/* codescanner.c generated by valac, the Vala compiler
 * generated from codescanner.vala, do not modify */

/* codescanner.vala
 *
 * Copyright (C) 2015       Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include "valadoc.h"
#include <valagee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>

enum  {
	VALADOC_HIGHLIGHTER_CODE_SCANNER_0_PROPERTY,
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUM_PROPERTIES
};
static GParamSpec* valadoc_highlighter_code_scanner_properties[VALADOC_HIGHLIGHTER_CODE_SCANNER_NUM_PROPERTIES];
typedef enum  {
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER,
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL,
	VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE
} ValadocHighlighterCodeScannerNumericType;

#define VALADOC_HIGHLIGHTER_CODE_SCANNER_TYPE_NUMERIC_TYPE (valadoc_highlighter_code_scanner_numeric_type_get_type ())
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHighlighterCodeScannerPrivate {
	ValaHashMap* keywords;
	gboolean enable_string_templates;
	gboolean enabel_verbatim_string;
	gboolean enable_preprocessor_define;
	gboolean enable_preprocessor_include;
	gboolean enable_keyword_escape;
	GQueue* token_queue;
	const gchar* content;
	const gchar* pos;
};

static gint ValadocHighlighterCodeScanner_private_offset;
static gpointer valadoc_highlighter_code_scanner_parent_class = NULL;
static ValadocHighlighterScannerIface * valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_parent_iface = NULL;

static GType valadoc_highlighter_code_scanner_numeric_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void _valadoc_highlighter_code_token_unref0_ (gpointer var);
static inline void _g_queue_free__valadoc_highlighter_code_token_unref0_ (GQueue* self);
static ValadocHighlighterCodeToken* valadoc_highlighter_code_scanner_real_next (ValadocHighlighterScanner* base);
static gboolean valadoc_highlighter_code_scanner_queue_c_include (ValadocHighlighterCodeScanner* self);
static ValadocHighlighterCodeToken* valadoc_highlighter_code_scanner_dispatch (ValadocHighlighterCodeScanner* self,
                                                                        const gchar* start,
                                                                        const gchar* end);
static void valadoc_highlighter_code_scanner_queue_until (ValadocHighlighterCodeScanner* self,
                                                   gchar end_char,
                                                   ValadocHighlighterCodeTokenType token_type);
static void valadoc_highlighter_code_scanner_queue_string_literal (ValadocHighlighterCodeScanner* self,
                                                            const gchar* end_chars);
static void valadoc_highlighter_code_scanner_queue_numeric_literal (ValadocHighlighterCodeScanner* self);
static void valadoc_highlighter_code_scanner_queue_multiline_comment (ValadocHighlighterCodeScanner* self);
static inline gboolean valadoc_highlighter_code_scanner_isidstartchar (ValadocHighlighterCodeScanner* self,
                                                         gchar c);
static gboolean valadoc_highlighter_code_scanner_queue_keyword (ValadocHighlighterCodeScanner* self);
static gchar* _g_ascii_dup (gchar* self);
static void valadoc_highlighter_code_scanner_queue_token (ValadocHighlighterCodeScanner* self,
                                                   const gchar* start,
                                                   const gchar* end,
                                                   ValadocHighlighterCodeTokenType token_type);
static gboolean _g_ascii_equal (const gchar * s1,
                         const gchar * s2);
static inline gboolean valadoc_highlighter_code_scanner_isidchar (ValadocHighlighterCodeScanner* self,
                                                    gchar c);
static gboolean valadoc_highlighter_code_scanner_has_printf_format_prefix (ValadocHighlighterCodeScanner* self,
                                                                    glong* skip);
static gboolean valadoc_highlighter_code_scanner_has_escape_prefix (ValadocHighlighterCodeScanner* self,
                                                             glong* skip);
static gboolean valadoc_highlighter_code_scanner_has_template_literal_prefix (ValadocHighlighterCodeScanner* self,
                                                                       glong* skip);
static void valadoc_highlighter_code_scanner_finalize (GObject * obj);

static inline gpointer
valadoc_highlighter_code_scanner_get_instance_private (ValadocHighlighterCodeScanner* self)
{
	return G_STRUCT_MEMBER_P (self, ValadocHighlighterCodeScanner_private_offset);
}

static GType
valadoc_highlighter_code_scanner_numeric_type_get_type (void)
{
	static volatile gsize valadoc_highlighter_code_scanner_numeric_type_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_highlighter_code_scanner_numeric_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER, "VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER", "integer"}, {VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL, "VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL", "real"}, {VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE, "VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE", "none"}, {0, NULL, NULL}};
		GType valadoc_highlighter_code_scanner_numeric_type_type_id;
		valadoc_highlighter_code_scanner_numeric_type_type_id = g_enum_register_static ("ValadocHighlighterCodeScannerNumericType", values);
		g_once_init_leave (&valadoc_highlighter_code_scanner_numeric_type_type_id__volatile, valadoc_highlighter_code_scanner_numeric_type_type_id);
	}
	return valadoc_highlighter_code_scanner_numeric_type_type_id__volatile;
}

static void
_valadoc_highlighter_code_token_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (valadoc_highlighter_code_token_unref (var), NULL));
}

static inline void
_g_queue_free__valadoc_highlighter_code_token_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _valadoc_highlighter_code_token_unref0_);
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

ValadocHighlighterCodeScanner*
valadoc_highlighter_code_scanner_construct (GType object_type,
                                            const gchar* content,
                                            gboolean enable_string_templates,
                                            gboolean enabel_verbatim_string,
                                            gboolean enable_preprocessor_define,
                                            gboolean enable_preprocessor_include,
                                            gboolean enable_keyword_escape,
                                            ValaHashMap* keywords)
{
	ValadocHighlighterCodeScanner * self = NULL;
	ValaHashMap* _tmp0_;
	g_return_val_if_fail (content != NULL, NULL);
	g_return_val_if_fail (keywords != NULL, NULL);
	self = (ValadocHighlighterCodeScanner*) g_object_new (object_type, NULL);
	self->priv->content = content;
	self->priv->pos = content;
	self->priv->enable_string_templates = enable_string_templates;
	self->priv->enabel_verbatim_string = enabel_verbatim_string;
	self->priv->enable_preprocessor_define = enable_preprocessor_define;
	self->priv->enable_preprocessor_include = enable_preprocessor_include;
	self->priv->enable_keyword_escape = enable_keyword_escape;
	_tmp0_ = _vala_map_ref0 (keywords);
	_vala_map_unref0 (self->priv->keywords);
	self->priv->keywords = _tmp0_;
	return self;
}

ValadocHighlighterCodeScanner*
valadoc_highlighter_code_scanner_new (const gchar* content,
                                      gboolean enable_string_templates,
                                      gboolean enabel_verbatim_string,
                                      gboolean enable_preprocessor_define,
                                      gboolean enable_preprocessor_include,
                                      gboolean enable_keyword_escape,
                                      ValaHashMap* keywords)
{
	return valadoc_highlighter_code_scanner_construct (VALADOC_HIGHLIGHTER_TYPE_CODE_SCANNER, content, enable_string_templates, enabel_verbatim_string, enable_preprocessor_define, enable_preprocessor_include, enable_keyword_escape, keywords);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}

static ValadocHighlighterCodeToken*
valadoc_highlighter_code_scanner_real_next (ValadocHighlighterScanner* base)
{
	ValadocHighlighterCodeScanner * self;
	ValadocHighlighterCodeToken* result = NULL;
	GQueue* _tmp0_;
	const gchar* start = NULL;
	GQueue* _tmp91_;
	ValadocHighlighterCodeToken* _tmp92_;
	const gchar* _tmp93_;
	const gchar* _tmp94_;
	ValadocHighlighterCodeToken* _tmp95_;
	self = (ValadocHighlighterCodeScanner*) base;
	_tmp0_ = self->priv->token_queue;
	if (!g_queue_is_empty (_tmp0_)) {
		GQueue* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->token_queue;
		_tmp2_ = g_queue_pop_head (_tmp1_);
		result = (ValadocHighlighterCodeToken*) _tmp2_;
		return result;
	}
	{
		const gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = self->priv->pos;
		start = _tmp3_;
		_tmp4_ = TRUE;
		while (TRUE) {
			const gchar* _tmp7_;
			gboolean _tmp8_ = FALSE;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			const gchar* _tmp44_;
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_;
			gboolean _tmp64_ = FALSE;
			const gchar* _tmp65_;
			const gchar* _tmp71_;
			const gchar* _tmp76_;
			gboolean _tmp81_ = FALSE;
			gboolean _tmp82_ = FALSE;
			const gchar* _tmp83_;
			const gchar* _tmp84_;
			if (!_tmp4_) {
				const gchar* _tmp5_;
				const gchar* _tmp6_;
				_tmp5_ = self->priv->pos;
				_tmp6_ = g_utf8_next_char (_tmp5_);
				self->priv->pos = _tmp6_;
			}
			_tmp4_ = FALSE;
			_tmp7_ = self->priv->pos;
			if (!(string_get (_tmp7_, (glong) 0) != '\0')) {
				break;
			}
			_tmp9_ = self->priv->pos;
			_tmp10_ = self->priv->content;
			if (((gchar*) _tmp9_) == ((gchar*) _tmp10_)) {
				_tmp8_ = TRUE;
			} else {
				const gchar* _tmp11_;
				_tmp11_ = self->priv->pos;
				_tmp8_ = string_get (_tmp11_, (glong) 0) == '\n';
			}
			if (_tmp8_) {
				const gchar* line_start = NULL;
				const gchar* _tmp12_;
				const gchar* _tmp20_;
				_tmp12_ = self->priv->pos;
				line_start = _tmp12_;
				while (TRUE) {
					gboolean _tmp13_ = FALSE;
					gboolean _tmp14_ = FALSE;
					const gchar* _tmp15_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					_tmp15_ = self->priv->pos;
					if (string_get (_tmp15_, (glong) 0) == ' ') {
						_tmp14_ = TRUE;
					} else {
						const gchar* _tmp16_;
						_tmp16_ = self->priv->pos;
						_tmp14_ = string_get (_tmp16_, (glong) 0) == '\t';
					}
					if (_tmp14_) {
						_tmp13_ = TRUE;
					} else {
						const gchar* _tmp17_;
						_tmp17_ = self->priv->pos;
						_tmp13_ = string_get (_tmp17_, (glong) 0) == '\n';
					}
					if (!_tmp13_) {
						break;
					}
					_tmp18_ = self->priv->pos;
					_tmp19_ = string_offset (_tmp18_, (glong) 1);
					self->priv->pos = _tmp19_;
				}
				_tmp20_ = self->priv->pos;
				if (string_get (_tmp20_, (glong) 0) == '\0') {
					break;
				} else {
					gboolean _tmp21_ = FALSE;
					if (self->priv->enable_preprocessor_include) {
						const gchar* _tmp22_;
						_tmp22_ = self->priv->pos;
						_tmp21_ = g_str_has_prefix (_tmp22_, "#include");
					} else {
						_tmp21_ = FALSE;
					}
					if (_tmp21_) {
						const gchar* end = NULL;
						const gchar* _tmp23_;
						_tmp23_ = self->priv->pos;
						end = _tmp23_;
						if (valadoc_highlighter_code_scanner_queue_c_include (self)) {
							const gchar* _tmp24_;
							const gchar* _tmp25_;
							ValadocHighlighterCodeToken* _tmp26_;
							_tmp24_ = start;
							_tmp25_ = end;
							_tmp26_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp24_, _tmp25_);
							result = _tmp26_;
							return result;
						} else {
							const gchar* _tmp27_;
							_tmp27_ = line_start;
							self->priv->pos = _tmp27_;
							continue;
						}
					} else {
						gboolean _tmp28_ = FALSE;
						gboolean _tmp29_ = FALSE;
						gboolean _tmp30_ = FALSE;
						gboolean _tmp31_ = FALSE;
						const gchar* _tmp32_;
						_tmp32_ = self->priv->pos;
						if (g_str_has_prefix (_tmp32_, "#if")) {
							_tmp31_ = TRUE;
						} else {
							const gchar* _tmp33_;
							_tmp33_ = self->priv->pos;
							_tmp31_ = g_str_has_prefix (_tmp33_, "#else");
						}
						if (_tmp31_) {
							_tmp30_ = TRUE;
						} else {
							const gchar* _tmp34_;
							_tmp34_ = self->priv->pos;
							_tmp30_ = g_str_has_prefix (_tmp34_, "#elif");
						}
						if (_tmp30_) {
							_tmp29_ = TRUE;
						} else {
							const gchar* _tmp35_;
							_tmp35_ = self->priv->pos;
							_tmp29_ = g_str_has_prefix (_tmp35_, "#endif");
						}
						if (_tmp29_) {
							_tmp28_ = TRUE;
						} else {
							gboolean _tmp36_ = FALSE;
							if (self->priv->enable_preprocessor_define) {
								gboolean _tmp37_ = FALSE;
								const gchar* _tmp38_;
								_tmp38_ = self->priv->pos;
								if (g_str_has_prefix (_tmp38_, "#defined")) {
									_tmp37_ = TRUE;
								} else {
									const gchar* _tmp39_;
									_tmp39_ = self->priv->pos;
									_tmp37_ = g_str_has_prefix (_tmp39_, "#ifdef");
								}
								_tmp36_ = _tmp37_;
							} else {
								_tmp36_ = FALSE;
							}
							_tmp28_ = _tmp36_;
						}
						if (_tmp28_) {
							const gchar* end = NULL;
							const gchar* _tmp40_;
							const gchar* _tmp41_;
							const gchar* _tmp42_;
							ValadocHighlighterCodeToken* _tmp43_;
							_tmp40_ = self->priv->pos;
							end = _tmp40_;
							valadoc_highlighter_code_scanner_queue_until (self, '\n', VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PREPROCESSOR);
							_tmp41_ = start;
							_tmp42_ = end;
							_tmp43_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp41_, _tmp42_);
							result = _tmp43_;
							return result;
						}
					}
				}
			}
			_tmp44_ = self->priv->pos;
			if (string_get (_tmp44_, (glong) 0) == '\'') {
				const gchar* end = NULL;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				ValadocHighlighterCodeToken* _tmp48_;
				_tmp45_ = self->priv->pos;
				end = _tmp45_;
				valadoc_highlighter_code_scanner_queue_string_literal (self, "\'");
				_tmp46_ = start;
				_tmp47_ = end;
				_tmp48_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp46_, _tmp47_);
				result = _tmp48_;
				return result;
			}
			_tmp50_ = self->priv->pos;
			if (string_get (_tmp50_, (glong) 0) == '"') {
				_tmp49_ = TRUE;
			} else {
				gboolean _tmp51_ = FALSE;
				gboolean _tmp52_ = FALSE;
				if (self->priv->enable_string_templates) {
					const gchar* _tmp53_;
					_tmp53_ = self->priv->pos;
					_tmp52_ = string_get (_tmp53_, (glong) 0) == '@';
				} else {
					_tmp52_ = FALSE;
				}
				if (_tmp52_) {
					const gchar* _tmp54_;
					_tmp54_ = self->priv->pos;
					_tmp51_ = string_get (_tmp54_, (glong) 1) == '"';
				} else {
					_tmp51_ = FALSE;
				}
				_tmp49_ = _tmp51_;
			}
			if (_tmp49_) {
				const gchar* end = NULL;
				const gchar* _tmp55_;
				gboolean _tmp56_ = FALSE;
				const gchar* _tmp61_;
				const gchar* _tmp62_;
				ValadocHighlighterCodeToken* _tmp63_;
				_tmp55_ = self->priv->pos;
				end = _tmp55_;
				if (self->priv->enabel_verbatim_string) {
					gboolean _tmp57_ = FALSE;
					const gchar* _tmp58_;
					_tmp58_ = self->priv->pos;
					if (g_str_has_prefix (_tmp58_, "\"\"\"")) {
						_tmp57_ = TRUE;
					} else {
						gboolean _tmp59_ = FALSE;
						if (self->priv->enable_string_templates) {
							const gchar* _tmp60_;
							_tmp60_ = self->priv->pos;
							_tmp59_ = g_str_has_prefix (_tmp60_, "@\"\"\"");
						} else {
							_tmp59_ = FALSE;
						}
						_tmp57_ = _tmp59_;
					}
					_tmp56_ = _tmp57_;
				} else {
					_tmp56_ = FALSE;
				}
				if (_tmp56_) {
					valadoc_highlighter_code_scanner_queue_string_literal (self, "\"\"\"");
				} else {
					valadoc_highlighter_code_scanner_queue_string_literal (self, "\"");
				}
				_tmp61_ = start;
				_tmp62_ = end;
				_tmp63_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp61_, _tmp62_);
				result = _tmp63_;
				return result;
			}
			_tmp65_ = self->priv->pos;
			if (string_get (_tmp65_, (glong) 0) >= '0') {
				const gchar* _tmp66_;
				_tmp66_ = self->priv->pos;
				_tmp64_ = string_get (_tmp66_, (glong) 0) <= '9';
			} else {
				_tmp64_ = FALSE;
			}
			if (_tmp64_) {
				const gchar* end = NULL;
				const gchar* _tmp67_;
				const gchar* _tmp68_;
				const gchar* _tmp69_;
				ValadocHighlighterCodeToken* _tmp70_;
				_tmp67_ = self->priv->pos;
				end = _tmp67_;
				valadoc_highlighter_code_scanner_queue_numeric_literal (self);
				_tmp68_ = start;
				_tmp69_ = end;
				_tmp70_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp68_, _tmp69_);
				result = _tmp70_;
				return result;
			}
			_tmp71_ = self->priv->pos;
			if (g_str_has_prefix (_tmp71_, "/*")) {
				const gchar* end = NULL;
				const gchar* _tmp72_;
				const gchar* _tmp73_;
				const gchar* _tmp74_;
				ValadocHighlighterCodeToken* _tmp75_;
				_tmp72_ = self->priv->pos;
				end = _tmp72_;
				valadoc_highlighter_code_scanner_queue_multiline_comment (self);
				_tmp73_ = start;
				_tmp74_ = end;
				_tmp75_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp73_, _tmp74_);
				result = _tmp75_;
				return result;
			}
			_tmp76_ = self->priv->pos;
			if (g_str_has_prefix (_tmp76_, "//")) {
				const gchar* end = NULL;
				const gchar* _tmp77_;
				const gchar* _tmp78_;
				const gchar* _tmp79_;
				ValadocHighlighterCodeToken* _tmp80_;
				_tmp77_ = self->priv->pos;
				end = _tmp77_;
				valadoc_highlighter_code_scanner_queue_until (self, '\n', VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_COMMENT);
				_tmp78_ = start;
				_tmp79_ = end;
				_tmp80_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp78_, _tmp79_);
				result = _tmp80_;
				return result;
			}
			_tmp83_ = self->priv->pos;
			_tmp84_ = self->priv->content;
			if (((gchar*) _tmp83_) == ((gchar*) _tmp84_)) {
				_tmp82_ = TRUE;
			} else {
				const gchar* _tmp85_;
				_tmp85_ = self->priv->pos;
				_tmp82_ = !valadoc_highlighter_code_scanner_isidstartchar (self, string_get (_tmp85_, (glong) -1));
			}
			if (_tmp82_) {
				const gchar* _tmp86_;
				_tmp86_ = self->priv->pos;
				_tmp81_ = valadoc_highlighter_code_scanner_isidstartchar (self, string_get (_tmp86_, (glong) 0));
			} else {
				_tmp81_ = FALSE;
			}
			if (_tmp81_) {
				const gchar* end = NULL;
				const gchar* _tmp87_;
				_tmp87_ = self->priv->pos;
				end = _tmp87_;
				if (valadoc_highlighter_code_scanner_queue_keyword (self)) {
					const gchar* _tmp88_;
					const gchar* _tmp89_;
					ValadocHighlighterCodeToken* _tmp90_;
					_tmp88_ = start;
					_tmp89_ = end;
					_tmp90_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp88_, _tmp89_);
					result = _tmp90_;
					return result;
				} else {
					continue;
				}
			}
		}
	}
	_tmp91_ = self->priv->token_queue;
	_tmp92_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_EOF, "");
	g_queue_push_tail (_tmp91_, _tmp92_);
	_tmp93_ = start;
	_tmp94_ = self->priv->pos;
	_tmp95_ = valadoc_highlighter_code_scanner_dispatch (self, _tmp93_, _tmp94_);
	result = _tmp95_;
	return result;
}

static gchar*
_g_ascii_dup (gchar* self)
{
	gchar* dup;
	dup = g_new0 (gchar, 1);
	memcpy (dup, self, sizeof (gchar));
	return dup;
}

static gpointer
__g_ascii_dup0 (gpointer self)
{
	return self ? _g_ascii_dup (self) : NULL;
}

static gboolean
_g_ascii_equal (const gchar * s1,
                const gchar * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gboolean
valadoc_highlighter_code_scanner_queue_c_include (ValadocHighlighterCodeScanner* self)
{
	gboolean result = FALSE;
	const gchar* include_start = NULL;
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* end_char = NULL;
	const gchar* _tmp9_;
	gchar* _tmp15_;
	gboolean _tmp45_ = FALSE;
	const gchar* _tmp46_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	include_start = _tmp0_;
	_tmp1_ = self->priv->pos;
	start = _tmp1_;
	_tmp2_ = self->priv->pos;
	_tmp3_ = string_offset (_tmp2_, (glong) 8);
	self->priv->pos = _tmp3_;
	while (TRUE) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		_tmp5_ = self->priv->pos;
		if (string_get (_tmp5_, (glong) 0) == ' ') {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->pos;
			_tmp4_ = string_get (_tmp6_, (glong) 0) == '\t';
		}
		if (!_tmp4_) {
			break;
		}
		_tmp7_ = self->priv->pos;
		_tmp8_ = string_offset (_tmp7_, (glong) 1);
		self->priv->pos = _tmp8_;
	}
	end_char = NULL;
	_tmp9_ = self->priv->pos;
	if (string_get (_tmp9_, (glong) 0) == '"') {
		gchar _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = '"';
		_tmp11_ = __g_ascii_dup0 (&_tmp10_);
		_g_free0 (end_char);
		end_char = _tmp11_;
	} else {
		const gchar* _tmp12_;
		_tmp12_ = self->priv->pos;
		if (string_get (_tmp12_, (glong) 0) == '<') {
			gchar _tmp13_;
			gchar* _tmp14_;
			_tmp13_ = '>';
			_tmp14_ = __g_ascii_dup0 (&_tmp13_);
			_g_free0 (end_char);
			end_char = _tmp14_;
		}
	}
	_tmp15_ = end_char;
	if (_tmp15_ != NULL) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* literal_start = NULL;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp30_;
		gchar _tmp31_;
		gchar* _tmp32_;
		_tmp16_ = start;
		_tmp17_ = self->priv->pos;
		valadoc_highlighter_code_scanner_queue_token (self, _tmp16_, _tmp17_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PREPROCESSOR);
		_tmp18_ = self->priv->pos;
		literal_start = _tmp18_;
		_tmp19_ = self->priv->pos;
		_tmp20_ = string_offset (_tmp19_, (glong) 1);
		self->priv->pos = _tmp20_;
		while (TRUE) {
			gboolean _tmp21_ = FALSE;
			gboolean _tmp22_ = FALSE;
			const gchar* _tmp23_;
			gchar _tmp24_;
			gchar* _tmp25_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp23_ = self->priv->pos;
			_tmp24_ = string_get (_tmp23_, (glong) 0);
			_tmp25_ = end_char;
			if (_g_ascii_equal (&_tmp24_, _tmp25_) != TRUE) {
				const gchar* _tmp26_;
				_tmp26_ = self->priv->pos;
				_tmp22_ = string_get (_tmp26_, (glong) 0) != '\n';
			} else {
				_tmp22_ = FALSE;
			}
			if (_tmp22_) {
				const gchar* _tmp27_;
				_tmp27_ = self->priv->pos;
				_tmp21_ = string_get (_tmp27_, (glong) 0) != '\0';
			} else {
				_tmp21_ = FALSE;
			}
			if (!_tmp21_) {
				break;
			}
			_tmp28_ = self->priv->pos;
			_tmp29_ = string_offset (_tmp28_, (glong) 1);
			self->priv->pos = _tmp29_;
		}
		_tmp30_ = self->priv->pos;
		_tmp31_ = string_get (_tmp30_, (glong) 0);
		_tmp32_ = end_char;
		if (_g_ascii_equal (&_tmp31_, _tmp32_) == TRUE) {
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp33_ = self->priv->pos;
			_tmp34_ = string_offset (_tmp33_, (glong) 1);
			self->priv->pos = _tmp34_;
			_tmp35_ = literal_start;
			_tmp36_ = self->priv->pos;
			valadoc_highlighter_code_scanner_queue_token (self, _tmp35_, _tmp36_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL);
			_tmp37_ = self->priv->pos;
			start = _tmp37_;
		} else {
			const gchar* _tmp38_;
			GQueue* _tmp39_;
			_tmp38_ = include_start;
			self->priv->pos = _tmp38_;
			_tmp39_ = self->priv->token_queue;
			g_queue_clear (_tmp39_);
			result = FALSE;
			_g_free0 (end_char);
			return result;
		}
	}
	while (TRUE) {
		gboolean _tmp40_ = FALSE;
		const gchar* _tmp41_;
		const gchar* _tmp43_;
		const gchar* _tmp44_;
		_tmp41_ = self->priv->pos;
		if (string_get (_tmp41_, (glong) 0) == ' ') {
			_tmp40_ = TRUE;
		} else {
			const gchar* _tmp42_;
			_tmp42_ = self->priv->pos;
			_tmp40_ = string_get (_tmp42_, (glong) 0) == '\t';
		}
		if (!_tmp40_) {
			break;
		}
		_tmp43_ = self->priv->pos;
		_tmp44_ = string_offset (_tmp43_, (glong) 1);
		self->priv->pos = _tmp44_;
	}
	_tmp46_ = self->priv->pos;
	if (string_get (_tmp46_, (glong) 0) == '\n') {
		_tmp45_ = TRUE;
	} else {
		const gchar* _tmp47_;
		_tmp47_ = self->priv->pos;
		_tmp45_ = string_get (_tmp47_, (glong) 0) == '\0';
	}
	if (_tmp45_) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		_tmp48_ = start;
		_tmp49_ = self->priv->pos;
		valadoc_highlighter_code_scanner_queue_token (self, _tmp48_, _tmp49_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PREPROCESSOR);
		result = TRUE;
		_g_free0 (end_char);
		return result;
	} else {
		const gchar* _tmp50_;
		GQueue* _tmp51_;
		_tmp50_ = include_start;
		self->priv->pos = _tmp50_;
		_tmp51_ = self->priv->token_queue;
		g_queue_clear (_tmp51_);
		result = FALSE;
		_g_free0 (end_char);
		return result;
	}
	_g_free0 (end_char);
}

static glong
string_pointer_to_offset (const gchar* self,
                          const gchar* pos)
{
	glong result = 0L;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (pos != NULL, 0L);
	result = (glong) (((gchar*) pos) - ((gchar*) self));
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gboolean
valadoc_highlighter_code_scanner_queue_keyword (ValadocHighlighterCodeScanner* self)
{
	gboolean result = FALSE;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	glong length = 0L;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* word = NULL;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	ValadocHighlighterCodeTokenType* token_type = NULL;
	ValaHashMap* _tmp11_;
	const gchar* _tmp12_;
	gpointer _tmp13_;
	ValadocHighlighterCodeTokenType* _tmp14_;
	GQueue* _tmp16_;
	ValadocHighlighterCodeTokenType* _tmp17_;
	const gchar* _tmp18_;
	ValadocHighlighterCodeToken* _tmp19_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	if (string_get (_tmp1_, (glong) 0) == '@') {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->pos;
		_tmp3_ = string_offset (_tmp2_, (glong) 1);
		self->priv->pos = _tmp3_;
	}
	while (TRUE) {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp4_ = self->priv->pos;
		if (!valadoc_highlighter_code_scanner_isidchar (self, string_get (_tmp4_, (glong) 0))) {
			break;
		}
		_tmp5_ = self->priv->pos;
		_tmp6_ = string_offset (_tmp5_, (glong) 1);
		self->priv->pos = _tmp6_;
	}
	_tmp7_ = start;
	_tmp8_ = self->priv->pos;
	length = string_pointer_to_offset (_tmp7_, _tmp8_);
	_tmp9_ = start;
	_tmp10_ = string_substring (_tmp9_, (glong) 0, length);
	word = _tmp10_;
	_tmp11_ = self->priv->keywords;
	_tmp12_ = word;
	_tmp13_ = vala_map_get ((ValaMap*) _tmp11_, _tmp12_);
	token_type = (ValadocHighlighterCodeTokenType*) _tmp13_;
	_tmp14_ = token_type;
	if (_tmp14_ == NULL) {
		const gchar* _tmp15_;
		_tmp15_ = start;
		self->priv->pos = _tmp15_;
		result = FALSE;
		_g_free0 (token_type);
		_g_free0 (word);
		return result;
	}
	_tmp16_ = self->priv->token_queue;
	_tmp17_ = token_type;
	_tmp18_ = word;
	_tmp19_ = valadoc_highlighter_code_token_new (*_tmp17_, _tmp18_);
	g_queue_push_tail (_tmp16_, _tmp19_);
	result = TRUE;
	_g_free0 (token_type);
	_g_free0 (word);
	return result;
}

static void
valadoc_highlighter_code_scanner_queue_multiline_comment (ValadocHighlighterCodeScanner* self)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 2);
	self->priv->pos = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp5_ = self->priv->pos;
		if (string_get (_tmp5_, (glong) 0) == '*') {
			const gchar* _tmp6_;
			_tmp6_ = self->priv->pos;
			_tmp4_ = string_get (_tmp6_, (glong) 1) == '/';
		} else {
			_tmp4_ = FALSE;
		}
		if (!_tmp4_) {
			const gchar* _tmp7_;
			_tmp7_ = self->priv->pos;
			_tmp3_ = string_get (_tmp7_, (glong) 0) != '\0';
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp8_ = self->priv->pos;
		_tmp9_ = string_offset (_tmp8_, (glong) 1);
		self->priv->pos = _tmp9_;
	}
	_tmp10_ = self->priv->pos;
	if (string_get (_tmp10_, (glong) 0) != '\0') {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = self->priv->pos;
		_tmp12_ = string_offset (_tmp11_, (glong) 2);
		self->priv->pos = _tmp12_;
	}
	_tmp13_ = start;
	_tmp14_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp13_, _tmp14_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_COMMENT);
}

static void
valadoc_highlighter_code_scanner_queue_until (ValadocHighlighterCodeScanner* self,
                                              gchar end_char,
                                              ValadocHighlighterCodeTokenType token_type)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp1_ = self->priv->pos;
	_tmp2_ = string_offset (_tmp1_, (glong) 1);
	self->priv->pos = _tmp2_;
	while (TRUE) {
		gboolean _tmp3_ = FALSE;
		const gchar* _tmp4_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->pos;
		if (string_get (_tmp4_, (glong) 0) != end_char) {
			const gchar* _tmp5_;
			_tmp5_ = self->priv->pos;
			_tmp3_ = string_get (_tmp5_, (glong) 0) != '\0';
		} else {
			_tmp3_ = FALSE;
		}
		if (!_tmp3_) {
			break;
		}
		_tmp6_ = self->priv->pos;
		_tmp7_ = string_offset (_tmp6_, (glong) 1);
		self->priv->pos = _tmp7_;
	}
	_tmp9_ = self->priv->pos;
	if (string_get (_tmp9_, (glong) 0) != '\0') {
		const gchar* _tmp10_;
		_tmp10_ = self->priv->pos;
		_tmp8_ = string_get (_tmp10_, (glong) 0) != '\n';
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = self->priv->pos;
		_tmp12_ = string_offset (_tmp11_, (glong) 1);
		self->priv->pos = _tmp12_;
	}
	_tmp13_ = start;
	_tmp14_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp13_, _tmp14_, token_type);
}

static void
valadoc_highlighter_code_scanner_queue_string_literal (ValadocHighlighterCodeScanner* self,
                                                       const gchar* end_chars)
{
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gboolean is_template = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp38_;
	const gchar* _tmp43_;
	const gchar* _tmp44_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (end_chars != NULL);
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	is_template = FALSE;
	_tmp1_ = self->priv->pos;
	if (string_get (_tmp1_, (glong) 0) == '@') {
		const gchar* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->pos;
		_tmp3_ = strlen (end_chars);
		_tmp4_ = _tmp3_;
		_tmp5_ = string_offset (_tmp2_, (glong) (_tmp4_ + 1));
		self->priv->pos = _tmp5_;
		is_template = TRUE;
	} else {
		const gchar* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		const gchar* _tmp9_;
		_tmp6_ = self->priv->pos;
		_tmp7_ = strlen (end_chars);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_offset (_tmp6_, (glong) _tmp8_);
		self->priv->pos = _tmp9_;
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_;
		glong skip = 0L;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		const gchar* _tmp16_;
		_tmp11_ = self->priv->pos;
		if (!g_str_has_prefix (_tmp11_, end_chars)) {
			const gchar* _tmp12_;
			_tmp12_ = self->priv->pos;
			_tmp10_ = string_get (_tmp12_, (glong) 0) != '\0';
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		skip = (glong) 0;
		_tmp16_ = self->priv->pos;
		if (string_get (_tmp16_, (glong) 0) == '%') {
			glong _tmp17_ = 0L;
			gboolean _tmp18_;
			_tmp18_ = valadoc_highlighter_code_scanner_has_printf_format_prefix (self, &_tmp17_);
			skip = _tmp17_;
			_tmp15_ = _tmp18_;
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			_tmp14_ = TRUE;
		} else {
			gboolean _tmp19_ = FALSE;
			const gchar* _tmp20_;
			_tmp20_ = self->priv->pos;
			if (string_get (_tmp20_, (glong) 0) == '\\') {
				glong _tmp21_ = 0L;
				gboolean _tmp22_;
				_tmp22_ = valadoc_highlighter_code_scanner_has_escape_prefix (self, &_tmp21_);
				skip = _tmp21_;
				_tmp19_ = _tmp22_;
			} else {
				_tmp19_ = FALSE;
			}
			_tmp14_ = _tmp19_;
		}
		if (_tmp14_) {
			_tmp13_ = TRUE;
		} else {
			gboolean _tmp23_ = FALSE;
			gboolean _tmp24_ = FALSE;
			if (is_template) {
				const gchar* _tmp25_;
				_tmp25_ = self->priv->pos;
				_tmp24_ = string_get (_tmp25_, (glong) 0) == '$';
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				glong _tmp26_ = 0L;
				gboolean _tmp27_;
				_tmp27_ = valadoc_highlighter_code_scanner_has_template_literal_prefix (self, &_tmp26_);
				skip = _tmp26_;
				_tmp23_ = _tmp27_;
			} else {
				_tmp23_ = FALSE;
			}
			_tmp13_ = _tmp23_;
		}
		if (_tmp13_) {
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			const gchar* sub_start = NULL;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			_tmp28_ = start;
			_tmp29_ = self->priv->pos;
			valadoc_highlighter_code_scanner_queue_token (self, _tmp28_, _tmp29_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL);
			_tmp30_ = self->priv->pos;
			sub_start = _tmp30_;
			_tmp31_ = self->priv->pos;
			_tmp32_ = string_offset (_tmp31_, skip);
			self->priv->pos = _tmp32_;
			_tmp33_ = sub_start;
			_tmp34_ = self->priv->pos;
			valadoc_highlighter_code_scanner_queue_token (self, _tmp33_, _tmp34_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_ESCAPE);
			_tmp35_ = self->priv->pos;
			start = _tmp35_;
		} else {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp36_ = self->priv->pos;
			_tmp37_ = string_offset (_tmp36_, (glong) 1);
			self->priv->pos = _tmp37_;
		}
	}
	_tmp38_ = self->priv->pos;
	if (string_get (_tmp38_, (glong) 0) != '\0') {
		const gchar* _tmp39_;
		gint _tmp40_;
		gint _tmp41_;
		const gchar* _tmp42_;
		_tmp39_ = self->priv->pos;
		_tmp40_ = strlen (end_chars);
		_tmp41_ = _tmp40_;
		_tmp42_ = string_offset (_tmp39_, (glong) _tmp41_);
		self->priv->pos = _tmp42_;
	}
	_tmp43_ = start;
	_tmp44_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp43_, _tmp44_, VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL);
}

static gboolean
valadoc_highlighter_code_scanner_has_template_literal_prefix (ValadocHighlighterCodeScanner* self,
                                                              glong* skip)
{
	glong _vala_skip = 0L;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	const gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	if (valadoc_highlighter_code_scanner_isidchar (self, string_get (_tmp0_, (glong) 1))) {
		_vala_skip = (glong) 1;
		while (TRUE) {
			const gchar* _tmp1_;
			glong _tmp2_;
			_tmp1_ = self->priv->pos;
			if (!valadoc_highlighter_code_scanner_isidchar (self, string_get (_tmp1_, _vala_skip))) {
				break;
			}
			_tmp2_ = _vala_skip;
			_vala_skip = _tmp2_ + 1;
		}
		result = TRUE;
		if (skip) {
			*skip = _vala_skip;
		}
		return result;
	}
	_tmp3_ = self->priv->pos;
	if (string_get (_tmp3_, (glong) 1) == '(') {
		gint level = 0;
		level = 1;
		_vala_skip = (glong) 2;
		while (TRUE) {
			const gchar* _tmp4_;
			glong _tmp7_;
			if (!(level > 0)) {
				break;
			}
			_tmp4_ = self->priv->pos;
			switch (string_get (_tmp4_, _vala_skip)) {
				case '(':
				{
					gint _tmp5_;
					_tmp5_ = level;
					level = _tmp5_ + 1;
					break;
				}
				case ')':
				{
					gint _tmp6_;
					_tmp6_ = level;
					level = _tmp6_ - 1;
					break;
				}
				case '\0':
				{
					_vala_skip = (glong) 0;
					result = FALSE;
					if (skip) {
						*skip = _vala_skip;
					}
					return result;
				}
				default:
				break;
			}
			_tmp7_ = _vala_skip;
			_vala_skip = _tmp7_ + 1;
		}
		result = TRUE;
		if (skip) {
			*skip = _vala_skip;
		}
		return result;
	}
	_vala_skip = (glong) 0;
	result = FALSE;
	if (skip) {
		*skip = _vala_skip;
	}
	return result;
}

static gboolean
valadoc_highlighter_code_scanner_has_escape_prefix (ValadocHighlighterCodeScanner* self,
                                                    glong* skip)
{
	glong _vala_skip = 0L;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	switch (string_get (_tmp0_, (glong) 1)) {
		case 'a':
		case 'b':
		case 'f':
		case 'n':
		case 'r':
		case 't':
		case 'v':
		case '\\':
		case '\'':
		case '\"':
		case '?':
		{
			_vala_skip = (glong) 2;
			result = TRUE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
		case 'x':
		{
			const gchar* _tmp1_;
			_tmp1_ = self->priv->pos;
			if (g_ascii_isxdigit (string_get (_tmp1_, (glong) 2))) {
				glong _tmp6_;
				{
					gboolean _tmp2_ = FALSE;
					_vala_skip = (glong) 2;
					_tmp2_ = TRUE;
					while (TRUE) {
						const gchar* _tmp4_;
						glong _tmp5_;
						if (!_tmp2_) {
							glong _tmp3_;
							_tmp3_ = _vala_skip;
							_vala_skip = _tmp3_ + 1;
						}
						_tmp2_ = FALSE;
						_tmp4_ = self->priv->pos;
						if (!g_ascii_isxdigit (string_get (_tmp4_, _vala_skip))) {
							break;
						}
						_tmp5_ = _vala_skip;
						_vala_skip = _tmp5_ + 1;
					}
				}
				_tmp6_ = _vala_skip;
				_vala_skip = _tmp6_ + 1;
				result = TRUE;
				if (skip) {
					*skip = _vala_skip;
				}
				return result;
			}
			_vala_skip = (glong) 0;
			result = FALSE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
		default:
		{
			const gchar* _tmp7_;
			_tmp7_ = self->priv->pos;
			if (g_ascii_isdigit (string_get (_tmp7_, (glong) 1))) {
				const gchar* _tmp8_;
				_vala_skip = (glong) 2;
				_tmp8_ = self->priv->pos;
				if (g_ascii_isdigit (string_get (_tmp8_, (glong) 2))) {
					glong _tmp9_;
					const gchar* _tmp10_;
					_tmp9_ = _vala_skip;
					_vala_skip = _tmp9_ + 1;
					_tmp10_ = self->priv->pos;
					if (g_ascii_isdigit (string_get (_tmp10_, (glong) 3))) {
						glong _tmp11_;
						_tmp11_ = _vala_skip;
						_vala_skip = _tmp11_ + 1;
					}
				}
				result = TRUE;
				if (skip) {
					*skip = _vala_skip;
				}
				return result;
			}
			_vala_skip = (glong) 0;
			result = FALSE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
	}
	if (skip) {
		*skip = _vala_skip;
	}
}

static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static gboolean
valadoc_highlighter_code_scanner_has_printf_format_prefix (ValadocHighlighterCodeScanner* self,
                                                           glong* skip)
{
	glong _vala_skip = 0L;
	gboolean result = FALSE;
	const gchar* pos = NULL;
	const gchar* _tmp0_;
	const gchar* start = NULL;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	const gchar* _tmp21_;
	const gchar* _tmp34_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->pos;
	pos = _tmp0_;
	_tmp1_ = pos;
	start = _tmp1_;
	_tmp2_ = pos;
	_tmp3_ = string_offset (_tmp2_, (glong) 1);
	pos = _tmp3_;
	_tmp4_ = pos;
	if (string_get (_tmp4_, (glong) 0) == '%') {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = pos;
		_tmp6_ = string_offset (_tmp5_, (glong) 1);
		pos = _tmp6_;
		_vala_skip = (glong) 2;
		result = TRUE;
		if (skip) {
			*skip = _vala_skip;
		}
		return result;
	}
	while (TRUE) {
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		_tmp7_ = pos;
		if (!(string_index_of_char ("#0+- ", (gunichar) string_get (_tmp7_, (glong) 0), 0) > 0)) {
			break;
		}
		_tmp8_ = pos;
		_tmp9_ = string_offset (_tmp8_, (glong) 1);
		pos = _tmp9_;
	}
	while (TRUE) {
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp10_ = pos;
		if (!g_ascii_isdigit (string_get (_tmp10_, (glong) 0))) {
			break;
		}
		_tmp11_ = pos;
		_tmp12_ = string_offset (_tmp11_, (glong) 1);
		pos = _tmp12_;
	}
	_tmp14_ = pos;
	if (string_get (_tmp14_, (glong) 0) == '.') {
		const gchar* _tmp15_;
		_tmp15_ = pos;
		_tmp13_ = g_ascii_isdigit (string_get (_tmp15_, (glong) 1));
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		_tmp16_ = pos;
		_tmp17_ = string_offset (_tmp16_, (glong) 2);
		pos = _tmp17_;
		while (TRUE) {
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = pos;
			if (!g_ascii_isdigit (string_get (_tmp18_, (glong) 0))) {
				break;
			}
			_tmp19_ = pos;
			_tmp20_ = string_offset (_tmp19_, (glong) 1);
			pos = _tmp20_;
		}
	}
	_tmp21_ = pos;
	switch (string_get (_tmp21_, (glong) 0)) {
		case 'h':
		{
			const gchar* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			_tmp22_ = pos;
			_tmp23_ = string_offset (_tmp22_, (glong) 1);
			pos = _tmp23_;
			_tmp24_ = pos;
			if (string_get (_tmp24_, (glong) 0) == 'h') {
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp25_ = pos;
				_tmp26_ = string_offset (_tmp25_, (glong) 1);
				pos = _tmp26_;
			}
			break;
		}
		case 'l':
		{
			const gchar* _tmp27_;
			const gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp27_ = pos;
			_tmp28_ = string_offset (_tmp27_, (glong) 1);
			pos = _tmp28_;
			_tmp29_ = pos;
			if (string_get (_tmp29_, (glong) 0) == 'l') {
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				_tmp30_ = pos;
				_tmp31_ = string_offset (_tmp30_, (glong) 1);
				pos = _tmp31_;
			}
			break;
		}
		case 'j':
		case 'z':
		case 't':
		case 'L':
		{
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp32_ = pos;
			_tmp33_ = string_offset (_tmp32_, (glong) 1);
			pos = _tmp33_;
			break;
		}
		default:
		break;
	}
	_tmp34_ = pos;
	switch (string_get (_tmp34_, (glong) 0)) {
		case 'd':
		case 'i':
		case 'u':
		case 'o':
		case 'x':
		case 'X':
		case 'f':
		case 'F':
		case 'e':
		case 'E':
		case 'g':
		case 'G':
		case 'a':
		case 'A':
		case 'c':
		case 's':
		case 'p':
		case 'n':
		{
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp35_ = pos;
			_tmp36_ = string_offset (_tmp35_, (glong) 1);
			pos = _tmp36_;
			break;
		}
		default:
		{
			_vala_skip = (glong) 0;
			result = FALSE;
			if (skip) {
				*skip = _vala_skip;
			}
			return result;
		}
	}
	_tmp37_ = start;
	_tmp38_ = pos;
	_vala_skip = string_pointer_to_offset (_tmp37_, _tmp38_);
	result = TRUE;
	if (skip) {
		*skip = _vala_skip;
	}
	return result;
}

static void
valadoc_highlighter_code_scanner_queue_numeric_literal (ValadocHighlighterCodeScanner* self)
{
	ValadocHighlighterCodeScannerNumericType numeric_type = 0;
	const gchar* start = NULL;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp22_ = FALSE;
	const gchar* _tmp23_;
	const gchar* _tmp35_;
	const gchar* _tmp59_;
	ValadocHighlighterCodeTokenType _tmp60_ = 0;
	ValadocHighlighterCodeScannerNumericType _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp63_;
	g_return_if_fail (self != NULL);
	numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER;
	_tmp0_ = self->priv->pos;
	start = _tmp0_;
	_tmp3_ = self->priv->pos;
	if (string_get (_tmp3_, (glong) 0) == '0') {
		const gchar* _tmp4_;
		_tmp4_ = self->priv->pos;
		_tmp2_ = string_get (_tmp4_, (glong) 1) == 'x';
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		const gchar* _tmp5_;
		_tmp5_ = self->priv->pos;
		_tmp1_ = g_ascii_isxdigit (string_get (_tmp5_, (glong) 2));
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp6_ = self->priv->pos;
		_tmp7_ = string_offset (_tmp6_, (glong) 2);
		self->priv->pos = _tmp7_;
		while (TRUE) {
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp8_ = self->priv->pos;
			if (!g_ascii_isxdigit (string_get (_tmp8_, (glong) 0))) {
				break;
			}
			_tmp9_ = self->priv->pos;
			_tmp10_ = string_offset (_tmp9_, (glong) 1);
			self->priv->pos = _tmp10_;
		}
	} else {
		while (TRUE) {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			_tmp11_ = self->priv->pos;
			if (!g_ascii_isdigit (string_get (_tmp11_, (glong) 0))) {
				break;
			}
			_tmp12_ = self->priv->pos;
			_tmp13_ = string_offset (_tmp12_, (glong) 1);
			self->priv->pos = _tmp13_;
		}
	}
	_tmp15_ = self->priv->pos;
	if (string_get (_tmp15_, (glong) 0) == '.') {
		const gchar* _tmp16_;
		_tmp16_ = self->priv->pos;
		_tmp14_ = g_ascii_isdigit (string_get (_tmp16_, (glong) 1));
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL;
		_tmp17_ = self->priv->pos;
		_tmp18_ = string_offset (_tmp17_, (glong) 1);
		self->priv->pos = _tmp18_;
		while (TRUE) {
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			const gchar* _tmp21_;
			_tmp19_ = self->priv->pos;
			if (!g_ascii_isdigit (string_get (_tmp19_, (glong) 0))) {
				break;
			}
			_tmp20_ = self->priv->pos;
			_tmp21_ = string_offset (_tmp20_, (glong) 1);
			self->priv->pos = _tmp21_;
		}
	}
	_tmp23_ = self->priv->pos;
	if (string_get (_tmp23_, (glong) 0) == 'e') {
		_tmp22_ = TRUE;
	} else {
		const gchar* _tmp24_;
		_tmp24_ = self->priv->pos;
		_tmp22_ = string_get (_tmp24_, (glong) 0) == 'E';
	}
	if (_tmp22_) {
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		gboolean _tmp27_ = FALSE;
		const gchar* _tmp28_;
		numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL;
		_tmp25_ = self->priv->pos;
		_tmp26_ = string_offset (_tmp25_, (glong) 1);
		self->priv->pos = _tmp26_;
		_tmp28_ = self->priv->pos;
		if (string_get (_tmp28_, (glong) 0) == '+') {
			_tmp27_ = TRUE;
		} else {
			const gchar* _tmp29_;
			_tmp29_ = self->priv->pos;
			_tmp27_ = string_get (_tmp29_, (glong) 0) == '-';
		}
		if (_tmp27_) {
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			_tmp30_ = self->priv->pos;
			_tmp31_ = string_offset (_tmp30_, (glong) 1);
			self->priv->pos = _tmp31_;
		}
		while (TRUE) {
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			const gchar* _tmp34_;
			_tmp32_ = self->priv->pos;
			if (!g_ascii_isdigit (string_get (_tmp32_, (glong) 0))) {
				break;
			}
			_tmp33_ = self->priv->pos;
			_tmp34_ = string_offset (_tmp33_, (glong) 1);
			self->priv->pos = _tmp34_;
		}
	}
	_tmp35_ = self->priv->pos;
	switch (string_get (_tmp35_, (glong) 0)) {
		case 'l':
		case 'L':
		{
			ValadocHighlighterCodeScannerNumericType _tmp36_;
			_tmp36_ = numeric_type;
			if (_tmp36_ == VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER) {
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gboolean _tmp39_ = FALSE;
				const gchar* _tmp40_;
				_tmp37_ = self->priv->pos;
				_tmp38_ = string_offset (_tmp37_, (glong) 1);
				self->priv->pos = _tmp38_;
				_tmp40_ = self->priv->pos;
				if (string_get (_tmp40_, (glong) 0) == 'l') {
					_tmp39_ = TRUE;
				} else {
					const gchar* _tmp41_;
					_tmp41_ = self->priv->pos;
					_tmp39_ = string_get (_tmp41_, (glong) 0) == 'L';
				}
				if (_tmp39_) {
					const gchar* _tmp42_;
					const gchar* _tmp43_;
					_tmp42_ = self->priv->pos;
					_tmp43_ = string_offset (_tmp42_, (glong) 1);
					self->priv->pos = _tmp43_;
				}
			}
			break;
		}
		case 'u':
		case 'U':
		{
			ValadocHighlighterCodeScannerNumericType _tmp44_;
			_tmp44_ = numeric_type;
			if (_tmp44_ == VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_INTEGER) {
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				gboolean _tmp47_ = FALSE;
				const gchar* _tmp48_;
				_tmp45_ = self->priv->pos;
				_tmp46_ = string_offset (_tmp45_, (glong) 1);
				self->priv->pos = _tmp46_;
				_tmp48_ = self->priv->pos;
				if (string_get (_tmp48_, (glong) 0) == 'l') {
					_tmp47_ = TRUE;
				} else {
					const gchar* _tmp49_;
					_tmp49_ = self->priv->pos;
					_tmp47_ = string_get (_tmp49_, (glong) 0) == 'L';
				}
				if (_tmp47_) {
					const gchar* _tmp50_;
					const gchar* _tmp51_;
					gboolean _tmp52_ = FALSE;
					const gchar* _tmp53_;
					_tmp50_ = self->priv->pos;
					_tmp51_ = string_offset (_tmp50_, (glong) 1);
					self->priv->pos = _tmp51_;
					_tmp53_ = self->priv->pos;
					if (string_get (_tmp53_, (glong) 0) == 'l') {
						_tmp52_ = TRUE;
					} else {
						const gchar* _tmp54_;
						_tmp54_ = self->priv->pos;
						_tmp52_ = string_get (_tmp54_, (glong) 0) == 'L';
					}
					if (_tmp52_) {
						const gchar* _tmp55_;
						const gchar* _tmp56_;
						_tmp55_ = self->priv->pos;
						_tmp56_ = string_offset (_tmp55_, (glong) 1);
						self->priv->pos = _tmp56_;
					}
				}
			}
			break;
		}
		case 'f':
		case 'F':
		case 'd':
		case 'D':
		{
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_REAL;
			_tmp57_ = self->priv->pos;
			_tmp58_ = string_offset (_tmp57_, (glong) 1);
			self->priv->pos = _tmp58_;
			break;
		}
		default:
		break;
	}
	_tmp59_ = self->priv->pos;
	if (g_ascii_isalnum (string_get (_tmp59_, (glong) 0))) {
		numeric_type = VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE;
	}
	_tmp61_ = numeric_type;
	if (_tmp61_ != VALADOC_HIGHLIGHTER_CODE_SCANNER_NUMERIC_TYPE_NONE) {
		_tmp60_ = VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_LITERAL;
	} else {
		_tmp60_ = VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PLAIN;
	}
	_tmp62_ = start;
	_tmp63_ = self->priv->pos;
	valadoc_highlighter_code_scanner_queue_token (self, _tmp62_, _tmp63_, _tmp60_);
}

static ValadocHighlighterCodeToken*
valadoc_highlighter_code_scanner_dispatch (ValadocHighlighterCodeScanner* self,
                                           const gchar* start,
                                           const gchar* end)
{
	ValadocHighlighterCodeToken* result = NULL;
	GQueue* _tmp0_;
	glong length = 0L;
	gchar* content = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValadocHighlighterCodeToken* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (start != NULL, NULL);
	g_return_val_if_fail (end != NULL, NULL);
	_tmp0_ = self->priv->token_queue;
	_vala_assert (g_queue_is_empty (_tmp0_) == FALSE, "token_queue.is_empty () == false");
	if (((gchar*) start) == ((gchar*) end)) {
		GQueue* _tmp1_;
		gpointer _tmp2_;
		_tmp1_ = self->priv->token_queue;
		_tmp2_ = g_queue_pop_head (_tmp1_);
		result = (ValadocHighlighterCodeToken*) _tmp2_;
		return result;
	}
	length = string_pointer_to_offset (start, end);
	_tmp3_ = string_substring (start, (glong) 0, length);
	content = _tmp3_;
	_tmp4_ = content;
	_tmp5_ = valadoc_highlighter_code_token_new (VALADOC_HIGHLIGHTER_CODE_TOKEN_TYPE_PLAIN, _tmp4_);
	result = _tmp5_;
	_g_free0 (content);
	return result;
}

static void
valadoc_highlighter_code_scanner_queue_token (ValadocHighlighterCodeScanner* self,
                                              const gchar* start,
                                              const gchar* end,
                                              ValadocHighlighterCodeTokenType token_type)
{
	glong length = 0L;
	gchar* content = NULL;
	gchar* _tmp0_;
	GQueue* _tmp1_;
	ValadocHighlighterCodeToken* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	length = string_pointer_to_offset (start, end);
	_tmp0_ = string_substring (start, (glong) 0, length);
	content = _tmp0_;
	_tmp1_ = self->priv->token_queue;
	_tmp2_ = valadoc_highlighter_code_token_new (token_type, content);
	g_queue_push_tail (_tmp1_, _tmp2_);
	_g_free0 (content);
}

static inline gboolean
valadoc_highlighter_code_scanner_isidchar (ValadocHighlighterCodeScanner* self,
                                           gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = c == '_';
	}
	result = _tmp0_;
	return result;
}

static inline gboolean
valadoc_highlighter_code_scanner_isidstartchar (ValadocHighlighterCodeScanner* self,
                                                gchar c)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (g_ascii_isalnum (c)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = c == '_';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if (c == '@') {
			_tmp2_ = self->priv->enable_keyword_escape;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	result = _tmp0_;
	return result;
}

static void
valadoc_highlighter_code_scanner_class_init (ValadocHighlighterCodeScannerClass * klass,
                                             gpointer klass_data)
{
	valadoc_highlighter_code_scanner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ValadocHighlighterCodeScanner_private_offset);
	G_OBJECT_CLASS (klass)->finalize = valadoc_highlighter_code_scanner_finalize;
}

static void
valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_interface_init (ValadocHighlighterScannerIface * iface,
                                                                             gpointer iface_data)
{
	valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = (ValadocHighlighterCodeToken* (*) (ValadocHighlighterScanner*)) valadoc_highlighter_code_scanner_real_next;
}

static void
valadoc_highlighter_code_scanner_instance_init (ValadocHighlighterCodeScanner * self,
                                                gpointer klass)
{
	GQueue* _tmp0_;
	self->priv = valadoc_highlighter_code_scanner_get_instance_private (self);
	_tmp0_ = g_queue_new ();
	self->priv->token_queue = _tmp0_;
}

static void
valadoc_highlighter_code_scanner_finalize (GObject * obj)
{
	ValadocHighlighterCodeScanner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HIGHLIGHTER_TYPE_CODE_SCANNER, ValadocHighlighterCodeScanner);
	_vala_map_unref0 (self->priv->keywords);
	(self->priv->token_queue == NULL) ? NULL : (self->priv->token_queue = (_g_queue_free__valadoc_highlighter_code_token_unref0_ (self->priv->token_queue), NULL));
	G_OBJECT_CLASS (valadoc_highlighter_code_scanner_parent_class)->finalize (obj);
}

/**
 * A cheap scanner used to highlight C and Vala source code.
 */
GType
valadoc_highlighter_code_scanner_get_type (void)
{
	static volatile gsize valadoc_highlighter_code_scanner_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_highlighter_code_scanner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHighlighterCodeScannerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_highlighter_code_scanner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHighlighterCodeScanner), 0, (GInstanceInitFunc) valadoc_highlighter_code_scanner_instance_init, NULL };
		static const GInterfaceInfo valadoc_highlighter_scanner_info = { (GInterfaceInitFunc) valadoc_highlighter_code_scanner_valadoc_highlighter_scanner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_highlighter_code_scanner_type_id;
		valadoc_highlighter_code_scanner_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocHighlighterCodeScanner", &g_define_type_info, 0);
		g_type_add_interface_static (valadoc_highlighter_code_scanner_type_id, VALADOC_HIGHLIGHTER_TYPE_SCANNER, &valadoc_highlighter_scanner_info);
		ValadocHighlighterCodeScanner_private_offset = g_type_add_instance_private (valadoc_highlighter_code_scanner_type_id, sizeof (ValadocHighlighterCodeScannerPrivate));
		g_once_init_leave (&valadoc_highlighter_code_scanner_type_id__volatile, valadoc_highlighter_code_scanner_type_id);
	}
	return valadoc_highlighter_code_scanner_type_id__volatile;
}

