/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "vala.h"
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};

static gint ValaMethod_private_offset;
static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_method_real_get_error_types (ValaCodeNode* base,
                                       ValaCollection* collection,
                                       ValaSourceReference* source_reference);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);

static inline gpointer
vala_method_get_instance_private (ValaMethod* self)
{
	return G_STRUCT_MEMBER_P (self, ValaMethod_private_offset);
}

/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}

ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}

/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}

static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}

static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp15_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				ValaScope* _tmp10_;
				ValaScope* _tmp11_;
				ValaParameter* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				_tmp12_ = param;
				_tmp13_ = vala_symbol_get_name ((ValaSymbol*) _tmp12_);
				_tmp14_ = _tmp13_;
				vala_scope_remove (_tmp11_, _tmp14_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp15_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp15_);
}

gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			ValaParameter* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp7_ = param;
			_tmp8_ = vala_parameter_get_ellipsis (_tmp7_);
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}

static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaList* _tmp23_;
	ValaLocalVariable* _tmp32_;
	ValaLocalVariable* _tmp33_;
	ValaList* _tmp36_;
	ValaList* _tmp45_;
	ValaBlock* _tmp54_;
	ValaBlock* _tmp55_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			ValaTypeParameter* p = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaTypeParameter* _tmp6_;
			_p_index = _p_index + 1;
			if (!(_p_index < _p_size)) {
				break;
			}
			_tmp4_ = _p_list;
			_tmp5_ = vala_list_get (_tmp4_, _p_index);
			p = (ValaTypeParameter*) _tmp5_;
			_tmp6_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp7_ = vala_method_get_base_interface_type (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		_tmp9_ = vala_method_get_base_interface_type (self);
		_tmp10_ = _tmp9_;
		vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
	}
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp13_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp15_;
		ValaList* _tmp16_;
		gint _param_size = 0;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _param_index = 0;
		_tmp15_ = self->priv->parameters;
		_tmp16_ = _vala_iterable_ref0 (_tmp15_);
		_param_list = _tmp16_;
		_tmp17_ = _param_list;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_param_size = _tmp19_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp20_;
			gpointer _tmp21_;
			ValaParameter* _tmp22_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp20_ = _param_list;
			_tmp21_ = vala_list_get (_tmp20_, _param_index);
			param = (ValaParameter*) _tmp21_;
			_tmp22_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp23_ = self->error_types;
	if (_tmp23_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp24_;
			ValaList* _tmp25_;
			gint _error_type_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _error_type_index = 0;
			_tmp24_ = self->error_types;
			_tmp25_ = _vala_iterable_ref0 (_tmp24_);
			_error_type_list = _tmp25_;
			_tmp26_ = _error_type_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_error_type_size = _tmp28_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp29_;
				gpointer _tmp30_;
				ValaDataType* _tmp31_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp29_ = _error_type_list;
				_tmp30_ = vala_list_get (_tmp29_, _error_type_index);
				error_type = (ValaDataType*) _tmp30_;
				_tmp31_ = error_type;
				vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp32_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaLocalVariable* _tmp34_;
		ValaLocalVariable* _tmp35_;
		_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp35_ = _tmp34_;
		vala_code_node_accept ((ValaCodeNode*) _tmp35_, visitor);
	}
	_tmp36_ = self->priv->preconditions;
	if (_tmp36_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp37_;
			ValaList* _tmp38_;
			gint _precondition_size = 0;
			ValaList* _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			gint _precondition_index = 0;
			_tmp37_ = self->priv->preconditions;
			_tmp38_ = _vala_iterable_ref0 (_tmp37_);
			_precondition_list = _tmp38_;
			_tmp39_ = _precondition_list;
			_tmp40_ = vala_collection_get_size ((ValaCollection*) _tmp39_);
			_tmp41_ = _tmp40_;
			_precondition_size = _tmp41_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp42_;
				gpointer _tmp43_;
				ValaExpression* _tmp44_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp42_ = _precondition_list;
				_tmp43_ = vala_list_get (_tmp42_, _precondition_index);
				precondition = (ValaExpression*) _tmp43_;
				_tmp44_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp45_ = self->priv->postconditions;
	if (_tmp45_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp46_;
			ValaList* _tmp47_;
			gint _postcondition_size = 0;
			ValaList* _tmp48_;
			gint _tmp49_;
			gint _tmp50_;
			gint _postcondition_index = 0;
			_tmp46_ = self->priv->postconditions;
			_tmp47_ = _vala_iterable_ref0 (_tmp46_);
			_postcondition_list = _tmp47_;
			_tmp48_ = _postcondition_list;
			_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
			_tmp50_ = _tmp49_;
			_postcondition_size = _tmp50_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp51_;
				gpointer _tmp52_;
				ValaExpression* _tmp53_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp51_ = _postcondition_list;
				_tmp52_ = vala_list_get (_tmp51_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp52_;
				_tmp53_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp53_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp54_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp55_ = _tmp54_;
	if (_tmp55_ != NULL) {
		ValaBlock* _tmp56_;
		ValaBlock* _tmp57_;
		_tmp56_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp57_ = _tmp56_;
		vala_code_node_accept ((ValaCodeNode*) _tmp57_, visitor);
	}
}

/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	gboolean _tmp30_;
	ValaList* method_type_args = NULL;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp55_;
	ValaDataType* _tmp56_;
	ValaObjectType* _tmp57_;
	ValaList* _tmp58_;
	ValaDataType* _tmp59_;
	ValaDataType* _tmp60_;
	ValaDataType* _tmp61_;
	ValaDataType* _tmp62_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp71_;
	ValaIterator* _tmp72_;
	gint param_index = 0;
	ValaIterator* _tmp113_;
	ValaArrayList* base_method_errors = NULL;
	GEqualFunc _tmp115_;
	ValaArrayList* _tmp116_;
	ValaArrayList* _tmp117_;
	ValaList* _tmp118_;
	gboolean _tmp139_;
	gboolean _tmp140_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_OBJECT_TYPE_SYMBOL)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp15_;
				gpointer _tmp16_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp17_;
				ValaGenericType* _tmp18_;
				ValaGenericType* _tmp19_;
				ValaObjectType* _tmp20_;
				ValaGenericType* _tmp21_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp15_ = _type_parameter_list;
				_tmp16_ = vala_list_get (_tmp15_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp16_;
				_tmp17_ = type_parameter;
				_tmp18_ = vala_generic_type_new (_tmp17_);
				type_arg = _tmp18_;
				_tmp19_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp19_, TRUE);
				_tmp20_ = object_type;
				_tmp21_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp20_, (ValaDataType*) _tmp21_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp22_ = vala_method_get_type_parameters (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_method_get_type_parameters (base_method);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = _tmp25_ < _tmp29_;
	_vala_iterable_unref0 (_tmp27_);
	_vala_iterable_unref0 (_tmp23_);
	if (_tmp30_) {
		gchar* _tmp31_;
		_tmp31_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp31_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp32_;
		ValaList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		ValaList* _tmp36_;
		ValaList* _tmp37_;
		gint _tmp38_;
		gint _tmp39_;
		gboolean _tmp40_;
		_tmp32_ = vala_method_get_type_parameters (self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_method_get_type_parameters (base_method);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_collection_get_size ((ValaCollection*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp35_ > _tmp39_;
		_vala_iterable_unref0 (_tmp37_);
		_vala_iterable_unref0 (_tmp33_);
		if (_tmp40_) {
			gchar* _tmp41_;
			_tmp41_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp41_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	if (vala_method_has_type_parameters (self)) {
		GEqualFunc _tmp42_;
		ValaArrayList* _tmp43_;
		_tmp42_ = g_direct_equal;
		_tmp43_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp42_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp43_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp44_;
			gint _type_parameter_size = 0;
			ValaList* _tmp45_;
			gint _tmp46_;
			gint _tmp47_;
			gint _type_parameter_index = 0;
			_tmp44_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp44_;
			_tmp45_ = _type_parameter_list;
			_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
			_tmp47_ = _tmp46_;
			_type_parameter_size = _tmp47_;
			_type_parameter_index = -1;
			while (TRUE) {
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp48_;
				gpointer _tmp49_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp50_;
				ValaGenericType* _tmp51_;
				ValaGenericType* _tmp52_;
				ValaList* _tmp53_;
				ValaGenericType* _tmp54_;
				_type_parameter_index = _type_parameter_index + 1;
				if (!(_type_parameter_index < _type_parameter_size)) {
					break;
				}
				_tmp48_ = _type_parameter_list;
				_tmp49_ = vala_list_get (_tmp48_, _type_parameter_index);
				type_parameter = (ValaTypeParameter*) _tmp49_;
				_tmp50_ = type_parameter;
				_tmp51_ = vala_generic_type_new (_tmp50_);
				type_arg = _tmp51_;
				_tmp52_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp52_, TRUE);
				_tmp53_ = method_type_args;
				_tmp54_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp53_, (ValaDataType*) _tmp54_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp55_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp56_ = _tmp55_;
	_tmp57_ = object_type;
	_tmp58_ = method_type_args;
	_tmp59_ = vala_data_type_get_actual_type (_tmp56_, (ValaDataType*) _tmp57_, _tmp58_, (ValaCodeNode*) self);
	actual_base_type = _tmp59_;
	_tmp60_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp61_ = _tmp60_;
	_tmp62_ = actual_base_type;
	if (!vala_data_type_equals (_tmp61_, _tmp62_)) {
		ValaDataType* _tmp63_;
		gchar* _tmp64_;
		gchar* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		gchar* _tmp68_;
		gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp63_ = actual_base_type;
		_tmp64_ = vala_data_type_to_prototype_string (_tmp63_, NULL);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_data_type_to_prototype_string (_tmp67_, NULL);
		_tmp69_ = _tmp68_;
		_tmp70_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp65_, _tmp69_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp70_;
		_g_free0 (_tmp69_);
		_g_free0 (_tmp65_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp71_ = self->priv->parameters;
	_tmp72_ = vala_iterable_iterator ((ValaIterable*) _tmp71_);
	method_params_it = _tmp72_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp73_;
		ValaList* _tmp74_;
		gint _base_param_size = 0;
		ValaList* _tmp75_;
		gint _tmp76_;
		gint _tmp77_;
		gint _base_param_index = 0;
		_tmp73_ = base_method->priv->parameters;
		_tmp74_ = _vala_iterable_ref0 (_tmp73_);
		_base_param_list = _tmp74_;
		_tmp75_ = _base_param_list;
		_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
		_tmp77_ = _tmp76_;
		_base_param_size = _tmp77_;
		_base_param_index = -1;
		while (TRUE) {
			ValaParameter* base_param = NULL;
			ValaList* _tmp78_;
			gpointer _tmp79_;
			ValaIterator* _tmp80_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp82_;
			gpointer _tmp83_;
			ValaParameter* _tmp84_;
			gboolean _tmp85_;
			gboolean _tmp86_;
			ValaParameter* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			ValaParameter* _tmp91_;
			gboolean _tmp92_;
			gboolean _tmp93_;
			gint _tmp112_;
			_base_param_index = _base_param_index + 1;
			if (!(_base_param_index < _base_param_size)) {
				break;
			}
			_tmp78_ = _base_param_list;
			_tmp79_ = vala_list_get (_tmp78_, _base_param_index);
			base_param = (ValaParameter*) _tmp79_;
			_tmp80_ = method_params_it;
			if (!vala_iterator_next (_tmp80_)) {
				gchar* _tmp81_;
				_tmp81_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp81_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp82_ = method_params_it;
			_tmp83_ = vala_iterator_get (_tmp82_);
			param = (ValaParameter*) _tmp83_;
			_tmp84_ = base_param;
			_tmp85_ = vala_parameter_get_ellipsis (_tmp84_);
			_tmp86_ = _tmp85_;
			_tmp87_ = param;
			_tmp88_ = vala_parameter_get_ellipsis (_tmp87_);
			_tmp89_ = _tmp88_;
			if (_tmp86_ != _tmp89_) {
				gchar* _tmp90_;
				_tmp90_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp90_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp91_ = base_param;
			_tmp92_ = vala_parameter_get_ellipsis (_tmp91_);
			_tmp93_ = _tmp92_;
			if (!_tmp93_) {
				ValaParameter* _tmp94_;
				ValaParameterDirection _tmp95_;
				ValaParameterDirection _tmp96_;
				ValaParameter* _tmp97_;
				ValaParameterDirection _tmp98_;
				ValaParameterDirection _tmp99_;
				ValaParameter* _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaObjectType* _tmp104_;
				ValaList* _tmp105_;
				ValaDataType* _tmp106_;
				ValaDataType* _tmp107_;
				ValaParameter* _tmp108_;
				ValaDataType* _tmp109_;
				ValaDataType* _tmp110_;
				_tmp94_ = base_param;
				_tmp95_ = vala_parameter_get_direction (_tmp94_);
				_tmp96_ = _tmp95_;
				_tmp97_ = param;
				_tmp98_ = vala_parameter_get_direction (_tmp97_);
				_tmp99_ = _tmp98_;
				if (_tmp96_ != _tmp99_) {
					gchar* _tmp100_;
					_tmp100_ = g_strdup_printf ("incompatible direction of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp100_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp101_ = base_param;
				_tmp102_ = vala_variable_get_variable_type ((ValaVariable*) _tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = object_type;
				_tmp105_ = method_type_args;
				_tmp106_ = vala_data_type_get_actual_type (_tmp103_, (ValaDataType*) _tmp104_, _tmp105_, (ValaCodeNode*) self);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp106_;
				_tmp107_ = actual_base_type;
				_tmp108_ = param;
				_tmp109_ = vala_variable_get_variable_type ((ValaVariable*) _tmp108_);
				_tmp110_ = _tmp109_;
				if (!vala_data_type_equals (_tmp107_, _tmp110_)) {
					gchar* _tmp111_;
					_tmp111_ = g_strdup_printf ("incompatible type of parameter %d", param_index);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp111_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp112_ = param_index;
			param_index = _tmp112_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp113_ = method_params_it;
	if (vala_iterator_next (_tmp113_)) {
		gchar* _tmp114_;
		_tmp114_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp114_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp115_ = g_direct_equal;
	_tmp116_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp115_);
	base_method_errors = _tmp116_;
	_tmp117_ = base_method_errors;
	vala_code_node_get_error_types ((ValaCodeNode*) base_method, (ValaCollection*) _tmp117_, NULL);
	_tmp118_ = self->error_types;
	if (_tmp118_ != NULL) {
		{
			ValaList* _method_error_type_list = NULL;
			ValaList* _tmp119_;
			ValaList* _tmp120_;
			gint _method_error_type_size = 0;
			ValaList* _tmp121_;
			gint _tmp122_;
			gint _tmp123_;
			gint _method_error_type_index = 0;
			_tmp119_ = self->error_types;
			_tmp120_ = _vala_iterable_ref0 (_tmp119_);
			_method_error_type_list = _tmp120_;
			_tmp121_ = _method_error_type_list;
			_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
			_tmp123_ = _tmp122_;
			_method_error_type_size = _tmp123_;
			_method_error_type_index = -1;
			while (TRUE) {
				ValaDataType* method_error_type = NULL;
				ValaList* _tmp124_;
				gpointer _tmp125_;
				gboolean match = FALSE;
				_method_error_type_index = _method_error_type_index + 1;
				if (!(_method_error_type_index < _method_error_type_size)) {
					break;
				}
				_tmp124_ = _method_error_type_list;
				_tmp125_ = vala_list_get (_tmp124_, _method_error_type_index);
				method_error_type = (ValaDataType*) _tmp125_;
				match = FALSE;
				{
					ValaArrayList* _base_method_error_type_list = NULL;
					ValaArrayList* _tmp126_;
					ValaArrayList* _tmp127_;
					gint _base_method_error_type_size = 0;
					ValaArrayList* _tmp128_;
					gint _tmp129_;
					gint _tmp130_;
					gint _base_method_error_type_index = 0;
					_tmp126_ = base_method_errors;
					_tmp127_ = _vala_iterable_ref0 (_tmp126_);
					_base_method_error_type_list = _tmp127_;
					_tmp128_ = _base_method_error_type_list;
					_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
					_tmp130_ = _tmp129_;
					_base_method_error_type_size = _tmp130_;
					_base_method_error_type_index = -1;
					while (TRUE) {
						ValaDataType* base_method_error_type = NULL;
						ValaArrayList* _tmp131_;
						gpointer _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						_base_method_error_type_index = _base_method_error_type_index + 1;
						if (!(_base_method_error_type_index < _base_method_error_type_size)) {
							break;
						}
						_tmp131_ = _base_method_error_type_list;
						_tmp132_ = vala_list_get ((ValaList*) _tmp131_, _base_method_error_type_index);
						base_method_error_type = (ValaDataType*) _tmp132_;
						_tmp133_ = method_error_type;
						_tmp134_ = base_method_error_type;
						if (vala_data_type_compatible (_tmp133_, _tmp134_)) {
							match = TRUE;
							_vala_code_node_unref0 (base_method_error_type);
							break;
						}
						_vala_code_node_unref0 (base_method_error_type);
					}
					_vala_iterable_unref0 (_base_method_error_type_list);
				}
				if (!match) {
					ValaDataType* _tmp135_;
					gchar* _tmp136_;
					gchar* _tmp137_;
					gchar* _tmp138_;
					_tmp135_ = method_error_type;
					_tmp136_ = vala_code_node_to_string ((ValaCodeNode*) _tmp135_);
					_tmp137_ = _tmp136_;
					_tmp138_ = g_strdup_printf ("incompatible error type `%s'", _tmp137_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp138_;
					_g_free0 (_tmp137_);
					result = FALSE;
					_vala_code_node_unref0 (method_error_type);
					_vala_iterable_unref0 (_method_error_type_list);
					_vala_iterable_unref0 (base_method_errors);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_vala_code_node_unref0 (method_error_type);
			}
			_vala_iterable_unref0 (_method_error_type_list);
		}
	}
	_tmp139_ = base_method->priv->_coroutine;
	_tmp140_ = self->priv->_coroutine;
	if (_tmp139_ != _tmp140_) {
		gchar* _tmp141_;
		_tmp141_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp141_;
		result = FALSE;
		_vala_iterable_unref0 (base_method_errors);
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterable_unref0 (base_method_errors);
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}

/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}

/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	gint result = 0;
	ValaList* _tmp0_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp6_;
			gpointer _tmp7_;
			ValaTypeParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			gint _tmp11_;
			_parameter_index = _parameter_index + 1;
			if (!(_parameter_index < _parameter_size)) {
				break;
			}
			_tmp6_ = _parameter_list;
			_tmp7_ = vala_list_get (_tmp6_, _parameter_index);
			parameter = (ValaTypeParameter*) _tmp7_;
			_tmp8_ = parameter;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (g_strcmp0 (_tmp10_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp11_ = i;
			i = _tmp11_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_type_parameters (ValaMethod* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->priv->type_parameters;
	if (_tmp1_ != NULL) {
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		_tmp2_ = self->priv->type_parameters;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}

/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}

/**
 * Adds an error type to the exceptions that can be
 * thrown by this method.
 */
void
vala_method_add_error_type (ValaMethod* self,
                            ValaDataType* error_type)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (error_type != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->error_types);
		self->error_types = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->error_types;
	vala_collection_add ((ValaCollection*) _tmp3_, error_type);
	vala_code_node_set_parent_node ((ValaCodeNode*) error_type, (ValaCodeNode*) self);
}

static void
vala_method_real_get_error_types (ValaCodeNode* base,
                                  ValaCollection* collection,
                                  ValaSourceReference* source_reference)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->error_types;
	if (_tmp0_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _error_type_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _error_type_index = 0;
			_tmp1_ = self->error_types;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_error_type_list = _tmp2_;
			_tmp3_ = _error_type_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_error_type_size = _tmp5_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp6_ = _error_type_list;
				_tmp7_ = vala_list_get (_tmp6_, _error_type_index);
				error_type = (ValaDataType*) _tmp7_;
				if (source_reference != NULL) {
					ValaDataType* type = NULL;
					ValaDataType* _tmp8_;
					ValaDataType* _tmp9_;
					ValaDataType* _tmp10_;
					ValaDataType* _tmp11_;
					_tmp8_ = error_type;
					_tmp9_ = vala_data_type_copy (_tmp8_);
					type = _tmp9_;
					_tmp10_ = type;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp10_, source_reference);
					_tmp11_ = type;
					vala_collection_add (collection, _tmp11_);
					_vala_code_node_unref0 (type);
				} else {
					ValaDataType* _tmp12_;
					_tmp12_ = error_type;
					vala_collection_add (collection, _tmp12_);
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
}

static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = self->error_types;
	if (_tmp4_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					ValaList* _tmp7_;
					gint _tmp8_;
					gint _tmp9_;
					ValaList* _tmp10_;
					gpointer _tmp11_;
					ValaDataType* _tmp12_;
					gboolean _tmp13_;
					if (!_tmp5_) {
						gint _tmp6_;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = self->error_types;
					_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
					_tmp9_ = _tmp8_;
					if (!(i < _tmp9_)) {
						break;
					}
					_tmp10_ = self->error_types;
					_tmp11_ = vala_list_get (_tmp10_, i);
					_tmp12_ = (ValaDataType*) _tmp11_;
					_tmp13_ = _tmp12_ == old_type;
					_vala_code_node_unref0 (_tmp12_);
					if (_tmp13_) {
						ValaList* _tmp14_;
						_tmp14_ = self->error_types;
						vala_list_set (_tmp14_, i, new_type);
						return;
					}
				}
			}
		}
	}
}

static void
vala_method_find_base_methods (ValaMethod* self)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	g_return_if_fail (self != NULL);
	if (self->priv->base_methods_valid) {
		return;
	}
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS)) {
		if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
			ValaSymbol* _tmp2_;
			ValaSymbol* _tmp3_;
			gboolean _tmp4_ = FALSE;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_;
			_tmp2_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp3_ = _tmp2_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_CLASS, ValaClass));
			_tmp6_ = self->priv->_is_virtual;
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp7_;
				_tmp7_ = self->priv->_is_abstract;
				_tmp5_ = _tmp7_;
			}
			if (_tmp5_) {
				_tmp4_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_overrides;
				_tmp4_ = _tmp8_;
			}
			if (_tmp4_) {
				ValaSymbol* _tmp9_;
				ValaSymbol* _tmp10_;
				_tmp9_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp10_ = _tmp9_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp12_ = _tmp11_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			if (_tmp14_) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = self->priv->_is_abstract;
				_tmp13_ = _tmp15_;
			}
			if (_tmp13_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp37_;
	ValaClass* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_SIGNAL)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_METHOD)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_tmp36_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp36_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp37_ = vala_class_get_base_class (cl);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaClass* _tmp39_;
		ValaClass* _tmp40_;
		_tmp39_ = vala_class_get_base_class (cl);
		_tmp40_ = _tmp39_;
		vala_method_find_base_class_method (self, _tmp40_);
	}
	_vala_code_node_unref0 (sym);
}

static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			ValaDataType* type = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaDataType* _tmp6_;
			ValaTypeSymbol* _tmp7_;
			ValaTypeSymbol* _tmp8_;
			_type_index = _type_index + 1;
			if (!(_type_index < _type_size)) {
				break;
			}
			_tmp4_ = _type_list;
			_tmp5_ = vala_list_get (_tmp4_, _type_index);
			type = (ValaDataType*) _tmp5_;
			_tmp6_ = type;
			_tmp7_ = vala_data_type_get_data_type (_tmp6_);
			_tmp8_ = _tmp7_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_INTERFACE)) {
				gboolean _tmp9_ = FALSE;
				ValaDataType* _tmp10_;
				ValaDataType* _tmp11_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaScope* _tmp22_;
				ValaScope* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp34_;
				_tmp10_ = vala_method_get_base_interface_type (self);
				_tmp11_ = _tmp10_;
				if (_tmp11_ != NULL) {
					ValaDataType* _tmp12_;
					ValaDataType* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					ValaTypeSymbol* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					_tmp12_ = vala_method_get_base_interface_type (self);
					_tmp13_ = _tmp12_;
					_tmp14_ = vala_data_type_get_data_type (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = type;
					_tmp17_ = vala_data_type_get_data_type (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp9_ = _tmp15_ != _tmp18_;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp19_ = type;
				_tmp20_ = vala_data_type_get_data_type (_tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_scope_lookup (_tmp23_, _tmp25_);
				sym = _tmp26_;
				_tmp27_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_SIGNAL)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp28_;
					ValaSignal* _tmp29_;
					ValaSignal* _tmp30_;
					ValaMethod* _tmp31_;
					ValaMethod* _tmp32_;
					ValaSymbol* _tmp33_;
					_tmp28_ = sym;
					_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp29_;
					_tmp30_ = sig;
					_tmp31_ = vala_signal_get_default_handler (_tmp30_);
					_tmp32_ = _tmp31_;
					_tmp33_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp32_);
					_vala_code_node_unref0 (sym);
					sym = _tmp33_;
					_vala_code_node_unref0 (sig);
				}
				_tmp34_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_METHOD)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp35_;
					ValaMethod* _tmp36_;
					gboolean _tmp37_ = FALSE;
					ValaMethod* _tmp38_;
					gboolean _tmp39_;
					_tmp35_ = sym;
					_tmp36_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp36_;
					_tmp38_ = base_method;
					_tmp39_ = _tmp38_->priv->_is_abstract;
					if (_tmp39_) {
						_tmp37_ = TRUE;
					} else {
						ValaMethod* _tmp40_;
						gboolean _tmp41_;
						_tmp40_ = base_method;
						_tmp41_ = _tmp40_->priv->_is_virtual;
						_tmp37_ = _tmp41_;
					}
					if (_tmp37_) {
						ValaDataType* _tmp42_;
						ValaDataType* _tmp43_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp58_;
						gchar* _tmp59_ = NULL;
						gboolean _tmp60_;
						ValaMethod* _tmp73_;
						ValaMethod* _tmp74_;
						_tmp42_ = vala_method_get_base_interface_type (self);
						_tmp43_ = _tmp42_;
						if (_tmp43_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp44_;
								gint _m_size = 0;
								ValaList* _tmp45_;
								gint _tmp46_;
								gint _tmp47_;
								gint _m_index = 0;
								_tmp44_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp44_;
								_tmp45_ = _m_list;
								_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
								_tmp47_ = _tmp46_;
								_m_size = _tmp47_;
								_m_index = -1;
								while (TRUE) {
									ValaMethod* m = NULL;
									ValaList* _tmp48_;
									gpointer _tmp49_;
									gboolean _tmp50_ = FALSE;
									ValaMethod* _tmp51_;
									ValaDataType* _tmp52_;
									ValaDataType* _tmp53_;
									_m_index = _m_index + 1;
									if (!(_m_index < _m_size)) {
										break;
									}
									_tmp48_ = _m_list;
									_tmp49_ = vala_list_get (_tmp48_, _m_index);
									m = (ValaMethod*) _tmp49_;
									_tmp51_ = m;
									_tmp52_ = vala_method_get_base_interface_type (_tmp51_);
									_tmp53_ = _tmp52_;
									if (_tmp53_ != NULL) {
										ValaMethod* _tmp54_;
										ValaMethod* _tmp55_;
										ValaMethod* _tmp56_;
										ValaMethod* _tmp57_;
										_tmp54_ = base_method;
										_tmp55_ = m;
										_tmp56_ = vala_method_get_base_interface_method (_tmp55_);
										_tmp57_ = _tmp56_;
										_tmp50_ = _tmp54_ == _tmp57_;
									} else {
										_tmp50_ = FALSE;
									}
									if (_tmp50_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							if (has_explicit_implementation) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp58_ = base_method;
						_tmp60_ = vala_method_compatible (self, _tmp58_, &_tmp59_);
						_g_free0 (invalid_match);
						invalid_match = _tmp59_;
						if (!_tmp60_) {
							ValaMethodType* base_method_type = NULL;
							ValaMethod* _tmp61_;
							ValaMethodType* _tmp62_;
							ValaSourceReference* _tmp63_;
							ValaSourceReference* _tmp64_;
							gchar* _tmp65_;
							gchar* _tmp66_;
							ValaMethodType* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							const gchar* _tmp70_;
							gchar* _tmp71_;
							gchar* _tmp72_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp61_ = base_method;
							_tmp62_ = vala_method_type_new (_tmp61_);
							base_method_type = _tmp62_;
							_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp64_ = _tmp63_;
							_tmp65_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp66_ = _tmp65_;
							_tmp67_ = base_method_type;
							_tmp68_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp67_, NULL);
							_tmp69_ = _tmp68_;
							_tmp70_ = invalid_match;
							_tmp71_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp66_, _tmp69_, _tmp70_);
							_tmp72_ = _tmp71_;
							vala_report_error (_tmp64_, _tmp72_);
							_g_free0 (_tmp72_);
							_g_free0 (_tmp69_);
							_g_free0 (_tmp66_);
							_vala_code_node_unref0 (base_method_type);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp73_ = base_method;
						self->priv->_base_interface_method = _tmp73_;
						_tmp74_ = base_method;
						vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp74_, "CCode", "instance_pos");
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_method);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp75_ = vala_method_get_base_interface_type (self);
	_tmp76_ = _tmp75_;
	if (_tmp76_ != NULL) {
		ValaSourceReference* _tmp77_;
		ValaSourceReference* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp80_);
		_tmp82_ = _tmp81_;
		vala_report_error (_tmp78_, _tmp82_);
		_g_free0 (_tmp82_);
		_g_free0 (_tmp80_);
	}
}

static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}

static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValaSymbol* _tmp10_;
	ValaSymbol* _tmp11_;
	gboolean _tmp27_ = FALSE;
	gboolean _tmp33_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaSourceFile* _tmp120_;
	ValaSourceFile* _tmp121_;
	ValaSourceFile* _tmp122_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp123_;
	ValaSemanticAnalyzer* _tmp124_;
	ValaSymbol* _tmp125_;
	ValaSymbol* _tmp126_;
	ValaSymbol* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaSourceReference* _tmp129_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaSemanticAnalyzer* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	gboolean _tmp140_;
	gboolean _tmp141_;
	ValaDataType* _tmp142_;
	ValaDataType* _tmp143_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp144_;
	ValaAttribute* _tmp145_;
	ValaAttribute* _tmp146_;
	ValaDataType* _tmp153_;
	ValaDataType* _tmp154_;
	gboolean _tmp157_ = FALSE;
	gboolean _tmp158_ = FALSE;
	gboolean _tmp159_ = FALSE;
	ValaList* _tmp160_;
	gint _tmp161_;
	gint _tmp162_;
	gboolean optional_param = FALSE;
	ValaList* _tmp207_;
	ValaLocalVariable* _tmp228_;
	ValaLocalVariable* _tmp229_;
	ValaList* _tmp232_;
	ValaList* _tmp241_;
	ValaBlock* _tmp250_;
	ValaBlock* _tmp251_;
	ValaSemanticAnalyzer* _tmp254_;
	ValaSemanticAnalyzer* _tmp255_;
	ValaStruct* _tmp256_;
	ValaStruct* _tmp257_;
	gboolean _tmp293_ = FALSE;
	gboolean _tmp294_ = FALSE;
	ValaDataType* _tmp295_;
	ValaDataType* _tmp296_;
	ValaSemanticAnalyzer* _tmp340_;
	ValaSemanticAnalyzer* _tmp341_;
	ValaSourceFile* _tmp342_;
	ValaSemanticAnalyzer* _tmp343_;
	ValaSemanticAnalyzer* _tmp344_;
	ValaSymbol* _tmp345_;
	gboolean _tmp346_ = FALSE;
	gboolean _tmp347_ = FALSE;
	gboolean _tmp348_ = FALSE;
	gboolean _tmp349_;
	gboolean _tmp350_;
	ValaSemanticAnalyzer* _tmp366_;
	ValaSemanticAnalyzer* _tmp367_;
	ValaDataType* _tmp368_;
	ValaDataType* _tmp369_;
	ValaBlock* _tmp416_;
	ValaBlock* _tmp417_;
	gboolean _tmp454_ = FALSE;
	gboolean _tmp455_ = FALSE;
	gboolean _tmp456_ = FALSE;
	gboolean _tmp457_ = FALSE;
	gboolean _tmp458_ = FALSE;
	ValaAttribute* _tmp516_;
	gboolean _tmp517_;
	gboolean _tmp518_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	if (_tmp4_ != NULL) {
		ValaParameter* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		_tmp5_ = self->priv->_this_parameter;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) _tmp5_);
		_tmp7_ = _tmp6_;
		vala_data_type_set_value_owned (_tmp7_, TRUE);
	}
	_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	if (_tmp8_ != NULL) {
		_vala_iterable_unref0 (self->error_types);
		self->error_types = NULL;
	}
	_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp11_ = _tmp10_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_CLASS)) {
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_;
		_tmp13_ = self->priv->_is_abstract;
		if (_tmp13_) {
			_tmp12_ = TRUE;
		} else {
			gboolean _tmp14_;
			_tmp14_ = self->priv->_is_virtual;
			_tmp12_ = _tmp14_;
		}
		_tmp9_ = _tmp12_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaClass* _tmp17_;
		gboolean _tmp18_ = FALSE;
		ValaClass* _tmp19_;
		gboolean _tmp20_;
		gboolean _tmp21_;
		_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp17_;
		_tmp19_ = cl;
		_tmp20_ = vala_class_get_is_compact (_tmp19_);
		_tmp21_ = _tmp20_;
		if (_tmp21_) {
			ValaClass* _tmp22_;
			ValaClass* _tmp23_;
			ValaClass* _tmp24_;
			_tmp22_ = cl;
			_tmp23_ = vala_class_get_base_class (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ != NULL;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaSourceReference* _tmp25_;
			ValaSourceReference* _tmp26_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp26_ = _tmp25_;
			vala_report_error (_tmp26_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	if (vala_method_is_variadic (self)) {
		gboolean _tmp28_ = FALSE;
		gboolean _tmp29_;
		_tmp29_ = self->priv->_is_abstract;
		if (_tmp29_) {
			_tmp28_ = TRUE;
		} else {
			gboolean _tmp30_;
			_tmp30_ = self->priv->_is_virtual;
			_tmp28_ = _tmp30_;
		}
		_tmp27_ = _tmp28_;
	} else {
		_tmp27_ = FALSE;
	}
	if (_tmp27_) {
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp32_ = _tmp31_;
		vala_report_error (_tmp32_, "Abstract and virtual methods may not be variadic. Use a `va_list' para" \
"meter instead of `...'.");
		result = FALSE;
		return result;
	}
	_tmp33_ = self->priv->_is_abstract;
	if (_tmp33_) {
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp45_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp53_, VALA_TYPE_INTERFACE);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp58_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp65_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp67_, VALA_TYPE_INTERFACE);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		gboolean _tmp80_;
		_tmp80_ = self->priv->_is_abstract;
		if (_tmp80_) {
			_tmp79_ = TRUE;
		} else {
			gboolean _tmp81_;
			_tmp81_ = self->priv->_is_virtual;
			_tmp79_ = _tmp81_;
		}
		if (_tmp79_) {
			gboolean _tmp82_;
			gboolean _tmp83_;
			_tmp82_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp83_ = _tmp82_;
			_tmp78_ = _tmp83_;
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			gboolean _tmp84_;
			gboolean _tmp85_;
			_tmp84_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp85_ = _tmp84_;
			_tmp77_ = !_tmp85_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			ValaSymbol* _tmp86_;
			ValaSymbol* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			_tmp86_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_symbol_get_external (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp76_ = !_tmp89_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp90_;
			ValaSourceReference* _tmp91_;
			_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp91_ = _tmp90_;
			vala_report_error (_tmp91_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_;
			gboolean _tmp94_;
			_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp94_ = _tmp93_;
			if (_tmp94_) {
				ValaBlock* _tmp95_;
				ValaBlock* _tmp96_;
				_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp96_ = _tmp95_;
				_tmp92_ = _tmp96_ != NULL;
			} else {
				_tmp92_ = FALSE;
			}
			if (_tmp92_) {
				ValaSourceReference* _tmp97_;
				ValaSourceReference* _tmp98_;
				_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp98_ = _tmp97_;
				vala_report_error (_tmp98_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_;
				_tmp102_ = self->priv->_is_abstract;
				if (!_tmp102_) {
					gboolean _tmp103_;
					gboolean _tmp104_;
					_tmp103_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp104_ = _tmp103_;
					_tmp101_ = !_tmp104_;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaSourceFileType _tmp105_;
					ValaSourceFileType _tmp106_;
					_tmp105_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp106_ = _tmp105_;
					_tmp100_ = _tmp106_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaBlock* _tmp107_;
					ValaBlock* _tmp108_;
					_tmp107_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp108_ = _tmp107_;
					_tmp99_ = _tmp108_ == NULL;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp110_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp113_ = self->priv->_coroutine;
	if (_tmp113_) {
		gboolean _tmp114_;
		gboolean _tmp115_;
		_tmp114_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		_tmp112_ = !_tmp115_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		_tmp111_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		ValaSourceReference* _tmp116_;
		ValaSourceReference* _tmp117_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp117_ = _tmp116_;
		vala_report_error (_tmp117_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_semantic_analyzer_get_current_source_file (_tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _vala_source_file_ref0 (_tmp121_);
	old_source_file = _tmp122_;
	_tmp123_ = vala_code_context_get_analyzer (context);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_semantic_analyzer_get_current_symbol (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = _vala_code_node_ref0 (_tmp126_);
	old_symbol = _tmp127_;
	_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp129_ = _tmp128_;
	if (_tmp129_ != NULL) {
		ValaSemanticAnalyzer* _tmp130_;
		ValaSemanticAnalyzer* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaSourceReference* _tmp133_;
		ValaSourceFile* _tmp134_;
		ValaSourceFile* _tmp135_;
		_tmp130_ = vala_code_context_get_analyzer (context);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_source_reference_get_file (_tmp133_);
		_tmp135_ = _tmp134_;
		vala_semantic_analyzer_set_current_source_file (_tmp131_, _tmp135_);
	}
	_tmp136_ = vala_code_context_get_analyzer (context);
	_tmp137_ = _tmp136_;
	vala_semantic_analyzer_set_current_symbol (_tmp137_, (ValaSymbol*) self);
	_tmp138_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_method_get_returns_floating_reference (self);
	_tmp141_ = _tmp140_;
	vala_data_type_set_floating_reference (_tmp139_, _tmp141_);
	_tmp142_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp143_ = _tmp142_;
	vala_code_node_check ((ValaCodeNode*) _tmp143_, context);
	_tmp144_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	_tmp145_ = _vala_code_node_ref0 (_tmp144_);
	init_attr = _tmp145_;
	_tmp146_ = init_attr;
	if (_tmp146_ != NULL) {
		ValaSourceReference* _tmp147_;
		ValaSourceReference* _tmp148_;
		ValaSourceFile* _tmp149_;
		ValaSourceFile* _tmp150_;
		ValaCodeContext* _tmp151_;
		ValaCodeContext* _tmp152_;
		_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_source_reference_get_file (_tmp148_);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_source_file_get_context (_tmp150_);
		_tmp152_ = _tmp151_;
		vala_code_context_set_module_init_method (_tmp152_, self);
	}
	_tmp153_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp154_ = _tmp153_;
	if (_tmp154_ != NULL) {
		ValaDataType* _tmp155_;
		ValaDataType* _tmp156_;
		_tmp155_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp156_ = _tmp155_;
		vala_code_node_check ((ValaCodeNode*) _tmp156_, context);
	}
	_tmp160_ = self->priv->parameters;
	_tmp161_ = vala_collection_get_size ((ValaCollection*) _tmp160_);
	_tmp162_ = _tmp161_;
	if (_tmp162_ == 1) {
		ValaList* _tmp163_;
		gpointer _tmp164_;
		ValaParameter* _tmp165_;
		gboolean _tmp166_;
		gboolean _tmp167_;
		_tmp163_ = self->priv->parameters;
		_tmp164_ = vala_list_get (_tmp163_, 0);
		_tmp165_ = (ValaParameter*) _tmp164_;
		_tmp166_ = vala_parameter_get_ellipsis (_tmp165_);
		_tmp167_ = _tmp166_;
		_tmp159_ = _tmp167_;
		_vala_code_node_unref0 (_tmp165_);
	} else {
		_tmp159_ = FALSE;
	}
	if (_tmp159_) {
		ValaBlock* _tmp168_;
		ValaBlock* _tmp169_;
		_tmp168_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp169_ = _tmp168_;
		_tmp158_ = _tmp169_ != NULL;
	} else {
		_tmp158_ = FALSE;
	}
	if (_tmp158_) {
		ValaMemberBinding _tmp170_;
		_tmp170_ = self->priv->_binding;
		_tmp157_ = _tmp170_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp157_ = FALSE;
	}
	if (_tmp157_) {
		ValaList* _tmp171_;
		gpointer _tmp172_;
		ValaParameter* _tmp173_;
		ValaSourceReference* _tmp174_;
		ValaSourceReference* _tmp175_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp171_ = self->priv->parameters;
		_tmp172_ = vala_list_get (_tmp171_, 0);
		_tmp173_ = (ValaParameter*) _tmp172_;
		_tmp174_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp173_);
		_tmp175_ = _tmp174_;
		vala_report_error (_tmp175_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp173_);
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp176_;
		ValaList* _tmp177_;
		gint _param_size = 0;
		ValaList* _tmp178_;
		gint _tmp179_;
		gint _tmp180_;
		gint _param_index = 0;
		_tmp176_ = self->priv->parameters;
		_tmp177_ = _vala_iterable_ref0 (_tmp176_);
		_param_list = _tmp177_;
		_tmp178_ = _param_list;
		_tmp179_ = vala_collection_get_size ((ValaCollection*) _tmp178_);
		_tmp180_ = _tmp179_;
		_param_size = _tmp180_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp181_;
			gpointer _tmp182_;
			ValaParameter* _tmp183_;
			gboolean _tmp184_ = FALSE;
			gboolean _tmp185_;
			gboolean _tmp192_;
			gboolean _tmp193_ = FALSE;
			gboolean _tmp194_ = FALSE;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp181_ = _param_list;
			_tmp182_ = vala_list_get (_tmp181_, _param_index);
			param = (ValaParameter*) _tmp182_;
			_tmp183_ = param;
			vala_code_node_check ((ValaCodeNode*) _tmp183_, context);
			_tmp185_ = self->priv->_coroutine;
			if (_tmp185_) {
				ValaParameter* _tmp186_;
				ValaParameterDirection _tmp187_;
				ValaParameterDirection _tmp188_;
				_tmp186_ = param;
				_tmp187_ = vala_parameter_get_direction (_tmp186_);
				_tmp188_ = _tmp187_;
				_tmp184_ = _tmp188_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp184_ = FALSE;
			}
			if (_tmp184_) {
				ValaParameter* _tmp189_;
				ValaSourceReference* _tmp190_;
				ValaSourceReference* _tmp191_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp189_ = param;
				_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp189_);
				_tmp191_ = _tmp190_;
				vala_report_error (_tmp191_, "Reference parameters are not supported for async methods");
			}
			_tmp192_ = self->priv->_coroutine;
			if (_tmp192_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			if (optional_param) {
				ValaParameter* _tmp195_;
				ValaExpression* _tmp196_;
				ValaExpression* _tmp197_;
				_tmp195_ = param;
				_tmp196_ = vala_variable_get_initializer ((ValaVariable*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp194_ = _tmp197_ == NULL;
			} else {
				_tmp194_ = FALSE;
			}
			if (_tmp194_) {
				ValaParameter* _tmp198_;
				gboolean _tmp199_;
				gboolean _tmp200_;
				_tmp198_ = param;
				_tmp199_ = vala_parameter_get_ellipsis (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp193_ = !_tmp200_;
			} else {
				_tmp193_ = FALSE;
			}
			if (_tmp193_) {
				ValaParameter* _tmp201_;
				ValaSourceReference* _tmp202_;
				ValaSourceReference* _tmp203_;
				_tmp201_ = param;
				_tmp202_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp201_);
				_tmp203_ = _tmp202_;
				vala_report_warning (_tmp203_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp204_;
				ValaExpression* _tmp205_;
				ValaExpression* _tmp206_;
				_tmp204_ = param;
				_tmp205_ = vala_variable_get_initializer ((ValaVariable*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (_tmp206_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp207_ = self->error_types;
	if (_tmp207_ != NULL) {
		{
			ValaList* _error_type_list = NULL;
			ValaList* _tmp208_;
			ValaList* _tmp209_;
			gint _error_type_size = 0;
			ValaList* _tmp210_;
			gint _tmp211_;
			gint _tmp212_;
			gint _error_type_index = 0;
			_tmp208_ = self->error_types;
			_tmp209_ = _vala_iterable_ref0 (_tmp208_);
			_error_type_list = _tmp209_;
			_tmp210_ = _error_type_list;
			_tmp211_ = vala_collection_get_size ((ValaCollection*) _tmp210_);
			_tmp212_ = _tmp211_;
			_error_type_size = _tmp212_;
			_error_type_index = -1;
			while (TRUE) {
				ValaDataType* error_type = NULL;
				ValaList* _tmp213_;
				gpointer _tmp214_;
				ValaDataType* _tmp215_;
				ValaSemanticAnalyzer* _tmp216_;
				ValaSemanticAnalyzer* _tmp217_;
				ValaDataType* _tmp218_;
				_error_type_index = _error_type_index + 1;
				if (!(_error_type_index < _error_type_size)) {
					break;
				}
				_tmp213_ = _error_type_list;
				_tmp214_ = vala_list_get (_tmp213_, _error_type_index);
				error_type = (ValaDataType*) _tmp214_;
				_tmp215_ = error_type;
				vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
				_tmp216_ = vala_code_context_get_analyzer (context);
				_tmp217_ = _tmp216_;
				_tmp218_ = error_type;
				if (!vala_semantic_analyzer_is_type_accessible (_tmp217_, (ValaSymbol*) self, _tmp218_)) {
					ValaSourceReference* _tmp219_;
					ValaSourceReference* _tmp220_;
					ValaDataType* _tmp221_;
					gchar* _tmp222_;
					gchar* _tmp223_;
					gchar* _tmp224_;
					gchar* _tmp225_;
					gchar* _tmp226_;
					gchar* _tmp227_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp219_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp220_ = _tmp219_;
					_tmp221_ = error_type;
					_tmp222_ = vala_code_node_to_string ((ValaCodeNode*) _tmp221_);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp225_ = _tmp224_;
					_tmp226_ = g_strdup_printf ("error type `%s' is less accessible than method `%s'", _tmp223_, _tmp225_);
					_tmp227_ = _tmp226_;
					vala_report_error (_tmp220_, _tmp227_);
					_g_free0 (_tmp227_);
					_g_free0 (_tmp225_);
					_g_free0 (_tmp223_);
					result = FALSE;
					_vala_code_node_unref0 (error_type);
					_vala_iterable_unref0 (_error_type_list);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
	}
	_tmp228_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp229_ = _tmp228_;
	if (_tmp229_ != NULL) {
		ValaLocalVariable* _tmp230_;
		ValaLocalVariable* _tmp231_;
		_tmp230_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp231_ = _tmp230_;
		vala_code_node_check ((ValaCodeNode*) _tmp231_, context);
	}
	_tmp232_ = self->priv->preconditions;
	if (_tmp232_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp233_;
			ValaList* _tmp234_;
			gint _precondition_size = 0;
			ValaList* _tmp235_;
			gint _tmp236_;
			gint _tmp237_;
			gint _precondition_index = 0;
			_tmp233_ = self->priv->preconditions;
			_tmp234_ = _vala_iterable_ref0 (_tmp233_);
			_precondition_list = _tmp234_;
			_tmp235_ = _precondition_list;
			_tmp236_ = vala_collection_get_size ((ValaCollection*) _tmp235_);
			_tmp237_ = _tmp236_;
			_precondition_size = _tmp237_;
			_precondition_index = -1;
			while (TRUE) {
				ValaExpression* precondition = NULL;
				ValaList* _tmp238_;
				gpointer _tmp239_;
				ValaExpression* _tmp240_;
				_precondition_index = _precondition_index + 1;
				if (!(_precondition_index < _precondition_size)) {
					break;
				}
				_tmp238_ = _precondition_list;
				_tmp239_ = vala_list_get (_tmp238_, _precondition_index);
				precondition = (ValaExpression*) _tmp239_;
				_tmp240_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp240_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp241_ = self->priv->postconditions;
	if (_tmp241_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp242_;
			ValaList* _tmp243_;
			gint _postcondition_size = 0;
			ValaList* _tmp244_;
			gint _tmp245_;
			gint _tmp246_;
			gint _postcondition_index = 0;
			_tmp242_ = self->priv->postconditions;
			_tmp243_ = _vala_iterable_ref0 (_tmp242_);
			_postcondition_list = _tmp243_;
			_tmp244_ = _postcondition_list;
			_tmp245_ = vala_collection_get_size ((ValaCollection*) _tmp244_);
			_tmp246_ = _tmp245_;
			_postcondition_size = _tmp246_;
			_postcondition_index = -1;
			while (TRUE) {
				ValaExpression* postcondition = NULL;
				ValaList* _tmp247_;
				gpointer _tmp248_;
				ValaExpression* _tmp249_;
				_postcondition_index = _postcondition_index + 1;
				if (!(_postcondition_index < _postcondition_size)) {
					break;
				}
				_tmp247_ = _postcondition_list;
				_tmp248_ = vala_list_get (_tmp247_, _postcondition_index);
				postcondition = (ValaExpression*) _tmp248_;
				_tmp249_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp249_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp250_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp251_ = _tmp250_;
	if (_tmp251_ != NULL) {
		ValaBlock* _tmp252_;
		ValaBlock* _tmp253_;
		_tmp252_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp253_ = _tmp252_;
		vala_code_node_check ((ValaCodeNode*) _tmp253_, context);
	}
	_tmp254_ = vala_code_context_get_analyzer (context);
	_tmp255_ = _tmp254_;
	_tmp256_ = vala_semantic_analyzer_get_current_struct (_tmp255_);
	_tmp257_ = _tmp256_;
	if (_tmp257_ != NULL) {
		gboolean _tmp258_ = FALSE;
		gboolean _tmp259_ = FALSE;
		gboolean _tmp260_;
		_tmp260_ = self->priv->_is_abstract;
		if (_tmp260_) {
			_tmp259_ = TRUE;
		} else {
			gboolean _tmp261_;
			_tmp261_ = self->priv->_is_virtual;
			_tmp259_ = _tmp261_;
		}
		if (_tmp259_) {
			_tmp258_ = TRUE;
		} else {
			gboolean _tmp262_;
			_tmp262_ = self->priv->_overrides;
			_tmp258_ = _tmp262_;
		}
		if (_tmp258_) {
			ValaSourceReference* _tmp263_;
			ValaSourceReference* _tmp264_;
			gchar* _tmp265_;
			gchar* _tmp266_;
			gchar* _tmp267_;
			gchar* _tmp268_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp264_ = _tmp263_;
			_tmp265_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp266_ = _tmp265_;
			_tmp267_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp266_);
			_tmp268_ = _tmp267_;
			vala_report_error (_tmp264_, _tmp268_);
			_g_free0 (_tmp268_);
			_g_free0 (_tmp266_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp269_ = FALSE;
		gboolean _tmp270_;
		_tmp270_ = self->priv->_overrides;
		if (_tmp270_) {
			ValaMethod* _tmp271_;
			ValaMethod* _tmp272_;
			_tmp271_ = vala_method_get_base_method (self);
			_tmp272_ = _tmp271_;
			_tmp269_ = _tmp272_ == NULL;
		} else {
			_tmp269_ = FALSE;
		}
		if (_tmp269_) {
			ValaSourceReference* _tmp273_;
			ValaSourceReference* _tmp274_;
			gchar* _tmp275_;
			gchar* _tmp276_;
			gchar* _tmp277_;
			gchar* _tmp278_;
			_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp274_ = _tmp273_;
			_tmp275_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp276_ = _tmp275_;
			_tmp277_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp276_);
			_tmp278_ = _tmp277_;
			vala_report_error (_tmp274_, _tmp278_);
			_g_free0 (_tmp278_);
			_g_free0 (_tmp276_);
		} else {
			gboolean _tmp279_ = FALSE;
			gboolean _tmp280_ = FALSE;
			gboolean _tmp281_ = FALSE;
			gboolean _tmp282_;
			_tmp282_ = self->priv->_is_abstract;
			if (_tmp282_) {
				_tmp281_ = TRUE;
			} else {
				gboolean _tmp283_;
				_tmp283_ = self->priv->_is_virtual;
				_tmp281_ = _tmp283_;
			}
			if (_tmp281_) {
				_tmp280_ = TRUE;
			} else {
				gboolean _tmp284_;
				_tmp284_ = self->priv->_overrides;
				_tmp280_ = _tmp284_;
			}
			if (_tmp280_) {
				ValaSymbolAccessibility _tmp285_;
				ValaSymbolAccessibility _tmp286_;
				_tmp285_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp286_ = _tmp285_;
				_tmp279_ = _tmp286_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp279_ = FALSE;
			}
			if (_tmp279_) {
				ValaSourceReference* _tmp287_;
				ValaSourceReference* _tmp288_;
				gchar* _tmp289_;
				gchar* _tmp290_;
				gchar* _tmp291_;
				gchar* _tmp292_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp287_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp288_ = _tmp287_;
				_tmp289_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp290_ = _tmp289_;
				_tmp291_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp290_);
				_tmp292_ = _tmp291_;
				vala_report_error (_tmp288_, _tmp292_);
				_g_free0 (_tmp292_);
				_g_free0 (_tmp290_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp295_ = vala_method_get_base_interface_type (self);
	_tmp296_ = _tmp295_;
	if (_tmp296_ != NULL) {
		ValaMethod* _tmp297_;
		ValaMethod* _tmp298_;
		_tmp297_ = vala_method_get_base_interface_method (self);
		_tmp298_ = _tmp297_;
		_tmp294_ = _tmp298_ != NULL;
	} else {
		_tmp294_ = FALSE;
	}
	if (_tmp294_) {
		ValaSymbol* _tmp299_;
		ValaSymbol* _tmp300_;
		_tmp299_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp300_ = _tmp299_;
		_tmp293_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp300_, VALA_TYPE_CLASS);
	} else {
		_tmp293_ = FALSE;
	}
	if (_tmp293_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp301_;
		ValaSymbol* _tmp302_;
		ValaClass* _tmp303_;
		_tmp301_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp302_ = _tmp301_;
		_tmp303_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp303_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp304_;
			ValaList* _tmp305_;
			gint _m_size = 0;
			ValaList* _tmp306_;
			gint _tmp307_;
			gint _tmp308_;
			gint _m_index = 0;
			_tmp304_ = cl;
			_tmp305_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp304_);
			_m_list = _tmp305_;
			_tmp306_ = _m_list;
			_tmp307_ = vala_collection_get_size ((ValaCollection*) _tmp306_);
			_tmp308_ = _tmp307_;
			_m_size = _tmp308_;
			_m_index = -1;
			while (TRUE) {
				ValaMethod* m = NULL;
				ValaList* _tmp309_;
				gpointer _tmp310_;
				gboolean _tmp311_ = FALSE;
				ValaMethod* _tmp312_;
				_m_index = _m_index + 1;
				if (!(_m_index < _m_size)) {
					break;
				}
				_tmp309_ = _m_list;
				_tmp310_ = vala_list_get (_tmp309_, _m_index);
				m = (ValaMethod*) _tmp310_;
				_tmp312_ = m;
				if (_tmp312_ != self) {
					ValaMethod* _tmp313_;
					ValaMethod* _tmp314_;
					ValaMethod* _tmp315_;
					ValaMethod* _tmp316_;
					ValaMethod* _tmp317_;
					_tmp313_ = m;
					_tmp314_ = vala_method_get_base_interface_method (_tmp313_);
					_tmp315_ = _tmp314_;
					_tmp316_ = vala_method_get_base_interface_method (self);
					_tmp317_ = _tmp316_;
					_tmp311_ = _tmp315_ == _tmp317_;
				} else {
					_tmp311_ = FALSE;
				}
				if (_tmp311_) {
					ValaMethod* _tmp318_;
					ValaMethod* _tmp319_;
					ValaSourceReference* _tmp320_;
					ValaSourceReference* _tmp321_;
					ValaClass* _tmp322_;
					gchar* _tmp323_;
					gchar* _tmp324_;
					ValaMethod* _tmp325_;
					ValaMethod* _tmp326_;
					gchar* _tmp327_;
					gchar* _tmp328_;
					gchar* _tmp329_;
					gchar* _tmp330_;
					ValaMethod* _tmp331_;
					ValaSourceReference* _tmp332_;
					ValaSourceReference* _tmp333_;
					ValaMethod* _tmp334_;
					ValaMethod* _tmp335_;
					gchar* _tmp336_;
					gchar* _tmp337_;
					gchar* _tmp338_;
					gchar* _tmp339_;
					_tmp318_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp318_, TRUE);
					_tmp319_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp319_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp320_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp321_ = _tmp320_;
					_tmp322_ = cl;
					_tmp323_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp322_);
					_tmp324_ = _tmp323_;
					_tmp325_ = vala_method_get_base_interface_method (self);
					_tmp326_ = _tmp325_;
					_tmp327_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp326_);
					_tmp328_ = _tmp327_;
					_tmp329_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp324_, _tmp328_);
					_tmp330_ = _tmp329_;
					vala_report_error (_tmp321_, _tmp330_);
					_g_free0 (_tmp330_);
					_g_free0 (_tmp328_);
					_g_free0 (_tmp324_);
					_tmp331_ = m;
					_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp331_);
					_tmp333_ = _tmp332_;
					_tmp334_ = vala_method_get_base_interface_method (self);
					_tmp335_ = _tmp334_;
					_tmp336_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp335_);
					_tmp337_ = _tmp336_;
					_tmp338_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp337_);
					_tmp339_ = _tmp338_;
					vala_report_notice (_tmp333_, _tmp339_);
					_g_free0 (_tmp339_);
					_g_free0 (_tmp337_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp340_ = vala_code_context_get_analyzer (context);
	_tmp341_ = _tmp340_;
	_tmp342_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp341_, _tmp342_);
	_tmp343_ = vala_code_context_get_analyzer (context);
	_tmp344_ = _tmp343_;
	_tmp345_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp344_, _tmp345_);
	_tmp349_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp350_ = _tmp349_;
	if (!_tmp350_) {
		gboolean _tmp351_;
		_tmp351_ = self->priv->_overrides;
		_tmp348_ = !_tmp351_;
	} else {
		_tmp348_ = FALSE;
	}
	if (_tmp348_) {
		gboolean _tmp352_;
		gboolean _tmp353_;
		_tmp352_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp353_ = _tmp352_;
		_tmp347_ = !_tmp353_;
	} else {
		_tmp347_ = FALSE;
	}
	if (_tmp347_) {
		ValaSymbol* _tmp354_;
		ValaSymbol* _tmp355_;
		_tmp354_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp355_ = _tmp354_;
		_tmp346_ = _tmp355_ != NULL;
		_vala_code_node_unref0 (_tmp355_);
	} else {
		_tmp346_ = FALSE;
	}
	if (_tmp346_) {
		ValaSourceReference* _tmp356_;
		ValaSourceReference* _tmp357_;
		gchar* _tmp358_;
		gchar* _tmp359_;
		ValaSymbol* _tmp360_;
		ValaSymbol* _tmp361_;
		gchar* _tmp362_;
		gchar* _tmp363_;
		gchar* _tmp364_;
		gchar* _tmp365_;
		_tmp356_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp357_ = _tmp356_;
		_tmp358_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp359_ = _tmp358_;
		_tmp360_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp361_ = _tmp360_;
		_tmp362_ = vala_symbol_get_full_name (_tmp361_);
		_tmp363_ = _tmp362_;
		_tmp364_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp359_, _tmp363_);
		_tmp365_ = _tmp364_;
		vala_report_warning (_tmp357_, _tmp365_);
		_g_free0 (_tmp365_);
		_g_free0 (_tmp363_);
		_vala_code_node_unref0 (_tmp361_);
		_g_free0 (_tmp359_);
	}
	_tmp366_ = vala_code_context_get_analyzer (context);
	_tmp367_ = _tmp366_;
	_tmp368_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp369_ = _tmp368_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp367_, (ValaSymbol*) self, _tmp369_)) {
		ValaSourceReference* _tmp370_;
		ValaSourceReference* _tmp371_;
		ValaDataType* _tmp372_;
		ValaDataType* _tmp373_;
		gchar* _tmp374_;
		gchar* _tmp375_;
		gchar* _tmp376_;
		gchar* _tmp377_;
		gchar* _tmp378_;
		gchar* _tmp379_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp373_ = _tmp372_;
		_tmp374_ = vala_code_node_to_string ((ValaCodeNode*) _tmp373_);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp377_ = _tmp376_;
		_tmp378_ = g_strdup_printf ("return type `%s' is less accessible than method `%s'", _tmp375_, _tmp377_);
		_tmp379_ = _tmp378_;
		vala_report_error (_tmp371_, _tmp379_);
		_g_free0 (_tmp379_);
		_g_free0 (_tmp377_);
		_g_free0 (_tmp375_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp380_;
		gint _precondition_size = 0;
		ValaList* _tmp381_;
		gint _tmp382_;
		gint _tmp383_;
		gint _precondition_index = 0;
		_tmp380_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp380_;
		_tmp381_ = _precondition_list;
		_tmp382_ = vala_collection_get_size ((ValaCollection*) _tmp381_);
		_tmp383_ = _tmp382_;
		_precondition_size = _tmp383_;
		_precondition_index = -1;
		while (TRUE) {
			ValaExpression* precondition = NULL;
			ValaList* _tmp384_;
			gpointer _tmp385_;
			ValaExpression* _tmp386_;
			gboolean _tmp387_;
			gboolean _tmp388_;
			ValaExpression* _tmp389_;
			ValaDataType* _tmp390_;
			ValaDataType* _tmp391_;
			ValaSemanticAnalyzer* _tmp392_;
			ValaSemanticAnalyzer* _tmp393_;
			ValaDataType* _tmp394_;
			_precondition_index = _precondition_index + 1;
			if (!(_precondition_index < _precondition_size)) {
				break;
			}
			_tmp384_ = _precondition_list;
			_tmp385_ = vala_list_get (_tmp384_, _precondition_index);
			precondition = (ValaExpression*) _tmp385_;
			_tmp386_ = precondition;
			_tmp387_ = vala_code_node_get_error ((ValaCodeNode*) _tmp386_);
			_tmp388_ = _tmp387_;
			if (_tmp388_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp389_ = precondition;
			_tmp390_ = vala_expression_get_value_type (_tmp389_);
			_tmp391_ = _tmp390_;
			_tmp392_ = vala_code_context_get_analyzer (context);
			_tmp393_ = _tmp392_;
			_tmp394_ = _tmp393_->bool_type;
			if (!vala_data_type_compatible (_tmp391_, _tmp394_)) {
				ValaExpression* _tmp395_;
				ValaSourceReference* _tmp396_;
				ValaSourceReference* _tmp397_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp395_ = precondition;
				_tmp396_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp395_);
				_tmp397_ = _tmp396_;
				vala_report_error (_tmp397_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp398_;
		gint _postcondition_size = 0;
		ValaList* _tmp399_;
		gint _tmp400_;
		gint _tmp401_;
		gint _postcondition_index = 0;
		_tmp398_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp398_;
		_tmp399_ = _postcondition_list;
		_tmp400_ = vala_collection_get_size ((ValaCollection*) _tmp399_);
		_tmp401_ = _tmp400_;
		_postcondition_size = _tmp401_;
		_postcondition_index = -1;
		while (TRUE) {
			ValaExpression* postcondition = NULL;
			ValaList* _tmp402_;
			gpointer _tmp403_;
			ValaExpression* _tmp404_;
			gboolean _tmp405_;
			gboolean _tmp406_;
			ValaExpression* _tmp407_;
			ValaDataType* _tmp408_;
			ValaDataType* _tmp409_;
			ValaSemanticAnalyzer* _tmp410_;
			ValaSemanticAnalyzer* _tmp411_;
			ValaDataType* _tmp412_;
			_postcondition_index = _postcondition_index + 1;
			if (!(_postcondition_index < _postcondition_size)) {
				break;
			}
			_tmp402_ = _postcondition_list;
			_tmp403_ = vala_list_get (_tmp402_, _postcondition_index);
			postcondition = (ValaExpression*) _tmp403_;
			_tmp404_ = postcondition;
			_tmp405_ = vala_code_node_get_error ((ValaCodeNode*) _tmp404_);
			_tmp406_ = _tmp405_;
			if (_tmp406_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp407_ = postcondition;
			_tmp408_ = vala_expression_get_value_type (_tmp407_);
			_tmp409_ = _tmp408_;
			_tmp410_ = vala_code_context_get_analyzer (context);
			_tmp411_ = _tmp410_;
			_tmp412_ = _tmp411_->bool_type;
			if (!vala_data_type_compatible (_tmp409_, _tmp412_)) {
				ValaExpression* _tmp413_;
				ValaSourceReference* _tmp414_;
				ValaSourceReference* _tmp415_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp413_ = postcondition;
				_tmp414_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp413_);
				_tmp415_ = _tmp414_;
				vala_report_error (_tmp415_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp416_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp417_ = _tmp416_;
	if (_tmp417_ != NULL) {
		ValaArrayList* body_errors = NULL;
		GEqualFunc _tmp418_;
		ValaArrayList* _tmp419_;
		ValaBlock* _tmp420_;
		ValaBlock* _tmp421_;
		ValaArrayList* _tmp422_;
		_tmp418_ = g_direct_equal;
		_tmp419_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp418_);
		body_errors = _tmp419_;
		_tmp420_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp421_ = _tmp420_;
		_tmp422_ = body_errors;
		vala_code_node_get_error_types ((ValaCodeNode*) _tmp421_, (ValaCollection*) _tmp422_, NULL);
		{
			ValaArrayList* _body_error_type_list = NULL;
			ValaArrayList* _tmp423_;
			ValaArrayList* _tmp424_;
			gint _body_error_type_size = 0;
			ValaArrayList* _tmp425_;
			gint _tmp426_;
			gint _tmp427_;
			gint _body_error_type_index = 0;
			_tmp423_ = body_errors;
			_tmp424_ = _vala_iterable_ref0 (_tmp423_);
			_body_error_type_list = _tmp424_;
			_tmp425_ = _body_error_type_list;
			_tmp426_ = vala_collection_get_size ((ValaCollection*) _tmp425_);
			_tmp427_ = _tmp426_;
			_body_error_type_size = _tmp427_;
			_body_error_type_index = -1;
			while (TRUE) {
				ValaDataType* body_error_type = NULL;
				ValaArrayList* _tmp428_;
				gpointer _tmp429_;
				gboolean can_propagate_error = FALSE;
				ValaList* _tmp430_;
				gboolean _tmp440_ = FALSE;
				ValaDataType* _tmp441_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp445_ = FALSE;
				_body_error_type_index = _body_error_type_index + 1;
				if (!(_body_error_type_index < _body_error_type_size)) {
					break;
				}
				_tmp428_ = _body_error_type_list;
				_tmp429_ = vala_list_get ((ValaList*) _tmp428_, _body_error_type_index);
				body_error_type = (ValaDataType*) _tmp429_;
				can_propagate_error = FALSE;
				_tmp430_ = self->error_types;
				if (_tmp430_ != NULL) {
					{
						ValaList* _method_error_type_list = NULL;
						ValaList* _tmp431_;
						ValaList* _tmp432_;
						gint _method_error_type_size = 0;
						ValaList* _tmp433_;
						gint _tmp434_;
						gint _tmp435_;
						gint _method_error_type_index = 0;
						_tmp431_ = self->error_types;
						_tmp432_ = _vala_iterable_ref0 (_tmp431_);
						_method_error_type_list = _tmp432_;
						_tmp433_ = _method_error_type_list;
						_tmp434_ = vala_collection_get_size ((ValaCollection*) _tmp433_);
						_tmp435_ = _tmp434_;
						_method_error_type_size = _tmp435_;
						_method_error_type_index = -1;
						while (TRUE) {
							ValaDataType* method_error_type = NULL;
							ValaList* _tmp436_;
							gpointer _tmp437_;
							ValaDataType* _tmp438_;
							ValaDataType* _tmp439_;
							_method_error_type_index = _method_error_type_index + 1;
							if (!(_method_error_type_index < _method_error_type_size)) {
								break;
							}
							_tmp436_ = _method_error_type_list;
							_tmp437_ = vala_list_get (_tmp436_, _method_error_type_index);
							method_error_type = (ValaDataType*) _tmp437_;
							_tmp438_ = body_error_type;
							_tmp439_ = method_error_type;
							if (vala_data_type_compatible (_tmp438_, _tmp439_)) {
								can_propagate_error = TRUE;
							}
							_vala_code_node_unref0 (method_error_type);
						}
						_vala_iterable_unref0 (_method_error_type_list);
					}
				}
				_tmp441_ = body_error_type;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp441_, VALA_TYPE_ERROR_TYPE)) {
					ValaDataType* _tmp442_;
					gboolean _tmp443_;
					gboolean _tmp444_;
					_tmp442_ = body_error_type;
					_tmp443_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp444_ = _tmp443_;
					_tmp440_ = _tmp444_;
				} else {
					_tmp440_ = FALSE;
				}
				is_dynamic_error = _tmp440_;
				if (!can_propagate_error) {
					_tmp445_ = !is_dynamic_error;
				} else {
					_tmp445_ = FALSE;
				}
				if (_tmp445_) {
					ValaDataType* _tmp446_;
					ValaSourceReference* _tmp447_;
					ValaSourceReference* _tmp448_;
					ValaDataType* _tmp449_;
					gchar* _tmp450_;
					gchar* _tmp451_;
					gchar* _tmp452_;
					gchar* _tmp453_;
					_tmp446_ = body_error_type;
					_tmp447_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp446_);
					_tmp448_ = _tmp447_;
					_tmp449_ = body_error_type;
					_tmp450_ = vala_code_node_to_string ((ValaCodeNode*) _tmp449_);
					_tmp451_ = _tmp450_;
					_tmp452_ = g_strdup_printf ("unhandled error `%s'", _tmp451_);
					_tmp453_ = _tmp452_;
					vala_report_warning (_tmp448_, _tmp453_);
					_g_free0 (_tmp453_);
					_g_free0 (_tmp451_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
		_vala_iterable_unref0 (body_errors);
	}
	if (!G_TYPE_CHECK_INSTANCE_TYPE (self, VALA_TYPE_CREATION_METHOD)) {
		ValaMemberBinding _tmp459_;
		_tmp459_ = self->priv->_binding;
		_tmp458_ = _tmp459_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp458_ = FALSE;
	}
	if (_tmp458_) {
		gboolean _tmp460_;
		_tmp460_ = self->priv->_overrides;
		_tmp457_ = !_tmp460_;
	} else {
		_tmp457_ = FALSE;
	}
	if (_tmp457_) {
		ValaSymbolAccessibility _tmp461_;
		ValaSymbolAccessibility _tmp462_;
		_tmp461_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp462_ = _tmp461_;
		_tmp456_ = _tmp462_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp456_ = FALSE;
	}
	if (_tmp456_) {
		ValaSymbol* _tmp463_;
		ValaSymbol* _tmp464_;
		_tmp463_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp464_ = _tmp463_;
		_tmp455_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp464_, VALA_TYPE_OBJECT_TYPE_SYMBOL);
	} else {
		_tmp455_ = FALSE;
	}
	if (_tmp455_) {
		ValaSymbol* _tmp465_;
		ValaSymbol* _tmp466_;
		ValaAttribute* _tmp467_;
		_tmp465_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp466_ = _tmp465_;
		_tmp467_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp466_, "DBus");
		_tmp454_ = _tmp467_ != NULL;
	} else {
		_tmp454_ = FALSE;
	}
	if (_tmp454_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp468_;
		ValaAttribute* _tmp469_;
		gboolean _tmp470_ = FALSE;
		ValaAttribute* _tmp471_;
		_tmp468_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		_tmp469_ = _vala_code_node_ref0 (_tmp468_);
		dbus_attr = _tmp469_;
		_tmp471_ = dbus_attr;
		if (_tmp471_ == NULL) {
			_tmp470_ = TRUE;
		} else {
			ValaAttribute* _tmp472_;
			_tmp472_ = dbus_attr;
			_tmp470_ = vala_attribute_get_bool (_tmp472_, "visible", TRUE);
		}
		if (_tmp470_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			ValaArrayList* error_types = NULL;
			GEqualFunc _tmp473_;
			ValaArrayList* _tmp474_;
			ValaArrayList* _tmp475_;
			gboolean _tmp492_ = FALSE;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			_tmp473_ = g_direct_equal;
			_tmp474_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp473_);
			error_types = _tmp474_;
			_tmp475_ = error_types;
			vala_code_node_get_error_types ((ValaCodeNode*) self, (ValaCollection*) _tmp475_, NULL);
			{
				ValaArrayList* _error_type_list = NULL;
				ValaArrayList* _tmp476_;
				ValaArrayList* _tmp477_;
				gint _error_type_size = 0;
				ValaArrayList* _tmp478_;
				gint _tmp479_;
				gint _tmp480_;
				gint _error_type_index = 0;
				_tmp476_ = error_types;
				_tmp477_ = _vala_iterable_ref0 (_tmp476_);
				_error_type_list = _tmp477_;
				_tmp478_ = _error_type_list;
				_tmp479_ = vala_collection_get_size ((ValaCollection*) _tmp478_);
				_tmp480_ = _tmp479_;
				_error_type_size = _tmp480_;
				_error_type_index = -1;
				while (TRUE) {
					ValaDataType* error_type = NULL;
					ValaArrayList* _tmp481_;
					gpointer _tmp482_;
					ValaDataType* _tmp483_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp484_;
					ValaErrorDomain* _tmp485_;
					ValaErrorDomain* _tmp486_;
					ValaErrorDomain* _tmp487_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp488_;
					gchar* _tmp489_;
					const gchar* _tmp490_;
					_error_type_index = _error_type_index + 1;
					if (!(_error_type_index < _error_type_size)) {
						break;
					}
					_tmp481_ = _error_type_list;
					_tmp482_ = vala_list_get ((ValaList*) _tmp481_, _error_type_index);
					error_type = (ValaDataType*) _tmp482_;
					_tmp483_ = error_type;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp483_, VALA_TYPE_ERROR_TYPE)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp484_ = error_type;
					_tmp485_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp484_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp486_ = _tmp485_;
					error_domain = _tmp486_;
					_tmp487_ = error_domain;
					if (_tmp487_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp488_ = error_domain;
					_tmp489_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp488_);
					full_error_domain = _tmp489_;
					_tmp490_ = full_error_domain;
					if (g_strcmp0 (_tmp490_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp491_;
						_tmp491_ = full_error_domain;
						if (g_strcmp0 (_tmp491_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			if (!throws_gerror) {
				gboolean _tmp493_ = FALSE;
				if (throws_gioerror) {
					_tmp493_ = throws_gdbuserror;
				} else {
					_tmp493_ = FALSE;
				}
				_tmp492_ = !_tmp493_;
			} else {
				_tmp492_ = FALSE;
			}
			if (_tmp492_) {
				ValaSourceReference* _tmp494_;
				ValaSourceReference* _tmp495_;
				_tmp494_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp495_ = _tmp494_;
				vala_report_warning (_tmp495_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
			_vala_iterable_unref0 (error_types);
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp496_;
		ValaMethod* _tmp497_;
		gboolean _tmp506_;
		gboolean _tmp507_;
		gboolean _tmp510_;
		gboolean _tmp513_;
		_tmp496_ = vala_code_context_get_entry_point (context);
		_tmp497_ = _tmp496_;
		if (_tmp497_ != NULL) {
			ValaSourceReference* _tmp498_;
			ValaSourceReference* _tmp499_;
			ValaMethod* _tmp500_;
			ValaMethod* _tmp501_;
			gchar* _tmp502_;
			gchar* _tmp503_;
			gchar* _tmp504_;
			gchar* _tmp505_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp499_ = _tmp498_;
			_tmp500_ = vala_code_context_get_entry_point (context);
			_tmp501_ = _tmp500_;
			_tmp502_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp501_);
			_tmp503_ = _tmp502_;
			_tmp504_ = g_strdup_printf ("program already has an entry point `%s'", _tmp503_);
			_tmp505_ = _tmp504_;
			vala_report_error (_tmp499_, _tmp505_);
			_g_free0 (_tmp505_);
			_g_free0 (_tmp503_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp506_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp507_ = _tmp506_;
		if (_tmp507_) {
			ValaSourceReference* _tmp508_;
			ValaSourceReference* _tmp509_;
			_tmp508_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp509_ = _tmp508_;
			vala_report_error (_tmp509_, "\"main\" method cannot throw errors");
		}
		_tmp510_ = self->priv->_is_inline;
		if (_tmp510_) {
			ValaSourceReference* _tmp511_;
			ValaSourceReference* _tmp512_;
			_tmp511_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp512_ = _tmp511_;
			vala_report_error (_tmp512_, "\"main\" method cannot be inline");
		}
		_tmp513_ = self->priv->_coroutine;
		if (_tmp513_) {
			ValaSourceReference* _tmp514_;
			ValaSourceReference* _tmp515_;
			_tmp514_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp515_ = _tmp514_;
			vala_report_error (_tmp515_, "\"main\" method cannot be async");
		}
	}
	_tmp516_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	if (_tmp516_ != NULL) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp517_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp518_ = _tmp517_;
	result = !_tmp518_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}

static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_VOID_TYPE)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp43_, VALA_TYPE_ARRAY_TYPE)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}

gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint result = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp5_;
			gpointer _tmp6_;
			gboolean _tmp7_ = FALSE;
			ValaParameter* _tmp8_;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gint _tmp14_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp5_ = _param_list;
			_tmp6_ = vala_list_get (_tmp5_, _param_index);
			param = (ValaParameter*) _tmp6_;
			_tmp8_ = param;
			_tmp9_ = vala_variable_get_initializer ((ValaVariable*) _tmp8_);
			_tmp10_ = _tmp9_;
			if (_tmp10_ != NULL) {
				_tmp7_ = TRUE;
			} else {
				ValaParameter* _tmp11_;
				gboolean _tmp12_;
				gboolean _tmp13_;
				_tmp11_ = param;
				_tmp12_ = vala_parameter_get_ellipsis (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp7_ = _tmp13_;
			}
			if (_tmp7_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp14_ = n;
			n = _tmp14_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}

ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp31_;
	ValaMethod* _tmp32_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp30_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				ValaParameter* param = NULL;
				ValaList* _tmp16_;
				gpointer _tmp17_;
				ValaMethod* _tmp18_;
				ValaParameter* _tmp19_;
				ValaParameter* _tmp20_;
				ValaParameter* _tmp21_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp16_ = _param_list;
				_tmp17_ = vala_list_get (_tmp16_, _param_index);
				param = (ValaParameter*) _tmp17_;
				_tmp18_ = self->priv->end_method;
				_tmp19_ = param;
				_tmp20_ = vala_parameter_copy (_tmp19_);
				_tmp21_ = _tmp20_;
				vala_callable_add_parameter ((ValaCallable*) _tmp18_, _tmp21_);
				_vala_code_node_unref0 (_tmp21_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp22_;
			gint _param_size = 0;
			ValaList* _tmp23_;
			gint _tmp24_;
			gint _tmp25_;
			gint _param_index = 0;
			_tmp22_ = vala_method_get_type_parameters (self);
			_param_list = _tmp22_;
			_tmp23_ = _param_list;
			_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
			_tmp25_ = _tmp24_;
			_param_size = _tmp25_;
			_param_index = -1;
			while (TRUE) {
				ValaTypeParameter* param = NULL;
				ValaList* _tmp26_;
				gpointer _tmp27_;
				ValaMethod* _tmp28_;
				ValaTypeParameter* _tmp29_;
				_param_index = _param_index + 1;
				if (!(_param_index < _param_size)) {
					break;
				}
				_tmp26_ = _param_list;
				_tmp27_ = vala_list_get (_tmp26_, _param_index);
				param = (ValaTypeParameter*) _tmp27_;
				_tmp28_ = self->priv->end_method;
				_tmp29_ = param;
				vala_method_add_type_parameter (_tmp28_, _tmp29_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp30_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp30_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp31_ = self->priv->end_method;
	_tmp32_ = _vala_code_node_ref0 (_tmp31_);
	result = _tmp32_;
	return result;
}

ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}

ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp28_;
	ValaScope* _tmp29_;
	ValaScope* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaDelegate* _tmp32_;
	ValaDelegateType* _tmp33_;
	ValaDelegateType* _tmp34_;
	ValaDelegateType* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp38_;
	ValaParameter* _tmp39_;
	ValaParameter* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaNullLiteral* _tmp43_;
	ValaNullLiteral* _tmp44_;
	ValaParameter* _tmp45_;
	ValaExpression* _tmp46_;
	ValaExpression* _tmp47_;
	ValaDelegateType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaParameter* _tmp51_;
	ValaParameter* _tmp52_;
	ValaArrayList* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaParameter* _tmp18_;
			gboolean _tmp19_;
			gboolean _tmp20_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp16_ = _param_list;
			_tmp17_ = vala_list_get (_tmp16_, _param_index);
			param = (ValaParameter*) _tmp17_;
			_tmp18_ = param;
			_tmp19_ = vala_parameter_get_ellipsis (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_) {
				ValaParameter* _tmp21_;
				ValaParameter* _tmp22_;
				_tmp21_ = param;
				_tmp22_ = _vala_code_node_ref0 (_tmp21_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp22_;
			} else {
				ValaParameter* _tmp23_;
				ValaParameterDirection _tmp24_;
				ValaParameterDirection _tmp25_;
				_tmp23_ = param;
				_tmp24_ = vala_parameter_get_direction (_tmp23_);
				_tmp25_ = _tmp24_;
				if (_tmp25_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp26_;
					ValaParameter* _tmp27_;
					_tmp26_ = params;
					_tmp27_ = param;
					vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp28_ = glib_ns;
	_tmp29_ = vala_symbol_get_scope (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_scope_lookup (_tmp30_, "AsyncReadyCallback");
	_tmp32_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp33_ = vala_delegate_type_new (_tmp32_);
	_tmp34_ = _tmp33_;
	_vala_code_node_unref0 (_tmp32_);
	callback_type = _tmp34_;
	_tmp35_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp35_, TRUE);
	_tmp36_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp36_, TRUE);
	_tmp37_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp37_, TRUE);
	_tmp38_ = callback_type;
	_tmp39_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp38_, NULL);
	callback_param = _tmp39_;
	_tmp40_ = callback_param;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_null_literal_new (_tmp42_);
	_tmp44_ = _tmp43_;
	vala_variable_set_initializer ((ValaVariable*) _tmp40_, (ValaExpression*) _tmp44_);
	_vala_code_node_unref0 (_tmp44_);
	_tmp45_ = callback_param;
	_tmp46_ = vala_variable_get_initializer ((ValaVariable*) _tmp45_);
	_tmp47_ = _tmp46_;
	_tmp48_ = callback_type;
	_tmp49_ = vala_data_type_copy ((ValaDataType*) _tmp48_);
	_tmp50_ = _tmp49_;
	vala_expression_set_target_type (_tmp47_, _tmp50_);
	_vala_code_node_unref0 (_tmp50_);
	_tmp51_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp51_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp52_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp52_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp53_ = params;
	_tmp54_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp53_, _tmp54_);
	_tmp55_ = ellipsis;
	if (_tmp55_ != NULL) {
		ValaArrayList* _tmp56_;
		ValaParameter* _tmp57_;
		_tmp56_ = params;
		_tmp57_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp28_;
			gpointer _tmp29_;
			ValaParameter* _tmp30_;
			ValaParameterDirection _tmp31_;
			ValaParameterDirection _tmp32_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp28_ = _param_list;
			_tmp29_ = vala_list_get (_tmp28_, _param_index);
			param = (ValaParameter*) _tmp29_;
			_tmp30_ = param;
			_tmp31_ = vala_parameter_get_direction (_tmp30_);
			_tmp32_ = _tmp31_;
			if (_tmp32_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp33_;
				ValaParameter* _tmp34_;
				_tmp33_ = params;
				_tmp34_ = param;
				vala_collection_add ((ValaCollection*) _tmp33_, _tmp34_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}

void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}

void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				ValaLocalVariable* local = NULL;
				ValaList* _tmp6_;
				gpointer _tmp7_;
				ValaLocalVariable* _tmp8_;
				_local_index = _local_index + 1;
				if (!(_local_index < _local_size)) {
					break;
				}
				_tmp6_ = _local_list;
				_tmp7_ = vala_list_get (_tmp6_, _local_index);
				local = (ValaLocalVariable*) _tmp7_;
				_tmp8_ = local;
				vala_collection_add (variables, _tmp8_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}

static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	gboolean _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_closure;
	if (_tmp0_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}

gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				ValaList* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
				ValaList* _tmp5_;
				gpointer _tmp6_;
				ValaParameter* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->parameters;
				_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
				_tmp4_ = _tmp3_;
				if (!(i < _tmp4_)) {
					break;
				}
				_tmp5_ = self->priv->parameters;
				_tmp6_ = vala_list_get (_tmp5_, i);
				_tmp7_ = (ValaParameter*) _tmp6_;
				_tmp8_ = vala_parameter_get_format_arg (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_vala_code_node_unref0 (_tmp7_);
				if (_tmp10_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ValaMethod* _tmp4_;
	ValaMethod* _tmp5_;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	ValaMethod* _tmp12_;
	ValaMethod* _tmp13_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = TRUE;
		return result;
	}
	_tmp4_ = vala_method_get_base_method (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		_tmp6_ = vala_method_get_base_method (self);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ != self;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		_tmp8_ = vala_method_get_base_method (self);
		_tmp9_ = _tmp8_;
		_tmp2_ = vala_method_has_error_type_parameter (_tmp9_);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		result = TRUE;
		return result;
	}
	_tmp12_ = vala_method_get_base_interface_method (self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaMethod* _tmp14_;
		ValaMethod* _tmp15_;
		_tmp14_ = vala_method_get_base_interface_method (self);
		_tmp15_ = _tmp14_;
		_tmp11_ = _tmp15_ != self;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		_tmp16_ = vala_method_get_base_interface_method (self);
		_tmp17_ = _tmp16_;
		_tmp10_ = vala_method_has_error_type_parameter (_tmp17_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}

static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VOID_TYPE);
	return result;
}

ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}

void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}

gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_abstract;
	return result;
}

void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}

gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_virtual;
	return result;
}

void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}

gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_overrides;
	return result;
}

void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}

gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_inline;
	return result;
}

void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}

gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}

void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}

gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}

ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}

ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}

ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}

void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_entry_point;
	return result;
}

static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}

ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}

void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}

gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}

gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	result = _tmp0_ != NULL;
	return result;
}

void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}

gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}

void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}

ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}

void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}

gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_closure;
	return result;
}

void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}

gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_coroutine;
	return result;
}

void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}

gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_async_callback;
	return result;
}

void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}

static void
vala_method_class_init (ValaMethodClass * klass)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_adjust_private_offset (klass, &ValaMethod_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_method_real_get_error_types;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}

static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}

static void
vala_method_instance_init (ValaMethod * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = vala_method_get_instance_private (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}

static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_iterable_unref0 (self->error_types);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}

/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		ValaMethod_private_offset = g_type_add_instance_private (vala_method_type_id, sizeof (ValaMethodPrivate));
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}

