/* valabinaryexpression.c generated by valac, the Vala compiler
 * generated from valabinaryexpression.vala, do not modify */

/* valabinaryexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include "vala.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib-object.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaBinaryExpressionPrivate {
	ValaBinaryOperator _operator;
	gboolean _is_chained;
	ValaExpression* _left;
	ValaExpression* _right;
};

static gint ValaBinaryExpression_private_offset;
static gpointer vala_binary_expression_parent_class = NULL;

static void vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                            gboolean value);
static void vala_binary_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node);
static gchar* vala_binary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_binary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_binary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_binary_expression_real_is_non_null (ValaExpression* base);
static gboolean vala_binary_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym);
static void vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                                  ValaCollection* collection,
                                                  ValaSourceReference* source_reference);
static gboolean vala_binary_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_binary_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection);
static void vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_binary_expression_finalize (ValaCodeNode * obj);

static inline gpointer
vala_binary_expression_get_instance_private (ValaBinaryExpression* self)
{
	return G_STRUCT_MEMBER_P (self, ValaBinaryExpression_private_offset);
}

/**
 * Creates a new binary expression.
 *
 * @param op      binary operator
 * @param _left   left operand
 * @param _right  right operand
 * @param source  reference to source code
 * @return        newly created binary expression
 */
ValaBinaryExpression*
vala_binary_expression_construct (GType object_type,
                                  ValaBinaryOperator op,
                                  ValaExpression* _left,
                                  ValaExpression* _right,
                                  ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, FALSE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new (ValaBinaryOperator op,
                            ValaExpression* _left,
                            ValaExpression* _right,
                            ValaSourceReference* source)
{
	return vala_binary_expression_construct (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

ValaBinaryExpression*
vala_binary_expression_construct_chained (GType object_type,
                                          ValaBinaryOperator op,
                                          ValaExpression* _left,
                                          ValaExpression* _right,
                                          ValaSourceReference* source)
{
	ValaBinaryExpression* self = NULL;
	g_return_val_if_fail (_left != NULL, NULL);
	g_return_val_if_fail (_right != NULL, NULL);
	self = (ValaBinaryExpression*) vala_expression_construct (object_type);
	vala_binary_expression_set_operator (self, op);
	vala_binary_expression_set_left (self, _left);
	vala_binary_expression_set_right (self, _right);
	vala_binary_expression_set_is_chained (self, TRUE);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}

ValaBinaryExpression*
vala_binary_expression_new_chained (ValaBinaryOperator op,
                                    ValaExpression* _left,
                                    ValaExpression* _right,
                                    ValaSourceReference* source)
{
	return vala_binary_expression_construct_chained (VALA_TYPE_BINARY_EXPRESSION, op, _left, _right, source);
}

static void
vala_binary_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_binary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}

static void
vala_binary_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
}

static void
vala_binary_expression_real_replace_expression (ValaCodeNode* base,
                                                ValaExpression* old_node,
                                                ValaExpression* new_node)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_binary_expression_set_left (self, new_node);
	}
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_binary_expression_set_right (self, new_node);
	}
}

static gchar*
vala_binary_expression_real_to_string (ValaCodeNode* base)
{
	ValaBinaryExpression * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	ValaBinaryOperator _tmp3_;
	const gchar* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	self = (ValaBinaryExpression*) base;
	_tmp0_ = self->priv->_left;
	_tmp1_ = vala_code_node_to_string ((ValaCodeNode*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->_operator;
	_tmp4_ = vala_binary_operator_to_string (_tmp3_);
	_tmp5_ = self->priv->_right;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf ("(%s %s %s)", _tmp2_, _tmp4_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp2_);
	result = _tmp9_;
	return result;
}

static gboolean
vala_binary_expression_real_is_constant (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_constant (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_constant (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_pure (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_pure (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_pure (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_non_null (ValaExpression* base)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_non_null (_tmp2_)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_non_null (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static gboolean
vala_binary_expression_real_is_accessible (ValaExpression* base,
                                           ValaSymbol* sym)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_binary_expression_get_left (self);
	_tmp2_ = _tmp1_;
	if (vala_expression_is_accessible (_tmp2_, sym)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_binary_expression_get_right (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_expression_is_accessible (_tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
vala_binary_expression_real_get_error_types (ValaCodeNode* base,
                                             ValaCollection* collection,
                                             ValaSourceReference* source_reference)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp1_, collection, source_reference);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_error_types ((ValaCodeNode*) _tmp3_, collection, source_reference);
}

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gboolean
vala_binary_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaBinaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSemanticAnalyzer* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaBinaryOperator _tmp126_;
	gboolean _tmp318_ = FALSE;
	gboolean _tmp319_ = FALSE;
	ValaDataType* _tmp320_;
	ValaDataType* _tmp321_;
	ValaExpression* _tmp341_;
	ValaExpression* _tmp342_;
	gboolean _tmp343_ = FALSE;
	gboolean _tmp344_ = FALSE;
	ValaExpression* _tmp345_;
	ValaExpression* _tmp346_;
	ValaDataType* _tmp347_;
	ValaDataType* _tmp348_;
	ValaExpression* _tmp366_;
	ValaExpression* _tmp367_;
	gboolean _tmp368_ = FALSE;
	gboolean _tmp369_ = FALSE;
	ValaExpression* _tmp370_;
	ValaExpression* _tmp371_;
	ValaDataType* _tmp372_;
	ValaDataType* _tmp373_;
	gboolean _tmp391_ = FALSE;
	ValaExpression* _tmp392_;
	ValaExpression* _tmp393_;
	ValaExpression* _tmp396_;
	ValaExpression* _tmp397_;
	ValaDataType* _tmp398_;
	ValaDataType* _tmp399_;
	gboolean _tmp404_ = FALSE;
	ValaBinaryOperator _tmp405_;
	ValaExpression* _tmp414_;
	ValaExpression* _tmp415_;
	ValaDataType* _tmp416_;
	ValaDataType* _tmp417_;
	ValaExpression* _tmp430_;
	ValaExpression* _tmp431_;
	ValaDataType* _tmp432_;
	ValaDataType* _tmp433_;
	ValaExpression* _tmp446_;
	ValaExpression* _tmp447_;
	ValaExpression* _tmp448_;
	ValaExpression* _tmp449_;
	ValaDataType* _tmp450_;
	ValaDataType* _tmp451_;
	ValaDataType* _tmp452_;
	ValaDataType* _tmp453_;
	ValaExpression* _tmp454_;
	ValaExpression* _tmp455_;
	ValaDataType* _tmp456_;
	ValaDataType* _tmp457_;
	ValaExpression* _tmp458_;
	ValaExpression* _tmp459_;
	ValaExpression* _tmp460_;
	ValaExpression* _tmp461_;
	ValaDataType* _tmp462_;
	ValaDataType* _tmp463_;
	ValaDataType* _tmp464_;
	ValaDataType* _tmp465_;
	ValaExpression* _tmp466_;
	ValaExpression* _tmp467_;
	ValaDataType* _tmp468_;
	ValaDataType* _tmp469_;
	gboolean _tmp470_ = FALSE;
	ValaExpression* _tmp471_;
	ValaExpression* _tmp472_;
	ValaDataType* _tmp473_;
	ValaDataType* _tmp474_;
	ValaTypeSymbol* _tmp475_;
	ValaTypeSymbol* _tmp476_;
	ValaSemanticAnalyzer* _tmp477_;
	ValaSemanticAnalyzer* _tmp478_;
	ValaDataType* _tmp479_;
	ValaTypeSymbol* _tmp480_;
	ValaTypeSymbol* _tmp481_;
	gboolean _tmp1035_;
	gboolean _tmp1036_;
	self = (ValaBinaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = vala_code_context_get_analyzer (context);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_semantic_analyzer_get_current_symbol (_tmp6_);
	_tmp8_ = _tmp7_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_BLOCK)) {
		gboolean _tmp9_ = FALSE;
		ValaBinaryOperator _tmp10_;
		_tmp10_ = self->priv->_operator;
		if (_tmp10_ == VALA_BINARY_OPERATOR_AND) {
			_tmp9_ = TRUE;
		} else {
			ValaBinaryOperator _tmp11_;
			_tmp11_ = self->priv->_operator;
			_tmp9_ = _tmp11_ == VALA_BINARY_OPERATOR_OR;
		}
		_tmp4_ = _tmp9_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaLocalVariable* local = NULL;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaDataType* _tmp14_;
		ValaDataType* _tmp15_;
		ValaDataType* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaLocalVariable* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp23_;
		ValaSourceReference* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaDeclarationStatement* _tmp26_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaMemberAccess* _tmp34_;
		ValaMemberAccess* _tmp35_;
		ValaExpression* _tmp36_;
		ValaExpression* _tmp37_;
		ValaExpression* _tmp38_;
		ValaExpression* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaAssignment* _tmp42_;
		ValaAssignment* _tmp43_;
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaSourceReference* _tmp46_;
		ValaSourceReference* _tmp47_;
		ValaExpressionStatement* _tmp48_;
		ValaExpressionStatement* _tmp49_;
		ValaExpressionStatement* stmt = NULL;
		ValaLocalVariable* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		ValaExpression* _tmp53_;
		ValaExpression* _tmp54_;
		ValaSourceReference* _tmp55_;
		ValaSourceReference* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaMemberAccess* _tmp58_;
		ValaBinaryOperator _tmp59_;
		ValaExpression* _tmp60_;
		ValaExpression* _tmp61_;
		ValaSourceReference* _tmp62_;
		ValaSourceReference* _tmp63_;
		ValaBooleanLiteral* _tmp64_;
		ValaBooleanLiteral* _tmp65_;
		ValaExpression* _tmp66_;
		ValaExpression* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaSourceReference* _tmp69_;
		ValaAssignment* _tmp70_;
		ValaAssignment* _tmp71_;
		ValaExpression* _tmp72_;
		ValaExpression* _tmp73_;
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		ValaExpressionStatement* _tmp76_;
		ValaExpressionStatement* _tmp77_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp78_;
		ValaSourceReference* _tmp79_;
		ValaBlock* _tmp80_;
		ValaBlock* false_block = NULL;
		ValaSourceReference* _tmp81_;
		ValaSourceReference* _tmp82_;
		ValaBlock* _tmp83_;
		ValaBinaryOperator _tmp84_;
		ValaIfStatement* if_stmt = NULL;
		ValaExpression* _tmp93_;
		ValaExpression* _tmp94_;
		ValaBlock* _tmp95_;
		ValaBlock* _tmp96_;
		ValaSourceReference* _tmp97_;
		ValaSourceReference* _tmp98_;
		ValaIfStatement* _tmp99_;
		ValaSemanticAnalyzer* _tmp100_;
		ValaSemanticAnalyzer* _tmp101_;
		ValaBlock* _tmp102_;
		ValaDeclarationStatement* _tmp103_;
		ValaSemanticAnalyzer* _tmp104_;
		ValaSemanticAnalyzer* _tmp105_;
		ValaBlock* _tmp106_;
		ValaIfStatement* _tmp107_;
		ValaDeclarationStatement* _tmp108_;
		ValaIfStatement* _tmp109_;
		ValaMemberAccess* ma = NULL;
		ValaLocalVariable* _tmp110_;
		const gchar* _tmp111_;
		const gchar* _tmp112_;
		ValaSourceReference* _tmp113_;
		ValaSourceReference* _tmp114_;
		ValaMemberAccess* _tmp115_;
		ValaMemberAccess* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		ValaMemberAccess* _tmp119_;
		ValaDataType* _tmp120_;
		ValaDataType* _tmp121_;
		ValaCodeNode* _tmp122_;
		ValaCodeNode* _tmp123_;
		ValaMemberAccess* _tmp124_;
		ValaMemberAccess* _tmp125_;
		_tmp12_ = vala_code_context_get_analyzer (context);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_->bool_type;
		_tmp15_ = vala_data_type_copy (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_code_node_get_temp_name ();
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_local_variable_new (_tmp16_, _tmp18_, NULL, _tmp20_);
		_tmp22_ = _tmp21_;
		_g_free0 (_tmp18_);
		_vala_code_node_unref0 (_tmp16_);
		local = _tmp22_;
		_tmp23_ = local;
		_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
		decl = _tmp26_;
		_tmp27_ = local;
		_tmp28_ = vala_symbol_get_name ((ValaSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_binary_expression_get_right (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_member_access_new_simple (_tmp29_, _tmp33_);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_binary_expression_get_right (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_binary_expression_get_right (self);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_assignment_new ((ValaExpression*) _tmp35_, _tmp37_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_binary_expression_get_right (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = vala_expression_statement_new ((ValaExpression*) _tmp43_, _tmp47_);
		_tmp49_ = _tmp48_;
		_vala_code_node_unref0 (_tmp43_);
		_vala_code_node_unref0 (_tmp35_);
		right_stmt = _tmp49_;
		_tmp50_ = local;
		_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_binary_expression_get_left (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_member_access_new_simple (_tmp52_, _tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = self->priv->_operator;
		_tmp60_ = vala_binary_expression_get_left (self);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = vala_boolean_literal_new (_tmp59_ == VALA_BINARY_OPERATOR_OR, _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_binary_expression_get_left (self);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp67_);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_assignment_new ((ValaExpression*) _tmp58_, (ValaExpression*) _tmp65_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_binary_expression_get_left (self);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
		_tmp75_ = _tmp74_;
		_tmp76_ = vala_expression_statement_new ((ValaExpression*) _tmp71_, _tmp75_);
		_tmp77_ = _tmp76_;
		_vala_code_node_unref0 (_tmp71_);
		_vala_code_node_unref0 (_tmp65_);
		_vala_code_node_unref0 (_tmp58_);
		stmt = _tmp77_;
		_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_block_new (_tmp79_);
		true_block = _tmp80_;
		_tmp81_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp82_ = _tmp81_;
		_tmp83_ = vala_block_new (_tmp82_);
		false_block = _tmp83_;
		_tmp84_ = self->priv->_operator;
		if (_tmp84_ == VALA_BINARY_OPERATOR_AND) {
			ValaBlock* _tmp85_;
			ValaExpressionStatement* _tmp86_;
			ValaBlock* _tmp87_;
			ValaExpressionStatement* _tmp88_;
			_tmp85_ = true_block;
			_tmp86_ = right_stmt;
			vala_block_add_statement (_tmp85_, (ValaStatement*) _tmp86_);
			_tmp87_ = false_block;
			_tmp88_ = stmt;
			vala_block_add_statement (_tmp87_, (ValaStatement*) _tmp88_);
		} else {
			ValaBlock* _tmp89_;
			ValaExpressionStatement* _tmp90_;
			ValaBlock* _tmp91_;
			ValaExpressionStatement* _tmp92_;
			_tmp89_ = true_block;
			_tmp90_ = stmt;
			vala_block_add_statement (_tmp89_, (ValaStatement*) _tmp90_);
			_tmp91_ = false_block;
			_tmp92_ = right_stmt;
			vala_block_add_statement (_tmp91_, (ValaStatement*) _tmp92_);
		}
		_tmp93_ = vala_binary_expression_get_left (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = true_block;
		_tmp96_ = false_block;
		_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp98_ = _tmp97_;
		_tmp99_ = vala_if_statement_new (_tmp94_, _tmp95_, _tmp96_, _tmp98_);
		if_stmt = _tmp99_;
		_tmp100_ = vala_code_context_get_analyzer (context);
		_tmp101_ = _tmp100_;
		_tmp102_ = _tmp101_->insert_block;
		_tmp103_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp102_, (ValaStatement*) _tmp103_);
		_tmp104_ = vala_code_context_get_analyzer (context);
		_tmp105_ = _tmp104_;
		_tmp106_ = _tmp105_->insert_block;
		_tmp107_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp106_, (ValaStatement*) _tmp107_);
		_tmp108_ = decl;
		vala_code_node_check ((ValaCodeNode*) _tmp108_, context);
		_tmp109_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp109_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (stmt);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			return result;
		}
		_tmp110_ = local;
		_tmp111_ = vala_symbol_get_name ((ValaSymbol*) _tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_member_access_new_simple (_tmp112_, _tmp114_);
		ma = _tmp115_;
		_tmp116_ = ma;
		_tmp117_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp118_ = _tmp117_;
		vala_expression_set_target_type ((ValaExpression*) _tmp116_, _tmp118_);
		_tmp119_ = ma;
		_tmp120_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
		_tmp121_ = _tmp120_;
		vala_expression_set_formal_target_type ((ValaExpression*) _tmp119_, _tmp121_);
		_tmp122_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp123_ = _tmp122_;
		_tmp124_ = ma;
		vala_code_node_replace_expression (_tmp123_, (ValaExpression*) self, (ValaExpression*) _tmp124_);
		_tmp125_ = ma;
		vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
		result = TRUE;
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (stmt);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		return result;
	}
	_tmp126_ = self->priv->_operator;
	if (_tmp126_ == VALA_BINARY_OPERATOR_COALESCE) {
		ValaExpression* _tmp127_;
		ValaExpression* _tmp128_;
		ValaExpression* _tmp129_;
		ValaExpression* _tmp130_;
		ValaDataType* local_type = NULL;
		gboolean cast_non_null = FALSE;
		gboolean _tmp131_ = FALSE;
		ValaExpression* _tmp132_;
		ValaExpression* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaLocalVariable* local = NULL;
		ValaDataType* _tmp218_;
		gchar* _tmp219_;
		gchar* _tmp220_;
		ValaExpression* _tmp221_;
		ValaExpression* _tmp222_;
		ValaSourceReference* _tmp223_;
		ValaSourceReference* _tmp224_;
		ValaLocalVariable* _tmp225_;
		ValaLocalVariable* _tmp226_;
		ValaDeclarationStatement* decl = NULL;
		ValaLocalVariable* _tmp227_;
		ValaSourceReference* _tmp228_;
		ValaSourceReference* _tmp229_;
		ValaDeclarationStatement* _tmp230_;
		ValaExpressionStatement* right_stmt = NULL;
		ValaLocalVariable* _tmp231_;
		const gchar* _tmp232_;
		const gchar* _tmp233_;
		ValaExpression* _tmp234_;
		ValaExpression* _tmp235_;
		ValaSourceReference* _tmp236_;
		ValaSourceReference* _tmp237_;
		ValaMemberAccess* _tmp238_;
		ValaMemberAccess* _tmp239_;
		ValaExpression* _tmp240_;
		ValaExpression* _tmp241_;
		ValaExpression* _tmp242_;
		ValaExpression* _tmp243_;
		ValaSourceReference* _tmp244_;
		ValaSourceReference* _tmp245_;
		ValaAssignment* _tmp246_;
		ValaAssignment* _tmp247_;
		ValaExpression* _tmp248_;
		ValaExpression* _tmp249_;
		ValaSourceReference* _tmp250_;
		ValaSourceReference* _tmp251_;
		ValaExpressionStatement* _tmp252_;
		ValaExpressionStatement* _tmp253_;
		ValaBlock* true_block = NULL;
		ValaSourceReference* _tmp254_;
		ValaSourceReference* _tmp255_;
		ValaBlock* _tmp256_;
		ValaBlock* _tmp257_;
		ValaExpressionStatement* _tmp258_;
		ValaBinaryExpression* cond = NULL;
		ValaLocalVariable* _tmp259_;
		const gchar* _tmp260_;
		const gchar* _tmp261_;
		ValaExpression* _tmp262_;
		ValaExpression* _tmp263_;
		ValaSourceReference* _tmp264_;
		ValaSourceReference* _tmp265_;
		ValaMemberAccess* _tmp266_;
		ValaMemberAccess* _tmp267_;
		ValaSourceReference* _tmp268_;
		ValaSourceReference* _tmp269_;
		ValaNullLiteral* _tmp270_;
		ValaNullLiteral* _tmp271_;
		ValaSourceReference* _tmp272_;
		ValaSourceReference* _tmp273_;
		ValaBinaryExpression* _tmp274_;
		ValaBinaryExpression* _tmp275_;
		ValaIfStatement* if_stmt = NULL;
		ValaBinaryExpression* _tmp276_;
		ValaBlock* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaIfStatement* _tmp280_;
		ValaSemanticAnalyzer* _tmp281_;
		ValaSemanticAnalyzer* _tmp282_;
		ValaBlock* _tmp283_;
		ValaDeclarationStatement* _tmp284_;
		ValaSemanticAnalyzer* _tmp285_;
		ValaSemanticAnalyzer* _tmp286_;
		ValaBlock* _tmp287_;
		ValaIfStatement* _tmp288_;
		ValaDeclarationStatement* _tmp289_;
		ValaIfStatement* _tmp290_;
		ValaExpression* replace_expr = NULL;
		ValaLocalVariable* _tmp291_;
		ValaDataType* _tmp292_;
		ValaDataType* _tmp293_;
		ValaExpression* _tmp294_;
		gboolean _tmp295_ = FALSE;
		ValaCodeNode* _tmp314_;
		ValaCodeNode* _tmp315_;
		ValaExpression* _tmp316_;
		ValaExpression* _tmp317_;
		_tmp127_ = vala_binary_expression_get_left (self);
		_tmp128_ = _tmp127_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp128_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		_tmp129_ = vala_binary_expression_get_right (self);
		_tmp130_ = _tmp129_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp130_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
		local_type = NULL;
		cast_non_null = FALSE;
		_tmp132_ = vala_binary_expression_get_left (self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_expression_get_value_type (_tmp133_);
		_tmp135_ = _tmp134_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp135_, VALA_TYPE_NULL_TYPE)) {
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaDataType* _tmp138_;
			ValaDataType* _tmp139_;
			_tmp136_ = vala_binary_expression_get_right (self);
			_tmp137_ = _tmp136_;
			_tmp138_ = vala_expression_get_value_type (_tmp137_);
			_tmp139_ = _tmp138_;
			_tmp131_ = _tmp139_ != NULL;
		} else {
			_tmp131_ = FALSE;
		}
		if (_tmp131_) {
			ValaExpression* _tmp140_;
			ValaExpression* _tmp141_;
			ValaSourceReference* _tmp142_;
			ValaSourceReference* _tmp143_;
			ValaExpression* _tmp144_;
			ValaExpression* _tmp145_;
			ValaDataType* _tmp146_;
			ValaDataType* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaExpression* _tmp150_;
			ValaExpression* _tmp151_;
			ValaDataType* _tmp152_;
			ValaDataType* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp140_ = vala_binary_expression_get_left (self);
			_tmp141_ = _tmp140_;
			_tmp142_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_warning (_tmp143_, "left operand is always null");
			_tmp144_ = vala_binary_expression_get_right (self);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_expression_get_value_type (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_data_type_copy (_tmp147_);
			_vala_code_node_unref0 (local_type);
			local_type = _tmp148_;
			_tmp149_ = local_type;
			vala_data_type_set_nullable (_tmp149_, TRUE);
			_tmp150_ = vala_binary_expression_get_right (self);
			_tmp151_ = _tmp150_;
			_tmp152_ = vala_expression_get_value_type (_tmp151_);
			_tmp153_ = _tmp152_;
			_tmp154_ = vala_data_type_get_nullable (_tmp153_);
			_tmp155_ = _tmp154_;
			if (!_tmp155_) {
				cast_non_null = TRUE;
			}
		} else {
			ValaExpression* _tmp156_;
			ValaExpression* _tmp157_;
			ValaDataType* _tmp158_;
			ValaDataType* _tmp159_;
			_tmp156_ = vala_binary_expression_get_left (self);
			_tmp157_ = _tmp156_;
			_tmp158_ = vala_expression_get_value_type (_tmp157_);
			_tmp159_ = _tmp158_;
			if (_tmp159_ != NULL) {
				ValaExpression* _tmp160_;
				ValaExpression* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				ValaDataType* _tmp164_;
				gboolean _tmp165_ = FALSE;
				ValaExpression* _tmp166_;
				ValaExpression* _tmp167_;
				ValaDataType* _tmp168_;
				ValaDataType* _tmp169_;
				gboolean _tmp177_;
				gboolean _tmp178_;
				_tmp160_ = vala_binary_expression_get_left (self);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_expression_get_value_type (_tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = vala_data_type_copy (_tmp163_);
				_vala_code_node_unref0 (local_type);
				local_type = _tmp164_;
				_tmp166_ = vala_binary_expression_get_right (self);
				_tmp167_ = _tmp166_;
				_tmp168_ = vala_expression_get_value_type (_tmp167_);
				_tmp169_ = _tmp168_;
				if (_tmp169_ != NULL) {
					ValaExpression* _tmp170_;
					ValaExpression* _tmp171_;
					ValaDataType* _tmp172_;
					ValaDataType* _tmp173_;
					gboolean _tmp174_;
					gboolean _tmp175_;
					_tmp170_ = vala_binary_expression_get_right (self);
					_tmp171_ = _tmp170_;
					_tmp172_ = vala_expression_get_value_type (_tmp171_);
					_tmp173_ = _tmp172_;
					_tmp174_ = vala_data_type_get_value_owned (_tmp173_);
					_tmp175_ = _tmp174_;
					_tmp165_ = _tmp175_;
				} else {
					_tmp165_ = FALSE;
				}
				if (_tmp165_) {
					ValaDataType* _tmp176_;
					_tmp176_ = local_type;
					vala_data_type_set_value_owned (_tmp176_, TRUE);
				}
				_tmp177_ = vala_code_context_get_experimental_non_null (context);
				_tmp178_ = _tmp177_;
				if (_tmp178_) {
					ValaDataType* _tmp179_;
					gboolean _tmp180_;
					gboolean _tmp181_;
					_tmp179_ = local_type;
					_tmp180_ = vala_data_type_get_nullable (_tmp179_);
					_tmp181_ = _tmp180_;
					if (!_tmp181_) {
						ValaExpression* _tmp182_;
						ValaExpression* _tmp183_;
						ValaSourceReference* _tmp184_;
						ValaSourceReference* _tmp185_;
						gboolean _tmp186_ = FALSE;
						ValaExpression* _tmp187_;
						ValaExpression* _tmp188_;
						ValaDataType* _tmp189_;
						ValaDataType* _tmp190_;
						_tmp182_ = vala_binary_expression_get_left (self);
						_tmp183_ = _tmp182_;
						_tmp184_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp183_);
						_tmp185_ = _tmp184_;
						vala_report_warning (_tmp185_, "left operand is never null");
						_tmp187_ = vala_binary_expression_get_right (self);
						_tmp188_ = _tmp187_;
						_tmp189_ = vala_expression_get_value_type (_tmp188_);
						_tmp190_ = _tmp189_;
						if (_tmp190_ != NULL) {
							ValaExpression* _tmp191_;
							ValaExpression* _tmp192_;
							ValaDataType* _tmp193_;
							ValaDataType* _tmp194_;
							gboolean _tmp195_;
							gboolean _tmp196_;
							_tmp191_ = vala_binary_expression_get_right (self);
							_tmp192_ = _tmp191_;
							_tmp193_ = vala_expression_get_value_type (_tmp192_);
							_tmp194_ = _tmp193_;
							_tmp195_ = vala_data_type_get_nullable (_tmp194_);
							_tmp196_ = _tmp195_;
							_tmp186_ = _tmp196_;
						} else {
							_tmp186_ = FALSE;
						}
						if (_tmp186_) {
							ValaDataType* _tmp197_;
							_tmp197_ = local_type;
							vala_data_type_set_nullable (_tmp197_, TRUE);
							cast_non_null = TRUE;
						}
					} else {
						gboolean _tmp198_ = FALSE;
						ValaExpression* _tmp199_;
						ValaExpression* _tmp200_;
						ValaDataType* _tmp201_;
						ValaDataType* _tmp202_;
						_tmp199_ = vala_binary_expression_get_right (self);
						_tmp200_ = _tmp199_;
						_tmp201_ = vala_expression_get_value_type (_tmp200_);
						_tmp202_ = _tmp201_;
						if (_tmp202_ != NULL) {
							ValaExpression* _tmp203_;
							ValaExpression* _tmp204_;
							ValaDataType* _tmp205_;
							ValaDataType* _tmp206_;
							gboolean _tmp207_;
							gboolean _tmp208_;
							_tmp203_ = vala_binary_expression_get_right (self);
							_tmp204_ = _tmp203_;
							_tmp205_ = vala_expression_get_value_type (_tmp204_);
							_tmp206_ = _tmp205_;
							_tmp207_ = vala_data_type_get_nullable (_tmp206_);
							_tmp208_ = _tmp207_;
							_tmp198_ = !_tmp208_;
						} else {
							_tmp198_ = FALSE;
						}
						if (_tmp198_) {
							cast_non_null = TRUE;
						}
					}
				}
			} else {
				ValaExpression* _tmp209_;
				ValaExpression* _tmp210_;
				ValaDataType* _tmp211_;
				ValaDataType* _tmp212_;
				_tmp209_ = vala_binary_expression_get_right (self);
				_tmp210_ = _tmp209_;
				_tmp211_ = vala_expression_get_value_type (_tmp210_);
				_tmp212_ = _tmp211_;
				if (_tmp212_ != NULL) {
					ValaExpression* _tmp213_;
					ValaExpression* _tmp214_;
					ValaDataType* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					_tmp213_ = vala_binary_expression_get_right (self);
					_tmp214_ = _tmp213_;
					_tmp215_ = vala_expression_get_value_type (_tmp214_);
					_tmp216_ = _tmp215_;
					_tmp217_ = vala_data_type_copy (_tmp216_);
					_vala_code_node_unref0 (local_type);
					local_type = _tmp217_;
				}
			}
		}
		_tmp218_ = local_type;
		_tmp219_ = vala_code_node_get_temp_name ();
		_tmp220_ = _tmp219_;
		_tmp221_ = vala_binary_expression_get_left (self);
		_tmp222_ = _tmp221_;
		_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp224_ = _tmp223_;
		_tmp225_ = vala_local_variable_new (_tmp218_, _tmp220_, _tmp222_, _tmp224_);
		_tmp226_ = _tmp225_;
		_g_free0 (_tmp220_);
		local = _tmp226_;
		_tmp227_ = local;
		_tmp228_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp229_ = _tmp228_;
		_tmp230_ = vala_declaration_statement_new ((ValaSymbol*) _tmp227_, _tmp229_);
		decl = _tmp230_;
		_tmp231_ = local;
		_tmp232_ = vala_symbol_get_name ((ValaSymbol*) _tmp231_);
		_tmp233_ = _tmp232_;
		_tmp234_ = vala_binary_expression_get_right (self);
		_tmp235_ = _tmp234_;
		_tmp236_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp235_);
		_tmp237_ = _tmp236_;
		_tmp238_ = vala_member_access_new_simple (_tmp233_, _tmp237_);
		_tmp239_ = _tmp238_;
		_tmp240_ = vala_binary_expression_get_right (self);
		_tmp241_ = _tmp240_;
		_tmp242_ = vala_binary_expression_get_right (self);
		_tmp243_ = _tmp242_;
		_tmp244_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp243_);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_assignment_new ((ValaExpression*) _tmp239_, _tmp241_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp245_);
		_tmp247_ = _tmp246_;
		_tmp248_ = vala_binary_expression_get_right (self);
		_tmp249_ = _tmp248_;
		_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
		_tmp251_ = _tmp250_;
		_tmp252_ = vala_expression_statement_new ((ValaExpression*) _tmp247_, _tmp251_);
		_tmp253_ = _tmp252_;
		_vala_code_node_unref0 (_tmp247_);
		_vala_code_node_unref0 (_tmp239_);
		right_stmt = _tmp253_;
		_tmp254_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_block_new (_tmp255_);
		true_block = _tmp256_;
		_tmp257_ = true_block;
		_tmp258_ = right_stmt;
		vala_block_add_statement (_tmp257_, (ValaStatement*) _tmp258_);
		_tmp259_ = local;
		_tmp260_ = vala_symbol_get_name ((ValaSymbol*) _tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = vala_binary_expression_get_left (self);
		_tmp263_ = _tmp262_;
		_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
		_tmp265_ = _tmp264_;
		_tmp266_ = vala_member_access_new_simple (_tmp261_, _tmp265_);
		_tmp267_ = _tmp266_;
		_tmp268_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = vala_null_literal_new (_tmp269_);
		_tmp271_ = _tmp270_;
		_tmp272_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp273_ = _tmp272_;
		_tmp274_ = vala_binary_expression_new (VALA_BINARY_OPERATOR_EQUALITY, (ValaExpression*) _tmp267_, (ValaExpression*) _tmp271_, _tmp273_);
		_tmp275_ = _tmp274_;
		_vala_code_node_unref0 (_tmp271_);
		_vala_code_node_unref0 (_tmp267_);
		cond = _tmp275_;
		_tmp276_ = cond;
		_tmp277_ = true_block;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_if_statement_new ((ValaExpression*) _tmp276_, _tmp277_, NULL, _tmp279_);
		if_stmt = _tmp280_;
		_tmp281_ = vala_code_context_get_analyzer (context);
		_tmp282_ = _tmp281_;
		_tmp283_ = _tmp282_->insert_block;
		_tmp284_ = decl;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp283_, (ValaStatement*) _tmp284_);
		_tmp285_ = vala_code_context_get_analyzer (context);
		_tmp286_ = _tmp285_;
		_tmp287_ = _tmp286_->insert_block;
		_tmp288_ = if_stmt;
		vala_expression_insert_statement ((ValaExpression*) self, _tmp287_, (ValaStatement*) _tmp288_);
		_tmp289_ = decl;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp289_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp290_ = if_stmt;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp290_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (cond);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (right_stmt);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_vala_code_node_unref0 (local_type);
			return result;
		}
		_tmp291_ = local;
		_tmp292_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp293_ = _tmp292_;
		_tmp294_ = vala_semantic_analyzer_create_temp_access (_tmp291_, _tmp293_);
		replace_expr = _tmp294_;
		if (cast_non_null) {
			ValaExpression* _tmp296_;
			ValaDataType* _tmp297_;
			ValaDataType* _tmp298_;
			_tmp296_ = replace_expr;
			_tmp297_ = vala_expression_get_target_type (_tmp296_);
			_tmp298_ = _tmp297_;
			_tmp295_ = _tmp298_ != NULL;
		} else {
			_tmp295_ = FALSE;
		}
		if (_tmp295_) {
			ValaCastExpression* cast = NULL;
			ValaExpression* _tmp299_;
			ValaSourceReference* _tmp300_;
			ValaSourceReference* _tmp301_;
			ValaCastExpression* _tmp302_;
			ValaCastExpression* _tmp303_;
			ValaExpression* _tmp304_;
			ValaDataType* _tmp305_;
			ValaDataType* _tmp306_;
			ValaDataType* _tmp307_;
			ValaDataType* _tmp308_;
			ValaCastExpression* _tmp309_;
			ValaDataType* _tmp310_;
			ValaDataType* _tmp311_;
			ValaCastExpression* _tmp312_;
			ValaExpression* _tmp313_;
			_tmp299_ = replace_expr;
			_tmp300_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = vala_cast_expression_new_non_null (_tmp299_, _tmp301_);
			cast = _tmp302_;
			_tmp303_ = cast;
			_tmp304_ = replace_expr;
			_tmp305_ = vala_expression_get_target_type (_tmp304_);
			_tmp306_ = _tmp305_;
			_tmp307_ = vala_data_type_copy (_tmp306_);
			_tmp308_ = _tmp307_;
			vala_expression_set_target_type ((ValaExpression*) _tmp303_, _tmp308_);
			_vala_code_node_unref0 (_tmp308_);
			_tmp309_ = cast;
			_tmp310_ = vala_expression_get_target_type ((ValaExpression*) _tmp309_);
			_tmp311_ = _tmp310_;
			vala_data_type_set_nullable (_tmp311_, FALSE);
			_tmp312_ = cast;
			_tmp313_ = _vala_code_node_ref0 ((ValaExpression*) _tmp312_);
			_vala_code_node_unref0 (replace_expr);
			replace_expr = _tmp313_;
			_vala_code_node_unref0 (cast);
		}
		_tmp314_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp315_ = _tmp314_;
		_tmp316_ = replace_expr;
		vala_code_node_replace_expression (_tmp315_, (ValaExpression*) self, _tmp316_);
		_tmp317_ = replace_expr;
		vala_code_node_check ((ValaCodeNode*) _tmp317_, context);
		result = TRUE;
		_vala_code_node_unref0 (replace_expr);
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (cond);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (right_stmt);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_vala_code_node_unref0 (local_type);
		return result;
	}
	_tmp320_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp321_ = _tmp320_;
	if (_tmp321_ != NULL) {
		ValaDataType* _tmp322_;
		ValaDataType* _tmp323_;
		ValaTypeSymbol* _tmp324_;
		ValaTypeSymbol* _tmp325_;
		_tmp322_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp323_ = _tmp322_;
		_tmp324_ = vala_data_type_get_data_type (_tmp323_);
		_tmp325_ = _tmp324_;
		_tmp319_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp325_, VALA_TYPE_ENUM);
	} else {
		_tmp319_ = FALSE;
	}
	if (_tmp319_) {
		gboolean _tmp326_ = FALSE;
		ValaBinaryOperator _tmp327_;
		_tmp327_ = self->priv->_operator;
		if (_tmp327_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
			_tmp326_ = TRUE;
		} else {
			ValaBinaryOperator _tmp328_;
			_tmp328_ = self->priv->_operator;
			_tmp326_ = _tmp328_ == VALA_BINARY_OPERATOR_BITWISE_OR;
		}
		_tmp318_ = _tmp326_;
	} else {
		_tmp318_ = FALSE;
	}
	if (_tmp318_) {
		ValaExpression* _tmp329_;
		ValaExpression* _tmp330_;
		ValaDataType* _tmp331_;
		ValaDataType* _tmp332_;
		ValaDataType* _tmp333_;
		ValaDataType* _tmp334_;
		ValaExpression* _tmp335_;
		ValaExpression* _tmp336_;
		ValaDataType* _tmp337_;
		ValaDataType* _tmp338_;
		ValaDataType* _tmp339_;
		ValaDataType* _tmp340_;
		_tmp329_ = vala_binary_expression_get_left (self);
		_tmp330_ = _tmp329_;
		_tmp331_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp332_ = _tmp331_;
		_tmp333_ = vala_data_type_copy (_tmp332_);
		_tmp334_ = _tmp333_;
		vala_expression_set_target_type (_tmp330_, _tmp334_);
		_vala_code_node_unref0 (_tmp334_);
		_tmp335_ = vala_binary_expression_get_right (self);
		_tmp336_ = _tmp335_;
		_tmp337_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp338_ = _tmp337_;
		_tmp339_ = vala_data_type_copy (_tmp338_);
		_tmp340_ = _tmp339_;
		vala_expression_set_target_type (_tmp336_, _tmp340_);
		_vala_code_node_unref0 (_tmp340_);
	}
	_tmp341_ = vala_binary_expression_get_left (self);
	_tmp342_ = _tmp341_;
	vala_code_node_check ((ValaCodeNode*) _tmp342_, context);
	_tmp345_ = vala_binary_expression_get_left (self);
	_tmp346_ = _tmp345_;
	_tmp347_ = vala_expression_get_value_type (_tmp346_);
	_tmp348_ = _tmp347_;
	if (_tmp348_ != NULL) {
		ValaExpression* _tmp349_;
		ValaExpression* _tmp350_;
		ValaDataType* _tmp351_;
		ValaDataType* _tmp352_;
		ValaTypeSymbol* _tmp353_;
		ValaTypeSymbol* _tmp354_;
		_tmp349_ = vala_binary_expression_get_left (self);
		_tmp350_ = _tmp349_;
		_tmp351_ = vala_expression_get_value_type (_tmp350_);
		_tmp352_ = _tmp351_;
		_tmp353_ = vala_data_type_get_data_type (_tmp352_);
		_tmp354_ = _tmp353_;
		_tmp344_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp354_, VALA_TYPE_ENUM);
	} else {
		_tmp344_ = FALSE;
	}
	if (_tmp344_) {
		gboolean _tmp355_ = FALSE;
		ValaBinaryOperator _tmp356_;
		_tmp356_ = self->priv->_operator;
		if (_tmp356_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp355_ = TRUE;
		} else {
			ValaBinaryOperator _tmp357_;
			_tmp357_ = self->priv->_operator;
			_tmp355_ = _tmp357_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp343_ = _tmp355_;
	} else {
		_tmp343_ = FALSE;
	}
	if (_tmp343_) {
		ValaExpression* _tmp358_;
		ValaExpression* _tmp359_;
		ValaExpression* _tmp360_;
		ValaExpression* _tmp361_;
		ValaDataType* _tmp362_;
		ValaDataType* _tmp363_;
		ValaDataType* _tmp364_;
		ValaDataType* _tmp365_;
		_tmp358_ = vala_binary_expression_get_right (self);
		_tmp359_ = _tmp358_;
		_tmp360_ = vala_binary_expression_get_left (self);
		_tmp361_ = _tmp360_;
		_tmp362_ = vala_expression_get_value_type (_tmp361_);
		_tmp363_ = _tmp362_;
		_tmp364_ = vala_data_type_copy (_tmp363_);
		_tmp365_ = _tmp364_;
		vala_expression_set_target_type (_tmp359_, _tmp365_);
		_vala_code_node_unref0 (_tmp365_);
	}
	_tmp366_ = vala_binary_expression_get_right (self);
	_tmp367_ = _tmp366_;
	vala_code_node_check ((ValaCodeNode*) _tmp367_, context);
	_tmp370_ = vala_binary_expression_get_right (self);
	_tmp371_ = _tmp370_;
	_tmp372_ = vala_expression_get_value_type (_tmp371_);
	_tmp373_ = _tmp372_;
	if (_tmp373_ != NULL) {
		ValaExpression* _tmp374_;
		ValaExpression* _tmp375_;
		ValaDataType* _tmp376_;
		ValaDataType* _tmp377_;
		ValaTypeSymbol* _tmp378_;
		ValaTypeSymbol* _tmp379_;
		_tmp374_ = vala_binary_expression_get_right (self);
		_tmp375_ = _tmp374_;
		_tmp376_ = vala_expression_get_value_type (_tmp375_);
		_tmp377_ = _tmp376_;
		_tmp378_ = vala_data_type_get_data_type (_tmp377_);
		_tmp379_ = _tmp378_;
		_tmp369_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp379_, VALA_TYPE_ENUM);
	} else {
		_tmp369_ = FALSE;
	}
	if (_tmp369_) {
		gboolean _tmp380_ = FALSE;
		ValaBinaryOperator _tmp381_;
		_tmp381_ = self->priv->_operator;
		if (_tmp381_ == VALA_BINARY_OPERATOR_EQUALITY) {
			_tmp380_ = TRUE;
		} else {
			ValaBinaryOperator _tmp382_;
			_tmp382_ = self->priv->_operator;
			_tmp380_ = _tmp382_ == VALA_BINARY_OPERATOR_INEQUALITY;
		}
		_tmp368_ = _tmp380_;
	} else {
		_tmp368_ = FALSE;
	}
	if (_tmp368_) {
		ValaExpression* _tmp383_;
		ValaExpression* _tmp384_;
		ValaExpression* _tmp385_;
		ValaExpression* _tmp386_;
		ValaDataType* _tmp387_;
		ValaDataType* _tmp388_;
		ValaDataType* _tmp389_;
		ValaDataType* _tmp390_;
		_tmp383_ = vala_binary_expression_get_left (self);
		_tmp384_ = _tmp383_;
		_tmp385_ = vala_binary_expression_get_right (self);
		_tmp386_ = _tmp385_;
		_tmp387_ = vala_expression_get_value_type (_tmp386_);
		_tmp388_ = _tmp387_;
		_tmp389_ = vala_data_type_copy (_tmp388_);
		_tmp390_ = _tmp389_;
		vala_expression_set_target_type (_tmp384_, _tmp390_);
		_vala_code_node_unref0 (_tmp390_);
	}
	_tmp392_ = vala_binary_expression_get_left (self);
	_tmp393_ = _tmp392_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp393_, context)) {
		_tmp391_ = TRUE;
	} else {
		ValaExpression* _tmp394_;
		ValaExpression* _tmp395_;
		_tmp394_ = vala_binary_expression_get_right (self);
		_tmp395_ = _tmp394_;
		_tmp391_ = !vala_code_node_check ((ValaCodeNode*) _tmp395_, context);
	}
	if (_tmp391_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp396_ = vala_binary_expression_get_left (self);
	_tmp397_ = _tmp396_;
	_tmp398_ = vala_expression_get_value_type (_tmp397_);
	_tmp399_ = _tmp398_;
	if (_tmp399_ == NULL) {
		ValaExpression* _tmp400_;
		ValaExpression* _tmp401_;
		ValaSourceReference* _tmp402_;
		ValaSourceReference* _tmp403_;
		_tmp400_ = vala_binary_expression_get_left (self);
		_tmp401_ = _tmp400_;
		_tmp402_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp401_);
		_tmp403_ = _tmp402_;
		vala_report_error (_tmp403_, "invalid left operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp405_ = self->priv->_operator;
	if (_tmp405_ != VALA_BINARY_OPERATOR_IN) {
		ValaExpression* _tmp406_;
		ValaExpression* _tmp407_;
		ValaDataType* _tmp408_;
		ValaDataType* _tmp409_;
		_tmp406_ = vala_binary_expression_get_right (self);
		_tmp407_ = _tmp406_;
		_tmp408_ = vala_expression_get_value_type (_tmp407_);
		_tmp409_ = _tmp408_;
		_tmp404_ = _tmp409_ == NULL;
	} else {
		_tmp404_ = FALSE;
	}
	if (_tmp404_) {
		ValaExpression* _tmp410_;
		ValaExpression* _tmp411_;
		ValaSourceReference* _tmp412_;
		ValaSourceReference* _tmp413_;
		_tmp410_ = vala_binary_expression_get_right (self);
		_tmp411_ = _tmp410_;
		_tmp412_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp411_);
		_tmp413_ = _tmp412_;
		vala_report_error (_tmp413_, "invalid right operand");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp414_ = vala_binary_expression_get_left (self);
	_tmp415_ = _tmp414_;
	_tmp416_ = vala_expression_get_value_type (_tmp415_);
	_tmp417_ = _tmp416_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp417_, VALA_TYPE_FIELD_PROTOTYPE)) {
		ValaExpression* _tmp418_;
		ValaExpression* _tmp419_;
		ValaSourceReference* _tmp420_;
		ValaSourceReference* _tmp421_;
		ValaExpression* _tmp422_;
		ValaExpression* _tmp423_;
		ValaSymbol* _tmp424_;
		ValaSymbol* _tmp425_;
		gchar* _tmp426_;
		gchar* _tmp427_;
		gchar* _tmp428_;
		gchar* _tmp429_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp418_ = vala_binary_expression_get_left (self);
		_tmp419_ = _tmp418_;
		_tmp420_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp419_);
		_tmp421_ = _tmp420_;
		_tmp422_ = vala_binary_expression_get_left (self);
		_tmp423_ = _tmp422_;
		_tmp424_ = vala_expression_get_symbol_reference (_tmp423_);
		_tmp425_ = _tmp424_;
		_tmp426_ = vala_symbol_get_full_name (_tmp425_);
		_tmp427_ = _tmp426_;
		_tmp428_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp427_);
		_tmp429_ = _tmp428_;
		vala_report_error (_tmp421_, _tmp429_);
		_g_free0 (_tmp429_);
		_g_free0 (_tmp427_);
		result = FALSE;
		return result;
	}
	_tmp430_ = vala_binary_expression_get_right (self);
	_tmp431_ = _tmp430_;
	_tmp432_ = vala_expression_get_value_type (_tmp431_);
	_tmp433_ = _tmp432_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp433_, VALA_TYPE_FIELD_PROTOTYPE)) {
		ValaExpression* _tmp434_;
		ValaExpression* _tmp435_;
		ValaSourceReference* _tmp436_;
		ValaSourceReference* _tmp437_;
		ValaExpression* _tmp438_;
		ValaExpression* _tmp439_;
		ValaSymbol* _tmp440_;
		ValaSymbol* _tmp441_;
		gchar* _tmp442_;
		gchar* _tmp443_;
		gchar* _tmp444_;
		gchar* _tmp445_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp434_ = vala_binary_expression_get_right (self);
		_tmp435_ = _tmp434_;
		_tmp436_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp435_);
		_tmp437_ = _tmp436_;
		_tmp438_ = vala_binary_expression_get_right (self);
		_tmp439_ = _tmp438_;
		_tmp440_ = vala_expression_get_symbol_reference (_tmp439_);
		_tmp441_ = _tmp440_;
		_tmp442_ = vala_symbol_get_full_name (_tmp441_);
		_tmp443_ = _tmp442_;
		_tmp444_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp443_);
		_tmp445_ = _tmp444_;
		vala_report_error (_tmp437_, _tmp445_);
		_g_free0 (_tmp445_);
		_g_free0 (_tmp443_);
		result = FALSE;
		return result;
	}
	_tmp446_ = vala_binary_expression_get_left (self);
	_tmp447_ = _tmp446_;
	_tmp448_ = vala_binary_expression_get_left (self);
	_tmp449_ = _tmp448_;
	_tmp450_ = vala_expression_get_value_type (_tmp449_);
	_tmp451_ = _tmp450_;
	_tmp452_ = vala_data_type_copy (_tmp451_);
	_tmp453_ = _tmp452_;
	vala_expression_set_target_type (_tmp447_, _tmp453_);
	_vala_code_node_unref0 (_tmp453_);
	_tmp454_ = vala_binary_expression_get_left (self);
	_tmp455_ = _tmp454_;
	_tmp456_ = vala_expression_get_target_type (_tmp455_);
	_tmp457_ = _tmp456_;
	vala_data_type_set_value_owned (_tmp457_, FALSE);
	_tmp458_ = vala_binary_expression_get_right (self);
	_tmp459_ = _tmp458_;
	_tmp460_ = vala_binary_expression_get_right (self);
	_tmp461_ = _tmp460_;
	_tmp462_ = vala_expression_get_value_type (_tmp461_);
	_tmp463_ = _tmp462_;
	_tmp464_ = vala_data_type_copy (_tmp463_);
	_tmp465_ = _tmp464_;
	vala_expression_set_target_type (_tmp459_, _tmp465_);
	_vala_code_node_unref0 (_tmp465_);
	_tmp466_ = vala_binary_expression_get_right (self);
	_tmp467_ = _tmp466_;
	_tmp468_ = vala_expression_get_target_type (_tmp467_);
	_tmp469_ = _tmp468_;
	vala_data_type_set_value_owned (_tmp469_, FALSE);
	_tmp471_ = vala_binary_expression_get_left (self);
	_tmp472_ = _tmp471_;
	_tmp473_ = vala_expression_get_value_type (_tmp472_);
	_tmp474_ = _tmp473_;
	_tmp475_ = vala_data_type_get_data_type (_tmp474_);
	_tmp476_ = _tmp475_;
	_tmp477_ = vala_code_context_get_analyzer (context);
	_tmp478_ = _tmp477_;
	_tmp479_ = _tmp478_->string_type;
	_tmp480_ = vala_data_type_get_data_type (_tmp479_);
	_tmp481_ = _tmp480_;
	if (_tmp476_ == _tmp481_) {
		ValaBinaryOperator _tmp482_;
		_tmp482_ = self->priv->_operator;
		_tmp470_ = _tmp482_ == VALA_BINARY_OPERATOR_PLUS;
	} else {
		_tmp470_ = FALSE;
	}
	if (_tmp470_) {
		gboolean _tmp483_ = FALSE;
		ValaExpression* _tmp484_;
		ValaExpression* _tmp485_;
		ValaDataType* _tmp486_;
		ValaDataType* _tmp487_;
		ValaSemanticAnalyzer* _tmp501_;
		ValaSemanticAnalyzer* _tmp502_;
		ValaDataType* _tmp503_;
		ValaDataType* _tmp504_;
		ValaDataType* _tmp505_;
		gboolean _tmp506_ = FALSE;
		ValaExpression* _tmp507_;
		ValaExpression* _tmp508_;
		_tmp484_ = vala_binary_expression_get_right (self);
		_tmp485_ = _tmp484_;
		_tmp486_ = vala_expression_get_value_type (_tmp485_);
		_tmp487_ = _tmp486_;
		if (_tmp487_ == NULL) {
			_tmp483_ = TRUE;
		} else {
			ValaExpression* _tmp488_;
			ValaExpression* _tmp489_;
			ValaDataType* _tmp490_;
			ValaDataType* _tmp491_;
			ValaTypeSymbol* _tmp492_;
			ValaTypeSymbol* _tmp493_;
			ValaSemanticAnalyzer* _tmp494_;
			ValaSemanticAnalyzer* _tmp495_;
			ValaDataType* _tmp496_;
			ValaTypeSymbol* _tmp497_;
			ValaTypeSymbol* _tmp498_;
			_tmp488_ = vala_binary_expression_get_right (self);
			_tmp489_ = _tmp488_;
			_tmp490_ = vala_expression_get_value_type (_tmp489_);
			_tmp491_ = _tmp490_;
			_tmp492_ = vala_data_type_get_data_type (_tmp491_);
			_tmp493_ = _tmp492_;
			_tmp494_ = vala_code_context_get_analyzer (context);
			_tmp495_ = _tmp494_;
			_tmp496_ = _tmp495_->string_type;
			_tmp497_ = vala_data_type_get_data_type (_tmp496_);
			_tmp498_ = _tmp497_;
			_tmp483_ = _tmp493_ != _tmp498_;
		}
		if (_tmp483_) {
			ValaSourceReference* _tmp499_;
			ValaSourceReference* _tmp500_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp499_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp500_ = _tmp499_;
			vala_report_error (_tmp500_, "Operands must be strings");
			result = FALSE;
			return result;
		}
		_tmp501_ = vala_code_context_get_analyzer (context);
		_tmp502_ = _tmp501_;
		_tmp503_ = _tmp502_->string_type;
		_tmp504_ = vala_data_type_copy (_tmp503_);
		_tmp505_ = _tmp504_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp505_);
		_vala_code_node_unref0 (_tmp505_);
		_tmp507_ = vala_binary_expression_get_left (self);
		_tmp508_ = _tmp507_;
		if (vala_expression_is_constant (_tmp508_)) {
			ValaExpression* _tmp509_;
			ValaExpression* _tmp510_;
			_tmp509_ = vala_binary_expression_get_right (self);
			_tmp510_ = _tmp509_;
			_tmp506_ = vala_expression_is_constant (_tmp510_);
		} else {
			_tmp506_ = FALSE;
		}
		if (_tmp506_) {
			ValaDataType* _tmp511_;
			ValaDataType* _tmp512_;
			_tmp511_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp512_ = _tmp511_;
			vala_data_type_set_value_owned (_tmp512_, FALSE);
		} else {
			ValaDataType* _tmp513_;
			ValaDataType* _tmp514_;
			_tmp513_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp514_ = _tmp513_;
			vala_data_type_set_value_owned (_tmp514_, TRUE);
		}
	} else {
		gboolean _tmp515_ = FALSE;
		ValaExpression* _tmp516_;
		ValaExpression* _tmp517_;
		ValaDataType* _tmp518_;
		ValaDataType* _tmp519_;
		_tmp516_ = vala_binary_expression_get_left (self);
		_tmp517_ = _tmp516_;
		_tmp518_ = vala_expression_get_value_type (_tmp517_);
		_tmp519_ = _tmp518_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp519_, VALA_TYPE_ARRAY_TYPE)) {
			ValaBinaryOperator _tmp520_;
			_tmp520_ = self->priv->_operator;
			_tmp515_ = _tmp520_ == VALA_BINARY_OPERATOR_PLUS;
		} else {
			_tmp515_ = FALSE;
		}
		if (_tmp515_) {
			ValaArrayType* array_type = NULL;
			ValaExpression* _tmp521_;
			ValaExpression* _tmp522_;
			ValaDataType* _tmp523_;
			ValaDataType* _tmp524_;
			ValaArrayType* _tmp525_;
			gboolean _tmp526_ = FALSE;
			ValaExpression* _tmp527_;
			ValaExpression* _tmp528_;
			ValaDataType* _tmp529_;
			ValaDataType* _tmp530_;
			ValaExpression* _tmp540_;
			ValaExpression* _tmp541_;
			ValaArrayType* _tmp542_;
			ValaDataType* _tmp543_;
			ValaDataType* _tmp544_;
			ValaDataType* _tmp545_;
			ValaDataType* _tmp546_;
			ValaArrayType* _tmp547_;
			ValaDataType* _tmp548_;
			ValaDataType* _tmp549_;
			ValaDataType* _tmp550_;
			ValaDataType* _tmp551_;
			_tmp521_ = vala_binary_expression_get_left (self);
			_tmp522_ = _tmp521_;
			_tmp523_ = vala_expression_get_value_type (_tmp522_);
			_tmp524_ = _tmp523_;
			_tmp525_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp524_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
			array_type = _tmp525_;
			_tmp527_ = vala_binary_expression_get_right (self);
			_tmp528_ = _tmp527_;
			_tmp529_ = vala_expression_get_value_type (_tmp528_);
			_tmp530_ = _tmp529_;
			if (_tmp530_ == NULL) {
				_tmp526_ = TRUE;
			} else {
				ValaExpression* _tmp531_;
				ValaExpression* _tmp532_;
				ValaDataType* _tmp533_;
				ValaDataType* _tmp534_;
				ValaArrayType* _tmp535_;
				ValaDataType* _tmp536_;
				ValaDataType* _tmp537_;
				_tmp531_ = vala_binary_expression_get_right (self);
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_expression_get_value_type (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = array_type;
				_tmp536_ = vala_array_type_get_element_type (_tmp535_);
				_tmp537_ = _tmp536_;
				_tmp526_ = !vala_data_type_compatible (_tmp534_, _tmp537_);
			}
			if (_tmp526_) {
				ValaSourceReference* _tmp538_;
				ValaSourceReference* _tmp539_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp538_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp539_ = _tmp538_;
				vala_report_error (_tmp539_, "Incompatible operand");
				result = FALSE;
				_vala_code_node_unref0 (array_type);
				return result;
			}
			_tmp540_ = vala_binary_expression_get_right (self);
			_tmp541_ = _tmp540_;
			_tmp542_ = array_type;
			_tmp543_ = vala_array_type_get_element_type (_tmp542_);
			_tmp544_ = _tmp543_;
			_tmp545_ = vala_data_type_copy (_tmp544_);
			_tmp546_ = _tmp545_;
			vala_expression_set_target_type (_tmp541_, _tmp546_);
			_vala_code_node_unref0 (_tmp546_);
			_tmp547_ = array_type;
			_tmp548_ = vala_data_type_copy ((ValaDataType*) _tmp547_);
			_tmp549_ = _tmp548_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp549_);
			_vala_code_node_unref0 (_tmp549_);
			_tmp550_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp551_ = _tmp550_;
			vala_data_type_set_value_owned (_tmp551_, TRUE);
			_vala_code_node_unref0 (array_type);
		} else {
			gboolean _tmp552_ = FALSE;
			gboolean _tmp553_ = FALSE;
			gboolean _tmp554_ = FALSE;
			ValaBinaryOperator _tmp555_;
			_tmp555_ = self->priv->_operator;
			if (_tmp555_ == VALA_BINARY_OPERATOR_PLUS) {
				_tmp554_ = TRUE;
			} else {
				ValaBinaryOperator _tmp556_;
				_tmp556_ = self->priv->_operator;
				_tmp554_ = _tmp556_ == VALA_BINARY_OPERATOR_MINUS;
			}
			if (_tmp554_) {
				_tmp553_ = TRUE;
			} else {
				ValaBinaryOperator _tmp557_;
				_tmp557_ = self->priv->_operator;
				_tmp553_ = _tmp557_ == VALA_BINARY_OPERATOR_MUL;
			}
			if (_tmp553_) {
				_tmp552_ = TRUE;
			} else {
				ValaBinaryOperator _tmp558_;
				_tmp558_ = self->priv->_operator;
				_tmp552_ = _tmp558_ == VALA_BINARY_OPERATOR_DIV;
			}
			if (_tmp552_) {
				ValaExpression* _tmp559_;
				ValaExpression* _tmp560_;
				ValaDataType* _tmp561_;
				ValaDataType* _tmp562_;
				ValaDataType* _tmp607_;
				ValaDataType* _tmp608_;
				ValaDataType* _tmp621_;
				ValaDataType* _tmp622_;
				_tmp559_ = vala_binary_expression_get_left (self);
				_tmp560_ = _tmp559_;
				_tmp561_ = vala_expression_get_value_type (_tmp560_);
				_tmp562_ = _tmp561_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp562_, VALA_TYPE_POINTER_TYPE)) {
					ValaPointerType* pointer_type = NULL;
					ValaExpression* _tmp563_;
					ValaExpression* _tmp564_;
					ValaDataType* _tmp565_;
					ValaDataType* _tmp566_;
					ValaPointerType* _tmp567_;
					ValaPointerType* _tmp568_;
					ValaDataType* _tmp569_;
					ValaDataType* _tmp570_;
					ValaStruct* offset_type = NULL;
					ValaExpression* _tmp573_;
					ValaExpression* _tmp574_;
					ValaDataType* _tmp575_;
					ValaDataType* _tmp576_;
					ValaTypeSymbol* _tmp577_;
					ValaTypeSymbol* _tmp578_;
					ValaStruct* _tmp579_;
					gboolean _tmp580_ = FALSE;
					ValaStruct* _tmp581_;
					_tmp563_ = vala_binary_expression_get_left (self);
					_tmp564_ = _tmp563_;
					_tmp565_ = vala_expression_get_value_type (_tmp564_);
					_tmp566_ = _tmp565_;
					_tmp567_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp566_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
					pointer_type = _tmp567_;
					_tmp568_ = pointer_type;
					_tmp569_ = vala_pointer_type_get_base_type (_tmp568_);
					_tmp570_ = _tmp569_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp570_, VALA_TYPE_VOID_TYPE)) {
						ValaSourceReference* _tmp571_;
						ValaSourceReference* _tmp572_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp571_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp572_ = _tmp571_;
						vala_report_error (_tmp572_, "Pointer arithmetic not supported for `void*'");
						result = FALSE;
						_vala_code_node_unref0 (pointer_type);
						return result;
					}
					_tmp573_ = vala_binary_expression_get_right (self);
					_tmp574_ = _tmp573_;
					_tmp575_ = vala_expression_get_value_type (_tmp574_);
					_tmp576_ = _tmp575_;
					_tmp577_ = vala_data_type_get_data_type (_tmp576_);
					_tmp578_ = _tmp577_;
					_tmp579_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp578_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp578_) : NULL);
					offset_type = _tmp579_;
					_tmp581_ = offset_type;
					if (_tmp581_ != NULL) {
						ValaStruct* _tmp582_;
						_tmp582_ = offset_type;
						_tmp580_ = vala_struct_is_integer_type (_tmp582_);
					} else {
						_tmp580_ = FALSE;
					}
					if (_tmp580_) {
						gboolean _tmp583_ = FALSE;
						ValaBinaryOperator _tmp584_;
						_tmp584_ = self->priv->_operator;
						if (_tmp584_ == VALA_BINARY_OPERATOR_PLUS) {
							_tmp583_ = TRUE;
						} else {
							ValaBinaryOperator _tmp585_;
							_tmp585_ = self->priv->_operator;
							_tmp583_ = _tmp585_ == VALA_BINARY_OPERATOR_MINUS;
						}
						if (_tmp583_) {
							ValaExpression* _tmp586_;
							ValaExpression* _tmp587_;
							ValaDataType* _tmp588_;
							ValaDataType* _tmp589_;
							ValaDataType* _tmp590_;
							ValaDataType* _tmp591_;
							_tmp586_ = vala_binary_expression_get_left (self);
							_tmp587_ = _tmp586_;
							_tmp588_ = vala_expression_get_value_type (_tmp587_);
							_tmp589_ = _tmp588_;
							_tmp590_ = vala_data_type_copy (_tmp589_);
							_tmp591_ = _tmp590_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp591_);
							_vala_code_node_unref0 (_tmp591_);
						}
					} else {
						ValaExpression* _tmp592_;
						ValaExpression* _tmp593_;
						ValaDataType* _tmp594_;
						ValaDataType* _tmp595_;
						_tmp592_ = vala_binary_expression_get_right (self);
						_tmp593_ = _tmp592_;
						_tmp594_ = vala_expression_get_value_type (_tmp593_);
						_tmp595_ = _tmp594_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp595_, VALA_TYPE_POINTER_TYPE)) {
							ValaSemanticAnalyzer* _tmp596_;
							ValaSemanticAnalyzer* _tmp597_;
							ValaDataType* _tmp598_;
							_tmp596_ = vala_code_context_get_analyzer (context);
							_tmp597_ = _tmp596_;
							_tmp598_ = _tmp597_->size_t_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp598_);
						}
					}
					_vala_code_node_unref0 (offset_type);
					_vala_code_node_unref0 (pointer_type);
				} else {
					ValaExpression* _tmp599_;
					ValaExpression* _tmp600_;
					ValaDataType* _tmp601_;
					ValaDataType* _tmp602_;
					ValaExpression* _tmp603_;
					ValaExpression* _tmp604_;
					ValaDataType* _tmp605_;
					ValaDataType* _tmp606_;
					_tmp599_ = vala_binary_expression_get_left (self);
					_tmp600_ = _tmp599_;
					_tmp601_ = vala_expression_get_target_type (_tmp600_);
					_tmp602_ = _tmp601_;
					vala_data_type_set_nullable (_tmp602_, FALSE);
					_tmp603_ = vala_binary_expression_get_right (self);
					_tmp604_ = _tmp603_;
					_tmp605_ = vala_expression_get_target_type (_tmp604_);
					_tmp606_ = _tmp605_;
					vala_data_type_set_nullable (_tmp606_, FALSE);
				}
				_tmp607_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp608_ = _tmp607_;
				if (_tmp608_ == NULL) {
					ValaSemanticAnalyzer* _tmp609_;
					ValaSemanticAnalyzer* _tmp610_;
					ValaExpression* _tmp611_;
					ValaExpression* _tmp612_;
					ValaDataType* _tmp613_;
					ValaDataType* _tmp614_;
					ValaExpression* _tmp615_;
					ValaExpression* _tmp616_;
					ValaDataType* _tmp617_;
					ValaDataType* _tmp618_;
					ValaDataType* _tmp619_;
					ValaDataType* _tmp620_;
					_tmp609_ = vala_code_context_get_analyzer (context);
					_tmp610_ = _tmp609_;
					_tmp611_ = vala_binary_expression_get_left (self);
					_tmp612_ = _tmp611_;
					_tmp613_ = vala_expression_get_target_type (_tmp612_);
					_tmp614_ = _tmp613_;
					_tmp615_ = vala_binary_expression_get_right (self);
					_tmp616_ = _tmp615_;
					_tmp617_ = vala_expression_get_target_type (_tmp616_);
					_tmp618_ = _tmp617_;
					_tmp619_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp610_, _tmp614_, _tmp618_);
					_tmp620_ = _tmp619_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp620_);
					_vala_code_node_unref0 (_tmp620_);
				}
				_tmp621_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp622_ = _tmp621_;
				if (_tmp622_ == NULL) {
					ValaSourceReference* _tmp623_;
					ValaSourceReference* _tmp624_;
					ValaExpression* _tmp625_;
					ValaExpression* _tmp626_;
					ValaDataType* _tmp627_;
					ValaDataType* _tmp628_;
					gchar* _tmp629_;
					gchar* _tmp630_;
					ValaExpression* _tmp631_;
					ValaExpression* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDataType* _tmp634_;
					gchar* _tmp635_;
					gchar* _tmp636_;
					gchar* _tmp637_;
					gchar* _tmp638_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp623_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp624_ = _tmp623_;
					_tmp625_ = vala_binary_expression_get_left (self);
					_tmp626_ = _tmp625_;
					_tmp627_ = vala_expression_get_value_type (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp629_ = vala_code_node_to_string ((ValaCodeNode*) _tmp628_);
					_tmp630_ = _tmp629_;
					_tmp631_ = vala_binary_expression_get_right (self);
					_tmp632_ = _tmp631_;
					_tmp633_ = vala_expression_get_value_type (_tmp632_);
					_tmp634_ = _tmp633_;
					_tmp635_ = vala_code_node_to_string ((ValaCodeNode*) _tmp634_);
					_tmp636_ = _tmp635_;
					_tmp637_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp630_, _tmp636_);
					_tmp638_ = _tmp637_;
					vala_report_error (_tmp624_, _tmp638_);
					_g_free0 (_tmp638_);
					_g_free0 (_tmp636_);
					_g_free0 (_tmp630_);
					result = FALSE;
					return result;
				}
			} else {
				gboolean _tmp639_ = FALSE;
				gboolean _tmp640_ = FALSE;
				ValaBinaryOperator _tmp641_;
				_tmp641_ = self->priv->_operator;
				if (_tmp641_ == VALA_BINARY_OPERATOR_MOD) {
					_tmp640_ = TRUE;
				} else {
					ValaBinaryOperator _tmp642_;
					_tmp642_ = self->priv->_operator;
					_tmp640_ = _tmp642_ == VALA_BINARY_OPERATOR_SHIFT_LEFT;
				}
				if (_tmp640_) {
					_tmp639_ = TRUE;
				} else {
					ValaBinaryOperator _tmp643_;
					_tmp643_ = self->priv->_operator;
					_tmp639_ = _tmp643_ == VALA_BINARY_OPERATOR_SHIFT_RIGHT;
				}
				if (_tmp639_) {
					ValaExpression* _tmp644_;
					ValaExpression* _tmp645_;
					ValaDataType* _tmp646_;
					ValaDataType* _tmp647_;
					ValaExpression* _tmp648_;
					ValaExpression* _tmp649_;
					ValaDataType* _tmp650_;
					ValaDataType* _tmp651_;
					ValaSemanticAnalyzer* _tmp652_;
					ValaSemanticAnalyzer* _tmp653_;
					ValaExpression* _tmp654_;
					ValaExpression* _tmp655_;
					ValaDataType* _tmp656_;
					ValaDataType* _tmp657_;
					ValaExpression* _tmp658_;
					ValaExpression* _tmp659_;
					ValaDataType* _tmp660_;
					ValaDataType* _tmp661_;
					ValaDataType* _tmp662_;
					ValaDataType* _tmp663_;
					ValaDataType* _tmp664_;
					ValaDataType* _tmp665_;
					_tmp644_ = vala_binary_expression_get_left (self);
					_tmp645_ = _tmp644_;
					_tmp646_ = vala_expression_get_target_type (_tmp645_);
					_tmp647_ = _tmp646_;
					vala_data_type_set_nullable (_tmp647_, FALSE);
					_tmp648_ = vala_binary_expression_get_right (self);
					_tmp649_ = _tmp648_;
					_tmp650_ = vala_expression_get_target_type (_tmp649_);
					_tmp651_ = _tmp650_;
					vala_data_type_set_nullable (_tmp651_, FALSE);
					_tmp652_ = vala_code_context_get_analyzer (context);
					_tmp653_ = _tmp652_;
					_tmp654_ = vala_binary_expression_get_left (self);
					_tmp655_ = _tmp654_;
					_tmp656_ = vala_expression_get_target_type (_tmp655_);
					_tmp657_ = _tmp656_;
					_tmp658_ = vala_binary_expression_get_right (self);
					_tmp659_ = _tmp658_;
					_tmp660_ = vala_expression_get_target_type (_tmp659_);
					_tmp661_ = _tmp660_;
					_tmp662_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp653_, _tmp657_, _tmp661_);
					_tmp663_ = _tmp662_;
					vala_expression_set_value_type ((ValaExpression*) self, _tmp663_);
					_vala_code_node_unref0 (_tmp663_);
					_tmp664_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp665_ = _tmp664_;
					if (_tmp665_ == NULL) {
						ValaSourceReference* _tmp666_;
						ValaSourceReference* _tmp667_;
						ValaExpression* _tmp668_;
						ValaExpression* _tmp669_;
						ValaDataType* _tmp670_;
						ValaDataType* _tmp671_;
						gchar* _tmp672_;
						gchar* _tmp673_;
						ValaExpression* _tmp674_;
						ValaExpression* _tmp675_;
						ValaDataType* _tmp676_;
						ValaDataType* _tmp677_;
						gchar* _tmp678_;
						gchar* _tmp679_;
						gchar* _tmp680_;
						gchar* _tmp681_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp666_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp667_ = _tmp666_;
						_tmp668_ = vala_binary_expression_get_left (self);
						_tmp669_ = _tmp668_;
						_tmp670_ = vala_expression_get_value_type (_tmp669_);
						_tmp671_ = _tmp670_;
						_tmp672_ = vala_code_node_to_string ((ValaCodeNode*) _tmp671_);
						_tmp673_ = _tmp672_;
						_tmp674_ = vala_binary_expression_get_right (self);
						_tmp675_ = _tmp674_;
						_tmp676_ = vala_expression_get_value_type (_tmp675_);
						_tmp677_ = _tmp676_;
						_tmp678_ = vala_code_node_to_string ((ValaCodeNode*) _tmp677_);
						_tmp679_ = _tmp678_;
						_tmp680_ = g_strdup_printf ("Arithmetic operation not supported for types `%s' and `%s'", _tmp673_, _tmp679_);
						_tmp681_ = _tmp680_;
						vala_report_error (_tmp667_, _tmp681_);
						_g_free0 (_tmp681_);
						_g_free0 (_tmp679_);
						_g_free0 (_tmp673_);
						result = FALSE;
						return result;
					}
				} else {
					gboolean _tmp682_ = FALSE;
					gboolean _tmp683_ = FALSE;
					gboolean _tmp684_ = FALSE;
					ValaBinaryOperator _tmp685_;
					_tmp685_ = self->priv->_operator;
					if (_tmp685_ == VALA_BINARY_OPERATOR_LESS_THAN) {
						_tmp684_ = TRUE;
					} else {
						ValaBinaryOperator _tmp686_;
						_tmp686_ = self->priv->_operator;
						_tmp684_ = _tmp686_ == VALA_BINARY_OPERATOR_GREATER_THAN;
					}
					if (_tmp684_) {
						_tmp683_ = TRUE;
					} else {
						ValaBinaryOperator _tmp687_;
						_tmp687_ = self->priv->_operator;
						_tmp683_ = _tmp687_ == VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL;
					}
					if (_tmp683_) {
						_tmp682_ = TRUE;
					} else {
						ValaBinaryOperator _tmp688_;
						_tmp688_ = self->priv->_operator;
						_tmp682_ = _tmp688_ == VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL;
					}
					if (_tmp682_) {
						gboolean _tmp689_ = FALSE;
						ValaExpression* _tmp690_;
						ValaExpression* _tmp691_;
						ValaDataType* _tmp692_;
						ValaDataType* _tmp693_;
						ValaSemanticAnalyzer* _tmp694_;
						ValaSemanticAnalyzer* _tmp695_;
						ValaDataType* _tmp696_;
						ValaSemanticAnalyzer* _tmp776_;
						ValaSemanticAnalyzer* _tmp777_;
						ValaDataType* _tmp778_;
						_tmp690_ = vala_binary_expression_get_left (self);
						_tmp691_ = _tmp690_;
						_tmp692_ = vala_expression_get_value_type (_tmp691_);
						_tmp693_ = _tmp692_;
						_tmp694_ = vala_code_context_get_analyzer (context);
						_tmp695_ = _tmp694_;
						_tmp696_ = _tmp695_->string_type;
						if (vala_data_type_compatible (_tmp693_, _tmp696_)) {
							ValaExpression* _tmp697_;
							ValaExpression* _tmp698_;
							ValaDataType* _tmp699_;
							ValaDataType* _tmp700_;
							ValaSemanticAnalyzer* _tmp701_;
							ValaSemanticAnalyzer* _tmp702_;
							ValaDataType* _tmp703_;
							_tmp697_ = vala_binary_expression_get_right (self);
							_tmp698_ = _tmp697_;
							_tmp699_ = vala_expression_get_value_type (_tmp698_);
							_tmp700_ = _tmp699_;
							_tmp701_ = vala_code_context_get_analyzer (context);
							_tmp702_ = _tmp701_;
							_tmp703_ = _tmp702_->string_type;
							_tmp689_ = vala_data_type_compatible (_tmp700_, _tmp703_);
						} else {
							_tmp689_ = FALSE;
						}
						if (_tmp689_) {
						} else {
							gboolean _tmp704_ = FALSE;
							ValaExpression* _tmp705_;
							ValaExpression* _tmp706_;
							ValaDataType* _tmp707_;
							ValaDataType* _tmp708_;
							_tmp705_ = vala_binary_expression_get_left (self);
							_tmp706_ = _tmp705_;
							_tmp707_ = vala_expression_get_value_type (_tmp706_);
							_tmp708_ = _tmp707_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp708_, VALA_TYPE_POINTER_TYPE)) {
								ValaExpression* _tmp709_;
								ValaExpression* _tmp710_;
								ValaDataType* _tmp711_;
								ValaDataType* _tmp712_;
								_tmp709_ = vala_binary_expression_get_right (self);
								_tmp710_ = _tmp709_;
								_tmp711_ = vala_expression_get_value_type (_tmp710_);
								_tmp712_ = _tmp711_;
								_tmp704_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp712_, VALA_TYPE_POINTER_TYPE);
							} else {
								_tmp704_ = FALSE;
							}
							if (_tmp704_) {
							} else {
								ValaDataType* resulting_type = NULL;
								gboolean _tmp713_;
								ValaDataType* _tmp740_;
								gboolean _tmp757_;
								ValaExpression* _tmp763_;
								ValaExpression* _tmp764_;
								ValaDataType* _tmp765_;
								ValaDataType* _tmp766_;
								ValaDataType* _tmp767_;
								ValaExpression* _tmp768_;
								ValaExpression* _tmp769_;
								ValaDataType* _tmp770_;
								ValaDataType* _tmp771_;
								ValaExpression* _tmp772_;
								ValaExpression* _tmp773_;
								ValaDataType* _tmp774_;
								ValaDataType* _tmp775_;
								_tmp713_ = self->priv->_is_chained;
								if (_tmp713_) {
									ValaBinaryExpression* lbe = NULL;
									ValaExpression* _tmp714_;
									ValaExpression* _tmp715_;
									ValaBinaryExpression* _tmp716_;
									ValaSemanticAnalyzer* _tmp717_;
									ValaSemanticAnalyzer* _tmp718_;
									ValaBinaryExpression* _tmp719_;
									ValaExpression* _tmp720_;
									ValaExpression* _tmp721_;
									ValaDataType* _tmp722_;
									ValaDataType* _tmp723_;
									ValaExpression* _tmp724_;
									ValaExpression* _tmp725_;
									ValaDataType* _tmp726_;
									ValaDataType* _tmp727_;
									ValaDataType* _tmp728_;
									_tmp714_ = vala_binary_expression_get_left (self);
									_tmp715_ = _tmp714_;
									_tmp716_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp715_, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression));
									lbe = _tmp716_;
									_tmp717_ = vala_code_context_get_analyzer (context);
									_tmp718_ = _tmp717_;
									_tmp719_ = lbe;
									_tmp720_ = vala_binary_expression_get_right (_tmp719_);
									_tmp721_ = _tmp720_;
									_tmp722_ = vala_expression_get_target_type (_tmp721_);
									_tmp723_ = _tmp722_;
									_tmp724_ = vala_binary_expression_get_right (self);
									_tmp725_ = _tmp724_;
									_tmp726_ = vala_expression_get_target_type (_tmp725_);
									_tmp727_ = _tmp726_;
									_tmp728_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp718_, _tmp723_, _tmp727_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp728_;
									_vala_code_node_unref0 (lbe);
								} else {
									ValaSemanticAnalyzer* _tmp729_;
									ValaSemanticAnalyzer* _tmp730_;
									ValaExpression* _tmp731_;
									ValaExpression* _tmp732_;
									ValaDataType* _tmp733_;
									ValaDataType* _tmp734_;
									ValaExpression* _tmp735_;
									ValaExpression* _tmp736_;
									ValaDataType* _tmp737_;
									ValaDataType* _tmp738_;
									ValaDataType* _tmp739_;
									_tmp729_ = vala_code_context_get_analyzer (context);
									_tmp730_ = _tmp729_;
									_tmp731_ = vala_binary_expression_get_left (self);
									_tmp732_ = _tmp731_;
									_tmp733_ = vala_expression_get_target_type (_tmp732_);
									_tmp734_ = _tmp733_;
									_tmp735_ = vala_binary_expression_get_right (self);
									_tmp736_ = _tmp735_;
									_tmp737_ = vala_expression_get_target_type (_tmp736_);
									_tmp738_ = _tmp737_;
									_tmp739_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp730_, _tmp734_, _tmp738_);
									_vala_code_node_unref0 (resulting_type);
									resulting_type = _tmp739_;
								}
								_tmp740_ = resulting_type;
								if (_tmp740_ == NULL) {
									ValaSourceReference* _tmp741_;
									ValaSourceReference* _tmp742_;
									ValaExpression* _tmp743_;
									ValaExpression* _tmp744_;
									ValaDataType* _tmp745_;
									ValaDataType* _tmp746_;
									gchar* _tmp747_;
									gchar* _tmp748_;
									ValaExpression* _tmp749_;
									ValaExpression* _tmp750_;
									ValaDataType* _tmp751_;
									ValaDataType* _tmp752_;
									gchar* _tmp753_;
									gchar* _tmp754_;
									gchar* _tmp755_;
									gchar* _tmp756_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp741_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp742_ = _tmp741_;
									_tmp743_ = vala_binary_expression_get_left (self);
									_tmp744_ = _tmp743_;
									_tmp745_ = vala_expression_get_value_type (_tmp744_);
									_tmp746_ = _tmp745_;
									_tmp747_ = vala_code_node_to_string ((ValaCodeNode*) _tmp746_);
									_tmp748_ = _tmp747_;
									_tmp749_ = vala_binary_expression_get_right (self);
									_tmp750_ = _tmp749_;
									_tmp751_ = vala_expression_get_value_type (_tmp750_);
									_tmp752_ = _tmp751_;
									_tmp753_ = vala_code_node_to_string ((ValaCodeNode*) _tmp752_);
									_tmp754_ = _tmp753_;
									_tmp755_ = g_strdup_printf ("Relational operation not supported for types `%s' and `%s'", _tmp748_, _tmp754_);
									_tmp756_ = _tmp755_;
									vala_report_error (_tmp742_, _tmp756_);
									_g_free0 (_tmp756_);
									_g_free0 (_tmp754_);
									_g_free0 (_tmp748_);
									result = FALSE;
									_vala_code_node_unref0 (resulting_type);
									return result;
								}
								_tmp757_ = self->priv->_is_chained;
								if (!_tmp757_) {
									ValaExpression* _tmp758_;
									ValaExpression* _tmp759_;
									ValaDataType* _tmp760_;
									ValaDataType* _tmp761_;
									ValaDataType* _tmp762_;
									_tmp758_ = vala_binary_expression_get_left (self);
									_tmp759_ = _tmp758_;
									_tmp760_ = resulting_type;
									_tmp761_ = vala_data_type_copy (_tmp760_);
									_tmp762_ = _tmp761_;
									vala_expression_set_target_type (_tmp759_, _tmp762_);
									_vala_code_node_unref0 (_tmp762_);
								}
								_tmp763_ = vala_binary_expression_get_right (self);
								_tmp764_ = _tmp763_;
								_tmp765_ = resulting_type;
								_tmp766_ = vala_data_type_copy (_tmp765_);
								_tmp767_ = _tmp766_;
								vala_expression_set_target_type (_tmp764_, _tmp767_);
								_vala_code_node_unref0 (_tmp767_);
								_tmp768_ = vala_binary_expression_get_left (self);
								_tmp769_ = _tmp768_;
								_tmp770_ = vala_expression_get_target_type (_tmp769_);
								_tmp771_ = _tmp770_;
								vala_data_type_set_nullable (_tmp771_, FALSE);
								_tmp772_ = vala_binary_expression_get_right (self);
								_tmp773_ = _tmp772_;
								_tmp774_ = vala_expression_get_target_type (_tmp773_);
								_tmp775_ = _tmp774_;
								vala_data_type_set_nullable (_tmp775_, FALSE);
								_vala_code_node_unref0 (resulting_type);
							}
						}
						_tmp776_ = vala_code_context_get_analyzer (context);
						_tmp777_ = _tmp776_;
						_tmp778_ = _tmp777_->bool_type;
						vala_expression_set_value_type ((ValaExpression*) self, _tmp778_);
					} else {
						gboolean _tmp779_ = FALSE;
						ValaBinaryOperator _tmp780_;
						_tmp780_ = self->priv->_operator;
						if (_tmp780_ == VALA_BINARY_OPERATOR_EQUALITY) {
							_tmp779_ = TRUE;
						} else {
							ValaBinaryOperator _tmp781_;
							_tmp781_ = self->priv->_operator;
							_tmp779_ = _tmp781_ == VALA_BINARY_OPERATOR_INEQUALITY;
						}
						if (_tmp779_) {
							gboolean _tmp782_ = FALSE;
							ValaExpression* _tmp783_;
							ValaExpression* _tmp784_;
							ValaDataType* _tmp785_;
							ValaDataType* _tmp786_;
							ValaExpression* _tmp787_;
							ValaExpression* _tmp788_;
							ValaDataType* _tmp789_;
							ValaDataType* _tmp790_;
							ValaDataType* resulting_type = NULL;
							ValaSemanticAnalyzer* _tmp815_;
							ValaSemanticAnalyzer* _tmp816_;
							ValaExpression* _tmp817_;
							ValaExpression* _tmp818_;
							ValaDataType* _tmp819_;
							ValaDataType* _tmp820_;
							ValaExpression* _tmp821_;
							ValaExpression* _tmp822_;
							ValaDataType* _tmp823_;
							ValaDataType* _tmp824_;
							ValaDataType* _tmp825_;
							ValaDataType* _tmp826_;
							ValaExpression* _tmp837_;
							ValaExpression* _tmp838_;
							ValaDataType* _tmp839_;
							ValaDataType* _tmp840_;
							ValaExpression* _tmp841_;
							ValaExpression* _tmp842_;
							ValaDataType* _tmp843_;
							ValaDataType* _tmp844_;
							ValaExpression* _tmp845_;
							ValaExpression* _tmp846_;
							ValaDataType* _tmp847_;
							ValaDataType* _tmp848_;
							gboolean _tmp849_;
							gboolean _tmp850_;
							ValaExpression* _tmp851_;
							ValaExpression* _tmp852_;
							ValaDataType* _tmp853_;
							ValaDataType* _tmp854_;
							gboolean _tmp855_;
							gboolean _tmp856_;
							ValaSemanticAnalyzer* _tmp865_;
							ValaSemanticAnalyzer* _tmp866_;
							ValaDataType* _tmp867_;
							_tmp783_ = vala_binary_expression_get_right (self);
							_tmp784_ = _tmp783_;
							_tmp785_ = vala_expression_get_value_type (_tmp784_);
							_tmp786_ = _tmp785_;
							_tmp787_ = vala_binary_expression_get_left (self);
							_tmp788_ = _tmp787_;
							_tmp789_ = vala_expression_get_value_type (_tmp788_);
							_tmp790_ = _tmp789_;
							if (!vala_data_type_compatible (_tmp786_, _tmp790_)) {
								ValaExpression* _tmp791_;
								ValaExpression* _tmp792_;
								ValaDataType* _tmp793_;
								ValaDataType* _tmp794_;
								ValaExpression* _tmp795_;
								ValaExpression* _tmp796_;
								ValaDataType* _tmp797_;
								ValaDataType* _tmp798_;
								_tmp791_ = vala_binary_expression_get_left (self);
								_tmp792_ = _tmp791_;
								_tmp793_ = vala_expression_get_value_type (_tmp792_);
								_tmp794_ = _tmp793_;
								_tmp795_ = vala_binary_expression_get_right (self);
								_tmp796_ = _tmp795_;
								_tmp797_ = vala_expression_get_value_type (_tmp796_);
								_tmp798_ = _tmp797_;
								_tmp782_ = !vala_data_type_compatible (_tmp794_, _tmp798_);
							} else {
								_tmp782_ = FALSE;
							}
							if (_tmp782_) {
								ValaSourceReference* _tmp799_;
								ValaSourceReference* _tmp800_;
								ValaExpression* _tmp801_;
								ValaExpression* _tmp802_;
								ValaDataType* _tmp803_;
								ValaDataType* _tmp804_;
								gchar* _tmp805_;
								gchar* _tmp806_;
								ValaExpression* _tmp807_;
								ValaExpression* _tmp808_;
								ValaDataType* _tmp809_;
								ValaDataType* _tmp810_;
								gchar* _tmp811_;
								gchar* _tmp812_;
								gchar* _tmp813_;
								gchar* _tmp814_;
								_tmp799_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp800_ = _tmp799_;
								_tmp801_ = vala_binary_expression_get_right (self);
								_tmp802_ = _tmp801_;
								_tmp803_ = vala_expression_get_value_type (_tmp802_);
								_tmp804_ = _tmp803_;
								_tmp805_ = vala_code_node_to_string ((ValaCodeNode*) _tmp804_);
								_tmp806_ = _tmp805_;
								_tmp807_ = vala_binary_expression_get_left (self);
								_tmp808_ = _tmp807_;
								_tmp809_ = vala_expression_get_value_type (_tmp808_);
								_tmp810_ = _tmp809_;
								_tmp811_ = vala_code_node_to_string ((ValaCodeNode*) _tmp810_);
								_tmp812_ = _tmp811_;
								_tmp813_ = g_strdup_printf ("Equality operation: `%s' and `%s' are incompatible", _tmp806_, _tmp812_);
								_tmp814_ = _tmp813_;
								vala_report_error (_tmp800_, _tmp814_);
								_g_free0 (_tmp814_);
								_g_free0 (_tmp812_);
								_g_free0 (_tmp806_);
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								return result;
							}
							_tmp815_ = vala_code_context_get_analyzer (context);
							_tmp816_ = _tmp815_;
							_tmp817_ = vala_binary_expression_get_left (self);
							_tmp818_ = _tmp817_;
							_tmp819_ = vala_expression_get_target_type (_tmp818_);
							_tmp820_ = _tmp819_;
							_tmp821_ = vala_binary_expression_get_right (self);
							_tmp822_ = _tmp821_;
							_tmp823_ = vala_expression_get_target_type (_tmp822_);
							_tmp824_ = _tmp823_;
							_tmp825_ = vala_semantic_analyzer_get_arithmetic_result_type (_tmp816_, _tmp820_, _tmp824_);
							resulting_type = _tmp825_;
							_tmp826_ = resulting_type;
							if (_tmp826_ != NULL) {
								ValaExpression* _tmp827_;
								ValaExpression* _tmp828_;
								ValaDataType* _tmp829_;
								ValaDataType* _tmp830_;
								ValaDataType* _tmp831_;
								ValaExpression* _tmp832_;
								ValaExpression* _tmp833_;
								ValaDataType* _tmp834_;
								ValaDataType* _tmp835_;
								ValaDataType* _tmp836_;
								_tmp827_ = vala_binary_expression_get_left (self);
								_tmp828_ = _tmp827_;
								_tmp829_ = resulting_type;
								_tmp830_ = vala_data_type_copy (_tmp829_);
								_tmp831_ = _tmp830_;
								vala_expression_set_target_type (_tmp828_, _tmp831_);
								_vala_code_node_unref0 (_tmp831_);
								_tmp832_ = vala_binary_expression_get_right (self);
								_tmp833_ = _tmp832_;
								_tmp834_ = resulting_type;
								_tmp835_ = vala_data_type_copy (_tmp834_);
								_tmp836_ = _tmp835_;
								vala_expression_set_target_type (_tmp833_, _tmp836_);
								_vala_code_node_unref0 (_tmp836_);
							}
							_tmp837_ = vala_binary_expression_get_left (self);
							_tmp838_ = _tmp837_;
							_tmp839_ = vala_expression_get_target_type (_tmp838_);
							_tmp840_ = _tmp839_;
							vala_data_type_set_value_owned (_tmp840_, FALSE);
							_tmp841_ = vala_binary_expression_get_right (self);
							_tmp842_ = _tmp841_;
							_tmp843_ = vala_expression_get_target_type (_tmp842_);
							_tmp844_ = _tmp843_;
							vala_data_type_set_value_owned (_tmp844_, FALSE);
							_tmp845_ = vala_binary_expression_get_left (self);
							_tmp846_ = _tmp845_;
							_tmp847_ = vala_expression_get_value_type (_tmp846_);
							_tmp848_ = _tmp847_;
							_tmp849_ = vala_data_type_get_nullable (_tmp848_);
							_tmp850_ = _tmp849_;
							_tmp851_ = vala_binary_expression_get_right (self);
							_tmp852_ = _tmp851_;
							_tmp853_ = vala_expression_get_value_type (_tmp852_);
							_tmp854_ = _tmp853_;
							_tmp855_ = vala_data_type_get_nullable (_tmp854_);
							_tmp856_ = _tmp855_;
							if (_tmp850_ != _tmp856_) {
								ValaExpression* _tmp857_;
								ValaExpression* _tmp858_;
								ValaDataType* _tmp859_;
								ValaDataType* _tmp860_;
								ValaExpression* _tmp861_;
								ValaExpression* _tmp862_;
								ValaDataType* _tmp863_;
								ValaDataType* _tmp864_;
								_tmp857_ = vala_binary_expression_get_left (self);
								_tmp858_ = _tmp857_;
								_tmp859_ = vala_expression_get_target_type (_tmp858_);
								_tmp860_ = _tmp859_;
								vala_data_type_set_nullable (_tmp860_, TRUE);
								_tmp861_ = vala_binary_expression_get_right (self);
								_tmp862_ = _tmp861_;
								_tmp863_ = vala_expression_get_target_type (_tmp862_);
								_tmp864_ = _tmp863_;
								vala_data_type_set_nullable (_tmp864_, TRUE);
							}
							_tmp865_ = vala_code_context_get_analyzer (context);
							_tmp866_ = _tmp865_;
							_tmp867_ = _tmp866_->bool_type;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp867_);
							_vala_code_node_unref0 (resulting_type);
						} else {
							gboolean _tmp868_ = FALSE;
							gboolean _tmp869_ = FALSE;
							ValaBinaryOperator _tmp870_;
							_tmp870_ = self->priv->_operator;
							if (_tmp870_ == VALA_BINARY_OPERATOR_BITWISE_AND) {
								_tmp869_ = TRUE;
							} else {
								ValaBinaryOperator _tmp871_;
								_tmp871_ = self->priv->_operator;
								_tmp869_ = _tmp871_ == VALA_BINARY_OPERATOR_BITWISE_OR;
							}
							if (_tmp869_) {
								_tmp868_ = TRUE;
							} else {
								ValaBinaryOperator _tmp872_;
								_tmp872_ = self->priv->_operator;
								_tmp868_ = _tmp872_ == VALA_BINARY_OPERATOR_BITWISE_XOR;
							}
							if (_tmp868_) {
								ValaExpression* _tmp873_;
								ValaExpression* _tmp874_;
								ValaDataType* _tmp875_;
								ValaDataType* _tmp876_;
								ValaExpression* _tmp877_;
								ValaExpression* _tmp878_;
								ValaDataType* _tmp879_;
								ValaDataType* _tmp880_;
								ValaExpression* _tmp881_;
								ValaExpression* _tmp882_;
								ValaDataType* _tmp883_;
								ValaDataType* _tmp884_;
								ValaDataType* _tmp885_;
								ValaDataType* _tmp886_;
								_tmp873_ = vala_binary_expression_get_left (self);
								_tmp874_ = _tmp873_;
								_tmp875_ = vala_expression_get_target_type (_tmp874_);
								_tmp876_ = _tmp875_;
								vala_data_type_set_nullable (_tmp876_, FALSE);
								_tmp877_ = vala_binary_expression_get_right (self);
								_tmp878_ = _tmp877_;
								_tmp879_ = vala_expression_get_target_type (_tmp878_);
								_tmp880_ = _tmp879_;
								vala_data_type_set_nullable (_tmp880_, FALSE);
								_tmp881_ = vala_binary_expression_get_left (self);
								_tmp882_ = _tmp881_;
								_tmp883_ = vala_expression_get_target_type (_tmp882_);
								_tmp884_ = _tmp883_;
								_tmp885_ = vala_data_type_copy (_tmp884_);
								_tmp886_ = _tmp885_;
								vala_expression_set_value_type ((ValaExpression*) self, _tmp886_);
								_vala_code_node_unref0 (_tmp886_);
							} else {
								gboolean _tmp887_ = FALSE;
								ValaBinaryOperator _tmp888_;
								_tmp888_ = self->priv->_operator;
								if (_tmp888_ == VALA_BINARY_OPERATOR_AND) {
									_tmp887_ = TRUE;
								} else {
									ValaBinaryOperator _tmp889_;
									_tmp889_ = self->priv->_operator;
									_tmp887_ = _tmp889_ == VALA_BINARY_OPERATOR_OR;
								}
								if (_tmp887_) {
									gboolean _tmp890_ = FALSE;
									ValaExpression* _tmp891_;
									ValaExpression* _tmp892_;
									ValaDataType* _tmp893_;
									ValaDataType* _tmp894_;
									ValaSemanticAnalyzer* _tmp895_;
									ValaSemanticAnalyzer* _tmp896_;
									ValaDataType* _tmp897_;
									ValaExpression* _tmp907_;
									ValaExpression* _tmp908_;
									ValaDataType* _tmp909_;
									ValaDataType* _tmp910_;
									ValaExpression* _tmp911_;
									ValaExpression* _tmp912_;
									ValaDataType* _tmp913_;
									ValaDataType* _tmp914_;
									ValaSemanticAnalyzer* _tmp915_;
									ValaSemanticAnalyzer* _tmp916_;
									ValaDataType* _tmp917_;
									_tmp891_ = vala_binary_expression_get_left (self);
									_tmp892_ = _tmp891_;
									_tmp893_ = vala_expression_get_value_type (_tmp892_);
									_tmp894_ = _tmp893_;
									_tmp895_ = vala_code_context_get_analyzer (context);
									_tmp896_ = _tmp895_;
									_tmp897_ = _tmp896_->bool_type;
									if (!vala_data_type_compatible (_tmp894_, _tmp897_)) {
										_tmp890_ = TRUE;
									} else {
										ValaExpression* _tmp898_;
										ValaExpression* _tmp899_;
										ValaDataType* _tmp900_;
										ValaDataType* _tmp901_;
										ValaSemanticAnalyzer* _tmp902_;
										ValaSemanticAnalyzer* _tmp903_;
										ValaDataType* _tmp904_;
										_tmp898_ = vala_binary_expression_get_right (self);
										_tmp899_ = _tmp898_;
										_tmp900_ = vala_expression_get_value_type (_tmp899_);
										_tmp901_ = _tmp900_;
										_tmp902_ = vala_code_context_get_analyzer (context);
										_tmp903_ = _tmp902_;
										_tmp904_ = _tmp903_->bool_type;
										_tmp890_ = !vala_data_type_compatible (_tmp901_, _tmp904_);
									}
									if (_tmp890_) {
										ValaSourceReference* _tmp905_;
										ValaSourceReference* _tmp906_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp905_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp906_ = _tmp905_;
										vala_report_error (_tmp906_, "Operands must be boolean");
									}
									_tmp907_ = vala_binary_expression_get_left (self);
									_tmp908_ = _tmp907_;
									_tmp909_ = vala_expression_get_target_type (_tmp908_);
									_tmp910_ = _tmp909_;
									vala_data_type_set_nullable (_tmp910_, FALSE);
									_tmp911_ = vala_binary_expression_get_right (self);
									_tmp912_ = _tmp911_;
									_tmp913_ = vala_expression_get_target_type (_tmp912_);
									_tmp914_ = _tmp913_;
									vala_data_type_set_nullable (_tmp914_, FALSE);
									_tmp915_ = vala_code_context_get_analyzer (context);
									_tmp916_ = _tmp915_;
									_tmp917_ = _tmp916_->bool_type;
									vala_expression_set_value_type ((ValaExpression*) self, _tmp917_);
								} else {
									ValaBinaryOperator _tmp918_;
									_tmp918_ = self->priv->_operator;
									if (_tmp918_ == VALA_BINARY_OPERATOR_IN) {
										gboolean _tmp919_ = FALSE;
										ValaExpression* _tmp920_;
										ValaExpression* _tmp921_;
										ValaDataType* _tmp922_;
										ValaDataType* _tmp923_;
										ValaSemanticAnalyzer* _tmp924_;
										ValaSemanticAnalyzer* _tmp925_;
										ValaDataType* _tmp926_;
										ValaSemanticAnalyzer* _tmp1032_;
										ValaSemanticAnalyzer* _tmp1033_;
										ValaDataType* _tmp1034_;
										_tmp920_ = vala_binary_expression_get_left (self);
										_tmp921_ = _tmp920_;
										_tmp922_ = vala_expression_get_value_type (_tmp921_);
										_tmp923_ = _tmp922_;
										_tmp924_ = vala_code_context_get_analyzer (context);
										_tmp925_ = _tmp924_;
										_tmp926_ = _tmp925_->int_type;
										if (vala_data_type_compatible (_tmp923_, _tmp926_)) {
											ValaExpression* _tmp927_;
											ValaExpression* _tmp928_;
											ValaDataType* _tmp929_;
											ValaDataType* _tmp930_;
											ValaSemanticAnalyzer* _tmp931_;
											ValaSemanticAnalyzer* _tmp932_;
											ValaDataType* _tmp933_;
											_tmp927_ = vala_binary_expression_get_right (self);
											_tmp928_ = _tmp927_;
											_tmp929_ = vala_expression_get_value_type (_tmp928_);
											_tmp930_ = _tmp929_;
											_tmp931_ = vala_code_context_get_analyzer (context);
											_tmp932_ = _tmp931_;
											_tmp933_ = _tmp932_->int_type;
											_tmp919_ = vala_data_type_compatible (_tmp930_, _tmp933_);
										} else {
											_tmp919_ = FALSE;
										}
										if (_tmp919_) {
											ValaExpression* _tmp934_;
											ValaExpression* _tmp935_;
											ValaDataType* _tmp936_;
											ValaDataType* _tmp937_;
											ValaExpression* _tmp938_;
											ValaExpression* _tmp939_;
											ValaDataType* _tmp940_;
											ValaDataType* _tmp941_;
											_tmp934_ = vala_binary_expression_get_left (self);
											_tmp935_ = _tmp934_;
											_tmp936_ = vala_expression_get_target_type (_tmp935_);
											_tmp937_ = _tmp936_;
											vala_data_type_set_nullable (_tmp937_, FALSE);
											_tmp938_ = vala_binary_expression_get_right (self);
											_tmp939_ = _tmp938_;
											_tmp940_ = vala_expression_get_target_type (_tmp939_);
											_tmp941_ = _tmp940_;
											vala_data_type_set_nullable (_tmp941_, FALSE);
										} else {
											ValaExpression* _tmp942_;
											ValaExpression* _tmp943_;
											ValaDataType* _tmp944_;
											ValaDataType* _tmp945_;
											_tmp942_ = vala_binary_expression_get_right (self);
											_tmp943_ = _tmp942_;
											_tmp944_ = vala_expression_get_value_type (_tmp943_);
											_tmp945_ = _tmp944_;
											if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp945_, VALA_TYPE_ARRAY_TYPE)) {
												ValaExpression* _tmp946_;
												ValaExpression* _tmp947_;
												ValaDataType* _tmp948_;
												ValaDataType* _tmp949_;
												ValaExpression* _tmp950_;
												ValaExpression* _tmp951_;
												ValaDataType* _tmp952_;
												ValaDataType* _tmp953_;
												ValaDataType* _tmp954_;
												ValaDataType* _tmp955_;
												_tmp946_ = vala_binary_expression_get_left (self);
												_tmp947_ = _tmp946_;
												_tmp948_ = vala_expression_get_value_type (_tmp947_);
												_tmp949_ = _tmp948_;
												_tmp950_ = vala_binary_expression_get_right (self);
												_tmp951_ = _tmp950_;
												_tmp952_ = vala_expression_get_value_type (_tmp951_);
												_tmp953_ = _tmp952_;
												_tmp954_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp953_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
												_tmp955_ = _tmp954_;
												if (!vala_data_type_compatible (_tmp949_, _tmp955_)) {
													ValaSourceReference* _tmp956_;
													ValaSourceReference* _tmp957_;
													ValaExpression* _tmp958_;
													ValaExpression* _tmp959_;
													ValaDataType* _tmp960_;
													ValaDataType* _tmp961_;
													gchar* _tmp962_;
													gchar* _tmp963_;
													ValaExpression* _tmp964_;
													ValaExpression* _tmp965_;
													ValaDataType* _tmp966_;
													ValaDataType* _tmp967_;
													gchar* _tmp968_;
													gchar* _tmp969_;
													gchar* _tmp970_;
													gchar* _tmp971_;
													_tmp956_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp957_ = _tmp956_;
													_tmp958_ = vala_binary_expression_get_left (self);
													_tmp959_ = _tmp958_;
													_tmp960_ = vala_expression_get_value_type (_tmp959_);
													_tmp961_ = _tmp960_;
													_tmp962_ = vala_code_node_to_string ((ValaCodeNode*) _tmp961_);
													_tmp963_ = _tmp962_;
													_tmp964_ = vala_binary_expression_get_right (self);
													_tmp965_ = _tmp964_;
													_tmp966_ = vala_expression_get_value_type (_tmp965_);
													_tmp967_ = _tmp966_;
													_tmp968_ = vala_code_node_to_string ((ValaCodeNode*) _tmp967_);
													_tmp969_ = _tmp968_;
													_tmp970_ = g_strdup_printf ("Cannot look for `%s' in `%s'", _tmp963_, _tmp969_);
													_tmp971_ = _tmp970_;
													vala_report_error (_tmp957_, _tmp971_);
													_g_free0 (_tmp971_);
													_g_free0 (_tmp969_);
													_g_free0 (_tmp963_);
												}
											} else {
												ValaMethod* contains_method = NULL;
												ValaExpression* _tmp972_;
												ValaExpression* _tmp973_;
												ValaDataType* _tmp974_;
												ValaDataType* _tmp975_;
												ValaSymbol* _tmp976_;
												ValaMethod* _tmp977_;
												ValaMethod* _tmp978_;
												ValaMethod* _tmp989_;
												ValaList* _tmp990_;
												ValaList* _tmp991_;
												gint _tmp992_;
												gint _tmp993_;
												gboolean _tmp994_;
												ValaMethod* _tmp1002_;
												ValaDataType* _tmp1003_;
												ValaDataType* _tmp1004_;
												ValaSemanticAnalyzer* _tmp1005_;
												ValaSemanticAnalyzer* _tmp1006_;
												ValaDataType* _tmp1007_;
												ValaMethodCall* contains_call = NULL;
												ValaExpression* _tmp1015_;
												ValaExpression* _tmp1016_;
												ValaSourceReference* _tmp1017_;
												ValaSourceReference* _tmp1018_;
												ValaMemberAccess* _tmp1019_;
												ValaMemberAccess* _tmp1020_;
												ValaSourceReference* _tmp1021_;
												ValaSourceReference* _tmp1022_;
												ValaMethodCall* _tmp1023_;
												ValaMethodCall* _tmp1024_;
												ValaMethodCall* _tmp1025_;
												ValaExpression* _tmp1026_;
												ValaExpression* _tmp1027_;
												ValaCodeNode* _tmp1028_;
												ValaCodeNode* _tmp1029_;
												ValaMethodCall* _tmp1030_;
												ValaMethodCall* _tmp1031_;
												_tmp972_ = vala_binary_expression_get_right (self);
												_tmp973_ = _tmp972_;
												_tmp974_ = vala_expression_get_value_type (_tmp973_);
												_tmp975_ = _tmp974_;
												_tmp976_ = vala_data_type_get_member (_tmp975_, "contains");
												_tmp977_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp976_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp976_) : NULL;
												if (_tmp977_ == NULL) {
													_vala_code_node_unref0 (_tmp976_);
												}
												contains_method = _tmp977_;
												_tmp978_ = contains_method;
												if (_tmp978_ == NULL) {
													ValaSourceReference* _tmp979_;
													ValaSourceReference* _tmp980_;
													ValaExpression* _tmp981_;
													ValaExpression* _tmp982_;
													ValaDataType* _tmp983_;
													ValaDataType* _tmp984_;
													gchar* _tmp985_;
													gchar* _tmp986_;
													gchar* _tmp987_;
													gchar* _tmp988_;
													_tmp979_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp980_ = _tmp979_;
													_tmp981_ = vala_binary_expression_get_right (self);
													_tmp982_ = _tmp981_;
													_tmp983_ = vala_expression_get_value_type (_tmp982_);
													_tmp984_ = _tmp983_;
													_tmp985_ = vala_code_node_to_string ((ValaCodeNode*) _tmp984_);
													_tmp986_ = _tmp985_;
													_tmp987_ = g_strdup_printf ("`%s' does not have a `contains' method", _tmp986_);
													_tmp988_ = _tmp987_;
													vala_report_error (_tmp980_, _tmp988_);
													_g_free0 (_tmp988_);
													_g_free0 (_tmp986_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp989_ = contains_method;
												_tmp990_ = vala_callable_get_parameters ((ValaCallable*) _tmp989_);
												_tmp991_ = _tmp990_;
												_tmp992_ = vala_collection_get_size ((ValaCollection*) _tmp991_);
												_tmp993_ = _tmp992_;
												_tmp994_ = _tmp993_ != 1;
												_vala_iterable_unref0 (_tmp991_);
												if (_tmp994_) {
													ValaSourceReference* _tmp995_;
													ValaSourceReference* _tmp996_;
													ValaMethod* _tmp997_;
													gchar* _tmp998_;
													gchar* _tmp999_;
													gchar* _tmp1000_;
													gchar* _tmp1001_;
													_tmp995_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp996_ = _tmp995_;
													_tmp997_ = contains_method;
													_tmp998_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp997_);
													_tmp999_ = _tmp998_;
													_tmp1000_ = g_strdup_printf ("`%s' must have one parameter", _tmp999_);
													_tmp1001_ = _tmp1000_;
													vala_report_error (_tmp996_, _tmp1001_);
													_g_free0 (_tmp1001_);
													_g_free0 (_tmp999_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1002_ = contains_method;
												_tmp1003_ = vala_callable_get_return_type ((ValaCallable*) _tmp1002_);
												_tmp1004_ = _tmp1003_;
												_tmp1005_ = vala_code_context_get_analyzer (context);
												_tmp1006_ = _tmp1005_;
												_tmp1007_ = _tmp1006_->bool_type;
												if (!vala_data_type_compatible (_tmp1004_, _tmp1007_)) {
													ValaSourceReference* _tmp1008_;
													ValaSourceReference* _tmp1009_;
													ValaMethod* _tmp1010_;
													gchar* _tmp1011_;
													gchar* _tmp1012_;
													gchar* _tmp1013_;
													gchar* _tmp1014_;
													_tmp1008_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
													_tmp1009_ = _tmp1008_;
													_tmp1010_ = contains_method;
													_tmp1011_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1010_);
													_tmp1012_ = _tmp1011_;
													_tmp1013_ = g_strdup_printf ("`%s' must return a boolean value", _tmp1012_);
													_tmp1014_ = _tmp1013_;
													vala_report_error (_tmp1009_, _tmp1014_);
													_g_free0 (_tmp1014_);
													_g_free0 (_tmp1012_);
													vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
													result = FALSE;
													_vala_code_node_unref0 (contains_method);
													return result;
												}
												_tmp1015_ = vala_binary_expression_get_right (self);
												_tmp1016_ = _tmp1015_;
												_tmp1017_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1018_ = _tmp1017_;
												_tmp1019_ = vala_member_access_new (_tmp1016_, "contains", _tmp1018_);
												_tmp1020_ = _tmp1019_;
												_tmp1021_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp1022_ = _tmp1021_;
												_tmp1023_ = vala_method_call_new ((ValaExpression*) _tmp1020_, _tmp1022_);
												_tmp1024_ = _tmp1023_;
												_vala_code_node_unref0 (_tmp1020_);
												contains_call = _tmp1024_;
												_tmp1025_ = contains_call;
												_tmp1026_ = vala_binary_expression_get_left (self);
												_tmp1027_ = _tmp1026_;
												vala_method_call_add_argument (_tmp1025_, _tmp1027_);
												_tmp1028_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
												_tmp1029_ = _tmp1028_;
												_tmp1030_ = contains_call;
												vala_code_node_replace_expression (_tmp1029_, (ValaExpression*) self, (ValaExpression*) _tmp1030_);
												_tmp1031_ = contains_call;
												result = vala_code_node_check ((ValaCodeNode*) _tmp1031_, context);
												_vala_code_node_unref0 (contains_call);
												_vala_code_node_unref0 (contains_method);
												return result;
											}
										}
										_tmp1032_ = vala_code_context_get_analyzer (context);
										_tmp1033_ = _tmp1032_;
										_tmp1034_ = _tmp1033_->bool_type;
										vala_expression_set_value_type ((ValaExpression*) self, _tmp1034_);
									} else {
										g_assert_not_reached ();
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1035_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1036_ = _tmp1035_;
	result = !_tmp1036_;
	return result;
}

static void
vala_binary_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	vala_code_visitor_visit_binary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}

static void
vala_binary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                   ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
}

static void
vala_binary_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaBinaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaBinaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_binary_expression_get_left (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_binary_expression_get_right (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
}

ValaBinaryOperator
vala_binary_expression_get_operator (ValaBinaryExpression* self)
{
	ValaBinaryOperator result;
	ValaBinaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_operator (ValaBinaryExpression* self,
                                     ValaBinaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}

ValaExpression*
vala_binary_expression_get_left (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_left;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_left (ValaBinaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_left);
	self->priv->_left = _tmp0_;
	_tmp1_ = self->priv->_left;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

ValaExpression*
vala_binary_expression_get_right (ValaBinaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_right;
	result = _tmp0_;
	return result;
}

void
vala_binary_expression_set_right (ValaBinaryExpression* self,
                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_right);
	self->priv->_right = _tmp0_;
	_tmp1_ = self->priv->_right;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}

gboolean
vala_binary_expression_get_is_chained (ValaBinaryExpression* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_chained;
	return result;
}

static void
vala_binary_expression_set_is_chained (ValaBinaryExpression* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chained = value;
}

static void
vala_binary_expression_class_init (ValaBinaryExpressionClass * klass)
{
	vala_binary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_binary_expression_finalize;
	g_type_class_adjust_private_offset (klass, &ValaBinaryExpression_private_offset);
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_binary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_binary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_binary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_binary_expression_real_is_non_null;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_binary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->get_error_types = (void (*) (ValaCodeNode*, ValaCollection*, ValaSourceReference*)) vala_binary_expression_real_get_error_types;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_binary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_binary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_binary_expression_real_get_used_variables;
}

static void
vala_binary_expression_instance_init (ValaBinaryExpression * self)
{
	self->priv = vala_binary_expression_get_instance_private (self);
}

static void
vala_binary_expression_finalize (ValaCodeNode * obj)
{
	ValaBinaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_BINARY_EXPRESSION, ValaBinaryExpression);
	_vala_code_node_unref0 (self->priv->_left);
	_vala_code_node_unref0 (self->priv->_right);
	VALA_CODE_NODE_CLASS (vala_binary_expression_parent_class)->finalize (obj);
}

/**
 * Represents an expression with two operands in the source code.
 *
 * Supports +, -, *, /, %, <<, >>, <, >, <=, >=, ==, !=, &, |, ^, &&, ||, ??.
 */
GType
vala_binary_expression_get_type (void)
{
	static volatile gsize vala_binary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaBinaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_binary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaBinaryExpression), 0, (GInstanceInitFunc) vala_binary_expression_instance_init, NULL };
		GType vala_binary_expression_type_id;
		vala_binary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaBinaryExpression", &g_define_type_info, 0);
		ValaBinaryExpression_private_offset = g_type_add_instance_private (vala_binary_expression_type_id, sizeof (ValaBinaryExpressionPrivate));
		g_once_init_leave (&vala_binary_expression_type_id__volatile, vala_binary_expression_type_id);
	}
	return vala_binary_expression_type_id__volatile;
}

const gchar*
vala_binary_operator_to_string (ValaBinaryOperator self)
{
	const gchar* result = NULL;
	switch (self) {
		case VALA_BINARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_BINARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_BINARY_OPERATOR_MUL:
		{
			result = "*";
			return result;
		}
		case VALA_BINARY_OPERATOR_DIV:
		{
			result = "/";
			return result;
		}
		case VALA_BINARY_OPERATOR_MOD:
		{
			result = "%";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_LEFT:
		{
			result = "<<";
			return result;
		}
		case VALA_BINARY_OPERATOR_SHIFT_RIGHT:
		{
			result = ">>";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN:
		{
			result = "<";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN:
		{
			result = ">";
			return result;
		}
		case VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL:
		{
			result = "<=";
			return result;
		}
		case VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL:
		{
			result = ">=";
			return result;
		}
		case VALA_BINARY_OPERATOR_EQUALITY:
		{
			result = "==";
			return result;
		}
		case VALA_BINARY_OPERATOR_INEQUALITY:
		{
			result = "!=";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_AND:
		{
			result = "&";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_OR:
		{
			result = "|";
			return result;
		}
		case VALA_BINARY_OPERATOR_BITWISE_XOR:
		{
			result = "^";
			return result;
		}
		case VALA_BINARY_OPERATOR_AND:
		{
			result = "&&";
			return result;
		}
		case VALA_BINARY_OPERATOR_OR:
		{
			result = "||";
			return result;
		}
		case VALA_BINARY_OPERATOR_IN:
		{
			result = "in";
			return result;
		}
		case VALA_BINARY_OPERATOR_COALESCE:
		{
			result = "??";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

GType
vala_binary_operator_get_type (void)
{
	static volatile gsize vala_binary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_binary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_BINARY_OPERATOR_NONE, "VALA_BINARY_OPERATOR_NONE", "none"}, {VALA_BINARY_OPERATOR_PLUS, "VALA_BINARY_OPERATOR_PLUS", "plus"}, {VALA_BINARY_OPERATOR_MINUS, "VALA_BINARY_OPERATOR_MINUS", "minus"}, {VALA_BINARY_OPERATOR_MUL, "VALA_BINARY_OPERATOR_MUL", "mul"}, {VALA_BINARY_OPERATOR_DIV, "VALA_BINARY_OPERATOR_DIV", "div"}, {VALA_BINARY_OPERATOR_MOD, "VALA_BINARY_OPERATOR_MOD", "mod"}, {VALA_BINARY_OPERATOR_SHIFT_LEFT, "VALA_BINARY_OPERATOR_SHIFT_LEFT", "shift-left"}, {VALA_BINARY_OPERATOR_SHIFT_RIGHT, "VALA_BINARY_OPERATOR_SHIFT_RIGHT", "shift-right"}, {VALA_BINARY_OPERATOR_LESS_THAN, "VALA_BINARY_OPERATOR_LESS_THAN", "less-than"}, {VALA_BINARY_OPERATOR_GREATER_THAN, "VALA_BINARY_OPERATOR_GREATER_THAN", "greater-than"}, {VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_LESS_THAN_OR_EQUAL", "less-than-or-equal"}, {VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL, "VALA_BINARY_OPERATOR_GREATER_THAN_OR_EQUAL", "greater-than-or-equal"}, {VALA_BINARY_OPERATOR_EQUALITY, "VALA_BINARY_OPERATOR_EQUALITY", "equality"}, {VALA_BINARY_OPERATOR_INEQUALITY, "VALA_BINARY_OPERATOR_INEQUALITY", "inequality"}, {VALA_BINARY_OPERATOR_BITWISE_AND, "VALA_BINARY_OPERATOR_BITWISE_AND", "bitwise-and"}, {VALA_BINARY_OPERATOR_BITWISE_OR, "VALA_BINARY_OPERATOR_BITWISE_OR", "bitwise-or"}, {VALA_BINARY_OPERATOR_BITWISE_XOR, "VALA_BINARY_OPERATOR_BITWISE_XOR", "bitwise-xor"}, {VALA_BINARY_OPERATOR_AND, "VALA_BINARY_OPERATOR_AND", "and"}, {VALA_BINARY_OPERATOR_OR, "VALA_BINARY_OPERATOR_OR", "or"}, {VALA_BINARY_OPERATOR_IN, "VALA_BINARY_OPERATOR_IN", "in"}, {VALA_BINARY_OPERATOR_COALESCE, "VALA_BINARY_OPERATOR_COALESCE", "coalesce"}, {0, NULL, NULL}};
		GType vala_binary_operator_type_id;
		vala_binary_operator_type_id = g_enum_register_static ("ValaBinaryOperator", values);
		g_once_init_leave (&vala_binary_operator_type_id__volatile, vala_binary_operator_type_id);
	}
	return vala_binary_operator_type_id__volatile;
}

