/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};

static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
static gchar* vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}

static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}

static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}

static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}

static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  gint str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp16_;
		gint _tmp17_;
		const gchar* res = NULL;
		void* _tmp18_;
		void* ptr = NULL;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		void* _tmp21_;
		const gchar* _tmp31_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp10_ = 0;
				const gchar* _tmp11_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					_tmp7_ = i < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp8_ = FALSE;
					if (str_array_length1 == -1) {
						const gchar* _tmp9_;
						_tmp9_ = str_array[i];
						_tmp8_ = _tmp9_ != NULL;
					} else {
						_tmp8_ = FALSE;
					}
					_tmp6_ = _tmp8_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp11_ = str_array[i];
				if (_tmp11_ != NULL) {
					const gchar* _tmp12_;
					gint _tmp13_;
					gint _tmp14_;
					_tmp12_ = str_array[i];
					_tmp13_ = strlen ((const gchar*) _tmp12_);
					_tmp14_ = _tmp13_;
					_tmp10_ = _tmp14_;
				} else {
					_tmp10_ = 0;
				}
				len += (gsize) _tmp10_;
			}
		}
		if (i == 0) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("");
			result = _tmp15_;
			return result;
		}
		str_array_length1 = i;
		_tmp16_ = strlen ((const gchar*) separator);
		_tmp17_ = _tmp16_;
		len += (gsize) (_tmp17_ * (i - 1));
		_tmp18_ = g_malloc (len);
		res = _tmp18_;
		_tmp19_ = res;
		_tmp20_ = str_array[0];
		_tmp21_ = g_stpcpy ((void*) _tmp19_, (const gchar*) _tmp20_);
		ptr = _tmp21_;
		{
			gboolean _tmp22_ = FALSE;
			i = 1;
			_tmp22_ = TRUE;
			while (TRUE) {
				void* _tmp24_;
				void* _tmp25_;
				const gchar* _tmp26_ = NULL;
				const gchar* _tmp27_;
				void* _tmp29_;
				void* _tmp30_;
				if (!_tmp22_) {
					gint _tmp23_;
					_tmp23_ = i;
					i = _tmp23_ + 1;
				}
				_tmp22_ = FALSE;
				if (!(i < str_array_length1)) {
					break;
				}
				_tmp24_ = ptr;
				_tmp25_ = g_stpcpy (_tmp24_, (const gchar*) separator);
				ptr = _tmp25_;
				_tmp27_ = str_array[i];
				if (_tmp27_ != NULL) {
					const gchar* _tmp28_;
					_tmp28_ = str_array[i];
					_tmp26_ = (const gchar*) _tmp28_;
				} else {
					_tmp26_ = "";
				}
				_tmp29_ = ptr;
				_tmp30_ = g_stpcpy (_tmp29_, _tmp26_);
				ptr = _tmp30_;
			}
		}
		_tmp31_ = res;
		res = NULL;
		result = (gchar*) _tmp31_;
		return result;
	} else {
		gchar* _tmp32_;
		_tmp32_ = g_strdup ("");
		result = _tmp32_;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}

static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp164_;
	GEqualFunc _tmp165_;
	GEqualFunc _tmp166_;
	ValaHashMap* _tmp167_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp168_;
	ValaHashMap* _tmp169_;
	gboolean _tmp170_ = FALSE;
	ValaMethod* _tmp171_;
	gboolean _tmp314_ = FALSE;
	ValaMethod* _tmp315_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp478_;
	ValaCCodeExpression* _tmp479_;
	ValaMethod* _tmp480_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp504_ = FALSE;
	ValaMethod* _tmp505_;
	gboolean _tmp659_ = FALSE;
	ValaMethod* _tmp660_;
	ValaMethod* _tmp697_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp879_;
	ValaIterator* _tmp880_;
	ValaIterator* _tmp1214_;
	gboolean _tmp1224_ = FALSE;
	gboolean _tmp1225_ = FALSE;
	ValaMethod* _tmp1226_;
	gboolean _tmp1348_ = FALSE;
	ValaDelegate* _tmp1349_;
	gboolean _tmp1449_ = FALSE;
	ValaMethod* _tmp1450_;
	gboolean _tmp1466_;
	gboolean _tmp1467_;
	ValaDataType* _tmp1506_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1530_;
	ValaDataType* _tmp1531_;
	ValaDataType* _tmp1532_;
	gboolean _tmp1533_;
	gboolean _tmp1534_ = FALSE;
	ValaDataType* _tmp1535_;
	ValaCCodeFunctionCall* _tmp1564_;
	ValaCCodeFunctionCall* _tmp1565_;
	ValaCCodeExpression* out_param_ref = NULL;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1580_;
	ValaCCodeFunctionCall* _tmp1581_;
	ValaCCodeFunctionCall* _tmp1596_;
	gboolean _tmp1611_;
	gboolean _tmp1612_;
	gboolean _tmp1636_;
	gboolean _tmp1637_;
	gboolean _tmp1672_ = FALSE;
	gboolean _tmp1673_ = FALSE;
	ValaMethod* _tmp1674_;
	gboolean _tmp1712_ = FALSE;
	gboolean _tmp1713_ = FALSE;
	ValaMethod* _tmp1714_;
	ValaMethod* _tmp1733_;
	gboolean _tmp1850_ = FALSE;
	ValaCodeNode* _tmp1851_;
	ValaCodeNode* _tmp1852_;
	ValaList* _tmp1932_;
	ValaIterator* _tmp1933_;
	gboolean _tmp2014_ = FALSE;
	gboolean _tmp2015_ = FALSE;
	ValaMethod* _tmp2016_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_ = FALSE;
			gboolean _tmp57_ = FALSE;
			gboolean _tmp58_ = FALSE;
			gboolean _tmp59_ = FALSE;
			ValaCodeContext* _tmp60_;
			ValaCodeContext* _tmp61_;
			ValaProfile _tmp62_;
			ValaProfile _tmp63_;
			_tmp60_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_code_context_get_profile (_tmp61_);
			_tmp63_ = _tmp62_;
			if (_tmp63_ == VALA_PROFILE_POSIX) {
				ValaMemberAccess* _tmp64_;
				ValaExpression* _tmp65_;
				ValaExpression* _tmp66_;
				_tmp64_ = ma;
				_tmp65_ = vala_member_access_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp59_ = _tmp66_ != NULL;
			} else {
				_tmp59_ = FALSE;
			}
			if (_tmp59_) {
				ValaMemberAccess* _tmp67_;
				ValaExpression* _tmp68_;
				ValaExpression* _tmp69_;
				ValaDataType* _tmp70_;
				ValaDataType* _tmp71_;
				_tmp67_ = ma;
				_tmp68_ = vala_member_access_get_inner (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = vala_expression_get_value_type (_tmp69_);
				_tmp71_ = _tmp70_;
				_tmp58_ = _tmp71_ != NULL;
			} else {
				_tmp58_ = FALSE;
			}
			if (_tmp58_) {
				ValaMemberAccess* _tmp72_;
				ValaExpression* _tmp73_;
				ValaExpression* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				ValaTypeSymbol* _tmp77_;
				ValaTypeSymbol* _tmp78_;
				ValaDataType* _tmp79_;
				ValaTypeSymbol* _tmp80_;
				ValaTypeSymbol* _tmp81_;
				_tmp72_ = ma;
				_tmp73_ = vala_member_access_get_inner (_tmp72_);
				_tmp74_ = _tmp73_;
				_tmp75_ = vala_expression_get_value_type (_tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = vala_data_type_get_data_type (_tmp76_);
				_tmp78_ = _tmp77_;
				_tmp79_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp80_ = vala_data_type_get_data_type (_tmp79_);
				_tmp81_ = _tmp80_;
				_tmp57_ = _tmp78_ == _tmp81_;
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				ValaMemberAccess* _tmp82_;
				const gchar* _tmp83_;
				const gchar* _tmp84_;
				_tmp82_ = ma;
				_tmp83_ = vala_member_access_get_member_name (_tmp82_);
				_tmp84_ = _tmp83_;
				_tmp56_ = g_strcmp0 (_tmp84_, "printf") == 0;
			} else {
				_tmp56_ = FALSE;
			}
			if (_tmp56_) {
				ValaCCodeFunctionCall* _tmp85_;
				gchar* _tmp86_;
				gchar* _tmp87_;
				ValaCCodeIdentifier* _tmp88_;
				ValaCCodeIdentifier* _tmp89_;
				_tmp85_ = ccall;
				_tmp86_ = vala_ccode_method_call_module_generate_string_printf_function (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_ccode_identifier_new (_tmp87_);
				_tmp89_ = _tmp88_;
				vala_ccode_function_call_set_call (_tmp85_, (ValaCCodeExpression*) _tmp89_);
				_vala_ccode_node_unref0 (_tmp89_);
				_g_free0 (_tmp87_);
			} else {
				gboolean _tmp90_;
				gboolean _tmp91_;
				_tmp90_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp91_ = _tmp90_;
				if (_tmp91_) {
					ValaCCodeFunctionCall* _tmp92_;
					ValaMethod* _tmp93_;
					gchar* _tmp94_;
					gchar* _tmp95_;
					ValaCCodeIdentifier* _tmp96_;
					ValaCCodeIdentifier* _tmp97_;
					_tmp92_ = ccall;
					_tmp93_ = m;
					_tmp94_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_ccode_identifier_new (_tmp95_);
					_tmp97_ = _tmp96_;
					vala_ccode_function_call_set_call (_tmp92_, (ValaCCodeExpression*) _tmp97_);
					_vala_ccode_node_unref0 (_tmp97_);
					_g_free0 (_tmp95_);
				}
			}
		}
	} else {
		ValaDataType* _tmp98_;
		_tmp98_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp98_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp99_;
			ValaSignalType* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean _tmp102_ = FALSE;
			ValaMemberAccess* _tmp103_;
			_tmp99_ = itype;
			_tmp100_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp100_;
			_tmp103_ = ma;
			if (_tmp103_ != NULL) {
				ValaMemberAccess* _tmp104_;
				ValaExpression* _tmp105_;
				ValaExpression* _tmp106_;
				_tmp104_ = ma;
				_tmp105_ = vala_member_access_get_inner (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp102_ = FALSE;
			}
			if (_tmp102_) {
				ValaSignalType* _tmp107_;
				ValaSignal* _tmp108_;
				ValaSignal* _tmp109_;
				gboolean _tmp110_;
				gboolean _tmp111_;
				_tmp107_ = sig_type;
				_tmp108_ = vala_signal_type_get_signal_symbol (_tmp107_);
				_tmp109_ = _tmp108_;
				_tmp110_ = vala_signal_get_is_virtual (_tmp109_);
				_tmp111_ = _tmp110_;
				_tmp101_ = _tmp111_;
			} else {
				_tmp101_ = FALSE;
			}
			if (_tmp101_) {
				ValaSignalType* _tmp112_;
				ValaSignal* _tmp113_;
				ValaSignal* _tmp114_;
				ValaMethod* _tmp115_;
				ValaMethod* _tmp116_;
				ValaMethod* _tmp117_;
				_tmp112_ = sig_type;
				_tmp113_ = vala_signal_type_get_signal_symbol (_tmp112_);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_signal_get_default_handler (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp117_ = _vala_code_node_ref0 (_tmp116_);
				_vala_code_node_unref0 (m);
				m = _tmp117_;
			} else {
				ValaExpression* _tmp118_;
				ValaExpression* _tmp119_;
				ValaCCodeExpression* _tmp120_;
				_tmp118_ = vala_method_call_get_call (expr);
				_tmp119_ = _tmp118_;
				_tmp120_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp119_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp121_;
			_tmp121_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp121_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp122_;
				ValaObjectTypeSymbol* _tmp123_;
				ValaObjectTypeSymbol* _tmp124_;
				ValaClass* _tmp125_;
				ValaClass* _tmp126_;
				ValaCreationMethod* _tmp127_;
				ValaCreationMethod* _tmp128_;
				ValaMethod* _tmp129_;
				ValaMethod* _tmp130_;
				ValaCCodeFile* _tmp131_;
				gchar* real_name = NULL;
				ValaMethod* _tmp132_;
				gchar* _tmp133_;
				gboolean _tmp134_;
				gboolean _tmp135_;
				const gchar* _tmp138_;
				ValaCCodeIdentifier* _tmp139_;
				ValaCCodeIdentifier* _tmp140_;
				ValaCCodeFunctionCall* _tmp141_;
				_tmp122_ = itype;
				_tmp123_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp122_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp124_ = _tmp123_;
				_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp125_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_default_construction_method (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = _vala_code_node_ref0 ((ValaMethod*) _tmp128_);
				_vala_code_node_unref0 (m);
				m = _tmp129_;
				_tmp130_ = m;
				_tmp131_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp130_, _tmp131_);
				_tmp132_ = m;
				_tmp133_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp132_);
				real_name = _tmp133_;
				_tmp134_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp135_ = _tmp134_;
				if (_tmp135_) {
					ValaMethod* _tmp136_;
					gchar* _tmp137_;
					_tmp136_ = m;
					_tmp137_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp136_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp137_;
				}
				_tmp138_ = real_name;
				_tmp139_ = vala_ccode_identifier_new (_tmp138_);
				_tmp140_ = _tmp139_;
				_tmp141_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp141_;
				_vala_ccode_node_unref0 (_tmp140_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp142_;
				_tmp142_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp142_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp143_;
					ValaTypeSymbol* _tmp144_;
					ValaTypeSymbol* _tmp145_;
					ValaStruct* _tmp146_;
					ValaStruct* _tmp147_;
					ValaCreationMethod* _tmp148_;
					ValaCreationMethod* _tmp149_;
					ValaMethod* _tmp150_;
					ValaMethod* _tmp151_;
					ValaCCodeFile* _tmp152_;
					ValaMethod* _tmp153_;
					gchar* _tmp154_;
					gchar* _tmp155_;
					ValaCCodeIdentifier* _tmp156_;
					ValaCCodeIdentifier* _tmp157_;
					ValaCCodeFunctionCall* _tmp158_;
					_tmp143_ = itype;
					_tmp144_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp143_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp145_ = _tmp144_;
					_tmp146_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp146_;
					_tmp147_ = st;
					_tmp148_ = vala_struct_get_default_construction_method (_tmp147_);
					_tmp149_ = _tmp148_;
					_tmp150_ = _vala_code_node_ref0 ((ValaMethod*) _tmp149_);
					_vala_code_node_unref0 (m);
					m = _tmp150_;
					_tmp151_ = m;
					_tmp152_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp151_, _tmp152_);
					_tmp153_ = m;
					_tmp154_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp153_);
					_tmp155_ = _tmp154_;
					_tmp156_ = vala_ccode_identifier_new (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp157_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp158_;
					_vala_ccode_node_unref0 (_tmp157_);
					_g_free0 (_tmp155_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp159_;
					_tmp159_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp159_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp160_;
						ValaDelegate* _tmp161_;
						ValaDelegate* _tmp162_;
						ValaDelegate* _tmp163_;
						_tmp160_ = itype;
						_tmp161_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp162_ = _tmp161_;
						_tmp163_ = _vala_code_node_ref0 (_tmp162_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp163_;
					}
				}
			}
		}
	}
	_tmp164_ = g_direct_hash;
	_tmp165_ = g_direct_equal;
	_tmp166_ = g_direct_equal;
	_tmp167_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp164_, _tmp165_, _tmp166_);
	in_arg_map = _tmp167_;
	_tmp168_ = in_arg_map;
	_tmp169_ = _vala_map_ref0 (_tmp168_);
	out_arg_map = _tmp169_;
	_tmp171_ = m;
	if (_tmp171_ != NULL) {
		ValaMethod* _tmp172_;
		gboolean _tmp173_;
		gboolean _tmp174_;
		_tmp172_ = m;
		_tmp173_ = vala_method_get_coroutine (_tmp172_);
		_tmp174_ = _tmp173_;
		_tmp170_ = _tmp174_;
	} else {
		_tmp170_ = FALSE;
	}
	if (_tmp170_) {
		ValaMethod* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		ValaCCodeIdentifier* _tmp178_;
		ValaCCodeIdentifier* _tmp179_;
		ValaCCodeFunctionCall* _tmp180_;
		ValaMethod* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		ValaCCodeIdentifier* _tmp184_;
		ValaCCodeIdentifier* _tmp185_;
		ValaCCodeFunctionCall* _tmp186_;
		ValaMemberAccess* _tmp187_;
		ValaExpression* _tmp188_;
		ValaExpression* _tmp189_;
		gboolean _tmp265_ = FALSE;
		ValaMemberAccess* _tmp266_;
		const gchar* _tmp267_;
		const gchar* _tmp268_;
		_tmp175_ = m;
		_tmp176_ = vala_get_ccode_name ((ValaCodeNode*) _tmp175_);
		_tmp177_ = _tmp176_;
		_tmp178_ = vala_ccode_identifier_new (_tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp179_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp180_;
		_vala_ccode_node_unref0 (_tmp179_);
		_g_free0 (_tmp177_);
		_tmp181_ = m;
		_tmp182_ = vala_get_ccode_finish_name (_tmp181_);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_ccode_identifier_new (_tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp185_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp186_;
		_vala_ccode_node_unref0 (_tmp185_);
		_g_free0 (_tmp183_);
		_tmp187_ = ma;
		_tmp188_ = vala_member_access_get_inner (_tmp187_);
		_tmp189_ = _tmp188_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp189_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp190_;
			ValaMethod* _tmp191_;
			ValaMethod* _tmp192_;
			_tmp190_ = m;
			_tmp191_ = vala_method_get_base_method (_tmp190_);
			_tmp192_ = _tmp191_;
			if (_tmp192_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp193_;
				ValaMethod* _tmp194_;
				ValaMethod* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaClass* _tmp198_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp199_;
				gchar* _tmp200_;
				gchar* _tmp201_;
				ValaCCodeIdentifier* _tmp202_;
				ValaCCodeIdentifier* _tmp203_;
				ValaCCodeFunctionCall* _tmp204_;
				ValaCCodeFunctionCall* _tmp205_;
				ValaCCodeFunctionCall* _tmp206_;
				ValaClass* _tmp207_;
				ValaClass* _tmp208_;
				gchar* _tmp209_;
				gchar* _tmp210_;
				gchar* _tmp211_;
				gchar* _tmp212_;
				ValaCCodeIdentifier* _tmp213_;
				ValaCCodeIdentifier* _tmp214_;
				ValaCCodeFunctionCall* _tmp215_;
				ValaCCodeFunctionCall* _tmp216_;
				ValaMethod* _tmp217_;
				gchar* _tmp218_;
				gchar* _tmp219_;
				ValaCCodeMemberAccess* _tmp220_;
				ValaCCodeMemberAccess* _tmp221_;
				ValaCCodeFunctionCall* _tmp222_;
				ValaCCodeFunctionCall* _tmp223_;
				ValaMethod* _tmp224_;
				gchar* _tmp225_;
				gchar* _tmp226_;
				ValaCCodeMemberAccess* _tmp227_;
				ValaCCodeMemberAccess* _tmp228_;
				_tmp193_ = m;
				_tmp194_ = vala_method_get_base_method (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp197_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp198_;
				_tmp199_ = base_class;
				_tmp200_ = vala_get_ccode_class_type_function (_tmp199_);
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_ccode_identifier_new (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp203_);
				_tmp205_ = _tmp204_;
				_vala_ccode_node_unref0 (_tmp203_);
				_g_free0 (_tmp201_);
				vcast = _tmp205_;
				_tmp206_ = vcast;
				_tmp207_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp208_ = _tmp207_;
				_tmp209_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp208_, NULL);
				_tmp210_ = _tmp209_;
				_tmp211_ = g_strdup_printf ("%s_parent_class", _tmp210_);
				_tmp212_ = _tmp211_;
				_tmp213_ = vala_ccode_identifier_new (_tmp212_);
				_tmp214_ = _tmp213_;
				vala_ccode_function_call_add_argument (_tmp206_, (ValaCCodeExpression*) _tmp214_);
				_vala_ccode_node_unref0 (_tmp214_);
				_g_free0 (_tmp212_);
				_g_free0 (_tmp210_);
				_tmp215_ = async_call;
				_tmp216_ = vcast;
				_tmp217_ = m;
				_tmp218_ = vala_get_ccode_vfunc_name (_tmp217_);
				_tmp219_ = _tmp218_;
				_tmp220_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp216_, _tmp219_);
				_tmp221_ = _tmp220_;
				vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp221_);
				_vala_ccode_node_unref0 (_tmp221_);
				_g_free0 (_tmp219_);
				_tmp222_ = finish_call;
				_tmp223_ = vcast;
				_tmp224_ = m;
				_tmp225_ = vala_get_ccode_finish_vfunc_name (_tmp224_);
				_tmp226_ = _tmp225_;
				_tmp227_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp223_, _tmp226_);
				_tmp228_ = _tmp227_;
				vala_ccode_function_call_set_call (_tmp222_, (ValaCCodeExpression*) _tmp228_);
				_vala_ccode_node_unref0 (_tmp228_);
				_g_free0 (_tmp226_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp229_;
				ValaMethod* _tmp230_;
				ValaMethod* _tmp231_;
				_tmp229_ = m;
				_tmp230_ = vala_method_get_base_interface_method (_tmp229_);
				_tmp231_ = _tmp230_;
				if (_tmp231_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp232_;
					ValaMethod* _tmp233_;
					ValaMethod* _tmp234_;
					ValaSymbol* _tmp235_;
					ValaSymbol* _tmp236_;
					ValaInterface* _tmp237_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp238_;
					ValaClass* _tmp239_;
					gchar* _tmp240_;
					gchar* _tmp241_;
					ValaInterface* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					ValaCCodeFunctionCall* _tmp247_;
					const gchar* _tmp248_;
					ValaCCodeIdentifier* _tmp249_;
					ValaCCodeIdentifier* _tmp250_;
					ValaMethod* _tmp251_;
					gchar* _tmp252_;
					gchar* _tmp253_;
					ValaCCodeMemberAccess* _tmp254_;
					ValaCCodeMemberAccess* _tmp255_;
					ValaCCodeFunctionCall* _tmp256_;
					const gchar* _tmp257_;
					ValaCCodeIdentifier* _tmp258_;
					ValaCCodeIdentifier* _tmp259_;
					ValaMethod* _tmp260_;
					gchar* _tmp261_;
					gchar* _tmp262_;
					ValaCCodeMemberAccess* _tmp263_;
					ValaCCodeMemberAccess* _tmp264_;
					_tmp232_ = m;
					_tmp233_ = vala_method_get_base_interface_method (_tmp232_);
					_tmp234_ = _tmp233_;
					_tmp235_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp234_);
					_tmp236_ = _tmp235_;
					_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp237_;
					_tmp238_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp239_ = _tmp238_;
					_tmp240_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp239_, NULL);
					_tmp241_ = _tmp240_;
					_tmp242_ = base_iface;
					_tmp243_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp242_, NULL);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("%s_%s_parent_iface", _tmp241_, _tmp244_);
					_tmp246_ = _tmp245_;
					_g_free0 (_tmp244_);
					_g_free0 (_tmp241_);
					parent_iface_var = _tmp246_;
					_tmp247_ = async_call;
					_tmp248_ = parent_iface_var;
					_tmp249_ = vala_ccode_identifier_new (_tmp248_);
					_tmp250_ = _tmp249_;
					_tmp251_ = m;
					_tmp252_ = vala_get_ccode_vfunc_name (_tmp251_);
					_tmp253_ = _tmp252_;
					_tmp254_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp250_, _tmp253_);
					_tmp255_ = _tmp254_;
					vala_ccode_function_call_set_call (_tmp247_, (ValaCCodeExpression*) _tmp255_);
					_vala_ccode_node_unref0 (_tmp255_);
					_g_free0 (_tmp253_);
					_vala_ccode_node_unref0 (_tmp250_);
					_tmp256_ = finish_call;
					_tmp257_ = parent_iface_var;
					_tmp258_ = vala_ccode_identifier_new (_tmp257_);
					_tmp259_ = _tmp258_;
					_tmp260_ = m;
					_tmp261_ = vala_get_ccode_finish_vfunc_name (_tmp260_);
					_tmp262_ = _tmp261_;
					_tmp263_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp259_, _tmp262_);
					_tmp264_ = _tmp263_;
					vala_ccode_function_call_set_call (_tmp256_, (ValaCCodeExpression*) _tmp264_);
					_vala_ccode_node_unref0 (_tmp264_);
					_g_free0 (_tmp262_);
					_vala_ccode_node_unref0 (_tmp259_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp266_ = ma;
		_tmp267_ = vala_member_access_get_member_name (_tmp266_);
		_tmp268_ = _tmp267_;
		if (g_strcmp0 (_tmp268_, "begin") == 0) {
			ValaMemberAccess* _tmp269_;
			ValaExpression* _tmp270_;
			ValaExpression* _tmp271_;
			ValaSymbol* _tmp272_;
			ValaSymbol* _tmp273_;
			ValaMemberAccess* _tmp274_;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			_tmp269_ = ma;
			_tmp270_ = vala_member_access_get_inner (_tmp269_);
			_tmp271_ = _tmp270_;
			_tmp272_ = vala_expression_get_symbol_reference (_tmp271_);
			_tmp273_ = _tmp272_;
			_tmp274_ = ma;
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp274_);
			_tmp276_ = _tmp275_;
			_tmp265_ = _tmp273_ == _tmp276_;
		} else {
			_tmp265_ = FALSE;
		}
		if (_tmp265_) {
			ValaCCodeFunctionCall* _tmp277_;
			ValaCCodeFunctionCall* _tmp278_;
			ValaMethod* _tmp279_;
			ValaList* _tmp280_;
			_tmp277_ = async_call;
			_tmp278_ = _vala_ccode_node_ref0 (_tmp277_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp278_;
			_tmp279_ = m;
			_tmp280_ = vala_method_get_async_begin_parameters (_tmp279_);
			_vala_iterable_unref0 (params);
			params = _tmp280_;
		} else {
			gboolean _tmp281_ = FALSE;
			ValaMemberAccess* _tmp282_;
			const gchar* _tmp283_;
			const gchar* _tmp284_;
			_tmp282_ = ma;
			_tmp283_ = vala_member_access_get_member_name (_tmp282_);
			_tmp284_ = _tmp283_;
			if (g_strcmp0 (_tmp284_, "end") == 0) {
				ValaMemberAccess* _tmp285_;
				ValaExpression* _tmp286_;
				ValaExpression* _tmp287_;
				ValaSymbol* _tmp288_;
				ValaSymbol* _tmp289_;
				ValaMemberAccess* _tmp290_;
				ValaSymbol* _tmp291_;
				ValaSymbol* _tmp292_;
				_tmp285_ = ma;
				_tmp286_ = vala_member_access_get_inner (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp288_ = vala_expression_get_symbol_reference (_tmp287_);
				_tmp289_ = _tmp288_;
				_tmp290_ = ma;
				_tmp291_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp290_);
				_tmp292_ = _tmp291_;
				_tmp281_ = _tmp289_ == _tmp292_;
			} else {
				_tmp281_ = FALSE;
			}
			if (_tmp281_) {
				ValaCCodeFunctionCall* _tmp293_;
				ValaCCodeFunctionCall* _tmp294_;
				ValaMethod* _tmp295_;
				ValaList* _tmp296_;
				_tmp293_ = finish_call;
				_tmp294_ = _vala_ccode_node_ref0 (_tmp293_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp294_;
				_tmp295_ = m;
				_tmp296_ = vala_method_get_async_end_parameters (_tmp295_);
				_vala_iterable_unref0 (params);
				params = _tmp296_;
			} else {
				gboolean _tmp297_;
				gboolean _tmp298_;
				_tmp297_ = vala_method_call_get_is_yield_expression (expr);
				_tmp298_ = _tmp297_;
				if (!_tmp298_) {
					ValaCCodeFunctionCall* _tmp299_;
					ValaCCodeFunctionCall* _tmp300_;
					ValaMethod* _tmp301_;
					ValaList* _tmp302_;
					_tmp299_ = async_call;
					_tmp300_ = _vala_ccode_node_ref0 (_tmp299_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp300_;
					_tmp301_ = m;
					_tmp302_ = vala_method_get_async_begin_parameters (_tmp301_);
					_vala_iterable_unref0 (params);
					params = _tmp302_;
				} else {
					ValaCCodeFunctionCall* _tmp303_;
					ValaCCodeFunctionCall* _tmp304_;
					GHashFunc _tmp305_;
					GEqualFunc _tmp306_;
					GEqualFunc _tmp307_;
					ValaHashMap* _tmp308_;
					ValaHashMap* _tmp309_;
					ValaCCodeIdentifier* _tmp310_;
					ValaCCodeIdentifier* _tmp311_;
					ValaCCodeMemberAccess* _tmp312_;
					ValaCCodeMemberAccess* _tmp313_;
					_tmp303_ = finish_call;
					_tmp304_ = _vala_ccode_node_ref0 (_tmp303_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp304_;
					_tmp305_ = g_direct_hash;
					_tmp306_ = g_direct_equal;
					_tmp307_ = g_direct_equal;
					_tmp308_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp305_, _tmp306_, _tmp307_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp308_;
					_tmp309_ = out_arg_map;
					_tmp310_ = vala_ccode_identifier_new ("_data_");
					_tmp311_ = _tmp310_;
					_tmp312_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp311_, "_res_");
					_tmp313_ = _tmp312_;
					vala_map_set ((ValaMap*) _tmp309_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp313_);
					_vala_ccode_node_unref0 (_tmp313_);
					_vala_ccode_node_unref0 (_tmp311_);
				}
			}
		}
	}
	_tmp315_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp315_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp316_;
		ValaSymbol* _tmp317_;
		ValaSymbol* _tmp318_;
		_tmp316_ = m;
		_tmp317_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp316_);
		_tmp318_ = _tmp317_;
		_tmp314_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp318_, VALA_TYPE_CLASS);
	} else {
		_tmp314_ = FALSE;
	}
	if (_tmp314_) {
		ValaCodeContext* _tmp319_;
		ValaCodeContext* _tmp320_;
		ValaProfile _tmp321_;
		ValaProfile _tmp322_;
		ValaClass* _tmp334_;
		ValaClass* _tmp335_;
		gboolean _tmp336_;
		gboolean _tmp337_;
		_tmp319_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
		_tmp320_ = _tmp319_;
		_tmp321_ = vala_code_context_get_profile (_tmp320_);
		_tmp322_ = _tmp321_;
		if (_tmp322_ == VALA_PROFILE_GOBJECT) {
			ValaMethod* _tmp323_;
			ValaSymbol* _tmp324_;
			ValaSymbol* _tmp325_;
			gboolean _tmp326_;
			gboolean _tmp327_;
			_tmp323_ = m;
			_tmp324_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp323_);
			_tmp325_ = _tmp324_;
			_tmp326_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_CLASS, ValaClass));
			_tmp327_ = _tmp326_;
			if (!_tmp327_) {
				ValaCCodeFunctionCall* _tmp328_;
				ValaCCodeExpression* _tmp329_;
				ValaCCodeExpression* _tmp330_;
				_tmp328_ = ccall;
				_tmp329_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
				_tmp330_ = _tmp329_;
				vala_ccode_function_call_add_argument (_tmp328_, _tmp330_);
				_vala_ccode_node_unref0 (_tmp330_);
			}
		} else {
			ValaCCodeFunctionCall* _tmp331_;
			ValaCCodeExpression* _tmp332_;
			ValaCCodeExpression* _tmp333_;
			_tmp331_ = ccall;
			_tmp332_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp333_ = _tmp332_;
			vala_ccode_function_call_add_argument (_tmp331_, _tmp333_);
			_vala_ccode_node_unref0 (_tmp333_);
		}
		_tmp334_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp335_ = _tmp334_;
		_tmp336_ = vala_class_get_is_compact (_tmp335_);
		_tmp337_ = _tmp336_;
		if (!_tmp337_) {
			ValaClass* _tmp338_;
			ValaClass* _tmp339_;
			ValaMethod* _tmp340_;
			ValaSymbol* _tmp341_;
			ValaSymbol* _tmp342_;
			_tmp338_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp339_ = _tmp338_;
			_tmp340_ = m;
			_tmp341_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp340_);
			_tmp342_ = _tmp341_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp339_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp342_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp343_;
					ValaClass* _tmp344_;
					ValaList* _tmp345_;
					gint _base_type_size = 0;
					ValaList* _tmp346_;
					gint _tmp347_;
					gint _tmp348_;
					gint _base_type_index = 0;
					_tmp343_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp344_ = _tmp343_;
					_tmp345_ = vala_class_get_base_types (_tmp344_);
					_base_type_list = _tmp345_;
					_tmp346_ = _base_type_list;
					_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
					_tmp348_ = _tmp347_;
					_base_type_size = _tmp348_;
					_base_type_index = -1;
					while (TRUE) {
						ValaDataType* base_type = NULL;
						ValaList* _tmp349_;
						gpointer _tmp350_;
						ValaDataType* _tmp351_;
						ValaTypeSymbol* _tmp352_;
						ValaTypeSymbol* _tmp353_;
						_base_type_index = _base_type_index + 1;
						if (!(_base_type_index < _base_type_size)) {
							break;
						}
						_tmp349_ = _base_type_list;
						_tmp350_ = vala_list_get (_tmp349_, _base_type_index);
						base_type = (ValaDataType*) _tmp350_;
						_tmp351_ = base_type;
						_tmp352_ = vala_data_type_get_data_type (_tmp351_);
						_tmp353_ = _tmp352_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp353_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp354_;
							gchar* _tmp355_;
							gchar* _tmp356_;
							gboolean _tmp357_;
							ValaHashMap* _tmp362_;
							ValaDataType* _tmp363_;
							ValaList* _tmp364_;
							ValaList* _tmp365_;
							ValaList* _tmp366_;
							type_parameters = NULL;
							_tmp354_ = m;
							_tmp355_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp354_);
							_tmp356_ = _tmp355_;
							_tmp357_ = g_strcmp0 (_tmp356_, "g_object_new") == 0;
							_g_free0 (_tmp356_);
							if (_tmp357_) {
								ValaDataType* _tmp358_;
								ValaTypeSymbol* _tmp359_;
								ValaTypeSymbol* _tmp360_;
								ValaList* _tmp361_;
								_tmp358_ = base_type;
								_tmp359_ = vala_data_type_get_data_type (_tmp358_);
								_tmp360_ = _tmp359_;
								_tmp361_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp361_;
							}
							_tmp362_ = in_arg_map;
							_tmp363_ = base_type;
							_tmp364_ = vala_data_type_get_type_arguments (_tmp363_);
							_tmp365_ = _tmp364_;
							_tmp366_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp362_, _tmp365_, (ValaCodeNode*) expr, TRUE, _tmp366_);
							_vala_iterable_unref0 (_tmp365_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp367_;
				ValaSymbol* _tmp368_;
				ValaSymbol* _tmp369_;
				ValaClass* _tmp370_;
				type_param_index = 0;
				_tmp367_ = m;
				_tmp368_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp367_);
				_tmp369_ = _tmp368_;
				_tmp370_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp369_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp370_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp371_;
					ValaList* _tmp372_;
					gint _type_param_size = 0;
					ValaList* _tmp373_;
					gint _tmp374_;
					gint _tmp375_;
					gint _type_param_index = 0;
					_tmp371_ = cl;
					_tmp372_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp371_);
					_type_param_list = _tmp372_;
					_tmp373_ = _type_param_list;
					_tmp374_ = vala_collection_get_size ((ValaCollection*) _tmp373_);
					_tmp375_ = _tmp374_;
					_type_param_size = _tmp375_;
					_type_param_index = -1;
					while (TRUE) {
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp376_;
						gpointer _tmp377_;
						ValaHashMap* _tmp378_;
						ValaTypeParameter* _tmp379_;
						const gchar* _tmp380_;
						const gchar* _tmp381_;
						gchar* _tmp382_;
						gchar* _tmp383_;
						gchar* _tmp384_;
						gchar* _tmp385_;
						ValaCCodeIdentifier* _tmp386_;
						ValaCCodeIdentifier* _tmp387_;
						ValaHashMap* _tmp388_;
						ValaTypeParameter* _tmp389_;
						const gchar* _tmp390_;
						const gchar* _tmp391_;
						gchar* _tmp392_;
						gchar* _tmp393_;
						gchar* _tmp394_;
						gchar* _tmp395_;
						ValaCCodeIdentifier* _tmp396_;
						ValaCCodeIdentifier* _tmp397_;
						ValaHashMap* _tmp398_;
						ValaTypeParameter* _tmp399_;
						const gchar* _tmp400_;
						const gchar* _tmp401_;
						gchar* _tmp402_;
						gchar* _tmp403_;
						gchar* _tmp404_;
						gchar* _tmp405_;
						ValaCCodeIdentifier* _tmp406_;
						ValaCCodeIdentifier* _tmp407_;
						gint _tmp408_;
						_type_param_index = _type_param_index + 1;
						if (!(_type_param_index < _type_param_size)) {
							break;
						}
						_tmp376_ = _type_param_list;
						_tmp377_ = vala_list_get (_tmp376_, _type_param_index);
						type_param = (ValaTypeParameter*) _tmp377_;
						_tmp378_ = in_arg_map;
						_tmp379_ = type_param;
						_tmp380_ = vala_symbol_get_name ((ValaSymbol*) _tmp379_);
						_tmp381_ = _tmp380_;
						_tmp382_ = g_utf8_strdown (_tmp381_, (gssize) -1);
						_tmp383_ = _tmp382_;
						_tmp384_ = g_strdup_printf ("%s_type", _tmp383_);
						_tmp385_ = _tmp384_;
						_tmp386_ = vala_ccode_identifier_new (_tmp385_);
						_tmp387_ = _tmp386_;
						vala_map_set ((ValaMap*) _tmp378_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp387_);
						_vala_ccode_node_unref0 (_tmp387_);
						_g_free0 (_tmp385_);
						_g_free0 (_tmp383_);
						_tmp388_ = in_arg_map;
						_tmp389_ = type_param;
						_tmp390_ = vala_symbol_get_name ((ValaSymbol*) _tmp389_);
						_tmp391_ = _tmp390_;
						_tmp392_ = g_utf8_strdown (_tmp391_, (gssize) -1);
						_tmp393_ = _tmp392_;
						_tmp394_ = g_strdup_printf ("%s_dup_func", _tmp393_);
						_tmp395_ = _tmp394_;
						_tmp396_ = vala_ccode_identifier_new (_tmp395_);
						_tmp397_ = _tmp396_;
						vala_map_set ((ValaMap*) _tmp388_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp397_);
						_vala_ccode_node_unref0 (_tmp397_);
						_g_free0 (_tmp395_);
						_g_free0 (_tmp393_);
						_tmp398_ = in_arg_map;
						_tmp399_ = type_param;
						_tmp400_ = vala_symbol_get_name ((ValaSymbol*) _tmp399_);
						_tmp401_ = _tmp400_;
						_tmp402_ = g_utf8_strdown (_tmp401_, (gssize) -1);
						_tmp403_ = _tmp402_;
						_tmp404_ = g_strdup_printf ("%s_destroy_func", _tmp403_);
						_tmp405_ = _tmp404_;
						_tmp406_ = vala_ccode_identifier_new (_tmp405_);
						_tmp407_ = _tmp406_;
						vala_map_set ((ValaMap*) _tmp398_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * type_param_index) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp407_);
						_vala_ccode_node_unref0 (_tmp407_);
						_g_free0 (_tmp405_);
						_g_free0 (_tmp403_);
						_tmp408_ = type_param_index;
						type_param_index = _tmp408_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp409_;
			ValaClass* _tmp410_;
			ValaClass* _tmp411_;
			ValaClass* _tmp412_;
			ValaClass* _tmp413_;
			_tmp409_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp410_ = _tmp409_;
			_tmp411_ = vala_class_get_base_class (_tmp410_);
			_tmp412_ = _tmp411_;
			_tmp413_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp412_ == _tmp413_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp414_;
				ValaClass* _tmp415_;
				gchar* _tmp416_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp417_;
				ValaCCodeDeclaration* _tmp418_;
				ValaCCodeDeclaration* _tmp419_;
				const gchar* _tmp420_;
				const gchar* _tmp421_;
				const gchar* _tmp422_;
				const gchar* _tmp423_;
				gchar* _tmp424_;
				gchar* _tmp425_;
				ValaCCodeConstant* _tmp426_;
				ValaCCodeConstant* _tmp427_;
				ValaCCodeVariableDeclarator* _tmp428_;
				ValaCCodeVariableDeclarator* _tmp429_;
				ValaCCodeFunction* _tmp430_;
				ValaCCodeFunction* _tmp431_;
				ValaCCodeDeclaration* _tmp432_;
				ValaCCodeFunctionCall* _tmp433_;
				ValaCCodeIdentifier* _tmp434_;
				ValaCCodeIdentifier* _tmp435_;
				ValaCCodeUnaryExpression* _tmp436_;
				ValaCCodeUnaryExpression* _tmp437_;
				ValaCCodeCastExpression* _tmp438_;
				ValaCCodeCastExpression* _tmp439_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp440_;
				ValaCCodeIdentifier* _tmp441_;
				ValaCCodeFunctionCall* _tmp442_;
				ValaCCodeFunctionCall* _tmp443_;
				ValaCCodeFunctionCall* _tmp444_;
				ValaClass* _tmp445_;
				ValaClass* _tmp446_;
				gchar* _tmp447_;
				gchar* _tmp448_;
				ValaCCodeIdentifier* _tmp449_;
				ValaCCodeIdentifier* _tmp450_;
				ValaCCodeFunctionCall* _tmp451_;
				ValaCCodeFunctionCall* _tmp452_;
				_tmp414_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp415_ = _tmp414_;
				_tmp416_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp415_, NULL);
				class_prefix = _tmp416_;
				_tmp417_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp417_;
				_tmp418_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp418_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp419_ = funcs;
				_tmp420_ = class_prefix;
				_tmp421_ = class_prefix;
				_tmp422_ = class_prefix;
				_tmp423_ = class_prefix;
				_tmp424_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp420_, _tmp421_, _tmp422_, _tmp423_);
				_tmp425_ = _tmp424_;
				_tmp426_ = vala_ccode_constant_new (_tmp425_);
				_tmp427_ = _tmp426_;
				_tmp428_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp427_, NULL);
				_tmp429_ = _tmp428_;
				vala_ccode_declaration_add_declarator (_tmp419_, (ValaCCodeDeclarator*) _tmp429_);
				_vala_ccode_node_unref0 (_tmp429_);
				_vala_ccode_node_unref0 (_tmp427_);
				_g_free0 (_tmp425_);
				_tmp430_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp431_ = _tmp430_;
				_tmp432_ = funcs;
				vala_ccode_function_add_statement (_tmp431_, (ValaCCodeNode*) _tmp432_);
				_tmp433_ = ccall;
				_tmp434_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp435_ = _tmp434_;
				_tmp436_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp435_);
				_tmp437_ = _tmp436_;
				_tmp438_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp437_, "GSourceFuncs *");
				_tmp439_ = _tmp438_;
				vala_ccode_function_call_add_argument (_tmp433_, (ValaCCodeExpression*) _tmp439_);
				_vala_ccode_node_unref0 (_tmp439_);
				_vala_ccode_node_unref0 (_tmp437_);
				_vala_ccode_node_unref0 (_tmp435_);
				_tmp440_ = vala_ccode_identifier_new ("sizeof");
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp441_);
				_tmp443_ = _tmp442_;
				_vala_ccode_node_unref0 (_tmp441_);
				csizeof = _tmp443_;
				_tmp444_ = csizeof;
				_tmp445_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp446_ = _tmp445_;
				_tmp447_ = vala_get_ccode_name ((ValaCodeNode*) _tmp446_);
				_tmp448_ = _tmp447_;
				_tmp449_ = vala_ccode_identifier_new (_tmp448_);
				_tmp450_ = _tmp449_;
				vala_ccode_function_call_add_argument (_tmp444_, (ValaCCodeExpression*) _tmp450_);
				_vala_ccode_node_unref0 (_tmp450_);
				_g_free0 (_tmp448_);
				_tmp451_ = ccall;
				_tmp452_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp451_, (ValaCCodeExpression*) _tmp452_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp453_ = FALSE;
		ValaMethod* _tmp454_;
		_tmp454_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp454_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp455_;
			ValaSymbol* _tmp456_;
			ValaSymbol* _tmp457_;
			_tmp455_ = m;
			_tmp456_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp455_);
			_tmp457_ = _tmp456_;
			_tmp453_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp457_, VALA_TYPE_STRUCT);
		} else {
			_tmp453_ = FALSE;
		}
		if (_tmp453_) {
			ValaCCodeFunctionCall* _tmp458_;
			ValaCCodeExpression* _tmp459_;
			ValaCCodeExpression* _tmp460_;
			_tmp458_ = ccall;
			_tmp459_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp460_ = _tmp459_;
			vala_ccode_function_call_add_argument (_tmp458_, _tmp460_);
			_vala_ccode_node_unref0 (_tmp460_);
		} else {
			gboolean _tmp461_ = FALSE;
			gboolean _tmp462_ = FALSE;
			gboolean _tmp463_ = FALSE;
			gboolean _tmp464_ = FALSE;
			ValaMethod* _tmp465_;
			_tmp465_ = m;
			if (_tmp465_ != NULL) {
				ValaMethod* _tmp466_;
				_tmp466_ = m;
				_tmp464_ = vala_method_has_type_parameters (_tmp466_);
			} else {
				_tmp464_ = FALSE;
			}
			if (_tmp464_) {
				ValaMethod* _tmp467_;
				_tmp467_ = m;
				_tmp463_ = !vala_get_ccode_has_generic_type_parameter (_tmp467_);
			} else {
				_tmp463_ = FALSE;
			}
			if (_tmp463_) {
				ValaMethod* _tmp468_;
				_tmp468_ = m;
				_tmp462_ = !vala_get_ccode_simple_generics (_tmp468_);
			} else {
				_tmp462_ = FALSE;
			}
			if (_tmp462_) {
				gboolean _tmp469_ = FALSE;
				ValaCCodeFunctionCall* _tmp470_;
				ValaCCodeFunctionCall* _tmp471_;
				_tmp470_ = ccall;
				_tmp471_ = finish_call;
				if (_tmp470_ != _tmp471_) {
					_tmp469_ = TRUE;
				} else {
					gboolean _tmp472_;
					gboolean _tmp473_;
					_tmp472_ = vala_method_call_get_is_yield_expression (expr);
					_tmp473_ = _tmp472_;
					_tmp469_ = _tmp473_;
				}
				_tmp461_ = _tmp469_;
			} else {
				_tmp461_ = FALSE;
			}
			if (_tmp461_) {
				ValaHashMap* _tmp474_;
				ValaMemberAccess* _tmp475_;
				ValaList* _tmp476_;
				ValaList* _tmp477_;
				_tmp474_ = in_arg_map;
				_tmp475_ = ma;
				_tmp476_ = vala_member_access_get_type_arguments (_tmp475_);
				_tmp477_ = _tmp476_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp474_, _tmp477_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp477_);
			}
		}
	}
	_tmp478_ = ccall;
	_tmp479_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp478_);
	ccall_expr = _tmp479_;
	_tmp480_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp480_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp481_;
		ValaExpression* _tmp482_;
		ValaExpression* _tmp483_;
		ValaDataType* _tmp484_;
		ValaDataType* _tmp485_;
		ValaArrayType* _tmp486_;
		ValaHashMap* _tmp487_;
		ValaArrayType* _tmp488_;
		ValaDataType* _tmp489_;
		ValaDataType* _tmp490_;
		gchar* _tmp491_;
		gchar* _tmp492_;
		ValaCCodeIdentifier* _tmp493_;
		ValaCCodeIdentifier* _tmp494_;
		_tmp481_ = ma;
		_tmp482_ = vala_member_access_get_inner (_tmp481_);
		_tmp483_ = _tmp482_;
		_tmp484_ = vala_expression_get_value_type (_tmp483_);
		_tmp485_ = _tmp484_;
		_tmp486_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp485_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp486_;
		_tmp487_ = in_arg_map;
		_tmp488_ = array_type;
		_tmp489_ = vala_array_type_get_element_type (_tmp488_);
		_tmp490_ = _tmp489_;
		_tmp491_ = vala_get_ccode_name ((ValaCodeNode*) _tmp490_);
		_tmp492_ = _tmp491_;
		_tmp493_ = vala_ccode_identifier_new (_tmp492_);
		_tmp494_ = _tmp493_;
		vala_map_set ((ValaMap*) _tmp487_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp494_);
		_vala_ccode_node_unref0 (_tmp494_);
		_g_free0 (_tmp492_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp495_;
		_tmp495_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp495_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp496_;
			_tmp496_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp496_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp497_;
				ValaExpression* _tmp498_;
				ValaExpression* _tmp499_;
				ValaTargetValue* _tmp500_;
				ValaTargetValue* _tmp501_;
				ValaTargetValue* _tmp502_;
				ValaTargetValue* _tmp503_;
				_tmp497_ = ma;
				_tmp498_ = vala_member_access_get_inner (_tmp497_);
				_tmp499_ = _tmp498_;
				_tmp500_ = vala_expression_get_target_value (_tmp499_);
				_tmp501_ = _tmp500_;
				_tmp502_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp501_, (ValaCodeNode*) expr);
				_tmp503_ = _tmp502_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp503_);
				_vala_target_value_unref0 (_tmp503_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp505_ = m;
	if (_tmp505_ != NULL) {
		ValaMethod* _tmp506_;
		gboolean _tmp507_;
		gboolean _tmp508_;
		_tmp506_ = m;
		_tmp507_ = vala_method_get_is_async_callback (_tmp506_);
		_tmp508_ = _tmp507_;
		_tmp504_ = _tmp508_;
	} else {
		_tmp504_ = FALSE;
	}
	if (_tmp504_) {
		ValaMethod* _tmp509_;
		ValaMethod* _tmp510_;
		gboolean _tmp511_;
		gboolean _tmp512_;
		ValaHashMap* _tmp526_;
		ValaMethod* _tmp527_;
		ValaCCodeExpression* _tmp528_;
		ValaHashMap* _tmp529_;
		ValaMethod* _tmp530_;
		ValaCCodeExpression* _tmp531_;
		_tmp509_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp510_ = _tmp509_;
		_tmp511_ = vala_method_get_closure (_tmp510_);
		_tmp512_ = _tmp511_;
		if (_tmp512_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp513_;
			ValaSymbol* _tmp514_;
			ValaSymbol* _tmp515_;
			ValaBlock* _tmp516_;
			ValaBlock* _tmp517_;
			ValaBlock* _tmp518_;
			ValaBlock* _tmp519_;
			gchar* _tmp520_;
			gchar* _tmp521_;
			ValaCCodeExpression* _tmp522_;
			ValaCCodeExpression* _tmp523_;
			ValaCCodeMemberAccess* _tmp524_;
			_tmp513_ = m;
			_tmp514_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp513_);
			_tmp515_ = _tmp514_;
			_tmp516_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp515_, VALA_TYPE_METHOD, ValaMethod));
			_tmp517_ = _tmp516_;
			_tmp518_ = _vala_code_node_ref0 (_tmp517_);
			block = _tmp518_;
			_tmp519_ = block;
			_tmp520_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp519_));
			_tmp521_ = _tmp520_;
			_tmp522_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp521_);
			_tmp523_ = _tmp522_;
			_tmp524_ = vala_ccode_member_access_new_pointer (_tmp523_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp524_;
			_vala_ccode_node_unref0 (_tmp523_);
			_g_free0 (_tmp521_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp525_;
			_tmp525_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp525_;
		}
		_tmp526_ = in_arg_map;
		_tmp527_ = m;
		_tmp528_ = instance;
		vala_map_set ((ValaMap*) _tmp526_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp527_), FALSE)), _tmp528_);
		_tmp529_ = out_arg_map;
		_tmp530_ = m;
		_tmp531_ = instance;
		vala_map_set ((ValaMap*) _tmp529_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp530_), FALSE)), _tmp531_);
	} else {
		gboolean _tmp532_ = FALSE;
		gboolean _tmp533_ = FALSE;
		ValaMethod* _tmp534_;
		_tmp534_ = m;
		if (_tmp534_ != NULL) {
			ValaMethod* _tmp535_;
			ValaMemberBinding _tmp536_;
			ValaMemberBinding _tmp537_;
			_tmp535_ = m;
			_tmp536_ = vala_method_get_binding (_tmp535_);
			_tmp537_ = _tmp536_;
			_tmp533_ = _tmp537_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp533_ = FALSE;
		}
		if (_tmp533_) {
			ValaMethod* _tmp538_;
			_tmp538_ = m;
			_tmp532_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp538_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp532_ = FALSE;
		}
		if (_tmp532_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp539_;
			ValaExpression* _tmp540_;
			ValaExpression* _tmp541_;
			ValaTargetValue* _tmp542_;
			ValaTargetValue* _tmp543_;
			ValaTargetValue* _tmp544_;
			gboolean _tmp545_ = FALSE;
			gboolean _tmp546_ = FALSE;
			ValaMemberAccess* _tmp547_;
			const gchar* _tmp548_;
			const gchar* _tmp549_;
			ValaTargetValue* _tmp571_;
			ValaCCodeExpression* _tmp572_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp573_;
			ValaSymbol* _tmp574_;
			ValaSymbol* _tmp575_;
			ValaStruct* _tmp576_;
			gboolean _tmp577_ = FALSE;
			ValaStruct* _tmp578_;
			gboolean _tmp587_;
			gboolean _tmp588_;
			_tmp539_ = ma;
			_tmp540_ = vala_member_access_get_inner (_tmp539_);
			_tmp541_ = _tmp540_;
			_tmp542_ = vala_expression_get_target_value (_tmp541_);
			_tmp543_ = _tmp542_;
			_tmp544_ = _vala_target_value_ref0 (_tmp543_);
			instance_value = _tmp544_;
			_tmp547_ = ma;
			_tmp548_ = vala_member_access_get_member_name (_tmp547_);
			_tmp549_ = _tmp548_;
			if (g_strcmp0 (_tmp549_, "begin") == 0) {
				_tmp546_ = TRUE;
			} else {
				ValaMemberAccess* _tmp550_;
				const gchar* _tmp551_;
				const gchar* _tmp552_;
				_tmp550_ = ma;
				_tmp551_ = vala_member_access_get_member_name (_tmp550_);
				_tmp552_ = _tmp551_;
				_tmp546_ = g_strcmp0 (_tmp552_, "end") == 0;
			}
			if (_tmp546_) {
				ValaMemberAccess* _tmp553_;
				ValaExpression* _tmp554_;
				ValaExpression* _tmp555_;
				ValaSymbol* _tmp556_;
				ValaSymbol* _tmp557_;
				ValaMemberAccess* _tmp558_;
				ValaSymbol* _tmp559_;
				ValaSymbol* _tmp560_;
				_tmp553_ = ma;
				_tmp554_ = vala_member_access_get_inner (_tmp553_);
				_tmp555_ = _tmp554_;
				_tmp556_ = vala_expression_get_symbol_reference (_tmp555_);
				_tmp557_ = _tmp556_;
				_tmp558_ = ma;
				_tmp559_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp558_);
				_tmp560_ = _tmp559_;
				_tmp545_ = _tmp557_ == _tmp560_;
			} else {
				_tmp545_ = FALSE;
			}
			if (_tmp545_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp561_;
				ValaExpression* _tmp562_;
				ValaExpression* _tmp563_;
				ValaMemberAccess* _tmp564_;
				ValaMemberAccess* _tmp565_;
				ValaExpression* _tmp566_;
				ValaExpression* _tmp567_;
				ValaTargetValue* _tmp568_;
				ValaTargetValue* _tmp569_;
				ValaTargetValue* _tmp570_;
				_tmp561_ = ma;
				_tmp562_ = vala_member_access_get_inner (_tmp561_);
				_tmp563_ = _tmp562_;
				_tmp564_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp563_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp564_;
				_tmp565_ = inner_ma;
				_tmp566_ = vala_member_access_get_inner (_tmp565_);
				_tmp567_ = _tmp566_;
				_tmp568_ = vala_expression_get_target_value (_tmp567_);
				_tmp569_ = _tmp568_;
				_tmp570_ = _vala_target_value_ref0 (_tmp569_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp570_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp571_ = instance_value;
			_tmp572_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp571_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp572_;
			_tmp573_ = m;
			_tmp574_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp573_);
			_tmp575_ = _tmp574_;
			_tmp576_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp575_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp575_) : NULL);
			st = _tmp576_;
			_tmp578_ = st;
			if (_tmp578_ != NULL) {
				ValaStruct* _tmp579_;
				_tmp579_ = st;
				_tmp577_ = !vala_struct_is_simple_type (_tmp579_);
			} else {
				_tmp577_ = FALSE;
			}
			if (_tmp577_) {
				ValaTargetValue* _tmp580_;
				ValaTargetValue* _tmp583_;
				ValaCCodeExpression* _tmp584_;
				ValaCCodeExpression* _tmp585_;
				ValaCCodeUnaryExpression* _tmp586_;
				_tmp580_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp580_)) {
					ValaTargetValue* _tmp581_;
					ValaTargetValue* _tmp582_;
					_tmp581_ = instance_value;
					_tmp582_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp581_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp582_;
				}
				_tmp583_ = instance_value;
				_tmp584_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp583_);
				_tmp585_ = _tmp584_;
				_tmp586_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp585_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp586_;
				_vala_ccode_node_unref0 (_tmp585_);
			}
			_tmp587_ = vala_method_call_get_is_yield_expression (expr);
			_tmp588_ = _tmp587_;
			if (_tmp588_) {
				ValaHashMap* _tmp589_;
				ValaMethod* _tmp590_;
				ValaCCodeExpression* _tmp591_;
				ValaMethod* _tmp592_;
				_tmp589_ = in_arg_map;
				_tmp590_ = m;
				_tmp591_ = instance;
				vala_map_set ((ValaMap*) _tmp589_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp590_), FALSE)), _tmp591_);
				_tmp592_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp592_)) {
					ValaHashMap* _tmp593_;
					ValaMethod* _tmp594_;
					ValaCCodeExpression* _tmp595_;
					_tmp593_ = out_arg_map;
					_tmp594_ = m;
					_tmp595_ = instance;
					vala_map_set ((ValaMap*) _tmp593_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp594_), FALSE)), _tmp595_);
				}
			} else {
				gboolean _tmp596_ = FALSE;
				ValaMemberAccess* _tmp597_;
				const gchar* _tmp598_;
				const gchar* _tmp599_;
				_tmp597_ = ma;
				_tmp598_ = vala_member_access_get_member_name (_tmp597_);
				_tmp599_ = _tmp598_;
				if (g_strcmp0 (_tmp599_, "end") != 0) {
					_tmp596_ = TRUE;
				} else {
					ValaMethod* _tmp600_;
					_tmp600_ = m;
					_tmp596_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp600_);
				}
				if (_tmp596_) {
					ValaHashMap* _tmp601_;
					ValaMethod* _tmp602_;
					ValaCCodeExpression* _tmp603_;
					ValaHashMap* _tmp604_;
					ValaMethod* _tmp605_;
					ValaCCodeExpression* _tmp606_;
					_tmp601_ = out_arg_map;
					_tmp602_ = m;
					_tmp603_ = instance;
					vala_map_set ((ValaMap*) _tmp601_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp602_), FALSE)), _tmp603_);
					_tmp604_ = in_arg_map;
					_tmp605_ = m;
					_tmp606_ = instance;
					vala_map_set ((ValaMap*) _tmp604_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp605_), FALSE)), _tmp606_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp607_ = FALSE;
			ValaMethod* _tmp608_;
			_tmp608_ = m;
			if (_tmp608_ != NULL) {
				ValaMethod* _tmp609_;
				ValaMemberBinding _tmp610_;
				ValaMemberBinding _tmp611_;
				_tmp609_ = m;
				_tmp610_ = vala_method_get_binding (_tmp609_);
				_tmp611_ = _tmp610_;
				_tmp607_ = _tmp611_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp607_ = FALSE;
			}
			if (_tmp607_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp612_;
				ValaSymbol* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaClass* _tmp615_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp616_;
				gchar* _tmp617_;
				gchar* _tmp618_;
				ValaCCodeIdentifier* _tmp619_;
				ValaCCodeIdentifier* _tmp620_;
				ValaCCodeFunctionCall* _tmp621_;
				ValaCCodeFunctionCall* _tmp622_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp623_;
				ValaExpression* _tmp624_;
				ValaExpression* _tmp625_;
				ValaCCodeFunctionCall* _tmp651_;
				ValaCCodeExpression* _tmp652_;
				ValaHashMap* _tmp653_;
				ValaMethod* _tmp654_;
				ValaCCodeFunctionCall* _tmp655_;
				ValaHashMap* _tmp656_;
				ValaMethod* _tmp657_;
				ValaCCodeFunctionCall* _tmp658_;
				_tmp612_ = m;
				_tmp613_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp612_);
				_tmp614_ = _tmp613_;
				_tmp615_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp614_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp615_;
				_tmp616_ = cl;
				_tmp617_ = vala_get_ccode_class_type_function (_tmp616_);
				_tmp618_ = _tmp617_;
				_tmp619_ = vala_ccode_identifier_new (_tmp618_);
				_tmp620_ = _tmp619_;
				_tmp621_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp620_);
				_tmp622_ = _tmp621_;
				_vala_ccode_node_unref0 (_tmp620_);
				_g_free0 (_tmp618_);
				cast = _tmp622_;
				_tmp623_ = ma;
				_tmp624_ = vala_member_access_get_inner (_tmp623_);
				_tmp625_ = _tmp624_;
				if (_tmp625_ == NULL) {
					ValaDataType* _tmp626_;
					ValaDataType* _tmp627_;
					gboolean _tmp628_;
					_tmp626_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp627_ = _tmp626_;
					_tmp628_ = _tmp627_ == NULL;
					_vala_code_node_unref0 (_tmp627_);
					if (_tmp628_) {
						ValaCCodeIdentifier* _tmp629_;
						_tmp629_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp629_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp630_;
						ValaCCodeIdentifier* _tmp631_;
						ValaCCodeFunctionCall* _tmp632_;
						ValaCCodeFunctionCall* _tmp633_;
						ValaCCodeFunctionCall* _tmp634_;
						ValaCCodeExpression* _tmp635_;
						ValaCCodeExpression* _tmp636_;
						ValaCCodeFunctionCall* _tmp637_;
						ValaCCodeExpression* _tmp638_;
						_tmp630_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp631_ = _tmp630_;
						_tmp632_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp631_);
						_tmp633_ = _tmp632_;
						_vala_ccode_node_unref0 (_tmp631_);
						k = _tmp633_;
						_tmp634_ = k;
						_tmp635_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp636_ = _tmp635_;
						vala_ccode_function_call_add_argument (_tmp634_, _tmp636_);
						_vala_ccode_node_unref0 (_tmp636_);
						_tmp637_ = k;
						_tmp638_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp637_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp638_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp639_;
					ValaCCodeIdentifier* _tmp640_;
					ValaCCodeFunctionCall* _tmp641_;
					ValaCCodeFunctionCall* _tmp642_;
					ValaCCodeFunctionCall* _tmp643_;
					ValaMemberAccess* _tmp644_;
					ValaExpression* _tmp645_;
					ValaExpression* _tmp646_;
					ValaCCodeExpression* _tmp647_;
					ValaCCodeExpression* _tmp648_;
					ValaCCodeFunctionCall* _tmp649_;
					ValaCCodeExpression* _tmp650_;
					_tmp639_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp640_ = _tmp639_;
					_tmp641_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp640_);
					_tmp642_ = _tmp641_;
					_vala_ccode_node_unref0 (_tmp640_);
					k = _tmp642_;
					_tmp643_ = k;
					_tmp644_ = ma;
					_tmp645_ = vala_member_access_get_inner (_tmp644_);
					_tmp646_ = _tmp645_;
					_tmp647_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp646_);
					_tmp648_ = _tmp647_;
					vala_ccode_function_call_add_argument (_tmp643_, _tmp648_);
					_vala_ccode_node_unref0 (_tmp648_);
					_tmp649_ = k;
					_tmp650_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp649_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp650_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp651_ = cast;
				_tmp652_ = klass;
				vala_ccode_function_call_add_argument (_tmp651_, _tmp652_);
				_tmp653_ = in_arg_map;
				_tmp654_ = m;
				_tmp655_ = cast;
				vala_map_set ((ValaMap*) _tmp653_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp654_), FALSE)), (ValaCCodeExpression*) _tmp655_);
				_tmp656_ = out_arg_map;
				_tmp657_ = m;
				_tmp658_ = cast;
				vala_map_set ((ValaMap*) _tmp656_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp657_), FALSE)), (ValaCCodeExpression*) _tmp658_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp660_ = m;
	if (_tmp660_ != NULL) {
		ValaMethod* _tmp661_;
		_tmp661_ = m;
		_tmp659_ = vala_get_ccode_has_generic_type_parameter (_tmp661_);
	} else {
		_tmp659_ = FALSE;
	}
	if (_tmp659_) {
		ValaMethod* _tmp662_;
		_tmp662_ = m;
		if (vala_method_has_type_parameters (_tmp662_)) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp663_;
				ValaList* _tmp664_;
				gint _type_arg_size = 0;
				ValaList* _tmp665_;
				gint _tmp666_;
				gint _tmp667_;
				gint _type_arg_index = 0;
				_tmp663_ = ma;
				_tmp664_ = vala_member_access_get_type_arguments (_tmp663_);
				_type_arg_list = _tmp664_;
				_tmp665_ = _type_arg_list;
				_tmp666_ = vala_collection_get_size ((ValaCollection*) _tmp665_);
				_tmp667_ = _tmp666_;
				_type_arg_size = _tmp667_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp668_;
					gpointer _tmp669_;
					ValaHashMap* _tmp670_;
					ValaMethod* _tmp671_;
					ValaDataType* _tmp672_;
					gchar* _tmp673_;
					gchar* _tmp674_;
					ValaCCodeIdentifier* _tmp675_;
					ValaCCodeIdentifier* _tmp676_;
					gint _tmp677_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp668_ = _type_arg_list;
					_tmp669_ = vala_list_get (_tmp668_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp669_;
					_tmp670_ = in_arg_map;
					_tmp671_ = m;
					_tmp672_ = type_arg;
					_tmp673_ = vala_get_ccode_name ((ValaCodeNode*) _tmp672_);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_ccode_identifier_new (_tmp674_);
					_tmp676_ = _tmp675_;
					vala_map_set ((ValaMap*) _tmp670_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp671_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp676_);
					_vala_ccode_node_unref0 (_tmp676_);
					_g_free0 (_tmp674_);
					_tmp677_ = type_param_index;
					type_param_index = _tmp677_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp678_;
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaDataType* _tmp681_;
				ValaDataType* _tmp682_;
				ValaList* _tmp683_;
				gint _type_arg_size = 0;
				ValaList* _tmp684_;
				gint _tmp685_;
				gint _tmp686_;
				gint _type_arg_index = 0;
				_tmp678_ = ma;
				_tmp679_ = vala_member_access_get_inner (_tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_value_type (_tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = vala_data_type_get_type_arguments (_tmp682_);
				_type_arg_list = _tmp683_;
				_tmp684_ = _type_arg_list;
				_tmp685_ = vala_collection_get_size ((ValaCollection*) _tmp684_);
				_tmp686_ = _tmp685_;
				_type_arg_size = _tmp686_;
				_type_arg_index = -1;
				while (TRUE) {
					ValaDataType* type_arg = NULL;
					ValaList* _tmp687_;
					gpointer _tmp688_;
					ValaHashMap* _tmp689_;
					ValaMethod* _tmp690_;
					ValaDataType* _tmp691_;
					gchar* _tmp692_;
					gchar* _tmp693_;
					ValaCCodeIdentifier* _tmp694_;
					ValaCCodeIdentifier* _tmp695_;
					gint _tmp696_;
					_type_arg_index = _type_arg_index + 1;
					if (!(_type_arg_index < _type_arg_size)) {
						break;
					}
					_tmp687_ = _type_arg_list;
					_tmp688_ = vala_list_get (_tmp687_, _type_arg_index);
					type_arg = (ValaDataType*) _tmp688_;
					_tmp689_ = in_arg_map;
					_tmp690_ = m;
					_tmp691_ = type_arg;
					_tmp692_ = vala_get_ccode_name ((ValaCodeNode*) _tmp691_);
					_tmp693_ = _tmp692_;
					_tmp694_ = vala_ccode_identifier_new (_tmp693_);
					_tmp695_ = _tmp694_;
					vala_map_set ((ValaMap*) _tmp689_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp690_) + (0.01 * type_param_index), FALSE)), (ValaCCodeExpression*) _tmp695_);
					_vala_ccode_node_unref0 (_tmp695_);
					_g_free0 (_tmp693_);
					_tmp696_ = type_param_index;
					type_param_index = _tmp696_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp697_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp697_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp698_;
		ValaExpression* _tmp699_;
		ValaExpression* _tmp700_;
		ValaDataType* _tmp701_;
		ValaDataType* _tmp702_;
		ValaArrayType* _tmp703_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp704_;
		ValaCCodeIdentifier* _tmp705_;
		ValaCCodeFunctionCall* _tmp706_;
		ValaCCodeFunctionCall* _tmp707_;
		ValaCCodeFunctionCall* _tmp708_;
		ValaArrayType* _tmp709_;
		ValaDataType* _tmp710_;
		ValaDataType* _tmp711_;
		gchar* _tmp712_;
		gchar* _tmp713_;
		ValaCCodeIdentifier* _tmp714_;
		ValaCCodeIdentifier* _tmp715_;
		ValaHashMap* _tmp716_;
		ValaCCodeFunctionCall* _tmp717_;
		_tmp698_ = ma;
		_tmp699_ = vala_member_access_get_inner (_tmp698_);
		_tmp700_ = _tmp699_;
		_tmp701_ = vala_expression_get_value_type (_tmp700_);
		_tmp702_ = _tmp701_;
		_tmp703_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp702_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp703_;
		_tmp704_ = vala_ccode_identifier_new ("sizeof");
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp705_);
		_tmp707_ = _tmp706_;
		_vala_ccode_node_unref0 (_tmp705_);
		csizeof = _tmp707_;
		_tmp708_ = csizeof;
		_tmp709_ = array_type;
		_tmp710_ = vala_array_type_get_element_type (_tmp709_);
		_tmp711_ = _tmp710_;
		_tmp712_ = vala_get_ccode_name ((ValaCodeNode*) _tmp711_);
		_tmp713_ = _tmp712_;
		_tmp714_ = vala_ccode_identifier_new (_tmp713_);
		_tmp715_ = _tmp714_;
		vala_ccode_function_call_add_argument (_tmp708_, (ValaCCodeExpression*) _tmp715_);
		_vala_ccode_node_unref0 (_tmp715_);
		_g_free0 (_tmp713_);
		_tmp716_ = in_arg_map;
		_tmp717_ = csizeof;
		vala_map_set ((ValaMap*) _tmp716_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp717_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp718_;
		_tmp718_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp718_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp719_;
			gint param_nr = 0;
			ValaMethod* _tmp779_;
			_tmp719_ = m;
			vala_method_clear_parameters (_tmp719_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp720_;
				gint _arg_size = 0;
				ValaList* _tmp721_;
				gint _tmp722_;
				gint _tmp723_;
				gint _arg_index = 0;
				_tmp720_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp720_;
				_tmp721_ = _arg_list;
				_tmp722_ = vala_collection_get_size ((ValaCollection*) _tmp721_);
				_tmp723_ = _tmp722_;
				_arg_size = _tmp723_;
				_arg_index = -1;
				while (TRUE) {
					ValaExpression* arg = NULL;
					ValaList* _tmp724_;
					gpointer _tmp725_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp726_;
					ValaUnaryExpression* _tmp727_;
					gboolean _tmp728_ = FALSE;
					ValaUnaryExpression* _tmp729_;
					gint _tmp770_;
					_arg_index = _arg_index + 1;
					if (!(_arg_index < _arg_size)) {
						break;
					}
					_tmp724_ = _arg_list;
					_tmp725_ = vala_list_get (_tmp724_, _arg_index);
					arg = (ValaExpression*) _tmp725_;
					_tmp726_ = arg;
					_tmp727_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp726_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp726_) : NULL);
					unary = _tmp727_;
					_tmp729_ = unary;
					if (_tmp729_ != NULL) {
						ValaUnaryExpression* _tmp730_;
						ValaUnaryOperator _tmp731_;
						ValaUnaryOperator _tmp732_;
						_tmp730_ = unary;
						_tmp731_ = vala_unary_expression_get_operator (_tmp730_);
						_tmp732_ = _tmp731_;
						_tmp728_ = _tmp732_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp728_ = FALSE;
					}
					if (_tmp728_) {
						ValaParameter* param = NULL;
						gchar* _tmp733_;
						gchar* _tmp734_;
						ValaUnaryExpression* _tmp735_;
						ValaExpression* _tmp736_;
						ValaExpression* _tmp737_;
						ValaDataType* _tmp738_;
						ValaDataType* _tmp739_;
						ValaParameter* _tmp740_;
						ValaParameter* _tmp741_;
						ValaParameter* _tmp742_;
						ValaMethod* _tmp743_;
						ValaParameter* _tmp744_;
						_tmp733_ = g_strdup_printf ("param%d", param_nr);
						_tmp734_ = _tmp733_;
						_tmp735_ = unary;
						_tmp736_ = vala_unary_expression_get_inner (_tmp735_);
						_tmp737_ = _tmp736_;
						_tmp738_ = vala_expression_get_value_type (_tmp737_);
						_tmp739_ = _tmp738_;
						_tmp740_ = vala_parameter_new (_tmp734_, _tmp739_, NULL);
						_tmp741_ = _tmp740_;
						_g_free0 (_tmp734_);
						param = _tmp741_;
						_tmp742_ = param;
						vala_parameter_set_direction (_tmp742_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp743_ = m;
						_tmp744_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp743_, _tmp744_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp745_ = FALSE;
						ValaUnaryExpression* _tmp746_;
						_tmp746_ = unary;
						if (_tmp746_ != NULL) {
							ValaUnaryExpression* _tmp747_;
							ValaUnaryOperator _tmp748_;
							ValaUnaryOperator _tmp749_;
							_tmp747_ = unary;
							_tmp748_ = vala_unary_expression_get_operator (_tmp747_);
							_tmp749_ = _tmp748_;
							_tmp745_ = _tmp749_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp745_ = FALSE;
						}
						if (_tmp745_) {
							ValaParameter* param = NULL;
							gchar* _tmp750_;
							gchar* _tmp751_;
							ValaUnaryExpression* _tmp752_;
							ValaExpression* _tmp753_;
							ValaExpression* _tmp754_;
							ValaDataType* _tmp755_;
							ValaDataType* _tmp756_;
							ValaParameter* _tmp757_;
							ValaParameter* _tmp758_;
							ValaParameter* _tmp759_;
							ValaMethod* _tmp760_;
							ValaParameter* _tmp761_;
							_tmp750_ = g_strdup_printf ("param%d", param_nr);
							_tmp751_ = _tmp750_;
							_tmp752_ = unary;
							_tmp753_ = vala_unary_expression_get_inner (_tmp752_);
							_tmp754_ = _tmp753_;
							_tmp755_ = vala_expression_get_value_type (_tmp754_);
							_tmp756_ = _tmp755_;
							_tmp757_ = vala_parameter_new (_tmp751_, _tmp756_, NULL);
							_tmp758_ = _tmp757_;
							_g_free0 (_tmp751_);
							param = _tmp758_;
							_tmp759_ = param;
							vala_parameter_set_direction (_tmp759_, VALA_PARAMETER_DIRECTION_REF);
							_tmp760_ = m;
							_tmp761_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp760_, _tmp761_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp762_;
							gchar* _tmp763_;
							gchar* _tmp764_;
							ValaExpression* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							ValaParameter* _tmp768_;
							ValaParameter* _tmp769_;
							_tmp762_ = m;
							_tmp763_ = g_strdup_printf ("param%d", param_nr);
							_tmp764_ = _tmp763_;
							_tmp765_ = arg;
							_tmp766_ = vala_expression_get_value_type (_tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = vala_parameter_new (_tmp764_, _tmp767_, NULL);
							_tmp769_ = _tmp768_;
							vala_callable_add_parameter ((ValaCallable*) _tmp762_, _tmp769_);
							_vala_code_node_unref0 (_tmp769_);
							_g_free0 (_tmp764_);
						}
					}
					_tmp770_ = param_nr;
					param_nr = _tmp770_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp771_;
				ValaList* _tmp772_;
				gint _param_size = 0;
				ValaList* _tmp773_;
				gint _tmp774_;
				gint _tmp775_;
				gint _param_index = 0;
				_tmp771_ = m;
				_tmp772_ = vala_callable_get_parameters ((ValaCallable*) _tmp771_);
				_param_list = _tmp772_;
				_tmp773_ = _param_list;
				_tmp774_ = vala_collection_get_size ((ValaCollection*) _tmp773_);
				_tmp775_ = _tmp774_;
				_param_size = _tmp775_;
				_param_index = -1;
				while (TRUE) {
					ValaParameter* param = NULL;
					ValaList* _tmp776_;
					gpointer _tmp777_;
					ValaParameter* _tmp778_;
					_param_index = _param_index + 1;
					if (!(_param_index < _param_size)) {
						break;
					}
					_tmp776_ = _param_list;
					_tmp777_ = vala_list_get (_tmp776_, _param_index);
					param = (ValaParameter*) _tmp777_;
					_tmp778_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp778_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp779_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp779_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp780_ = FALSE;
			gboolean _tmp781_ = FALSE;
			ValaMethod* _tmp782_;
			_tmp782_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp782_, VALA_TYPE_CREATION_METHOD)) {
				ValaCodeContext* _tmp783_;
				ValaCodeContext* _tmp784_;
				ValaProfile _tmp785_;
				ValaProfile _tmp786_;
				_tmp783_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
				_tmp784_ = _tmp783_;
				_tmp785_ = vala_code_context_get_profile (_tmp784_);
				_tmp786_ = _tmp785_;
				_tmp781_ = _tmp786_ == VALA_PROFILE_GOBJECT;
			} else {
				_tmp781_ = FALSE;
			}
			if (_tmp781_) {
				ValaMethod* _tmp787_;
				ValaSymbol* _tmp788_;
				ValaSymbol* _tmp789_;
				_tmp787_ = m;
				_tmp788_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp787_);
				_tmp789_ = _tmp788_;
				_tmp780_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp789_, VALA_TYPE_CLASS);
			} else {
				_tmp780_ = FALSE;
			}
			if (_tmp780_) {
				ValaCCodeFunction* _tmp790_;
				ValaCCodeFunction* _tmp791_;
				ValaCCodeExpression* _tmp792_;
				ValaCCodeExpression* _tmp793_;
				ValaCCodeFunctionCall* _tmp794_;
				ValaClass* _tmp795_;
				ValaClass* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				ValaCCodeCastExpression* _tmp801_;
				ValaCCodeCastExpression* _tmp802_;
				ValaMethod* _tmp803_;
				ValaMethod* _tmp804_;
				ValaBlock* _tmp805_;
				ValaBlock* _tmp806_;
				gboolean _tmp807_;
				gboolean _tmp808_;
				gboolean _tmp835_ = FALSE;
				ValaClass* _tmp836_;
				ValaClass* _tmp837_;
				gboolean _tmp838_;
				gboolean _tmp839_;
				_tmp790_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = ccall;
				_tmp795_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_get_ccode_name ((ValaCodeNode*) _tmp796_);
				_tmp798_ = _tmp797_;
				_tmp799_ = g_strconcat (_tmp798_, "*", NULL);
				_tmp800_ = _tmp799_;
				_tmp801_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp794_, _tmp800_);
				_tmp802_ = _tmp801_;
				vala_ccode_function_add_assignment (_tmp791_, _tmp793_, (ValaCCodeExpression*) _tmp802_);
				_vala_ccode_node_unref0 (_tmp802_);
				_g_free0 (_tmp800_);
				_g_free0 (_tmp798_);
				_vala_ccode_node_unref0 (_tmp793_);
				_tmp803_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp804_ = _tmp803_;
				_tmp805_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp804_);
				_tmp806_ = _tmp805_;
				_tmp807_ = vala_block_get_captured (_tmp806_);
				_tmp808_ = _tmp807_;
				if (_tmp808_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp809_;
					ValaClass* _tmp810_;
					ValaObjectType* _tmp811_;
					ValaObjectType* _tmp812_;
					ValaSourceReference* _tmp813_;
					ValaSourceReference* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeExpression* _tmp816_;
					ValaCCodeFunctionCall* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					ValaCCodeExpression* _tmp820_;
					ValaCCodeExpression* _tmp821_;
					ValaCCodeFunction* _tmp822_;
					ValaCCodeFunction* _tmp823_;
					ValaMethod* _tmp824_;
					ValaMethod* _tmp825_;
					ValaBlock* _tmp826_;
					ValaBlock* _tmp827_;
					gchar* _tmp828_;
					gchar* _tmp829_;
					ValaCCodeExpression* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeMemberAccess* _tmp832_;
					ValaCCodeMemberAccess* _tmp833_;
					ValaCCodeFunctionCall* _tmp834_;
					_tmp809_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp810_);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp814_ = _tmp813_;
					_tmp815_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp812_, _tmp814_, FALSE);
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_ccode_function_call_new (_tmp816_);
					_tmp818_ = _tmp817_;
					_vala_ccode_node_unref0 (_tmp816_);
					_vala_code_node_unref0 (_tmp812_);
					ref_call = _tmp818_;
					_tmp819_ = ref_call;
					_tmp820_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp821_ = _tmp820_;
					vala_ccode_function_call_add_argument (_tmp819_, _tmp821_);
					_vala_ccode_node_unref0 (_tmp821_);
					_tmp822_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp825_);
					_tmp827_ = _tmp826_;
					_tmp828_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp827_));
					_tmp829_ = _tmp828_;
					_tmp830_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp829_);
					_tmp831_ = _tmp830_;
					_tmp832_ = vala_ccode_member_access_new_pointer (_tmp831_, "self");
					_tmp833_ = _tmp832_;
					_tmp834_ = ref_call;
					vala_ccode_function_add_assignment (_tmp823_, (ValaCCodeExpression*) _tmp833_, (ValaCCodeExpression*) _tmp834_);
					_vala_ccode_node_unref0 (_tmp833_);
					_vala_ccode_node_unref0 (_tmp831_);
					_g_free0 (_tmp829_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp836_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp837_ = _tmp836_;
				_tmp838_ = vala_class_get_is_compact (_tmp837_);
				_tmp839_ = _tmp838_;
				if (!_tmp839_) {
					ValaClass* _tmp840_;
					ValaClass* _tmp841_;
					_tmp840_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp841_ = _tmp840_;
					_tmp835_ = vala_object_type_symbol_has_type_parameters ((ValaObjectTypeSymbol*) _tmp841_);
				} else {
					_tmp835_ = FALSE;
				}
				if (_tmp835_) {
					gchar** suffices = NULL;
					gchar* _tmp842_;
					gchar* _tmp843_;
					gchar* _tmp844_;
					gchar** _tmp845_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp842_ = g_strdup ("type");
					_tmp843_ = g_strdup ("dup_func");
					_tmp844_ = g_strdup ("destroy_func");
					_tmp845_ = g_new0 (gchar*, 3 + 1);
					_tmp845_[0] = _tmp842_;
					_tmp845_[1] = _tmp843_;
					_tmp845_[2] = _tmp844_;
					suffices = _tmp845_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp846_;
						ValaClass* _tmp847_;
						ValaList* _tmp848_;
						gint _type_param_size = 0;
						ValaList* _tmp849_;
						gint _tmp850_;
						gint _tmp851_;
						gint _type_param_index = 0;
						_tmp846_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp847_ = _tmp846_;
						_tmp848_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp847_);
						_type_param_list = _tmp848_;
						_tmp849_ = _type_param_list;
						_tmp850_ = vala_collection_get_size ((ValaCollection*) _tmp849_);
						_tmp851_ = _tmp850_;
						_type_param_size = _tmp851_;
						_type_param_index = -1;
						while (TRUE) {
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp852_;
							gpointer _tmp853_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp854_;
							ValaCCodeIdentifier* _tmp855_;
							ValaCCodeMemberAccess* _tmp856_;
							ValaCCodeMemberAccess* _tmp857_;
							gchar** _tmp858_;
							gint _tmp858__length1;
							_type_param_index = _type_param_index + 1;
							if (!(_type_param_index < _type_param_size)) {
								break;
							}
							_tmp852_ = _type_param_list;
							_tmp853_ = vala_list_get (_tmp852_, _type_param_index);
							type_param = (ValaTypeParameter*) _tmp853_;
							_tmp854_ = vala_ccode_identifier_new ("self");
							_tmp855_ = _tmp854_;
							_tmp856_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp855_, "priv");
							_tmp857_ = _tmp856_;
							_vala_ccode_node_unref0 (_tmp855_);
							priv_access = _tmp857_;
							_tmp858_ = suffices;
							_tmp858__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp858_;
								suffix_collection_length1 = _tmp858__length1;
								for (suffix_it = 0; suffix_it < _tmp858__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp859_;
									gchar* suffix = NULL;
									_tmp859_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp859_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp860_;
										const gchar* _tmp861_;
										const gchar* _tmp862_;
										gchar* _tmp863_;
										gchar* _tmp864_;
										const gchar* _tmp865_;
										gchar* _tmp866_;
										gchar* _tmp867_;
										ValaCCodeIdentifier* _tmp868_;
										ValaCCodeIdentifier* _tmp869_;
										ValaCCodeFunction* _tmp870_;
										ValaCCodeFunction* _tmp871_;
										ValaCCodeMemberAccess* _tmp872_;
										ValaCCodeIdentifier* _tmp873_;
										const gchar* _tmp874_;
										const gchar* _tmp875_;
										ValaCCodeMemberAccess* _tmp876_;
										ValaCCodeMemberAccess* _tmp877_;
										ValaCCodeIdentifier* _tmp878_;
										_tmp860_ = type_param;
										_tmp861_ = vala_symbol_get_name ((ValaSymbol*) _tmp860_);
										_tmp862_ = _tmp861_;
										_tmp863_ = g_utf8_strdown (_tmp862_, (gssize) -1);
										_tmp864_ = _tmp863_;
										_tmp865_ = suffix;
										_tmp866_ = g_strdup_printf ("%s_%s", _tmp864_, _tmp865_);
										_tmp867_ = _tmp866_;
										_tmp868_ = vala_ccode_identifier_new (_tmp867_);
										_tmp869_ = _tmp868_;
										_g_free0 (_tmp867_);
										_g_free0 (_tmp864_);
										param_name = _tmp869_;
										_tmp870_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp871_ = _tmp870_;
										_tmp872_ = priv_access;
										_tmp873_ = param_name;
										_tmp874_ = vala_ccode_identifier_get_name (_tmp873_);
										_tmp875_ = _tmp874_;
										_tmp876_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp872_, _tmp875_);
										_tmp877_ = _tmp876_;
										_tmp878_ = param_name;
										vala_ccode_function_add_assignment (_tmp871_, (ValaCCodeExpression*) _tmp877_, (ValaCCodeExpression*) _tmp878_);
										_vala_ccode_node_unref0 (_tmp877_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp879_ = params;
	_tmp880_ = vala_iterable_iterator ((ValaIterable*) _tmp879_);
	params_it = _tmp880_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp881_;
		gint _arg_size = 0;
		ValaList* _tmp882_;
		gint _tmp883_;
		gint _tmp884_;
		gint _arg_index = 0;
		_tmp881_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp881_;
		_tmp882_ = _arg_list;
		_tmp883_ = vala_collection_get_size ((ValaCollection*) _tmp882_);
		_tmp884_ = _tmp883_;
		_arg_size = _tmp884_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp885_;
			gpointer _tmp886_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp887_;
			ValaCCodeExpression* _tmp888_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp889_;
			ValaHashMap* _tmp890_;
			ValaIterator* _tmp891_;
			ValaHashMap* _tmp1193_;
			ValaCCodeExpression* _tmp1194_;
			gboolean _tmp1195_ = FALSE;
			ValaExpression* _tmp1196_;
			gint _tmp1213_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp885_ = _arg_list;
			_tmp886_ = vala_list_get (_tmp885_, _arg_index);
			arg = (ValaExpression*) _tmp886_;
			_tmp887_ = arg;
			_tmp888_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp887_);
			cexpr = _tmp888_;
			_tmp889_ = in_arg_map;
			_tmp890_ = _vala_map_ref0 (_tmp889_);
			carg_map = _tmp890_;
			_tmp891_ = params_it;
			if (vala_iterator_next (_tmp891_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp892_;
				gpointer _tmp893_;
				gboolean _tmp894_ = FALSE;
				ValaParameter* _tmp895_;
				gboolean _tmp896_;
				gboolean _tmp897_;
				ValaParameter* _tmp1189_;
				_tmp892_ = params_it;
				_tmp893_ = vala_iterator_get (_tmp892_);
				param = (ValaParameter*) _tmp893_;
				_tmp895_ = param;
				_tmp896_ = vala_parameter_get_params_array (_tmp895_);
				_tmp897_ = _tmp896_;
				if (_tmp897_) {
					_tmp894_ = TRUE;
				} else {
					ValaParameter* _tmp898_;
					gboolean _tmp899_;
					gboolean _tmp900_;
					_tmp898_ = param;
					_tmp899_ = vala_parameter_get_ellipsis (_tmp898_);
					_tmp900_ = _tmp899_;
					_tmp894_ = _tmp900_;
				}
				ellipsis = _tmp894_;
				if (!ellipsis) {
					ValaParameter* _tmp901_;
					ValaParameterDirection _tmp902_;
					ValaParameterDirection _tmp903_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp906_;
					ValaUnaryExpression* _tmp907_;
					gboolean _tmp908_ = FALSE;
					ValaUnaryExpression* _tmp909_;
					ValaParameter* _tmp1177_;
					gchar* _tmp1178_;
					gchar* _tmp1179_;
					gboolean _tmp1180_;
					_tmp901_ = param;
					_tmp902_ = vala_parameter_get_direction (_tmp901_);
					_tmp903_ = _tmp902_;
					if (_tmp903_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp904_;
						ValaHashMap* _tmp905_;
						_tmp904_ = out_arg_map;
						_tmp905_ = _vala_map_ref0 (_tmp904_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp905_;
					}
					_tmp906_ = arg;
					_tmp907_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp906_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp906_) : NULL);
					unary = _tmp907_;
					_tmp909_ = unary;
					if (_tmp909_ == NULL) {
						_tmp908_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp910_;
						ValaUnaryOperator _tmp911_;
						ValaUnaryOperator _tmp912_;
						_tmp910_ = unary;
						_tmp911_ = vala_unary_expression_get_operator (_tmp910_);
						_tmp912_ = _tmp911_;
						_tmp908_ = _tmp912_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp908_) {
						gboolean _tmp913_ = FALSE;
						gboolean _tmp914_ = FALSE;
						ValaParameter* _tmp915_;
						ValaParameter* _tmp1051_;
						ValaExpression* _tmp1052_;
						ValaCCodeExpression* _tmp1053_;
						ValaCCodeExpression* _tmp1054_;
						_tmp915_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp915_)) {
							ValaParameter* _tmp916_;
							ValaDataType* _tmp917_;
							ValaDataType* _tmp918_;
							_tmp916_ = param;
							_tmp917_ = vala_variable_get_variable_type ((ValaVariable*) _tmp916_);
							_tmp918_ = _tmp917_;
							_tmp914_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp918_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp914_ = FALSE;
						}
						if (_tmp914_) {
							ValaParameter* _tmp919_;
							ValaDataType* _tmp920_;
							ValaDataType* _tmp921_;
							gboolean _tmp922_;
							gboolean _tmp923_;
							_tmp919_ = param;
							_tmp920_ = vala_variable_get_variable_type ((ValaVariable*) _tmp919_);
							_tmp921_ = _tmp920_;
							_tmp922_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp921_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp923_ = _tmp922_;
							_tmp913_ = !_tmp923_;
						} else {
							_tmp913_ = FALSE;
						}
						if (_tmp913_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp924_;
							ValaDataType* _tmp925_;
							ValaDataType* _tmp926_;
							ValaArrayType* _tmp927_;
							gchar* _tmp928_ = NULL;
							ValaParameter* _tmp929_;
							gchar* _tmp930_;
							gchar* length_ctype = NULL;
							gchar* _tmp933_;
							gboolean _tmp934_ = FALSE;
							ValaUnaryExpression* _tmp935_;
							_tmp924_ = param;
							_tmp925_ = vala_variable_get_variable_type ((ValaVariable*) _tmp924_);
							_tmp926_ = _tmp925_;
							_tmp927_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp926_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp927_;
							_tmp929_ = param;
							_tmp930_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp929_);
							_tmp928_ = _tmp930_;
							if (_tmp928_ == NULL) {
								ValaArrayType* _tmp931_;
								gchar* _tmp932_;
								_tmp931_ = array_type;
								_tmp932_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp931_);
								_g_free0 (_tmp928_);
								_tmp928_ = _tmp932_;
							}
							_tmp933_ = g_strdup (_tmp928_);
							length_ctype = _tmp933_;
							_tmp935_ = unary;
							if (_tmp935_ != NULL) {
								ValaUnaryExpression* _tmp936_;
								ValaUnaryOperator _tmp937_;
								ValaUnaryOperator _tmp938_;
								_tmp936_ = unary;
								_tmp937_ = vala_unary_expression_get_operator (_tmp936_);
								_tmp938_ = _tmp937_;
								_tmp934_ = _tmp938_ == VALA_UNARY_OPERATOR_REF;
							} else {
								_tmp934_ = FALSE;
							}
							if (_tmp934_) {
								const gchar* _tmp939_;
								gchar* _tmp940_;
								_tmp939_ = length_ctype;
								_tmp940_ = g_strdup_printf ("%s*", _tmp939_);
								_g_free0 (length_ctype);
								length_ctype = _tmp940_;
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp941_ = FALSE;
									_tmp941_ = TRUE;
									while (TRUE) {
										ValaArrayType* _tmp943_;
										gint _tmp944_;
										gint _tmp945_;
										ValaCCodeCastExpression* array_length_expr = NULL;
										ValaExpression* _tmp946_;
										ValaCCodeExpression* _tmp947_;
										ValaCCodeExpression* _tmp948_;
										const gchar* _tmp949_;
										ValaCCodeCastExpression* _tmp950_;
										ValaCCodeCastExpression* _tmp951_;
										ValaHashMap* _tmp952_;
										ValaParameter* _tmp953_;
										ValaCCodeCastExpression* _tmp954_;
										if (!_tmp941_) {
											gint _tmp942_;
											_tmp942_ = dim;
											dim = _tmp942_ + 1;
										}
										_tmp941_ = FALSE;
										_tmp943_ = array_type;
										_tmp944_ = vala_array_type_get_rank (_tmp943_);
										_tmp945_ = _tmp944_;
										if (!(dim <= _tmp945_)) {
											break;
										}
										_tmp946_ = arg;
										_tmp947_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp946_, dim);
										_tmp948_ = _tmp947_;
										_tmp949_ = length_ctype;
										_tmp950_ = vala_ccode_cast_expression_new (_tmp948_, _tmp949_);
										_tmp951_ = _tmp950_;
										_vala_ccode_node_unref0 (_tmp948_);
										array_length_expr = _tmp951_;
										_tmp952_ = carg_map;
										_tmp953_ = param;
										_tmp954_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp952_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp953_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp954_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_g_free0 (length_ctype);
							_g_free0 (_tmp928_);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp955_;
							ValaDataType* _tmp956_;
							ValaDataType* _tmp957_;
							_tmp955_ = param;
							_tmp956_ = vala_variable_get_variable_type ((ValaVariable*) _tmp955_);
							_tmp957_ = _tmp956_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp957_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp958_;
								ValaDataType* _tmp959_;
								ValaDataType* _tmp960_;
								ValaDelegateType* _tmp961_;
								ValaDelegateType* _tmp962_;
								ValaDelegate* _tmp963_;
								ValaDelegate* _tmp964_;
								gboolean _tmp965_;
								gboolean _tmp966_;
								_tmp958_ = param;
								_tmp959_ = vala_variable_get_variable_type ((ValaVariable*) _tmp958_);
								_tmp960_ = _tmp959_;
								_tmp961_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp960_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp961_;
								_tmp962_ = deleg_type;
								_tmp963_ = vala_delegate_type_get_delegate_symbol (_tmp962_);
								_tmp964_ = _tmp963_;
								_tmp965_ = vala_delegate_get_has_target (_tmp964_);
								_tmp966_ = _tmp965_;
								if (_tmp966_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp967_;
									ValaCCodeExpression* _tmp968_ = NULL;
									ValaCCodeExpression* _tmp969_;
									ValaCCodeExpression* _tmp970_;
									ValaParameter* _tmp971_;
									gchar* _tmp972_;
									gchar* _tmp973_;
									gboolean _tmp974_;
									_tmp967_ = arg;
									_tmp969_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp967_, &_tmp968_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp968_;
									delegate_target = _tmp969_;
									_tmp970_ = delegate_target;
									_vala_assert (_tmp970_ != NULL, "delegate_target != null");
									_tmp971_ = param;
									_tmp972_ = vala_get_ccode_type ((ValaCodeNode*) _tmp971_);
									_tmp973_ = _tmp972_;
									_tmp974_ = g_strcmp0 (_tmp973_, "GClosure*") == 0;
									_g_free0 (_tmp973_);
									if (_tmp974_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp975_;
										ValaCCodeIdentifier* _tmp976_;
										ValaCCodeFunctionCall* _tmp977_;
										ValaCCodeFunctionCall* _tmp978_;
										ValaCCodeFunctionCall* _tmp979_;
										ValaCCodeExpression* _tmp980_;
										ValaCCodeCastExpression* _tmp981_;
										ValaCCodeCastExpression* _tmp982_;
										ValaCCodeFunctionCall* _tmp983_;
										ValaCCodeExpression* _tmp984_;
										ValaCCodeFunctionCall* _tmp985_;
										ValaCCodeExpression* _tmp986_;
										ValaCCodeCastExpression* _tmp987_;
										ValaCCodeCastExpression* _tmp988_;
										ValaCCodeExpression* _tmp989_;
										ValaCCodeIdentifier* _tmp990_;
										ValaCCodeIdentifier* _tmp991_;
										ValaCCodeBinaryExpression* _tmp992_;
										ValaCCodeBinaryExpression* _tmp993_;
										ValaCCodeIdentifier* _tmp994_;
										ValaCCodeIdentifier* _tmp995_;
										ValaCCodeFunctionCall* _tmp996_;
										ValaCCodeConditionalExpression* _tmp997_;
										_tmp975_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp976_ = _tmp975_;
										_tmp977_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp976_);
										_tmp978_ = _tmp977_;
										_vala_ccode_node_unref0 (_tmp976_);
										closure_new = _tmp978_;
										_tmp979_ = closure_new;
										_tmp980_ = cexpr;
										_tmp981_ = vala_ccode_cast_expression_new (_tmp980_, "GCallback");
										_tmp982_ = _tmp981_;
										vala_ccode_function_call_add_argument (_tmp979_, (ValaCCodeExpression*) _tmp982_);
										_vala_ccode_node_unref0 (_tmp982_);
										_tmp983_ = closure_new;
										_tmp984_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp983_, _tmp984_);
										_tmp985_ = closure_new;
										_tmp986_ = delegate_target_destroy_notify;
										_tmp987_ = vala_ccode_cast_expression_new (_tmp986_, "GClosureNotify");
										_tmp988_ = _tmp987_;
										vala_ccode_function_call_add_argument (_tmp985_, (ValaCCodeExpression*) _tmp988_);
										_vala_ccode_node_unref0 (_tmp988_);
										_tmp989_ = cexpr;
										_tmp990_ = vala_ccode_identifier_new ("NULL");
										_tmp991_ = _tmp990_;
										_tmp992_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp989_, (ValaCCodeExpression*) _tmp991_);
										_tmp993_ = _tmp992_;
										_tmp994_ = vala_ccode_identifier_new ("NULL");
										_tmp995_ = _tmp994_;
										_tmp996_ = closure_new;
										_tmp997_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp993_, (ValaCCodeExpression*) _tmp995_, (ValaCCodeExpression*) _tmp996_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp997_;
										_vala_ccode_node_unref0 (_tmp995_);
										_vala_ccode_node_unref0 (_tmp993_);
										_vala_ccode_node_unref0 (_tmp991_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp998_;
										ValaParameter* _tmp999_;
										ValaCCodeExpression* _tmp1000_;
										ValaDelegateType* _tmp1001_;
										_tmp998_ = carg_map;
										_tmp999_ = param;
										_tmp1000_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp998_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp999_), FALSE)), _tmp1000_);
										_tmp1001_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1001_)) {
											ValaCCodeExpression* _tmp1002_;
											ValaHashMap* _tmp1003_;
											ValaParameter* _tmp1004_;
											ValaCCodeExpression* _tmp1005_;
											_tmp1002_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1002_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1003_ = carg_map;
											_tmp1004_ = param;
											_tmp1005_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1003_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1004_) + 0.01, FALSE)), _tmp1005_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1006_;
								ValaDataType* _tmp1007_;
								ValaDataType* _tmp1008_;
								_tmp1006_ = param;
								_tmp1007_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1006_);
								_tmp1008_ = _tmp1007_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1008_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1009_;
									ValaParameter* _tmp1010_;
									ValaExpression* _tmp1011_;
									ValaCCodeExpression* _tmp1012_ = NULL;
									ValaCCodeExpression* _tmp1013_;
									ValaCCodeExpression* _tmp1014_;
									_tmp1009_ = carg_map;
									_tmp1010_ = param;
									_tmp1011_ = arg;
									_tmp1013_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1011_, &_tmp1012_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1012_;
									_tmp1014_ = _tmp1013_;
									vala_map_set ((ValaMap*) _tmp1009_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1010_), FALSE)), _tmp1014_);
									_vala_ccode_node_unref0 (_tmp1014_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1015_;
									ValaDataType* _tmp1016_;
									ValaDataType* _tmp1017_;
									_tmp1015_ = param;
									_tmp1016_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1015_);
									_tmp1017_ = _tmp1016_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1017_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1018_ = FALSE;
										ValaMethod* _tmp1019_;
										_tmp1019_ = m;
										if (_tmp1019_ != NULL) {
											ValaMethod* _tmp1020_;
											_tmp1020_ = m;
											_tmp1018_ = vala_get_ccode_simple_generics (_tmp1020_);
										} else {
											_tmp1018_ = FALSE;
										}
										if (_tmp1018_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1021_;
											ValaDataType* _tmp1022_;
											ValaDataType* _tmp1023_;
											ValaGenericType* _tmp1024_;
											gint type_param_index = 0;
											ValaMethod* _tmp1025_;
											ValaGenericType* _tmp1026_;
											ValaTypeParameter* _tmp1027_;
											ValaTypeParameter* _tmp1028_;
											const gchar* _tmp1029_;
											const gchar* _tmp1030_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1031_;
											ValaList* _tmp1032_;
											ValaList* _tmp1033_;
											gpointer _tmp1034_;
											ValaDataType* _tmp1035_;
											ValaParameter* _tmp1036_;
											ValaDataType* _tmp1037_;
											ValaDataType* _tmp1038_;
											gboolean _tmp1039_;
											gboolean _tmp1040_;
											_tmp1021_ = param;
											_tmp1022_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1021_);
											_tmp1023_ = _tmp1022_;
											_tmp1024_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1023_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1024_;
											_tmp1025_ = m;
											_tmp1026_ = generic_type;
											_tmp1027_ = vala_generic_type_get_type_parameter (_tmp1026_);
											_tmp1028_ = _tmp1027_;
											_tmp1029_ = vala_symbol_get_name ((ValaSymbol*) _tmp1028_);
											_tmp1030_ = _tmp1029_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1025_, _tmp1030_);
											_tmp1031_ = ma;
											_tmp1032_ = vala_member_access_get_type_arguments (_tmp1031_);
											_tmp1033_ = _tmp1032_;
											_tmp1034_ = vala_list_get (_tmp1033_, type_param_index);
											_tmp1035_ = (ValaDataType*) _tmp1034_;
											_vala_iterable_unref0 (_tmp1033_);
											type_arg = _tmp1035_;
											_tmp1036_ = param;
											_tmp1037_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1036_);
											_tmp1038_ = _tmp1037_;
											_tmp1039_ = vala_data_type_get_value_owned (_tmp1038_);
											_tmp1040_ = _tmp1039_;
											if (_tmp1040_) {
												ValaDataType* _tmp1041_;
												_tmp1041_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1041_)) {
													ValaHashMap* _tmp1042_;
													ValaParameter* _tmp1043_;
													ValaDataType* _tmp1044_;
													ValaCCodeExpression* _tmp1045_;
													ValaCCodeExpression* _tmp1046_;
													_tmp1042_ = carg_map;
													_tmp1043_ = param;
													_tmp1044_ = type_arg;
													_tmp1045_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1044_, FALSE);
													_tmp1046_ = _tmp1045_;
													vala_map_set ((ValaMap*) _tmp1042_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1043_), FALSE)), _tmp1046_);
													_vala_ccode_node_unref0 (_tmp1046_);
												} else {
													ValaHashMap* _tmp1047_;
													ValaParameter* _tmp1048_;
													ValaCCodeConstant* _tmp1049_;
													ValaCCodeConstant* _tmp1050_;
													_tmp1047_ = carg_map;
													_tmp1048_ = param;
													_tmp1049_ = vala_ccode_constant_new ("NULL");
													_tmp1050_ = _tmp1049_;
													vala_map_set ((ValaMap*) _tmp1047_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1048_), FALSE)), (ValaCCodeExpression*) _tmp1050_);
													_vala_ccode_node_unref0 (_tmp1050_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1051_ = param;
						_tmp1052_ = arg;
						_tmp1053_ = cexpr;
						_tmp1054_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1051_, _tmp1052_, _tmp1053_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1054_;
					} else {
						ValaExpression* _tmp1055_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1056_;
						ValaDataType* _tmp1057_;
						ValaDataType* _tmp1058_;
						ValaParameter* _tmp1059_;
						ValaDataType* _tmp1060_;
						ValaDataType* _tmp1061_;
						gboolean _tmp1062_;
						gboolean _tmp1063_;
						ValaLocalVariable* _tmp1064_;
						ValaLocalVariable* _tmp1065_;
						ValaExpression* _tmp1066_;
						ValaLocalVariable* _tmp1067_;
						const gchar* _tmp1068_;
						const gchar* _tmp1069_;
						ValaCCodeExpression* _tmp1070_;
						ValaCCodeExpression* _tmp1071_;
						ValaExpression* _tmp1072_;
						ValaTargetValue* _tmp1073_;
						ValaTargetValue* _tmp1074_;
						ValaExpression* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						ValaExpression* _tmp1078_;
						ValaCCodeExpression* _tmp1079_;
						ValaCCodeExpression* _tmp1080_;
						ValaCCodeUnaryExpression* _tmp1081_;
						gboolean _tmp1082_ = FALSE;
						gboolean _tmp1083_ = FALSE;
						ValaParameter* _tmp1084_;
						_tmp1055_ = arg;
						vala_expression_set_target_value (_tmp1055_, NULL);
						_tmp1056_ = param;
						_tmp1057_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1056_);
						_tmp1058_ = _tmp1057_;
						_tmp1059_ = param;
						_tmp1060_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1059_);
						_tmp1061_ = _tmp1060_;
						_tmp1062_ = vala_data_type_get_value_owned (_tmp1061_);
						_tmp1063_ = _tmp1062_;
						_tmp1064_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1058_, _tmp1063_, NULL, TRUE);
						temp_var = _tmp1064_;
						_tmp1065_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1065_, FALSE);
						_tmp1066_ = arg;
						_tmp1067_ = temp_var;
						_tmp1068_ = vala_symbol_get_name ((ValaSymbol*) _tmp1067_);
						_tmp1069_ = _tmp1068_;
						_tmp1070_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1069_);
						_tmp1071_ = _tmp1070_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1066_, _tmp1071_);
						_vala_ccode_node_unref0 (_tmp1071_);
						_tmp1072_ = arg;
						_tmp1073_ = vala_expression_get_target_value (_tmp1072_);
						_tmp1074_ = _tmp1073_;
						_tmp1075_ = arg;
						_tmp1076_ = vala_expression_get_target_type (_tmp1075_);
						_tmp1077_ = _tmp1076_;
						vala_target_value_set_value_type (_tmp1074_, _tmp1077_);
						_tmp1078_ = arg;
						_tmp1079_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1078_);
						_tmp1080_ = _tmp1079_;
						_tmp1081_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1080_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1081_;
						_vala_ccode_node_unref0 (_tmp1080_);
						_tmp1084_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1084_)) {
							ValaParameter* _tmp1085_;
							ValaDataType* _tmp1086_;
							ValaDataType* _tmp1087_;
							_tmp1085_ = param;
							_tmp1086_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1085_);
							_tmp1087_ = _tmp1086_;
							_tmp1083_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1087_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1083_ = FALSE;
						}
						if (_tmp1083_) {
							ValaParameter* _tmp1088_;
							ValaDataType* _tmp1089_;
							ValaDataType* _tmp1090_;
							gboolean _tmp1091_;
							gboolean _tmp1092_;
							_tmp1088_ = param;
							_tmp1089_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1088_);
							_tmp1090_ = _tmp1089_;
							_tmp1091_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1090_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp1092_ = _tmp1091_;
							_tmp1082_ = !_tmp1092_;
						} else {
							_tmp1082_ = FALSE;
						}
						if (_tmp1082_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1093_;
							ValaDataType* _tmp1094_;
							ValaDataType* _tmp1095_;
							ValaArrayType* _tmp1096_;
							gchar* _tmp1097_ = NULL;
							ValaParameter* _tmp1098_;
							gchar* _tmp1099_;
							gchar* length_ctype = NULL;
							gchar* _tmp1102_;
							_tmp1093_ = param;
							_tmp1094_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1093_);
							_tmp1095_ = _tmp1094_;
							_tmp1096_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1095_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1096_;
							_tmp1098_ = param;
							_tmp1099_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1098_);
							_tmp1097_ = _tmp1099_;
							if (_tmp1097_ == NULL) {
								ValaArrayType* _tmp1100_;
								gchar* _tmp1101_;
								_tmp1100_ = array_type;
								_tmp1101_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1100_);
								_g_free0 (_tmp1097_);
								_tmp1097_ = _tmp1101_;
							}
							_tmp1102_ = g_strdup (_tmp1097_);
							length_ctype = _tmp1102_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1103_ = FALSE;
									_tmp1103_ = TRUE;
									while (TRUE) {
										ValaArrayType* _tmp1105_;
										gint _tmp1106_;
										gint _tmp1107_;
										ValaLocalVariable* temp_array_length = NULL;
										const gchar* _tmp1108_;
										ValaCType* _tmp1109_;
										ValaCType* _tmp1110_;
										ValaLocalVariable* _tmp1111_;
										ValaLocalVariable* _tmp1112_;
										ValaLocalVariable* _tmp1113_;
										ValaExpression* _tmp1114_;
										ValaLocalVariable* _tmp1115_;
										const gchar* _tmp1116_;
										const gchar* _tmp1117_;
										ValaCCodeExpression* _tmp1118_;
										ValaCCodeExpression* _tmp1119_;
										ValaHashMap* _tmp1120_;
										ValaParameter* _tmp1121_;
										ValaExpression* _tmp1122_;
										ValaList* _tmp1123_;
										ValaList* _tmp1124_;
										gpointer _tmp1125_;
										ValaCCodeExpression* _tmp1126_;
										ValaCCodeUnaryExpression* _tmp1127_;
										ValaCCodeUnaryExpression* _tmp1128_;
										if (!_tmp1103_) {
											gint _tmp1104_;
											_tmp1104_ = dim;
											dim = _tmp1104_ + 1;
										}
										_tmp1103_ = FALSE;
										_tmp1105_ = array_type;
										_tmp1106_ = vala_array_type_get_rank (_tmp1105_);
										_tmp1107_ = _tmp1106_;
										if (!(dim <= _tmp1107_)) {
											break;
										}
										_tmp1108_ = length_ctype;
										_tmp1109_ = vala_ctype_new (_tmp1108_);
										_tmp1110_ = _tmp1109_;
										_tmp1111_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1110_, TRUE, NULL, FALSE);
										_tmp1112_ = _tmp1111_;
										_vala_code_node_unref0 (_tmp1110_);
										temp_array_length = _tmp1112_;
										_tmp1113_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1113_, FALSE);
										_tmp1114_ = arg;
										_tmp1115_ = temp_array_length;
										_tmp1116_ = vala_symbol_get_name ((ValaSymbol*) _tmp1115_);
										_tmp1117_ = _tmp1116_;
										_tmp1118_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1117_);
										_tmp1119_ = _tmp1118_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1114_, _tmp1119_);
										_vala_ccode_node_unref0 (_tmp1119_);
										_tmp1120_ = carg_map;
										_tmp1121_ = param;
										_tmp1122_ = arg;
										_tmp1123_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1122_);
										_tmp1124_ = _tmp1123_;
										_tmp1125_ = vala_list_get (_tmp1124_, dim - 1);
										_tmp1126_ = (ValaCCodeExpression*) _tmp1125_;
										_tmp1127_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1126_);
										_tmp1128_ = _tmp1127_;
										vala_map_set ((ValaMap*) _tmp1120_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1121_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1128_);
										_vala_ccode_node_unref0 (_tmp1128_);
										_vala_ccode_node_unref0 (_tmp1126_);
										_vala_iterable_unref0 (_tmp1124_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_g_free0 (length_ctype);
							_g_free0 (_tmp1097_);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1129_;
							ValaDataType* _tmp1130_;
							ValaDataType* _tmp1131_;
							_tmp1129_ = param;
							_tmp1130_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1129_);
							_tmp1131_ = _tmp1130_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1131_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1132_;
								ValaDataType* _tmp1133_;
								ValaDataType* _tmp1134_;
								ValaDelegateType* _tmp1135_;
								ValaDelegateType* _tmp1136_;
								ValaDelegate* _tmp1137_;
								ValaDelegate* _tmp1138_;
								gboolean _tmp1139_;
								gboolean _tmp1140_;
								_tmp1132_ = param;
								_tmp1133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1132_);
								_tmp1134_ = _tmp1133_;
								_tmp1135_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1134_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1135_;
								_tmp1136_ = deleg_type;
								_tmp1137_ = vala_delegate_type_get_delegate_symbol (_tmp1136_);
								_tmp1138_ = _tmp1137_;
								_tmp1139_ = vala_delegate_get_has_target (_tmp1138_);
								_tmp1140_ = _tmp1139_;
								if (_tmp1140_) {
									ValaVoidType* _tmp1141_;
									ValaVoidType* _tmp1142_;
									ValaPointerType* _tmp1143_;
									ValaPointerType* _tmp1144_;
									ValaLocalVariable* _tmp1145_;
									ValaLocalVariable* _tmp1146_;
									ValaExpression* _tmp1147_;
									ValaLocalVariable* _tmp1148_;
									const gchar* _tmp1149_;
									const gchar* _tmp1150_;
									ValaCCodeExpression* _tmp1151_;
									ValaCCodeExpression* _tmp1152_;
									ValaHashMap* _tmp1153_;
									ValaParameter* _tmp1154_;
									ValaExpression* _tmp1155_;
									ValaCCodeExpression* _tmp1156_;
									ValaCCodeExpression* _tmp1157_;
									ValaCCodeUnaryExpression* _tmp1158_;
									ValaCCodeUnaryExpression* _tmp1159_;
									ValaDelegateType* _tmp1160_;
									_tmp1141_ = vala_void_type_new (NULL);
									_tmp1142_ = _tmp1141_;
									_tmp1143_ = vala_pointer_type_new ((ValaDataType*) _tmp1142_, NULL);
									_tmp1144_ = _tmp1143_;
									_tmp1145_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1144_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1145_;
									_vala_code_node_unref0 (_tmp1144_);
									_vala_code_node_unref0 (_tmp1142_);
									_tmp1146_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1146_, FALSE);
									_tmp1147_ = arg;
									_tmp1148_ = temp_var;
									_tmp1149_ = vala_symbol_get_name ((ValaSymbol*) _tmp1148_);
									_tmp1150_ = _tmp1149_;
									_tmp1151_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1150_);
									_tmp1152_ = _tmp1151_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1147_, _tmp1152_);
									_vala_ccode_node_unref0 (_tmp1152_);
									_tmp1153_ = carg_map;
									_tmp1154_ = param;
									_tmp1155_ = arg;
									_tmp1156_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1155_);
									_tmp1157_ = _tmp1156_;
									_tmp1158_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1157_);
									_tmp1159_ = _tmp1158_;
									vala_map_set ((ValaMap*) _tmp1153_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1154_), FALSE)), (ValaCCodeExpression*) _tmp1159_);
									_vala_ccode_node_unref0 (_tmp1159_);
									_vala_ccode_node_unref0 (_tmp1157_);
									_tmp1160_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1160_)) {
										ValaDataType* _tmp1161_;
										ValaLocalVariable* _tmp1162_;
										ValaLocalVariable* _tmp1163_;
										ValaExpression* _tmp1164_;
										ValaLocalVariable* _tmp1165_;
										const gchar* _tmp1166_;
										const gchar* _tmp1167_;
										ValaCCodeExpression* _tmp1168_;
										ValaCCodeExpression* _tmp1169_;
										ValaHashMap* _tmp1170_;
										ValaParameter* _tmp1171_;
										ValaExpression* _tmp1172_;
										ValaCCodeExpression* _tmp1173_;
										ValaCCodeExpression* _tmp1174_;
										ValaCCodeUnaryExpression* _tmp1175_;
										ValaCCodeUnaryExpression* _tmp1176_;
										_tmp1161_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1162_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1161_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1162_;
										_tmp1163_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1163_, FALSE);
										_tmp1164_ = arg;
										_tmp1165_ = temp_var;
										_tmp1166_ = vala_symbol_get_name ((ValaSymbol*) _tmp1165_);
										_tmp1167_ = _tmp1166_;
										_tmp1168_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1167_);
										_tmp1169_ = _tmp1168_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1164_, _tmp1169_);
										_vala_ccode_node_unref0 (_tmp1169_);
										_tmp1170_ = carg_map;
										_tmp1171_ = param;
										_tmp1172_ = arg;
										_tmp1173_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1172_);
										_tmp1174_ = _tmp1173_;
										_tmp1175_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1174_);
										_tmp1176_ = _tmp1175_;
										vala_map_set ((ValaMap*) _tmp1170_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1171_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1176_);
										_vala_ccode_node_unref0 (_tmp1176_);
										_vala_ccode_node_unref0 (_tmp1174_);
									}
								}
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1177_ = param;
					_tmp1178_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1177_);
					_tmp1179_ = _tmp1178_;
					_tmp1180_ = _tmp1179_ != NULL;
					_g_free0 (_tmp1179_);
					if (_tmp1180_) {
						ValaCCodeExpression* _tmp1181_;
						ValaParameter* _tmp1182_;
						gchar* _tmp1183_;
						gchar* _tmp1184_;
						ValaCCodeCastExpression* _tmp1185_;
						_tmp1181_ = cexpr;
						_tmp1182_ = param;
						_tmp1183_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1182_);
						_tmp1184_ = _tmp1183_;
						_tmp1185_ = vala_ccode_cast_expression_new (_tmp1181_, _tmp1184_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1185_;
						_g_free0 (_tmp1184_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1186_;
					ValaCCodeExpression* _tmp1187_;
					ValaCCodeExpression* _tmp1188_;
					_tmp1186_ = arg;
					_tmp1187_ = cexpr;
					_tmp1188_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1186_, _tmp1187_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1188_;
				}
				_tmp1189_ = param;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1189_), ellipsis);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1190_;
				ValaCCodeExpression* _tmp1191_;
				ValaCCodeExpression* _tmp1192_;
				_tmp1190_ = arg;
				_tmp1191_ = cexpr;
				_tmp1192_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1190_, _tmp1191_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1192_;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) i, ellipsis);
			}
			_tmp1193_ = carg_map;
			_tmp1194_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1193_, (gpointer) ((gintptr) arg_pos), _tmp1194_);
			_tmp1196_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1196_, VALA_TYPE_NAMED_ARGUMENT)) {
				_tmp1195_ = ellipsis;
			} else {
				_tmp1195_ = FALSE;
			}
			if (_tmp1195_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1197_;
				ValaNamedArgument* _tmp1198_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1199_;
				const gchar* _tmp1200_;
				const gchar* _tmp1201_;
				gchar** _tmp1202_;
				gchar** _tmp1203_;
				gchar** _tmp1204_;
				gint _tmp1204__length1;
				gchar* _tmp1205_;
				gchar* _tmp1206_;
				ValaHashMap* _tmp1207_;
				const gchar* _tmp1208_;
				gchar* _tmp1209_;
				gchar* _tmp1210_;
				ValaCCodeConstant* _tmp1211_;
				ValaCCodeConstant* _tmp1212_;
				_tmp1197_ = arg;
				_tmp1198_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1197_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1198_;
				_tmp1199_ = named_arg;
				_tmp1200_ = vala_named_argument_get_name (_tmp1199_);
				_tmp1201_ = _tmp1200_;
				_tmp1203_ = _tmp1202_ = g_strsplit (_tmp1201_, "_", 0);
				_tmp1204_ = _tmp1203_;
				_tmp1204__length1 = _vala_array_length (_tmp1202_);
				_tmp1205_ = _vala_g_strjoinv ("-", _tmp1204_, (gint) _vala_array_length (_tmp1202_));
				_tmp1206_ = _tmp1205_;
				_tmp1204_ = (_vala_array_free (_tmp1204_, _tmp1204__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1206_;
				_tmp1207_ = carg_map;
				_tmp1208_ = name;
				_tmp1209_ = g_strdup_printf ("\"%s\"", _tmp1208_);
				_tmp1210_ = _tmp1209_;
				_tmp1211_ = vala_ccode_constant_new (_tmp1210_);
				_tmp1212_ = _tmp1211_;
				vala_map_set ((ValaMap*) _tmp1207_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, i - 0.1, ellipsis)), (ValaCCodeExpression*) _tmp1212_);
				_vala_ccode_node_unref0 (_tmp1212_);
				_g_free0 (_tmp1210_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1213_ = i;
			i = _tmp1213_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1214_ = params_it;
	if (vala_iterator_next (_tmp1214_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1215_;
		gpointer _tmp1216_;
		gboolean _tmp1217_ = FALSE;
		ValaParameter* _tmp1218_;
		gboolean _tmp1219_;
		gboolean _tmp1220_;
		_tmp1215_ = params_it;
		_tmp1216_ = vala_iterator_get (_tmp1215_);
		param = (ValaParameter*) _tmp1216_;
		_tmp1218_ = param;
		_tmp1219_ = vala_parameter_get_params_array (_tmp1218_);
		_tmp1220_ = _tmp1219_;
		if (_tmp1220_) {
			_tmp1217_ = TRUE;
		} else {
			ValaParameter* _tmp1221_;
			gboolean _tmp1222_;
			gboolean _tmp1223_;
			_tmp1221_ = param;
			_tmp1222_ = vala_parameter_get_ellipsis (_tmp1221_);
			_tmp1223_ = _tmp1222_;
			_tmp1217_ = _tmp1223_;
		}
		_vala_assert (_tmp1217_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1226_ = m;
	if (_tmp1226_ != NULL) {
		ValaMethod* _tmp1227_;
		ValaDataType* _tmp1228_;
		ValaDataType* _tmp1229_;
		_tmp1227_ = m;
		_tmp1228_ = vala_callable_get_return_type ((ValaCallable*) _tmp1227_);
		_tmp1229_ = _tmp1228_;
		_tmp1225_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1229_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1225_ = FALSE;
	}
	if (_tmp1225_) {
		ValaCCodeFunctionCall* _tmp1230_;
		ValaCCodeFunctionCall* _tmp1231_;
		_tmp1230_ = async_call;
		_tmp1231_ = ccall;
		_tmp1224_ = _tmp1230_ != _tmp1231_;
	} else {
		_tmp1224_ = FALSE;
	}
	if (_tmp1224_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1232_;
		ValaDataType* _tmp1233_;
		ValaDataType* _tmp1234_;
		ValaArrayType* _tmp1235_;
		_tmp1232_ = m;
		_tmp1233_ = vala_callable_get_return_type ((ValaCallable*) _tmp1232_);
		_tmp1234_ = _tmp1233_;
		_tmp1235_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1234_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1235_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1236_ = FALSE;
				_tmp1236_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1238_;
					gint _tmp1239_;
					gint _tmp1240_;
					ValaMethod* _tmp1241_;
					if (!_tmp1236_) {
						gint _tmp1237_;
						_tmp1237_ = dim;
						dim = _tmp1237_ + 1;
					}
					_tmp1236_ = FALSE;
					_tmp1238_ = array_type;
					_tmp1239_ = vala_array_type_get_rank (_tmp1238_);
					_tmp1240_ = _tmp1239_;
					if (!(dim <= _tmp1240_)) {
						break;
					}
					_tmp1241_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1241_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1242_;
						ValaDataType* _tmp1243_;
						ValaDataType* _tmp1244_;
						ValaLocalVariable* _tmp1245_;
						ValaLocalVariable* _tmp1246_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1247_;
						const gchar* _tmp1248_;
						const gchar* _tmp1249_;
						ValaCCodeExpression* _tmp1250_;
						ValaLocalVariable* _tmp1251_;
						ValaCCodeExpression* _tmp1252_;
						ValaCCodeExpression* _tmp1253_;
						ValaCCodeAssignment* _tmp1254_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1255_;
						ValaCCodeIdentifier* _tmp1256_;
						ValaCCodeFunctionCall* _tmp1257_;
						ValaCCodeFunctionCall* _tmp1258_;
						ValaCCodeFunctionCall* _tmp1259_;
						ValaCCodeExpression* _tmp1260_;
						ValaCCodeFunctionCall* _tmp1261_;
						_tmp1242_ = itype;
						_tmp1243_ = vala_data_type_get_return_type (_tmp1242_);
						_tmp1244_ = _tmp1243_;
						_tmp1245_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1244_, TRUE, NULL, FALSE);
						_tmp1246_ = _tmp1245_;
						_vala_code_node_unref0 (_tmp1244_);
						temp_var = _tmp1246_;
						_tmp1247_ = temp_var;
						_tmp1248_ = vala_symbol_get_name ((ValaSymbol*) _tmp1247_);
						_tmp1249_ = _tmp1248_;
						_tmp1250_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1249_);
						temp_ref = _tmp1250_;
						_tmp1251_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1251_, FALSE);
						_tmp1252_ = temp_ref;
						_tmp1253_ = ccall_expr;
						_tmp1254_ = vala_ccode_assignment_new (_tmp1252_, _tmp1253_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1254_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1255_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1256_ = _tmp1255_;
						_tmp1257_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1256_);
						_tmp1258_ = _tmp1257_;
						_vala_ccode_node_unref0 (_tmp1256_);
						len_call = _tmp1258_;
						_tmp1259_ = len_call;
						_tmp1260_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1259_, _tmp1260_);
						_tmp1261_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1261_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1262_;
						_tmp1262_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1262_)) {
							gchar* _tmp1263_ = NULL;
							ValaMethod* _tmp1264_;
							gchar* _tmp1265_;
							gchar* length_ctype = NULL;
							gchar* _tmp1268_;
							ValaLocalVariable* temp_var = NULL;
							const gchar* _tmp1269_;
							ValaCType* _tmp1270_;
							ValaCType* _tmp1271_;
							ValaLocalVariable* _tmp1272_;
							ValaLocalVariable* _tmp1273_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1274_;
							const gchar* _tmp1275_;
							const gchar* _tmp1276_;
							ValaCCodeExpression* _tmp1277_;
							ValaLocalVariable* _tmp1278_;
							ValaHashMap* _tmp1279_;
							ValaMethod* _tmp1280_;
							ValaCCodeExpression* _tmp1281_;
							ValaCCodeUnaryExpression* _tmp1282_;
							ValaCCodeUnaryExpression* _tmp1283_;
							ValaCCodeExpression* _tmp1284_;
							_tmp1264_ = m;
							_tmp1265_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1264_);
							_tmp1263_ = _tmp1265_;
							if (_tmp1263_ == NULL) {
								ValaArrayType* _tmp1266_;
								gchar* _tmp1267_;
								_tmp1266_ = array_type;
								_tmp1267_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1266_);
								_g_free0 (_tmp1263_);
								_tmp1263_ = _tmp1267_;
							}
							_tmp1268_ = g_strdup (_tmp1263_);
							length_ctype = _tmp1268_;
							_tmp1269_ = length_ctype;
							_tmp1270_ = vala_ctype_new (_tmp1269_);
							_tmp1271_ = _tmp1270_;
							_tmp1272_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1271_, TRUE, NULL, TRUE);
							_tmp1273_ = _tmp1272_;
							_vala_code_node_unref0 (_tmp1271_);
							temp_var = _tmp1273_;
							_tmp1274_ = temp_var;
							_tmp1275_ = vala_symbol_get_name ((ValaSymbol*) _tmp1274_);
							_tmp1276_ = _tmp1275_;
							_tmp1277_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1276_);
							temp_ref = _tmp1277_;
							_tmp1278_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1278_, FALSE);
							_tmp1279_ = out_arg_map;
							_tmp1280_ = m;
							_tmp1281_ = temp_ref;
							_tmp1282_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1281_);
							_tmp1283_ = _tmp1282_;
							vala_map_set ((ValaMap*) _tmp1279_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1280_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1283_);
							_vala_ccode_node_unref0 (_tmp1283_);
							_tmp1284_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1284_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
							_g_free0 (length_ctype);
							_g_free0 (_tmp1263_);
						} else {
							ValaMethod* _tmp1285_;
							gchar* _tmp1286_;
							gchar* _tmp1287_;
							gboolean _tmp1288_;
							_tmp1285_ = m;
							_tmp1286_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1285_);
							_tmp1287_ = _tmp1286_;
							_tmp1288_ = _tmp1287_ != NULL;
							_g_free0 (_tmp1287_);
							if (_tmp1288_) {
								ValaMethod* _tmp1289_;
								gchar* _tmp1290_;
								gchar* _tmp1291_;
								ValaCCodeConstant* _tmp1292_;
								ValaCCodeConstant* _tmp1293_;
								_tmp1289_ = m;
								_tmp1290_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1289_);
								_tmp1291_ = _tmp1290_;
								_tmp1292_ = vala_ccode_constant_new (_tmp1291_);
								_tmp1293_ = _tmp1292_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1293_);
								_vala_ccode_node_unref0 (_tmp1293_);
								_g_free0 (_tmp1291_);
							} else {
								ValaCCodeConstant* _tmp1294_;
								ValaCCodeConstant* _tmp1295_;
								_tmp1294_ = vala_ccode_constant_new ("-1");
								_tmp1295_ = _tmp1294_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1295_);
								_vala_ccode_node_unref0 (_tmp1295_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1296_ = FALSE;
		gboolean _tmp1297_ = FALSE;
		ValaMethod* _tmp1298_;
		_tmp1298_ = m;
		if (_tmp1298_ != NULL) {
			ValaMethod* _tmp1299_;
			ValaDataType* _tmp1300_;
			ValaDataType* _tmp1301_;
			_tmp1299_ = m;
			_tmp1300_ = vala_callable_get_return_type ((ValaCallable*) _tmp1299_);
			_tmp1301_ = _tmp1300_;
			_tmp1297_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1301_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1297_ = FALSE;
		}
		if (_tmp1297_) {
			ValaCCodeFunctionCall* _tmp1302_;
			ValaCCodeFunctionCall* _tmp1303_;
			_tmp1302_ = async_call;
			_tmp1303_ = ccall;
			_tmp1296_ = _tmp1302_ != _tmp1303_;
		} else {
			_tmp1296_ = FALSE;
		}
		if (_tmp1296_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1304_;
			ValaDataType* _tmp1305_;
			ValaDataType* _tmp1306_;
			ValaDelegateType* _tmp1307_;
			ValaDelegateType* _tmp1308_;
			ValaDelegate* _tmp1309_;
			ValaDelegate* _tmp1310_;
			gboolean _tmp1311_;
			gboolean _tmp1312_;
			_tmp1304_ = m;
			_tmp1305_ = vala_callable_get_return_type ((ValaCallable*) _tmp1304_);
			_tmp1306_ = _tmp1305_;
			_tmp1307_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1306_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1307_;
			_tmp1308_ = deleg_type;
			_tmp1309_ = vala_delegate_type_get_delegate_symbol (_tmp1308_);
			_tmp1310_ = _tmp1309_;
			_tmp1311_ = vala_delegate_get_has_target (_tmp1310_);
			_tmp1312_ = _tmp1311_;
			if (_tmp1312_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1313_;
				ValaVoidType* _tmp1314_;
				ValaPointerType* _tmp1315_;
				ValaPointerType* _tmp1316_;
				ValaLocalVariable* _tmp1317_;
				ValaLocalVariable* _tmp1318_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1319_;
				const gchar* _tmp1320_;
				const gchar* _tmp1321_;
				ValaCCodeExpression* _tmp1322_;
				ValaLocalVariable* _tmp1323_;
				ValaHashMap* _tmp1324_;
				ValaMethod* _tmp1325_;
				ValaCCodeExpression* _tmp1326_;
				ValaCCodeUnaryExpression* _tmp1327_;
				ValaCCodeUnaryExpression* _tmp1328_;
				ValaCCodeExpression* _tmp1329_;
				ValaDelegateType* _tmp1330_;
				_tmp1313_ = vala_void_type_new (NULL);
				_tmp1314_ = _tmp1313_;
				_tmp1315_ = vala_pointer_type_new ((ValaDataType*) _tmp1314_, NULL);
				_tmp1316_ = _tmp1315_;
				_tmp1317_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1316_, TRUE, NULL, TRUE);
				_tmp1318_ = _tmp1317_;
				_vala_code_node_unref0 (_tmp1316_);
				_vala_code_node_unref0 (_tmp1314_);
				temp_var = _tmp1318_;
				_tmp1319_ = temp_var;
				_tmp1320_ = vala_symbol_get_name ((ValaSymbol*) _tmp1319_);
				_tmp1321_ = _tmp1320_;
				_tmp1322_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1321_);
				temp_ref = _tmp1322_;
				_tmp1323_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1323_, FALSE);
				_tmp1324_ = out_arg_map;
				_tmp1325_ = m;
				_tmp1326_ = temp_ref;
				_tmp1327_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1326_);
				_tmp1328_ = _tmp1327_;
				vala_map_set ((ValaMap*) _tmp1324_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1325_), FALSE)), (ValaCCodeExpression*) _tmp1328_);
				_vala_ccode_node_unref0 (_tmp1328_);
				_tmp1329_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1329_);
				_tmp1330_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1330_)) {
					ValaDataType* _tmp1331_;
					ValaLocalVariable* _tmp1332_;
					ValaLocalVariable* _tmp1333_;
					const gchar* _tmp1334_;
					const gchar* _tmp1335_;
					ValaCCodeExpression* _tmp1336_;
					ValaLocalVariable* _tmp1337_;
					ValaHashMap* _tmp1338_;
					ValaMethod* _tmp1339_;
					ValaCCodeExpression* _tmp1340_;
					ValaCCodeUnaryExpression* _tmp1341_;
					ValaCCodeUnaryExpression* _tmp1342_;
					ValaCCodeExpression* _tmp1343_;
					_tmp1331_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1332_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1331_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1332_;
					_tmp1333_ = temp_var;
					_tmp1334_ = vala_symbol_get_name ((ValaSymbol*) _tmp1333_);
					_tmp1335_ = _tmp1334_;
					_tmp1336_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1335_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1336_;
					_tmp1337_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1337_, FALSE);
					_tmp1338_ = out_arg_map;
					_tmp1339_ = m;
					_tmp1340_ = temp_ref;
					_tmp1341_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1340_);
					_tmp1342_ = _tmp1341_;
					vala_map_set ((ValaMap*) _tmp1338_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1339_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1342_);
					_vala_ccode_node_unref0 (_tmp1342_);
					_tmp1343_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1343_);
				} else {
					ValaCCodeConstant* _tmp1344_;
					ValaCCodeConstant* _tmp1345_;
					_tmp1344_ = vala_ccode_constant_new ("NULL");
					_tmp1345_ = _tmp1344_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1345_);
					_vala_ccode_node_unref0 (_tmp1345_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1346_;
				ValaCCodeConstant* _tmp1347_;
				_tmp1346_ = vala_ccode_constant_new ("NULL");
				_tmp1347_ = _tmp1346_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1347_);
				_vala_ccode_node_unref0 (_tmp1347_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1349_ = deleg;
	if (_tmp1349_ != NULL) {
		ValaDelegate* _tmp1350_;
		ValaDataType* _tmp1351_;
		ValaDataType* _tmp1352_;
		_tmp1350_ = deleg;
		_tmp1351_ = vala_callable_get_return_type ((ValaCallable*) _tmp1350_);
		_tmp1352_ = _tmp1351_;
		_tmp1348_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1352_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1348_ = FALSE;
	}
	if (_tmp1348_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1353_;
		ValaDataType* _tmp1354_;
		ValaDataType* _tmp1355_;
		ValaArrayType* _tmp1356_;
		_tmp1353_ = deleg;
		_tmp1354_ = vala_callable_get_return_type ((ValaCallable*) _tmp1353_);
		_tmp1355_ = _tmp1354_;
		_tmp1356_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1355_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1356_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1357_ = FALSE;
				_tmp1357_ = TRUE;
				while (TRUE) {
					ValaArrayType* _tmp1359_;
					gint _tmp1360_;
					gint _tmp1361_;
					ValaDelegate* _tmp1362_;
					if (!_tmp1357_) {
						gint _tmp1358_;
						_tmp1358_ = dim;
						dim = _tmp1358_ + 1;
					}
					_tmp1357_ = FALSE;
					_tmp1359_ = array_type;
					_tmp1360_ = vala_array_type_get_rank (_tmp1359_);
					_tmp1361_ = _tmp1360_;
					if (!(dim <= _tmp1361_)) {
						break;
					}
					_tmp1362_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1362_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1363_;
						ValaDataType* _tmp1364_;
						ValaDataType* _tmp1365_;
						ValaLocalVariable* _tmp1366_;
						ValaLocalVariable* _tmp1367_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1368_;
						const gchar* _tmp1369_;
						const gchar* _tmp1370_;
						ValaCCodeExpression* _tmp1371_;
						ValaLocalVariable* _tmp1372_;
						ValaCCodeExpression* _tmp1373_;
						ValaCCodeExpression* _tmp1374_;
						ValaCCodeAssignment* _tmp1375_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1376_;
						ValaCCodeIdentifier* _tmp1377_;
						ValaCCodeFunctionCall* _tmp1378_;
						ValaCCodeFunctionCall* _tmp1379_;
						ValaCCodeFunctionCall* _tmp1380_;
						ValaCCodeExpression* _tmp1381_;
						ValaCCodeFunctionCall* _tmp1382_;
						_tmp1363_ = itype;
						_tmp1364_ = vala_data_type_get_return_type (_tmp1363_);
						_tmp1365_ = _tmp1364_;
						_tmp1366_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1365_, TRUE, NULL, FALSE);
						_tmp1367_ = _tmp1366_;
						_vala_code_node_unref0 (_tmp1365_);
						temp_var = _tmp1367_;
						_tmp1368_ = temp_var;
						_tmp1369_ = vala_symbol_get_name ((ValaSymbol*) _tmp1368_);
						_tmp1370_ = _tmp1369_;
						_tmp1371_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1370_);
						temp_ref = _tmp1371_;
						_tmp1372_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1372_, FALSE);
						_tmp1373_ = temp_ref;
						_tmp1374_ = ccall_expr;
						_tmp1375_ = vala_ccode_assignment_new (_tmp1373_, _tmp1374_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1375_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1376_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1377_ = _tmp1376_;
						_tmp1378_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1377_);
						_tmp1379_ = _tmp1378_;
						_vala_ccode_node_unref0 (_tmp1377_);
						len_call = _tmp1379_;
						_tmp1380_ = len_call;
						_tmp1381_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1380_, _tmp1381_);
						_tmp1382_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1382_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1383_;
						_tmp1383_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1383_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaArrayType* _tmp1384_;
							gchar* _tmp1385_;
							gchar* _tmp1386_;
							ValaCType* _tmp1387_;
							ValaCType* _tmp1388_;
							ValaLocalVariable* _tmp1389_;
							ValaLocalVariable* _tmp1390_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1391_;
							const gchar* _tmp1392_;
							const gchar* _tmp1393_;
							ValaCCodeExpression* _tmp1394_;
							ValaLocalVariable* _tmp1395_;
							ValaHashMap* _tmp1396_;
							ValaDelegate* _tmp1397_;
							ValaCCodeExpression* _tmp1398_;
							ValaCCodeUnaryExpression* _tmp1399_;
							ValaCCodeUnaryExpression* _tmp1400_;
							ValaCCodeExpression* _tmp1401_;
							_tmp1384_ = array_type;
							_tmp1385_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1384_);
							_tmp1386_ = _tmp1385_;
							_tmp1387_ = vala_ctype_new (_tmp1386_);
							_tmp1388_ = _tmp1387_;
							_tmp1389_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1388_, TRUE, NULL, TRUE);
							_tmp1390_ = _tmp1389_;
							_vala_code_node_unref0 (_tmp1388_);
							_g_free0 (_tmp1386_);
							temp_var = _tmp1390_;
							_tmp1391_ = temp_var;
							_tmp1392_ = vala_symbol_get_name ((ValaSymbol*) _tmp1391_);
							_tmp1393_ = _tmp1392_;
							_tmp1394_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1393_);
							temp_ref = _tmp1394_;
							_tmp1395_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1395_, FALSE);
							_tmp1396_ = out_arg_map;
							_tmp1397_ = deleg;
							_tmp1398_ = temp_ref;
							_tmp1399_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1398_);
							_tmp1400_ = _tmp1399_;
							vala_map_set ((ValaMap*) _tmp1396_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1397_) + (0.01 * dim), FALSE)), (ValaCCodeExpression*) _tmp1400_);
							_vala_ccode_node_unref0 (_tmp1400_);
							_tmp1401_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1401_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1402_;
							ValaCCodeConstant* _tmp1403_;
							_tmp1402_ = vala_ccode_constant_new ("-1");
							_tmp1403_ = _tmp1402_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1403_);
							_vala_ccode_node_unref0 (_tmp1403_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1404_ = FALSE;
		ValaDelegate* _tmp1405_;
		_tmp1405_ = deleg;
		if (_tmp1405_ != NULL) {
			ValaDelegate* _tmp1406_;
			ValaDataType* _tmp1407_;
			ValaDataType* _tmp1408_;
			_tmp1406_ = deleg;
			_tmp1407_ = vala_callable_get_return_type ((ValaCallable*) _tmp1406_);
			_tmp1408_ = _tmp1407_;
			_tmp1404_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1408_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1404_ = FALSE;
		}
		if (_tmp1404_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1409_;
			ValaDataType* _tmp1410_;
			ValaDataType* _tmp1411_;
			ValaDelegateType* _tmp1412_;
			ValaDelegateType* _tmp1413_;
			ValaDelegate* _tmp1414_;
			ValaDelegate* _tmp1415_;
			gboolean _tmp1416_;
			gboolean _tmp1417_;
			_tmp1409_ = deleg;
			_tmp1410_ = vala_callable_get_return_type ((ValaCallable*) _tmp1409_);
			_tmp1411_ = _tmp1410_;
			_tmp1412_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1411_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1412_;
			_tmp1413_ = deleg_type;
			_tmp1414_ = vala_delegate_type_get_delegate_symbol (_tmp1413_);
			_tmp1415_ = _tmp1414_;
			_tmp1416_ = vala_delegate_get_has_target (_tmp1415_);
			_tmp1417_ = _tmp1416_;
			if (_tmp1417_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1418_;
				ValaVoidType* _tmp1419_;
				ValaPointerType* _tmp1420_;
				ValaPointerType* _tmp1421_;
				ValaLocalVariable* _tmp1422_;
				ValaLocalVariable* _tmp1423_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1424_;
				const gchar* _tmp1425_;
				const gchar* _tmp1426_;
				ValaCCodeExpression* _tmp1427_;
				ValaLocalVariable* _tmp1428_;
				ValaHashMap* _tmp1429_;
				ValaDelegate* _tmp1430_;
				ValaCCodeExpression* _tmp1431_;
				ValaCCodeUnaryExpression* _tmp1432_;
				ValaCCodeUnaryExpression* _tmp1433_;
				ValaCCodeExpression* _tmp1434_;
				ValaDelegateType* _tmp1435_;
				_tmp1418_ = vala_void_type_new (NULL);
				_tmp1419_ = _tmp1418_;
				_tmp1420_ = vala_pointer_type_new ((ValaDataType*) _tmp1419_, NULL);
				_tmp1421_ = _tmp1420_;
				_tmp1422_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1421_, TRUE, NULL, TRUE);
				_tmp1423_ = _tmp1422_;
				_vala_code_node_unref0 (_tmp1421_);
				_vala_code_node_unref0 (_tmp1419_);
				temp_var = _tmp1423_;
				_tmp1424_ = temp_var;
				_tmp1425_ = vala_symbol_get_name ((ValaSymbol*) _tmp1424_);
				_tmp1426_ = _tmp1425_;
				_tmp1427_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1426_);
				temp_ref = _tmp1427_;
				_tmp1428_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1428_, FALSE);
				_tmp1429_ = out_arg_map;
				_tmp1430_ = deleg;
				_tmp1431_ = temp_ref;
				_tmp1432_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1431_);
				_tmp1433_ = _tmp1432_;
				vala_map_set ((ValaMap*) _tmp1429_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1430_), FALSE)), (ValaCCodeExpression*) _tmp1433_);
				_vala_ccode_node_unref0 (_tmp1433_);
				_tmp1434_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1434_);
				_tmp1435_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1435_)) {
					ValaDataType* _tmp1436_;
					ValaLocalVariable* _tmp1437_;
					ValaLocalVariable* _tmp1438_;
					const gchar* _tmp1439_;
					const gchar* _tmp1440_;
					ValaCCodeExpression* _tmp1441_;
					ValaLocalVariable* _tmp1442_;
					ValaHashMap* _tmp1443_;
					ValaDelegate* _tmp1444_;
					ValaCCodeExpression* _tmp1445_;
					ValaCCodeUnaryExpression* _tmp1446_;
					ValaCCodeUnaryExpression* _tmp1447_;
					ValaCCodeExpression* _tmp1448_;
					_tmp1436_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1437_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1436_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1437_;
					_tmp1438_ = temp_var;
					_tmp1439_ = vala_symbol_get_name ((ValaSymbol*) _tmp1438_);
					_tmp1440_ = _tmp1439_;
					_tmp1441_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1440_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1441_;
					_tmp1442_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1442_, FALSE);
					_tmp1443_ = out_arg_map;
					_tmp1444_ = deleg;
					_tmp1445_ = temp_ref;
					_tmp1446_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1445_);
					_tmp1447_ = _tmp1446_;
					vala_map_set ((ValaMap*) _tmp1443_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1444_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1447_);
					_vala_ccode_node_unref0 (_tmp1447_);
					_tmp1448_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1448_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1450_ = m;
	if (_tmp1450_ != NULL) {
		ValaMethod* _tmp1451_;
		gboolean _tmp1452_;
		gboolean _tmp1453_;
		_tmp1451_ = m;
		_tmp1452_ = vala_method_get_coroutine (_tmp1451_);
		_tmp1453_ = _tmp1452_;
		_tmp1449_ = _tmp1453_;
	} else {
		_tmp1449_ = FALSE;
	}
	if (_tmp1449_) {
		gboolean _tmp1454_;
		gboolean _tmp1455_;
		_tmp1454_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1455_ = _tmp1454_;
		if (_tmp1455_) {
			ValaHashMap* _tmp1456_;
			ValaMethod* _tmp1457_;
			ValaMethod* _tmp1458_;
			gchar* _tmp1459_;
			gchar* _tmp1460_;
			ValaCCodeIdentifier* _tmp1461_;
			ValaCCodeIdentifier* _tmp1462_;
			ValaHashMap* _tmp1463_;
			ValaCCodeIdentifier* _tmp1464_;
			ValaCCodeIdentifier* _tmp1465_;
			_tmp1456_ = in_arg_map;
			_tmp1457_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1458_ = _tmp1457_;
			_tmp1459_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1458_);
			_tmp1460_ = _tmp1459_;
			_tmp1461_ = vala_ccode_identifier_new (_tmp1460_);
			_tmp1462_ = _tmp1461_;
			vala_map_set ((ValaMap*) _tmp1456_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1462_);
			_vala_ccode_node_unref0 (_tmp1462_);
			_g_free0 (_tmp1460_);
			_tmp1463_ = in_arg_map;
			_tmp1464_ = vala_ccode_identifier_new ("_data_");
			_tmp1465_ = _tmp1464_;
			vala_map_set ((ValaMap*) _tmp1463_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1465_);
			_vala_ccode_node_unref0 (_tmp1465_);
		}
	}
	_tmp1466_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1467_ = _tmp1466_;
	if (_tmp1467_) {
		ValaHashMap* _tmp1468_;
		ValaCCodeExpression* _tmp1469_;
		ValaCCodeExpression* _tmp1470_;
		ValaCCodeUnaryExpression* _tmp1471_;
		ValaCCodeUnaryExpression* _tmp1472_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1468_ = out_arg_map;
		_tmp1469_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1470_ = _tmp1469_;
		_tmp1471_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1470_);
		_tmp1472_ = _tmp1471_;
		vala_map_set ((ValaMap*) _tmp1468_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1472_);
		_vala_ccode_node_unref0 (_tmp1472_);
		_vala_ccode_node_unref0 (_tmp1470_);
	} else {
		gboolean _tmp1473_ = FALSE;
		gboolean _tmp1474_ = FALSE;
		ValaMethod* _tmp1475_;
		_tmp1475_ = m;
		if (_tmp1475_ != NULL) {
			ValaMethod* _tmp1476_;
			_tmp1476_ = m;
			_tmp1474_ = vala_method_has_error_type_parameter (_tmp1476_);
		} else {
			_tmp1474_ = FALSE;
		}
		if (_tmp1474_) {
			ValaCCodeFunctionCall* _tmp1477_;
			ValaCCodeFunctionCall* _tmp1478_;
			_tmp1477_ = async_call;
			_tmp1478_ = ccall;
			_tmp1473_ = _tmp1477_ != _tmp1478_;
		} else {
			_tmp1473_ = FALSE;
		}
		if (_tmp1473_) {
			ValaHashMap* _tmp1479_;
			ValaCCodeConstant* _tmp1480_;
			ValaCCodeConstant* _tmp1481_;
			_tmp1479_ = out_arg_map;
			_tmp1480_ = vala_ccode_constant_new ("NULL");
			_tmp1481_ = _tmp1480_;
			vala_map_set ((ValaMap*) _tmp1479_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1481_);
			_vala_ccode_node_unref0 (_tmp1481_);
		}
	}
	if (ellipsis) {
		ValaMethod* _tmp1482_;
		_tmp1482_ = m;
		if (_tmp1482_ == NULL) {
			ValaHashMap* _tmp1483_;
			ValaCCodeConstant* _tmp1484_;
			ValaCCodeConstant* _tmp1485_;
			_tmp1483_ = in_arg_map;
			_tmp1484_ = vala_ccode_constant_new ("NULL");
			_tmp1485_ = _tmp1484_;
			vala_map_set ((ValaMap*) _tmp1483_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1485_);
			_vala_ccode_node_unref0 (_tmp1485_);
		} else {
			gboolean _tmp1486_ = FALSE;
			gboolean _tmp1487_ = FALSE;
			gboolean _tmp1488_ = FALSE;
			ValaMethod* _tmp1489_;
			gboolean _tmp1490_;
			gboolean _tmp1491_;
			_tmp1489_ = m;
			_tmp1490_ = vala_method_get_printf_format (_tmp1489_);
			_tmp1491_ = _tmp1490_;
			if (!_tmp1491_) {
				ValaMethod* _tmp1492_;
				gboolean _tmp1493_;
				gboolean _tmp1494_;
				_tmp1492_ = m;
				_tmp1493_ = vala_method_get_scanf_format (_tmp1492_);
				_tmp1494_ = _tmp1493_;
				_tmp1488_ = !_tmp1494_;
			} else {
				_tmp1488_ = FALSE;
			}
			if (_tmp1488_) {
				ValaMethod* _tmp1495_;
				gchar* _tmp1496_;
				gchar* _tmp1497_;
				_tmp1495_ = m;
				_tmp1496_ = vala_get_ccode_sentinel (_tmp1495_);
				_tmp1497_ = _tmp1496_;
				_tmp1487_ = g_strcmp0 (_tmp1497_, "") != 0;
				_g_free0 (_tmp1497_);
			} else {
				_tmp1487_ = FALSE;
			}
			if (_tmp1487_) {
				gboolean _tmp1498_;
				gboolean _tmp1499_;
				_tmp1498_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1499_ = _tmp1498_;
				_tmp1486_ = !_tmp1499_;
			} else {
				_tmp1486_ = FALSE;
			}
			if (_tmp1486_) {
				ValaHashMap* _tmp1500_;
				ValaMethod* _tmp1501_;
				gchar* _tmp1502_;
				gchar* _tmp1503_;
				ValaCCodeConstant* _tmp1504_;
				ValaCCodeConstant* _tmp1505_;
				_tmp1500_ = in_arg_map;
				_tmp1501_ = m;
				_tmp1502_ = vala_get_ccode_sentinel (_tmp1501_);
				_tmp1503_ = _tmp1502_;
				_tmp1504_ = vala_ccode_constant_new (_tmp1503_);
				_tmp1505_ = _tmp1504_;
				vala_map_set ((ValaMap*) _tmp1500_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1505_);
				_vala_ccode_node_unref0 (_tmp1505_);
				_g_free0 (_tmp1503_);
			}
		}
	}
	_tmp1506_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1506_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1507_;
		ValaDelegateType* _tmp1508_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1509_;
		ValaDelegate* _tmp1510_;
		ValaDelegate* _tmp1511_;
		ValaDelegate* _tmp1512_;
		ValaDelegate* _tmp1513_;
		gboolean _tmp1514_;
		gboolean _tmp1515_;
		_tmp1507_ = itype;
		_tmp1508_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1507_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1508_;
		_tmp1509_ = deleg_type;
		_tmp1510_ = vala_delegate_type_get_delegate_symbol (_tmp1509_);
		_tmp1511_ = _tmp1510_;
		_tmp1512_ = _vala_code_node_ref0 (_tmp1511_);
		d = _tmp1512_;
		_tmp1513_ = d;
		_tmp1514_ = vala_delegate_get_has_target (_tmp1513_);
		_tmp1515_ = _tmp1514_;
		if (_tmp1515_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1516_;
			ValaDelegate* _tmp1517_;
			ValaExpression* _tmp1518_;
			ValaExpression* _tmp1519_;
			ValaCCodeExpression* _tmp1520_ = NULL;
			ValaCCodeExpression* _tmp1521_;
			ValaCCodeExpression* _tmp1522_;
			ValaHashMap* _tmp1523_;
			ValaDelegate* _tmp1524_;
			ValaExpression* _tmp1525_;
			ValaExpression* _tmp1526_;
			ValaCCodeExpression* _tmp1527_ = NULL;
			ValaCCodeExpression* _tmp1528_;
			ValaCCodeExpression* _tmp1529_;
			_tmp1516_ = in_arg_map;
			_tmp1517_ = d;
			_tmp1518_ = vala_method_call_get_call (expr);
			_tmp1519_ = _tmp1518_;
			_tmp1521_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1519_, &_tmp1520_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1520_;
			_tmp1522_ = _tmp1521_;
			vala_map_set ((ValaMap*) _tmp1516_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1517_), FALSE)), _tmp1522_);
			_vala_ccode_node_unref0 (_tmp1522_);
			_tmp1523_ = out_arg_map;
			_tmp1524_ = d;
			_tmp1525_ = vala_method_call_get_call (expr);
			_tmp1526_ = _tmp1525_;
			_tmp1528_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1526_, &_tmp1527_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1527_;
			_tmp1529_ = _tmp1528_;
			vala_map_set ((ValaMap*) _tmp1523_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1524_), FALSE)), _tmp1529_);
			_vala_ccode_node_unref0 (_tmp1529_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1530_ = itype;
	_tmp1531_ = vala_data_type_get_return_type (_tmp1530_);
	_tmp1532_ = _tmp1531_;
	_tmp1533_ = vala_data_type_is_real_non_null_struct_type (_tmp1532_);
	_vala_code_node_unref0 (_tmp1532_);
	return_result_via_out_param = _tmp1533_;
	_tmp1535_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1535_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1536_;
		ValaDataType* _tmp1537_;
		ValaDataType* _tmp1538_;
		_tmp1536_ = itype;
		_tmp1537_ = vala_data_type_get_return_type (_tmp1536_);
		_tmp1538_ = _tmp1537_;
		_tmp1534_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1538_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1538_);
	} else {
		_tmp1534_ = FALSE;
	}
	if (_tmp1534_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1539_;
		ValaSignal* _tmp1540_;
		ValaSignal* _tmp1541_;
		ValaSignal* _tmp1542_;
		gboolean _tmp1543_ = FALSE;
		gboolean _tmp1544_ = FALSE;
		ValaMemberAccess* _tmp1545_;
		_tmp1539_ = itype;
		_tmp1540_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1539_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1541_ = _tmp1540_;
		_tmp1542_ = _vala_code_node_ref0 (_tmp1541_);
		sig = _tmp1542_;
		_tmp1545_ = ma;
		if (_tmp1545_ != NULL) {
			ValaMemberAccess* _tmp1546_;
			ValaExpression* _tmp1547_;
			ValaExpression* _tmp1548_;
			_tmp1546_ = ma;
			_tmp1547_ = vala_member_access_get_inner (_tmp1546_);
			_tmp1548_ = _tmp1547_;
			_tmp1544_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1548_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1544_ = FALSE;
		}
		if (_tmp1544_) {
			ValaSignal* _tmp1549_;
			gboolean _tmp1550_;
			gboolean _tmp1551_;
			_tmp1549_ = sig;
			_tmp1550_ = vala_signal_get_is_virtual (_tmp1549_);
			_tmp1551_ = _tmp1550_;
			_tmp1543_ = _tmp1551_;
		} else {
			_tmp1543_ = FALSE;
		}
		if (_tmp1543_) {
		} else {
			gboolean _tmp1552_ = FALSE;
			ValaSignal* _tmp1553_;
			_tmp1553_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1553_)) {
				_tmp1552_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1554_;
				ValaSourceReference* _tmp1555_;
				ValaSourceReference* _tmp1556_;
				ValaSourceFile* _tmp1557_;
				ValaSourceFile* _tmp1558_;
				ValaSignal* _tmp1559_;
				ValaSourceReference* _tmp1560_;
				ValaSourceReference* _tmp1561_;
				ValaSourceFile* _tmp1562_;
				ValaSourceFile* _tmp1563_;
				_tmp1554_ = ma;
				_tmp1555_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1554_);
				_tmp1556_ = _tmp1555_;
				_tmp1557_ = vala_source_reference_get_file (_tmp1556_);
				_tmp1558_ = _tmp1557_;
				_tmp1559_ = sig;
				_tmp1560_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1559_);
				_tmp1561_ = _tmp1560_;
				_tmp1562_ = vala_source_reference_get_file (_tmp1561_);
				_tmp1563_ = _tmp1562_;
				_tmp1552_ = _tmp1558_ == _tmp1563_;
			}
			if (_tmp1552_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1564_ = async_call;
	_tmp1565_ = ccall;
	if (_tmp1564_ == _tmp1565_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	if (return_result_via_out_param) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1566_;
		ValaDataType* _tmp1567_;
		ValaDataType* _tmp1568_;
		ValaLocalVariable* _tmp1569_;
		ValaLocalVariable* _tmp1570_;
		ValaLocalVariable* _tmp1571_;
		const gchar* _tmp1572_;
		const gchar* _tmp1573_;
		ValaCCodeExpression* _tmp1574_;
		ValaLocalVariable* _tmp1575_;
		ValaHashMap* _tmp1576_;
		ValaCCodeExpression* _tmp1577_;
		ValaCCodeUnaryExpression* _tmp1578_;
		ValaCCodeUnaryExpression* _tmp1579_;
		_tmp1566_ = itype;
		_tmp1567_ = vala_data_type_get_return_type (_tmp1566_);
		_tmp1568_ = _tmp1567_;
		_tmp1569_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1568_, TRUE, NULL, TRUE);
		_tmp1570_ = _tmp1569_;
		_vala_code_node_unref0 (_tmp1568_);
		out_param_var = _tmp1570_;
		_tmp1571_ = out_param_var;
		_tmp1572_ = vala_symbol_get_name ((ValaSymbol*) _tmp1571_);
		_tmp1573_ = _tmp1572_;
		_tmp1574_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1573_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1574_;
		_tmp1575_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1575_, FALSE);
		_tmp1576_ = out_arg_map;
		_tmp1577_ = out_param_ref;
		_tmp1578_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1577_);
		_tmp1579_ = _tmp1578_;
		vala_map_set ((ValaMap*) _tmp1576_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1579_);
		_vala_ccode_node_unref0 (_tmp1579_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1580_ = async_call;
	_tmp1581_ = ccall;
	if (_tmp1580_ != _tmp1581_) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1592_;
			ValaHashMap* _tmp1593_;
			gpointer _tmp1594_;
			ValaCCodeExpression* _tmp1595_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1582_;
				ValaSet* _tmp1583_;
				ValaSet* _tmp1584_;
				ValaIterator* _tmp1585_;
				ValaIterator* _tmp1586_;
				_tmp1582_ = out_arg_map;
				_tmp1583_ = vala_map_get_keys ((ValaMap*) _tmp1582_);
				_tmp1584_ = _tmp1583_;
				_tmp1585_ = vala_iterable_iterator ((ValaIterable*) _tmp1584_);
				_tmp1586_ = _tmp1585_;
				_vala_iterable_unref0 (_tmp1584_);
				_pos_it = _tmp1586_;
				while (TRUE) {
					ValaIterator* _tmp1587_;
					gint pos = 0;
					ValaIterator* _tmp1588_;
					gpointer _tmp1589_;
					gboolean _tmp1590_ = FALSE;
					_tmp1587_ = _pos_it;
					if (!vala_iterator_next (_tmp1587_)) {
						break;
					}
					_tmp1588_ = _pos_it;
					_tmp1589_ = vala_iterator_get (_tmp1588_);
					pos = (gint) ((gintptr) _tmp1589_);
					if (pos > last_pos) {
						gboolean _tmp1591_ = FALSE;
						if (min_pos == -1) {
							_tmp1591_ = TRUE;
						} else {
							_tmp1591_ = pos < min_pos;
						}
						_tmp1590_ = _tmp1591_;
					} else {
						_tmp1590_ = FALSE;
					}
					if (_tmp1590_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1592_ = ccall;
			_tmp1593_ = out_arg_map;
			_tmp1594_ = vala_map_get ((ValaMap*) _tmp1593_, (gpointer) ((gintptr) min_pos));
			_tmp1595_ = (ValaCCodeExpression*) _tmp1594_;
			vala_ccode_function_call_add_argument (_tmp1592_, _tmp1595_);
			_vala_ccode_node_unref0 (_tmp1595_);
			last_pos = min_pos;
		}
	}
	_tmp1596_ = async_call;
	if (_tmp1596_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			ValaCCodeFunctionCall* _tmp1607_;
			ValaHashMap* _tmp1608_;
			gpointer _tmp1609_;
			ValaCCodeExpression* _tmp1610_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1597_;
				ValaSet* _tmp1598_;
				ValaSet* _tmp1599_;
				ValaIterator* _tmp1600_;
				ValaIterator* _tmp1601_;
				_tmp1597_ = in_arg_map;
				_tmp1598_ = vala_map_get_keys ((ValaMap*) _tmp1597_);
				_tmp1599_ = _tmp1598_;
				_tmp1600_ = vala_iterable_iterator ((ValaIterable*) _tmp1599_);
				_tmp1601_ = _tmp1600_;
				_vala_iterable_unref0 (_tmp1599_);
				_pos_it = _tmp1601_;
				while (TRUE) {
					ValaIterator* _tmp1602_;
					gint pos = 0;
					ValaIterator* _tmp1603_;
					gpointer _tmp1604_;
					gboolean _tmp1605_ = FALSE;
					_tmp1602_ = _pos_it;
					if (!vala_iterator_next (_tmp1602_)) {
						break;
					}
					_tmp1603_ = _pos_it;
					_tmp1604_ = vala_iterator_get (_tmp1603_);
					pos = (gint) ((gintptr) _tmp1604_);
					if (pos > last_pos) {
						gboolean _tmp1606_ = FALSE;
						if (min_pos == -1) {
							_tmp1606_ = TRUE;
						} else {
							_tmp1606_ = pos < min_pos;
						}
						_tmp1605_ = _tmp1606_;
					} else {
						_tmp1605_ = FALSE;
					}
					if (_tmp1605_) {
						min_pos = pos;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			if (min_pos == -1) {
				break;
			}
			_tmp1607_ = async_call;
			_tmp1608_ = in_arg_map;
			_tmp1609_ = vala_map_get ((ValaMap*) _tmp1608_, (gpointer) ((gintptr) min_pos));
			_tmp1610_ = (ValaCCodeExpression*) _tmp1609_;
			vala_ccode_function_call_add_argument (_tmp1607_, _tmp1610_);
			_vala_ccode_node_unref0 (_tmp1610_);
			last_pos = min_pos;
		}
	}
	_tmp1611_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1612_ = _tmp1611_;
	if (_tmp1612_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1613_;
		gint _tmp1614_;
		ValaCCodeFunction* _tmp1615_;
		ValaCCodeFunction* _tmp1616_;
		ValaCCodeIdentifier* _tmp1617_;
		ValaCCodeIdentifier* _tmp1618_;
		ValaCCodeMemberAccess* _tmp1619_;
		ValaCCodeMemberAccess* _tmp1620_;
		gchar* _tmp1621_;
		gchar* _tmp1622_;
		ValaCCodeConstant* _tmp1623_;
		ValaCCodeConstant* _tmp1624_;
		ValaCCodeFunction* _tmp1625_;
		ValaCCodeFunction* _tmp1626_;
		ValaCCodeFunctionCall* _tmp1627_;
		ValaCCodeFunction* _tmp1628_;
		ValaCCodeFunction* _tmp1629_;
		ValaCCodeConstant* _tmp1630_;
		ValaCCodeConstant* _tmp1631_;
		ValaCCodeFunction* _tmp1632_;
		ValaCCodeFunction* _tmp1633_;
		gchar* _tmp1634_;
		gchar* _tmp1635_;
		_tmp1613_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1614_ = _tmp1613_->next_coroutine_state;
		_tmp1613_->next_coroutine_state = _tmp1614_ + 1;
		state = _tmp1614_;
		_tmp1615_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1616_ = _tmp1615_;
		_tmp1617_ = vala_ccode_identifier_new ("_data_");
		_tmp1618_ = _tmp1617_;
		_tmp1619_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1618_, "_state_");
		_tmp1620_ = _tmp1619_;
		_tmp1621_ = g_strdup_printf ("%i", state);
		_tmp1622_ = _tmp1621_;
		_tmp1623_ = vala_ccode_constant_new (_tmp1622_);
		_tmp1624_ = _tmp1623_;
		vala_ccode_function_add_assignment (_tmp1616_, (ValaCCodeExpression*) _tmp1620_, (ValaCCodeExpression*) _tmp1624_);
		_vala_ccode_node_unref0 (_tmp1624_);
		_g_free0 (_tmp1622_);
		_vala_ccode_node_unref0 (_tmp1620_);
		_vala_ccode_node_unref0 (_tmp1618_);
		_tmp1625_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1626_ = _tmp1625_;
		_tmp1627_ = async_call;
		vala_ccode_function_add_expression (_tmp1626_, (ValaCCodeExpression*) _tmp1627_);
		_tmp1628_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1629_ = _tmp1628_;
		_tmp1630_ = vala_ccode_constant_new ("FALSE");
		_tmp1631_ = _tmp1630_;
		vala_ccode_function_add_return (_tmp1629_, (ValaCCodeExpression*) _tmp1631_);
		_vala_ccode_node_unref0 (_tmp1631_);
		_tmp1632_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1633_ = _tmp1632_;
		_tmp1634_ = g_strdup_printf ("_state_%d", state);
		_tmp1635_ = _tmp1634_;
		vala_ccode_function_add_label (_tmp1633_, _tmp1635_);
		_g_free0 (_tmp1635_);
	}
	_tmp1636_ = vala_method_call_get_is_assert (expr);
	_tmp1637_ = _tmp1636_;
	if (_tmp1637_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1638_;
		ValaSourceReference* _tmp1639_;
		ValaSourceLocation _tmp1640_ = {0};
		ValaSourceLocation _tmp1641_;
		gchar* _tmp1642_;
		ValaSourceReference* _tmp1643_;
		ValaSourceReference* _tmp1644_;
		ValaSourceLocation _tmp1645_ = {0};
		ValaSourceLocation _tmp1646_;
		gchar* _tmp1647_;
		ValaSourceReference* _tmp1648_;
		ValaSourceReference* _tmp1649_;
		ValaSourceLocation _tmp1650_ = {0};
		ValaSourceLocation _tmp1651_;
		gchar* _tmp1652_;
		gchar* _tmp1653_;
		ValaCCodeFunctionCall* _tmp1654_;
		ValaCCodeIdentifier* _tmp1655_;
		ValaCCodeIdentifier* _tmp1656_;
		ValaCCodeFunctionCall* _tmp1657_;
		const gchar* _tmp1658_;
		gchar* _tmp1659_;
		gchar* _tmp1660_;
		gchar* _tmp1661_;
		gchar* _tmp1662_;
		gchar* _tmp1663_;
		gchar* _tmp1664_;
		ValaCCodeConstant* _tmp1665_;
		ValaCCodeConstant* _tmp1666_;
		_tmp1638_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1639_ = _tmp1638_;
		vala_source_reference_get_begin (_tmp1639_, &_tmp1640_);
		_tmp1641_ = _tmp1640_;
		_tmp1642_ = _tmp1641_.pos;
		_tmp1643_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1644_ = _tmp1643_;
		vala_source_reference_get_end (_tmp1644_, &_tmp1645_);
		_tmp1646_ = _tmp1645_;
		_tmp1647_ = _tmp1646_.pos;
		_tmp1648_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1649_ = _tmp1648_;
		vala_source_reference_get_begin (_tmp1649_, &_tmp1650_);
		_tmp1651_ = _tmp1650_;
		_tmp1652_ = _tmp1651_.pos;
		_tmp1653_ = string_substring ((const gchar*) _tmp1642_, (glong) 0, (glong) ((gint) (_tmp1647_ - _tmp1652_)));
		message = _tmp1653_;
		_tmp1654_ = ccall;
		_tmp1655_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1656_ = _tmp1655_;
		vala_ccode_function_call_set_call (_tmp1654_, (ValaCCodeExpression*) _tmp1656_);
		_vala_ccode_node_unref0 (_tmp1656_);
		_tmp1657_ = ccall;
		_tmp1658_ = message;
		_tmp1659_ = string_replace (_tmp1658_, "\n", " ");
		_tmp1660_ = _tmp1659_;
		_tmp1661_ = g_strescape (_tmp1660_, "");
		_tmp1662_ = _tmp1661_;
		_tmp1663_ = g_strdup_printf ("\"%s\"", _tmp1662_);
		_tmp1664_ = _tmp1663_;
		_tmp1665_ = vala_ccode_constant_new (_tmp1664_);
		_tmp1666_ = _tmp1665_;
		vala_ccode_function_call_add_argument (_tmp1657_, (ValaCCodeExpression*) _tmp1666_);
		_vala_ccode_node_unref0 (_tmp1666_);
		_g_free0 (_tmp1664_);
		_g_free0 (_tmp1662_);
		_g_free0 (_tmp1660_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	if (return_result_via_out_param) {
		ValaCCodeFunction* _tmp1667_;
		ValaCCodeFunction* _tmp1668_;
		ValaCCodeExpression* _tmp1669_;
		ValaCCodeExpression* _tmp1670_;
		ValaCCodeExpression* _tmp1671_;
		_tmp1667_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1668_ = _tmp1667_;
		_tmp1669_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1668_, _tmp1669_);
		_tmp1670_ = out_param_ref;
		_tmp1671_ = _vala_ccode_node_ref0 (_tmp1670_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1671_;
	}
	_tmp1674_ = m;
	if (_tmp1674_ != NULL) {
		ValaMethod* _tmp1675_;
		ValaMemberBinding _tmp1676_;
		ValaMemberBinding _tmp1677_;
		_tmp1675_ = m;
		_tmp1676_ = vala_method_get_binding (_tmp1675_);
		_tmp1677_ = _tmp1676_;
		_tmp1673_ = _tmp1677_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1673_ = FALSE;
	}
	if (_tmp1673_) {
		ValaMethod* _tmp1678_;
		gboolean _tmp1679_;
		gboolean _tmp1680_;
		_tmp1678_ = m;
		_tmp1679_ = vala_method_get_returns_modified_pointer (_tmp1678_);
		_tmp1680_ = _tmp1679_;
		_tmp1672_ = _tmp1680_;
	} else {
		_tmp1672_ = FALSE;
	}
	if (_tmp1672_) {
		gboolean _tmp1681_ = FALSE;
		gboolean _tmp1682_ = FALSE;
		ValaMemberAccess* _tmp1683_;
		_tmp1683_ = ma;
		if (_tmp1683_ != NULL) {
			ValaMemberAccess* _tmp1684_;
			ValaExpression* _tmp1685_;
			ValaExpression* _tmp1686_;
			ValaSymbol* _tmp1687_;
			ValaSymbol* _tmp1688_;
			_tmp1684_ = ma;
			_tmp1685_ = vala_member_access_get_inner (_tmp1684_);
			_tmp1686_ = _tmp1685_;
			_tmp1687_ = vala_expression_get_symbol_reference (_tmp1686_);
			_tmp1688_ = _tmp1687_;
			_tmp1682_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1688_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1682_ = FALSE;
		}
		if (_tmp1682_) {
			ValaMemberAccess* _tmp1689_;
			ValaExpression* _tmp1690_;
			ValaExpression* _tmp1691_;
			_tmp1689_ = ma;
			_tmp1690_ = vala_member_access_get_inner (_tmp1689_);
			_tmp1691_ = _tmp1690_;
			_tmp1681_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1691_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1681_ = FALSE;
		}
		if (_tmp1681_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1692_;
			ValaExpression* _tmp1693_;
			ValaExpression* _tmp1694_;
			ValaSymbol* _tmp1695_;
			ValaSymbol* _tmp1696_;
			ValaProperty* _tmp1697_;
			ValaProperty* _tmp1698_;
			ValaMemberAccess* _tmp1699_;
			ValaExpression* _tmp1700_;
			ValaExpression* _tmp1701_;
			ValaExpression* _tmp1702_;
			ValaExpression* _tmp1703_;
			ValaDataType* _tmp1704_;
			ValaDataType* _tmp1705_;
			ValaCCodeExpression* _tmp1706_;
			ValaGLibValue* _tmp1707_;
			ValaGLibValue* _tmp1708_;
			_tmp1692_ = ma;
			_tmp1693_ = vala_member_access_get_inner (_tmp1692_);
			_tmp1694_ = _tmp1693_;
			_tmp1695_ = vala_expression_get_symbol_reference (_tmp1694_);
			_tmp1696_ = _tmp1695_;
			_tmp1697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1696_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1697_;
			_tmp1698_ = prop;
			_tmp1699_ = ma;
			_tmp1700_ = vala_member_access_get_inner (_tmp1699_);
			_tmp1701_ = _tmp1700_;
			_tmp1702_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1701_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1703_ = _tmp1702_;
			_tmp1704_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1705_ = _tmp1704_;
			_tmp1706_ = ccall_expr;
			_tmp1707_ = vala_glib_value_new (_tmp1705_, _tmp1706_, FALSE);
			_tmp1708_ = _tmp1707_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1698_, _tmp1703_, (ValaTargetValue*) _tmp1708_);
			_vala_target_value_unref0 (_tmp1708_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1709_;
			ValaCCodeExpression* _tmp1710_;
			ValaCCodeAssignment* _tmp1711_;
			_tmp1709_ = instance;
			_tmp1710_ = ccall_expr;
			_tmp1711_ = vala_ccode_assignment_new (_tmp1709_, _tmp1710_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1711_;
		}
	}
	_tmp1714_ = m;
	if (_tmp1714_ != NULL) {
		ValaMethod* _tmp1715_;
		gchar* _tmp1716_;
		gchar* _tmp1717_;
		_tmp1715_ = m;
		_tmp1716_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1715_);
		_tmp1717_ = _tmp1716_;
		_tmp1713_ = _tmp1717_ != NULL;
		_g_free0 (_tmp1717_);
	} else {
		_tmp1713_ = FALSE;
	}
	if (_tmp1713_) {
		ValaMethod* _tmp1718_;
		gchar* _tmp1719_;
		gchar* _tmp1720_;
		ValaMethod* _tmp1721_;
		ValaDataType* _tmp1722_;
		ValaDataType* _tmp1723_;
		gchar* _tmp1724_;
		gchar* _tmp1725_;
		_tmp1718_ = m;
		_tmp1719_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1718_);
		_tmp1720_ = _tmp1719_;
		_tmp1721_ = m;
		_tmp1722_ = vala_callable_get_return_type ((ValaCallable*) _tmp1721_);
		_tmp1723_ = _tmp1722_;
		_tmp1724_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1723_);
		_tmp1725_ = _tmp1724_;
		_tmp1712_ = g_strcmp0 (_tmp1720_, _tmp1725_) != 0;
		_g_free0 (_tmp1725_);
		_g_free0 (_tmp1720_);
	} else {
		_tmp1712_ = FALSE;
	}
	if (_tmp1712_) {
		ValaCCodeExpression* _tmp1726_;
		ValaMethod* _tmp1727_;
		ValaDataType* _tmp1728_;
		ValaDataType* _tmp1729_;
		gchar* _tmp1730_;
		gchar* _tmp1731_;
		ValaCCodeCastExpression* _tmp1732_;
		_tmp1726_ = ccall_expr;
		_tmp1727_ = m;
		_tmp1728_ = vala_callable_get_return_type ((ValaCallable*) _tmp1727_);
		_tmp1729_ = _tmp1728_;
		_tmp1730_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1729_);
		_tmp1731_ = _tmp1730_;
		_tmp1732_ = vala_ccode_cast_expression_new (_tmp1726_, _tmp1731_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1732_;
		_g_free0 (_tmp1731_);
	}
	_tmp1733_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1733_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1734_;
		ValaList* _tmp1735_;
		ValaIterator* _tmp1736_;
		ValaIterator* _tmp1737_;
		ValaIterator* _tmp1738_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1739_;
		gpointer _tmp1740_;
		ValaExpression* _tmp1741_;
		ValaCCodeExpression* _tmp1742_;
		ValaCCodeExpression* _tmp1743_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1744_;
		ValaLocalVariable* _tmp1745_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1746_;
		const gchar* _tmp1747_;
		const gchar* _tmp1748_;
		ValaCCodeExpression* _tmp1749_;
		ValaLocalVariable* _tmp1750_;
		ValaCCodeFile* _tmp1751_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1752_;
		ValaExpression* _tmp1753_;
		ValaExpression* _tmp1754_;
		ValaCCodeExpression* _tmp1755_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1756_;
		ValaExpression* _tmp1757_;
		ValaExpression* _tmp1758_;
		ValaCCodeExpression* _tmp1759_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1760_;
		ValaExpression* _tmp1761_;
		ValaExpression* _tmp1762_;
		ValaDataType* _tmp1763_;
		ValaDataType* _tmp1764_;
		ValaArrayType* _tmp1765_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1766_;
		ValaDataType* _tmp1767_;
		ValaDataType* _tmp1768_;
		gchar* _tmp1769_;
		gchar* _tmp1770_;
		gchar* _tmp1771_;
		gchar* _tmp1772_;
		ValaCCodeIdentifier* _tmp1773_;
		ValaCCodeIdentifier* _tmp1774_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1775_;
		ValaCCodeExpression* _tmp1776_;
		ValaCCodeBinaryExpression* _tmp1777_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1778_;
		ValaCCodeExpression* _tmp1779_;
		ValaCCodeBinaryExpression* _tmp1780_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1781_;
		ValaCCodeIdentifier* _tmp1782_;
		ValaCCodeFunctionCall* _tmp1783_;
		ValaCCodeFunctionCall* _tmp1784_;
		ValaCCodeFunctionCall* _tmp1785_;
		ValaCCodeExpression* _tmp1786_;
		ValaCCodeExpression* _tmp1787_;
		ValaCCodeBinaryExpression* _tmp1788_;
		ValaCCodeBinaryExpression* _tmp1789_;
		ValaCCodeFunctionCall* _tmp1790_;
		ValaCCodeConstant* _tmp1791_;
		ValaCCodeConstant* _tmp1792_;
		ValaCCodeFunctionCall* _tmp1793_;
		ValaCCodeIdentifier* _tmp1794_;
		ValaCCodeBinaryExpression* _tmp1795_;
		ValaCCodeBinaryExpression* _tmp1796_;
		ValaCCodeBinaryExpression* _tmp1797_;
		ValaCCodeFunction* _tmp1798_;
		ValaCCodeFunction* _tmp1799_;
		ValaCCodeExpression* _tmp1800_;
		ValaCCodeExpression* _tmp1801_;
		ValaCCodeFunction* _tmp1802_;
		ValaCCodeFunction* _tmp1803_;
		ValaCCodeExpression* _tmp1804_;
		ValaCCodeFunction* _tmp1805_;
		ValaCCodeFunction* _tmp1806_;
		ValaCCodeBinaryExpression* _tmp1807_;
		ValaCCodeFunctionCall* _tmp1808_;
		ValaCCodeConstant* _tmp1809_;
		ValaCCodeConstant* _tmp1810_;
		ValaCCodeConditionalExpression* _tmp1811_;
		ValaCCodeConditionalExpression* _tmp1812_;
		ValaCCodeFunction* _tmp1813_;
		ValaCCodeFunction* _tmp1814_;
		ValaMemberAccess* _tmp1815_;
		ValaExpression* _tmp1816_;
		ValaExpression* _tmp1817_;
		ValaCCodeExpression* _tmp1818_;
		ValaCCodeExpression* _tmp1819_;
		ValaCCodeExpression* _tmp1820_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1821_;
		ValaExpression* _tmp1822_;
		ValaExpression* _tmp1823_;
		ValaSymbol* _tmp1824_;
		ValaSymbol* _tmp1825_;
		ValaSymbol* _tmp1826_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1827_;
		ValaLocalVariable* _tmp1828_;
		gboolean _tmp1829_ = FALSE;
		gboolean _tmp1830_ = FALSE;
		ValaSymbol* _tmp1831_;
		_tmp1734_ = vala_method_call_get_argument_list (expr);
		_tmp1735_ = _tmp1734_;
		_tmp1736_ = vala_iterable_iterator ((ValaIterable*) _tmp1735_);
		_tmp1737_ = _tmp1736_;
		_vala_iterable_unref0 (_tmp1735_);
		arg_it = _tmp1737_;
		_tmp1738_ = arg_it;
		vala_iterator_next (_tmp1738_);
		_tmp1739_ = arg_it;
		_tmp1740_ = vala_iterator_get (_tmp1739_);
		_tmp1741_ = (ValaExpression*) _tmp1740_;
		_tmp1742_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1741_);
		_tmp1743_ = _tmp1742_;
		_vala_code_node_unref0 (_tmp1741_);
		new_size = _tmp1743_;
		_tmp1744_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1745_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1744_, TRUE, NULL, FALSE);
		temp_decl = _tmp1745_;
		_tmp1746_ = temp_decl;
		_tmp1747_ = vala_symbol_get_name ((ValaSymbol*) _tmp1746_);
		_tmp1748_ = _tmp1747_;
		_tmp1749_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1748_);
		temp_ref = _tmp1749_;
		_tmp1750_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1750_, FALSE);
		_tmp1751_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1751_, "string.h", FALSE);
		_tmp1752_ = ma;
		_tmp1753_ = vala_member_access_get_inner (_tmp1752_);
		_tmp1754_ = _tmp1753_;
		_tmp1755_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1754_, 1);
		clen = _tmp1755_;
		_tmp1756_ = ma;
		_tmp1757_ = vala_member_access_get_inner (_tmp1756_);
		_tmp1758_ = _tmp1757_;
		_tmp1759_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1758_);
		celems = _tmp1759_;
		_tmp1760_ = ma;
		_tmp1761_ = vala_member_access_get_inner (_tmp1760_);
		_tmp1762_ = _tmp1761_;
		_tmp1763_ = vala_expression_get_value_type (_tmp1762_);
		_tmp1764_ = _tmp1763_;
		_tmp1765_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1764_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1765_;
		_tmp1766_ = array_type;
		_tmp1767_ = vala_array_type_get_element_type (_tmp1766_);
		_tmp1768_ = _tmp1767_;
		_tmp1769_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1768_);
		_tmp1770_ = _tmp1769_;
		_tmp1771_ = g_strdup_printf ("sizeof (%s)", _tmp1770_);
		_tmp1772_ = _tmp1771_;
		_tmp1773_ = vala_ccode_identifier_new (_tmp1772_);
		_tmp1774_ = _tmp1773_;
		_g_free0 (_tmp1772_);
		_g_free0 (_tmp1770_);
		csizeof = _tmp1774_;
		_tmp1775_ = temp_ref;
		_tmp1776_ = clen;
		_tmp1777_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1775_, _tmp1776_);
		cdelta = _tmp1777_;
		_tmp1778_ = temp_ref;
		_tmp1779_ = clen;
		_tmp1780_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1778_, _tmp1779_);
		ccheck = _tmp1780_;
		_tmp1781_ = vala_ccode_identifier_new ("memset");
		_tmp1782_ = _tmp1781_;
		_tmp1783_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1782_);
		_tmp1784_ = _tmp1783_;
		_vala_ccode_node_unref0 (_tmp1782_);
		czero = _tmp1784_;
		_tmp1785_ = czero;
		_tmp1786_ = celems;
		_tmp1787_ = clen;
		_tmp1788_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1786_, _tmp1787_);
		_tmp1789_ = _tmp1788_;
		vala_ccode_function_call_add_argument (_tmp1785_, (ValaCCodeExpression*) _tmp1789_);
		_vala_ccode_node_unref0 (_tmp1789_);
		_tmp1790_ = czero;
		_tmp1791_ = vala_ccode_constant_new ("0");
		_tmp1792_ = _tmp1791_;
		vala_ccode_function_call_add_argument (_tmp1790_, (ValaCCodeExpression*) _tmp1792_);
		_vala_ccode_node_unref0 (_tmp1792_);
		_tmp1793_ = czero;
		_tmp1794_ = csizeof;
		_tmp1795_ = cdelta;
		_tmp1796_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1794_, (ValaCCodeExpression*) _tmp1795_);
		_tmp1797_ = _tmp1796_;
		vala_ccode_function_call_add_argument (_tmp1793_, (ValaCCodeExpression*) _tmp1797_);
		_vala_ccode_node_unref0 (_tmp1797_);
		_tmp1798_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1799_ = _tmp1798_;
		_tmp1800_ = temp_ref;
		_tmp1801_ = new_size;
		vala_ccode_function_add_assignment (_tmp1799_, _tmp1800_, _tmp1801_);
		_tmp1802_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1803_ = _tmp1802_;
		_tmp1804_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1803_, _tmp1804_);
		_tmp1805_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1806_ = _tmp1805_;
		_tmp1807_ = ccheck;
		_tmp1808_ = czero;
		_tmp1809_ = vala_ccode_constant_new ("NULL");
		_tmp1810_ = _tmp1809_;
		_tmp1811_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1807_, (ValaCCodeExpression*) _tmp1808_, (ValaCCodeExpression*) _tmp1810_);
		_tmp1812_ = _tmp1811_;
		vala_ccode_function_add_expression (_tmp1806_, (ValaCCodeExpression*) _tmp1812_);
		_vala_ccode_node_unref0 (_tmp1812_);
		_vala_ccode_node_unref0 (_tmp1810_);
		_tmp1813_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1814_ = _tmp1813_;
		_tmp1815_ = ma;
		_tmp1816_ = vala_member_access_get_inner (_tmp1815_);
		_tmp1817_ = _tmp1816_;
		_tmp1818_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1817_, 1);
		_tmp1819_ = _tmp1818_;
		_tmp1820_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1814_, _tmp1819_, _tmp1820_);
		_vala_ccode_node_unref0 (_tmp1819_);
		_tmp1821_ = ma;
		_tmp1822_ = vala_member_access_get_inner (_tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1824_ = vala_expression_get_symbol_reference (_tmp1823_);
		_tmp1825_ = _tmp1824_;
		_tmp1826_ = _vala_code_node_ref0 (_tmp1825_);
		array_var = _tmp1826_;
		_tmp1827_ = array_var;
		_tmp1828_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1827_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1827_) : NULL);
		array_local = _tmp1828_;
		_tmp1831_ = array_var;
		if (_tmp1831_ != NULL) {
			ValaSymbol* _tmp1832_;
			_tmp1832_ = array_var;
			_tmp1830_ = vala_symbol_is_internal_symbol (_tmp1832_);
		} else {
			_tmp1830_ = FALSE;
		}
		if (_tmp1830_) {
			gboolean _tmp1833_ = FALSE;
			gboolean _tmp1834_ = FALSE;
			ValaSymbol* _tmp1835_;
			_tmp1835_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1835_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1836_;
				gboolean _tmp1837_;
				gboolean _tmp1838_;
				_tmp1836_ = array_local;
				_tmp1837_ = vala_local_variable_get_captured (_tmp1836_);
				_tmp1838_ = _tmp1837_;
				_tmp1834_ = !_tmp1838_;
			} else {
				_tmp1834_ = FALSE;
			}
			if (_tmp1834_) {
				_tmp1833_ = TRUE;
			} else {
				ValaSymbol* _tmp1839_;
				_tmp1839_ = array_var;
				_tmp1833_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1839_, VALA_TYPE_FIELD);
			}
			_tmp1829_ = _tmp1833_;
		} else {
			_tmp1829_ = FALSE;
		}
		if (_tmp1829_) {
			ValaCCodeFunction* _tmp1840_;
			ValaCCodeFunction* _tmp1841_;
			ValaMemberAccess* _tmp1842_;
			ValaExpression* _tmp1843_;
			ValaExpression* _tmp1844_;
			ValaTargetValue* _tmp1845_;
			ValaTargetValue* _tmp1846_;
			ValaCCodeExpression* _tmp1847_;
			ValaCCodeExpression* _tmp1848_;
			ValaCCodeExpression* _tmp1849_;
			_tmp1840_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1841_ = _tmp1840_;
			_tmp1842_ = ma;
			_tmp1843_ = vala_member_access_get_inner (_tmp1842_);
			_tmp1844_ = _tmp1843_;
			_tmp1845_ = vala_expression_get_target_value (_tmp1844_);
			_tmp1846_ = _tmp1845_;
			_tmp1847_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1846_);
			_tmp1848_ = _tmp1847_;
			_tmp1849_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1841_, _tmp1848_, _tmp1849_);
			_vala_ccode_node_unref0 (_tmp1848_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1851_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1852_ = _tmp1851_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1852_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1853_;
		ValaDataType* _tmp1854_;
		_tmp1853_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1854_ = _tmp1853_;
		_tmp1850_ = !vala_data_type_is_disposable (_tmp1854_);
	} else {
		_tmp1850_ = FALSE;
	}
	if (_tmp1850_) {
		gboolean _tmp1855_ = FALSE;
		ValaCCodeExpression* _tmp1856_;
		_tmp1856_ = ccall_expr;
		if (_tmp1856_ != NULL) {
			_tmp1855_ = !return_result_via_out_param;
		} else {
			_tmp1855_ = FALSE;
		}
		if (_tmp1855_) {
			ValaCCodeFunction* _tmp1857_;
			ValaCCodeFunction* _tmp1858_;
			ValaCCodeExpression* _tmp1859_;
			_tmp1857_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1858_ = _tmp1857_;
			_tmp1859_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1858_, _tmp1859_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1860_;
		ValaDataType* _tmp1861_;
		gboolean _tmp1862_ = FALSE;
		ValaDataType* _tmp1863_;
		ValaDataType* _tmp1864_;
		gboolean _tmp1891_ = FALSE;
		ValaMethod* _tmp1892_;
		_tmp1860_ = itype;
		_tmp1861_ = vala_data_type_get_return_type (_tmp1860_);
		result_type = _tmp1861_;
		_tmp1863_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1864_ = _tmp1863_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1864_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1865_;
			ValaDataType* _tmp1866_;
			_tmp1865_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1866_ = _tmp1865_;
			_tmp1862_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1866_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1862_ = FALSE;
		}
		if (_tmp1862_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1867_;
			ValaDataType* _tmp1868_;
			ValaTypeParameter* _tmp1869_;
			ValaTypeParameter* _tmp1870_;
			ValaTypeParameter* _tmp1871_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1872_;
			ValaSymbol* _tmp1873_;
			ValaSymbol* _tmp1874_;
			ValaSymbol* _tmp1875_;
			ValaSymbol* _tmp1876_;
			ValaStruct* _tmp1877_;
			gboolean _tmp1878_ = FALSE;
			ValaTypeParameter* _tmp1879_;
			ValaSymbol* _tmp1880_;
			ValaSymbol* _tmp1881_;
			ValaTypeSymbol* _tmp1882_;
			_tmp1867_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1868_ = _tmp1867_;
			_tmp1869_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1868_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1870_ = _tmp1869_;
			_tmp1871_ = _vala_code_node_ref0 (_tmp1870_);
			type_parameter = _tmp1871_;
			_tmp1872_ = type_parameter;
			_tmp1873_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1872_);
			_tmp1874_ = _tmp1873_;
			_tmp1875_ = vala_symbol_get_parent_symbol (_tmp1874_);
			_tmp1876_ = _tmp1875_;
			_tmp1877_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1876_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1876_) : NULL);
			st = _tmp1877_;
			_tmp1879_ = type_parameter;
			_tmp1880_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1879_);
			_tmp1881_ = _tmp1880_;
			_tmp1882_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1881_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1882_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1878_ = TRUE;
			} else {
				gboolean _tmp1883_ = FALSE;
				ValaStruct* _tmp1884_;
				_tmp1884_ = st;
				if (_tmp1884_ != NULL) {
					ValaStruct* _tmp1885_;
					gchar* _tmp1886_;
					gchar* _tmp1887_;
					_tmp1885_ = st;
					_tmp1886_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1885_);
					_tmp1887_ = _tmp1886_;
					_tmp1883_ = g_strcmp0 (_tmp1887_, "va_list") == 0;
					_g_free0 (_tmp1887_);
				} else {
					_tmp1883_ = FALSE;
				}
				_tmp1878_ = _tmp1883_;
			}
			if (_tmp1878_) {
				ValaDataType* _tmp1888_;
				ValaDataType* _tmp1889_;
				ValaDataType* _tmp1890_;
				_tmp1888_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1889_ = _tmp1888_;
				_tmp1890_ = _vala_code_node_ref0 (_tmp1889_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1890_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1892_ = m;
		if (_tmp1892_ != NULL) {
			ValaMethod* _tmp1893_;
			_tmp1893_ = m;
			_tmp1891_ = vala_method_get_format_arg_index (_tmp1893_) >= 0;
		} else {
			_tmp1891_ = FALSE;
		}
		if (_tmp1891_) {
			ValaCCodeExpression* _tmp1894_;
			_tmp1894_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1894_);
		} else {
			gboolean _tmp1895_ = FALSE;
			ValaMethod* _tmp1896_;
			_tmp1896_ = m;
			if (_tmp1896_ != NULL) {
				ValaMethod* _tmp1897_;
				_tmp1897_ = m;
				_tmp1895_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1897_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1895_ = FALSE;
			}
			if (_tmp1895_) {
				ValaCCodeExpression* _tmp1898_;
				_tmp1898_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1898_);
			} else {
				gboolean _tmp1899_ = FALSE;
				gboolean _tmp1900_ = FALSE;
				if (!return_result_via_out_param) {
					gboolean _tmp1901_ = FALSE;
					gboolean _tmp1902_ = FALSE;
					ValaMethod* _tmp1903_;
					_tmp1903_ = m;
					if (_tmp1903_ != NULL) {
						ValaMethod* _tmp1904_;
						_tmp1904_ = m;
						_tmp1902_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1904_);
					} else {
						_tmp1902_ = FALSE;
					}
					if (_tmp1902_) {
						_tmp1901_ = TRUE;
					} else {
						gboolean _tmp1905_ = FALSE;
						ValaDelegate* _tmp1906_;
						_tmp1906_ = deleg;
						if (_tmp1906_ != NULL) {
							ValaDelegate* _tmp1907_;
							_tmp1907_ = deleg;
							_tmp1905_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1907_);
						} else {
							_tmp1905_ = FALSE;
						}
						_tmp1901_ = _tmp1905_;
					}
					_tmp1900_ = _tmp1901_;
				} else {
					_tmp1900_ = FALSE;
				}
				if (_tmp1900_) {
					gboolean _tmp1908_ = FALSE;
					ValaDataType* _tmp1909_;
					_tmp1909_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1909_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1910_;
						_tmp1910_ = result_type;
						_tmp1908_ = !vala_data_type_is_disposable (_tmp1910_);
					} else {
						_tmp1908_ = FALSE;
					}
					_tmp1899_ = _tmp1908_;
				} else {
					_tmp1899_ = FALSE;
				}
				if (_tmp1899_) {
					ValaCCodeExpression* _tmp1911_;
					_tmp1911_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1911_);
				} else {
					if (!return_result_via_out_param) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1912_;
						ValaDataType* _tmp1913_;
						gboolean _tmp1914_;
						gboolean _tmp1915_;
						ValaLocalVariable* _tmp1916_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1917_;
						const gchar* _tmp1918_;
						const gchar* _tmp1919_;
						ValaCCodeExpression* _tmp1920_;
						ValaLocalVariable* _tmp1921_;
						ValaCCodeFunction* _tmp1922_;
						ValaCCodeFunction* _tmp1923_;
						ValaCCodeExpression* _tmp1924_;
						ValaCCodeExpression* _tmp1925_;
						ValaCCodeExpression* _tmp1926_;
						ValaTargetValue* _tmp1927_;
						ValaTargetValue* _tmp1928_;
						_tmp1912_ = result_type;
						_tmp1913_ = result_type;
						_tmp1914_ = vala_data_type_get_value_owned (_tmp1913_);
						_tmp1915_ = _tmp1914_;
						_tmp1916_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1912_, _tmp1915_, NULL, FALSE);
						temp_var = _tmp1916_;
						_tmp1917_ = temp_var;
						_tmp1918_ = vala_symbol_get_name ((ValaSymbol*) _tmp1917_);
						_tmp1919_ = _tmp1918_;
						_tmp1920_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1919_);
						temp_ref = _tmp1920_;
						_tmp1921_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1921_, FALSE);
						_tmp1922_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1923_ = _tmp1922_;
						_tmp1924_ = temp_ref;
						_tmp1925_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1923_, _tmp1924_, _tmp1925_);
						_tmp1926_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1926_);
						_tmp1927_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1928_ = _tmp1927_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1928_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1929_;
						ValaTargetValue* _tmp1930_;
						ValaTargetValue* _tmp1931_;
						_tmp1929_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1929_);
						_tmp1930_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1931_ = _tmp1930_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1931_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1932_ = params;
	_tmp1933_ = vala_iterable_iterator ((ValaIterable*) _tmp1932_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1933_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1934_;
		gint _arg_size = 0;
		ValaList* _tmp1935_;
		gint _tmp1936_;
		gint _tmp1937_;
		gint _arg_index = 0;
		_tmp1934_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1934_;
		_tmp1935_ = _arg_list;
		_tmp1936_ = vala_collection_get_size ((ValaCollection*) _tmp1935_);
		_tmp1937_ = _tmp1936_;
		_arg_size = _tmp1937_;
		_arg_index = -1;
		while (TRUE) {
			ValaExpression* arg = NULL;
			ValaList* _tmp1938_;
			gpointer _tmp1939_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp1940_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp1950_;
			ValaUnaryExpression* _tmp1951_;
			gboolean _tmp1952_ = FALSE;
			ValaUnaryExpression* _tmp1953_;
			ValaUnaryExpression* _tmp1957_;
			ValaExpression* _tmp1958_;
			ValaExpression* _tmp1959_;
			ValaDataType* _tmp1960_;
			ValaDataType* _tmp1961_;
			ValaUnaryExpression* _tmp1971_;
			ValaExpression* _tmp1972_;
			ValaExpression* _tmp1973_;
			ValaTargetValue* _tmp1974_;
			ValaTargetValue* _tmp1975_;
			ValaUnaryExpression* _tmp1976_;
			ValaTargetValue* _tmp1977_;
			ValaTargetValue* _tmp1978_;
			ValaUnaryExpression* _tmp1979_;
			ValaExpression* _tmp1980_;
			ValaExpression* _tmp1981_;
			ValaDataType* _tmp1982_;
			ValaDataType* _tmp1983_;
			ValaExpression* _tmp1984_;
			ValaTargetValue* _tmp1985_;
			ValaTargetValue* _tmp1986_;
			ValaSourceReference* _tmp1987_;
			ValaSourceReference* _tmp1988_;
			gboolean _tmp1989_ = FALSE;
			ValaParameter* _tmp1990_;
			_arg_index = _arg_index + 1;
			if (!(_arg_index < _arg_size)) {
				break;
			}
			_tmp1938_ = _arg_list;
			_tmp1939_ = vala_list_get (_tmp1938_, _arg_index);
			arg = (ValaExpression*) _tmp1939_;
			param = NULL;
			_tmp1940_ = params_it;
			if (vala_iterator_next (_tmp1940_)) {
				ValaIterator* _tmp1941_;
				gpointer _tmp1942_;
				gboolean _tmp1943_ = FALSE;
				ValaParameter* _tmp1944_;
				gboolean _tmp1945_;
				gboolean _tmp1946_;
				_tmp1941_ = params_it;
				_tmp1942_ = vala_iterator_get (_tmp1941_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp1942_;
				_tmp1944_ = param;
				_tmp1945_ = vala_parameter_get_params_array (_tmp1944_);
				_tmp1946_ = _tmp1945_;
				if (_tmp1946_) {
					_tmp1943_ = TRUE;
				} else {
					ValaParameter* _tmp1947_;
					gboolean _tmp1948_;
					gboolean _tmp1949_;
					_tmp1947_ = param;
					_tmp1948_ = vala_parameter_get_ellipsis (_tmp1947_);
					_tmp1949_ = _tmp1948_;
					_tmp1943_ = _tmp1949_;
				}
				if (_tmp1943_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp1950_ = arg;
			_tmp1951_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1950_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1950_) : NULL);
			unary = _tmp1951_;
			_tmp1953_ = unary;
			if (_tmp1953_ == NULL) {
				_tmp1952_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp1954_;
				ValaUnaryOperator _tmp1955_;
				ValaUnaryOperator _tmp1956_;
				_tmp1954_ = unary;
				_tmp1955_ = vala_unary_expression_get_operator (_tmp1954_);
				_tmp1956_ = _tmp1955_;
				_tmp1952_ = _tmp1956_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp1952_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp1957_ = unary;
			_tmp1958_ = vala_unary_expression_get_inner (_tmp1957_);
			_tmp1959_ = _tmp1958_;
			_tmp1960_ = vala_expression_get_value_type (_tmp1959_);
			_tmp1961_ = _tmp1960_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp1961_)) {
				ValaCCodeFunction* _tmp1962_;
				ValaCCodeFunction* _tmp1963_;
				ValaUnaryExpression* _tmp1964_;
				ValaExpression* _tmp1965_;
				ValaExpression* _tmp1966_;
				ValaTargetValue* _tmp1967_;
				ValaTargetValue* _tmp1968_;
				ValaCCodeExpression* _tmp1969_;
				ValaCCodeExpression* _tmp1970_;
				_tmp1962_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp1963_ = _tmp1962_;
				_tmp1964_ = unary;
				_tmp1965_ = vala_unary_expression_get_inner (_tmp1964_);
				_tmp1966_ = _tmp1965_;
				_tmp1967_ = vala_expression_get_target_value (_tmp1966_);
				_tmp1968_ = _tmp1967_;
				_tmp1969_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp1968_, FALSE);
				_tmp1970_ = _tmp1969_;
				vala_ccode_function_add_expression (_tmp1963_, _tmp1970_);
				_vala_ccode_node_unref0 (_tmp1970_);
			}
			_tmp1971_ = unary;
			_tmp1972_ = vala_unary_expression_get_inner (_tmp1971_);
			_tmp1973_ = _tmp1972_;
			_tmp1974_ = vala_expression_get_target_value (_tmp1973_);
			_tmp1975_ = _tmp1974_;
			_tmp1976_ = unary;
			_tmp1977_ = vala_expression_get_target_value ((ValaExpression*) _tmp1976_);
			_tmp1978_ = _tmp1977_;
			_tmp1979_ = unary;
			_tmp1980_ = vala_unary_expression_get_inner (_tmp1979_);
			_tmp1981_ = _tmp1980_;
			_tmp1982_ = vala_expression_get_value_type (_tmp1981_);
			_tmp1983_ = _tmp1982_;
			_tmp1984_ = arg;
			_tmp1985_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp1978_, _tmp1983_, (ValaCodeNode*) _tmp1984_);
			_tmp1986_ = _tmp1985_;
			_tmp1987_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp1988_ = _tmp1987_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp1975_, _tmp1986_, _tmp1988_);
			_vala_target_value_unref0 (_tmp1986_);
			_tmp1990_ = param;
			if (_tmp1990_ != NULL) {
				ValaParameter* _tmp1991_;
				_tmp1991_ = param;
				_tmp1989_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1991_);
			} else {
				_tmp1989_ = FALSE;
			}
			if (_tmp1989_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp1992_;
				ValaCCodeIdentifier* _tmp1993_;
				ValaCCodeFunctionCall* _tmp1994_;
				ValaCCodeFunctionCall* _tmp1995_;
				ValaCCodeFunctionCall* _tmp1996_;
				ValaUnaryExpression* _tmp1997_;
				ValaExpression* _tmp1998_;
				ValaExpression* _tmp1999_;
				ValaTargetValue* _tmp2000_;
				ValaTargetValue* _tmp2001_;
				ValaCCodeExpression* _tmp2002_;
				ValaCCodeExpression* _tmp2003_;
				ValaCCodeFunction* _tmp2004_;
				ValaCCodeFunction* _tmp2005_;
				ValaUnaryExpression* _tmp2006_;
				ValaExpression* _tmp2007_;
				ValaExpression* _tmp2008_;
				ValaTargetValue* _tmp2009_;
				ValaTargetValue* _tmp2010_;
				ValaCCodeExpression* _tmp2011_;
				ValaCCodeExpression* _tmp2012_;
				ValaCCodeFunctionCall* _tmp2013_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp1992_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp1993_ = _tmp1992_;
				_tmp1994_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1993_);
				_tmp1995_ = _tmp1994_;
				_vala_ccode_node_unref0 (_tmp1993_);
				len_call = _tmp1995_;
				_tmp1996_ = len_call;
				_tmp1997_ = unary;
				_tmp1998_ = vala_unary_expression_get_inner (_tmp1997_);
				_tmp1999_ = _tmp1998_;
				_tmp2000_ = vala_expression_get_target_value (_tmp1999_);
				_tmp2001_ = _tmp2000_;
				_tmp2002_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2001_);
				_tmp2003_ = _tmp2002_;
				vala_ccode_function_call_add_argument (_tmp1996_, _tmp2003_);
				_vala_ccode_node_unref0 (_tmp2003_);
				_tmp2004_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2005_ = _tmp2004_;
				_tmp2006_ = unary;
				_tmp2007_ = vala_unary_expression_get_inner (_tmp2006_);
				_tmp2008_ = _tmp2007_;
				_tmp2009_ = vala_expression_get_target_value (_tmp2008_);
				_tmp2010_ = _tmp2009_;
				_tmp2011_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2010_, 1);
				_tmp2012_ = _tmp2011_;
				_tmp2013_ = len_call;
				vala_ccode_function_add_assignment (_tmp2005_, _tmp2012_, (ValaCCodeExpression*) _tmp2013_);
				_vala_ccode_node_unref0 (_tmp2012_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2016_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2016_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2017_;
		ValaSymbol* _tmp2018_;
		ValaSymbol* _tmp2019_;
		_tmp2017_ = m;
		_tmp2018_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2017_);
		_tmp2019_ = _tmp2018_;
		_tmp2015_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2019_, VALA_TYPE_CLASS);
	} else {
		_tmp2015_ = FALSE;
	}
	if (_tmp2015_) {
		gboolean _tmp2020_ = FALSE;
		gboolean _tmp2021_ = FALSE;
		ValaClass* _tmp2022_;
		ValaClass* _tmp2023_;
		gboolean _tmp2024_;
		gboolean _tmp2025_;
		_tmp2022_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2023_ = _tmp2022_;
		_tmp2024_ = vala_class_get_is_compact (_tmp2023_);
		_tmp2025_ = _tmp2024_;
		if (_tmp2025_) {
			ValaClass* _tmp2026_;
			ValaClass* _tmp2027_;
			ValaClass* _tmp2028_;
			ValaClass* _tmp2029_;
			_tmp2026_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2027_ = _tmp2026_;
			_tmp2028_ = vala_class_get_base_class (_tmp2027_);
			_tmp2029_ = _tmp2028_;
			_tmp2021_ = _tmp2029_ != NULL;
		} else {
			_tmp2021_ = FALSE;
		}
		if (_tmp2021_) {
			_tmp2020_ = TRUE;
		} else {
			ValaClass* _tmp2030_;
			ValaClass* _tmp2031_;
			ValaClass* _tmp2032_;
			ValaClass* _tmp2033_;
			ValaClass* _tmp2034_;
			_tmp2030_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2031_ = _tmp2030_;
			_tmp2032_ = vala_class_get_base_class (_tmp2031_);
			_tmp2033_ = _tmp2032_;
			_tmp2034_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2020_ = _tmp2033_ == _tmp2034_;
		}
		_tmp2014_ = _tmp2020_;
	} else {
		_tmp2014_ = FALSE;
	}
	if (_tmp2014_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2035_;
		ValaClass* _tmp2036_;
		gchar* _tmp2037_;
		gchar* _tmp2038_;
		gchar* _tmp2039_;
		gchar* _tmp2040_;
		ValaCCodeIdentifier* _tmp2041_;
		ValaCCodeIdentifier* _tmp2042_;
		ValaCCodeFunctionCall* _tmp2043_;
		ValaCCodeFunctionCall* _tmp2044_;
		ValaCCodeFunctionCall* _tmp2045_;
		ValaCCodeExpression* _tmp2046_;
		ValaCCodeExpression* _tmp2047_;
		ValaCCodeFunction* _tmp2048_;
		ValaCCodeFunction* _tmp2049_;
		ValaCCodeFunctionCall* _tmp2050_;
		_tmp2035_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2036_ = _tmp2035_;
		_tmp2037_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2036_, NULL);
		_tmp2038_ = _tmp2037_;
		_tmp2039_ = g_strdup_printf ("%s_instance_init", _tmp2038_);
		_tmp2040_ = _tmp2039_;
		_tmp2041_ = vala_ccode_identifier_new (_tmp2040_);
		_tmp2042_ = _tmp2041_;
		_tmp2043_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2042_);
		_tmp2044_ = _tmp2043_;
		_vala_ccode_node_unref0 (_tmp2042_);
		_g_free0 (_tmp2040_);
		_g_free0 (_tmp2038_);
		cinitcall = _tmp2044_;
		_tmp2045_ = cinitcall;
		_tmp2046_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2047_ = _tmp2046_;
		vala_ccode_function_call_add_argument (_tmp2045_, _tmp2047_);
		_vala_ccode_node_unref0 (_tmp2047_);
		_tmp2048_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2049_ = _tmp2048_;
		_tmp2050_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2049_, (ValaCCodeExpression*) _tmp2050_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}

static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunction* _tmp45_;
	ValaCCodeFunction* _tmp46_;
	ValaCCodeFunction* _tmp47_;
	ValaCCodeConstant* _tmp48_;
	ValaCCodeConstant* _tmp49_;
	ValaCCodeFile* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeFile* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp24_;
			gpointer _tmp25_;
			ValaCCodeFunction* _tmp26_;
			ValaCCodeFunction* _tmp27_;
			ValaEnumValue* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaCCodeIdentifier* _tmp31_;
			ValaCCodeIdentifier* _tmp32_;
			ValaCCodeFunction* _tmp33_;
			ValaCCodeFunction* _tmp34_;
			ValaEnumValue* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_enum_value_index = _enum_value_index + 1;
			if (!(_enum_value_index < _enum_value_size)) {
				break;
			}
			_tmp24_ = _enum_value_list;
			_tmp25_ = vala_list_get (_tmp24_, _enum_value_index);
			enum_value = (ValaEnumValue*) _tmp25_;
			_tmp26_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp27_ = _tmp26_;
			_tmp28_ = enum_value;
			_tmp29_ = vala_get_ccode_name ((ValaCodeNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			_tmp31_ = vala_ccode_identifier_new (_tmp30_);
			_tmp32_ = _tmp31_;
			vala_ccode_function_add_case (_tmp27_, (ValaCCodeExpression*) _tmp32_);
			_vala_ccode_node_unref0 (_tmp32_);
			_g_free0 (_tmp30_);
			_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp34_ = _tmp33_;
			_tmp35_ = enum_value;
			_tmp36_ = vala_get_ccode_name ((ValaCodeNode*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat ("\"", _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			_tmp40_ = g_strconcat (_tmp39_, "\"", NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new (_tmp41_);
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp34_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
			_g_free0 (_tmp41_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp44_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	vala_ccode_function_close (_tmp45_);
	_tmp46_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp47_ = _tmp46_;
	_tmp48_ = vala_ccode_constant_new ("NULL");
	_tmp49_ = _tmp48_;
	vala_ccode_function_add_return (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp51_ = function;
	vala_ccode_file_add_function_declaration (_tmp50_, _tmp51_);
	_tmp52_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp53_ = function;
	vala_ccode_file_add_function (_tmp52_, _tmp53_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}

static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			ValaParameter* param = NULL;
			ValaList* _tmp4_;
			gpointer _tmp5_;
			ValaParameter* _tmp6_;
			ValaParameterDirection _tmp7_;
			ValaParameterDirection _tmp8_;
			_param_index = _param_index + 1;
			if (!(_param_index < _param_size)) {
				break;
			}
			_tmp4_ = _param_list;
			_tmp5_ = vala_list_get (_tmp4_, _param_index);
			param = (ValaParameter*) _tmp5_;
			_tmp6_ = param;
			_tmp7_ = vala_parameter_get_direction (_tmp6_);
			_tmp8_ = _tmp7_;
			if (_tmp8_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}

static gchar*
vala_ccode_method_call_module_generate_string_printf_function (ValaCCodeMethodCallModule* self)
{
	gchar* result = NULL;
	ValaCCodeFunction* function = NULL;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeFunction* _tmp2_;
	ValaCCodeParameter* _tmp3_;
	ValaCCodeParameter* _tmp4_;
	ValaCCodeFunction* _tmp5_;
	ValaCCodeParameter* _tmp6_;
	ValaCCodeParameter* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeBaseModuleEmitContext* _tmp9_;
	ValaCCodeBaseModuleEmitContext* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeFunction* _tmp12_;
	ValaCCodeFunction* _tmp13_;
	ValaCCodeVariableDeclarator* _tmp14_;
	ValaCCodeVariableDeclarator* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeVariableDeclarator* _tmp18_;
	ValaCCodeVariableDeclarator* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeVariableDeclarator* _tmp22_;
	ValaCCodeVariableDeclarator* _tmp23_;
	ValaCCodeFunctionCall* va_start = NULL;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeIdentifier* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeIdentifier* _tmp29_;
	ValaCCodeIdentifier* _tmp30_;
	ValaCCodeFunctionCall* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* vsnprintf = NULL;
	ValaCCodeIdentifier* _tmp37_;
	ValaCCodeIdentifier* _tmp38_;
	ValaCCodeFunctionCall* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunctionCall* _tmp41_;
	ValaCCodeConstant* _tmp42_;
	ValaCCodeConstant* _tmp43_;
	ValaCCodeFunctionCall* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeFunctionCall* _tmp47_;
	ValaCCodeIdentifier* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeFunctionCall* _tmp50_;
	ValaCCodeIdentifier* _tmp51_;
	ValaCCodeIdentifier* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	ValaCCodeFunction* _tmp54_;
	ValaCCodeIdentifier* _tmp55_;
	ValaCCodeIdentifier* _tmp56_;
	ValaCCodeFunctionCall* _tmp57_;
	ValaCCodeConstant* _tmp58_;
	ValaCCodeConstant* _tmp59_;
	ValaCCodeBinaryExpression* _tmp60_;
	ValaCCodeBinaryExpression* _tmp61_;
	ValaCCodeFunctionCall* va_end = NULL;
	ValaCCodeIdentifier* _tmp62_;
	ValaCCodeIdentifier* _tmp63_;
	ValaCCodeFunctionCall* _tmp64_;
	ValaCCodeFunctionCall* _tmp65_;
	ValaCCodeFunctionCall* _tmp66_;
	ValaCCodeIdentifier* _tmp67_;
	ValaCCodeIdentifier* _tmp68_;
	ValaCCodeFunction* _tmp69_;
	ValaCCodeFunction* _tmp70_;
	ValaCCodeFunctionCall* _tmp71_;
	ValaCCodeFunctionCall* malloc = NULL;
	ValaCCodeIdentifier* _tmp72_;
	ValaCCodeIdentifier* _tmp73_;
	ValaCCodeFunctionCall* _tmp74_;
	ValaCCodeFunctionCall* _tmp75_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeIdentifier* _tmp77_;
	ValaCCodeIdentifier* _tmp78_;
	ValaCCodeFunction* _tmp79_;
	ValaCCodeFunction* _tmp80_;
	ValaCCodeIdentifier* _tmp81_;
	ValaCCodeIdentifier* _tmp82_;
	ValaCCodeFunctionCall* _tmp83_;
	ValaCCodeIdentifier* _tmp84_;
	ValaCCodeIdentifier* _tmp85_;
	ValaCCodeFunctionCall* _tmp86_;
	ValaCCodeFunctionCall* _tmp87_;
	ValaCCodeIdentifier* _tmp88_;
	ValaCCodeIdentifier* _tmp89_;
	ValaCCodeFunctionCall* _tmp90_;
	ValaCCodeIdentifier* _tmp91_;
	ValaCCodeIdentifier* _tmp92_;
	ValaCCodeFunction* _tmp93_;
	ValaCCodeFunction* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	ValaCCodeIdentifier* _tmp97_;
	ValaCCodeFunctionCall* _tmp98_;
	ValaCCodeFunctionCall* _tmp99_;
	ValaCCodeIdentifier* _tmp100_;
	ValaCCodeIdentifier* _tmp101_;
	ValaCCodeFunctionCall* _tmp102_;
	ValaCCodeIdentifier* _tmp103_;
	ValaCCodeIdentifier* _tmp104_;
	ValaCCodeFunctionCall* _tmp105_;
	ValaCCodeIdentifier* _tmp106_;
	ValaCCodeIdentifier* _tmp107_;
	ValaCCodeFunctionCall* _tmp108_;
	ValaCCodeIdentifier* _tmp109_;
	ValaCCodeIdentifier* _tmp110_;
	ValaCCodeFunction* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunctionCall* _tmp113_;
	ValaCCodeIdentifier* _tmp114_;
	ValaCCodeIdentifier* _tmp115_;
	ValaCCodeFunctionCall* _tmp116_;
	ValaCCodeFunctionCall* _tmp117_;
	ValaCCodeIdentifier* _tmp118_;
	ValaCCodeIdentifier* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	ValaCCodeFunction* _tmp121_;
	ValaCCodeFunctionCall* _tmp122_;
	ValaCCodeFunction* _tmp123_;
	ValaCCodeFunction* _tmp124_;
	ValaCCodeIdentifier* _tmp125_;
	ValaCCodeIdentifier* _tmp126_;
	ValaCCodeFile* _tmp127_;
	ValaCCodeFile* _tmp128_;
	ValaCCodeFunction* _tmp129_;
	ValaCCodeFile* _tmp130_;
	ValaCCodeFunction* _tmp131_;
	gchar* _tmp132_;
	g_return_val_if_fail (self != NULL, NULL);
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, "string_printf")) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("string_printf");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = vala_ccode_function_new ("string_printf", "char*");
	function = _tmp1_;
	_tmp2_ = function;
	_tmp3_ = vala_ccode_parameter_new ("format", "const char*");
	_tmp4_ = _tmp3_;
	vala_ccode_function_add_parameter (_tmp2_, _tmp4_);
	_vala_ccode_node_unref0 (_tmp4_);
	_tmp5_ = function;
	_tmp6_ = vala_ccode_parameter_new_with_ellipsis ();
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_parameter (_tmp5_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_tmp8_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp8_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp9_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp10_ = _tmp9_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp10_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp10_);
	_tmp11_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp11_);
	_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_variable_declarator_new ("length", NULL, NULL);
	_tmp15_ = _tmp14_;
	vala_ccode_function_add_declaration (_tmp13_, "int", (ValaCCodeDeclarator*) _tmp15_, 0);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_variable_declarator_new ("ap", NULL, NULL);
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_declaration (_tmp17_, "va_list", (ValaCCodeDeclarator*) _tmp19_, 0);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_variable_declarator_new ("result", NULL, NULL);
	_tmp23_ = _tmp22_;
	vala_ccode_function_add_declaration (_tmp21_, "char*", (ValaCCodeDeclarator*) _tmp23_, 0);
	_vala_ccode_node_unref0 (_tmp23_);
	_tmp24_ = vala_ccode_identifier_new ("va_start");
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp25_);
	_tmp27_ = _tmp26_;
	_vala_ccode_node_unref0 (_tmp25_);
	va_start = _tmp27_;
	_tmp28_ = va_start;
	_tmp29_ = vala_ccode_identifier_new ("ap");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = va_start;
	_tmp32_ = vala_ccode_identifier_new ("format");
	_tmp33_ = _tmp32_;
	vala_ccode_function_call_add_argument (_tmp31_, (ValaCCodeExpression*) _tmp33_);
	_vala_ccode_node_unref0 (_tmp33_);
	_tmp34_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = va_start;
	vala_ccode_function_add_expression (_tmp35_, (ValaCCodeExpression*) _tmp36_);
	_tmp37_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp38_);
	_tmp40_ = _tmp39_;
	_vala_ccode_node_unref0 (_tmp38_);
	vsnprintf = _tmp40_;
	_tmp41_ = vsnprintf;
	_tmp42_ = vala_ccode_constant_new ("NULL");
	_tmp43_ = _tmp42_;
	vala_ccode_function_call_add_argument (_tmp41_, (ValaCCodeExpression*) _tmp43_);
	_vala_ccode_node_unref0 (_tmp43_);
	_tmp44_ = vsnprintf;
	_tmp45_ = vala_ccode_constant_new ("0");
	_tmp46_ = _tmp45_;
	vala_ccode_function_call_add_argument (_tmp44_, (ValaCCodeExpression*) _tmp46_);
	_vala_ccode_node_unref0 (_tmp46_);
	_tmp47_ = vsnprintf;
	_tmp48_ = vala_ccode_identifier_new ("format");
	_tmp49_ = _tmp48_;
	vala_ccode_function_call_add_argument (_tmp47_, (ValaCCodeExpression*) _tmp49_);
	_vala_ccode_node_unref0 (_tmp49_);
	_tmp50_ = vsnprintf;
	_tmp51_ = vala_ccode_identifier_new ("ap");
	_tmp52_ = _tmp51_;
	vala_ccode_function_call_add_argument (_tmp50_, (ValaCCodeExpression*) _tmp52_);
	_vala_ccode_node_unref0 (_tmp52_);
	_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_ccode_identifier_new ("length");
	_tmp56_ = _tmp55_;
	_tmp57_ = vsnprintf;
	_tmp58_ = vala_ccode_constant_new ("1");
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp57_, (ValaCCodeExpression*) _tmp59_);
	_tmp61_ = _tmp60_;
	vala_ccode_function_add_assignment (_tmp54_, (ValaCCodeExpression*) _tmp56_, (ValaCCodeExpression*) _tmp61_);
	_vala_ccode_node_unref0 (_tmp61_);
	_vala_ccode_node_unref0 (_tmp59_);
	_vala_ccode_node_unref0 (_tmp56_);
	_tmp62_ = vala_ccode_identifier_new ("va_end");
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp63_);
	_tmp65_ = _tmp64_;
	_vala_ccode_node_unref0 (_tmp63_);
	va_end = _tmp65_;
	_tmp66_ = va_end;
	_tmp67_ = vala_ccode_identifier_new ("ap");
	_tmp68_ = _tmp67_;
	vala_ccode_function_call_add_argument (_tmp66_, (ValaCCodeExpression*) _tmp68_);
	_vala_ccode_node_unref0 (_tmp68_);
	_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp70_ = _tmp69_;
	_tmp71_ = va_end;
	vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
	_tmp72_ = vala_ccode_identifier_new ("malloc");
	_tmp73_ = _tmp72_;
	_tmp74_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp73_);
	_tmp75_ = _tmp74_;
	_vala_ccode_node_unref0 (_tmp73_);
	malloc = _tmp75_;
	_tmp76_ = malloc;
	_tmp77_ = vala_ccode_identifier_new ("length");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = vala_ccode_identifier_new ("result");
	_tmp82_ = _tmp81_;
	_tmp83_ = malloc;
	vala_ccode_function_add_assignment (_tmp80_, (ValaCCodeExpression*) _tmp82_, (ValaCCodeExpression*) _tmp83_);
	_vala_ccode_node_unref0 (_tmp82_);
	_tmp84_ = vala_ccode_identifier_new ("va_start");
	_tmp85_ = _tmp84_;
	_tmp86_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp85_);
	_vala_ccode_node_unref0 (va_start);
	va_start = _tmp86_;
	_vala_ccode_node_unref0 (_tmp85_);
	_tmp87_ = va_start;
	_tmp88_ = vala_ccode_identifier_new ("ap");
	_tmp89_ = _tmp88_;
	vala_ccode_function_call_add_argument (_tmp87_, (ValaCCodeExpression*) _tmp89_);
	_vala_ccode_node_unref0 (_tmp89_);
	_tmp90_ = va_start;
	_tmp91_ = vala_ccode_identifier_new ("format");
	_tmp92_ = _tmp91_;
	vala_ccode_function_call_add_argument (_tmp90_, (ValaCCodeExpression*) _tmp92_);
	_vala_ccode_node_unref0 (_tmp92_);
	_tmp93_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp94_ = _tmp93_;
	_tmp95_ = va_start;
	vala_ccode_function_add_expression (_tmp94_, (ValaCCodeExpression*) _tmp95_);
	_tmp96_ = vala_ccode_identifier_new ("vsnprintf");
	_tmp97_ = _tmp96_;
	_tmp98_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp97_);
	_vala_ccode_node_unref0 (vsnprintf);
	vsnprintf = _tmp98_;
	_vala_ccode_node_unref0 (_tmp97_);
	_tmp99_ = vsnprintf;
	_tmp100_ = vala_ccode_identifier_new ("result");
	_tmp101_ = _tmp100_;
	vala_ccode_function_call_add_argument (_tmp99_, (ValaCCodeExpression*) _tmp101_);
	_vala_ccode_node_unref0 (_tmp101_);
	_tmp102_ = vsnprintf;
	_tmp103_ = vala_ccode_identifier_new ("length");
	_tmp104_ = _tmp103_;
	vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
	_vala_ccode_node_unref0 (_tmp104_);
	_tmp105_ = vsnprintf;
	_tmp106_ = vala_ccode_identifier_new ("format");
	_tmp107_ = _tmp106_;
	vala_ccode_function_call_add_argument (_tmp105_, (ValaCCodeExpression*) _tmp107_);
	_vala_ccode_node_unref0 (_tmp107_);
	_tmp108_ = vsnprintf;
	_tmp109_ = vala_ccode_identifier_new ("ap");
	_tmp110_ = _tmp109_;
	vala_ccode_function_call_add_argument (_tmp108_, (ValaCCodeExpression*) _tmp110_);
	_vala_ccode_node_unref0 (_tmp110_);
	_tmp111_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp112_ = _tmp111_;
	_tmp113_ = vsnprintf;
	vala_ccode_function_add_expression (_tmp112_, (ValaCCodeExpression*) _tmp113_);
	_tmp114_ = vala_ccode_identifier_new ("va_end");
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp115_);
	_vala_ccode_node_unref0 (va_end);
	va_end = _tmp116_;
	_vala_ccode_node_unref0 (_tmp115_);
	_tmp117_ = va_end;
	_tmp118_ = vala_ccode_identifier_new ("ap");
	_tmp119_ = _tmp118_;
	vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
	_vala_ccode_node_unref0 (_tmp119_);
	_tmp120_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp121_ = _tmp120_;
	_tmp122_ = va_end;
	vala_ccode_function_add_expression (_tmp121_, (ValaCCodeExpression*) _tmp122_);
	_tmp123_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_ccode_identifier_new ("result");
	_tmp126_ = _tmp125_;
	vala_ccode_function_add_return (_tmp124_, (ValaCCodeExpression*) _tmp126_);
	_vala_ccode_node_unref0 (_tmp126_);
	_tmp127_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_include (_tmp127_, "stdarg.h", FALSE);
	_tmp128_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp129_ = function;
	vala_ccode_file_add_function_declaration (_tmp128_, _tmp129_);
	_tmp130_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp131_ = function;
	vala_ccode_file_add_function (_tmp130_, _tmp131_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	_tmp132_ = g_strdup ("string_printf");
	result = _tmp132_;
	_vala_ccode_node_unref0 (malloc);
	_vala_ccode_node_unref0 (va_end);
	_vala_ccode_node_unref0 (vsnprintf);
	_vala_ccode_node_unref0 (va_start);
	_vala_ccode_node_unref0 (function);
	return result;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}

ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}

static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}

static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}

GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}

static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

