/* gstreamer-video-1.0.vapi generated by vapigen, do not modify. */

[CCode (cprefix = "Gst", gir_namespace = "GstVideo", gir_version = "1.0", lower_case_cprefix = "gst_")]
namespace Gst {
	namespace Video {
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_buffer_pool_get_type ()")]
		[GIR (name = "VideoBufferPool")]
		public class BufferPool : Gst.BufferPool {
			[CCode (has_construct_function = false, type = "GstBufferPool*")]
			public BufferPool ();
		}
		[CCode (cheader_filename = "gst/video/video.h")]
		[Compact]
		[GIR (name = "VideoChromaResample")]
		public class ChromaResample {
			public ChromaResample (Gst.Video.ChromaMethod method, Gst.Video.ChromaSite site, Gst.Video.ChromaFlags flags, Gst.Video.Format format, int h_factor, int v_factor);
			public void free ();
			public void get_info (uint n_lines, int offset);
			[CCode (cname = "gst_video_chroma_resample")]
			public void resample (void* lines, int width);
		}
		[CCode (cheader_filename = "gst/video/gstvideoutils.h", ref_function = "gst_video_codec_frame_ref", type_id = "gst_video_codec_frame_get_type ()", unref_function = "gst_video_codec_frame_unref")]
		[Compact]
		[GIR (name = "VideoCodecFrame")]
		public class CodecFrame {
			public Gst.ClockTime deadline;
			public int distance_from_sync;
			public Gst.ClockTime dts;
			public Gst.ClockTime duration;
			public weak Gst.Buffer input_buffer;
			public weak Gst.Buffer output_buffer;
			public Gst.ClockTime pts;
			public uint32 system_frame_number;
			[CCode (simple_generics = true)]
			public T get_user_data<T> ();
			public unowned Gst.Video.CodecFrame @ref ();
			[CCode (simple_generics = true)]
			public void set_user_data<T> (owned T user_data);
			public void unref ();
		}
		[CCode (cheader_filename = "gst/video/video.h", ref_function = "gst_video_codec_state_ref", type_id = "gst_video_codec_state_get_type ()", unref_function = "gst_video_codec_state_unref")]
		[Compact]
		[GIR (name = "VideoCodecState")]
		public class CodecState {
			public weak Gst.Caps allocation_caps;
			public weak Gst.Caps caps;
			public weak Gst.Buffer codec_data;
			public weak Gst.Video.Info info;
			public unowned Gst.Video.CodecState @ref ();
			public void unref ();
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstColorBalanceChannel", lower_case_cprefix = "gst_color_balance_channel_", type_id = "gst_color_balance_channel_get_type ()")]
		[GIR (name = "ColorBalanceChannel")]
		public class ColorBalanceChannel : GLib.Object {
			public weak string label;
			public int max_value;
			public int min_value;
			[CCode (has_construct_function = false)]
			protected ColorBalanceChannel ();
			public virtual signal void value_changed (int value);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[Compact]
		[GIR (name = "VideoConverter")]
		public class Converter {
			[Version (since = "1.6")]
			public void frame (Gst.Video.Frame src, Gst.Video.Frame dest);
			[Version (since = "1.6")]
			public void free ();
			public unowned Gst.Structure get_config ();
			[Version (since = "1.6")]
			public bool set_config (owned Gst.Structure config);
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_decoder_get_type ()")]
		[GIR (name = "VideoDecoder")]
		public abstract class Decoder : Gst.Element {
			[CCode (has_construct_function = false)]
			protected Decoder ();
			public void add_to_frame (int n_bytes);
			public Gst.Buffer allocate_output_buffer ();
			public Gst.FlowReturn allocate_output_frame (Gst.Video.CodecFrame frame);
			[Version (since = "1.12")]
			public Gst.FlowReturn allocate_output_frame_with_params (Gst.Video.CodecFrame frame, Gst.BufferPoolAcquireParams @params);
			[NoWrapper]
			public virtual bool close ();
			[NoWrapper]
			public virtual bool decide_allocation (Gst.Query query);
			[NoWrapper]
			public virtual Gst.FlowReturn drain ();
			public Gst.FlowReturn drop_frame (owned Gst.Video.CodecFrame frame);
			[NoWrapper]
			public virtual Gst.FlowReturn finish ();
			public Gst.FlowReturn finish_frame (owned Gst.Video.CodecFrame frame);
			[NoWrapper]
			public virtual bool flush ();
			public void get_allocator (out Gst.Allocator allocator, out Gst.AllocationParams @params);
			public Gst.BufferPool get_buffer_pool ();
			public int get_estimate_rate ();
			public Gst.Video.CodecFrame get_frame (int frame_number);
			public GLib.List<Gst.Video.CodecFrame> get_frames ();
			public void get_latency (out Gst.ClockTime min_latency, out Gst.ClockTime max_latency);
			public Gst.ClockTimeDiff get_max_decode_time (Gst.Video.CodecFrame frame);
			public int get_max_errors ();
			[Version (since = "1.4")]
			public bool get_needs_format ();
			public Gst.Video.CodecFrame get_oldest_frame ();
			public Gst.Video.CodecState get_output_state ();
			public bool get_packetized ();
			[Version (since = "1.4")]
			public size_t get_pending_frame_size ();
			[Version (since = "1.0.3")]
			public double get_qos_proportion ();
			[NoWrapper]
			public virtual Gst.Caps getcaps (Gst.Caps filter);
			[NoWrapper]
			public virtual Gst.FlowReturn handle_frame (Gst.Video.CodecFrame frame);
			public Gst.FlowReturn have_frame ();
			public void merge_tags (Gst.TagList? tags, Gst.TagMergeMode mode);
			public virtual bool negotiate ();
			[NoWrapper]
			public virtual bool open ();
			[NoWrapper]
			public virtual Gst.FlowReturn parse (Gst.Video.CodecFrame frame, Gst.Base.Adapter adapter, bool at_eos);
			[NoWrapper]
			public virtual bool propose_allocation (Gst.Query query);
			[Version (since = "1.6")]
			public Gst.Caps proxy_getcaps (Gst.Caps? caps, Gst.Caps? filter);
			[Version (since = "1.2.2")]
			public void release_frame (owned Gst.Video.CodecFrame frame);
			[NoWrapper]
			public virtual bool reset (bool hard);
			public void set_estimate_rate (bool enabled);
			[NoWrapper]
			public virtual bool set_format (Gst.Video.CodecState state);
			public void set_latency (Gst.ClockTime min_latency, Gst.ClockTime max_latency);
			public void set_max_errors (int num);
			[Version (since = "1.4")]
			public void set_needs_format (bool enabled);
			public Gst.Video.CodecState set_output_state (Gst.Video.Format fmt, uint width, uint height, Gst.Video.CodecState? reference);
			public void set_packetized (bool packetized);
			[Version (since = "1.6")]
			public void set_use_default_pad_acceptcaps (bool use);
			[NoWrapper]
			public virtual bool sink_event (Gst.Event event);
			[NoWrapper]
			public virtual bool sink_query (Gst.Query query);
			[NoWrapper]
			public virtual bool src_event (Gst.Event event);
			[NoWrapper]
			public virtual bool src_query (Gst.Query query);
			[NoWrapper]
			public virtual bool start ();
			[NoWrapper]
			public virtual bool stop ();
			[NoWrapper]
			public virtual bool transform_meta (Gst.Video.CodecFrame frame, Gst.Meta meta);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[Compact]
		[GIR (name = "VideoDither")]
		public class Dither {
			public void free ();
			public void line (void* line, uint x, uint y, uint width);
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_encoder_get_type ()")]
		[GIR (name = "VideoEncoder")]
		public abstract class Encoder : Gst.Element, Gst.Preset {
			[CCode (has_construct_function = false)]
			protected Encoder ();
			public Gst.Buffer allocate_output_buffer (size_t size);
			public Gst.FlowReturn allocate_output_frame (Gst.Video.CodecFrame frame, size_t size);
			[NoWrapper]
			public virtual bool close ();
			[NoWrapper]
			public virtual bool decide_allocation (Gst.Query query);
			[NoWrapper]
			public virtual Gst.FlowReturn finish ();
			public Gst.FlowReturn finish_frame (owned Gst.Video.CodecFrame frame);
			[NoWrapper]
			public virtual bool flush ();
			public void get_allocator (out Gst.Allocator allocator, out Gst.AllocationParams @params);
			public Gst.Video.CodecFrame get_frame (int frame_number);
			public GLib.List<Gst.Video.CodecFrame> get_frames ();
			public void get_latency (out Gst.ClockTime min_latency, out Gst.ClockTime max_latency);
			[Version (since = "1.14")]
			public Gst.ClockTimeDiff get_max_encode_time (Gst.Video.CodecFrame frame);
			public Gst.Video.CodecFrame get_oldest_frame ();
			public Gst.Video.CodecState get_output_state ();
			[NoWrapper]
			public virtual Gst.Caps getcaps (Gst.Caps filter);
			[NoWrapper]
			public virtual Gst.FlowReturn handle_frame (Gst.Video.CodecFrame frame);
			[Version (since = "1.14")]
			public bool is_qos_enabled ();
			public void merge_tags (Gst.TagList? tags, Gst.TagMergeMode mode);
			public virtual bool negotiate ();
			[NoWrapper]
			public virtual bool open ();
			[NoWrapper]
			public virtual Gst.FlowReturn pre_push (Gst.Video.CodecFrame frame);
			[NoWrapper]
			public virtual bool propose_allocation (Gst.Query query);
			public Gst.Caps proxy_getcaps (Gst.Caps? caps, Gst.Caps? filter);
			[NoWrapper]
			public virtual bool reset (bool hard);
			[NoWrapper]
			public virtual bool set_format (Gst.Video.CodecState state);
			public void set_headers (owned GLib.List<Gst.Buffer> headers);
			public void set_latency (Gst.ClockTime min_latency, Gst.ClockTime max_latency);
			public void set_min_pts (Gst.ClockTime min_pts);
			public Gst.Video.CodecState set_output_state (owned Gst.Caps caps, Gst.Video.CodecState? reference);
			[Version (since = "1.14")]
			public void set_qos_enabled (bool enabled);
			[NoWrapper]
			public virtual bool sink_event (Gst.Event event);
			[NoWrapper]
			public virtual bool sink_query (Gst.Query query);
			[NoWrapper]
			public virtual bool src_event (Gst.Event event);
			[NoWrapper]
			public virtual bool src_query (Gst.Query query);
			[NoWrapper]
			public virtual bool start ();
			[NoWrapper]
			public virtual bool stop ();
			[NoWrapper]
			public virtual bool transform_meta (Gst.Video.CodecFrame frame, Gst.Meta meta);
			[NoAccessorMethod]
			public bool qos { get; set; }
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_filter_get_type ()")]
		[GIR (name = "VideoFilter")]
		public abstract class Filter : Gst.Base.Transform {
			public weak Gst.Video.Info in_info;
			public bool negotiated;
			public weak Gst.Video.Info out_info;
			[CCode (has_construct_function = false)]
			protected Filter ();
			[NoWrapper]
			public virtual bool set_info (Gst.Caps incaps, Gst.Video.Info in_info, Gst.Caps outcaps, Gst.Video.Info out_info);
			[NoWrapper]
			public virtual Gst.FlowReturn transform_frame (Gst.Video.Frame inframe, Gst.Video.Frame outframe);
			[NoWrapper]
			public virtual Gst.FlowReturn transform_frame_ip (Gst.Video.Frame frame);
		}
		[CCode (cheader_filename = "gst/video/video.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gst_video_info_get_type ()")]
		[Compact]
		[GIR (name = "VideoInfo")]
		public class Info {
			[CCode (cname = "ABI.abi.field_order")]
			public Gst.Video.FieldOrder ABI_abi_field_order;
			[CCode (cname = "ABI.abi.multiview_flags")]
			public Gst.Video.MultiviewFlags ABI_abi_multiview_flags;
			[CCode (cname = "ABI.abi.multiview_mode")]
			public Gst.Video.MultiviewMode ABI_abi_multiview_mode;
			public Gst.Video.ChromaSite chroma_site;
			public Gst.Video.Colorimetry colorimetry;
			public weak Gst.Video.FormatInfo? finfo;
			public Gst.Video.Flags flags;
			public int fps_d;
			public int fps_n;
			public int height;
			public Gst.Video.InterlaceMode interlace_mode;
			[CCode (array_length = false)]
			public weak size_t offset[4];
			public int par_d;
			public int par_n;
			public size_t size;
			[CCode (array_length = false)]
			public weak int stride[4];
			public int views;
			public int width;
			[CCode (has_construct_function = false)]
			[Version (since = "1.6")]
			public Info ();
			public bool align (Gst.Video.Alignment align);
			public bool convert (Gst.Format src_format, int64 src_value, Gst.Format dest_format, out int64 dest_value);
			[Version (since = "1.6")]
			public Gst.Video.Info copy ();
			[Version (since = "1.6")]
			public void free ();
			public bool from_caps (Gst.Caps caps);
			public void init ();
			public bool is_equal (Gst.Video.Info other);
			public bool set_format (Gst.Video.Format format, uint width, uint height);
			public Gst.Caps to_caps ();
		}
		[CCode (cheader_filename = "gst/video/video.h", lower_case_cprefix = "gst_video_multiview_flagset_", type_id = "gst_video_multiview_flagset_get_type ()")]
		[GIR (name = "VideoMultiviewFlagsSet")]
		public class MultiviewFlagsSet : Gst.FlagSet {
			[CCode (has_construct_function = false)]
			protected MultiviewFlagsSet ();
		}
		[CCode (cheader_filename = "gst/video/video-overlay-composition.h", ref_function = "gst_video_overlay_composition_ref", type_id = "gst_video_overlay_composition_get_type ()", unref_function = "gst_video_overlay_composition_unref")]
		[Compact]
		[GIR (name = "VideoOverlayComposition")]
		public class OverlayComposition : Gst.MiniObject {
			[CCode (has_construct_function = false)]
			public OverlayComposition (Gst.Video.OverlayRectangle rectangle);
			public void add_rectangle (Gst.Video.OverlayRectangle rectangle);
			public bool blend (Gst.Video.Frame video_buf);
			public Gst.Video.OverlayComposition copy ();
			public unowned Gst.Video.OverlayRectangle get_rectangle (uint n);
			public uint get_seqnum ();
			[ReturnsModifiedPointer]
			public Gst.Video.OverlayComposition make_writable ();
			public uint n_rectangles ();
		}
		[CCode (cheader_filename = "gst/video/video-overlay-composition.h", ref_function = "gst_video_overlay_rectangle_ref", type_id = "gst_video_overlay_rectangle_get_type ()", unref_function = "gst_video_overlay_rectangle_unref")]
		[Compact]
		[GIR (name = "VideoOverlayRectangle")]
		public class OverlayRectangle : Gst.MiniObject {
			public Gst.Video.OverlayRectangle copy ();
			public Gst.Video.OverlayFormatFlags get_flags ();
			public float get_global_alpha ();
			public unowned Gst.Buffer get_pixels_argb (Gst.Video.OverlayFormatFlags flags);
			public unowned Gst.Buffer get_pixels_ayuv (Gst.Video.OverlayFormatFlags flags);
			public unowned Gst.Buffer get_pixels_raw (Gst.Video.OverlayFormatFlags flags);
			public unowned Gst.Buffer get_pixels_unscaled_argb (Gst.Video.OverlayFormatFlags flags);
			public unowned Gst.Buffer get_pixels_unscaled_ayuv (Gst.Video.OverlayFormatFlags flags);
			public unowned Gst.Buffer get_pixels_unscaled_raw (Gst.Video.OverlayFormatFlags flags);
			public bool get_render_rectangle (out int render_x, out int render_y, out uint render_width, out uint render_height);
			public uint get_seqnum ();
			[CCode (has_construct_function = false)]
			public OverlayRectangle.raw (Gst.Buffer pixels, int render_x, int render_y, uint render_width, uint render_height, Gst.Video.OverlayFormatFlags flags);
			public void set_global_alpha (float global_alpha);
			public void set_render_rectangle (int render_x, int render_y, uint render_width, uint render_height);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[Compact]
		[GIR (name = "VideoScaler")]
		public class Scaler {
			public void @2d (Gst.Video.Scaler vscale, Gst.Video.Format format, void* src, int src_stride, void* dest, int dest_stride, uint x, uint y, uint width, uint height);
			public void free ();
			public double get_coeff (uint out_offset, uint in_offset, uint n_taps);
			public uint get_max_taps ();
			public void horizontal (Gst.Video.Format format, void* src, void* dest, uint dest_offset, uint width);
			public void vertical (Gst.Video.Format format, void* src_lines, void* dest, uint dest_offset, uint width);
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_sink_get_type ()")]
		[GIR (name = "VideoSink")]
		public class Sink : Gst.Base.Sink {
			public int height;
			public int width;
			[CCode (has_construct_function = false)]
			protected Sink ();
			public static void center_rect (Gst.Video.Rectangle src, Gst.Video.Rectangle dst, Gst.Video.Rectangle result, bool scaling);
			[NoWrapper]
			public virtual Gst.FlowReturn show_frame (Gst.Buffer buf);
			[NoAccessorMethod]
			public bool show_preroll_frame { get; set construct; }
		}
		[CCode (cheader_filename = "gst/video/video.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gst_video_time_code_get_type ()")]
		[Compact]
		[GIR (name = "VideoTimeCode")]
		[Version (since = "1.10")]
		public class TimeCode {
			public Gst.Video.TimeCodeConfig config;
			public uint field_count;
			public uint frames;
			public uint hours;
			public uint minutes;
			public uint seconds;
			[CCode (has_construct_function = false)]
			public TimeCode (uint fps_n, uint fps_d, GLib.DateTime latest_daily_jam, Gst.Video.TimeCodeFlags flags, uint hours, uint minutes, uint seconds, uint frames, uint field_count);
			public void add_frames (int64 frames);
			[Version (since = "1.12")]
			public Gst.Video.TimeCode add_interval (Gst.Video.TimeCodeInterval tc_inter);
			public void clear ();
			public int compare (Gst.Video.TimeCode tc2);
			public Gst.Video.TimeCode copy ();
			[CCode (has_construct_function = false)]
			public TimeCode.empty ();
			public uint64 frames_since_daily_jam ();
			public void free ();
			[CCode (has_construct_function = false)]
			[Version (since = "1.12")]
			public TimeCode.from_date_time (uint fps_n, uint fps_d, GLib.DateTime dt, Gst.Video.TimeCodeFlags flags, uint field_count);
			[CCode (has_construct_function = false)]
			[Version (since = "1.12")]
			public TimeCode.from_string (string tc_str);
			public void increment_frame ();
			public void init (uint fps_n, uint fps_d, GLib.DateTime latest_daily_jam, Gst.Video.TimeCodeFlags flags, uint hours, uint minutes, uint seconds, uint frames, uint field_count);
			[Version (since = "1.12")]
			public void init_from_date_time (uint fps_n, uint fps_d, GLib.DateTime dt, Gst.Video.TimeCodeFlags flags, uint field_count);
			public bool is_valid ();
			public uint64 nsec_since_daily_jam ();
			public GLib.DateTime to_date_time ();
			public string to_string ();
		}
		[CCode (cheader_filename = "gst/video/video.h", copy_function = "g_boxed_copy", free_function = "g_boxed_free", type_id = "gst_video_time_code_interval_get_type ()")]
		[Compact]
		[GIR (name = "VideoTimeCodeInterval")]
		[Version (since = "1.12")]
		public class TimeCodeInterval {
			public uint frames;
			public uint hours;
			public uint minutes;
			public uint seconds;
			[CCode (has_construct_function = false)]
			public TimeCodeInterval (uint hours, uint minutes, uint seconds, uint frames);
			public void clear ();
			public Gst.Video.TimeCodeInterval copy ();
			public void free ();
			[CCode (has_construct_function = false)]
			public TimeCodeInterval.from_string (string tc_inter_str);
			public void init (uint hours, uint minutes, uint seconds, uint frames);
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstColorBalance", lower_case_cprefix = "gst_color_balance_", type_cname = "GstColorBalanceInterface", type_id = "gst_color_balance_get_type ()")]
		[GIR (name = "ColorBalance")]
		public interface ColorBalance : GLib.Object {
			public abstract Gst.Video.ColorBalanceType get_balance_type ();
			public abstract int get_value (Gst.Video.ColorBalanceChannel channel);
			public abstract unowned GLib.List<Gst.Video.ColorBalanceChannel> list_channels ();
			public abstract void set_value (Gst.Video.ColorBalanceChannel channel, int value);
			[HasEmitter]
			public virtual signal void value_changed (Gst.Video.ColorBalanceChannel channel, int value);
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_direction_get_type ()")]
		[GIR (name = "VideoDirection")]
		[Version (since = "1.10")]
		public interface Direction : GLib.Object {
			[NoAccessorMethod]
			public abstract Gst.Video.OrientationMethod video_direction { get; set construct; }
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstNavigation", lower_case_cprefix = "gst_navigation_", type_cname = "GstNavigationInterface", type_id = "gst_navigation_get_type ()")]
		[GIR (name = "Navigation")]
		public interface Navigation : GLib.Object {
			public static Gst.Video.NavigationEventType event_get_type (Gst.Event event);
			public static bool event_parse_command (Gst.Event event, out Gst.Video.NavigationCommand command);
			public static bool event_parse_key_event (Gst.Event event, out unowned string key);
			public static bool event_parse_mouse_button_event (Gst.Event event, out int button, out double x, out double y);
			public static bool event_parse_mouse_move_event (Gst.Event event, out double x, out double y);
			public static Gst.Video.NavigationMessageType message_get_type (Gst.Message message);
			public static Gst.Message message_new_angles_changed (Gst.Object src, uint cur_angle, uint n_angles);
			public static Gst.Message message_new_commands_changed (Gst.Object src);
			[Version (since = "1.6")]
			public static Gst.Message message_new_event (Gst.Object src, Gst.Event event);
			public static Gst.Message message_new_mouse_over (Gst.Object src, bool active);
			public static bool message_parse_angles_changed (Gst.Message message, out uint cur_angle, out uint n_angles);
			[Version (since = "1.6")]
			public static bool message_parse_event (Gst.Message message, out Gst.Event event);
			public static bool message_parse_mouse_over (Gst.Message message, out bool active);
			public static Gst.Video.NavigationQueryType query_get_type (Gst.Query query);
			public static Gst.Query query_new_angles ();
			public static Gst.Query query_new_commands ();
			public static bool query_parse_angles (Gst.Query query, out uint cur_angle, out uint n_angles);
			public static bool query_parse_commands_length (Gst.Query query, out uint n_cmds);
			public static bool query_parse_commands_nth (Gst.Query query, uint nth, out Gst.Video.NavigationCommand cmd);
			public static void query_set_angles (Gst.Query query, uint cur_angle, uint n_angles);
			public static void query_set_commandsv (Gst.Query query, [CCode (array_length_cname = "n_cmds", array_length_pos = 1.5)] Gst.Video.NavigationCommand[] cmds);
			public void send_command (Gst.Video.NavigationCommand command);
			public abstract void send_event (Gst.Structure structure);
			public void send_key_event (string event, string key);
			public void send_mouse_event (string event, int button, double x, double y);
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_orientation_get_type ()")]
		[GIR (name = "VideoOrientation")]
		public interface Orientation : GLib.Object {
			public abstract bool get_hcenter (out int center);
			public abstract bool get_hflip (out bool flip);
			public abstract bool get_vcenter (out int center);
			public abstract bool get_vflip (out bool flip);
			public abstract bool set_hcenter (int center);
			public abstract bool set_hflip (bool flip);
			public abstract bool set_vcenter (int center);
			public abstract bool set_vflip (bool flip);
		}
		[CCode (cheader_filename = "gst/video/video.h", type_id = "gst_video_overlay_get_type ()")]
		[GIR (name = "VideoOverlay")]
		public interface Overlay : GLib.Object {
			public abstract void expose ();
			public void got_window_handle ([CCode (type = "guintptr")] uint* handle);
			public abstract void handle_events (bool handle_events);
			public static void install_properties (GLib.ObjectClass oclass, int last_prop_id);
			public void prepare_window_handle ();
			public static bool set_property (GLib.Object object, int last_prop_id, uint property_id, GLib.Value value);
			[NoWrapper]
			public virtual void set_render_rectangle (int x, int y, int width, int height);
			public abstract void set_window_handle ([CCode (type = "guintptr")] uint* handle);
			[CCode (cname = "gst_video_overlay_set_render_rectangle")]
			public bool try_set_render_rectangle (int x, int y, int width, int height);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoAffineTransformationMeta")]
		[Version (since = "1.8")]
		public struct AffineTransformationMeta {
			public Gst.Meta meta;
			[CCode (array_length = false)]
			public weak float matrix[16];
			public void apply_matrix (float matrix);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoAlignment")]
		public struct Alignment {
			public uint padding_top;
			public uint padding_bottom;
			public uint padding_left;
			public uint padding_right;
			[CCode (array_length = false)]
			public weak uint stride_align[4];
			public void reset ();
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoColorPrimariesInfo")]
		[Version (since = "1.6")]
		public struct ColorPrimariesInfo {
			public Gst.Video.ColorPrimaries primaries;
			public double Wx;
			public double Wy;
			public double Rx;
			public double Ry;
			public double Gx;
			public double Gy;
			public double Bx;
			public double By;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoColorimetry")]
		public struct Colorimetry {
			public Gst.Video.ColorRange range;
			public Gst.Video.ColorMatrix matrix;
			public Gst.Video.TransferFunction transfer;
			public Gst.Video.ColorPrimaries primaries;
			public bool from_string (string color);
			[Version (since = "1.6")]
			public bool is_equal (Gst.Video.Colorimetry other);
			public bool matches (string color);
			public string to_string ();
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoCropMeta")]
		public struct CropMeta {
			public Gst.Meta meta;
			public uint x;
			public uint y;
			public uint width;
			public uint height;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoFormatInfo")]
		public struct FormatInfo {
			public Gst.Video.Format format;
			public weak string name;
			public weak string description;
			public Gst.Video.FormatFlags flags;
			public uint bits;
			public uint n_components;
			[CCode (array_length = false)]
			public weak uint shift[4];
			[CCode (array_length = false)]
			public weak uint depth[4];
			[CCode (array_length = false)]
			public weak int pixel_stride[4];
			public uint n_planes;
			[CCode (array_length = false)]
			public weak uint plane[4];
			[CCode (array_length = false)]
			public weak uint poffset[4];
			[CCode (array_length = false)]
			public weak uint w_sub[4];
			[CCode (array_length = false)]
			public weak uint h_sub[4];
			public Gst.Video.Format unpack_format;
			public weak Gst.Video.FormatUnpack unpack_func;
			public int pack_lines;
			public weak Gst.Video.FormatPack pack_func;
			public Gst.Video.TileMode tile_mode;
			public uint tile_ws;
			public uint tile_hs;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoFrame")]
		public struct Frame {
			public weak Gst.Video.Info info;
			public Gst.Video.FrameFlags flags;
			public weak Gst.Buffer buffer;
			public void* meta;
			public int id;
			[CCode (array_length = false)]
			public weak void* data[4];
			public bool copy (Gst.Video.Frame src);
			public bool copy_plane (Gst.Video.Frame src, uint plane);
			public bool map (Gst.Video.Info info, Gst.Buffer buffer, Gst.MapFlags flags);
			public bool map_id (Gst.Video.Info info, Gst.Buffer buffer, int id, Gst.MapFlags flags);
			public void unmap ();
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoGLTextureUploadMeta")]
		public struct GLTextureUploadMeta {
			public Gst.Meta meta;
			public Gst.Video.GLTextureOrientation texture_orientation;
			public uint n_textures;
			[CCode (array_length = false)]
			public weak Gst.Video.GLTextureType texture_type[4];
			public bool upload (uint texture_id);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoMeta")]
		public struct Meta {
			public Gst.Meta meta;
			public weak Gst.Buffer buffer;
			public Gst.Video.FrameFlags flags;
			public Gst.Video.Format format;
			public int id;
			public uint width;
			public uint height;
			public uint n_planes;
			[CCode (array_length = false)]
			public weak size_t offset[4];
			[CCode (array_length = false)]
			public weak int stride[4];
			public bool map (uint plane, Gst.MapInfo info, out void* data, out int stride, Gst.MapFlags flags);
			public bool unmap (uint plane, Gst.MapInfo info);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoMetaTransform")]
		public struct MetaTransform {
			public weak Gst.Video.Info in_info;
			public weak Gst.Video.Info out_info;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoOverlayCompositionMeta")]
		public struct OverlayCompositionMeta {
			public Gst.Meta meta;
			public weak Gst.Video.OverlayComposition overlay;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoRectangle")]
		public struct Rectangle {
			public int x;
			public int y;
			public int w;
			public int h;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoRegionOfInterestMeta")]
		public struct RegionOfInterestMeta {
			public Gst.Meta meta;
			public GLib.Quark roi_type;
			public int id;
			public int parent_id;
			public uint x;
			public uint y;
			public uint w;
			public uint h;
			public weak GLib.List<void*> @params;
			[Version (since = "1.14")]
			public void add_param (owned Gst.Structure s);
			[Version (since = "1.14")]
			public unowned Gst.Structure? get_param (string name);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoResampler")]
		[Version (since = "1.6")]
		public struct Resampler {
			public int in_size;
			public int out_size;
			public uint max_taps;
			public uint n_phases;
			public uint32 offset;
			public uint32 phase;
			public uint32 n_taps;
			public double taps;
			public void clear ();
			public bool init (Gst.Video.ResamplerMethod method, Gst.Video.ResamplerFlags flags, uint n_phases, uint n_taps, double shift, uint in_size, uint out_size, Gst.Structure options);
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoTimeCodeConfig")]
		[Version (since = "1.10")]
		public struct TimeCodeConfig {
			public uint fps_n;
			public uint fps_d;
			public Gst.Video.TimeCodeFlags flags;
			public weak GLib.DateTime latest_daily_jam;
		}
		[CCode (cheader_filename = "gst/video/video.h", has_type_id = false)]
		[GIR (name = "VideoTimeCodeMeta")]
		[Version (since = "1.10")]
		public struct TimeCodeMeta {
			public Gst.Meta meta;
			public weak Gst.Video.TimeCode tc;
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_ALPHA_MODE_", type_id = "gst_video_alpha_mode_get_type ()")]
		[GIR (name = "VideoAlphaMode")]
		[Version (since = "1.6")]
		public enum AlphaMode {
			COPY,
			SET,
			MULT
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_BUFFER_FLAG_", type_id = "gst_video_buffer_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoBufferFlags")]
		public enum BufferFlags {
			INTERLACED,
			TFF,
			RFF,
			ONEFIELD,
			MULTIPLE_VIEW,
			FIRST_IN_BUNDLE,
			LAST
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_CHROMA_FLAG_", type_id = "gst_video_chroma_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoChromaFlags")]
		public enum ChromaFlags {
			NONE,
			INTERLACED
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_CHROMA_METHOD_", type_id = "gst_video_chroma_method_get_type ()")]
		[GIR (name = "VideoChromaMethod")]
		public enum ChromaMethod {
			NEAREST,
			LINEAR
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_CHROMA_MODE_", type_id = "gst_video_chroma_mode_get_type ()")]
		[GIR (name = "VideoChromaMode")]
		[Version (since = "1.6")]
		public enum ChromaMode {
			FULL,
			UPSAMPLE_ONLY,
			DOWNSAMPLE_ONLY,
			NONE
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_CHROMA_SITE_", type_id = "gst_video_chroma_site_get_type ()")]
		[Flags]
		[GIR (name = "VideoChromaSite")]
		public enum ChromaSite {
			UNKNOWN,
			NONE,
			H_COSITED,
			V_COSITED,
			ALT_LINE,
			COSITED,
			JPEG,
			MPEG2,
			DV
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_CODEC_FRAME_FLAG_", has_type_id = false)]
		[Flags]
		[GIR (name = "VideoCodecFrameFlags")]
		public enum CodecFrameFlags {
			DECODE_ONLY,
			SYNC_POINT,
			FORCE_KEYFRAME,
			FORCE_KEYFRAME_HEADERS
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstColorBalanceType", cprefix = "GST_COLOR_BALANCE_", type_id = "gst_color_balance_type_get_type ()")]
		[GIR (name = "ColorBalanceType")]
		public enum ColorBalanceType {
			HARDWARE,
			SOFTWARE
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_COLOR_MATRIX_", type_id = "gst_video_color_matrix_get_type ()")]
		[GIR (name = "VideoColorMatrix")]
		public enum ColorMatrix {
			UNKNOWN,
			RGB,
			FCC,
			BT709,
			BT601,
			SMPTE240M,
			BT2020
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_COLOR_PRIMARIES_", type_id = "gst_video_color_primaries_get_type ()")]
		[GIR (name = "VideoColorPrimaries")]
		public enum ColorPrimaries {
			UNKNOWN,
			BT709,
			BT470M,
			BT470BG,
			SMPTE170M,
			SMPTE240M,
			FILM,
			BT2020,
			ADOBERGB
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_COLOR_RANGE_", type_id = "gst_video_color_range_get_type ()")]
		[GIR (name = "VideoColorRange")]
		public enum ColorRange {
			UNKNOWN,
			@0_255,
			@16_235
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_DITHER_FLAG_", type_id = "gst_video_dither_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoDitherFlags")]
		public enum DitherFlags {
			NONE,
			INTERLACED,
			QUANTIZE
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_DITHER_", type_id = "gst_video_dither_method_get_type ()")]
		[GIR (name = "VideoDitherMethod")]
		public enum DitherMethod {
			NONE,
			VERTERR,
			FLOYD_STEINBERG,
			SIERRA_LITE,
			BAYER
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_FIELD_ORDER_", type_id = "gst_video_field_order_get_type ()")]
		[GIR (name = "VideoFieldOrder")]
		[Version (since = "1.12")]
		public enum FieldOrder {
			UNKNOWN,
			TOP_FIELD_FIRST,
			BOTTOM_FIELD_FIRST
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_FLAG_", type_id = "gst_video_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoFlags")]
		public enum Flags {
			NONE,
			VARIABLE_FPS,
			PREMULTIPLIED_ALPHA
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_FORMAT_", type_id = "gst_video_format_get_type ()")]
		[GIR (name = "VideoFormat")]
		public enum Format {
			UNKNOWN,
			ENCODED,
			I420,
			YV12,
			YUY2,
			UYVY,
			AYUV,
			[CCode (cname = "GST_VIDEO_FORMAT_RGBx")]
			RGBX,
			[CCode (cname = "GST_VIDEO_FORMAT_BGRx")]
			BGRX,
			[CCode (cname = "GST_VIDEO_FORMAT_xRGB")]
			XRGB,
			[CCode (cname = "GST_VIDEO_FORMAT_xBGR")]
			XBGR,
			RGBA,
			BGRA,
			ARGB,
			ABGR,
			RGB,
			BGR,
			Y41B,
			Y42B,
			YVYU,
			Y444,
			[CCode (cname = "GST_VIDEO_FORMAT_v210")]
			V210,
			[CCode (cname = "GST_VIDEO_FORMAT_v216")]
			V216,
			NV12,
			NV21,
			GRAY8,
			GRAY16_BE,
			GRAY16_LE,
			[CCode (cname = "GST_VIDEO_FORMAT_v308")]
			V308,
			RGB16,
			BGR16,
			RGB15,
			BGR15,
			UYVP,
			A420,
			RGB8P,
			YUV9,
			YVU9,
			IYU1,
			ARGB64,
			AYUV64,
			[CCode (cname = "GST_VIDEO_FORMAT_r210")]
			R210,
			I420_10BE,
			I420_10LE,
			I422_10BE,
			I422_10LE,
			Y444_10BE,
			Y444_10LE,
			GBR,
			GBR_10BE,
			GBR_10LE,
			NV16,
			NV24,
			NV12_64Z32,
			A420_10BE,
			A420_10LE,
			A422_10BE,
			A422_10LE,
			A444_10BE,
			A444_10LE,
			NV61,
			P010_10BE,
			P010_10LE,
			IYU2,
			VYUY,
			GBRA,
			GBRA_10BE,
			GBRA_10LE,
			GBR_12BE,
			GBR_12LE,
			GBRA_12BE,
			GBRA_12LE,
			I420_12BE,
			I420_12LE,
			I422_12BE,
			I422_12LE,
			Y444_12BE,
			Y444_12LE,
			GRAY10_LE32,
			NV12_10LE32,
			NV16_10LE32
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_FORMAT_FLAG_", type_id = "gst_video_format_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoFormatFlags")]
		public enum FormatFlags {
			YUV,
			RGB,
			GRAY,
			ALPHA,
			LE,
			PALETTE,
			COMPLEX,
			UNPACK,
			TILED
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_FRAME_FLAG_", type_id = "gst_video_frame_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoFrameFlags")]
		public enum FrameFlags {
			NONE,
			INTERLACED,
			TFF,
			RFF,
			ONEFIELD,
			MULTIPLE_VIEW,
			FIRST_IN_BUNDLE
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_FRAME_MAP_FLAG_", type_id = "gst_video_frame_map_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoFrameMapFlags")]
		[Version (since = "1.6")]
		public enum FrameMapFlags {
			NO_REF,
			LAST
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_GL_TEXTURE_ORIENTATION_X_", has_type_id = false)]
		[GIR (name = "VideoGLTextureOrientation")]
		public enum GLTextureOrientation {
			NORMAL_Y_NORMAL,
			NORMAL_Y_FLIP,
			FLIP_Y_NORMAL,
			FLIP_Y_FLIP
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_GL_TEXTURE_TYPE_", has_type_id = false)]
		[GIR (name = "VideoGLTextureType")]
		public enum GLTextureType {
			LUMINANCE,
			LUMINANCE_ALPHA,
			RGB16,
			RGB,
			RGBA,
			R,
			RG
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_GAMMA_MODE_", type_id = "gst_video_gamma_mode_get_type ()")]
		[GIR (name = "VideoGammaMode")]
		[Version (since = "1.6")]
		public enum GammaMode {
			NONE,
			REMAP
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_INTERLACE_MODE_", type_id = "gst_video_interlace_mode_get_type ()")]
		[GIR (name = "VideoInterlaceMode")]
		public enum InterlaceMode {
			PROGRESSIVE,
			INTERLEAVED,
			MIXED,
			FIELDS
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_MATRIX_MODE_", type_id = "gst_video_matrix_mode_get_type ()")]
		[GIR (name = "VideoMatrixMode")]
		[Version (since = "1.6")]
		public enum MatrixMode {
			FULL,
			INPUT_ONLY,
			OUTPUT_ONLY,
			NONE
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_MULTIVIEW_FLAGS_", type_id = "gst_video_multiview_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoMultiviewFlags")]
		public enum MultiviewFlags {
			NONE,
			RIGHT_VIEW_FIRST,
			LEFT_FLIPPED,
			LEFT_FLOPPED,
			RIGHT_FLIPPED,
			RIGHT_FLOPPED,
			HALF_ASPECT,
			MIXED_MONO
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_MULTIVIEW_FRAME_PACKING_", type_id = "gst_video_multiview_frame_packing_get_type ()")]
		[GIR (name = "VideoMultiviewFramePacking")]
		public enum MultiviewFramePacking {
			NONE,
			MONO,
			LEFT,
			RIGHT,
			SIDE_BY_SIDE,
			SIDE_BY_SIDE_QUINCUNX,
			COLUMN_INTERLEAVED,
			ROW_INTERLEAVED,
			TOP_BOTTOM,
			CHECKERBOARD
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_MULTIVIEW_MODE_", type_id = "gst_video_multiview_mode_get_type ()")]
		[GIR (name = "VideoMultiviewMode")]
		public enum MultiviewMode {
			NONE,
			MONO,
			LEFT,
			RIGHT,
			SIDE_BY_SIDE,
			SIDE_BY_SIDE_QUINCUNX,
			COLUMN_INTERLEAVED,
			ROW_INTERLEAVED,
			TOP_BOTTOM,
			CHECKERBOARD,
			FRAME_BY_FRAME,
			MULTIVIEW_FRAME_BY_FRAME,
			SEPARATED
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstNavigationCommand", cprefix = "GST_NAVIGATION_COMMAND_", type_id = "gst_navigation_command_get_type ()")]
		[GIR (name = "NavigationCommand")]
		public enum NavigationCommand {
			INVALID,
			MENU1,
			MENU2,
			MENU3,
			MENU4,
			MENU5,
			MENU6,
			MENU7,
			LEFT,
			RIGHT,
			UP,
			DOWN,
			ACTIVATE,
			PREV_ANGLE,
			NEXT_ANGLE
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstNavigationEventType", cprefix = "GST_NAVIGATION_EVENT_", type_id = "gst_navigation_event_type_get_type ()")]
		[GIR (name = "NavigationEventType")]
		public enum NavigationEventType {
			INVALID,
			KEY_PRESS,
			KEY_RELEASE,
			MOUSE_BUTTON_PRESS,
			MOUSE_BUTTON_RELEASE,
			MOUSE_MOVE,
			COMMAND
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstNavigationMessageType", cprefix = "GST_NAVIGATION_MESSAGE_", type_id = "gst_navigation_message_type_get_type ()")]
		[GIR (name = "NavigationMessageType")]
		public enum NavigationMessageType {
			INVALID,
			MOUSE_OVER,
			COMMANDS_CHANGED,
			ANGLES_CHANGED,
			EVENT
		}
		[CCode (cheader_filename = "gst/video/video.h", cname = "GstNavigationQueryType", cprefix = "GST_NAVIGATION_QUERY_", type_id = "gst_navigation_query_type_get_type ()")]
		[GIR (name = "NavigationQueryType")]
		public enum NavigationQueryType {
			INVALID,
			COMMANDS,
			ANGLES
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_ORIENTATION_", type_id = "gst_video_orientation_method_get_type ()")]
		[GIR (name = "VideoOrientationMethod")]
		[Version (since = "1.10")]
		public enum OrientationMethod {
			IDENTITY,
			@90R,
			@180,
			@90L,
			HORIZ,
			VERT,
			UL_LR,
			UR_LL,
			AUTO,
			CUSTOM
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_OVERLAY_FORMAT_FLAG_", has_type_id = false)]
		[GIR (name = "VideoOverlayFormatFlags")]
		public enum OverlayFormatFlags {
			NONE,
			PREMULTIPLIED_ALPHA,
			GLOBAL_ALPHA
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_PACK_FLAG_", type_id = "gst_video_pack_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoPackFlags")]
		public enum PackFlags {
			NONE,
			TRUNCATE_RANGE,
			INTERLACED
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_PRIMARIES_MODE_", type_id = "gst_video_primaries_mode_get_type ()")]
		[GIR (name = "VideoPrimariesMode")]
		[Version (since = "1.6")]
		public enum PrimariesMode {
			NONE,
			MERGE_ONLY,
			FAST
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_RESAMPLER_FLAG_", type_id = "gst_video_resampler_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoResamplerFlags")]
		[Version (since = "1.6")]
		public enum ResamplerFlags {
			NONE,
			HALF_TAPS
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_RESAMPLER_METHOD_", type_id = "gst_video_resampler_method_get_type ()")]
		[GIR (name = "VideoResamplerMethod")]
		[Version (since = "1.6")]
		public enum ResamplerMethod {
			NEAREST,
			LINEAR,
			CUBIC,
			SINC,
			LANCZOS
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_SCALER_FLAG_", type_id = "gst_video_scaler_flags_get_type ()")]
		[Flags]
		[GIR (name = "VideoScalerFlags")]
		public enum ScalerFlags {
			NONE,
			INTERLACED
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_TILE_MODE_", type_id = "gst_video_tile_mode_get_type ()")]
		[GIR (name = "VideoTileMode")]
		public enum TileMode {
			UNKNOWN,
			ZFLIPZ_2X2
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_TILE_TYPE_", type_id = "gst_video_tile_type_get_type ()")]
		[GIR (name = "VideoTileType")]
		public enum TileType {
			INDEXED
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_TIME_CODE_FLAGS_", has_type_id = false)]
		[Flags]
		[GIR (name = "VideoTimeCodeFlags")]
		[Version (since = "1.10")]
		public enum TimeCodeFlags {
			NONE,
			DROP_FRAME,
			INTERLACED
		}
		[CCode (cheader_filename = "gst/video/video.h", cprefix = "GST_VIDEO_TRANSFER_", type_id = "gst_video_transfer_function_get_type ()")]
		[GIR (name = "VideoTransferFunction")]
		public enum TransferFunction {
			UNKNOWN,
			GAMMA10,
			GAMMA18,
			GAMMA20,
			GAMMA22,
			BT709,
			SMPTE240M,
			SRGB,
			GAMMA28,
			LOG100,
			LOG316,
			BT2020_12,
			ADOBERGB
		}
		[CCode (cheader_filename = "gst/video/video.h", has_target = false)]
		public delegate bool AffineTransformationGetMatrix (Gst.Video.AffineTransformationMeta meta, float matrix);
		[CCode (cheader_filename = "gst/video/video.h", instance_pos = 2.9)]
		public delegate void ConvertSampleCallback (Gst.Sample sample, GLib.Error error);
		[CCode (cheader_filename = "gst/video/video.h", has_target = false)]
		public delegate void FormatPack (Gst.Video.FormatInfo info, Gst.Video.PackFlags flags, void* src, int sstride, void* data, int stride, Gst.Video.ChromaSite chroma_site, int y, int width);
		[CCode (cheader_filename = "gst/video/video.h", has_target = false)]
		public delegate void FormatUnpack (Gst.Video.FormatInfo info, Gst.Video.PackFlags flags, void* dest, void* data, int stride, int x, int y, int width);
		[CCode (cheader_filename = "gst/video/video.h", has_target = false)]
		public delegate bool GLTextureUpload (Gst.Video.GLTextureUploadMeta meta, uint texture_id);
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_BUFFER_POOL_OPTION_VIDEO_AFFINE_TRANSFORMATION_META")]
		public const string BUFFER_POOL_OPTION_VIDEO_AFFINE_TRANSFORMATION_META;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_BUFFER_POOL_OPTION_VIDEO_ALIGNMENT")]
		public const string BUFFER_POOL_OPTION_VIDEO_ALIGNMENT;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_BUFFER_POOL_OPTION_VIDEO_GL_TEXTURE_UPLOAD_META")]
		[Version (since = "1.2.2")]
		public const string BUFFER_POOL_OPTION_VIDEO_GL_TEXTURE_UPLOAD_META;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_BUFFER_POOL_OPTION_VIDEO_META")]
		public const string BUFFER_POOL_OPTION_VIDEO_META;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_CAPS_FEATURE_META_GST_VIDEO_AFFINE_TRANSFORMATION_META")]
		public const string CAPS_FEATURE_META_GST_VIDEO_AFFINE_TRANSFORMATION_META;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_CAPS_FEATURE_META_GST_VIDEO_GL_TEXTURE_UPLOAD_META")]
		public const string CAPS_FEATURE_META_GST_VIDEO_GL_TEXTURE_UPLOAD_META;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_CAPS_FEATURE_META_GST_VIDEO_META")]
		public const string CAPS_FEATURE_META_GST_VIDEO_META;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_CAPS_FEATURE_META_GST_VIDEO_OVERLAY_COMPOSITION")]
		public const string CAPS_FEATURE_META_GST_VIDEO_OVERLAY_COMPOSITION;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COLORIMETRY_BT2020")]
		public const string COLORIMETRY_BT2020;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COLORIMETRY_BT601")]
		public const string COLORIMETRY_BT601;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COLORIMETRY_BT709")]
		public const string COLORIMETRY_BT709;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COLORIMETRY_SMPTE240M")]
		public const string COLORIMETRY_SMPTE240M;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COLORIMETRY_SRGB")]
		public const string COLORIMETRY_SRGB;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_A")]
		public const int COMP_A;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_B")]
		public const int COMP_B;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_G")]
		public const int COMP_G;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_INDEX")]
		public const int COMP_INDEX;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_PALETTE")]
		public const int COMP_PALETTE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_R")]
		public const int COMP_R;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_U")]
		public const int COMP_U;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_V")]
		public const int COMP_V;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_COMP_Y")]
		public const int COMP_Y;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_ALPHA_MODE")]
		public const string CONVERTER_OPT_ALPHA_MODE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_ALPHA_VALUE")]
		public const string CONVERTER_OPT_ALPHA_VALUE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_BORDER_ARGB")]
		public const string CONVERTER_OPT_BORDER_ARGB;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_CHROMA_MODE")]
		public const string CONVERTER_OPT_CHROMA_MODE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_CHROMA_RESAMPLER_METHOD")]
		public const string CONVERTER_OPT_CHROMA_RESAMPLER_METHOD;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_DEST_HEIGHT")]
		public const string CONVERTER_OPT_DEST_HEIGHT;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_DEST_WIDTH")]
		public const string CONVERTER_OPT_DEST_WIDTH;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_DEST_X")]
		public const string CONVERTER_OPT_DEST_X;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_DEST_Y")]
		public const string CONVERTER_OPT_DEST_Y;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_DITHER_METHOD")]
		public const string CONVERTER_OPT_DITHER_METHOD;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_DITHER_QUANTIZATION")]
		public const string CONVERTER_OPT_DITHER_QUANTIZATION;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_FILL_BORDER")]
		public const string CONVERTER_OPT_FILL_BORDER;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_GAMMA_MODE")]
		public const string CONVERTER_OPT_GAMMA_MODE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_MATRIX_MODE")]
		public const string CONVERTER_OPT_MATRIX_MODE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_PRIMARIES_MODE")]
		public const string CONVERTER_OPT_PRIMARIES_MODE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_RESAMPLER_METHOD")]
		public const string CONVERTER_OPT_RESAMPLER_METHOD;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_RESAMPLER_TAPS")]
		public const string CONVERTER_OPT_RESAMPLER_TAPS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_SRC_HEIGHT")]
		public const string CONVERTER_OPT_SRC_HEIGHT;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_SRC_WIDTH")]
		public const string CONVERTER_OPT_SRC_WIDTH;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_SRC_X")]
		public const string CONVERTER_OPT_SRC_X;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_SRC_Y")]
		public const string CONVERTER_OPT_SRC_Y;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_CONVERTER_OPT_THREADS")]
		public const string CONVERTER_OPT_THREADS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_DECODER_MAX_ERRORS")]
		public const int DECODER_MAX_ERRORS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_DECODER_SINK_NAME")]
		public const string DECODER_SINK_NAME;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_DECODER_SRC_NAME")]
		public const string DECODER_SRC_NAME;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_ENCODER_SINK_NAME")]
		public const string ENCODER_SINK_NAME;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_ENCODER_SRC_NAME")]
		public const string ENCODER_SRC_NAME;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_FORMATS_ALL")]
		public const string FORMATS_ALL;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_FPS_RANGE")]
		public const string FPS_RANGE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_MAX_COMPONENTS")]
		public const int MAX_COMPONENTS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_MAX_PLANES")]
		public const int MAX_PLANES;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_META_TAG_VIDEO_COLORSPACE_STR")]
		[Version (since = "1.2")]
		public const string META_TAG_VIDEO_COLORSPACE_STR;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_META_TAG_VIDEO_ORIENTATION_STR")]
		[Version (since = "1.2")]
		public const string META_TAG_VIDEO_ORIENTATION_STR;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_META_TAG_VIDEO_SIZE_STR")]
		[Version (since = "1.2")]
		public const string META_TAG_VIDEO_SIZE_STR;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_META_TAG_VIDEO_STR")]
		[Version (since = "1.2")]
		public const string META_TAG_VIDEO_STR;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_OVERLAY_COMPOSITION_BLEND_FORMATS")]
		[Version (since = "1.2")]
		public const string OVERLAY_COMPOSITION_BLEND_FORMATS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_RESAMPLER_OPT_CUBIC_B")]
		public const string RESAMPLER_OPT_CUBIC_B;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_RESAMPLER_OPT_CUBIC_C")]
		public const string RESAMPLER_OPT_CUBIC_C;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_RESAMPLER_OPT_ENVELOPE")]
		public const string RESAMPLER_OPT_ENVELOPE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_RESAMPLER_OPT_MAX_TAPS")]
		public const string RESAMPLER_OPT_MAX_TAPS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_RESAMPLER_OPT_SHARPEN")]
		public const string RESAMPLER_OPT_SHARPEN;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_RESAMPLER_OPT_SHARPNESS")]
		public const string RESAMPLER_OPT_SHARPNESS;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_SCALER_OPT_DITHER_METHOD")]
		public const string SCALER_OPT_DITHER_METHOD;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_SIZE_RANGE")]
		public const string SIZE_RANGE;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_TILE_TYPE_MASK")]
		public const int TILE_TYPE_MASK;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_TILE_TYPE_SHIFT")]
		public const int TILE_TYPE_SHIFT;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_TILE_X_TILES_MASK")]
		public const int TILE_X_TILES_MASK;
		[CCode (cheader_filename = "gst/video/video.h", cname = "GST_VIDEO_TILE_Y_TILES_SHIFT")]
		public const int TILE_Y_TILES_SHIFT;
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type affine_transformation_meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? affine_transformation_meta_get_info ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool blend (Gst.Video.Frame dest, Gst.Video.Frame src, int x, int y, float global_alpha);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static void blend_scale_linear_RGBA (Gst.Video.Info src, Gst.Buffer src_buffer, int dest_height, int dest_width, out unowned Gst.Video.Info dest, out Gst.Buffer dest_buffer);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_affine_transformation_meta")]
		[Version (since = "1.8")]
		public static unowned Gst.Video.AffineTransformationMeta? buffer_add_video_affine_transformation_meta (Gst.Buffer buffer);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_gl_texture_upload_meta")]
		public static unowned Gst.Video.GLTextureUploadMeta? buffer_add_video_gl_texture_upload_meta (Gst.Buffer buffer, Gst.Video.GLTextureOrientation texture_orientation, uint n_textures, Gst.Video.GLTextureType texture_type, [CCode (delegate_target_pos = 5.5)] Gst.Video.GLTextureUpload upload, GLib.BoxedCopyFunc user_data_copy, GLib.BoxedFreeFunc user_data_free);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_meta")]
		public static unowned Gst.Video.Meta? buffer_add_video_meta (Gst.Buffer buffer, Gst.Video.FrameFlags flags, Gst.Video.Format format, uint width, uint height);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_meta_full")]
		public static unowned Gst.Video.Meta? buffer_add_video_meta_full (Gst.Buffer buffer, Gst.Video.FrameFlags flags, Gst.Video.Format format, uint width, uint height, uint n_planes, size_t offset, int stride);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_overlay_composition_meta")]
		public static unowned Gst.Video.OverlayCompositionMeta? buffer_add_video_overlay_composition_meta (Gst.Buffer buf, Gst.Video.OverlayComposition? comp);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_region_of_interest_meta")]
		public static unowned Gst.Video.RegionOfInterestMeta? buffer_add_video_region_of_interest_meta (Gst.Buffer buffer, string roi_type, uint x, uint y, uint w, uint h);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_region_of_interest_meta_id")]
		public static unowned Gst.Video.RegionOfInterestMeta? buffer_add_video_region_of_interest_meta_id (Gst.Buffer buffer, GLib.Quark roi_type, uint x, uint y, uint w, uint h);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_time_code_meta")]
		[Version (since = "1.10")]
		public static unowned Gst.Video.TimeCodeMeta? buffer_add_video_time_code_meta (Gst.Buffer buffer, Gst.Video.TimeCode tc);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_add_video_time_code_meta_full")]
		[Version (since = "1.10")]
		public static unowned Gst.Video.TimeCodeMeta? buffer_add_video_time_code_meta_full (Gst.Buffer buffer, uint fps_n, uint fps_d, GLib.DateTime latest_daily_jam, Gst.Video.TimeCodeFlags flags, uint hours, uint minutes, uint seconds, uint frames, uint field_count);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_get_video_meta")]
		public static unowned Gst.Video.Meta? buffer_get_video_meta (Gst.Buffer buffer);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_get_video_meta_id")]
		public static unowned Gst.Video.Meta? buffer_get_video_meta_id (Gst.Buffer buffer, int id);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_get_video_region_of_interest_meta_id")]
		public static unowned Gst.Video.RegionOfInterestMeta? buffer_get_video_region_of_interest_meta_id (Gst.Buffer buffer, int id);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_pool_config_get_video_alignment")]
		public static bool buffer_pool_config_get_video_alignment (Gst.Structure config, Gst.Video.Alignment align);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_buffer_pool_config_set_video_alignment")]
		public static void buffer_pool_config_set_video_alignment (Gst.Structure config, Gst.Video.Alignment align);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool calculate_display_ratio (out uint dar_n, out uint dar_d, uint video_width, uint video_height, uint video_par_n, uint video_par_d, uint display_par_n, uint display_par_d);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Video.ChromaSite chroma_from_string (string s);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned string chroma_to_string (Gst.Video.ChromaSite site);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static bool color_matrix_get_Kr_Kb (Gst.Video.ColorMatrix matrix, out double Kr, out double Kb);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned Gst.Video.ColorPrimariesInfo? color_primaries_get_info (Gst.Video.ColorPrimaries primaries);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static void color_range_offsets (Gst.Video.ColorRange range, Gst.Video.FormatInfo info, [CCode (array_length = false)] out int offset[4], [CCode (array_length = false)] out int scale[4]);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static double color_transfer_decode (Gst.Video.TransferFunction func, double val);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static double color_transfer_encode (Gst.Video.TransferFunction func, double val);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Sample convert_sample (Gst.Sample sample, Gst.Caps to_caps, Gst.ClockTime timeout) throws GLib.Error;
		[CCode (cheader_filename = "gst/video/video.h")]
		public static void convert_sample_async (Gst.Sample sample, Gst.Caps to_caps, Gst.ClockTime timeout, owned Gst.Video.ConvertSampleCallback callback);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type crop_meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? crop_meta_get_info ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool event_is_force_key_unit (Gst.Event event);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Event event_new_downstream_force_key_unit (Gst.ClockTime timestamp, Gst.ClockTime stream_time, Gst.ClockTime running_time, bool all_headers, uint count);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Event event_new_still_frame (bool in_still);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Event event_new_upstream_force_key_unit (Gst.ClockTime running_time, bool all_headers, uint count);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool event_parse_downstream_force_key_unit (Gst.Event event, out Gst.ClockTime timestamp, out Gst.ClockTime stream_time, out Gst.ClockTime running_time, out bool all_headers, out uint count);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool event_parse_still_frame (Gst.Event event, out bool in_still);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool event_parse_upstream_force_key_unit (Gst.Event event, out Gst.ClockTime running_time, out bool all_headers, out uint count);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.12")]
		public static Gst.Video.FieldOrder field_order_from_string (string order);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.12")]
		public static unowned string field_order_to_string (Gst.Video.FieldOrder order);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Video.Format format_from_fourcc (uint32 fourcc);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Video.Format format_from_masks (int depth, int bpp, int endianness, uint red_mask, uint green_mask, uint blue_mask, uint alpha_mask);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static Gst.Video.Format format_from_string (string format);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.Video.FormatInfo? format_get_info (Gst.Video.Format format);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.2")]
		public static void* format_get_palette (Gst.Video.Format format, out size_t size);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static uint32 format_to_fourcc (Gst.Video.Format format);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned string format_to_string (Gst.Video.Format format);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type gl_texture_upload_meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? gl_texture_upload_meta_get_info ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static bool guess_framerate (Gst.ClockTime duration, out int dest_n, out int dest_d);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static Gst.Video.InterlaceMode interlace_mode_from_string (string mode);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned string interlace_mode_to_string (Gst.Video.InterlaceMode mode);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_is_video_overlay_prepare_window_handle_message")]
		public static bool is_video_overlay_prepare_window_handle_message (Gst.Message msg);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? meta_get_info ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Quark meta_transform_scale_get_quark ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned GLib.Value? multiview_get_doubled_height_modes ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned GLib.Value? multiview_get_doubled_size_modes ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned GLib.Value? multiview_get_doubled_width_modes ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned GLib.Value? multiview_get_mono_modes ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned GLib.Value? multiview_get_unpacked_modes ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static bool multiview_guess_half_aspect (Gst.Video.MultiviewMode mv_mode, uint width, uint height, uint par_n, uint par_d);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static Gst.Video.MultiviewMode multiview_mode_from_caps_string (string caps_mview_mode);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static unowned string multiview_mode_to_caps_string (Gst.Video.MultiviewMode mview_mode);
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.6")]
		public static void multiview_video_info_change_mode (Gst.Video.Info info, Gst.Video.MultiviewMode out_mview_mode, Gst.Video.MultiviewFlags out_mview_flags);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_event_get_type")]
		public static Gst.Video.NavigationEventType navigation_event_get_type (Gst.Event event);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_event_parse_command")]
		public static bool navigation_event_parse_command (Gst.Event event, out Gst.Video.NavigationCommand command);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_event_parse_key_event")]
		public static bool navigation_event_parse_key_event (Gst.Event event, out unowned string key);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_event_parse_mouse_button_event")]
		public static bool navigation_event_parse_mouse_button_event (Gst.Event event, out int button, out double x, out double y);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_event_parse_mouse_move_event")]
		public static bool navigation_event_parse_mouse_move_event (Gst.Event event, out double x, out double y);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_get_type")]
		public static Gst.Video.NavigationMessageType navigation_message_get_type (Gst.Message message);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_new_angles_changed")]
		public static Gst.Message navigation_message_new_angles_changed (Gst.Object src, uint cur_angle, uint n_angles);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_new_commands_changed")]
		public static Gst.Message navigation_message_new_commands_changed (Gst.Object src);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_new_event")]
		[Version (since = "1.6")]
		public static Gst.Message navigation_message_new_event (Gst.Object src, Gst.Event event);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_new_mouse_over")]
		public static Gst.Message navigation_message_new_mouse_over (Gst.Object src, bool active);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_parse_angles_changed")]
		public static bool navigation_message_parse_angles_changed (Gst.Message message, out uint cur_angle, out uint n_angles);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_parse_event")]
		[Version (since = "1.6")]
		public static bool navigation_message_parse_event (Gst.Message message, out Gst.Event event);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_message_parse_mouse_over")]
		public static bool navigation_message_parse_mouse_over (Gst.Message message, out bool active);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_get_type")]
		public static Gst.Video.NavigationQueryType navigation_query_get_type (Gst.Query query);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_new_angles")]
		public static Gst.Query navigation_query_new_angles ();
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_new_commands")]
		public static Gst.Query navigation_query_new_commands ();
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_parse_angles")]
		public static bool navigation_query_parse_angles (Gst.Query query, out uint cur_angle, out uint n_angles);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_parse_commands_length")]
		public static bool navigation_query_parse_commands_length (Gst.Query query, out uint n_cmds);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_parse_commands_nth")]
		public static bool navigation_query_parse_commands_nth (Gst.Query query, uint nth, out Gst.Video.NavigationCommand cmd);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_set_angles")]
		public static void navigation_query_set_angles (Gst.Query query, uint cur_angle, uint n_angles);
		[CCode (cheader_filename = "gst/video/video.h", cname = "gst_navigation_query_set_commandsv")]
		public static void navigation_query_set_commandsv (Gst.Query query, [CCode (array_length_cname = "n_cmds", array_length_pos = 1.5)] Gst.Video.NavigationCommand[] cmds);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type overlay_composition_meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? overlay_composition_meta_get_info ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static void overlay_install_properties (GLib.ObjectClass oclass, int last_prop_id);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static bool overlay_set_property (GLib.Object object, int last_prop_id, uint property_id, GLib.Value value);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type region_of_interest_meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? region_of_interest_meta_get_info ();
		[CCode (cheader_filename = "gst/video/video.h")]
		[Version (since = "1.4")]
		public static uint tile_get_index (Gst.Video.TileMode mode, int x, int y, int x_tiles, int y_tiles);
		[CCode (cheader_filename = "gst/video/video.h")]
		public static GLib.Type time_code_meta_api_get_type ();
		[CCode (cheader_filename = "gst/video/video.h")]
		public static unowned Gst.MetaInfo? time_code_meta_get_info ();
	}
}
