/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};


static gpointer vala_object_creation_expression_parent_class = NULL;

#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaExpression* arg = NULL;
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			_arg_index = _arg_index + 1;
			_tmp13_ = _arg_index;
			_tmp14_ = _arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _arg_list;
			_tmp16_ = _arg_index;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			arg = (ValaExpression*) _tmp17_;
			_tmp18_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp18_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp19_;
		ValaList* _tmp20_;
		gint _init_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _init_index = 0;
		_tmp19_ = self->priv->object_initializer;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_init_list = _tmp20_;
		_tmp21_ = _init_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_init_size = _tmp23_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaMemberInitializer* _tmp29_;
			_init_index = _init_index + 1;
			_tmp24_ = _init_index;
			_tmp25_ = _init_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _init_list;
			_tmp27_ = _init_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			init = (ValaMemberInitializer*) _tmp28_;
			_tmp29_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	gint _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	_tmp1_ = index;
	if (_tmp1_ >= 0) {
		ValaList* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = index;
		vala_list_set (_tmp2_, _tmp3_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaExpression* arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaExpression* _tmp15_;
			_arg_index = _arg_index + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = _arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			arg = (ValaExpression*) _tmp14_;
			_tmp15_ = arg;
			if (!vala_expression_is_accessible (_tmp15_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _init_size = 0;
		ValaList* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _init_index = 0;
		_tmp16_ = self->priv->object_initializer;
		_tmp17_ = _vala_iterable_ref0 (_tmp16_);
		_init_list = _tmp17_;
		_tmp18_ = _init_list;
		_tmp19_ = vala_collection_get_size ((ValaCollection*) _tmp18_);
		_tmp20_ = _tmp19_;
		_init_size = _tmp20_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp21_;
			gint _tmp22_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp23_;
			gint _tmp24_;
			gpointer _tmp25_;
			ValaMemberInitializer* _tmp26_;
			ValaExpression* _tmp27_;
			ValaExpression* _tmp28_;
			_init_index = _init_index + 1;
			_tmp21_ = _init_index;
			_tmp22_ = _init_size;
			if (!(_tmp21_ < _tmp22_)) {
				break;
			}
			_tmp23_ = _init_list;
			_tmp24_ = _init_index;
			_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
			init = (ValaMemberInitializer*) _tmp25_;
			_tmp26_ = init;
			_tmp27_ = vala_member_initializer_get_initializer (_tmp26_);
			_tmp28_ = _tmp27_;
			if (!vala_expression_is_accessible (_tmp28_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp109_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp115_;
	ValaDataType* _tmp116_;
	ValaList* _tmp117_;
	ValaList* _tmp118_;
	gint _tmp119_;
	gint _tmp120_;
	gint _tmp121_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp122_;
	gint _tmp244_;
	gint _tmp245_;
	gboolean _tmp252_ = FALSE;
	ValaSymbol* _tmp253_;
	ValaSymbol* _tmp254_;
	ValaSymbol* _tmp266_;
	ValaSymbol* _tmp267_;
	gboolean _tmp544_;
	gboolean _tmp600_;
	gboolean _tmp601_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaSymbol* _tmp55_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		type_args = _tmp30_;
		_tmp31_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp31_)) {
			ValaSymbol* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp36_;
			ValaMethod* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp46_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp47_;
			ValaMemberAccess* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaMemberAccess* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp32_ = constructor_sym;
			_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _vala_code_node_ref0 (_tmp34_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp35_;
			_tmp36_ = constructor_sym;
			_tmp37_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp37_;
			_tmp38_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp38_)) {
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaMethod* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = constructor;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("`%s' is not a creation method", _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp40_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp46_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp46_);
			_tmp47_ = vala_object_creation_expression_get_member_name (self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_member_access_get_inner (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp50_) ? ((ValaMemberAccess*) _tmp50_) : NULL);
			ma = _tmp51_;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp54_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp55_ = type_sym;
		if (VALA_IS_CLASS (_tmp55_)) {
			ValaSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			gboolean _tmp59_;
			gboolean _tmp60_;
			_tmp56_ = type_sym;
			_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp57_;
			_tmp58_ = type;
			_tmp59_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_CLASS, ValaClass));
			_tmp60_ = _tmp59_;
			if (_tmp60_) {
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaErrorType* _tmp63_;
				ValaErrorType* _tmp64_;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_error_type_new (NULL, NULL, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp64_);
				_vala_code_node_unref0 (_tmp64_);
			} else {
				ValaTypeSymbol* _tmp65_;
				ValaObjectType* _tmp66_;
				ValaObjectType* _tmp67_;
				_tmp65_ = type;
				_tmp66_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CLASS, ValaClass));
				_tmp67_ = _tmp66_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
			}
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_STRUCT (_tmp68_)) {
				ValaSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaStructValueType* _tmp72_;
				ValaStructValueType* _tmp73_;
				_tmp69_ = type_sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp70_;
				_tmp71_ = type;
				_tmp72_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp73_ = _tmp72_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp73_);
				_vala_code_node_unref0 (_tmp73_);
			} else {
				ValaSymbol* _tmp74_;
				_tmp74_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp74_)) {
					ValaSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaErrorType* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaSymbol* _tmp83_;
					_tmp75_ = type_sym;
					_tmp76_ = vala_symbol_get_parent_symbol (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp80_);
					_tmp82_ = _tmp81_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp82_);
					_vala_code_node_unref0 (_tmp82_);
					_tmp83_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp83_);
				} else {
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					ValaSymbol* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					_tmp86_ = type_sym;
					_tmp87_ = vala_symbol_get_full_name (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp85_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp91_;
			ValaList* _tmp92_;
			gint _type_arg_size = 0;
			ValaList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _type_arg_index = 0;
			_tmp91_ = type_args;
			_tmp92_ = _vala_iterable_ref0 (_tmp91_);
			_type_arg_list = _tmp92_;
			_tmp93_ = _type_arg_list;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_type_arg_size = _tmp95_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp96_;
				gint _tmp97_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp98_;
				gint _tmp99_;
				gpointer _tmp100_;
				ValaDataType* _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				_type_arg_index = _type_arg_index + 1;
				_tmp96_ = _type_arg_index;
				_tmp97_ = _type_arg_size;
				if (!(_tmp96_ < _tmp97_)) {
					break;
				}
				_tmp98_ = _type_arg_list;
				_tmp99_ = _type_arg_index;
				_tmp100_ = vala_list_get (_tmp98_, _tmp99_);
				type_arg = (ValaDataType*) _tmp100_;
				_tmp101_ = vala_object_creation_expression_get_type_reference (self);
				_tmp102_ = _tmp101_;
				_tmp103_ = type_arg;
				vala_data_type_add_type_argument (_tmp102_, _tmp103_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp104_;
		ValaDataType* _tmp105_;
		ValaTypeSymbol* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		_tmp104_ = vala_object_creation_expression_get_type_reference (self);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_data_type_get_data_type (_tmp105_);
		_tmp107_ = _tmp106_;
		_tmp108_ = _vala_code_node_ref0 (_tmp107_);
		_vala_code_node_unref0 (type);
		type = _tmp108_;
	}
	_tmp109_ = vala_object_creation_expression_get_type_reference (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_data_type_copy (_tmp110_);
	_tmp112_ = _tmp111_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp112_);
	_vala_code_node_unref0 (_tmp112_);
	_tmp113_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp114_ = _tmp113_;
	vala_data_type_set_value_owned (_tmp114_, TRUE);
	may_throw = FALSE;
	_tmp115_ = vala_object_creation_expression_get_type_reference (self);
	_tmp116_ = _tmp115_;
	_tmp117_ = vala_data_type_get_type_arguments (_tmp116_);
	_tmp118_ = _tmp117_;
	_tmp119_ = vala_collection_get_size ((ValaCollection*) _tmp118_);
	_tmp120_ = _tmp119_;
	_tmp121_ = _tmp120_;
	_vala_iterable_unref0 (_tmp118_);
	given_num_type_args = _tmp121_;
	expected_num_type_args = 0;
	_tmp122_ = type;
	if (VALA_IS_CLASS (_tmp122_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp123_;
		ValaClass* _tmp124_;
		ValaClass* _tmp125_;
		ValaList* _tmp126_;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gboolean _tmp130_;
		ValaClass* _tmp133_;
		gboolean _tmp134_;
		gboolean _tmp135_;
		ValaSymbol* _tmp143_;
		ValaSymbol* _tmp144_;
		gboolean _tmp165_ = FALSE;
		ValaSymbol* _tmp166_;
		ValaSymbol* _tmp167_;
		_tmp123_ = type;
		_tmp124_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp123_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp124_;
		_tmp125_ = cl;
		_tmp126_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		expected_num_type_args = _tmp129_;
		_vala_iterable_unref0 (_tmp127_);
		_tmp130_ = self->priv->_struct_creation;
		if (_tmp130_) {
			ValaSourceReference* _tmp131_;
			ValaSourceReference* _tmp132_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp131_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp132_ = _tmp131_;
			vala_report_error (_tmp132_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp133_ = cl;
		_tmp134_ = vala_class_get_is_abstract (_tmp133_);
		_tmp135_ = _tmp134_;
		if (_tmp135_) {
			ValaSourceReference* _tmp136_;
			ValaSourceReference* _tmp137_;
			ValaClass* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp136_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp137_ = _tmp136_;
			_tmp138_ = cl;
			_tmp139_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp140_);
			_tmp142_ = _tmp141_;
			vala_report_error (_tmp137_, _tmp142_);
			_g_free0 (_tmp142_);
			_g_free0 (_tmp140_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp143_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp144_ = _tmp143_;
		if (_tmp144_ == NULL) {
			ValaClass* _tmp145_;
			ValaCreationMethod* _tmp146_;
			ValaCreationMethod* _tmp147_;
			ValaSymbol* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp157_;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaVersionAttribute* _tmp161_;
			ValaVersionAttribute* _tmp162_;
			ValaSourceReference* _tmp163_;
			ValaSourceReference* _tmp164_;
			_tmp145_ = cl;
			_tmp146_ = vala_class_get_default_construction_method (_tmp145_);
			_tmp147_ = _tmp146_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp147_);
			_tmp148_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp149_ = _tmp148_;
			if (_tmp149_ == NULL) {
				ValaSourceReference* _tmp150_;
				ValaSourceReference* _tmp151_;
				ValaClass* _tmp152_;
				gchar* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp151_ = _tmp150_;
				_tmp152_ = cl;
				_tmp153_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp152_);
				_tmp154_ = _tmp153_;
				_tmp155_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp154_);
				_tmp156_ = _tmp155_;
				vala_report_error (_tmp151_, _tmp156_);
				_g_free0 (_tmp156_);
				_g_free0 (_tmp154_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp157_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp158_ = _tmp157_;
			vala_symbol_set_used (_tmp158_, TRUE);
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			_tmp161_ = vala_symbol_get_version (_tmp160_);
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp164_ = _tmp163_;
			vala_version_attribute_check (_tmp162_, _tmp164_);
		}
		_tmp166_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp167_ = _tmp166_;
		if (_tmp167_ != NULL) {
			gboolean _tmp168_ = FALSE;
			ValaSymbol* _tmp169_;
			ValaSymbol* _tmp170_;
			ValaSymbolAccessibility _tmp171_;
			ValaSymbolAccessibility _tmp172_;
			_tmp169_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_symbol_get_access (_tmp170_);
			_tmp172_ = _tmp171_;
			if (_tmp172_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp168_ = TRUE;
			} else {
				ValaSymbol* _tmp173_;
				ValaSymbol* _tmp174_;
				ValaSymbolAccessibility _tmp175_;
				ValaSymbolAccessibility _tmp176_;
				_tmp173_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp174_ = _tmp173_;
				_tmp175_ = vala_symbol_get_access (_tmp174_);
				_tmp176_ = _tmp175_;
				_tmp168_ = _tmp176_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp165_ = _tmp168_;
		} else {
			_tmp165_ = FALSE;
		}
		if (_tmp165_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp190_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp177_;
				ValaSemanticAnalyzer* _tmp178_;
				ValaSymbol* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				_tmp177_ = vala_code_context_get_analyzer (context);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_semantic_analyzer_get_current_symbol (_tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = _vala_code_node_ref0 (_tmp180_);
				this_symbol = _tmp181_;
				{
					gboolean _tmp182_ = FALSE;
					_tmp182_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp187_;
						ValaSymbol* _tmp188_;
						ValaClass* _tmp189_;
						if (!_tmp182_) {
							ValaSymbol* _tmp183_;
							ValaSymbol* _tmp184_;
							ValaSymbol* _tmp185_;
							ValaSymbol* _tmp186_;
							_tmp183_ = this_symbol;
							_tmp184_ = vala_symbol_get_parent_symbol (_tmp183_);
							_tmp185_ = _tmp184_;
							_tmp186_ = _vala_code_node_ref0 (_tmp185_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp186_;
						}
						_tmp182_ = FALSE;
						_tmp187_ = this_symbol;
						if (!(_tmp187_ != NULL)) {
							break;
						}
						_tmp188_ = this_symbol;
						_tmp189_ = cl;
						if (_tmp188_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp189_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp190_ = in_target_type;
			if (!_tmp190_) {
				ValaSourceReference* _tmp191_;
				ValaSourceReference* _tmp192_;
				ValaSymbol* _tmp193_;
				ValaSymbol* _tmp194_;
				gchar* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				gchar* _tmp198_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp192_ = _tmp191_;
				_tmp193_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_symbol_get_full_name (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp196_);
				_tmp198_ = _tmp197_;
				vala_report_error (_tmp192_, _tmp198_);
				_g_free0 (_tmp198_);
				_g_free0 (_tmp196_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp199_;
			ValaClass* _tmp200_;
			gchar* _tmp201_;
			gchar* _tmp202_;
			gboolean _tmp203_;
			ValaClass* _tmp206_;
			ValaClass* _tmp207_;
			ValaClass* _tmp208_;
			ValaClass* _tmp209_;
			_tmp199_ = cl;
			if (!(_tmp199_ != NULL)) {
				break;
			}
			_tmp200_ = cl;
			_tmp201_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp200_, "CCode", "ref_sink_function", NULL);
			_tmp202_ = _tmp201_;
			_tmp203_ = _tmp202_ != NULL;
			_g_free0 (_tmp202_);
			if (_tmp203_) {
				ValaDataType* _tmp204_;
				ValaDataType* _tmp205_;
				_tmp204_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp205_ = _tmp204_;
				vala_data_type_set_floating_reference (_tmp205_, TRUE);
				break;
			}
			_tmp206_ = cl;
			_tmp207_ = vala_class_get_base_class (_tmp206_);
			_tmp208_ = _tmp207_;
			_tmp209_ = _vala_code_node_ref0 (_tmp208_);
			_vala_code_node_unref0 (cl);
			cl = _tmp209_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp210_;
		_tmp210_ = type;
		if (VALA_IS_STRUCT (_tmp210_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp211_;
			ValaStruct* _tmp212_;
			ValaStruct* _tmp213_;
			ValaList* _tmp214_;
			ValaList* _tmp215_;
			gint _tmp216_;
			gint _tmp217_;
			gboolean _tmp218_ = FALSE;
			gboolean _tmp219_;
			ValaSymbol* _tmp224_;
			ValaSymbol* _tmp225_;
			gboolean _tmp229_ = FALSE;
			gboolean _tmp230_ = FALSE;
			ValaStruct* _tmp231_;
			_tmp211_ = type;
			_tmp212_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp211_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp212_;
			_tmp213_ = st;
			_tmp214_ = vala_struct_get_type_parameters (_tmp213_);
			_tmp215_ = _tmp214_;
			_tmp216_ = vala_collection_get_size ((ValaCollection*) _tmp215_);
			_tmp217_ = _tmp216_;
			expected_num_type_args = _tmp217_;
			_vala_iterable_unref0 (_tmp215_);
			_tmp219_ = self->priv->_struct_creation;
			if (!_tmp219_) {
				gboolean _tmp220_;
				gboolean _tmp221_;
				_tmp220_ = vala_code_context_get_deprecated (context);
				_tmp221_ = _tmp220_;
				_tmp218_ = !_tmp221_;
			} else {
				_tmp218_ = FALSE;
			}
			if (_tmp218_) {
				ValaSourceReference* _tmp222_;
				ValaSourceReference* _tmp223_;
				_tmp222_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp223_ = _tmp222_;
				vala_report_warning (_tmp223_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp224_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp225_ = _tmp224_;
			if (_tmp225_ == NULL) {
				ValaStruct* _tmp226_;
				ValaMethod* _tmp227_;
				ValaMethod* _tmp228_;
				_tmp226_ = st;
				_tmp227_ = vala_struct_get_default_construction_method (_tmp226_);
				_tmp228_ = _tmp227_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp228_);
			}
			_tmp231_ = st;
			if (vala_struct_is_simple_type (_tmp231_)) {
				ValaSymbol* _tmp232_;
				ValaSymbol* _tmp233_;
				_tmp232_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp233_ = _tmp232_;
				_tmp230_ = _tmp233_ == NULL;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaList* _tmp234_;
				gint _tmp235_;
				gint _tmp236_;
				_tmp234_ = self->priv->object_initializer;
				_tmp235_ = vala_collection_get_size ((ValaCollection*) _tmp234_);
				_tmp236_ = _tmp235_;
				_tmp229_ = _tmp236_ == 0;
			} else {
				_tmp229_ = FALSE;
			}
			if (_tmp229_) {
				ValaSourceReference* _tmp237_;
				ValaSourceReference* _tmp238_;
				ValaStruct* _tmp239_;
				gchar* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp238_ = _tmp237_;
				_tmp239_ = st;
				_tmp240_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp241_);
				_tmp243_ = _tmp242_;
				vala_report_error (_tmp238_, _tmp243_);
				_g_free0 (_tmp243_);
				_g_free0 (_tmp241_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp244_ = expected_num_type_args;
	_tmp245_ = given_num_type_args;
	if (_tmp244_ > _tmp245_) {
		ValaSourceReference* _tmp246_;
		ValaSourceReference* _tmp247_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp246_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp247_ = _tmp246_;
		vala_report_error (_tmp247_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp248_;
		gint _tmp249_;
		_tmp248_ = expected_num_type_args;
		_tmp249_ = given_num_type_args;
		if (_tmp248_ < _tmp249_) {
			ValaSourceReference* _tmp250_;
			ValaSourceReference* _tmp251_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp251_ = _tmp250_;
			vala_report_error (_tmp251_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp253_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp254_ = _tmp253_;
	if (_tmp254_ == NULL) {
		ValaList* _tmp255_;
		ValaList* _tmp256_;
		gint _tmp257_;
		gint _tmp258_;
		_tmp255_ = vala_object_creation_expression_get_argument_list (self);
		_tmp256_ = _tmp255_;
		_tmp257_ = vala_collection_get_size ((ValaCollection*) _tmp256_);
		_tmp258_ = _tmp257_;
		_tmp252_ = _tmp258_ != 0;
		_vala_iterable_unref0 (_tmp256_);
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		ValaSourceReference* _tmp259_;
		ValaSourceReference* _tmp260_;
		ValaTypeSymbol* _tmp261_;
		gchar* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		gchar* _tmp265_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp259_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp260_ = _tmp259_;
		_tmp261_ = type;
		_tmp262_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp261_);
		_tmp263_ = _tmp262_;
		_tmp264_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp263_);
		_tmp265_ = _tmp264_;
		vala_report_error (_tmp260_, _tmp265_);
		_g_free0 (_tmp265_);
		_g_free0 (_tmp263_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp266_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp267_ = _tmp266_;
	if (VALA_IS_METHOD (_tmp267_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp268_;
		ValaSymbol* _tmp269_;
		ValaMethod* _tmp270_;
		gboolean _tmp271_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp296_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp297_;
		ValaIterator* _tmp298_;
		ValaMethod* _tmp330_;
		gboolean _tmp331_;
		gboolean _tmp332_;
		ValaSemanticAnalyzer* _tmp395_;
		ValaSemanticAnalyzer* _tmp396_;
		ValaMethod* _tmp397_;
		ValaMethodType* _tmp398_;
		ValaMethodType* _tmp399_;
		ValaMethod* _tmp400_;
		ValaList* _tmp401_;
		ValaList* _tmp402_;
		ValaList* _tmp403_;
		_tmp268_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp269_ = _tmp268_;
		_tmp270_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp269_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp270_;
		_tmp271_ = self->priv->_is_yield_expression;
		if (_tmp271_) {
			ValaMethod* _tmp272_;
			gboolean _tmp273_;
			gboolean _tmp274_;
			gboolean _tmp277_ = FALSE;
			ValaSemanticAnalyzer* _tmp278_;
			ValaSemanticAnalyzer* _tmp279_;
			ValaMethod* _tmp280_;
			ValaMethod* _tmp281_;
			_tmp272_ = m;
			_tmp273_ = vala_method_get_coroutine (_tmp272_);
			_tmp274_ = _tmp273_;
			if (!_tmp274_) {
				ValaSourceReference* _tmp275_;
				ValaSourceReference* _tmp276_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp275_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp276_ = _tmp275_;
				vala_report_error (_tmp276_, "yield expression requires async method");
			}
			_tmp278_ = vala_code_context_get_analyzer (context);
			_tmp279_ = _tmp278_;
			_tmp280_ = vala_semantic_analyzer_get_current_method (_tmp279_);
			_tmp281_ = _tmp280_;
			if (_tmp281_ == NULL) {
				_tmp277_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp282_;
				ValaSemanticAnalyzer* _tmp283_;
				ValaMethod* _tmp284_;
				ValaMethod* _tmp285_;
				gboolean _tmp286_;
				gboolean _tmp287_;
				_tmp282_ = vala_code_context_get_analyzer (context);
				_tmp283_ = _tmp282_;
				_tmp284_ = vala_semantic_analyzer_get_current_method (_tmp283_);
				_tmp285_ = _tmp284_;
				_tmp286_ = vala_method_get_coroutine (_tmp285_);
				_tmp287_ = _tmp286_;
				_tmp277_ = !_tmp287_;
			}
			if (_tmp277_) {
				ValaSourceReference* _tmp288_;
				ValaSourceReference* _tmp289_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp288_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp289_ = _tmp288_;
				vala_report_error (_tmp289_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp290_;
			_tmp290_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp290_)) {
				ValaMethod* _tmp291_;
				gboolean _tmp292_;
				gboolean _tmp293_;
				_tmp291_ = m;
				_tmp292_ = vala_method_get_coroutine (_tmp291_);
				_tmp293_ = _tmp292_;
				if (_tmp293_) {
					ValaSourceReference* _tmp294_;
					ValaSourceReference* _tmp295_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp294_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp295_ = _tmp294_;
					vala_report_error (_tmp295_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp296_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp296_;
		_tmp297_ = args;
		_tmp298_ = vala_iterable_iterator ((ValaIterable*) _tmp297_);
		arg_it = _tmp298_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp299_;
			ValaList* _tmp300_;
			gint _param_size = 0;
			ValaList* _tmp301_;
			gint _tmp302_;
			gint _tmp303_;
			gint _param_index = 0;
			_tmp299_ = m;
			_tmp300_ = vala_callable_get_parameters ((ValaCallable*) _tmp299_);
			_param_list = _tmp300_;
			_tmp301_ = _param_list;
			_tmp302_ = vala_collection_get_size ((ValaCollection*) _tmp301_);
			_tmp303_ = _tmp302_;
			_param_size = _tmp303_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp304_;
				gint _tmp305_;
				ValaParameter* param = NULL;
				ValaList* _tmp306_;
				gint _tmp307_;
				gpointer _tmp308_;
				ValaParameter* _tmp309_;
				ValaParameter* _tmp310_;
				gboolean _tmp311_;
				gboolean _tmp312_;
				ValaIterator* _tmp313_;
				_param_index = _param_index + 1;
				_tmp304_ = _param_index;
				_tmp305_ = _param_size;
				if (!(_tmp304_ < _tmp305_)) {
					break;
				}
				_tmp306_ = _param_list;
				_tmp307_ = _param_index;
				_tmp308_ = vala_list_get (_tmp306_, _tmp307_);
				param = (ValaParameter*) _tmp308_;
				_tmp309_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp309_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp310_ = param;
				_tmp311_ = vala_parameter_get_ellipsis (_tmp310_);
				_tmp312_ = _tmp311_;
				if (_tmp312_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp313_ = arg_it;
				if (vala_iterator_next (_tmp313_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp314_;
					gpointer _tmp315_;
					ValaExpression* _tmp316_;
					ValaParameter* _tmp317_;
					ValaDataType* _tmp318_;
					ValaDataType* _tmp319_;
					ValaExpression* _tmp320_;
					ValaExpression* _tmp321_;
					ValaDataType* _tmp322_;
					ValaDataType* _tmp323_;
					ValaDataType* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaDataType* _tmp327_;
					ValaExpression* _tmp328_;
					ValaExpression* _tmp329_;
					_tmp314_ = arg_it;
					_tmp315_ = vala_iterator_get (_tmp314_);
					arg = (ValaExpression*) _tmp315_;
					_tmp316_ = arg;
					_tmp317_ = param;
					_tmp318_ = vala_variable_get_variable_type ((ValaVariable*) _tmp317_);
					_tmp319_ = _tmp318_;
					vala_expression_set_formal_target_type (_tmp316_, _tmp319_);
					_tmp320_ = arg;
					_tmp321_ = arg;
					_tmp322_ = vala_expression_get_formal_target_type (_tmp321_);
					_tmp323_ = _tmp322_;
					_tmp324_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp325_ = _tmp324_;
					_tmp326_ = vala_data_type_get_actual_type (_tmp323_, _tmp325_, NULL, (ValaCodeNode*) self);
					_tmp327_ = _tmp326_;
					vala_expression_set_target_type (_tmp320_, _tmp327_);
					_vala_code_node_unref0 (_tmp327_);
					_tmp328_ = arg;
					_tmp329_ = _vala_code_node_ref0 (_tmp328_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp329_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp330_ = m;
		_tmp331_ = vala_method_get_printf_format (_tmp330_);
		_tmp332_ = _tmp331_;
		if (_tmp332_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp333_;
			ValaStringLiteral* _tmp375_;
			format_literal = NULL;
			_tmp333_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp333_)) {
			} else {
				ValaExpression* _tmp334_;
				_tmp334_ = last_arg;
				if (_tmp334_ != NULL) {
					ValaExpression* _tmp335_;
					ValaStringLiteral* _tmp336_;
					gboolean _tmp337_ = FALSE;
					ValaStringLiteral* _tmp338_;
					_tmp335_ = last_arg;
					_tmp336_ = vala_string_literal_get_format_literal (_tmp335_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp336_;
					_tmp338_ = format_literal;
					if (_tmp338_ == NULL) {
						ValaList* _tmp339_;
						gint _tmp340_;
						gint _tmp341_;
						ValaMethod* _tmp342_;
						ValaList* _tmp343_;
						ValaList* _tmp344_;
						gint _tmp345_;
						gint _tmp346_;
						_tmp339_ = args;
						_tmp340_ = vala_collection_get_size ((ValaCollection*) _tmp339_);
						_tmp341_ = _tmp340_;
						_tmp342_ = m;
						_tmp343_ = vala_callable_get_parameters ((ValaCallable*) _tmp342_);
						_tmp344_ = _tmp343_;
						_tmp345_ = vala_collection_get_size ((ValaCollection*) _tmp344_);
						_tmp346_ = _tmp345_;
						_tmp337_ = _tmp341_ == (_tmp346_ - 1);
						_vala_iterable_unref0 (_tmp344_);
					} else {
						_tmp337_ = FALSE;
					}
					if (_tmp337_) {
						ValaStringLiteral* _tmp347_;
						ValaStringLiteral* _tmp348_;
						ValaSemanticAnalyzer* _tmp349_;
						ValaSemanticAnalyzer* _tmp350_;
						ValaDataType* _tmp351_;
						ValaDataType* _tmp352_;
						ValaDataType* _tmp353_;
						ValaList* _tmp354_;
						ValaList* _tmp355_;
						gint _tmp356_;
						gint _tmp357_;
						ValaStringLiteral* _tmp358_;
						ValaList* _tmp359_;
						ValaIterator* _tmp360_;
						_tmp347_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp347_;
						_tmp348_ = format_literal;
						_tmp349_ = vala_code_context_get_analyzer (context);
						_tmp350_ = _tmp349_;
						_tmp351_ = _tmp350_->string_type;
						_tmp352_ = vala_data_type_copy (_tmp351_);
						_tmp353_ = _tmp352_;
						vala_expression_set_target_type ((ValaExpression*) _tmp348_, _tmp353_);
						_vala_code_node_unref0 (_tmp353_);
						_tmp354_ = self->priv->argument_list;
						_tmp355_ = args;
						_tmp356_ = vala_collection_get_size ((ValaCollection*) _tmp355_);
						_tmp357_ = _tmp356_;
						_tmp358_ = format_literal;
						vala_list_insert (_tmp354_, _tmp357_ - 1, (ValaExpression*) _tmp358_);
						_tmp359_ = self->priv->argument_list;
						_tmp360_ = vala_iterable_iterator ((ValaIterable*) _tmp359_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp360_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp361_;
							ValaList* _tmp362_;
							gint _param_size = 0;
							ValaList* _tmp363_;
							gint _tmp364_;
							gint _tmp365_;
							gint _param_index = 0;
							_tmp361_ = m;
							_tmp362_ = vala_callable_get_parameters ((ValaCallable*) _tmp361_);
							_param_list = _tmp362_;
							_tmp363_ = _param_list;
							_tmp364_ = vala_collection_get_size ((ValaCollection*) _tmp363_);
							_tmp365_ = _tmp364_;
							_param_size = _tmp365_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp366_;
								gint _tmp367_;
								ValaParameter* param = NULL;
								ValaList* _tmp368_;
								gint _tmp369_;
								gpointer _tmp370_;
								ValaParameter* _tmp371_;
								gboolean _tmp372_;
								gboolean _tmp373_;
								ValaIterator* _tmp374_;
								_param_index = _param_index + 1;
								_tmp366_ = _param_index;
								_tmp367_ = _param_size;
								if (!(_tmp366_ < _tmp367_)) {
									break;
								}
								_tmp368_ = _param_list;
								_tmp369_ = _param_index;
								_tmp370_ = vala_list_get (_tmp368_, _tmp369_);
								param = (ValaParameter*) _tmp370_;
								_tmp371_ = param;
								_tmp372_ = vala_parameter_get_ellipsis (_tmp371_);
								_tmp373_ = _tmp372_;
								if (_tmp373_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp374_ = arg_it;
								vala_iterator_next (_tmp374_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp375_ = format_literal;
			if (_tmp375_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp376_;
				gchar* _tmp377_;
				ValaSemanticAnalyzer* _tmp378_;
				ValaSemanticAnalyzer* _tmp379_;
				const gchar* _tmp380_;
				ValaIterator* _tmp381_;
				ValaSourceReference* _tmp382_;
				ValaSourceReference* _tmp383_;
				_tmp376_ = format_literal;
				_tmp377_ = vala_string_literal_eval (_tmp376_);
				format = _tmp377_;
				_tmp378_ = vala_code_context_get_analyzer (context);
				_tmp379_ = _tmp378_;
				_tmp380_ = format;
				_tmp381_ = arg_it;
				_tmp382_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp383_ = _tmp382_;
				if (!vala_semantic_analyzer_check_print_format (_tmp379_, _tmp380_, _tmp381_, _tmp383_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp384_;
			ValaList* _tmp385_;
			gint _arg_size = 0;
			ValaList* _tmp386_;
			gint _tmp387_;
			gint _tmp388_;
			gint _arg_index = 0;
			_tmp384_ = args;
			_tmp385_ = _vala_iterable_ref0 (_tmp384_);
			_arg_list = _tmp385_;
			_tmp386_ = _arg_list;
			_tmp387_ = vala_collection_get_size ((ValaCollection*) _tmp386_);
			_tmp388_ = _tmp387_;
			_arg_size = _tmp388_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp389_;
				gint _tmp390_;
				ValaExpression* arg = NULL;
				ValaList* _tmp391_;
				gint _tmp392_;
				gpointer _tmp393_;
				ValaExpression* _tmp394_;
				_arg_index = _arg_index + 1;
				_tmp389_ = _arg_index;
				_tmp390_ = _arg_size;
				if (!(_tmp389_ < _tmp390_)) {
					break;
				}
				_tmp391_ = _arg_list;
				_tmp392_ = _arg_index;
				_tmp393_ = vala_list_get (_tmp391_, _tmp392_);
				arg = (ValaExpression*) _tmp393_;
				_tmp394_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp394_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp395_ = vala_code_context_get_analyzer (context);
		_tmp396_ = _tmp395_;
		_tmp397_ = m;
		_tmp398_ = vala_method_type_new (_tmp397_);
		_tmp399_ = _tmp398_;
		_tmp400_ = m;
		_tmp401_ = vala_callable_get_parameters ((ValaCallable*) _tmp400_);
		_tmp402_ = _tmp401_;
		_tmp403_ = args;
		vala_semantic_analyzer_check_arguments (_tmp396_, (ValaExpression*) self, (ValaDataType*) _tmp399_, _tmp402_, _tmp403_);
		_vala_iterable_unref0 (_tmp402_);
		_vala_code_node_unref0 (_tmp399_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp404_;
			ValaList* _tmp405_;
			gint _error_type_size = 0;
			ValaList* _tmp406_;
			gint _tmp407_;
			gint _tmp408_;
			gint _error_type_index = 0;
			_tmp404_ = m;
			_tmp405_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp404_);
			_error_type_list = _tmp405_;
			_tmp406_ = _error_type_list;
			_tmp407_ = vala_collection_get_size ((ValaCollection*) _tmp406_);
			_tmp408_ = _tmp407_;
			_error_type_size = _tmp408_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp409_;
				gint _tmp410_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp411_;
				gint _tmp412_;
				gpointer _tmp413_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp414_;
				ValaDataType* _tmp415_;
				ValaDataType* _tmp416_;
				ValaSourceReference* _tmp417_;
				ValaSourceReference* _tmp418_;
				ValaDataType* _tmp419_;
				_error_type_index = _error_type_index + 1;
				_tmp409_ = _error_type_index;
				_tmp410_ = _error_type_size;
				if (!(_tmp409_ < _tmp410_)) {
					break;
				}
				_tmp411_ = _error_type_list;
				_tmp412_ = _error_type_index;
				_tmp413_ = vala_list_get (_tmp411_, _tmp412_);
				error_type = (ValaDataType*) _tmp413_;
				may_throw = TRUE;
				_tmp414_ = error_type;
				_tmp415_ = vala_data_type_copy (_tmp414_);
				call_error_type = _tmp415_;
				_tmp416_ = call_error_type;
				_tmp417_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp418_ = _tmp417_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp416_, _tmp418_);
				_tmp419_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp419_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp420_;
		ValaDataType* _tmp421_;
		_tmp420_ = vala_object_creation_expression_get_type_reference (self);
		_tmp421_ = _tmp420_;
		if (VALA_IS_ERROR_TYPE (_tmp421_)) {
			ValaDataType* _tmp422_;
			ValaDataType* _tmp423_;
			ValaMemberAccess* _tmp426_;
			ValaMemberAccess* _tmp427_;
			ValaList* _tmp452_;
			ValaList* _tmp453_;
			gint _tmp454_;
			gint _tmp455_;
			gboolean _tmp456_;
			_tmp422_ = vala_object_creation_expression_get_type_reference (self);
			_tmp423_ = _tmp422_;
			if (_tmp423_ != NULL) {
				ValaDataType* _tmp424_;
				ValaDataType* _tmp425_;
				_tmp424_ = vala_object_creation_expression_get_type_reference (self);
				_tmp425_ = _tmp424_;
				vala_code_node_check ((ValaCodeNode*) _tmp425_, context);
			}
			_tmp426_ = vala_object_creation_expression_get_member_name (self);
			_tmp427_ = _tmp426_;
			if (_tmp427_ != NULL) {
				ValaMemberAccess* _tmp428_;
				ValaMemberAccess* _tmp429_;
				_tmp428_ = vala_object_creation_expression_get_member_name (self);
				_tmp429_ = _tmp428_;
				vala_code_node_check ((ValaCodeNode*) _tmp429_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp430_;
				ValaList* _tmp431_;
				gint _arg_size = 0;
				ValaList* _tmp432_;
				gint _tmp433_;
				gint _tmp434_;
				gint _arg_index = 0;
				_tmp430_ = self->priv->argument_list;
				_tmp431_ = _vala_iterable_ref0 (_tmp430_);
				_arg_list = _tmp431_;
				_tmp432_ = _arg_list;
				_tmp433_ = vala_collection_get_size ((ValaCollection*) _tmp432_);
				_tmp434_ = _tmp433_;
				_arg_size = _tmp434_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp435_;
					gint _tmp436_;
					ValaExpression* arg = NULL;
					ValaList* _tmp437_;
					gint _tmp438_;
					gpointer _tmp439_;
					ValaExpression* _tmp440_;
					_arg_index = _arg_index + 1;
					_tmp435_ = _arg_index;
					_tmp436_ = _arg_size;
					if (!(_tmp435_ < _tmp436_)) {
						break;
					}
					_tmp437_ = _arg_list;
					_tmp438_ = _arg_index;
					_tmp439_ = vala_list_get (_tmp437_, _tmp438_);
					arg = (ValaExpression*) _tmp439_;
					_tmp440_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp440_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp441_;
				ValaList* _tmp442_;
				gint _init_size = 0;
				ValaList* _tmp443_;
				gint _tmp444_;
				gint _tmp445_;
				gint _init_index = 0;
				_tmp441_ = self->priv->object_initializer;
				_tmp442_ = _vala_iterable_ref0 (_tmp441_);
				_init_list = _tmp442_;
				_tmp443_ = _init_list;
				_tmp444_ = vala_collection_get_size ((ValaCollection*) _tmp443_);
				_tmp445_ = _tmp444_;
				_init_size = _tmp445_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp446_;
					gint _tmp447_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp448_;
					gint _tmp449_;
					gpointer _tmp450_;
					ValaMemberInitializer* _tmp451_;
					_init_index = _init_index + 1;
					_tmp446_ = _init_index;
					_tmp447_ = _init_size;
					if (!(_tmp446_ < _tmp447_)) {
						break;
					}
					_tmp448_ = _init_list;
					_tmp449_ = _init_index;
					_tmp450_ = vala_list_get (_tmp448_, _tmp449_);
					init = (ValaMemberInitializer*) _tmp450_;
					_tmp451_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp451_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp452_ = vala_object_creation_expression_get_argument_list (self);
			_tmp453_ = _tmp452_;
			_tmp454_ = vala_collection_get_size ((ValaCollection*) _tmp453_);
			_tmp455_ = _tmp454_;
			_tmp456_ = _tmp455_ == 0;
			_vala_iterable_unref0 (_tmp453_);
			if (_tmp456_) {
				ValaSourceReference* _tmp457_;
				ValaSourceReference* _tmp458_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp457_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp458_ = _tmp457_;
				vala_report_error (_tmp458_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp459_;
				ValaList* _tmp460_;
				ValaIterator* _tmp461_;
				ValaIterator* _tmp462_;
				ValaIterator* _tmp463_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp464_;
				gpointer _tmp465_;
				gboolean _tmp466_ = FALSE;
				ValaExpression* _tmp467_;
				ValaDataType* _tmp468_;
				ValaDataType* _tmp469_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp478_;
				ValaStringLiteral* _tmp479_;
				ValaStringLiteral* _tmp480_;
				ValaList* _tmp489_;
				ValaList* _tmp490_;
				ValaIterator* _tmp491_;
				ValaIterator* _tmp492_;
				ValaSemanticAnalyzer* _tmp493_;
				ValaSemanticAnalyzer* _tmp494_;
				ValaIterator* _tmp495_;
				ValaSourceReference* _tmp496_;
				ValaSourceReference* _tmp497_;
				_tmp459_ = vala_object_creation_expression_get_argument_list (self);
				_tmp460_ = _tmp459_;
				_tmp461_ = vala_iterable_iterator ((ValaIterable*) _tmp460_);
				_tmp462_ = _tmp461_;
				_vala_iterable_unref0 (_tmp460_);
				arg_it = _tmp462_;
				_tmp463_ = arg_it;
				vala_iterator_next (_tmp463_);
				_tmp464_ = arg_it;
				_tmp465_ = vala_iterator_get (_tmp464_);
				ex = (ValaExpression*) _tmp465_;
				_tmp467_ = ex;
				_tmp468_ = vala_expression_get_value_type (_tmp467_);
				_tmp469_ = _tmp468_;
				if (_tmp469_ == NULL) {
					_tmp466_ = TRUE;
				} else {
					ValaExpression* _tmp470_;
					ValaDataType* _tmp471_;
					ValaDataType* _tmp472_;
					ValaSemanticAnalyzer* _tmp473_;
					ValaSemanticAnalyzer* _tmp474_;
					ValaDataType* _tmp475_;
					_tmp470_ = ex;
					_tmp471_ = vala_expression_get_value_type (_tmp470_);
					_tmp472_ = _tmp471_;
					_tmp473_ = vala_code_context_get_analyzer (context);
					_tmp474_ = _tmp473_;
					_tmp475_ = _tmp474_->string_type;
					_tmp466_ = !vala_data_type_compatible (_tmp472_, _tmp475_);
				}
				if (_tmp466_) {
					ValaSourceReference* _tmp476_;
					ValaSourceReference* _tmp477_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp476_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp477_ = _tmp476_;
					vala_report_error (_tmp477_, "Invalid type for argument 1");
				}
				_tmp478_ = ex;
				_tmp479_ = vala_string_literal_get_format_literal (_tmp478_);
				format_literal = _tmp479_;
				_tmp480_ = format_literal;
				if (_tmp480_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp481_;
					gchar* _tmp482_;
					ValaSemanticAnalyzer* _tmp483_;
					ValaSemanticAnalyzer* _tmp484_;
					const gchar* _tmp485_;
					ValaIterator* _tmp486_;
					ValaSourceReference* _tmp487_;
					ValaSourceReference* _tmp488_;
					_tmp481_ = format_literal;
					_tmp482_ = vala_string_literal_eval (_tmp481_);
					format = _tmp482_;
					_tmp483_ = vala_code_context_get_analyzer (context);
					_tmp484_ = _tmp483_;
					_tmp485_ = format;
					_tmp486_ = arg_it;
					_tmp487_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp488_ = _tmp487_;
					if (!vala_semantic_analyzer_check_print_format (_tmp484_, _tmp485_, _tmp486_, _tmp488_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp489_ = vala_object_creation_expression_get_argument_list (self);
				_tmp490_ = _tmp489_;
				_tmp491_ = vala_iterable_iterator ((ValaIterable*) _tmp490_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp491_;
				_vala_iterable_unref0 (_tmp490_);
				_tmp492_ = arg_it;
				vala_iterator_next (_tmp492_);
				_tmp493_ = vala_code_context_get_analyzer (context);
				_tmp494_ = _tmp493_;
				_tmp495_ = arg_it;
				_tmp496_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp497_ = _tmp496_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp494_, _tmp495_, 1, _tmp497_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp498_;
		gint _arg_size = 0;
		ValaList* _tmp499_;
		gint _tmp500_;
		gint _tmp501_;
		gint _arg_index = 0;
		_tmp498_ = vala_object_creation_expression_get_argument_list (self);
		_arg_list = _tmp498_;
		_tmp499_ = _arg_list;
		_tmp500_ = vala_collection_get_size ((ValaCollection*) _tmp499_);
		_tmp501_ = _tmp500_;
		_arg_size = _tmp501_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp502_;
			gint _tmp503_;
			ValaExpression* arg = NULL;
			ValaList* _tmp504_;
			gint _tmp505_;
			gpointer _tmp506_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp507_;
			gboolean _tmp508_ = FALSE;
			ValaSizeofExpression* _tmp509_;
			_arg_index = _arg_index + 1;
			_tmp502_ = _arg_index;
			_tmp503_ = _arg_size;
			if (!(_tmp502_ < _tmp503_)) {
				break;
			}
			_tmp504_ = _arg_list;
			_tmp505_ = _arg_index;
			_tmp506_ = vala_list_get (_tmp504_, _tmp505_);
			arg = (ValaExpression*) _tmp506_;
			_tmp507_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp507_) ? ((ValaSizeofExpression*) _tmp507_) : NULL;
			_tmp509_ = sizeof_expr;
			if (_tmp509_ != NULL) {
				ValaSizeofExpression* _tmp510_;
				ValaDataType* _tmp511_;
				ValaDataType* _tmp512_;
				_tmp510_ = sizeof_expr;
				_tmp511_ = vala_sizeof_expression_get_type_reference (_tmp510_);
				_tmp512_ = _tmp511_;
				_tmp508_ = VALA_IS_GENERIC_TYPE (_tmp512_);
			} else {
				_tmp508_ = FALSE;
			}
			if (_tmp508_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp513_;
				ValaDataType* _tmp514_;
				ValaDataType* _tmp515_;
				ValaDataType* _tmp516_;
				ValaDataType* _tmp517_;
				ValaDataType* _tmp518_;
				ValaDataType* _tmp519_;
				ValaList* _tmp520_;
				ValaList* _tmp521_;
				ValaDataType* _tmp522_;
				ValaDataType* _tmp523_;
				ValaExpression* _tmp524_;
				ValaDataType* _tmp525_;
				ValaSourceReference* _tmp526_;
				ValaSourceReference* _tmp527_;
				ValaSizeofExpression* _tmp528_;
				ValaSizeofExpression* _tmp529_;
				_tmp513_ = sizeof_expr;
				_tmp514_ = vala_sizeof_expression_get_type_reference (_tmp513_);
				_tmp515_ = _tmp514_;
				_tmp516_ = vala_object_creation_expression_get_type_reference (self);
				_tmp517_ = _tmp516_;
				_tmp518_ = vala_object_creation_expression_get_type_reference (self);
				_tmp519_ = _tmp518_;
				_tmp520_ = vala_data_type_get_type_arguments (_tmp519_);
				_tmp521_ = _tmp520_;
				_tmp522_ = vala_data_type_get_actual_type (_tmp515_, _tmp517_, _tmp521_, (ValaCodeNode*) self);
				_tmp523_ = _tmp522_;
				_vala_iterable_unref0 (_tmp521_);
				sizeof_type = _tmp523_;
				_tmp524_ = arg;
				_tmp525_ = sizeof_type;
				_tmp526_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp527_ = _tmp526_;
				_tmp528_ = vala_sizeof_expression_new (_tmp525_, _tmp527_);
				_tmp529_ = _tmp528_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp524_, (ValaExpression*) _tmp529_);
				_vala_code_node_unref0 (_tmp529_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp530_;
		gint _init_size = 0;
		ValaList* _tmp531_;
		gint _tmp532_;
		gint _tmp533_;
		gint _init_index = 0;
		_tmp530_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp530_;
		_tmp531_ = _init_list;
		_tmp532_ = vala_collection_get_size ((ValaCollection*) _tmp531_);
		_tmp533_ = _tmp532_;
		_init_size = _tmp533_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp534_;
			gint _tmp535_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp536_;
			gint _tmp537_;
			gpointer _tmp538_;
			ValaSemanticAnalyzer* _tmp539_;
			ValaSemanticAnalyzer* _tmp540_;
			ValaMemberInitializer* _tmp541_;
			ValaDataType* _tmp542_;
			ValaDataType* _tmp543_;
			_init_index = _init_index + 1;
			_tmp534_ = _init_index;
			_tmp535_ = _init_size;
			if (!(_tmp534_ < _tmp535_)) {
				break;
			}
			_tmp536_ = _init_list;
			_tmp537_ = _init_index;
			_tmp538_ = vala_list_get (_tmp536_, _tmp537_);
			init = (ValaMemberInitializer*) _tmp538_;
			_tmp539_ = vala_code_context_get_analyzer (context);
			_tmp540_ = _tmp539_;
			_tmp541_ = init;
			_tmp542_ = vala_object_creation_expression_get_type_reference (self);
			_tmp543_ = _tmp542_;
			vala_semantic_analyzer_visit_member_initializer (_tmp540_, _tmp541_, _tmp543_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp544_ = may_throw;
	if (_tmp544_) {
		gboolean _tmp545_ = FALSE;
		ValaCodeNode* _tmp546_;
		ValaCodeNode* _tmp547_;
		_tmp546_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp547_ = _tmp546_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp547_)) {
			_tmp545_ = TRUE;
		} else {
			ValaCodeNode* _tmp548_;
			ValaCodeNode* _tmp549_;
			_tmp548_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp549_ = _tmp548_;
			_tmp545_ = VALA_IS_EXPRESSION_STATEMENT (_tmp549_);
		}
		if (_tmp545_) {
		} else {
			ValaSemanticAnalyzer* _tmp550_;
			ValaSemanticAnalyzer* _tmp551_;
			ValaSymbol* _tmp552_;
			ValaSymbol* _tmp553_;
			_tmp550_ = vala_code_context_get_analyzer (context);
			_tmp551_ = _tmp550_;
			_tmp552_ = vala_semantic_analyzer_get_current_symbol (_tmp551_);
			_tmp553_ = _tmp552_;
			if (!VALA_IS_BLOCK (_tmp553_)) {
				ValaSourceReference* _tmp554_;
				ValaSourceReference* _tmp555_;
				_tmp554_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp555_ = _tmp554_;
				vala_report_error (_tmp555_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp556_;
				ValaCodeNode* _tmp557_;
				ValaCodeNode* _tmp558_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp559_;
				ValaDataType* _tmp560_;
				ValaDataType* _tmp561_;
				ValaDataType* _tmp562_;
				gchar* _tmp563_;
				gchar* _tmp564_;
				ValaSourceReference* _tmp565_;
				ValaSourceReference* _tmp566_;
				ValaLocalVariable* _tmp567_;
				ValaLocalVariable* _tmp568_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp569_;
				ValaSourceReference* _tmp570_;
				ValaSourceReference* _tmp571_;
				ValaDeclarationStatement* _tmp572_;
				ValaSemanticAnalyzer* _tmp573_;
				ValaSemanticAnalyzer* _tmp574_;
				ValaBlock* _tmp575_;
				ValaDeclarationStatement* _tmp576_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp577_;
				ValaDataType* _tmp578_;
				ValaDataType* _tmp579_;
				ValaExpression* _tmp580_;
				ValaExpression* _tmp581_;
				ValaDataType* _tmp582_;
				ValaDataType* _tmp583_;
				ValaLocalVariable* _tmp584_;
				ValaDeclarationStatement* _tmp585_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp586_;
				ValaSemanticAnalyzer* _tmp587_;
				ValaSymbol* _tmp588_;
				ValaSymbol* _tmp589_;
				ValaBlock* _tmp590_;
				ValaBlock* _tmp591_;
				ValaLocalVariable* _tmp592_;
				ValaSemanticAnalyzer* _tmp593_;
				ValaSemanticAnalyzer* _tmp594_;
				ValaBlock* _tmp595_;
				ValaLocalVariable* _tmp596_;
				ValaCodeNode* _tmp597_;
				ValaExpression* _tmp598_;
				ValaExpression* _tmp599_;
				_tmp556_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp557_ = _tmp556_;
				_tmp558_ = _vala_code_node_ref0 (_tmp557_);
				old_parent_node = _tmp558_;
				_tmp559_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp560_ = _tmp559_;
				_tmp561_ = vala_data_type_copy (_tmp560_);
				_tmp562_ = _tmp561_;
				_tmp563_ = vala_code_node_get_temp_name ();
				_tmp564_ = _tmp563_;
				_tmp565_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp566_ = _tmp565_;
				_tmp567_ = vala_local_variable_new (_tmp562_, _tmp564_, NULL, _tmp566_);
				_tmp568_ = _tmp567_;
				_g_free0 (_tmp564_);
				_vala_code_node_unref0 (_tmp562_);
				local = _tmp568_;
				_tmp569_ = local;
				_tmp570_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp571_ = _tmp570_;
				_tmp572_ = vala_declaration_statement_new ((ValaSymbol*) _tmp569_, _tmp571_);
				decl = _tmp572_;
				_tmp573_ = vala_code_context_get_analyzer (context);
				_tmp574_ = _tmp573_;
				_tmp575_ = _tmp574_->insert_block;
				_tmp576_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp575_, (ValaStatement*) _tmp576_);
				_tmp577_ = local;
				_tmp578_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp579_ = _tmp578_;
				_tmp580_ = vala_semantic_analyzer_create_temp_access (_tmp577_, _tmp579_);
				temp_access = _tmp580_;
				_tmp581_ = temp_access;
				_tmp582_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp583_ = _tmp582_;
				vala_expression_set_formal_target_type (_tmp581_, _tmp583_);
				_tmp584_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp584_, (ValaExpression*) self);
				_tmp585_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp585_, context);
				_tmp586_ = vala_code_context_get_analyzer (context);
				_tmp587_ = _tmp586_;
				_tmp588_ = vala_semantic_analyzer_get_current_symbol (_tmp587_);
				_tmp589_ = _tmp588_;
				_tmp590_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp589_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp590_;
				_tmp591_ = block;
				_tmp592_ = local;
				vala_block_remove_local_variable (_tmp591_, _tmp592_);
				_tmp593_ = vala_code_context_get_analyzer (context);
				_tmp594_ = _tmp593_;
				_tmp595_ = _tmp594_->insert_block;
				_tmp596_ = local;
				vala_block_add_local_variable (_tmp595_, _tmp596_);
				_tmp597_ = old_parent_node;
				_tmp598_ = temp_access;
				vala_code_node_replace_expression (_tmp597_, (ValaExpression*) self, _tmp598_);
				_tmp599_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp599_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp600_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp601_ = _tmp600_;
	result = !_tmp601_;
	_vala_code_node_unref0 (type);
	return result;
}


static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp10_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _init_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _init_index = 0;
		_tmp11_ = self->priv->object_initializer;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_init_list = _tmp12_;
		_tmp13_ = _init_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_init_size = _tmp15_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaMemberInitializer* _tmp21_;
			_init_index = _init_index + 1;
			_tmp16_ = _init_index;
			_tmp17_ = _init_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _init_list;
			_tmp19_ = _init_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			init = (ValaMemberInitializer*) _tmp20_;
			_tmp21_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp21_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_arg_index = _arg_index + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _init_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _init_index = 0;
		_tmp11_ = self->priv->object_initializer;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_init_list = _tmp12_;
		_tmp13_ = _init_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_init_size = _tmp15_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaMemberInitializer* _tmp21_;
			_init_index = _init_index + 1;
			_tmp16_ = _init_index;
			_tmp17_ = _init_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _init_list;
			_tmp19_ = _init_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			init = (ValaMemberInitializer*) _tmp20_;
			_tmp21_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp21_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



