/* valamethod.c generated by valac, the Vala compiler
 * generated from valamethod.vala, do not modify */

/* valamethod.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaMethodPrivate {
	ValaList* type_parameters;
	ValaMemberBinding _binding;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	gboolean _is_inline;
	gboolean _entry_point;
	ValaParameter* _this_parameter;
	ValaSignal* _signal_reference;
	gboolean _closure;
	gboolean _coroutine;
	gboolean _is_async_callback;
	ValaList* parameters;
	ValaList* preconditions;
	ValaList* postconditions;
	ValaDataType* _return_type;
	ValaMethod* _base_method;
	ValaMethod* _base_interface_method;
	ValaDataType* _base_interface_type;
	gboolean base_methods_valid;
	ValaMethod* callback_method;
	ValaMethod* end_method;
	ValaList* captured_variables;
};


static gpointer vala_method_parent_class = NULL;
static ValaList* vala_method__empty_expression_list;
static ValaList* vala_method__empty_expression_list = NULL;
static ValaList* vala_method__empty_type_parameter_list;
static ValaList* vala_method__empty_type_parameter_list = NULL;
static ValaCallableIface * vala_method_vala_callable_parent_iface = NULL;

#define VALA_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD, ValaMethodPrivate))
static void vala_method_real_add_parameter (ValaCallable* base,
                                     ValaParameter* param);
static ValaList* vala_method_real_get_parameters (ValaCallable* base);
static void vala_method_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor);
static void vala_method_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_method_real_replace_type (ValaCodeNode* base,
                                    ValaDataType* old_type,
                                    ValaDataType* new_type);
static void vala_method_find_base_methods (ValaMethod* self);
static void vala_method_find_base_interface_method (ValaMethod* self,
                                             ValaClass* cl);
static void vala_method_find_base_class_method (ValaMethod* self,
                                         ValaClass* cl);
static gboolean vala_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context);
static gboolean vala_method_is_possible_entry_point (ValaMethod* self,
                                              ValaCodeContext* context);
static void vala_method_set_entry_point (ValaMethod* self,
                                  gboolean value);
static void vala_method_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection);
static void vala_method_finalize (ValaCodeNode * obj);


/**
 * Creates a new method.
 *
 * @param name              method name
 * @param return_type       method return type
 * @param source_reference  reference to source code
 * @return                  newly created method
 */
ValaMethod*
vala_method_construct (GType object_type,
                       const gchar* name,
                       ValaDataType* return_type,
                       ValaSourceReference* source_reference,
                       ValaComment* comment)
{
	ValaMethod* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaMethod*) vala_subroutine_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaMethod*
vala_method_new (const gchar* name,
                 ValaDataType* return_type,
                 ValaSourceReference* source_reference,
                 ValaComment* comment)
{
	return vala_method_construct (VALA_TYPE_METHOD, name, return_type, source_reference, comment);
}


/**
 * Appends parameter to this method.
 *
 * @param param a formal parameter
 */
static void
vala_method_real_add_parameter (ValaCallable* base,
                                ValaParameter* param)
{
	ValaMethod * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static ValaList*
vala_method_real_get_parameters (ValaCallable* base)
{
	ValaMethod * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Remove all parameters from this method.
 */
void
vala_method_clear_parameters (ValaMethod* self)
{
	ValaList* _tmp18_;
	g_return_if_fail (self != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_ellipsis (_tmp10_);
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				ValaScope* _tmp13_;
				ValaScope* _tmp14_;
				ValaParameter* _tmp15_;
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) self);
				_tmp14_ = _tmp13_;
				_tmp15_ = param;
				_tmp16_ = vala_symbol_get_name ((ValaSymbol*) _tmp15_);
				_tmp17_ = _tmp16_;
				vala_scope_remove (_tmp14_, _tmp17_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp18_ = self->priv->parameters;
	vala_collection_clear ((ValaCollection*) _tmp18_);
}


gboolean
vala_method_is_variadic (ValaMethod* self)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_ellipsis (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


static void
vala_method_real_accept (ValaCodeNode* base,
                         ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method (visitor, self);
}


static void
vala_method_real_accept_children (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaMethod * self;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaLocalVariable* _tmp39_;
	ValaLocalVariable* _tmp40_;
	ValaList* _tmp43_;
	ValaList* _tmp55_;
	ValaBlock* _tmp67_;
	ValaBlock* _tmp68_;
	self = (ValaMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		gint _p_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _p_index = 0;
		_tmp0_ = vala_method_get_type_parameters (self);
		_p_list = _tmp0_;
		_tmp1_ = _p_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_p_size = _tmp3_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaTypeParameter* _tmp9_;
			_p_index = _p_index + 1;
			_tmp4_ = _p_index;
			_tmp5_ = _p_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _p_list;
			_tmp7_ = _p_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			p = (ValaTypeParameter*) _tmp8_;
			_tmp9_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp10_ = vala_method_get_base_interface_type (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		_tmp12_ = vala_method_get_base_interface_type (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
	_tmp14_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		_tmp16_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp17_ = _tmp16_;
		vala_code_node_accept ((ValaCodeNode*) _tmp17_, visitor);
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp18_;
		ValaList* _tmp19_;
		gint _param_size = 0;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _param_index = 0;
		_tmp18_ = self->priv->parameters;
		_tmp19_ = _vala_iterable_ref0 (_tmp18_);
		_param_list = _tmp19_;
		_tmp20_ = _param_list;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_param_size = _tmp22_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			ValaParameter* param = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaParameter* _tmp28_;
			_param_index = _param_index + 1;
			_tmp23_ = _param_index;
			_tmp24_ = _param_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _param_list;
			_tmp26_ = _param_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			param = (ValaParameter*) _tmp27_;
			_tmp28_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp28_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp29_;
		gint _error_type_size = 0;
		ValaList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gint _error_type_index = 0;
		_tmp29_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp29_;
		_tmp30_ = _error_type_list;
		_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_error_type_size = _tmp32_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp33_;
			gint _tmp34_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp35_;
			gint _tmp36_;
			gpointer _tmp37_;
			ValaDataType* _tmp38_;
			_error_type_index = _error_type_index + 1;
			_tmp33_ = _error_type_index;
			_tmp34_ = _error_type_size;
			if (!(_tmp33_ < _tmp34_)) {
				break;
			}
			_tmp35_ = _error_type_list;
			_tmp36_ = _error_type_index;
			_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
			error_type = (ValaDataType*) _tmp37_;
			_tmp38_ = error_type;
			vala_code_node_accept ((ValaCodeNode*) _tmp38_, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp39_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp40_ = _tmp39_;
	if (_tmp40_ != NULL) {
		ValaLocalVariable* _tmp41_;
		ValaLocalVariable* _tmp42_;
		_tmp41_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp42_ = _tmp41_;
		vala_code_node_accept ((ValaCodeNode*) _tmp42_, visitor);
	}
	_tmp43_ = self->priv->preconditions;
	if (_tmp43_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp44_;
			ValaList* _tmp45_;
			gint _precondition_size = 0;
			ValaList* _tmp46_;
			gint _tmp47_;
			gint _tmp48_;
			gint _precondition_index = 0;
			_tmp44_ = self->priv->preconditions;
			_tmp45_ = _vala_iterable_ref0 (_tmp44_);
			_precondition_list = _tmp45_;
			_tmp46_ = _precondition_list;
			_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
			_tmp48_ = _tmp47_;
			_precondition_size = _tmp48_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp49_;
				gint _tmp50_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp51_;
				gint _tmp52_;
				gpointer _tmp53_;
				ValaExpression* _tmp54_;
				_precondition_index = _precondition_index + 1;
				_tmp49_ = _precondition_index;
				_tmp50_ = _precondition_size;
				if (!(_tmp49_ < _tmp50_)) {
					break;
				}
				_tmp51_ = _precondition_list;
				_tmp52_ = _precondition_index;
				_tmp53_ = vala_list_get (_tmp51_, _tmp52_);
				precondition = (ValaExpression*) _tmp53_;
				_tmp54_ = precondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp54_, visitor);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp55_ = self->priv->postconditions;
	if (_tmp55_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp56_;
			ValaList* _tmp57_;
			gint _postcondition_size = 0;
			ValaList* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			gint _postcondition_index = 0;
			_tmp56_ = self->priv->postconditions;
			_tmp57_ = _vala_iterable_ref0 (_tmp56_);
			_postcondition_list = _tmp57_;
			_tmp58_ = _postcondition_list;
			_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
			_tmp60_ = _tmp59_;
			_postcondition_size = _tmp60_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp61_;
				gint _tmp62_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp63_;
				gint _tmp64_;
				gpointer _tmp65_;
				ValaExpression* _tmp66_;
				_postcondition_index = _postcondition_index + 1;
				_tmp61_ = _postcondition_index;
				_tmp62_ = _postcondition_size;
				if (!(_tmp61_ < _tmp62_)) {
					break;
				}
				_tmp63_ = _postcondition_list;
				_tmp64_ = _postcondition_index;
				_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
				postcondition = (ValaExpression*) _tmp65_;
				_tmp66_ = postcondition;
				vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp67_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp68_ = _tmp67_;
	if (_tmp68_ != NULL) {
		ValaBlock* _tmp69_;
		ValaBlock* _tmp70_;
		_tmp69_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp70_ = _tmp69_;
		vala_code_node_accept ((ValaCodeNode*) _tmp70_, visitor);
	}
}


/**
 * Checks whether the parameters and return type of this method are
 * compatible with the specified method
 *
 * @param base_method a method
 * @param invalid_match error string about which check failed
 * @return true if the specified method is compatible to this method
 */
gboolean
vala_method_compatible (ValaMethod* self,
                        ValaMethod* base_method,
                        gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	ValaObjectType* object_type = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* _tmp25_;
	ValaList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_;
	ValaList* method_type_args = NULL;
	ValaList* _tmp45_;
	ValaList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	gboolean _tmp49_;
	ValaDataType* actual_base_type = NULL;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	ValaObjectType* _tmp68_;
	ValaList* _tmp69_;
	ValaDataType* _tmp70_;
	ValaDataType* _tmp71_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp73_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp82_;
	ValaIterator* _tmp83_;
	gint param_index = 0;
	ValaIterator* _tmp136_;
	gboolean _tmp163_;
	gboolean _tmp164_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_method != NULL, FALSE);
	if (self == base_method) {
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = NULL;
		result = TRUE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp0_ = self->priv->_binding;
	_tmp1_ = base_method->priv->_binding;
	if (_tmp0_ != _tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("incompatible binding");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp2_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	object_type = NULL;
	_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaObjectType* _tmp7_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
		_vala_code_node_unref0 (object_type);
		object_type = _tmp7_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaObjectType* _tmp8_;
			ValaObjectTypeSymbol* _tmp9_;
			ValaObjectTypeSymbol* _tmp10_;
			ValaList* _tmp11_;
			gint _type_parameter_size = 0;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gint _type_parameter_index = 0;
			_tmp8_ = object_type;
			_tmp9_ = vala_object_type_get_type_symbol (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_object_type_symbol_get_type_parameters (_tmp10_);
			_type_parameter_list = _tmp11_;
			_tmp12_ = _type_parameter_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_type_parameter_size = _tmp14_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp15_;
				gint _tmp16_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp20_;
				ValaGenericType* _tmp21_;
				ValaGenericType* _tmp22_;
				ValaObjectType* _tmp23_;
				ValaGenericType* _tmp24_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp15_ = _type_parameter_index;
				_tmp16_ = _type_parameter_size;
				if (!(_tmp15_ < _tmp16_)) {
					break;
				}
				_tmp17_ = _type_parameter_list;
				_tmp18_ = _type_parameter_index;
				_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
				type_parameter = (ValaTypeParameter*) _tmp19_;
				_tmp20_ = type_parameter;
				_tmp21_ = vala_generic_type_new (_tmp20_);
				type_arg = _tmp21_;
				_tmp22_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp22_, TRUE);
				_tmp23_ = object_type;
				_tmp24_ = type_arg;
				vala_data_type_add_type_argument ((ValaDataType*) _tmp23_, (ValaDataType*) _tmp24_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp25_ = vala_method_get_type_parameters (self);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_method_get_type_parameters (base_method);
	_tmp30_ = _tmp29_;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp28_ < _tmp32_;
	_vala_iterable_unref0 (_tmp30_);
	_vala_iterable_unref0 (_tmp26_);
	if (_tmp33_) {
		gchar* _tmp34_;
		_tmp34_ = g_strdup ("too few type parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp34_;
		result = FALSE;
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	} else {
		ValaList* _tmp35_;
		ValaList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		ValaList* _tmp39_;
		ValaList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gboolean _tmp43_;
		_tmp35_ = vala_method_get_type_parameters (self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = vala_method_get_type_parameters (base_method);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_collection_get_size ((ValaCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp38_ > _tmp42_;
		_vala_iterable_unref0 (_tmp40_);
		_vala_iterable_unref0 (_tmp36_);
		if (_tmp43_) {
			gchar* _tmp44_;
			_tmp44_ = g_strdup ("too many type parameters");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp44_;
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
	}
	method_type_args = NULL;
	_tmp45_ = vala_method_get_type_parameters (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = _tmp48_ > 0;
	_vala_iterable_unref0 (_tmp46_);
	if (_tmp49_) {
		GEqualFunc _tmp50_;
		ValaArrayList* _tmp51_;
		_tmp50_ = g_direct_equal;
		_tmp51_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp50_);
		_vala_iterable_unref0 (method_type_args);
		method_type_args = (ValaList*) _tmp51_;
		{
			ValaList* _type_parameter_list = NULL;
			ValaList* _tmp52_;
			gint _type_parameter_size = 0;
			ValaList* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gint _type_parameter_index = 0;
			_tmp52_ = vala_method_get_type_parameters (self);
			_type_parameter_list = _tmp52_;
			_tmp53_ = _type_parameter_list;
			_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
			_tmp55_ = _tmp54_;
			_type_parameter_size = _tmp55_;
			_type_parameter_index = -1;
			while (TRUE) {
				gint _tmp56_;
				gint _tmp57_;
				ValaTypeParameter* type_parameter = NULL;
				ValaList* _tmp58_;
				gint _tmp59_;
				gpointer _tmp60_;
				ValaGenericType* type_arg = NULL;
				ValaTypeParameter* _tmp61_;
				ValaGenericType* _tmp62_;
				ValaGenericType* _tmp63_;
				ValaList* _tmp64_;
				ValaGenericType* _tmp65_;
				_type_parameter_index = _type_parameter_index + 1;
				_tmp56_ = _type_parameter_index;
				_tmp57_ = _type_parameter_size;
				if (!(_tmp56_ < _tmp57_)) {
					break;
				}
				_tmp58_ = _type_parameter_list;
				_tmp59_ = _type_parameter_index;
				_tmp60_ = vala_list_get (_tmp58_, _tmp59_);
				type_parameter = (ValaTypeParameter*) _tmp60_;
				_tmp61_ = type_parameter;
				_tmp62_ = vala_generic_type_new (_tmp61_);
				type_arg = _tmp62_;
				_tmp63_ = type_arg;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp63_, TRUE);
				_tmp64_ = method_type_args;
				_tmp65_ = type_arg;
				vala_collection_add ((ValaCollection*) _tmp64_, (ValaDataType*) _tmp65_);
				_vala_code_node_unref0 (type_arg);
				_vala_code_node_unref0 (type_parameter);
			}
			_vala_iterable_unref0 (_type_parameter_list);
		}
	}
	_tmp66_ = vala_callable_get_return_type ((ValaCallable*) base_method);
	_tmp67_ = _tmp66_;
	_tmp68_ = object_type;
	_tmp69_ = method_type_args;
	_tmp70_ = vala_data_type_get_actual_type (_tmp67_, (ValaDataType*) _tmp68_, _tmp69_, (ValaCodeNode*) self);
	actual_base_type = _tmp70_;
	_tmp71_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp72_ = _tmp71_;
	_tmp73_ = actual_base_type;
	if (!vala_data_type_equals (_tmp72_, _tmp73_)) {
		ValaDataType* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
		ValaDataType* _tmp77_;
		ValaDataType* _tmp78_;
		gchar* _tmp79_;
		gchar* _tmp80_;
		gchar* _tmp81_;
		_tmp74_ = actual_base_type;
		_tmp75_ = vala_data_type_to_prototype_string (_tmp74_, NULL);
		_tmp76_ = _tmp75_;
		_tmp77_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp78_ = _tmp77_;
		_tmp79_ = vala_data_type_to_prototype_string (_tmp78_, NULL);
		_tmp80_ = _tmp79_;
		_tmp81_ = g_strdup_printf ("Base method expected return type `%s', but `%s' was provided", _tmp76_, _tmp80_);
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp81_;
		_g_free0 (_tmp80_);
		_g_free0 (_tmp76_);
		result = FALSE;
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp82_ = self->priv->parameters;
	_tmp83_ = vala_iterable_iterator ((ValaIterable*) _tmp82_);
	method_params_it = _tmp83_;
	param_index = 1;
	{
		ValaList* _base_param_list = NULL;
		ValaList* _tmp84_;
		ValaList* _tmp85_;
		gint _base_param_size = 0;
		ValaList* _tmp86_;
		gint _tmp87_;
		gint _tmp88_;
		gint _base_param_index = 0;
		_tmp84_ = base_method->priv->parameters;
		_tmp85_ = _vala_iterable_ref0 (_tmp84_);
		_base_param_list = _tmp85_;
		_tmp86_ = _base_param_list;
		_tmp87_ = vala_collection_get_size ((ValaCollection*) _tmp86_);
		_tmp88_ = _tmp87_;
		_base_param_size = _tmp88_;
		_base_param_index = -1;
		while (TRUE) {
			gint _tmp89_;
			gint _tmp90_;
			ValaParameter* base_param = NULL;
			ValaList* _tmp91_;
			gint _tmp92_;
			gpointer _tmp93_;
			ValaIterator* _tmp94_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp96_;
			gpointer _tmp97_;
			ValaParameter* _tmp98_;
			gboolean _tmp99_;
			gboolean _tmp100_;
			ValaParameter* _tmp101_;
			gboolean _tmp102_;
			gboolean _tmp103_;
			ValaParameter* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			ValaParameter* _tmp108_;
			gboolean _tmp109_;
			gboolean _tmp110_;
			ValaParameter* _tmp112_;
			gboolean _tmp113_;
			gboolean _tmp114_;
			gint _tmp135_;
			_base_param_index = _base_param_index + 1;
			_tmp89_ = _base_param_index;
			_tmp90_ = _base_param_size;
			if (!(_tmp89_ < _tmp90_)) {
				break;
			}
			_tmp91_ = _base_param_list;
			_tmp92_ = _base_param_index;
			_tmp93_ = vala_list_get (_tmp91_, _tmp92_);
			base_param = (ValaParameter*) _tmp93_;
			_tmp94_ = method_params_it;
			if (!vala_iterator_next (_tmp94_)) {
				gchar* _tmp95_;
				_tmp95_ = g_strdup ("too few parameters");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp95_;
				result = FALSE;
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp96_ = method_params_it;
			_tmp97_ = vala_iterator_get (_tmp96_);
			param = (ValaParameter*) _tmp97_;
			_tmp98_ = base_param;
			_tmp99_ = vala_parameter_get_ellipsis (_tmp98_);
			_tmp100_ = _tmp99_;
			_tmp101_ = param;
			_tmp102_ = vala_parameter_get_ellipsis (_tmp101_);
			_tmp103_ = _tmp102_;
			if (_tmp100_ != _tmp103_) {
				gchar* _tmp104_;
				_tmp104_ = g_strdup ("ellipsis parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp104_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp105_ = base_param;
			_tmp106_ = vala_parameter_get_params_array (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp108_ = param;
			_tmp109_ = vala_parameter_get_params_array (_tmp108_);
			_tmp110_ = _tmp109_;
			if (_tmp107_ != _tmp110_) {
				gchar* _tmp111_;
				_tmp111_ = g_strdup ("params array parameter mismatch");
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp111_;
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (base_param);
				_vala_iterable_unref0 (_base_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_tmp112_ = base_param;
			_tmp113_ = vala_parameter_get_ellipsis (_tmp112_);
			_tmp114_ = _tmp113_;
			if (!_tmp114_) {
				ValaParameter* _tmp115_;
				ValaParameterDirection _tmp116_;
				ValaParameterDirection _tmp117_;
				ValaParameter* _tmp118_;
				ValaParameterDirection _tmp119_;
				ValaParameterDirection _tmp120_;
				ValaParameter* _tmp123_;
				ValaDataType* _tmp124_;
				ValaDataType* _tmp125_;
				ValaObjectType* _tmp126_;
				ValaList* _tmp127_;
				ValaDataType* _tmp128_;
				ValaDataType* _tmp129_;
				ValaParameter* _tmp130_;
				ValaDataType* _tmp131_;
				ValaDataType* _tmp132_;
				_tmp115_ = base_param;
				_tmp116_ = vala_parameter_get_direction (_tmp115_);
				_tmp117_ = _tmp116_;
				_tmp118_ = param;
				_tmp119_ = vala_parameter_get_direction (_tmp118_);
				_tmp120_ = _tmp119_;
				if (_tmp117_ != _tmp120_) {
					gint _tmp121_;
					gchar* _tmp122_;
					_tmp121_ = param_index;
					_tmp122_ = g_strdup_printf ("incompatible direction of parameter %d", _tmp121_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp122_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
				_tmp123_ = base_param;
				_tmp124_ = vala_variable_get_variable_type ((ValaVariable*) _tmp123_);
				_tmp125_ = _tmp124_;
				_tmp126_ = object_type;
				_tmp127_ = method_type_args;
				_tmp128_ = vala_data_type_get_actual_type (_tmp125_, (ValaDataType*) _tmp126_, _tmp127_, (ValaCodeNode*) self);
				_vala_code_node_unref0 (actual_base_type);
				actual_base_type = _tmp128_;
				_tmp129_ = actual_base_type;
				_tmp130_ = param;
				_tmp131_ = vala_variable_get_variable_type ((ValaVariable*) _tmp130_);
				_tmp132_ = _tmp131_;
				if (!vala_data_type_equals (_tmp129_, _tmp132_)) {
					gint _tmp133_;
					gchar* _tmp134_;
					_tmp133_ = param_index;
					_tmp134_ = g_strdup_printf ("incompatible type of parameter %d", _tmp133_);
					_g_free0 (_vala_invalid_match);
					_vala_invalid_match = _tmp134_;
					result = FALSE;
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (base_param);
					_vala_iterable_unref0 (_base_param_list);
					_vala_iterator_unref0 (method_params_it);
					_vala_code_node_unref0 (actual_base_type);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (object_type);
					if (invalid_match) {
						*invalid_match = _vala_invalid_match;
					} else {
						_g_free0 (_vala_invalid_match);
					}
					return result;
				}
			}
			_tmp135_ = param_index;
			param_index = _tmp135_ + 1;
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (base_param);
		}
		_vala_iterable_unref0 (_base_param_list);
	}
	_tmp136_ = method_params_it;
	if (vala_iterator_next (_tmp136_)) {
		gchar* _tmp137_;
		_tmp137_ = g_strdup ("too many parameters");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp137_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	{
		ValaList* _method_error_type_list = NULL;
		ValaList* _tmp138_;
		gint _method_error_type_size = 0;
		ValaList* _tmp139_;
		gint _tmp140_;
		gint _tmp141_;
		gint _method_error_type_index = 0;
		_tmp138_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_method_error_type_list = _tmp138_;
		_tmp139_ = _method_error_type_list;
		_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
		_tmp141_ = _tmp140_;
		_method_error_type_size = _tmp141_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp142_;
			gint _tmp143_;
			ValaDataType* method_error_type = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			gboolean match = FALSE;
			gboolean _tmp158_;
			_method_error_type_index = _method_error_type_index + 1;
			_tmp142_ = _method_error_type_index;
			_tmp143_ = _method_error_type_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _method_error_type_list;
			_tmp145_ = _method_error_type_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			method_error_type = (ValaDataType*) _tmp146_;
			match = FALSE;
			{
				ValaList* _base_method_error_type_list = NULL;
				ValaList* _tmp147_;
				gint _base_method_error_type_size = 0;
				ValaList* _tmp148_;
				gint _tmp149_;
				gint _tmp150_;
				gint _base_method_error_type_index = 0;
				_tmp147_ = vala_code_node_get_error_types ((ValaCodeNode*) base_method);
				_base_method_error_type_list = _tmp147_;
				_tmp148_ = _base_method_error_type_list;
				_tmp149_ = vala_collection_get_size ((ValaCollection*) _tmp148_);
				_tmp150_ = _tmp149_;
				_base_method_error_type_size = _tmp150_;
				_base_method_error_type_index = -1;
				while (TRUE) {
					gint _tmp151_;
					gint _tmp152_;
					ValaDataType* base_method_error_type = NULL;
					ValaList* _tmp153_;
					gint _tmp154_;
					gpointer _tmp155_;
					ValaDataType* _tmp156_;
					ValaDataType* _tmp157_;
					_base_method_error_type_index = _base_method_error_type_index + 1;
					_tmp151_ = _base_method_error_type_index;
					_tmp152_ = _base_method_error_type_size;
					if (!(_tmp151_ < _tmp152_)) {
						break;
					}
					_tmp153_ = _base_method_error_type_list;
					_tmp154_ = _base_method_error_type_index;
					_tmp155_ = vala_list_get (_tmp153_, _tmp154_);
					base_method_error_type = (ValaDataType*) _tmp155_;
					_tmp156_ = method_error_type;
					_tmp157_ = base_method_error_type;
					if (vala_data_type_compatible (_tmp156_, _tmp157_)) {
						match = TRUE;
						_vala_code_node_unref0 (base_method_error_type);
						break;
					}
					_vala_code_node_unref0 (base_method_error_type);
				}
				_vala_iterable_unref0 (_base_method_error_type_list);
			}
			_tmp158_ = match;
			if (!_tmp158_) {
				ValaDataType* _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				gchar* _tmp162_;
				_tmp159_ = method_error_type;
				_tmp160_ = vala_code_node_to_string ((ValaCodeNode*) _tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = g_strdup_printf ("incompatible error type `%s'", _tmp161_);
				_g_free0 (_vala_invalid_match);
				_vala_invalid_match = _tmp162_;
				_g_free0 (_tmp161_);
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_code_node_unref0 (actual_base_type);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (object_type);
				if (invalid_match) {
					*invalid_match = _vala_invalid_match;
				} else {
					_g_free0 (_vala_invalid_match);
				}
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	_tmp163_ = base_method->priv->_coroutine;
	_tmp164_ = self->priv->_coroutine;
	if (_tmp163_ != _tmp164_) {
		gchar* _tmp165_;
		_tmp165_ = g_strdup ("async mismatch");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp165_;
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_code_node_unref0 (actual_base_type);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (object_type);
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_iterator_unref0 (method_params_it);
	_vala_code_node_unref0 (actual_base_type);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_method_add_type_parameter (ValaMethod* self,
                                ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->type_parameters);
		self->priv->type_parameters = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp3_, p);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp7_ = _tmp6_;
	vala_scope_add (_tmp5_, _tmp7_, (ValaSymbol*) p);
}


/**
 * Returns a copy of the type parameter list.
 *
 * @return list of type parameters
 */
ValaList*
vala_method_get_type_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_type_parameter_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_type_parameter_list);
		vala_method__empty_type_parameter_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_type_parameter_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


gint
vala_method_get_type_parameter_index (ValaMethod* self,
                                      const gchar* name)
{
	gint result = 0;
	ValaList* _tmp0_;
	gint i = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = self->priv->type_parameters;
	if (_tmp0_ == NULL) {
		result = -1;
		return result;
	}
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _parameter_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _parameter_index = 0;
		_tmp1_ = self->priv->type_parameters;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_parameter_list = _tmp2_;
		_tmp3_ = _parameter_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_parameter_size = _tmp5_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaTypeParameter* _tmp11_;
			const gchar* _tmp12_;
			const gchar* _tmp13_;
			gint _tmp14_;
			_parameter_index = _parameter_index + 1;
			_tmp6_ = _parameter_index;
			_tmp7_ = _parameter_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _parameter_list;
			_tmp9_ = _parameter_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			parameter = (ValaTypeParameter*) _tmp10_;
			_tmp11_ = parameter;
			_tmp12_ = vala_symbol_get_name ((ValaSymbol*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (g_strcmp0 (_tmp13_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp14_ = i;
			i = _tmp14_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Adds a precondition to this method.
 *
 * @param precondition a boolean precondition expression
 */
void
vala_method_add_precondition (ValaMethod* self,
                              ValaExpression* precondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (precondition != NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->preconditions);
		self->priv->preconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->preconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, precondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) precondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of preconditions of this method.
 *
 * @return list of preconditions
 */
ValaList*
vala_method_get_preconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->preconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->preconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


/**
 * Adds a postcondition to this method.
 *
 * @param postcondition a boolean postcondition expression
 */
void
vala_method_add_postcondition (ValaMethod* self,
                               ValaExpression* postcondition)
{
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (postcondition != NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ == NULL) {
		GEqualFunc _tmp1_;
		ValaArrayList* _tmp2_;
		_tmp1_ = g_direct_equal;
		_tmp2_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
		_vala_iterable_unref0 (self->priv->postconditions);
		self->priv->postconditions = (ValaList*) _tmp2_;
	}
	_tmp3_ = self->priv->postconditions;
	vala_collection_add ((ValaCollection*) _tmp3_, postcondition);
	vala_code_node_set_parent_node ((ValaCodeNode*) postcondition, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of postconditions of this method.
 *
 * @return list of postconditions
 */
ValaList*
vala_method_get_postconditions (ValaMethod* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp3_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->postconditions;
	if (_tmp0_ != NULL) {
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		_tmp1_ = self->priv->postconditions;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = vala_method__empty_expression_list;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_);
		_vala_iterable_unref0 (vala_method__empty_expression_list);
		vala_method__empty_expression_list = (ValaList*) _tmp5_;
	}
	_tmp6_ = vala_method__empty_expression_list;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	result = _tmp7_;
	return result;
}


static void
vala_method_real_replace_type (ValaCodeNode* base,
                               ValaDataType* old_type,
                               ValaDataType* new_type)
{
	ValaMethod * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaList* error_types = NULL;
	ValaList* _tmp4_;
	self = (ValaMethod*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_method_get_base_interface_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_method_set_base_interface_type (self, new_type);
		return;
	}
	_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp4_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp4_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				gint _tmp7_;
				ValaList* _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaDataType* _tmp14_;
				gboolean _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = i;
				_tmp8_ = error_types;
				_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
				_tmp10_ = _tmp9_;
				if (!(_tmp7_ < _tmp10_)) {
					break;
				}
				_tmp11_ = error_types;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				_tmp14_ = (ValaDataType*) _tmp13_;
				_tmp15_ = _tmp14_ == old_type;
				_vala_code_node_unref0 (_tmp14_);
				if (_tmp15_) {
					ValaList* _tmp16_;
					gint _tmp17_;
					_tmp16_ = error_types;
					_tmp17_ = i;
					vala_list_set (_tmp16_, _tmp17_, new_type);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


static void
vala_method_find_base_methods (ValaMethod* self)
{
	gboolean _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_methods_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (VALA_IS_CLASS (_tmp2_)) {
		if (!VALA_IS_CREATION_METHOD (self)) {
			ValaSymbol* _tmp3_;
			ValaSymbol* _tmp4_;
			gboolean _tmp5_ = FALSE;
			gboolean _tmp6_ = FALSE;
			gboolean _tmp7_;
			_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			vala_method_find_base_interface_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
			_tmp7_ = self->priv->_is_virtual;
			if (_tmp7_) {
				_tmp6_ = TRUE;
			} else {
				gboolean _tmp8_;
				_tmp8_ = self->priv->_is_abstract;
				_tmp6_ = _tmp8_;
			}
			if (_tmp6_) {
				_tmp5_ = TRUE;
			} else {
				gboolean _tmp9_;
				_tmp9_ = self->priv->_overrides;
				_tmp5_ = _tmp9_;
			}
			if (_tmp5_) {
				ValaSymbol* _tmp10_;
				ValaSymbol* _tmp11_;
				_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp11_ = _tmp10_;
				vala_method_find_base_class_method (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_CLASS, ValaClass));
			}
		}
	} else {
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		_tmp12_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp13_ = _tmp12_;
		if (VALA_IS_INTERFACE (_tmp13_)) {
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_;
			_tmp15_ = self->priv->_is_virtual;
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				gboolean _tmp16_;
				_tmp16_ = self->priv->_is_abstract;
				_tmp14_ = _tmp16_;
			}
			if (_tmp14_) {
				self->priv->_base_interface_method = self;
			}
		}
	}
	self->priv->base_methods_valid = TRUE;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_method_find_base_class_method (ValaMethod* self,
                                    ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaSymbol* _tmp12_;
	ValaClass* _tmp37_;
	ValaClass* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (VALA_IS_SIGNAL (_tmp5_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp6_;
		ValaSignal* _tmp7_;
		ValaSignal* _tmp8_;
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp7_;
		_tmp8_ = sig;
		_tmp9_ = vala_signal_get_default_handler (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (sym);
		sym = _tmp11_;
		_vala_code_node_unref0 (sig);
	}
	_tmp12_ = sym;
	if (VALA_IS_METHOD (_tmp12_)) {
		ValaMethod* base_method = NULL;
		ValaSymbol* _tmp13_;
		ValaMethod* _tmp14_;
		gboolean _tmp15_ = FALSE;
		ValaMethod* _tmp16_;
		gboolean _tmp17_;
		_tmp13_ = sym;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_METHOD, ValaMethod));
		base_method = _tmp14_;
		_tmp16_ = base_method;
		_tmp17_ = _tmp16_->priv->_is_abstract;
		if (_tmp17_) {
			_tmp15_ = TRUE;
		} else {
			ValaMethod* _tmp18_;
			gboolean _tmp19_;
			_tmp18_ = base_method;
			_tmp19_ = _tmp18_->priv->_is_virtual;
			_tmp15_ = _tmp19_;
		}
		if (_tmp15_) {
			gchar* invalid_match = NULL;
			ValaMethod* _tmp20_;
			gchar* _tmp21_ = NULL;
			gboolean _tmp22_;
			ValaMethod* _tmp35_;
			ValaMethod* _tmp36_;
			_tmp20_ = base_method;
			_tmp22_ = vala_method_compatible (self, _tmp20_, &_tmp21_);
			_g_free0 (invalid_match);
			invalid_match = _tmp21_;
			if (!_tmp22_) {
				ValaMethodType* base_method_type = NULL;
				ValaMethod* _tmp23_;
				ValaMethodType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				ValaMethodType* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				const gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = base_method;
				_tmp24_ = vala_method_type_new (_tmp23_);
				base_method_type = _tmp24_;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = base_method_type;
				_tmp30_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp29_, NULL);
				_tmp31_ = _tmp30_;
				_tmp32_ = invalid_match;
				_tmp33_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp28_, _tmp31_, _tmp32_);
				_tmp34_ = _tmp33_;
				vala_report_error (_tmp26_, _tmp34_);
				_g_free0 (_tmp34_);
				_g_free0 (_tmp31_);
				_g_free0 (_tmp28_);
				_vala_code_node_unref0 (base_method_type);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_method);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp35_ = base_method;
			self->priv->_base_method = _tmp35_;
			_tmp36_ = base_method;
			vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp36_, "CCode", "instance_pos");
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_method);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_method);
	}
	_tmp37_ = vala_class_get_base_class (cl);
	_tmp38_ = _tmp37_;
	if (_tmp38_ != NULL) {
		ValaClass* _tmp39_;
		ValaClass* _tmp40_;
		_tmp39_ = vala_class_get_base_class (cl);
		_tmp40_ = _tmp39_;
		vala_method_find_base_class_method (self, _tmp40_);
	}
	_vala_code_node_unref0 (sym);
}


static void
vala_method_find_base_interface_method (ValaMethod* self,
                                        ValaClass* cl)
{
	ValaDataType* _tmp82_;
	ValaDataType* _tmp83_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* type = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_type_index = _type_index + 1;
			_tmp4_ = _type_index;
			_tmp5_ = _type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _type_list;
			_tmp7_ = _type_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			type = (ValaDataType*) _tmp8_;
			_tmp9_ = type;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_INTERFACE (_tmp11_)) {
				gboolean _tmp12_ = FALSE;
				ValaDataType* _tmp13_;
				ValaDataType* _tmp14_;
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				ValaTypeSymbol* _tmp24_;
				ValaScope* _tmp25_;
				ValaScope* _tmp26_;
				const gchar* _tmp27_;
				const gchar* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaSymbol* _tmp37_;
				_tmp13_ = vala_method_get_base_interface_type (self);
				_tmp14_ = _tmp13_;
				if (_tmp14_ != NULL) {
					ValaDataType* _tmp15_;
					ValaDataType* _tmp16_;
					ValaTypeSymbol* _tmp17_;
					ValaTypeSymbol* _tmp18_;
					ValaDataType* _tmp19_;
					ValaTypeSymbol* _tmp20_;
					ValaTypeSymbol* _tmp21_;
					_tmp15_ = vala_method_get_base_interface_type (self);
					_tmp16_ = _tmp15_;
					_tmp17_ = vala_data_type_get_data_type (_tmp16_);
					_tmp18_ = _tmp17_;
					_tmp19_ = type;
					_tmp20_ = vala_data_type_get_data_type (_tmp19_);
					_tmp21_ = _tmp20_;
					_tmp12_ = _tmp18_ != _tmp21_;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_vala_code_node_unref0 (type);
					continue;
				}
				_tmp22_ = type;
				_tmp23_ = vala_data_type_get_data_type (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_symbol_get_scope ((ValaSymbol*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_scope_lookup (_tmp26_, _tmp28_);
				sym = _tmp29_;
				_tmp30_ = sym;
				if (VALA_IS_SIGNAL (_tmp30_)) {
					ValaSignal* sig = NULL;
					ValaSymbol* _tmp31_;
					ValaSignal* _tmp32_;
					ValaSignal* _tmp33_;
					ValaMethod* _tmp34_;
					ValaMethod* _tmp35_;
					ValaSymbol* _tmp36_;
					_tmp31_ = sym;
					_tmp32_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, VALA_TYPE_SIGNAL, ValaSignal));
					sig = _tmp32_;
					_tmp33_ = sig;
					_tmp34_ = vala_signal_get_default_handler (_tmp33_);
					_tmp35_ = _tmp34_;
					_tmp36_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp35_);
					_vala_code_node_unref0 (sym);
					sym = _tmp36_;
					_vala_code_node_unref0 (sig);
				}
				_tmp37_ = sym;
				if (VALA_IS_METHOD (_tmp37_)) {
					ValaMethod* base_method = NULL;
					ValaSymbol* _tmp38_;
					ValaMethod* _tmp39_;
					gboolean _tmp40_ = FALSE;
					ValaMethod* _tmp41_;
					gboolean _tmp42_;
					_tmp38_ = sym;
					_tmp39_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_METHOD, ValaMethod));
					base_method = _tmp39_;
					_tmp41_ = base_method;
					_tmp42_ = _tmp41_->priv->_is_abstract;
					if (_tmp42_) {
						_tmp40_ = TRUE;
					} else {
						ValaMethod* _tmp43_;
						gboolean _tmp44_;
						_tmp43_ = base_method;
						_tmp44_ = _tmp43_->priv->_is_virtual;
						_tmp40_ = _tmp44_;
					}
					if (_tmp40_) {
						ValaDataType* _tmp45_;
						ValaDataType* _tmp46_;
						gchar* invalid_match = NULL;
						ValaMethod* _tmp65_;
						gchar* _tmp66_ = NULL;
						gboolean _tmp67_;
						ValaMethod* _tmp80_;
						ValaMethod* _tmp81_;
						_tmp45_ = vala_method_get_base_interface_type (self);
						_tmp46_ = _tmp45_;
						if (_tmp46_ == NULL) {
							gboolean has_explicit_implementation = FALSE;
							gboolean _tmp64_;
							has_explicit_implementation = FALSE;
							{
								ValaList* _m_list = NULL;
								ValaList* _tmp47_;
								gint _m_size = 0;
								ValaList* _tmp48_;
								gint _tmp49_;
								gint _tmp50_;
								gint _m_index = 0;
								_tmp47_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) cl);
								_m_list = _tmp47_;
								_tmp48_ = _m_list;
								_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
								_tmp50_ = _tmp49_;
								_m_size = _tmp50_;
								_m_index = -1;
								while (TRUE) {
									gint _tmp51_;
									gint _tmp52_;
									ValaMethod* m = NULL;
									ValaList* _tmp53_;
									gint _tmp54_;
									gpointer _tmp55_;
									gboolean _tmp56_ = FALSE;
									ValaMethod* _tmp57_;
									ValaDataType* _tmp58_;
									ValaDataType* _tmp59_;
									_m_index = _m_index + 1;
									_tmp51_ = _m_index;
									_tmp52_ = _m_size;
									if (!(_tmp51_ < _tmp52_)) {
										break;
									}
									_tmp53_ = _m_list;
									_tmp54_ = _m_index;
									_tmp55_ = vala_list_get (_tmp53_, _tmp54_);
									m = (ValaMethod*) _tmp55_;
									_tmp57_ = m;
									_tmp58_ = vala_method_get_base_interface_type (_tmp57_);
									_tmp59_ = _tmp58_;
									if (_tmp59_ != NULL) {
										ValaMethod* _tmp60_;
										ValaMethod* _tmp61_;
										ValaMethod* _tmp62_;
										ValaMethod* _tmp63_;
										_tmp60_ = base_method;
										_tmp61_ = m;
										_tmp62_ = vala_method_get_base_interface_method (_tmp61_);
										_tmp63_ = _tmp62_;
										_tmp56_ = _tmp60_ == _tmp63_;
									} else {
										_tmp56_ = FALSE;
									}
									if (_tmp56_) {
										has_explicit_implementation = TRUE;
										_vala_code_node_unref0 (m);
										break;
									}
									_vala_code_node_unref0 (m);
								}
								_vala_iterable_unref0 (_m_list);
							}
							_tmp64_ = has_explicit_implementation;
							if (_tmp64_) {
								_vala_code_node_unref0 (base_method);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (type);
								continue;
							}
						}
						invalid_match = NULL;
						_tmp65_ = base_method;
						_tmp67_ = vala_method_compatible (self, _tmp65_, &_tmp66_);
						_g_free0 (invalid_match);
						invalid_match = _tmp66_;
						if (!_tmp67_) {
							ValaMethodType* base_method_type = NULL;
							ValaMethod* _tmp68_;
							ValaMethodType* _tmp69_;
							ValaSourceReference* _tmp70_;
							ValaSourceReference* _tmp71_;
							gchar* _tmp72_;
							gchar* _tmp73_;
							ValaMethodType* _tmp74_;
							gchar* _tmp75_;
							gchar* _tmp76_;
							const gchar* _tmp77_;
							gchar* _tmp78_;
							gchar* _tmp79_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp68_ = base_method;
							_tmp69_ = vala_method_type_new (_tmp68_);
							base_method_type = _tmp69_;
							_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp73_ = _tmp72_;
							_tmp74_ = base_method_type;
							_tmp75_ = vala_data_type_to_prototype_string ((ValaDataType*) _tmp74_, NULL);
							_tmp76_ = _tmp75_;
							_tmp77_ = invalid_match;
							_tmp78_ = g_strdup_printf ("overriding method `%s' is incompatible with base method `%s': %s.", _tmp73_, _tmp76_, _tmp77_);
							_tmp79_ = _tmp78_;
							vala_report_error (_tmp71_, _tmp79_);
							_g_free0 (_tmp79_);
							_g_free0 (_tmp76_);
							_g_free0 (_tmp73_);
							_vala_code_node_unref0 (base_method_type);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_method);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp80_ = base_method;
						self->priv->_base_interface_method = _tmp80_;
						_tmp81_ = base_method;
						vala_code_node_copy_attribute_double ((ValaCodeNode*) self, (ValaCodeNode*) _tmp81_, "CCode", "instance_pos");
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_method);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_method);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	_tmp82_ = vala_method_get_base_interface_type (self);
	_tmp83_ = _tmp82_;
	if (_tmp83_ != NULL) {
		ValaSourceReference* _tmp84_;
		ValaSourceReference* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp85_ = _tmp84_;
		_tmp86_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp87_ = _tmp86_;
		_tmp88_ = g_strdup_printf ("`%s': no suitable interface method found to implement", _tmp87_);
		_tmp89_ = _tmp88_;
		vala_report_error (_tmp85_, _tmp89_);
		_g_free0 (_tmp89_);
		_g_free0 (_tmp87_);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_method_real_check (ValaCodeNode* base,
                        ValaCodeContext* context)
{
	ValaMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaAttribute* _tmp4_;
	ValaAttribute* _tmp5_;
	gboolean _tmp6_;
	ValaAttribute* _tmp10_;
	ValaAttribute* _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp15_ = FALSE;
	ValaSymbol* _tmp16_;
	ValaSymbol* _tmp17_;
	gboolean _tmp33_;
	gboolean _tmp70_ = FALSE;
	gboolean _tmp71_;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp113_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaSourceFile* _tmp120_;
	ValaSourceFile* _tmp121_;
	ValaSourceFile* _tmp122_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp123_;
	ValaSemanticAnalyzer* _tmp124_;
	ValaSymbol* _tmp125_;
	ValaSymbol* _tmp126_;
	ValaSymbol* _tmp127_;
	ValaSourceReference* _tmp128_;
	ValaSourceReference* _tmp129_;
	ValaSemanticAnalyzer* _tmp136_;
	ValaSemanticAnalyzer* _tmp137_;
	ValaDataType* _tmp138_;
	ValaDataType* _tmp139_;
	ValaDataType* _tmp140_;
	ValaDataType* _tmp141_;
	ValaTypeSymbol* _tmp142_;
	ValaTypeSymbol* _tmp143_;
	ValaSemanticAnalyzer* _tmp144_;
	ValaSemanticAnalyzer* _tmp145_;
	ValaDataType* _tmp146_;
	ValaTypeSymbol* _tmp147_;
	ValaTypeSymbol* _tmp148_;
	ValaAttribute* init_attr = NULL;
	ValaAttribute* _tmp159_;
	ValaAttribute* _tmp160_;
	ValaDataType* _tmp167_;
	ValaDataType* _tmp168_;
	gboolean _tmp171_ = FALSE;
	gboolean _tmp172_ = FALSE;
	gboolean _tmp173_ = FALSE;
	ValaList* _tmp174_;
	gint _tmp175_;
	gint _tmp176_;
	gboolean _tmp190_ = FALSE;
	ValaAttribute* _tmp191_;
	ValaAttribute* _tmp192_;
	gboolean _tmp193_;
	gboolean optional_param = FALSE;
	ValaLocalVariable* _tmp291_;
	ValaLocalVariable* _tmp292_;
	ValaList* _tmp295_;
	ValaList* _tmp307_;
	ValaBlock* _tmp319_;
	ValaBlock* _tmp320_;
	ValaSemanticAnalyzer* _tmp323_;
	ValaSemanticAnalyzer* _tmp324_;
	ValaStruct* _tmp325_;
	ValaStruct* _tmp326_;
	gboolean _tmp362_ = FALSE;
	gboolean _tmp363_ = FALSE;
	ValaDataType* _tmp364_;
	ValaDataType* _tmp365_;
	ValaSemanticAnalyzer* _tmp412_;
	ValaSemanticAnalyzer* _tmp413_;
	ValaSourceFile* _tmp414_;
	ValaSemanticAnalyzer* _tmp415_;
	ValaSemanticAnalyzer* _tmp416_;
	ValaSymbol* _tmp417_;
	gboolean _tmp418_ = FALSE;
	gboolean _tmp419_ = FALSE;
	gboolean _tmp420_ = FALSE;
	gboolean _tmp421_;
	gboolean _tmp422_;
	ValaSemanticAnalyzer* _tmp438_;
	ValaSemanticAnalyzer* _tmp439_;
	ValaDataType* _tmp440_;
	ValaDataType* _tmp441_;
	gboolean _tmp494_ = FALSE;
	ValaBlock* _tmp495_;
	ValaBlock* _tmp496_;
	gboolean _tmp539_ = FALSE;
	gboolean _tmp540_ = FALSE;
	gboolean _tmp541_ = FALSE;
	gboolean _tmp542_ = FALSE;
	gboolean _tmp543_ = FALSE;
	ValaAttribute* _tmp603_;
	ValaAttribute* _tmp604_;
	gboolean _tmp605_;
	gboolean _tmp606_;
	gboolean _tmp607_;
	self = (ValaMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DestroysInstance");
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_ != NULL;
	_vala_code_node_unref0 (_tmp5_);
	if (_tmp6_) {
		ValaParameter* _tmp7_;
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp7_ = self->priv->_this_parameter;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) _tmp7_);
		_tmp9_ = _tmp8_;
		vala_data_type_set_value_owned (_tmp9_, TRUE);
	}
	_tmp10_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "NoThrow");
	_tmp11_ = _tmp10_;
	_tmp12_ = _tmp11_ != NULL;
	_vala_code_node_unref0 (_tmp11_);
	if (_tmp12_) {
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		_tmp13_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		vala_collection_clear ((ValaCollection*) _tmp14_);
		_vala_iterable_unref0 (_tmp14_);
	}
	_tmp16_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp17_ = _tmp16_;
	if (VALA_IS_CLASS (_tmp17_)) {
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_;
		_tmp19_ = self->priv->_is_abstract;
		if (_tmp19_) {
			_tmp18_ = TRUE;
		} else {
			gboolean _tmp20_;
			_tmp20_ = self->priv->_is_virtual;
			_tmp18_ = _tmp20_;
		}
		_tmp15_ = _tmp18_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaClass* _tmp23_;
		gboolean _tmp24_ = FALSE;
		ValaClass* _tmp25_;
		gboolean _tmp26_;
		gboolean _tmp27_;
		_tmp21_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp23_;
		_tmp25_ = cl;
		_tmp26_ = vala_class_get_is_compact (_tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_) {
			ValaClass* _tmp28_;
			ValaClass* _tmp29_;
			ValaClass* _tmp30_;
			_tmp28_ = cl;
			_tmp29_ = vala_class_get_base_class (_tmp28_);
			_tmp30_ = _tmp29_;
			_tmp24_ = _tmp30_ != NULL;
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaSourceReference* _tmp31_;
			ValaSourceReference* _tmp32_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp32_ = _tmp31_;
			vala_report_error (_tmp32_, "Abstract and virtual methods may not be declared in derived compact cl" \
"asses");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			return result;
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp33_ = self->priv->_is_abstract;
	if (_tmp33_) {
		ValaSymbol* _tmp34_;
		ValaSymbol* _tmp35_;
		_tmp34_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp35_ = _tmp34_;
		if (VALA_IS_CLASS (_tmp35_)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp36_;
			ValaSymbol* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp37_ = _tmp36_;
			_tmp38_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp38_;
			_tmp39_ = cl;
			_tmp40_ = vala_class_get_is_abstract (_tmp39_);
			_tmp41_ = _tmp40_;
			if (!_tmp41_) {
				ValaSourceReference* _tmp42_;
				ValaSourceReference* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp43_, "Abstract methods may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			_tmp44_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp45_ = _tmp44_;
			if (!VALA_IS_INTERFACE (_tmp45_)) {
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp46_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp47_ = _tmp46_;
				vala_report_error (_tmp47_, "Abstract methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp48_;
		_tmp48_ = self->priv->_is_virtual;
		if (_tmp48_) {
			gboolean _tmp49_ = FALSE;
			ValaSymbol* _tmp50_;
			ValaSymbol* _tmp51_;
			_tmp50_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp51_ = _tmp50_;
			if (!VALA_IS_CLASS (_tmp51_)) {
				ValaSymbol* _tmp52_;
				ValaSymbol* _tmp53_;
				_tmp52_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp49_ = !VALA_IS_INTERFACE (_tmp53_);
			} else {
				_tmp49_ = FALSE;
			}
			if (_tmp49_) {
				ValaSourceReference* _tmp54_;
				ValaSourceReference* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp54_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp55_, "Virtual methods may not be declared outside of classes and interfaces");
				result = FALSE;
				return result;
			}
		} else {
			gboolean _tmp56_;
			_tmp56_ = self->priv->_overrides;
			if (_tmp56_) {
				ValaSymbol* _tmp57_;
				ValaSymbol* _tmp58_;
				_tmp57_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp58_ = _tmp57_;
				if (!VALA_IS_CLASS (_tmp58_)) {
					ValaSourceReference* _tmp59_;
					ValaSourceReference* _tmp60_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp59_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp60_ = _tmp59_;
					vala_report_error (_tmp60_, "Methods may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp61_;
				ValaSymbolAccessibility _tmp62_;
				_tmp61_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp62_ = _tmp61_;
				if (_tmp62_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp63_ = FALSE;
					ValaSymbol* _tmp64_;
					ValaSymbol* _tmp65_;
					_tmp64_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp65_ = _tmp64_;
					if (!VALA_IS_CLASS (_tmp65_)) {
						ValaSymbol* _tmp66_;
						ValaSymbol* _tmp67_;
						_tmp66_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp67_ = _tmp66_;
						_tmp63_ = !VALA_IS_INTERFACE (_tmp67_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						ValaSourceReference* _tmp68_;
						ValaSourceReference* _tmp69_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp68_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp69_ = _tmp68_;
						vala_report_error (_tmp69_, "Protected methods may not be declared outside of classes and interface" \
"s");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp71_ = self->priv->_is_abstract;
	if (_tmp71_) {
		ValaBlock* _tmp72_;
		ValaBlock* _tmp73_;
		_tmp72_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp73_ = _tmp72_;
		_tmp70_ = _tmp73_ != NULL;
	} else {
		_tmp70_ = FALSE;
	}
	if (_tmp70_) {
		ValaSourceReference* _tmp74_;
		ValaSourceReference* _tmp75_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp75_ = _tmp74_;
		vala_report_error (_tmp75_, "Abstract methods cannot have bodies");
	} else {
		gboolean _tmp76_ = FALSE;
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		gboolean _tmp79_ = FALSE;
		gboolean _tmp80_;
		_tmp80_ = self->priv->_is_abstract;
		if (_tmp80_) {
			_tmp79_ = TRUE;
		} else {
			gboolean _tmp81_;
			_tmp81_ = self->priv->_is_virtual;
			_tmp79_ = _tmp81_;
		}
		if (_tmp79_) {
			gboolean _tmp82_;
			gboolean _tmp83_;
			_tmp82_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp83_ = _tmp82_;
			_tmp78_ = _tmp83_;
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			gboolean _tmp84_;
			gboolean _tmp85_;
			_tmp84_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp85_ = _tmp84_;
			_tmp77_ = !_tmp85_;
		} else {
			_tmp77_ = FALSE;
		}
		if (_tmp77_) {
			ValaSymbol* _tmp86_;
			ValaSymbol* _tmp87_;
			gboolean _tmp88_;
			gboolean _tmp89_;
			_tmp86_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp87_ = _tmp86_;
			_tmp88_ = vala_symbol_get_external (_tmp87_);
			_tmp89_ = _tmp88_;
			_tmp76_ = !_tmp89_;
		} else {
			_tmp76_ = FALSE;
		}
		if (_tmp76_) {
			ValaSourceReference* _tmp90_;
			ValaSourceReference* _tmp91_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp90_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp91_ = _tmp90_;
			vala_report_error (_tmp91_, "Extern methods cannot be abstract or virtual");
		} else {
			gboolean _tmp92_ = FALSE;
			gboolean _tmp93_;
			gboolean _tmp94_;
			_tmp93_ = vala_symbol_get_external ((ValaSymbol*) self);
			_tmp94_ = _tmp93_;
			if (_tmp94_) {
				ValaBlock* _tmp95_;
				ValaBlock* _tmp96_;
				_tmp95_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp96_ = _tmp95_;
				_tmp92_ = _tmp96_ != NULL;
			} else {
				_tmp92_ = FALSE;
			}
			if (_tmp92_) {
				ValaSourceReference* _tmp97_;
				ValaSourceReference* _tmp98_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp97_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp98_ = _tmp97_;
				vala_report_error (_tmp98_, "Extern methods cannot have bodies");
			} else {
				gboolean _tmp99_ = FALSE;
				gboolean _tmp100_ = FALSE;
				gboolean _tmp101_ = FALSE;
				gboolean _tmp102_;
				_tmp102_ = self->priv->_is_abstract;
				if (!_tmp102_) {
					gboolean _tmp103_;
					gboolean _tmp104_;
					_tmp103_ = vala_symbol_get_external ((ValaSymbol*) self);
					_tmp104_ = _tmp103_;
					_tmp101_ = !_tmp104_;
				} else {
					_tmp101_ = FALSE;
				}
				if (_tmp101_) {
					ValaSourceFileType _tmp105_;
					ValaSourceFileType _tmp106_;
					_tmp105_ = vala_symbol_get_source_type ((ValaSymbol*) self);
					_tmp106_ = _tmp105_;
					_tmp100_ = _tmp106_ == VALA_SOURCE_FILE_TYPE_SOURCE;
				} else {
					_tmp100_ = FALSE;
				}
				if (_tmp100_) {
					ValaBlock* _tmp107_;
					ValaBlock* _tmp108_;
					_tmp107_ = vala_subroutine_get_body ((ValaSubroutine*) self);
					_tmp108_ = _tmp107_;
					_tmp99_ = _tmp108_ == NULL;
				} else {
					_tmp99_ = FALSE;
				}
				if (_tmp99_) {
					ValaSourceReference* _tmp109_;
					ValaSourceReference* _tmp110_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp110_ = _tmp109_;
					vala_report_error (_tmp110_, "Non-abstract, non-extern methods must have bodies");
				}
			}
		}
	}
	_tmp113_ = self->priv->_coroutine;
	if (_tmp113_) {
		gboolean _tmp114_;
		gboolean _tmp115_;
		_tmp114_ = vala_symbol_get_external_package ((ValaSymbol*) self);
		_tmp115_ = _tmp114_;
		_tmp112_ = !_tmp115_;
	} else {
		_tmp112_ = FALSE;
	}
	if (_tmp112_) {
		_tmp111_ = !vala_code_context_has_package (context, "gio-2.0");
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		ValaSourceReference* _tmp116_;
		ValaSourceReference* _tmp117_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp116_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp117_ = _tmp116_;
		vala_report_error (_tmp117_, "gio-2.0 package required for async methods");
		result = FALSE;
		return result;
	}
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_semantic_analyzer_get_current_source_file (_tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _vala_source_file_ref0 (_tmp121_);
	old_source_file = _tmp122_;
	_tmp123_ = vala_code_context_get_analyzer (context);
	_tmp124_ = _tmp123_;
	_tmp125_ = vala_semantic_analyzer_get_current_symbol (_tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = _vala_code_node_ref0 (_tmp126_);
	old_symbol = _tmp127_;
	_tmp128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp129_ = _tmp128_;
	if (_tmp129_ != NULL) {
		ValaSemanticAnalyzer* _tmp130_;
		ValaSemanticAnalyzer* _tmp131_;
		ValaSourceReference* _tmp132_;
		ValaSourceReference* _tmp133_;
		ValaSourceFile* _tmp134_;
		ValaSourceFile* _tmp135_;
		_tmp130_ = vala_code_context_get_analyzer (context);
		_tmp131_ = _tmp130_;
		_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp133_ = _tmp132_;
		_tmp134_ = vala_source_reference_get_file (_tmp133_);
		_tmp135_ = _tmp134_;
		vala_semantic_analyzer_set_current_source_file (_tmp131_, _tmp135_);
	}
	_tmp136_ = vala_code_context_get_analyzer (context);
	_tmp137_ = _tmp136_;
	vala_semantic_analyzer_set_current_symbol (_tmp137_, (ValaSymbol*) self);
	_tmp138_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp139_ = _tmp138_;
	vala_code_node_check ((ValaCodeNode*) _tmp139_, context);
	_tmp140_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_data_type_get_data_type (_tmp141_);
	_tmp143_ = _tmp142_;
	_tmp144_ = vala_code_context_get_analyzer (context);
	_tmp145_ = _tmp144_;
	_tmp146_ = _tmp145_->va_list_type;
	_tmp147_ = vala_data_type_get_data_type (_tmp146_);
	_tmp148_ = _tmp147_;
	if (_tmp143_ == _tmp148_) {
		ValaSourceReference* _tmp149_;
		ValaSourceReference* _tmp150_;
		ValaDataType* _tmp151_;
		ValaDataType* _tmp152_;
		ValaTypeSymbol* _tmp153_;
		ValaTypeSymbol* _tmp154_;
		gchar* _tmp155_;
		gchar* _tmp156_;
		gchar* _tmp157_;
		gchar* _tmp158_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp149_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp150_ = _tmp149_;
		_tmp151_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp152_ = _tmp151_;
		_tmp153_ = vala_data_type_get_data_type (_tmp152_);
		_tmp154_ = _tmp153_;
		_tmp155_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp154_);
		_tmp156_ = _tmp155_;
		_tmp157_ = g_strdup_printf ("`%s' not supported as return type", _tmp156_);
		_tmp158_ = _tmp157_;
		vala_report_error (_tmp150_, _tmp158_);
		_g_free0 (_tmp158_);
		_g_free0 (_tmp156_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp159_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ModuleInit");
	init_attr = _tmp159_;
	_tmp160_ = init_attr;
	if (_tmp160_ != NULL) {
		ValaSourceReference* _tmp161_;
		ValaSourceReference* _tmp162_;
		ValaSourceFile* _tmp163_;
		ValaSourceFile* _tmp164_;
		ValaCodeContext* _tmp165_;
		ValaCodeContext* _tmp166_;
		_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp162_ = _tmp161_;
		_tmp163_ = vala_source_reference_get_file (_tmp162_);
		_tmp164_ = _tmp163_;
		_tmp165_ = vala_source_file_get_context (_tmp164_);
		_tmp166_ = _tmp165_;
		vala_code_context_set_module_init_method (_tmp166_, self);
	}
	_tmp167_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp168_ = _tmp167_;
	if (_tmp168_ != NULL) {
		ValaDataType* _tmp169_;
		ValaDataType* _tmp170_;
		_tmp169_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp170_ = _tmp169_;
		vala_code_node_check ((ValaCodeNode*) _tmp170_, context);
	}
	_tmp174_ = self->priv->parameters;
	_tmp175_ = vala_collection_get_size ((ValaCollection*) _tmp174_);
	_tmp176_ = _tmp175_;
	if (_tmp176_ == 1) {
		ValaList* _tmp177_;
		gpointer _tmp178_;
		ValaParameter* _tmp179_;
		gboolean _tmp180_;
		gboolean _tmp181_;
		_tmp177_ = self->priv->parameters;
		_tmp178_ = vala_list_get (_tmp177_, 0);
		_tmp179_ = (ValaParameter*) _tmp178_;
		_tmp180_ = vala_parameter_get_ellipsis (_tmp179_);
		_tmp181_ = _tmp180_;
		_tmp173_ = _tmp181_;
		_vala_code_node_unref0 (_tmp179_);
	} else {
		_tmp173_ = FALSE;
	}
	if (_tmp173_) {
		ValaBlock* _tmp182_;
		ValaBlock* _tmp183_;
		_tmp182_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp183_ = _tmp182_;
		_tmp172_ = _tmp183_ != NULL;
	} else {
		_tmp172_ = FALSE;
	}
	if (_tmp172_) {
		ValaMemberBinding _tmp184_;
		_tmp184_ = self->priv->_binding;
		_tmp171_ = _tmp184_ != VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp171_ = FALSE;
	}
	if (_tmp171_) {
		ValaList* _tmp185_;
		gpointer _tmp186_;
		ValaParameter* _tmp187_;
		ValaSourceReference* _tmp188_;
		ValaSourceReference* _tmp189_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp185_ = self->priv->parameters;
		_tmp186_ = vala_list_get (_tmp185_, 0);
		_tmp187_ = (ValaParameter*) _tmp186_;
		_tmp188_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp187_);
		_tmp189_ = _tmp188_;
		vala_report_error (_tmp189_, "Named parameter required before `...'");
		_vala_code_node_unref0 (_tmp187_);
	}
	_tmp191_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Print");
	_tmp192_ = _tmp191_;
	_tmp193_ = _tmp192_ != NULL;
	_vala_code_node_unref0 (_tmp192_);
	if (_tmp193_) {
		gboolean _tmp194_ = FALSE;
		ValaList* _tmp195_;
		gint _tmp196_;
		gint _tmp197_;
		_tmp195_ = self->priv->parameters;
		_tmp196_ = vala_collection_get_size ((ValaCollection*) _tmp195_);
		_tmp197_ = _tmp196_;
		if (_tmp197_ != 1) {
			_tmp194_ = TRUE;
		} else {
			ValaList* _tmp198_;
			gpointer _tmp199_;
			ValaParameter* _tmp200_;
			ValaDataType* _tmp201_;
			ValaDataType* _tmp202_;
			ValaTypeSymbol* _tmp203_;
			ValaTypeSymbol* _tmp204_;
			ValaSemanticAnalyzer* _tmp205_;
			ValaSemanticAnalyzer* _tmp206_;
			ValaDataType* _tmp207_;
			ValaTypeSymbol* _tmp208_;
			ValaTypeSymbol* _tmp209_;
			_tmp198_ = self->priv->parameters;
			_tmp199_ = vala_list_get (_tmp198_, 0);
			_tmp200_ = (ValaParameter*) _tmp199_;
			_tmp201_ = vala_variable_get_variable_type ((ValaVariable*) _tmp200_);
			_tmp202_ = _tmp201_;
			_tmp203_ = vala_data_type_get_data_type (_tmp202_);
			_tmp204_ = _tmp203_;
			_tmp205_ = vala_code_context_get_analyzer (context);
			_tmp206_ = _tmp205_;
			_tmp207_ = _tmp206_->string_type;
			_tmp208_ = vala_data_type_get_data_type (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp194_ = _tmp204_ != _tmp209_;
			_vala_code_node_unref0 (_tmp200_);
		}
		_tmp190_ = _tmp194_;
	} else {
		_tmp190_ = FALSE;
	}
	if (_tmp190_) {
		ValaSourceReference* _tmp210_;
		ValaSourceReference* _tmp211_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp210_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp211_ = _tmp210_;
		vala_report_error (_tmp211_, "[Print] methods must have exactly one parameter of type `string'");
	}
	optional_param = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp212_;
		ValaList* _tmp213_;
		gint _param_size = 0;
		ValaList* _tmp214_;
		gint _tmp215_;
		gint _tmp216_;
		gint _param_index = 0;
		_tmp212_ = self->priv->parameters;
		_tmp213_ = _vala_iterable_ref0 (_tmp212_);
		_param_list = _tmp213_;
		_tmp214_ = _param_list;
		_tmp215_ = vala_collection_get_size ((ValaCollection*) _tmp214_);
		_tmp216_ = _tmp215_;
		_param_size = _tmp216_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp217_;
			gint _tmp218_;
			ValaParameter* param = NULL;
			ValaList* _tmp219_;
			gint _tmp220_;
			gpointer _tmp221_;
			ValaParameter* _tmp222_;
			gboolean _tmp223_ = FALSE;
			gboolean _tmp224_;
			gboolean _tmp231_ = FALSE;
			gboolean _tmp232_ = FALSE;
			gboolean _tmp233_;
			gboolean _tmp234_;
			gboolean _tmp253_;
			gboolean _tmp254_ = FALSE;
			gboolean _tmp255_ = FALSE;
			gboolean _tmp256_;
			_param_index = _param_index + 1;
			_tmp217_ = _param_index;
			_tmp218_ = _param_size;
			if (!(_tmp217_ < _tmp218_)) {
				break;
			}
			_tmp219_ = _param_list;
			_tmp220_ = _param_index;
			_tmp221_ = vala_list_get (_tmp219_, _tmp220_);
			param = (ValaParameter*) _tmp221_;
			_tmp222_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp222_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp224_ = self->priv->_coroutine;
			if (_tmp224_) {
				ValaParameter* _tmp225_;
				ValaParameterDirection _tmp226_;
				ValaParameterDirection _tmp227_;
				_tmp225_ = param;
				_tmp226_ = vala_parameter_get_direction (_tmp225_);
				_tmp227_ = _tmp226_;
				_tmp223_ = _tmp227_ == VALA_PARAMETER_DIRECTION_REF;
			} else {
				_tmp223_ = FALSE;
			}
			if (_tmp223_) {
				ValaParameter* _tmp228_;
				ValaSourceReference* _tmp229_;
				ValaSourceReference* _tmp230_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp228_ = param;
				_tmp229_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp228_);
				_tmp230_ = _tmp229_;
				vala_report_error (_tmp230_, "Reference parameters are not supported for async methods");
			}
			_tmp233_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp234_ = _tmp233_;
			if (!_tmp234_) {
				gboolean _tmp235_;
				_tmp235_ = self->priv->_coroutine;
				_tmp232_ = _tmp235_;
			} else {
				_tmp232_ = FALSE;
			}
			if (_tmp232_) {
				gboolean _tmp236_ = FALSE;
				ValaParameter* _tmp237_;
				gboolean _tmp238_;
				gboolean _tmp239_;
				_tmp237_ = param;
				_tmp238_ = vala_parameter_get_ellipsis (_tmp237_);
				_tmp239_ = _tmp238_;
				if (_tmp239_) {
					_tmp236_ = TRUE;
				} else {
					ValaParameter* _tmp240_;
					ValaDataType* _tmp241_;
					ValaDataType* _tmp242_;
					ValaTypeSymbol* _tmp243_;
					ValaTypeSymbol* _tmp244_;
					ValaSemanticAnalyzer* _tmp245_;
					ValaSemanticAnalyzer* _tmp246_;
					ValaDataType* _tmp247_;
					ValaTypeSymbol* _tmp248_;
					ValaTypeSymbol* _tmp249_;
					_tmp240_ = param;
					_tmp241_ = vala_variable_get_variable_type ((ValaVariable*) _tmp240_);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_data_type_get_data_type (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_code_context_get_analyzer (context);
					_tmp246_ = _tmp245_;
					_tmp247_ = _tmp246_->va_list_type;
					_tmp248_ = vala_data_type_get_data_type (_tmp247_);
					_tmp249_ = _tmp248_;
					_tmp236_ = _tmp244_ == _tmp249_;
				}
				_tmp231_ = _tmp236_;
			} else {
				_tmp231_ = FALSE;
			}
			if (_tmp231_) {
				ValaParameter* _tmp250_;
				ValaSourceReference* _tmp251_;
				ValaSourceReference* _tmp252_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp250_ = param;
				_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp250_);
				_tmp252_ = _tmp251_;
				vala_report_error (_tmp252_, "Variadic parameters are not supported for async methods");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp253_ = self->priv->_coroutine;
			if (_tmp253_) {
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp256_ = optional_param;
			if (_tmp256_) {
				ValaParameter* _tmp257_;
				ValaExpression* _tmp258_;
				ValaExpression* _tmp259_;
				_tmp257_ = param;
				_tmp258_ = vala_variable_get_initializer ((ValaVariable*) _tmp257_);
				_tmp259_ = _tmp258_;
				_tmp255_ = _tmp259_ == NULL;
			} else {
				_tmp255_ = FALSE;
			}
			if (_tmp255_) {
				ValaParameter* _tmp260_;
				gboolean _tmp261_;
				gboolean _tmp262_;
				_tmp260_ = param;
				_tmp261_ = vala_parameter_get_ellipsis (_tmp260_);
				_tmp262_ = _tmp261_;
				_tmp254_ = !_tmp262_;
			} else {
				_tmp254_ = FALSE;
			}
			if (_tmp254_) {
				ValaParameter* _tmp263_;
				ValaSourceReference* _tmp264_;
				ValaSourceReference* _tmp265_;
				_tmp263_ = param;
				_tmp264_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp263_);
				_tmp265_ = _tmp264_;
				vala_report_warning (_tmp265_, "parameter without default follows parameter with default");
			} else {
				ValaParameter* _tmp266_;
				ValaExpression* _tmp267_;
				ValaExpression* _tmp268_;
				_tmp266_ = param;
				_tmp267_ = vala_variable_get_initializer ((ValaVariable*) _tmp266_);
				_tmp268_ = _tmp267_;
				if (_tmp268_ != NULL) {
					optional_param = TRUE;
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp269_;
		gint _error_type_size = 0;
		ValaList* _tmp270_;
		gint _tmp271_;
		gint _tmp272_;
		gint _error_type_index = 0;
		_tmp269_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp269_;
		_tmp270_ = _error_type_list;
		_tmp271_ = vala_collection_get_size ((ValaCollection*) _tmp270_);
		_tmp272_ = _tmp271_;
		_error_type_size = _tmp272_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp273_;
			gint _tmp274_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp275_;
			gint _tmp276_;
			gpointer _tmp277_;
			ValaDataType* _tmp278_;
			ValaSemanticAnalyzer* _tmp279_;
			ValaSemanticAnalyzer* _tmp280_;
			ValaDataType* _tmp281_;
			_error_type_index = _error_type_index + 1;
			_tmp273_ = _error_type_index;
			_tmp274_ = _error_type_size;
			if (!(_tmp273_ < _tmp274_)) {
				break;
			}
			_tmp275_ = _error_type_list;
			_tmp276_ = _error_type_index;
			_tmp277_ = vala_list_get (_tmp275_, _tmp276_);
			error_type = (ValaDataType*) _tmp277_;
			_tmp278_ = error_type;
			vala_code_node_check ((ValaCodeNode*) _tmp278_, context);
			_tmp279_ = vala_code_context_get_analyzer (context);
			_tmp280_ = _tmp279_;
			_tmp281_ = error_type;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp280_, (ValaSymbol*) self, _tmp281_)) {
				ValaSourceReference* _tmp282_;
				ValaSourceReference* _tmp283_;
				ValaDataType* _tmp284_;
				gchar* _tmp285_;
				gchar* _tmp286_;
				gchar* _tmp287_;
				gchar* _tmp288_;
				gchar* _tmp289_;
				gchar* _tmp290_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp282_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp283_ = _tmp282_;
				_tmp284_ = error_type;
				_tmp285_ = vala_code_node_to_string ((ValaCodeNode*) _tmp284_);
				_tmp286_ = _tmp285_;
				_tmp287_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp288_ = _tmp287_;
				_tmp289_ = g_strdup_printf ("error type `%s` is less accessible than method `%s`", _tmp286_, _tmp288_);
				_tmp290_ = _tmp289_;
				vala_report_error (_tmp283_, _tmp290_);
				_g_free0 (_tmp290_);
				_g_free0 (_tmp288_);
				_g_free0 (_tmp286_);
				result = FALSE;
				_vala_code_node_unref0 (error_type);
				_vala_iterable_unref0 (_error_type_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp291_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
	_tmp292_ = _tmp291_;
	if (_tmp292_ != NULL) {
		ValaLocalVariable* _tmp293_;
		ValaLocalVariable* _tmp294_;
		_tmp293_ = vala_subroutine_get_result_var ((ValaSubroutine*) self);
		_tmp294_ = _tmp293_;
		vala_code_node_check ((ValaCodeNode*) _tmp294_, context);
	}
	_tmp295_ = self->priv->preconditions;
	if (_tmp295_ != NULL) {
		{
			ValaList* _precondition_list = NULL;
			ValaList* _tmp296_;
			ValaList* _tmp297_;
			gint _precondition_size = 0;
			ValaList* _tmp298_;
			gint _tmp299_;
			gint _tmp300_;
			gint _precondition_index = 0;
			_tmp296_ = self->priv->preconditions;
			_tmp297_ = _vala_iterable_ref0 (_tmp296_);
			_precondition_list = _tmp297_;
			_tmp298_ = _precondition_list;
			_tmp299_ = vala_collection_get_size ((ValaCollection*) _tmp298_);
			_tmp300_ = _tmp299_;
			_precondition_size = _tmp300_;
			_precondition_index = -1;
			while (TRUE) {
				gint _tmp301_;
				gint _tmp302_;
				ValaExpression* precondition = NULL;
				ValaList* _tmp303_;
				gint _tmp304_;
				gpointer _tmp305_;
				ValaExpression* _tmp306_;
				_precondition_index = _precondition_index + 1;
				_tmp301_ = _precondition_index;
				_tmp302_ = _precondition_size;
				if (!(_tmp301_ < _tmp302_)) {
					break;
				}
				_tmp303_ = _precondition_list;
				_tmp304_ = _precondition_index;
				_tmp305_ = vala_list_get (_tmp303_, _tmp304_);
				precondition = (ValaExpression*) _tmp305_;
				_tmp306_ = precondition;
				vala_code_node_check ((ValaCodeNode*) _tmp306_, context);
				_vala_code_node_unref0 (precondition);
			}
			_vala_iterable_unref0 (_precondition_list);
		}
	}
	_tmp307_ = self->priv->postconditions;
	if (_tmp307_ != NULL) {
		{
			ValaList* _postcondition_list = NULL;
			ValaList* _tmp308_;
			ValaList* _tmp309_;
			gint _postcondition_size = 0;
			ValaList* _tmp310_;
			gint _tmp311_;
			gint _tmp312_;
			gint _postcondition_index = 0;
			_tmp308_ = self->priv->postconditions;
			_tmp309_ = _vala_iterable_ref0 (_tmp308_);
			_postcondition_list = _tmp309_;
			_tmp310_ = _postcondition_list;
			_tmp311_ = vala_collection_get_size ((ValaCollection*) _tmp310_);
			_tmp312_ = _tmp311_;
			_postcondition_size = _tmp312_;
			_postcondition_index = -1;
			while (TRUE) {
				gint _tmp313_;
				gint _tmp314_;
				ValaExpression* postcondition = NULL;
				ValaList* _tmp315_;
				gint _tmp316_;
				gpointer _tmp317_;
				ValaExpression* _tmp318_;
				_postcondition_index = _postcondition_index + 1;
				_tmp313_ = _postcondition_index;
				_tmp314_ = _postcondition_size;
				if (!(_tmp313_ < _tmp314_)) {
					break;
				}
				_tmp315_ = _postcondition_list;
				_tmp316_ = _postcondition_index;
				_tmp317_ = vala_list_get (_tmp315_, _tmp316_);
				postcondition = (ValaExpression*) _tmp317_;
				_tmp318_ = postcondition;
				vala_code_node_check ((ValaCodeNode*) _tmp318_, context);
				_vala_code_node_unref0 (postcondition);
			}
			_vala_iterable_unref0 (_postcondition_list);
		}
	}
	_tmp319_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp320_ = _tmp319_;
	if (_tmp320_ != NULL) {
		ValaBlock* _tmp321_;
		ValaBlock* _tmp322_;
		_tmp321_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp322_ = _tmp321_;
		vala_code_node_check ((ValaCodeNode*) _tmp322_, context);
	}
	_tmp323_ = vala_code_context_get_analyzer (context);
	_tmp324_ = _tmp323_;
	_tmp325_ = vala_semantic_analyzer_get_current_struct (_tmp324_);
	_tmp326_ = _tmp325_;
	if (_tmp326_ != NULL) {
		gboolean _tmp327_ = FALSE;
		gboolean _tmp328_ = FALSE;
		gboolean _tmp329_;
		_tmp329_ = self->priv->_is_abstract;
		if (_tmp329_) {
			_tmp328_ = TRUE;
		} else {
			gboolean _tmp330_;
			_tmp330_ = self->priv->_is_virtual;
			_tmp328_ = _tmp330_;
		}
		if (_tmp328_) {
			_tmp327_ = TRUE;
		} else {
			gboolean _tmp331_;
			_tmp331_ = self->priv->_overrides;
			_tmp327_ = _tmp331_;
		}
		if (_tmp327_) {
			ValaSourceReference* _tmp332_;
			ValaSourceReference* _tmp333_;
			gchar* _tmp334_;
			gchar* _tmp335_;
			gchar* _tmp336_;
			gchar* _tmp337_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp332_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp333_ = _tmp332_;
			_tmp334_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp335_ = _tmp334_;
			_tmp336_ = g_strdup_printf ("A struct member `%s' cannot be marked as override, virtual, or abstrac" \
"t", _tmp335_);
			_tmp337_ = _tmp336_;
			vala_report_error (_tmp333_, _tmp337_);
			_g_free0 (_tmp337_);
			_g_free0 (_tmp335_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
	} else {
		gboolean _tmp338_ = FALSE;
		gboolean _tmp339_;
		_tmp339_ = self->priv->_overrides;
		if (_tmp339_) {
			ValaMethod* _tmp340_;
			ValaMethod* _tmp341_;
			_tmp340_ = vala_method_get_base_method (self);
			_tmp341_ = _tmp340_;
			_tmp338_ = _tmp341_ == NULL;
		} else {
			_tmp338_ = FALSE;
		}
		if (_tmp338_) {
			ValaSourceReference* _tmp342_;
			ValaSourceReference* _tmp343_;
			gchar* _tmp344_;
			gchar* _tmp345_;
			gchar* _tmp346_;
			gchar* _tmp347_;
			_tmp342_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp343_ = _tmp342_;
			_tmp344_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp345_ = _tmp344_;
			_tmp346_ = g_strdup_printf ("`%s': no suitable method found to override", _tmp345_);
			_tmp347_ = _tmp346_;
			vala_report_error (_tmp343_, _tmp347_);
			_g_free0 (_tmp347_);
			_g_free0 (_tmp345_);
		} else {
			gboolean _tmp348_ = FALSE;
			gboolean _tmp349_ = FALSE;
			gboolean _tmp350_ = FALSE;
			gboolean _tmp351_;
			_tmp351_ = self->priv->_is_abstract;
			if (_tmp351_) {
				_tmp350_ = TRUE;
			} else {
				gboolean _tmp352_;
				_tmp352_ = self->priv->_is_virtual;
				_tmp350_ = _tmp352_;
			}
			if (_tmp350_) {
				_tmp349_ = TRUE;
			} else {
				gboolean _tmp353_;
				_tmp353_ = self->priv->_overrides;
				_tmp349_ = _tmp353_;
			}
			if (_tmp349_) {
				ValaSymbolAccessibility _tmp354_;
				ValaSymbolAccessibility _tmp355_;
				_tmp354_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp355_ = _tmp354_;
				_tmp348_ = _tmp355_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
			} else {
				_tmp348_ = FALSE;
			}
			if (_tmp348_) {
				ValaSourceReference* _tmp356_;
				ValaSourceReference* _tmp357_;
				gchar* _tmp358_;
				gchar* _tmp359_;
				gchar* _tmp360_;
				gchar* _tmp361_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp356_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp357_ = _tmp356_;
				_tmp358_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp359_ = _tmp358_;
				_tmp360_ = g_strdup_printf ("Private member `%s' cannot be marked as override, virtual, or abstract", _tmp359_);
				_tmp361_ = _tmp360_;
				vala_report_error (_tmp357_, _tmp361_);
				_g_free0 (_tmp361_);
				_g_free0 (_tmp359_);
				result = FALSE;
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
		}
	}
	_tmp364_ = vala_method_get_base_interface_type (self);
	_tmp365_ = _tmp364_;
	if (_tmp365_ != NULL) {
		ValaMethod* _tmp366_;
		ValaMethod* _tmp367_;
		_tmp366_ = vala_method_get_base_interface_method (self);
		_tmp367_ = _tmp366_;
		_tmp363_ = _tmp367_ != NULL;
	} else {
		_tmp363_ = FALSE;
	}
	if (_tmp363_) {
		ValaSymbol* _tmp368_;
		ValaSymbol* _tmp369_;
		_tmp368_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp369_ = _tmp368_;
		_tmp362_ = VALA_IS_CLASS (_tmp369_);
	} else {
		_tmp362_ = FALSE;
	}
	if (_tmp362_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp370_;
		ValaSymbol* _tmp371_;
		ValaClass* _tmp372_;
		_tmp370_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp371_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp372_;
		{
			ValaList* _m_list = NULL;
			ValaClass* _tmp373_;
			ValaList* _tmp374_;
			gint _m_size = 0;
			ValaList* _tmp375_;
			gint _tmp376_;
			gint _tmp377_;
			gint _m_index = 0;
			_tmp373_ = cl;
			_tmp374_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp373_);
			_m_list = _tmp374_;
			_tmp375_ = _m_list;
			_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
			_tmp377_ = _tmp376_;
			_m_size = _tmp377_;
			_m_index = -1;
			while (TRUE) {
				gint _tmp378_;
				gint _tmp379_;
				ValaMethod* m = NULL;
				ValaList* _tmp380_;
				gint _tmp381_;
				gpointer _tmp382_;
				gboolean _tmp383_ = FALSE;
				ValaMethod* _tmp384_;
				_m_index = _m_index + 1;
				_tmp378_ = _m_index;
				_tmp379_ = _m_size;
				if (!(_tmp378_ < _tmp379_)) {
					break;
				}
				_tmp380_ = _m_list;
				_tmp381_ = _m_index;
				_tmp382_ = vala_list_get (_tmp380_, _tmp381_);
				m = (ValaMethod*) _tmp382_;
				_tmp384_ = m;
				if (_tmp384_ != self) {
					ValaMethod* _tmp385_;
					ValaMethod* _tmp386_;
					ValaMethod* _tmp387_;
					ValaMethod* _tmp388_;
					ValaMethod* _tmp389_;
					_tmp385_ = m;
					_tmp386_ = vala_method_get_base_interface_method (_tmp385_);
					_tmp387_ = _tmp386_;
					_tmp388_ = vala_method_get_base_interface_method (self);
					_tmp389_ = _tmp388_;
					_tmp383_ = _tmp387_ == _tmp389_;
				} else {
					_tmp383_ = FALSE;
				}
				if (_tmp383_) {
					ValaMethod* _tmp390_;
					ValaMethod* _tmp391_;
					ValaSourceReference* _tmp392_;
					ValaSourceReference* _tmp393_;
					ValaClass* _tmp394_;
					gchar* _tmp395_;
					gchar* _tmp396_;
					ValaMethod* _tmp397_;
					ValaMethod* _tmp398_;
					gchar* _tmp399_;
					gchar* _tmp400_;
					gchar* _tmp401_;
					gchar* _tmp402_;
					ValaMethod* _tmp403_;
					ValaSourceReference* _tmp404_;
					ValaSourceReference* _tmp405_;
					ValaMethod* _tmp406_;
					ValaMethod* _tmp407_;
					gchar* _tmp408_;
					gchar* _tmp409_;
					gchar* _tmp410_;
					gchar* _tmp411_;
					_tmp390_ = m;
					vala_code_node_set_checked ((ValaCodeNode*) _tmp390_, TRUE);
					_tmp391_ = m;
					vala_code_node_set_error ((ValaCodeNode*) _tmp391_, TRUE);
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp392_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp393_ = _tmp392_;
					_tmp394_ = cl;
					_tmp395_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp394_);
					_tmp396_ = _tmp395_;
					_tmp397_ = vala_method_get_base_interface_method (self);
					_tmp398_ = _tmp397_;
					_tmp399_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp398_);
					_tmp400_ = _tmp399_;
					_tmp401_ = g_strdup_printf ("`%s' already contains an implementation for `%s'", _tmp396_, _tmp400_);
					_tmp402_ = _tmp401_;
					vala_report_error (_tmp393_, _tmp402_);
					_g_free0 (_tmp402_);
					_g_free0 (_tmp400_);
					_g_free0 (_tmp396_);
					_tmp403_ = m;
					_tmp404_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp403_);
					_tmp405_ = _tmp404_;
					_tmp406_ = vala_method_get_base_interface_method (self);
					_tmp407_ = _tmp406_;
					_tmp408_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp407_);
					_tmp409_ = _tmp408_;
					_tmp410_ = g_strdup_printf ("previous implementation of `%s' was here", _tmp409_);
					_tmp411_ = _tmp410_;
					vala_report_notice (_tmp405_, _tmp411_);
					_g_free0 (_tmp411_);
					_g_free0 (_tmp409_);
					result = FALSE;
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (_m_list);
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (init_attr);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
				_vala_code_node_unref0 (m);
			}
			_vala_iterable_unref0 (_m_list);
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp412_ = vala_code_context_get_analyzer (context);
	_tmp413_ = _tmp412_;
	_tmp414_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp413_, _tmp414_);
	_tmp415_ = vala_code_context_get_analyzer (context);
	_tmp416_ = _tmp415_;
	_tmp417_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp416_, _tmp417_);
	_tmp421_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp422_ = _tmp421_;
	if (!_tmp422_) {
		gboolean _tmp423_;
		_tmp423_ = self->priv->_overrides;
		_tmp420_ = !_tmp423_;
	} else {
		_tmp420_ = FALSE;
	}
	if (_tmp420_) {
		gboolean _tmp424_;
		gboolean _tmp425_;
		_tmp424_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp425_ = _tmp424_;
		_tmp419_ = !_tmp425_;
	} else {
		_tmp419_ = FALSE;
	}
	if (_tmp419_) {
		ValaSymbol* _tmp426_;
		ValaSymbol* _tmp427_;
		_tmp426_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp427_ = _tmp426_;
		_tmp418_ = _tmp427_ != NULL;
		_vala_code_node_unref0 (_tmp427_);
	} else {
		_tmp418_ = FALSE;
	}
	if (_tmp418_) {
		ValaSourceReference* _tmp428_;
		ValaSourceReference* _tmp429_;
		gchar* _tmp430_;
		gchar* _tmp431_;
		ValaSymbol* _tmp432_;
		ValaSymbol* _tmp433_;
		gchar* _tmp434_;
		gchar* _tmp435_;
		gchar* _tmp436_;
		gchar* _tmp437_;
		_tmp428_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp429_ = _tmp428_;
		_tmp430_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp431_ = _tmp430_;
		_tmp432_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp433_ = _tmp432_;
		_tmp434_ = vala_symbol_get_full_name (_tmp433_);
		_tmp435_ = _tmp434_;
		_tmp436_ = g_strdup_printf ("%s hides inherited method `%s'. Use the `new' keyword if hiding was in" \
"tentional", _tmp431_, _tmp435_);
		_tmp437_ = _tmp436_;
		vala_report_warning (_tmp429_, _tmp437_);
		_g_free0 (_tmp437_);
		_g_free0 (_tmp435_);
		_vala_code_node_unref0 (_tmp433_);
		_g_free0 (_tmp431_);
	}
	_tmp438_ = vala_code_context_get_analyzer (context);
	_tmp439_ = _tmp438_;
	_tmp440_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp441_ = _tmp440_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp439_, (ValaSymbol*) self, _tmp441_)) {
		ValaSourceReference* _tmp442_;
		ValaSourceReference* _tmp443_;
		ValaDataType* _tmp444_;
		ValaDataType* _tmp445_;
		gchar* _tmp446_;
		gchar* _tmp447_;
		gchar* _tmp448_;
		gchar* _tmp449_;
		gchar* _tmp450_;
		gchar* _tmp451_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp442_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp443_ = _tmp442_;
		_tmp444_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp445_ = _tmp444_;
		_tmp446_ = vala_code_node_to_string ((ValaCodeNode*) _tmp445_);
		_tmp447_ = _tmp446_;
		_tmp448_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp449_ = _tmp448_;
		_tmp450_ = g_strdup_printf ("return type `%s` is less accessible than method `%s`", _tmp447_, _tmp449_);
		_tmp451_ = _tmp450_;
		vala_report_error (_tmp443_, _tmp451_);
		_g_free0 (_tmp451_);
		_g_free0 (_tmp449_);
		_g_free0 (_tmp447_);
		result = FALSE;
		_vala_code_node_unref0 (init_attr);
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp452_;
		gint _precondition_size = 0;
		ValaList* _tmp453_;
		gint _tmp454_;
		gint _tmp455_;
		gint _precondition_index = 0;
		_tmp452_ = vala_method_get_preconditions (self);
		_precondition_list = _tmp452_;
		_tmp453_ = _precondition_list;
		_tmp454_ = vala_collection_get_size ((ValaCollection*) _tmp453_);
		_tmp455_ = _tmp454_;
		_precondition_size = _tmp455_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp456_;
			gint _tmp457_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp458_;
			gint _tmp459_;
			gpointer _tmp460_;
			ValaExpression* _tmp461_;
			gboolean _tmp462_;
			gboolean _tmp463_;
			ValaExpression* _tmp464_;
			ValaDataType* _tmp465_;
			ValaDataType* _tmp466_;
			ValaSemanticAnalyzer* _tmp467_;
			ValaSemanticAnalyzer* _tmp468_;
			ValaDataType* _tmp469_;
			_precondition_index = _precondition_index + 1;
			_tmp456_ = _precondition_index;
			_tmp457_ = _precondition_size;
			if (!(_tmp456_ < _tmp457_)) {
				break;
			}
			_tmp458_ = _precondition_list;
			_tmp459_ = _precondition_index;
			_tmp460_ = vala_list_get (_tmp458_, _tmp459_);
			precondition = (ValaExpression*) _tmp460_;
			_tmp461_ = precondition;
			_tmp462_ = vala_code_node_get_error ((ValaCodeNode*) _tmp461_);
			_tmp463_ = _tmp462_;
			if (_tmp463_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp464_ = precondition;
			_tmp465_ = vala_expression_get_value_type (_tmp464_);
			_tmp466_ = _tmp465_;
			_tmp467_ = vala_code_context_get_analyzer (context);
			_tmp468_ = _tmp467_;
			_tmp469_ = _tmp468_->bool_type;
			if (!vala_data_type_compatible (_tmp466_, _tmp469_)) {
				ValaExpression* _tmp470_;
				ValaSourceReference* _tmp471_;
				ValaSourceReference* _tmp472_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp470_ = precondition;
				_tmp471_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp470_);
				_tmp472_ = _tmp471_;
				vala_report_error (_tmp472_, "Precondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (precondition);
				_vala_iterable_unref0 (_precondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp473_;
		gint _postcondition_size = 0;
		ValaList* _tmp474_;
		gint _tmp475_;
		gint _tmp476_;
		gint _postcondition_index = 0;
		_tmp473_ = vala_method_get_postconditions (self);
		_postcondition_list = _tmp473_;
		_tmp474_ = _postcondition_list;
		_tmp475_ = vala_collection_get_size ((ValaCollection*) _tmp474_);
		_tmp476_ = _tmp475_;
		_postcondition_size = _tmp476_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp477_;
			gint _tmp478_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp479_;
			gint _tmp480_;
			gpointer _tmp481_;
			ValaExpression* _tmp482_;
			gboolean _tmp483_;
			gboolean _tmp484_;
			ValaExpression* _tmp485_;
			ValaDataType* _tmp486_;
			ValaDataType* _tmp487_;
			ValaSemanticAnalyzer* _tmp488_;
			ValaSemanticAnalyzer* _tmp489_;
			ValaDataType* _tmp490_;
			_postcondition_index = _postcondition_index + 1;
			_tmp477_ = _postcondition_index;
			_tmp478_ = _postcondition_size;
			if (!(_tmp477_ < _tmp478_)) {
				break;
			}
			_tmp479_ = _postcondition_list;
			_tmp480_ = _postcondition_index;
			_tmp481_ = vala_list_get (_tmp479_, _tmp480_);
			postcondition = (ValaExpression*) _tmp481_;
			_tmp482_ = postcondition;
			_tmp483_ = vala_code_node_get_error ((ValaCodeNode*) _tmp482_);
			_tmp484_ = _tmp483_;
			if (_tmp484_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp485_ = postcondition;
			_tmp486_ = vala_expression_get_value_type (_tmp485_);
			_tmp487_ = _tmp486_;
			_tmp488_ = vala_code_context_get_analyzer (context);
			_tmp489_ = _tmp488_;
			_tmp490_ = _tmp489_->bool_type;
			if (!vala_data_type_compatible (_tmp487_, _tmp490_)) {
				ValaExpression* _tmp491_;
				ValaSourceReference* _tmp492_;
				ValaSourceReference* _tmp493_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp491_ = postcondition;
				_tmp492_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp491_);
				_tmp493_ = _tmp492_;
				vala_report_error (_tmp493_, "Postcondition must be boolean");
				result = FALSE;
				_vala_code_node_unref0 (postcondition);
				_vala_iterable_unref0 (_postcondition_list);
				_vala_code_node_unref0 (init_attr);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp495_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp496_ = _tmp495_;
	if (_tmp496_ != NULL) {
		ValaBlock* _tmp497_;
		ValaBlock* _tmp498_;
		gboolean _tmp499_;
		gboolean _tmp500_;
		_tmp497_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp498_ = _tmp497_;
		_tmp499_ = vala_code_node_get_error ((ValaCodeNode*) _tmp498_);
		_tmp500_ = _tmp499_;
		_tmp494_ = !_tmp500_;
	} else {
		_tmp494_ = FALSE;
	}
	if (_tmp494_) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp501_;
			ValaBlock* _tmp502_;
			ValaList* _tmp503_;
			gint _body_error_type_size = 0;
			ValaList* _tmp504_;
			gint _tmp505_;
			gint _tmp506_;
			gint _body_error_type_index = 0;
			_tmp501_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp502_ = _tmp501_;
			_tmp503_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp502_);
			_body_error_type_list = _tmp503_;
			_tmp504_ = _body_error_type_list;
			_tmp505_ = vala_collection_get_size ((ValaCollection*) _tmp504_);
			_tmp506_ = _tmp505_;
			_body_error_type_size = _tmp506_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp507_;
				gint _tmp508_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp509_;
				gint _tmp510_;
				gpointer _tmp511_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp523_ = FALSE;
				ValaDataType* _tmp524_;
				gboolean is_dynamic_error = FALSE;
				gboolean _tmp528_ = FALSE;
				gboolean _tmp529_;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp507_ = _body_error_type_index;
				_tmp508_ = _body_error_type_size;
				if (!(_tmp507_ < _tmp508_)) {
					break;
				}
				_tmp509_ = _body_error_type_list;
				_tmp510_ = _body_error_type_index;
				_tmp511_ = vala_list_get (_tmp509_, _tmp510_);
				body_error_type = (ValaDataType*) _tmp511_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp512_;
					gint _method_error_type_size = 0;
					ValaList* _tmp513_;
					gint _tmp514_;
					gint _tmp515_;
					gint _method_error_type_index = 0;
					_tmp512_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp512_;
					_tmp513_ = _method_error_type_list;
					_tmp514_ = vala_collection_get_size ((ValaCollection*) _tmp513_);
					_tmp515_ = _tmp514_;
					_method_error_type_size = _tmp515_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp516_;
						gint _tmp517_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp518_;
						gint _tmp519_;
						gpointer _tmp520_;
						ValaDataType* _tmp521_;
						ValaDataType* _tmp522_;
						_method_error_type_index = _method_error_type_index + 1;
						_tmp516_ = _method_error_type_index;
						_tmp517_ = _method_error_type_size;
						if (!(_tmp516_ < _tmp517_)) {
							break;
						}
						_tmp518_ = _method_error_type_list;
						_tmp519_ = _method_error_type_index;
						_tmp520_ = vala_list_get (_tmp518_, _tmp519_);
						method_error_type = (ValaDataType*) _tmp520_;
						_tmp521_ = body_error_type;
						_tmp522_ = method_error_type;
						if (vala_data_type_compatible (_tmp521_, _tmp522_)) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp524_ = body_error_type;
				if (VALA_IS_ERROR_TYPE (_tmp524_)) {
					ValaDataType* _tmp525_;
					gboolean _tmp526_;
					gboolean _tmp527_;
					_tmp525_ = body_error_type;
					_tmp526_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp525_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp527_ = _tmp526_;
					_tmp523_ = _tmp527_;
				} else {
					_tmp523_ = FALSE;
				}
				is_dynamic_error = _tmp523_;
				_tmp529_ = can_propagate_error;
				if (!_tmp529_) {
					gboolean _tmp530_;
					_tmp530_ = is_dynamic_error;
					_tmp528_ = !_tmp530_;
				} else {
					_tmp528_ = FALSE;
				}
				if (_tmp528_) {
					ValaDataType* _tmp531_;
					ValaSourceReference* _tmp532_;
					ValaSourceReference* _tmp533_;
					ValaDataType* _tmp534_;
					gchar* _tmp535_;
					gchar* _tmp536_;
					gchar* _tmp537_;
					gchar* _tmp538_;
					_tmp531_ = body_error_type;
					_tmp532_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp531_);
					_tmp533_ = _tmp532_;
					_tmp534_ = body_error_type;
					_tmp535_ = vala_code_node_to_string ((ValaCodeNode*) _tmp534_);
					_tmp536_ = _tmp535_;
					_tmp537_ = g_strdup_printf ("unhandled error `%s'", _tmp536_);
					_tmp538_ = _tmp537_;
					vala_report_warning (_tmp533_, _tmp538_);
					_g_free0 (_tmp538_);
					_g_free0 (_tmp536_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	if (!VALA_IS_CREATION_METHOD (self)) {
		ValaMemberBinding _tmp544_;
		_tmp544_ = self->priv->_binding;
		_tmp543_ = _tmp544_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp543_ = FALSE;
	}
	if (_tmp543_) {
		gboolean _tmp545_;
		_tmp545_ = self->priv->_overrides;
		_tmp542_ = !_tmp545_;
	} else {
		_tmp542_ = FALSE;
	}
	if (_tmp542_) {
		ValaSymbolAccessibility _tmp546_;
		ValaSymbolAccessibility _tmp547_;
		_tmp546_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp547_ = _tmp546_;
		_tmp541_ = _tmp547_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	} else {
		_tmp541_ = FALSE;
	}
	if (_tmp541_) {
		ValaSymbol* _tmp548_;
		ValaSymbol* _tmp549_;
		_tmp548_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp549_ = _tmp548_;
		_tmp540_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp549_);
	} else {
		_tmp540_ = FALSE;
	}
	if (_tmp540_) {
		ValaSymbol* _tmp550_;
		ValaSymbol* _tmp551_;
		ValaAttribute* _tmp552_;
		ValaAttribute* _tmp553_;
		_tmp550_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp551_ = _tmp550_;
		_tmp552_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp551_, "DBus");
		_tmp553_ = _tmp552_;
		_tmp539_ = _tmp553_ != NULL;
		_vala_code_node_unref0 (_tmp553_);
	} else {
		_tmp539_ = FALSE;
	}
	if (_tmp539_) {
		ValaAttribute* dbus_attr = NULL;
		ValaAttribute* _tmp554_;
		gboolean _tmp555_ = FALSE;
		ValaAttribute* _tmp556_;
		_tmp554_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "DBus");
		dbus_attr = _tmp554_;
		_tmp556_ = dbus_attr;
		if (_tmp556_ == NULL) {
			_tmp555_ = TRUE;
		} else {
			ValaAttribute* _tmp557_;
			_tmp557_ = dbus_attr;
			_tmp555_ = vala_attribute_get_bool (_tmp557_, "visible", TRUE);
		}
		if (_tmp555_) {
			gboolean throws_gerror = FALSE;
			gboolean throws_gioerror = FALSE;
			gboolean throws_gdbuserror = FALSE;
			gboolean _tmp576_ = FALSE;
			gboolean _tmp577_;
			throws_gerror = FALSE;
			throws_gioerror = FALSE;
			throws_gdbuserror = FALSE;
			{
				ValaList* _error_type_list = NULL;
				ValaList* _tmp558_;
				gint _error_type_size = 0;
				ValaList* _tmp559_;
				gint _tmp560_;
				gint _tmp561_;
				gint _error_type_index = 0;
				_tmp558_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
				_error_type_list = _tmp558_;
				_tmp559_ = _error_type_list;
				_tmp560_ = vala_collection_get_size ((ValaCollection*) _tmp559_);
				_tmp561_ = _tmp560_;
				_error_type_size = _tmp561_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp562_;
					gint _tmp563_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp564_;
					gint _tmp565_;
					gpointer _tmp566_;
					ValaDataType* _tmp567_;
					ValaErrorDomain* error_domain = NULL;
					ValaDataType* _tmp568_;
					ValaErrorDomain* _tmp569_;
					ValaErrorDomain* _tmp570_;
					ValaErrorDomain* _tmp571_;
					gchar* full_error_domain = NULL;
					ValaErrorDomain* _tmp572_;
					gchar* _tmp573_;
					const gchar* _tmp574_;
					_error_type_index = _error_type_index + 1;
					_tmp562_ = _error_type_index;
					_tmp563_ = _error_type_size;
					if (!(_tmp562_ < _tmp563_)) {
						break;
					}
					_tmp564_ = _error_type_list;
					_tmp565_ = _error_type_index;
					_tmp566_ = vala_list_get (_tmp564_, _tmp565_);
					error_type = (ValaDataType*) _tmp566_;
					_tmp567_ = error_type;
					if (!VALA_IS_ERROR_TYPE (_tmp567_)) {
						_vala_code_node_unref0 (error_type);
						continue;
					}
					_tmp568_ = error_type;
					_tmp569_ = vala_error_type_get_error_domain (G_TYPE_CHECK_INSTANCE_CAST (_tmp568_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp570_ = _tmp569_;
					error_domain = _tmp570_;
					_tmp571_ = error_domain;
					if (_tmp571_ == NULL) {
						throws_gerror = TRUE;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp572_ = error_domain;
					_tmp573_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp572_);
					full_error_domain = _tmp573_;
					_tmp574_ = full_error_domain;
					if (g_strcmp0 (_tmp574_, "GLib.IOError") == 0) {
						throws_gioerror = TRUE;
					} else {
						const gchar* _tmp575_;
						_tmp575_ = full_error_domain;
						if (g_strcmp0 (_tmp575_, "GLib.DBusError") == 0) {
							throws_gdbuserror = TRUE;
						}
					}
					_g_free0 (full_error_domain);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_tmp577_ = throws_gerror;
			if (!_tmp577_) {
				gboolean _tmp578_ = FALSE;
				gboolean _tmp579_;
				_tmp579_ = throws_gioerror;
				if (_tmp579_) {
					gboolean _tmp580_;
					_tmp580_ = throws_gdbuserror;
					_tmp578_ = _tmp580_;
				} else {
					_tmp578_ = FALSE;
				}
				_tmp576_ = !_tmp578_;
			} else {
				_tmp576_ = FALSE;
			}
			if (_tmp576_) {
				ValaSourceReference* _tmp581_;
				ValaSourceReference* _tmp582_;
				_tmp581_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp582_ = _tmp581_;
				vala_report_warning (_tmp582_, "DBus methods are recommended to throw at least `GLib.Error' or `GLib.D" \
"BusError, GLib.IOError'");
			}
		}
		_vala_code_node_unref0 (dbus_attr);
	}
	if (vala_method_is_possible_entry_point (self, context)) {
		ValaMethod* _tmp583_;
		ValaMethod* _tmp584_;
		gboolean _tmp593_;
		gboolean _tmp594_;
		gboolean _tmp597_;
		gboolean _tmp600_;
		_tmp583_ = vala_code_context_get_entry_point (context);
		_tmp584_ = _tmp583_;
		if (_tmp584_ != NULL) {
			ValaSourceReference* _tmp585_;
			ValaSourceReference* _tmp586_;
			ValaMethod* _tmp587_;
			ValaMethod* _tmp588_;
			gchar* _tmp589_;
			gchar* _tmp590_;
			gchar* _tmp591_;
			gchar* _tmp592_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp585_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp586_ = _tmp585_;
			_tmp587_ = vala_code_context_get_entry_point (context);
			_tmp588_ = _tmp587_;
			_tmp589_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp588_);
			_tmp590_ = _tmp589_;
			_tmp591_ = g_strdup_printf ("program already has an entry point `%s'", _tmp590_);
			_tmp592_ = _tmp591_;
			vala_report_error (_tmp586_, _tmp592_);
			_g_free0 (_tmp592_);
			_g_free0 (_tmp590_);
			result = FALSE;
			_vala_code_node_unref0 (init_attr);
			_vala_code_node_unref0 (old_symbol);
			_vala_source_file_unref0 (old_source_file);
			return result;
		}
		vala_method_set_entry_point (self, TRUE);
		vala_code_context_set_entry_point (context, self);
		_tmp593_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) self);
		_tmp594_ = _tmp593_;
		if (_tmp594_) {
			ValaSourceReference* _tmp595_;
			ValaSourceReference* _tmp596_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp595_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp596_ = _tmp595_;
			vala_report_error (_tmp596_, "\"main\" method cannot throw errors");
		}
		_tmp597_ = self->priv->_is_inline;
		if (_tmp597_) {
			ValaSourceReference* _tmp598_;
			ValaSourceReference* _tmp599_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp598_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp599_ = _tmp598_;
			vala_report_error (_tmp599_, "\"main\" method cannot be inline");
		}
		_tmp600_ = self->priv->_coroutine;
		if (_tmp600_) {
			ValaSourceReference* _tmp601_;
			ValaSourceReference* _tmp602_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp601_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp602_ = _tmp601_;
			vala_report_error (_tmp602_, "\"main\" method cannot be async");
		}
	}
	_tmp603_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "GtkCallback");
	_tmp604_ = _tmp603_;
	_tmp605_ = _tmp604_ != NULL;
	_vala_code_node_unref0 (_tmp604_);
	if (_tmp605_) {
		vala_symbol_set_used ((ValaSymbol*) self, TRUE);
	}
	_tmp606_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp607_ = _tmp606_;
	result = !_tmp607_;
	_vala_code_node_unref0 (init_attr);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static gboolean
vala_method_is_possible_entry_point (ValaMethod* self,
                                     ValaCodeContext* context)
{
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaMemberBinding _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaList* params = NULL;
	ValaList* _tmp26_;
	ValaList* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	ValaIterator* params_it = NULL;
	ValaList* _tmp33_;
	ValaIterator* _tmp34_;
	ValaIterator* _tmp35_;
	ValaParameter* param = NULL;
	ValaIterator* _tmp36_;
	gpointer _tmp37_;
	ValaParameter* _tmp38_;
	ValaParameterDirection _tmp39_;
	ValaParameterDirection _tmp40_;
	ValaParameter* _tmp41_;
	ValaDataType* _tmp42_;
	ValaDataType* _tmp43_;
	ValaArrayType* array_type = NULL;
	ValaParameter* _tmp44_;
	ValaDataType* _tmp45_;
	ValaDataType* _tmp46_;
	ValaArrayType* _tmp47_;
	ValaArrayType* _tmp48_;
	ValaDataType* _tmp49_;
	ValaDataType* _tmp50_;
	ValaTypeSymbol* _tmp51_;
	ValaTypeSymbol* _tmp52_;
	ValaSemanticAnalyzer* _tmp53_;
	ValaSemanticAnalyzer* _tmp54_;
	ValaDataType* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	ValaTypeSymbol* _tmp57_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_code_context_get_entry_point_name (context);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = vala_symbol_get_name ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			_tmp4_ = TRUE;
		} else {
			const gchar* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp4_ = g_strcmp0 (_tmp8_, "main") != 0;
		}
		if (_tmp4_) {
			result = FALSE;
			return result;
		}
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean _tmp13_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_context_get_entry_point_name (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strcmp0 (_tmp10_, _tmp12_) != 0;
		_g_free0 (_tmp10_);
		if (_tmp13_) {
			result = FALSE;
			return result;
		}
	}
	_tmp14_ = self->priv->_binding;
	if (_tmp14_ == VALA_MEMBER_BINDING_INSTANCE) {
		result = FALSE;
		return result;
	}
	_tmp15_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp16_ = _tmp15_;
	if (VALA_IS_VOID_TYPE (_tmp16_)) {
	} else {
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaTypeSymbol* _tmp19_;
		ValaTypeSymbol* _tmp20_;
		ValaSemanticAnalyzer* _tmp21_;
		ValaSemanticAnalyzer* _tmp22_;
		ValaDataType* _tmp23_;
		ValaTypeSymbol* _tmp24_;
		ValaTypeSymbol* _tmp25_;
		_tmp17_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_data_type_get_data_type (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_code_context_get_analyzer (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _tmp22_->int_type;
		_tmp24_ = vala_data_type_get_data_type (_tmp23_);
		_tmp25_ = _tmp24_;
		if (_tmp20_ == _tmp25_) {
		} else {
			result = FALSE;
			return result;
		}
	}
	_tmp26_ = vala_callable_get_parameters ((ValaCallable*) self);
	params = _tmp26_;
	_tmp27_ = params;
	_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == 0) {
		result = TRUE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp30_ = params;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ > 1) {
		result = FALSE;
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp33_ = params;
	_tmp34_ = vala_iterable_iterator ((ValaIterable*) _tmp33_);
	params_it = _tmp34_;
	_tmp35_ = params_it;
	vala_iterator_next (_tmp35_);
	_tmp36_ = params_it;
	_tmp37_ = vala_iterator_get (_tmp36_);
	param = (ValaParameter*) _tmp37_;
	_tmp38_ = param;
	_tmp39_ = vala_parameter_get_direction (_tmp38_);
	_tmp40_ = _tmp39_;
	if (_tmp40_ == VALA_PARAMETER_DIRECTION_OUT) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp41_ = param;
	_tmp42_ = vala_variable_get_variable_type ((ValaVariable*) _tmp41_);
	_tmp43_ = _tmp42_;
	if (!VALA_IS_ARRAY_TYPE (_tmp43_)) {
		result = FALSE;
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	_tmp44_ = param;
	_tmp45_ = vala_variable_get_variable_type ((ValaVariable*) _tmp44_);
	_tmp46_ = _tmp45_;
	_tmp47_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp46_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
	array_type = _tmp47_;
	_tmp48_ = array_type;
	_tmp49_ = vala_array_type_get_element_type (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_data_type_get_data_type (_tmp50_);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_context_get_analyzer (context);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->string_type;
	_tmp56_ = vala_data_type_get_data_type (_tmp55_);
	_tmp57_ = _tmp56_;
	if (_tmp52_ != _tmp57_) {
		result = FALSE;
		_vala_code_node_unref0 (array_type);
		_vala_code_node_unref0 (param);
		_vala_iterator_unref0 (params_it);
		_vala_iterable_unref0 (params);
		return result;
	}
	result = TRUE;
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (param);
	_vala_iterator_unref0 (params_it);
	_vala_iterable_unref0 (params);
	return result;
}


gint
vala_method_get_required_arguments (ValaMethod* self)
{
	gint result = 0;
	gint n = 0;
	g_return_val_if_fail (self != NULL, 0);
	n = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _param_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _param_index = 0;
		_tmp0_ = self->priv->parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_param_list = _tmp1_;
		_tmp2_ = _param_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_param_size = _tmp4_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			ValaParameter* _tmp11_;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			gint _tmp17_;
			_param_index = _param_index + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp11_ = param;
			_tmp12_ = vala_variable_get_initializer ((ValaVariable*) _tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				_tmp10_ = TRUE;
			} else {
				ValaParameter* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				_tmp14_ = param;
				_tmp15_ = vala_parameter_get_ellipsis (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp10_ = _tmp16_;
			}
			if (_tmp10_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp17_ = n;
			n = _tmp17_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = n;
	return result;
}


ValaMethod*
vala_method_get_end_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp37_;
	ValaMethod* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->end_method;
	if (_tmp1_ == NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMethod* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaScope* _tmp10_;
		ValaScope* _tmp11_;
		ValaMethod* _tmp36_;
		_tmp2_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_method_new ("end", _tmp3_, _tmp5_, NULL);
		_vala_code_node_unref0 (self->priv->end_method);
		self->priv->end_method = _tmp6_;
		_tmp7_ = self->priv->end_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp7_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp8_ = self->priv->end_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp8_, TRUE);
		_tmp9_ = self->priv->end_method;
		_tmp10_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp9_, _tmp11_);
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_method_get_async_end_parameters (self);
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* param = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValaMethod* _tmp21_;
				ValaParameter* _tmp22_;
				ValaParameter* _tmp23_;
				ValaParameter* _tmp24_;
				_param_index = _param_index + 1;
				_tmp16_ = _param_index;
				_tmp17_ = _param_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _param_list;
				_tmp19_ = _param_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				param = (ValaParameter*) _tmp20_;
				_tmp21_ = self->priv->end_method;
				_tmp22_ = param;
				_tmp23_ = vala_parameter_copy (_tmp22_);
				_tmp24_ = _tmp23_;
				vala_callable_add_parameter ((ValaCallable*) _tmp21_, _tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp25_;
			gint _param_size = 0;
			ValaList* _tmp26_;
			gint _tmp27_;
			gint _tmp28_;
			gint _param_index = 0;
			_tmp25_ = vala_method_get_type_parameters (self);
			_param_list = _tmp25_;
			_tmp26_ = _param_list;
			_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
			_tmp28_ = _tmp27_;
			_param_size = _tmp28_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp29_;
				gint _tmp30_;
				ValaTypeParameter* param = NULL;
				ValaList* _tmp31_;
				gint _tmp32_;
				gpointer _tmp33_;
				ValaMethod* _tmp34_;
				ValaTypeParameter* _tmp35_;
				_param_index = _param_index + 1;
				_tmp29_ = _param_index;
				_tmp30_ = _param_size;
				if (!(_tmp29_ < _tmp30_)) {
					break;
				}
				_tmp31_ = _param_list;
				_tmp32_ = _param_index;
				_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
				param = (ValaTypeParameter*) _tmp33_;
				_tmp34_ = self->priv->end_method;
				_tmp35_ = param;
				vala_method_add_type_parameter (_tmp34_, _tmp35_);
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp36_ = self->priv->end_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp36_, (ValaCodeNode*) self, "CCode", "async_result_pos");
	}
	_tmp37_ = self->priv->end_method;
	_tmp38_ = _vala_code_node_ref0 (_tmp37_);
	result = _tmp38_;
	return result;
}


ValaMethod*
vala_method_get_callback_method (ValaMethod* self)
{
	ValaMethod* result = NULL;
	gboolean _tmp0_;
	ValaMethod* _tmp1_;
	ValaMethod* _tmp24_;
	ValaMethod* _tmp25_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = self->priv->callback_method;
	if (_tmp1_ == NULL) {
		ValaBooleanType* bool_type = NULL;
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaNamespace* _tmp4_;
		ValaNamespace* _tmp5_;
		ValaScope* _tmp6_;
		ValaScope* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaStruct* _tmp9_;
		ValaBooleanType* _tmp10_;
		ValaBooleanType* _tmp11_;
		ValaBooleanType* _tmp12_;
		ValaBooleanType* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceReference* _tmp15_;
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaScope* _tmp21_;
		ValaScope* _tmp22_;
		ValaMethod* _tmp23_;
		_tmp2_ = vala_code_context_get ();
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_code_context_get_root (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_scope_lookup (_tmp7_, "bool");
		_tmp9_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_STRUCT, ValaStruct);
		_tmp10_ = vala_boolean_type_new (_tmp9_);
		_tmp11_ = _tmp10_;
		_vala_code_node_unref0 (_tmp9_);
		_vala_code_context_unref0 (_tmp3_);
		bool_type = _tmp11_;
		_tmp12_ = bool_type;
		vala_data_type_set_value_owned ((ValaDataType*) _tmp12_, TRUE);
		_tmp13_ = bool_type;
		_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_method_new ("callback", (ValaDataType*) _tmp13_, _tmp15_, NULL);
		_vala_code_node_unref0 (self->priv->callback_method);
		self->priv->callback_method = _tmp16_;
		_tmp17_ = self->priv->callback_method;
		vala_symbol_set_access ((ValaSymbol*) _tmp17_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp18_ = self->priv->callback_method;
		vala_symbol_set_external ((ValaSymbol*) _tmp18_, TRUE);
		_tmp19_ = self->priv->callback_method;
		vala_method_set_binding (_tmp19_, VALA_MEMBER_BINDING_INSTANCE);
		_tmp20_ = self->priv->callback_method;
		_tmp21_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp22_ = _tmp21_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp20_, _tmp22_);
		_tmp23_ = self->priv->callback_method;
		vala_method_set_is_async_callback (_tmp23_, TRUE);
		_vala_code_node_unref0 (bool_type);
	}
	_tmp24_ = self->priv->callback_method;
	_tmp25_ = _vala_code_node_ref0 (_tmp24_);
	result = _tmp25_;
	return result;
}


ValaList*
vala_method_get_async_begin_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp1_;
	ValaCodeContext* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaScope* _tmp5_;
	ValaScope* _tmp6_;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp9_;
	ValaArrayList* _tmp10_;
	ValaParameter* ellipsis = NULL;
	ValaDelegateType* callback_type = NULL;
	ValaSymbol* _tmp31_;
	ValaScope* _tmp32_;
	ValaScope* _tmp33_;
	ValaSymbol* _tmp34_;
	ValaDelegate* _tmp35_;
	ValaDelegateType* _tmp36_;
	ValaDelegateType* _tmp37_;
	ValaDelegateType* _tmp38_;
	ValaDelegateType* _tmp39_;
	ValaDelegateType* _tmp40_;
	ValaParameter* callback_param = NULL;
	ValaDelegateType* _tmp41_;
	ValaParameter* _tmp42_;
	ValaParameter* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaSourceReference* _tmp45_;
	ValaNullLiteral* _tmp46_;
	ValaNullLiteral* _tmp47_;
	ValaParameter* _tmp48_;
	ValaExpression* _tmp49_;
	ValaExpression* _tmp50_;
	ValaDelegateType* _tmp51_;
	ValaDataType* _tmp52_;
	ValaDataType* _tmp53_;
	ValaParameter* _tmp54_;
	ValaParameter* _tmp55_;
	ValaArrayList* _tmp56_;
	ValaParameter* _tmp57_;
	ValaParameter* _tmp58_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = vala_code_context_get ();
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_code_context_get_root (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_scope_lookup (_tmp6_, "GLib");
	_tmp8_ = _tmp7_;
	_vala_code_context_unref0 (_tmp2_);
	glib_ns = _tmp8_;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp9_);
	params = _tmp10_;
	ellipsis = NULL;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp11_;
		ValaList* _tmp12_;
		gint _param_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _param_index = 0;
		_tmp11_ = self->priv->parameters;
		_tmp12_ = _vala_iterable_ref0 (_tmp11_);
		_param_list = _tmp12_;
		_tmp13_ = _param_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_param_size = _tmp15_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaParameter* param = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaParameter* _tmp21_;
			gboolean _tmp22_;
			gboolean _tmp23_;
			_param_index = _param_index + 1;
			_tmp16_ = _param_index;
			_tmp17_ = _param_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _param_list;
			_tmp19_ = _param_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			param = (ValaParameter*) _tmp20_;
			_tmp21_ = param;
			_tmp22_ = vala_parameter_get_ellipsis (_tmp21_);
			_tmp23_ = _tmp22_;
			if (_tmp23_) {
				ValaParameter* _tmp24_;
				ValaParameter* _tmp25_;
				_tmp24_ = param;
				_tmp25_ = _vala_code_node_ref0 (_tmp24_);
				_vala_code_node_unref0 (ellipsis);
				ellipsis = _tmp25_;
			} else {
				ValaParameter* _tmp26_;
				ValaParameterDirection _tmp27_;
				ValaParameterDirection _tmp28_;
				_tmp26_ = param;
				_tmp27_ = vala_parameter_get_direction (_tmp26_);
				_tmp28_ = _tmp27_;
				if (_tmp28_ == VALA_PARAMETER_DIRECTION_IN) {
					ValaArrayList* _tmp29_;
					ValaParameter* _tmp30_;
					_tmp29_ = params;
					_tmp30_ = param;
					vala_collection_add ((ValaCollection*) _tmp29_, _tmp30_);
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp31_ = glib_ns;
	_tmp32_ = vala_symbol_get_scope (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_scope_lookup (_tmp33_, "AsyncReadyCallback");
	_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_DELEGATE, ValaDelegate);
	_tmp36_ = vala_delegate_type_new (_tmp35_);
	_tmp37_ = _tmp36_;
	_vala_code_node_unref0 (_tmp35_);
	callback_type = _tmp37_;
	_tmp38_ = callback_type;
	vala_data_type_set_nullable ((ValaDataType*) _tmp38_, TRUE);
	_tmp39_ = callback_type;
	vala_data_type_set_value_owned ((ValaDataType*) _tmp39_, TRUE);
	_tmp40_ = callback_type;
	vala_delegate_type_set_is_called_once (_tmp40_, TRUE);
	_tmp41_ = callback_type;
	_tmp42_ = vala_parameter_new ("_callback_", (ValaDataType*) _tmp41_, NULL);
	callback_param = _tmp42_;
	_tmp43_ = callback_param;
	_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_null_literal_new (_tmp45_);
	_tmp47_ = _tmp46_;
	vala_variable_set_initializer ((ValaVariable*) _tmp43_, (ValaExpression*) _tmp47_);
	_vala_code_node_unref0 (_tmp47_);
	_tmp48_ = callback_param;
	_tmp49_ = vala_variable_get_initializer ((ValaVariable*) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = callback_type;
	_tmp52_ = vala_data_type_copy ((ValaDataType*) _tmp51_);
	_tmp53_ = _tmp52_;
	vala_expression_set_target_type (_tmp50_, _tmp53_);
	_vala_code_node_unref0 (_tmp53_);
	_tmp54_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp54_, "CCode", "pos", (gdouble) -1, NULL);
	_tmp55_ = callback_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp55_, "CCode", "delegate_target_pos", -0.9, NULL);
	_tmp56_ = params;
	_tmp57_ = callback_param;
	vala_collection_add ((ValaCollection*) _tmp56_, _tmp57_);
	_tmp58_ = ellipsis;
	if (_tmp58_ != NULL) {
		ValaArrayList* _tmp59_;
		ValaParameter* _tmp60_;
		_tmp59_ = params;
		_tmp60_ = ellipsis;
		vala_collection_add ((ValaCollection*) _tmp59_, _tmp60_);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (callback_param);
	_vala_code_node_unref0 (callback_type);
	_vala_code_node_unref0 (ellipsis);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


ValaList*
vala_method_get_async_end_parameters (ValaMethod* self)
{
	ValaList* result = NULL;
	gboolean _tmp0_;
	ValaArrayList* params = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaSymbol* glib_ns = NULL;
	ValaCodeContext* _tmp3_;
	ValaCodeContext* _tmp4_;
	ValaNamespace* _tmp5_;
	ValaNamespace* _tmp6_;
	ValaScope* _tmp7_;
	ValaScope* _tmp8_;
	ValaSymbol* _tmp9_;
	ValaSymbol* _tmp10_;
	ValaObjectType* result_type = NULL;
	ValaSymbol* _tmp11_;
	ValaScope* _tmp12_;
	ValaScope* _tmp13_;
	ValaSymbol* _tmp14_;
	ValaObjectTypeSymbol* _tmp15_;
	ValaObjectType* _tmp16_;
	ValaObjectType* _tmp17_;
	ValaParameter* result_param = NULL;
	ValaObjectType* _tmp18_;
	ValaParameter* _tmp19_;
	ValaParameter* _tmp20_;
	ValaArrayList* _tmp21_;
	ValaParameter* _tmp22_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_coroutine;
	_vala_assert (_tmp0_, "this.coroutine");
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp1_);
	params = _tmp2_;
	_tmp3_ = vala_code_context_get ();
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_code_context_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_symbol_get_scope ((ValaSymbol*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_scope_lookup (_tmp8_, "GLib");
	_tmp10_ = _tmp9_;
	_vala_code_context_unref0 (_tmp4_);
	glib_ns = _tmp10_;
	_tmp11_ = glib_ns;
	_tmp12_ = vala_symbol_get_scope (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_scope_lookup (_tmp13_, "AsyncResult");
	_tmp15_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol);
	_tmp16_ = vala_object_type_new (_tmp15_);
	_tmp17_ = _tmp16_;
	_vala_code_node_unref0 (_tmp15_);
	result_type = _tmp17_;
	_tmp18_ = result_type;
	_tmp19_ = vala_parameter_new ("_res_", (ValaDataType*) _tmp18_, NULL);
	result_param = _tmp19_;
	_tmp20_ = result_param;
	vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp20_, "CCode", "pos", vala_code_node_get_attribute_double ((ValaCodeNode*) self, "CCode", "async_result_pos", 0.1), NULL);
	_tmp21_ = params;
	_tmp22_ = result_param;
	vala_collection_add ((ValaCollection*) _tmp21_, _tmp22_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _param_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _param_index = 0;
		_tmp23_ = self->priv->parameters;
		_tmp24_ = _vala_iterable_ref0 (_tmp23_);
		_param_list = _tmp24_;
		_tmp25_ = _param_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_param_size = _tmp27_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaParameter* param = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaParameter* _tmp33_;
			ValaParameterDirection _tmp34_;
			ValaParameterDirection _tmp35_;
			_param_index = _param_index + 1;
			_tmp28_ = _param_index;
			_tmp29_ = _param_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _param_list;
			_tmp31_ = _param_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			param = (ValaParameter*) _tmp32_;
			_tmp33_ = param;
			_tmp34_ = vala_parameter_get_direction (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaArrayList* _tmp36_;
				ValaParameter* _tmp37_;
				_tmp36_ = params;
				_tmp37_ = param;
				vala_collection_add ((ValaCollection*) _tmp36_, _tmp37_);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = (ValaList*) params;
	_vala_code_node_unref0 (result_param);
	_vala_code_node_unref0 (result_type);
	_vala_code_node_unref0 (glib_ns);
	return result;
}


void
vala_method_add_captured_variable (ValaMethod* self,
                                   ValaLocalVariable* local)
{
	gboolean _tmp0_;
	ValaList* _tmp1_;
	ValaList* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (local != NULL);
	_tmp0_ = self->priv->_closure;
	_vala_assert (_tmp0_, "this.closure");
	_tmp1_ = self->priv->captured_variables;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_LOCAL_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (self->priv->captured_variables);
		self->priv->captured_variables = (ValaList*) _tmp3_;
	}
	_tmp4_ = self->priv->captured_variables;
	vala_collection_add ((ValaCollection*) _tmp4_, local);
}


void
vala_method_get_captured_variables (ValaMethod* self,
                                    ValaCollection* variables)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (variables != NULL);
	_tmp0_ = self->priv->captured_variables;
	if (_tmp0_ != NULL) {
		{
			ValaList* _local_list = NULL;
			ValaList* _tmp1_;
			ValaList* _tmp2_;
			gint _local_size = 0;
			ValaList* _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gint _local_index = 0;
			_tmp1_ = self->priv->captured_variables;
			_tmp2_ = _vala_iterable_ref0 (_tmp1_);
			_local_list = _tmp2_;
			_tmp3_ = _local_list;
			_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
			_tmp5_ = _tmp4_;
			_local_size = _tmp5_;
			_local_index = -1;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				ValaLocalVariable* local = NULL;
				ValaList* _tmp8_;
				gint _tmp9_;
				gpointer _tmp10_;
				ValaLocalVariable* _tmp11_;
				_local_index = _local_index + 1;
				_tmp6_ = _local_index;
				_tmp7_ = _local_size;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp8_ = _local_list;
				_tmp9_ = _local_index;
				_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
				local = (ValaLocalVariable*) _tmp10_;
				_tmp11_ = local;
				vala_collection_add (variables, _tmp11_);
				_vala_code_node_unref0 (local);
			}
			_vala_iterable_unref0 (_local_list);
		}
	}
}


static void
vala_method_real_get_defined_variables (ValaCodeNode* base,
                                        ValaCollection* collection)
{
	ValaMethod * self;
	gboolean _tmp0_;
	self = (ValaMethod*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_closure;
	if (_tmp0_) {
		vala_method_get_captured_variables (self, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


gint
vala_method_get_format_arg_index (ValaMethod* self)
{
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaParameter* _tmp9_;
				gboolean _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->parameters;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->parameters;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaParameter*) _tmp8_;
				_tmp10_ = vala_parameter_get_format_arg (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp12_) {
					result = i;
					return result;
				}
			}
		}
	}
	result = -1;
	return result;
}


gboolean
vala_method_has_error_type_parameter (ValaMethod* self)
{
	gboolean result = FALSE;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ValaMethod* _tmp7_;
	ValaMethod* _tmp8_;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ValaMethod* _tmp15_;
	ValaMethod* _tmp16_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_ > 0;
	_vala_iterable_unref0 (_tmp1_);
	if (_tmp4_) {
		result = TRUE;
		return result;
	}
	_tmp7_ = vala_method_get_base_method (self);
	_tmp8_ = _tmp7_;
	if (_tmp8_ != NULL) {
		ValaMethod* _tmp9_;
		ValaMethod* _tmp10_;
		_tmp9_ = vala_method_get_base_method (self);
		_tmp10_ = _tmp9_;
		_tmp6_ = _tmp10_ != self;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaMethod* _tmp11_;
		ValaMethod* _tmp12_;
		_tmp11_ = vala_method_get_base_method (self);
		_tmp12_ = _tmp11_;
		_tmp5_ = vala_method_has_error_type_parameter (_tmp12_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		result = TRUE;
		return result;
	}
	_tmp15_ = vala_method_get_base_interface_method (self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		ValaMethod* _tmp17_;
		ValaMethod* _tmp18_;
		_tmp17_ = vala_method_get_base_interface_method (self);
		_tmp18_ = _tmp17_;
		_tmp14_ = _tmp18_ != self;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		_tmp19_ = vala_method_get_base_interface_method (self);
		_tmp20_ = _tmp19_;
		_tmp13_ = vala_method_has_error_type_parameter (_tmp20_);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static ValaDataType*
vala_method_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	self = (ValaMethod*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static void
vala_method_real_set_return_type (ValaCallable* base,
                                  ValaDataType* value)
{
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static gboolean
vala_method_real_get_has_result (ValaSubroutine* base)
{
	gboolean result;
	ValaMethod* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaMethod*) base;
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	result = !VALA_IS_VOID_TYPE (_tmp1_);
	return result;
}


ValaMemberBinding
vala_method_get_binding (ValaMethod* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_method_set_binding (ValaMethod* self,
                         ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


gboolean
vala_method_get_is_abstract (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_abstract (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean
vala_method_get_is_virtual (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_virtual (ValaMethod* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean
vala_method_get_overrides (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void
vala_method_set_overrides (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


gboolean
vala_method_get_is_inline (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_inline;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_inline (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_inline = value;
}


gboolean
vala_method_get_returns_floating_reference (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", FALSE);
	return result;
}


void
vala_method_set_returns_floating_reference (ValaMethod* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "returns_floating_reference", value, NULL);
}


gboolean
vala_method_get_returns_modified_pointer (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_returns_modified_pointer (ValaMethod* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ReturnsModifiedPointer", value, NULL);
}


ValaMethod*
vala_method_get_base_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_method;
	result = _tmp0_;
	return result;
}


ValaMethod*
vala_method_get_base_interface_method (ValaMethod* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_method_find_base_methods (self);
	_tmp0_ = self->priv->_base_interface_method;
	result = _tmp0_;
	return result;
}


ValaDataType*
vala_method_get_base_interface_type (ValaMethod* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_interface_type;
	result = _tmp0_;
	return result;
}


void
vala_method_set_base_interface_type (ValaMethod* self,
                                     ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	self->priv->_base_interface_type = _tmp0_;
	_tmp1_ = self->priv->_base_interface_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_get_entry_point (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_entry_point;
	result = _tmp0_;
	return result;
}


static void
vala_method_set_entry_point (ValaMethod* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_entry_point = value;
}


ValaParameter*
vala_method_get_this_parameter (ValaMethod* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void
vala_method_set_this_parameter (ValaMethod* self,
                                ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}


gboolean
vala_method_get_printf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "PrintfFormat");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_printf_format (ValaMethod* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "PrintfFormat", value, NULL);
}


gboolean
vala_method_get_scanf_format (ValaMethod* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ScanfFormat");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


void
vala_method_set_scanf_format (ValaMethod* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute ((ValaCodeNode*) self, "ScanfFormat", value, NULL);
}


gboolean
vala_method_get_has_construct_function (ValaMethod* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", TRUE);
	return result;
}


void
vala_method_set_has_construct_function (ValaMethod* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_construct_function", value, NULL);
}


ValaSignal*
vala_method_get_signal_reference (ValaMethod* self)
{
	ValaSignal* result;
	ValaSignal* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_signal_reference;
	result = _tmp0_;
	return result;
}


void
vala_method_set_signal_reference (ValaMethod* self,
                                  ValaSignal* value)
{
	g_return_if_fail (self != NULL);
	self->priv->_signal_reference = value;
}


gboolean
vala_method_get_closure (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_closure;
	result = _tmp0_;
	return result;
}


void
vala_method_set_closure (ValaMethod* self,
                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_closure = value;
}


gboolean
vala_method_get_coroutine (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_coroutine;
	result = _tmp0_;
	return result;
}


void
vala_method_set_coroutine (ValaMethod* self,
                           gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_coroutine = value;
}


gboolean
vala_method_get_is_async_callback (ValaMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_async_callback;
	result = _tmp0_;
	return result;
}


void
vala_method_set_is_async_callback (ValaMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_async_callback = value;
}


static void
vala_method_class_init (ValaMethodClass * klass)
{
	vala_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_method_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_real_check;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_real_get_defined_variables;
	VALA_SUBROUTINE_CLASS (klass)->get_has_result = vala_method_real_get_has_result;
}


static void
vala_method_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_method_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_method_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_method_real_get_parameters;
	iface->get_return_type = vala_method_real_get_return_type;
	iface->set_return_type = vala_method_real_set_return_type;
}


static void
vala_method_instance_init (ValaMethod * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void
vala_method_finalize (ValaCodeNode * obj)
{
	ValaMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD, ValaMethod);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_iterable_unref0 (self->priv->preconditions);
	_vala_iterable_unref0 (self->priv->postconditions);
	_vala_code_node_unref0 (self->priv->_return_type);
	_vala_code_node_unref0 (self->priv->_base_interface_type);
	_vala_code_node_unref0 (self->priv->callback_method);
	_vala_code_node_unref0 (self->priv->end_method);
	_vala_iterable_unref0 (self->priv->captured_variables);
	VALA_CODE_NODE_CLASS (vala_method_parent_class)->finalize (obj);
}


/**
 * Represents a type or namespace method.
 */
GType
vala_method_get_type (void)
{
	static volatile gsize vala_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethod), 0, (GInstanceInitFunc) vala_method_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_method_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_method_type_id;
		vala_method_type_id = g_type_register_static (VALA_TYPE_SUBROUTINE, "ValaMethod", &g_define_type_info, 0);
		g_type_add_interface_static (vala_method_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_method_type_id__volatile, vala_method_type_id);
	}
	return vala_method_type_id__volatile;
}



