/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _vala_code_visitor_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_visitor_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _tainted_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};

struct _Block1Data {
	int _ref_count_;
	ValaMemberAccess* self;
	gboolean found;
};


static gpointer vala_member_access_parent_class = NULL;

#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static gboolean vala_member_access_is_tainted (ValaMemberAccess* self);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static ValaTraverseStatus __lambda4_ (Block1Data* _data1_,
                               ValaCodeNode* n);
static ValaTraverseStatus ___lambda4__vala_traverse_func (ValaCodeNode* node,
                                                   gpointer self);
static void vala_member_access_finalize (ValaCodeNode * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaDataType* _tmp14_;
			_type_arg_index = _type_arg_index + 1;
			_tmp9_ = _type_arg_index;
			_tmp10_ = _type_arg_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_arg_list;
			_tmp12_ = _type_arg_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			type_arg = (ValaDataType*) _tmp13_;
			_tmp14_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp14_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}


static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->type_argument_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->type_argument_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->type_argument_list;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}


static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}


static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp19_;
	gboolean _tmp638_ = FALSE;
	gboolean _tmp639_ = FALSE;
	ValaSymbol* _tmp640_;
	ValaSymbol* _tmp641_;
	ValaSymbol* _tmp668_;
	ValaSymbol* _tmp669_;
	ValaSymbol* _tmp698_;
	ValaSymbol* _tmp699_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp740_;
	ValaSymbol* _tmp741_;
	ValaSymbol* _tmp742_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp743_;
	ValaSymbol* _tmp744_;
	ValaSymbol* _tmp1170_;
	ValaSymbol* _tmp1171_;
	ValaVersionAttribute* _tmp1172_;
	ValaVersionAttribute* _tmp1173_;
	ValaSourceReference* _tmp1174_;
	ValaSourceReference* _tmp1175_;
	gboolean _tmp1176_ = FALSE;
	ValaSymbolAccessibility _tmp1177_;
	gboolean _tmp1238_ = FALSE;
	gboolean _tmp1239_;
	gboolean _tmp1278_ = FALSE;
	gboolean _tmp1279_ = FALSE;
	gboolean _tmp1280_;
	gboolean _tmp1574_;
	gboolean _tmp1575_;
	gboolean _tmp1576_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaDataType* _tmp18_;
			_type_arg_index = _type_arg_index + 1;
			_tmp13_ = _type_arg_index;
			_tmp14_ = _type_arg_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _type_arg_list;
			_tmp16_ = _type_arg_index;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			type_arg = (ValaDataType*) _tmp17_;
			_tmp18_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp18_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp19_ = self->priv->_qualified;
	if (_tmp19_) {
		ValaNamespace* _tmp20_;
		ValaNamespace* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaScope* _tmp24_;
		ValaScope* _tmp25_;
		const gchar* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaSymbol* _tmp28_;
		_tmp20_ = vala_code_context_get_root (context);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp22_;
		_tmp23_ = base_symbol;
		_tmp24_ = vala_symbol_get_scope (_tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_member_name;
		_tmp27_ = vala_scope_lookup (_tmp25_, _tmp26_);
		_tmp28_ = _tmp27_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp28_);
		_vala_code_node_unref0 (_tmp28_);
	} else {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		_tmp29_ = vala_member_access_get_inner (self);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == NULL) {
			const gchar* _tmp31_;
			ValaSemanticAnalyzer* _tmp36_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaSymbol* _tmp40_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp41_;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSymbol* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			gboolean _tmp157_ = FALSE;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			_tmp31_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp31_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp32_;
				ValaSemanticAnalyzer* _tmp33_;
				_tmp32_ = vala_code_context_get_analyzer (context);
				_tmp33_ = _tmp32_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp33_)) {
					ValaSourceReference* _tmp34_;
					ValaSourceReference* _tmp35_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp34_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp35_ = _tmp34_;
					vala_report_error (_tmp35_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp36_ = vala_code_context_get_analyzer (context);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_semantic_analyzer_get_current_symbol (_tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = _vala_code_node_ref0 (_tmp39_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp40_;
			method_found = FALSE;
			_tmp41_ = vala_code_context_get_analyzer (context);
			_tmp42_ = _tmp41_;
			_tmp43_ = vala_semantic_analyzer_get_current_symbol (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = _vala_code_node_ref0 (_tmp44_);
			sym = _tmp45_;
			while (TRUE) {
				gboolean _tmp46_ = FALSE;
				ValaSymbol* _tmp47_;
				gboolean _tmp50_;
				ValaSymbol* _tmp104_;
				const gchar* _tmp105_;
				ValaSymbol* _tmp106_;
				ValaSymbol* _tmp107_;
				gboolean _tmp108_ = FALSE;
				gboolean _tmp109_ = FALSE;
				ValaSymbol* _tmp110_;
				ValaSymbol* _tmp111_;
				ValaSymbol* _tmp150_;
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp153_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				_tmp47_ = sym;
				if (_tmp47_ != NULL) {
					ValaSymbol* _tmp48_;
					ValaSymbol* _tmp49_;
					_tmp48_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp49_ = _tmp48_;
					_tmp46_ = _tmp49_ == NULL;
				} else {
					_tmp46_ = FALSE;
				}
				if (!_tmp46_) {
					break;
				}
				_tmp50_ = method_found;
				if (!_tmp50_) {
					ValaSymbol* _tmp51_;
					_tmp51_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp51_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp52_;
						ValaCreationMethod* _tmp53_;
						ValaCreationMethod* _tmp54_;
						ValaParameter* _tmp55_;
						ValaParameter* _tmp56_;
						ValaParameter* _tmp57_;
						_tmp52_ = sym;
						_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp53_;
						_tmp54_ = cm;
						_tmp55_ = vala_method_get_this_parameter ((ValaMethod*) _tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = _vala_code_node_ref0 (_tmp56_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp57_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp58_;
						_tmp58_ = sym;
						if (VALA_IS_PROPERTY (_tmp58_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp59_;
							ValaProperty* _tmp60_;
							ValaProperty* _tmp61_;
							ValaParameter* _tmp62_;
							ValaParameter* _tmp63_;
							ValaParameter* _tmp64_;
							ValaProperty* _tmp65_;
							ValaMemberBinding _tmp66_;
							ValaMemberBinding _tmp67_;
							ValaProperty* _tmp68_;
							ValaMemberBinding _tmp69_;
							ValaMemberBinding _tmp70_;
							_tmp59_ = sym;
							_tmp60_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp60_;
							_tmp61_ = prop;
							_tmp62_ = vala_property_get_this_parameter (_tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = _vala_code_node_ref0 (_tmp63_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp64_;
							_tmp65_ = prop;
							_tmp66_ = vala_property_get_binding (_tmp65_);
							_tmp67_ = _tmp66_;
							may_access_instance_members = _tmp67_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp68_ = prop;
							_tmp69_ = vala_property_get_binding (_tmp68_);
							_tmp70_ = _tmp69_;
							may_access_klass_members = _tmp70_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp71_;
							_tmp71_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp71_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp72_;
								ValaConstructor* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaParameter* _tmp75_;
								ValaParameter* _tmp76_;
								ValaParameter* _tmp77_;
								ValaConstructor* _tmp78_;
								ValaMemberBinding _tmp79_;
								ValaMemberBinding _tmp80_;
								_tmp72_ = sym;
								_tmp73_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp72_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp73_;
								_tmp74_ = c;
								_tmp75_ = vala_constructor_get_this_parameter (_tmp74_);
								_tmp76_ = _tmp75_;
								_tmp77_ = _vala_code_node_ref0 (_tmp76_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp77_;
								_tmp78_ = c;
								_tmp79_ = vala_constructor_get_binding (_tmp78_);
								_tmp80_ = _tmp79_;
								may_access_instance_members = _tmp80_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp81_;
								_tmp81_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp81_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp82_;
									ValaDestructor* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaParameter* _tmp85_;
									ValaParameter* _tmp86_;
									ValaParameter* _tmp87_;
									ValaDestructor* _tmp88_;
									ValaMemberBinding _tmp89_;
									ValaMemberBinding _tmp90_;
									_tmp82_ = sym;
									_tmp83_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp82_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp83_;
									_tmp84_ = d;
									_tmp85_ = vala_destructor_get_this_parameter (_tmp84_);
									_tmp86_ = _tmp85_;
									_tmp87_ = _vala_code_node_ref0 (_tmp86_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp87_;
									_tmp88_ = d;
									_tmp89_ = vala_destructor_get_binding (_tmp88_);
									_tmp90_ = _tmp89_;
									may_access_instance_members = _tmp90_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp91_;
									_tmp91_ = sym;
									if (VALA_IS_METHOD (_tmp91_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp92_;
										ValaMethod* _tmp93_;
										ValaMethod* _tmp94_;
										ValaParameter* _tmp95_;
										ValaParameter* _tmp96_;
										ValaParameter* _tmp97_;
										ValaMethod* _tmp98_;
										ValaMemberBinding _tmp99_;
										ValaMemberBinding _tmp100_;
										ValaMethod* _tmp101_;
										ValaMemberBinding _tmp102_;
										ValaMemberBinding _tmp103_;
										_tmp92_ = sym;
										_tmp93_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp92_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp93_;
										_tmp94_ = m;
										_tmp95_ = vala_method_get_this_parameter (_tmp94_);
										_tmp96_ = _tmp95_;
										_tmp97_ = _vala_code_node_ref0 (_tmp96_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp97_;
										_tmp98_ = m;
										_tmp99_ = vala_method_get_binding (_tmp98_);
										_tmp100_ = _tmp99_;
										may_access_instance_members = _tmp100_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp101_ = m;
										_tmp102_ = vala_method_get_binding (_tmp101_);
										_tmp103_ = _tmp102_;
										may_access_klass_members = _tmp103_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp104_ = sym;
				_tmp105_ = self->priv->_member_name;
				_tmp106_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp104_, _tmp105_);
				_tmp107_ = _tmp106_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp107_);
				_vala_code_node_unref0 (_tmp107_);
				_tmp110_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp111_ = _tmp110_;
				if (_tmp111_ == NULL) {
					ValaSymbol* _tmp112_;
					_tmp112_ = sym;
					_tmp109_ = VALA_IS_TYPESYMBOL (_tmp112_);
				} else {
					_tmp109_ = FALSE;
				}
				if (_tmp109_) {
					gboolean _tmp113_;
					_tmp113_ = may_access_instance_members;
					_tmp108_ = _tmp113_;
				} else {
					_tmp108_ = FALSE;
				}
				if (_tmp108_) {
					ValaParameter* _tmp114_;
					ValaDataType* _tmp115_;
					ValaDataType* _tmp116_;
					const gchar* _tmp117_;
					ValaSymbol* _tmp118_;
					ValaSymbol* _tmp119_;
					gboolean _tmp120_ = FALSE;
					ValaSymbol* _tmp121_;
					ValaSymbol* _tmp122_;
					_tmp114_ = this_parameter;
					_tmp115_ = vala_variable_get_variable_type ((ValaVariable*) _tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = self->priv->_member_name;
					_tmp118_ = vala_data_type_get_member (_tmp116_, _tmp117_);
					_tmp119_ = _tmp118_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp119_);
					_vala_code_node_unref0 (_tmp119_);
					_tmp121_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp122_ = _tmp121_;
					if (_tmp122_ != NULL) {
						ValaSymbol* _tmp123_;
						ValaSymbol* _tmp124_;
						_tmp123_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp124_ = _tmp123_;
						_tmp120_ = vala_member_access_is_instance_symbol (_tmp124_);
					} else {
						_tmp120_ = FALSE;
					}
					if (_tmp120_) {
						ValaSourceReference* _tmp125_;
						ValaSourceReference* _tmp126_;
						ValaMemberAccess* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaExpression* _tmp129_;
						ValaExpression* _tmp130_;
						ValaParameter* _tmp131_;
						ValaDataType* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						ValaExpression* _tmp136_;
						ValaExpression* _tmp137_;
						ValaDataType* _tmp138_;
						ValaDataType* _tmp139_;
						ValaExpression* _tmp140_;
						ValaExpression* _tmp141_;
						ValaParameter* _tmp142_;
						ValaExpression* _tmp143_;
						ValaExpression* _tmp144_;
						ValaDataType* _tmp145_;
						ValaDataType* _tmp146_;
						const gchar* _tmp147_;
						ValaSymbol* _tmp148_;
						ValaSymbol* _tmp149_;
						_tmp125_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp126_ = _tmp125_;
						_tmp127_ = vala_member_access_new (NULL, "this", _tmp126_);
						_tmp128_ = _tmp127_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp128_);
						_vala_code_node_unref0 (_tmp128_);
						_tmp129_ = vala_member_access_get_inner (self);
						_tmp130_ = _tmp129_;
						_tmp131_ = this_parameter;
						_tmp132_ = vala_variable_get_variable_type ((ValaVariable*) _tmp131_);
						_tmp133_ = _tmp132_;
						_tmp134_ = vala_data_type_copy (_tmp133_);
						_tmp135_ = _tmp134_;
						vala_expression_set_value_type (_tmp130_, _tmp135_);
						_vala_code_node_unref0 (_tmp135_);
						_tmp136_ = vala_member_access_get_inner (self);
						_tmp137_ = _tmp136_;
						_tmp138_ = vala_expression_get_value_type (_tmp137_);
						_tmp139_ = _tmp138_;
						vala_data_type_set_value_owned (_tmp139_, FALSE);
						_tmp140_ = vala_member_access_get_inner (self);
						_tmp141_ = _tmp140_;
						_tmp142_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp141_, (ValaSymbol*) _tmp142_);
						_tmp143_ = vala_member_access_get_inner (self);
						_tmp144_ = _tmp143_;
						_tmp145_ = vala_expression_get_value_type (_tmp144_);
						_tmp146_ = _tmp145_;
						_tmp147_ = self->priv->_member_name;
						_tmp148_ = vala_data_type_get_member (_tmp146_, _tmp147_);
						_tmp149_ = _tmp148_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp149_);
						_vala_code_node_unref0 (_tmp149_);
					}
				}
				_tmp150_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp151_ = _tmp150_;
				if (_tmp151_ == NULL) {
					ValaSymbol* _tmp152_;
					_tmp152_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp152_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp153_ = sym;
				_tmp154_ = vala_symbol_get_parent_symbol (_tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = _vala_code_node_ref0 (_tmp155_);
				_vala_code_node_unref0 (sym);
				sym = _tmp156_;
			}
			_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			if (_tmp159_ == NULL) {
				ValaSourceReference* _tmp160_;
				ValaSourceReference* _tmp161_;
				_tmp160_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp161_ = _tmp160_;
				_tmp157_ = _tmp161_ != NULL;
			} else {
				_tmp157_ = FALSE;
			}
			if (_tmp157_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp162_;
					ValaSourceReference* _tmp163_;
					ValaList* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _tmp166_;
					gint _ns_size = 0;
					ValaList* _tmp167_;
					gint _tmp168_;
					gint _tmp169_;
					gint _ns_index = 0;
					_tmp162_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp163_ = _tmp162_;
					_tmp164_ = vala_source_reference_get_using_directives (_tmp163_);
					_tmp165_ = _tmp164_;
					_tmp166_ = _vala_iterable_ref0 (_tmp165_);
					_ns_list = _tmp166_;
					_tmp167_ = _ns_list;
					_tmp168_ = vala_collection_get_size ((ValaCollection*) _tmp167_);
					_tmp169_ = _tmp168_;
					_ns_size = _tmp169_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp170_;
						gint _tmp171_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp172_;
						gint _tmp173_;
						gpointer _tmp174_;
						ValaUsingDirective* _tmp175_;
						gboolean _tmp176_;
						gboolean _tmp177_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp178_;
						ValaSymbol* _tmp179_;
						ValaSymbol* _tmp180_;
						ValaScope* _tmp181_;
						ValaScope* _tmp182_;
						const gchar* _tmp183_;
						ValaSymbol* _tmp184_;
						ValaSymbol* _tmp185_;
						_ns_index = _ns_index + 1;
						_tmp170_ = _ns_index;
						_tmp171_ = _ns_size;
						if (!(_tmp170_ < _tmp171_)) {
							break;
						}
						_tmp172_ = _ns_list;
						_tmp173_ = _ns_index;
						_tmp174_ = vala_list_get (_tmp172_, _tmp173_);
						ns = (ValaUsingDirective*) _tmp174_;
						_tmp175_ = ns;
						_tmp176_ = vala_code_node_get_error ((ValaCodeNode*) _tmp175_);
						_tmp177_ = _tmp176_;
						if (_tmp177_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp178_ = ns;
						_tmp179_ = vala_using_directive_get_namespace_symbol (_tmp178_);
						_tmp180_ = _tmp179_;
						_tmp181_ = vala_symbol_get_scope (_tmp180_);
						_tmp182_ = _tmp181_;
						_tmp183_ = self->priv->_member_name;
						_tmp184_ = vala_scope_lookup (_tmp182_, _tmp183_);
						local_sym = _tmp184_;
						_tmp185_ = local_sym;
						if (_tmp185_ != NULL) {
							gboolean _tmp186_ = FALSE;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp188_;
							ValaSymbol* inner_sym = NULL;
							ValaSymbol* _tmp204_;
							ValaSymbol* _tmp205_;
							ValaSymbol* _tmp206_;
							ValaMemberAccess* inner_ma = NULL;
							ValaMemberAccess* _tmp226_;
							ValaExpression* _tmp227_;
							ValaExpression* _tmp228_;
							ValaSymbol* _tmp229_;
							_tmp187_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp188_ = _tmp187_;
							if (_tmp188_ != NULL) {
								ValaSymbol* _tmp189_;
								ValaSymbol* _tmp190_;
								ValaSymbol* _tmp191_;
								_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp190_ = _tmp189_;
								_tmp191_ = local_sym;
								_tmp186_ = _tmp190_ != _tmp191_;
							} else {
								_tmp186_ = FALSE;
							}
							if (_tmp186_) {
								ValaSourceReference* _tmp192_;
								ValaSourceReference* _tmp193_;
								const gchar* _tmp194_;
								ValaSymbol* _tmp195_;
								ValaSymbol* _tmp196_;
								gchar* _tmp197_;
								gchar* _tmp198_;
								ValaSymbol* _tmp199_;
								gchar* _tmp200_;
								gchar* _tmp201_;
								gchar* _tmp202_;
								gchar* _tmp203_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp193_ = _tmp192_;
								_tmp194_ = self->priv->_member_name;
								_tmp195_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp196_ = _tmp195_;
								_tmp197_ = vala_symbol_get_full_name (_tmp196_);
								_tmp198_ = _tmp197_;
								_tmp199_ = local_sym;
								_tmp200_ = vala_symbol_get_full_name (_tmp199_);
								_tmp201_ = _tmp200_;
								_tmp202_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp194_, _tmp198_, _tmp201_);
								_tmp203_ = _tmp202_;
								vala_report_error (_tmp193_, _tmp203_);
								_g_free0 (_tmp203_);
								_g_free0 (_tmp201_);
								_g_free0 (_tmp198_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp204_ = local_sym;
							_tmp205_ = vala_symbol_get_parent_symbol (_tmp204_);
							_tmp206_ = _tmp205_;
							inner_sym = _tmp206_;
							inner_ma = self;
							while (TRUE) {
								gboolean _tmp207_ = FALSE;
								ValaSymbol* _tmp208_;
								ValaMemberAccess* _tmp212_;
								ValaSymbol* _tmp213_;
								const gchar* _tmp214_;
								const gchar* _tmp215_;
								ValaSourceReference* _tmp216_;
								ValaSourceReference* _tmp217_;
								ValaMemberAccess* _tmp218_;
								ValaMemberAccess* _tmp219_;
								ValaMemberAccess* _tmp220_;
								ValaExpression* _tmp221_;
								ValaExpression* _tmp222_;
								ValaSymbol* _tmp223_;
								ValaSymbol* _tmp224_;
								ValaSymbol* _tmp225_;
								_tmp208_ = inner_sym;
								if (_tmp208_ != NULL) {
									ValaSymbol* _tmp209_;
									const gchar* _tmp210_;
									const gchar* _tmp211_;
									_tmp209_ = inner_sym;
									_tmp210_ = vala_symbol_get_name (_tmp209_);
									_tmp211_ = _tmp210_;
									_tmp207_ = _tmp211_ != NULL;
								} else {
									_tmp207_ = FALSE;
								}
								if (!_tmp207_) {
									break;
								}
								_tmp212_ = inner_ma;
								_tmp213_ = inner_sym;
								_tmp214_ = vala_symbol_get_name (_tmp213_);
								_tmp215_ = _tmp214_;
								_tmp216_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp217_ = _tmp216_;
								_tmp218_ = vala_member_access_new (NULL, _tmp215_, _tmp217_);
								_tmp219_ = _tmp218_;
								vala_member_access_set_inner (_tmp212_, (ValaExpression*) _tmp219_);
								_vala_code_node_unref0 (_tmp219_);
								_tmp220_ = inner_ma;
								_tmp221_ = vala_member_access_get_inner (_tmp220_);
								_tmp222_ = _tmp221_;
								inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp222_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
								_tmp223_ = inner_sym;
								_tmp224_ = vala_symbol_get_parent_symbol (_tmp223_);
								_tmp225_ = _tmp224_;
								inner_sym = _tmp225_;
							}
							_tmp226_ = inner_ma;
							vala_member_access_set_qualified (_tmp226_, TRUE);
							_tmp227_ = vala_member_access_get_inner (self);
							_tmp228_ = _tmp227_;
							vala_code_node_check ((ValaCodeNode*) _tmp228_, context);
							_tmp229_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp229_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp230_;
			ValaExpression* _tmp231_;
			gboolean _tmp232_;
			gboolean _tmp233_;
			ValaExpression* _tmp234_;
			ValaExpression* _tmp235_;
			ValaDataType* _tmp236_;
			ValaDataType* _tmp237_;
			ValaExpression* _tmp256_;
			ValaExpression* _tmp257_;
			gboolean _tmp273_ = FALSE;
			ValaExpression* _tmp274_;
			ValaExpression* _tmp275_;
			gboolean _tmp297_ = FALSE;
			ValaSymbol* _tmp298_;
			ValaSymbol* _tmp299_;
			gboolean _tmp334_ = FALSE;
			gboolean _tmp335_ = FALSE;
			ValaSymbol* _tmp336_;
			ValaSymbol* _tmp337_;
			gboolean _tmp609_ = FALSE;
			ValaSymbol* _tmp610_;
			ValaSymbol* _tmp611_;
			_tmp230_ = vala_member_access_get_inner (self);
			_tmp231_ = _tmp230_;
			_tmp232_ = vala_code_node_get_error ((ValaCodeNode*) _tmp231_);
			_tmp233_ = _tmp232_;
			if (_tmp233_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp234_ = vala_member_access_get_inner (self);
			_tmp235_ = _tmp234_;
			_tmp236_ = vala_expression_get_value_type (_tmp235_);
			_tmp237_ = _tmp236_;
			if (VALA_IS_POINTER_TYPE (_tmp237_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp238_;
				ValaExpression* _tmp239_;
				ValaDataType* _tmp240_;
				ValaDataType* _tmp241_;
				ValaPointerType* _tmp242_;
				gboolean _tmp243_ = FALSE;
				ValaPointerType* _tmp244_;
				_tmp238_ = vala_member_access_get_inner (self);
				_tmp239_ = _tmp238_;
				_tmp240_ = vala_expression_get_value_type (_tmp239_);
				_tmp241_ = _tmp240_;
				_tmp242_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp241_) ? ((ValaPointerType*) _tmp241_) : NULL);
				pointer_type = _tmp242_;
				_tmp244_ = pointer_type;
				if (_tmp244_ != NULL) {
					ValaPointerType* _tmp245_;
					ValaDataType* _tmp246_;
					ValaDataType* _tmp247_;
					_tmp245_ = pointer_type;
					_tmp246_ = vala_pointer_type_get_base_type (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp243_ = VALA_IS_VALUE_TYPE (_tmp247_);
				} else {
					_tmp243_ = FALSE;
				}
				if (_tmp243_) {
					ValaExpression* _tmp248_;
					ValaExpression* _tmp249_;
					ValaSourceReference* _tmp250_;
					ValaSourceReference* _tmp251_;
					ValaPointerIndirection* _tmp252_;
					ValaPointerIndirection* _tmp253_;
					ValaExpression* _tmp254_;
					ValaExpression* _tmp255_;
					_tmp248_ = vala_member_access_get_inner (self);
					_tmp249_ = _tmp248_;
					_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp251_ = _tmp250_;
					_tmp252_ = vala_pointer_indirection_new (_tmp249_, _tmp251_);
					_tmp253_ = _tmp252_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp253_);
					_vala_code_node_unref0 (_tmp253_);
					_tmp254_ = vala_member_access_get_inner (self);
					_tmp255_ = _tmp254_;
					vala_code_node_check ((ValaCodeNode*) _tmp255_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp256_ = vala_member_access_get_inner (self);
			_tmp257_ = _tmp256_;
			if (VALA_IS_MEMBER_ACCESS (_tmp257_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp258_;
				ValaExpression* _tmp259_;
				ValaMemberAccess* _tmp260_;
				ValaMemberAccess* _tmp261_;
				gboolean _tmp262_;
				_tmp258_ = vala_member_access_get_inner (self);
				_tmp259_ = _tmp258_;
				_tmp260_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp259_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp260_;
				_tmp261_ = ma;
				_tmp262_ = _tmp261_->priv->_prototype_access;
				if (_tmp262_) {
					ValaSourceReference* _tmp263_;
					ValaSourceReference* _tmp264_;
					ValaExpression* _tmp265_;
					ValaExpression* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaSymbol* _tmp268_;
					gchar* _tmp269_;
					gchar* _tmp270_;
					gchar* _tmp271_;
					gchar* _tmp272_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp263_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp264_ = _tmp263_;
					_tmp265_ = vala_member_access_get_inner (self);
					_tmp266_ = _tmp265_;
					_tmp267_ = vala_expression_get_symbol_reference (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = vala_symbol_get_full_name (_tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp270_);
					_tmp272_ = _tmp271_;
					vala_report_error (_tmp264_, _tmp272_);
					_g_free0 (_tmp272_);
					_g_free0 (_tmp270_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp274_ = vala_member_access_get_inner (self);
			_tmp275_ = _tmp274_;
			if (VALA_IS_MEMBER_ACCESS (_tmp275_)) {
				_tmp273_ = TRUE;
			} else {
				ValaExpression* _tmp276_;
				ValaExpression* _tmp277_;
				_tmp276_ = vala_member_access_get_inner (self);
				_tmp277_ = _tmp276_;
				_tmp273_ = VALA_IS_BASE_ACCESS (_tmp277_);
			}
			if (_tmp273_) {
				ValaExpression* _tmp278_;
				ValaExpression* _tmp279_;
				ValaSymbol* _tmp280_;
				ValaSymbol* _tmp281_;
				ValaSymbol* _tmp282_;
				gboolean _tmp283_ = FALSE;
				ValaSymbol* _tmp284_;
				ValaSymbol* _tmp285_;
				_tmp278_ = vala_member_access_get_inner (self);
				_tmp279_ = _tmp278_;
				_tmp280_ = vala_expression_get_symbol_reference (_tmp279_);
				_tmp281_ = _tmp280_;
				_tmp282_ = _vala_code_node_ref0 (_tmp281_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp282_;
				_tmp284_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp285_ = _tmp284_;
				if (_tmp285_ == NULL) {
					gboolean _tmp286_ = FALSE;
					ValaSymbol* _tmp287_;
					_tmp287_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp287_)) {
						_tmp286_ = TRUE;
					} else {
						ValaSymbol* _tmp288_;
						_tmp288_ = base_symbol;
						_tmp286_ = VALA_IS_TYPESYMBOL (_tmp288_);
					}
					_tmp283_ = _tmp286_;
				} else {
					_tmp283_ = FALSE;
				}
				if (_tmp283_) {
					ValaSymbol* _tmp289_;
					ValaScope* _tmp290_;
					ValaScope* _tmp291_;
					const gchar* _tmp292_;
					ValaSymbol* _tmp293_;
					ValaSymbol* _tmp294_;
					ValaExpression* _tmp295_;
					ValaExpression* _tmp296_;
					_tmp289_ = base_symbol;
					_tmp290_ = vala_symbol_get_scope (_tmp289_);
					_tmp291_ = _tmp290_;
					_tmp292_ = self->priv->_member_name;
					_tmp293_ = vala_scope_lookup (_tmp291_, _tmp292_);
					_tmp294_ = _tmp293_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp294_);
					_vala_code_node_unref0 (_tmp294_);
					_tmp295_ = vala_member_access_get_inner (self);
					_tmp296_ = _tmp295_;
					if (VALA_IS_BASE_ACCESS (_tmp296_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp298_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp299_ = _tmp298_;
			if (_tmp299_ == NULL) {
				ValaExpression* _tmp300_;
				ValaExpression* _tmp301_;
				ValaDataType* _tmp302_;
				ValaDataType* _tmp303_;
				_tmp300_ = vala_member_access_get_inner (self);
				_tmp301_ = _tmp300_;
				_tmp302_ = vala_expression_get_value_type (_tmp301_);
				_tmp303_ = _tmp302_;
				_tmp297_ = _tmp303_ != NULL;
			} else {
				_tmp297_ = FALSE;
			}
			if (_tmp297_) {
				gboolean _tmp304_;
				ValaSymbol* _tmp332_;
				ValaSymbol* _tmp333_;
				_tmp304_ = self->priv->_pointer_member_access;
				if (_tmp304_) {
					ValaExpression* _tmp305_;
					ValaExpression* _tmp306_;
					ValaDataType* _tmp307_;
					ValaDataType* _tmp308_;
					const gchar* _tmp309_;
					ValaSymbol* _tmp310_;
					ValaSymbol* _tmp311_;
					_tmp305_ = vala_member_access_get_inner (self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_expression_get_value_type (_tmp306_);
					_tmp308_ = _tmp307_;
					_tmp309_ = self->priv->_member_name;
					_tmp310_ = vala_data_type_get_pointer_member (_tmp308_, _tmp309_);
					_tmp311_ = _tmp310_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp311_);
					_vala_code_node_unref0 (_tmp311_);
				} else {
					ValaExpression* _tmp312_;
					ValaExpression* _tmp313_;
					ValaDataType* _tmp314_;
					ValaDataType* _tmp315_;
					ValaTypeSymbol* _tmp316_;
					ValaTypeSymbol* _tmp317_;
					ValaExpression* _tmp325_;
					ValaExpression* _tmp326_;
					ValaDataType* _tmp327_;
					ValaDataType* _tmp328_;
					const gchar* _tmp329_;
					ValaSymbol* _tmp330_;
					ValaSymbol* _tmp331_;
					_tmp312_ = vala_member_access_get_inner (self);
					_tmp313_ = _tmp312_;
					_tmp314_ = vala_expression_get_value_type (_tmp313_);
					_tmp315_ = _tmp314_;
					_tmp316_ = vala_data_type_get_data_type (_tmp315_);
					_tmp317_ = _tmp316_;
					if (_tmp317_ != NULL) {
						ValaExpression* _tmp318_;
						ValaExpression* _tmp319_;
						ValaDataType* _tmp320_;
						ValaDataType* _tmp321_;
						ValaTypeSymbol* _tmp322_;
						ValaTypeSymbol* _tmp323_;
						ValaSymbol* _tmp324_;
						_tmp318_ = vala_member_access_get_inner (self);
						_tmp319_ = _tmp318_;
						_tmp320_ = vala_expression_get_value_type (_tmp319_);
						_tmp321_ = _tmp320_;
						_tmp322_ = vala_data_type_get_data_type (_tmp321_);
						_tmp323_ = _tmp322_;
						_tmp324_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp323_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp324_;
					}
					_tmp325_ = vala_member_access_get_inner (self);
					_tmp326_ = _tmp325_;
					_tmp327_ = vala_expression_get_value_type (_tmp326_);
					_tmp328_ = _tmp327_;
					_tmp329_ = self->priv->_member_name;
					_tmp330_ = vala_data_type_get_member (_tmp328_, _tmp329_);
					_tmp331_ = _tmp330_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp331_);
					_vala_code_node_unref0 (_tmp331_);
				}
				_tmp332_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp333_ = _tmp332_;
				if (_tmp333_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp336_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp337_ = _tmp336_;
			if (_tmp337_ == NULL) {
				ValaExpression* _tmp338_;
				ValaExpression* _tmp339_;
				ValaDataType* _tmp340_;
				ValaDataType* _tmp341_;
				_tmp338_ = vala_member_access_get_inner (self);
				_tmp339_ = _tmp338_;
				_tmp340_ = vala_expression_get_value_type (_tmp339_);
				_tmp341_ = _tmp340_;
				_tmp335_ = _tmp341_ != NULL;
			} else {
				_tmp335_ = FALSE;
			}
			if (_tmp335_) {
				ValaExpression* _tmp342_;
				ValaExpression* _tmp343_;
				ValaDataType* _tmp344_;
				ValaDataType* _tmp345_;
				gboolean _tmp346_;
				gboolean _tmp347_;
				_tmp342_ = vala_member_access_get_inner (self);
				_tmp343_ = _tmp342_;
				_tmp344_ = vala_expression_get_value_type (_tmp343_);
				_tmp345_ = _tmp344_;
				_tmp346_ = vala_data_type_get_is_dynamic (_tmp345_);
				_tmp347_ = _tmp346_;
				_tmp334_ = _tmp347_;
			} else {
				_tmp334_ = FALSE;
			}
			if (_tmp334_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp348_;
				ValaExpression* _tmp349_;
				ValaDataType* _tmp350_;
				ValaDataType* _tmp351_;
				ValaObjectType* _tmp352_;
				ValaCodeNode* _tmp353_;
				ValaCodeNode* _tmp354_;
				ValaSymbol* _tmp557_;
				ValaSymbol* _tmp558_;
				ValaSymbol* _tmp607_;
				ValaSymbol* _tmp608_;
				_tmp348_ = vala_member_access_get_inner (self);
				_tmp349_ = _tmp348_;
				_tmp350_ = vala_expression_get_value_type (_tmp349_);
				_tmp351_ = _tmp350_;
				_tmp352_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp351_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp352_;
				_tmp353_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp354_ = _tmp353_;
				if (VALA_IS_METHOD_CALL (_tmp354_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp355_;
					ValaCodeNode* _tmp356_;
					ValaMethodCall* _tmp357_;
					ValaMethodCall* _tmp358_;
					ValaExpression* _tmp359_;
					ValaExpression* _tmp360_;
					_tmp355_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp356_ = _tmp355_;
					_tmp357_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp356_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp357_;
					_tmp358_ = invoc;
					_tmp359_ = vala_method_call_get_call (_tmp358_);
					_tmp360_ = _tmp359_;
					if (_tmp360_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp361_;
						ValaDataType* _tmp362_;
						ValaDataType* _tmp363_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp378_;
						ValaExpression* _tmp379_;
						ValaDataType* _tmp380_;
						ValaDataType* _tmp381_;
						const gchar* _tmp382_;
						ValaDataType* _tmp383_;
						ValaSourceReference* _tmp384_;
						ValaSourceReference* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						ValaDynamicMethod* _tmp387_;
						ValaMethodCall* _tmp388_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp389_;
						ValaErrorType* _tmp390_;
						ValaDynamicMethod* _tmp391_;
						ValaErrorType* _tmp392_;
						ValaDynamicMethod* _tmp393_;
						ValaDynamicMethod* _tmp394_;
						ValaParameter* _tmp395_;
						ValaParameter* _tmp396_;
						ValaDynamicMethod* _tmp397_;
						ValaObjectType* _tmp398_;
						ValaDataType* _tmp399_;
						ValaDataType* _tmp400_;
						ValaParameter* _tmp401_;
						ValaParameter* _tmp402_;
						ValaObjectType* _tmp403_;
						ValaObjectTypeSymbol* _tmp404_;
						ValaObjectTypeSymbol* _tmp405_;
						ValaScope* _tmp406_;
						ValaScope* _tmp407_;
						ValaDynamicMethod* _tmp408_;
						ValaDynamicMethod* _tmp409_;
						_tmp361_ = invoc;
						_tmp362_ = vala_expression_get_target_type ((ValaExpression*) _tmp361_);
						_tmp363_ = _tmp362_;
						if (_tmp363_ != NULL) {
							ValaMethodCall* _tmp364_;
							ValaDataType* _tmp365_;
							ValaDataType* _tmp366_;
							ValaDataType* _tmp367_;
							ValaDataType* _tmp368_;
							_tmp364_ = invoc;
							_tmp365_ = vala_expression_get_target_type ((ValaExpression*) _tmp364_);
							_tmp366_ = _tmp365_;
							_tmp367_ = vala_data_type_copy (_tmp366_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp367_;
							_tmp368_ = ret_type;
							vala_data_type_set_value_owned (_tmp368_, TRUE);
						} else {
							ValaMethodCall* _tmp369_;
							ValaCodeNode* _tmp370_;
							ValaCodeNode* _tmp371_;
							_tmp369_ = invoc;
							_tmp370_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp369_);
							_tmp371_ = _tmp370_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp371_)) {
								ValaVoidType* _tmp372_;
								_tmp372_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp372_;
							} else {
								ValaExpression* _tmp373_;
								ValaExpression* _tmp374_;
								ValaDataType* _tmp375_;
								ValaDataType* _tmp376_;
								ValaDataType* _tmp377_;
								_tmp373_ = vala_member_access_get_inner (self);
								_tmp374_ = _tmp373_;
								_tmp375_ = vala_expression_get_value_type (_tmp374_);
								_tmp376_ = _tmp375_;
								_tmp377_ = vala_data_type_copy (_tmp376_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp377_;
							}
						}
						_tmp378_ = vala_member_access_get_inner (self);
						_tmp379_ = _tmp378_;
						_tmp380_ = vala_expression_get_value_type (_tmp379_);
						_tmp381_ = _tmp380_;
						_tmp382_ = self->priv->_member_name;
						_tmp383_ = ret_type;
						_tmp384_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp385_ = _tmp384_;
						_tmp386_ = vala_dynamic_method_new (_tmp381_, _tmp382_, _tmp383_, _tmp385_, NULL);
						m = _tmp386_;
						_tmp387_ = m;
						_tmp388_ = invoc;
						vala_dynamic_method_set_invocation (_tmp387_, _tmp388_);
						_tmp389_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp389_;
						_tmp390_ = err;
						vala_error_type_set_dynamic_error (_tmp390_, TRUE);
						_tmp391_ = m;
						_tmp392_ = err;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp391_, (ValaDataType*) _tmp392_);
						_tmp393_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp393_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp394_ = m;
						_tmp395_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp396_ = _tmp395_;
						vala_callable_add_parameter ((ValaCallable*) _tmp394_, _tmp396_);
						_vala_code_node_unref0 (_tmp396_);
						_tmp397_ = m;
						_tmp398_ = dynamic_object_type;
						_tmp399_ = vala_data_type_copy ((ValaDataType*) _tmp398_);
						_tmp400_ = _tmp399_;
						_tmp401_ = vala_parameter_new ("this", _tmp400_, NULL);
						_tmp402_ = _tmp401_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp397_, _tmp402_);
						_vala_code_node_unref0 (_tmp402_);
						_vala_code_node_unref0 (_tmp400_);
						_tmp403_ = dynamic_object_type;
						_tmp404_ = vala_object_type_get_type_symbol (_tmp403_);
						_tmp405_ = _tmp404_;
						_tmp406_ = vala_symbol_get_scope ((ValaSymbol*) _tmp405_);
						_tmp407_ = _tmp406_;
						_tmp408_ = m;
						vala_scope_add (_tmp407_, NULL, (ValaSymbol*) _tmp408_);
						_tmp409_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp409_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp410_;
					ValaCodeNode* _tmp411_;
					_tmp410_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp411_ = _tmp410_;
					if (VALA_IS_ASSIGNMENT (_tmp411_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp412_;
						ValaCodeNode* _tmp413_;
						ValaAssignment* _tmp414_;
						gboolean _tmp415_ = FALSE;
						ValaAssignment* _tmp416_;
						ValaExpression* _tmp417_;
						ValaExpression* _tmp418_;
						_tmp412_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp413_ = _tmp412_;
						_tmp414_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp413_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp414_;
						_tmp416_ = a;
						_tmp417_ = vala_assignment_get_left (_tmp416_);
						_tmp418_ = _tmp417_;
						if (_tmp418_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp419_ = FALSE;
							ValaAssignment* _tmp420_;
							ValaAssignmentOperator _tmp421_;
							ValaAssignmentOperator _tmp422_;
							_tmp420_ = a;
							_tmp421_ = vala_assignment_get_operator (_tmp420_);
							_tmp422_ = _tmp421_;
							if (_tmp422_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp419_ = TRUE;
							} else {
								ValaAssignment* _tmp423_;
								ValaAssignmentOperator _tmp424_;
								ValaAssignmentOperator _tmp425_;
								_tmp423_ = a;
								_tmp424_ = vala_assignment_get_operator (_tmp423_);
								_tmp425_ = _tmp424_;
								_tmp419_ = _tmp425_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp415_ = _tmp419_;
						} else {
							_tmp415_ = FALSE;
						}
						if (_tmp415_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp426_;
							ValaExpression* _tmp427_;
							ValaDataType* _tmp428_;
							ValaDataType* _tmp429_;
							const gchar* _tmp430_;
							ValaVoidType* _tmp431_;
							ValaVoidType* _tmp432_;
							ValaSourceReference* _tmp433_;
							ValaSourceReference* _tmp434_;
							ValaDynamicSignal* _tmp435_;
							ValaDynamicSignal* _tmp436_;
							ValaDynamicSignal* _tmp437_;
							ValaAssignment* _tmp438_;
							ValaExpression* _tmp439_;
							ValaExpression* _tmp440_;
							ValaDynamicSignal* _tmp441_;
							ValaObjectType* _tmp442_;
							ValaObjectTypeSymbol* _tmp443_;
							ValaObjectTypeSymbol* _tmp444_;
							ValaScope* _tmp445_;
							ValaScope* _tmp446_;
							ValaDynamicSignal* _tmp447_;
							ValaDynamicSignal* _tmp448_;
							_tmp426_ = vala_member_access_get_inner (self);
							_tmp427_ = _tmp426_;
							_tmp428_ = vala_expression_get_value_type (_tmp427_);
							_tmp429_ = _tmp428_;
							_tmp430_ = self->priv->_member_name;
							_tmp431_ = vala_void_type_new (NULL);
							_tmp432_ = _tmp431_;
							_tmp433_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp434_ = _tmp433_;
							_tmp435_ = vala_dynamic_signal_new (_tmp429_, _tmp430_, (ValaDataType*) _tmp432_, _tmp434_, NULL);
							_tmp436_ = _tmp435_;
							_vala_code_node_unref0 (_tmp432_);
							s = _tmp436_;
							_tmp437_ = s;
							_tmp438_ = a;
							_tmp439_ = vala_assignment_get_right (_tmp438_);
							_tmp440_ = _tmp439_;
							vala_dynamic_signal_set_handler (_tmp437_, _tmp440_);
							_tmp441_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp441_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp442_ = dynamic_object_type;
							_tmp443_ = vala_object_type_get_type_symbol (_tmp442_);
							_tmp444_ = _tmp443_;
							_tmp445_ = vala_symbol_get_scope ((ValaSymbol*) _tmp444_);
							_tmp446_ = _tmp445_;
							_tmp447_ = s;
							vala_scope_add (_tmp446_, NULL, (ValaSymbol*) _tmp447_);
							_tmp448_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp448_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp449_;
							ValaExpression* _tmp450_;
							ValaExpression* _tmp451_;
							_tmp449_ = a;
							_tmp450_ = vala_assignment_get_left (_tmp449_);
							_tmp451_ = _tmp450_;
							if (_tmp451_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp452_;
								ValaExpression* _tmp453_;
								ValaDataType* _tmp454_;
								ValaDataType* _tmp455_;
								const gchar* _tmp456_;
								ValaSourceReference* _tmp457_;
								ValaSourceReference* _tmp458_;
								ValaDynamicProperty* _tmp459_;
								ValaDynamicProperty* _tmp460_;
								ValaDynamicProperty* _tmp461_;
								ValaDynamicProperty* _tmp462_;
								ValaSourceReference* _tmp463_;
								ValaSourceReference* _tmp464_;
								ValaPropertyAccessor* _tmp465_;
								ValaPropertyAccessor* _tmp466_;
								ValaDynamicProperty* _tmp467_;
								ValaExpression* _tmp468_;
								ValaExpression* _tmp469_;
								ValaDataType* _tmp470_;
								ValaDataType* _tmp471_;
								ValaTypeSymbol* _tmp472_;
								ValaTypeSymbol* _tmp473_;
								ValaScope* _tmp474_;
								ValaScope* _tmp475_;
								ValaObjectType* _tmp476_;
								ValaObjectTypeSymbol* _tmp477_;
								ValaObjectTypeSymbol* _tmp478_;
								ValaScope* _tmp479_;
								ValaScope* _tmp480_;
								ValaDynamicProperty* _tmp481_;
								ValaDynamicProperty* _tmp482_;
								_tmp452_ = vala_member_access_get_inner (self);
								_tmp453_ = _tmp452_;
								_tmp454_ = vala_expression_get_value_type (_tmp453_);
								_tmp455_ = _tmp454_;
								_tmp456_ = self->priv->_member_name;
								_tmp457_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp458_ = _tmp457_;
								_tmp459_ = vala_dynamic_property_new (_tmp455_, _tmp456_, _tmp458_, NULL);
								prop = _tmp459_;
								_tmp460_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp460_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp461_ = prop;
								_tmp462_ = prop;
								_tmp463_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp462_);
								_tmp464_ = _tmp463_;
								_tmp465_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp464_, NULL);
								_tmp466_ = _tmp465_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp461_, _tmp466_);
								_vala_code_node_unref0 (_tmp466_);
								_tmp467_ = prop;
								_tmp468_ = vala_member_access_get_inner (self);
								_tmp469_ = _tmp468_;
								_tmp470_ = vala_expression_get_value_type (_tmp469_);
								_tmp471_ = _tmp470_;
								_tmp472_ = vala_data_type_get_data_type (_tmp471_);
								_tmp473_ = _tmp472_;
								_tmp474_ = vala_symbol_get_scope ((ValaSymbol*) _tmp473_);
								_tmp475_ = _tmp474_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp467_, _tmp475_);
								_tmp476_ = dynamic_object_type;
								_tmp477_ = vala_object_type_get_type_symbol (_tmp476_);
								_tmp478_ = _tmp477_;
								_tmp479_ = vala_symbol_get_scope ((ValaSymbol*) _tmp478_);
								_tmp480_ = _tmp479_;
								_tmp481_ = prop;
								vala_scope_add (_tmp480_, NULL, (ValaSymbol*) _tmp481_);
								_tmp482_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp482_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp483_ = FALSE;
						gboolean _tmp484_ = FALSE;
						ValaCodeNode* _tmp485_;
						ValaCodeNode* _tmp486_;
						_tmp485_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp486_ = _tmp485_;
						if (VALA_IS_MEMBER_ACCESS (_tmp486_)) {
							ValaExpression* _tmp487_;
							ValaExpression* _tmp488_;
							_tmp487_ = vala_member_access_get_inner (self);
							_tmp488_ = _tmp487_;
							_tmp484_ = VALA_IS_MEMBER_ACCESS (_tmp488_);
						} else {
							_tmp484_ = FALSE;
						}
						if (_tmp484_) {
							ValaCodeNode* _tmp489_;
							ValaCodeNode* _tmp490_;
							ValaCodeNode* _tmp491_;
							ValaCodeNode* _tmp492_;
							_tmp489_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp490_ = _tmp489_;
							_tmp491_ = vala_code_node_get_parent_node (_tmp490_);
							_tmp492_ = _tmp491_;
							_tmp483_ = VALA_IS_METHOD_CALL (_tmp492_);
						} else {
							_tmp483_ = FALSE;
						}
						if (_tmp483_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp493_;
							ValaCodeNode* _tmp494_;
							ValaMemberAccess* _tmp495_;
							gboolean _tmp496_ = FALSE;
							ValaMemberAccess* _tmp497_;
							const gchar* _tmp498_;
							_tmp493_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp494_ = _tmp493_;
							_tmp495_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp494_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp495_;
							_tmp497_ = ma;
							_tmp498_ = _tmp497_->priv->_member_name;
							if (g_strcmp0 (_tmp498_, "connect") == 0) {
								_tmp496_ = TRUE;
							} else {
								ValaMemberAccess* _tmp499_;
								const gchar* _tmp500_;
								_tmp499_ = ma;
								_tmp500_ = _tmp499_->priv->_member_name;
								_tmp496_ = g_strcmp0 (_tmp500_, "connect_after") == 0;
							}
							if (_tmp496_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp501_;
								ValaExpression* _tmp502_;
								ValaDataType* _tmp503_;
								ValaDataType* _tmp504_;
								const gchar* _tmp505_;
								ValaVoidType* _tmp506_;
								ValaVoidType* _tmp507_;
								ValaSourceReference* _tmp508_;
								ValaSourceReference* _tmp509_;
								ValaDynamicSignal* _tmp510_;
								ValaDynamicSignal* _tmp511_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp512_;
								ValaCodeNode* _tmp513_;
								ValaCodeNode* _tmp514_;
								ValaCodeNode* _tmp515_;
								ValaMethodCall* _tmp516_;
								ValaMethodCall* _tmp517_;
								ValaList* _tmp518_;
								ValaList* _tmp519_;
								gint _tmp520_;
								gint _tmp521_;
								gboolean _tmp522_;
								ValaDynamicSignal* _tmp549_;
								ValaObjectType* _tmp550_;
								ValaObjectTypeSymbol* _tmp551_;
								ValaObjectTypeSymbol* _tmp552_;
								ValaScope* _tmp553_;
								ValaScope* _tmp554_;
								ValaDynamicSignal* _tmp555_;
								ValaDynamicSignal* _tmp556_;
								_tmp501_ = vala_member_access_get_inner (self);
								_tmp502_ = _tmp501_;
								_tmp503_ = vala_expression_get_value_type (_tmp502_);
								_tmp504_ = _tmp503_;
								_tmp505_ = self->priv->_member_name;
								_tmp506_ = vala_void_type_new (NULL);
								_tmp507_ = _tmp506_;
								_tmp508_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp509_ = _tmp508_;
								_tmp510_ = vala_dynamic_signal_new (_tmp504_, _tmp505_, (ValaDataType*) _tmp507_, _tmp509_, NULL);
								_tmp511_ = _tmp510_;
								_vala_code_node_unref0 (_tmp507_);
								s = _tmp511_;
								_tmp512_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp513_ = _tmp512_;
								_tmp514_ = vala_code_node_get_parent_node (_tmp513_);
								_tmp515_ = _tmp514_;
								_tmp516_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp515_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp516_;
								_tmp517_ = mcall;
								_tmp518_ = vala_method_call_get_argument_list (_tmp517_);
								_tmp519_ = _tmp518_;
								_tmp520_ = vala_collection_get_size ((ValaCollection*) _tmp519_);
								_tmp521_ = _tmp520_;
								_tmp522_ = _tmp521_ > 0;
								_vala_iterable_unref0 (_tmp519_);
								if (_tmp522_) {
									ValaDynamicSignal* _tmp523_;
									ValaMethodCall* _tmp524_;
									ValaList* _tmp525_;
									ValaList* _tmp526_;
									gpointer _tmp527_;
									ValaExpression* _tmp528_;
									ValaMemberAccess* arg = NULL;
									ValaDynamicSignal* _tmp529_;
									ValaExpression* _tmp530_;
									ValaExpression* _tmp531_;
									gboolean _tmp532_ = FALSE;
									gboolean _tmp533_ = FALSE;
									ValaMemberAccess* _tmp534_;
									_tmp523_ = s;
									_tmp524_ = mcall;
									_tmp525_ = vala_method_call_get_argument_list (_tmp524_);
									_tmp526_ = _tmp525_;
									_tmp527_ = vala_list_get (_tmp526_, 0);
									_tmp528_ = (ValaExpression*) _tmp527_;
									vala_dynamic_signal_set_handler (_tmp523_, _tmp528_);
									_vala_code_node_unref0 (_tmp528_);
									_vala_iterable_unref0 (_tmp526_);
									_tmp529_ = s;
									_tmp530_ = vala_dynamic_signal_get_handler (_tmp529_);
									_tmp531_ = _tmp530_;
									arg = VALA_IS_MEMBER_ACCESS (_tmp531_) ? ((ValaMemberAccess*) _tmp531_) : NULL;
									_tmp534_ = arg;
									if (_tmp534_ == NULL) {
										_tmp533_ = TRUE;
									} else {
										ValaMemberAccess* _tmp535_;
										_tmp535_ = arg;
										_tmp533_ = !vala_code_node_check ((ValaCodeNode*) _tmp535_, context);
									}
									if (_tmp533_) {
										_tmp532_ = TRUE;
									} else {
										ValaMemberAccess* _tmp536_;
										ValaSymbol* _tmp537_;
										ValaSymbol* _tmp538_;
										_tmp536_ = arg;
										_tmp537_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp536_);
										_tmp538_ = _tmp537_;
										_tmp532_ = !VALA_IS_METHOD (_tmp538_);
									}
									if (_tmp532_) {
										ValaDynamicSignal* _tmp539_;
										ValaExpression* _tmp540_;
										ValaExpression* _tmp541_;
										ValaSourceReference* _tmp542_;
										ValaSourceReference* _tmp543_;
										ValaDynamicSignal* _tmp544_;
										gchar* _tmp545_;
										gchar* _tmp546_;
										gchar* _tmp547_;
										gchar* _tmp548_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp539_ = s;
										_tmp540_ = vala_dynamic_signal_get_handler (_tmp539_);
										_tmp541_ = _tmp540_;
										_tmp542_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp541_);
										_tmp543_ = _tmp542_;
										_tmp544_ = s;
										_tmp545_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp544_);
										_tmp546_ = _tmp545_;
										_tmp547_ = g_strdup_printf ("Invalid handler for `%s'", _tmp546_);
										_tmp548_ = _tmp547_;
										vala_report_error (_tmp543_, _tmp548_);
										_g_free0 (_tmp548_);
										_g_free0 (_tmp546_);
									}
								}
								_tmp549_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp549_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp550_ = dynamic_object_type;
								_tmp551_ = vala_object_type_get_type_symbol (_tmp550_);
								_tmp552_ = _tmp551_;
								_tmp553_ = vala_symbol_get_scope ((ValaSymbol*) _tmp552_);
								_tmp554_ = _tmp553_;
								_tmp555_ = s;
								vala_scope_add (_tmp554_, NULL, (ValaSymbol*) _tmp555_);
								_tmp556_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp556_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp557_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp558_ = _tmp557_;
				if (_tmp558_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp559_;
					ValaExpression* _tmp560_;
					ValaDataType* _tmp561_;
					ValaDataType* _tmp562_;
					const gchar* _tmp563_;
					ValaSourceReference* _tmp564_;
					ValaSourceReference* _tmp565_;
					ValaDynamicProperty* _tmp566_;
					ValaDataType* _tmp567_;
					ValaDataType* _tmp568_;
					ValaDynamicProperty* _tmp579_;
					ValaDynamicProperty* _tmp580_;
					ValaDynamicProperty* _tmp581_;
					ValaDataType* _tmp582_;
					ValaDataType* _tmp583_;
					ValaDataType* _tmp584_;
					ValaDataType* _tmp585_;
					ValaDynamicProperty* _tmp586_;
					ValaSourceReference* _tmp587_;
					ValaSourceReference* _tmp588_;
					ValaPropertyAccessor* _tmp589_;
					ValaPropertyAccessor* _tmp590_;
					ValaDynamicProperty* _tmp591_;
					ValaExpression* _tmp592_;
					ValaExpression* _tmp593_;
					ValaDataType* _tmp594_;
					ValaDataType* _tmp595_;
					ValaTypeSymbol* _tmp596_;
					ValaTypeSymbol* _tmp597_;
					ValaScope* _tmp598_;
					ValaScope* _tmp599_;
					ValaObjectType* _tmp600_;
					ValaObjectTypeSymbol* _tmp601_;
					ValaObjectTypeSymbol* _tmp602_;
					ValaScope* _tmp603_;
					ValaScope* _tmp604_;
					ValaDynamicProperty* _tmp605_;
					ValaDynamicProperty* _tmp606_;
					_tmp559_ = vala_member_access_get_inner (self);
					_tmp560_ = _tmp559_;
					_tmp561_ = vala_expression_get_value_type (_tmp560_);
					_tmp562_ = _tmp561_;
					_tmp563_ = self->priv->_member_name;
					_tmp564_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp565_ = _tmp564_;
					_tmp566_ = vala_dynamic_property_new (_tmp562_, _tmp563_, _tmp565_, NULL);
					prop = _tmp566_;
					_tmp567_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp568_ = _tmp567_;
					if (_tmp568_ != NULL) {
						ValaDynamicProperty* _tmp569_;
						ValaDataType* _tmp570_;
						ValaDataType* _tmp571_;
						_tmp569_ = prop;
						_tmp570_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp571_ = _tmp570_;
						vala_property_set_property_type ((ValaProperty*) _tmp569_, _tmp571_);
					} else {
						ValaDynamicProperty* _tmp572_;
						ValaExpression* _tmp573_;
						ValaExpression* _tmp574_;
						ValaDataType* _tmp575_;
						ValaDataType* _tmp576_;
						ValaDataType* _tmp577_;
						ValaDataType* _tmp578_;
						_tmp572_ = prop;
						_tmp573_ = vala_member_access_get_inner (self);
						_tmp574_ = _tmp573_;
						_tmp575_ = vala_expression_get_value_type (_tmp574_);
						_tmp576_ = _tmp575_;
						_tmp577_ = vala_data_type_copy (_tmp576_);
						_tmp578_ = _tmp577_;
						vala_property_set_property_type ((ValaProperty*) _tmp572_, _tmp578_);
						_vala_code_node_unref0 (_tmp578_);
					}
					_tmp579_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp579_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp580_ = prop;
					_tmp581_ = prop;
					_tmp582_ = vala_property_get_property_type ((ValaProperty*) _tmp581_);
					_tmp583_ = _tmp582_;
					_tmp584_ = vala_data_type_copy (_tmp583_);
					_tmp585_ = _tmp584_;
					_tmp586_ = prop;
					_tmp587_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp586_);
					_tmp588_ = _tmp587_;
					_tmp589_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp585_, NULL, _tmp588_, NULL);
					_tmp590_ = _tmp589_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp580_, _tmp590_);
					_vala_code_node_unref0 (_tmp590_);
					_vala_code_node_unref0 (_tmp585_);
					_tmp591_ = prop;
					_tmp592_ = vala_member_access_get_inner (self);
					_tmp593_ = _tmp592_;
					_tmp594_ = vala_expression_get_value_type (_tmp593_);
					_tmp595_ = _tmp594_;
					_tmp596_ = vala_data_type_get_data_type (_tmp595_);
					_tmp597_ = _tmp596_;
					_tmp598_ = vala_symbol_get_scope ((ValaSymbol*) _tmp597_);
					_tmp599_ = _tmp598_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp591_, _tmp599_);
					_tmp600_ = dynamic_object_type;
					_tmp601_ = vala_object_type_get_type_symbol (_tmp600_);
					_tmp602_ = _tmp601_;
					_tmp603_ = vala_symbol_get_scope ((ValaSymbol*) _tmp602_);
					_tmp604_ = _tmp603_;
					_tmp605_ = prop;
					vala_scope_add (_tmp604_, NULL, (ValaSymbol*) _tmp605_);
					_tmp606_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp606_);
					_vala_code_node_unref0 (prop);
				}
				_tmp607_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp608_ = _tmp607_;
				if (_tmp608_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp610_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp611_ = _tmp610_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp611_)) {
				ValaExpression* _tmp612_;
				ValaExpression* _tmp613_;
				ValaSymbol* _tmp614_;
				ValaSymbol* _tmp615_;
				_tmp612_ = vala_member_access_get_inner (self);
				_tmp613_ = _tmp612_;
				_tmp614_ = vala_expression_get_symbol_reference (_tmp613_);
				_tmp615_ = _tmp614_;
				_tmp609_ = VALA_IS_VARIABLE (_tmp615_);
			} else {
				_tmp609_ = FALSE;
			}
			if (_tmp609_) {
				ValaArrayType* inner_type = NULL;
				ValaSemanticAnalyzer* _tmp616_;
				ValaSemanticAnalyzer* _tmp617_;
				ValaExpression* _tmp618_;
				ValaExpression* _tmp619_;
				ValaSymbol* _tmp620_;
				ValaSymbol* _tmp621_;
				ValaDataType* _tmp622_;
				ValaArrayType* _tmp623_;
				gboolean _tmp624_ = FALSE;
				ValaArrayType* _tmp625_;
				_tmp616_ = vala_code_context_get_analyzer (context);
				_tmp617_ = _tmp616_;
				_tmp618_ = vala_member_access_get_inner (self);
				_tmp619_ = _tmp618_;
				_tmp620_ = vala_expression_get_symbol_reference (_tmp619_);
				_tmp621_ = _tmp620_;
				_tmp622_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp617_, _tmp621_, TRUE);
				_tmp623_ = VALA_IS_ARRAY_TYPE (_tmp622_) ? ((ValaArrayType*) _tmp622_) : NULL;
				if (_tmp623_ == NULL) {
					_vala_code_node_unref0 (_tmp622_);
				}
				inner_type = _tmp623_;
				_tmp625_ = inner_type;
				if (_tmp625_ != NULL) {
					ValaArrayType* _tmp626_;
					gboolean _tmp627_;
					gboolean _tmp628_;
					_tmp626_ = inner_type;
					_tmp627_ = vala_array_type_get_inline_allocated (_tmp626_);
					_tmp628_ = _tmp627_;
					_tmp624_ = _tmp628_;
				} else {
					_tmp624_ = FALSE;
				}
				if (_tmp624_) {
					ValaSourceReference* _tmp629_;
					ValaSourceReference* _tmp630_;
					_tmp629_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp630_ = _tmp629_;
					vala_report_error (_tmp630_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				} else {
					gboolean _tmp631_ = FALSE;
					ValaArrayType* _tmp632_;
					_tmp632_ = inner_type;
					if (_tmp632_ != NULL) {
						ValaArrayType* _tmp633_;
						gboolean _tmp634_;
						gboolean _tmp635_;
						_tmp633_ = inner_type;
						_tmp634_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp633_);
						_tmp635_ = _tmp634_;
						_tmp631_ = !_tmp635_;
					} else {
						_tmp631_ = FALSE;
					}
					if (_tmp631_) {
						ValaSourceReference* _tmp636_;
						ValaSourceReference* _tmp637_;
						_tmp636_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp637_ = _tmp636_;
						vala_report_error (_tmp637_, "`resize' is not allowed for unowned array references");
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					}
				}
				_vala_code_node_unref0 (inner_type);
			}
		}
	}
	_tmp640_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp641_ = _tmp640_;
	if (_tmp641_ == NULL) {
		ValaDataType* _tmp642_;
		ValaDataType* _tmp643_;
		_tmp642_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp643_ = _tmp642_;
		_tmp639_ = _tmp643_ != NULL;
	} else {
		_tmp639_ = FALSE;
	}
	if (_tmp639_) {
		ValaDataType* _tmp644_;
		ValaDataType* _tmp645_;
		ValaTypeSymbol* _tmp646_;
		ValaTypeSymbol* _tmp647_;
		_tmp644_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp645_ = _tmp644_;
		_tmp646_ = vala_data_type_get_data_type (_tmp645_);
		_tmp647_ = _tmp646_;
		_tmp638_ = VALA_IS_ENUM (_tmp647_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp648_;
		ValaDataType* _tmp649_;
		ValaTypeSymbol* _tmp650_;
		ValaTypeSymbol* _tmp651_;
		ValaEnum* _tmp652_;
		_tmp648_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp649_ = _tmp648_;
		_tmp650_ = vala_data_type_get_data_type (_tmp649_);
		_tmp651_ = _tmp650_;
		_tmp652_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp651_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp652_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp653_;
			ValaList* _tmp654_;
			gint _val_size = 0;
			ValaList* _tmp655_;
			gint _tmp656_;
			gint _tmp657_;
			gint _val_index = 0;
			_tmp653_ = enum_type;
			_tmp654_ = vala_enum_get_values (_tmp653_);
			_val_list = _tmp654_;
			_tmp655_ = _val_list;
			_tmp656_ = vala_collection_get_size ((ValaCollection*) _tmp655_);
			_tmp657_ = _tmp656_;
			_val_size = _tmp657_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp658_;
				gint _tmp659_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp660_;
				gint _tmp661_;
				gpointer _tmp662_;
				const gchar* _tmp663_;
				ValaEnumValue* _tmp664_;
				const gchar* _tmp665_;
				const gchar* _tmp666_;
				_val_index = _val_index + 1;
				_tmp658_ = _val_index;
				_tmp659_ = _val_size;
				if (!(_tmp658_ < _tmp659_)) {
					break;
				}
				_tmp660_ = _val_list;
				_tmp661_ = _val_index;
				_tmp662_ = vala_list_get (_tmp660_, _tmp661_);
				val = (ValaEnumValue*) _tmp662_;
				_tmp663_ = self->priv->_member_name;
				_tmp664_ = val;
				_tmp665_ = vala_symbol_get_name ((ValaSymbol*) _tmp664_);
				_tmp666_ = _tmp665_;
				if (g_strcmp0 (_tmp663_, _tmp666_) == 0) {
					ValaEnumValue* _tmp667_;
					_tmp667_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp667_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp668_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp669_ = _tmp668_;
	if (_tmp669_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp670_;
		gboolean _tmp671_ = FALSE;
		ValaExpression* _tmp672_;
		ValaExpression* _tmp673_;
		ValaSourceReference* _tmp686_;
		ValaSourceReference* _tmp687_;
		const gchar* _tmp688_;
		const gchar* _tmp689_;
		gchar* _tmp690_;
		gchar* _tmp691_;
		ValaInvalidType* _tmp692_;
		ValaInvalidType* _tmp693_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp670_ = g_strdup ("(null)");
		base_type_name = _tmp670_;
		_tmp672_ = vala_member_access_get_inner (self);
		_tmp673_ = _tmp672_;
		if (_tmp673_ != NULL) {
			ValaExpression* _tmp674_;
			ValaExpression* _tmp675_;
			ValaDataType* _tmp676_;
			ValaDataType* _tmp677_;
			_tmp674_ = vala_member_access_get_inner (self);
			_tmp675_ = _tmp674_;
			_tmp676_ = vala_expression_get_value_type (_tmp675_);
			_tmp677_ = _tmp676_;
			_tmp671_ = _tmp677_ != NULL;
		} else {
			_tmp671_ = FALSE;
		}
		if (_tmp671_) {
			ValaExpression* _tmp678_;
			ValaExpression* _tmp679_;
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			gchar* _tmp682_;
			_tmp678_ = vala_member_access_get_inner (self);
			_tmp679_ = _tmp678_;
			_tmp680_ = vala_expression_get_value_type (_tmp679_);
			_tmp681_ = _tmp680_;
			_tmp682_ = vala_code_node_to_string ((ValaCodeNode*) _tmp681_);
			_g_free0 (base_type_name);
			base_type_name = _tmp682_;
		} else {
			ValaSymbol* _tmp683_;
			_tmp683_ = base_symbol;
			if (_tmp683_ != NULL) {
				ValaSymbol* _tmp684_;
				gchar* _tmp685_;
				_tmp684_ = base_symbol;
				_tmp685_ = vala_symbol_get_full_name (_tmp684_);
				_g_free0 (base_type_name);
				base_type_name = _tmp685_;
			}
		}
		_tmp686_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp687_ = _tmp686_;
		_tmp688_ = self->priv->_member_name;
		_tmp689_ = base_type_name;
		_tmp690_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp688_, _tmp689_);
		_tmp691_ = _tmp690_;
		vala_report_error (_tmp687_, _tmp691_);
		_g_free0 (_tmp691_);
		_tmp692_ = vala_invalid_type_new ();
		_tmp693_ = _tmp692_;
		vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp693_);
		_vala_code_node_unref0 (_tmp693_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp694_;
		ValaSymbol* _tmp695_;
		gboolean _tmp696_;
		gboolean _tmp697_;
		_tmp694_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp695_ = _tmp694_;
		_tmp696_ = vala_code_node_get_error ((ValaCodeNode*) _tmp695_);
		_tmp697_ = _tmp696_;
		if (_tmp697_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp698_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp699_ = _tmp698_;
	if (VALA_IS_SIGNAL (_tmp699_)) {
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp700_;
		ValaSymbol* _tmp701_;
		ValaCodeNode* ma = NULL;
		ValaCodeNode* parent = NULL;
		ValaCodeNode* _tmp708_;
		ValaCodeNode* _tmp709_;
		ValaCodeNode* _tmp710_;
		gboolean _tmp711_ = FALSE;
		gboolean _tmp712_ = FALSE;
		gboolean _tmp713_ = FALSE;
		ValaCodeNode* _tmp714_;
		_tmp700_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp701_ = _tmp700_;
		sig = G_TYPE_CHECK_INSTANCE_CAST (_tmp701_, VALA_TYPE_SIGNAL, ValaSignal);
		ma = (ValaCodeNode*) self;
		while (TRUE) {
			ValaCodeNode* _tmp702_;
			ValaCodeNode* _tmp703_;
			ValaCodeNode* _tmp704_;
			ValaCodeNode* _tmp705_;
			ValaCodeNode* _tmp706_;
			ValaCodeNode* _tmp707_;
			_tmp702_ = ma;
			_tmp703_ = vala_code_node_get_parent_node (_tmp702_);
			_tmp704_ = _tmp703_;
			if (!VALA_IS_MEMBER_ACCESS (_tmp704_)) {
				break;
			}
			_tmp705_ = ma;
			_tmp706_ = vala_code_node_get_parent_node (_tmp705_);
			_tmp707_ = _tmp706_;
			ma = _tmp707_;
		}
		_tmp708_ = ma;
		_tmp709_ = vala_code_node_get_parent_node (_tmp708_);
		_tmp710_ = _tmp709_;
		parent = _tmp710_;
		_tmp714_ = parent;
		if (_tmp714_ != NULL) {
			ValaCodeNode* _tmp715_;
			_tmp715_ = parent;
			_tmp713_ = !VALA_IS_ELEMENT_ACCESS (_tmp715_);
		} else {
			_tmp713_ = FALSE;
		}
		if (_tmp713_) {
			ValaCodeNode* _tmp716_;
			ValaExpression* _tmp717_;
			ValaExpression* _tmp718_;
			_tmp716_ = ma;
			_tmp717_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp716_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp718_ = _tmp717_;
			_tmp712_ = !VALA_IS_BASE_ACCESS (_tmp718_);
		} else {
			_tmp712_ = FALSE;
		}
		if (_tmp712_) {
			gboolean _tmp719_ = FALSE;
			ValaCodeNode* _tmp720_;
			_tmp720_ = parent;
			if (!VALA_IS_METHOD_CALL (_tmp720_)) {
				_tmp719_ = TRUE;
			} else {
				ValaCodeNode* _tmp721_;
				ValaList* _tmp722_;
				ValaList* _tmp723_;
				_tmp721_ = parent;
				_tmp722_ = vala_method_call_get_argument_list (G_TYPE_CHECK_INSTANCE_CAST (_tmp721_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
				_tmp723_ = _tmp722_;
				_tmp719_ = vala_collection_contains ((ValaCollection*) _tmp723_, (ValaExpression*) self);
				_vala_iterable_unref0 (_tmp723_);
			}
			_tmp711_ = _tmp719_;
		} else {
			_tmp711_ = FALSE;
		}
		if (_tmp711_) {
			ValaSignal* _tmp724_;
			ValaAttribute* _tmp725_;
			ValaAttribute* _tmp726_;
			gboolean _tmp727_;
			_tmp724_ = sig;
			_tmp725_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp724_, "HasEmitter");
			_tmp726_ = _tmp725_;
			_tmp727_ = _tmp726_ != NULL;
			_vala_code_node_unref0 (_tmp726_);
			if (_tmp727_) {
				ValaSignal* _tmp728_;
				ValaSignal* _tmp729_;
				ValaMethod* _tmp730_;
				ValaMethod* _tmp731_;
				_tmp728_ = sig;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp728_, context)) {
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_tmp729_ = sig;
				_tmp730_ = vala_signal_get_emitter (_tmp729_);
				_tmp731_ = _tmp730_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp731_);
			} else {
				ValaSourceReference* _tmp732_;
				ValaSourceReference* _tmp733_;
				ValaSymbol* _tmp734_;
				ValaSymbol* _tmp735_;
				gchar* _tmp736_;
				gchar* _tmp737_;
				gchar* _tmp738_;
				gchar* _tmp739_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp732_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp733_ = _tmp732_;
				_tmp734_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp735_ = _tmp734_;
				_tmp736_ = vala_symbol_get_full_name (_tmp735_);
				_tmp737_ = _tmp736_;
				_tmp738_ = g_strdup_printf ("Signal `%s' requires emitter in this context", _tmp737_);
				_tmp739_ = _tmp738_;
				vala_report_error (_tmp733_, _tmp739_);
				_g_free0 (_tmp739_);
				_g_free0 (_tmp737_);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
		}
	}
	_tmp740_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp741_ = _tmp740_;
	_tmp742_ = _vala_code_node_ref0 (_tmp741_);
	member = _tmp742_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp743_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp743_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp744_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp744_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp745_;
		ValaLocalVariable* _tmp746_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp747_;
		ValaSymbol* _tmp748_;
		ValaSymbol* _tmp749_;
		ValaBlock* _tmp750_;
		gboolean _tmp751_ = FALSE;
		ValaBlock* _tmp752_;
		_tmp745_ = member;
		_tmp746_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp745_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp746_;
		_tmp747_ = local;
		_tmp748_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp747_);
		_tmp749_ = _tmp748_;
		_tmp750_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp749_) ? ((ValaBlock*) _tmp749_) : NULL);
		block = _tmp750_;
		_tmp752_ = block;
		if (_tmp752_ != NULL) {
			ValaSemanticAnalyzer* _tmp753_;
			ValaSemanticAnalyzer* _tmp754_;
			ValaBlock* _tmp755_;
			ValaSymbol* _tmp756_;
			ValaSymbol* _tmp757_;
			ValaSemanticAnalyzer* _tmp758_;
			ValaSemanticAnalyzer* _tmp759_;
			ValaSymbol* _tmp760_;
			ValaSymbol* _tmp761_;
			_tmp753_ = vala_code_context_get_analyzer (context);
			_tmp754_ = _tmp753_;
			_tmp755_ = block;
			_tmp756_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp754_, (ValaSymbol*) _tmp755_);
			_tmp757_ = _tmp756_;
			_tmp758_ = vala_code_context_get_analyzer (context);
			_tmp759_ = _tmp758_;
			_tmp760_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp759_);
			_tmp761_ = _tmp760_;
			_tmp751_ = _tmp757_ != _tmp761_;
			_vala_code_node_unref0 (_tmp757_);
		} else {
			_tmp751_ = FALSE;
		}
		if (_tmp751_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp762_;
			ValaSemanticAnalyzer* _tmp763_;
			ValaSymbol* _tmp764_;
			ValaSymbol* _tmp765_;
			ValaSymbol* _tmp766_;
			ValaLocalVariable* _tmp779_;
			ValaBlock* _tmp780_;
			_tmp762_ = vala_code_context_get_analyzer (context);
			_tmp763_ = _tmp762_;
			_tmp764_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp763_);
			_tmp765_ = _tmp764_;
			_tmp766_ = _vala_code_node_ref0 (_tmp765_);
			sym = _tmp766_;
			while (TRUE) {
				ValaSymbol* _tmp767_;
				ValaBlock* _tmp768_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp769_;
				ValaMethod* _tmp770_;
				ValaMethod* _tmp771_;
				ValaSymbol* _tmp775_;
				ValaSymbol* _tmp776_;
				ValaSymbol* _tmp777_;
				ValaSymbol* _tmp778_;
				_tmp767_ = sym;
				_tmp768_ = block;
				if (!(_tmp767_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp768_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp769_ = sym;
				_tmp770_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp769_) ? ((ValaMethod*) _tmp769_) : NULL);
				method = _tmp770_;
				_tmp771_ = method;
				if (_tmp771_ != NULL) {
					ValaMethod* _tmp772_;
					ValaMethod* _tmp773_;
					ValaLocalVariable* _tmp774_;
					_tmp772_ = method;
					vala_method_set_closure (_tmp772_, TRUE);
					_tmp773_ = method;
					_tmp774_ = local;
					vala_method_add_captured_variable (_tmp773_, _tmp774_);
				}
				_tmp775_ = sym;
				_tmp776_ = vala_symbol_get_parent_symbol (_tmp775_);
				_tmp777_ = _tmp776_;
				_tmp778_ = _vala_code_node_ref0 (_tmp777_);
				_vala_code_node_unref0 (sym);
				sym = _tmp778_;
				_vala_code_node_unref0 (method);
			}
			_tmp779_ = local;
			vala_local_variable_set_captured (_tmp779_, TRUE);
			_tmp780_ = block;
			vala_block_set_captured (_tmp780_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp781_;
		_tmp781_ = member;
		if (VALA_IS_PARAMETER (_tmp781_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp782_;
			ValaParameter* _tmp783_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp784_;
			ValaSymbol* _tmp785_;
			ValaSymbol* _tmp786_;
			ValaMethod* _tmp787_;
			gboolean _tmp788_ = FALSE;
			gboolean _tmp789_ = FALSE;
			ValaMethod* _tmp790_;
			_tmp782_ = member;
			_tmp783_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp782_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp783_;
			_tmp784_ = param;
			_tmp785_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp784_);
			_tmp786_ = _tmp785_;
			_tmp787_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp786_) ? ((ValaMethod*) _tmp786_) : NULL);
			m = _tmp787_;
			_tmp790_ = m;
			if (_tmp790_ != NULL) {
				ValaMethod* _tmp791_;
				ValaSemanticAnalyzer* _tmp792_;
				ValaSemanticAnalyzer* _tmp793_;
				ValaSymbol* _tmp794_;
				ValaSymbol* _tmp795_;
				_tmp791_ = m;
				_tmp792_ = vala_code_context_get_analyzer (context);
				_tmp793_ = _tmp792_;
				_tmp794_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp793_);
				_tmp795_ = _tmp794_;
				_tmp789_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp791_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp795_;
			} else {
				_tmp789_ = FALSE;
			}
			if (_tmp789_) {
				ValaParameter* _tmp796_;
				ValaMethod* _tmp797_;
				ValaParameter* _tmp798_;
				ValaParameter* _tmp799_;
				_tmp796_ = param;
				_tmp797_ = m;
				_tmp798_ = vala_method_get_this_parameter (_tmp797_);
				_tmp799_ = _tmp798_;
				_tmp788_ = _tmp796_ != _tmp799_;
			} else {
				_tmp788_ = FALSE;
			}
			if (_tmp788_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp800_;
				ValaSemanticAnalyzer* _tmp801_;
				ValaSymbol* _tmp802_;
				ValaSymbol* _tmp803_;
				ValaSymbol* _tmp804_;
				ValaParameter* _tmp815_;
				ValaMethod* _tmp816_;
				ValaBlock* _tmp817_;
				ValaBlock* _tmp818_;
				ValaParameter* _tmp819_;
				ValaParameterDirection _tmp820_;
				ValaParameterDirection _tmp821_;
				_tmp800_ = vala_code_context_get_analyzer (context);
				_tmp801_ = _tmp800_;
				_tmp802_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp801_);
				_tmp803_ = _tmp802_;
				_tmp804_ = _vala_code_node_ref0 (_tmp803_);
				sym = _tmp804_;
				while (TRUE) {
					ValaSymbol* _tmp805_;
					ValaMethod* _tmp806_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp807_;
					ValaMethod* _tmp808_;
					ValaMethod* _tmp809_;
					ValaSymbol* _tmp811_;
					ValaSymbol* _tmp812_;
					ValaSymbol* _tmp813_;
					ValaSymbol* _tmp814_;
					_tmp805_ = sym;
					_tmp806_ = m;
					if (!(_tmp805_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp806_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp807_ = sym;
					_tmp808_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp807_) ? ((ValaMethod*) _tmp807_) : NULL);
					method = _tmp808_;
					_tmp809_ = method;
					if (_tmp809_ != NULL) {
						ValaMethod* _tmp810_;
						_tmp810_ = method;
						vala_method_set_closure (_tmp810_, TRUE);
					}
					_tmp811_ = sym;
					_tmp812_ = vala_symbol_get_parent_symbol (_tmp811_);
					_tmp813_ = _tmp812_;
					_tmp814_ = _vala_code_node_ref0 (_tmp813_);
					_vala_code_node_unref0 (sym);
					sym = _tmp814_;
					_vala_code_node_unref0 (method);
				}
				_tmp815_ = param;
				vala_parameter_set_captured (_tmp815_, TRUE);
				_tmp816_ = m;
				_tmp817_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp816_);
				_tmp818_ = _tmp817_;
				vala_block_set_captured (_tmp818_, TRUE);
				_tmp819_ = param;
				_tmp820_ = vala_parameter_get_direction (_tmp819_);
				_tmp821_ = _tmp820_;
				if (_tmp821_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp822_;
					ValaSourceReference* _tmp823_;
					ValaParameter* _tmp824_;
					gchar* _tmp825_;
					gchar* _tmp826_;
					gchar* _tmp827_;
					gchar* _tmp828_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp822_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp823_ = _tmp822_;
					_tmp824_ = param;
					_tmp825_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp824_);
					_tmp826_ = _tmp825_;
					_tmp827_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp826_);
					_tmp828_ = _tmp827_;
					vala_report_error (_tmp823_, _tmp828_);
					_g_free0 (_tmp828_);
					_g_free0 (_tmp826_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp829_;
				ValaSymbol* _tmp830_;
				ValaSymbol* _tmp831_;
				ValaSymbol* _tmp832_;
				ValaSymbol* _tmp833_;
				ValaPropertyAccessor* _tmp834_;
				gboolean _tmp835_ = FALSE;
				gboolean _tmp836_ = FALSE;
				ValaPropertyAccessor* _tmp837_;
				_tmp829_ = param;
				_tmp830_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp829_);
				_tmp831_ = _tmp830_;
				_tmp832_ = vala_symbol_get_parent_symbol (_tmp831_);
				_tmp833_ = _tmp832_;
				_tmp834_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp833_) ? ((ValaPropertyAccessor*) _tmp833_) : NULL);
				acc = _tmp834_;
				_tmp837_ = acc;
				if (_tmp837_ != NULL) {
					ValaPropertyAccessor* _tmp838_;
					ValaSemanticAnalyzer* _tmp839_;
					ValaSemanticAnalyzer* _tmp840_;
					ValaSymbol* _tmp841_;
					ValaSymbol* _tmp842_;
					_tmp838_ = acc;
					_tmp839_ = vala_code_context_get_analyzer (context);
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp840_);
					_tmp842_ = _tmp841_;
					_tmp836_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp838_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp842_;
				} else {
					_tmp836_ = FALSE;
				}
				if (_tmp836_) {
					ValaParameter* _tmp843_;
					ValaPropertyAccessor* _tmp844_;
					ValaProperty* _tmp845_;
					ValaProperty* _tmp846_;
					ValaParameter* _tmp847_;
					ValaParameter* _tmp848_;
					_tmp843_ = param;
					_tmp844_ = acc;
					_tmp845_ = vala_property_accessor_get_prop (_tmp844_);
					_tmp846_ = _tmp845_;
					_tmp847_ = vala_property_get_this_parameter (_tmp846_);
					_tmp848_ = _tmp847_;
					_tmp835_ = _tmp843_ != _tmp848_;
				} else {
					_tmp835_ = FALSE;
				}
				if (_tmp835_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp849_;
					ValaSemanticAnalyzer* _tmp850_;
					ValaSymbol* _tmp851_;
					ValaSymbol* _tmp852_;
					ValaSymbol* _tmp853_;
					ValaParameter* _tmp864_;
					ValaPropertyAccessor* _tmp865_;
					ValaBlock* _tmp866_;
					ValaBlock* _tmp867_;
					_tmp849_ = vala_code_context_get_analyzer (context);
					_tmp850_ = _tmp849_;
					_tmp851_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp850_);
					_tmp852_ = _tmp851_;
					_tmp853_ = _vala_code_node_ref0 (_tmp852_);
					sym = _tmp853_;
					while (TRUE) {
						ValaSymbol* _tmp854_;
						ValaMethod* _tmp855_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp856_;
						ValaMethod* _tmp857_;
						ValaMethod* _tmp858_;
						ValaSymbol* _tmp860_;
						ValaSymbol* _tmp861_;
						ValaSymbol* _tmp862_;
						ValaSymbol* _tmp863_;
						_tmp854_ = sym;
						_tmp855_ = m;
						if (!(_tmp854_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp855_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp856_ = sym;
						_tmp857_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp856_) ? ((ValaMethod*) _tmp856_) : NULL);
						method = _tmp857_;
						_tmp858_ = method;
						if (_tmp858_ != NULL) {
							ValaMethod* _tmp859_;
							_tmp859_ = method;
							vala_method_set_closure (_tmp859_, TRUE);
						}
						_tmp860_ = sym;
						_tmp861_ = vala_symbol_get_parent_symbol (_tmp860_);
						_tmp862_ = _tmp861_;
						_tmp863_ = _vala_code_node_ref0 (_tmp862_);
						_vala_code_node_unref0 (sym);
						sym = _tmp863_;
						_vala_code_node_unref0 (method);
					}
					_tmp864_ = param;
					vala_parameter_set_captured (_tmp864_, TRUE);
					_tmp865_ = acc;
					_tmp866_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp865_);
					_tmp867_ = _tmp866_;
					vala_block_set_captured (_tmp867_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp868_;
			_tmp868_ = member;
			if (VALA_IS_FIELD (_tmp868_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp869_;
				ValaField* _tmp870_;
				ValaField* _tmp871_;
				ValaSymbolAccessibility _tmp872_;
				ValaSymbolAccessibility _tmp873_;
				ValaField* _tmp874_;
				ValaMemberBinding _tmp875_;
				ValaMemberBinding _tmp876_;
				ValaField* _tmp877_;
				ValaMemberBinding _tmp878_;
				ValaMemberBinding _tmp879_;
				ValaField* _tmp880_;
				ValaDataType* _tmp881_;
				ValaDataType* _tmp882_;
				_tmp869_ = member;
				_tmp870_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp869_, VALA_TYPE_FIELD, ValaField));
				f = _tmp870_;
				_tmp871_ = f;
				_tmp872_ = vala_symbol_get_access ((ValaSymbol*) _tmp871_);
				_tmp873_ = _tmp872_;
				access = _tmp873_;
				_tmp874_ = f;
				_tmp875_ = vala_field_get_binding (_tmp874_);
				_tmp876_ = _tmp875_;
				instance = _tmp876_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp877_ = f;
				_tmp878_ = vala_field_get_binding (_tmp877_);
				_tmp879_ = _tmp878_;
				klass = _tmp879_ == VALA_MEMBER_BINDING_CLASS;
				_tmp880_ = f;
				_tmp881_ = vala_variable_get_variable_type ((ValaVariable*) _tmp880_);
				_tmp882_ = _tmp881_;
				if (VALA_IS_GENERIC_TYPE (_tmp882_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp883_;
				_tmp883_ = member;
				if (VALA_IS_CONSTANT (_tmp883_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp884_;
					ValaConstant* _tmp885_;
					ValaConstant* _tmp886_;
					ValaSymbolAccessibility _tmp887_;
					ValaSymbolAccessibility _tmp888_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp889_;
					ValaSymbol* _tmp890_;
					ValaSymbol* _tmp891_;
					ValaBlock* _tmp892_;
					gboolean _tmp893_ = FALSE;
					ValaBlock* _tmp894_;
					_tmp884_ = member;
					_tmp885_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp884_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp885_;
					_tmp886_ = c;
					_tmp887_ = vala_symbol_get_access ((ValaSymbol*) _tmp886_);
					_tmp888_ = _tmp887_;
					access = _tmp888_;
					_tmp889_ = c;
					_tmp890_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp889_);
					_tmp891_ = _tmp890_;
					_tmp892_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp891_) ? ((ValaBlock*) _tmp891_) : NULL);
					block = _tmp892_;
					_tmp894_ = block;
					if (_tmp894_ != NULL) {
						ValaSemanticAnalyzer* _tmp895_;
						ValaSemanticAnalyzer* _tmp896_;
						ValaBlock* _tmp897_;
						ValaSymbol* _tmp898_;
						ValaSymbol* _tmp899_;
						ValaSemanticAnalyzer* _tmp900_;
						ValaSemanticAnalyzer* _tmp901_;
						ValaSymbol* _tmp902_;
						ValaSymbol* _tmp903_;
						_tmp895_ = vala_code_context_get_analyzer (context);
						_tmp896_ = _tmp895_;
						_tmp897_ = block;
						_tmp898_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp896_, (ValaSymbol*) _tmp897_);
						_tmp899_ = _tmp898_;
						_tmp900_ = vala_code_context_get_analyzer (context);
						_tmp901_ = _tmp900_;
						_tmp902_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp901_);
						_tmp903_ = _tmp902_;
						_tmp893_ = _tmp899_ != _tmp903_;
						_vala_code_node_unref0 (_tmp899_);
					} else {
						_tmp893_ = FALSE;
					}
					if (_tmp893_) {
						ValaSourceReference* _tmp904_;
						ValaSourceReference* _tmp905_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp904_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp905_ = _tmp904_;
						vala_report_error (_tmp905_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp906_;
					_tmp906_ = member;
					if (VALA_IS_METHOD (_tmp906_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp907_;
						ValaMethod* _tmp908_;
						ValaMethod* _tmp909_;
						gboolean _tmp910_;
						gboolean _tmp911_;
						ValaMethod* _tmp1014_;
						ValaSymbolAccessibility _tmp1015_;
						ValaSymbolAccessibility _tmp1016_;
						ValaMethod* _tmp1017_;
						ValaMethod* _tmp1021_;
						ValaMemberBinding _tmp1022_;
						ValaMemberBinding _tmp1023_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp1045_;
						ValaDataType* _tmp1046_;
						ValaDataType* _tmp1047_;
						ValaGenericType* _tmp1048_;
						gboolean _tmp1049_ = FALSE;
						ValaGenericType* _tmp1050_;
						_tmp907_ = member;
						_tmp908_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp907_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp908_;
						_tmp909_ = m;
						_tmp910_ = vala_method_get_is_async_callback (_tmp909_);
						_tmp911_ = _tmp910_;
						if (_tmp911_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp912_;
							ValaSemanticAnalyzer* _tmp913_;
							ValaMethod* _tmp914_;
							ValaMethod* _tmp915_;
							ValaMethod* _tmp916_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp917_;
							gboolean _tmp943_;
							ValaMethod* _tmp951_;
							ValaSemanticAnalyzer* _tmp952_;
							ValaSemanticAnalyzer* _tmp953_;
							ValaMethod* _tmp954_;
							ValaMethod* _tmp955_;
							ValaMethod* _tmp974_;
							ValaMethod* _tmp975_;
							ValaMethod* _tmp976_;
							ValaSymbol* _tmp977_;
							ValaSymbol* _tmp978_;
							ValaSymbol* _tmp979_;
							_tmp912_ = vala_code_context_get_analyzer (context);
							_tmp913_ = _tmp912_;
							_tmp914_ = vala_semantic_analyzer_get_current_async_method (_tmp913_);
							_tmp915_ = _tmp914_;
							_tmp916_ = _vala_code_node_ref0 (_tmp915_);
							async_method = _tmp916_;
							is_valid_access = FALSE;
							_tmp917_ = async_method;
							if (_tmp917_ != NULL) {
								ValaMethod* _tmp918_;
								ValaMethod* _tmp919_;
								ValaMethod* _tmp920_;
								ValaMethod* _tmp921_;
								gboolean _tmp922_;
								_tmp918_ = m;
								_tmp919_ = async_method;
								_tmp920_ = vala_method_get_callback_method (_tmp919_);
								_tmp921_ = _tmp920_;
								_tmp922_ = _tmp918_ == _tmp921_;
								_vala_code_node_unref0 (_tmp921_);
								if (_tmp922_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp923_ = FALSE;
									ValaMethod* _tmp924_;
									ValaMethod* _tmp925_;
									ValaMethod* _tmp926_;
									_tmp924_ = async_method;
									_tmp925_ = vala_method_get_base_method (_tmp924_);
									_tmp926_ = _tmp925_;
									if (_tmp926_ != NULL) {
										ValaMethod* _tmp927_;
										ValaMethod* _tmp928_;
										ValaMethod* _tmp929_;
										ValaMethod* _tmp930_;
										ValaMethod* _tmp931_;
										ValaMethod* _tmp932_;
										_tmp927_ = m;
										_tmp928_ = async_method;
										_tmp929_ = vala_method_get_base_method (_tmp928_);
										_tmp930_ = _tmp929_;
										_tmp931_ = vala_method_get_callback_method (_tmp930_);
										_tmp932_ = _tmp931_;
										_tmp923_ = _tmp927_ == _tmp932_;
										_vala_code_node_unref0 (_tmp932_);
									} else {
										_tmp923_ = FALSE;
									}
									if (_tmp923_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp933_ = FALSE;
										ValaMethod* _tmp934_;
										ValaMethod* _tmp935_;
										ValaMethod* _tmp936_;
										_tmp934_ = async_method;
										_tmp935_ = vala_method_get_base_interface_method (_tmp934_);
										_tmp936_ = _tmp935_;
										if (_tmp936_ != NULL) {
											ValaMethod* _tmp937_;
											ValaMethod* _tmp938_;
											ValaMethod* _tmp939_;
											ValaMethod* _tmp940_;
											ValaMethod* _tmp941_;
											ValaMethod* _tmp942_;
											_tmp937_ = m;
											_tmp938_ = async_method;
											_tmp939_ = vala_method_get_base_interface_method (_tmp938_);
											_tmp940_ = _tmp939_;
											_tmp941_ = vala_method_get_callback_method (_tmp940_);
											_tmp942_ = _tmp941_;
											_tmp933_ = _tmp937_ == _tmp942_;
											_vala_code_node_unref0 (_tmp942_);
										} else {
											_tmp933_ = FALSE;
										}
										if (_tmp933_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							_tmp943_ = is_valid_access;
							if (!_tmp943_) {
								ValaSourceReference* _tmp944_;
								ValaSourceReference* _tmp945_;
								ValaMethod* _tmp946_;
								gchar* _tmp947_;
								gchar* _tmp948_;
								gchar* _tmp949_;
								gchar* _tmp950_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp944_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp945_ = _tmp944_;
								_tmp946_ = m;
								_tmp947_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp946_);
								_tmp948_ = _tmp947_;
								_tmp949_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp948_);
								_tmp950_ = _tmp949_;
								vala_report_error (_tmp945_, _tmp950_);
								_g_free0 (_tmp950_);
								_g_free0 (_tmp948_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp951_ = async_method;
							_tmp952_ = vala_code_context_get_analyzer (context);
							_tmp953_ = _tmp952_;
							_tmp954_ = vala_semantic_analyzer_get_current_method (_tmp953_);
							_tmp955_ = _tmp954_;
							if (_tmp951_ != _tmp955_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp956_;
								ValaSemanticAnalyzer* _tmp957_;
								ValaMethod* _tmp958_;
								ValaMethod* _tmp959_;
								ValaSymbol* _tmp960_;
								ValaMethod* _tmp971_;
								ValaBlock* _tmp972_;
								ValaBlock* _tmp973_;
								_tmp956_ = vala_code_context_get_analyzer (context);
								_tmp957_ = _tmp956_;
								_tmp958_ = vala_semantic_analyzer_get_current_method (_tmp957_);
								_tmp959_ = _tmp958_;
								_tmp960_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp959_);
								sym = _tmp960_;
								while (TRUE) {
									ValaSymbol* _tmp961_;
									ValaMethod* _tmp962_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp963_;
									ValaMethod* _tmp964_;
									ValaMethod* _tmp965_;
									ValaSymbol* _tmp967_;
									ValaSymbol* _tmp968_;
									ValaSymbol* _tmp969_;
									ValaSymbol* _tmp970_;
									_tmp961_ = sym;
									_tmp962_ = async_method;
									if (!(_tmp961_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp962_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp963_ = sym;
									_tmp964_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp963_) ? ((ValaMethod*) _tmp963_) : NULL);
									method = _tmp964_;
									_tmp965_ = method;
									if (_tmp965_ != NULL) {
										ValaMethod* _tmp966_;
										_tmp966_ = method;
										vala_method_set_closure (_tmp966_, TRUE);
									}
									_tmp967_ = sym;
									_tmp968_ = vala_symbol_get_parent_symbol (_tmp967_);
									_tmp969_ = _tmp968_;
									_tmp970_ = _vala_code_node_ref0 (_tmp969_);
									_vala_code_node_unref0 (sym);
									sym = _tmp970_;
									_vala_code_node_unref0 (method);
								}
								_tmp971_ = async_method;
								_tmp972_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp971_);
								_tmp973_ = _tmp972_;
								vala_block_set_captured (_tmp973_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp974_ = async_method;
							_tmp975_ = vala_method_get_callback_method (_tmp974_);
							_vala_code_node_unref0 (m);
							m = _tmp975_;
							_tmp976_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp976_);
							_tmp977_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp978_ = _tmp977_;
							_tmp979_ = _vala_code_node_ref0 (_tmp978_);
							_vala_code_node_unref0 (member);
							member = _tmp979_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp980_;
							ValaMethod* _tmp981_;
							ValaMethod* _tmp982_;
							_tmp980_ = m;
							_tmp981_ = vala_method_get_base_method (_tmp980_);
							_tmp982_ = _tmp981_;
							if (_tmp982_ != NULL) {
								ValaMethod* _tmp983_;
								ValaMethod* _tmp984_;
								ValaMethod* _tmp985_;
								ValaMethod* _tmp986_;
								ValaMethod* _tmp987_;
								ValaSignal* _tmp988_;
								ValaSignal* _tmp989_;
								ValaSymbol* _tmp994_;
								ValaSymbol* _tmp995_;
								ValaSymbol* _tmp996_;
								_tmp983_ = m;
								_tmp984_ = vala_method_get_base_method (_tmp983_);
								_tmp985_ = _tmp984_;
								_tmp986_ = _vala_code_node_ref0 (_tmp985_);
								_vala_code_node_unref0 (m);
								m = _tmp986_;
								_tmp987_ = m;
								_tmp988_ = vala_method_get_signal_reference (_tmp987_);
								_tmp989_ = _tmp988_;
								if (_tmp989_ != NULL) {
									ValaMethod* _tmp990_;
									ValaSignal* _tmp991_;
									ValaSignal* _tmp992_;
									_tmp990_ = m;
									_tmp991_ = vala_method_get_signal_reference (_tmp990_);
									_tmp992_ = _tmp991_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp992_);
								} else {
									ValaMethod* _tmp993_;
									_tmp993_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp993_);
								}
								_tmp994_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp995_ = _tmp994_;
								_tmp996_ = _vala_code_node_ref0 (_tmp995_);
								_vala_code_node_unref0 (member);
								member = _tmp996_;
							} else {
								ValaMethod* _tmp997_;
								ValaMethod* _tmp998_;
								ValaMethod* _tmp999_;
								_tmp997_ = m;
								_tmp998_ = vala_method_get_base_interface_method (_tmp997_);
								_tmp999_ = _tmp998_;
								if (_tmp999_ != NULL) {
									ValaMethod* _tmp1000_;
									ValaMethod* _tmp1001_;
									ValaMethod* _tmp1002_;
									ValaMethod* _tmp1003_;
									ValaMethod* _tmp1004_;
									ValaSignal* _tmp1005_;
									ValaSignal* _tmp1006_;
									ValaSymbol* _tmp1011_;
									ValaSymbol* _tmp1012_;
									ValaSymbol* _tmp1013_;
									_tmp1000_ = m;
									_tmp1001_ = vala_method_get_base_interface_method (_tmp1000_);
									_tmp1002_ = _tmp1001_;
									_tmp1003_ = _vala_code_node_ref0 (_tmp1002_);
									_vala_code_node_unref0 (m);
									m = _tmp1003_;
									_tmp1004_ = m;
									_tmp1005_ = vala_method_get_signal_reference (_tmp1004_);
									_tmp1006_ = _tmp1005_;
									if (_tmp1006_ != NULL) {
										ValaMethod* _tmp1007_;
										ValaSignal* _tmp1008_;
										ValaSignal* _tmp1009_;
										_tmp1007_ = m;
										_tmp1008_ = vala_method_get_signal_reference (_tmp1007_);
										_tmp1009_ = _tmp1008_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1009_);
									} else {
										ValaMethod* _tmp1010_;
										_tmp1010_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1010_);
									}
									_tmp1011_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1012_ = _tmp1011_;
									_tmp1013_ = _vala_code_node_ref0 (_tmp1012_);
									_vala_code_node_unref0 (member);
									member = _tmp1013_;
								}
							}
						}
						_tmp1014_ = m;
						_tmp1015_ = vala_symbol_get_access ((ValaSymbol*) _tmp1014_);
						_tmp1016_ = _tmp1015_;
						access = _tmp1016_;
						_tmp1017_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp1017_)) {
							ValaMethod* _tmp1018_;
							ValaMemberBinding _tmp1019_;
							ValaMemberBinding _tmp1020_;
							_tmp1018_ = m;
							_tmp1019_ = vala_method_get_binding (_tmp1018_);
							_tmp1020_ = _tmp1019_;
							instance = _tmp1020_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp1021_ = m;
						_tmp1022_ = vala_method_get_binding (_tmp1021_);
						_tmp1023_ = _tmp1022_;
						klass = _tmp1023_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp1024_;
							ValaList* _tmp1025_;
							gint _param_size = 0;
							ValaList* _tmp1026_;
							gint _tmp1027_;
							gint _tmp1028_;
							gint _param_index = 0;
							_tmp1024_ = m;
							_tmp1025_ = vala_callable_get_parameters ((ValaCallable*) _tmp1024_);
							_param_list = _tmp1025_;
							_tmp1026_ = _param_list;
							_tmp1027_ = vala_collection_get_size ((ValaCollection*) _tmp1026_);
							_tmp1028_ = _tmp1027_;
							_param_size = _tmp1028_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp1029_;
								gint _tmp1030_;
								ValaParameter* param = NULL;
								ValaList* _tmp1031_;
								gint _tmp1032_;
								gpointer _tmp1033_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp1034_;
								ValaDataType* _tmp1035_;
								ValaDataType* _tmp1036_;
								ValaGenericType* _tmp1037_;
								gboolean _tmp1038_ = FALSE;
								ValaGenericType* _tmp1039_;
								_param_index = _param_index + 1;
								_tmp1029_ = _param_index;
								_tmp1030_ = _param_size;
								if (!(_tmp1029_ < _tmp1030_)) {
									break;
								}
								_tmp1031_ = _param_list;
								_tmp1032_ = _param_index;
								_tmp1033_ = vala_list_get (_tmp1031_, _tmp1032_);
								param = (ValaParameter*) _tmp1033_;
								_tmp1034_ = param;
								_tmp1035_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1034_);
								_tmp1036_ = _tmp1035_;
								_tmp1037_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp1036_) ? ((ValaGenericType*) _tmp1036_) : NULL);
								generic_type = _tmp1037_;
								_tmp1039_ = generic_type;
								if (_tmp1039_ != NULL) {
									ValaGenericType* _tmp1040_;
									ValaTypeParameter* _tmp1041_;
									ValaTypeParameter* _tmp1042_;
									ValaSymbol* _tmp1043_;
									ValaSymbol* _tmp1044_;
									_tmp1040_ = generic_type;
									_tmp1041_ = vala_generic_type_get_type_parameter (_tmp1040_);
									_tmp1042_ = _tmp1041_;
									_tmp1043_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1042_);
									_tmp1044_ = _tmp1043_;
									_tmp1038_ = VALA_IS_TYPESYMBOL (_tmp1044_);
								} else {
									_tmp1038_ = FALSE;
								}
								if (_tmp1038_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp1045_ = m;
						_tmp1046_ = vala_callable_get_return_type ((ValaCallable*) _tmp1045_);
						_tmp1047_ = _tmp1046_;
						_tmp1048_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp1047_) ? ((ValaGenericType*) _tmp1047_) : NULL);
						generic_type = _tmp1048_;
						_tmp1050_ = generic_type;
						if (_tmp1050_ != NULL) {
							ValaGenericType* _tmp1051_;
							ValaTypeParameter* _tmp1052_;
							ValaTypeParameter* _tmp1053_;
							ValaSymbol* _tmp1054_;
							ValaSymbol* _tmp1055_;
							_tmp1051_ = generic_type;
							_tmp1052_ = vala_generic_type_get_type_parameter (_tmp1051_);
							_tmp1053_ = _tmp1052_;
							_tmp1054_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1053_);
							_tmp1055_ = _tmp1054_;
							_tmp1049_ = VALA_IS_TYPESYMBOL (_tmp1055_);
						} else {
							_tmp1049_ = FALSE;
						}
						if (_tmp1049_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp1056_;
						_tmp1056_ = member;
						if (VALA_IS_PROPERTY (_tmp1056_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp1057_;
							ValaProperty* _tmp1058_;
							ValaProperty* _tmp1059_;
							ValaProperty* _tmp1060_;
							ValaProperty* _tmp1061_;
							ValaProperty* _tmp1062_;
							ValaProperty* _tmp1082_;
							ValaSymbolAccessibility _tmp1083_;
							ValaSymbolAccessibility _tmp1084_;
							gboolean _tmp1085_;
							gboolean _tmp1086_;
							ValaProperty* _tmp1151_;
							ValaMemberBinding _tmp1152_;
							ValaMemberBinding _tmp1153_;
							ValaProperty* _tmp1154_;
							ValaDataType* _tmp1155_;
							ValaDataType* _tmp1156_;
							_tmp1057_ = member;
							_tmp1058_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1057_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp1058_;
							_tmp1059_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp1059_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp1060_ = prop;
							_tmp1061_ = vala_property_get_base_property (_tmp1060_);
							_tmp1062_ = _tmp1061_;
							if (_tmp1062_ != NULL) {
								ValaProperty* _tmp1063_;
								ValaProperty* _tmp1064_;
								ValaProperty* _tmp1065_;
								ValaProperty* _tmp1066_;
								ValaProperty* _tmp1067_;
								ValaSymbol* _tmp1068_;
								ValaSymbol* _tmp1069_;
								ValaSymbol* _tmp1070_;
								_tmp1063_ = prop;
								_tmp1064_ = vala_property_get_base_property (_tmp1063_);
								_tmp1065_ = _tmp1064_;
								_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
								_vala_code_node_unref0 (prop);
								prop = _tmp1066_;
								_tmp1067_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1067_);
								_tmp1068_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp1069_ = _tmp1068_;
								_tmp1070_ = _vala_code_node_ref0 (_tmp1069_);
								_vala_code_node_unref0 (member);
								member = _tmp1070_;
							} else {
								ValaProperty* _tmp1071_;
								ValaProperty* _tmp1072_;
								ValaProperty* _tmp1073_;
								_tmp1071_ = prop;
								_tmp1072_ = vala_property_get_base_interface_property (_tmp1071_);
								_tmp1073_ = _tmp1072_;
								if (_tmp1073_ != NULL) {
									ValaProperty* _tmp1074_;
									ValaProperty* _tmp1075_;
									ValaProperty* _tmp1076_;
									ValaProperty* _tmp1077_;
									ValaProperty* _tmp1078_;
									ValaSymbol* _tmp1079_;
									ValaSymbol* _tmp1080_;
									ValaSymbol* _tmp1081_;
									_tmp1074_ = prop;
									_tmp1075_ = vala_property_get_base_interface_property (_tmp1074_);
									_tmp1076_ = _tmp1075_;
									_tmp1077_ = _vala_code_node_ref0 (_tmp1076_);
									_vala_code_node_unref0 (prop);
									prop = _tmp1077_;
									_tmp1078_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1078_);
									_tmp1079_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1080_ = _tmp1079_;
									_tmp1081_ = _vala_code_node_ref0 (_tmp1080_);
									_vala_code_node_unref0 (member);
									member = _tmp1081_;
								}
							}
							_tmp1082_ = prop;
							_tmp1083_ = vala_symbol_get_access ((ValaSymbol*) _tmp1082_);
							_tmp1084_ = _tmp1083_;
							access = _tmp1084_;
							_tmp1085_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp1086_ = _tmp1085_;
							if (_tmp1086_) {
								ValaProperty* _tmp1087_;
								ValaPropertyAccessor* _tmp1088_;
								ValaPropertyAccessor* _tmp1089_;
								ValaProperty* _tmp1097_;
								ValaSymbolAccessibility _tmp1098_;
								ValaSymbolAccessibility _tmp1099_;
								_tmp1087_ = prop;
								_tmp1088_ = vala_property_get_set_accessor (_tmp1087_);
								_tmp1089_ = _tmp1088_;
								if (_tmp1089_ == NULL) {
									ValaSourceReference* _tmp1090_;
									ValaSourceReference* _tmp1091_;
									ValaProperty* _tmp1092_;
									gchar* _tmp1093_;
									gchar* _tmp1094_;
									gchar* _tmp1095_;
									gchar* _tmp1096_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1090_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1091_ = _tmp1090_;
									_tmp1092_ = prop;
									_tmp1093_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1092_);
									_tmp1094_ = _tmp1093_;
									_tmp1095_ = g_strdup_printf ("Property `%s' is read-only", _tmp1094_);
									_tmp1096_ = _tmp1095_;
									vala_report_error (_tmp1091_, _tmp1096_);
									_g_free0 (_tmp1096_);
									_g_free0 (_tmp1094_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1097_ = prop;
								_tmp1098_ = vala_symbol_get_access ((ValaSymbol*) _tmp1097_);
								_tmp1099_ = _tmp1098_;
								if (_tmp1099_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1100_;
									ValaPropertyAccessor* _tmp1101_;
									ValaPropertyAccessor* _tmp1102_;
									ValaSymbolAccessibility _tmp1103_;
									ValaSymbolAccessibility _tmp1104_;
									_tmp1100_ = prop;
									_tmp1101_ = vala_property_get_set_accessor (_tmp1100_);
									_tmp1102_ = _tmp1101_;
									_tmp1103_ = vala_symbol_get_access ((ValaSymbol*) _tmp1102_);
									_tmp1104_ = _tmp1103_;
									access = _tmp1104_;
								} else {
									gboolean _tmp1105_ = FALSE;
									ValaProperty* _tmp1106_;
									ValaSymbolAccessibility _tmp1107_;
									ValaSymbolAccessibility _tmp1108_;
									_tmp1106_ = prop;
									_tmp1107_ = vala_symbol_get_access ((ValaSymbol*) _tmp1106_);
									_tmp1108_ = _tmp1107_;
									if (_tmp1108_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1109_;
										ValaPropertyAccessor* _tmp1110_;
										ValaPropertyAccessor* _tmp1111_;
										ValaSymbolAccessibility _tmp1112_;
										ValaSymbolAccessibility _tmp1113_;
										_tmp1109_ = prop;
										_tmp1110_ = vala_property_get_set_accessor (_tmp1109_);
										_tmp1111_ = _tmp1110_;
										_tmp1112_ = vala_symbol_get_access ((ValaSymbol*) _tmp1111_);
										_tmp1113_ = _tmp1112_;
										_tmp1105_ = _tmp1113_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1105_ = FALSE;
									}
									if (_tmp1105_) {
										ValaProperty* _tmp1114_;
										ValaPropertyAccessor* _tmp1115_;
										ValaPropertyAccessor* _tmp1116_;
										ValaSymbolAccessibility _tmp1117_;
										ValaSymbolAccessibility _tmp1118_;
										_tmp1114_ = prop;
										_tmp1115_ = vala_property_get_set_accessor (_tmp1114_);
										_tmp1116_ = _tmp1115_;
										_tmp1117_ = vala_symbol_get_access ((ValaSymbol*) _tmp1116_);
										_tmp1118_ = _tmp1117_;
										access = _tmp1118_;
									}
								}
							} else {
								ValaProperty* _tmp1119_;
								ValaPropertyAccessor* _tmp1120_;
								ValaPropertyAccessor* _tmp1121_;
								ValaProperty* _tmp1129_;
								ValaSymbolAccessibility _tmp1130_;
								ValaSymbolAccessibility _tmp1131_;
								_tmp1119_ = prop;
								_tmp1120_ = vala_property_get_get_accessor (_tmp1119_);
								_tmp1121_ = _tmp1120_;
								if (_tmp1121_ == NULL) {
									ValaSourceReference* _tmp1122_;
									ValaSourceReference* _tmp1123_;
									ValaProperty* _tmp1124_;
									gchar* _tmp1125_;
									gchar* _tmp1126_;
									gchar* _tmp1127_;
									gchar* _tmp1128_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1122_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1123_ = _tmp1122_;
									_tmp1124_ = prop;
									_tmp1125_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1124_);
									_tmp1126_ = _tmp1125_;
									_tmp1127_ = g_strdup_printf ("Property `%s' is write-only", _tmp1126_);
									_tmp1128_ = _tmp1127_;
									vala_report_error (_tmp1123_, _tmp1128_);
									_g_free0 (_tmp1128_);
									_g_free0 (_tmp1126_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1129_ = prop;
								_tmp1130_ = vala_symbol_get_access ((ValaSymbol*) _tmp1129_);
								_tmp1131_ = _tmp1130_;
								if (_tmp1131_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1132_;
									ValaPropertyAccessor* _tmp1133_;
									ValaPropertyAccessor* _tmp1134_;
									ValaSymbolAccessibility _tmp1135_;
									ValaSymbolAccessibility _tmp1136_;
									_tmp1132_ = prop;
									_tmp1133_ = vala_property_get_get_accessor (_tmp1132_);
									_tmp1134_ = _tmp1133_;
									_tmp1135_ = vala_symbol_get_access ((ValaSymbol*) _tmp1134_);
									_tmp1136_ = _tmp1135_;
									access = _tmp1136_;
								} else {
									gboolean _tmp1137_ = FALSE;
									ValaProperty* _tmp1138_;
									ValaSymbolAccessibility _tmp1139_;
									ValaSymbolAccessibility _tmp1140_;
									_tmp1138_ = prop;
									_tmp1139_ = vala_symbol_get_access ((ValaSymbol*) _tmp1138_);
									_tmp1140_ = _tmp1139_;
									if (_tmp1140_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1141_;
										ValaPropertyAccessor* _tmp1142_;
										ValaPropertyAccessor* _tmp1143_;
										ValaSymbolAccessibility _tmp1144_;
										ValaSymbolAccessibility _tmp1145_;
										_tmp1141_ = prop;
										_tmp1142_ = vala_property_get_get_accessor (_tmp1141_);
										_tmp1143_ = _tmp1142_;
										_tmp1144_ = vala_symbol_get_access ((ValaSymbol*) _tmp1143_);
										_tmp1145_ = _tmp1144_;
										_tmp1137_ = _tmp1145_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1137_ = FALSE;
									}
									if (_tmp1137_) {
										ValaProperty* _tmp1146_;
										ValaPropertyAccessor* _tmp1147_;
										ValaPropertyAccessor* _tmp1148_;
										ValaSymbolAccessibility _tmp1149_;
										ValaSymbolAccessibility _tmp1150_;
										_tmp1146_ = prop;
										_tmp1147_ = vala_property_get_get_accessor (_tmp1146_);
										_tmp1148_ = _tmp1147_;
										_tmp1149_ = vala_symbol_get_access ((ValaSymbol*) _tmp1148_);
										_tmp1150_ = _tmp1149_;
										access = _tmp1150_;
									}
								}
							}
							_tmp1151_ = prop;
							_tmp1152_ = vala_property_get_binding (_tmp1151_);
							_tmp1153_ = _tmp1152_;
							instance = _tmp1153_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1154_ = prop;
							_tmp1155_ = vala_property_get_property_type (_tmp1154_);
							_tmp1156_ = _tmp1155_;
							if (VALA_IS_GENERIC_TYPE (_tmp1156_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1157_;
							_tmp1157_ = member;
							if (VALA_IS_SIGNAL (_tmp1157_)) {
								ValaSymbol* _tmp1158_;
								ValaSymbolAccessibility _tmp1159_;
								ValaSymbolAccessibility _tmp1160_;
								instance = TRUE;
								_tmp1158_ = member;
								_tmp1159_ = vala_symbol_get_access (_tmp1158_);
								_tmp1160_ = _tmp1159_;
								access = _tmp1160_;
							} else {
								gboolean _tmp1161_ = FALSE;
								gboolean _tmp1162_;
								_tmp1162_ = self->priv->_creation_member;
								if (!_tmp1162_) {
									ValaSymbol* _tmp1163_;
									_tmp1163_ = member;
									_tmp1161_ = VALA_IS_ERROR_CODE (_tmp1163_);
								} else {
									_tmp1161_ = FALSE;
								}
								if (_tmp1161_) {
									ValaSymbol* _tmp1164_;
									ValaConstant* _tmp1165_;
									ValaConstant* _tmp1166_;
									ValaSymbol* _tmp1167_;
									ValaSymbol* _tmp1168_;
									ValaSymbol* _tmp1169_;
									_tmp1164_ = member;
									_tmp1165_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1164_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1166_ = _tmp1165_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1166_);
									_tmp1167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1168_ = _tmp1167_;
									_tmp1169_ = _vala_code_node_ref0 (_tmp1168_);
									_vala_code_node_unref0 (member);
									member = _tmp1169_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1170_ = member;
	vala_symbol_set_used (_tmp1170_, TRUE);
	_tmp1171_ = member;
	_tmp1172_ = vala_symbol_get_version (_tmp1171_);
	_tmp1173_ = _tmp1172_;
	_tmp1174_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1175_ = _tmp1174_;
	vala_version_attribute_check (_tmp1173_, _tmp1175_);
	_tmp1177_ = access;
	if (_tmp1177_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1178_;
		ValaSymbol* _tmp1179_;
		ValaSymbol* _tmp1180_;
		_tmp1178_ = member;
		_tmp1179_ = vala_symbol_get_parent_symbol (_tmp1178_);
		_tmp1180_ = _tmp1179_;
		_tmp1176_ = VALA_IS_TYPESYMBOL (_tmp1180_);
	} else {
		_tmp1176_ = FALSE;
	}
	if (_tmp1176_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1181_;
		ValaSymbol* _tmp1182_;
		ValaSymbol* _tmp1183_;
		ValaTypeSymbol* _tmp1184_;
		gboolean in_subtype = FALSE;
		gboolean _tmp1204_;
		_tmp1181_ = member;
		_tmp1182_ = vala_symbol_get_parent_symbol (_tmp1181_);
		_tmp1183_ = _tmp1182_;
		_tmp1184_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1183_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1184_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1185_;
			ValaSemanticAnalyzer* _tmp1186_;
			ValaSymbol* _tmp1187_;
			ValaSymbol* _tmp1188_;
			ValaSymbol* _tmp1189_;
			_tmp1185_ = vala_code_context_get_analyzer (context);
			_tmp1186_ = _tmp1185_;
			_tmp1187_ = vala_semantic_analyzer_get_current_symbol (_tmp1186_);
			_tmp1188_ = _tmp1187_;
			_tmp1189_ = _vala_code_node_ref0 (_tmp1188_);
			this_symbol = _tmp1189_;
			{
				gboolean _tmp1190_ = FALSE;
				_tmp1190_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1195_;
					ValaSymbol* _tmp1196_;
					ValaTypeSymbol* _tmp1197_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1198_;
					ValaClass* _tmp1199_;
					gboolean _tmp1200_ = FALSE;
					ValaClass* _tmp1201_;
					if (!_tmp1190_) {
						ValaSymbol* _tmp1191_;
						ValaSymbol* _tmp1192_;
						ValaSymbol* _tmp1193_;
						ValaSymbol* _tmp1194_;
						_tmp1191_ = this_symbol;
						_tmp1192_ = vala_symbol_get_parent_symbol (_tmp1191_);
						_tmp1193_ = _tmp1192_;
						_tmp1194_ = _vala_code_node_ref0 (_tmp1193_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1194_;
					}
					_tmp1190_ = FALSE;
					_tmp1195_ = this_symbol;
					if (!(_tmp1195_ != NULL)) {
						break;
					}
					_tmp1196_ = this_symbol;
					_tmp1197_ = target_type;
					if (_tmp1196_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1197_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1198_ = this_symbol;
					_tmp1199_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1198_) ? ((ValaClass*) _tmp1198_) : NULL);
					cl = _tmp1199_;
					_tmp1201_ = cl;
					if (_tmp1201_ != NULL) {
						ValaClass* _tmp1202_;
						ValaTypeSymbol* _tmp1203_;
						_tmp1202_ = cl;
						_tmp1203_ = target_type;
						_tmp1200_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1202_, _tmp1203_);
					} else {
						_tmp1200_ = FALSE;
					}
					if (_tmp1200_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		_tmp1204_ = in_subtype;
		if (!_tmp1204_) {
			ValaSourceReference* _tmp1205_;
			ValaSourceReference* _tmp1206_;
			ValaSymbol* _tmp1207_;
			gchar* _tmp1208_;
			gchar* _tmp1209_;
			gchar* _tmp1210_;
			gchar* _tmp1211_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1205_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1206_ = _tmp1205_;
			_tmp1207_ = member;
			_tmp1208_ = vala_symbol_get_full_name (_tmp1207_);
			_tmp1209_ = _tmp1208_;
			_tmp1210_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1209_);
			_tmp1211_ = _tmp1210_;
			vala_report_error (_tmp1206_, _tmp1211_);
			_g_free0 (_tmp1211_);
			_g_free0 (_tmp1209_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1212_;
		_tmp1212_ = access;
		if (_tmp1212_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1213_;
			ValaSymbol* _tmp1214_;
			ValaSymbol* _tmp1215_;
			ValaSymbol* _tmp1216_;
			gboolean in_target_type = FALSE;
			gboolean _tmp1230_;
			_tmp1213_ = member;
			_tmp1214_ = vala_symbol_get_parent_symbol (_tmp1213_);
			_tmp1215_ = _tmp1214_;
			_tmp1216_ = _vala_code_node_ref0 (_tmp1215_);
			target_type = _tmp1216_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1217_;
				ValaSemanticAnalyzer* _tmp1218_;
				ValaSymbol* _tmp1219_;
				ValaSymbol* _tmp1220_;
				ValaSymbol* _tmp1221_;
				_tmp1217_ = vala_code_context_get_analyzer (context);
				_tmp1218_ = _tmp1217_;
				_tmp1219_ = vala_semantic_analyzer_get_current_symbol (_tmp1218_);
				_tmp1220_ = _tmp1219_;
				_tmp1221_ = _vala_code_node_ref0 (_tmp1220_);
				this_symbol = _tmp1221_;
				{
					gboolean _tmp1222_ = FALSE;
					_tmp1222_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1227_;
						ValaSymbol* _tmp1228_;
						ValaSymbol* _tmp1229_;
						if (!_tmp1222_) {
							ValaSymbol* _tmp1223_;
							ValaSymbol* _tmp1224_;
							ValaSymbol* _tmp1225_;
							ValaSymbol* _tmp1226_;
							_tmp1223_ = this_symbol;
							_tmp1224_ = vala_symbol_get_parent_symbol (_tmp1223_);
							_tmp1225_ = _tmp1224_;
							_tmp1226_ = _vala_code_node_ref0 (_tmp1225_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1226_;
						}
						_tmp1222_ = FALSE;
						_tmp1227_ = this_symbol;
						if (!(_tmp1227_ != NULL)) {
							break;
						}
						_tmp1228_ = target_type;
						_tmp1229_ = this_symbol;
						if (_tmp1228_ == _tmp1229_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp1230_ = in_target_type;
			if (!_tmp1230_) {
				ValaSourceReference* _tmp1231_;
				ValaSourceReference* _tmp1232_;
				ValaSymbol* _tmp1233_;
				gchar* _tmp1234_;
				gchar* _tmp1235_;
				gchar* _tmp1236_;
				gchar* _tmp1237_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1231_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1232_ = _tmp1231_;
				_tmp1233_ = member;
				_tmp1234_ = vala_symbol_get_full_name (_tmp1233_);
				_tmp1235_ = _tmp1234_;
				_tmp1236_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1235_);
				_tmp1237_ = _tmp1236_;
				vala_report_error (_tmp1232_, _tmp1237_);
				_g_free0 (_tmp1237_);
				_g_free0 (_tmp1235_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	_tmp1239_ = generics;
	if (_tmp1239_) {
		ValaExpression* _tmp1240_;
		ValaExpression* _tmp1241_;
		_tmp1240_ = vala_member_access_get_inner (self);
		_tmp1241_ = _tmp1240_;
		_tmp1238_ = _tmp1241_ != NULL;
	} else {
		_tmp1238_ = FALSE;
	}
	if (_tmp1238_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1242_;
		ValaExpression* _tmp1243_;
		ValaDataType* _tmp1244_;
		ValaDataType* _tmp1245_;
		ValaDataType* _tmp1246_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1247_;
		ValaExpression* _tmp1248_;
		ValaDataType* _tmp1249_;
		ValaDataType* _tmp1250_;
		ValaPointerType* _tmp1251_;
		ValaPointerType* _tmp1252_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1257_;
		ValaObjectType* _tmp1258_;
		gboolean _tmp1259_ = FALSE;
		gboolean _tmp1260_ = FALSE;
		ValaObjectType* _tmp1261_;
		_tmp1242_ = vala_member_access_get_inner (self);
		_tmp1243_ = _tmp1242_;
		_tmp1244_ = vala_expression_get_value_type (_tmp1243_);
		_tmp1245_ = _tmp1244_;
		_tmp1246_ = _vala_code_node_ref0 (_tmp1245_);
		instance_type = _tmp1246_;
		_tmp1247_ = vala_member_access_get_inner (self);
		_tmp1248_ = _tmp1247_;
		_tmp1249_ = vala_expression_get_value_type (_tmp1248_);
		_tmp1250_ = _tmp1249_;
		_tmp1251_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1250_) ? ((ValaPointerType*) _tmp1250_) : NULL);
		pointer_type = _tmp1251_;
		_tmp1252_ = pointer_type;
		if (_tmp1252_ != NULL) {
			ValaPointerType* _tmp1253_;
			ValaDataType* _tmp1254_;
			ValaDataType* _tmp1255_;
			ValaDataType* _tmp1256_;
			_tmp1253_ = pointer_type;
			_tmp1254_ = vala_pointer_type_get_base_type (_tmp1253_);
			_tmp1255_ = _tmp1254_;
			_tmp1256_ = _vala_code_node_ref0 (_tmp1255_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1256_;
		}
		_tmp1257_ = instance_type;
		_tmp1258_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1257_) ? ((ValaObjectType*) _tmp1257_) : NULL);
		object_type = _tmp1258_;
		_tmp1261_ = object_type;
		if (_tmp1261_ != NULL) {
			ValaObjectType* _tmp1262_;
			ValaObjectTypeSymbol* _tmp1263_;
			ValaObjectTypeSymbol* _tmp1264_;
			ValaList* _tmp1265_;
			ValaList* _tmp1266_;
			gint _tmp1267_;
			gint _tmp1268_;
			_tmp1262_ = object_type;
			_tmp1263_ = vala_object_type_get_type_symbol (_tmp1262_);
			_tmp1264_ = _tmp1263_;
			_tmp1265_ = vala_object_type_symbol_get_type_parameters (_tmp1264_);
			_tmp1266_ = _tmp1265_;
			_tmp1267_ = vala_collection_get_size ((ValaCollection*) _tmp1266_);
			_tmp1268_ = _tmp1267_;
			_tmp1260_ = _tmp1268_ > 0;
			_vala_iterable_unref0 (_tmp1266_);
		} else {
			_tmp1260_ = FALSE;
		}
		if (_tmp1260_) {
			ValaDataType* _tmp1269_;
			ValaList* _tmp1270_;
			ValaList* _tmp1271_;
			gint _tmp1272_;
			gint _tmp1273_;
			_tmp1269_ = instance_type;
			_tmp1270_ = vala_data_type_get_type_arguments (_tmp1269_);
			_tmp1271_ = _tmp1270_;
			_tmp1272_ = vala_collection_get_size ((ValaCollection*) _tmp1271_);
			_tmp1273_ = _tmp1272_;
			_tmp1259_ = _tmp1273_ == 0;
			_vala_iterable_unref0 (_tmp1271_);
		} else {
			_tmp1259_ = FALSE;
		}
		if (_tmp1259_) {
			ValaExpression* _tmp1274_;
			ValaExpression* _tmp1275_;
			ValaSourceReference* _tmp1276_;
			ValaSourceReference* _tmp1277_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1274_ = vala_member_access_get_inner (self);
			_tmp1275_ = _tmp1274_;
			_tmp1276_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1275_);
			_tmp1277_ = _tmp1276_;
			vala_report_error (_tmp1277_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	_tmp1280_ = instance;
	if (_tmp1280_) {
		gboolean _tmp1281_;
		_tmp1281_ = may_access_instance_members;
		_tmp1279_ = !_tmp1281_;
	} else {
		_tmp1279_ = FALSE;
	}
	if (_tmp1279_) {
		_tmp1278_ = TRUE;
	} else {
		gboolean _tmp1282_ = FALSE;
		gboolean _tmp1283_;
		_tmp1283_ = klass;
		if (_tmp1283_) {
			gboolean _tmp1284_;
			_tmp1284_ = may_access_klass_members;
			_tmp1282_ = !_tmp1284_;
		} else {
			_tmp1282_ = FALSE;
		}
		_tmp1278_ = _tmp1282_;
	}
	if (_tmp1278_) {
		ValaSymbol* _tmp1285_;
		ValaSymbol* _tmp1286_;
		ValaDataType* _tmp1309_;
		ValaDataType* _tmp1310_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1285_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1286_ = _tmp1285_;
		if (VALA_IS_METHOD (_tmp1286_)) {
			ValaSemanticAnalyzer* _tmp1287_;
			ValaSemanticAnalyzer* _tmp1288_;
			ValaSymbol* _tmp1289_;
			ValaSymbol* _tmp1290_;
			gboolean _tmp1291_;
			gboolean _tmp1292_;
			ValaDataType* _tmp1293_;
			ValaDataType* _tmp1294_;
			_tmp1287_ = vala_code_context_get_analyzer (context);
			_tmp1288_ = _tmp1287_;
			_tmp1289_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1290_ = _tmp1289_;
			_tmp1291_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1292_ = _tmp1291_;
			_tmp1293_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1288_, _tmp1290_, _tmp1292_);
			_tmp1294_ = _tmp1293_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1294_);
			_vala_code_node_unref0 (_tmp1294_);
		} else {
			ValaSymbol* _tmp1295_;
			ValaSymbol* _tmp1296_;
			_tmp1295_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1296_ = _tmp1295_;
			if (VALA_IS_FIELD (_tmp1296_)) {
				ValaSymbol* _tmp1297_;
				ValaSymbol* _tmp1298_;
				ValaFieldPrototype* _tmp1299_;
				ValaFieldPrototype* _tmp1300_;
				_tmp1297_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1298_ = _tmp1297_;
				_tmp1299_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1298_, VALA_TYPE_FIELD, ValaField));
				_tmp1300_ = _tmp1299_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1300_);
				_vala_code_node_unref0 (_tmp1300_);
			} else {
				ValaSymbol* _tmp1301_;
				ValaSymbol* _tmp1302_;
				_tmp1301_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1302_ = _tmp1301_;
				if (VALA_IS_PROPERTY (_tmp1302_)) {
					ValaSymbol* _tmp1303_;
					ValaSymbol* _tmp1304_;
					ValaPropertyPrototype* _tmp1305_;
					ValaPropertyPrototype* _tmp1306_;
					_tmp1303_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1304_ = _tmp1303_;
					_tmp1305_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1304_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1306_ = _tmp1305_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1306_);
					_vala_code_node_unref0 (_tmp1306_);
				} else {
					ValaInvalidType* _tmp1307_;
					ValaInvalidType* _tmp1308_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1307_ = vala_invalid_type_new ();
					_tmp1308_ = _tmp1307_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1308_);
					_vala_code_node_unref0 (_tmp1308_);
				}
			}
		}
		_tmp1309_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1310_ = _tmp1309_;
		if (_tmp1310_ != NULL) {
			ValaDataType* _tmp1311_;
			ValaDataType* _tmp1312_;
			ValaDataType* _tmp1313_;
			ValaDataType* _tmp1314_;
			gboolean _tmp1315_;
			gboolean _tmp1316_;
			_tmp1311_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1312_ = _tmp1311_;
			_tmp1313_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1314_ = _tmp1313_;
			_tmp1315_ = vala_data_type_get_value_owned (_tmp1314_);
			_tmp1316_ = _tmp1315_;
			vala_data_type_set_value_owned (_tmp1312_, _tmp1316_);
		}
	} else {
		gboolean _tmp1317_ = FALSE;
		gboolean _tmp1318_;
		gboolean _tmp1339_ = FALSE;
		gboolean _tmp1340_ = FALSE;
		gboolean _tmp1341_ = FALSE;
		gboolean _tmp1342_ = FALSE;
		gboolean _tmp1343_;
		gboolean _tmp1387_ = FALSE;
		gboolean _tmp1388_ = FALSE;
		gboolean _tmp1389_ = FALSE;
		gboolean _tmp1390_ = FALSE;
		gboolean _tmp1391_ = FALSE;
		gboolean _tmp1392_;
		gboolean _tmp1393_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1421_;
		ValaSymbol* _tmp1422_;
		ValaMethod* _tmp1423_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1424_;
		ValaExpression* _tmp1425_;
		ValaMemberAccess* _tmp1426_;
		gboolean _tmp1427_ = FALSE;
		gboolean _tmp1428_ = FALSE;
		gboolean _tmp1429_ = FALSE;
		gboolean _tmp1430_ = FALSE;
		gboolean _tmp1431_ = FALSE;
		ValaMethod* _tmp1432_;
		ValaSemanticAnalyzer* _tmp1472_;
		ValaSemanticAnalyzer* _tmp1473_;
		ValaSymbol* _tmp1474_;
		ValaSymbol* _tmp1475_;
		gboolean _tmp1476_;
		gboolean _tmp1477_;
		ValaDataType* _tmp1478_;
		ValaDataType* _tmp1479_;
		gboolean _tmp1480_ = FALSE;
		ValaExpression* _tmp1481_;
		ValaExpression* _tmp1482_;
		ValaSymbol* _tmp1495_;
		ValaSymbol* _tmp1496_;
		_tmp1318_ = instance;
		if (_tmp1318_) {
			ValaExpression* _tmp1319_;
			ValaExpression* _tmp1320_;
			_tmp1319_ = vala_member_access_get_inner (self);
			_tmp1320_ = _tmp1319_;
			_tmp1317_ = _tmp1320_ == NULL;
		} else {
			_tmp1317_ = FALSE;
		}
		if (_tmp1317_) {
			ValaSourceReference* _tmp1321_;
			ValaSourceReference* _tmp1322_;
			ValaMemberAccess* _tmp1323_;
			ValaMemberAccess* _tmp1324_;
			ValaExpression* _tmp1325_;
			ValaExpression* _tmp1326_;
			ValaParameter* _tmp1327_;
			ValaDataType* _tmp1328_;
			ValaDataType* _tmp1329_;
			ValaDataType* _tmp1330_;
			ValaDataType* _tmp1331_;
			ValaExpression* _tmp1332_;
			ValaExpression* _tmp1333_;
			ValaDataType* _tmp1334_;
			ValaDataType* _tmp1335_;
			ValaExpression* _tmp1336_;
			ValaExpression* _tmp1337_;
			ValaParameter* _tmp1338_;
			_tmp1321_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1322_ = _tmp1321_;
			_tmp1323_ = vala_member_access_new (NULL, "this", _tmp1322_);
			_tmp1324_ = _tmp1323_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1324_);
			_vala_code_node_unref0 (_tmp1324_);
			_tmp1325_ = vala_member_access_get_inner (self);
			_tmp1326_ = _tmp1325_;
			_tmp1327_ = this_parameter;
			_tmp1328_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1327_);
			_tmp1329_ = _tmp1328_;
			_tmp1330_ = vala_data_type_copy (_tmp1329_);
			_tmp1331_ = _tmp1330_;
			vala_expression_set_value_type (_tmp1326_, _tmp1331_);
			_vala_code_node_unref0 (_tmp1331_);
			_tmp1332_ = vala_member_access_get_inner (self);
			_tmp1333_ = _tmp1332_;
			_tmp1334_ = vala_expression_get_value_type (_tmp1333_);
			_tmp1335_ = _tmp1334_;
			vala_data_type_set_value_owned (_tmp1335_, FALSE);
			_tmp1336_ = vala_member_access_get_inner (self);
			_tmp1337_ = _tmp1336_;
			_tmp1338_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1337_, (ValaSymbol*) _tmp1338_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		_tmp1343_ = instance;
		if (!_tmp1343_) {
			gboolean _tmp1344_;
			_tmp1344_ = klass;
			_tmp1342_ = !_tmp1344_;
		} else {
			_tmp1342_ = FALSE;
		}
		if (_tmp1342_) {
			ValaSymbol* _tmp1345_;
			ValaSymbol* _tmp1346_;
			_tmp1345_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1346_ = _tmp1345_;
			_tmp1341_ = !VALA_IS_CREATION_METHOD (_tmp1346_);
		} else {
			_tmp1341_ = FALSE;
		}
		if (_tmp1341_) {
			gboolean _tmp1347_;
			_tmp1347_ = may_access_instance_members;
			_tmp1340_ = _tmp1347_;
		} else {
			_tmp1340_ = FALSE;
		}
		if (_tmp1340_) {
			ValaExpression* _tmp1348_;
			ValaExpression* _tmp1349_;
			_tmp1348_ = vala_member_access_get_inner (self);
			_tmp1349_ = _tmp1348_;
			_tmp1339_ = _tmp1349_ != NULL;
		} else {
			_tmp1339_ = FALSE;
		}
		if (_tmp1339_) {
			ValaExpression* _tmp1350_;
			ValaExpression* _tmp1351_;
			ValaSymbol* _tmp1352_;
			ValaSymbol* _tmp1353_;
			_tmp1350_ = vala_member_access_get_inner (self);
			_tmp1351_ = _tmp1350_;
			_tmp1352_ = vala_expression_get_symbol_reference (_tmp1351_);
			_tmp1353_ = _tmp1352_;
			if (VALA_IS_METHOD (_tmp1353_)) {
			} else {
				ValaSourceReference* _tmp1354_;
				ValaSourceReference* _tmp1355_;
				ValaSymbol* _tmp1356_;
				ValaSymbol* _tmp1357_;
				gchar* _tmp1358_;
				gchar* _tmp1359_;
				gchar* _tmp1360_;
				gchar* _tmp1361_;
				ValaSymbol* inner_sym = NULL;
				ValaSymbol* _tmp1362_;
				ValaSymbol* _tmp1363_;
				ValaSymbol* _tmp1364_;
				ValaSymbol* _tmp1365_;
				ValaMemberAccess* inner_ma = NULL;
				ValaExpression* _tmp1385_;
				ValaExpression* _tmp1386_;
				_tmp1354_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1355_ = _tmp1354_;
				_tmp1356_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1357_ = _tmp1356_;
				_tmp1358_ = vala_symbol_get_full_name (_tmp1357_);
				_tmp1359_ = _tmp1358_;
				_tmp1360_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1359_);
				_tmp1361_ = _tmp1360_;
				vala_report_warning (_tmp1355_, _tmp1361_);
				_g_free0 (_tmp1361_);
				_g_free0 (_tmp1359_);
				_tmp1362_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1363_ = _tmp1362_;
				_tmp1364_ = vala_symbol_get_parent_symbol (_tmp1363_);
				_tmp1365_ = _tmp1364_;
				inner_sym = _tmp1365_;
				inner_ma = self;
				while (TRUE) {
					gboolean _tmp1366_ = FALSE;
					ValaSymbol* _tmp1367_;
					ValaMemberAccess* _tmp1371_;
					ValaSymbol* _tmp1372_;
					const gchar* _tmp1373_;
					const gchar* _tmp1374_;
					ValaSourceReference* _tmp1375_;
					ValaSourceReference* _tmp1376_;
					ValaMemberAccess* _tmp1377_;
					ValaMemberAccess* _tmp1378_;
					ValaMemberAccess* _tmp1379_;
					ValaExpression* _tmp1380_;
					ValaExpression* _tmp1381_;
					ValaSymbol* _tmp1382_;
					ValaSymbol* _tmp1383_;
					ValaSymbol* _tmp1384_;
					_tmp1367_ = inner_sym;
					if (_tmp1367_ != NULL) {
						ValaSymbol* _tmp1368_;
						const gchar* _tmp1369_;
						const gchar* _tmp1370_;
						_tmp1368_ = inner_sym;
						_tmp1369_ = vala_symbol_get_name (_tmp1368_);
						_tmp1370_ = _tmp1369_;
						_tmp1366_ = _tmp1370_ != NULL;
					} else {
						_tmp1366_ = FALSE;
					}
					if (!_tmp1366_) {
						break;
					}
					_tmp1371_ = inner_ma;
					_tmp1372_ = inner_sym;
					_tmp1373_ = vala_symbol_get_name (_tmp1372_);
					_tmp1374_ = _tmp1373_;
					_tmp1375_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp1376_ = _tmp1375_;
					_tmp1377_ = vala_member_access_new (NULL, _tmp1374_, _tmp1376_);
					_tmp1378_ = _tmp1377_;
					vala_member_access_set_inner (_tmp1371_, (ValaExpression*) _tmp1378_);
					_vala_code_node_unref0 (_tmp1378_);
					_tmp1379_ = inner_ma;
					_tmp1380_ = vala_member_access_get_inner (_tmp1379_);
					_tmp1381_ = _tmp1380_;
					inner_ma = G_TYPE_CHECK_INSTANCE_CAST (_tmp1381_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
					_tmp1382_ = inner_sym;
					_tmp1383_ = vala_symbol_get_parent_symbol (_tmp1382_);
					_tmp1384_ = _tmp1383_;
					inner_sym = _tmp1384_;
				}
				_tmp1385_ = vala_member_access_get_inner (self);
				_tmp1386_ = _tmp1385_;
				vala_code_node_check ((ValaCodeNode*) _tmp1386_, context);
			}
		}
		_tmp1392_ = vala_code_context_get_experimental_non_null (context);
		_tmp1393_ = _tmp1392_;
		if (_tmp1393_) {
			gboolean _tmp1394_;
			_tmp1394_ = instance;
			_tmp1391_ = _tmp1394_;
		} else {
			_tmp1391_ = FALSE;
		}
		if (_tmp1391_) {
			ValaExpression* _tmp1395_;
			ValaExpression* _tmp1396_;
			ValaDataType* _tmp1397_;
			ValaDataType* _tmp1398_;
			gboolean _tmp1399_;
			gboolean _tmp1400_;
			_tmp1395_ = vala_member_access_get_inner (self);
			_tmp1396_ = _tmp1395_;
			_tmp1397_ = vala_expression_get_value_type (_tmp1396_);
			_tmp1398_ = _tmp1397_;
			_tmp1399_ = vala_data_type_get_nullable (_tmp1398_);
			_tmp1400_ = _tmp1399_;
			_tmp1390_ = _tmp1400_;
		} else {
			_tmp1390_ = FALSE;
		}
		if (_tmp1390_) {
			ValaExpression* _tmp1401_;
			ValaExpression* _tmp1402_;
			ValaDataType* _tmp1403_;
			ValaDataType* _tmp1404_;
			_tmp1401_ = vala_member_access_get_inner (self);
			_tmp1402_ = _tmp1401_;
			_tmp1403_ = vala_expression_get_value_type (_tmp1402_);
			_tmp1404_ = _tmp1403_;
			_tmp1389_ = !VALA_IS_POINTER_TYPE (_tmp1404_);
		} else {
			_tmp1389_ = FALSE;
		}
		if (_tmp1389_) {
			ValaExpression* _tmp1405_;
			ValaExpression* _tmp1406_;
			ValaDataType* _tmp1407_;
			ValaDataType* _tmp1408_;
			_tmp1405_ = vala_member_access_get_inner (self);
			_tmp1406_ = _tmp1405_;
			_tmp1407_ = vala_expression_get_value_type (_tmp1406_);
			_tmp1408_ = _tmp1407_;
			_tmp1388_ = !VALA_IS_GENERIC_TYPE (_tmp1408_);
		} else {
			_tmp1388_ = FALSE;
		}
		if (_tmp1388_) {
			ValaExpression* _tmp1409_;
			ValaExpression* _tmp1410_;
			ValaDataType* _tmp1411_;
			ValaDataType* _tmp1412_;
			_tmp1409_ = vala_member_access_get_inner (self);
			_tmp1410_ = _tmp1409_;
			_tmp1411_ = vala_expression_get_value_type (_tmp1410_);
			_tmp1412_ = _tmp1411_;
			_tmp1387_ = !VALA_IS_ARRAY_TYPE (_tmp1412_);
		} else {
			_tmp1387_ = FALSE;
		}
		if (_tmp1387_) {
			ValaSourceReference* _tmp1413_;
			ValaSourceReference* _tmp1414_;
			ValaSymbol* _tmp1415_;
			ValaSymbol* _tmp1416_;
			gchar* _tmp1417_;
			gchar* _tmp1418_;
			gchar* _tmp1419_;
			gchar* _tmp1420_;
			_tmp1413_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1414_ = _tmp1413_;
			_tmp1415_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1416_ = _tmp1415_;
			_tmp1417_ = vala_symbol_get_full_name (_tmp1416_);
			_tmp1418_ = _tmp1417_;
			_tmp1419_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1418_);
			_tmp1420_ = _tmp1419_;
			vala_report_error (_tmp1414_, _tmp1420_);
			_g_free0 (_tmp1420_);
			_g_free0 (_tmp1418_);
		}
		_tmp1421_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1422_ = _tmp1421_;
		_tmp1423_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1422_) ? ((ValaMethod*) _tmp1422_) : NULL);
		m = _tmp1423_;
		_tmp1424_ = vala_member_access_get_inner (self);
		_tmp1425_ = _tmp1424_;
		_tmp1426_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1425_) ? ((ValaMemberAccess*) _tmp1425_) : NULL);
		inner_ma = _tmp1426_;
		_tmp1432_ = m;
		if (_tmp1432_ != NULL) {
			ValaMethod* _tmp1433_;
			ValaMemberBinding _tmp1434_;
			ValaMemberBinding _tmp1435_;
			_tmp1433_ = m;
			_tmp1434_ = vala_method_get_binding (_tmp1433_);
			_tmp1435_ = _tmp1434_;
			_tmp1431_ = _tmp1435_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1431_ = FALSE;
		}
		if (_tmp1431_) {
			ValaMethod* _tmp1436_;
			ValaSymbol* _tmp1437_;
			ValaSymbol* _tmp1438_;
			_tmp1436_ = m;
			_tmp1437_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1436_);
			_tmp1438_ = _tmp1437_;
			_tmp1430_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1438_);
		} else {
			_tmp1430_ = FALSE;
		}
		if (_tmp1430_) {
			ValaExpression* _tmp1439_;
			ValaExpression* _tmp1440_;
			_tmp1439_ = vala_member_access_get_inner (self);
			_tmp1440_ = _tmp1439_;
			_tmp1429_ = _tmp1440_ != NULL;
		} else {
			_tmp1429_ = FALSE;
		}
		if (_tmp1429_) {
			ValaExpression* _tmp1441_;
			ValaExpression* _tmp1442_;
			ValaDataType* _tmp1443_;
			ValaDataType* _tmp1444_;
			_tmp1441_ = vala_member_access_get_inner (self);
			_tmp1442_ = _tmp1441_;
			_tmp1443_ = vala_expression_get_value_type (_tmp1442_);
			_tmp1444_ = _tmp1443_;
			_tmp1428_ = _tmp1444_ == NULL;
		} else {
			_tmp1428_ = FALSE;
		}
		if (_tmp1428_) {
			ValaMemberAccess* _tmp1445_;
			ValaList* _tmp1446_;
			gint _tmp1447_;
			gint _tmp1448_;
			_tmp1445_ = inner_ma;
			_tmp1446_ = _tmp1445_->priv->type_argument_list;
			_tmp1447_ = vala_collection_get_size ((ValaCollection*) _tmp1446_);
			_tmp1448_ = _tmp1447_;
			_tmp1427_ = _tmp1448_ > 0;
		} else {
			_tmp1427_ = FALSE;
		}
		if (_tmp1427_) {
			ValaExpression* _tmp1449_;
			ValaExpression* _tmp1450_;
			ValaMethod* _tmp1451_;
			ValaSymbol* _tmp1452_;
			ValaSymbol* _tmp1453_;
			ValaObjectType* _tmp1454_;
			ValaObjectType* _tmp1455_;
			_tmp1449_ = vala_member_access_get_inner (self);
			_tmp1450_ = _tmp1449_;
			_tmp1451_ = m;
			_tmp1452_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1451_);
			_tmp1453_ = _tmp1452_;
			_tmp1454_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1453_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1455_ = _tmp1454_;
			vala_expression_set_value_type (_tmp1450_, (ValaDataType*) _tmp1455_);
			_vala_code_node_unref0 (_tmp1455_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1456_;
				ValaList* _tmp1457_;
				ValaList* _tmp1458_;
				gint _type_argument_size = 0;
				ValaList* _tmp1459_;
				gint _tmp1460_;
				gint _tmp1461_;
				gint _type_argument_index = 0;
				_tmp1456_ = inner_ma;
				_tmp1457_ = _tmp1456_->priv->type_argument_list;
				_tmp1458_ = _vala_iterable_ref0 (_tmp1457_);
				_type_argument_list = _tmp1458_;
				_tmp1459_ = _type_argument_list;
				_tmp1460_ = vala_collection_get_size ((ValaCollection*) _tmp1459_);
				_tmp1461_ = _tmp1460_;
				_type_argument_size = _tmp1461_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1462_;
					gint _tmp1463_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1464_;
					gint _tmp1465_;
					gpointer _tmp1466_;
					ValaExpression* _tmp1467_;
					ValaExpression* _tmp1468_;
					ValaDataType* _tmp1469_;
					ValaDataType* _tmp1470_;
					ValaDataType* _tmp1471_;
					_type_argument_index = _type_argument_index + 1;
					_tmp1462_ = _type_argument_index;
					_tmp1463_ = _type_argument_size;
					if (!(_tmp1462_ < _tmp1463_)) {
						break;
					}
					_tmp1464_ = _type_argument_list;
					_tmp1465_ = _type_argument_index;
					_tmp1466_ = vala_list_get (_tmp1464_, _tmp1465_);
					type_argument = (ValaDataType*) _tmp1466_;
					_tmp1467_ = vala_member_access_get_inner (self);
					_tmp1468_ = _tmp1467_;
					_tmp1469_ = vala_expression_get_value_type (_tmp1468_);
					_tmp1470_ = _tmp1469_;
					_tmp1471_ = type_argument;
					vala_data_type_add_type_argument (_tmp1470_, _tmp1471_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1472_ = vala_code_context_get_analyzer (context);
		_tmp1473_ = _tmp1472_;
		_tmp1474_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1475_ = _tmp1474_;
		_tmp1476_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1477_ = _tmp1476_;
		_tmp1478_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1473_, _tmp1475_, _tmp1477_);
		_tmp1479_ = _tmp1478_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1479_);
		_vala_code_node_unref0 (_tmp1479_);
		_tmp1481_ = vala_member_access_get_inner (self);
		_tmp1482_ = _tmp1481_;
		if (_tmp1482_ != NULL) {
			ValaDataType* _tmp1483_;
			ValaDataType* _tmp1484_;
			_tmp1483_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1484_ = _tmp1483_;
			_tmp1480_ = _tmp1484_ != NULL;
		} else {
			_tmp1480_ = FALSE;
		}
		if (_tmp1480_) {
			ValaDataType* _tmp1485_;
			ValaDataType* _tmp1486_;
			ValaExpression* _tmp1487_;
			ValaExpression* _tmp1488_;
			ValaDataType* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaDataType* _tmp1491_;
			ValaDataType* _tmp1492_;
			_tmp1485_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1486_ = _tmp1485_;
			_tmp1487_ = vala_member_access_get_inner (self);
			_tmp1488_ = _tmp1487_;
			_tmp1489_ = vala_expression_get_value_type (_tmp1488_);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_data_type_get_actual_type (_tmp1486_, _tmp1490_, NULL, (ValaCodeNode*) self);
			_tmp1492_ = _tmp1491_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1492_);
			_vala_code_node_unref0 (_tmp1492_);
		} else {
			ValaDataType* _tmp1493_;
			ValaDataType* _tmp1494_;
			_tmp1493_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1494_ = _tmp1493_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1494_);
		}
		_tmp1495_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1496_ = _tmp1495_;
		if (VALA_IS_METHOD (_tmp1496_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1497_;
			ValaSymbol* _tmp1498_;
			ValaMethod* _tmp1499_;
			ValaDataType* _tmp1500_;
			ValaDataType* _tmp1501_;
			gboolean _tmp1508_ = FALSE;
			gboolean _tmp1509_;
			_tmp1497_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1498_ = _tmp1497_;
			_tmp1499_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1498_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1499_;
			_tmp1500_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1501_ = _tmp1500_;
			if (_tmp1501_ != NULL) {
				ValaDataType* _tmp1502_;
				ValaDataType* _tmp1503_;
				ValaDataType* _tmp1504_;
				ValaDataType* _tmp1505_;
				gboolean _tmp1506_;
				gboolean _tmp1507_;
				_tmp1502_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1503_ = _tmp1502_;
				_tmp1504_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1505_ = _tmp1504_;
				_tmp1506_ = vala_data_type_get_value_owned (_tmp1505_);
				_tmp1507_ = _tmp1506_;
				vala_data_type_set_value_owned (_tmp1503_, _tmp1507_);
			}
			_tmp1509_ = instance;
			if (_tmp1509_) {
				ValaMethod* _tmp1510_;
				ValaSymbol* _tmp1511_;
				ValaSymbol* _tmp1512_;
				_tmp1510_ = method;
				_tmp1511_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1510_);
				_tmp1512_ = _tmp1511_;
				_tmp1508_ = VALA_IS_TYPESYMBOL (_tmp1512_);
			} else {
				_tmp1508_ = FALSE;
			}
			if (_tmp1508_) {
				ValaExpression* _tmp1513_;
				ValaExpression* _tmp1514_;
				ValaMethod* _tmp1515_;
				ValaSymbol* _tmp1516_;
				ValaSymbol* _tmp1517_;
				ValaDataType* _tmp1518_;
				ValaDataType* _tmp1519_;
				ValaExpression* _tmp1520_;
				ValaExpression* _tmp1521_;
				ValaDataType* _tmp1522_;
				ValaDataType* _tmp1523_;
				ValaMethod* _tmp1524_;
				ValaParameter* _tmp1525_;
				ValaParameter* _tmp1526_;
				ValaDataType* _tmp1527_;
				ValaDataType* _tmp1528_;
				gboolean _tmp1529_;
				gboolean _tmp1530_;
				_tmp1513_ = vala_member_access_get_inner (self);
				_tmp1514_ = _tmp1513_;
				_tmp1515_ = method;
				_tmp1516_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1515_);
				_tmp1517_ = _tmp1516_;
				_tmp1518_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1517_);
				_tmp1519_ = _tmp1518_;
				vala_expression_set_target_type (_tmp1514_, _tmp1519_);
				_vala_code_node_unref0 (_tmp1519_);
				_tmp1520_ = vala_member_access_get_inner (self);
				_tmp1521_ = _tmp1520_;
				_tmp1522_ = vala_expression_get_target_type (_tmp1521_);
				_tmp1523_ = _tmp1522_;
				_tmp1524_ = method;
				_tmp1525_ = vala_method_get_this_parameter (_tmp1524_);
				_tmp1526_ = _tmp1525_;
				_tmp1527_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1526_);
				_tmp1528_ = _tmp1527_;
				_tmp1529_ = vala_data_type_get_value_owned (_tmp1528_);
				_tmp1530_ = _tmp1529_;
				vala_data_type_set_value_owned (_tmp1523_, _tmp1530_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1531_;
			ValaSymbol* _tmp1532_;
			_tmp1531_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1532_ = _tmp1531_;
			if (VALA_IS_PROPERTY (_tmp1532_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1533_;
				ValaSymbol* _tmp1534_;
				ValaProperty* _tmp1535_;
				gboolean _tmp1536_ = FALSE;
				gboolean _tmp1537_;
				_tmp1533_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1534_ = _tmp1533_;
				_tmp1535_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1534_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1535_;
				_tmp1537_ = instance;
				if (_tmp1537_) {
					ValaProperty* _tmp1538_;
					ValaSymbol* _tmp1539_;
					ValaSymbol* _tmp1540_;
					_tmp1538_ = prop;
					_tmp1539_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1538_);
					_tmp1540_ = _tmp1539_;
					_tmp1536_ = _tmp1540_ != NULL;
				} else {
					_tmp1536_ = FALSE;
				}
				if (_tmp1536_) {
					ValaExpression* _tmp1541_;
					ValaExpression* _tmp1542_;
					ValaProperty* _tmp1543_;
					ValaSymbol* _tmp1544_;
					ValaSymbol* _tmp1545_;
					ValaDataType* _tmp1546_;
					ValaDataType* _tmp1547_;
					_tmp1541_ = vala_member_access_get_inner (self);
					_tmp1542_ = _tmp1541_;
					_tmp1543_ = prop;
					_tmp1544_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1543_);
					_tmp1545_ = _tmp1544_;
					_tmp1546_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1545_);
					_tmp1547_ = _tmp1546_;
					vala_expression_set_target_type (_tmp1542_, _tmp1547_);
					_vala_code_node_unref0 (_tmp1547_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1548_ = FALSE;
				gboolean _tmp1549_ = FALSE;
				gboolean _tmp1550_ = FALSE;
				ValaSymbol* _tmp1551_;
				ValaSymbol* _tmp1552_;
				_tmp1551_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1552_ = _tmp1551_;
				if (VALA_IS_FIELD (_tmp1552_)) {
					_tmp1550_ = TRUE;
				} else {
					ValaSymbol* _tmp1553_;
					ValaSymbol* _tmp1554_;
					_tmp1553_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1554_ = _tmp1553_;
					_tmp1550_ = VALA_IS_SIGNAL (_tmp1554_);
				}
				if (_tmp1550_) {
					gboolean _tmp1555_;
					_tmp1555_ = instance;
					_tmp1549_ = _tmp1555_;
				} else {
					_tmp1549_ = FALSE;
				}
				if (_tmp1549_) {
					ValaSymbol* _tmp1556_;
					ValaSymbol* _tmp1557_;
					ValaSymbol* _tmp1558_;
					ValaSymbol* _tmp1559_;
					_tmp1556_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1557_ = _tmp1556_;
					_tmp1558_ = vala_symbol_get_parent_symbol (_tmp1557_);
					_tmp1559_ = _tmp1558_;
					_tmp1548_ = _tmp1559_ != NULL;
				} else {
					_tmp1548_ = FALSE;
				}
				if (_tmp1548_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1560_;
					ValaSymbol* _tmp1561_;
					ValaSymbol* _tmp1562_;
					ValaSymbol* _tmp1563_;
					ValaDataType* _tmp1564_;
					ValaExpression* _tmp1565_;
					ValaExpression* _tmp1566_;
					ValaDataType* _tmp1567_;
					ValaExpression* _tmp1568_;
					ValaExpression* _tmp1569_;
					ValaDataType* _tmp1570_;
					ValaDataType* _tmp1571_;
					ValaDataType* _tmp1572_;
					ValaDataType* _tmp1573_;
					_tmp1560_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1561_ = _tmp1560_;
					_tmp1562_ = vala_symbol_get_parent_symbol (_tmp1561_);
					_tmp1563_ = _tmp1562_;
					_tmp1564_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1563_);
					parent_type = _tmp1564_;
					_tmp1565_ = vala_member_access_get_inner (self);
					_tmp1566_ = _tmp1565_;
					_tmp1567_ = parent_type;
					_tmp1568_ = vala_member_access_get_inner (self);
					_tmp1569_ = _tmp1568_;
					_tmp1570_ = vala_expression_get_value_type (_tmp1569_);
					_tmp1571_ = _tmp1570_;
					_tmp1572_ = vala_data_type_get_actual_type (_tmp1567_, _tmp1571_, NULL, (ValaCodeNode*) self);
					_tmp1573_ = _tmp1572_;
					vala_expression_set_target_type (_tmp1566_, _tmp1573_);
					_vala_code_node_unref0 (_tmp1573_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1574_ = self->priv->_tainted_access;
	if (!_tmp1574_) {
		vala_member_access_set_tainted_access (self, vala_member_access_is_tainted (self));
	}
	_tmp1575_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1576_ = _tmp1575_;
	result = !_tmp1576_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}


static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}


void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_ = FALSE;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	gboolean this_access = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaMemberAccess* _tmp57_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	_tmp9_ = instance;
	if (!_tmp9_) {
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_METHOD (_tmp12_)) {
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_tmp13_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_METHOD, ValaMethod));
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp10_ = FALSE;
		}
		instance = _tmp10_;
	}
	_tmp17_ = instance;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp20_ = _tmp19_;
		if (VALA_IS_PROPERTY (_tmp20_)) {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp18_ = FALSE;
		}
		instance = _tmp18_;
	}
	_tmp26_ = vala_member_access_get_inner (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_expression_get_symbol_reference (_tmp27_);
	_tmp29_ = _tmp28_;
	if (VALA_IS_PARAMETER (_tmp29_)) {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp25_ = g_strcmp0 (_tmp35_, "this") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	this_access = _tmp25_;
	_tmp38_ = vala_member_access_get_inner (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp41_)) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp42_ = vala_member_access_get_inner (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_expression_get_value_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_data_type_get_nullable (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp37_ = !_tmp47_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_member_access_get_inner (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_expression_get_value_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp36_ = VALA_IS_ARRAY_TYPE (_tmp51_);
	}
	struct_or_array = _tmp36_;
	_tmp52_ = vala_member_access_get_inner (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp53_) ? ((ValaMemberAccess*) _tmp53_) : NULL);
	ma = _tmp54_;
	_tmp57_ = ma;
	if (_tmp57_ == NULL) {
		gboolean _tmp58_;
		_tmp58_ = struct_or_array;
		_tmp56_ = _tmp58_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_member_access_get_inner (self);
		_tmp60_ = _tmp59_;
		_tmp55_ = VALA_IS_POINTER_INDIRECTION (_tmp60_);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaMemberAccess* _tmp65_;
		_tmp61_ = vala_member_access_get_inner (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp64_) ? ((ValaMemberAccess*) _tmp64_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
	}
	_tmp70_ = instance;
	if (_tmp70_) {
		gboolean _tmp71_;
		_tmp71_ = struct_or_array;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gboolean _tmp72_ = FALSE;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		_tmp73_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (VALA_IS_METHOD (_tmp74_)) {
			_tmp72_ = TRUE;
		} else {
			gboolean _tmp75_;
			gboolean _tmp76_;
			_tmp75_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp72_ = _tmp76_;
		}
		_tmp68_ = _tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaMemberAccess* _tmp79_;
		_tmp79_ = ma;
		if (_tmp79_ != NULL) {
			ValaMemberAccess* _tmp80_;
			ValaSymbol* _tmp81_;
			ValaSymbol* _tmp82_;
			_tmp80_ = ma;
			_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = VALA_IS_VARIABLE (_tmp82_);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			_tmp83_ = vala_member_access_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp77_ = VALA_IS_ELEMENT_ACCESS (_tmp84_);
		}
		_tmp67_ = _tmp77_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gboolean _tmp85_;
		_tmp85_ = this_access;
		_tmp66_ = !_tmp85_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		ValaAttribute* _tmp97_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ != NULL;
		_vala_code_node_unref0 (_tmp97_);
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaClass* _tmp104_;
		_tmp98_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_METHOD, ValaMethod));
		_tmp101_ = _tmp100_;
		cl = VALA_IS_CLASS (_tmp101_) ? ((ValaClass*) _tmp101_) : NULL;
		_tmp104_ = cl;
		if (_tmp104_ != NULL) {
			ValaClass* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = cl;
			_tmp106_ = vala_class_get_is_compact (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp108_;
			_tmp108_ = ma;
			_tmp102_ = _tmp108_ != NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp109_;
			ValaMemberAccess* _tmp110_;
			_tmp109_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp109_, TRUE);
			_tmp110_ = ma;
			vala_member_access_check_lvalue_access (_tmp110_);
		}
	}
	_vala_code_node_unref0 (ma);
}


static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}


static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		ValaMemberAccess* self;
		self = _data1_->self;
		_vala_code_node_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static ValaTraverseStatus
__lambda4_ (Block1Data* _data1_,
            ValaCodeNode* n)
{
	ValaMemberAccess* self;
	ValaTraverseStatus result = 0;
	self = _data1_->self;
	g_return_val_if_fail (n != NULL, 0);
	if (VALA_IS_POSTFIX_EXPRESSION (n)) {
		_data1_->found = TRUE;
		result = VALA_TRAVERSE_STATUS_STOP;
		return result;
	} else {
		if (VALA_IS_UNARY_EXPRESSION (n)) {
			ValaUnaryExpression* e = NULL;
			gboolean _tmp0_ = FALSE;
			ValaUnaryExpression* _tmp1_;
			ValaUnaryOperator _tmp2_;
			ValaUnaryOperator _tmp3_;
			e = G_TYPE_CHECK_INSTANCE_CAST (n, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
			_tmp1_ = e;
			_tmp2_ = vala_unary_expression_get_operator (_tmp1_);
			_tmp3_ = _tmp2_;
			if (_tmp3_ == VALA_UNARY_OPERATOR_INCREMENT) {
				_tmp0_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp4_;
				ValaUnaryOperator _tmp5_;
				ValaUnaryOperator _tmp6_;
				_tmp4_ = e;
				_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp0_ = _tmp6_ == VALA_UNARY_OPERATOR_DECREMENT;
			}
			if (_tmp0_) {
				_data1_->found = TRUE;
				result = VALA_TRAVERSE_STATUS_STOP;
				return result;
			}
		}
	}
	result = VALA_TRAVERSE_STATUS_CONTINUE;
	return result;
}


static ValaTraverseStatus
___lambda4__vala_traverse_func (ValaCodeNode* node,
                                gpointer self)
{
	ValaTraverseStatus result;
	result = __lambda4_ (self, node);
	return result;
}


static gboolean
vala_member_access_is_tainted (ValaMemberAccess* self)
{
	gboolean result = FALSE;
	Block1Data* _data1_;
	ValaCodeNode* node = NULL;
	ValaCodeNode* _tmp0_;
	ValaCodeNode* _tmp1_;
	ValaCodeNode* _tmp2_;
	ValaTraverseVisitor* traverse = NULL;
	ValaTraverseVisitor* _tmp14_;
	ValaCodeNode* _tmp15_;
	ValaTraverseVisitor* _tmp16_;
	gboolean _tmp17_;
	g_return_val_if_fail (self != NULL, FALSE);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = vala_code_node_ref (self);
	node = (ValaCodeNode*) self;
	_tmp0_ = node;
	_tmp1_ = vala_code_node_get_parent_node (_tmp0_);
	_tmp2_ = _tmp1_;
	if (VALA_IS_MEMBER_ACCESS (_tmp2_)) {
		result = FALSE;
		block1_data_unref (_data1_);
		_data1_ = NULL;
		return result;
	}
	while (TRUE) {
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaCodeNode* _tmp5_;
		ValaCodeNode* _tmp6_;
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		ValaCodeNode* _tmp11_;
		_tmp3_ = node;
		_tmp4_ = vala_code_node_get_parent_node (_tmp3_);
		_tmp5_ = _tmp4_;
		if (!VALA_IS_EXPRESSION (_tmp5_)) {
			break;
		}
		_tmp6_ = node;
		_tmp7_ = vala_code_node_get_parent_node (_tmp6_);
		_tmp8_ = _tmp7_;
		node = _tmp8_;
		_tmp11_ = node;
		if (VALA_IS_ASSIGNMENT (_tmp11_)) {
			_tmp10_ = TRUE;
		} else {
			ValaCodeNode* _tmp12_;
			_tmp12_ = node;
			_tmp10_ = VALA_IS_METHOD_CALL (_tmp12_);
		}
		if (_tmp10_) {
			_tmp9_ = TRUE;
		} else {
			ValaCodeNode* _tmp13_;
			_tmp13_ = node;
			_tmp9_ = VALA_IS_OBJECT_CREATION_EXPRESSION (_tmp13_);
		}
		if (_tmp9_) {
			break;
		}
	}
	_data1_->found = FALSE;
	_tmp14_ = vala_traverse_visitor_new (___lambda4__vala_traverse_func, block1_data_ref (_data1_), block1_data_unref);
	traverse = _tmp14_;
	_tmp15_ = node;
	_tmp16_ = traverse;
	vala_code_node_accept (_tmp15_, (ValaCodeVisitor*) _tmp16_);
	_tmp17_ = _data1_->found;
	result = _tmp17_;
	_vala_code_visitor_unref0 (traverse);
	block1_data_unref (_data1_);
	_data1_ = NULL;
	return result;
}


ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pointer_member_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_prototype_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean
vala_member_access_get_tainted_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_tainted_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_tainted_access (ValaMemberAccess* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_tainted_access = value;
}


gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_creation_member;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_qualified;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}


static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}


static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}



