/* valainitializerlist.c generated by valac, the Vala compiler
 * generated from valainitializerlist.vala, do not modify */

/* valainitializerlist.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaInitializerListPrivate {
	ValaList* initializers;
};


static gpointer vala_initializer_list_parent_class = NULL;

#define VALA_INITIALIZER_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INITIALIZER_LIST, ValaInitializerListPrivate))
static void vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_initializer_list_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static gboolean vala_initializer_list_real_is_constant (ValaExpression* base);
static gboolean vala_initializer_list_real_is_pure (ValaExpression* base);
static gboolean vala_initializer_list_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gchar* vala_initializer_list_real_to_string (ValaCodeNode* base);
static void vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static gboolean vala_initializer_list_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_initializer_list_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_initializer_list_finalize (ValaCodeNode * obj);


/**
 * Appends the specified expression to this initializer 
 *
 * @param expr an expression
 */
void
vala_initializer_list_append (ValaInitializerList* self,
                              ValaExpression* expr)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (expr != NULL);
	_tmp0_ = self->priv->initializers;
	vala_collection_add ((ValaCollection*) _tmp0_, expr);
	vala_code_node_set_parent_node ((ValaCodeNode*) expr, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the expression 
 *
 * @return expression list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_initializer_list_get_initializers (ValaInitializerList* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Creates a new initializer 
 *
 * @param source_reference reference to source code
 * @return                 newly created initializer list
 */
ValaInitializerList*
vala_initializer_list_construct (GType object_type,
                                 ValaSourceReference* source_reference)
{
	ValaInitializerList* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaInitializerList*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaInitializerList*
vala_initializer_list_new (ValaSourceReference* source_reference)
{
	return vala_initializer_list_construct (VALA_TYPE_INITIALIZER_LIST, source_reference);
}


static void
vala_initializer_list_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp5_ = _expr_index;
			_tmp6_ = _expr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = _expr_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_initializer_list_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_initializer_list (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static gboolean
vala_initializer_list_real_is_constant (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_initializer_index = _initializer_index + 1;
			_tmp5_ = _initializer_index;
			_tmp6_ = _initializer_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _initializer_list;
			_tmp8_ = _initializer_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			initializer = (ValaExpression*) _tmp9_;
			_tmp10_ = initializer;
			if (!vala_expression_is_constant (_tmp10_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_initializer_list_real_is_pure (ValaExpression* base)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_initializer_index = _initializer_index + 1;
			_tmp5_ = _initializer_index;
			_tmp6_ = _initializer_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _initializer_list;
			_tmp8_ = _initializer_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			initializer = (ValaExpression*) _tmp9_;
			_tmp10_ = initializer;
			if (!vala_expression_is_pure (_tmp10_)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_initializer_list_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _initializer_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _initializer_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_initializer_list = _tmp1_;
		_tmp2_ = _initializer_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_initializer_size = _tmp4_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_initializer_index = _initializer_index + 1;
			_tmp5_ = _initializer_index;
			_tmp6_ = _initializer_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _initializer_list;
			_tmp8_ = _initializer_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			initializer = (ValaExpression*) _tmp9_;
			_tmp10_ = initializer;
			if (!vala_expression_is_accessible (_tmp10_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (initializer);
				_vala_iterable_unref0 (_initializer_list);
				return result;
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	result = TRUE;
	return result;
}


static gchar*
vala_initializer_list_real_to_string (ValaCodeNode* base)
{
	ValaInitializerList * self;
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_;
	gboolean first = FALSE;
	GString* _tmp20_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	self = (ValaInitializerList*) base;
	_tmp0_ = g_string_new ("{");
	builder = _tmp0_;
	first = TRUE;
	{
		ValaList* _initializer_list = NULL;
		ValaList* _tmp1_;
		ValaList* _tmp2_;
		gint _initializer_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _initializer_index = 0;
		_tmp1_ = self->priv->initializers;
		_tmp2_ = _vala_iterable_ref0 (_tmp1_);
		_initializer_list = _tmp2_;
		_tmp3_ = _initializer_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_initializer_size = _tmp5_;
		_initializer_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* initializer = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_;
			_initializer_index = _initializer_index + 1;
			_tmp6_ = _initializer_index;
			_tmp7_ = _initializer_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _initializer_list;
			_tmp9_ = _initializer_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			initializer = (ValaExpression*) _tmp10_;
			_tmp11_ = first;
			if (_tmp11_) {
				GString* _tmp12_;
				ValaExpression* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp12_ = builder;
				_tmp13_ = initializer;
				_tmp14_ = vala_code_node_to_string ((ValaCodeNode*) _tmp13_);
				_tmp15_ = _tmp14_;
				g_string_append (_tmp12_, _tmp15_);
				_g_free0 (_tmp15_);
				first = FALSE;
			} else {
				GString* _tmp16_;
				ValaExpression* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp16_ = builder;
				_tmp17_ = initializer;
				_tmp18_ = vala_code_node_to_string ((ValaCodeNode*) _tmp17_);
				_tmp19_ = _tmp18_;
				g_string_append_printf (_tmp16_, ", %s", _tmp19_);
				_g_free0 (_tmp19_);
			}
			_vala_code_node_unref0 (initializer);
		}
		_vala_iterable_unref0 (_initializer_list);
	}
	_tmp20_ = builder;
	g_string_append_c (_tmp20_, '}');
	_tmp21_ = builder;
	_tmp22_ = _tmp21_->str;
	_tmp23_ = g_strdup (_tmp22_);
	result = _tmp23_;
	_g_string_free0 (builder);
	return result;
}


static void
vala_initializer_list_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaExpression* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->initializers;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->initializers;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaExpression*) _tmp8_;
				_tmp10_ = _tmp9_ == old_node;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->initializers;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_node);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_initializer_list_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaInitializerList * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean _tmp233_;
	gboolean _tmp234_;
	gboolean _tmp283_;
	gboolean _tmp284_;
	gboolean _tmp291_;
	gboolean _tmp292_;
	self = (ValaInitializerList*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == NULL) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "initializer list used for unknown type");
		result = FALSE;
		return result;
	} else {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp8_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_code_node_get_error ((ValaCodeNode*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (_tmp11_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		} else {
			ValaDataType* _tmp12_;
			ValaDataType* _tmp13_;
			_tmp12_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp13_ = _tmp12_;
			if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
				ValaArrayType* array_type = NULL;
				ValaDataType* _tmp14_;
				ValaDataType* _tmp15_;
				ValaArrayType* _tmp16_;
				gboolean requires_constants_only = FALSE;
				ValaCodeNode* node = NULL;
				ValaCodeNode* _tmp17_;
				ValaCodeNode* _tmp18_;
				gboolean _tmp24_ = FALSE;
				gboolean _tmp25_ = FALSE;
				ValaCodeNode* _tmp26_;
				ValaCodeNode* _tmp27_;
				ValaDataType* inner_target_type = NULL;
				ValaArrayType* _tmp62_;
				gint _tmp63_;
				gint _tmp64_;
				_tmp14_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp15_ = _tmp14_;
				_tmp16_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp16_;
				requires_constants_only = FALSE;
				_tmp17_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				node = _tmp18_;
				while (TRUE) {
					ValaCodeNode* _tmp19_;
					ValaCodeNode* _tmp20_;
					ValaCodeNode* _tmp21_;
					ValaCodeNode* _tmp22_;
					ValaCodeNode* _tmp23_;
					_tmp19_ = node;
					if (!(_tmp19_ != NULL)) {
						break;
					}
					_tmp20_ = node;
					if (VALA_IS_CONSTANT (_tmp20_)) {
						requires_constants_only = TRUE;
						break;
					}
					_tmp21_ = node;
					_tmp22_ = vala_code_node_get_parent_node (_tmp21_);
					_tmp23_ = _tmp22_;
					node = _tmp23_;
				}
				_tmp26_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp27_ = _tmp26_;
				if (!VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp27_)) {
					gboolean _tmp28_;
					_tmp28_ = requires_constants_only;
					_tmp25_ = !_tmp28_;
				} else {
					_tmp25_ = FALSE;
				}
				if (_tmp25_) {
					gboolean _tmp29_ = FALSE;
					ValaCodeNode* _tmp30_;
					ValaCodeNode* _tmp31_;
					_tmp30_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp31_ = _tmp30_;
					if (!VALA_IS_INITIALIZER_LIST (_tmp31_)) {
						_tmp29_ = TRUE;
					} else {
						ValaCodeNode* _tmp32_;
						ValaCodeNode* _tmp33_;
						ValaDataType* _tmp34_;
						ValaDataType* _tmp35_;
						ValaTypeSymbol* _tmp36_;
						ValaTypeSymbol* _tmp37_;
						_tmp32_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp33_ = _tmp32_;
						_tmp34_ = vala_expression_get_target_type ((ValaExpression*) G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
						_tmp35_ = _tmp34_;
						_tmp36_ = vala_data_type_get_data_type (_tmp35_);
						_tmp37_ = _tmp36_;
						_tmp29_ = VALA_IS_STRUCT (_tmp37_);
					}
					_tmp24_ = _tmp29_;
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					ValaCodeNode* old_parent_node = NULL;
					ValaCodeNode* _tmp38_;
					ValaCodeNode* _tmp39_;
					ValaCodeNode* _tmp40_;
					ValaArrayCreationExpression* array_creation = NULL;
					ValaArrayType* _tmp41_;
					ValaDataType* _tmp42_;
					ValaDataType* _tmp43_;
					ValaDataType* _tmp44_;
					ValaDataType* _tmp45_;
					ValaArrayType* _tmp46_;
					gint _tmp47_;
					gint _tmp48_;
					ValaSourceReference* _tmp49_;
					ValaSourceReference* _tmp50_;
					ValaArrayCreationExpression* _tmp51_;
					ValaArrayCreationExpression* _tmp52_;
					ValaArrayCreationExpression* _tmp53_;
					ValaDataType* _tmp54_;
					ValaDataType* _tmp55_;
					ValaArrayCreationExpression* _tmp56_;
					ValaDataType* _tmp57_;
					ValaDataType* _tmp58_;
					ValaCodeNode* _tmp59_;
					ValaArrayCreationExpression* _tmp60_;
					ValaArrayCreationExpression* _tmp61_;
					_tmp38_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp39_ = _tmp38_;
					_tmp40_ = _vala_code_node_ref0 (_tmp39_);
					old_parent_node = _tmp40_;
					_tmp41_ = array_type;
					_tmp42_ = vala_array_type_get_element_type (_tmp41_);
					_tmp43_ = _tmp42_;
					_tmp44_ = vala_data_type_copy (_tmp43_);
					_tmp45_ = _tmp44_;
					_tmp46_ = array_type;
					_tmp47_ = vala_array_type_get_rank (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp50_ = _tmp49_;
					_tmp51_ = vala_array_creation_expression_new (_tmp45_, _tmp48_, self, _tmp50_);
					_tmp52_ = _tmp51_;
					_vala_code_node_unref0 (_tmp45_);
					array_creation = _tmp52_;
					_tmp53_ = array_creation;
					_tmp54_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp55_ = _tmp54_;
					vala_expression_set_target_type ((ValaExpression*) _tmp53_, _tmp55_);
					_tmp56_ = array_creation;
					_tmp57_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
					_tmp58_ = _tmp57_;
					vala_expression_set_formal_target_type ((ValaExpression*) _tmp56_, _tmp58_);
					_tmp59_ = old_parent_node;
					_tmp60_ = array_creation;
					vala_code_node_replace_expression (_tmp59_, (ValaExpression*) self, (ValaExpression*) _tmp60_);
					vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
					_tmp61_ = array_creation;
					result = vala_code_node_check ((ValaCodeNode*) _tmp61_, context);
					_vala_code_node_unref0 (array_creation);
					_vala_code_node_unref0 (old_parent_node);
					_vala_code_node_unref0 (array_type);
					return result;
				}
				_tmp62_ = array_type;
				_tmp63_ = vala_array_type_get_rank (_tmp62_);
				_tmp64_ = _tmp63_;
				if (_tmp64_ > 1) {
					ValaArrayType* inner_array_type = NULL;
					ValaArrayType* _tmp65_;
					ValaDataType* _tmp66_;
					ValaArrayType* _tmp67_;
					gint _tmp68_;
					gint _tmp69_;
					ValaArrayType* _tmp70_;
					ValaDataType* _tmp71_;
					_tmp65_ = array_type;
					_tmp66_ = vala_data_type_copy ((ValaDataType*) _tmp65_);
					inner_array_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_ARRAY_TYPE, ValaArrayType);
					_tmp67_ = inner_array_type;
					_tmp68_ = vala_array_type_get_rank (_tmp67_);
					_tmp69_ = _tmp68_;
					vala_array_type_set_rank (_tmp67_, _tmp69_ - 1);
					_tmp70_ = inner_array_type;
					_tmp71_ = _vala_code_node_ref0 ((ValaDataType*) _tmp70_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp71_;
					_vala_code_node_unref0 (inner_array_type);
				} else {
					ValaArrayType* _tmp72_;
					ValaDataType* _tmp73_;
					ValaDataType* _tmp74_;
					ValaDataType* _tmp75_;
					_tmp72_ = array_type;
					_tmp73_ = vala_array_type_get_element_type (_tmp72_);
					_tmp74_ = _tmp73_;
					_tmp75_ = vala_data_type_copy (_tmp74_);
					_vala_code_node_unref0 (inner_target_type);
					inner_target_type = _tmp75_;
				}
				{
					ValaList* _e_list = NULL;
					ValaList* _tmp76_;
					gint _e_size = 0;
					ValaList* _tmp77_;
					gint _tmp78_;
					gint _tmp79_;
					gint _e_index = 0;
					_tmp76_ = vala_initializer_list_get_initializers (self);
					_e_list = _tmp76_;
					_tmp77_ = _e_list;
					_tmp78_ = vala_collection_get_size ((ValaCollection*) _tmp77_);
					_tmp79_ = _tmp78_;
					_e_size = _tmp79_;
					_e_index = -1;
					while (TRUE) {
						gint _tmp80_;
						gint _tmp81_;
						ValaExpression* e = NULL;
						ValaList* _tmp82_;
						gint _tmp83_;
						gpointer _tmp84_;
						ValaExpression* _tmp85_;
						ValaDataType* _tmp86_;
						_e_index = _e_index + 1;
						_tmp80_ = _e_index;
						_tmp81_ = _e_size;
						if (!(_tmp80_ < _tmp81_)) {
							break;
						}
						_tmp82_ = _e_list;
						_tmp83_ = _e_index;
						_tmp84_ = vala_list_get (_tmp82_, _tmp83_);
						e = (ValaExpression*) _tmp84_;
						_tmp85_ = e;
						_tmp86_ = inner_target_type;
						vala_expression_set_target_type (_tmp85_, _tmp86_);
						_vala_code_node_unref0 (e);
					}
					_vala_iterable_unref0 (_e_list);
				}
				_vala_code_node_unref0 (inner_target_type);
				_vala_code_node_unref0 (array_type);
			} else {
				ValaDataType* _tmp87_;
				ValaDataType* _tmp88_;
				ValaTypeSymbol* _tmp89_;
				ValaTypeSymbol* _tmp90_;
				_tmp87_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp88_ = _tmp87_;
				_tmp89_ = vala_data_type_get_data_type (_tmp88_);
				_tmp90_ = _tmp89_;
				if (VALA_IS_STRUCT (_tmp90_)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp91_;
					ValaDataType* _tmp92_;
					ValaTypeSymbol* _tmp93_;
					ValaTypeSymbol* _tmp94_;
					ValaStruct* _tmp95_;
					gboolean _tmp103_ = FALSE;
					ValaCodeNode* _tmp104_;
					ValaCodeNode* _tmp105_;
					gboolean in_array_creation_initializer = FALSE;
					ValaObjectCreationExpression* struct_creation = NULL;
					gboolean _tmp110_;
					ValaIterator* field_it = NULL;
					ValaStruct* _tmp155_;
					ValaList* _tmp156_;
					ValaList* _tmp157_;
					ValaIterator* _tmp158_;
					ValaIterator* _tmp159_;
					gboolean _tmp209_;
					_tmp91_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp92_ = _tmp91_;
					_tmp93_ = vala_data_type_get_data_type (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp95_;
					while (TRUE) {
						ValaStruct* _tmp96_;
						ValaStruct* _tmp97_;
						ValaStruct* _tmp98_;
						ValaStruct* _tmp99_;
						ValaStruct* _tmp100_;
						ValaStruct* _tmp101_;
						ValaStruct* _tmp102_;
						_tmp96_ = st;
						_tmp97_ = vala_struct_get_base_struct (_tmp96_);
						_tmp98_ = _tmp97_;
						if (!(_tmp98_ != NULL)) {
							break;
						}
						_tmp99_ = st;
						_tmp100_ = vala_struct_get_base_struct (_tmp99_);
						_tmp101_ = _tmp100_;
						_tmp102_ = _vala_code_node_ref0 (_tmp101_);
						_vala_code_node_unref0 (st);
						st = _tmp102_;
					}
					_tmp104_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp105_ = _tmp104_;
					if (VALA_IS_INITIALIZER_LIST (_tmp105_)) {
						ValaCodeNode* _tmp106_;
						ValaCodeNode* _tmp107_;
						ValaCodeNode* _tmp108_;
						ValaCodeNode* _tmp109_;
						_tmp106_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp107_ = _tmp106_;
						_tmp108_ = vala_code_node_get_parent_node (_tmp107_);
						_tmp109_ = _tmp108_;
						_tmp103_ = VALA_IS_ARRAY_CREATION_EXPRESSION (_tmp109_);
					} else {
						_tmp103_ = FALSE;
					}
					in_array_creation_initializer = _tmp103_;
					struct_creation = NULL;
					_tmp110_ = in_array_creation_initializer;
					if (_tmp110_) {
						ValaSymbol* sym = NULL;
						ValaStruct* _tmp111_;
						ValaMemberAccess* ma = NULL;
						ValaSymbol* _tmp112_;
						const gchar* _tmp113_;
						const gchar* _tmp114_;
						ValaSourceReference* _tmp115_;
						ValaSourceReference* _tmp116_;
						ValaMemberAccess* _tmp117_;
						ValaMemberAccess* _tmp118_;
						ValaMemberAccess* _tmp119_;
						ValaSymbol* _tmp120_;
						ValaMemberAccess* inner = NULL;
						ValaMemberAccess* _tmp121_;
						ValaMemberAccess* _tmp122_;
						ValaMemberAccess* _tmp145_;
						ValaSourceReference* _tmp146_;
						ValaSourceReference* _tmp147_;
						ValaObjectCreationExpression* _tmp148_;
						ValaObjectCreationExpression* _tmp149_;
						ValaDataType* _tmp150_;
						ValaDataType* _tmp151_;
						ValaDataType* _tmp152_;
						ValaDataType* _tmp153_;
						ValaObjectCreationExpression* _tmp154_;
						_tmp111_ = st;
						sym = (ValaSymbol*) _tmp111_;
						_tmp112_ = sym;
						_tmp113_ = vala_symbol_get_name (_tmp112_);
						_tmp114_ = _tmp113_;
						_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp116_ = _tmp115_;
						_tmp117_ = vala_member_access_new_simple (_tmp114_, _tmp116_);
						ma = _tmp117_;
						_tmp118_ = ma;
						vala_member_access_set_creation_member (_tmp118_, TRUE);
						_tmp119_ = ma;
						_tmp120_ = sym;
						vala_expression_set_symbol_reference ((ValaExpression*) _tmp119_, _tmp120_);
						_tmp121_ = ma;
						_tmp122_ = _vala_code_node_ref0 (_tmp121_);
						inner = _tmp122_;
						while (TRUE) {
							gboolean _tmp123_ = FALSE;
							ValaSymbol* _tmp124_;
							ValaSymbol* _tmp125_;
							ValaSymbol* _tmp126_;
							ValaSymbol* _tmp132_;
							ValaSymbol* _tmp133_;
							ValaSymbol* _tmp134_;
							ValaMemberAccess* ma_inner = NULL;
							ValaSymbol* _tmp135_;
							const gchar* _tmp136_;
							const gchar* _tmp137_;
							ValaSourceReference* _tmp138_;
							ValaSourceReference* _tmp139_;
							ValaMemberAccess* _tmp140_;
							ValaMemberAccess* _tmp141_;
							ValaMemberAccess* _tmp142_;
							ValaMemberAccess* _tmp143_;
							ValaMemberAccess* _tmp144_;
							_tmp124_ = sym;
							_tmp125_ = vala_symbol_get_parent_symbol (_tmp124_);
							_tmp126_ = _tmp125_;
							if (_tmp126_ != NULL) {
								ValaSymbol* _tmp127_;
								ValaSymbol* _tmp128_;
								ValaSymbol* _tmp129_;
								ValaNamespace* _tmp130_;
								ValaNamespace* _tmp131_;
								_tmp127_ = sym;
								_tmp128_ = vala_symbol_get_parent_symbol (_tmp127_);
								_tmp129_ = _tmp128_;
								_tmp130_ = vala_code_context_get_root (context);
								_tmp131_ = _tmp130_;
								_tmp123_ = _tmp129_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp131_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp123_ = FALSE;
							}
							if (!_tmp123_) {
								break;
							}
							_tmp132_ = sym;
							_tmp133_ = vala_symbol_get_parent_symbol (_tmp132_);
							_tmp134_ = _tmp133_;
							sym = _tmp134_;
							_tmp135_ = sym;
							_tmp136_ = vala_symbol_get_name (_tmp135_);
							_tmp137_ = _tmp136_;
							_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp139_ = _tmp138_;
							_tmp140_ = vala_member_access_new_simple (_tmp137_, _tmp139_);
							ma_inner = _tmp140_;
							_tmp141_ = inner;
							_tmp142_ = ma_inner;
							vala_member_access_set_inner (_tmp141_, (ValaExpression*) _tmp142_);
							_tmp143_ = ma_inner;
							_tmp144_ = _vala_code_node_ref0 (_tmp143_);
							_vala_code_node_unref0 (inner);
							inner = _tmp144_;
							_vala_code_node_unref0 (ma_inner);
						}
						_tmp145_ = ma;
						_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp147_ = _tmp146_;
						_tmp148_ = vala_object_creation_expression_new (_tmp145_, _tmp147_);
						_vala_code_node_unref0 (struct_creation);
						struct_creation = _tmp148_;
						_tmp149_ = struct_creation;
						_tmp150_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp151_ = _tmp150_;
						_tmp152_ = vala_data_type_copy (_tmp151_);
						_tmp153_ = _tmp152_;
						vala_expression_set_target_type ((ValaExpression*) _tmp149_, _tmp153_);
						_vala_code_node_unref0 (_tmp153_);
						_tmp154_ = struct_creation;
						vala_object_creation_expression_set_struct_creation (_tmp154_, TRUE);
						_vala_code_node_unref0 (inner);
						_vala_code_node_unref0 (ma);
					}
					_tmp155_ = st;
					_tmp156_ = vala_struct_get_fields (_tmp155_);
					_tmp157_ = _tmp156_;
					_tmp158_ = vala_iterable_iterator ((ValaIterable*) _tmp157_);
					_tmp159_ = _tmp158_;
					_vala_iterable_unref0 (_tmp157_);
					field_it = _tmp159_;
					{
						ValaList* _e_list = NULL;
						ValaList* _tmp160_;
						gint _e_size = 0;
						ValaList* _tmp161_;
						gint _tmp162_;
						gint _tmp163_;
						gint _e_index = 0;
						_tmp160_ = vala_initializer_list_get_initializers (self);
						_e_list = _tmp160_;
						_tmp161_ = _e_list;
						_tmp162_ = vala_collection_get_size ((ValaCollection*) _tmp161_);
						_tmp163_ = _tmp162_;
						_e_size = _tmp163_;
						_e_index = -1;
						while (TRUE) {
							gint _tmp164_;
							gint _tmp165_;
							ValaExpression* e = NULL;
							ValaList* _tmp166_;
							gint _tmp167_;
							gpointer _tmp168_;
							ValaField* field = NULL;
							gboolean _tmp185_;
							_e_index = _e_index + 1;
							_tmp164_ = _e_index;
							_tmp165_ = _e_size;
							if (!(_tmp164_ < _tmp165_)) {
								break;
							}
							_tmp166_ = _e_list;
							_tmp167_ = _e_index;
							_tmp168_ = vala_list_get (_tmp166_, _tmp167_);
							e = (ValaExpression*) _tmp168_;
							field = NULL;
							while (TRUE) {
								ValaField* _tmp169_;
								ValaIterator* _tmp170_;
								ValaIterator* _tmp180_;
								gpointer _tmp181_;
								ValaField* _tmp182_;
								ValaMemberBinding _tmp183_;
								ValaMemberBinding _tmp184_;
								_tmp169_ = field;
								if (!(_tmp169_ == NULL)) {
									break;
								}
								_tmp170_ = field_it;
								if (!vala_iterator_next (_tmp170_)) {
									ValaExpression* _tmp171_;
									ValaSourceReference* _tmp172_;
									ValaSourceReference* _tmp173_;
									ValaDataType* _tmp174_;
									ValaDataType* _tmp175_;
									gchar* _tmp176_;
									gchar* _tmp177_;
									gchar* _tmp178_;
									gchar* _tmp179_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp171_ = e;
									_tmp172_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp171_);
									_tmp173_ = _tmp172_;
									_tmp174_ = vala_expression_get_target_type ((ValaExpression*) self);
									_tmp175_ = _tmp174_;
									_tmp176_ = vala_code_node_to_string ((ValaCodeNode*) _tmp175_);
									_tmp177_ = _tmp176_;
									_tmp178_ = g_strdup_printf ("too many expressions in initializer list for `%s'", _tmp177_);
									_tmp179_ = _tmp178_;
									vala_report_error (_tmp173_, _tmp179_);
									_g_free0 (_tmp179_);
									_g_free0 (_tmp177_);
									result = FALSE;
									_vala_code_node_unref0 (field);
									_vala_code_node_unref0 (e);
									_vala_iterable_unref0 (_e_list);
									_vala_iterator_unref0 (field_it);
									_vala_code_node_unref0 (struct_creation);
									_vala_code_node_unref0 (st);
									return result;
								}
								_tmp180_ = field_it;
								_tmp181_ = vala_iterator_get (_tmp180_);
								_vala_code_node_unref0 (field);
								field = (ValaField*) _tmp181_;
								_tmp182_ = field;
								_tmp183_ = vala_field_get_binding (_tmp182_);
								_tmp184_ = _tmp183_;
								if (_tmp184_ != VALA_MEMBER_BINDING_INSTANCE) {
									_vala_code_node_unref0 (field);
									field = NULL;
								}
							}
							_tmp185_ = in_array_creation_initializer;
							if (_tmp185_) {
								ValaMemberInitializer* member_init = NULL;
								ValaField* _tmp186_;
								const gchar* _tmp187_;
								const gchar* _tmp188_;
								ValaExpression* _tmp189_;
								ValaExpression* _tmp190_;
								ValaSourceReference* _tmp191_;
								ValaSourceReference* _tmp192_;
								ValaMemberInitializer* _tmp193_;
								ValaObjectCreationExpression* _tmp194_;
								ValaMemberInitializer* _tmp195_;
								_tmp186_ = field;
								_tmp187_ = vala_symbol_get_name ((ValaSymbol*) _tmp186_);
								_tmp188_ = _tmp187_;
								_tmp189_ = e;
								_tmp190_ = e;
								_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp190_);
								_tmp192_ = _tmp191_;
								_tmp193_ = vala_member_initializer_new (_tmp188_, _tmp189_, _tmp192_);
								member_init = _tmp193_;
								_tmp194_ = struct_creation;
								_tmp195_ = member_init;
								vala_object_creation_expression_add_member_initializer (_tmp194_, _tmp195_);
								_vala_code_node_unref0 (member_init);
							} else {
								ValaExpression* _tmp196_;
								ValaField* _tmp197_;
								ValaDataType* _tmp198_;
								ValaDataType* _tmp199_;
								ValaDataType* _tmp200_;
								ValaDataType* _tmp201_;
								ValaDataType* _tmp202_;
								ValaDataType* _tmp203_;
								gboolean _tmp204_;
								gboolean _tmp205_;
								_tmp196_ = e;
								_tmp197_ = field;
								_tmp198_ = vala_variable_get_variable_type ((ValaVariable*) _tmp197_);
								_tmp199_ = _tmp198_;
								_tmp200_ = vala_data_type_copy (_tmp199_);
								_tmp201_ = _tmp200_;
								vala_expression_set_target_type (_tmp196_, _tmp201_);
								_vala_code_node_unref0 (_tmp201_);
								_tmp202_ = vala_expression_get_target_type ((ValaExpression*) self);
								_tmp203_ = _tmp202_;
								_tmp204_ = vala_data_type_get_value_owned (_tmp203_);
								_tmp205_ = _tmp204_;
								if (!_tmp205_) {
									ValaExpression* _tmp206_;
									ValaDataType* _tmp207_;
									ValaDataType* _tmp208_;
									_tmp206_ = e;
									_tmp207_ = vala_expression_get_target_type (_tmp206_);
									_tmp208_ = _tmp207_;
									vala_data_type_set_value_owned (_tmp208_, FALSE);
								}
							}
							_vala_code_node_unref0 (field);
							_vala_code_node_unref0 (e);
						}
						_vala_iterable_unref0 (_e_list);
					}
					_tmp209_ = in_array_creation_initializer;
					if (_tmp209_) {
						ValaCodeNode* _tmp210_;
						ValaCodeNode* _tmp211_;
						ValaObjectCreationExpression* _tmp212_;
						ValaObjectCreationExpression* _tmp213_;
						_tmp210_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp211_ = _tmp210_;
						_tmp212_ = struct_creation;
						vala_code_node_replace_expression (_tmp211_, (ValaExpression*) self, (ValaExpression*) _tmp212_);
						vala_code_node_set_checked ((ValaCodeNode*) self, FALSE);
						_tmp213_ = struct_creation;
						result = vala_code_node_check ((ValaCodeNode*) _tmp213_, context);
						_vala_iterator_unref0 (field_it);
						_vala_code_node_unref0 (struct_creation);
						_vala_code_node_unref0 (st);
						return result;
					}
					_vala_iterator_unref0 (field_it);
					_vala_code_node_unref0 (struct_creation);
					_vala_code_node_unref0 (st);
				} else {
					ValaSourceReference* _tmp214_;
					ValaSourceReference* _tmp215_;
					ValaDataType* _tmp216_;
					ValaDataType* _tmp217_;
					gchar* _tmp218_;
					gchar* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp214_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp215_ = _tmp214_;
					_tmp216_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp217_ = _tmp216_;
					_tmp218_ = vala_code_node_to_string ((ValaCodeNode*) _tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = g_strdup_printf ("initializer list used for `%s', which is neither array nor struct", _tmp219_);
					_tmp221_ = _tmp220_;
					vala_report_error (_tmp215_, _tmp221_);
					_g_free0 (_tmp221_);
					_g_free0 (_tmp219_);
					result = FALSE;
					return result;
				}
			}
		}
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp222_;
		ValaList* _tmp223_;
		gint _expr_size = 0;
		ValaList* _tmp224_;
		gint _tmp225_;
		gint _tmp226_;
		gint _expr_index = 0;
		_tmp222_ = self->priv->initializers;
		_tmp223_ = _vala_iterable_ref0 (_tmp222_);
		_expr_list = _tmp223_;
		_tmp224_ = _expr_list;
		_tmp225_ = vala_collection_get_size ((ValaCollection*) _tmp224_);
		_tmp226_ = _tmp225_;
		_expr_size = _tmp226_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp227_;
			gint _tmp228_;
			ValaExpression* expr = NULL;
			ValaList* _tmp229_;
			gint _tmp230_;
			gpointer _tmp231_;
			ValaExpression* _tmp232_;
			_expr_index = _expr_index + 1;
			_tmp227_ = _expr_index;
			_tmp228_ = _expr_size;
			if (!(_tmp227_ < _tmp228_)) {
				break;
			}
			_tmp229_ = _expr_list;
			_tmp230_ = _expr_index;
			_tmp231_ = vala_list_get (_tmp229_, _tmp230_);
			expr = (ValaExpression*) _tmp231_;
			_tmp232_ = expr;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp232_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp233_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp234_ = _tmp233_;
	if (_tmp234_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _e_list = NULL;
		ValaList* _tmp235_;
		gint _e_size = 0;
		ValaList* _tmp236_;
		gint _tmp237_;
		gint _tmp238_;
		gint _e_index = 0;
		_tmp235_ = vala_initializer_list_get_initializers (self);
		_e_list = _tmp235_;
		_tmp236_ = _e_list;
		_tmp237_ = vala_collection_get_size ((ValaCollection*) _tmp236_);
		_tmp238_ = _tmp237_;
		_e_size = _tmp238_;
		_e_index = -1;
		while (TRUE) {
			gint _tmp239_;
			gint _tmp240_;
			ValaExpression* e = NULL;
			ValaList* _tmp241_;
			gint _tmp242_;
			gpointer _tmp243_;
			ValaExpression* _tmp244_;
			ValaDataType* _tmp245_;
			ValaDataType* _tmp246_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp250_;
			ValaUnaryExpression* _tmp251_;
			gboolean _tmp252_ = FALSE;
			ValaUnaryExpression* _tmp253_;
			_e_index = _e_index + 1;
			_tmp239_ = _e_index;
			_tmp240_ = _e_size;
			if (!(_tmp239_ < _tmp240_)) {
				break;
			}
			_tmp241_ = _e_list;
			_tmp242_ = _e_index;
			_tmp243_ = vala_list_get (_tmp241_, _tmp242_);
			e = (ValaExpression*) _tmp243_;
			_tmp244_ = e;
			_tmp245_ = vala_expression_get_value_type (_tmp244_);
			_tmp246_ = _tmp245_;
			if (_tmp246_ == NULL) {
				ValaExpression* _tmp247_;
				ValaSourceReference* _tmp248_;
				ValaSourceReference* _tmp249_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp247_ = e;
				_tmp248_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp247_);
				_tmp249_ = _tmp248_;
				vala_report_error (_tmp249_, "expression type not allowed as initializer");
				_vala_code_node_unref0 (e);
				continue;
			}
			_tmp250_ = e;
			_tmp251_ = _vala_code_node_ref0 (VALA_IS_UNARY_EXPRESSION (_tmp250_) ? ((ValaUnaryExpression*) _tmp250_) : NULL);
			unary = _tmp251_;
			_tmp253_ = unary;
			if (_tmp253_ != NULL) {
				gboolean _tmp254_ = FALSE;
				ValaUnaryExpression* _tmp255_;
				ValaUnaryOperator _tmp256_;
				ValaUnaryOperator _tmp257_;
				_tmp255_ = unary;
				_tmp256_ = vala_unary_expression_get_operator (_tmp255_);
				_tmp257_ = _tmp256_;
				if (_tmp257_ == VALA_UNARY_OPERATOR_REF) {
					_tmp254_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp258_;
					ValaUnaryOperator _tmp259_;
					ValaUnaryOperator _tmp260_;
					_tmp258_ = unary;
					_tmp259_ = vala_unary_expression_get_operator (_tmp258_);
					_tmp260_ = _tmp259_;
					_tmp254_ = _tmp260_ == VALA_UNARY_OPERATOR_OUT;
				}
				_tmp252_ = _tmp254_;
			} else {
				_tmp252_ = FALSE;
			}
			if (_tmp252_) {
			} else {
				ValaExpression* _tmp261_;
				ValaDataType* _tmp262_;
				ValaDataType* _tmp263_;
				ValaExpression* _tmp264_;
				ValaDataType* _tmp265_;
				ValaDataType* _tmp266_;
				_tmp261_ = e;
				_tmp262_ = vala_expression_get_value_type (_tmp261_);
				_tmp263_ = _tmp262_;
				_tmp264_ = e;
				_tmp265_ = vala_expression_get_target_type (_tmp264_);
				_tmp266_ = _tmp265_;
				if (!vala_data_type_compatible (_tmp263_, _tmp266_)) {
					ValaExpression* _tmp267_;
					ValaExpression* _tmp268_;
					ValaSourceReference* _tmp269_;
					ValaSourceReference* _tmp270_;
					ValaExpression* _tmp271_;
					ValaDataType* _tmp272_;
					ValaDataType* _tmp273_;
					gchar* _tmp274_;
					gchar* _tmp275_;
					ValaExpression* _tmp276_;
					ValaDataType* _tmp277_;
					ValaDataType* _tmp278_;
					gchar* _tmp279_;
					gchar* _tmp280_;
					gchar* _tmp281_;
					gchar* _tmp282_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp267_ = e;
					vala_code_node_set_error ((ValaCodeNode*) _tmp267_, TRUE);
					_tmp268_ = e;
					_tmp269_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp268_);
					_tmp270_ = _tmp269_;
					_tmp271_ = e;
					_tmp272_ = vala_expression_get_target_type (_tmp271_);
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_code_node_to_string ((ValaCodeNode*) _tmp273_);
					_tmp275_ = _tmp274_;
					_tmp276_ = e;
					_tmp277_ = vala_expression_get_value_type (_tmp276_);
					_tmp278_ = _tmp277_;
					_tmp279_ = vala_code_node_to_string ((ValaCodeNode*) _tmp278_);
					_tmp280_ = _tmp279_;
					_tmp281_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp275_, _tmp280_);
					_tmp282_ = _tmp281_;
					vala_report_error (_tmp270_, _tmp282_);
					_g_free0 (_tmp282_);
					_g_free0 (_tmp280_);
					_g_free0 (_tmp275_);
				}
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (e);
		}
		_vala_iterable_unref0 (_e_list);
	}
	_tmp283_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp284_ = _tmp283_;
	if (!_tmp284_) {
		ValaDataType* _tmp285_;
		ValaDataType* _tmp286_;
		ValaDataType* _tmp287_;
		ValaDataType* _tmp288_;
		ValaDataType* _tmp289_;
		ValaDataType* _tmp290_;
		_tmp285_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp286_ = _tmp285_;
		_tmp287_ = vala_data_type_copy (_tmp286_);
		_tmp288_ = _tmp287_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp288_);
		_vala_code_node_unref0 (_tmp288_);
		_tmp289_ = vala_expression_get_value_type ((ValaExpression*) self);
		_tmp290_ = _tmp289_;
		vala_data_type_set_nullable (_tmp290_, FALSE);
	}
	_tmp291_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp292_ = _tmp291_;
	result = !_tmp292_;
	return result;
}


static void
vala_initializer_list_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp5_ = _expr_index;
			_tmp6_ = _expr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = _expr_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp10_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_initializer_list ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_initializer_list_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaInitializerList * self;
	self = (ValaInitializerList*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _expr_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _expr_index = 0;
		_tmp0_ = self->priv->initializers;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_expr_list = _tmp1_;
		_tmp2_ = _expr_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_expr_size = _tmp4_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* expr = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaExpression* _tmp10_;
			_expr_index = _expr_index + 1;
			_tmp5_ = _expr_index;
			_tmp6_ = _expr_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _expr_list;
			_tmp8_ = _expr_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			expr = (ValaExpression*) _tmp9_;
			_tmp10_ = expr;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp10_, collection);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


gint
vala_initializer_list_get_size (ValaInitializerList* self)
{
	gint result;
	ValaList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->initializers;
	_tmp1_ = vala_collection_get_size ((ValaCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static void
vala_initializer_list_class_init (ValaInitializerListClass * klass)
{
	vala_initializer_list_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_initializer_list_finalize;
	g_type_class_add_private (klass, sizeof (ValaInitializerListPrivate));
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept_children;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_initializer_list_real_accept;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_initializer_list_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_initializer_list_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_initializer_list_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_initializer_list_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_initializer_list_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_initializer_list_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_initializer_list_real_get_used_variables;
}


static void
vala_initializer_list_instance_init (ValaInitializerList * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_INITIALIZER_LIST_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->initializers = (ValaList*) _tmp1_;
}


static void
vala_initializer_list_finalize (ValaCodeNode * obj)
{
	ValaInitializerList * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList);
	_vala_iterable_unref0 (self->priv->initializers);
	VALA_CODE_NODE_CLASS (vala_initializer_list_parent_class)->finalize (obj);
}


/**
 * Represents an array or struct initializer list in the source code.
 */
GType
vala_initializer_list_get_type (void)
{
	static volatile gsize vala_initializer_list_type_id__volatile = 0;
	if (g_once_init_enter (&vala_initializer_list_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaInitializerListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_initializer_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaInitializerList), 0, (GInstanceInitFunc) vala_initializer_list_instance_init, NULL };
		GType vala_initializer_list_type_id;
		vala_initializer_list_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaInitializerList", &g_define_type_info, 0);
		g_once_init_leave (&vala_initializer_list_type_id__volatile, vala_initializer_list_type_id);
	}
	return vala_initializer_list_type_id__volatile;
}



