/* valagirparser.c generated by valac, the Vala compiler
 * generated from valagirparser.vala, do not modify */

/* valagirparser.vala
 *
 * Copyright (C) 2008-2012  Jürg Billeter
 * Copyright (C) 2011-2014  Luca Bruno
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Luca Bruno <lucabru@src.gnome.org>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <glib/gstdio.h>
#include <gobject/gvaluecollector.h>


#define VALA_GIR_PARSER_TYPE_NODE (vala_gir_parser_node_get_type ())
#define VALA_GIR_PARSER_NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode))
#define VALA_GIR_PARSER_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))
#define VALA_GIR_PARSER_IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_NODE))
#define VALA_GIR_PARSER_NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNodeClass))

typedef struct _ValaGirParserNode ValaGirParserNode;
typedef struct _ValaGirParserNodeClass ValaGirParserNodeClass;

#define VALA_GIR_PARSER_TYPE_METADATA (vala_gir_parser_metadata_get_type ())
#define VALA_GIR_PARSER_METADATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata))
#define VALA_GIR_PARSER_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))
#define VALA_GIR_PARSER_IS_METADATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_IS_METADATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA))
#define VALA_GIR_PARSER_METADATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadataClass))

typedef struct _ValaGirParserMetadata ValaGirParserMetadata;
typedef struct _ValaGirParserMetadataClass ValaGirParserMetadataClass;
typedef enum  {
	VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP,
	VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NEW,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_OUT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_REF,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS,
	VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE,
	VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING,
	VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID,
	VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME,
	VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET,
	VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX,
	VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE
} ValaGirParserArgumentType;


#define VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE (vala_gir_parser_argument_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_type_class_unref0(var) ((var == NULL) ? NULL : (var = (g_type_class_unref (var), NULL)))
#define _vala_markup_reader_unref0(var) ((var == NULL) ? NULL : (var = (vala_markup_reader_unref (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _vala_gir_parser_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_gir_parser_metadata_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
typedef struct _ValaGirParserNodePrivate ValaGirParserNodePrivate;

#define VALA_GIR_PARSER_TYPE_PARAMETER_INFO (vala_gir_parser_parameter_info_get_type ())
#define VALA_GIR_PARSER_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo))
#define VALA_GIR_PARSER_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_IS_PARAMETER_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_PARAMETER_INFO))
#define VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfoClass))

typedef struct _ValaGirParserParameterInfo ValaGirParserParameterInfo;
typedef struct _ValaGirParserParameterInfoClass ValaGirParserParameterInfoClass;
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_source_reference_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_reference_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
typedef struct _ValaGirParserParameterInfoPrivate ValaGirParserParameterInfoPrivate;

#define VALA_GIR_PARSER_TYPE_METADATA_PARSER (vala_gir_parser_metadata_parser_get_type ())
#define VALA_GIR_PARSER_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser))
#define VALA_GIR_PARSER_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))
#define VALA_GIR_PARSER_IS_METADATA_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_IS_METADATA_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_PARSER))
#define VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserClass))

typedef struct _ValaGirParserMetadataParser ValaGirParserMetadataParser;
typedef struct _ValaGirParserMetadataParserClass ValaGirParserMetadataParserClass;
#define _vala_gir_parser_metadata_parser_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_metadata_parser_unref (var), NULL)))
#define _vala_comment_unref0(var) ((var == NULL) ? NULL : (var = (vala_comment_unref (var), NULL)))
#define _vala_gir_parser_parameter_info_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_parameter_info_unref (var), NULL)))
typedef struct _ValaGirParserMetadataPrivate ValaGirParserMetadataPrivate;

#define VALA_GIR_PARSER_TYPE_ARGUMENT (vala_gir_parser_argument_get_type ())
#define VALA_GIR_PARSER_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument))
#define VALA_GIR_PARSER_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))
#define VALA_GIR_PARSER_IS_ARGUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_IS_ARGUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_ARGUMENT))
#define VALA_GIR_PARSER_ARGUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgumentClass))

typedef struct _ValaGirParserArgument ValaGirParserArgument;
typedef struct _ValaGirParserArgumentClass ValaGirParserArgumentClass;
typedef struct _ValaGirParserArgumentPrivate ValaGirParserArgumentPrivate;
#define _vala_gir_parser_argument_unref0(var) ((var == NULL) ? NULL : (var = (vala_gir_parser_argument_unref (var), NULL)))
#define _vala_map_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_iterator_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecArgument ValaGirParserParamSpecArgument;

#define VALA_GIR_PARSER_TYPE_METADATA_SET (vala_gir_parser_metadata_set_get_type ())
#define VALA_GIR_PARSER_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSet))
#define VALA_GIR_PARSER_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))
#define VALA_GIR_PARSER_IS_METADATA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_IS_METADATA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_GIR_PARSER_TYPE_METADATA_SET))
#define VALA_GIR_PARSER_METADATA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_GIR_PARSER_TYPE_METADATA_SET, ValaGirParserMetadataSetClass))

typedef struct _ValaGirParserMetadataSet ValaGirParserMetadataSet;
typedef struct _ValaGirParserMetadataSetClass ValaGirParserMetadataSetClass;
typedef struct _ValaGirParserMetadataSetPrivate ValaGirParserMetadataSetPrivate;
#define _g_pattern_spec_free0(var) ((var == NULL) ? NULL : (var = (g_pattern_spec_free (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadata ValaGirParserParamSpecMetadata;
typedef struct _ValaGirParserMetadataParserPrivate ValaGirParserMetadataParserPrivate;
#define _vala_scanner_unref0(var) ((var == NULL) ? NULL : (var = (vala_scanner_unref (var), NULL)))
typedef struct _ValaGirParserParamSpecMetadataParser ValaGirParserParamSpecMetadataParser;
typedef struct _ValaGirParserParamSpecNode ValaGirParserParamSpecNode;
typedef struct _ValaGirParserParamSpecParameterInfo ValaGirParserParamSpecParameterInfo;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGirParserPrivate {
	ValaMarkupReader* reader;
	ValaCodeContext* context;
	ValaSourceFile* current_source_file;
	ValaGirParserNode* root;
	ValaArrayList* metadata_roots;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaMarkupTokenType current_token;
	gchar** cheader_filenames;
	gint cheader_filenames_length1;
	gint _cheader_filenames_size_;
	ValaArrayList* metadata_stack;
	ValaGirParserMetadata* metadata;
	ValaArrayList* tree_stack;
	ValaGirParserNode* current;
	ValaGirParserNode* old_current;
	ValaSet* provided_namespaces;
	ValaHashMap* unresolved_symbols_map;
	ValaArrayList* unresolved_gir_symbols;
	ValaHashMap* unresolved_type_arguments;
	ValaArrayList* ifaces_needing_object_prereq;
};

struct _ValaGirParserNode {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserNode* parent;
	gchar* element_type;
	gchar* name;
	ValaMap* girdata;
	ValaGirParserMetadata* metadata;
	ValaSourceReference* source_reference;
	ValaArrayList* members;
	ValaHashMap* scope;
	ValaGirComment* comment;
	ValaSymbol* symbol;
	gboolean new_symbol;
	gboolean merged;
	gboolean processed;
	gint return_array_length_idx;
	ValaList* parameters;
	ValaArrayList* array_length_parameters;
	ValaArrayList* closure_parameters;
	ValaArrayList* destroy_parameters;
	ValaUnresolvedSymbol* gtype_struct_for;
	ValaDataType* base_type;
	gint array_length_idx;
	gboolean deprecated;
	guint64 deprecated_version;
	gchar* deprecated_since;
	gchar* deprecated_replacement;
	ValaGirParserNodePrivate * priv;
};

struct _ValaGirParserNodeClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserNode *self);
};

struct _ValaGirParserParameterInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaParameter* param;
	gfloat vala_idx;
	gint array_length_idx;
	gint closure_idx;
	gint destroy_idx;
	gboolean keep;
	gboolean is_async;
	gboolean is_async_result;
	ValaGirParserParameterInfoPrivate * priv;
};

struct _ValaGirParserParameterInfoClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserParameterInfo *self);
};

struct _ValaGirParserMetadata {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GPatternSpec* pattern_spec;
	gchar* selector;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaMap* args;
	ValaArrayList* children;
	ValaGirParserMetadataPrivate * priv;
};

struct _ValaGirParserMetadataClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadata *self);
};

struct _ValaGirParserArgument {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaExpression* expression;
	ValaSourceReference* source_reference;
	gboolean used;
	ValaGirParserArgumentPrivate * priv;
};

struct _ValaGirParserArgumentClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserArgument *self);
};

struct _ValaGirParserParamSpecArgument {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataSet {
	ValaGirParserMetadata parent_instance;
	ValaGirParserMetadataSetPrivate * priv;
};

struct _ValaGirParserMetadataSetClass {
	ValaGirParserMetadataClass parent_class;
};

struct _ValaGirParserParamSpecMetadata {
	GParamSpec parent_instance;
};

struct _ValaGirParserMetadataParser {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaGirParserMetadataParserPrivate * priv;
};

struct _ValaGirParserMetadataParserClass {
	GTypeClass parent_class;
	void (*finalize) (ValaGirParserMetadataParser *self);
};

struct _ValaGirParserMetadataParserPrivate {
	ValaGirParserMetadata* tree;
	ValaScanner* scanner;
	ValaSourceLocation begin;
	ValaSourceLocation end;
	ValaSourceLocation old_end;
	ValaTokenType current;
	ValaGirParserMetadata* parent_metadata;
};

struct _ValaGirParserParamSpecMetadataParser {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecNode {
	GParamSpec parent_instance;
};

struct _ValaGirParserParamSpecParameterInfo {
	GParamSpec parent_instance;
};


static gpointer vala_gir_parser_parent_class = NULL;
static GRegex* vala_gir_parser_type_from_string_regex;
static GRegex* vala_gir_parser_type_from_string_regex = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces;
static gpointer vala_gir_parser_argument_parent_class = NULL;
static gpointer vala_gir_parser_metadata_set_parent_class = NULL;
static gpointer vala_gir_parser_metadata_parent_class = NULL;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty;
static ValaGirParserMetadata* vala_gir_parser_metadata__empty = NULL;
static gpointer vala_gir_parser_metadata_parser_parent_class = NULL;
static gpointer vala_gir_parser_node_parent_class = NULL;
static ValaArrayList* vala_gir_parser_node_new_namespaces = NULL;
static gpointer vala_gir_parser_parameter_info_parent_class = NULL;

static gpointer vala_gir_parser_node_ref (gpointer instance);
static void vala_gir_parser_node_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_node (const gchar* name,
                                             const gchar* nick,
                                             const gchar* blurb,
                                             GType object_type,
                                             GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_node (GValue* value,
                                     gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_node (GValue* value,
                                      gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_node (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_node_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gpointer vala_gir_parser_metadata_ref (gpointer instance);
static void vala_gir_parser_metadata_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_GIR_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GIR_PARSER, ValaGirParserPrivate))
static GType vala_gir_parser_argument_type_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserArgumentType* vala_gir_parser_argument_type_from_string (const gchar* name);
static ValaGirParserArgumentType* _vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self);
static guint vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym);
static guint _vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key);
static gboolean vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                                  ValaUnresolvedSymbol* sym2);
static gboolean _vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                               gconstpointer b);
#define VALA_GIR_PARSER_GIR_VERSION "1.2"
static ValaGirParserNode* vala_gir_parser_node_new (const gchar* name);
static ValaGirParserNode* vala_gir_parser_node_construct (GType object_type,
                                                   const gchar* name);
static gpointer vala_gir_parser_parameter_info_ref (gpointer instance);
static void vala_gir_parser_parameter_info_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_parameter_info (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_parameter_info (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_parameter_info (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_parameter_info_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_map_vala_to_gir (ValaGirParser* self);
static void vala_gir_parser_resolve_gir_symbols (ValaGirParser* self);
static void vala_gir_parser_create_new_namespaces (ValaGirParser* self);
static void vala_gir_parser_resolve_type_arguments (ValaGirParser* self);
static void vala_gir_parser_node_process (ValaGirParserNode* self,
                                   ValaGirParser* parser);
static void vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                             ValaGirParserMetadata* metadata);
static void vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                         ValaUnresolvedSymbol* map_from,
                                         ValaSymbol* map_to);
static void vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                             ValaSourceFile* source_file);
static ValaGirParserMetadata* vala_gir_parser_metadata_get_empty (void);
static void vala_gir_parser_next (ValaGirParser* self);
static void vala_gir_parser_parse_repository (ValaGirParser* self);
static void vala_gir_parser_start_element (ValaGirParser* self,
                                    const gchar* name);
static ValaSourceReference* vala_gir_parser_get_current_src (ValaGirParser* self);
static void vala_gir_parser_end_element (ValaGirParser* self,
                                  const gchar* name);
static void vala_gir_parser_skip_element (ValaGirParser* self);
static ValaSourceReference* vala_gir_parser_get_src (ValaGirParser* self,
                                              ValaSourceLocation* begin,
                                              ValaSourceLocation* end);
static void vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                              ValaSymbol* sym);
static gboolean vala_gir_parser_is_container (ValaSymbol* sym);
static ValaUnresolvedSymbol* vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                                                const gchar* symbol_string,
                                                                ValaSourceReference* source_reference);
static void vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                             ValaSignal* sig,
                                             ValaSymbol* sym,
                                             gboolean skip_first);
static ValaGirParserNode* vala_gir_parser_find_invoker (ValaGirParser* self,
                                                 ValaGirParserNode* node);
static ValaGirParserMetadata* vala_gir_parser_get_current_metadata (ValaGirParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                                             const gchar* name,
                                                             const gchar* selector);
static gboolean vala_gir_parser_push_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                                ValaGirParserArgumentType key);
static gboolean vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg,
                                            gboolean default_value);
static void vala_gir_parser_pop_metadata (ValaGirParser* self);
static gboolean vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                           ValaDataType* parent_type,
                                                           const gchar* type_arguments,
                                                           ValaSourceReference* source_reference);
static ValaDataType* vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                                      const gchar* type_string,
                                                      gboolean owned_by_default,
                                                      ValaSourceReference* source_reference);
static gchar* vala_gir_parser_element_get_string (ValaGirParser* self,
                                           const gchar* attribute_name,
                                           ValaGirParserArgumentType arg_type);
static gchar* vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_element_get_type (ValaGirParser* self,
                                                ValaDataType* orig_type,
                                                gboolean owned_by_default,
                                                gboolean* no_array_length,
                                                gboolean* array_null_terminated,
                                                gboolean* changed);
static ValaSourceReference* vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                                                    ValaGirParserArgumentType arg);
static gchar* vala_gir_parser_element_get_name (ValaGirParser* self,
                                         const gchar* gir_name);
static gchar* vala_gir_parser_element_get_type_id (ValaGirParser* self);
static void vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                      ValaSymbol* sym,
                                      ValaGirParserParameterInfo* info);
static ValaGirParserNode* vala_gir_parser_node_lookup (ValaGirParserNode* self,
                                                const gchar* name,
                                                gboolean create_namespace,
                                                ValaSourceReference* source_reference);
static gchar* vala_gir_parser_node_get_cname (ValaGirParserNode* self);
static void vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                        ValaSymbol* sym);
static void vala_gir_parser_parse_namespace (ValaGirParser* self);
static void vala_gir_parser_parse_include (ValaGirParser* self);
static gchar* vala_gir_parser_parse_package (ValaGirParser* self);
static void vala_gir_parser_parse_c_include (ValaGirParser* self);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static ValaGirParserNode* vala_gir_parser_resolve_node (ValaGirParser* self,
                                                 ValaGirParserNode* parent_scope,
                                                 ValaUnresolvedSymbol* unresolved_sym,
                                                 gboolean create_namespace);
static ValaSymbol* vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                            ValaGirParserNode* parent_scope,
                                            ValaUnresolvedSymbol* unresolved_sym);
static void vala_gir_parser_push_node (ValaGirParser* self,
                                const gchar* name,
                                gboolean merge);
static void vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                      ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_gir_name (ValaGirParserNode* self);
static ValaUnresolvedSymbol* vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self);
static void vala_gir_parser_pop_node (ValaGirParser* self);
static gpointer vala_gir_parser_metadata_parser_ref (gpointer instance);
static void vala_gir_parser_metadata_parser_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                                        const gchar* nick,
                                                        const gchar* blurb,
                                                        GType object_type,
                                                        GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_metadata_parser (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_metadata_parser (GValue* value,
                                                 gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_metadata_parser (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_metadata_parser_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_new (void);
static ValaGirParserMetadataParser* vala_gir_parser_metadata_parser_construct (GType object_type);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                                       ValaSourceFile* metadata_file);
static void _vala_code_node_unref0_ (gpointer var);
static inline void _g_list_free__vala_code_node_unref0_ (GList* self);
static void vala_gir_parser_parse_alias (ValaGirParser* self);
static void vala_gir_parser_parse_error_domain (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                        const gchar* element_name,
                                        gboolean error_domain);
static void vala_gir_parser_parse_bitfield (ValaGirParser* self);
static void vala_gir_parser_parse_method (ValaGirParser* self,
                                   const gchar* element_name);
static void vala_gir_parser_parse_callback (ValaGirParser* self);
static void vala_gir_parser_parse_record (ValaGirParser* self);
static void vala_gir_parser_parse_boxed (ValaGirParser* self,
                                  const gchar* element_name);
static void vala_gir_parser_parse_class (ValaGirParser* self);
static void vala_gir_parser_parse_interface (ValaGirParser* self);
static void vala_gir_parser_parse_union (ValaGirParser* self);
static void vala_gir_parser_parse_constant (ValaGirParser* self);
static ValaGirComment* vala_gir_parser_parse_symbol_doc (ValaGirParser* self);
static ValaDataType* vala_gir_parser_parse_type (ValaGirParser* self,
                                          gchar* * ctype,
                                          gint* array_length_idx,
                                          gboolean transfer_elements,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated);
static void vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                              gchar* * common_prefix,
                                              const gchar* cname);
static ValaComment* vala_gir_parser_parse_doc (ValaGirParser* self);
static void vala_gir_parser_parse_error_member (ValaGirParser* self);
static void vala_gir_parser_parse_enumeration_member (ValaGirParser* self);
static ValaExpression* vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                                         ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_return_value (ValaGirParser* self,
                                                  gchar* * ctype,
                                                  gint* array_length_idx,
                                                  gboolean* no_array_length,
                                                  gboolean* array_null_terminated,
                                                  ValaComment* * comment);
static ValaParameter* vala_gir_parser_parse_parameter (ValaGirParser* self,
                                                gint* array_length_idx,
                                                gint* closure_idx,
                                                gint* destroy_idx,
                                                gchar* * scope,
                                                ValaComment* * comment,
                                                const gchar* default_name);
static gint vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                           ValaGirParserArgumentType arg);
static ValaDataType* vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                                        const gchar* type_name,
                                                        gboolean* no_array_length,
                                                        gboolean* array_null_terminated,
                                                        const gchar* ctype);
static void vala_gir_parser_parse_field (ValaGirParser* self);
static void vala_gir_parser_parse_constructor (ValaGirParser* self);
static ValaProperty* vala_gir_parser_parse_property (ValaGirParser* self);
static void vala_gir_parser_parse_signal (ValaGirParser* self);
static void vala_gir_parser_parse_function (ValaGirParser* self,
                                     const gchar* element_name);
G_GNUC_INTERNAL void vala_gir_comment_add_content_for_parameter (ValaGirComment* self,
                                                 const gchar* name,
                                                 ValaComment* comment);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_new (ValaParameter* param,
                                                                gint array_length_idx,
                                                                gint closure_idx,
                                                                gint destroy_idx,
                                                                gboolean is_async);
static ValaGirParserParameterInfo* vala_gir_parser_parameter_info_construct (GType object_type,
                                                                      ValaParameter* param,
                                                                      gint array_length_idx,
                                                                      gint closure_idx,
                                                                      gint destroy_idx,
                                                                      gboolean is_async);
static gpointer vala_gir_parser_argument_ref (gpointer instance);
static void vala_gir_parser_argument_unref (gpointer instance);
static GParamSpec* vala_gir_parser_param_spec_argument (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED;
static void vala_gir_parser_value_set_argument (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED;
static void vala_gir_parser_value_take_argument (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_gir_parser_value_get_argument (const GValue* value) G_GNUC_UNUSED;
static GType vala_gir_parser_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gir_parser_process_interface (ValaGirParser* self,
                                        ValaGirParserNode* iface_node);
static void vala_gir_parser_process_alias (ValaGirParser* self,
                                    ValaGirParserNode* alias);
static gchar* vala_gir_parser_node_get_full_name (ValaGirParserNode* self);
static void vala_gir_parser_process_callable (ValaGirParser* self,
                                       ValaGirParserNode* node);
static void vala_gir_parser_find_parent (ValaGirParser* self,
                                  const gchar* cname,
                                  ValaGirParserNode* current,
                                  ValaGirParserNode* * best,
                                  gint* match);
static gchar* vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self);
static gboolean vala_gir_parser_same_gir (ValaGirParser* self,
                                   ValaSymbol* gir_component,
                                   ValaSymbol* sym);
static void vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                               ValaGirParserNode* ns,
                                               ValaGirParserNode* node);
static void vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                         ValaGirParserNode* node);
static void vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                                   ValaGirParserNode* node,
                                                   ValaDelegate* d,
                                                   ValaUnresolvedSymbol* gtype_struct_for);
static gchar* vala_gir_parser_node_to_string (ValaGirParserNode* self);
static ValaArrayList* vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                                const gchar* name);
static void vala_gir_parser_process_async_method (ValaGirParser* self,
                                           ValaGirParserNode* node);
static gchar* vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self);
static ValaGirParserNode* vala_gir_parser_base_interface_property (ValaGirParser* self,
                                                            ValaGirParserNode* prop_node);
static ValaGirParserArgument* vala_gir_parser_argument_new (ValaExpression* expression,
                                                     ValaSourceReference* source_reference);
static ValaGirParserArgument* vala_gir_parser_argument_construct (GType object_type,
                                                           ValaExpression* expression,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_argument_finalize (ValaGirParserArgument * obj);
static GType vala_gir_parser_metadata_set_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_new (const gchar* selector);
static ValaGirParserMetadataSet* vala_gir_parser_metadata_set_construct (GType object_type,
                                                                  const gchar* selector);
static ValaGirParserMetadata* vala_gir_parser_metadata_new (const gchar* pattern,
                                                     const gchar* selector,
                                                     ValaSourceReference* source_reference);
static ValaGirParserMetadata* vala_gir_parser_metadata_construct (GType object_type,
                                                           const gchar* pattern,
                                                           const gchar* selector,
                                                           ValaSourceReference* source_reference);
static void vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                               ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                         ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                            ValaGirParserArgumentType key,
                                            ValaGirParserArgument* value);
static void vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj);
#define VALA_GIR_PARSER_METADATA_PARSER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParserPrivate))
static ValaSourceReference* vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self);
static ValaSourceReference* vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                                              ValaSourceLocation* begin,
                                                              ValaSourceLocation* end);
static ValaTokenType vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self);
static gchar* vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                                   ValaSourceLocation* begin,
                                                   ValaSourceLocation* end);
static gchar* vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                         gboolean is_glob);
static gchar* vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self);
static ValaGirParserMetadata* vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self);
static ValaExpression* vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self);
static gboolean vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                                     ValaGirParserMetadata* metadata);
static void vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj);
static gchar* vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cprefix (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_default_cname (ValaGirParserNode* self);
static gchar* vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self);
static guint64 vala_gir_parser_node_parse_version_string (const gchar* version);
static void vala_gir_parser_node_finalize (ValaGirParserNode * obj);
static void vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj);
static void vala_gir_parser_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch7_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally7;
	__catch7_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static ValaGirParserArgumentType*
_vala_gir_parser_argument_type_dup (ValaGirParserArgumentType* self)
{
	ValaGirParserArgumentType* dup;
	dup = g_new0 (ValaGirParserArgumentType, 1);
	memcpy (dup, self, sizeof (ValaGirParserArgumentType));
	return dup;
}


static gpointer
__vala_gir_parser_argument_type_dup0 (gpointer self)
{
	return self ? _vala_gir_parser_argument_type_dup (self) : NULL;
}


static ValaGirParserArgumentType*
vala_gir_parser_argument_type_from_string (const gchar* name)
{
	ValaGirParserArgumentType* result = NULL;
	GEnumClass* enum_class = NULL;
	GTypeClass* _tmp0_;
	gchar* nick = NULL;
	gchar* _tmp1_;
	GEnumValue* enum_value = NULL;
	GEnumClass* _tmp2_;
	const gchar* _tmp3_;
	GEnumValue* _tmp4_;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_type_class_ref (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE);
	enum_class = (GEnumClass*) _tmp0_;
	_tmp1_ = string_replace (name, "_", "-");
	nick = _tmp1_;
	_tmp2_ = enum_class;
	_tmp3_ = nick;
	enum_value = g_enum_get_value_by_nick (_tmp2_, _tmp3_);
	_tmp4_ = enum_value;
	if (_tmp4_ != NULL) {
		ValaGirParserArgumentType value = 0;
		GEnumValue* _tmp5_;
		gint _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		_tmp5_ = enum_value;
		_tmp6_ = (*_tmp5_).value;
		value = (ValaGirParserArgumentType) _tmp6_;
		_tmp7_ = __vala_gir_parser_argument_type_dup0 (&value);
		result = _tmp7_;
		_g_free0 (nick);
		_g_type_class_unref0 (enum_class);
		return result;
	}
	result = NULL;
	_g_free0 (nick);
	_g_type_class_unref0 (enum_class);
	return result;
}


static GType
vala_gir_parser_argument_type_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, "VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP", "skip"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, "VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN", "hidden"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NEW, "VALA_GIR_PARSER_ARGUMENT_TYPE_NEW", "new"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE", "type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS", "type-arguments"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME", "cheader-filename"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_NAME", "name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED", "owned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, "VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED", "unowned"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT", "parent"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, "VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE", "nullable"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED", "deprecated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT, "VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT", "replacement"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE", "deprecated-since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE", "since"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY", "array"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX", "array-length-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED", "array-null-terminated"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT, "VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT", "default"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, "VALA_GIR_PARSER_ARGUMENT_TYPE_OUT", "out"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_REF, "VALA_GIR_PARSER_ARGUMENT_TYPE_REF", "ref"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME", "vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL", "virtual"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, "VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT", "abstract"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE", "scope"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, "VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT", "struct"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS, "VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS", "throws"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, "VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT", "printf-format"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD, "VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD", "array-length-field"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL, "VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL", "sentinel"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE", "closure"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY", "destroy"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX", "cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX", "lower-case-cprefix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, "VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN", "errordomain"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE", "destroys-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE", "base-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME", "finish-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE", "finish-instance"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE", "symbol-type"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX, "VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX", "instance-idx"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, "VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL", "experimental"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO, "VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO", "feature-test-macro"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, "VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING", "floating"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID, "VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID", "type-id"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID", "return-void"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, "VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER", "returns-modified-pointer"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME", "delegate-target-cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME", "finish-vfunc-name"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, "VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD", "no-accessor-method"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME, "VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME", "cname"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, "VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET", "delegate-target"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX, "VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX", "lower-case-csuffix"}, {VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE, "VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE", "ctype"}, {0, NULL, NULL}};
		GType vala_gir_parser_argument_type_type_id;
		vala_gir_parser_argument_type_type_id = g_enum_register_static ("ValaGirParserArgumentType", values);
		g_once_init_leave (&vala_gir_parser_argument_type_type_id__volatile, vala_gir_parser_argument_type_type_id);
	}
	return vala_gir_parser_argument_type_type_id__volatile;
}


static guint
_vala_gir_parser_unresolved_symbol_hash_ghash_func (gconstpointer key)
{
	guint result;
	result = vala_gir_parser_unresolved_symbol_hash ((ValaUnresolvedSymbol*) key);
	return result;
}


static gboolean
_vala_gir_parser_unresolved_symbol_equal_gequal_func (gconstpointer a,
                                                      gconstpointer b)
{
	gboolean result;
	result = vala_gir_parser_unresolved_symbol_equal ((ValaUnresolvedSymbol*) a, (ValaUnresolvedSymbol*) b);
	return result;
}


/**
 * Parses all .gir source files in the specified code
 * context and builds a code tree.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_gir_parser_node_ref0 (gpointer self)
{
	return self ? vala_gir_parser_node_ref (self) : NULL;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


void
vala_gir_parser_parse (ValaGirParser* self,
                       ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaNamespace* _tmp3_;
	ValaNamespace* _tmp4_;
	ValaSymbol* _tmp5_;
	GEqualFunc _tmp6_;
	ValaArrayList* _tmp7_;
	ValaGirParserNode* _tmp8_;
	ValaGirParserNode* _tmp9_;
	ValaGirParserNode* _tmp10_;
	ValaNamespace* glib_ns = NULL;
	ValaNamespace* _tmp11_;
	ValaNamespace* _tmp12_;
	ValaScope* _tmp13_;
	ValaScope* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaNamespace* _tmp16_;
	ValaNamespace* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_gir_parser_node_new (NULL);
	_vala_gir_parser_node_unref0 (self->priv->root);
	self->priv->root = _tmp1_;
	_tmp2_ = self->priv->root;
	_tmp3_ = vala_code_context_get_root (context);
	_tmp4_ = _tmp3_;
	_tmp5_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp4_);
	_vala_code_node_unref0 (_tmp2_->symbol);
	_tmp2_->symbol = _tmp5_;
	_tmp6_ = g_direct_equal;
	_tmp7_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp6_);
	_vala_iterable_unref0 (self->priv->tree_stack);
	self->priv->tree_stack = _tmp7_;
	_tmp8_ = self->priv->root;
	_tmp9_ = _vala_gir_parser_node_ref0 (_tmp8_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp9_;
	vala_gir_parser_map_vala_to_gir (self);
	vala_code_context_accept (context, (ValaCodeVisitor*) self);
	vala_gir_parser_resolve_gir_symbols (self);
	vala_gir_parser_create_new_namespaces (self);
	vala_gir_parser_resolve_type_arguments (self);
	_tmp10_ = self->priv->root;
	vala_gir_parser_node_process (_tmp10_, self);
	_tmp11_ = vala_code_context_get_root (context);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_symbol_get_scope ((ValaSymbol*) _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_scope_lookup (_tmp14_, "GLib");
	_tmp16_ = VALA_IS_NAMESPACE (_tmp15_) ? ((ValaNamespace*) _tmp15_) : NULL;
	if (_tmp16_ == NULL) {
		_vala_code_node_unref0 (_tmp15_);
	}
	glib_ns = _tmp16_;
	_tmp17_ = glib_ns;
	if (_tmp17_ != NULL) {
		ValaClass* object_type = NULL;
		ValaNamespace* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaSymbol* _tmp21_;
		_tmp18_ = glib_ns;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_scope_lookup (_tmp20_, "Object");
		object_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_CLASS, ValaClass);
		{
			ValaArrayList* _iface_list = NULL;
			ValaArrayList* _tmp22_;
			ValaArrayList* _tmp23_;
			gint _iface_size = 0;
			ValaArrayList* _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			gint _iface_index = 0;
			_tmp22_ = self->priv->ifaces_needing_object_prereq;
			_tmp23_ = _vala_iterable_ref0 (_tmp22_);
			_iface_list = _tmp23_;
			_tmp24_ = _iface_list;
			_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
			_tmp26_ = _tmp25_;
			_iface_size = _tmp26_;
			_iface_index = -1;
			while (TRUE) {
				gint _tmp27_;
				gint _tmp28_;
				ValaInterface* iface = NULL;
				ValaArrayList* _tmp29_;
				gint _tmp30_;
				gpointer _tmp31_;
				ValaInterface* _tmp32_;
				ValaClass* _tmp33_;
				ValaObjectType* _tmp34_;
				ValaObjectType* _tmp35_;
				_iface_index = _iface_index + 1;
				_tmp27_ = _iface_index;
				_tmp28_ = _iface_size;
				if (!(_tmp27_ < _tmp28_)) {
					break;
				}
				_tmp29_ = _iface_list;
				_tmp30_ = _iface_index;
				_tmp31_ = vala_list_get ((ValaList*) _tmp29_, _tmp30_);
				iface = (ValaInterface*) _tmp31_;
				_tmp32_ = iface;
				_tmp33_ = object_type;
				_tmp34_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp33_);
				_tmp35_ = _tmp34_;
				vala_interface_add_prerequisite (_tmp32_, (ValaDataType*) _tmp35_);
				_vala_code_node_unref0 (_tmp35_);
				_vala_code_node_unref0 (iface);
			}
			_vala_iterable_unref0 (_iface_list);
		}
		_vala_code_node_unref0 (object_type);
	}
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp36_;
		ValaArrayList* _tmp37_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _metadata_index = 0;
		_tmp36_ = self->priv->metadata_roots;
		_tmp37_ = _vala_iterable_ref0 (_tmp36_);
		_metadata_list = _tmp37_;
		_tmp38_ = _metadata_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_metadata_size = _tmp40_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			ValaGirParserMetadata* _tmp46_;
			_metadata_index = _metadata_index + 1;
			_tmp41_ = _metadata_index;
			_tmp42_ = _metadata_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _metadata_list;
			_tmp44_ = _metadata_index;
			_tmp45_ = vala_list_get ((ValaList*) _tmp43_, _tmp44_);
			metadata = (ValaGirParserMetadata*) _tmp45_;
			_tmp46_ = metadata;
			vala_gir_parser_report_unused_metadata (self, _tmp46_);
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_code_node_unref0 (glib_ns);
}


static void
vala_gir_parser_map_vala_to_gir (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaList* _source_file_list = NULL;
		ValaCodeContext* _tmp0_;
		ValaList* _tmp1_;
		gint _source_file_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _source_file_index = 0;
		_tmp0_ = self->priv->context;
		_tmp1_ = vala_code_context_get_source_files (_tmp0_);
		_source_file_list = _tmp1_;
		_tmp2_ = _source_file_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_source_file_size = _tmp4_;
		_source_file_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaSourceFile* source_file = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			gchar* gir_namespace = NULL;
			ValaSourceFile* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* gir_version = NULL;
			ValaSourceFile* _tmp14_;
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			gchar* _tmp17_;
			ValaNamespace* ns = NULL;
			const gchar* _tmp18_;
			const gchar* _tmp37_;
			ValaSet* _tmp38_;
			const gchar* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			ValaUnresolvedSymbol* gir_symbol = NULL;
			const gchar* _tmp43_;
			ValaUnresolvedSymbol* _tmp44_;
			const gchar* _tmp45_;
			ValaNamespace* _tmp46_;
			const gchar* _tmp47_;
			const gchar* _tmp48_;
			_source_file_index = _source_file_index + 1;
			_tmp5_ = _source_file_index;
			_tmp6_ = _source_file_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _source_file_list;
			_tmp8_ = _source_file_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			source_file = (ValaSourceFile*) _tmp9_;
			_tmp10_ = source_file;
			_tmp11_ = vala_source_file_get_gir_namespace (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			gir_namespace = _tmp13_;
			_tmp14_ = source_file;
			_tmp15_ = vala_source_file_get_gir_version (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = g_strdup (_tmp16_);
			gir_version = _tmp17_;
			ns = NULL;
			_tmp18_ = gir_namespace;
			if (_tmp18_ == NULL) {
				{
					ValaList* _node_list = NULL;
					ValaSourceFile* _tmp19_;
					ValaList* _tmp20_;
					gint _node_size = 0;
					ValaList* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					gint _node_index = 0;
					_tmp19_ = source_file;
					_tmp20_ = vala_source_file_get_nodes (_tmp19_);
					_node_list = _tmp20_;
					_tmp21_ = _node_list;
					_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
					_tmp23_ = _tmp22_;
					_node_size = _tmp23_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp24_;
						gint _tmp25_;
						ValaCodeNode* node = NULL;
						ValaList* _tmp26_;
						gint _tmp27_;
						gpointer _tmp28_;
						ValaCodeNode* _tmp29_;
						_node_index = _node_index + 1;
						_tmp24_ = _node_index;
						_tmp25_ = _node_size;
						if (!(_tmp24_ < _tmp25_)) {
							break;
						}
						_tmp26_ = _node_list;
						_tmp27_ = _node_index;
						_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
						node = (ValaCodeNode*) _tmp28_;
						_tmp29_ = node;
						if (VALA_IS_NAMESPACE (_tmp29_)) {
							ValaCodeNode* _tmp30_;
							ValaNamespace* _tmp31_;
							ValaNamespace* _tmp32_;
							gchar* _tmp33_;
							const gchar* _tmp34_;
							_tmp30_ = node;
							_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_NAMESPACE, ValaNamespace));
							_vala_code_node_unref0 (ns);
							ns = _tmp31_;
							_tmp32_ = ns;
							_tmp33_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp32_, "CCode", "gir_namespace", NULL);
							_g_free0 (gir_namespace);
							gir_namespace = _tmp33_;
							_tmp34_ = gir_namespace;
							if (_tmp34_ != NULL) {
								ValaNamespace* _tmp35_;
								gchar* _tmp36_;
								_tmp35_ = ns;
								_tmp36_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp35_, "CCode", "gir_version", NULL);
								_g_free0 (gir_version);
								gir_version = _tmp36_;
								_vala_code_node_unref0 (node);
								break;
							}
						}
						_vala_code_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
			}
			_tmp37_ = gir_namespace;
			if (_tmp37_ == NULL) {
				_vala_code_node_unref0 (ns);
				_g_free0 (gir_version);
				_g_free0 (gir_namespace);
				_vala_source_file_unref0 (source_file);
				continue;
			}
			_tmp38_ = self->priv->provided_namespaces;
			_tmp39_ = gir_namespace;
			_tmp40_ = gir_version;
			_tmp41_ = g_strdup_printf ("%s-%s", _tmp39_, _tmp40_);
			_tmp42_ = _tmp41_;
			vala_collection_add ((ValaCollection*) _tmp38_, _tmp42_);
			_g_free0 (_tmp42_);
			_tmp43_ = gir_namespace;
			_tmp44_ = vala_unresolved_symbol_new (NULL, _tmp43_, NULL);
			gir_symbol = _tmp44_;
			_tmp45_ = gir_namespace;
			_tmp46_ = ns;
			_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
			_tmp48_ = _tmp47_;
			if (g_strcmp0 (_tmp45_, _tmp48_) != 0) {
				ValaUnresolvedSymbol* _tmp49_;
				ValaNamespace* _tmp50_;
				_tmp49_ = gir_symbol;
				_tmp50_ = ns;
				vala_gir_parser_set_symbol_mapping (self, _tmp49_, (ValaSymbol*) _tmp50_);
			}
			{
				ValaList* _node_list = NULL;
				ValaSourceFile* _tmp51_;
				ValaList* _tmp52_;
				gint _node_size = 0;
				ValaList* _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
				gint _node_index = 0;
				_tmp51_ = source_file;
				_tmp52_ = vala_source_file_get_nodes (_tmp51_);
				_node_list = _tmp52_;
				_tmp53_ = _node_list;
				_tmp54_ = vala_collection_get_size ((ValaCollection*) _tmp53_);
				_tmp55_ = _tmp54_;
				_node_size = _tmp55_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp56_;
					gint _tmp57_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp58_;
					gint _tmp59_;
					gpointer _tmp60_;
					ValaCodeNode* _tmp61_;
					_node_index = _node_index + 1;
					_tmp56_ = _node_index;
					_tmp57_ = _node_size;
					if (!(_tmp56_ < _tmp57_)) {
						break;
					}
					_tmp58_ = _node_list;
					_tmp59_ = _node_index;
					_tmp60_ = vala_list_get (_tmp58_, _tmp59_);
					node = (ValaCodeNode*) _tmp60_;
					_tmp61_ = node;
					if (vala_code_node_has_attribute_argument (_tmp61_, "GIR", "name")) {
						ValaUnresolvedSymbol* map_from = NULL;
						ValaUnresolvedSymbol* _tmp62_;
						ValaCodeNode* _tmp63_;
						gchar* _tmp64_;
						gchar* _tmp65_;
						ValaUnresolvedSymbol* _tmp66_;
						ValaUnresolvedSymbol* _tmp67_;
						ValaUnresolvedSymbol* _tmp68_;
						ValaCodeNode* _tmp69_;
						_tmp62_ = gir_symbol;
						_tmp63_ = node;
						_tmp64_ = vala_code_node_get_attribute_string (_tmp63_, "GIR", "name", NULL);
						_tmp65_ = _tmp64_;
						_tmp66_ = vala_unresolved_symbol_new (_tmp62_, _tmp65_, NULL);
						_tmp67_ = _tmp66_;
						_g_free0 (_tmp65_);
						map_from = _tmp67_;
						_tmp68_ = map_from;
						_tmp69_ = node;
						vala_gir_parser_set_symbol_mapping (self, _tmp68_, G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_SYMBOL, ValaSymbol));
						_vala_code_node_unref0 (map_from);
					}
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_vala_code_node_unref0 (gir_symbol);
			_vala_code_node_unref0 (ns);
			_g_free0 (gir_version);
			_g_free0 (gir_namespace);
			_vala_source_file_unref0 (source_file);
		}
		_vala_iterable_unref0 (_source_file_list);
	}
}


static void
vala_gir_parser_real_visit_source_file (ValaCodeVisitor* base,
                                        ValaSourceFile* source_file)
{
	ValaGirParser * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	self = (ValaGirParser*) base;
	g_return_if_fail (source_file != NULL);
	_tmp0_ = vala_source_file_get_filename (source_file);
	_tmp1_ = _tmp0_;
	if (g_str_has_suffix (_tmp1_, ".gir")) {
		vala_gir_parser_parse_file (self, source_file);
	}
}


static gpointer
_vala_gir_parser_metadata_ref0 (gpointer self)
{
	return self ? vala_gir_parser_metadata_ref (self) : NULL;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


void
vala_gir_parser_parse_file (ValaGirParser* self,
                            ValaSourceFile* source_file)
{
	gboolean has_global_context = FALSE;
	ValaCodeContext* _tmp0_;
	gboolean _tmp1_;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaGirParserMetadata* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaGirParserMetadata* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	ValaMarkupReader* _tmp13_;
	gboolean _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source_file != NULL);
	_tmp0_ = self->priv->context;
	has_global_context = _tmp0_ != NULL;
	_tmp1_ = has_global_context;
	if (!_tmp1_) {
		ValaCodeContext* _tmp2_;
		ValaCodeContext* _tmp3_;
		ValaCodeContext* _tmp4_;
		_tmp2_ = vala_source_file_get_context (source_file);
		_tmp3_ = _tmp2_;
		_tmp4_ = _vala_code_context_ref0 (_tmp3_);
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = _tmp4_;
	}
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp5_);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	self->priv->metadata_stack = _tmp6_;
	_tmp7_ = vala_gir_parser_metadata_get_empty ();
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_gir_parser_metadata_ref0 (_tmp8_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp9_;
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	self->priv->cheader_filenames = NULL;
	self->priv->cheader_filenames_length1 = 0;
	self->priv->_cheader_filenames_size_ = self->priv->cheader_filenames_length1;
	_tmp10_ = _vala_source_file_ref0 (source_file);
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = _tmp10_;
	_tmp11_ = vala_source_file_get_filename (source_file);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_markup_reader_new (_tmp12_);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = _tmp13_;
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_next (self);
	vala_gir_parser_parse_repository (self);
	_vala_markup_reader_unref0 (self->priv->reader);
	self->priv->reader = NULL;
	_vala_source_file_unref0 (self->priv->current_source_file);
	self->priv->current_source_file = NULL;
	_tmp14_ = has_global_context;
	if (!_tmp14_) {
		_vala_code_context_unref0 (self->priv->context);
		self->priv->context = NULL;
	}
}


static void
vala_gir_parser_next (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	ValaSourceLocation _tmp1_ = {0};
	ValaSourceLocation _tmp2_ = {0};
	ValaMarkupTokenType _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_read_token (_tmp0_, &_tmp1_, &_tmp2_);
	self->priv->begin = _tmp1_;
	self->priv->end = _tmp2_;
	self->priv->current_token = _tmp3_;
}


static void
vala_gir_parser_start_element (ValaGirParser* self,
                               const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	ValaMarkupTokenType _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->current_token;
	if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaMarkupReader* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_name (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected start element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
	}
}


static void
vala_gir_parser_end_element (ValaGirParser* self,
                             const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		ValaMarkupTokenType _tmp1_;
		ValaSourceReference* _tmp5_;
		ValaSourceReference* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ != VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
			_tmp0_ = TRUE;
		} else {
			ValaMarkupReader* _tmp2_;
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			_tmp2_ = self->priv->reader;
			_tmp3_ = vala_markup_reader_get_name (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp0_ = g_strcmp0 (_tmp4_, name) != 0;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = vala_gir_parser_get_current_src (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf ("expected end element of `%s'", name);
		_tmp8_ = _tmp7_;
		vala_report_warning (_tmp6_, _tmp8_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp6_);
		vala_gir_parser_skip_element (self);
	}
	vala_gir_parser_next (self);
}


static ValaSourceReference*
vala_gir_parser_get_current_src (ValaGirParser* self)
{
	ValaSourceReference* result = NULL;
	ValaSourceFile* _tmp0_;
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceReference* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_source_file;
	_tmp1_ = self->priv->begin;
	_tmp2_ = self->priv->end;
	_tmp3_ = vala_source_reference_new (_tmp0_, &_tmp1_, &_tmp2_);
	result = _tmp3_;
	return result;
}


static ValaSourceReference*
vala_gir_parser_get_src (ValaGirParser* self,
                         ValaSourceLocation* begin,
                         ValaSourceLocation* end)
{
	ValaSourceReference* result = NULL;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceLocation _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceReference* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->current_source_file;
	_tmp2_ = *begin;
	_tmp3_ = e;
	_tmp4_ = vala_source_reference_new (_tmp1_, &_tmp2_, &_tmp3_);
	result = _tmp4_;
	return result;
}


static void
vala_gir_parser_add_symbol_to_container (ValaSymbol* container,
                                         ValaSymbol* sym)
{
	g_return_if_fail (container != NULL);
	g_return_if_fail (sym != NULL);
	if (VALA_IS_CLASS (container)) {
		ValaClass* cl = NULL;
		cl = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_CLASS, ValaClass);
		if (VALA_IS_CLASS (sym)) {
			ValaClass* _tmp0_;
			_tmp0_ = cl;
			vala_symbol_add_class ((ValaSymbol*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
		} else {
			if (VALA_IS_CONSTANT (sym)) {
				ValaClass* _tmp1_;
				_tmp1_ = cl;
				vala_symbol_add_constant ((ValaSymbol*) _tmp1_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
			} else {
				if (VALA_IS_ENUM (sym)) {
					ValaClass* _tmp2_;
					_tmp2_ = cl;
					vala_symbol_add_enum ((ValaSymbol*) _tmp2_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
				} else {
					if (VALA_IS_FIELD (sym)) {
						ValaClass* _tmp3_;
						_tmp3_ = cl;
						vala_symbol_add_field ((ValaSymbol*) _tmp3_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
					} else {
						if (VALA_IS_METHOD (sym)) {
							ValaClass* _tmp4_;
							_tmp4_ = cl;
							vala_symbol_add_method ((ValaSymbol*) _tmp4_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
						} else {
							if (VALA_IS_PROPERTY (sym)) {
								ValaClass* _tmp5_;
								_tmp5_ = cl;
								vala_symbol_add_property ((ValaSymbol*) _tmp5_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
							} else {
								if (VALA_IS_SIGNAL (sym)) {
									ValaClass* _tmp6_;
									_tmp6_ = cl;
									vala_symbol_add_signal ((ValaSymbol*) _tmp6_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
								} else {
									if (VALA_IS_STRUCT (sym)) {
										ValaClass* _tmp7_;
										_tmp7_ = cl;
										vala_symbol_add_struct ((ValaSymbol*) _tmp7_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
									}
								}
							}
						}
					}
				}
			}
		}
	} else {
		if (VALA_IS_ENUM (container)) {
			ValaEnum* en = NULL;
			en = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ENUM, ValaEnum);
			if (VALA_IS_ENUM_VALUE (sym)) {
				ValaEnum* _tmp8_;
				_tmp8_ = en;
				vala_enum_add_value (_tmp8_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM_VALUE, ValaEnumValue));
			} else {
				if (VALA_IS_CONSTANT (sym)) {
					ValaEnum* _tmp9_;
					_tmp9_ = en;
					vala_symbol_add_constant ((ValaSymbol*) _tmp9_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
				} else {
					if (VALA_IS_METHOD (sym)) {
						ValaEnum* _tmp10_;
						_tmp10_ = en;
						vala_symbol_add_method ((ValaSymbol*) _tmp10_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
					}
				}
			}
		} else {
			if (VALA_IS_INTERFACE (container)) {
				ValaInterface* iface = NULL;
				iface = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_INTERFACE, ValaInterface);
				if (VALA_IS_CLASS (sym)) {
					ValaInterface* _tmp11_;
					_tmp11_ = iface;
					vala_symbol_add_class ((ValaSymbol*) _tmp11_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
				} else {
					if (VALA_IS_CONSTANT (sym)) {
						ValaInterface* _tmp12_;
						_tmp12_ = iface;
						vala_symbol_add_constant ((ValaSymbol*) _tmp12_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
					} else {
						if (VALA_IS_ENUM (sym)) {
							ValaInterface* _tmp13_;
							_tmp13_ = iface;
							vala_symbol_add_enum ((ValaSymbol*) _tmp13_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaInterface* _tmp14_;
								_tmp14_ = iface;
								vala_symbol_add_field ((ValaSymbol*) _tmp14_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaInterface* _tmp15_;
									_tmp15_ = iface;
									vala_symbol_add_method ((ValaSymbol*) _tmp15_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaInterface* _tmp16_;
										_tmp16_ = iface;
										vala_symbol_add_property ((ValaSymbol*) _tmp16_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									} else {
										if (VALA_IS_SIGNAL (sym)) {
											ValaInterface* _tmp17_;
											_tmp17_ = iface;
											vala_symbol_add_signal ((ValaSymbol*) _tmp17_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_SIGNAL, ValaSignal));
										} else {
											if (VALA_IS_STRUCT (sym)) {
												ValaInterface* _tmp18_;
												_tmp18_ = iface;
												vala_symbol_add_struct ((ValaSymbol*) _tmp18_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
											}
										}
									}
								}
							}
						}
					}
				}
			} else {
				if (VALA_IS_NAMESPACE (container)) {
					ValaNamespace* ns = NULL;
					ns = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_NAMESPACE, ValaNamespace);
					if (VALA_IS_NAMESPACE (sym)) {
						ValaNamespace* _tmp19_;
						_tmp19_ = ns;
						vala_symbol_add_namespace ((ValaSymbol*) _tmp19_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_NAMESPACE, ValaNamespace));
					} else {
						if (VALA_IS_CLASS (sym)) {
							ValaNamespace* _tmp20_;
							_tmp20_ = ns;
							vala_symbol_add_class ((ValaSymbol*) _tmp20_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CLASS, ValaClass));
						} else {
							if (VALA_IS_CONSTANT (sym)) {
								ValaNamespace* _tmp21_;
								_tmp21_ = ns;
								vala_symbol_add_constant ((ValaSymbol*) _tmp21_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
							} else {
								if (VALA_IS_DELEGATE (sym)) {
									ValaNamespace* _tmp22_;
									_tmp22_ = ns;
									vala_symbol_add_delegate ((ValaSymbol*) _tmp22_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_DELEGATE, ValaDelegate));
								} else {
									if (VALA_IS_ENUM (sym)) {
										ValaNamespace* _tmp23_;
										_tmp23_ = ns;
										vala_symbol_add_enum ((ValaSymbol*) _tmp23_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ENUM, ValaEnum));
									} else {
										if (VALA_IS_ERROR_DOMAIN (sym)) {
											ValaNamespace* _tmp24_;
											_tmp24_ = ns;
											vala_symbol_add_error_domain ((ValaSymbol*) _tmp24_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain));
										} else {
											if (VALA_IS_FIELD (sym)) {
												ValaNamespace* _tmp25_;
												_tmp25_ = ns;
												vala_symbol_add_field ((ValaSymbol*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
											} else {
												if (VALA_IS_INTERFACE (sym)) {
													ValaNamespace* _tmp26_;
													_tmp26_ = ns;
													vala_symbol_add_interface ((ValaSymbol*) _tmp26_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_INTERFACE, ValaInterface));
												} else {
													if (VALA_IS_METHOD (sym)) {
														ValaNamespace* _tmp27_;
														_tmp27_ = ns;
														vala_symbol_add_method ((ValaSymbol*) _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
													} else {
														if (VALA_IS_STRUCT (sym)) {
															ValaNamespace* _tmp28_;
															_tmp28_ = ns;
															vala_symbol_add_struct ((ValaSymbol*) _tmp28_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_STRUCT, ValaStruct));
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				} else {
					if (VALA_IS_STRUCT (container)) {
						ValaStruct* st = NULL;
						st = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_STRUCT, ValaStruct);
						if (VALA_IS_CONSTANT (sym)) {
							ValaStruct* _tmp29_;
							_tmp29_ = st;
							vala_symbol_add_constant ((ValaSymbol*) _tmp29_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CONSTANT, ValaConstant));
						} else {
							if (VALA_IS_FIELD (sym)) {
								ValaStruct* _tmp30_;
								_tmp30_ = st;
								vala_symbol_add_field ((ValaSymbol*) _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_FIELD, ValaField));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaStruct* _tmp31_;
									_tmp31_ = st;
									vala_symbol_add_method ((ValaSymbol*) _tmp31_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								} else {
									if (VALA_IS_PROPERTY (sym)) {
										ValaStruct* _tmp32_;
										_tmp32_ = st;
										vala_symbol_add_property ((ValaSymbol*) _tmp32_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_PROPERTY, ValaProperty));
									}
								}
							}
						}
					} else {
						if (VALA_IS_ERROR_DOMAIN (container)) {
							ValaErrorDomain* ed = NULL;
							ed = G_TYPE_CHECK_INSTANCE_CAST (container, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain);
							if (VALA_IS_ERROR_CODE (sym)) {
								ValaErrorDomain* _tmp33_;
								_tmp33_ = ed;
								vala_error_domain_add_code (_tmp33_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_ERROR_CODE, ValaErrorCode));
							} else {
								if (VALA_IS_METHOD (sym)) {
									ValaErrorDomain* _tmp34_;
									_tmp34_ = ed;
									vala_symbol_add_method ((ValaSymbol*) _tmp34_, G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_METHOD, ValaMethod));
								}
							}
						} else {
							ValaSourceReference* _tmp35_;
							ValaSourceReference* _tmp36_;
							const gchar* _tmp37_;
							const gchar* _tmp38_;
							const gchar* _tmp39_;
							const gchar* _tmp40_;
							gchar* _tmp41_;
							gchar* _tmp42_;
							_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
							_tmp36_ = _tmp35_;
							_tmp37_ = vala_symbol_get_name (sym);
							_tmp38_ = _tmp37_;
							_tmp39_ = vala_symbol_get_name (container);
							_tmp40_ = _tmp39_;
							_tmp41_ = g_strdup_printf ("impossible to add `%s' to container `%s'", _tmp38_, _tmp40_);
							_tmp42_ = _tmp41_;
							vala_report_error (_tmp36_, _tmp42_);
							_g_free0 (_tmp42_);
						}
					}
				}
			}
		}
	}
}


static gboolean
vala_gir_parser_is_container (ValaSymbol* sym)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_val_if_fail (sym != NULL, FALSE);
	if (VALA_IS_OBJECT_TYPE_SYMBOL (sym)) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = VALA_IS_STRUCT (sym);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = VALA_IS_NAMESPACE (sym);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = VALA_IS_ERROR_DOMAIN (sym);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_ENUM (sym);
	}
	result = _tmp0_;
	return result;
}


static ValaUnresolvedSymbol*
vala_gir_parser_parse_symbol_from_string (ValaGirParser* self,
                                          const gchar* symbol_string,
                                          ValaSourceReference* source_reference)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaUnresolvedSymbol* sym = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	ValaUnresolvedSymbol* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (symbol_string != NULL, NULL);
	sym = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (symbol_string, ".", 0);
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp1_;
		s_collection_length1 = _vala_array_length (_tmp0_);
		for (s_it = 0; s_it < s_collection_length1; s_it = s_it + 1) {
			const gchar* s = NULL;
			s = s_collection[s_it];
			{
				ValaUnresolvedSymbol* _tmp2_;
				const gchar* _tmp3_;
				ValaUnresolvedSymbol* _tmp4_;
				_tmp2_ = sym;
				_tmp3_ = s;
				_tmp4_ = vala_unresolved_symbol_new (_tmp2_, _tmp3_, source_reference);
				_vala_code_node_unref0 (sym);
				sym = _tmp4_;
			}
		}
		s_collection = (_vala_array_free (s_collection, s_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp5_ = sym;
	if (_tmp5_ == NULL) {
		vala_report_error (source_reference, "a symbol must be specified");
	}
	result = sym;
	return result;
}


static void
vala_gir_parser_set_symbol_mapping (ValaGirParser* self,
                                    ValaUnresolvedSymbol* map_from,
                                    ValaSymbol* map_to)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (map_from != NULL);
	g_return_if_fail (map_to != NULL);
	if (VALA_IS_UNRESOLVED_SYMBOL (map_from)) {
		ValaHashMap* _tmp0_;
		_tmp0_ = self->priv->unresolved_symbols_map;
		vala_map_set ((ValaMap*) _tmp0_, G_TYPE_CHECK_INSTANCE_CAST (map_from, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol), map_to);
	}
}


static void
vala_gir_parser_assume_parameter_names (ValaGirParser* self,
                                        ValaSignal* sig,
                                        ValaSymbol* sym,
                                        gboolean skip_first)
{
	ValaIterator* iter = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	ValaIterator* _tmp2_;
	ValaIterator* _tmp3_;
	gboolean first = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (sym != NULL);
	_tmp0_ = vala_callable_get_parameters (G_TYPE_CHECK_INSTANCE_CAST (sym, VALA_TYPE_CALLABLE, ValaCallable));
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_iterable_unref0 (_tmp1_);
	iter = _tmp3_;
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp4_;
		gint _param_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _param_index = 0;
		_tmp4_ = vala_callable_get_parameters ((ValaCallable*) sig);
		_param_list = _tmp4_;
		_tmp5_ = _param_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_param_size = _tmp7_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaParameter* param = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaIterator* _tmp13_;
			gboolean _tmp14_ = FALSE;
			ValaParameter* _tmp17_;
			ValaIterator* _tmp18_;
			gpointer _tmp19_;
			ValaParameter* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			_param_index = _param_index + 1;
			_tmp8_ = _param_index;
			_tmp9_ = _param_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _param_list;
			_tmp11_ = _param_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			param = (ValaParameter*) _tmp12_;
			_tmp13_ = iter;
			if (!vala_iterator_next (_tmp13_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			if (skip_first) {
				gboolean _tmp15_;
				_tmp15_ = first;
				_tmp14_ = _tmp15_;
			} else {
				_tmp14_ = FALSE;
			}
			if (_tmp14_) {
				ValaIterator* _tmp16_;
				_tmp16_ = iter;
				if (!vala_iterator_next (_tmp16_)) {
					_vala_code_node_unref0 (param);
					break;
				}
				first = FALSE;
			}
			_tmp17_ = param;
			_tmp18_ = iter;
			_tmp19_ = vala_iterator_get (_tmp18_);
			_tmp20_ = (ValaParameter*) _tmp19_;
			_tmp21_ = vala_symbol_get_name ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			vala_symbol_set_name ((ValaSymbol*) _tmp17_, _tmp22_);
			_vala_code_node_unref0 (_tmp20_);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_vala_iterator_unref0 (iter);
}


static ValaGirParserNode*
vala_gir_parser_find_invoker (ValaGirParser* self,
                              ValaGirParserNode* node)
{
	ValaGirParserNode* result = NULL;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gchar* prefix = NULL;
	ValaMethod* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	_tmp2_ = m;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_", _tmp4_);
	prefix = _tmp5_;
	{
		ValaArrayList* _n_list = NULL;
		ValaGirParserNode* _tmp6_;
		ValaArrayList* _tmp7_;
		ValaArrayList* _tmp8_;
		gint _n_size = 0;
		ValaArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _n_index = 0;
		_tmp6_ = node->parent;
		_tmp7_ = _tmp6_->members;
		_tmp8_ = _vala_iterable_ref0 (_tmp7_);
		_n_list = _tmp8_;
		_tmp9_ = _n_list;
		_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_n_size = _tmp11_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaGirParserNode* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			ValaMethod* invoker = NULL;
			ValaGirParserNode* _tmp20_;
			ValaSymbol* _tmp21_;
			ValaMethod* _tmp22_;
			gboolean _tmp23_ = FALSE;
			ValaMethod* _tmp24_;
			ValaIterator* iter = NULL;
			ValaMethod* _tmp35_;
			ValaList* _tmp36_;
			ValaList* _tmp37_;
			ValaIterator* _tmp38_;
			ValaIterator* _tmp39_;
			ValaMethod* _tmp60_;
			_n_index = _n_index + 1;
			_tmp12_ = _n_index;
			_tmp13_ = _n_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _n_list;
			_tmp15_ = _n_index;
			_tmp16_ = vala_list_get ((ValaList*) _tmp14_, _tmp15_);
			n = (ValaGirParserNode*) _tmp16_;
			_tmp17_ = n;
			_tmp18_ = _tmp17_->name;
			_tmp19_ = prefix;
			if (!g_str_has_prefix (_tmp18_, _tmp19_)) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp20_ = n;
			_tmp21_ = _tmp20_->symbol;
			_tmp22_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp21_) ? ((ValaMethod*) _tmp21_) : NULL);
			invoker = _tmp22_;
			_tmp24_ = invoker;
			if (_tmp24_ == NULL) {
				_tmp23_ = TRUE;
			} else {
				ValaMethod* _tmp25_;
				ValaList* _tmp26_;
				ValaList* _tmp27_;
				gint _tmp28_;
				gint _tmp29_;
				ValaMethod* _tmp30_;
				ValaList* _tmp31_;
				ValaList* _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				_tmp25_ = m;
				_tmp26_ = vala_callable_get_parameters ((ValaCallable*) _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = invoker;
				_tmp31_ = vala_callable_get_parameters ((ValaCallable*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
				_tmp34_ = _tmp33_;
				_tmp23_ = _tmp29_ != _tmp34_;
				_vala_iterable_unref0 (_tmp32_);
				_vala_iterable_unref0 (_tmp27_);
			}
			if (_tmp23_) {
				_vala_code_node_unref0 (invoker);
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp35_ = invoker;
			_tmp36_ = vala_callable_get_parameters ((ValaCallable*) _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = vala_iterable_iterator ((ValaIterable*) _tmp37_);
			_tmp39_ = _tmp38_;
			_vala_iterable_unref0 (_tmp37_);
			iter = _tmp39_;
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp40_;
				ValaList* _tmp41_;
				gint _param_size = 0;
				ValaList* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				gint _param_index = 0;
				_tmp40_ = m;
				_tmp41_ = vala_callable_get_parameters ((ValaCallable*) _tmp40_);
				_param_list = _tmp41_;
				_tmp42_ = _param_list;
				_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
				_tmp44_ = _tmp43_;
				_param_size = _tmp44_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp45_;
					gint _tmp46_;
					ValaParameter* param = NULL;
					ValaList* _tmp47_;
					gint _tmp48_;
					gpointer _tmp49_;
					ValaIterator* _tmp50_;
					ValaParameter* _tmp51_;
					const gchar* _tmp52_;
					const gchar* _tmp53_;
					ValaIterator* _tmp54_;
					gpointer _tmp55_;
					ValaParameter* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					gboolean _tmp59_;
					_param_index = _param_index + 1;
					_tmp45_ = _param_index;
					_tmp46_ = _param_size;
					if (!(_tmp45_ < _tmp46_)) {
						break;
					}
					_tmp47_ = _param_list;
					_tmp48_ = _param_index;
					_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
					param = (ValaParameter*) _tmp49_;
					_tmp50_ = iter;
					_vala_assert (vala_iterator_next (_tmp50_), "iter.next ()");
					_tmp51_ = param;
					_tmp52_ = vala_symbol_get_name ((ValaSymbol*) _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = iter;
					_tmp55_ = vala_iterator_get (_tmp54_);
					_tmp56_ = (ValaParameter*) _tmp55_;
					_tmp57_ = vala_symbol_get_name ((ValaSymbol*) _tmp56_);
					_tmp58_ = _tmp57_;
					_tmp59_ = g_strcmp0 (_tmp53_, _tmp58_) != 0;
					_vala_code_node_unref0 (_tmp56_);
					if (_tmp59_) {
						_vala_code_node_unref0 (invoker);
						invoker = NULL;
						_vala_code_node_unref0 (param);
						break;
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp60_ = invoker;
			if (_tmp60_ != NULL) {
				result = n;
				_vala_iterator_unref0 (iter);
				_vala_code_node_unref0 (invoker);
				_vala_iterable_unref0 (_n_list);
				_g_free0 (prefix);
				_vala_code_node_unref0 (m);
				return result;
			}
			_vala_iterator_unref0 (iter);
			_vala_code_node_unref0 (invoker);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	result = NULL;
	_g_free0 (prefix);
	_vala_code_node_unref0 (m);
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_get_current_metadata (ValaGirParser* self)
{
	ValaGirParserMetadata* result = NULL;
	gchar* selector = NULL;
	ValaMarkupReader* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* child_name = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean _tmp9_ = FALSE;
	const gchar* _tmp10_;
	const gchar* _tmp13_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	ValaGirParserMetadata* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaGirParserMetadata* _tmp29_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_name (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	selector = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "name");
	child_name = _tmp5_;
	_tmp6_ = child_name;
	if (_tmp6_ == NULL) {
		ValaMarkupReader* _tmp7_;
		gchar* _tmp8_;
		_tmp7_ = self->priv->reader;
		_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "glib:name");
		_g_free0 (child_name);
		child_name = _tmp8_;
	}
	_tmp10_ = selector;
	if (g_strcmp0 (_tmp10_, "union") == 0) {
		const gchar* _tmp11_;
		_tmp11_ = child_name;
		_tmp9_ = _tmp11_ == NULL;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		gchar* _tmp12_;
		_tmp12_ = g_strdup ("union");
		_g_free0 (child_name);
		child_name = _tmp12_;
	}
	_tmp13_ = child_name;
	if (_tmp13_ == NULL) {
		ValaGirParserMetadata* _tmp14_;
		ValaGirParserMetadata* _tmp15_;
		ValaGirParserMetadata* _tmp16_;
		_tmp14_ = vala_gir_parser_metadata_get_empty ();
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_gir_parser_metadata_ref0 (_tmp15_);
		result = _tmp16_;
		_g_free0 (child_name);
		_g_free0 (selector);
		return result;
	}
	_tmp17_ = selector;
	_tmp18_ = string_replace (_tmp17_, "-", "_");
	_g_free0 (selector);
	selector = _tmp18_;
	_tmp19_ = child_name;
	_tmp20_ = string_replace (_tmp19_, "-", "_");
	_g_free0 (child_name);
	child_name = _tmp20_;
	_tmp21_ = selector;
	if (g_str_has_prefix (_tmp21_, "glib:")) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gchar* _tmp25_;
		_tmp22_ = selector;
		_tmp23_ = strlen ("glib:");
		_tmp24_ = _tmp23_;
		_tmp25_ = string_substring (_tmp22_, (glong) _tmp24_, (glong) -1);
		_g_free0 (selector);
		selector = _tmp25_;
	}
	_tmp26_ = self->priv->metadata;
	_tmp27_ = child_name;
	_tmp28_ = selector;
	_tmp29_ = vala_gir_parser_metadata_match_child (_tmp26_, _tmp27_, _tmp28_);
	result = _tmp29_;
	_g_free0 (child_name);
	_g_free0 (selector);
	return result;
}


static gboolean
vala_gir_parser_push_metadata (ValaGirParser* self)
{
	gboolean result = FALSE;
	ValaGirParserMetadata* new_metadata = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaArrayList* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	ValaGirParserMetadata* _tmp13_;
	ValaGirParserMetadata* _tmp14_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_get_current_metadata (self);
	new_metadata = _tmp0_;
	_tmp1_ = new_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP)) {
		ValaGirParserMetadata* _tmp2_;
		_tmp2_ = new_metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_SKIP, FALSE)) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	} else {
		gboolean _tmp3_ = FALSE;
		ValaMarkupReader* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gboolean _tmp7_;
		_tmp4_ = self->priv->reader;
		_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "introspectable");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strcmp0 (_tmp6_, "0") == 0;
		_g_free0 (_tmp6_);
		if (_tmp7_) {
			_tmp3_ = TRUE;
		} else {
			ValaMarkupReader* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->reader;
			_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "private");
			_tmp10_ = _tmp9_;
			_tmp3_ = g_strcmp0 (_tmp10_, "1") == 0;
			_g_free0 (_tmp10_);
		}
		if (_tmp3_) {
			result = FALSE;
			_vala_gir_parser_metadata_unref0 (new_metadata);
			return result;
		}
	}
	_tmp11_ = self->priv->metadata_stack;
	_tmp12_ = self->priv->metadata;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp12_);
	_tmp13_ = new_metadata;
	_tmp14_ = _vala_gir_parser_metadata_ref0 (_tmp13_);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = _tmp14_;
	result = TRUE;
	_vala_gir_parser_metadata_unref0 (new_metadata);
	return result;
}


static void
vala_gir_parser_pop_metadata (ValaGirParser* self)
{
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gpointer _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->metadata_stack;
	_tmp1_ = self->priv->metadata_stack;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_list_remove_at ((ValaList*) _tmp0_, _tmp3_ - 1);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	self->priv->metadata = (ValaGirParserMetadata*) _tmp4_;
}


static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static gboolean
vala_gir_parser_parse_type_arguments_from_string (ValaGirParser* self,
                                                  ValaDataType* parent_type,
                                                  const gchar* type_arguments,
                                                  ValaSourceReference* source_reference)
{
	gboolean result = FALSE;
	gint type_arguments_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	GString* current = NULL;
	gint _tmp2_;
	GString* _tmp3_;
	gint depth = 0;
	ValaDataType* dt = NULL;
	GString* _tmp32_;
	const gchar* _tmp33_;
	ValaDataType* _tmp34_;
	ValaDataType* _tmp35_;
	ValaDataType* _tmp36_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (parent_type != NULL, FALSE);
	g_return_val_if_fail (type_arguments != NULL, FALSE);
	_tmp0_ = strlen (type_arguments);
	_tmp1_ = _tmp0_;
	type_arguments_length = (gint) _tmp1_;
	_tmp2_ = type_arguments_length;
	_tmp3_ = g_string_sized_new ((gsize) _tmp2_);
	current = _tmp3_;
	depth = 0;
	{
		gint c = 0;
		c = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				gint _tmp7_;
				gboolean _tmp8_ = FALSE;
				gint _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = c;
					c = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = c;
				_tmp7_ = type_arguments_length;
				if (!(_tmp6_ < _tmp7_)) {
					break;
				}
				_tmp9_ = c;
				if (string_get (type_arguments, (glong) _tmp9_) == '<') {
					_tmp8_ = TRUE;
				} else {
					gint _tmp10_;
					_tmp10_ = c;
					_tmp8_ = string_get (type_arguments, (glong) _tmp10_) == '[';
				}
				if (_tmp8_) {
					gint _tmp11_;
					GString* _tmp12_;
					gint _tmp13_;
					_tmp11_ = depth;
					depth = _tmp11_ + 1;
					_tmp12_ = current;
					_tmp13_ = c;
					g_string_append_unichar (_tmp12_, (gunichar) string_get (type_arguments, (glong) _tmp13_));
				} else {
					gboolean _tmp14_ = FALSE;
					gint _tmp15_;
					_tmp15_ = c;
					if (string_get (type_arguments, (glong) _tmp15_) == '>') {
						_tmp14_ = TRUE;
					} else {
						gint _tmp16_;
						_tmp16_ = c;
						_tmp14_ = string_get (type_arguments, (glong) _tmp16_) == ']';
					}
					if (_tmp14_) {
						gint _tmp17_;
						GString* _tmp18_;
						gint _tmp19_;
						_tmp17_ = depth;
						depth = _tmp17_ - 1;
						_tmp18_ = current;
						_tmp19_ = c;
						g_string_append_unichar (_tmp18_, (gunichar) string_get (type_arguments, (glong) _tmp19_));
					} else {
						gint _tmp20_;
						_tmp20_ = c;
						if (string_get (type_arguments, (glong) _tmp20_) == ',') {
							gint _tmp21_;
							_tmp21_ = depth;
							if (_tmp21_ == 0) {
								ValaDataType* dt = NULL;
								GString* _tmp22_;
								const gchar* _tmp23_;
								ValaDataType* _tmp24_;
								ValaDataType* _tmp25_;
								ValaDataType* _tmp26_;
								GString* _tmp27_;
								_tmp22_ = current;
								_tmp23_ = _tmp22_->str;
								_tmp24_ = vala_gir_parser_parse_type_from_string (self, _tmp23_, TRUE, source_reference);
								dt = _tmp24_;
								_tmp25_ = dt;
								if (_tmp25_ == NULL) {
									result = FALSE;
									_vala_code_node_unref0 (dt);
									_g_string_free0 (current);
									return result;
								}
								_tmp26_ = dt;
								vala_data_type_add_type_argument (parent_type, _tmp26_);
								_tmp27_ = current;
								g_string_truncate (_tmp27_, (gsize) 0);
								_vala_code_node_unref0 (dt);
							} else {
								GString* _tmp28_;
								gint _tmp29_;
								_tmp28_ = current;
								_tmp29_ = c;
								g_string_append_unichar (_tmp28_, (gunichar) string_get (type_arguments, (glong) _tmp29_));
							}
						} else {
							GString* _tmp30_;
							gint _tmp31_;
							_tmp30_ = current;
							_tmp31_ = c;
							g_string_append_unichar (_tmp30_, (gunichar) string_get (type_arguments, (glong) _tmp31_));
						}
					}
				}
			}
		}
	}
	_tmp32_ = current;
	_tmp33_ = _tmp32_->str;
	_tmp34_ = vala_gir_parser_parse_type_from_string (self, _tmp33_, TRUE, source_reference);
	dt = _tmp34_;
	_tmp35_ = dt;
	if (_tmp35_ == NULL) {
		result = FALSE;
		_vala_code_node_unref0 (dt);
		_g_string_free0 (current);
		return result;
	}
	_tmp36_ = dt;
	vala_data_type_add_type_argument (parent_type, _tmp36_);
	result = TRUE;
	_vala_code_node_unref0 (dt);
	_g_string_free0 (current);
	return result;
}


static ValaDataType*
vala_gir_parser_parse_type_from_string (ValaGirParser* self,
                                        const gchar* type_string,
                                        gboolean owned_by_default,
                                        ValaSourceReference* source_reference)
{
	ValaDataType* result = NULL;
	GRegex* _tmp0_;
	GMatchInfo* match = NULL;
	GRegex* _tmp5_;
	GMatchInfo* _tmp6_ = NULL;
	gboolean _tmp7_;
	ValaDataType* type = NULL;
	gchar* ownership_data = NULL;
	GMatchInfo* _tmp8_;
	gchar* _tmp9_;
	gchar* type_name = NULL;
	GMatchInfo* _tmp10_;
	gchar* _tmp11_;
	gchar* type_arguments_data = NULL;
	GMatchInfo* _tmp12_;
	gchar* _tmp13_;
	gchar* pointers_data = NULL;
	GMatchInfo* _tmp14_;
	gchar* _tmp15_;
	gchar* array_data = NULL;
	GMatchInfo* _tmp16_;
	gchar* _tmp17_;
	gchar* nullable_data = NULL;
	GMatchInfo* _tmp18_;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	gboolean nullable = FALSE;
	gboolean _tmp25_ = FALSE;
	const gchar* _tmp26_;
	gboolean value_owned = FALSE;
	const gchar* _tmp41_;
	ValaUnresolvedSymbol* sym = NULL;
	const gchar* _tmp43_;
	ValaUnresolvedSymbol* _tmp44_;
	ValaUnresolvedSymbol* _tmp45_;
	ValaUnresolvedSymbol* _tmp46_;
	ValaUnresolvedType* _tmp47_;
	gboolean _tmp48_ = FALSE;
	const gchar* _tmp49_;
	const gchar* _tmp55_;
	gboolean _tmp64_ = FALSE;
	const gchar* _tmp65_;
	ValaDataType* _tmp75_;
	gboolean _tmp76_;
	ValaDataType* _tmp77_;
	gboolean _tmp78_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_string != NULL, NULL);
	_tmp0_ = vala_gir_parser_type_from_string_regex;
	if (_tmp0_ == NULL) {
		{
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp3_;
			_tmp2_ = g_regex_new ("^(?:(owned|unowned|weak) +)?([0-9a-zA-Z_\\.]+)(?:<(.+)>)?(\\*+)?(\\[,*" \
"\\])?(\\?)?$", (G_REGEX_ANCHORED | G_REGEX_DOLLAR_ENDONLY) | G_REGEX_OPTIMIZE, 0, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == G_REGEX_ERROR) {
					goto __catch8_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_gir_parser_type_from_string_regex);
			vala_gir_parser_type_from_string_regex = _tmp3_;
			_g_regex_unref0 (_tmp1_);
		}
		goto __finally8;
		__catch8_g_regex_error:
		{
			GError* e = NULL;
			const gchar* _tmp4_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp4_ = e->message;
			g_error ("valagirparser.vala:1744: Unable to compile regex: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally8:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp5_ = vala_gir_parser_type_from_string_regex;
	_tmp7_ = g_regex_match (_tmp5_, type_string, 0, &_tmp6_);
	_g_match_info_unref0 (match);
	match = _tmp6_;
	if (!_tmp7_) {
		vala_report_error (source_reference, "unable to parse type");
		result = NULL;
		_g_match_info_unref0 (match);
		return result;
	}
	type = NULL;
	_tmp8_ = match;
	_tmp9_ = g_match_info_fetch (_tmp8_, 1);
	ownership_data = _tmp9_;
	_tmp10_ = match;
	_tmp11_ = g_match_info_fetch (_tmp10_, 2);
	type_name = _tmp11_;
	_tmp12_ = match;
	_tmp13_ = g_match_info_fetch (_tmp12_, 3);
	type_arguments_data = _tmp13_;
	_tmp14_ = match;
	_tmp15_ = g_match_info_fetch (_tmp14_, 4);
	pointers_data = _tmp15_;
	_tmp16_ = match;
	_tmp17_ = g_match_info_fetch (_tmp16_, 5);
	array_data = _tmp17_;
	_tmp18_ = match;
	_tmp19_ = g_match_info_fetch (_tmp18_, 6);
	nullable_data = _tmp19_;
	_tmp21_ = nullable_data;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		_tmp22_ = nullable_data;
		_tmp23_ = strlen (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ > 0;
	} else {
		_tmp20_ = FALSE;
	}
	nullable = _tmp20_;
	_tmp26_ = ownership_data;
	if (_tmp26_ == NULL) {
		const gchar* _tmp27_;
		_tmp27_ = type_name;
		_tmp25_ = g_strcmp0 (_tmp27_, "void") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp29_;
		_tmp29_ = array_data;
		if (_tmp29_ == NULL) {
			gboolean _tmp30_;
			_tmp30_ = nullable;
			_tmp28_ = !_tmp30_;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			ValaVoidType* _tmp31_;
			const gchar* _tmp32_;
			_tmp31_ = vala_void_type_new (source_reference);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp31_;
			_tmp32_ = pointers_data;
			if (_tmp32_ != NULL) {
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp33_ = FALSE;
						_tmp33_ = TRUE;
						while (TRUE) {
							gint _tmp35_;
							const gchar* _tmp36_;
							gint _tmp37_;
							gint _tmp38_;
							ValaDataType* _tmp39_;
							ValaPointerType* _tmp40_;
							if (!_tmp33_) {
								gint _tmp34_;
								_tmp34_ = i;
								i = _tmp34_ + 1;
							}
							_tmp33_ = FALSE;
							_tmp35_ = i;
							_tmp36_ = pointers_data;
							_tmp37_ = strlen (_tmp36_);
							_tmp38_ = _tmp37_;
							if (!(_tmp35_ < _tmp38_)) {
								break;
							}
							_tmp39_ = type;
							_tmp40_ = vala_pointer_type_new (_tmp39_, NULL);
							_vala_code_node_unref0 (type);
							type = (ValaDataType*) _tmp40_;
						}
					}
				}
			}
			result = type;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_g_match_info_unref0 (match);
			return result;
		} else {
			vala_report_error (source_reference, "invalid void type");
			result = NULL;
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	value_owned = owned_by_default;
	_tmp41_ = ownership_data;
	if (g_strcmp0 (_tmp41_, "owned") == 0) {
		if (owned_by_default) {
			vala_report_error (source_reference, "unexpected `owned' keyword");
		} else {
			value_owned = TRUE;
		}
	} else {
		const gchar* _tmp42_;
		_tmp42_ = ownership_data;
		if (g_strcmp0 (_tmp42_, "unowned") == 0) {
			if (owned_by_default) {
				value_owned = FALSE;
			} else {
				vala_report_error (source_reference, "unexpected `unowned' keyword");
				result = NULL;
				_g_free0 (nullable_data);
				_g_free0 (array_data);
				_g_free0 (pointers_data);
				_g_free0 (type_arguments_data);
				_g_free0 (type_name);
				_g_free0 (ownership_data);
				_vala_code_node_unref0 (type);
				_g_match_info_unref0 (match);
				return result;
			}
		}
	}
	_tmp43_ = type_name;
	_tmp44_ = vala_gir_parser_parse_symbol_from_string (self, _tmp43_, source_reference);
	sym = _tmp44_;
	_tmp45_ = sym;
	if (_tmp45_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (sym);
		_g_free0 (nullable_data);
		_g_free0 (array_data);
		_g_free0 (pointers_data);
		_g_free0 (type_arguments_data);
		_g_free0 (type_name);
		_g_free0 (ownership_data);
		_vala_code_node_unref0 (type);
		_g_match_info_unref0 (match);
		return result;
	}
	_tmp46_ = sym;
	_tmp47_ = vala_unresolved_type_new_from_symbol (_tmp46_, source_reference);
	_vala_code_node_unref0 (type);
	type = (ValaDataType*) _tmp47_;
	_tmp49_ = type_arguments_data;
	if (_tmp49_ != NULL) {
		const gchar* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		_tmp50_ = type_arguments_data;
		_tmp51_ = strlen (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp48_ = _tmp52_ > 0;
	} else {
		_tmp48_ = FALSE;
	}
	if (_tmp48_) {
		ValaDataType* _tmp53_;
		const gchar* _tmp54_;
		_tmp53_ = type;
		_tmp54_ = type_arguments_data;
		if (!vala_gir_parser_parse_type_arguments_from_string (self, _tmp53_, _tmp54_, source_reference)) {
			result = NULL;
			_vala_code_node_unref0 (sym);
			_g_free0 (nullable_data);
			_g_free0 (array_data);
			_g_free0 (pointers_data);
			_g_free0 (type_arguments_data);
			_g_free0 (type_name);
			_g_free0 (ownership_data);
			_vala_code_node_unref0 (type);
			_g_match_info_unref0 (match);
			return result;
		}
	}
	_tmp55_ = pointers_data;
	if (_tmp55_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp56_ = FALSE;
				_tmp56_ = TRUE;
				while (TRUE) {
					gint _tmp58_;
					const gchar* _tmp59_;
					gint _tmp60_;
					gint _tmp61_;
					ValaDataType* _tmp62_;
					ValaPointerType* _tmp63_;
					if (!_tmp56_) {
						gint _tmp57_;
						_tmp57_ = i;
						i = _tmp57_ + 1;
					}
					_tmp56_ = FALSE;
					_tmp58_ = i;
					_tmp59_ = pointers_data;
					_tmp60_ = strlen (_tmp59_);
					_tmp61_ = _tmp60_;
					if (!(_tmp58_ < _tmp61_)) {
						break;
					}
					_tmp62_ = type;
					_tmp63_ = vala_pointer_type_new (_tmp62_, NULL);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp63_;
				}
			}
		}
	}
	_tmp65_ = array_data;
	if (_tmp65_ != NULL) {
		const gchar* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		_tmp66_ = array_data;
		_tmp67_ = strlen (_tmp66_);
		_tmp68_ = _tmp67_;
		_tmp64_ = _tmp68_ != 0;
	} else {
		_tmp64_ = FALSE;
	}
	if (_tmp64_) {
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		const gchar* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		ValaArrayType* _tmp74_;
		_tmp69_ = type;
		vala_data_type_set_value_owned (_tmp69_, TRUE);
		_tmp70_ = type;
		_tmp71_ = array_data;
		_tmp72_ = strlen (_tmp71_);
		_tmp73_ = _tmp72_;
		_tmp74_ = vala_array_type_new (_tmp70_, ((gint) _tmp73_) - 1, source_reference);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp74_;
	}
	_tmp75_ = type;
	_tmp76_ = nullable;
	vala_data_type_set_nullable (_tmp75_, _tmp76_);
	_tmp77_ = type;
	_tmp78_ = value_owned;
	vala_data_type_set_value_owned (_tmp77_, _tmp78_);
	result = type;
	_vala_code_node_unref0 (sym);
	_g_free0 (nullable_data);
	_g_free0 (array_data);
	_g_free0 (pointers_data);
	_g_free0 (type_arguments_data);
	_g_free0 (type_name);
	_g_free0 (ownership_data);
	_g_match_info_unref0 (match);
	return result;
}


static gchar*
vala_gir_parser_element_get_string (ValaGirParser* self,
                                    const gchar* attribute_name,
                                    ValaGirParserArgumentType arg_type)
{
	gchar* result = NULL;
	ValaGirParserMetadata* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute_name != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, arg_type)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, arg_type);
		result = _tmp2_;
		return result;
	} else {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, attribute_name);
		result = _tmp4_;
		return result;
	}
}


static ValaDataType*
vala_gir_parser_element_get_type (ValaGirParser* self,
                                  ValaDataType* orig_type,
                                  gboolean owned_by_default,
                                  gboolean* no_array_length,
                                  gboolean* array_null_terminated,
                                  gboolean* changed)
{
	gboolean _vala_changed = FALSE;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	ValaDataType* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaDataType* _tmp43_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (orig_type != NULL, NULL);
	_vala_changed = FALSE;
	_tmp0_ = _vala_code_node_ref0 (orig_type);
	type = _tmp0_;
	_tmp1_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE)) {
		ValaGirParserMetadata* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		ValaGirParserMetadata* _tmp5_;
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaDataType* _tmp8_;
		_tmp2_ = self->priv->metadata;
		_tmp3_ = vala_gir_parser_metadata_get_string (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->metadata;
		_tmp6_ = vala_gir_parser_metadata_get_source_reference (_tmp5_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_gir_parser_parse_type_from_string (self, _tmp4_, owned_by_default, _tmp7_);
		_vala_code_node_unref0 (type);
		type = _tmp8_;
		_vala_source_reference_unref0 (_tmp7_);
		_g_free0 (_tmp4_);
		_vala_changed = TRUE;
	} else {
		ValaDataType* _tmp9_;
		_tmp9_ = type;
		if (!VALA_IS_VOID_TYPE (_tmp9_)) {
			ValaGirParserMetadata* _tmp10_;
			gboolean _tmp19_ = FALSE;
			ValaDataType* _tmp20_;
			ValaDataType* _tmp38_;
			ValaGirParserMetadata* _tmp39_;
			ValaDataType* _tmp40_;
			gboolean _tmp41_;
			gboolean _tmp42_;
			_tmp10_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS)) {
				ValaDataType* _tmp11_;
				ValaDataType* _tmp12_;
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				ValaGirParserMetadata* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				_tmp11_ = type;
				vala_data_type_remove_all_type_arguments (_tmp11_);
				_tmp12_ = type;
				_tmp13_ = self->priv->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp15_ = _tmp14_;
				_tmp16_ = self->priv->metadata;
				_tmp17_ = vala_gir_parser_metadata_get_source_reference (_tmp16_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ARGUMENTS);
				_tmp18_ = _tmp17_;
				vala_gir_parser_parse_type_arguments_from_string (self, _tmp12_, _tmp15_, _tmp18_);
				_vala_source_reference_unref0 (_tmp18_);
				_g_free0 (_tmp15_);
			}
			_tmp20_ = type;
			if (!VALA_IS_ARRAY_TYPE (_tmp20_)) {
				ValaGirParserMetadata* _tmp21_;
				_tmp21_ = self->priv->metadata;
				_tmp19_ = vala_gir_parser_metadata_get_bool (_tmp21_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY, FALSE);
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaDataType* _tmp22_;
				ValaDataType* _tmp23_;
				ValaDataType* _tmp24_;
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				ValaArrayType* _tmp27_;
				_tmp22_ = type;
				vala_data_type_set_value_owned (_tmp22_, TRUE);
				_tmp23_ = type;
				_tmp24_ = type;
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_array_type_new (_tmp23_, 1, _tmp26_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp27_;
				_vala_changed = TRUE;
			}
			if (owned_by_default) {
				ValaDataType* _tmp28_;
				ValaGirParserMetadata* _tmp29_;
				ValaDataType* _tmp30_;
				gboolean _tmp31_;
				gboolean _tmp32_;
				_tmp28_ = type;
				_tmp29_ = self->priv->metadata;
				_tmp30_ = type;
				_tmp31_ = vala_data_type_get_value_owned (_tmp30_);
				_tmp32_ = _tmp31_;
				vala_data_type_set_value_owned (_tmp28_, !vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_UNOWNED, !_tmp32_));
			} else {
				ValaDataType* _tmp33_;
				ValaGirParserMetadata* _tmp34_;
				ValaDataType* _tmp35_;
				gboolean _tmp36_;
				gboolean _tmp37_;
				_tmp33_ = type;
				_tmp34_ = self->priv->metadata;
				_tmp35_ = type;
				_tmp36_ = vala_data_type_get_value_owned (_tmp35_);
				_tmp37_ = _tmp36_;
				vala_data_type_set_value_owned (_tmp33_, vala_gir_parser_metadata_get_bool (_tmp34_, VALA_GIR_PARSER_ARGUMENT_TYPE_OWNED, _tmp37_));
			}
			_tmp38_ = type;
			_tmp39_ = self->priv->metadata;
			_tmp40_ = type;
			_tmp41_ = vala_data_type_get_nullable (_tmp40_);
			_tmp42_ = _tmp41_;
			vala_data_type_set_nullable (_tmp38_, vala_gir_parser_metadata_get_bool (_tmp39_, VALA_GIR_PARSER_ARGUMENT_TYPE_NULLABLE, _tmp42_));
		}
	}
	_tmp43_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp43_)) {
		ValaGirParserMetadata* _tmp44_;
		if (!VALA_IS_ARRAY_TYPE (orig_type)) {
			*no_array_length = TRUE;
		}
		_tmp44_ = self->priv->metadata;
		*array_null_terminated = vala_gir_parser_metadata_get_bool (_tmp44_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_NULL_TERMINATED, *array_null_terminated);
	}
	result = type;
	if (changed) {
		*changed = _vala_changed;
	}
	return result;
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
vala_gir_parser_element_get_name (ValaGirParser* self,
                                  const gchar* gir_name)
{
	gchar* result = NULL;
	gchar* name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* pattern = NULL;
	ValaGirParserMetadata* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (gir_name);
	name = _tmp0_;
	_tmp1_ = name;
	if (_tmp1_ == NULL) {
		ValaMarkupReader* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->priv->reader;
		_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "name");
		_g_free0 (name);
		name = _tmp3_;
	}
	_tmp4_ = self->priv->metadata;
	_tmp5_ = vala_gir_parser_metadata_get_string (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	pattern = _tmp5_;
	_tmp6_ = pattern;
	if (_tmp6_ != NULL) {
		const gchar* _tmp7_;
		_tmp7_ = pattern;
		if (string_index_of_char (_tmp7_, (gunichar) '(', 0) < 0) {
			const gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = pattern;
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (name);
			name = _tmp9_;
		} else {
			{
				gchar* replacement = NULL;
				gchar* _tmp10_;
				gchar** split = NULL;
				const gchar* _tmp11_;
				gchar** _tmp12_;
				gchar** _tmp13_;
				gint split_length1;
				gint _split_size_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				GRegex* regex = NULL;
				const gchar* _tmp21_;
				GRegex* _tmp22_;
				gchar* _tmp23_ = NULL;
				GRegex* _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				gchar* _tmp28_;
				_tmp10_ = g_strdup ("\\1");
				replacement = _tmp10_;
				_tmp11_ = pattern;
				_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "/", 0);
				split = _tmp13_;
				split_length1 = _vala_array_length (_tmp12_);
				_split_size_ = split_length1;
				_tmp14_ = split;
				_tmp14__length1 = split_length1;
				if (_tmp14__length1 > 1) {
					gchar** _tmp15_;
					gint _tmp15__length1;
					const gchar* _tmp16_;
					gchar* _tmp17_;
					gchar** _tmp18_;
					gint _tmp18__length1;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp15_ = split;
					_tmp15__length1 = split_length1;
					_tmp16_ = _tmp15_[0];
					_tmp17_ = g_strdup (_tmp16_);
					_g_free0 (pattern);
					pattern = _tmp17_;
					_tmp18_ = split;
					_tmp18__length1 = split_length1;
					_tmp19_ = _tmp18_[1];
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (replacement);
					replacement = _tmp20_;
				}
				_tmp21_ = pattern;
				_tmp22_ = g_regex_new (_tmp21_, G_REGEX_ANCHORED, G_REGEX_MATCH_ANCHORED, &_inner_error0_);
				regex = _tmp22_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch9_g_error;
				}
				_tmp24_ = regex;
				_tmp25_ = name;
				_tmp26_ = replacement;
				_tmp27_ = g_regex_replace (_tmp24_, _tmp25_, (gssize) -1, 0, _tmp26_, 0, &_inner_error0_);
				_tmp23_ = _tmp27_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_regex_unref0 (regex);
					split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (replacement);
					goto __catch9_g_error;
				}
				_tmp28_ = _tmp23_;
				_tmp23_ = NULL;
				_g_free0 (name);
				name = _tmp28_;
				_g_free0 (_tmp23_);
				_g_regex_unref0 (regex);
				split = (_vala_array_free (split, split_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (replacement);
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError* e = NULL;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				e = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp29_ = pattern;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (name);
				name = _tmp30_;
				_g_error_free0 (e);
			}
			__finally9:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (pattern);
				_g_free0 (name);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	} else {
		gboolean _tmp31_ = FALSE;
		const gchar* _tmp32_;
		_tmp32_ = name;
		if (_tmp32_ != NULL) {
			const gchar* _tmp33_;
			_tmp33_ = name;
			_tmp31_ = g_str_has_suffix (_tmp33_, "Enum");
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			const gchar* _tmp34_;
			const gchar* _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			gint _tmp38_;
			gint _tmp39_;
			gchar* _tmp40_;
			_tmp34_ = name;
			_tmp35_ = name;
			_tmp36_ = strlen (_tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = strlen ("Enum");
			_tmp39_ = _tmp38_;
			_tmp40_ = string_substring (_tmp34_, (glong) 0, (glong) (_tmp37_ - _tmp39_));
			_g_free0 (name);
			name = _tmp40_;
		}
	}
	result = name;
	_g_free0 (pattern);
	return result;
}


static gchar*
vala_gir_parser_element_get_type_id (ValaGirParser* self)
{
	gchar* result = NULL;
	gchar* type_id = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	ValaMarkupReader* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->metadata;
	_tmp1_ = vala_gir_parser_metadata_get_string (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_TYPE_ID);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ != NULL) {
		result = type_id;
		return result;
	}
	_tmp3_ = self->priv->reader;
	_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:get-type");
	_g_free0 (type_id);
	type_id = _tmp4_;
	_tmp5_ = type_id;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = type_id;
		_tmp7_ = g_strconcat (_tmp6_, " ()", NULL);
		_g_free0 (type_id);
		type_id = _tmp7_;
	}
	result = type_id;
	return result;
}


static void
vala_gir_parser_set_array_ccode (ValaGirParser* self,
                                 ValaSymbol* sym,
                                 ValaGirParserParameterInfo* info)
{
	gfloat _tmp0_;
	gchar* type_name = NULL;
	ValaParameter* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = info->vala_idx;
	vala_code_node_set_attribute_double ((ValaCodeNode*) sym, "CCode", "array_length_pos", (gdouble) _tmp0_, NULL);
	if (VALA_IS_PARAMETER (sym)) {
		ValaParameter* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = info->param;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) _tmp1_);
		_tmp3_ = _tmp2_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_cname", _tmp3_, NULL);
	}
	_tmp4_ = info->param;
	_tmp5_ = vala_variable_get_variable_type ((ValaVariable*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_data_type_to_qualified_string (_tmp6_, NULL);
	type_name = _tmp7_;
	_tmp8_ = type_name;
	if (g_strcmp0 (_tmp8_, "int") != 0) {
		ValaGirParserNode* st = NULL;
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaGirParserNode* _tmp12_;
		_tmp9_ = self->priv->root;
		_tmp10_ = type_name;
		_tmp11_ = vala_gir_parser_node_lookup (_tmp9_, _tmp10_, FALSE, NULL);
		st = _tmp11_;
		_tmp12_ = st;
		if (_tmp12_ != NULL) {
			gboolean _tmp13_ = FALSE;
			if (VALA_IS_CALLABLE (sym)) {
				_tmp13_ = TRUE;
			} else {
				_tmp13_ = VALA_IS_PARAMETER (sym);
			}
			if (_tmp13_) {
				ValaGirParserNode* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				_tmp14_ = st;
				_tmp15_ = vala_gir_parser_node_get_cname (_tmp14_);
				_tmp16_ = _tmp15_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "array_length_type", _tmp16_, NULL);
				_g_free0 (_tmp16_);
			}
		}
		_vala_gir_parser_node_unref0 (st);
	}
	_g_free0 (type_name);
}


static void
vala_gir_parser_set_type_id_ccode (ValaGirParser* self,
                                   ValaSymbol* sym)
{
	gboolean _tmp0_ = FALSE;
	gchar* type_id = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sym != NULL);
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "has_type_id")) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) sym, "CCode", "type_id");
	}
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_gir_parser_element_get_type_id (self);
	type_id = _tmp1_;
	_tmp2_ = type_id;
	if (_tmp2_ == NULL) {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) sym, "CCode", "has_type_id", FALSE, NULL);
	} else {
		const gchar* _tmp3_;
		_tmp3_ = type_id;
		vala_code_node_set_attribute_string ((ValaCodeNode*) sym, "CCode", "type_id", _tmp3_, NULL);
	}
	_g_free0 (type_id);
}


static void
vala_gir_parser_parse_repository (ValaGirParser* self)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "repository");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "version");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, VALA_GIR_PARSER_GIR_VERSION) != 0;
	_g_free0 (_tmp2_);
	if (_tmp3_) {
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		ValaMarkupReader* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp4_ = vala_gir_parser_get_current_src (self);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->reader;
		_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "version");
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strdup_printf ("unsupported GIR version %s (supported: %s)", _tmp8_, VALA_GIR_PARSER_GIR_VERSION);
		_tmp10_ = _tmp9_;
		vala_report_error (_tmp5_, _tmp10_);
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_vala_source_reference_unref0 (_tmp5_);
		return;
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp11_;
		ValaMarkupReader* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp11_ = self->priv->current_token;
		if (!(_tmp11_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp12_ = self->priv->reader;
		_tmp13_ = vala_markup_reader_get_name (_tmp12_);
		_tmp14_ = _tmp13_;
		if (g_strcmp0 (_tmp14_, "namespace") == 0) {
			vala_gir_parser_parse_namespace (self);
		} else {
			ValaMarkupReader* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp15_ = self->priv->reader;
			_tmp16_ = vala_markup_reader_get_name (_tmp15_);
			_tmp17_ = _tmp16_;
			if (g_strcmp0 (_tmp17_, "include") == 0) {
				vala_gir_parser_parse_include (self);
			} else {
				ValaMarkupReader* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_name (_tmp18_);
				_tmp20_ = _tmp19_;
				if (g_strcmp0 (_tmp20_, "package") == 0) {
					gchar* pkg = NULL;
					gchar* _tmp21_;
					ValaSourceFile* _tmp22_;
					const gchar* _tmp23_;
					ValaCodeContext* _tmp24_;
					const gchar* _tmp25_;
					_tmp21_ = vala_gir_parser_parse_package (self);
					pkg = _tmp21_;
					_tmp22_ = self->priv->current_source_file;
					_tmp23_ = pkg;
					vala_source_file_set_package_name (_tmp22_, _tmp23_);
					_tmp24_ = self->priv->context;
					_tmp25_ = pkg;
					if (vala_code_context_has_package (_tmp24_, _tmp25_)) {
						ValaSourceFile* _tmp26_;
						gboolean _tmp27_;
						gboolean _tmp28_;
						_tmp26_ = self->priv->current_source_file;
						_tmp27_ = vala_source_file_get_explicit (_tmp26_);
						_tmp28_ = _tmp27_;
						if (!_tmp28_) {
							_g_free0 (pkg);
							return;
						}
					} else {
						ValaCodeContext* _tmp29_;
						const gchar* _tmp30_;
						_tmp29_ = self->priv->context;
						_tmp30_ = pkg;
						vala_code_context_add_package (_tmp29_, _tmp30_);
					}
					_g_free0 (pkg);
				} else {
					ValaMarkupReader* _tmp31_;
					const gchar* _tmp32_;
					const gchar* _tmp33_;
					_tmp31_ = self->priv->reader;
					_tmp32_ = vala_markup_reader_get_name (_tmp31_);
					_tmp33_ = _tmp32_;
					if (g_strcmp0 (_tmp33_, "c:include") == 0) {
						vala_gir_parser_parse_c_include (self);
					} else {
						ValaSourceReference* _tmp34_;
						ValaSourceReference* _tmp35_;
						ValaMarkupReader* _tmp36_;
						const gchar* _tmp37_;
						const gchar* _tmp38_;
						gchar* _tmp39_;
						gchar* _tmp40_;
						_tmp34_ = vala_gir_parser_get_current_src (self);
						_tmp35_ = _tmp34_;
						_tmp36_ = self->priv->reader;
						_tmp37_ = vala_markup_reader_get_name (_tmp36_);
						_tmp38_ = _tmp37_;
						_tmp39_ = g_strdup_printf ("unknown child element `%s' in `repository'", _tmp38_);
						_tmp40_ = _tmp39_;
						vala_report_error (_tmp35_, _tmp40_);
						_g_free0 (_tmp40_);
						_vala_source_reference_unref0 (_tmp35_);
						vala_gir_parser_skip_element (self);
					}
				}
			}
		}
	}
	vala_gir_parser_end_element (self, "repository");
}


static void
vala_gir_parser_parse_include (ValaGirParser* self)
{
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* version = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCodeContext* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "include");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "version");
	version = _tmp3_;
	_tmp4_ = version;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = pkg;
		_tmp6_ = version;
		_tmp7_ = g_strdup_printf ("%s-%s", _tmp5_, _tmp6_);
		_g_free0 (pkg);
		pkg = _tmp7_;
	}
	_tmp8_ = self->priv->context;
	_tmp9_ = pkg;
	vala_code_context_add_external_package (_tmp8_, _tmp9_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "include");
	_g_free0 (version);
	_g_free0 (pkg);
}


static gchar*
vala_gir_parser_parse_package (ValaGirParser* self)
{
	gchar* result = NULL;
	gchar* pkg = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "package");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	pkg = _tmp1_;
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "package");
	result = pkg;
	return result;
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
vala_gir_parser_parse_c_include (ValaGirParser* self)
{
	gchar** _tmp0_;
	gint _tmp0__length1;
	ValaMarkupReader* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "c:include");
	_tmp0_ = self->priv->cheader_filenames;
	_tmp0__length1 = self->priv->cheader_filenames_length1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_attribute (_tmp1_, "name");
	_vala_array_add1 (&self->priv->cheader_filenames, &self->priv->cheader_filenames_length1, &self->priv->_cheader_filenames_size_, _tmp2_);
	vala_gir_parser_next (self);
	vala_gir_parser_end_element (self, "c:include");
}


static void
vala_gir_parser_skip_element (ValaGirParser* self)
{
	gint level = 0;
	g_return_if_fail (self != NULL);
	vala_gir_parser_next (self);
	level = 1;
	while (TRUE) {
		gint _tmp0_;
		ValaMarkupTokenType _tmp1_;
		_tmp0_ = level;
		if (!(_tmp0_ > 0)) {
			break;
		}
		_tmp1_ = self->priv->current_token;
		if (_tmp1_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
			gint _tmp2_;
			_tmp2_ = level;
			level = _tmp2_ + 1;
		} else {
			ValaMarkupTokenType _tmp3_;
			_tmp3_ = self->priv->current_token;
			if (_tmp3_ == VALA_MARKUP_TOKEN_TYPE_END_ELEMENT) {
				gint _tmp4_;
				_tmp4_ = level;
				level = _tmp4_ - 1;
			} else {
				ValaMarkupTokenType _tmp5_;
				_tmp5_ = self->priv->current_token;
				if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_EOF) {
					ValaSourceReference* _tmp6_;
					ValaSourceReference* _tmp7_;
					_tmp6_ = vala_gir_parser_get_current_src (self);
					_tmp7_ = _tmp6_;
					vala_report_error (_tmp7_, "unexpected end of file");
					_vala_source_reference_unref0 (_tmp7_);
					break;
				}
			}
		}
		vala_gir_parser_next (self);
	}
}


static ValaGirParserNode*
vala_gir_parser_resolve_node (ValaGirParser* self,
                              ValaGirParserNode* parent_scope,
                              ValaUnresolvedSymbol* unresolved_sym,
                              gboolean create_namespace)
{
	ValaGirParserNode* result = NULL;
	ValaUnresolvedSymbol* _tmp0_;
	ValaUnresolvedSymbol* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_unresolved_symbol_get_inner (unresolved_sym);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		ValaGirParserNode* scope = NULL;
		ValaGirParserNode* _tmp2_;
		_tmp2_ = _vala_gir_parser_node_ref0 (parent_scope);
		scope = _tmp2_;
		while (TRUE) {
			ValaGirParserNode* _tmp3_;
			ValaGirParserNode* node = NULL;
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaGirParserNode* _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaGirParserNode* _tmp12_;
			ValaGirParserNode* _tmp13_;
			_tmp3_ = scope;
			if (!(_tmp3_ != NULL)) {
				break;
			}
			_tmp4_ = scope;
			_tmp5_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_gir_parser_node_lookup (_tmp4_, _tmp6_, create_namespace, _tmp8_);
			node = _tmp9_;
			_tmp10_ = node;
			if (_tmp10_ != NULL) {
				result = node;
				_vala_gir_parser_node_unref0 (scope);
				return result;
			}
			_tmp11_ = scope;
			_tmp12_ = _tmp11_->parent;
			_tmp13_ = _vala_gir_parser_node_ref0 (_tmp12_);
			_vala_gir_parser_node_unref0 (scope);
			scope = _tmp13_;
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_gir_parser_node_unref0 (scope);
	} else {
		ValaGirParserNode* inner = NULL;
		ValaUnresolvedSymbol* _tmp14_;
		ValaUnresolvedSymbol* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaGirParserNode* _tmp17_;
		_tmp14_ = vala_unresolved_symbol_get_inner (unresolved_sym);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_gir_parser_resolve_node (self, parent_scope, _tmp15_, create_namespace);
		inner = _tmp16_;
		_tmp17_ = inner;
		if (_tmp17_ != NULL) {
			ValaGirParserNode* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			ValaGirParserNode* _tmp23_;
			_tmp18_ = inner;
			_tmp19_ = vala_symbol_get_name ((ValaSymbol*) unresolved_sym);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) unresolved_sym);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_gir_parser_node_lookup (_tmp18_, _tmp20_, create_namespace, _tmp22_);
			result = _tmp23_;
			_vala_gir_parser_node_unref0 (inner);
			return result;
		}
		_vala_gir_parser_node_unref0 (inner);
	}
	result = NULL;
	return result;
}


static ValaSymbol*
vala_gir_parser_resolve_symbol (ValaGirParser* self,
                                ValaGirParserNode* parent_scope,
                                ValaUnresolvedSymbol* unresolved_sym)
{
	ValaSymbol* result = NULL;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (parent_scope != NULL, NULL);
	g_return_val_if_fail (unresolved_sym != NULL, NULL);
	_tmp0_ = vala_gir_parser_resolve_node (self, parent_scope, unresolved_sym, FALSE);
	node = _tmp0_;
	_tmp1_ = node;
	if (_tmp1_ != NULL) {
		ValaGirParserNode* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp2_ = node;
		_tmp3_ = _tmp2_->symbol;
		_tmp4_ = _vala_code_node_ref0 (_tmp3_);
		result = _tmp4_;
		_vala_gir_parser_node_unref0 (node);
		return result;
	}
	result = NULL;
	_vala_gir_parser_node_unref0 (node);
	return result;
}


static void
vala_gir_parser_push_node (ValaGirParser* self,
                           const gchar* name,
                           gboolean merge)
{
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	ValaGirParserNode* node = NULL;
	ValaGirParserNode* _tmp14_;
	ValaGirParserNode* _tmp15_;
	gboolean _tmp16_ = FALSE;
	ValaGirParserNode* _tmp17_;
	ValaGirParserNode* _tmp27_;
	ValaMarkupReader* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	ValaGirParserNode* _tmp32_;
	ValaMarkupReader* _tmp33_;
	ValaMap* _tmp34_;
	ValaGirParserNode* _tmp35_;
	ValaGirParserMetadata* _tmp36_;
	ValaGirParserMetadata* _tmp37_;
	ValaGirParserNode* _tmp38_;
	ValaSourceReference* _tmp39_;
	gchar* gir_name = NULL;
	ValaGirParserNode* _tmp40_;
	gchar* _tmp41_;
	gboolean _tmp42_ = FALSE;
	ValaGirParserNode* _tmp43_;
	ValaGirParserNode* _tmp44_;
	ValaArrayList* _tmp52_;
	ValaGirParserNode* _tmp53_;
	ValaGirParserNode* _tmp54_;
	ValaGirParserNode* _tmp55_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	parent = _tmp1_;
	_tmp2_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT)) {
		ValaUnresolvedSymbol* target = NULL;
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserMetadata* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaGirParserNode* _tmp11_;
		ValaUnresolvedSymbol* _tmp12_;
		ValaGirParserNode* _tmp13_;
		_tmp3_ = self->priv->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->metadata;
		_tmp7_ = vala_gir_parser_metadata_get_source_reference (_tmp6_, VALA_GIR_PARSER_ARGUMENT_TYPE_PARENT);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_gir_parser_parse_symbol_from_string (self, _tmp5_, _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_source_reference_unref0 (_tmp8_);
		_g_free0 (_tmp5_);
		target = _tmp10_;
		_tmp11_ = self->priv->root;
		_tmp12_ = target;
		_tmp13_ = vala_gir_parser_resolve_node (self, _tmp11_, _tmp12_, TRUE);
		_vala_gir_parser_node_unref0 (parent);
		parent = _tmp13_;
		_vala_code_node_unref0 (target);
	}
	_tmp14_ = parent;
	_tmp15_ = vala_gir_parser_node_lookup (_tmp14_, name, FALSE, NULL);
	node = _tmp15_;
	_tmp17_ = node;
	if (_tmp17_ == NULL) {
		_tmp16_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = node;
		_tmp20_ = _tmp19_->symbol;
		if (_tmp20_ != NULL) {
			_tmp18_ = !merge;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp16_ = _tmp18_;
	}
	if (_tmp16_) {
		ValaGirParserNode* _tmp21_;
		ValaGirParserNode* _tmp22_;
		ValaGirParserNode* _tmp23_;
		ValaGirParserNode* _tmp24_;
		_tmp21_ = vala_gir_parser_node_new (name);
		_vala_gir_parser_node_unref0 (node);
		node = _tmp21_;
		_tmp22_ = node;
		_tmp22_->new_symbol = TRUE;
		_tmp23_ = parent;
		_tmp24_ = node;
		vala_gir_parser_node_add_member (_tmp23_, _tmp24_);
	} else {
		ValaArrayList* _tmp25_;
		ValaGirParserNode* _tmp26_;
		_tmp25_ = vala_gir_parser_node_new_namespaces;
		_tmp26_ = node;
		vala_collection_remove ((ValaCollection*) _tmp25_, _tmp26_);
	}
	_tmp27_ = node;
	_tmp28_ = self->priv->reader;
	_tmp29_ = vala_markup_reader_get_name (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strdup (_tmp30_);
	_g_free0 (_tmp27_->element_type);
	_tmp27_->element_type = _tmp31_;
	_tmp32_ = node;
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attributes (_tmp33_);
	_vala_map_unref0 (_tmp32_->girdata);
	_tmp32_->girdata = _tmp34_;
	_tmp35_ = node;
	_tmp36_ = self->priv->metadata;
	_tmp37_ = _vala_gir_parser_metadata_ref0 (_tmp36_);
	_vala_gir_parser_metadata_unref0 (_tmp35_->metadata);
	_tmp35_->metadata = _tmp37_;
	_tmp38_ = node;
	_tmp39_ = vala_gir_parser_get_current_src (self);
	_vala_source_reference_unref0 (_tmp38_->source_reference);
	_tmp38_->source_reference = _tmp39_;
	_tmp40_ = node;
	_tmp41_ = vala_gir_parser_node_get_gir_name (_tmp40_);
	gir_name = _tmp41_;
	_tmp43_ = parent;
	_tmp44_ = self->priv->current;
	if (_tmp43_ != _tmp44_) {
		_tmp42_ = TRUE;
	} else {
		const gchar* _tmp45_;
		_tmp45_ = gir_name;
		_tmp42_ = g_strcmp0 (_tmp45_, name) != 0;
	}
	if (_tmp42_) {
		const gchar* _tmp46_;
		ValaUnresolvedSymbol* _tmp47_;
		ValaUnresolvedSymbol* _tmp48_;
		ValaGirParserNode* _tmp49_;
		ValaUnresolvedSymbol* _tmp50_;
		ValaUnresolvedSymbol* _tmp51_;
		_tmp46_ = gir_name;
		_tmp47_ = vala_unresolved_symbol_new (NULL, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		_tmp49_ = node;
		_tmp50_ = vala_gir_parser_node_get_unresolved_symbol (_tmp49_);
		_tmp51_ = _tmp50_;
		vala_gir_parser_set_symbol_mapping (self, _tmp48_, (ValaSymbol*) _tmp51_);
		_vala_code_node_unref0 (_tmp51_);
		_vala_code_node_unref0 (_tmp48_);
	}
	_tmp52_ = self->priv->tree_stack;
	_tmp53_ = self->priv->current;
	vala_collection_add ((ValaCollection*) _tmp52_, _tmp53_);
	_tmp54_ = node;
	_tmp55_ = _vala_gir_parser_node_ref0 (_tmp54_);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = _tmp55_;
	_g_free0 (gir_name);
	_vala_gir_parser_node_unref0 (node);
	_vala_gir_parser_node_unref0 (parent);
}


static void
vala_gir_parser_pop_node (ValaGirParser* self)
{
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gpointer _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->current;
	_tmp1_ = _vala_gir_parser_node_ref0 (_tmp0_);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	self->priv->old_current = _tmp1_;
	_tmp2_ = self->priv->tree_stack;
	_tmp3_ = self->priv->tree_stack;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_list_remove_at ((ValaList*) _tmp2_, _tmp5_ - 1);
	_vala_gir_parser_node_unref0 (self->priv->current);
	self->priv->current = (ValaGirParserNode*) _tmp6_;
}


static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static void
_vala_code_node_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL));
}


static inline void
_g_list_free__vala_code_node_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _vala_code_node_unref0_);
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static void
vala_gir_parser_parse_namespace (ValaGirParser* self)
{
	gchar* cprefix = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* lower_case_cprefix = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	gchar* vala_namespace = NULL;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* gir_namespace = NULL;
	ValaMarkupReader* _tmp12_;
	gchar* _tmp13_;
	gchar* gir_version = NULL;
	ValaMarkupReader* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaSet* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gboolean _tmp27_;
	gchar* metadata_filename = NULL;
	ValaCodeContext* _tmp28_;
	ValaSourceFile* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gboolean _tmp33_ = FALSE;
	const gchar* _tmp34_;
	ValaGirParserMetadata* ns_metadata = NULL;
	ValaGirParserMetadata* _tmp50_;
	const gchar* _tmp51_;
	ValaGirParserMetadata* _tmp52_;
	ValaGirParserMetadata* _tmp53_;
	const gchar* _tmp56_;
	ValaSourceFile* _tmp59_;
	const gchar* _tmp60_;
	ValaSourceFile* _tmp61_;
	const gchar* _tmp62_;
	ValaNamespace* ns = NULL;
	const gchar* _tmp63_;
	ValaGirParserNode* _tmp64_;
	gboolean _tmp65_;
	ValaGirParserNode* _tmp80_;
	ValaGirParserMetadata* _tmp81_;
	ValaGirParserMetadata* _tmp82_;
	ValaGirParserMetadata* _tmp83_;
	ValaGirParserMetadata* _tmp86_;
	ValaNamespace* _tmp92_;
	const gchar* _tmp93_;
	ValaNamespace* _tmp94_;
	const gchar* _tmp95_;
	const gchar* _tmp96_;
	const gchar* _tmp106_;
	gchar** _tmp109_;
	gint _tmp109__length1;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "namespace");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "c:identifier-prefixes");
	cprefix = _tmp1_;
	_tmp2_ = cprefix;
	if (_tmp2_ != NULL) {
		gint idx = 0;
		const gchar* _tmp3_;
		gint _tmp4_;
		_tmp3_ = cprefix;
		idx = string_index_of (_tmp3_, ",", 0);
		_tmp4_ = idx;
		if (_tmp4_ != -1) {
			const gchar* _tmp5_;
			gint _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = cprefix;
			_tmp6_ = idx;
			_tmp7_ = string_substring (_tmp5_, (glong) 0, (glong) _tmp6_);
			_g_free0 (cprefix);
			cprefix = _tmp7_;
		}
	}
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "c:symbol-prefixes");
	lower_case_cprefix = _tmp9_;
	_tmp10_ = cprefix;
	_tmp11_ = g_strdup (_tmp10_);
	vala_namespace = _tmp11_;
	_tmp12_ = self->priv->reader;
	_tmp13_ = vala_markup_reader_get_attribute (_tmp12_, "name");
	gir_namespace = _tmp13_;
	_tmp14_ = self->priv->reader;
	_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "version");
	gir_version = _tmp15_;
	_tmp16_ = lower_case_cprefix;
	if (_tmp16_ != NULL) {
		gint idx = 0;
		const gchar* _tmp17_;
		gint _tmp18_;
		_tmp17_ = lower_case_cprefix;
		idx = string_index_of (_tmp17_, ",", 0);
		_tmp18_ = idx;
		if (_tmp18_ != -1) {
			const gchar* _tmp19_;
			gint _tmp20_;
			gchar* _tmp21_;
			_tmp19_ = lower_case_cprefix;
			_tmp20_ = idx;
			_tmp21_ = string_substring (_tmp19_, (glong) 0, (glong) _tmp20_);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp21_;
		}
	}
	_tmp22_ = self->priv->provided_namespaces;
	_tmp23_ = gir_namespace;
	_tmp24_ = gir_version;
	_tmp25_ = g_strdup_printf ("%s-%s", _tmp23_, _tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = vala_collection_contains ((ValaCollection*) _tmp22_, _tmp26_);
	_g_free0 (_tmp26_);
	if (_tmp27_) {
		vala_gir_parser_skip_element (self);
		_g_free0 (gir_version);
		_g_free0 (gir_namespace);
		_g_free0 (vala_namespace);
		_g_free0 (lower_case_cprefix);
		_g_free0 (cprefix);
		return;
	}
	_tmp28_ = self->priv->context;
	_tmp29_ = self->priv->current_source_file;
	_tmp30_ = vala_source_file_get_filename (_tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_context_get_metadata_path (_tmp28_, _tmp31_);
	metadata_filename = _tmp32_;
	_tmp34_ = metadata_filename;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_;
		_tmp35_ = metadata_filename;
		_tmp33_ = g_file_test (_tmp35_, G_FILE_TEST_EXISTS);
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		ValaGirParserMetadataParser* metadata_parser = NULL;
		ValaGirParserMetadataParser* _tmp36_;
		ValaSourceFile* metadata_file = NULL;
		ValaCodeContext* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaSourceFileType _tmp39_;
		ValaSourceFileType _tmp40_;
		const gchar* _tmp41_;
		ValaSourceFile* _tmp42_;
		ValaCodeContext* _tmp43_;
		ValaSourceFile* _tmp44_;
		ValaGirParserMetadataParser* _tmp45_;
		ValaSourceFile* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaArrayList* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		_tmp36_ = vala_gir_parser_metadata_parser_new ();
		metadata_parser = _tmp36_;
		_tmp37_ = self->priv->context;
		_tmp38_ = self->priv->current_source_file;
		_tmp39_ = vala_source_file_get_file_type (_tmp38_);
		_tmp40_ = _tmp39_;
		_tmp41_ = metadata_filename;
		_tmp42_ = vala_source_file_new (_tmp37_, _tmp40_, _tmp41_, NULL, FALSE);
		metadata_file = _tmp42_;
		_tmp43_ = self->priv->context;
		_tmp44_ = metadata_file;
		vala_code_context_add_source_file (_tmp43_, _tmp44_);
		_tmp45_ = metadata_parser;
		_tmp46_ = metadata_file;
		_tmp47_ = vala_gir_parser_metadata_parser_parse_metadata (_tmp45_, _tmp46_);
		_vala_gir_parser_metadata_unref0 (self->priv->metadata);
		self->priv->metadata = _tmp47_;
		_tmp48_ = self->priv->metadata_roots;
		_tmp49_ = self->priv->metadata;
		vala_collection_add ((ValaCollection*) _tmp48_, _tmp49_);
		_vala_source_file_unref0 (metadata_file);
		_vala_gir_parser_metadata_parser_unref0 (metadata_parser);
	}
	_tmp50_ = self->priv->metadata;
	_tmp51_ = gir_namespace;
	_tmp52_ = vala_gir_parser_metadata_match_child (_tmp50_, _tmp51_, NULL);
	ns_metadata = _tmp52_;
	_tmp53_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp53_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME)) {
		ValaGirParserMetadata* _tmp54_;
		gchar* _tmp55_;
		_tmp54_ = ns_metadata;
		_tmp55_ = vala_gir_parser_metadata_get_string (_tmp54_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp55_;
	}
	_tmp56_ = vala_namespace;
	if (_tmp56_ == NULL) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp57_ = gir_namespace;
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (vala_namespace);
		vala_namespace = _tmp58_;
	}
	_tmp59_ = self->priv->current_source_file;
	_tmp60_ = gir_namespace;
	vala_source_file_set_gir_namespace (_tmp59_, _tmp60_);
	_tmp61_ = self->priv->current_source_file;
	_tmp62_ = gir_version;
	vala_source_file_set_gir_version (_tmp61_, _tmp62_);
	_tmp63_ = vala_namespace;
	vala_gir_parser_push_node (self, _tmp63_, TRUE);
	_tmp64_ = self->priv->current;
	_tmp65_ = _tmp64_->new_symbol;
	if (_tmp65_) {
		const gchar* _tmp66_;
		ValaGirParserNode* _tmp67_;
		ValaSourceReference* _tmp68_;
		ValaNamespace* _tmp69_;
		ValaGirParserNode* _tmp70_;
		ValaNamespace* _tmp71_;
		ValaSymbol* _tmp72_;
		_tmp66_ = vala_namespace;
		_tmp67_ = self->priv->current;
		_tmp68_ = _tmp67_->source_reference;
		_tmp69_ = vala_namespace_new (_tmp66_, _tmp68_);
		_vala_code_node_unref0 (ns);
		ns = _tmp69_;
		_tmp70_ = self->priv->current;
		_tmp71_ = ns;
		_tmp72_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp71_);
		_vala_code_node_unref0 (_tmp70_->symbol);
		_tmp70_->symbol = _tmp72_;
	} else {
		ValaGirParserNode* _tmp73_;
		ValaSymbol* _tmp74_;
		ValaNamespace* _tmp75_;
		ValaNamespace* _tmp76_;
		ValaNamespace* _tmp77_;
		ValaGirParserNode* _tmp78_;
		ValaSourceReference* _tmp79_;
		_tmp73_ = self->priv->current;
		_tmp74_ = _tmp73_->symbol;
		_tmp75_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp74_, VALA_TYPE_NAMESPACE, ValaNamespace));
		_vala_code_node_unref0 (ns);
		ns = _tmp75_;
		_tmp76_ = ns;
		(((ValaCodeNode*) _tmp76_)->attributes == NULL) ? NULL : (((ValaCodeNode*) _tmp76_)->attributes = (_g_list_free__vala_code_node_unref0_ (((ValaCodeNode*) _tmp76_)->attributes), NULL));
		((ValaCodeNode*) _tmp76_)->attributes = NULL;
		_tmp77_ = ns;
		_tmp78_ = self->priv->current;
		_tmp79_ = _tmp78_->source_reference;
		vala_code_node_set_source_reference ((ValaCodeNode*) _tmp77_, _tmp79_);
	}
	_tmp80_ = self->priv->current;
	_tmp81_ = ns_metadata;
	_tmp82_ = _vala_gir_parser_metadata_ref0 (_tmp81_);
	_vala_gir_parser_metadata_unref0 (_tmp80_->metadata);
	_tmp80_->metadata = _tmp82_;
	_tmp83_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp83_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp84_;
		gchar* _tmp85_;
		_tmp84_ = ns_metadata;
		_tmp85_ = vala_gir_parser_metadata_get_string (_tmp84_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (cprefix);
		cprefix = _tmp85_;
	}
	_tmp86_ = ns_metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp86_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
		ValaGirParserMetadata* _tmp87_;
		gchar* _tmp88_;
		_tmp87_ = ns_metadata;
		_tmp88_ = vala_gir_parser_metadata_get_string (_tmp87_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
		_g_free0 (lower_case_cprefix);
		lower_case_cprefix = _tmp88_;
	} else {
		const gchar* _tmp89_;
		_tmp89_ = lower_case_cprefix;
		if (_tmp89_ != NULL) {
			const gchar* _tmp90_;
			gchar* _tmp91_;
			_tmp90_ = lower_case_cprefix;
			_tmp91_ = g_strconcat (_tmp90_, "_", NULL);
			_g_free0 (lower_case_cprefix);
			lower_case_cprefix = _tmp91_;
		}
	}
	_tmp92_ = ns;
	_tmp93_ = gir_namespace;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp92_, "CCode", "gir_namespace", _tmp93_, NULL);
	_tmp94_ = ns;
	_tmp95_ = gir_version;
	vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp94_, "CCode", "gir_version", _tmp95_, NULL);
	_tmp96_ = cprefix;
	if (_tmp96_ != NULL) {
		ValaNamespace* _tmp97_;
		const gchar* _tmp98_;
		const gchar* _tmp99_;
		_tmp97_ = ns;
		_tmp98_ = cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp97_, "CCode", "cprefix", _tmp98_, NULL);
		_tmp99_ = lower_case_cprefix;
		if (_tmp99_ == NULL) {
			ValaNamespace* _tmp100_;
			const gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gchar* _tmp104_;
			gchar* _tmp105_;
			_tmp100_ = ns;
			_tmp101_ = cprefix;
			_tmp102_ = vala_symbol_camel_case_to_lower_case (_tmp101_);
			_tmp103_ = _tmp102_;
			_tmp104_ = g_strconcat (_tmp103_, "_", NULL);
			_tmp105_ = _tmp104_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp100_, "CCode", "lower_case_cprefix", _tmp105_, NULL);
			_g_free0 (_tmp105_);
			_g_free0 (_tmp103_);
		}
	}
	_tmp106_ = lower_case_cprefix;
	if (_tmp106_ != NULL) {
		ValaNamespace* _tmp107_;
		const gchar* _tmp108_;
		_tmp107_ = ns;
		_tmp108_ = lower_case_cprefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp107_, "CCode", "lower_case_cprefix", _tmp108_, NULL);
	}
	_tmp109_ = self->priv->cheader_filenames;
	_tmp109__length1 = self->priv->cheader_filenames_length1;
	if (_tmp109_ != NULL) {
		ValaNamespace* _tmp110_;
		gchar** _tmp111_;
		gint _tmp111__length1;
		gchar* _tmp112_;
		gchar* _tmp113_;
		_tmp110_ = ns;
		_tmp111_ = self->priv->cheader_filenames;
		_tmp111__length1 = self->priv->cheader_filenames_length1;
		_tmp112_ = _vala_g_strjoinv (",", _tmp111_, _tmp111__length1);
		_tmp113_ = _tmp112_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp110_, "CCode", "cheader_filename", _tmp113_, NULL);
		_g_free0 (_tmp113_);
	}
	vala_gir_parser_next (self);
	while (TRUE) {
		ValaMarkupTokenType _tmp114_;
		ValaMarkupReader* _tmp115_;
		const gchar* _tmp116_;
		const gchar* _tmp117_;
		_tmp114_ = self->priv->current_token;
		if (!(_tmp114_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp115_ = self->priv->reader;
		_tmp116_ = vala_markup_reader_get_name (_tmp115_);
		_tmp117_ = _tmp116_;
		if (g_strcmp0 (_tmp117_, "alias") == 0) {
			vala_gir_parser_parse_alias (self);
		} else {
			ValaMarkupReader* _tmp118_;
			const gchar* _tmp119_;
			const gchar* _tmp120_;
			_tmp118_ = self->priv->reader;
			_tmp119_ = vala_markup_reader_get_name (_tmp118_);
			_tmp120_ = _tmp119_;
			if (g_strcmp0 (_tmp120_, "enumeration") == 0) {
				ValaGirParserMetadata* _tmp121_;
				_tmp121_ = self->priv->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp121_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN)) {
					ValaGirParserMetadata* _tmp122_;
					_tmp122_ = self->priv->metadata;
					if (vala_gir_parser_metadata_get_bool (_tmp122_, VALA_GIR_PARSER_ARGUMENT_TYPE_ERRORDOMAIN, FALSE)) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				} else {
					gboolean _tmp123_ = FALSE;
					ValaMarkupReader* _tmp124_;
					gchar* _tmp125_;
					gchar* _tmp126_;
					gboolean _tmp127_;
					_tmp124_ = self->priv->reader;
					_tmp125_ = vala_markup_reader_get_attribute (_tmp124_, "glib:error-quark");
					_tmp126_ = _tmp125_;
					_tmp127_ = _tmp126_ != NULL;
					_g_free0 (_tmp126_);
					if (_tmp127_) {
						_tmp123_ = TRUE;
					} else {
						ValaMarkupReader* _tmp128_;
						gchar* _tmp129_;
						gchar* _tmp130_;
						_tmp128_ = self->priv->reader;
						_tmp129_ = vala_markup_reader_get_attribute (_tmp128_, "glib:error-domain");
						_tmp130_ = _tmp129_;
						_tmp123_ = _tmp130_ != NULL;
						_g_free0 (_tmp130_);
					}
					if (_tmp123_) {
						vala_gir_parser_parse_error_domain (self);
					} else {
						vala_gir_parser_parse_enumeration (self, "enumeration", FALSE);
					}
				}
			} else {
				ValaMarkupReader* _tmp131_;
				const gchar* _tmp132_;
				const gchar* _tmp133_;
				_tmp131_ = self->priv->reader;
				_tmp132_ = vala_markup_reader_get_name (_tmp131_);
				_tmp133_ = _tmp132_;
				if (g_strcmp0 (_tmp133_, "bitfield") == 0) {
					vala_gir_parser_parse_bitfield (self);
				} else {
					ValaMarkupReader* _tmp134_;
					const gchar* _tmp135_;
					const gchar* _tmp136_;
					_tmp134_ = self->priv->reader;
					_tmp135_ = vala_markup_reader_get_name (_tmp134_);
					_tmp136_ = _tmp135_;
					if (g_strcmp0 (_tmp136_, "function") == 0) {
						vala_gir_parser_parse_method (self, "function");
					} else {
						ValaMarkupReader* _tmp137_;
						const gchar* _tmp138_;
						const gchar* _tmp139_;
						_tmp137_ = self->priv->reader;
						_tmp138_ = vala_markup_reader_get_name (_tmp137_);
						_tmp139_ = _tmp138_;
						if (g_strcmp0 (_tmp139_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp140_;
							const gchar* _tmp141_;
							const gchar* _tmp142_;
							_tmp140_ = self->priv->reader;
							_tmp141_ = vala_markup_reader_get_name (_tmp140_);
							_tmp142_ = _tmp141_;
							if (g_strcmp0 (_tmp142_, "callback") == 0) {
								vala_gir_parser_parse_callback (self);
							} else {
								ValaMarkupReader* _tmp143_;
								const gchar* _tmp144_;
								const gchar* _tmp145_;
								_tmp143_ = self->priv->reader;
								_tmp144_ = vala_markup_reader_get_name (_tmp143_);
								_tmp145_ = _tmp144_;
								if (g_strcmp0 (_tmp145_, "record") == 0) {
									ValaGirParserMetadata* _tmp146_;
									_tmp146_ = self->priv->metadata;
									if (vala_gir_parser_metadata_has_argument (_tmp146_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT)) {
										ValaGirParserMetadata* _tmp147_;
										_tmp147_ = self->priv->metadata;
										if (vala_gir_parser_metadata_get_bool (_tmp147_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE)) {
											vala_gir_parser_parse_record (self);
										} else {
											vala_gir_parser_parse_boxed (self, "record");
										}
									} else {
										gchar* _tmp148_;
										gchar* _tmp149_;
										gboolean _tmp150_;
										_tmp148_ = vala_gir_parser_element_get_type_id (self);
										_tmp149_ = _tmp148_;
										_tmp150_ = _tmp149_ != NULL;
										_g_free0 (_tmp149_);
										if (_tmp150_) {
											vala_gir_parser_parse_boxed (self, "record");
										} else {
											ValaMarkupReader* _tmp151_;
											gchar* _tmp152_;
											gchar* _tmp153_;
											gboolean _tmp154_;
											_tmp151_ = self->priv->reader;
											_tmp152_ = vala_markup_reader_get_attribute (_tmp151_, "name");
											_tmp153_ = _tmp152_;
											_tmp154_ = !g_str_has_suffix (_tmp153_, "Private");
											_g_free0 (_tmp153_);
											if (_tmp154_) {
												gboolean _tmp155_ = FALSE;
												ValaMarkupReader* _tmp156_;
												gchar* _tmp157_;
												gchar* _tmp158_;
												gboolean _tmp159_;
												_tmp156_ = self->priv->reader;
												_tmp157_ = vala_markup_reader_get_attribute (_tmp156_, "glib:is-gtype-struct-for");
												_tmp158_ = _tmp157_;
												_tmp159_ = _tmp158_ == NULL;
												_g_free0 (_tmp158_);
												if (_tmp159_) {
													ValaMarkupReader* _tmp160_;
													gchar* _tmp161_;
													gchar* _tmp162_;
													_tmp160_ = self->priv->reader;
													_tmp161_ = vala_markup_reader_get_attribute (_tmp160_, "disguised");
													_tmp162_ = _tmp161_;
													_tmp155_ = g_strcmp0 (_tmp162_, "1") == 0;
													_g_free0 (_tmp162_);
												} else {
													_tmp155_ = FALSE;
												}
												if (_tmp155_) {
													vala_gir_parser_parse_boxed (self, "record");
												} else {
													vala_gir_parser_parse_record (self);
												}
											} else {
												vala_gir_parser_skip_element (self);
											}
										}
									}
								} else {
									ValaMarkupReader* _tmp163_;
									const gchar* _tmp164_;
									const gchar* _tmp165_;
									_tmp163_ = self->priv->reader;
									_tmp164_ = vala_markup_reader_get_name (_tmp163_);
									_tmp165_ = _tmp164_;
									if (g_strcmp0 (_tmp165_, "class") == 0) {
										vala_gir_parser_parse_class (self);
									} else {
										ValaMarkupReader* _tmp166_;
										const gchar* _tmp167_;
										const gchar* _tmp168_;
										_tmp166_ = self->priv->reader;
										_tmp167_ = vala_markup_reader_get_name (_tmp166_);
										_tmp168_ = _tmp167_;
										if (g_strcmp0 (_tmp168_, "interface") == 0) {
											vala_gir_parser_parse_interface (self);
										} else {
											ValaMarkupReader* _tmp169_;
											const gchar* _tmp170_;
											const gchar* _tmp171_;
											_tmp169_ = self->priv->reader;
											_tmp170_ = vala_markup_reader_get_name (_tmp169_);
											_tmp171_ = _tmp170_;
											if (g_strcmp0 (_tmp171_, "glib:boxed") == 0) {
												vala_gir_parser_parse_boxed (self, "glib:boxed");
											} else {
												ValaMarkupReader* _tmp172_;
												const gchar* _tmp173_;
												const gchar* _tmp174_;
												_tmp172_ = self->priv->reader;
												_tmp173_ = vala_markup_reader_get_name (_tmp172_);
												_tmp174_ = _tmp173_;
												if (g_strcmp0 (_tmp174_, "union") == 0) {
													gboolean _tmp175_ = FALSE;
													gchar* _tmp176_;
													gchar* _tmp177_;
													gboolean _tmp178_;
													_tmp176_ = vala_gir_parser_element_get_type_id (self);
													_tmp177_ = _tmp176_;
													_tmp178_ = _tmp177_ != NULL;
													_g_free0 (_tmp177_);
													if (_tmp178_) {
														ValaGirParserMetadata* _tmp179_;
														_tmp179_ = self->priv->metadata;
														_tmp175_ = !vala_gir_parser_metadata_get_bool (_tmp179_, VALA_GIR_PARSER_ARGUMENT_TYPE_STRUCT, FALSE);
													} else {
														_tmp175_ = FALSE;
													}
													if (_tmp175_) {
														vala_gir_parser_parse_boxed (self, "union");
													} else {
														vala_gir_parser_parse_union (self);
													}
												} else {
													ValaMarkupReader* _tmp180_;
													const gchar* _tmp181_;
													const gchar* _tmp182_;
													_tmp180_ = self->priv->reader;
													_tmp181_ = vala_markup_reader_get_name (_tmp180_);
													_tmp182_ = _tmp181_;
													if (g_strcmp0 (_tmp182_, "constant") == 0) {
														vala_gir_parser_parse_constant (self);
													} else {
														ValaMarkupReader* _tmp183_;
														const gchar* _tmp184_;
														const gchar* _tmp185_;
														_tmp183_ = self->priv->reader;
														_tmp184_ = vala_markup_reader_get_name (_tmp183_);
														_tmp185_ = _tmp184_;
														if (g_strcmp0 (_tmp185_, "docsection") == 0) {
															vala_gir_parser_skip_element (self);
														} else {
															ValaSourceReference* _tmp186_;
															ValaSourceReference* _tmp187_;
															ValaMarkupReader* _tmp188_;
															const gchar* _tmp189_;
															const gchar* _tmp190_;
															gchar* _tmp191_;
															gchar* _tmp192_;
															_tmp186_ = vala_gir_parser_get_current_src (self);
															_tmp187_ = _tmp186_;
															_tmp188_ = self->priv->reader;
															_tmp189_ = vala_markup_reader_get_name (_tmp188_);
															_tmp190_ = _tmp189_;
															_tmp191_ = g_strdup_printf ("unknown child element `%s' in `namespace'", _tmp190_);
															_tmp192_ = _tmp191_;
															vala_report_error (_tmp187_, _tmp192_);
															_g_free0 (_tmp192_);
															_vala_source_reference_unref0 (_tmp187_);
															vala_gir_parser_skip_element (self);
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "namespace");
	_vala_code_node_unref0 (ns);
	_vala_gir_parser_metadata_unref0 (ns_metadata);
	_g_free0 (metadata_filename);
	_g_free0 (gir_version);
	_g_free0 (gir_namespace);
	_g_free0 (vala_namespace);
	_g_free0 (lower_case_cprefix);
	_g_free0 (cprefix);
}


static void
vala_gir_parser_parse_alias (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserNode* _tmp2_;
	ValaGirComment* _tmp3_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaGirParserNode* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserMetadata* _tmp12_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "alias");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->comment;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		ValaGirComment* _tmp5_;
		_tmp4_ = self->priv->current;
		_tmp5_ = vala_gir_parser_parse_symbol_doc (self);
		_vala_comment_unref0 (_tmp4_->comment);
		_tmp4_->comment = _tmp5_;
	} else {
		ValaGirComment* _tmp6_;
		ValaGirComment* _tmp7_;
		_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp7_ = _tmp6_;
		_vala_comment_unref0 (_tmp7_);
	}
	no_array_length = FALSE;
	array_null_terminated = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_gir_parser_element_get_type (self, _tmp10_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (_tmp8_->base_type);
	_tmp8_->base_type = _tmp11_;
	_vala_code_node_unref0 (_tmp10_);
	_tmp12_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaGirParserNode* _tmp13_;
		ValaGirParserMetadata* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		ValaGirParserMetadata* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp13_ = self->priv->current;
		_tmp14_ = self->priv->metadata;
		_tmp15_ = vala_gir_parser_metadata_get_string (_tmp14_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp16_ = _tmp15_;
		_tmp17_ = self->priv->metadata;
		_tmp18_ = vala_gir_parser_metadata_get_source_reference (_tmp17_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_gir_parser_parse_type_from_string (self, _tmp16_, TRUE, _tmp19_);
		_vala_code_node_unref0 (_tmp13_->base_type);
		_tmp13_->base_type = _tmp20_;
		_vala_source_reference_unref0 (_tmp19_);
		_g_free0 (_tmp16_);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "alias");
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


static void
vala_gir_parser_calculate_common_prefix (ValaGirParser* self,
                                         gchar* * common_prefix,
                                         const gchar* cname)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	if ((*common_prefix) == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (cname);
		_g_free0 (*common_prefix);
		*common_prefix = _tmp0_;
		while (TRUE) {
			gboolean _tmp1_ = FALSE;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			gchar* _tmp6_;
			_tmp2_ = strlen (*common_prefix);
			_tmp3_ = _tmp2_;
			if (_tmp3_ > 0) {
				_tmp1_ = !g_str_has_suffix (*common_prefix, "_");
			} else {
				_tmp1_ = FALSE;
			}
			if (!_tmp1_) {
				break;
			}
			_tmp4_ = strlen (*common_prefix);
			_tmp5_ = _tmp4_;
			_tmp6_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp5_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp6_;
		}
	} else {
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gchar* _tmp9_;
			if (!(!g_str_has_prefix (cname, *common_prefix))) {
				break;
			}
			_tmp7_ = strlen (*common_prefix);
			_tmp8_ = _tmp7_;
			_tmp9_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp8_ - 1));
			_g_free0 (*common_prefix);
			*common_prefix = _tmp9_;
		}
	}
	while (TRUE) {
		gboolean _tmp10_ = FALSE;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		_tmp11_ = strlen (*common_prefix);
		_tmp12_ = _tmp11_;
		if (_tmp12_ > 0) {
			gboolean _tmp13_ = FALSE;
			if (!g_str_has_suffix (*common_prefix, "_")) {
				_tmp13_ = TRUE;
			} else {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp16_;
				_tmp15_ = strlen (*common_prefix);
				_tmp16_ = _tmp15_;
				if (g_unichar_isdigit (string_get_char (cname, (glong) _tmp16_))) {
					gint _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					gint _tmp20_;
					_tmp17_ = strlen (cname);
					_tmp18_ = _tmp17_;
					_tmp19_ = strlen (*common_prefix);
					_tmp20_ = _tmp19_;
					_tmp14_ = (_tmp18_ - _tmp20_) <= 1;
				} else {
					_tmp14_ = FALSE;
				}
				_tmp13_ = _tmp14_;
			}
			_tmp10_ = _tmp13_;
		} else {
			_tmp10_ = FALSE;
		}
		if (!_tmp10_) {
			break;
		}
		_tmp21_ = strlen (*common_prefix);
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (*common_prefix, (glong) 0, (glong) (_tmp22_ - 1));
		_g_free0 (*common_prefix);
		*common_prefix = _tmp23_;
	}
}


static ValaGirComment*
vala_gir_parser_parse_symbol_doc (ValaGirParser* self)
{
	ValaGirComment* result = NULL;
	ValaGirComment* comment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaGirComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_gir_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = reader_name;
					if (g_strcmp0 (_tmp18_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}


static ValaComment*
vala_gir_parser_parse_doc (ValaGirParser* self)
{
	ValaComment* result = NULL;
	ValaComment* comment = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	comment = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp0_;
		const gchar* reader_name = NULL;
		ValaMarkupReader* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = self->priv->current_token;
		if (!(_tmp0_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp1_ = self->priv->reader;
		_tmp2_ = vala_markup_reader_get_name (_tmp1_);
		_tmp3_ = _tmp2_;
		reader_name = _tmp3_;
		_tmp4_ = reader_name;
		if (g_strcmp0 (_tmp4_, "doc") == 0) {
			ValaMarkupTokenType _tmp5_;
			vala_gir_parser_start_element (self, "doc");
			vala_gir_parser_next (self);
			_tmp5_ = self->priv->current_token;
			if (_tmp5_ == VALA_MARKUP_TOKEN_TYPE_TEXT) {
				ValaMarkupReader* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				ValaGirParserNode* _tmp9_;
				ValaSourceReference* _tmp10_;
				ValaComment* _tmp11_;
				_tmp6_ = self->priv->reader;
				_tmp7_ = vala_markup_reader_get_content (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = self->priv->current;
				_tmp10_ = _tmp9_->source_reference;
				_tmp11_ = vala_comment_new (_tmp8_, _tmp10_);
				_vala_comment_unref0 (comment);
				comment = _tmp11_;
				vala_gir_parser_next (self);
			}
			vala_gir_parser_end_element (self, "doc");
		} else {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_ = FALSE;
			const gchar* _tmp14_;
			_tmp14_ = reader_name;
			if (g_strcmp0 (_tmp14_, "doc-version") == 0) {
				_tmp13_ = TRUE;
			} else {
				const gchar* _tmp15_;
				_tmp15_ = reader_name;
				_tmp13_ = g_strcmp0 (_tmp15_, "doc-deprecated") == 0;
			}
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				const gchar* _tmp16_;
				_tmp16_ = reader_name;
				_tmp12_ = g_strcmp0 (_tmp16_, "doc-stability") == 0;
			}
			if (_tmp12_) {
				vala_gir_parser_skip_element (self);
			} else {
				const gchar* _tmp17_;
				_tmp17_ = reader_name;
				if (g_strcmp0 (_tmp17_, "source-position") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					const gchar* _tmp18_;
					_tmp18_ = reader_name;
					if (g_strcmp0 (_tmp18_, "attribute") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						break;
					}
				}
			}
		}
	}
	result = comment;
	return result;
}


static void
vala_gir_parser_parse_enumeration (ValaGirParser* self,
                                   const gchar* element_name,
                                   gboolean error_domain)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaSymbol* sym = NULL;
	ValaGirParserNode* _tmp2_;
	gboolean _tmp3_;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	gchar* common_prefix = NULL;
	gboolean explicit_prefix = FALSE;
	ValaGirParserMetadata* _tmp26_;
	gboolean has_member = FALSE;
	ValaSymbol* _tmp31_;
	ValaGirComment* _tmp32_;
	ValaGirComment* _tmp33_;
	gboolean _tmp55_;
	const gchar* _tmp62_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->new_symbol;
	if (_tmp3_) {
		ValaGirParserNode* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		if (error_domain) {
			ValaGirParserNode* _tmp4_;
			const gchar* _tmp5_;
			ValaGirParserNode* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaErrorDomain* _tmp8_;
			_tmp4_ = self->priv->current;
			_tmp5_ = _tmp4_->name;
			_tmp6_ = self->priv->current;
			_tmp7_ = _tmp6_->source_reference;
			_tmp8_ = vala_error_domain_new (_tmp5_, _tmp7_, NULL);
			_vala_code_node_unref0 (sym);
			sym = (ValaSymbol*) _tmp8_;
		} else {
			ValaEnum* en = NULL;
			ValaGirParserNode* _tmp9_;
			const gchar* _tmp10_;
			ValaGirParserNode* _tmp11_;
			ValaSourceReference* _tmp12_;
			ValaEnum* _tmp13_;
			ValaEnum* _tmp15_;
			ValaSymbol* _tmp16_;
			_tmp9_ = self->priv->current;
			_tmp10_ = _tmp9_->name;
			_tmp11_ = self->priv->current;
			_tmp12_ = _tmp11_->source_reference;
			_tmp13_ = vala_enum_new (_tmp10_, _tmp12_, NULL);
			en = _tmp13_;
			if (g_strcmp0 (element_name, "bitfield") == 0) {
				ValaEnum* _tmp14_;
				_tmp14_ = en;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp14_, "Flags", TRUE, NULL);
			}
			_tmp15_ = en;
			_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp15_);
			_vala_code_node_unref0 (sym);
			sym = _tmp16_;
			_vala_code_node_unref0 (en);
		}
		_tmp17_ = self->priv->current;
		_tmp18_ = sym;
		_tmp19_ = _vala_code_node_ref0 (_tmp18_);
		_vala_code_node_unref0 (_tmp17_->symbol);
		_tmp17_->symbol = _tmp19_;
	} else {
		ValaGirParserNode* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		_tmp20_ = self->priv->current;
		_tmp21_ = _tmp20_->symbol;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		_vala_code_node_unref0 (sym);
		sym = _tmp22_;
	}
	if (!error_domain) {
		ValaSymbol* _tmp23_;
		_tmp23_ = sym;
		vala_gir_parser_set_type_id_ccode (self, _tmp23_);
	}
	_tmp24_ = sym;
	vala_symbol_set_external (_tmp24_, TRUE);
	_tmp25_ = sym;
	vala_symbol_set_access (_tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	common_prefix = NULL;
	explicit_prefix = FALSE;
	_tmp26_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaSymbol* _tmp27_;
		ValaGirParserMetadata* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp27_ = sym;
		_tmp28_ = self->priv->metadata;
		_tmp29_ = vala_gir_parser_metadata_get_string (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_tmp30_ = _tmp29_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp27_, "CCode", "cprefix", _tmp30_, NULL);
		_g_free0 (_tmp30_);
		explicit_prefix = TRUE;
	}
	has_member = FALSE;
	vala_gir_parser_next (self);
	_tmp31_ = sym;
	_tmp32_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp33_ = _tmp32_;
	vala_symbol_set_comment (_tmp31_, (ValaComment*) _tmp33_);
	_vala_comment_unref0 (_tmp33_);
	while (TRUE) {
		ValaMarkupTokenType _tmp34_;
		ValaMarkupReader* _tmp35_;
		const gchar* _tmp36_;
		const gchar* _tmp37_;
		_tmp34_ = self->priv->current_token;
		if (!(_tmp34_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp35_ = self->priv->reader;
		_tmp36_ = vala_markup_reader_get_name (_tmp35_);
		_tmp37_ = _tmp36_;
		if (g_strcmp0 (_tmp37_, "member") == 0) {
			gboolean _tmp38_;
			has_member = TRUE;
			if (error_domain) {
				vala_gir_parser_parse_error_member (self);
			} else {
				vala_gir_parser_parse_enumeration_member (self);
			}
			_tmp38_ = explicit_prefix;
			if (!_tmp38_) {
				ValaGirParserNode* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				_tmp39_ = self->priv->old_current;
				_tmp40_ = vala_gir_parser_node_get_cname (_tmp39_);
				_tmp41_ = _tmp40_;
				vala_gir_parser_calculate_common_prefix (self, &common_prefix, _tmp41_);
				_g_free0 (_tmp41_);
			}
		} else {
			ValaMarkupReader* _tmp42_;
			const gchar* _tmp43_;
			const gchar* _tmp44_;
			_tmp42_ = self->priv->reader;
			_tmp43_ = vala_markup_reader_get_name (_tmp42_);
			_tmp44_ = _tmp43_;
			if (g_strcmp0 (_tmp44_, "function") == 0) {
				vala_gir_parser_skip_element (self);
			} else {
				ValaMarkupReader* _tmp45_;
				const gchar* _tmp46_;
				const gchar* _tmp47_;
				_tmp45_ = self->priv->reader;
				_tmp46_ = vala_markup_reader_get_name (_tmp45_);
				_tmp47_ = _tmp46_;
				if (g_strcmp0 (_tmp47_, "function-macro") == 0) {
					vala_gir_parser_skip_element (self);
				} else {
					ValaSourceReference* _tmp48_;
					ValaSourceReference* _tmp49_;
					ValaMarkupReader* _tmp50_;
					const gchar* _tmp51_;
					const gchar* _tmp52_;
					gchar* _tmp53_;
					gchar* _tmp54_;
					_tmp48_ = vala_gir_parser_get_current_src (self);
					_tmp49_ = _tmp48_;
					_tmp50_ = self->priv->reader;
					_tmp51_ = vala_markup_reader_get_name (_tmp50_);
					_tmp52_ = _tmp51_;
					_tmp53_ = g_strdup_printf ("unknown child element `%s' in `%s'", _tmp52_, element_name);
					_tmp54_ = _tmp53_;
					vala_report_error (_tmp49_, _tmp54_);
					_g_free0 (_tmp54_);
					_vala_source_reference_unref0 (_tmp49_);
					vala_gir_parser_skip_element (self);
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp55_ = has_member;
	if (!_tmp55_) {
		ValaSourceReference* _tmp56_;
		ValaSourceReference* _tmp57_;
		ValaGirParserNode* _tmp58_;
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp56_ = vala_gir_parser_get_current_src (self);
		_tmp57_ = _tmp56_;
		_tmp58_ = self->priv->current;
		_tmp59_ = _tmp58_->name;
		_tmp60_ = g_strdup_printf ("%s `%s' has no members", element_name, _tmp59_);
		_tmp61_ = _tmp60_;
		vala_report_error (_tmp57_, _tmp61_);
		_g_free0 (_tmp61_);
		_vala_source_reference_unref0 (_tmp57_);
	}
	_tmp62_ = common_prefix;
	if (_tmp62_ != NULL) {
		ValaSymbol* _tmp63_;
		const gchar* _tmp64_;
		_tmp63_ = sym;
		_tmp64_ = common_prefix;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp63_, "CCode", "cprefix", _tmp64_, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_g_free0 (common_prefix);
	_vala_code_node_unref0 (sym);
}


static void
vala_gir_parser_parse_error_domain (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "enumeration", TRUE);
}


static void
vala_gir_parser_parse_bitfield (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_enumeration (self, "bitfield", FALSE);
}


static void
vala_gir_parser_parse_enumeration_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaEnumValue* ev = NULL;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	ValaGirParserMetadata* _tmp8_;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaGirParserNode* _tmp11_;
	ValaSourceReference* _tmp12_;
	ValaEnumValue* _tmp13_;
	ValaEnumValue* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaGirComment* _tmp17_;
	ValaGirComment* _tmp18_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->current;
	_tmp7_ = _tmp6_->name;
	_tmp8_ = self->priv->metadata;
	_tmp9_ = vala_gir_parser_metadata_get_expression (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
	_tmp10_ = _tmp9_;
	_tmp11_ = self->priv->current;
	_tmp12_ = _tmp11_->source_reference;
	_tmp13_ = vala_enum_value_new (_tmp7_, _tmp10_, _tmp12_, NULL);
	_tmp14_ = _tmp13_;
	_vala_code_node_unref0 (_tmp10_);
	ev = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = _vala_code_node_ref0 ((ValaSymbol*) ev);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp16_;
	vala_gir_parser_next (self);
	_tmp17_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp18_ = _tmp17_;
	vala_symbol_set_comment ((ValaSymbol*) ev, (ValaComment*) _tmp18_);
	_vala_comment_unref0 (_tmp18_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_vala_code_node_unref0 (ev);
}


static void
vala_gir_parser_parse_error_member (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaErrorCode* ec = NULL;
	gchar* value = NULL;
	ValaMarkupReader* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	ValaGirParserNode* _tmp18_;
	ValaErrorCode* _tmp19_;
	ValaSymbol* _tmp20_;
	ValaErrorCode* _tmp21_;
	ValaGirComment* _tmp22_;
	ValaGirComment* _tmp23_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "member");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_ascii_strup (_tmp1_, (gssize) -1);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_replace (_tmp3_, "-", "_");
	_tmp5_ = _tmp4_;
	vala_gir_parser_push_node (self, _tmp5_, FALSE);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = self->priv->reader;
	_tmp7_ = vala_markup_reader_get_attribute (_tmp6_, "value");
	value = _tmp7_;
	_tmp8_ = value;
	if (_tmp8_ != NULL) {
		ValaGirParserNode* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		ValaIntegerLiteral* _tmp12_;
		ValaIntegerLiteral* _tmp13_;
		ValaErrorCode* _tmp14_;
		_tmp9_ = self->priv->current;
		_tmp10_ = _tmp9_->name;
		_tmp11_ = value;
		_tmp12_ = vala_integer_literal_new (_tmp11_, NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_error_code_new_with_value (_tmp10_, (ValaExpression*) _tmp13_, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp14_;
		_vala_code_node_unref0 (_tmp13_);
	} else {
		ValaGirParserNode* _tmp15_;
		const gchar* _tmp16_;
		ValaErrorCode* _tmp17_;
		_tmp15_ = self->priv->current;
		_tmp16_ = _tmp15_->name;
		_tmp17_ = vala_error_code_new (_tmp16_, NULL, NULL);
		_vala_code_node_unref0 (ec);
		ec = _tmp17_;
	}
	_tmp18_ = self->priv->current;
	_tmp19_ = ec;
	_tmp20_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp19_);
	_vala_code_node_unref0 (_tmp18_->symbol);
	_tmp18_->symbol = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = ec;
	_tmp22_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp23_ = _tmp22_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp21_, (ValaComment*) _tmp23_);
	_vala_comment_unref0 (_tmp23_);
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "member");
	_g_free0 (value);
	_vala_code_node_unref0 (ec);
}


static ValaDataType*
vala_gir_parser_parse_return_value (ValaGirParser* self,
                                    gchar* * ctype,
                                    gint* array_length_idx,
                                    gboolean* no_array_length,
                                    gboolean* array_null_terminated,
                                    ValaComment* * comment)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaComment* _vala_comment = NULL;
	ValaDataType* result = NULL;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaComment* _tmp6_;
	gboolean transfer_elements = FALSE;
	const gchar* _tmp7_;
	ValaDataType* type = NULL;
	gboolean _tmp8_;
	gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	gboolean _tmp14_ = FALSE;
	const gchar* _tmp15_;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "return-value");
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "transfer-ownership");
	transfer = _tmp1_;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp6_;
	_tmp7_ = transfer;
	transfer_elements = g_strcmp0 (_tmp7_, "container") != 0;
	_tmp8_ = transfer_elements;
	_tmp13_ = vala_gir_parser_parse_type (self, &_tmp9_, &_tmp10_, _tmp8_, &_tmp11_, &_tmp12_);
	_g_free0 (_vala_ctype);
	_vala_ctype = _tmp9_;
	_vala_array_length_idx = _tmp10_;
	_vala_no_array_length = _tmp11_;
	_vala_array_null_terminated = _tmp12_;
	type = _tmp13_;
	_tmp15_ = transfer;
	if (g_strcmp0 (_tmp15_, "full") == 0) {
		_tmp14_ = TRUE;
	} else {
		const gchar* _tmp16_;
		_tmp16_ = transfer;
		_tmp14_ = g_strcmp0 (_tmp16_, "container") == 0;
	}
	if (_tmp14_) {
		ValaDataType* _tmp17_;
		_tmp17_ = type;
		vala_data_type_set_value_owned (_tmp17_, TRUE);
	}
	_tmp19_ = nullable;
	if (g_strcmp0 (_tmp19_, "1") == 0) {
		_tmp18_ = TRUE;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = allow_none;
		_tmp18_ = g_strcmp0 (_tmp20_, "1") == 0;
	}
	if (_tmp18_) {
		ValaDataType* _tmp21_;
		_tmp21_ = type;
		vala_data_type_set_nullable (_tmp21_, TRUE);
	}
	_tmp22_ = type;
	_tmp23_ = vala_gir_parser_element_get_type (self, _tmp22_, TRUE, &_vala_no_array_length, &_vala_array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp23_;
	vala_gir_parser_end_element (self, "return-value");
	result = type;
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}


static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gboolean result = FALSE;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}


static ValaParameter*
vala_gir_parser_parse_parameter (ValaGirParser* self,
                                 gint* array_length_idx,
                                 gint* closure_idx,
                                 gint* destroy_idx,
                                 gchar* * scope,
                                 ValaComment* * comment,
                                 const gchar* default_name)
{
	gint _vala_array_length_idx = 0;
	gint _vala_closure_idx = 0;
	gint _vala_destroy_idx = 0;
	gchar* _vala_scope = NULL;
	ValaComment* _vala_comment = NULL;
	ValaParameter* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaParameter* param = NULL;
	gchar* element_type = NULL;
	ValaMarkupReader* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMarkupTokenType _tmp6_;
	const gchar* _tmp12_;
	gchar* name = NULL;
	ValaGirParserMetadata* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp18_;
	gchar* direction = NULL;
	ValaGirParserMetadata* _tmp25_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp33_;
	gchar* _tmp34_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp35_;
	gchar* _tmp36_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	gchar* closure = NULL;
	ValaMarkupReader* _tmp40_;
	gchar* _tmp41_;
	gchar* destroy = NULL;
	ValaMarkupReader* _tmp42_;
	gchar* _tmp43_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	gboolean _tmp47_ = FALSE;
	const gchar* _tmp48_;
	ValaGirParserMetadata* _tmp50_;
	ValaGirParserMetadata* _tmp52_;
	ValaComment* _tmp54_;
	ValaMarkupReader* _tmp55_;
	const gchar* _tmp56_;
	const gchar* _tmp57_;
	const gchar* _tmp119_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_vala_array_length_idx = -1;
	_vala_closure_idx = -1;
	_vala_destroy_idx = -1;
	_tmp1_ = self->priv->reader;
	_tmp2_ = vala_markup_reader_get_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	element_type = _tmp4_;
	_tmp6_ = self->priv->current_token;
	if (_tmp6_ != VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		_tmp5_ = TRUE;
	} else {
		gboolean _tmp7_ = FALSE;
		const gchar* _tmp8_;
		_tmp8_ = element_type;
		if (g_strcmp0 (_tmp8_, "parameter") != 0) {
			const gchar* _tmp9_;
			_tmp9_ = element_type;
			_tmp7_ = g_strcmp0 (_tmp9_, "instance-parameter") != 0;
		} else {
			_tmp7_ = FALSE;
		}
		_tmp5_ = _tmp7_;
	}
	if (_tmp5_) {
		ValaSourceReference* _tmp10_;
		ValaSourceReference* _tmp11_;
		_tmp10_ = vala_gir_parser_get_current_src (self);
		_tmp11_ = _tmp10_;
		vala_report_error (_tmp11_, "expected start element of `parameter' or `instance-parameter'");
		_vala_source_reference_unref0 (_tmp11_);
	}
	_tmp12_ = element_type;
	vala_gir_parser_start_element (self, _tmp12_);
	_tmp13_ = self->priv->metadata;
	_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	name = _tmp14_;
	_tmp15_ = name;
	if (_tmp15_ == NULL) {
		ValaMarkupReader* _tmp16_;
		gchar* _tmp17_;
		_tmp16_ = self->priv->reader;
		_tmp17_ = vala_markup_reader_get_attribute (_tmp16_, "name");
		_g_free0 (name);
		name = _tmp17_;
	}
	_tmp18_ = name;
	if (_tmp18_ == NULL) {
		gchar* _tmp19_;
		_tmp19_ = g_strdup (default_name);
		_g_free0 (name);
		name = _tmp19_;
	} else {
		const gchar* _tmp20_;
		_tmp20_ = name;
		if (string_contains (_tmp20_, "-")) {
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp21_ = vala_gir_parser_get_current_src (self);
			_tmp22_ = _tmp21_;
			vala_report_warning (_tmp22_, "parameter name contains hyphen");
			_vala_source_reference_unref0 (_tmp22_);
			_tmp23_ = name;
			_tmp24_ = string_replace (_tmp23_, "-", "_");
			_g_free0 (name);
			name = _tmp24_;
		}
	}
	direction = NULL;
	_tmp25_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp25_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT)) {
		ValaGirParserMetadata* _tmp26_;
		_tmp26_ = self->priv->metadata;
		if (vala_gir_parser_metadata_get_bool (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_OUT, FALSE)) {
			gchar* _tmp27_;
			_tmp27_ = g_strdup ("out");
			_g_free0 (direction);
			direction = _tmp27_;
		}
	} else {
		ValaGirParserMetadata* _tmp28_;
		_tmp28_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF)) {
			ValaGirParserMetadata* _tmp29_;
			_tmp29_ = self->priv->metadata;
			if (vala_gir_parser_metadata_get_bool (_tmp29_, VALA_GIR_PARSER_ARGUMENT_TYPE_REF, FALSE)) {
				gchar* _tmp30_;
				_tmp30_ = g_strdup ("inout");
				_g_free0 (direction);
				direction = _tmp30_;
			}
		} else {
			ValaMarkupReader* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = self->priv->reader;
			_tmp32_ = vala_markup_reader_get_attribute (_tmp31_, "direction");
			_g_free0 (direction);
			direction = _tmp32_;
		}
	}
	_tmp33_ = self->priv->reader;
	_tmp34_ = vala_markup_reader_get_attribute (_tmp33_, "transfer-ownership");
	transfer = _tmp34_;
	_tmp35_ = self->priv->reader;
	_tmp36_ = vala_markup_reader_get_attribute (_tmp35_, "nullable");
	nullable = _tmp36_;
	_tmp37_ = self->priv->reader;
	_tmp38_ = vala_markup_reader_get_attribute (_tmp37_, "allow-none");
	allow_none = _tmp38_;
	_tmp39_ = vala_gir_parser_element_get_string (self, "scope", VALA_GIR_PARSER_ARGUMENT_TYPE_SCOPE);
	_g_free0 (_vala_scope);
	_vala_scope = _tmp39_;
	_tmp40_ = self->priv->reader;
	_tmp41_ = vala_markup_reader_get_attribute (_tmp40_, "closure");
	closure = _tmp41_;
	_tmp42_ = self->priv->reader;
	_tmp43_ = vala_markup_reader_get_attribute (_tmp42_, "destroy");
	destroy = _tmp43_;
	_tmp45_ = closure;
	if (_tmp45_ != NULL) {
		_tmp44_ = (&_vala_closure_idx) != NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		const gchar* _tmp46_;
		_tmp46_ = closure;
		_vala_closure_idx = atoi (_tmp46_);
	}
	_tmp48_ = destroy;
	if (_tmp48_ != NULL) {
		_tmp47_ = (&_vala_destroy_idx) != NULL;
	} else {
		_tmp47_ = FALSE;
	}
	if (_tmp47_) {
		const gchar* _tmp49_;
		_tmp49_ = destroy;
		_vala_destroy_idx = atoi (_tmp49_);
	}
	_tmp50_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp50_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE)) {
		ValaGirParserMetadata* _tmp51_;
		_tmp51_ = self->priv->metadata;
		_vala_closure_idx = vala_gir_parser_metadata_get_integer (_tmp51_, VALA_GIR_PARSER_ARGUMENT_TYPE_CLOSURE);
	}
	_tmp52_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp52_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY)) {
		ValaGirParserMetadata* _tmp53_;
		_tmp53_ = self->priv->metadata;
		_vala_destroy_idx = vala_gir_parser_metadata_get_integer (_tmp53_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROY);
	}
	vala_gir_parser_next (self);
	_tmp54_ = vala_gir_parser_parse_doc (self);
	_vala_comment_unref0 (_vala_comment);
	_vala_comment = _tmp54_;
	_tmp55_ = self->priv->reader;
	_tmp56_ = vala_markup_reader_get_name (_tmp55_);
	_tmp57_ = _tmp56_;
	if (g_strcmp0 (_tmp57_, "varargs") == 0) {
		ValaSourceLocation _tmp58_;
		ValaSourceReference* _tmp59_;
		ValaSourceReference* _tmp60_;
		ValaParameter* _tmp61_;
		vala_gir_parser_start_element (self, "varargs");
		vala_gir_parser_next (self);
		_tmp58_ = begin;
		_tmp59_ = vala_gir_parser_get_src (self, &_tmp58_, NULL);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_parameter_new_with_ellipsis (_tmp60_);
		_vala_code_node_unref0 (param);
		param = _tmp61_;
		_vala_source_reference_unref0 (_tmp60_);
		vala_gir_parser_end_element (self, "varargs");
	} else {
		gchar* ctype = NULL;
		gboolean no_array_length = FALSE;
		gboolean array_null_terminated = FALSE;
		ValaDataType* type = NULL;
		const gchar* _tmp62_;
		gchar* _tmp63_ = NULL;
		gint _tmp64_ = 0;
		gboolean _tmp65_ = FALSE;
		gboolean _tmp66_ = FALSE;
		ValaDataType* _tmp67_;
		gboolean _tmp68_ = FALSE;
		gboolean _tmp69_ = FALSE;
		const gchar* _tmp70_;
		gboolean _tmp74_ = FALSE;
		const gchar* _tmp75_;
		gboolean changed = FALSE;
		gboolean _tmp80_ = FALSE;
		const gchar* _tmp81_;
		ValaDataType* _tmp83_;
		gboolean _tmp84_ = FALSE;
		ValaDataType* _tmp85_;
		gboolean _tmp86_;
		const gchar* _tmp87_;
		ValaDataType* _tmp88_;
		ValaSourceLocation _tmp89_;
		ValaSourceReference* _tmp90_;
		ValaSourceReference* _tmp91_;
		ValaParameter* _tmp92_;
		const gchar* _tmp93_;
		const gchar* _tmp96_;
		ValaDataType* _tmp100_;
		ValaParameter* _tmp111_;
		ValaGirParserMetadata* _tmp112_;
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		ValaParameter* _tmp115_;
		ValaExpression* _tmp116_;
		ValaExpression* _tmp117_;
		_tmp62_ = transfer;
		_tmp67_ = vala_gir_parser_parse_type (self, &_tmp63_, &_tmp64_, g_strcmp0 (_tmp62_, "container") != 0, &_tmp65_, &_tmp66_);
		_g_free0 (ctype);
		ctype = _tmp63_;
		_vala_array_length_idx = _tmp64_;
		no_array_length = _tmp65_;
		array_null_terminated = _tmp66_;
		type = _tmp67_;
		_tmp70_ = transfer;
		if (g_strcmp0 (_tmp70_, "full") == 0) {
			_tmp69_ = TRUE;
		} else {
			const gchar* _tmp71_;
			_tmp71_ = transfer;
			_tmp69_ = g_strcmp0 (_tmp71_, "container") == 0;
		}
		if (_tmp69_) {
			_tmp68_ = TRUE;
		} else {
			const gchar* _tmp72_;
			_tmp72_ = destroy;
			_tmp68_ = _tmp72_ != NULL;
		}
		if (_tmp68_) {
			ValaDataType* _tmp73_;
			_tmp73_ = type;
			vala_data_type_set_value_owned (_tmp73_, TRUE);
		}
		_tmp75_ = nullable;
		if (g_strcmp0 (_tmp75_, "1") == 0) {
			_tmp74_ = TRUE;
		} else {
			gboolean _tmp76_ = FALSE;
			const gchar* _tmp77_;
			_tmp77_ = allow_none;
			if (g_strcmp0 (_tmp77_, "1") == 0) {
				const gchar* _tmp78_;
				_tmp78_ = direction;
				_tmp76_ = g_strcmp0 (_tmp78_, "out") != 0;
			} else {
				_tmp76_ = FALSE;
			}
			_tmp74_ = _tmp76_;
		}
		if (_tmp74_) {
			ValaDataType* _tmp79_;
			_tmp79_ = type;
			vala_data_type_set_nullable (_tmp79_, TRUE);
		}
		_tmp81_ = direction;
		if (g_strcmp0 (_tmp81_, "out") == 0) {
			_tmp80_ = TRUE;
		} else {
			const gchar* _tmp82_;
			_tmp82_ = direction;
			_tmp80_ = g_strcmp0 (_tmp82_, "inout") == 0;
		}
		_tmp83_ = type;
		_tmp85_ = vala_gir_parser_element_get_type (self, _tmp83_, _tmp80_, &no_array_length, &array_null_terminated, &_tmp84_);
		changed = _tmp84_;
		_vala_code_node_unref0 (type);
		type = _tmp85_;
		_tmp86_ = changed;
		if (!_tmp86_) {
			_g_free0 (ctype);
			ctype = NULL;
		}
		_tmp87_ = name;
		_tmp88_ = type;
		_tmp89_ = begin;
		_tmp90_ = vala_gir_parser_get_src (self, &_tmp89_, NULL);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_parameter_new (_tmp87_, _tmp88_, _tmp91_);
		_vala_code_node_unref0 (param);
		param = _tmp92_;
		_vala_source_reference_unref0 (_tmp91_);
		_tmp93_ = ctype;
		if (_tmp93_ != NULL) {
			ValaParameter* _tmp94_;
			const gchar* _tmp95_;
			_tmp94_ = param;
			_tmp95_ = ctype;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp94_, "CCode", "type", _tmp95_, NULL);
		}
		_tmp96_ = direction;
		if (g_strcmp0 (_tmp96_, "out") == 0) {
			ValaParameter* _tmp97_;
			_tmp97_ = param;
			vala_parameter_set_direction (_tmp97_, VALA_PARAMETER_DIRECTION_OUT);
		} else {
			const gchar* _tmp98_;
			_tmp98_ = direction;
			if (g_strcmp0 (_tmp98_, "inout") == 0) {
				ValaParameter* _tmp99_;
				_tmp99_ = param;
				vala_parameter_set_direction (_tmp99_, VALA_PARAMETER_DIRECTION_REF);
			}
		}
		_tmp100_ = type;
		if (VALA_IS_ARRAY_TYPE (_tmp100_)) {
			ValaGirParserMetadata* _tmp101_;
			_tmp101_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp101_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX)) {
				ValaGirParserMetadata* _tmp102_;
				_tmp102_ = self->priv->metadata;
				_vala_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp102_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
			} else {
				gboolean _tmp103_ = FALSE;
				gboolean _tmp104_;
				gboolean _tmp108_;
				_tmp104_ = no_array_length;
				if (_tmp104_) {
					_tmp103_ = TRUE;
				} else {
					gboolean _tmp105_;
					_tmp105_ = array_null_terminated;
					_tmp103_ = _tmp105_;
				}
				if (_tmp103_) {
					ValaParameter* _tmp106_;
					gboolean _tmp107_;
					_tmp106_ = param;
					_tmp107_ = no_array_length;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp106_, "CCode", "array_length", !_tmp107_, NULL);
				}
				_tmp108_ = array_null_terminated;
				if (_tmp108_) {
					ValaParameter* _tmp109_;
					gboolean _tmp110_;
					_tmp109_ = param;
					_tmp110_ = array_null_terminated;
					vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp109_, "CCode", "array_null_terminated", _tmp110_, NULL);
				}
			}
		}
		_tmp111_ = param;
		_tmp112_ = self->priv->metadata;
		_tmp113_ = vala_gir_parser_metadata_get_expression (_tmp112_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEFAULT);
		_tmp114_ = _tmp113_;
		vala_variable_set_initializer ((ValaVariable*) _tmp111_, _tmp114_);
		_vala_code_node_unref0 (_tmp114_);
		_tmp115_ = param;
		_tmp116_ = vala_variable_get_initializer ((ValaVariable*) _tmp115_);
		_tmp117_ = _tmp116_;
		if (VALA_IS_TUPLE (_tmp117_)) {
			ValaParameter* _tmp118_;
			_tmp118_ = param;
			vala_variable_set_initializer ((ValaVariable*) _tmp118_, NULL);
		}
		_vala_code_node_unref0 (type);
		_g_free0 (ctype);
	}
	_tmp119_ = element_type;
	vala_gir_parser_end_element (self, _tmp119_);
	result = param;
	_g_free0 (destroy);
	_g_free0 (closure);
	_g_free0 (allow_none);
	_g_free0 (nullable);
	_g_free0 (transfer);
	_g_free0 (direction);
	_g_free0 (name);
	_g_free0 (element_type);
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (closure_idx) {
		*closure_idx = _vala_closure_idx;
	}
	if (destroy_idx) {
		*destroy_idx = _vala_destroy_idx;
	}
	if (scope) {
		*scope = _vala_scope;
	} else {
		_g_free0 (_vala_scope);
	}
	if (comment) {
		*comment = _vala_comment;
	} else {
		_vala_comment_unref0 (_vala_comment);
	}
	return result;
}


static ValaDataType*
vala_gir_parser_parse_type (ValaGirParser* self,
                            gchar* * ctype,
                            gint* array_length_idx,
                            gboolean transfer_elements,
                            gboolean* no_array_length,
                            gboolean* array_null_terminated)
{
	gchar* _vala_ctype = NULL;
	gint _vala_array_length_idx = 0;
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* result = NULL;
	gboolean is_array = FALSE;
	gchar* type_name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gint fixed_length = 0;
	ValaMarkupReader* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaGirParserMetadata* _tmp51_;
	const gchar* _tmp56_;
	ValaDataType* type = NULL;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	gboolean _tmp61_ = FALSE;
	gboolean _tmp62_ = FALSE;
	ValaDataType* _tmp63_;
	const gchar* _tmp90_ = NULL;
	gboolean _tmp91_;
	g_return_val_if_fail (self != NULL, NULL);
	is_array = FALSE;
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	type_name = _tmp1_;
	_g_free0 (_vala_ctype);
	_vala_ctype = NULL;
	fixed_length = -1;
	_vala_array_length_idx = -1;
	_vala_no_array_length = TRUE;
	_vala_array_null_terminated = TRUE;
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_name (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp4_, "array") == 0) {
		ValaSourceReference* src = NULL;
		ValaSourceReference* _tmp5_;
		const gchar* _tmp6_;
		is_array = TRUE;
		vala_gir_parser_start_element (self, "array");
		_tmp5_ = vala_gir_parser_get_current_src (self);
		src = _tmp5_;
		_tmp6_ = type_name;
		if (_tmp6_ == NULL) {
			ValaMarkupReader* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gboolean _tmp10_;
			ValaMarkupReader* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			gboolean _tmp17_;
			ValaMarkupReader* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gboolean _tmp24_;
			ValaMarkupReader* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gboolean _tmp28_;
			ValaDataType* element_type = NULL;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			ValaArrayType* array_type = NULL;
			ValaDataType* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaArrayType* _tmp36_;
			gint _tmp37_;
			_tmp7_ = self->priv->reader;
			_tmp8_ = vala_markup_reader_get_attribute (_tmp7_, "length");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_g_free0 (_tmp9_);
			if (_tmp10_) {
				ValaMarkupReader* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				_tmp11_ = self->priv->reader;
				_tmp12_ = vala_markup_reader_get_attribute (_tmp11_, "length");
				_tmp13_ = _tmp12_;
				_vala_array_length_idx = atoi (_tmp13_);
				_g_free0 (_tmp13_);
				_vala_no_array_length = FALSE;
				_vala_array_null_terminated = FALSE;
			}
			_tmp14_ = self->priv->reader;
			_tmp15_ = vala_markup_reader_get_attribute (_tmp14_, "fixed-size");
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_ != NULL;
			_g_free0 (_tmp16_);
			if (_tmp17_) {
				ValaMarkupReader* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp18_ = self->priv->reader;
				_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "fixed-size");
				_tmp20_ = _tmp19_;
				fixed_length = atoi (_tmp20_);
				_g_free0 (_tmp20_);
				_vala_array_null_terminated = FALSE;
			}
			_tmp21_ = self->priv->reader;
			_tmp22_ = vala_markup_reader_get_attribute (_tmp21_, "c:type");
			_tmp23_ = _tmp22_;
			_tmp24_ = g_strcmp0 (_tmp23_, "GStrv") == 0;
			_g_free0 (_tmp23_);
			if (_tmp24_) {
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
			}
			_tmp25_ = self->priv->reader;
			_tmp26_ = vala_markup_reader_get_attribute (_tmp25_, "zero-terminated");
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_ != NULL;
			_g_free0 (_tmp27_);
			if (_tmp28_) {
				ValaMarkupReader* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp29_ = self->priv->reader;
				_tmp30_ = vala_markup_reader_get_attribute (_tmp29_, "zero-terminated");
				_tmp31_ = _tmp30_;
				_vala_array_null_terminated = atoi (_tmp31_) != 0;
				_g_free0 (_tmp31_);
			}
			vala_gir_parser_next (self);
			_tmp32_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
			element_type = _tmp32_;
			_tmp33_ = element_type;
			vala_data_type_set_value_owned (_tmp33_, transfer_elements);
			vala_gir_parser_end_element (self, "array");
			_tmp34_ = element_type;
			_tmp35_ = src;
			_tmp36_ = vala_array_type_new (_tmp34_, 1, _tmp35_);
			array_type = _tmp36_;
			_tmp37_ = fixed_length;
			if (_tmp37_ > 0) {
				ValaArrayType* _tmp38_;
				ValaArrayType* _tmp39_;
				gint _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				ValaIntegerLiteral* _tmp43_;
				ValaIntegerLiteral* _tmp44_;
				_tmp38_ = array_type;
				vala_array_type_set_fixed_length (_tmp38_, TRUE);
				_tmp39_ = array_type;
				_tmp40_ = fixed_length;
				_tmp41_ = g_strdup_printf ("%i", _tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = vala_integer_literal_new (_tmp42_, NULL);
				_tmp44_ = _tmp43_;
				vala_array_type_set_length (_tmp39_, (ValaExpression*) _tmp44_);
				_vala_code_node_unref0 (_tmp44_);
				_g_free0 (_tmp42_);
			}
			result = (ValaDataType*) array_type;
			_vala_code_node_unref0 (element_type);
			_vala_source_reference_unref0 (src);
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		}
		_vala_source_reference_unref0 (src);
	} else {
		ValaMarkupReader* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		_tmp45_ = self->priv->reader;
		_tmp46_ = vala_markup_reader_get_name (_tmp45_);
		_tmp47_ = _tmp46_;
		if (g_strcmp0 (_tmp47_, "callback") == 0) {
			ValaGirParserNode* _tmp48_;
			ValaSymbol* _tmp49_;
			ValaDelegateType* _tmp50_;
			vala_gir_parser_parse_callback (self);
			_tmp48_ = self->priv->old_current;
			_tmp49_ = _tmp48_->symbol;
			_tmp50_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_DELEGATE, ValaDelegate));
			result = (ValaDataType*) _tmp50_;
			_g_free0 (type_name);
			if (ctype) {
				*ctype = _vala_ctype;
			} else {
				_g_free0 (_vala_ctype);
			}
			if (array_length_idx) {
				*array_length_idx = _vala_array_length_idx;
			}
			if (no_array_length) {
				*no_array_length = _vala_no_array_length;
			}
			if (array_null_terminated) {
				*array_null_terminated = _vala_array_null_terminated;
			}
			return result;
		} else {
			vala_gir_parser_start_element (self, "type");
		}
	}
	_tmp51_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp51_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp52_;
		gchar* _tmp53_;
		_tmp52_ = self->priv->metadata;
		_tmp53_ = vala_gir_parser_metadata_get_string (_tmp52_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp53_;
	} else {
		ValaMarkupReader* _tmp54_;
		gchar* _tmp55_;
		_tmp54_ = self->priv->reader;
		_tmp55_ = vala_markup_reader_get_attribute (_tmp54_, "c:type");
		_g_free0 (_vala_ctype);
		_vala_ctype = _tmp55_;
	}
	vala_gir_parser_next (self);
	_tmp56_ = type_name;
	if (_tmp56_ == NULL) {
		const gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp57_ = _vala_ctype;
		_tmp58_ = g_strdup (_tmp57_);
		_g_free0 (type_name);
		type_name = _tmp58_;
	}
	_tmp59_ = type_name;
	_tmp60_ = _vala_ctype;
	_tmp63_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp59_, &_tmp61_, &_tmp62_, _tmp60_);
	_vala_no_array_length = _tmp61_;
	_vala_array_null_terminated = _tmp62_;
	type = _tmp63_;
	while (TRUE) {
		ValaMarkupTokenType _tmp64_;
		const gchar* _tmp65_;
		ValaDataType* element_type = NULL;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaDataType* _tmp69_;
		ValaDataType* _tmp70_;
		_tmp64_ = self->priv->current_token;
		if (!(_tmp64_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		_tmp65_ = type_name;
		if (g_strcmp0 (_tmp65_, "GLib.ByteArray") == 0) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp66_ = vala_gir_parser_parse_type (self, NULL, NULL, TRUE, NULL, NULL);
		element_type = _tmp66_;
		_tmp67_ = element_type;
		vala_data_type_set_value_owned (_tmp67_, transfer_elements);
		_tmp68_ = type;
		_tmp69_ = element_type;
		vala_data_type_add_type_argument (_tmp68_, _tmp69_);
		_tmp70_ = element_type;
		if (VALA_IS_UNRESOLVED_TYPE (_tmp70_)) {
			ValaGirParserNode* _tmp71_ = NULL;
			ValaGirParserNode* _tmp72_;
			ValaGirParserNode* parent = NULL;
			ValaGirParserNode* _tmp74_;
			ValaHashMap* _tmp87_;
			ValaDataType* _tmp88_;
			ValaGirParserNode* _tmp89_;
			_tmp72_ = self->priv->current;
			_tmp71_ = _tmp72_;
			if (_tmp71_ == NULL) {
				ValaGirParserNode* _tmp73_;
				_tmp73_ = self->priv->root;
				_tmp71_ = _tmp73_;
			}
			_tmp74_ = _vala_gir_parser_node_ref0 (_tmp71_);
			parent = _tmp74_;
			while (TRUE) {
				gboolean _tmp75_ = FALSE;
				gboolean _tmp76_ = FALSE;
				ValaGirParserNode* _tmp77_;
				ValaGirParserNode* _tmp78_;
				ValaGirParserNode* _tmp84_;
				ValaGirParserNode* _tmp85_;
				ValaGirParserNode* _tmp86_;
				_tmp77_ = parent;
				_tmp78_ = self->priv->root;
				if (_tmp77_ != _tmp78_) {
					ValaGirParserNode* _tmp79_;
					ValaGirParserNode* _tmp80_;
					_tmp79_ = parent;
					_tmp80_ = _tmp79_->parent;
					_tmp76_ = _tmp80_ != NULL;
				} else {
					_tmp76_ = FALSE;
				}
				if (_tmp76_) {
					ValaGirParserNode* _tmp81_;
					ValaGirParserNode* _tmp82_;
					ValaGirParserNode* _tmp83_;
					_tmp81_ = parent;
					_tmp82_ = _tmp81_->parent;
					_tmp83_ = self->priv->root;
					_tmp75_ = _tmp82_ != _tmp83_;
				} else {
					_tmp75_ = FALSE;
				}
				if (!_tmp75_) {
					break;
				}
				_tmp84_ = parent;
				_tmp85_ = _tmp84_->parent;
				_tmp86_ = _vala_gir_parser_node_ref0 (_tmp85_);
				_vala_gir_parser_node_unref0 (parent);
				parent = _tmp86_;
			}
			_tmp87_ = self->priv->unresolved_type_arguments;
			_tmp88_ = element_type;
			_tmp89_ = parent;
			vala_map_set ((ValaMap*) _tmp87_, G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType), _tmp89_);
			_vala_gir_parser_node_unref0 (parent);
		}
		_vala_code_node_unref0 (element_type);
	}
	_tmp91_ = is_array;
	if (_tmp91_) {
		_tmp90_ = "array";
	} else {
		_tmp90_ = "type";
	}
	vala_gir_parser_end_element (self, _tmp90_);
	result = type;
	_g_free0 (type_name);
	if (ctype) {
		*ctype = _vala_ctype;
	} else {
		_g_free0 (_vala_ctype);
	}
	if (array_length_idx) {
		*array_length_idx = _vala_array_length_idx;
	}
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}


static ValaDataType*
vala_gir_parser_parse_type_from_gir_name (ValaGirParser* self,
                                          const gchar* type_name,
                                          gboolean* no_array_length,
                                          gboolean* array_null_terminated,
                                          const gchar* ctype)
{
	gboolean _vala_no_array_length = FALSE;
	gboolean _vala_array_null_terminated = FALSE;
	ValaDataType* result = NULL;
	ValaDataType* type = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (type_name != NULL, NULL);
	_vala_no_array_length = FALSE;
	_vala_array_null_terminated = FALSE;
	type = NULL;
	if (g_strcmp0 (type_name, "none") == 0) {
		ValaSourceReference* _tmp0_;
		ValaSourceReference* _tmp1_;
		ValaVoidType* _tmp2_;
		_tmp0_ = vala_gir_parser_get_current_src (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_void_type_new (_tmp1_);
		_vala_code_node_unref0 (type);
		type = (ValaDataType*) _tmp2_;
		_vala_source_reference_unref0 (_tmp1_);
	} else {
		if (g_strcmp0 (type_name, "gpointer") == 0) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			ValaVoidType* _tmp5_;
			ValaVoidType* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaPointerType* _tmp9_;
			_tmp3_ = vala_gir_parser_get_current_src (self);
			_tmp4_ = _tmp3_;
			_tmp5_ = vala_void_type_new (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_gir_parser_get_current_src (self);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_pointer_type_new ((ValaDataType*) _tmp6_, _tmp8_);
			_vala_code_node_unref0 (type);
			type = (ValaDataType*) _tmp9_;
			_vala_source_reference_unref0 (_tmp8_);
			_vala_code_node_unref0 (_tmp6_);
			_vala_source_reference_unref0 (_tmp4_);
		} else {
			if (g_strcmp0 (type_name, "GObject.Strv") == 0) {
				ValaUnresolvedType* element_type = NULL;
				ValaUnresolvedSymbol* _tmp10_;
				ValaUnresolvedSymbol* _tmp11_;
				ValaUnresolvedType* _tmp12_;
				ValaUnresolvedType* _tmp13_;
				ValaUnresolvedType* _tmp14_;
				ValaUnresolvedType* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				ValaArrayType* _tmp18_;
				_tmp10_ = vala_unresolved_symbol_new (NULL, "string", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = vala_unresolved_type_new_from_symbol (_tmp11_, NULL);
				_tmp13_ = _tmp12_;
				_vala_code_node_unref0 (_tmp11_);
				element_type = _tmp13_;
				_tmp14_ = element_type;
				vala_data_type_set_value_owned ((ValaDataType*) _tmp14_, TRUE);
				_tmp15_ = element_type;
				_tmp16_ = vala_gir_parser_get_current_src (self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_array_type_new ((ValaDataType*) _tmp15_, 1, _tmp17_);
				_vala_code_node_unref0 (type);
				type = (ValaDataType*) _tmp18_;
				_vala_source_reference_unref0 (_tmp17_);
				_vala_no_array_length = TRUE;
				_vala_array_null_terminated = TRUE;
				_vala_code_node_unref0 (element_type);
			} else {
				gboolean known_type = FALSE;
				ValaDataType* _tmp31_;
				known_type = TRUE;
				if (g_strcmp0 (type_name, "utf8") == 0) {
					type_name = "string";
				} else {
					if (g_strcmp0 (type_name, "gboolean") == 0) {
						ValaCodeContext* _tmp19_;
						ValaNamespace* _tmp20_;
						ValaNamespace* _tmp21_;
						ValaScope* _tmp22_;
						ValaScope* _tmp23_;
						ValaSymbol* _tmp24_;
						ValaStruct* _tmp25_;
						ValaBooleanType* _tmp26_;
						_tmp19_ = self->priv->context;
						_tmp20_ = vala_code_context_get_root (_tmp19_);
						_tmp21_ = _tmp20_;
						_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
						_tmp23_ = _tmp22_;
						_tmp24_ = vala_scope_lookup (_tmp23_, "bool");
						_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALA_TYPE_STRUCT, ValaStruct);
						_tmp26_ = vala_boolean_type_new (_tmp25_);
						_vala_code_node_unref0 (type);
						type = (ValaDataType*) _tmp26_;
						_vala_code_node_unref0 (_tmp25_);
					} else {
						if (g_strcmp0 (type_name, "gchar") == 0) {
							type_name = "char";
						} else {
							if (g_strcmp0 (type_name, "gshort") == 0) {
								type_name = "short";
							} else {
								if (g_strcmp0 (type_name, "gushort") == 0) {
									type_name = "ushort";
								} else {
									if (g_strcmp0 (type_name, "gint") == 0) {
										type_name = "int";
									} else {
										if (g_strcmp0 (type_name, "guint") == 0) {
											type_name = "uint";
										} else {
											if (g_strcmp0 (type_name, "glong") == 0) {
												gboolean _tmp27_ = FALSE;
												if (ctype != NULL) {
													_tmp27_ = g_str_has_prefix (ctype, "gssize");
												} else {
													_tmp27_ = FALSE;
												}
												if (_tmp27_) {
													type_name = "ssize_t";
												} else {
													gboolean _tmp28_ = FALSE;
													if (ctype != NULL) {
														_tmp28_ = g_str_has_prefix (ctype, "gintptr");
													} else {
														_tmp28_ = FALSE;
													}
													if (_tmp28_) {
														type_name = "intptr";
													} else {
														type_name = "long";
													}
												}
											} else {
												if (g_strcmp0 (type_name, "gulong") == 0) {
													gboolean _tmp29_ = FALSE;
													if (ctype != NULL) {
														_tmp29_ = g_str_has_prefix (ctype, "gsize");
													} else {
														_tmp29_ = FALSE;
													}
													if (_tmp29_) {
														type_name = "size_t";
													} else {
														gboolean _tmp30_ = FALSE;
														if (ctype != NULL) {
															_tmp30_ = g_str_has_prefix (ctype, "guintptr");
														} else {
															_tmp30_ = FALSE;
														}
														if (_tmp30_) {
															type_name = "uintptr";
														} else {
															type_name = "ulong";
														}
													}
												} else {
													if (g_strcmp0 (type_name, "gint8") == 0) {
														type_name = "int8";
													} else {
														if (g_strcmp0 (type_name, "guint8") == 0) {
															type_name = "uint8";
														} else {
															if (g_strcmp0 (type_name, "gint16") == 0) {
																type_name = "int16";
															} else {
																if (g_strcmp0 (type_name, "guint16") == 0) {
																	type_name = "uint16";
																} else {
																	if (g_strcmp0 (type_name, "gint32") == 0) {
																		type_name = "int32";
																	} else {
																		if (g_strcmp0 (type_name, "guint32") == 0) {
																			type_name = "uint32";
																		} else {
																			if (g_strcmp0 (type_name, "gint64") == 0) {
																				type_name = "int64";
																			} else {
																				if (g_strcmp0 (type_name, "guint64") == 0) {
																					type_name = "uint64";
																				} else {
																					if (g_strcmp0 (type_name, "gfloat") == 0) {
																						type_name = "float";
																					} else {
																						if (g_strcmp0 (type_name, "gdouble") == 0) {
																							type_name = "double";
																						} else {
																							if (g_strcmp0 (type_name, "filename") == 0) {
																								type_name = "string";
																							} else {
																								if (g_strcmp0 (type_name, "GLib.offset") == 0) {
																									type_name = "int64";
																								} else {
																									if (g_strcmp0 (type_name, "gsize") == 0) {
																										type_name = "size_t";
																									} else {
																										if (g_strcmp0 (type_name, "gssize") == 0) {
																											type_name = "ssize_t";
																										} else {
																											if (g_strcmp0 (type_name, "guintptr") == 0) {
																												type_name = "uintptr";
																											} else {
																												if (g_strcmp0 (type_name, "gintptr") == 0) {
																													type_name = "intptr";
																												} else {
																													if (g_strcmp0 (type_name, "GType") == 0) {
																														type_name = "GLib.Type";
																													} else {
																														if (g_strcmp0 (type_name, "GObject.Class") == 0) {
																															type_name = "GLib.ObjectClass";
																														} else {
																															if (g_strcmp0 (type_name, "gunichar") == 0) {
																																type_name = "unichar";
																															} else {
																																if (g_strcmp0 (type_name, "Atk.ImplementorIface") == 0) {
																																	type_name = "Atk.Implementor";
																																} else {
																																	known_type = FALSE;
																																}
																															}
																														}
																													}
																												}
																											}
																										}
																									}
																								}
																							}
																						}
																					}
																				}
																			}
																		}
																	}
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
				}
				_tmp31_ = type;
				if (_tmp31_ == NULL) {
					ValaUnresolvedSymbol* sym = NULL;
					ValaSourceReference* _tmp32_;
					ValaSourceReference* _tmp33_;
					ValaUnresolvedSymbol* _tmp34_;
					ValaUnresolvedSymbol* _tmp35_;
					ValaUnresolvedSymbol* _tmp36_;
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaUnresolvedType* _tmp39_;
					gboolean _tmp40_;
					_tmp32_ = vala_gir_parser_get_current_src (self);
					_tmp33_ = _tmp32_;
					_tmp34_ = vala_gir_parser_parse_symbol_from_string (self, type_name, _tmp33_);
					_tmp35_ = _tmp34_;
					_vala_source_reference_unref0 (_tmp33_);
					sym = _tmp35_;
					_tmp36_ = sym;
					_tmp37_ = vala_gir_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = vala_unresolved_type_new_from_symbol (_tmp36_, _tmp38_);
					_vala_code_node_unref0 (type);
					type = (ValaDataType*) _tmp39_;
					_vala_source_reference_unref0 (_tmp38_);
					_tmp40_ = known_type;
					if (!_tmp40_) {
						ValaArrayList* _tmp41_;
						ValaUnresolvedSymbol* _tmp42_;
						_tmp41_ = self->priv->unresolved_gir_symbols;
						_tmp42_ = sym;
						vala_collection_add ((ValaCollection*) _tmp41_, _tmp42_);
					}
					_vala_code_node_unref0 (sym);
				}
			}
		}
	}
	result = type;
	if (no_array_length) {
		*no_array_length = _vala_no_array_length;
	}
	if (array_null_terminated) {
		*array_null_terminated = _vala_array_null_terminated;
	}
	return result;
}


static void
vala_gir_parser_parse_record (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaStruct* st = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp2_;
	gboolean _tmp3_;
	ValaStruct* _tmp15_;
	ValaStruct* _tmp16_;
	ValaStruct* _tmp17_;
	ValaStruct* _tmp18_;
	gchar* gtype_struct_for = NULL;
	ValaMarkupReader* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	gboolean first_field = FALSE;
	ValaStruct* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	gboolean _tmp72_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "record");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	require_copy_free = FALSE;
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->new_symbol;
	if (_tmp3_) {
		gchar* _tmp4_;
		gchar* _tmp5_;
		ValaGirParserNode* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaStruct* _tmp8_;
		ValaGirParserNode* _tmp9_;
		ValaStruct* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp4_ = vala_gir_parser_element_get_name (self, NULL);
		_tmp5_ = _tmp4_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->source_reference;
		_tmp8_ = vala_struct_new (_tmp5_, _tmp7_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp8_;
		_g_free0 (_tmp5_);
		_tmp9_ = self->priv->current;
		_tmp10_ = st;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (_tmp9_->symbol);
		_tmp9_->symbol = _tmp11_;
	} else {
		ValaGirParserNode* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaStruct* _tmp14_;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->symbol;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp14_;
	}
	_tmp15_ = st;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = st;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp16_, "CCode", "type_id");
	_tmp17_ = st;
	vala_symbol_set_external ((ValaSymbol*) _tmp17_, TRUE);
	_tmp18_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = self->priv->reader;
	_tmp20_ = vala_markup_reader_get_attribute (_tmp19_, "glib:is-gtype-struct-for");
	gtype_struct_for = _tmp20_;
	_tmp21_ = gtype_struct_for;
	if (_tmp21_ != NULL) {
		ValaGirParserNode* _tmp22_;
		const gchar* _tmp23_;
		ValaGirParserNode* _tmp24_;
		ValaSourceReference* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaArrayList* _tmp27_;
		ValaGirParserNode* _tmp28_;
		ValaUnresolvedSymbol* _tmp29_;
		_tmp22_ = self->priv->current;
		_tmp23_ = gtype_struct_for;
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_->source_reference;
		_tmp26_ = vala_gir_parser_parse_symbol_from_string (self, _tmp23_, _tmp25_);
		_vala_code_node_unref0 (_tmp22_->gtype_struct_for);
		_tmp22_->gtype_struct_for = _tmp26_;
		_tmp27_ = self->priv->unresolved_gir_symbols;
		_tmp28_ = self->priv->current;
		_tmp29_ = _tmp28_->gtype_struct_for;
		vala_collection_add ((ValaCollection*) _tmp27_, _tmp29_);
	}
	first_field = TRUE;
	vala_gir_parser_next (self);
	_tmp30_ = st;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp34_ = FALSE;
			gboolean _tmp35_;
			_tmp35_ = first_field;
			if (_tmp35_) {
				ValaMarkupReader* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = self->priv->reader;
				_tmp37_ = vala_markup_reader_get_name (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp34_ = g_strcmp0 (_tmp38_, "field") == 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp39_ = self->priv->reader;
		_tmp40_ = vala_markup_reader_get_name (_tmp39_);
		_tmp41_ = _tmp40_;
		if (g_strcmp0 (_tmp41_, "field") == 0) {
			gboolean _tmp42_ = FALSE;
			ValaMarkupReader* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			gboolean _tmp46_;
			_tmp43_ = self->priv->reader;
			_tmp44_ = vala_markup_reader_get_attribute (_tmp43_, "name");
			_tmp45_ = _tmp44_;
			_tmp46_ = g_strcmp0 (_tmp45_, "priv") != 0;
			_g_free0 (_tmp45_);
			if (_tmp46_) {
				gboolean _tmp47_ = FALSE;
				gboolean _tmp48_;
				_tmp48_ = first_field;
				if (_tmp48_) {
					const gchar* _tmp49_;
					_tmp49_ = gtype_struct_for;
					_tmp47_ = _tmp49_ != NULL;
				} else {
					_tmp47_ = FALSE;
				}
				_tmp42_ = !_tmp47_;
			} else {
				_tmp42_ = FALSE;
			}
			if (_tmp42_) {
				vala_gir_parser_parse_field (self);
			} else {
				vala_gir_parser_skip_element (self);
			}
			first_field = FALSE;
		} else {
			ValaMarkupReader* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			_tmp50_ = self->priv->reader;
			_tmp51_ = vala_markup_reader_get_name (_tmp50_);
			_tmp52_ = _tmp51_;
			if (g_strcmp0 (_tmp52_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp53_;
				const gchar* _tmp54_;
				const gchar* _tmp55_;
				_tmp53_ = self->priv->reader;
				_tmp54_ = vala_markup_reader_get_name (_tmp53_);
				_tmp55_ = _tmp54_;
				if (g_strcmp0 (_tmp55_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp56_;
					const gchar* _tmp57_;
					const gchar* _tmp58_;
					_tmp56_ = self->priv->reader;
					_tmp57_ = vala_markup_reader_get_name (_tmp56_);
					_tmp58_ = _tmp57_;
					if (g_strcmp0 (_tmp58_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp59_;
						const gchar* _tmp60_;
						const gchar* _tmp61_;
						_tmp59_ = self->priv->reader;
						_tmp60_ = vala_markup_reader_get_name (_tmp59_);
						_tmp61_ = _tmp60_;
						if (g_strcmp0 (_tmp61_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp62_;
							const gchar* _tmp63_;
							const gchar* _tmp64_;
							_tmp62_ = self->priv->reader;
							_tmp63_ = vala_markup_reader_get_name (_tmp62_);
							_tmp64_ = _tmp63_;
							if (g_strcmp0 (_tmp64_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp65_;
								ValaSourceReference* _tmp66_;
								ValaMarkupReader* _tmp67_;
								const gchar* _tmp68_;
								const gchar* _tmp69_;
								gchar* _tmp70_;
								gchar* _tmp71_;
								_tmp65_ = vala_gir_parser_get_current_src (self);
								_tmp66_ = _tmp65_;
								_tmp67_ = self->priv->reader;
								_tmp68_ = vala_markup_reader_get_name (_tmp67_);
								_tmp69_ = _tmp68_;
								_tmp70_ = g_strdup_printf ("unknown child element `%s' in `record'", _tmp69_);
								_tmp71_ = _tmp70_;
								vala_report_error (_tmp66_, _tmp71_);
								_g_free0 (_tmp71_);
								_vala_source_reference_unref0 (_tmp66_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp72_ = require_copy_free;
	if (_tmp72_) {
		ValaStruct* _tmp73_;
		ValaStruct* _tmp74_;
		_tmp73_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp73_, "CCode", "copy_function", "g_boxed_copy", NULL);
		_tmp74_ = st;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp74_, "CCode", "free_function", "g_boxed_free", NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "record");
	_g_free0 (gtype_struct_for);
	_vala_code_node_unref0 (st);
}


static void
vala_gir_parser_parse_class (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaClass* cl = NULL;
	gchar* parent = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	ValaGirParserNode* _tmp4_;
	gboolean _tmp5_;
	ValaClass* _tmp27_;
	ValaClass* _tmp28_;
	ValaClass* _tmp29_;
	ValaClass* _tmp30_;
	ValaGirComment* _tmp31_;
	ValaGirComment* _tmp32_;
	gboolean first_field = FALSE;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "class");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "parent");
	parent = _tmp3_;
	_tmp4_ = self->priv->current;
	_tmp5_ = _tmp4_->new_symbol;
	if (_tmp5_) {
		ValaGirParserNode* _tmp6_;
		const gchar* _tmp7_;
		ValaGirParserNode* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaClass* _tmp10_;
		ValaClass* _tmp11_;
		ValaGirParserMetadata* _tmp12_;
		ValaMarkupReader* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		ValaGirParserNode* _tmp21_;
		ValaClass* _tmp22_;
		ValaSymbol* _tmp23_;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->name;
		_tmp8_ = self->priv->current;
		_tmp9_ = _tmp8_->source_reference;
		_tmp10_ = vala_class_new (_tmp7_, _tmp9_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp10_;
		_tmp11_ = cl;
		_tmp12_ = self->priv->metadata;
		_tmp13_ = self->priv->reader;
		_tmp14_ = vala_markup_reader_get_attribute (_tmp13_, "abstract");
		_tmp15_ = _tmp14_;
		vala_class_set_is_abstract (_tmp11_, vala_gir_parser_metadata_get_bool (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, g_strcmp0 (_tmp15_, "1") == 0));
		_g_free0 (_tmp15_);
		_tmp16_ = parent;
		if (_tmp16_ != NULL) {
			ValaClass* _tmp17_;
			const gchar* _tmp18_;
			ValaDataType* _tmp19_;
			ValaDataType* _tmp20_;
			_tmp17_ = cl;
			_tmp18_ = parent;
			_tmp19_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp18_, NULL, NULL, NULL);
			_tmp20_ = _tmp19_;
			vala_class_add_base_type (_tmp17_, _tmp20_);
			_vala_code_node_unref0 (_tmp20_);
		}
		_tmp21_ = self->priv->current;
		_tmp22_ = cl;
		_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
		_vala_code_node_unref0 (_tmp21_->symbol);
		_tmp21_->symbol = _tmp23_;
	} else {
		ValaGirParserNode* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaClass* _tmp26_;
		_tmp24_ = self->priv->current;
		_tmp25_ = _tmp24_->symbol;
		_tmp26_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp26_;
	}
	_tmp27_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp27_);
	_tmp28_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp28_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp29_ = cl;
	vala_symbol_set_external ((ValaSymbol*) _tmp29_, TRUE);
	vala_gir_parser_next (self);
	_tmp30_ = cl;
	_tmp31_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp32_ = _tmp31_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp30_, (ValaComment*) _tmp32_);
	_vala_comment_unref0 (_tmp32_);
	first_field = TRUE;
	while (TRUE) {
		ValaMarkupTokenType _tmp33_;
		ValaMarkupReader* _tmp39_;
		const gchar* _tmp40_;
		const gchar* _tmp41_;
		_tmp33_ = self->priv->current_token;
		if (!(_tmp33_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			gboolean _tmp34_ = FALSE;
			gboolean _tmp35_;
			_tmp35_ = first_field;
			if (_tmp35_) {
				ValaMarkupReader* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				_tmp36_ = self->priv->reader;
				_tmp37_ = vala_markup_reader_get_name (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp34_ = g_strcmp0 (_tmp38_, "field") == 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				first_field = FALSE;
			}
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp39_ = self->priv->reader;
		_tmp40_ = vala_markup_reader_get_name (_tmp39_);
		_tmp41_ = _tmp40_;
		if (g_strcmp0 (_tmp41_, "implements") == 0) {
			ValaClass* _tmp42_;
			ValaMarkupReader* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaDataType* _tmp46_;
			ValaDataType* _tmp47_;
			vala_gir_parser_start_element (self, "implements");
			_tmp42_ = cl;
			_tmp43_ = self->priv->reader;
			_tmp44_ = vala_markup_reader_get_attribute (_tmp43_, "name");
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp45_, NULL, NULL, NULL);
			_tmp47_ = _tmp46_;
			vala_class_add_base_type (_tmp42_, _tmp47_);
			_vala_code_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "implements");
		} else {
			ValaMarkupReader* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			_tmp48_ = self->priv->reader;
			_tmp49_ = vala_markup_reader_get_name (_tmp48_);
			_tmp50_ = _tmp49_;
			if (g_strcmp0 (_tmp50_, "constant") == 0) {
				vala_gir_parser_parse_constant (self);
			} else {
				ValaMarkupReader* _tmp51_;
				const gchar* _tmp52_;
				const gchar* _tmp53_;
				_tmp51_ = self->priv->reader;
				_tmp52_ = vala_markup_reader_get_name (_tmp51_);
				_tmp53_ = _tmp52_;
				if (g_strcmp0 (_tmp53_, "field") == 0) {
					gboolean _tmp54_ = FALSE;
					gboolean _tmp55_;
					_tmp55_ = first_field;
					if (_tmp55_) {
						const gchar* _tmp56_;
						_tmp56_ = parent;
						_tmp54_ = _tmp56_ != NULL;
					} else {
						_tmp54_ = FALSE;
					}
					if (_tmp54_) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp57_;
						gchar* _tmp58_;
						gchar* _tmp59_;
						gboolean _tmp60_;
						_tmp57_ = self->priv->reader;
						_tmp58_ = vala_markup_reader_get_attribute (_tmp57_, "name");
						_tmp59_ = _tmp58_;
						_tmp60_ = g_strcmp0 (_tmp59_, "priv") != 0;
						_g_free0 (_tmp59_);
						if (_tmp60_) {
							vala_gir_parser_parse_field (self);
						} else {
							vala_gir_parser_skip_element (self);
						}
					}
					first_field = FALSE;
				} else {
					ValaMarkupReader* _tmp61_;
					const gchar* _tmp62_;
					const gchar* _tmp63_;
					_tmp61_ = self->priv->reader;
					_tmp62_ = vala_markup_reader_get_name (_tmp61_);
					_tmp63_ = _tmp62_;
					if (g_strcmp0 (_tmp63_, "property") == 0) {
						ValaProperty* _tmp64_;
						ValaProperty* _tmp65_;
						_tmp64_ = vala_gir_parser_parse_property (self);
						_tmp65_ = _tmp64_;
						_vala_code_node_unref0 (_tmp65_);
					} else {
						ValaMarkupReader* _tmp66_;
						const gchar* _tmp67_;
						const gchar* _tmp68_;
						_tmp66_ = self->priv->reader;
						_tmp67_ = vala_markup_reader_get_name (_tmp66_);
						_tmp68_ = _tmp67_;
						if (g_strcmp0 (_tmp68_, "constructor") == 0) {
							vala_gir_parser_parse_constructor (self);
						} else {
							ValaMarkupReader* _tmp69_;
							const gchar* _tmp70_;
							const gchar* _tmp71_;
							_tmp69_ = self->priv->reader;
							_tmp70_ = vala_markup_reader_get_name (_tmp69_);
							_tmp71_ = _tmp70_;
							if (g_strcmp0 (_tmp71_, "function") == 0) {
								vala_gir_parser_parse_method (self, "function");
							} else {
								ValaMarkupReader* _tmp72_;
								const gchar* _tmp73_;
								const gchar* _tmp74_;
								_tmp72_ = self->priv->reader;
								_tmp73_ = vala_markup_reader_get_name (_tmp72_);
								_tmp74_ = _tmp73_;
								if (g_strcmp0 (_tmp74_, "function-macro") == 0) {
									vala_gir_parser_skip_element (self);
								} else {
									ValaMarkupReader* _tmp75_;
									const gchar* _tmp76_;
									const gchar* _tmp77_;
									_tmp75_ = self->priv->reader;
									_tmp76_ = vala_markup_reader_get_name (_tmp75_);
									_tmp77_ = _tmp76_;
									if (g_strcmp0 (_tmp77_, "method") == 0) {
										vala_gir_parser_parse_method (self, "method");
									} else {
										ValaMarkupReader* _tmp78_;
										const gchar* _tmp79_;
										const gchar* _tmp80_;
										_tmp78_ = self->priv->reader;
										_tmp79_ = vala_markup_reader_get_name (_tmp78_);
										_tmp80_ = _tmp79_;
										if (g_strcmp0 (_tmp80_, "virtual-method") == 0) {
											vala_gir_parser_parse_method (self, "virtual-method");
										} else {
											ValaMarkupReader* _tmp81_;
											const gchar* _tmp82_;
											const gchar* _tmp83_;
											_tmp81_ = self->priv->reader;
											_tmp82_ = vala_markup_reader_get_name (_tmp81_);
											_tmp83_ = _tmp82_;
											if (g_strcmp0 (_tmp83_, "union") == 0) {
												vala_gir_parser_parse_union (self);
											} else {
												ValaMarkupReader* _tmp84_;
												const gchar* _tmp85_;
												const gchar* _tmp86_;
												_tmp84_ = self->priv->reader;
												_tmp85_ = vala_markup_reader_get_name (_tmp84_);
												_tmp86_ = _tmp85_;
												if (g_strcmp0 (_tmp86_, "glib:signal") == 0) {
													vala_gir_parser_parse_signal (self);
												} else {
													ValaSourceReference* _tmp87_;
													ValaSourceReference* _tmp88_;
													ValaMarkupReader* _tmp89_;
													const gchar* _tmp90_;
													const gchar* _tmp91_;
													gchar* _tmp92_;
													gchar* _tmp93_;
													_tmp87_ = vala_gir_parser_get_current_src (self);
													_tmp88_ = _tmp87_;
													_tmp89_ = self->priv->reader;
													_tmp90_ = vala_markup_reader_get_name (_tmp89_);
													_tmp91_ = _tmp90_;
													_tmp92_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp91_);
													_tmp93_ = _tmp92_;
													vala_report_error (_tmp88_, _tmp93_);
													_g_free0 (_tmp93_);
													_vala_source_reference_unref0 (_tmp88_);
													vala_gir_parser_skip_element (self);
												}
											}
										}
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "class");
	_g_free0 (parent);
	_vala_code_node_unref0 (cl);
}


static void
vala_gir_parser_parse_interface (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaInterface* iface = NULL;
	ValaGirParserNode* _tmp2_;
	gboolean _tmp3_;
	ValaInterface* _tmp15_;
	ValaInterface* _tmp16_;
	ValaInterface* _tmp17_;
	ValaInterface* _tmp18_;
	ValaGirComment* _tmp19_;
	ValaGirComment* _tmp20_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "interface");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, TRUE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->current;
	_tmp3_ = _tmp2_->new_symbol;
	if (_tmp3_) {
		ValaGirParserNode* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserNode* _tmp6_;
		ValaSourceReference* _tmp7_;
		ValaInterface* _tmp8_;
		ValaGirParserNode* _tmp9_;
		ValaInterface* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp4_ = self->priv->current;
		_tmp5_ = _tmp4_->name;
		_tmp6_ = self->priv->current;
		_tmp7_ = _tmp6_->source_reference;
		_tmp8_ = vala_interface_new (_tmp5_, _tmp7_, NULL);
		_vala_code_node_unref0 (iface);
		iface = _tmp8_;
		_tmp9_ = self->priv->current;
		_tmp10_ = iface;
		_tmp11_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp10_);
		_vala_code_node_unref0 (_tmp9_->symbol);
		_tmp9_->symbol = _tmp11_;
	} else {
		ValaGirParserNode* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaInterface* _tmp14_;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->symbol;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_INTERFACE, ValaInterface));
		_vala_code_node_unref0 (iface);
		iface = _tmp14_;
	}
	_tmp15_ = iface;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp15_);
	_tmp16_ = iface;
	vala_symbol_set_access ((ValaSymbol*) _tmp16_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp17_ = iface;
	vala_symbol_set_external ((ValaSymbol*) _tmp17_, TRUE);
	vala_gir_parser_next (self);
	_tmp18_ = iface;
	_tmp19_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp20_ = _tmp19_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp18_, (ValaComment*) _tmp20_);
	_vala_comment_unref0 (_tmp20_);
	while (TRUE) {
		ValaMarkupTokenType _tmp21_;
		ValaMarkupReader* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp21_ = self->priv->current_token;
		if (!(_tmp21_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp22_ = self->priv->reader;
		_tmp23_ = vala_markup_reader_get_name (_tmp22_);
		_tmp24_ = _tmp23_;
		if (g_strcmp0 (_tmp24_, "prerequisite") == 0) {
			ValaInterface* _tmp25_;
			ValaMarkupReader* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			ValaDataType* _tmp29_;
			ValaDataType* _tmp30_;
			vala_gir_parser_start_element (self, "prerequisite");
			_tmp25_ = iface;
			_tmp26_ = self->priv->reader;
			_tmp27_ = vala_markup_reader_get_attribute (_tmp26_, "name");
			_tmp28_ = _tmp27_;
			_tmp29_ = vala_gir_parser_parse_type_from_gir_name (self, _tmp28_, NULL, NULL, NULL);
			_tmp30_ = _tmp29_;
			vala_interface_add_prerequisite (_tmp25_, _tmp30_);
			_vala_code_node_unref0 (_tmp30_);
			_g_free0 (_tmp28_);
			vala_gir_parser_next (self);
			vala_gir_parser_end_element (self, "prerequisite");
		} else {
			ValaMarkupReader* _tmp31_;
			const gchar* _tmp32_;
			const gchar* _tmp33_;
			_tmp31_ = self->priv->reader;
			_tmp32_ = vala_markup_reader_get_name (_tmp31_);
			_tmp33_ = _tmp32_;
			if (g_strcmp0 (_tmp33_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaMarkupReader* _tmp34_;
				const gchar* _tmp35_;
				const gchar* _tmp36_;
				_tmp34_ = self->priv->reader;
				_tmp35_ = vala_markup_reader_get_name (_tmp34_);
				_tmp36_ = _tmp35_;
				if (g_strcmp0 (_tmp36_, "property") == 0) {
					ValaProperty* _tmp37_;
					ValaProperty* _tmp38_;
					_tmp37_ = vala_gir_parser_parse_property (self);
					_tmp38_ = _tmp37_;
					_vala_code_node_unref0 (_tmp38_);
				} else {
					ValaMarkupReader* _tmp39_;
					const gchar* _tmp40_;
					const gchar* _tmp41_;
					_tmp39_ = self->priv->reader;
					_tmp40_ = vala_markup_reader_get_name (_tmp39_);
					_tmp41_ = _tmp40_;
					if (g_strcmp0 (_tmp41_, "virtual-method") == 0) {
						vala_gir_parser_parse_method (self, "virtual-method");
					} else {
						ValaMarkupReader* _tmp42_;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						_tmp42_ = self->priv->reader;
						_tmp43_ = vala_markup_reader_get_name (_tmp42_);
						_tmp44_ = _tmp43_;
						if (g_strcmp0 (_tmp44_, "function") == 0) {
							vala_gir_parser_parse_method (self, "function");
						} else {
							ValaMarkupReader* _tmp45_;
							const gchar* _tmp46_;
							const gchar* _tmp47_;
							_tmp45_ = self->priv->reader;
							_tmp46_ = vala_markup_reader_get_name (_tmp45_);
							_tmp47_ = _tmp46_;
							if (g_strcmp0 (_tmp47_, "function-macro") == 0) {
								vala_gir_parser_skip_element (self);
							} else {
								ValaMarkupReader* _tmp48_;
								const gchar* _tmp49_;
								const gchar* _tmp50_;
								_tmp48_ = self->priv->reader;
								_tmp49_ = vala_markup_reader_get_name (_tmp48_);
								_tmp50_ = _tmp49_;
								if (g_strcmp0 (_tmp50_, "method") == 0) {
									vala_gir_parser_parse_method (self, "method");
								} else {
									ValaMarkupReader* _tmp51_;
									const gchar* _tmp52_;
									const gchar* _tmp53_;
									_tmp51_ = self->priv->reader;
									_tmp52_ = vala_markup_reader_get_name (_tmp51_);
									_tmp53_ = _tmp52_;
									if (g_strcmp0 (_tmp53_, "glib:signal") == 0) {
										vala_gir_parser_parse_signal (self);
									} else {
										ValaSourceReference* _tmp54_;
										ValaSourceReference* _tmp55_;
										ValaMarkupReader* _tmp56_;
										const gchar* _tmp57_;
										const gchar* _tmp58_;
										gchar* _tmp59_;
										gchar* _tmp60_;
										_tmp54_ = vala_gir_parser_get_current_src (self);
										_tmp55_ = _tmp54_;
										_tmp56_ = self->priv->reader;
										_tmp57_ = vala_markup_reader_get_name (_tmp56_);
										_tmp58_ = _tmp57_;
										_tmp59_ = g_strdup_printf ("unknown child element `%s' in `interface'", _tmp58_);
										_tmp60_ = _tmp59_;
										vala_report_error (_tmp55_, _tmp60_);
										_g_free0 (_tmp60_);
										_vala_source_reference_unref0 (_tmp55_);
										vala_gir_parser_skip_element (self);
									}
								}
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "interface");
	_vala_code_node_unref0 (iface);
}


static void
vala_gir_parser_parse_field (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* nullable = NULL;
	ValaMarkupReader* _tmp2_;
	gchar* _tmp3_;
	gchar* allow_none = NULL;
	ValaMarkupReader* _tmp4_;
	gchar* _tmp5_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp6_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp7_ = 0;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	ValaDataType* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp13_;
	const gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* cname = NULL;
	ValaGirParserNode* _tmp16_;
	ValaMap* _tmp17_;
	gpointer _tmp18_;
	ValaField* field = NULL;
	const gchar* _tmp19_;
	ValaDataType* _tmp20_;
	ValaGirParserNode* _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaField* _tmp23_;
	ValaField* _tmp24_;
	ValaField* _tmp25_;
	ValaGirComment* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	ValaDataType* _tmp31_;
	gboolean _tmp44_ = FALSE;
	const gchar* _tmp45_;
	ValaGirParserNode* _tmp48_;
	ValaField* _tmp49_;
	ValaSymbol* _tmp50_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "field");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reader;
	_tmp3_ = vala_markup_reader_get_attribute (_tmp2_, "nullable");
	nullable = _tmp3_;
	_tmp4_ = self->priv->reader;
	_tmp5_ = vala_markup_reader_get_attribute (_tmp4_, "allow-none");
	allow_none = _tmp5_;
	vala_gir_parser_next (self);
	_tmp6_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp6_;
	_tmp10_ = vala_gir_parser_parse_type (self, NULL, &_tmp7_, TRUE, &_tmp8_, &_tmp9_);
	array_length_idx = _tmp7_;
	no_array_length = _tmp8_;
	array_null_terminated = _tmp9_;
	type = _tmp10_;
	_tmp11_ = type;
	_tmp12_ = vala_gir_parser_element_get_type (self, _tmp11_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp12_;
	_tmp13_ = self->priv->current;
	_tmp14_ = _tmp13_->name;
	_tmp15_ = g_strdup (_tmp14_);
	name = _tmp15_;
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->girdata;
	_tmp18_ = vala_map_get (_tmp17_, "name");
	cname = (gchar*) _tmp18_;
	_tmp19_ = name;
	_tmp20_ = type;
	_tmp21_ = self->priv->current;
	_tmp22_ = _tmp21_->source_reference;
	_tmp23_ = vala_field_new (_tmp19_, _tmp20_, NULL, _tmp22_, NULL);
	field = _tmp23_;
	_tmp24_ = field;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = field;
	_tmp26_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp25_, (ValaComment*) _tmp26_);
	_tmp27_ = name;
	_tmp28_ = cname;
	if (g_strcmp0 (_tmp27_, _tmp28_) != 0) {
		ValaField* _tmp29_;
		const gchar* _tmp30_;
		_tmp29_ = field;
		_tmp30_ = cname;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp29_, "CCode", "cname", _tmp30_, NULL);
	}
	_tmp31_ = type;
	if (VALA_IS_ARRAY_TYPE (_tmp31_)) {
		gboolean _tmp32_ = FALSE;
		gboolean _tmp33_;
		gboolean _tmp37_ = FALSE;
		gboolean _tmp38_;
		gboolean _tmp42_;
		_tmp33_ = no_array_length;
		if (!_tmp33_) {
			gint _tmp34_;
			_tmp34_ = array_length_idx;
			_tmp32_ = _tmp34_ > -1;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp35_;
			gint _tmp36_;
			_tmp35_ = self->priv->current;
			_tmp36_ = array_length_idx;
			_tmp35_->array_length_idx = _tmp36_;
		}
		_tmp38_ = no_array_length;
		if (_tmp38_) {
			_tmp37_ = TRUE;
		} else {
			gboolean _tmp39_;
			_tmp39_ = array_null_terminated;
			_tmp37_ = _tmp39_;
		}
		if (_tmp37_) {
			ValaField* _tmp40_;
			gboolean _tmp41_;
			_tmp40_ = field;
			_tmp41_ = no_array_length;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp40_, "CCode", "array_length", !_tmp41_, NULL);
		}
		_tmp42_ = array_null_terminated;
		if (_tmp42_) {
			ValaField* _tmp43_;
			_tmp43_ = field;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp43_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp45_ = nullable;
	if (g_strcmp0 (_tmp45_, "1") == 0) {
		_tmp44_ = TRUE;
	} else {
		const gchar* _tmp46_;
		_tmp46_ = allow_none;
		_tmp44_ = g_strcmp0 (_tmp46_, "1") == 0;
	}
	if (_tmp44_) {
		ValaDataType* _tmp47_;
		_tmp47_ = type;
		vala_data_type_set_nullable (_tmp47_, TRUE);
	}
	_tmp48_ = self->priv->current;
	_tmp49_ = field;
	_tmp50_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp49_);
	_vala_code_node_unref0 (_tmp48_->symbol);
	_tmp48_->symbol = _tmp50_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "field");
	_vala_code_node_unref0 (field);
	_g_free0 (cname);
	_g_free0 (name);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (allow_none);
	_g_free0 (nullable);
}


static ValaProperty*
vala_gir_parser_parse_property (ValaGirParser* self)
{
	ValaProperty* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean is_abstract = FALSE;
	ValaGirParserMetadata* _tmp4_;
	ValaGirParserNode* _tmp5_;
	ValaGirParserNode* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* transfer = NULL;
	ValaMarkupReader* _tmp8_;
	gchar* _tmp9_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp10_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	ValaDataType* type = NULL;
	const gchar* _tmp11_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaDataType* _tmp14_;
	ValaDataType* _tmp15_;
	ValaDataType* _tmp16_;
	ValaProperty* prop = NULL;
	ValaGirParserNode* _tmp17_;
	const gchar* _tmp18_;
	ValaDataType* _tmp19_;
	ValaGirParserNode* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaProperty* _tmp22_;
	ValaProperty* _tmp23_;
	ValaGirComment* _tmp24_;
	ValaProperty* _tmp25_;
	ValaProperty* _tmp26_;
	ValaProperty* _tmp27_;
	gboolean _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean _tmp30_;
	gboolean _tmp34_;
	ValaGirParserNode* _tmp36_;
	ValaProperty* _tmp37_;
	ValaSymbol* _tmp38_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_gir_parser_start_element (self, "property");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, "-", "_");
	_tmp3_ = _tmp2_;
	vala_gir_parser_push_node (self, _tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = self->priv->metadata;
	_tmp5_ = self->priv->current;
	_tmp6_ = _tmp5_->parent;
	_tmp7_ = _tmp6_->symbol;
	is_abstract = vala_gir_parser_metadata_get_bool (_tmp4_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, VALA_IS_INTERFACE (_tmp7_));
	_tmp8_ = self->priv->reader;
	_tmp9_ = vala_markup_reader_get_attribute (_tmp8_, "transfer-ownership");
	transfer = _tmp9_;
	vala_gir_parser_next (self);
	_tmp10_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp10_;
	_tmp11_ = transfer;
	_tmp14_ = vala_gir_parser_parse_type (self, NULL, NULL, g_strcmp0 (_tmp11_, "container") != 0, &_tmp12_, &_tmp13_);
	no_array_length = _tmp12_;
	array_null_terminated = _tmp13_;
	type = _tmp14_;
	_tmp15_ = type;
	_tmp16_ = vala_gir_parser_element_get_type (self, _tmp15_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp16_;
	_tmp17_ = self->priv->current;
	_tmp18_ = _tmp17_->name;
	_tmp19_ = type;
	_tmp20_ = self->priv->current;
	_tmp21_ = _tmp20_->source_reference;
	_tmp22_ = vala_property_new (_tmp18_, _tmp19_, NULL, NULL, _tmp21_, NULL);
	prop = _tmp22_;
	_tmp23_ = prop;
	_tmp24_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp23_, (ValaComment*) _tmp24_);
	_tmp25_ = prop;
	vala_symbol_set_access ((ValaSymbol*) _tmp25_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp26_ = prop;
	vala_symbol_set_external ((ValaSymbol*) _tmp26_, TRUE);
	_tmp27_ = prop;
	_tmp28_ = is_abstract;
	vala_property_set_is_abstract (_tmp27_, _tmp28_);
	_tmp30_ = no_array_length;
	if (_tmp30_) {
		_tmp29_ = TRUE;
	} else {
		gboolean _tmp31_;
		_tmp31_ = array_null_terminated;
		_tmp29_ = _tmp31_;
	}
	if (_tmp29_) {
		ValaProperty* _tmp32_;
		gboolean _tmp33_;
		_tmp32_ = prop;
		_tmp33_ = no_array_length;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp32_, "CCode", "array_length", !_tmp33_, NULL);
	}
	_tmp34_ = array_null_terminated;
	if (_tmp34_) {
		ValaProperty* _tmp35_;
		_tmp35_ = prop;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp35_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	_tmp36_ = self->priv->current;
	_tmp37_ = prop;
	_tmp38_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp37_);
	_vala_code_node_unref0 (_tmp36_->symbol);
	_tmp36_->symbol = _tmp38_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "property");
	result = prop;
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
	_g_free0 (transfer);
	return result;
}


static void
vala_gir_parser_parse_callback (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "callback");
}


static void
vala_gir_parser_parse_constructor (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "constructor");
}


static void
vala_gir_parser_parse_function (ValaGirParser* self,
                                const gchar* element_name)
{
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* symbol_type = NULL;
	ValaGirParserMetadata* _tmp7_;
	gchar* ctype = NULL;
	ValaGirParserMetadata* _tmp11_;
	gchar* name = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* throws_string = NULL;
	ValaMarkupReader* _tmp17_;
	gchar* _tmp18_;
	gchar* invoker = NULL;
	ValaMarkupReader* _tmp19_;
	gchar* _tmp20_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp21_;
	ValaDataType* return_type = NULL;
	gchar* return_ctype = NULL;
	gint return_array_length_idx = 0;
	gboolean return_no_array_length = FALSE;
	gboolean return_array_null_terminated = FALSE;
	gboolean _tmp22_ = FALSE;
	ValaMarkupTokenType _tmp23_;
	ValaSymbol* s = NULL;
	const gchar* _tmp41_;
	ValaSymbol* _tmp98_;
	ValaSymbol* _tmp99_;
	ValaGirComment* _tmp100_;
	ValaSymbol* _tmp101_;
	ValaArrayType* array_type = NULL;
	ValaDataType* _tmp102_;
	ValaArrayType* _tmp103_;
	gboolean _tmp104_ = FALSE;
	ValaArrayType* _tmp105_;
	ValaSymbol* _tmp117_;
	ValaSymbol* _tmp131_;
	gboolean _tmp171_ = FALSE;
	ValaSymbol* _tmp172_;
	ValaGirParserMetadata* _tmp196_;
	ValaExpression* _tmp197_;
	ValaExpression* _tmp198_;
	gboolean _tmp199_;
	ValaSymbol* _tmp220_;
	gboolean _tmp230_ = FALSE;
	ValaDataType* _tmp231_;
	ValaGirParserNode* _tmp241_;
	gint _tmp242_;
	const gchar* _tmp243_;
	ValaGirParserNode* _tmp246_;
	ValaSymbol* _tmp247_;
	ValaSymbol* _tmp248_;
	ValaGirParserMetadata* _tmp249_;
	ValaGirParserMetadata* _tmp254_;
	gint instance_idx = 0;
	gboolean _tmp257_ = FALSE;
	ValaArrayList* parameters = NULL;
	GEqualFunc _tmp266_;
	ValaArrayList* _tmp267_;
	ValaGirParserNode* _tmp268_;
	GEqualFunc _tmp269_;
	ValaArrayList* _tmp270_;
	ValaGirParserNode* _tmp271_;
	GEqualFunc _tmp272_;
	ValaArrayList* _tmp273_;
	ValaGirParserNode* _tmp274_;
	GEqualFunc _tmp275_;
	ValaArrayList* _tmp276_;
	gboolean _tmp277_ = FALSE;
	ValaMarkupTokenType _tmp278_;
	ValaGirParserNode* _tmp364_;
	ValaArrayList* _tmp365_;
	ValaList* _tmp366_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "invoker");
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_element_get_name (self, _tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "-", "_");
	_tmp6_ = _tmp5_;
	vala_gir_parser_push_node (self, _tmp6_, FALSE);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_tmp7_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp7_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE)) {
		ValaGirParserMetadata* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->priv->metadata;
		_tmp9_ = vala_gir_parser_metadata_get_string (_tmp8_, VALA_GIR_PARSER_ARGUMENT_TYPE_SYMBOL_TYPE);
		_g_free0 (symbol_type);
		symbol_type = _tmp9_;
	} else {
		gchar* _tmp10_;
		_tmp10_ = g_strdup (element_name);
		_g_free0 (symbol_type);
		symbol_type = _tmp10_;
	}
	ctype = NULL;
	_tmp11_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp11_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE)) {
		ValaGirParserMetadata* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = self->priv->metadata;
		_tmp13_ = vala_gir_parser_metadata_get_string (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CTYPE);
		_g_free0 (ctype);
		ctype = _tmp13_;
	}
	_tmp14_ = self->priv->current;
	_tmp15_ = _tmp14_->name;
	_tmp16_ = g_strdup (_tmp15_);
	name = _tmp16_;
	_tmp17_ = self->priv->reader;
	_tmp18_ = vala_markup_reader_get_attribute (_tmp17_, "throws");
	throws_string = _tmp18_;
	_tmp19_ = self->priv->reader;
	_tmp20_ = vala_markup_reader_get_attribute (_tmp19_, "invoker");
	invoker = _tmp20_;
	vala_gir_parser_next (self);
	_tmp21_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp21_;
	return_ctype = NULL;
	return_array_length_idx = -1;
	return_no_array_length = FALSE;
	return_array_null_terminated = FALSE;
	_tmp23_ = self->priv->current_token;
	if (_tmp23_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp24_ = self->priv->reader;
		_tmp25_ = vala_markup_reader_get_name (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp22_ = g_strcmp0 (_tmp26_, "return-value") == 0;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		ValaComment* return_comment = NULL;
		gchar* _tmp27_ = NULL;
		gint _tmp28_ = 0;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		ValaComment* _tmp31_ = NULL;
		ValaDataType* _tmp32_;
		ValaComment* _tmp33_;
		_tmp32_ = vala_gir_parser_parse_return_value (self, &_tmp27_, &_tmp28_, &_tmp29_, &_tmp30_, &_tmp31_);
		_g_free0 (return_ctype);
		return_ctype = _tmp27_;
		return_array_length_idx = _tmp28_;
		return_no_array_length = _tmp29_;
		return_array_null_terminated = _tmp30_;
		_vala_comment_unref0 (return_comment);
		return_comment = _tmp31_;
		_vala_code_node_unref0 (return_type);
		return_type = _tmp32_;
		_tmp33_ = return_comment;
		if (_tmp33_ != NULL) {
			ValaGirComment* _tmp34_;
			ValaGirComment* _tmp38_;
			ValaComment* _tmp39_;
			_tmp34_ = comment;
			if (_tmp34_ == NULL) {
				ValaGirParserNode* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaGirComment* _tmp37_;
				_tmp35_ = self->priv->current;
				_tmp36_ = _tmp35_->source_reference;
				_tmp37_ = vala_gir_comment_new (NULL, _tmp36_);
				_vala_comment_unref0 (comment);
				comment = _tmp37_;
			}
			_tmp38_ = comment;
			_tmp39_ = return_comment;
			vala_gir_comment_set_return_content (_tmp38_, _tmp39_);
		}
		_vala_comment_unref0 (return_comment);
	} else {
		ValaVoidType* _tmp40_;
		_tmp40_ = vala_void_type_new (NULL);
		_vala_code_node_unref0 (return_type);
		return_type = (ValaDataType*) _tmp40_;
	}
	_tmp41_ = symbol_type;
	if (g_strcmp0 (_tmp41_, "callback") == 0) {
		const gchar* _tmp42_;
		ValaDataType* _tmp43_;
		ValaGirParserNode* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaDelegate* _tmp46_;
		ValaSymbol* _tmp47_;
		_tmp42_ = name;
		_tmp43_ = return_type;
		_tmp44_ = self->priv->current;
		_tmp45_ = _tmp44_->source_reference;
		_tmp46_ = vala_delegate_new (_tmp42_, _tmp43_, _tmp45_, NULL);
		_vala_code_node_unref0 (s);
		s = (ValaSymbol*) _tmp46_;
		_tmp47_ = s;
		vala_delegate_set_has_target (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_DELEGATE, ValaDelegate), FALSE);
	} else {
		const gchar* _tmp48_;
		_tmp48_ = symbol_type;
		if (g_strcmp0 (_tmp48_, "constructor") == 0) {
			const gchar* _tmp49_;
			ValaCreationMethod* m = NULL;
			const gchar* _tmp55_;
			ValaGirParserNode* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaCreationMethod* _tmp58_;
			ValaCreationMethod* _tmp59_;
			gboolean _tmp60_ = FALSE;
			const gchar* _tmp61_;
			gchar* parent_ctype = NULL;
			ValaGirParserNode* _tmp69_;
			ValaGirParserNode* _tmp70_;
			ValaSymbol* _tmp71_;
			gboolean _tmp75_ = FALSE;
			const gchar* _tmp76_;
			ValaCreationMethod* _tmp85_;
			ValaSymbol* _tmp86_;
			_tmp49_ = name;
			if (g_strcmp0 (_tmp49_, "new") == 0) {
				_g_free0 (name);
				name = NULL;
			} else {
				const gchar* _tmp50_;
				_tmp50_ = name;
				if (g_str_has_prefix (_tmp50_, "new_")) {
					const gchar* _tmp51_;
					gint _tmp52_;
					gint _tmp53_;
					gchar* _tmp54_;
					_tmp51_ = name;
					_tmp52_ = strlen ("new_");
					_tmp53_ = _tmp52_;
					_tmp54_ = string_substring (_tmp51_, (glong) _tmp53_, (glong) -1);
					_g_free0 (name);
					name = _tmp54_;
				}
			}
			_tmp55_ = name;
			_tmp56_ = self->priv->current;
			_tmp57_ = _tmp56_->source_reference;
			_tmp58_ = vala_creation_method_new (NULL, _tmp55_, _tmp57_, NULL);
			m = _tmp58_;
			_tmp59_ = m;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp59_, FALSE);
			_tmp61_ = name;
			if (_tmp61_ != NULL) {
				ValaGirParserNode* _tmp62_;
				const gchar* _tmp63_;
				_tmp62_ = self->priv->current;
				_tmp63_ = _tmp62_->name;
				_tmp60_ = !g_str_has_prefix (_tmp63_, "new_");
			} else {
				_tmp60_ = FALSE;
			}
			if (_tmp60_) {
				ValaCreationMethod* _tmp64_;
				ValaGirParserNode* _tmp65_;
				ValaMap* _tmp66_;
				gpointer _tmp67_;
				gchar* _tmp68_;
				_tmp64_ = m;
				_tmp65_ = self->priv->current;
				_tmp66_ = _tmp65_->girdata;
				_tmp67_ = vala_map_get (_tmp66_, "c:identifier");
				_tmp68_ = (gchar*) _tmp67_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp64_, "CCode", "cname", _tmp68_, NULL);
				_g_free0 (_tmp68_);
			}
			parent_ctype = NULL;
			_tmp69_ = self->priv->current;
			_tmp70_ = _tmp69_->parent;
			_tmp71_ = _tmp70_->symbol;
			if (VALA_IS_CLASS (_tmp71_)) {
				ValaGirParserNode* _tmp72_;
				ValaGirParserNode* _tmp73_;
				gchar* _tmp74_;
				_tmp72_ = self->priv->current;
				_tmp73_ = _tmp72_->parent;
				_tmp74_ = vala_gir_parser_node_get_cname (_tmp73_);
				_g_free0 (parent_ctype);
				parent_ctype = _tmp74_;
			}
			_tmp76_ = return_ctype;
			if (_tmp76_ != NULL) {
				gboolean _tmp77_ = FALSE;
				const gchar* _tmp78_;
				_tmp78_ = parent_ctype;
				if (_tmp78_ == NULL) {
					_tmp77_ = TRUE;
				} else {
					const gchar* _tmp79_;
					const gchar* _tmp80_;
					gchar* _tmp81_;
					gchar* _tmp82_;
					_tmp79_ = return_ctype;
					_tmp80_ = parent_ctype;
					_tmp81_ = g_strconcat (_tmp80_, "*", NULL);
					_tmp82_ = _tmp81_;
					_tmp77_ = g_strcmp0 (_tmp79_, _tmp82_) != 0;
					_g_free0 (_tmp82_);
				}
				_tmp75_ = _tmp77_;
			} else {
				_tmp75_ = FALSE;
			}
			if (_tmp75_) {
				ValaCreationMethod* _tmp83_;
				const gchar* _tmp84_;
				_tmp83_ = m;
				_tmp84_ = return_ctype;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp83_, "CCode", "type", _tmp84_, NULL);
			}
			_tmp85_ = m;
			_tmp86_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp85_);
			_vala_code_node_unref0 (s);
			s = _tmp86_;
			_g_free0 (parent_ctype);
			_vala_code_node_unref0 (m);
		} else {
			const gchar* _tmp87_;
			_tmp87_ = symbol_type;
			if (g_strcmp0 (_tmp87_, "glib:signal") == 0) {
				const gchar* _tmp88_;
				ValaDataType* _tmp89_;
				ValaGirParserNode* _tmp90_;
				ValaSourceReference* _tmp91_;
				ValaSignal* _tmp92_;
				_tmp88_ = name;
				_tmp89_ = return_type;
				_tmp90_ = self->priv->current;
				_tmp91_ = _tmp90_->source_reference;
				_tmp92_ = vala_signal_new (_tmp88_, _tmp89_, _tmp91_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp92_;
			} else {
				const gchar* _tmp93_;
				ValaDataType* _tmp94_;
				ValaGirParserNode* _tmp95_;
				ValaSourceReference* _tmp96_;
				ValaMethod* _tmp97_;
				_tmp93_ = name;
				_tmp94_ = return_type;
				_tmp95_ = self->priv->current;
				_tmp96_ = _tmp95_->source_reference;
				_tmp97_ = vala_method_new (_tmp93_, _tmp94_, _tmp96_, NULL);
				_vala_code_node_unref0 (s);
				s = (ValaSymbol*) _tmp97_;
			}
		}
	}
	_tmp98_ = s;
	vala_symbol_set_access (_tmp98_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp99_ = s;
	_tmp100_ = comment;
	vala_symbol_set_comment (_tmp99_, (ValaComment*) _tmp100_);
	_tmp101_ = s;
	vala_symbol_set_external (_tmp101_, TRUE);
	_tmp102_ = return_type;
	_tmp103_ = _vala_code_node_ref0 (VALA_IS_ARRAY_TYPE (_tmp102_) ? ((ValaArrayType*) _tmp102_) : NULL);
	array_type = _tmp103_;
	_tmp105_ = array_type;
	if (_tmp105_ != NULL) {
		ValaArrayType* _tmp106_;
		gboolean _tmp107_;
		gboolean _tmp108_;
		_tmp106_ = array_type;
		_tmp107_ = vala_array_type_get_fixed_length (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp104_ = _tmp108_;
	} else {
		_tmp104_ = FALSE;
	}
	if (_tmp104_) {
		ValaSymbol* _tmp109_;
		ValaArrayType* _tmp110_;
		ValaExpression* _tmp111_;
		ValaExpression* _tmp112_;
		const gchar* _tmp113_;
		const gchar* _tmp114_;
		ValaArrayType* _tmp115_;
		ValaArrayType* _tmp116_;
		_tmp109_ = s;
		_tmp110_ = array_type;
		_tmp111_ = vala_array_type_get_length (_tmp110_);
		_tmp112_ = _tmp111_;
		_tmp113_ = vala_integer_literal_get_value (G_TYPE_CHECK_INSTANCE_CAST (_tmp112_, VALA_TYPE_INTEGER_LITERAL, ValaIntegerLiteral));
		_tmp114_ = _tmp113_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp109_, "CCode", "array_length_cexpr", _tmp114_, NULL);
		_tmp115_ = array_type;
		vala_array_type_set_fixed_length (_tmp115_, FALSE);
		_tmp116_ = array_type;
		vala_array_type_set_length (_tmp116_, NULL);
	}
	_tmp117_ = s;
	if (VALA_IS_SIGNAL (_tmp117_)) {
		ValaGirParserNode* _tmp118_;
		ValaMap* _tmp119_;
		gpointer _tmp120_;
		gchar* _tmp121_;
		const gchar* _tmp122_;
		gchar* _tmp123_;
		gchar* _tmp124_;
		gboolean _tmp125_;
		_tmp118_ = self->priv->current;
		_tmp119_ = _tmp118_->girdata;
		_tmp120_ = vala_map_get (_tmp119_, "name");
		_tmp121_ = (gchar*) _tmp120_;
		_tmp122_ = name;
		_tmp123_ = string_replace (_tmp122_, "_", "-");
		_tmp124_ = _tmp123_;
		_tmp125_ = g_strcmp0 (_tmp121_, _tmp124_) != 0;
		_g_free0 (_tmp124_);
		_g_free0 (_tmp121_);
		if (_tmp125_) {
			ValaSymbol* _tmp126_;
			ValaGirParserNode* _tmp127_;
			ValaMap* _tmp128_;
			gpointer _tmp129_;
			gchar* _tmp130_;
			_tmp126_ = s;
			_tmp127_ = self->priv->current;
			_tmp128_ = _tmp127_->girdata;
			_tmp129_ = vala_map_get (_tmp128_, "name");
			_tmp130_ = (gchar*) _tmp129_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp126_, "CCode", "cname", _tmp130_, NULL);
			_g_free0 (_tmp130_);
		}
	}
	_tmp131_ = s;
	if (VALA_IS_METHOD (_tmp131_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp132_;
		ValaMethod* _tmp133_;
		gboolean _tmp134_ = FALSE;
		const gchar* _tmp135_;
		ValaGirParserMetadata* _tmp162_;
		ValaGirParserMetadata* _tmp168_;
		_tmp132_ = s;
		_tmp133_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp132_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp133_;
		_tmp135_ = symbol_type;
		if (g_strcmp0 (_tmp135_, "virtual-method") == 0) {
			_tmp134_ = TRUE;
		} else {
			const gchar* _tmp136_;
			_tmp136_ = symbol_type;
			_tmp134_ = g_strcmp0 (_tmp136_, "callback") == 0;
		}
		if (_tmp134_) {
			ValaGirParserNode* _tmp137_;
			ValaGirParserNode* _tmp138_;
			ValaSymbol* _tmp139_;
			gboolean _tmp142_ = FALSE;
			const gchar* _tmp143_;
			ValaGirParserNode* _tmp149_;
			ValaMap* _tmp150_;
			gpointer _tmp151_;
			gchar* _tmp152_;
			const gchar* _tmp153_;
			gboolean _tmp154_;
			_tmp137_ = self->priv->current;
			_tmp138_ = _tmp137_->parent;
			_tmp139_ = _tmp138_->symbol;
			if (VALA_IS_INTERFACE (_tmp139_)) {
				ValaMethod* _tmp140_;
				_tmp140_ = m;
				vala_method_set_is_abstract (_tmp140_, TRUE);
			} else {
				ValaMethod* _tmp141_;
				_tmp141_ = m;
				vala_method_set_is_virtual (_tmp141_, TRUE);
			}
			_tmp143_ = invoker;
			if (_tmp143_ == NULL) {
				ValaGirParserMetadata* _tmp144_;
				_tmp144_ = self->priv->metadata;
				_tmp142_ = !vala_gir_parser_metadata_has_argument (_tmp144_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			} else {
				_tmp142_ = FALSE;
			}
			if (_tmp142_) {
				ValaSymbol* _tmp145_;
				ValaSymbol* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaSourceReference* _tmp148_;
				_tmp145_ = s;
				_tmp146_ = s;
				_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp146_);
				_tmp148_ = _tmp147_;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp145_, "NoWrapper", TRUE, _tmp148_);
			}
			_tmp149_ = self->priv->current;
			_tmp150_ = _tmp149_->girdata;
			_tmp151_ = vala_map_get (_tmp150_, "name");
			_tmp152_ = (gchar*) _tmp151_;
			_tmp153_ = name;
			_tmp154_ = g_strcmp0 (_tmp152_, _tmp153_) != 0;
			_g_free0 (_tmp152_);
			if (_tmp154_) {
				ValaMethod* _tmp155_;
				ValaGirParserNode* _tmp156_;
				ValaMap* _tmp157_;
				gpointer _tmp158_;
				gchar* _tmp159_;
				_tmp155_ = m;
				_tmp156_ = self->priv->current;
				_tmp157_ = _tmp156_->girdata;
				_tmp158_ = vala_map_get (_tmp157_, "name");
				_tmp159_ = (gchar*) _tmp158_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp155_, "CCode", "vfunc_name", _tmp159_, NULL);
				_g_free0 (_tmp159_);
			}
		} else {
			const gchar* _tmp160_;
			_tmp160_ = symbol_type;
			if (g_strcmp0 (_tmp160_, "function") == 0) {
				ValaMethod* _tmp161_;
				_tmp161_ = m;
				vala_method_set_binding (_tmp161_, VALA_MEMBER_BINDING_STATIC);
			}
		}
		_tmp162_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp162_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING)) {
			ValaMethod* _tmp163_;
			ValaGirParserMetadata* _tmp164_;
			ValaMethod* _tmp165_;
			ValaDataType* _tmp166_;
			ValaDataType* _tmp167_;
			_tmp163_ = m;
			_tmp164_ = self->priv->metadata;
			vala_method_set_returns_floating_reference (_tmp163_, vala_gir_parser_metadata_get_bool (_tmp164_, VALA_GIR_PARSER_ARGUMENT_TYPE_FLOATING, FALSE));
			_tmp165_ = m;
			_tmp166_ = vala_callable_get_return_type ((ValaCallable*) _tmp165_);
			_tmp167_ = _tmp166_;
			vala_data_type_set_value_owned (_tmp167_, TRUE);
		}
		_tmp168_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp168_, VALA_GIR_PARSER_ARGUMENT_TYPE_NEW)) {
			ValaMethod* _tmp169_;
			ValaGirParserMetadata* _tmp170_;
			_tmp169_ = m;
			_tmp170_ = self->priv->metadata;
			vala_symbol_set_hides ((ValaSymbol*) _tmp169_, vala_gir_parser_metadata_get_bool (_tmp170_, VALA_GIR_PARSER_ARGUMENT_TYPE_NEW, FALSE));
		}
		_vala_code_node_unref0 (m);
	}
	_tmp172_ = s;
	if (VALA_IS_METHOD (_tmp172_)) {
		ValaSymbol* _tmp173_;
		_tmp173_ = s;
		_tmp171_ = !VALA_IS_CREATION_METHOD (_tmp173_);
	} else {
		_tmp171_ = FALSE;
	}
	if (_tmp171_) {
		ValaMethod* method = NULL;
		ValaSymbol* _tmp174_;
		ValaMethod* _tmp175_;
		ValaGirParserMetadata* _tmp176_;
		ValaGirParserMetadata* _tmp184_;
		ValaGirParserMetadata* _tmp190_;
		_tmp174_ = s;
		_tmp175_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp174_, VALA_TYPE_METHOD, ValaMethod));
		method = _tmp175_;
		_tmp176_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp176_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL)) {
			ValaMethod* _tmp177_;
			ValaGirParserMetadata* _tmp178_;
			ValaMethod* _tmp179_;
			_tmp177_ = method;
			_tmp178_ = self->priv->metadata;
			vala_method_set_is_virtual (_tmp177_, vala_gir_parser_metadata_get_bool (_tmp178_, VALA_GIR_PARSER_ARGUMENT_TYPE_VIRTUAL, FALSE));
			_tmp179_ = method;
			vala_method_set_is_abstract (_tmp179_, FALSE);
		} else {
			ValaGirParserMetadata* _tmp180_;
			_tmp180_ = self->priv->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp180_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT)) {
				ValaMethod* _tmp181_;
				ValaGirParserMetadata* _tmp182_;
				ValaMethod* _tmp183_;
				_tmp181_ = method;
				_tmp182_ = self->priv->metadata;
				vala_method_set_is_abstract (_tmp181_, vala_gir_parser_metadata_get_bool (_tmp182_, VALA_GIR_PARSER_ARGUMENT_TYPE_ABSTRACT, FALSE));
				_tmp183_ = method;
				vala_method_set_is_virtual (_tmp183_, FALSE);
			}
		}
		_tmp184_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp184_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
			ValaMethod* _tmp185_;
			ValaGirParserMetadata* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			ValaMethod* _tmp189_;
			_tmp185_ = method;
			_tmp186_ = self->priv->metadata;
			_tmp187_ = vala_gir_parser_metadata_get_string (_tmp186_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
			_tmp188_ = _tmp187_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp185_, "CCode", "vfunc_name", _tmp188_, NULL);
			_g_free0 (_tmp188_);
			_tmp189_ = method;
			vala_method_set_is_virtual (_tmp189_, TRUE);
		}
		_tmp190_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp190_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME)) {
			ValaMethod* _tmp191_;
			ValaGirParserMetadata* _tmp192_;
			gchar* _tmp193_;
			gchar* _tmp194_;
			ValaMethod* _tmp195_;
			_tmp191_ = method;
			_tmp192_ = self->priv->metadata;
			_tmp193_ = vala_gir_parser_metadata_get_string (_tmp192_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_VFUNC_NAME);
			_tmp194_ = _tmp193_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp191_, "CCode", "finish_vfunc_name", _tmp194_, NULL);
			_g_free0 (_tmp194_);
			_tmp195_ = method;
			vala_method_set_is_virtual (_tmp195_, TRUE);
		}
		_vala_code_node_unref0 (method);
	}
	_tmp196_ = self->priv->metadata;
	_tmp197_ = vala_gir_parser_metadata_get_expression (_tmp196_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
	_tmp198_ = _tmp197_;
	_tmp199_ = !VALA_IS_NULL_LITERAL (_tmp198_);
	_vala_code_node_unref0 (_tmp198_);
	if (_tmp199_) {
		ValaGirParserMetadata* _tmp200_;
		_tmp200_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp200_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS)) {
			gchar** error_types = NULL;
			ValaGirParserMetadata* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gchar** _tmp204_;
			gchar** _tmp205_;
			gchar** _tmp206_;
			gint _tmp206__length1;
			gint error_types_length1;
			gint _error_types_size_;
			gchar** _tmp207_;
			gint _tmp207__length1;
			_tmp201_ = self->priv->metadata;
			_tmp202_ = vala_gir_parser_metadata_get_string (_tmp201_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
			_tmp203_ = _tmp202_;
			_tmp205_ = _tmp204_ = g_strsplit (_tmp203_, ",", 0);
			_tmp206_ = _tmp205_;
			_tmp206__length1 = _vala_array_length (_tmp204_);
			_g_free0 (_tmp203_);
			error_types = _tmp206_;
			error_types_length1 = _tmp206__length1;
			_error_types_size_ = error_types_length1;
			_tmp207_ = error_types;
			_tmp207__length1 = error_types_length1;
			{
				gchar** error_type_collection = NULL;
				gint error_type_collection_length1 = 0;
				gint _error_type_collection_size_ = 0;
				gint error_type_it = 0;
				error_type_collection = _tmp207_;
				error_type_collection_length1 = _tmp207__length1;
				for (error_type_it = 0; error_type_it < error_type_collection_length1; error_type_it = error_type_it + 1) {
					gchar* _tmp208_;
					gchar* error_type = NULL;
					_tmp208_ = g_strdup (error_type_collection[error_type_it]);
					error_type = _tmp208_;
					{
						ValaSymbol* _tmp209_;
						const gchar* _tmp210_;
						ValaGirParserMetadata* _tmp211_;
						ValaSourceReference* _tmp212_;
						ValaSourceReference* _tmp213_;
						ValaDataType* _tmp214_;
						ValaDataType* _tmp215_;
						_tmp209_ = s;
						_tmp210_ = error_type;
						_tmp211_ = self->priv->metadata;
						_tmp212_ = vala_gir_parser_metadata_get_source_reference (_tmp211_, VALA_GIR_PARSER_ARGUMENT_TYPE_THROWS);
						_tmp213_ = _tmp212_;
						_tmp214_ = vala_gir_parser_parse_type_from_string (self, _tmp210_, TRUE, _tmp213_);
						_tmp215_ = _tmp214_;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp209_, _tmp215_);
						_vala_code_node_unref0 (_tmp215_);
						_vala_source_reference_unref0 (_tmp213_);
						_g_free0 (error_type);
					}
				}
			}
			error_types = (_vala_array_free (error_types, error_types_length1, (GDestroyNotify) g_free), NULL);
		} else {
			const gchar* _tmp216_;
			_tmp216_ = throws_string;
			if (g_strcmp0 (_tmp216_, "1") == 0) {
				ValaSymbol* _tmp217_;
				ValaErrorType* _tmp218_;
				ValaErrorType* _tmp219_;
				_tmp217_ = s;
				_tmp218_ = vala_error_type_new (NULL, NULL, NULL);
				_tmp219_ = _tmp218_;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp217_, (ValaDataType*) _tmp219_);
				_vala_code_node_unref0 (_tmp219_);
			}
		}
	}
	_tmp220_ = s;
	if (VALA_IS_METHOD (_tmp220_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp221_;
		ValaMethod* _tmp222_;
		ValaMethod* _tmp223_;
		ValaGirParserMetadata* _tmp224_;
		ValaGirParserMetadata* _tmp225_;
		_tmp221_ = s;
		_tmp222_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp221_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp222_;
		_tmp223_ = m;
		_tmp224_ = self->priv->metadata;
		vala_code_node_set_attribute ((ValaCodeNode*) _tmp223_, "PrintfFormat", vala_gir_parser_metadata_get_bool (_tmp224_, VALA_GIR_PARSER_ARGUMENT_TYPE_PRINTF_FORMAT, FALSE), NULL);
		_tmp225_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp225_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL)) {
			ValaMethod* _tmp226_;
			ValaGirParserMetadata* _tmp227_;
			gchar* _tmp228_;
			gchar* _tmp229_;
			_tmp226_ = m;
			_tmp227_ = self->priv->metadata;
			_tmp228_ = vala_gir_parser_metadata_get_string (_tmp227_, VALA_GIR_PARSER_ARGUMENT_TYPE_SENTINEL);
			_tmp229_ = _tmp228_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp226_, "CCode", "sentinel", _tmp229_, NULL);
			_g_free0 (_tmp229_);
		}
		_vala_code_node_unref0 (m);
	}
	_tmp231_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp231_)) {
		ValaGirParserMetadata* _tmp232_;
		_tmp232_ = self->priv->metadata;
		_tmp230_ = vala_gir_parser_metadata_has_argument (_tmp232_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		_tmp230_ = FALSE;
	}
	if (_tmp230_) {
		ValaGirParserMetadata* _tmp233_;
		_tmp233_ = self->priv->metadata;
		return_array_length_idx = vala_gir_parser_metadata_get_integer (_tmp233_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_IDX);
	} else {
		gboolean _tmp234_ = FALSE;
		gboolean _tmp235_;
		gboolean _tmp239_;
		_tmp235_ = return_no_array_length;
		if (_tmp235_) {
			_tmp234_ = TRUE;
		} else {
			gboolean _tmp236_;
			_tmp236_ = return_array_null_terminated;
			_tmp234_ = _tmp236_;
		}
		if (_tmp234_) {
			ValaSymbol* _tmp237_;
			gboolean _tmp238_;
			_tmp237_ = s;
			_tmp238_ = return_no_array_length;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp237_, "CCode", "array_length", !_tmp238_, NULL);
		}
		_tmp239_ = return_array_null_terminated;
		if (_tmp239_) {
			ValaSymbol* _tmp240_;
			_tmp240_ = s;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp240_, "CCode", "array_null_terminated", TRUE, NULL);
		}
	}
	_tmp241_ = self->priv->current;
	_tmp242_ = return_array_length_idx;
	_tmp241_->return_array_length_idx = _tmp242_;
	_tmp243_ = ctype;
	if (_tmp243_ != NULL) {
		ValaSymbol* _tmp244_;
		const gchar* _tmp245_;
		_tmp244_ = s;
		_tmp245_ = ctype;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp244_, "CCode", "type", _tmp245_, NULL);
	}
	_tmp246_ = self->priv->current;
	_tmp247_ = s;
	_tmp248_ = _vala_code_node_ref0 (_tmp247_);
	_vala_code_node_unref0 (_tmp246_->symbol);
	_tmp246_->symbol = _tmp248_;
	_tmp249_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp249_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME)) {
		ValaSymbol* _tmp250_;
		ValaGirParserMetadata* _tmp251_;
		gchar* _tmp252_;
		gchar* _tmp253_;
		_tmp250_ = s;
		_tmp251_ = self->priv->metadata;
		_tmp252_ = vala_gir_parser_metadata_get_string (_tmp251_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_NAME);
		_tmp253_ = _tmp252_;
		vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp250_, "CCode", "finish_name", _tmp253_, NULL);
		_g_free0 (_tmp253_);
	}
	_tmp254_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp254_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE)) {
		ValaSymbol* _tmp255_;
		ValaGirParserMetadata* _tmp256_;
		_tmp255_ = s;
		_tmp256_ = self->priv->metadata;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp255_, "CCode", "finish_instance", vala_gir_parser_metadata_get_bool (_tmp256_, VALA_GIR_PARSER_ARGUMENT_TYPE_FINISH_INSTANCE, FALSE), NULL);
	}
	instance_idx = -2;
	if (g_strcmp0 (element_name, "function") == 0) {
		const gchar* _tmp258_;
		_tmp258_ = symbol_type;
		_tmp257_ = g_strcmp0 (_tmp258_, "method") == 0;
	} else {
		_tmp257_ = FALSE;
	}
	if (_tmp257_) {
		ValaGirParserMetadata* _tmp259_;
		_tmp259_ = self->priv->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp259_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX)) {
			ValaGirParserMetadata* _tmp260_;
			gint _tmp261_;
			_tmp260_ = self->priv->metadata;
			instance_idx = vala_gir_parser_metadata_get_integer (_tmp260_, VALA_GIR_PARSER_ARGUMENT_TYPE_INSTANCE_IDX);
			_tmp261_ = instance_idx;
			if (_tmp261_ != 0) {
				ValaSymbol* _tmp262_;
				gint _tmp263_;
				_tmp262_ = s;
				_tmp263_ = instance_idx;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp262_, "CCode", "instance_pos", _tmp263_ + 0.5, NULL);
			}
		} else {
			ValaSourceReference* _tmp264_;
			ValaSourceReference* _tmp265_;
			_tmp264_ = vala_gir_parser_get_current_src (self);
			_tmp265_ = _tmp264_;
			vala_report_error (_tmp265_, "instance_idx required when converting function to method");
			_vala_source_reference_unref0 (_tmp265_);
		}
	}
	_tmp266_ = g_direct_equal;
	_tmp267_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, (GBoxedCopyFunc) vala_gir_parser_parameter_info_ref, (GDestroyNotify) vala_gir_parser_parameter_info_unref, _tmp266_);
	parameters = _tmp267_;
	_tmp268_ = self->priv->current;
	_tmp269_ = g_direct_equal;
	_tmp270_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp269_);
	_vala_iterable_unref0 (_tmp268_->array_length_parameters);
	_tmp268_->array_length_parameters = _tmp270_;
	_tmp271_ = self->priv->current;
	_tmp272_ = g_direct_equal;
	_tmp273_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp272_);
	_vala_iterable_unref0 (_tmp271_->closure_parameters);
	_tmp271_->closure_parameters = _tmp273_;
	_tmp274_ = self->priv->current;
	_tmp275_ = g_direct_equal;
	_tmp276_ = vala_array_list_new (G_TYPE_INT, NULL, NULL, _tmp275_);
	_vala_iterable_unref0 (_tmp274_->destroy_parameters);
	_tmp274_->destroy_parameters = _tmp276_;
	_tmp278_ = self->priv->current_token;
	if (_tmp278_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT) {
		ValaMarkupReader* _tmp279_;
		const gchar* _tmp280_;
		const gchar* _tmp281_;
		_tmp279_ = self->priv->reader;
		_tmp280_ = vala_markup_reader_get_name (_tmp279_);
		_tmp281_ = _tmp280_;
		_tmp277_ = g_strcmp0 (_tmp281_, "parameters") == 0;
	} else {
		_tmp277_ = FALSE;
	}
	if (_tmp277_) {
		gint current_parameter_idx = 0;
		vala_gir_parser_start_element (self, "parameters");
		vala_gir_parser_next (self);
		current_parameter_idx = -1;
		while (TRUE) {
			ValaMarkupTokenType _tmp282_;
			gint _tmp283_;
			gboolean _tmp284_ = FALSE;
			ValaMarkupReader* _tmp285_;
			const gchar* _tmp286_;
			const gchar* _tmp287_;
			gboolean _tmp291_ = FALSE;
			gint _tmp292_;
			gint array_length_idx = 0;
			gint closure_idx = 0;
			gint destroy_idx = 0;
			gchar* scope = NULL;
			gchar* default_param_name = NULL;
			ValaComment* param_comment = NULL;
			ValaArrayList* _tmp295_;
			gint _tmp296_;
			gint _tmp297_;
			gchar* _tmp298_;
			ValaParameter* param = NULL;
			const gchar* _tmp299_;
			gint _tmp300_ = 0;
			gint _tmp301_ = 0;
			gint _tmp302_ = 0;
			gchar* _tmp303_ = NULL;
			ValaComment* _tmp304_ = NULL;
			ValaParameter* _tmp305_;
			gint _tmp306_;
			gint _tmp315_;
			gint _tmp327_;
			ValaComment* _tmp339_;
			ValaGirParserParameterInfo* info = NULL;
			ValaParameter* _tmp356_;
			gint _tmp357_;
			gint _tmp358_;
			gint _tmp359_;
			const gchar* _tmp360_;
			ValaGirParserParameterInfo* _tmp361_;
			ValaArrayList* _tmp362_;
			ValaGirParserParameterInfo* _tmp363_;
			_tmp282_ = self->priv->current_token;
			if (!(_tmp282_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			_tmp283_ = current_parameter_idx;
			current_parameter_idx = _tmp283_ + 1;
			_tmp285_ = self->priv->reader;
			_tmp286_ = vala_markup_reader_get_name (_tmp285_);
			_tmp287_ = _tmp286_;
			if (g_strcmp0 (_tmp287_, "instance-parameter") == 0) {
				gboolean _tmp288_ = FALSE;
				const gchar* _tmp289_;
				_tmp289_ = symbol_type;
				if (g_strcmp0 (_tmp289_, "function") == 0) {
					_tmp288_ = TRUE;
				} else {
					const gchar* _tmp290_;
					_tmp290_ = symbol_type;
					_tmp288_ = g_strcmp0 (_tmp290_, "constructor") == 0;
				}
				_tmp284_ = !_tmp288_;
			} else {
				_tmp284_ = FALSE;
			}
			if (_tmp284_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp292_ = instance_idx;
			if (_tmp292_ > -2) {
				gint _tmp293_;
				gint _tmp294_;
				_tmp293_ = instance_idx;
				_tmp294_ = current_parameter_idx;
				_tmp291_ = _tmp293_ == _tmp294_;
			} else {
				_tmp291_ = FALSE;
			}
			if (_tmp291_) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			default_param_name = NULL;
			_tmp295_ = parameters;
			_tmp296_ = vala_collection_get_size ((ValaCollection*) _tmp295_);
			_tmp297_ = _tmp296_;
			_tmp298_ = g_strdup_printf ("arg%d", _tmp297_);
			_g_free0 (default_param_name);
			default_param_name = _tmp298_;
			_tmp299_ = default_param_name;
			_tmp305_ = vala_gir_parser_parse_parameter (self, &_tmp300_, &_tmp301_, &_tmp302_, &_tmp303_, &_tmp304_, _tmp299_);
			array_length_idx = _tmp300_;
			closure_idx = _tmp301_;
			destroy_idx = _tmp302_;
			_g_free0 (scope);
			scope = _tmp303_;
			_vala_comment_unref0 (param_comment);
			param_comment = _tmp304_;
			param = _tmp305_;
			_tmp306_ = array_length_idx;
			if (_tmp306_ != -1) {
				gboolean _tmp307_ = FALSE;
				gint _tmp308_;
				ValaGirParserNode* _tmp312_;
				ValaArrayList* _tmp313_;
				gint _tmp314_;
				_tmp308_ = instance_idx;
				if (_tmp308_ > -2) {
					gint _tmp309_;
					gint _tmp310_;
					_tmp309_ = instance_idx;
					_tmp310_ = array_length_idx;
					_tmp307_ = _tmp309_ < _tmp310_;
				} else {
					_tmp307_ = FALSE;
				}
				if (_tmp307_) {
					gint _tmp311_;
					_tmp311_ = array_length_idx;
					array_length_idx = _tmp311_ - 1;
				}
				_tmp312_ = self->priv->current;
				_tmp313_ = _tmp312_->array_length_parameters;
				_tmp314_ = array_length_idx;
				vala_collection_add ((ValaCollection*) _tmp313_, (gpointer) ((gintptr) _tmp314_));
			}
			_tmp315_ = closure_idx;
			if (_tmp315_ != -1) {
				gboolean _tmp316_ = FALSE;
				gint _tmp317_;
				ValaGirParserNode* _tmp321_;
				ValaArrayList* _tmp322_;
				gint _tmp323_;
				_tmp317_ = instance_idx;
				if (_tmp317_ > -2) {
					gint _tmp318_;
					gint _tmp319_;
					_tmp318_ = instance_idx;
					_tmp319_ = closure_idx;
					_tmp316_ = _tmp318_ < _tmp319_;
				} else {
					_tmp316_ = FALSE;
				}
				if (_tmp316_) {
					gint _tmp320_;
					_tmp320_ = closure_idx;
					closure_idx = _tmp320_ - 1;
				}
				_tmp321_ = self->priv->current;
				_tmp322_ = _tmp321_->closure_parameters;
				_tmp323_ = current_parameter_idx;
				if (vala_list_index_of ((ValaList*) _tmp322_, (gpointer) ((gintptr) _tmp323_)) < 0) {
					ValaGirParserNode* _tmp324_;
					ValaArrayList* _tmp325_;
					gint _tmp326_;
					_tmp324_ = self->priv->current;
					_tmp325_ = _tmp324_->closure_parameters;
					_tmp326_ = closure_idx;
					vala_collection_add ((ValaCollection*) _tmp325_, (gpointer) ((gintptr) _tmp326_));
				}
			}
			_tmp327_ = destroy_idx;
			if (_tmp327_ != -1) {
				gboolean _tmp328_ = FALSE;
				gint _tmp329_;
				ValaGirParserNode* _tmp333_;
				ValaArrayList* _tmp334_;
				gint _tmp335_;
				_tmp329_ = instance_idx;
				if (_tmp329_ > -2) {
					gint _tmp330_;
					gint _tmp331_;
					_tmp330_ = instance_idx;
					_tmp331_ = destroy_idx;
					_tmp328_ = _tmp330_ < _tmp331_;
				} else {
					_tmp328_ = FALSE;
				}
				if (_tmp328_) {
					gint _tmp332_;
					_tmp332_ = destroy_idx;
					destroy_idx = _tmp332_ - 1;
				}
				_tmp333_ = self->priv->current;
				_tmp334_ = _tmp333_->destroy_parameters;
				_tmp335_ = current_parameter_idx;
				if (vala_list_index_of ((ValaList*) _tmp334_, (gpointer) ((gintptr) _tmp335_)) < 0) {
					ValaGirParserNode* _tmp336_;
					ValaArrayList* _tmp337_;
					gint _tmp338_;
					_tmp336_ = self->priv->current;
					_tmp337_ = _tmp336_->destroy_parameters;
					_tmp338_ = destroy_idx;
					vala_collection_add ((ValaCollection*) _tmp337_, (gpointer) ((gintptr) _tmp338_));
				}
			}
			_tmp339_ = param_comment;
			if (_tmp339_ != NULL) {
				ValaGirComment* _tmp340_;
				const gchar* _tmp347_ = NULL;
				ValaParameter* _tmp348_;
				gboolean _tmp349_;
				gboolean _tmp350_;
				ValaGirComment* _tmp354_;
				ValaComment* _tmp355_;
				_tmp340_ = comment;
				if (_tmp340_ == NULL) {
					ValaSymbol* _tmp341_;
					ValaSourceReference* _tmp342_;
					ValaSourceReference* _tmp343_;
					ValaGirComment* _tmp344_;
					ValaSymbol* _tmp345_;
					ValaGirComment* _tmp346_;
					_tmp341_ = s;
					_tmp342_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp341_);
					_tmp343_ = _tmp342_;
					_tmp344_ = vala_gir_comment_new (NULL, _tmp343_);
					_vala_comment_unref0 (comment);
					comment = _tmp344_;
					_tmp345_ = s;
					_tmp346_ = comment;
					vala_symbol_set_comment (_tmp345_, (ValaComment*) _tmp346_);
				}
				_tmp348_ = param;
				_tmp349_ = vala_parameter_get_ellipsis (_tmp348_);
				_tmp350_ = _tmp349_;
				if (_tmp350_) {
					_tmp347_ = "...";
				} else {
					ValaParameter* _tmp351_;
					const gchar* _tmp352_;
					const gchar* _tmp353_;
					_tmp351_ = param;
					_tmp352_ = vala_symbol_get_name ((ValaSymbol*) _tmp351_);
					_tmp353_ = _tmp352_;
					_tmp347_ = _tmp353_;
				}
				_tmp354_ = comment;
				_tmp355_ = param_comment;
				vala_gir_comment_add_content_for_parameter (_tmp354_, _tmp347_, _tmp355_);
			}
			_tmp356_ = param;
			_tmp357_ = array_length_idx;
			_tmp358_ = closure_idx;
			_tmp359_ = destroy_idx;
			_tmp360_ = scope;
			_tmp361_ = vala_gir_parser_parameter_info_new (_tmp356_, _tmp357_, _tmp358_, _tmp359_, g_strcmp0 (_tmp360_, "async") == 0);
			info = _tmp361_;
			_tmp362_ = parameters;
			_tmp363_ = info;
			vala_collection_add ((ValaCollection*) _tmp362_, _tmp363_);
			vala_gir_parser_pop_metadata (self);
			_vala_gir_parser_parameter_info_unref0 (info);
			_vala_code_node_unref0 (param);
			_vala_comment_unref0 (param_comment);
			_g_free0 (default_param_name);
			_g_free0 (scope);
		}
		vala_gir_parser_end_element (self, "parameters");
	}
	_tmp364_ = self->priv->current;
	_tmp365_ = parameters;
	_tmp366_ = _vala_iterable_ref0 ((ValaList*) _tmp365_);
	_vala_iterable_unref0 (_tmp364_->parameters);
	_tmp364_->parameters = _tmp366_;
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (array_type);
	_vala_code_node_unref0 (s);
	_g_free0 (return_ctype);
	_vala_code_node_unref0 (return_type);
	_vala_comment_unref0 (comment);
	_g_free0 (invoker);
	_g_free0 (throws_string);
	_g_free0 (name);
	_g_free0 (ctype);
	_g_free0 (symbol_type);
}


static void
vala_gir_parser_parse_method (ValaGirParser* self,
                              const gchar* element_name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_parse_function (self, element_name);
}


static void
vala_gir_parser_parse_signal (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	vala_gir_parser_parse_function (self, "glib:signal");
}


static void
vala_gir_parser_parse_boxed (ValaGirParser* self,
                             const gchar* element_name)
{
	gchar* name = NULL;
	ValaMarkupReader* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaClass* cl = NULL;
	gboolean require_copy_free = FALSE;
	ValaGirParserNode* _tmp8_;
	gboolean _tmp9_;
	ValaClass* _tmp22_;
	ValaClass* _tmp23_;
	ValaClass* _tmp24_;
	ValaClass* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	ValaClass* _tmp36_;
	ValaGirComment* _tmp37_;
	ValaGirComment* _tmp38_;
	ValaGirParserNode* ref_method = NULL;
	ValaGirParserNode* unref_method = NULL;
	gboolean _tmp83_ = FALSE;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp85_ = FALSE;
	ValaClass* _tmp86_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element_name != NULL);
	vala_gir_parser_start_element (self, element_name);
	_tmp0_ = self->priv->reader;
	_tmp1_ = vala_markup_reader_get_attribute (_tmp0_, "name");
	name = _tmp1_;
	_tmp2_ = name;
	if (_tmp2_ == NULL) {
		ValaMarkupReader* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->priv->reader;
		_tmp4_ = vala_markup_reader_get_attribute (_tmp3_, "glib:name");
		_g_free0 (name);
		name = _tmp4_;
	}
	_tmp5_ = name;
	_tmp6_ = vala_gir_parser_element_get_name (self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_gir_parser_push_node (self, _tmp7_, TRUE);
	_g_free0 (_tmp7_);
	require_copy_free = FALSE;
	_tmp8_ = self->priv->current;
	_tmp9_ = _tmp8_->new_symbol;
	if (_tmp9_) {
		ValaGirParserNode* _tmp10_;
		const gchar* _tmp11_;
		ValaGirParserNode* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaClass* _tmp14_;
		ValaClass* _tmp15_;
		ValaGirParserNode* _tmp16_;
		ValaClass* _tmp17_;
		ValaSymbol* _tmp18_;
		_tmp10_ = self->priv->current;
		_tmp11_ = _tmp10_->name;
		_tmp12_ = self->priv->current;
		_tmp13_ = _tmp12_->source_reference;
		_tmp14_ = vala_class_new (_tmp11_, _tmp13_, NULL);
		_vala_code_node_unref0 (cl);
		cl = _tmp14_;
		_tmp15_ = cl;
		vala_class_set_is_compact (_tmp15_, TRUE);
		_tmp16_ = self->priv->current;
		_tmp17_ = cl;
		_tmp18_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp17_);
		_vala_code_node_unref0 (_tmp16_->symbol);
		_tmp16_->symbol = _tmp18_;
	} else {
		ValaGirParserNode* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaClass* _tmp21_;
		_tmp19_ = self->priv->current;
		_tmp20_ = _tmp19_->symbol;
		_tmp21_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_CLASS, ValaClass));
		_vala_code_node_unref0 (cl);
		cl = _tmp21_;
	}
	_tmp22_ = cl;
	vala_gir_parser_set_type_id_ccode (self, (ValaSymbol*) _tmp22_);
	_tmp23_ = cl;
	require_copy_free = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp23_, "CCode", "type_id");
	_tmp24_ = cl;
	vala_symbol_set_access ((ValaSymbol*) _tmp24_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp25_ = cl;
	vala_symbol_set_external ((ValaSymbol*) _tmp25_, TRUE);
	_tmp26_ = self->priv->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp26_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE)) {
		ValaClass* _tmp27_;
		ValaGirParserMetadata* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		ValaGirParserMetadata* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		_tmp27_ = cl;
		_tmp28_ = self->priv->metadata;
		_tmp29_ = vala_gir_parser_metadata_get_string (_tmp28_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp30_ = _tmp29_;
		_tmp31_ = self->priv->metadata;
		_tmp32_ = vala_gir_parser_metadata_get_source_reference (_tmp31_, VALA_GIR_PARSER_ARGUMENT_TYPE_BASE_TYPE);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_gir_parser_parse_type_from_string (self, _tmp30_, TRUE, _tmp33_);
		_tmp35_ = _tmp34_;
		vala_class_add_base_type (_tmp27_, _tmp35_);
		_vala_code_node_unref0 (_tmp35_);
		_vala_source_reference_unref0 (_tmp33_);
		_g_free0 (_tmp30_);
	}
	vala_gir_parser_next (self);
	_tmp36_ = cl;
	_tmp37_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp38_ = _tmp37_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp36_, (ValaComment*) _tmp38_);
	_vala_comment_unref0 (_tmp38_);
	ref_method = NULL;
	unref_method = NULL;
	while (TRUE) {
		ValaMarkupTokenType _tmp39_;
		ValaMarkupReader* _tmp40_;
		const gchar* _tmp41_;
		const gchar* _tmp42_;
		_tmp39_ = self->priv->current_token;
		if (!(_tmp39_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp40_ = self->priv->reader;
		_tmp41_ = vala_markup_reader_get_name (_tmp40_);
		_tmp42_ = _tmp41_;
		if (g_strcmp0 (_tmp42_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp43_;
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			_tmp43_ = self->priv->reader;
			_tmp44_ = vala_markup_reader_get_name (_tmp43_);
			_tmp45_ = _tmp44_;
			if (g_strcmp0 (_tmp45_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp46_;
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				_tmp46_ = self->priv->reader;
				_tmp47_ = vala_markup_reader_get_name (_tmp46_);
				_tmp48_ = _tmp47_;
				if (g_strcmp0 (_tmp48_, "method") == 0) {
					gchar* cname = NULL;
					ValaGirParserNode* _tmp49_;
					gchar* _tmp50_;
					gboolean _tmp51_ = FALSE;
					const gchar* _tmp52_;
					vala_gir_parser_parse_method (self, "method");
					_tmp49_ = self->priv->old_current;
					_tmp50_ = vala_gir_parser_node_get_cname (_tmp49_);
					cname = _tmp50_;
					_tmp52_ = cname;
					if (g_str_has_suffix (_tmp52_, "_ref")) {
						gboolean _tmp53_ = FALSE;
						ValaGirParserNode* _tmp54_;
						_tmp54_ = ref_method;
						if (_tmp54_ == NULL) {
							_tmp53_ = TRUE;
						} else {
							ValaGirParserNode* _tmp55_;
							const gchar* _tmp56_;
							_tmp55_ = self->priv->old_current;
							_tmp56_ = _tmp55_->name;
							_tmp53_ = g_strcmp0 (_tmp56_, "ref") == 0;
						}
						_tmp51_ = _tmp53_;
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						ValaGirParserNode* _tmp57_;
						ValaGirParserNode* _tmp58_;
						_tmp57_ = self->priv->old_current;
						_tmp58_ = _vala_gir_parser_node_ref0 (_tmp57_);
						_vala_gir_parser_node_unref0 (ref_method);
						ref_method = _tmp58_;
					} else {
						gboolean _tmp59_ = FALSE;
						const gchar* _tmp60_;
						_tmp60_ = cname;
						if (g_str_has_suffix (_tmp60_, "_unref")) {
							gboolean _tmp61_ = FALSE;
							ValaGirParserNode* _tmp62_;
							_tmp62_ = unref_method;
							if (_tmp62_ == NULL) {
								_tmp61_ = TRUE;
							} else {
								ValaGirParserNode* _tmp63_;
								const gchar* _tmp64_;
								_tmp63_ = self->priv->old_current;
								_tmp64_ = _tmp63_->name;
								_tmp61_ = g_strcmp0 (_tmp64_, "unref") == 0;
							}
							_tmp59_ = _tmp61_;
						} else {
							_tmp59_ = FALSE;
						}
						if (_tmp59_) {
							ValaGirParserNode* _tmp65_;
							ValaGirParserNode* _tmp66_;
							_tmp65_ = self->priv->old_current;
							_tmp66_ = _vala_gir_parser_node_ref0 (_tmp65_);
							_vala_gir_parser_node_unref0 (unref_method);
							unref_method = _tmp66_;
						}
					}
					_g_free0 (cname);
				} else {
					ValaMarkupReader* _tmp67_;
					const gchar* _tmp68_;
					const gchar* _tmp69_;
					_tmp67_ = self->priv->reader;
					_tmp68_ = vala_markup_reader_get_name (_tmp67_);
					_tmp69_ = _tmp68_;
					if (g_strcmp0 (_tmp69_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp70_;
						const gchar* _tmp71_;
						const gchar* _tmp72_;
						_tmp70_ = self->priv->reader;
						_tmp71_ = vala_markup_reader_get_name (_tmp70_);
						_tmp72_ = _tmp71_;
						if (g_strcmp0 (_tmp72_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp73_;
							const gchar* _tmp74_;
							const gchar* _tmp75_;
							_tmp73_ = self->priv->reader;
							_tmp74_ = vala_markup_reader_get_name (_tmp73_);
							_tmp75_ = _tmp74_;
							if (g_strcmp0 (_tmp75_, "union") == 0) {
								vala_gir_parser_parse_union (self);
							} else {
								ValaSourceReference* _tmp76_;
								ValaSourceReference* _tmp77_;
								ValaMarkupReader* _tmp78_;
								const gchar* _tmp79_;
								const gchar* _tmp80_;
								gchar* _tmp81_;
								gchar* _tmp82_;
								_tmp76_ = vala_gir_parser_get_current_src (self);
								_tmp77_ = _tmp76_;
								_tmp78_ = self->priv->reader;
								_tmp79_ = vala_markup_reader_get_name (_tmp78_);
								_tmp80_ = _tmp79_;
								_tmp81_ = g_strdup_printf ("unknown child element `%s' in `class'", _tmp80_);
								_tmp82_ = _tmp81_;
								vala_report_error (_tmp77_, _tmp82_);
								_g_free0 (_tmp82_);
								_vala_source_reference_unref0 (_tmp77_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	_tmp86_ = cl;
	if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp86_, "CCode", "ref_function")) {
		_tmp85_ = TRUE;
	} else {
		ValaClass* _tmp87_;
		_tmp87_ = cl;
		_tmp85_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp87_, "CCode", "unref_function");
	}
	if (_tmp85_) {
		_tmp84_ = TRUE;
	} else {
		ValaClass* _tmp88_;
		_tmp88_ = cl;
		_tmp84_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp88_, "CCode", "copy_function");
	}
	if (_tmp84_) {
		_tmp83_ = TRUE;
	} else {
		ValaClass* _tmp89_;
		_tmp89_ = cl;
		_tmp83_ = vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp89_, "CCode", "free_function");
	}
	if (_tmp83_) {
	} else {
		gboolean _tmp90_ = FALSE;
		ValaGirParserNode* _tmp91_;
		_tmp91_ = ref_method;
		if (_tmp91_ != NULL) {
			ValaGirParserNode* _tmp92_;
			_tmp92_ = unref_method;
			_tmp90_ = _tmp92_ != NULL;
		} else {
			_tmp90_ = FALSE;
		}
		if (_tmp90_) {
			ValaClass* _tmp93_;
			ValaGirParserNode* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			ValaClass* _tmp97_;
			ValaGirParserNode* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp93_ = cl;
			_tmp94_ = ref_method;
			_tmp95_ = vala_gir_parser_node_get_cname (_tmp94_);
			_tmp96_ = _tmp95_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp93_, "CCode", "ref_function", _tmp96_, NULL);
			_g_free0 (_tmp96_);
			_tmp97_ = cl;
			_tmp98_ = unref_method;
			_tmp99_ = vala_gir_parser_node_get_cname (_tmp98_);
			_tmp100_ = _tmp99_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp97_, "CCode", "unref_function", _tmp100_, NULL);
			_g_free0 (_tmp100_);
		} else {
			gboolean _tmp101_;
			_tmp101_ = require_copy_free;
			if (_tmp101_) {
				ValaClass* _tmp102_;
				ValaClass* _tmp103_;
				_tmp102_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp102_, "CCode", "copy_function", "g_boxed_copy", NULL);
				_tmp103_ = cl;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp103_, "CCode", "free_function", "g_boxed_free", NULL);
			}
		}
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, element_name);
	_vala_gir_parser_node_unref0 (unref_method);
	_vala_gir_parser_node_unref0 (ref_method);
	_vala_code_node_unref0 (cl);
	_g_free0 (name);
}


static void
vala_gir_parser_parse_union (ValaGirParser* self)
{
	gchar* element_name = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp15_;
	ValaStruct* st = NULL;
	ValaGirParserNode* _tmp16_;
	gboolean _tmp17_;
	ValaStruct* _tmp30_;
	ValaStruct* _tmp31_;
	ValaStruct* _tmp32_;
	ValaGirComment* _tmp33_;
	ValaGirComment* _tmp34_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "union");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	element_name = _tmp0_;
	_tmp1_ = element_name;
	if (_tmp1_ == NULL) {
		ValaGirComment* _tmp2_;
		ValaGirComment* _tmp3_;
		vala_gir_parser_next (self);
		_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
		_tmp3_ = _tmp2_;
		_vala_comment_unref0 (_tmp3_);
		while (TRUE) {
			ValaMarkupTokenType _tmp4_;
			ValaMarkupReader* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp4_ = self->priv->current_token;
			if (!(_tmp4_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
				break;
			}
			if (!vala_gir_parser_push_metadata (self)) {
				vala_gir_parser_skip_element (self);
				continue;
			}
			_tmp5_ = self->priv->reader;
			_tmp6_ = vala_markup_reader_get_name (_tmp5_);
			_tmp7_ = _tmp6_;
			if (g_strcmp0 (_tmp7_, "field") == 0) {
				vala_gir_parser_parse_field (self);
			} else {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				ValaMarkupReader* _tmp10_;
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				_tmp8_ = vala_gir_parser_get_current_src (self);
				_tmp9_ = _tmp8_;
				_tmp10_ = self->priv->reader;
				_tmp11_ = vala_markup_reader_get_name (_tmp10_);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("unknown child element `%s' in `transparent union'", _tmp12_);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp9_, _tmp14_);
				_g_free0 (_tmp14_);
				_vala_source_reference_unref0 (_tmp9_);
				vala_gir_parser_skip_element (self);
			}
			vala_gir_parser_pop_metadata (self);
		}
		vala_gir_parser_end_element (self, "union");
		_g_free0 (element_name);
		return;
	}
	_tmp15_ = element_name;
	vala_gir_parser_push_node (self, _tmp15_, TRUE);
	_tmp16_ = self->priv->current;
	_tmp17_ = _tmp16_->new_symbol;
	if (_tmp17_) {
		ValaMarkupReader* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		ValaGirParserNode* _tmp21_;
		ValaSourceReference* _tmp22_;
		ValaStruct* _tmp23_;
		ValaGirParserNode* _tmp24_;
		ValaStruct* _tmp25_;
		ValaSymbol* _tmp26_;
		_tmp18_ = self->priv->reader;
		_tmp19_ = vala_markup_reader_get_attribute (_tmp18_, "name");
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->current;
		_tmp22_ = _tmp21_->source_reference;
		_tmp23_ = vala_struct_new (_tmp20_, _tmp22_, NULL);
		_vala_code_node_unref0 (st);
		st = _tmp23_;
		_g_free0 (_tmp20_);
		_tmp24_ = self->priv->current;
		_tmp25_ = st;
		_tmp26_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp25_);
		_vala_code_node_unref0 (_tmp24_->symbol);
		_tmp24_->symbol = _tmp26_;
	} else {
		ValaGirParserNode* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaStruct* _tmp29_;
		_tmp27_ = self->priv->current;
		_tmp28_ = _tmp27_->symbol;
		_tmp29_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, VALA_TYPE_STRUCT, ValaStruct));
		_vala_code_node_unref0 (st);
		st = _tmp29_;
	}
	_tmp30_ = st;
	vala_symbol_set_access ((ValaSymbol*) _tmp30_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp31_ = st;
	vala_symbol_set_external ((ValaSymbol*) _tmp31_, TRUE);
	vala_gir_parser_next (self);
	_tmp32_ = st;
	_tmp33_ = vala_gir_parser_parse_symbol_doc (self);
	_tmp34_ = _tmp33_;
	vala_symbol_set_comment ((ValaSymbol*) _tmp32_, (ValaComment*) _tmp34_);
	_vala_comment_unref0 (_tmp34_);
	while (TRUE) {
		ValaMarkupTokenType _tmp35_;
		ValaMarkupReader* _tmp36_;
		const gchar* _tmp37_;
		const gchar* _tmp38_;
		_tmp35_ = self->priv->current_token;
		if (!(_tmp35_ == VALA_MARKUP_TOKEN_TYPE_START_ELEMENT)) {
			break;
		}
		if (!vala_gir_parser_push_metadata (self)) {
			vala_gir_parser_skip_element (self);
			continue;
		}
		_tmp36_ = self->priv->reader;
		_tmp37_ = vala_markup_reader_get_name (_tmp36_);
		_tmp38_ = _tmp37_;
		if (g_strcmp0 (_tmp38_, "field") == 0) {
			vala_gir_parser_parse_field (self);
		} else {
			ValaMarkupReader* _tmp39_;
			const gchar* _tmp40_;
			const gchar* _tmp41_;
			_tmp39_ = self->priv->reader;
			_tmp40_ = vala_markup_reader_get_name (_tmp39_);
			_tmp41_ = _tmp40_;
			if (g_strcmp0 (_tmp41_, "constructor") == 0) {
				vala_gir_parser_parse_constructor (self);
			} else {
				ValaMarkupReader* _tmp42_;
				const gchar* _tmp43_;
				const gchar* _tmp44_;
				_tmp42_ = self->priv->reader;
				_tmp43_ = vala_markup_reader_get_name (_tmp42_);
				_tmp44_ = _tmp43_;
				if (g_strcmp0 (_tmp44_, "method") == 0) {
					vala_gir_parser_parse_method (self, "method");
				} else {
					ValaMarkupReader* _tmp45_;
					const gchar* _tmp46_;
					const gchar* _tmp47_;
					_tmp45_ = self->priv->reader;
					_tmp46_ = vala_markup_reader_get_name (_tmp45_);
					_tmp47_ = _tmp46_;
					if (g_strcmp0 (_tmp47_, "function") == 0) {
						vala_gir_parser_skip_element (self);
					} else {
						ValaMarkupReader* _tmp48_;
						const gchar* _tmp49_;
						const gchar* _tmp50_;
						_tmp48_ = self->priv->reader;
						_tmp49_ = vala_markup_reader_get_name (_tmp48_);
						_tmp50_ = _tmp49_;
						if (g_strcmp0 (_tmp50_, "function-macro") == 0) {
							vala_gir_parser_skip_element (self);
						} else {
							ValaMarkupReader* _tmp51_;
							const gchar* _tmp52_;
							const gchar* _tmp53_;
							_tmp51_ = self->priv->reader;
							_tmp52_ = vala_markup_reader_get_name (_tmp51_);
							_tmp53_ = _tmp52_;
							if (g_strcmp0 (_tmp53_, "record") == 0) {
								vala_gir_parser_parse_record (self);
							} else {
								ValaSourceReference* _tmp54_;
								ValaSourceReference* _tmp55_;
								ValaMarkupReader* _tmp56_;
								const gchar* _tmp57_;
								const gchar* _tmp58_;
								gchar* _tmp59_;
								gchar* _tmp60_;
								_tmp54_ = vala_gir_parser_get_current_src (self);
								_tmp55_ = _tmp54_;
								_tmp56_ = self->priv->reader;
								_tmp57_ = vala_markup_reader_get_name (_tmp56_);
								_tmp58_ = _tmp57_;
								_tmp59_ = g_strdup_printf ("unknown child element `%s' in `union'", _tmp58_);
								_tmp60_ = _tmp59_;
								vala_report_error (_tmp55_, _tmp60_);
								_g_free0 (_tmp60_);
								_vala_source_reference_unref0 (_tmp55_);
								vala_gir_parser_skip_element (self);
							}
						}
					}
				}
			}
		}
		vala_gir_parser_pop_metadata (self);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "union");
	_vala_code_node_unref0 (st);
	_g_free0 (element_name);
}


static void
vala_gir_parser_parse_constant (ValaGirParser* self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	ValaGirComment* comment = NULL;
	ValaGirComment* _tmp2_;
	gboolean no_array_length = FALSE;
	gboolean array_null_terminated = FALSE;
	gint array_length_idx = 0;
	ValaDataType* type = NULL;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaConstant* c = NULL;
	ValaGirParserNode* _tmp9_;
	const gchar* _tmp10_;
	ValaDataType* _tmp11_;
	ValaGirParserNode* _tmp12_;
	ValaSourceReference* _tmp13_;
	ValaConstant* _tmp14_;
	ValaGirParserNode* _tmp15_;
	ValaConstant* _tmp16_;
	ValaSymbol* _tmp17_;
	ValaConstant* _tmp18_;
	ValaConstant* _tmp19_;
	ValaGirComment* _tmp20_;
	ValaConstant* _tmp21_;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_;
	gboolean _tmp27_;
	g_return_if_fail (self != NULL);
	vala_gir_parser_start_element (self, "constant");
	_tmp0_ = vala_gir_parser_element_get_name (self, NULL);
	_tmp1_ = _tmp0_;
	vala_gir_parser_push_node (self, _tmp1_, FALSE);
	_g_free0 (_tmp1_);
	vala_gir_parser_next (self);
	_tmp2_ = vala_gir_parser_parse_symbol_doc (self);
	comment = _tmp2_;
	_tmp6_ = vala_gir_parser_parse_type (self, NULL, &_tmp3_, TRUE, &_tmp4_, &_tmp5_);
	array_length_idx = _tmp3_;
	no_array_length = _tmp4_;
	array_null_terminated = _tmp5_;
	type = _tmp6_;
	_tmp7_ = type;
	_tmp8_ = vala_gir_parser_element_get_type (self, _tmp7_, TRUE, &no_array_length, &array_null_terminated, NULL);
	_vala_code_node_unref0 (type);
	type = _tmp8_;
	_tmp9_ = self->priv->current;
	_tmp10_ = _tmp9_->name;
	_tmp11_ = type;
	_tmp12_ = self->priv->current;
	_tmp13_ = _tmp12_->source_reference;
	_tmp14_ = vala_constant_new (_tmp10_, _tmp11_, NULL, _tmp13_, NULL);
	c = _tmp14_;
	_tmp15_ = self->priv->current;
	_tmp16_ = c;
	_tmp17_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp16_);
	_vala_code_node_unref0 (_tmp15_->symbol);
	_tmp15_->symbol = _tmp17_;
	_tmp18_ = c;
	vala_symbol_set_access ((ValaSymbol*) _tmp18_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
	_tmp19_ = c;
	_tmp20_ = comment;
	vala_symbol_set_comment ((ValaSymbol*) _tmp19_, (ValaComment*) _tmp20_);
	_tmp21_ = c;
	vala_symbol_set_external ((ValaSymbol*) _tmp21_, TRUE);
	_tmp23_ = no_array_length;
	if (_tmp23_) {
		_tmp22_ = TRUE;
	} else {
		gboolean _tmp24_;
		_tmp24_ = array_null_terminated;
		_tmp22_ = _tmp24_;
	}
	if (_tmp22_) {
		ValaConstant* _tmp25_;
		gboolean _tmp26_;
		_tmp25_ = c;
		_tmp26_ = no_array_length;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp25_, "CCode", "array_length", !_tmp26_, NULL);
	}
	_tmp27_ = array_null_terminated;
	if (_tmp27_) {
		ValaConstant* _tmp28_;
		_tmp28_ = c;
		vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp28_, "CCode", "array_null_terminated", TRUE, NULL);
	}
	vala_gir_parser_pop_node (self);
	vala_gir_parser_end_element (self, "constant");
	_vala_code_node_unref0 (c);
	_vala_code_node_unref0 (type);
	_vala_comment_unref0 (comment);
}


static void
vala_gir_parser_report_unused_metadata (ValaGirParser* self,
                                        ValaGirParserMetadata* metadata)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaMap* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	if (metadata == _tmp1_) {
		return;
	}
	_tmp3_ = metadata->args;
	_tmp4_ = vala_map_get_size (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		ValaArrayList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		_tmp6_ = metadata->children;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp9_;
		_tmp9_ = metadata->source_reference;
		vala_report_warning (_tmp9_, "empty metadata");
		return;
	}
	{
		ValaIterator* _arg_type_it = NULL;
		ValaMap* _tmp10_;
		ValaSet* _tmp11_;
		ValaSet* _tmp12_;
		ValaIterator* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp10_ = metadata->args;
		_tmp11_ = vala_map_get_keys (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_tmp14_ = _tmp13_;
		_vala_iterable_unref0 (_tmp12_);
		_arg_type_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaGirParserArgumentType arg_type = 0;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaGirParserArgument* arg = NULL;
			ValaMap* _tmp18_;
			ValaGirParserArgumentType _tmp19_;
			gpointer _tmp20_;
			ValaGirParserArgument* _tmp21_;
			gboolean _tmp22_;
			_tmp15_ = _arg_type_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _arg_type_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			arg_type = (ValaGirParserArgumentType) ((gintptr) _tmp17_);
			_tmp18_ = metadata->args;
			_tmp19_ = arg_type;
			_tmp20_ = vala_map_get (_tmp18_, (gpointer) ((gintptr) _tmp19_));
			arg = (ValaGirParserArgument*) _tmp20_;
			_tmp21_ = arg;
			_tmp22_ = _tmp21_->used;
			if (!_tmp22_) {
				ValaGirParserArgument* _tmp23_;
				ValaSourceReference* _tmp24_;
				_tmp23_ = arg;
				_tmp24_ = _tmp23_->source_reference;
				vala_report_warning (_tmp24_, "argument never used");
			}
			_vala_gir_parser_argument_unref0 (arg);
		}
		_vala_iterator_unref0 (_arg_type_it);
	}
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp25_;
		ValaArrayList* _tmp26_;
		gint _child_size = 0;
		ValaArrayList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		gint _child_index = 0;
		_tmp25_ = metadata->children;
		_tmp26_ = _vala_iterable_ref0 (_tmp25_);
		_child_list = _tmp26_;
		_tmp27_ = _child_list;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_child_size = _tmp29_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp30_;
			gint _tmp31_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ValaGirParserMetadata* _tmp35_;
			gboolean _tmp36_;
			_child_index = _child_index + 1;
			_tmp30_ = _child_index;
			_tmp31_ = _child_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _child_list;
			_tmp33_ = _child_index;
			_tmp34_ = vala_list_get ((ValaList*) _tmp32_, _tmp33_);
			child = (ValaGirParserMetadata*) _tmp34_;
			_tmp35_ = child;
			_tmp36_ = _tmp35_->used;
			if (!_tmp36_) {
				ValaGirParserMetadata* _tmp37_;
				ValaSourceReference* _tmp38_;
				_tmp37_ = child;
				_tmp38_ = _tmp37_->source_reference;
				vala_report_warning (_tmp38_, "metadata never used");
			} else {
				ValaGirParserMetadata* _tmp39_;
				_tmp39_ = child;
				vala_gir_parser_report_unused_metadata (self, _tmp39_);
			}
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
}


static void
vala_gir_parser_resolve_gir_symbols (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _map_from_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _map_from_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _map_from_index = 0;
		_tmp0_ = self->priv->unresolved_gir_symbols;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_map_from_list = _tmp1_;
		_tmp2_ = _map_from_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_map_from_size = _tmp4_;
		_map_from_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaUnresolvedSymbol* map_from = NULL;
			ValaArrayList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			_map_from_index = _map_from_index + 1;
			_tmp5_ = _map_from_index;
			_tmp6_ = _map_from_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _map_from_list;
			_tmp8_ = _map_from_index;
			_tmp9_ = vala_list_get ((ValaList*) _tmp7_, _tmp8_);
			map_from = (ValaUnresolvedSymbol*) _tmp9_;
			while (TRUE) {
				ValaUnresolvedSymbol* _tmp10_;
				ValaSymbol* map_to = NULL;
				ValaHashMap* _tmp11_;
				ValaUnresolvedSymbol* _tmp12_;
				gpointer _tmp13_;
				ValaSymbol* _tmp14_;
				ValaUnresolvedSymbol* _tmp64_;
				ValaUnresolvedSymbol* _tmp65_;
				ValaUnresolvedSymbol* _tmp66_;
				ValaUnresolvedSymbol* _tmp67_;
				_tmp10_ = map_from;
				if (!(_tmp10_ != NULL)) {
					break;
				}
				_tmp11_ = self->priv->unresolved_symbols_map;
				_tmp12_ = map_from;
				_tmp13_ = vala_map_get ((ValaMap*) _tmp11_, _tmp12_);
				map_to = (ValaSymbol*) _tmp13_;
				_tmp14_ = map_to;
				if (_tmp14_ != NULL) {
					ValaUnresolvedSymbol* _tmp15_;
					ValaUnresolvedSymbol* _tmp16_;
					ValaSymbol* _tmp17_;
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					ValaSymbol* _tmp20_;
					_tmp15_ = map_from;
					vala_unresolved_symbol_set_inner (_tmp15_, NULL);
					_tmp16_ = map_from;
					_tmp17_ = map_to;
					_tmp18_ = vala_symbol_get_name (_tmp17_);
					_tmp19_ = _tmp18_;
					vala_symbol_set_name ((ValaSymbol*) _tmp16_, _tmp19_);
					_tmp20_ = map_to;
					if (VALA_IS_UNRESOLVED_SYMBOL (_tmp20_)) {
						ValaUnresolvedSymbol* umap_to = NULL;
						ValaSymbol* _tmp21_;
						ValaUnresolvedSymbol* _tmp22_;
						_tmp21_ = map_to;
						_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_UNRESOLVED_SYMBOL, ValaUnresolvedSymbol));
						umap_to = _tmp22_;
						while (TRUE) {
							ValaUnresolvedSymbol* _tmp23_;
							ValaUnresolvedSymbol* _tmp24_;
							ValaUnresolvedSymbol* _tmp25_;
							ValaUnresolvedSymbol* _tmp26_;
							ValaUnresolvedSymbol* _tmp27_;
							ValaUnresolvedSymbol* _tmp28_;
							ValaUnresolvedSymbol* _tmp29_;
							ValaUnresolvedSymbol* _tmp30_;
							ValaUnresolvedSymbol* _tmp31_;
							const gchar* _tmp32_;
							const gchar* _tmp33_;
							ValaUnresolvedSymbol* _tmp34_;
							ValaUnresolvedSymbol* _tmp35_;
							ValaUnresolvedSymbol* _tmp36_;
							ValaUnresolvedSymbol* _tmp37_;
							ValaUnresolvedSymbol* _tmp38_;
							ValaUnresolvedSymbol* _tmp39_;
							_tmp23_ = umap_to;
							_tmp24_ = vala_unresolved_symbol_get_inner (_tmp23_);
							_tmp25_ = _tmp24_;
							if (!(_tmp25_ != NULL)) {
								break;
							}
							_tmp26_ = umap_to;
							_tmp27_ = vala_unresolved_symbol_get_inner (_tmp26_);
							_tmp28_ = _tmp27_;
							_tmp29_ = _vala_code_node_ref0 (_tmp28_);
							_vala_code_node_unref0 (umap_to);
							umap_to = _tmp29_;
							_tmp30_ = map_from;
							_tmp31_ = umap_to;
							_tmp32_ = vala_symbol_get_name ((ValaSymbol*) _tmp31_);
							_tmp33_ = _tmp32_;
							_tmp34_ = vala_unresolved_symbol_new (NULL, _tmp33_, NULL);
							_tmp35_ = _tmp34_;
							vala_unresolved_symbol_set_inner (_tmp30_, _tmp35_);
							_vala_code_node_unref0 (_tmp35_);
							_tmp36_ = map_from;
							_tmp37_ = vala_unresolved_symbol_get_inner (_tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = _vala_code_node_ref0 (_tmp38_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp39_;
						}
						_vala_code_node_unref0 (umap_to);
					} else {
						while (TRUE) {
							gboolean _tmp40_ = FALSE;
							ValaSymbol* _tmp41_;
							ValaSymbol* _tmp42_;
							ValaSymbol* _tmp43_;
							ValaSymbol* _tmp50_;
							ValaSymbol* _tmp51_;
							ValaSymbol* _tmp52_;
							ValaSymbol* _tmp53_;
							ValaUnresolvedSymbol* _tmp54_;
							ValaSymbol* _tmp55_;
							const gchar* _tmp56_;
							const gchar* _tmp57_;
							ValaUnresolvedSymbol* _tmp58_;
							ValaUnresolvedSymbol* _tmp59_;
							ValaUnresolvedSymbol* _tmp60_;
							ValaUnresolvedSymbol* _tmp61_;
							ValaUnresolvedSymbol* _tmp62_;
							ValaUnresolvedSymbol* _tmp63_;
							_tmp41_ = map_to;
							_tmp42_ = vala_symbol_get_parent_symbol (_tmp41_);
							_tmp43_ = _tmp42_;
							if (_tmp43_ != NULL) {
								ValaSymbol* _tmp44_;
								ValaSymbol* _tmp45_;
								ValaSymbol* _tmp46_;
								ValaCodeContext* _tmp47_;
								ValaNamespace* _tmp48_;
								ValaNamespace* _tmp49_;
								_tmp44_ = map_to;
								_tmp45_ = vala_symbol_get_parent_symbol (_tmp44_);
								_tmp46_ = _tmp45_;
								_tmp47_ = self->priv->context;
								_tmp48_ = vala_code_context_get_root (_tmp47_);
								_tmp49_ = _tmp48_;
								_tmp40_ = _tmp46_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp49_, VALA_TYPE_SYMBOL, ValaSymbol);
							} else {
								_tmp40_ = FALSE;
							}
							if (!_tmp40_) {
								break;
							}
							_tmp50_ = map_to;
							_tmp51_ = vala_symbol_get_parent_symbol (_tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = _vala_code_node_ref0 (_tmp52_);
							_vala_code_node_unref0 (map_to);
							map_to = _tmp53_;
							_tmp54_ = map_from;
							_tmp55_ = map_to;
							_tmp56_ = vala_symbol_get_name (_tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = vala_unresolved_symbol_new (NULL, _tmp57_, NULL);
							_tmp59_ = _tmp58_;
							vala_unresolved_symbol_set_inner (_tmp54_, _tmp59_);
							_vala_code_node_unref0 (_tmp59_);
							_tmp60_ = map_from;
							_tmp61_ = vala_unresolved_symbol_get_inner (_tmp60_);
							_tmp62_ = _tmp61_;
							_tmp63_ = _vala_code_node_ref0 (_tmp62_);
							_vala_code_node_unref0 (map_from);
							map_from = _tmp63_;
						}
					}
					_vala_code_node_unref0 (map_to);
					break;
				}
				_tmp64_ = map_from;
				_tmp65_ = vala_unresolved_symbol_get_inner (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = _vala_code_node_ref0 (_tmp66_);
				_vala_code_node_unref0 (map_from);
				map_from = _tmp67_;
				_vala_code_node_unref0 (map_to);
			}
			_vala_code_node_unref0 (map_from);
		}
		_vala_iterable_unref0 (_map_from_list);
	}
}


static void
vala_gir_parser_create_new_namespaces (ValaGirParser* self)
{
	g_return_if_fail (self != NULL);
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _node_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _node_index = 0;
		_tmp0_ = vala_gir_parser_node_new_namespaces;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_node_list = _tmp1_;
		_tmp2_ = _node_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_node_size = _tmp4_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaGirParserNode* _tmp10_;
			ValaSymbol* _tmp11_;
			_node_index = _node_index + 1;
			_tmp5_ = _node_index;
			_tmp6_ = _node_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _node_list;
			_tmp8_ = _node_index;
			_tmp9_ = vala_list_get ((ValaList*) _tmp7_, _tmp8_);
			node = (ValaGirParserNode*) _tmp9_;
			_tmp10_ = node;
			_tmp11_ = _tmp10_->symbol;
			if (_tmp11_ == NULL) {
				ValaGirParserNode* _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				ValaGirParserNode* _tmp15_;
				ValaSourceReference* _tmp16_;
				ValaNamespace* _tmp17_;
				_tmp12_ = node;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->name;
				_tmp15_ = node;
				_tmp16_ = _tmp15_->source_reference;
				_tmp17_ = vala_namespace_new (_tmp14_, _tmp16_);
				_vala_code_node_unref0 (_tmp12_->symbol);
				_tmp12_->symbol = (ValaSymbol*) _tmp17_;
			}
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static void
vala_gir_parser_resolve_type_arguments (ValaGirParser* self)
{
	ValaMapIterator* it = NULL;
	ValaHashMap* _tmp0_;
	ValaMapIterator* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unresolved_type_arguments;
	_tmp1_ = vala_map_map_iterator ((ValaMap*) _tmp0_);
	it = _tmp1_;
	while (TRUE) {
		ValaMapIterator* _tmp2_;
		ValaUnresolvedType* element_type = NULL;
		ValaMapIterator* _tmp3_;
		gpointer _tmp4_;
		ValaGirParserNode* parent = NULL;
		ValaMapIterator* _tmp5_;
		gpointer _tmp6_;
		ValaTypeSymbol* sym = NULL;
		ValaGirParserNode* _tmp7_;
		ValaUnresolvedType* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		ValaUnresolvedSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaStruct* st = NULL;
		ValaTypeSymbol* _tmp12_;
		ValaStruct* _tmp13_;
		gboolean _tmp14_ = FALSE;
		gboolean _tmp15_ = FALSE;
		ValaStruct* _tmp16_;
		_tmp2_ = it;
		if (!vala_map_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = it;
		_tmp4_ = vala_map_iterator_get_key (_tmp3_);
		element_type = (ValaUnresolvedType*) _tmp4_;
		_tmp5_ = it;
		_tmp6_ = vala_map_iterator_get_value (_tmp5_);
		parent = (ValaGirParserNode*) _tmp6_;
		_tmp7_ = parent;
		_tmp8_ = element_type;
		_tmp9_ = vala_unresolved_type_get_unresolved_symbol (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_gir_parser_resolve_symbol (self, _tmp7_, _tmp10_);
		sym = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
		_tmp12_ = sym;
		_tmp13_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp12_) ? ((ValaStruct*) _tmp12_) : NULL);
		st = _tmp13_;
		_tmp16_ = st;
		if (_tmp16_ != NULL) {
			ValaStruct* _tmp17_;
			_tmp17_ = st;
			_tmp15_ = !vala_struct_is_integer_type (_tmp17_);
		} else {
			_tmp15_ = FALSE;
		}
		if (_tmp15_) {
			ValaStruct* _tmp18_;
			_tmp18_ = st;
			_tmp14_ = !vala_struct_is_floating_type (_tmp18_);
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaUnresolvedType* _tmp19_;
			_tmp19_ = element_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp19_, TRUE);
		}
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (sym);
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (element_type);
	}
	_vala_map_iterator_unref0 (it);
}


static void
vala_gir_parser_process_interface (ValaGirParser* self,
                                   ValaGirParserNode* iface_node)
{
	ValaInterface* iface = NULL;
	ValaSymbol* _tmp0_;
	ValaInterface* _tmp1_;
	gboolean has_instantiable_prereq = FALSE;
	gboolean _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface_node != NULL);
	_tmp0_ = iface_node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_INTERFACE, ValaInterface));
	iface = _tmp1_;
	has_instantiable_prereq = FALSE;
	{
		ValaList* _prereq_list = NULL;
		ValaInterface* _tmp2_;
		ValaList* _tmp3_;
		gint _prereq_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _prereq_index = 0;
		_tmp2_ = iface;
		_tmp3_ = vala_interface_get_prerequisites (_tmp2_);
		_prereq_list = _tmp3_;
		_tmp4_ = _prereq_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_prereq_size = _tmp6_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaSymbol* sym = NULL;
			ValaDataType* _tmp12_;
			ValaSymbol* _tmp24_;
			_prereq_index = _prereq_index + 1;
			_tmp7_ = _prereq_index;
			_tmp8_ = _prereq_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _prereq_list;
			_tmp10_ = _prereq_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			prereq = (ValaDataType*) _tmp11_;
			sym = NULL;
			_tmp12_ = prereq;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp12_)) {
				ValaUnresolvedSymbol* unresolved_symbol = NULL;
				ValaDataType* _tmp13_;
				ValaUnresolvedSymbol* _tmp14_;
				ValaUnresolvedSymbol* _tmp15_;
				ValaUnresolvedSymbol* _tmp16_;
				ValaGirParserNode* _tmp17_;
				ValaUnresolvedSymbol* _tmp18_;
				ValaSymbol* _tmp19_;
				_tmp13_ = prereq;
				_tmp14_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp15_ = _tmp14_;
				_tmp16_ = _vala_code_node_ref0 (_tmp15_);
				unresolved_symbol = _tmp16_;
				_tmp17_ = iface_node->parent;
				_tmp18_ = unresolved_symbol;
				_tmp19_ = vala_gir_parser_resolve_symbol (self, _tmp17_, _tmp18_);
				_vala_code_node_unref0 (sym);
				sym = _tmp19_;
				_vala_code_node_unref0 (unresolved_symbol);
			} else {
				ValaDataType* _tmp20_;
				ValaTypeSymbol* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaSymbol* _tmp23_;
				_tmp20_ = prereq;
				_tmp21_ = vala_data_type_get_data_type (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
				_vala_code_node_unref0 (sym);
				sym = _tmp23_;
			}
			_tmp24_ = sym;
			if (VALA_IS_CLASS (_tmp24_)) {
				has_instantiable_prereq = TRUE;
				_vala_code_node_unref0 (sym);
				_vala_code_node_unref0 (prereq);
				break;
			}
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp25_ = has_instantiable_prereq;
	if (!_tmp25_) {
		ValaArrayList* _tmp26_;
		ValaInterface* _tmp27_;
		_tmp26_ = self->priv->ifaces_needing_object_prereq;
		_tmp27_ = iface;
		vala_collection_add ((ValaCollection*) _tmp26_, _tmp27_);
	}
	_vala_code_node_unref0 (iface);
}


static void
vala_gir_parser_process_alias (ValaGirParser* self,
                               ValaGirParserNode* alias)
{
	ValaDataType* base_type = NULL;
	ValaSymbol* type_sym = NULL;
	ValaGirParserNode* base_node = NULL;
	gboolean simple_type = FALSE;
	ValaDataType* _tmp0_;
	gboolean _tmp32_ = FALSE;
	ValaSymbol* _tmp33_;
	gboolean _tmp35_ = FALSE;
	gboolean _tmp36_ = FALSE;
	ValaDataType* _tmp37_;
	gboolean _tmp153_ = FALSE;
	ValaSymbol* _tmp154_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (alias != NULL);
	base_type = NULL;
	type_sym = NULL;
	base_node = NULL;
	simple_type = FALSE;
	_tmp0_ = alias->base_type;
	if (VALA_IS_UNRESOLVED_TYPE (_tmp0_)) {
		ValaDataType* _tmp1_;
		ValaDataType* _tmp2_;
		ValaGirParserNode* _tmp3_;
		ValaDataType* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaGirParserNode* _tmp7_;
		ValaGirParserNode* _tmp8_;
		_tmp1_ = alias->base_type;
		_tmp2_ = _vala_code_node_ref0 (_tmp1_);
		_vala_code_node_unref0 (base_type);
		base_type = _tmp2_;
		_tmp3_ = alias->parent;
		_tmp4_ = base_type;
		_tmp5_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_gir_parser_resolve_node (self, _tmp3_, _tmp6_, FALSE);
		_vala_gir_parser_node_unref0 (base_node);
		base_node = _tmp7_;
		_tmp8_ = base_node;
		if (_tmp8_ != NULL) {
			ValaGirParserNode* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSymbol* _tmp11_;
			_tmp9_ = base_node;
			_tmp10_ = _tmp9_->symbol;
			_tmp11_ = _vala_code_node_ref0 (_tmp10_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp11_;
		}
	} else {
		gboolean _tmp12_ = FALSE;
		ValaDataType* _tmp13_;
		_tmp13_ = alias->base_type;
		if (VALA_IS_POINTER_TYPE (_tmp13_)) {
			ValaDataType* _tmp14_;
			ValaDataType* _tmp15_;
			ValaDataType* _tmp16_;
			_tmp14_ = alias->base_type;
			_tmp15_ = vala_pointer_type_get_base_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_POINTER_TYPE, ValaPointerType));
			_tmp16_ = _tmp15_;
			_tmp12_ = VALA_IS_VOID_TYPE (_tmp16_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			simple_type = TRUE;
		} else {
			ValaDataType* _tmp17_;
			ValaDataType* _tmp18_;
			ValaDataType* _tmp19_;
			ValaTypeSymbol* _tmp20_;
			ValaTypeSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp17_ = alias->base_type;
			_tmp18_ = _vala_code_node_ref0 (_tmp17_);
			_vala_code_node_unref0 (base_type);
			base_type = _tmp18_;
			_tmp19_ = base_type;
			_tmp20_ = vala_data_type_get_data_type (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp21_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp22_;
			_tmp23_ = type_sym;
			if (_tmp23_ != NULL) {
				ValaGirParserNode* _tmp24_;
				ValaSymbol* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaUnresolvedSymbol* _tmp29_;
				ValaUnresolvedSymbol* _tmp30_;
				ValaGirParserNode* _tmp31_;
				_tmp24_ = alias->parent;
				_tmp25_ = type_sym;
				_tmp26_ = vala_symbol_get_full_name (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = alias->source_reference;
				_tmp29_ = vala_gir_parser_parse_symbol_from_string (self, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = vala_gir_parser_resolve_node (self, _tmp24_, _tmp30_, FALSE);
				_vala_gir_parser_node_unref0 (base_node);
				base_node = _tmp31_;
				_vala_code_node_unref0 (_tmp30_);
				_g_free0 (_tmp27_);
			}
		}
	}
	_tmp33_ = type_sym;
	if (VALA_IS_STRUCT (_tmp33_)) {
		ValaSymbol* _tmp34_;
		_tmp34_ = type_sym;
		_tmp32_ = vala_struct_is_simple_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, VALA_TYPE_STRUCT, ValaStruct));
	} else {
		_tmp32_ = FALSE;
	}
	if (_tmp32_) {
		simple_type = TRUE;
	}
	_tmp37_ = base_type;
	if (_tmp37_ == NULL) {
		_tmp36_ = TRUE;
	} else {
		ValaSymbol* _tmp38_;
		_tmp38_ = type_sym;
		_tmp36_ = _tmp38_ == NULL;
	}
	if (_tmp36_) {
		_tmp35_ = TRUE;
	} else {
		ValaSymbol* _tmp39_;
		_tmp39_ = type_sym;
		_tmp35_ = VALA_IS_STRUCT (_tmp39_);
	}
	if (_tmp35_) {
		ValaStruct* st = NULL;
		const gchar* _tmp40_;
		ValaSourceReference* _tmp41_;
		ValaStruct* _tmp42_;
		ValaStruct* _tmp43_;
		ValaDataType* _tmp44_;
		ValaStruct* _tmp47_;
		ValaGirComment* _tmp48_;
		ValaStruct* _tmp49_;
		ValaStruct* _tmp50_;
		gboolean _tmp51_;
		ValaStruct* _tmp52_;
		ValaSymbol* _tmp53_;
		_tmp40_ = alias->name;
		_tmp41_ = alias->source_reference;
		_tmp42_ = vala_struct_new (_tmp40_, _tmp41_, NULL);
		st = _tmp42_;
		_tmp43_ = st;
		vala_symbol_set_access ((ValaSymbol*) _tmp43_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
		_tmp44_ = base_type;
		if (_tmp44_ != NULL) {
			ValaStruct* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp45_ = st;
			_tmp46_ = base_type;
			vala_struct_set_base_type (_tmp45_, _tmp46_);
		}
		_tmp47_ = st;
		_tmp48_ = alias->comment;
		vala_symbol_set_comment ((ValaSymbol*) _tmp47_, (ValaComment*) _tmp48_);
		_tmp49_ = st;
		vala_symbol_set_external ((ValaSymbol*) _tmp49_, TRUE);
		_tmp50_ = st;
		_tmp51_ = simple_type;
		vala_struct_set_simple_type (_tmp50_, _tmp51_);
		_tmp52_ = st;
		_tmp53_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp52_);
		_vala_code_node_unref0 (alias->symbol);
		alias->symbol = _tmp53_;
		_vala_code_node_unref0 (st);
	} else {
		ValaSymbol* _tmp54_;
		_tmp54_ = type_sym;
		if (VALA_IS_CLASS (_tmp54_)) {
			ValaClass* cl = NULL;
			const gchar* _tmp55_;
			ValaSourceReference* _tmp56_;
			ValaClass* _tmp57_;
			ValaClass* _tmp58_;
			ValaDataType* _tmp59_;
			ValaClass* _tmp62_;
			ValaGirComment* _tmp63_;
			ValaClass* _tmp64_;
			ValaClass* _tmp65_;
			ValaSymbol* _tmp66_;
			gboolean _tmp67_;
			gboolean _tmp68_;
			ValaClass* _tmp69_;
			ValaSymbol* _tmp70_;
			_tmp55_ = alias->name;
			_tmp56_ = alias->source_reference;
			_tmp57_ = vala_class_new (_tmp55_, _tmp56_, NULL);
			cl = _tmp57_;
			_tmp58_ = cl;
			vala_symbol_set_access ((ValaSymbol*) _tmp58_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
			_tmp59_ = base_type;
			if (_tmp59_ != NULL) {
				ValaClass* _tmp60_;
				ValaDataType* _tmp61_;
				_tmp60_ = cl;
				_tmp61_ = base_type;
				vala_class_add_base_type (_tmp60_, _tmp61_);
			}
			_tmp62_ = cl;
			_tmp63_ = alias->comment;
			vala_symbol_set_comment ((ValaSymbol*) _tmp62_, (ValaComment*) _tmp63_);
			_tmp64_ = cl;
			vala_symbol_set_external ((ValaSymbol*) _tmp64_, TRUE);
			_tmp65_ = cl;
			_tmp66_ = type_sym;
			_tmp67_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_CLASS, ValaClass));
			_tmp68_ = _tmp67_;
			vala_class_set_is_compact (_tmp65_, _tmp68_);
			_tmp69_ = cl;
			_tmp70_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp69_);
			_vala_code_node_unref0 (alias->symbol);
			alias->symbol = _tmp70_;
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp71_;
			_tmp71_ = type_sym;
			if (VALA_IS_INTERFACE (_tmp71_)) {
				ValaInterface* iface = NULL;
				const gchar* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaInterface* _tmp74_;
				ValaInterface* _tmp75_;
				ValaDataType* _tmp76_;
				ValaInterface* _tmp79_;
				ValaGirComment* _tmp80_;
				ValaInterface* _tmp81_;
				ValaInterface* _tmp82_;
				ValaSymbol* _tmp83_;
				_tmp72_ = alias->name;
				_tmp73_ = alias->source_reference;
				_tmp74_ = vala_interface_new (_tmp72_, _tmp73_, NULL);
				iface = _tmp74_;
				_tmp75_ = iface;
				vala_symbol_set_access ((ValaSymbol*) _tmp75_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
				_tmp76_ = base_type;
				if (_tmp76_ != NULL) {
					ValaInterface* _tmp77_;
					ValaDataType* _tmp78_;
					_tmp77_ = iface;
					_tmp78_ = base_type;
					vala_interface_add_prerequisite (_tmp77_, _tmp78_);
				}
				_tmp79_ = iface;
				_tmp80_ = alias->comment;
				vala_symbol_set_comment ((ValaSymbol*) _tmp79_, (ValaComment*) _tmp80_);
				_tmp81_ = iface;
				vala_symbol_set_external ((ValaSymbol*) _tmp81_, TRUE);
				_tmp82_ = iface;
				_tmp83_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp82_);
				_vala_code_node_unref0 (alias->symbol);
				alias->symbol = _tmp83_;
				_vala_code_node_unref0 (iface);
			} else {
				ValaSymbol* _tmp84_;
				_tmp84_ = type_sym;
				if (VALA_IS_DELEGATE (_tmp84_)) {
					ValaDelegate* orig = NULL;
					ValaSymbol* _tmp85_;
					ValaDelegate* _tmp86_;
					ValaGirParserNode* _tmp87_;
					ValaDelegate* deleg = NULL;
					const gchar* _tmp92_;
					ValaDelegate* _tmp93_;
					ValaDataType* _tmp94_;
					ValaDataType* _tmp95_;
					ValaDataType* _tmp96_;
					ValaDataType* _tmp97_;
					ValaSourceReference* _tmp98_;
					ValaDelegate* _tmp99_;
					ValaDelegate* _tmp100_;
					ValaDelegate* _tmp101_;
					ValaDelegate* _tmp102_;
					ValaSymbolAccessibility _tmp103_;
					ValaSymbolAccessibility _tmp104_;
					ValaDelegate* _tmp133_;
					GList* _tmp134_;
					ValaDelegate* _tmp139_;
					ValaDelegate* _tmp140_;
					ValaSymbol* _tmp141_;
					_tmp85_ = type_sym;
					_tmp86_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp85_, VALA_TYPE_DELEGATE, ValaDelegate));
					orig = _tmp86_;
					_tmp87_ = base_node;
					if (_tmp87_ != NULL) {
						ValaGirParserNode* _tmp88_;
						ValaGirParserNode* _tmp89_;
						ValaSymbol* _tmp90_;
						ValaDelegate* _tmp91_;
						_tmp88_ = base_node;
						vala_gir_parser_node_process (_tmp88_, self);
						_tmp89_ = base_node;
						_tmp90_ = _tmp89_->symbol;
						_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (orig);
						orig = _tmp91_;
					}
					_tmp92_ = alias->name;
					_tmp93_ = orig;
					_tmp94_ = vala_callable_get_return_type ((ValaCallable*) _tmp93_);
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_data_type_copy (_tmp95_);
					_tmp97_ = _tmp96_;
					_tmp98_ = alias->source_reference;
					_tmp99_ = vala_delegate_new (_tmp92_, _tmp97_, _tmp98_, NULL);
					_tmp100_ = _tmp99_;
					_vala_code_node_unref0 (_tmp97_);
					deleg = _tmp100_;
					_tmp101_ = deleg;
					_tmp102_ = orig;
					_tmp103_ = vala_symbol_get_access ((ValaSymbol*) _tmp102_);
					_tmp104_ = _tmp103_;
					vala_symbol_set_access ((ValaSymbol*) _tmp101_, _tmp104_);
					{
						ValaList* _param_list = NULL;
						ValaDelegate* _tmp105_;
						ValaList* _tmp106_;
						gint _param_size = 0;
						ValaList* _tmp107_;
						gint _tmp108_;
						gint _tmp109_;
						gint _param_index = 0;
						_tmp105_ = orig;
						_tmp106_ = vala_callable_get_parameters ((ValaCallable*) _tmp105_);
						_param_list = _tmp106_;
						_tmp107_ = _param_list;
						_tmp108_ = vala_collection_get_size ((ValaCollection*) _tmp107_);
						_tmp109_ = _tmp108_;
						_param_size = _tmp109_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp110_;
							gint _tmp111_;
							ValaParameter* param = NULL;
							ValaList* _tmp112_;
							gint _tmp113_;
							gpointer _tmp114_;
							ValaDelegate* _tmp115_;
							ValaParameter* _tmp116_;
							ValaParameter* _tmp117_;
							ValaParameter* _tmp118_;
							_param_index = _param_index + 1;
							_tmp110_ = _param_index;
							_tmp111_ = _param_size;
							if (!(_tmp110_ < _tmp111_)) {
								break;
							}
							_tmp112_ = _param_list;
							_tmp113_ = _param_index;
							_tmp114_ = vala_list_get (_tmp112_, _tmp113_);
							param = (ValaParameter*) _tmp114_;
							_tmp115_ = deleg;
							_tmp116_ = param;
							_tmp117_ = vala_parameter_copy (_tmp116_);
							_tmp118_ = _tmp117_;
							vala_callable_add_parameter ((ValaCallable*) _tmp115_, _tmp118_);
							_vala_code_node_unref0 (_tmp118_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
					{
						ValaList* _error_type_list = NULL;
						ValaDelegate* _tmp119_;
						ValaList* _tmp120_;
						gint _error_type_size = 0;
						ValaList* _tmp121_;
						gint _tmp122_;
						gint _tmp123_;
						gint _error_type_index = 0;
						_tmp119_ = orig;
						_tmp120_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp119_);
						_error_type_list = _tmp120_;
						_tmp121_ = _error_type_list;
						_tmp122_ = vala_collection_get_size ((ValaCollection*) _tmp121_);
						_tmp123_ = _tmp122_;
						_error_type_size = _tmp123_;
						_error_type_index = -1;
						while (TRUE) {
							gint _tmp124_;
							gint _tmp125_;
							ValaDataType* error_type = NULL;
							ValaList* _tmp126_;
							gint _tmp127_;
							gpointer _tmp128_;
							ValaDelegate* _tmp129_;
							ValaDataType* _tmp130_;
							ValaDataType* _tmp131_;
							ValaDataType* _tmp132_;
							_error_type_index = _error_type_index + 1;
							_tmp124_ = _error_type_index;
							_tmp125_ = _error_type_size;
							if (!(_tmp124_ < _tmp125_)) {
								break;
							}
							_tmp126_ = _error_type_list;
							_tmp127_ = _error_type_index;
							_tmp128_ = vala_list_get (_tmp126_, _tmp127_);
							error_type = (ValaDataType*) _tmp128_;
							_tmp129_ = deleg;
							_tmp130_ = error_type;
							_tmp131_ = vala_data_type_copy (_tmp130_);
							_tmp132_ = _tmp131_;
							vala_code_node_add_error_type ((ValaCodeNode*) _tmp129_, _tmp132_);
							_vala_code_node_unref0 (_tmp132_);
							_vala_code_node_unref0 (error_type);
						}
						_vala_iterable_unref0 (_error_type_list);
					}
					_tmp133_ = orig;
					_tmp134_ = ((ValaCodeNode*) _tmp133_)->attributes;
					{
						GList* attribute_collection = NULL;
						GList* attribute_it = NULL;
						attribute_collection = _tmp134_;
						for (attribute_it = attribute_collection; attribute_it != NULL; attribute_it = attribute_it->next) {
							ValaAttribute* _tmp135_;
							ValaAttribute* attribute = NULL;
							_tmp135_ = _vala_code_node_ref0 ((ValaAttribute*) attribute_it->data);
							attribute = _tmp135_;
							{
								ValaDelegate* _tmp136_;
								ValaAttribute* _tmp137_;
								ValaAttribute* _tmp138_;
								_tmp136_ = deleg;
								_tmp137_ = attribute;
								_tmp138_ = _vala_code_node_ref0 (_tmp137_);
								((ValaCodeNode*) _tmp136_)->attributes = g_list_append (((ValaCodeNode*) _tmp136_)->attributes, _tmp138_);
								_vala_code_node_unref0 (attribute);
							}
						}
					}
					_tmp139_ = deleg;
					vala_symbol_set_external ((ValaSymbol*) _tmp139_, TRUE);
					_tmp140_ = deleg;
					_tmp141_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp140_);
					_vala_code_node_unref0 (alias->symbol);
					alias->symbol = _tmp141_;
					_vala_code_node_unref0 (deleg);
					_vala_code_node_unref0 (orig);
				} else {
					ValaSymbol* _tmp142_;
					_tmp142_ = type_sym;
					if (_tmp142_ != NULL) {
						ValaSourceReference* _tmp143_;
						gchar* _tmp144_;
						gchar* _tmp145_;
						ValaSymbol* _tmp146_;
						gchar* _tmp147_;
						gchar* _tmp148_;
						gchar* _tmp149_;
						gchar* _tmp150_;
						ValaSymbol* _tmp151_;
						ValaSymbol* _tmp152_;
						_tmp143_ = alias->source_reference;
						_tmp144_ = vala_gir_parser_node_get_full_name (alias);
						_tmp145_ = _tmp144_;
						_tmp146_ = type_sym;
						_tmp147_ = vala_symbol_get_full_name (_tmp146_);
						_tmp148_ = _tmp147_;
						_tmp149_ = g_strdup_printf ("alias `%s' for `%s' is not supported", _tmp145_, _tmp148_);
						_tmp150_ = _tmp149_;
						vala_report_warning (_tmp143_, _tmp150_);
						_g_free0 (_tmp150_);
						_g_free0 (_tmp148_);
						_g_free0 (_tmp145_);
						_tmp151_ = type_sym;
						_tmp152_ = _vala_code_node_ref0 (_tmp151_);
						_vala_code_node_unref0 (alias->symbol);
						alias->symbol = _tmp152_;
						alias->merged = TRUE;
					}
				}
			}
		}
	}
	_tmp154_ = type_sym;
	if (VALA_IS_CLASS (_tmp154_)) {
		_tmp153_ = TRUE;
	} else {
		gboolean _tmp155_ = FALSE;
		ValaSymbol* _tmp156_;
		_tmp156_ = type_sym;
		if (VALA_IS_STRUCT (_tmp156_)) {
			gboolean _tmp157_;
			_tmp157_ = simple_type;
			_tmp155_ = !_tmp157_;
		} else {
			_tmp155_ = FALSE;
		}
		_tmp153_ = _tmp155_;
	}
	if (_tmp153_) {
		ValaSymbol* _tmp158_;
		_tmp158_ = type_sym;
		if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp158_, "CCode", "has_type_id")) {
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			_tmp159_ = alias->symbol;
			_tmp160_ = type_sym;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp159_, "CCode", "has_type_id", vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp160_, "CCode", "has_type_id", FALSE), NULL);
		} else {
			ValaSymbol* _tmp161_;
			_tmp161_ = type_sym;
			if (vala_code_node_has_attribute_argument ((ValaCodeNode*) _tmp161_, "CCode", "type_id")) {
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				gchar* _tmp164_;
				gchar* _tmp165_;
				_tmp162_ = alias->symbol;
				_tmp163_ = type_sym;
				_tmp164_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp163_, "CCode", "type_id", NULL);
				_tmp165_ = _tmp164_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp162_, "CCode", "type_id", _tmp165_, NULL);
				_g_free0 (_tmp165_);
			}
		}
	}
	_vala_gir_parser_node_unref0 (base_node);
	_vala_code_node_unref0 (type_sym);
	_vala_code_node_unref0 (base_type);
}


static void
vala_gir_parser_process_callable (ValaGirParser* self,
                                  ValaGirParserNode* node)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	ValaSymbol* s = NULL;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaList* parameters = NULL;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaDataType* return_type = NULL;
	ValaSymbol* _tmp7_;
	gboolean _tmp12_ = FALSE;
	ValaDataType* _tmp13_;
	ValaList* _tmp228_;
	gint _tmp229_;
	gint _tmp230_;
	gint i = 0;
	gint j = 0;
	gint first_out = 0;
	gint last = 0;
	gboolean _tmp489_ = FALSE;
	ValaDataType* _tmp490_;
	ValaSymbol* _tmp497_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp1_ = node->element_type;
	if (g_strcmp0 (_tmp1_, "alias") == 0) {
		ValaSymbol* _tmp2_;
		_tmp2_ = node->symbol;
		_tmp0_ = VALA_IS_DELEGATE (_tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp3_ = node->symbol;
	_tmp4_ = _vala_code_node_ref0 (_tmp3_);
	s = _tmp4_;
	_tmp5_ = node->parameters;
	_tmp6_ = _vala_iterable_ref0 (_tmp5_);
	parameters = _tmp6_;
	return_type = NULL;
	_tmp7_ = s;
	if (VALA_IS_CALLABLE (_tmp7_)) {
		ValaSymbol* _tmp8_;
		ValaDataType* _tmp9_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp8_ = s;
		_tmp9_ = vala_callable_get_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CALLABLE, ValaCallable));
		_tmp10_ = _tmp9_;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (return_type);
		return_type = _tmp11_;
	}
	_tmp13_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp13_)) {
		gint _tmp14_;
		_tmp14_ = node->return_array_length_idx;
		_tmp12_ = _tmp14_ >= 0;
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		gint _tmp15_;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		_tmp15_ = node->return_array_length_idx;
		_tmp16_ = parameters;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		if (_tmp15_ >= _tmp18_) {
			ValaDataType* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaSourceReference* _tmp21_;
			_tmp19_ = return_type;
			_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp19_);
			_tmp21_ = _tmp20_;
			vala_report_error (_tmp21_, "invalid array length index");
		} else {
			ValaList* _tmp22_;
			gint _tmp23_;
			gpointer _tmp24_;
			ValaGirParserParameterInfo* _tmp25_;
			ValaArrayList* _tmp26_;
			gint _tmp27_;
			_tmp22_ = parameters;
			_tmp23_ = node->return_array_length_idx;
			_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
			_tmp25_ = (ValaGirParserParameterInfo*) _tmp24_;
			_tmp25_->keep = FALSE;
			_vala_gir_parser_parameter_info_unref0 (_tmp25_);
			_tmp26_ = node->array_length_parameters;
			_tmp27_ = node->return_array_length_idx;
			vala_collection_add ((ValaCollection*) _tmp26_, (gpointer) ((gintptr) _tmp27_));
		}
	} else {
		gboolean _tmp28_ = FALSE;
		ValaDataType* _tmp29_;
		_tmp29_ = return_type;
		if (VALA_IS_VOID_TYPE (_tmp29_)) {
			ValaList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			_tmp30_ = parameters;
			_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp28_ = _tmp32_ > 0;
		} else {
			_tmp28_ = FALSE;
		}
		if (_tmp28_) {
			gint n_out_parameters = 0;
			gint _tmp48_;
			n_out_parameters = 0;
			{
				ValaList* _info_list = NULL;
				ValaList* _tmp33_;
				ValaList* _tmp34_;
				gint _info_size = 0;
				ValaList* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _info_index = 0;
				_tmp33_ = parameters;
				_tmp34_ = _vala_iterable_ref0 (_tmp33_);
				_info_list = _tmp34_;
				_tmp35_ = _info_list;
				_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
				_tmp37_ = _tmp36_;
				_info_size = _tmp37_;
				_info_index = -1;
				while (TRUE) {
					gint _tmp38_;
					gint _tmp39_;
					ValaGirParserParameterInfo* info = NULL;
					ValaList* _tmp40_;
					gint _tmp41_;
					gpointer _tmp42_;
					ValaGirParserParameterInfo* _tmp43_;
					ValaParameter* _tmp44_;
					ValaParameterDirection _tmp45_;
					ValaParameterDirection _tmp46_;
					_info_index = _info_index + 1;
					_tmp38_ = _info_index;
					_tmp39_ = _info_size;
					if (!(_tmp38_ < _tmp39_)) {
						break;
					}
					_tmp40_ = _info_list;
					_tmp41_ = _info_index;
					_tmp42_ = vala_list_get (_tmp40_, _tmp41_);
					info = (ValaGirParserParameterInfo*) _tmp42_;
					_tmp43_ = info;
					_tmp44_ = _tmp43_->param;
					_tmp45_ = vala_parameter_get_direction (_tmp44_);
					_tmp46_ = _tmp45_;
					if (_tmp46_ == VALA_PARAMETER_DIRECTION_OUT) {
						gint _tmp47_;
						_tmp47_ = n_out_parameters;
						n_out_parameters = _tmp47_ + 1;
					}
					_vala_gir_parser_parameter_info_unref0 (info);
				}
				_vala_iterable_unref0 (_info_list);
			}
			_tmp48_ = n_out_parameters;
			if (_tmp48_ == 1) {
				ValaGirParserParameterInfo* last_param = NULL;
				ValaList* _tmp49_;
				ValaList* _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
				gpointer _tmp53_;
				ValaGirParserParameterInfo* _tmp54_;
				ValaParameter* _tmp55_;
				ValaParameterDirection _tmp56_;
				ValaParameterDirection _tmp57_;
				_tmp49_ = parameters;
				_tmp50_ = parameters;
				_tmp51_ = vala_collection_get_size ((ValaCollection*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_list_get (_tmp49_, _tmp52_ - 1);
				last_param = (ValaGirParserParameterInfo*) _tmp53_;
				_tmp54_ = last_param;
				_tmp55_ = _tmp54_->param;
				_tmp56_ = vala_parameter_get_direction (_tmp55_);
				_tmp57_ = _tmp56_;
				if (_tmp57_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaGirParserParameterInfo* _tmp58_;
					ValaParameter* _tmp59_;
					ValaDataType* _tmp60_;
					ValaDataType* _tmp61_;
					_tmp58_ = last_param;
					_tmp59_ = _tmp58_->param;
					_tmp60_ = vala_variable_get_variable_type ((ValaVariable*) _tmp59_);
					_tmp61_ = _tmp60_;
					if (VALA_IS_UNRESOLVED_TYPE (_tmp61_)) {
						ValaStruct* st = NULL;
						ValaGirParserNode* _tmp62_;
						ValaGirParserParameterInfo* _tmp63_;
						ValaParameter* _tmp64_;
						ValaDataType* _tmp65_;
						ValaDataType* _tmp66_;
						ValaUnresolvedSymbol* _tmp67_;
						ValaUnresolvedSymbol* _tmp68_;
						ValaSymbol* _tmp69_;
						ValaStruct* _tmp70_;
						gboolean _tmp71_ = FALSE;
						gboolean _tmp72_ = FALSE;
						ValaStruct* _tmp73_;
						_tmp62_ = node->parent;
						_tmp63_ = last_param;
						_tmp64_ = _tmp63_->param;
						_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) _tmp64_);
						_tmp66_ = _tmp65_;
						_tmp67_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp66_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
						_tmp68_ = _tmp67_;
						_tmp69_ = vala_gir_parser_resolve_symbol (self, _tmp62_, _tmp68_);
						_tmp70_ = VALA_IS_STRUCT (_tmp69_) ? ((ValaStruct*) _tmp69_) : NULL;
						if (_tmp70_ == NULL) {
							_vala_code_node_unref0 (_tmp69_);
						}
						st = _tmp70_;
						_tmp73_ = st;
						if (_tmp73_ != NULL) {
							ValaStruct* _tmp74_;
							_tmp74_ = st;
							_tmp72_ = !vala_struct_is_simple_type (_tmp74_);
						} else {
							_tmp72_ = FALSE;
						}
						if (_tmp72_) {
							ValaGirParserParameterInfo* _tmp75_;
							ValaParameter* _tmp76_;
							ValaDataType* _tmp77_;
							ValaDataType* _tmp78_;
							gboolean _tmp79_;
							gboolean _tmp80_;
							_tmp75_ = last_param;
							_tmp76_ = _tmp75_->param;
							_tmp77_ = vala_variable_get_variable_type ((ValaVariable*) _tmp76_);
							_tmp78_ = _tmp77_;
							_tmp79_ = vala_data_type_get_nullable (_tmp78_);
							_tmp80_ = _tmp79_;
							_tmp71_ = !_tmp80_;
						} else {
							_tmp71_ = FALSE;
						}
						if (_tmp71_) {
							ValaGirParserMetadata* _tmp81_;
							_tmp81_ = node->metadata;
							if (!vala_gir_parser_metadata_get_bool (_tmp81_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURN_VOID, FALSE)) {
								ValaGirParserParameterInfo* _tmp82_;
								ValaGirParserParameterInfo* _tmp83_;
								ValaParameter* _tmp84_;
								ValaDataType* _tmp85_;
								ValaDataType* _tmp86_;
								ValaDataType* _tmp87_;
								_tmp82_ = last_param;
								_tmp82_->keep = FALSE;
								_tmp83_ = last_param;
								_tmp84_ = _tmp83_->param;
								_tmp85_ = vala_variable_get_variable_type ((ValaVariable*) _tmp84_);
								_tmp86_ = _tmp85_;
								_tmp87_ = vala_data_type_copy (_tmp86_);
								_vala_code_node_unref0 (return_type);
								return_type = _tmp87_;
							}
						}
						_vala_code_node_unref0 (st);
					}
				}
				_vala_gir_parser_parameter_info_unref0 (last_param);
			}
		} else {
			gboolean _tmp88_ = FALSE;
			ValaDataType* _tmp89_;
			_tmp89_ = return_type;
			if (VALA_IS_UNRESOLVED_TYPE (_tmp89_)) {
				ValaDataType* _tmp90_;
				gboolean _tmp91_;
				gboolean _tmp92_;
				_tmp90_ = return_type;
				_tmp91_ = vala_data_type_get_nullable (_tmp90_);
				_tmp92_ = _tmp91_;
				_tmp88_ = !_tmp92_;
			} else {
				_tmp88_ = FALSE;
			}
			if (_tmp88_) {
				ValaStruct* st = NULL;
				ValaGirParserNode* _tmp93_;
				ValaDataType* _tmp94_;
				ValaUnresolvedSymbol* _tmp95_;
				ValaUnresolvedSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaStruct* _tmp98_;
				ValaStruct* _tmp99_;
				_tmp93_ = node->parent;
				_tmp94_ = return_type;
				_tmp95_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp94_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
				_tmp96_ = _tmp95_;
				_tmp97_ = vala_gir_parser_resolve_symbol (self, _tmp93_, _tmp96_);
				_tmp98_ = VALA_IS_STRUCT (_tmp97_) ? ((ValaStruct*) _tmp97_) : NULL;
				if (_tmp98_ == NULL) {
					_vala_code_node_unref0 (_tmp97_);
				}
				st = _tmp98_;
				_tmp99_ = st;
				if (_tmp99_ != NULL) {
					gboolean is_simple_type = FALSE;
					ValaStruct* base_st = NULL;
					ValaStruct* _tmp100_;
					ValaStruct* _tmp101_;
					gboolean _tmp119_;
					is_simple_type = FALSE;
					_tmp100_ = st;
					_tmp101_ = _vala_code_node_ref0 (_tmp100_);
					base_st = _tmp101_;
					while (TRUE) {
						ValaStruct* _tmp102_;
						ValaStruct* _tmp103_;
						ValaStruct* _tmp104_;
						ValaDataType* _tmp105_;
						ValaDataType* _tmp106_;
						_tmp102_ = base_st;
						if (!(_tmp102_ != NULL)) {
							break;
						}
						_tmp103_ = base_st;
						if (vala_struct_is_simple_type (_tmp103_)) {
							is_simple_type = TRUE;
							break;
						}
						_tmp104_ = base_st;
						_tmp105_ = vala_struct_get_base_type (_tmp104_);
						_tmp106_ = _tmp105_;
						if (VALA_IS_UNRESOLVED_TYPE (_tmp106_)) {
							ValaGirParserNode* _tmp107_;
							ValaStruct* _tmp108_;
							ValaDataType* _tmp109_;
							ValaDataType* _tmp110_;
							ValaUnresolvedSymbol* _tmp111_;
							ValaUnresolvedSymbol* _tmp112_;
							ValaSymbol* _tmp113_;
							ValaStruct* _tmp114_;
							_tmp107_ = node->parent;
							_tmp108_ = base_st;
							_tmp109_ = vala_struct_get_base_type (_tmp108_);
							_tmp110_ = _tmp109_;
							_tmp111_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp110_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
							_tmp112_ = _tmp111_;
							_tmp113_ = vala_gir_parser_resolve_symbol (self, _tmp107_, _tmp112_);
							_tmp114_ = VALA_IS_STRUCT (_tmp113_) ? ((ValaStruct*) _tmp113_) : NULL;
							if (_tmp114_ == NULL) {
								_vala_code_node_unref0 (_tmp113_);
							}
							_vala_code_node_unref0 (base_st);
							base_st = _tmp114_;
						} else {
							ValaStruct* _tmp115_;
							ValaStruct* _tmp116_;
							ValaStruct* _tmp117_;
							ValaStruct* _tmp118_;
							_tmp115_ = base_st;
							_tmp116_ = vala_struct_get_base_struct (_tmp115_);
							_tmp117_ = _tmp116_;
							_tmp118_ = _vala_code_node_ref0 (_tmp117_);
							_vala_code_node_unref0 (base_st);
							base_st = _tmp118_;
						}
					}
					_tmp119_ = is_simple_type;
					if (!_tmp119_) {
						ValaDataType* _tmp120_;
						_tmp120_ = return_type;
						vala_data_type_set_nullable (_tmp120_, TRUE);
					}
					_vala_code_node_unref0 (base_st);
				}
				_vala_code_node_unref0 (st);
			}
		}
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp121_;
		ValaList* _tmp122_;
		gint _info_size = 0;
		ValaList* _tmp123_;
		gint _tmp124_;
		gint _tmp125_;
		gint _info_index = 0;
		_tmp121_ = parameters;
		_tmp122_ = _vala_iterable_ref0 (_tmp121_);
		_info_list = _tmp122_;
		_tmp123_ = _info_list;
		_tmp124_ = vala_collection_get_size ((ValaCollection*) _tmp123_);
		_tmp125_ = _tmp124_;
		_info_size = _tmp125_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp126_;
			gint _tmp127_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp128_;
			gint _tmp129_;
			gpointer _tmp130_;
			ValaDataType* type = NULL;
			ValaGirParserParameterInfo* _tmp131_;
			ValaParameter* _tmp132_;
			ValaDataType* _tmp133_;
			ValaDataType* _tmp134_;
			gboolean _tmp135_ = FALSE;
			ValaGirParserParameterInfo* _tmp136_;
			ValaParameter* _tmp137_;
			ValaParameterDirection _tmp138_;
			ValaParameterDirection _tmp139_;
			ValaSymbol* _tmp159_;
			_info_index = _info_index + 1;
			_tmp126_ = _info_index;
			_tmp127_ = _info_size;
			if (!(_tmp126_ < _tmp127_)) {
				break;
			}
			_tmp128_ = _info_list;
			_tmp129_ = _info_index;
			_tmp130_ = vala_list_get (_tmp128_, _tmp129_);
			info = (ValaGirParserParameterInfo*) _tmp130_;
			_tmp131_ = info;
			_tmp132_ = _tmp131_->param;
			_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp132_);
			_tmp134_ = _tmp133_;
			type = _tmp134_;
			_tmp136_ = info;
			_tmp137_ = _tmp136_->param;
			_tmp138_ = vala_parameter_get_direction (_tmp137_);
			_tmp139_ = _tmp138_;
			if (_tmp139_ == VALA_PARAMETER_DIRECTION_OUT) {
				ValaDataType* _tmp140_;
				gboolean _tmp141_;
				gboolean _tmp142_;
				_tmp140_ = type;
				_tmp141_ = vala_data_type_get_nullable (_tmp140_);
				_tmp142_ = _tmp141_;
				_tmp135_ = _tmp142_;
			} else {
				_tmp135_ = FALSE;
			}
			if (_tmp135_) {
				ValaStruct* st = NULL;
				ValaDataType* _tmp143_;
				gboolean _tmp155_ = FALSE;
				ValaStruct* _tmp156_;
				st = NULL;
				_tmp143_ = type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp143_)) {
					ValaGirParserNode* _tmp144_;
					ValaDataType* _tmp145_;
					ValaUnresolvedSymbol* _tmp146_;
					ValaUnresolvedSymbol* _tmp147_;
					ValaSymbol* _tmp148_;
					ValaStruct* _tmp149_;
					_tmp144_ = node->parent;
					_tmp145_ = type;
					_tmp146_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp145_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp147_ = _tmp146_;
					_tmp148_ = vala_gir_parser_resolve_symbol (self, _tmp144_, _tmp147_);
					_tmp149_ = VALA_IS_STRUCT (_tmp148_) ? ((ValaStruct*) _tmp148_) : NULL;
					if (_tmp149_ == NULL) {
						_vala_code_node_unref0 (_tmp148_);
					}
					_vala_code_node_unref0 (st);
					st = _tmp149_;
				} else {
					ValaDataType* _tmp150_;
					_tmp150_ = type;
					if (VALA_IS_VALUE_TYPE (_tmp150_)) {
						ValaDataType* _tmp151_;
						ValaTypeSymbol* _tmp152_;
						ValaTypeSymbol* _tmp153_;
						ValaStruct* _tmp154_;
						_tmp151_ = type;
						_tmp152_ = vala_data_type_get_data_type (_tmp151_);
						_tmp153_ = _tmp152_;
						_tmp154_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp153_) ? ((ValaStruct*) _tmp153_) : NULL);
						_vala_code_node_unref0 (st);
						st = _tmp154_;
					}
				}
				_tmp156_ = st;
				if (_tmp156_ != NULL) {
					ValaStruct* _tmp157_;
					_tmp157_ = st;
					_tmp155_ = vala_struct_is_simple_type (_tmp157_);
				} else {
					_tmp155_ = FALSE;
				}
				if (_tmp155_) {
					ValaDataType* _tmp158_;
					_tmp158_ = type;
					vala_data_type_set_nullable (_tmp158_, FALSE);
				}
				_vala_code_node_unref0 (st);
			}
			_tmp159_ = s;
			if (VALA_IS_METHOD (_tmp159_)) {
				gchar* type_name = NULL;
				ValaUnresolvedType* unresolved_type = NULL;
				ValaDataType* _tmp160_;
				ValaUnresolvedType* _tmp161_;
				ValaGirParserParameterInfo* _tmp171_;
				gboolean _tmp172_;
				gboolean _tmp186_ = FALSE;
				gboolean _tmp187_ = FALSE;
				gboolean _tmp188_ = FALSE;
				gboolean _tmp189_ = FALSE;
				gboolean _tmp190_ = FALSE;
				ValaUnresolvedType* _tmp191_;
				type_name = NULL;
				_tmp160_ = type;
				unresolved_type = VALA_IS_UNRESOLVED_TYPE (_tmp160_) ? ((ValaUnresolvedType*) _tmp160_) : NULL;
				_tmp161_ = unresolved_type;
				if (_tmp161_ != NULL) {
					ValaUnresolvedType* _tmp162_;
					ValaUnresolvedSymbol* _tmp163_;
					ValaUnresolvedSymbol* _tmp164_;
					const gchar* _tmp165_;
					const gchar* _tmp166_;
					gchar* _tmp167_;
					_tmp162_ = unresolved_type;
					_tmp163_ = vala_unresolved_type_get_unresolved_symbol (_tmp162_);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_symbol_get_name ((ValaSymbol*) _tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = g_strdup (_tmp166_);
					_g_free0 (type_name);
					type_name = _tmp167_;
				} else {
					ValaDataType* _tmp168_;
					_tmp168_ = type;
					if (_tmp168_ != NULL) {
						ValaDataType* _tmp169_;
						gchar* _tmp170_;
						_tmp169_ = type;
						_tmp170_ = vala_code_node_to_string ((ValaCodeNode*) _tmp169_);
						_g_free0 (type_name);
						type_name = _tmp170_;
					}
				}
				_tmp171_ = info;
				_tmp172_ = _tmp171_->is_async;
				if (_tmp172_) {
					gboolean _tmp173_ = FALSE;
					gboolean _tmp174_ = FALSE;
					gboolean _tmp175_ = FALSE;
					gboolean _tmp176_ = FALSE;
					gboolean _tmp177_ = FALSE;
					ValaUnresolvedType* _tmp178_;
					_tmp178_ = unresolved_type;
					if (_tmp178_ != NULL) {
						const gchar* _tmp179_;
						_tmp179_ = type_name;
						_tmp177_ = g_strcmp0 (_tmp179_, "AsyncReadyCallback") == 0;
					} else {
						_tmp177_ = FALSE;
					}
					if (_tmp177_) {
						_tmp176_ = TRUE;
					} else {
						const gchar* _tmp180_;
						_tmp180_ = type_name;
						_tmp176_ = g_strcmp0 (_tmp180_, "GLib.AsyncReadyCallback") == 0;
					}
					if (_tmp176_) {
						_tmp175_ = TRUE;
					} else {
						const gchar* _tmp181_;
						_tmp181_ = type_name;
						_tmp175_ = g_strcmp0 (_tmp181_, "Gio.AsyncReadyCallback") == 0;
					}
					if (_tmp175_) {
						_tmp174_ = TRUE;
					} else {
						const gchar* _tmp182_;
						_tmp182_ = type_name;
						_tmp174_ = g_strcmp0 (_tmp182_, "GLib.AsyncReadyCallback?") == 0;
					}
					if (_tmp174_) {
						_tmp173_ = TRUE;
					} else {
						const gchar* _tmp183_;
						_tmp183_ = type_name;
						_tmp173_ = g_strcmp0 (_tmp183_, "Gio.AsyncReadyCallback?") == 0;
					}
					if (_tmp173_) {
						ValaSymbol* _tmp184_;
						ValaGirParserParameterInfo* _tmp185_;
						_tmp184_ = s;
						vala_method_set_coroutine (G_TYPE_CHECK_INSTANCE_CAST (_tmp184_, VALA_TYPE_METHOD, ValaMethod), TRUE);
						_tmp185_ = info;
						_tmp185_->keep = FALSE;
					}
				}
				_tmp191_ = unresolved_type;
				if (_tmp191_ != NULL) {
					const gchar* _tmp192_;
					_tmp192_ = type_name;
					_tmp190_ = g_strcmp0 (_tmp192_, "AsyncResult") == 0;
				} else {
					_tmp190_ = FALSE;
				}
				if (_tmp190_) {
					_tmp189_ = TRUE;
				} else {
					const gchar* _tmp193_;
					_tmp193_ = type_name;
					_tmp189_ = g_strcmp0 (_tmp193_, "GLib.AsyncResult") == 0;
				}
				if (_tmp189_) {
					_tmp188_ = TRUE;
				} else {
					const gchar* _tmp194_;
					_tmp194_ = type_name;
					_tmp188_ = g_strcmp0 (_tmp194_, "Gio.AsyncResult") == 0;
				}
				if (_tmp188_) {
					_tmp187_ = TRUE;
				} else {
					const gchar* _tmp195_;
					_tmp195_ = type_name;
					_tmp187_ = g_strcmp0 (_tmp195_, "GLib.AsyncResult?") == 0;
				}
				if (_tmp187_) {
					_tmp186_ = TRUE;
				} else {
					const gchar* _tmp196_;
					_tmp196_ = type_name;
					_tmp186_ = g_strcmp0 (_tmp196_, "Gio.AsyncResult?") == 0;
				}
				if (_tmp186_) {
					ValaGirParserParameterInfo* _tmp197_;
					_tmp197_ = info;
					_tmp197_->is_async_result = TRUE;
				}
				_g_free0 (type_name);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		gint param_n = 0;
		ValaList* _tmp198_;
		gint _tmp199_;
		gint _tmp200_;
		_tmp198_ = parameters;
		_tmp199_ = vala_collection_get_size ((ValaCollection*) _tmp198_);
		_tmp200_ = _tmp199_;
		param_n = _tmp200_ - 1;
		{
			gboolean _tmp201_ = FALSE;
			_tmp201_ = TRUE;
			while (TRUE) {
				gint _tmp203_;
				ValaGirParserParameterInfo* info = NULL;
				ValaList* _tmp204_;
				gint _tmp205_;
				gpointer _tmp206_;
				gboolean _tmp207_ = FALSE;
				ValaGirParserParameterInfo* _tmp208_;
				ValaParameter* _tmp209_;
				gboolean _tmp210_;
				gboolean _tmp211_;
				if (!_tmp201_) {
					gint _tmp202_;
					_tmp202_ = param_n;
					param_n = _tmp202_ - 1;
				}
				_tmp201_ = FALSE;
				_tmp203_ = param_n;
				if (!(_tmp203_ >= 0)) {
					break;
				}
				_tmp204_ = parameters;
				_tmp205_ = param_n;
				_tmp206_ = vala_list_get (_tmp204_, _tmp205_);
				info = (ValaGirParserParameterInfo*) _tmp206_;
				_tmp208_ = info;
				_tmp209_ = _tmp208_->param;
				_tmp210_ = vala_parameter_get_ellipsis (_tmp209_);
				_tmp211_ = _tmp210_;
				if (!_tmp211_) {
					ValaGirParserParameterInfo* _tmp212_;
					ValaParameter* _tmp213_;
					ValaExpression* _tmp214_;
					ValaExpression* _tmp215_;
					_tmp212_ = info;
					_tmp213_ = _tmp212_->param;
					_tmp214_ = vala_variable_get_initializer ((ValaVariable*) _tmp213_);
					_tmp215_ = _tmp214_;
					_tmp207_ = _tmp215_ == NULL;
				} else {
					_tmp207_ = FALSE;
				}
				if (_tmp207_) {
					gchar* type_string = NULL;
					ValaGirParserParameterInfo* _tmp216_;
					ValaParameter* _tmp217_;
					ValaDataType* _tmp218_;
					ValaDataType* _tmp219_;
					gchar* _tmp220_;
					gboolean _tmp221_ = FALSE;
					const gchar* _tmp222_;
					_tmp216_ = info;
					_tmp217_ = _tmp216_->param;
					_tmp218_ = vala_variable_get_variable_type ((ValaVariable*) _tmp217_);
					_tmp219_ = _tmp218_;
					_tmp220_ = vala_code_node_to_string ((ValaCodeNode*) _tmp219_);
					type_string = _tmp220_;
					_tmp222_ = type_string;
					if (g_strcmp0 (_tmp222_, "GLib.Cancellable?") == 0) {
						_tmp221_ = TRUE;
					} else {
						const gchar* _tmp223_;
						_tmp223_ = type_string;
						_tmp221_ = g_strcmp0 (_tmp223_, "Gio.Cancellable?") == 0;
					}
					if (_tmp221_) {
						ValaGirParserParameterInfo* _tmp224_;
						ValaParameter* _tmp225_;
						ValaNullLiteral* _tmp226_;
						ValaNullLiteral* _tmp227_;
						_tmp224_ = info;
						_tmp225_ = _tmp224_->param;
						_tmp226_ = vala_null_literal_new (NULL);
						_tmp227_ = _tmp226_;
						vala_variable_set_initializer ((ValaVariable*) _tmp225_, (ValaExpression*) _tmp227_);
						_vala_code_node_unref0 (_tmp227_);
					} else {
						_g_free0 (type_string);
						_vala_gir_parser_parameter_info_unref0 (info);
						break;
					}
					_g_free0 (type_string);
				}
				_vala_gir_parser_parameter_info_unref0 (info);
			}
		}
	}
	_tmp228_ = parameters;
	_tmp229_ = vala_collection_get_size ((ValaCollection*) _tmp228_);
	_tmp230_ = _tmp229_;
	if (_tmp230_ > 1) {
		ValaGirParserParameterInfo* last_param = NULL;
		ValaList* _tmp231_;
		ValaList* _tmp232_;
		gint _tmp233_;
		gint _tmp234_;
		gpointer _tmp235_;
		ValaGirParserParameterInfo* _tmp236_;
		ValaParameter* _tmp237_;
		gboolean _tmp238_;
		gboolean _tmp239_;
		_tmp231_ = parameters;
		_tmp232_ = parameters;
		_tmp233_ = vala_collection_get_size ((ValaCollection*) _tmp232_);
		_tmp234_ = _tmp233_;
		_tmp235_ = vala_list_get (_tmp231_, _tmp234_ - 1);
		last_param = (ValaGirParserParameterInfo*) _tmp235_;
		_tmp236_ = last_param;
		_tmp237_ = _tmp236_->param;
		_tmp238_ = vala_parameter_get_ellipsis (_tmp237_);
		_tmp239_ = _tmp238_;
		if (_tmp239_) {
			ValaGirParserParameterInfo* first_vararg_param = NULL;
			ValaList* _tmp240_;
			ValaList* _tmp241_;
			gint _tmp242_;
			gint _tmp243_;
			gpointer _tmp244_;
			ValaGirParserParameterInfo* _tmp245_;
			ValaParameter* _tmp246_;
			const gchar* _tmp247_;
			const gchar* _tmp248_;
			_tmp240_ = parameters;
			_tmp241_ = parameters;
			_tmp242_ = vala_collection_get_size ((ValaCollection*) _tmp241_);
			_tmp243_ = _tmp242_;
			_tmp244_ = vala_list_get (_tmp240_, _tmp243_ - 2);
			first_vararg_param = (ValaGirParserParameterInfo*) _tmp244_;
			_tmp245_ = first_vararg_param;
			_tmp246_ = _tmp245_->param;
			_tmp247_ = vala_symbol_get_name ((ValaSymbol*) _tmp246_);
			_tmp248_ = _tmp247_;
			if (g_str_has_prefix (_tmp248_, "first_")) {
				ValaGirParserParameterInfo* _tmp249_;
				_tmp249_ = first_vararg_param;
				_tmp249_->keep = FALSE;
			}
			_vala_gir_parser_parameter_info_unref0 (first_vararg_param);
		}
		_vala_gir_parser_parameter_info_unref0 (last_param);
	}
	i = 0;
	j = 1;
	first_out = -1;
	last = -1;
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp250_;
		ValaList* _tmp251_;
		gint _info_size = 0;
		ValaList* _tmp252_;
		gint _tmp253_;
		gint _tmp254_;
		gint _info_index = 0;
		_tmp250_ = parameters;
		_tmp251_ = _vala_iterable_ref0 (_tmp250_);
		_info_list = _tmp251_;
		_tmp252_ = _info_list;
		_tmp253_ = vala_collection_get_size ((ValaCollection*) _tmp252_);
		_tmp254_ = _tmp253_;
		_info_size = _tmp254_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp255_;
			gint _tmp256_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp257_;
			gint _tmp258_;
			gpointer _tmp259_;
			gboolean _tmp260_ = FALSE;
			ValaSymbol* _tmp261_;
			gboolean _tmp314_ = FALSE;
			gint _tmp315_;
			gboolean _tmp321_ = FALSE;
			gboolean _tmp322_ = FALSE;
			gint _tmp323_;
			gint _tmp334_;
			_info_index = _info_index + 1;
			_tmp255_ = _info_index;
			_tmp256_ = _info_size;
			if (!(_tmp255_ < _tmp256_)) {
				break;
			}
			_tmp257_ = _info_list;
			_tmp258_ = _info_index;
			_tmp259_ = vala_list_get (_tmp257_, _tmp258_);
			info = (ValaGirParserParameterInfo*) _tmp259_;
			_tmp261_ = s;
			if (VALA_IS_DELEGATE (_tmp261_)) {
				ValaGirParserParameterInfo* _tmp262_;
				gint _tmp263_;
				gint _tmp264_;
				_tmp262_ = info;
				_tmp263_ = _tmp262_->closure_idx;
				_tmp264_ = i;
				_tmp260_ = _tmp263_ == _tmp264_;
			} else {
				_tmp260_ = FALSE;
			}
			if (_tmp260_) {
				ValaDelegate* d = NULL;
				ValaSymbol* _tmp265_;
				ValaDelegate* _tmp266_;
				ValaDelegate* _tmp267_;
				ValaDelegate* _tmp268_;
				gint _tmp269_;
				ValaGirParserParameterInfo* _tmp270_;
				_tmp265_ = s;
				_tmp266_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp265_, VALA_TYPE_DELEGATE, ValaDelegate));
				d = _tmp266_;
				_tmp267_ = d;
				vala_delegate_set_has_target (_tmp267_, TRUE);
				_tmp268_ = d;
				_tmp269_ = j;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp268_, "CCode", "instance_pos", _tmp269_ - 0.1, NULL);
				_tmp270_ = info;
				_tmp270_->keep = FALSE;
				_vala_code_node_unref0 (d);
			} else {
				gboolean _tmp271_ = FALSE;
				gboolean _tmp272_ = FALSE;
				gboolean _tmp273_ = FALSE;
				ValaGirParserParameterInfo* _tmp274_;
				gboolean _tmp275_;
				_tmp274_ = info;
				_tmp275_ = _tmp274_->keep;
				if (_tmp275_) {
					ValaArrayList* _tmp276_;
					gint _tmp277_;
					_tmp276_ = node->array_length_parameters;
					_tmp277_ = i;
					_tmp273_ = !vala_collection_contains ((ValaCollection*) _tmp276_, (gpointer) ((gintptr) _tmp277_));
				} else {
					_tmp273_ = FALSE;
				}
				if (_tmp273_) {
					ValaArrayList* _tmp278_;
					gint _tmp279_;
					_tmp278_ = node->closure_parameters;
					_tmp279_ = i;
					_tmp272_ = !vala_collection_contains ((ValaCollection*) _tmp278_, (gpointer) ((gintptr) _tmp279_));
				} else {
					_tmp272_ = FALSE;
				}
				if (_tmp272_) {
					ValaArrayList* _tmp280_;
					gint _tmp281_;
					_tmp280_ = node->destroy_parameters;
					_tmp281_ = i;
					_tmp271_ = !vala_collection_contains ((ValaCollection*) _tmp280_, (gpointer) ((gintptr) _tmp281_));
				} else {
					_tmp271_ = FALSE;
				}
				if (_tmp271_) {
					ValaGirParserParameterInfo* _tmp282_;
					gint _tmp283_;
					ValaGirParserParameterInfo* _tmp284_;
					gfloat last_idx = 0.0F;
					gint _tmp285_;
					gint _tmp307_;
					gint _tmp308_;
					_tmp282_ = info;
					_tmp283_ = j;
					_tmp282_->vala_idx = (gfloat) _tmp283_;
					_tmp284_ = info;
					_tmp284_->keep = TRUE;
					last_idx = 0.0F;
					_tmp285_ = last;
					if (_tmp285_ != -1) {
						ValaList* _tmp286_;
						gint _tmp287_;
						gpointer _tmp288_;
						ValaGirParserParameterInfo* _tmp289_;
						gfloat _tmp290_;
						_tmp286_ = parameters;
						_tmp287_ = last;
						_tmp288_ = vala_list_get (_tmp286_, _tmp287_);
						_tmp289_ = (ValaGirParserParameterInfo*) _tmp288_;
						_tmp290_ = _tmp289_->vala_idx;
						last_idx = _tmp290_;
						_vala_gir_parser_parameter_info_unref0 (_tmp289_);
					}
					{
						gint k = 0;
						gint _tmp291_;
						_tmp291_ = last;
						k = _tmp291_ + 1;
						{
							gboolean _tmp292_ = FALSE;
							_tmp292_ = TRUE;
							while (TRUE) {
								gint _tmp294_;
								gint _tmp295_;
								ValaList* _tmp296_;
								gint _tmp297_;
								gpointer _tmp298_;
								ValaGirParserParameterInfo* _tmp299_;
								gfloat _tmp300_;
								gint _tmp301_;
								gfloat _tmp302_;
								gint _tmp303_;
								gint _tmp304_;
								gint _tmp305_;
								gint _tmp306_;
								if (!_tmp292_) {
									gint _tmp293_;
									_tmp293_ = k;
									k = _tmp293_ + 1;
								}
								_tmp292_ = FALSE;
								_tmp294_ = k;
								_tmp295_ = i;
								if (!(_tmp294_ < _tmp295_)) {
									break;
								}
								_tmp296_ = parameters;
								_tmp297_ = k;
								_tmp298_ = vala_list_get (_tmp296_, _tmp297_);
								_tmp299_ = (ValaGirParserParameterInfo*) _tmp298_;
								_tmp300_ = last_idx;
								_tmp301_ = j;
								_tmp302_ = last_idx;
								_tmp303_ = i;
								_tmp304_ = last;
								_tmp305_ = k;
								_tmp306_ = last;
								_tmp299_->vala_idx = _tmp300_ + (((_tmp301_ - _tmp302_) / (_tmp303_ - _tmp304_)) * (_tmp305_ - _tmp306_));
								_vala_gir_parser_parameter_info_unref0 (_tmp299_);
							}
						}
					}
					_tmp307_ = i;
					last = _tmp307_;
					_tmp308_ = j;
					j = _tmp308_ + 1;
				} else {
					ValaGirParserParameterInfo* _tmp309_;
					ValaGirParserParameterInfo* _tmp310_;
					gint _tmp311_;
					gint _tmp312_;
					gint _tmp313_;
					_tmp309_ = info;
					_tmp309_->keep = FALSE;
					_tmp310_ = info;
					_tmp311_ = j;
					_tmp312_ = i;
					_tmp313_ = last;
					_tmp310_->vala_idx = (_tmp311_ - 1) + ((_tmp312_ - _tmp313_) * 0.1F);
				}
			}
			_tmp315_ = first_out;
			if (_tmp315_ < 0) {
				ValaGirParserParameterInfo* _tmp316_;
				ValaParameter* _tmp317_;
				ValaParameterDirection _tmp318_;
				ValaParameterDirection _tmp319_;
				_tmp316_ = info;
				_tmp317_ = _tmp316_->param;
				_tmp318_ = vala_parameter_get_direction (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp314_ = _tmp319_ == VALA_PARAMETER_DIRECTION_OUT;
			} else {
				_tmp314_ = FALSE;
			}
			if (_tmp314_) {
				gint _tmp320_;
				_tmp320_ = i;
				first_out = _tmp320_;
			}
			_tmp323_ = first_out;
			if (_tmp323_ >= 0) {
				ValaGirParserParameterInfo* _tmp324_;
				gboolean _tmp325_;
				_tmp324_ = info;
				_tmp325_ = _tmp324_->is_async_result;
				_tmp322_ = _tmp325_;
			} else {
				_tmp322_ = FALSE;
			}
			if (_tmp322_) {
				ValaSymbol* _tmp326_;
				_tmp326_ = s;
				_tmp321_ = VALA_IS_METHOD (_tmp326_);
			} else {
				_tmp321_ = FALSE;
			}
			if (_tmp321_) {
				gdouble _tmp327_ = 0.0;
				ValaSymbol* _tmp328_;
				ValaMemberBinding _tmp329_;
				ValaMemberBinding _tmp330_;
				gdouble shift = 0.0;
				ValaSymbol* _tmp331_;
				gint _tmp332_;
				gdouble _tmp333_;
				_tmp328_ = s;
				_tmp329_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_METHOD, ValaMethod));
				_tmp330_ = _tmp329_;
				if (_tmp330_ == VALA_MEMBER_BINDING_INSTANCE) {
					_tmp327_ = 1.1;
				} else {
					_tmp327_ = 0.1;
				}
				shift = _tmp327_;
				_tmp331_ = s;
				_tmp332_ = i;
				_tmp333_ = shift;
				vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp331_, "CCode", "async_result_pos", _tmp332_ + _tmp333_, NULL);
			}
			_tmp334_ = i;
			i = _tmp334_ + 1;
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	{
		ValaList* _info_list = NULL;
		ValaList* _tmp335_;
		ValaList* _tmp336_;
		gint _info_size = 0;
		ValaList* _tmp337_;
		gint _tmp338_;
		gint _tmp339_;
		gint _info_index = 0;
		_tmp335_ = parameters;
		_tmp336_ = _vala_iterable_ref0 (_tmp335_);
		_info_list = _tmp336_;
		_tmp337_ = _info_list;
		_tmp338_ = vala_collection_get_size ((ValaCollection*) _tmp337_);
		_tmp339_ = _tmp338_;
		_info_size = _tmp339_;
		_info_index = -1;
		while (TRUE) {
			gint _tmp340_;
			gint _tmp341_;
			ValaGirParserParameterInfo* info = NULL;
			ValaList* _tmp342_;
			gint _tmp343_;
			gpointer _tmp344_;
			ValaGirParserParameterInfo* _tmp345_;
			gboolean _tmp346_;
			ValaSymbol* _tmp347_;
			ValaGirParserParameterInfo* _tmp351_;
			gint _tmp352_;
			ValaGirParserParameterInfo* _tmp369_;
			gint _tmp370_;
			ValaGirParserParameterInfo* _tmp401_;
			gint _tmp402_;
			ValaGirParserParameterInfo* _tmp433_;
			gboolean _tmp434_;
			_info_index = _info_index + 1;
			_tmp340_ = _info_index;
			_tmp341_ = _info_size;
			if (!(_tmp340_ < _tmp341_)) {
				break;
			}
			_tmp342_ = _info_list;
			_tmp343_ = _info_index;
			_tmp344_ = vala_list_get (_tmp342_, _tmp343_);
			info = (ValaGirParserParameterInfo*) _tmp344_;
			_tmp345_ = info;
			_tmp346_ = _tmp345_->keep;
			if (!_tmp346_) {
				_vala_gir_parser_parameter_info_unref0 (info);
				continue;
			}
			_tmp347_ = s;
			if (VALA_IS_CALLABLE (_tmp347_)) {
				ValaSymbol* _tmp348_;
				ValaGirParserParameterInfo* _tmp349_;
				ValaParameter* _tmp350_;
				_tmp348_ = s;
				_tmp349_ = info;
				_tmp350_ = _tmp349_->param;
				vala_callable_add_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp348_, VALA_TYPE_CALLABLE, ValaCallable), _tmp350_);
			}
			_tmp351_ = info;
			_tmp352_ = _tmp351_->array_length_idx;
			if (_tmp352_ != -1) {
				ValaGirParserParameterInfo* _tmp353_;
				gint _tmp354_;
				ValaList* _tmp355_;
				gint _tmp356_;
				gint _tmp357_;
				ValaGirParserParameterInfo* _tmp362_;
				ValaParameter* _tmp363_;
				ValaList* _tmp364_;
				ValaGirParserParameterInfo* _tmp365_;
				gint _tmp366_;
				gpointer _tmp367_;
				ValaGirParserParameterInfo* _tmp368_;
				_tmp353_ = info;
				_tmp354_ = _tmp353_->array_length_idx;
				_tmp355_ = parameters;
				_tmp356_ = vala_collection_get_size ((ValaCollection*) _tmp355_);
				_tmp357_ = _tmp356_;
				if (_tmp354_ >= _tmp357_) {
					ValaGirParserParameterInfo* _tmp358_;
					ValaParameter* _tmp359_;
					ValaSourceReference* _tmp360_;
					ValaSourceReference* _tmp361_;
					_tmp358_ = info;
					_tmp359_ = _tmp358_->param;
					_tmp360_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp359_);
					_tmp361_ = _tmp360_;
					vala_report_error (_tmp361_, "invalid array_length index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp362_ = info;
				_tmp363_ = _tmp362_->param;
				_tmp364_ = parameters;
				_tmp365_ = info;
				_tmp366_ = _tmp365_->array_length_idx;
				_tmp367_ = vala_list_get (_tmp364_, _tmp366_);
				_tmp368_ = (ValaGirParserParameterInfo*) _tmp367_;
				vala_gir_parser_set_array_ccode (self, (ValaSymbol*) _tmp363_, _tmp368_);
				_vala_gir_parser_parameter_info_unref0 (_tmp368_);
			}
			_tmp369_ = info;
			_tmp370_ = _tmp369_->closure_idx;
			if (_tmp370_ != -1) {
				ValaGirParserParameterInfo* _tmp371_;
				gint _tmp372_;
				ValaList* _tmp373_;
				gint _tmp374_;
				gint _tmp375_;
				ValaList* _tmp380_;
				ValaGirParserParameterInfo* _tmp381_;
				gint _tmp382_;
				gpointer _tmp383_;
				ValaGirParserParameterInfo* _tmp384_;
				gfloat _tmp385_;
				gchar* _tmp386_;
				gchar* _tmp387_;
				ValaGirParserParameterInfo* _tmp388_;
				gfloat _tmp389_;
				gchar* _tmp390_;
				gchar* _tmp391_;
				gboolean _tmp392_;
				_tmp371_ = info;
				_tmp372_ = _tmp371_->closure_idx;
				_tmp373_ = parameters;
				_tmp374_ = vala_collection_get_size ((ValaCollection*) _tmp373_);
				_tmp375_ = _tmp374_;
				if (_tmp372_ >= _tmp375_) {
					ValaGirParserParameterInfo* _tmp376_;
					ValaParameter* _tmp377_;
					ValaSourceReference* _tmp378_;
					ValaSourceReference* _tmp379_;
					_tmp376_ = info;
					_tmp377_ = _tmp376_->param;
					_tmp378_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp377_);
					_tmp379_ = _tmp378_;
					vala_report_error (_tmp379_, "invalid closure index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp380_ = parameters;
				_tmp381_ = info;
				_tmp382_ = _tmp381_->closure_idx;
				_tmp383_ = vala_list_get (_tmp380_, _tmp382_);
				_tmp384_ = (ValaGirParserParameterInfo*) _tmp383_;
				_tmp385_ = _tmp384_->vala_idx;
				_tmp386_ = g_strdup_printf ("%g", (gdouble) _tmp385_);
				_tmp387_ = _tmp386_;
				_tmp388_ = info;
				_tmp389_ = _tmp388_->vala_idx;
				_tmp390_ = g_strdup_printf ("%g", _tmp389_ + 0.1);
				_tmp391_ = _tmp390_;
				_tmp392_ = g_strcmp0 (_tmp387_, _tmp391_) != 0;
				_g_free0 (_tmp391_);
				_g_free0 (_tmp387_);
				_vala_gir_parser_parameter_info_unref0 (_tmp384_);
				if (_tmp392_) {
					ValaGirParserParameterInfo* _tmp393_;
					ValaParameter* _tmp394_;
					ValaList* _tmp395_;
					ValaGirParserParameterInfo* _tmp396_;
					gint _tmp397_;
					gpointer _tmp398_;
					ValaGirParserParameterInfo* _tmp399_;
					gfloat _tmp400_;
					_tmp393_ = info;
					_tmp394_ = _tmp393_->param;
					_tmp395_ = parameters;
					_tmp396_ = info;
					_tmp397_ = _tmp396_->closure_idx;
					_tmp398_ = vala_list_get (_tmp395_, _tmp397_);
					_tmp399_ = (ValaGirParserParameterInfo*) _tmp398_;
					_tmp400_ = _tmp399_->vala_idx;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp394_, "CCode", "delegate_target_pos", (gdouble) _tmp400_, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp399_);
				}
			}
			_tmp401_ = info;
			_tmp402_ = _tmp401_->destroy_idx;
			if (_tmp402_ != -1) {
				ValaGirParserParameterInfo* _tmp403_;
				gint _tmp404_;
				ValaList* _tmp405_;
				gint _tmp406_;
				gint _tmp407_;
				ValaList* _tmp412_;
				ValaGirParserParameterInfo* _tmp413_;
				gint _tmp414_;
				gpointer _tmp415_;
				ValaGirParserParameterInfo* _tmp416_;
				gfloat _tmp417_;
				gchar* _tmp418_;
				gchar* _tmp419_;
				ValaGirParserParameterInfo* _tmp420_;
				gfloat _tmp421_;
				gchar* _tmp422_;
				gchar* _tmp423_;
				gboolean _tmp424_;
				_tmp403_ = info;
				_tmp404_ = _tmp403_->destroy_idx;
				_tmp405_ = parameters;
				_tmp406_ = vala_collection_get_size ((ValaCollection*) _tmp405_);
				_tmp407_ = _tmp406_;
				if (_tmp404_ >= _tmp407_) {
					ValaGirParserParameterInfo* _tmp408_;
					ValaParameter* _tmp409_;
					ValaSourceReference* _tmp410_;
					ValaSourceReference* _tmp411_;
					_tmp408_ = info;
					_tmp409_ = _tmp408_->param;
					_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp409_);
					_tmp411_ = _tmp410_;
					vala_report_error (_tmp411_, "invalid destroy index");
					_vala_gir_parser_parameter_info_unref0 (info);
					continue;
				}
				_tmp412_ = parameters;
				_tmp413_ = info;
				_tmp414_ = _tmp413_->destroy_idx;
				_tmp415_ = vala_list_get (_tmp412_, _tmp414_);
				_tmp416_ = (ValaGirParserParameterInfo*) _tmp415_;
				_tmp417_ = _tmp416_->vala_idx;
				_tmp418_ = g_strdup_printf ("%g", (gdouble) _tmp417_);
				_tmp419_ = _tmp418_;
				_tmp420_ = info;
				_tmp421_ = _tmp420_->vala_idx;
				_tmp422_ = g_strdup_printf ("%g", _tmp421_ + 0.2);
				_tmp423_ = _tmp422_;
				_tmp424_ = g_strcmp0 (_tmp419_, _tmp423_) != 0;
				_g_free0 (_tmp423_);
				_g_free0 (_tmp419_);
				_vala_gir_parser_parameter_info_unref0 (_tmp416_);
				if (_tmp424_) {
					ValaGirParserParameterInfo* _tmp425_;
					ValaParameter* _tmp426_;
					ValaList* _tmp427_;
					ValaGirParserParameterInfo* _tmp428_;
					gint _tmp429_;
					gpointer _tmp430_;
					ValaGirParserParameterInfo* _tmp431_;
					gfloat _tmp432_;
					_tmp425_ = info;
					_tmp426_ = _tmp425_->param;
					_tmp427_ = parameters;
					_tmp428_ = info;
					_tmp429_ = _tmp428_->destroy_idx;
					_tmp430_ = vala_list_get (_tmp427_, _tmp429_);
					_tmp431_ = (ValaGirParserParameterInfo*) _tmp430_;
					_tmp432_ = _tmp431_->vala_idx;
					vala_code_node_set_attribute_double ((ValaCodeNode*) _tmp426_, "CCode", "destroy_notify_pos", (gdouble) _tmp432_, NULL);
					_vala_gir_parser_parameter_info_unref0 (_tmp431_);
				}
			}
			_tmp433_ = info;
			_tmp434_ = _tmp433_->is_async;
			if (_tmp434_) {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp435_;
				ValaParameter* _tmp436_;
				ValaDataType* _tmp437_;
				ValaDataType* _tmp438_;
				ValaDataType* _tmp439_;
				ValaDataType* _tmp440_;
				ValaDataType* _tmp449_;
				_tmp435_ = info;
				_tmp436_ = _tmp435_->param;
				_tmp437_ = vala_variable_get_variable_type ((ValaVariable*) _tmp436_);
				_tmp438_ = _tmp437_;
				_tmp439_ = _vala_code_node_ref0 (_tmp438_);
				resolved_type = _tmp439_;
				_tmp440_ = resolved_type;
				if (VALA_IS_UNRESOLVED_TYPE (_tmp440_)) {
					ValaSymbol* resolved_symbol = NULL;
					ValaGirParserNode* _tmp441_;
					ValaDataType* _tmp442_;
					ValaUnresolvedSymbol* _tmp443_;
					ValaUnresolvedSymbol* _tmp444_;
					ValaSymbol* _tmp445_;
					ValaSymbol* _tmp446_;
					_tmp441_ = node->parent;
					_tmp442_ = resolved_type;
					_tmp443_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp442_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
					_tmp444_ = _tmp443_;
					_tmp445_ = vala_gir_parser_resolve_symbol (self, _tmp441_, _tmp444_);
					resolved_symbol = _tmp445_;
					_tmp446_ = resolved_symbol;
					if (VALA_IS_DELEGATE (_tmp446_)) {
						ValaSymbol* _tmp447_;
						ValaDelegateType* _tmp448_;
						_tmp447_ = resolved_symbol;
						_tmp448_ = vala_delegate_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp447_, VALA_TYPE_DELEGATE, ValaDelegate));
						_vala_code_node_unref0 (resolved_type);
						resolved_type = (ValaDataType*) _tmp448_;
					}
					_vala_code_node_unref0 (resolved_symbol);
				}
				_tmp449_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp449_)) {
					ValaDelegate* d = NULL;
					ValaDataType* _tmp450_;
					ValaDelegate* _tmp451_;
					ValaDelegate* _tmp452_;
					ValaDelegate* _tmp453_;
					gboolean _tmp454_ = FALSE;
					ValaDelegate* _tmp455_;
					const gchar* _tmp456_;
					const gchar* _tmp457_;
					_tmp450_ = resolved_type;
					_tmp451_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp450_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
					_tmp452_ = _tmp451_;
					_tmp453_ = _vala_code_node_ref0 (_tmp452_);
					d = _tmp453_;
					_tmp455_ = d;
					_tmp456_ = vala_symbol_get_name ((ValaSymbol*) _tmp455_);
					_tmp457_ = _tmp456_;
					if (g_strcmp0 (_tmp457_, "DestroyNotify") == 0) {
						ValaDelegate* _tmp458_;
						ValaSymbol* _tmp459_;
						ValaSymbol* _tmp460_;
						const gchar* _tmp461_;
						const gchar* _tmp462_;
						_tmp458_ = d;
						_tmp459_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp458_);
						_tmp460_ = _tmp459_;
						_tmp461_ = vala_symbol_get_name (_tmp460_);
						_tmp462_ = _tmp461_;
						_tmp454_ = g_strcmp0 (_tmp462_, "GLib") == 0;
					} else {
						_tmp454_ = FALSE;
					}
					if (!_tmp454_) {
						ValaGirParserParameterInfo* _tmp463_;
						ValaParameter* _tmp464_;
						gboolean _tmp465_ = FALSE;
						ValaGirParserParameterInfo* _tmp466_;
						gint _tmp467_;
						ValaGirParserParameterInfo* _tmp470_;
						ValaParameter* _tmp471_;
						ValaDataType* _tmp472_;
						ValaDataType* _tmp473_;
						_tmp463_ = info;
						_tmp464_ = _tmp463_->param;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp464_, "CCode", "scope", "async", NULL);
						_tmp466_ = info;
						_tmp467_ = _tmp466_->closure_idx;
						if (_tmp467_ != -1) {
							ValaGirParserParameterInfo* _tmp468_;
							gint _tmp469_;
							_tmp468_ = info;
							_tmp469_ = _tmp468_->destroy_idx;
							_tmp465_ = _tmp469_ != -1;
						} else {
							_tmp465_ = FALSE;
						}
						_tmp470_ = info;
						_tmp471_ = _tmp470_->param;
						_tmp472_ = vala_variable_get_variable_type ((ValaVariable*) _tmp471_);
						_tmp473_ = _tmp472_;
						vala_data_type_set_value_owned (_tmp473_, _tmp465_);
					}
					_vala_code_node_unref0 (d);
				}
				_vala_code_node_unref0 (resolved_type);
			} else {
				ValaDataType* resolved_type = NULL;
				ValaGirParserParameterInfo* _tmp474_;
				ValaParameter* _tmp475_;
				ValaDataType* _tmp476_;
				ValaDataType* _tmp477_;
				ValaDataType* _tmp478_;
				ValaDataType* _tmp479_;
				_tmp474_ = info;
				_tmp475_ = _tmp474_->param;
				_tmp476_ = vala_variable_get_variable_type ((ValaVariable*) _tmp475_);
				_tmp477_ = _tmp476_;
				_tmp478_ = _vala_code_node_ref0 (_tmp477_);
				resolved_type = _tmp478_;
				_tmp479_ = resolved_type;
				if (VALA_IS_DELEGATE_TYPE (_tmp479_)) {
					gboolean _tmp480_ = FALSE;
					ValaGirParserParameterInfo* _tmp481_;
					gint _tmp482_;
					ValaGirParserParameterInfo* _tmp485_;
					ValaParameter* _tmp486_;
					ValaDataType* _tmp487_;
					ValaDataType* _tmp488_;
					_tmp481_ = info;
					_tmp482_ = _tmp481_->closure_idx;
					if (_tmp482_ != -1) {
						ValaGirParserParameterInfo* _tmp483_;
						gint _tmp484_;
						_tmp483_ = info;
						_tmp484_ = _tmp483_->destroy_idx;
						_tmp480_ = _tmp484_ != -1;
					} else {
						_tmp480_ = FALSE;
					}
					_tmp485_ = info;
					_tmp486_ = _tmp485_->param;
					_tmp487_ = vala_variable_get_variable_type ((ValaVariable*) _tmp486_);
					_tmp488_ = _tmp487_;
					vala_data_type_set_value_owned (_tmp488_, _tmp480_);
				}
				_vala_code_node_unref0 (resolved_type);
			}
			_vala_gir_parser_parameter_info_unref0 (info);
		}
		_vala_iterable_unref0 (_info_list);
	}
	_tmp490_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp490_)) {
		gint _tmp491_;
		_tmp491_ = node->return_array_length_idx;
		_tmp489_ = _tmp491_ >= 0;
	} else {
		_tmp489_ = FALSE;
	}
	if (_tmp489_) {
		ValaSymbol* _tmp492_;
		ValaList* _tmp493_;
		gint _tmp494_;
		gpointer _tmp495_;
		ValaGirParserParameterInfo* _tmp496_;
		_tmp492_ = s;
		_tmp493_ = parameters;
		_tmp494_ = node->return_array_length_idx;
		_tmp495_ = vala_list_get (_tmp493_, _tmp494_);
		_tmp496_ = (ValaGirParserParameterInfo*) _tmp495_;
		vala_gir_parser_set_array_ccode (self, _tmp492_, _tmp496_);
		_vala_gir_parser_parameter_info_unref0 (_tmp496_);
	}
	_tmp497_ = s;
	if (VALA_IS_CALLABLE (_tmp497_)) {
		ValaSymbol* _tmp498_;
		ValaDataType* _tmp499_;
		_tmp498_ = s;
		_tmp499_ = return_type;
		vala_callable_set_return_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp498_, VALA_TYPE_CALLABLE, ValaCallable), _tmp499_);
	}
	_vala_code_node_unref0 (return_type);
	_vala_iterable_unref0 (parameters);
	_vala_code_node_unref0 (s);
}


static void
vala_gir_parser_find_parent (ValaGirParser* self,
                             const gchar* cname,
                             ValaGirParserNode* current,
                             ValaGirParserNode* * best,
                             gint* match)
{
	ValaGirParserNode* old_best = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaGirParserNode* _tmp22_;
	gint current_match = 0;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gint _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cname != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (*best != NULL);
	_tmp0_ = _vala_gir_parser_node_ref0 (*best);
	old_best = _tmp0_;
	_tmp1_ = current->symbol;
	if (VALA_IS_NAMESPACE (_tmp1_)) {
		{
			ValaArrayList* _child_list = NULL;
			ValaArrayList* _tmp2_;
			ValaArrayList* _tmp3_;
			gint _child_size = 0;
			ValaArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _child_index = 0;
			_tmp2_ = current->members;
			_tmp3_ = _vala_iterable_ref0 (_tmp2_);
			_child_list = _tmp3_;
			_tmp4_ = _child_list;
			_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_child_size = _tmp6_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				ValaGirParserNode* child = NULL;
				ValaArrayList* _tmp9_;
				gint _tmp10_;
				gpointer _tmp11_;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				ValaGirParserNode* _tmp14_;
				ValaSymbol* _tmp15_;
				_child_index = _child_index + 1;
				_tmp7_ = _child_index;
				_tmp8_ = _child_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _child_list;
				_tmp10_ = _child_index;
				_tmp11_ = vala_list_get ((ValaList*) _tmp9_, _tmp10_);
				child = (ValaGirParserNode*) _tmp11_;
				_tmp14_ = child;
				_tmp15_ = _tmp14_->symbol;
				if (_tmp15_ == NULL) {
					_tmp13_ = TRUE;
				} else {
					ValaGirParserNode* _tmp16_;
					ValaSymbol* _tmp17_;
					_tmp16_ = child;
					_tmp17_ = _tmp16_->symbol;
					_tmp13_ = vala_gir_parser_is_container (_tmp17_);
				}
				if (_tmp13_) {
					ValaGirParserNode* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp18_ = child;
					_tmp19_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp12_ = g_str_has_prefix (cname, _tmp20_);
					_g_free0 (_tmp20_);
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					ValaGirParserNode* _tmp21_;
					_tmp21_ = child;
					vala_gir_parser_find_parent (self, cname, _tmp21_, best, match);
				}
				_vala_gir_parser_node_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
	}
	_tmp22_ = old_best;
	if ((*best) != _tmp22_) {
		_vala_gir_parser_node_unref0 (old_best);
		return;
	}
	_tmp23_ = vala_gir_parser_node_get_lower_case_cprefix (current);
	_tmp24_ = _tmp23_;
	_tmp25_ = strlen (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_;
	_g_free0 (_tmp24_);
	current_match = _tmp27_;
	_tmp28_ = current_match;
	if (_tmp28_ > (*match)) {
		gint _tmp29_;
		ValaGirParserNode* _tmp30_;
		_tmp29_ = current_match;
		*match = _tmp29_;
		_tmp30_ = _vala_gir_parser_node_ref0 (current);
		_vala_gir_parser_node_unref0 (*best);
		*best = _tmp30_;
	}
	_vala_gir_parser_node_unref0 (old_best);
}


static gboolean
vala_gir_parser_same_gir (ValaGirParser* self,
                          ValaSymbol* gir_component,
                          ValaSymbol* sym)
{
	gboolean result = FALSE;
	gchar* gir_name = NULL;
	ValaSourceReference* _tmp0_;
	ValaSourceReference* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* gir_version = NULL;
	ValaSourceReference* _tmp7_;
	ValaSourceReference* _tmp8_;
	ValaSourceFile* _tmp9_;
	ValaSourceFile* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSourceFile* _tmp16_;
	ValaSourceFile* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gboolean _tmp22_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (gir_component != NULL, FALSE);
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_source_reference_get_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_source_file_get_gir_namespace (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	gir_name = _tmp6_;
	_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) gir_component);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_source_reference_get_file (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_source_file_get_gir_version (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	gir_version = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) sym);
	_tmp15_ = _tmp14_;
	_tmp16_ = vala_source_reference_get_file (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_source_file_get_filename (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strdup_printf ("%s-%s", gir_name, gir_version);
	_tmp21_ = _tmp20_;
	_tmp22_ = string_contains (_tmp19_, _tmp21_);
	_g_free0 (_tmp21_);
	result = _tmp22_;
	_g_free0 (gir_version);
	_g_free0 (gir_name);
	return result;
}


static void
vala_gir_parser_process_namespace_method (ValaGirParser* self,
                                          ValaGirParserNode* ns,
                                          ValaGirParserNode* node)
{
	gchar* ns_cprefix = NULL;
	gchar* _tmp0_;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	gchar* cname = NULL;
	gchar* _tmp3_;
	ValaParameter* first_param = NULL;
	ValaList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaParameter* _tmp14_;
	gint match = 0;
	ValaGirParserNode* parent = NULL;
	ValaGirParserNode* _tmp73_;
	const gchar* _tmp74_;
	gchar* new_name = NULL;
	ValaMethod* _tmp75_;
	const gchar* _tmp76_;
	const gchar* _tmp77_;
	ValaGirParserNode* _tmp78_;
	gchar* _tmp79_;
	gchar* _tmp80_;
	gint _tmp81_;
	gint _tmp82_;
	const gchar* _tmp83_;
	gint _tmp84_;
	gint _tmp85_;
	gchar* _tmp86_;
	gchar* _tmp87_;
	gboolean _tmp88_ = FALSE;
	ValaMethod* _tmp89_;
	ValaGirParserNode* _tmp90_;
	ValaSymbol* _tmp91_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ns != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_gir_parser_node_get_lower_case_cprefix (ns);
	ns_cprefix = _tmp0_;
	_tmp1_ = node->symbol;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_METHOD, ValaMethod));
	method = _tmp2_;
	_tmp3_ = vala_gir_parser_node_get_cname (node);
	cname = _tmp3_;
	first_param = NULL;
	_tmp4_ = node->parameters;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ > 0) {
		ValaList* _tmp7_;
		gpointer _tmp8_;
		ValaGirParserParameterInfo* _tmp9_;
		ValaParameter* _tmp10_;
		ValaParameter* _tmp11_;
		_tmp7_ = node->parameters;
		_tmp8_ = vala_list_get (_tmp7_, 0);
		_tmp9_ = (ValaGirParserParameterInfo*) _tmp8_;
		_tmp10_ = _tmp9_->param;
		_tmp11_ = _vala_code_node_ref0 (_tmp10_);
		_vala_code_node_unref0 (first_param);
		first_param = _tmp11_;
		_vala_gir_parser_parameter_info_unref0 (_tmp9_);
	}
	_tmp14_ = first_param;
	if (_tmp14_ != NULL) {
		ValaParameter* _tmp15_;
		ValaParameterDirection _tmp16_;
		ValaParameterDirection _tmp17_;
		_tmp15_ = first_param;
		_tmp16_ = vala_parameter_get_direction (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ == VALA_PARAMETER_DIRECTION_IN;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaParameter* _tmp18_;
		ValaDataType* _tmp19_;
		ValaDataType* _tmp20_;
		_tmp18_ = first_param;
		_tmp19_ = vala_variable_get_variable_type ((ValaVariable*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp12_ = VALA_IS_UNRESOLVED_TYPE (_tmp20_);
	} else {
		_tmp12_ = FALSE;
	}
	if (_tmp12_) {
		ValaUnresolvedSymbol* sym = NULL;
		ValaParameter* _tmp21_;
		ValaDataType* _tmp22_;
		ValaDataType* _tmp23_;
		ValaUnresolvedSymbol* _tmp24_;
		ValaUnresolvedSymbol* _tmp25_;
		ValaUnresolvedSymbol* _tmp26_;
		ValaGirParserNode* parent = NULL;
		ValaUnresolvedSymbol* _tmp27_;
		ValaGirParserNode* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		gboolean _tmp32_ = FALSE;
		ValaGirParserNode* _tmp33_;
		_tmp21_ = first_param;
		_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
		_tmp25_ = _tmp24_;
		_tmp26_ = _vala_code_node_ref0 (_tmp25_);
		sym = _tmp26_;
		_tmp27_ = sym;
		_tmp28_ = vala_gir_parser_resolve_node (self, ns, _tmp27_, FALSE);
		parent = _tmp28_;
		_tmp33_ = parent;
		if (_tmp33_ != NULL) {
			ValaMethod* _tmp34_;
			ValaGirParserNode* _tmp35_;
			ValaSymbol* _tmp36_;
			_tmp34_ = method;
			_tmp35_ = parent;
			_tmp36_ = _tmp35_->symbol;
			_tmp32_ = vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp34_, _tmp36_);
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			ValaGirParserNode* _tmp37_;
			ValaGirParserNode* _tmp38_;
			_tmp37_ = parent;
			_tmp38_ = _tmp37_->parent;
			_tmp31_ = _tmp38_ == ns;
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			ValaGirParserNode* _tmp39_;
			ValaSymbol* _tmp40_;
			_tmp39_ = parent;
			_tmp40_ = _tmp39_->symbol;
			_tmp30_ = vala_gir_parser_is_container (_tmp40_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			const gchar* _tmp41_;
			ValaGirParserNode* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			_tmp41_ = cname;
			_tmp42_ = parent;
			_tmp43_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp29_ = g_str_has_prefix (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
		} else {
			_tmp29_ = FALSE;
		}
		if (_tmp29_) {
			gchar* new_name = NULL;
			ValaMethod* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			ValaGirParserNode* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			gint _tmp51_;
			gint _tmp52_;
			const gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			ValaGirParserNode* _tmp58_;
			const gchar* _tmp59_;
			ValaGirParserNode* _tmp60_;
			ValaGirParserNode* _tmp61_;
			gboolean _tmp62_;
			_tmp45_ = method;
			_tmp46_ = vala_symbol_get_name ((ValaSymbol*) _tmp45_);
			_tmp47_ = _tmp46_;
			_tmp48_ = parent;
			_tmp49_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = strlen (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = ns_cprefix;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = string_substring (_tmp47_, (glong) (_tmp52_ - _tmp55_), (glong) -1);
			_tmp57_ = _tmp56_;
			_g_free0 (_tmp50_);
			new_name = _tmp57_;
			_tmp58_ = parent;
			_tmp59_ = new_name;
			_tmp60_ = vala_gir_parser_node_lookup (_tmp58_, _tmp59_, FALSE, NULL);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_ == NULL;
			_vala_gir_parser_node_unref0 (_tmp61_);
			if (_tmp62_) {
				const gchar* _tmp63_;
				gchar* _tmp64_;
				ValaList* _tmp65_;
				gpointer _tmp66_;
				ValaGirParserParameterInfo* _tmp67_;
				gint _tmp68_;
				ValaMethod* _tmp69_;
				const gchar* _tmp70_;
				ValaMethod* _tmp71_;
				ValaGirParserNode* _tmp72_;
				vala_gir_parser_node_remove_member (ns, node);
				_tmp63_ = new_name;
				_tmp64_ = g_strdup (_tmp63_);
				_g_free0 (node->name);
				node->name = _tmp64_;
				_tmp65_ = node->parameters;
				_tmp66_ = vala_list_remove_at (_tmp65_, 0);
				_tmp67_ = (ValaGirParserParameterInfo*) _tmp66_;
				_vala_gir_parser_parameter_info_unref0 (_tmp67_);
				_tmp68_ = node->return_array_length_idx;
				node->return_array_length_idx = _tmp68_ - 1;
				_tmp69_ = method;
				_tmp70_ = new_name;
				vala_symbol_set_name ((ValaSymbol*) _tmp69_, _tmp70_);
				_tmp71_ = method;
				vala_method_set_binding (_tmp71_, VALA_MEMBER_BINDING_INSTANCE);
				_tmp72_ = parent;
				vala_gir_parser_node_add_member (_tmp72_, node);
			}
			_g_free0 (new_name);
			_vala_gir_parser_node_unref0 (parent);
			_vala_code_node_unref0 (sym);
			_vala_code_node_unref0 (first_param);
			_g_free0 (cname);
			_vala_code_node_unref0 (method);
			_g_free0 (ns_cprefix);
			return;
		}
		_vala_gir_parser_node_unref0 (parent);
		_vala_code_node_unref0 (sym);
	}
	match = 0;
	_tmp73_ = _vala_gir_parser_node_ref0 (ns);
	parent = _tmp73_;
	_tmp74_ = cname;
	vala_gir_parser_find_parent (self, _tmp74_, ns, &parent, &match);
	_tmp75_ = method;
	_tmp76_ = vala_symbol_get_name ((ValaSymbol*) _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = parent;
	_tmp79_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp78_);
	_tmp80_ = _tmp79_;
	_tmp81_ = strlen (_tmp80_);
	_tmp82_ = _tmp81_;
	_tmp83_ = ns_cprefix;
	_tmp84_ = strlen (_tmp83_);
	_tmp85_ = _tmp84_;
	_tmp86_ = string_substring (_tmp77_, (glong) (_tmp82_ - _tmp85_), (glong) -1);
	_tmp87_ = _tmp86_;
	_g_free0 (_tmp80_);
	new_name = _tmp87_;
	_tmp89_ = method;
	_tmp90_ = parent;
	_tmp91_ = _tmp90_->symbol;
	if (vala_gir_parser_same_gir (self, (ValaSymbol*) _tmp89_, _tmp91_)) {
		ValaGirParserNode* _tmp92_;
		const gchar* _tmp93_;
		ValaGirParserNode* _tmp94_;
		ValaGirParserNode* _tmp95_;
		_tmp92_ = parent;
		_tmp93_ = new_name;
		_tmp94_ = vala_gir_parser_node_lookup (_tmp92_, _tmp93_, FALSE, NULL);
		_tmp95_ = _tmp94_;
		_tmp88_ = _tmp95_ == NULL;
		_vala_gir_parser_node_unref0 (_tmp95_);
	} else {
		_tmp88_ = FALSE;
	}
	if (_tmp88_) {
		const gchar* _tmp96_;
		gchar* _tmp97_;
		ValaMethod* _tmp98_;
		const gchar* _tmp99_;
		ValaGirParserNode* _tmp100_;
		vala_gir_parser_node_remove_member (ns, node);
		_tmp96_ = new_name;
		_tmp97_ = g_strdup (_tmp96_);
		_g_free0 (node->name);
		node->name = _tmp97_;
		_tmp98_ = method;
		_tmp99_ = new_name;
		vala_symbol_set_name ((ValaSymbol*) _tmp98_, _tmp99_);
		_tmp100_ = parent;
		vala_gir_parser_node_add_member (_tmp100_, node);
	}
	_g_free0 (new_name);
	_vala_gir_parser_node_unref0 (parent);
	_vala_code_node_unref0 (first_param);
	_g_free0 (cname);
	_vala_code_node_unref0 (method);
	_g_free0 (ns_cprefix);
}


static void
vala_gir_parser_process_virtual_method_field (ValaGirParser* self,
                                              ValaGirParserNode* node,
                                              ValaDelegate* d,
                                              ValaUnresolvedSymbol* gtype_struct_for)
{
	ValaGirParserNode* gtype_node = NULL;
	ValaGirParserNode* _tmp0_;
	ValaGirParserNode* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaGirParserNode* _tmp3_;
	ValaArrayList* nodes = NULL;
	ValaGirParserNode* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (d != NULL);
	g_return_if_fail (gtype_struct_for != NULL);
	_tmp0_ = node->parent;
	_tmp1_ = vala_gir_parser_resolve_node (self, _tmp0_, gtype_struct_for, FALSE);
	gtype_node = _tmp1_;
	_tmp3_ = gtype_node;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaSymbol* _tmp5_;
		_tmp4_ = gtype_node;
		_tmp5_ = _tmp4_->symbol;
		_tmp2_ = !VALA_IS_OBJECT_TYPE_SYMBOL (_tmp5_);
	}
	if (_tmp2_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) gtype_struct_for);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_to_string ((ValaCodeNode*) gtype_struct_for);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_gir_parser_node_to_string (node);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup_printf ("Unknown symbol `%s' for virtual method field `%s'", _tmp9_, _tmp11_);
		_tmp13_ = _tmp12_;
		vala_report_error (_tmp7_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
	}
	_tmp14_ = gtype_node;
	_tmp15_ = vala_symbol_get_name ((ValaSymbol*) d);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_gir_parser_node_lookup_all (_tmp14_, _tmp16_);
	nodes = _tmp17_;
	_tmp18_ = nodes;
	if (_tmp18_ == NULL) {
		_vala_iterable_unref0 (nodes);
		_vala_gir_parser_node_unref0 (gtype_node);
		return;
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp19_;
		ValaArrayList* _tmp20_;
		gint _n_size = 0;
		ValaArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _n_index = 0;
		_tmp19_ = nodes;
		_tmp20_ = _vala_iterable_ref0 (_tmp19_);
		_n_list = _tmp20_;
		_tmp21_ = _n_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_n_size = _tmp23_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaGirParserNode* _tmp29_;
			_n_index = _n_index + 1;
			_tmp24_ = _n_index;
			_tmp25_ = _n_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _n_list;
			_tmp27_ = _n_index;
			_tmp28_ = vala_list_get ((ValaList*) _tmp26_, _tmp27_);
			n = (ValaGirParserNode*) _tmp28_;
			_tmp29_ = n;
			if (node != _tmp29_) {
				ValaGirParserNode* _tmp30_;
				_tmp30_ = n;
				vala_gir_parser_node_process (_tmp30_, self);
			}
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	{
		ValaArrayList* _n_list = NULL;
		ValaArrayList* _tmp31_;
		ValaArrayList* _tmp32_;
		gint _n_size = 0;
		ValaArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _n_index = 0;
		_tmp31_ = nodes;
		_tmp32_ = _vala_iterable_ref0 (_tmp31_);
		_n_list = _tmp32_;
		_tmp33_ = _n_list;
		_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_n_size = _tmp35_;
		_n_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			ValaGirParserNode* n = NULL;
			ValaArrayList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaGirParserNode* _tmp41_;
			gboolean _tmp42_;
			ValaSymbol* sym = NULL;
			ValaGirParserNode* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaSymbol* _tmp46_;
			_n_index = _n_index + 1;
			_tmp36_ = _n_index;
			_tmp37_ = _n_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _n_list;
			_tmp39_ = _n_index;
			_tmp40_ = vala_list_get ((ValaList*) _tmp38_, _tmp39_);
			n = (ValaGirParserNode*) _tmp40_;
			_tmp41_ = n;
			_tmp42_ = _tmp41_->merged;
			if (_tmp42_) {
				_vala_gir_parser_node_unref0 (n);
				continue;
			}
			_tmp43_ = n;
			_tmp44_ = _tmp43_->symbol;
			_tmp45_ = _vala_code_node_ref0 (_tmp44_);
			sym = _tmp45_;
			_tmp46_ = sym;
			if (VALA_IS_SIGNAL (_tmp46_)) {
				ValaSignal* sig = NULL;
				ValaSymbol* _tmp47_;
				ValaSignal* _tmp48_;
				ValaSignal* _tmp49_;
				ValaSignal* _tmp50_;
				_tmp47_ = sym;
				_tmp48_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp47_, VALA_TYPE_SIGNAL, ValaSignal));
				sig = _tmp48_;
				_tmp49_ = sig;
				vala_signal_set_is_virtual (_tmp49_, TRUE);
				_tmp50_ = sig;
				vala_gir_parser_assume_parameter_names (self, _tmp50_, (ValaSymbol*) d, TRUE);
				_vala_code_node_unref0 (sig);
			} else {
				ValaSymbol* _tmp51_;
				_tmp51_ = sym;
				if (VALA_IS_PROPERTY (_tmp51_)) {
					ValaProperty* prop = NULL;
					ValaSymbol* _tmp52_;
					ValaProperty* _tmp53_;
					ValaProperty* _tmp54_;
					_tmp52_ = sym;
					_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp52_, VALA_TYPE_PROPERTY, ValaProperty));
					prop = _tmp53_;
					_tmp54_ = prop;
					vala_property_set_is_virtual (_tmp54_, TRUE);
					_vala_code_node_unref0 (prop);
				}
			}
			_vala_code_node_unref0 (sym);
			_vala_gir_parser_node_unref0 (n);
		}
		_vala_iterable_unref0 (_n_list);
	}
	_vala_iterable_unref0 (nodes);
	_vala_gir_parser_node_unref0 (gtype_node);
}


static void
vala_gir_parser_process_async_method (ValaGirParser* self,
                                      ValaGirParserNode* node)
{
	ValaMethod* m = NULL;
	ValaSymbol* _tmp0_;
	ValaMethod* _tmp1_;
	gboolean requires_pointer = FALSE;
	gchar* finish_method_base = NULL;
	ValaMethod* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	ValaGirParserNode* finish_method_node = NULL;
	ValaGirParserNode* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	ValaGirParserNode* _tmp56_;
	ValaGirParserNode* _tmp57_;
	ValaGirParserNode* _tmp58_;
	ValaMethod* method = NULL;
	ValaMethod* _tmp80_;
	ValaMethod* _tmp81_;
	gboolean _tmp82_ = FALSE;
	ValaGirParserNode* _tmp83_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node->symbol;
	_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, VALA_TYPE_METHOD, ValaMethod));
	m = _tmp1_;
	requires_pointer = FALSE;
	{
		ValaList* _param_list = NULL;
		ValaMethod* _tmp2_;
		ValaList* _tmp3_;
		gint _param_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _param_index = 0;
		_tmp2_ = m;
		_tmp3_ = vala_callable_get_parameters ((ValaCallable*) _tmp2_);
		_param_list = _tmp3_;
		_tmp4_ = _param_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_param_size = _tmp6_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaParameter* param = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameterDirection _tmp13_;
			ValaParameterDirection _tmp14_;
			_param_index = _param_index + 1;
			_tmp7_ = _param_index;
			_tmp8_ = _param_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _param_list;
			_tmp10_ = _param_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			param = (ValaParameter*) _tmp11_;
			_tmp12_ = param;
			_tmp13_ = vala_parameter_get_direction (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == VALA_PARAMETER_DIRECTION_IN) {
				requires_pointer = TRUE;
			} else {
				gboolean _tmp15_;
				_tmp15_ = requires_pointer;
				if (_tmp15_) {
					ValaParameter* _tmp16_;
					ValaParameter* _tmp17_;
					ValaDataType* _tmp18_;
					ValaDataType* _tmp19_;
					ValaParameter* _tmp20_;
					ValaParameter* _tmp21_;
					ValaDataType* _tmp22_;
					ValaDataType* _tmp23_;
					ValaPointerType* _tmp24_;
					ValaPointerType* _tmp25_;
					ValaParameter* _tmp26_;
					ValaSourceReference* _tmp27_;
					ValaSourceReference* _tmp28_;
					_tmp16_ = param;
					vala_parameter_set_direction (_tmp16_, VALA_PARAMETER_DIRECTION_IN);
					_tmp17_ = param;
					_tmp18_ = vala_variable_get_variable_type ((ValaVariable*) _tmp17_);
					_tmp19_ = _tmp18_;
					vala_data_type_set_nullable (_tmp19_, FALSE);
					_tmp20_ = param;
					_tmp21_ = param;
					_tmp22_ = vala_variable_get_variable_type ((ValaVariable*) _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = vala_pointer_type_new (_tmp23_, NULL);
					_tmp25_ = _tmp24_;
					vala_variable_set_variable_type ((ValaVariable*) _tmp20_, (ValaDataType*) _tmp25_);
					_vala_code_node_unref0 (_tmp25_);
					_tmp26_ = param;
					_tmp27_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp26_);
					_tmp28_ = _tmp27_;
					vala_report_warning (_tmp28_, "Synchronous out-parameters are not supported in async methods");
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp29_ = m;
	_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
	_tmp31_ = _tmp30_;
	if (_tmp31_ == NULL) {
		ValaMethod* _tmp32_;
		gchar* _tmp33_;
		_tmp32_ = m;
		_vala_assert (VALA_IS_CREATION_METHOD (_tmp32_), "m is CreationMethod");
		_tmp33_ = g_strdup ("new");
		_g_free0 (finish_method_base);
		finish_method_base = _tmp33_;
	} else {
		ValaMethod* _tmp34_;
		const gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp34_ = m;
		_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
		_tmp36_ = _tmp35_;
		if (g_str_has_suffix (_tmp36_, "_async")) {
			ValaMethod* _tmp37_;
			const gchar* _tmp38_;
			const gchar* _tmp39_;
			ValaMethod* _tmp40_;
			const gchar* _tmp41_;
			const gchar* _tmp42_;
			gint _tmp43_;
			gint _tmp44_;
			gint _tmp45_;
			gint _tmp46_;
			gchar* _tmp47_;
			_tmp37_ = m;
			_tmp38_ = vala_symbol_get_name ((ValaSymbol*) _tmp37_);
			_tmp39_ = _tmp38_;
			_tmp40_ = m;
			_tmp41_ = vala_symbol_get_name ((ValaSymbol*) _tmp40_);
			_tmp42_ = _tmp41_;
			_tmp43_ = strlen (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = strlen ("_async");
			_tmp46_ = _tmp45_;
			_tmp47_ = string_substring (_tmp39_, (glong) 0, (glong) (_tmp44_ - _tmp46_));
			_g_free0 (finish_method_base);
			finish_method_base = _tmp47_;
		} else {
			ValaMethod* _tmp48_;
			const gchar* _tmp49_;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp48_ = m;
			_tmp49_ = vala_symbol_get_name ((ValaSymbol*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = g_strdup (_tmp50_);
			_g_free0 (finish_method_base);
			finish_method_base = _tmp51_;
		}
	}
	_tmp52_ = node->parent;
	_tmp53_ = finish_method_base;
	_tmp54_ = g_strconcat (_tmp53_, "_finish", NULL);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_gir_parser_node_lookup (_tmp52_, _tmp55_, FALSE, NULL);
	_tmp57_ = _tmp56_;
	_g_free0 (_tmp55_);
	finish_method_node = _tmp57_;
	_tmp58_ = finish_method_node;
	if (_tmp58_ == NULL) {
		gchar* method_cname = NULL;
		gchar* _tmp59_;
		_tmp59_ = vala_gir_parser_node_get_finish_cname (node);
		method_cname = _tmp59_;
		{
			ValaArrayList* _n_list = NULL;
			ValaGirParserNode* _tmp60_;
			ValaArrayList* _tmp61_;
			ValaArrayList* _tmp62_;
			gint _n_size = 0;
			ValaArrayList* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gint _n_index = 0;
			_tmp60_ = node->parent;
			_tmp61_ = _tmp60_->members;
			_tmp62_ = _vala_iterable_ref0 (_tmp61_);
			_n_list = _tmp62_;
			_tmp63_ = _n_list;
			_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
			_tmp65_ = _tmp64_;
			_n_size = _tmp65_;
			_n_index = -1;
			while (TRUE) {
				gint _tmp66_;
				gint _tmp67_;
				ValaGirParserNode* n = NULL;
				ValaArrayList* _tmp68_;
				gint _tmp69_;
				gpointer _tmp70_;
				gboolean _tmp71_ = FALSE;
				ValaGirParserNode* _tmp72_;
				ValaSymbol* _tmp73_;
				_n_index = _n_index + 1;
				_tmp66_ = _n_index;
				_tmp67_ = _n_size;
				if (!(_tmp66_ < _tmp67_)) {
					break;
				}
				_tmp68_ = _n_list;
				_tmp69_ = _n_index;
				_tmp70_ = vala_list_get ((ValaList*) _tmp68_, _tmp69_);
				n = (ValaGirParserNode*) _tmp70_;
				_tmp72_ = n;
				_tmp73_ = _tmp72_->symbol;
				if (VALA_IS_METHOD (_tmp73_)) {
					ValaGirParserNode* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					const gchar* _tmp77_;
					_tmp74_ = n;
					_tmp75_ = vala_gir_parser_node_get_cname (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = method_cname;
					_tmp71_ = g_strcmp0 (_tmp76_, _tmp77_) == 0;
					_g_free0 (_tmp76_);
				} else {
					_tmp71_ = FALSE;
				}
				if (_tmp71_) {
					ValaGirParserNode* _tmp78_;
					ValaGirParserNode* _tmp79_;
					_tmp78_ = n;
					_tmp79_ = _vala_gir_parser_node_ref0 (_tmp78_);
					_vala_gir_parser_node_unref0 (finish_method_node);
					finish_method_node = _tmp79_;
					_vala_gir_parser_node_unref0 (n);
					break;
				}
				_vala_gir_parser_node_unref0 (n);
			}
			_vala_iterable_unref0 (_n_list);
		}
		_g_free0 (method_cname);
	}
	_tmp80_ = m;
	_tmp81_ = _vala_code_node_ref0 (_tmp80_);
	method = _tmp81_;
	_tmp83_ = finish_method_node;
	if (_tmp83_ != NULL) {
		ValaGirParserNode* _tmp84_;
		ValaSymbol* _tmp85_;
		_tmp84_ = finish_method_node;
		_tmp85_ = _tmp84_->symbol;
		_tmp82_ = VALA_IS_METHOD (_tmp85_);
	} else {
		_tmp82_ = FALSE;
	}
	if (_tmp82_) {
		ValaGirParserNode* _tmp86_;
		ValaMethod* finish_method = NULL;
		ValaGirParserNode* _tmp87_;
		ValaSymbol* _tmp88_;
		ValaMethod* _tmp89_;
		ValaMethod* _tmp90_;
		ValaMethod* _tmp164_;
		ValaMethod* _tmp165_;
		ValaGirParserNode* _tmp212_;
		ValaGirParserNode* _tmp213_;
		_tmp86_ = finish_method_node;
		vala_gir_parser_node_process (_tmp86_, self);
		_tmp87_ = finish_method_node;
		_tmp88_ = _tmp87_->symbol;
		_tmp89_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_METHOD, ValaMethod));
		finish_method = _tmp89_;
		_tmp90_ = finish_method;
		if (VALA_IS_CREATION_METHOD (_tmp90_)) {
			ValaMethod* _tmp91_;
			const gchar* _tmp92_;
			const gchar* _tmp93_;
			ValaMethod* _tmp94_;
			ValaSourceReference* _tmp95_;
			ValaSourceReference* _tmp96_;
			ValaCreationMethod* _tmp97_;
			ValaMethod* _tmp98_;
			ValaMethod* _tmp99_;
			ValaSymbolAccessibility _tmp100_;
			ValaSymbolAccessibility _tmp101_;
			ValaMethod* _tmp102_;
			ValaMethod* _tmp103_;
			ValaMemberBinding _tmp104_;
			ValaMemberBinding _tmp105_;
			ValaMethod* _tmp106_;
			ValaMethod* _tmp107_;
			ValaMethod* _tmp108_;
			ValaMethod* _tmp109_;
			gboolean _tmp110_;
			gboolean _tmp111_;
			ValaMethod* _tmp112_;
			GList* _tmp113_;
			ValaMethod* _tmp118_;
			gchar* _tmp119_;
			gchar* _tmp120_;
			const gchar* _tmp121_;
			ValaMethod* _tmp144_;
			ValaSymbol* _tmp145_;
			_tmp91_ = finish_method;
			_tmp92_ = vala_creation_method_get_class_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp91_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			_tmp93_ = _tmp92_;
			_tmp94_ = m;
			_tmp95_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp94_);
			_tmp96_ = _tmp95_;
			_tmp97_ = vala_creation_method_new (_tmp93_, NULL, _tmp96_, NULL);
			_vala_code_node_unref0 (method);
			method = (ValaMethod*) _tmp97_;
			_tmp98_ = method;
			_tmp99_ = m;
			_tmp100_ = vala_symbol_get_access ((ValaSymbol*) _tmp99_);
			_tmp101_ = _tmp100_;
			vala_symbol_set_access ((ValaSymbol*) _tmp98_, _tmp101_);
			_tmp102_ = method;
			_tmp103_ = m;
			_tmp104_ = vala_method_get_binding (_tmp103_);
			_tmp105_ = _tmp104_;
			vala_method_set_binding (_tmp102_, _tmp105_);
			_tmp106_ = method;
			vala_symbol_set_external ((ValaSymbol*) _tmp106_, TRUE);
			_tmp107_ = method;
			vala_method_set_coroutine (_tmp107_, TRUE);
			_tmp108_ = method;
			_tmp109_ = finish_method;
			_tmp110_ = vala_method_get_has_construct_function (_tmp109_);
			_tmp111_ = _tmp110_;
			vala_method_set_has_construct_function (_tmp108_, _tmp111_);
			_tmp112_ = m;
			_tmp113_ = ((ValaCodeNode*) _tmp112_)->attributes;
			{
				GList* a_collection = NULL;
				GList* a_it = NULL;
				a_collection = _tmp113_;
				for (a_it = a_collection; a_it != NULL; a_it = a_it->next) {
					ValaAttribute* _tmp114_;
					ValaAttribute* a = NULL;
					_tmp114_ = _vala_code_node_ref0 ((ValaAttribute*) a_it->data);
					a = _tmp114_;
					{
						ValaMethod* _tmp115_;
						ValaAttribute* _tmp116_;
						ValaAttribute* _tmp117_;
						_tmp115_ = method;
						_tmp116_ = a;
						_tmp117_ = _vala_code_node_ref0 (_tmp116_);
						((ValaCodeNode*) _tmp115_)->attributes = g_list_append (((ValaCodeNode*) _tmp115_)->attributes, _tmp117_);
						_vala_code_node_unref0 (a);
					}
				}
			}
			_tmp118_ = method;
			_tmp119_ = vala_gir_parser_node_get_cname (node);
			_tmp120_ = _tmp119_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp118_, "CCode", "cname", _tmp120_, NULL);
			_g_free0 (_tmp120_);
			_tmp121_ = finish_method_base;
			if (g_strcmp0 (_tmp121_, "new") == 0) {
				ValaMethod* _tmp122_;
				_tmp122_ = method;
				vala_symbol_set_name ((ValaSymbol*) _tmp122_, NULL);
			} else {
				const gchar* _tmp123_;
				_tmp123_ = finish_method_base;
				if (g_str_has_prefix (_tmp123_, "new_")) {
					ValaMethod* _tmp124_;
					ValaMethod* _tmp125_;
					const gchar* _tmp126_;
					const gchar* _tmp127_;
					gint _tmp128_;
					gint _tmp129_;
					gchar* _tmp130_;
					gchar* _tmp131_;
					_tmp124_ = method;
					_tmp125_ = m;
					_tmp126_ = vala_symbol_get_name ((ValaSymbol*) _tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = strlen ("new_");
					_tmp129_ = _tmp128_;
					_tmp130_ = string_substring (_tmp127_, (glong) _tmp129_, (glong) -1);
					_tmp131_ = _tmp130_;
					vala_symbol_set_name ((ValaSymbol*) _tmp124_, _tmp131_);
					_g_free0 (_tmp131_);
				}
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp132_;
				ValaList* _tmp133_;
				gint _param_size = 0;
				ValaList* _tmp134_;
				gint _tmp135_;
				gint _tmp136_;
				gint _param_index = 0;
				_tmp132_ = m;
				_tmp133_ = vala_callable_get_parameters ((ValaCallable*) _tmp132_);
				_param_list = _tmp133_;
				_tmp134_ = _param_list;
				_tmp135_ = vala_collection_get_size ((ValaCollection*) _tmp134_);
				_tmp136_ = _tmp135_;
				_param_size = _tmp136_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp137_;
					gint _tmp138_;
					ValaParameter* param = NULL;
					ValaList* _tmp139_;
					gint _tmp140_;
					gpointer _tmp141_;
					ValaMethod* _tmp142_;
					ValaParameter* _tmp143_;
					_param_index = _param_index + 1;
					_tmp137_ = _param_index;
					_tmp138_ = _param_size;
					if (!(_tmp137_ < _tmp138_)) {
						break;
					}
					_tmp139_ = _param_list;
					_tmp140_ = _param_index;
					_tmp141_ = vala_list_get (_tmp139_, _tmp140_);
					param = (ValaParameter*) _tmp141_;
					_tmp142_ = method;
					_tmp143_ = param;
					vala_callable_add_parameter ((ValaCallable*) _tmp142_, _tmp143_);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp144_ = method;
			_tmp145_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp144_);
			_vala_code_node_unref0 (node->symbol);
			node->symbol = _tmp145_;
		} else {
			ValaMethod* _tmp146_;
			ValaMethod* _tmp147_;
			ValaDataType* _tmp148_;
			ValaDataType* _tmp149_;
			ValaDataType* _tmp150_;
			ValaDataType* _tmp151_;
			ValaAttribute* a = NULL;
			ValaMethod* _tmp152_;
			ValaAttribute* _tmp153_;
			gboolean _tmp154_ = FALSE;
			ValaAttribute* _tmp155_;
			gboolean _tmp159_ = FALSE;
			ValaAttribute* _tmp160_;
			_tmp146_ = method;
			_tmp147_ = finish_method;
			_tmp148_ = vala_callable_get_return_type ((ValaCallable*) _tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = vala_data_type_copy (_tmp149_);
			_tmp151_ = _tmp150_;
			vala_callable_set_return_type ((ValaCallable*) _tmp146_, _tmp151_);
			_vala_code_node_unref0 (_tmp151_);
			_tmp152_ = finish_method;
			_tmp153_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp152_, "CCode");
			a = _tmp153_;
			_tmp155_ = a;
			if (_tmp155_ != NULL) {
				ValaAttribute* _tmp156_;
				_tmp156_ = a;
				_tmp154_ = vala_attribute_has_argument (_tmp156_, "array_length");
			} else {
				_tmp154_ = FALSE;
			}
			if (_tmp154_) {
				ValaMethod* _tmp157_;
				ValaAttribute* _tmp158_;
				_tmp157_ = method;
				_tmp158_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp157_, "CCode", "array_length", vala_attribute_get_bool (_tmp158_, "array_length", FALSE), NULL);
			}
			_tmp160_ = a;
			if (_tmp160_ != NULL) {
				ValaAttribute* _tmp161_;
				_tmp161_ = a;
				_tmp159_ = vala_attribute_has_argument (_tmp161_, "array_null_terminated");
			} else {
				_tmp159_ = FALSE;
			}
			if (_tmp159_) {
				ValaMethod* _tmp162_;
				ValaAttribute* _tmp163_;
				_tmp162_ = method;
				_tmp163_ = a;
				vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp162_, "CCode", "array_null_terminated", vala_attribute_get_bool (_tmp163_, "array_null_terminated", FALSE), NULL);
			}
			_vala_code_node_unref0 (a);
		}
		_tmp164_ = method;
		_tmp165_ = finish_method;
		vala_code_node_copy_attribute_double ((ValaCodeNode*) _tmp164_, (ValaCodeNode*) _tmp165_, "CCode", "async_result_pos");
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp166_;
			ValaList* _tmp167_;
			gint _param_size = 0;
			ValaList* _tmp168_;
			gint _tmp169_;
			gint _tmp170_;
			gint _param_index = 0;
			_tmp166_ = finish_method;
			_tmp167_ = vala_callable_get_parameters ((ValaCallable*) _tmp166_);
			_param_list = _tmp167_;
			_tmp168_ = _param_list;
			_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
			_tmp170_ = _tmp169_;
			_param_size = _tmp170_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp171_;
				gint _tmp172_;
				ValaParameter* param = NULL;
				ValaList* _tmp173_;
				gint _tmp174_;
				gpointer _tmp175_;
				ValaParameter* _tmp176_;
				ValaParameterDirection _tmp177_;
				ValaParameterDirection _tmp178_;
				_param_index = _param_index + 1;
				_tmp171_ = _param_index;
				_tmp172_ = _param_size;
				if (!(_tmp171_ < _tmp172_)) {
					break;
				}
				_tmp173_ = _param_list;
				_tmp174_ = _param_index;
				_tmp175_ = vala_list_get (_tmp173_, _tmp174_);
				param = (ValaParameter*) _tmp175_;
				_tmp176_ = param;
				_tmp177_ = vala_parameter_get_direction (_tmp176_);
				_tmp178_ = _tmp177_;
				if (_tmp178_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaParameter* async_param = NULL;
					ValaParameter* _tmp179_;
					ValaParameter* _tmp180_;
					ValaMethod* _tmp181_;
					ValaScope* _tmp182_;
					ValaScope* _tmp183_;
					ValaParameter* _tmp184_;
					const gchar* _tmp185_;
					const gchar* _tmp186_;
					ValaSymbol* _tmp187_;
					ValaSymbol* _tmp188_;
					gboolean _tmp189_;
					ValaMethod* _tmp196_;
					ValaParameter* _tmp197_;
					_tmp179_ = param;
					_tmp180_ = vala_parameter_copy (_tmp179_);
					async_param = _tmp180_;
					_tmp181_ = method;
					_tmp182_ = vala_symbol_get_scope ((ValaSymbol*) _tmp181_);
					_tmp183_ = _tmp182_;
					_tmp184_ = param;
					_tmp185_ = vala_symbol_get_name ((ValaSymbol*) _tmp184_);
					_tmp186_ = _tmp185_;
					_tmp187_ = vala_scope_lookup (_tmp183_, _tmp186_);
					_tmp188_ = _tmp187_;
					_tmp189_ = _tmp188_ != NULL;
					_vala_code_node_unref0 (_tmp188_);
					if (_tmp189_) {
						ValaParameter* _tmp190_;
						ValaParameter* _tmp191_;
						const gchar* _tmp192_;
						const gchar* _tmp193_;
						gchar* _tmp194_;
						gchar* _tmp195_;
						_tmp190_ = async_param;
						_tmp191_ = async_param;
						_tmp192_ = vala_symbol_get_name ((ValaSymbol*) _tmp191_);
						_tmp193_ = _tmp192_;
						_tmp194_ = g_strconcat (_tmp193_, "_out", NULL);
						_tmp195_ = _tmp194_;
						vala_symbol_set_name ((ValaSymbol*) _tmp191_, _tmp195_);
						_g_free0 (_tmp195_);
					}
					_tmp196_ = method;
					_tmp197_ = async_param;
					vala_callable_add_parameter ((ValaCallable*) _tmp196_, _tmp197_);
					_vala_code_node_unref0 (async_param);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp198_;
			ValaList* _tmp199_;
			gint _error_type_size = 0;
			ValaList* _tmp200_;
			gint _tmp201_;
			gint _tmp202_;
			gint _error_type_index = 0;
			_tmp198_ = finish_method;
			_tmp199_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp198_);
			_error_type_list = _tmp199_;
			_tmp200_ = _error_type_list;
			_tmp201_ = vala_collection_get_size ((ValaCollection*) _tmp200_);
			_tmp202_ = _tmp201_;
			_error_type_size = _tmp202_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp203_;
				gint _tmp204_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp205_;
				gint _tmp206_;
				gpointer _tmp207_;
				ValaMethod* _tmp208_;
				ValaDataType* _tmp209_;
				ValaDataType* _tmp210_;
				ValaDataType* _tmp211_;
				_error_type_index = _error_type_index + 1;
				_tmp203_ = _error_type_index;
				_tmp204_ = _error_type_size;
				if (!(_tmp203_ < _tmp204_)) {
					break;
				}
				_tmp205_ = _error_type_list;
				_tmp206_ = _error_type_index;
				_tmp207_ = vala_list_get (_tmp205_, _tmp206_);
				error_type = (ValaDataType*) _tmp207_;
				_tmp208_ = method;
				_tmp209_ = error_type;
				_tmp210_ = vala_data_type_copy (_tmp209_);
				_tmp211_ = _tmp210_;
				vala_code_node_add_error_type ((ValaCodeNode*) _tmp208_, _tmp211_);
				_vala_code_node_unref0 (_tmp211_);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_tmp212_ = finish_method_node;
		_tmp212_->processed = TRUE;
		_tmp213_ = finish_method_node;
		_tmp213_->merged = TRUE;
		_vala_code_node_unref0 (finish_method);
	}
	_vala_code_node_unref0 (method);
	_vala_gir_parser_node_unref0 (finish_method_node);
	_g_free0 (finish_method_base);
	_vala_code_node_unref0 (m);
}


static guint
vala_gir_parser_unresolved_symbol_hash (ValaUnresolvedSymbol* sym)
{
	guint result = 0U;
	GString* builder = NULL;
	GString* _tmp0_;
	GString* _tmp6_;
	const gchar* _tmp7_;
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	while (TRUE) {
		GString* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		ValaUnresolvedSymbol* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		if (!(sym != NULL)) {
			break;
		}
		_tmp1_ = builder;
		_tmp2_ = vala_symbol_get_name ((ValaSymbol*) sym);
		_tmp3_ = _tmp2_;
		g_string_append (_tmp1_, _tmp3_);
		_tmp4_ = vala_unresolved_symbol_get_inner (sym);
		_tmp5_ = _tmp4_;
		sym = _tmp5_;
	}
	_tmp6_ = builder;
	_tmp7_ = _tmp6_->str;
	result = g_str_hash (_tmp7_);
	_g_string_free0 (builder);
	return result;
}


static gboolean
vala_gir_parser_unresolved_symbol_equal (ValaUnresolvedSymbol* sym1,
                                         ValaUnresolvedSymbol* sym2)
{
	gboolean result = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		ValaUnresolvedSymbol* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		if (!(sym1 != sym2)) {
			break;
		}
		if (sym1 == NULL) {
			_tmp0_ = TRUE;
		} else {
			_tmp0_ = sym2 == NULL;
		}
		if (_tmp0_) {
			result = FALSE;
			return result;
		}
		_tmp1_ = vala_symbol_get_name ((ValaSymbol*) sym1);
		_tmp2_ = _tmp1_;
		_tmp3_ = vala_symbol_get_name ((ValaSymbol*) sym2);
		_tmp4_ = _tmp3_;
		if (g_strcmp0 (_tmp2_, _tmp4_) != 0) {
			result = FALSE;
			return result;
		}
		_tmp5_ = vala_unresolved_symbol_get_inner (sym1);
		_tmp6_ = _tmp5_;
		sym1 = _tmp6_;
		_tmp7_ = vala_unresolved_symbol_get_inner (sym2);
		_tmp8_ = _tmp7_;
		sym2 = _tmp8_;
	}
	result = TRUE;
	return result;
}


static ValaGirParserNode*
vala_gir_parser_base_interface_property (ValaGirParser* self,
                                         ValaGirParserNode* prop_node)
{
	ValaGirParserNode* result = NULL;
	ValaClass* cl = NULL;
	ValaGirParserNode* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	ValaClass* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prop_node != NULL, NULL);
	_tmp0_ = prop_node->parent;
	_tmp1_ = _tmp0_->symbol;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1_) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp3_ = cl;
	if (_tmp3_ == NULL) {
		result = NULL;
		_vala_code_node_unref0 (cl);
		return result;
	}
	{
		ValaList* _type_list = NULL;
		ValaClass* _tmp4_;
		ValaList* _tmp5_;
		gint _type_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_index = 0;
		_tmp4_ = cl;
		_tmp5_ = vala_class_get_base_types (_tmp4_);
		_type_list = _tmp5_;
		_tmp6_ = _type_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_size = _tmp8_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			ValaDataType* type = NULL;
			ValaList* _tmp11_;
			gint _tmp12_;
			gpointer _tmp13_;
			ValaDataType* _tmp14_;
			ValaGirParserNode* base_node = NULL;
			ValaGirParserNode* _tmp15_;
			ValaDataType* _tmp16_;
			ValaUnresolvedSymbol* _tmp17_;
			ValaUnresolvedSymbol* _tmp18_;
			ValaGirParserNode* _tmp19_;
			gboolean _tmp20_ = FALSE;
			ValaGirParserNode* _tmp21_;
			_type_index = _type_index + 1;
			_tmp9_ = _type_index;
			_tmp10_ = _type_size;
			if (!(_tmp9_ < _tmp10_)) {
				break;
			}
			_tmp11_ = _type_list;
			_tmp12_ = _type_index;
			_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
			type = (ValaDataType*) _tmp13_;
			_tmp14_ = type;
			if (!VALA_IS_UNRESOLVED_TYPE (_tmp14_)) {
				_vala_code_node_unref0 (type);
				continue;
			}
			_tmp15_ = prop_node->parent;
			_tmp16_ = type;
			_tmp17_ = vala_unresolved_type_get_unresolved_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_UNRESOLVED_TYPE, ValaUnresolvedType));
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_gir_parser_resolve_node (self, _tmp15_, _tmp18_, FALSE);
			base_node = _tmp19_;
			_tmp21_ = base_node;
			if (_tmp21_ != NULL) {
				ValaGirParserNode* _tmp22_;
				ValaSymbol* _tmp23_;
				_tmp22_ = base_node;
				_tmp23_ = _tmp22_->symbol;
				_tmp20_ = VALA_IS_INTERFACE (_tmp23_);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaGirParserNode* base_prop_node = NULL;
				ValaGirParserNode* _tmp24_;
				const gchar* _tmp25_;
				ValaGirParserNode* _tmp26_;
				gboolean _tmp27_ = FALSE;
				ValaGirParserNode* _tmp28_;
				_tmp24_ = base_node;
				_tmp25_ = prop_node->name;
				_tmp26_ = vala_gir_parser_node_lookup (_tmp24_, _tmp25_, FALSE, NULL);
				base_prop_node = _tmp26_;
				_tmp28_ = base_prop_node;
				if (_tmp28_ != NULL) {
					ValaGirParserNode* _tmp29_;
					ValaSymbol* _tmp30_;
					_tmp29_ = base_prop_node;
					_tmp30_ = _tmp29_->symbol;
					_tmp27_ = VALA_IS_PROPERTY (_tmp30_);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					ValaProperty* base_property = NULL;
					ValaGirParserNode* _tmp31_;
					ValaSymbol* _tmp32_;
					ValaProperty* _tmp33_;
					gboolean _tmp34_ = FALSE;
					ValaProperty* _tmp35_;
					gboolean _tmp36_;
					gboolean _tmp37_;
					_tmp31_ = base_prop_node;
					_tmp32_ = _tmp31_->symbol;
					_tmp33_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp33_;
					_tmp35_ = base_property;
					_tmp36_ = vala_property_get_is_abstract (_tmp35_);
					_tmp37_ = _tmp36_;
					if (_tmp37_) {
						_tmp34_ = TRUE;
					} else {
						ValaProperty* _tmp38_;
						gboolean _tmp39_;
						gboolean _tmp40_;
						_tmp38_ = base_property;
						_tmp39_ = vala_property_get_is_virtual (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp34_ = _tmp40_;
					}
					if (_tmp34_) {
						result = base_prop_node;
						_vala_code_node_unref0 (base_property);
						_vala_gir_parser_node_unref0 (base_node);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						_vala_code_node_unref0 (cl);
						return result;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_gir_parser_node_unref0 (base_prop_node);
			}
			_vala_gir_parser_node_unref0 (base_node);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	result = NULL;
	_vala_code_node_unref0 (cl);
	return result;
}


ValaGirParser*
vala_gir_parser_construct (GType object_type)
{
	ValaGirParser* self = NULL;
	self = (ValaGirParser*) vala_code_visitor_construct (object_type);
	return self;
}


ValaGirParser*
vala_gir_parser_new (void)
{
	return vala_gir_parser_construct (VALA_TYPE_GIR_PARSER);
}


static gpointer
_vala_source_reference_ref0 (gpointer self)
{
	return self ? vala_source_reference_ref (self) : NULL;
}


static ValaGirParserArgument*
vala_gir_parser_argument_construct (GType object_type,
                                    ValaExpression* expression,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserArgument* self = NULL;
	ValaExpression* _tmp0_;
	ValaSourceReference* _tmp1_;
	g_return_val_if_fail (expression != NULL, NULL);
	self = (ValaGirParserArgument*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (expression);
	_vala_code_node_unref0 (self->expression);
	self->expression = _tmp0_;
	_tmp1_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp1_;
	return self;
}


static ValaGirParserArgument*
vala_gir_parser_argument_new (ValaExpression* expression,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_argument_construct (VALA_GIR_PARSER_TYPE_ARGUMENT, expression, source_reference);
}


static void
vala_gir_parser_value_argument_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_argument_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_argument_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_argument_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_argument_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_argument_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_argument_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserArgument * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_argument_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_argument_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserArgument ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_argument_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_argument (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecArgument* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_argument (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_argument (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_argument_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}


static void
vala_gir_parser_value_take_argument (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserArgument * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_ARGUMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_ARGUMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_argument_unref (old);
	}
}


static void
vala_gir_parser_argument_class_init (ValaGirParserArgumentClass * klass)
{
	vala_gir_parser_argument_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserArgumentClass *) klass)->finalize = vala_gir_parser_argument_finalize;
}


static void
vala_gir_parser_argument_instance_init (ValaGirParserArgument * self)
{
	self->used = FALSE;
	self->ref_count = 1;
}


static void
vala_gir_parser_argument_finalize (ValaGirParserArgument * obj)
{
	ValaGirParserArgument * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_ARGUMENT, ValaGirParserArgument);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->expression);
	_vala_source_reference_unref0 (self->source_reference);
}


static GType
vala_gir_parser_argument_get_type (void)
{
	static volatile gsize vala_gir_parser_argument_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_argument_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_argument_init, vala_gir_parser_value_argument_free_value, vala_gir_parser_value_argument_copy_value, vala_gir_parser_value_argument_peek_pointer, "p", vala_gir_parser_value_argument_collect_value, "p", vala_gir_parser_value_argument_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserArgumentClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_argument_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserArgument), 0, (GInstanceInitFunc) vala_gir_parser_argument_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_argument_type_id;
		vala_gir_parser_argument_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserArgument", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_argument_type_id__volatile, vala_gir_parser_argument_type_id);
	}
	return vala_gir_parser_argument_type_id__volatile;
}


static gpointer
vala_gir_parser_argument_ref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_argument_unref (gpointer instance)
{
	ValaGirParserArgument * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_ARGUMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_construct (GType object_type,
                                        const gchar* selector)
{
	ValaGirParserMetadataSet* self = NULL;
	self = (ValaGirParserMetadataSet*) vala_gir_parser_metadata_construct (object_type, "", selector, NULL);
	return self;
}


static ValaGirParserMetadataSet*
vala_gir_parser_metadata_set_new (const gchar* selector)
{
	return vala_gir_parser_metadata_set_construct (VALA_GIR_PARSER_TYPE_METADATA_SET, selector);
}


static void
vala_gir_parser_metadata_set_add_sibling (ValaGirParserMetadataSet* self,
                                          ValaGirParserMetadata* metadata)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp0_;
		ValaArrayList* _tmp1_;
		gint _child_size = 0;
		ValaArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _child_index = 0;
		_tmp0_ = metadata->children;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_child_list = _tmp1_;
		_tmp2_ = _child_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_child_size = _tmp4_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaGirParserMetadata* child = NULL;
			ValaArrayList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaGirParserMetadata* _tmp10_;
			_child_index = _child_index + 1;
			_tmp5_ = _child_index;
			_tmp6_ = _child_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _child_list;
			_tmp8_ = _child_index;
			_tmp9_ = vala_list_get ((ValaList*) _tmp7_, _tmp8_);
			child = (ValaGirParserMetadata*) _tmp9_;
			_tmp10_ = child;
			vala_gir_parser_metadata_add_child ((ValaGirParserMetadata*) self, _tmp10_);
			_vala_gir_parser_metadata_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _key_it = NULL;
		ValaMap* _tmp11_;
		ValaSet* _tmp12_;
		ValaSet* _tmp13_;
		ValaIterator* _tmp14_;
		ValaIterator* _tmp15_;
		_tmp11_ = metadata->args;
		_tmp12_ = vala_map_get_keys (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
		_tmp15_ = _tmp14_;
		_vala_iterable_unref0 (_tmp13_);
		_key_it = _tmp15_;
		while (TRUE) {
			ValaIterator* _tmp16_;
			ValaGirParserArgumentType key = 0;
			ValaIterator* _tmp17_;
			gpointer _tmp18_;
			ValaMap* _tmp19_;
			ValaGirParserArgumentType _tmp20_;
			ValaMap* _tmp21_;
			ValaGirParserArgumentType _tmp22_;
			gpointer _tmp23_;
			ValaGirParserArgument* _tmp24_;
			_tmp16_ = _key_it;
			if (!vala_iterator_next (_tmp16_)) {
				break;
			}
			_tmp17_ = _key_it;
			_tmp18_ = vala_iterator_get (_tmp17_);
			key = (ValaGirParserArgumentType) ((gintptr) _tmp18_);
			_tmp19_ = ((ValaGirParserMetadata*) self)->args;
			_tmp20_ = key;
			_tmp21_ = metadata->args;
			_tmp22_ = key;
			_tmp23_ = vala_map_get (_tmp21_, (gpointer) ((gintptr) _tmp22_));
			_tmp24_ = (ValaGirParserArgument*) _tmp23_;
			vala_map_set (_tmp19_, (gpointer) ((gintptr) _tmp20_), _tmp24_);
			_vala_gir_parser_argument_unref0 (_tmp24_);
		}
		_vala_iterator_unref0 (_key_it);
	}
}


static void
vala_gir_parser_metadata_set_class_init (ValaGirParserMetadataSetClass * klass)
{
	vala_gir_parser_metadata_set_parent_class = g_type_class_peek_parent (klass);
}


static void
vala_gir_parser_metadata_set_instance_init (ValaGirParserMetadataSet * self)
{
}


static GType
vala_gir_parser_metadata_set_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_set_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataSet), 0, (GInstanceInitFunc) vala_gir_parser_metadata_set_instance_init, NULL };
		GType vala_gir_parser_metadata_set_type_id;
		vala_gir_parser_metadata_set_type_id = g_type_register_static (VALA_GIR_PARSER_TYPE_METADATA, "ValaGirParserMetadataSet", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_set_type_id__volatile, vala_gir_parser_metadata_set_type_id);
	}
	return vala_gir_parser_metadata_set_type_id__volatile;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_construct (GType object_type,
                                    const gchar* pattern,
                                    const gchar* selector,
                                    ValaSourceReference* source_reference)
{
	ValaGirParserMetadata* self = NULL;
	GPatternSpec* _tmp0_;
	gchar* _tmp1_;
	ValaSourceReference* _tmp2_;
	g_return_val_if_fail (pattern != NULL, NULL);
	self = (ValaGirParserMetadata*) g_type_create_instance (object_type);
	_tmp0_ = g_pattern_spec_new (pattern);
	_g_pattern_spec_free0 (self->pattern_spec);
	self->pattern_spec = _tmp0_;
	_tmp1_ = g_strdup (selector);
	_g_free0 (self->selector);
	self->selector = _tmp1_;
	_tmp2_ = _vala_source_reference_ref0 (source_reference);
	_vala_source_reference_unref0 (self->source_reference);
	self->source_reference = _tmp2_;
	return self;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_new (const gchar* pattern,
                              const gchar* selector,
                              ValaSourceReference* source_reference)
{
	return vala_gir_parser_metadata_construct (VALA_GIR_PARSER_TYPE_METADATA, pattern, selector, source_reference);
}


static void
vala_gir_parser_metadata_add_child (ValaGirParserMetadata* self,
                                    ValaGirParserMetadata* metadata)
{
	ValaArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (metadata != NULL);
	_tmp0_ = self->children;
	vala_collection_add ((ValaCollection*) _tmp0_, metadata);
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_match_child (ValaGirParserMetadata* self,
                                      const gchar* name,
                                      const gchar* selector)
{
	ValaGirParserMetadata* result = NULL;
	ValaGirParserMetadata* _result_ = NULL;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	_result_ = _tmp2_;
	{
		ValaArrayList* _metadata_list = NULL;
		ValaArrayList* _tmp3_;
		ValaArrayList* _tmp4_;
		gint _metadata_size = 0;
		ValaArrayList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _metadata_index = 0;
		_tmp3_ = self->children;
		_tmp4_ = _vala_iterable_ref0 (_tmp3_);
		_metadata_list = _tmp4_;
		_tmp5_ = _metadata_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_metadata_size = _tmp7_;
		_metadata_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaGirParserMetadata* metadata = NULL;
			ValaArrayList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			gboolean _tmp13_ = FALSE;
			gboolean _tmp14_ = FALSE;
			gboolean _tmp15_ = FALSE;
			_metadata_index = _metadata_index + 1;
			_tmp8_ = _metadata_index;
			_tmp9_ = _metadata_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _metadata_list;
			_tmp11_ = _metadata_index;
			_tmp12_ = vala_list_get ((ValaList*) _tmp10_, _tmp11_);
			metadata = (ValaGirParserMetadata*) _tmp12_;
			if (selector == NULL) {
				_tmp15_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = metadata;
				_tmp17_ = _tmp16_->selector;
				_tmp15_ = _tmp17_ == NULL;
			}
			if (_tmp15_) {
				_tmp14_ = TRUE;
			} else {
				ValaGirParserMetadata* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = metadata;
				_tmp19_ = _tmp18_->selector;
				_tmp14_ = g_strcmp0 (_tmp19_, selector) == 0;
			}
			if (_tmp14_) {
				ValaGirParserMetadata* _tmp20_;
				GPatternSpec* _tmp21_;
				_tmp20_ = metadata;
				_tmp21_ = _tmp20_->pattern_spec;
				_tmp13_ = g_pattern_match_string (_tmp21_, name);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				ValaGirParserMetadata* _tmp22_;
				ValaGirParserMetadata* _tmp23_;
				ValaGirParserMetadata* _tmp24_;
				ValaGirParserMetadata* _tmp25_;
				_tmp22_ = metadata;
				_tmp22_->used = TRUE;
				_tmp23_ = _result_;
				_tmp24_ = vala_gir_parser_metadata_get_empty ();
				_tmp25_ = _tmp24_;
				if (_tmp23_ == _tmp25_) {
					ValaGirParserMetadata* _tmp26_;
					ValaGirParserMetadata* _tmp27_;
					_tmp26_ = metadata;
					_tmp27_ = _vala_gir_parser_metadata_ref0 (_tmp26_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp27_;
				} else {
					ValaGirParserMetadataSet* ms = NULL;
					ValaGirParserMetadata* _tmp28_;
					ValaGirParserMetadataSet* _tmp29_;
					ValaGirParserMetadataSet* _tmp30_;
					ValaGirParserMetadataSet* _tmp34_;
					ValaGirParserMetadata* _tmp35_;
					ValaGirParserMetadataSet* _tmp36_;
					ValaGirParserMetadata* _tmp37_;
					_tmp28_ = _result_;
					_tmp29_ = _vala_gir_parser_metadata_ref0 (VALA_GIR_PARSER_IS_METADATA_SET (_tmp28_) ? ((ValaGirParserMetadataSet*) _tmp28_) : NULL);
					ms = _tmp29_;
					_tmp30_ = ms;
					if (_tmp30_ == NULL) {
						ValaGirParserMetadataSet* _tmp31_;
						ValaGirParserMetadataSet* _tmp32_;
						ValaGirParserMetadata* _tmp33_;
						_tmp31_ = vala_gir_parser_metadata_set_new (selector);
						_vala_gir_parser_metadata_unref0 (ms);
						ms = _tmp31_;
						_tmp32_ = ms;
						_tmp33_ = _result_;
						vala_gir_parser_metadata_set_add_sibling (_tmp32_, _tmp33_);
					}
					_tmp34_ = ms;
					_tmp35_ = metadata;
					vala_gir_parser_metadata_set_add_sibling (_tmp34_, _tmp35_);
					_tmp36_ = ms;
					_tmp37_ = _vala_gir_parser_metadata_ref0 ((ValaGirParserMetadata*) _tmp36_);
					_vala_gir_parser_metadata_unref0 (_result_);
					_result_ = _tmp37_;
					_vala_gir_parser_metadata_unref0 (ms);
				}
			}
			_vala_gir_parser_metadata_unref0 (metadata);
		}
		_vala_iterable_unref0 (_metadata_list);
	}
	result = _result_;
	return result;
}


static void
vala_gir_parser_metadata_add_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key,
                                       ValaGirParserArgument* value)
{
	ValaMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->args;
	vala_map_set (_tmp0_, (gpointer) ((gintptr) key), value);
}


static gboolean
vala_gir_parser_metadata_has_argument (ValaGirParserMetadata* self,
                                       ValaGirParserArgumentType key)
{
	gboolean result = FALSE;
	ValaMap* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->args;
	result = vala_map_contains (_tmp0_, (gpointer) ((gintptr) key));
	return result;
}


static ValaExpression*
vala_gir_parser_metadata_get_expression (ValaGirParserMetadata* self,
                                         ValaGirParserArgumentType arg)
{
	ValaExpression* result = NULL;
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaGirParserArgument* _tmp4_;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp3_ = val;
		_tmp3_->used = TRUE;
		_tmp4_ = val;
		_tmp5_ = _tmp4_->expression;
		_tmp6_ = _vala_code_node_ref0 (_tmp5_);
		result = _tmp6_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}


static gchar*
vala_gir_parser_metadata_get_string (ValaGirParserMetadata* self,
                                     ValaGirParserArgumentType arg)
{
	gchar* result = NULL;
	ValaStringLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaStringLiteral* _tmp1_;
	ValaStringLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_STRING_LITERAL (_tmp0_) ? ((ValaStringLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaStringLiteral* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = lit;
		_tmp4_ = vala_string_literal_eval (_tmp3_);
		result = _tmp4_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = NULL;
	_vala_code_node_unref0 (lit);
	return result;
}


static gint
vala_gir_parser_metadata_get_integer (ValaGirParserMetadata* self,
                                      ValaGirParserArgumentType arg)
{
	gint result = 0;
	ValaUnaryExpression* unary = NULL;
	ValaExpression* _tmp0_;
	ValaUnaryExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryExpression* _tmp3_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_UNARY_EXPRESSION (_tmp0_) ? ((ValaUnaryExpression*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	unary = _tmp1_;
	_tmp3_ = unary;
	if (_tmp3_ != NULL) {
		ValaUnaryExpression* _tmp4_;
		ValaUnaryOperator _tmp5_;
		ValaUnaryOperator _tmp6_;
		_tmp4_ = unary;
		_tmp5_ = vala_unary_expression_get_operator (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_ == VALA_UNARY_OPERATOR_MINUS;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		ValaIntegerLiteral* lit = NULL;
		ValaUnaryExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaIntegerLiteral* _tmp10_;
		ValaIntegerLiteral* _tmp11_;
		_tmp7_ = unary;
		_tmp8_ = vala_unary_expression_get_inner (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (VALA_IS_INTEGER_LITERAL (_tmp9_) ? ((ValaIntegerLiteral*) _tmp9_) : NULL);
		lit = _tmp10_;
		_tmp11_ = lit;
		if (_tmp11_ != NULL) {
			ValaIntegerLiteral* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			_tmp12_ = lit;
			_tmp13_ = vala_integer_literal_get_value (_tmp12_);
			_tmp14_ = _tmp13_;
			result = -atoi (_tmp14_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	} else {
		ValaIntegerLiteral* lit = NULL;
		ValaExpression* _tmp15_;
		ValaIntegerLiteral* _tmp16_;
		ValaIntegerLiteral* _tmp17_;
		_tmp15_ = vala_gir_parser_metadata_get_expression (self, arg);
		_tmp16_ = VALA_IS_INTEGER_LITERAL (_tmp15_) ? ((ValaIntegerLiteral*) _tmp15_) : NULL;
		if (_tmp16_ == NULL) {
			_vala_code_node_unref0 (_tmp15_);
		}
		lit = _tmp16_;
		_tmp17_ = lit;
		if (_tmp17_ != NULL) {
			ValaIntegerLiteral* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = lit;
			_tmp19_ = vala_integer_literal_get_value (_tmp18_);
			_tmp20_ = _tmp19_;
			result = atoi (_tmp20_);
			_vala_code_node_unref0 (lit);
			_vala_code_node_unref0 (unary);
			return result;
		}
		_vala_code_node_unref0 (lit);
	}
	result = 0;
	_vala_code_node_unref0 (unary);
	return result;
}


static gboolean
vala_gir_parser_metadata_get_bool (ValaGirParserMetadata* self,
                                   ValaGirParserArgumentType arg,
                                   gboolean default_value)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* lit = NULL;
	ValaExpression* _tmp0_;
	ValaBooleanLiteral* _tmp1_;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_gir_parser_metadata_get_expression (self, arg);
	_tmp1_ = VALA_IS_BOOLEAN_LITERAL (_tmp0_) ? ((ValaBooleanLiteral*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_vala_code_node_unref0 (_tmp0_);
	}
	lit = _tmp1_;
	_tmp2_ = lit;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = lit;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		result = _tmp5_;
		_vala_code_node_unref0 (lit);
		return result;
	}
	result = default_value;
	_vala_code_node_unref0 (lit);
	return result;
}


static ValaSourceReference*
vala_gir_parser_metadata_get_source_reference (ValaGirParserMetadata* self,
                                               ValaGirParserArgumentType arg)
{
	ValaSourceReference* result = NULL;
	ValaGirParserArgument* val = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserArgument* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->args;
	_tmp1_ = vala_map_get (_tmp0_, (gpointer) ((gintptr) arg));
	val = (ValaGirParserArgument*) _tmp1_;
	_tmp2_ = val;
	if (_tmp2_ != NULL) {
		ValaGirParserArgument* _tmp3_;
		ValaSourceReference* _tmp4_;
		ValaSourceReference* _tmp5_;
		_tmp3_ = val;
		_tmp4_ = _tmp3_->source_reference;
		_tmp5_ = _vala_source_reference_ref0 (_tmp4_);
		result = _tmp5_;
		_vala_gir_parser_argument_unref0 (val);
		return result;
	}
	result = NULL;
	_vala_gir_parser_argument_unref0 (val);
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_get_empty (void)
{
	ValaGirParserMetadata* result;
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp2_;
	_tmp0_ = vala_gir_parser_metadata__empty;
	if (_tmp0_ == NULL) {
		ValaGirParserMetadata* _tmp1_;
		_tmp1_ = vala_gir_parser_metadata_new ("", NULL, NULL);
		_vala_gir_parser_metadata_unref0 (vala_gir_parser_metadata__empty);
		vala_gir_parser_metadata__empty = _tmp1_;
	}
	_tmp2_ = vala_gir_parser_metadata__empty;
	result = _tmp2_;
	return result;
}


static void
vala_gir_parser_value_metadata_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_metadata_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_metadata_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_metadata_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_metadata_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadata * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_metadata_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	ValaGirParserMetadata ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_metadata (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	ValaGirParserParamSpecMetadata* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_metadata (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_metadata (GValue* value,
                                    gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}


static void
vala_gir_parser_value_take_metadata (GValue* value,
                                     gpointer v_object)
{
	ValaGirParserMetadata * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_unref (old);
	}
}


static void
vala_gir_parser_metadata_class_init (ValaGirParserMetadataClass * klass)
{
	vala_gir_parser_metadata_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataClass *) klass)->finalize = vala_gir_parser_metadata_finalize;
}


static void
vala_gir_parser_metadata_instance_init (ValaGirParserMetadata * self)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GEqualFunc _tmp4_;
	ValaArrayList* _tmp5_;
	self->used = FALSE;
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_GIR_PARSER_TYPE_ARGUMENT_TYPE, NULL, NULL, VALA_GIR_PARSER_TYPE_ARGUMENT, (GBoxedCopyFunc) vala_gir_parser_argument_ref, (GDestroyNotify) vala_gir_parser_argument_unref, _tmp0_, _tmp1_, _tmp2_);
	self->args = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_equal;
	_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp4_);
	self->children = _tmp5_;
	self->ref_count = 1;
}


static void
vala_gir_parser_metadata_finalize (ValaGirParserMetadata * obj)
{
	ValaGirParserMetadata * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA, ValaGirParserMetadata);
	g_signal_handlers_destroy (self);
	_g_pattern_spec_free0 (self->pattern_spec);
	_g_free0 (self->selector);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_map_unref0 (self->args);
	_vala_iterable_unref0 (self->children);
}


static GType
vala_gir_parser_metadata_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_init, vala_gir_parser_value_metadata_free_value, vala_gir_parser_value_metadata_copy_value, vala_gir_parser_value_metadata_peek_pointer, "p", vala_gir_parser_value_metadata_collect_value, "p", vala_gir_parser_value_metadata_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadata), 0, (GInstanceInitFunc) vala_gir_parser_metadata_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_metadata_type_id;
		vala_gir_parser_metadata_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadata", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_type_id__volatile, vala_gir_parser_metadata_type_id);
	}
	return vala_gir_parser_metadata_type_id__volatile;
}


static gpointer
vala_gir_parser_metadata_ref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_metadata_unref (gpointer instance)
{
	ValaGirParserMetadata * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_construct (GType object_type)
{
	ValaGirParserMetadataParser* self = NULL;
	ValaGirParserMetadata* _tmp0_;
	self = (ValaGirParserMetadataParser*) g_type_create_instance (object_type);
	_tmp0_ = self->priv->tree;
	_tmp0_->used = TRUE;
	return self;
}


static ValaGirParserMetadataParser*
vala_gir_parser_metadata_parser_new (void)
{
	return vala_gir_parser_metadata_parser_construct (VALA_GIR_PARSER_TYPE_METADATA_PARSER);
}


static ValaSourceReference*
vala_gir_parser_metadata_parser_get_current_src (ValaGirParserMetadataParser* self)
{
	ValaSourceReference* result = NULL;
	ValaScanner* _tmp0_;
	ValaSourceFile* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceLocation _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceReference* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->scanner;
	_tmp1_ = vala_scanner_get_source_file (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = self->priv->begin;
	_tmp4_ = self->priv->end;
	_tmp5_ = vala_source_reference_new (_tmp2_, &_tmp3_, &_tmp4_);
	result = _tmp5_;
	return result;
}


static ValaSourceReference*
vala_gir_parser_metadata_parser_get_src (ValaGirParserMetadataParser* self,
                                         ValaSourceLocation* begin,
                                         ValaSourceLocation* end)
{
	ValaSourceReference* result = NULL;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceFile* _tmp2_;
	ValaSourceFile* _tmp3_;
	ValaSourceLocation _tmp4_;
	ValaSourceLocation _tmp5_;
	ValaSourceReference* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (begin != NULL, NULL);
	_tmp0_ = self->priv->end;
	e = _tmp0_;
	if (end != NULL) {
		e = *end;
	}
	_tmp1_ = self->priv->scanner;
	_tmp2_ = vala_scanner_get_source_file (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = *begin;
	_tmp5_ = e;
	_tmp6_ = vala_source_reference_new (_tmp3_, &_tmp4_, &_tmp5_);
	result = _tmp6_;
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_metadata (ValaGirParserMetadataParser* self,
                                                ValaSourceFile* metadata_file)
{
	ValaGirParserMetadata* result = NULL;
	ValaScanner* _tmp0_;
	ValaGirParserMetadata* _tmp5_;
	ValaGirParserMetadata* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (metadata_file != NULL, NULL);
	_tmp0_ = vala_scanner_new (metadata_file);
	_vala_scanner_unref0 (self->priv->scanner);
	self->priv->scanner = _tmp0_;
	vala_gir_parser_metadata_parser_next (self);
	while (TRUE) {
		ValaTokenType _tmp1_;
		_tmp1_ = self->priv->current;
		if (!(_tmp1_ != VALA_TOKEN_TYPE_EOF)) {
			break;
		}
		if (!vala_gir_parser_metadata_parser_parse_rule (self)) {
			ValaGirParserMetadata* _tmp2_;
			ValaGirParserMetadata* _tmp3_;
			ValaGirParserMetadata* _tmp4_;
			_tmp2_ = vala_gir_parser_metadata_get_empty ();
			_tmp3_ = _tmp2_;
			_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = self->priv->tree;
	_tmp6_ = _vala_gir_parser_metadata_ref0 (_tmp5_);
	result = _tmp6_;
	return result;
}


static ValaTokenType
vala_gir_parser_metadata_parser_next (ValaGirParserMetadataParser* self)
{
	ValaTokenType result = 0;
	ValaSourceLocation _tmp0_;
	ValaScanner* _tmp1_;
	ValaSourceLocation _tmp2_ = {0};
	ValaSourceLocation _tmp3_ = {0};
	ValaTokenType _tmp4_;
	ValaTokenType _tmp5_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->end;
	self->priv->old_end = _tmp0_;
	_tmp1_ = self->priv->scanner;
	_tmp4_ = vala_scanner_read_token (_tmp1_, &_tmp2_, &_tmp3_);
	self->priv->begin = _tmp2_;
	self->priv->end = _tmp3_;
	self->priv->current = _tmp4_;
	_tmp5_ = self->priv->current;
	result = _tmp5_;
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_has_space (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation _tmp0_;
	gchar* _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.pos;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.pos;
	result = _tmp1_ != _tmp3_;
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_has_newline (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation _tmp0_;
	gint _tmp1_;
	ValaSourceLocation _tmp2_;
	gint _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->old_end;
	_tmp1_ = _tmp0_.line;
	_tmp2_ = self->priv->begin;
	_tmp3_ = _tmp2_.line;
	result = _tmp1_ != _tmp3_;
	return result;
}


static gchar*
vala_gir_parser_metadata_parser_get_string (ValaGirParserMetadataParser* self,
                                            ValaSourceLocation* begin,
                                            ValaSourceLocation* end)
{
	gchar* result = NULL;
	ValaSourceLocation b = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceLocation e = {0};
	ValaSourceLocation _tmp1_;
	ValaSourceLocation _tmp2_;
	gchar* _tmp3_;
	ValaSourceLocation _tmp4_;
	gchar* _tmp5_;
	ValaSourceLocation _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	b = _tmp0_;
	_tmp1_ = self->priv->end;
	e = _tmp1_;
	if (begin != NULL) {
		b = *begin;
	}
	if (end != NULL) {
		e = *end;
	}
	_tmp2_ = b;
	_tmp3_ = _tmp2_.pos;
	_tmp4_ = e;
	_tmp5_ = _tmp4_.pos;
	_tmp6_ = b;
	_tmp7_ = _tmp6_.pos;
	_tmp8_ = string_substring ((const gchar*) _tmp3_, (glong) 0, (glong) ((gint) (_tmp5_ - _tmp7_)));
	result = _tmp8_;
	return result;
}


static gchar*
vala_gir_parser_metadata_parser_parse_identifier (ValaGirParserMetadataParser* self,
                                                  gboolean is_glob)
{
	gchar* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaTokenType _tmp2_;
	ValaSourceLocation _tmp15_;
	ValaSourceLocation _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp2_ = self->priv->current;
	if (_tmp2_ == VALA_TOKEN_TYPE_DOT) {
		_tmp1_ = TRUE;
	} else {
		ValaTokenType _tmp3_;
		_tmp3_ = self->priv->current;
		_tmp1_ = _tmp3_ == VALA_TOKEN_TYPE_HASH;
	}
	if (_tmp1_) {
		if (is_glob) {
			ValaSourceLocation _tmp4_;
			ValaSourceReference* _tmp5_;
			ValaSourceReference* _tmp6_;
			_tmp4_ = begin;
			_tmp5_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp4_, NULL);
			_tmp6_ = _tmp5_;
			vala_report_error (_tmp6_, "expected glob-style pattern");
			_vala_source_reference_unref0 (_tmp6_);
		} else {
			ValaSourceLocation _tmp7_;
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			_tmp7_ = begin;
			_tmp8_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp7_, NULL);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "expected identifier");
			_vala_source_reference_unref0 (_tmp9_);
		}
		result = NULL;
		return result;
	}
	if (is_glob) {
		while (TRUE) {
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaTokenType _tmp12_;
			_tmp12_ = self->priv->current;
			if (_tmp12_ != VALA_TOKEN_TYPE_EOF) {
				ValaTokenType _tmp13_;
				_tmp13_ = self->priv->current;
				_tmp11_ = _tmp13_ != VALA_TOKEN_TYPE_DOT;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaTokenType _tmp14_;
				_tmp14_ = self->priv->current;
				_tmp10_ = _tmp14_ != VALA_TOKEN_TYPE_HASH;
			} else {
				_tmp10_ = FALSE;
			}
			if (!_tmp10_) {
				break;
			}
			vala_gir_parser_metadata_parser_next (self);
			if (vala_gir_parser_metadata_parser_has_space (self)) {
				break;
			}
		}
	} else {
		vala_gir_parser_metadata_parser_next (self);
	}
	_tmp15_ = begin;
	_tmp16_ = self->priv->old_end;
	_tmp17_ = vala_gir_parser_metadata_parser_get_string (self, &_tmp15_, &_tmp16_);
	result = _tmp17_;
	return result;
}


static gchar*
vala_gir_parser_metadata_parser_parse_selector (ValaGirParserMetadataParser* self)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->current;
	if (_tmp1_ != VALA_TOKEN_TYPE_HASH) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = vala_gir_parser_metadata_parser_has_space (self);
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	vala_gir_parser_metadata_parser_next (self);
	_tmp2_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
	result = _tmp2_;
	return result;
}


static ValaGirParserMetadata*
vala_gir_parser_metadata_parser_parse_pattern (ValaGirParserMetadataParser* self)
{
	ValaGirParserMetadata* result = NULL;
	ValaGirParserMetadata* metadata = NULL;
	gboolean is_relative = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaTokenType _tmp1_;
	ValaGirParserMetadata* _tmp12_;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp15_;
	gchar* pattern = NULL;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaSourceLocation _tmp21_;
	ValaSourceReference* _tmp22_;
	ValaSourceReference* _tmp23_;
	ValaGirParserMetadata* _tmp24_;
	ValaGirParserMetadata* _tmp25_;
	ValaGirParserMetadata* _tmp26_;
	gboolean _tmp52_;
	g_return_val_if_fail (self != NULL, NULL);
	is_relative = FALSE;
	_tmp1_ = self->priv->current;
	if (_tmp1_ == VALA_TOKEN_TYPE_IDENTIFIER) {
		_tmp0_ = TRUE;
	} else {
		ValaTokenType _tmp2_;
		_tmp2_ = self->priv->current;
		_tmp0_ = _tmp2_ == VALA_TOKEN_TYPE_STAR;
	}
	if (_tmp0_) {
		ValaGirParserMetadata* _tmp3_;
		ValaGirParserMetadata* _tmp4_;
		_tmp3_ = self->priv->tree;
		_tmp4_ = _vala_gir_parser_metadata_ref0 (_tmp3_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp4_;
	} else {
		ValaTokenType _tmp5_;
		_tmp5_ = self->priv->current;
		if (_tmp5_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp6_;
			ValaSourceReference* _tmp7_;
			ValaTokenType _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->current;
			_tmp9_ = vala_token_type_to_string (_tmp8_);
			_tmp10_ = g_strdup_printf ("expected pattern or `.', got %s", _tmp9_);
			_tmp11_ = _tmp10_;
			vala_report_error (_tmp7_, _tmp11_);
			_g_free0 (_tmp11_);
			_vala_source_reference_unref0 (_tmp7_);
			result = NULL;
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		vala_gir_parser_metadata_parser_next (self);
		is_relative = TRUE;
	}
	_tmp12_ = self->priv->parent_metadata;
	if (_tmp12_ == NULL) {
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		_tmp13_ = vala_gir_parser_metadata_parser_get_current_src (self);
		_tmp14_ = _tmp13_;
		vala_report_error (_tmp14_, "cannot determinate parent metadata");
		_vala_source_reference_unref0 (_tmp14_);
		result = NULL;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp15_ = self->priv->begin;
	begin = _tmp15_;
	_tmp16_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
	pattern = _tmp16_;
	_tmp17_ = pattern;
	if (_tmp17_ == NULL) {
		result = NULL;
		_g_free0 (pattern);
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp18_ = pattern;
	_tmp19_ = vala_gir_parser_metadata_parser_parse_selector (self);
	_tmp20_ = _tmp19_;
	_tmp21_ = begin;
	_tmp22_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp21_, NULL);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_gir_parser_metadata_new (_tmp18_, _tmp20_, _tmp23_);
	_vala_gir_parser_metadata_unref0 (metadata);
	metadata = _tmp24_;
	_vala_source_reference_unref0 (_tmp23_);
	_g_free0 (_tmp20_);
	_tmp25_ = self->priv->parent_metadata;
	_tmp26_ = metadata;
	vala_gir_parser_metadata_add_child (_tmp25_, _tmp26_);
	while (TRUE) {
		gboolean _tmp27_ = FALSE;
		ValaTokenType _tmp28_;
		ValaTokenType _tmp29_;
		ValaSourceLocation _tmp36_;
		gchar* _tmp37_;
		const gchar* _tmp38_;
		ValaGirParserMetadata* child = NULL;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		ValaSourceLocation _tmp42_;
		ValaSourceLocation _tmp43_;
		ValaSourceReference* _tmp44_;
		ValaSourceReference* _tmp45_;
		ValaGirParserMetadata* _tmp46_;
		ValaGirParserMetadata* _tmp47_;
		ValaGirParserMetadata* _tmp48_;
		ValaGirParserMetadata* _tmp49_;
		ValaGirParserMetadata* _tmp50_;
		ValaGirParserMetadata* _tmp51_;
		_tmp28_ = self->priv->current;
		if (_tmp28_ != VALA_TOKEN_TYPE_EOF) {
			_tmp27_ = !vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp27_ = FALSE;
		}
		if (!_tmp27_) {
			break;
		}
		_tmp29_ = self->priv->current;
		if (_tmp29_ != VALA_TOKEN_TYPE_DOT) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaTokenType _tmp32_;
			const gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp30_ = vala_gir_parser_metadata_parser_get_current_src (self);
			_tmp31_ = _tmp30_;
			_tmp32_ = self->priv->current;
			_tmp33_ = vala_token_type_to_string (_tmp32_);
			_tmp34_ = g_strdup_printf ("expected `.' got %s", _tmp33_);
			_tmp35_ = _tmp34_;
			vala_report_error (_tmp31_, _tmp35_);
			_g_free0 (_tmp35_);
			_vala_source_reference_unref0 (_tmp31_);
			break;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp36_ = self->priv->begin;
		begin = _tmp36_;
		_tmp37_ = vala_gir_parser_metadata_parser_parse_identifier (self, TRUE);
		_g_free0 (pattern);
		pattern = _tmp37_;
		_tmp38_ = pattern;
		if (_tmp38_ == NULL) {
			result = NULL;
			_g_free0 (pattern);
			_vala_gir_parser_metadata_unref0 (metadata);
			return result;
		}
		_tmp39_ = pattern;
		_tmp40_ = vala_gir_parser_metadata_parser_parse_selector (self);
		_tmp41_ = _tmp40_;
		_tmp42_ = begin;
		_tmp43_ = self->priv->old_end;
		_tmp44_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp42_, &_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_gir_parser_metadata_new (_tmp39_, _tmp41_, _tmp45_);
		_tmp47_ = _tmp46_;
		_vala_source_reference_unref0 (_tmp45_);
		_g_free0 (_tmp41_);
		child = _tmp47_;
		_tmp48_ = metadata;
		_tmp49_ = child;
		vala_gir_parser_metadata_add_child (_tmp48_, _tmp49_);
		_tmp50_ = child;
		_tmp51_ = _vala_gir_parser_metadata_ref0 (_tmp50_);
		_vala_gir_parser_metadata_unref0 (metadata);
		metadata = _tmp51_;
		_vala_gir_parser_metadata_unref0 (child);
	}
	_tmp52_ = is_relative;
	if (!_tmp52_) {
		ValaGirParserMetadata* _tmp53_;
		ValaGirParserMetadata* _tmp54_;
		_tmp53_ = metadata;
		_tmp54_ = _vala_gir_parser_metadata_ref0 (_tmp53_);
		_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
		self->priv->parent_metadata = _tmp54_;
	}
	result = metadata;
	_g_free0 (pattern);
	return result;
}


static ValaExpression*
vala_gir_parser_metadata_parser_parse_expression (ValaGirParserMetadataParser* self)
{
	ValaExpression* result = NULL;
	ValaSourceLocation begin = {0};
	ValaSourceLocation _tmp0_;
	ValaSourceReference* src = NULL;
	ValaSourceReference* _tmp1_;
	ValaExpression* expr = NULL;
	ValaTokenType _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->begin;
	begin = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_get_current_src (self);
	src = _tmp1_;
	expr = NULL;
	_tmp2_ = self->priv->current;
	switch (_tmp2_) {
		case VALA_TOKEN_TYPE_NULL:
		{
			ValaSourceReference* _tmp3_;
			ValaNullLiteral* _tmp4_;
			_tmp3_ = src;
			_tmp4_ = vala_null_literal_new (_tmp3_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp4_;
			break;
		}
		case VALA_TOKEN_TYPE_TRUE:
		{
			ValaSourceReference* _tmp5_;
			ValaBooleanLiteral* _tmp6_;
			_tmp5_ = src;
			_tmp6_ = vala_boolean_literal_new (TRUE, _tmp5_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp6_;
			break;
		}
		case VALA_TOKEN_TYPE_FALSE:
		{
			ValaSourceReference* _tmp7_;
			ValaBooleanLiteral* _tmp8_;
			_tmp7_ = src;
			_tmp8_ = vala_boolean_literal_new (FALSE, _tmp7_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp8_;
			break;
		}
		case VALA_TOKEN_TYPE_MINUS:
		{
			ValaExpression* inner = NULL;
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			vala_gir_parser_metadata_parser_next (self);
			_tmp9_ = vala_gir_parser_metadata_parser_parse_expression (self);
			inner = _tmp9_;
			_tmp10_ = inner;
			if (_tmp10_ == NULL) {
				ValaSourceReference* _tmp11_;
				ValaTokenType _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp11_ = src;
				_tmp12_ = self->priv->current;
				_tmp13_ = vala_token_type_to_string (_tmp12_);
				_tmp14_ = g_strdup_printf ("expected expression after `-', got %s", _tmp13_);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp11_, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				ValaExpression* _tmp16_;
				ValaSourceLocation _tmp17_;
				ValaSourceReference* _tmp18_;
				ValaSourceReference* _tmp19_;
				ValaUnaryExpression* _tmp20_;
				_tmp16_ = inner;
				_tmp17_ = begin;
				_tmp18_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp17_, NULL);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_unary_expression_new (VALA_UNARY_OPERATOR_MINUS, _tmp16_, _tmp19_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp20_;
				_vala_source_reference_unref0 (_tmp19_);
			}
			result = expr;
			_vala_code_node_unref0 (inner);
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_INTEGER_LITERAL:
		{
			gchar* _tmp21_;
			gchar* _tmp22_;
			ValaSourceReference* _tmp23_;
			ValaIntegerLiteral* _tmp24_;
			_tmp21_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp22_ = _tmp21_;
			_tmp23_ = src;
			_tmp24_ = vala_integer_literal_new (_tmp22_, _tmp23_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp24_;
			_g_free0 (_tmp22_);
			break;
		}
		case VALA_TOKEN_TYPE_REAL_LITERAL:
		{
			gchar* _tmp25_;
			gchar* _tmp26_;
			ValaSourceReference* _tmp27_;
			ValaRealLiteral* _tmp28_;
			_tmp25_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = src;
			_tmp28_ = vala_real_literal_new (_tmp26_, _tmp27_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp28_;
			_g_free0 (_tmp26_);
			break;
		}
		case VALA_TOKEN_TYPE_STRING_LITERAL:
		{
			gchar* _tmp29_;
			gchar* _tmp30_;
			ValaSourceReference* _tmp31_;
			ValaStringLiteral* _tmp32_;
			_tmp29_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = src;
			_tmp32_ = vala_string_literal_new (_tmp30_, _tmp31_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp32_;
			_g_free0 (_tmp30_);
			break;
		}
		case VALA_TOKEN_TYPE_IDENTIFIER:
		{
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaSourceReference* _tmp35_;
			ValaMemberAccess* _tmp36_;
			_tmp33_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
			_tmp34_ = _tmp33_;
			_tmp35_ = src;
			_tmp36_ = vala_member_access_new (NULL, _tmp34_, _tmp35_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp36_;
			_g_free0 (_tmp34_);
			while (TRUE) {
				ValaExpression* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				ValaSourceReference* _tmp46_;
				ValaSourceReference* _tmp47_;
				ValaMemberAccess* _tmp48_;
				if (!(vala_gir_parser_metadata_parser_next (self) == VALA_TOKEN_TYPE_DOT)) {
					break;
				}
				if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_IDENTIFIER) {
					ValaSourceReference* _tmp37_;
					ValaSourceReference* _tmp38_;
					ValaTokenType _tmp39_;
					const gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					_tmp37_ = vala_gir_parser_metadata_parser_get_current_src (self);
					_tmp38_ = _tmp37_;
					_tmp39_ = self->priv->current;
					_tmp40_ = vala_token_type_to_string (_tmp39_);
					_tmp41_ = g_strdup_printf ("expected identifier got %s", _tmp40_);
					_tmp42_ = _tmp41_;
					vala_report_error (_tmp38_, _tmp42_);
					_g_free0 (_tmp42_);
					_vala_source_reference_unref0 (_tmp38_);
					break;
				}
				_tmp43_ = expr;
				_tmp44_ = vala_gir_parser_metadata_parser_get_string (self, NULL, NULL);
				_tmp45_ = _tmp44_;
				_tmp46_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp47_ = _tmp46_;
				_tmp48_ = vala_member_access_new (_tmp43_, _tmp45_, _tmp47_);
				_vala_code_node_unref0 (expr);
				expr = (ValaExpression*) _tmp48_;
				_vala_source_reference_unref0 (_tmp47_);
				_g_free0 (_tmp45_);
			}
			result = expr;
			_vala_source_reference_unref0 (src);
			return result;
		}
		case VALA_TOKEN_TYPE_OPEN_PARENS:
		{
			ValaSourceReference* _tmp55_;
			ValaTuple* _tmp56_;
			if (vala_gir_parser_metadata_parser_next (self) != VALA_TOKEN_TYPE_CLOSE_PARENS) {
				ValaSourceReference* _tmp49_;
				ValaSourceReference* _tmp50_;
				ValaTokenType _tmp51_;
				const gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				_tmp49_ = vala_gir_parser_metadata_parser_get_current_src (self);
				_tmp50_ = _tmp49_;
				_tmp51_ = self->priv->current;
				_tmp52_ = vala_token_type_to_string (_tmp51_);
				_tmp53_ = g_strdup_printf ("expected `)', got %s", _tmp52_);
				_tmp54_ = _tmp53_;
				vala_report_error (_tmp50_, _tmp54_);
				_g_free0 (_tmp54_);
				_vala_source_reference_unref0 (_tmp50_);
				break;
			}
			_tmp55_ = src;
			_tmp56_ = vala_tuple_new (_tmp55_);
			_vala_code_node_unref0 (expr);
			expr = (ValaExpression*) _tmp56_;
			break;
		}
		default:
		{
			ValaSourceReference* _tmp57_;
			ValaTokenType _tmp58_;
			const gchar* _tmp59_;
			gchar* _tmp60_;
			gchar* _tmp61_;
			_tmp57_ = src;
			_tmp58_ = self->priv->current;
			_tmp59_ = vala_token_type_to_string (_tmp58_);
			_tmp60_ = g_strdup_printf ("expected literal or symbol got %s", _tmp59_);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp57_, _tmp61_);
			_g_free0 (_tmp61_);
			break;
		}
	}
	vala_gir_parser_metadata_parser_next (self);
	result = expr;
	_vala_source_reference_unref0 (src);
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_parse_args (ValaGirParserMetadataParser* self,
                                            ValaGirParserMetadata* metadata)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (metadata != NULL, FALSE);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		ValaTokenType _tmp2_;
		ValaSourceLocation begin = {0};
		ValaSourceLocation _tmp3_;
		gchar* id = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		ValaGirParserArgumentType* arg_type = NULL;
		const gchar* _tmp6_;
		ValaGirParserArgumentType* _tmp7_;
		ValaGirParserArgumentType* _tmp8_;
		ValaTokenType _tmp16_;
		ValaExpression* expr = NULL;
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaGirParserArgumentType* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSourceLocation _tmp32_;
		ValaSourceReference* _tmp33_;
		ValaSourceReference* _tmp34_;
		ValaGirParserArgument* _tmp35_;
		ValaGirParserArgument* _tmp36_;
		_tmp2_ = self->priv->current;
		if (_tmp2_ != VALA_TOKEN_TYPE_EOF) {
			_tmp1_ = vala_gir_parser_metadata_parser_has_space (self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			_tmp0_ = !vala_gir_parser_metadata_parser_has_newline (self);
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp3_ = self->priv->begin;
		begin = _tmp3_;
		_tmp4_ = vala_gir_parser_metadata_parser_parse_identifier (self, FALSE);
		id = _tmp4_;
		_tmp5_ = id;
		if (_tmp5_ == NULL) {
			result = FALSE;
			_g_free0 (id);
			return result;
		}
		_tmp6_ = id;
		_tmp7_ = vala_gir_parser_argument_type_from_string (_tmp6_);
		arg_type = _tmp7_;
		_tmp8_ = arg_type;
		if (_tmp8_ == NULL) {
			ValaSourceLocation _tmp9_;
			ValaSourceLocation _tmp10_;
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			const gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp9_ = begin;
			_tmp10_ = self->priv->old_end;
			_tmp11_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp9_, &_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = id;
			_tmp14_ = g_strdup_printf ("unknown argument `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_warning (_tmp12_, _tmp15_);
			_g_free0 (_tmp15_);
			_vala_source_reference_unref0 (_tmp12_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		_tmp16_ = self->priv->current;
		if (_tmp16_ != VALA_TOKEN_TYPE_ASSIGN) {
			ValaGirParserArgumentType* _tmp17_;
			ValaSourceLocation _tmp18_;
			ValaSourceReference* _tmp19_;
			ValaSourceReference* _tmp20_;
			ValaBooleanLiteral* _tmp21_;
			ValaBooleanLiteral* _tmp22_;
			ValaSourceLocation _tmp23_;
			ValaSourceReference* _tmp24_;
			ValaSourceReference* _tmp25_;
			ValaGirParserArgument* _tmp26_;
			ValaGirParserArgument* _tmp27_;
			_tmp17_ = arg_type;
			_tmp18_ = begin;
			_tmp19_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp18_, NULL);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_boolean_literal_new (TRUE, _tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = begin;
			_tmp24_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = vala_gir_parser_argument_new ((ValaExpression*) _tmp22_, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_gir_parser_metadata_add_argument (metadata, *_tmp17_, _tmp27_);
			_vala_gir_parser_argument_unref0 (_tmp27_);
			_vala_source_reference_unref0 (_tmp25_);
			_vala_code_node_unref0 (_tmp22_);
			_vala_source_reference_unref0 (_tmp20_);
			_g_free0 (arg_type);
			_g_free0 (id);
			continue;
		}
		vala_gir_parser_metadata_parser_next (self);
		_tmp28_ = vala_gir_parser_metadata_parser_parse_expression (self);
		expr = _tmp28_;
		_tmp29_ = expr;
		if (_tmp29_ == NULL) {
			result = FALSE;
			_vala_code_node_unref0 (expr);
			_g_free0 (arg_type);
			_g_free0 (id);
			return result;
		}
		_tmp30_ = arg_type;
		_tmp31_ = expr;
		_tmp32_ = begin;
		_tmp33_ = vala_gir_parser_metadata_parser_get_src (self, &_tmp32_, NULL);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_gir_parser_argument_new (_tmp31_, _tmp34_);
		_tmp36_ = _tmp35_;
		vala_gir_parser_metadata_add_argument (metadata, *_tmp30_, _tmp36_);
		_vala_gir_parser_argument_unref0 (_tmp36_);
		_vala_source_reference_unref0 (_tmp34_);
		_vala_code_node_unref0 (expr);
		_g_free0 (arg_type);
		_g_free0 (id);
	}
	result = TRUE;
	return result;
}


static gboolean
vala_gir_parser_metadata_parser_parse_rule (ValaGirParserMetadataParser* self)
{
	gboolean result = FALSE;
	ValaSourceLocation old_end = {0};
	ValaSourceLocation _tmp0_;
	ValaGirParserMetadata* metadata = NULL;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaTokenType _tmp4_;
	ValaGirParserMetadata* _tmp9_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->end;
	old_end = _tmp0_;
	_tmp1_ = vala_gir_parser_metadata_parser_parse_pattern (self);
	metadata = _tmp1_;
	_tmp2_ = metadata;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp4_ = self->priv->current;
	if (_tmp4_ == VALA_TOKEN_TYPE_EOF) {
		_tmp3_ = TRUE;
	} else {
		ValaSourceLocation _tmp5_;
		gint _tmp6_;
		ValaSourceLocation _tmp7_;
		gint _tmp8_;
		_tmp5_ = old_end;
		_tmp6_ = _tmp5_.line;
		_tmp7_ = self->priv->end;
		_tmp8_ = _tmp7_.line;
		_tmp3_ = _tmp6_ != _tmp8_;
	}
	if (_tmp3_) {
		result = TRUE;
		_vala_gir_parser_metadata_unref0 (metadata);
		return result;
	}
	_tmp9_ = metadata;
	result = vala_gir_parser_metadata_parser_parse_args (self, _tmp9_);
	_vala_gir_parser_metadata_unref0 (metadata);
	return result;
}


static void
vala_gir_parser_value_metadata_parser_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_metadata_parser_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_metadata_parser_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_metadata_parser_copy_value (const GValue* src_value,
                                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_metadata_parser_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_metadata_parser_collect_value (GValue* value,
                                                     guint n_collect_values,
                                                     GTypeCValue* collect_values,
                                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserMetadataParser * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_metadata_parser_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_metadata_parser_lcopy_value (const GValue* value,
                                                   guint n_collect_values,
                                                   GTypeCValue* collect_values,
                                                   guint collect_flags)
{
	ValaGirParserMetadataParser ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_metadata_parser (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags)
{
	ValaGirParserParamSpecMetadataParser* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_metadata_parser (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_metadata_parser (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_metadata_parser_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}


static void
vala_gir_parser_value_take_metadata_parser (GValue* value,
                                            gpointer v_object)
{
	ValaGirParserMetadataParser * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_METADATA_PARSER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_metadata_parser_unref (old);
	}
}


static void
vala_gir_parser_metadata_parser_class_init (ValaGirParserMetadataParserClass * klass)
{
	vala_gir_parser_metadata_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserMetadataParserClass *) klass)->finalize = vala_gir_parser_metadata_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGirParserMetadataParserPrivate));
}


static void
vala_gir_parser_metadata_parser_instance_init (ValaGirParserMetadataParser * self)
{
	ValaGirParserMetadata* _tmp0_;
	self->priv = VALA_GIR_PARSER_METADATA_PARSER_GET_PRIVATE (self);
	_tmp0_ = vala_gir_parser_metadata_new ("", NULL, NULL);
	self->priv->tree = _tmp0_;
	self->ref_count = 1;
}


static void
vala_gir_parser_metadata_parser_finalize (ValaGirParserMetadataParser * obj)
{
	ValaGirParserMetadataParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_METADATA_PARSER, ValaGirParserMetadataParser);
	g_signal_handlers_destroy (self);
	_vala_gir_parser_metadata_unref0 (self->priv->tree);
	_vala_scanner_unref0 (self->priv->scanner);
	_vala_gir_parser_metadata_unref0 (self->priv->parent_metadata);
}


static GType
vala_gir_parser_metadata_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_metadata_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_metadata_parser_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_metadata_parser_init, vala_gir_parser_value_metadata_parser_free_value, vala_gir_parser_value_metadata_parser_copy_value, vala_gir_parser_value_metadata_parser_peek_pointer, "p", vala_gir_parser_value_metadata_parser_collect_value, "p", vala_gir_parser_value_metadata_parser_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserMetadataParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_metadata_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserMetadataParser), 0, (GInstanceInitFunc) vala_gir_parser_metadata_parser_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_metadata_parser_type_id;
		vala_gir_parser_metadata_parser_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserMetadataParser", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_metadata_parser_type_id__volatile, vala_gir_parser_metadata_parser_type_id);
	}
	return vala_gir_parser_metadata_parser_type_id__volatile;
}


static gpointer
vala_gir_parser_metadata_parser_ref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_metadata_parser_unref (gpointer instance)
{
	ValaGirParserMetadataParser * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_METADATA_PARSER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserNode*
vala_gir_parser_node_construct (GType object_type,
                                const gchar* name)
{
	ValaGirParserNode* self = NULL;
	gchar* _tmp0_;
	self = (ValaGirParserNode*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup (name);
	_g_free0 (self->name);
	self->name = _tmp0_;
	return self;
}


static ValaGirParserNode*
vala_gir_parser_node_new (const gchar* name)
{
	return vala_gir_parser_node_construct (VALA_GIR_PARSER_TYPE_NODE, name);
}


static void
vala_gir_parser_node_add_member (ValaGirParserNode* self,
                                 ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp9_;
	ValaArrayList* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	if (_tmp3_ == NULL) {
		GEqualFunc _tmp4_;
		ValaArrayList* _tmp5_;
		ValaHashMap* _tmp6_;
		const gchar* _tmp7_;
		ValaArrayList* _tmp8_;
		_tmp4_ = g_direct_equal;
		_tmp5_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp4_);
		_vala_iterable_unref0 (nodes);
		nodes = _tmp5_;
		_tmp6_ = self->scope;
		_tmp7_ = node->name;
		_tmp8_ = nodes;
		vala_map_set ((ValaMap*) _tmp6_, _tmp7_, _tmp8_);
	}
	_tmp9_ = nodes;
	vala_collection_add ((ValaCollection*) _tmp9_, node);
	_tmp10_ = self->members;
	vala_collection_add ((ValaCollection*) _tmp10_, node);
	node->parent = self;
	_vala_iterable_unref0 (nodes);
}


static void
vala_gir_parser_node_remove_member (ValaGirParserNode* self,
                                    ValaGirParserNode* node)
{
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	const gchar* _tmp1_;
	gpointer _tmp2_;
	ValaArrayList* _tmp3_;
	ValaArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	ValaArrayList* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->scope;
	_tmp1_ = node->name;
	_tmp2_ = vala_map_get ((ValaMap*) _tmp0_, _tmp1_);
	nodes = (ValaArrayList*) _tmp2_;
	_tmp3_ = nodes;
	vala_collection_remove ((ValaCollection*) _tmp3_, node);
	_tmp4_ = nodes;
	_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		ValaHashMap* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->scope;
		_tmp8_ = node->name;
		vala_map_remove ((ValaMap*) _tmp7_, _tmp8_);
	}
	_tmp9_ = self->members;
	vala_collection_remove ((ValaCollection*) _tmp9_, node);
	node->parent = NULL;
	_vala_iterable_unref0 (nodes);
}


static ValaGirParserNode*
vala_gir_parser_node_lookup (ValaGirParserNode* self,
                             const gchar* name,
                             gboolean create_namespace,
                             ValaSourceReference* source_reference)
{
	ValaGirParserNode* result = NULL;
	ValaArrayList* nodes = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	ValaGirParserNode* node = NULL;
	ValaArrayList* _tmp2_;
	ValaGirParserNode* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	nodes = (ValaArrayList*) _tmp1_;
	node = NULL;
	_tmp2_ = nodes;
	if (_tmp2_ != NULL) {
		ValaArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = nodes;
		_tmp4_ = vala_list_get ((ValaList*) _tmp3_, 0);
		_vala_gir_parser_node_unref0 (node);
		node = (ValaGirParserNode*) _tmp4_;
	}
	_tmp5_ = node;
	if (_tmp5_ == NULL) {
		ValaSymbol* sym = NULL;
		ValaSymbol* _tmp6_;
		gboolean _tmp11_ = FALSE;
		ValaSymbol* _tmp12_;
		sym = NULL;
		_tmp6_ = self->symbol;
		if (_tmp6_ != NULL) {
			ValaSymbol* _tmp7_;
			ValaScope* _tmp8_;
			ValaScope* _tmp9_;
			ValaSymbol* _tmp10_;
			_tmp7_ = self->symbol;
			_tmp8_ = vala_symbol_get_scope (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_scope_lookup (_tmp9_, name);
			_vala_code_node_unref0 (sym);
			sym = _tmp10_;
		}
		_tmp12_ = sym;
		if (_tmp12_ != NULL) {
			_tmp11_ = TRUE;
		} else {
			_tmp11_ = create_namespace;
		}
		if (_tmp11_) {
			ValaGirParserNode* _tmp13_;
			ValaGirParserNode* _tmp14_;
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			ValaGirParserNode* _tmp17_;
			ValaGirParserNode* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaGirParserNode* _tmp20_;
			ValaSourceReference* _tmp21_;
			ValaGirParserNode* _tmp22_;
			ValaSymbol* _tmp23_;
			_tmp13_ = vala_gir_parser_node_new (name);
			_vala_gir_parser_node_unref0 (node);
			node = _tmp13_;
			_tmp14_ = node;
			_tmp15_ = sym;
			_tmp16_ = _vala_code_node_ref0 (_tmp15_);
			_vala_code_node_unref0 (_tmp14_->symbol);
			_tmp14_->symbol = _tmp16_;
			_tmp17_ = node;
			_tmp18_ = node;
			_tmp19_ = _tmp18_->symbol;
			_tmp17_->new_symbol = _tmp19_ == NULL;
			_tmp20_ = node;
			_tmp21_ = _vala_source_reference_ref0 (source_reference);
			_vala_source_reference_unref0 (_tmp20_->source_reference);
			_tmp20_->source_reference = _tmp21_;
			_tmp22_ = node;
			vala_gir_parser_node_add_member (self, _tmp22_);
			_tmp23_ = sym;
			if (_tmp23_ == NULL) {
				ValaArrayList* _tmp24_;
				ValaGirParserNode* _tmp25_;
				_tmp24_ = vala_gir_parser_node_new_namespaces;
				_tmp25_ = node;
				vala_collection_add ((ValaCollection*) _tmp24_, _tmp25_);
			}
		}
		_vala_code_node_unref0 (sym);
	}
	result = node;
	_vala_iterable_unref0 (nodes);
	return result;
}


static ValaArrayList*
vala_gir_parser_node_lookup_all (ValaGirParserNode* self,
                                 const gchar* name)
{
	ValaArrayList* result = NULL;
	ValaHashMap* _tmp0_;
	gpointer _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = self->scope;
	_tmp1_ = vala_map_get ((ValaMap*) _tmp0_, name);
	result = (ValaArrayList*) _tmp1_;
	return result;
}


static ValaUnresolvedSymbol*
vala_gir_parser_node_get_unresolved_symbol (ValaGirParserNode* self)
{
	ValaUnresolvedSymbol* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		ValaUnresolvedSymbol* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = vala_unresolved_symbol_new (NULL, _tmp2_, NULL);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		ValaUnresolvedSymbol* _tmp5_;
		ValaUnresolvedSymbol* _tmp6_;
		const gchar* _tmp7_;
		ValaUnresolvedSymbol* _tmp8_;
		ValaUnresolvedSymbol* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_unresolved_symbol (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = vala_unresolved_symbol_new (_tmp6_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_vala_code_node_unref0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}


static gchar*
vala_gir_parser_node_get_full_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp3_;
	ValaGirParserNode* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gboolean _tmp9_;
	ValaGirParserNode* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	if (_tmp0_ == NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->name;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->name;
	if (_tmp3_ == NULL) {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_get_full_name (_tmp4_);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = vala_gir_parser_node_get_full_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = _tmp8_ == NULL;
	_g_free0 (_tmp8_);
	if (_tmp9_) {
		const gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = self->name;
		_tmp11_ = g_strdup (_tmp10_);
		result = _tmp11_;
		return result;
	}
	_tmp12_ = self->parent;
	_tmp13_ = vala_gir_parser_node_get_full_name (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->name;
	_tmp16_ = g_strdup_printf ("%s.%s", _tmp14_, _tmp15_);
	_tmp17_ = _tmp16_;
	_g_free0 (_tmp14_);
	result = _tmp17_;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_gir_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	GString* default_name = NULL;
	GString* _tmp0_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	default_name = _tmp0_;
	{
		ValaGirParserNode* node = NULL;
		node = self;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp4_;
				ValaGirParserNode* _tmp5_;
				ValaSymbol* _tmp6_;
				GString* _tmp12_;
				ValaGirParserNode* _tmp13_;
				const gchar* _tmp14_;
				if (!_tmp1_) {
					ValaGirParserNode* _tmp2_;
					ValaGirParserNode* _tmp3_;
					_tmp2_ = node;
					_tmp3_ = _tmp2_->parent;
					node = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = node;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp5_ = node;
				_tmp6_ = _tmp5_->symbol;
				if (VALA_IS_NAMESPACE (_tmp6_)) {
					ValaGirParserNode* _tmp7_;
					ValaSymbol* _tmp8_;
					gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean _tmp11_;
					_tmp7_ = node;
					_tmp8_ = _tmp7_->symbol;
					_tmp9_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp8_, "CCode", "gir_namespace", NULL);
					_tmp10_ = _tmp9_;
					_tmp11_ = _tmp10_ != NULL;
					_g_free0 (_tmp10_);
					if (_tmp11_) {
						break;
					}
				}
				_tmp12_ = default_name;
				_tmp13_ = node;
				_tmp14_ = _tmp13_->name;
				g_string_prepend (_tmp12_, _tmp14_);
			}
		}
	}
	_tmp15_ = default_name;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (default_name);
	return result;
}


static gchar*
vala_gir_parser_node_get_gir_name (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* gir_name = NULL;
	ValaMap* _tmp0_;
	gpointer _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->girdata;
	_tmp1_ = vala_map_get (_tmp0_, "name");
	gir_name = (gchar*) _tmp1_;
	_tmp2_ = gir_name;
	if (_tmp2_ == NULL) {
		ValaMap* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->girdata;
		_tmp4_ = vala_map_get (_tmp3_, "glib:name");
		_g_free0 (gir_name);
		gir_name = (gchar*) _tmp4_;
	}
	result = gir_name;
	return result;
}


static gchar*
vala_gir_parser_node_get_lower_case_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaSymbol* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	const gchar* _tmp19_;
	const gchar* _tmp48_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	_tmp3_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp2_, "CCode", "lower_case_cprefix", NULL);
	prefix = _tmp3_;
	_tmp5_ = prefix;
	if (_tmp5_ == NULL) {
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		_tmp7_ = self->symbol;
		if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp7_)) {
			_tmp6_ = TRUE;
		} else {
			ValaSymbol* _tmp8_;
			_tmp8_ = self->symbol;
			_tmp6_ = VALA_IS_STRUCT (_tmp8_);
		}
		_tmp4_ = _tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaGirParserMetadata* _tmp9_;
		_tmp9_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp9_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX)) {
			ValaGirParserMetadata* _tmp10_;
			gchar* _tmp11_;
			_tmp10_ = self->metadata;
			_tmp11_ = vala_gir_parser_metadata_get_string (_tmp10_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CPREFIX);
			_g_free0 (prefix);
			prefix = _tmp11_;
		} else {
			ValaGirParserMetadata* _tmp12_;
			_tmp12_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp12_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
				ValaGirParserMetadata* _tmp13_;
				gchar* _tmp14_;
				_tmp13_ = self->metadata;
				_tmp14_ = vala_gir_parser_metadata_get_string (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
				_g_free0 (prefix);
				prefix = _tmp14_;
			} else {
				ValaSymbol* _tmp15_;
				gchar* _tmp16_;
				_tmp15_ = self->symbol;
				_tmp16_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp15_, "CCode", "cprefix", NULL);
				_g_free0 (prefix);
				prefix = _tmp16_;
			}
		}
	}
	_tmp19_ = prefix;
	if (_tmp19_ == NULL) {
		ValaMap* _tmp20_;
		_tmp20_ = self->girdata;
		_tmp18_ = _tmp20_ != NULL;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		gboolean _tmp21_ = FALSE;
		ValaMap* _tmp22_;
		_tmp22_ = self->girdata;
		if (vala_map_contains (_tmp22_, "c:symbol-prefix")) {
			_tmp21_ = TRUE;
		} else {
			ValaMap* _tmp23_;
			_tmp23_ = self->girdata;
			_tmp21_ = vala_map_contains (_tmp23_, "c:symbol-prefixes");
		}
		_tmp17_ = _tmp21_;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		ValaGirParserNode* cur = NULL;
		cur = self;
		{
			gboolean _tmp24_ = FALSE;
			_tmp24_ = TRUE;
			while (TRUE) {
				ValaGirParserNode* _tmp26_;
				ValaMap* _tmp27_;
				ValaGirParserNode* _tmp46_;
				ValaGirParserNode* _tmp47_;
				if (!_tmp24_) {
					ValaGirParserNode* _tmp25_;
					_tmp25_ = cur;
					if (!(_tmp25_ != NULL)) {
						break;
					}
				}
				_tmp24_ = FALSE;
				_tmp26_ = cur;
				_tmp27_ = _tmp26_->girdata;
				if (_tmp27_ != NULL) {
					gchar* p = NULL;
					ValaGirParserNode* _tmp28_;
					ValaMap* _tmp29_;
					gpointer _tmp30_;
					const gchar* _tmp31_;
					const gchar* _tmp41_;
					_tmp28_ = cur;
					_tmp29_ = _tmp28_->girdata;
					_tmp30_ = vala_map_get (_tmp29_, "c:symbol-prefix");
					p = (gchar*) _tmp30_;
					_tmp31_ = p;
					if (_tmp31_ == NULL) {
						ValaGirParserNode* _tmp32_;
						ValaMap* _tmp33_;
						gpointer _tmp34_;
						const gchar* _tmp35_;
						_tmp32_ = cur;
						_tmp33_ = _tmp32_->girdata;
						_tmp34_ = vala_map_get (_tmp33_, "c:symbol-prefixes");
						_g_free0 (p);
						p = (gchar*) _tmp34_;
						_tmp35_ = p;
						if (_tmp35_ != NULL) {
							gint idx = 0;
							const gchar* _tmp36_;
							gint _tmp37_;
							_tmp36_ = p;
							idx = string_index_of (_tmp36_, ",", 0);
							_tmp37_ = idx;
							if (_tmp37_ >= 0) {
								const gchar* _tmp38_;
								gint _tmp39_;
								gchar* _tmp40_;
								_tmp38_ = p;
								_tmp39_ = idx;
								_tmp40_ = string_substring (_tmp38_, (glong) 0, (glong) _tmp39_);
								_g_free0 (p);
								p = _tmp40_;
							}
						}
					}
					_tmp41_ = p;
					if (_tmp41_ != NULL) {
						const gchar* _tmp42_ = NULL;
						const gchar* _tmp43_;
						const gchar* _tmp44_;
						gchar* _tmp45_;
						_tmp43_ = prefix;
						_tmp42_ = _tmp43_;
						if (_tmp42_ == NULL) {
							_tmp42_ = "";
						}
						_tmp44_ = p;
						_tmp45_ = g_strdup_printf ("%s_%s", _tmp44_, _tmp42_);
						_g_free0 (prefix);
						prefix = _tmp45_;
					}
					_g_free0 (p);
				}
				_tmp46_ = cur;
				_tmp47_ = _tmp46_->parent;
				cur = _tmp47_;
			}
		}
	}
	_tmp48_ = prefix;
	if (_tmp48_ == NULL) {
		gchar* _tmp49_;
		_tmp49_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_g_free0 (prefix);
		prefix = _tmp49_;
	}
	result = prefix;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_lower_case_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_gir_parser_node_get_lower_case_csuffix (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s%s_", _tmp2_, _tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	result = _tmp6_;
	return result;
}


static gchar*
vala_gir_parser_node_get_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* suffix = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	const gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "lower_case_csuffix", NULL);
	suffix = _tmp1_;
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_LOWER_CASE_CSUFFIX);
		_g_free0 (suffix);
		suffix = _tmp4_;
	}
	_tmp8_ = suffix;
	if (_tmp8_ == NULL) {
		ValaMap* _tmp9_;
		_tmp9_ = self->girdata;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp10_;
		gpointer _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = self->girdata;
		_tmp11_ = vala_map_get (_tmp10_, "c:symbol-prefix");
		_tmp12_ = (gchar*) _tmp11_;
		_tmp6_ = _tmp12_ != NULL;
		_g_free0 (_tmp12_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		ValaGirParserMetadata* _tmp13_;
		_tmp13_ = self->metadata;
		_tmp5_ = !vala_gir_parser_metadata_has_argument (_tmp13_, VALA_GIR_PARSER_ARGUMENT_TYPE_NAME);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:symbol-prefix");
		_g_free0 (suffix);
		suffix = (gchar*) _tmp15_;
	}
	_tmp16_ = suffix;
	if (_tmp16_ == NULL) {
		gchar* _tmp17_;
		_tmp17_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_g_free0 (suffix);
		suffix = _tmp17_;
	}
	result = suffix;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_lower_case_csuffix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* csuffix = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp16_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	_tmp1_ = vala_symbol_camel_case_to_lower_case (_tmp0_);
	csuffix = _tmp1_;
	_tmp2_ = csuffix;
	if (g_str_has_prefix (_tmp2_, "type_")) {
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp3_ = csuffix;
		_tmp4_ = strlen ("type_");
		_tmp5_ = _tmp4_;
		_tmp6_ = string_substring (_tmp3_, (glong) _tmp5_, (glong) -1);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strconcat ("type", _tmp7_, NULL);
		_g_free0 (csuffix);
		csuffix = _tmp8_;
		_g_free0 (_tmp7_);
	} else {
		const gchar* _tmp9_;
		_tmp9_ = csuffix;
		if (g_str_has_prefix (_tmp9_, "is_")) {
			const gchar* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp10_ = csuffix;
			_tmp11_ = strlen ("is_");
			_tmp12_ = _tmp11_;
			_tmp13_ = string_substring (_tmp10_, (glong) _tmp12_, (glong) -1);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strconcat ("is", _tmp14_, NULL);
			_g_free0 (csuffix);
			csuffix = _tmp15_;
			_g_free0 (_tmp14_);
		}
	}
	_tmp16_ = csuffix;
	if (g_str_has_suffix (_tmp16_, "_class")) {
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gint _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp17_ = csuffix;
		_tmp18_ = csuffix;
		_tmp19_ = strlen (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = strlen ("_class");
		_tmp22_ = _tmp21_;
		_tmp23_ = string_substring (_tmp17_, (glong) 0, (glong) (_tmp20_ - _tmp22_));
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strconcat (_tmp24_, "class", NULL);
		_g_free0 (csuffix);
		csuffix = _tmp25_;
		_g_free0 (_tmp24_);
	}
	result = csuffix;
	return result;
}


static gchar*
vala_gir_parser_node_get_cprefix (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* prefix = NULL;
	ValaGirParserMetadata* _tmp2_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	const gchar* _tmp21_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CPREFIX);
		_g_free0 (prefix);
		prefix = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cprefix", NULL);
		_g_free0 (prefix);
		prefix = _tmp6_;
	}
	_tmp9_ = prefix;
	if (_tmp9_ == NULL) {
		ValaMap* _tmp10_;
		_tmp10_ = self->girdata;
		_tmp8_ = _tmp10_ != NULL;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		ValaMap* _tmp11_;
		gpointer _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->girdata;
		_tmp12_ = vala_map_get (_tmp11_, "c:identifier-prefixes");
		_tmp13_ = (gchar*) _tmp12_;
		_tmp7_ = _tmp13_ != NULL;
		_g_free0 (_tmp13_);
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		ValaMap* _tmp14_;
		gpointer _tmp15_;
		gint idx = 0;
		const gchar* _tmp16_;
		gint _tmp17_;
		_tmp14_ = self->girdata;
		_tmp15_ = vala_map_get (_tmp14_, "c:identifier-prefixes");
		_g_free0 (prefix);
		prefix = (gchar*) _tmp15_;
		_tmp16_ = prefix;
		idx = string_index_of (_tmp16_, ",", 0);
		_tmp17_ = idx;
		if (_tmp17_ != -1) {
			const gchar* _tmp18_;
			gint _tmp19_;
			gchar* _tmp20_;
			_tmp18_ = prefix;
			_tmp19_ = idx;
			_tmp20_ = string_substring (_tmp18_, (glong) 0, (glong) _tmp19_);
			_g_free0 (prefix);
			prefix = _tmp20_;
		}
	}
	_tmp21_ = prefix;
	if (_tmp21_ == NULL) {
		gboolean _tmp22_ = FALSE;
		ValaSymbol* _tmp23_;
		_tmp23_ = self->symbol;
		if (VALA_IS_ENUM (_tmp23_)) {
			_tmp22_ = TRUE;
		} else {
			ValaSymbol* _tmp24_;
			_tmp24_ = self->symbol;
			_tmp22_ = VALA_IS_ERROR_DOMAIN (_tmp24_);
		}
		if (_tmp22_) {
			ValaGirParserNode* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp25_ = self->parent;
			_tmp26_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp28_ = g_ascii_strup (_tmp27_, (gssize) -1);
			_tmp29_ = _tmp28_;
			_tmp30_ = self->name;
			_tmp31_ = g_strdup_printf ("%s%s", _tmp29_, _tmp30_);
			_g_free0 (prefix);
			prefix = _tmp31_;
			_g_free0 (_tmp29_);
			_g_free0 (_tmp27_);
		} else {
			gchar* _tmp32_;
			_tmp32_ = vala_gir_parser_node_get_cname (self);
			_g_free0 (prefix);
			prefix = _tmp32_;
		}
	}
	result = prefix;
	return result;
}


static gchar*
vala_gir_parser_node_get_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* cname = NULL;
	ValaGirParserMetadata* _tmp2_;
	ValaMap* _tmp7_;
	const gchar* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp2_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME)) {
		ValaGirParserMetadata* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->metadata;
		_tmp4_ = vala_gir_parser_metadata_get_string (_tmp3_, VALA_GIR_PARSER_ARGUMENT_TYPE_CNAME);
		_g_free0 (cname);
		cname = _tmp4_;
	} else {
		ValaSymbol* _tmp5_;
		gchar* _tmp6_;
		_tmp5_ = self->symbol;
		_tmp6_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp5_, "CCode", "cname", NULL);
		_g_free0 (cname);
		cname = _tmp6_;
	}
	_tmp7_ = self->girdata;
	if (_tmp7_ != NULL) {
		const gchar* _tmp8_;
		const gchar* _tmp11_;
		const gchar* _tmp14_;
		_tmp8_ = cname;
		if (_tmp8_ == NULL) {
			ValaMap* _tmp9_;
			gpointer _tmp10_;
			_tmp9_ = self->girdata;
			_tmp10_ = vala_map_get (_tmp9_, "c:identifier");
			_g_free0 (cname);
			cname = (gchar*) _tmp10_;
		}
		_tmp11_ = cname;
		if (_tmp11_ == NULL) {
			ValaMap* _tmp12_;
			gpointer _tmp13_;
			_tmp12_ = self->girdata;
			_tmp13_ = vala_map_get (_tmp12_, "c:type");
			_g_free0 (cname);
			cname = (gchar*) _tmp13_;
		}
		_tmp14_ = cname;
		if (_tmp14_ == NULL) {
			ValaMap* _tmp15_;
			gpointer _tmp16_;
			_tmp15_ = self->girdata;
			_tmp16_ = vala_map_get (_tmp15_, "glib:type-name");
			_g_free0 (cname);
			cname = (gchar*) _tmp16_;
		}
	}
	_tmp17_ = cname;
	if (_tmp17_ == NULL) {
		gchar* _tmp18_;
		_tmp18_ = vala_gir_parser_node_get_default_cname (self);
		_g_free0 (cname);
		cname = _tmp18_;
	}
	result = cname;
	return result;
}


static gchar*
vala_gir_parser_node_get_default_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaSymbol* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->name;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = self->symbol;
	if (VALA_IS_FIELD (_tmp2_)) {
		ValaSymbol* _tmp3_;
		ValaMemberBinding _tmp4_;
		ValaMemberBinding _tmp5_;
		_tmp3_ = self->symbol;
		_tmp4_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_FIELD, ValaField));
		_tmp5_ = _tmp4_;
		if (_tmp5_ == VALA_MEMBER_BINDING_STATIC) {
			ValaGirParserNode* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			_tmp6_ = self->parent;
			_tmp7_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = self->name;
			_tmp10_ = g_strconcat (_tmp8_, _tmp9_, NULL);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp8_);
			result = _tmp11_;
			return result;
		} else {
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp12_ = self->name;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			return result;
		}
	} else {
		ValaSymbol* _tmp14_;
		_tmp14_ = self->symbol;
		if (VALA_IS_METHOD (_tmp14_)) {
			ValaGirParserNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			_tmp15_ = self->parent;
			_tmp16_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = self->name;
			_tmp19_ = g_strdup_printf ("%s%s", _tmp17_, _tmp18_);
			_tmp20_ = _tmp19_;
			_g_free0 (_tmp17_);
			result = _tmp20_;
			return result;
		} else {
			ValaGirParserNode* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp21_ = self->parent;
			_tmp22_ = vala_gir_parser_node_get_cprefix (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = self->name;
			_tmp25_ = g_strdup_printf ("%s%s", _tmp23_, _tmp24_);
			_tmp26_ = _tmp25_;
			_g_free0 (_tmp23_);
			result = _tmp26_;
			return result;
		}
	}
}


static gchar*
vala_gir_parser_node_get_finish_cname (ValaGirParserNode* self)
{
	gchar* result = NULL;
	gchar* finish_cname = NULL;
	ValaSymbol* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->symbol;
	_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp0_, "CCode", "finish_name", NULL);
	finish_cname = _tmp1_;
	_tmp2_ = finish_cname;
	if (_tmp2_ == NULL) {
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp3_ = vala_gir_parser_node_get_cname (self);
		_g_free0 (finish_cname);
		finish_cname = _tmp3_;
		_tmp4_ = finish_cname;
		if (g_str_has_suffix (_tmp4_, "_async")) {
			const gchar* _tmp5_;
			const gchar* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gchar* _tmp11_;
			_tmp5_ = finish_cname;
			_tmp6_ = finish_cname;
			_tmp7_ = strlen (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = strlen ("_async");
			_tmp10_ = _tmp9_;
			_tmp11_ = string_substring (_tmp5_, (glong) 0, (glong) (_tmp8_ - _tmp10_));
			_g_free0 (finish_cname);
			finish_cname = _tmp11_;
		}
		_tmp12_ = finish_cname;
		_tmp13_ = g_strdup_printf ("%s_finish", _tmp12_);
		_g_free0 (finish_cname);
		finish_cname = _tmp13_;
	}
	result = finish_cname;
	return result;
}


static gchar*
vala_gir_parser_node_get_cheader_filename (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserMetadata* _tmp0_;
	gchar* cheader_filename = NULL;
	ValaSymbol* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValaGirParserNode* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp19_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->metadata;
	if (vala_gir_parser_metadata_has_argument (_tmp0_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
		ValaGirParserMetadata* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->metadata;
		_tmp2_ = vala_gir_parser_metadata_get_string (_tmp1_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->symbol;
	_tmp4_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp3_, "CCode", "cheader_filename", NULL);
	cheader_filename = _tmp4_;
	_tmp5_ = cheader_filename;
	if (_tmp5_ != NULL) {
		result = cheader_filename;
		return result;
	}
	_tmp6_ = self->parent;
	_tmp7_ = _tmp6_->name;
	if (_tmp7_ != NULL) {
		ValaGirParserNode* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->parent;
		_tmp9_ = vala_gir_parser_node_get_cheader_filename (_tmp8_);
		result = _tmp9_;
		_g_free0 (cheader_filename);
		return result;
	} else {
		ValaSymbol* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		_tmp10_ = self->symbol;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_ != NULL) {
			ValaSymbol* _tmp13_;
			ValaSourceReference* _tmp14_;
			ValaSourceReference* _tmp15_;
			ValaSourceFile* _tmp16_;
			ValaSourceFile* _tmp17_;
			gchar* _tmp18_;
			_tmp13_ = self->symbol;
			_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = vala_source_reference_get_file (_tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = vala_source_file_get_cinclude_filename (_tmp17_);
			result = _tmp18_;
			_g_free0 (cheader_filename);
			return result;
		}
	}
	_tmp19_ = g_strdup ("");
	result = _tmp19_;
	_g_free0 (cheader_filename);
	return result;
}


static gboolean
int64_try_parse (const gchar* str,
                 gint64* _result_,
                 const gchar* * unparsed)
{
	gint64 _vala_result = 0LL;
	const gchar* _vala_unparsed = NULL;
	gboolean result = FALSE;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	gint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	g_return_val_if_fail (str != NULL, FALSE);
	_tmp1_ = g_ascii_strtoll (str, &_tmp0_, (guint) 0);
	endptr = _tmp0_;
	_vala_result = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		_vala_unparsed = "";
		result = TRUE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp5_;
		_tmp5_ = endptr;
		_vala_unparsed = (const gchar*) _tmp5_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala_result;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
	if (_result_) {
		*_result_ = _vala_result;
	}
	if (unparsed) {
		*unparsed = _vala_unparsed;
	}
}


static guint64
vala_gir_parser_node_parse_version_string (const gchar* version)
{
	guint64 result = 0ULL;
	gint64 res = 0LL;
	gint shift = 0;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (version != NULL, 0ULL);
	res = (gint64) 0;
	shift = 16;
	_tmp1_ = _tmp0_ = g_strsplit (version, ".", 3);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp2_;
		token_collection_length1 = _tmp2__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			const gchar* token = NULL;
			token = token_collection[token_it];
			{
				gint64 t = 0LL;
				const gchar* _tmp3_;
				gint64 _tmp4_ = 0LL;
				gboolean _tmp5_;
				gint64 _tmp6_;
				gint64 _tmp7_;
				gint64 _tmp8_;
				gint _tmp9_;
				gint _tmp10_;
				_tmp3_ = token;
				_tmp5_ = int64_try_parse (_tmp3_, &_tmp4_, NULL);
				t = _tmp4_;
				if (!_tmp5_) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp6_ = t;
				if (_tmp6_ > ((gint64) 0xffff)) {
					result = (guint64) 0;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_tmp7_ = res;
				_tmp8_ = t;
				_tmp9_ = shift;
				res = _tmp7_ | (_tmp8_ << _tmp9_);
				_tmp10_ = shift;
				shift = _tmp10_ - 8;
			}
		}
	}
	result = (guint64) res;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void
vala_gir_parser_node_process (ValaGirParserNode* self,
                              ValaGirParser* parser)
{
	gboolean _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSymbol* _tmp2_;
	gboolean _tmp44_ = FALSE;
	ValaSymbol* _tmp45_;
	ValaMap* _tmp88_;
	gboolean _tmp844_ = FALSE;
	gboolean _tmp845_ = FALSE;
	gboolean _tmp846_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parser != NULL);
	_tmp0_ = self->processed;
	if (_tmp0_) {
		return;
	}
	_tmp2_ = self->symbol;
	if (VALA_IS_NAMESPACE (_tmp2_)) {
		ValaGirParserNode* _tmp3_;
		ValaGirParserNode* _tmp4_;
		_tmp3_ = self->parent;
		_tmp4_ = parser->priv->root;
		_tmp1_ = _tmp3_ == _tmp4_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp5_;
			ValaArrayList* _tmp6_;
			gint _node_size = 0;
			ValaArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _node_index = 0;
			_tmp5_ = self->members;
			_tmp6_ = _vala_iterable_ref0 (_tmp5_);
			_node_list = _tmp6_;
			_tmp7_ = _node_list;
			_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_node_size = _tmp9_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp12_;
				gint _tmp13_;
				gpointer _tmp14_;
				ValaGirParserNode* _tmp15_;
				const gchar* _tmp16_;
				_node_index = _node_index + 1;
				_tmp10_ = _node_index;
				_tmp11_ = _node_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _node_list;
				_tmp13_ = _node_index;
				_tmp14_ = vala_list_get ((ValaList*) _tmp12_, _tmp13_);
				node = (ValaGirParserNode*) _tmp14_;
				_tmp15_ = node;
				_tmp16_ = _tmp15_->element_type;
				if (g_strcmp0 (_tmp16_, "alias") == 0) {
					ValaGirParserNode* _tmp17_;
					_tmp17_ = node;
					vala_gir_parser_process_alias (parser, _tmp17_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp18_ = FALSE;
				_tmp18_ = TRUE;
				while (TRUE) {
					gint _tmp20_;
					ValaArrayList* _tmp21_;
					gint _tmp22_;
					gint _tmp23_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp24_;
					gint _tmp25_;
					gpointer _tmp26_;
					gboolean _tmp27_ = FALSE;
					ValaGirParserNode* _tmp28_;
					ValaSymbol* _tmp29_;
					if (!_tmp18_) {
						gint _tmp19_;
						_tmp19_ = i;
						i = _tmp19_ + 1;
					}
					_tmp18_ = FALSE;
					_tmp20_ = i;
					_tmp21_ = self->members;
					_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
					_tmp23_ = _tmp22_;
					if (!(_tmp20_ < _tmp23_)) {
						break;
					}
					_tmp24_ = self->members;
					_tmp25_ = i;
					_tmp26_ = vala_list_get ((ValaList*) _tmp24_, _tmp25_);
					node = (ValaGirParserNode*) _tmp26_;
					_tmp28_ = node;
					_tmp29_ = _tmp28_->symbol;
					if (VALA_IS_METHOD (_tmp29_)) {
						ValaGirParserNode* _tmp30_;
						gboolean _tmp31_;
						_tmp30_ = node;
						_tmp31_ = _tmp30_->new_symbol;
						_tmp27_ = _tmp31_;
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						ValaGirParserNode* _tmp32_;
						gboolean _tmp33_ = FALSE;
						gint _tmp34_;
						ValaArrayList* _tmp35_;
						gint _tmp36_;
						gint _tmp37_;
						_tmp32_ = node;
						vala_gir_parser_process_namespace_method (parser, self, _tmp32_);
						_tmp34_ = i;
						_tmp35_ = self->members;
						_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
						_tmp37_ = _tmp36_;
						if (_tmp34_ < _tmp37_) {
							ValaArrayList* _tmp38_;
							gint _tmp39_;
							gpointer _tmp40_;
							ValaGirParserNode* _tmp41_;
							ValaGirParserNode* _tmp42_;
							_tmp38_ = self->members;
							_tmp39_ = i;
							_tmp40_ = vala_list_get ((ValaList*) _tmp38_, _tmp39_);
							_tmp41_ = (ValaGirParserNode*) _tmp40_;
							_tmp42_ = node;
							_tmp33_ = _tmp41_ != _tmp42_;
							_vala_gir_parser_node_unref0 (_tmp41_);
						} else {
							_tmp33_ = FALSE;
						}
						if (_tmp33_) {
							gint _tmp43_;
							_tmp43_ = i;
							i = _tmp43_ - 1;
						}
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
		}
	}
	_tmp45_ = self->symbol;
	if (VALA_IS_CLASS (_tmp45_)) {
		ValaMap* _tmp46_;
		_tmp46_ = self->girdata;
		_tmp44_ = _tmp46_ != NULL;
	} else {
		_tmp44_ = FALSE;
	}
	if (_tmp44_) {
		gchar* class_struct = NULL;
		ValaMap* _tmp47_;
		gpointer _tmp48_;
		const gchar* _tmp49_;
		_tmp47_ = self->girdata;
		_tmp48_ = vala_map_get (_tmp47_, "glib:type-struct");
		class_struct = (gchar*) _tmp48_;
		_tmp49_ = class_struct;
		if (_tmp49_ != NULL) {
			ValaGirParserNode* klass = NULL;
			ValaGirParserNode* _tmp50_;
			const gchar* _tmp51_;
			ValaSourceReference* _tmp52_;
			ValaUnresolvedSymbol* _tmp53_;
			ValaUnresolvedSymbol* _tmp54_;
			ValaGirParserNode* _tmp55_;
			ValaGirParserNode* _tmp56_;
			ValaGirParserNode* _tmp57_;
			_tmp50_ = self->parent;
			_tmp51_ = class_struct;
			_tmp52_ = self->source_reference;
			_tmp53_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp51_, _tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_gir_parser_resolve_node (parser, _tmp50_, _tmp54_, FALSE);
			_tmp56_ = _tmp55_;
			_vala_code_node_unref0 (_tmp54_);
			klass = _tmp56_;
			_tmp57_ = klass;
			if (_tmp57_ != NULL) {
				gint i = 0;
				i = 0;
				while (TRUE) {
					gint _tmp58_;
					ValaGirParserNode* _tmp59_;
					ValaArrayList* _tmp60_;
					gint _tmp61_;
					gint _tmp62_;
					ValaGirParserNode* node = NULL;
					ValaGirParserNode* _tmp63_;
					ValaArrayList* _tmp64_;
					gint _tmp65_;
					gpointer _tmp66_;
					ValaGirParserNode* _tmp67_;
					ValaSymbol* _tmp68_;
					_tmp58_ = i;
					_tmp59_ = klass;
					_tmp60_ = _tmp59_->members;
					_tmp61_ = vala_collection_get_size ((ValaCollection*) _tmp60_);
					_tmp62_ = _tmp61_;
					if (!(_tmp58_ < _tmp62_)) {
						break;
					}
					_tmp63_ = klass;
					_tmp64_ = _tmp63_->members;
					_tmp65_ = i;
					_tmp66_ = vala_list_get ((ValaList*) _tmp64_, _tmp65_);
					node = (ValaGirParserNode*) _tmp66_;
					_tmp67_ = node;
					_tmp68_ = _tmp67_->symbol;
					if (VALA_IS_METHOD (_tmp68_)) {
						ValaGirParserNode* _tmp69_;
						ValaGirParserNode* _tmp70_;
						ValaGirParserNode* _tmp71_;
						ValaMethod* m = NULL;
						ValaGirParserNode* _tmp72_;
						ValaSymbol* _tmp73_;
						ValaMethod* _tmp74_;
						ValaMethod* _tmp75_;
						_tmp69_ = klass;
						_tmp70_ = node;
						vala_gir_parser_node_remove_member (_tmp69_, _tmp70_);
						_tmp71_ = node;
						vala_gir_parser_node_add_member (self, _tmp71_);
						_tmp72_ = node;
						_tmp73_ = _tmp72_->symbol;
						_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp74_;
						_tmp75_ = m;
						vala_method_set_binding (_tmp75_, VALA_MEMBER_BINDING_CLASS);
						_vala_code_node_unref0 (m);
					} else {
						gint _tmp76_;
						_tmp76_ = i;
						i = _tmp76_ + 1;
					}
					_vala_gir_parser_node_unref0 (node);
				}
			}
			_vala_gir_parser_node_unref0 (klass);
		}
		_g_free0 (class_struct);
	}
	{
		ValaArrayList* _node_list = NULL;
		ValaArrayList* _tmp77_;
		ValaArrayList* _tmp78_;
		gint _node_size = 0;
		ValaArrayList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _node_index = 0;
		_tmp77_ = self->members;
		_tmp78_ = _vala_iterable_ref0 (_tmp77_);
		_node_list = _tmp78_;
		_tmp79_ = _node_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_node_size = _tmp81_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			ValaGirParserNode* node = NULL;
			ValaArrayList* _tmp84_;
			gint _tmp85_;
			gpointer _tmp86_;
			ValaGirParserNode* _tmp87_;
			_node_index = _node_index + 1;
			_tmp82_ = _node_index;
			_tmp83_ = _node_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _node_list;
			_tmp85_ = _node_index;
			_tmp86_ = vala_list_get ((ValaList*) _tmp84_, _tmp85_);
			node = (ValaGirParserNode*) _tmp86_;
			_tmp87_ = node;
			vala_gir_parser_node_process (_tmp87_, parser);
			_vala_gir_parser_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	_tmp88_ = self->girdata;
	if (_tmp88_ != NULL) {
		ValaSymbol* _tmp89_;
		ValaGirParserMetadata* _tmp750_;
		ValaGirParserMetadata* _tmp753_;
		ValaGirParserMetadata* _tmp762_;
		const gchar* _tmp769_;
		ValaGirParserMetadata* _tmp771_;
		ValaGirParserMetadata* _tmp774_;
		ValaGirParserNode* _tmp792_;
		ValaSymbol* _tmp793_;
		gchar* _tmp802_;
		gchar* _tmp803_;
		gchar* _tmp804_;
		gchar* _tmp805_;
		gboolean _tmp806_;
		ValaGirParserMetadata* _tmp810_;
		gchar* _tmp815_;
		gchar* _tmp816_;
		gchar* _tmp817_;
		gchar* _tmp818_;
		gboolean _tmp819_;
		gchar* _tmp823_;
		gchar* _tmp824_;
		gchar* _tmp825_;
		gchar* _tmp826_;
		gboolean _tmp827_;
		gchar* gir_name = NULL;
		gchar* _tmp831_;
		gchar* default_gir_name = NULL;
		gchar* _tmp832_;
		gboolean _tmp833_ = FALSE;
		gboolean _tmp834_ = FALSE;
		ValaSymbol* _tmp835_;
		_tmp89_ = self->symbol;
		if (VALA_IS_METHOD (_tmp89_)) {
			ValaMethod* m = NULL;
			ValaSymbol* _tmp90_;
			ValaMethod* _tmp91_;
			ValaArrayList* colliding = NULL;
			ValaGirParserNode* _tmp92_;
			const gchar* _tmp93_;
			ValaArrayList* _tmp94_;
			ValaMethod* _tmp199_;
			ValaMethod* _tmp218_;
			gboolean _tmp219_;
			gboolean _tmp220_;
			_tmp90_ = self->symbol;
			_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
			m = _tmp91_;
			vala_gir_parser_process_callable (parser, self);
			_tmp92_ = self->parent;
			_tmp93_ = self->name;
			_tmp94_ = vala_gir_parser_node_lookup_all (_tmp92_, _tmp93_);
			colliding = _tmp94_;
			{
				ValaArrayList* _node_list = NULL;
				ValaArrayList* _tmp95_;
				ValaArrayList* _tmp96_;
				gint _node_size = 0;
				ValaArrayList* _tmp97_;
				gint _tmp98_;
				gint _tmp99_;
				gint _node_index = 0;
				_tmp95_ = colliding;
				_tmp96_ = _vala_iterable_ref0 (_tmp95_);
				_node_list = _tmp96_;
				_tmp97_ = _node_list;
				_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
				_tmp99_ = _tmp98_;
				_node_size = _tmp99_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp100_;
					gint _tmp101_;
					ValaGirParserNode* node = NULL;
					ValaArrayList* _tmp102_;
					gint _tmp103_;
					gpointer _tmp104_;
					ValaSymbol* sym = NULL;
					ValaGirParserNode* _tmp105_;
					ValaSymbol* _tmp106_;
					ValaSymbol* _tmp107_;
					gboolean _tmp108_ = FALSE;
					gboolean _tmp109_ = FALSE;
					ValaSymbol* _tmp110_;
					_node_index = _node_index + 1;
					_tmp100_ = _node_index;
					_tmp101_ = _node_size;
					if (!(_tmp100_ < _tmp101_)) {
						break;
					}
					_tmp102_ = _node_list;
					_tmp103_ = _node_index;
					_tmp104_ = vala_list_get ((ValaList*) _tmp102_, _tmp103_);
					node = (ValaGirParserNode*) _tmp104_;
					_tmp105_ = node;
					_tmp106_ = _tmp105_->symbol;
					_tmp107_ = _vala_code_node_ref0 (_tmp106_);
					sym = _tmp107_;
					_tmp110_ = sym;
					if (VALA_IS_FIELD (_tmp110_)) {
						ValaMethod* _tmp111_;
						ValaDataType* _tmp112_;
						ValaDataType* _tmp113_;
						_tmp111_ = m;
						_tmp112_ = vala_callable_get_return_type ((ValaCallable*) _tmp111_);
						_tmp113_ = _tmp112_;
						_tmp109_ = !VALA_IS_VOID_TYPE (_tmp113_);
					} else {
						_tmp109_ = FALSE;
					}
					if (_tmp109_) {
						ValaMethod* _tmp114_;
						ValaList* _tmp115_;
						ValaList* _tmp116_;
						gint _tmp117_;
						gint _tmp118_;
						_tmp114_ = m;
						_tmp115_ = vala_callable_get_parameters ((ValaCallable*) _tmp114_);
						_tmp116_ = _tmp115_;
						_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
						_tmp118_ = _tmp117_;
						_tmp108_ = _tmp118_ == 0;
						_vala_iterable_unref0 (_tmp116_);
					} else {
						_tmp108_ = FALSE;
					}
					if (_tmp108_) {
						self->merged = TRUE;
					} else {
						ValaSymbol* _tmp119_;
						_tmp119_ = sym;
						if (VALA_IS_SIGNAL (_tmp119_)) {
							ValaGirParserNode* _tmp120_;
							ValaSignal* sig = NULL;
							ValaSymbol* _tmp121_;
							ValaSignal* _tmp122_;
							gboolean _tmp123_ = FALSE;
							ValaMethod* _tmp124_;
							gboolean _tmp125_;
							gboolean _tmp126_;
							ValaSignal* _tmp132_;
							ValaMethod* _tmp133_;
							ValaMethod* _tmp134_;
							ValaList* _tmp135_;
							ValaList* _tmp136_;
							gint _tmp137_;
							gint _tmp138_;
							ValaSignal* _tmp139_;
							ValaList* _tmp140_;
							ValaList* _tmp141_;
							gint _tmp142_;
							gint _tmp143_;
							gboolean _tmp144_;
							_tmp120_ = node;
							vala_gir_parser_node_process (_tmp120_, parser);
							_tmp121_ = sym;
							_tmp122_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp121_, VALA_TYPE_SIGNAL, ValaSignal));
							sig = _tmp122_;
							_tmp124_ = m;
							_tmp125_ = vala_method_get_is_virtual (_tmp124_);
							_tmp126_ = _tmp125_;
							if (_tmp126_) {
								_tmp123_ = TRUE;
							} else {
								ValaMethod* _tmp127_;
								gboolean _tmp128_;
								gboolean _tmp129_;
								_tmp127_ = m;
								_tmp128_ = vala_method_get_is_abstract (_tmp127_);
								_tmp129_ = _tmp128_;
								_tmp123_ = _tmp129_;
							}
							if (_tmp123_) {
								ValaSignal* _tmp130_;
								_tmp130_ = sig;
								vala_signal_set_is_virtual (_tmp130_, TRUE);
							} else {
								ValaSignal* _tmp131_;
								_tmp131_ = sig;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp131_, "HasEmitter", TRUE, NULL);
							}
							_tmp132_ = sig;
							_tmp133_ = m;
							vala_gir_parser_assume_parameter_names (parser, _tmp132_, (ValaSymbol*) _tmp133_, FALSE);
							_tmp134_ = m;
							_tmp135_ = vala_callable_get_parameters ((ValaCallable*) _tmp134_);
							_tmp136_ = _tmp135_;
							_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
							_tmp138_ = _tmp137_;
							_tmp139_ = sig;
							_tmp140_ = vala_callable_get_parameters ((ValaCallable*) _tmp139_);
							_tmp141_ = _tmp140_;
							_tmp142_ = vala_collection_get_size ((ValaCollection*) _tmp141_);
							_tmp143_ = _tmp142_;
							_tmp144_ = _tmp138_ != _tmp143_;
							_vala_iterable_unref0 (_tmp141_);
							_vala_iterable_unref0 (_tmp136_);
							if (_tmp144_) {
								ValaSymbol* _tmp145_;
								ValaSourceReference* _tmp146_;
								ValaSourceReference* _tmp147_;
								gchar* _tmp148_;
								gchar* _tmp149_;
								gchar* _tmp150_;
								gchar* _tmp151_;
								_tmp145_ = self->symbol;
								_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp145_);
								_tmp147_ = _tmp146_;
								_tmp148_ = vala_gir_parser_node_get_full_name (self);
								_tmp149_ = _tmp148_;
								_tmp150_ = g_strdup_printf ("Signal `%s' conflicts with method of the same name", _tmp149_);
								_tmp151_ = _tmp150_;
								vala_report_warning (_tmp147_, _tmp151_);
								_g_free0 (_tmp151_);
								_g_free0 (_tmp149_);
							}
							self->merged = TRUE;
							_vala_code_node_unref0 (sig);
						} else {
							gboolean _tmp152_ = FALSE;
							gboolean _tmp153_ = FALSE;
							ValaSymbol* _tmp154_;
							_tmp154_ = sym;
							if (VALA_IS_METHOD (_tmp154_)) {
								ValaSymbol* _tmp155_;
								_tmp155_ = sym;
								_tmp153_ = !VALA_IS_CREATION_METHOD (_tmp155_);
							} else {
								_tmp153_ = FALSE;
							}
							if (_tmp153_) {
								ValaGirParserNode* _tmp156_;
								_tmp156_ = node;
								_tmp152_ = _tmp156_ != self;
							} else {
								_tmp152_ = FALSE;
							}
							if (_tmp152_) {
								gboolean _tmp157_ = FALSE;
								ValaMethod* _tmp158_;
								gboolean _tmp159_;
								gboolean _tmp160_;
								_tmp158_ = m;
								_tmp159_ = vala_method_get_is_virtual (_tmp158_);
								_tmp160_ = _tmp159_;
								if (_tmp160_) {
									_tmp157_ = TRUE;
								} else {
									ValaMethod* _tmp161_;
									gboolean _tmp162_;
									gboolean _tmp163_;
									_tmp161_ = m;
									_tmp162_ = vala_method_get_is_abstract (_tmp161_);
									_tmp163_ = _tmp162_;
									_tmp157_ = _tmp163_;
								}
								if (_tmp157_) {
									gboolean different_invoker = FALSE;
									ValaAttribute* attr = NULL;
									ValaMethod* _tmp164_;
									ValaAttribute* _tmp165_;
									ValaAttribute* _tmp166_;
									gboolean _tmp180_;
									different_invoker = FALSE;
									_tmp164_ = m;
									_tmp165_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp164_, "NoWrapper");
									attr = _tmp165_;
									_tmp166_ = attr;
									if (_tmp166_ != NULL) {
										ValaGirParserNode* invoker = NULL;
										ValaGirParserNode* _tmp167_;
										ValaGirParserNode* _tmp168_;
										_tmp167_ = vala_gir_parser_find_invoker (parser, self);
										invoker = _tmp167_;
										_tmp168_ = invoker;
										if (_tmp168_ != NULL) {
											ValaMethod* _tmp169_;
											ValaMethod* _tmp170_;
											const gchar* _tmp171_;
											const gchar* _tmp172_;
											ValaMethod* _tmp173_;
											ValaGirParserNode* _tmp174_;
											ValaSymbol* _tmp175_;
											const gchar* _tmp176_;
											const gchar* _tmp177_;
											ValaMethod* _tmp178_;
											ValaGirParserNode* _tmp179_;
											_tmp169_ = m;
											_tmp170_ = m;
											_tmp171_ = vala_symbol_get_name ((ValaSymbol*) _tmp170_);
											_tmp172_ = _tmp171_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp169_, "CCode", "vfunc_name", _tmp172_, NULL);
											_tmp173_ = m;
											_tmp174_ = invoker;
											_tmp175_ = _tmp174_->symbol;
											_tmp176_ = vala_symbol_get_name (_tmp175_);
											_tmp177_ = _tmp176_;
											vala_symbol_set_name ((ValaSymbol*) _tmp173_, _tmp177_);
											_tmp178_ = m;
											vala_code_node_set_attribute ((ValaCodeNode*) _tmp178_, "NoWrapper", FALSE, NULL);
											_tmp179_ = invoker;
											_tmp179_->merged = TRUE;
											different_invoker = TRUE;
										}
										_vala_gir_parser_node_unref0 (invoker);
									}
									_tmp180_ = different_invoker;
									if (!_tmp180_) {
										ValaAttribute* _tmp181_;
										ValaGirParserNode* _tmp189_;
										_tmp181_ = attr;
										if (_tmp181_ != NULL) {
											ValaSymbol* _tmp182_;
											ValaSourceReference* _tmp183_;
											ValaSourceReference* _tmp184_;
											gchar* _tmp185_;
											gchar* _tmp186_;
											gchar* _tmp187_;
											gchar* _tmp188_;
											_tmp182_ = self->symbol;
											_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp182_);
											_tmp184_ = _tmp183_;
											_tmp185_ = vala_gir_parser_node_get_full_name (self);
											_tmp186_ = _tmp185_;
											_tmp187_ = g_strdup_printf ("Virtual method `%s' conflicts with method of the same name", _tmp186_);
											_tmp188_ = _tmp187_;
											vala_report_warning (_tmp184_, _tmp188_);
											_g_free0 (_tmp188_);
											_g_free0 (_tmp186_);
										}
										_tmp189_ = node;
										_tmp189_->merged = TRUE;
									}
									_vala_code_node_unref0 (attr);
								} else {
									ValaMethod* _tmp190_;
									_tmp190_ = m;
									if (vala_symbol_is_class_member ((ValaSymbol*) _tmp190_)) {
										ValaSymbol* _tmp191_;
										ValaSourceReference* _tmp192_;
										ValaSourceReference* _tmp193_;
										gchar* _tmp194_;
										gchar* _tmp195_;
										gchar* _tmp196_;
										gchar* _tmp197_;
										ValaGirParserNode* _tmp198_;
										_tmp191_ = self->symbol;
										_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp191_);
										_tmp193_ = _tmp192_;
										_tmp194_ = vala_gir_parser_node_get_full_name (self);
										_tmp195_ = _tmp194_;
										_tmp196_ = g_strdup_printf ("Class method `%s' conflicts with method of the same name", _tmp195_);
										_tmp197_ = _tmp196_;
										vala_report_warning (_tmp193_, _tmp197_);
										_g_free0 (_tmp197_);
										_g_free0 (_tmp195_);
										_tmp198_ = node;
										_tmp198_->merged = TRUE;
									}
								}
							}
						}
					}
					_vala_code_node_unref0 (sym);
					_vala_gir_parser_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			_tmp199_ = m;
			if (!VALA_IS_CREATION_METHOD (_tmp199_)) {
				ValaGirParserMetadata* _tmp200_;
				ValaGirParserMetadata* _tmp203_;
				ValaGirParserMetadata* _tmp206_;
				_tmp200_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp200_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE)) {
					ValaMethod* _tmp201_;
					ValaGirParserMetadata* _tmp202_;
					_tmp201_ = m;
					_tmp202_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp201_, "DestroysInstance", vala_gir_parser_metadata_get_bool (_tmp202_, VALA_GIR_PARSER_ARGUMENT_TYPE_DESTROYS_INSTANCE, FALSE), NULL);
				}
				_tmp203_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp203_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER)) {
					ValaMethod* _tmp204_;
					ValaGirParserMetadata* _tmp205_;
					_tmp204_ = m;
					_tmp205_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp204_, "ReturnsModifiedPointer", vala_gir_parser_metadata_get_bool (_tmp205_, VALA_GIR_PARSER_ARGUMENT_TYPE_RETURNS_MODIFIED_POINTER, FALSE), NULL);
				}
				_tmp206_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp206_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME)) {
					ValaGirParserNode* vfunc = NULL;
					ValaGirParserNode* _tmp207_;
					ValaGirParserMetadata* _tmp208_;
					gchar* _tmp209_;
					gchar* _tmp210_;
					ValaGirParserNode* _tmp211_;
					ValaGirParserNode* _tmp212_;
					gboolean _tmp213_ = FALSE;
					ValaGirParserNode* _tmp214_;
					_tmp207_ = self->parent;
					_tmp208_ = self->metadata;
					_tmp209_ = vala_gir_parser_metadata_get_string (_tmp208_, VALA_GIR_PARSER_ARGUMENT_TYPE_VFUNC_NAME);
					_tmp210_ = _tmp209_;
					_tmp211_ = vala_gir_parser_node_lookup (_tmp207_, _tmp210_, FALSE, NULL);
					_tmp212_ = _tmp211_;
					_g_free0 (_tmp210_);
					vfunc = _tmp212_;
					_tmp214_ = vfunc;
					if (_tmp214_ != NULL) {
						ValaGirParserNode* _tmp215_;
						_tmp215_ = vfunc;
						_tmp213_ = _tmp215_ != self;
					} else {
						_tmp213_ = FALSE;
					}
					if (_tmp213_) {
						ValaGirParserNode* _tmp216_;
						ValaGirParserNode* _tmp217_;
						_tmp216_ = vfunc;
						_tmp216_->processed = TRUE;
						_tmp217_ = vfunc;
						_tmp217_->merged = TRUE;
					}
					_vala_gir_parser_node_unref0 (vfunc);
				}
			}
			_tmp218_ = m;
			_tmp219_ = vala_method_get_coroutine (_tmp218_);
			_tmp220_ = _tmp219_;
			if (_tmp220_) {
				vala_gir_parser_process_async_method (parser, self);
			}
			_vala_iterable_unref0 (colliding);
			_vala_code_node_unref0 (m);
		} else {
			ValaSymbol* _tmp221_;
			_tmp221_ = self->symbol;
			if (VALA_IS_PROPERTY (_tmp221_)) {
				ValaArrayList* colliding = NULL;
				ValaGirParserNode* _tmp222_;
				const gchar* _tmp223_;
				ValaArrayList* _tmp224_;
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp249_;
				ValaProperty* _tmp250_;
				gchar* readable = NULL;
				ValaMap* _tmp251_;
				gpointer _tmp252_;
				gchar* writable = NULL;
				ValaMap* _tmp253_;
				gpointer _tmp254_;
				gchar* construct_ = NULL;
				ValaMap* _tmp255_;
				gpointer _tmp256_;
				gchar* construct_only = NULL;
				ValaMap* _tmp257_;
				gpointer _tmp258_;
				const gchar* _tmp259_;
				gboolean _tmp268_ = FALSE;
				const gchar* _tmp269_;
				ValaProperty* _tmp285_;
				ValaDataType* _tmp286_;
				ValaDataType* _tmp287_;
				ValaGirParserNode* getter = NULL;
				ValaArrayList* getters = NULL;
				ValaGirParserNode* _tmp288_;
				const gchar* _tmp289_;
				gchar* _tmp290_;
				gchar* _tmp291_;
				ValaArrayList* _tmp292_;
				ValaArrayList* _tmp293_;
				ValaArrayList* _tmp294_;
				ValaGirParserNode* setter = NULL;
				ValaArrayList* setters = NULL;
				ValaGirParserNode* _tmp321_;
				const gchar* _tmp322_;
				gchar* _tmp323_;
				gchar* _tmp324_;
				ValaArrayList* _tmp325_;
				ValaArrayList* _tmp326_;
				ValaArrayList* _tmp327_;
				gboolean _tmp354_ = FALSE;
				const gchar* _tmp355_;
				ValaProperty* _tmp357_;
				ValaProperty* _tmp358_;
				ValaPropertyAccessor* _tmp359_;
				ValaPropertyAccessor* _tmp360_;
				gboolean _tmp423_ = FALSE;
				gboolean _tmp424_ = FALSE;
				ValaProperty* _tmp425_;
				ValaAttribute* _tmp426_;
				ValaAttribute* _tmp427_;
				gboolean _tmp428_;
				ValaProperty* _tmp499_;
				ValaAttribute* _tmp500_;
				ValaAttribute* _tmp501_;
				gboolean _tmp502_;
				ValaGirParserMetadata* _tmp550_;
				ValaProperty* _tmp553_;
				ValaAttribute* _tmp554_;
				ValaAttribute* _tmp555_;
				gboolean _tmp556_;
				_tmp222_ = self->parent;
				_tmp223_ = self->name;
				_tmp224_ = vala_gir_parser_node_lookup_all (_tmp222_, _tmp223_);
				colliding = _tmp224_;
				{
					ValaArrayList* _node_list = NULL;
					ValaArrayList* _tmp225_;
					ValaArrayList* _tmp226_;
					gint _node_size = 0;
					ValaArrayList* _tmp227_;
					gint _tmp228_;
					gint _tmp229_;
					gint _node_index = 0;
					_tmp225_ = colliding;
					_tmp226_ = _vala_iterable_ref0 (_tmp225_);
					_node_list = _tmp226_;
					_tmp227_ = _node_list;
					_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
					_tmp229_ = _tmp228_;
					_node_size = _tmp229_;
					_node_index = -1;
					while (TRUE) {
						gint _tmp230_;
						gint _tmp231_;
						ValaGirParserNode* node = NULL;
						ValaArrayList* _tmp232_;
						gint _tmp233_;
						gpointer _tmp234_;
						ValaGirParserNode* _tmp235_;
						ValaSymbol* _tmp236_;
						_node_index = _node_index + 1;
						_tmp230_ = _node_index;
						_tmp231_ = _node_size;
						if (!(_tmp230_ < _tmp231_)) {
							break;
						}
						_tmp232_ = _node_list;
						_tmp233_ = _node_index;
						_tmp234_ = vala_list_get ((ValaList*) _tmp232_, _tmp233_);
						node = (ValaGirParserNode*) _tmp234_;
						_tmp235_ = node;
						_tmp236_ = _tmp235_->symbol;
						if (VALA_IS_SIGNAL (_tmp236_)) {
							ValaGirParserNode* _tmp237_;
							ValaGirParserNode* _tmp238_;
							ValaSymbol* _tmp239_;
							ValaSourceReference* _tmp240_;
							ValaSourceReference* _tmp241_;
							gchar* _tmp242_;
							gchar* _tmp243_;
							gchar* _tmp244_;
							gchar* _tmp245_;
							_tmp237_ = node;
							_tmp237_->processed = TRUE;
							_tmp238_ = node;
							_tmp238_->merged = TRUE;
							_tmp239_ = self->symbol;
							_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp239_);
							_tmp241_ = _tmp240_;
							_tmp242_ = vala_gir_parser_node_get_full_name (self);
							_tmp243_ = _tmp242_;
							_tmp244_ = g_strdup_printf ("Signal `%s' conflicts with property of the same name", _tmp243_);
							_tmp245_ = _tmp244_;
							vala_report_warning (_tmp241_, _tmp245_);
							_g_free0 (_tmp245_);
							_g_free0 (_tmp243_);
						} else {
							ValaGirParserNode* _tmp246_;
							ValaSymbol* _tmp247_;
							_tmp246_ = node;
							_tmp247_ = _tmp246_->symbol;
							if (VALA_IS_METHOD (_tmp247_)) {
								ValaGirParserNode* _tmp248_;
								_tmp248_ = node;
								_tmp248_->merged = TRUE;
							}
						}
						_vala_gir_parser_node_unref0 (node);
					}
					_vala_iterable_unref0 (_node_list);
				}
				_tmp249_ = self->symbol;
				_tmp250_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp249_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp250_;
				_tmp251_ = self->girdata;
				_tmp252_ = vala_map_get (_tmp251_, "readable");
				readable = (gchar*) _tmp252_;
				_tmp253_ = self->girdata;
				_tmp254_ = vala_map_get (_tmp253_, "writable");
				writable = (gchar*) _tmp254_;
				_tmp255_ = self->girdata;
				_tmp256_ = vala_map_get (_tmp255_, "construct");
				construct_ = (gchar*) _tmp256_;
				_tmp257_ = self->girdata;
				_tmp258_ = vala_map_get (_tmp257_, "construct-only");
				construct_only = (gchar*) _tmp258_;
				_tmp259_ = readable;
				if (g_strcmp0 (_tmp259_, "0") != 0) {
					ValaProperty* _tmp260_;
					ValaProperty* _tmp261_;
					ValaDataType* _tmp262_;
					ValaDataType* _tmp263_;
					ValaDataType* _tmp264_;
					ValaDataType* _tmp265_;
					ValaPropertyAccessor* _tmp266_;
					ValaPropertyAccessor* _tmp267_;
					_tmp260_ = prop;
					_tmp261_ = prop;
					_tmp262_ = vala_property_get_property_type (_tmp261_);
					_tmp263_ = _tmp262_;
					_tmp264_ = vala_data_type_copy (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp265_, NULL, NULL, NULL);
					_tmp267_ = _tmp266_;
					vala_property_set_get_accessor (_tmp260_, _tmp267_);
					_vala_code_node_unref0 (_tmp267_);
					_vala_code_node_unref0 (_tmp265_);
				}
				_tmp269_ = writable;
				if (g_strcmp0 (_tmp269_, "1") == 0) {
					_tmp268_ = TRUE;
				} else {
					const gchar* _tmp270_;
					_tmp270_ = construct_only;
					_tmp268_ = g_strcmp0 (_tmp270_, "1") == 0;
				}
				if (_tmp268_) {
					gboolean _tmp271_ = FALSE;
					const gchar* _tmp272_;
					gboolean _tmp274_ = FALSE;
					const gchar* _tmp275_;
					ValaProperty* _tmp277_;
					ValaProperty* _tmp278_;
					ValaDataType* _tmp279_;
					ValaDataType* _tmp280_;
					ValaDataType* _tmp281_;
					ValaDataType* _tmp282_;
					ValaPropertyAccessor* _tmp283_;
					ValaPropertyAccessor* _tmp284_;
					_tmp272_ = construct_only;
					if (g_strcmp0 (_tmp272_, "1") != 0) {
						const gchar* _tmp273_;
						_tmp273_ = writable;
						_tmp271_ = g_strcmp0 (_tmp273_, "1") == 0;
					} else {
						_tmp271_ = FALSE;
					}
					_tmp275_ = construct_only;
					if (g_strcmp0 (_tmp275_, "1") == 0) {
						_tmp274_ = TRUE;
					} else {
						const gchar* _tmp276_;
						_tmp276_ = construct_;
						_tmp274_ = g_strcmp0 (_tmp276_, "1") == 0;
					}
					_tmp277_ = prop;
					_tmp278_ = prop;
					_tmp279_ = vala_property_get_property_type (_tmp278_);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_data_type_copy (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = vala_property_accessor_new (FALSE, _tmp271_, _tmp274_, _tmp282_, NULL, NULL, NULL);
					_tmp284_ = _tmp283_;
					vala_property_set_set_accessor (_tmp277_, _tmp284_);
					_vala_code_node_unref0 (_tmp284_);
					_vala_code_node_unref0 (_tmp282_);
				}
				_tmp285_ = prop;
				_tmp286_ = vala_property_get_property_type (_tmp285_);
				_tmp287_ = _tmp286_;
				vala_data_type_set_value_owned (_tmp287_, TRUE);
				getter = NULL;
				_tmp288_ = self->parent;
				_tmp289_ = self->name;
				_tmp290_ = g_strdup_printf ("get_%s", _tmp289_);
				_tmp291_ = _tmp290_;
				_tmp292_ = vala_gir_parser_node_lookup_all (_tmp288_, _tmp291_);
				_tmp293_ = _tmp292_;
				_g_free0 (_tmp291_);
				getters = _tmp293_;
				_tmp294_ = getters;
				if (_tmp294_ != NULL) {
					{
						ValaArrayList* _g_list = NULL;
						ValaArrayList* _tmp295_;
						ValaArrayList* _tmp296_;
						gint _g_size = 0;
						ValaArrayList* _tmp297_;
						gint _tmp298_;
						gint _tmp299_;
						gint _g_index = 0;
						_tmp295_ = getters;
						_tmp296_ = _vala_iterable_ref0 (_tmp295_);
						_g_list = _tmp296_;
						_tmp297_ = _g_list;
						_tmp298_ = vala_collection_get_size ((ValaCollection*) _tmp297_);
						_tmp299_ = _tmp298_;
						_g_size = _tmp299_;
						_g_index = -1;
						while (TRUE) {
							gint _tmp300_;
							gint _tmp301_;
							ValaGirParserNode* g = NULL;
							ValaArrayList* _tmp302_;
							gint _tmp303_;
							gpointer _tmp304_;
							gboolean _tmp305_ = FALSE;
							gboolean _tmp306_ = FALSE;
							ValaGirParserNode* _tmp307_;
							_g_index = _g_index + 1;
							_tmp300_ = _g_index;
							_tmp301_ = _g_size;
							if (!(_tmp300_ < _tmp301_)) {
								break;
							}
							_tmp302_ = _g_list;
							_tmp303_ = _g_index;
							_tmp304_ = vala_list_get ((ValaList*) _tmp302_, _tmp303_);
							g = (ValaGirParserNode*) _tmp304_;
							_tmp307_ = getter;
							if (_tmp307_ == NULL) {
								_tmp306_ = TRUE;
							} else {
								ValaGirParserNode* _tmp308_;
								gboolean _tmp309_;
								_tmp308_ = g;
								_tmp309_ = _tmp308_->merged;
								_tmp306_ = !_tmp309_;
							}
							if (_tmp306_) {
								ValaGirParserNode* _tmp310_;
								gchar* _tmp311_;
								gchar* _tmp312_;
								ValaGirParserNode* _tmp313_;
								gchar* _tmp314_;
								gchar* _tmp315_;
								const gchar* _tmp316_;
								gchar* _tmp317_;
								gchar* _tmp318_;
								_tmp310_ = g;
								_tmp311_ = vala_gir_parser_node_get_cname (_tmp310_);
								_tmp312_ = _tmp311_;
								_tmp313_ = self->parent;
								_tmp314_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp313_);
								_tmp315_ = _tmp314_;
								_tmp316_ = self->name;
								_tmp317_ = g_strdup_printf ("%sget_%s", _tmp315_, _tmp316_);
								_tmp318_ = _tmp317_;
								_tmp305_ = g_strcmp0 (_tmp312_, _tmp318_) == 0;
								_g_free0 (_tmp318_);
								_g_free0 (_tmp315_);
								_g_free0 (_tmp312_);
							} else {
								_tmp305_ = FALSE;
							}
							if (_tmp305_) {
								ValaGirParserNode* _tmp319_;
								ValaGirParserNode* _tmp320_;
								_tmp319_ = g;
								_tmp320_ = _vala_gir_parser_node_ref0 (_tmp319_);
								_vala_gir_parser_node_unref0 (getter);
								getter = _tmp320_;
							}
							_vala_gir_parser_node_unref0 (g);
						}
						_vala_iterable_unref0 (_g_list);
					}
				}
				setter = NULL;
				_tmp321_ = self->parent;
				_tmp322_ = self->name;
				_tmp323_ = g_strdup_printf ("set_%s", _tmp322_);
				_tmp324_ = _tmp323_;
				_tmp325_ = vala_gir_parser_node_lookup_all (_tmp321_, _tmp324_);
				_tmp326_ = _tmp325_;
				_g_free0 (_tmp324_);
				setters = _tmp326_;
				_tmp327_ = setters;
				if (_tmp327_ != NULL) {
					{
						ValaArrayList* _s_list = NULL;
						ValaArrayList* _tmp328_;
						ValaArrayList* _tmp329_;
						gint _s_size = 0;
						ValaArrayList* _tmp330_;
						gint _tmp331_;
						gint _tmp332_;
						gint _s_index = 0;
						_tmp328_ = setters;
						_tmp329_ = _vala_iterable_ref0 (_tmp328_);
						_s_list = _tmp329_;
						_tmp330_ = _s_list;
						_tmp331_ = vala_collection_get_size ((ValaCollection*) _tmp330_);
						_tmp332_ = _tmp331_;
						_s_size = _tmp332_;
						_s_index = -1;
						while (TRUE) {
							gint _tmp333_;
							gint _tmp334_;
							ValaGirParserNode* s = NULL;
							ValaArrayList* _tmp335_;
							gint _tmp336_;
							gpointer _tmp337_;
							gboolean _tmp338_ = FALSE;
							gboolean _tmp339_ = FALSE;
							ValaGirParserNode* _tmp340_;
							_s_index = _s_index + 1;
							_tmp333_ = _s_index;
							_tmp334_ = _s_size;
							if (!(_tmp333_ < _tmp334_)) {
								break;
							}
							_tmp335_ = _s_list;
							_tmp336_ = _s_index;
							_tmp337_ = vala_list_get ((ValaList*) _tmp335_, _tmp336_);
							s = (ValaGirParserNode*) _tmp337_;
							_tmp340_ = setter;
							if (_tmp340_ == NULL) {
								_tmp339_ = TRUE;
							} else {
								ValaGirParserNode* _tmp341_;
								gboolean _tmp342_;
								_tmp341_ = s;
								_tmp342_ = _tmp341_->merged;
								_tmp339_ = !_tmp342_;
							}
							if (_tmp339_) {
								ValaGirParserNode* _tmp343_;
								gchar* _tmp344_;
								gchar* _tmp345_;
								ValaGirParserNode* _tmp346_;
								gchar* _tmp347_;
								gchar* _tmp348_;
								const gchar* _tmp349_;
								gchar* _tmp350_;
								gchar* _tmp351_;
								_tmp343_ = s;
								_tmp344_ = vala_gir_parser_node_get_cname (_tmp343_);
								_tmp345_ = _tmp344_;
								_tmp346_ = self->parent;
								_tmp347_ = vala_gir_parser_node_get_lower_case_cprefix (_tmp346_);
								_tmp348_ = _tmp347_;
								_tmp349_ = self->name;
								_tmp350_ = g_strdup_printf ("%sset_%s", _tmp348_, _tmp349_);
								_tmp351_ = _tmp350_;
								_tmp338_ = g_strcmp0 (_tmp345_, _tmp351_) == 0;
								_g_free0 (_tmp351_);
								_g_free0 (_tmp348_);
								_g_free0 (_tmp345_);
							} else {
								_tmp338_ = FALSE;
							}
							if (_tmp338_) {
								ValaGirParserNode* _tmp352_;
								ValaGirParserNode* _tmp353_;
								_tmp352_ = s;
								_tmp353_ = _vala_gir_parser_node_ref0 (_tmp352_);
								_vala_gir_parser_node_unref0 (setter);
								setter = _tmp353_;
							}
							_vala_gir_parser_node_unref0 (s);
						}
						_vala_iterable_unref0 (_s_list);
					}
				}
				_tmp355_ = readable;
				if (g_strcmp0 (_tmp355_, "0") == 0) {
					const gchar* _tmp356_;
					_tmp356_ = construct_only;
					_tmp354_ = g_strcmp0 (_tmp356_, "1") == 0;
				} else {
					_tmp354_ = FALSE;
				}
				_tmp357_ = prop;
				vala_code_node_set_attribute ((ValaCodeNode*) _tmp357_, "NoAccessorMethod", _tmp354_, NULL);
				_tmp358_ = prop;
				_tmp359_ = vala_property_get_get_accessor (_tmp358_);
				_tmp360_ = _tmp359_;
				if (_tmp360_ != NULL) {
					ValaMethod* _tmp361_ = NULL;
					ValaGirParserNode* _tmp362_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp365_;
					ValaMethod* _tmp366_;
					_tmp362_ = getter;
					if (_tmp362_ != NULL) {
						ValaGirParserNode* _tmp363_;
						ValaSymbol* _tmp364_;
						_tmp363_ = getter;
						_tmp364_ = _tmp363_->symbol;
						_tmp361_ = VALA_IS_METHOD (_tmp364_) ? ((ValaMethod*) _tmp364_) : NULL;
					} else {
						_tmp361_ = NULL;
					}
					_tmp365_ = _vala_code_node_ref0 (_tmp361_);
					m = _tmp365_;
					_tmp366_ = m;
					if (_tmp366_ != NULL) {
						ValaGirParserNode* _tmp367_;
						gboolean _tmp368_ = FALSE;
						gboolean _tmp369_ = FALSE;
						ValaMethod* _tmp370_;
						ValaDataType* _tmp371_;
						ValaDataType* _tmp372_;
						_tmp367_ = getter;
						vala_gir_parser_node_process (_tmp367_, parser);
						_tmp370_ = m;
						_tmp371_ = vala_callable_get_return_type ((ValaCallable*) _tmp370_);
						_tmp372_ = _tmp371_;
						if (VALA_IS_VOID_TYPE (_tmp372_)) {
							_tmp369_ = TRUE;
						} else {
							ValaMethod* _tmp373_;
							ValaList* _tmp374_;
							ValaList* _tmp375_;
							gint _tmp376_;
							gint _tmp377_;
							_tmp373_ = m;
							_tmp374_ = vala_callable_get_parameters ((ValaCallable*) _tmp373_);
							_tmp375_ = _tmp374_;
							_tmp376_ = vala_collection_get_size ((ValaCollection*) _tmp375_);
							_tmp377_ = _tmp376_;
							_tmp369_ = _tmp377_ != 0;
							_vala_iterable_unref0 (_tmp375_);
						}
						if (_tmp369_) {
							_tmp368_ = TRUE;
						} else {
							ValaMethod* _tmp378_;
							ValaList* _tmp379_;
							ValaList* _tmp380_;
							gint _tmp381_;
							gint _tmp382_;
							_tmp378_ = m;
							_tmp379_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp378_);
							_tmp380_ = _tmp379_;
							_tmp381_ = vala_collection_get_size ((ValaCollection*) _tmp380_);
							_tmp382_ = _tmp381_;
							_tmp368_ = _tmp382_ > 0;
							_vala_iterable_unref0 (_tmp380_);
						}
						if (_tmp368_) {
							ValaProperty* _tmp383_;
							_tmp383_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp383_, "NoAccessorMethod", TRUE, NULL);
						} else {
							ValaGirParserNode* _tmp384_;
							const gchar* _tmp385_;
							const gchar* _tmp386_;
							ValaProperty* _tmp400_;
							ValaPropertyAccessor* _tmp401_;
							ValaPropertyAccessor* _tmp402_;
							ValaDataType* _tmp403_;
							ValaDataType* _tmp404_;
							ValaMethod* _tmp405_;
							ValaDataType* _tmp406_;
							ValaDataType* _tmp407_;
							gboolean _tmp408_;
							gboolean _tmp409_;
							gboolean _tmp410_ = FALSE;
							gboolean _tmp411_ = FALSE;
							ValaMethod* _tmp412_;
							gboolean _tmp413_;
							gboolean _tmp414_;
							_tmp384_ = getter;
							_tmp385_ = _tmp384_->name;
							_tmp386_ = self->name;
							if (g_strcmp0 (_tmp385_, _tmp386_) == 0) {
								{
									ValaArrayList* _node_list = NULL;
									ValaArrayList* _tmp387_;
									ValaArrayList* _tmp388_;
									gint _node_size = 0;
									ValaArrayList* _tmp389_;
									gint _tmp390_;
									gint _tmp391_;
									gint _node_index = 0;
									_tmp387_ = colliding;
									_tmp388_ = _vala_iterable_ref0 (_tmp387_);
									_node_list = _tmp388_;
									_tmp389_ = _node_list;
									_tmp390_ = vala_collection_get_size ((ValaCollection*) _tmp389_);
									_tmp391_ = _tmp390_;
									_node_size = _tmp391_;
									_node_index = -1;
									while (TRUE) {
										gint _tmp392_;
										gint _tmp393_;
										ValaGirParserNode* node = NULL;
										ValaArrayList* _tmp394_;
										gint _tmp395_;
										gpointer _tmp396_;
										ValaGirParserNode* _tmp397_;
										ValaSymbol* _tmp398_;
										_node_index = _node_index + 1;
										_tmp392_ = _node_index;
										_tmp393_ = _node_size;
										if (!(_tmp392_ < _tmp393_)) {
											break;
										}
										_tmp394_ = _node_list;
										_tmp395_ = _node_index;
										_tmp396_ = vala_list_get ((ValaList*) _tmp394_, _tmp395_);
										node = (ValaGirParserNode*) _tmp396_;
										_tmp397_ = node;
										_tmp398_ = _tmp397_->symbol;
										if (VALA_IS_METHOD (_tmp398_)) {
											ValaGirParserNode* _tmp399_;
											_tmp399_ = node;
											_tmp399_->merged = TRUE;
										}
										_vala_gir_parser_node_unref0 (node);
									}
									_vala_iterable_unref0 (_node_list);
								}
							}
							_tmp400_ = prop;
							_tmp401_ = vala_property_get_get_accessor (_tmp400_);
							_tmp402_ = _tmp401_;
							_tmp403_ = vala_property_accessor_get_value_type (_tmp402_);
							_tmp404_ = _tmp403_;
							_tmp405_ = m;
							_tmp406_ = vala_callable_get_return_type ((ValaCallable*) _tmp405_);
							_tmp407_ = _tmp406_;
							_tmp408_ = vala_data_type_get_value_owned (_tmp407_);
							_tmp409_ = _tmp408_;
							vala_data_type_set_value_owned (_tmp404_, _tmp409_);
							_tmp412_ = m;
							_tmp413_ = vala_method_get_is_abstract (_tmp412_);
							_tmp414_ = _tmp413_;
							if (!_tmp414_) {
								ValaMethod* _tmp415_;
								gboolean _tmp416_;
								gboolean _tmp417_;
								_tmp415_ = m;
								_tmp416_ = vala_method_get_is_virtual (_tmp415_);
								_tmp417_ = _tmp416_;
								_tmp411_ = !_tmp417_;
							} else {
								_tmp411_ = FALSE;
							}
							if (_tmp411_) {
								ValaProperty* _tmp418_;
								gboolean _tmp419_;
								gboolean _tmp420_;
								_tmp418_ = prop;
								_tmp419_ = vala_property_get_is_abstract (_tmp418_);
								_tmp420_ = _tmp419_;
								_tmp410_ = _tmp420_;
							} else {
								_tmp410_ = FALSE;
							}
							if (_tmp410_) {
								ValaProperty* _tmp421_;
								_tmp421_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp421_, "ConcreteAccessor", TRUE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp422_;
						_tmp422_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp422_, "NoAccessorMethod", TRUE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp425_ = prop;
				_tmp426_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp425_, "NoAccessorMethod");
				_tmp427_ = _tmp426_;
				_tmp428_ = _tmp427_ == NULL;
				_vala_code_node_unref0 (_tmp427_);
				if (_tmp428_) {
					ValaProperty* _tmp429_;
					ValaPropertyAccessor* _tmp430_;
					ValaPropertyAccessor* _tmp431_;
					_tmp429_ = prop;
					_tmp430_ = vala_property_get_set_accessor (_tmp429_);
					_tmp431_ = _tmp430_;
					_tmp424_ = _tmp431_ != NULL;
				} else {
					_tmp424_ = FALSE;
				}
				if (_tmp424_) {
					ValaProperty* _tmp432_;
					ValaPropertyAccessor* _tmp433_;
					ValaPropertyAccessor* _tmp434_;
					gboolean _tmp435_;
					gboolean _tmp436_;
					_tmp432_ = prop;
					_tmp433_ = vala_property_get_set_accessor (_tmp432_);
					_tmp434_ = _tmp433_;
					_tmp435_ = vala_property_accessor_get_writable (_tmp434_);
					_tmp436_ = _tmp435_;
					_tmp423_ = _tmp436_;
				} else {
					_tmp423_ = FALSE;
				}
				if (_tmp423_) {
					ValaMethod* _tmp437_ = NULL;
					ValaGirParserNode* _tmp438_;
					ValaMethod* m = NULL;
					ValaMethod* _tmp441_;
					ValaMethod* _tmp442_;
					_tmp438_ = setter;
					if (_tmp438_ != NULL) {
						ValaGirParserNode* _tmp439_;
						ValaSymbol* _tmp440_;
						_tmp439_ = setter;
						_tmp440_ = _tmp439_->symbol;
						_tmp437_ = VALA_IS_METHOD (_tmp440_) ? ((ValaMethod*) _tmp440_) : NULL;
					} else {
						_tmp437_ = NULL;
					}
					_tmp441_ = _vala_code_node_ref0 (_tmp437_);
					m = _tmp441_;
					_tmp442_ = m;
					if (_tmp442_ != NULL) {
						ValaGirParserNode* _tmp443_;
						gboolean _tmp444_ = FALSE;
						gboolean _tmp445_ = FALSE;
						gboolean _tmp446_ = FALSE;
						ValaMethod* _tmp447_;
						ValaDataType* _tmp448_;
						ValaDataType* _tmp449_;
						_tmp443_ = setter;
						vala_gir_parser_node_process (_tmp443_, parser);
						_tmp447_ = m;
						_tmp448_ = vala_callable_get_return_type ((ValaCallable*) _tmp447_);
						_tmp449_ = _tmp448_;
						if (VALA_IS_VOID_TYPE (_tmp449_)) {
							_tmp446_ = TRUE;
						} else {
							ValaMethod* _tmp450_;
							ValaDataType* _tmp451_;
							ValaDataType* _tmp452_;
							_tmp450_ = m;
							_tmp451_ = vala_callable_get_return_type ((ValaCallable*) _tmp450_);
							_tmp452_ = _tmp451_;
							_tmp446_ = VALA_IS_BOOLEAN_TYPE (_tmp452_);
						}
						if (!_tmp446_) {
							_tmp445_ = TRUE;
						} else {
							ValaMethod* _tmp453_;
							ValaList* _tmp454_;
							ValaList* _tmp455_;
							gint _tmp456_;
							gint _tmp457_;
							_tmp453_ = m;
							_tmp454_ = vala_callable_get_parameters ((ValaCallable*) _tmp453_);
							_tmp455_ = _tmp454_;
							_tmp456_ = vala_collection_get_size ((ValaCollection*) _tmp455_);
							_tmp457_ = _tmp456_;
							_tmp445_ = _tmp457_ != 1;
							_vala_iterable_unref0 (_tmp455_);
						}
						if (_tmp445_) {
							_tmp444_ = TRUE;
						} else {
							ValaMethod* _tmp458_;
							ValaList* _tmp459_;
							ValaList* _tmp460_;
							gint _tmp461_;
							gint _tmp462_;
							_tmp458_ = m;
							_tmp459_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp458_);
							_tmp460_ = _tmp459_;
							_tmp461_ = vala_collection_get_size ((ValaCollection*) _tmp460_);
							_tmp462_ = _tmp461_;
							_tmp444_ = _tmp462_ > 0;
							_vala_iterable_unref0 (_tmp460_);
						}
						if (_tmp444_) {
							ValaProperty* _tmp463_;
							ValaProperty* _tmp464_;
							_tmp463_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp463_, "NoAccessorMethod", TRUE, NULL);
							_tmp464_ = prop;
							vala_code_node_set_attribute ((ValaCodeNode*) _tmp464_, "ConcreteAccessor", FALSE, NULL);
						} else {
							ValaProperty* _tmp465_;
							ValaPropertyAccessor* _tmp466_;
							ValaPropertyAccessor* _tmp467_;
							ValaDataType* _tmp468_;
							ValaDataType* _tmp469_;
							ValaMethod* _tmp470_;
							ValaList* _tmp471_;
							ValaList* _tmp472_;
							gpointer _tmp473_;
							ValaParameter* _tmp474_;
							ValaDataType* _tmp475_;
							ValaDataType* _tmp476_;
							gboolean _tmp477_;
							gboolean _tmp478_;
							gboolean _tmp479_ = FALSE;
							gboolean _tmp480_ = FALSE;
							gboolean _tmp481_ = FALSE;
							ValaProperty* _tmp482_;
							ValaAttribute* _tmp483_;
							ValaAttribute* _tmp484_;
							gboolean _tmp485_;
							_tmp465_ = prop;
							_tmp466_ = vala_property_get_set_accessor (_tmp465_);
							_tmp467_ = _tmp466_;
							_tmp468_ = vala_property_accessor_get_value_type (_tmp467_);
							_tmp469_ = _tmp468_;
							_tmp470_ = m;
							_tmp471_ = vala_callable_get_parameters ((ValaCallable*) _tmp470_);
							_tmp472_ = _tmp471_;
							_tmp473_ = vala_list_get (_tmp472_, 0);
							_tmp474_ = (ValaParameter*) _tmp473_;
							_tmp475_ = vala_variable_get_variable_type ((ValaVariable*) _tmp474_);
							_tmp476_ = _tmp475_;
							_tmp477_ = vala_data_type_get_value_owned (_tmp476_);
							_tmp478_ = _tmp477_;
							vala_data_type_set_value_owned (_tmp469_, _tmp478_);
							_vala_code_node_unref0 (_tmp474_);
							_vala_iterable_unref0 (_tmp472_);
							_tmp482_ = prop;
							_tmp483_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp482_, "ConcreteAccessor");
							_tmp484_ = _tmp483_;
							_tmp485_ = _tmp484_ != NULL;
							_vala_code_node_unref0 (_tmp484_);
							if (_tmp485_) {
								ValaMethod* _tmp486_;
								gboolean _tmp487_;
								gboolean _tmp488_;
								_tmp486_ = m;
								_tmp487_ = vala_method_get_is_abstract (_tmp486_);
								_tmp488_ = _tmp487_;
								_tmp481_ = !_tmp488_;
							} else {
								_tmp481_ = FALSE;
							}
							if (_tmp481_) {
								ValaMethod* _tmp489_;
								gboolean _tmp490_;
								gboolean _tmp491_;
								_tmp489_ = m;
								_tmp490_ = vala_method_get_is_virtual (_tmp489_);
								_tmp491_ = _tmp490_;
								_tmp480_ = !_tmp491_;
							} else {
								_tmp480_ = FALSE;
							}
							if (_tmp480_) {
								ValaProperty* _tmp492_;
								gboolean _tmp493_;
								gboolean _tmp494_;
								_tmp492_ = prop;
								_tmp493_ = vala_property_get_is_abstract (_tmp492_);
								_tmp494_ = _tmp493_;
								_tmp479_ = _tmp494_;
							} else {
								_tmp479_ = FALSE;
							}
							if (_tmp479_) {
								ValaProperty* _tmp495_;
								ValaProperty* _tmp496_;
								_tmp495_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp495_, "ConcreteAccessor", TRUE, NULL);
								_tmp496_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp496_, "NoAccessorMethod", FALSE, NULL);
							}
						}
					} else {
						ValaProperty* _tmp497_;
						ValaProperty* _tmp498_;
						_tmp497_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp497_, "NoAccessorMethod", TRUE, NULL);
						_tmp498_ = prop;
						vala_code_node_set_attribute ((ValaCodeNode*) _tmp498_, "ConcreteAccessor", FALSE, NULL);
					}
					_vala_code_node_unref0 (m);
				}
				_tmp499_ = prop;
				_tmp500_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp499_, "NoAccessorMethod");
				_tmp501_ = _tmp500_;
				_tmp502_ = _tmp501_ != NULL;
				_vala_code_node_unref0 (_tmp501_);
				if (_tmp502_) {
					gboolean _tmp503_ = FALSE;
					ValaProperty* _tmp504_;
					gboolean _tmp505_;
					gboolean _tmp506_;
					_tmp504_ = prop;
					_tmp505_ = vala_property_get_overrides (_tmp504_);
					_tmp506_ = _tmp505_;
					if (!_tmp506_) {
						ValaGirParserNode* _tmp507_;
						ValaSymbol* _tmp508_;
						_tmp507_ = self->parent;
						_tmp508_ = _tmp507_->symbol;
						_tmp503_ = VALA_IS_CLASS (_tmp508_);
					} else {
						_tmp503_ = FALSE;
					}
					if (_tmp503_) {
						ValaGirParserNode* base_prop_node = NULL;
						ValaGirParserNode* _tmp509_;
						ValaGirParserNode* _tmp510_;
						_tmp509_ = vala_gir_parser_base_interface_property (parser, self);
						base_prop_node = _tmp509_;
						_tmp510_ = base_prop_node;
						if (_tmp510_ != NULL) {
							ValaGirParserNode* _tmp511_;
							ValaProperty* base_property = NULL;
							ValaGirParserNode* _tmp512_;
							ValaSymbol* _tmp513_;
							ValaProperty* _tmp514_;
							ValaProperty* _tmp515_;
							ValaAttribute* _tmp516_;
							ValaAttribute* _tmp517_;
							gboolean _tmp518_;
							_tmp511_ = base_prop_node;
							vala_gir_parser_node_process (_tmp511_, parser);
							_tmp512_ = base_prop_node;
							_tmp513_ = _tmp512_->symbol;
							_tmp514_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp513_, VALA_TYPE_PROPERTY, ValaProperty));
							base_property = _tmp514_;
							_tmp515_ = base_property;
							_tmp516_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp515_, "ConcreteAccessor");
							_tmp517_ = _tmp516_;
							_tmp518_ = _tmp517_ != NULL;
							_vala_code_node_unref0 (_tmp517_);
							if (_tmp518_) {
								ValaProperty* _tmp519_;
								ValaProperty* _tmp520_;
								ValaPropertyAccessor* _tmp521_;
								ValaPropertyAccessor* _tmp522_;
								ValaProperty* _tmp535_;
								ValaPropertyAccessor* _tmp536_;
								ValaPropertyAccessor* _tmp537_;
								_tmp519_ = prop;
								vala_code_node_set_attribute ((ValaCodeNode*) _tmp519_, "NoAccessorMethod", FALSE, NULL);
								_tmp520_ = prop;
								_tmp521_ = vala_property_get_get_accessor (_tmp520_);
								_tmp522_ = _tmp521_;
								if (_tmp522_ != NULL) {
									ValaProperty* _tmp523_;
									ValaPropertyAccessor* _tmp524_;
									ValaPropertyAccessor* _tmp525_;
									ValaDataType* _tmp526_;
									ValaDataType* _tmp527_;
									ValaProperty* _tmp528_;
									ValaPropertyAccessor* _tmp529_;
									ValaPropertyAccessor* _tmp530_;
									ValaDataType* _tmp531_;
									ValaDataType* _tmp532_;
									gboolean _tmp533_;
									gboolean _tmp534_;
									_tmp523_ = prop;
									_tmp524_ = vala_property_get_get_accessor (_tmp523_);
									_tmp525_ = _tmp524_;
									_tmp526_ = vala_property_accessor_get_value_type (_tmp525_);
									_tmp527_ = _tmp526_;
									_tmp528_ = base_property;
									_tmp529_ = vala_property_get_get_accessor (_tmp528_);
									_tmp530_ = _tmp529_;
									_tmp531_ = vala_property_accessor_get_value_type (_tmp530_);
									_tmp532_ = _tmp531_;
									_tmp533_ = vala_data_type_get_value_owned (_tmp532_);
									_tmp534_ = _tmp533_;
									vala_data_type_set_value_owned (_tmp527_, _tmp534_);
								}
								_tmp535_ = prop;
								_tmp536_ = vala_property_get_set_accessor (_tmp535_);
								_tmp537_ = _tmp536_;
								if (_tmp537_ != NULL) {
									ValaProperty* _tmp538_;
									ValaPropertyAccessor* _tmp539_;
									ValaPropertyAccessor* _tmp540_;
									ValaDataType* _tmp541_;
									ValaDataType* _tmp542_;
									ValaProperty* _tmp543_;
									ValaPropertyAccessor* _tmp544_;
									ValaPropertyAccessor* _tmp545_;
									ValaDataType* _tmp546_;
									ValaDataType* _tmp547_;
									gboolean _tmp548_;
									gboolean _tmp549_;
									_tmp538_ = prop;
									_tmp539_ = vala_property_get_set_accessor (_tmp538_);
									_tmp540_ = _tmp539_;
									_tmp541_ = vala_property_accessor_get_value_type (_tmp540_);
									_tmp542_ = _tmp541_;
									_tmp543_ = base_property;
									_tmp544_ = vala_property_get_set_accessor (_tmp543_);
									_tmp545_ = _tmp544_;
									_tmp546_ = vala_property_accessor_get_value_type (_tmp545_);
									_tmp547_ = _tmp546_;
									_tmp548_ = vala_data_type_get_value_owned (_tmp547_);
									_tmp549_ = _tmp548_;
									vala_data_type_set_value_owned (_tmp542_, _tmp549_);
								}
							}
							_vala_code_node_unref0 (base_property);
						}
						_vala_gir_parser_node_unref0 (base_prop_node);
					}
				}
				_tmp550_ = self->metadata;
				if (vala_gir_parser_metadata_has_argument (_tmp550_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD)) {
					ValaProperty* _tmp551_;
					ValaGirParserMetadata* _tmp552_;
					_tmp551_ = prop;
					_tmp552_ = self->metadata;
					vala_code_node_set_attribute ((ValaCodeNode*) _tmp551_, "NoAccessorMethod", vala_gir_parser_metadata_get_bool (_tmp552_, VALA_GIR_PARSER_ARGUMENT_TYPE_NO_ACCESSOR_METHOD, FALSE), NULL);
				}
				_tmp553_ = prop;
				_tmp554_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp553_, "NoAccessorMethod");
				_tmp555_ = _tmp554_;
				_tmp556_ = _tmp555_ != NULL;
				_vala_code_node_unref0 (_tmp555_);
				if (_tmp556_) {
					ValaProperty* _tmp557_;
					ValaPropertyAccessor* _tmp558_;
					ValaPropertyAccessor* _tmp559_;
					ValaProperty* _tmp565_;
					ValaPropertyAccessor* _tmp566_;
					ValaPropertyAccessor* _tmp567_;
					_tmp557_ = prop;
					_tmp558_ = vala_property_get_get_accessor (_tmp557_);
					_tmp559_ = _tmp558_;
					if (_tmp559_ != NULL) {
						ValaProperty* _tmp560_;
						ValaPropertyAccessor* _tmp561_;
						ValaPropertyAccessor* _tmp562_;
						ValaDataType* _tmp563_;
						ValaDataType* _tmp564_;
						_tmp560_ = prop;
						_tmp561_ = vala_property_get_get_accessor (_tmp560_);
						_tmp562_ = _tmp561_;
						_tmp563_ = vala_property_accessor_get_value_type (_tmp562_);
						_tmp564_ = _tmp563_;
						vala_data_type_set_value_owned (_tmp564_, TRUE);
					}
					_tmp565_ = prop;
					_tmp566_ = vala_property_get_set_accessor (_tmp565_);
					_tmp567_ = _tmp566_;
					if (_tmp567_ != NULL) {
						ValaProperty* _tmp568_;
						ValaPropertyAccessor* _tmp569_;
						ValaPropertyAccessor* _tmp570_;
						ValaDataType* _tmp571_;
						ValaDataType* _tmp572_;
						_tmp568_ = prop;
						_tmp569_ = vala_property_get_set_accessor (_tmp568_);
						_tmp570_ = _tmp569_;
						_tmp571_ = vala_property_accessor_get_value_type (_tmp570_);
						_tmp572_ = _tmp571_;
						vala_data_type_set_value_owned (_tmp572_, FALSE);
					}
				}
				_vala_iterable_unref0 (setters);
				_vala_gir_parser_node_unref0 (setter);
				_vala_iterable_unref0 (getters);
				_vala_gir_parser_node_unref0 (getter);
				_g_free0 (construct_only);
				_g_free0 (construct_);
				_g_free0 (writable);
				_g_free0 (readable);
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (colliding);
			} else {
				ValaSymbol* _tmp573_;
				_tmp573_ = self->symbol;
				if (VALA_IS_FIELD (_tmp573_)) {
					ValaField* field = NULL;
					ValaSymbol* _tmp574_;
					ValaField* _tmp575_;
					ValaArrayList* colliding = NULL;
					ValaGirParserNode* _tmp576_;
					const gchar* _tmp577_;
					ValaArrayList* _tmp578_;
					ValaArrayList* _tmp579_;
					gint _tmp580_;
					gint _tmp581_;
					ValaGirParserMetadata* _tmp582_;
					ValaGirParserMetadata* _tmp585_;
					gboolean _tmp590_ = FALSE;
					ValaField* _tmp591_;
					ValaDataType* _tmp592_;
					ValaDataType* _tmp593_;
					_tmp574_ = self->symbol;
					_tmp575_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp574_, VALA_TYPE_FIELD, ValaField));
					field = _tmp575_;
					_tmp576_ = self->parent;
					_tmp577_ = self->name;
					_tmp578_ = vala_gir_parser_node_lookup_all (_tmp576_, _tmp577_);
					colliding = _tmp578_;
					_tmp579_ = colliding;
					_tmp580_ = vala_collection_get_size ((ValaCollection*) _tmp579_);
					_tmp581_ = _tmp580_;
					if (_tmp581_ > 1) {
						self->merged = TRUE;
					}
					_tmp582_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp582_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET)) {
						ValaField* _tmp583_;
						ValaGirParserMetadata* _tmp584_;
						_tmp583_ = field;
						_tmp584_ = self->metadata;
						vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp583_, "CCode", "delegate_target", vala_gir_parser_metadata_get_bool (_tmp584_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET, FALSE), NULL);
					}
					_tmp585_ = self->metadata;
					if (vala_gir_parser_metadata_has_argument (_tmp585_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME)) {
						ValaField* _tmp586_;
						ValaGirParserMetadata* _tmp587_;
						gchar* _tmp588_;
						gchar* _tmp589_;
						_tmp586_ = field;
						_tmp587_ = self->metadata;
						_tmp588_ = vala_gir_parser_metadata_get_string (_tmp587_, VALA_GIR_PARSER_ARGUMENT_TYPE_DELEGATE_TARGET_CNAME);
						_tmp589_ = _tmp588_;
						vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp586_, "CCode", "delegate_target_cname", _tmp589_, NULL);
						_g_free0 (_tmp589_);
					}
					_tmp591_ = field;
					_tmp592_ = vala_variable_get_variable_type ((ValaVariable*) _tmp591_);
					_tmp593_ = _tmp592_;
					if (VALA_IS_DELEGATE_TYPE (_tmp593_)) {
						ValaGirParserNode* _tmp594_;
						ValaUnresolvedSymbol* _tmp595_;
						_tmp594_ = self->parent;
						_tmp595_ = _tmp594_->gtype_struct_for;
						_tmp590_ = _tmp595_ != NULL;
					} else {
						_tmp590_ = FALSE;
					}
					if (_tmp590_) {
						ValaDelegate* d = NULL;
						ValaField* _tmp596_;
						ValaDataType* _tmp597_;
						ValaDataType* _tmp598_;
						ValaDelegate* _tmp599_;
						ValaDelegate* _tmp600_;
						ValaDelegate* _tmp601_;
						ValaDelegate* _tmp602_;
						ValaGirParserNode* _tmp603_;
						ValaUnresolvedSymbol* _tmp604_;
						_tmp596_ = field;
						_tmp597_ = vala_variable_get_variable_type ((ValaVariable*) _tmp596_);
						_tmp598_ = _tmp597_;
						_tmp599_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp598_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp600_ = _tmp599_;
						_tmp601_ = _vala_code_node_ref0 (_tmp600_);
						d = _tmp601_;
						_tmp602_ = d;
						_tmp603_ = self->parent;
						_tmp604_ = _tmp603_->gtype_struct_for;
						vala_gir_parser_process_virtual_method_field (parser, self, _tmp602_, _tmp604_);
						self->merged = TRUE;
						_vala_code_node_unref0 (d);
					} else {
						ValaField* _tmp605_;
						ValaDataType* _tmp606_;
						ValaDataType* _tmp607_;
						_tmp605_ = field;
						_tmp606_ = vala_variable_get_variable_type ((ValaVariable*) _tmp605_);
						_tmp607_ = _tmp606_;
						if (VALA_IS_ARRAY_TYPE (_tmp607_)) {
							ValaGirParserNode* array_length = NULL;
							ValaGirParserMetadata* _tmp608_;
							gboolean _tmp648_ = FALSE;
							ValaGirParserNode* _tmp649_;
							_tmp608_ = self->metadata;
							if (vala_gir_parser_metadata_has_argument (_tmp608_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD)) {
								ValaGirParserNode* _tmp609_;
								ValaGirParserMetadata* _tmp610_;
								gchar* _tmp611_;
								gchar* _tmp612_;
								ValaGirParserNode* _tmp613_;
								_tmp609_ = self->parent;
								_tmp610_ = self->metadata;
								_tmp611_ = vala_gir_parser_metadata_get_string (_tmp610_, VALA_GIR_PARSER_ARGUMENT_TYPE_ARRAY_LENGTH_FIELD);
								_tmp612_ = _tmp611_;
								_tmp613_ = vala_gir_parser_node_lookup (_tmp609_, _tmp612_, FALSE, NULL);
								_vala_gir_parser_node_unref0 (array_length);
								array_length = _tmp613_;
								_g_free0 (_tmp612_);
							} else {
								gboolean _tmp614_ = FALSE;
								gint _tmp615_;
								_tmp615_ = self->array_length_idx;
								if (_tmp615_ > -1) {
									ValaGirParserNode* _tmp616_;
									ValaArrayList* _tmp617_;
									gint _tmp618_;
									gint _tmp619_;
									gint _tmp620_;
									_tmp616_ = self->parent;
									_tmp617_ = _tmp616_->members;
									_tmp618_ = vala_collection_get_size ((ValaCollection*) _tmp617_);
									_tmp619_ = _tmp618_;
									_tmp620_ = self->array_length_idx;
									_tmp614_ = _tmp619_ > _tmp620_;
								} else {
									_tmp614_ = FALSE;
								}
								if (_tmp614_) {
									ValaGirParserNode* _tmp621_;
									ValaArrayList* _tmp622_;
									gint _tmp623_;
									gpointer _tmp624_;
									_tmp621_ = self->parent;
									_tmp622_ = _tmp621_->members;
									_tmp623_ = self->array_length_idx;
									_tmp624_ = vala_list_get ((ValaList*) _tmp622_, _tmp623_);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = (ValaGirParserNode*) _tmp624_;
								} else {
									ValaGirParserNode* _tmp625_;
									ValaField* _tmp626_;
									const gchar* _tmp627_;
									const gchar* _tmp628_;
									gchar* _tmp629_;
									gchar* _tmp630_;
									ValaGirParserNode* _tmp631_;
									ValaGirParserNode* _tmp632_;
									_tmp625_ = self->parent;
									_tmp626_ = field;
									_tmp627_ = vala_symbol_get_name ((ValaSymbol*) _tmp626_);
									_tmp628_ = _tmp627_;
									_tmp629_ = g_strdup_printf ("n_%s", _tmp628_);
									_tmp630_ = _tmp629_;
									_tmp631_ = vala_gir_parser_node_lookup (_tmp625_, _tmp630_, FALSE, NULL);
									_vala_gir_parser_node_unref0 (array_length);
									array_length = _tmp631_;
									_g_free0 (_tmp630_);
									_tmp632_ = array_length;
									if (_tmp632_ == NULL) {
										ValaGirParserNode* _tmp633_;
										ValaField* _tmp634_;
										const gchar* _tmp635_;
										const gchar* _tmp636_;
										gchar* _tmp637_;
										gchar* _tmp638_;
										ValaGirParserNode* _tmp639_;
										ValaGirParserNode* _tmp640_;
										_tmp633_ = self->parent;
										_tmp634_ = field;
										_tmp635_ = vala_symbol_get_name ((ValaSymbol*) _tmp634_);
										_tmp636_ = _tmp635_;
										_tmp637_ = g_strdup_printf ("num_%s", _tmp636_);
										_tmp638_ = _tmp637_;
										_tmp639_ = vala_gir_parser_node_lookup (_tmp633_, _tmp638_, FALSE, NULL);
										_vala_gir_parser_node_unref0 (array_length);
										array_length = _tmp639_;
										_g_free0 (_tmp638_);
										_tmp640_ = array_length;
										if (_tmp640_ == NULL) {
											ValaGirParserNode* _tmp641_;
											ValaField* _tmp642_;
											const gchar* _tmp643_;
											const gchar* _tmp644_;
											gchar* _tmp645_;
											gchar* _tmp646_;
											ValaGirParserNode* _tmp647_;
											_tmp641_ = self->parent;
											_tmp642_ = field;
											_tmp643_ = vala_symbol_get_name ((ValaSymbol*) _tmp642_);
											_tmp644_ = _tmp643_;
											_tmp645_ = g_strdup_printf ("%s_length", _tmp644_);
											_tmp646_ = _tmp645_;
											_tmp647_ = vala_gir_parser_node_lookup (_tmp641_, _tmp646_, FALSE, NULL);
											_vala_gir_parser_node_unref0 (array_length);
											array_length = _tmp647_;
											_g_free0 (_tmp646_);
										}
									}
								}
							}
							_tmp649_ = array_length;
							if (_tmp649_ != NULL) {
								ValaGirParserNode* _tmp650_;
								ValaSymbol* _tmp651_;
								_tmp650_ = array_length;
								_tmp651_ = _tmp650_->symbol;
								_tmp648_ = VALA_IS_FIELD (_tmp651_);
							} else {
								_tmp648_ = FALSE;
							}
							if (_tmp648_) {
								ValaField* length_field = NULL;
								ValaGirParserNode* _tmp652_;
								ValaSymbol* _tmp653_;
								ValaField* _tmp654_;
								ValaField* _tmp655_;
								ValaField* _tmp656_;
								const gchar* _tmp657_;
								const gchar* _tmp658_;
								gchar* length_type = NULL;
								ValaField* _tmp659_;
								ValaDataType* _tmp660_;
								ValaDataType* _tmp661_;
								gchar* _tmp662_;
								const gchar* _tmp663_;
								ValaField* _tmp672_;
								ValaField* _tmp673_;
								_tmp652_ = array_length;
								_tmp653_ = _tmp652_->symbol;
								_tmp654_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp653_, VALA_TYPE_FIELD, ValaField));
								length_field = _tmp654_;
								_tmp655_ = field;
								_tmp656_ = length_field;
								_tmp657_ = vala_symbol_get_name ((ValaSymbol*) _tmp656_);
								_tmp658_ = _tmp657_;
								vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp655_, "CCode", "array_length_cname", _tmp658_, NULL);
								_tmp659_ = length_field;
								_tmp660_ = vala_variable_get_variable_type ((ValaVariable*) _tmp659_);
								_tmp661_ = _tmp660_;
								_tmp662_ = vala_data_type_to_qualified_string (_tmp661_, NULL);
								length_type = _tmp662_;
								_tmp663_ = length_type;
								if (g_strcmp0 (_tmp663_, "int") != 0) {
									ValaGirParserNode* st = NULL;
									ValaGirParserNode* _tmp664_;
									const gchar* _tmp665_;
									ValaGirParserNode* _tmp666_;
									ValaGirParserNode* _tmp667_;
									_tmp664_ = parser->priv->root;
									_tmp665_ = length_type;
									_tmp666_ = vala_gir_parser_node_lookup (_tmp664_, _tmp665_, FALSE, NULL);
									st = _tmp666_;
									_tmp667_ = st;
									if (_tmp667_ != NULL) {
										ValaField* _tmp668_;
										ValaGirParserNode* _tmp669_;
										gchar* _tmp670_;
										gchar* _tmp671_;
										_tmp668_ = field;
										_tmp669_ = st;
										_tmp670_ = vala_gir_parser_node_get_cname (_tmp669_);
										_tmp671_ = _tmp670_;
										vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp668_, "CCode", "array_length_type", _tmp671_, NULL);
										_g_free0 (_tmp671_);
									}
									_vala_gir_parser_node_unref0 (st);
								}
								_tmp672_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp672_, "CCode", "array_length");
								_tmp673_ = field;
								vala_code_node_remove_attribute_argument ((ValaCodeNode*) _tmp673_, "CCode", "array_null_terminated");
								_g_free0 (length_type);
								_vala_code_node_unref0 (length_field);
							}
							_vala_gir_parser_node_unref0 (array_length);
						}
					}
					_vala_iterable_unref0 (colliding);
					_vala_code_node_unref0 (field);
				} else {
					gboolean _tmp674_ = FALSE;
					ValaSymbol* _tmp675_;
					_tmp675_ = self->symbol;
					if (VALA_IS_SIGNAL (_tmp675_)) {
						_tmp674_ = TRUE;
					} else {
						ValaSymbol* _tmp676_;
						_tmp676_ = self->symbol;
						_tmp674_ = VALA_IS_DELEGATE (_tmp676_);
					}
					if (_tmp674_) {
						vala_gir_parser_process_callable (parser, self);
					} else {
						ValaSymbol* _tmp677_;
						_tmp677_ = self->symbol;
						if (VALA_IS_INTERFACE (_tmp677_)) {
							vala_gir_parser_process_interface (parser, self);
						} else {
							ValaSymbol* _tmp678_;
							_tmp678_ = self->symbol;
							if (VALA_IS_STRUCT (_tmp678_)) {
								gboolean _tmp679_ = FALSE;
								ValaGirParserNode* _tmp680_;
								ValaSymbol* _tmp681_;
								_tmp680_ = self->parent;
								_tmp681_ = _tmp680_->symbol;
								if (VALA_IS_OBJECT_TYPE_SYMBOL (_tmp681_)) {
									_tmp679_ = TRUE;
								} else {
									ValaGirParserNode* _tmp682_;
									ValaSymbol* _tmp683_;
									_tmp682_ = self->parent;
									_tmp683_ = _tmp682_->symbol;
									_tmp679_ = VALA_IS_STRUCT (_tmp683_);
								}
								if (_tmp679_) {
									{
										ValaArrayList* _fn_list = NULL;
										ValaArrayList* _tmp684_;
										ValaArrayList* _tmp685_;
										gint _fn_size = 0;
										ValaArrayList* _tmp686_;
										gint _tmp687_;
										gint _tmp688_;
										gint _fn_index = 0;
										_tmp684_ = self->members;
										_tmp685_ = _vala_iterable_ref0 (_tmp684_);
										_fn_list = _tmp685_;
										_tmp686_ = _fn_list;
										_tmp687_ = vala_collection_get_size ((ValaCollection*) _tmp686_);
										_tmp688_ = _tmp687_;
										_fn_size = _tmp688_;
										_fn_index = -1;
										while (TRUE) {
											gint _tmp689_;
											gint _tmp690_;
											ValaGirParserNode* fn = NULL;
											ValaArrayList* _tmp691_;
											gint _tmp692_;
											gpointer _tmp693_;
											ValaField* f = NULL;
											ValaGirParserNode* _tmp694_;
											ValaSymbol* _tmp695_;
											ValaField* _tmp696_;
											ValaField* _tmp697_;
											_fn_index = _fn_index + 1;
											_tmp689_ = _fn_index;
											_tmp690_ = _fn_size;
											if (!(_tmp689_ < _tmp690_)) {
												break;
											}
											_tmp691_ = _fn_list;
											_tmp692_ = _fn_index;
											_tmp693_ = vala_list_get ((ValaList*) _tmp691_, _tmp692_);
											fn = (ValaGirParserNode*) _tmp693_;
											_tmp694_ = fn;
											_tmp695_ = _tmp694_->symbol;
											_tmp696_ = _vala_code_node_ref0 (VALA_IS_FIELD (_tmp695_) ? ((ValaField*) _tmp695_) : NULL);
											f = _tmp696_;
											_tmp697_ = f;
											if (_tmp697_ != NULL) {
												ValaField* _tmp698_;
												ValaMemberBinding _tmp699_;
												ValaMemberBinding _tmp700_;
												ValaField* _tmp708_;
												ValaSymbol* _tmp709_;
												const gchar* _tmp710_;
												const gchar* _tmp711_;
												ValaField* _tmp712_;
												const gchar* _tmp713_;
												const gchar* _tmp714_;
												gchar* _tmp715_;
												gchar* _tmp716_;
												ValaGirParserNode* _tmp717_;
												ValaField* _tmp718_;
												const gchar* _tmp719_;
												const gchar* _tmp720_;
												gchar* _tmp721_;
												ValaGirParserNode* _tmp722_;
												ValaGirParserNode* _tmp723_;
												_tmp698_ = f;
												_tmp699_ = vala_field_get_binding (_tmp698_);
												_tmp700_ = _tmp699_;
												if (_tmp700_ == VALA_MEMBER_BINDING_INSTANCE) {
													ValaField* _tmp701_;
													const gchar* _tmp702_;
													ValaGirParserNode* _tmp703_;
													gchar* _tmp704_;
													gchar* _tmp705_;
													gchar* _tmp706_;
													gchar* _tmp707_;
													_tmp701_ = f;
													_tmp702_ = self->name;
													_tmp703_ = fn;
													_tmp704_ = vala_gir_parser_node_get_cname (_tmp703_);
													_tmp705_ = _tmp704_;
													_tmp706_ = g_strdup_printf ("%s.%s", _tmp702_, _tmp705_);
													_tmp707_ = _tmp706_;
													vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp701_, "CCode", "cname", _tmp707_, NULL);
													_g_free0 (_tmp707_);
													_g_free0 (_tmp705_);
												}
												_tmp708_ = f;
												_tmp709_ = self->symbol;
												_tmp710_ = vala_symbol_get_name (_tmp709_);
												_tmp711_ = _tmp710_;
												_tmp712_ = f;
												_tmp713_ = vala_symbol_get_name ((ValaSymbol*) _tmp712_);
												_tmp714_ = _tmp713_;
												_tmp715_ = g_strdup_printf ("%s_%s", _tmp711_, _tmp714_);
												_tmp716_ = _tmp715_;
												vala_symbol_set_name ((ValaSymbol*) _tmp708_, _tmp716_);
												_g_free0 (_tmp716_);
												_tmp717_ = fn;
												_tmp718_ = f;
												_tmp719_ = vala_symbol_get_name ((ValaSymbol*) _tmp718_);
												_tmp720_ = _tmp719_;
												_tmp721_ = g_strdup (_tmp720_);
												_g_free0 (_tmp717_->name);
												_tmp717_->name = _tmp721_;
												_tmp722_ = self->parent;
												_tmp723_ = fn;
												vala_gir_parser_node_add_member (_tmp722_, _tmp723_);
											}
											_vala_code_node_unref0 (f);
											_vala_gir_parser_node_unref0 (fn);
										}
										_vala_iterable_unref0 (_fn_list);
									}
									self->merged = TRUE;
								} else {
									gchar* gtype_struct_for = NULL;
									ValaMap* _tmp724_;
									gpointer _tmp725_;
									const gchar* _tmp726_;
									_tmp724_ = self->girdata;
									_tmp725_ = vala_map_get (_tmp724_, "glib:is-gtype-struct-for");
									gtype_struct_for = (gchar*) _tmp725_;
									_tmp726_ = gtype_struct_for;
									if (_tmp726_ != NULL) {
										ValaGirParserNode* iface = NULL;
										ValaGirParserNode* _tmp727_;
										const gchar* _tmp728_;
										ValaSourceReference* _tmp729_;
										ValaUnresolvedSymbol* _tmp730_;
										ValaUnresolvedSymbol* _tmp731_;
										ValaGirParserNode* _tmp732_;
										ValaGirParserNode* _tmp733_;
										gboolean _tmp734_ = FALSE;
										gboolean _tmp735_ = FALSE;
										ValaGirParserNode* _tmp736_;
										_tmp727_ = self->parent;
										_tmp728_ = gtype_struct_for;
										_tmp729_ = self->source_reference;
										_tmp730_ = vala_gir_parser_parse_symbol_from_string (parser, _tmp728_, _tmp729_);
										_tmp731_ = _tmp730_;
										_tmp732_ = vala_gir_parser_resolve_node (parser, _tmp727_, _tmp731_, FALSE);
										_tmp733_ = _tmp732_;
										_vala_code_node_unref0 (_tmp731_);
										iface = _tmp733_;
										_tmp736_ = iface;
										if (_tmp736_ != NULL) {
											ValaGirParserNode* _tmp737_;
											ValaSymbol* _tmp738_;
											_tmp737_ = iface;
											_tmp738_ = _tmp737_->symbol;
											_tmp735_ = VALA_IS_INTERFACE (_tmp738_);
										} else {
											_tmp735_ = FALSE;
										}
										if (_tmp735_) {
											ValaGirParserNode* _tmp739_;
											gchar* _tmp740_;
											gchar* _tmp741_;
											gchar* _tmp742_;
											gchar* _tmp743_;
											gchar* _tmp744_;
											gchar* _tmp745_;
											_tmp739_ = iface;
											_tmp740_ = vala_gir_parser_node_get_cname (_tmp739_);
											_tmp741_ = _tmp740_;
											_tmp742_ = g_strdup_printf ("%sIface", _tmp741_);
											_tmp743_ = _tmp742_;
											_tmp744_ = vala_gir_parser_node_get_cname (self);
											_tmp745_ = _tmp744_;
											_tmp734_ = g_strcmp0 (_tmp743_, _tmp745_) != 0;
											_g_free0 (_tmp745_);
											_g_free0 (_tmp743_);
											_g_free0 (_tmp741_);
										} else {
											_tmp734_ = FALSE;
										}
										if (_tmp734_) {
											ValaGirParserNode* _tmp746_;
											ValaSymbol* _tmp747_;
											gchar* _tmp748_;
											gchar* _tmp749_;
											_tmp746_ = iface;
											_tmp747_ = _tmp746_->symbol;
											_tmp748_ = vala_gir_parser_node_get_cname (self);
											_tmp749_ = _tmp748_;
											vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp747_, "CCode", "type_cname", _tmp749_, NULL);
											_g_free0 (_tmp749_);
										}
										self->merged = TRUE;
										_vala_gir_parser_node_unref0 (iface);
									}
									_g_free0 (gtype_struct_for);
								}
							}
						}
					}
				}
			}
		}
		_tmp750_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp750_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT)) {
			ValaGirParserMetadata* _tmp751_;
			gchar* _tmp752_;
			self->deprecated = TRUE;
			_tmp751_ = self->metadata;
			_tmp752_ = vala_gir_parser_metadata_get_string (_tmp751_, VALA_GIR_PARSER_ARGUMENT_TYPE_REPLACEMENT);
			_g_free0 (self->deprecated_replacement);
			self->deprecated_replacement = _tmp752_;
		}
		_tmp753_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp753_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE)) {
			ValaGirParserMetadata* _tmp754_;
			gchar* _tmp755_;
			self->deprecated = TRUE;
			_tmp754_ = self->metadata;
			_tmp755_ = vala_gir_parser_metadata_get_string (_tmp754_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED_SINCE);
			_g_free0 (self->deprecated_since);
			self->deprecated_since = _tmp755_;
		} else {
			ValaMap* _tmp756_;
			gpointer _tmp757_;
			gchar* _tmp758_;
			gboolean _tmp759_;
			_tmp756_ = self->girdata;
			_tmp757_ = vala_map_get (_tmp756_, "deprecated-version");
			_tmp758_ = (gchar*) _tmp757_;
			_tmp759_ = _tmp758_ != NULL;
			_g_free0 (_tmp758_);
			if (_tmp759_) {
				ValaMap* _tmp760_;
				gpointer _tmp761_;
				self->deprecated = TRUE;
				_tmp760_ = self->girdata;
				_tmp761_ = vala_map_get (_tmp760_, "deprecated-version");
				_g_free0 (self->deprecated_since);
				self->deprecated_since = (gchar*) _tmp761_;
			}
		}
		_tmp762_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp762_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED)) {
			ValaGirParserMetadata* _tmp763_;
			gboolean _tmp764_;
			_tmp763_ = self->metadata;
			self->deprecated = vala_gir_parser_metadata_get_bool (_tmp763_, VALA_GIR_PARSER_ARGUMENT_TYPE_DEPRECATED, TRUE);
			_tmp764_ = self->deprecated;
			if (!_tmp764_) {
				_g_free0 (self->deprecated_since);
				self->deprecated_since = NULL;
				_g_free0 (self->deprecated_replacement);
				self->deprecated_replacement = NULL;
			}
		} else {
			ValaMap* _tmp765_;
			gpointer _tmp766_;
			gchar* _tmp767_;
			gboolean _tmp768_;
			_tmp765_ = self->girdata;
			_tmp766_ = vala_map_get (_tmp765_, "deprecated");
			_tmp767_ = (gchar*) _tmp766_;
			_tmp768_ = _tmp767_ != NULL;
			_g_free0 (_tmp767_);
			if (_tmp768_) {
				self->deprecated = TRUE;
			}
		}
		_tmp769_ = self->deprecated_since;
		if (_tmp769_ != NULL) {
			const gchar* _tmp770_;
			_tmp770_ = self->deprecated_since;
			self->deprecated_version = vala_gir_parser_node_parse_version_string (_tmp770_);
		}
		_tmp771_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp771_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL)) {
			ValaSymbol* _tmp772_;
			ValaGirParserMetadata* _tmp773_;
			_tmp772_ = self->symbol;
			_tmp773_ = self->metadata;
			vala_code_node_set_attribute_bool ((ValaCodeNode*) _tmp772_, "Version", "experimental", vala_gir_parser_metadata_get_bool (_tmp773_, VALA_GIR_PARSER_ARGUMENT_TYPE_EXPERIMENTAL, FALSE), NULL);
		}
		_tmp774_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp774_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE)) {
			ValaSymbol* _tmp775_;
			ValaVersionAttribute* _tmp776_;
			ValaVersionAttribute* _tmp777_;
			ValaGirParserMetadata* _tmp778_;
			gchar* _tmp779_;
			gchar* _tmp780_;
			_tmp775_ = self->symbol;
			_tmp776_ = vala_symbol_get_version (_tmp775_);
			_tmp777_ = _tmp776_;
			_tmp778_ = self->metadata;
			_tmp779_ = vala_gir_parser_metadata_get_string (_tmp778_, VALA_GIR_PARSER_ARGUMENT_TYPE_SINCE);
			_tmp780_ = _tmp779_;
			vala_version_attribute_set_since (_tmp777_, _tmp780_);
			_g_free0 (_tmp780_);
		} else {
			gboolean _tmp781_ = FALSE;
			ValaSymbol* _tmp782_;
			_tmp782_ = self->symbol;
			if (VALA_IS_NAMESPACE (_tmp782_) == FALSE) {
				ValaMap* _tmp783_;
				gpointer _tmp784_;
				gchar* _tmp785_;
				_tmp783_ = self->girdata;
				_tmp784_ = vala_map_get (_tmp783_, "version");
				_tmp785_ = (gchar*) _tmp784_;
				_tmp781_ = _tmp785_ != NULL;
				_g_free0 (_tmp785_);
			} else {
				_tmp781_ = FALSE;
			}
			if (_tmp781_) {
				ValaSymbol* _tmp786_;
				ValaVersionAttribute* _tmp787_;
				ValaVersionAttribute* _tmp788_;
				ValaMap* _tmp789_;
				gpointer _tmp790_;
				gchar* _tmp791_;
				_tmp786_ = self->symbol;
				_tmp787_ = vala_symbol_get_version (_tmp786_);
				_tmp788_ = _tmp787_;
				_tmp789_ = self->girdata;
				_tmp790_ = vala_map_get (_tmp789_, "version");
				_tmp791_ = (gchar*) _tmp790_;
				vala_version_attribute_set_since (_tmp788_, _tmp791_);
				_g_free0 (_tmp791_);
			}
		}
		_tmp792_ = self->parent;
		_tmp793_ = _tmp792_->symbol;
		if (VALA_IS_NAMESPACE (_tmp793_)) {
			ValaSymbol* _tmp794_;
			gchar* _tmp795_;
			gchar* _tmp796_;
			_tmp794_ = self->symbol;
			_tmp795_ = vala_gir_parser_node_get_cheader_filename (self);
			_tmp796_ = _tmp795_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp794_, "CCode", "cheader_filename", _tmp796_, NULL);
			_g_free0 (_tmp796_);
		} else {
			ValaGirParserMetadata* _tmp797_;
			_tmp797_ = self->metadata;
			if (vala_gir_parser_metadata_has_argument (_tmp797_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME)) {
				ValaSymbol* _tmp798_;
				ValaGirParserMetadata* _tmp799_;
				gchar* _tmp800_;
				gchar* _tmp801_;
				_tmp798_ = self->symbol;
				_tmp799_ = self->metadata;
				_tmp800_ = vala_gir_parser_metadata_get_string (_tmp799_, VALA_GIR_PARSER_ARGUMENT_TYPE_CHEADER_FILENAME);
				_tmp801_ = _tmp800_;
				vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp798_, "CCode", "cheader_filename", _tmp801_, NULL);
				_g_free0 (_tmp801_);
			}
		}
		_tmp802_ = vala_gir_parser_node_get_cname (self);
		_tmp803_ = _tmp802_;
		_tmp804_ = vala_gir_parser_node_get_default_cname (self);
		_tmp805_ = _tmp804_;
		_tmp806_ = g_strcmp0 (_tmp803_, _tmp805_) != 0;
		_g_free0 (_tmp805_);
		_g_free0 (_tmp803_);
		if (_tmp806_) {
			ValaSymbol* _tmp807_;
			gchar* _tmp808_;
			gchar* _tmp809_;
			_tmp807_ = self->symbol;
			_tmp808_ = vala_gir_parser_node_get_cname (self);
			_tmp809_ = _tmp808_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp807_, "CCode", "cname", _tmp809_, NULL);
			_g_free0 (_tmp809_);
		}
		_tmp810_ = self->metadata;
		if (vala_gir_parser_metadata_has_argument (_tmp810_, VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO)) {
			ValaSymbol* _tmp811_;
			ValaGirParserMetadata* _tmp812_;
			gchar* _tmp813_;
			gchar* _tmp814_;
			_tmp811_ = self->symbol;
			_tmp812_ = self->metadata;
			_tmp813_ = vala_gir_parser_metadata_get_string (_tmp812_, VALA_GIR_PARSER_ARGUMENT_TYPE_FEATURE_TEST_MACRO);
			_tmp814_ = _tmp813_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp811_, "CCode", "feature_test_macro", _tmp814_, NULL);
			_g_free0 (_tmp814_);
		}
		_tmp815_ = vala_gir_parser_node_get_lower_case_cprefix (self);
		_tmp816_ = _tmp815_;
		_tmp817_ = vala_gir_parser_node_get_default_lower_case_cprefix (self);
		_tmp818_ = _tmp817_;
		_tmp819_ = g_strcmp0 (_tmp816_, _tmp818_) != 0;
		_g_free0 (_tmp818_);
		_g_free0 (_tmp816_);
		if (_tmp819_) {
			ValaSymbol* _tmp820_;
			gchar* _tmp821_;
			gchar* _tmp822_;
			_tmp820_ = self->symbol;
			_tmp821_ = vala_gir_parser_node_get_lower_case_cprefix (self);
			_tmp822_ = _tmp821_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp820_, "CCode", "lower_case_cprefix", _tmp822_, NULL);
			_g_free0 (_tmp822_);
		}
		_tmp823_ = vala_gir_parser_node_get_lower_case_csuffix (self);
		_tmp824_ = _tmp823_;
		_tmp825_ = vala_gir_parser_node_get_default_lower_case_csuffix (self);
		_tmp826_ = _tmp825_;
		_tmp827_ = g_strcmp0 (_tmp824_, _tmp826_) != 0;
		_g_free0 (_tmp826_);
		_g_free0 (_tmp824_);
		if (_tmp827_) {
			ValaSymbol* _tmp828_;
			gchar* _tmp829_;
			gchar* _tmp830_;
			_tmp828_ = self->symbol;
			_tmp829_ = vala_gir_parser_node_get_lower_case_csuffix (self);
			_tmp830_ = _tmp829_;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp828_, "CCode", "lower_case_csuffix", _tmp830_, NULL);
			_g_free0 (_tmp830_);
		}
		_tmp831_ = vala_gir_parser_node_get_gir_name (self);
		gir_name = _tmp831_;
		_tmp832_ = vala_gir_parser_node_get_default_gir_name (self);
		default_gir_name = _tmp832_;
		_tmp835_ = self->symbol;
		if (vala_gir_parser_is_container (_tmp835_)) {
			ValaSymbol* _tmp836_;
			_tmp836_ = self->symbol;
			_tmp834_ = !VALA_IS_NAMESPACE (_tmp836_);
		} else {
			_tmp834_ = FALSE;
		}
		if (_tmp834_) {
			gboolean _tmp837_ = FALSE;
			const gchar* _tmp838_;
			const gchar* _tmp839_;
			_tmp838_ = self->name;
			_tmp839_ = gir_name;
			if (g_strcmp0 (_tmp838_, _tmp839_) != 0) {
				_tmp837_ = TRUE;
			} else {
				const gchar* _tmp840_;
				const gchar* _tmp841_;
				_tmp840_ = gir_name;
				_tmp841_ = default_gir_name;
				_tmp837_ = g_strcmp0 (_tmp840_, _tmp841_) != 0;
			}
			_tmp833_ = _tmp837_;
		} else {
			_tmp833_ = FALSE;
		}
		if (_tmp833_) {
			ValaSymbol* _tmp842_;
			const gchar* _tmp843_;
			_tmp842_ = self->symbol;
			_tmp843_ = gir_name;
			vala_code_node_set_attribute_string ((ValaCodeNode*) _tmp842_, "GIR", "name", _tmp843_, NULL);
		}
		_g_free0 (default_gir_name);
		_g_free0 (gir_name);
	}
	_tmp846_ = self->new_symbol;
	if (_tmp846_) {
		gboolean _tmp847_;
		_tmp847_ = self->merged;
		_tmp845_ = _tmp847_;
	} else {
		_tmp845_ = FALSE;
	}
	if (!_tmp845_) {
		ValaSymbol* _tmp848_;
		_tmp848_ = self->symbol;
		_tmp844_ = vala_gir_parser_is_container (_tmp848_);
	} else {
		_tmp844_ = FALSE;
	}
	if (_tmp844_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp901_;
		ValaClass* _tmp902_;
		gboolean _tmp903_ = FALSE;
		gboolean _tmp904_ = FALSE;
		ValaClass* _tmp905_;
		{
			ValaArrayList* _node_list = NULL;
			ValaArrayList* _tmp849_;
			ValaArrayList* _tmp850_;
			gint _node_size = 0;
			ValaArrayList* _tmp851_;
			gint _tmp852_;
			gint _tmp853_;
			gint _node_index = 0;
			_tmp849_ = self->members;
			_tmp850_ = _vala_iterable_ref0 (_tmp849_);
			_node_list = _tmp850_;
			_tmp851_ = _node_list;
			_tmp852_ = vala_collection_get_size ((ValaCollection*) _tmp851_);
			_tmp853_ = _tmp852_;
			_node_size = _tmp853_;
			_node_index = -1;
			while (TRUE) {
				gint _tmp854_;
				gint _tmp855_;
				ValaGirParserNode* node = NULL;
				ValaArrayList* _tmp856_;
				gint _tmp857_;
				gpointer _tmp858_;
				gboolean _tmp859_ = FALSE;
				guint64 _tmp860_;
				ValaGirParserNode* _tmp869_;
				gboolean _tmp870_;
				ValaGirParserNode* _tmp875_;
				const gchar* _tmp876_;
				ValaGirParserNode* _tmp883_;
				const gchar* _tmp884_;
				gboolean _tmp891_ = FALSE;
				gboolean _tmp892_ = FALSE;
				ValaGirParserNode* _tmp893_;
				gboolean _tmp894_;
				_node_index = _node_index + 1;
				_tmp854_ = _node_index;
				_tmp855_ = _node_size;
				if (!(_tmp854_ < _tmp855_)) {
					break;
				}
				_tmp856_ = _node_list;
				_tmp857_ = _node_index;
				_tmp858_ = vala_list_get ((ValaList*) _tmp856_, _tmp857_);
				node = (ValaGirParserNode*) _tmp858_;
				_tmp860_ = self->deprecated_version;
				if (_tmp860_ > ((guint64) 0)) {
					ValaGirParserNode* _tmp861_;
					guint64 _tmp862_;
					_tmp861_ = node;
					_tmp862_ = _tmp861_->deprecated_version;
					_tmp859_ = _tmp862_ > ((guint64) 0);
				} else {
					_tmp859_ = FALSE;
				}
				if (_tmp859_) {
					guint64 _tmp863_;
					ValaGirParserNode* _tmp864_;
					guint64 _tmp865_;
					_tmp863_ = self->deprecated_version;
					_tmp864_ = node;
					_tmp865_ = _tmp864_->deprecated_version;
					if (_tmp863_ <= _tmp865_) {
						ValaGirParserNode* _tmp866_;
						ValaGirParserNode* _tmp867_;
						ValaGirParserNode* _tmp868_;
						_tmp866_ = node;
						_tmp866_->deprecated = FALSE;
						_tmp867_ = node;
						_g_free0 (_tmp867_->deprecated_since);
						_tmp867_->deprecated_since = NULL;
						_tmp868_ = node;
						_g_free0 (_tmp868_->deprecated_replacement);
						_tmp868_->deprecated_replacement = NULL;
					}
				}
				_tmp869_ = node;
				_tmp870_ = _tmp869_->deprecated;
				if (_tmp870_) {
					ValaGirParserNode* _tmp871_;
					ValaSymbol* _tmp872_;
					ValaVersionAttribute* _tmp873_;
					ValaVersionAttribute* _tmp874_;
					_tmp871_ = node;
					_tmp872_ = _tmp871_->symbol;
					_tmp873_ = vala_symbol_get_version (_tmp872_);
					_tmp874_ = _tmp873_;
					vala_version_attribute_set_deprecated (_tmp874_, TRUE);
				}
				_tmp875_ = node;
				_tmp876_ = _tmp875_->deprecated_since;
				if (_tmp876_ != NULL) {
					ValaGirParserNode* _tmp877_;
					ValaSymbol* _tmp878_;
					ValaVersionAttribute* _tmp879_;
					ValaVersionAttribute* _tmp880_;
					ValaGirParserNode* _tmp881_;
					const gchar* _tmp882_;
					_tmp877_ = node;
					_tmp878_ = _tmp877_->symbol;
					_tmp879_ = vala_symbol_get_version (_tmp878_);
					_tmp880_ = _tmp879_;
					_tmp881_ = node;
					_tmp882_ = _tmp881_->deprecated_since;
					vala_version_attribute_set_deprecated_since (_tmp880_, _tmp882_);
				}
				_tmp883_ = node;
				_tmp884_ = _tmp883_->deprecated_replacement;
				if (_tmp884_ != NULL) {
					ValaGirParserNode* _tmp885_;
					ValaSymbol* _tmp886_;
					ValaVersionAttribute* _tmp887_;
					ValaVersionAttribute* _tmp888_;
					ValaGirParserNode* _tmp889_;
					const gchar* _tmp890_;
					_tmp885_ = node;
					_tmp886_ = _tmp885_->symbol;
					_tmp887_ = vala_symbol_get_version (_tmp886_);
					_tmp888_ = _tmp887_;
					_tmp889_ = node;
					_tmp890_ = _tmp889_->deprecated_replacement;
					vala_version_attribute_set_replacement (_tmp888_, _tmp890_);
				}
				_tmp893_ = node;
				_tmp894_ = _tmp893_->new_symbol;
				if (_tmp894_) {
					ValaGirParserNode* _tmp895_;
					gboolean _tmp896_;
					_tmp895_ = node;
					_tmp896_ = _tmp895_->merged;
					_tmp892_ = !_tmp896_;
				} else {
					_tmp892_ = FALSE;
				}
				if (_tmp892_) {
					ValaGirParserMetadata* _tmp897_;
					_tmp897_ = self->metadata;
					_tmp891_ = !vala_gir_parser_metadata_get_bool (_tmp897_, VALA_GIR_PARSER_ARGUMENT_TYPE_HIDDEN, FALSE);
				} else {
					_tmp891_ = FALSE;
				}
				if (_tmp891_) {
					ValaSymbol* _tmp898_;
					ValaGirParserNode* _tmp899_;
					ValaSymbol* _tmp900_;
					_tmp898_ = self->symbol;
					_tmp899_ = node;
					_tmp900_ = _tmp899_->symbol;
					vala_gir_parser_add_symbol_to_container (_tmp898_, _tmp900_);
				}
				_vala_gir_parser_node_unref0 (node);
			}
			_vala_iterable_unref0 (_node_list);
		}
		_tmp901_ = self->symbol;
		_tmp902_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp901_) ? ((ValaClass*) _tmp901_) : NULL);
		cl = _tmp902_;
		_tmp905_ = cl;
		if (_tmp905_ != NULL) {
			ValaClass* _tmp906_;
			gboolean _tmp907_;
			gboolean _tmp908_;
			_tmp906_ = cl;
			_tmp907_ = vala_class_get_is_compact (_tmp906_);
			_tmp908_ = _tmp907_;
			_tmp904_ = !_tmp908_;
		} else {
			_tmp904_ = FALSE;
		}
		if (_tmp904_) {
			ValaClass* _tmp909_;
			ValaCreationMethod* _tmp910_;
			ValaCreationMethod* _tmp911_;
			_tmp909_ = cl;
			_tmp910_ = vala_class_get_default_construction_method (_tmp909_);
			_tmp911_ = _tmp910_;
			_tmp903_ = _tmp911_ == NULL;
		} else {
			_tmp903_ = FALSE;
		}
		if (_tmp903_) {
			ValaCreationMethod* cm = NULL;
			ValaClass* _tmp912_;
			ValaSourceReference* _tmp913_;
			ValaSourceReference* _tmp914_;
			ValaCreationMethod* _tmp915_;
			ValaCreationMethod* _tmp916_;
			ValaCreationMethod* _tmp917_;
			ValaClass* _tmp918_;
			ValaCreationMethod* _tmp919_;
			_tmp912_ = cl;
			_tmp913_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp912_);
			_tmp914_ = _tmp913_;
			_tmp915_ = vala_creation_method_new (NULL, NULL, _tmp914_, NULL);
			cm = _tmp915_;
			_tmp916_ = cm;
			vala_method_set_has_construct_function ((ValaMethod*) _tmp916_, FALSE);
			_tmp917_ = cm;
			vala_symbol_set_access ((ValaSymbol*) _tmp917_, VALA_SYMBOL_ACCESSIBILITY_PROTECTED);
			_tmp918_ = cl;
			_tmp919_ = cm;
			vala_symbol_add_method ((ValaSymbol*) _tmp918_, (ValaMethod*) _tmp919_);
			_vala_code_node_unref0 (cm);
		}
		_vala_code_node_unref0 (cl);
	}
	self->processed = TRUE;
}


static gchar*
vala_gir_parser_node_to_string (ValaGirParserNode* self)
{
	gchar* result = NULL;
	ValaGirParserNode* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->parent;
	_tmp1_ = _tmp0_->name;
	if (_tmp1_ == NULL) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->name;
		_tmp3_ = g_strdup (_tmp2_);
		result = _tmp3_;
		return result;
	} else {
		ValaGirParserNode* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->parent;
		_tmp5_ = vala_gir_parser_node_to_string (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->name;
		_tmp8_ = g_strdup_printf ("%s.%s", _tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp6_);
		result = _tmp9_;
		return result;
	}
}


static void
vala_gir_parser_value_node_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_node_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_node_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_node_copy_value (const GValue* src_value,
                                       GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_node_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_node_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_node_collect_value (GValue* value,
                                          guint n_collect_values,
                                          GTypeCValue* collect_values,
                                          guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserNode * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_node_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_node_lcopy_value (const GValue* value,
                                        guint n_collect_values,
                                        GTypeCValue* collect_values,
                                        guint collect_flags)
{
	ValaGirParserNode ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_node_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_node (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags)
{
	ValaGirParserParamSpecNode* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_NODE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_node (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_node (GValue* value,
                                gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_node_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}


static void
vala_gir_parser_value_take_node (GValue* value,
                                 gpointer v_object)
{
	ValaGirParserNode * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_NODE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_NODE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_node_unref (old);
	}
}


static void
vala_gir_parser_node_class_init (ValaGirParserNodeClass * klass)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	vala_gir_parser_node_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserNodeClass *) klass)->finalize = vala_gir_parser_node_finalize;
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp0_);
	vala_gir_parser_node_new_namespaces = _tmp1_;
}


static void
vala_gir_parser_node_instance_init (ValaGirParserNode * self)
{
	ValaGirParserMetadata* _tmp0_;
	ValaGirParserMetadata* _tmp1_;
	ValaGirParserMetadata* _tmp2_;
	GEqualFunc _tmp3_;
	ValaArrayList* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GEqualFunc _tmp7_;
	ValaHashMap* _tmp8_;
	self->girdata = NULL;
	_tmp0_ = vala_gir_parser_metadata_get_empty ();
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_gir_parser_metadata_ref0 (_tmp1_);
	self->metadata = _tmp2_;
	self->source_reference = NULL;
	_tmp3_ = g_direct_equal;
	_tmp4_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp3_);
	self->members = _tmp4_;
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, VALA_TYPE_ARRAY_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp5_, _tmp6_, _tmp7_);
	self->scope = _tmp8_;
	self->return_array_length_idx = -1;
	self->array_length_idx = -1;
	self->deprecated = FALSE;
	self->deprecated_version = (guint64) 0;
	self->deprecated_since = NULL;
	self->deprecated_replacement = NULL;
	self->ref_count = 1;
}


static void
vala_gir_parser_node_finalize (ValaGirParserNode * obj)
{
	ValaGirParserNode * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_NODE, ValaGirParserNode);
	g_signal_handlers_destroy (self);
	_g_free0 (self->element_type);
	_g_free0 (self->name);
	_vala_map_unref0 (self->girdata);
	_vala_gir_parser_metadata_unref0 (self->metadata);
	_vala_source_reference_unref0 (self->source_reference);
	_vala_iterable_unref0 (self->members);
	_vala_map_unref0 (self->scope);
	_vala_comment_unref0 (self->comment);
	_vala_code_node_unref0 (self->symbol);
	_vala_iterable_unref0 (self->parameters);
	_vala_iterable_unref0 (self->array_length_parameters);
	_vala_iterable_unref0 (self->closure_parameters);
	_vala_iterable_unref0 (self->destroy_parameters);
	_vala_code_node_unref0 (self->gtype_struct_for);
	_vala_code_node_unref0 (self->base_type);
	_g_free0 (self->deprecated_since);
	_g_free0 (self->deprecated_replacement);
}


static GType
vala_gir_parser_node_get_type (void)
{
	static volatile gsize vala_gir_parser_node_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_node_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_node_init, vala_gir_parser_value_node_free_value, vala_gir_parser_value_node_copy_value, vala_gir_parser_value_node_peek_pointer, "p", vala_gir_parser_value_node_collect_value, "p", vala_gir_parser_value_node_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserNodeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_node_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserNode), 0, (GInstanceInitFunc) vala_gir_parser_node_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_node_type_id;
		vala_gir_parser_node_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserNode", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_node_type_id__volatile, vala_gir_parser_node_type_id);
	}
	return vala_gir_parser_node_type_id__volatile;
}


static gpointer
vala_gir_parser_node_ref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_node_unref (gpointer instance)
{
	ValaGirParserNode * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_NODE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_construct (GType object_type,
                                          ValaParameter* param,
                                          gint array_length_idx,
                                          gint closure_idx,
                                          gint destroy_idx,
                                          gboolean is_async)
{
	ValaGirParserParameterInfo* self = NULL;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (ValaGirParserParameterInfo*) g_type_create_instance (object_type);
	_tmp0_ = _vala_code_node_ref0 (param);
	_vala_code_node_unref0 (self->param);
	self->param = _tmp0_;
	self->array_length_idx = array_length_idx;
	self->closure_idx = closure_idx;
	self->destroy_idx = destroy_idx;
	self->vala_idx = 0.0F;
	self->keep = TRUE;
	self->is_async = is_async;
	return self;
}


static ValaGirParserParameterInfo*
vala_gir_parser_parameter_info_new (ValaParameter* param,
                                    gint array_length_idx,
                                    gint closure_idx,
                                    gint destroy_idx,
                                    gboolean is_async)
{
	return vala_gir_parser_parameter_info_construct (VALA_GIR_PARSER_TYPE_PARAMETER_INFO, param, array_length_idx, closure_idx, destroy_idx, is_async);
}


static void
vala_gir_parser_value_parameter_info_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_gir_parser_value_parameter_info_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_gir_parser_parameter_info_unref (value->data[0].v_pointer);
	}
}


static void
vala_gir_parser_value_parameter_info_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_gir_parser_value_parameter_info_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_gir_parser_value_parameter_info_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaGirParserParameterInfo * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_gir_parser_parameter_info_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_gir_parser_value_parameter_info_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaGirParserParameterInfo ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_gir_parser_param_spec_parameter_info (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaGirParserParamSpecParameterInfo* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_gir_parser_value_get_parameter_info (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO), NULL);
	return value->data[0].v_pointer;
}


static void
vala_gir_parser_value_set_parameter_info (GValue* value,
                                          gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_gir_parser_parameter_info_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}


static void
vala_gir_parser_value_take_parameter_info (GValue* value,
                                           gpointer v_object)
{
	ValaGirParserParameterInfo * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_GIR_PARSER_TYPE_PARAMETER_INFO));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_gir_parser_parameter_info_unref (old);
	}
}


static void
vala_gir_parser_parameter_info_class_init (ValaGirParserParameterInfoClass * klass)
{
	vala_gir_parser_parameter_info_parent_class = g_type_class_peek_parent (klass);
	((ValaGirParserParameterInfoClass *) klass)->finalize = vala_gir_parser_parameter_info_finalize;
}


static void
vala_gir_parser_parameter_info_instance_init (ValaGirParserParameterInfo * self)
{
	self->ref_count = 1;
}


static void
vala_gir_parser_parameter_info_finalize (ValaGirParserParameterInfo * obj)
{
	ValaGirParserParameterInfo * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_GIR_PARSER_TYPE_PARAMETER_INFO, ValaGirParserParameterInfo);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->param);
}


static GType
vala_gir_parser_parameter_info_get_type (void)
{
	static volatile gsize vala_gir_parser_parameter_info_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_parameter_info_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_gir_parser_value_parameter_info_init, vala_gir_parser_value_parameter_info_free_value, vala_gir_parser_value_parameter_info_copy_value, vala_gir_parser_value_parameter_info_peek_pointer, "p", vala_gir_parser_value_parameter_info_collect_value, "p", vala_gir_parser_value_parameter_info_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserParameterInfoClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_parameter_info_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParserParameterInfo), 0, (GInstanceInitFunc) vala_gir_parser_parameter_info_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_gir_parser_parameter_info_type_id;
		vala_gir_parser_parameter_info_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaGirParserParameterInfo", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_gir_parser_parameter_info_type_id__volatile, vala_gir_parser_parameter_info_type_id);
	}
	return vala_gir_parser_parameter_info_type_id__volatile;
}


static gpointer
vala_gir_parser_parameter_info_ref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_gir_parser_parameter_info_unref (gpointer instance)
{
	ValaGirParserParameterInfo * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_GIR_PARSER_PARAMETER_INFO_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
vala_gir_parser_class_init (ValaGirParserClass * klass)
{
	vala_gir_parser_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gir_parser_finalize;
	g_type_class_add_private (klass, sizeof (ValaGirParserPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_gir_parser_real_visit_source_file;
}


static void
vala_gir_parser_instance_init (ValaGirParser * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GHashFunc _tmp2_;
	GEqualFunc _tmp3_;
	ValaHashSet* _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	GEqualFunc _tmp7_;
	ValaArrayList* _tmp8_;
	GHashFunc _tmp9_;
	GEqualFunc _tmp10_;
	GEqualFunc _tmp11_;
	ValaHashMap* _tmp12_;
	GEqualFunc _tmp13_;
	ValaArrayList* _tmp14_;
	self->priv = VALA_GIR_PARSER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_GIR_PARSER_TYPE_METADATA, (GBoxedCopyFunc) vala_gir_parser_metadata_ref, (GDestroyNotify) vala_gir_parser_metadata_unref, _tmp0_);
	self->priv->metadata_roots = _tmp1_;
	_tmp2_ = g_str_hash;
	_tmp3_ = g_str_equal;
	_tmp4_ = vala_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp2_, _tmp3_);
	self->priv->provided_namespaces = (ValaSet*) _tmp4_;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _vala_gir_parser_unresolved_symbol_hash_ghash_func, _vala_gir_parser_unresolved_symbol_equal_gequal_func, _tmp5_);
	self->priv->unresolved_symbols_map = _tmp6_;
	_tmp7_ = g_direct_equal;
	_tmp8_ = vala_array_list_new (VALA_TYPE_UNRESOLVED_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp7_);
	self->priv->unresolved_gir_symbols = _tmp8_;
	_tmp9_ = g_direct_hash;
	_tmp10_ = g_direct_equal;
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_hash_map_new (VALA_TYPE_UNRESOLVED_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_GIR_PARSER_TYPE_NODE, (GBoxedCopyFunc) vala_gir_parser_node_ref, (GDestroyNotify) vala_gir_parser_node_unref, _tmp9_, _tmp10_, _tmp11_);
	self->priv->unresolved_type_arguments = _tmp12_;
	_tmp13_ = g_direct_equal;
	_tmp14_ = vala_array_list_new (VALA_TYPE_INTERFACE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
	self->priv->ifaces_needing_object_prereq = _tmp14_;
}


static void
vala_gir_parser_finalize (ValaCodeVisitor * obj)
{
	ValaGirParser * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GIR_PARSER, ValaGirParser);
	_vala_markup_reader_unref0 (self->priv->reader);
	_vala_code_context_unref0 (self->priv->context);
	_vala_source_file_unref0 (self->priv->current_source_file);
	_vala_gir_parser_node_unref0 (self->priv->root);
	_vala_iterable_unref0 (self->priv->metadata_roots);
	self->priv->cheader_filenames = (_vala_array_free (self->priv->cheader_filenames, self->priv->cheader_filenames_length1, (GDestroyNotify) g_free), NULL);
	_vala_iterable_unref0 (self->priv->metadata_stack);
	_vala_gir_parser_metadata_unref0 (self->priv->metadata);
	_vala_iterable_unref0 (self->priv->tree_stack);
	_vala_gir_parser_node_unref0 (self->priv->current);
	_vala_gir_parser_node_unref0 (self->priv->old_current);
	_vala_iterable_unref0 (self->priv->provided_namespaces);
	_vala_map_unref0 (self->priv->unresolved_symbols_map);
	_vala_iterable_unref0 (self->priv->unresolved_gir_symbols);
	_vala_map_unref0 (self->priv->unresolved_type_arguments);
	_vala_iterable_unref0 (self->priv->ifaces_needing_object_prereq);
	VALA_CODE_VISITOR_CLASS (vala_gir_parser_parent_class)->finalize (obj);
}


/**
 * Code visitor parsing all GIR source files.
 *
 * Pipeline:
 * 1) Parse metadata
 * 2) Parse GIR with metadata, track unresolved GIR symbols, create Vala symbols
 * 3) Reconciliate the tree by mapping tracked symbols
 * 4) Process the tree
 */
GType
vala_gir_parser_get_type (void)
{
	static volatile gsize vala_gir_parser_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gir_parser_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGirParserClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gir_parser_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGirParser), 0, (GInstanceInitFunc) vala_gir_parser_instance_init, NULL };
		GType vala_gir_parser_type_id;
		vala_gir_parser_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaGirParser", &g_define_type_info, 0);
		g_once_init_leave (&vala_gir_parser_type_id__volatile, vala_gir_parser_type_id);
	}
	return vala_gir_parser_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



