/* valaflowanalyzer.c generated by valac, the Vala compiler
 * generated from valaflowanalyzer.vala, do not modify */

/* valaflowanalyzer.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET (vala_flow_analyzer_jump_target_get_type ())
#define VALA_FLOW_ANALYZER_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_IS_JUMP_TARGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET))
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetClass))

typedef struct _ValaFlowAnalyzerJumpTarget ValaFlowAnalyzerJumpTarget;
typedef struct _ValaFlowAnalyzerJumpTargetClass ValaFlowAnalyzerJumpTargetClass;
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _vala_basic_block_unref0(var) ((var == NULL) ? NULL : (var = (vala_basic_block_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_flow_analyzer_jump_target_unref0(var) ((var == NULL) ? NULL : (var = (vala_flow_analyzer_jump_target_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_phi_function_unref0(var) ((var == NULL) ? NULL : (var = (vala_phi_function_unref (var), NULL)))
typedef struct _ValaFlowAnalyzerJumpTargetPrivate ValaFlowAnalyzerJumpTargetPrivate;
typedef struct _ValaFlowAnalyzerParamSpecJumpTarget ValaFlowAnalyzerParamSpecJumpTarget;

struct _ValaFlowAnalyzerPrivate {
	ValaCodeContext* context;
	ValaBasicBlock* current_block;
	gboolean unreachable_reported;
	ValaList* jump_stack;
	ValaMap* var_map;
	ValaSet* used_vars;
	ValaMap* phi_functions;
};

struct _ValaFlowAnalyzerJumpTarget {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ValaFlowAnalyzerJumpTargetPrivate * priv;
};

struct _ValaFlowAnalyzerJumpTargetClass {
	GTypeClass parent_class;
	void (*finalize) (ValaFlowAnalyzerJumpTarget *self);
};

struct _ValaFlowAnalyzerJumpTargetPrivate {
	gboolean _is_break_target;
	gboolean _is_continue_target;
	gboolean _is_return_target;
	gboolean _is_exit_target;
	gboolean _is_error_target;
	ValaErrorDomain* _error_domain;
	ValaErrorCode* _error_code;
	ValaClass* _error_class;
	gboolean _is_finally_clause;
	ValaBasicBlock* _basic_block;
	ValaBasicBlock* _last_block;
	ValaCatchClause* _catch_clause;
};

struct _ValaFlowAnalyzerParamSpecJumpTarget {
	GParamSpec parent_instance;
};


static gpointer vala_flow_analyzer_parent_class = NULL;
static gpointer vala_flow_analyzer_jump_target_parent_class = NULL;

static gpointer vala_flow_analyzer_jump_target_ref (gpointer instance);
static void vala_flow_analyzer_jump_target_unref (gpointer instance);
static GParamSpec* vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                                       const gchar* nick,
                                                       const gchar* blurb,
                                                       GType object_type,
                                                       GParamFlags flags) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_set_jump_target (GValue* value,
                                               gpointer v_object) G_GNUC_UNUSED;
static void vala_flow_analyzer_value_take_jump_target (GValue* value,
                                                gpointer v_object) G_GNUC_UNUSED;
static gpointer vala_flow_analyzer_value_get_jump_target (const GValue* value) G_GNUC_UNUSED;
static GType vala_flow_analyzer_jump_target_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
#define VALA_FLOW_ANALYZER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzerPrivate))
static void vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                                ValaSourceFile* source_file);
static void vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                          ValaClass* cl);
static void vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                           ValaStruct* st);
static void vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                              ValaInterface* iface);
static void vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                         ValaEnum* en);
static void vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* ed);
static void vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                          ValaField* f);
static void vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                      ValaLambdaExpression* le);
static void vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self);
static void vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                           ValaMethod* m);
static void vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                          ValaSubroutine* m);
static void vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                           ValaSignal* sig);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                                                    ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                                                  ValaBasicBlock* basic_block);
static void vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                      ValaBasicBlock* entry_block);
static ValaList* vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                                   ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                                  ValaList* block_list,
                                                  ValaBasicBlock* entry_block);
static void vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                              ValaList* block_list,
                                              ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block);
static void vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                              ValaBasicBlock* current,
                                              ValaList* list);
static ValaBasicBlock* vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                                              ValaBasicBlock** idoms,
                                              int idoms_length1,
                                              ValaBasicBlock* b1,
                                              ValaBasicBlock* b2);
static ValaMap* vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                                ValaList* block_list,
                                                ValaBasicBlock* entry_block);
static void vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                               ValaBasicBlock* block);
static ValaVariable* vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                                     ValaMap* var_map,
                                                     ValaVariable* var_symbol);
static void vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                                    ValaCreationMethod* m);
static void vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                             ValaProperty* prop);
static void vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                      ValaPropertyAccessor* acc);
static void vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                          ValaBlock* b);
static void vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                          ValaDeclarationStatement* stmt);
static gboolean vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                         ValaCodeNode* node);
static void vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                       ValaCodeNode* node,
                                       gboolean always_fail);
static void vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                                   ValaLocalVariable* local);
static void vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                         ValaExpressionStatement* stmt);
static gboolean vala_flow_analyzer_always_true (ValaFlowAnalyzer* self,
                                         ValaExpression* condition);
static gboolean vala_flow_analyzer_always_false (ValaFlowAnalyzer* self,
                                          ValaExpression* condition);
static void vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                                 ValaIfStatement* stmt);
static void vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                     ValaSwitchStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base,
                                         ValaLoop* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                                                      ValaBasicBlock* basic_block);
static void vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                      ValaForeachStatement* stmt);
static void vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                                    ValaBreakStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self);
static ValaBasicBlock* vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                       ValaContinueStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                     ValaReturnStatement* stmt);
static gboolean vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self);
static gboolean vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorDomain* vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self);
static ValaErrorCode* vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                                    ValaYieldStatement* stmt);
static void vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                                                 ValaBasicBlock* basic_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                                               ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                                                     ValaBasicBlock* basic_block,
                                                                                     ValaBasicBlock* last_block);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                                             ValaCatchClause* catch_clause,
                                                                             ValaErrorDomain* error_domain,
                                                                             ValaErrorCode* error_code,
                                                                             ValaClass* error_class);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                                                   ValaBasicBlock* basic_block,
                                                                                   ValaCatchClause* catch_clause,
                                                                                   ValaErrorDomain* error_domain,
                                                                                   ValaErrorCode* error_code,
                                                                                   ValaClass* error_class);
static ValaCatchClause* vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                                   ValaLockStatement* stmt);
static void vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                     ValaUnlockStatement* stmt);
static void vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                               ValaExpression* expr);
#define VALA_FLOW_ANALYZER_JUMP_TARGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTargetPrivate))
static void vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                            gboolean value);
static void vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                          gboolean value);
static void vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                        gboolean value);
static void vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaCatchClause* value);
static void vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                      ValaErrorDomain* value);
static void vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaErrorCode* value);
static void vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                     ValaClass* value);
static void vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                         gboolean value);
static void vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                                    ValaBasicBlock* value);
static void vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                           gboolean value);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_new (void);
static ValaFlowAnalyzerJumpTarget* vala_flow_analyzer_jump_target_construct (GType object_type);
static ValaClass* vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self);
static void vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj);
static void vala_flow_analyzer_finalize (ValaCodeVisitor * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


ValaFlowAnalyzer*
vala_flow_analyzer_construct (GType object_type)
{
	ValaFlowAnalyzer* self = NULL;
	self = (ValaFlowAnalyzer*) vala_code_visitor_construct (object_type);
	return self;
}


ValaFlowAnalyzer*
vala_flow_analyzer_new (void)
{
	return vala_flow_analyzer_construct (VALA_TYPE_FLOW_ANALYZER);
}


/**
 * Build control flow graph in the specified context.
 *
 * @param context a code context
 */
static gpointer
_vala_code_context_ref0 (gpointer self)
{
	return self ? vala_code_context_ref (self) : NULL;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


void
vala_flow_analyzer_analyze (ValaFlowAnalyzer* self,
                            ValaCodeContext* context)
{
	ValaCodeContext* _tmp0_;
	ValaList* source_files = NULL;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = _vala_code_context_ref0 (context);
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = _tmp0_;
	_tmp1_ = vala_code_context_get_source_files (context);
	source_files = _tmp1_;
	{
		ValaList* _file_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _file_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _file_index = 0;
		_tmp2_ = source_files;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_file_list = _tmp3_;
		_tmp4_ = _file_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_file_size = _tmp6_;
		_file_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaSourceFile* file = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			ValaSourceFile* _tmp12_;
			ValaSourceFileType _tmp13_;
			ValaSourceFileType _tmp14_;
			_file_index = _file_index + 1;
			_tmp7_ = _file_index;
			_tmp8_ = _file_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _file_list;
			_tmp10_ = _file_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			file = (ValaSourceFile*) _tmp11_;
			_tmp12_ = file;
			_tmp13_ = vala_source_file_get_file_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
				ValaSourceFile* _tmp15_;
				_tmp15_ = file;
				vala_source_file_accept (_tmp15_, (ValaCodeVisitor*) self);
			}
			_vala_source_file_unref0 (file);
		}
		_vala_iterable_unref0 (_file_list);
	}
	_vala_code_context_unref0 (self->priv->context);
	self->priv->context = NULL;
	_vala_iterable_unref0 (source_files);
}


static void
vala_flow_analyzer_real_visit_source_file (ValaCodeVisitor* base,
                                           ValaSourceFile* source_file)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (source_file != NULL);
	vala_source_file_accept_children (source_file, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_class (ValaCodeVisitor* base,
                                     ValaClass* cl)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (cl != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) cl, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_struct (ValaCodeVisitor* base,
                                      ValaStruct* st)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (st != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) st, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_interface (ValaCodeVisitor* base,
                                         ValaInterface* iface)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (iface != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) iface, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_enum (ValaCodeVisitor* base,
                                    ValaEnum* en)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (en != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) en, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* ed)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (ed != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) ed, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_field (ValaCodeVisitor* base,
                                     ValaField* f)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (f != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) f)) {
		gboolean _tmp1_;
		gboolean _tmp2_;
		_tmp1_ = vala_symbol_get_used ((ValaSymbol*) f);
		_tmp2_ = _tmp1_;
		_tmp0_ = !_tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp3_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) f)) {
			gboolean _tmp4_ = FALSE;
			ValaCodeContext* _tmp5_;
			const gchar* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = self->priv->context;
			_tmp6_ = vala_code_context_get_internal_header_filename (_tmp5_);
			_tmp7_ = _tmp6_;
			if (_tmp7_ != NULL) {
				_tmp4_ = TRUE;
			} else {
				ValaCodeContext* _tmp8_;
				gboolean _tmp9_;
				gboolean _tmp10_;
				_tmp8_ = self->priv->context;
				_tmp9_ = vala_code_context_get_use_fast_vapi (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp4_ = _tmp10_;
			}
			_tmp3_ = _tmp4_;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
		} else {
			ValaSourceReference* _tmp11_;
			ValaSourceReference* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			gchar* _tmp16_;
			_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) f);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_symbol_get_full_name ((ValaSymbol*) f);
			_tmp14_ = _tmp13_;
			_tmp15_ = g_strdup_printf ("field `%s' never used", _tmp14_);
			_tmp16_ = _tmp15_;
			vala_report_warning (_tmp12_, _tmp16_);
			_g_free0 (_tmp16_);
			_g_free0 (_tmp14_);
		}
	}
}


static gpointer
_vala_basic_block_ref0 (gpointer self)
{
	return self ? vala_basic_block_ref (self) : NULL;
}


static void
vala_flow_analyzer_real_visit_lambda_expression (ValaCodeVisitor* base,
                                                 ValaLambdaExpression* le)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* old_current_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	gboolean old_unreachable_reported = FALSE;
	gboolean _tmp2_;
	ValaList* old_jump_stack = NULL;
	ValaList* _tmp3_;
	ValaList* _tmp4_;
	GEqualFunc _tmp5_;
	ValaArrayList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaList* _tmp8_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (le != NULL);
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	old_current_block = _tmp1_;
	_tmp2_ = self->priv->unreachable_reported;
	old_unreachable_reported = _tmp2_;
	_tmp3_ = self->priv->jump_stack;
	_tmp4_ = _vala_iterable_ref0 (_tmp3_);
	old_jump_stack = _tmp4_;
	vala_flow_analyzer_mark_unreachable (self);
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp5_);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = (ValaList*) _tmp6_;
	vala_code_node_accept_children ((ValaCodeNode*) le, (ValaCodeVisitor*) self);
	_tmp7_ = _vala_basic_block_ref0 (old_current_block);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp7_;
	self->priv->unreachable_reported = old_unreachable_reported;
	_tmp8_ = _vala_iterable_ref0 (old_jump_stack);
	_vala_iterable_unref0 (self->priv->jump_stack);
	self->priv->jump_stack = _tmp8_;
	_vala_iterable_unref0 (old_jump_stack);
	_vala_basic_block_unref0 (old_current_block);
}


static void
vala_flow_analyzer_real_visit_method (ValaCodeVisitor* base,
                                      ValaMethod* m)
{
	ValaFlowAnalyzer * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	if (vala_symbol_is_internal_symbol ((ValaSymbol*) m)) {
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp5_ = vala_symbol_get_used ((ValaSymbol*) m);
		_tmp6_ = _tmp5_;
		_tmp4_ = !_tmp6_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = vala_method_get_entry_point (m);
		_tmp8_ = _tmp7_;
		_tmp3_ = !_tmp8_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		gboolean _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = vala_method_get_overrides (m);
		_tmp10_ = _tmp9_;
		_tmp2_ = !_tmp10_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gboolean _tmp11_ = FALSE;
		ValaMethod* _tmp12_;
		ValaMethod* _tmp13_;
		_tmp12_ = vala_method_get_base_interface_method (m);
		_tmp13_ = _tmp12_;
		if (_tmp13_ == NULL) {
			_tmp11_ = TRUE;
		} else {
			ValaMethod* _tmp14_;
			ValaMethod* _tmp15_;
			_tmp14_ = vala_method_get_base_interface_method (m);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == m;
		}
		_tmp1_ = _tmp11_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = !VALA_IS_CREATION_METHOD (m);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp16_ = FALSE;
		if (!vala_symbol_is_private_symbol ((ValaSymbol*) m)) {
			gboolean _tmp17_ = FALSE;
			ValaCodeContext* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp18_ = self->priv->context;
			_tmp19_ = vala_code_context_get_internal_header_filename (_tmp18_);
			_tmp20_ = _tmp19_;
			if (_tmp20_ != NULL) {
				_tmp17_ = TRUE;
			} else {
				ValaCodeContext* _tmp21_;
				gboolean _tmp22_;
				gboolean _tmp23_;
				_tmp21_ = self->priv->context;
				_tmp22_ = vala_code_context_get_use_fast_vapi (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp17_ = _tmp23_;
			}
			_tmp16_ = _tmp17_;
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
		} else {
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			ValaSymbol* _tmp26_;
			ValaSymbol* _tmp27_;
			_tmp26_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
			_tmp27_ = _tmp26_;
			if (_tmp27_ != NULL) {
				ValaSymbol* _tmp28_;
				ValaSymbol* _tmp29_;
				ValaAttribute* _tmp30_;
				ValaAttribute* _tmp31_;
				_tmp28_ = vala_symbol_get_parent_symbol ((ValaSymbol*) m);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp29_, "DBus");
				_tmp31_ = _tmp30_;
				_tmp25_ = _tmp31_ != NULL;
				_vala_code_node_unref0 (_tmp31_);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				_tmp24_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) m, "DBus", "visible", TRUE);
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
			} else {
				ValaSourceReference* _tmp32_;
				ValaSourceReference* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
				_tmp33_ = _tmp32_;
				_tmp34_ = vala_symbol_get_full_name ((ValaSymbol*) m);
				_tmp35_ = _tmp34_;
				_tmp36_ = g_strdup_printf ("method `%s' never used", _tmp35_);
				_tmp37_ = _tmp36_;
				vala_report_warning (_tmp33_, _tmp37_);
				_g_free0 (_tmp37_);
				_g_free0 (_tmp35_);
			}
		}
	}
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) m);
}


static void
vala_flow_analyzer_real_visit_signal (ValaCodeVisitor* base,
                                      ValaSignal* sig)
{
	ValaFlowAnalyzer * self;
	ValaMethod* _tmp0_;
	ValaMethod* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_signal_get_default_handler (sig);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		ValaMethod* _tmp3_;
		_tmp2_ = vala_signal_get_default_handler (sig);
		_tmp3_ = _tmp2_;
		vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) _tmp3_);
	}
}


static void
vala_flow_analyzer_visit_subroutine (ValaFlowAnalyzer* self,
                                     ValaSubroutine* m)
{
	ValaBlock* _tmp0_;
	ValaBlock* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* _tmp3_;
	ValaBasicBlock* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaBasicBlock* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp36_;
	ValaBasicBlock* _tmp37_;
	ValaBasicBlock* _tmp38_;
	ValaBasicBlock* _tmp39_;
	ValaBasicBlock* _tmp40_;
	ValaList* _tmp41_;
	ValaBasicBlock* _tmp42_;
	ValaBasicBlock* _tmp43_;
	ValaFlowAnalyzerJumpTarget* _tmp44_;
	ValaFlowAnalyzerJumpTarget* _tmp45_;
	ValaList* _tmp46_;
	ValaBasicBlock* _tmp47_;
	ValaBasicBlock* _tmp48_;
	ValaFlowAnalyzerJumpTarget* _tmp49_;
	ValaFlowAnalyzerJumpTarget* _tmp50_;
	ValaList* _tmp51_;
	ValaList* _tmp52_;
	gint _tmp53_;
	gint _tmp54_;
	gpointer _tmp55_;
	ValaFlowAnalyzerJumpTarget* _tmp56_;
	ValaBasicBlock* _tmp57_;
	ValaBasicBlock* _tmp65_;
	ValaBasicBlock* _tmp66_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (m != NULL);
	_tmp0_ = vala_subroutine_get_body (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = vala_basic_block_new_entry ();
	_tmp3_ = _tmp2_;
	vala_subroutine_set_entry_block (m, _tmp3_);
	_vala_basic_block_unref0 (_tmp3_);
	_tmp4_ = vala_basic_block_new ();
	_tmp5_ = _tmp4_;
	vala_subroutine_set_return_block (m, _tmp5_);
	_vala_basic_block_unref0 (_tmp5_);
	_tmp6_ = vala_basic_block_new_exit ();
	_tmp7_ = _tmp6_;
	vala_subroutine_set_exit_block (m, _tmp7_);
	_vala_basic_block_unref0 (_tmp7_);
	_tmp8_ = vala_subroutine_get_return_block (m);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_subroutine_get_exit_block (m);
	_tmp11_ = _tmp10_;
	vala_basic_block_connect (_tmp9_, _tmp11_);
	if (VALA_IS_METHOD (m)) {
		{
			ValaList* _param_list = NULL;
			ValaList* _tmp12_;
			gint _param_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _param_index = 0;
			_tmp12_ = vala_callable_get_parameters ((ValaCallable*) G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_METHOD, ValaMethod));
			_param_list = _tmp12_;
			_tmp13_ = _param_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_param_size = _tmp15_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaParameter* param = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValaParameter* _tmp21_;
				ValaParameterDirection _tmp22_;
				ValaParameterDirection _tmp23_;
				_param_index = _param_index + 1;
				_tmp16_ = _param_index;
				_tmp17_ = _param_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _param_list;
				_tmp19_ = _param_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				param = (ValaParameter*) _tmp20_;
				_tmp21_ = param;
				_tmp22_ = vala_parameter_get_direction (_tmp21_);
				_tmp23_ = _tmp22_;
				if (_tmp23_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaMemberAccess* param_ma = NULL;
					ValaParameter* _tmp24_;
					const gchar* _tmp25_;
					const gchar* _tmp26_;
					ValaParameter* _tmp27_;
					ValaSourceReference* _tmp28_;
					ValaSourceReference* _tmp29_;
					ValaMemberAccess* _tmp30_;
					ValaMemberAccess* _tmp31_;
					ValaParameter* _tmp32_;
					ValaBasicBlock* _tmp33_;
					ValaBasicBlock* _tmp34_;
					ValaMemberAccess* _tmp35_;
					_tmp24_ = param;
					_tmp25_ = vala_symbol_get_name ((ValaSymbol*) _tmp24_);
					_tmp26_ = _tmp25_;
					_tmp27_ = param;
					_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp30_ = vala_member_access_new_simple (_tmp26_, _tmp29_);
					param_ma = _tmp30_;
					_tmp31_ = param_ma;
					_tmp32_ = param;
					vala_expression_set_symbol_reference ((ValaExpression*) _tmp31_, (ValaSymbol*) _tmp32_);
					_tmp33_ = vala_subroutine_get_return_block (m);
					_tmp34_ = _tmp33_;
					_tmp35_ = param_ma;
					vala_basic_block_add_node (_tmp34_, (ValaCodeNode*) _tmp35_);
					_vala_code_node_unref0 (param_ma);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
	}
	_tmp36_ = vala_basic_block_new ();
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp36_;
	_tmp37_ = vala_subroutine_get_entry_block (m);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->current_block;
	vala_basic_block_connect (_tmp38_, _tmp39_);
	_tmp40_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp40_, (ValaCodeNode*) m);
	_tmp41_ = self->priv->jump_stack;
	_tmp42_ = vala_subroutine_get_return_block (m);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_flow_analyzer_jump_target_new_return_target (_tmp43_);
	_tmp45_ = _tmp44_;
	vala_collection_add ((ValaCollection*) _tmp41_, _tmp45_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp45_);
	_tmp46_ = self->priv->jump_stack;
	_tmp47_ = vala_subroutine_get_exit_block (m);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_flow_analyzer_jump_target_new_exit_target (_tmp48_);
	_tmp50_ = _tmp49_;
	vala_collection_add ((ValaCollection*) _tmp46_, _tmp50_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp50_);
	vala_code_node_accept_children ((ValaCodeNode*) m, (ValaCodeVisitor*) self);
	_tmp51_ = self->priv->jump_stack;
	_tmp52_ = self->priv->jump_stack;
	_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_list_remove_at (_tmp51_, _tmp54_ - 1);
	_tmp56_ = (ValaFlowAnalyzerJumpTarget*) _tmp55_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp56_);
	_tmp57_ = self->priv->current_block;
	if (_tmp57_ != NULL) {
		gboolean _tmp58_;
		gboolean _tmp59_;
		ValaBasicBlock* _tmp62_;
		ValaBasicBlock* _tmp63_;
		ValaBasicBlock* _tmp64_;
		_tmp58_ = vala_subroutine_get_has_result (m);
		_tmp59_ = _tmp58_;
		if (_tmp59_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			vala_report_error (_tmp61_, "missing return statement at end of subroutine body");
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
		}
		_tmp62_ = self->priv->current_block;
		_tmp63_ = vala_subroutine_get_return_block (m);
		_tmp64_ = _tmp63_;
		vala_basic_block_connect (_tmp62_, _tmp64_);
	}
	_tmp65_ = vala_subroutine_get_entry_block (m);
	_tmp66_ = _tmp65_;
	vala_flow_analyzer_analyze_body (self, _tmp66_);
}


static void
vala_flow_analyzer_analyze_body (ValaFlowAnalyzer* self,
                                 ValaBasicBlock* entry_block)
{
	ValaList* block_list = NULL;
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_depth_first_list (self, entry_block);
	block_list = _tmp0_;
	vala_flow_analyzer_build_dominator_tree (self, block_list, entry_block);
	vala_flow_analyzer_build_dominator_frontier (self, block_list, entry_block);
	vala_flow_analyzer_insert_phi_functions (self, block_list, entry_block);
	vala_flow_analyzer_check_variables (self, entry_block);
	_vala_iterable_unref0 (block_list);
}


static ValaList*
vala_flow_analyzer_get_depth_first_list (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* entry_block)
{
	ValaList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp0_);
	list = _tmp1_;
	vala_flow_analyzer_depth_first_traverse (self, entry_block, (ValaList*) list);
	result = (ValaList*) list;
	return result;
}


static void
vala_flow_analyzer_depth_first_traverse (ValaFlowAnalyzer* self,
                                         ValaBasicBlock* current,
                                         ValaList* list)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	gint _tmp12_;
	gint _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (current != NULL);
	g_return_if_fail (list != NULL);
	_tmp0_ = vala_basic_block_get_postorder_visited (current);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	vala_basic_block_set_postorder_visited (current, TRUE);
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp2_;
		gint _succ_size = 0;
		ValaList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _succ_index = 0;
		_tmp2_ = vala_basic_block_get_successors (current);
		_succ_list = _tmp2_;
		_tmp3_ = _succ_list;
		_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_succ_size = _tmp5_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaBasicBlock* _tmp11_;
			_succ_index = _succ_index + 1;
			_tmp6_ = _succ_index;
			_tmp7_ = _succ_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _succ_list;
			_tmp9_ = _succ_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			succ = (ValaBasicBlock*) _tmp10_;
			_tmp11_ = succ;
			vala_flow_analyzer_depth_first_traverse (self, _tmp11_, list);
			_vala_basic_block_unref0 (succ);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	_tmp12_ = vala_collection_get_size ((ValaCollection*) list);
	_tmp13_ = _tmp12_;
	vala_basic_block_set_postorder_number (current, _tmp13_);
	vala_list_insert (list, 0, current);
}


static void
vala_flow_analyzer_build_dominator_tree (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaBasicBlock** idoms = NULL;
	gint _tmp0_;
	gint _tmp1_;
	ValaBasicBlock** _tmp2_;
	gint idoms_length1;
	gint _idoms_size_;
	ValaBasicBlock** _tmp3_;
	gint _tmp3__length1;
	gint _tmp4_;
	gint _tmp5_;
	ValaBasicBlock* _tmp6_;
	gboolean changed = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (ValaBasicBlock*, _tmp1_ + 1);
	idoms = _tmp2_;
	idoms_length1 = _tmp1_;
	_idoms_size_ = idoms_length1;
	_tmp3_ = idoms;
	_tmp3__length1 = idoms_length1;
	_tmp4_ = vala_basic_block_get_postorder_number (entry_block);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_basic_block_ref0 (entry_block);
	_vala_basic_block_unref0 (_tmp3_[_tmp5_]);
	_tmp3_[_tmp5_] = _tmp6_;
	changed = TRUE;
	while (TRUE) {
		gboolean _tmp7_;
		_tmp7_ = changed;
		if (!_tmp7_) {
			break;
		}
		changed = FALSE;
		{
			ValaList* _block_list = NULL;
			ValaList* _tmp8_;
			gint _block_size = 0;
			ValaList* _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _block_index = 0;
			_tmp8_ = _vala_iterable_ref0 (block_list);
			_block_list = _tmp8_;
			_tmp9_ = _block_list;
			_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
			_tmp11_ = _tmp10_;
			_block_size = _tmp11_;
			_block_index = -1;
			while (TRUE) {
				gint _tmp12_;
				gint _tmp13_;
				ValaBasicBlock* block = NULL;
				ValaList* _tmp14_;
				gint _tmp15_;
				gpointer _tmp16_;
				ValaBasicBlock* _tmp17_;
				ValaBasicBlock* new_idom = NULL;
				gboolean first = FALSE;
				ValaBasicBlock** _tmp41_;
				gint _tmp41__length1;
				ValaBasicBlock* _tmp42_;
				gint _tmp43_;
				gint _tmp44_;
				ValaBasicBlock* _tmp45_;
				ValaBasicBlock* _tmp46_;
				_block_index = _block_index + 1;
				_tmp12_ = _block_index;
				_tmp13_ = _block_size;
				if (!(_tmp12_ < _tmp13_)) {
					break;
				}
				_tmp14_ = _block_list;
				_tmp15_ = _block_index;
				_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
				block = (ValaBasicBlock*) _tmp16_;
				_tmp17_ = block;
				if (_tmp17_ == entry_block) {
					_vala_basic_block_unref0 (block);
					continue;
				}
				new_idom = NULL;
				first = TRUE;
				{
					ValaList* _pred_list = NULL;
					ValaBasicBlock* _tmp18_;
					ValaList* _tmp19_;
					gint _pred_size = 0;
					ValaList* _tmp20_;
					gint _tmp21_;
					gint _tmp22_;
					gint _pred_index = 0;
					_tmp18_ = block;
					_tmp19_ = vala_basic_block_get_predecessors (_tmp18_);
					_pred_list = _tmp19_;
					_tmp20_ = _pred_list;
					_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
					_tmp22_ = _tmp21_;
					_pred_size = _tmp22_;
					_pred_index = -1;
					while (TRUE) {
						gint _tmp23_;
						gint _tmp24_;
						ValaBasicBlock* pred = NULL;
						ValaList* _tmp25_;
						gint _tmp26_;
						gpointer _tmp27_;
						ValaBasicBlock* _tmp28_;
						ValaBasicBlock** _tmp29_;
						gint _tmp29__length1;
						ValaBasicBlock* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						ValaBasicBlock* _tmp33_;
						_pred_index = _pred_index + 1;
						_tmp23_ = _pred_index;
						_tmp24_ = _pred_size;
						if (!(_tmp23_ < _tmp24_)) {
							break;
						}
						_tmp25_ = _pred_list;
						_tmp26_ = _pred_index;
						_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
						_tmp28_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp27_);
						pred = _tmp28_;
						_tmp29_ = idoms;
						_tmp29__length1 = idoms_length1;
						_tmp30_ = pred;
						_tmp31_ = vala_basic_block_get_postorder_number (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = _tmp29_[_tmp32_];
						if (_tmp33_ != NULL) {
							gboolean _tmp34_;
							_tmp34_ = first;
							if (_tmp34_) {
								ValaBasicBlock* _tmp35_;
								ValaBasicBlock* _tmp36_;
								_tmp35_ = pred;
								_tmp36_ = _vala_basic_block_ref0 (_tmp35_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp36_;
								first = FALSE;
							} else {
								ValaBasicBlock** _tmp37_;
								gint _tmp37__length1;
								ValaBasicBlock* _tmp38_;
								ValaBasicBlock* _tmp39_;
								ValaBasicBlock* _tmp40_;
								_tmp37_ = idoms;
								_tmp37__length1 = idoms_length1;
								_tmp38_ = pred;
								_tmp39_ = new_idom;
								_tmp40_ = vala_flow_analyzer_intersect (self, _tmp37_, _tmp37__length1, _tmp38_, _tmp39_);
								_vala_basic_block_unref0 (new_idom);
								new_idom = _tmp40_;
							}
						}
						_vala_basic_block_unref0 (pred);
					}
					_vala_iterable_unref0 (_pred_list);
				}
				_tmp41_ = idoms;
				_tmp41__length1 = idoms_length1;
				_tmp42_ = block;
				_tmp43_ = vala_basic_block_get_postorder_number (_tmp42_);
				_tmp44_ = _tmp43_;
				_tmp45_ = _tmp41_[_tmp44_];
				_tmp46_ = new_idom;
				if (_tmp45_ != _tmp46_) {
					ValaBasicBlock** _tmp47_;
					gint _tmp47__length1;
					ValaBasicBlock* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					ValaBasicBlock* _tmp51_;
					ValaBasicBlock* _tmp52_;
					_tmp47_ = idoms;
					_tmp47__length1 = idoms_length1;
					_tmp48_ = block;
					_tmp49_ = vala_basic_block_get_postorder_number (_tmp48_);
					_tmp50_ = _tmp49_;
					_tmp51_ = new_idom;
					_tmp52_ = _vala_basic_block_ref0 (_tmp51_);
					_vala_basic_block_unref0 (_tmp47_[_tmp50_]);
					_tmp47_[_tmp50_] = _tmp52_;
					changed = TRUE;
				}
				_vala_basic_block_unref0 (new_idom);
				_vala_basic_block_unref0 (block);
			}
			_vala_iterable_unref0 (_block_list);
		}
	}
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp53_;
		gint _block_size = 0;
		ValaList* _tmp54_;
		gint _tmp55_;
		gint _tmp56_;
		gint _block_index = 0;
		_tmp53_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp53_;
		_tmp54_ = _block_list;
		_tmp55_ = vala_collection_get_size ((ValaCollection*) _tmp54_);
		_tmp56_ = _tmp55_;
		_block_size = _tmp56_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp57_;
			gint _tmp58_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp59_;
			gint _tmp60_;
			gpointer _tmp61_;
			ValaBasicBlock* _tmp62_;
			ValaBasicBlock** _tmp63_;
			gint _tmp63__length1;
			ValaBasicBlock* _tmp64_;
			gint _tmp65_;
			gint _tmp66_;
			ValaBasicBlock* _tmp67_;
			ValaBasicBlock* _tmp68_;
			_block_index = _block_index + 1;
			_tmp57_ = _block_index;
			_tmp58_ = _block_size;
			if (!(_tmp57_ < _tmp58_)) {
				break;
			}
			_tmp59_ = _block_list;
			_tmp60_ = _block_index;
			_tmp61_ = vala_list_get (_tmp59_, _tmp60_);
			block = (ValaBasicBlock*) _tmp61_;
			_tmp62_ = block;
			if (_tmp62_ == entry_block) {
				_vala_basic_block_unref0 (block);
				continue;
			}
			_tmp63_ = idoms;
			_tmp63__length1 = idoms_length1;
			_tmp64_ = block;
			_tmp65_ = vala_basic_block_get_postorder_number (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = _tmp63_[_tmp66_];
			_tmp68_ = block;
			vala_basic_block_add_child (_tmp67_, _tmp68_);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	idoms = (_vala_array_free (idoms, idoms_length1, (GDestroyNotify) vala_basic_block_unref), NULL);
}


static ValaBasicBlock*
vala_flow_analyzer_intersect (ValaFlowAnalyzer* self,
                              ValaBasicBlock** idoms,
                              int idoms_length1,
                              ValaBasicBlock* b1,
                              ValaBasicBlock* b2)
{
	ValaBasicBlock* result = NULL;
	ValaBasicBlock* _tmp14_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (b1 != NULL, NULL);
	g_return_val_if_fail (b2 != NULL, NULL);
	while (TRUE) {
		if (!(b1 != b2)) {
			break;
		}
		while (TRUE) {
			gint _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gint _tmp4_;
			gint _tmp5_;
			ValaBasicBlock* _tmp6_;
			_tmp0_ = vala_basic_block_get_postorder_number (b1);
			_tmp1_ = _tmp0_;
			_tmp2_ = vala_basic_block_get_postorder_number (b2);
			_tmp3_ = _tmp2_;
			if (!(_tmp1_ < _tmp3_)) {
				break;
			}
			_tmp4_ = vala_basic_block_get_postorder_number (b2);
			_tmp5_ = _tmp4_;
			_tmp6_ = idoms[_tmp5_];
			b1 = _tmp6_;
		}
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaBasicBlock* _tmp13_;
			_tmp7_ = vala_basic_block_get_postorder_number (b2);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_basic_block_get_postorder_number (b1);
			_tmp10_ = _tmp9_;
			if (!(_tmp8_ < _tmp10_)) {
				break;
			}
			_tmp11_ = vala_basic_block_get_postorder_number (b2);
			_tmp12_ = _tmp11_;
			_tmp13_ = idoms[_tmp12_];
			b2 = _tmp13_;
		}
	}
	_tmp14_ = _vala_basic_block_ref0 (b1);
	result = _tmp14_;
	return result;
}


static void
vala_flow_analyzer_build_dominator_frontier (ValaFlowAnalyzer* self,
                                             ValaList* block_list,
                                             ValaBasicBlock* entry_block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	{
		gint i = 0;
		gint _tmp0_;
		gint _tmp1_;
		_tmp0_ = vala_collection_get_size ((ValaCollection*) block_list);
		_tmp1_ = _tmp0_;
		i = _tmp1_ - 1;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				gint _tmp4_;
				ValaBasicBlock* block = NULL;
				gint _tmp5_;
				gpointer _tmp6_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				if (!(_tmp4_ >= 0)) {
					break;
				}
				_tmp5_ = i;
				_tmp6_ = vala_list_get (block_list, _tmp5_);
				block = (ValaBasicBlock*) _tmp6_;
				{
					ValaList* _succ_list = NULL;
					ValaBasicBlock* _tmp7_;
					ValaList* _tmp8_;
					gint _succ_size = 0;
					ValaList* _tmp9_;
					gint _tmp10_;
					gint _tmp11_;
					gint _succ_index = 0;
					_tmp7_ = block;
					_tmp8_ = vala_basic_block_get_successors (_tmp7_);
					_succ_list = _tmp8_;
					_tmp9_ = _succ_list;
					_tmp10_ = vala_collection_get_size ((ValaCollection*) _tmp9_);
					_tmp11_ = _tmp10_;
					_succ_size = _tmp11_;
					_succ_index = -1;
					while (TRUE) {
						gint _tmp12_;
						gint _tmp13_;
						ValaBasicBlock* succ = NULL;
						ValaList* _tmp14_;
						gint _tmp15_;
						gpointer _tmp16_;
						ValaBasicBlock* _tmp17_;
						ValaBasicBlock* _tmp18_;
						ValaBasicBlock* _tmp19_;
						ValaBasicBlock* _tmp20_;
						_succ_index = _succ_index + 1;
						_tmp12_ = _succ_index;
						_tmp13_ = _succ_size;
						if (!(_tmp12_ < _tmp13_)) {
							break;
						}
						_tmp14_ = _succ_list;
						_tmp15_ = _succ_index;
						_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
						succ = (ValaBasicBlock*) _tmp16_;
						_tmp17_ = succ;
						_tmp18_ = vala_basic_block_get_parent (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp20_ = block;
						if (_tmp19_ != _tmp20_) {
							ValaBasicBlock* _tmp21_;
							ValaBasicBlock* _tmp22_;
							_tmp21_ = block;
							_tmp22_ = succ;
							vala_basic_block_add_dominator_frontier (_tmp21_, _tmp22_);
						}
						_vala_basic_block_unref0 (succ);
					}
					_vala_iterable_unref0 (_succ_list);
				}
				{
					ValaList* _child_list = NULL;
					ValaBasicBlock* _tmp23_;
					ValaList* _tmp24_;
					gint _child_size = 0;
					ValaList* _tmp25_;
					gint _tmp26_;
					gint _tmp27_;
					gint _child_index = 0;
					_tmp23_ = block;
					_tmp24_ = vala_basic_block_get_children (_tmp23_);
					_child_list = _tmp24_;
					_tmp25_ = _child_list;
					_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
					_tmp27_ = _tmp26_;
					_child_size = _tmp27_;
					_child_index = -1;
					while (TRUE) {
						gint _tmp28_;
						gint _tmp29_;
						ValaBasicBlock* child = NULL;
						ValaList* _tmp30_;
						gint _tmp31_;
						gpointer _tmp32_;
						_child_index = _child_index + 1;
						_tmp28_ = _child_index;
						_tmp29_ = _child_size;
						if (!(_tmp28_ < _tmp29_)) {
							break;
						}
						_tmp30_ = _child_list;
						_tmp31_ = _child_index;
						_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
						child = (ValaBasicBlock*) _tmp32_;
						{
							ValaIterator* _child_frontier_it = NULL;
							ValaBasicBlock* _tmp33_;
							ValaSet* _tmp34_;
							ValaSet* _tmp35_;
							ValaIterator* _tmp36_;
							ValaIterator* _tmp37_;
							_tmp33_ = child;
							_tmp34_ = vala_basic_block_get_dominator_frontier (_tmp33_);
							_tmp35_ = _tmp34_;
							_tmp36_ = vala_iterable_iterator ((ValaIterable*) _tmp35_);
							_tmp37_ = _tmp36_;
							_vala_iterable_unref0 (_tmp35_);
							_child_frontier_it = _tmp37_;
							while (TRUE) {
								ValaIterator* _tmp38_;
								ValaBasicBlock* child_frontier = NULL;
								ValaIterator* _tmp39_;
								gpointer _tmp40_;
								ValaBasicBlock* _tmp41_;
								ValaBasicBlock* _tmp42_;
								ValaBasicBlock* _tmp43_;
								ValaBasicBlock* _tmp44_;
								_tmp38_ = _child_frontier_it;
								if (!vala_iterator_next (_tmp38_)) {
									break;
								}
								_tmp39_ = _child_frontier_it;
								_tmp40_ = vala_iterator_get (_tmp39_);
								child_frontier = (ValaBasicBlock*) _tmp40_;
								_tmp41_ = child_frontier;
								_tmp42_ = vala_basic_block_get_parent (_tmp41_);
								_tmp43_ = _tmp42_;
								_tmp44_ = block;
								if (_tmp43_ != _tmp44_) {
									ValaBasicBlock* _tmp45_;
									ValaBasicBlock* _tmp46_;
									_tmp45_ = block;
									_tmp46_ = child_frontier;
									vala_basic_block_add_dominator_frontier (_tmp45_, _tmp46_);
								}
								_vala_basic_block_unref0 (child_frontier);
							}
							_vala_iterator_unref0 (_child_frontier_it);
						}
						_vala_basic_block_unref0 (child);
					}
					_vala_iterable_unref0 (_child_list);
				}
				_vala_basic_block_unref0 (block);
			}
		}
	}
}


static ValaMap*
vala_flow_analyzer_get_assignment_map (ValaFlowAnalyzer* self,
                                       ValaList* block_list,
                                       ValaBasicBlock* entry_block)
{
	ValaMap* result = NULL;
	ValaHashMap* map = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (block_list != NULL, NULL);
	g_return_val_if_fail (entry_block != NULL, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_SET, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	map = _tmp3_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp4_;
		gint _block_size = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		gint _block_index = 0;
		_tmp4_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp4_;
		_tmp5_ = _block_list;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		_block_size = _tmp7_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp8_;
			gint _tmp9_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp13_;
			ValaArrayList* _tmp14_;
			_block_index = _block_index + 1;
			_tmp8_ = _block_index;
			_tmp9_ = _block_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _block_list;
			_tmp11_ = _block_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			block = (ValaBasicBlock*) _tmp12_;
			_tmp13_ = g_direct_equal;
			_tmp14_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp13_);
			defined_variables = _tmp14_;
			{
				ValaList* _node_list = NULL;
				ValaBasicBlock* _tmp15_;
				ValaList* _tmp16_;
				gint _node_size = 0;
				ValaList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _node_index = 0;
				_tmp15_ = block;
				_tmp16_ = vala_basic_block_get_nodes (_tmp15_);
				_node_list = _tmp16_;
				_tmp17_ = _node_list;
				_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_node_size = _tmp19_;
				_node_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					ValaCodeNode* node = NULL;
					ValaList* _tmp22_;
					gint _tmp23_;
					gpointer _tmp24_;
					ValaCodeNode* _tmp25_;
					ValaArrayList* _tmp26_;
					_node_index = _node_index + 1;
					_tmp20_ = _node_index;
					_tmp21_ = _node_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _node_list;
					_tmp23_ = _node_index;
					_tmp24_ = vala_list_get (_tmp22_, _tmp23_);
					node = (ValaCodeNode*) _tmp24_;
					_tmp25_ = node;
					_tmp26_ = defined_variables;
					vala_code_node_get_defined_variables (_tmp25_, (ValaCollection*) _tmp26_);
					_vala_code_node_unref0 (node);
				}
				_vala_iterable_unref0 (_node_list);
			}
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp27_;
				ValaArrayList* _tmp28_;
				gint _variable_size = 0;
				ValaArrayList* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _variable_index = 0;
				_tmp27_ = defined_variables;
				_tmp28_ = _vala_iterable_ref0 (_tmp27_);
				_variable_list = _tmp28_;
				_tmp29_ = _variable_list;
				_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
				_tmp31_ = _tmp30_;
				_variable_size = _tmp31_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp32_;
					gint _tmp33_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp34_;
					gint _tmp35_;
					gpointer _tmp36_;
					ValaSet* block_set = NULL;
					ValaHashMap* _tmp37_;
					ValaVariable* _tmp38_;
					gpointer _tmp39_;
					ValaSet* _tmp40_;
					ValaSet* _tmp47_;
					ValaBasicBlock* _tmp48_;
					_variable_index = _variable_index + 1;
					_tmp32_ = _variable_index;
					_tmp33_ = _variable_size;
					if (!(_tmp32_ < _tmp33_)) {
						break;
					}
					_tmp34_ = _variable_list;
					_tmp35_ = _variable_index;
					_tmp36_ = vala_list_get ((ValaList*) _tmp34_, _tmp35_);
					variable = (ValaVariable*) _tmp36_;
					_tmp37_ = map;
					_tmp38_ = variable;
					_tmp39_ = vala_map_get ((ValaMap*) _tmp37_, _tmp38_);
					block_set = (ValaSet*) _tmp39_;
					_tmp40_ = block_set;
					if (_tmp40_ == NULL) {
						GHashFunc _tmp41_;
						GEqualFunc _tmp42_;
						ValaHashSet* _tmp43_;
						ValaHashMap* _tmp44_;
						ValaVariable* _tmp45_;
						ValaSet* _tmp46_;
						_tmp41_ = g_direct_hash;
						_tmp42_ = g_direct_equal;
						_tmp43_ = vala_hash_set_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp41_, _tmp42_);
						_vala_iterable_unref0 (block_set);
						block_set = (ValaSet*) _tmp43_;
						_tmp44_ = map;
						_tmp45_ = variable;
						_tmp46_ = block_set;
						vala_map_set ((ValaMap*) _tmp44_, _tmp45_, _tmp46_);
					}
					_tmp47_ = block_set;
					_tmp48_ = block;
					vala_collection_add ((ValaCollection*) _tmp47_, _tmp48_);
					_vala_iterable_unref0 (block_set);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	result = (ValaMap*) map;
	return result;
}


static void
vala_flow_analyzer_insert_phi_functions (ValaFlowAnalyzer* self,
                                         ValaList* block_list,
                                         ValaBasicBlock* entry_block)
{
	ValaMap* assign = NULL;
	ValaMap* _tmp0_;
	gint counter = 0;
	ValaArrayList* work_list = NULL;
	GEqualFunc _tmp1_;
	ValaArrayList* _tmp2_;
	ValaHashMap* added = NULL;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashMap* _tmp6_;
	ValaHashMap* phi = NULL;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (block_list != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = vala_flow_analyzer_get_assignment_map (self, block_list, entry_block);
	assign = _tmp0_;
	counter = 0;
	_tmp1_ = g_direct_equal;
	_tmp2_ = vala_array_list_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, _tmp1_);
	work_list = _tmp2_;
	_tmp3_ = g_direct_hash;
	_tmp4_ = g_direct_equal;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp3_, _tmp4_, _tmp5_);
	added = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_BASIC_BLOCK, (GBoxedCopyFunc) vala_basic_block_ref, (GDestroyNotify) vala_basic_block_unref, G_TYPE_INT, NULL, NULL, _tmp7_, _tmp8_, _tmp9_);
	phi = _tmp10_;
	{
		ValaList* _block_list = NULL;
		ValaList* _tmp11_;
		gint _block_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _block_index = 0;
		_tmp11_ = _vala_iterable_ref0 (block_list);
		_block_list = _tmp11_;
		_tmp12_ = _block_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_block_size = _tmp14_;
		_block_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaBasicBlock* block = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValaHashMap* _tmp20_;
			ValaBasicBlock* _tmp21_;
			ValaHashMap* _tmp22_;
			ValaBasicBlock* _tmp23_;
			_block_index = _block_index + 1;
			_tmp15_ = _block_index;
			_tmp16_ = _block_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _block_list;
			_tmp18_ = _block_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			block = (ValaBasicBlock*) _tmp19_;
			_tmp20_ = added;
			_tmp21_ = block;
			vala_map_set ((ValaMap*) _tmp20_, _tmp21_, (gpointer) ((gintptr) 0));
			_tmp22_ = phi;
			_tmp23_ = block;
			vala_map_set ((ValaMap*) _tmp22_, _tmp23_, (gpointer) ((gintptr) 0));
			_vala_basic_block_unref0 (block);
		}
		_vala_iterable_unref0 (_block_list);
	}
	{
		ValaIterator* _variable_it = NULL;
		ValaMap* _tmp24_;
		ValaSet* _tmp25_;
		ValaSet* _tmp26_;
		ValaIterator* _tmp27_;
		ValaIterator* _tmp28_;
		_tmp24_ = assign;
		_tmp25_ = vala_map_get_keys (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_iterable_iterator ((ValaIterable*) _tmp26_);
		_tmp28_ = _tmp27_;
		_vala_iterable_unref0 (_tmp26_);
		_variable_it = _tmp28_;
		while (TRUE) {
			ValaIterator* _tmp29_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp30_;
			gpointer _tmp31_;
			gint _tmp32_;
			_tmp29_ = _variable_it;
			if (!vala_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = _variable_it;
			_tmp31_ = vala_iterator_get (_tmp30_);
			variable = (ValaVariable*) _tmp31_;
			_tmp32_ = counter;
			counter = _tmp32_ + 1;
			{
				ValaIterator* _block_it = NULL;
				ValaMap* _tmp33_;
				ValaVariable* _tmp34_;
				gpointer _tmp35_;
				ValaSet* _tmp36_;
				ValaIterator* _tmp37_;
				ValaIterator* _tmp38_;
				_tmp33_ = assign;
				_tmp34_ = variable;
				_tmp35_ = vala_map_get (_tmp33_, _tmp34_);
				_tmp36_ = (ValaSet*) _tmp35_;
				_tmp37_ = vala_iterable_iterator ((ValaIterable*) _tmp36_);
				_tmp38_ = _tmp37_;
				_vala_iterable_unref0 (_tmp36_);
				_block_it = _tmp38_;
				while (TRUE) {
					ValaIterator* _tmp39_;
					ValaBasicBlock* block = NULL;
					ValaIterator* _tmp40_;
					gpointer _tmp41_;
					ValaArrayList* _tmp42_;
					ValaBasicBlock* _tmp43_;
					ValaHashMap* _tmp44_;
					ValaBasicBlock* _tmp45_;
					gint _tmp46_;
					_tmp39_ = _block_it;
					if (!vala_iterator_next (_tmp39_)) {
						break;
					}
					_tmp40_ = _block_it;
					_tmp41_ = vala_iterator_get (_tmp40_);
					block = (ValaBasicBlock*) _tmp41_;
					_tmp42_ = work_list;
					_tmp43_ = block;
					vala_collection_add ((ValaCollection*) _tmp42_, _tmp43_);
					_tmp44_ = added;
					_tmp45_ = block;
					_tmp46_ = counter;
					vala_map_set ((ValaMap*) _tmp44_, _tmp45_, (gpointer) ((gintptr) _tmp46_));
					_vala_basic_block_unref0 (block);
				}
				_vala_iterator_unref0 (_block_it);
			}
			while (TRUE) {
				ValaArrayList* _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				ValaBasicBlock* block = NULL;
				ValaArrayList* _tmp50_;
				gpointer _tmp51_;
				_tmp47_ = work_list;
				_tmp48_ = vala_collection_get_size ((ValaCollection*) _tmp47_);
				_tmp49_ = _tmp48_;
				if (!(_tmp49_ > 0)) {
					break;
				}
				_tmp50_ = work_list;
				_tmp51_ = vala_list_remove_at ((ValaList*) _tmp50_, 0);
				block = (ValaBasicBlock*) _tmp51_;
				{
					ValaIterator* _frontier_it = NULL;
					ValaBasicBlock* _tmp52_;
					ValaSet* _tmp53_;
					ValaSet* _tmp54_;
					ValaIterator* _tmp55_;
					ValaIterator* _tmp56_;
					_tmp52_ = block;
					_tmp53_ = vala_basic_block_get_dominator_frontier (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp55_ = vala_iterable_iterator ((ValaIterable*) _tmp54_);
					_tmp56_ = _tmp55_;
					_vala_iterable_unref0 (_tmp54_);
					_frontier_it = _tmp56_;
					while (TRUE) {
						ValaIterator* _tmp57_;
						ValaBasicBlock* frontier = NULL;
						ValaIterator* _tmp58_;
						gpointer _tmp59_;
						gint blockPhi = 0;
						ValaHashMap* _tmp60_;
						ValaBasicBlock* _tmp61_;
						gpointer _tmp62_;
						gint _tmp63_;
						gint _tmp64_;
						_tmp57_ = _frontier_it;
						if (!vala_iterator_next (_tmp57_)) {
							break;
						}
						_tmp58_ = _frontier_it;
						_tmp59_ = vala_iterator_get (_tmp58_);
						frontier = (ValaBasicBlock*) _tmp59_;
						_tmp60_ = phi;
						_tmp61_ = frontier;
						_tmp62_ = vala_map_get ((ValaMap*) _tmp60_, _tmp61_);
						blockPhi = (gint) ((gintptr) _tmp62_);
						_tmp63_ = blockPhi;
						_tmp64_ = counter;
						if (_tmp63_ < _tmp64_) {
							ValaBasicBlock* _tmp65_;
							ValaVariable* _tmp66_;
							ValaBasicBlock* _tmp67_;
							ValaList* _tmp68_;
							ValaList* _tmp69_;
							gint _tmp70_;
							gint _tmp71_;
							ValaPhiFunction* _tmp72_;
							ValaPhiFunction* _tmp73_;
							ValaHashMap* _tmp74_;
							ValaBasicBlock* _tmp75_;
							gint _tmp76_;
							gint block_added = 0;
							ValaHashMap* _tmp77_;
							ValaBasicBlock* _tmp78_;
							gpointer _tmp79_;
							gint _tmp80_;
							gint _tmp81_;
							_tmp65_ = frontier;
							_tmp66_ = variable;
							_tmp67_ = frontier;
							_tmp68_ = vala_basic_block_get_predecessors (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = vala_collection_get_size ((ValaCollection*) _tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = vala_phi_function_new (_tmp66_, _tmp71_);
							_tmp73_ = _tmp72_;
							vala_basic_block_add_phi_function (_tmp65_, _tmp73_);
							_vala_phi_function_unref0 (_tmp73_);
							_vala_iterable_unref0 (_tmp69_);
							_tmp74_ = phi;
							_tmp75_ = frontier;
							_tmp76_ = counter;
							vala_map_set ((ValaMap*) _tmp74_, _tmp75_, (gpointer) ((gintptr) _tmp76_));
							_tmp77_ = added;
							_tmp78_ = frontier;
							_tmp79_ = vala_map_get ((ValaMap*) _tmp77_, _tmp78_);
							block_added = (gint) ((gintptr) _tmp79_);
							_tmp80_ = block_added;
							_tmp81_ = counter;
							if (_tmp80_ < _tmp81_) {
								ValaHashMap* _tmp82_;
								ValaBasicBlock* _tmp83_;
								gint _tmp84_;
								ValaArrayList* _tmp85_;
								ValaBasicBlock* _tmp86_;
								_tmp82_ = added;
								_tmp83_ = frontier;
								_tmp84_ = counter;
								vala_map_set ((ValaMap*) _tmp82_, _tmp83_, (gpointer) ((gintptr) _tmp84_));
								_tmp85_ = work_list;
								_tmp86_ = frontier;
								vala_collection_add ((ValaCollection*) _tmp85_, _tmp86_);
							}
						}
						_vala_basic_block_unref0 (frontier);
					}
					_vala_iterator_unref0 (_frontier_it);
				}
				_vala_basic_block_unref0 (block);
			}
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	_vala_map_unref0 (phi);
	_vala_map_unref0 (added);
	_vala_iterable_unref0 (work_list);
	_vala_map_unref0 (assign);
}


static void
vala_flow_analyzer_check_variables (ValaFlowAnalyzer* self,
                                    ValaBasicBlock* entry_block)
{
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GEqualFunc _tmp2_;
	ValaHashMap* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	ValaHashSet* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GEqualFunc _tmp9_;
	ValaHashMap* _tmp10_;
	ValaArrayList* used_vars_queue = NULL;
	GEqualFunc _tmp11_;
	ValaArrayList* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (entry_block != NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_hash_map_new (VALA_TYPE_SYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_LIST, (GBoxedCopyFunc) vala_iterable_ref, (GDestroyNotify) vala_iterable_unref, _tmp0_, _tmp1_, _tmp2_);
	_vala_map_unref0 (self->priv->var_map);
	self->priv->var_map = (ValaMap*) _tmp3_;
	_tmp4_ = g_direct_hash;
	_tmp5_ = g_direct_equal;
	_tmp6_ = vala_hash_set_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp4_, _tmp5_);
	_vala_iterable_unref0 (self->priv->used_vars);
	self->priv->used_vars = (ValaSet*) _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_direct_equal;
	_tmp10_ = vala_hash_map_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, VALA_TYPE_PHI_FUNCTION, (GBoxedCopyFunc) vala_phi_function_ref, (GDestroyNotify) vala_phi_function_unref, _tmp7_, _tmp8_, _tmp9_);
	_vala_map_unref0 (self->priv->phi_functions);
	self->priv->phi_functions = (ValaMap*) _tmp10_;
	vala_flow_analyzer_check_block_variables (self, entry_block);
	_tmp11_ = g_direct_equal;
	_tmp12_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp11_);
	used_vars_queue = _tmp12_;
	{
		ValaIterator* _variable_it = NULL;
		ValaSet* _tmp13_;
		ValaIterator* _tmp14_;
		_tmp13_ = self->priv->used_vars;
		_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
		_variable_it = _tmp14_;
		while (TRUE) {
			ValaIterator* _tmp15_;
			ValaVariable* variable = NULL;
			ValaIterator* _tmp16_;
			gpointer _tmp17_;
			ValaArrayList* _tmp18_;
			ValaVariable* _tmp19_;
			_tmp15_ = _variable_it;
			if (!vala_iterator_next (_tmp15_)) {
				break;
			}
			_tmp16_ = _variable_it;
			_tmp17_ = vala_iterator_get (_tmp16_);
			variable = (ValaVariable*) _tmp17_;
			_tmp18_ = used_vars_queue;
			_tmp19_ = variable;
			vala_collection_add ((ValaCollection*) _tmp18_, _tmp19_);
			_vala_code_node_unref0 (variable);
		}
		_vala_iterator_unref0 (_variable_it);
	}
	while (TRUE) {
		ValaArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		ValaVariable* used_var = NULL;
		ValaArrayList* _tmp23_;
		gpointer _tmp24_;
		ValaPhiFunction* phi = NULL;
		ValaMap* _tmp25_;
		ValaVariable* _tmp26_;
		gpointer _tmp27_;
		ValaPhiFunction* _tmp28_;
		_tmp20_ = used_vars_queue;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		if (!(_tmp22_ > 0)) {
			break;
		}
		_tmp23_ = used_vars_queue;
		_tmp24_ = vala_list_remove_at ((ValaList*) _tmp23_, 0);
		used_var = (ValaVariable*) _tmp24_;
		_tmp25_ = self->priv->phi_functions;
		_tmp26_ = used_var;
		_tmp27_ = vala_map_get (_tmp25_, _tmp26_);
		phi = (ValaPhiFunction*) _tmp27_;
		_tmp28_ = phi;
		if (_tmp28_ != NULL) {
			{
				ValaList* _variable_list = NULL;
				ValaPhiFunction* _tmp29_;
				ValaList* _tmp30_;
				ValaList* _tmp31_;
				ValaList* _tmp32_;
				gint _variable_size = 0;
				ValaList* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				gint _variable_index = 0;
				_tmp29_ = phi;
				_tmp30_ = vala_phi_function_get_operands (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = _vala_iterable_ref0 (_tmp31_);
				_variable_list = _tmp32_;
				_tmp33_ = _variable_list;
				_tmp34_ = vala_collection_get_size ((ValaCollection*) _tmp33_);
				_tmp35_ = _tmp34_;
				_variable_size = _tmp35_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp36_;
					gint _tmp37_;
					ValaVariable* variable = NULL;
					ValaList* _tmp38_;
					gint _tmp39_;
					gpointer _tmp40_;
					ValaVariable* _tmp41_;
					ValaSet* _tmp59_;
					ValaVariable* _tmp60_;
					_variable_index = _variable_index + 1;
					_tmp36_ = _variable_index;
					_tmp37_ = _variable_size;
					if (!(_tmp36_ < _tmp37_)) {
						break;
					}
					_tmp38_ = _variable_list;
					_tmp39_ = _variable_index;
					_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
					variable = (ValaVariable*) _tmp40_;
					_tmp41_ = variable;
					if (_tmp41_ == NULL) {
						ValaVariable* _tmp42_;
						_tmp42_ = used_var;
						if (VALA_IS_LOCAL_VARIABLE (_tmp42_)) {
							ValaVariable* _tmp43_;
							ValaSourceReference* _tmp44_;
							ValaSourceReference* _tmp45_;
							ValaVariable* _tmp46_;
							const gchar* _tmp47_;
							const gchar* _tmp48_;
							gchar* _tmp49_;
							gchar* _tmp50_;
							_tmp43_ = used_var;
							_tmp44_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp43_);
							_tmp45_ = _tmp44_;
							_tmp46_ = used_var;
							_tmp47_ = vala_symbol_get_name ((ValaSymbol*) _tmp46_);
							_tmp48_ = _tmp47_;
							_tmp49_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp48_);
							_tmp50_ = _tmp49_;
							vala_report_error (_tmp45_, _tmp50_);
							_g_free0 (_tmp50_);
						} else {
							ValaVariable* _tmp51_;
							ValaSourceReference* _tmp52_;
							ValaSourceReference* _tmp53_;
							ValaVariable* _tmp54_;
							const gchar* _tmp55_;
							const gchar* _tmp56_;
							gchar* _tmp57_;
							gchar* _tmp58_;
							_tmp51_ = used_var;
							_tmp52_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp51_);
							_tmp53_ = _tmp52_;
							_tmp54_ = used_var;
							_tmp55_ = vala_symbol_get_name ((ValaSymbol*) _tmp54_);
							_tmp56_ = _tmp55_;
							_tmp57_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp56_);
							_tmp58_ = _tmp57_;
							vala_report_warning (_tmp53_, _tmp58_);
							_g_free0 (_tmp58_);
						}
						_vala_code_node_unref0 (variable);
						continue;
					}
					_tmp59_ = self->priv->used_vars;
					_tmp60_ = variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp59_, _tmp60_)) {
						ValaVariable* _tmp61_;
						ValaVariable* _tmp62_;
						ValaSourceReference* _tmp63_;
						ValaSourceReference* _tmp64_;
						ValaSet* _tmp65_;
						ValaVariable* _tmp66_;
						ValaArrayList* _tmp67_;
						ValaVariable* _tmp68_;
						_tmp61_ = variable;
						_tmp62_ = used_var;
						_tmp63_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp62_);
						_tmp64_ = _tmp63_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp61_, _tmp64_);
						_tmp65_ = self->priv->used_vars;
						_tmp66_ = variable;
						vala_collection_add ((ValaCollection*) _tmp65_, _tmp66_);
						_tmp67_ = used_vars_queue;
						_tmp68_ = variable;
						vala_collection_add ((ValaCollection*) _tmp67_, _tmp68_);
					}
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
		}
		_vala_phi_function_unref0 (phi);
		_vala_code_node_unref0 (used_var);
	}
	_vala_iterable_unref0 (used_vars_queue);
}


static void
vala_flow_analyzer_check_block_variables (ValaFlowAnalyzer* self,
                                          ValaBasicBlock* block)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (block != NULL);
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp0_;
		ValaSet* _tmp1_;
		ValaIterator* _tmp2_;
		ValaIterator* _tmp3_;
		_tmp0_ = vala_basic_block_get_phi_functions (block);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_iterable_iterator ((ValaIterable*) _tmp1_);
		_tmp3_ = _tmp2_;
		_vala_iterable_unref0 (_tmp1_);
		_phi_it = _tmp3_;
		while (TRUE) {
			ValaIterator* _tmp4_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp5_;
			gpointer _tmp6_;
			ValaVariable* versioned_var = NULL;
			ValaMap* _tmp7_;
			ValaPhiFunction* _tmp8_;
			ValaVariable* _tmp9_;
			ValaVariable* _tmp10_;
			ValaVariable* _tmp11_;
			ValaMap* _tmp12_;
			ValaVariable* _tmp13_;
			ValaPhiFunction* _tmp14_;
			_tmp4_ = _phi_it;
			if (!vala_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _phi_it;
			_tmp6_ = vala_iterator_get (_tmp5_);
			phi = (ValaPhiFunction*) _tmp6_;
			_tmp7_ = self->priv->var_map;
			_tmp8_ = phi;
			_tmp9_ = vala_phi_function_get_original_variable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_flow_analyzer_process_assignment (self, _tmp7_, _tmp10_);
			versioned_var = _tmp11_;
			_tmp12_ = self->priv->phi_functions;
			_tmp13_ = versioned_var;
			_tmp14_ = phi;
			vala_map_set (_tmp12_, _tmp13_, _tmp14_);
			_vala_code_node_unref0 (versioned_var);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp15_;
		gint _node_size = 0;
		ValaList* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gint _node_index = 0;
		_tmp15_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp15_;
		_tmp16_ = _node_list;
		_tmp17_ = vala_collection_get_size ((ValaCollection*) _tmp16_);
		_tmp18_ = _tmp17_;
		_node_size = _tmp18_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp19_;
			gint _tmp20_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp21_;
			gint _tmp22_;
			gpointer _tmp23_;
			ValaArrayList* used_variables = NULL;
			GEqualFunc _tmp24_;
			ValaArrayList* _tmp25_;
			ValaCodeNode* _tmp26_;
			ValaArrayList* _tmp27_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp76_;
			ValaArrayList* _tmp77_;
			ValaCodeNode* _tmp78_;
			ValaArrayList* _tmp79_;
			_node_index = _node_index + 1;
			_tmp19_ = _node_index;
			_tmp20_ = _node_size;
			if (!(_tmp19_ < _tmp20_)) {
				break;
			}
			_tmp21_ = _node_list;
			_tmp22_ = _node_index;
			_tmp23_ = vala_list_get (_tmp21_, _tmp22_);
			node = (ValaCodeNode*) _tmp23_;
			_tmp24_ = g_direct_equal;
			_tmp25_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp24_);
			used_variables = _tmp25_;
			_tmp26_ = node;
			_tmp27_ = used_variables;
			vala_code_node_get_used_variables (_tmp26_, (ValaCollection*) _tmp27_);
			{
				ValaArrayList* _var_symbol_list = NULL;
				ValaArrayList* _tmp28_;
				ValaArrayList* _tmp29_;
				gint _var_symbol_size = 0;
				ValaArrayList* _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _var_symbol_index = 0;
				_tmp28_ = used_variables;
				_tmp29_ = _vala_iterable_ref0 (_tmp28_);
				_var_symbol_list = _tmp29_;
				_tmp30_ = _var_symbol_list;
				_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
				_tmp32_ = _tmp31_;
				_var_symbol_size = _tmp32_;
				_var_symbol_index = -1;
				while (TRUE) {
					gint _tmp33_;
					gint _tmp34_;
					ValaVariable* var_symbol = NULL;
					ValaArrayList* _tmp35_;
					gint _tmp36_;
					gpointer _tmp37_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp38_;
					ValaVariable* _tmp39_;
					gpointer _tmp40_;
					gboolean _tmp41_ = FALSE;
					ValaList* _tmp42_;
					ValaVariable* versioned_variable = NULL;
					ValaList* _tmp63_;
					ValaList* _tmp64_;
					gint _tmp65_;
					gint _tmp66_;
					gpointer _tmp67_;
					ValaSet* _tmp68_;
					ValaVariable* _tmp69_;
					ValaSet* _tmp74_;
					ValaVariable* _tmp75_;
					_var_symbol_index = _var_symbol_index + 1;
					_tmp33_ = _var_symbol_index;
					_tmp34_ = _var_symbol_size;
					if (!(_tmp33_ < _tmp34_)) {
						break;
					}
					_tmp35_ = _var_symbol_list;
					_tmp36_ = _var_symbol_index;
					_tmp37_ = vala_list_get ((ValaList*) _tmp35_, _tmp36_);
					var_symbol = (ValaVariable*) _tmp37_;
					_tmp38_ = self->priv->var_map;
					_tmp39_ = var_symbol;
					_tmp40_ = vala_map_get (_tmp38_, (ValaSymbol*) _tmp39_);
					variable_stack = (ValaList*) _tmp40_;
					_tmp42_ = variable_stack;
					if (_tmp42_ == NULL) {
						_tmp41_ = TRUE;
					} else {
						ValaList* _tmp43_;
						gint _tmp44_;
						gint _tmp45_;
						_tmp43_ = variable_stack;
						_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
						_tmp45_ = _tmp44_;
						_tmp41_ = _tmp45_ == 0;
					}
					if (_tmp41_) {
						ValaVariable* _tmp46_;
						_tmp46_ = var_symbol;
						if (VALA_IS_LOCAL_VARIABLE (_tmp46_)) {
							ValaCodeNode* _tmp47_;
							ValaSourceReference* _tmp48_;
							ValaSourceReference* _tmp49_;
							ValaVariable* _tmp50_;
							const gchar* _tmp51_;
							const gchar* _tmp52_;
							gchar* _tmp53_;
							gchar* _tmp54_;
							_tmp47_ = node;
							_tmp48_ = vala_code_node_get_source_reference (_tmp47_);
							_tmp49_ = _tmp48_;
							_tmp50_ = var_symbol;
							_tmp51_ = vala_symbol_get_name ((ValaSymbol*) _tmp50_);
							_tmp52_ = _tmp51_;
							_tmp53_ = g_strdup_printf ("use of possibly unassigned local variable `%s'", _tmp52_);
							_tmp54_ = _tmp53_;
							vala_report_error (_tmp49_, _tmp54_);
							_g_free0 (_tmp54_);
						} else {
							ValaCodeNode* _tmp55_;
							ValaSourceReference* _tmp56_;
							ValaSourceReference* _tmp57_;
							ValaVariable* _tmp58_;
							const gchar* _tmp59_;
							const gchar* _tmp60_;
							gchar* _tmp61_;
							gchar* _tmp62_;
							_tmp55_ = node;
							_tmp56_ = vala_code_node_get_source_reference (_tmp55_);
							_tmp57_ = _tmp56_;
							_tmp58_ = var_symbol;
							_tmp59_ = vala_symbol_get_name ((ValaSymbol*) _tmp58_);
							_tmp60_ = _tmp59_;
							_tmp61_ = g_strdup_printf ("use of possibly unassigned parameter `%s'", _tmp60_);
							_tmp62_ = _tmp61_;
							vala_report_warning (_tmp57_, _tmp62_);
							_g_free0 (_tmp62_);
						}
						_vala_iterable_unref0 (variable_stack);
						_vala_code_node_unref0 (var_symbol);
						continue;
					}
					_tmp63_ = variable_stack;
					_tmp64_ = variable_stack;
					_tmp65_ = vala_collection_get_size ((ValaCollection*) _tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = vala_list_get (_tmp63_, _tmp66_ - 1);
					versioned_variable = (ValaVariable*) _tmp67_;
					_tmp68_ = self->priv->used_vars;
					_tmp69_ = versioned_variable;
					if (!vala_collection_contains ((ValaCollection*) _tmp68_, _tmp69_)) {
						ValaVariable* _tmp70_;
						ValaCodeNode* _tmp71_;
						ValaSourceReference* _tmp72_;
						ValaSourceReference* _tmp73_;
						_tmp70_ = versioned_variable;
						_tmp71_ = node;
						_tmp72_ = vala_code_node_get_source_reference (_tmp71_);
						_tmp73_ = _tmp72_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp70_, _tmp73_);
					}
					_tmp74_ = self->priv->used_vars;
					_tmp75_ = versioned_variable;
					vala_collection_add ((ValaCollection*) _tmp74_, _tmp75_);
					_vala_code_node_unref0 (versioned_variable);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (var_symbol);
				}
				_vala_iterable_unref0 (_var_symbol_list);
			}
			_tmp76_ = g_direct_equal;
			_tmp77_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp76_);
			defined_variables = _tmp77_;
			_tmp78_ = node;
			_tmp79_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp78_, (ValaCollection*) _tmp79_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp80_;
				ValaArrayList* _tmp81_;
				gint _variable_size = 0;
				ValaArrayList* _tmp82_;
				gint _tmp83_;
				gint _tmp84_;
				gint _variable_index = 0;
				_tmp80_ = defined_variables;
				_tmp81_ = _vala_iterable_ref0 (_tmp80_);
				_variable_list = _tmp81_;
				_tmp82_ = _variable_list;
				_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
				_tmp84_ = _tmp83_;
				_variable_size = _tmp84_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp85_;
					gint _tmp86_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp87_;
					gint _tmp88_;
					gpointer _tmp89_;
					ValaMap* _tmp90_;
					ValaVariable* _tmp91_;
					ValaVariable* _tmp92_;
					ValaVariable* _tmp93_;
					_variable_index = _variable_index + 1;
					_tmp85_ = _variable_index;
					_tmp86_ = _variable_size;
					if (!(_tmp85_ < _tmp86_)) {
						break;
					}
					_tmp87_ = _variable_list;
					_tmp88_ = _variable_index;
					_tmp89_ = vala_list_get ((ValaList*) _tmp87_, _tmp88_);
					variable = (ValaVariable*) _tmp89_;
					_tmp90_ = self->priv->var_map;
					_tmp91_ = variable;
					_tmp92_ = vala_flow_analyzer_process_assignment (self, _tmp90_, _tmp91_);
					_tmp93_ = _tmp92_;
					_vala_code_node_unref0 (_tmp93_);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_iterable_unref0 (used_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
	{
		ValaList* _succ_list = NULL;
		ValaList* _tmp94_;
		gint _succ_size = 0;
		ValaList* _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _succ_index = 0;
		_tmp94_ = vala_basic_block_get_successors (block);
		_succ_list = _tmp94_;
		_tmp95_ = _succ_list;
		_tmp96_ = vala_collection_get_size ((ValaCollection*) _tmp95_);
		_tmp97_ = _tmp96_;
		_succ_size = _tmp97_;
		_succ_index = -1;
		while (TRUE) {
			gint _tmp98_;
			gint _tmp99_;
			ValaBasicBlock* succ = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			gint j = 0;
			_succ_index = _succ_index + 1;
			_tmp98_ = _succ_index;
			_tmp99_ = _succ_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _succ_list;
			_tmp101_ = _succ_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			succ = (ValaBasicBlock*) _tmp102_;
			j = 0;
			{
				ValaList* _pred_list = NULL;
				ValaBasicBlock* _tmp103_;
				ValaList* _tmp104_;
				gint _pred_size = 0;
				ValaList* _tmp105_;
				gint _tmp106_;
				gint _tmp107_;
				gint _pred_index = 0;
				_tmp103_ = succ;
				_tmp104_ = vala_basic_block_get_predecessors (_tmp103_);
				_pred_list = _tmp104_;
				_tmp105_ = _pred_list;
				_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
				_tmp107_ = _tmp106_;
				_pred_size = _tmp107_;
				_pred_index = -1;
				while (TRUE) {
					gint _tmp108_;
					gint _tmp109_;
					ValaBasicBlock* pred = NULL;
					ValaList* _tmp110_;
					gint _tmp111_;
					gpointer _tmp112_;
					ValaBasicBlock* _tmp113_;
					ValaBasicBlock* _tmp114_;
					gint _tmp115_;
					_pred_index = _pred_index + 1;
					_tmp108_ = _pred_index;
					_tmp109_ = _pred_size;
					if (!(_tmp108_ < _tmp109_)) {
						break;
					}
					_tmp110_ = _pred_list;
					_tmp111_ = _pred_index;
					_tmp112_ = vala_list_get (_tmp110_, _tmp111_);
					_tmp113_ = _vala_basic_block_ref0 ((ValaBasicBlock*) _tmp112_);
					pred = _tmp113_;
					_tmp114_ = pred;
					if (_tmp114_ == block) {
						_vala_basic_block_unref0 (pred);
						break;
					}
					_tmp115_ = j;
					j = _tmp115_ + 1;
					_vala_basic_block_unref0 (pred);
				}
				_vala_iterable_unref0 (_pred_list);
			}
			{
				ValaIterator* _phi_it = NULL;
				ValaBasicBlock* _tmp116_;
				ValaSet* _tmp117_;
				ValaSet* _tmp118_;
				ValaIterator* _tmp119_;
				ValaIterator* _tmp120_;
				_tmp116_ = succ;
				_tmp117_ = vala_basic_block_get_phi_functions (_tmp116_);
				_tmp118_ = _tmp117_;
				_tmp119_ = vala_iterable_iterator ((ValaIterable*) _tmp118_);
				_tmp120_ = _tmp119_;
				_vala_iterable_unref0 (_tmp118_);
				_phi_it = _tmp120_;
				while (TRUE) {
					ValaIterator* _tmp121_;
					ValaPhiFunction* phi = NULL;
					ValaIterator* _tmp122_;
					gpointer _tmp123_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp124_;
					ValaPhiFunction* _tmp125_;
					ValaVariable* _tmp126_;
					ValaVariable* _tmp127_;
					gpointer _tmp128_;
					gboolean _tmp129_ = FALSE;
					ValaList* _tmp130_;
					_tmp121_ = _phi_it;
					if (!vala_iterator_next (_tmp121_)) {
						break;
					}
					_tmp122_ = _phi_it;
					_tmp123_ = vala_iterator_get (_tmp122_);
					phi = (ValaPhiFunction*) _tmp123_;
					_tmp124_ = self->priv->var_map;
					_tmp125_ = phi;
					_tmp126_ = vala_phi_function_get_original_variable (_tmp125_);
					_tmp127_ = _tmp126_;
					_tmp128_ = vala_map_get (_tmp124_, (ValaSymbol*) _tmp127_);
					variable_stack = (ValaList*) _tmp128_;
					_tmp130_ = variable_stack;
					if (_tmp130_ != NULL) {
						ValaList* _tmp131_;
						gint _tmp132_;
						gint _tmp133_;
						_tmp131_ = variable_stack;
						_tmp132_ = vala_collection_get_size ((ValaCollection*) _tmp131_);
						_tmp133_ = _tmp132_;
						_tmp129_ = _tmp133_ > 0;
					} else {
						_tmp129_ = FALSE;
					}
					if (_tmp129_) {
						ValaPhiFunction* _tmp134_;
						ValaList* _tmp135_;
						ValaList* _tmp136_;
						gint _tmp137_;
						ValaList* _tmp138_;
						ValaList* _tmp139_;
						gint _tmp140_;
						gint _tmp141_;
						gpointer _tmp142_;
						ValaVariable* _tmp143_;
						_tmp134_ = phi;
						_tmp135_ = vala_phi_function_get_operands (_tmp134_);
						_tmp136_ = _tmp135_;
						_tmp137_ = j;
						_tmp138_ = variable_stack;
						_tmp139_ = variable_stack;
						_tmp140_ = vala_collection_get_size ((ValaCollection*) _tmp139_);
						_tmp141_ = _tmp140_;
						_tmp142_ = vala_list_get (_tmp138_, _tmp141_ - 1);
						_tmp143_ = (ValaVariable*) _tmp142_;
						vala_list_set (_tmp136_, _tmp137_, _tmp143_);
						_vala_code_node_unref0 (_tmp143_);
					}
					_vala_iterable_unref0 (variable_stack);
					_vala_phi_function_unref0 (phi);
				}
				_vala_iterator_unref0 (_phi_it);
			}
			_vala_basic_block_unref0 (succ);
		}
		_vala_iterable_unref0 (_succ_list);
	}
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp144_;
		gint _child_size = 0;
		ValaList* _tmp145_;
		gint _tmp146_;
		gint _tmp147_;
		gint _child_index = 0;
		_tmp144_ = vala_basic_block_get_children (block);
		_child_list = _tmp144_;
		_tmp145_ = _child_list;
		_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
		_tmp147_ = _tmp146_;
		_child_size = _tmp147_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp148_;
			gint _tmp149_;
			ValaBasicBlock* child = NULL;
			ValaList* _tmp150_;
			gint _tmp151_;
			gpointer _tmp152_;
			ValaBasicBlock* _tmp153_;
			_child_index = _child_index + 1;
			_tmp148_ = _child_index;
			_tmp149_ = _child_size;
			if (!(_tmp148_ < _tmp149_)) {
				break;
			}
			_tmp150_ = _child_list;
			_tmp151_ = _child_index;
			_tmp152_ = vala_list_get (_tmp150_, _tmp151_);
			child = (ValaBasicBlock*) _tmp152_;
			_tmp153_ = child;
			vala_flow_analyzer_check_block_variables (self, _tmp153_);
			_vala_basic_block_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	{
		ValaIterator* _phi_it = NULL;
		ValaSet* _tmp154_;
		ValaSet* _tmp155_;
		ValaIterator* _tmp156_;
		ValaIterator* _tmp157_;
		_tmp154_ = vala_basic_block_get_phi_functions (block);
		_tmp155_ = _tmp154_;
		_tmp156_ = vala_iterable_iterator ((ValaIterable*) _tmp155_);
		_tmp157_ = _tmp156_;
		_vala_iterable_unref0 (_tmp155_);
		_phi_it = _tmp157_;
		while (TRUE) {
			ValaIterator* _tmp158_;
			ValaPhiFunction* phi = NULL;
			ValaIterator* _tmp159_;
			gpointer _tmp160_;
			ValaList* variable_stack = NULL;
			ValaMap* _tmp161_;
			ValaPhiFunction* _tmp162_;
			ValaVariable* _tmp163_;
			ValaVariable* _tmp164_;
			gpointer _tmp165_;
			ValaList* _tmp166_;
			ValaList* _tmp167_;
			gint _tmp168_;
			gint _tmp169_;
			gpointer _tmp170_;
			ValaVariable* _tmp171_;
			_tmp158_ = _phi_it;
			if (!vala_iterator_next (_tmp158_)) {
				break;
			}
			_tmp159_ = _phi_it;
			_tmp160_ = vala_iterator_get (_tmp159_);
			phi = (ValaPhiFunction*) _tmp160_;
			_tmp161_ = self->priv->var_map;
			_tmp162_ = phi;
			_tmp163_ = vala_phi_function_get_original_variable (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = vala_map_get (_tmp161_, (ValaSymbol*) _tmp164_);
			variable_stack = (ValaList*) _tmp165_;
			_tmp166_ = variable_stack;
			_tmp167_ = variable_stack;
			_tmp168_ = vala_collection_get_size ((ValaCollection*) _tmp167_);
			_tmp169_ = _tmp168_;
			_tmp170_ = vala_list_remove_at (_tmp166_, _tmp169_ - 1);
			_tmp171_ = (ValaVariable*) _tmp170_;
			_vala_code_node_unref0 (_tmp171_);
			_vala_iterable_unref0 (variable_stack);
			_vala_phi_function_unref0 (phi);
		}
		_vala_iterator_unref0 (_phi_it);
	}
	{
		ValaList* _node_list = NULL;
		ValaList* _tmp172_;
		gint _node_size = 0;
		ValaList* _tmp173_;
		gint _tmp174_;
		gint _tmp175_;
		gint _node_index = 0;
		_tmp172_ = vala_basic_block_get_nodes (block);
		_node_list = _tmp172_;
		_tmp173_ = _node_list;
		_tmp174_ = vala_collection_get_size ((ValaCollection*) _tmp173_);
		_tmp175_ = _tmp174_;
		_node_size = _tmp175_;
		_node_index = -1;
		while (TRUE) {
			gint _tmp176_;
			gint _tmp177_;
			ValaCodeNode* node = NULL;
			ValaList* _tmp178_;
			gint _tmp179_;
			gpointer _tmp180_;
			ValaArrayList* defined_variables = NULL;
			GEqualFunc _tmp181_;
			ValaArrayList* _tmp182_;
			ValaCodeNode* _tmp183_;
			ValaArrayList* _tmp184_;
			_node_index = _node_index + 1;
			_tmp176_ = _node_index;
			_tmp177_ = _node_size;
			if (!(_tmp176_ < _tmp177_)) {
				break;
			}
			_tmp178_ = _node_list;
			_tmp179_ = _node_index;
			_tmp180_ = vala_list_get (_tmp178_, _tmp179_);
			node = (ValaCodeNode*) _tmp180_;
			_tmp181_ = g_direct_equal;
			_tmp182_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp181_);
			defined_variables = _tmp182_;
			_tmp183_ = node;
			_tmp184_ = defined_variables;
			vala_code_node_get_defined_variables (_tmp183_, (ValaCollection*) _tmp184_);
			{
				ValaArrayList* _variable_list = NULL;
				ValaArrayList* _tmp185_;
				ValaArrayList* _tmp186_;
				gint _variable_size = 0;
				ValaArrayList* _tmp187_;
				gint _tmp188_;
				gint _tmp189_;
				gint _variable_index = 0;
				_tmp185_ = defined_variables;
				_tmp186_ = _vala_iterable_ref0 (_tmp185_);
				_variable_list = _tmp186_;
				_tmp187_ = _variable_list;
				_tmp188_ = vala_collection_get_size ((ValaCollection*) _tmp187_);
				_tmp189_ = _tmp188_;
				_variable_size = _tmp189_;
				_variable_index = -1;
				while (TRUE) {
					gint _tmp190_;
					gint _tmp191_;
					ValaVariable* variable = NULL;
					ValaArrayList* _tmp192_;
					gint _tmp193_;
					gpointer _tmp194_;
					ValaList* variable_stack = NULL;
					ValaMap* _tmp195_;
					ValaVariable* _tmp196_;
					gpointer _tmp197_;
					ValaList* _tmp198_;
					ValaList* _tmp199_;
					gint _tmp200_;
					gint _tmp201_;
					gpointer _tmp202_;
					ValaVariable* _tmp203_;
					_variable_index = _variable_index + 1;
					_tmp190_ = _variable_index;
					_tmp191_ = _variable_size;
					if (!(_tmp190_ < _tmp191_)) {
						break;
					}
					_tmp192_ = _variable_list;
					_tmp193_ = _variable_index;
					_tmp194_ = vala_list_get ((ValaList*) _tmp192_, _tmp193_);
					variable = (ValaVariable*) _tmp194_;
					_tmp195_ = self->priv->var_map;
					_tmp196_ = variable;
					_tmp197_ = vala_map_get (_tmp195_, (ValaSymbol*) _tmp196_);
					variable_stack = (ValaList*) _tmp197_;
					_tmp198_ = variable_stack;
					_tmp199_ = variable_stack;
					_tmp200_ = vala_collection_get_size ((ValaCollection*) _tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_list_remove_at (_tmp198_, _tmp201_ - 1);
					_tmp203_ = (ValaVariable*) _tmp202_;
					_vala_code_node_unref0 (_tmp203_);
					_vala_iterable_unref0 (variable_stack);
					_vala_code_node_unref0 (variable);
				}
				_vala_iterable_unref0 (_variable_list);
			}
			_vala_iterable_unref0 (defined_variables);
			_vala_code_node_unref0 (node);
		}
		_vala_iterable_unref0 (_node_list);
	}
}


static ValaVariable*
vala_flow_analyzer_process_assignment (ValaFlowAnalyzer* self,
                                       ValaMap* var_map,
                                       ValaVariable* var_symbol)
{
	ValaVariable* result = NULL;
	ValaList* variable_stack = NULL;
	gpointer _tmp0_;
	ValaList* _tmp1_;
	ValaVariable* versioned_var = NULL;
	ValaList* _tmp23_;
	ValaVariable* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (var_map != NULL, NULL);
	g_return_val_if_fail (var_symbol != NULL, NULL);
	_tmp0_ = vala_map_get (var_map, (ValaSymbol*) var_symbol);
	variable_stack = (ValaList*) _tmp0_;
	_tmp1_ = variable_stack;
	if (_tmp1_ == NULL) {
		GEqualFunc _tmp2_;
		ValaArrayList* _tmp3_;
		ValaList* _tmp4_;
		_tmp2_ = g_direct_equal;
		_tmp3_ = vala_array_list_new (VALA_TYPE_VARIABLE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
		_vala_iterable_unref0 (variable_stack);
		variable_stack = (ValaList*) _tmp3_;
		_tmp4_ = variable_stack;
		vala_map_set (var_map, (ValaSymbol*) var_symbol, _tmp4_);
		vala_variable_set_single_assignment (var_symbol, TRUE);
	} else {
		vala_variable_set_single_assignment (var_symbol, FALSE);
	}
	if (VALA_IS_LOCAL_VARIABLE (var_symbol)) {
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaLocalVariable* _tmp13_;
		_tmp5_ = vala_variable_get_variable_type (var_symbol);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_data_type_copy (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_local_variable_new (_tmp8_, _tmp10_, NULL, _tmp12_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp13_;
		_vala_code_node_unref0 (_tmp8_);
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaDataType* _tmp18_;
		ValaDataType* _tmp19_;
		ValaSourceReference* _tmp20_;
		ValaSourceReference* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp14_ = vala_symbol_get_name ((ValaSymbol*) var_symbol);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type (var_symbol);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_data_type_copy (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) var_symbol);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_parameter_new (_tmp15_, _tmp19_, _tmp21_);
		_vala_code_node_unref0 (versioned_var);
		versioned_var = (ValaVariable*) _tmp22_;
		_vala_code_node_unref0 (_tmp19_);
	}
	_tmp23_ = variable_stack;
	_tmp24_ = versioned_var;
	vala_collection_add ((ValaCollection*) _tmp23_, _tmp24_);
	result = versioned_var;
	_vala_iterable_unref0 (variable_stack);
	return result;
}


static void
vala_flow_analyzer_real_visit_creation_method (ValaCodeVisitor* base,
                                               ValaCreationMethod* m)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (m != NULL);
	vala_code_visitor_visit_method ((ValaCodeVisitor*) self, (ValaMethod*) m);
}


static void
vala_flow_analyzer_real_visit_property (ValaCodeVisitor* base,
                                        ValaProperty* prop)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (prop != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) prop, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_property_accessor (ValaCodeVisitor* base,
                                                 ValaPropertyAccessor* acc)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (acc != NULL);
	vala_flow_analyzer_visit_subroutine (self, (ValaSubroutine*) acc);
}


static void
vala_flow_analyzer_real_visit_block (ValaCodeVisitor* base,
                                     ValaBlock* b)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (b != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) b, (ValaCodeVisitor*) self);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_flow_analyzer_real_visit_declaration_statement (ValaCodeVisitor* base,
                                                     ValaDeclarationStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	ValaBasicBlock* _tmp16_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp17_;
	ValaSymbol* _tmp18_;
	ValaLocalVariable* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaLocalVariable* _tmp21_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		ValaSymbol* _tmp0_;
		ValaSymbol* _tmp1_;
		_tmp0_ = vala_declaration_statement_get_declaration (stmt);
		_tmp1_ = _tmp0_;
		vala_code_node_set_unreachable ((ValaCodeNode*) _tmp1_, TRUE);
		return;
	}
	_tmp2_ = vala_declaration_statement_get_declaration (stmt);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_symbol_get_used (_tmp3_);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = vala_declaration_statement_get_declaration (stmt);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_declaration_statement_get_declaration (stmt);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_symbol_get_name (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf ("local variable `%s' declared but never used", _tmp13_);
		_tmp15_ = _tmp14_;
		vala_report_warning (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
	}
	_tmp16_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp16_, (ValaCodeNode*) stmt);
	_tmp17_ = vala_declaration_statement_get_declaration (stmt);
	_tmp18_ = _tmp17_;
	_tmp19_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp18_) ? ((ValaLocalVariable*) _tmp18_) : NULL);
	local = _tmp19_;
	_tmp21_ = local;
	if (_tmp21_ != NULL) {
		ValaLocalVariable* _tmp22_;
		ValaExpression* _tmp23_;
		ValaExpression* _tmp24_;
		_tmp22_ = local;
		_tmp23_ = vala_variable_get_initializer ((ValaVariable*) _tmp22_);
		_tmp24_ = _tmp23_;
		_tmp20_ = _tmp24_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		ValaLocalVariable* _tmp25_;
		ValaExpression* _tmp26_;
		ValaExpression* _tmp27_;
		_tmp25_ = local;
		_tmp26_ = vala_variable_get_initializer ((ValaVariable*) _tmp25_);
		_tmp27_ = _tmp26_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp27_, FALSE);
	}
	_vala_code_node_unref0 (local);
}


static void
vala_flow_analyzer_real_visit_local_variable (ValaCodeVisitor* base,
                                              ValaLocalVariable* local)
{
	ValaFlowAnalyzer * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (local != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) local);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) local);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, (ValaCodeVisitor*) self);
	}
}


static void
vala_flow_analyzer_real_visit_expression_statement (ValaCodeVisitor* base,
                                                    ValaExpressionStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, FALSE);
	_tmp1_ = vala_expression_statement_get_expression (stmt);
	_tmp2_ = _tmp1_;
	if (VALA_IS_METHOD_CALL (_tmp2_)) {
		ValaMethodCall* expr = NULL;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaMethodCall* _tmp5_;
		ValaMemberAccess* ma = NULL;
		ValaMethodCall* _tmp6_;
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaMemberAccess* _tmp9_;
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		ValaMemberAccess* _tmp12_;
		_tmp3_ = vala_expression_statement_get_expression (stmt);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
		expr = _tmp5_;
		_tmp6_ = expr;
		_tmp7_ = vala_method_call_get_call (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp8_) ? ((ValaMemberAccess*) _tmp8_) : NULL);
		ma = _tmp9_;
		_tmp12_ = ma;
		if (_tmp12_ != NULL) {
			ValaMemberAccess* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaSymbol* _tmp15_;
			_tmp13_ = ma;
			_tmp14_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ != NULL;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			ValaMemberAccess* _tmp16_;
			ValaSymbol* _tmp17_;
			ValaSymbol* _tmp18_;
			ValaAttribute* _tmp19_;
			ValaAttribute* _tmp20_;
			_tmp16_ = ma;
			_tmp17_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp18_, "NoReturn");
			_tmp20_ = _tmp19_;
			_tmp10_ = _tmp20_ != NULL;
			_vala_code_node_unref0 (_tmp20_);
		} else {
			_tmp10_ = FALSE;
		}
		if (_tmp10_) {
			vala_flow_analyzer_mark_unreachable (self);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (expr);
			return;
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
}


static gboolean
vala_flow_analyzer_always_true (ValaFlowAnalyzer* self,
                                ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static gboolean
vala_flow_analyzer_always_false (ValaFlowAnalyzer* self,
                                 ValaExpression* condition)
{
	gboolean result = FALSE;
	ValaBooleanLiteral* literal = NULL;
	ValaBooleanLiteral* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaBooleanLiteral* _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (condition != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (VALA_IS_BOOLEAN_LITERAL (condition) ? ((ValaBooleanLiteral*) condition) : NULL);
	literal = _tmp0_;
	_tmp2_ = literal;
	if (_tmp2_ != NULL) {
		ValaBooleanLiteral* _tmp3_;
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp3_ = literal;
		_tmp4_ = vala_boolean_literal_get_value (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp1_ = !_tmp5_;
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	_vala_code_node_unref0 (literal);
	return result;
}


static void
vala_flow_analyzer_real_visit_if_statement (ValaCodeVisitor* base,
                                            ValaIfStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaBasicBlock* _tmp6_;
	ValaExpression* _tmp7_;
	ValaExpression* _tmp8_;
	ValaBlock* _tmp12_;
	ValaBlock* _tmp13_;
	ValaBasicBlock* last_true_block = NULL;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	ValaBlock* _tmp21_;
	ValaBlock* _tmp22_;
	ValaBasicBlock* last_false_block = NULL;
	ValaBasicBlock* _tmp25_;
	ValaBasicBlock* _tmp26_;
	gboolean _tmp27_ = FALSE;
	ValaBasicBlock* _tmp28_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_if_statement_get_condition (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_if_statement_get_condition (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = _vala_basic_block_ref0 (_tmp5_);
	last_block = _tmp6_;
	_tmp7_ = vala_if_statement_get_condition (stmt);
	_tmp8_ = _tmp7_;
	if (vala_flow_analyzer_always_false (self, _tmp8_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaBasicBlock* _tmp11_;
		_tmp9_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp9_;
		_tmp10_ = last_block;
		_tmp11_ = self->priv->current_block;
		vala_basic_block_connect (_tmp10_, _tmp11_);
	}
	_tmp12_ = vala_if_statement_get_true_statement (stmt);
	_tmp13_ = _tmp12_;
	vala_code_node_accept ((ValaCodeNode*) _tmp13_, (ValaCodeVisitor*) self);
	_tmp14_ = self->priv->current_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	last_true_block = _tmp15_;
	_tmp16_ = vala_if_statement_get_condition (stmt);
	_tmp17_ = _tmp16_;
	if (vala_flow_analyzer_always_true (self, _tmp17_)) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp18_;
		ValaBasicBlock* _tmp19_;
		ValaBasicBlock* _tmp20_;
		_tmp18_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp18_;
		_tmp19_ = last_block;
		_tmp20_ = self->priv->current_block;
		vala_basic_block_connect (_tmp19_, _tmp20_);
	}
	_tmp21_ = vala_if_statement_get_false_statement (stmt);
	_tmp22_ = _tmp21_;
	if (_tmp22_ != NULL) {
		ValaBlock* _tmp23_;
		ValaBlock* _tmp24_;
		_tmp23_ = vala_if_statement_get_false_statement (stmt);
		_tmp24_ = _tmp23_;
		vala_code_node_accept ((ValaCodeNode*) _tmp24_, (ValaCodeVisitor*) self);
	}
	_tmp25_ = self->priv->current_block;
	_tmp26_ = _vala_basic_block_ref0 (_tmp25_);
	last_false_block = _tmp26_;
	_tmp28_ = last_true_block;
	if (_tmp28_ != NULL) {
		_tmp27_ = TRUE;
	} else {
		ValaBasicBlock* _tmp29_;
		_tmp29_ = last_false_block;
		_tmp27_ = _tmp29_ != NULL;
	}
	if (_tmp27_) {
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		ValaBasicBlock* _tmp34_;
		_tmp30_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp30_;
		_tmp31_ = last_true_block;
		if (_tmp31_ != NULL) {
			ValaBasicBlock* _tmp32_;
			ValaBasicBlock* _tmp33_;
			_tmp32_ = last_true_block;
			_tmp33_ = self->priv->current_block;
			vala_basic_block_connect (_tmp32_, _tmp33_);
		}
		_tmp34_ = last_false_block;
		if (_tmp34_ != NULL) {
			ValaBasicBlock* _tmp35_;
			ValaBasicBlock* _tmp36_;
			_tmp35_ = last_false_block;
			_tmp36_ = self->priv->current_block;
			vala_basic_block_connect (_tmp35_, _tmp36_);
		}
	}
	_vala_basic_block_unref0 (last_false_block);
	_vala_basic_block_unref0 (last_true_block);
	_vala_basic_block_unref0 (last_block);
}


static void
vala_flow_analyzer_real_visit_switch_statement (ValaCodeVisitor* base,
                                                ValaSwitchStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* after_switch_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaList* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaFlowAnalyzerJumpTarget* _tmp3_;
	ValaFlowAnalyzerJumpTarget* _tmp4_;
	ValaBasicBlock* _tmp5_;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaBasicBlock* condition_block = NULL;
	ValaBasicBlock* _tmp8_;
	ValaBasicBlock* _tmp9_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	gboolean has_default_label = FALSE;
	gboolean _tmp43_;
	ValaBasicBlock* _tmp46_;
	ValaList* _tmp47_;
	ValaList* _tmp48_;
	gint _tmp49_;
	gint _tmp50_;
	gboolean _tmp51_;
	ValaList* _tmp54_;
	ValaList* _tmp55_;
	gint _tmp56_;
	gint _tmp57_;
	gpointer _tmp58_;
	ValaFlowAnalyzerJumpTarget* _tmp59_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	after_switch_block = _tmp0_;
	_tmp1_ = self->priv->jump_stack;
	_tmp2_ = after_switch_block;
	_tmp3_ = vala_flow_analyzer_jump_target_new_break_target (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp4_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp4_);
	_tmp5_ = self->priv->current_block;
	_tmp6_ = vala_switch_statement_get_expression (stmt);
	_tmp7_ = _tmp6_;
	vala_basic_block_add_node (_tmp5_, (ValaCodeNode*) _tmp7_);
	_tmp8_ = self->priv->current_block;
	_tmp9_ = _vala_basic_block_ref0 (_tmp8_);
	condition_block = _tmp9_;
	_tmp10_ = vala_switch_statement_get_expression (stmt);
	_tmp11_ = _tmp10_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp11_, FALSE);
	has_default_label = FALSE;
	{
		ValaList* _section_list = NULL;
		ValaList* _tmp12_;
		gint _section_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _section_index = 0;
		_tmp12_ = vala_switch_statement_get_sections (stmt);
		_section_list = _tmp12_;
		_tmp13_ = _section_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_section_size = _tmp15_;
		_section_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			ValaSwitchSection* section = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			ValaBasicBlock* _tmp21_;
			ValaBasicBlock* _tmp22_;
			ValaBasicBlock* _tmp23_;
			ValaSwitchSection* _tmp35_;
			ValaBasicBlock* _tmp36_;
			_section_index = _section_index + 1;
			_tmp16_ = _section_index;
			_tmp17_ = _section_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _section_list;
			_tmp19_ = _section_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			section = (ValaSwitchSection*) _tmp20_;
			_tmp21_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp21_;
			_tmp22_ = condition_block;
			_tmp23_ = self->priv->current_block;
			vala_basic_block_connect (_tmp22_, _tmp23_);
			{
				ValaList* _section_stmt_list = NULL;
				ValaSwitchSection* _tmp24_;
				ValaList* _tmp25_;
				gint _section_stmt_size = 0;
				ValaList* _tmp26_;
				gint _tmp27_;
				gint _tmp28_;
				gint _section_stmt_index = 0;
				_tmp24_ = section;
				_tmp25_ = vala_block_get_statements ((ValaBlock*) _tmp24_);
				_section_stmt_list = _tmp25_;
				_tmp26_ = _section_stmt_list;
				_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
				_tmp28_ = _tmp27_;
				_section_stmt_size = _tmp28_;
				_section_stmt_index = -1;
				while (TRUE) {
					gint _tmp29_;
					gint _tmp30_;
					ValaStatement* section_stmt = NULL;
					ValaList* _tmp31_;
					gint _tmp32_;
					gpointer _tmp33_;
					ValaStatement* _tmp34_;
					_section_stmt_index = _section_stmt_index + 1;
					_tmp29_ = _section_stmt_index;
					_tmp30_ = _section_stmt_size;
					if (!(_tmp29_ < _tmp30_)) {
						break;
					}
					_tmp31_ = _section_stmt_list;
					_tmp32_ = _section_stmt_index;
					_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
					section_stmt = (ValaStatement*) _tmp33_;
					_tmp34_ = section_stmt;
					vala_code_node_accept ((ValaCodeNode*) _tmp34_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (section_stmt);
				}
				_vala_iterable_unref0 (_section_stmt_list);
			}
			_tmp35_ = section;
			if (vala_switch_section_has_default_label (_tmp35_)) {
				has_default_label = TRUE;
			}
			_tmp36_ = self->priv->current_block;
			if (_tmp36_ != NULL) {
				ValaSwitchSection* _tmp37_;
				ValaSourceReference* _tmp38_;
				ValaSourceReference* _tmp39_;
				ValaSwitchSection* _tmp40_;
				ValaBasicBlock* _tmp41_;
				ValaBasicBlock* _tmp42_;
				_tmp37_ = section;
				_tmp38_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp37_);
				_tmp39_ = _tmp38_;
				vala_report_error (_tmp39_, "missing break statement at end of switch section");
				_tmp40_ = section;
				vala_code_node_set_error ((ValaCodeNode*) _tmp40_, TRUE);
				_tmp41_ = self->priv->current_block;
				_tmp42_ = after_switch_block;
				vala_basic_block_connect (_tmp41_, _tmp42_);
			}
			_vala_code_node_unref0 (section);
		}
		_vala_iterable_unref0 (_section_list);
	}
	_tmp43_ = has_default_label;
	if (!_tmp43_) {
		ValaBasicBlock* _tmp44_;
		ValaBasicBlock* _tmp45_;
		_tmp44_ = condition_block;
		_tmp45_ = after_switch_block;
		vala_basic_block_connect (_tmp44_, _tmp45_);
	}
	_tmp46_ = after_switch_block;
	_tmp47_ = vala_basic_block_get_predecessors (_tmp46_);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_collection_get_size ((ValaCollection*) _tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = _tmp50_ > 0;
	_vala_iterable_unref0 (_tmp48_);
	if (_tmp51_) {
		ValaBasicBlock* _tmp52_;
		ValaBasicBlock* _tmp53_;
		_tmp52_ = after_switch_block;
		_tmp53_ = _vala_basic_block_ref0 (_tmp52_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp53_;
	} else {
		vala_flow_analyzer_mark_unreachable (self);
	}
	_tmp54_ = self->priv->jump_stack;
	_tmp55_ = self->priv->jump_stack;
	_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_list_remove_at (_tmp54_, _tmp57_ - 1);
	_tmp59_ = (ValaFlowAnalyzerJumpTarget*) _tmp58_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp59_);
	_vala_basic_block_unref0 (condition_block);
	_vala_basic_block_unref0 (after_switch_block);
}


static void
vala_flow_analyzer_real_visit_loop (ValaCodeVisitor* base,
                                    ValaLoop* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaList* _tmp1_;
	ValaBasicBlock* _tmp2_;
	ValaFlowAnalyzerJumpTarget* _tmp3_;
	ValaFlowAnalyzerJumpTarget* _tmp4_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaFlowAnalyzerJumpTarget* _tmp8_;
	ValaFlowAnalyzerJumpTarget* _tmp9_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaBasicBlock* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaBasicBlock* _tmp13_;
	ValaBasicBlock* _tmp14_;
	ValaBasicBlock* _tmp15_;
	ValaBlock* _tmp16_;
	ValaBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp21_;
	ValaList* _tmp22_;
	ValaList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	gboolean _tmp26_;
	ValaList* _tmp29_;
	ValaList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gpointer _tmp33_;
	ValaFlowAnalyzerJumpTarget* _tmp34_;
	ValaList* _tmp35_;
	ValaList* _tmp36_;
	gint _tmp37_;
	gint _tmp38_;
	gpointer _tmp39_;
	ValaFlowAnalyzerJumpTarget* _tmp40_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = vala_basic_block_new ();
	loop_block = _tmp0_;
	_tmp1_ = self->priv->jump_stack;
	_tmp2_ = loop_block;
	_tmp3_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp2_);
	_tmp4_ = _tmp3_;
	vala_collection_add ((ValaCollection*) _tmp1_, _tmp4_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp4_);
	_tmp5_ = vala_basic_block_new ();
	after_loop_block = _tmp5_;
	_tmp6_ = self->priv->jump_stack;
	_tmp7_ = after_loop_block;
	_tmp8_ = vala_flow_analyzer_jump_target_new_break_target (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp9_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp9_);
	_tmp10_ = self->priv->current_block;
	_tmp11_ = _vala_basic_block_ref0 (_tmp10_);
	last_block = _tmp11_;
	_tmp12_ = last_block;
	_tmp13_ = loop_block;
	vala_basic_block_connect (_tmp12_, _tmp13_);
	_tmp14_ = loop_block;
	_tmp15_ = _vala_basic_block_ref0 (_tmp14_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp15_;
	_tmp16_ = vala_loop_get_body (stmt);
	_tmp17_ = _tmp16_;
	vala_code_node_accept ((ValaCodeNode*) _tmp17_, (ValaCodeVisitor*) self);
	_tmp18_ = self->priv->current_block;
	if (_tmp18_ != NULL) {
		ValaBasicBlock* _tmp19_;
		ValaBasicBlock* _tmp20_;
		_tmp19_ = self->priv->current_block;
		_tmp20_ = loop_block;
		vala_basic_block_connect (_tmp19_, _tmp20_);
	}
	_tmp21_ = after_loop_block;
	_tmp22_ = vala_basic_block_get_predecessors (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_collection_get_size ((ValaCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _tmp25_ == 0;
	_vala_iterable_unref0 (_tmp23_);
	if (_tmp26_) {
		vala_flow_analyzer_mark_unreachable (self);
	} else {
		ValaBasicBlock* _tmp27_;
		ValaBasicBlock* _tmp28_;
		_tmp27_ = after_loop_block;
		_tmp28_ = _vala_basic_block_ref0 (_tmp27_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp28_;
	}
	_tmp29_ = self->priv->jump_stack;
	_tmp30_ = self->priv->jump_stack;
	_tmp31_ = vala_collection_get_size ((ValaCollection*) _tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_list_remove_at (_tmp29_, _tmp32_ - 1);
	_tmp34_ = (ValaFlowAnalyzerJumpTarget*) _tmp33_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp34_);
	_tmp35_ = self->priv->jump_stack;
	_tmp36_ = self->priv->jump_stack;
	_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_list_remove_at (_tmp35_, _tmp38_ - 1);
	_tmp40_ = (ValaFlowAnalyzerJumpTarget*) _tmp39_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp40_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void
vala_flow_analyzer_real_visit_foreach_statement (ValaCodeVisitor* base,
                                                 ValaForeachStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaBasicBlock* loop_block = NULL;
	ValaBasicBlock* _tmp5_;
	ValaList* _tmp6_;
	ValaBasicBlock* _tmp7_;
	ValaFlowAnalyzerJumpTarget* _tmp8_;
	ValaFlowAnalyzerJumpTarget* _tmp9_;
	ValaBasicBlock* after_loop_block = NULL;
	ValaBasicBlock* _tmp10_;
	ValaList* _tmp11_;
	ValaBasicBlock* _tmp12_;
	ValaFlowAnalyzerJumpTarget* _tmp13_;
	ValaFlowAnalyzerJumpTarget* _tmp14_;
	ValaBasicBlock* last_block = NULL;
	ValaBasicBlock* _tmp15_;
	ValaBasicBlock* _tmp16_;
	ValaBasicBlock* _tmp17_;
	ValaBasicBlock* _tmp18_;
	ValaBasicBlock* _tmp19_;
	ValaBasicBlock* _tmp20_;
	ValaBasicBlock* _tmp21_;
	ValaBlock* _tmp22_;
	ValaBlock* _tmp23_;
	ValaBasicBlock* _tmp24_;
	ValaBasicBlock* _tmp27_;
	ValaBasicBlock* _tmp28_;
	ValaBasicBlock* _tmp29_;
	ValaBasicBlock* _tmp32_;
	ValaBasicBlock* _tmp33_;
	ValaList* _tmp34_;
	ValaList* _tmp35_;
	gint _tmp36_;
	gint _tmp37_;
	gpointer _tmp38_;
	ValaFlowAnalyzerJumpTarget* _tmp39_;
	ValaList* _tmp40_;
	ValaList* _tmp41_;
	gint _tmp42_;
	gint _tmp43_;
	gpointer _tmp44_;
	ValaFlowAnalyzerJumpTarget* _tmp45_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = vala_foreach_statement_get_collection (stmt);
	_tmp2_ = _tmp1_;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) _tmp2_);
	_tmp3_ = vala_foreach_statement_get_collection (stmt);
	_tmp4_ = _tmp3_;
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	_tmp5_ = vala_basic_block_new ();
	loop_block = _tmp5_;
	_tmp6_ = self->priv->jump_stack;
	_tmp7_ = loop_block;
	_tmp8_ = vala_flow_analyzer_jump_target_new_continue_target (_tmp7_);
	_tmp9_ = _tmp8_;
	vala_collection_add ((ValaCollection*) _tmp6_, _tmp9_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp9_);
	_tmp10_ = vala_basic_block_new ();
	after_loop_block = _tmp10_;
	_tmp11_ = self->priv->jump_stack;
	_tmp12_ = after_loop_block;
	_tmp13_ = vala_flow_analyzer_jump_target_new_break_target (_tmp12_);
	_tmp14_ = _tmp13_;
	vala_collection_add ((ValaCollection*) _tmp11_, _tmp14_);
	_vala_flow_analyzer_jump_target_unref0 (_tmp14_);
	_tmp15_ = self->priv->current_block;
	_tmp16_ = _vala_basic_block_ref0 (_tmp15_);
	last_block = _tmp16_;
	_tmp17_ = last_block;
	_tmp18_ = loop_block;
	vala_basic_block_connect (_tmp17_, _tmp18_);
	_tmp19_ = loop_block;
	_tmp20_ = _vala_basic_block_ref0 (_tmp19_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp20_;
	_tmp21_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp21_, (ValaCodeNode*) stmt);
	_tmp22_ = vala_foreach_statement_get_body (stmt);
	_tmp23_ = _tmp22_;
	vala_code_node_accept ((ValaCodeNode*) _tmp23_, (ValaCodeVisitor*) self);
	_tmp24_ = self->priv->current_block;
	if (_tmp24_ != NULL) {
		ValaBasicBlock* _tmp25_;
		ValaBasicBlock* _tmp26_;
		_tmp25_ = self->priv->current_block;
		_tmp26_ = loop_block;
		vala_basic_block_connect (_tmp25_, _tmp26_);
	}
	_tmp27_ = last_block;
	_tmp28_ = after_loop_block;
	vala_basic_block_connect (_tmp27_, _tmp28_);
	_tmp29_ = self->priv->current_block;
	if (_tmp29_ != NULL) {
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		_tmp30_ = self->priv->current_block;
		_tmp31_ = after_loop_block;
		vala_basic_block_connect (_tmp30_, _tmp31_);
	}
	_tmp32_ = after_loop_block;
	_tmp33_ = _vala_basic_block_ref0 (_tmp32_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp33_;
	_tmp34_ = self->priv->jump_stack;
	_tmp35_ = self->priv->jump_stack;
	_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = vala_list_remove_at (_tmp34_, _tmp37_ - 1);
	_tmp39_ = (ValaFlowAnalyzerJumpTarget*) _tmp38_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp39_);
	_tmp40_ = self->priv->jump_stack;
	_tmp41_ = self->priv->jump_stack;
	_tmp42_ = vala_collection_get_size ((ValaCollection*) _tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_list_remove_at (_tmp40_, _tmp43_ - 1);
	_tmp45_ = (ValaFlowAnalyzerJumpTarget*) _tmp44_;
	_vala_flow_analyzer_jump_target_unref0 (_tmp45_);
	_vala_basic_block_unref0 (last_block);
	_vala_basic_block_unref0 (after_loop_block);
	_vala_basic_block_unref0 (loop_block);
}


static void
vala_flow_analyzer_real_visit_break_statement (ValaCodeVisitor* base,
                                               ValaBreakStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp28_;
	ValaSourceReference* _tmp29_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaFlowAnalyzerJumpTarget* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = self->priv->jump_stack;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp9_;
				_tmp10_ = jump_target;
				_tmp11_ = vala_flow_analyzer_jump_target_get_is_break_target (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					ValaBasicBlock* _tmp13_;
					ValaFlowAnalyzerJumpTarget* _tmp14_;
					ValaBasicBlock* _tmp15_;
					ValaBasicBlock* _tmp16_;
					_tmp13_ = self->priv->current_block;
					_tmp14_ = jump_target;
					_tmp15_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_basic_block_connect (_tmp13_, _tmp16_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaBasicBlock* _tmp20_;
						ValaFlowAnalyzerJumpTarget* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						_tmp20_ = self->priv->current_block;
						_tmp21_ = jump_target;
						_tmp22_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp21_);
						_tmp23_ = _tmp22_;
						vala_basic_block_connect (_tmp20_, _tmp23_);
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_last_block (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = _vala_basic_block_ref0 (_tmp26_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp27_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp29_ = _tmp28_;
	vala_report_error (_tmp29_, "no enclosing loop or switch statement found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_continue_statement (ValaCodeVisitor* base,
                                                  ValaContinueStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaSourceReference* _tmp28_;
	ValaSourceReference* _tmp29_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	{
		gint i = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->jump_stack;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp7_;
				gint _tmp8_;
				gpointer _tmp9_;
				ValaFlowAnalyzerJumpTarget* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ >= 0)) {
					break;
				}
				_tmp7_ = self->priv->jump_stack;
				_tmp8_ = i;
				_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp9_;
				_tmp10_ = jump_target;
				_tmp11_ = vala_flow_analyzer_jump_target_get_is_continue_target (_tmp10_);
				_tmp12_ = _tmp11_;
				if (_tmp12_) {
					ValaBasicBlock* _tmp13_;
					ValaFlowAnalyzerJumpTarget* _tmp14_;
					ValaBasicBlock* _tmp15_;
					ValaBasicBlock* _tmp16_;
					_tmp13_ = self->priv->current_block;
					_tmp14_ = jump_target;
					_tmp15_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp14_);
					_tmp16_ = _tmp15_;
					vala_basic_block_connect (_tmp13_, _tmp16_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp17_;
					gboolean _tmp18_;
					gboolean _tmp19_;
					_tmp17_ = jump_target;
					_tmp18_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_) {
						ValaBasicBlock* _tmp20_;
						ValaFlowAnalyzerJumpTarget* _tmp21_;
						ValaBasicBlock* _tmp22_;
						ValaBasicBlock* _tmp23_;
						ValaFlowAnalyzerJumpTarget* _tmp24_;
						ValaBasicBlock* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						_tmp20_ = self->priv->current_block;
						_tmp21_ = jump_target;
						_tmp22_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp21_);
						_tmp23_ = _tmp22_;
						vala_basic_block_connect (_tmp20_, _tmp23_);
						_tmp24_ = jump_target;
						_tmp25_ = vala_flow_analyzer_jump_target_get_last_block (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = _vala_basic_block_ref0 (_tmp26_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp27_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp29_ = _tmp28_;
	vala_report_error (_tmp29_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_return_statement (ValaCodeVisitor* base,
                                                ValaReturnStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	_tmp1_ = vala_return_statement_get_return_expression (stmt);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		_tmp3_ = vala_return_statement_get_return_expression (stmt);
		_tmp4_ = _tmp3_;
		vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) _tmp4_, FALSE);
	}
	{
		gint i = 0;
		ValaList* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = self->priv->jump_stack;
		_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
		_tmp7_ = _tmp6_;
		i = _tmp7_ - 1;
		{
			gboolean _tmp8_ = FALSE;
			_tmp8_ = TRUE;
			while (TRUE) {
				gint _tmp10_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp11_;
				gint _tmp12_;
				gpointer _tmp13_;
				ValaFlowAnalyzerJumpTarget* _tmp14_;
				gboolean _tmp15_;
				gboolean _tmp16_;
				if (!_tmp8_) {
					gint _tmp9_;
					_tmp9_ = i;
					i = _tmp9_ - 1;
				}
				_tmp8_ = FALSE;
				_tmp10_ = i;
				if (!(_tmp10_ >= 0)) {
					break;
				}
				_tmp11_ = self->priv->jump_stack;
				_tmp12_ = i;
				_tmp13_ = vala_list_get (_tmp11_, _tmp12_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp13_;
				_tmp14_ = jump_target;
				_tmp15_ = vala_flow_analyzer_jump_target_get_is_return_target (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_) {
					ValaBasicBlock* _tmp17_;
					ValaFlowAnalyzerJumpTarget* _tmp18_;
					ValaBasicBlock* _tmp19_;
					ValaBasicBlock* _tmp20_;
					_tmp17_ = self->priv->current_block;
					_tmp18_ = jump_target;
					_tmp19_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp18_);
					_tmp20_ = _tmp19_;
					vala_basic_block_connect (_tmp17_, _tmp20_);
					vala_flow_analyzer_mark_unreachable (self);
					_vala_flow_analyzer_jump_target_unref0 (jump_target);
					return;
				} else {
					ValaFlowAnalyzerJumpTarget* _tmp21_;
					gboolean _tmp22_;
					gboolean _tmp23_;
					_tmp21_ = jump_target;
					_tmp22_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp21_);
					_tmp23_ = _tmp22_;
					if (_tmp23_) {
						ValaBasicBlock* _tmp24_;
						ValaFlowAnalyzerJumpTarget* _tmp25_;
						ValaBasicBlock* _tmp26_;
						ValaBasicBlock* _tmp27_;
						ValaFlowAnalyzerJumpTarget* _tmp28_;
						ValaBasicBlock* _tmp29_;
						ValaBasicBlock* _tmp30_;
						ValaBasicBlock* _tmp31_;
						_tmp24_ = self->priv->current_block;
						_tmp25_ = jump_target;
						_tmp26_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp25_);
						_tmp27_ = _tmp26_;
						vala_basic_block_connect (_tmp24_, _tmp27_);
						_tmp28_ = jump_target;
						_tmp29_ = vala_flow_analyzer_jump_target_get_last_block (_tmp28_);
						_tmp30_ = _tmp29_;
						_tmp31_ = _vala_basic_block_ref0 (_tmp30_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp31_;
					}
				}
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
	_tmp33_ = _tmp32_;
	vala_report_error (_tmp33_, "no enclosing loop found");
	vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_handle_errors (ValaFlowAnalyzer* self,
                                  ValaCodeNode* node,
                                  gboolean always_fail)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = vala_code_node_get_tree_can_fail (node);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValaBasicBlock* last_block = NULL;
		ValaBasicBlock* _tmp2_;
		ValaBasicBlock* _tmp3_;
		_tmp2_ = self->priv->current_block;
		_tmp3_ = _vala_basic_block_ref0 (_tmp2_);
		last_block = _tmp3_;
		{
			ValaList* _error_data_type_list = NULL;
			ValaList* _tmp4_;
			gint _error_data_type_size = 0;
			ValaList* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			gint _error_data_type_index = 0;
			_tmp4_ = vala_code_node_get_error_types (node);
			_error_data_type_list = _tmp4_;
			_tmp5_ = _error_data_type_list;
			_tmp6_ = vala_collection_get_size ((ValaCollection*) _tmp5_);
			_tmp7_ = _tmp6_;
			_error_data_type_size = _tmp7_;
			_error_data_type_index = -1;
			while (TRUE) {
				gint _tmp8_;
				gint _tmp9_;
				ValaDataType* error_data_type = NULL;
				ValaList* _tmp10_;
				gint _tmp11_;
				gpointer _tmp12_;
				ValaErrorType* error_type = NULL;
				ValaDataType* _tmp13_;
				ValaErrorType* _tmp14_;
				ValaBasicBlock* _tmp15_;
				ValaBasicBlock* _tmp16_;
				_error_data_type_index = _error_data_type_index + 1;
				_tmp8_ = _error_data_type_index;
				_tmp9_ = _error_data_type_size;
				if (!(_tmp8_ < _tmp9_)) {
					break;
				}
				_tmp10_ = _error_data_type_list;
				_tmp11_ = _error_data_type_index;
				_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
				error_data_type = (ValaDataType*) _tmp12_;
				_tmp13_ = error_data_type;
				_tmp14_ = _vala_code_node_ref0 (VALA_IS_ERROR_TYPE (_tmp13_) ? ((ValaErrorType*) _tmp13_) : NULL);
				error_type = _tmp14_;
				_tmp15_ = last_block;
				_tmp16_ = _vala_basic_block_ref0 (_tmp15_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp16_;
				self->priv->unreachable_reported = TRUE;
				{
					gint i = 0;
					ValaList* _tmp17_;
					gint _tmp18_;
					gint _tmp19_;
					_tmp17_ = self->priv->jump_stack;
					_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
					_tmp19_ = _tmp18_;
					i = _tmp19_ - 1;
					{
						gboolean _tmp20_ = FALSE;
						_tmp20_ = TRUE;
						while (TRUE) {
							gint _tmp22_;
							ValaFlowAnalyzerJumpTarget* jump_target = NULL;
							ValaList* _tmp23_;
							gint _tmp24_;
							gpointer _tmp25_;
							ValaFlowAnalyzerJumpTarget* _tmp26_;
							gboolean _tmp27_;
							gboolean _tmp28_;
							if (!_tmp20_) {
								gint _tmp21_;
								_tmp21_ = i;
								i = _tmp21_ - 1;
							}
							_tmp20_ = FALSE;
							_tmp22_ = i;
							if (!(_tmp22_ >= 0)) {
								break;
							}
							_tmp23_ = self->priv->jump_stack;
							_tmp24_ = i;
							_tmp25_ = vala_list_get (_tmp23_, _tmp24_);
							jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp25_;
							_tmp26_ = jump_target;
							_tmp27_ = vala_flow_analyzer_jump_target_get_is_exit_target (_tmp26_);
							_tmp28_ = _tmp27_;
							if (_tmp28_) {
								ValaBasicBlock* _tmp29_;
								ValaFlowAnalyzerJumpTarget* _tmp30_;
								ValaBasicBlock* _tmp31_;
								ValaBasicBlock* _tmp32_;
								_tmp29_ = self->priv->current_block;
								_tmp30_ = jump_target;
								_tmp31_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp30_);
								_tmp32_ = _tmp31_;
								vala_basic_block_connect (_tmp29_, _tmp32_);
								vala_flow_analyzer_mark_unreachable (self);
								_vala_flow_analyzer_jump_target_unref0 (jump_target);
								break;
							} else {
								ValaFlowAnalyzerJumpTarget* _tmp33_;
								gboolean _tmp34_;
								gboolean _tmp35_;
								_tmp33_ = jump_target;
								_tmp34_ = vala_flow_analyzer_jump_target_get_is_error_target (_tmp33_);
								_tmp35_ = _tmp34_;
								if (_tmp35_) {
									gboolean _tmp36_ = FALSE;
									ValaFlowAnalyzerJumpTarget* _tmp37_;
									ValaErrorDomain* _tmp38_;
									ValaErrorDomain* _tmp39_;
									_tmp37_ = jump_target;
									_tmp38_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp37_);
									_tmp39_ = _tmp38_;
									if (_tmp39_ == NULL) {
										_tmp36_ = TRUE;
									} else {
										gboolean _tmp40_ = FALSE;
										ValaFlowAnalyzerJumpTarget* _tmp41_;
										ValaErrorDomain* _tmp42_;
										ValaErrorDomain* _tmp43_;
										ValaErrorType* _tmp44_;
										ValaErrorDomain* _tmp45_;
										ValaErrorDomain* _tmp46_;
										_tmp41_ = jump_target;
										_tmp42_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp41_);
										_tmp43_ = _tmp42_;
										_tmp44_ = error_type;
										_tmp45_ = vala_error_type_get_error_domain (_tmp44_);
										_tmp46_ = _tmp45_;
										if (_tmp43_ == _tmp46_) {
											gboolean _tmp47_ = FALSE;
											ValaFlowAnalyzerJumpTarget* _tmp48_;
											ValaErrorCode* _tmp49_;
											ValaErrorCode* _tmp50_;
											_tmp48_ = jump_target;
											_tmp49_ = vala_flow_analyzer_jump_target_get_error_code (_tmp48_);
											_tmp50_ = _tmp49_;
											if (_tmp50_ == NULL) {
												_tmp47_ = TRUE;
											} else {
												ValaFlowAnalyzerJumpTarget* _tmp51_;
												ValaErrorCode* _tmp52_;
												ValaErrorCode* _tmp53_;
												ValaErrorType* _tmp54_;
												ValaErrorCode* _tmp55_;
												ValaErrorCode* _tmp56_;
												_tmp51_ = jump_target;
												_tmp52_ = vala_flow_analyzer_jump_target_get_error_code (_tmp51_);
												_tmp53_ = _tmp52_;
												_tmp54_ = error_type;
												_tmp55_ = vala_error_type_get_error_code (_tmp54_);
												_tmp56_ = _tmp55_;
												_tmp47_ = _tmp53_ == _tmp56_;
											}
											_tmp40_ = _tmp47_;
										} else {
											_tmp40_ = FALSE;
										}
										_tmp36_ = _tmp40_;
									}
									if (_tmp36_) {
										ValaBasicBlock* _tmp57_;
										ValaFlowAnalyzerJumpTarget* _tmp58_;
										ValaBasicBlock* _tmp59_;
										ValaBasicBlock* _tmp60_;
										_tmp57_ = self->priv->current_block;
										_tmp58_ = jump_target;
										_tmp59_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp58_);
										_tmp60_ = _tmp59_;
										vala_basic_block_connect (_tmp57_, _tmp60_);
										vala_flow_analyzer_mark_unreachable (self);
										_vala_flow_analyzer_jump_target_unref0 (jump_target);
										break;
									} else {
										gboolean _tmp61_ = FALSE;
										ValaErrorType* _tmp62_;
										ValaErrorDomain* _tmp63_;
										ValaErrorDomain* _tmp64_;
										_tmp62_ = error_type;
										_tmp63_ = vala_error_type_get_error_domain (_tmp62_);
										_tmp64_ = _tmp63_;
										if (_tmp64_ == NULL) {
											_tmp61_ = TRUE;
										} else {
											gboolean _tmp65_ = FALSE;
											ValaErrorType* _tmp66_;
											ValaErrorDomain* _tmp67_;
											ValaErrorDomain* _tmp68_;
											ValaFlowAnalyzerJumpTarget* _tmp69_;
											ValaErrorDomain* _tmp70_;
											ValaErrorDomain* _tmp71_;
											_tmp66_ = error_type;
											_tmp67_ = vala_error_type_get_error_domain (_tmp66_);
											_tmp68_ = _tmp67_;
											_tmp69_ = jump_target;
											_tmp70_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp69_);
											_tmp71_ = _tmp70_;
											if (_tmp68_ == _tmp71_) {
												gboolean _tmp72_ = FALSE;
												ValaErrorType* _tmp73_;
												ValaErrorCode* _tmp74_;
												ValaErrorCode* _tmp75_;
												_tmp73_ = error_type;
												_tmp74_ = vala_error_type_get_error_code (_tmp73_);
												_tmp75_ = _tmp74_;
												if (_tmp75_ == NULL) {
													_tmp72_ = TRUE;
												} else {
													ValaErrorType* _tmp76_;
													ValaErrorCode* _tmp77_;
													ValaErrorCode* _tmp78_;
													ValaFlowAnalyzerJumpTarget* _tmp79_;
													ValaErrorCode* _tmp80_;
													ValaErrorCode* _tmp81_;
													_tmp76_ = error_type;
													_tmp77_ = vala_error_type_get_error_code (_tmp76_);
													_tmp78_ = _tmp77_;
													_tmp79_ = jump_target;
													_tmp80_ = vala_flow_analyzer_jump_target_get_error_code (_tmp79_);
													_tmp81_ = _tmp80_;
													_tmp72_ = _tmp78_ == _tmp81_;
												}
												_tmp65_ = _tmp72_;
											} else {
												_tmp65_ = FALSE;
											}
											_tmp61_ = _tmp65_;
										}
										if (_tmp61_) {
											ValaBasicBlock* _tmp82_;
											ValaFlowAnalyzerJumpTarget* _tmp83_;
											ValaBasicBlock* _tmp84_;
											ValaBasicBlock* _tmp85_;
											_tmp82_ = self->priv->current_block;
											_tmp83_ = jump_target;
											_tmp84_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp83_);
											_tmp85_ = _tmp84_;
											vala_basic_block_connect (_tmp82_, _tmp85_);
										}
									}
								} else {
									ValaFlowAnalyzerJumpTarget* _tmp86_;
									gboolean _tmp87_;
									gboolean _tmp88_;
									_tmp86_ = jump_target;
									_tmp87_ = vala_flow_analyzer_jump_target_get_is_finally_clause (_tmp86_);
									_tmp88_ = _tmp87_;
									if (_tmp88_) {
										ValaBasicBlock* _tmp89_;
										ValaFlowAnalyzerJumpTarget* _tmp90_;
										ValaBasicBlock* _tmp91_;
										ValaBasicBlock* _tmp92_;
										ValaFlowAnalyzerJumpTarget* _tmp93_;
										ValaBasicBlock* _tmp94_;
										ValaBasicBlock* _tmp95_;
										ValaBasicBlock* _tmp96_;
										_tmp89_ = self->priv->current_block;
										_tmp90_ = jump_target;
										_tmp91_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp90_);
										_tmp92_ = _tmp91_;
										vala_basic_block_connect (_tmp89_, _tmp92_);
										_tmp93_ = jump_target;
										_tmp94_ = vala_flow_analyzer_jump_target_get_last_block (_tmp93_);
										_tmp95_ = _tmp94_;
										_tmp96_ = _vala_basic_block_ref0 (_tmp95_);
										_vala_basic_block_unref0 (self->priv->current_block);
										self->priv->current_block = _tmp96_;
									}
								}
							}
							_vala_flow_analyzer_jump_target_unref0 (jump_target);
						}
					}
				}
				_vala_code_node_unref0 (error_type);
				_vala_code_node_unref0 (error_data_type);
			}
			_vala_iterable_unref0 (_error_data_type_list);
		}
		if (!always_fail) {
			ValaBasicBlock* _tmp97_;
			ValaBasicBlock* _tmp98_;
			ValaBasicBlock* _tmp99_;
			_tmp97_ = vala_basic_block_new ();
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp97_;
			_tmp98_ = last_block;
			_tmp99_ = self->priv->current_block;
			vala_basic_block_connect (_tmp98_, _tmp99_);
		}
		_vala_basic_block_unref0 (last_block);
	}
}


static void
vala_flow_analyzer_real_visit_yield_statement (ValaCodeVisitor* base,
                                               ValaYieldStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	vala_code_node_accept_children ((ValaCodeNode*) stmt, (ValaCodeVisitor*) self);
}


static void
vala_flow_analyzer_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* _tmp0_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	vala_basic_block_add_node (_tmp0_, (ValaCodeNode*) stmt);
	vala_flow_analyzer_handle_errors (self, (ValaCodeNode*) stmt, TRUE);
}


static void
vala_flow_analyzer_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaFlowAnalyzer * self;
	ValaBasicBlock* before_try_block = NULL;
	ValaBasicBlock* _tmp0_;
	ValaBasicBlock* _tmp1_;
	ValaBasicBlock* after_try_block = NULL;
	ValaBasicBlock* _tmp2_;
	ValaBasicBlock* finally_block = NULL;
	ValaBlock* _tmp3_;
	ValaBlock* _tmp4_;
	gint finally_jump_stack_size = 0;
	ValaList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	ValaList* catch_clauses = NULL;
	ValaList* _tmp37_;
	ValaBasicBlock* _tmp78_;
	ValaBasicBlock* _tmp79_;
	ValaBlock* _tmp80_;
	ValaBlock* _tmp81_;
	ValaBasicBlock* _tmp82_;
	ValaList* catch_stack = NULL;
	GEqualFunc _tmp90_;
	ValaArrayList* _tmp91_;
	ValaBasicBlock* _tmp175_;
	ValaBasicBlock* _tmp182_;
	ValaList* _tmp183_;
	ValaList* _tmp184_;
	gint _tmp185_;
	gint _tmp186_;
	gboolean _tmp187_;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
	_tmp0_ = self->priv->current_block;
	_tmp1_ = _vala_basic_block_ref0 (_tmp0_);
	before_try_block = _tmp1_;
	_tmp2_ = vala_basic_block_new ();
	after_try_block = _tmp2_;
	finally_block = NULL;
	_tmp3_ = vala_try_statement_get_finally_body (stmt);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		ValaBasicBlock* _tmp5_;
		ValaBasicBlock* _tmp6_;
		ValaBasicBlock* _tmp7_;
		ValaBasicBlock* invalid_block = NULL;
		ValaBasicBlock* _tmp8_;
		ValaList* _tmp9_;
		ValaBasicBlock* _tmp10_;
		ValaFlowAnalyzerJumpTarget* _tmp11_;
		ValaFlowAnalyzerJumpTarget* _tmp12_;
		ValaBlock* _tmp13_;
		ValaBlock* _tmp14_;
		ValaBasicBlock* _tmp15_;
		ValaList* _tmp16_;
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gboolean _tmp20_;
		ValaList* _tmp23_;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gpointer _tmp27_;
		ValaFlowAnalyzerJumpTarget* _tmp28_;
		ValaList* _tmp29_;
		ValaBasicBlock* _tmp30_;
		ValaBasicBlock* _tmp31_;
		ValaFlowAnalyzerJumpTarget* _tmp32_;
		ValaFlowAnalyzerJumpTarget* _tmp33_;
		_tmp5_ = vala_basic_block_new ();
		_vala_basic_block_unref0 (finally_block);
		finally_block = _tmp5_;
		_tmp6_ = finally_block;
		_tmp7_ = _vala_basic_block_ref0 (_tmp6_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp7_;
		_tmp8_ = vala_basic_block_new ();
		invalid_block = _tmp8_;
		_tmp9_ = self->priv->jump_stack;
		_tmp10_ = invalid_block;
		_tmp11_ = vala_flow_analyzer_jump_target_new_any_target (_tmp10_);
		_tmp12_ = _tmp11_;
		vala_collection_add ((ValaCollection*) _tmp9_, _tmp12_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp12_);
		_tmp13_ = vala_try_statement_get_finally_body (stmt);
		_tmp14_ = _tmp13_;
		vala_code_node_accept ((ValaCodeNode*) _tmp14_, (ValaCodeVisitor*) self);
		_tmp15_ = invalid_block;
		_tmp16_ = vala_basic_block_get_predecessors (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_ > 0;
		_vala_iterable_unref0 (_tmp17_);
		if (_tmp20_) {
			ValaSourceReference* _tmp21_;
			ValaSourceReference* _tmp22_;
			_tmp21_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
			_tmp22_ = _tmp21_;
			vala_report_error (_tmp22_, "jump out of finally block not permitted");
			vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
			_vala_basic_block_unref0 (invalid_block);
			_vala_basic_block_unref0 (finally_block);
			_vala_basic_block_unref0 (after_try_block);
			_vala_basic_block_unref0 (before_try_block);
			return;
		}
		_tmp23_ = self->priv->jump_stack;
		_tmp24_ = self->priv->jump_stack;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_list_remove_at (_tmp23_, _tmp26_ - 1);
		_tmp28_ = (ValaFlowAnalyzerJumpTarget*) _tmp27_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp28_);
		_tmp29_ = self->priv->jump_stack;
		_tmp30_ = finally_block;
		_tmp31_ = self->priv->current_block;
		_tmp32_ = vala_flow_analyzer_jump_target_new_finally_clause (_tmp30_, _tmp31_);
		_tmp33_ = _tmp32_;
		vala_collection_add ((ValaCollection*) _tmp29_, _tmp33_);
		_vala_flow_analyzer_jump_target_unref0 (_tmp33_);
		_vala_basic_block_unref0 (invalid_block);
	}
	_tmp34_ = self->priv->jump_stack;
	_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	finally_jump_stack_size = _tmp36_;
	_tmp37_ = vala_try_statement_get_catch_clauses (stmt);
	catch_clauses = _tmp37_;
	{
		gint i = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		_tmp38_ = catch_clauses;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		i = _tmp40_ - 1;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gint _tmp43_;
				ValaCatchClause* catch_clause = NULL;
				ValaList* _tmp44_;
				gint _tmp45_;
				gpointer _tmp46_;
				gboolean _tmp47_ = FALSE;
				ValaCatchClause* _tmp48_;
				ValaDataType* _tmp49_;
				ValaDataType* _tmp50_;
				if (!_tmp41_) {
					gint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ - 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = i;
				if (!(_tmp43_ >= 0)) {
					break;
				}
				_tmp44_ = catch_clauses;
				_tmp45_ = i;
				_tmp46_ = vala_list_get (_tmp44_, _tmp45_);
				catch_clause = (ValaCatchClause*) _tmp46_;
				_tmp48_ = catch_clause;
				_tmp49_ = vala_catch_clause_get_error_type (_tmp48_);
				_tmp50_ = _tmp49_;
				if (_tmp50_ != NULL) {
					ValaCatchClause* _tmp51_;
					gboolean _tmp52_;
					gboolean _tmp53_;
					_tmp51_ = catch_clause;
					_tmp52_ = vala_code_node_get_error ((ValaCodeNode*) _tmp51_);
					_tmp53_ = _tmp52_;
					_tmp47_ = !_tmp53_;
				} else {
					_tmp47_ = FALSE;
				}
				if (_tmp47_) {
					ValaErrorType* error_type = NULL;
					ValaCatchClause* _tmp54_;
					ValaDataType* _tmp55_;
					ValaDataType* _tmp56_;
					ValaErrorType* _tmp57_;
					ValaList* _tmp58_;
					ValaBasicBlock* _tmp59_;
					ValaBasicBlock* _tmp60_;
					ValaCatchClause* _tmp61_;
					ValaCatchClause* _tmp62_;
					ValaDataType* _tmp63_;
					ValaDataType* _tmp64_;
					ValaTypeSymbol* _tmp65_;
					ValaTypeSymbol* _tmp66_;
					ValaErrorType* _tmp67_;
					ValaErrorCode* _tmp68_;
					ValaErrorCode* _tmp69_;
					ValaFlowAnalyzerJumpTarget* _tmp70_;
					ValaFlowAnalyzerJumpTarget* _tmp71_;
					_tmp54_ = catch_clause;
					_tmp55_ = vala_catch_clause_get_error_type (_tmp54_);
					_tmp56_ = _tmp55_;
					_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					error_type = _tmp57_;
					_tmp58_ = self->priv->jump_stack;
					_tmp59_ = vala_basic_block_new ();
					_tmp60_ = _tmp59_;
					_tmp61_ = catch_clause;
					_tmp62_ = catch_clause;
					_tmp63_ = vala_catch_clause_get_error_type (_tmp62_);
					_tmp64_ = _tmp63_;
					_tmp65_ = vala_data_type_get_data_type (_tmp64_);
					_tmp66_ = _tmp65_;
					_tmp67_ = error_type;
					_tmp68_ = vala_error_type_get_error_code (_tmp67_);
					_tmp69_ = _tmp68_;
					_tmp70_ = vala_flow_analyzer_jump_target_new_error_target (_tmp60_, _tmp61_, VALA_IS_ERROR_DOMAIN (_tmp66_) ? ((ValaErrorDomain*) _tmp66_) : NULL, _tmp69_, NULL);
					_tmp71_ = _tmp70_;
					vala_collection_add ((ValaCollection*) _tmp58_, _tmp71_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp71_);
					_vala_basic_block_unref0 (_tmp60_);
					_vala_code_node_unref0 (error_type);
				} else {
					ValaList* _tmp72_;
					ValaBasicBlock* _tmp73_;
					ValaBasicBlock* _tmp74_;
					ValaCatchClause* _tmp75_;
					ValaFlowAnalyzerJumpTarget* _tmp76_;
					ValaFlowAnalyzerJumpTarget* _tmp77_;
					_tmp72_ = self->priv->jump_stack;
					_tmp73_ = vala_basic_block_new ();
					_tmp74_ = _tmp73_;
					_tmp75_ = catch_clause;
					_tmp76_ = vala_flow_analyzer_jump_target_new_error_target (_tmp74_, _tmp75_, NULL, NULL, NULL);
					_tmp77_ = _tmp76_;
					vala_collection_add ((ValaCollection*) _tmp72_, _tmp77_);
					_vala_flow_analyzer_jump_target_unref0 (_tmp77_);
					_vala_basic_block_unref0 (_tmp74_);
				}
				_vala_code_node_unref0 (catch_clause);
			}
		}
	}
	_tmp78_ = before_try_block;
	_tmp79_ = _vala_basic_block_ref0 (_tmp78_);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = _tmp79_;
	_tmp80_ = vala_try_statement_get_body (stmt);
	_tmp81_ = _tmp80_;
	vala_code_node_accept ((ValaCodeNode*) _tmp81_, (ValaCodeVisitor*) self);
	_tmp82_ = self->priv->current_block;
	if (_tmp82_ != NULL) {
		ValaBasicBlock* _tmp83_;
		ValaBasicBlock* _tmp88_;
		ValaBasicBlock* _tmp89_;
		_tmp83_ = finally_block;
		if (_tmp83_ != NULL) {
			ValaBasicBlock* _tmp84_;
			ValaBasicBlock* _tmp85_;
			ValaBasicBlock* _tmp86_;
			ValaBasicBlock* _tmp87_;
			_tmp84_ = self->priv->current_block;
			_tmp85_ = finally_block;
			vala_basic_block_connect (_tmp84_, _tmp85_);
			_tmp86_ = finally_block;
			_tmp87_ = _vala_basic_block_ref0 (_tmp86_);
			_vala_basic_block_unref0 (self->priv->current_block);
			self->priv->current_block = _tmp87_;
		}
		_tmp88_ = self->priv->current_block;
		_tmp89_ = after_try_block;
		vala_basic_block_connect (_tmp88_, _tmp89_);
	}
	_tmp90_ = g_direct_equal;
	_tmp91_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp90_);
	catch_stack = (ValaList*) _tmp91_;
	{
		gint i = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		_tmp92_ = self->priv->jump_stack;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		i = _tmp94_ - 1;
		{
			gboolean _tmp95_ = FALSE;
			_tmp95_ = TRUE;
			while (TRUE) {
				gint _tmp97_;
				gint _tmp98_;
				ValaFlowAnalyzerJumpTarget* jump_target = NULL;
				ValaList* _tmp99_;
				gint _tmp100_;
				gpointer _tmp101_;
				ValaList* _tmp102_;
				ValaFlowAnalyzerJumpTarget* _tmp103_;
				if (!_tmp95_) {
					gint _tmp96_;
					_tmp96_ = i;
					i = _tmp96_ - 1;
				}
				_tmp95_ = FALSE;
				_tmp97_ = i;
				_tmp98_ = finally_jump_stack_size;
				if (!(_tmp97_ >= _tmp98_)) {
					break;
				}
				_tmp99_ = self->priv->jump_stack;
				_tmp100_ = i;
				_tmp101_ = vala_list_remove_at (_tmp99_, _tmp100_);
				jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp101_;
				_tmp102_ = catch_stack;
				_tmp103_ = jump_target;
				vala_collection_add ((ValaCollection*) _tmp102_, _tmp103_);
				_vala_flow_analyzer_jump_target_unref0 (jump_target);
			}
		}
	}
	{
		ValaList* _jump_target_list = NULL;
		ValaList* _tmp104_;
		ValaList* _tmp105_;
		gint _jump_target_size = 0;
		ValaList* _tmp106_;
		gint _tmp107_;
		gint _tmp108_;
		gint _jump_target_index = 0;
		_tmp104_ = catch_stack;
		_tmp105_ = _vala_iterable_ref0 (_tmp104_);
		_jump_target_list = _tmp105_;
		_tmp106_ = _jump_target_list;
		_tmp107_ = vala_collection_get_size ((ValaCollection*) _tmp106_);
		_tmp108_ = _tmp107_;
		_jump_target_size = _tmp108_;
		_jump_target_index = -1;
		while (TRUE) {
			gint _tmp109_;
			gint _tmp110_;
			ValaFlowAnalyzerJumpTarget* jump_target = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaFlowAnalyzerJumpTarget* _tmp141_;
			ValaBasicBlock* _tmp142_;
			ValaBasicBlock* _tmp143_;
			ValaList* _tmp144_;
			ValaList* _tmp145_;
			gint _tmp146_;
			gint _tmp147_;
			gboolean _tmp148_;
			_jump_target_index = _jump_target_index + 1;
			_tmp109_ = _jump_target_index;
			_tmp110_ = _jump_target_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _jump_target_list;
			_tmp112_ = _jump_target_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			jump_target = (ValaFlowAnalyzerJumpTarget*) _tmp113_;
			{
				ValaList* _prev_target_list = NULL;
				ValaList* _tmp114_;
				ValaList* _tmp115_;
				gint _prev_target_size = 0;
				ValaList* _tmp116_;
				gint _tmp117_;
				gint _tmp118_;
				gint _prev_target_index = 0;
				_tmp114_ = catch_stack;
				_tmp115_ = _vala_iterable_ref0 (_tmp114_);
				_prev_target_list = _tmp115_;
				_tmp116_ = _prev_target_list;
				_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
				_tmp118_ = _tmp117_;
				_prev_target_size = _tmp118_;
				_prev_target_index = -1;
				while (TRUE) {
					gint _tmp119_;
					gint _tmp120_;
					ValaFlowAnalyzerJumpTarget* prev_target = NULL;
					ValaList* _tmp121_;
					gint _tmp122_;
					gpointer _tmp123_;
					ValaFlowAnalyzerJumpTarget* _tmp124_;
					ValaFlowAnalyzerJumpTarget* _tmp125_;
					gboolean _tmp126_ = FALSE;
					ValaFlowAnalyzerJumpTarget* _tmp127_;
					ValaErrorDomain* _tmp128_;
					ValaErrorDomain* _tmp129_;
					ValaFlowAnalyzerJumpTarget* _tmp130_;
					ValaErrorDomain* _tmp131_;
					ValaErrorDomain* _tmp132_;
					_prev_target_index = _prev_target_index + 1;
					_tmp119_ = _prev_target_index;
					_tmp120_ = _prev_target_size;
					if (!(_tmp119_ < _tmp120_)) {
						break;
					}
					_tmp121_ = _prev_target_list;
					_tmp122_ = _prev_target_index;
					_tmp123_ = vala_list_get (_tmp121_, _tmp122_);
					prev_target = (ValaFlowAnalyzerJumpTarget*) _tmp123_;
					_tmp124_ = prev_target;
					_tmp125_ = jump_target;
					if (_tmp124_ == _tmp125_) {
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						break;
					}
					_tmp127_ = prev_target;
					_tmp128_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp127_);
					_tmp129_ = _tmp128_;
					_tmp130_ = jump_target;
					_tmp131_ = vala_flow_analyzer_jump_target_get_error_domain (_tmp130_);
					_tmp132_ = _tmp131_;
					if (_tmp129_ == _tmp132_) {
						ValaFlowAnalyzerJumpTarget* _tmp133_;
						ValaErrorCode* _tmp134_;
						ValaErrorCode* _tmp135_;
						ValaFlowAnalyzerJumpTarget* _tmp136_;
						ValaErrorCode* _tmp137_;
						ValaErrorCode* _tmp138_;
						_tmp133_ = prev_target;
						_tmp134_ = vala_flow_analyzer_jump_target_get_error_code (_tmp133_);
						_tmp135_ = _tmp134_;
						_tmp136_ = jump_target;
						_tmp137_ = vala_flow_analyzer_jump_target_get_error_code (_tmp136_);
						_tmp138_ = _tmp137_;
						_tmp126_ = _tmp135_ == _tmp138_;
					} else {
						_tmp126_ = FALSE;
					}
					if (_tmp126_) {
						ValaSourceReference* _tmp139_;
						ValaSourceReference* _tmp140_;
						_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) stmt);
						_tmp140_ = _tmp139_;
						vala_report_error (_tmp140_, "double catch clause of same error detected");
						vala_code_node_set_error ((ValaCodeNode*) stmt, TRUE);
						_vala_flow_analyzer_jump_target_unref0 (prev_target);
						_vala_iterable_unref0 (_prev_target_list);
						_vala_flow_analyzer_jump_target_unref0 (jump_target);
						_vala_iterable_unref0 (_jump_target_list);
						_vala_iterable_unref0 (catch_stack);
						_vala_iterable_unref0 (catch_clauses);
						_vala_basic_block_unref0 (finally_block);
						_vala_basic_block_unref0 (after_try_block);
						_vala_basic_block_unref0 (before_try_block);
						return;
					}
					_vala_flow_analyzer_jump_target_unref0 (prev_target);
				}
				_vala_iterable_unref0 (_prev_target_list);
			}
			_tmp141_ = jump_target;
			_tmp142_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = vala_basic_block_get_predecessors (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = vala_collection_get_size ((ValaCollection*) _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = _tmp147_ == 0;
			_vala_iterable_unref0 (_tmp145_);
			if (_tmp148_) {
				ValaFlowAnalyzerJumpTarget* _tmp149_;
				ValaCatchClause* _tmp150_;
				ValaCatchClause* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaSourceReference* _tmp153_;
				_tmp149_ = jump_target;
				_tmp150_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp149_);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp151_);
				_tmp153_ = _tmp152_;
				vala_report_warning (_tmp153_, "unreachable catch clause detected");
			} else {
				ValaFlowAnalyzerJumpTarget* _tmp154_;
				ValaBasicBlock* _tmp155_;
				ValaBasicBlock* _tmp156_;
				ValaBasicBlock* _tmp157_;
				ValaBasicBlock* _tmp158_;
				ValaFlowAnalyzerJumpTarget* _tmp159_;
				ValaCatchClause* _tmp160_;
				ValaCatchClause* _tmp161_;
				ValaFlowAnalyzerJumpTarget* _tmp162_;
				ValaCatchClause* _tmp163_;
				ValaCatchClause* _tmp164_;
				ValaBlock* _tmp165_;
				ValaBlock* _tmp166_;
				ValaBasicBlock* _tmp167_;
				_tmp154_ = jump_target;
				_tmp155_ = vala_flow_analyzer_jump_target_get_basic_block (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = _vala_basic_block_ref0 (_tmp156_);
				_vala_basic_block_unref0 (self->priv->current_block);
				self->priv->current_block = _tmp157_;
				_tmp158_ = self->priv->current_block;
				_tmp159_ = jump_target;
				_tmp160_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp159_);
				_tmp161_ = _tmp160_;
				vala_basic_block_add_node (_tmp158_, (ValaCodeNode*) _tmp161_);
				_tmp162_ = jump_target;
				_tmp163_ = vala_flow_analyzer_jump_target_get_catch_clause (_tmp162_);
				_tmp164_ = _tmp163_;
				_tmp165_ = vala_catch_clause_get_body (_tmp164_);
				_tmp166_ = _tmp165_;
				vala_code_node_accept ((ValaCodeNode*) _tmp166_, (ValaCodeVisitor*) self);
				_tmp167_ = self->priv->current_block;
				if (_tmp167_ != NULL) {
					ValaBasicBlock* _tmp168_;
					ValaBasicBlock* _tmp173_;
					ValaBasicBlock* _tmp174_;
					_tmp168_ = finally_block;
					if (_tmp168_ != NULL) {
						ValaBasicBlock* _tmp169_;
						ValaBasicBlock* _tmp170_;
						ValaBasicBlock* _tmp171_;
						ValaBasicBlock* _tmp172_;
						_tmp169_ = self->priv->current_block;
						_tmp170_ = finally_block;
						vala_basic_block_connect (_tmp169_, _tmp170_);
						_tmp171_ = finally_block;
						_tmp172_ = _vala_basic_block_ref0 (_tmp171_);
						_vala_basic_block_unref0 (self->priv->current_block);
						self->priv->current_block = _tmp172_;
					}
					_tmp173_ = self->priv->current_block;
					_tmp174_ = after_try_block;
					vala_basic_block_connect (_tmp173_, _tmp174_);
				}
			}
			_vala_flow_analyzer_jump_target_unref0 (jump_target);
		}
		_vala_iterable_unref0 (_jump_target_list);
	}
	_tmp175_ = finally_block;
	if (_tmp175_ != NULL) {
		ValaList* _tmp176_;
		ValaList* _tmp177_;
		gint _tmp178_;
		gint _tmp179_;
		gpointer _tmp180_;
		ValaFlowAnalyzerJumpTarget* _tmp181_;
		_tmp176_ = self->priv->jump_stack;
		_tmp177_ = self->priv->jump_stack;
		_tmp178_ = vala_collection_get_size ((ValaCollection*) _tmp177_);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_list_remove_at (_tmp176_, _tmp179_ - 1);
		_tmp181_ = (ValaFlowAnalyzerJumpTarget*) _tmp180_;
		_vala_flow_analyzer_jump_target_unref0 (_tmp181_);
	}
	_tmp182_ = after_try_block;
	_tmp183_ = vala_basic_block_get_predecessors (_tmp182_);
	_tmp184_ = _tmp183_;
	_tmp185_ = vala_collection_get_size ((ValaCollection*) _tmp184_);
	_tmp186_ = _tmp185_;
	_tmp187_ = _tmp186_ > 0;
	_vala_iterable_unref0 (_tmp184_);
	if (_tmp187_) {
		ValaBasicBlock* _tmp188_;
		ValaBasicBlock* _tmp189_;
		_tmp188_ = after_try_block;
		_tmp189_ = _vala_basic_block_ref0 (_tmp188_);
		_vala_basic_block_unref0 (self->priv->current_block);
		self->priv->current_block = _tmp189_;
	} else {
		vala_try_statement_set_after_try_block_reachable (stmt, FALSE);
		vala_flow_analyzer_mark_unreachable (self);
	}
	_vala_iterable_unref0 (catch_stack);
	_vala_iterable_unref0 (catch_clauses);
	_vala_basic_block_unref0 (finally_block);
	_vala_basic_block_unref0 (after_try_block);
	_vala_basic_block_unref0 (before_try_block);
}


static void
vala_flow_analyzer_real_visit_lock_statement (ValaCodeVisitor* base,
                                              ValaLockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}


static void
vala_flow_analyzer_real_visit_unlock_statement (ValaCodeVisitor* base,
                                                ValaUnlockStatement* stmt)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (stmt != NULL);
	if (vala_flow_analyzer_unreachable (self, (ValaCodeNode*) stmt)) {
		return;
	}
}


static void
vala_flow_analyzer_real_visit_expression (ValaCodeVisitor* base,
                                          ValaExpression* expr)
{
	ValaFlowAnalyzer * self;
	self = (ValaFlowAnalyzer*) base;
	g_return_if_fail (expr != NULL);
	if (!VALA_IS_LAMBDA_EXPRESSION (expr)) {
		vala_code_node_accept_children ((ValaCodeNode*) expr, (ValaCodeVisitor*) self);
	}
}


static gboolean
vala_flow_analyzer_unreachable (ValaFlowAnalyzer* self,
                                ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = self->priv->current_block;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		vala_code_node_set_unreachable (node, TRUE);
		_tmp1_ = self->priv->unreachable_reported;
		if (!_tmp1_) {
			ValaSourceReference* _tmp2_;
			ValaSourceReference* _tmp3_;
			_tmp2_ = vala_code_node_get_source_reference (node);
			_tmp3_ = _tmp2_;
			vala_report_warning (_tmp3_, "unreachable code detected");
			self->priv->unreachable_reported = TRUE;
		}
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static void
vala_flow_analyzer_mark_unreachable (ValaFlowAnalyzer* self)
{
	g_return_if_fail (self != NULL);
	_vala_basic_block_unref0 (self->priv->current_block);
	self->priv->current_block = NULL;
	self->priv->unreachable_reported = FALSE;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_break_target (GType object_type,
                                                       ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_break_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_break_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_continue_target (GType object_type,
                                                          ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_continue_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_continue_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_return_target (GType object_type,
                                                        ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_return_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_return_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_exit_target (GType object_type,
                                                      ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_exit_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_exit_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_error_target (GType object_type,
                                                       ValaBasicBlock* basic_block,
                                                       ValaCatchClause* catch_clause,
                                                       ValaErrorDomain* error_domain,
                                                       ValaErrorCode* error_code,
                                                       ValaClass* error_class)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (catch_clause != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_catch_clause (self, catch_clause);
	vala_flow_analyzer_jump_target_set_error_domain (self, error_domain);
	vala_flow_analyzer_jump_target_set_error_code (self, error_code);
	vala_flow_analyzer_jump_target_set_error_class (self, error_class);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_error_target (ValaBasicBlock* basic_block,
                                                 ValaCatchClause* catch_clause,
                                                 ValaErrorDomain* error_domain,
                                                 ValaErrorCode* error_code,
                                                 ValaClass* error_class)
{
	return vala_flow_analyzer_jump_target_construct_error_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, catch_clause, error_domain, error_code, error_class);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_any_target (GType object_type,
                                                     ValaBasicBlock* basic_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_is_break_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_continue_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_return_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_exit_target (self, TRUE);
	vala_flow_analyzer_jump_target_set_is_error_target (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_any_target (ValaBasicBlock* basic_block)
{
	return vala_flow_analyzer_jump_target_construct_any_target (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct_finally_clause (GType object_type,
                                                         ValaBasicBlock* basic_block,
                                                         ValaBasicBlock* last_block)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	g_return_val_if_fail (basic_block != NULL, NULL);
	g_return_val_if_fail (last_block != NULL, NULL);
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	vala_flow_analyzer_jump_target_set_basic_block (self, basic_block);
	vala_flow_analyzer_jump_target_set_last_block (self, last_block);
	vala_flow_analyzer_jump_target_set_is_finally_clause (self, TRUE);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new_finally_clause (ValaBasicBlock* basic_block,
                                                   ValaBasicBlock* last_block)
{
	return vala_flow_analyzer_jump_target_construct_finally_clause (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, basic_block, last_block);
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_construct (GType object_type)
{
	ValaFlowAnalyzerJumpTarget* self = NULL;
	self = (ValaFlowAnalyzerJumpTarget*) g_type_create_instance (object_type);
	return self;
}


static ValaFlowAnalyzerJumpTarget*
vala_flow_analyzer_jump_target_new (void)
{
	return vala_flow_analyzer_jump_target_construct (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET);
}


static gboolean
vala_flow_analyzer_jump_target_get_is_break_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_break_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_break_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_break_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_continue_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_continue_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_continue_target (ValaFlowAnalyzerJumpTarget* self,
                                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_continue_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_return_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_return_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_return_target (ValaFlowAnalyzerJumpTarget* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_return_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_exit_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_exit_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_exit_target (ValaFlowAnalyzerJumpTarget* self,
                                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_exit_target = value;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_error_target (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_error_target;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_error_target (ValaFlowAnalyzerJumpTarget* self,
                                                    gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_error_target = value;
}


static ValaErrorDomain*
vala_flow_analyzer_jump_target_get_error_domain (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorDomain* result;
	ValaErrorDomain* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_domain;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_domain (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaErrorDomain* value)
{
	ValaErrorDomain* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_domain);
	self->priv->_error_domain = _tmp0_;
}


static ValaErrorCode*
vala_flow_analyzer_jump_target_get_error_code (ValaFlowAnalyzerJumpTarget* self)
{
	ValaErrorCode* result;
	ValaErrorCode* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_code;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_code (ValaFlowAnalyzerJumpTarget* self,
                                               ValaErrorCode* value)
{
	ValaErrorCode* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_code);
	self->priv->_error_code = _tmp0_;
}


static ValaClass*
vala_flow_analyzer_jump_target_get_error_class (ValaFlowAnalyzerJumpTarget* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_error_class;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_error_class (ValaFlowAnalyzerJumpTarget* self,
                                                ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_error_class);
	self->priv->_error_class = _tmp0_;
}


static gboolean
vala_flow_analyzer_jump_target_get_is_finally_clause (ValaFlowAnalyzerJumpTarget* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_finally_clause;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_is_finally_clause (ValaFlowAnalyzerJumpTarget* self,
                                                      gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_finally_clause = value;
}


static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_basic_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_basic_block;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_basic_block (ValaFlowAnalyzerJumpTarget* self,
                                                ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	self->priv->_basic_block = _tmp0_;
}


static ValaBasicBlock*
vala_flow_analyzer_jump_target_get_last_block (ValaFlowAnalyzerJumpTarget* self)
{
	ValaBasicBlock* result;
	ValaBasicBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_last_block;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_last_block (ValaFlowAnalyzerJumpTarget* self,
                                               ValaBasicBlock* value)
{
	ValaBasicBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_basic_block_ref0 (value);
	_vala_basic_block_unref0 (self->priv->_last_block);
	self->priv->_last_block = _tmp0_;
}


static ValaCatchClause*
vala_flow_analyzer_jump_target_get_catch_clause (ValaFlowAnalyzerJumpTarget* self)
{
	ValaCatchClause* result;
	ValaCatchClause* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_catch_clause;
	result = _tmp0_;
	return result;
}


static void
vala_flow_analyzer_jump_target_set_catch_clause (ValaFlowAnalyzerJumpTarget* self,
                                                 ValaCatchClause* value)
{
	ValaCatchClause* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_catch_clause);
	self->priv->_catch_clause = _tmp0_;
}


static void
vala_flow_analyzer_value_jump_target_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_flow_analyzer_value_jump_target_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_flow_analyzer_jump_target_unref (value->data[0].v_pointer);
	}
}


static void
vala_flow_analyzer_value_jump_target_copy_value (const GValue* src_value,
                                                 GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_flow_analyzer_value_jump_target_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_flow_analyzer_value_jump_target_collect_value (GValue* value,
                                                    guint n_collect_values,
                                                    GTypeCValue* collect_values,
                                                    guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaFlowAnalyzerJumpTarget * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_flow_analyzer_jump_target_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_flow_analyzer_value_jump_target_lcopy_value (const GValue* value,
                                                  guint n_collect_values,
                                                  GTypeCValue* collect_values,
                                                  guint collect_flags)
{
	ValaFlowAnalyzerJumpTarget ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	}
	return NULL;
}


static GParamSpec*
vala_flow_analyzer_param_spec_jump_target (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags)
{
	ValaFlowAnalyzerParamSpecJumpTarget* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


static gpointer
vala_flow_analyzer_value_get_jump_target (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET), NULL);
	return value->data[0].v_pointer;
}


static void
vala_flow_analyzer_value_set_jump_target (GValue* value,
                                          gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_flow_analyzer_jump_target_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void
vala_flow_analyzer_value_take_jump_target (GValue* value,
                                           gpointer v_object)
{
	ValaFlowAnalyzerJumpTarget * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_flow_analyzer_jump_target_unref (old);
	}
}


static void
vala_flow_analyzer_jump_target_class_init (ValaFlowAnalyzerJumpTargetClass * klass)
{
	vala_flow_analyzer_jump_target_parent_class = g_type_class_peek_parent (klass);
	((ValaFlowAnalyzerJumpTargetClass *) klass)->finalize = vala_flow_analyzer_jump_target_finalize;
	g_type_class_add_private (klass, sizeof (ValaFlowAnalyzerJumpTargetPrivate));
}


static void
vala_flow_analyzer_jump_target_instance_init (ValaFlowAnalyzerJumpTarget * self)
{
	self->priv = VALA_FLOW_ANALYZER_JUMP_TARGET_GET_PRIVATE (self);
	self->ref_count = 1;
}


static void
vala_flow_analyzer_jump_target_finalize (ValaFlowAnalyzerJumpTarget * obj)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, ValaFlowAnalyzerJumpTarget);
	g_signal_handlers_destroy (self);
	_vala_code_node_unref0 (self->priv->_error_domain);
	_vala_code_node_unref0 (self->priv->_error_code);
	_vala_code_node_unref0 (self->priv->_error_class);
	_vala_basic_block_unref0 (self->priv->_basic_block);
	_vala_basic_block_unref0 (self->priv->_last_block);
	_vala_code_node_unref0 (self->priv->_catch_clause);
}


static GType
vala_flow_analyzer_jump_target_get_type (void)
{
	static volatile gsize vala_flow_analyzer_jump_target_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_jump_target_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_flow_analyzer_value_jump_target_init, vala_flow_analyzer_value_jump_target_free_value, vala_flow_analyzer_value_jump_target_copy_value, vala_flow_analyzer_value_jump_target_peek_pointer, "p", vala_flow_analyzer_value_jump_target_collect_value, "p", vala_flow_analyzer_value_jump_target_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerJumpTargetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_jump_target_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzerJumpTarget), 0, (GInstanceInitFunc) vala_flow_analyzer_jump_target_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_flow_analyzer_jump_target_type_id;
		vala_flow_analyzer_jump_target_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaFlowAnalyzerJumpTarget", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_flow_analyzer_jump_target_type_id__volatile, vala_flow_analyzer_jump_target_type_id);
	}
	return vala_flow_analyzer_jump_target_type_id__volatile;
}


static gpointer
vala_flow_analyzer_jump_target_ref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


static void
vala_flow_analyzer_jump_target_unref (gpointer instance)
{
	ValaFlowAnalyzerJumpTarget * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_FLOW_ANALYZER_JUMP_TARGET_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
vala_flow_analyzer_class_init (ValaFlowAnalyzerClass * klass)
{
	vala_flow_analyzer_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_flow_analyzer_finalize;
	g_type_class_add_private (klass, sizeof (ValaFlowAnalyzerPrivate));
	((ValaCodeVisitorClass *) klass)->visit_source_file = (void (*) (ValaCodeVisitor*, ValaSourceFile*)) vala_flow_analyzer_real_visit_source_file;
	((ValaCodeVisitorClass *) klass)->visit_class = (void (*) (ValaCodeVisitor*, ValaClass*)) vala_flow_analyzer_real_visit_class;
	((ValaCodeVisitorClass *) klass)->visit_struct = (void (*) (ValaCodeVisitor*, ValaStruct*)) vala_flow_analyzer_real_visit_struct;
	((ValaCodeVisitorClass *) klass)->visit_interface = (void (*) (ValaCodeVisitor*, ValaInterface*)) vala_flow_analyzer_real_visit_interface;
	((ValaCodeVisitorClass *) klass)->visit_enum = (void (*) (ValaCodeVisitor*, ValaEnum*)) vala_flow_analyzer_real_visit_enum;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_flow_analyzer_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_field = (void (*) (ValaCodeVisitor*, ValaField*)) vala_flow_analyzer_real_visit_field;
	((ValaCodeVisitorClass *) klass)->visit_lambda_expression = (void (*) (ValaCodeVisitor*, ValaLambdaExpression*)) vala_flow_analyzer_real_visit_lambda_expression;
	((ValaCodeVisitorClass *) klass)->visit_method = (void (*) (ValaCodeVisitor*, ValaMethod*)) vala_flow_analyzer_real_visit_method;
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_flow_analyzer_real_visit_signal;
	((ValaCodeVisitorClass *) klass)->visit_creation_method = (void (*) (ValaCodeVisitor*, ValaCreationMethod*)) vala_flow_analyzer_real_visit_creation_method;
	((ValaCodeVisitorClass *) klass)->visit_property = (void (*) (ValaCodeVisitor*, ValaProperty*)) vala_flow_analyzer_real_visit_property;
	((ValaCodeVisitorClass *) klass)->visit_property_accessor = (void (*) (ValaCodeVisitor*, ValaPropertyAccessor*)) vala_flow_analyzer_real_visit_property_accessor;
	((ValaCodeVisitorClass *) klass)->visit_block = (void (*) (ValaCodeVisitor*, ValaBlock*)) vala_flow_analyzer_real_visit_block;
	((ValaCodeVisitorClass *) klass)->visit_declaration_statement = (void (*) (ValaCodeVisitor*, ValaDeclarationStatement*)) vala_flow_analyzer_real_visit_declaration_statement;
	((ValaCodeVisitorClass *) klass)->visit_local_variable = (void (*) (ValaCodeVisitor*, ValaLocalVariable*)) vala_flow_analyzer_real_visit_local_variable;
	((ValaCodeVisitorClass *) klass)->visit_expression_statement = (void (*) (ValaCodeVisitor*, ValaExpressionStatement*)) vala_flow_analyzer_real_visit_expression_statement;
	((ValaCodeVisitorClass *) klass)->visit_if_statement = (void (*) (ValaCodeVisitor*, ValaIfStatement*)) vala_flow_analyzer_real_visit_if_statement;
	((ValaCodeVisitorClass *) klass)->visit_switch_statement = (void (*) (ValaCodeVisitor*, ValaSwitchStatement*)) vala_flow_analyzer_real_visit_switch_statement;
	((ValaCodeVisitorClass *) klass)->visit_loop = (void (*) (ValaCodeVisitor*, ValaLoop*)) vala_flow_analyzer_real_visit_loop;
	((ValaCodeVisitorClass *) klass)->visit_foreach_statement = (void (*) (ValaCodeVisitor*, ValaForeachStatement*)) vala_flow_analyzer_real_visit_foreach_statement;
	((ValaCodeVisitorClass *) klass)->visit_break_statement = (void (*) (ValaCodeVisitor*, ValaBreakStatement*)) vala_flow_analyzer_real_visit_break_statement;
	((ValaCodeVisitorClass *) klass)->visit_continue_statement = (void (*) (ValaCodeVisitor*, ValaContinueStatement*)) vala_flow_analyzer_real_visit_continue_statement;
	((ValaCodeVisitorClass *) klass)->visit_return_statement = (void (*) (ValaCodeVisitor*, ValaReturnStatement*)) vala_flow_analyzer_real_visit_return_statement;
	((ValaCodeVisitorClass *) klass)->visit_yield_statement = (void (*) (ValaCodeVisitor*, ValaYieldStatement*)) vala_flow_analyzer_real_visit_yield_statement;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_flow_analyzer_real_visit_throw_statement;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_flow_analyzer_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_lock_statement = (void (*) (ValaCodeVisitor*, ValaLockStatement*)) vala_flow_analyzer_real_visit_lock_statement;
	((ValaCodeVisitorClass *) klass)->visit_unlock_statement = (void (*) (ValaCodeVisitor*, ValaUnlockStatement*)) vala_flow_analyzer_real_visit_unlock_statement;
	((ValaCodeVisitorClass *) klass)->visit_expression = (void (*) (ValaCodeVisitor*, ValaExpression*)) vala_flow_analyzer_real_visit_expression;
}


static void
vala_flow_analyzer_instance_init (ValaFlowAnalyzer * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_FLOW_ANALYZER_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_FLOW_ANALYZER_TYPE_JUMP_TARGET, (GBoxedCopyFunc) vala_flow_analyzer_jump_target_ref, (GDestroyNotify) vala_flow_analyzer_jump_target_unref, _tmp0_);
	self->priv->jump_stack = (ValaList*) _tmp1_;
}


static void
vala_flow_analyzer_finalize (ValaCodeVisitor * obj)
{
	ValaFlowAnalyzer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_FLOW_ANALYZER, ValaFlowAnalyzer);
	_vala_code_context_unref0 (self->priv->context);
	_vala_basic_block_unref0 (self->priv->current_block);
	_vala_iterable_unref0 (self->priv->jump_stack);
	_vala_map_unref0 (self->priv->var_map);
	_vala_iterable_unref0 (self->priv->used_vars);
	_vala_map_unref0 (self->priv->phi_functions);
	VALA_CODE_VISITOR_CLASS (vala_flow_analyzer_parent_class)->finalize (obj);
}


/**
 * Code visitor building the control flow graph.
 */
GType
vala_flow_analyzer_get_type (void)
{
	static volatile gsize vala_flow_analyzer_type_id__volatile = 0;
	if (g_once_init_enter (&vala_flow_analyzer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaFlowAnalyzerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_flow_analyzer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaFlowAnalyzer), 0, (GInstanceInitFunc) vala_flow_analyzer_instance_init, NULL };
		GType vala_flow_analyzer_type_id;
		vala_flow_analyzer_type_id = g_type_register_static (VALA_TYPE_CODE_VISITOR, "ValaFlowAnalyzer", &g_define_type_info, 0);
		g_once_init_leave (&vala_flow_analyzer_type_id__volatile, vala_flow_analyzer_type_id);
	}
	return vala_flow_analyzer_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



