/* valadelegate.c generated by valac, the Vala compiler
 * generated from valadelegate.vala, do not modify */

/* valadelegate.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaDelegatePrivate {
	ValaDataType* _sender_type;
	ValaList* type_parameters;
	ValaList* parameters;
	ValaDataType* _return_type;
	gboolean* _has_target;
};


static gpointer vala_delegate_parent_class = NULL;
static ValaCallableIface * vala_delegate_vala_callable_parent_iface = NULL;

#define VALA_DELEGATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DELEGATE, ValaDelegatePrivate))
static gint vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base,
                                                  const gchar* name);
static void vala_delegate_real_add_parameter (ValaCallable* base,
                                       ValaParameter* param);
static ValaList* vala_delegate_real_get_parameters (ValaCallable* base);
static void vala_delegate_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_delegate_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static gboolean vala_delegate_real_is_reference_type (ValaTypeSymbol* base);
static void vala_delegate_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static gboolean vala_delegate_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_delegate_finalize (ValaCodeNode * obj);


/**
 * Creates a new delegate.
 *
 * @param name              delegate type name
 * @param return_type       return type
 * @param source_reference  reference to source code
 * @return                  newly created delegate
 */
ValaDelegate*
vala_delegate_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* return_type,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaDelegate* self = NULL;
	g_return_val_if_fail (return_type != NULL, NULL);
	self = (ValaDelegate*) vala_typesymbol_construct (object_type, name, source_reference, comment);
	vala_callable_set_return_type ((ValaCallable*) self, return_type);
	return self;
}


ValaDelegate*
vala_delegate_new (const gchar* name,
                   ValaDataType* return_type,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_delegate_construct (VALA_TYPE_DELEGATE, name, return_type, source_reference, comment);
}


/**
 * Appends the specified parameter to the list of type parameters.
 *
 * @param p a type parameter
 */
void
vala_delegate_add_type_parameter (ValaDelegate* self,
                                  ValaTypeParameter* p)
{
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->type_parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, p);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) p);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) p);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_delegate_get_type_parameters (ValaDelegate* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static gint
vala_delegate_real_get_type_parameter_index (ValaTypeSymbol* base,
                                             const gchar* name)
{
	ValaDelegate * self;
	gint result = 0;
	gint i = 0;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (name != NULL, 0);
	i = 0;
	{
		ValaList* _parameter_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _parameter_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _parameter_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_parameter_list = _tmp1_;
		_tmp2_ = _parameter_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_parameter_size = _tmp4_;
		_parameter_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* parameter = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gint _tmp13_;
			_parameter_index = _parameter_index + 1;
			_tmp5_ = _parameter_index;
			_tmp6_ = _parameter_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _parameter_list;
			_tmp8_ = _parameter_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			parameter = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = parameter;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			if (g_strcmp0 (_tmp12_, name) == 0) {
				result = i;
				_vala_code_node_unref0 (parameter);
				_vala_iterable_unref0 (_parameter_list);
				return result;
			}
			_tmp13_ = i;
			i = _tmp13_ + 1;
			_vala_code_node_unref0 (parameter);
		}
		_vala_iterable_unref0 (_parameter_list);
	}
	result = -1;
	return result;
}


/**
 * Appends paramater to this callback function.
 *
 * @param param a formal parameter
 */
static void
vala_delegate_real_add_parameter (ValaCallable* base,
                                  ValaParameter* param)
{
	ValaDelegate * self;
	ValaList* _tmp0_;
	ValaScope* _tmp1_;
	ValaScope* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	self = (ValaDelegate*) base;
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
	_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = vala_symbol_get_name ((ValaSymbol*) param);
	_tmp4_ = _tmp3_;
	vala_scope_add (_tmp2_, _tmp4_, (ValaSymbol*) param);
}


/**
 * Return copy of parameter list.
 *
 * @return parameter list
 */
static ValaList*
vala_delegate_real_get_parameters (ValaCallable* base)
{
	ValaDelegate * self;
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Checks whether the arguments and return type of the specified method
 * matches this callback.
 *
 * @param m a method
 * @return  true if the specified method is compatible to this callback
 */
gboolean
vala_delegate_matches_method (ValaDelegate* self,
                              ValaMethod* m,
                              ValaDataType* dt)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ValaDataType* _tmp5_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp10_;
	gboolean _tmp11_;
	ValaList* method_params = NULL;
	ValaList* _tmp12_;
	ValaIterator* method_params_it = NULL;
	ValaList* _tmp13_;
	ValaIterator* _tmp14_;
	gboolean _tmp15_ = FALSE;
	ValaDataType* _tmp16_;
	gboolean first = FALSE;
	ValaIterator* _tmp59_;
	ValaList* error_types = NULL;
	ValaList* _tmp60_;
	ValaList* method_error_types = NULL;
	ValaList* _tmp61_;
	gboolean _tmp62_ = FALSE;
	ValaList* _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	g_return_val_if_fail (dt != NULL, FALSE);
	_tmp1_ = vala_method_get_coroutine (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !VALA_IS_SIGNAL (_tmp4_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_data_type_get_actual_type (_tmp8_, dt, NULL, (ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = !vala_data_type_stricter (_tmp6_, _tmp10_);
	_vala_code_node_unref0 (_tmp10_);
	if (_tmp11_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = vala_callable_get_parameters ((ValaCallable*) m);
	method_params = _tmp12_;
	_tmp13_ = method_params;
	_tmp14_ = vala_iterable_iterator ((ValaIterable*) _tmp13_);
	method_params_it = _tmp14_;
	_tmp16_ = self->priv->_sender_type;
	if (_tmp16_ != NULL) {
		ValaList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		ValaList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		_tmp17_ = method_params;
		_tmp18_ = vala_collection_get_size ((ValaCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = self->priv->parameters;
		_tmp21_ = vala_collection_get_size ((ValaCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_tmp15_ = _tmp19_ == (_tmp22_ + 1);
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		ValaIterator* _tmp23_;
		ValaParameter* method_param = NULL;
		ValaIterator* _tmp24_;
		gpointer _tmp25_;
		ValaDataType* _tmp26_;
		ValaParameter* _tmp27_;
		ValaDataType* _tmp28_;
		ValaDataType* _tmp29_;
		_tmp23_ = method_params_it;
		vala_iterator_next (_tmp23_);
		_tmp24_ = method_params_it;
		_tmp25_ = vala_iterator_get (_tmp24_);
		method_param = (ValaParameter*) _tmp25_;
		_tmp26_ = self->priv->_sender_type;
		_tmp27_ = method_param;
		_tmp28_ = vala_variable_get_variable_type ((ValaVariable*) _tmp27_);
		_tmp29_ = _tmp28_;
		if (!vala_data_type_stricter (_tmp26_, _tmp29_)) {
			result = FALSE;
			_vala_code_node_unref0 (method_param);
			_vala_iterator_unref0 (method_params_it);
			_vala_iterable_unref0 (method_params);
			return result;
		}
		_vala_code_node_unref0 (method_param);
	}
	first = TRUE;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp30_;
		ValaList* _tmp31_;
		gint _param_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _param_index = 0;
		_tmp30_ = self->priv->parameters;
		_tmp31_ = _vala_iterable_ref0 (_tmp30_);
		_param_list = _tmp31_;
		_tmp32_ = _param_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_param_size = _tmp34_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaParameter* param = NULL;
			ValaList* _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			gboolean _tmp40_ = FALSE;
			gboolean _tmp41_ = FALSE;
			gboolean _tmp42_;
			ValaIterator* _tmp47_;
			ValaParameter* method_param = NULL;
			ValaIterator* _tmp48_;
			gpointer _tmp49_;
			ValaParameter* _tmp50_;
			ValaDataType* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			ValaDataType* _tmp54_;
			ValaParameter* _tmp55_;
			ValaDataType* _tmp56_;
			ValaDataType* _tmp57_;
			gboolean _tmp58_;
			_param_index = _param_index + 1;
			_tmp35_ = _param_index;
			_tmp36_ = _param_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _param_list;
			_tmp38_ = _param_index;
			_tmp39_ = vala_list_get (_tmp37_, _tmp38_);
			param = (ValaParameter*) _tmp39_;
			_tmp42_ = first;
			if (_tmp42_) {
				ValaMemberBinding _tmp43_;
				ValaMemberBinding _tmp44_;
				_tmp43_ = vala_method_get_binding (m);
				_tmp44_ = _tmp43_;
				_tmp41_ = _tmp44_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp41_ = FALSE;
			}
			if (_tmp41_) {
				gboolean _tmp45_;
				gboolean _tmp46_;
				_tmp45_ = vala_delegate_get_has_target (self);
				_tmp46_ = _tmp45_;
				_tmp40_ = !_tmp46_;
			} else {
				_tmp40_ = FALSE;
			}
			if (_tmp40_) {
				first = FALSE;
				_vala_code_node_unref0 (param);
				continue;
			}
			_tmp47_ = method_params_it;
			if (!vala_iterator_next (_tmp47_)) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp48_ = method_params_it;
			_tmp49_ = vala_iterator_get (_tmp48_);
			method_param = (ValaParameter*) _tmp49_;
			_tmp50_ = param;
			_tmp51_ = vala_variable_get_variable_type ((ValaVariable*) _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_data_type_get_actual_type (_tmp52_, dt, NULL, (ValaCodeNode*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = method_param;
			_tmp56_ = vala_variable_get_variable_type ((ValaVariable*) _tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = !vala_data_type_stricter (_tmp54_, _tmp57_);
			_vala_code_node_unref0 (_tmp54_);
			if (_tmp58_) {
				result = FALSE;
				_vala_code_node_unref0 (method_param);
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_param);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp59_ = method_params_it;
	if (vala_iterator_next (_tmp59_)) {
		result = FALSE;
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	_tmp60_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp60_;
	_tmp61_ = vala_code_node_get_error_types ((ValaCodeNode*) m);
	method_error_types = _tmp61_;
	_tmp63_ = error_types;
	_tmp64_ = vala_collection_get_size ((ValaCollection*) _tmp63_);
	_tmp65_ = _tmp64_;
	if (_tmp65_ > 0) {
		ValaList* _tmp66_;
		gint _tmp67_;
		gint _tmp68_;
		_tmp66_ = method_error_types;
		_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
		_tmp68_ = _tmp67_;
		_tmp62_ = _tmp68_ == 0;
	} else {
		_tmp62_ = FALSE;
	}
	if (_tmp62_) {
		result = FALSE;
		_vala_iterable_unref0 (method_error_types);
		_vala_iterable_unref0 (error_types);
		_vala_iterator_unref0 (method_params_it);
		_vala_iterable_unref0 (method_params);
		return result;
	}
	{
		ValaList* _method_error_type_list = NULL;
		ValaList* _tmp69_;
		ValaList* _tmp70_;
		gint _method_error_type_size = 0;
		ValaList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _method_error_type_index = 0;
		_tmp69_ = method_error_types;
		_tmp70_ = _vala_iterable_ref0 (_tmp69_);
		_method_error_type_list = _tmp70_;
		_tmp71_ = _method_error_type_list;
		_tmp72_ = vala_collection_get_size ((ValaCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_method_error_type_size = _tmp73_;
		_method_error_type_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			ValaDataType* method_error_type = NULL;
			ValaList* _tmp76_;
			gint _tmp77_;
			gpointer _tmp78_;
			gboolean match = FALSE;
			gboolean _tmp91_;
			_method_error_type_index = _method_error_type_index + 1;
			_tmp74_ = _method_error_type_index;
			_tmp75_ = _method_error_type_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _method_error_type_list;
			_tmp77_ = _method_error_type_index;
			_tmp78_ = vala_list_get (_tmp76_, _tmp77_);
			method_error_type = (ValaDataType*) _tmp78_;
			match = FALSE;
			{
				ValaList* _delegate_error_type_list = NULL;
				ValaList* _tmp79_;
				ValaList* _tmp80_;
				gint _delegate_error_type_size = 0;
				ValaList* _tmp81_;
				gint _tmp82_;
				gint _tmp83_;
				gint _delegate_error_type_index = 0;
				_tmp79_ = error_types;
				_tmp80_ = _vala_iterable_ref0 (_tmp79_);
				_delegate_error_type_list = _tmp80_;
				_tmp81_ = _delegate_error_type_list;
				_tmp82_ = vala_collection_get_size ((ValaCollection*) _tmp81_);
				_tmp83_ = _tmp82_;
				_delegate_error_type_size = _tmp83_;
				_delegate_error_type_index = -1;
				while (TRUE) {
					gint _tmp84_;
					gint _tmp85_;
					ValaDataType* delegate_error_type = NULL;
					ValaList* _tmp86_;
					gint _tmp87_;
					gpointer _tmp88_;
					ValaDataType* _tmp89_;
					ValaDataType* _tmp90_;
					_delegate_error_type_index = _delegate_error_type_index + 1;
					_tmp84_ = _delegate_error_type_index;
					_tmp85_ = _delegate_error_type_size;
					if (!(_tmp84_ < _tmp85_)) {
						break;
					}
					_tmp86_ = _delegate_error_type_list;
					_tmp87_ = _delegate_error_type_index;
					_tmp88_ = vala_list_get (_tmp86_, _tmp87_);
					delegate_error_type = (ValaDataType*) _tmp88_;
					_tmp89_ = method_error_type;
					_tmp90_ = delegate_error_type;
					if (vala_data_type_compatible (_tmp89_, _tmp90_)) {
						match = TRUE;
						_vala_code_node_unref0 (delegate_error_type);
						break;
					}
					_vala_code_node_unref0 (delegate_error_type);
				}
				_vala_iterable_unref0 (_delegate_error_type_list);
			}
			_tmp91_ = match;
			if (!_tmp91_) {
				result = FALSE;
				_vala_code_node_unref0 (method_error_type);
				_vala_iterable_unref0 (_method_error_type_list);
				_vala_iterable_unref0 (method_error_types);
				_vala_iterable_unref0 (error_types);
				_vala_iterator_unref0 (method_params_it);
				_vala_iterable_unref0 (method_params);
				return result;
			}
			_vala_code_node_unref0 (method_error_type);
		}
		_vala_iterable_unref0 (_method_error_type_list);
	}
	result = TRUE;
	_vala_iterable_unref0 (method_error_types);
	_vala_iterable_unref0 (error_types);
	_vala_iterator_unref0 (method_params_it);
	_vala_iterable_unref0 (method_params);
	return result;
}


static void
vala_delegate_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaDelegate * self;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_delegate (visitor, self);
}


static void
vala_delegate_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaDelegate * self;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	self = (ValaDelegate*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _p_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _p_index = 0;
		_tmp0_ = self->priv->type_parameters;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_p_list = _tmp1_;
		_tmp2_ = _p_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_p_size = _tmp4_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeParameter* _tmp10_;
			_p_index = _p_index + 1;
			_tmp5_ = _p_index;
			_tmp6_ = _p_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _p_list;
			_tmp8_ = _p_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			p = (ValaTypeParameter*) _tmp9_;
			_tmp10_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp11_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp12_ = _tmp11_;
	vala_code_node_accept ((ValaCodeNode*) _tmp12_, visitor);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp13_;
		ValaList* _tmp14_;
		gint _param_size = 0;
		ValaList* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		gint _param_index = 0;
		_tmp13_ = self->priv->parameters;
		_tmp14_ = _vala_iterable_ref0 (_tmp13_);
		_param_list = _tmp14_;
		_tmp15_ = _param_list;
		_tmp16_ = vala_collection_get_size ((ValaCollection*) _tmp15_);
		_tmp17_ = _tmp16_;
		_param_size = _tmp17_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp18_;
			gint _tmp19_;
			ValaParameter* param = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaParameter* _tmp23_;
			_param_index = _param_index + 1;
			_tmp18_ = _param_index;
			_tmp19_ = _param_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _param_list;
			_tmp21_ = _param_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			param = (ValaParameter*) _tmp22_;
			_tmp23_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp23_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp24_;
		gint _error_type_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _error_type_index = 0;
		_tmp24_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp24_;
		_tmp25_ = _error_type_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_error_type_size = _tmp27_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaDataType* _tmp33_;
			_error_type_index = _error_type_index + 1;
			_tmp28_ = _error_type_index;
			_tmp29_ = _error_type_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _error_type_list;
			_tmp31_ = _error_type_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			error_type = (ValaDataType*) _tmp32_;
			_tmp33_ = error_type;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
}


static gboolean
vala_delegate_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaDelegate * self;
	gboolean result = FALSE;
	self = (ValaDelegate*) base;
	result = FALSE;
	return result;
}


static void
vala_delegate_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaDelegate * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaList* error_types = NULL;
	ValaList* _tmp2_;
	self = (ValaDelegate*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_callable_set_return_type ((ValaCallable*) self, new_type);
		return;
	}
	_tmp2_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
	error_types = _tmp2_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				ValaList* _tmp9_;
				gint _tmp10_;
				gpointer _tmp11_;
				ValaDataType* _tmp12_;
				gboolean _tmp13_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = error_types;
				_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
				_tmp8_ = _tmp7_;
				if (!(_tmp5_ < _tmp8_)) {
					break;
				}
				_tmp9_ = error_types;
				_tmp10_ = i;
				_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
				_tmp12_ = (ValaDataType*) _tmp11_;
				_tmp13_ = _tmp12_ == old_type;
				_vala_code_node_unref0 (_tmp12_);
				if (_tmp13_) {
					ValaList* _tmp14_;
					gint _tmp15_;
					_tmp14_ = error_types;
					_tmp15_ = i;
					vala_list_set (_tmp14_, _tmp15_, new_type);
					_vala_iterable_unref0 (error_types);
					return;
				}
			}
		}
	}
	_vala_iterable_unref0 (error_types);
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_delegate_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaDelegate * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSourceReference* _tmp9_;
	ValaSourceReference* _tmp10_;
	ValaDataType* _tmp28_;
	ValaDataType* _tmp29_;
	ValaDataType* _tmp30_;
	ValaDataType* _tmp31_;
	ValaTypeSymbol* _tmp32_;
	ValaTypeSymbol* _tmp33_;
	ValaSemanticAnalyzer* _tmp34_;
	ValaSemanticAnalyzer* _tmp35_;
	ValaDataType* _tmp36_;
	ValaTypeSymbol* _tmp37_;
	ValaTypeSymbol* _tmp38_;
	ValaSemanticAnalyzer* _tmp82_;
	ValaSemanticAnalyzer* _tmp83_;
	ValaSourceFile* _tmp84_;
	gboolean _tmp85_;
	gboolean _tmp86_;
	self = (ValaDelegate*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp10_ = _tmp9_;
	if (_tmp10_ != NULL) {
		ValaSemanticAnalyzer* _tmp11_;
		ValaSemanticAnalyzer* _tmp12_;
		ValaSourceReference* _tmp13_;
		ValaSourceReference* _tmp14_;
		ValaSourceFile* _tmp15_;
		ValaSourceFile* _tmp16_;
		_tmp11_ = vala_code_context_get_analyzer (context);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_source_reference_get_file (_tmp14_);
		_tmp16_ = _tmp15_;
		vala_semantic_analyzer_set_current_source_file (_tmp12_, _tmp16_);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _p_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _p_index = 0;
		_tmp17_ = self->priv->type_parameters;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_p_list = _tmp18_;
		_tmp19_ = _p_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_p_size = _tmp21_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp24_;
			gint _tmp25_;
			gpointer _tmp26_;
			ValaTypeParameter* _tmp27_;
			_p_index = _p_index + 1;
			_tmp22_ = _p_index;
			_tmp23_ = _p_size;
			if (!(_tmp22_ < _tmp23_)) {
				break;
			}
			_tmp24_ = _p_list;
			_tmp25_ = _p_index;
			_tmp26_ = vala_list_get (_tmp24_, _tmp25_);
			p = (ValaTypeParameter*) _tmp26_;
			_tmp27_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp27_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp28_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp29_ = _tmp28_;
	vala_code_node_check ((ValaCodeNode*) _tmp29_, context);
	_tmp30_ = vala_callable_get_return_type ((ValaCallable*) self);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_data_type_get_data_type (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_code_context_get_analyzer (context);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_->va_list_type;
	_tmp37_ = vala_data_type_get_data_type (_tmp36_);
	_tmp38_ = _tmp37_;
	if (_tmp33_ == _tmp38_) {
		ValaSourceReference* _tmp39_;
		ValaSourceReference* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaTypeSymbol* _tmp43_;
		ValaTypeSymbol* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_callable_get_return_type ((ValaCallable*) self);
		_tmp42_ = _tmp41_;
		_tmp43_ = vala_data_type_get_data_type (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strdup_printf ("`%s' not supported as return type", _tmp46_);
		_tmp48_ = _tmp47_;
		vala_report_error (_tmp40_, _tmp48_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		result = FALSE;
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp49_;
		ValaList* _tmp50_;
		gint _param_size = 0;
		ValaList* _tmp51_;
		gint _tmp52_;
		gint _tmp53_;
		gint _param_index = 0;
		_tmp49_ = self->priv->parameters;
		_tmp50_ = _vala_iterable_ref0 (_tmp49_);
		_param_list = _tmp50_;
		_tmp51_ = _param_list;
		_tmp52_ = vala_collection_get_size ((ValaCollection*) _tmp51_);
		_tmp53_ = _tmp52_;
		_param_size = _tmp53_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp54_;
			gint _tmp55_;
			ValaParameter* param = NULL;
			ValaList* _tmp56_;
			gint _tmp57_;
			gpointer _tmp58_;
			ValaParameter* _tmp59_;
			_param_index = _param_index + 1;
			_tmp54_ = _param_index;
			_tmp55_ = _param_size;
			if (!(_tmp54_ < _tmp55_)) {
				break;
			}
			_tmp56_ = _param_list;
			_tmp57_ = _param_index;
			_tmp58_ = vala_list_get (_tmp56_, _tmp57_);
			param = (ValaParameter*) _tmp58_;
			_tmp59_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp59_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp60_;
		gint _error_type_size = 0;
		ValaList* _tmp61_;
		gint _tmp62_;
		gint _tmp63_;
		gint _error_type_index = 0;
		_tmp60_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp60_;
		_tmp61_ = _error_type_list;
		_tmp62_ = vala_collection_get_size ((ValaCollection*) _tmp61_);
		_tmp63_ = _tmp62_;
		_error_type_size = _tmp63_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp64_;
			gint _tmp65_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp66_;
			gint _tmp67_;
			gpointer _tmp68_;
			ValaDataType* _tmp69_;
			ValaSemanticAnalyzer* _tmp70_;
			ValaSemanticAnalyzer* _tmp71_;
			ValaDataType* _tmp72_;
			_error_type_index = _error_type_index + 1;
			_tmp64_ = _error_type_index;
			_tmp65_ = _error_type_size;
			if (!(_tmp64_ < _tmp65_)) {
				break;
			}
			_tmp66_ = _error_type_list;
			_tmp67_ = _error_type_index;
			_tmp68_ = vala_list_get (_tmp66_, _tmp67_);
			error_type = (ValaDataType*) _tmp68_;
			_tmp69_ = error_type;
			vala_code_node_check ((ValaCodeNode*) _tmp69_, context);
			_tmp70_ = vala_code_context_get_analyzer (context);
			_tmp71_ = _tmp70_;
			_tmp72_ = error_type;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp71_, (ValaSymbol*) self, _tmp72_)) {
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaDataType* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp74_ = _tmp73_;
				_tmp75_ = error_type;
				_tmp76_ = vala_code_node_to_string ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strdup_printf ("error type `%s' is less accessible than delegate `%s'", _tmp77_, _tmp79_);
				_tmp81_ = _tmp80_;
				vala_report_error (_tmp74_, _tmp81_);
				_g_free0 (_tmp81_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				result = FALSE;
				_vala_code_node_unref0 (error_type);
				_vala_iterable_unref0 (_error_type_list);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp82_ = vala_code_context_get_analyzer (context);
	_tmp83_ = _tmp82_;
	_tmp84_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp83_, _tmp84_);
	_tmp85_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp86_ = _tmp85_;
	result = !_tmp86_;
	_vala_source_file_unref0 (old_source_file);
	return result;
}


static ValaDataType*
vala_delegate_real_get_return_type (ValaCallable* base)
{
	ValaDataType* result;
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	self = (ValaDelegate*) base;
	_tmp0_ = self->priv->_return_type;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_delegate_real_set_return_type (ValaCallable* base,
                                    ValaDataType* value)
{
	ValaDelegate* self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaDelegate*) base;
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_return_type);
	self->priv->_return_type = _tmp0_;
	_tmp1_ = self->priv->_return_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_delegate_get_has_target (ValaDelegate* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_target;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_has_target);
		self->priv->_has_target = _tmp2_;
	}
	_tmp3_ = self->priv->_has_target;
	result = *_tmp3_;
	return result;
}


void
vala_delegate_set_has_target (ValaDelegate* self,
                              gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_has_target);
	self->priv->_has_target = _tmp0_;
	if (value) {
		vala_code_node_remove_attribute_argument ((ValaCodeNode*) self, "CCode", "has_target");
	} else {
		vala_code_node_set_attribute_bool ((ValaCodeNode*) self, "CCode", "has_target", FALSE, NULL);
	}
}


ValaDataType*
vala_delegate_get_sender_type (ValaDelegate* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sender_type;
	result = _tmp0_;
	return result;
}


void
vala_delegate_set_sender_type (ValaDelegate* self,
                               ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_sender_type);
	self->priv->_sender_type = _tmp0_;
}


static void
vala_delegate_class_init (ValaDelegateClass * klass)
{
	vala_delegate_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_delegate_finalize;
	g_type_class_add_private (klass, sizeof (ValaDelegatePrivate));
	((ValaTypeSymbolClass *) klass)->get_type_parameter_index = (gint (*) (ValaTypeSymbol*, const gchar*)) vala_delegate_real_get_type_parameter_index;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_delegate_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_delegate_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_delegate_real_is_reference_type;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_delegate_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_delegate_real_check;
}


static void
vala_delegate_vala_callable_interface_init (ValaCallableIface * iface)
{
	vala_delegate_vala_callable_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_parameter = (void (*) (ValaCallable*, ValaParameter*)) vala_delegate_real_add_parameter;
	iface->get_parameters = (ValaList* (*) (ValaCallable*)) vala_delegate_real_get_parameters;
	iface->get_return_type = vala_delegate_real_get_return_type;
	iface->set_return_type = vala_delegate_real_set_return_type;
}


static void
vala_delegate_instance_init (ValaDelegate * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_DELEGATE_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_TYPEPARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_parameters = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->parameters = (ValaList*) _tmp3_;
}


static void
vala_delegate_finalize (ValaCodeNode * obj)
{
	ValaDelegate * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_DELEGATE, ValaDelegate);
	_vala_code_node_unref0 (self->priv->_sender_type);
	_vala_iterable_unref0 (self->priv->type_parameters);
	_vala_iterable_unref0 (self->priv->parameters);
	_vala_code_node_unref0 (self->priv->_return_type);
	_g_free0 (self->priv->_has_target);
	VALA_CODE_NODE_CLASS (vala_delegate_parent_class)->finalize (obj);
}


/**
 * Represents a function callback type.
 */
GType
vala_delegate_get_type (void)
{
	static volatile gsize vala_delegate_type_id__volatile = 0;
	if (g_once_init_enter (&vala_delegate_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDelegateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_delegate_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDelegate), 0, (GInstanceInitFunc) vala_delegate_instance_init, NULL };
		static const GInterfaceInfo vala_callable_info = { (GInterfaceInitFunc) vala_delegate_vala_callable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_delegate_type_id;
		vala_delegate_type_id = g_type_register_static (VALA_TYPE_TYPESYMBOL, "ValaDelegate", &g_define_type_info, 0);
		g_type_add_interface_static (vala_delegate_type_id, VALA_TYPE_CALLABLE, &vala_callable_info);
		g_once_init_leave (&vala_delegate_type_id__volatile, vala_delegate_type_id);
	}
	return vala_delegate_type_id__volatile;
}



