/* valacreationmethod.c generated by valac, the Vala compiler
 * generated from valacreationmethod.vala, do not modify */

/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2010  Jürg Billeter
 * Copyright (C) 2007-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaCreationMethodPrivate {
	gchar* _class_name;
	gboolean _chain_up;
};


static gpointer vala_creation_method_parent_class = NULL;

#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
static void vala_creation_method_real_accept (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base,
                                                ValaCodeVisitor* visitor);
static gboolean vala_creation_method_real_check (ValaCodeNode* base,
                                          ValaCodeContext* context);
static void vala_creation_method_finalize (ValaCodeNode * obj);


/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod*
vala_creation_method_construct (GType object_type,
                                const gchar* class_name,
                                const gchar* name,
                                ValaSourceReference* source_reference,
                                ValaComment* comment)
{
	ValaCreationMethod* self = NULL;
	ValaVoidType* _tmp0_;
	ValaVoidType* _tmp1_;
	_tmp0_ = vala_void_type_new (NULL);
	_tmp1_ = _tmp0_;
	self = (ValaCreationMethod*) vala_method_construct (object_type, name, (ValaDataType*) _tmp1_, source_reference, comment);
	_vala_code_node_unref0 (_tmp1_);
	vala_creation_method_set_class_name (self, class_name);
	return self;
}


ValaCreationMethod*
vala_creation_method_new (const gchar* class_name,
                          const gchar* name,
                          ValaSourceReference* source_reference,
                          ValaComment* comment)
{
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, class_name, name, source_reference, comment);
}


static void
vala_creation_method_real_accept (ValaCodeNode* base,
                                  ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void
vala_creation_method_real_accept_children (ValaCodeNode* base,
                                           ValaCodeVisitor* visitor)
{
	ValaCreationMethod * self;
	ValaBlock* _tmp40_;
	ValaBlock* _tmp41_;
	self = (ValaCreationMethod*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaParameter* param = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaParameter* _tmp9_;
			_param_index = _param_index + 1;
			_tmp4_ = _param_index;
			_tmp5_ = _param_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _param_list;
			_tmp7_ = _param_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			param = (ValaParameter*) _tmp8_;
			_tmp9_ = param;
			vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp10_;
		gint _error_type_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _error_type_index = 0;
		_tmp10_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp10_;
		_tmp11_ = _error_type_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_error_type_size = _tmp13_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_error_type_index = _error_type_index + 1;
			_tmp14_ = _error_type_index;
			_tmp15_ = _error_type_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _error_type_list;
			_tmp17_ = _error_type_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			error_type = (ValaDataType*) _tmp18_;
			_tmp19_ = error_type;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp20_;
		gint _precondition_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _precondition_index = 0;
		_tmp20_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp20_;
		_tmp21_ = _precondition_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_precondition_size = _tmp23_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp26_;
			gint _tmp27_;
			gpointer _tmp28_;
			ValaExpression* _tmp29_;
			_precondition_index = _precondition_index + 1;
			_tmp24_ = _precondition_index;
			_tmp25_ = _precondition_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _precondition_list;
			_tmp27_ = _precondition_index;
			_tmp28_ = vala_list_get (_tmp26_, _tmp27_);
			precondition = (ValaExpression*) _tmp28_;
			_tmp29_ = precondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp29_, visitor);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp30_;
		gint _postcondition_size = 0;
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _postcondition_index = 0;
		_tmp30_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp30_;
		_tmp31_ = _postcondition_list;
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_postcondition_size = _tmp33_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_;
			ValaExpression* _tmp39_;
			_postcondition_index = _postcondition_index + 1;
			_tmp34_ = _postcondition_index;
			_tmp35_ = _postcondition_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _postcondition_list;
			_tmp37_ = _postcondition_index;
			_tmp38_ = vala_list_get (_tmp36_, _tmp37_);
			postcondition = (ValaExpression*) _tmp38_;
			_tmp39_ = postcondition;
			vala_code_node_accept ((ValaCodeNode*) _tmp39_, visitor);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp40_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp41_ = _tmp40_;
	if (_tmp41_ != NULL) {
		ValaBlock* _tmp42_;
		ValaBlock* _tmp43_;
		_tmp42_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp43_ = _tmp42_;
		vala_code_node_accept ((ValaCodeNode*) _tmp43_, visitor);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_creation_method_real_check (ValaCodeNode* base,
                                 ValaCodeContext* context)
{
	ValaCreationMethod * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	const gchar* _tmp5_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaSourceFile* _tmp24_;
	ValaSourceFile* _tmp25_;
	ValaSourceFile* _tmp26_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp27_;
	ValaSemanticAnalyzer* _tmp28_;
	ValaSymbol* _tmp29_;
	ValaSymbol* _tmp30_;
	ValaSymbol* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSemanticAnalyzer* _tmp40_;
	ValaSemanticAnalyzer* _tmp41_;
	gint i = 0;
	ValaBlock* _tmp106_;
	ValaBlock* _tmp107_;
	ValaSemanticAnalyzer* _tmp229_;
	ValaSemanticAnalyzer* _tmp230_;
	ValaSourceFile* _tmp231_;
	ValaSemanticAnalyzer* _tmp232_;
	ValaSemanticAnalyzer* _tmp233_;
	ValaSymbol* _tmp234_;
	gboolean _tmp235_ = FALSE;
	gboolean _tmp236_ = FALSE;
	gboolean _tmp237_;
	gboolean _tmp238_;
	gboolean _tmp249_ = FALSE;
	ValaBlock* _tmp250_;
	ValaBlock* _tmp251_;
	gboolean _tmp291_;
	gboolean _tmp292_;
	self = (ValaCreationMethod*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_class_name;
	if (_tmp5_ != NULL) {
		const gchar* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		_tmp6_ = self->priv->_class_name;
		_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_name (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp4_ = g_strcmp0 (_tmp6_, _tmp10_) != 0;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValaSourceReference* _tmp11_;
		ValaSourceReference* _tmp12_;
		ValaSemanticAnalyzer* _tmp13_;
		ValaSemanticAnalyzer* _tmp14_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_code_context_get_analyzer (context);
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_semantic_analyzer_get_current_symbol (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_symbol_get_full_name (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = self->priv->_class_name;
		_tmp20_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp18_, _tmp19_);
		_tmp21_ = _tmp20_;
		vala_report_error (_tmp12_, _tmp21_);
		_g_free0 (_tmp21_);
		_g_free0 (_tmp18_);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	_tmp24_ = vala_semantic_analyzer_get_current_source_file (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = _vala_source_file_ref0 (_tmp25_);
	old_source_file = _tmp26_;
	_tmp27_ = vala_code_context_get_analyzer (context);
	_tmp28_ = _tmp27_;
	_tmp29_ = vala_semantic_analyzer_get_current_symbol (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = _vala_code_node_ref0 (_tmp30_);
	old_symbol = _tmp31_;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp33_ = _tmp32_;
	if (_tmp33_ != NULL) {
		ValaSemanticAnalyzer* _tmp34_;
		ValaSemanticAnalyzer* _tmp35_;
		ValaSourceReference* _tmp36_;
		ValaSourceReference* _tmp37_;
		ValaSourceFile* _tmp38_;
		ValaSourceFile* _tmp39_;
		_tmp34_ = vala_code_context_get_analyzer (context);
		_tmp35_ = _tmp34_;
		_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_source_reference_get_file (_tmp37_);
		_tmp39_ = _tmp38_;
		vala_semantic_analyzer_set_current_source_file (_tmp35_, _tmp39_);
	}
	_tmp40_ = vala_code_context_get_analyzer (context);
	_tmp41_ = _tmp40_;
	vala_semantic_analyzer_set_current_symbol (_tmp41_, (ValaSymbol*) self);
	i = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp42_;
		gint _param_size = 0;
		ValaList* _tmp43_;
		gint _tmp44_;
		gint _tmp45_;
		gint _param_index = 0;
		_tmp42_ = vala_callable_get_parameters ((ValaCallable*) self);
		_param_list = _tmp42_;
		_tmp43_ = _param_list;
		_tmp44_ = vala_collection_get_size ((ValaCollection*) _tmp43_);
		_tmp45_ = _tmp44_;
		_param_size = _tmp45_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp46_;
			gint _tmp47_;
			ValaParameter* param = NULL;
			ValaList* _tmp48_;
			gint _tmp49_;
			gpointer _tmp50_;
			ValaParameter* _tmp51_;
			gboolean _tmp52_ = FALSE;
			gboolean _tmp53_ = FALSE;
			gint _tmp54_;
			gint _tmp63_;
			_param_index = _param_index + 1;
			_tmp46_ = _param_index;
			_tmp47_ = _param_size;
			if (!(_tmp46_ < _tmp47_)) {
				break;
			}
			_tmp48_ = _param_list;
			_tmp49_ = _param_index;
			_tmp50_ = vala_list_get (_tmp48_, _tmp49_);
			param = (ValaParameter*) _tmp50_;
			_tmp51_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp51_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp54_ = i;
			if (_tmp54_ == 0) {
				ValaParameter* _tmp55_;
				gboolean _tmp56_;
				gboolean _tmp57_;
				_tmp55_ = param;
				_tmp56_ = vala_parameter_get_ellipsis (_tmp55_);
				_tmp57_ = _tmp56_;
				_tmp53_ = _tmp57_;
			} else {
				_tmp53_ = FALSE;
			}
			if (_tmp53_) {
				ValaBlock* _tmp58_;
				ValaBlock* _tmp59_;
				_tmp58_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp59_ = _tmp58_;
				_tmp52_ = _tmp59_ != NULL;
			} else {
				_tmp52_ = FALSE;
			}
			if (_tmp52_) {
				ValaParameter* _tmp60_;
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp60_ = param;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
				_tmp62_ = _tmp61_;
				vala_report_error (_tmp62_, "Named parameter required before `...'");
			}
			_tmp63_ = i;
			i = _tmp63_ + 1;
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	{
		ValaList* _error_type_list = NULL;
		ValaList* _tmp64_;
		gint _error_type_size = 0;
		ValaList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
		gint _error_type_index = 0;
		_tmp64_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
		_error_type_list = _tmp64_;
		_tmp65_ = _error_type_list;
		_tmp66_ = vala_collection_get_size ((ValaCollection*) _tmp65_);
		_tmp67_ = _tmp66_;
		_error_type_size = _tmp67_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp68_;
			gint _tmp69_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp70_;
			gint _tmp71_;
			gpointer _tmp72_;
			ValaDataType* _tmp73_;
			ValaSemanticAnalyzer* _tmp74_;
			ValaSemanticAnalyzer* _tmp75_;
			ValaDataType* _tmp76_;
			_error_type_index = _error_type_index + 1;
			_tmp68_ = _error_type_index;
			_tmp69_ = _error_type_size;
			if (!(_tmp68_ < _tmp69_)) {
				break;
			}
			_tmp70_ = _error_type_list;
			_tmp71_ = _error_type_index;
			_tmp72_ = vala_list_get (_tmp70_, _tmp71_);
			error_type = (ValaDataType*) _tmp72_;
			_tmp73_ = error_type;
			vala_code_node_check ((ValaCodeNode*) _tmp73_, context);
			_tmp74_ = vala_code_context_get_analyzer (context);
			_tmp75_ = _tmp74_;
			_tmp76_ = error_type;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp75_, (ValaSymbol*) self, _tmp76_)) {
				ValaSourceReference* _tmp77_;
				ValaSourceReference* _tmp78_;
				ValaDataType* _tmp79_;
				gchar* _tmp80_;
				gchar* _tmp81_;
				gchar* _tmp82_;
				gchar* _tmp83_;
				gchar* _tmp84_;
				gchar* _tmp85_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp77_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp78_ = _tmp77_;
				_tmp79_ = error_type;
				_tmp80_ = vala_code_node_to_string ((ValaCodeNode*) _tmp79_);
				_tmp81_ = _tmp80_;
				_tmp82_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp83_ = _tmp82_;
				_tmp84_ = g_strdup_printf ("error type `%s' is less accessible than creation method `%s'", _tmp81_, _tmp83_);
				_tmp85_ = _tmp84_;
				vala_report_error (_tmp78_, _tmp85_);
				_g_free0 (_tmp85_);
				_g_free0 (_tmp83_);
				_g_free0 (_tmp81_);
				result = FALSE;
				_vala_code_node_unref0 (error_type);
				_vala_iterable_unref0 (_error_type_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	{
		ValaList* _precondition_list = NULL;
		ValaList* _tmp86_;
		gint _precondition_size = 0;
		ValaList* _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _precondition_index = 0;
		_tmp86_ = vala_method_get_preconditions ((ValaMethod*) self);
		_precondition_list = _tmp86_;
		_tmp87_ = _precondition_list;
		_tmp88_ = vala_collection_get_size ((ValaCollection*) _tmp87_);
		_tmp89_ = _tmp88_;
		_precondition_size = _tmp89_;
		_precondition_index = -1;
		while (TRUE) {
			gint _tmp90_;
			gint _tmp91_;
			ValaExpression* precondition = NULL;
			ValaList* _tmp92_;
			gint _tmp93_;
			gpointer _tmp94_;
			ValaExpression* _tmp95_;
			_precondition_index = _precondition_index + 1;
			_tmp90_ = _precondition_index;
			_tmp91_ = _precondition_size;
			if (!(_tmp90_ < _tmp91_)) {
				break;
			}
			_tmp92_ = _precondition_list;
			_tmp93_ = _precondition_index;
			_tmp94_ = vala_list_get (_tmp92_, _tmp93_);
			precondition = (ValaExpression*) _tmp94_;
			_tmp95_ = precondition;
			vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
			_vala_code_node_unref0 (precondition);
		}
		_vala_iterable_unref0 (_precondition_list);
	}
	{
		ValaList* _postcondition_list = NULL;
		ValaList* _tmp96_;
		gint _postcondition_size = 0;
		ValaList* _tmp97_;
		gint _tmp98_;
		gint _tmp99_;
		gint _postcondition_index = 0;
		_tmp96_ = vala_method_get_postconditions ((ValaMethod*) self);
		_postcondition_list = _tmp96_;
		_tmp97_ = _postcondition_list;
		_tmp98_ = vala_collection_get_size ((ValaCollection*) _tmp97_);
		_tmp99_ = _tmp98_;
		_postcondition_size = _tmp99_;
		_postcondition_index = -1;
		while (TRUE) {
			gint _tmp100_;
			gint _tmp101_;
			ValaExpression* postcondition = NULL;
			ValaList* _tmp102_;
			gint _tmp103_;
			gpointer _tmp104_;
			ValaExpression* _tmp105_;
			_postcondition_index = _postcondition_index + 1;
			_tmp100_ = _postcondition_index;
			_tmp101_ = _postcondition_size;
			if (!(_tmp100_ < _tmp101_)) {
				break;
			}
			_tmp102_ = _postcondition_list;
			_tmp103_ = _postcondition_index;
			_tmp104_ = vala_list_get (_tmp102_, _tmp103_);
			postcondition = (ValaExpression*) _tmp104_;
			_tmp105_ = postcondition;
			vala_code_node_check ((ValaCodeNode*) _tmp105_, context);
			_vala_code_node_unref0 (postcondition);
		}
		_vala_iterable_unref0 (_postcondition_list);
	}
	_tmp106_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp107_ = _tmp106_;
	if (_tmp107_ != NULL) {
		ValaBlock* _tmp108_;
		ValaBlock* _tmp109_;
		ValaClass* cl = NULL;
		ValaSymbol* _tmp110_;
		ValaSymbol* _tmp111_;
		ValaClass* _tmp112_;
		gboolean _tmp113_ = FALSE;
		gboolean _tmp114_ = FALSE;
		gboolean _tmp115_;
		_tmp108_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp109_ = _tmp108_;
		vala_code_node_check ((ValaCodeNode*) _tmp109_, context);
		_tmp110_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp111_ = _tmp110_;
		_tmp112_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp111_) ? ((ValaClass*) _tmp111_) : NULL);
		cl = _tmp112_;
		_tmp115_ = self->priv->_chain_up;
		if (!_tmp115_) {
			ValaClass* _tmp116_;
			_tmp116_ = cl;
			_tmp114_ = _tmp116_ != NULL;
		} else {
			_tmp114_ = FALSE;
		}
		if (_tmp114_) {
			ValaClass* _tmp117_;
			ValaClass* _tmp118_;
			ValaClass* _tmp119_;
			_tmp117_ = cl;
			_tmp118_ = vala_class_get_base_class (_tmp117_);
			_tmp119_ = _tmp118_;
			_tmp113_ = _tmp119_ != NULL;
		} else {
			_tmp113_ = FALSE;
		}
		if (_tmp113_) {
			gboolean _tmp120_ = FALSE;
			ValaClass* _tmp121_;
			ValaClass* _tmp122_;
			ValaClass* _tmp123_;
			ValaCreationMethod* _tmp124_;
			ValaCreationMethod* _tmp125_;
			_tmp121_ = cl;
			_tmp122_ = vala_class_get_base_class (_tmp121_);
			_tmp123_ = _tmp122_;
			_tmp124_ = vala_class_get_default_construction_method (_tmp123_);
			_tmp125_ = _tmp124_;
			if (_tmp125_ != NULL) {
				ValaClass* _tmp126_;
				ValaClass* _tmp127_;
				ValaClass* _tmp128_;
				ValaCreationMethod* _tmp129_;
				ValaCreationMethod* _tmp130_;
				gboolean _tmp131_;
				gboolean _tmp132_;
				_tmp126_ = cl;
				_tmp127_ = vala_class_get_base_class (_tmp126_);
				_tmp128_ = _tmp127_;
				_tmp129_ = vala_class_get_default_construction_method (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp130_);
				_tmp132_ = _tmp131_;
				_tmp120_ = !_tmp132_;
			} else {
				_tmp120_ = FALSE;
			}
			if (_tmp120_) {
				ValaBlock* old_insert_block = NULL;
				ValaSemanticAnalyzer* _tmp133_;
				ValaSemanticAnalyzer* _tmp134_;
				ValaBlock* _tmp135_;
				ValaBlock* _tmp136_;
				ValaSemanticAnalyzer* _tmp137_;
				ValaSemanticAnalyzer* _tmp138_;
				ValaBlock* _tmp139_;
				ValaBlock* _tmp140_;
				ValaSemanticAnalyzer* _tmp141_;
				ValaSemanticAnalyzer* _tmp142_;
				ValaBlock* _tmp143_;
				ValaBlock* _tmp144_;
				ValaBlock* _tmp145_;
				ValaExpressionStatement* stmt = NULL;
				ValaSourceReference* _tmp146_;
				ValaSourceReference* _tmp147_;
				ValaMemberAccess* _tmp148_;
				ValaMemberAccess* _tmp149_;
				ValaSourceReference* _tmp150_;
				ValaSourceReference* _tmp151_;
				ValaMemberAccess* _tmp152_;
				ValaMemberAccess* _tmp153_;
				ValaSourceReference* _tmp154_;
				ValaSourceReference* _tmp155_;
				ValaMethodCall* _tmp156_;
				ValaMethodCall* _tmp157_;
				ValaSourceReference* _tmp158_;
				ValaSourceReference* _tmp159_;
				ValaExpressionStatement* _tmp160_;
				ValaExpressionStatement* _tmp161_;
				ValaBlock* _tmp162_;
				ValaBlock* _tmp163_;
				ValaExpressionStatement* _tmp164_;
				ValaExpressionStatement* _tmp165_;
				ValaSemanticAnalyzer* _tmp166_;
				ValaSemanticAnalyzer* _tmp167_;
				ValaSemanticAnalyzer* _tmp168_;
				ValaSemanticAnalyzer* _tmp169_;
				ValaBlock* _tmp170_;
				ValaBlock* _tmp171_;
				_tmp133_ = vala_code_context_get_analyzer (context);
				_tmp134_ = _tmp133_;
				_tmp135_ = _tmp134_->insert_block;
				_tmp136_ = _vala_code_node_ref0 (_tmp135_);
				old_insert_block = _tmp136_;
				_tmp137_ = vala_code_context_get_analyzer (context);
				_tmp138_ = _tmp137_;
				_tmp139_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp140_ = _tmp139_;
				vala_semantic_analyzer_set_current_symbol (_tmp138_, (ValaSymbol*) _tmp140_);
				_tmp141_ = vala_code_context_get_analyzer (context);
				_tmp142_ = _tmp141_;
				_tmp143_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp144_ = _tmp143_;
				_tmp145_ = _vala_code_node_ref0 (_tmp144_);
				_vala_code_node_unref0 (_tmp142_->insert_block);
				_tmp142_->insert_block = _tmp145_;
				_tmp146_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp147_ = _tmp146_;
				_tmp148_ = vala_member_access_new_simple ("GLib", _tmp147_);
				_tmp149_ = _tmp148_;
				_tmp150_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp151_ = _tmp150_;
				_tmp152_ = vala_member_access_new ((ValaExpression*) _tmp149_, "Object", _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp155_ = _tmp154_;
				_tmp156_ = vala_method_call_new ((ValaExpression*) _tmp153_, _tmp155_);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp159_ = _tmp158_;
				_tmp160_ = vala_expression_statement_new ((ValaExpression*) _tmp157_, _tmp159_);
				_tmp161_ = _tmp160_;
				_vala_code_node_unref0 (_tmp157_);
				_vala_code_node_unref0 (_tmp153_);
				_vala_code_node_unref0 (_tmp149_);
				stmt = _tmp161_;
				_tmp162_ = vala_subroutine_get_body ((ValaSubroutine*) self);
				_tmp163_ = _tmp162_;
				_tmp164_ = stmt;
				vala_block_insert_statement (_tmp163_, 0, (ValaStatement*) _tmp164_);
				_tmp165_ = stmt;
				vala_code_node_check ((ValaCodeNode*) _tmp165_, context);
				_tmp166_ = vala_code_context_get_analyzer (context);
				_tmp167_ = _tmp166_;
				vala_semantic_analyzer_set_current_symbol (_tmp167_, (ValaSymbol*) self);
				_tmp168_ = vala_code_context_get_analyzer (context);
				_tmp169_ = _tmp168_;
				_tmp170_ = old_insert_block;
				_tmp171_ = _vala_code_node_ref0 (_tmp170_);
				_vala_code_node_unref0 (_tmp169_->insert_block);
				_tmp169_->insert_block = _tmp171_;
				_vala_code_node_unref0 (stmt);
				_vala_code_node_unref0 (old_insert_block);
			} else {
				gboolean _tmp172_ = FALSE;
				ValaClass* _tmp173_;
				ValaClass* _tmp174_;
				ValaClass* _tmp175_;
				ValaCreationMethod* _tmp176_;
				ValaCreationMethod* _tmp177_;
				_tmp173_ = cl;
				_tmp174_ = vala_class_get_base_class (_tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_class_get_default_construction_method (_tmp175_);
				_tmp177_ = _tmp176_;
				if (_tmp177_ == NULL) {
					_tmp172_ = TRUE;
				} else {
					ValaClass* _tmp178_;
					ValaClass* _tmp179_;
					ValaClass* _tmp180_;
					ValaCreationMethod* _tmp181_;
					ValaCreationMethod* _tmp182_;
					ValaSymbolAccessibility _tmp183_;
					ValaSymbolAccessibility _tmp184_;
					_tmp178_ = cl;
					_tmp179_ = vala_class_get_base_class (_tmp178_);
					_tmp180_ = _tmp179_;
					_tmp181_ = vala_class_get_default_construction_method (_tmp180_);
					_tmp182_ = _tmp181_;
					_tmp183_ = vala_symbol_get_access ((ValaSymbol*) _tmp182_);
					_tmp184_ = _tmp183_;
					_tmp172_ = _tmp184_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				}
				if (_tmp172_) {
					ValaSourceReference* _tmp185_;
					ValaSourceReference* _tmp186_;
					_tmp185_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp186_ = _tmp185_;
					vala_report_error (_tmp186_, "unable to chain up to private base constructor");
				} else {
					ValaClass* _tmp187_;
					ValaClass* _tmp188_;
					ValaClass* _tmp189_;
					ValaCreationMethod* _tmp190_;
					ValaCreationMethod* _tmp191_;
					_tmp187_ = cl;
					_tmp188_ = vala_class_get_base_class (_tmp187_);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_class_get_default_construction_method (_tmp189_);
					_tmp191_ = _tmp190_;
					if (vala_method_get_required_arguments ((ValaMethod*) _tmp191_) > 0) {
						ValaSourceReference* _tmp192_;
						ValaSourceReference* _tmp193_;
						_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp193_ = _tmp192_;
						vala_report_error (_tmp193_, "unable to chain up to base constructor requiring arguments");
					} else {
						ValaBlock* old_insert_block = NULL;
						ValaSemanticAnalyzer* _tmp194_;
						ValaSemanticAnalyzer* _tmp195_;
						ValaBlock* _tmp196_;
						ValaBlock* _tmp197_;
						ValaSemanticAnalyzer* _tmp198_;
						ValaSemanticAnalyzer* _tmp199_;
						ValaBlock* _tmp200_;
						ValaBlock* _tmp201_;
						ValaSemanticAnalyzer* _tmp202_;
						ValaSemanticAnalyzer* _tmp203_;
						ValaBlock* _tmp204_;
						ValaBlock* _tmp205_;
						ValaBlock* _tmp206_;
						ValaExpressionStatement* stmt = NULL;
						ValaSourceReference* _tmp207_;
						ValaSourceReference* _tmp208_;
						ValaBaseAccess* _tmp209_;
						ValaBaseAccess* _tmp210_;
						ValaSourceReference* _tmp211_;
						ValaSourceReference* _tmp212_;
						ValaMethodCall* _tmp213_;
						ValaMethodCall* _tmp214_;
						ValaSourceReference* _tmp215_;
						ValaSourceReference* _tmp216_;
						ValaExpressionStatement* _tmp217_;
						ValaExpressionStatement* _tmp218_;
						ValaBlock* _tmp219_;
						ValaBlock* _tmp220_;
						ValaExpressionStatement* _tmp221_;
						ValaExpressionStatement* _tmp222_;
						ValaSemanticAnalyzer* _tmp223_;
						ValaSemanticAnalyzer* _tmp224_;
						ValaSemanticAnalyzer* _tmp225_;
						ValaSemanticAnalyzer* _tmp226_;
						ValaBlock* _tmp227_;
						ValaBlock* _tmp228_;
						_tmp194_ = vala_code_context_get_analyzer (context);
						_tmp195_ = _tmp194_;
						_tmp196_ = _tmp195_->insert_block;
						_tmp197_ = _vala_code_node_ref0 (_tmp196_);
						old_insert_block = _tmp197_;
						_tmp198_ = vala_code_context_get_analyzer (context);
						_tmp199_ = _tmp198_;
						_tmp200_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp201_ = _tmp200_;
						vala_semantic_analyzer_set_current_symbol (_tmp199_, (ValaSymbol*) _tmp201_);
						_tmp202_ = vala_code_context_get_analyzer (context);
						_tmp203_ = _tmp202_;
						_tmp204_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp205_ = _tmp204_;
						_tmp206_ = _vala_code_node_ref0 (_tmp205_);
						_vala_code_node_unref0 (_tmp203_->insert_block);
						_tmp203_->insert_block = _tmp206_;
						_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp208_ = _tmp207_;
						_tmp209_ = vala_base_access_new (_tmp208_);
						_tmp210_ = _tmp209_;
						_tmp211_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp212_ = _tmp211_;
						_tmp213_ = vala_method_call_new ((ValaExpression*) _tmp210_, _tmp212_);
						_tmp214_ = _tmp213_;
						_tmp215_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp216_ = _tmp215_;
						_tmp217_ = vala_expression_statement_new ((ValaExpression*) _tmp214_, _tmp216_);
						_tmp218_ = _tmp217_;
						_vala_code_node_unref0 (_tmp214_);
						_vala_code_node_unref0 (_tmp210_);
						stmt = _tmp218_;
						_tmp219_ = vala_subroutine_get_body ((ValaSubroutine*) self);
						_tmp220_ = _tmp219_;
						_tmp221_ = stmt;
						vala_block_insert_statement (_tmp220_, 0, (ValaStatement*) _tmp221_);
						_tmp222_ = stmt;
						vala_code_node_check ((ValaCodeNode*) _tmp222_, context);
						_tmp223_ = vala_code_context_get_analyzer (context);
						_tmp224_ = _tmp223_;
						vala_semantic_analyzer_set_current_symbol (_tmp224_, (ValaSymbol*) self);
						_tmp225_ = vala_code_context_get_analyzer (context);
						_tmp226_ = _tmp225_;
						_tmp227_ = old_insert_block;
						_tmp228_ = _vala_code_node_ref0 (_tmp227_);
						_vala_code_node_unref0 (_tmp226_->insert_block);
						_tmp226_->insert_block = _tmp228_;
						_vala_code_node_unref0 (stmt);
						_vala_code_node_unref0 (old_insert_block);
					}
				}
			}
		}
		_vala_code_node_unref0 (cl);
	}
	_tmp229_ = vala_code_context_get_analyzer (context);
	_tmp230_ = _tmp229_;
	_tmp231_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp230_, _tmp231_);
	_tmp232_ = vala_code_context_get_analyzer (context);
	_tmp233_ = _tmp232_;
	_tmp234_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp233_, _tmp234_);
	_tmp237_ = vala_method_get_is_abstract ((ValaMethod*) self);
	_tmp238_ = _tmp237_;
	if (_tmp238_) {
		_tmp236_ = TRUE;
	} else {
		gboolean _tmp239_;
		gboolean _tmp240_;
		_tmp239_ = vala_method_get_is_virtual ((ValaMethod*) self);
		_tmp240_ = _tmp239_;
		_tmp236_ = _tmp240_;
	}
	if (_tmp236_) {
		_tmp235_ = TRUE;
	} else {
		gboolean _tmp241_;
		gboolean _tmp242_;
		_tmp241_ = vala_method_get_overrides ((ValaMethod*) self);
		_tmp242_ = _tmp241_;
		_tmp235_ = _tmp242_;
	}
	if (_tmp235_) {
		ValaSourceReference* _tmp243_;
		ValaSourceReference* _tmp244_;
		gchar* _tmp245_;
		gchar* _tmp246_;
		gchar* _tmp247_;
		gchar* _tmp248_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp244_ = _tmp243_;
		_tmp245_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp246_ = _tmp245_;
		_tmp247_ = g_strdup_printf ("The creation method `%s' cannot be marked as override, virtual, or abs" \
"tract", _tmp246_);
		_tmp248_ = _tmp247_;
		vala_report_error (_tmp244_, _tmp248_);
		_g_free0 (_tmp248_);
		_g_free0 (_tmp246_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp250_ = vala_subroutine_get_body ((ValaSubroutine*) self);
	_tmp251_ = _tmp250_;
	if (_tmp251_ != NULL) {
		ValaBlock* _tmp252_;
		ValaBlock* _tmp253_;
		gboolean _tmp254_;
		gboolean _tmp255_;
		_tmp252_ = vala_subroutine_get_body ((ValaSubroutine*) self);
		_tmp253_ = _tmp252_;
		_tmp254_ = vala_code_node_get_error ((ValaCodeNode*) _tmp253_);
		_tmp255_ = _tmp254_;
		_tmp249_ = !_tmp255_;
	} else {
		_tmp249_ = FALSE;
	}
	if (_tmp249_) {
		{
			ValaList* _body_error_type_list = NULL;
			ValaBlock* _tmp256_;
			ValaBlock* _tmp257_;
			ValaList* _tmp258_;
			gint _body_error_type_size = 0;
			ValaList* _tmp259_;
			gint _tmp260_;
			gint _tmp261_;
			gint _body_error_type_index = 0;
			_tmp256_ = vala_subroutine_get_body ((ValaSubroutine*) self);
			_tmp257_ = _tmp256_;
			_tmp258_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp257_);
			_body_error_type_list = _tmp258_;
			_tmp259_ = _body_error_type_list;
			_tmp260_ = vala_collection_get_size ((ValaCollection*) _tmp259_);
			_tmp261_ = _tmp260_;
			_body_error_type_size = _tmp261_;
			_body_error_type_index = -1;
			while (TRUE) {
				gint _tmp262_;
				gint _tmp263_;
				ValaDataType* body_error_type = NULL;
				ValaList* _tmp264_;
				gint _tmp265_;
				gpointer _tmp266_;
				gboolean can_propagate_error = FALSE;
				gboolean _tmp278_ = FALSE;
				gboolean _tmp279_;
				_body_error_type_index = _body_error_type_index + 1;
				_tmp262_ = _body_error_type_index;
				_tmp263_ = _body_error_type_size;
				if (!(_tmp262_ < _tmp263_)) {
					break;
				}
				_tmp264_ = _body_error_type_list;
				_tmp265_ = _body_error_type_index;
				_tmp266_ = vala_list_get (_tmp264_, _tmp265_);
				body_error_type = (ValaDataType*) _tmp266_;
				can_propagate_error = FALSE;
				{
					ValaList* _method_error_type_list = NULL;
					ValaList* _tmp267_;
					gint _method_error_type_size = 0;
					ValaList* _tmp268_;
					gint _tmp269_;
					gint _tmp270_;
					gint _method_error_type_index = 0;
					_tmp267_ = vala_code_node_get_error_types ((ValaCodeNode*) self);
					_method_error_type_list = _tmp267_;
					_tmp268_ = _method_error_type_list;
					_tmp269_ = vala_collection_get_size ((ValaCollection*) _tmp268_);
					_tmp270_ = _tmp269_;
					_method_error_type_size = _tmp270_;
					_method_error_type_index = -1;
					while (TRUE) {
						gint _tmp271_;
						gint _tmp272_;
						ValaDataType* method_error_type = NULL;
						ValaList* _tmp273_;
						gint _tmp274_;
						gpointer _tmp275_;
						ValaDataType* _tmp276_;
						ValaDataType* _tmp277_;
						_method_error_type_index = _method_error_type_index + 1;
						_tmp271_ = _method_error_type_index;
						_tmp272_ = _method_error_type_size;
						if (!(_tmp271_ < _tmp272_)) {
							break;
						}
						_tmp273_ = _method_error_type_list;
						_tmp274_ = _method_error_type_index;
						_tmp275_ = vala_list_get (_tmp273_, _tmp274_);
						method_error_type = (ValaDataType*) _tmp275_;
						_tmp276_ = body_error_type;
						_tmp277_ = method_error_type;
						if (vala_data_type_compatible (_tmp276_, _tmp277_)) {
							can_propagate_error = TRUE;
						}
						_vala_code_node_unref0 (method_error_type);
					}
					_vala_iterable_unref0 (_method_error_type_list);
				}
				_tmp279_ = can_propagate_error;
				if (!_tmp279_) {
					ValaDataType* _tmp280_;
					gboolean _tmp281_;
					gboolean _tmp282_;
					_tmp280_ = body_error_type;
					_tmp281_ = vala_error_type_get_dynamic_error (G_TYPE_CHECK_INSTANCE_CAST (_tmp280_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
					_tmp282_ = _tmp281_;
					_tmp278_ = !_tmp282_;
				} else {
					_tmp278_ = FALSE;
				}
				if (_tmp278_) {
					ValaDataType* _tmp283_;
					ValaSourceReference* _tmp284_;
					ValaSourceReference* _tmp285_;
					ValaDataType* _tmp286_;
					gchar* _tmp287_;
					gchar* _tmp288_;
					gchar* _tmp289_;
					gchar* _tmp290_;
					_tmp283_ = body_error_type;
					_tmp284_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = body_error_type;
					_tmp287_ = vala_code_node_to_string ((ValaCodeNode*) _tmp286_);
					_tmp288_ = _tmp287_;
					_tmp289_ = g_strdup_printf ("unhandled error `%s'", _tmp288_);
					_tmp290_ = _tmp289_;
					vala_report_warning (_tmp285_, _tmp290_);
					_g_free0 (_tmp290_);
					_g_free0 (_tmp288_);
				}
				_vala_code_node_unref0 (body_error_type);
			}
			_vala_iterable_unref0 (_body_error_type_list);
		}
	}
	_tmp291_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp292_ = _tmp291_;
	result = !_tmp292_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


const gchar*
vala_creation_method_get_class_name (ValaCreationMethod* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_name;
	result = _tmp0_;
	return result;
}


void
vala_creation_method_set_class_name (ValaCreationMethod* self,
                                     const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_class_name);
	self->priv->_class_name = _tmp0_;
}


gboolean
vala_creation_method_get_chain_up (ValaCreationMethod* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_chain_up;
	result = _tmp0_;
	return result;
}


void
vala_creation_method_set_chain_up (ValaCreationMethod* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_chain_up = value;
}


static void
vala_creation_method_class_init (ValaCreationMethodClass * klass)
{
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_creation_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_creation_method_real_accept_children;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_creation_method_real_check;
}


static void
vala_creation_method_instance_init (ValaCreationMethod * self)
{
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void
vala_creation_method_finalize (ValaCodeNode * obj)
{
	ValaCreationMethod * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CREATION_METHOD, ValaCreationMethod);
	_g_free0 (self->priv->_class_name);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}


/**
 * Represents a type creation method.
 */
GType
vala_creation_method_get_type (void)
{
	static volatile gsize vala_creation_method_type_id__volatile = 0;
	if (g_once_init_enter (&vala_creation_method_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		GType vala_creation_method_type_id;
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
		g_once_init_leave (&vala_creation_method_type_id__volatile, vala_creation_method_type_id);
	}
	return vala_creation_method_type_id__volatile;
}



