/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};


static gpointer vala_class_parent_class = NULL;

#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
	_tmp69_ = vala_method_get_base_interface_type (m);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaScope* _tmp71_;
		ValaScope* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValaScope* _tmp75_;
		ValaScope* _tmp76_;
		_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp74_ = _tmp73_;
		vala_scope_remove (_tmp72_, _tmp74_);
		_tmp75_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_scope_add (_tmp76_, NULL, (ValaSymbol*) m);
	}
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}


static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp2_;
		ValaConstructor* _tmp3_;
		_tmp2_ = vala_class_get_constructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_constructor_get_binding (c);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp8_;
			ValaConstructor* _tmp9_;
			_tmp8_ = vala_class_get_class_constructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			ValaConstructor* _tmp12_;
			ValaConstructor* _tmp13_;
			_tmp12_ = vala_class_get_static_constructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp2_;
		ValaDestructor* _tmp3_;
		_tmp2_ = vala_class_get_destructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_destructor_get_binding (d);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp8_;
			ValaDestructor* _tmp9_;
			_tmp8_ = vala_class_get_class_destructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			ValaDestructor* _tmp12_;
			ValaDestructor* _tmp13_;
			_tmp12_ = vala_class_get_static_destructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp81_;
	ValaConstructor* _tmp82_;
	ValaConstructor* _tmp85_;
	ValaConstructor* _tmp86_;
	ValaConstructor* _tmp89_;
	ValaConstructor* _tmp90_;
	ValaDestructor* _tmp93_;
	ValaDestructor* _tmp94_;
	ValaDestructor* _tmp97_;
	ValaDestructor* _tmp98_;
	ValaDestructor* _tmp101_;
	ValaDestructor* _tmp102_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			_type_index = _type_index + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = _type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type = (ValaDataType*) _tmp9_;
			_tmp10_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp10_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp11_;
		gint _p_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _p_index = 0;
		_tmp11_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp11_;
		_tmp12_ = _p_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_p_size = _tmp14_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValaTypeParameter* _tmp20_;
			_p_index = _p_index + 1;
			_tmp15_ = _p_index;
			_tmp16_ = _p_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _p_list;
			_tmp18_ = _p_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			p = (ValaTypeParameter*) _tmp19_;
			_tmp20_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp20_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp21_;
		gint _en_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _en_index = 0;
		_tmp21_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp21_;
		_tmp22_ = _en_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_en_size = _tmp24_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			ValaEnum* en = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaEnum* _tmp30_;
			_en_index = _en_index + 1;
			_tmp25_ = _en_index;
			_tmp26_ = _en_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _en_list;
			_tmp28_ = _en_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			en = (ValaEnum*) _tmp29_;
			_tmp30_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp30_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp31_;
		gint _f_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _f_index = 0;
		_tmp31_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp31_;
		_tmp32_ = _f_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_f_size = _tmp34_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			ValaField* f = NULL;
			ValaList* _tmp37_;
			gint _tmp38_;
			gpointer _tmp39_;
			ValaField* _tmp40_;
			_f_index = _f_index + 1;
			_tmp35_ = _f_index;
			_tmp36_ = _f_size;
			if (!(_tmp35_ < _tmp36_)) {
				break;
			}
			_tmp37_ = _f_list;
			_tmp38_ = _f_index;
			_tmp39_ = vala_list_get (_tmp37_, _tmp38_);
			f = (ValaField*) _tmp39_;
			_tmp40_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp40_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp41_;
		gint _c_size = 0;
		ValaList* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gint _c_index = 0;
		_tmp41_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp41_;
		_tmp42_ = _c_list;
		_tmp43_ = vala_collection_get_size ((ValaCollection*) _tmp42_);
		_tmp44_ = _tmp43_;
		_c_size = _tmp44_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp45_;
			gint _tmp46_;
			ValaConstant* c = NULL;
			ValaList* _tmp47_;
			gint _tmp48_;
			gpointer _tmp49_;
			ValaConstant* _tmp50_;
			_c_index = _c_index + 1;
			_tmp45_ = _c_index;
			_tmp46_ = _c_size;
			if (!(_tmp45_ < _tmp46_)) {
				break;
			}
			_tmp47_ = _c_list;
			_tmp48_ = _c_index;
			_tmp49_ = vala_list_get (_tmp47_, _tmp48_);
			c = (ValaConstant*) _tmp49_;
			_tmp50_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp50_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp51_;
		gint _m_size = 0;
		ValaList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
		gint _m_index = 0;
		_tmp51_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp51_;
		_tmp52_ = _m_list;
		_tmp53_ = vala_collection_get_size ((ValaCollection*) _tmp52_);
		_tmp54_ = _tmp53_;
		_m_size = _tmp54_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp55_;
			gint _tmp56_;
			ValaMethod* m = NULL;
			ValaList* _tmp57_;
			gint _tmp58_;
			gpointer _tmp59_;
			ValaMethod* _tmp60_;
			_m_index = _m_index + 1;
			_tmp55_ = _m_index;
			_tmp56_ = _m_size;
			if (!(_tmp55_ < _tmp56_)) {
				break;
			}
			_tmp57_ = _m_list;
			_tmp58_ = _m_index;
			_tmp59_ = vala_list_get (_tmp57_, _tmp58_);
			m = (ValaMethod*) _tmp59_;
			_tmp60_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp60_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp61_;
		gint _prop_size = 0;
		ValaList* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		gint _prop_index = 0;
		_tmp61_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp61_;
		_tmp62_ = _prop_list;
		_tmp63_ = vala_collection_get_size ((ValaCollection*) _tmp62_);
		_tmp64_ = _tmp63_;
		_prop_size = _tmp64_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp65_;
			gint _tmp66_;
			ValaProperty* prop = NULL;
			ValaList* _tmp67_;
			gint _tmp68_;
			gpointer _tmp69_;
			ValaProperty* _tmp70_;
			_prop_index = _prop_index + 1;
			_tmp65_ = _prop_index;
			_tmp66_ = _prop_size;
			if (!(_tmp65_ < _tmp66_)) {
				break;
			}
			_tmp67_ = _prop_list;
			_tmp68_ = _prop_index;
			_tmp69_ = vala_list_get (_tmp67_, _tmp68_);
			prop = (ValaProperty*) _tmp69_;
			_tmp70_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp70_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp71_;
		gint _sig_size = 0;
		ValaList* _tmp72_;
		gint _tmp73_;
		gint _tmp74_;
		gint _sig_index = 0;
		_tmp71_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp71_;
		_tmp72_ = _sig_list;
		_tmp73_ = vala_collection_get_size ((ValaCollection*) _tmp72_);
		_tmp74_ = _tmp73_;
		_sig_size = _tmp74_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp75_;
			gint _tmp76_;
			ValaSignal* sig = NULL;
			ValaList* _tmp77_;
			gint _tmp78_;
			gpointer _tmp79_;
			ValaSignal* _tmp80_;
			_sig_index = _sig_index + 1;
			_tmp75_ = _sig_index;
			_tmp76_ = _sig_size;
			if (!(_tmp75_ < _tmp76_)) {
				break;
			}
			_tmp77_ = _sig_list;
			_tmp78_ = _sig_index;
			_tmp79_ = vala_list_get (_tmp77_, _tmp78_);
			sig = (ValaSignal*) _tmp79_;
			_tmp80_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp80_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp81_ = vala_class_get_constructor (self);
	_tmp82_ = _tmp81_;
	if (_tmp82_ != NULL) {
		ValaConstructor* _tmp83_;
		ValaConstructor* _tmp84_;
		_tmp83_ = vala_class_get_constructor (self);
		_tmp84_ = _tmp83_;
		vala_code_node_accept ((ValaCodeNode*) _tmp84_, visitor);
	}
	_tmp85_ = vala_class_get_class_constructor (self);
	_tmp86_ = _tmp85_;
	if (_tmp86_ != NULL) {
		ValaConstructor* _tmp87_;
		ValaConstructor* _tmp88_;
		_tmp87_ = vala_class_get_class_constructor (self);
		_tmp88_ = _tmp87_;
		vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
	}
	_tmp89_ = vala_class_get_static_constructor (self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaConstructor* _tmp91_;
		ValaConstructor* _tmp92_;
		_tmp91_ = vala_class_get_static_constructor (self);
		_tmp92_ = _tmp91_;
		vala_code_node_accept ((ValaCodeNode*) _tmp92_, visitor);
	}
	_tmp93_ = vala_class_get_destructor (self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaDestructor* _tmp95_;
		ValaDestructor* _tmp96_;
		_tmp95_ = vala_class_get_destructor (self);
		_tmp96_ = _tmp95_;
		vala_code_node_accept ((ValaCodeNode*) _tmp96_, visitor);
	}
	_tmp97_ = vala_class_get_static_destructor (self);
	_tmp98_ = _tmp97_;
	if (_tmp98_ != NULL) {
		ValaDestructor* _tmp99_;
		ValaDestructor* _tmp100_;
		_tmp99_ = vala_class_get_static_destructor (self);
		_tmp100_ = _tmp99_;
		vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
	}
	_tmp101_ = vala_class_get_class_destructor (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_ != NULL) {
		ValaDestructor* _tmp103_;
		ValaDestructor* _tmp104_;
		_tmp103_ = vala_class_get_class_destructor (self);
		_tmp104_ = _tmp103_;
		vala_code_node_accept ((ValaCodeNode*) _tmp104_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp105_;
		gint _cl_size = 0;
		ValaList* _tmp106_;
		gint _tmp107_;
		gint _tmp108_;
		gint _cl_index = 0;
		_tmp105_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp105_;
		_tmp106_ = _cl_list;
		_tmp107_ = vala_collection_get_size ((ValaCollection*) _tmp106_);
		_tmp108_ = _tmp107_;
		_cl_size = _tmp108_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp109_;
			gint _tmp110_;
			ValaClass* cl = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaClass* _tmp114_;
			_cl_index = _cl_index + 1;
			_tmp109_ = _cl_index;
			_tmp110_ = _cl_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _cl_list;
			_tmp112_ = _cl_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			cl = (ValaClass*) _tmp113_;
			_tmp114_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp114_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp115_;
		gint _st_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _st_index = 0;
		_tmp115_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp115_;
		_tmp116_ = _st_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_st_size = _tmp118_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			ValaStruct* st = NULL;
			ValaList* _tmp121_;
			gint _tmp122_;
			gpointer _tmp123_;
			ValaStruct* _tmp124_;
			_st_index = _st_index + 1;
			_tmp119_ = _st_index;
			_tmp120_ = _st_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _st_list;
			_tmp122_ = _st_index;
			_tmp123_ = vala_list_get (_tmp121_, _tmp122_);
			st = (ValaStruct*) _tmp123_;
			_tmp124_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp124_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp125_;
		gint _d_size = 0;
		ValaList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _d_index = 0;
		_tmp125_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp125_;
		_tmp126_ = _d_list;
		_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
		_tmp128_ = _tmp127_;
		_d_size = _tmp128_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp129_;
			gint _tmp130_;
			ValaDelegate* d = NULL;
			ValaList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_;
			ValaDelegate* _tmp134_;
			_d_index = _d_index + 1;
			_tmp129_ = _d_index;
			_tmp130_ = _d_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _d_list;
			_tmp132_ = _d_index;
			_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
			d = (ValaDelegate*) _tmp133_;
			_tmp134_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp134_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_base_type_index = _base_type_index + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp12_ = base_type;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = _tmp17_ != G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				ValaDataType* _tmp18_;
				ValaTypeSymbol* _tmp19_;
				ValaTypeSymbol* _tmp20_;
				_tmp18_ = base_type;
				_tmp19_ = vala_data_type_get_data_type (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp10_ = vala_typesymbol_is_subtype_of (_tmp20_, t);
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->base_types;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			_prereq_index = _prereq_index + 1;
			_tmp4_ = _prereq_index;
			_tmp5_ = _prereq_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _prereq_list;
			_tmp7_ = _prereq_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			prereq = (ValaDataType*) _tmp8_;
			_tmp9_ = prereq;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = _vala_code_node_ref0 (_tmp11_);
			type = _tmp12_;
			_tmp13_ = type;
			if (_tmp13_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp14_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp14_);
			_tmp15_ = type;
			if (VALA_IS_INTERFACE (_tmp15_)) {
				ValaTypeSymbol* _tmp16_;
				_tmp16_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = _base_type_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			base_type = (ValaDataType*) _tmp8_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			if (VALA_IS_CLASS (_tmp11_)) {
				ValaDataType* _tmp12_;
				ValaTypeSymbol* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				_tmp12_ = base_type;
				_tmp13_ = vala_data_type_get_data_type (_tmp12_);
				_tmp14_ = _tmp13_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				if (_tmp17_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp6_;
			gint _tmp7_;
			gpointer _tmp8_;
			ValaDataType* _tmp9_;
			ValaTypeSymbol* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			_base_type_index = _base_type_index + 1;
			_tmp4_ = _base_type_index;
			_tmp5_ = _base_type_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _base_type_list;
			_tmp7_ = _base_type_index;
			_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
			base_type = (ValaDataType*) _tmp8_;
			_tmp9_ = base_type;
			_tmp10_ = vala_data_type_get_data_type (_tmp9_);
			_tmp11_ = _tmp10_;
			if (_tmp11_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaConstructor* _tmp192_;
	ValaConstructor* _tmp193_;
	ValaConstructor* _tmp196_;
	ValaConstructor* _tmp197_;
	ValaConstructor* _tmp200_;
	ValaConstructor* _tmp201_;
	ValaDestructor* _tmp204_;
	ValaDestructor* _tmp205_;
	ValaDestructor* _tmp208_;
	ValaDestructor* _tmp209_;
	ValaDestructor* _tmp212_;
	ValaDestructor* _tmp213_;
	gboolean _tmp246_;
	gboolean _tmp247_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp292_;
	ValaArrayList* _tmp293_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp310_;
	ValaArrayList* _tmp311_;
	ValaList* _tmp327_;
	gint _tmp328_;
	gint _tmp329_;
	ValaSourceFileType _tmp356_;
	ValaSourceFileType _tmp357_;
	ValaSemanticAnalyzer* _tmp577_;
	ValaSemanticAnalyzer* _tmp578_;
	ValaSourceFile* _tmp579_;
	ValaSemanticAnalyzer* _tmp580_;
	ValaSemanticAnalyzer* _tmp581_;
	ValaSymbol* _tmp582_;
	gboolean _tmp583_;
	gboolean _tmp584_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaDataType* _tmp33_;
			ValaDataType* _tmp34_;
			ValaSemanticAnalyzer* _tmp44_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaDataType* _tmp46_;
			gint n_type_args = 0;
			ValaDataType* _tmp56_;
			ValaList* _tmp57_;
			ValaList* _tmp58_;
			gint _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint n_type_params = 0;
			ValaDataType* _tmp62_;
			ValaTypeSymbol* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaList* _tmp65_;
			ValaList* _tmp66_;
			gint _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			_base_type_reference_index = _base_type_reference_index + 1;
			_tmp28_ = _base_type_reference_index;
			_tmp29_ = _base_type_reference_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _base_type_reference_list;
			_tmp31_ = _base_type_reference_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			base_type_reference = (ValaDataType*) _tmp32_;
			_tmp33_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp33_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp34_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp34_)) {
				ValaSourceReference* _tmp35_;
				ValaSourceReference* _tmp36_;
				ValaDataType* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp36_ = _tmp35_;
				_tmp37_ = base_type_reference;
				_tmp38_ = vala_code_node_to_string ((ValaCodeNode*) _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp41_ = _tmp40_;
				_tmp42_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp39_, _tmp41_);
				_tmp43_ = _tmp42_;
				vala_report_error (_tmp36_, _tmp43_);
				_g_free0 (_tmp43_);
				_g_free0 (_tmp41_);
				_g_free0 (_tmp39_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp44_ = vala_code_context_get_analyzer (context);
			_tmp45_ = _tmp44_;
			_tmp46_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp45_, (ValaSymbol*) self, _tmp46_)) {
				ValaSourceReference* _tmp47_;
				ValaSourceReference* _tmp48_;
				ValaDataType* _tmp49_;
				gchar* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp47_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp48_ = _tmp47_;
				_tmp49_ = base_type_reference;
				_tmp50_ = vala_code_node_to_string ((ValaCodeNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp53_ = _tmp52_;
				_tmp54_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp51_, _tmp53_);
				_tmp55_ = _tmp54_;
				vala_report_error (_tmp48_, _tmp55_);
				_g_free0 (_tmp55_);
				_g_free0 (_tmp53_);
				_g_free0 (_tmp51_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp56_ = base_type_reference;
			_tmp57_ = vala_data_type_get_type_arguments (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = vala_collection_get_size ((ValaCollection*) _tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = _tmp60_;
			_vala_iterable_unref0 (_tmp58_);
			n_type_args = _tmp61_;
			_tmp62_ = base_type_reference;
			_tmp63_ = vala_data_type_get_data_type (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_collection_get_size ((ValaCollection*) _tmp66_);
			_tmp68_ = _tmp67_;
			_tmp69_ = _tmp68_;
			_vala_iterable_unref0 (_tmp66_);
			n_type_params = _tmp69_;
			_tmp70_ = n_type_args;
			_tmp71_ = n_type_params;
			if (_tmp70_ < _tmp71_) {
				ValaDataType* _tmp72_;
				ValaSourceReference* _tmp73_;
				ValaSourceReference* _tmp74_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp72_ = base_type_reference;
				_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp72_);
				_tmp74_ = _tmp73_;
				vala_report_error (_tmp74_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp75_;
				gint _tmp76_;
				_tmp75_ = n_type_args;
				_tmp76_ = n_type_params;
				if (_tmp75_ > _tmp76_) {
					ValaDataType* _tmp77_;
					ValaSourceReference* _tmp78_;
					ValaSourceReference* _tmp79_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp77_ = base_type_reference;
					_tmp78_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp77_);
					_tmp79_ = _tmp78_;
					vala_report_error (_tmp79_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp80_;
		ValaList* _tmp81_;
		gint _type_size = 0;
		ValaList* _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _type_index = 0;
		_tmp80_ = self->priv->base_types;
		_tmp81_ = _vala_iterable_ref0 (_tmp80_);
		_type_list = _tmp81_;
		_tmp82_ = _type_list;
		_tmp83_ = vala_collection_get_size ((ValaCollection*) _tmp82_);
		_tmp84_ = _tmp83_;
		_type_size = _tmp84_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp85_;
			gint _tmp86_;
			ValaDataType* type = NULL;
			ValaList* _tmp87_;
			gint _tmp88_;
			gpointer _tmp89_;
			ValaDataType* _tmp90_;
			_type_index = _type_index + 1;
			_tmp85_ = _type_index;
			_tmp86_ = _type_size;
			if (!(_tmp85_ < _tmp86_)) {
				break;
			}
			_tmp87_ = _type_list;
			_tmp88_ = _type_index;
			_tmp89_ = vala_list_get (_tmp87_, _tmp88_);
			type = (ValaDataType*) _tmp89_;
			_tmp90_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp90_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp91_;
		gint _p_size = 0;
		ValaList* _tmp92_;
		gint _tmp93_;
		gint _tmp94_;
		gint _p_index = 0;
		_tmp91_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp91_;
		_tmp92_ = _p_list;
		_tmp93_ = vala_collection_get_size ((ValaCollection*) _tmp92_);
		_tmp94_ = _tmp93_;
		_p_size = _tmp94_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp95_;
			gint _tmp96_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp97_;
			gint _tmp98_;
			gpointer _tmp99_;
			ValaTypeParameter* _tmp100_;
			_p_index = _p_index + 1;
			_tmp95_ = _p_index;
			_tmp96_ = _p_size;
			if (!(_tmp95_ < _tmp96_)) {
				break;
			}
			_tmp97_ = _p_list;
			_tmp98_ = _p_index;
			_tmp99_ = vala_list_get (_tmp97_, _tmp98_);
			p = (ValaTypeParameter*) _tmp99_;
			_tmp100_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp100_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp101_;
		gint _en_size = 0;
		ValaList* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		gint _en_index = 0;
		_tmp101_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp101_;
		_tmp102_ = _en_list;
		_tmp103_ = vala_collection_get_size ((ValaCollection*) _tmp102_);
		_tmp104_ = _tmp103_;
		_en_size = _tmp104_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp105_;
			gint _tmp106_;
			ValaEnum* en = NULL;
			ValaList* _tmp107_;
			gint _tmp108_;
			gpointer _tmp109_;
			ValaEnum* _tmp110_;
			_en_index = _en_index + 1;
			_tmp105_ = _en_index;
			_tmp106_ = _en_size;
			if (!(_tmp105_ < _tmp106_)) {
				break;
			}
			_tmp107_ = _en_list;
			_tmp108_ = _en_index;
			_tmp109_ = vala_list_get (_tmp107_, _tmp108_);
			en = (ValaEnum*) _tmp109_;
			_tmp110_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp110_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp111_;
		gint _f_size = 0;
		ValaList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _f_index = 0;
		_tmp111_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp111_;
		_tmp112_ = _f_list;
		_tmp113_ = vala_collection_get_size ((ValaCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_f_size = _tmp114_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			ValaField* f = NULL;
			ValaList* _tmp117_;
			gint _tmp118_;
			gpointer _tmp119_;
			gboolean _tmp120_ = FALSE;
			gboolean _tmp121_;
			gboolean _tmp122_;
			ValaField* _tmp140_;
			_f_index = _f_index + 1;
			_tmp115_ = _f_index;
			_tmp116_ = _f_size;
			if (!(_tmp115_ < _tmp116_)) {
				break;
			}
			_tmp117_ = _f_list;
			_tmp118_ = _f_index;
			_tmp119_ = vala_list_get (_tmp117_, _tmp118_);
			f = (ValaField*) _tmp119_;
			_tmp121_ = vala_class_get_is_compact (self);
			_tmp122_ = _tmp121_;
			if (_tmp122_) {
				ValaField* _tmp123_;
				ValaMemberBinding _tmp124_;
				ValaMemberBinding _tmp125_;
				_tmp123_ = f;
				_tmp124_ = vala_field_get_binding (_tmp123_);
				_tmp125_ = _tmp124_;
				_tmp120_ = _tmp125_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp120_ = FALSE;
			}
			if (_tmp120_) {
				gboolean _tmp126_ = FALSE;
				gboolean _tmp127_;
				gboolean _tmp128_;
				ValaField* _tmp134_;
				ValaMemberBinding _tmp135_;
				ValaMemberBinding _tmp136_;
				_tmp127_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp128_ = _tmp127_;
				if (!_tmp128_) {
					ValaField* _tmp129_;
					ValaSymbolAccessibility _tmp130_;
					ValaSymbolAccessibility _tmp131_;
					_tmp129_ = f;
					_tmp130_ = vala_symbol_get_access ((ValaSymbol*) _tmp129_);
					_tmp131_ = _tmp130_;
					_tmp126_ = _tmp131_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp126_ = FALSE;
				}
				if (_tmp126_) {
					ValaSourceReference* _tmp132_;
					ValaSourceReference* _tmp133_;
					_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp133_ = _tmp132_;
					vala_report_error (_tmp133_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp134_ = f;
				_tmp135_ = vala_field_get_binding (_tmp134_);
				_tmp136_ = _tmp135_;
				if (_tmp136_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp137_;
					ValaSourceReference* _tmp138_;
					ValaSourceReference* _tmp139_;
					_tmp137_ = f;
					_tmp138_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp137_);
					_tmp139_ = _tmp138_;
					vala_report_error (_tmp139_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp140_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp140_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp141_;
		gint _c_size = 0;
		ValaList* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gint _c_index = 0;
		_tmp141_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp141_;
		_tmp142_ = _c_list;
		_tmp143_ = vala_collection_get_size ((ValaCollection*) _tmp142_);
		_tmp144_ = _tmp143_;
		_c_size = _tmp144_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp145_;
			gint _tmp146_;
			ValaConstant* c = NULL;
			ValaList* _tmp147_;
			gint _tmp148_;
			gpointer _tmp149_;
			ValaConstant* _tmp150_;
			_c_index = _c_index + 1;
			_tmp145_ = _c_index;
			_tmp146_ = _c_size;
			if (!(_tmp145_ < _tmp146_)) {
				break;
			}
			_tmp147_ = _c_list;
			_tmp148_ = _c_index;
			_tmp149_ = vala_list_get (_tmp147_, _tmp148_);
			c = (ValaConstant*) _tmp149_;
			_tmp150_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp150_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp151_;
		gint _m_size = 0;
		ValaList* _tmp152_;
		gint _tmp153_;
		gint _tmp154_;
		gint _m_index = 0;
		_tmp151_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp151_;
		_tmp152_ = _m_list;
		_tmp153_ = vala_collection_get_size ((ValaCollection*) _tmp152_);
		_tmp154_ = _tmp153_;
		_m_size = _tmp154_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp155_;
			gint _tmp156_;
			ValaMethod* m = NULL;
			ValaList* _tmp157_;
			gint _tmp158_;
			gpointer _tmp159_;
			ValaMethod* _tmp160_;
			_m_index = _m_index + 1;
			_tmp155_ = _m_index;
			_tmp156_ = _m_size;
			if (!(_tmp155_ < _tmp156_)) {
				break;
			}
			_tmp157_ = _m_list;
			_tmp158_ = _m_index;
			_tmp159_ = vala_list_get (_tmp157_, _tmp158_);
			m = (ValaMethod*) _tmp159_;
			_tmp160_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp160_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp161_;
		gint _prop_size = 0;
		ValaList* _tmp162_;
		gint _tmp163_;
		gint _tmp164_;
		gint _prop_index = 0;
		_tmp161_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp161_;
		_tmp162_ = _prop_list;
		_tmp163_ = vala_collection_get_size ((ValaCollection*) _tmp162_);
		_tmp164_ = _tmp163_;
		_prop_size = _tmp164_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp165_;
			gint _tmp166_;
			ValaProperty* prop = NULL;
			ValaList* _tmp167_;
			gint _tmp168_;
			gpointer _tmp169_;
			gboolean _tmp170_ = FALSE;
			ValaProperty* _tmp171_;
			ValaAttribute* _tmp172_;
			ValaAttribute* _tmp173_;
			gboolean _tmp174_;
			ValaProperty* _tmp181_;
			_prop_index = _prop_index + 1;
			_tmp165_ = _prop_index;
			_tmp166_ = _prop_size;
			if (!(_tmp165_ < _tmp166_)) {
				break;
			}
			_tmp167_ = _prop_list;
			_tmp168_ = _prop_index;
			_tmp169_ = vala_list_get (_tmp167_, _tmp168_);
			prop = (ValaProperty*) _tmp169_;
			_tmp171_ = prop;
			_tmp172_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp171_, "NoAccessorMethod");
			_tmp173_ = _tmp172_;
			_tmp174_ = _tmp173_ != NULL;
			_vala_code_node_unref0 (_tmp173_);
			if (_tmp174_) {
				ValaSemanticAnalyzer* _tmp175_;
				ValaSemanticAnalyzer* _tmp176_;
				ValaClass* _tmp177_;
				_tmp175_ = vala_code_context_get_analyzer (context);
				_tmp176_ = _tmp175_;
				_tmp177_ = _tmp176_->object_type;
				_tmp170_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp177_);
			} else {
				_tmp170_ = FALSE;
			}
			if (_tmp170_) {
				ValaProperty* _tmp178_;
				ValaSourceReference* _tmp179_;
				ValaSourceReference* _tmp180_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp178_ = prop;
				_tmp179_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp178_);
				_tmp180_ = _tmp179_;
				vala_report_error (_tmp180_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp181_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp181_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp182_;
		gint _sig_size = 0;
		ValaList* _tmp183_;
		gint _tmp184_;
		gint _tmp185_;
		gint _sig_index = 0;
		_tmp182_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp182_;
		_tmp183_ = _sig_list;
		_tmp184_ = vala_collection_get_size ((ValaCollection*) _tmp183_);
		_tmp185_ = _tmp184_;
		_sig_size = _tmp185_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp186_;
			gint _tmp187_;
			ValaSignal* sig = NULL;
			ValaList* _tmp188_;
			gint _tmp189_;
			gpointer _tmp190_;
			ValaSignal* _tmp191_;
			_sig_index = _sig_index + 1;
			_tmp186_ = _sig_index;
			_tmp187_ = _sig_size;
			if (!(_tmp186_ < _tmp187_)) {
				break;
			}
			_tmp188_ = _sig_list;
			_tmp189_ = _sig_index;
			_tmp190_ = vala_list_get (_tmp188_, _tmp189_);
			sig = (ValaSignal*) _tmp190_;
			_tmp191_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp191_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp192_ = vala_class_get_constructor (self);
	_tmp193_ = _tmp192_;
	if (_tmp193_ != NULL) {
		ValaConstructor* _tmp194_;
		ValaConstructor* _tmp195_;
		_tmp194_ = vala_class_get_constructor (self);
		_tmp195_ = _tmp194_;
		vala_code_node_check ((ValaCodeNode*) _tmp195_, context);
	}
	_tmp196_ = vala_class_get_class_constructor (self);
	_tmp197_ = _tmp196_;
	if (_tmp197_ != NULL) {
		ValaConstructor* _tmp198_;
		ValaConstructor* _tmp199_;
		_tmp198_ = vala_class_get_class_constructor (self);
		_tmp199_ = _tmp198_;
		vala_code_node_check ((ValaCodeNode*) _tmp199_, context);
	}
	_tmp200_ = vala_class_get_static_constructor (self);
	_tmp201_ = _tmp200_;
	if (_tmp201_ != NULL) {
		ValaConstructor* _tmp202_;
		ValaConstructor* _tmp203_;
		_tmp202_ = vala_class_get_static_constructor (self);
		_tmp203_ = _tmp202_;
		vala_code_node_check ((ValaCodeNode*) _tmp203_, context);
	}
	_tmp204_ = vala_class_get_destructor (self);
	_tmp205_ = _tmp204_;
	if (_tmp205_ != NULL) {
		ValaDestructor* _tmp206_;
		ValaDestructor* _tmp207_;
		_tmp206_ = vala_class_get_destructor (self);
		_tmp207_ = _tmp206_;
		vala_code_node_check ((ValaCodeNode*) _tmp207_, context);
	}
	_tmp208_ = vala_class_get_static_destructor (self);
	_tmp209_ = _tmp208_;
	if (_tmp209_ != NULL) {
		ValaDestructor* _tmp210_;
		ValaDestructor* _tmp211_;
		_tmp210_ = vala_class_get_static_destructor (self);
		_tmp211_ = _tmp210_;
		vala_code_node_check ((ValaCodeNode*) _tmp211_, context);
	}
	_tmp212_ = vala_class_get_class_destructor (self);
	_tmp213_ = _tmp212_;
	if (_tmp213_ != NULL) {
		ValaDestructor* _tmp214_;
		ValaDestructor* _tmp215_;
		_tmp214_ = vala_class_get_class_destructor (self);
		_tmp215_ = _tmp214_;
		vala_code_node_check ((ValaCodeNode*) _tmp215_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp216_;
		gint _cl_size = 0;
		ValaList* _tmp217_;
		gint _tmp218_;
		gint _tmp219_;
		gint _cl_index = 0;
		_tmp216_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp216_;
		_tmp217_ = _cl_list;
		_tmp218_ = vala_collection_get_size ((ValaCollection*) _tmp217_);
		_tmp219_ = _tmp218_;
		_cl_size = _tmp219_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp220_;
			gint _tmp221_;
			ValaClass* cl = NULL;
			ValaList* _tmp222_;
			gint _tmp223_;
			gpointer _tmp224_;
			ValaClass* _tmp225_;
			_cl_index = _cl_index + 1;
			_tmp220_ = _cl_index;
			_tmp221_ = _cl_size;
			if (!(_tmp220_ < _tmp221_)) {
				break;
			}
			_tmp222_ = _cl_list;
			_tmp223_ = _cl_index;
			_tmp224_ = vala_list_get (_tmp222_, _tmp223_);
			cl = (ValaClass*) _tmp224_;
			_tmp225_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp225_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp226_;
		gint _st_size = 0;
		ValaList* _tmp227_;
		gint _tmp228_;
		gint _tmp229_;
		gint _st_index = 0;
		_tmp226_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp226_;
		_tmp227_ = _st_list;
		_tmp228_ = vala_collection_get_size ((ValaCollection*) _tmp227_);
		_tmp229_ = _tmp228_;
		_st_size = _tmp229_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp230_;
			gint _tmp231_;
			ValaStruct* st = NULL;
			ValaList* _tmp232_;
			gint _tmp233_;
			gpointer _tmp234_;
			ValaStruct* _tmp235_;
			_st_index = _st_index + 1;
			_tmp230_ = _st_index;
			_tmp231_ = _st_size;
			if (!(_tmp230_ < _tmp231_)) {
				break;
			}
			_tmp232_ = _st_list;
			_tmp233_ = _st_index;
			_tmp234_ = vala_list_get (_tmp232_, _tmp233_);
			st = (ValaStruct*) _tmp234_;
			_tmp235_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp235_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp236_;
		gint _d_size = 0;
		ValaList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _d_index = 0;
		_tmp236_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp236_;
		_tmp237_ = _d_list;
		_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_d_size = _tmp239_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			ValaDelegate* d = NULL;
			ValaList* _tmp242_;
			gint _tmp243_;
			gpointer _tmp244_;
			ValaDelegate* _tmp245_;
			_d_index = _d_index + 1;
			_tmp240_ = _d_index;
			_tmp241_ = _d_size;
			if (!(_tmp240_ < _tmp241_)) {
				break;
			}
			_tmp242_ = _d_list;
			_tmp243_ = _d_index;
			_tmp244_ = vala_list_get (_tmp242_, _tmp243_);
			d = (ValaDelegate*) _tmp244_;
			_tmp245_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp245_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp246_ = vala_class_get_is_compact (self);
	_tmp247_ = _tmp246_;
	if (_tmp247_) {
		gboolean _tmp266_ = FALSE;
		gboolean _tmp267_ = FALSE;
		gboolean _tmp268_ = FALSE;
		gboolean _tmp269_;
		gboolean _tmp270_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp248_;
			gint _base_type_size = 0;
			ValaList* _tmp249_;
			gint _tmp250_;
			gint _tmp251_;
			gint _base_type_index = 0;
			_tmp248_ = vala_class_get_base_types (self);
			_base_type_list = _tmp248_;
			_tmp249_ = _base_type_list;
			_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
			_tmp251_ = _tmp250_;
			_base_type_size = _tmp251_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp252_;
				gint _tmp253_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp254_;
				gint _tmp255_;
				gpointer _tmp256_;
				ValaDataType* _tmp257_;
				ValaTypeSymbol* _tmp258_;
				ValaTypeSymbol* _tmp259_;
				_base_type_index = _base_type_index + 1;
				_tmp252_ = _base_type_index;
				_tmp253_ = _base_type_size;
				if (!(_tmp252_ < _tmp253_)) {
					break;
				}
				_tmp254_ = _base_type_list;
				_tmp255_ = _base_type_index;
				_tmp256_ = vala_list_get (_tmp254_, _tmp255_);
				base_type = (ValaDataType*) _tmp256_;
				_tmp257_ = base_type;
				_tmp258_ = vala_data_type_get_data_type (_tmp257_);
				_tmp259_ = _tmp258_;
				if (VALA_IS_INTERFACE (_tmp259_)) {
					ValaSourceReference* _tmp260_;
					ValaSourceReference* _tmp261_;
					gchar* _tmp262_;
					gchar* _tmp263_;
					gchar* _tmp264_;
					gchar* _tmp265_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp261_ = _tmp260_;
					_tmp262_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp263_ = _tmp262_;
					_tmp264_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp263_);
					_tmp265_ = _tmp264_;
					vala_report_error (_tmp261_, _tmp265_);
					_g_free0 (_tmp265_);
					_g_free0 (_tmp263_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp269_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp270_ = _tmp269_;
		if (!_tmp270_) {
			gboolean _tmp271_;
			gboolean _tmp272_;
			_tmp271_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp272_ = _tmp271_;
			_tmp268_ = !_tmp272_;
		} else {
			_tmp268_ = FALSE;
		}
		if (_tmp268_) {
			ValaClass* _tmp273_;
			_tmp273_ = self->priv->_base_class;
			_tmp267_ = _tmp273_ != NULL;
		} else {
			_tmp267_ = FALSE;
		}
		if (_tmp267_) {
			ValaClass* _tmp274_;
			ValaSemanticAnalyzer* _tmp275_;
			ValaSemanticAnalyzer* _tmp276_;
			ValaClass* _tmp277_;
			_tmp274_ = self->priv->_base_class;
			_tmp275_ = vala_code_context_get_analyzer (context);
			_tmp276_ = _tmp275_;
			_tmp277_ = _tmp276_->gsource_type;
			_tmp266_ = _tmp274_ != _tmp277_;
		} else {
			_tmp266_ = FALSE;
		}
		if (_tmp266_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp278_;
				gint _f_size = 0;
				ValaList* _tmp279_;
				gint _tmp280_;
				gint _tmp281_;
				gint _f_index = 0;
				_tmp278_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp278_;
				_tmp279_ = _f_list;
				_tmp280_ = vala_collection_get_size ((ValaCollection*) _tmp279_);
				_tmp281_ = _tmp280_;
				_f_size = _tmp281_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp282_;
					gint _tmp283_;
					ValaField* f = NULL;
					ValaList* _tmp284_;
					gint _tmp285_;
					gpointer _tmp286_;
					ValaField* _tmp287_;
					ValaMemberBinding _tmp288_;
					ValaMemberBinding _tmp289_;
					_f_index = _f_index + 1;
					_tmp282_ = _f_index;
					_tmp283_ = _f_size;
					if (!(_tmp282_ < _tmp283_)) {
						break;
					}
					_tmp284_ = _f_list;
					_tmp285_ = _f_index;
					_tmp286_ = vala_list_get (_tmp284_, _tmp285_);
					f = (ValaField*) _tmp286_;
					_tmp287_ = f;
					_tmp288_ = vala_field_get_binding (_tmp287_);
					_tmp289_ = _tmp288_;
					if (_tmp289_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp290_;
						ValaSourceReference* _tmp291_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp290_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp291_ = _tmp290_;
						vala_report_error (_tmp291_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp292_ = g_direct_equal;
	_tmp293_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp292_);
	prerequisites = (ValaList*) _tmp293_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp294_;
		gint _base_type_size = 0;
		ValaList* _tmp295_;
		gint _tmp296_;
		gint _tmp297_;
		gint _base_type_index = 0;
		_tmp294_ = vala_class_get_base_types (self);
		_base_type_list = _tmp294_;
		_tmp295_ = _base_type_list;
		_tmp296_ = vala_collection_get_size ((ValaCollection*) _tmp295_);
		_tmp297_ = _tmp296_;
		_base_type_size = _tmp297_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp298_;
			gint _tmp299_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp300_;
			gint _tmp301_;
			gpointer _tmp302_;
			ValaDataType* _tmp303_;
			ValaTypeSymbol* _tmp304_;
			ValaTypeSymbol* _tmp305_;
			_base_type_index = _base_type_index + 1;
			_tmp298_ = _base_type_index;
			_tmp299_ = _base_type_size;
			if (!(_tmp298_ < _tmp299_)) {
				break;
			}
			_tmp300_ = _base_type_list;
			_tmp301_ = _base_type_index;
			_tmp302_ = vala_list_get (_tmp300_, _tmp301_);
			base_type = (ValaDataType*) _tmp302_;
			_tmp303_ = base_type;
			_tmp304_ = vala_data_type_get_data_type (_tmp303_);
			_tmp305_ = _tmp304_;
			if (VALA_IS_INTERFACE (_tmp305_)) {
				ValaDataType* _tmp306_;
				ValaTypeSymbol* _tmp307_;
				ValaTypeSymbol* _tmp308_;
				ValaList* _tmp309_;
				_tmp306_ = base_type;
				_tmp307_ = vala_data_type_get_data_type (_tmp306_);
				_tmp308_ = _tmp307_;
				_tmp309_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp308_, VALA_TYPE_INTERFACE, ValaInterface), _tmp309_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp310_ = g_direct_equal;
	_tmp311_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp310_);
	missing_prereqs = (ValaList*) _tmp311_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp312_;
		ValaList* _tmp313_;
		gint _prereq_size = 0;
		ValaList* _tmp314_;
		gint _tmp315_;
		gint _tmp316_;
		gint _prereq_index = 0;
		_tmp312_ = prerequisites;
		_tmp313_ = _vala_iterable_ref0 (_tmp312_);
		_prereq_list = _tmp313_;
		_tmp314_ = _prereq_list;
		_tmp315_ = vala_collection_get_size ((ValaCollection*) _tmp314_);
		_tmp316_ = _tmp315_;
		_prereq_size = _tmp316_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp317_;
			gint _tmp318_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp319_;
			gint _tmp320_;
			gpointer _tmp321_;
			ValaTypeSymbol* _tmp322_;
			_prereq_index = _prereq_index + 1;
			_tmp317_ = _prereq_index;
			_tmp318_ = _prereq_size;
			if (!(_tmp317_ < _tmp318_)) {
				break;
			}
			_tmp319_ = _prereq_list;
			_tmp320_ = _prereq_index;
			_tmp321_ = vala_list_get (_tmp319_, _tmp320_);
			prereq = (ValaTypeSymbol*) _tmp321_;
			_tmp322_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp322_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp323_;
				ValaTypeSymbol* _tmp324_;
				gchar* _tmp325_;
				gchar* _tmp326_;
				_tmp323_ = missing_prereqs;
				_tmp324_ = prereq;
				_tmp325_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp324_);
				_tmp326_ = _tmp325_;
				vala_list_insert (_tmp323_, 0, _tmp326_);
				_g_free0 (_tmp326_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp327_ = missing_prereqs;
	_tmp328_ = vala_collection_get_size ((ValaCollection*) _tmp327_);
	_tmp329_ = _tmp328_;
	if (_tmp329_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp330_;
		gchar* _tmp331_;
		gchar* _tmp332_;
		gchar* _tmp333_;
		gboolean first = FALSE;
		const gchar* _tmp351_;
		gchar* _tmp352_;
		ValaSourceReference* _tmp353_;
		ValaSourceReference* _tmp354_;
		const gchar* _tmp355_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp330_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp331_ = _tmp330_;
		_tmp332_ = g_strdup_printf ("%s: some prerequisites (", _tmp331_);
		_tmp333_ = _tmp332_;
		_g_free0 (_tmp331_);
		error_string = _tmp333_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp334_;
			ValaList* _tmp335_;
			gint _s_size = 0;
			ValaList* _tmp336_;
			gint _tmp337_;
			gint _tmp338_;
			gint _s_index = 0;
			_tmp334_ = missing_prereqs;
			_tmp335_ = _vala_iterable_ref0 (_tmp334_);
			_s_list = _tmp335_;
			_tmp336_ = _s_list;
			_tmp337_ = vala_collection_get_size ((ValaCollection*) _tmp336_);
			_tmp338_ = _tmp337_;
			_s_size = _tmp338_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp339_;
				gint _tmp340_;
				gchar* s = NULL;
				ValaList* _tmp341_;
				gint _tmp342_;
				gpointer _tmp343_;
				gboolean _tmp344_;
				_s_index = _s_index + 1;
				_tmp339_ = _s_index;
				_tmp340_ = _s_size;
				if (!(_tmp339_ < _tmp340_)) {
					break;
				}
				_tmp341_ = _s_list;
				_tmp342_ = _s_index;
				_tmp343_ = vala_list_get (_tmp341_, _tmp342_);
				s = (gchar*) _tmp343_;
				_tmp344_ = first;
				if (_tmp344_) {
					const gchar* _tmp345_;
					const gchar* _tmp346_;
					gchar* _tmp347_;
					_tmp345_ = error_string;
					_tmp346_ = s;
					_tmp347_ = g_strdup_printf ("%s`%s'", _tmp345_, _tmp346_);
					_g_free0 (error_string);
					error_string = _tmp347_;
					first = FALSE;
				} else {
					const gchar* _tmp348_;
					const gchar* _tmp349_;
					gchar* _tmp350_;
					_tmp348_ = error_string;
					_tmp349_ = s;
					_tmp350_ = g_strdup_printf ("%s, `%s'", _tmp348_, _tmp349_);
					_g_free0 (error_string);
					error_string = _tmp350_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp351_ = error_string;
		_tmp352_ = g_strconcat (_tmp351_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp352_;
		_tmp353_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp354_ = _tmp353_;
		_tmp355_ = error_string;
		vala_report_error (_tmp354_, _tmp355_);
		_g_free0 (error_string);
	}
	_tmp356_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp357_ = _tmp356_;
	if (_tmp357_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp503_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp358_;
			gint _base_type_size = 0;
			ValaList* _tmp359_;
			gint _tmp360_;
			gint _tmp361_;
			gint _base_type_index = 0;
			_tmp358_ = vala_class_get_base_types (self);
			_base_type_list = _tmp358_;
			_tmp359_ = _base_type_list;
			_tmp360_ = vala_collection_get_size ((ValaCollection*) _tmp359_);
			_tmp361_ = _tmp360_;
			_base_type_size = _tmp361_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp362_;
				gint _tmp363_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp364_;
				gint _tmp365_;
				gpointer _tmp366_;
				ValaDataType* _tmp367_;
				ValaTypeSymbol* _tmp368_;
				ValaTypeSymbol* _tmp369_;
				_base_type_index = _base_type_index + 1;
				_tmp362_ = _base_type_index;
				_tmp363_ = _base_type_size;
				if (!(_tmp362_ < _tmp363_)) {
					break;
				}
				_tmp364_ = _base_type_list;
				_tmp365_ = _base_type_index;
				_tmp366_ = vala_list_get (_tmp364_, _tmp365_);
				base_type = (ValaDataType*) _tmp366_;
				_tmp367_ = base_type;
				_tmp368_ = vala_data_type_get_data_type (_tmp367_);
				_tmp369_ = _tmp368_;
				if (VALA_IS_INTERFACE (_tmp369_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp370_;
					ValaTypeSymbol* _tmp371_;
					ValaTypeSymbol* _tmp372_;
					ValaInterface* _tmp373_;
					gboolean _tmp374_ = FALSE;
					ValaClass* _tmp375_;
					_tmp370_ = base_type;
					_tmp371_ = vala_data_type_get_data_type (_tmp370_);
					_tmp372_ = _tmp371_;
					_tmp373_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp372_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp373_;
					_tmp375_ = self->priv->_base_class;
					if (_tmp375_ != NULL) {
						ValaClass* _tmp376_;
						ValaInterface* _tmp377_;
						_tmp376_ = self->priv->_base_class;
						_tmp377_ = iface;
						_tmp374_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp376_, (ValaTypeSymbol*) _tmp377_);
					} else {
						_tmp374_ = FALSE;
					}
					if (_tmp374_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp378_;
						ValaList* _tmp379_;
						gint _m_size = 0;
						ValaList* _tmp380_;
						gint _tmp381_;
						gint _tmp382_;
						gint _m_index = 0;
						_tmp378_ = iface;
						_tmp379_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp378_);
						_m_list = _tmp379_;
						_tmp380_ = _m_list;
						_tmp381_ = vala_collection_get_size ((ValaCollection*) _tmp380_);
						_tmp382_ = _tmp381_;
						_m_size = _tmp382_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp383_;
							gint _tmp384_;
							ValaMethod* m = NULL;
							ValaList* _tmp385_;
							gint _tmp386_;
							gpointer _tmp387_;
							ValaMethod* _tmp388_;
							gboolean _tmp389_;
							gboolean _tmp390_;
							_m_index = _m_index + 1;
							_tmp383_ = _m_index;
							_tmp384_ = _m_size;
							if (!(_tmp383_ < _tmp384_)) {
								break;
							}
							_tmp385_ = _m_list;
							_tmp386_ = _m_index;
							_tmp387_ = vala_list_get (_tmp385_, _tmp386_);
							m = (ValaMethod*) _tmp387_;
							_tmp388_ = m;
							_tmp389_ = vala_method_get_is_abstract (_tmp388_);
							_tmp390_ = _tmp389_;
							if (_tmp390_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp391_;
								gboolean _tmp429_;
								implemented = FALSE;
								_tmp391_ = _vala_code_node_ref0 (self);
								base_class = _tmp391_;
								while (TRUE) {
									ValaClass* _tmp392_;
									ValaClass* _tmp426_;
									ValaClass* _tmp427_;
									ValaClass* _tmp428_;
									_tmp392_ = base_class;
									if (!(_tmp392_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp393_;
										ValaList* _tmp394_;
										gint _impl_size = 0;
										ValaList* _tmp395_;
										gint _tmp396_;
										gint _tmp397_;
										gint _impl_index = 0;
										_tmp393_ = base_class;
										_tmp394_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp393_);
										_impl_list = _tmp394_;
										_tmp395_ = _impl_list;
										_tmp396_ = vala_collection_get_size ((ValaCollection*) _tmp395_);
										_tmp397_ = _tmp396_;
										_impl_size = _tmp397_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp398_;
											gint _tmp399_;
											ValaMethod* impl = NULL;
											ValaList* _tmp400_;
											gint _tmp401_;
											gpointer _tmp402_;
											gboolean _tmp403_ = FALSE;
											ValaMethod* _tmp404_;
											const gchar* _tmp405_;
											const gchar* _tmp406_;
											ValaMethod* _tmp407_;
											const gchar* _tmp408_;
											const gchar* _tmp409_;
											_impl_index = _impl_index + 1;
											_tmp398_ = _impl_index;
											_tmp399_ = _impl_size;
											if (!(_tmp398_ < _tmp399_)) {
												break;
											}
											_tmp400_ = _impl_list;
											_tmp401_ = _impl_index;
											_tmp402_ = vala_list_get (_tmp400_, _tmp401_);
											impl = (ValaMethod*) _tmp402_;
											_tmp404_ = impl;
											_tmp405_ = vala_symbol_get_name ((ValaSymbol*) _tmp404_);
											_tmp406_ = _tmp405_;
											_tmp407_ = m;
											_tmp408_ = vala_symbol_get_name ((ValaSymbol*) _tmp407_);
											_tmp409_ = _tmp408_;
											if (g_strcmp0 (_tmp406_, _tmp409_) == 0) {
												gboolean _tmp410_ = FALSE;
												ValaMethod* _tmp411_;
												ValaDataType* _tmp412_;
												ValaDataType* _tmp413_;
												_tmp411_ = impl;
												_tmp412_ = vala_method_get_base_interface_type (_tmp411_);
												_tmp413_ = _tmp412_;
												if (_tmp413_ == NULL) {
													_tmp410_ = TRUE;
												} else {
													ValaMethod* _tmp414_;
													ValaDataType* _tmp415_;
													ValaDataType* _tmp416_;
													ValaTypeSymbol* _tmp417_;
													ValaTypeSymbol* _tmp418_;
													ValaInterface* _tmp419_;
													_tmp414_ = impl;
													_tmp415_ = vala_method_get_base_interface_type (_tmp414_);
													_tmp416_ = _tmp415_;
													_tmp417_ = vala_data_type_get_data_type (_tmp416_);
													_tmp418_ = _tmp417_;
													_tmp419_ = iface;
													_tmp410_ = _tmp418_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp419_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp403_ = _tmp410_;
											} else {
												_tmp403_ = FALSE;
											}
											if (_tmp403_) {
												ValaMethod* _tmp420_;
												ValaVersionAttribute* _tmp421_;
												ValaVersionAttribute* _tmp422_;
												ValaSourceReference* _tmp423_;
												ValaSourceReference* _tmp424_;
												ValaMethod* _tmp425_;
												_tmp420_ = impl;
												_tmp421_ = vala_symbol_get_version ((ValaSymbol*) _tmp420_);
												_tmp422_ = _tmp421_;
												_tmp423_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp424_ = _tmp423_;
												vala_version_attribute_check (_tmp422_, _tmp424_);
												_tmp425_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp425_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp426_ = base_class;
									_tmp427_ = _tmp426_->priv->_base_class;
									_tmp428_ = _vala_code_node_ref0 (_tmp427_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp428_;
								}
								_tmp429_ = implemented;
								if (!_tmp429_) {
									ValaSourceReference* _tmp430_;
									ValaSourceReference* _tmp431_;
									gchar* _tmp432_;
									gchar* _tmp433_;
									ValaMethod* _tmp434_;
									gchar* _tmp435_;
									gchar* _tmp436_;
									gchar* _tmp437_;
									gchar* _tmp438_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp430_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp431_ = _tmp430_;
									_tmp432_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp433_ = _tmp432_;
									_tmp434_ = m;
									_tmp435_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp434_);
									_tmp436_ = _tmp435_;
									_tmp437_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp433_, _tmp436_);
									_tmp438_ = _tmp437_;
									vala_report_error (_tmp431_, _tmp438_);
									_g_free0 (_tmp438_);
									_g_free0 (_tmp436_);
									_g_free0 (_tmp433_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp439_;
						ValaList* _tmp440_;
						gint _prop_size = 0;
						ValaList* _tmp441_;
						gint _tmp442_;
						gint _tmp443_;
						gint _prop_index = 0;
						_tmp439_ = iface;
						_tmp440_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp439_);
						_prop_list = _tmp440_;
						_tmp441_ = _prop_list;
						_tmp442_ = vala_collection_get_size ((ValaCollection*) _tmp441_);
						_tmp443_ = _tmp442_;
						_prop_size = _tmp443_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp444_;
							gint _tmp445_;
							ValaProperty* prop = NULL;
							ValaList* _tmp446_;
							gint _tmp447_;
							gpointer _tmp448_;
							ValaProperty* _tmp449_;
							gboolean _tmp450_;
							gboolean _tmp451_;
							_prop_index = _prop_index + 1;
							_tmp444_ = _prop_index;
							_tmp445_ = _prop_size;
							if (!(_tmp444_ < _tmp445_)) {
								break;
							}
							_tmp446_ = _prop_list;
							_tmp447_ = _prop_index;
							_tmp448_ = vala_list_get (_tmp446_, _tmp447_);
							prop = (ValaProperty*) _tmp448_;
							_tmp449_ = prop;
							_tmp450_ = vala_property_get_is_abstract (_tmp449_);
							_tmp451_ = _tmp450_;
							if (_tmp451_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp452_;
								ValaSymbol* _tmp466_;
								sym = NULL;
								_tmp452_ = _vala_code_node_ref0 (self);
								base_class = _tmp452_;
								while (TRUE) {
									gboolean _tmp453_ = FALSE;
									ValaClass* _tmp454_;
									ValaClass* _tmp456_;
									ValaScope* _tmp457_;
									ValaScope* _tmp458_;
									ValaProperty* _tmp459_;
									const gchar* _tmp460_;
									const gchar* _tmp461_;
									ValaSymbol* _tmp462_;
									ValaClass* _tmp463_;
									ValaClass* _tmp464_;
									ValaClass* _tmp465_;
									_tmp454_ = base_class;
									if (_tmp454_ != NULL) {
										ValaSymbol* _tmp455_;
										_tmp455_ = sym;
										_tmp453_ = !VALA_IS_PROPERTY (_tmp455_);
									} else {
										_tmp453_ = FALSE;
									}
									if (!_tmp453_) {
										break;
									}
									_tmp456_ = base_class;
									_tmp457_ = vala_symbol_get_scope ((ValaSymbol*) _tmp456_);
									_tmp458_ = _tmp457_;
									_tmp459_ = prop;
									_tmp460_ = vala_symbol_get_name ((ValaSymbol*) _tmp459_);
									_tmp461_ = _tmp460_;
									_tmp462_ = vala_scope_lookup (_tmp458_, _tmp461_);
									_vala_code_node_unref0 (sym);
									sym = _tmp462_;
									_tmp463_ = base_class;
									_tmp464_ = _tmp463_->priv->_base_class;
									_tmp465_ = _vala_code_node_ref0 (_tmp464_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp465_;
								}
								_tmp466_ = sym;
								if (VALA_IS_PROPERTY (_tmp466_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp467_;
									ValaProperty* _tmp468_;
									gchar* invalid_match = NULL;
									gboolean _tmp469_ = FALSE;
									ValaProperty* _tmp470_;
									gboolean _tmp471_;
									gboolean _tmp472_;
									ValaSymbol* _tmp488_;
									ValaVersionAttribute* _tmp489_;
									ValaVersionAttribute* _tmp490_;
									ValaSourceReference* _tmp491_;
									ValaSourceReference* _tmp492_;
									ValaSymbol* _tmp493_;
									_tmp467_ = sym;
									_tmp468_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp467_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp468_;
									invalid_match = NULL;
									_tmp470_ = base_prop;
									_tmp471_ = vala_symbol_get_hides ((ValaSymbol*) _tmp470_);
									_tmp472_ = _tmp471_;
									if (!_tmp472_) {
										ValaProperty* _tmp473_;
										ValaProperty* _tmp474_;
										gchar* _tmp475_ = NULL;
										gboolean _tmp476_;
										_tmp473_ = base_prop;
										_tmp474_ = prop;
										_tmp476_ = vala_property_compatible (_tmp473_, _tmp474_, &_tmp475_);
										_g_free0 (invalid_match);
										invalid_match = _tmp475_;
										_tmp469_ = !_tmp476_;
									} else {
										_tmp469_ = FALSE;
									}
									if (_tmp469_) {
										ValaSourceReference* _tmp477_;
										ValaSourceReference* _tmp478_;
										ValaProperty* _tmp479_;
										gchar* _tmp480_;
										gchar* _tmp481_;
										ValaProperty* _tmp482_;
										gchar* _tmp483_;
										gchar* _tmp484_;
										const gchar* _tmp485_;
										gchar* _tmp486_;
										gchar* _tmp487_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp477_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp478_ = _tmp477_;
										_tmp479_ = prop;
										_tmp480_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp479_);
										_tmp481_ = _tmp480_;
										_tmp482_ = base_prop;
										_tmp483_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp482_);
										_tmp484_ = _tmp483_;
										_tmp485_ = invalid_match;
										_tmp486_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp481_, _tmp484_, _tmp485_);
										_tmp487_ = _tmp486_;
										vala_report_error (_tmp478_, _tmp487_);
										_g_free0 (_tmp487_);
										_g_free0 (_tmp484_);
										_g_free0 (_tmp481_);
									}
									_tmp488_ = sym;
									_tmp489_ = vala_symbol_get_version (_tmp488_);
									_tmp490_ = _tmp489_;
									_tmp491_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp492_ = _tmp491_;
									vala_version_attribute_check (_tmp490_, _tmp492_);
									_tmp493_ = sym;
									vala_symbol_set_used (_tmp493_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp494_;
									ValaSourceReference* _tmp495_;
									gchar* _tmp496_;
									gchar* _tmp497_;
									ValaProperty* _tmp498_;
									gchar* _tmp499_;
									gchar* _tmp500_;
									gchar* _tmp501_;
									gchar* _tmp502_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp494_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp495_ = _tmp494_;
									_tmp496_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp497_ = _tmp496_;
									_tmp498_ = prop;
									_tmp499_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp498_);
									_tmp500_ = _tmp499_;
									_tmp501_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp497_, _tmp500_);
									_tmp502_ = _tmp501_;
									vala_report_error (_tmp495_, _tmp502_);
									_g_free0 (_tmp502_);
									_g_free0 (_tmp500_);
									_g_free0 (_tmp497_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp503_ = self->priv->_is_abstract;
		if (!_tmp503_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp504_;
			ValaClass* _tmp505_;
			_tmp504_ = self->priv->_base_class;
			_tmp505_ = _vala_code_node_ref0 (_tmp504_);
			base_class = _tmp505_;
			while (TRUE) {
				gboolean _tmp506_ = FALSE;
				ValaClass* _tmp507_;
				ValaClass* _tmp574_;
				ValaClass* _tmp575_;
				ValaClass* _tmp576_;
				_tmp507_ = base_class;
				if (_tmp507_ != NULL) {
					ValaClass* _tmp508_;
					gboolean _tmp509_;
					_tmp508_ = base_class;
					_tmp509_ = _tmp508_->priv->_is_abstract;
					_tmp506_ = _tmp509_;
				} else {
					_tmp506_ = FALSE;
				}
				if (!_tmp506_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp510_;
					ValaList* _tmp511_;
					gint _base_method_size = 0;
					ValaList* _tmp512_;
					gint _tmp513_;
					gint _tmp514_;
					gint _base_method_index = 0;
					_tmp510_ = base_class;
					_tmp511_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp510_);
					_base_method_list = _tmp511_;
					_tmp512_ = _base_method_list;
					_tmp513_ = vala_collection_get_size ((ValaCollection*) _tmp512_);
					_tmp514_ = _tmp513_;
					_base_method_size = _tmp514_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp515_;
						gint _tmp516_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp517_;
						gint _tmp518_;
						gpointer _tmp519_;
						ValaMethod* _tmp520_;
						gboolean _tmp521_;
						gboolean _tmp522_;
						_base_method_index = _base_method_index + 1;
						_tmp515_ = _base_method_index;
						_tmp516_ = _base_method_size;
						if (!(_tmp515_ < _tmp516_)) {
							break;
						}
						_tmp517_ = _base_method_list;
						_tmp518_ = _base_method_index;
						_tmp519_ = vala_list_get (_tmp517_, _tmp518_);
						base_method = (ValaMethod*) _tmp519_;
						_tmp520_ = base_method;
						_tmp521_ = vala_method_get_is_abstract (_tmp520_);
						_tmp522_ = _tmp521_;
						if (_tmp522_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp523_;
							const gchar* _tmp524_;
							const gchar* _tmp525_;
							ValaSymbol* _tmp526_;
							ValaMethod* _tmp527_;
							gboolean _tmp528_ = FALSE;
							ValaMethod* _tmp529_;
							_tmp523_ = base_method;
							_tmp524_ = vala_symbol_get_name ((ValaSymbol*) _tmp523_);
							_tmp525_ = _tmp524_;
							_tmp526_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp525_);
							_tmp527_ = VALA_IS_METHOD (_tmp526_) ? ((ValaMethod*) _tmp526_) : NULL;
							if (_tmp527_ == NULL) {
								_vala_code_node_unref0 (_tmp526_);
							}
							override_method = _tmp527_;
							_tmp529_ = override_method;
							if (_tmp529_ == NULL) {
								_tmp528_ = TRUE;
							} else {
								ValaMethod* _tmp530_;
								gboolean _tmp531_;
								gboolean _tmp532_;
								_tmp530_ = override_method;
								_tmp531_ = vala_method_get_overrides (_tmp530_);
								_tmp532_ = _tmp531_;
								_tmp528_ = !_tmp532_;
							}
							if (_tmp528_) {
								ValaSourceReference* _tmp533_;
								ValaSourceReference* _tmp534_;
								gchar* _tmp535_;
								gchar* _tmp536_;
								ValaMethod* _tmp537_;
								gchar* _tmp538_;
								gchar* _tmp539_;
								gchar* _tmp540_;
								gchar* _tmp541_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp533_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp534_ = _tmp533_;
								_tmp535_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp536_ = _tmp535_;
								_tmp537_ = base_method;
								_tmp538_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp537_);
								_tmp539_ = _tmp538_;
								_tmp540_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp536_, _tmp539_);
								_tmp541_ = _tmp540_;
								vala_report_error (_tmp534_, _tmp541_);
								_g_free0 (_tmp541_);
								_g_free0 (_tmp539_);
								_g_free0 (_tmp536_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp542_;
					ValaList* _tmp543_;
					gint _base_property_size = 0;
					ValaList* _tmp544_;
					gint _tmp545_;
					gint _tmp546_;
					gint _base_property_index = 0;
					_tmp542_ = base_class;
					_tmp543_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp542_);
					_base_property_list = _tmp543_;
					_tmp544_ = _base_property_list;
					_tmp545_ = vala_collection_get_size ((ValaCollection*) _tmp544_);
					_tmp546_ = _tmp545_;
					_base_property_size = _tmp546_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp547_;
						gint _tmp548_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp549_;
						gint _tmp550_;
						gpointer _tmp551_;
						ValaProperty* _tmp552_;
						gboolean _tmp553_;
						gboolean _tmp554_;
						_base_property_index = _base_property_index + 1;
						_tmp547_ = _base_property_index;
						_tmp548_ = _base_property_size;
						if (!(_tmp547_ < _tmp548_)) {
							break;
						}
						_tmp549_ = _base_property_list;
						_tmp550_ = _base_property_index;
						_tmp551_ = vala_list_get (_tmp549_, _tmp550_);
						base_property = (ValaProperty*) _tmp551_;
						_tmp552_ = base_property;
						_tmp553_ = vala_property_get_is_abstract (_tmp552_);
						_tmp554_ = _tmp553_;
						if (_tmp554_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp555_;
							const gchar* _tmp556_;
							const gchar* _tmp557_;
							ValaSymbol* _tmp558_;
							ValaProperty* _tmp559_;
							gboolean _tmp560_ = FALSE;
							ValaProperty* _tmp561_;
							_tmp555_ = base_property;
							_tmp556_ = vala_symbol_get_name ((ValaSymbol*) _tmp555_);
							_tmp557_ = _tmp556_;
							_tmp558_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp557_);
							_tmp559_ = VALA_IS_PROPERTY (_tmp558_) ? ((ValaProperty*) _tmp558_) : NULL;
							if (_tmp559_ == NULL) {
								_vala_code_node_unref0 (_tmp558_);
							}
							override_property = _tmp559_;
							_tmp561_ = override_property;
							if (_tmp561_ == NULL) {
								_tmp560_ = TRUE;
							} else {
								ValaProperty* _tmp562_;
								gboolean _tmp563_;
								gboolean _tmp564_;
								_tmp562_ = override_property;
								_tmp563_ = vala_property_get_overrides (_tmp562_);
								_tmp564_ = _tmp563_;
								_tmp560_ = !_tmp564_;
							}
							if (_tmp560_) {
								ValaSourceReference* _tmp565_;
								ValaSourceReference* _tmp566_;
								gchar* _tmp567_;
								gchar* _tmp568_;
								ValaProperty* _tmp569_;
								gchar* _tmp570_;
								gchar* _tmp571_;
								gchar* _tmp572_;
								gchar* _tmp573_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp565_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp566_ = _tmp565_;
								_tmp567_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp568_ = _tmp567_;
								_tmp569_ = base_property;
								_tmp570_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp569_);
								_tmp571_ = _tmp570_;
								_tmp572_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp568_, _tmp571_);
								_tmp573_ = _tmp572_;
								vala_report_error (_tmp566_, _tmp573_);
								_g_free0 (_tmp573_);
								_g_free0 (_tmp571_);
								_g_free0 (_tmp568_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp574_ = base_class;
				_tmp575_ = _tmp574_->priv->_base_class;
				_tmp576_ = _vala_code_node_ref0 (_tmp575_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp576_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp577_ = vala_code_context_get_analyzer (context);
	_tmp578_ = _tmp577_;
	_tmp579_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp578_, _tmp579_);
	_tmp580_ = vala_code_context_get_analyzer (context);
	_tmp581_ = _tmp580_;
	_tmp582_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp581_, _tmp582_);
	_tmp583_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp584_ = _tmp583_;
	result = !_tmp584_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_compact (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			ValaAttribute* _tmp9_;
			gboolean _tmp10_;
			gboolean* _tmp11_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_tmp11_ = __bool_dup0 (&_tmp10_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp11_;
			_vala_code_node_unref0 (_tmp9_);
		}
	}
	_tmp12_ = self->priv->_is_compact;
	result = *_tmp12_;
	return result;
}


void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}


gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp12_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_ = FALSE;
		ValaClass* _tmp2_;
		_tmp2_ = self->priv->_base_class;
		if (_tmp2_ != NULL) {
			ValaClass* _tmp3_;
			_tmp3_ = self->priv->_base_class;
			_tmp1_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp3_, (ValaTypeSymbol*) self);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			ValaClass* _tmp4_;
			gboolean _tmp5_;
			gboolean _tmp6_;
			gboolean* _tmp7_;
			_tmp4_ = self->priv->_base_class;
			_tmp5_ = vala_class_get_is_immutable (_tmp4_);
			_tmp6_ = _tmp5_;
			_tmp7_ = __bool_dup0 (&_tmp6_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp7_;
		} else {
			ValaAttribute* _tmp8_;
			ValaAttribute* _tmp9_;
			gboolean _tmp10_;
			gboolean* _tmp11_;
			_tmp8_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp9_ = _tmp8_;
			_tmp10_ = _tmp9_ != NULL;
			_tmp11_ = __bool_dup0 (&_tmp10_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp11_;
			_vala_code_node_unref0 (_tmp9_);
		}
	}
	_tmp12_ = self->priv->_is_immutable;
	result = *_tmp12_;
	return result;
}


void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaDestructor* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaDestructor* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaDestructor* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaDestructor* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
		_tmp5_ = self->priv->_destructor;
		_tmp6_ = vala_destructor_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDestructor* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaDestructor* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_destructor;
			_tmp12_ = vala_destructor_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = self->priv->_destructor;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_destructor_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_destructor;
		_tmp25_ = vala_destructor_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_destructor;
		_tmp30_ = vala_destructor_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
}


ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void
vala_class_class_init (ValaClassClass * klass)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}


static void
vala_class_instance_init (ValaClass * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
}


static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



