/* valagsignalmodule.c generated by valac, the Vala compiler
 * generated from valagsignalmodule.vala, do not modify */

/* valagsignalmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))


static gpointer vala_gsignal_module_parent_class = NULL;

static gchar* vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                                    ValaSignal* sig,
                                                    ValaList* params,
                                                    ValaDataType* return_type,
                                                    const gchar* prefix);
static gchar* vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                                     ValaSignal* sig,
                                                     ValaList* params,
                                                     ValaDataType* return_type);
static gchar* vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                                    ValaDataType* t);
static gchar* vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                               ValaParameter* p);
static ValaCCodeExpression* vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                                      ValaSignal* sig,
                                                                      ValaExpression* detail_expr,
                                                                      ValaCodeNode* node);
static ValaCCodeExpression* vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                                                    ValaSignal* sig);
static ValaCCodeExpression* vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                                                 ValaExpression* detail_expr,
                                                                 ValaCodeNode* node);
static void vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                            ValaSignal* sig);
static void vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type);
static ValaCCodeExpression* vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                                                   ValaSignal* sig,
                                                                   ValaTypeSymbol* type);
static void _vala_array_add1 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add3 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add4 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add5 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add6 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add7 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void _vala_array_add8 (gchar** * array,
                       int* length,
                       int* size,
                       gchar* value);
static void vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                                    ValaElementAccess* expr);
static gboolean vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                                  ValaMethod* m);
static void vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self,
                                                 ValaAssignment* assignment);
static ValaCCodeExpression* vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                                         ValaSignal* sig,
                                                         ValaExpression* signal_access,
                                                         ValaExpression* handler,
                                                         gboolean disconnect,
                                                         gboolean after,
                                                         ValaCodeNode* expr);
static void vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base,
                                                ValaAssignment* assignment);
static void vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                                   ValaMemberAccess* expr);
static void vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                                 ValaMethodCall* expr);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (_tmp7_);
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally10:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static gchar*
vala_gsignal_module_get_marshaller_function (ValaGSignalModule* self,
                                             ValaSignal* sig,
                                             ValaList* params,
                                             ValaDataType* return_type,
                                             const gchar* prefix)
{
	gchar* result = NULL;
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* ret = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	ValaDataType* _tmp22_;
	ValaDataType* _tmp23_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	signature = _tmp0_;
	if (prefix == NULL) {
		ValaSet* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
		_tmp2_ = signature;
		if (vala_collection_contains ((ValaCollection*) _tmp1_, _tmp2_)) {
			prefix = "g_cclosure_marshal";
		} else {
			prefix = "g_cclosure_user_marshal";
		}
	}
	_tmp3_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_%s_", prefix, _tmp4_);
	_g_free0 (ret);
	ret = _tmp5_;
	_g_free0 (_tmp4_);
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp6_;
		gint _p_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _p_index = 0;
		_tmp6_ = _vala_iterable_ref0 (params);
		_p_list = _tmp6_;
		_tmp7_ = _p_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_p_size = _tmp9_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			ValaParameter* p = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			const gchar* _tmp15_;
			ValaParameter* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			_p_index = _p_index + 1;
			_tmp10_ = _p_index;
			_tmp11_ = _p_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _p_list;
			_tmp13_ = _p_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			p = (ValaParameter*) _tmp14_;
			_tmp15_ = ret;
			_tmp16_ = p;
			_tmp17_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = string_replace (_tmp18_, ",", "_");
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strdup_printf ("%s_%s", _tmp15_, _tmp20_);
			_g_free0 (ret);
			ret = _tmp21_;
			_g_free0 (_tmp20_);
			_g_free0 (_tmp18_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp22_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp23_ = _tmp22_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp23_)) {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp24_ = ret;
		_tmp25_ = g_strconcat (_tmp24_, "_POINTER", NULL);
		_g_free0 (ret);
		ret = _tmp25_;
	} else {
		gint _tmp26_;
		gint _tmp27_;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp27_ = _tmp26_;
		if (_tmp27_ == 0) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = ret;
			_tmp29_ = g_strconcat (_tmp28_, "_VOID", NULL);
			_g_free0 (ret);
			ret = _tmp29_;
		}
	}
	result = ret;
	_g_free0 (signature);
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gchar*
vala_gsignal_module_get_value_type_name_from_type_reference (ValaGSignalModule* self,
                                                             ValaDataType* t)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (t != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_POINTER_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp0_) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("gpointer");
		result = _tmp1_;
		return result;
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VOID_TYPE)) {
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("void");
			result = _tmp2_;
			return result;
		} else {
			gchar* _tmp3_;
			gchar* _tmp4_;
			ValaDataType* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gboolean _tmp8_;
			_tmp3_ = vala_get_ccode_type_id ((ValaCodeNode*) t);
			_tmp4_ = _tmp3_;
			_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
			_tmp6_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strcmp0 (_tmp4_, _tmp7_) == 0;
			_g_free0 (_tmp7_);
			_g_free0 (_tmp4_);
			if (_tmp8_) {
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("const char*");
				result = _tmp9_;
				return result;
			} else {
				gboolean _tmp10_ = FALSE;
				ValaTypeSymbol* _tmp11_;
				ValaTypeSymbol* _tmp12_;
				_tmp11_ = vala_data_type_get_data_type (t);
				_tmp12_ = _tmp11_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
					_tmp10_ = TRUE;
				} else {
					ValaTypeSymbol* _tmp13_;
					ValaTypeSymbol* _tmp14_;
					_tmp13_ = vala_data_type_get_data_type (t);
					_tmp14_ = _tmp13_;
					_tmp10_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_INTERFACE);
				}
				if (_tmp10_) {
					gchar* _tmp15_;
					_tmp15_ = g_strdup ("gpointer");
					result = _tmp15_;
					return result;
				} else {
					gboolean _tmp16_ = FALSE;
					if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_VALUE_TYPE)) {
						gboolean _tmp17_;
						gboolean _tmp18_;
						_tmp17_ = vala_data_type_get_nullable (t);
						_tmp18_ = _tmp17_;
						_tmp16_ = _tmp18_;
					} else {
						_tmp16_ = FALSE;
					}
					if (_tmp16_) {
						gchar* _tmp19_;
						_tmp19_ = g_strdup ("gpointer");
						result = _tmp19_;
						return result;
					} else {
						ValaTypeSymbol* _tmp20_;
						ValaTypeSymbol* _tmp21_;
						_tmp20_ = vala_data_type_get_data_type (t);
						_tmp21_ = _tmp20_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_STRUCT)) {
							ValaStruct* st = NULL;
							ValaTypeSymbol* _tmp22_;
							ValaTypeSymbol* _tmp23_;
							ValaStruct* _tmp24_;
							ValaStruct* _tmp25_;
							_tmp22_ = vala_data_type_get_data_type (t);
							_tmp23_ = _tmp22_;
							_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_STRUCT, ValaStruct));
							st = _tmp24_;
							_tmp25_ = st;
							if (vala_struct_is_simple_type (_tmp25_)) {
								ValaTypeSymbol* _tmp26_;
								ValaTypeSymbol* _tmp27_;
								gchar* _tmp28_;
								_tmp26_ = vala_data_type_get_data_type (t);
								_tmp27_ = _tmp26_;
								_tmp28_ = vala_get_ccode_name ((ValaCodeNode*) _tmp27_);
								result = _tmp28_;
								_vala_code_node_unref0 (st);
								return result;
							} else {
								gchar* _tmp29_;
								_tmp29_ = g_strdup ("gpointer");
								result = _tmp29_;
								_vala_code_node_unref0 (st);
								return result;
							}
							_vala_code_node_unref0 (st);
						} else {
							ValaTypeSymbol* _tmp30_;
							ValaTypeSymbol* _tmp31_;
							_tmp30_ = vala_data_type_get_data_type (t);
							_tmp31_ = _tmp30_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp31_, VALA_TYPE_ENUM)) {
								ValaEnum* en = NULL;
								ValaTypeSymbol* _tmp32_;
								ValaTypeSymbol* _tmp33_;
								ValaEnum* _tmp34_;
								ValaEnum* _tmp35_;
								gboolean _tmp36_;
								gboolean _tmp37_;
								_tmp32_ = vala_data_type_get_data_type (t);
								_tmp33_ = _tmp32_;
								_tmp34_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, VALA_TYPE_ENUM, ValaEnum));
								en = _tmp34_;
								_tmp35_ = en;
								_tmp36_ = vala_enum_get_is_flags (_tmp35_);
								_tmp37_ = _tmp36_;
								if (_tmp37_) {
									gchar* _tmp38_;
									_tmp38_ = g_strdup ("guint");
									result = _tmp38_;
									_vala_code_node_unref0 (en);
									return result;
								} else {
									gchar* _tmp39_;
									_tmp39_ = g_strdup ("gint");
									result = _tmp39_;
									_vala_code_node_unref0 (en);
									return result;
								}
								_vala_code_node_unref0 (en);
							} else {
								if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ARRAY_TYPE)) {
									gchar* _tmp40_;
									_tmp40_ = g_strdup ("gpointer");
									result = _tmp40_;
									return result;
								} else {
									if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_DELEGATE_TYPE)) {
										gchar* _tmp41_;
										_tmp41_ = g_strdup ("gpointer");
										result = _tmp41_;
										return result;
									} else {
										if (G_TYPE_CHECK_INSTANCE_TYPE (t, VALA_TYPE_ERROR_TYPE)) {
											gchar* _tmp42_;
											_tmp42_ = g_strdup ("gpointer");
											result = _tmp42_;
											return result;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}
	result = NULL;
	return result;
}


static gchar*
vala_gsignal_module_get_value_type_name_from_parameter (ValaGSignalModule* self,
                                                        ValaParameter* p)
{
	gchar* result = NULL;
	ValaParameterDirection _tmp0_;
	ValaParameterDirection _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (p != NULL, NULL);
	_tmp0_ = vala_parameter_get_direction (p);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != VALA_PARAMETER_DIRECTION_IN) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("gpointer");
		result = _tmp2_;
		return result;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = vala_variable_get_variable_type ((ValaVariable*) p);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, _tmp4_);
		result = _tmp5_;
		return result;
	}
}


static gchar*
vala_gsignal_module_get_marshaller_signature (ValaGSignalModule* self,
                                              ValaSignal* sig,
                                              ValaList* params,
                                              ValaDataType* return_type)
{
	gchar* result = NULL;
	gchar* signature = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean first = FALSE;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (params != NULL, NULL);
	g_return_val_if_fail (return_type != NULL, NULL);
	_tmp0_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) return_type);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%s:", _tmp1_);
	_g_free0 (signature);
	signature = _tmp2_;
	_g_free0 (_tmp1_);
	first = TRUE;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp3_;
		gint _p_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _p_index = 0;
		_tmp3_ = _vala_iterable_ref0 (params);
		_p_list = _tmp3_;
		_tmp4_ = _p_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_p_size = _tmp6_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			ValaParameter* p = NULL;
			ValaList* _tmp9_;
			gint _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_;
			_p_index = _p_index + 1;
			_tmp7_ = _p_index;
			_tmp8_ = _p_size;
			if (!(_tmp7_ < _tmp8_)) {
				break;
			}
			_tmp9_ = _p_list;
			_tmp10_ = _p_index;
			_tmp11_ = vala_list_get (_tmp9_, _tmp10_);
			p = (ValaParameter*) _tmp11_;
			_tmp12_ = first;
			if (_tmp12_) {
				const gchar* _tmp13_;
				ValaParameter* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				gchar* _tmp17_;
				_tmp13_ = signature;
				_tmp14_ = p;
				_tmp15_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = g_strconcat (_tmp13_, _tmp16_, NULL);
				_g_free0 (signature);
				signature = _tmp17_;
				_g_free0 (_tmp16_);
				first = FALSE;
			} else {
				const gchar* _tmp18_;
				ValaParameter* _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp18_ = signature;
				_tmp19_ = p;
				_tmp20_ = vala_get_ccode_marshaller_type_name ((ValaCodeNode*) _tmp19_);
				_tmp21_ = _tmp20_;
				_tmp22_ = g_strdup_printf ("%s,%s", _tmp18_, _tmp21_);
				_g_free0 (signature);
				signature = _tmp22_;
				_g_free0 (_tmp21_);
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp23_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp24_ = _tmp23_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp24_)) {
		const gchar* _tmp25_ = NULL;
		gboolean _tmp26_;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		_tmp26_ = first;
		if (_tmp26_) {
			_tmp25_ = "POINTER";
		} else {
			_tmp25_ = ",POINTER";
		}
		_tmp27_ = signature;
		_tmp28_ = g_strconcat (_tmp27_, _tmp25_, NULL);
		_g_free0 (signature);
		signature = _tmp28_;
	} else {
		gint _tmp29_;
		gint _tmp30_;
		_tmp29_ = vala_collection_get_size ((ValaCollection*) params);
		_tmp30_ = _tmp29_;
		if (_tmp30_ == 0) {
			const gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp31_ = signature;
			_tmp32_ = g_strconcat (_tmp31_, "VOID", NULL);
			_g_free0 (signature);
			signature = _tmp32_;
		}
	}
	result = signature;
	return result;
}


static ValaCCodeExpression*
vala_gsignal_module_get_signal_name_cexpression (ValaGSignalModule* self,
                                                 ValaSignal* sig,
                                                 ValaExpression* detail_expr,
                                                 ValaCodeNode* node)
{
	ValaCCodeExpression* result = NULL;
	gboolean _tmp1_ = FALSE;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaTargetValue* detail_value = NULL;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	gboolean _tmp15_;
	ValaTargetValue* _tmp16_;
	ValaArrayList* _tmp17_;
	ValaArrayList* _tmp18_;
	ValaTargetValue* _tmp19_;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeConstant* _tmp25_;
	ValaCCodeConstant* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeExpression* _tmp28_;
	ValaCCodeExpression* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeConstant* _tmp31_;
	ValaCCodeConstant* _tmp32_;
	ValaCCodeFunction* _tmp33_;
	ValaCCodeFunction* _tmp34_;
	ValaTargetValue* _tmp35_;
	ValaCCodeExpression* _tmp36_;
	ValaCCodeExpression* _tmp37_;
	ValaCCodeFunctionCall* _tmp38_;
	ValaTargetValue* _tmp39_;
	ValaCCodeExpression* _tmp40_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	if (detail_expr == NULL) {
		ValaCCodeConstant* _tmp0_;
		_tmp0_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, NULL);
		result = (ValaCCodeExpression*) _tmp0_;
		return result;
	}
	_tmp2_ = vala_expression_get_value_type (detail_expr);
	_tmp3_ = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_NULL_TYPE)) {
		_tmp1_ = TRUE;
	} else {
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDataType* _tmp6_;
		_tmp4_ = vala_expression_get_value_type (detail_expr);
		_tmp5_ = _tmp4_;
		_tmp6_ = ((ValaCCodeBaseModule*) self)->string_type;
		_tmp1_ = !vala_data_type_compatible (_tmp5_, _tmp6_);
	}
	if (_tmp1_) {
		ValaSourceReference* _tmp7_;
		ValaSourceReference* _tmp8_;
		vala_code_node_set_error (node, TRUE);
		_tmp7_ = vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr);
		_tmp8_ = _tmp7_;
		vala_report_error (_tmp8_, "only string details are supported");
		result = NULL;
		return result;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (detail_expr, VALA_TYPE_STRING_LITERAL)) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		ValaCCodeConstant* _tmp11_;
		ValaCCodeExpression* _tmp12_;
		_tmp9_ = vala_string_literal_eval (G_TYPE_CHECK_INSTANCE_CAST (detail_expr, VALA_TYPE_STRING_LITERAL, ValaStringLiteral));
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, _tmp10_);
		_tmp12_ = (ValaCCodeExpression*) _tmp11_;
		_g_free0 (_tmp10_);
		result = _tmp12_;
		return result;
	}
	_tmp13_ = vala_expression_get_value_type (detail_expr);
	_tmp14_ = _tmp13_;
	_tmp15_ = TRUE;
	_tmp16_ = vala_ccode_base_module_create_temp_value ((ValaCCodeBaseModule*) self, _tmp14_, FALSE, node, &_tmp15_);
	detail_value = _tmp16_;
	_tmp17_ = vala_ccode_base_module_get_temp_ref_values ((ValaCCodeBaseModule*) self);
	_tmp18_ = _tmp17_;
	_tmp19_ = detail_value;
	vala_list_insert ((ValaList*) _tmp18_, 0, _tmp19_);
	_tmp20_ = vala_ccode_identifier_new ("g_strconcat");
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp21_);
	_tmp23_ = _tmp22_;
	_vala_ccode_node_unref0 (_tmp21_);
	ccall = _tmp23_;
	_tmp24_ = ccall;
	_tmp25_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, sig, "");
	_tmp26_ = _tmp25_;
	vala_ccode_function_call_add_argument (_tmp24_, (ValaCCodeExpression*) _tmp26_);
	_vala_ccode_node_unref0 (_tmp26_);
	_tmp27_ = ccall;
	_tmp28_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	_tmp29_ = _tmp28_;
	vala_ccode_function_call_add_argument (_tmp27_, _tmp29_);
	_vala_ccode_node_unref0 (_tmp29_);
	_tmp30_ = ccall;
	_tmp31_ = vala_ccode_constant_new ("NULL");
	_tmp32_ = _tmp31_;
	vala_ccode_function_call_add_argument (_tmp30_, (ValaCCodeExpression*) _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_tmp33_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = detail_value;
	_tmp36_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp35_);
	_tmp37_ = _tmp36_;
	_tmp38_ = ccall;
	vala_ccode_function_add_assignment (_tmp34_, _tmp37_, (ValaCCodeExpression*) _tmp38_);
	_vala_ccode_node_unref0 (_tmp37_);
	_tmp39_ = detail_value;
	_tmp40_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp39_);
	result = _tmp40_;
	_vala_ccode_node_unref0 (ccall);
	_vala_target_value_unref0 (detail_value);
	return result;
}


static ValaCCodeExpression*
vala_gsignal_module_get_signal_id_cexpression (ValaGSignalModule* self,
                                               ValaSignal* sig)
{
	ValaCCodeExpression* result = NULL;
	ValaTypeSymbol* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaTypeSymbol* _tmp2_;
	ValaCCodeIdentifier* signal_array = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	ValaCCodeIdentifier* _tmp7_;
	ValaCCodeIdentifier* _tmp8_;
	ValaCCodeIdentifier* signal_enum_value = NULL;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	ValaCCodeIdentifier* _tmp16_;
	ValaCCodeElementAccess* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
	cl = _tmp2_;
	_tmp3_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) cl, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("%s_signals", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_ccode_identifier_new (_tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	signal_array = _tmp8_;
	_tmp9_ = vala_get_ccode_upper_case_name ((ValaSymbol*) cl, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp10_, _tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_ccode_identifier_new (_tmp14_);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	signal_enum_value = _tmp16_;
	_tmp17_ = vala_ccode_element_access_new ((ValaCCodeExpression*) signal_array, (ValaCCodeExpression*) signal_enum_value);
	result = (ValaCCodeExpression*) _tmp17_;
	_vala_ccode_node_unref0 (signal_enum_value);
	_vala_ccode_node_unref0 (signal_array);
	_vala_code_node_unref0 (cl);
	return result;
}


static ValaCCodeExpression*
vala_gsignal_module_get_detail_cexpression (ValaGSignalModule* self,
                                            ValaExpression* detail_expr,
                                            ValaCodeNode* node)
{
	ValaCCodeExpression* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaDataType* _tmp1_;
	ValaDataType* _tmp2_;
	ValaCCodeExpression* detail_cexpr = NULL;
	ValaCCodeExpression* _tmp8_;
	ValaCCodeFunctionCall* detail_ccall = NULL;
	ValaCCodeExpression* _tmp9_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeExpression* _tmp17_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (detail_expr != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	_tmp1_ = vala_expression_get_value_type (detail_expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_NULL_TYPE)) {
		_tmp0_ = TRUE;
	} else {
		ValaDataType* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		_tmp3_ = vala_expression_get_value_type (detail_expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = ((ValaCCodeBaseModule*) self)->string_type;
		_tmp0_ = !vala_data_type_compatible (_tmp4_, _tmp5_);
	}
	if (_tmp0_) {
		ValaSourceReference* _tmp6_;
		ValaSourceReference* _tmp7_;
		vala_code_node_set_error (node, TRUE);
		_tmp6_ = vala_code_node_get_source_reference ((ValaCodeNode*) detail_expr);
		_tmp7_ = _tmp6_;
		vala_report_error (_tmp7_, "only string details are supported");
		result = NULL;
		return result;
	}
	_tmp8_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, detail_expr);
	detail_cexpr = _tmp8_;
	_tmp9_ = detail_cexpr;
	if (vala_ccode_base_module_is_constant_ccode_expression ((ValaCCodeBaseModule*) self, _tmp9_)) {
		ValaCCodeIdentifier* _tmp10_;
		ValaCCodeIdentifier* _tmp11_;
		ValaCCodeFunctionCall* _tmp12_;
		_tmp10_ = vala_ccode_identifier_new ("g_quark_from_static_string");
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp11_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp12_;
		_vala_ccode_node_unref0 (_tmp11_);
	} else {
		ValaCCodeIdentifier* _tmp13_;
		ValaCCodeIdentifier* _tmp14_;
		ValaCCodeFunctionCall* _tmp15_;
		_tmp13_ = vala_ccode_identifier_new ("g_quark_from_string");
		_tmp14_ = _tmp13_;
		_tmp15_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (detail_ccall);
		detail_ccall = _tmp15_;
		_vala_ccode_node_unref0 (_tmp14_);
	}
	_tmp16_ = detail_ccall;
	_tmp17_ = detail_cexpr;
	vala_ccode_function_call_add_argument (_tmp16_, _tmp17_);
	result = (ValaCCodeExpression*) detail_ccall;
	_vala_ccode_node_unref0 (detail_cexpr);
	return result;
}


static void
vala_gsignal_module_real_visit_signal (ValaCodeVisitor* base,
                                       ValaSignal* sig)
{
	ValaGSignalModule * self;
	ValaClass* cl = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaClass* _tmp2_;
	gboolean _tmp3_ = FALSE;
	ValaClass* _tmp4_;
	ValaClass* _tmp10_;
	gboolean _tmp31_ = FALSE;
	ValaCCodeEnum* _tmp32_;
	ValaList* params = NULL;
	ValaList* _tmp46_;
	ValaDataType* _tmp66_;
	ValaDataType* _tmp67_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (sig != NULL);
	_tmp0_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_CLASS) ? ((ValaClass*) _tmp1_) : NULL);
	cl = _tmp2_;
	_tmp4_ = cl;
	if (_tmp4_ != NULL) {
		ValaClass* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = cl;
		_tmp6_ = vala_class_get_is_compact (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "Signals are not supported in compact classes");
		_vala_code_node_unref0 (cl);
		return;
	}
	_tmp10_ = cl;
	if (_tmp10_ != NULL) {
		{
			ValaList* _base_type_list = NULL;
			ValaClass* _tmp11_;
			ValaList* _tmp12_;
			gint _base_type_size = 0;
			ValaList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _base_type_index = 0;
			_tmp11_ = cl;
			_tmp12_ = vala_class_get_base_types (_tmp11_);
			_base_type_list = _tmp12_;
			_tmp13_ = _base_type_list;
			_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_base_type_size = _tmp15_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp18_;
				gint _tmp19_;
				gpointer _tmp20_;
				ValaDataType* _tmp21_;
				ValaTypeSymbol* _tmp22_;
				ValaTypeSymbol* _tmp23_;
				const gchar* _tmp24_;
				const gchar* _tmp25_;
				ValaSymbol* _tmp26_;
				ValaSymbol* _tmp27_;
				gboolean _tmp28_;
				_base_type_index = _base_type_index + 1;
				_tmp16_ = _base_type_index;
				_tmp17_ = _base_type_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _base_type_list;
				_tmp19_ = _base_type_index;
				_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
				base_type = (ValaDataType*) _tmp20_;
				_tmp21_ = base_type;
				_tmp22_ = vala_data_type_get_data_type (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_symbol_get_name ((ValaSymbol*) sig);
				_tmp25_ = _tmp24_;
				_tmp26_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) _tmp23_, _tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp27_, VALA_TYPE_SIGNAL);
				_vala_code_node_unref0 (_tmp27_);
				if (_tmp28_) {
					ValaSourceReference* _tmp29_;
					ValaSourceReference* _tmp30_;
					vala_code_node_set_error ((ValaCodeNode*) sig, TRUE);
					_tmp29_ = vala_code_node_get_source_reference ((ValaCodeNode*) sig);
					_tmp30_ = _tmp29_;
					vala_report_error (_tmp30_, "Signals with the same name as a signal in a base type are not supporte" \
"d");
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					_vala_code_node_unref0 (cl);
					return;
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
	}
	_tmp32_ = ((ValaCCodeBaseModule*) self)->signal_enum;
	if (_tmp32_ != NULL) {
		ValaSymbol* _tmp33_;
		ValaSymbol* _tmp34_;
		_tmp33_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp34_ = _tmp33_;
		_tmp31_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp34_, VALA_TYPE_TYPESYMBOL);
	} else {
		_tmp31_ = FALSE;
	}
	if (_tmp31_) {
		ValaCCodeEnum* _tmp35_;
		ValaSymbol* _tmp36_;
		ValaSymbol* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		ValaCCodeEnumValue* _tmp44_;
		ValaCCodeEnumValue* _tmp45_;
		_tmp35_ = ((ValaCCodeBaseModule*) self)->signal_enum;
		_tmp36_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_get_ccode_upper_case_name ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp37_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol), NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_get_ccode_upper_case_name ((ValaSymbol*) sig, NULL);
		_tmp41_ = _tmp40_;
		_tmp42_ = g_strdup_printf ("%s_%s_SIGNAL", _tmp39_, _tmp41_);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_ccode_enum_value_new (_tmp43_, NULL);
		_tmp45_ = _tmp44_;
		vala_ccode_enum_add_value (_tmp35_, _tmp45_);
		_vala_ccode_node_unref0 (_tmp45_);
		_g_free0 (_tmp43_);
		_g_free0 (_tmp41_);
		_g_free0 (_tmp39_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) sig, (ValaCodeVisitor*) self);
	_tmp46_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp46_;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp47_;
		ValaList* _tmp48_;
		gint _p_size = 0;
		ValaList* _tmp49_;
		gint _tmp50_;
		gint _tmp51_;
		gint _p_index = 0;
		_tmp47_ = params;
		_tmp48_ = _vala_iterable_ref0 (_tmp47_);
		_p_list = _tmp48_;
		_tmp49_ = _p_list;
		_tmp50_ = vala_collection_get_size ((ValaCollection*) _tmp49_);
		_tmp51_ = _tmp50_;
		_p_size = _tmp51_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp52_;
			gint _tmp53_;
			ValaParameter* p = NULL;
			ValaList* _tmp54_;
			gint _tmp55_;
			gpointer _tmp56_;
			ValaParameter* _tmp57_;
			ValaCCodeFile* _tmp58_;
			GHashFunc _tmp59_;
			GEqualFunc _tmp60_;
			GEqualFunc _tmp61_;
			ValaHashMap* _tmp62_;
			ValaHashMap* _tmp63_;
			ValaCCodeParameter* _tmp64_;
			ValaCCodeParameter* _tmp65_;
			_p_index = _p_index + 1;
			_tmp52_ = _p_index;
			_tmp53_ = _p_size;
			if (!(_tmp52_ < _tmp53_)) {
				break;
			}
			_tmp54_ = _p_list;
			_tmp55_ = _p_index;
			_tmp56_ = vala_list_get (_tmp54_, _tmp55_);
			p = (ValaParameter*) _tmp56_;
			_tmp57_ = p;
			_tmp58_ = ((ValaCCodeBaseModule*) self)->cfile;
			_tmp59_ = g_direct_hash;
			_tmp60_ = g_direct_equal;
			_tmp61_ = g_direct_equal;
			_tmp62_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_PARAMETER, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp59_, _tmp60_, _tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = vala_ccode_method_module_generate_parameter ((ValaCCodeMethodModule*) self, _tmp57_, _tmp58_, (ValaMap*) _tmp63_, NULL);
			_tmp65_ = _tmp64_;
			_vala_ccode_node_unref0 (_tmp65_);
			_vala_map_unref0 (_tmp63_);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp66_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp67_ = _tmp66_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp67_)) {
		ValaList* _tmp68_;
		ValaVoidType* _tmp69_;
		ValaVoidType* _tmp70_;
		_tmp68_ = params;
		_tmp69_ = vala_void_type_new (NULL);
		_tmp70_ = _tmp69_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp68_, (ValaDataType*) _tmp70_);
		_vala_code_node_unref0 (_tmp70_);
	} else {
		ValaList* _tmp71_;
		ValaDataType* _tmp72_;
		ValaDataType* _tmp73_;
		_tmp71_ = params;
		_tmp72_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp73_ = _tmp72_;
		vala_gsignal_module_generate_marshaller (self, sig, _tmp71_, _tmp73_);
	}
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (cl);
}


static void
vala_gsignal_module_generate_marshaller (ValaGSignalModule* self,
                                         ValaSignal* sig,
                                         ValaList* params,
                                         ValaDataType* return_type)
{
	gchar* signature = NULL;
	gint n_params = 0;
	gint i = 0;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	ValaSet* _tmp2_;
	const gchar* _tmp3_;
	ValaCCodeFunction* signal_marshaller = NULL;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeParameter* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeParameter* _tmp15_;
	ValaCCodeParameter* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeParameter* _tmp18_;
	ValaCCodeParameter* _tmp19_;
	ValaCCodeFunction* _tmp20_;
	ValaCCodeParameter* _tmp21_;
	ValaCCodeParameter* _tmp22_;
	ValaCCodeFunction* _tmp23_;
	ValaCCodeParameter* _tmp24_;
	ValaCCodeParameter* _tmp25_;
	ValaCCodeFunction* _tmp26_;
	ValaCCodeParameter* _tmp27_;
	ValaCCodeParameter* _tmp28_;
	ValaCCodeFunction* _tmp29_;
	ValaCCodeFunctionDeclarator* callback_decl = NULL;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaCCodeFunctionDeclarator* _tmp32_;
	ValaCCodeFunctionDeclarator* _tmp33_;
	ValaCCodeFunctionDeclarator* _tmp34_;
	ValaCCodeParameter* _tmp35_;
	ValaCCodeParameter* _tmp36_;
	ValaDataType* _tmp100_;
	ValaDataType* _tmp101_;
	ValaCCodeFunctionDeclarator* _tmp109_;
	ValaCCodeParameter* _tmp110_;
	ValaCCodeParameter* _tmp111_;
	ValaCCodeFunction* _tmp112_;
	ValaCCodeFunction* _tmp113_;
	gchar* _tmp114_;
	gchar* _tmp115_;
	ValaCCodeFunctionDeclarator* _tmp116_;
	ValaCCodeTypeDefinition* _tmp117_;
	ValaCCodeTypeDefinition* _tmp118_;
	ValaCCodeFunction* _tmp119_;
	ValaCCodeFunction* _tmp120_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	ValaCCodeVariableDeclarator* _tmp123_;
	ValaCCodeVariableDeclarator* _tmp124_;
	ValaCCodeFunction* _tmp125_;
	ValaCCodeFunction* _tmp126_;
	ValaCCodeIdentifier* _tmp127_;
	ValaCCodeIdentifier* _tmp128_;
	ValaCCodeCastExpression* _tmp129_;
	ValaCCodeCastExpression* _tmp130_;
	ValaCCodeVariableDeclarator* _tmp131_;
	ValaCCodeVariableDeclarator* _tmp132_;
	ValaCCodeFunction* _tmp133_;
	ValaCCodeFunction* _tmp134_;
	ValaCCodeVariableDeclarator* _tmp135_;
	ValaCCodeVariableDeclarator* _tmp136_;
	ValaCCodeFunction* _tmp137_;
	ValaCCodeFunction* _tmp138_;
	ValaCCodeVariableDeclarator* _tmp139_;
	ValaCCodeVariableDeclarator* _tmp140_;
	ValaCCodeFunctionCall* fc = NULL;
	gboolean _tmp141_ = FALSE;
	ValaTypeSymbol* _tmp142_;
	ValaTypeSymbol* _tmp143_;
	ValaCCodeIdentifier* _tmp163_;
	ValaCCodeIdentifier* _tmp164_;
	ValaCCodeFunctionCall* _tmp165_;
	ValaCCodeFunctionCall* _tmp166_;
	ValaCCodeIdentifier* _tmp167_;
	ValaCCodeIdentifier* _tmp168_;
	gint _tmp169_;
	gchar* _tmp170_;
	gchar* _tmp171_;
	ValaCCodeConstant* _tmp172_;
	ValaCCodeConstant* _tmp173_;
	ValaCCodeBinaryExpression* _tmp174_;
	ValaCCodeBinaryExpression* _tmp175_;
	ValaCCodeFunction* _tmp176_;
	ValaCCodeFunction* _tmp177_;
	ValaCCodeFunctionCall* _tmp178_;
	ValaCCodeMemberAccess* data = NULL;
	ValaCCodeIdentifier* _tmp179_;
	ValaCCodeIdentifier* _tmp180_;
	ValaCCodeMemberAccess* _tmp181_;
	ValaCCodeMemberAccess* _tmp182_;
	ValaCCodeMemberAccess* param = NULL;
	ValaCCodeIdentifier* _tmp183_;
	ValaCCodeIdentifier* _tmp184_;
	ValaCCodeMemberAccess* _tmp185_;
	ValaCCodeMemberAccess* _tmp186_;
	ValaCCodeMemberAccess* _tmp187_;
	ValaCCodeMemberAccess* _tmp188_;
	ValaCCodeFunctionCall* cond = NULL;
	ValaCCodeConstant* _tmp189_;
	ValaCCodeConstant* _tmp190_;
	ValaCCodeFunctionCall* _tmp191_;
	ValaCCodeFunctionCall* _tmp192_;
	ValaCCodeFunctionCall* _tmp193_;
	ValaCCodeIdentifier* _tmp194_;
	ValaCCodeIdentifier* _tmp195_;
	ValaCCodeFunction* _tmp196_;
	ValaCCodeFunction* _tmp197_;
	ValaCCodeFunctionCall* _tmp198_;
	ValaCCodeFunction* _tmp199_;
	ValaCCodeFunction* _tmp200_;
	ValaCCodeIdentifier* _tmp201_;
	ValaCCodeIdentifier* _tmp202_;
	ValaCCodeMemberAccess* _tmp203_;
	ValaCCodeFunction* _tmp204_;
	ValaCCodeFunction* _tmp205_;
	ValaCCodeIdentifier* _tmp206_;
	ValaCCodeIdentifier* _tmp207_;
	ValaCCodeMemberAccess* _tmp208_;
	ValaCCodeFunction* _tmp209_;
	ValaCCodeFunction* _tmp210_;
	ValaCCodeFunction* _tmp211_;
	ValaCCodeFunction* _tmp212_;
	ValaCCodeIdentifier* _tmp213_;
	ValaCCodeIdentifier* _tmp214_;
	ValaCCodeMemberAccess* _tmp215_;
	ValaCCodeFunction* _tmp216_;
	ValaCCodeFunction* _tmp217_;
	ValaCCodeIdentifier* _tmp218_;
	ValaCCodeIdentifier* _tmp219_;
	ValaCCodeMemberAccess* _tmp220_;
	ValaCCodeFunction* _tmp221_;
	ValaCCodeFunction* _tmp222_;
	ValaCCodeCastExpression* c_assign_rhs = NULL;
	ValaCCodeIdentifier* _tmp223_;
	ValaCCodeIdentifier* _tmp224_;
	ValaCCodeIdentifier* _tmp225_;
	ValaCCodeIdentifier* _tmp226_;
	ValaCCodeIdentifier* _tmp227_;
	ValaCCodeIdentifier* _tmp228_;
	ValaCCodeMemberAccess* _tmp229_;
	ValaCCodeMemberAccess* _tmp230_;
	ValaCCodeConditionalExpression* _tmp231_;
	ValaCCodeConditionalExpression* _tmp232_;
	gchar* _tmp233_;
	gchar* _tmp234_;
	ValaCCodeCastExpression* _tmp235_;
	ValaCCodeCastExpression* _tmp236_;
	ValaCCodeFunction* _tmp237_;
	ValaCCodeFunction* _tmp238_;
	ValaCCodeIdentifier* _tmp239_;
	ValaCCodeIdentifier* _tmp240_;
	ValaCCodeCastExpression* _tmp241_;
	ValaCCodeIdentifier* _tmp242_;
	ValaCCodeIdentifier* _tmp243_;
	ValaCCodeFunctionCall* _tmp244_;
	ValaCCodeFunctionCall* _tmp245_;
	ValaCCodeIdentifier* _tmp246_;
	ValaCCodeIdentifier* _tmp247_;
	ValaDataType* _tmp365_;
	ValaDataType* _tmp366_;
	ValaCCodeFunctionCall* _tmp384_;
	ValaCCodeIdentifier* _tmp385_;
	ValaCCodeIdentifier* _tmp386_;
	gboolean _tmp387_ = FALSE;
	ValaTypeSymbol* _tmp388_;
	ValaTypeSymbol* _tmp389_;
	ValaCCodeFile* _tmp418_;
	ValaCCodeFunction* _tmp419_;
	ValaCCodeFile* _tmp420_;
	ValaCCodeFunction* _tmp421_;
	ValaSet* _tmp422_;
	const gchar* _tmp423_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sig != NULL);
	g_return_if_fail (params != NULL);
	g_return_if_fail (return_type != NULL);
	_tmp0_ = vala_gsignal_module_get_marshaller_signature (self, sig, params, return_type);
	_g_free0 (signature);
	signature = _tmp0_;
	_tmp2_ = ((ValaCCodeBaseModule*) self)->predefined_marshal_set;
	_tmp3_ = signature;
	if (vala_collection_contains ((ValaCollection*) _tmp2_, _tmp3_)) {
		_tmp1_ = TRUE;
	} else {
		ValaSet* _tmp4_;
		const gchar* _tmp5_;
		_tmp4_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
		_tmp5_ = signature;
		_tmp1_ = vala_collection_contains ((ValaCollection*) _tmp4_, _tmp5_);
	}
	if (_tmp1_) {
		_g_free0 (signature);
		return;
	}
	_tmp6_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_ccode_function_new (_tmp7_, "void");
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	signal_marshaller = _tmp9_;
	_tmp10_ = signal_marshaller;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp10_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp11_ = signal_marshaller;
	_tmp12_ = vala_ccode_parameter_new ("closure", "GClosure *");
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_parameter (_tmp11_, _tmp13_);
	_vala_ccode_node_unref0 (_tmp13_);
	_tmp14_ = signal_marshaller;
	_tmp15_ = vala_ccode_parameter_new ("return_value", "GValue *");
	_tmp16_ = _tmp15_;
	vala_ccode_function_add_parameter (_tmp14_, _tmp16_);
	_vala_ccode_node_unref0 (_tmp16_);
	_tmp17_ = signal_marshaller;
	_tmp18_ = vala_ccode_parameter_new ("n_param_values", "guint");
	_tmp19_ = _tmp18_;
	vala_ccode_function_add_parameter (_tmp17_, _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	_tmp20_ = signal_marshaller;
	_tmp21_ = vala_ccode_parameter_new ("param_values", "const GValue *");
	_tmp22_ = _tmp21_;
	vala_ccode_function_add_parameter (_tmp20_, _tmp22_);
	_vala_ccode_node_unref0 (_tmp22_);
	_tmp23_ = signal_marshaller;
	_tmp24_ = vala_ccode_parameter_new ("invocation_hint", "gpointer");
	_tmp25_ = _tmp24_;
	vala_ccode_function_add_parameter (_tmp23_, _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = signal_marshaller;
	_tmp27_ = vala_ccode_parameter_new ("marshal_data", "gpointer");
	_tmp28_ = _tmp27_;
	vala_ccode_function_add_parameter (_tmp26_, _tmp28_);
	_vala_ccode_node_unref0 (_tmp28_);
	_tmp29_ = signal_marshaller;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp29_);
	_tmp30_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_ccode_function_declarator_new (_tmp31_);
	_tmp33_ = _tmp32_;
	_g_free0 (_tmp31_);
	callback_decl = _tmp33_;
	_tmp34_ = callback_decl;
	_tmp35_ = vala_ccode_parameter_new ("data1", "gpointer");
	_tmp36_ = _tmp35_;
	vala_ccode_function_declarator_add_parameter (_tmp34_, _tmp36_);
	_vala_ccode_node_unref0 (_tmp36_);
	n_params = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp37_;
		gint _p_size = 0;
		ValaList* _tmp38_;
		gint _tmp39_;
		gint _tmp40_;
		gint _p_index = 0;
		_tmp37_ = _vala_iterable_ref0 (params);
		_p_list = _tmp37_;
		_tmp38_ = _p_list;
		_tmp39_ = vala_collection_get_size ((ValaCollection*) _tmp38_);
		_tmp40_ = _tmp39_;
		_p_size = _tmp40_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp41_;
			gint _tmp42_;
			ValaParameter* p = NULL;
			ValaList* _tmp43_;
			gint _tmp44_;
			gpointer _tmp45_;
			ValaCCodeFunctionDeclarator* _tmp46_;
			gint _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			ValaParameter* _tmp50_;
			gchar* _tmp51_;
			gchar* _tmp52_;
			ValaCCodeParameter* _tmp53_;
			ValaCCodeParameter* _tmp54_;
			gint _tmp55_;
			ValaParameter* _tmp56_;
			ValaDataType* _tmp57_;
			ValaDataType* _tmp58_;
			_p_index = _p_index + 1;
			_tmp41_ = _p_index;
			_tmp42_ = _p_size;
			if (!(_tmp41_ < _tmp42_)) {
				break;
			}
			_tmp43_ = _p_list;
			_tmp44_ = _p_index;
			_tmp45_ = vala_list_get (_tmp43_, _tmp44_);
			p = (ValaParameter*) _tmp45_;
			_tmp46_ = callback_decl;
			_tmp47_ = n_params;
			_tmp48_ = g_strdup_printf ("arg_%d", _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = p;
			_tmp51_ = vala_gsignal_module_get_value_type_name_from_parameter (self, _tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_ccode_parameter_new (_tmp49_, _tmp52_);
			_tmp54_ = _tmp53_;
			vala_ccode_function_declarator_add_parameter (_tmp46_, _tmp54_);
			_vala_ccode_node_unref0 (_tmp54_);
			_g_free0 (_tmp52_);
			_g_free0 (_tmp49_);
			_tmp55_ = n_params;
			n_params = _tmp55_ + 1;
			_tmp56_ = p;
			_tmp57_ = vala_variable_get_variable_type ((ValaVariable*) _tmp56_);
			_tmp58_ = _tmp57_;
			if (vala_data_type_is_array (_tmp58_)) {
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp59_ = FALSE;
						_tmp59_ = TRUE;
						while (TRUE) {
							gint _tmp61_;
							ValaParameter* _tmp62_;
							ValaDataType* _tmp63_;
							ValaDataType* _tmp64_;
							gint _tmp65_;
							gint _tmp66_;
							ValaCCodeFunctionDeclarator* _tmp67_;
							gint _tmp68_;
							gchar* _tmp69_;
							gchar* _tmp70_;
							ValaCCodeParameter* _tmp71_;
							ValaCCodeParameter* _tmp72_;
							gint _tmp73_;
							if (!_tmp59_) {
								gint _tmp60_;
								_tmp60_ = j;
								j = _tmp60_ + 1;
							}
							_tmp59_ = FALSE;
							_tmp61_ = j;
							_tmp62_ = p;
							_tmp63_ = vala_variable_get_variable_type ((ValaVariable*) _tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp64_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp66_ = _tmp65_;
							if (!(_tmp61_ < _tmp66_)) {
								break;
							}
							_tmp67_ = callback_decl;
							_tmp68_ = n_params;
							_tmp69_ = g_strdup_printf ("arg_%d", _tmp68_);
							_tmp70_ = _tmp69_;
							_tmp71_ = vala_ccode_parameter_new (_tmp70_, "gint");
							_tmp72_ = _tmp71_;
							vala_ccode_function_declarator_add_parameter (_tmp67_, _tmp72_);
							_vala_ccode_node_unref0 (_tmp72_);
							_g_free0 (_tmp70_);
							_tmp73_ = n_params;
							n_params = _tmp73_ + 1;
						}
					}
				}
			} else {
				ValaParameter* _tmp74_;
				ValaDataType* _tmp75_;
				ValaDataType* _tmp76_;
				_tmp74_ = p;
				_tmp75_ = vala_variable_get_variable_type ((ValaVariable*) _tmp74_);
				_tmp76_ = _tmp75_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp76_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp77_;
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					ValaDelegateType* _tmp80_;
					ValaDelegate* _tmp81_;
					ValaDelegate* _tmp82_;
					gboolean _tmp83_;
					gboolean _tmp84_;
					_tmp77_ = p;
					_tmp78_ = vala_variable_get_variable_type ((ValaVariable*) _tmp77_);
					_tmp79_ = _tmp78_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp79_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp80_ = delegate_type;
					_tmp81_ = vala_delegate_type_get_delegate_symbol (_tmp80_);
					_tmp82_ = _tmp81_;
					_tmp83_ = vala_delegate_get_has_target (_tmp82_);
					_tmp84_ = _tmp83_;
					if (_tmp84_) {
						ValaCCodeFunctionDeclarator* _tmp85_;
						gint _tmp86_;
						gchar* _tmp87_;
						gchar* _tmp88_;
						ValaCCodeParameter* _tmp89_;
						ValaCCodeParameter* _tmp90_;
						gint _tmp91_;
						ValaDelegateType* _tmp92_;
						_tmp85_ = callback_decl;
						_tmp86_ = n_params;
						_tmp87_ = g_strdup_printf ("arg_%d", _tmp86_);
						_tmp88_ = _tmp87_;
						_tmp89_ = vala_ccode_parameter_new (_tmp88_, "gpointer");
						_tmp90_ = _tmp89_;
						vala_ccode_function_declarator_add_parameter (_tmp85_, _tmp90_);
						_vala_ccode_node_unref0 (_tmp90_);
						_g_free0 (_tmp88_);
						_tmp91_ = n_params;
						n_params = _tmp91_ + 1;
						_tmp92_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp92_)) {
							ValaCCodeFunctionDeclarator* _tmp93_;
							gint _tmp94_;
							gchar* _tmp95_;
							gchar* _tmp96_;
							ValaCCodeParameter* _tmp97_;
							ValaCCodeParameter* _tmp98_;
							gint _tmp99_;
							_tmp93_ = callback_decl;
							_tmp94_ = n_params;
							_tmp95_ = g_strdup_printf ("arg_%d", _tmp94_);
							_tmp96_ = _tmp95_;
							_tmp97_ = vala_ccode_parameter_new (_tmp96_, "GDestroyNotify");
							_tmp98_ = _tmp97_;
							vala_ccode_function_declarator_add_parameter (_tmp93_, _tmp98_);
							_vala_ccode_node_unref0 (_tmp98_);
							_g_free0 (_tmp96_);
							_tmp99_ = n_params;
							n_params = _tmp99_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp100_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp101_ = _tmp100_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp101_)) {
		ValaCCodeFunctionDeclarator* _tmp102_;
		gint _tmp103_;
		gchar* _tmp104_;
		gchar* _tmp105_;
		ValaCCodeParameter* _tmp106_;
		ValaCCodeParameter* _tmp107_;
		gint _tmp108_;
		_tmp102_ = callback_decl;
		_tmp103_ = n_params;
		_tmp104_ = g_strdup_printf ("arg_%d", _tmp103_);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_ccode_parameter_new (_tmp105_, "gpointer");
		_tmp107_ = _tmp106_;
		vala_ccode_function_declarator_add_parameter (_tmp102_, _tmp107_);
		_vala_ccode_node_unref0 (_tmp107_);
		_g_free0 (_tmp105_);
		_tmp108_ = n_params;
		n_params = _tmp108_ + 1;
	}
	_tmp109_ = callback_decl;
	_tmp110_ = vala_ccode_parameter_new ("data2", "gpointer");
	_tmp111_ = _tmp110_;
	vala_ccode_function_declarator_add_parameter (_tmp109_, _tmp111_);
	_vala_ccode_node_unref0 (_tmp111_);
	_tmp112_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp113_ = _tmp112_;
	_tmp114_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
	_tmp115_ = _tmp114_;
	_tmp116_ = callback_decl;
	_tmp117_ = vala_ccode_type_definition_new (_tmp115_, (ValaCCodeDeclarator*) _tmp116_);
	_tmp118_ = _tmp117_;
	vala_ccode_function_add_statement (_tmp113_, (ValaCCodeNode*) _tmp118_);
	_vala_ccode_node_unref0 (_tmp118_);
	_g_free0 (_tmp115_);
	_tmp119_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp120_ = _tmp119_;
	_tmp121_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp122_ = _tmp121_;
	_tmp123_ = vala_ccode_variable_declarator_new ("callback", NULL, NULL);
	_tmp124_ = _tmp123_;
	vala_ccode_function_add_declaration (_tmp120_, _tmp122_, (ValaCCodeDeclarator*) _tmp124_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp124_);
	_g_free0 (_tmp122_);
	_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp126_ = _tmp125_;
	_tmp127_ = vala_ccode_identifier_new ("closure");
	_tmp128_ = _tmp127_;
	_tmp129_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp128_, "GCClosure *");
	_tmp130_ = _tmp129_;
	_tmp131_ = vala_ccode_variable_declarator_new ("cc", (ValaCCodeExpression*) _tmp130_, NULL);
	_tmp132_ = _tmp131_;
	vala_ccode_function_add_declaration (_tmp126_, "GCClosure *", (ValaCCodeDeclarator*) _tmp132_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp132_);
	_vala_ccode_node_unref0 (_tmp130_);
	_vala_ccode_node_unref0 (_tmp128_);
	_tmp133_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp134_ = _tmp133_;
	_tmp135_ = vala_ccode_variable_declarator_new ("data1", NULL, NULL);
	_tmp136_ = _tmp135_;
	vala_ccode_function_add_declaration (_tmp134_, "gpointer", (ValaCCodeDeclarator*) _tmp136_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp136_);
	_tmp137_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp138_ = _tmp137_;
	_tmp139_ = vala_ccode_variable_declarator_new ("data2", NULL, NULL);
	_tmp140_ = _tmp139_;
	vala_ccode_function_add_declaration (_tmp138_, "gpointer", (ValaCCodeDeclarator*) _tmp140_, VALA_CCODE_MODIFIERS_REGISTER);
	_vala_ccode_node_unref0 (_tmp140_);
	_tmp142_ = vala_data_type_get_data_type (return_type);
	_tmp143_ = _tmp142_;
	if (_tmp143_ != NULL) {
		_tmp141_ = TRUE;
	} else {
		_tmp141_ = vala_data_type_is_array (return_type);
	}
	if (_tmp141_) {
		ValaCCodeFunction* _tmp144_;
		ValaCCodeFunction* _tmp145_;
		gchar* _tmp146_;
		gchar* _tmp147_;
		ValaCCodeVariableDeclarator* _tmp148_;
		ValaCCodeVariableDeclarator* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaCCodeFunctionCall* _tmp153_;
		ValaCCodeIdentifier* _tmp154_;
		ValaCCodeIdentifier* _tmp155_;
		ValaCCodeConstant* _tmp156_;
		ValaCCodeConstant* _tmp157_;
		ValaCCodeBinaryExpression* _tmp158_;
		ValaCCodeBinaryExpression* _tmp159_;
		ValaCCodeFunction* _tmp160_;
		ValaCCodeFunction* _tmp161_;
		ValaCCodeFunctionCall* _tmp162_;
		_tmp144_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_gsignal_module_get_value_type_name_from_type_reference (self, return_type);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_ccode_variable_declarator_new ("v_return", NULL, NULL);
		_tmp149_ = _tmp148_;
		vala_ccode_function_add_declaration (_tmp145_, _tmp147_, (ValaCCodeDeclarator*) _tmp149_, 0);
		_vala_ccode_node_unref0 (_tmp149_);
		_g_free0 (_tmp147_);
		_tmp150_ = vala_ccode_identifier_new ("g_return_if_fail");
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (fc);
		fc = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_tmp153_ = fc;
		_tmp154_ = vala_ccode_identifier_new ("return_value");
		_tmp155_ = _tmp154_;
		_tmp156_ = vala_ccode_constant_new ("NULL");
		_tmp157_ = _tmp156_;
		_tmp158_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, (ValaCCodeExpression*) _tmp155_, (ValaCCodeExpression*) _tmp157_);
		_tmp159_ = _tmp158_;
		vala_ccode_function_call_add_argument (_tmp153_, (ValaCCodeExpression*) _tmp159_);
		_vala_ccode_node_unref0 (_tmp159_);
		_vala_ccode_node_unref0 (_tmp157_);
		_vala_ccode_node_unref0 (_tmp155_);
		_tmp160_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp161_ = _tmp160_;
		_tmp162_ = fc;
		vala_ccode_function_add_expression (_tmp161_, (ValaCCodeExpression*) _tmp162_);
	}
	_tmp163_ = vala_ccode_identifier_new ("g_return_if_fail");
	_tmp164_ = _tmp163_;
	_tmp165_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp164_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp165_;
	_vala_ccode_node_unref0 (_tmp164_);
	_tmp166_ = fc;
	_tmp167_ = vala_ccode_identifier_new ("n_param_values");
	_tmp168_ = _tmp167_;
	_tmp169_ = n_params;
	_tmp170_ = g_strdup_printf ("%i", _tmp169_);
	_tmp171_ = _tmp170_;
	_tmp172_ = vala_ccode_constant_new (_tmp171_);
	_tmp173_ = _tmp172_;
	_tmp174_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp168_, (ValaCCodeExpression*) _tmp173_);
	_tmp175_ = _tmp174_;
	vala_ccode_function_call_add_argument (_tmp166_, (ValaCCodeExpression*) _tmp175_);
	_vala_ccode_node_unref0 (_tmp175_);
	_vala_ccode_node_unref0 (_tmp173_);
	_g_free0 (_tmp171_);
	_vala_ccode_node_unref0 (_tmp168_);
	_tmp176_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp177_ = _tmp176_;
	_tmp178_ = fc;
	vala_ccode_function_add_expression (_tmp177_, (ValaCCodeExpression*) _tmp178_);
	_tmp179_ = vala_ccode_identifier_new ("closure");
	_tmp180_ = _tmp179_;
	_tmp181_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp180_, "data", TRUE);
	_tmp182_ = _tmp181_;
	_vala_ccode_node_unref0 (_tmp180_);
	data = _tmp182_;
	_tmp183_ = vala_ccode_identifier_new ("param_values");
	_tmp184_ = _tmp183_;
	_tmp185_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp184_, "data[0]", TRUE);
	_tmp186_ = _tmp185_;
	_tmp187_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp186_, "v_pointer", FALSE);
	_tmp188_ = _tmp187_;
	_vala_ccode_node_unref0 (_tmp186_);
	_vala_ccode_node_unref0 (_tmp184_);
	param = _tmp188_;
	_tmp189_ = vala_ccode_constant_new ("G_CCLOSURE_SWAP_DATA");
	_tmp190_ = _tmp189_;
	_tmp191_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp190_);
	_tmp192_ = _tmp191_;
	_vala_ccode_node_unref0 (_tmp190_);
	cond = _tmp192_;
	_tmp193_ = cond;
	_tmp194_ = vala_ccode_identifier_new ("closure");
	_tmp195_ = _tmp194_;
	vala_ccode_function_call_add_argument (_tmp193_, (ValaCCodeExpression*) _tmp195_);
	_vala_ccode_node_unref0 (_tmp195_);
	_tmp196_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp197_ = _tmp196_;
	_tmp198_ = cond;
	vala_ccode_function_open_if (_tmp197_, (ValaCCodeExpression*) _tmp198_);
	_tmp199_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp200_ = _tmp199_;
	_tmp201_ = vala_ccode_identifier_new ("data1");
	_tmp202_ = _tmp201_;
	_tmp203_ = data;
	vala_ccode_function_add_assignment (_tmp200_, (ValaCCodeExpression*) _tmp202_, (ValaCCodeExpression*) _tmp203_);
	_vala_ccode_node_unref0 (_tmp202_);
	_tmp204_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_ccode_identifier_new ("data2");
	_tmp207_ = _tmp206_;
	_tmp208_ = param;
	vala_ccode_function_add_assignment (_tmp205_, (ValaCCodeExpression*) _tmp207_, (ValaCCodeExpression*) _tmp208_);
	_vala_ccode_node_unref0 (_tmp207_);
	_tmp209_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp210_ = _tmp209_;
	vala_ccode_function_add_else (_tmp210_);
	_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp212_ = _tmp211_;
	_tmp213_ = vala_ccode_identifier_new ("data1");
	_tmp214_ = _tmp213_;
	_tmp215_ = param;
	vala_ccode_function_add_assignment (_tmp212_, (ValaCCodeExpression*) _tmp214_, (ValaCCodeExpression*) _tmp215_);
	_vala_ccode_node_unref0 (_tmp214_);
	_tmp216_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp217_ = _tmp216_;
	_tmp218_ = vala_ccode_identifier_new ("data2");
	_tmp219_ = _tmp218_;
	_tmp220_ = data;
	vala_ccode_function_add_assignment (_tmp217_, (ValaCCodeExpression*) _tmp219_, (ValaCCodeExpression*) _tmp220_);
	_vala_ccode_node_unref0 (_tmp219_);
	_tmp221_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp222_ = _tmp221_;
	vala_ccode_function_close (_tmp222_);
	_tmp223_ = vala_ccode_identifier_new ("marshal_data");
	_tmp224_ = _tmp223_;
	_tmp225_ = vala_ccode_identifier_new ("marshal_data");
	_tmp226_ = _tmp225_;
	_tmp227_ = vala_ccode_identifier_new ("cc");
	_tmp228_ = _tmp227_;
	_tmp229_ = vala_ccode_member_access_new ((ValaCCodeExpression*) _tmp228_, "callback", TRUE);
	_tmp230_ = _tmp229_;
	_tmp231_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp224_, (ValaCCodeExpression*) _tmp226_, (ValaCCodeExpression*) _tmp230_);
	_tmp232_ = _tmp231_;
	_tmp233_ = vala_gsignal_module_get_marshaller_function (self, sig, params, return_type, "GMarshalFunc");
	_tmp234_ = _tmp233_;
	_tmp235_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp232_, _tmp234_);
	_tmp236_ = _tmp235_;
	_g_free0 (_tmp234_);
	_vala_ccode_node_unref0 (_tmp232_);
	_vala_ccode_node_unref0 (_tmp230_);
	_vala_ccode_node_unref0 (_tmp228_);
	_vala_ccode_node_unref0 (_tmp226_);
	_vala_ccode_node_unref0 (_tmp224_);
	c_assign_rhs = _tmp236_;
	_tmp237_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp238_ = _tmp237_;
	_tmp239_ = vala_ccode_identifier_new ("callback");
	_tmp240_ = _tmp239_;
	_tmp241_ = c_assign_rhs;
	vala_ccode_function_add_assignment (_tmp238_, (ValaCCodeExpression*) _tmp240_, (ValaCCodeExpression*) _tmp241_);
	_vala_ccode_node_unref0 (_tmp240_);
	_tmp242_ = vala_ccode_identifier_new ("callback");
	_tmp243_ = _tmp242_;
	_tmp244_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp243_);
	_vala_ccode_node_unref0 (fc);
	fc = _tmp244_;
	_vala_ccode_node_unref0 (_tmp243_);
	_tmp245_ = fc;
	_tmp246_ = vala_ccode_identifier_new ("data1");
	_tmp247_ = _tmp246_;
	vala_ccode_function_call_add_argument (_tmp245_, (ValaCCodeExpression*) _tmp247_);
	_vala_ccode_node_unref0 (_tmp247_);
	i = 1;
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp248_;
		gint _p_size = 0;
		ValaList* _tmp249_;
		gint _tmp250_;
		gint _tmp251_;
		gint _p_index = 0;
		_tmp248_ = _vala_iterable_ref0 (params);
		_p_list = _tmp248_;
		_tmp249_ = _p_list;
		_tmp250_ = vala_collection_get_size ((ValaCollection*) _tmp249_);
		_tmp251_ = _tmp250_;
		_p_size = _tmp251_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp252_;
			gint _tmp253_;
			ValaParameter* p = NULL;
			ValaList* _tmp254_;
			gint _tmp255_;
			gpointer _tmp256_;
			ValaCCodeFunctionCall* inner_fc = NULL;
			ValaParameter* _tmp257_;
			ValaParameterDirection _tmp258_;
			ValaParameterDirection _tmp259_;
			ValaCCodeFunctionCall* _tmp281_;
			ValaCCodeIdentifier* _tmp282_;
			ValaCCodeIdentifier* _tmp283_;
			gint _tmp284_;
			gchar* _tmp285_;
			gchar* _tmp286_;
			ValaCCodeIdentifier* _tmp287_;
			ValaCCodeIdentifier* _tmp288_;
			ValaCCodeBinaryExpression* _tmp289_;
			ValaCCodeBinaryExpression* _tmp290_;
			ValaCCodeFunctionCall* _tmp291_;
			ValaCCodeFunctionCall* _tmp292_;
			gint _tmp293_;
			ValaParameter* _tmp294_;
			ValaDataType* _tmp295_;
			ValaDataType* _tmp296_;
			_p_index = _p_index + 1;
			_tmp252_ = _p_index;
			_tmp253_ = _p_size;
			if (!(_tmp252_ < _tmp253_)) {
				break;
			}
			_tmp254_ = _p_list;
			_tmp255_ = _p_index;
			_tmp256_ = vala_list_get (_tmp254_, _tmp255_);
			p = (ValaParameter*) _tmp256_;
			_tmp257_ = p;
			_tmp258_ = vala_parameter_get_direction (_tmp257_);
			_tmp259_ = _tmp258_;
			if (_tmp259_ != VALA_PARAMETER_DIRECTION_IN) {
				ValaCCodeIdentifier* _tmp260_;
				ValaCCodeIdentifier* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				_tmp260_ = vala_ccode_identifier_new ("g_value_get_pointer");
				_tmp261_ = _tmp260_;
				_tmp262_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp261_);
				_vala_ccode_node_unref0 (inner_fc);
				inner_fc = _tmp262_;
				_vala_ccode_node_unref0 (_tmp261_);
			} else {
				gboolean _tmp263_ = FALSE;
				ValaParameter* _tmp264_;
				ValaDataType* _tmp265_;
				ValaDataType* _tmp266_;
				_tmp264_ = p;
				_tmp265_ = vala_variable_get_variable_type ((ValaVariable*) _tmp264_);
				_tmp266_ = _tmp265_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp266_, VALA_TYPE_VALUE_TYPE)) {
					ValaParameter* _tmp267_;
					ValaDataType* _tmp268_;
					ValaDataType* _tmp269_;
					gboolean _tmp270_;
					gboolean _tmp271_;
					_tmp267_ = p;
					_tmp268_ = vala_variable_get_variable_type ((ValaVariable*) _tmp267_);
					_tmp269_ = _tmp268_;
					_tmp270_ = vala_data_type_get_nullable (_tmp269_);
					_tmp271_ = _tmp270_;
					_tmp263_ = _tmp271_;
				} else {
					_tmp263_ = FALSE;
				}
				if (_tmp263_) {
					ValaCCodeIdentifier* _tmp272_;
					ValaCCodeIdentifier* _tmp273_;
					ValaCCodeFunctionCall* _tmp274_;
					_tmp272_ = vala_ccode_identifier_new ("g_value_get_pointer");
					_tmp273_ = _tmp272_;
					_tmp274_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp273_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp274_;
					_vala_ccode_node_unref0 (_tmp273_);
				} else {
					ValaParameter* _tmp275_;
					ValaDataType* _tmp276_;
					ValaDataType* _tmp277_;
					ValaCCodeIdentifier* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeFunctionCall* _tmp280_;
					_tmp275_ = p;
					_tmp276_ = vala_variable_get_variable_type ((ValaVariable*) _tmp275_);
					_tmp277_ = _tmp276_;
					_tmp278_ = vala_ccode_base_module_get_value_getter_function ((ValaCCodeBaseModule*) self, _tmp277_);
					_tmp279_ = _tmp278_;
					_tmp280_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp279_);
					_vala_ccode_node_unref0 (inner_fc);
					inner_fc = _tmp280_;
					_vala_ccode_node_unref0 (_tmp279_);
				}
			}
			_tmp281_ = inner_fc;
			_tmp282_ = vala_ccode_identifier_new ("param_values");
			_tmp283_ = _tmp282_;
			_tmp284_ = i;
			_tmp285_ = g_strdup_printf ("%i", _tmp284_);
			_tmp286_ = _tmp285_;
			_tmp287_ = vala_ccode_identifier_new (_tmp286_);
			_tmp288_ = _tmp287_;
			_tmp289_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp283_, (ValaCCodeExpression*) _tmp288_);
			_tmp290_ = _tmp289_;
			vala_ccode_function_call_add_argument (_tmp281_, (ValaCCodeExpression*) _tmp290_);
			_vala_ccode_node_unref0 (_tmp290_);
			_vala_ccode_node_unref0 (_tmp288_);
			_g_free0 (_tmp286_);
			_vala_ccode_node_unref0 (_tmp283_);
			_tmp291_ = fc;
			_tmp292_ = inner_fc;
			vala_ccode_function_call_add_argument (_tmp291_, (ValaCCodeExpression*) _tmp292_);
			_tmp293_ = i;
			i = _tmp293_ + 1;
			_tmp294_ = p;
			_tmp295_ = vala_variable_get_variable_type ((ValaVariable*) _tmp294_);
			_tmp296_ = _tmp295_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp296_, VALA_TYPE_ARRAY_TYPE)) {
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp297_ = FALSE;
						_tmp297_ = TRUE;
						while (TRUE) {
							gint _tmp299_;
							ValaParameter* _tmp300_;
							ValaDataType* _tmp301_;
							ValaDataType* _tmp302_;
							gint _tmp303_;
							gint _tmp304_;
							ValaCCodeIdentifier* _tmp305_;
							ValaCCodeIdentifier* _tmp306_;
							ValaCCodeFunctionCall* _tmp307_;
							ValaCCodeFunctionCall* _tmp308_;
							ValaCCodeIdentifier* _tmp309_;
							ValaCCodeIdentifier* _tmp310_;
							gint _tmp311_;
							gchar* _tmp312_;
							gchar* _tmp313_;
							ValaCCodeIdentifier* _tmp314_;
							ValaCCodeIdentifier* _tmp315_;
							ValaCCodeBinaryExpression* _tmp316_;
							ValaCCodeBinaryExpression* _tmp317_;
							ValaCCodeFunctionCall* _tmp318_;
							ValaCCodeFunctionCall* _tmp319_;
							gint _tmp320_;
							if (!_tmp297_) {
								gint _tmp298_;
								_tmp298_ = j;
								j = _tmp298_ + 1;
							}
							_tmp297_ = FALSE;
							_tmp299_ = j;
							_tmp300_ = p;
							_tmp301_ = vala_variable_get_variable_type ((ValaVariable*) _tmp300_);
							_tmp302_ = _tmp301_;
							_tmp303_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp302_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp304_ = _tmp303_;
							if (!(_tmp299_ < _tmp304_)) {
								break;
							}
							_tmp305_ = vala_ccode_identifier_new ("g_value_get_int");
							_tmp306_ = _tmp305_;
							_tmp307_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp306_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp307_;
							_vala_ccode_node_unref0 (_tmp306_);
							_tmp308_ = inner_fc;
							_tmp309_ = vala_ccode_identifier_new ("param_values");
							_tmp310_ = _tmp309_;
							_tmp311_ = i;
							_tmp312_ = g_strdup_printf ("%i", _tmp311_);
							_tmp313_ = _tmp312_;
							_tmp314_ = vala_ccode_identifier_new (_tmp313_);
							_tmp315_ = _tmp314_;
							_tmp316_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp310_, (ValaCCodeExpression*) _tmp315_);
							_tmp317_ = _tmp316_;
							vala_ccode_function_call_add_argument (_tmp308_, (ValaCCodeExpression*) _tmp317_);
							_vala_ccode_node_unref0 (_tmp317_);
							_vala_ccode_node_unref0 (_tmp315_);
							_g_free0 (_tmp313_);
							_vala_ccode_node_unref0 (_tmp310_);
							_tmp318_ = fc;
							_tmp319_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp318_, (ValaCCodeExpression*) _tmp319_);
							_tmp320_ = i;
							i = _tmp320_ + 1;
						}
					}
				}
			} else {
				ValaParameter* _tmp321_;
				ValaDataType* _tmp322_;
				ValaDataType* _tmp323_;
				_tmp321_ = p;
				_tmp322_ = vala_variable_get_variable_type ((ValaVariable*) _tmp321_);
				_tmp323_ = _tmp322_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp323_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaDelegateType* _tmp327_;
					ValaDelegate* _tmp328_;
					ValaDelegate* _tmp329_;
					gboolean _tmp330_;
					gboolean _tmp331_;
					_tmp324_ = p;
					_tmp325_ = vala_variable_get_variable_type ((ValaVariable*) _tmp324_);
					_tmp326_ = _tmp325_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp327_ = delegate_type;
					_tmp328_ = vala_delegate_type_get_delegate_symbol (_tmp327_);
					_tmp329_ = _tmp328_;
					_tmp330_ = vala_delegate_get_has_target (_tmp329_);
					_tmp331_ = _tmp330_;
					if (_tmp331_) {
						ValaCCodeIdentifier* _tmp332_;
						ValaCCodeIdentifier* _tmp333_;
						ValaCCodeFunctionCall* _tmp334_;
						ValaCCodeFunctionCall* _tmp335_;
						ValaCCodeIdentifier* _tmp336_;
						ValaCCodeIdentifier* _tmp337_;
						gint _tmp338_;
						gchar* _tmp339_;
						gchar* _tmp340_;
						ValaCCodeIdentifier* _tmp341_;
						ValaCCodeIdentifier* _tmp342_;
						ValaCCodeBinaryExpression* _tmp343_;
						ValaCCodeBinaryExpression* _tmp344_;
						ValaCCodeFunctionCall* _tmp345_;
						ValaCCodeFunctionCall* _tmp346_;
						gint _tmp347_;
						ValaDelegateType* _tmp348_;
						_tmp332_ = vala_ccode_identifier_new ("g_value_get_pointer");
						_tmp333_ = _tmp332_;
						_tmp334_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp333_);
						_vala_ccode_node_unref0 (inner_fc);
						inner_fc = _tmp334_;
						_vala_ccode_node_unref0 (_tmp333_);
						_tmp335_ = inner_fc;
						_tmp336_ = vala_ccode_identifier_new ("param_values");
						_tmp337_ = _tmp336_;
						_tmp338_ = i;
						_tmp339_ = g_strdup_printf ("%i", _tmp338_);
						_tmp340_ = _tmp339_;
						_tmp341_ = vala_ccode_identifier_new (_tmp340_);
						_tmp342_ = _tmp341_;
						_tmp343_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp337_, (ValaCCodeExpression*) _tmp342_);
						_tmp344_ = _tmp343_;
						vala_ccode_function_call_add_argument (_tmp335_, (ValaCCodeExpression*) _tmp344_);
						_vala_ccode_node_unref0 (_tmp344_);
						_vala_ccode_node_unref0 (_tmp342_);
						_g_free0 (_tmp340_);
						_vala_ccode_node_unref0 (_tmp337_);
						_tmp345_ = fc;
						_tmp346_ = inner_fc;
						vala_ccode_function_call_add_argument (_tmp345_, (ValaCCodeExpression*) _tmp346_);
						_tmp347_ = i;
						i = _tmp347_ + 1;
						_tmp348_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp348_)) {
							ValaCCodeIdentifier* _tmp349_;
							ValaCCodeIdentifier* _tmp350_;
							ValaCCodeFunctionCall* _tmp351_;
							ValaCCodeFunctionCall* _tmp352_;
							ValaCCodeIdentifier* _tmp353_;
							ValaCCodeIdentifier* _tmp354_;
							gint _tmp355_;
							gchar* _tmp356_;
							gchar* _tmp357_;
							ValaCCodeIdentifier* _tmp358_;
							ValaCCodeIdentifier* _tmp359_;
							ValaCCodeBinaryExpression* _tmp360_;
							ValaCCodeBinaryExpression* _tmp361_;
							ValaCCodeFunctionCall* _tmp362_;
							ValaCCodeFunctionCall* _tmp363_;
							gint _tmp364_;
							_tmp349_ = vala_ccode_identifier_new ("g_value_get_pointer");
							_tmp350_ = _tmp349_;
							_tmp351_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp350_);
							_vala_ccode_node_unref0 (inner_fc);
							inner_fc = _tmp351_;
							_vala_ccode_node_unref0 (_tmp350_);
							_tmp352_ = inner_fc;
							_tmp353_ = vala_ccode_identifier_new ("param_values");
							_tmp354_ = _tmp353_;
							_tmp355_ = i;
							_tmp356_ = g_strdup_printf ("%i", _tmp355_);
							_tmp357_ = _tmp356_;
							_tmp358_ = vala_ccode_identifier_new (_tmp357_);
							_tmp359_ = _tmp358_;
							_tmp360_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp354_, (ValaCCodeExpression*) _tmp359_);
							_tmp361_ = _tmp360_;
							vala_ccode_function_call_add_argument (_tmp352_, (ValaCCodeExpression*) _tmp361_);
							_vala_ccode_node_unref0 (_tmp361_);
							_vala_ccode_node_unref0 (_tmp359_);
							_g_free0 (_tmp357_);
							_vala_ccode_node_unref0 (_tmp354_);
							_tmp362_ = fc;
							_tmp363_ = inner_fc;
							vala_ccode_function_call_add_argument (_tmp362_, (ValaCCodeExpression*) _tmp363_);
							_tmp364_ = i;
							i = _tmp364_ + 1;
						}
					}
				}
			}
			_vala_ccode_node_unref0 (inner_fc);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	_tmp365_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp366_ = _tmp365_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp366_)) {
		ValaCCodeFunctionCall* inner_fc = NULL;
		ValaCCodeIdentifier* _tmp367_;
		ValaCCodeIdentifier* _tmp368_;
		ValaCCodeFunctionCall* _tmp369_;
		ValaCCodeFunctionCall* _tmp370_;
		ValaCCodeFunctionCall* _tmp371_;
		ValaCCodeIdentifier* _tmp372_;
		ValaCCodeIdentifier* _tmp373_;
		gint _tmp374_;
		gchar* _tmp375_;
		gchar* _tmp376_;
		ValaCCodeIdentifier* _tmp377_;
		ValaCCodeIdentifier* _tmp378_;
		ValaCCodeBinaryExpression* _tmp379_;
		ValaCCodeBinaryExpression* _tmp380_;
		ValaCCodeFunctionCall* _tmp381_;
		ValaCCodeFunctionCall* _tmp382_;
		gint _tmp383_;
		_tmp367_ = vala_ccode_identifier_new ("g_value_get_pointer");
		_tmp368_ = _tmp367_;
		_tmp369_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp368_);
		_tmp370_ = _tmp369_;
		_vala_ccode_node_unref0 (_tmp368_);
		inner_fc = _tmp370_;
		_tmp371_ = inner_fc;
		_tmp372_ = vala_ccode_identifier_new ("param_values");
		_tmp373_ = _tmp372_;
		_tmp374_ = i;
		_tmp375_ = g_strdup_printf ("%i", _tmp374_);
		_tmp376_ = _tmp375_;
		_tmp377_ = vala_ccode_identifier_new (_tmp376_);
		_tmp378_ = _tmp377_;
		_tmp379_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, (ValaCCodeExpression*) _tmp373_, (ValaCCodeExpression*) _tmp378_);
		_tmp380_ = _tmp379_;
		vala_ccode_function_call_add_argument (_tmp371_, (ValaCCodeExpression*) _tmp380_);
		_vala_ccode_node_unref0 (_tmp380_);
		_vala_ccode_node_unref0 (_tmp378_);
		_g_free0 (_tmp376_);
		_vala_ccode_node_unref0 (_tmp373_);
		_tmp381_ = fc;
		_tmp382_ = inner_fc;
		vala_ccode_function_call_add_argument (_tmp381_, (ValaCCodeExpression*) _tmp382_);
		_tmp383_ = i;
		i = _tmp383_ + 1;
		_vala_ccode_node_unref0 (inner_fc);
	}
	_tmp384_ = fc;
	_tmp385_ = vala_ccode_identifier_new ("data2");
	_tmp386_ = _tmp385_;
	vala_ccode_function_call_add_argument (_tmp384_, (ValaCCodeExpression*) _tmp386_);
	_vala_ccode_node_unref0 (_tmp386_);
	_tmp388_ = vala_data_type_get_data_type (return_type);
	_tmp389_ = _tmp388_;
	if (_tmp389_ != NULL) {
		_tmp387_ = TRUE;
	} else {
		_tmp387_ = vala_data_type_is_array (return_type);
	}
	if (_tmp387_) {
		ValaCCodeFunction* _tmp390_;
		ValaCCodeFunction* _tmp391_;
		ValaCCodeIdentifier* _tmp392_;
		ValaCCodeIdentifier* _tmp393_;
		ValaCCodeFunctionCall* _tmp394_;
		ValaCCodeFunctionCall* set_fc = NULL;
		ValaCCodeFunctionCall* _tmp406_;
		ValaCCodeIdentifier* _tmp407_;
		ValaCCodeIdentifier* _tmp408_;
		ValaCCodeFunctionCall* _tmp409_;
		ValaCCodeIdentifier* _tmp410_;
		ValaCCodeIdentifier* _tmp411_;
		ValaCCodeFunction* _tmp412_;
		ValaCCodeFunction* _tmp413_;
		ValaCCodeFunctionCall* _tmp414_;
		_tmp390_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp391_ = _tmp390_;
		_tmp392_ = vala_ccode_identifier_new ("v_return");
		_tmp393_ = _tmp392_;
		_tmp394_ = fc;
		vala_ccode_function_add_assignment (_tmp391_, (ValaCCodeExpression*) _tmp393_, (ValaCCodeExpression*) _tmp394_);
		_vala_ccode_node_unref0 (_tmp393_);
		if (G_TYPE_CHECK_INSTANCE_TYPE (return_type, VALA_TYPE_VALUE_TYPE)) {
			gboolean _tmp395_;
			gboolean _tmp396_;
			_tmp395_ = vala_data_type_get_nullable (return_type);
			_tmp396_ = _tmp395_;
			if (_tmp396_) {
				ValaCCodeIdentifier* _tmp397_;
				ValaCCodeIdentifier* _tmp398_;
				ValaCCodeFunctionCall* _tmp399_;
				_tmp397_ = vala_ccode_identifier_new ("g_value_set_pointer");
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp398_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp399_;
				_vala_ccode_node_unref0 (_tmp398_);
			} else {
				ValaCCodeIdentifier* _tmp400_;
				ValaCCodeIdentifier* _tmp401_;
				ValaCCodeFunctionCall* _tmp402_;
				_tmp400_ = vala_ccode_base_module_get_value_setter_function ((ValaCCodeBaseModule*) self, return_type);
				_tmp401_ = _tmp400_;
				_tmp402_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp401_);
				_vala_ccode_node_unref0 (set_fc);
				set_fc = _tmp402_;
				_vala_ccode_node_unref0 (_tmp401_);
			}
		} else {
			ValaCCodeIdentifier* _tmp403_;
			ValaCCodeIdentifier* _tmp404_;
			ValaCCodeFunctionCall* _tmp405_;
			_tmp403_ = vala_ccode_base_module_get_value_taker_function ((ValaCCodeBaseModule*) self, return_type);
			_tmp404_ = _tmp403_;
			_tmp405_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp404_);
			_vala_ccode_node_unref0 (set_fc);
			set_fc = _tmp405_;
			_vala_ccode_node_unref0 (_tmp404_);
		}
		_tmp406_ = set_fc;
		_tmp407_ = vala_ccode_identifier_new ("return_value");
		_tmp408_ = _tmp407_;
		vala_ccode_function_call_add_argument (_tmp406_, (ValaCCodeExpression*) _tmp408_);
		_vala_ccode_node_unref0 (_tmp408_);
		_tmp409_ = set_fc;
		_tmp410_ = vala_ccode_identifier_new ("v_return");
		_tmp411_ = _tmp410_;
		vala_ccode_function_call_add_argument (_tmp409_, (ValaCCodeExpression*) _tmp411_);
		_vala_ccode_node_unref0 (_tmp411_);
		_tmp412_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp413_ = _tmp412_;
		_tmp414_ = set_fc;
		vala_ccode_function_add_expression (_tmp413_, (ValaCCodeExpression*) _tmp414_);
		_vala_ccode_node_unref0 (set_fc);
	} else {
		ValaCCodeFunction* _tmp415_;
		ValaCCodeFunction* _tmp416_;
		ValaCCodeFunctionCall* _tmp417_;
		_tmp415_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp416_ = _tmp415_;
		_tmp417_ = fc;
		vala_ccode_function_add_expression (_tmp416_, (ValaCCodeExpression*) _tmp417_);
	}
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp418_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp419_ = signal_marshaller;
	vala_ccode_file_add_function_declaration (_tmp418_, _tmp419_);
	_tmp420_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp421_ = signal_marshaller;
	vala_ccode_file_add_function (_tmp420_, _tmp421_);
	_tmp422_ = ((ValaCCodeBaseModule*) self)->user_marshal_set;
	_tmp423_ = signature;
	vala_collection_add ((ValaCollection*) _tmp422_, _tmp423_);
	_vala_ccode_node_unref0 (c_assign_rhs);
	_vala_ccode_node_unref0 (cond);
	_vala_ccode_node_unref0 (param);
	_vala_ccode_node_unref0 (data);
	_vala_ccode_node_unref0 (fc);
	_vala_ccode_node_unref0 (callback_decl);
	_vala_ccode_node_unref0 (signal_marshaller);
	_g_free0 (signature);
}


static void
_vala_array_add1 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add2 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add3 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add4 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add5 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add6 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add7 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void
_vala_array_add8 (gchar** * array,
                  int* length,
                  int* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static ValaCCodeExpression*
vala_gsignal_module_real_get_signal_creation (ValaCCodeBaseModule* base,
                                              ValaSignal* sig,
                                              ValaTypeSymbol* type)
{
	ValaGSignalModule * self;
	ValaCCodeExpression* result = NULL;
	ValaCCodeFunctionCall* csignew = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeFunctionCall* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	ValaCCodeIdentifier* _tmp14_;
	ValaCCodeIdentifier* _tmp15_;
	gchar** flags = NULL;
	gchar** _tmp16_;
	gint flags_length1;
	gint _flags_size_;
	gchar* run_type = NULL;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	ValaVersionAttribute* _tmp34_;
	ValaVersionAttribute* _tmp35_;
	gboolean _tmp36_;
	gboolean _tmp37_;
	ValaCCodeFunctionCall* _tmp40_;
	gchar** _tmp41_;
	gint _tmp41__length1;
	gchar* _tmp42_;
	gchar* _tmp43_;
	ValaCCodeConstant* _tmp44_;
	ValaCCodeConstant* _tmp45_;
	ValaMethod* _tmp46_;
	ValaMethod* _tmp47_;
	ValaCCodeFunctionCall* _tmp76_;
	ValaCCodeConstant* _tmp77_;
	ValaCCodeConstant* _tmp78_;
	ValaCCodeFunctionCall* _tmp79_;
	ValaCCodeConstant* _tmp80_;
	ValaCCodeConstant* _tmp81_;
	ValaList* params = NULL;
	ValaList* _tmp82_;
	gchar* marshaller = NULL;
	ValaDataType* _tmp83_;
	ValaDataType* _tmp84_;
	ValaCCodeIdentifier* marshal_arg = NULL;
	const gchar* _tmp93_;
	ValaCCodeIdentifier* _tmp94_;
	ValaCCodeFunctionCall* _tmp95_;
	ValaCCodeIdentifier* _tmp96_;
	gboolean _tmp97_ = FALSE;
	ValaDataType* _tmp98_;
	ValaDataType* _tmp99_;
	gint params_len = 0;
	ValaDataType* _tmp175_;
	ValaDataType* _tmp176_;
	ValaCCodeFunctionCall* _tmp178_;
	gint _tmp179_;
	gchar* _tmp180_;
	gchar* _tmp181_;
	ValaCCodeConstant* _tmp182_;
	ValaCCodeConstant* _tmp183_;
	ValaDataType* _tmp287_;
	ValaDataType* _tmp288_;
	ValaCCodeIdentifier* _tmp292_;
	const gchar* _tmp293_;
	ValaCCodeExpression* _tmp294_;
	ValaCCodeExpression* _tmp295_;
	ValaCCodeFunctionCall* _tmp296_;
	ValaCCodeAssignment* _tmp297_;
	ValaCCodeExpression* _tmp298_;
	self = (ValaGSignalModule*) base;
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_signal_new");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	csignew = _tmp3_;
	_tmp4_ = csignew;
	_tmp5_ = vala_get_ccode_name ((ValaCodeNode*) sig);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("\"%s\"", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = vala_ccode_constant_new (_tmp8_);
	_tmp10_ = _tmp9_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp10_);
	_vala_ccode_node_unref0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp11_ = csignew;
	_tmp12_ = vala_get_ccode_type_id ((ValaCodeNode*) type);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_ccode_identifier_new (_tmp13_);
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp11_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_g_free0 (_tmp13_);
	_tmp16_ = g_new0 (gchar*, 0 + 1);
	flags = _tmp16_;
	flags_length1 = 0;
	_flags_size_ = flags_length1;
	_tmp17_ = vala_code_node_get_attribute_string ((ValaCodeNode*) sig, "Signal", "run", NULL);
	run_type = _tmp17_;
	_tmp18_ = run_type;
	if (g_strcmp0 (_tmp18_, "first") == 0) {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar* _tmp20_;
		_tmp19_ = flags;
		_tmp19__length1 = flags_length1;
		_tmp20_ = g_strdup ("G_SIGNAL_RUN_FIRST");
		_vala_array_add1 (&flags, &flags_length1, &_flags_size_, _tmp20_);
	} else {
		const gchar* _tmp21_;
		_tmp21_ = run_type;
		if (g_strcmp0 (_tmp21_, "cleanup") == 0) {
			gchar** _tmp22_;
			gint _tmp22__length1;
			gchar* _tmp23_;
			_tmp22_ = flags;
			_tmp22__length1 = flags_length1;
			_tmp23_ = g_strdup ("G_SIGNAL_RUN_CLEANUP");
			_vala_array_add2 (&flags, &flags_length1, &_flags_size_, _tmp23_);
		} else {
			gchar** _tmp24_;
			gint _tmp24__length1;
			gchar* _tmp25_;
			_tmp24_ = flags;
			_tmp24__length1 = flags_length1;
			_tmp25_ = g_strdup ("G_SIGNAL_RUN_LAST");
			_vala_array_add3 (&flags, &flags_length1, &_flags_size_, _tmp25_);
		}
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "detailed", FALSE)) {
		gchar** _tmp26_;
		gint _tmp26__length1;
		gchar* _tmp27_;
		_tmp26_ = flags;
		_tmp26__length1 = flags_length1;
		_tmp27_ = g_strdup ("G_SIGNAL_DETAILED");
		_vala_array_add4 (&flags, &flags_length1, &_flags_size_, _tmp27_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_recurse", FALSE)) {
		gchar** _tmp28_;
		gint _tmp28__length1;
		gchar* _tmp29_;
		_tmp28_ = flags;
		_tmp28__length1 = flags_length1;
		_tmp29_ = g_strdup ("G_SIGNAL_NO_RECURSE");
		_vala_array_add5 (&flags, &flags_length1, &_flags_size_, _tmp29_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "action", FALSE)) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		gchar* _tmp31_;
		_tmp30_ = flags;
		_tmp30__length1 = flags_length1;
		_tmp31_ = g_strdup ("G_SIGNAL_ACTION");
		_vala_array_add6 (&flags, &flags_length1, &_flags_size_, _tmp31_);
	}
	if (vala_code_node_get_attribute_bool ((ValaCodeNode*) sig, "Signal", "no_hooks", FALSE)) {
		gchar** _tmp32_;
		gint _tmp32__length1;
		gchar* _tmp33_;
		_tmp32_ = flags;
		_tmp32__length1 = flags_length1;
		_tmp33_ = g_strdup ("G_SIGNAL_NO_HOOKS");
		_vala_array_add7 (&flags, &flags_length1, &_flags_size_, _tmp33_);
	}
	_tmp34_ = vala_symbol_get_version ((ValaSymbol*) sig);
	_tmp35_ = _tmp34_;
	_tmp36_ = vala_version_attribute_get_deprecated (_tmp35_);
	_tmp37_ = _tmp36_;
	if (_tmp37_) {
		gchar** _tmp38_;
		gint _tmp38__length1;
		gchar* _tmp39_;
		_tmp38_ = flags;
		_tmp38__length1 = flags_length1;
		_tmp39_ = g_strdup ("G_SIGNAL_DEPRECATED");
		_vala_array_add8 (&flags, &flags_length1, &_flags_size_, _tmp39_);
	}
	_tmp40_ = csignew;
	_tmp41_ = flags;
	_tmp41__length1 = flags_length1;
	_tmp42_ = _vala_g_strjoinv (" | ", _tmp41_, _tmp41__length1);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_constant_new (_tmp43_);
	_tmp45_ = _tmp44_;
	vala_ccode_function_call_add_argument (_tmp40_, (ValaCCodeExpression*) _tmp45_);
	_vala_ccode_node_unref0 (_tmp45_);
	_g_free0 (_tmp43_);
	_tmp46_ = vala_signal_get_default_handler (sig);
	_tmp47_ = _tmp46_;
	if (_tmp47_ == NULL) {
		ValaCCodeFunctionCall* _tmp48_;
		ValaCCodeConstant* _tmp49_;
		ValaCCodeConstant* _tmp50_;
		_tmp48_ = csignew;
		_tmp49_ = vala_ccode_constant_new ("0");
		_tmp50_ = _tmp49_;
		vala_ccode_function_call_add_argument (_tmp48_, (ValaCCodeExpression*) _tmp50_);
		_vala_ccode_node_unref0 (_tmp50_);
	} else {
		ValaCCodeFunctionCall* struct_offset = NULL;
		ValaCCodeIdentifier* _tmp51_;
		ValaCCodeIdentifier* _tmp52_;
		ValaCCodeFunctionCall* _tmp53_;
		ValaCCodeFunctionCall* _tmp54_;
		ValaCCodeFunctionCall* _tmp67_;
		ValaMethod* _tmp68_;
		ValaMethod* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		ValaCCodeIdentifier* _tmp72_;
		ValaCCodeIdentifier* _tmp73_;
		ValaCCodeFunctionCall* _tmp74_;
		ValaCCodeFunctionCall* _tmp75_;
		_tmp51_ = vala_ccode_identifier_new ("G_STRUCT_OFFSET");
		_tmp52_ = _tmp51_;
		_tmp53_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp52_);
		_tmp54_ = _tmp53_;
		_vala_ccode_node_unref0 (_tmp52_);
		struct_offset = _tmp54_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (type, VALA_TYPE_CLASS)) {
			ValaCCodeFunctionCall* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			ValaCCodeIdentifier* _tmp60_;
			ValaCCodeIdentifier* _tmp61_;
			_tmp55_ = struct_offset;
			_tmp56_ = vala_get_ccode_name ((ValaCodeNode*) type);
			_tmp57_ = _tmp56_;
			_tmp58_ = g_strdup_printf ("%sClass", _tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_ccode_identifier_new (_tmp59_);
			_tmp61_ = _tmp60_;
			vala_ccode_function_call_add_argument (_tmp55_, (ValaCCodeExpression*) _tmp61_);
			_vala_ccode_node_unref0 (_tmp61_);
			_g_free0 (_tmp59_);
			_g_free0 (_tmp57_);
		} else {
			ValaCCodeFunctionCall* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			_tmp62_ = struct_offset;
			_tmp63_ = vala_get_ccode_type_name (G_TYPE_CHECK_INSTANCE_CAST (type, VALA_TYPE_INTERFACE, ValaInterface));
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_ccode_identifier_new (_tmp64_);
			_tmp66_ = _tmp65_;
			vala_ccode_function_call_add_argument (_tmp62_, (ValaCCodeExpression*) _tmp66_);
			_vala_ccode_node_unref0 (_tmp66_);
			_g_free0 (_tmp64_);
		}
		_tmp67_ = struct_offset;
		_tmp68_ = vala_signal_get_default_handler (sig);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_get_ccode_vfunc_name (_tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = vala_ccode_identifier_new (_tmp71_);
		_tmp73_ = _tmp72_;
		vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp73_);
		_vala_ccode_node_unref0 (_tmp73_);
		_g_free0 (_tmp71_);
		_tmp74_ = csignew;
		_tmp75_ = struct_offset;
		vala_ccode_function_call_add_argument (_tmp74_, (ValaCCodeExpression*) _tmp75_);
		_vala_ccode_node_unref0 (struct_offset);
	}
	_tmp76_ = csignew;
	_tmp77_ = vala_ccode_constant_new ("NULL");
	_tmp78_ = _tmp77_;
	vala_ccode_function_call_add_argument (_tmp76_, (ValaCCodeExpression*) _tmp78_);
	_vala_ccode_node_unref0 (_tmp78_);
	_tmp79_ = csignew;
	_tmp80_ = vala_ccode_constant_new ("NULL");
	_tmp81_ = _tmp80_;
	vala_ccode_function_call_add_argument (_tmp79_, (ValaCCodeExpression*) _tmp81_);
	_vala_ccode_node_unref0 (_tmp81_);
	_tmp82_ = vala_callable_get_parameters ((ValaCallable*) sig);
	params = _tmp82_;
	_tmp83_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp84_ = _tmp83_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp84_)) {
		ValaList* _tmp85_;
		ValaVoidType* _tmp86_;
		ValaVoidType* _tmp87_;
		gchar* _tmp88_;
		_tmp85_ = params;
		_tmp86_ = vala_void_type_new (NULL);
		_tmp87_ = _tmp86_;
		_tmp88_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp85_, (ValaDataType*) _tmp87_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp88_;
		_vala_code_node_unref0 (_tmp87_);
	} else {
		ValaList* _tmp89_;
		ValaDataType* _tmp90_;
		ValaDataType* _tmp91_;
		gchar* _tmp92_;
		_tmp89_ = params;
		_tmp90_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp91_ = _tmp90_;
		_tmp92_ = vala_gsignal_module_get_marshaller_function (self, sig, _tmp89_, _tmp91_, NULL);
		_g_free0 (marshaller);
		marshaller = _tmp92_;
	}
	_tmp93_ = marshaller;
	_tmp94_ = vala_ccode_identifier_new (_tmp93_);
	marshal_arg = _tmp94_;
	_tmp95_ = csignew;
	_tmp96_ = marshal_arg;
	vala_ccode_function_call_add_argument (_tmp95_, (ValaCCodeExpression*) _tmp96_);
	_tmp98_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp99_ = _tmp98_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_POINTER_TYPE)) {
		_tmp97_ = TRUE;
	} else {
		ValaDataType* _tmp100_;
		ValaDataType* _tmp101_;
		_tmp100_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp101_ = _tmp100_;
		_tmp97_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_GENERIC_TYPE);
	}
	if (_tmp97_) {
		ValaCCodeFunctionCall* _tmp102_;
		ValaCCodeConstant* _tmp103_;
		ValaCCodeConstant* _tmp104_;
		_tmp102_ = csignew;
		_tmp103_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp104_ = _tmp103_;
		vala_ccode_function_call_add_argument (_tmp102_, (ValaCCodeExpression*) _tmp104_);
		_vala_ccode_node_unref0 (_tmp104_);
	} else {
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		_tmp105_ = vala_callable_get_return_type ((ValaCallable*) sig);
		_tmp106_ = _tmp105_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp106_, VALA_TYPE_ERROR_TYPE)) {
			ValaCCodeFunctionCall* _tmp107_;
			ValaCCodeConstant* _tmp108_;
			ValaCCodeConstant* _tmp109_;
			_tmp107_ = csignew;
			_tmp108_ = vala_ccode_constant_new ("G_TYPE_POINTER");
			_tmp109_ = _tmp108_;
			vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp109_);
			_vala_ccode_node_unref0 (_tmp109_);
		} else {
			gboolean _tmp110_ = FALSE;
			ValaDataType* _tmp111_;
			ValaDataType* _tmp112_;
			_tmp111_ = vala_callable_get_return_type ((ValaCallable*) sig);
			_tmp112_ = _tmp111_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp112_, VALA_TYPE_VALUE_TYPE)) {
				ValaDataType* _tmp113_;
				ValaDataType* _tmp114_;
				gboolean _tmp115_;
				gboolean _tmp116_;
				_tmp113_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp114_ = _tmp113_;
				_tmp115_ = vala_data_type_get_nullable (_tmp114_);
				_tmp116_ = _tmp115_;
				_tmp110_ = _tmp116_;
			} else {
				_tmp110_ = FALSE;
			}
			if (_tmp110_) {
				ValaCCodeFunctionCall* _tmp117_;
				ValaCCodeConstant* _tmp118_;
				ValaCCodeConstant* _tmp119_;
				_tmp117_ = csignew;
				_tmp118_ = vala_ccode_constant_new ("G_TYPE_POINTER");
				_tmp119_ = _tmp118_;
				vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp119_);
				_vala_ccode_node_unref0 (_tmp119_);
			} else {
				ValaDataType* _tmp120_;
				ValaDataType* _tmp121_;
				ValaTypeSymbol* _tmp122_;
				ValaTypeSymbol* _tmp123_;
				_tmp120_ = vala_callable_get_return_type ((ValaCallable*) sig);
				_tmp121_ = _tmp120_;
				_tmp122_ = vala_data_type_get_data_type (_tmp121_);
				_tmp123_ = _tmp122_;
				if (_tmp123_ == NULL) {
					ValaCCodeFunctionCall* _tmp124_;
					ValaCCodeConstant* _tmp125_;
					ValaCCodeConstant* _tmp126_;
					_tmp124_ = csignew;
					_tmp125_ = vala_ccode_constant_new ("G_TYPE_NONE");
					_tmp126_ = _tmp125_;
					vala_ccode_function_call_add_argument (_tmp124_, (ValaCCodeExpression*) _tmp126_);
					_vala_ccode_node_unref0 (_tmp126_);
				} else {
					ValaDataType* _tmp127_;
					ValaDataType* _tmp128_;
					_tmp127_ = vala_callable_get_return_type ((ValaCallable*) sig);
					_tmp128_ = _tmp127_;
					if (vala_data_type_is_real_non_null_struct_type (_tmp128_)) {
						ValaCCodeFunctionCall* _tmp129_;
						ValaCCodeConstant* _tmp130_;
						ValaCCodeConstant* _tmp131_;
						_tmp129_ = csignew;
						_tmp130_ = vala_ccode_constant_new ("G_TYPE_NONE");
						_tmp131_ = _tmp130_;
						vala_ccode_function_call_add_argument (_tmp129_, (ValaCCodeExpression*) _tmp131_);
						_vala_ccode_node_unref0 (_tmp131_);
					} else {
						ValaCCodeFunctionCall* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaTypeSymbol* _tmp135_;
						ValaTypeSymbol* _tmp136_;
						gchar* _tmp137_;
						gchar* _tmp138_;
						ValaCCodeConstant* _tmp139_;
						ValaCCodeConstant* _tmp140_;
						_tmp132_ = csignew;
						_tmp133_ = vala_callable_get_return_type ((ValaCallable*) sig);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_get_data_type (_tmp134_);
						_tmp136_ = _tmp135_;
						_tmp137_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp136_);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_ccode_constant_new (_tmp138_);
						_tmp140_ = _tmp139_;
						vala_ccode_function_call_add_argument (_tmp132_, (ValaCCodeExpression*) _tmp140_);
						_vala_ccode_node_unref0 (_tmp140_);
						_g_free0 (_tmp138_);
					}
				}
			}
		}
	}
	params_len = 0;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp141_;
		ValaList* _tmp142_;
		gint _param_size = 0;
		ValaList* _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gint _param_index = 0;
		_tmp141_ = params;
		_tmp142_ = _vala_iterable_ref0 (_tmp141_);
		_param_list = _tmp142_;
		_tmp143_ = _param_list;
		_tmp144_ = vala_collection_get_size ((ValaCollection*) _tmp143_);
		_tmp145_ = _tmp144_;
		_param_size = _tmp145_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp146_;
			gint _tmp147_;
			ValaParameter* param = NULL;
			ValaList* _tmp148_;
			gint _tmp149_;
			gpointer _tmp150_;
			gint _tmp151_;
			ValaParameter* _tmp152_;
			ValaDataType* _tmp153_;
			ValaDataType* _tmp154_;
			_param_index = _param_index + 1;
			_tmp146_ = _param_index;
			_tmp147_ = _param_size;
			if (!(_tmp146_ < _tmp147_)) {
				break;
			}
			_tmp148_ = _param_list;
			_tmp149_ = _param_index;
			_tmp150_ = vala_list_get (_tmp148_, _tmp149_);
			param = (ValaParameter*) _tmp150_;
			_tmp151_ = params_len;
			params_len = _tmp151_ + 1;
			_tmp152_ = param;
			_tmp153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp152_);
			_tmp154_ = _tmp153_;
			if (vala_data_type_is_array (_tmp154_)) {
				gint _tmp155_;
				ValaParameter* _tmp156_;
				ValaDataType* _tmp157_;
				ValaDataType* _tmp158_;
				gint _tmp159_;
				gint _tmp160_;
				_tmp155_ = params_len;
				_tmp156_ = param;
				_tmp157_ = vala_variable_get_variable_type ((ValaVariable*) _tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp158_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp160_ = _tmp159_;
				params_len = _tmp155_ + _tmp160_;
			} else {
				ValaParameter* _tmp161_;
				ValaDataType* _tmp162_;
				ValaDataType* _tmp163_;
				_tmp161_ = param;
				_tmp162_ = vala_variable_get_variable_type ((ValaVariable*) _tmp161_);
				_tmp163_ = _tmp162_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp163_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp164_;
					ValaDataType* _tmp165_;
					ValaDataType* _tmp166_;
					ValaDelegateType* _tmp167_;
					ValaDelegate* _tmp168_;
					ValaDelegate* _tmp169_;
					gboolean _tmp170_;
					gboolean _tmp171_;
					_tmp164_ = param;
					_tmp165_ = vala_variable_get_variable_type ((ValaVariable*) _tmp164_);
					_tmp166_ = _tmp165_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp166_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp167_ = delegate_type;
					_tmp168_ = vala_delegate_type_get_delegate_symbol (_tmp167_);
					_tmp169_ = _tmp168_;
					_tmp170_ = vala_delegate_get_has_target (_tmp169_);
					_tmp171_ = _tmp170_;
					if (_tmp171_) {
						gint _tmp172_;
						ValaDelegateType* _tmp173_;
						_tmp172_ = params_len;
						params_len = _tmp172_ + 1;
						_tmp173_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp173_)) {
							gint _tmp174_;
							_tmp174_ = params_len;
							params_len = _tmp174_ + 1;
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp175_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp176_ = _tmp175_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp176_)) {
		gint _tmp177_;
		_tmp177_ = params_len;
		params_len = _tmp177_ + 1;
	}
	_tmp178_ = csignew;
	_tmp179_ = params_len;
	_tmp180_ = g_strdup_printf ("%d", _tmp179_);
	_tmp181_ = _tmp180_;
	_tmp182_ = vala_ccode_constant_new (_tmp181_);
	_tmp183_ = _tmp182_;
	vala_ccode_function_call_add_argument (_tmp178_, (ValaCCodeExpression*) _tmp183_);
	_vala_ccode_node_unref0 (_tmp183_);
	_g_free0 (_tmp181_);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp184_;
		ValaList* _tmp185_;
		gint _param_size = 0;
		ValaList* _tmp186_;
		gint _tmp187_;
		gint _tmp188_;
		gint _param_index = 0;
		_tmp184_ = params;
		_tmp185_ = _vala_iterable_ref0 (_tmp184_);
		_param_list = _tmp185_;
		_tmp186_ = _param_list;
		_tmp187_ = vala_collection_get_size ((ValaCollection*) _tmp186_);
		_tmp188_ = _tmp187_;
		_param_size = _tmp188_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp189_;
			gint _tmp190_;
			ValaParameter* param = NULL;
			ValaList* _tmp191_;
			gint _tmp192_;
			gpointer _tmp193_;
			ValaParameter* _tmp194_;
			ValaDataType* _tmp195_;
			ValaDataType* _tmp196_;
			_param_index = _param_index + 1;
			_tmp189_ = _param_index;
			_tmp190_ = _param_size;
			if (!(_tmp189_ < _tmp190_)) {
				break;
			}
			_tmp191_ = _param_list;
			_tmp192_ = _param_index;
			_tmp193_ = vala_list_get (_tmp191_, _tmp192_);
			param = (ValaParameter*) _tmp193_;
			_tmp194_ = param;
			_tmp195_ = vala_variable_get_variable_type ((ValaVariable*) _tmp194_);
			_tmp196_ = _tmp195_;
			if (vala_data_type_is_array (_tmp196_)) {
				ValaParameter* _tmp197_;
				ValaDataType* _tmp198_;
				ValaDataType* _tmp199_;
				ValaDataType* _tmp200_;
				ValaDataType* _tmp201_;
				ValaTypeSymbol* _tmp202_;
				ValaTypeSymbol* _tmp203_;
				ValaDataType* _tmp204_;
				ValaTypeSymbol* _tmp205_;
				ValaTypeSymbol* _tmp206_;
				_tmp197_ = param;
				_tmp198_ = vala_variable_get_variable_type ((ValaVariable*) _tmp197_);
				_tmp199_ = _tmp198_;
				_tmp200_ = vala_array_type_get_element_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp199_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				_tmp201_ = _tmp200_;
				_tmp202_ = vala_data_type_get_data_type (_tmp201_);
				_tmp203_ = _tmp202_;
				_tmp204_ = ((ValaCCodeBaseModule*) self)->string_type;
				_tmp205_ = vala_data_type_get_data_type (_tmp204_);
				_tmp206_ = _tmp205_;
				if (_tmp203_ == _tmp206_) {
					ValaCCodeFunctionCall* _tmp207_;
					ValaCCodeConstant* _tmp208_;
					ValaCCodeConstant* _tmp209_;
					_tmp207_ = csignew;
					_tmp208_ = vala_ccode_constant_new ("G_TYPE_STRV");
					_tmp209_ = _tmp208_;
					vala_ccode_function_call_add_argument (_tmp207_, (ValaCCodeExpression*) _tmp209_);
					_vala_ccode_node_unref0 (_tmp209_);
				} else {
					ValaCCodeFunctionCall* _tmp210_;
					ValaCCodeConstant* _tmp211_;
					ValaCCodeConstant* _tmp212_;
					_tmp210_ = csignew;
					_tmp211_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp212_ = _tmp211_;
					vala_ccode_function_call_add_argument (_tmp210_, (ValaCCodeExpression*) _tmp212_);
					_vala_ccode_node_unref0 (_tmp212_);
				}
				{
					gint i = 0;
					i = 0;
					{
						gboolean _tmp213_ = FALSE;
						_tmp213_ = TRUE;
						while (TRUE) {
							gint _tmp215_;
							ValaParameter* _tmp216_;
							ValaDataType* _tmp217_;
							ValaDataType* _tmp218_;
							gint _tmp219_;
							gint _tmp220_;
							ValaCCodeFunctionCall* _tmp221_;
							ValaCCodeConstant* _tmp222_;
							ValaCCodeConstant* _tmp223_;
							if (!_tmp213_) {
								gint _tmp214_;
								_tmp214_ = i;
								i = _tmp214_ + 1;
							}
							_tmp213_ = FALSE;
							_tmp215_ = i;
							_tmp216_ = param;
							_tmp217_ = vala_variable_get_variable_type ((ValaVariable*) _tmp216_);
							_tmp218_ = _tmp217_;
							_tmp219_ = vala_array_type_get_rank (G_TYPE_CHECK_INSTANCE_CAST (_tmp218_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp220_ = _tmp219_;
							if (!(_tmp215_ < _tmp220_)) {
								break;
							}
							_tmp221_ = csignew;
							_tmp222_ = vala_ccode_constant_new ("G_TYPE_INT");
							_tmp223_ = _tmp222_;
							vala_ccode_function_call_add_argument (_tmp221_, (ValaCCodeExpression*) _tmp223_);
							_vala_ccode_node_unref0 (_tmp223_);
						}
					}
				}
			} else {
				ValaParameter* _tmp224_;
				ValaDataType* _tmp225_;
				ValaDataType* _tmp226_;
				_tmp224_ = param;
				_tmp225_ = vala_variable_get_variable_type ((ValaVariable*) _tmp224_);
				_tmp226_ = _tmp225_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp226_, VALA_TYPE_DELEGATE_TYPE)) {
					ValaDelegateType* delegate_type = NULL;
					ValaParameter* _tmp227_;
					ValaDataType* _tmp228_;
					ValaDataType* _tmp229_;
					ValaCCodeFunctionCall* _tmp230_;
					ValaCCodeConstant* _tmp231_;
					ValaCCodeConstant* _tmp232_;
					ValaDelegateType* _tmp233_;
					ValaDelegate* _tmp234_;
					ValaDelegate* _tmp235_;
					gboolean _tmp236_;
					gboolean _tmp237_;
					_tmp227_ = param;
					_tmp228_ = vala_variable_get_variable_type ((ValaVariable*) _tmp227_);
					_tmp229_ = _tmp228_;
					delegate_type = G_TYPE_CHECK_INSTANCE_CAST (_tmp229_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType);
					_tmp230_ = csignew;
					_tmp231_ = vala_ccode_constant_new ("G_TYPE_POINTER");
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_add_argument (_tmp230_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_tmp233_ = delegate_type;
					_tmp234_ = vala_delegate_type_get_delegate_symbol (_tmp233_);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_delegate_get_has_target (_tmp235_);
					_tmp237_ = _tmp236_;
					if (_tmp237_) {
						ValaCCodeFunctionCall* _tmp238_;
						ValaCCodeConstant* _tmp239_;
						ValaCCodeConstant* _tmp240_;
						ValaDelegateType* _tmp241_;
						_tmp238_ = csignew;
						_tmp239_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp240_ = _tmp239_;
						vala_ccode_function_call_add_argument (_tmp238_, (ValaCCodeExpression*) _tmp240_);
						_vala_ccode_node_unref0 (_tmp240_);
						_tmp241_ = delegate_type;
						if (vala_data_type_is_disposable ((ValaDataType*) _tmp241_)) {
							ValaCCodeFunctionCall* _tmp242_;
							ValaCCodeConstant* _tmp243_;
							ValaCCodeConstant* _tmp244_;
							_tmp242_ = csignew;
							_tmp243_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp244_ = _tmp243_;
							vala_ccode_function_call_add_argument (_tmp242_, (ValaCCodeExpression*) _tmp244_);
							_vala_ccode_node_unref0 (_tmp244_);
						}
					}
				} else {
					gboolean _tmp245_ = FALSE;
					gboolean _tmp246_ = FALSE;
					ValaParameter* _tmp247_;
					ValaDataType* _tmp248_;
					ValaDataType* _tmp249_;
					_tmp247_ = param;
					_tmp248_ = vala_variable_get_variable_type ((ValaVariable*) _tmp247_);
					_tmp249_ = _tmp248_;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp249_, VALA_TYPE_POINTER_TYPE)) {
						_tmp246_ = TRUE;
					} else {
						ValaParameter* _tmp250_;
						ValaDataType* _tmp251_;
						ValaDataType* _tmp252_;
						_tmp250_ = param;
						_tmp251_ = vala_variable_get_variable_type ((ValaVariable*) _tmp250_);
						_tmp252_ = _tmp251_;
						_tmp246_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp252_, VALA_TYPE_GENERIC_TYPE);
					}
					if (_tmp246_) {
						_tmp245_ = TRUE;
					} else {
						ValaParameter* _tmp253_;
						ValaParameterDirection _tmp254_;
						ValaParameterDirection _tmp255_;
						_tmp253_ = param;
						_tmp254_ = vala_parameter_get_direction (_tmp253_);
						_tmp255_ = _tmp254_;
						_tmp245_ = _tmp255_ != VALA_PARAMETER_DIRECTION_IN;
					}
					if (_tmp245_) {
						ValaCCodeFunctionCall* _tmp256_;
						ValaCCodeConstant* _tmp257_;
						ValaCCodeConstant* _tmp258_;
						_tmp256_ = csignew;
						_tmp257_ = vala_ccode_constant_new ("G_TYPE_POINTER");
						_tmp258_ = _tmp257_;
						vala_ccode_function_call_add_argument (_tmp256_, (ValaCCodeExpression*) _tmp258_);
						_vala_ccode_node_unref0 (_tmp258_);
					} else {
						ValaParameter* _tmp259_;
						ValaDataType* _tmp260_;
						ValaDataType* _tmp261_;
						_tmp259_ = param;
						_tmp260_ = vala_variable_get_variable_type ((ValaVariable*) _tmp259_);
						_tmp261_ = _tmp260_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp261_, VALA_TYPE_ERROR_TYPE)) {
							ValaCCodeFunctionCall* _tmp262_;
							ValaCCodeConstant* _tmp263_;
							ValaCCodeConstant* _tmp264_;
							_tmp262_ = csignew;
							_tmp263_ = vala_ccode_constant_new ("G_TYPE_POINTER");
							_tmp264_ = _tmp263_;
							vala_ccode_function_call_add_argument (_tmp262_, (ValaCCodeExpression*) _tmp264_);
							_vala_ccode_node_unref0 (_tmp264_);
						} else {
							gboolean _tmp265_ = FALSE;
							ValaParameter* _tmp266_;
							ValaDataType* _tmp267_;
							ValaDataType* _tmp268_;
							_tmp266_ = param;
							_tmp267_ = vala_variable_get_variable_type ((ValaVariable*) _tmp266_);
							_tmp268_ = _tmp267_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp268_, VALA_TYPE_VALUE_TYPE)) {
								ValaParameter* _tmp269_;
								ValaDataType* _tmp270_;
								ValaDataType* _tmp271_;
								gboolean _tmp272_;
								gboolean _tmp273_;
								_tmp269_ = param;
								_tmp270_ = vala_variable_get_variable_type ((ValaVariable*) _tmp269_);
								_tmp271_ = _tmp270_;
								_tmp272_ = vala_data_type_get_nullable (_tmp271_);
								_tmp273_ = _tmp272_;
								_tmp265_ = _tmp273_;
							} else {
								_tmp265_ = FALSE;
							}
							if (_tmp265_) {
								ValaCCodeFunctionCall* _tmp274_;
								ValaCCodeConstant* _tmp275_;
								ValaCCodeConstant* _tmp276_;
								_tmp274_ = csignew;
								_tmp275_ = vala_ccode_constant_new ("G_TYPE_POINTER");
								_tmp276_ = _tmp275_;
								vala_ccode_function_call_add_argument (_tmp274_, (ValaCCodeExpression*) _tmp276_);
								_vala_ccode_node_unref0 (_tmp276_);
							} else {
								ValaCCodeFunctionCall* _tmp277_;
								ValaParameter* _tmp278_;
								ValaDataType* _tmp279_;
								ValaDataType* _tmp280_;
								ValaTypeSymbol* _tmp281_;
								ValaTypeSymbol* _tmp282_;
								gchar* _tmp283_;
								gchar* _tmp284_;
								ValaCCodeConstant* _tmp285_;
								ValaCCodeConstant* _tmp286_;
								_tmp277_ = csignew;
								_tmp278_ = param;
								_tmp279_ = vala_variable_get_variable_type ((ValaVariable*) _tmp278_);
								_tmp280_ = _tmp279_;
								_tmp281_ = vala_data_type_get_data_type (_tmp280_);
								_tmp282_ = _tmp281_;
								_tmp283_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp282_);
								_tmp284_ = _tmp283_;
								_tmp285_ = vala_ccode_constant_new (_tmp284_);
								_tmp286_ = _tmp285_;
								vala_ccode_function_call_add_argument (_tmp277_, (ValaCCodeExpression*) _tmp286_);
								_vala_ccode_node_unref0 (_tmp286_);
								_g_free0 (_tmp284_);
							}
						}
					}
				}
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp287_ = vala_callable_get_return_type ((ValaCallable*) sig);
	_tmp288_ = _tmp287_;
	if (vala_data_type_is_real_non_null_struct_type (_tmp288_)) {
		ValaCCodeFunctionCall* _tmp289_;
		ValaCCodeConstant* _tmp290_;
		ValaCCodeConstant* _tmp291_;
		_tmp289_ = csignew;
		_tmp290_ = vala_ccode_constant_new ("G_TYPE_POINTER");
		_tmp291_ = _tmp290_;
		vala_ccode_function_call_add_argument (_tmp289_, (ValaCCodeExpression*) _tmp291_);
		_vala_ccode_node_unref0 (_tmp291_);
	}
	_tmp292_ = marshal_arg;
	_tmp293_ = marshaller;
	vala_ccode_identifier_set_name (_tmp292_, _tmp293_);
	_tmp294_ = vala_gsignal_module_get_signal_id_cexpression (self, sig);
	_tmp295_ = _tmp294_;
	_tmp296_ = csignew;
	_tmp297_ = vala_ccode_assignment_new (_tmp295_, (ValaCCodeExpression*) _tmp296_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
	_tmp298_ = (ValaCCodeExpression*) _tmp297_;
	_vala_ccode_node_unref0 (_tmp295_);
	result = _tmp298_;
	_vala_ccode_node_unref0 (marshal_arg);
	_g_free0 (marshaller);
	_vala_iterable_unref0 (params);
	_g_free0 (run_type);
	flags = (_vala_array_free (flags, flags_length1, (GDestroyNotify) g_free), NULL);
	_vala_ccode_node_unref0 (csignew);
	return result;
}


static void
vala_gsignal_module_real_visit_element_access (ValaCodeVisitor* base,
                                               ValaElementAccess* expr)
{
	ValaGSignalModule * self;
	gboolean _tmp0_ = FALSE;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp1_ = vala_element_access_get_container (expr);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_MEMBER_ACCESS)) {
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp3_ = vala_element_access_get_container (expr);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_expression_get_symbol_reference (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_SIGNAL);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaCodeNode* _tmp7_;
		ValaCodeNode* _tmp8_;
		_tmp7_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
		_tmp8_ = _tmp7_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_METHOD_CALL)) {
			ValaSignal* sig = NULL;
			ValaSymbol* _tmp9_;
			ValaSymbol* _tmp10_;
			ValaSignal* _tmp11_;
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp12_;
			ValaExpression* _tmp13_;
			ValaMemberAccess* _tmp14_;
			ValaExpression* detail_expr = NULL;
			ValaList* _tmp15_;
			ValaList* _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaCCodeFunctionCall* ccall = NULL;
			gboolean _tmp19_ = FALSE;
			ValaSignal* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaCCodeFunctionCall* _tmp65_;
			_tmp9_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
			_tmp10_ = _tmp9_;
			_tmp11_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_SIGNAL, ValaSignal));
			sig = _tmp11_;
			_tmp12_ = vala_element_access_get_container (expr);
			_tmp13_ = _tmp12_;
			_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp14_;
			_tmp15_ = vala_element_access_get_indices (expr);
			_tmp16_ = _tmp15_;
			_tmp17_ = vala_list_get (_tmp16_, 0);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_vala_iterable_unref0 (_tmp16_);
			detail_expr = _tmp18_;
			_tmp20_ = sig;
			_tmp21_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp20_);
			_tmp22_ = _tmp21_;
			if (!_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaSourceFile* _tmp25_;
				ValaSourceFile* _tmp26_;
				ValaSignal* _tmp27_;
				ValaSourceReference* _tmp28_;
				ValaSourceReference* _tmp29_;
				ValaSourceFile* _tmp30_;
				ValaSourceFile* _tmp31_;
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_source_reference_get_file (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = sig;
				_tmp28_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = vala_source_reference_get_file (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp19_ = _tmp26_ == _tmp31_;
			} else {
				_tmp19_ = FALSE;
			}
			if (_tmp19_) {
				ValaCCodeExpression* detail_cexpr = NULL;
				ValaExpression* _tmp32_;
				ValaCCodeExpression* _tmp33_;
				ValaCCodeIdentifier* _tmp34_;
				ValaCCodeIdentifier* _tmp35_;
				ValaCCodeFunctionCall* _tmp36_;
				ValaCCodeFunctionCall* _tmp37_;
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaCCodeExpression* _tmp41_;
				ValaCCodeExpression* _tmp42_;
				ValaCCodeFunctionCall* _tmp43_;
				ValaSignal* _tmp44_;
				ValaCCodeExpression* _tmp45_;
				ValaCCodeExpression* _tmp46_;
				ValaCCodeExpression* _tmp47_;
				_tmp32_ = detail_expr;
				_tmp33_ = vala_gsignal_module_get_detail_cexpression (self, _tmp32_, (ValaCodeNode*) expr);
				detail_cexpr = _tmp33_;
				_tmp34_ = vala_ccode_identifier_new ("g_signal_emit");
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp35_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp36_;
				_vala_ccode_node_unref0 (_tmp35_);
				_tmp37_ = ccall;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp40_);
				_tmp42_ = _tmp41_;
				vala_ccode_function_call_add_argument (_tmp37_, _tmp42_);
				_vala_ccode_node_unref0 (_tmp42_);
				_tmp43_ = ccall;
				_tmp44_ = sig;
				_tmp45_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp44_);
				_tmp46_ = _tmp45_;
				vala_ccode_function_call_add_argument (_tmp43_, _tmp46_);
				_vala_ccode_node_unref0 (_tmp46_);
				_tmp47_ = detail_cexpr;
				if (_tmp47_ != NULL) {
					ValaCCodeFunctionCall* _tmp48_;
					ValaCCodeExpression* _tmp49_;
					_tmp48_ = ccall;
					_tmp49_ = detail_cexpr;
					vala_ccode_function_call_add_argument (_tmp48_, _tmp49_);
				}
				_vala_ccode_node_unref0 (detail_cexpr);
			} else {
				ValaCCodeExpression* signal_name_cexpr = NULL;
				ValaSignal* _tmp50_;
				ValaExpression* _tmp51_;
				ValaCCodeExpression* _tmp52_;
				ValaCCodeIdentifier* _tmp53_;
				ValaCCodeIdentifier* _tmp54_;
				ValaCCodeFunctionCall* _tmp55_;
				ValaCCodeFunctionCall* _tmp56_;
				ValaMemberAccess* _tmp57_;
				ValaExpression* _tmp58_;
				ValaExpression* _tmp59_;
				ValaCCodeExpression* _tmp60_;
				ValaCCodeExpression* _tmp61_;
				ValaCCodeExpression* _tmp62_;
				_tmp50_ = sig;
				_tmp51_ = detail_expr;
				_tmp52_ = vala_gsignal_module_get_signal_name_cexpression (self, _tmp50_, _tmp51_, (ValaCodeNode*) expr);
				signal_name_cexpr = _tmp52_;
				_tmp53_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp54_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp55_;
				_vala_ccode_node_unref0 (_tmp54_);
				_tmp56_ = ccall;
				_tmp57_ = ma;
				_tmp58_ = vala_member_access_get_inner (_tmp57_);
				_tmp59_ = _tmp58_;
				_tmp60_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp59_);
				_tmp61_ = _tmp60_;
				vala_ccode_function_call_add_argument (_tmp56_, _tmp61_);
				_vala_ccode_node_unref0 (_tmp61_);
				_tmp62_ = signal_name_cexpr;
				if (_tmp62_ != NULL) {
					ValaCCodeFunctionCall* _tmp63_;
					ValaCCodeExpression* _tmp64_;
					_tmp63_ = ccall;
					_tmp64_ = signal_name_cexpr;
					vala_ccode_function_call_add_argument (_tmp63_, _tmp64_);
				}
				_vala_ccode_node_unref0 (signal_name_cexpr);
			}
			_tmp65_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp65_);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (sig);
		} else {
		}
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_element_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}


static gboolean
vala_gsignal_module_in_gobject_instance (ValaGSignalModule* self,
                                         ValaMethod* m)
{
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (m != NULL, FALSE);
	_result_ = FALSE;
	_tmp0_ = vala_method_get_binding (m);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaParameter* _tmp2_;
		ValaParameter* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaTypeSymbol* _tmp6_;
		ValaTypeSymbol* _tmp7_;
		ValaTypeSymbol* _tmp8_;
		_tmp2_ = vala_method_get_this_parameter (m);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = vala_data_type_get_data_type (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ((ValaCCodeBaseModule*) self)->gobject_type;
		_result_ = vala_typesymbol_is_subtype_of (_tmp7_, _tmp8_);
	}
	result = _result_;
	return result;
}


static void
vala_gsignal_module_emit_signal_assignment (ValaGSignalModule* self,
                                            ValaAssignment* assignment)
{
	ValaSignal* sig = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSignal* _tmp4_;
	gboolean disconnect = FALSE;
	ValaAssignmentOperator _tmp5_;
	ValaAssignmentOperator _tmp6_;
	ValaSignal* _tmp11_;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaExpression* _tmp14_;
	ValaExpression* _tmp15_;
	gboolean _tmp16_;
	ValaCCodeExpression* _tmp17_;
	ValaCCodeExpression* _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp4_;
	disconnect = FALSE;
	_tmp5_ = vala_assignment_get_operator (assignment);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
	} else {
		ValaAssignmentOperator _tmp7_;
		ValaAssignmentOperator _tmp8_;
		_tmp7_ = vala_assignment_get_operator (assignment);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == VALA_ASSIGNMENT_OPERATOR_SUB) {
			disconnect = TRUE;
		} else {
			ValaSourceReference* _tmp9_;
			ValaSourceReference* _tmp10_;
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) assignment);
			_tmp10_ = _tmp9_;
			vala_report_error (_tmp10_, "Specified compound assignment type for signals not supported.");
			_vala_code_node_unref0 (sig);
			return;
		}
	}
	_tmp11_ = sig;
	_tmp12_ = vala_assignment_get_left (assignment);
	_tmp13_ = _tmp12_;
	_tmp14_ = vala_assignment_get_right (assignment);
	_tmp15_ = _tmp14_;
	_tmp16_ = disconnect;
	_tmp17_ = vala_gsignal_module_connect_signal (self, _tmp11_, _tmp13_, _tmp15_, _tmp16_, FALSE, (ValaCodeNode*) assignment);
	_tmp18_ = _tmp17_;
	_vala_ccode_node_unref0 (_tmp18_);
	_vala_code_node_unref0 (sig);
}


static void
vala_gsignal_module_real_visit_assignment (ValaCodeVisitor* base,
                                           ValaAssignment* assignment)
{
	ValaGSignalModule * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaSymbol* _tmp2_;
	ValaSymbol* _tmp3_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (assignment != NULL);
	_tmp0_ = vala_assignment_get_left (assignment);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_symbol_reference (_tmp1_);
	_tmp3_ = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_SIGNAL)) {
		gboolean _tmp4_ = FALSE;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp5_ = vala_assignment_get_left (assignment);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_code_node_get_error ((ValaCodeNode*) _tmp6_);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			_tmp4_ = TRUE;
		} else {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_assignment_get_right (assignment);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_node_get_error ((ValaCodeNode*) _tmp10_);
			_tmp12_ = _tmp11_;
			_tmp4_ = _tmp12_;
		}
		if (_tmp4_) {
			vala_code_node_set_error ((ValaCodeNode*) assignment, TRUE);
			return;
		}
		vala_gsignal_module_emit_signal_assignment (self, assignment);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_assignment ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), assignment);
	}
}


static void
vala_gsignal_module_real_visit_member_access (ValaCodeVisitor* base,
                                              ValaMemberAccess* expr)
{
	ValaGSignalModule * self;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_SIGNAL)) {
		ValaCCodeExpression* pub_inst = NULL;
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaSignal* sig = NULL;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSignal* _tmp9_;
		ValaTypeSymbol* cl = NULL;
		ValaSignal* _tmp10_;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaTypeSymbol* _tmp13_;
		gboolean _tmp14_ = FALSE;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		gboolean _tmp52_ = FALSE;
		ValaSignal* _tmp53_;
		gboolean _tmp54_;
		gboolean _tmp55_;
		pub_inst = NULL;
		_tmp2_ = vala_member_access_get_inner (expr);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaExpression* _tmp4_;
			ValaExpression* _tmp5_;
			ValaCCodeExpression* _tmp6_;
			_tmp4_ = vala_member_access_get_inner (expr);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
			_vala_ccode_node_unref0 (pub_inst);
			pub_inst = _tmp6_;
		}
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) expr);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_SIGNAL, ValaSignal));
		sig = _tmp9_;
		_tmp10_ = sig;
		_tmp11_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		cl = _tmp13_;
		_tmp15_ = vala_member_access_get_inner (expr);
		_tmp16_ = _tmp15_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_BASE_ACCESS)) {
			ValaSignal* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			_tmp17_ = sig;
			_tmp18_ = vala_signal_get_is_virtual (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp14_ = _tmp19_;
		} else {
			_tmp14_ = FALSE;
		}
		if (_tmp14_) {
			ValaMethod* m = NULL;
			ValaSignal* _tmp20_;
			ValaMethod* _tmp21_;
			ValaMethod* _tmp22_;
			ValaMethod* _tmp23_;
			ValaClass* base_class = NULL;
			ValaMethod* _tmp24_;
			ValaSymbol* _tmp25_;
			ValaSymbol* _tmp26_;
			ValaClass* _tmp27_;
			ValaCCodeFunctionCall* vcast = NULL;
			ValaClass* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			ValaCCodeIdentifier* _tmp33_;
			ValaCCodeIdentifier* _tmp34_;
			ValaCCodeFunctionCall* _tmp35_;
			ValaCCodeFunctionCall* _tmp36_;
			ValaCCodeFunctionCall* _tmp37_;
			ValaClass* _tmp38_;
			ValaClass* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			ValaCCodeIdentifier* _tmp44_;
			ValaCCodeIdentifier* _tmp45_;
			ValaCCodeFunctionCall* _tmp46_;
			ValaMethod* _tmp47_;
			const gchar* _tmp48_;
			const gchar* _tmp49_;
			ValaCCodeMemberAccess* _tmp50_;
			ValaCCodeMemberAccess* _tmp51_;
			_tmp20_ = sig;
			_tmp21_ = vala_signal_get_default_handler (_tmp20_);
			_tmp22_ = _tmp21_;
			_tmp23_ = _vala_code_node_ref0 (_tmp22_);
			m = _tmp23_;
			_tmp24_ = m;
			_tmp25_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, VALA_TYPE_CLASS, ValaClass));
			base_class = _tmp27_;
			_tmp28_ = base_class;
			_tmp29_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp28_, NULL);
			_tmp30_ = _tmp29_;
			_tmp31_ = g_strdup_printf ("%s_CLASS", _tmp30_);
			_tmp32_ = _tmp31_;
			_tmp33_ = vala_ccode_identifier_new (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
			_tmp36_ = _tmp35_;
			_vala_ccode_node_unref0 (_tmp34_);
			_g_free0 (_tmp32_);
			_g_free0 (_tmp30_);
			vcast = _tmp36_;
			_tmp37_ = vcast;
			_tmp38_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp39_ = _tmp38_;
			_tmp40_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp39_, NULL);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strdup_printf ("%s_parent_class", _tmp41_);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_ccode_identifier_new (_tmp43_);
			_tmp45_ = _tmp44_;
			vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp45_);
			_vala_ccode_node_unref0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_tmp46_ = vcast;
			_tmp47_ = m;
			_tmp48_ = vala_symbol_get_name ((ValaSymbol*) _tmp47_);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp46_, _tmp49_);
			_tmp51_ = _tmp50_;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp51_);
			_vala_ccode_node_unref0 (_tmp51_);
			_vala_ccode_node_unref0 (vcast);
			_vala_code_node_unref0 (base_class);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (sig);
			_vala_ccode_node_unref0 (pub_inst);
			return;
		}
		_tmp53_ = sig;
		_tmp54_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp53_);
		_tmp55_ = _tmp54_;
		if (!_tmp55_) {
			ValaSourceReference* _tmp56_;
			ValaSourceReference* _tmp57_;
			ValaSourceFile* _tmp58_;
			ValaSourceFile* _tmp59_;
			ValaSignal* _tmp60_;
			ValaSourceReference* _tmp61_;
			ValaSourceReference* _tmp62_;
			ValaSourceFile* _tmp63_;
			ValaSourceFile* _tmp64_;
			_tmp56_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_source_reference_get_file (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = sig;
			_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp60_);
			_tmp62_ = _tmp61_;
			_tmp63_ = vala_source_reference_get_file (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp52_ = _tmp59_ == _tmp64_;
		} else {
			_tmp52_ = FALSE;
		}
		if (_tmp52_) {
			ValaCCodeFunctionCall* ccall = NULL;
			ValaCCodeIdentifier* _tmp65_;
			ValaCCodeIdentifier* _tmp66_;
			ValaCCodeFunctionCall* _tmp67_;
			ValaCCodeFunctionCall* _tmp68_;
			ValaCCodeFunctionCall* _tmp69_;
			ValaCCodeExpression* _tmp70_;
			ValaCCodeFunctionCall* _tmp71_;
			ValaSignal* _tmp72_;
			ValaCCodeExpression* _tmp73_;
			ValaCCodeExpression* _tmp74_;
			ValaCCodeFunctionCall* _tmp75_;
			ValaCCodeConstant* _tmp76_;
			ValaCCodeConstant* _tmp77_;
			ValaCCodeFunctionCall* _tmp78_;
			_tmp65_ = vala_ccode_identifier_new ("g_signal_emit");
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp66_);
			_tmp68_ = _tmp67_;
			_vala_ccode_node_unref0 (_tmp66_);
			ccall = _tmp68_;
			_tmp69_ = ccall;
			_tmp70_ = pub_inst;
			vala_ccode_function_call_add_argument (_tmp69_, _tmp70_);
			_tmp71_ = ccall;
			_tmp72_ = sig;
			_tmp73_ = vala_gsignal_module_get_signal_id_cexpression (self, _tmp72_);
			_tmp74_ = _tmp73_;
			vala_ccode_function_call_add_argument (_tmp71_, _tmp74_);
			_vala_ccode_node_unref0 (_tmp74_);
			_tmp75_ = ccall;
			_tmp76_ = vala_ccode_constant_new ("0");
			_tmp77_ = _tmp76_;
			vala_ccode_function_call_add_argument (_tmp75_, (ValaCCodeExpression*) _tmp77_);
			_vala_ccode_node_unref0 (_tmp77_);
			_tmp78_ = ccall;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp78_);
			_vala_ccode_node_unref0 (ccall);
		} else {
			ValaSignal* _tmp79_;
			_tmp79_ = sig;
			if (vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp79_)) {
				gchar* emitter_func = NULL;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaCCodeFunctionCall* ccall = NULL;
				const gchar* _tmp111_;
				ValaCCodeIdentifier* _tmp112_;
				ValaCCodeIdentifier* _tmp113_;
				ValaCCodeFunctionCall* _tmp114_;
				ValaCCodeFunctionCall* _tmp115_;
				ValaCCodeFunctionCall* _tmp116_;
				ValaCCodeExpression* _tmp117_;
				ValaCCodeFunctionCall* _tmp118_;
				_tmp80_ = sig;
				_tmp81_ = vala_signal_get_emitter (_tmp80_);
				_tmp82_ = _tmp81_;
				if (_tmp82_ != NULL) {
					gboolean _tmp83_ = FALSE;
					ValaSignal* _tmp84_;
					gboolean _tmp85_;
					gboolean _tmp86_;
					ValaSignal* _tmp100_;
					ValaMethod* _tmp101_;
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp84_ = sig;
					_tmp85_ = vala_symbol_get_external_package ((ValaSymbol*) _tmp84_);
					_tmp86_ = _tmp85_;
					if (!_tmp86_) {
						ValaSourceReference* _tmp87_;
						ValaSourceReference* _tmp88_;
						ValaSourceFile* _tmp89_;
						ValaSourceFile* _tmp90_;
						ValaSignal* _tmp91_;
						ValaSourceReference* _tmp92_;
						ValaSourceReference* _tmp93_;
						ValaSourceFile* _tmp94_;
						ValaSourceFile* _tmp95_;
						_tmp87_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
						_tmp88_ = _tmp87_;
						_tmp89_ = vala_source_reference_get_file (_tmp88_);
						_tmp90_ = _tmp89_;
						_tmp91_ = sig;
						_tmp92_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp91_);
						_tmp93_ = _tmp92_;
						_tmp94_ = vala_source_reference_get_file (_tmp93_);
						_tmp95_ = _tmp94_;
						_tmp83_ = _tmp90_ != _tmp95_;
					} else {
						_tmp83_ = FALSE;
					}
					if (_tmp83_) {
						ValaSignal* _tmp96_;
						ValaMethod* _tmp97_;
						ValaMethod* _tmp98_;
						ValaCCodeFile* _tmp99_;
						_tmp96_ = sig;
						_tmp97_ = vala_signal_get_emitter (_tmp96_);
						_tmp98_ = _tmp97_;
						_tmp99_ = ((ValaCCodeBaseModule*) self)->cfile;
						vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp98_, _tmp99_);
					}
					_tmp100_ = sig;
					_tmp101_ = vala_signal_get_emitter (_tmp100_);
					_tmp102_ = _tmp101_;
					_tmp103_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp102_, NULL);
					_g_free0 (emitter_func);
					emitter_func = _tmp103_;
				} else {
					ValaTypeSymbol* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					ValaSignal* _tmp107_;
					gchar* _tmp108_;
					gchar* _tmp109_;
					gchar* _tmp110_;
					_tmp104_ = cl;
					_tmp105_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp104_, NULL);
					_tmp106_ = _tmp105_;
					_tmp107_ = sig;
					_tmp108_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp107_, NULL);
					_tmp109_ = _tmp108_;
					_tmp110_ = g_strdup_printf ("%s_%s", _tmp106_, _tmp109_);
					_g_free0 (emitter_func);
					emitter_func = _tmp110_;
					_g_free0 (_tmp109_);
					_g_free0 (_tmp106_);
				}
				_tmp111_ = emitter_func;
				_tmp112_ = vala_ccode_identifier_new (_tmp111_);
				_tmp113_ = _tmp112_;
				_tmp114_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp113_);
				_tmp115_ = _tmp114_;
				_vala_ccode_node_unref0 (_tmp113_);
				ccall = _tmp115_;
				_tmp116_ = ccall;
				_tmp117_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp116_, _tmp117_);
				_tmp118_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp118_);
				_vala_ccode_node_unref0 (ccall);
				_g_free0 (emitter_func);
			} else {
				ValaCCodeFunctionCall* ccall = NULL;
				ValaCCodeIdentifier* _tmp119_;
				ValaCCodeIdentifier* _tmp120_;
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeFunctionCall* _tmp122_;
				ValaCCodeFunctionCall* _tmp123_;
				ValaCCodeExpression* _tmp124_;
				ValaCCodeFunctionCall* _tmp125_;
				ValaSignal* _tmp126_;
				ValaCCodeConstant* _tmp127_;
				ValaCCodeConstant* _tmp128_;
				ValaCCodeFunctionCall* _tmp129_;
				_tmp119_ = vala_ccode_identifier_new ("g_signal_emit_by_name");
				_tmp120_ = _tmp119_;
				_tmp121_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp120_);
				_tmp122_ = _tmp121_;
				_vala_ccode_node_unref0 (_tmp120_);
				ccall = _tmp122_;
				_tmp123_ = ccall;
				_tmp124_ = pub_inst;
				vala_ccode_function_call_add_argument (_tmp123_, _tmp124_);
				_tmp125_ = ccall;
				_tmp126_ = sig;
				_tmp127_ = vala_ccode_base_module_get_signal_canonical_constant ((ValaCCodeBaseModule*) self, _tmp126_, NULL);
				_tmp128_ = _tmp127_;
				vala_ccode_function_call_add_argument (_tmp125_, (ValaCCodeExpression*) _tmp128_);
				_vala_ccode_node_unref0 (_tmp128_);
				_tmp129_ = ccall;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp129_);
				_vala_ccode_node_unref0 (ccall);
			}
		}
		_vala_code_node_unref0 (cl);
		_vala_code_node_unref0 (sig);
		_vala_ccode_node_unref0 (pub_inst);
	} else {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_member_access ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
	}
}


static void
vala_gsignal_module_real_visit_method_call (ValaCodeVisitor* base,
                                            ValaMethodCall* expr)
{
	ValaGSignalModule * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	ValaSignal* sig = NULL;
	ValaMethodType* _tmp12_;
	ValaMethod* _tmp13_;
	ValaMethod* _tmp14_;
	ValaSymbol* _tmp15_;
	ValaSymbol* _tmp16_;
	ValaSignal* _tmp17_;
	ValaExpression* signal_access = NULL;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	ValaExpression* _tmp20_;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaExpression* handler = NULL;
	ValaList* _tmp23_;
	ValaList* _tmp24_;
	gpointer _tmp25_;
	ValaExpression* _tmp26_;
	gboolean disconnect = FALSE;
	ValaMethodType* _tmp27_;
	ValaMethod* _tmp28_;
	ValaMethod* _tmp29_;
	const gchar* _tmp30_;
	const gchar* _tmp31_;
	gboolean after = FALSE;
	ValaMethodType* _tmp32_;
	ValaMethod* _tmp33_;
	ValaMethod* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	ValaCCodeExpression* cexpr = NULL;
	ValaSignal* _tmp37_;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	gboolean _tmp40_;
	gboolean _tmp41_;
	ValaCCodeExpression* _tmp42_;
	ValaCCodeExpression* _tmp43_;
	self = (ValaGSignalModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_METHOD_TYPE) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ == NULL) {
		_tmp5_ = TRUE;
	} else {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_SIGNAL);
	}
	if (_tmp5_) {
		VALA_CODE_VISITOR_CLASS (vala_gsignal_module_parent_class)->visit_method_call ((ValaCodeVisitor*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_GOBJECT_MODULE, ValaGObjectModule), expr);
		_vala_code_node_unref0 (method_type);
		return;
	}
	_tmp12_ = method_type;
	_tmp13_ = vala_method_type_get_method_symbol (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_SIGNAL, ValaSignal));
	sig = _tmp17_;
	_tmp18_ = vala_method_call_get_call (expr);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (_tmp21_);
	signal_access = _tmp22_;
	_tmp23_ = vala_method_call_get_argument_list (expr);
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_list_get (_tmp24_, 0);
	_tmp26_ = (ValaExpression*) _tmp25_;
	_vala_iterable_unref0 (_tmp24_);
	handler = _tmp26_;
	_tmp27_ = method_type;
	_tmp28_ = vala_method_type_get_method_symbol (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_symbol_get_name ((ValaSymbol*) _tmp29_);
	_tmp31_ = _tmp30_;
	disconnect = g_strcmp0 (_tmp31_, "disconnect") == 0;
	_tmp32_ = method_type;
	_tmp33_ = vala_method_type_get_method_symbol (_tmp32_);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_symbol_get_name ((ValaSymbol*) _tmp34_);
	_tmp36_ = _tmp35_;
	after = g_strcmp0 (_tmp36_, "connect_after") == 0;
	_tmp37_ = sig;
	_tmp38_ = signal_access;
	_tmp39_ = handler;
	_tmp40_ = disconnect;
	_tmp41_ = after;
	_tmp42_ = vala_gsignal_module_connect_signal (self, _tmp37_, _tmp38_, _tmp39_, _tmp40_, _tmp41_, (ValaCodeNode*) expr);
	cexpr = _tmp42_;
	_tmp43_ = cexpr;
	vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp43_);
	_vala_ccode_node_unref0 (cexpr);
	_vala_code_node_unref0 (handler);
	_vala_code_node_unref0 (signal_access);
	_vala_code_node_unref0 (sig);
	_vala_code_node_unref0 (method_type);
}


static ValaCCodeExpression*
vala_gsignal_module_connect_signal (ValaGSignalModule* self,
                                    ValaSignal* sig,
                                    ValaExpression* signal_access,
                                    ValaExpression* handler,
                                    gboolean disconnect,
                                    gboolean after,
                                    ValaCodeNode* expr)
{
	ValaCCodeExpression* result = NULL;
	gchar* connect_func = NULL;
	ValaDelegateType* dt = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* m = NULL;
	ValaSymbol* _tmp23_;
	ValaSymbol* _tmp24_;
	ValaMethod* _tmp25_;
	ValaCCodeFunctionCall* ccall = NULL;
	const gchar* _tmp48_;
	ValaCCodeIdentifier* _tmp49_;
	ValaCCodeIdentifier* _tmp50_;
	ValaCCodeFunctionCall* _tmp51_;
	ValaCCodeFunctionCall* _tmp52_;
	ValaCCodeExpression* signal_name_cexpr = NULL;
	ValaMemberAccess* ma = NULL;
	ValaMemberAccess* _tmp68_;
	ValaExpression* _tmp69_;
	ValaExpression* _tmp70_;
	ValaCCodeFunctionCall* _tmp163_;
	ValaCCodeExpression* _tmp164_;
	ValaCCodeExpression* _tmp165_;
	ValaCCodeCastExpression* _tmp166_;
	ValaCCodeCastExpression* _tmp167_;
	gboolean _tmp168_ = FALSE;
	ValaMethod* _tmp169_;
	gboolean _tmp245_ = FALSE;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sig != NULL, NULL);
	g_return_val_if_fail (signal_access != NULL, NULL);
	g_return_val_if_fail (handler != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	dt = NULL;
	_tmp0_ = vala_expression_get_symbol_reference (handler);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_VARIABLE)) {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		ValaDataType* _tmp4_;
		ValaDataType* _tmp5_;
		ValaDelegateType* _tmp6_;
		gboolean _tmp7_ = FALSE;
		ValaDelegateType* _tmp8_;
		ValaSymbol* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaExpression* _tmp17_;
		ValaExpression* _tmp18_;
		_tmp2_ = vala_expression_get_symbol_reference (handler);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_variable_get_variable_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp5_ = _tmp4_;
		_tmp6_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_DELEGATE_TYPE) ? ((ValaDelegateType*) _tmp5_) : NULL);
		_vala_code_node_unref0 (dt);
		dt = _tmp6_;
		_tmp8_ = dt;
		if (_tmp8_ != NULL) {
			ValaCodeContext* _tmp9_;
			ValaCodeContext* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp9_ = vala_ccode_base_module_get_context ((ValaCCodeBaseModule*) self);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_code_context_get_experimental (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp7_ = !_tmp12_;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			ValaSourceReference* _tmp13_;
			ValaSourceReference* _tmp14_;
			_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) handler);
			_tmp14_ = _tmp13_;
			vala_report_warning (_tmp14_, "Connecting delegates to signals is experimental");
		}
		_tmp15_ = vala_expression_get_symbol_reference (handler);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, VALA_TYPE_VARIABLE, ValaVariable));
		_tmp18_ = _tmp17_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_LAMBDA_EXPRESSION)) {
			ValaSymbol* _tmp19_;
			ValaSymbol* _tmp20_;
			ValaExpression* _tmp21_;
			ValaExpression* _tmp22_;
			_tmp19_ = vala_expression_get_symbol_reference (handler);
			_tmp20_ = _tmp19_;
			_tmp21_ = vala_variable_get_initializer (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_VARIABLE, ValaVariable));
			_tmp22_ = _tmp21_;
			handler = _tmp22_;
		}
	}
	_tmp23_ = vala_expression_get_symbol_reference (handler);
	_tmp24_ = _tmp23_;
	_tmp25_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp24_) : NULL);
	m = _tmp25_;
	if (!disconnect) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			if (!after) {
				gchar* _tmp26_;
				_tmp26_ = vala_ccode_base_module_get_dynamic_signal_connect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp26_;
			} else {
				gchar* _tmp27_;
				_tmp27_ = vala_ccode_base_module_get_dynamic_signal_connect_after_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
				_g_free0 (connect_func);
				connect_func = _tmp27_;
			}
		} else {
			gboolean _tmp28_ = FALSE;
			gboolean _tmp29_ = FALSE;
			ValaMethod* _tmp30_;
			_tmp30_ = m;
			if (_tmp30_ != NULL) {
				ValaMethod* _tmp31_;
				gboolean _tmp32_;
				gboolean _tmp33_;
				_tmp31_ = m;
				_tmp32_ = vala_method_get_closure (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp29_ = _tmp33_;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				_tmp28_ = TRUE;
			} else {
				gboolean _tmp34_ = FALSE;
				ValaDelegateType* _tmp35_;
				_tmp35_ = dt;
				if (_tmp35_ != NULL) {
					ValaDelegateType* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_;
					_tmp36_ = dt;
					_tmp37_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp36_);
					_tmp38_ = _tmp37_;
					_tmp34_ = _tmp38_;
				} else {
					_tmp34_ = FALSE;
				}
				_tmp28_ = _tmp34_;
			}
			if (_tmp28_) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup ("g_signal_connect_data");
				_g_free0 (connect_func);
				connect_func = _tmp39_;
			} else {
				gboolean _tmp40_ = FALSE;
				ValaMethod* _tmp41_;
				_tmp41_ = m;
				if (_tmp41_ != NULL) {
					ValaMethod* _tmp42_;
					_tmp42_ = m;
					_tmp40_ = vala_gsignal_module_in_gobject_instance (self, _tmp42_);
				} else {
					_tmp40_ = FALSE;
				}
				if (_tmp40_) {
					gchar* _tmp43_;
					_tmp43_ = g_strdup ("g_signal_connect_object");
					_g_free0 (connect_func);
					connect_func = _tmp43_;
				} else {
					if (!after) {
						gchar* _tmp44_;
						_tmp44_ = g_strdup ("g_signal_connect");
						_g_free0 (connect_func);
						connect_func = _tmp44_;
					} else {
						gchar* _tmp45_;
						_tmp45_ = g_strdup ("g_signal_connect_after");
						_g_free0 (connect_func);
						connect_func = _tmp45_;
					}
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
			gchar* _tmp46_;
			_tmp46_ = vala_ccode_base_module_get_dynamic_signal_disconnect_wrapper_name ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (sig, VALA_TYPE_DYNAMIC_SIGNAL, ValaDynamicSignal));
			_g_free0 (connect_func);
			connect_func = _tmp46_;
		} else {
			gchar* _tmp47_;
			_tmp47_ = g_strdup ("g_signal_handlers_disconnect_matched");
			_g_free0 (connect_func);
			connect_func = _tmp47_;
		}
	}
	_tmp48_ = connect_func;
	_tmp49_ = vala_ccode_identifier_new (_tmp48_);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp50_);
	_tmp52_ = _tmp51_;
	_vala_ccode_node_unref0 (_tmp50_);
	ccall = _tmp52_;
	signal_name_cexpr = NULL;
	if (G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
		ValaElementAccess* ea = NULL;
		ValaElementAccess* _tmp53_;
		ValaElementAccess* _tmp54_;
		ValaExpression* _tmp55_;
		ValaExpression* _tmp56_;
		ValaMemberAccess* _tmp57_;
		ValaExpression* detail_expr = NULL;
		ValaElementAccess* _tmp58_;
		ValaList* _tmp59_;
		ValaList* _tmp60_;
		gpointer _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaCCodeExpression* _tmp64_;
		ValaCCodeExpression* _tmp65_;
		_tmp53_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_ELEMENT_ACCESS, ValaElementAccess));
		ea = _tmp53_;
		_tmp54_ = ea;
		_tmp55_ = vala_element_access_get_container (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp57_;
		_tmp58_ = ea;
		_tmp59_ = vala_element_access_get_indices (_tmp58_);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_list_get (_tmp60_, 0);
		_tmp62_ = (ValaExpression*) _tmp61_;
		_vala_iterable_unref0 (_tmp60_);
		detail_expr = _tmp62_;
		_tmp63_ = detail_expr;
		_tmp64_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, _tmp63_, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp64_;
		_tmp65_ = signal_name_cexpr;
		if (_tmp65_ == NULL) {
			result = NULL;
			_vala_code_node_unref0 (detail_expr);
			_vala_code_node_unref0 (ea);
			_vala_code_node_unref0 (ma);
			_vala_ccode_node_unref0 (signal_name_cexpr);
			_vala_ccode_node_unref0 (ccall);
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (dt);
			_g_free0 (connect_func);
			return result;
		}
		_vala_code_node_unref0 (detail_expr);
		_vala_code_node_unref0 (ea);
	} else {
		ValaMemberAccess* _tmp66_;
		ValaCCodeExpression* _tmp67_;
		_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (signal_access, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_vala_code_node_unref0 (ma);
		ma = _tmp66_;
		_tmp67_ = vala_gsignal_module_get_signal_name_cexpression (self, sig, NULL, expr);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		signal_name_cexpr = _tmp67_;
	}
	_tmp68_ = ma;
	_tmp69_ = vala_member_access_get_inner (_tmp68_);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaCCodeFunctionCall* _tmp71_;
		ValaMemberAccess* _tmp72_;
		ValaExpression* _tmp73_;
		ValaExpression* _tmp74_;
		ValaCCodeExpression* _tmp75_;
		ValaCCodeExpression* _tmp76_;
		_tmp71_ = ccall;
		_tmp72_ = ma;
		_tmp73_ = vala_member_access_get_inner (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = vala_ccode_base_module_get_ccodenode ((ValaCCodeBaseModule*) self, _tmp74_);
		_tmp76_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp75_, VALA_TYPE_CCODE_EXPRESSION, ValaCCodeExpression);
		vala_ccode_function_call_add_argument (_tmp71_, _tmp76_);
		_vala_ccode_node_unref0 (_tmp76_);
	} else {
		ValaCCodeFunctionCall* _tmp77_;
		ValaCCodeExpression* _tmp78_;
		ValaCCodeExpression* _tmp79_;
		_tmp77_ = ccall;
		_tmp78_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
		_tmp79_ = _tmp78_;
		vala_ccode_function_call_add_argument (_tmp77_, _tmp79_);
		_vala_ccode_node_unref0 (_tmp79_);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL)) {
		ValaCCodeFunctionCall* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		gchar* _tmp84_;
		ValaCCodeConstant* _tmp85_;
		ValaCCodeConstant* _tmp86_;
		_tmp80_ = ccall;
		_tmp81_ = vala_get_ccode_name ((ValaCodeNode*) sig);
		_tmp82_ = _tmp81_;
		_tmp83_ = g_strdup_printf ("\"%s\"", _tmp82_);
		_tmp84_ = _tmp83_;
		_tmp85_ = vala_ccode_constant_new (_tmp84_);
		_tmp86_ = _tmp85_;
		vala_ccode_function_call_add_argument (_tmp80_, (ValaCCodeExpression*) _tmp86_);
		_vala_ccode_node_unref0 (_tmp86_);
		_g_free0 (_tmp84_);
		_g_free0 (_tmp82_);
	} else {
		if (!disconnect) {
			ValaCCodeFunctionCall* _tmp87_;
			ValaCCodeExpression* _tmp88_;
			_tmp87_ = ccall;
			_tmp88_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp87_, _tmp88_);
		} else {
			ValaLocalVariable* temp_decl = NULL;
			ValaDataType* _tmp95_;
			ValaLocalVariable* _tmp96_;
			ValaLocalVariable* _tmp97_;
			ValaCCodeFunctionCall* parse_call = NULL;
			ValaCCodeIdentifier* _tmp98_;
			ValaCCodeIdentifier* _tmp99_;
			ValaCCodeFunctionCall* _tmp100_;
			ValaCCodeFunctionCall* _tmp101_;
			ValaCCodeFunctionCall* _tmp102_;
			ValaCCodeExpression* _tmp103_;
			ValaTypeSymbol* decl_type = NULL;
			ValaSymbol* _tmp104_;
			ValaSymbol* _tmp105_;
			ValaTypeSymbol* _tmp106_;
			ValaCCodeFunctionCall* _tmp107_;
			ValaTypeSymbol* _tmp108_;
			gchar* _tmp109_;
			gchar* _tmp110_;
			ValaCCodeIdentifier* _tmp111_;
			ValaCCodeIdentifier* _tmp112_;
			ValaCCodeFunctionCall* _tmp113_;
			ValaLocalVariable* _tmp114_;
			const gchar* _tmp115_;
			const gchar* _tmp116_;
			ValaCCodeExpression* _tmp117_;
			ValaCCodeExpression* _tmp118_;
			ValaCCodeUnaryExpression* _tmp119_;
			ValaCCodeUnaryExpression* _tmp120_;
			ValaLocalVariable* detail_temp_decl = NULL;
			ValaCCodeFunction* _tmp141_;
			ValaCCodeFunction* _tmp142_;
			ValaCCodeFunctionCall* _tmp143_;
			ValaCCodeFunctionCall* _tmp144_;
			ValaLocalVariable* _tmp145_;
			const gchar* _tmp146_;
			const gchar* _tmp147_;
			ValaCCodeExpression* _tmp148_;
			ValaCCodeExpression* _tmp149_;
			ValaLocalVariable* _tmp150_;
			ValaCCodeFunctionCall* _tmp160_;
			ValaCCodeConstant* _tmp161_;
			ValaCCodeConstant* _tmp162_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp89_;
				ValaCCodeConstant* _tmp90_;
				ValaCCodeConstant* _tmp91_;
				_tmp89_ = ccall;
				_tmp90_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA");
				_tmp91_ = _tmp90_;
				vala_ccode_function_call_add_argument (_tmp89_, (ValaCCodeExpression*) _tmp91_);
				_vala_ccode_node_unref0 (_tmp91_);
			} else {
				ValaCCodeFunctionCall* _tmp92_;
				ValaCCodeConstant* _tmp93_;
				ValaCCodeConstant* _tmp94_;
				_tmp92_ = ccall;
				_tmp93_ = vala_ccode_constant_new ("G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SI" \
"GNAL_MATCH_DATA");
				_tmp94_ = _tmp93_;
				vala_ccode_function_call_add_argument (_tmp92_, (ValaCCodeExpression*) _tmp94_);
				_vala_ccode_node_unref0 (_tmp94_);
			}
			_tmp95_ = ((ValaCCodeBaseModule*) self)->uint_type;
			_tmp96_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp95_, TRUE, NULL, FALSE);
			temp_decl = _tmp96_;
			_tmp97_ = temp_decl;
			vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp97_, FALSE);
			_tmp98_ = vala_ccode_identifier_new ("g_signal_parse_name");
			_tmp99_ = _tmp98_;
			_tmp100_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp99_);
			_tmp101_ = _tmp100_;
			_vala_ccode_node_unref0 (_tmp99_);
			parse_call = _tmp101_;
			_tmp102_ = parse_call;
			_tmp103_ = signal_name_cexpr;
			vala_ccode_function_call_add_argument (_tmp102_, _tmp103_);
			_tmp104_ = vala_symbol_get_parent_symbol ((ValaSymbol*) sig);
			_tmp105_ = _tmp104_;
			_tmp106_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp105_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			decl_type = _tmp106_;
			_tmp107_ = parse_call;
			_tmp108_ = decl_type;
			_tmp109_ = vala_get_ccode_type_id ((ValaCodeNode*) _tmp108_);
			_tmp110_ = _tmp109_;
			_tmp111_ = vala_ccode_identifier_new (_tmp110_);
			_tmp112_ = _tmp111_;
			vala_ccode_function_call_add_argument (_tmp107_, (ValaCCodeExpression*) _tmp112_);
			_vala_ccode_node_unref0 (_tmp112_);
			_g_free0 (_tmp110_);
			_tmp113_ = parse_call;
			_tmp114_ = temp_decl;
			_tmp115_ = vala_symbol_get_name ((ValaSymbol*) _tmp114_);
			_tmp116_ = _tmp115_;
			_tmp117_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp116_);
			_tmp118_ = _tmp117_;
			_tmp119_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp118_);
			_tmp120_ = _tmp119_;
			vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp120_);
			_vala_ccode_node_unref0 (_tmp120_);
			_vala_ccode_node_unref0 (_tmp118_);
			detail_temp_decl = NULL;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (signal_access, VALA_TYPE_ELEMENT_ACCESS)) {
				ValaCCodeFunctionCall* _tmp121_;
				ValaCCodeConstant* _tmp122_;
				ValaCCodeConstant* _tmp123_;
				ValaCCodeFunctionCall* _tmp124_;
				ValaCCodeConstant* _tmp125_;
				ValaCCodeConstant* _tmp126_;
				_tmp121_ = parse_call;
				_tmp122_ = vala_ccode_constant_new ("NULL");
				_tmp123_ = _tmp122_;
				vala_ccode_function_call_add_argument (_tmp121_, (ValaCCodeExpression*) _tmp123_);
				_vala_ccode_node_unref0 (_tmp123_);
				_tmp124_ = parse_call;
				_tmp125_ = vala_ccode_constant_new ("FALSE");
				_tmp126_ = _tmp125_;
				vala_ccode_function_call_add_argument (_tmp124_, (ValaCCodeExpression*) _tmp126_);
				_vala_ccode_node_unref0 (_tmp126_);
			} else {
				ValaDataType* _tmp127_;
				ValaLocalVariable* _tmp128_;
				ValaLocalVariable* _tmp129_;
				ValaCCodeFunctionCall* _tmp130_;
				ValaLocalVariable* _tmp131_;
				const gchar* _tmp132_;
				const gchar* _tmp133_;
				ValaCCodeExpression* _tmp134_;
				ValaCCodeExpression* _tmp135_;
				ValaCCodeUnaryExpression* _tmp136_;
				ValaCCodeUnaryExpression* _tmp137_;
				ValaCCodeFunctionCall* _tmp138_;
				ValaCCodeConstant* _tmp139_;
				ValaCCodeConstant* _tmp140_;
				_tmp127_ = ((ValaCCodeBaseModule*) self)->gquark_type;
				_tmp128_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp127_, TRUE, NULL, FALSE);
				_vala_code_node_unref0 (detail_temp_decl);
				detail_temp_decl = _tmp128_;
				_tmp129_ = detail_temp_decl;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp129_, FALSE);
				_tmp130_ = parse_call;
				_tmp131_ = detail_temp_decl;
				_tmp132_ = vala_symbol_get_name ((ValaSymbol*) _tmp131_);
				_tmp133_ = _tmp132_;
				_tmp134_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp135_);
				_tmp137_ = _tmp136_;
				vala_ccode_function_call_add_argument (_tmp130_, (ValaCCodeExpression*) _tmp137_);
				_vala_ccode_node_unref0 (_tmp137_);
				_vala_ccode_node_unref0 (_tmp135_);
				_tmp138_ = parse_call;
				_tmp139_ = vala_ccode_constant_new ("TRUE");
				_tmp140_ = _tmp139_;
				vala_ccode_function_call_add_argument (_tmp138_, (ValaCCodeExpression*) _tmp140_);
				_vala_ccode_node_unref0 (_tmp140_);
			}
			_tmp141_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp142_ = _tmp141_;
			_tmp143_ = parse_call;
			vala_ccode_function_add_expression (_tmp142_, (ValaCCodeExpression*) _tmp143_);
			_tmp144_ = ccall;
			_tmp145_ = temp_decl;
			_tmp146_ = vala_symbol_get_name ((ValaSymbol*) _tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp147_);
			_tmp149_ = _tmp148_;
			vala_ccode_function_call_add_argument (_tmp144_, _tmp149_);
			_vala_ccode_node_unref0 (_tmp149_);
			_tmp150_ = detail_temp_decl;
			if (_tmp150_ == NULL) {
				ValaCCodeFunctionCall* _tmp151_;
				ValaCCodeConstant* _tmp152_;
				ValaCCodeConstant* _tmp153_;
				_tmp151_ = ccall;
				_tmp152_ = vala_ccode_constant_new ("0");
				_tmp153_ = _tmp152_;
				vala_ccode_function_call_add_argument (_tmp151_, (ValaCCodeExpression*) _tmp153_);
				_vala_ccode_node_unref0 (_tmp153_);
			} else {
				ValaCCodeFunctionCall* _tmp154_;
				ValaLocalVariable* _tmp155_;
				const gchar* _tmp156_;
				const gchar* _tmp157_;
				ValaCCodeExpression* _tmp158_;
				ValaCCodeExpression* _tmp159_;
				_tmp154_ = ccall;
				_tmp155_ = detail_temp_decl;
				_tmp156_ = vala_symbol_get_name ((ValaSymbol*) _tmp155_);
				_tmp157_ = _tmp156_;
				_tmp158_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp157_);
				_tmp159_ = _tmp158_;
				vala_ccode_function_call_add_argument (_tmp154_, _tmp159_);
				_vala_ccode_node_unref0 (_tmp159_);
			}
			_tmp160_ = ccall;
			_tmp161_ = vala_ccode_constant_new ("NULL");
			_tmp162_ = _tmp161_;
			vala_ccode_function_call_add_argument (_tmp160_, (ValaCCodeExpression*) _tmp162_);
			_vala_ccode_node_unref0 (_tmp162_);
			_vala_code_node_unref0 (detail_temp_decl);
			_vala_code_node_unref0 (decl_type);
			_vala_ccode_node_unref0 (parse_call);
			_vala_code_node_unref0 (temp_decl);
		}
	}
	_tmp163_ = ccall;
	_tmp164_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, handler);
	_tmp165_ = _tmp164_;
	_tmp166_ = vala_ccode_cast_expression_new (_tmp165_, "GCallback");
	_tmp167_ = _tmp166_;
	vala_ccode_function_call_add_argument (_tmp163_, (ValaCCodeExpression*) _tmp167_);
	_vala_ccode_node_unref0 (_tmp167_);
	_vala_ccode_node_unref0 (_tmp165_);
	_tmp169_ = m;
	if (_tmp169_ != NULL) {
		ValaMethod* _tmp170_;
		gboolean _tmp171_;
		gboolean _tmp172_;
		_tmp170_ = m;
		_tmp171_ = vala_method_get_closure (_tmp170_);
		_tmp172_ = _tmp171_;
		_tmp168_ = _tmp172_;
	} else {
		_tmp168_ = FALSE;
	}
	if (_tmp168_) {
		ValaCCodeExpression* handler_destroy_notify = NULL;
		ValaCCodeFunctionCall* _tmp173_;
		ValaCCodeExpression* _tmp174_ = NULL;
		ValaCCodeExpression* _tmp175_;
		ValaCCodeExpression* _tmp176_;
		ValaCCodeFunctionCall* _tmp177_;
		ValaCCodeExpression* _tmp178_;
		ValaCCodeCastExpression* _tmp179_;
		ValaCCodeCastExpression* _tmp180_;
		_tmp173_ = ccall;
		_tmp175_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp174_);
		_vala_ccode_node_unref0 (handler_destroy_notify);
		handler_destroy_notify = _tmp174_;
		_tmp176_ = _tmp175_;
		vala_ccode_function_call_add_argument (_tmp173_, _tmp176_);
		_vala_ccode_node_unref0 (_tmp176_);
		_tmp177_ = ccall;
		_tmp178_ = handler_destroy_notify;
		_tmp179_ = vala_ccode_cast_expression_new (_tmp178_, "GClosureNotify");
		_tmp180_ = _tmp179_;
		vala_ccode_function_call_add_argument (_tmp177_, (ValaCCodeExpression*) _tmp180_);
		_vala_ccode_node_unref0 (_tmp180_);
		if (!after) {
			ValaCCodeFunctionCall* _tmp181_;
			ValaCCodeConstant* _tmp182_;
			ValaCCodeConstant* _tmp183_;
			_tmp181_ = ccall;
			_tmp182_ = vala_ccode_constant_new ("0");
			_tmp183_ = _tmp182_;
			vala_ccode_function_call_add_argument (_tmp181_, (ValaCCodeExpression*) _tmp183_);
			_vala_ccode_node_unref0 (_tmp183_);
		} else {
			ValaCCodeFunctionCall* _tmp184_;
			ValaCCodeConstant* _tmp185_;
			ValaCCodeConstant* _tmp186_;
			_tmp184_ = ccall;
			_tmp185_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
			_tmp186_ = _tmp185_;
			vala_ccode_function_call_add_argument (_tmp184_, (ValaCCodeExpression*) _tmp186_);
			_vala_ccode_node_unref0 (_tmp186_);
		}
		_vala_ccode_node_unref0 (handler_destroy_notify);
	} else {
		gboolean _tmp187_ = FALSE;
		ValaMethod* _tmp188_;
		_tmp188_ = m;
		if (_tmp188_ != NULL) {
			ValaMethod* _tmp189_;
			ValaMemberBinding _tmp190_;
			ValaMemberBinding _tmp191_;
			_tmp189_ = m;
			_tmp190_ = vala_method_get_binding (_tmp189_);
			_tmp191_ = _tmp190_;
			_tmp187_ = _tmp191_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp187_ = FALSE;
		}
		if (_tmp187_) {
			gboolean _tmp208_ = FALSE;
			gboolean _tmp209_ = FALSE;
			if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_MEMBER_ACCESS)) {
				ValaMemberAccess* right_ma = NULL;
				ValaMemberAccess* _tmp192_;
				ValaMemberAccess* _tmp193_;
				ValaExpression* _tmp194_;
				ValaExpression* _tmp195_;
				_tmp192_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (handler, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				right_ma = _tmp192_;
				_tmp193_ = right_ma;
				_tmp194_ = vala_member_access_get_inner (_tmp193_);
				_tmp195_ = _tmp194_;
				if (_tmp195_ != NULL) {
					ValaCCodeFunctionCall* _tmp196_;
					ValaMemberAccess* _tmp197_;
					ValaExpression* _tmp198_;
					ValaExpression* _tmp199_;
					ValaCCodeExpression* _tmp200_;
					ValaCCodeExpression* _tmp201_;
					_tmp196_ = ccall;
					_tmp197_ = right_ma;
					_tmp198_ = vala_member_access_get_inner (_tmp197_);
					_tmp199_ = _tmp198_;
					_tmp200_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp199_);
					_tmp201_ = _tmp200_;
					vala_ccode_function_call_add_argument (_tmp196_, _tmp201_);
					_vala_ccode_node_unref0 (_tmp201_);
				} else {
					ValaCCodeFunctionCall* _tmp202_;
					ValaCCodeExpression* _tmp203_;
					ValaCCodeExpression* _tmp204_;
					_tmp202_ = ccall;
					_tmp203_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp204_ = _tmp203_;
					vala_ccode_function_call_add_argument (_tmp202_, _tmp204_);
					_vala_ccode_node_unref0 (_tmp204_);
				}
				_vala_code_node_unref0 (right_ma);
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (handler, VALA_TYPE_LAMBDA_EXPRESSION)) {
					ValaCCodeFunctionCall* _tmp205_;
					ValaCCodeExpression* _tmp206_;
					ValaCCodeExpression* _tmp207_;
					_tmp205_ = ccall;
					_tmp206_ = vala_ccode_base_module_get_result_cexpression ((ValaCCodeBaseModule*) self, "self");
					_tmp207_ = _tmp206_;
					vala_ccode_function_call_add_argument (_tmp205_, _tmp207_);
					_vala_ccode_node_unref0 (_tmp207_);
				}
			}
			if (!disconnect) {
				_tmp209_ = !G_TYPE_CHECK_INSTANCE_TYPE (sig, VALA_TYPE_DYNAMIC_SIGNAL);
			} else {
				_tmp209_ = FALSE;
			}
			if (_tmp209_) {
				ValaMethod* _tmp210_;
				_tmp210_ = m;
				_tmp208_ = vala_gsignal_module_in_gobject_instance (self, _tmp210_);
			} else {
				_tmp208_ = FALSE;
			}
			if (_tmp208_) {
				if (!after) {
					ValaCCodeFunctionCall* _tmp211_;
					ValaCCodeConstant* _tmp212_;
					ValaCCodeConstant* _tmp213_;
					_tmp211_ = ccall;
					_tmp212_ = vala_ccode_constant_new ("0");
					_tmp213_ = _tmp212_;
					vala_ccode_function_call_add_argument (_tmp211_, (ValaCCodeExpression*) _tmp213_);
					_vala_ccode_node_unref0 (_tmp213_);
				} else {
					ValaCCodeFunctionCall* _tmp214_;
					ValaCCodeConstant* _tmp215_;
					ValaCCodeConstant* _tmp216_;
					_tmp214_ = ccall;
					_tmp215_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
					_tmp216_ = _tmp215_;
					vala_ccode_function_call_add_argument (_tmp214_, (ValaCCodeExpression*) _tmp216_);
					_vala_ccode_node_unref0 (_tmp216_);
				}
			}
		} else {
			gboolean _tmp217_ = FALSE;
			ValaDelegateType* _tmp218_;
			_tmp218_ = dt;
			if (_tmp218_ != NULL) {
				ValaDelegateType* _tmp219_;
				ValaDelegate* _tmp220_;
				ValaDelegate* _tmp221_;
				gboolean _tmp222_;
				gboolean _tmp223_;
				_tmp219_ = dt;
				_tmp220_ = vala_delegate_type_get_delegate_symbol (_tmp219_);
				_tmp221_ = _tmp220_;
				_tmp222_ = vala_delegate_get_has_target (_tmp221_);
				_tmp223_ = _tmp222_;
				_tmp217_ = _tmp223_;
			} else {
				_tmp217_ = FALSE;
			}
			if (_tmp217_) {
				ValaCCodeExpression* handler_destroy_notify = NULL;
				ValaCCodeFunctionCall* _tmp224_;
				ValaCCodeExpression* _tmp225_ = NULL;
				ValaCCodeExpression* _tmp226_;
				ValaCCodeExpression* _tmp227_;
				gboolean _tmp228_ = FALSE;
				_tmp224_ = ccall;
				_tmp226_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, handler, &_tmp225_);
				_vala_ccode_node_unref0 (handler_destroy_notify);
				handler_destroy_notify = _tmp225_;
				_tmp227_ = _tmp226_;
				vala_ccode_function_call_add_argument (_tmp224_, _tmp227_);
				_vala_ccode_node_unref0 (_tmp227_);
				if (!disconnect) {
					ValaDelegateType* _tmp229_;
					gboolean _tmp230_;
					gboolean _tmp231_;
					_tmp229_ = dt;
					_tmp230_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp229_);
					_tmp231_ = _tmp230_;
					_tmp228_ = _tmp231_;
				} else {
					_tmp228_ = FALSE;
				}
				if (_tmp228_) {
					ValaCCodeFunctionCall* _tmp232_;
					ValaCCodeExpression* _tmp233_;
					ValaCCodeCastExpression* _tmp234_;
					ValaCCodeCastExpression* _tmp235_;
					_tmp232_ = ccall;
					_tmp233_ = handler_destroy_notify;
					_tmp234_ = vala_ccode_cast_expression_new (_tmp233_, "GClosureNotify");
					_tmp235_ = _tmp234_;
					vala_ccode_function_call_add_argument (_tmp232_, (ValaCCodeExpression*) _tmp235_);
					_vala_ccode_node_unref0 (_tmp235_);
					if (!after) {
						ValaCCodeFunctionCall* _tmp236_;
						ValaCCodeConstant* _tmp237_;
						ValaCCodeConstant* _tmp238_;
						_tmp236_ = ccall;
						_tmp237_ = vala_ccode_constant_new ("0");
						_tmp238_ = _tmp237_;
						vala_ccode_function_call_add_argument (_tmp236_, (ValaCCodeExpression*) _tmp238_);
						_vala_ccode_node_unref0 (_tmp238_);
					} else {
						ValaCCodeFunctionCall* _tmp239_;
						ValaCCodeConstant* _tmp240_;
						ValaCCodeConstant* _tmp241_;
						_tmp239_ = ccall;
						_tmp240_ = vala_ccode_constant_new ("G_CONNECT_AFTER");
						_tmp241_ = _tmp240_;
						vala_ccode_function_call_add_argument (_tmp239_, (ValaCCodeExpression*) _tmp241_);
						_vala_ccode_node_unref0 (_tmp241_);
					}
				}
				_vala_ccode_node_unref0 (handler_destroy_notify);
			} else {
				ValaCCodeFunctionCall* _tmp242_;
				ValaCCodeConstant* _tmp243_;
				ValaCCodeConstant* _tmp244_;
				_tmp242_ = ccall;
				_tmp243_ = vala_ccode_constant_new ("NULL");
				_tmp244_ = _tmp243_;
				vala_ccode_function_call_add_argument (_tmp242_, (ValaCCodeExpression*) _tmp244_);
				_vala_ccode_node_unref0 (_tmp244_);
			}
		}
	}
	if (disconnect) {
		_tmp245_ = TRUE;
	} else {
		ValaCodeNode* _tmp246_;
		ValaCodeNode* _tmp247_;
		_tmp246_ = vala_code_node_get_parent_node (expr);
		_tmp247_ = _tmp246_;
		_tmp245_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp247_, VALA_TYPE_EXPRESSION_STATEMENT);
	}
	if (_tmp245_) {
		ValaCCodeFunction* _tmp248_;
		ValaCCodeFunction* _tmp249_;
		ValaCCodeFunctionCall* _tmp250_;
		_tmp248_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp249_ = _tmp248_;
		_tmp250_ = ccall;
		vala_ccode_function_add_expression (_tmp249_, (ValaCCodeExpression*) _tmp250_);
		result = NULL;
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	} else {
		ValaLocalVariable* temp_var = NULL;
		ValaDataType* _tmp251_;
		ValaLocalVariable* _tmp252_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp253_;
		const gchar* _tmp254_;
		const gchar* _tmp255_;
		ValaCCodeExpression* _tmp256_;
		ValaLocalVariable* _tmp257_;
		ValaCCodeFunction* _tmp258_;
		ValaCCodeFunction* _tmp259_;
		ValaCCodeExpression* _tmp260_;
		ValaCCodeFunctionCall* _tmp261_;
		_tmp251_ = ((ValaCCodeBaseModule*) self)->ulong_type;
		_tmp252_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp251_, TRUE, NULL, FALSE);
		temp_var = _tmp252_;
		_tmp253_ = temp_var;
		_tmp254_ = vala_symbol_get_name ((ValaSymbol*) _tmp253_);
		_tmp255_ = _tmp254_;
		_tmp256_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp255_);
		temp_ref = _tmp256_;
		_tmp257_ = temp_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp257_, FALSE);
		_tmp258_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp259_ = _tmp258_;
		_tmp260_ = temp_ref;
		_tmp261_ = ccall;
		vala_ccode_function_add_assignment (_tmp259_, _tmp260_, (ValaCCodeExpression*) _tmp261_);
		result = temp_ref;
		_vala_code_node_unref0 (temp_var);
		_vala_code_node_unref0 (ma);
		_vala_ccode_node_unref0 (signal_name_cexpr);
		_vala_ccode_node_unref0 (ccall);
		_vala_code_node_unref0 (m);
		_vala_code_node_unref0 (dt);
		_g_free0 (connect_func);
		return result;
	}
	_vala_code_node_unref0 (ma);
	_vala_ccode_node_unref0 (signal_name_cexpr);
	_vala_ccode_node_unref0 (ccall);
	_vala_code_node_unref0 (m);
	_vala_code_node_unref0 (dt);
	_g_free0 (connect_func);
}


ValaGSignalModule*
vala_gsignal_module_construct (GType object_type)
{
	ValaGSignalModule* self = NULL;
	self = (ValaGSignalModule*) vala_gobject_module_construct (object_type);
	return self;
}


ValaGSignalModule*
vala_gsignal_module_new (void)
{
	return vala_gsignal_module_construct (VALA_TYPE_GSIGNAL_MODULE);
}


static void
vala_gsignal_module_class_init (ValaGSignalModuleClass * klass)
{
	vala_gsignal_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_signal = (void (*) (ValaCodeVisitor*, ValaSignal*)) vala_gsignal_module_real_visit_signal;
	((ValaCCodeBaseModuleClass *) klass)->get_signal_creation = (ValaCCodeExpression* (*) (ValaCCodeBaseModule*, ValaSignal*, ValaTypeSymbol*)) vala_gsignal_module_real_get_signal_creation;
	((ValaCodeVisitorClass *) klass)->visit_element_access = (void (*) (ValaCodeVisitor*, ValaElementAccess*)) vala_gsignal_module_real_visit_element_access;
	((ValaCodeVisitorClass *) klass)->visit_assignment = (void (*) (ValaCodeVisitor*, ValaAssignment*)) vala_gsignal_module_real_visit_assignment;
	((ValaCodeVisitorClass *) klass)->visit_member_access = (void (*) (ValaCodeVisitor*, ValaMemberAccess*)) vala_gsignal_module_real_visit_member_access;
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_gsignal_module_real_visit_method_call;
}


static void
vala_gsignal_module_instance_init (ValaGSignalModule * self)
{
}


GType
vala_gsignal_module_get_type (void)
{
	static volatile gsize vala_gsignal_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gsignal_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGSignalModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gsignal_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGSignalModule), 0, (GInstanceInitFunc) vala_gsignal_module_instance_init, NULL };
		GType vala_gsignal_module_type_id;
		vala_gsignal_module_type_id = g_type_register_static (VALA_TYPE_GOBJECT_MODULE, "ValaGSignalModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gsignal_module_type_id__volatile, vala_gsignal_module_type_id);
	}
	return vala_gsignal_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



