/* valagerrormodule.c generated by valac, the Vala compiler
 * generated from valagerrormodule.vala, do not modify */

/* valagerrormodule.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Jürg Billeter <j@bitron.ch>
 *	Thijs Vermeir <thijsvermeir@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))

struct _ValaGErrorModulePrivate {
	gint current_try_id;
	gint next_try_id;
	gboolean is_in_catch;
};


static gpointer vala_gerror_module_parent_class = NULL;

#define VALA_GERROR_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GERROR_MODULE, ValaGErrorModulePrivate))
static void vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                                ValaErrorDomain* edomain,
                                                                ValaCCodeFile* decl_space);
static void vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static void vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                                    ValaCCodeExpression* error_expr);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                                  ValaCCodeExpression* inner_error,
                                                  gboolean unexpected,
                                                  ValaCodeNode* start_at);
static gboolean vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                              ValaCodeNode* node);
static void vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                               ValaCodeNode* node,
                                               gboolean always_fails);
static void vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static void vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                                 ValaCatchClause* clause);
static void vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                                ValaSymbol* sym,
                                                ValaCodeNode* stop_at);
static void vala_gerror_module_finalize (ValaCodeVisitor * obj);


static void
vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                           ValaErrorDomain* edomain,
                                                           ValaCCodeFile* decl_space)
{
	ValaGErrorModule * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	ValaCCodeEnum* cenum = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaCCodeEnum* _tmp5_;
	ValaCCodeEnum* _tmp6_;
	ValaCCodeEnum* _tmp39_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	ValaCCodeMacroReplacement* error_domain_define = NULL;
	gchar* _tmp44_;
	gchar* _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	ValaCCodeMacroReplacement* _tmp49_;
	ValaCCodeMacroReplacement* _tmp50_;
	ValaCCodeMacroReplacement* _tmp51_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp52_;
	ValaDataType* _tmp53_;
	ValaTypeSymbol* _tmp54_;
	ValaTypeSymbol* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	ValaCCodeFunction* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_add_symbol_declaration ((ValaCCodeBaseModule*) self, decl_space, (ValaSymbol*) edomain, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_ccode_enum_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	cenum = _tmp6_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp7_;
		gint _ecode_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _ecode_index = 0;
		_tmp7_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp7_;
		_tmp8_ = _ecode_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_ecode_size = _tmp10_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaErrorCode* _tmp16_;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			_ecode_index = _ecode_index + 1;
			_tmp11_ = _ecode_index;
			_tmp12_ = _ecode_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _ecode_list;
			_tmp14_ = _ecode_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			ecode = (ValaErrorCode*) _tmp15_;
			_tmp16_ = ecode;
			_tmp17_ = vala_error_code_get_value (_tmp16_);
			_tmp18_ = _tmp17_;
			if (_tmp18_ == NULL) {
				ValaCCodeEnum* _tmp19_;
				ValaErrorCode* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				ValaCCodeEnumValue* _tmp23_;
				ValaCCodeEnumValue* _tmp24_;
				_tmp19_ = cenum;
				_tmp20_ = ecode;
				_tmp21_ = vala_get_ccode_name ((ValaCodeNode*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = vala_ccode_enum_value_new (_tmp22_, NULL);
				_tmp24_ = _tmp23_;
				vala_ccode_enum_add_value (_tmp19_, _tmp24_);
				_vala_ccode_node_unref0 (_tmp24_);
				_g_free0 (_tmp22_);
			} else {
				ValaErrorCode* _tmp25_;
				ValaExpression* _tmp26_;
				ValaExpression* _tmp27_;
				ValaCCodeEnum* _tmp28_;
				ValaErrorCode* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				ValaErrorCode* _tmp32_;
				ValaExpression* _tmp33_;
				ValaExpression* _tmp34_;
				ValaCCodeExpression* _tmp35_;
				ValaCCodeExpression* _tmp36_;
				ValaCCodeEnumValue* _tmp37_;
				ValaCCodeEnumValue* _tmp38_;
				_tmp25_ = ecode;
				_tmp26_ = vala_error_code_get_value (_tmp25_);
				_tmp27_ = _tmp26_;
				vala_code_node_emit ((ValaCodeNode*) _tmp27_, (ValaCodeGenerator*) self);
				_tmp28_ = cenum;
				_tmp29_ = ecode;
				_tmp30_ = vala_get_ccode_name ((ValaCodeNode*) _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = ecode;
				_tmp33_ = vala_error_code_get_value (_tmp32_);
				_tmp34_ = _tmp33_;
				_tmp35_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp34_);
				_tmp36_ = _tmp35_;
				_tmp37_ = vala_ccode_enum_value_new (_tmp31_, _tmp36_);
				_tmp38_ = _tmp37_;
				vala_ccode_enum_add_value (_tmp28_, _tmp38_);
				_vala_ccode_node_unref0 (_tmp38_);
				_vala_ccode_node_unref0 (_tmp36_);
				_g_free0 (_tmp31_);
			}
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp39_ = cenum;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp39_);
	_tmp40_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp41_ = _tmp40_;
	_tmp42_ = g_strconcat (_tmp41_, "quark", NULL);
	_tmp43_ = _tmp42_;
	_g_free0 (_tmp41_);
	quark_fun_name = _tmp43_;
	_tmp44_ = vala_get_ccode_upper_case_name ((ValaSymbol*) edomain, NULL);
	_tmp45_ = _tmp44_;
	_tmp46_ = quark_fun_name;
	_tmp47_ = g_strconcat (_tmp46_, " ()", NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = vala_ccode_macro_replacement_new (_tmp45_, _tmp48_);
	_tmp50_ = _tmp49_;
	_g_free0 (_tmp48_);
	_g_free0 (_tmp45_);
	error_domain_define = _tmp50_;
	_tmp51_ = error_domain_define;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp51_);
	_tmp52_ = quark_fun_name;
	_tmp53_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp54_ = vala_data_type_get_data_type (_tmp53_);
	_tmp55_ = _tmp54_;
	_tmp56_ = vala_get_ccode_name ((ValaCodeNode*) _tmp55_);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_ccode_function_new (_tmp52_, _tmp57_);
	_tmp59_ = _tmp58_;
	_g_free0 (_tmp57_);
	cquark_fun = _tmp59_;
	_tmp60_ = cquark_fun;
	vala_ccode_file_add_function_declaration (decl_space, _tmp60_);
	_vala_ccode_node_unref0 (cquark_fun);
	_vala_ccode_node_unref0 (error_domain_define);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (cenum);
}


static void
vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGErrorModule * self;
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	ValaCCodeFile* _tmp9_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValaCCodeFunction* cquark_fun = NULL;
	ValaDataType* _tmp16_;
	ValaTypeSymbol* _tmp17_;
	ValaTypeSymbol* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* cquark_call = NULL;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeConstant* _tmp33_;
	ValaCCodeConstant* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	ValaCCodeFile* _tmp37_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaCCodeFile* _tmp2_;
		ValaComment* _tmp3_;
		ValaComment* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValaCCodeComment* _tmp7_;
		ValaCCodeComment* _tmp8_;
		_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp3_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_comment_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_comment_new (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_ccode_file_add_type_definition (_tmp2_, (ValaCCodeNode*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
	}
	_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp9_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp10_;
		_tmp10_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp10_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp11_;
		_tmp11_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp11_);
	}
	vala_code_node_accept_children ((ValaCodeNode*) edomain, (ValaCodeVisitor*) self);
	_tmp12_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "quark", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	quark_fun_name = _tmp15_;
	_tmp16_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp17_ = vala_data_type_get_data_type (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_get_ccode_name ((ValaCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_function_new (quark_fun_name, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	cquark_fun = _tmp22_;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, cquark_fun);
	_tmp23_ = vala_ccode_identifier_new ("g_quark_from_static_string");
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp24_);
	_tmp26_ = _tmp25_;
	_vala_ccode_node_unref0 (_tmp24_);
	cquark_call = _tmp26_;
	_tmp27_ = vala_get_ccode_quark_name (edomain);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat ("\"", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "\"", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_constant_new (_tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_call_add_argument (cquark_call, (ValaCCodeExpression*) _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) cquark_call);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp37_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function (_tmp37_, cquark_fun);
	_vala_ccode_node_unref0 (cquark_call);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
}


static void
vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaGErrorModule * self;
	ValaCCodeFunction* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCCodeExpression* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_throw_statement_get_error_expression (stmt);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_assignment (_tmp1_, _tmp3_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                               ValaCCodeExpression* error_expr)
{
	ValaCCodeFunctionCall* cpropagate = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	gboolean _tmp13_ = FALSE;
	ValaMethod* _tmp14_;
	ValaMethod* _tmp15_;
	g_return_if_fail (error_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_propagate_error");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cpropagate = _tmp3_;
	_tmp4_ = cpropagate;
	_tmp5_ = vala_ccode_identifier_new ("error");
	_tmp6_ = _tmp5_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp6_);
	_vala_ccode_node_unref0 (_tmp6_);
	_tmp7_ = cpropagate;
	vala_ccode_function_call_add_argument (_tmp7_, error_expr);
	_tmp8_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = cpropagate;
	vala_ccode_function_add_expression (_tmp9_, (ValaCCodeExpression*) _tmp10_);
	_tmp11_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
	_tmp12_ = _tmp11_;
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp12_, NULL, NULL);
	_tmp14_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		_tmp16_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_CLASS);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaClass* cl = NULL;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaClass* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaClass* _tmp27_;
		ValaObjectType* _tmp28_;
		ValaObjectType* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaGLibValue* _tmp32_;
		ValaGLibValue* _tmp33_;
		ValaCCodeExpression* _tmp34_;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeFunction* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeConstant* _tmp38_;
		ValaCCodeConstant* _tmp39_;
		_tmp20_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp24_;
		_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = cl;
		_tmp28_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new ("self");
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_glib_value_new ((ValaDataType*) _tmp29_, (ValaCCodeExpression*) _tmp31_, TRUE);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp33_, FALSE);
		_tmp35_ = _tmp34_;
		vala_ccode_function_add_expression (_tmp26_, _tmp35_);
		_vala_ccode_node_unref0 (_tmp35_);
		_vala_target_value_unref0 (_tmp33_);
		_vala_ccode_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp29_);
		_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_ccode_constant_new ("NULL");
		_tmp39_ = _tmp38_;
		vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp39_);
		_vala_ccode_node_unref0 (_tmp39_);
		_vala_code_node_unref0 (cl);
	} else {
		if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
			ValaCCodeFunction* _tmp40_;
			ValaCCodeFunction* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new ("FALSE");
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp41_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
		} else {
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			_tmp44_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
			_tmp45_ = _tmp44_;
			vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp45_, TRUE);
		}
	}
	_vala_ccode_node_unref0 (cpropagate);
}


void
vala_gerror_module_return_with_exception (ValaGErrorModule* self,
                                          ValaCCodeExpression* error_expr)
{
	g_return_if_fail (self != NULL);
	VALA_GERROR_MODULE_GET_CLASS (self)->return_with_exception (self, error_expr);
}


static void
vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                             ValaCCodeExpression* inner_error,
                                             gboolean unexpected,
                                             ValaCodeNode* start_at)
{
	ValaCCodeFunctionCall* ccritical = NULL;
	ValaCCodeIdentifier* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeFunctionCall* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	const gchar* _tmp8_ = NULL;
	ValaCCodeFunctionCall* _tmp9_;
	ValaCCodeConstant* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeFunctionCall* _tmp12_;
	ValaCCodeConstant* _tmp13_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeFunctionCall* _tmp15_;
	ValaCCodeConstant* _tmp16_;
	ValaCCodeConstant* _tmp17_;
	ValaCCodeFunctionCall* _tmp18_;
	ValaCCodeMemberAccess* _tmp19_;
	ValaCCodeMemberAccess* _tmp20_;
	ValaCCodeFunctionCall* domain_name = NULL;
	ValaCCodeIdentifier* _tmp21_;
	ValaCCodeIdentifier* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeFunctionCall* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeMemberAccess* _tmp26_;
	ValaCCodeMemberAccess* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeFunctionCall* _tmp29_;
	ValaCCodeFunctionCall* _tmp30_;
	ValaCCodeMemberAccess* _tmp31_;
	ValaCCodeMemberAccess* _tmp32_;
	ValaCCodeFunctionCall* cclear = NULL;
	ValaCCodeIdentifier* _tmp33_;
	ValaCCodeIdentifier* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeFunctionCall* _tmp36_;
	ValaCCodeFunctionCall* _tmp37_;
	ValaCCodeUnaryExpression* _tmp38_;
	ValaCCodeUnaryExpression* _tmp39_;
	ValaCCodeFunction* _tmp40_;
	ValaCCodeFunction* _tmp41_;
	ValaCCodeFunctionCall* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeFunction* _tmp44_;
	ValaCCodeFunctionCall* _tmp45_;
	gboolean _tmp46_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inner_error != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (start_at, VALA_TYPE_TRY_STATEMENT)) {
		ValaCodeNode* _tmp0_;
		ValaCodeNode* _tmp1_;
		_tmp0_ = vala_code_node_get_parent_node (start_at);
		_tmp1_ = _tmp0_;
		vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, (ValaSymbol*) (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp1_) : NULL), NULL, NULL);
	} else {
		ValaSymbol* _tmp2_;
		ValaSymbol* _tmp3_;
		_tmp2_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
		_tmp3_ = _tmp2_;
		vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp3_, NULL, NULL);
	}
	_tmp4_ = vala_ccode_identifier_new ("g_critical");
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp5_);
	_tmp7_ = _tmp6_;
	_vala_ccode_node_unref0 (_tmp5_);
	ccritical = _tmp7_;
	if (unexpected) {
		_tmp8_ = "\"file %s: line %d: unexpected error: %s (%s, %d)\"";
	} else {
		_tmp8_ = "\"file %s: line %d: uncaught error: %s (%s, %d)\"";
	}
	_tmp9_ = ccritical;
	_tmp10_ = vala_ccode_constant_new (_tmp8_);
	_tmp11_ = _tmp10_;
	vala_ccode_function_call_add_argument (_tmp9_, (ValaCCodeExpression*) _tmp11_);
	_vala_ccode_node_unref0 (_tmp11_);
	_tmp12_ = ccritical;
	_tmp13_ = vala_ccode_constant_new ("__FILE__");
	_tmp14_ = _tmp13_;
	vala_ccode_function_call_add_argument (_tmp12_, (ValaCCodeExpression*) _tmp14_);
	_vala_ccode_node_unref0 (_tmp14_);
	_tmp15_ = ccritical;
	_tmp16_ = vala_ccode_constant_new ("__LINE__");
	_tmp17_ = _tmp16_;
	vala_ccode_function_call_add_argument (_tmp15_, (ValaCCodeExpression*) _tmp17_);
	_vala_ccode_node_unref0 (_tmp17_);
	_tmp18_ = ccritical;
	_tmp19_ = vala_ccode_member_access_new_pointer (inner_error, "message");
	_tmp20_ = _tmp19_;
	vala_ccode_function_call_add_argument (_tmp18_, (ValaCCodeExpression*) _tmp20_);
	_vala_ccode_node_unref0 (_tmp20_);
	_tmp21_ = vala_ccode_identifier_new ("g_quark_to_string");
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp22_);
	_tmp24_ = _tmp23_;
	_vala_ccode_node_unref0 (_tmp22_);
	domain_name = _tmp24_;
	_tmp25_ = domain_name;
	_tmp26_ = vala_ccode_member_access_new_pointer (inner_error, "domain");
	_tmp27_ = _tmp26_;
	vala_ccode_function_call_add_argument (_tmp25_, (ValaCCodeExpression*) _tmp27_);
	_vala_ccode_node_unref0 (_tmp27_);
	_tmp28_ = ccritical;
	_tmp29_ = domain_name;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp29_);
	_tmp30_ = ccritical;
	_tmp31_ = vala_ccode_member_access_new_pointer (inner_error, "code");
	_tmp32_ = _tmp31_;
	vala_ccode_function_call_add_argument (_tmp30_, (ValaCCodeExpression*) _tmp32_);
	_vala_ccode_node_unref0 (_tmp32_);
	_tmp33_ = vala_ccode_identifier_new ("g_clear_error");
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp34_);
	_tmp36_ = _tmp35_;
	_vala_ccode_node_unref0 (_tmp34_);
	cclear = _tmp36_;
	_tmp37_ = cclear;
	_tmp38_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, inner_error);
	_tmp39_ = _tmp38_;
	vala_ccode_function_call_add_argument (_tmp37_, (ValaCCodeExpression*) _tmp39_);
	_vala_ccode_node_unref0 (_tmp39_);
	_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp41_ = _tmp40_;
	_tmp42_ = ccritical;
	vala_ccode_function_add_expression (_tmp41_, (ValaCCodeExpression*) _tmp42_);
	_tmp43_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp44_ = _tmp43_;
	_tmp45_ = cclear;
	vala_ccode_function_add_expression (_tmp44_, (ValaCCodeExpression*) _tmp45_);
	if (vala_ccode_base_module_is_in_constructor ((ValaCCodeBaseModule*) self)) {
		_tmp46_ = TRUE;
	} else {
		_tmp46_ = vala_ccode_base_module_is_in_destructor ((ValaCCodeBaseModule*) self);
	}
	if (_tmp46_) {
	} else {
		ValaMethod* _tmp47_;
		ValaMethod* _tmp48_;
		_tmp47_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp48_ = _tmp47_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp49_;
			ValaMethod* _tmp50_;
			ValaSymbol* _tmp51_;
			ValaSymbol* _tmp52_;
			_tmp49_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp50_);
			_tmp52_ = _tmp51_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp52_, VALA_TYPE_STRUCT)) {
				ValaCCodeFunction* _tmp53_;
				ValaCCodeFunction* _tmp54_;
				_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp54_ = _tmp53_;
				vala_ccode_function_add_return (_tmp54_, NULL);
			} else {
				ValaCCodeFunction* _tmp55_;
				ValaCCodeFunction* _tmp56_;
				ValaCCodeConstant* _tmp57_;
				ValaCCodeConstant* _tmp58_;
				_tmp55_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp56_ = _tmp55_;
				_tmp57_ = vala_ccode_constant_new ("NULL");
				_tmp58_ = _tmp57_;
				vala_ccode_function_add_return (_tmp56_, (ValaCCodeExpression*) _tmp58_);
				_vala_ccode_node_unref0 (_tmp58_);
			}
		} else {
			if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
				ValaCCodeMemberAccess* async_result_expr = NULL;
				ValaCCodeIdentifier* _tmp59_;
				ValaCCodeIdentifier* _tmp60_;
				ValaCCodeMemberAccess* _tmp61_;
				ValaCCodeMemberAccess* _tmp62_;
				ValaCCodeFunctionCall* unref = NULL;
				ValaCCodeIdentifier* _tmp63_;
				ValaCCodeIdentifier* _tmp64_;
				ValaCCodeFunctionCall* _tmp65_;
				ValaCCodeFunctionCall* _tmp66_;
				ValaCCodeFunctionCall* _tmp67_;
				ValaCCodeMemberAccess* _tmp68_;
				ValaCCodeFunction* _tmp69_;
				ValaCCodeFunction* _tmp70_;
				ValaCCodeFunctionCall* _tmp71_;
				ValaCCodeFunction* _tmp72_;
				ValaCCodeFunction* _tmp73_;
				ValaCCodeConstant* _tmp74_;
				ValaCCodeConstant* _tmp75_;
				_tmp59_ = vala_ccode_identifier_new ("_data_");
				_tmp60_ = _tmp59_;
				_tmp61_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp60_, "_async_result");
				_tmp62_ = _tmp61_;
				_vala_ccode_node_unref0 (_tmp60_);
				async_result_expr = _tmp62_;
				_tmp63_ = vala_ccode_identifier_new ("g_object_unref");
				_tmp64_ = _tmp63_;
				_tmp65_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp64_);
				_tmp66_ = _tmp65_;
				_vala_ccode_node_unref0 (_tmp64_);
				unref = _tmp66_;
				_tmp67_ = unref;
				_tmp68_ = async_result_expr;
				vala_ccode_function_call_add_argument (_tmp67_, (ValaCCodeExpression*) _tmp68_);
				_tmp69_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp70_ = _tmp69_;
				_tmp71_ = unref;
				vala_ccode_function_add_expression (_tmp70_, (ValaCCodeExpression*) _tmp71_);
				_tmp72_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_ccode_constant_new ("FALSE");
				_tmp75_ = _tmp74_;
				vala_ccode_function_add_return (_tmp73_, (ValaCCodeExpression*) _tmp75_);
				_vala_ccode_node_unref0 (_tmp75_);
				_vala_ccode_node_unref0 (unref);
				_vala_ccode_node_unref0 (async_result_expr);
			} else {
				ValaDataType* _tmp76_;
				ValaDataType* _tmp77_;
				_tmp76_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
				_tmp77_ = _tmp76_;
				if (_tmp77_ != NULL) {
					ValaDataType* _tmp78_;
					ValaDataType* _tmp79_;
					_tmp78_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
					_tmp79_ = _tmp78_;
					vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp79_, TRUE);
				}
			}
		}
	}
	_vala_ccode_node_unref0 (cclear);
	_vala_ccode_node_unref0 (domain_name);
	_vala_ccode_node_unref0 (ccritical);
}


static gboolean
vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                     ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCodeNode* current_node = NULL;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (node);
	current_node = _tmp0_;
	while (TRUE) {
		ValaCodeNode* _tmp1_;
		ValaTryStatement* try_stmt = NULL;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaTryStatement* _tmp5_;
		gboolean _tmp6_ = FALSE;
		ValaTryStatement* _tmp7_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		_tmp1_ = current_node;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = current_node;
		_tmp3_ = vala_code_node_get_parent_node (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_TRY_STATEMENT) ? ((ValaTryStatement*) _tmp4_) : NULL);
		try_stmt = _tmp5_;
		_tmp7_ = try_stmt;
		if (_tmp7_ != NULL) {
			ValaTryStatement* _tmp8_;
			ValaBlock* _tmp9_;
			ValaBlock* _tmp10_;
			ValaCodeNode* _tmp11_;
			_tmp8_ = try_stmt;
			_tmp9_ = vala_try_statement_get_finally_body (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = current_node;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp11_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			_vala_code_node_unref0 (try_stmt);
			_vala_code_node_unref0 (current_node);
			return result;
		}
		_tmp12_ = current_node;
		_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _vala_code_node_ref0 (_tmp14_);
		_vala_code_node_unref0 (current_node);
		current_node = _tmp15_;
		_vala_code_node_unref0 (try_stmt);
	}
	result = FALSE;
	_vala_code_node_unref0 (current_node);
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void
vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                          ValaCodeNode* node,
                                          gboolean always_fails)
{
	ValaGErrorModule * self;
	ValaTryStatement* _tmp15_;
	ValaTryStatement* _tmp16_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (node != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	if (always_fails) {
	} else {
		ValaCCodeBinaryExpression* ccond = NULL;
		ValaCCodeExpression* _tmp0_;
		ValaCCodeExpression* _tmp1_;
		ValaCCodeConstant* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeBinaryExpression* _tmp4_;
		ValaCCodeBinaryExpression* _tmp5_;
		ValaCCodeFunctionCall* unlikely = NULL;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeBinaryExpression* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		ValaCCodeFunction* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		_tmp0_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_ccode_constant_new ("NULL");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp1_, (ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		_vala_ccode_node_unref0 (_tmp1_);
		ccond = _tmp5_;
		_tmp6_ = vala_ccode_identifier_new ("G_UNLIKELY");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
		unlikely = _tmp9_;
		_tmp10_ = unlikely;
		_tmp11_ = ccond;
		vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp11_);
		_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = unlikely;
		vala_ccode_function_open_if (_tmp13_, (ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (unlikely);
		_vala_ccode_node_unref0 (ccond);
	}
	_tmp15_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		gboolean _tmp17_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp26_;
		ValaArrayList* _tmp27_;
		gboolean has_general_catch_clause = FALSE;
		gboolean _tmp39_;
		gboolean _tmp153_;
		_tmp17_ = self->priv->is_in_catch;
		if (_tmp17_) {
			ValaSymbol* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaCatchClause* _tmp20_;
			ValaCatchClause* _tmp21_;
			_tmp18_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
			_tmp21_ = _tmp20_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp19_, NULL, (ValaCodeNode*) _tmp21_);
		} else {
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			ValaTryStatement* _tmp24_;
			ValaTryStatement* _tmp25_;
			_tmp22_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
			_tmp25_ = _tmp24_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp23_, NULL, (ValaCodeNode*) _tmp25_);
		}
		_tmp26_ = g_direct_equal;
		_tmp27_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp26_);
		error_types = _tmp27_;
		{
			ValaList* _node_error_type_list = NULL;
			ValaList* _tmp28_;
			gint _node_error_type_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _node_error_type_index = 0;
			_tmp28_ = vala_code_node_get_error_types (node);
			_node_error_type_list = _tmp28_;
			_tmp29_ = _node_error_type_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_node_error_type_size = _tmp31_;
			_node_error_type_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				ValaDataType* node_error_type = NULL;
				ValaList* _tmp34_;
				gint _tmp35_;
				gpointer _tmp36_;
				ValaArrayList* _tmp37_;
				ValaDataType* _tmp38_;
				_node_error_type_index = _node_error_type_index + 1;
				_tmp32_ = _node_error_type_index;
				_tmp33_ = _node_error_type_size;
				if (!(_tmp32_ < _tmp33_)) {
					break;
				}
				_tmp34_ = _node_error_type_list;
				_tmp35_ = _node_error_type_index;
				_tmp36_ = vala_list_get (_tmp34_, _tmp35_);
				node_error_type = (ValaDataType*) _tmp36_;
				_tmp37_ = error_types;
				_tmp38_ = node_error_type;
				vala_collection_add ((ValaCollection*) _tmp37_, _tmp38_);
				_vala_code_node_unref0 (node_error_type);
			}
			_vala_iterable_unref0 (_node_error_type_list);
		}
		has_general_catch_clause = FALSE;
		_tmp39_ = self->priv->is_in_catch;
		if (!_tmp39_) {
			ValaArrayList* handled_error_types = NULL;
			GEqualFunc _tmp40_;
			ValaArrayList* _tmp41_;
			_tmp40_ = g_direct_equal;
			_tmp41_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp40_);
			handled_error_types = _tmp41_;
			{
				ValaList* _clause_list = NULL;
				ValaTryStatement* _tmp42_;
				ValaTryStatement* _tmp43_;
				ValaList* _tmp44_;
				gint _clause_size = 0;
				ValaList* _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _clause_index = 0;
				_tmp42_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
				_tmp43_ = _tmp42_;
				_tmp44_ = vala_try_statement_get_catch_clauses (_tmp43_);
				_clause_list = _tmp44_;
				_tmp45_ = _clause_list;
				_tmp46_ = vala_collection_get_size ((ValaCollection*) _tmp45_);
				_tmp47_ = _tmp46_;
				_clause_size = _tmp47_;
				_clause_index = -1;
				while (TRUE) {
					gint _tmp48_;
					gint _tmp49_;
					ValaCatchClause* clause = NULL;
					ValaList* _tmp50_;
					gint _tmp51_;
					gpointer _tmp52_;
					ValaArrayList* _tmp85_;
					ValaCatchClause* _tmp86_;
					ValaDataType* _tmp87_;
					ValaDataType* _tmp88_;
					ValaErrorType* _tmp89_;
					_clause_index = _clause_index + 1;
					_tmp48_ = _clause_index;
					_tmp49_ = _clause_size;
					if (!(_tmp48_ < _tmp49_)) {
						break;
					}
					_tmp50_ = _clause_list;
					_tmp51_ = _clause_index;
					_tmp52_ = vala_list_get (_tmp50_, _tmp51_);
					clause = (ValaCatchClause*) _tmp52_;
					{
						ValaArrayList* _node_error_type_list = NULL;
						ValaArrayList* _tmp53_;
						ValaArrayList* _tmp54_;
						gint _node_error_type_size = 0;
						ValaArrayList* _tmp55_;
						gint _tmp56_;
						gint _tmp57_;
						gint _node_error_type_index = 0;
						_tmp53_ = error_types;
						_tmp54_ = _vala_iterable_ref0 (_tmp53_);
						_node_error_type_list = _tmp54_;
						_tmp55_ = _node_error_type_list;
						_tmp56_ = vala_collection_get_size ((ValaCollection*) _tmp55_);
						_tmp57_ = _tmp56_;
						_node_error_type_size = _tmp57_;
						_node_error_type_index = -1;
						while (TRUE) {
							gint _tmp58_;
							gint _tmp59_;
							ValaDataType* node_error_type = NULL;
							ValaArrayList* _tmp60_;
							gint _tmp61_;
							gpointer _tmp62_;
							gboolean _tmp63_ = FALSE;
							ValaCatchClause* _tmp64_;
							ValaDataType* _tmp65_;
							ValaDataType* _tmp66_;
							_node_error_type_index = _node_error_type_index + 1;
							_tmp58_ = _node_error_type_index;
							_tmp59_ = _node_error_type_size;
							if (!(_tmp58_ < _tmp59_)) {
								break;
							}
							_tmp60_ = _node_error_type_list;
							_tmp61_ = _node_error_type_index;
							_tmp62_ = vala_list_get ((ValaList*) _tmp60_, _tmp61_);
							node_error_type = (ValaDataType*) _tmp62_;
							_tmp64_ = clause;
							_tmp65_ = vala_catch_clause_get_error_type (_tmp64_);
							_tmp66_ = _tmp65_;
							if (_tmp66_ == NULL) {
								_tmp63_ = TRUE;
							} else {
								ValaDataType* _tmp67_;
								ValaCatchClause* _tmp68_;
								ValaDataType* _tmp69_;
								ValaDataType* _tmp70_;
								_tmp67_ = node_error_type;
								_tmp68_ = clause;
								_tmp69_ = vala_catch_clause_get_error_type (_tmp68_);
								_tmp70_ = _tmp69_;
								_tmp63_ = vala_data_type_compatible (_tmp67_, _tmp70_);
							}
							if (_tmp63_) {
								ValaArrayList* _tmp71_;
								ValaDataType* _tmp72_;
								_tmp71_ = handled_error_types;
								_tmp72_ = node_error_type;
								vala_collection_add ((ValaCollection*) _tmp71_, _tmp72_);
							}
							_vala_code_node_unref0 (node_error_type);
						}
						_vala_iterable_unref0 (_node_error_type_list);
					}
					{
						ValaArrayList* _handled_error_type_list = NULL;
						ValaArrayList* _tmp73_;
						ValaArrayList* _tmp74_;
						gint _handled_error_type_size = 0;
						ValaArrayList* _tmp75_;
						gint _tmp76_;
						gint _tmp77_;
						gint _handled_error_type_index = 0;
						_tmp73_ = handled_error_types;
						_tmp74_ = _vala_iterable_ref0 (_tmp73_);
						_handled_error_type_list = _tmp74_;
						_tmp75_ = _handled_error_type_list;
						_tmp76_ = vala_collection_get_size ((ValaCollection*) _tmp75_);
						_tmp77_ = _tmp76_;
						_handled_error_type_size = _tmp77_;
						_handled_error_type_index = -1;
						while (TRUE) {
							gint _tmp78_;
							gint _tmp79_;
							ValaDataType* handled_error_type = NULL;
							ValaArrayList* _tmp80_;
							gint _tmp81_;
							gpointer _tmp82_;
							ValaArrayList* _tmp83_;
							ValaDataType* _tmp84_;
							_handled_error_type_index = _handled_error_type_index + 1;
							_tmp78_ = _handled_error_type_index;
							_tmp79_ = _handled_error_type_size;
							if (!(_tmp78_ < _tmp79_)) {
								break;
							}
							_tmp80_ = _handled_error_type_list;
							_tmp81_ = _handled_error_type_index;
							_tmp82_ = vala_list_get ((ValaList*) _tmp80_, _tmp81_);
							handled_error_type = (ValaDataType*) _tmp82_;
							_tmp83_ = error_types;
							_tmp84_ = handled_error_type;
							vala_collection_remove ((ValaCollection*) _tmp83_, _tmp84_);
							_vala_code_node_unref0 (handled_error_type);
						}
						_vala_iterable_unref0 (_handled_error_type_list);
					}
					_tmp85_ = handled_error_types;
					vala_collection_clear ((ValaCollection*) _tmp85_);
					_tmp86_ = clause;
					_tmp87_ = vala_catch_clause_get_error_type (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp88_, (ValaDataType*) _tmp89_)) {
						ValaCCodeFunction* _tmp90_;
						ValaCCodeFunction* _tmp91_;
						ValaCatchClause* _tmp92_;
						const gchar* _tmp93_;
						const gchar* _tmp94_;
						has_general_catch_clause = TRUE;
						_tmp90_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp91_ = _tmp90_;
						_tmp92_ = clause;
						_tmp93_ = vala_catch_clause_get_clabel_name (_tmp92_);
						_tmp94_ = _tmp93_;
						vala_ccode_function_add_goto (_tmp91_, _tmp94_);
						_vala_code_node_unref0 (clause);
						break;
					} else {
						ValaErrorType* catch_type = NULL;
						ValaCatchClause* _tmp95_;
						ValaDataType* _tmp96_;
						ValaDataType* _tmp97_;
						ValaErrorType* _tmp98_;
						ValaErrorType* _tmp99_;
						ValaErrorCode* _tmp100_;
						ValaErrorCode* _tmp101_;
						ValaCCodeFunction* _tmp146_;
						ValaCCodeFunction* _tmp147_;
						ValaCatchClause* _tmp148_;
						const gchar* _tmp149_;
						const gchar* _tmp150_;
						ValaCCodeFunction* _tmp151_;
						ValaCCodeFunction* _tmp152_;
						_tmp95_ = clause;
						_tmp96_ = vala_catch_clause_get_error_type (_tmp95_);
						_tmp97_ = _tmp96_;
						_tmp98_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_ERROR_TYPE) ? ((ValaErrorType*) _tmp97_) : NULL);
						catch_type = _tmp98_;
						_tmp99_ = catch_type;
						_tmp100_ = vala_error_type_get_error_code (_tmp99_);
						_tmp101_ = _tmp100_;
						if (_tmp101_ != NULL) {
							ValaCCodeFunctionCall* error_match = NULL;
							ValaCCodeIdentifier* _tmp102_;
							ValaCCodeIdentifier* _tmp103_;
							ValaCCodeFunctionCall* _tmp104_;
							ValaCCodeFunctionCall* _tmp105_;
							ValaCCodeFunctionCall* _tmp106_;
							ValaCCodeExpression* _tmp107_;
							ValaCCodeExpression* _tmp108_;
							ValaCCodeFunctionCall* _tmp109_;
							ValaErrorType* _tmp110_;
							ValaTypeSymbol* _tmp111_;
							ValaTypeSymbol* _tmp112_;
							gchar* _tmp113_;
							gchar* _tmp114_;
							ValaCCodeIdentifier* _tmp115_;
							ValaCCodeIdentifier* _tmp116_;
							ValaCCodeFunctionCall* _tmp117_;
							ValaErrorType* _tmp118_;
							ValaErrorCode* _tmp119_;
							ValaErrorCode* _tmp120_;
							gchar* _tmp121_;
							gchar* _tmp122_;
							ValaCCodeIdentifier* _tmp123_;
							ValaCCodeIdentifier* _tmp124_;
							ValaCCodeFunction* _tmp125_;
							ValaCCodeFunction* _tmp126_;
							ValaCCodeFunctionCall* _tmp127_;
							_tmp102_ = vala_ccode_identifier_new ("g_error_matches");
							_tmp103_ = _tmp102_;
							_tmp104_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp103_);
							_tmp105_ = _tmp104_;
							_vala_ccode_node_unref0 (_tmp103_);
							error_match = _tmp105_;
							_tmp106_ = error_match;
							_tmp107_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
							_tmp108_ = _tmp107_;
							vala_ccode_function_call_add_argument (_tmp106_, _tmp108_);
							_vala_ccode_node_unref0 (_tmp108_);
							_tmp109_ = error_match;
							_tmp110_ = catch_type;
							_tmp111_ = vala_data_type_get_data_type ((ValaDataType*) _tmp110_);
							_tmp112_ = _tmp111_;
							_tmp113_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp112_, NULL);
							_tmp114_ = _tmp113_;
							_tmp115_ = vala_ccode_identifier_new (_tmp114_);
							_tmp116_ = _tmp115_;
							vala_ccode_function_call_add_argument (_tmp109_, (ValaCCodeExpression*) _tmp116_);
							_vala_ccode_node_unref0 (_tmp116_);
							_g_free0 (_tmp114_);
							_tmp117_ = error_match;
							_tmp118_ = catch_type;
							_tmp119_ = vala_error_type_get_error_code (_tmp118_);
							_tmp120_ = _tmp119_;
							_tmp121_ = vala_get_ccode_name ((ValaCodeNode*) _tmp120_);
							_tmp122_ = _tmp121_;
							_tmp123_ = vala_ccode_identifier_new (_tmp122_);
							_tmp124_ = _tmp123_;
							vala_ccode_function_call_add_argument (_tmp117_, (ValaCCodeExpression*) _tmp124_);
							_vala_ccode_node_unref0 (_tmp124_);
							_g_free0 (_tmp122_);
							_tmp125_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp126_ = _tmp125_;
							_tmp127_ = error_match;
							vala_ccode_function_open_if (_tmp126_, (ValaCCodeExpression*) _tmp127_);
							_vala_ccode_node_unref0 (error_match);
						} else {
							ValaCCodeBinaryExpression* ccond = NULL;
							ValaCCodeExpression* _tmp128_;
							ValaCCodeExpression* _tmp129_;
							ValaCCodeMemberAccess* _tmp130_;
							ValaCCodeMemberAccess* _tmp131_;
							ValaCatchClause* _tmp132_;
							ValaDataType* _tmp133_;
							ValaDataType* _tmp134_;
							ValaTypeSymbol* _tmp135_;
							ValaTypeSymbol* _tmp136_;
							gchar* _tmp137_;
							gchar* _tmp138_;
							ValaCCodeIdentifier* _tmp139_;
							ValaCCodeIdentifier* _tmp140_;
							ValaCCodeBinaryExpression* _tmp141_;
							ValaCCodeBinaryExpression* _tmp142_;
							ValaCCodeFunction* _tmp143_;
							ValaCCodeFunction* _tmp144_;
							ValaCCodeBinaryExpression* _tmp145_;
							_tmp128_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
							_tmp129_ = _tmp128_;
							_tmp130_ = vala_ccode_member_access_new_pointer (_tmp129_, "domain");
							_tmp131_ = _tmp130_;
							_tmp132_ = clause;
							_tmp133_ = vala_catch_clause_get_error_type (_tmp132_);
							_tmp134_ = _tmp133_;
							_tmp135_ = vala_data_type_get_data_type (_tmp134_);
							_tmp136_ = _tmp135_;
							_tmp137_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp136_, NULL);
							_tmp138_ = _tmp137_;
							_tmp139_ = vala_ccode_identifier_new (_tmp138_);
							_tmp140_ = _tmp139_;
							_tmp141_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp131_, (ValaCCodeExpression*) _tmp140_);
							_tmp142_ = _tmp141_;
							_vala_ccode_node_unref0 (_tmp140_);
							_g_free0 (_tmp138_);
							_vala_ccode_node_unref0 (_tmp131_);
							_vala_ccode_node_unref0 (_tmp129_);
							ccond = _tmp142_;
							_tmp143_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp144_ = _tmp143_;
							_tmp145_ = ccond;
							vala_ccode_function_open_if (_tmp144_, (ValaCCodeExpression*) _tmp145_);
							_vala_ccode_node_unref0 (ccond);
						}
						_tmp146_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp147_ = _tmp146_;
						_tmp148_ = clause;
						_tmp149_ = vala_catch_clause_get_clabel_name (_tmp148_);
						_tmp150_ = _tmp149_;
						vala_ccode_function_add_goto (_tmp147_, _tmp150_);
						_tmp151_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp152_ = _tmp151_;
						vala_ccode_function_close (_tmp152_);
						_vala_code_node_unref0 (catch_type);
					}
					_vala_code_node_unref0 (clause);
				}
				_vala_iterable_unref0 (_clause_list);
			}
			_vala_iterable_unref0 (handled_error_types);
		}
		_tmp153_ = has_general_catch_clause;
		if (_tmp153_) {
		} else {
			ValaArrayList* _tmp154_;
			gint _tmp155_;
			gint _tmp156_;
			_tmp154_ = error_types;
			_tmp155_ = vala_collection_get_size ((ValaCollection*) _tmp154_);
			_tmp156_ = _tmp155_;
			if (_tmp156_ > 0) {
				ValaCCodeFunction* _tmp157_;
				ValaCCodeFunction* _tmp158_;
				gint _tmp159_;
				gchar* _tmp160_;
				gchar* _tmp161_;
				_tmp157_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp158_ = _tmp157_;
				_tmp159_ = self->priv->current_try_id;
				_tmp160_ = g_strdup_printf ("__finally%d", _tmp159_);
				_tmp161_ = _tmp160_;
				vala_ccode_function_add_goto (_tmp158_, _tmp161_);
				_g_free0 (_tmp161_);
			} else {
				if (vala_gerror_module_in_finally_block (self, node)) {
				} else {
					ValaCCodeExpression* _tmp162_;
					ValaCCodeExpression* _tmp163_;
					ValaTryStatement* _tmp164_;
					ValaTryStatement* _tmp165_;
					_tmp162_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
					_tmp163_ = _tmp162_;
					_tmp164_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
					_tmp165_ = _tmp164_;
					vala_gerror_module_uncaught_error_statement (self, _tmp163_, TRUE, (ValaCodeNode*) _tmp165_);
					_vala_ccode_node_unref0 (_tmp163_);
				}
			}
		}
		_vala_iterable_unref0 (error_types);
	} else {
		gboolean _tmp166_ = FALSE;
		ValaMethod* _tmp167_;
		ValaMethod* _tmp168_;
		_tmp167_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp168_ = _tmp167_;
		if (_tmp168_ != NULL) {
			ValaMethod* _tmp169_;
			ValaMethod* _tmp170_;
			ValaList* _tmp171_;
			ValaList* _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			_tmp169_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp170_ = _tmp169_;
			_tmp171_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp170_);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_collection_get_size ((ValaCollection*) _tmp172_);
			_tmp174_ = _tmp173_;
			_tmp166_ = _tmp174_ > 0;
			_vala_iterable_unref0 (_tmp172_);
		} else {
			_tmp166_ = FALSE;
		}
		if (_tmp166_) {
			ValaCCodeBinaryExpression* ccond = NULL;
			ValaCCodeBinaryExpression* _tmp207_;
			ccond = NULL;
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp175_;
				ValaMethod* _tmp176_;
				ValaList* _tmp177_;
				gint _error_type_size = 0;
				ValaList* _tmp178_;
				gint _tmp179_;
				gint _tmp180_;
				gint _error_type_index = 0;
				_tmp175_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp176_);
				_error_type_list = _tmp177_;
				_tmp178_ = _error_type_list;
				_tmp179_ = vala_collection_get_size ((ValaCollection*) _tmp178_);
				_tmp180_ = _tmp179_;
				_error_type_size = _tmp180_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp181_;
					gint _tmp182_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp183_;
					gint _tmp184_;
					gpointer _tmp185_;
					ValaDataType* _tmp186_;
					ValaErrorType* _tmp187_;
					ValaCCodeBinaryExpression* domain_check = NULL;
					ValaCCodeExpression* _tmp188_;
					ValaCCodeExpression* _tmp189_;
					ValaCCodeMemberAccess* _tmp190_;
					ValaCCodeMemberAccess* _tmp191_;
					ValaDataType* _tmp192_;
					ValaTypeSymbol* _tmp193_;
					ValaTypeSymbol* _tmp194_;
					gchar* _tmp195_;
					gchar* _tmp196_;
					ValaCCodeIdentifier* _tmp197_;
					ValaCCodeIdentifier* _tmp198_;
					ValaCCodeBinaryExpression* _tmp199_;
					ValaCCodeBinaryExpression* _tmp200_;
					ValaCCodeBinaryExpression* _tmp201_;
					_error_type_index = _error_type_index + 1;
					_tmp181_ = _error_type_index;
					_tmp182_ = _error_type_size;
					if (!(_tmp181_ < _tmp182_)) {
						break;
					}
					_tmp183_ = _error_type_list;
					_tmp184_ = _error_type_index;
					_tmp185_ = vala_list_get (_tmp183_, _tmp184_);
					error_type = (ValaDataType*) _tmp185_;
					_tmp186_ = error_type;
					_tmp187_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp186_, (ValaDataType*) _tmp187_)) {
						_vala_ccode_node_unref0 (ccond);
						ccond = NULL;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp188_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
					_tmp189_ = _tmp188_;
					_tmp190_ = vala_ccode_member_access_new_pointer (_tmp189_, "domain");
					_tmp191_ = _tmp190_;
					_tmp192_ = error_type;
					_tmp193_ = vala_data_type_get_data_type (_tmp192_);
					_tmp194_ = _tmp193_;
					_tmp195_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp194_, NULL);
					_tmp196_ = _tmp195_;
					_tmp197_ = vala_ccode_identifier_new (_tmp196_);
					_tmp198_ = _tmp197_;
					_tmp199_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp191_, (ValaCCodeExpression*) _tmp198_);
					_tmp200_ = _tmp199_;
					_vala_ccode_node_unref0 (_tmp198_);
					_g_free0 (_tmp196_);
					_vala_ccode_node_unref0 (_tmp191_);
					_vala_ccode_node_unref0 (_tmp189_);
					domain_check = _tmp200_;
					_tmp201_ = ccond;
					if (_tmp201_ == NULL) {
						ValaCCodeBinaryExpression* _tmp202_;
						ValaCCodeBinaryExpression* _tmp203_;
						_tmp202_ = domain_check;
						_tmp203_ = _vala_ccode_node_ref0 (_tmp202_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp203_;
					} else {
						ValaCCodeBinaryExpression* _tmp204_;
						ValaCCodeBinaryExpression* _tmp205_;
						ValaCCodeBinaryExpression* _tmp206_;
						_tmp204_ = ccond;
						_tmp205_ = domain_check;
						_tmp206_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) _tmp204_, (ValaCCodeExpression*) _tmp205_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp206_;
					}
					_vala_ccode_node_unref0 (domain_check);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_tmp207_ = ccond;
			if (_tmp207_ != NULL) {
				ValaCCodeFunction* _tmp208_;
				ValaCCodeFunction* _tmp209_;
				ValaCCodeBinaryExpression* _tmp210_;
				ValaCCodeExpression* _tmp211_;
				ValaCCodeExpression* _tmp212_;
				ValaCCodeFunction* _tmp213_;
				ValaCCodeFunction* _tmp214_;
				ValaCCodeExpression* _tmp215_;
				ValaCCodeExpression* _tmp216_;
				ValaCCodeFunction* _tmp217_;
				ValaCCodeFunction* _tmp218_;
				_tmp208_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp209_ = _tmp208_;
				_tmp210_ = ccond;
				vala_ccode_function_open_if (_tmp209_, (ValaCCodeExpression*) _tmp210_);
				_tmp211_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp212_ = _tmp211_;
				vala_gerror_module_return_with_exception (self, _tmp212_);
				_vala_ccode_node_unref0 (_tmp212_);
				_tmp213_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp214_ = _tmp213_;
				vala_ccode_function_add_else (_tmp214_);
				_tmp215_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp216_ = _tmp215_;
				vala_gerror_module_uncaught_error_statement (self, _tmp216_, FALSE, NULL);
				_vala_ccode_node_unref0 (_tmp216_);
				_tmp217_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp218_ = _tmp217_;
				vala_ccode_function_close (_tmp218_);
			} else {
				ValaCCodeExpression* _tmp219_;
				ValaCCodeExpression* _tmp220_;
				_tmp219_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp220_ = _tmp219_;
				vala_gerror_module_return_with_exception (self, _tmp220_);
				_vala_ccode_node_unref0 (_tmp220_);
			}
			_vala_ccode_node_unref0 (ccond);
		} else {
			ValaCCodeExpression* _tmp221_;
			ValaCCodeExpression* _tmp222_;
			_tmp221_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
			_tmp222_ = _tmp221_;
			vala_gerror_module_uncaught_error_statement (self, _tmp222_, FALSE, NULL);
			_vala_ccode_node_unref0 (_tmp222_);
		}
	}
	if (!always_fails) {
		ValaCCodeFunction* _tmp223_;
		ValaCCodeFunction* _tmp224_;
		_tmp223_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp224_ = _tmp223_;
		vala_ccode_function_close (_tmp224_);
	}
}


static void
vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaGErrorModule * self;
	gint this_try_id = 0;
	gint _tmp0_;
	ValaTryStatement* old_try = NULL;
	ValaTryStatement* _tmp1_;
	ValaTryStatement* _tmp2_;
	ValaTryStatement* _tmp3_;
	gint old_try_id = 0;
	gint _tmp4_;
	gboolean old_is_in_catch = FALSE;
	gboolean _tmp5_;
	ValaCatchClause* old_catch = NULL;
	ValaCatchClause* _tmp6_;
	ValaCatchClause* _tmp7_;
	ValaCatchClause* _tmp8_;
	gint _tmp9_;
	ValaBlock* _tmp28_;
	ValaBlock* _tmp29_;
	ValaTryStatement* _tmp46_;
	gint _tmp47_;
	gboolean _tmp48_;
	ValaCatchClause* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	gint _tmp52_;
	gchar* _tmp53_;
	gchar* _tmp54_;
	ValaBlock* _tmp55_;
	ValaBlock* _tmp56_;
	gboolean _tmp63_;
	gboolean _tmp64_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = self->priv->next_try_id;
	self->priv->next_try_id = _tmp0_ + 1;
	this_try_id = _tmp0_;
	_tmp1_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	old_try = _tmp3_;
	_tmp4_ = self->priv->current_try_id;
	old_try_id = _tmp4_;
	_tmp5_ = self->priv->is_in_catch;
	old_is_in_catch = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	old_catch = _tmp8_;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, stmt);
	_tmp9_ = this_try_id;
	self->priv->current_try_id = _tmp9_;
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp10_;
		gint _clause_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _clause_index = 0;
		_tmp10_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp10_;
		_tmp11_ = _clause_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_clause_size = _tmp13_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaCatchClause* _tmp19_;
			gint _tmp20_;
			ValaCatchClause* _tmp21_;
			ValaDataType* _tmp22_;
			ValaDataType* _tmp23_;
			gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			_clause_index = _clause_index + 1;
			_tmp14_ = _clause_index;
			_tmp15_ = _clause_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _clause_list;
			_tmp17_ = _clause_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			clause = (ValaCatchClause*) _tmp18_;
			_tmp19_ = clause;
			_tmp20_ = this_try_id;
			_tmp21_ = clause;
			_tmp22_ = vala_catch_clause_get_error_type (_tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp23_, NULL);
			_tmp25_ = _tmp24_;
			_tmp26_ = g_strdup_printf ("__catch%d_%s", _tmp20_, _tmp25_);
			_tmp27_ = _tmp26_;
			vala_catch_clause_set_clabel_name (_tmp19_, _tmp27_);
			_g_free0 (_tmp27_);
			_g_free0 (_tmp25_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	self->priv->is_in_catch = FALSE;
	_tmp28_ = vala_try_statement_get_body (stmt);
	_tmp29_ = _tmp28_;
	vala_code_node_emit ((ValaCodeNode*) _tmp29_, (ValaCodeGenerator*) self);
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp30_;
		gint _clause_size = 0;
		ValaList* _tmp31_;
		gint _tmp32_;
		gint _tmp33_;
		gint _clause_index = 0;
		_tmp30_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp30_;
		_tmp31_ = _clause_list;
		_tmp32_ = vala_collection_get_size ((ValaCollection*) _tmp31_);
		_tmp33_ = _tmp32_;
		_clause_size = _tmp33_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp34_;
			gint _tmp35_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp36_;
			gint _tmp37_;
			gpointer _tmp38_;
			ValaCatchClause* _tmp39_;
			ValaCCodeFunction* _tmp40_;
			ValaCCodeFunction* _tmp41_;
			gint _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			ValaCatchClause* _tmp45_;
			_clause_index = _clause_index + 1;
			_tmp34_ = _clause_index;
			_tmp35_ = _clause_size;
			if (!(_tmp34_ < _tmp35_)) {
				break;
			}
			_tmp36_ = _clause_list;
			_tmp37_ = _clause_index;
			_tmp38_ = vala_list_get (_tmp36_, _tmp37_);
			clause = (ValaCatchClause*) _tmp38_;
			_tmp39_ = clause;
			vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp39_);
			_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp41_ = _tmp40_;
			_tmp42_ = this_try_id;
			_tmp43_ = g_strdup_printf ("__finally%d", _tmp42_);
			_tmp44_ = _tmp43_;
			vala_ccode_function_add_goto (_tmp41_, _tmp44_);
			_g_free0 (_tmp44_);
			_tmp45_ = clause;
			vala_code_node_emit ((ValaCodeNode*) _tmp45_, (ValaCodeGenerator*) self);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp46_ = old_try;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, _tmp46_);
	_tmp47_ = old_try_id;
	self->priv->current_try_id = _tmp47_;
	_tmp48_ = old_is_in_catch;
	self->priv->is_in_catch = _tmp48_;
	_tmp49_ = old_catch;
	vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = this_try_id;
	_tmp53_ = g_strdup_printf ("__finally%d", _tmp52_);
	_tmp54_ = _tmp53_;
	vala_ccode_function_add_label (_tmp51_, _tmp54_);
	_g_free0 (_tmp54_);
	_tmp55_ = vala_try_statement_get_finally_body (stmt);
	_tmp56_ = _tmp55_;
	if (_tmp56_ != NULL) {
		gint _tmp57_;
		gint _tmp58_;
		ValaBlock* _tmp59_;
		ValaBlock* _tmp60_;
		gint _tmp61_;
		gint _tmp62_;
		_tmp57_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
		_tmp58_ = _tmp57_;
		vala_ccode_base_module_set_current_inner_error_id ((ValaCCodeBaseModule*) self, _tmp58_ + 1);
		_tmp59_ = vala_try_statement_get_finally_body (stmt);
		_tmp60_ = _tmp59_;
		vala_code_node_emit ((ValaCodeNode*) _tmp60_, (ValaCodeGenerator*) self);
		_tmp61_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
		_tmp62_ = _tmp61_;
		vala_ccode_base_module_set_current_inner_error_id ((ValaCCodeBaseModule*) self, _tmp62_ - 1);
	}
	_tmp63_ = vala_try_statement_get_after_try_block_reachable (stmt);
	_tmp64_ = _tmp63_;
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, !_tmp64_);
	_vala_code_node_unref0 (old_catch);
	_vala_code_node_unref0 (old_try);
}


static void
vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                            ValaCatchClause* clause)
{
	ValaGErrorModule * self;
	ValaErrorType* error_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaErrorType* _tmp2_;
	ValaErrorType* _tmp3_;
	ValaErrorDomain* _tmp4_;
	ValaErrorDomain* _tmp5_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaLocalVariable* _tmp16_;
	ValaLocalVariable* _tmp17_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeExpression* _tmp44_;
	ValaCCodeExpression* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (clause != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_catch_clause_get_error_type (clause);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
	error_type = _tmp2_;
	_tmp3_ = error_type;
	_tmp4_ = vala_error_type_get_error_domain (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaErrorType* _tmp6_;
		ValaErrorDomain* _tmp7_;
		ValaErrorDomain* _tmp8_;
		ValaCCodeFile* _tmp9_;
		_tmp6_ = error_type;
		_tmp7_ = vala_error_type_get_error_domain (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, _tmp8_, _tmp9_);
	}
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_catch_clause_get_clabel_name (clause);
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_label (_tmp11_, _tmp13_);
	_tmp14_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	vala_ccode_function_open_block (_tmp15_);
	_tmp16_ = vala_catch_clause_get_error_variable (clause);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaLocalVariable* _tmp18_;
		ValaLocalVariable* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		ValaCCodeExpression* _tmp26_;
		ValaCCodeExpression* _tmp27_;
		ValaCCodeExpression* _tmp28_;
		ValaCCodeExpression* _tmp29_;
		_tmp18_ = vala_catch_clause_get_error_variable (clause);
		_tmp19_ = _tmp18_;
		vala_code_visitor_visit_local_variable ((ValaCodeVisitor*) self, _tmp19_);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_catch_clause_get_error_variable (clause);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_ccode_base_module_get_local_cname ((ValaCCodeBaseModule*) self, _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_assignment (_tmp21_, _tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_vala_ccode_node_unref0 (_tmp27_);
		_g_free0 (_tmp25_);
	} else {
		ValaCCodeFunctionCall* cclear = NULL;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeFunctionCall* _tmp32_;
		ValaCCodeFunctionCall* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeExpression* _tmp36_;
		ValaCCodeUnaryExpression* _tmp37_;
		ValaCCodeUnaryExpression* _tmp38_;
		ValaCCodeFunction* _tmp39_;
		ValaCCodeFunction* _tmp40_;
		ValaCCodeFunctionCall* _tmp41_;
		_tmp30_ = vala_ccode_identifier_new ("g_clear_error");
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp31_);
		_tmp33_ = _tmp32_;
		_vala_ccode_node_unref0 (_tmp31_);
		cclear = _tmp33_;
		_tmp34_ = cclear;
		_tmp35_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp36_);
		_tmp38_ = _tmp37_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp38_);
		_vala_ccode_node_unref0 (_tmp38_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp39_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = cclear;
		vala_ccode_function_add_expression (_tmp40_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (cclear);
	}
	_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_ccode_constant_new ("NULL");
	_tmp47_ = _tmp46_;
	vala_ccode_function_add_assignment (_tmp43_, _tmp45_, (ValaCCodeExpression*) _tmp47_);
	_vala_ccode_node_unref0 (_tmp47_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp48_ = vala_catch_clause_get_body (clause);
	_tmp49_ = _tmp48_;
	vala_code_node_emit ((ValaCodeNode*) _tmp49_, (ValaCodeGenerator*) self);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	vala_ccode_function_close (_tmp51_);
	_vala_code_node_unref0 (error_type);
}


static void
vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                           ValaSymbol* sym,
                                           ValaCodeNode* stop_at)
{
	ValaGErrorModule * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (sym != NULL);
	VALA_CCODE_BASE_MODULE_CLASS (vala_gerror_module_parent_class)->append_scope_free ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule), sym, stop_at);
	if (G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_TRY_STATEMENT)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_CATCH_CLAUSE);
	}
	if (!_tmp0_) {
		ValaBlock* finally_block = NULL;
		ValaBlock* _tmp1_;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		gboolean _tmp18_ = FALSE;
		ValaBlock* _tmp19_;
		_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (NULL, VALA_TYPE_BLOCK, ValaBlock));
		finally_block = _tmp1_;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
		_tmp3_ = _tmp2_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TRY_STATEMENT)) {
			ValaCodeNode* _tmp4_;
			ValaCodeNode* _tmp5_;
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			ValaBlock* _tmp8_;
			_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
			_tmp7_ = _tmp6_;
			_tmp8_ = _vala_code_node_ref0 (_tmp7_);
			_vala_code_node_unref0 (finally_block);
			finally_block = _tmp8_;
		} else {
			ValaCodeNode* _tmp9_;
			ValaCodeNode* _tmp10_;
			_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp10_ = _tmp9_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_CATCH_CLAUSE)) {
				ValaCodeNode* _tmp11_;
				ValaCodeNode* _tmp12_;
				ValaCodeNode* _tmp13_;
				ValaCodeNode* _tmp14_;
				ValaBlock* _tmp15_;
				ValaBlock* _tmp16_;
				ValaBlock* _tmp17_;
				_tmp11_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
				_tmp16_ = _tmp15_;
				_tmp17_ = _vala_code_node_ref0 (_tmp16_);
				_vala_code_node_unref0 (finally_block);
				finally_block = _tmp17_;
			}
		}
		_tmp19_ = finally_block;
		if (_tmp19_ != NULL) {
			ValaBlock* _tmp20_;
			_tmp20_ = finally_block;
			_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_SYMBOL, ValaSymbol) != sym;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaBlock* _tmp21_;
			_tmp21_ = finally_block;
			vala_code_node_emit ((ValaCodeNode*) _tmp21_, (ValaCodeGenerator*) self);
		}
		_vala_code_node_unref0 (finally_block);
	}
}


ValaGErrorModule*
vala_gerror_module_construct (GType object_type)
{
	ValaGErrorModule* self = NULL;
	self = (ValaGErrorModule*) vala_ccode_delegate_module_construct (object_type);
	return self;
}


ValaGErrorModule*
vala_gerror_module_new (void)
{
	return vala_gerror_module_construct (VALA_TYPE_GERROR_MODULE);
}


static void
vala_gerror_module_class_init (ValaGErrorModuleClass * klass)
{
	vala_gerror_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gerror_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGErrorModulePrivate));
	((ValaCCodeBaseModuleClass *) klass)->generate_error_domain_declaration = (void (*) (ValaCCodeBaseModule*, ValaErrorDomain*, ValaCCodeFile*)) vala_gerror_module_real_generate_error_domain_declaration;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gerror_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_gerror_module_real_visit_throw_statement;
	((ValaGErrorModuleClass *) klass)->return_with_exception = (void (*) (ValaGErrorModule*, ValaCCodeExpression*)) vala_gerror_module_real_return_with_exception;
	((ValaCCodeBaseModuleClass *) klass)->add_simple_check = (void (*) (ValaCCodeBaseModule*, ValaCodeNode*, gboolean)) vala_gerror_module_real_add_simple_check;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_gerror_module_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor*, ValaCatchClause*)) vala_gerror_module_real_visit_catch_clause;
	((ValaCCodeBaseModuleClass *) klass)->append_scope_free = (void (*) (ValaCCodeBaseModule*, ValaSymbol*, ValaCodeNode*)) vala_gerror_module_real_append_scope_free;
}


static void
vala_gerror_module_instance_init (ValaGErrorModule * self)
{
	self->priv = VALA_GERROR_MODULE_GET_PRIVATE (self);
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->priv->is_in_catch = FALSE;
}


static void
vala_gerror_module_finalize (ValaCodeVisitor * obj)
{
	ValaGErrorModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GERROR_MODULE, ValaGErrorModule);
	VALA_CODE_VISITOR_CLASS (vala_gerror_module_parent_class)->finalize (obj);
}


GType
vala_gerror_module_get_type (void)
{
	static volatile gsize vala_gerror_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gerror_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGErrorModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gerror_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGErrorModule), 0, (GInstanceInitFunc) vala_gerror_module_instance_init, NULL };
		GType vala_gerror_module_type_id;
		vala_gerror_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaGErrorModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gerror_module_type_id__volatile, vala_gerror_module_type_id);
	}
	return vala_gerror_module_type_id__volatile;
}



