/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};


static gpointer vala_member_access_parent_class = NULL;

#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_tmp9_ = _type_arg_index;
			_type_arg_index = _tmp9_ + 1;
			_tmp10_ = _type_arg_index;
			_tmp11_ = _type_arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_arg_list;
			_tmp13_ = _type_arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}


static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->type_argument_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->type_argument_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->type_argument_list;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}


static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}


static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp20_;
	gboolean _tmp584_ = FALSE;
	gboolean _tmp585_ = FALSE;
	ValaSymbol* _tmp586_;
	ValaSymbol* _tmp587_;
	ValaSymbol* _tmp615_;
	ValaSymbol* _tmp616_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp643_;
	ValaSymbol* _tmp644_;
	ValaSymbol* _tmp645_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp646_;
	ValaSymbol* _tmp647_;
	ValaSymbol* _tmp1074_;
	ValaSymbol* _tmp1075_;
	ValaVersionAttribute* _tmp1076_;
	ValaVersionAttribute* _tmp1077_;
	ValaSourceReference* _tmp1078_;
	ValaSourceReference* _tmp1079_;
	gboolean _tmp1080_ = FALSE;
	ValaSymbolAccessibility _tmp1081_;
	gboolean _tmp1142_ = FALSE;
	gboolean _tmp1143_;
	gboolean _tmp1182_ = FALSE;
	gboolean _tmp1183_ = FALSE;
	gboolean _tmp1184_;
	gboolean _tmp1454_;
	gboolean _tmp1455_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_tmp13_ = _type_arg_index;
			_type_arg_index = _tmp13_ + 1;
			_tmp14_ = _type_arg_index;
			_tmp15_ = _type_arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _type_arg_list;
			_tmp17_ = _type_arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaScope* _tmp25_;
		ValaScope* _tmp26_;
		const gchar* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaSymbol* _tmp29_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp23_;
		_tmp24_ = base_symbol;
		_tmp25_ = vala_symbol_get_scope (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_member_name;
		_tmp28_ = vala_scope_lookup (_tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
	} else {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == NULL) {
			const gchar* _tmp32_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaSymbol* _tmp46_;
			gboolean _tmp158_ = FALSE;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			_tmp32_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp32_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp33_;
				ValaSemanticAnalyzer* _tmp34_;
				_tmp33_ = vala_code_context_get_analyzer (context);
				_tmp34_ = _tmp33_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp34_)) {
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp36_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp37_ = vala_code_context_get_analyzer (context);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _vala_code_node_ref0 (_tmp40_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (_tmp45_);
			sym = _tmp46_;
			while (TRUE) {
				gboolean _tmp47_ = FALSE;
				ValaSymbol* _tmp48_;
				gboolean _tmp51_;
				ValaSymbol* _tmp105_;
				const gchar* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp108_;
				gboolean _tmp109_ = FALSE;
				gboolean _tmp110_ = FALSE;
				ValaSymbol* _tmp111_;
				ValaSymbol* _tmp112_;
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp152_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				ValaSymbol* _tmp157_;
				_tmp48_ = sym;
				if (_tmp48_ != NULL) {
					ValaSymbol* _tmp49_;
					ValaSymbol* _tmp50_;
					_tmp49_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp50_ = _tmp49_;
					_tmp47_ = _tmp50_ == NULL;
				} else {
					_tmp47_ = FALSE;
				}
				if (!_tmp47_) {
					break;
				}
				_tmp51_ = method_found;
				if (!_tmp51_) {
					ValaSymbol* _tmp52_;
					_tmp52_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp52_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp53_;
						ValaCreationMethod* _tmp54_;
						ValaCreationMethod* _tmp55_;
						ValaParameter* _tmp56_;
						ValaParameter* _tmp57_;
						ValaParameter* _tmp58_;
						_tmp53_ = sym;
						_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp54_;
						_tmp55_ = cm;
						_tmp56_ = vala_method_get_this_parameter ((ValaMethod*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp58_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp59_;
						_tmp59_ = sym;
						if (VALA_IS_PROPERTY (_tmp59_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp60_;
							ValaProperty* _tmp61_;
							ValaProperty* _tmp62_;
							ValaParameter* _tmp63_;
							ValaParameter* _tmp64_;
							ValaParameter* _tmp65_;
							ValaProperty* _tmp66_;
							ValaMemberBinding _tmp67_;
							ValaMemberBinding _tmp68_;
							ValaProperty* _tmp69_;
							ValaMemberBinding _tmp70_;
							ValaMemberBinding _tmp71_;
							_tmp60_ = sym;
							_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp61_;
							_tmp62_ = prop;
							_tmp63_ = vala_property_get_this_parameter (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = _vala_code_node_ref0 (_tmp64_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp65_;
							_tmp66_ = prop;
							_tmp67_ = vala_property_get_binding (_tmp66_);
							_tmp68_ = _tmp67_;
							may_access_instance_members = _tmp68_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp69_ = prop;
							_tmp70_ = vala_property_get_binding (_tmp69_);
							_tmp71_ = _tmp70_;
							may_access_klass_members = _tmp71_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp72_;
							_tmp72_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp72_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaConstructor* _tmp75_;
								ValaParameter* _tmp76_;
								ValaParameter* _tmp77_;
								ValaParameter* _tmp78_;
								ValaConstructor* _tmp79_;
								ValaMemberBinding _tmp80_;
								ValaMemberBinding _tmp81_;
								_tmp73_ = sym;
								_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp74_;
								_tmp75_ = c;
								_tmp76_ = vala_constructor_get_this_parameter (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = _vala_code_node_ref0 (_tmp77_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp78_;
								_tmp79_ = c;
								_tmp80_ = vala_constructor_get_binding (_tmp79_);
								_tmp81_ = _tmp80_;
								may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp82_;
								_tmp82_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp82_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaDestructor* _tmp85_;
									ValaParameter* _tmp86_;
									ValaParameter* _tmp87_;
									ValaParameter* _tmp88_;
									ValaDestructor* _tmp89_;
									ValaMemberBinding _tmp90_;
									ValaMemberBinding _tmp91_;
									_tmp83_ = sym;
									_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp84_;
									_tmp85_ = d;
									_tmp86_ = vala_destructor_get_this_parameter (_tmp85_);
									_tmp87_ = _tmp86_;
									_tmp88_ = _vala_code_node_ref0 (_tmp87_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp88_;
									_tmp89_ = d;
									_tmp90_ = vala_destructor_get_binding (_tmp89_);
									_tmp91_ = _tmp90_;
									may_access_instance_members = _tmp91_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp92_;
									_tmp92_ = sym;
									if (VALA_IS_METHOD (_tmp92_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMethod* _tmp95_;
										ValaParameter* _tmp96_;
										ValaParameter* _tmp97_;
										ValaParameter* _tmp98_;
										ValaMethod* _tmp99_;
										ValaMemberBinding _tmp100_;
										ValaMemberBinding _tmp101_;
										ValaMethod* _tmp102_;
										ValaMemberBinding _tmp103_;
										ValaMemberBinding _tmp104_;
										_tmp93_ = sym;
										_tmp94_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp94_;
										_tmp95_ = m;
										_tmp96_ = vala_method_get_this_parameter (_tmp95_);
										_tmp97_ = _tmp96_;
										_tmp98_ = _vala_code_node_ref0 (_tmp97_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp98_;
										_tmp99_ = m;
										_tmp100_ = vala_method_get_binding (_tmp99_);
										_tmp101_ = _tmp100_;
										may_access_instance_members = _tmp101_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp102_ = m;
										_tmp103_ = vala_method_get_binding (_tmp102_);
										_tmp104_ = _tmp103_;
										may_access_klass_members = _tmp104_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp105_ = sym;
				_tmp106_ = self->priv->_member_name;
				_tmp107_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp105_, _tmp106_);
				_tmp108_ = _tmp107_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp108_);
				_vala_code_node_unref0 (_tmp108_);
				_tmp111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp112_ = _tmp111_;
				if (_tmp112_ == NULL) {
					ValaSymbol* _tmp113_;
					_tmp113_ = sym;
					_tmp110_ = VALA_IS_TYPESYMBOL (_tmp113_);
				} else {
					_tmp110_ = FALSE;
				}
				if (_tmp110_) {
					gboolean _tmp114_;
					_tmp114_ = may_access_instance_members;
					_tmp109_ = _tmp114_;
				} else {
					_tmp109_ = FALSE;
				}
				if (_tmp109_) {
					ValaParameter* _tmp115_;
					ValaDataType* _tmp116_;
					ValaDataType* _tmp117_;
					const gchar* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					gboolean _tmp121_ = FALSE;
					ValaSymbol* _tmp122_;
					ValaSymbol* _tmp123_;
					_tmp115_ = this_parameter;
					_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = self->priv->_member_name;
					_tmp119_ = vala_data_type_get_member (_tmp117_, _tmp118_);
					_tmp120_ = _tmp119_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp120_);
					_vala_code_node_unref0 (_tmp120_);
					_tmp122_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp123_ = _tmp122_;
					if (_tmp123_ != NULL) {
						ValaSymbol* _tmp124_;
						ValaSymbol* _tmp125_;
						_tmp124_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp125_ = _tmp124_;
						_tmp121_ = vala_member_access_is_instance_symbol (_tmp125_);
					} else {
						_tmp121_ = FALSE;
					}
					if (_tmp121_) {
						ValaSourceReference* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						ValaParameter* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						ValaDataType* _tmp136_;
						ValaExpression* _tmp137_;
						ValaExpression* _tmp138_;
						ValaDataType* _tmp139_;
						ValaDataType* _tmp140_;
						ValaExpression* _tmp141_;
						ValaExpression* _tmp142_;
						ValaParameter* _tmp143_;
						ValaExpression* _tmp144_;
						ValaExpression* _tmp145_;
						ValaDataType* _tmp146_;
						ValaDataType* _tmp147_;
						const gchar* _tmp148_;
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_member_access_new (NULL, "this", _tmp127_);
						_tmp129_ = _tmp128_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp129_);
						_vala_code_node_unref0 (_tmp129_);
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						_tmp132_ = this_parameter;
						_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_copy (_tmp134_);
						_tmp136_ = _tmp135_;
						vala_expression_set_value_type (_tmp131_, _tmp136_);
						_vala_code_node_unref0 (_tmp136_);
						_tmp137_ = vala_member_access_get_inner (self);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_expression_get_value_type (_tmp138_);
						_tmp140_ = _tmp139_;
						vala_data_type_set_value_owned (_tmp140_, FALSE);
						_tmp141_ = vala_member_access_get_inner (self);
						_tmp142_ = _tmp141_;
						_tmp143_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp142_, (ValaSymbol*) _tmp143_);
						_tmp144_ = vala_member_access_get_inner (self);
						_tmp145_ = _tmp144_;
						_tmp146_ = vala_expression_get_value_type (_tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = self->priv->_member_name;
						_tmp149_ = vala_data_type_get_member (_tmp147_, _tmp148_);
						_tmp150_ = _tmp149_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp150_);
						_vala_code_node_unref0 (_tmp150_);
					}
				}
				_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp152_ = _tmp151_;
				if (_tmp152_ == NULL) {
					ValaSymbol* _tmp153_;
					_tmp153_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp153_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp154_ = sym;
				_tmp155_ = vala_symbol_get_parent_symbol (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = _vala_code_node_ref0 (_tmp156_);
				_vala_code_node_unref0 (sym);
				sym = _tmp157_;
			}
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			if (_tmp160_ == NULL) {
				ValaSourceReference* _tmp161_;
				ValaSourceReference* _tmp162_;
				_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp162_ = _tmp161_;
				_tmp158_ = _tmp162_ != NULL;
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp163_;
					ValaSourceReference* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _tmp166_;
					ValaList* _tmp167_;
					gint _ns_size = 0;
					ValaList* _tmp168_;
					gint _tmp169_;
					gint _tmp170_;
					gint _ns_index = 0;
					_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_source_reference_get_using_directives (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = _vala_iterable_ref0 (_tmp166_);
					_ns_list = _tmp167_;
					_tmp168_ = _ns_list;
					_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
					_tmp170_ = _tmp169_;
					_ns_size = _tmp170_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp171_;
						gint _tmp172_;
						gint _tmp173_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp174_;
						gint _tmp175_;
						gpointer _tmp176_;
						ValaUsingDirective* _tmp177_;
						gboolean _tmp178_;
						gboolean _tmp179_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp180_;
						ValaSymbol* _tmp181_;
						ValaSymbol* _tmp182_;
						ValaScope* _tmp183_;
						ValaScope* _tmp184_;
						const gchar* _tmp185_;
						ValaSymbol* _tmp186_;
						ValaSymbol* _tmp187_;
						_tmp171_ = _ns_index;
						_ns_index = _tmp171_ + 1;
						_tmp172_ = _ns_index;
						_tmp173_ = _ns_size;
						if (!(_tmp172_ < _tmp173_)) {
							break;
						}
						_tmp174_ = _ns_list;
						_tmp175_ = _ns_index;
						_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
						ns = (ValaUsingDirective*) _tmp176_;
						_tmp177_ = ns;
						_tmp178_ = vala_code_node_get_error ((ValaCodeNode*) _tmp177_);
						_tmp179_ = _tmp178_;
						if (_tmp179_) {
							_vala_code_node_unref0 (ns);
							continue;
						}
						_tmp180_ = ns;
						_tmp181_ = vala_using_directive_get_namespace_symbol (_tmp180_);
						_tmp182_ = _tmp181_;
						_tmp183_ = vala_symbol_get_scope (_tmp182_);
						_tmp184_ = _tmp183_;
						_tmp185_ = self->priv->_member_name;
						_tmp186_ = vala_scope_lookup (_tmp184_, _tmp185_);
						local_sym = _tmp186_;
						_tmp187_ = local_sym;
						if (_tmp187_ != NULL) {
							gboolean _tmp188_ = FALSE;
							ValaSymbol* _tmp189_;
							ValaSymbol* _tmp190_;
							ValaSymbol* _tmp206_;
							_tmp189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp190_ = _tmp189_;
							if (_tmp190_ != NULL) {
								ValaSymbol* _tmp191_;
								ValaSymbol* _tmp192_;
								ValaSymbol* _tmp193_;
								_tmp191_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp192_ = _tmp191_;
								_tmp193_ = local_sym;
								_tmp188_ = _tmp192_ != _tmp193_;
							} else {
								_tmp188_ = FALSE;
							}
							if (_tmp188_) {
								ValaSourceReference* _tmp194_;
								ValaSourceReference* _tmp195_;
								const gchar* _tmp196_;
								ValaSymbol* _tmp197_;
								ValaSymbol* _tmp198_;
								gchar* _tmp199_;
								gchar* _tmp200_;
								ValaSymbol* _tmp201_;
								gchar* _tmp202_;
								gchar* _tmp203_;
								gchar* _tmp204_;
								gchar* _tmp205_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp194_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = self->priv->_member_name;
								_tmp197_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp198_ = _tmp197_;
								_tmp199_ = vala_symbol_get_full_name (_tmp198_);
								_tmp200_ = _tmp199_;
								_tmp201_ = local_sym;
								_tmp202_ = vala_symbol_get_full_name (_tmp201_);
								_tmp203_ = _tmp202_;
								_tmp204_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp196_, _tmp200_, _tmp203_);
								_tmp205_ = _tmp204_;
								vala_report_error (_tmp195_, _tmp205_);
								_g_free0 (_tmp205_);
								_g_free0 (_tmp203_);
								_g_free0 (_tmp200_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp206_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp206_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp207_;
			ValaExpression* _tmp208_;
			gboolean _tmp209_;
			gboolean _tmp210_;
			ValaExpression* _tmp211_;
			ValaExpression* _tmp212_;
			ValaDataType* _tmp213_;
			ValaDataType* _tmp214_;
			ValaExpression* _tmp233_;
			ValaExpression* _tmp234_;
			gboolean _tmp250_ = FALSE;
			ValaExpression* _tmp251_;
			ValaExpression* _tmp252_;
			gboolean _tmp274_ = FALSE;
			ValaSymbol* _tmp275_;
			ValaSymbol* _tmp276_;
			gboolean _tmp311_ = FALSE;
			gboolean _tmp312_ = FALSE;
			ValaSymbol* _tmp313_;
			ValaSymbol* _tmp314_;
			gboolean _tmp566_ = FALSE;
			ValaSymbol* _tmp567_;
			ValaSymbol* _tmp568_;
			_tmp207_ = vala_member_access_get_inner (self);
			_tmp208_ = _tmp207_;
			_tmp209_ = vala_code_node_get_error ((ValaCodeNode*) _tmp208_);
			_tmp210_ = _tmp209_;
			if (_tmp210_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp211_ = vala_member_access_get_inner (self);
			_tmp212_ = _tmp211_;
			_tmp213_ = vala_expression_get_value_type (_tmp212_);
			_tmp214_ = _tmp213_;
			if (VALA_IS_POINTER_TYPE (_tmp214_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp215_;
				ValaExpression* _tmp216_;
				ValaDataType* _tmp217_;
				ValaDataType* _tmp218_;
				ValaPointerType* _tmp219_;
				gboolean _tmp220_ = FALSE;
				ValaPointerType* _tmp221_;
				_tmp215_ = vala_member_access_get_inner (self);
				_tmp216_ = _tmp215_;
				_tmp217_ = vala_expression_get_value_type (_tmp216_);
				_tmp218_ = _tmp217_;
				_tmp219_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp218_) ? ((ValaPointerType*) _tmp218_) : NULL);
				pointer_type = _tmp219_;
				_tmp221_ = pointer_type;
				if (_tmp221_ != NULL) {
					ValaPointerType* _tmp222_;
					ValaDataType* _tmp223_;
					ValaDataType* _tmp224_;
					_tmp222_ = pointer_type;
					_tmp223_ = vala_pointer_type_get_base_type (_tmp222_);
					_tmp224_ = _tmp223_;
					_tmp220_ = VALA_IS_VALUE_TYPE (_tmp224_);
				} else {
					_tmp220_ = FALSE;
				}
				if (_tmp220_) {
					ValaExpression* _tmp225_;
					ValaExpression* _tmp226_;
					ValaSourceReference* _tmp227_;
					ValaSourceReference* _tmp228_;
					ValaPointerIndirection* _tmp229_;
					ValaPointerIndirection* _tmp230_;
					ValaExpression* _tmp231_;
					ValaExpression* _tmp232_;
					_tmp225_ = vala_member_access_get_inner (self);
					_tmp226_ = _tmp225_;
					_tmp227_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_pointer_indirection_new (_tmp226_, _tmp228_);
					_tmp230_ = _tmp229_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp230_);
					_vala_code_node_unref0 (_tmp230_);
					_tmp231_ = vala_member_access_get_inner (self);
					_tmp232_ = _tmp231_;
					vala_code_node_check ((ValaCodeNode*) _tmp232_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp233_ = vala_member_access_get_inner (self);
			_tmp234_ = _tmp233_;
			if (VALA_IS_MEMBER_ACCESS (_tmp234_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp235_;
				ValaExpression* _tmp236_;
				ValaMemberAccess* _tmp237_;
				ValaMemberAccess* _tmp238_;
				gboolean _tmp239_;
				_tmp235_ = vala_member_access_get_inner (self);
				_tmp236_ = _tmp235_;
				_tmp237_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp236_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp237_;
				_tmp238_ = ma;
				_tmp239_ = _tmp238_->priv->_prototype_access;
				if (_tmp239_) {
					ValaSourceReference* _tmp240_;
					ValaSourceReference* _tmp241_;
					ValaExpression* _tmp242_;
					ValaExpression* _tmp243_;
					ValaSymbol* _tmp244_;
					ValaSymbol* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					gchar* _tmp249_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp240_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp241_ = _tmp240_;
					_tmp242_ = vala_member_access_get_inner (self);
					_tmp243_ = _tmp242_;
					_tmp244_ = vala_expression_get_symbol_reference (_tmp243_);
					_tmp245_ = _tmp244_;
					_tmp246_ = vala_symbol_get_full_name (_tmp245_);
					_tmp247_ = _tmp246_;
					_tmp248_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp247_);
					_tmp249_ = _tmp248_;
					vala_report_error (_tmp241_, _tmp249_);
					_g_free0 (_tmp249_);
					_g_free0 (_tmp247_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp251_ = vala_member_access_get_inner (self);
			_tmp252_ = _tmp251_;
			if (VALA_IS_MEMBER_ACCESS (_tmp252_)) {
				_tmp250_ = TRUE;
			} else {
				ValaExpression* _tmp253_;
				ValaExpression* _tmp254_;
				_tmp253_ = vala_member_access_get_inner (self);
				_tmp254_ = _tmp253_;
				_tmp250_ = VALA_IS_BASE_ACCESS (_tmp254_);
			}
			if (_tmp250_) {
				ValaExpression* _tmp255_;
				ValaExpression* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				gboolean _tmp260_ = FALSE;
				ValaSymbol* _tmp261_;
				ValaSymbol* _tmp262_;
				_tmp255_ = vala_member_access_get_inner (self);
				_tmp256_ = _tmp255_;
				_tmp257_ = vala_expression_get_symbol_reference (_tmp256_);
				_tmp258_ = _tmp257_;
				_tmp259_ = _vala_code_node_ref0 (_tmp258_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp259_;
				_tmp261_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp262_ = _tmp261_;
				if (_tmp262_ == NULL) {
					gboolean _tmp263_ = FALSE;
					ValaSymbol* _tmp264_;
					_tmp264_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp264_)) {
						_tmp263_ = TRUE;
					} else {
						ValaSymbol* _tmp265_;
						_tmp265_ = base_symbol;
						_tmp263_ = VALA_IS_TYPESYMBOL (_tmp265_);
					}
					_tmp260_ = _tmp263_;
				} else {
					_tmp260_ = FALSE;
				}
				if (_tmp260_) {
					ValaSymbol* _tmp266_;
					ValaScope* _tmp267_;
					ValaScope* _tmp268_;
					const gchar* _tmp269_;
					ValaSymbol* _tmp270_;
					ValaSymbol* _tmp271_;
					ValaExpression* _tmp272_;
					ValaExpression* _tmp273_;
					_tmp266_ = base_symbol;
					_tmp267_ = vala_symbol_get_scope (_tmp266_);
					_tmp268_ = _tmp267_;
					_tmp269_ = self->priv->_member_name;
					_tmp270_ = vala_scope_lookup (_tmp268_, _tmp269_);
					_tmp271_ = _tmp270_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp271_);
					_vala_code_node_unref0 (_tmp271_);
					_tmp272_ = vala_member_access_get_inner (self);
					_tmp273_ = _tmp272_;
					if (VALA_IS_BASE_ACCESS (_tmp273_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp275_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp276_ = _tmp275_;
			if (_tmp276_ == NULL) {
				ValaExpression* _tmp277_;
				ValaExpression* _tmp278_;
				ValaDataType* _tmp279_;
				ValaDataType* _tmp280_;
				_tmp277_ = vala_member_access_get_inner (self);
				_tmp278_ = _tmp277_;
				_tmp279_ = vala_expression_get_value_type (_tmp278_);
				_tmp280_ = _tmp279_;
				_tmp274_ = _tmp280_ != NULL;
			} else {
				_tmp274_ = FALSE;
			}
			if (_tmp274_) {
				gboolean _tmp281_;
				ValaSymbol* _tmp309_;
				ValaSymbol* _tmp310_;
				_tmp281_ = self->priv->_pointer_member_access;
				if (_tmp281_) {
					ValaExpression* _tmp282_;
					ValaExpression* _tmp283_;
					ValaDataType* _tmp284_;
					ValaDataType* _tmp285_;
					const gchar* _tmp286_;
					ValaSymbol* _tmp287_;
					ValaSymbol* _tmp288_;
					_tmp282_ = vala_member_access_get_inner (self);
					_tmp283_ = _tmp282_;
					_tmp284_ = vala_expression_get_value_type (_tmp283_);
					_tmp285_ = _tmp284_;
					_tmp286_ = self->priv->_member_name;
					_tmp287_ = vala_data_type_get_pointer_member (_tmp285_, _tmp286_);
					_tmp288_ = _tmp287_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp288_);
					_vala_code_node_unref0 (_tmp288_);
				} else {
					ValaExpression* _tmp289_;
					ValaExpression* _tmp290_;
					ValaDataType* _tmp291_;
					ValaDataType* _tmp292_;
					ValaTypeSymbol* _tmp293_;
					ValaTypeSymbol* _tmp294_;
					ValaExpression* _tmp302_;
					ValaExpression* _tmp303_;
					ValaDataType* _tmp304_;
					ValaDataType* _tmp305_;
					const gchar* _tmp306_;
					ValaSymbol* _tmp307_;
					ValaSymbol* _tmp308_;
					_tmp289_ = vala_member_access_get_inner (self);
					_tmp290_ = _tmp289_;
					_tmp291_ = vala_expression_get_value_type (_tmp290_);
					_tmp292_ = _tmp291_;
					_tmp293_ = vala_data_type_get_data_type (_tmp292_);
					_tmp294_ = _tmp293_;
					if (_tmp294_ != NULL) {
						ValaExpression* _tmp295_;
						ValaExpression* _tmp296_;
						ValaDataType* _tmp297_;
						ValaDataType* _tmp298_;
						ValaTypeSymbol* _tmp299_;
						ValaTypeSymbol* _tmp300_;
						ValaSymbol* _tmp301_;
						_tmp295_ = vala_member_access_get_inner (self);
						_tmp296_ = _tmp295_;
						_tmp297_ = vala_expression_get_value_type (_tmp296_);
						_tmp298_ = _tmp297_;
						_tmp299_ = vala_data_type_get_data_type (_tmp298_);
						_tmp300_ = _tmp299_;
						_tmp301_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp300_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp301_;
					}
					_tmp302_ = vala_member_access_get_inner (self);
					_tmp303_ = _tmp302_;
					_tmp304_ = vala_expression_get_value_type (_tmp303_);
					_tmp305_ = _tmp304_;
					_tmp306_ = self->priv->_member_name;
					_tmp307_ = vala_data_type_get_member (_tmp305_, _tmp306_);
					_tmp308_ = _tmp307_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp308_);
					_vala_code_node_unref0 (_tmp308_);
				}
				_tmp309_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp310_ = _tmp309_;
				if (_tmp310_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp313_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp314_ = _tmp313_;
			if (_tmp314_ == NULL) {
				ValaExpression* _tmp315_;
				ValaExpression* _tmp316_;
				ValaDataType* _tmp317_;
				ValaDataType* _tmp318_;
				_tmp315_ = vala_member_access_get_inner (self);
				_tmp316_ = _tmp315_;
				_tmp317_ = vala_expression_get_value_type (_tmp316_);
				_tmp318_ = _tmp317_;
				_tmp312_ = _tmp318_ != NULL;
			} else {
				_tmp312_ = FALSE;
			}
			if (_tmp312_) {
				ValaExpression* _tmp319_;
				ValaExpression* _tmp320_;
				ValaDataType* _tmp321_;
				ValaDataType* _tmp322_;
				gboolean _tmp323_;
				gboolean _tmp324_;
				_tmp319_ = vala_member_access_get_inner (self);
				_tmp320_ = _tmp319_;
				_tmp321_ = vala_expression_get_value_type (_tmp320_);
				_tmp322_ = _tmp321_;
				_tmp323_ = vala_data_type_get_is_dynamic (_tmp322_);
				_tmp324_ = _tmp323_;
				_tmp311_ = _tmp324_;
			} else {
				_tmp311_ = FALSE;
			}
			if (_tmp311_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp325_;
				ValaExpression* _tmp326_;
				ValaDataType* _tmp327_;
				ValaDataType* _tmp328_;
				ValaObjectType* _tmp329_;
				ValaCodeNode* _tmp330_;
				ValaCodeNode* _tmp331_;
				ValaSymbol* _tmp514_;
				ValaSymbol* _tmp515_;
				ValaSymbol* _tmp564_;
				ValaSymbol* _tmp565_;
				_tmp325_ = vala_member_access_get_inner (self);
				_tmp326_ = _tmp325_;
				_tmp327_ = vala_expression_get_value_type (_tmp326_);
				_tmp328_ = _tmp327_;
				_tmp329_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp328_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp329_;
				_tmp330_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp331_ = _tmp330_;
				if (VALA_IS_METHOD_CALL (_tmp331_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp332_;
					ValaCodeNode* _tmp333_;
					ValaMethodCall* _tmp334_;
					ValaMethodCall* _tmp335_;
					ValaExpression* _tmp336_;
					ValaExpression* _tmp337_;
					_tmp332_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp333_ = _tmp332_;
					_tmp334_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp333_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp334_;
					_tmp335_ = invoc;
					_tmp336_ = vala_method_call_get_call (_tmp335_);
					_tmp337_ = _tmp336_;
					if (_tmp337_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp338_;
						ValaDataType* _tmp339_;
						ValaDataType* _tmp340_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp355_;
						ValaExpression* _tmp356_;
						ValaDataType* _tmp357_;
						ValaDataType* _tmp358_;
						const gchar* _tmp359_;
						ValaDataType* _tmp360_;
						ValaSourceReference* _tmp361_;
						ValaSourceReference* _tmp362_;
						ValaDynamicMethod* _tmp363_;
						ValaDynamicMethod* _tmp364_;
						ValaMethodCall* _tmp365_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp366_;
						ValaErrorType* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaErrorType* _tmp369_;
						ValaDynamicMethod* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaParameter* _tmp372_;
						ValaParameter* _tmp373_;
						ValaDynamicMethod* _tmp374_;
						ValaObjectType* _tmp375_;
						ValaDataType* _tmp376_;
						ValaDataType* _tmp377_;
						ValaParameter* _tmp378_;
						ValaParameter* _tmp379_;
						ValaObjectType* _tmp380_;
						ValaObjectTypeSymbol* _tmp381_;
						ValaObjectTypeSymbol* _tmp382_;
						ValaScope* _tmp383_;
						ValaScope* _tmp384_;
						ValaDynamicMethod* _tmp385_;
						ValaDynamicMethod* _tmp386_;
						_tmp338_ = invoc;
						_tmp339_ = vala_expression_get_target_type ((ValaExpression*) _tmp338_);
						_tmp340_ = _tmp339_;
						if (_tmp340_ != NULL) {
							ValaMethodCall* _tmp341_;
							ValaDataType* _tmp342_;
							ValaDataType* _tmp343_;
							ValaDataType* _tmp344_;
							ValaDataType* _tmp345_;
							_tmp341_ = invoc;
							_tmp342_ = vala_expression_get_target_type ((ValaExpression*) _tmp341_);
							_tmp343_ = _tmp342_;
							_tmp344_ = vala_data_type_copy (_tmp343_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp344_;
							_tmp345_ = ret_type;
							vala_data_type_set_value_owned (_tmp345_, TRUE);
						} else {
							ValaMethodCall* _tmp346_;
							ValaCodeNode* _tmp347_;
							ValaCodeNode* _tmp348_;
							_tmp346_ = invoc;
							_tmp347_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp346_);
							_tmp348_ = _tmp347_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp348_)) {
								ValaVoidType* _tmp349_;
								_tmp349_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp349_;
							} else {
								ValaExpression* _tmp350_;
								ValaExpression* _tmp351_;
								ValaDataType* _tmp352_;
								ValaDataType* _tmp353_;
								ValaDataType* _tmp354_;
								_tmp350_ = vala_member_access_get_inner (self);
								_tmp351_ = _tmp350_;
								_tmp352_ = vala_expression_get_value_type (_tmp351_);
								_tmp353_ = _tmp352_;
								_tmp354_ = vala_data_type_copy (_tmp353_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp354_;
							}
						}
						_tmp355_ = vala_member_access_get_inner (self);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_expression_get_value_type (_tmp356_);
						_tmp358_ = _tmp357_;
						_tmp359_ = self->priv->_member_name;
						_tmp360_ = ret_type;
						_tmp361_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp362_ = _tmp361_;
						_tmp363_ = vala_dynamic_method_new (_tmp358_, _tmp359_, _tmp360_, _tmp362_, NULL);
						m = _tmp363_;
						_tmp364_ = m;
						_tmp365_ = invoc;
						vala_dynamic_method_set_invocation (_tmp364_, _tmp365_);
						_tmp366_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp366_;
						_tmp367_ = err;
						vala_error_type_set_dynamic_error (_tmp367_, TRUE);
						_tmp368_ = m;
						_tmp369_ = err;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp368_, (ValaDataType*) _tmp369_);
						_tmp370_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp370_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp371_ = m;
						_tmp372_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp373_ = _tmp372_;
						vala_callable_add_parameter ((ValaCallable*) _tmp371_, _tmp373_);
						_vala_code_node_unref0 (_tmp373_);
						_tmp374_ = m;
						_tmp375_ = dynamic_object_type;
						_tmp376_ = vala_data_type_copy ((ValaDataType*) _tmp375_);
						_tmp377_ = _tmp376_;
						_tmp378_ = vala_parameter_new ("this", _tmp377_, NULL);
						_tmp379_ = _tmp378_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp374_, _tmp379_);
						_vala_code_node_unref0 (_tmp379_);
						_vala_code_node_unref0 (_tmp377_);
						_tmp380_ = dynamic_object_type;
						_tmp381_ = vala_object_type_get_type_symbol (_tmp380_);
						_tmp382_ = _tmp381_;
						_tmp383_ = vala_symbol_get_scope ((ValaSymbol*) _tmp382_);
						_tmp384_ = _tmp383_;
						_tmp385_ = m;
						vala_scope_add (_tmp384_, NULL, (ValaSymbol*) _tmp385_);
						_tmp386_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp386_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp387_;
					ValaCodeNode* _tmp388_;
					_tmp387_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp388_ = _tmp387_;
					if (VALA_IS_ASSIGNMENT (_tmp388_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp389_;
						ValaCodeNode* _tmp390_;
						ValaAssignment* _tmp391_;
						gboolean _tmp392_ = FALSE;
						ValaAssignment* _tmp393_;
						ValaExpression* _tmp394_;
						ValaExpression* _tmp395_;
						_tmp389_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp390_ = _tmp389_;
						_tmp391_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp391_;
						_tmp393_ = a;
						_tmp394_ = vala_assignment_get_left (_tmp393_);
						_tmp395_ = _tmp394_;
						if (_tmp395_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp396_ = FALSE;
							ValaAssignment* _tmp397_;
							ValaAssignmentOperator _tmp398_;
							ValaAssignmentOperator _tmp399_;
							_tmp397_ = a;
							_tmp398_ = vala_assignment_get_operator (_tmp397_);
							_tmp399_ = _tmp398_;
							if (_tmp399_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp396_ = TRUE;
							} else {
								ValaAssignment* _tmp400_;
								ValaAssignmentOperator _tmp401_;
								ValaAssignmentOperator _tmp402_;
								_tmp400_ = a;
								_tmp401_ = vala_assignment_get_operator (_tmp400_);
								_tmp402_ = _tmp401_;
								_tmp396_ = _tmp402_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp392_ = _tmp396_;
						} else {
							_tmp392_ = FALSE;
						}
						if (_tmp392_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp403_;
							ValaExpression* _tmp404_;
							ValaDataType* _tmp405_;
							ValaDataType* _tmp406_;
							const gchar* _tmp407_;
							ValaVoidType* _tmp408_;
							ValaVoidType* _tmp409_;
							ValaSourceReference* _tmp410_;
							ValaSourceReference* _tmp411_;
							ValaDynamicSignal* _tmp412_;
							ValaDynamicSignal* _tmp413_;
							ValaDynamicSignal* _tmp414_;
							ValaAssignment* _tmp415_;
							ValaExpression* _tmp416_;
							ValaExpression* _tmp417_;
							ValaDynamicSignal* _tmp418_;
							ValaObjectType* _tmp419_;
							ValaObjectTypeSymbol* _tmp420_;
							ValaObjectTypeSymbol* _tmp421_;
							ValaScope* _tmp422_;
							ValaScope* _tmp423_;
							ValaDynamicSignal* _tmp424_;
							ValaDynamicSignal* _tmp425_;
							_tmp403_ = vala_member_access_get_inner (self);
							_tmp404_ = _tmp403_;
							_tmp405_ = vala_expression_get_value_type (_tmp404_);
							_tmp406_ = _tmp405_;
							_tmp407_ = self->priv->_member_name;
							_tmp408_ = vala_void_type_new (NULL);
							_tmp409_ = _tmp408_;
							_tmp410_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp411_ = _tmp410_;
							_tmp412_ = vala_dynamic_signal_new (_tmp406_, _tmp407_, (ValaDataType*) _tmp409_, _tmp411_, NULL);
							_tmp413_ = _tmp412_;
							_vala_code_node_unref0 (_tmp409_);
							s = _tmp413_;
							_tmp414_ = s;
							_tmp415_ = a;
							_tmp416_ = vala_assignment_get_right (_tmp415_);
							_tmp417_ = _tmp416_;
							vala_dynamic_signal_set_handler (_tmp414_, _tmp417_);
							_tmp418_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp418_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp419_ = dynamic_object_type;
							_tmp420_ = vala_object_type_get_type_symbol (_tmp419_);
							_tmp421_ = _tmp420_;
							_tmp422_ = vala_symbol_get_scope ((ValaSymbol*) _tmp421_);
							_tmp423_ = _tmp422_;
							_tmp424_ = s;
							vala_scope_add (_tmp423_, NULL, (ValaSymbol*) _tmp424_);
							_tmp425_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp425_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp426_;
							ValaExpression* _tmp427_;
							ValaExpression* _tmp428_;
							_tmp426_ = a;
							_tmp427_ = vala_assignment_get_left (_tmp426_);
							_tmp428_ = _tmp427_;
							if (_tmp428_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp429_;
								ValaExpression* _tmp430_;
								ValaDataType* _tmp431_;
								ValaDataType* _tmp432_;
								const gchar* _tmp433_;
								ValaSourceReference* _tmp434_;
								ValaSourceReference* _tmp435_;
								ValaDynamicProperty* _tmp436_;
								ValaDynamicProperty* _tmp437_;
								ValaDynamicProperty* _tmp438_;
								ValaDynamicProperty* _tmp439_;
								ValaSourceReference* _tmp440_;
								ValaSourceReference* _tmp441_;
								ValaPropertyAccessor* _tmp442_;
								ValaPropertyAccessor* _tmp443_;
								ValaDynamicProperty* _tmp444_;
								ValaExpression* _tmp445_;
								ValaExpression* _tmp446_;
								ValaDataType* _tmp447_;
								ValaDataType* _tmp448_;
								ValaTypeSymbol* _tmp449_;
								ValaTypeSymbol* _tmp450_;
								ValaScope* _tmp451_;
								ValaScope* _tmp452_;
								ValaObjectType* _tmp453_;
								ValaObjectTypeSymbol* _tmp454_;
								ValaObjectTypeSymbol* _tmp455_;
								ValaScope* _tmp456_;
								ValaScope* _tmp457_;
								ValaDynamicProperty* _tmp458_;
								ValaDynamicProperty* _tmp459_;
								_tmp429_ = vala_member_access_get_inner (self);
								_tmp430_ = _tmp429_;
								_tmp431_ = vala_expression_get_value_type (_tmp430_);
								_tmp432_ = _tmp431_;
								_tmp433_ = self->priv->_member_name;
								_tmp434_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp435_ = _tmp434_;
								_tmp436_ = vala_dynamic_property_new (_tmp432_, _tmp433_, _tmp435_, NULL);
								prop = _tmp436_;
								_tmp437_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp437_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp438_ = prop;
								_tmp439_ = prop;
								_tmp440_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp439_);
								_tmp441_ = _tmp440_;
								_tmp442_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp441_, NULL);
								_tmp443_ = _tmp442_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp438_, _tmp443_);
								_vala_code_node_unref0 (_tmp443_);
								_tmp444_ = prop;
								_tmp445_ = vala_member_access_get_inner (self);
								_tmp446_ = _tmp445_;
								_tmp447_ = vala_expression_get_value_type (_tmp446_);
								_tmp448_ = _tmp447_;
								_tmp449_ = vala_data_type_get_data_type (_tmp448_);
								_tmp450_ = _tmp449_;
								_tmp451_ = vala_symbol_get_scope ((ValaSymbol*) _tmp450_);
								_tmp452_ = _tmp451_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp444_, _tmp452_);
								_tmp453_ = dynamic_object_type;
								_tmp454_ = vala_object_type_get_type_symbol (_tmp453_);
								_tmp455_ = _tmp454_;
								_tmp456_ = vala_symbol_get_scope ((ValaSymbol*) _tmp455_);
								_tmp457_ = _tmp456_;
								_tmp458_ = prop;
								vala_scope_add (_tmp457_, NULL, (ValaSymbol*) _tmp458_);
								_tmp459_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp459_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp460_ = FALSE;
						gboolean _tmp461_ = FALSE;
						ValaCodeNode* _tmp462_;
						ValaCodeNode* _tmp463_;
						_tmp462_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp463_ = _tmp462_;
						if (VALA_IS_MEMBER_ACCESS (_tmp463_)) {
							ValaExpression* _tmp464_;
							ValaExpression* _tmp465_;
							_tmp464_ = vala_member_access_get_inner (self);
							_tmp465_ = _tmp464_;
							_tmp461_ = VALA_IS_MEMBER_ACCESS (_tmp465_);
						} else {
							_tmp461_ = FALSE;
						}
						if (_tmp461_) {
							ValaCodeNode* _tmp466_;
							ValaCodeNode* _tmp467_;
							ValaCodeNode* _tmp468_;
							ValaCodeNode* _tmp469_;
							_tmp466_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp467_ = _tmp466_;
							_tmp468_ = vala_code_node_get_parent_node (_tmp467_);
							_tmp469_ = _tmp468_;
							_tmp460_ = VALA_IS_METHOD_CALL (_tmp469_);
						} else {
							_tmp460_ = FALSE;
						}
						if (_tmp460_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp470_;
							ValaCodeNode* _tmp471_;
							ValaMemberAccess* _tmp472_;
							gboolean _tmp473_ = FALSE;
							ValaMemberAccess* _tmp474_;
							const gchar* _tmp475_;
							_tmp470_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp471_ = _tmp470_;
							_tmp472_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp471_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp472_;
							_tmp474_ = ma;
							_tmp475_ = _tmp474_->priv->_member_name;
							if (g_strcmp0 (_tmp475_, "connect") == 0) {
								_tmp473_ = TRUE;
							} else {
								ValaMemberAccess* _tmp476_;
								const gchar* _tmp477_;
								_tmp476_ = ma;
								_tmp477_ = _tmp476_->priv->_member_name;
								_tmp473_ = g_strcmp0 (_tmp477_, "connect_after") == 0;
							}
							if (_tmp473_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp478_;
								ValaExpression* _tmp479_;
								ValaDataType* _tmp480_;
								ValaDataType* _tmp481_;
								const gchar* _tmp482_;
								ValaVoidType* _tmp483_;
								ValaVoidType* _tmp484_;
								ValaSourceReference* _tmp485_;
								ValaSourceReference* _tmp486_;
								ValaDynamicSignal* _tmp487_;
								ValaDynamicSignal* _tmp488_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp489_;
								ValaCodeNode* _tmp490_;
								ValaCodeNode* _tmp491_;
								ValaCodeNode* _tmp492_;
								ValaMethodCall* _tmp493_;
								ValaMethodCall* _tmp494_;
								ValaList* _tmp495_;
								ValaList* _tmp496_;
								gint _tmp497_;
								gint _tmp498_;
								gboolean _tmp499_;
								ValaDynamicSignal* _tmp506_;
								ValaObjectType* _tmp507_;
								ValaObjectTypeSymbol* _tmp508_;
								ValaObjectTypeSymbol* _tmp509_;
								ValaScope* _tmp510_;
								ValaScope* _tmp511_;
								ValaDynamicSignal* _tmp512_;
								ValaDynamicSignal* _tmp513_;
								_tmp478_ = vala_member_access_get_inner (self);
								_tmp479_ = _tmp478_;
								_tmp480_ = vala_expression_get_value_type (_tmp479_);
								_tmp481_ = _tmp480_;
								_tmp482_ = self->priv->_member_name;
								_tmp483_ = vala_void_type_new (NULL);
								_tmp484_ = _tmp483_;
								_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp486_ = _tmp485_;
								_tmp487_ = vala_dynamic_signal_new (_tmp481_, _tmp482_, (ValaDataType*) _tmp484_, _tmp486_, NULL);
								_tmp488_ = _tmp487_;
								_vala_code_node_unref0 (_tmp484_);
								s = _tmp488_;
								_tmp489_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp490_ = _tmp489_;
								_tmp491_ = vala_code_node_get_parent_node (_tmp490_);
								_tmp492_ = _tmp491_;
								_tmp493_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp492_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp493_;
								_tmp494_ = mcall;
								_tmp495_ = vala_method_call_get_argument_list (_tmp494_);
								_tmp496_ = _tmp495_;
								_tmp497_ = vala_collection_get_size ((ValaCollection*) _tmp496_);
								_tmp498_ = _tmp497_;
								_tmp499_ = _tmp498_ > 0;
								_vala_iterable_unref0 (_tmp496_);
								if (_tmp499_) {
									ValaDynamicSignal* _tmp500_;
									ValaMethodCall* _tmp501_;
									ValaList* _tmp502_;
									ValaList* _tmp503_;
									gpointer _tmp504_;
									ValaExpression* _tmp505_;
									_tmp500_ = s;
									_tmp501_ = mcall;
									_tmp502_ = vala_method_call_get_argument_list (_tmp501_);
									_tmp503_ = _tmp502_;
									_tmp504_ = vala_list_get (_tmp503_, 0);
									_tmp505_ = (ValaExpression*) _tmp504_;
									vala_dynamic_signal_set_handler (_tmp500_, _tmp505_);
									_vala_code_node_unref0 (_tmp505_);
									_vala_iterable_unref0 (_tmp503_);
								}
								_tmp506_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp506_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp507_ = dynamic_object_type;
								_tmp508_ = vala_object_type_get_type_symbol (_tmp507_);
								_tmp509_ = _tmp508_;
								_tmp510_ = vala_symbol_get_scope ((ValaSymbol*) _tmp509_);
								_tmp511_ = _tmp510_;
								_tmp512_ = s;
								vala_scope_add (_tmp511_, NULL, (ValaSymbol*) _tmp512_);
								_tmp513_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp513_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp514_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp515_ = _tmp514_;
				if (_tmp515_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp516_;
					ValaExpression* _tmp517_;
					ValaDataType* _tmp518_;
					ValaDataType* _tmp519_;
					const gchar* _tmp520_;
					ValaSourceReference* _tmp521_;
					ValaSourceReference* _tmp522_;
					ValaDynamicProperty* _tmp523_;
					ValaDataType* _tmp524_;
					ValaDataType* _tmp525_;
					ValaDynamicProperty* _tmp536_;
					ValaDynamicProperty* _tmp537_;
					ValaDynamicProperty* _tmp538_;
					ValaDataType* _tmp539_;
					ValaDataType* _tmp540_;
					ValaDataType* _tmp541_;
					ValaDataType* _tmp542_;
					ValaDynamicProperty* _tmp543_;
					ValaSourceReference* _tmp544_;
					ValaSourceReference* _tmp545_;
					ValaPropertyAccessor* _tmp546_;
					ValaPropertyAccessor* _tmp547_;
					ValaDynamicProperty* _tmp548_;
					ValaExpression* _tmp549_;
					ValaExpression* _tmp550_;
					ValaDataType* _tmp551_;
					ValaDataType* _tmp552_;
					ValaTypeSymbol* _tmp553_;
					ValaTypeSymbol* _tmp554_;
					ValaScope* _tmp555_;
					ValaScope* _tmp556_;
					ValaObjectType* _tmp557_;
					ValaObjectTypeSymbol* _tmp558_;
					ValaObjectTypeSymbol* _tmp559_;
					ValaScope* _tmp560_;
					ValaScope* _tmp561_;
					ValaDynamicProperty* _tmp562_;
					ValaDynamicProperty* _tmp563_;
					_tmp516_ = vala_member_access_get_inner (self);
					_tmp517_ = _tmp516_;
					_tmp518_ = vala_expression_get_value_type (_tmp517_);
					_tmp519_ = _tmp518_;
					_tmp520_ = self->priv->_member_name;
					_tmp521_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp522_ = _tmp521_;
					_tmp523_ = vala_dynamic_property_new (_tmp519_, _tmp520_, _tmp522_, NULL);
					prop = _tmp523_;
					_tmp524_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp525_ = _tmp524_;
					if (_tmp525_ != NULL) {
						ValaDynamicProperty* _tmp526_;
						ValaDataType* _tmp527_;
						ValaDataType* _tmp528_;
						_tmp526_ = prop;
						_tmp527_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp528_ = _tmp527_;
						vala_property_set_property_type ((ValaProperty*) _tmp526_, _tmp528_);
					} else {
						ValaDynamicProperty* _tmp529_;
						ValaExpression* _tmp530_;
						ValaExpression* _tmp531_;
						ValaDataType* _tmp532_;
						ValaDataType* _tmp533_;
						ValaDataType* _tmp534_;
						ValaDataType* _tmp535_;
						_tmp529_ = prop;
						_tmp530_ = vala_member_access_get_inner (self);
						_tmp531_ = _tmp530_;
						_tmp532_ = vala_expression_get_value_type (_tmp531_);
						_tmp533_ = _tmp532_;
						_tmp534_ = vala_data_type_copy (_tmp533_);
						_tmp535_ = _tmp534_;
						vala_property_set_property_type ((ValaProperty*) _tmp529_, _tmp535_);
						_vala_code_node_unref0 (_tmp535_);
					}
					_tmp536_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp536_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp537_ = prop;
					_tmp538_ = prop;
					_tmp539_ = vala_property_get_property_type ((ValaProperty*) _tmp538_);
					_tmp540_ = _tmp539_;
					_tmp541_ = vala_data_type_copy (_tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = prop;
					_tmp544_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp543_);
					_tmp545_ = _tmp544_;
					_tmp546_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp542_, NULL, _tmp545_, NULL);
					_tmp547_ = _tmp546_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp537_, _tmp547_);
					_vala_code_node_unref0 (_tmp547_);
					_vala_code_node_unref0 (_tmp542_);
					_tmp548_ = prop;
					_tmp549_ = vala_member_access_get_inner (self);
					_tmp550_ = _tmp549_;
					_tmp551_ = vala_expression_get_value_type (_tmp550_);
					_tmp552_ = _tmp551_;
					_tmp553_ = vala_data_type_get_data_type (_tmp552_);
					_tmp554_ = _tmp553_;
					_tmp555_ = vala_symbol_get_scope ((ValaSymbol*) _tmp554_);
					_tmp556_ = _tmp555_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp548_, _tmp556_);
					_tmp557_ = dynamic_object_type;
					_tmp558_ = vala_object_type_get_type_symbol (_tmp557_);
					_tmp559_ = _tmp558_;
					_tmp560_ = vala_symbol_get_scope ((ValaSymbol*) _tmp559_);
					_tmp561_ = _tmp560_;
					_tmp562_ = prop;
					vala_scope_add (_tmp561_, NULL, (ValaSymbol*) _tmp562_);
					_tmp563_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp563_);
					_vala_code_node_unref0 (prop);
				}
				_tmp564_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp565_ = _tmp564_;
				if (_tmp565_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp567_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp568_ = _tmp567_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp568_)) {
				ValaExpression* _tmp569_;
				ValaExpression* _tmp570_;
				ValaDataType* _tmp571_;
				ValaDataType* _tmp572_;
				_tmp569_ = vala_member_access_get_inner (self);
				_tmp570_ = _tmp569_;
				_tmp571_ = vala_expression_get_value_type (_tmp570_);
				_tmp572_ = _tmp571_;
				_tmp566_ = VALA_IS_ARRAY_TYPE (_tmp572_);
			} else {
				_tmp566_ = FALSE;
			}
			if (_tmp566_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp573_;
				ValaExpression* _tmp574_;
				ValaDataType* _tmp575_;
				ValaDataType* _tmp576_;
				gboolean _tmp577_ = FALSE;
				ValaArrayType* _tmp578_;
				_tmp573_ = vala_member_access_get_inner (self);
				_tmp574_ = _tmp573_;
				_tmp575_ = vala_expression_get_value_type (_tmp574_);
				_tmp576_ = _tmp575_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp576_) ? ((ValaArrayType*) _tmp576_) : NULL;
				_tmp578_ = value_array_type;
				if (_tmp578_ != NULL) {
					ValaArrayType* _tmp579_;
					gboolean _tmp580_;
					gboolean _tmp581_;
					_tmp579_ = value_array_type;
					_tmp580_ = vala_array_type_get_inline_allocated (_tmp579_);
					_tmp581_ = _tmp580_;
					_tmp577_ = _tmp581_;
				} else {
					_tmp577_ = FALSE;
				}
				if (_tmp577_) {
					ValaSourceReference* _tmp582_;
					ValaSourceReference* _tmp583_;
					_tmp582_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp583_ = _tmp582_;
					vala_report_error (_tmp583_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp586_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp587_ = _tmp586_;
	if (_tmp587_ == NULL) {
		ValaDataType* _tmp588_;
		ValaDataType* _tmp589_;
		_tmp588_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp589_ = _tmp588_;
		_tmp585_ = _tmp589_ != NULL;
	} else {
		_tmp585_ = FALSE;
	}
	if (_tmp585_) {
		ValaDataType* _tmp590_;
		ValaDataType* _tmp591_;
		ValaTypeSymbol* _tmp592_;
		ValaTypeSymbol* _tmp593_;
		_tmp590_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp591_ = _tmp590_;
		_tmp592_ = vala_data_type_get_data_type (_tmp591_);
		_tmp593_ = _tmp592_;
		_tmp584_ = VALA_IS_ENUM (_tmp593_);
	} else {
		_tmp584_ = FALSE;
	}
	if (_tmp584_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp594_;
		ValaDataType* _tmp595_;
		ValaTypeSymbol* _tmp596_;
		ValaTypeSymbol* _tmp597_;
		ValaEnum* _tmp598_;
		_tmp594_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp595_ = _tmp594_;
		_tmp596_ = vala_data_type_get_data_type (_tmp595_);
		_tmp597_ = _tmp596_;
		_tmp598_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp597_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp598_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp599_;
			ValaList* _tmp600_;
			gint _val_size = 0;
			ValaList* _tmp601_;
			gint _tmp602_;
			gint _tmp603_;
			gint _val_index = 0;
			_tmp599_ = enum_type;
			_tmp600_ = vala_enum_get_values (_tmp599_);
			_val_list = _tmp600_;
			_tmp601_ = _val_list;
			_tmp602_ = vala_collection_get_size ((ValaCollection*) _tmp601_);
			_tmp603_ = _tmp602_;
			_val_size = _tmp603_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp604_;
				gint _tmp605_;
				gint _tmp606_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp607_;
				gint _tmp608_;
				gpointer _tmp609_;
				const gchar* _tmp610_;
				ValaEnumValue* _tmp611_;
				const gchar* _tmp612_;
				const gchar* _tmp613_;
				_tmp604_ = _val_index;
				_val_index = _tmp604_ + 1;
				_tmp605_ = _val_index;
				_tmp606_ = _val_size;
				if (!(_tmp605_ < _tmp606_)) {
					break;
				}
				_tmp607_ = _val_list;
				_tmp608_ = _val_index;
				_tmp609_ = vala_list_get (_tmp607_, _tmp608_);
				val = (ValaEnumValue*) _tmp609_;
				_tmp610_ = self->priv->_member_name;
				_tmp611_ = val;
				_tmp612_ = vala_symbol_get_name ((ValaSymbol*) _tmp611_);
				_tmp613_ = _tmp612_;
				if (g_strcmp0 (_tmp610_, _tmp613_) == 0) {
					ValaEnumValue* _tmp614_;
					_tmp614_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp614_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp615_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp616_ = _tmp615_;
	if (_tmp616_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp617_;
		gboolean _tmp618_ = FALSE;
		ValaExpression* _tmp619_;
		ValaExpression* _tmp620_;
		ValaSourceReference* _tmp633_;
		ValaSourceReference* _tmp634_;
		const gchar* _tmp635_;
		const gchar* _tmp636_;
		gchar* _tmp637_;
		gchar* _tmp638_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp617_ = g_strdup ("(null)");
		base_type_name = _tmp617_;
		_tmp619_ = vala_member_access_get_inner (self);
		_tmp620_ = _tmp619_;
		if (_tmp620_ != NULL) {
			ValaExpression* _tmp621_;
			ValaExpression* _tmp622_;
			ValaDataType* _tmp623_;
			ValaDataType* _tmp624_;
			_tmp621_ = vala_member_access_get_inner (self);
			_tmp622_ = _tmp621_;
			_tmp623_ = vala_expression_get_value_type (_tmp622_);
			_tmp624_ = _tmp623_;
			_tmp618_ = _tmp624_ != NULL;
		} else {
			_tmp618_ = FALSE;
		}
		if (_tmp618_) {
			ValaExpression* _tmp625_;
			ValaExpression* _tmp626_;
			ValaDataType* _tmp627_;
			ValaDataType* _tmp628_;
			gchar* _tmp629_;
			_tmp625_ = vala_member_access_get_inner (self);
			_tmp626_ = _tmp625_;
			_tmp627_ = vala_expression_get_value_type (_tmp626_);
			_tmp628_ = _tmp627_;
			_tmp629_ = vala_code_node_to_string ((ValaCodeNode*) _tmp628_);
			_g_free0 (base_type_name);
			base_type_name = _tmp629_;
		} else {
			ValaSymbol* _tmp630_;
			_tmp630_ = base_symbol;
			if (_tmp630_ != NULL) {
				ValaSymbol* _tmp631_;
				gchar* _tmp632_;
				_tmp631_ = base_symbol;
				_tmp632_ = vala_symbol_get_full_name (_tmp631_);
				_g_free0 (base_type_name);
				base_type_name = _tmp632_;
			}
		}
		_tmp633_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp634_ = _tmp633_;
		_tmp635_ = self->priv->_member_name;
		_tmp636_ = base_type_name;
		_tmp637_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp635_, _tmp636_);
		_tmp638_ = _tmp637_;
		vala_report_error (_tmp634_, _tmp638_);
		_g_free0 (_tmp638_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	} else {
		ValaSymbol* _tmp639_;
		ValaSymbol* _tmp640_;
		gboolean _tmp641_;
		gboolean _tmp642_;
		_tmp639_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp640_ = _tmp639_;
		_tmp641_ = vala_code_node_get_error ((ValaCodeNode*) _tmp640_);
		_tmp642_ = _tmp641_;
		if (_tmp642_) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
	}
	_tmp643_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp644_ = _tmp643_;
	_tmp645_ = _vala_code_node_ref0 (_tmp644_);
	member = _tmp645_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp646_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp646_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp647_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp647_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp648_;
		ValaLocalVariable* _tmp649_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp650_;
		ValaSymbol* _tmp651_;
		ValaSymbol* _tmp652_;
		ValaBlock* _tmp653_;
		gboolean _tmp654_ = FALSE;
		ValaBlock* _tmp655_;
		_tmp648_ = member;
		_tmp649_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp648_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp649_;
		_tmp650_ = local;
		_tmp651_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp650_);
		_tmp652_ = _tmp651_;
		_tmp653_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp652_) ? ((ValaBlock*) _tmp652_) : NULL);
		block = _tmp653_;
		_tmp655_ = block;
		if (_tmp655_ != NULL) {
			ValaSemanticAnalyzer* _tmp656_;
			ValaSemanticAnalyzer* _tmp657_;
			ValaBlock* _tmp658_;
			ValaSymbol* _tmp659_;
			ValaSymbol* _tmp660_;
			ValaSemanticAnalyzer* _tmp661_;
			ValaSemanticAnalyzer* _tmp662_;
			ValaSymbol* _tmp663_;
			ValaSymbol* _tmp664_;
			_tmp656_ = vala_code_context_get_analyzer (context);
			_tmp657_ = _tmp656_;
			_tmp658_ = block;
			_tmp659_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp657_, (ValaSymbol*) _tmp658_);
			_tmp660_ = _tmp659_;
			_tmp661_ = vala_code_context_get_analyzer (context);
			_tmp662_ = _tmp661_;
			_tmp663_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp662_);
			_tmp664_ = _tmp663_;
			_tmp654_ = _tmp660_ != _tmp664_;
			_vala_code_node_unref0 (_tmp660_);
		} else {
			_tmp654_ = FALSE;
		}
		if (_tmp654_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp665_;
			ValaSemanticAnalyzer* _tmp666_;
			ValaSymbol* _tmp667_;
			ValaSymbol* _tmp668_;
			ValaSymbol* _tmp669_;
			ValaLocalVariable* _tmp682_;
			ValaBlock* _tmp683_;
			_tmp665_ = vala_code_context_get_analyzer (context);
			_tmp666_ = _tmp665_;
			_tmp667_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp666_);
			_tmp668_ = _tmp667_;
			_tmp669_ = _vala_code_node_ref0 (_tmp668_);
			sym = _tmp669_;
			while (TRUE) {
				ValaSymbol* _tmp670_;
				ValaBlock* _tmp671_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp672_;
				ValaMethod* _tmp673_;
				ValaMethod* _tmp674_;
				ValaSymbol* _tmp678_;
				ValaSymbol* _tmp679_;
				ValaSymbol* _tmp680_;
				ValaSymbol* _tmp681_;
				_tmp670_ = sym;
				_tmp671_ = block;
				if (!(_tmp670_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp671_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp672_ = sym;
				_tmp673_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp672_) ? ((ValaMethod*) _tmp672_) : NULL);
				method = _tmp673_;
				_tmp674_ = method;
				if (_tmp674_ != NULL) {
					ValaMethod* _tmp675_;
					ValaMethod* _tmp676_;
					ValaLocalVariable* _tmp677_;
					_tmp675_ = method;
					vala_method_set_closure (_tmp675_, TRUE);
					_tmp676_ = method;
					_tmp677_ = local;
					vala_method_add_captured_variable (_tmp676_, _tmp677_);
				}
				_tmp678_ = sym;
				_tmp679_ = vala_symbol_get_parent_symbol (_tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = _vala_code_node_ref0 (_tmp680_);
				_vala_code_node_unref0 (sym);
				sym = _tmp681_;
				_vala_code_node_unref0 (method);
			}
			_tmp682_ = local;
			vala_local_variable_set_captured (_tmp682_, TRUE);
			_tmp683_ = block;
			vala_block_set_captured (_tmp683_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp684_;
		_tmp684_ = member;
		if (VALA_IS_PARAMETER (_tmp684_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp685_;
			ValaParameter* _tmp686_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp687_;
			ValaSymbol* _tmp688_;
			ValaSymbol* _tmp689_;
			ValaMethod* _tmp690_;
			gboolean _tmp691_ = FALSE;
			gboolean _tmp692_ = FALSE;
			ValaMethod* _tmp693_;
			_tmp685_ = member;
			_tmp686_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp685_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp686_;
			_tmp687_ = param;
			_tmp688_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp687_);
			_tmp689_ = _tmp688_;
			_tmp690_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp689_) ? ((ValaMethod*) _tmp689_) : NULL);
			m = _tmp690_;
			_tmp693_ = m;
			if (_tmp693_ != NULL) {
				ValaMethod* _tmp694_;
				ValaSemanticAnalyzer* _tmp695_;
				ValaSemanticAnalyzer* _tmp696_;
				ValaSymbol* _tmp697_;
				ValaSymbol* _tmp698_;
				_tmp694_ = m;
				_tmp695_ = vala_code_context_get_analyzer (context);
				_tmp696_ = _tmp695_;
				_tmp697_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp696_);
				_tmp698_ = _tmp697_;
				_tmp692_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp694_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp698_;
			} else {
				_tmp692_ = FALSE;
			}
			if (_tmp692_) {
				ValaParameter* _tmp699_;
				ValaMethod* _tmp700_;
				ValaParameter* _tmp701_;
				ValaParameter* _tmp702_;
				_tmp699_ = param;
				_tmp700_ = m;
				_tmp701_ = vala_method_get_this_parameter (_tmp700_);
				_tmp702_ = _tmp701_;
				_tmp691_ = _tmp699_ != _tmp702_;
			} else {
				_tmp691_ = FALSE;
			}
			if (_tmp691_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp703_;
				ValaSemanticAnalyzer* _tmp704_;
				ValaSymbol* _tmp705_;
				ValaSymbol* _tmp706_;
				ValaSymbol* _tmp707_;
				ValaParameter* _tmp718_;
				ValaMethod* _tmp719_;
				ValaBlock* _tmp720_;
				ValaBlock* _tmp721_;
				ValaParameter* _tmp722_;
				ValaParameterDirection _tmp723_;
				ValaParameterDirection _tmp724_;
				_tmp703_ = vala_code_context_get_analyzer (context);
				_tmp704_ = _tmp703_;
				_tmp705_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp704_);
				_tmp706_ = _tmp705_;
				_tmp707_ = _vala_code_node_ref0 (_tmp706_);
				sym = _tmp707_;
				while (TRUE) {
					ValaSymbol* _tmp708_;
					ValaMethod* _tmp709_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp710_;
					ValaMethod* _tmp711_;
					ValaMethod* _tmp712_;
					ValaSymbol* _tmp714_;
					ValaSymbol* _tmp715_;
					ValaSymbol* _tmp716_;
					ValaSymbol* _tmp717_;
					_tmp708_ = sym;
					_tmp709_ = m;
					if (!(_tmp708_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp709_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp710_ = sym;
					_tmp711_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp710_) ? ((ValaMethod*) _tmp710_) : NULL);
					method = _tmp711_;
					_tmp712_ = method;
					if (_tmp712_ != NULL) {
						ValaMethod* _tmp713_;
						_tmp713_ = method;
						vala_method_set_closure (_tmp713_, TRUE);
					}
					_tmp714_ = sym;
					_tmp715_ = vala_symbol_get_parent_symbol (_tmp714_);
					_tmp716_ = _tmp715_;
					_tmp717_ = _vala_code_node_ref0 (_tmp716_);
					_vala_code_node_unref0 (sym);
					sym = _tmp717_;
					_vala_code_node_unref0 (method);
				}
				_tmp718_ = param;
				vala_parameter_set_captured (_tmp718_, TRUE);
				_tmp719_ = m;
				_tmp720_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp719_);
				_tmp721_ = _tmp720_;
				vala_block_set_captured (_tmp721_, TRUE);
				_tmp722_ = param;
				_tmp723_ = vala_parameter_get_direction (_tmp722_);
				_tmp724_ = _tmp723_;
				if (_tmp724_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp725_;
					ValaSourceReference* _tmp726_;
					ValaParameter* _tmp727_;
					gchar* _tmp728_;
					gchar* _tmp729_;
					gchar* _tmp730_;
					gchar* _tmp731_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp725_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp726_ = _tmp725_;
					_tmp727_ = param;
					_tmp728_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp727_);
					_tmp729_ = _tmp728_;
					_tmp730_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp729_);
					_tmp731_ = _tmp730_;
					vala_report_error (_tmp726_, _tmp731_);
					_g_free0 (_tmp731_);
					_g_free0 (_tmp729_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp732_;
				ValaSymbol* _tmp733_;
				ValaSymbol* _tmp734_;
				ValaSymbol* _tmp735_;
				ValaSymbol* _tmp736_;
				ValaPropertyAccessor* _tmp737_;
				gboolean _tmp738_ = FALSE;
				gboolean _tmp739_ = FALSE;
				ValaPropertyAccessor* _tmp740_;
				_tmp732_ = param;
				_tmp733_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp732_);
				_tmp734_ = _tmp733_;
				_tmp735_ = vala_symbol_get_parent_symbol (_tmp734_);
				_tmp736_ = _tmp735_;
				_tmp737_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp736_) ? ((ValaPropertyAccessor*) _tmp736_) : NULL);
				acc = _tmp737_;
				_tmp740_ = acc;
				if (_tmp740_ != NULL) {
					ValaPropertyAccessor* _tmp741_;
					ValaSemanticAnalyzer* _tmp742_;
					ValaSemanticAnalyzer* _tmp743_;
					ValaSymbol* _tmp744_;
					ValaSymbol* _tmp745_;
					_tmp741_ = acc;
					_tmp742_ = vala_code_context_get_analyzer (context);
					_tmp743_ = _tmp742_;
					_tmp744_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp743_);
					_tmp745_ = _tmp744_;
					_tmp739_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp741_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp745_;
				} else {
					_tmp739_ = FALSE;
				}
				if (_tmp739_) {
					ValaParameter* _tmp746_;
					ValaPropertyAccessor* _tmp747_;
					ValaProperty* _tmp748_;
					ValaProperty* _tmp749_;
					ValaParameter* _tmp750_;
					ValaParameter* _tmp751_;
					_tmp746_ = param;
					_tmp747_ = acc;
					_tmp748_ = vala_property_accessor_get_prop (_tmp747_);
					_tmp749_ = _tmp748_;
					_tmp750_ = vala_property_get_this_parameter (_tmp749_);
					_tmp751_ = _tmp750_;
					_tmp738_ = _tmp746_ != _tmp751_;
				} else {
					_tmp738_ = FALSE;
				}
				if (_tmp738_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp752_;
					ValaSemanticAnalyzer* _tmp753_;
					ValaSymbol* _tmp754_;
					ValaSymbol* _tmp755_;
					ValaSymbol* _tmp756_;
					ValaParameter* _tmp767_;
					ValaPropertyAccessor* _tmp768_;
					ValaBlock* _tmp769_;
					ValaBlock* _tmp770_;
					_tmp752_ = vala_code_context_get_analyzer (context);
					_tmp753_ = _tmp752_;
					_tmp754_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp753_);
					_tmp755_ = _tmp754_;
					_tmp756_ = _vala_code_node_ref0 (_tmp755_);
					sym = _tmp756_;
					while (TRUE) {
						ValaSymbol* _tmp757_;
						ValaMethod* _tmp758_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp759_;
						ValaMethod* _tmp760_;
						ValaMethod* _tmp761_;
						ValaSymbol* _tmp763_;
						ValaSymbol* _tmp764_;
						ValaSymbol* _tmp765_;
						ValaSymbol* _tmp766_;
						_tmp757_ = sym;
						_tmp758_ = m;
						if (!(_tmp757_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp758_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp759_ = sym;
						_tmp760_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp759_) ? ((ValaMethod*) _tmp759_) : NULL);
						method = _tmp760_;
						_tmp761_ = method;
						if (_tmp761_ != NULL) {
							ValaMethod* _tmp762_;
							_tmp762_ = method;
							vala_method_set_closure (_tmp762_, TRUE);
						}
						_tmp763_ = sym;
						_tmp764_ = vala_symbol_get_parent_symbol (_tmp763_);
						_tmp765_ = _tmp764_;
						_tmp766_ = _vala_code_node_ref0 (_tmp765_);
						_vala_code_node_unref0 (sym);
						sym = _tmp766_;
						_vala_code_node_unref0 (method);
					}
					_tmp767_ = param;
					vala_parameter_set_captured (_tmp767_, TRUE);
					_tmp768_ = acc;
					_tmp769_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp768_);
					_tmp770_ = _tmp769_;
					vala_block_set_captured (_tmp770_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp771_;
			_tmp771_ = member;
			if (VALA_IS_FIELD (_tmp771_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp772_;
				ValaField* _tmp773_;
				ValaField* _tmp774_;
				ValaSymbolAccessibility _tmp775_;
				ValaSymbolAccessibility _tmp776_;
				ValaField* _tmp777_;
				ValaMemberBinding _tmp778_;
				ValaMemberBinding _tmp779_;
				ValaField* _tmp780_;
				ValaMemberBinding _tmp781_;
				ValaMemberBinding _tmp782_;
				ValaField* _tmp783_;
				ValaDataType* _tmp784_;
				ValaDataType* _tmp785_;
				_tmp772_ = member;
				_tmp773_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp772_, VALA_TYPE_FIELD, ValaField));
				f = _tmp773_;
				_tmp774_ = f;
				_tmp775_ = vala_symbol_get_access ((ValaSymbol*) _tmp774_);
				_tmp776_ = _tmp775_;
				access = _tmp776_;
				_tmp777_ = f;
				_tmp778_ = vala_field_get_binding (_tmp777_);
				_tmp779_ = _tmp778_;
				instance = _tmp779_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp780_ = f;
				_tmp781_ = vala_field_get_binding (_tmp780_);
				_tmp782_ = _tmp781_;
				klass = _tmp782_ == VALA_MEMBER_BINDING_CLASS;
				_tmp783_ = f;
				_tmp784_ = vala_variable_get_variable_type ((ValaVariable*) _tmp783_);
				_tmp785_ = _tmp784_;
				if (VALA_IS_GENERIC_TYPE (_tmp785_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp786_;
				_tmp786_ = member;
				if (VALA_IS_CONSTANT (_tmp786_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp787_;
					ValaConstant* _tmp788_;
					ValaConstant* _tmp789_;
					ValaSymbolAccessibility _tmp790_;
					ValaSymbolAccessibility _tmp791_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp792_;
					ValaSymbol* _tmp793_;
					ValaSymbol* _tmp794_;
					ValaBlock* _tmp795_;
					gboolean _tmp796_ = FALSE;
					ValaBlock* _tmp797_;
					_tmp787_ = member;
					_tmp788_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp787_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp788_;
					_tmp789_ = c;
					_tmp790_ = vala_symbol_get_access ((ValaSymbol*) _tmp789_);
					_tmp791_ = _tmp790_;
					access = _tmp791_;
					_tmp792_ = c;
					_tmp793_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp792_);
					_tmp794_ = _tmp793_;
					_tmp795_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp794_) ? ((ValaBlock*) _tmp794_) : NULL);
					block = _tmp795_;
					_tmp797_ = block;
					if (_tmp797_ != NULL) {
						ValaSemanticAnalyzer* _tmp798_;
						ValaSemanticAnalyzer* _tmp799_;
						ValaBlock* _tmp800_;
						ValaSymbol* _tmp801_;
						ValaSymbol* _tmp802_;
						ValaSemanticAnalyzer* _tmp803_;
						ValaSemanticAnalyzer* _tmp804_;
						ValaSymbol* _tmp805_;
						ValaSymbol* _tmp806_;
						_tmp798_ = vala_code_context_get_analyzer (context);
						_tmp799_ = _tmp798_;
						_tmp800_ = block;
						_tmp801_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp799_, (ValaSymbol*) _tmp800_);
						_tmp802_ = _tmp801_;
						_tmp803_ = vala_code_context_get_analyzer (context);
						_tmp804_ = _tmp803_;
						_tmp805_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp804_);
						_tmp806_ = _tmp805_;
						_tmp796_ = _tmp802_ != _tmp806_;
						_vala_code_node_unref0 (_tmp802_);
					} else {
						_tmp796_ = FALSE;
					}
					if (_tmp796_) {
						ValaSourceReference* _tmp807_;
						ValaSourceReference* _tmp808_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp807_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp808_ = _tmp807_;
						vala_report_error (_tmp808_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp809_;
					_tmp809_ = member;
					if (VALA_IS_METHOD (_tmp809_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp810_;
						ValaMethod* _tmp811_;
						ValaMethod* _tmp812_;
						gboolean _tmp813_;
						gboolean _tmp814_;
						ValaMethod* _tmp917_;
						ValaSymbolAccessibility _tmp918_;
						ValaSymbolAccessibility _tmp919_;
						ValaMethod* _tmp920_;
						ValaMethod* _tmp924_;
						ValaMemberBinding _tmp925_;
						ValaMemberBinding _tmp926_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp949_;
						ValaDataType* _tmp950_;
						ValaDataType* _tmp951_;
						ValaGenericType* _tmp952_;
						gboolean _tmp953_ = FALSE;
						ValaGenericType* _tmp954_;
						_tmp810_ = member;
						_tmp811_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp810_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp811_;
						_tmp812_ = m;
						_tmp813_ = vala_method_get_is_async_callback (_tmp812_);
						_tmp814_ = _tmp813_;
						if (_tmp814_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp815_;
							ValaSemanticAnalyzer* _tmp816_;
							ValaMethod* _tmp817_;
							ValaMethod* _tmp818_;
							ValaMethod* _tmp819_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp820_;
							gboolean _tmp846_;
							ValaMethod* _tmp854_;
							ValaSemanticAnalyzer* _tmp855_;
							ValaSemanticAnalyzer* _tmp856_;
							ValaMethod* _tmp857_;
							ValaMethod* _tmp858_;
							ValaMethod* _tmp877_;
							ValaMethod* _tmp878_;
							ValaMethod* _tmp879_;
							ValaSymbol* _tmp880_;
							ValaSymbol* _tmp881_;
							ValaSymbol* _tmp882_;
							_tmp815_ = vala_code_context_get_analyzer (context);
							_tmp816_ = _tmp815_;
							_tmp817_ = vala_semantic_analyzer_get_current_async_method (_tmp816_);
							_tmp818_ = _tmp817_;
							_tmp819_ = _vala_code_node_ref0 (_tmp818_);
							async_method = _tmp819_;
							is_valid_access = FALSE;
							_tmp820_ = async_method;
							if (_tmp820_ != NULL) {
								ValaMethod* _tmp821_;
								ValaMethod* _tmp822_;
								ValaMethod* _tmp823_;
								ValaMethod* _tmp824_;
								gboolean _tmp825_;
								_tmp821_ = m;
								_tmp822_ = async_method;
								_tmp823_ = vala_method_get_callback_method (_tmp822_);
								_tmp824_ = _tmp823_;
								_tmp825_ = _tmp821_ == _tmp824_;
								_vala_code_node_unref0 (_tmp824_);
								if (_tmp825_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp826_ = FALSE;
									ValaMethod* _tmp827_;
									ValaMethod* _tmp828_;
									ValaMethod* _tmp829_;
									_tmp827_ = async_method;
									_tmp828_ = vala_method_get_base_method (_tmp827_);
									_tmp829_ = _tmp828_;
									if (_tmp829_ != NULL) {
										ValaMethod* _tmp830_;
										ValaMethod* _tmp831_;
										ValaMethod* _tmp832_;
										ValaMethod* _tmp833_;
										ValaMethod* _tmp834_;
										ValaMethod* _tmp835_;
										_tmp830_ = m;
										_tmp831_ = async_method;
										_tmp832_ = vala_method_get_base_method (_tmp831_);
										_tmp833_ = _tmp832_;
										_tmp834_ = vala_method_get_callback_method (_tmp833_);
										_tmp835_ = _tmp834_;
										_tmp826_ = _tmp830_ == _tmp835_;
										_vala_code_node_unref0 (_tmp835_);
									} else {
										_tmp826_ = FALSE;
									}
									if (_tmp826_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp836_ = FALSE;
										ValaMethod* _tmp837_;
										ValaMethod* _tmp838_;
										ValaMethod* _tmp839_;
										_tmp837_ = async_method;
										_tmp838_ = vala_method_get_base_interface_method (_tmp837_);
										_tmp839_ = _tmp838_;
										if (_tmp839_ != NULL) {
											ValaMethod* _tmp840_;
											ValaMethod* _tmp841_;
											ValaMethod* _tmp842_;
											ValaMethod* _tmp843_;
											ValaMethod* _tmp844_;
											ValaMethod* _tmp845_;
											_tmp840_ = m;
											_tmp841_ = async_method;
											_tmp842_ = vala_method_get_base_interface_method (_tmp841_);
											_tmp843_ = _tmp842_;
											_tmp844_ = vala_method_get_callback_method (_tmp843_);
											_tmp845_ = _tmp844_;
											_tmp836_ = _tmp840_ == _tmp845_;
											_vala_code_node_unref0 (_tmp845_);
										} else {
											_tmp836_ = FALSE;
										}
										if (_tmp836_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							_tmp846_ = is_valid_access;
							if (!_tmp846_) {
								ValaSourceReference* _tmp847_;
								ValaSourceReference* _tmp848_;
								ValaMethod* _tmp849_;
								gchar* _tmp850_;
								gchar* _tmp851_;
								gchar* _tmp852_;
								gchar* _tmp853_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp847_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp848_ = _tmp847_;
								_tmp849_ = m;
								_tmp850_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp849_);
								_tmp851_ = _tmp850_;
								_tmp852_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp851_);
								_tmp853_ = _tmp852_;
								vala_report_error (_tmp848_, _tmp853_);
								_g_free0 (_tmp853_);
								_g_free0 (_tmp851_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp854_ = async_method;
							_tmp855_ = vala_code_context_get_analyzer (context);
							_tmp856_ = _tmp855_;
							_tmp857_ = vala_semantic_analyzer_get_current_method (_tmp856_);
							_tmp858_ = _tmp857_;
							if (_tmp854_ != _tmp858_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp859_;
								ValaSemanticAnalyzer* _tmp860_;
								ValaMethod* _tmp861_;
								ValaMethod* _tmp862_;
								ValaSymbol* _tmp863_;
								ValaMethod* _tmp874_;
								ValaBlock* _tmp875_;
								ValaBlock* _tmp876_;
								_tmp859_ = vala_code_context_get_analyzer (context);
								_tmp860_ = _tmp859_;
								_tmp861_ = vala_semantic_analyzer_get_current_method (_tmp860_);
								_tmp862_ = _tmp861_;
								_tmp863_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp862_);
								sym = _tmp863_;
								while (TRUE) {
									ValaSymbol* _tmp864_;
									ValaMethod* _tmp865_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp866_;
									ValaMethod* _tmp867_;
									ValaMethod* _tmp868_;
									ValaSymbol* _tmp870_;
									ValaSymbol* _tmp871_;
									ValaSymbol* _tmp872_;
									ValaSymbol* _tmp873_;
									_tmp864_ = sym;
									_tmp865_ = async_method;
									if (!(_tmp864_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp865_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp866_ = sym;
									_tmp867_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp866_) ? ((ValaMethod*) _tmp866_) : NULL);
									method = _tmp867_;
									_tmp868_ = method;
									if (_tmp868_ != NULL) {
										ValaMethod* _tmp869_;
										_tmp869_ = method;
										vala_method_set_closure (_tmp869_, TRUE);
									}
									_tmp870_ = sym;
									_tmp871_ = vala_symbol_get_parent_symbol (_tmp870_);
									_tmp872_ = _tmp871_;
									_tmp873_ = _vala_code_node_ref0 (_tmp872_);
									_vala_code_node_unref0 (sym);
									sym = _tmp873_;
									_vala_code_node_unref0 (method);
								}
								_tmp874_ = async_method;
								_tmp875_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp874_);
								_tmp876_ = _tmp875_;
								vala_block_set_captured (_tmp876_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp877_ = async_method;
							_tmp878_ = vala_method_get_callback_method (_tmp877_);
							_vala_code_node_unref0 (m);
							m = _tmp878_;
							_tmp879_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp879_);
							_tmp880_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp881_ = _tmp880_;
							_tmp882_ = _vala_code_node_ref0 (_tmp881_);
							_vala_code_node_unref0 (member);
							member = _tmp882_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp883_;
							ValaMethod* _tmp884_;
							ValaMethod* _tmp885_;
							_tmp883_ = m;
							_tmp884_ = vala_method_get_base_method (_tmp883_);
							_tmp885_ = _tmp884_;
							if (_tmp885_ != NULL) {
								ValaMethod* _tmp886_;
								ValaMethod* _tmp887_;
								ValaMethod* _tmp888_;
								ValaMethod* _tmp889_;
								ValaMethod* _tmp890_;
								ValaSignal* _tmp891_;
								ValaSignal* _tmp892_;
								ValaSymbol* _tmp897_;
								ValaSymbol* _tmp898_;
								ValaSymbol* _tmp899_;
								_tmp886_ = m;
								_tmp887_ = vala_method_get_base_method (_tmp886_);
								_tmp888_ = _tmp887_;
								_tmp889_ = _vala_code_node_ref0 (_tmp888_);
								_vala_code_node_unref0 (m);
								m = _tmp889_;
								_tmp890_ = m;
								_tmp891_ = vala_method_get_signal_reference (_tmp890_);
								_tmp892_ = _tmp891_;
								if (_tmp892_ != NULL) {
									ValaMethod* _tmp893_;
									ValaSignal* _tmp894_;
									ValaSignal* _tmp895_;
									_tmp893_ = m;
									_tmp894_ = vala_method_get_signal_reference (_tmp893_);
									_tmp895_ = _tmp894_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp895_);
								} else {
									ValaMethod* _tmp896_;
									_tmp896_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp896_);
								}
								_tmp897_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp898_ = _tmp897_;
								_tmp899_ = _vala_code_node_ref0 (_tmp898_);
								_vala_code_node_unref0 (member);
								member = _tmp899_;
							} else {
								ValaMethod* _tmp900_;
								ValaMethod* _tmp901_;
								ValaMethod* _tmp902_;
								_tmp900_ = m;
								_tmp901_ = vala_method_get_base_interface_method (_tmp900_);
								_tmp902_ = _tmp901_;
								if (_tmp902_ != NULL) {
									ValaMethod* _tmp903_;
									ValaMethod* _tmp904_;
									ValaMethod* _tmp905_;
									ValaMethod* _tmp906_;
									ValaMethod* _tmp907_;
									ValaSignal* _tmp908_;
									ValaSignal* _tmp909_;
									ValaSymbol* _tmp914_;
									ValaSymbol* _tmp915_;
									ValaSymbol* _tmp916_;
									_tmp903_ = m;
									_tmp904_ = vala_method_get_base_interface_method (_tmp903_);
									_tmp905_ = _tmp904_;
									_tmp906_ = _vala_code_node_ref0 (_tmp905_);
									_vala_code_node_unref0 (m);
									m = _tmp906_;
									_tmp907_ = m;
									_tmp908_ = vala_method_get_signal_reference (_tmp907_);
									_tmp909_ = _tmp908_;
									if (_tmp909_ != NULL) {
										ValaMethod* _tmp910_;
										ValaSignal* _tmp911_;
										ValaSignal* _tmp912_;
										_tmp910_ = m;
										_tmp911_ = vala_method_get_signal_reference (_tmp910_);
										_tmp912_ = _tmp911_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp912_);
									} else {
										ValaMethod* _tmp913_;
										_tmp913_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp913_);
									}
									_tmp914_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp915_ = _tmp914_;
									_tmp916_ = _vala_code_node_ref0 (_tmp915_);
									_vala_code_node_unref0 (member);
									member = _tmp916_;
								}
							}
						}
						_tmp917_ = m;
						_tmp918_ = vala_symbol_get_access ((ValaSymbol*) _tmp917_);
						_tmp919_ = _tmp918_;
						access = _tmp919_;
						_tmp920_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp920_)) {
							ValaMethod* _tmp921_;
							ValaMemberBinding _tmp922_;
							ValaMemberBinding _tmp923_;
							_tmp921_ = m;
							_tmp922_ = vala_method_get_binding (_tmp921_);
							_tmp923_ = _tmp922_;
							instance = _tmp923_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp924_ = m;
						_tmp925_ = vala_method_get_binding (_tmp924_);
						_tmp926_ = _tmp925_;
						klass = _tmp926_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp927_;
							ValaList* _tmp928_;
							gint _param_size = 0;
							ValaList* _tmp929_;
							gint _tmp930_;
							gint _tmp931_;
							gint _param_index = 0;
							_tmp927_ = m;
							_tmp928_ = vala_callable_get_parameters ((ValaCallable*) _tmp927_);
							_param_list = _tmp928_;
							_tmp929_ = _param_list;
							_tmp930_ = vala_collection_get_size ((ValaCollection*) _tmp929_);
							_tmp931_ = _tmp930_;
							_param_size = _tmp931_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp932_;
								gint _tmp933_;
								gint _tmp934_;
								ValaParameter* param = NULL;
								ValaList* _tmp935_;
								gint _tmp936_;
								gpointer _tmp937_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp938_;
								ValaDataType* _tmp939_;
								ValaDataType* _tmp940_;
								ValaGenericType* _tmp941_;
								gboolean _tmp942_ = FALSE;
								ValaGenericType* _tmp943_;
								_tmp932_ = _param_index;
								_param_index = _tmp932_ + 1;
								_tmp933_ = _param_index;
								_tmp934_ = _param_size;
								if (!(_tmp933_ < _tmp934_)) {
									break;
								}
								_tmp935_ = _param_list;
								_tmp936_ = _param_index;
								_tmp937_ = vala_list_get (_tmp935_, _tmp936_);
								param = (ValaParameter*) _tmp937_;
								_tmp938_ = param;
								_tmp939_ = vala_variable_get_variable_type ((ValaVariable*) _tmp938_);
								_tmp940_ = _tmp939_;
								_tmp941_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp940_) ? ((ValaGenericType*) _tmp940_) : NULL);
								generic_type = _tmp941_;
								_tmp943_ = generic_type;
								if (_tmp943_ != NULL) {
									ValaGenericType* _tmp944_;
									ValaTypeParameter* _tmp945_;
									ValaTypeParameter* _tmp946_;
									ValaSymbol* _tmp947_;
									ValaSymbol* _tmp948_;
									_tmp944_ = generic_type;
									_tmp945_ = vala_generic_type_get_type_parameter (_tmp944_);
									_tmp946_ = _tmp945_;
									_tmp947_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp946_);
									_tmp948_ = _tmp947_;
									_tmp942_ = VALA_IS_TYPESYMBOL (_tmp948_);
								} else {
									_tmp942_ = FALSE;
								}
								if (_tmp942_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp949_ = m;
						_tmp950_ = vala_callable_get_return_type ((ValaCallable*) _tmp949_);
						_tmp951_ = _tmp950_;
						_tmp952_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp951_) ? ((ValaGenericType*) _tmp951_) : NULL);
						generic_type = _tmp952_;
						_tmp954_ = generic_type;
						if (_tmp954_ != NULL) {
							ValaGenericType* _tmp955_;
							ValaTypeParameter* _tmp956_;
							ValaTypeParameter* _tmp957_;
							ValaSymbol* _tmp958_;
							ValaSymbol* _tmp959_;
							_tmp955_ = generic_type;
							_tmp956_ = vala_generic_type_get_type_parameter (_tmp955_);
							_tmp957_ = _tmp956_;
							_tmp958_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp957_);
							_tmp959_ = _tmp958_;
							_tmp953_ = VALA_IS_TYPESYMBOL (_tmp959_);
						} else {
							_tmp953_ = FALSE;
						}
						if (_tmp953_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp960_;
						_tmp960_ = member;
						if (VALA_IS_PROPERTY (_tmp960_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp961_;
							ValaProperty* _tmp962_;
							ValaProperty* _tmp963_;
							ValaProperty* _tmp964_;
							ValaProperty* _tmp965_;
							ValaProperty* _tmp966_;
							ValaProperty* _tmp986_;
							ValaSymbolAccessibility _tmp987_;
							ValaSymbolAccessibility _tmp988_;
							gboolean _tmp989_;
							gboolean _tmp990_;
							ValaProperty* _tmp1055_;
							ValaMemberBinding _tmp1056_;
							ValaMemberBinding _tmp1057_;
							ValaProperty* _tmp1058_;
							ValaDataType* _tmp1059_;
							ValaDataType* _tmp1060_;
							_tmp961_ = member;
							_tmp962_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp961_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp962_;
							_tmp963_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp963_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp964_ = prop;
							_tmp965_ = vala_property_get_base_property (_tmp964_);
							_tmp966_ = _tmp965_;
							if (_tmp966_ != NULL) {
								ValaProperty* _tmp967_;
								ValaProperty* _tmp968_;
								ValaProperty* _tmp969_;
								ValaProperty* _tmp970_;
								ValaProperty* _tmp971_;
								ValaSymbol* _tmp972_;
								ValaSymbol* _tmp973_;
								ValaSymbol* _tmp974_;
								_tmp967_ = prop;
								_tmp968_ = vala_property_get_base_property (_tmp967_);
								_tmp969_ = _tmp968_;
								_tmp970_ = _vala_code_node_ref0 (_tmp969_);
								_vala_code_node_unref0 (prop);
								prop = _tmp970_;
								_tmp971_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp971_);
								_tmp972_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp973_ = _tmp972_;
								_tmp974_ = _vala_code_node_ref0 (_tmp973_);
								_vala_code_node_unref0 (member);
								member = _tmp974_;
							} else {
								ValaProperty* _tmp975_;
								ValaProperty* _tmp976_;
								ValaProperty* _tmp977_;
								_tmp975_ = prop;
								_tmp976_ = vala_property_get_base_interface_property (_tmp975_);
								_tmp977_ = _tmp976_;
								if (_tmp977_ != NULL) {
									ValaProperty* _tmp978_;
									ValaProperty* _tmp979_;
									ValaProperty* _tmp980_;
									ValaProperty* _tmp981_;
									ValaProperty* _tmp982_;
									ValaSymbol* _tmp983_;
									ValaSymbol* _tmp984_;
									ValaSymbol* _tmp985_;
									_tmp978_ = prop;
									_tmp979_ = vala_property_get_base_interface_property (_tmp978_);
									_tmp980_ = _tmp979_;
									_tmp981_ = _vala_code_node_ref0 (_tmp980_);
									_vala_code_node_unref0 (prop);
									prop = _tmp981_;
									_tmp982_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp982_);
									_tmp983_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp984_ = _tmp983_;
									_tmp985_ = _vala_code_node_ref0 (_tmp984_);
									_vala_code_node_unref0 (member);
									member = _tmp985_;
								}
							}
							_tmp986_ = prop;
							_tmp987_ = vala_symbol_get_access ((ValaSymbol*) _tmp986_);
							_tmp988_ = _tmp987_;
							access = _tmp988_;
							_tmp989_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp990_ = _tmp989_;
							if (_tmp990_) {
								ValaProperty* _tmp991_;
								ValaPropertyAccessor* _tmp992_;
								ValaPropertyAccessor* _tmp993_;
								ValaProperty* _tmp1001_;
								ValaSymbolAccessibility _tmp1002_;
								ValaSymbolAccessibility _tmp1003_;
								_tmp991_ = prop;
								_tmp992_ = vala_property_get_set_accessor (_tmp991_);
								_tmp993_ = _tmp992_;
								if (_tmp993_ == NULL) {
									ValaSourceReference* _tmp994_;
									ValaSourceReference* _tmp995_;
									ValaProperty* _tmp996_;
									gchar* _tmp997_;
									gchar* _tmp998_;
									gchar* _tmp999_;
									gchar* _tmp1000_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp994_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp995_ = _tmp994_;
									_tmp996_ = prop;
									_tmp997_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp996_);
									_tmp998_ = _tmp997_;
									_tmp999_ = g_strdup_printf ("Property `%s' is read-only", _tmp998_);
									_tmp1000_ = _tmp999_;
									vala_report_error (_tmp995_, _tmp1000_);
									_g_free0 (_tmp1000_);
									_g_free0 (_tmp998_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1001_ = prop;
								_tmp1002_ = vala_symbol_get_access ((ValaSymbol*) _tmp1001_);
								_tmp1003_ = _tmp1002_;
								if (_tmp1003_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1004_;
									ValaPropertyAccessor* _tmp1005_;
									ValaPropertyAccessor* _tmp1006_;
									ValaSymbolAccessibility _tmp1007_;
									ValaSymbolAccessibility _tmp1008_;
									_tmp1004_ = prop;
									_tmp1005_ = vala_property_get_set_accessor (_tmp1004_);
									_tmp1006_ = _tmp1005_;
									_tmp1007_ = vala_symbol_get_access ((ValaSymbol*) _tmp1006_);
									_tmp1008_ = _tmp1007_;
									access = _tmp1008_;
								} else {
									gboolean _tmp1009_ = FALSE;
									ValaProperty* _tmp1010_;
									ValaSymbolAccessibility _tmp1011_;
									ValaSymbolAccessibility _tmp1012_;
									_tmp1010_ = prop;
									_tmp1011_ = vala_symbol_get_access ((ValaSymbol*) _tmp1010_);
									_tmp1012_ = _tmp1011_;
									if (_tmp1012_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1013_;
										ValaPropertyAccessor* _tmp1014_;
										ValaPropertyAccessor* _tmp1015_;
										ValaSymbolAccessibility _tmp1016_;
										ValaSymbolAccessibility _tmp1017_;
										_tmp1013_ = prop;
										_tmp1014_ = vala_property_get_set_accessor (_tmp1013_);
										_tmp1015_ = _tmp1014_;
										_tmp1016_ = vala_symbol_get_access ((ValaSymbol*) _tmp1015_);
										_tmp1017_ = _tmp1016_;
										_tmp1009_ = _tmp1017_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1009_ = FALSE;
									}
									if (_tmp1009_) {
										ValaProperty* _tmp1018_;
										ValaPropertyAccessor* _tmp1019_;
										ValaPropertyAccessor* _tmp1020_;
										ValaSymbolAccessibility _tmp1021_;
										ValaSymbolAccessibility _tmp1022_;
										_tmp1018_ = prop;
										_tmp1019_ = vala_property_get_set_accessor (_tmp1018_);
										_tmp1020_ = _tmp1019_;
										_tmp1021_ = vala_symbol_get_access ((ValaSymbol*) _tmp1020_);
										_tmp1022_ = _tmp1021_;
										access = _tmp1022_;
									}
								}
							} else {
								ValaProperty* _tmp1023_;
								ValaPropertyAccessor* _tmp1024_;
								ValaPropertyAccessor* _tmp1025_;
								ValaProperty* _tmp1033_;
								ValaSymbolAccessibility _tmp1034_;
								ValaSymbolAccessibility _tmp1035_;
								_tmp1023_ = prop;
								_tmp1024_ = vala_property_get_get_accessor (_tmp1023_);
								_tmp1025_ = _tmp1024_;
								if (_tmp1025_ == NULL) {
									ValaSourceReference* _tmp1026_;
									ValaSourceReference* _tmp1027_;
									ValaProperty* _tmp1028_;
									gchar* _tmp1029_;
									gchar* _tmp1030_;
									gchar* _tmp1031_;
									gchar* _tmp1032_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1026_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1027_ = _tmp1026_;
									_tmp1028_ = prop;
									_tmp1029_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1028_);
									_tmp1030_ = _tmp1029_;
									_tmp1031_ = g_strdup_printf ("Property `%s' is write-only", _tmp1030_);
									_tmp1032_ = _tmp1031_;
									vala_report_error (_tmp1027_, _tmp1032_);
									_g_free0 (_tmp1032_);
									_g_free0 (_tmp1030_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1033_ = prop;
								_tmp1034_ = vala_symbol_get_access ((ValaSymbol*) _tmp1033_);
								_tmp1035_ = _tmp1034_;
								if (_tmp1035_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1036_;
									ValaPropertyAccessor* _tmp1037_;
									ValaPropertyAccessor* _tmp1038_;
									ValaSymbolAccessibility _tmp1039_;
									ValaSymbolAccessibility _tmp1040_;
									_tmp1036_ = prop;
									_tmp1037_ = vala_property_get_get_accessor (_tmp1036_);
									_tmp1038_ = _tmp1037_;
									_tmp1039_ = vala_symbol_get_access ((ValaSymbol*) _tmp1038_);
									_tmp1040_ = _tmp1039_;
									access = _tmp1040_;
								} else {
									gboolean _tmp1041_ = FALSE;
									ValaProperty* _tmp1042_;
									ValaSymbolAccessibility _tmp1043_;
									ValaSymbolAccessibility _tmp1044_;
									_tmp1042_ = prop;
									_tmp1043_ = vala_symbol_get_access ((ValaSymbol*) _tmp1042_);
									_tmp1044_ = _tmp1043_;
									if (_tmp1044_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1045_;
										ValaPropertyAccessor* _tmp1046_;
										ValaPropertyAccessor* _tmp1047_;
										ValaSymbolAccessibility _tmp1048_;
										ValaSymbolAccessibility _tmp1049_;
										_tmp1045_ = prop;
										_tmp1046_ = vala_property_get_get_accessor (_tmp1045_);
										_tmp1047_ = _tmp1046_;
										_tmp1048_ = vala_symbol_get_access ((ValaSymbol*) _tmp1047_);
										_tmp1049_ = _tmp1048_;
										_tmp1041_ = _tmp1049_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1041_ = FALSE;
									}
									if (_tmp1041_) {
										ValaProperty* _tmp1050_;
										ValaPropertyAccessor* _tmp1051_;
										ValaPropertyAccessor* _tmp1052_;
										ValaSymbolAccessibility _tmp1053_;
										ValaSymbolAccessibility _tmp1054_;
										_tmp1050_ = prop;
										_tmp1051_ = vala_property_get_get_accessor (_tmp1050_);
										_tmp1052_ = _tmp1051_;
										_tmp1053_ = vala_symbol_get_access ((ValaSymbol*) _tmp1052_);
										_tmp1054_ = _tmp1053_;
										access = _tmp1054_;
									}
								}
							}
							_tmp1055_ = prop;
							_tmp1056_ = vala_property_get_binding (_tmp1055_);
							_tmp1057_ = _tmp1056_;
							instance = _tmp1057_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1058_ = prop;
							_tmp1059_ = vala_property_get_property_type (_tmp1058_);
							_tmp1060_ = _tmp1059_;
							if (VALA_IS_GENERIC_TYPE (_tmp1060_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1061_;
							_tmp1061_ = member;
							if (VALA_IS_SIGNAL (_tmp1061_)) {
								ValaSymbol* _tmp1062_;
								ValaSymbolAccessibility _tmp1063_;
								ValaSymbolAccessibility _tmp1064_;
								instance = TRUE;
								_tmp1062_ = member;
								_tmp1063_ = vala_symbol_get_access (_tmp1062_);
								_tmp1064_ = _tmp1063_;
								access = _tmp1064_;
							} else {
								gboolean _tmp1065_ = FALSE;
								gboolean _tmp1066_;
								_tmp1066_ = self->priv->_creation_member;
								if (!_tmp1066_) {
									ValaSymbol* _tmp1067_;
									_tmp1067_ = member;
									_tmp1065_ = VALA_IS_ERROR_CODE (_tmp1067_);
								} else {
									_tmp1065_ = FALSE;
								}
								if (_tmp1065_) {
									ValaSymbol* _tmp1068_;
									ValaConstant* _tmp1069_;
									ValaConstant* _tmp1070_;
									ValaSymbol* _tmp1071_;
									ValaSymbol* _tmp1072_;
									ValaSymbol* _tmp1073_;
									_tmp1068_ = member;
									_tmp1069_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1068_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1070_ = _tmp1069_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1070_);
									_tmp1071_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1072_ = _tmp1071_;
									_tmp1073_ = _vala_code_node_ref0 (_tmp1072_);
									_vala_code_node_unref0 (member);
									member = _tmp1073_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1074_ = member;
	vala_symbol_set_used (_tmp1074_, TRUE);
	_tmp1075_ = member;
	_tmp1076_ = vala_symbol_get_version (_tmp1075_);
	_tmp1077_ = _tmp1076_;
	_tmp1078_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1079_ = _tmp1078_;
	vala_version_attribute_check (_tmp1077_, _tmp1079_);
	_tmp1081_ = access;
	if (_tmp1081_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1082_;
		ValaSymbol* _tmp1083_;
		ValaSymbol* _tmp1084_;
		_tmp1082_ = member;
		_tmp1083_ = vala_symbol_get_parent_symbol (_tmp1082_);
		_tmp1084_ = _tmp1083_;
		_tmp1080_ = VALA_IS_TYPESYMBOL (_tmp1084_);
	} else {
		_tmp1080_ = FALSE;
	}
	if (_tmp1080_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1085_;
		ValaSymbol* _tmp1086_;
		ValaSymbol* _tmp1087_;
		ValaTypeSymbol* _tmp1088_;
		gboolean in_subtype = FALSE;
		gboolean _tmp1108_;
		_tmp1085_ = member;
		_tmp1086_ = vala_symbol_get_parent_symbol (_tmp1085_);
		_tmp1087_ = _tmp1086_;
		_tmp1088_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1087_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1088_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1089_;
			ValaSemanticAnalyzer* _tmp1090_;
			ValaSymbol* _tmp1091_;
			ValaSymbol* _tmp1092_;
			ValaSymbol* _tmp1093_;
			_tmp1089_ = vala_code_context_get_analyzer (context);
			_tmp1090_ = _tmp1089_;
			_tmp1091_ = vala_semantic_analyzer_get_current_symbol (_tmp1090_);
			_tmp1092_ = _tmp1091_;
			_tmp1093_ = _vala_code_node_ref0 (_tmp1092_);
			this_symbol = _tmp1093_;
			{
				gboolean _tmp1094_ = FALSE;
				_tmp1094_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1099_;
					ValaSymbol* _tmp1100_;
					ValaTypeSymbol* _tmp1101_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1102_;
					ValaClass* _tmp1103_;
					gboolean _tmp1104_ = FALSE;
					ValaClass* _tmp1105_;
					if (!_tmp1094_) {
						ValaSymbol* _tmp1095_;
						ValaSymbol* _tmp1096_;
						ValaSymbol* _tmp1097_;
						ValaSymbol* _tmp1098_;
						_tmp1095_ = this_symbol;
						_tmp1096_ = vala_symbol_get_parent_symbol (_tmp1095_);
						_tmp1097_ = _tmp1096_;
						_tmp1098_ = _vala_code_node_ref0 (_tmp1097_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1098_;
					}
					_tmp1094_ = FALSE;
					_tmp1099_ = this_symbol;
					if (!(_tmp1099_ != NULL)) {
						break;
					}
					_tmp1100_ = this_symbol;
					_tmp1101_ = target_type;
					if (_tmp1100_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1101_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1102_ = this_symbol;
					_tmp1103_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1102_) ? ((ValaClass*) _tmp1102_) : NULL);
					cl = _tmp1103_;
					_tmp1105_ = cl;
					if (_tmp1105_ != NULL) {
						ValaClass* _tmp1106_;
						ValaTypeSymbol* _tmp1107_;
						_tmp1106_ = cl;
						_tmp1107_ = target_type;
						_tmp1104_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1106_, _tmp1107_);
					} else {
						_tmp1104_ = FALSE;
					}
					if (_tmp1104_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		_tmp1108_ = in_subtype;
		if (!_tmp1108_) {
			ValaSourceReference* _tmp1109_;
			ValaSourceReference* _tmp1110_;
			ValaSymbol* _tmp1111_;
			gchar* _tmp1112_;
			gchar* _tmp1113_;
			gchar* _tmp1114_;
			gchar* _tmp1115_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1109_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1110_ = _tmp1109_;
			_tmp1111_ = member;
			_tmp1112_ = vala_symbol_get_full_name (_tmp1111_);
			_tmp1113_ = _tmp1112_;
			_tmp1114_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1113_);
			_tmp1115_ = _tmp1114_;
			vala_report_error (_tmp1110_, _tmp1115_);
			_g_free0 (_tmp1115_);
			_g_free0 (_tmp1113_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1116_;
		_tmp1116_ = access;
		if (_tmp1116_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1117_;
			ValaSymbol* _tmp1118_;
			ValaSymbol* _tmp1119_;
			ValaSymbol* _tmp1120_;
			gboolean in_target_type = FALSE;
			gboolean _tmp1134_;
			_tmp1117_ = member;
			_tmp1118_ = vala_symbol_get_parent_symbol (_tmp1117_);
			_tmp1119_ = _tmp1118_;
			_tmp1120_ = _vala_code_node_ref0 (_tmp1119_);
			target_type = _tmp1120_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1121_;
				ValaSemanticAnalyzer* _tmp1122_;
				ValaSymbol* _tmp1123_;
				ValaSymbol* _tmp1124_;
				ValaSymbol* _tmp1125_;
				_tmp1121_ = vala_code_context_get_analyzer (context);
				_tmp1122_ = _tmp1121_;
				_tmp1123_ = vala_semantic_analyzer_get_current_symbol (_tmp1122_);
				_tmp1124_ = _tmp1123_;
				_tmp1125_ = _vala_code_node_ref0 (_tmp1124_);
				this_symbol = _tmp1125_;
				{
					gboolean _tmp1126_ = FALSE;
					_tmp1126_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1131_;
						ValaSymbol* _tmp1132_;
						ValaSymbol* _tmp1133_;
						if (!_tmp1126_) {
							ValaSymbol* _tmp1127_;
							ValaSymbol* _tmp1128_;
							ValaSymbol* _tmp1129_;
							ValaSymbol* _tmp1130_;
							_tmp1127_ = this_symbol;
							_tmp1128_ = vala_symbol_get_parent_symbol (_tmp1127_);
							_tmp1129_ = _tmp1128_;
							_tmp1130_ = _vala_code_node_ref0 (_tmp1129_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1130_;
						}
						_tmp1126_ = FALSE;
						_tmp1131_ = this_symbol;
						if (!(_tmp1131_ != NULL)) {
							break;
						}
						_tmp1132_ = target_type;
						_tmp1133_ = this_symbol;
						if (_tmp1132_ == _tmp1133_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp1134_ = in_target_type;
			if (!_tmp1134_) {
				ValaSourceReference* _tmp1135_;
				ValaSourceReference* _tmp1136_;
				ValaSymbol* _tmp1137_;
				gchar* _tmp1138_;
				gchar* _tmp1139_;
				gchar* _tmp1140_;
				gchar* _tmp1141_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1135_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1136_ = _tmp1135_;
				_tmp1137_ = member;
				_tmp1138_ = vala_symbol_get_full_name (_tmp1137_);
				_tmp1139_ = _tmp1138_;
				_tmp1140_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1139_);
				_tmp1141_ = _tmp1140_;
				vala_report_error (_tmp1136_, _tmp1141_);
				_g_free0 (_tmp1141_);
				_g_free0 (_tmp1139_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	_tmp1143_ = generics;
	if (_tmp1143_) {
		ValaExpression* _tmp1144_;
		ValaExpression* _tmp1145_;
		_tmp1144_ = vala_member_access_get_inner (self);
		_tmp1145_ = _tmp1144_;
		_tmp1142_ = _tmp1145_ != NULL;
	} else {
		_tmp1142_ = FALSE;
	}
	if (_tmp1142_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1146_;
		ValaExpression* _tmp1147_;
		ValaDataType* _tmp1148_;
		ValaDataType* _tmp1149_;
		ValaDataType* _tmp1150_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1151_;
		ValaExpression* _tmp1152_;
		ValaDataType* _tmp1153_;
		ValaDataType* _tmp1154_;
		ValaPointerType* _tmp1155_;
		ValaPointerType* _tmp1156_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1161_;
		ValaObjectType* _tmp1162_;
		gboolean _tmp1163_ = FALSE;
		gboolean _tmp1164_ = FALSE;
		ValaObjectType* _tmp1165_;
		_tmp1146_ = vala_member_access_get_inner (self);
		_tmp1147_ = _tmp1146_;
		_tmp1148_ = vala_expression_get_value_type (_tmp1147_);
		_tmp1149_ = _tmp1148_;
		_tmp1150_ = _vala_code_node_ref0 (_tmp1149_);
		instance_type = _tmp1150_;
		_tmp1151_ = vala_member_access_get_inner (self);
		_tmp1152_ = _tmp1151_;
		_tmp1153_ = vala_expression_get_value_type (_tmp1152_);
		_tmp1154_ = _tmp1153_;
		_tmp1155_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1154_) ? ((ValaPointerType*) _tmp1154_) : NULL);
		pointer_type = _tmp1155_;
		_tmp1156_ = pointer_type;
		if (_tmp1156_ != NULL) {
			ValaPointerType* _tmp1157_;
			ValaDataType* _tmp1158_;
			ValaDataType* _tmp1159_;
			ValaDataType* _tmp1160_;
			_tmp1157_ = pointer_type;
			_tmp1158_ = vala_pointer_type_get_base_type (_tmp1157_);
			_tmp1159_ = _tmp1158_;
			_tmp1160_ = _vala_code_node_ref0 (_tmp1159_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1160_;
		}
		_tmp1161_ = instance_type;
		_tmp1162_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1161_) ? ((ValaObjectType*) _tmp1161_) : NULL);
		object_type = _tmp1162_;
		_tmp1165_ = object_type;
		if (_tmp1165_ != NULL) {
			ValaObjectType* _tmp1166_;
			ValaObjectTypeSymbol* _tmp1167_;
			ValaObjectTypeSymbol* _tmp1168_;
			ValaList* _tmp1169_;
			ValaList* _tmp1170_;
			gint _tmp1171_;
			gint _tmp1172_;
			_tmp1166_ = object_type;
			_tmp1167_ = vala_object_type_get_type_symbol (_tmp1166_);
			_tmp1168_ = _tmp1167_;
			_tmp1169_ = vala_object_type_symbol_get_type_parameters (_tmp1168_);
			_tmp1170_ = _tmp1169_;
			_tmp1171_ = vala_collection_get_size ((ValaCollection*) _tmp1170_);
			_tmp1172_ = _tmp1171_;
			_tmp1164_ = _tmp1172_ > 0;
			_vala_iterable_unref0 (_tmp1170_);
		} else {
			_tmp1164_ = FALSE;
		}
		if (_tmp1164_) {
			ValaDataType* _tmp1173_;
			ValaList* _tmp1174_;
			ValaList* _tmp1175_;
			gint _tmp1176_;
			gint _tmp1177_;
			_tmp1173_ = instance_type;
			_tmp1174_ = vala_data_type_get_type_arguments (_tmp1173_);
			_tmp1175_ = _tmp1174_;
			_tmp1176_ = vala_collection_get_size ((ValaCollection*) _tmp1175_);
			_tmp1177_ = _tmp1176_;
			_tmp1163_ = _tmp1177_ == 0;
			_vala_iterable_unref0 (_tmp1175_);
		} else {
			_tmp1163_ = FALSE;
		}
		if (_tmp1163_) {
			ValaExpression* _tmp1178_;
			ValaExpression* _tmp1179_;
			ValaSourceReference* _tmp1180_;
			ValaSourceReference* _tmp1181_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1178_ = vala_member_access_get_inner (self);
			_tmp1179_ = _tmp1178_;
			_tmp1180_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1179_);
			_tmp1181_ = _tmp1180_;
			vala_report_error (_tmp1181_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	_tmp1184_ = instance;
	if (_tmp1184_) {
		gboolean _tmp1185_;
		_tmp1185_ = may_access_instance_members;
		_tmp1183_ = !_tmp1185_;
	} else {
		_tmp1183_ = FALSE;
	}
	if (_tmp1183_) {
		_tmp1182_ = TRUE;
	} else {
		gboolean _tmp1186_ = FALSE;
		gboolean _tmp1187_;
		_tmp1187_ = klass;
		if (_tmp1187_) {
			gboolean _tmp1188_;
			_tmp1188_ = may_access_klass_members;
			_tmp1186_ = !_tmp1188_;
		} else {
			_tmp1186_ = FALSE;
		}
		_tmp1182_ = _tmp1186_;
	}
	if (_tmp1182_) {
		ValaSymbol* _tmp1189_;
		ValaSymbol* _tmp1190_;
		ValaDataType* _tmp1213_;
		ValaDataType* _tmp1214_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1189_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1190_ = _tmp1189_;
		if (VALA_IS_METHOD (_tmp1190_)) {
			ValaSemanticAnalyzer* _tmp1191_;
			ValaSemanticAnalyzer* _tmp1192_;
			ValaSymbol* _tmp1193_;
			ValaSymbol* _tmp1194_;
			gboolean _tmp1195_;
			gboolean _tmp1196_;
			ValaDataType* _tmp1197_;
			ValaDataType* _tmp1198_;
			_tmp1191_ = vala_code_context_get_analyzer (context);
			_tmp1192_ = _tmp1191_;
			_tmp1193_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1194_ = _tmp1193_;
			_tmp1195_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1196_ = _tmp1195_;
			_tmp1197_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1192_, _tmp1194_, _tmp1196_);
			_tmp1198_ = _tmp1197_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1198_);
			_vala_code_node_unref0 (_tmp1198_);
		} else {
			ValaSymbol* _tmp1199_;
			ValaSymbol* _tmp1200_;
			_tmp1199_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1200_ = _tmp1199_;
			if (VALA_IS_FIELD (_tmp1200_)) {
				ValaSymbol* _tmp1201_;
				ValaSymbol* _tmp1202_;
				ValaFieldPrototype* _tmp1203_;
				ValaFieldPrototype* _tmp1204_;
				_tmp1201_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1202_ = _tmp1201_;
				_tmp1203_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1202_, VALA_TYPE_FIELD, ValaField));
				_tmp1204_ = _tmp1203_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1204_);
				_vala_code_node_unref0 (_tmp1204_);
			} else {
				ValaSymbol* _tmp1205_;
				ValaSymbol* _tmp1206_;
				_tmp1205_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1206_ = _tmp1205_;
				if (VALA_IS_PROPERTY (_tmp1206_)) {
					ValaSymbol* _tmp1207_;
					ValaSymbol* _tmp1208_;
					ValaPropertyPrototype* _tmp1209_;
					ValaPropertyPrototype* _tmp1210_;
					_tmp1207_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1208_ = _tmp1207_;
					_tmp1209_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1208_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1210_ = _tmp1209_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1210_);
					_vala_code_node_unref0 (_tmp1210_);
				} else {
					ValaInvalidType* _tmp1211_;
					ValaInvalidType* _tmp1212_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp1211_ = vala_invalid_type_new ();
					_tmp1212_ = _tmp1211_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1212_);
					_vala_code_node_unref0 (_tmp1212_);
				}
			}
		}
		_tmp1213_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1214_ = _tmp1213_;
		if (_tmp1214_ != NULL) {
			ValaDataType* _tmp1215_;
			ValaDataType* _tmp1216_;
			ValaDataType* _tmp1217_;
			ValaDataType* _tmp1218_;
			gboolean _tmp1219_;
			gboolean _tmp1220_;
			_tmp1215_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1216_ = _tmp1215_;
			_tmp1217_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1218_ = _tmp1217_;
			_tmp1219_ = vala_data_type_get_value_owned (_tmp1218_);
			_tmp1220_ = _tmp1219_;
			vala_data_type_set_value_owned (_tmp1216_, _tmp1220_);
		}
	} else {
		gboolean _tmp1221_ = FALSE;
		gboolean _tmp1222_;
		gboolean _tmp1243_ = FALSE;
		gboolean _tmp1244_ = FALSE;
		gboolean _tmp1245_ = FALSE;
		gboolean _tmp1246_ = FALSE;
		gboolean _tmp1247_;
		gboolean _tmp1266_ = FALSE;
		gboolean _tmp1267_ = FALSE;
		gboolean _tmp1268_ = FALSE;
		gboolean _tmp1269_ = FALSE;
		gboolean _tmp1270_ = FALSE;
		gboolean _tmp1271_;
		gboolean _tmp1272_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1300_;
		ValaSymbol* _tmp1301_;
		ValaMethod* _tmp1302_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1303_;
		ValaExpression* _tmp1304_;
		ValaMemberAccess* _tmp1305_;
		gboolean _tmp1306_ = FALSE;
		gboolean _tmp1307_ = FALSE;
		gboolean _tmp1308_ = FALSE;
		gboolean _tmp1309_ = FALSE;
		gboolean _tmp1310_ = FALSE;
		ValaMethod* _tmp1311_;
		ValaSemanticAnalyzer* _tmp1352_;
		ValaSemanticAnalyzer* _tmp1353_;
		ValaSymbol* _tmp1354_;
		ValaSymbol* _tmp1355_;
		gboolean _tmp1356_;
		gboolean _tmp1357_;
		ValaDataType* _tmp1358_;
		ValaDataType* _tmp1359_;
		gboolean _tmp1360_ = FALSE;
		ValaExpression* _tmp1361_;
		ValaExpression* _tmp1362_;
		ValaSymbol* _tmp1375_;
		ValaSymbol* _tmp1376_;
		_tmp1222_ = instance;
		if (_tmp1222_) {
			ValaExpression* _tmp1223_;
			ValaExpression* _tmp1224_;
			_tmp1223_ = vala_member_access_get_inner (self);
			_tmp1224_ = _tmp1223_;
			_tmp1221_ = _tmp1224_ == NULL;
		} else {
			_tmp1221_ = FALSE;
		}
		if (_tmp1221_) {
			ValaSourceReference* _tmp1225_;
			ValaSourceReference* _tmp1226_;
			ValaMemberAccess* _tmp1227_;
			ValaMemberAccess* _tmp1228_;
			ValaExpression* _tmp1229_;
			ValaExpression* _tmp1230_;
			ValaParameter* _tmp1231_;
			ValaDataType* _tmp1232_;
			ValaDataType* _tmp1233_;
			ValaDataType* _tmp1234_;
			ValaDataType* _tmp1235_;
			ValaExpression* _tmp1236_;
			ValaExpression* _tmp1237_;
			ValaDataType* _tmp1238_;
			ValaDataType* _tmp1239_;
			ValaExpression* _tmp1240_;
			ValaExpression* _tmp1241_;
			ValaParameter* _tmp1242_;
			_tmp1225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1226_ = _tmp1225_;
			_tmp1227_ = vala_member_access_new (NULL, "this", _tmp1226_);
			_tmp1228_ = _tmp1227_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1228_);
			_vala_code_node_unref0 (_tmp1228_);
			_tmp1229_ = vala_member_access_get_inner (self);
			_tmp1230_ = _tmp1229_;
			_tmp1231_ = this_parameter;
			_tmp1232_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1231_);
			_tmp1233_ = _tmp1232_;
			_tmp1234_ = vala_data_type_copy (_tmp1233_);
			_tmp1235_ = _tmp1234_;
			vala_expression_set_value_type (_tmp1230_, _tmp1235_);
			_vala_code_node_unref0 (_tmp1235_);
			_tmp1236_ = vala_member_access_get_inner (self);
			_tmp1237_ = _tmp1236_;
			_tmp1238_ = vala_expression_get_value_type (_tmp1237_);
			_tmp1239_ = _tmp1238_;
			vala_data_type_set_value_owned (_tmp1239_, FALSE);
			_tmp1240_ = vala_member_access_get_inner (self);
			_tmp1241_ = _tmp1240_;
			_tmp1242_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1241_, (ValaSymbol*) _tmp1242_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		_tmp1247_ = instance;
		if (!_tmp1247_) {
			gboolean _tmp1248_;
			_tmp1248_ = klass;
			_tmp1246_ = !_tmp1248_;
		} else {
			_tmp1246_ = FALSE;
		}
		if (_tmp1246_) {
			ValaSymbol* _tmp1249_;
			ValaSymbol* _tmp1250_;
			_tmp1249_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1250_ = _tmp1249_;
			_tmp1245_ = !VALA_IS_CREATION_METHOD (_tmp1250_);
		} else {
			_tmp1245_ = FALSE;
		}
		if (_tmp1245_) {
			gboolean _tmp1251_;
			_tmp1251_ = may_access_instance_members;
			_tmp1244_ = _tmp1251_;
		} else {
			_tmp1244_ = FALSE;
		}
		if (_tmp1244_) {
			ValaExpression* _tmp1252_;
			ValaExpression* _tmp1253_;
			_tmp1252_ = vala_member_access_get_inner (self);
			_tmp1253_ = _tmp1252_;
			_tmp1243_ = _tmp1253_ != NULL;
		} else {
			_tmp1243_ = FALSE;
		}
		if (_tmp1243_) {
			ValaExpression* _tmp1254_;
			ValaExpression* _tmp1255_;
			ValaSymbol* _tmp1256_;
			ValaSymbol* _tmp1257_;
			_tmp1254_ = vala_member_access_get_inner (self);
			_tmp1255_ = _tmp1254_;
			_tmp1256_ = vala_expression_get_symbol_reference (_tmp1255_);
			_tmp1257_ = _tmp1256_;
			if (VALA_IS_METHOD (_tmp1257_)) {
			} else {
				ValaSourceReference* _tmp1258_;
				ValaSourceReference* _tmp1259_;
				ValaSymbol* _tmp1260_;
				ValaSymbol* _tmp1261_;
				gchar* _tmp1262_;
				gchar* _tmp1263_;
				gchar* _tmp1264_;
				gchar* _tmp1265_;
				_tmp1258_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1259_ = _tmp1258_;
				_tmp1260_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1261_ = _tmp1260_;
				_tmp1262_ = vala_symbol_get_full_name (_tmp1261_);
				_tmp1263_ = _tmp1262_;
				_tmp1264_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1263_);
				_tmp1265_ = _tmp1264_;
				vala_report_warning (_tmp1259_, _tmp1265_);
				_g_free0 (_tmp1265_);
				_g_free0 (_tmp1263_);
			}
		}
		_tmp1271_ = vala_code_context_get_experimental_non_null (context);
		_tmp1272_ = _tmp1271_;
		if (_tmp1272_) {
			gboolean _tmp1273_;
			_tmp1273_ = instance;
			_tmp1270_ = _tmp1273_;
		} else {
			_tmp1270_ = FALSE;
		}
		if (_tmp1270_) {
			ValaExpression* _tmp1274_;
			ValaExpression* _tmp1275_;
			ValaDataType* _tmp1276_;
			ValaDataType* _tmp1277_;
			gboolean _tmp1278_;
			gboolean _tmp1279_;
			_tmp1274_ = vala_member_access_get_inner (self);
			_tmp1275_ = _tmp1274_;
			_tmp1276_ = vala_expression_get_value_type (_tmp1275_);
			_tmp1277_ = _tmp1276_;
			_tmp1278_ = vala_data_type_get_nullable (_tmp1277_);
			_tmp1279_ = _tmp1278_;
			_tmp1269_ = _tmp1279_;
		} else {
			_tmp1269_ = FALSE;
		}
		if (_tmp1269_) {
			ValaExpression* _tmp1280_;
			ValaExpression* _tmp1281_;
			ValaDataType* _tmp1282_;
			ValaDataType* _tmp1283_;
			_tmp1280_ = vala_member_access_get_inner (self);
			_tmp1281_ = _tmp1280_;
			_tmp1282_ = vala_expression_get_value_type (_tmp1281_);
			_tmp1283_ = _tmp1282_;
			_tmp1268_ = !VALA_IS_POINTER_TYPE (_tmp1283_);
		} else {
			_tmp1268_ = FALSE;
		}
		if (_tmp1268_) {
			ValaExpression* _tmp1284_;
			ValaExpression* _tmp1285_;
			ValaDataType* _tmp1286_;
			ValaDataType* _tmp1287_;
			_tmp1284_ = vala_member_access_get_inner (self);
			_tmp1285_ = _tmp1284_;
			_tmp1286_ = vala_expression_get_value_type (_tmp1285_);
			_tmp1287_ = _tmp1286_;
			_tmp1267_ = !VALA_IS_GENERIC_TYPE (_tmp1287_);
		} else {
			_tmp1267_ = FALSE;
		}
		if (_tmp1267_) {
			ValaExpression* _tmp1288_;
			ValaExpression* _tmp1289_;
			ValaDataType* _tmp1290_;
			ValaDataType* _tmp1291_;
			_tmp1288_ = vala_member_access_get_inner (self);
			_tmp1289_ = _tmp1288_;
			_tmp1290_ = vala_expression_get_value_type (_tmp1289_);
			_tmp1291_ = _tmp1290_;
			_tmp1266_ = !VALA_IS_ARRAY_TYPE (_tmp1291_);
		} else {
			_tmp1266_ = FALSE;
		}
		if (_tmp1266_) {
			ValaSourceReference* _tmp1292_;
			ValaSourceReference* _tmp1293_;
			ValaSymbol* _tmp1294_;
			ValaSymbol* _tmp1295_;
			gchar* _tmp1296_;
			gchar* _tmp1297_;
			gchar* _tmp1298_;
			gchar* _tmp1299_;
			_tmp1292_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1293_ = _tmp1292_;
			_tmp1294_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1295_ = _tmp1294_;
			_tmp1296_ = vala_symbol_get_full_name (_tmp1295_);
			_tmp1297_ = _tmp1296_;
			_tmp1298_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1297_);
			_tmp1299_ = _tmp1298_;
			vala_report_error (_tmp1293_, _tmp1299_);
			_g_free0 (_tmp1299_);
			_g_free0 (_tmp1297_);
		}
		_tmp1300_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1301_ = _tmp1300_;
		_tmp1302_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1301_) ? ((ValaMethod*) _tmp1301_) : NULL);
		m = _tmp1302_;
		_tmp1303_ = vala_member_access_get_inner (self);
		_tmp1304_ = _tmp1303_;
		_tmp1305_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1304_) ? ((ValaMemberAccess*) _tmp1304_) : NULL);
		inner_ma = _tmp1305_;
		_tmp1311_ = m;
		if (_tmp1311_ != NULL) {
			ValaMethod* _tmp1312_;
			ValaMemberBinding _tmp1313_;
			ValaMemberBinding _tmp1314_;
			_tmp1312_ = m;
			_tmp1313_ = vala_method_get_binding (_tmp1312_);
			_tmp1314_ = _tmp1313_;
			_tmp1310_ = _tmp1314_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1310_ = FALSE;
		}
		if (_tmp1310_) {
			ValaMethod* _tmp1315_;
			ValaSymbol* _tmp1316_;
			ValaSymbol* _tmp1317_;
			_tmp1315_ = m;
			_tmp1316_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1315_);
			_tmp1317_ = _tmp1316_;
			_tmp1309_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1317_);
		} else {
			_tmp1309_ = FALSE;
		}
		if (_tmp1309_) {
			ValaExpression* _tmp1318_;
			ValaExpression* _tmp1319_;
			_tmp1318_ = vala_member_access_get_inner (self);
			_tmp1319_ = _tmp1318_;
			_tmp1308_ = _tmp1319_ != NULL;
		} else {
			_tmp1308_ = FALSE;
		}
		if (_tmp1308_) {
			ValaExpression* _tmp1320_;
			ValaExpression* _tmp1321_;
			ValaDataType* _tmp1322_;
			ValaDataType* _tmp1323_;
			_tmp1320_ = vala_member_access_get_inner (self);
			_tmp1321_ = _tmp1320_;
			_tmp1322_ = vala_expression_get_value_type (_tmp1321_);
			_tmp1323_ = _tmp1322_;
			_tmp1307_ = _tmp1323_ == NULL;
		} else {
			_tmp1307_ = FALSE;
		}
		if (_tmp1307_) {
			ValaMemberAccess* _tmp1324_;
			ValaList* _tmp1325_;
			gint _tmp1326_;
			gint _tmp1327_;
			_tmp1324_ = inner_ma;
			_tmp1325_ = _tmp1324_->priv->type_argument_list;
			_tmp1326_ = vala_collection_get_size ((ValaCollection*) _tmp1325_);
			_tmp1327_ = _tmp1326_;
			_tmp1306_ = _tmp1327_ > 0;
		} else {
			_tmp1306_ = FALSE;
		}
		if (_tmp1306_) {
			ValaExpression* _tmp1328_;
			ValaExpression* _tmp1329_;
			ValaMethod* _tmp1330_;
			ValaSymbol* _tmp1331_;
			ValaSymbol* _tmp1332_;
			ValaObjectType* _tmp1333_;
			ValaObjectType* _tmp1334_;
			_tmp1328_ = vala_member_access_get_inner (self);
			_tmp1329_ = _tmp1328_;
			_tmp1330_ = m;
			_tmp1331_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1330_);
			_tmp1332_ = _tmp1331_;
			_tmp1333_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1332_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1334_ = _tmp1333_;
			vala_expression_set_value_type (_tmp1329_, (ValaDataType*) _tmp1334_);
			_vala_code_node_unref0 (_tmp1334_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1335_;
				ValaList* _tmp1336_;
				ValaList* _tmp1337_;
				gint _type_argument_size = 0;
				ValaList* _tmp1338_;
				gint _tmp1339_;
				gint _tmp1340_;
				gint _type_argument_index = 0;
				_tmp1335_ = inner_ma;
				_tmp1336_ = _tmp1335_->priv->type_argument_list;
				_tmp1337_ = _vala_iterable_ref0 (_tmp1336_);
				_type_argument_list = _tmp1337_;
				_tmp1338_ = _type_argument_list;
				_tmp1339_ = vala_collection_get_size ((ValaCollection*) _tmp1338_);
				_tmp1340_ = _tmp1339_;
				_type_argument_size = _tmp1340_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1341_;
					gint _tmp1342_;
					gint _tmp1343_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1344_;
					gint _tmp1345_;
					gpointer _tmp1346_;
					ValaExpression* _tmp1347_;
					ValaExpression* _tmp1348_;
					ValaDataType* _tmp1349_;
					ValaDataType* _tmp1350_;
					ValaDataType* _tmp1351_;
					_tmp1341_ = _type_argument_index;
					_type_argument_index = _tmp1341_ + 1;
					_tmp1342_ = _type_argument_index;
					_tmp1343_ = _type_argument_size;
					if (!(_tmp1342_ < _tmp1343_)) {
						break;
					}
					_tmp1344_ = _type_argument_list;
					_tmp1345_ = _type_argument_index;
					_tmp1346_ = vala_list_get (_tmp1344_, _tmp1345_);
					type_argument = (ValaDataType*) _tmp1346_;
					_tmp1347_ = vala_member_access_get_inner (self);
					_tmp1348_ = _tmp1347_;
					_tmp1349_ = vala_expression_get_value_type (_tmp1348_);
					_tmp1350_ = _tmp1349_;
					_tmp1351_ = type_argument;
					vala_data_type_add_type_argument (_tmp1350_, _tmp1351_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1352_ = vala_code_context_get_analyzer (context);
		_tmp1353_ = _tmp1352_;
		_tmp1354_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1355_ = _tmp1354_;
		_tmp1356_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1357_ = _tmp1356_;
		_tmp1358_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1353_, _tmp1355_, _tmp1357_);
		_tmp1359_ = _tmp1358_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1359_);
		_vala_code_node_unref0 (_tmp1359_);
		_tmp1361_ = vala_member_access_get_inner (self);
		_tmp1362_ = _tmp1361_;
		if (_tmp1362_ != NULL) {
			ValaDataType* _tmp1363_;
			ValaDataType* _tmp1364_;
			_tmp1363_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1364_ = _tmp1363_;
			_tmp1360_ = _tmp1364_ != NULL;
		} else {
			_tmp1360_ = FALSE;
		}
		if (_tmp1360_) {
			ValaDataType* _tmp1365_;
			ValaDataType* _tmp1366_;
			ValaExpression* _tmp1367_;
			ValaExpression* _tmp1368_;
			ValaDataType* _tmp1369_;
			ValaDataType* _tmp1370_;
			ValaDataType* _tmp1371_;
			ValaDataType* _tmp1372_;
			_tmp1365_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1366_ = _tmp1365_;
			_tmp1367_ = vala_member_access_get_inner (self);
			_tmp1368_ = _tmp1367_;
			_tmp1369_ = vala_expression_get_value_type (_tmp1368_);
			_tmp1370_ = _tmp1369_;
			_tmp1371_ = vala_data_type_get_actual_type (_tmp1366_, _tmp1370_, NULL, (ValaCodeNode*) self);
			_tmp1372_ = _tmp1371_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1372_);
			_vala_code_node_unref0 (_tmp1372_);
		} else {
			ValaDataType* _tmp1373_;
			ValaDataType* _tmp1374_;
			_tmp1373_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1374_ = _tmp1373_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1374_);
		}
		_tmp1375_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1376_ = _tmp1375_;
		if (VALA_IS_METHOD (_tmp1376_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1377_;
			ValaSymbol* _tmp1378_;
			ValaMethod* _tmp1379_;
			ValaDataType* _tmp1380_;
			ValaDataType* _tmp1381_;
			gboolean _tmp1388_ = FALSE;
			gboolean _tmp1389_;
			_tmp1377_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1378_ = _tmp1377_;
			_tmp1379_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1378_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1379_;
			_tmp1380_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1381_ = _tmp1380_;
			if (_tmp1381_ != NULL) {
				ValaDataType* _tmp1382_;
				ValaDataType* _tmp1383_;
				ValaDataType* _tmp1384_;
				ValaDataType* _tmp1385_;
				gboolean _tmp1386_;
				gboolean _tmp1387_;
				_tmp1382_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1383_ = _tmp1382_;
				_tmp1384_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1385_ = _tmp1384_;
				_tmp1386_ = vala_data_type_get_value_owned (_tmp1385_);
				_tmp1387_ = _tmp1386_;
				vala_data_type_set_value_owned (_tmp1383_, _tmp1387_);
			}
			_tmp1389_ = instance;
			if (_tmp1389_) {
				ValaMethod* _tmp1390_;
				ValaSymbol* _tmp1391_;
				ValaSymbol* _tmp1392_;
				_tmp1390_ = method;
				_tmp1391_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1390_);
				_tmp1392_ = _tmp1391_;
				_tmp1388_ = VALA_IS_TYPESYMBOL (_tmp1392_);
			} else {
				_tmp1388_ = FALSE;
			}
			if (_tmp1388_) {
				ValaExpression* _tmp1393_;
				ValaExpression* _tmp1394_;
				ValaMethod* _tmp1395_;
				ValaSymbol* _tmp1396_;
				ValaSymbol* _tmp1397_;
				ValaDataType* _tmp1398_;
				ValaDataType* _tmp1399_;
				ValaExpression* _tmp1400_;
				ValaExpression* _tmp1401_;
				ValaDataType* _tmp1402_;
				ValaDataType* _tmp1403_;
				ValaMethod* _tmp1404_;
				ValaParameter* _tmp1405_;
				ValaParameter* _tmp1406_;
				ValaDataType* _tmp1407_;
				ValaDataType* _tmp1408_;
				gboolean _tmp1409_;
				gboolean _tmp1410_;
				_tmp1393_ = vala_member_access_get_inner (self);
				_tmp1394_ = _tmp1393_;
				_tmp1395_ = method;
				_tmp1396_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1395_);
				_tmp1397_ = _tmp1396_;
				_tmp1398_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1397_);
				_tmp1399_ = _tmp1398_;
				vala_expression_set_target_type (_tmp1394_, _tmp1399_);
				_vala_code_node_unref0 (_tmp1399_);
				_tmp1400_ = vala_member_access_get_inner (self);
				_tmp1401_ = _tmp1400_;
				_tmp1402_ = vala_expression_get_target_type (_tmp1401_);
				_tmp1403_ = _tmp1402_;
				_tmp1404_ = method;
				_tmp1405_ = vala_method_get_this_parameter (_tmp1404_);
				_tmp1406_ = _tmp1405_;
				_tmp1407_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1406_);
				_tmp1408_ = _tmp1407_;
				_tmp1409_ = vala_data_type_get_value_owned (_tmp1408_);
				_tmp1410_ = _tmp1409_;
				vala_data_type_set_value_owned (_tmp1403_, _tmp1410_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1411_;
			ValaSymbol* _tmp1412_;
			_tmp1411_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1412_ = _tmp1411_;
			if (VALA_IS_PROPERTY (_tmp1412_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1413_;
				ValaSymbol* _tmp1414_;
				ValaProperty* _tmp1415_;
				gboolean _tmp1416_ = FALSE;
				gboolean _tmp1417_;
				_tmp1413_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1414_ = _tmp1413_;
				_tmp1415_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1414_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1415_;
				_tmp1417_ = instance;
				if (_tmp1417_) {
					ValaProperty* _tmp1418_;
					ValaSymbol* _tmp1419_;
					ValaSymbol* _tmp1420_;
					_tmp1418_ = prop;
					_tmp1419_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1418_);
					_tmp1420_ = _tmp1419_;
					_tmp1416_ = _tmp1420_ != NULL;
				} else {
					_tmp1416_ = FALSE;
				}
				if (_tmp1416_) {
					ValaExpression* _tmp1421_;
					ValaExpression* _tmp1422_;
					ValaProperty* _tmp1423_;
					ValaSymbol* _tmp1424_;
					ValaSymbol* _tmp1425_;
					ValaDataType* _tmp1426_;
					ValaDataType* _tmp1427_;
					_tmp1421_ = vala_member_access_get_inner (self);
					_tmp1422_ = _tmp1421_;
					_tmp1423_ = prop;
					_tmp1424_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1423_);
					_tmp1425_ = _tmp1424_;
					_tmp1426_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1425_);
					_tmp1427_ = _tmp1426_;
					vala_expression_set_target_type (_tmp1422_, _tmp1427_);
					_vala_code_node_unref0 (_tmp1427_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1428_ = FALSE;
				gboolean _tmp1429_ = FALSE;
				gboolean _tmp1430_ = FALSE;
				ValaSymbol* _tmp1431_;
				ValaSymbol* _tmp1432_;
				_tmp1431_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1432_ = _tmp1431_;
				if (VALA_IS_FIELD (_tmp1432_)) {
					_tmp1430_ = TRUE;
				} else {
					ValaSymbol* _tmp1433_;
					ValaSymbol* _tmp1434_;
					_tmp1433_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1434_ = _tmp1433_;
					_tmp1430_ = VALA_IS_SIGNAL (_tmp1434_);
				}
				if (_tmp1430_) {
					gboolean _tmp1435_;
					_tmp1435_ = instance;
					_tmp1429_ = _tmp1435_;
				} else {
					_tmp1429_ = FALSE;
				}
				if (_tmp1429_) {
					ValaSymbol* _tmp1436_;
					ValaSymbol* _tmp1437_;
					ValaSymbol* _tmp1438_;
					ValaSymbol* _tmp1439_;
					_tmp1436_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1437_ = _tmp1436_;
					_tmp1438_ = vala_symbol_get_parent_symbol (_tmp1437_);
					_tmp1439_ = _tmp1438_;
					_tmp1428_ = _tmp1439_ != NULL;
				} else {
					_tmp1428_ = FALSE;
				}
				if (_tmp1428_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1440_;
					ValaSymbol* _tmp1441_;
					ValaSymbol* _tmp1442_;
					ValaSymbol* _tmp1443_;
					ValaDataType* _tmp1444_;
					ValaExpression* _tmp1445_;
					ValaExpression* _tmp1446_;
					ValaDataType* _tmp1447_;
					ValaExpression* _tmp1448_;
					ValaExpression* _tmp1449_;
					ValaDataType* _tmp1450_;
					ValaDataType* _tmp1451_;
					ValaDataType* _tmp1452_;
					ValaDataType* _tmp1453_;
					_tmp1440_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1441_ = _tmp1440_;
					_tmp1442_ = vala_symbol_get_parent_symbol (_tmp1441_);
					_tmp1443_ = _tmp1442_;
					_tmp1444_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1443_);
					parent_type = _tmp1444_;
					_tmp1445_ = vala_member_access_get_inner (self);
					_tmp1446_ = _tmp1445_;
					_tmp1447_ = parent_type;
					_tmp1448_ = vala_member_access_get_inner (self);
					_tmp1449_ = _tmp1448_;
					_tmp1450_ = vala_expression_get_value_type (_tmp1449_);
					_tmp1451_ = _tmp1450_;
					_tmp1452_ = vala_data_type_get_actual_type (_tmp1447_, _tmp1451_, NULL, (ValaCodeNode*) self);
					_tmp1453_ = _tmp1452_;
					vala_expression_set_target_type (_tmp1446_, _tmp1453_);
					_vala_code_node_unref0 (_tmp1453_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1454_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1455_ = _tmp1454_;
	result = !_tmp1455_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}


static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}


void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_ = FALSE;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	gboolean this_access = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaMemberAccess* _tmp57_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	_tmp9_ = instance;
	if (!_tmp9_) {
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_METHOD (_tmp12_)) {
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_tmp13_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_METHOD, ValaMethod));
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp10_ = FALSE;
		}
		instance = _tmp10_;
	}
	_tmp17_ = instance;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp20_ = _tmp19_;
		if (VALA_IS_PROPERTY (_tmp20_)) {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp18_ = FALSE;
		}
		instance = _tmp18_;
	}
	_tmp26_ = vala_member_access_get_inner (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_expression_get_symbol_reference (_tmp27_);
	_tmp29_ = _tmp28_;
	if (VALA_IS_PARAMETER (_tmp29_)) {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp25_ = g_strcmp0 (_tmp35_, "this") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	this_access = _tmp25_;
	_tmp38_ = vala_member_access_get_inner (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp41_)) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp42_ = vala_member_access_get_inner (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_expression_get_value_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_data_type_get_nullable (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp37_ = !_tmp47_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_member_access_get_inner (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_expression_get_value_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp36_ = VALA_IS_ARRAY_TYPE (_tmp51_);
	}
	struct_or_array = _tmp36_;
	_tmp52_ = vala_member_access_get_inner (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp53_) ? ((ValaMemberAccess*) _tmp53_) : NULL);
	ma = _tmp54_;
	_tmp57_ = ma;
	if (_tmp57_ == NULL) {
		gboolean _tmp58_;
		_tmp58_ = struct_or_array;
		_tmp56_ = _tmp58_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_member_access_get_inner (self);
		_tmp60_ = _tmp59_;
		_tmp55_ = VALA_IS_POINTER_INDIRECTION (_tmp60_);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaMemberAccess* _tmp65_;
		_tmp61_ = vala_member_access_get_inner (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp64_) ? ((ValaMemberAccess*) _tmp64_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
	}
	_tmp70_ = instance;
	if (_tmp70_) {
		gboolean _tmp71_;
		_tmp71_ = struct_or_array;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gboolean _tmp72_ = FALSE;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		_tmp73_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (VALA_IS_METHOD (_tmp74_)) {
			_tmp72_ = TRUE;
		} else {
			gboolean _tmp75_;
			gboolean _tmp76_;
			_tmp75_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp72_ = _tmp76_;
		}
		_tmp68_ = _tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaMemberAccess* _tmp79_;
		_tmp79_ = ma;
		if (_tmp79_ != NULL) {
			ValaMemberAccess* _tmp80_;
			ValaSymbol* _tmp81_;
			ValaSymbol* _tmp82_;
			_tmp80_ = ma;
			_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = VALA_IS_VARIABLE (_tmp82_);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			_tmp83_ = vala_member_access_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp77_ = VALA_IS_ELEMENT_ACCESS (_tmp84_);
		}
		_tmp67_ = _tmp77_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gboolean _tmp85_;
		_tmp85_ = this_access;
		_tmp66_ = !_tmp85_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		ValaAttribute* _tmp97_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ != NULL;
		_vala_code_node_unref0 (_tmp97_);
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaClass* _tmp104_;
		_tmp98_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_METHOD, ValaMethod));
		_tmp101_ = _tmp100_;
		cl = VALA_IS_CLASS (_tmp101_) ? ((ValaClass*) _tmp101_) : NULL;
		_tmp104_ = cl;
		if (_tmp104_ != NULL) {
			ValaClass* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = cl;
			_tmp106_ = vala_class_get_is_compact (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp108_;
			_tmp108_ = ma;
			_tmp102_ = _tmp108_ != NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp109_;
			ValaMemberAccess* _tmp110_;
			_tmp109_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp109_, TRUE);
			_tmp110_ = ma;
			vala_member_access_check_lvalue_access (_tmp110_);
		}
	}
	_vala_code_node_unref0 (ma);
}


static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}


static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pointer_member_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_prototype_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_creation_member;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_qualified;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}


static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}


static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}



