/* valalambdaexpression.c generated by valac, the Vala compiler
 * generated from valalambdaexpression.vala, do not modify */

/* valalambdaexpression.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaLambdaExpressionPrivate {
	ValaExpression* _expression_body;
	ValaBlock* _statement_body;
	ValaMethod* _method;
	ValaList* parameters;
};


static gpointer vala_lambda_expression_parent_class = NULL;
static gint vala_lambda_expression_next_lambda_id;
static gint vala_lambda_expression_next_lambda_id = 0;

#define VALA_LAMBDA_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpressionPrivate))
static void vala_lambda_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static void vala_lambda_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static gboolean vala_lambda_expression_real_is_pure (ValaExpression* base);
static gboolean vala_lambda_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context);
static void vala_lambda_expression_real_emit (ValaCodeNode* base,
                                       ValaCodeGenerator* codegen);
static void vala_lambda_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection);
static void vala_lambda_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new lambda expression.
 *
 * @param expression_body  expression body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct (GType object_type,
                                  ValaExpression* expression_body,
                                  ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (expression_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_lambda_expression_set_expression_body (self, expression_body);
	return self;
}


ValaLambdaExpression*
vala_lambda_expression_new (ValaExpression* expression_body,
                            ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct (VALA_TYPE_LAMBDA_EXPRESSION, expression_body, source_reference);
}


/**
 * Creates a new lambda expression with statement body.
 *
 * @param statement_body   statement body
 * @param source_reference reference to source code
 * @return                 newly created lambda expression
 */
ValaLambdaExpression*
vala_lambda_expression_construct_with_statement_body (GType object_type,
                                                      ValaBlock* statement_body,
                                                      ValaSourceReference* source_reference)
{
	ValaLambdaExpression* self = NULL;
	g_return_val_if_fail (statement_body != NULL, NULL);
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaLambdaExpression*) vala_expression_construct (object_type);
	vala_lambda_expression_set_statement_body (self, statement_body);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaLambdaExpression*
vala_lambda_expression_new_with_statement_body (ValaBlock* statement_body,
                                                ValaSourceReference* source_reference)
{
	return vala_lambda_expression_construct_with_statement_body (VALA_TYPE_LAMBDA_EXPRESSION, statement_body, source_reference);
}


/**
 * Appends implicitly typed parameter.
 *
 * @param param parameter name
 */
void
vala_lambda_expression_add_parameter (ValaLambdaExpression* self,
                                      ValaParameter* param)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (param != NULL);
	_tmp0_ = self->priv->parameters;
	vala_collection_add ((ValaCollection*) _tmp0_, param);
}


/**
 * Returns copy of parameter list.
 *
 * @return parameter list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_lambda_expression_get_parameters (ValaLambdaExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->parameters;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_lambda_expression_real_accept (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_lambda_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_lambda_expression_real_accept_children (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaLambdaExpression * self;
	ValaMethod* _tmp0_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = self->priv->_method;
	if (_tmp0_ == NULL) {
		ValaExpression* _tmp1_;
		_tmp1_ = self->priv->_expression_body;
		if (_tmp1_ != NULL) {
			ValaExpression* _tmp2_;
			ValaExpression* _tmp3_;
			_tmp2_ = self->priv->_expression_body;
			vala_code_node_accept ((ValaCodeNode*) _tmp2_, visitor);
			_tmp3_ = self->priv->_expression_body;
			vala_code_visitor_visit_end_full_expression (visitor, _tmp3_);
		} else {
			ValaBlock* _tmp4_;
			_tmp4_ = self->priv->_statement_body;
			if (_tmp4_ != NULL) {
				ValaBlock* _tmp5_;
				_tmp5_ = self->priv->_statement_body;
				vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
			}
		}
	} else {
		ValaMethod* _tmp6_;
		_tmp6_ = self->priv->_method;
		vala_code_node_accept ((ValaCodeNode*) _tmp6_, visitor);
	}
}


static gboolean
vala_lambda_expression_real_is_pure (ValaExpression* base)
{
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	self = (ValaLambdaExpression*) base;
	result = FALSE;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_lambda_expression_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context)
{
	ValaLambdaExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	ValaDelegate* cb = NULL;
	ValaDataType* _tmp18_;
	ValaDataType* _tmp19_;
	ValaDelegate* _tmp20_;
	ValaDelegate* _tmp21_;
	ValaDelegate* _tmp22_;
	ValaDataType* return_type = NULL;
	ValaDelegate* _tmp23_;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	ValaDataType* _tmp28_;
	gint _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	ValaDataType* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaSourceReference* _tmp34_;
	ValaMethod* _tmp35_;
	ValaMethod* _tmp36_;
	ValaMethod* _tmp37_;
	ValaMethod* _tmp38_;
	ValaVersionAttribute* _tmp39_;
	ValaVersionAttribute* _tmp40_;
	ValaSourceReference* _tmp41_;
	ValaSourceReference* _tmp42_;
	ValaDataType* _tmp43_;
	gboolean _tmp53_ = FALSE;
	ValaDelegate* _tmp54_;
	gboolean _tmp55_;
	gboolean _tmp56_;
	ValaMethod* _tmp100_;
	ValaSemanticAnalyzer* _tmp101_;
	ValaSemanticAnalyzer* _tmp102_;
	ValaSymbol* _tmp103_;
	ValaSymbol* _tmp104_;
	ValaScope* _tmp105_;
	ValaScope* _tmp106_;
	ValaList* lambda_params = NULL;
	ValaList* _tmp107_;
	ValaIterator* lambda_param_it = NULL;
	ValaList* _tmp108_;
	ValaIterator* _tmp109_;
	gboolean _tmp110_ = FALSE;
	ValaDelegate* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaIterator* _tmp171_;
	ValaExpression* _tmp189_;
	ValaMethod* _tmp220_;
	ValaBlock* _tmp221_;
	ValaBlock* _tmp222_;
	ValaMethod* _tmp223_;
	ValaScope* _tmp224_;
	ValaScope* _tmp225_;
	ValaMethod* m = NULL;
	ValaSemanticAnalyzer* _tmp226_;
	ValaSemanticAnalyzer* _tmp227_;
	ValaSemanticAnalyzer* _tmp228_;
	ValaSemanticAnalyzer* _tmp229_;
	ValaSymbol* _tmp230_;
	ValaSymbol* _tmp231_;
	ValaMethod* _tmp232_;
	ValaMethod* _tmp233_;
	ValaMethod* _tmp258_;
	ValaMethod* _tmp259_;
	ValaMethod* _tmp260_;
	ValaMethodType* _tmp261_;
	ValaMethodType* _tmp262_;
	ValaDataType* _tmp263_;
	ValaDataType* _tmp264_;
	ValaDataType* _tmp265_;
	ValaDataType* _tmp266_;
	gboolean _tmp267_;
	gboolean _tmp268_;
	gboolean _tmp269_;
	gboolean _tmp270_;
	self = (ValaLambdaExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	if (!VALA_IS_DELEGATE_TYPE (_tmp5_)) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp6_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			ValaDataType* _tmp10_;
			ValaDataType* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			_tmp10_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp11_ = _tmp10_;
			_tmp12_ = vala_code_node_to_string ((ValaCodeNode*) _tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = g_strdup_printf ("Cannot convert lambda expression to `%s'", _tmp13_);
			_tmp15_ = _tmp14_;
			vala_report_error (_tmp9_, _tmp15_);
			_g_free0 (_tmp15_);
			_g_free0 (_tmp13_);
		} else {
			ValaSourceReference* _tmp16_;
			ValaSourceReference* _tmp17_;
			_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp17_ = _tmp16_;
			vala_report_error (_tmp17_, "lambda expression not allowed in this context");
		}
		result = FALSE;
		return result;
	}
	_tmp18_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
	_tmp21_ = _tmp20_;
	_tmp22_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_DELEGATE, ValaDelegate));
	cb = _tmp22_;
	_tmp23_ = cb;
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_data_type_get_actual_type (_tmp25_, _tmp27_, NULL, (ValaCodeNode*) self);
	return_type = _tmp28_;
	_tmp29_ = vala_lambda_expression_next_lambda_id;
	vala_lambda_expression_next_lambda_id = _tmp29_ + 1;
	_tmp30_ = g_strdup_printf ("_lambda%d_", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = return_type;
	_tmp33_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp34_ = _tmp33_;
	_tmp35_ = vala_method_new (_tmp31_, _tmp32_, _tmp34_, NULL);
	_tmp36_ = _tmp35_;
	vala_lambda_expression_set_method (self, _tmp36_);
	_vala_code_node_unref0 (_tmp36_);
	_g_free0 (_tmp31_);
	_tmp37_ = self->priv->_method;
	vala_symbol_set_used ((ValaSymbol*) _tmp37_, TRUE);
	_tmp38_ = self->priv->_method;
	_tmp39_ = vala_symbol_get_version ((ValaSymbol*) _tmp38_);
	_tmp40_ = _tmp39_;
	_tmp41_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp42_ = _tmp41_;
	vala_version_attribute_check (_tmp40_, _tmp42_);
	_tmp43_ = return_type;
	if (VALA_IS_ARRAY_TYPE (_tmp43_)) {
		ValaMethod* _tmp44_;
		ValaDelegate* _tmp45_;
		ValaMethod* _tmp46_;
		ValaDelegate* _tmp47_;
		ValaMethod* _tmp48_;
		ValaDelegate* _tmp49_;
		_tmp44_ = self->priv->_method;
		_tmp45_ = cb;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp44_, (ValaCodeNode*) _tmp45_, "CCode", "array_length");
		_tmp46_ = self->priv->_method;
		_tmp47_ = cb;
		vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp46_, (ValaCodeNode*) _tmp47_, "CCode", "array_null_terminated");
		_tmp48_ = self->priv->_method;
		_tmp49_ = cb;
		vala_code_node_copy_attribute_string ((ValaCodeNode*) _tmp48_, (ValaCodeNode*) _tmp49_, "CCode", "array_length_type");
	} else {
		ValaDataType* _tmp50_;
		_tmp50_ = return_type;
		if (VALA_IS_DELEGATE_TYPE (_tmp50_)) {
			ValaMethod* _tmp51_;
			ValaDelegate* _tmp52_;
			_tmp51_ = self->priv->_method;
			_tmp52_ = cb;
			vala_code_node_copy_attribute_bool ((ValaCodeNode*) _tmp51_, (ValaCodeNode*) _tmp52_, "CCode", "delegate_target");
		}
	}
	_tmp54_ = cb;
	_tmp55_ = vala_delegate_get_has_target (_tmp54_);
	_tmp56_ = _tmp55_;
	if (!_tmp56_) {
		_tmp53_ = TRUE;
	} else {
		ValaSemanticAnalyzer* _tmp57_;
		ValaSemanticAnalyzer* _tmp58_;
		_tmp57_ = vala_code_context_get_analyzer (context);
		_tmp58_ = _tmp57_;
		_tmp53_ = !vala_semantic_analyzer_is_in_instance_method (_tmp58_);
	}
	if (_tmp53_) {
		ValaMethod* _tmp59_;
		_tmp59_ = self->priv->_method;
		vala_method_set_binding (_tmp59_, VALA_MEMBER_BINDING_STATIC);
	} else {
		ValaSymbol* sym = NULL;
		ValaSemanticAnalyzer* _tmp60_;
		ValaSemanticAnalyzer* _tmp61_;
		ValaSymbol* _tmp62_;
		ValaSymbol* _tmp63_;
		ValaSymbol* _tmp64_;
		_tmp60_ = vala_code_context_get_analyzer (context);
		_tmp61_ = _tmp60_;
		_tmp62_ = vala_semantic_analyzer_get_current_symbol (_tmp61_);
		_tmp63_ = _tmp62_;
		_tmp64_ = _vala_code_node_ref0 (_tmp63_);
		sym = _tmp64_;
		while (TRUE) {
			ValaMethod* _tmp65_;
			ValaParameter* _tmp66_;
			ValaParameter* _tmp67_;
			ValaSymbol* _tmp68_;
			ValaSymbol* _tmp96_;
			ValaSymbol* _tmp97_;
			ValaSymbol* _tmp98_;
			ValaSymbol* _tmp99_;
			_tmp65_ = self->priv->_method;
			_tmp66_ = vala_method_get_this_parameter (_tmp65_);
			_tmp67_ = _tmp66_;
			if (!(_tmp67_ == NULL)) {
				break;
			}
			_tmp68_ = sym;
			if (VALA_IS_PROPERTY (_tmp68_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp69_;
				ValaProperty* _tmp70_;
				ValaMethod* _tmp71_;
				ValaProperty* _tmp72_;
				ValaParameter* _tmp73_;
				ValaParameter* _tmp74_;
				_tmp69_ = sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp70_;
				_tmp71_ = self->priv->_method;
				_tmp72_ = prop;
				_tmp73_ = vala_property_get_this_parameter (_tmp72_);
				_tmp74_ = _tmp73_;
				vala_method_set_this_parameter (_tmp71_, _tmp74_);
				_vala_code_node_unref0 (prop);
			} else {
				ValaSymbol* _tmp75_;
				_tmp75_ = sym;
				if (VALA_IS_CONSTRUCTOR (_tmp75_)) {
					ValaConstructor* c = NULL;
					ValaSymbol* _tmp76_;
					ValaConstructor* _tmp77_;
					ValaMethod* _tmp78_;
					ValaConstructor* _tmp79_;
					ValaParameter* _tmp80_;
					ValaParameter* _tmp81_;
					_tmp76_ = sym;
					_tmp77_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp76_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
					c = _tmp77_;
					_tmp78_ = self->priv->_method;
					_tmp79_ = c;
					_tmp80_ = vala_constructor_get_this_parameter (_tmp79_);
					_tmp81_ = _tmp80_;
					vala_method_set_this_parameter (_tmp78_, _tmp81_);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp82_;
					_tmp82_ = sym;
					if (VALA_IS_DESTRUCTOR (_tmp82_)) {
						ValaDestructor* d = NULL;
						ValaSymbol* _tmp83_;
						ValaDestructor* _tmp84_;
						ValaMethod* _tmp85_;
						ValaDestructor* _tmp86_;
						ValaParameter* _tmp87_;
						ValaParameter* _tmp88_;
						_tmp83_ = sym;
						_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
						d = _tmp84_;
						_tmp85_ = self->priv->_method;
						_tmp86_ = d;
						_tmp87_ = vala_destructor_get_this_parameter (_tmp86_);
						_tmp88_ = _tmp87_;
						vala_method_set_this_parameter (_tmp85_, _tmp88_);
						_vala_code_node_unref0 (d);
					} else {
						ValaSymbol* _tmp89_;
						_tmp89_ = sym;
						if (VALA_IS_METHOD (_tmp89_)) {
							ValaMethod* m = NULL;
							ValaSymbol* _tmp90_;
							ValaMethod* _tmp91_;
							ValaMethod* _tmp92_;
							ValaMethod* _tmp93_;
							ValaParameter* _tmp94_;
							ValaParameter* _tmp95_;
							_tmp90_ = sym;
							_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_METHOD, ValaMethod));
							m = _tmp91_;
							_tmp92_ = self->priv->_method;
							_tmp93_ = m;
							_tmp94_ = vala_method_get_this_parameter (_tmp93_);
							_tmp95_ = _tmp94_;
							vala_method_set_this_parameter (_tmp92_, _tmp95_);
							_vala_code_node_unref0 (m);
						}
					}
				}
			}
			_tmp96_ = sym;
			_tmp97_ = vala_symbol_get_parent_symbol (_tmp96_);
			_tmp98_ = _tmp97_;
			_tmp99_ = _vala_code_node_ref0 (_tmp98_);
			_vala_code_node_unref0 (sym);
			sym = _tmp99_;
		}
		_vala_code_node_unref0 (sym);
	}
	_tmp100_ = self->priv->_method;
	_tmp101_ = vala_code_context_get_analyzer (context);
	_tmp102_ = _tmp101_;
	_tmp103_ = vala_semantic_analyzer_get_current_symbol (_tmp102_);
	_tmp104_ = _tmp103_;
	_tmp105_ = vala_symbol_get_scope (_tmp104_);
	_tmp106_ = _tmp105_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp100_, _tmp106_);
	_tmp107_ = vala_lambda_expression_get_parameters (self);
	lambda_params = _tmp107_;
	_tmp108_ = lambda_params;
	_tmp109_ = vala_iterable_iterator ((ValaIterable*) _tmp108_);
	lambda_param_it = _tmp109_;
	_tmp111_ = cb;
	_tmp112_ = vala_delegate_get_sender_type (_tmp111_);
	_tmp113_ = _tmp112_;
	if (_tmp113_ != NULL) {
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		ValaDelegate* _tmp117_;
		ValaList* _tmp118_;
		ValaList* _tmp119_;
		gint _tmp120_;
		gint _tmp121_;
		_tmp114_ = lambda_params;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = cb;
		_tmp118_ = vala_callable_get_parameters ((ValaCallable*) _tmp117_);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
		_tmp121_ = _tmp120_;
		_tmp110_ = _tmp116_ == (_tmp121_ + 1);
		_vala_iterable_unref0 (_tmp119_);
	} else {
		_tmp110_ = FALSE;
	}
	if (_tmp110_) {
		ValaIterator* _tmp122_;
		ValaParameter* lambda_param = NULL;
		ValaIterator* _tmp123_;
		gpointer _tmp124_;
		ValaParameter* _tmp125_;
		ValaDelegate* _tmp126_;
		ValaDataType* _tmp127_;
		ValaDataType* _tmp128_;
		ValaMethod* _tmp129_;
		ValaParameter* _tmp130_;
		_tmp122_ = lambda_param_it;
		vala_iterator_next (_tmp122_);
		_tmp123_ = lambda_param_it;
		_tmp124_ = vala_iterator_get (_tmp123_);
		lambda_param = (ValaParameter*) _tmp124_;
		_tmp125_ = lambda_param;
		_tmp126_ = cb;
		_tmp127_ = vala_delegate_get_sender_type (_tmp126_);
		_tmp128_ = _tmp127_;
		vala_variable_set_variable_type ((ValaVariable*) _tmp125_, _tmp128_);
		_tmp129_ = self->priv->_method;
		_tmp130_ = lambda_param;
		vala_callable_add_parameter ((ValaCallable*) _tmp129_, _tmp130_);
		_vala_code_node_unref0 (lambda_param);
	}
	{
		ValaList* _cb_param_list = NULL;
		ValaDelegate* _tmp131_;
		ValaList* _tmp132_;
		gint _cb_param_size = 0;
		ValaList* _tmp133_;
		gint _tmp134_;
		gint _tmp135_;
		gint _cb_param_index = 0;
		_tmp131_ = cb;
		_tmp132_ = vala_callable_get_parameters ((ValaCallable*) _tmp131_);
		_cb_param_list = _tmp132_;
		_tmp133_ = _cb_param_list;
		_tmp134_ = vala_collection_get_size ((ValaCollection*) _tmp133_);
		_tmp135_ = _tmp134_;
		_cb_param_size = _tmp135_;
		_cb_param_index = -1;
		while (TRUE) {
			gint _tmp136_;
			gint _tmp137_;
			gint _tmp138_;
			ValaParameter* cb_param = NULL;
			ValaList* _tmp139_;
			gint _tmp140_;
			gpointer _tmp141_;
			ValaIterator* _tmp142_;
			ValaParameter* lambda_param = NULL;
			ValaIterator* _tmp143_;
			gpointer _tmp144_;
			ValaParameter* _tmp145_;
			ValaParameterDirection _tmp146_;
			ValaParameterDirection _tmp147_;
			ValaParameter* _tmp148_;
			ValaParameterDirection _tmp149_;
			ValaParameterDirection _tmp150_;
			ValaParameter* _tmp159_;
			ValaParameter* _tmp160_;
			ValaDataType* _tmp161_;
			ValaDataType* _tmp162_;
			ValaDataType* _tmp163_;
			ValaDataType* _tmp164_;
			ValaDataType* _tmp165_;
			ValaDataType* _tmp166_;
			ValaParameter* _tmp167_;
			ValaParameter* _tmp168_;
			ValaMethod* _tmp169_;
			ValaParameter* _tmp170_;
			_tmp136_ = _cb_param_index;
			_cb_param_index = _tmp136_ + 1;
			_tmp137_ = _cb_param_index;
			_tmp138_ = _cb_param_size;
			if (!(_tmp137_ < _tmp138_)) {
				break;
			}
			_tmp139_ = _cb_param_list;
			_tmp140_ = _cb_param_index;
			_tmp141_ = vala_list_get (_tmp139_, _tmp140_);
			cb_param = (ValaParameter*) _tmp141_;
			_tmp142_ = lambda_param_it;
			if (!vala_iterator_next (_tmp142_)) {
				_vala_code_node_unref0 (cb_param);
				break;
			}
			_tmp143_ = lambda_param_it;
			_tmp144_ = vala_iterator_get (_tmp143_);
			lambda_param = (ValaParameter*) _tmp144_;
			_tmp145_ = lambda_param;
			_tmp146_ = vala_parameter_get_direction (_tmp145_);
			_tmp147_ = _tmp146_;
			_tmp148_ = cb_param;
			_tmp149_ = vala_parameter_get_direction (_tmp148_);
			_tmp150_ = _tmp149_;
			if (_tmp147_ != _tmp150_) {
				ValaParameter* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaSourceReference* _tmp153_;
				ValaParameter* _tmp154_;
				const gchar* _tmp155_;
				const gchar* _tmp156_;
				gchar* _tmp157_;
				gchar* _tmp158_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp151_ = lambda_param;
				_tmp152_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp151_);
				_tmp153_ = _tmp152_;
				_tmp154_ = lambda_param;
				_tmp155_ = vala_symbol_get_name ((ValaSymbol*) _tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = g_strdup_printf ("direction of parameter `%s' is incompatible with the target delegate", _tmp156_);
				_tmp158_ = _tmp157_;
				vala_report_error (_tmp153_, _tmp158_);
				_g_free0 (_tmp158_);
			}
			_tmp159_ = lambda_param;
			_tmp160_ = cb_param;
			_tmp161_ = vala_variable_get_variable_type ((ValaVariable*) _tmp160_);
			_tmp162_ = _tmp161_;
			_tmp163_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp164_ = _tmp163_;
			_tmp165_ = vala_data_type_get_actual_type (_tmp162_, _tmp164_, NULL, (ValaCodeNode*) self);
			_tmp166_ = _tmp165_;
			vala_variable_set_variable_type ((ValaVariable*) _tmp159_, _tmp166_);
			_vala_code_node_unref0 (_tmp166_);
			_tmp167_ = lambda_param;
			_tmp168_ = cb_param;
			vala_parameter_set_base_parameter (_tmp167_, _tmp168_);
			_tmp169_ = self->priv->_method;
			_tmp170_ = lambda_param;
			vala_callable_add_parameter ((ValaCallable*) _tmp169_, _tmp170_);
			_vala_code_node_unref0 (lambda_param);
			_vala_code_node_unref0 (cb_param);
		}
		_vala_iterable_unref0 (_cb_param_list);
	}
	_tmp171_ = lambda_param_it;
	if (vala_iterator_next (_tmp171_)) {
		ValaSourceReference* _tmp172_;
		ValaSourceReference* _tmp173_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp172_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp173_ = _tmp172_;
		vala_report_error (_tmp173_, "lambda expression: too many parameters");
		result = FALSE;
		_vala_iterator_unref0 (lambda_param_it);
		_vala_iterable_unref0 (lambda_params);
		_vala_code_node_unref0 (return_type);
		_vala_code_node_unref0 (cb);
		return result;
	}
	{
		ValaList* _error_type_list = NULL;
		ValaDelegate* _tmp174_;
		ValaList* _tmp175_;
		gint _error_type_size = 0;
		ValaList* _tmp176_;
		gint _tmp177_;
		gint _tmp178_;
		gint _error_type_index = 0;
		_tmp174_ = cb;
		_tmp175_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp174_);
		_error_type_list = _tmp175_;
		_tmp176_ = _error_type_list;
		_tmp177_ = vala_collection_get_size ((ValaCollection*) _tmp176_);
		_tmp178_ = _tmp177_;
		_error_type_size = _tmp178_;
		_error_type_index = -1;
		while (TRUE) {
			gint _tmp179_;
			gint _tmp180_;
			gint _tmp181_;
			ValaDataType* error_type = NULL;
			ValaList* _tmp182_;
			gint _tmp183_;
			gpointer _tmp184_;
			ValaMethod* _tmp185_;
			ValaDataType* _tmp186_;
			ValaDataType* _tmp187_;
			ValaDataType* _tmp188_;
			_tmp179_ = _error_type_index;
			_error_type_index = _tmp179_ + 1;
			_tmp180_ = _error_type_index;
			_tmp181_ = _error_type_size;
			if (!(_tmp180_ < _tmp181_)) {
				break;
			}
			_tmp182_ = _error_type_list;
			_tmp183_ = _error_type_index;
			_tmp184_ = vala_list_get (_tmp182_, _tmp183_);
			error_type = (ValaDataType*) _tmp184_;
			_tmp185_ = self->priv->_method;
			_tmp186_ = error_type;
			_tmp187_ = vala_data_type_copy (_tmp186_);
			_tmp188_ = _tmp187_;
			vala_code_node_add_error_type ((ValaCodeNode*) _tmp185_, _tmp188_);
			_vala_code_node_unref0 (_tmp188_);
			_vala_code_node_unref0 (error_type);
		}
		_vala_iterable_unref0 (_error_type_list);
	}
	_tmp189_ = self->priv->_expression_body;
	if (_tmp189_ != NULL) {
		ValaBlock* block = NULL;
		ValaSourceReference* _tmp190_;
		ValaSourceReference* _tmp191_;
		ValaBlock* _tmp192_;
		ValaBlock* _tmp193_;
		ValaScope* _tmp194_;
		ValaScope* _tmp195_;
		ValaMethod* _tmp196_;
		ValaScope* _tmp197_;
		ValaScope* _tmp198_;
		ValaMethod* _tmp199_;
		ValaDataType* _tmp200_;
		ValaDataType* _tmp201_;
		ValaTypeSymbol* _tmp202_;
		ValaTypeSymbol* _tmp203_;
		ValaMethod* _tmp216_;
		ValaBlock* _tmp217_;
		_tmp190_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp191_ = _tmp190_;
		_tmp192_ = vala_block_new (_tmp191_);
		block = _tmp192_;
		_tmp193_ = block;
		_tmp194_ = vala_symbol_get_scope ((ValaSymbol*) _tmp193_);
		_tmp195_ = _tmp194_;
		_tmp196_ = self->priv->_method;
		_tmp197_ = vala_symbol_get_scope ((ValaSymbol*) _tmp196_);
		_tmp198_ = _tmp197_;
		vala_scope_set_parent_scope (_tmp195_, _tmp198_);
		_tmp199_ = self->priv->_method;
		_tmp200_ = vala_callable_get_return_type ((ValaCallable*) _tmp199_);
		_tmp201_ = _tmp200_;
		_tmp202_ = vala_data_type_get_data_type (_tmp201_);
		_tmp203_ = _tmp202_;
		if (_tmp203_ != NULL) {
			ValaBlock* _tmp204_;
			ValaExpression* _tmp205_;
			ValaSourceReference* _tmp206_;
			ValaSourceReference* _tmp207_;
			ValaReturnStatement* _tmp208_;
			ValaReturnStatement* _tmp209_;
			_tmp204_ = block;
			_tmp205_ = self->priv->_expression_body;
			_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp207_ = _tmp206_;
			_tmp208_ = vala_return_statement_new (_tmp205_, _tmp207_);
			_tmp209_ = _tmp208_;
			vala_block_add_statement (_tmp204_, (ValaStatement*) _tmp209_);
			_vala_code_node_unref0 (_tmp209_);
		} else {
			ValaBlock* _tmp210_;
			ValaExpression* _tmp211_;
			ValaSourceReference* _tmp212_;
			ValaSourceReference* _tmp213_;
			ValaExpressionStatement* _tmp214_;
			ValaExpressionStatement* _tmp215_;
			_tmp210_ = block;
			_tmp211_ = self->priv->_expression_body;
			_tmp212_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp213_ = _tmp212_;
			_tmp214_ = vala_expression_statement_new (_tmp211_, _tmp213_);
			_tmp215_ = _tmp214_;
			vala_block_add_statement (_tmp210_, (ValaStatement*) _tmp215_);
			_vala_code_node_unref0 (_tmp215_);
		}
		_tmp216_ = self->priv->_method;
		_tmp217_ = block;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp216_, _tmp217_);
		_vala_code_node_unref0 (block);
	} else {
		ValaMethod* _tmp218_;
		ValaBlock* _tmp219_;
		_tmp218_ = self->priv->_method;
		_tmp219_ = self->priv->_statement_body;
		vala_subroutine_set_body ((ValaSubroutine*) _tmp218_, _tmp219_);
	}
	_tmp220_ = self->priv->_method;
	_tmp221_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp220_);
	_tmp222_ = _tmp221_;
	_tmp223_ = self->priv->_method;
	_tmp224_ = vala_symbol_get_scope ((ValaSymbol*) _tmp223_);
	_tmp225_ = _tmp224_;
	vala_symbol_set_owner ((ValaSymbol*) _tmp222_, _tmp225_);
	_tmp226_ = vala_code_context_get_analyzer (context);
	_tmp227_ = _tmp226_;
	_tmp228_ = vala_code_context_get_analyzer (context);
	_tmp229_ = _tmp228_;
	_tmp230_ = vala_semantic_analyzer_get_current_symbol (_tmp229_);
	_tmp231_ = _tmp230_;
	_tmp232_ = vala_semantic_analyzer_find_parent_method (_tmp227_, _tmp231_);
	m = _tmp232_;
	_tmp233_ = m;
	if (_tmp233_ != NULL) {
		{
			ValaList* _type_param_list = NULL;
			ValaMethod* _tmp234_;
			ValaList* _tmp235_;
			gint _type_param_size = 0;
			ValaList* _tmp236_;
			gint _tmp237_;
			gint _tmp238_;
			gint _type_param_index = 0;
			_tmp234_ = m;
			_tmp235_ = vala_method_get_type_parameters (_tmp234_);
			_type_param_list = _tmp235_;
			_tmp236_ = _type_param_list;
			_tmp237_ = vala_collection_get_size ((ValaCollection*) _tmp236_);
			_tmp238_ = _tmp237_;
			_type_param_size = _tmp238_;
			_type_param_index = -1;
			while (TRUE) {
				gint _tmp239_;
				gint _tmp240_;
				gint _tmp241_;
				ValaTypeParameter* type_param = NULL;
				ValaList* _tmp242_;
				gint _tmp243_;
				gpointer _tmp244_;
				ValaMethod* _tmp245_;
				ValaTypeParameter* _tmp246_;
				const gchar* _tmp247_;
				const gchar* _tmp248_;
				ValaTypeParameter* _tmp249_;
				ValaSourceReference* _tmp250_;
				ValaSourceReference* _tmp251_;
				ValaTypeParameter* _tmp252_;
				ValaTypeParameter* _tmp253_;
				ValaMethod* _tmp254_;
				ValaMethod* _tmp255_;
				ValaBlock* _tmp256_;
				ValaBlock* _tmp257_;
				_tmp239_ = _type_param_index;
				_type_param_index = _tmp239_ + 1;
				_tmp240_ = _type_param_index;
				_tmp241_ = _type_param_size;
				if (!(_tmp240_ < _tmp241_)) {
					break;
				}
				_tmp242_ = _type_param_list;
				_tmp243_ = _type_param_index;
				_tmp244_ = vala_list_get (_tmp242_, _tmp243_);
				type_param = (ValaTypeParameter*) _tmp244_;
				_tmp245_ = self->priv->_method;
				_tmp246_ = type_param;
				_tmp247_ = vala_symbol_get_name ((ValaSymbol*) _tmp246_);
				_tmp248_ = _tmp247_;
				_tmp249_ = type_param;
				_tmp250_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp249_);
				_tmp251_ = _tmp250_;
				_tmp252_ = vala_typeparameter_new (_tmp248_, _tmp251_);
				_tmp253_ = _tmp252_;
				vala_method_add_type_parameter (_tmp245_, _tmp253_);
				_vala_code_node_unref0 (_tmp253_);
				_tmp254_ = self->priv->_method;
				vala_method_set_closure (_tmp254_, TRUE);
				_tmp255_ = m;
				_tmp256_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp255_);
				_tmp257_ = _tmp256_;
				vala_block_set_captured (_tmp257_, TRUE);
				_vala_code_node_unref0 (type_param);
			}
			_vala_iterable_unref0 (_type_param_list);
		}
	}
	_tmp258_ = self->priv->_method;
	vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp258_);
	_tmp259_ = self->priv->_method;
	vala_code_node_check ((ValaCodeNode*) _tmp259_, context);
	_tmp260_ = self->priv->_method;
	_tmp261_ = vala_method_type_new (_tmp260_);
	_tmp262_ = _tmp261_;
	vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp262_);
	_vala_code_node_unref0 (_tmp262_);
	_tmp263_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp264_ = _tmp263_;
	_tmp265_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp266_ = _tmp265_;
	_tmp267_ = vala_data_type_get_value_owned (_tmp266_);
	_tmp268_ = _tmp267_;
	vala_data_type_set_value_owned (_tmp264_, _tmp268_);
	_tmp269_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp270_ = _tmp269_;
	result = !_tmp270_;
	_vala_code_node_unref0 (m);
	_vala_iterator_unref0 (lambda_param_it);
	_vala_iterable_unref0 (lambda_params);
	_vala_code_node_unref0 (return_type);
	_vala_code_node_unref0 (cb);
	return result;
}


static void
vala_lambda_expression_real_emit (ValaCodeNode* base,
                                  ValaCodeGenerator* codegen)
{
	ValaLambdaExpression * self;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (codegen != NULL);
	vala_code_visitor_visit_lambda_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_lambda_expression_real_get_used_variables (ValaCodeNode* base,
                                                ValaCollection* collection)
{
	ValaLambdaExpression * self;
	gboolean _tmp0_ = FALSE;
	ValaMethod* _tmp1_;
	self = (ValaLambdaExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp1_ = self->priv->_method;
	if (_tmp1_ != NULL) {
		ValaMethod* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->priv->_method;
		_tmp3_ = vala_method_get_closure (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ValaMethod* _tmp5_;
		_tmp5_ = self->priv->_method;
		vala_method_get_captured_variables (_tmp5_, G_TYPE_CHECK_INSTANCE_CAST (collection, VALA_TYPE_COLLECTION, ValaCollection));
	}
}


ValaExpression*
vala_lambda_expression_get_expression_body (ValaLambdaExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expression_body;
	result = _tmp0_;
	return result;
}


void
vala_lambda_expression_set_expression_body (ValaLambdaExpression* self,
                                            ValaExpression* value)
{
	ValaExpression* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_expression_body);
	self->priv->_expression_body = _tmp0_;
}


ValaBlock*
vala_lambda_expression_get_statement_body (ValaLambdaExpression* self)
{
	ValaBlock* result;
	ValaBlock* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_statement_body;
	result = _tmp0_;
	return result;
}


void
vala_lambda_expression_set_statement_body (ValaLambdaExpression* self,
                                           ValaBlock* value)
{
	ValaBlock* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_statement_body);
	self->priv->_statement_body = _tmp0_;
}


ValaMethod*
vala_lambda_expression_get_method (ValaLambdaExpression* self)
{
	ValaMethod* result;
	ValaMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_method;
	result = _tmp0_;
	return result;
}


void
vala_lambda_expression_set_method (ValaLambdaExpression* self,
                                   ValaMethod* value)
{
	ValaMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_method);
	self->priv->_method = _tmp0_;
}


static void
vala_lambda_expression_class_init (ValaLambdaExpressionClass * klass)
{
	vala_lambda_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_lambda_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaLambdaExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_lambda_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_lambda_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_lambda_expression_real_is_pure;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_lambda_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_lambda_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_lambda_expression_real_get_used_variables;
}


static void
vala_lambda_expression_instance_init (ValaLambdaExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_LAMBDA_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_PARAMETER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->parameters = (ValaList*) _tmp1_;
}


static void
vala_lambda_expression_finalize (ValaCodeNode * obj)
{
	ValaLambdaExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LAMBDA_EXPRESSION, ValaLambdaExpression);
	_vala_code_node_unref0 (self->priv->_expression_body);
	_vala_code_node_unref0 (self->priv->_statement_body);
	_vala_code_node_unref0 (self->priv->_method);
	_vala_iterable_unref0 (self->priv->parameters);
	VALA_CODE_NODE_CLASS (vala_lambda_expression_parent_class)->finalize (obj);
}


/**
 * Represents a lambda expression in the source code. Lambda expressions are
 * anonymous methods with implicitly typed parameters.
 */
GType
vala_lambda_expression_get_type (void)
{
	static volatile gsize vala_lambda_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_lambda_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLambdaExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lambda_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLambdaExpression), 0, (GInstanceInitFunc) vala_lambda_expression_instance_init, NULL };
		GType vala_lambda_expression_type_id;
		vala_lambda_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaLambdaExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_lambda_expression_type_id__volatile, vala_lambda_expression_type_id);
	}
	return vala_lambda_expression_type_id__volatile;
}



