/* valamethodcall.c generated by valac, the Vala compiler
 * generated from valamethodcall.vala, do not modify */

/* valamethodcall.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _ValaMethodCallPrivate {
	gboolean _is_yield_expression;
	gboolean _is_assert;
	gboolean _is_constructv_chainup;
	gboolean _is_chainup;
	ValaExpression* _call;
	ValaList* argument_list;
};


static gpointer vala_method_call_parent_class = NULL;

#define VALA_METHOD_CALL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_METHOD_CALL, ValaMethodCallPrivate))
static void vala_method_call_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor);
static void vala_method_call_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor);
static void vala_method_call_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node);
static gboolean vala_method_call_real_is_constant (ValaExpression* base);
static gboolean vala_method_call_real_is_pure (ValaExpression* base);
static gboolean vala_method_call_real_is_accessible (ValaExpression* base,
                                              ValaSymbol* sym);
static gboolean vala_method_call_real_check (ValaCodeNode* base,
                                      ValaCodeContext* context);
static void vala_method_call_set_is_assert (ValaMethodCall* self,
                                     gboolean value);
static void vala_method_call_set_is_chainup (ValaMethodCall* self,
                                      gboolean value);
static void vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                                 gboolean value);
static void vala_method_call_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen);
static void vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection);
static void vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection);
static gchar* vala_method_call_real_to_string (ValaCodeNode* base);
static void vala_method_call_finalize (ValaCodeNode * obj);


/**
 * Creates a new invocation expression.
 *
 * @param call             method to call
 * @param source_reference reference to source code
 * @return                 newly created invocation expression
 */
ValaMethodCall*
vala_method_call_construct (GType object_type,
                            ValaExpression* call,
                            ValaSourceReference* source_reference)
{
	ValaMethodCall* self = NULL;
	g_return_val_if_fail (call != NULL, NULL);
	self = (ValaMethodCall*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_method_call_set_call (self, call);
	return self;
}


ValaMethodCall*
vala_method_call_new (ValaExpression* call,
                      ValaSourceReference* source_reference)
{
	return vala_method_call_construct (VALA_TYPE_METHOD_CALL, call, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_method_call_add_argument (ValaMethodCall* self,
                               ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_method_call_get_argument_list (ValaMethodCall* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_method_call_real_accept (ValaCodeNode* base,
                              ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_method_call (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_method_call_real_accept_children (ValaCodeNode* base,
                                       ValaCodeVisitor* visitor)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _expr_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _expr_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_expr_list = _tmp3_;
		_tmp4_ = _expr_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_expr_size = _tmp6_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* expr = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _expr_index;
			_expr_index = _tmp7_ + 1;
			_tmp8_ = _expr_index;
			_tmp9_ = _expr_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _expr_list;
			_tmp11_ = _expr_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			expr = (ValaExpression*) _tmp12_;
			_tmp13_ = expr;
			vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
}


static void
vala_method_call_real_replace_expression (ValaCodeNode* base,
                                          ValaExpression* old_node,
                                          ValaExpression* new_node)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gint index = 0;
	ValaList* _tmp2_;
	gint _tmp3_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_method_call_set_call (self, new_node);
	}
	_tmp2_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp2_, old_node);
	_tmp3_ = index;
	if (_tmp3_ >= 0) {
		ValaList* _tmp4_;
		gint _tmp5_;
		_tmp4_ = self->priv->argument_list;
		_tmp5_ = index;
		vala_list_set (_tmp4_, _tmp5_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_method_call_real_is_constant (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	self = (ValaMethodCall*) base;
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp5_ = method_type;
	if (_tmp5_ != NULL) {
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gboolean _tmp11_;
		_tmp6_ = method_type;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strcmp0 (_tmp10_, "GLib.N_") == 0;
		_g_free0 (_tmp10_);
		if (_tmp11_) {
			ValaList* _tmp12_;
			gpointer _tmp13_;
			ValaExpression* _tmp14_;
			gboolean _tmp15_;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_list_get (_tmp12_, 0);
			_tmp14_ = (ValaExpression*) _tmp13_;
			_tmp15_ = vala_expression_is_constant (_tmp14_);
			_vala_code_node_unref0 (_tmp14_);
			result = _tmp15_;
			_vala_code_node_unref0 (method_type);
			return result;
		} else {
			ValaMethodType* _tmp16_;
			ValaMethod* _tmp17_;
			ValaMethod* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gboolean _tmp21_;
			_tmp16_ = method_type;
			_tmp17_ = vala_method_type_get_method_symbol (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strcmp0 (_tmp20_, "GLib.NC_") == 0;
			_g_free0 (_tmp20_);
			if (_tmp21_) {
				ValaList* _tmp22_;
				gpointer _tmp23_;
				ValaExpression* _tmp24_;
				gboolean _tmp25_;
				_tmp22_ = self->priv->argument_list;
				_tmp23_ = vala_list_get (_tmp22_, 1);
				_tmp24_ = (ValaExpression*) _tmp23_;
				_tmp25_ = vala_expression_is_constant (_tmp24_);
				_vala_code_node_unref0 (_tmp24_);
				result = _tmp25_;
				_vala_code_node_unref0 (method_type);
				return result;
			}
		}
	}
	result = FALSE;
	_vala_code_node_unref0 (method_type);
	return result;
}


static gboolean
vala_method_call_real_is_pure (ValaExpression* base)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	self = (ValaMethodCall*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_method_call_real_is_accessible (ValaExpression* base,
                                     ValaSymbol* sym)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			if (!vala_expression_is_accessible (_tmp11_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp12_ = vala_method_call_get_call (self);
	_tmp13_ = _tmp12_;
	result = vala_expression_is_accessible (_tmp13_, sym);
	return result;
}


static gboolean
vala_method_call_real_check (ValaCodeNode* base,
                             ValaCodeContext* context)
{
	ValaMethodCall * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaDataType* target_object_type = NULL;
	ValaList* method_type_args = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* mtype = NULL;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	gboolean gobject_chainup = FALSE;
	ValaExpression* _tmp114_;
	ValaExpression* _tmp115_;
	ValaSymbol* _tmp116_;
	ValaSymbol* _tmp117_;
	ValaSemanticAnalyzer* _tmp118_;
	ValaSemanticAnalyzer* _tmp119_;
	ValaClass* _tmp120_;
	gboolean _tmp121_;
	gboolean _tmp122_;
	ValaCreationMethod* base_cm = NULL;
	gboolean _tmp145_;
	gboolean _tmp239_ = FALSE;
	ValaExpression* _tmp240_;
	ValaExpression* _tmp241_;
	gboolean _tmp315_ = FALSE;
	gboolean _tmp316_;
	ValaDataType* ret_type = NULL;
	ValaDataType* _tmp331_;
	ValaDataType* _tmp332_;
	ValaList* params = NULL;
	ValaDataType* _tmp333_;
	ValaList* _tmp334_;
	ValaDataType* _tmp335_;
	ValaExpression* last_arg = NULL;
	ValaList* args = NULL;
	ValaList* _tmp408_;
	ValaIterator* arg_it = NULL;
	ValaList* _tmp409_;
	ValaIterator* _tmp410_;
	gboolean _tmp463_ = FALSE;
	ValaDataType* _tmp464_;
	gboolean _tmp489_ = FALSE;
	ValaDataType* _tmp490_;
	ValaDataType* _tmp565_;
	ValaDataType* _tmp576_;
	ValaDataType* _tmp577_;
	ValaDataType* _tmp578_;
	ValaDataType* _tmp579_;
	ValaDataType* _tmp580_;
	ValaDataType* _tmp581_;
	ValaList* _tmp582_;
	ValaDataType* _tmp583_;
	ValaDataType* _tmp584_;
	gboolean may_throw = FALSE;
	ValaDataType* _tmp585_;
	ValaSemanticAnalyzer* _tmp906_;
	ValaSemanticAnalyzer* _tmp907_;
	ValaDataType* _tmp908_;
	ValaList* _tmp909_;
	ValaList* _tmp910_;
	ValaList* _tmp911_;
	gboolean _tmp912_;
	gboolean _tmp941_ = FALSE;
	gboolean _tmp942_ = FALSE;
	ValaCreationMethod* _tmp943_;
	gboolean _tmp972_;
	gboolean _tmp1028_;
	gboolean _tmp1029_;
	self = (ValaMethodCall*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_method_call_get_call (self);
	_tmp5_ = _tmp4_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp5_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	target_object_type = NULL;
	method_type_args = NULL;
	_tmp6_ = vala_method_call_get_call (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_expression_get_value_type (_tmp7_);
	_tmp9_ = _tmp8_;
	if (VALA_IS_DELEGATE_TYPE (_tmp9_)) {
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaDataType* _tmp12_;
		ValaDataType* _tmp13_;
		ValaDataType* _tmp14_;
		_tmp10_ = vala_method_call_get_call (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_value_type (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (_tmp13_);
		_vala_code_node_unref0 (target_object_type);
		target_object_type = _tmp14_;
	} else {
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		_tmp15_ = vala_method_call_get_call (self);
		_tmp16_ = _tmp15_;
		if (VALA_IS_MEMBER_ACCESS (_tmp16_)) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp17_;
			ValaExpression* _tmp18_;
			ValaMemberAccess* _tmp19_;
			ValaMemberAccess* _tmp20_;
			gboolean _tmp21_;
			gboolean _tmp22_;
			ValaMemberAccess* _tmp33_;
			ValaList* _tmp34_;
			ValaMemberAccess* _tmp35_;
			ValaExpression* _tmp36_;
			ValaExpression* _tmp37_;
			gboolean _tmp91_ = FALSE;
			ValaMemberAccess* _tmp92_;
			ValaSymbol* _tmp93_;
			ValaSymbol* _tmp94_;
			_tmp17_ = vala_method_call_get_call (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp19_;
			_tmp20_ = ma;
			_tmp21_ = vala_member_access_get_prototype_access (_tmp20_);
			_tmp22_ = _tmp21_;
			if (_tmp22_) {
				ValaSourceReference* _tmp23_;
				ValaSourceReference* _tmp24_;
				ValaExpression* _tmp25_;
				ValaExpression* _tmp26_;
				ValaSymbol* _tmp27_;
				ValaSymbol* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp23_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp24_ = _tmp23_;
				_tmp25_ = vala_method_call_get_call (self);
				_tmp26_ = _tmp25_;
				_tmp27_ = vala_expression_get_symbol_reference (_tmp26_);
				_tmp28_ = _tmp27_;
				_tmp29_ = vala_symbol_get_full_name (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp30_);
				_tmp32_ = _tmp31_;
				vala_report_error (_tmp24_, _tmp32_);
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_tmp33_ = ma;
			_tmp34_ = vala_member_access_get_type_arguments (_tmp33_);
			_vala_iterable_unref0 (method_type_args);
			method_type_args = _tmp34_;
			_tmp35_ = ma;
			_tmp36_ = vala_member_access_get_inner (_tmp35_);
			_tmp37_ = _tmp36_;
			if (_tmp37_ != NULL) {
				ValaMemberAccess* _tmp38_;
				ValaExpression* _tmp39_;
				ValaExpression* _tmp40_;
				ValaDataType* _tmp41_;
				ValaDataType* _tmp42_;
				ValaDataType* _tmp43_;
				ValaMemberAccess* _tmp44_;
				ValaExpression* _tmp45_;
				ValaExpression* _tmp46_;
				ValaSymbol* _tmp47_;
				ValaSymbol* _tmp48_;
				ValaMethod* m = NULL;
				ValaMemberAccess* _tmp60_;
				ValaSymbol* _tmp61_;
				ValaSymbol* _tmp62_;
				ValaMethod* _tmp63_;
				gboolean _tmp64_ = FALSE;
				ValaMethod* _tmp65_;
				_tmp38_ = ma;
				_tmp39_ = vala_member_access_get_inner (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_expression_get_value_type (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = _vala_code_node_ref0 (_tmp42_);
				_vala_code_node_unref0 (target_object_type);
				target_object_type = _tmp43_;
				_tmp44_ = ma;
				_tmp45_ = vala_member_access_get_inner (_tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = vala_expression_get_symbol_reference (_tmp46_);
				_tmp48_ = _tmp47_;
				if (VALA_IS_SIGNAL (_tmp48_)) {
					ValaMemberAccess* sig = NULL;
					ValaMemberAccess* _tmp49_;
					ValaExpression* _tmp50_;
					ValaExpression* _tmp51_;
					ValaMemberAccess* _tmp52_;
					ValaMemberAccess* _tmp53_;
					_tmp49_ = ma;
					_tmp50_ = vala_member_access_get_inner (_tmp49_);
					_tmp51_ = _tmp50_;
					_tmp52_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp51_) ? ((ValaMemberAccess*) _tmp51_) : NULL);
					sig = _tmp52_;
					_tmp53_ = sig;
					if (_tmp53_ != NULL) {
						ValaMemberAccess* _tmp54_;
						ValaExpression* _tmp55_;
						ValaExpression* _tmp56_;
						ValaDataType* _tmp57_;
						ValaDataType* _tmp58_;
						ValaDataType* _tmp59_;
						_tmp54_ = sig;
						_tmp55_ = vala_member_access_get_inner (_tmp54_);
						_tmp56_ = _tmp55_;
						_tmp57_ = vala_expression_get_value_type (_tmp56_);
						_tmp58_ = _tmp57_;
						_tmp59_ = _vala_code_node_ref0 (_tmp58_);
						_vala_code_node_unref0 (target_object_type);
						target_object_type = _tmp59_;
					}
					_vala_code_node_unref0 (sig);
				}
				_tmp60_ = ma;
				_tmp61_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp62_) ? ((ValaMethod*) _tmp62_) : NULL);
				m = _tmp63_;
				_tmp65_ = m;
				if (_tmp65_ != NULL) {
					ValaMethod* _tmp66_;
					gboolean _tmp67_;
					gboolean _tmp68_;
					_tmp66_ = m;
					_tmp67_ = vala_method_get_coroutine (_tmp66_);
					_tmp68_ = _tmp67_;
					_tmp64_ = _tmp68_;
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					gboolean _tmp69_ = FALSE;
					ValaMemberAccess* _tmp70_;
					const gchar* _tmp71_;
					const gchar* _tmp72_;
					_tmp70_ = ma;
					_tmp71_ = vala_member_access_get_member_name (_tmp70_);
					_tmp72_ = _tmp71_;
					if (g_strcmp0 (_tmp72_, "begin") == 0) {
						_tmp69_ = TRUE;
					} else {
						ValaMemberAccess* _tmp73_;
						const gchar* _tmp74_;
						const gchar* _tmp75_;
						_tmp73_ = ma;
						_tmp74_ = vala_member_access_get_member_name (_tmp73_);
						_tmp75_ = _tmp74_;
						_tmp69_ = g_strcmp0 (_tmp75_, "end") == 0;
					}
					if (_tmp69_) {
						ValaMemberAccess* method_access = NULL;
						ValaMemberAccess* _tmp76_;
						ValaExpression* _tmp77_;
						ValaExpression* _tmp78_;
						ValaMemberAccess* _tmp79_;
						gboolean _tmp80_ = FALSE;
						ValaMemberAccess* _tmp81_;
						_tmp76_ = ma;
						_tmp77_ = vala_member_access_get_inner (_tmp76_);
						_tmp78_ = _tmp77_;
						_tmp79_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp78_) ? ((ValaMemberAccess*) _tmp78_) : NULL);
						method_access = _tmp79_;
						_tmp81_ = method_access;
						if (_tmp81_ != NULL) {
							ValaMemberAccess* _tmp82_;
							ValaExpression* _tmp83_;
							ValaExpression* _tmp84_;
							_tmp82_ = method_access;
							_tmp83_ = vala_member_access_get_inner (_tmp82_);
							_tmp84_ = _tmp83_;
							_tmp80_ = _tmp84_ != NULL;
						} else {
							_tmp80_ = FALSE;
						}
						if (_tmp80_) {
							ValaMemberAccess* _tmp85_;
							ValaExpression* _tmp86_;
							ValaExpression* _tmp87_;
							ValaDataType* _tmp88_;
							ValaDataType* _tmp89_;
							ValaDataType* _tmp90_;
							_tmp85_ = method_access;
							_tmp86_ = vala_member_access_get_inner (_tmp85_);
							_tmp87_ = _tmp86_;
							_tmp88_ = vala_expression_get_value_type (_tmp87_);
							_tmp89_ = _tmp88_;
							_tmp90_ = _vala_code_node_ref0 (_tmp89_);
							_vala_code_node_unref0 (target_object_type);
							target_object_type = _tmp90_;
						} else {
							_vala_code_node_unref0 (target_object_type);
							target_object_type = NULL;
						}
						_vala_code_node_unref0 (method_access);
					}
				}
				_vala_code_node_unref0 (m);
			}
			_tmp92_ = ma;
			_tmp93_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp92_);
			_tmp94_ = _tmp93_;
			if (_tmp94_ != NULL) {
				ValaMemberAccess* _tmp95_;
				ValaSymbol* _tmp96_;
				ValaSymbol* _tmp97_;
				ValaAttribute* _tmp98_;
				ValaAttribute* _tmp99_;
				_tmp95_ = ma;
				_tmp96_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp95_);
				_tmp97_ = _tmp96_;
				_tmp98_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp97_, "Assert");
				_tmp99_ = _tmp98_;
				_tmp91_ = _tmp99_ != NULL;
				_vala_code_node_unref0 (_tmp99_);
			} else {
				_tmp91_ = FALSE;
			}
			if (_tmp91_) {
				ValaList* args = NULL;
				ValaList* _tmp100_;
				ValaList* _tmp101_;
				gint _tmp102_;
				gint _tmp103_;
				vala_method_call_set_is_assert (self, TRUE);
				_tmp100_ = vala_method_call_get_argument_list (self);
				args = _tmp100_;
				_tmp101_ = args;
				_tmp102_ = vala_collection_get_size ((ValaCollection*) _tmp101_);
				_tmp103_ = _tmp102_;
				if (_tmp103_ == 1) {
					ValaList* _tmp104_;
					gpointer _tmp105_;
					ValaExpression* _tmp106_;
					ValaSourceReference* _tmp107_;
					ValaSourceReference* _tmp108_;
					_tmp104_ = args;
					_tmp105_ = vala_list_get (_tmp104_, 0);
					_tmp106_ = (ValaExpression*) _tmp105_;
					_tmp107_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp106_);
					_tmp108_ = _tmp107_;
					vala_code_node_set_source_reference ((ValaCodeNode*) self, _tmp108_);
					_vala_code_node_unref0 (_tmp106_);
				}
				_vala_iterable_unref0 (args);
			}
			_vala_code_node_unref0 (ma);
		}
	}
	_tmp109_ = vala_method_call_get_call (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_expression_get_value_type (_tmp110_);
	_tmp112_ = _tmp111_;
	_tmp113_ = _vala_code_node_ref0 (_tmp112_);
	mtype = _tmp113_;
	_tmp114_ = vala_method_call_get_call (self);
	_tmp115_ = _tmp114_;
	_tmp116_ = vala_expression_get_symbol_reference (_tmp115_);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_code_context_get_analyzer (context);
	_tmp119_ = _tmp118_;
	_tmp120_ = _tmp119_->object_type;
	gobject_chainup = _tmp117_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp120_, VALA_TYPE_SYMBOL, ValaSymbol);
	_tmp121_ = gobject_chainup;
	vala_method_call_set_is_chainup (self, _tmp121_);
	_tmp122_ = gobject_chainup;
	if (!_tmp122_) {
		ValaExpression* expr = NULL;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaExpression* _tmp125_;
		ValaMemberAccess* ma = NULL;
		ValaExpression* _tmp126_;
		ValaMemberAccess* _tmp127_;
		gboolean _tmp128_ = FALSE;
		ValaMemberAccess* _tmp129_;
		gboolean _tmp139_ = FALSE;
		ValaMemberAccess* _tmp140_;
		_tmp123_ = vala_method_call_get_call (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = _vala_code_node_ref0 (_tmp124_);
		expr = _tmp125_;
		_tmp126_ = expr;
		_tmp127_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp126_) ? ((ValaMemberAccess*) _tmp126_) : NULL);
		ma = _tmp127_;
		_tmp129_ = ma;
		if (_tmp129_ != NULL) {
			ValaMemberAccess* _tmp130_;
			ValaSymbol* _tmp131_;
			ValaSymbol* _tmp132_;
			_tmp130_ = ma;
			_tmp131_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp130_);
			_tmp132_ = _tmp131_;
			_tmp128_ = VALA_IS_CREATION_METHOD (_tmp132_);
		} else {
			_tmp128_ = FALSE;
		}
		if (_tmp128_) {
			ValaMemberAccess* _tmp133_;
			ValaExpression* _tmp134_;
			ValaExpression* _tmp135_;
			ValaExpression* _tmp136_;
			ValaExpression* _tmp137_;
			ValaMemberAccess* _tmp138_;
			_tmp133_ = ma;
			_tmp134_ = vala_member_access_get_inner (_tmp133_);
			_tmp135_ = _tmp134_;
			_tmp136_ = _vala_code_node_ref0 (_tmp135_);
			_vala_code_node_unref0 (expr);
			expr = _tmp136_;
			_tmp137_ = expr;
			_tmp138_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp137_) ? ((ValaMemberAccess*) _tmp137_) : NULL);
			_vala_code_node_unref0 (ma);
			ma = _tmp138_;
		}
		_tmp140_ = ma;
		if (_tmp140_ != NULL) {
			ValaMemberAccess* _tmp141_;
			const gchar* _tmp142_;
			const gchar* _tmp143_;
			_tmp141_ = ma;
			_tmp142_ = vala_member_access_get_member_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp139_ = g_strcmp0 (_tmp143_, "this") == 0;
		} else {
			_tmp139_ = FALSE;
		}
		if (_tmp139_) {
			vala_method_call_set_is_chainup (self, TRUE);
		} else {
			ValaExpression* _tmp144_;
			_tmp144_ = expr;
			if (VALA_IS_BASE_ACCESS (_tmp144_)) {
				vala_method_call_set_is_chainup (self, TRUE);
			}
		}
		_vala_code_node_unref0 (ma);
		_vala_code_node_unref0 (expr);
	}
	base_cm = NULL;
	_tmp145_ = self->priv->_is_chainup;
	if (_tmp145_) {
		ValaCreationMethod* cm = NULL;
		ValaSemanticAnalyzer* _tmp146_;
		ValaSemanticAnalyzer* _tmp147_;
		ValaMethod* _tmp148_;
		ValaCreationMethod* _tmp149_;
		ValaCreationMethod* _tmp150_;
		ValaCreationMethod* _tmp158_;
		ValaDataType* _tmp159_;
		_tmp146_ = vala_code_context_get_analyzer (context);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_semantic_analyzer_find_current_method (_tmp147_);
		_tmp149_ = VALA_IS_CREATION_METHOD (_tmp148_) ? ((ValaCreationMethod*) _tmp148_) : NULL;
		if (_tmp149_ == NULL) {
			_vala_code_node_unref0 (_tmp148_);
		}
		cm = _tmp149_;
		_tmp150_ = cm;
		if (_tmp150_ == NULL) {
			ValaSourceReference* _tmp151_;
			ValaSourceReference* _tmp152_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp152_ = _tmp151_;
			vala_report_error (_tmp152_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (cm);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		} else {
			ValaCreationMethod* _tmp153_;
			gboolean _tmp154_;
			gboolean _tmp155_;
			_tmp153_ = cm;
			_tmp154_ = vala_creation_method_get_chain_up (_tmp153_);
			_tmp155_ = _tmp154_;
			if (_tmp155_) {
				ValaSourceReference* _tmp156_;
				ValaSourceReference* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp156_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp157_, "Multiple constructor calls in the same constructor are not permitted");
				result = FALSE;
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
		_tmp158_ = cm;
		vala_creation_method_set_chain_up (_tmp158_, TRUE);
		_tmp159_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp159_)) {
			ValaObjectType* otype = NULL;
			ValaDataType* _tmp160_;
			ValaObjectType* _tmp161_;
			ValaClass* cl = NULL;
			ValaObjectType* _tmp162_;
			ValaObjectTypeSymbol* _tmp163_;
			ValaObjectTypeSymbol* _tmp164_;
			ValaClass* _tmp165_;
			ValaClass* _tmp166_;
			ValaCreationMethod* _tmp167_;
			ValaCreationMethod* _tmp168_;
			ValaCreationMethod* _tmp169_;
			ValaCreationMethod* _tmp170_;
			_tmp160_ = mtype;
			_tmp161_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp160_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			otype = _tmp161_;
			_tmp162_ = otype;
			_tmp163_ = vala_object_type_get_type_symbol (_tmp162_);
			_tmp164_ = _tmp163_;
			_tmp165_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp164_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp165_;
			_tmp166_ = cl;
			_tmp167_ = vala_class_get_default_construction_method (_tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = _vala_code_node_ref0 (_tmp168_);
			_vala_code_node_unref0 (base_cm);
			base_cm = _tmp169_;
			_tmp170_ = base_cm;
			if (_tmp170_ == NULL) {
				ValaSourceReference* _tmp171_;
				ValaSourceReference* _tmp172_;
				ValaClass* _tmp173_;
				gchar* _tmp174_;
				gchar* _tmp175_;
				gchar* _tmp176_;
				gchar* _tmp177_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp171_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp172_ = _tmp171_;
				_tmp173_ = cl;
				_tmp174_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp173_);
				_tmp175_ = _tmp174_;
				_tmp176_ = g_strdup_printf ("chain up to `%s' not supported", _tmp175_);
				_tmp177_ = _tmp176_;
				vala_report_error (_tmp172_, _tmp177_);
				_g_free0 (_tmp177_);
				_g_free0 (_tmp175_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (otype);
				_vala_code_node_unref0 (cm);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaCreationMethod* _tmp178_;
				gboolean _tmp179_;
				gboolean _tmp180_;
				_tmp178_ = base_cm;
				_tmp179_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp178_);
				_tmp180_ = _tmp179_;
				if (!_tmp180_) {
					ValaSourceReference* _tmp181_;
					ValaSourceReference* _tmp182_;
					ValaCreationMethod* _tmp183_;
					gchar* _tmp184_;
					gchar* _tmp185_;
					gchar* _tmp186_;
					gchar* _tmp187_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp181_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp182_ = _tmp181_;
					_tmp183_ = base_cm;
					_tmp184_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp183_);
					_tmp185_ = _tmp184_;
					_tmp186_ = g_strdup_printf ("chain up to `%s' not supported", _tmp185_);
					_tmp187_ = _tmp186_;
					vala_report_error (_tmp182_, _tmp187_);
					_g_free0 (_tmp187_);
					_g_free0 (_tmp185_);
					result = FALSE;
					_vala_code_node_unref0 (cl);
					_vala_code_node_unref0 (otype);
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (otype);
		} else {
			gboolean _tmp188_ = FALSE;
			ValaExpression* _tmp189_;
			ValaExpression* _tmp190_;
			ValaSymbol* _tmp191_;
			ValaSymbol* _tmp192_;
			_tmp189_ = vala_method_call_get_call (self);
			_tmp190_ = _tmp189_;
			_tmp191_ = vala_expression_get_symbol_reference (_tmp190_);
			_tmp192_ = _tmp191_;
			if (VALA_IS_CREATION_METHOD (_tmp192_)) {
				ValaExpression* _tmp193_;
				ValaExpression* _tmp194_;
				ValaSymbol* _tmp195_;
				ValaSymbol* _tmp196_;
				ValaSymbol* _tmp197_;
				ValaSymbol* _tmp198_;
				_tmp193_ = vala_method_call_get_call (self);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_expression_get_symbol_reference (_tmp194_);
				_tmp196_ = _tmp195_;
				_tmp197_ = vala_symbol_get_parent_symbol (_tmp196_);
				_tmp198_ = _tmp197_;
				_tmp188_ = VALA_IS_CLASS (_tmp198_);
			} else {
				_tmp188_ = FALSE;
			}
			if (_tmp188_) {
				ValaExpression* _tmp199_;
				ValaExpression* _tmp200_;
				ValaSymbol* _tmp201_;
				ValaSymbol* _tmp202_;
				ValaCreationMethod* _tmp203_;
				ValaCreationMethod* _tmp204_;
				gboolean _tmp205_;
				gboolean _tmp206_;
				_tmp199_ = vala_method_call_get_call (self);
				_tmp200_ = _tmp199_;
				_tmp201_ = vala_expression_get_symbol_reference (_tmp200_);
				_tmp202_ = _tmp201_;
				_tmp203_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp202_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_vala_code_node_unref0 (base_cm);
				base_cm = _tmp203_;
				_tmp204_ = base_cm;
				_tmp205_ = vala_method_get_has_construct_function ((ValaMethod*) _tmp204_);
				_tmp206_ = _tmp205_;
				if (!_tmp206_) {
					ValaSourceReference* _tmp207_;
					ValaSourceReference* _tmp208_;
					ValaCreationMethod* _tmp209_;
					gchar* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp207_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp208_ = _tmp207_;
					_tmp209_ = base_cm;
					_tmp210_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp209_);
					_tmp211_ = _tmp210_;
					_tmp212_ = g_strdup_printf ("chain up to `%s' not supported", _tmp211_);
					_tmp213_ = _tmp212_;
					vala_report_error (_tmp208_, _tmp213_);
					_g_free0 (_tmp213_);
					_g_free0 (_tmp211_);
					result = FALSE;
					_vala_code_node_unref0 (cm);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			} else {
				gboolean _tmp214_;
				_tmp214_ = gobject_chainup;
				if (_tmp214_) {
					ValaClass* cl = NULL;
					ValaCreationMethod* _tmp215_;
					ValaSymbol* _tmp216_;
					ValaSymbol* _tmp217_;
					ValaClass* _tmp218_;
					gboolean _tmp219_ = FALSE;
					ValaClass* _tmp220_;
					ValaExpression* _tmp227_;
					ValaExpression* _tmp228_;
					ValaSemanticAnalyzer* _tmp229_;
					ValaSemanticAnalyzer* _tmp230_;
					ValaClass* _tmp231_;
					ValaObjectType* _tmp232_;
					ValaObjectType* _tmp233_;
					ValaExpression* _tmp234_;
					ValaExpression* _tmp235_;
					ValaDataType* _tmp236_;
					ValaDataType* _tmp237_;
					ValaDataType* _tmp238_;
					_tmp215_ = cm;
					_tmp216_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp215_);
					_tmp217_ = _tmp216_;
					_tmp218_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp217_) ? ((ValaClass*) _tmp217_) : NULL);
					cl = _tmp218_;
					_tmp220_ = cl;
					if (_tmp220_ == NULL) {
						_tmp219_ = TRUE;
					} else {
						ValaClass* _tmp221_;
						ValaSemanticAnalyzer* _tmp222_;
						ValaSemanticAnalyzer* _tmp223_;
						ValaClass* _tmp224_;
						_tmp221_ = cl;
						_tmp222_ = vala_code_context_get_analyzer (context);
						_tmp223_ = _tmp222_;
						_tmp224_ = _tmp223_->object_type;
						_tmp219_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp221_, (ValaTypeSymbol*) _tmp224_);
					}
					if (_tmp219_) {
						ValaSourceReference* _tmp225_;
						ValaSourceReference* _tmp226_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp225_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp226_ = _tmp225_;
						vala_report_error (_tmp226_, "chain up to `GLib.Object' not supported");
						result = FALSE;
						_vala_code_node_unref0 (cl);
						_vala_code_node_unref0 (cm);
						_vala_code_node_unref0 (base_cm);
						_vala_code_node_unref0 (mtype);
						_vala_iterable_unref0 (method_type_args);
						_vala_code_node_unref0 (target_object_type);
						return result;
					}
					_tmp227_ = vala_method_call_get_call (self);
					_tmp228_ = _tmp227_;
					_tmp229_ = vala_code_context_get_analyzer (context);
					_tmp230_ = _tmp229_;
					_tmp231_ = _tmp230_->object_type;
					_tmp232_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp231_);
					_tmp233_ = _tmp232_;
					vala_expression_set_value_type (_tmp228_, (ValaDataType*) _tmp233_);
					_vala_code_node_unref0 (_tmp233_);
					_tmp234_ = vala_method_call_get_call (self);
					_tmp235_ = _tmp234_;
					_tmp236_ = vala_expression_get_value_type (_tmp235_);
					_tmp237_ = _tmp236_;
					_tmp238_ = _vala_code_node_ref0 (_tmp237_);
					_vala_code_node_unref0 (mtype);
					mtype = _tmp238_;
					_vala_code_node_unref0 (cl);
				}
			}
		}
		_vala_code_node_unref0 (cm);
	}
	_tmp240_ = vala_method_call_get_call (self);
	_tmp241_ = _tmp240_;
	if (VALA_IS_MEMBER_ACCESS (_tmp241_)) {
		gboolean _tmp242_ = FALSE;
		gboolean _tmp243_ = FALSE;
		ValaExpression* _tmp244_;
		ValaExpression* _tmp245_;
		ValaSymbol* _tmp246_;
		ValaSymbol* _tmp247_;
		_tmp244_ = vala_method_call_get_call (self);
		_tmp245_ = _tmp244_;
		_tmp246_ = vala_expression_get_symbol_reference (_tmp245_);
		_tmp247_ = _tmp246_;
		if (VALA_IS_CREATION_METHOD (_tmp247_)) {
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			ValaSymbol* _tmp250_;
			ValaSymbol* _tmp251_;
			ValaSymbol* _tmp252_;
			ValaSymbol* _tmp253_;
			_tmp248_ = vala_method_call_get_call (self);
			_tmp249_ = _tmp248_;
			_tmp250_ = vala_expression_get_symbol_reference (_tmp249_);
			_tmp251_ = _tmp250_;
			_tmp252_ = vala_symbol_get_parent_symbol (_tmp251_);
			_tmp253_ = _tmp252_;
			_tmp243_ = VALA_IS_STRUCT (_tmp253_);
		} else {
			_tmp243_ = FALSE;
		}
		if (_tmp243_) {
			_tmp242_ = TRUE;
		} else {
			ValaExpression* _tmp254_;
			ValaExpression* _tmp255_;
			ValaSymbol* _tmp256_;
			ValaSymbol* _tmp257_;
			_tmp254_ = vala_method_call_get_call (self);
			_tmp255_ = _tmp254_;
			_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
			_tmp257_ = _tmp256_;
			_tmp242_ = VALA_IS_STRUCT (_tmp257_);
		}
		_tmp239_ = _tmp242_;
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		ValaStruct* st = NULL;
		ValaExpression* _tmp258_;
		ValaExpression* _tmp259_;
		ValaSymbol* _tmp260_;
		ValaSymbol* _tmp261_;
		ValaStruct* _tmp262_;
		gboolean _tmp263_ = FALSE;
		gboolean _tmp264_ = FALSE;
		ValaStruct* _tmp265_;
		ValaObjectCreationExpression* struct_creation_expression = NULL;
		ValaExpression* _tmp276_;
		ValaExpression* _tmp277_;
		ValaSourceReference* _tmp278_;
		ValaSourceReference* _tmp279_;
		ValaObjectCreationExpression* _tmp280_;
		ValaObjectCreationExpression* _tmp281_;
		ValaObjectCreationExpression* _tmp294_;
		ValaDataType* _tmp295_;
		ValaDataType* _tmp296_;
		ValaSemanticAnalyzer* _tmp297_;
		ValaSemanticAnalyzer* _tmp298_;
		ValaList* _tmp299_;
		ValaCodeNode* _tmp300_;
		ValaCodeNode* _tmp301_;
		ValaObjectCreationExpression* _tmp302_;
		ValaObjectCreationExpression* _tmp303_;
		_tmp258_ = vala_method_call_get_call (self);
		_tmp259_ = _tmp258_;
		_tmp260_ = vala_expression_get_symbol_reference (_tmp259_);
		_tmp261_ = _tmp260_;
		_tmp262_ = _vala_code_node_ref0 (VALA_IS_STRUCT (_tmp261_) ? ((ValaStruct*) _tmp261_) : NULL);
		st = _tmp262_;
		_tmp265_ = st;
		if (_tmp265_ != NULL) {
			ValaStruct* _tmp266_;
			ValaMethod* _tmp267_;
			ValaMethod* _tmp268_;
			_tmp266_ = st;
			_tmp267_ = vala_struct_get_default_construction_method (_tmp266_);
			_tmp268_ = _tmp267_;
			_tmp264_ = _tmp268_ == NULL;
		} else {
			_tmp264_ = FALSE;
		}
		if (_tmp264_) {
			gboolean _tmp269_ = FALSE;
			gboolean _tmp270_ = FALSE;
			ValaStruct* _tmp271_;
			_tmp271_ = st;
			if (vala_struct_is_boolean_type (_tmp271_)) {
				_tmp270_ = TRUE;
			} else {
				ValaStruct* _tmp272_;
				_tmp272_ = st;
				_tmp270_ = vala_struct_is_integer_type (_tmp272_);
			}
			if (_tmp270_) {
				_tmp269_ = TRUE;
			} else {
				ValaStruct* _tmp273_;
				_tmp273_ = st;
				_tmp269_ = vala_struct_is_floating_type (_tmp273_);
			}
			_tmp263_ = _tmp269_;
		} else {
			_tmp263_ = FALSE;
		}
		if (_tmp263_) {
			ValaSourceReference* _tmp274_;
			ValaSourceReference* _tmp275_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp275_ = _tmp274_;
			vala_report_error (_tmp275_, "invocation not supported in this context");
			result = FALSE;
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
		_tmp276_ = vala_method_call_get_call (self);
		_tmp277_ = _tmp276_;
		_tmp278_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp279_ = _tmp278_;
		_tmp280_ = vala_object_creation_expression_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp277_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess), _tmp279_);
		struct_creation_expression = _tmp280_;
		_tmp281_ = struct_creation_expression;
		vala_object_creation_expression_set_struct_creation (_tmp281_, TRUE);
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp282_;
			gint _arg_size = 0;
			ValaList* _tmp283_;
			gint _tmp284_;
			gint _tmp285_;
			gint _arg_index = 0;
			_tmp282_ = vala_method_call_get_argument_list (self);
			_arg_list = _tmp282_;
			_tmp283_ = _arg_list;
			_tmp284_ = vala_collection_get_size ((ValaCollection*) _tmp283_);
			_tmp285_ = _tmp284_;
			_arg_size = _tmp285_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp286_;
				gint _tmp287_;
				gint _tmp288_;
				ValaExpression* arg = NULL;
				ValaList* _tmp289_;
				gint _tmp290_;
				gpointer _tmp291_;
				ValaObjectCreationExpression* _tmp292_;
				ValaExpression* _tmp293_;
				_tmp286_ = _arg_index;
				_arg_index = _tmp286_ + 1;
				_tmp287_ = _arg_index;
				_tmp288_ = _arg_size;
				if (!(_tmp287_ < _tmp288_)) {
					break;
				}
				_tmp289_ = _arg_list;
				_tmp290_ = _arg_index;
				_tmp291_ = vala_list_get (_tmp289_, _tmp290_);
				arg = (ValaExpression*) _tmp291_;
				_tmp292_ = struct_creation_expression;
				_tmp293_ = arg;
				vala_object_creation_expression_add_argument (_tmp292_, _tmp293_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp294_ = struct_creation_expression;
		_tmp295_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp296_ = _tmp295_;
		vala_expression_set_target_type ((ValaExpression*) _tmp294_, _tmp296_);
		_tmp297_ = vala_code_context_get_analyzer (context);
		_tmp298_ = _tmp297_;
		_tmp299_ = _tmp298_->replaced_nodes;
		vala_collection_add ((ValaCollection*) _tmp299_, (ValaCodeNode*) self);
		_tmp300_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp301_ = _tmp300_;
		_tmp302_ = struct_creation_expression;
		vala_code_node_replace_expression (_tmp301_, (ValaExpression*) self, (ValaExpression*) _tmp302_);
		_tmp303_ = struct_creation_expression;
		vala_code_node_check ((ValaCodeNode*) _tmp303_, context);
		result = TRUE;
		_vala_code_node_unref0 (struct_creation_expression);
		_vala_code_node_unref0 (st);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp304_ = FALSE;
		gboolean _tmp305_ = FALSE;
		gboolean _tmp306_;
		_tmp306_ = self->priv->_is_chainup;
		if (!_tmp306_) {
			ValaExpression* _tmp307_;
			ValaExpression* _tmp308_;
			_tmp307_ = vala_method_call_get_call (self);
			_tmp308_ = _tmp307_;
			_tmp305_ = VALA_IS_MEMBER_ACCESS (_tmp308_);
		} else {
			_tmp305_ = FALSE;
		}
		if (_tmp305_) {
			ValaExpression* _tmp309_;
			ValaExpression* _tmp310_;
			ValaSymbol* _tmp311_;
			ValaSymbol* _tmp312_;
			_tmp309_ = vala_method_call_get_call (self);
			_tmp310_ = _tmp309_;
			_tmp311_ = vala_expression_get_symbol_reference (_tmp310_);
			_tmp312_ = _tmp311_;
			_tmp304_ = VALA_IS_CREATION_METHOD (_tmp312_);
		} else {
			_tmp304_ = FALSE;
		}
		if (_tmp304_) {
			ValaSourceReference* _tmp313_;
			ValaSourceReference* _tmp314_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp313_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp314_ = _tmp313_;
			vala_report_error (_tmp314_, "use `new' operator to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp316_ = self->priv->_is_chainup;
	if (!_tmp316_) {
		ValaDataType* _tmp317_;
		_tmp317_ = mtype;
		_tmp315_ = VALA_IS_OBJECT_TYPE (_tmp317_);
	} else {
		_tmp315_ = FALSE;
	}
	if (_tmp315_) {
		ValaSourceReference* _tmp318_;
		ValaSourceReference* _tmp319_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp318_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp319_ = _tmp318_;
		vala_report_error (_tmp319_, "invocation not supported in this context");
		result = FALSE;
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	} else {
		gboolean _tmp320_ = FALSE;
		ValaDataType* _tmp321_;
		_tmp321_ = mtype;
		if (_tmp321_ != NULL) {
			ValaDataType* _tmp322_;
			_tmp322_ = mtype;
			_tmp320_ = vala_data_type_is_invokable (_tmp322_);
		} else {
			_tmp320_ = FALSE;
		}
		if (_tmp320_) {
		} else {
			ValaExpression* _tmp323_;
			ValaExpression* _tmp324_;
			ValaSymbol* _tmp325_;
			ValaSymbol* _tmp326_;
			_tmp323_ = vala_method_call_get_call (self);
			_tmp324_ = _tmp323_;
			_tmp325_ = vala_expression_get_symbol_reference (_tmp324_);
			_tmp326_ = _tmp325_;
			if (VALA_IS_CLASS (_tmp326_)) {
				ValaSourceReference* _tmp327_;
				ValaSourceReference* _tmp328_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp327_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp328_ = _tmp327_;
				vala_report_error (_tmp328_, "use `new' operator to create new objects");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				ValaSourceReference* _tmp329_;
				ValaSourceReference* _tmp330_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp329_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp330_ = _tmp329_;
				vala_report_error (_tmp330_, "invocation not supported in this context");
				result = FALSE;
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
		}
	}
	_tmp331_ = mtype;
	_tmp332_ = vala_data_type_get_return_type (_tmp331_);
	ret_type = _tmp332_;
	_tmp333_ = mtype;
	_tmp334_ = vala_data_type_get_parameters (_tmp333_);
	params = _tmp334_;
	_tmp335_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp335_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp336_;
		ValaMethod* _tmp337_;
		ValaMethod* _tmp338_;
		ValaMethod* _tmp339_;
		gboolean _tmp340_ = FALSE;
		ValaMethod* _tmp341_;
		ValaMethod* _tmp378_;
		_tmp336_ = mtype;
		_tmp337_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp336_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp338_ = _tmp337_;
		_tmp339_ = _vala_code_node_ref0 (_tmp338_);
		m = _tmp339_;
		_tmp341_ = m;
		if (_tmp341_ != NULL) {
			ValaMethod* _tmp342_;
			gboolean _tmp343_;
			gboolean _tmp344_;
			_tmp342_ = m;
			_tmp343_ = vala_method_get_coroutine (_tmp342_);
			_tmp344_ = _tmp343_;
			_tmp340_ = _tmp344_;
		} else {
			_tmp340_ = FALSE;
		}
		if (_tmp340_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp345_;
			ValaExpression* _tmp346_;
			ValaMemberAccess* _tmp347_;
			gboolean _tmp348_;
			_tmp345_ = vala_method_call_get_call (self);
			_tmp346_ = _tmp345_;
			_tmp347_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp346_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp347_;
			_tmp348_ = self->priv->_is_yield_expression;
			if (!_tmp348_) {
				ValaMemberAccess* _tmp349_;
				const gchar* _tmp350_;
				const gchar* _tmp351_;
				_tmp349_ = ma;
				_tmp350_ = vala_member_access_get_member_name (_tmp349_);
				_tmp351_ = _tmp350_;
				if (g_strcmp0 (_tmp351_, "end") != 0) {
					ValaMemberAccess* _tmp352_;
					const gchar* _tmp353_;
					const gchar* _tmp354_;
					ValaMethod* _tmp358_;
					ValaList* _tmp359_;
					ValaVoidType* _tmp360_;
					_tmp352_ = ma;
					_tmp353_ = vala_member_access_get_member_name (_tmp352_);
					_tmp354_ = _tmp353_;
					if (g_strcmp0 (_tmp354_, "begin") != 0) {
						ValaMemberAccess* _tmp355_;
						ValaSourceReference* _tmp356_;
						ValaSourceReference* _tmp357_;
						_tmp355_ = ma;
						_tmp356_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp355_);
						_tmp357_ = _tmp356_;
						vala_report_deprecated (_tmp357_, "implicit .begin is deprecated");
					}
					_tmp358_ = m;
					_tmp359_ = vala_method_get_async_begin_parameters (_tmp358_);
					_vala_iterable_unref0 (params);
					params = _tmp359_;
					_tmp360_ = vala_void_type_new (NULL);
					_vala_code_node_unref0 (ret_type);
					ret_type = (ValaDataType*) _tmp360_;
				} else {
					ValaMethod* _tmp361_;
					ValaList* _tmp362_;
					_tmp361_ = m;
					_tmp362_ = vala_method_get_async_end_parameters (_tmp361_);
					_vala_iterable_unref0 (params);
					params = _tmp362_;
				}
			} else {
				gboolean _tmp363_ = FALSE;
				ValaMemberAccess* _tmp364_;
				const gchar* _tmp365_;
				const gchar* _tmp366_;
				_tmp364_ = ma;
				_tmp365_ = vala_member_access_get_member_name (_tmp364_);
				_tmp366_ = _tmp365_;
				if (g_strcmp0 (_tmp366_, "begin") == 0) {
					_tmp363_ = TRUE;
				} else {
					ValaMemberAccess* _tmp367_;
					const gchar* _tmp368_;
					const gchar* _tmp369_;
					_tmp367_ = ma;
					_tmp368_ = vala_member_access_get_member_name (_tmp367_);
					_tmp369_ = _tmp368_;
					_tmp363_ = g_strcmp0 (_tmp369_, "end") == 0;
				}
				if (_tmp363_) {
					ValaMemberAccess* _tmp370_;
					ValaSourceReference* _tmp371_;
					ValaSourceReference* _tmp372_;
					ValaMemberAccess* _tmp373_;
					const gchar* _tmp374_;
					const gchar* _tmp375_;
					gchar* _tmp376_;
					gchar* _tmp377_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp370_ = ma;
					_tmp371_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp370_);
					_tmp372_ = _tmp371_;
					_tmp373_ = ma;
					_tmp374_ = vala_member_access_get_member_name (_tmp373_);
					_tmp375_ = _tmp374_;
					_tmp376_ = g_strdup_printf ("use of `%s' not allowed in yield statement", _tmp375_);
					_tmp377_ = _tmp376_;
					vala_report_error (_tmp372_, _tmp377_);
					_g_free0 (_tmp377_);
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp378_ = m;
		if (_tmp378_ != NULL) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp379_;
			ValaExpression* _tmp380_;
			ValaMemberAccess* _tmp381_;
			gint n_type_params = 0;
			ValaMethod* _tmp382_;
			ValaList* _tmp383_;
			ValaList* _tmp384_;
			gint _tmp385_;
			gint _tmp386_;
			gint _tmp387_;
			gint n_type_args = 0;
			ValaMemberAccess* _tmp388_;
			ValaList* _tmp389_;
			ValaList* _tmp390_;
			gint _tmp391_;
			gint _tmp392_;
			gint _tmp393_;
			gboolean _tmp394_ = FALSE;
			gint _tmp395_;
			_tmp379_ = vala_method_call_get_call (self);
			_tmp380_ = _tmp379_;
			_tmp381_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp380_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp381_;
			_tmp382_ = m;
			_tmp383_ = vala_method_get_type_parameters (_tmp382_);
			_tmp384_ = _tmp383_;
			_tmp385_ = vala_collection_get_size ((ValaCollection*) _tmp384_);
			_tmp386_ = _tmp385_;
			_tmp387_ = _tmp386_;
			_vala_iterable_unref0 (_tmp384_);
			n_type_params = _tmp387_;
			_tmp388_ = ma;
			_tmp389_ = vala_member_access_get_type_arguments (_tmp388_);
			_tmp390_ = _tmp389_;
			_tmp391_ = vala_collection_get_size ((ValaCollection*) _tmp390_);
			_tmp392_ = _tmp391_;
			_tmp393_ = _tmp392_;
			_vala_iterable_unref0 (_tmp390_);
			n_type_args = _tmp393_;
			_tmp395_ = n_type_args;
			if (_tmp395_ > 0) {
				gint _tmp396_;
				gint _tmp397_;
				_tmp396_ = n_type_args;
				_tmp397_ = n_type_params;
				_tmp394_ = _tmp396_ < _tmp397_;
			} else {
				_tmp394_ = FALSE;
			}
			if (_tmp394_) {
				ValaMemberAccess* _tmp398_;
				ValaSourceReference* _tmp399_;
				ValaSourceReference* _tmp400_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp398_ = ma;
				_tmp399_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp398_);
				_tmp400_ = _tmp399_;
				vala_report_error (_tmp400_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (ma);
				_vala_code_node_unref0 (m);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			} else {
				gboolean _tmp401_ = FALSE;
				gint _tmp402_;
				_tmp402_ = n_type_args;
				if (_tmp402_ > 0) {
					gint _tmp403_;
					gint _tmp404_;
					_tmp403_ = n_type_args;
					_tmp404_ = n_type_params;
					_tmp401_ = _tmp403_ > _tmp404_;
				} else {
					_tmp401_ = FALSE;
				}
				if (_tmp401_) {
					ValaMemberAccess* _tmp405_;
					ValaSourceReference* _tmp406_;
					ValaSourceReference* _tmp407_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp405_ = ma;
					_tmp406_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp405_);
					_tmp407_ = _tmp406_;
					vala_report_error (_tmp407_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (m);
					_vala_iterable_unref0 (params);
					_vala_code_node_unref0 (ret_type);
					_vala_code_node_unref0 (base_cm);
					_vala_code_node_unref0 (mtype);
					_vala_iterable_unref0 (method_type_args);
					_vala_code_node_unref0 (target_object_type);
					return result;
				}
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (m);
	}
	last_arg = NULL;
	_tmp408_ = vala_method_call_get_argument_list (self);
	args = _tmp408_;
	_tmp409_ = args;
	_tmp410_ = vala_iterable_iterator ((ValaIterable*) _tmp409_);
	arg_it = _tmp410_;
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp411_;
		ValaList* _tmp412_;
		gint _param_size = 0;
		ValaList* _tmp413_;
		gint _tmp414_;
		gint _tmp415_;
		gint _param_index = 0;
		_tmp411_ = params;
		_tmp412_ = _vala_iterable_ref0 (_tmp411_);
		_param_list = _tmp412_;
		_tmp413_ = _param_list;
		_tmp414_ = vala_collection_get_size ((ValaCollection*) _tmp413_);
		_tmp415_ = _tmp414_;
		_param_size = _tmp415_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp416_;
			gint _tmp417_;
			gint _tmp418_;
			ValaParameter* param = NULL;
			ValaList* _tmp419_;
			gint _tmp420_;
			gpointer _tmp421_;
			ValaParameter* _tmp422_;
			ValaParameter* _tmp423_;
			gboolean _tmp424_;
			gboolean _tmp425_;
			ValaParameter* _tmp426_;
			gboolean _tmp427_;
			gboolean _tmp428_;
			ValaIterator* _tmp446_;
			_tmp416_ = _param_index;
			_param_index = _tmp416_ + 1;
			_tmp417_ = _param_index;
			_tmp418_ = _param_size;
			if (!(_tmp417_ < _tmp418_)) {
				break;
			}
			_tmp419_ = _param_list;
			_tmp420_ = _param_index;
			_tmp421_ = vala_list_get (_tmp419_, _tmp420_);
			param = (ValaParameter*) _tmp421_;
			_tmp422_ = param;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp422_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			}
			_tmp423_ = param;
			_tmp424_ = vala_parameter_get_ellipsis (_tmp423_);
			_tmp425_ = _tmp424_;
			if (_tmp425_) {
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp426_ = param;
			_tmp427_ = vala_parameter_get_params_array (_tmp426_);
			_tmp428_ = _tmp427_;
			if (_tmp428_) {
				ValaArrayType* array_type = NULL;
				ValaParameter* _tmp429_;
				ValaDataType* _tmp430_;
				ValaDataType* _tmp431_;
				ValaArrayType* _tmp432_;
				_tmp429_ = param;
				_tmp430_ = vala_variable_get_variable_type ((ValaVariable*) _tmp429_);
				_tmp431_ = _tmp430_;
				_tmp432_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp431_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
				array_type = _tmp432_;
				while (TRUE) {
					ValaIterator* _tmp433_;
					ValaExpression* arg = NULL;
					ValaIterator* _tmp434_;
					gpointer _tmp435_;
					ValaExpression* _tmp436_;
					ValaArrayType* _tmp437_;
					ValaDataType* _tmp438_;
					ValaDataType* _tmp439_;
					ValaExpression* _tmp440_;
					ValaDataType* _tmp441_;
					ValaDataType* _tmp442_;
					ValaArrayType* _tmp443_;
					gboolean _tmp444_;
					gboolean _tmp445_;
					_tmp433_ = arg_it;
					if (!vala_iterator_next (_tmp433_)) {
						break;
					}
					_tmp434_ = arg_it;
					_tmp435_ = vala_iterator_get (_tmp434_);
					arg = (ValaExpression*) _tmp435_;
					_tmp436_ = arg;
					_tmp437_ = array_type;
					_tmp438_ = vala_array_type_get_element_type (_tmp437_);
					_tmp439_ = _tmp438_;
					vala_expression_set_target_type (_tmp436_, _tmp439_);
					_tmp440_ = arg;
					_tmp441_ = vala_expression_get_target_type (_tmp440_);
					_tmp442_ = _tmp441_;
					_tmp443_ = array_type;
					_tmp444_ = vala_data_type_get_value_owned ((ValaDataType*) _tmp443_);
					_tmp445_ = _tmp444_;
					vala_data_type_set_value_owned (_tmp442_, _tmp445_);
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (array_type);
				_vala_code_node_unref0 (param);
				break;
			}
			_tmp446_ = arg_it;
			if (vala_iterator_next (_tmp446_)) {
				ValaExpression* arg = NULL;
				ValaIterator* _tmp447_;
				gpointer _tmp448_;
				ValaExpression* _tmp449_;
				ValaParameter* _tmp450_;
				ValaDataType* _tmp451_;
				ValaDataType* _tmp452_;
				ValaExpression* _tmp453_;
				ValaExpression* _tmp454_;
				ValaDataType* _tmp455_;
				ValaDataType* _tmp456_;
				ValaDataType* _tmp457_;
				ValaList* _tmp458_;
				ValaDataType* _tmp459_;
				ValaDataType* _tmp460_;
				ValaExpression* _tmp461_;
				ValaExpression* _tmp462_;
				_tmp447_ = arg_it;
				_tmp448_ = vala_iterator_get (_tmp447_);
				arg = (ValaExpression*) _tmp448_;
				_tmp449_ = arg;
				_tmp450_ = param;
				_tmp451_ = vala_variable_get_variable_type ((ValaVariable*) _tmp450_);
				_tmp452_ = _tmp451_;
				vala_expression_set_formal_target_type (_tmp449_, _tmp452_);
				_tmp453_ = arg;
				_tmp454_ = arg;
				_tmp455_ = vala_expression_get_formal_target_type (_tmp454_);
				_tmp456_ = _tmp455_;
				_tmp457_ = target_object_type;
				_tmp458_ = method_type_args;
				_tmp459_ = vala_data_type_get_actual_type (_tmp456_, _tmp457_, _tmp458_, (ValaCodeNode*) self);
				_tmp460_ = _tmp459_;
				vala_expression_set_target_type (_tmp453_, _tmp460_);
				_vala_code_node_unref0 (_tmp460_);
				_tmp461_ = arg;
				_tmp462_ = _vala_code_node_ref0 (_tmp461_);
				_vala_code_node_unref0 (last_arg);
				last_arg = _tmp462_;
				_vala_code_node_unref0 (arg);
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	_tmp464_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp464_)) {
		ValaDataType* _tmp465_;
		ValaMethod* _tmp466_;
		ValaMethod* _tmp467_;
		ValaAttribute* _tmp468_;
		ValaAttribute* _tmp469_;
		_tmp465_ = mtype;
		_tmp466_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp465_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp467_, "Print");
		_tmp469_ = _tmp468_;
		_tmp463_ = _tmp469_ != NULL;
		_vala_code_node_unref0 (_tmp469_);
	} else {
		_tmp463_ = FALSE;
	}
	if (_tmp463_) {
		ValaTemplate* template = NULL;
		ValaSourceReference* _tmp470_;
		ValaSourceReference* _tmp471_;
		ValaTemplate* _tmp472_;
		ValaList* _tmp487_;
		ValaTemplate* _tmp488_;
		_tmp470_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp471_ = _tmp470_;
		_tmp472_ = vala_template_new (_tmp471_);
		template = _tmp472_;
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp473_;
			ValaList* _tmp474_;
			gint _arg_size = 0;
			ValaList* _tmp475_;
			gint _tmp476_;
			gint _tmp477_;
			gint _arg_index = 0;
			_tmp473_ = self->priv->argument_list;
			_tmp474_ = _vala_iterable_ref0 (_tmp473_);
			_arg_list = _tmp474_;
			_tmp475_ = _arg_list;
			_tmp476_ = vala_collection_get_size ((ValaCollection*) _tmp475_);
			_tmp477_ = _tmp476_;
			_arg_size = _tmp477_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp478_;
				gint _tmp479_;
				gint _tmp480_;
				ValaExpression* arg = NULL;
				ValaList* _tmp481_;
				gint _tmp482_;
				gpointer _tmp483_;
				ValaExpression* _tmp484_;
				ValaTemplate* _tmp485_;
				ValaExpression* _tmp486_;
				_tmp478_ = _arg_index;
				_arg_index = _tmp478_ + 1;
				_tmp479_ = _arg_index;
				_tmp480_ = _arg_size;
				if (!(_tmp479_ < _tmp480_)) {
					break;
				}
				_tmp481_ = _arg_list;
				_tmp482_ = _arg_index;
				_tmp483_ = vala_list_get (_tmp481_, _tmp482_);
				arg = (ValaExpression*) _tmp483_;
				_tmp484_ = arg;
				vala_code_node_set_parent_node ((ValaCodeNode*) _tmp484_, NULL);
				_tmp485_ = template;
				_tmp486_ = arg;
				vala_template_add_expression (_tmp485_, _tmp486_);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp487_ = self->priv->argument_list;
		vala_collection_clear ((ValaCollection*) _tmp487_);
		_tmp488_ = template;
		vala_method_call_add_argument (self, (ValaExpression*) _tmp488_);
		_vala_code_node_unref0 (template);
	}
	_tmp490_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp490_)) {
		ValaDataType* _tmp491_;
		ValaMethod* _tmp492_;
		ValaMethod* _tmp493_;
		gboolean _tmp494_;
		gboolean _tmp495_;
		_tmp491_ = mtype;
		_tmp492_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp491_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp493_ = _tmp492_;
		_tmp494_ = vala_method_get_printf_format (_tmp493_);
		_tmp495_ = _tmp494_;
		_tmp489_ = _tmp495_;
	} else {
		_tmp489_ = FALSE;
	}
	if (_tmp489_) {
		ValaStringLiteral* format_literal = NULL;
		ValaExpression* _tmp496_;
		ValaStringLiteral* _tmp545_;
		format_literal = NULL;
		_tmp496_ = last_arg;
		if (VALA_IS_NULL_LITERAL (_tmp496_)) {
		} else {
			ValaExpression* _tmp497_;
			_tmp497_ = last_arg;
			if (_tmp497_ != NULL) {
				ValaExpression* _tmp498_;
				ValaStringLiteral* _tmp499_;
				gboolean _tmp500_ = FALSE;
				ValaStringLiteral* _tmp501_;
				_tmp498_ = last_arg;
				_tmp499_ = vala_string_literal_get_format_literal (_tmp498_);
				_vala_code_node_unref0 (format_literal);
				format_literal = _tmp499_;
				_tmp501_ = format_literal;
				if (_tmp501_ == NULL) {
					ValaList* _tmp502_;
					gint _tmp503_;
					gint _tmp504_;
					ValaList* _tmp505_;
					gint _tmp506_;
					gint _tmp507_;
					_tmp502_ = args;
					_tmp503_ = vala_collection_get_size ((ValaCollection*) _tmp502_);
					_tmp504_ = _tmp503_;
					_tmp505_ = params;
					_tmp506_ = vala_collection_get_size ((ValaCollection*) _tmp505_);
					_tmp507_ = _tmp506_;
					_tmp500_ = _tmp504_ == (_tmp507_ - 1);
				} else {
					_tmp500_ = FALSE;
				}
				if (_tmp500_) {
					ValaStringLiteral* _tmp508_;
					ValaStringLiteral* _tmp509_;
					ValaSemanticAnalyzer* _tmp510_;
					ValaSemanticAnalyzer* _tmp511_;
					ValaDataType* _tmp512_;
					ValaDataType* _tmp513_;
					ValaDataType* _tmp514_;
					ValaList* _tmp515_;
					ValaList* _tmp516_;
					gint _tmp517_;
					gint _tmp518_;
					ValaStringLiteral* _tmp519_;
					ValaList* _tmp520_;
					ValaIterator* _tmp521_;
					_tmp508_ = vala_string_literal_new ("\"%s\"", NULL);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp508_;
					_tmp509_ = format_literal;
					_tmp510_ = vala_code_context_get_analyzer (context);
					_tmp511_ = _tmp510_;
					_tmp512_ = _tmp511_->string_type;
					_tmp513_ = vala_data_type_copy (_tmp512_);
					_tmp514_ = _tmp513_;
					vala_expression_set_target_type ((ValaExpression*) _tmp509_, _tmp514_);
					_vala_code_node_unref0 (_tmp514_);
					_tmp515_ = self->priv->argument_list;
					_tmp516_ = args;
					_tmp517_ = vala_collection_get_size ((ValaCollection*) _tmp516_);
					_tmp518_ = _tmp517_;
					_tmp519_ = format_literal;
					vala_list_insert (_tmp515_, _tmp518_ - 1, (ValaExpression*) _tmp519_);
					_tmp520_ = self->priv->argument_list;
					_tmp521_ = vala_iterable_iterator ((ValaIterable*) _tmp520_);
					_vala_iterator_unref0 (arg_it);
					arg_it = _tmp521_;
					{
						ValaList* _param_list = NULL;
						ValaList* _tmp522_;
						ValaList* _tmp523_;
						gint _param_size = 0;
						ValaList* _tmp524_;
						gint _tmp525_;
						gint _tmp526_;
						gint _param_index = 0;
						_tmp522_ = params;
						_tmp523_ = _vala_iterable_ref0 (_tmp522_);
						_param_list = _tmp523_;
						_tmp524_ = _param_list;
						_tmp525_ = vala_collection_get_size ((ValaCollection*) _tmp524_);
						_tmp526_ = _tmp525_;
						_param_size = _tmp526_;
						_param_index = -1;
						while (TRUE) {
							gint _tmp527_;
							gint _tmp528_;
							gint _tmp529_;
							ValaParameter* param = NULL;
							ValaList* _tmp530_;
							gint _tmp531_;
							gpointer _tmp532_;
							ValaParameter* _tmp533_;
							gboolean _tmp534_;
							gboolean _tmp535_;
							ValaIterator* _tmp536_;
							_tmp527_ = _param_index;
							_param_index = _tmp527_ + 1;
							_tmp528_ = _param_index;
							_tmp529_ = _param_size;
							if (!(_tmp528_ < _tmp529_)) {
								break;
							}
							_tmp530_ = _param_list;
							_tmp531_ = _param_index;
							_tmp532_ = vala_list_get (_tmp530_, _tmp531_);
							param = (ValaParameter*) _tmp532_;
							_tmp533_ = param;
							_tmp534_ = vala_parameter_get_ellipsis (_tmp533_);
							_tmp535_ = _tmp534_;
							if (_tmp535_) {
								_vala_code_node_unref0 (param);
								break;
							}
							_tmp536_ = arg_it;
							vala_iterator_next (_tmp536_);
							_vala_code_node_unref0 (param);
						}
						_vala_iterable_unref0 (_param_list);
					}
				}
			} else {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp537_;
				ValaExpression* _tmp538_;
				ValaMemberAccess* _tmp539_;
				ValaMemberAccess* _tmp540_;
				_tmp537_ = vala_method_call_get_call (self);
				_tmp538_ = _tmp537_;
				_tmp539_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp538_) ? ((ValaMemberAccess*) _tmp538_) : NULL);
				ma = _tmp539_;
				_tmp540_ = ma;
				if (_tmp540_ != NULL) {
					ValaMemberAccess* _tmp541_;
					ValaExpression* _tmp542_;
					ValaExpression* _tmp543_;
					ValaStringLiteral* _tmp544_;
					_tmp541_ = ma;
					_tmp542_ = vala_member_access_get_inner (_tmp541_);
					_tmp543_ = _tmp542_;
					_tmp544_ = vala_string_literal_get_format_literal (_tmp543_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp544_;
				}
				_vala_code_node_unref0 (ma);
			}
		}
		_tmp545_ = format_literal;
		if (_tmp545_ != NULL) {
			gchar* format = NULL;
			ValaStringLiteral* _tmp546_;
			gchar* _tmp547_;
			ValaSemanticAnalyzer* _tmp548_;
			ValaSemanticAnalyzer* _tmp549_;
			const gchar* _tmp550_;
			ValaIterator* _tmp551_;
			ValaSourceReference* _tmp552_;
			ValaSourceReference* _tmp553_;
			_tmp546_ = format_literal;
			_tmp547_ = vala_string_literal_eval (_tmp546_);
			format = _tmp547_;
			_tmp548_ = vala_code_context_get_analyzer (context);
			_tmp549_ = _tmp548_;
			_tmp550_ = format;
			_tmp551_ = arg_it;
			_tmp552_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp553_ = _tmp552_;
			if (!vala_semantic_analyzer_check_print_format (_tmp549_, _tmp550_, _tmp551_, _tmp553_)) {
				result = FALSE;
				_g_free0 (format);
				_vala_code_node_unref0 (format_literal);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_g_free0 (format);
		}
		_vala_code_node_unref0 (format_literal);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp554_;
		gint _arg_size = 0;
		ValaList* _tmp555_;
		gint _tmp556_;
		gint _tmp557_;
		gint _arg_index = 0;
		_tmp554_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp554_;
		_tmp555_ = _arg_list;
		_tmp556_ = vala_collection_get_size ((ValaCollection*) _tmp555_);
		_tmp557_ = _tmp556_;
		_arg_size = _tmp557_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp558_;
			gint _tmp559_;
			gint _tmp560_;
			ValaExpression* arg = NULL;
			ValaList* _tmp561_;
			gint _tmp562_;
			gpointer _tmp563_;
			ValaExpression* _tmp564_;
			_tmp558_ = _arg_index;
			_arg_index = _tmp558_ + 1;
			_tmp559_ = _arg_index;
			_tmp560_ = _arg_size;
			if (!(_tmp559_ < _tmp560_)) {
				break;
			}
			_tmp561_ = _arg_list;
			_tmp562_ = _arg_index;
			_tmp563_ = vala_list_get (_tmp561_, _tmp562_);
			arg = (ValaExpression*) _tmp563_;
			_tmp564_ = arg;
			vala_code_node_check ((ValaCodeNode*) _tmp564_, context);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp565_ = ret_type;
	if (VALA_IS_VOID_TYPE (_tmp565_)) {
		gboolean _tmp566_ = FALSE;
		gboolean _tmp567_ = FALSE;
		ValaCodeNode* _tmp568_;
		ValaCodeNode* _tmp569_;
		_tmp568_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp569_ = _tmp568_;
		if (!VALA_IS_EXPRESSION_STATEMENT (_tmp569_)) {
			ValaCodeNode* _tmp570_;
			ValaCodeNode* _tmp571_;
			_tmp570_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp571_ = _tmp570_;
			_tmp567_ = !VALA_IS_FOR_STATEMENT (_tmp571_);
		} else {
			_tmp567_ = FALSE;
		}
		if (_tmp567_) {
			ValaCodeNode* _tmp572_;
			ValaCodeNode* _tmp573_;
			_tmp572_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp573_ = _tmp572_;
			_tmp566_ = !VALA_IS_YIELD_STATEMENT (_tmp573_);
		} else {
			_tmp566_ = FALSE;
		}
		if (_tmp566_) {
			ValaSourceReference* _tmp574_;
			ValaSourceReference* _tmp575_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp574_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp575_ = _tmp574_;
			vala_report_error (_tmp575_, "invocation of void method not allowed as expression");
			result = FALSE;
			_vala_iterator_unref0 (arg_it);
			_vala_iterable_unref0 (args);
			_vala_code_node_unref0 (last_arg);
			_vala_iterable_unref0 (params);
			_vala_code_node_unref0 (ret_type);
			_vala_code_node_unref0 (base_cm);
			_vala_code_node_unref0 (mtype);
			_vala_iterable_unref0 (method_type_args);
			_vala_code_node_unref0 (target_object_type);
			return result;
		}
	}
	_tmp576_ = ret_type;
	_tmp577_ = vala_data_type_copy (_tmp576_);
	_tmp578_ = _tmp577_;
	vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp578_);
	_vala_code_node_unref0 (_tmp578_);
	_tmp579_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
	_tmp580_ = _tmp579_;
	_tmp581_ = target_object_type;
	_tmp582_ = method_type_args;
	_tmp583_ = vala_data_type_get_actual_type (_tmp580_, _tmp581_, _tmp582_, (ValaCodeNode*) self);
	_tmp584_ = _tmp583_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp584_);
	_vala_code_node_unref0 (_tmp584_);
	may_throw = FALSE;
	_tmp585_ = mtype;
	if (VALA_IS_METHOD_TYPE (_tmp585_)) {
		ValaMethod* m = NULL;
		ValaDataType* _tmp586_;
		ValaMethod* _tmp587_;
		ValaMethod* _tmp588_;
		ValaMethod* _tmp589_;
		gboolean _tmp590_;
		gboolean _tmp609_ = FALSE;
		gboolean _tmp610_ = FALSE;
		gboolean _tmp611_ = FALSE;
		ValaMethod* _tmp612_;
		ValaMethod* _tmp638_;
		gboolean _tmp639_;
		gboolean _tmp640_;
		ValaMethod* _tmp643_;
		gboolean _tmp644_;
		gboolean _tmp645_;
		ValaSignal* sig = NULL;
		ValaMethod* _tmp650_;
		ValaSymbol* _tmp651_;
		ValaSymbol* _tmp652_;
		gboolean _tmp653_ = FALSE;
		ValaSignal* _tmp654_;
		ValaDynamicSignal* dynamic_sig = NULL;
		ValaMethod* _tmp665_;
		ValaSymbol* _tmp666_;
		ValaSymbol* _tmp667_;
		ValaDynamicSignal* _tmp668_;
		gboolean _tmp669_ = FALSE;
		ValaDynamicSignal* _tmp670_;
		gboolean _tmp717_ = FALSE;
		ValaMethod* _tmp718_;
		gboolean _tmp843_ = FALSE;
		ValaMethod* _tmp844_;
		_tmp586_ = mtype;
		_tmp587_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp586_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp588_ = _tmp587_;
		_tmp589_ = _vala_code_node_ref0 (_tmp588_);
		m = _tmp589_;
		_tmp590_ = self->priv->_is_yield_expression;
		if (_tmp590_) {
			ValaMethod* _tmp591_;
			gboolean _tmp592_;
			gboolean _tmp593_;
			gboolean _tmp596_ = FALSE;
			ValaSemanticAnalyzer* _tmp597_;
			ValaSemanticAnalyzer* _tmp598_;
			ValaMethod* _tmp599_;
			ValaMethod* _tmp600_;
			_tmp591_ = m;
			_tmp592_ = vala_method_get_coroutine (_tmp591_);
			_tmp593_ = _tmp592_;
			if (!_tmp593_) {
				ValaSourceReference* _tmp594_;
				ValaSourceReference* _tmp595_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp594_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp595_ = _tmp594_;
				vala_report_error (_tmp595_, "yield expression requires async method");
			}
			_tmp597_ = vala_code_context_get_analyzer (context);
			_tmp598_ = _tmp597_;
			_tmp599_ = vala_semantic_analyzer_get_current_method (_tmp598_);
			_tmp600_ = _tmp599_;
			if (_tmp600_ == NULL) {
				_tmp596_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp601_;
				ValaSemanticAnalyzer* _tmp602_;
				ValaMethod* _tmp603_;
				ValaMethod* _tmp604_;
				gboolean _tmp605_;
				gboolean _tmp606_;
				_tmp601_ = vala_code_context_get_analyzer (context);
				_tmp602_ = _tmp601_;
				_tmp603_ = vala_semantic_analyzer_get_current_method (_tmp602_);
				_tmp604_ = _tmp603_;
				_tmp605_ = vala_method_get_coroutine (_tmp604_);
				_tmp606_ = _tmp605_;
				_tmp596_ = !_tmp606_;
			}
			if (_tmp596_) {
				ValaSourceReference* _tmp607_;
				ValaSourceReference* _tmp608_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp607_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp608_ = _tmp607_;
				vala_report_error (_tmp608_, "yield expression not available outside async method");
			}
		}
		_tmp612_ = m;
		if (_tmp612_ != NULL) {
			ValaMethod* _tmp613_;
			gboolean _tmp614_;
			gboolean _tmp615_;
			_tmp613_ = m;
			_tmp614_ = vala_method_get_coroutine (_tmp613_);
			_tmp615_ = _tmp614_;
			_tmp611_ = _tmp615_;
		} else {
			_tmp611_ = FALSE;
		}
		if (_tmp611_) {
			gboolean _tmp616_;
			_tmp616_ = self->priv->_is_yield_expression;
			_tmp610_ = !_tmp616_;
		} else {
			_tmp610_ = FALSE;
		}
		if (_tmp610_) {
			ValaExpression* _tmp617_;
			ValaExpression* _tmp618_;
			const gchar* _tmp619_;
			const gchar* _tmp620_;
			_tmp617_ = vala_method_call_get_call (self);
			_tmp618_ = _tmp617_;
			_tmp619_ = vala_member_access_get_member_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp618_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp620_ = _tmp619_;
			_tmp609_ = g_strcmp0 (_tmp620_, "end") != 0;
		} else {
			_tmp609_ = FALSE;
		}
		if (_tmp609_) {
		} else {
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp621_;
				ValaList* _tmp622_;
				gint _error_type_size = 0;
				ValaList* _tmp623_;
				gint _tmp624_;
				gint _tmp625_;
				gint _error_type_index = 0;
				_tmp621_ = m;
				_tmp622_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp621_);
				_error_type_list = _tmp622_;
				_tmp623_ = _error_type_list;
				_tmp624_ = vala_collection_get_size ((ValaCollection*) _tmp623_);
				_tmp625_ = _tmp624_;
				_error_type_size = _tmp625_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp626_;
					gint _tmp627_;
					gint _tmp628_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp629_;
					gint _tmp630_;
					gpointer _tmp631_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp632_;
					ValaDataType* _tmp633_;
					ValaDataType* _tmp634_;
					ValaSourceReference* _tmp635_;
					ValaSourceReference* _tmp636_;
					ValaDataType* _tmp637_;
					_tmp626_ = _error_type_index;
					_error_type_index = _tmp626_ + 1;
					_tmp627_ = _error_type_index;
					_tmp628_ = _error_type_size;
					if (!(_tmp627_ < _tmp628_)) {
						break;
					}
					_tmp629_ = _error_type_list;
					_tmp630_ = _error_type_index;
					_tmp631_ = vala_list_get (_tmp629_, _tmp630_);
					error_type = (ValaDataType*) _tmp631_;
					may_throw = TRUE;
					_tmp632_ = error_type;
					_tmp633_ = vala_data_type_copy (_tmp632_);
					call_error_type = _tmp633_;
					_tmp634_ = call_error_type;
					_tmp635_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp636_ = _tmp635_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp634_, _tmp636_);
					_tmp637_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp637_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
		}
		_tmp638_ = m;
		_tmp639_ = vala_method_get_returns_floating_reference (_tmp638_);
		_tmp640_ = _tmp639_;
		if (_tmp640_) {
			ValaDataType* _tmp641_;
			ValaDataType* _tmp642_;
			_tmp641_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp642_ = _tmp641_;
			vala_data_type_set_floating_reference (_tmp642_, TRUE);
		}
		_tmp643_ = m;
		_tmp644_ = vala_method_get_returns_modified_pointer (_tmp643_);
		_tmp645_ = _tmp644_;
		if (_tmp645_) {
			ValaExpression* _tmp646_;
			ValaExpression* _tmp647_;
			ValaExpression* _tmp648_;
			ValaExpression* _tmp649_;
			_tmp646_ = vala_method_call_get_call (self);
			_tmp647_ = _tmp646_;
			_tmp648_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp647_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp649_ = _tmp648_;
			vala_expression_set_lvalue (_tmp649_, TRUE);
		}
		_tmp650_ = m;
		_tmp651_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp650_);
		_tmp652_ = _tmp651_;
		sig = VALA_IS_SIGNAL (_tmp652_) ? ((ValaSignal*) _tmp652_) : NULL;
		_tmp654_ = sig;
		if (_tmp654_ != NULL) {
			ValaMethod* _tmp655_;
			const gchar* _tmp656_;
			const gchar* _tmp657_;
			_tmp655_ = m;
			_tmp656_ = vala_symbol_get_name ((ValaSymbol*) _tmp655_);
			_tmp657_ = _tmp656_;
			_tmp653_ = g_strcmp0 (_tmp657_, "disconnect") == 0;
		} else {
			_tmp653_ = FALSE;
		}
		if (_tmp653_) {
			ValaExpression* param = NULL;
			ValaList* _tmp658_;
			ValaList* _tmp659_;
			gpointer _tmp660_;
			ValaExpression* _tmp661_;
			ValaExpression* _tmp662_;
			_tmp658_ = vala_method_call_get_argument_list (self);
			_tmp659_ = _tmp658_;
			_tmp660_ = vala_list_get (_tmp659_, 0);
			_tmp661_ = (ValaExpression*) _tmp660_;
			_vala_iterable_unref0 (_tmp659_);
			param = _tmp661_;
			_tmp662_ = param;
			if (VALA_IS_LAMBDA_EXPRESSION (_tmp662_)) {
				ValaSourceReference* _tmp663_;
				ValaSourceReference* _tmp664_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp663_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp664_ = _tmp663_;
				vala_report_error (_tmp664_, "Cannot disconnect lambda expression from signal");
				result = FALSE;
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (m);
				_vala_iterator_unref0 (arg_it);
				_vala_iterable_unref0 (args);
				_vala_code_node_unref0 (last_arg);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (ret_type);
				_vala_code_node_unref0 (base_cm);
				_vala_code_node_unref0 (mtype);
				_vala_iterable_unref0 (method_type_args);
				_vala_code_node_unref0 (target_object_type);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_tmp665_ = m;
		_tmp666_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp665_);
		_tmp667_ = _tmp666_;
		_tmp668_ = _vala_code_node_ref0 (VALA_IS_DYNAMIC_SIGNAL (_tmp667_) ? ((ValaDynamicSignal*) _tmp667_) : NULL);
		dynamic_sig = _tmp668_;
		_tmp670_ = dynamic_sig;
		if (_tmp670_ != NULL) {
			ValaDynamicSignal* _tmp671_;
			ValaExpression* _tmp672_;
			ValaExpression* _tmp673_;
			_tmp671_ = dynamic_sig;
			_tmp672_ = vala_dynamic_signal_get_handler (_tmp671_);
			_tmp673_ = _tmp672_;
			_tmp669_ = _tmp673_ != NULL;
		} else {
			_tmp669_ = FALSE;
		}
		if (_tmp669_) {
			ValaDynamicSignal* _tmp674_;
			ValaDynamicSignal* _tmp675_;
			ValaExpression* _tmp676_;
			ValaExpression* _tmp677_;
			ValaDataType* _tmp678_;
			ValaDataType* _tmp679_;
			ValaDataType* _tmp680_;
			ValaDataType* _tmp681_;
			ValaDataType* _tmp682_;
			ValaDataType* _tmp683_;
			gboolean first = FALSE;
			ValaDynamicSignal* _tmp704_;
			ValaExpression* _tmp705_;
			ValaExpression* _tmp706_;
			ValaDynamicSignal* _tmp707_;
			ValaDynamicSignal* _tmp708_;
			ValaSymbol* _tmp709_;
			ValaSymbol* _tmp710_;
			ValaObjectType* _tmp711_;
			ValaObjectType* _tmp712_;
			ValaDelegate* _tmp713_;
			ValaDelegate* _tmp714_;
			ValaDelegateType* _tmp715_;
			ValaDelegateType* _tmp716_;
			_tmp674_ = dynamic_sig;
			_tmp675_ = dynamic_sig;
			_tmp676_ = vala_dynamic_signal_get_handler (_tmp675_);
			_tmp677_ = _tmp676_;
			_tmp678_ = vala_expression_get_value_type (_tmp677_);
			_tmp679_ = _tmp678_;
			_tmp680_ = vala_data_type_get_return_type (_tmp679_);
			_tmp681_ = _tmp680_;
			_tmp682_ = vala_data_type_copy (_tmp681_);
			_tmp683_ = _tmp682_;
			vala_callable_set_return_type ((ValaCallable*) _tmp674_, _tmp683_);
			_vala_code_node_unref0 (_tmp683_);
			_vala_code_node_unref0 (_tmp681_);
			first = TRUE;
			{
				ValaList* _param_list = NULL;
				ValaDynamicSignal* _tmp684_;
				ValaExpression* _tmp685_;
				ValaExpression* _tmp686_;
				ValaDataType* _tmp687_;
				ValaDataType* _tmp688_;
				ValaList* _tmp689_;
				gint _param_size = 0;
				ValaList* _tmp690_;
				gint _tmp691_;
				gint _tmp692_;
				gint _param_index = 0;
				_tmp684_ = dynamic_sig;
				_tmp685_ = vala_dynamic_signal_get_handler (_tmp684_);
				_tmp686_ = _tmp685_;
				_tmp687_ = vala_expression_get_value_type (_tmp686_);
				_tmp688_ = _tmp687_;
				_tmp689_ = vala_data_type_get_parameters (_tmp688_);
				_param_list = _tmp689_;
				_tmp690_ = _param_list;
				_tmp691_ = vala_collection_get_size ((ValaCollection*) _tmp690_);
				_tmp692_ = _tmp691_;
				_param_size = _tmp692_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp693_;
					gint _tmp694_;
					gint _tmp695_;
					ValaParameter* param = NULL;
					ValaList* _tmp696_;
					gint _tmp697_;
					gpointer _tmp698_;
					gboolean _tmp699_;
					_tmp693_ = _param_index;
					_param_index = _tmp693_ + 1;
					_tmp694_ = _param_index;
					_tmp695_ = _param_size;
					if (!(_tmp694_ < _tmp695_)) {
						break;
					}
					_tmp696_ = _param_list;
					_tmp697_ = _param_index;
					_tmp698_ = vala_list_get (_tmp696_, _tmp697_);
					param = (ValaParameter*) _tmp698_;
					_tmp699_ = first;
					if (_tmp699_) {
						first = FALSE;
					} else {
						ValaDynamicSignal* _tmp700_;
						ValaParameter* _tmp701_;
						ValaParameter* _tmp702_;
						ValaParameter* _tmp703_;
						_tmp700_ = dynamic_sig;
						_tmp701_ = param;
						_tmp702_ = vala_parameter_copy (_tmp701_);
						_tmp703_ = _tmp702_;
						vala_callable_add_parameter ((ValaCallable*) _tmp700_, _tmp703_);
						_vala_code_node_unref0 (_tmp703_);
					}
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp704_ = dynamic_sig;
			_tmp705_ = vala_dynamic_signal_get_handler (_tmp704_);
			_tmp706_ = _tmp705_;
			_tmp707_ = dynamic_sig;
			_tmp708_ = dynamic_sig;
			_tmp709_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp708_);
			_tmp710_ = _tmp709_;
			_tmp711_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp710_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp712_ = _tmp711_;
			_tmp713_ = vala_signal_get_delegate ((ValaSignal*) _tmp707_, (ValaDataType*) _tmp712_, (ValaCodeNode*) self);
			_tmp714_ = _tmp713_;
			_tmp715_ = vala_delegate_type_new (_tmp714_);
			_tmp716_ = _tmp715_;
			vala_expression_set_target_type (_tmp706_, (ValaDataType*) _tmp716_);
			_vala_code_node_unref0 (_tmp716_);
			_vala_code_node_unref0 (_tmp714_);
			_vala_code_node_unref0 (_tmp712_);
		}
		_tmp718_ = m;
		if (_tmp718_ != NULL) {
			ValaMethod* _tmp719_;
			ValaList* _tmp720_;
			ValaList* _tmp721_;
			gint _tmp722_;
			gint _tmp723_;
			_tmp719_ = m;
			_tmp720_ = vala_method_get_type_parameters (_tmp719_);
			_tmp721_ = _tmp720_;
			_tmp722_ = vala_collection_get_size ((ValaCollection*) _tmp721_);
			_tmp723_ = _tmp722_;
			_tmp717_ = _tmp723_ > 0;
			_vala_iterable_unref0 (_tmp721_);
		} else {
			_tmp717_ = FALSE;
		}
		if (_tmp717_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp724_;
			ValaExpression* _tmp725_;
			ValaMemberAccess* _tmp726_;
			ValaMemberAccess* _tmp727_;
			ValaList* _tmp728_;
			ValaList* _tmp729_;
			gint _tmp730_;
			gint _tmp731_;
			gboolean _tmp732_;
			_tmp724_ = vala_method_call_get_call (self);
			_tmp725_ = _tmp724_;
			_tmp726_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp725_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp726_;
			_tmp727_ = ma;
			_tmp728_ = vala_member_access_get_type_arguments (_tmp727_);
			_tmp729_ = _tmp728_;
			_tmp730_ = vala_collection_get_size ((ValaCollection*) _tmp729_);
			_tmp731_ = _tmp730_;
			_tmp732_ = _tmp731_ == 0;
			_vala_iterable_unref0 (_tmp729_);
			if (_tmp732_) {
				ValaList* _tmp806_;
				ValaIterator* _tmp807_;
				ValaDataType* _tmp837_;
				ValaDataType* _tmp838_;
				ValaDataType* _tmp839_;
				ValaList* _tmp840_;
				ValaDataType* _tmp841_;
				ValaDataType* _tmp842_;
				{
					ValaList* _type_param_list = NULL;
					ValaMethod* _tmp733_;
					ValaList* _tmp734_;
					gint _type_param_size = 0;
					ValaList* _tmp735_;
					gint _tmp736_;
					gint _tmp737_;
					gint _type_param_index = 0;
					_tmp733_ = m;
					_tmp734_ = vala_method_get_type_parameters (_tmp733_);
					_type_param_list = _tmp734_;
					_tmp735_ = _type_param_list;
					_tmp736_ = vala_collection_get_size ((ValaCollection*) _tmp735_);
					_tmp737_ = _tmp736_;
					_type_param_size = _tmp737_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp738_;
						gint _tmp739_;
						gint _tmp740_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp741_;
						gint _tmp742_;
						gpointer _tmp743_;
						ValaDataType* type_arg = NULL;
						ValaList* _tmp744_;
						ValaIterator* _tmp745_;
						gboolean _tmp784_ = FALSE;
						ValaDataType* _tmp785_;
						ValaDataType* _tmp795_;
						ValaMemberAccess* _tmp804_;
						ValaDataType* _tmp805_;
						_tmp738_ = _type_param_index;
						_type_param_index = _tmp738_ + 1;
						_tmp739_ = _type_param_index;
						_tmp740_ = _type_param_size;
						if (!(_tmp739_ < _tmp740_)) {
							break;
						}
						_tmp741_ = _type_param_list;
						_tmp742_ = _type_param_index;
						_tmp743_ = vala_list_get (_tmp741_, _tmp742_);
						type_param = (ValaTypeParameter*) _tmp743_;
						type_arg = NULL;
						_tmp744_ = args;
						_tmp745_ = vala_iterable_iterator ((ValaIterable*) _tmp744_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp745_;
						{
							ValaList* _param_list = NULL;
							ValaList* _tmp746_;
							ValaList* _tmp747_;
							gint _param_size = 0;
							ValaList* _tmp748_;
							gint _tmp749_;
							gint _tmp750_;
							gint _param_index = 0;
							_tmp746_ = params;
							_tmp747_ = _vala_iterable_ref0 (_tmp746_);
							_param_list = _tmp747_;
							_tmp748_ = _param_list;
							_tmp749_ = vala_collection_get_size ((ValaCollection*) _tmp748_);
							_tmp750_ = _tmp749_;
							_param_size = _tmp750_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp751_;
								gint _tmp752_;
								gint _tmp753_;
								ValaParameter* param = NULL;
								ValaList* _tmp754_;
								gint _tmp755_;
								gpointer _tmp756_;
								gboolean _tmp757_ = FALSE;
								ValaParameter* _tmp758_;
								gboolean _tmp759_;
								gboolean _tmp760_;
								ValaIterator* _tmp764_;
								_tmp751_ = _param_index;
								_param_index = _tmp751_ + 1;
								_tmp752_ = _param_index;
								_tmp753_ = _param_size;
								if (!(_tmp752_ < _tmp753_)) {
									break;
								}
								_tmp754_ = _param_list;
								_tmp755_ = _param_index;
								_tmp756_ = vala_list_get (_tmp754_, _tmp755_);
								param = (ValaParameter*) _tmp756_;
								_tmp758_ = param;
								_tmp759_ = vala_parameter_get_ellipsis (_tmp758_);
								_tmp760_ = _tmp759_;
								if (_tmp760_) {
									_tmp757_ = TRUE;
								} else {
									ValaParameter* _tmp761_;
									gboolean _tmp762_;
									gboolean _tmp763_;
									_tmp761_ = param;
									_tmp762_ = vala_parameter_get_params_array (_tmp761_);
									_tmp763_ = _tmp762_;
									_tmp757_ = _tmp763_;
								}
								if (_tmp757_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp764_ = arg_it;
								if (vala_iterator_next (_tmp764_)) {
									ValaExpression* arg = NULL;
									ValaIterator* _tmp765_;
									gpointer _tmp766_;
									ValaParameter* _tmp767_;
									ValaDataType* _tmp768_;
									ValaDataType* _tmp769_;
									ValaTypeParameter* _tmp770_;
									ValaExpression* _tmp771_;
									ValaDataType* _tmp772_;
									ValaDataType* _tmp773_;
									ValaDataType* _tmp774_;
									ValaDataType* _tmp775_;
									ValaExpression* _tmp776_;
									ValaExpression* _tmp777_;
									ValaDataType* _tmp778_;
									ValaDataType* _tmp779_;
									ValaDataType* _tmp780_;
									ValaList* _tmp781_;
									ValaDataType* _tmp782_;
									ValaDataType* _tmp783_;
									_tmp765_ = arg_it;
									_tmp766_ = vala_iterator_get (_tmp765_);
									arg = (ValaExpression*) _tmp766_;
									_tmp767_ = param;
									_tmp768_ = vala_variable_get_variable_type ((ValaVariable*) _tmp767_);
									_tmp769_ = _tmp768_;
									_tmp770_ = type_param;
									_tmp771_ = arg;
									_tmp772_ = vala_expression_get_value_type (_tmp771_);
									_tmp773_ = _tmp772_;
									_tmp774_ = vala_data_type_infer_type_argument (_tmp769_, _tmp770_, _tmp773_);
									_vala_code_node_unref0 (type_arg);
									type_arg = _tmp774_;
									_tmp775_ = type_arg;
									if (_tmp775_ != NULL) {
										_vala_code_node_unref0 (arg);
										_vala_code_node_unref0 (param);
										break;
									}
									_tmp776_ = arg;
									_tmp777_ = arg;
									_tmp778_ = vala_expression_get_formal_target_type (_tmp777_);
									_tmp779_ = _tmp778_;
									_tmp780_ = target_object_type;
									_tmp781_ = method_type_args;
									_tmp782_ = vala_data_type_get_actual_type (_tmp779_, _tmp780_, _tmp781_, (ValaCodeNode*) self);
									_tmp783_ = _tmp782_;
									vala_expression_set_target_type (_tmp776_, _tmp783_);
									_vala_code_node_unref0 (_tmp783_);
									_vala_code_node_unref0 (arg);
								}
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp785_ = type_arg;
						if (_tmp785_ == NULL) {
							ValaDataType* _tmp786_;
							ValaDataType* _tmp787_;
							_tmp786_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp787_ = _tmp786_;
							_tmp784_ = _tmp787_ != NULL;
						} else {
							_tmp784_ = FALSE;
						}
						if (_tmp784_) {
							ValaMethod* _tmp788_;
							ValaDataType* _tmp789_;
							ValaDataType* _tmp790_;
							ValaTypeParameter* _tmp791_;
							ValaDataType* _tmp792_;
							ValaDataType* _tmp793_;
							ValaDataType* _tmp794_;
							_tmp788_ = m;
							_tmp789_ = vala_callable_get_return_type ((ValaCallable*) _tmp788_);
							_tmp790_ = _tmp789_;
							_tmp791_ = type_param;
							_tmp792_ = vala_expression_get_target_type ((ValaExpression*) self);
							_tmp793_ = _tmp792_;
							_tmp794_ = vala_data_type_infer_type_argument (_tmp790_, _tmp791_, _tmp793_);
							_vala_code_node_unref0 (type_arg);
							type_arg = _tmp794_;
						}
						_tmp795_ = type_arg;
						if (_tmp795_ == NULL) {
							ValaMemberAccess* _tmp796_;
							ValaSourceReference* _tmp797_;
							ValaSourceReference* _tmp798_;
							ValaTypeParameter* _tmp799_;
							gchar* _tmp800_;
							gchar* _tmp801_;
							gchar* _tmp802_;
							gchar* _tmp803_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp796_ = ma;
							_tmp797_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp796_);
							_tmp798_ = _tmp797_;
							_tmp799_ = type_param;
							_tmp800_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp799_);
							_tmp801_ = _tmp800_;
							_tmp802_ = g_strdup_printf ("cannot infer generic type argument for type parameter `%s'", _tmp801_);
							_tmp803_ = _tmp802_;
							vala_report_error (_tmp798_, _tmp803_);
							_g_free0 (_tmp803_);
							_g_free0 (_tmp801_);
							result = FALSE;
							_vala_code_node_unref0 (type_arg);
							_vala_code_node_unref0 (type_param);
							_vala_iterable_unref0 (_type_param_list);
							_vala_code_node_unref0 (ma);
							_vala_code_node_unref0 (dynamic_sig);
							_vala_code_node_unref0 (m);
							_vala_iterator_unref0 (arg_it);
							_vala_iterable_unref0 (args);
							_vala_code_node_unref0 (last_arg);
							_vala_iterable_unref0 (params);
							_vala_code_node_unref0 (ret_type);
							_vala_code_node_unref0 (base_cm);
							_vala_code_node_unref0 (mtype);
							_vala_iterable_unref0 (method_type_args);
							_vala_code_node_unref0 (target_object_type);
							return result;
						}
						_tmp804_ = ma;
						_tmp805_ = type_arg;
						vala_member_access_add_type_argument (_tmp804_, _tmp805_);
						_vala_code_node_unref0 (type_arg);
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_tmp806_ = args;
				_tmp807_ = vala_iterable_iterator ((ValaIterable*) _tmp806_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp807_;
				{
					ValaList* _param_list = NULL;
					ValaList* _tmp808_;
					ValaList* _tmp809_;
					gint _param_size = 0;
					ValaList* _tmp810_;
					gint _tmp811_;
					gint _tmp812_;
					gint _param_index = 0;
					_tmp808_ = params;
					_tmp809_ = _vala_iterable_ref0 (_tmp808_);
					_param_list = _tmp809_;
					_tmp810_ = _param_list;
					_tmp811_ = vala_collection_get_size ((ValaCollection*) _tmp810_);
					_tmp812_ = _tmp811_;
					_param_size = _tmp812_;
					_param_index = -1;
					while (TRUE) {
						gint _tmp813_;
						gint _tmp814_;
						gint _tmp815_;
						ValaParameter* param = NULL;
						ValaList* _tmp816_;
						gint _tmp817_;
						gpointer _tmp818_;
						gboolean _tmp819_ = FALSE;
						ValaParameter* _tmp820_;
						gboolean _tmp821_;
						gboolean _tmp822_;
						ValaIterator* _tmp826_;
						_tmp813_ = _param_index;
						_param_index = _tmp813_ + 1;
						_tmp814_ = _param_index;
						_tmp815_ = _param_size;
						if (!(_tmp814_ < _tmp815_)) {
							break;
						}
						_tmp816_ = _param_list;
						_tmp817_ = _param_index;
						_tmp818_ = vala_list_get (_tmp816_, _tmp817_);
						param = (ValaParameter*) _tmp818_;
						_tmp820_ = param;
						_tmp821_ = vala_parameter_get_ellipsis (_tmp820_);
						_tmp822_ = _tmp821_;
						if (_tmp822_) {
							_tmp819_ = TRUE;
						} else {
							ValaParameter* _tmp823_;
							gboolean _tmp824_;
							gboolean _tmp825_;
							_tmp823_ = param;
							_tmp824_ = vala_parameter_get_params_array (_tmp823_);
							_tmp825_ = _tmp824_;
							_tmp819_ = _tmp825_;
						}
						if (_tmp819_) {
							_vala_code_node_unref0 (param);
							break;
						}
						_tmp826_ = arg_it;
						if (vala_iterator_next (_tmp826_)) {
							ValaExpression* arg = NULL;
							ValaIterator* _tmp827_;
							gpointer _tmp828_;
							ValaExpression* _tmp829_;
							ValaExpression* _tmp830_;
							ValaDataType* _tmp831_;
							ValaDataType* _tmp832_;
							ValaDataType* _tmp833_;
							ValaList* _tmp834_;
							ValaDataType* _tmp835_;
							ValaDataType* _tmp836_;
							_tmp827_ = arg_it;
							_tmp828_ = vala_iterator_get (_tmp827_);
							arg = (ValaExpression*) _tmp828_;
							_tmp829_ = arg;
							_tmp830_ = arg;
							_tmp831_ = vala_expression_get_formal_target_type (_tmp830_);
							_tmp832_ = _tmp831_;
							_tmp833_ = target_object_type;
							_tmp834_ = method_type_args;
							_tmp835_ = vala_data_type_get_actual_type (_tmp832_, _tmp833_, _tmp834_, (ValaCodeNode*) self);
							_tmp836_ = _tmp835_;
							vala_expression_set_target_type (_tmp829_, _tmp836_);
							_vala_code_node_unref0 (_tmp836_);
							_vala_code_node_unref0 (arg);
						}
						_vala_code_node_unref0 (param);
					}
					_vala_iterable_unref0 (_param_list);
				}
				_tmp837_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
				_tmp838_ = _tmp837_;
				_tmp839_ = target_object_type;
				_tmp840_ = method_type_args;
				_tmp841_ = vala_data_type_get_actual_type (_tmp838_, _tmp839_, _tmp840_, (ValaCodeNode*) self);
				_tmp842_ = _tmp841_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp842_);
				_vala_code_node_unref0 (_tmp842_);
			}
			_vala_code_node_unref0 (ma);
		}
		_tmp844_ = m;
		if (_tmp844_ != NULL) {
			ValaMethod* _tmp845_;
			gboolean _tmp846_;
			gboolean _tmp847_;
			_tmp845_ = m;
			_tmp846_ = vala_method_get_coroutine (_tmp845_);
			_tmp847_ = _tmp846_;
			_tmp843_ = _tmp847_;
		} else {
			_tmp843_ = FALSE;
		}
		if (_tmp843_) {
			ValaMemberAccess* ma = NULL;
			ValaExpression* _tmp848_;
			ValaExpression* _tmp849_;
			ValaMemberAccess* _tmp850_;
			ValaMemberAccess* _tmp851_;
			const gchar* _tmp852_;
			const gchar* _tmp853_;
			_tmp848_ = vala_method_call_get_call (self);
			_tmp849_ = _tmp848_;
			_tmp850_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp849_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			ma = _tmp850_;
			_tmp851_ = ma;
			_tmp852_ = vala_member_access_get_member_name (_tmp851_);
			_tmp853_ = _tmp852_;
			if (g_strcmp0 (_tmp853_, "end") == 0) {
				ValaMethod* _tmp854_;
				ValaMethod* _tmp855_;
				ValaMethod* _tmp856_;
				ValaMethodType* _tmp857_;
				_tmp854_ = m;
				_tmp855_ = vala_method_get_end_method (_tmp854_);
				_tmp856_ = _tmp855_;
				_tmp857_ = vala_method_type_new (_tmp856_);
				_vala_code_node_unref0 (mtype);
				mtype = (ValaDataType*) _tmp857_;
				_vala_code_node_unref0 (_tmp856_);
			}
			_vala_code_node_unref0 (ma);
		}
		_vala_code_node_unref0 (dynamic_sig);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp858_;
		_tmp858_ = mtype;
		if (VALA_IS_OBJECT_TYPE (_tmp858_)) {
			ValaClass* cl = NULL;
			ValaDataType* _tmp859_;
			ValaObjectTypeSymbol* _tmp860_;
			ValaObjectTypeSymbol* _tmp861_;
			ValaClass* _tmp862_;
			ValaCreationMethod* m = NULL;
			ValaClass* _tmp863_;
			ValaCreationMethod* _tmp864_;
			ValaCreationMethod* _tmp865_;
			ValaCreationMethod* _tmp866_;
			_tmp859_ = mtype;
			_tmp860_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp859_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
			_tmp861_ = _tmp860_;
			_tmp862_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp861_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp862_;
			_tmp863_ = cl;
			_tmp864_ = vala_class_get_default_construction_method (_tmp863_);
			_tmp865_ = _tmp864_;
			_tmp866_ = _vala_code_node_ref0 (_tmp865_);
			m = _tmp866_;
			{
				ValaList* _error_type_list = NULL;
				ValaCreationMethod* _tmp867_;
				ValaList* _tmp868_;
				gint _error_type_size = 0;
				ValaList* _tmp869_;
				gint _tmp870_;
				gint _tmp871_;
				gint _error_type_index = 0;
				_tmp867_ = m;
				_tmp868_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp867_);
				_error_type_list = _tmp868_;
				_tmp869_ = _error_type_list;
				_tmp870_ = vala_collection_get_size ((ValaCollection*) _tmp869_);
				_tmp871_ = _tmp870_;
				_error_type_size = _tmp871_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp872_;
					gint _tmp873_;
					gint _tmp874_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp875_;
					gint _tmp876_;
					gpointer _tmp877_;
					ValaDataType* call_error_type = NULL;
					ValaDataType* _tmp878_;
					ValaDataType* _tmp879_;
					ValaDataType* _tmp880_;
					ValaSourceReference* _tmp881_;
					ValaSourceReference* _tmp882_;
					ValaDataType* _tmp883_;
					_tmp872_ = _error_type_index;
					_error_type_index = _tmp872_ + 1;
					_tmp873_ = _error_type_index;
					_tmp874_ = _error_type_size;
					if (!(_tmp873_ < _tmp874_)) {
						break;
					}
					_tmp875_ = _error_type_list;
					_tmp876_ = _error_type_index;
					_tmp877_ = vala_list_get (_tmp875_, _tmp876_);
					error_type = (ValaDataType*) _tmp877_;
					may_throw = TRUE;
					_tmp878_ = error_type;
					_tmp879_ = vala_data_type_copy (_tmp878_);
					call_error_type = _tmp879_;
					_tmp880_ = call_error_type;
					_tmp881_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp882_ = _tmp881_;
					vala_code_node_set_source_reference ((ValaCodeNode*) _tmp880_, _tmp882_);
					_tmp883_ = call_error_type;
					vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp883_);
					_vala_code_node_unref0 (call_error_type);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (cl);
		} else {
			ValaDataType* _tmp884_;
			_tmp884_ = mtype;
			if (VALA_IS_DELEGATE_TYPE (_tmp884_)) {
				ValaDelegate* d = NULL;
				ValaDataType* _tmp885_;
				ValaDelegate* _tmp886_;
				ValaDelegate* _tmp887_;
				ValaDelegate* _tmp888_;
				_tmp885_ = mtype;
				_tmp886_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp885_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				_tmp887_ = _tmp886_;
				_tmp888_ = _vala_code_node_ref0 (_tmp887_);
				d = _tmp888_;
				{
					ValaList* _error_type_list = NULL;
					ValaDelegate* _tmp889_;
					ValaList* _tmp890_;
					gint _error_type_size = 0;
					ValaList* _tmp891_;
					gint _tmp892_;
					gint _tmp893_;
					gint _error_type_index = 0;
					_tmp889_ = d;
					_tmp890_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp889_);
					_error_type_list = _tmp890_;
					_tmp891_ = _error_type_list;
					_tmp892_ = vala_collection_get_size ((ValaCollection*) _tmp891_);
					_tmp893_ = _tmp892_;
					_error_type_size = _tmp893_;
					_error_type_index = -1;
					while (TRUE) {
						gint _tmp894_;
						gint _tmp895_;
						gint _tmp896_;
						ValaDataType* error_type = NULL;
						ValaList* _tmp897_;
						gint _tmp898_;
						gpointer _tmp899_;
						ValaDataType* call_error_type = NULL;
						ValaDataType* _tmp900_;
						ValaDataType* _tmp901_;
						ValaDataType* _tmp902_;
						ValaSourceReference* _tmp903_;
						ValaSourceReference* _tmp904_;
						ValaDataType* _tmp905_;
						_tmp894_ = _error_type_index;
						_error_type_index = _tmp894_ + 1;
						_tmp895_ = _error_type_index;
						_tmp896_ = _error_type_size;
						if (!(_tmp895_ < _tmp896_)) {
							break;
						}
						_tmp897_ = _error_type_list;
						_tmp898_ = _error_type_index;
						_tmp899_ = vala_list_get (_tmp897_, _tmp898_);
						error_type = (ValaDataType*) _tmp899_;
						may_throw = TRUE;
						_tmp900_ = error_type;
						_tmp901_ = vala_data_type_copy (_tmp900_);
						call_error_type = _tmp901_;
						_tmp902_ = call_error_type;
						_tmp903_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp904_ = _tmp903_;
						vala_code_node_set_source_reference ((ValaCodeNode*) _tmp902_, _tmp904_);
						_tmp905_ = call_error_type;
						vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp905_);
						_vala_code_node_unref0 (call_error_type);
						_vala_code_node_unref0 (error_type);
					}
					_vala_iterable_unref0 (_error_type_list);
				}
				_vala_code_node_unref0 (d);
			}
		}
	}
	_tmp906_ = vala_code_context_get_analyzer (context);
	_tmp907_ = _tmp906_;
	_tmp908_ = mtype;
	_tmp909_ = params;
	_tmp910_ = vala_method_call_get_argument_list (self);
	_tmp911_ = _tmp910_;
	_tmp912_ = !vala_semantic_analyzer_check_arguments (_tmp907_, (ValaExpression*) self, _tmp908_, _tmp909_, _tmp911_);
	_vala_iterable_unref0 (_tmp911_);
	if (_tmp912_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (ret_type);
		_vala_code_node_unref0 (base_cm);
		_vala_code_node_unref0 (mtype);
		_vala_iterable_unref0 (method_type_args);
		_vala_code_node_unref0 (target_object_type);
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp913_;
		gint _arg_size = 0;
		ValaList* _tmp914_;
		gint _tmp915_;
		gint _tmp916_;
		gint _arg_index = 0;
		_tmp913_ = vala_method_call_get_argument_list (self);
		_arg_list = _tmp913_;
		_tmp914_ = _arg_list;
		_tmp915_ = vala_collection_get_size ((ValaCollection*) _tmp914_);
		_tmp916_ = _tmp915_;
		_arg_size = _tmp916_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp917_;
			gint _tmp918_;
			gint _tmp919_;
			ValaExpression* arg = NULL;
			ValaList* _tmp920_;
			gint _tmp921_;
			gpointer _tmp922_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp923_;
			gboolean _tmp924_ = FALSE;
			ValaSizeofExpression* _tmp925_;
			_tmp917_ = _arg_index;
			_arg_index = _tmp917_ + 1;
			_tmp918_ = _arg_index;
			_tmp919_ = _arg_size;
			if (!(_tmp918_ < _tmp919_)) {
				break;
			}
			_tmp920_ = _arg_list;
			_tmp921_ = _arg_index;
			_tmp922_ = vala_list_get (_tmp920_, _tmp921_);
			arg = (ValaExpression*) _tmp922_;
			_tmp923_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp923_) ? ((ValaSizeofExpression*) _tmp923_) : NULL;
			_tmp925_ = sizeof_expr;
			if (_tmp925_ != NULL) {
				ValaSizeofExpression* _tmp926_;
				ValaDataType* _tmp927_;
				ValaDataType* _tmp928_;
				_tmp926_ = sizeof_expr;
				_tmp927_ = vala_sizeof_expression_get_type_reference (_tmp926_);
				_tmp928_ = _tmp927_;
				_tmp924_ = VALA_IS_GENERIC_TYPE (_tmp928_);
			} else {
				_tmp924_ = FALSE;
			}
			if (_tmp924_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp929_;
				ValaDataType* _tmp930_;
				ValaDataType* _tmp931_;
				ValaDataType* _tmp932_;
				ValaList* _tmp933_;
				ValaDataType* _tmp934_;
				ValaExpression* _tmp935_;
				ValaDataType* _tmp936_;
				ValaSourceReference* _tmp937_;
				ValaSourceReference* _tmp938_;
				ValaSizeofExpression* _tmp939_;
				ValaSizeofExpression* _tmp940_;
				_tmp929_ = sizeof_expr;
				_tmp930_ = vala_sizeof_expression_get_type_reference (_tmp929_);
				_tmp931_ = _tmp930_;
				_tmp932_ = target_object_type;
				_tmp933_ = method_type_args;
				_tmp934_ = vala_data_type_get_actual_type (_tmp931_, _tmp932_, _tmp933_, (ValaCodeNode*) self);
				sizeof_type = _tmp934_;
				_tmp935_ = arg;
				_tmp936_ = sizeof_type;
				_tmp937_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp938_ = _tmp937_;
				_tmp939_ = vala_sizeof_expression_new (_tmp936_, _tmp938_);
				_tmp940_ = _tmp939_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp935_, (ValaExpression*) _tmp940_);
				_vala_code_node_unref0 (_tmp940_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp943_ = base_cm;
	if (_tmp943_ != NULL) {
		ValaCreationMethod* _tmp944_;
		_tmp944_ = base_cm;
		_tmp942_ = vala_method_is_variadic ((ValaMethod*) _tmp944_);
	} else {
		_tmp942_ = FALSE;
	}
	if (_tmp942_) {
		ValaList* _tmp945_;
		gint _tmp946_;
		gint _tmp947_;
		ValaCreationMethod* _tmp948_;
		ValaList* _tmp949_;
		ValaList* _tmp950_;
		gint _tmp951_;
		gint _tmp952_;
		_tmp945_ = args;
		_tmp946_ = vala_collection_get_size ((ValaCollection*) _tmp945_);
		_tmp947_ = _tmp946_;
		_tmp948_ = base_cm;
		_tmp949_ = vala_callable_get_parameters ((ValaCallable*) _tmp948_);
		_tmp950_ = _tmp949_;
		_tmp951_ = vala_collection_get_size ((ValaCollection*) _tmp950_);
		_tmp952_ = _tmp951_;
		_tmp941_ = _tmp947_ == _tmp952_;
		_vala_iterable_unref0 (_tmp950_);
	} else {
		_tmp941_ = FALSE;
	}
	if (_tmp941_) {
		ValaExpression* this_last_arg = NULL;
		ValaList* _tmp953_;
		ValaList* _tmp954_;
		gint _tmp955_;
		gint _tmp956_;
		gpointer _tmp957_;
		gboolean _tmp958_ = FALSE;
		ValaExpression* _tmp959_;
		ValaDataType* _tmp960_;
		ValaDataType* _tmp961_;
		_tmp953_ = args;
		_tmp954_ = args;
		_tmp955_ = vala_collection_get_size ((ValaCollection*) _tmp954_);
		_tmp956_ = _tmp955_;
		_tmp957_ = vala_list_get (_tmp953_, _tmp956_ - 1);
		this_last_arg = (ValaExpression*) _tmp957_;
		_tmp959_ = this_last_arg;
		_tmp960_ = vala_expression_get_value_type (_tmp959_);
		_tmp961_ = _tmp960_;
		if (VALA_IS_STRUCT_VALUE_TYPE (_tmp961_)) {
			ValaExpression* _tmp962_;
			ValaDataType* _tmp963_;
			ValaDataType* _tmp964_;
			ValaTypeSymbol* _tmp965_;
			ValaTypeSymbol* _tmp966_;
			ValaSemanticAnalyzer* _tmp967_;
			ValaSemanticAnalyzer* _tmp968_;
			ValaDataType* _tmp969_;
			ValaTypeSymbol* _tmp970_;
			ValaTypeSymbol* _tmp971_;
			_tmp962_ = this_last_arg;
			_tmp963_ = vala_expression_get_value_type (_tmp962_);
			_tmp964_ = _tmp963_;
			_tmp965_ = vala_data_type_get_data_type (_tmp964_);
			_tmp966_ = _tmp965_;
			_tmp967_ = vala_code_context_get_analyzer (context);
			_tmp968_ = _tmp967_;
			_tmp969_ = _tmp968_->va_list_type;
			_tmp970_ = vala_data_type_get_data_type (_tmp969_);
			_tmp971_ = _tmp970_;
			_tmp958_ = _tmp966_ == _tmp971_;
		} else {
			_tmp958_ = FALSE;
		}
		if (_tmp958_) {
			vala_method_call_set_is_constructv_chainup (self, TRUE);
		}
		_vala_code_node_unref0 (this_last_arg);
	}
	_tmp972_ = may_throw;
	if (_tmp972_) {
		gboolean _tmp973_ = FALSE;
		ValaCodeNode* _tmp974_;
		ValaCodeNode* _tmp975_;
		_tmp974_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp975_ = _tmp974_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp975_)) {
			_tmp973_ = TRUE;
		} else {
			ValaCodeNode* _tmp976_;
			ValaCodeNode* _tmp977_;
			_tmp976_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp977_ = _tmp976_;
			_tmp973_ = VALA_IS_EXPRESSION_STATEMENT (_tmp977_);
		}
		if (_tmp973_) {
		} else {
			ValaSemanticAnalyzer* _tmp978_;
			ValaSemanticAnalyzer* _tmp979_;
			ValaSymbol* _tmp980_;
			ValaSymbol* _tmp981_;
			_tmp978_ = vala_code_context_get_analyzer (context);
			_tmp979_ = _tmp978_;
			_tmp980_ = vala_semantic_analyzer_get_current_symbol (_tmp979_);
			_tmp981_ = _tmp980_;
			if (!VALA_IS_BLOCK (_tmp981_)) {
				ValaSourceReference* _tmp982_;
				ValaSourceReference* _tmp983_;
				_tmp982_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp983_ = _tmp982_;
				vala_report_error (_tmp983_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp984_;
				ValaCodeNode* _tmp985_;
				ValaCodeNode* _tmp986_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp987_;
				ValaDataType* _tmp988_;
				ValaDataType* _tmp989_;
				ValaDataType* _tmp990_;
				gchar* _tmp991_;
				gchar* _tmp992_;
				ValaSourceReference* _tmp993_;
				ValaSourceReference* _tmp994_;
				ValaLocalVariable* _tmp995_;
				ValaLocalVariable* _tmp996_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp997_;
				ValaSourceReference* _tmp998_;
				ValaSourceReference* _tmp999_;
				ValaDeclarationStatement* _tmp1000_;
				ValaSemanticAnalyzer* _tmp1001_;
				ValaSemanticAnalyzer* _tmp1002_;
				ValaBlock* _tmp1003_;
				ValaDeclarationStatement* _tmp1004_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp1005_;
				ValaDataType* _tmp1006_;
				ValaDataType* _tmp1007_;
				ValaExpression* _tmp1008_;
				ValaExpression* _tmp1009_;
				ValaDataType* _tmp1010_;
				ValaDataType* _tmp1011_;
				ValaLocalVariable* _tmp1012_;
				ValaDeclarationStatement* _tmp1013_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp1014_;
				ValaSemanticAnalyzer* _tmp1015_;
				ValaSymbol* _tmp1016_;
				ValaSymbol* _tmp1017_;
				ValaBlock* _tmp1018_;
				ValaBlock* _tmp1019_;
				ValaLocalVariable* _tmp1020_;
				ValaSemanticAnalyzer* _tmp1021_;
				ValaSemanticAnalyzer* _tmp1022_;
				ValaBlock* _tmp1023_;
				ValaLocalVariable* _tmp1024_;
				ValaCodeNode* _tmp1025_;
				ValaExpression* _tmp1026_;
				ValaExpression* _tmp1027_;
				_tmp984_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp985_ = _tmp984_;
				_tmp986_ = _vala_code_node_ref0 (_tmp985_);
				old_parent_node = _tmp986_;
				_tmp987_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp988_ = _tmp987_;
				_tmp989_ = vala_data_type_copy (_tmp988_);
				_tmp990_ = _tmp989_;
				_tmp991_ = vala_code_node_get_temp_name ();
				_tmp992_ = _tmp991_;
				_tmp993_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp994_ = _tmp993_;
				_tmp995_ = vala_local_variable_new (_tmp990_, _tmp992_, NULL, _tmp994_);
				_tmp996_ = _tmp995_;
				_g_free0 (_tmp992_);
				_vala_code_node_unref0 (_tmp990_);
				local = _tmp996_;
				_tmp997_ = local;
				_tmp998_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp999_ = _tmp998_;
				_tmp1000_ = vala_declaration_statement_new ((ValaSymbol*) _tmp997_, _tmp999_);
				decl = _tmp1000_;
				_tmp1001_ = vala_code_context_get_analyzer (context);
				_tmp1002_ = _tmp1001_;
				_tmp1003_ = _tmp1002_->insert_block;
				_tmp1004_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp1003_, (ValaStatement*) _tmp1004_);
				_tmp1005_ = local;
				_tmp1006_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1007_ = _tmp1006_;
				_tmp1008_ = vala_semantic_analyzer_create_temp_access (_tmp1005_, _tmp1007_);
				temp_access = _tmp1008_;
				_tmp1009_ = temp_access;
				_tmp1010_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
				_tmp1011_ = _tmp1010_;
				vala_expression_set_formal_target_type (_tmp1009_, _tmp1011_);
				_tmp1012_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp1012_, (ValaExpression*) self);
				_tmp1013_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp1013_, context);
				_tmp1014_ = vala_code_context_get_analyzer (context);
				_tmp1015_ = _tmp1014_;
				_tmp1016_ = vala_semantic_analyzer_get_current_symbol (_tmp1015_);
				_tmp1017_ = _tmp1016_;
				_tmp1018_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1017_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp1018_;
				_tmp1019_ = block;
				_tmp1020_ = local;
				vala_block_remove_local_variable (_tmp1019_, _tmp1020_);
				_tmp1021_ = vala_code_context_get_analyzer (context);
				_tmp1022_ = _tmp1021_;
				_tmp1023_ = _tmp1022_->insert_block;
				_tmp1024_ = local;
				vala_block_add_local_variable (_tmp1023_, _tmp1024_);
				_tmp1025_ = old_parent_node;
				_tmp1026_ = temp_access;
				vala_code_node_replace_expression (_tmp1025_, (ValaExpression*) self, _tmp1026_);
				_tmp1027_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp1027_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp1028_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1029_ = _tmp1028_;
	result = !_tmp1029_;
	_vala_iterator_unref0 (arg_it);
	_vala_iterable_unref0 (args);
	_vala_code_node_unref0 (last_arg);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (ret_type);
	_vala_code_node_unref0 (base_cm);
	_vala_code_node_unref0 (mtype);
	_vala_iterable_unref0 (method_type_args);
	_vala_code_node_unref0 (target_object_type);
	return result;
}


static void
vala_method_call_real_emit (ValaCodeNode* base,
                            ValaCodeGenerator* codegen)
{
	ValaMethodCall * self;
	ValaMethodType* method_type = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaMethodType* _tmp6_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL);
	method_type = _tmp4_;
	_tmp6_ = method_type;
	if (_tmp6_ != NULL) {
		ValaMethodType* _tmp7_;
		ValaMethod* _tmp8_;
		ValaMethod* _tmp9_;
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp7_ = method_type;
		_tmp8_ = vala_method_type_get_method_symbol (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp5_ = VALA_IS_SIGNAL (_tmp11_);
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		ValaExpression* signal_access = NULL;
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaExpression* _tmp16_;
		ValaExpression* _tmp17_;
		_tmp12_ = vala_method_call_get_call (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		_tmp15_ = _tmp14_;
		_tmp16_ = _vala_code_node_ref0 (_tmp15_);
		signal_access = _tmp16_;
		_tmp17_ = signal_access;
		vala_code_node_emit ((ValaCodeNode*) _tmp17_, codegen);
		_vala_code_node_unref0 (signal_access);
	} else {
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		_tmp18_ = vala_method_call_get_call (self);
		_tmp19_ = _tmp18_;
		vala_code_node_emit ((ValaCodeNode*) _tmp19_, codegen);
	}
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _expr_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _expr_index = 0;
		_tmp20_ = self->priv->argument_list;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_expr_list = _tmp21_;
		_tmp22_ = _expr_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_expr_size = _tmp24_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaExpression* expr = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaExpression* _tmp31_;
			_tmp25_ = _expr_index;
			_expr_index = _tmp25_ + 1;
			_tmp26_ = _expr_index;
			_tmp27_ = _expr_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _expr_list;
			_tmp29_ = _expr_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			expr = (ValaExpression*) _tmp30_;
			_tmp31_ = expr;
			vala_code_node_emit ((ValaCodeNode*) _tmp31_, codegen);
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	vala_code_visitor_visit_method_call ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
	_vala_code_node_unref0 (method_type);
}


static void
vala_method_call_real_get_defined_variables (ValaCodeNode* base,
                                             ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_method_call_real_get_used_variables (ValaCodeNode* base,
                                          ValaCollection* collection)
{
	ValaMethodCall * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMethodCall*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _arg_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _arg_index = 0;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_arg_list = _tmp3_;
		_tmp4_ = _arg_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_arg_size = _tmp6_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValaExpression* arg = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValaExpression* _tmp13_;
			_tmp7_ = _arg_index;
			_arg_index = _tmp7_ + 1;
			_tmp8_ = _arg_index;
			_tmp9_ = _arg_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _arg_list;
			_tmp11_ = _arg_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			arg = (ValaExpression*) _tmp12_;
			_tmp13_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp13_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


ValaStringLiteral*
vala_method_call_get_format_literal (ValaMethodCall* self)
{
	ValaStringLiteral* result = NULL;
	ValaMethodType* mtype = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp2_;
	ValaDataType* _tmp3_;
	ValaMethodType* _tmp4_;
	ValaMethodType* _tmp5_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = vala_method_call_get_call (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_expression_get_value_type (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (VALA_IS_METHOD_TYPE (_tmp3_) ? ((ValaMethodType*) _tmp3_) : NULL);
	mtype = _tmp4_;
	_tmp5_ = mtype;
	if (_tmp5_ != NULL) {
		gint format_arg = 0;
		ValaMethodType* _tmp6_;
		ValaMethod* _tmp7_;
		ValaMethod* _tmp8_;
		gboolean _tmp9_ = FALSE;
		gint _tmp10_;
		_tmp6_ = mtype;
		_tmp7_ = vala_method_type_get_method_symbol (_tmp6_);
		_tmp8_ = _tmp7_;
		format_arg = vala_method_get_format_arg_index (_tmp8_);
		_tmp10_ = format_arg;
		if (_tmp10_ >= 0) {
			gint _tmp11_;
			ValaList* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			_tmp11_ = format_arg;
			_tmp12_ = self->priv->argument_list;
			_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp9_ = _tmp11_ < _tmp14_;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			ValaList* _tmp15_;
			gint _tmp16_;
			gpointer _tmp17_;
			ValaExpression* _tmp18_;
			ValaStringLiteral* _tmp19_;
			ValaStringLiteral* _tmp20_;
			_tmp15_ = self->priv->argument_list;
			_tmp16_ = format_arg;
			_tmp17_ = vala_list_get (_tmp15_, _tmp16_);
			_tmp18_ = (ValaExpression*) _tmp17_;
			_tmp19_ = vala_string_literal_get_format_literal (_tmp18_);
			_tmp20_ = _tmp19_;
			_vala_code_node_unref0 (_tmp18_);
			result = _tmp20_;
			_vala_code_node_unref0 (mtype);
			return result;
		}
	}
	result = NULL;
	_vala_code_node_unref0 (mtype);
	return result;
}


static gchar*
vala_method_call_real_to_string (ValaCodeNode* base)
{
	ValaMethodCall * self;
	gchar* result = NULL;
	GString* b = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	gboolean _tmp2_;
	GString* _tmp4_;
	ValaExpression* _tmp5_;
	ValaExpression* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GString* _tmp9_;
	gboolean first = FALSE;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	self = (ValaMethodCall*) base;
	_tmp0_ = g_string_new ("");
	b = _tmp0_;
	_tmp1_ = b;
	g_string_append_c (_tmp1_, '(');
	_tmp2_ = self->priv->_is_yield_expression;
	if (_tmp2_) {
		GString* _tmp3_;
		_tmp3_ = b;
		g_string_append (_tmp3_, "yield ");
	}
	_tmp4_ = b;
	_tmp5_ = vala_method_call_get_call (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = vala_code_node_to_string ((ValaCodeNode*) _tmp6_);
	_tmp8_ = _tmp7_;
	g_string_append (_tmp4_, _tmp8_);
	_g_free0 (_tmp8_);
	_tmp9_ = b;
	g_string_append_c (_tmp9_, '(');
	first = TRUE;
	{
		ValaList* _expr_list = NULL;
		ValaList* _tmp10_;
		ValaList* _tmp11_;
		gint _expr_size = 0;
		ValaList* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		gint _expr_index = 0;
		_tmp10_ = self->priv->argument_list;
		_tmp11_ = _vala_iterable_ref0 (_tmp10_);
		_expr_list = _tmp11_;
		_tmp12_ = _expr_list;
		_tmp13_ = vala_collection_get_size ((ValaCollection*) _tmp12_);
		_tmp14_ = _tmp13_;
		_expr_size = _tmp14_;
		_expr_index = -1;
		while (TRUE) {
			gint _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			ValaExpression* expr = NULL;
			ValaList* _tmp18_;
			gint _tmp19_;
			gpointer _tmp20_;
			gboolean _tmp21_;
			GString* _tmp23_;
			ValaExpression* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp15_ = _expr_index;
			_expr_index = _tmp15_ + 1;
			_tmp16_ = _expr_index;
			_tmp17_ = _expr_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _expr_list;
			_tmp19_ = _expr_index;
			_tmp20_ = vala_list_get (_tmp18_, _tmp19_);
			expr = (ValaExpression*) _tmp20_;
			_tmp21_ = first;
			if (!_tmp21_) {
				GString* _tmp22_;
				_tmp22_ = b;
				g_string_append (_tmp22_, ", ");
			}
			_tmp23_ = b;
			_tmp24_ = expr;
			_tmp25_ = vala_code_node_to_string ((ValaCodeNode*) _tmp24_);
			_tmp26_ = _tmp25_;
			g_string_append (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			first = FALSE;
			_vala_code_node_unref0 (expr);
		}
		_vala_iterable_unref0 (_expr_list);
	}
	_tmp27_ = b;
	g_string_append (_tmp27_, "))");
	_tmp28_ = b;
	_tmp29_ = _tmp28_->str;
	_tmp30_ = g_strdup (_tmp29_);
	result = _tmp30_;
	_g_string_free0 (b);
	return result;
}


ValaExpression*
vala_method_call_get_call (ValaMethodCall* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_call;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_call (ValaMethodCall* self,
                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_call);
	self->priv->_call = _tmp0_;
	_tmp1_ = self->priv->_call;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


gboolean
vala_method_call_get_is_yield_expression (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_method_call_set_is_yield_expression (ValaMethodCall* self,
                                          gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_method_call_get_is_assert (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_assert;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_assert (ValaMethodCall* self,
                                gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_assert = value;
}


gboolean
vala_method_call_get_is_constructv_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_constructv_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_constructv_chainup (ValaMethodCall* self,
                                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_constructv_chainup = value;
}


gboolean
vala_method_call_get_is_chainup (ValaMethodCall* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_chainup;
	result = _tmp0_;
	return result;
}


static void
vala_method_call_set_is_chainup (ValaMethodCall* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_chainup = value;
}


static void
vala_method_call_class_init (ValaMethodCallClass * klass)
{
	vala_method_call_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_method_call_finalize;
	g_type_class_add_private (klass, sizeof (ValaMethodCallPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_method_call_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_method_call_real_replace_expression;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_method_call_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_method_call_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_method_call_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_method_call_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_method_call_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_method_call_real_to_string;
}


static void
vala_method_call_instance_init (ValaMethodCall * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_METHOD_CALL_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
}


static void
vala_method_call_finalize (ValaCodeNode * obj)
{
	ValaMethodCall * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_METHOD_CALL, ValaMethodCall);
	_vala_code_node_unref0 (self->priv->_call);
	_vala_iterable_unref0 (self->priv->argument_list);
	VALA_CODE_NODE_CLASS (vala_method_call_parent_class)->finalize (obj);
}


/**
 * Represents an invocation expression in the source code.
 */
GType
vala_method_call_get_type (void)
{
	static volatile gsize vala_method_call_type_id__volatile = 0;
	if (g_once_init_enter (&vala_method_call_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMethodCallClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_method_call_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMethodCall), 0, (GInstanceInitFunc) vala_method_call_instance_init, NULL };
		GType vala_method_call_type_id;
		vala_method_call_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMethodCall", &g_define_type_info, 0);
		g_once_init_leave (&vala_method_call_type_id__volatile, vala_method_call_type_id);
	}
	return vala_method_call_type_id__volatile;
}



