/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _static_destructor;
};


static gpointer vala_class_parent_class = NULL;

#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = VALA_IS_CREATION_METHOD (m);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!VALA_IS_VOID_TYPE (_tmp25_)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (VALA_IS_CREATION_METHOD (m)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
	_tmp69_ = vala_method_get_base_interface_type (m);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaScope* _tmp71_;
		ValaScope* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValaScope* _tmp75_;
		ValaScope* _tmp76_;
		_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp74_ = _tmp73_;
		vala_scope_remove (_tmp72_, _tmp74_);
		_tmp75_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_scope_add (_tmp76_, NULL, (ValaSymbol*) m);
	}
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}


static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp2_;
		ValaConstructor* _tmp3_;
		_tmp2_ = vala_class_get_constructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_constructor_get_binding (c);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp8_;
			ValaConstructor* _tmp9_;
			_tmp8_ = vala_class_get_class_constructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			ValaConstructor* _tmp12_;
			ValaConstructor* _tmp13_;
			_tmp12_ = vala_class_get_static_constructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp2_;
		ValaDestructor* _tmp3_;
		_tmp2_ = vala_class_get_destructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_destructor_get_binding (d);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp8_;
			ValaDestructor* _tmp9_;
			_tmp8_ = vala_class_get_class_destructor (self);
			_tmp9_ = _tmp8_;
			if (_tmp9_ != NULL) {
				ValaSourceReference* _tmp10_;
				ValaSourceReference* _tmp11_;
				_tmp10_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp11_ = _tmp10_;
				vala_report_error (_tmp11_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			ValaDestructor* _tmp12_;
			ValaDestructor* _tmp13_;
			_tmp12_ = vala_class_get_static_destructor (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				ValaSourceReference* _tmp14_;
				ValaSourceReference* _tmp15_;
				_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp15_ = _tmp14_;
				vala_report_error (_tmp15_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp89_;
	ValaConstructor* _tmp90_;
	ValaConstructor* _tmp93_;
	ValaConstructor* _tmp94_;
	ValaConstructor* _tmp97_;
	ValaConstructor* _tmp98_;
	ValaDestructor* _tmp101_;
	ValaDestructor* _tmp102_;
	ValaDestructor* _tmp105_;
	ValaDestructor* _tmp106_;
	ValaDestructor* _tmp109_;
	ValaDestructor* _tmp110_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp34_;
		gint _f_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _f_index = 0;
		_tmp34_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp34_;
		_tmp35_ = _f_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_f_size = _tmp37_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaField* f = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaField* _tmp44_;
			_tmp38_ = _f_index;
			_f_index = _tmp38_ + 1;
			_tmp39_ = _f_index;
			_tmp40_ = _f_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _f_list;
			_tmp42_ = _f_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			f = (ValaField*) _tmp43_;
			_tmp44_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp45_;
		gint _c_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _c_index = 0;
		_tmp45_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp45_;
		_tmp46_ = _c_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_c_size = _tmp48_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaConstant* c = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaConstant* _tmp55_;
			_tmp49_ = _c_index;
			_c_index = _tmp49_ + 1;
			_tmp50_ = _c_index;
			_tmp51_ = _c_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _c_list;
			_tmp53_ = _c_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			c = (ValaConstant*) _tmp54_;
			_tmp55_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp56_;
		gint _m_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _m_index = 0;
		_tmp56_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp56_;
		_tmp57_ = _m_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_m_size = _tmp59_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaMethod* m = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaMethod* _tmp66_;
			_tmp60_ = _m_index;
			_m_index = _tmp60_ + 1;
			_tmp61_ = _m_index;
			_tmp62_ = _m_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _m_list;
			_tmp64_ = _m_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			m = (ValaMethod*) _tmp65_;
			_tmp66_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp89_ = vala_class_get_constructor (self);
	_tmp90_ = _tmp89_;
	if (_tmp90_ != NULL) {
		ValaConstructor* _tmp91_;
		ValaConstructor* _tmp92_;
		_tmp91_ = vala_class_get_constructor (self);
		_tmp92_ = _tmp91_;
		vala_code_node_accept ((ValaCodeNode*) _tmp92_, visitor);
	}
	_tmp93_ = vala_class_get_class_constructor (self);
	_tmp94_ = _tmp93_;
	if (_tmp94_ != NULL) {
		ValaConstructor* _tmp95_;
		ValaConstructor* _tmp96_;
		_tmp95_ = vala_class_get_class_constructor (self);
		_tmp96_ = _tmp95_;
		vala_code_node_accept ((ValaCodeNode*) _tmp96_, visitor);
	}
	_tmp97_ = vala_class_get_static_constructor (self);
	_tmp98_ = _tmp97_;
	if (_tmp98_ != NULL) {
		ValaConstructor* _tmp99_;
		ValaConstructor* _tmp100_;
		_tmp99_ = vala_class_get_static_constructor (self);
		_tmp100_ = _tmp99_;
		vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
	}
	_tmp101_ = vala_class_get_destructor (self);
	_tmp102_ = _tmp101_;
	if (_tmp102_ != NULL) {
		ValaDestructor* _tmp103_;
		ValaDestructor* _tmp104_;
		_tmp103_ = vala_class_get_destructor (self);
		_tmp104_ = _tmp103_;
		vala_code_node_accept ((ValaCodeNode*) _tmp104_, visitor);
	}
	_tmp105_ = vala_class_get_static_destructor (self);
	_tmp106_ = _tmp105_;
	if (_tmp106_ != NULL) {
		ValaDestructor* _tmp107_;
		ValaDestructor* _tmp108_;
		_tmp107_ = vala_class_get_static_destructor (self);
		_tmp108_ = _tmp107_;
		vala_code_node_accept ((ValaCodeNode*) _tmp108_, visitor);
	}
	_tmp109_ = vala_class_get_class_destructor (self);
	_tmp110_ = _tmp109_;
	if (_tmp110_ != NULL) {
		ValaDestructor* _tmp111_;
		ValaDestructor* _tmp112_;
		_tmp111_ = vala_class_get_class_destructor (self);
		_tmp112_ = _tmp111_;
		vala_code_node_accept ((ValaCodeNode*) _tmp112_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp113_;
		gint _cl_size = 0;
		ValaList* _tmp114_;
		gint _tmp115_;
		gint _tmp116_;
		gint _cl_index = 0;
		_tmp113_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp113_;
		_tmp114_ = _cl_list;
		_tmp115_ = vala_collection_get_size ((ValaCollection*) _tmp114_);
		_tmp116_ = _tmp115_;
		_cl_size = _tmp116_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp117_;
			gint _tmp118_;
			gint _tmp119_;
			ValaClass* cl = NULL;
			ValaList* _tmp120_;
			gint _tmp121_;
			gpointer _tmp122_;
			ValaClass* _tmp123_;
			_tmp117_ = _cl_index;
			_cl_index = _tmp117_ + 1;
			_tmp118_ = _cl_index;
			_tmp119_ = _cl_size;
			if (!(_tmp118_ < _tmp119_)) {
				break;
			}
			_tmp120_ = _cl_list;
			_tmp121_ = _cl_index;
			_tmp122_ = vala_list_get (_tmp120_, _tmp121_);
			cl = (ValaClass*) _tmp122_;
			_tmp123_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp123_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp124_;
		gint _st_size = 0;
		ValaList* _tmp125_;
		gint _tmp126_;
		gint _tmp127_;
		gint _st_index = 0;
		_tmp124_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp124_;
		_tmp125_ = _st_list;
		_tmp126_ = vala_collection_get_size ((ValaCollection*) _tmp125_);
		_tmp127_ = _tmp126_;
		_st_size = _tmp127_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp128_;
			gint _tmp129_;
			gint _tmp130_;
			ValaStruct* st = NULL;
			ValaList* _tmp131_;
			gint _tmp132_;
			gpointer _tmp133_;
			ValaStruct* _tmp134_;
			_tmp128_ = _st_index;
			_st_index = _tmp128_ + 1;
			_tmp129_ = _st_index;
			_tmp130_ = _st_size;
			if (!(_tmp129_ < _tmp130_)) {
				break;
			}
			_tmp131_ = _st_list;
			_tmp132_ = _st_index;
			_tmp133_ = vala_list_get (_tmp131_, _tmp132_);
			st = (ValaStruct*) _tmp133_;
			_tmp134_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp134_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp135_;
		gint _d_size = 0;
		ValaList* _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		gint _d_index = 0;
		_tmp135_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp135_;
		_tmp136_ = _d_list;
		_tmp137_ = vala_collection_get_size ((ValaCollection*) _tmp136_);
		_tmp138_ = _tmp137_;
		_d_size = _tmp138_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp139_;
			gint _tmp140_;
			gint _tmp141_;
			ValaDelegate* d = NULL;
			ValaList* _tmp142_;
			gint _tmp143_;
			gpointer _tmp144_;
			ValaDelegate* _tmp145_;
			_tmp139_ = _d_index;
			_d_index = _tmp139_ + 1;
			_tmp140_ = _d_index;
			_tmp141_ = _d_size;
			if (!(_tmp140_ < _tmp141_)) {
				break;
			}
			_tmp142_ = _d_list;
			_tmp143_ = _d_index;
			_tmp144_ = vala_list_get (_tmp142_, _tmp143_);
			d = (ValaDelegate*) _tmp144_;
			_tmp145_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp145_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _base_type_index;
			_base_type_index = _tmp5_ + 1;
			_tmp6_ = _base_type_index;
			_tmp7_ = _base_type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _base_type_list;
			_tmp9_ = _base_type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			base_type = (ValaDataType*) _tmp10_;
			_tmp12_ = base_type;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->base_types;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			_tmp4_ = _prereq_index;
			_prereq_index = _tmp4_ + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = _prereq_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prereq = (ValaDataType*) _tmp9_;
			_tmp10_ = prereq;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			type = _tmp13_;
			_tmp14_ = type;
			if (_tmp14_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp15_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp15_);
			_tmp16_ = type;
			if (VALA_IS_INTERFACE (_tmp16_)) {
				ValaTypeSymbol* _tmp17_;
				_tmp17_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


gboolean
vala_class_is_a (ValaClass* self,
                 ValaObjectTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (VALA_IS_CLASS (_tmp12_)) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_data_type (_tmp13_);
				_tmp15_ = _tmp14_;
				if (vala_class_is_a (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ == G_TYPE_CHECK_INSTANCE_CAST (t, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


gboolean
vala_class_implements (ValaClass* self,
                       ValaInterface* i)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (i != NULL, FALSE);
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (self);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ == G_TYPE_CHECK_INSTANCE_CAST (i, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol)) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaConstructor* _tmp201_;
	ValaConstructor* _tmp202_;
	ValaConstructor* _tmp205_;
	ValaConstructor* _tmp206_;
	ValaConstructor* _tmp209_;
	ValaConstructor* _tmp210_;
	ValaDestructor* _tmp213_;
	ValaDestructor* _tmp214_;
	ValaDestructor* _tmp217_;
	ValaDestructor* _tmp218_;
	ValaDestructor* _tmp221_;
	ValaDestructor* _tmp222_;
	gboolean _tmp258_;
	gboolean _tmp259_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp306_;
	ValaArrayList* _tmp307_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp325_;
	ValaArrayList* _tmp326_;
	ValaList* _tmp343_;
	gint _tmp344_;
	gint _tmp345_;
	ValaSourceFileType _tmp373_;
	ValaSourceFileType _tmp374_;
	ValaSemanticAnalyzer* _tmp600_;
	ValaSemanticAnalyzer* _tmp601_;
	ValaSourceFile* _tmp602_;
	ValaSemanticAnalyzer* _tmp603_;
	ValaSemanticAnalyzer* _tmp604_;
	ValaSymbol* _tmp605_;
	gboolean _tmp606_;
	gboolean _tmp607_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaDataType* _tmp34_;
			ValaDataType* _tmp35_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaDataType* _tmp47_;
			gint n_type_args = 0;
			ValaDataType* _tmp57_;
			ValaList* _tmp58_;
			ValaList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint n_type_params = 0;
			ValaDataType* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp28_ = _base_type_reference_index;
			_base_type_reference_index = _tmp28_ + 1;
			_tmp29_ = _base_type_reference_index;
			_tmp30_ = _base_type_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _base_type_reference_list;
			_tmp32_ = _base_type_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			base_type_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp34_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp35_ = base_type_reference;
			if (!VALA_IS_OBJECT_TYPE (_tmp35_)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = base_type_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp45_ = vala_code_context_get_analyzer (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp46_, (ValaSymbol*) self, _tmp47_)) {
				ValaSourceReference* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaDataType* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = base_type_reference;
				_tmp51_ = vala_code_node_to_string ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp52_, _tmp54_);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp49_, _tmp56_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp52_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = base_type_reference;
			_tmp58_ = vala_data_type_get_type_arguments (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_;
			_vala_iterable_unref0 (_tmp59_);
			n_type_args = _tmp62_;
			_tmp63_ = base_type_reference;
			_tmp64_ = vala_data_type_get_data_type (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_vala_iterable_unref0 (_tmp67_);
			n_type_params = _tmp70_;
			_tmp71_ = n_type_args;
			_tmp72_ = n_type_params;
			if (_tmp71_ < _tmp72_) {
				ValaDataType* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = base_type_reference;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp76_;
				gint _tmp77_;
				_tmp76_ = n_type_args;
				_tmp77_ = n_type_params;
				if (_tmp76_ > _tmp77_) {
					ValaDataType* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp78_ = base_type_reference;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
					_tmp80_ = _tmp79_;
					vala_report_error (_tmp80_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp81_;
		ValaList* _tmp82_;
		gint _type_size = 0;
		ValaList* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gint _type_index = 0;
		_tmp81_ = self->priv->base_types;
		_tmp82_ = _vala_iterable_ref0 (_tmp81_);
		_type_list = _tmp82_;
		_tmp83_ = _type_list;
		_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
		_tmp85_ = _tmp84_;
		_type_size = _tmp85_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			ValaDataType* type = NULL;
			ValaList* _tmp89_;
			gint _tmp90_;
			gpointer _tmp91_;
			ValaDataType* _tmp92_;
			_tmp86_ = _type_index;
			_type_index = _tmp86_ + 1;
			_tmp87_ = _type_index;
			_tmp88_ = _type_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _type_list;
			_tmp90_ = _type_index;
			_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
			type = (ValaDataType*) _tmp91_;
			_tmp92_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp93_;
		gint _p_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _p_index = 0;
		_tmp93_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp93_;
		_tmp94_ = _p_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_p_size = _tmp96_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			ValaTypeParameter* _tmp103_;
			_tmp97_ = _p_index;
			_p_index = _tmp97_ + 1;
			_tmp98_ = _p_index;
			_tmp99_ = _p_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _p_list;
			_tmp101_ = _p_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			p = (ValaTypeParameter*) _tmp102_;
			_tmp103_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp103_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp104_;
		gint _en_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _en_index = 0;
		_tmp104_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp104_;
		_tmp105_ = _en_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_en_size = _tmp107_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaEnum* en = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaEnum* _tmp114_;
			_tmp108_ = _en_index;
			_en_index = _tmp108_ + 1;
			_tmp109_ = _en_index;
			_tmp110_ = _en_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _en_list;
			_tmp112_ = _en_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			en = (ValaEnum*) _tmp113_;
			_tmp114_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp115_;
		gint _f_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _f_index = 0;
		_tmp115_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp115_;
		_tmp116_ = _f_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_f_size = _tmp118_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaField* f = NULL;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_;
			gboolean _tmp125_ = FALSE;
			gboolean _tmp126_;
			gboolean _tmp127_;
			ValaField* _tmp145_;
			_tmp119_ = _f_index;
			_f_index = _tmp119_ + 1;
			_tmp120_ = _f_index;
			_tmp121_ = _f_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _f_list;
			_tmp123_ = _f_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			f = (ValaField*) _tmp124_;
			_tmp126_ = vala_class_get_is_compact (self);
			_tmp127_ = _tmp126_;
			if (_tmp127_) {
				ValaField* _tmp128_;
				ValaMemberBinding _tmp129_;
				ValaMemberBinding _tmp130_;
				_tmp128_ = f;
				_tmp129_ = vala_field_get_binding (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp125_ = _tmp130_ != VALA_MEMBER_BINDING_STATIC;
			} else {
				_tmp125_ = FALSE;
			}
			if (_tmp125_) {
				gboolean _tmp131_ = FALSE;
				gboolean _tmp132_;
				gboolean _tmp133_;
				ValaField* _tmp139_;
				ValaMemberBinding _tmp140_;
				ValaMemberBinding _tmp141_;
				_tmp132_ = vala_symbol_get_external_package ((ValaSymbol*) self);
				_tmp133_ = _tmp132_;
				if (!_tmp133_) {
					ValaField* _tmp134_;
					ValaSymbolAccessibility _tmp135_;
					ValaSymbolAccessibility _tmp136_;
					_tmp134_ = f;
					_tmp135_ = vala_symbol_get_access ((ValaSymbol*) _tmp134_);
					_tmp136_ = _tmp135_;
					_tmp131_ = _tmp136_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE;
				} else {
					_tmp131_ = FALSE;
				}
				if (_tmp131_) {
					ValaSourceReference* _tmp137_;
					ValaSourceReference* _tmp138_;
					_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp138_ = _tmp137_;
					vala_report_error (_tmp138_, "private fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp139_ = f;
				_tmp140_ = vala_field_get_binding (_tmp139_);
				_tmp141_ = _tmp140_;
				if (_tmp141_ == VALA_MEMBER_BINDING_CLASS) {
					ValaField* _tmp142_;
					ValaSourceReference* _tmp143_;
					ValaSourceReference* _tmp144_;
					_tmp142_ = f;
					_tmp143_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp142_);
					_tmp144_ = _tmp143_;
					vala_report_error (_tmp144_, "class fields are not supported in compact classes");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
			_tmp145_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp145_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp146_;
		gint _c_size = 0;
		ValaList* _tmp147_;
		gint _tmp148_;
		gint _tmp149_;
		gint _c_index = 0;
		_tmp146_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp146_;
		_tmp147_ = _c_list;
		_tmp148_ = vala_collection_get_size ((ValaCollection*) _tmp147_);
		_tmp149_ = _tmp148_;
		_c_size = _tmp149_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp150_;
			gint _tmp151_;
			gint _tmp152_;
			ValaConstant* c = NULL;
			ValaList* _tmp153_;
			gint _tmp154_;
			gpointer _tmp155_;
			ValaConstant* _tmp156_;
			_tmp150_ = _c_index;
			_c_index = _tmp150_ + 1;
			_tmp151_ = _c_index;
			_tmp152_ = _c_size;
			if (!(_tmp151_ < _tmp152_)) {
				break;
			}
			_tmp153_ = _c_list;
			_tmp154_ = _c_index;
			_tmp155_ = vala_list_get (_tmp153_, _tmp154_);
			c = (ValaConstant*) _tmp155_;
			_tmp156_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp156_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp157_;
		gint _m_size = 0;
		ValaList* _tmp158_;
		gint _tmp159_;
		gint _tmp160_;
		gint _m_index = 0;
		_tmp157_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp157_;
		_tmp158_ = _m_list;
		_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
		_tmp160_ = _tmp159_;
		_m_size = _tmp160_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp161_;
			gint _tmp162_;
			gint _tmp163_;
			ValaMethod* m = NULL;
			ValaList* _tmp164_;
			gint _tmp165_;
			gpointer _tmp166_;
			ValaMethod* _tmp167_;
			_tmp161_ = _m_index;
			_m_index = _tmp161_ + 1;
			_tmp162_ = _m_index;
			_tmp163_ = _m_size;
			if (!(_tmp162_ < _tmp163_)) {
				break;
			}
			_tmp164_ = _m_list;
			_tmp165_ = _m_index;
			_tmp166_ = vala_list_get (_tmp164_, _tmp165_);
			m = (ValaMethod*) _tmp166_;
			_tmp167_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp167_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp168_;
		gint _prop_size = 0;
		ValaList* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
		gint _prop_index = 0;
		_tmp168_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp168_;
		_tmp169_ = _prop_list;
		_tmp170_ = vala_collection_get_size ((ValaCollection*) _tmp169_);
		_tmp171_ = _tmp170_;
		_prop_size = _tmp171_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp172_;
			gint _tmp173_;
			gint _tmp174_;
			ValaProperty* prop = NULL;
			ValaList* _tmp175_;
			gint _tmp176_;
			gpointer _tmp177_;
			gboolean _tmp178_ = FALSE;
			ValaProperty* _tmp179_;
			ValaAttribute* _tmp180_;
			ValaAttribute* _tmp181_;
			gboolean _tmp182_;
			ValaProperty* _tmp189_;
			_tmp172_ = _prop_index;
			_prop_index = _tmp172_ + 1;
			_tmp173_ = _prop_index;
			_tmp174_ = _prop_size;
			if (!(_tmp173_ < _tmp174_)) {
				break;
			}
			_tmp175_ = _prop_list;
			_tmp176_ = _prop_index;
			_tmp177_ = vala_list_get (_tmp175_, _tmp176_);
			prop = (ValaProperty*) _tmp177_;
			_tmp179_ = prop;
			_tmp180_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp179_, "NoAccessorMethod");
			_tmp181_ = _tmp180_;
			_tmp182_ = _tmp181_ != NULL;
			_vala_code_node_unref0 (_tmp181_);
			if (_tmp182_) {
				ValaSemanticAnalyzer* _tmp183_;
				ValaSemanticAnalyzer* _tmp184_;
				ValaClass* _tmp185_;
				_tmp183_ = vala_code_context_get_analyzer (context);
				_tmp184_ = _tmp183_;
				_tmp185_ = _tmp184_->object_type;
				_tmp178_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp185_);
			} else {
				_tmp178_ = FALSE;
			}
			if (_tmp178_) {
				ValaProperty* _tmp186_;
				ValaSourceReference* _tmp187_;
				ValaSourceReference* _tmp188_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp186_ = prop;
				_tmp187_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp186_);
				_tmp188_ = _tmp187_;
				vala_report_error (_tmp188_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp189_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp189_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp190_;
		gint _sig_size = 0;
		ValaList* _tmp191_;
		gint _tmp192_;
		gint _tmp193_;
		gint _sig_index = 0;
		_tmp190_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp190_;
		_tmp191_ = _sig_list;
		_tmp192_ = vala_collection_get_size ((ValaCollection*) _tmp191_);
		_tmp193_ = _tmp192_;
		_sig_size = _tmp193_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp194_;
			gint _tmp195_;
			gint _tmp196_;
			ValaSignal* sig = NULL;
			ValaList* _tmp197_;
			gint _tmp198_;
			gpointer _tmp199_;
			ValaSignal* _tmp200_;
			_tmp194_ = _sig_index;
			_sig_index = _tmp194_ + 1;
			_tmp195_ = _sig_index;
			_tmp196_ = _sig_size;
			if (!(_tmp195_ < _tmp196_)) {
				break;
			}
			_tmp197_ = _sig_list;
			_tmp198_ = _sig_index;
			_tmp199_ = vala_list_get (_tmp197_, _tmp198_);
			sig = (ValaSignal*) _tmp199_;
			_tmp200_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp200_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp201_ = vala_class_get_constructor (self);
	_tmp202_ = _tmp201_;
	if (_tmp202_ != NULL) {
		ValaConstructor* _tmp203_;
		ValaConstructor* _tmp204_;
		_tmp203_ = vala_class_get_constructor (self);
		_tmp204_ = _tmp203_;
		vala_code_node_check ((ValaCodeNode*) _tmp204_, context);
	}
	_tmp205_ = vala_class_get_class_constructor (self);
	_tmp206_ = _tmp205_;
	if (_tmp206_ != NULL) {
		ValaConstructor* _tmp207_;
		ValaConstructor* _tmp208_;
		_tmp207_ = vala_class_get_class_constructor (self);
		_tmp208_ = _tmp207_;
		vala_code_node_check ((ValaCodeNode*) _tmp208_, context);
	}
	_tmp209_ = vala_class_get_static_constructor (self);
	_tmp210_ = _tmp209_;
	if (_tmp210_ != NULL) {
		ValaConstructor* _tmp211_;
		ValaConstructor* _tmp212_;
		_tmp211_ = vala_class_get_static_constructor (self);
		_tmp212_ = _tmp211_;
		vala_code_node_check ((ValaCodeNode*) _tmp212_, context);
	}
	_tmp213_ = vala_class_get_destructor (self);
	_tmp214_ = _tmp213_;
	if (_tmp214_ != NULL) {
		ValaDestructor* _tmp215_;
		ValaDestructor* _tmp216_;
		_tmp215_ = vala_class_get_destructor (self);
		_tmp216_ = _tmp215_;
		vala_code_node_check ((ValaCodeNode*) _tmp216_, context);
	}
	_tmp217_ = vala_class_get_static_destructor (self);
	_tmp218_ = _tmp217_;
	if (_tmp218_ != NULL) {
		ValaDestructor* _tmp219_;
		ValaDestructor* _tmp220_;
		_tmp219_ = vala_class_get_static_destructor (self);
		_tmp220_ = _tmp219_;
		vala_code_node_check ((ValaCodeNode*) _tmp220_, context);
	}
	_tmp221_ = vala_class_get_class_destructor (self);
	_tmp222_ = _tmp221_;
	if (_tmp222_ != NULL) {
		ValaDestructor* _tmp223_;
		ValaDestructor* _tmp224_;
		_tmp223_ = vala_class_get_class_destructor (self);
		_tmp224_ = _tmp223_;
		vala_code_node_check ((ValaCodeNode*) _tmp224_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp225_;
		gint _cl_size = 0;
		ValaList* _tmp226_;
		gint _tmp227_;
		gint _tmp228_;
		gint _cl_index = 0;
		_tmp225_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp225_;
		_tmp226_ = _cl_list;
		_tmp227_ = vala_collection_get_size ((ValaCollection*) _tmp226_);
		_tmp228_ = _tmp227_;
		_cl_size = _tmp228_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp229_;
			gint _tmp230_;
			gint _tmp231_;
			ValaClass* cl = NULL;
			ValaList* _tmp232_;
			gint _tmp233_;
			gpointer _tmp234_;
			ValaClass* _tmp235_;
			_tmp229_ = _cl_index;
			_cl_index = _tmp229_ + 1;
			_tmp230_ = _cl_index;
			_tmp231_ = _cl_size;
			if (!(_tmp230_ < _tmp231_)) {
				break;
			}
			_tmp232_ = _cl_list;
			_tmp233_ = _cl_index;
			_tmp234_ = vala_list_get (_tmp232_, _tmp233_);
			cl = (ValaClass*) _tmp234_;
			_tmp235_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp235_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp236_;
		gint _st_size = 0;
		ValaList* _tmp237_;
		gint _tmp238_;
		gint _tmp239_;
		gint _st_index = 0;
		_tmp236_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp236_;
		_tmp237_ = _st_list;
		_tmp238_ = vala_collection_get_size ((ValaCollection*) _tmp237_);
		_tmp239_ = _tmp238_;
		_st_size = _tmp239_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp240_;
			gint _tmp241_;
			gint _tmp242_;
			ValaStruct* st = NULL;
			ValaList* _tmp243_;
			gint _tmp244_;
			gpointer _tmp245_;
			ValaStruct* _tmp246_;
			_tmp240_ = _st_index;
			_st_index = _tmp240_ + 1;
			_tmp241_ = _st_index;
			_tmp242_ = _st_size;
			if (!(_tmp241_ < _tmp242_)) {
				break;
			}
			_tmp243_ = _st_list;
			_tmp244_ = _st_index;
			_tmp245_ = vala_list_get (_tmp243_, _tmp244_);
			st = (ValaStruct*) _tmp245_;
			_tmp246_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp246_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp247_;
		gint _d_size = 0;
		ValaList* _tmp248_;
		gint _tmp249_;
		gint _tmp250_;
		gint _d_index = 0;
		_tmp247_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp247_;
		_tmp248_ = _d_list;
		_tmp249_ = vala_collection_get_size ((ValaCollection*) _tmp248_);
		_tmp250_ = _tmp249_;
		_d_size = _tmp250_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp251_;
			gint _tmp252_;
			gint _tmp253_;
			ValaDelegate* d = NULL;
			ValaList* _tmp254_;
			gint _tmp255_;
			gpointer _tmp256_;
			ValaDelegate* _tmp257_;
			_tmp251_ = _d_index;
			_d_index = _tmp251_ + 1;
			_tmp252_ = _d_index;
			_tmp253_ = _d_size;
			if (!(_tmp252_ < _tmp253_)) {
				break;
			}
			_tmp254_ = _d_list;
			_tmp255_ = _d_index;
			_tmp256_ = vala_list_get (_tmp254_, _tmp255_);
			d = (ValaDelegate*) _tmp256_;
			_tmp257_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp257_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp258_ = vala_class_get_is_compact (self);
	_tmp259_ = _tmp258_;
	if (_tmp259_) {
		gboolean _tmp279_ = FALSE;
		gboolean _tmp280_ = FALSE;
		gboolean _tmp281_ = FALSE;
		gboolean _tmp282_;
		gboolean _tmp283_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp260_;
			gint _base_type_size = 0;
			ValaList* _tmp261_;
			gint _tmp262_;
			gint _tmp263_;
			gint _base_type_index = 0;
			_tmp260_ = vala_class_get_base_types (self);
			_base_type_list = _tmp260_;
			_tmp261_ = _base_type_list;
			_tmp262_ = vala_collection_get_size ((ValaCollection*) _tmp261_);
			_tmp263_ = _tmp262_;
			_base_type_size = _tmp263_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp264_;
				gint _tmp265_;
				gint _tmp266_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp267_;
				gint _tmp268_;
				gpointer _tmp269_;
				ValaDataType* _tmp270_;
				ValaTypeSymbol* _tmp271_;
				ValaTypeSymbol* _tmp272_;
				_tmp264_ = _base_type_index;
				_base_type_index = _tmp264_ + 1;
				_tmp265_ = _base_type_index;
				_tmp266_ = _base_type_size;
				if (!(_tmp265_ < _tmp266_)) {
					break;
				}
				_tmp267_ = _base_type_list;
				_tmp268_ = _base_type_index;
				_tmp269_ = vala_list_get (_tmp267_, _tmp268_);
				base_type = (ValaDataType*) _tmp269_;
				_tmp270_ = base_type;
				_tmp271_ = vala_data_type_get_data_type (_tmp270_);
				_tmp272_ = _tmp271_;
				if (VALA_IS_INTERFACE (_tmp272_)) {
					ValaSourceReference* _tmp273_;
					ValaSourceReference* _tmp274_;
					gchar* _tmp275_;
					gchar* _tmp276_;
					gchar* _tmp277_;
					gchar* _tmp278_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp273_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp274_ = _tmp273_;
					_tmp275_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp276_ = _tmp275_;
					_tmp277_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp276_);
					_tmp278_ = _tmp277_;
					vala_report_error (_tmp274_, _tmp278_);
					_g_free0 (_tmp278_);
					_g_free0 (_tmp276_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp282_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp283_ = _tmp282_;
		if (!_tmp283_) {
			gboolean _tmp284_;
			gboolean _tmp285_;
			_tmp284_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp285_ = _tmp284_;
			_tmp281_ = !_tmp285_;
		} else {
			_tmp281_ = FALSE;
		}
		if (_tmp281_) {
			ValaClass* _tmp286_;
			_tmp286_ = self->priv->_base_class;
			_tmp280_ = _tmp286_ != NULL;
		} else {
			_tmp280_ = FALSE;
		}
		if (_tmp280_) {
			ValaClass* _tmp287_;
			ValaSemanticAnalyzer* _tmp288_;
			ValaSemanticAnalyzer* _tmp289_;
			ValaClass* _tmp290_;
			_tmp287_ = self->priv->_base_class;
			_tmp288_ = vala_code_context_get_analyzer (context);
			_tmp289_ = _tmp288_;
			_tmp290_ = _tmp289_->gsource_type;
			_tmp279_ = _tmp287_ != _tmp290_;
		} else {
			_tmp279_ = FALSE;
		}
		if (_tmp279_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp291_;
				gint _f_size = 0;
				ValaList* _tmp292_;
				gint _tmp293_;
				gint _tmp294_;
				gint _f_index = 0;
				_tmp291_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp291_;
				_tmp292_ = _f_list;
				_tmp293_ = vala_collection_get_size ((ValaCollection*) _tmp292_);
				_tmp294_ = _tmp293_;
				_f_size = _tmp294_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp295_;
					gint _tmp296_;
					gint _tmp297_;
					ValaField* f = NULL;
					ValaList* _tmp298_;
					gint _tmp299_;
					gpointer _tmp300_;
					ValaField* _tmp301_;
					ValaMemberBinding _tmp302_;
					ValaMemberBinding _tmp303_;
					_tmp295_ = _f_index;
					_f_index = _tmp295_ + 1;
					_tmp296_ = _f_index;
					_tmp297_ = _f_size;
					if (!(_tmp296_ < _tmp297_)) {
						break;
					}
					_tmp298_ = _f_list;
					_tmp299_ = _f_index;
					_tmp300_ = vala_list_get (_tmp298_, _tmp299_);
					f = (ValaField*) _tmp300_;
					_tmp301_ = f;
					_tmp302_ = vala_field_get_binding (_tmp301_);
					_tmp303_ = _tmp302_;
					if (_tmp303_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp304_;
						ValaSourceReference* _tmp305_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp304_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp305_ = _tmp304_;
						vala_report_error (_tmp305_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp306_ = g_direct_equal;
	_tmp307_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp306_);
	prerequisites = (ValaList*) _tmp307_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp308_;
		gint _base_type_size = 0;
		ValaList* _tmp309_;
		gint _tmp310_;
		gint _tmp311_;
		gint _base_type_index = 0;
		_tmp308_ = vala_class_get_base_types (self);
		_base_type_list = _tmp308_;
		_tmp309_ = _base_type_list;
		_tmp310_ = vala_collection_get_size ((ValaCollection*) _tmp309_);
		_tmp311_ = _tmp310_;
		_base_type_size = _tmp311_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp312_;
			gint _tmp313_;
			gint _tmp314_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp315_;
			gint _tmp316_;
			gpointer _tmp317_;
			ValaDataType* _tmp318_;
			ValaTypeSymbol* _tmp319_;
			ValaTypeSymbol* _tmp320_;
			_tmp312_ = _base_type_index;
			_base_type_index = _tmp312_ + 1;
			_tmp313_ = _base_type_index;
			_tmp314_ = _base_type_size;
			if (!(_tmp313_ < _tmp314_)) {
				break;
			}
			_tmp315_ = _base_type_list;
			_tmp316_ = _base_type_index;
			_tmp317_ = vala_list_get (_tmp315_, _tmp316_);
			base_type = (ValaDataType*) _tmp317_;
			_tmp318_ = base_type;
			_tmp319_ = vala_data_type_get_data_type (_tmp318_);
			_tmp320_ = _tmp319_;
			if (VALA_IS_INTERFACE (_tmp320_)) {
				ValaDataType* _tmp321_;
				ValaTypeSymbol* _tmp322_;
				ValaTypeSymbol* _tmp323_;
				ValaList* _tmp324_;
				_tmp321_ = base_type;
				_tmp322_ = vala_data_type_get_data_type (_tmp321_);
				_tmp323_ = _tmp322_;
				_tmp324_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp323_, VALA_TYPE_INTERFACE, ValaInterface), _tmp324_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp325_ = g_direct_equal;
	_tmp326_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp325_);
	missing_prereqs = (ValaList*) _tmp326_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp327_;
		ValaList* _tmp328_;
		gint _prereq_size = 0;
		ValaList* _tmp329_;
		gint _tmp330_;
		gint _tmp331_;
		gint _prereq_index = 0;
		_tmp327_ = prerequisites;
		_tmp328_ = _vala_iterable_ref0 (_tmp327_);
		_prereq_list = _tmp328_;
		_tmp329_ = _prereq_list;
		_tmp330_ = vala_collection_get_size ((ValaCollection*) _tmp329_);
		_tmp331_ = _tmp330_;
		_prereq_size = _tmp331_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp332_;
			gint _tmp333_;
			gint _tmp334_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp335_;
			gint _tmp336_;
			gpointer _tmp337_;
			ValaTypeSymbol* _tmp338_;
			_tmp332_ = _prereq_index;
			_prereq_index = _tmp332_ + 1;
			_tmp333_ = _prereq_index;
			_tmp334_ = _prereq_size;
			if (!(_tmp333_ < _tmp334_)) {
				break;
			}
			_tmp335_ = _prereq_list;
			_tmp336_ = _prereq_index;
			_tmp337_ = vala_list_get (_tmp335_, _tmp336_);
			prereq = (ValaTypeSymbol*) _tmp337_;
			_tmp338_ = prereq;
			if (!vala_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp338_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol))) {
				ValaList* _tmp339_;
				ValaTypeSymbol* _tmp340_;
				gchar* _tmp341_;
				gchar* _tmp342_;
				_tmp339_ = missing_prereqs;
				_tmp340_ = prereq;
				_tmp341_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp340_);
				_tmp342_ = _tmp341_;
				vala_list_insert (_tmp339_, 0, _tmp342_);
				_g_free0 (_tmp342_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp343_ = missing_prereqs;
	_tmp344_ = vala_collection_get_size ((ValaCollection*) _tmp343_);
	_tmp345_ = _tmp344_;
	if (_tmp345_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp346_;
		gchar* _tmp347_;
		gchar* _tmp348_;
		gchar* _tmp349_;
		gboolean first = FALSE;
		const gchar* _tmp368_;
		gchar* _tmp369_;
		ValaSourceReference* _tmp370_;
		ValaSourceReference* _tmp371_;
		const gchar* _tmp372_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp346_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp347_ = _tmp346_;
		_tmp348_ = g_strdup_printf ("%s: some prerequisites (", _tmp347_);
		_tmp349_ = _tmp348_;
		_g_free0 (_tmp347_);
		error_string = _tmp349_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp350_;
			ValaList* _tmp351_;
			gint _s_size = 0;
			ValaList* _tmp352_;
			gint _tmp353_;
			gint _tmp354_;
			gint _s_index = 0;
			_tmp350_ = missing_prereqs;
			_tmp351_ = _vala_iterable_ref0 (_tmp350_);
			_s_list = _tmp351_;
			_tmp352_ = _s_list;
			_tmp353_ = vala_collection_get_size ((ValaCollection*) _tmp352_);
			_tmp354_ = _tmp353_;
			_s_size = _tmp354_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp355_;
				gint _tmp356_;
				gint _tmp357_;
				gchar* s = NULL;
				ValaList* _tmp358_;
				gint _tmp359_;
				gpointer _tmp360_;
				gboolean _tmp361_;
				_tmp355_ = _s_index;
				_s_index = _tmp355_ + 1;
				_tmp356_ = _s_index;
				_tmp357_ = _s_size;
				if (!(_tmp356_ < _tmp357_)) {
					break;
				}
				_tmp358_ = _s_list;
				_tmp359_ = _s_index;
				_tmp360_ = vala_list_get (_tmp358_, _tmp359_);
				s = (gchar*) _tmp360_;
				_tmp361_ = first;
				if (_tmp361_) {
					const gchar* _tmp362_;
					const gchar* _tmp363_;
					gchar* _tmp364_;
					_tmp362_ = error_string;
					_tmp363_ = s;
					_tmp364_ = g_strdup_printf ("%s`%s'", _tmp362_, _tmp363_);
					_g_free0 (error_string);
					error_string = _tmp364_;
					first = FALSE;
				} else {
					const gchar* _tmp365_;
					const gchar* _tmp366_;
					gchar* _tmp367_;
					_tmp365_ = error_string;
					_tmp366_ = s;
					_tmp367_ = g_strdup_printf ("%s, `%s'", _tmp365_, _tmp366_);
					_g_free0 (error_string);
					error_string = _tmp367_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp368_ = error_string;
		_tmp369_ = g_strconcat (_tmp368_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp369_;
		_tmp370_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp371_ = _tmp370_;
		_tmp372_ = error_string;
		vala_report_error (_tmp371_, _tmp372_);
		_g_free0 (error_string);
	}
	_tmp373_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp374_ = _tmp373_;
	if (_tmp374_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp524_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp375_;
			gint _base_type_size = 0;
			ValaList* _tmp376_;
			gint _tmp377_;
			gint _tmp378_;
			gint _base_type_index = 0;
			_tmp375_ = vala_class_get_base_types (self);
			_base_type_list = _tmp375_;
			_tmp376_ = _base_type_list;
			_tmp377_ = vala_collection_get_size ((ValaCollection*) _tmp376_);
			_tmp378_ = _tmp377_;
			_base_type_size = _tmp378_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp379_;
				gint _tmp380_;
				gint _tmp381_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp382_;
				gint _tmp383_;
				gpointer _tmp384_;
				ValaDataType* _tmp385_;
				ValaTypeSymbol* _tmp386_;
				ValaTypeSymbol* _tmp387_;
				_tmp379_ = _base_type_index;
				_base_type_index = _tmp379_ + 1;
				_tmp380_ = _base_type_index;
				_tmp381_ = _base_type_size;
				if (!(_tmp380_ < _tmp381_)) {
					break;
				}
				_tmp382_ = _base_type_list;
				_tmp383_ = _base_type_index;
				_tmp384_ = vala_list_get (_tmp382_, _tmp383_);
				base_type = (ValaDataType*) _tmp384_;
				_tmp385_ = base_type;
				_tmp386_ = vala_data_type_get_data_type (_tmp385_);
				_tmp387_ = _tmp386_;
				if (VALA_IS_INTERFACE (_tmp387_)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp388_;
					ValaTypeSymbol* _tmp389_;
					ValaTypeSymbol* _tmp390_;
					ValaInterface* _tmp391_;
					gboolean _tmp392_ = FALSE;
					ValaClass* _tmp393_;
					_tmp388_ = base_type;
					_tmp389_ = vala_data_type_get_data_type (_tmp388_);
					_tmp390_ = _tmp389_;
					_tmp391_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp390_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp391_;
					_tmp393_ = self->priv->_base_class;
					if (_tmp393_ != NULL) {
						ValaClass* _tmp394_;
						ValaInterface* _tmp395_;
						_tmp394_ = self->priv->_base_class;
						_tmp395_ = iface;
						_tmp392_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp394_, (ValaTypeSymbol*) _tmp395_);
					} else {
						_tmp392_ = FALSE;
					}
					if (_tmp392_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp396_;
						ValaList* _tmp397_;
						gint _m_size = 0;
						ValaList* _tmp398_;
						gint _tmp399_;
						gint _tmp400_;
						gint _m_index = 0;
						_tmp396_ = iface;
						_tmp397_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp396_);
						_m_list = _tmp397_;
						_tmp398_ = _m_list;
						_tmp399_ = vala_collection_get_size ((ValaCollection*) _tmp398_);
						_tmp400_ = _tmp399_;
						_m_size = _tmp400_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp401_;
							gint _tmp402_;
							gint _tmp403_;
							ValaMethod* m = NULL;
							ValaList* _tmp404_;
							gint _tmp405_;
							gpointer _tmp406_;
							ValaMethod* _tmp407_;
							gboolean _tmp408_;
							gboolean _tmp409_;
							_tmp401_ = _m_index;
							_m_index = _tmp401_ + 1;
							_tmp402_ = _m_index;
							_tmp403_ = _m_size;
							if (!(_tmp402_ < _tmp403_)) {
								break;
							}
							_tmp404_ = _m_list;
							_tmp405_ = _m_index;
							_tmp406_ = vala_list_get (_tmp404_, _tmp405_);
							m = (ValaMethod*) _tmp406_;
							_tmp407_ = m;
							_tmp408_ = vala_method_get_is_abstract (_tmp407_);
							_tmp409_ = _tmp408_;
							if (_tmp409_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp410_;
								gboolean _tmp449_;
								implemented = FALSE;
								_tmp410_ = _vala_code_node_ref0 (self);
								base_class = _tmp410_;
								while (TRUE) {
									ValaClass* _tmp411_;
									ValaClass* _tmp446_;
									ValaClass* _tmp447_;
									ValaClass* _tmp448_;
									_tmp411_ = base_class;
									if (!(_tmp411_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp412_;
										ValaList* _tmp413_;
										gint _impl_size = 0;
										ValaList* _tmp414_;
										gint _tmp415_;
										gint _tmp416_;
										gint _impl_index = 0;
										_tmp412_ = base_class;
										_tmp413_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp412_);
										_impl_list = _tmp413_;
										_tmp414_ = _impl_list;
										_tmp415_ = vala_collection_get_size ((ValaCollection*) _tmp414_);
										_tmp416_ = _tmp415_;
										_impl_size = _tmp416_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp417_;
											gint _tmp418_;
											gint _tmp419_;
											ValaMethod* impl = NULL;
											ValaList* _tmp420_;
											gint _tmp421_;
											gpointer _tmp422_;
											gboolean _tmp423_ = FALSE;
											ValaMethod* _tmp424_;
											const gchar* _tmp425_;
											const gchar* _tmp426_;
											ValaMethod* _tmp427_;
											const gchar* _tmp428_;
											const gchar* _tmp429_;
											_tmp417_ = _impl_index;
											_impl_index = _tmp417_ + 1;
											_tmp418_ = _impl_index;
											_tmp419_ = _impl_size;
											if (!(_tmp418_ < _tmp419_)) {
												break;
											}
											_tmp420_ = _impl_list;
											_tmp421_ = _impl_index;
											_tmp422_ = vala_list_get (_tmp420_, _tmp421_);
											impl = (ValaMethod*) _tmp422_;
											_tmp424_ = impl;
											_tmp425_ = vala_symbol_get_name ((ValaSymbol*) _tmp424_);
											_tmp426_ = _tmp425_;
											_tmp427_ = m;
											_tmp428_ = vala_symbol_get_name ((ValaSymbol*) _tmp427_);
											_tmp429_ = _tmp428_;
											if (g_strcmp0 (_tmp426_, _tmp429_) == 0) {
												gboolean _tmp430_ = FALSE;
												ValaMethod* _tmp431_;
												ValaDataType* _tmp432_;
												ValaDataType* _tmp433_;
												_tmp431_ = impl;
												_tmp432_ = vala_method_get_base_interface_type (_tmp431_);
												_tmp433_ = _tmp432_;
												if (_tmp433_ == NULL) {
													_tmp430_ = TRUE;
												} else {
													ValaMethod* _tmp434_;
													ValaDataType* _tmp435_;
													ValaDataType* _tmp436_;
													ValaTypeSymbol* _tmp437_;
													ValaTypeSymbol* _tmp438_;
													ValaInterface* _tmp439_;
													_tmp434_ = impl;
													_tmp435_ = vala_method_get_base_interface_type (_tmp434_);
													_tmp436_ = _tmp435_;
													_tmp437_ = vala_data_type_get_data_type (_tmp436_);
													_tmp438_ = _tmp437_;
													_tmp439_ = iface;
													_tmp430_ = _tmp438_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp439_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp423_ = _tmp430_;
											} else {
												_tmp423_ = FALSE;
											}
											if (_tmp423_) {
												ValaMethod* _tmp440_;
												ValaVersionAttribute* _tmp441_;
												ValaVersionAttribute* _tmp442_;
												ValaSourceReference* _tmp443_;
												ValaSourceReference* _tmp444_;
												ValaMethod* _tmp445_;
												_tmp440_ = impl;
												_tmp441_ = vala_symbol_get_version ((ValaSymbol*) _tmp440_);
												_tmp442_ = _tmp441_;
												_tmp443_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp444_ = _tmp443_;
												vala_version_attribute_check (_tmp442_, _tmp444_);
												_tmp445_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp445_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp446_ = base_class;
									_tmp447_ = _tmp446_->priv->_base_class;
									_tmp448_ = _vala_code_node_ref0 (_tmp447_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp448_;
								}
								_tmp449_ = implemented;
								if (!_tmp449_) {
									ValaSourceReference* _tmp450_;
									ValaSourceReference* _tmp451_;
									gchar* _tmp452_;
									gchar* _tmp453_;
									ValaMethod* _tmp454_;
									gchar* _tmp455_;
									gchar* _tmp456_;
									gchar* _tmp457_;
									gchar* _tmp458_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp450_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp451_ = _tmp450_;
									_tmp452_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp453_ = _tmp452_;
									_tmp454_ = m;
									_tmp455_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp454_);
									_tmp456_ = _tmp455_;
									_tmp457_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp453_, _tmp456_);
									_tmp458_ = _tmp457_;
									vala_report_error (_tmp451_, _tmp458_);
									_g_free0 (_tmp458_);
									_g_free0 (_tmp456_);
									_g_free0 (_tmp453_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp459_;
						ValaList* _tmp460_;
						gint _prop_size = 0;
						ValaList* _tmp461_;
						gint _tmp462_;
						gint _tmp463_;
						gint _prop_index = 0;
						_tmp459_ = iface;
						_tmp460_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp459_);
						_prop_list = _tmp460_;
						_tmp461_ = _prop_list;
						_tmp462_ = vala_collection_get_size ((ValaCollection*) _tmp461_);
						_tmp463_ = _tmp462_;
						_prop_size = _tmp463_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp464_;
							gint _tmp465_;
							gint _tmp466_;
							ValaProperty* prop = NULL;
							ValaList* _tmp467_;
							gint _tmp468_;
							gpointer _tmp469_;
							ValaProperty* _tmp470_;
							gboolean _tmp471_;
							gboolean _tmp472_;
							_tmp464_ = _prop_index;
							_prop_index = _tmp464_ + 1;
							_tmp465_ = _prop_index;
							_tmp466_ = _prop_size;
							if (!(_tmp465_ < _tmp466_)) {
								break;
							}
							_tmp467_ = _prop_list;
							_tmp468_ = _prop_index;
							_tmp469_ = vala_list_get (_tmp467_, _tmp468_);
							prop = (ValaProperty*) _tmp469_;
							_tmp470_ = prop;
							_tmp471_ = vala_property_get_is_abstract (_tmp470_);
							_tmp472_ = _tmp471_;
							if (_tmp472_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp473_;
								ValaSymbol* _tmp487_;
								sym = NULL;
								_tmp473_ = _vala_code_node_ref0 (self);
								base_class = _tmp473_;
								while (TRUE) {
									gboolean _tmp474_ = FALSE;
									ValaClass* _tmp475_;
									ValaClass* _tmp477_;
									ValaScope* _tmp478_;
									ValaScope* _tmp479_;
									ValaProperty* _tmp480_;
									const gchar* _tmp481_;
									const gchar* _tmp482_;
									ValaSymbol* _tmp483_;
									ValaClass* _tmp484_;
									ValaClass* _tmp485_;
									ValaClass* _tmp486_;
									_tmp475_ = base_class;
									if (_tmp475_ != NULL) {
										ValaSymbol* _tmp476_;
										_tmp476_ = sym;
										_tmp474_ = !VALA_IS_PROPERTY (_tmp476_);
									} else {
										_tmp474_ = FALSE;
									}
									if (!_tmp474_) {
										break;
									}
									_tmp477_ = base_class;
									_tmp478_ = vala_symbol_get_scope ((ValaSymbol*) _tmp477_);
									_tmp479_ = _tmp478_;
									_tmp480_ = prop;
									_tmp481_ = vala_symbol_get_name ((ValaSymbol*) _tmp480_);
									_tmp482_ = _tmp481_;
									_tmp483_ = vala_scope_lookup (_tmp479_, _tmp482_);
									_vala_code_node_unref0 (sym);
									sym = _tmp483_;
									_tmp484_ = base_class;
									_tmp485_ = _tmp484_->priv->_base_class;
									_tmp486_ = _vala_code_node_ref0 (_tmp485_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp486_;
								}
								_tmp487_ = sym;
								if (VALA_IS_PROPERTY (_tmp487_)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp488_;
									ValaProperty* _tmp489_;
									gchar* invalid_match = NULL;
									gboolean _tmp490_ = FALSE;
									ValaProperty* _tmp491_;
									gboolean _tmp492_;
									gboolean _tmp493_;
									ValaSymbol* _tmp509_;
									ValaVersionAttribute* _tmp510_;
									ValaVersionAttribute* _tmp511_;
									ValaSourceReference* _tmp512_;
									ValaSourceReference* _tmp513_;
									ValaSymbol* _tmp514_;
									_tmp488_ = sym;
									_tmp489_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp488_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp489_;
									invalid_match = NULL;
									_tmp491_ = base_prop;
									_tmp492_ = vala_symbol_get_hides ((ValaSymbol*) _tmp491_);
									_tmp493_ = _tmp492_;
									if (!_tmp493_) {
										ValaProperty* _tmp494_;
										ValaProperty* _tmp495_;
										gchar* _tmp496_ = NULL;
										gboolean _tmp497_;
										_tmp494_ = base_prop;
										_tmp495_ = prop;
										_tmp497_ = vala_property_compatible (_tmp494_, _tmp495_, &_tmp496_);
										_g_free0 (invalid_match);
										invalid_match = _tmp496_;
										_tmp490_ = !_tmp497_;
									} else {
										_tmp490_ = FALSE;
									}
									if (_tmp490_) {
										ValaSourceReference* _tmp498_;
										ValaSourceReference* _tmp499_;
										ValaProperty* _tmp500_;
										gchar* _tmp501_;
										gchar* _tmp502_;
										ValaProperty* _tmp503_;
										gchar* _tmp504_;
										gchar* _tmp505_;
										const gchar* _tmp506_;
										gchar* _tmp507_;
										gchar* _tmp508_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp498_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp499_ = _tmp498_;
										_tmp500_ = prop;
										_tmp501_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp500_);
										_tmp502_ = _tmp501_;
										_tmp503_ = base_prop;
										_tmp504_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp503_);
										_tmp505_ = _tmp504_;
										_tmp506_ = invalid_match;
										_tmp507_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp502_, _tmp505_, _tmp506_);
										_tmp508_ = _tmp507_;
										vala_report_error (_tmp499_, _tmp508_);
										_g_free0 (_tmp508_);
										_g_free0 (_tmp505_);
										_g_free0 (_tmp502_);
									}
									_tmp509_ = sym;
									_tmp510_ = vala_symbol_get_version (_tmp509_);
									_tmp511_ = _tmp510_;
									_tmp512_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp513_ = _tmp512_;
									vala_version_attribute_check (_tmp511_, _tmp513_);
									_tmp514_ = sym;
									vala_symbol_set_used (_tmp514_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp515_;
									ValaSourceReference* _tmp516_;
									gchar* _tmp517_;
									gchar* _tmp518_;
									ValaProperty* _tmp519_;
									gchar* _tmp520_;
									gchar* _tmp521_;
									gchar* _tmp522_;
									gchar* _tmp523_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp515_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp516_ = _tmp515_;
									_tmp517_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp518_ = _tmp517_;
									_tmp519_ = prop;
									_tmp520_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp519_);
									_tmp521_ = _tmp520_;
									_tmp522_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp518_, _tmp521_);
									_tmp523_ = _tmp522_;
									vala_report_error (_tmp516_, _tmp523_);
									_g_free0 (_tmp523_);
									_g_free0 (_tmp521_);
									_g_free0 (_tmp518_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp524_ = self->priv->_is_abstract;
		if (!_tmp524_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp525_;
			ValaClass* _tmp526_;
			_tmp525_ = self->priv->_base_class;
			_tmp526_ = _vala_code_node_ref0 (_tmp525_);
			base_class = _tmp526_;
			while (TRUE) {
				gboolean _tmp527_ = FALSE;
				ValaClass* _tmp528_;
				ValaClass* _tmp597_;
				ValaClass* _tmp598_;
				ValaClass* _tmp599_;
				_tmp528_ = base_class;
				if (_tmp528_ != NULL) {
					ValaClass* _tmp529_;
					gboolean _tmp530_;
					_tmp529_ = base_class;
					_tmp530_ = _tmp529_->priv->_is_abstract;
					_tmp527_ = _tmp530_;
				} else {
					_tmp527_ = FALSE;
				}
				if (!_tmp527_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp531_;
					ValaList* _tmp532_;
					gint _base_method_size = 0;
					ValaList* _tmp533_;
					gint _tmp534_;
					gint _tmp535_;
					gint _base_method_index = 0;
					_tmp531_ = base_class;
					_tmp532_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp531_);
					_base_method_list = _tmp532_;
					_tmp533_ = _base_method_list;
					_tmp534_ = vala_collection_get_size ((ValaCollection*) _tmp533_);
					_tmp535_ = _tmp534_;
					_base_method_size = _tmp535_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp536_;
						gint _tmp537_;
						gint _tmp538_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp539_;
						gint _tmp540_;
						gpointer _tmp541_;
						ValaMethod* _tmp542_;
						gboolean _tmp543_;
						gboolean _tmp544_;
						_tmp536_ = _base_method_index;
						_base_method_index = _tmp536_ + 1;
						_tmp537_ = _base_method_index;
						_tmp538_ = _base_method_size;
						if (!(_tmp537_ < _tmp538_)) {
							break;
						}
						_tmp539_ = _base_method_list;
						_tmp540_ = _base_method_index;
						_tmp541_ = vala_list_get (_tmp539_, _tmp540_);
						base_method = (ValaMethod*) _tmp541_;
						_tmp542_ = base_method;
						_tmp543_ = vala_method_get_is_abstract (_tmp542_);
						_tmp544_ = _tmp543_;
						if (_tmp544_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp545_;
							const gchar* _tmp546_;
							const gchar* _tmp547_;
							ValaSymbol* _tmp548_;
							ValaMethod* _tmp549_;
							gboolean _tmp550_ = FALSE;
							ValaMethod* _tmp551_;
							_tmp545_ = base_method;
							_tmp546_ = vala_symbol_get_name ((ValaSymbol*) _tmp545_);
							_tmp547_ = _tmp546_;
							_tmp548_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp547_);
							_tmp549_ = VALA_IS_METHOD (_tmp548_) ? ((ValaMethod*) _tmp548_) : NULL;
							if (_tmp549_ == NULL) {
								_vala_code_node_unref0 (_tmp548_);
							}
							override_method = _tmp549_;
							_tmp551_ = override_method;
							if (_tmp551_ == NULL) {
								_tmp550_ = TRUE;
							} else {
								ValaMethod* _tmp552_;
								gboolean _tmp553_;
								gboolean _tmp554_;
								_tmp552_ = override_method;
								_tmp553_ = vala_method_get_overrides (_tmp552_);
								_tmp554_ = _tmp553_;
								_tmp550_ = !_tmp554_;
							}
							if (_tmp550_) {
								ValaSourceReference* _tmp555_;
								ValaSourceReference* _tmp556_;
								gchar* _tmp557_;
								gchar* _tmp558_;
								ValaMethod* _tmp559_;
								gchar* _tmp560_;
								gchar* _tmp561_;
								gchar* _tmp562_;
								gchar* _tmp563_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp555_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp556_ = _tmp555_;
								_tmp557_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp558_ = _tmp557_;
								_tmp559_ = base_method;
								_tmp560_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp559_);
								_tmp561_ = _tmp560_;
								_tmp562_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp558_, _tmp561_);
								_tmp563_ = _tmp562_;
								vala_report_error (_tmp556_, _tmp563_);
								_g_free0 (_tmp563_);
								_g_free0 (_tmp561_);
								_g_free0 (_tmp558_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp564_;
					ValaList* _tmp565_;
					gint _base_property_size = 0;
					ValaList* _tmp566_;
					gint _tmp567_;
					gint _tmp568_;
					gint _base_property_index = 0;
					_tmp564_ = base_class;
					_tmp565_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp564_);
					_base_property_list = _tmp565_;
					_tmp566_ = _base_property_list;
					_tmp567_ = vala_collection_get_size ((ValaCollection*) _tmp566_);
					_tmp568_ = _tmp567_;
					_base_property_size = _tmp568_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp569_;
						gint _tmp570_;
						gint _tmp571_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp572_;
						gint _tmp573_;
						gpointer _tmp574_;
						ValaProperty* _tmp575_;
						gboolean _tmp576_;
						gboolean _tmp577_;
						_tmp569_ = _base_property_index;
						_base_property_index = _tmp569_ + 1;
						_tmp570_ = _base_property_index;
						_tmp571_ = _base_property_size;
						if (!(_tmp570_ < _tmp571_)) {
							break;
						}
						_tmp572_ = _base_property_list;
						_tmp573_ = _base_property_index;
						_tmp574_ = vala_list_get (_tmp572_, _tmp573_);
						base_property = (ValaProperty*) _tmp574_;
						_tmp575_ = base_property;
						_tmp576_ = vala_property_get_is_abstract (_tmp575_);
						_tmp577_ = _tmp576_;
						if (_tmp577_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp578_;
							const gchar* _tmp579_;
							const gchar* _tmp580_;
							ValaSymbol* _tmp581_;
							ValaProperty* _tmp582_;
							gboolean _tmp583_ = FALSE;
							ValaProperty* _tmp584_;
							_tmp578_ = base_property;
							_tmp579_ = vala_symbol_get_name ((ValaSymbol*) _tmp578_);
							_tmp580_ = _tmp579_;
							_tmp581_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp580_);
							_tmp582_ = VALA_IS_PROPERTY (_tmp581_) ? ((ValaProperty*) _tmp581_) : NULL;
							if (_tmp582_ == NULL) {
								_vala_code_node_unref0 (_tmp581_);
							}
							override_property = _tmp582_;
							_tmp584_ = override_property;
							if (_tmp584_ == NULL) {
								_tmp583_ = TRUE;
							} else {
								ValaProperty* _tmp585_;
								gboolean _tmp586_;
								gboolean _tmp587_;
								_tmp585_ = override_property;
								_tmp586_ = vala_property_get_overrides (_tmp585_);
								_tmp587_ = _tmp586_;
								_tmp583_ = !_tmp587_;
							}
							if (_tmp583_) {
								ValaSourceReference* _tmp588_;
								ValaSourceReference* _tmp589_;
								gchar* _tmp590_;
								gchar* _tmp591_;
								ValaProperty* _tmp592_;
								gchar* _tmp593_;
								gchar* _tmp594_;
								gchar* _tmp595_;
								gchar* _tmp596_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp588_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp589_ = _tmp588_;
								_tmp590_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp591_ = _tmp590_;
								_tmp592_ = base_property;
								_tmp593_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp592_);
								_tmp594_ = _tmp593_;
								_tmp595_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp591_, _tmp594_);
								_tmp596_ = _tmp595_;
								vala_report_error (_tmp589_, _tmp596_);
								_g_free0 (_tmp596_);
								_g_free0 (_tmp594_);
								_g_free0 (_tmp591_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp597_ = base_class;
				_tmp598_ = _tmp597_->priv->_base_class;
				_tmp599_ = _vala_code_node_ref0 (_tmp598_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp599_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp600_ = vala_code_context_get_analyzer (context);
	_tmp601_ = _tmp600_;
	_tmp602_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp601_, _tmp602_);
	_tmp603_ = vala_code_context_get_analyzer (context);
	_tmp604_ = _tmp603_;
	_tmp605_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp604_, _tmp605_);
	_tmp606_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp607_ = _tmp606_;
	result = !_tmp607_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_compact;
	result = *_tmp10_;
	return result;
}


void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}


gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	result = *_tmp10_;
	return result;
}


void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
	_tmp1_ = self->priv->_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
	_tmp1_ = self->priv->_class_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	ValaConstructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
	_tmp1_ = self->priv->_static_constructor;
	if (_tmp1_ != NULL) {
		ValaConstructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_constructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		ValaDestructor* _tmp5_;
		ValaParameter* _tmp6_;
		ValaParameter* _tmp7_;
		ValaDestructor* _tmp16_;
		ValaObjectType* _tmp17_;
		ValaObjectType* _tmp18_;
		ValaParameter* _tmp19_;
		ValaParameter* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaScope* _tmp22_;
		ValaScope* _tmp23_;
		ValaDestructor* _tmp24_;
		ValaParameter* _tmp25_;
		ValaParameter* _tmp26_;
		const gchar* _tmp27_;
		const gchar* _tmp28_;
		ValaDestructor* _tmp29_;
		ValaParameter* _tmp30_;
		ValaParameter* _tmp31_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
		_tmp5_ = self->priv->_destructor;
		_tmp6_ = vala_destructor_get_this_parameter (_tmp5_);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != NULL) {
			ValaDestructor* _tmp8_;
			ValaScope* _tmp9_;
			ValaScope* _tmp10_;
			ValaDestructor* _tmp11_;
			ValaParameter* _tmp12_;
			ValaParameter* _tmp13_;
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_symbol_get_scope ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = self->priv->_destructor;
			_tmp12_ = vala_destructor_get_this_parameter (_tmp11_);
			_tmp13_ = _tmp12_;
			_tmp14_ = vala_symbol_get_name ((ValaSymbol*) _tmp13_);
			_tmp15_ = _tmp14_;
			vala_scope_remove (_tmp10_, _tmp15_);
		}
		_tmp16_ = self->priv->_destructor;
		_tmp17_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_parameter_new ("this", (ValaDataType*) _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		vala_destructor_set_this_parameter (_tmp16_, _tmp20_);
		_vala_code_node_unref0 (_tmp20_);
		_vala_code_node_unref0 (_tmp18_);
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_symbol_get_scope ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = self->priv->_destructor;
		_tmp25_ = vala_destructor_get_this_parameter (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_symbol_get_name ((ValaSymbol*) _tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = self->priv->_destructor;
		_tmp30_ = vala_destructor_get_this_parameter (_tmp29_);
		_tmp31_ = _tmp30_;
		vala_scope_add (_tmp23_, _tmp28_, (ValaSymbol*) _tmp31_);
	}
}


ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
	_tmp1_ = self->priv->_static_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_static_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
	_tmp1_ = self->priv->_class_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaScope* _tmp3_;
		ValaScope* _tmp4_;
		_tmp2_ = self->priv->_class_destructor;
		_tmp3_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_symbol_set_owner ((ValaSymbol*) _tmp2_, _tmp4_);
	}
}


gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void
vala_class_class_init (ValaClassClass * klass)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol*, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol*, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol*, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol*, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol*, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol*)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol*, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_class_real_check;
}


static void
vala_class_instance_init (ValaClass * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
}


static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



