/* valaobjectcreationexpression.c generated by valac, the Vala compiler
 * generated from valaobjectcreationexpression.vala, do not modify */

/* valaobjectcreationexpression.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))

struct _ValaObjectCreationExpressionPrivate {
	gboolean _is_yield_expression;
	gboolean _struct_creation;
	ValaList* argument_list;
	ValaList* object_initializer;
	ValaDataType* _data_type;
	ValaMemberAccess* _member_name;
};


static gpointer vala_object_creation_expression_parent_class = NULL;

#define VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpressionPrivate))
static void vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                           ValaCodeVisitor* visitor);
static void vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                              ValaExpression* old_node,
                                                              ValaExpression* new_node);
static gboolean vala_object_creation_expression_real_is_pure (ValaExpression* base);
static gboolean vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                             ValaSymbol* sym);
static void vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                        ValaDataType* old_type,
                                                        ValaDataType* new_type);
static gboolean vala_object_creation_expression_real_check (ValaCodeNode* base,
                                                     ValaCodeContext* context);
static void vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                                ValaCodeGenerator* codegen);
static void vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                                 ValaCollection* collection);
static void vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                              ValaCollection* collection);
static void vala_object_creation_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new object creation expression.
 *
 * @param member_name      object type to create
 * @param source_reference reference to source code
 * @return                 newly created object creation expression
 */
ValaObjectCreationExpression*
vala_object_creation_expression_construct (GType object_type,
                                           ValaMemberAccess* member_name,
                                           ValaSourceReference* source_reference)
{
	ValaObjectCreationExpression* self = NULL;
	g_return_val_if_fail (source_reference != NULL, NULL);
	self = (ValaObjectCreationExpression*) vala_expression_construct (object_type);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_object_creation_expression_set_member_name (self, member_name);
	return self;
}


ValaObjectCreationExpression*
vala_object_creation_expression_new (ValaMemberAccess* member_name,
                                     ValaSourceReference* source_reference)
{
	return vala_object_creation_expression_construct (VALA_TYPE_OBJECT_CREATION_EXPRESSION, member_name, source_reference);
}


/**
 * Appends the specified expression to the list of arguments.
 *
 * @param arg an argument
 */
void
vala_object_creation_expression_add_argument (ValaObjectCreationExpression* self,
                                              ValaExpression* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the argument list.
 *
 * @return argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_object_creation_expression_get_argument_list (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Appends the specified member initializer to the object initializer.
 *
 * @param init a member initializer
 */
void
vala_object_creation_expression_add_member_initializer (ValaObjectCreationExpression* self,
                                                        ValaMemberInitializer* init)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (init != NULL);
	_tmp0_ = self->priv->object_initializer;
	vala_collection_add ((ValaCollection*) _tmp0_, init);
	vala_code_node_set_parent_node ((ValaCodeNode*) init, (ValaCodeNode*) self);
}


/**
 * Returns the object initializer.
 *
 * @return member initializer list
 */
ValaList*
vala_object_creation_expression_get_object_initializer (ValaObjectCreationExpression* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->object_initializer;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_object_creation_expression_real_accept (ValaCodeNode* base,
                                             ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_object_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_accept_children (ValaCodeNode* base,
                                                      ValaCodeVisitor* visitor)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaDataType* _tmp2_;
		ValaDataType* _tmp3_;
		_tmp2_ = vala_object_creation_expression_get_type_reference (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		vala_code_node_accept ((ValaCodeNode*) _tmp7_, visitor);
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _arg_index = 0;
		_tmp8_ = self->priv->argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_arg_list = _tmp9_;
		_tmp10_ = _arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_arg_size = _tmp12_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaExpression* arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaExpression* _tmp19_;
			_tmp13_ = _arg_index;
			_arg_index = _tmp13_ + 1;
			_tmp14_ = _arg_index;
			_tmp15_ = _arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _arg_list;
			_tmp17_ = _arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			arg = (ValaExpression*) _tmp18_;
			_tmp19_ = arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp19_, visitor);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp20_;
		ValaList* _tmp21_;
		gint _init_size = 0;
		ValaList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _init_index = 0;
		_tmp20_ = self->priv->object_initializer;
		_tmp21_ = _vala_iterable_ref0 (_tmp20_);
		_init_list = _tmp21_;
		_tmp22_ = _init_list;
		_tmp23_ = vala_collection_get_size ((ValaCollection*) _tmp22_);
		_tmp24_ = _tmp23_;
		_init_size = _tmp24_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp25_;
			gint _tmp26_;
			gint _tmp27_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp28_;
			gint _tmp29_;
			gpointer _tmp30_;
			ValaMemberInitializer* _tmp31_;
			_tmp25_ = _init_index;
			_init_index = _tmp25_ + 1;
			_tmp26_ = _init_index;
			_tmp27_ = _init_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _init_list;
			_tmp29_ = _init_index;
			_tmp30_ = vala_list_get (_tmp28_, _tmp29_);
			init = (ValaMemberInitializer*) _tmp30_;
			_tmp31_ = init;
			vala_code_node_accept ((ValaCodeNode*) _tmp31_, visitor);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


static void
vala_object_creation_expression_real_replace_expression (ValaCodeNode* base,
                                                         ValaExpression* old_node,
                                                         ValaExpression* new_node)
{
	ValaObjectCreationExpression * self;
	gint index = 0;
	ValaList* _tmp0_;
	gint _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = self->priv->argument_list;
	index = vala_list_index_of (_tmp0_, old_node);
	_tmp1_ = index;
	if (_tmp1_ >= 0) {
		ValaList* _tmp2_;
		gint _tmp3_;
		_tmp2_ = self->priv->argument_list;
		_tmp3_ = index;
		vala_list_set (_tmp2_, _tmp3_, new_node);
		vala_code_node_set_parent_node ((ValaCodeNode*) new_node, (ValaCodeNode*) self);
	}
}


static gboolean
vala_object_creation_expression_real_is_pure (ValaExpression* base)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	self = (ValaObjectCreationExpression*) base;
	result = FALSE;
	return result;
}


static gboolean
vala_object_creation_expression_real_is_accessible (ValaExpression* base,
                                                    ValaSymbol* sym)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaMemberAccess* _tmp1_;
	ValaMemberAccess* _tmp2_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp1_ = vala_object_creation_expression_get_member_name (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		ValaMemberAccess* _tmp3_;
		ValaMemberAccess* _tmp4_;
		_tmp3_ = vala_object_creation_expression_get_member_name (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = !vala_expression_is_accessible ((ValaExpression*) _tmp4_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp5_;
		ValaList* _tmp6_;
		gint _arg_size = 0;
		ValaList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _arg_index = 0;
		_tmp5_ = self->priv->argument_list;
		_tmp6_ = _vala_iterable_ref0 (_tmp5_);
		_arg_list = _tmp6_;
		_tmp7_ = _arg_list;
		_tmp8_ = vala_collection_get_size ((ValaCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		_arg_size = _tmp9_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			ValaExpression* arg = NULL;
			ValaList* _tmp13_;
			gint _tmp14_;
			gpointer _tmp15_;
			ValaExpression* _tmp16_;
			_tmp10_ = _arg_index;
			_arg_index = _tmp10_ + 1;
			_tmp11_ = _arg_index;
			_tmp12_ = _arg_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _arg_list;
			_tmp14_ = _arg_index;
			_tmp15_ = vala_list_get (_tmp13_, _tmp14_);
			arg = (ValaExpression*) _tmp15_;
			_tmp16_ = arg;
			if (!vala_expression_is_accessible (_tmp16_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp17_;
		ValaList* _tmp18_;
		gint _init_size = 0;
		ValaList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _init_index = 0;
		_tmp17_ = self->priv->object_initializer;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_init_list = _tmp18_;
		_tmp19_ = _init_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_init_size = _tmp21_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValaMemberInitializer* _tmp28_;
			ValaExpression* _tmp29_;
			ValaExpression* _tmp30_;
			_tmp22_ = _init_index;
			_init_index = _tmp22_ + 1;
			_tmp23_ = _init_index;
			_tmp24_ = _init_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _init_list;
			_tmp26_ = _init_index;
			_tmp27_ = vala_list_get (_tmp25_, _tmp26_);
			init = (ValaMemberInitializer*) _tmp27_;
			_tmp28_ = init;
			_tmp29_ = vala_member_initializer_get_initializer (_tmp28_);
			_tmp30_ = _tmp29_;
			if (!vala_expression_is_accessible (_tmp30_, sym)) {
				result = FALSE;
				_vala_code_node_unref0 (init);
				_vala_iterable_unref0 (_init_list);
				return result;
			}
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	result = TRUE;
	return result;
}


static void
vala_object_creation_expression_real_replace_type (ValaCodeNode* base,
                                                   ValaDataType* old_type,
                                                   ValaDataType* new_type)
{
	ValaObjectCreationExpression * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_object_creation_expression_get_type_reference (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_object_creation_expression_set_type_reference (self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_object_creation_expression_real_check (ValaCodeNode* base,
                                            ValaCodeContext* context)
{
	ValaObjectCreationExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaMemberAccess* _tmp4_;
	ValaMemberAccess* _tmp5_;
	ValaTypeSymbol* type = NULL;
	ValaDataType* _tmp8_;
	ValaDataType* _tmp9_;
	ValaDataType* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	ValaDataType* _tmp113_;
	ValaDataType* _tmp114_;
	ValaDataType* _tmp115_;
	gboolean may_throw = FALSE;
	gint given_num_type_args = 0;
	ValaDataType* _tmp116_;
	ValaDataType* _tmp117_;
	ValaList* _tmp118_;
	ValaList* _tmp119_;
	gint _tmp120_;
	gint _tmp121_;
	gint _tmp122_;
	gint expected_num_type_args = 0;
	ValaTypeSymbol* _tmp123_;
	gint _tmp245_;
	gint _tmp246_;
	gboolean _tmp253_ = FALSE;
	ValaSymbol* _tmp254_;
	ValaSymbol* _tmp255_;
	ValaSymbol* _tmp267_;
	ValaSymbol* _tmp268_;
	gboolean _tmp553_;
	gboolean _tmp606_;
	gboolean _tmp607_;
	self = (ValaObjectCreationExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_object_creation_expression_get_member_name (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaMemberAccess* _tmp6_;
		ValaMemberAccess* _tmp7_;
		_tmp6_ = vala_object_creation_expression_get_member_name (self);
		_tmp7_ = _tmp6_;
		if (!vala_code_node_check ((ValaCodeNode*) _tmp7_, context)) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			return result;
		}
	}
	type = NULL;
	_tmp8_ = vala_object_creation_expression_get_type_reference (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		ValaMemberAccess* _tmp10_;
		ValaMemberAccess* _tmp11_;
		ValaMemberAccess* _tmp14_;
		ValaMemberAccess* _tmp15_;
		ValaSymbol* _tmp16_;
		ValaSymbol* _tmp17_;
		ValaSymbol* constructor_sym = NULL;
		ValaMemberAccess* _tmp18_;
		ValaMemberAccess* _tmp19_;
		ValaSymbol* _tmp20_;
		ValaSymbol* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* type_sym = NULL;
		ValaMemberAccess* _tmp23_;
		ValaMemberAccess* _tmp24_;
		ValaSymbol* _tmp25_;
		ValaSymbol* _tmp26_;
		ValaSymbol* _tmp27_;
		ValaList* type_args = NULL;
		ValaMemberAccess* _tmp28_;
		ValaMemberAccess* _tmp29_;
		ValaList* _tmp30_;
		ValaSymbol* _tmp31_;
		ValaSymbol* _tmp55_;
		_tmp10_ = vala_object_creation_expression_get_member_name (self);
		_tmp11_ = _tmp10_;
		if (_tmp11_ == NULL) {
			ValaSourceReference* _tmp12_;
			ValaSourceReference* _tmp13_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp13_ = _tmp12_;
			vala_report_error (_tmp13_, "Incomplete object creation expression");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp14_ = vala_object_creation_expression_get_member_name (self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp15_);
		_tmp17_ = _tmp16_;
		if (_tmp17_ == NULL) {
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp18_ = vala_object_creation_expression_get_member_name (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _vala_code_node_ref0 (_tmp21_);
		constructor_sym = _tmp22_;
		_tmp23_ = vala_object_creation_expression_get_member_name (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _vala_code_node_ref0 (_tmp26_);
		type_sym = _tmp27_;
		_tmp28_ = vala_object_creation_expression_get_member_name (self);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_member_access_get_type_arguments (_tmp29_);
		type_args = _tmp30_;
		_tmp31_ = constructor_sym;
		if (VALA_IS_METHOD (_tmp31_)) {
			ValaSymbol* _tmp32_;
			ValaSymbol* _tmp33_;
			ValaSymbol* _tmp34_;
			ValaSymbol* _tmp35_;
			ValaMethod* constructor = NULL;
			ValaSymbol* _tmp36_;
			ValaMethod* _tmp37_;
			ValaSymbol* _tmp38_;
			ValaMethod* _tmp46_;
			ValaMemberAccess* ma = NULL;
			ValaMemberAccess* _tmp47_;
			ValaMemberAccess* _tmp48_;
			ValaExpression* _tmp49_;
			ValaExpression* _tmp50_;
			ValaMemberAccess* _tmp51_;
			ValaMemberAccess* _tmp52_;
			_tmp32_ = constructor_sym;
			_tmp33_ = vala_symbol_get_parent_symbol (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _vala_code_node_ref0 (_tmp34_);
			_vala_code_node_unref0 (type_sym);
			type_sym = _tmp35_;
			_tmp36_ = constructor_sym;
			_tmp37_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, VALA_TYPE_METHOD, ValaMethod));
			constructor = _tmp37_;
			_tmp38_ = constructor_sym;
			if (!VALA_IS_CREATION_METHOD (_tmp38_)) {
				ValaSourceReference* _tmp39_;
				ValaSourceReference* _tmp40_;
				ValaMethod* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp39_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp40_ = _tmp39_;
				_tmp41_ = constructor;
				_tmp42_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("`%s' is not a creation method", _tmp43_);
				_tmp45_ = _tmp44_;
				vala_report_error (_tmp40_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
				result = FALSE;
				_vala_code_node_unref0 (constructor);
				_vala_iterable_unref0 (type_args);
				_vala_code_node_unref0 (type_sym);
				_vala_code_node_unref0 (constructor_sym);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp46_ = constructor;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp46_);
			_tmp47_ = vala_object_creation_expression_get_member_name (self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_member_access_get_inner (_tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp50_) ? ((ValaMemberAccess*) _tmp50_) : NULL);
			ma = _tmp51_;
			_tmp52_ = ma;
			if (_tmp52_ != NULL) {
				ValaMemberAccess* _tmp53_;
				ValaList* _tmp54_;
				_tmp53_ = ma;
				_tmp54_ = vala_member_access_get_type_arguments (_tmp53_);
				_vala_iterable_unref0 (type_args);
				type_args = _tmp54_;
			}
			_vala_code_node_unref0 (ma);
			_vala_code_node_unref0 (constructor);
		}
		_tmp55_ = type_sym;
		if (VALA_IS_CLASS (_tmp55_)) {
			ValaSymbol* _tmp56_;
			ValaTypeSymbol* _tmp57_;
			ValaTypeSymbol* _tmp58_;
			gboolean _tmp59_;
			gboolean _tmp60_;
			_tmp56_ = type_sym;
			_tmp57_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp56_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
			_vala_code_node_unref0 (type);
			type = _tmp57_;
			_tmp58_ = type;
			_tmp59_ = vala_class_get_is_error_base (G_TYPE_CHECK_INSTANCE_CAST (_tmp58_, VALA_TYPE_CLASS, ValaClass));
			_tmp60_ = _tmp59_;
			if (_tmp60_) {
				ValaSourceReference* _tmp61_;
				ValaSourceReference* _tmp62_;
				ValaErrorType* _tmp63_;
				ValaErrorType* _tmp64_;
				_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_error_type_new (NULL, NULL, _tmp62_);
				_tmp64_ = _tmp63_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp64_);
				_vala_code_node_unref0 (_tmp64_);
			} else {
				ValaTypeSymbol* _tmp65_;
				ValaObjectType* _tmp66_;
				ValaObjectType* _tmp67_;
				_tmp65_ = type;
				_tmp66_ = vala_object_type_new ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_CLASS, ValaClass));
				_tmp67_ = _tmp66_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp67_);
				_vala_code_node_unref0 (_tmp67_);
			}
		} else {
			ValaSymbol* _tmp68_;
			_tmp68_ = type_sym;
			if (VALA_IS_STRUCT (_tmp68_)) {
				ValaSymbol* _tmp69_;
				ValaTypeSymbol* _tmp70_;
				ValaTypeSymbol* _tmp71_;
				ValaStructValueType* _tmp72_;
				ValaStructValueType* _tmp73_;
				_tmp69_ = type_sym;
				_tmp70_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp69_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
				_vala_code_node_unref0 (type);
				type = _tmp70_;
				_tmp71_ = type;
				_tmp72_ = vala_struct_value_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp71_, VALA_TYPE_STRUCT, ValaStruct));
				_tmp73_ = _tmp72_;
				vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp73_);
				_vala_code_node_unref0 (_tmp73_);
			} else {
				ValaSymbol* _tmp74_;
				_tmp74_ = type_sym;
				if (VALA_IS_ERROR_CODE (_tmp74_)) {
					ValaSymbol* _tmp75_;
					ValaSymbol* _tmp76_;
					ValaSymbol* _tmp77_;
					ValaSymbol* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					ValaErrorType* _tmp81_;
					ValaErrorType* _tmp82_;
					ValaSymbol* _tmp83_;
					_tmp75_ = type_sym;
					_tmp76_ = vala_symbol_get_parent_symbol (_tmp75_);
					_tmp77_ = _tmp76_;
					_tmp78_ = type_sym;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp80_ = _tmp79_;
					_tmp81_ = vala_error_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp77_, VALA_TYPE_ERROR_DOMAIN, ValaErrorDomain), G_TYPE_CHECK_INSTANCE_CAST (_tmp78_, VALA_TYPE_ERROR_CODE, ValaErrorCode), _tmp80_);
					_tmp82_ = _tmp81_;
					vala_object_creation_expression_set_type_reference (self, (ValaDataType*) _tmp82_);
					_vala_code_node_unref0 (_tmp82_);
					_tmp83_ = type_sym;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp83_);
				} else {
					ValaSourceReference* _tmp84_;
					ValaSourceReference* _tmp85_;
					ValaSymbol* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
					gchar* _tmp90_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp84_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp85_ = _tmp84_;
					_tmp86_ = type_sym;
					_tmp87_ = vala_symbol_get_full_name (_tmp86_);
					_tmp88_ = _tmp87_;
					_tmp89_ = g_strdup_printf ("`%s' is not a class, struct, or error code", _tmp88_);
					_tmp90_ = _tmp89_;
					vala_report_error (_tmp85_, _tmp90_);
					_g_free0 (_tmp90_);
					_g_free0 (_tmp88_);
					result = FALSE;
					_vala_iterable_unref0 (type_args);
					_vala_code_node_unref0 (type_sym);
					_vala_code_node_unref0 (constructor_sym);
					_vala_code_node_unref0 (type);
					return result;
				}
			}
		}
		{
			ValaList* _type_arg_list = NULL;
			ValaList* _tmp91_;
			ValaList* _tmp92_;
			gint _type_arg_size = 0;
			ValaList* _tmp93_;
			gint _tmp94_;
			gint _tmp95_;
			gint _type_arg_index = 0;
			_tmp91_ = type_args;
			_tmp92_ = _vala_iterable_ref0 (_tmp91_);
			_type_arg_list = _tmp92_;
			_tmp93_ = _type_arg_list;
			_tmp94_ = vala_collection_get_size ((ValaCollection*) _tmp93_);
			_tmp95_ = _tmp94_;
			_type_arg_size = _tmp95_;
			_type_arg_index = -1;
			while (TRUE) {
				gint _tmp96_;
				gint _tmp97_;
				gint _tmp98_;
				ValaDataType* type_arg = NULL;
				ValaList* _tmp99_;
				gint _tmp100_;
				gpointer _tmp101_;
				ValaDataType* _tmp102_;
				ValaDataType* _tmp103_;
				ValaDataType* _tmp104_;
				_tmp96_ = _type_arg_index;
				_type_arg_index = _tmp96_ + 1;
				_tmp97_ = _type_arg_index;
				_tmp98_ = _type_arg_size;
				if (!(_tmp97_ < _tmp98_)) {
					break;
				}
				_tmp99_ = _type_arg_list;
				_tmp100_ = _type_arg_index;
				_tmp101_ = vala_list_get (_tmp99_, _tmp100_);
				type_arg = (ValaDataType*) _tmp101_;
				_tmp102_ = vala_object_creation_expression_get_type_reference (self);
				_tmp103_ = _tmp102_;
				_tmp104_ = type_arg;
				vala_data_type_add_type_argument (_tmp103_, _tmp104_);
				_vala_code_node_unref0 (type_arg);
			}
			_vala_iterable_unref0 (_type_arg_list);
		}
		_vala_iterable_unref0 (type_args);
		_vala_code_node_unref0 (type_sym);
		_vala_code_node_unref0 (constructor_sym);
	} else {
		ValaDataType* _tmp105_;
		ValaDataType* _tmp106_;
		ValaTypeSymbol* _tmp107_;
		ValaTypeSymbol* _tmp108_;
		ValaTypeSymbol* _tmp109_;
		_tmp105_ = vala_object_creation_expression_get_type_reference (self);
		_tmp106_ = _tmp105_;
		_tmp107_ = vala_data_type_get_data_type (_tmp106_);
		_tmp108_ = _tmp107_;
		_tmp109_ = _vala_code_node_ref0 (_tmp108_);
		_vala_code_node_unref0 (type);
		type = _tmp109_;
	}
	_tmp110_ = vala_object_creation_expression_get_type_reference (self);
	_tmp111_ = _tmp110_;
	_tmp112_ = vala_data_type_copy (_tmp111_);
	_tmp113_ = _tmp112_;
	vala_expression_set_value_type ((ValaExpression*) self, _tmp113_);
	_vala_code_node_unref0 (_tmp113_);
	_tmp114_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp115_ = _tmp114_;
	vala_data_type_set_value_owned (_tmp115_, TRUE);
	may_throw = FALSE;
	_tmp116_ = vala_object_creation_expression_get_type_reference (self);
	_tmp117_ = _tmp116_;
	_tmp118_ = vala_data_type_get_type_arguments (_tmp117_);
	_tmp119_ = _tmp118_;
	_tmp120_ = vala_collection_get_size ((ValaCollection*) _tmp119_);
	_tmp121_ = _tmp120_;
	_tmp122_ = _tmp121_;
	_vala_iterable_unref0 (_tmp119_);
	given_num_type_args = _tmp122_;
	expected_num_type_args = 0;
	_tmp123_ = type;
	if (VALA_IS_CLASS (_tmp123_)) {
		ValaClass* cl = NULL;
		ValaTypeSymbol* _tmp124_;
		ValaClass* _tmp125_;
		ValaClass* _tmp126_;
		ValaList* _tmp127_;
		ValaList* _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
		gboolean _tmp131_;
		ValaClass* _tmp134_;
		gboolean _tmp135_;
		gboolean _tmp136_;
		ValaSymbol* _tmp144_;
		ValaSymbol* _tmp145_;
		gboolean _tmp166_ = FALSE;
		ValaSymbol* _tmp167_;
		ValaSymbol* _tmp168_;
		_tmp124_ = type;
		_tmp125_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp124_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp125_;
		_tmp126_ = cl;
		_tmp127_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp126_);
		_tmp128_ = _tmp127_;
		_tmp129_ = vala_collection_get_size ((ValaCollection*) _tmp128_);
		_tmp130_ = _tmp129_;
		expected_num_type_args = _tmp130_;
		_vala_iterable_unref0 (_tmp128_);
		_tmp131_ = self->priv->_struct_creation;
		if (_tmp131_) {
			ValaSourceReference* _tmp132_;
			ValaSourceReference* _tmp133_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp132_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp133_ = _tmp132_;
			vala_report_error (_tmp133_, "syntax error, use `new' to create new objects");
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp134_ = cl;
		_tmp135_ = vala_class_get_is_abstract (_tmp134_);
		_tmp136_ = _tmp135_;
		if (_tmp136_) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			ValaClass* _tmp139_;
			gchar* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			vala_expression_set_value_type ((ValaExpression*) self, NULL);
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = cl;
			_tmp140_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp139_);
			_tmp141_ = _tmp140_;
			_tmp142_ = g_strdup_printf ("Can't create instance of abstract class `%s'", _tmp141_);
			_tmp143_ = _tmp142_;
			vala_report_error (_tmp138_, _tmp143_);
			_g_free0 (_tmp143_);
			_g_free0 (_tmp141_);
			result = FALSE;
			_vala_code_node_unref0 (cl);
			_vala_code_node_unref0 (type);
			return result;
		}
		_tmp144_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp145_ = _tmp144_;
		if (_tmp145_ == NULL) {
			ValaClass* _tmp146_;
			ValaCreationMethod* _tmp147_;
			ValaCreationMethod* _tmp148_;
			ValaSymbol* _tmp149_;
			ValaSymbol* _tmp150_;
			ValaSymbol* _tmp158_;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			ValaSymbol* _tmp161_;
			ValaVersionAttribute* _tmp162_;
			ValaVersionAttribute* _tmp163_;
			ValaSourceReference* _tmp164_;
			ValaSourceReference* _tmp165_;
			_tmp146_ = cl;
			_tmp147_ = vala_class_get_default_construction_method (_tmp146_);
			_tmp148_ = _tmp147_;
			vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp148_);
			_tmp149_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp150_ = _tmp149_;
			if (_tmp150_ == NULL) {
				ValaSourceReference* _tmp151_;
				ValaSourceReference* _tmp152_;
				ValaClass* _tmp153_;
				gchar* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				gchar* _tmp157_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp151_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp152_ = _tmp151_;
				_tmp153_ = cl;
				_tmp154_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp153_);
				_tmp155_ = _tmp154_;
				_tmp156_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp155_);
				_tmp157_ = _tmp156_;
				vala_report_error (_tmp152_, _tmp157_);
				_g_free0 (_tmp157_);
				_g_free0 (_tmp155_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
			_tmp158_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp159_ = _tmp158_;
			vala_symbol_set_used (_tmp159_, TRUE);
			_tmp160_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp161_ = _tmp160_;
			_tmp162_ = vala_symbol_get_version (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp164_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp165_ = _tmp164_;
			vala_version_attribute_check (_tmp163_, _tmp165_);
		}
		_tmp167_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp168_ = _tmp167_;
		if (_tmp168_ != NULL) {
			gboolean _tmp169_ = FALSE;
			ValaSymbol* _tmp170_;
			ValaSymbol* _tmp171_;
			ValaSymbolAccessibility _tmp172_;
			ValaSymbolAccessibility _tmp173_;
			_tmp170_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp171_ = _tmp170_;
			_tmp172_ = vala_symbol_get_access (_tmp171_);
			_tmp173_ = _tmp172_;
			if (_tmp173_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				_tmp169_ = TRUE;
			} else {
				ValaSymbol* _tmp174_;
				ValaSymbol* _tmp175_;
				ValaSymbolAccessibility _tmp176_;
				ValaSymbolAccessibility _tmp177_;
				_tmp174_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp175_ = _tmp174_;
				_tmp176_ = vala_symbol_get_access (_tmp175_);
				_tmp177_ = _tmp176_;
				_tmp169_ = _tmp177_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED;
			}
			_tmp166_ = _tmp169_;
		} else {
			_tmp166_ = FALSE;
		}
		if (_tmp166_) {
			gboolean in_target_type = FALSE;
			gboolean _tmp191_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp178_;
				ValaSemanticAnalyzer* _tmp179_;
				ValaSymbol* _tmp180_;
				ValaSymbol* _tmp181_;
				ValaSymbol* _tmp182_;
				_tmp178_ = vala_code_context_get_analyzer (context);
				_tmp179_ = _tmp178_;
				_tmp180_ = vala_semantic_analyzer_get_current_symbol (_tmp179_);
				_tmp181_ = _tmp180_;
				_tmp182_ = _vala_code_node_ref0 (_tmp181_);
				this_symbol = _tmp182_;
				{
					gboolean _tmp183_ = FALSE;
					_tmp183_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp188_;
						ValaSymbol* _tmp189_;
						ValaClass* _tmp190_;
						if (!_tmp183_) {
							ValaSymbol* _tmp184_;
							ValaSymbol* _tmp185_;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							_tmp184_ = this_symbol;
							_tmp185_ = vala_symbol_get_parent_symbol (_tmp184_);
							_tmp186_ = _tmp185_;
							_tmp187_ = _vala_code_node_ref0 (_tmp186_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp187_;
						}
						_tmp183_ = FALSE;
						_tmp188_ = this_symbol;
						if (!(_tmp188_ != NULL)) {
							break;
						}
						_tmp189_ = this_symbol;
						_tmp190_ = cl;
						if (_tmp189_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp190_, VALA_TYPE_SYMBOL, ValaSymbol)) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp191_ = in_target_type;
			if (!_tmp191_) {
				ValaSourceReference* _tmp192_;
				ValaSourceReference* _tmp193_;
				ValaSymbol* _tmp194_;
				ValaSymbol* _tmp195_;
				gchar* _tmp196_;
				gchar* _tmp197_;
				gchar* _tmp198_;
				gchar* _tmp199_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp195_ = _tmp194_;
				_tmp196_ = vala_symbol_get_full_name (_tmp195_);
				_tmp197_ = _tmp196_;
				_tmp198_ = g_strdup_printf ("Access to non-public constructor `%s' denied", _tmp197_);
				_tmp199_ = _tmp198_;
				vala_report_error (_tmp193_, _tmp199_);
				_g_free0 (_tmp199_);
				_g_free0 (_tmp197_);
				result = FALSE;
				_vala_code_node_unref0 (cl);
				_vala_code_node_unref0 (type);
				return result;
			}
		}
		while (TRUE) {
			ValaClass* _tmp200_;
			ValaClass* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gboolean _tmp204_;
			ValaClass* _tmp207_;
			ValaClass* _tmp208_;
			ValaClass* _tmp209_;
			ValaClass* _tmp210_;
			_tmp200_ = cl;
			if (!(_tmp200_ != NULL)) {
				break;
			}
			_tmp201_ = cl;
			_tmp202_ = vala_code_node_get_attribute_string ((ValaCodeNode*) _tmp201_, "CCode", "ref_sink_function", NULL);
			_tmp203_ = _tmp202_;
			_tmp204_ = _tmp203_ != NULL;
			_g_free0 (_tmp203_);
			if (_tmp204_) {
				ValaDataType* _tmp205_;
				ValaDataType* _tmp206_;
				_tmp205_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp206_ = _tmp205_;
				vala_data_type_set_floating_reference (_tmp206_, TRUE);
				break;
			}
			_tmp207_ = cl;
			_tmp208_ = vala_class_get_base_class (_tmp207_);
			_tmp209_ = _tmp208_;
			_tmp210_ = _vala_code_node_ref0 (_tmp209_);
			_vala_code_node_unref0 (cl);
			cl = _tmp210_;
		}
		_vala_code_node_unref0 (cl);
	} else {
		ValaTypeSymbol* _tmp211_;
		_tmp211_ = type;
		if (VALA_IS_STRUCT (_tmp211_)) {
			ValaStruct* st = NULL;
			ValaTypeSymbol* _tmp212_;
			ValaStruct* _tmp213_;
			ValaStruct* _tmp214_;
			ValaList* _tmp215_;
			ValaList* _tmp216_;
			gint _tmp217_;
			gint _tmp218_;
			gboolean _tmp219_ = FALSE;
			gboolean _tmp220_;
			ValaSymbol* _tmp225_;
			ValaSymbol* _tmp226_;
			gboolean _tmp230_ = FALSE;
			gboolean _tmp231_ = FALSE;
			ValaStruct* _tmp232_;
			_tmp212_ = type;
			_tmp213_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp212_, VALA_TYPE_STRUCT, ValaStruct));
			st = _tmp213_;
			_tmp214_ = st;
			_tmp215_ = vala_struct_get_type_parameters (_tmp214_);
			_tmp216_ = _tmp215_;
			_tmp217_ = vala_collection_get_size ((ValaCollection*) _tmp216_);
			_tmp218_ = _tmp217_;
			expected_num_type_args = _tmp218_;
			_vala_iterable_unref0 (_tmp216_);
			_tmp220_ = self->priv->_struct_creation;
			if (!_tmp220_) {
				gboolean _tmp221_;
				gboolean _tmp222_;
				_tmp221_ = vala_code_context_get_deprecated (context);
				_tmp222_ = _tmp221_;
				_tmp219_ = !_tmp222_;
			} else {
				_tmp219_ = FALSE;
			}
			if (_tmp219_) {
				ValaSourceReference* _tmp223_;
				ValaSourceReference* _tmp224_;
				_tmp223_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp224_ = _tmp223_;
				vala_report_warning (_tmp224_, "deprecated syntax, don't use `new' to initialize structs");
			}
			_tmp225_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp226_ = _tmp225_;
			if (_tmp226_ == NULL) {
				ValaStruct* _tmp227_;
				ValaMethod* _tmp228_;
				ValaMethod* _tmp229_;
				_tmp227_ = st;
				_tmp228_ = vala_struct_get_default_construction_method (_tmp227_);
				_tmp229_ = _tmp228_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp229_);
			}
			_tmp232_ = st;
			if (vala_struct_is_simple_type (_tmp232_)) {
				ValaSymbol* _tmp233_;
				ValaSymbol* _tmp234_;
				_tmp233_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp234_ = _tmp233_;
				_tmp231_ = _tmp234_ == NULL;
			} else {
				_tmp231_ = FALSE;
			}
			if (_tmp231_) {
				ValaList* _tmp235_;
				gint _tmp236_;
				gint _tmp237_;
				_tmp235_ = self->priv->object_initializer;
				_tmp236_ = vala_collection_get_size ((ValaCollection*) _tmp235_);
				_tmp237_ = _tmp236_;
				_tmp230_ = _tmp237_ == 0;
			} else {
				_tmp230_ = FALSE;
			}
			if (_tmp230_) {
				ValaSourceReference* _tmp238_;
				ValaSourceReference* _tmp239_;
				ValaStruct* _tmp240_;
				gchar* _tmp241_;
				gchar* _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp238_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp239_ = _tmp238_;
				_tmp240_ = st;
				_tmp241_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp240_);
				_tmp242_ = _tmp241_;
				_tmp243_ = g_strdup_printf ("`%s' does not have a default constructor", _tmp242_);
				_tmp244_ = _tmp243_;
				vala_report_error (_tmp239_, _tmp244_);
				_g_free0 (_tmp244_);
				_g_free0 (_tmp242_);
				result = FALSE;
				_vala_code_node_unref0 (st);
				_vala_code_node_unref0 (type);
				return result;
			}
			_vala_code_node_unref0 (st);
		}
	}
	_tmp245_ = expected_num_type_args;
	_tmp246_ = given_num_type_args;
	if (_tmp245_ > _tmp246_) {
		ValaSourceReference* _tmp247_;
		ValaSourceReference* _tmp248_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp247_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp248_ = _tmp247_;
		vala_report_error (_tmp248_, "too few type arguments");
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	} else {
		gint _tmp249_;
		gint _tmp250_;
		_tmp249_ = expected_num_type_args;
		_tmp250_ = given_num_type_args;
		if (_tmp249_ < _tmp250_) {
			ValaSourceReference* _tmp251_;
			ValaSourceReference* _tmp252_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp252_ = _tmp251_;
			vala_report_error (_tmp252_, "too many type arguments");
			result = FALSE;
			_vala_code_node_unref0 (type);
			return result;
		}
	}
	_tmp254_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp255_ = _tmp254_;
	if (_tmp255_ == NULL) {
		ValaList* _tmp256_;
		ValaList* _tmp257_;
		gint _tmp258_;
		gint _tmp259_;
		_tmp256_ = vala_object_creation_expression_get_argument_list (self);
		_tmp257_ = _tmp256_;
		_tmp258_ = vala_collection_get_size ((ValaCollection*) _tmp257_);
		_tmp259_ = _tmp258_;
		_tmp253_ = _tmp259_ != 0;
		_vala_iterable_unref0 (_tmp257_);
	} else {
		_tmp253_ = FALSE;
	}
	if (_tmp253_) {
		ValaSourceReference* _tmp260_;
		ValaSourceReference* _tmp261_;
		ValaTypeSymbol* _tmp262_;
		gchar* _tmp263_;
		gchar* _tmp264_;
		gchar* _tmp265_;
		gchar* _tmp266_;
		vala_expression_set_value_type ((ValaExpression*) self, NULL);
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp260_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp261_ = _tmp260_;
		_tmp262_ = type;
		_tmp263_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp262_);
		_tmp264_ = _tmp263_;
		_tmp265_ = g_strdup_printf ("No arguments allowed when constructing type `%s'", _tmp264_);
		_tmp266_ = _tmp265_;
		vala_report_error (_tmp261_, _tmp266_);
		_g_free0 (_tmp266_);
		_g_free0 (_tmp264_);
		result = FALSE;
		_vala_code_node_unref0 (type);
		return result;
	}
	_tmp267_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp268_ = _tmp267_;
	if (VALA_IS_METHOD (_tmp268_)) {
		ValaMethod* m = NULL;
		ValaSymbol* _tmp269_;
		ValaSymbol* _tmp270_;
		ValaMethod* _tmp271_;
		gboolean _tmp272_;
		ValaExpression* last_arg = NULL;
		ValaList* args = NULL;
		ValaList* _tmp297_;
		ValaIterator* arg_it = NULL;
		ValaList* _tmp298_;
		ValaIterator* _tmp299_;
		ValaMethod* _tmp332_;
		gboolean _tmp333_;
		gboolean _tmp334_;
		ValaSemanticAnalyzer* _tmp399_;
		ValaSemanticAnalyzer* _tmp400_;
		ValaMethod* _tmp401_;
		ValaMethodType* _tmp402_;
		ValaMethodType* _tmp403_;
		ValaMethod* _tmp404_;
		ValaList* _tmp405_;
		ValaList* _tmp406_;
		ValaList* _tmp407_;
		_tmp269_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp270_ = _tmp269_;
		_tmp271_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp270_, VALA_TYPE_METHOD, ValaMethod));
		m = _tmp271_;
		_tmp272_ = self->priv->_is_yield_expression;
		if (_tmp272_) {
			ValaMethod* _tmp273_;
			gboolean _tmp274_;
			gboolean _tmp275_;
			gboolean _tmp278_ = FALSE;
			ValaSemanticAnalyzer* _tmp279_;
			ValaSemanticAnalyzer* _tmp280_;
			ValaMethod* _tmp281_;
			ValaMethod* _tmp282_;
			_tmp273_ = m;
			_tmp274_ = vala_method_get_coroutine (_tmp273_);
			_tmp275_ = _tmp274_;
			if (!_tmp275_) {
				ValaSourceReference* _tmp276_;
				ValaSourceReference* _tmp277_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp276_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp277_ = _tmp276_;
				vala_report_error (_tmp277_, "yield expression requires async method");
			}
			_tmp279_ = vala_code_context_get_analyzer (context);
			_tmp280_ = _tmp279_;
			_tmp281_ = vala_semantic_analyzer_get_current_method (_tmp280_);
			_tmp282_ = _tmp281_;
			if (_tmp282_ == NULL) {
				_tmp278_ = TRUE;
			} else {
				ValaSemanticAnalyzer* _tmp283_;
				ValaSemanticAnalyzer* _tmp284_;
				ValaMethod* _tmp285_;
				ValaMethod* _tmp286_;
				gboolean _tmp287_;
				gboolean _tmp288_;
				_tmp283_ = vala_code_context_get_analyzer (context);
				_tmp284_ = _tmp283_;
				_tmp285_ = vala_semantic_analyzer_get_current_method (_tmp284_);
				_tmp286_ = _tmp285_;
				_tmp287_ = vala_method_get_coroutine (_tmp286_);
				_tmp288_ = _tmp287_;
				_tmp278_ = !_tmp288_;
			}
			if (_tmp278_) {
				ValaSourceReference* _tmp289_;
				ValaSourceReference* _tmp290_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp289_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp290_ = _tmp289_;
				vala_report_error (_tmp290_, "yield expression not available outside async method");
			}
		} else {
			ValaMethod* _tmp291_;
			_tmp291_ = m;
			if (VALA_IS_CREATION_METHOD (_tmp291_)) {
				ValaMethod* _tmp292_;
				gboolean _tmp293_;
				gboolean _tmp294_;
				_tmp292_ = m;
				_tmp293_ = vala_method_get_coroutine (_tmp292_);
				_tmp294_ = _tmp293_;
				if (_tmp294_) {
					ValaSourceReference* _tmp295_;
					ValaSourceReference* _tmp296_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp295_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp296_ = _tmp295_;
					vala_report_error (_tmp296_, "missing `yield' before async creation expression");
				}
			}
		}
		last_arg = NULL;
		_tmp297_ = vala_object_creation_expression_get_argument_list (self);
		args = _tmp297_;
		_tmp298_ = args;
		_tmp299_ = vala_iterable_iterator ((ValaIterable*) _tmp298_);
		arg_it = _tmp299_;
		{
			ValaList* _param_list = NULL;
			ValaMethod* _tmp300_;
			ValaList* _tmp301_;
			gint _param_size = 0;
			ValaList* _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			gint _param_index = 0;
			_tmp300_ = m;
			_tmp301_ = vala_callable_get_parameters ((ValaCallable*) _tmp300_);
			_param_list = _tmp301_;
			_tmp302_ = _param_list;
			_tmp303_ = vala_collection_get_size ((ValaCollection*) _tmp302_);
			_tmp304_ = _tmp303_;
			_param_size = _tmp304_;
			_param_index = -1;
			while (TRUE) {
				gint _tmp305_;
				gint _tmp306_;
				gint _tmp307_;
				ValaParameter* param = NULL;
				ValaList* _tmp308_;
				gint _tmp309_;
				gpointer _tmp310_;
				ValaParameter* _tmp311_;
				ValaParameter* _tmp312_;
				gboolean _tmp313_;
				gboolean _tmp314_;
				ValaIterator* _tmp315_;
				_tmp305_ = _param_index;
				_param_index = _tmp305_ + 1;
				_tmp306_ = _param_index;
				_tmp307_ = _param_size;
				if (!(_tmp306_ < _tmp307_)) {
					break;
				}
				_tmp308_ = _param_list;
				_tmp309_ = _param_index;
				_tmp310_ = vala_list_get (_tmp308_, _tmp309_);
				param = (ValaParameter*) _tmp310_;
				_tmp311_ = param;
				if (!vala_code_node_check ((ValaCodeNode*) _tmp311_, context)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
				_tmp312_ = param;
				_tmp313_ = vala_parameter_get_ellipsis (_tmp312_);
				_tmp314_ = _tmp313_;
				if (_tmp314_) {
					_vala_code_node_unref0 (param);
					break;
				}
				_tmp315_ = arg_it;
				if (vala_iterator_next (_tmp315_)) {
					ValaExpression* arg = NULL;
					ValaIterator* _tmp316_;
					gpointer _tmp317_;
					ValaExpression* _tmp318_;
					ValaParameter* _tmp319_;
					ValaDataType* _tmp320_;
					ValaDataType* _tmp321_;
					ValaExpression* _tmp322_;
					ValaExpression* _tmp323_;
					ValaDataType* _tmp324_;
					ValaDataType* _tmp325_;
					ValaDataType* _tmp326_;
					ValaDataType* _tmp327_;
					ValaDataType* _tmp328_;
					ValaDataType* _tmp329_;
					ValaExpression* _tmp330_;
					ValaExpression* _tmp331_;
					_tmp316_ = arg_it;
					_tmp317_ = vala_iterator_get (_tmp316_);
					arg = (ValaExpression*) _tmp317_;
					_tmp318_ = arg;
					_tmp319_ = param;
					_tmp320_ = vala_variable_get_variable_type ((ValaVariable*) _tmp319_);
					_tmp321_ = _tmp320_;
					vala_expression_set_formal_target_type (_tmp318_, _tmp321_);
					_tmp322_ = arg;
					_tmp323_ = arg;
					_tmp324_ = vala_expression_get_formal_target_type (_tmp323_);
					_tmp325_ = _tmp324_;
					_tmp326_ = vala_expression_get_value_type ((ValaExpression*) self);
					_tmp327_ = _tmp326_;
					_tmp328_ = vala_data_type_get_actual_type (_tmp325_, _tmp327_, NULL, (ValaCodeNode*) self);
					_tmp329_ = _tmp328_;
					vala_expression_set_target_type (_tmp322_, _tmp329_);
					_vala_code_node_unref0 (_tmp329_);
					_tmp330_ = arg;
					_tmp331_ = _vala_code_node_ref0 (_tmp330_);
					_vala_code_node_unref0 (last_arg);
					last_arg = _tmp331_;
					_vala_code_node_unref0 (arg);
				}
				_vala_code_node_unref0 (param);
			}
			_vala_iterable_unref0 (_param_list);
		}
		_tmp332_ = m;
		_tmp333_ = vala_method_get_printf_format (_tmp332_);
		_tmp334_ = _tmp333_;
		if (_tmp334_) {
			ValaStringLiteral* format_literal = NULL;
			ValaExpression* _tmp335_;
			ValaStringLiteral* _tmp378_;
			format_literal = NULL;
			_tmp335_ = last_arg;
			if (VALA_IS_NULL_LITERAL (_tmp335_)) {
			} else {
				ValaExpression* _tmp336_;
				_tmp336_ = last_arg;
				if (_tmp336_ != NULL) {
					ValaExpression* _tmp337_;
					ValaStringLiteral* _tmp338_;
					gboolean _tmp339_ = FALSE;
					ValaStringLiteral* _tmp340_;
					_tmp337_ = last_arg;
					_tmp338_ = vala_string_literal_get_format_literal (_tmp337_);
					_vala_code_node_unref0 (format_literal);
					format_literal = _tmp338_;
					_tmp340_ = format_literal;
					if (_tmp340_ == NULL) {
						ValaList* _tmp341_;
						gint _tmp342_;
						gint _tmp343_;
						ValaMethod* _tmp344_;
						ValaList* _tmp345_;
						ValaList* _tmp346_;
						gint _tmp347_;
						gint _tmp348_;
						_tmp341_ = args;
						_tmp342_ = vala_collection_get_size ((ValaCollection*) _tmp341_);
						_tmp343_ = _tmp342_;
						_tmp344_ = m;
						_tmp345_ = vala_callable_get_parameters ((ValaCallable*) _tmp344_);
						_tmp346_ = _tmp345_;
						_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
						_tmp348_ = _tmp347_;
						_tmp339_ = _tmp343_ == (_tmp348_ - 1);
						_vala_iterable_unref0 (_tmp346_);
					} else {
						_tmp339_ = FALSE;
					}
					if (_tmp339_) {
						ValaStringLiteral* _tmp349_;
						ValaStringLiteral* _tmp350_;
						ValaSemanticAnalyzer* _tmp351_;
						ValaSemanticAnalyzer* _tmp352_;
						ValaDataType* _tmp353_;
						ValaDataType* _tmp354_;
						ValaDataType* _tmp355_;
						ValaList* _tmp356_;
						ValaList* _tmp357_;
						gint _tmp358_;
						gint _tmp359_;
						ValaStringLiteral* _tmp360_;
						ValaList* _tmp361_;
						ValaIterator* _tmp362_;
						_tmp349_ = vala_string_literal_new ("\"%s\"", NULL);
						_vala_code_node_unref0 (format_literal);
						format_literal = _tmp349_;
						_tmp350_ = format_literal;
						_tmp351_ = vala_code_context_get_analyzer (context);
						_tmp352_ = _tmp351_;
						_tmp353_ = _tmp352_->string_type;
						_tmp354_ = vala_data_type_copy (_tmp353_);
						_tmp355_ = _tmp354_;
						vala_expression_set_target_type ((ValaExpression*) _tmp350_, _tmp355_);
						_vala_code_node_unref0 (_tmp355_);
						_tmp356_ = self->priv->argument_list;
						_tmp357_ = args;
						_tmp358_ = vala_collection_get_size ((ValaCollection*) _tmp357_);
						_tmp359_ = _tmp358_;
						_tmp360_ = format_literal;
						vala_list_insert (_tmp356_, _tmp359_ - 1, (ValaExpression*) _tmp360_);
						_tmp361_ = self->priv->argument_list;
						_tmp362_ = vala_iterable_iterator ((ValaIterable*) _tmp361_);
						_vala_iterator_unref0 (arg_it);
						arg_it = _tmp362_;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp363_;
							ValaList* _tmp364_;
							gint _param_size = 0;
							ValaList* _tmp365_;
							gint _tmp366_;
							gint _tmp367_;
							gint _param_index = 0;
							_tmp363_ = m;
							_tmp364_ = vala_callable_get_parameters ((ValaCallable*) _tmp363_);
							_param_list = _tmp364_;
							_tmp365_ = _param_list;
							_tmp366_ = vala_collection_get_size ((ValaCollection*) _tmp365_);
							_tmp367_ = _tmp366_;
							_param_size = _tmp367_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp368_;
								gint _tmp369_;
								gint _tmp370_;
								ValaParameter* param = NULL;
								ValaList* _tmp371_;
								gint _tmp372_;
								gpointer _tmp373_;
								ValaParameter* _tmp374_;
								gboolean _tmp375_;
								gboolean _tmp376_;
								ValaIterator* _tmp377_;
								_tmp368_ = _param_index;
								_param_index = _tmp368_ + 1;
								_tmp369_ = _param_index;
								_tmp370_ = _param_size;
								if (!(_tmp369_ < _tmp370_)) {
									break;
								}
								_tmp371_ = _param_list;
								_tmp372_ = _param_index;
								_tmp373_ = vala_list_get (_tmp371_, _tmp372_);
								param = (ValaParameter*) _tmp373_;
								_tmp374_ = param;
								_tmp375_ = vala_parameter_get_ellipsis (_tmp374_);
								_tmp376_ = _tmp375_;
								if (_tmp376_) {
									_vala_code_node_unref0 (param);
									break;
								}
								_tmp377_ = arg_it;
								vala_iterator_next (_tmp377_);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
					}
				}
			}
			_tmp378_ = format_literal;
			if (_tmp378_ != NULL) {
				gchar* format = NULL;
				ValaStringLiteral* _tmp379_;
				gchar* _tmp380_;
				ValaSemanticAnalyzer* _tmp381_;
				ValaSemanticAnalyzer* _tmp382_;
				const gchar* _tmp383_;
				ValaIterator* _tmp384_;
				ValaSourceReference* _tmp385_;
				ValaSourceReference* _tmp386_;
				_tmp379_ = format_literal;
				_tmp380_ = vala_string_literal_eval (_tmp379_);
				format = _tmp380_;
				_tmp381_ = vala_code_context_get_analyzer (context);
				_tmp382_ = _tmp381_;
				_tmp383_ = format;
				_tmp384_ = arg_it;
				_tmp385_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp386_ = _tmp385_;
				if (!vala_semantic_analyzer_check_print_format (_tmp382_, _tmp383_, _tmp384_, _tmp386_)) {
					result = FALSE;
					_g_free0 (format);
					_vala_code_node_unref0 (format_literal);
					_vala_iterator_unref0 (arg_it);
					_vala_iterable_unref0 (args);
					_vala_code_node_unref0 (last_arg);
					_vala_code_node_unref0 (m);
					_vala_code_node_unref0 (type);
					return result;
				}
				_g_free0 (format);
			}
			_vala_code_node_unref0 (format_literal);
		}
		{
			ValaList* _arg_list = NULL;
			ValaList* _tmp387_;
			ValaList* _tmp388_;
			gint _arg_size = 0;
			ValaList* _tmp389_;
			gint _tmp390_;
			gint _tmp391_;
			gint _arg_index = 0;
			_tmp387_ = args;
			_tmp388_ = _vala_iterable_ref0 (_tmp387_);
			_arg_list = _tmp388_;
			_tmp389_ = _arg_list;
			_tmp390_ = vala_collection_get_size ((ValaCollection*) _tmp389_);
			_tmp391_ = _tmp390_;
			_arg_size = _tmp391_;
			_arg_index = -1;
			while (TRUE) {
				gint _tmp392_;
				gint _tmp393_;
				gint _tmp394_;
				ValaExpression* arg = NULL;
				ValaList* _tmp395_;
				gint _tmp396_;
				gpointer _tmp397_;
				ValaExpression* _tmp398_;
				_tmp392_ = _arg_index;
				_arg_index = _tmp392_ + 1;
				_tmp393_ = _arg_index;
				_tmp394_ = _arg_size;
				if (!(_tmp393_ < _tmp394_)) {
					break;
				}
				_tmp395_ = _arg_list;
				_tmp396_ = _arg_index;
				_tmp397_ = vala_list_get (_tmp395_, _tmp396_);
				arg = (ValaExpression*) _tmp397_;
				_tmp398_ = arg;
				vala_code_node_check ((ValaCodeNode*) _tmp398_, context);
				_vala_code_node_unref0 (arg);
			}
			_vala_iterable_unref0 (_arg_list);
		}
		_tmp399_ = vala_code_context_get_analyzer (context);
		_tmp400_ = _tmp399_;
		_tmp401_ = m;
		_tmp402_ = vala_method_type_new (_tmp401_);
		_tmp403_ = _tmp402_;
		_tmp404_ = m;
		_tmp405_ = vala_callable_get_parameters ((ValaCallable*) _tmp404_);
		_tmp406_ = _tmp405_;
		_tmp407_ = args;
		vala_semantic_analyzer_check_arguments (_tmp400_, (ValaExpression*) self, (ValaDataType*) _tmp403_, _tmp406_, _tmp407_);
		_vala_iterable_unref0 (_tmp406_);
		_vala_code_node_unref0 (_tmp403_);
		{
			ValaList* _error_type_list = NULL;
			ValaMethod* _tmp408_;
			ValaList* _tmp409_;
			gint _error_type_size = 0;
			ValaList* _tmp410_;
			gint _tmp411_;
			gint _tmp412_;
			gint _error_type_index = 0;
			_tmp408_ = m;
			_tmp409_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp408_);
			_error_type_list = _tmp409_;
			_tmp410_ = _error_type_list;
			_tmp411_ = vala_collection_get_size ((ValaCollection*) _tmp410_);
			_tmp412_ = _tmp411_;
			_error_type_size = _tmp412_;
			_error_type_index = -1;
			while (TRUE) {
				gint _tmp413_;
				gint _tmp414_;
				gint _tmp415_;
				ValaDataType* error_type = NULL;
				ValaList* _tmp416_;
				gint _tmp417_;
				gpointer _tmp418_;
				ValaDataType* call_error_type = NULL;
				ValaDataType* _tmp419_;
				ValaDataType* _tmp420_;
				ValaDataType* _tmp421_;
				ValaSourceReference* _tmp422_;
				ValaSourceReference* _tmp423_;
				ValaDataType* _tmp424_;
				_tmp413_ = _error_type_index;
				_error_type_index = _tmp413_ + 1;
				_tmp414_ = _error_type_index;
				_tmp415_ = _error_type_size;
				if (!(_tmp414_ < _tmp415_)) {
					break;
				}
				_tmp416_ = _error_type_list;
				_tmp417_ = _error_type_index;
				_tmp418_ = vala_list_get (_tmp416_, _tmp417_);
				error_type = (ValaDataType*) _tmp418_;
				may_throw = TRUE;
				_tmp419_ = error_type;
				_tmp420_ = vala_data_type_copy (_tmp419_);
				call_error_type = _tmp420_;
				_tmp421_ = call_error_type;
				_tmp422_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp423_ = _tmp422_;
				vala_code_node_set_source_reference ((ValaCodeNode*) _tmp421_, _tmp423_);
				_tmp424_ = call_error_type;
				vala_code_node_add_error_type ((ValaCodeNode*) self, _tmp424_);
				_vala_code_node_unref0 (call_error_type);
				_vala_code_node_unref0 (error_type);
			}
			_vala_iterable_unref0 (_error_type_list);
		}
		_vala_iterator_unref0 (arg_it);
		_vala_iterable_unref0 (args);
		_vala_code_node_unref0 (last_arg);
		_vala_code_node_unref0 (m);
	} else {
		ValaDataType* _tmp425_;
		ValaDataType* _tmp426_;
		_tmp425_ = vala_object_creation_expression_get_type_reference (self);
		_tmp426_ = _tmp425_;
		if (VALA_IS_ERROR_TYPE (_tmp426_)) {
			ValaDataType* _tmp427_;
			ValaDataType* _tmp428_;
			ValaMemberAccess* _tmp431_;
			ValaMemberAccess* _tmp432_;
			ValaList* _tmp459_;
			ValaList* _tmp460_;
			gint _tmp461_;
			gint _tmp462_;
			gboolean _tmp463_;
			_tmp427_ = vala_object_creation_expression_get_type_reference (self);
			_tmp428_ = _tmp427_;
			if (_tmp428_ != NULL) {
				ValaDataType* _tmp429_;
				ValaDataType* _tmp430_;
				_tmp429_ = vala_object_creation_expression_get_type_reference (self);
				_tmp430_ = _tmp429_;
				vala_code_node_check ((ValaCodeNode*) _tmp430_, context);
			}
			_tmp431_ = vala_object_creation_expression_get_member_name (self);
			_tmp432_ = _tmp431_;
			if (_tmp432_ != NULL) {
				ValaMemberAccess* _tmp433_;
				ValaMemberAccess* _tmp434_;
				_tmp433_ = vala_object_creation_expression_get_member_name (self);
				_tmp434_ = _tmp433_;
				vala_code_node_check ((ValaCodeNode*) _tmp434_, context);
			}
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp435_;
				ValaList* _tmp436_;
				gint _arg_size = 0;
				ValaList* _tmp437_;
				gint _tmp438_;
				gint _tmp439_;
				gint _arg_index = 0;
				_tmp435_ = self->priv->argument_list;
				_tmp436_ = _vala_iterable_ref0 (_tmp435_);
				_arg_list = _tmp436_;
				_tmp437_ = _arg_list;
				_tmp438_ = vala_collection_get_size ((ValaCollection*) _tmp437_);
				_tmp439_ = _tmp438_;
				_arg_size = _tmp439_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp440_;
					gint _tmp441_;
					gint _tmp442_;
					ValaExpression* arg = NULL;
					ValaList* _tmp443_;
					gint _tmp444_;
					gpointer _tmp445_;
					ValaExpression* _tmp446_;
					_tmp440_ = _arg_index;
					_arg_index = _tmp440_ + 1;
					_tmp441_ = _arg_index;
					_tmp442_ = _arg_size;
					if (!(_tmp441_ < _tmp442_)) {
						break;
					}
					_tmp443_ = _arg_list;
					_tmp444_ = _arg_index;
					_tmp445_ = vala_list_get (_tmp443_, _tmp444_);
					arg = (ValaExpression*) _tmp445_;
					_tmp446_ = arg;
					vala_code_node_check ((ValaCodeNode*) _tmp446_, context);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _init_list = NULL;
				ValaList* _tmp447_;
				ValaList* _tmp448_;
				gint _init_size = 0;
				ValaList* _tmp449_;
				gint _tmp450_;
				gint _tmp451_;
				gint _init_index = 0;
				_tmp447_ = self->priv->object_initializer;
				_tmp448_ = _vala_iterable_ref0 (_tmp447_);
				_init_list = _tmp448_;
				_tmp449_ = _init_list;
				_tmp450_ = vala_collection_get_size ((ValaCollection*) _tmp449_);
				_tmp451_ = _tmp450_;
				_init_size = _tmp451_;
				_init_index = -1;
				while (TRUE) {
					gint _tmp452_;
					gint _tmp453_;
					gint _tmp454_;
					ValaMemberInitializer* init = NULL;
					ValaList* _tmp455_;
					gint _tmp456_;
					gpointer _tmp457_;
					ValaMemberInitializer* _tmp458_;
					_tmp452_ = _init_index;
					_init_index = _tmp452_ + 1;
					_tmp453_ = _init_index;
					_tmp454_ = _init_size;
					if (!(_tmp453_ < _tmp454_)) {
						break;
					}
					_tmp455_ = _init_list;
					_tmp456_ = _init_index;
					_tmp457_ = vala_list_get (_tmp455_, _tmp456_);
					init = (ValaMemberInitializer*) _tmp457_;
					_tmp458_ = init;
					vala_code_node_check ((ValaCodeNode*) _tmp458_, context);
					_vala_code_node_unref0 (init);
				}
				_vala_iterable_unref0 (_init_list);
			}
			_tmp459_ = vala_object_creation_expression_get_argument_list (self);
			_tmp460_ = _tmp459_;
			_tmp461_ = vala_collection_get_size ((ValaCollection*) _tmp460_);
			_tmp462_ = _tmp461_;
			_tmp463_ = _tmp462_ == 0;
			_vala_iterable_unref0 (_tmp460_);
			if (_tmp463_) {
				ValaSourceReference* _tmp464_;
				ValaSourceReference* _tmp465_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp464_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp465_ = _tmp464_;
				vala_report_error (_tmp465_, "Too few arguments, errors need at least 1 argument");
			} else {
				ValaIterator* arg_it = NULL;
				ValaList* _tmp466_;
				ValaList* _tmp467_;
				ValaIterator* _tmp468_;
				ValaIterator* _tmp469_;
				ValaIterator* _tmp470_;
				ValaExpression* ex = NULL;
				ValaIterator* _tmp471_;
				gpointer _tmp472_;
				gboolean _tmp473_ = FALSE;
				ValaExpression* _tmp474_;
				ValaDataType* _tmp475_;
				ValaDataType* _tmp476_;
				ValaStringLiteral* format_literal = NULL;
				ValaExpression* _tmp485_;
				ValaStringLiteral* _tmp486_;
				ValaStringLiteral* _tmp487_;
				ValaList* _tmp496_;
				ValaList* _tmp497_;
				ValaIterator* _tmp498_;
				ValaIterator* _tmp499_;
				ValaSemanticAnalyzer* _tmp500_;
				ValaSemanticAnalyzer* _tmp501_;
				ValaIterator* _tmp502_;
				ValaSourceReference* _tmp503_;
				ValaSourceReference* _tmp504_;
				_tmp466_ = vala_object_creation_expression_get_argument_list (self);
				_tmp467_ = _tmp466_;
				_tmp468_ = vala_iterable_iterator ((ValaIterable*) _tmp467_);
				_tmp469_ = _tmp468_;
				_vala_iterable_unref0 (_tmp467_);
				arg_it = _tmp469_;
				_tmp470_ = arg_it;
				vala_iterator_next (_tmp470_);
				_tmp471_ = arg_it;
				_tmp472_ = vala_iterator_get (_tmp471_);
				ex = (ValaExpression*) _tmp472_;
				_tmp474_ = ex;
				_tmp475_ = vala_expression_get_value_type (_tmp474_);
				_tmp476_ = _tmp475_;
				if (_tmp476_ == NULL) {
					_tmp473_ = TRUE;
				} else {
					ValaExpression* _tmp477_;
					ValaDataType* _tmp478_;
					ValaDataType* _tmp479_;
					ValaSemanticAnalyzer* _tmp480_;
					ValaSemanticAnalyzer* _tmp481_;
					ValaDataType* _tmp482_;
					_tmp477_ = ex;
					_tmp478_ = vala_expression_get_value_type (_tmp477_);
					_tmp479_ = _tmp478_;
					_tmp480_ = vala_code_context_get_analyzer (context);
					_tmp481_ = _tmp480_;
					_tmp482_ = _tmp481_->string_type;
					_tmp473_ = !vala_data_type_compatible (_tmp479_, _tmp482_);
				}
				if (_tmp473_) {
					ValaSourceReference* _tmp483_;
					ValaSourceReference* _tmp484_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp483_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp484_ = _tmp483_;
					vala_report_error (_tmp484_, "Invalid type for argument 1");
				}
				_tmp485_ = ex;
				_tmp486_ = vala_string_literal_get_format_literal (_tmp485_);
				format_literal = _tmp486_;
				_tmp487_ = format_literal;
				if (_tmp487_ != NULL) {
					gchar* format = NULL;
					ValaStringLiteral* _tmp488_;
					gchar* _tmp489_;
					ValaSemanticAnalyzer* _tmp490_;
					ValaSemanticAnalyzer* _tmp491_;
					const gchar* _tmp492_;
					ValaIterator* _tmp493_;
					ValaSourceReference* _tmp494_;
					ValaSourceReference* _tmp495_;
					_tmp488_ = format_literal;
					_tmp489_ = vala_string_literal_eval (_tmp488_);
					format = _tmp489_;
					_tmp490_ = vala_code_context_get_analyzer (context);
					_tmp491_ = _tmp490_;
					_tmp492_ = format;
					_tmp493_ = arg_it;
					_tmp494_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp495_ = _tmp494_;
					if (!vala_semantic_analyzer_check_print_format (_tmp491_, _tmp492_, _tmp493_, _tmp495_)) {
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						result = FALSE;
						_g_free0 (format);
						_vala_code_node_unref0 (format_literal);
						_vala_code_node_unref0 (ex);
						_vala_iterator_unref0 (arg_it);
						_vala_code_node_unref0 (type);
						return result;
					}
					_g_free0 (format);
				}
				_tmp496_ = vala_object_creation_expression_get_argument_list (self);
				_tmp497_ = _tmp496_;
				_tmp498_ = vala_iterable_iterator ((ValaIterable*) _tmp497_);
				_vala_iterator_unref0 (arg_it);
				arg_it = _tmp498_;
				_vala_iterable_unref0 (_tmp497_);
				_tmp499_ = arg_it;
				vala_iterator_next (_tmp499_);
				_tmp500_ = vala_code_context_get_analyzer (context);
				_tmp501_ = _tmp500_;
				_tmp502_ = arg_it;
				_tmp503_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp504_ = _tmp503_;
				if (!vala_semantic_analyzer_check_variadic_arguments (_tmp501_, _tmp502_, 1, _tmp504_)) {
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					result = FALSE;
					_vala_code_node_unref0 (format_literal);
					_vala_code_node_unref0 (ex);
					_vala_iterator_unref0 (arg_it);
					_vala_code_node_unref0 (type);
					return result;
				}
				_vala_code_node_unref0 (format_literal);
				_vala_code_node_unref0 (ex);
				_vala_iterator_unref0 (arg_it);
			}
		}
	}
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp505_;
		gint _arg_size = 0;
		ValaList* _tmp506_;
		gint _tmp507_;
		gint _tmp508_;
		gint _arg_index = 0;
		_tmp505_ = vala_object_creation_expression_get_argument_list (self);
		_arg_list = _tmp505_;
		_tmp506_ = _arg_list;
		_tmp507_ = vala_collection_get_size ((ValaCollection*) _tmp506_);
		_tmp508_ = _tmp507_;
		_arg_size = _tmp508_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp509_;
			gint _tmp510_;
			gint _tmp511_;
			ValaExpression* arg = NULL;
			ValaList* _tmp512_;
			gint _tmp513_;
			gpointer _tmp514_;
			ValaSizeofExpression* sizeof_expr = NULL;
			ValaExpression* _tmp515_;
			gboolean _tmp516_ = FALSE;
			ValaSizeofExpression* _tmp517_;
			_tmp509_ = _arg_index;
			_arg_index = _tmp509_ + 1;
			_tmp510_ = _arg_index;
			_tmp511_ = _arg_size;
			if (!(_tmp510_ < _tmp511_)) {
				break;
			}
			_tmp512_ = _arg_list;
			_tmp513_ = _arg_index;
			_tmp514_ = vala_list_get (_tmp512_, _tmp513_);
			arg = (ValaExpression*) _tmp514_;
			_tmp515_ = arg;
			sizeof_expr = VALA_IS_SIZEOF_EXPRESSION (_tmp515_) ? ((ValaSizeofExpression*) _tmp515_) : NULL;
			_tmp517_ = sizeof_expr;
			if (_tmp517_ != NULL) {
				ValaSizeofExpression* _tmp518_;
				ValaDataType* _tmp519_;
				ValaDataType* _tmp520_;
				_tmp518_ = sizeof_expr;
				_tmp519_ = vala_sizeof_expression_get_type_reference (_tmp518_);
				_tmp520_ = _tmp519_;
				_tmp516_ = VALA_IS_GENERIC_TYPE (_tmp520_);
			} else {
				_tmp516_ = FALSE;
			}
			if (_tmp516_) {
				ValaDataType* sizeof_type = NULL;
				ValaSizeofExpression* _tmp521_;
				ValaDataType* _tmp522_;
				ValaDataType* _tmp523_;
				ValaDataType* _tmp524_;
				ValaDataType* _tmp525_;
				ValaDataType* _tmp526_;
				ValaDataType* _tmp527_;
				ValaList* _tmp528_;
				ValaList* _tmp529_;
				ValaDataType* _tmp530_;
				ValaDataType* _tmp531_;
				ValaExpression* _tmp532_;
				ValaDataType* _tmp533_;
				ValaSourceReference* _tmp534_;
				ValaSourceReference* _tmp535_;
				ValaSizeofExpression* _tmp536_;
				ValaSizeofExpression* _tmp537_;
				_tmp521_ = sizeof_expr;
				_tmp522_ = vala_sizeof_expression_get_type_reference (_tmp521_);
				_tmp523_ = _tmp522_;
				_tmp524_ = vala_object_creation_expression_get_type_reference (self);
				_tmp525_ = _tmp524_;
				_tmp526_ = vala_object_creation_expression_get_type_reference (self);
				_tmp527_ = _tmp526_;
				_tmp528_ = vala_data_type_get_type_arguments (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp530_ = vala_data_type_get_actual_type (_tmp523_, _tmp525_, _tmp529_, (ValaCodeNode*) self);
				_tmp531_ = _tmp530_;
				_vala_iterable_unref0 (_tmp529_);
				sizeof_type = _tmp531_;
				_tmp532_ = arg;
				_tmp533_ = sizeof_type;
				_tmp534_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp535_ = _tmp534_;
				_tmp536_ = vala_sizeof_expression_new (_tmp533_, _tmp535_);
				_tmp537_ = _tmp536_;
				vala_code_node_replace_expression ((ValaCodeNode*) self, _tmp532_, (ValaExpression*) _tmp537_);
				_vala_code_node_unref0 (_tmp537_);
				_vala_code_node_unref0 (sizeof_type);
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp538_;
		gint _init_size = 0;
		ValaList* _tmp539_;
		gint _tmp540_;
		gint _tmp541_;
		gint _init_index = 0;
		_tmp538_ = vala_object_creation_expression_get_object_initializer (self);
		_init_list = _tmp538_;
		_tmp539_ = _init_list;
		_tmp540_ = vala_collection_get_size ((ValaCollection*) _tmp539_);
		_tmp541_ = _tmp540_;
		_init_size = _tmp541_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp542_;
			gint _tmp543_;
			gint _tmp544_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp545_;
			gint _tmp546_;
			gpointer _tmp547_;
			ValaSemanticAnalyzer* _tmp548_;
			ValaSemanticAnalyzer* _tmp549_;
			ValaMemberInitializer* _tmp550_;
			ValaDataType* _tmp551_;
			ValaDataType* _tmp552_;
			_tmp542_ = _init_index;
			_init_index = _tmp542_ + 1;
			_tmp543_ = _init_index;
			_tmp544_ = _init_size;
			if (!(_tmp543_ < _tmp544_)) {
				break;
			}
			_tmp545_ = _init_list;
			_tmp546_ = _init_index;
			_tmp547_ = vala_list_get (_tmp545_, _tmp546_);
			init = (ValaMemberInitializer*) _tmp547_;
			_tmp548_ = vala_code_context_get_analyzer (context);
			_tmp549_ = _tmp548_;
			_tmp550_ = init;
			_tmp551_ = vala_object_creation_expression_get_type_reference (self);
			_tmp552_ = _tmp551_;
			vala_semantic_analyzer_visit_member_initializer (_tmp549_, _tmp550_, _tmp552_);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	_tmp553_ = may_throw;
	if (_tmp553_) {
		gboolean _tmp554_ = FALSE;
		ValaCodeNode* _tmp555_;
		ValaCodeNode* _tmp556_;
		_tmp555_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
		_tmp556_ = _tmp555_;
		if (VALA_IS_LOCAL_VARIABLE (_tmp556_)) {
			_tmp554_ = TRUE;
		} else {
			ValaCodeNode* _tmp557_;
			ValaCodeNode* _tmp558_;
			_tmp557_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
			_tmp558_ = _tmp557_;
			_tmp554_ = VALA_IS_EXPRESSION_STATEMENT (_tmp558_);
		}
		if (_tmp554_) {
		} else {
			ValaSemanticAnalyzer* _tmp559_;
			ValaSemanticAnalyzer* _tmp560_;
			ValaSymbol* _tmp561_;
			ValaSymbol* _tmp562_;
			_tmp559_ = vala_code_context_get_analyzer (context);
			_tmp560_ = _tmp559_;
			_tmp561_ = vala_semantic_analyzer_get_current_symbol (_tmp560_);
			_tmp562_ = _tmp561_;
			if (!VALA_IS_BLOCK (_tmp562_)) {
				ValaSourceReference* _tmp563_;
				ValaSourceReference* _tmp564_;
				_tmp563_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp564_ = _tmp563_;
				vala_report_error (_tmp564_, "Field initializers must not throw errors");
			} else {
				ValaCodeNode* old_parent_node = NULL;
				ValaCodeNode* _tmp565_;
				ValaCodeNode* _tmp566_;
				ValaCodeNode* _tmp567_;
				ValaLocalVariable* local = NULL;
				ValaDataType* _tmp568_;
				ValaDataType* _tmp569_;
				ValaDataType* _tmp570_;
				ValaDataType* _tmp571_;
				gchar* _tmp572_;
				gchar* _tmp573_;
				ValaSourceReference* _tmp574_;
				ValaSourceReference* _tmp575_;
				ValaLocalVariable* _tmp576_;
				ValaLocalVariable* _tmp577_;
				ValaDeclarationStatement* decl = NULL;
				ValaLocalVariable* _tmp578_;
				ValaSourceReference* _tmp579_;
				ValaSourceReference* _tmp580_;
				ValaDeclarationStatement* _tmp581_;
				ValaSemanticAnalyzer* _tmp582_;
				ValaSemanticAnalyzer* _tmp583_;
				ValaBlock* _tmp584_;
				ValaDeclarationStatement* _tmp585_;
				ValaExpression* temp_access = NULL;
				ValaLocalVariable* _tmp586_;
				ValaDataType* _tmp587_;
				ValaDataType* _tmp588_;
				ValaExpression* _tmp589_;
				ValaLocalVariable* _tmp590_;
				ValaDeclarationStatement* _tmp591_;
				ValaBlock* block = NULL;
				ValaSemanticAnalyzer* _tmp592_;
				ValaSemanticAnalyzer* _tmp593_;
				ValaSymbol* _tmp594_;
				ValaSymbol* _tmp595_;
				ValaBlock* _tmp596_;
				ValaBlock* _tmp597_;
				ValaLocalVariable* _tmp598_;
				ValaSemanticAnalyzer* _tmp599_;
				ValaSemanticAnalyzer* _tmp600_;
				ValaBlock* _tmp601_;
				ValaLocalVariable* _tmp602_;
				ValaCodeNode* _tmp603_;
				ValaExpression* _tmp604_;
				ValaExpression* _tmp605_;
				_tmp565_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp566_ = _tmp565_;
				_tmp567_ = _vala_code_node_ref0 (_tmp566_);
				old_parent_node = _tmp567_;
				_tmp568_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp569_ = _tmp568_;
				_tmp570_ = vala_data_type_copy (_tmp569_);
				_tmp571_ = _tmp570_;
				_tmp572_ = vala_code_node_get_temp_name ();
				_tmp573_ = _tmp572_;
				_tmp574_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp575_ = _tmp574_;
				_tmp576_ = vala_local_variable_new (_tmp571_, _tmp573_, NULL, _tmp575_);
				_tmp577_ = _tmp576_;
				_g_free0 (_tmp573_);
				_vala_code_node_unref0 (_tmp571_);
				local = _tmp577_;
				_tmp578_ = local;
				_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp580_ = _tmp579_;
				_tmp581_ = vala_declaration_statement_new ((ValaSymbol*) _tmp578_, _tmp580_);
				decl = _tmp581_;
				_tmp582_ = vala_code_context_get_analyzer (context);
				_tmp583_ = _tmp582_;
				_tmp584_ = _tmp583_->insert_block;
				_tmp585_ = decl;
				vala_expression_insert_statement ((ValaExpression*) self, _tmp584_, (ValaStatement*) _tmp585_);
				_tmp586_ = local;
				_tmp587_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp588_ = _tmp587_;
				_tmp589_ = vala_semantic_analyzer_create_temp_access (_tmp586_, _tmp588_);
				temp_access = _tmp589_;
				_tmp590_ = local;
				vala_variable_set_initializer ((ValaVariable*) _tmp590_, (ValaExpression*) self);
				_tmp591_ = decl;
				vala_code_node_check ((ValaCodeNode*) _tmp591_, context);
				_tmp592_ = vala_code_context_get_analyzer (context);
				_tmp593_ = _tmp592_;
				_tmp594_ = vala_semantic_analyzer_get_current_symbol (_tmp593_);
				_tmp595_ = _tmp594_;
				_tmp596_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp595_, VALA_TYPE_BLOCK, ValaBlock));
				block = _tmp596_;
				_tmp597_ = block;
				_tmp598_ = local;
				vala_block_remove_local_variable (_tmp597_, _tmp598_);
				_tmp599_ = vala_code_context_get_analyzer (context);
				_tmp600_ = _tmp599_;
				_tmp601_ = _tmp600_->insert_block;
				_tmp602_ = local;
				vala_block_add_local_variable (_tmp601_, _tmp602_);
				_tmp603_ = old_parent_node;
				_tmp604_ = temp_access;
				vala_code_node_replace_expression (_tmp603_, (ValaExpression*) self, _tmp604_);
				_tmp605_ = temp_access;
				vala_code_node_check ((ValaCodeNode*) _tmp605_, context);
				_vala_code_node_unref0 (block);
				_vala_code_node_unref0 (temp_access);
				_vala_code_node_unref0 (decl);
				_vala_code_node_unref0 (local);
				_vala_code_node_unref0 (old_parent_node);
			}
		}
	}
	_tmp606_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp607_ = _tmp606_;
	result = !_tmp607_;
	_vala_code_node_unref0 (type);
	return result;
}


static void
vala_object_creation_expression_real_emit (ValaCodeNode* base,
                                           ValaCodeGenerator* codegen)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (codegen != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_emit ((ValaCodeNode*) _tmp11_, codegen);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_emit ((ValaCodeNode*) _tmp23_, codegen);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
	vala_code_visitor_visit_object_creation_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_object_creation_expression_real_get_defined_variables (ValaCodeNode* base,
                                                            ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
}


static void
vala_object_creation_expression_real_get_used_variables (ValaCodeNode* base,
                                                         ValaCollection* collection)
{
	ValaObjectCreationExpression * self;
	self = (ValaObjectCreationExpression*) base;
	g_return_if_fail (collection != NULL);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _arg_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _arg_index = 0;
		_tmp0_ = self->priv->argument_list;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_arg_list = _tmp1_;
		_tmp2_ = _arg_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_arg_size = _tmp4_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaExpression* arg = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaExpression* _tmp11_;
			_tmp5_ = _arg_index;
			_arg_index = _tmp5_ + 1;
			_tmp6_ = _arg_index;
			_tmp7_ = _arg_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _arg_list;
			_tmp9_ = _arg_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			arg = (ValaExpression*) _tmp10_;
			_tmp11_ = arg;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp11_, collection);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	{
		ValaList* _init_list = NULL;
		ValaList* _tmp12_;
		ValaList* _tmp13_;
		gint _init_size = 0;
		ValaList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _init_index = 0;
		_tmp12_ = self->priv->object_initializer;
		_tmp13_ = _vala_iterable_ref0 (_tmp12_);
		_init_list = _tmp13_;
		_tmp14_ = _init_list;
		_tmp15_ = vala_collection_get_size ((ValaCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_init_size = _tmp16_;
		_init_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			ValaMemberInitializer* init = NULL;
			ValaList* _tmp20_;
			gint _tmp21_;
			gpointer _tmp22_;
			ValaMemberInitializer* _tmp23_;
			_tmp17_ = _init_index;
			_init_index = _tmp17_ + 1;
			_tmp18_ = _init_index;
			_tmp19_ = _init_size;
			if (!(_tmp18_ < _tmp19_)) {
				break;
			}
			_tmp20_ = _init_list;
			_tmp21_ = _init_index;
			_tmp22_ = vala_list_get (_tmp20_, _tmp21_);
			init = (ValaMemberInitializer*) _tmp22_;
			_tmp23_ = init;
			vala_code_node_get_used_variables ((ValaCodeNode*) _tmp23_, collection);
			_vala_code_node_unref0 (init);
		}
		_vala_iterable_unref0 (_init_list);
	}
}


ValaDataType*
vala_object_creation_expression_get_type_reference (ValaObjectCreationExpression* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_type_reference (ValaObjectCreationExpression* self,
                                                    ValaDataType* value)
{
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	_tmp1_ = self->priv->_data_type;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaMemberAccess*
vala_object_creation_expression_get_member_name (ValaObjectCreationExpression* self)
{
	ValaMemberAccess* result;
	ValaMemberAccess* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_member_name (ValaObjectCreationExpression* self,
                                                 ValaMemberAccess* value)
{
	ValaMemberAccess* _tmp0_;
	ValaMemberAccess* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
	_tmp1_ = self->priv->_member_name;
	if (_tmp1_ != NULL) {
		ValaMemberAccess* _tmp2_;
		_tmp2_ = self->priv->_member_name;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


gboolean
vala_object_creation_expression_get_is_yield_expression (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_yield_expression;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_is_yield_expression (ValaObjectCreationExpression* self,
                                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_yield_expression = value;
}


gboolean
vala_object_creation_expression_get_struct_creation (ValaObjectCreationExpression* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_struct_creation;
	result = _tmp0_;
	return result;
}


void
vala_object_creation_expression_set_struct_creation (ValaObjectCreationExpression* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_struct_creation = value;
}


static void
vala_object_creation_expression_class_init (ValaObjectCreationExpressionClass * klass)
{
	vala_object_creation_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_object_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaObjectCreationExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_object_creation_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_object_creation_expression_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_object_creation_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_object_creation_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_object_creation_expression_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_object_creation_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_object_creation_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_object_creation_expression_real_get_used_variables;
}


static void
vala_object_creation_expression_instance_init (ValaObjectCreationExpression * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	GEqualFunc _tmp2_;
	ValaArrayList* _tmp3_;
	self->priv = VALA_OBJECT_CREATION_EXPRESSION_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_EXPRESSION, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->argument_list = (ValaList*) _tmp1_;
	_tmp2_ = g_direct_equal;
	_tmp3_ = vala_array_list_new (VALA_TYPE_MEMBER_INITIALIZER, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp2_);
	self->priv->object_initializer = (ValaList*) _tmp3_;
}


static void
vala_object_creation_expression_finalize (ValaCodeNode * obj)
{
	ValaObjectCreationExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_OBJECT_CREATION_EXPRESSION, ValaObjectCreationExpression);
	_vala_iterable_unref0 (self->priv->argument_list);
	_vala_iterable_unref0 (self->priv->object_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_member_name);
	VALA_CODE_NODE_CLASS (vala_object_creation_expression_parent_class)->finalize (obj);
}


/**
 * Represents an object creation expression in the source code.
 */
GType
vala_object_creation_expression_get_type (void)
{
	static volatile gsize vala_object_creation_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_object_creation_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaObjectCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_object_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaObjectCreationExpression), 0, (GInstanceInitFunc) vala_object_creation_expression_instance_init, NULL };
		GType vala_object_creation_expression_type_id;
		vala_object_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaObjectCreationExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_object_creation_expression_type_id__volatile, vala_object_creation_expression_type_id);
	}
	return vala_object_creation_expression_type_id__volatile;
}



