/* valamemberaccess.c generated by valac, the Vala compiler
 * generated from valamemberaccess.vala, do not modify */

/* valamemberaccess.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

struct _ValaMemberAccessPrivate {
	gchar* _member_name;
	gboolean _pointer_member_access;
	gboolean _prototype_access;
	gboolean _creation_member;
	gboolean _qualified;
	ValaExpression* _inner;
	ValaList* type_argument_list;
};


static gpointer vala_member_access_parent_class = NULL;

#define VALA_MEMBER_ACCESS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_MEMBER_ACCESS, ValaMemberAccessPrivate))
static void vala_member_access_real_accept (ValaCodeNode* base,
                                     ValaCodeVisitor* visitor);
static void vala_member_access_real_accept_children (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static gchar* vala_member_access_real_to_string (ValaCodeNode* base);
static void vala_member_access_real_replace_expression (ValaCodeNode* base,
                                                 ValaExpression* old_node,
                                                 ValaExpression* new_node);
static gboolean vala_member_access_real_is_pure (ValaExpression* base);
static gboolean vala_member_access_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym);
static void vala_member_access_real_replace_type (ValaCodeNode* base,
                                           ValaDataType* old_type,
                                           ValaDataType* new_type);
static gboolean vala_member_access_real_is_constant (ValaExpression* base);
static gboolean vala_member_access_real_is_non_null (ValaExpression* base);
static gboolean vala_member_access_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context);
static gboolean vala_member_access_is_instance_symbol (ValaSymbol* symbol);
static void vala_member_access_real_emit (ValaCodeNode* base,
                                   ValaCodeGenerator* codegen);
static void vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                                 ValaCollection* collection);
static void vala_member_access_finalize (ValaCodeNode * obj);


/**
 * Creates a new member access expression.
 *
 * @param inner            parent of the member
 * @param member_name      member name
 * @param source_reference reference to source code
 * @return                 newly created member access expression
 */
ValaMemberAccess*
vala_member_access_construct (GType object_type,
                              ValaExpression* inner,
                              const gchar* member_name,
                              ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new (ValaExpression* inner,
                        const gchar* member_name,
                        ValaSourceReference* source_reference)
{
	return vala_member_access_construct (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_simple (GType object_type,
                                     const gchar* member_name,
                                     ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	return self;
}


ValaMemberAccess*
vala_member_access_new_simple (const gchar* member_name,
                               ValaSourceReference* source_reference)
{
	return vala_member_access_construct_simple (VALA_TYPE_MEMBER_ACCESS, member_name, source_reference);
}


ValaMemberAccess*
vala_member_access_construct_pointer (GType object_type,
                                      ValaExpression* inner,
                                      const gchar* member_name,
                                      ValaSourceReference* source_reference)
{
	ValaMemberAccess* self = NULL;
	g_return_val_if_fail (inner != NULL, NULL);
	g_return_val_if_fail (member_name != NULL, NULL);
	self = (ValaMemberAccess*) vala_expression_construct (object_type);
	vala_member_access_set_inner (self, inner);
	vala_member_access_set_member_name (self, member_name);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source_reference);
	vala_member_access_set_pointer_member_access (self, TRUE);
	return self;
}


ValaMemberAccess*
vala_member_access_new_pointer (ValaExpression* inner,
                                const gchar* member_name,
                                ValaSourceReference* source_reference)
{
	return vala_member_access_construct_pointer (VALA_TYPE_MEMBER_ACCESS, inner, member_name, source_reference);
}


/**
 * Appends the specified type as generic type argument.
 *
 * @param arg a type reference
 */
void
vala_member_access_add_type_argument (ValaMemberAccess* self,
                                      ValaDataType* arg)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg != NULL);
	_tmp0_ = self->priv->type_argument_list;
	vala_collection_add ((ValaCollection*) _tmp0_, arg);
	vala_code_node_set_parent_node ((ValaCodeNode*) arg, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the list of generic type arguments.
 *
 * @return type argument list
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_member_access_get_type_arguments (ValaMemberAccess* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->type_argument_list;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


static void
vala_member_access_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_member_access (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_member_access_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp4_;
		ValaList* _tmp5_;
		gint _type_arg_size = 0;
		ValaList* _tmp6_;
		gint _tmp7_;
		gint _tmp8_;
		gint _type_arg_index = 0;
		_tmp4_ = self->priv->type_argument_list;
		_tmp5_ = _vala_iterable_ref0 (_tmp4_);
		_type_arg_list = _tmp5_;
		_tmp6_ = _type_arg_list;
		_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_type_arg_size = _tmp8_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp9_;
			gint _tmp10_;
			gint _tmp11_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp12_;
			gint _tmp13_;
			gpointer _tmp14_;
			ValaDataType* _tmp15_;
			_tmp9_ = _type_arg_index;
			_type_arg_index = _tmp9_ + 1;
			_tmp10_ = _type_arg_index;
			_tmp11_ = _type_arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _type_arg_list;
			_tmp13_ = _type_arg_index;
			_tmp14_ = vala_list_get (_tmp12_, _tmp13_);
			type_arg = (ValaDataType*) _tmp14_;
			_tmp15_ = type_arg;
			vala_code_node_accept ((ValaCodeNode*) _tmp15_, visitor);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
}


static gchar*
vala_member_access_real_to_string (ValaCodeNode* base)
{
	ValaMemberAccess * self;
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	self = (ValaMemberAccess*) base;
	_tmp1_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp4_ = _tmp3_;
		_tmp0_ = vala_symbol_is_instance_member (_tmp4_);
	}
	if (_tmp0_) {
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		_tmp5_ = vala_member_access_get_inner (self);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == NULL) {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp7_ = self->priv->_member_name;
			_tmp8_ = g_strdup (_tmp7_);
			result = _tmp8_;
			return result;
		} else {
			const gchar* _tmp9_ = NULL;
			gboolean _tmp10_;
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			_tmp10_ = self->priv->_pointer_member_access;
			if (_tmp10_) {
				_tmp9_ = "->";
			} else {
				_tmp9_ = ".";
			}
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_code_node_to_string ((ValaCodeNode*) _tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = self->priv->_member_name;
			_tmp16_ = g_strdup_printf ("%s%s%s", _tmp14_, _tmp9_, _tmp15_);
			_tmp17_ = _tmp16_;
			_g_free0 (_tmp14_);
			result = _tmp17_;
			return result;
		}
	} else {
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		gchar* _tmp20_;
		_tmp18_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_symbol_get_full_name (_tmp19_);
		result = _tmp20_;
		return result;
	}
}


static void
vala_member_access_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_member_access_set_inner (self, new_node);
	}
}


static gboolean
vala_member_access_real_is_pure (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = !VALA_IS_PROPERTY (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_member_access_real_is_accessible (ValaExpression* base,
                                       ValaSymbol* sym)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_member_access_get_inner (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_member_access_get_inner (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	}
	if (_tmp1_) {
		ValaSymbol* _tmp6_;
		ValaSymbol* _tmp7_;
		_tmp6_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_symbol_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static void
vala_member_access_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type)
{
	ValaMemberAccess * self;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->type_argument_list;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->type_argument_list;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->type_argument_list;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					return;
				}
			}
		}
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_member_access_real_is_constant (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaMethod* method = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaMethod* _tmp2_;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1_) ? ((ValaMethod*) _tmp1_) : NULL);
	method = _tmp2_;
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_CONSTANT (_tmp4_)) {
		result = TRUE;
		_vala_code_node_unref0 (method);
		return result;
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp8_ = _tmp7_;
		if (VALA_IS_ARRAY_LENGTH_FIELD (_tmp8_)) {
			ValaExpression* _tmp9_;
			ValaExpression* _tmp10_;
			_tmp9_ = vala_member_access_get_inner (self);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ != NULL;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			ValaExpression* _tmp11_;
			ValaExpression* _tmp12_;
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			_tmp11_ = vala_member_access_get_inner (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = vala_expression_get_symbol_reference (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp5_ = VALA_IS_CONSTANT (_tmp14_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			_vala_code_node_unref0 (method);
			return result;
		} else {
			gboolean _tmp15_ = FALSE;
			ValaMethod* _tmp16_;
			_tmp16_ = method;
			if (_tmp16_ != NULL) {
				gboolean _tmp17_ = FALSE;
				ValaMethod* _tmp18_;
				ValaMemberBinding _tmp19_;
				ValaMemberBinding _tmp20_;
				_tmp18_ = method;
				_tmp19_ = vala_method_get_binding (_tmp18_);
				_tmp20_ = _tmp19_;
				if (_tmp20_ == VALA_MEMBER_BINDING_STATIC) {
					_tmp17_ = TRUE;
				} else {
					gboolean _tmp21_;
					_tmp21_ = self->priv->_prototype_access;
					_tmp17_ = _tmp21_;
				}
				_tmp15_ = _tmp17_;
			} else {
				_tmp15_ = FALSE;
			}
			if (_tmp15_) {
				result = TRUE;
				_vala_code_node_unref0 (method);
				return result;
			} else {
				result = FALSE;
				_vala_code_node_unref0 (method);
				return result;
			}
		}
	}
	_vala_code_node_unref0 (method);
}


static gboolean
vala_member_access_real_is_non_null (ValaExpression* base)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	ValaConstant* c = NULL;
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaConstant* _tmp2_;
	ValaConstant* _tmp3_;
	self = (ValaMemberAccess*) base;
	_tmp0_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (VALA_IS_CONSTANT (_tmp1_) ? ((ValaConstant*) _tmp1_) : NULL);
	c = _tmp2_;
	_tmp3_ = c;
	if (_tmp3_ != NULL) {
		gboolean _tmp4_ = FALSE;
		ValaConstant* _tmp5_;
		_tmp5_ = c;
		if (VALA_IS_ENUM_VALUE (_tmp5_)) {
			_tmp4_ = TRUE;
		} else {
			ValaConstant* _tmp6_;
			ValaDataType* _tmp7_;
			ValaDataType* _tmp8_;
			gboolean _tmp9_;
			gboolean _tmp10_;
			_tmp6_ = c;
			_tmp7_ = vala_constant_get_type_reference (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_data_type_get_nullable (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp4_ = !_tmp10_;
		}
		result = _tmp4_;
		_vala_code_node_unref0 (c);
		return result;
	} else {
		result = FALSE;
		_vala_code_node_unref0 (c);
		return result;
	}
	_vala_code_node_unref0 (c);
}


static gboolean
vala_member_access_real_check (ValaCodeNode* base,
                               ValaCodeContext* context)
{
	ValaMemberAccess * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaSymbol* base_symbol = NULL;
	ValaParameter* this_parameter = NULL;
	gboolean may_access_instance_members = FALSE;
	gboolean may_access_klass_members = FALSE;
	gboolean _tmp20_;
	gboolean _tmp581_ = FALSE;
	gboolean _tmp582_ = FALSE;
	ValaSymbol* _tmp583_;
	ValaSymbol* _tmp584_;
	ValaSymbol* _tmp612_;
	ValaSymbol* _tmp613_;
	ValaSymbol* member = NULL;
	ValaSymbol* _tmp636_;
	ValaSymbol* _tmp637_;
	ValaSymbol* _tmp638_;
	ValaSymbolAccessibility access = 0;
	gboolean instance = FALSE;
	gboolean klass = FALSE;
	gboolean generics = FALSE;
	ValaSymbol* _tmp639_;
	ValaSymbol* _tmp640_;
	ValaSymbol* _tmp1067_;
	ValaSymbol* _tmp1068_;
	ValaVersionAttribute* _tmp1069_;
	ValaVersionAttribute* _tmp1070_;
	ValaSourceReference* _tmp1071_;
	ValaSourceReference* _tmp1072_;
	gboolean _tmp1073_ = FALSE;
	ValaSymbolAccessibility _tmp1074_;
	gboolean _tmp1135_ = FALSE;
	gboolean _tmp1136_;
	gboolean _tmp1175_ = FALSE;
	gboolean _tmp1176_ = FALSE;
	gboolean _tmp1177_;
	gboolean _tmp1447_;
	gboolean _tmp1448_;
	self = (ValaMemberAccess*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_member_access_get_inner (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_member_access_get_inner (self);
		_tmp7_ = _tmp6_;
		vala_code_node_check ((ValaCodeNode*) _tmp7_, context);
	}
	{
		ValaList* _type_arg_list = NULL;
		ValaList* _tmp8_;
		ValaList* _tmp9_;
		gint _type_arg_size = 0;
		ValaList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _type_arg_index = 0;
		_tmp8_ = self->priv->type_argument_list;
		_tmp9_ = _vala_iterable_ref0 (_tmp8_);
		_type_arg_list = _tmp9_;
		_tmp10_ = _type_arg_list;
		_tmp11_ = vala_collection_get_size ((ValaCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_type_arg_size = _tmp12_;
		_type_arg_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			ValaDataType* type_arg = NULL;
			ValaList* _tmp16_;
			gint _tmp17_;
			gpointer _tmp18_;
			ValaDataType* _tmp19_;
			_tmp13_ = _type_arg_index;
			_type_arg_index = _tmp13_ + 1;
			_tmp14_ = _type_arg_index;
			_tmp15_ = _type_arg_size;
			if (!(_tmp14_ < _tmp15_)) {
				break;
			}
			_tmp16_ = _type_arg_list;
			_tmp17_ = _type_arg_index;
			_tmp18_ = vala_list_get (_tmp16_, _tmp17_);
			type_arg = (ValaDataType*) _tmp18_;
			_tmp19_ = type_arg;
			vala_code_node_check ((ValaCodeNode*) _tmp19_, context);
			_vala_code_node_unref0 (type_arg);
		}
		_vala_iterable_unref0 (_type_arg_list);
	}
	base_symbol = NULL;
	this_parameter = NULL;
	may_access_instance_members = FALSE;
	may_access_klass_members = FALSE;
	vala_expression_set_symbol_reference ((ValaExpression*) self, NULL);
	_tmp20_ = self->priv->_qualified;
	if (_tmp20_) {
		ValaNamespace* _tmp21_;
		ValaNamespace* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaSymbol* _tmp24_;
		ValaScope* _tmp25_;
		ValaScope* _tmp26_;
		const gchar* _tmp27_;
		ValaSymbol* _tmp28_;
		ValaSymbol* _tmp29_;
		_tmp21_ = vala_code_context_get_root (context);
		_tmp22_ = _tmp21_;
		_tmp23_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp22_);
		_vala_code_node_unref0 (base_symbol);
		base_symbol = _tmp23_;
		_tmp24_ = base_symbol;
		_tmp25_ = vala_symbol_get_scope (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = self->priv->_member_name;
		_tmp28_ = vala_scope_lookup (_tmp26_, _tmp27_);
		_tmp29_ = _tmp28_;
		vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp29_);
		_vala_code_node_unref0 (_tmp29_);
	} else {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		if (_tmp31_ == NULL) {
			const gchar* _tmp32_;
			ValaSemanticAnalyzer* _tmp37_;
			ValaSemanticAnalyzer* _tmp38_;
			ValaSymbol* _tmp39_;
			ValaSymbol* _tmp40_;
			ValaSymbol* _tmp41_;
			gboolean method_found = FALSE;
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp42_;
			ValaSemanticAnalyzer* _tmp43_;
			ValaSymbol* _tmp44_;
			ValaSymbol* _tmp45_;
			ValaSymbol* _tmp46_;
			gboolean _tmp158_ = FALSE;
			ValaSymbol* _tmp159_;
			ValaSymbol* _tmp160_;
			_tmp32_ = self->priv->_member_name;
			if (g_strcmp0 (_tmp32_, "this") == 0) {
				ValaSemanticAnalyzer* _tmp33_;
				ValaSemanticAnalyzer* _tmp34_;
				_tmp33_ = vala_code_context_get_analyzer (context);
				_tmp34_ = _tmp33_;
				if (!vala_semantic_analyzer_is_in_instance_method (_tmp34_)) {
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp36_, "This access invalid outside of instance methods");
					result = FALSE;
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
			}
			_tmp37_ = vala_code_context_get_analyzer (context);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_semantic_analyzer_get_current_symbol (_tmp38_);
			_tmp40_ = _tmp39_;
			_tmp41_ = _vala_code_node_ref0 (_tmp40_);
			_vala_code_node_unref0 (base_symbol);
			base_symbol = _tmp41_;
			method_found = FALSE;
			_tmp42_ = vala_code_context_get_analyzer (context);
			_tmp43_ = _tmp42_;
			_tmp44_ = vala_semantic_analyzer_get_current_symbol (_tmp43_);
			_tmp45_ = _tmp44_;
			_tmp46_ = _vala_code_node_ref0 (_tmp45_);
			sym = _tmp46_;
			while (TRUE) {
				gboolean _tmp47_ = FALSE;
				ValaSymbol* _tmp48_;
				gboolean _tmp51_;
				ValaSymbol* _tmp105_;
				const gchar* _tmp106_;
				ValaSymbol* _tmp107_;
				ValaSymbol* _tmp108_;
				gboolean _tmp109_ = FALSE;
				gboolean _tmp110_ = FALSE;
				ValaSymbol* _tmp111_;
				ValaSymbol* _tmp112_;
				ValaSymbol* _tmp151_;
				ValaSymbol* _tmp152_;
				ValaSymbol* _tmp154_;
				ValaSymbol* _tmp155_;
				ValaSymbol* _tmp156_;
				ValaSymbol* _tmp157_;
				_tmp48_ = sym;
				if (_tmp48_ != NULL) {
					ValaSymbol* _tmp49_;
					ValaSymbol* _tmp50_;
					_tmp49_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp50_ = _tmp49_;
					_tmp47_ = _tmp50_ == NULL;
				} else {
					_tmp47_ = FALSE;
				}
				if (!_tmp47_) {
					break;
				}
				_tmp51_ = method_found;
				if (!_tmp51_) {
					ValaSymbol* _tmp52_;
					_tmp52_ = sym;
					if (VALA_IS_CREATION_METHOD (_tmp52_)) {
						ValaCreationMethod* cm = NULL;
						ValaSymbol* _tmp53_;
						ValaCreationMethod* _tmp54_;
						ValaCreationMethod* _tmp55_;
						ValaParameter* _tmp56_;
						ValaParameter* _tmp57_;
						ValaParameter* _tmp58_;
						_tmp53_ = sym;
						_tmp54_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
						cm = _tmp54_;
						_tmp55_ = cm;
						_tmp56_ = vala_method_get_this_parameter ((ValaMethod*) _tmp55_);
						_tmp57_ = _tmp56_;
						_tmp58_ = _vala_code_node_ref0 (_tmp57_);
						_vala_code_node_unref0 (this_parameter);
						this_parameter = _tmp58_;
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
						method_found = TRUE;
						_vala_code_node_unref0 (cm);
					} else {
						ValaSymbol* _tmp59_;
						_tmp59_ = sym;
						if (VALA_IS_PROPERTY (_tmp59_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp60_;
							ValaProperty* _tmp61_;
							ValaProperty* _tmp62_;
							ValaParameter* _tmp63_;
							ValaParameter* _tmp64_;
							ValaParameter* _tmp65_;
							ValaProperty* _tmp66_;
							ValaMemberBinding _tmp67_;
							ValaMemberBinding _tmp68_;
							ValaProperty* _tmp69_;
							ValaMemberBinding _tmp70_;
							ValaMemberBinding _tmp71_;
							_tmp60_ = sym;
							_tmp61_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp60_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp61_;
							_tmp62_ = prop;
							_tmp63_ = vala_property_get_this_parameter (_tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = _vala_code_node_ref0 (_tmp64_);
							_vala_code_node_unref0 (this_parameter);
							this_parameter = _tmp65_;
							_tmp66_ = prop;
							_tmp67_ = vala_property_get_binding (_tmp66_);
							_tmp68_ = _tmp67_;
							may_access_instance_members = _tmp68_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp69_ = prop;
							_tmp70_ = vala_property_get_binding (_tmp69_);
							_tmp71_ = _tmp70_;
							may_access_klass_members = _tmp71_ != VALA_MEMBER_BINDING_STATIC;
							method_found = TRUE;
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp72_;
							_tmp72_ = sym;
							if (VALA_IS_CONSTRUCTOR (_tmp72_)) {
								ValaConstructor* c = NULL;
								ValaSymbol* _tmp73_;
								ValaConstructor* _tmp74_;
								ValaConstructor* _tmp75_;
								ValaParameter* _tmp76_;
								ValaParameter* _tmp77_;
								ValaParameter* _tmp78_;
								ValaConstructor* _tmp79_;
								ValaMemberBinding _tmp80_;
								ValaMemberBinding _tmp81_;
								_tmp73_ = sym;
								_tmp74_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp73_, VALA_TYPE_CONSTRUCTOR, ValaConstructor));
								c = _tmp74_;
								_tmp75_ = c;
								_tmp76_ = vala_constructor_get_this_parameter (_tmp75_);
								_tmp77_ = _tmp76_;
								_tmp78_ = _vala_code_node_ref0 (_tmp77_);
								_vala_code_node_unref0 (this_parameter);
								this_parameter = _tmp78_;
								_tmp79_ = c;
								_tmp80_ = vala_constructor_get_binding (_tmp79_);
								_tmp81_ = _tmp80_;
								may_access_instance_members = _tmp81_ == VALA_MEMBER_BINDING_INSTANCE;
								may_access_klass_members = TRUE;
								method_found = TRUE;
								_vala_code_node_unref0 (c);
							} else {
								ValaSymbol* _tmp82_;
								_tmp82_ = sym;
								if (VALA_IS_DESTRUCTOR (_tmp82_)) {
									ValaDestructor* d = NULL;
									ValaSymbol* _tmp83_;
									ValaDestructor* _tmp84_;
									ValaDestructor* _tmp85_;
									ValaParameter* _tmp86_;
									ValaParameter* _tmp87_;
									ValaParameter* _tmp88_;
									ValaDestructor* _tmp89_;
									ValaMemberBinding _tmp90_;
									ValaMemberBinding _tmp91_;
									_tmp83_ = sym;
									_tmp84_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp83_, VALA_TYPE_DESTRUCTOR, ValaDestructor));
									d = _tmp84_;
									_tmp85_ = d;
									_tmp86_ = vala_destructor_get_this_parameter (_tmp85_);
									_tmp87_ = _tmp86_;
									_tmp88_ = _vala_code_node_ref0 (_tmp87_);
									_vala_code_node_unref0 (this_parameter);
									this_parameter = _tmp88_;
									_tmp89_ = d;
									_tmp90_ = vala_destructor_get_binding (_tmp89_);
									_tmp91_ = _tmp90_;
									may_access_instance_members = _tmp91_ == VALA_MEMBER_BINDING_INSTANCE;
									may_access_klass_members = TRUE;
									method_found = TRUE;
									_vala_code_node_unref0 (d);
								} else {
									ValaSymbol* _tmp92_;
									_tmp92_ = sym;
									if (VALA_IS_METHOD (_tmp92_)) {
										ValaMethod* m = NULL;
										ValaSymbol* _tmp93_;
										ValaMethod* _tmp94_;
										ValaMethod* _tmp95_;
										ValaParameter* _tmp96_;
										ValaParameter* _tmp97_;
										ValaParameter* _tmp98_;
										ValaMethod* _tmp99_;
										ValaMemberBinding _tmp100_;
										ValaMemberBinding _tmp101_;
										ValaMethod* _tmp102_;
										ValaMemberBinding _tmp103_;
										ValaMemberBinding _tmp104_;
										_tmp93_ = sym;
										_tmp94_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALA_TYPE_METHOD, ValaMethod));
										m = _tmp94_;
										_tmp95_ = m;
										_tmp96_ = vala_method_get_this_parameter (_tmp95_);
										_tmp97_ = _tmp96_;
										_tmp98_ = _vala_code_node_ref0 (_tmp97_);
										_vala_code_node_unref0 (this_parameter);
										this_parameter = _tmp98_;
										_tmp99_ = m;
										_tmp100_ = vala_method_get_binding (_tmp99_);
										_tmp101_ = _tmp100_;
										may_access_instance_members = _tmp101_ == VALA_MEMBER_BINDING_INSTANCE;
										_tmp102_ = m;
										_tmp103_ = vala_method_get_binding (_tmp102_);
										_tmp104_ = _tmp103_;
										may_access_klass_members = _tmp104_ != VALA_MEMBER_BINDING_STATIC;
										method_found = TRUE;
										_vala_code_node_unref0 (m);
									}
								}
							}
						}
					}
				}
				_tmp105_ = sym;
				_tmp106_ = self->priv->_member_name;
				_tmp107_ = vala_semantic_analyzer_symbol_lookup_inherited (_tmp105_, _tmp106_);
				_tmp108_ = _tmp107_;
				vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp108_);
				_vala_code_node_unref0 (_tmp108_);
				_tmp111_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp112_ = _tmp111_;
				if (_tmp112_ == NULL) {
					ValaSymbol* _tmp113_;
					_tmp113_ = sym;
					_tmp110_ = VALA_IS_TYPESYMBOL (_tmp113_);
				} else {
					_tmp110_ = FALSE;
				}
				if (_tmp110_) {
					gboolean _tmp114_;
					_tmp114_ = may_access_instance_members;
					_tmp109_ = _tmp114_;
				} else {
					_tmp109_ = FALSE;
				}
				if (_tmp109_) {
					ValaParameter* _tmp115_;
					ValaDataType* _tmp116_;
					ValaDataType* _tmp117_;
					const gchar* _tmp118_;
					ValaSymbol* _tmp119_;
					ValaSymbol* _tmp120_;
					gboolean _tmp121_ = FALSE;
					ValaSymbol* _tmp122_;
					ValaSymbol* _tmp123_;
					_tmp115_ = this_parameter;
					_tmp116_ = vala_variable_get_variable_type ((ValaVariable*) _tmp115_);
					_tmp117_ = _tmp116_;
					_tmp118_ = self->priv->_member_name;
					_tmp119_ = vala_data_type_get_member (_tmp117_, _tmp118_);
					_tmp120_ = _tmp119_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp120_);
					_vala_code_node_unref0 (_tmp120_);
					_tmp122_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp123_ = _tmp122_;
					if (_tmp123_ != NULL) {
						ValaSymbol* _tmp124_;
						ValaSymbol* _tmp125_;
						_tmp124_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
						_tmp125_ = _tmp124_;
						_tmp121_ = vala_member_access_is_instance_symbol (_tmp125_);
					} else {
						_tmp121_ = FALSE;
					}
					if (_tmp121_) {
						ValaSourceReference* _tmp126_;
						ValaSourceReference* _tmp127_;
						ValaMemberAccess* _tmp128_;
						ValaMemberAccess* _tmp129_;
						ValaExpression* _tmp130_;
						ValaExpression* _tmp131_;
						ValaParameter* _tmp132_;
						ValaDataType* _tmp133_;
						ValaDataType* _tmp134_;
						ValaDataType* _tmp135_;
						ValaDataType* _tmp136_;
						ValaExpression* _tmp137_;
						ValaExpression* _tmp138_;
						ValaDataType* _tmp139_;
						ValaDataType* _tmp140_;
						ValaExpression* _tmp141_;
						ValaExpression* _tmp142_;
						ValaParameter* _tmp143_;
						ValaExpression* _tmp144_;
						ValaExpression* _tmp145_;
						ValaDataType* _tmp146_;
						ValaDataType* _tmp147_;
						const gchar* _tmp148_;
						ValaSymbol* _tmp149_;
						ValaSymbol* _tmp150_;
						_tmp126_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp127_ = _tmp126_;
						_tmp128_ = vala_member_access_new (NULL, "this", _tmp127_);
						_tmp129_ = _tmp128_;
						vala_member_access_set_inner (self, (ValaExpression*) _tmp129_);
						_vala_code_node_unref0 (_tmp129_);
						_tmp130_ = vala_member_access_get_inner (self);
						_tmp131_ = _tmp130_;
						_tmp132_ = this_parameter;
						_tmp133_ = vala_variable_get_variable_type ((ValaVariable*) _tmp132_);
						_tmp134_ = _tmp133_;
						_tmp135_ = vala_data_type_copy (_tmp134_);
						_tmp136_ = _tmp135_;
						vala_expression_set_value_type (_tmp131_, _tmp136_);
						_vala_code_node_unref0 (_tmp136_);
						_tmp137_ = vala_member_access_get_inner (self);
						_tmp138_ = _tmp137_;
						_tmp139_ = vala_expression_get_value_type (_tmp138_);
						_tmp140_ = _tmp139_;
						vala_data_type_set_value_owned (_tmp140_, FALSE);
						_tmp141_ = vala_member_access_get_inner (self);
						_tmp142_ = _tmp141_;
						_tmp143_ = this_parameter;
						vala_expression_set_symbol_reference (_tmp142_, (ValaSymbol*) _tmp143_);
						_tmp144_ = vala_member_access_get_inner (self);
						_tmp145_ = _tmp144_;
						_tmp146_ = vala_expression_get_value_type (_tmp145_);
						_tmp147_ = _tmp146_;
						_tmp148_ = self->priv->_member_name;
						_tmp149_ = vala_data_type_get_member (_tmp147_, _tmp148_);
						_tmp150_ = _tmp149_;
						vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp150_);
						_vala_code_node_unref0 (_tmp150_);
					}
				}
				_tmp151_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp152_ = _tmp151_;
				if (_tmp152_ == NULL) {
					ValaSymbol* _tmp153_;
					_tmp153_ = sym;
					if (VALA_IS_TYPESYMBOL (_tmp153_)) {
						_vala_code_node_unref0 (this_parameter);
						this_parameter = NULL;
						may_access_instance_members = FALSE;
						may_access_klass_members = FALSE;
					}
				}
				_tmp154_ = sym;
				_tmp155_ = vala_symbol_get_parent_symbol (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = _vala_code_node_ref0 (_tmp156_);
				_vala_code_node_unref0 (sym);
				sym = _tmp157_;
			}
			_tmp159_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp160_ = _tmp159_;
			if (_tmp160_ == NULL) {
				ValaSourceReference* _tmp161_;
				ValaSourceReference* _tmp162_;
				_tmp161_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp162_ = _tmp161_;
				_tmp158_ = _tmp162_ != NULL;
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				{
					ValaList* _ns_list = NULL;
					ValaSourceReference* _tmp163_;
					ValaSourceReference* _tmp164_;
					ValaList* _tmp165_;
					ValaList* _tmp166_;
					ValaList* _tmp167_;
					gint _ns_size = 0;
					ValaList* _tmp168_;
					gint _tmp169_;
					gint _tmp170_;
					gint _ns_index = 0;
					_tmp163_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp164_ = _tmp163_;
					_tmp165_ = vala_source_reference_get_using_directives (_tmp164_);
					_tmp166_ = _tmp165_;
					_tmp167_ = _vala_iterable_ref0 (_tmp166_);
					_ns_list = _tmp167_;
					_tmp168_ = _ns_list;
					_tmp169_ = vala_collection_get_size ((ValaCollection*) _tmp168_);
					_tmp170_ = _tmp169_;
					_ns_size = _tmp170_;
					_ns_index = -1;
					while (TRUE) {
						gint _tmp171_;
						gint _tmp172_;
						gint _tmp173_;
						ValaUsingDirective* ns = NULL;
						ValaList* _tmp174_;
						gint _tmp175_;
						gpointer _tmp176_;
						ValaSymbol* local_sym = NULL;
						ValaUsingDirective* _tmp177_;
						ValaSymbol* _tmp178_;
						ValaSymbol* _tmp179_;
						ValaScope* _tmp180_;
						ValaScope* _tmp181_;
						const gchar* _tmp182_;
						ValaSymbol* _tmp183_;
						ValaSymbol* _tmp184_;
						_tmp171_ = _ns_index;
						_ns_index = _tmp171_ + 1;
						_tmp172_ = _ns_index;
						_tmp173_ = _ns_size;
						if (!(_tmp172_ < _tmp173_)) {
							break;
						}
						_tmp174_ = _ns_list;
						_tmp175_ = _ns_index;
						_tmp176_ = vala_list_get (_tmp174_, _tmp175_);
						ns = (ValaUsingDirective*) _tmp176_;
						_tmp177_ = ns;
						_tmp178_ = vala_using_directive_get_namespace_symbol (_tmp177_);
						_tmp179_ = _tmp178_;
						_tmp180_ = vala_symbol_get_scope (_tmp179_);
						_tmp181_ = _tmp180_;
						_tmp182_ = self->priv->_member_name;
						_tmp183_ = vala_scope_lookup (_tmp181_, _tmp182_);
						local_sym = _tmp183_;
						_tmp184_ = local_sym;
						if (_tmp184_ != NULL) {
							gboolean _tmp185_ = FALSE;
							ValaSymbol* _tmp186_;
							ValaSymbol* _tmp187_;
							ValaSymbol* _tmp203_;
							_tmp186_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp187_ = _tmp186_;
							if (_tmp187_ != NULL) {
								ValaSymbol* _tmp188_;
								ValaSymbol* _tmp189_;
								ValaSymbol* _tmp190_;
								_tmp188_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp189_ = _tmp188_;
								_tmp190_ = local_sym;
								_tmp185_ = _tmp189_ != _tmp190_;
							} else {
								_tmp185_ = FALSE;
							}
							if (_tmp185_) {
								ValaSourceReference* _tmp191_;
								ValaSourceReference* _tmp192_;
								const gchar* _tmp193_;
								ValaSymbol* _tmp194_;
								ValaSymbol* _tmp195_;
								gchar* _tmp196_;
								gchar* _tmp197_;
								ValaSymbol* _tmp198_;
								gchar* _tmp199_;
								gchar* _tmp200_;
								gchar* _tmp201_;
								gchar* _tmp202_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp191_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp192_ = _tmp191_;
								_tmp193_ = self->priv->_member_name;
								_tmp194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp195_ = _tmp194_;
								_tmp196_ = vala_symbol_get_full_name (_tmp195_);
								_tmp197_ = _tmp196_;
								_tmp198_ = local_sym;
								_tmp199_ = vala_symbol_get_full_name (_tmp198_);
								_tmp200_ = _tmp199_;
								_tmp201_ = g_strdup_printf ("`%s' is an ambiguous reference between `%s' and `%s'", _tmp193_, _tmp197_, _tmp200_);
								_tmp202_ = _tmp201_;
								vala_report_error (_tmp192_, _tmp202_);
								_g_free0 (_tmp202_);
								_g_free0 (_tmp200_);
								_g_free0 (_tmp197_);
								result = FALSE;
								_vala_code_node_unref0 (local_sym);
								_vala_code_node_unref0 (ns);
								_vala_iterable_unref0 (_ns_list);
								_vala_code_node_unref0 (sym);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp203_ = local_sym;
							vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp203_);
						}
						_vala_code_node_unref0 (local_sym);
						_vala_code_node_unref0 (ns);
					}
					_vala_iterable_unref0 (_ns_list);
				}
			}
			_vala_code_node_unref0 (sym);
		} else {
			ValaExpression* _tmp204_;
			ValaExpression* _tmp205_;
			gboolean _tmp206_;
			gboolean _tmp207_;
			ValaExpression* _tmp208_;
			ValaExpression* _tmp209_;
			ValaDataType* _tmp210_;
			ValaDataType* _tmp211_;
			ValaExpression* _tmp230_;
			ValaExpression* _tmp231_;
			gboolean _tmp247_ = FALSE;
			ValaExpression* _tmp248_;
			ValaExpression* _tmp249_;
			gboolean _tmp271_ = FALSE;
			ValaSymbol* _tmp272_;
			ValaSymbol* _tmp273_;
			gboolean _tmp308_ = FALSE;
			gboolean _tmp309_ = FALSE;
			ValaSymbol* _tmp310_;
			ValaSymbol* _tmp311_;
			gboolean _tmp563_ = FALSE;
			ValaSymbol* _tmp564_;
			ValaSymbol* _tmp565_;
			_tmp204_ = vala_member_access_get_inner (self);
			_tmp205_ = _tmp204_;
			_tmp206_ = vala_code_node_get_error ((ValaCodeNode*) _tmp205_);
			_tmp207_ = _tmp206_;
			if (_tmp207_) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_tmp208_ = vala_member_access_get_inner (self);
			_tmp209_ = _tmp208_;
			_tmp210_ = vala_expression_get_value_type (_tmp209_);
			_tmp211_ = _tmp210_;
			if (VALA_IS_POINTER_TYPE (_tmp211_)) {
				ValaPointerType* pointer_type = NULL;
				ValaExpression* _tmp212_;
				ValaExpression* _tmp213_;
				ValaDataType* _tmp214_;
				ValaDataType* _tmp215_;
				ValaPointerType* _tmp216_;
				gboolean _tmp217_ = FALSE;
				ValaPointerType* _tmp218_;
				_tmp212_ = vala_member_access_get_inner (self);
				_tmp213_ = _tmp212_;
				_tmp214_ = vala_expression_get_value_type (_tmp213_);
				_tmp215_ = _tmp214_;
				_tmp216_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp215_) ? ((ValaPointerType*) _tmp215_) : NULL);
				pointer_type = _tmp216_;
				_tmp218_ = pointer_type;
				if (_tmp218_ != NULL) {
					ValaPointerType* _tmp219_;
					ValaDataType* _tmp220_;
					ValaDataType* _tmp221_;
					_tmp219_ = pointer_type;
					_tmp220_ = vala_pointer_type_get_base_type (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp217_ = VALA_IS_VALUE_TYPE (_tmp221_);
				} else {
					_tmp217_ = FALSE;
				}
				if (_tmp217_) {
					ValaExpression* _tmp222_;
					ValaExpression* _tmp223_;
					ValaSourceReference* _tmp224_;
					ValaSourceReference* _tmp225_;
					ValaPointerIndirection* _tmp226_;
					ValaPointerIndirection* _tmp227_;
					ValaExpression* _tmp228_;
					ValaExpression* _tmp229_;
					_tmp222_ = vala_member_access_get_inner (self);
					_tmp223_ = _tmp222_;
					_tmp224_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp225_ = _tmp224_;
					_tmp226_ = vala_pointer_indirection_new (_tmp223_, _tmp225_);
					_tmp227_ = _tmp226_;
					vala_member_access_set_inner (self, (ValaExpression*) _tmp227_);
					_vala_code_node_unref0 (_tmp227_);
					_tmp228_ = vala_member_access_get_inner (self);
					_tmp229_ = _tmp228_;
					vala_code_node_check ((ValaCodeNode*) _tmp229_, context);
					vala_member_access_set_pointer_member_access (self, FALSE);
				}
				_vala_code_node_unref0 (pointer_type);
			}
			_tmp230_ = vala_member_access_get_inner (self);
			_tmp231_ = _tmp230_;
			if (VALA_IS_MEMBER_ACCESS (_tmp231_)) {
				ValaMemberAccess* ma = NULL;
				ValaExpression* _tmp232_;
				ValaExpression* _tmp233_;
				ValaMemberAccess* _tmp234_;
				ValaMemberAccess* _tmp235_;
				gboolean _tmp236_;
				_tmp232_ = vala_member_access_get_inner (self);
				_tmp233_ = _tmp232_;
				_tmp234_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp233_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				ma = _tmp234_;
				_tmp235_ = ma;
				_tmp236_ = _tmp235_->priv->_prototype_access;
				if (_tmp236_) {
					ValaSourceReference* _tmp237_;
					ValaSourceReference* _tmp238_;
					ValaExpression* _tmp239_;
					ValaExpression* _tmp240_;
					ValaSymbol* _tmp241_;
					ValaSymbol* _tmp242_;
					gchar* _tmp243_;
					gchar* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp237_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp238_ = _tmp237_;
					_tmp239_ = vala_member_access_get_inner (self);
					_tmp240_ = _tmp239_;
					_tmp241_ = vala_expression_get_symbol_reference (_tmp240_);
					_tmp242_ = _tmp241_;
					_tmp243_ = vala_symbol_get_full_name (_tmp242_);
					_tmp244_ = _tmp243_;
					_tmp245_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp244_);
					_tmp246_ = _tmp245_;
					vala_report_error (_tmp238_, _tmp246_);
					_g_free0 (_tmp246_);
					_g_free0 (_tmp244_);
					result = FALSE;
					_vala_code_node_unref0 (ma);
					_vala_code_node_unref0 (this_parameter);
					_vala_code_node_unref0 (base_symbol);
					return result;
				}
				_vala_code_node_unref0 (ma);
			}
			_tmp248_ = vala_member_access_get_inner (self);
			_tmp249_ = _tmp248_;
			if (VALA_IS_MEMBER_ACCESS (_tmp249_)) {
				_tmp247_ = TRUE;
			} else {
				ValaExpression* _tmp250_;
				ValaExpression* _tmp251_;
				_tmp250_ = vala_member_access_get_inner (self);
				_tmp251_ = _tmp250_;
				_tmp247_ = VALA_IS_BASE_ACCESS (_tmp251_);
			}
			if (_tmp247_) {
				ValaExpression* _tmp252_;
				ValaExpression* _tmp253_;
				ValaSymbol* _tmp254_;
				ValaSymbol* _tmp255_;
				ValaSymbol* _tmp256_;
				gboolean _tmp257_ = FALSE;
				ValaSymbol* _tmp258_;
				ValaSymbol* _tmp259_;
				_tmp252_ = vala_member_access_get_inner (self);
				_tmp253_ = _tmp252_;
				_tmp254_ = vala_expression_get_symbol_reference (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = _vala_code_node_ref0 (_tmp255_);
				_vala_code_node_unref0 (base_symbol);
				base_symbol = _tmp256_;
				_tmp258_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp259_ = _tmp258_;
				if (_tmp259_ == NULL) {
					gboolean _tmp260_ = FALSE;
					ValaSymbol* _tmp261_;
					_tmp261_ = base_symbol;
					if (VALA_IS_NAMESPACE (_tmp261_)) {
						_tmp260_ = TRUE;
					} else {
						ValaSymbol* _tmp262_;
						_tmp262_ = base_symbol;
						_tmp260_ = VALA_IS_TYPESYMBOL (_tmp262_);
					}
					_tmp257_ = _tmp260_;
				} else {
					_tmp257_ = FALSE;
				}
				if (_tmp257_) {
					ValaSymbol* _tmp263_;
					ValaScope* _tmp264_;
					ValaScope* _tmp265_;
					const gchar* _tmp266_;
					ValaSymbol* _tmp267_;
					ValaSymbol* _tmp268_;
					ValaExpression* _tmp269_;
					ValaExpression* _tmp270_;
					_tmp263_ = base_symbol;
					_tmp264_ = vala_symbol_get_scope (_tmp263_);
					_tmp265_ = _tmp264_;
					_tmp266_ = self->priv->_member_name;
					_tmp267_ = vala_scope_lookup (_tmp265_, _tmp266_);
					_tmp268_ = _tmp267_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp268_);
					_vala_code_node_unref0 (_tmp268_);
					_tmp269_ = vala_member_access_get_inner (self);
					_tmp270_ = _tmp269_;
					if (VALA_IS_BASE_ACCESS (_tmp270_)) {
						may_access_instance_members = TRUE;
						may_access_klass_members = TRUE;
					}
				}
			}
			_tmp272_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp273_ = _tmp272_;
			if (_tmp273_ == NULL) {
				ValaExpression* _tmp274_;
				ValaExpression* _tmp275_;
				ValaDataType* _tmp276_;
				ValaDataType* _tmp277_;
				_tmp274_ = vala_member_access_get_inner (self);
				_tmp275_ = _tmp274_;
				_tmp276_ = vala_expression_get_value_type (_tmp275_);
				_tmp277_ = _tmp276_;
				_tmp271_ = _tmp277_ != NULL;
			} else {
				_tmp271_ = FALSE;
			}
			if (_tmp271_) {
				gboolean _tmp278_;
				ValaSymbol* _tmp306_;
				ValaSymbol* _tmp307_;
				_tmp278_ = self->priv->_pointer_member_access;
				if (_tmp278_) {
					ValaExpression* _tmp279_;
					ValaExpression* _tmp280_;
					ValaDataType* _tmp281_;
					ValaDataType* _tmp282_;
					const gchar* _tmp283_;
					ValaSymbol* _tmp284_;
					ValaSymbol* _tmp285_;
					_tmp279_ = vala_member_access_get_inner (self);
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_expression_get_value_type (_tmp280_);
					_tmp282_ = _tmp281_;
					_tmp283_ = self->priv->_member_name;
					_tmp284_ = vala_data_type_get_pointer_member (_tmp282_, _tmp283_);
					_tmp285_ = _tmp284_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp285_);
					_vala_code_node_unref0 (_tmp285_);
				} else {
					ValaExpression* _tmp286_;
					ValaExpression* _tmp287_;
					ValaDataType* _tmp288_;
					ValaDataType* _tmp289_;
					ValaTypeSymbol* _tmp290_;
					ValaTypeSymbol* _tmp291_;
					ValaExpression* _tmp299_;
					ValaExpression* _tmp300_;
					ValaDataType* _tmp301_;
					ValaDataType* _tmp302_;
					const gchar* _tmp303_;
					ValaSymbol* _tmp304_;
					ValaSymbol* _tmp305_;
					_tmp286_ = vala_member_access_get_inner (self);
					_tmp287_ = _tmp286_;
					_tmp288_ = vala_expression_get_value_type (_tmp287_);
					_tmp289_ = _tmp288_;
					_tmp290_ = vala_data_type_get_data_type (_tmp289_);
					_tmp291_ = _tmp290_;
					if (_tmp291_ != NULL) {
						ValaExpression* _tmp292_;
						ValaExpression* _tmp293_;
						ValaDataType* _tmp294_;
						ValaDataType* _tmp295_;
						ValaTypeSymbol* _tmp296_;
						ValaTypeSymbol* _tmp297_;
						ValaSymbol* _tmp298_;
						_tmp292_ = vala_member_access_get_inner (self);
						_tmp293_ = _tmp292_;
						_tmp294_ = vala_expression_get_value_type (_tmp293_);
						_tmp295_ = _tmp294_;
						_tmp296_ = vala_data_type_get_data_type (_tmp295_);
						_tmp297_ = _tmp296_;
						_tmp298_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp297_);
						_vala_code_node_unref0 (base_symbol);
						base_symbol = _tmp298_;
					}
					_tmp299_ = vala_member_access_get_inner (self);
					_tmp300_ = _tmp299_;
					_tmp301_ = vala_expression_get_value_type (_tmp300_);
					_tmp302_ = _tmp301_;
					_tmp303_ = self->priv->_member_name;
					_tmp304_ = vala_data_type_get_member (_tmp302_, _tmp303_);
					_tmp305_ = _tmp304_;
					vala_expression_set_symbol_reference ((ValaExpression*) self, _tmp305_);
					_vala_code_node_unref0 (_tmp305_);
				}
				_tmp306_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp307_ = _tmp306_;
				if (_tmp307_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
			}
			_tmp310_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp311_ = _tmp310_;
			if (_tmp311_ == NULL) {
				ValaExpression* _tmp312_;
				ValaExpression* _tmp313_;
				ValaDataType* _tmp314_;
				ValaDataType* _tmp315_;
				_tmp312_ = vala_member_access_get_inner (self);
				_tmp313_ = _tmp312_;
				_tmp314_ = vala_expression_get_value_type (_tmp313_);
				_tmp315_ = _tmp314_;
				_tmp309_ = _tmp315_ != NULL;
			} else {
				_tmp309_ = FALSE;
			}
			if (_tmp309_) {
				ValaExpression* _tmp316_;
				ValaExpression* _tmp317_;
				ValaDataType* _tmp318_;
				ValaDataType* _tmp319_;
				gboolean _tmp320_;
				gboolean _tmp321_;
				_tmp316_ = vala_member_access_get_inner (self);
				_tmp317_ = _tmp316_;
				_tmp318_ = vala_expression_get_value_type (_tmp317_);
				_tmp319_ = _tmp318_;
				_tmp320_ = vala_data_type_get_is_dynamic (_tmp319_);
				_tmp321_ = _tmp320_;
				_tmp308_ = _tmp321_;
			} else {
				_tmp308_ = FALSE;
			}
			if (_tmp308_) {
				ValaObjectType* dynamic_object_type = NULL;
				ValaExpression* _tmp322_;
				ValaExpression* _tmp323_;
				ValaDataType* _tmp324_;
				ValaDataType* _tmp325_;
				ValaObjectType* _tmp326_;
				ValaCodeNode* _tmp327_;
				ValaCodeNode* _tmp328_;
				ValaSymbol* _tmp511_;
				ValaSymbol* _tmp512_;
				ValaSymbol* _tmp561_;
				ValaSymbol* _tmp562_;
				_tmp322_ = vala_member_access_get_inner (self);
				_tmp323_ = _tmp322_;
				_tmp324_ = vala_expression_get_value_type (_tmp323_);
				_tmp325_ = _tmp324_;
				_tmp326_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp325_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				dynamic_object_type = _tmp326_;
				_tmp327_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
				_tmp328_ = _tmp327_;
				if (VALA_IS_METHOD_CALL (_tmp328_)) {
					ValaMethodCall* invoc = NULL;
					ValaCodeNode* _tmp329_;
					ValaCodeNode* _tmp330_;
					ValaMethodCall* _tmp331_;
					ValaMethodCall* _tmp332_;
					ValaExpression* _tmp333_;
					ValaExpression* _tmp334_;
					_tmp329_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp330_ = _tmp329_;
					_tmp331_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp330_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
					invoc = _tmp331_;
					_tmp332_ = invoc;
					_tmp333_ = vala_method_call_get_call (_tmp332_);
					_tmp334_ = _tmp333_;
					if (_tmp334_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
						ValaDataType* ret_type = NULL;
						ValaMethodCall* _tmp335_;
						ValaDataType* _tmp336_;
						ValaDataType* _tmp337_;
						ValaDynamicMethod* m = NULL;
						ValaExpression* _tmp352_;
						ValaExpression* _tmp353_;
						ValaDataType* _tmp354_;
						ValaDataType* _tmp355_;
						const gchar* _tmp356_;
						ValaDataType* _tmp357_;
						ValaSourceReference* _tmp358_;
						ValaSourceReference* _tmp359_;
						ValaDynamicMethod* _tmp360_;
						ValaDynamicMethod* _tmp361_;
						ValaMethodCall* _tmp362_;
						ValaErrorType* err = NULL;
						ValaErrorType* _tmp363_;
						ValaErrorType* _tmp364_;
						ValaDynamicMethod* _tmp365_;
						ValaErrorType* _tmp366_;
						ValaDynamicMethod* _tmp367_;
						ValaDynamicMethod* _tmp368_;
						ValaParameter* _tmp369_;
						ValaParameter* _tmp370_;
						ValaDynamicMethod* _tmp371_;
						ValaObjectType* _tmp372_;
						ValaDataType* _tmp373_;
						ValaDataType* _tmp374_;
						ValaParameter* _tmp375_;
						ValaParameter* _tmp376_;
						ValaObjectType* _tmp377_;
						ValaObjectTypeSymbol* _tmp378_;
						ValaObjectTypeSymbol* _tmp379_;
						ValaScope* _tmp380_;
						ValaScope* _tmp381_;
						ValaDynamicMethod* _tmp382_;
						ValaDynamicMethod* _tmp383_;
						_tmp335_ = invoc;
						_tmp336_ = vala_expression_get_target_type ((ValaExpression*) _tmp335_);
						_tmp337_ = _tmp336_;
						if (_tmp337_ != NULL) {
							ValaMethodCall* _tmp338_;
							ValaDataType* _tmp339_;
							ValaDataType* _tmp340_;
							ValaDataType* _tmp341_;
							ValaDataType* _tmp342_;
							_tmp338_ = invoc;
							_tmp339_ = vala_expression_get_target_type ((ValaExpression*) _tmp338_);
							_tmp340_ = _tmp339_;
							_tmp341_ = vala_data_type_copy (_tmp340_);
							_vala_code_node_unref0 (ret_type);
							ret_type = _tmp341_;
							_tmp342_ = ret_type;
							vala_data_type_set_value_owned (_tmp342_, TRUE);
						} else {
							ValaMethodCall* _tmp343_;
							ValaCodeNode* _tmp344_;
							ValaCodeNode* _tmp345_;
							_tmp343_ = invoc;
							_tmp344_ = vala_code_node_get_parent_node ((ValaCodeNode*) _tmp343_);
							_tmp345_ = _tmp344_;
							if (VALA_IS_EXPRESSION_STATEMENT (_tmp345_)) {
								ValaVoidType* _tmp346_;
								_tmp346_ = vala_void_type_new (NULL);
								_vala_code_node_unref0 (ret_type);
								ret_type = (ValaDataType*) _tmp346_;
							} else {
								ValaExpression* _tmp347_;
								ValaExpression* _tmp348_;
								ValaDataType* _tmp349_;
								ValaDataType* _tmp350_;
								ValaDataType* _tmp351_;
								_tmp347_ = vala_member_access_get_inner (self);
								_tmp348_ = _tmp347_;
								_tmp349_ = vala_expression_get_value_type (_tmp348_);
								_tmp350_ = _tmp349_;
								_tmp351_ = vala_data_type_copy (_tmp350_);
								_vala_code_node_unref0 (ret_type);
								ret_type = _tmp351_;
							}
						}
						_tmp352_ = vala_member_access_get_inner (self);
						_tmp353_ = _tmp352_;
						_tmp354_ = vala_expression_get_value_type (_tmp353_);
						_tmp355_ = _tmp354_;
						_tmp356_ = self->priv->_member_name;
						_tmp357_ = ret_type;
						_tmp358_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp359_ = _tmp358_;
						_tmp360_ = vala_dynamic_method_new (_tmp355_, _tmp356_, _tmp357_, _tmp359_, NULL);
						m = _tmp360_;
						_tmp361_ = m;
						_tmp362_ = invoc;
						vala_dynamic_method_set_invocation (_tmp361_, _tmp362_);
						_tmp363_ = vala_error_type_new (NULL, NULL, NULL);
						err = _tmp363_;
						_tmp364_ = err;
						vala_error_type_set_dynamic_error (_tmp364_, TRUE);
						_tmp365_ = m;
						_tmp366_ = err;
						vala_code_node_add_error_type ((ValaCodeNode*) _tmp365_, (ValaDataType*) _tmp366_);
						_tmp367_ = m;
						vala_symbol_set_access ((ValaSymbol*) _tmp367_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
						_tmp368_ = m;
						_tmp369_ = vala_parameter_new_with_ellipsis (NULL);
						_tmp370_ = _tmp369_;
						vala_callable_add_parameter ((ValaCallable*) _tmp368_, _tmp370_);
						_vala_code_node_unref0 (_tmp370_);
						_tmp371_ = m;
						_tmp372_ = dynamic_object_type;
						_tmp373_ = vala_data_type_copy ((ValaDataType*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = vala_parameter_new ("this", _tmp374_, NULL);
						_tmp376_ = _tmp375_;
						vala_method_set_this_parameter ((ValaMethod*) _tmp371_, _tmp376_);
						_vala_code_node_unref0 (_tmp376_);
						_vala_code_node_unref0 (_tmp374_);
						_tmp377_ = dynamic_object_type;
						_tmp378_ = vala_object_type_get_type_symbol (_tmp377_);
						_tmp379_ = _tmp378_;
						_tmp380_ = vala_symbol_get_scope ((ValaSymbol*) _tmp379_);
						_tmp381_ = _tmp380_;
						_tmp382_ = m;
						vala_scope_add (_tmp381_, NULL, (ValaSymbol*) _tmp382_);
						_tmp383_ = m;
						vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp383_);
						_vala_code_node_unref0 (err);
						_vala_code_node_unref0 (m);
						_vala_code_node_unref0 (ret_type);
					}
					_vala_code_node_unref0 (invoc);
				} else {
					ValaCodeNode* _tmp384_;
					ValaCodeNode* _tmp385_;
					_tmp384_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp385_ = _tmp384_;
					if (VALA_IS_ASSIGNMENT (_tmp385_)) {
						ValaAssignment* a = NULL;
						ValaCodeNode* _tmp386_;
						ValaCodeNode* _tmp387_;
						ValaAssignment* _tmp388_;
						gboolean _tmp389_ = FALSE;
						ValaAssignment* _tmp390_;
						ValaExpression* _tmp391_;
						ValaExpression* _tmp392_;
						_tmp386_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp387_ = _tmp386_;
						_tmp388_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp387_, VALA_TYPE_ASSIGNMENT, ValaAssignment));
						a = _tmp388_;
						_tmp390_ = a;
						_tmp391_ = vala_assignment_get_left (_tmp390_);
						_tmp392_ = _tmp391_;
						if (_tmp392_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
							gboolean _tmp393_ = FALSE;
							ValaAssignment* _tmp394_;
							ValaAssignmentOperator _tmp395_;
							ValaAssignmentOperator _tmp396_;
							_tmp394_ = a;
							_tmp395_ = vala_assignment_get_operator (_tmp394_);
							_tmp396_ = _tmp395_;
							if (_tmp396_ == VALA_ASSIGNMENT_OPERATOR_ADD) {
								_tmp393_ = TRUE;
							} else {
								ValaAssignment* _tmp397_;
								ValaAssignmentOperator _tmp398_;
								ValaAssignmentOperator _tmp399_;
								_tmp397_ = a;
								_tmp398_ = vala_assignment_get_operator (_tmp397_);
								_tmp399_ = _tmp398_;
								_tmp393_ = _tmp399_ == VALA_ASSIGNMENT_OPERATOR_SUB;
							}
							_tmp389_ = _tmp393_;
						} else {
							_tmp389_ = FALSE;
						}
						if (_tmp389_) {
							ValaDynamicSignal* s = NULL;
							ValaExpression* _tmp400_;
							ValaExpression* _tmp401_;
							ValaDataType* _tmp402_;
							ValaDataType* _tmp403_;
							const gchar* _tmp404_;
							ValaVoidType* _tmp405_;
							ValaVoidType* _tmp406_;
							ValaSourceReference* _tmp407_;
							ValaSourceReference* _tmp408_;
							ValaDynamicSignal* _tmp409_;
							ValaDynamicSignal* _tmp410_;
							ValaDynamicSignal* _tmp411_;
							ValaAssignment* _tmp412_;
							ValaExpression* _tmp413_;
							ValaExpression* _tmp414_;
							ValaDynamicSignal* _tmp415_;
							ValaObjectType* _tmp416_;
							ValaObjectTypeSymbol* _tmp417_;
							ValaObjectTypeSymbol* _tmp418_;
							ValaScope* _tmp419_;
							ValaScope* _tmp420_;
							ValaDynamicSignal* _tmp421_;
							ValaDynamicSignal* _tmp422_;
							_tmp400_ = vala_member_access_get_inner (self);
							_tmp401_ = _tmp400_;
							_tmp402_ = vala_expression_get_value_type (_tmp401_);
							_tmp403_ = _tmp402_;
							_tmp404_ = self->priv->_member_name;
							_tmp405_ = vala_void_type_new (NULL);
							_tmp406_ = _tmp405_;
							_tmp407_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp408_ = _tmp407_;
							_tmp409_ = vala_dynamic_signal_new (_tmp403_, _tmp404_, (ValaDataType*) _tmp406_, _tmp408_, NULL);
							_tmp410_ = _tmp409_;
							_vala_code_node_unref0 (_tmp406_);
							s = _tmp410_;
							_tmp411_ = s;
							_tmp412_ = a;
							_tmp413_ = vala_assignment_get_right (_tmp412_);
							_tmp414_ = _tmp413_;
							vala_dynamic_signal_set_handler (_tmp411_, _tmp414_);
							_tmp415_ = s;
							vala_symbol_set_access ((ValaSymbol*) _tmp415_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
							_tmp416_ = dynamic_object_type;
							_tmp417_ = vala_object_type_get_type_symbol (_tmp416_);
							_tmp418_ = _tmp417_;
							_tmp419_ = vala_symbol_get_scope ((ValaSymbol*) _tmp418_);
							_tmp420_ = _tmp419_;
							_tmp421_ = s;
							vala_scope_add (_tmp420_, NULL, (ValaSymbol*) _tmp421_);
							_tmp422_ = s;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp422_);
							_vala_code_node_unref0 (s);
						} else {
							ValaAssignment* _tmp423_;
							ValaExpression* _tmp424_;
							ValaExpression* _tmp425_;
							_tmp423_ = a;
							_tmp424_ = vala_assignment_get_left (_tmp423_);
							_tmp425_ = _tmp424_;
							if (_tmp425_ == G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_EXPRESSION, ValaExpression)) {
								ValaDynamicProperty* prop = NULL;
								ValaExpression* _tmp426_;
								ValaExpression* _tmp427_;
								ValaDataType* _tmp428_;
								ValaDataType* _tmp429_;
								const gchar* _tmp430_;
								ValaSourceReference* _tmp431_;
								ValaSourceReference* _tmp432_;
								ValaDynamicProperty* _tmp433_;
								ValaDynamicProperty* _tmp434_;
								ValaDynamicProperty* _tmp435_;
								ValaDynamicProperty* _tmp436_;
								ValaSourceReference* _tmp437_;
								ValaSourceReference* _tmp438_;
								ValaPropertyAccessor* _tmp439_;
								ValaPropertyAccessor* _tmp440_;
								ValaDynamicProperty* _tmp441_;
								ValaExpression* _tmp442_;
								ValaExpression* _tmp443_;
								ValaDataType* _tmp444_;
								ValaDataType* _tmp445_;
								ValaTypeSymbol* _tmp446_;
								ValaTypeSymbol* _tmp447_;
								ValaScope* _tmp448_;
								ValaScope* _tmp449_;
								ValaObjectType* _tmp450_;
								ValaObjectTypeSymbol* _tmp451_;
								ValaObjectTypeSymbol* _tmp452_;
								ValaScope* _tmp453_;
								ValaScope* _tmp454_;
								ValaDynamicProperty* _tmp455_;
								ValaDynamicProperty* _tmp456_;
								_tmp426_ = vala_member_access_get_inner (self);
								_tmp427_ = _tmp426_;
								_tmp428_ = vala_expression_get_value_type (_tmp427_);
								_tmp429_ = _tmp428_;
								_tmp430_ = self->priv->_member_name;
								_tmp431_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp432_ = _tmp431_;
								_tmp433_ = vala_dynamic_property_new (_tmp429_, _tmp430_, _tmp432_, NULL);
								prop = _tmp433_;
								_tmp434_ = prop;
								vala_symbol_set_access ((ValaSymbol*) _tmp434_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp435_ = prop;
								_tmp436_ = prop;
								_tmp437_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp436_);
								_tmp438_ = _tmp437_;
								_tmp439_ = vala_property_accessor_new (FALSE, TRUE, FALSE, NULL, NULL, _tmp438_, NULL);
								_tmp440_ = _tmp439_;
								vala_property_set_set_accessor ((ValaProperty*) _tmp435_, _tmp440_);
								_vala_code_node_unref0 (_tmp440_);
								_tmp441_ = prop;
								_tmp442_ = vala_member_access_get_inner (self);
								_tmp443_ = _tmp442_;
								_tmp444_ = vala_expression_get_value_type (_tmp443_);
								_tmp445_ = _tmp444_;
								_tmp446_ = vala_data_type_get_data_type (_tmp445_);
								_tmp447_ = _tmp446_;
								_tmp448_ = vala_symbol_get_scope ((ValaSymbol*) _tmp447_);
								_tmp449_ = _tmp448_;
								vala_symbol_set_owner ((ValaSymbol*) _tmp441_, _tmp449_);
								_tmp450_ = dynamic_object_type;
								_tmp451_ = vala_object_type_get_type_symbol (_tmp450_);
								_tmp452_ = _tmp451_;
								_tmp453_ = vala_symbol_get_scope ((ValaSymbol*) _tmp452_);
								_tmp454_ = _tmp453_;
								_tmp455_ = prop;
								vala_scope_add (_tmp454_, NULL, (ValaSymbol*) _tmp455_);
								_tmp456_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp456_);
								_vala_code_node_unref0 (prop);
							}
						}
						_vala_code_node_unref0 (a);
					} else {
						gboolean _tmp457_ = FALSE;
						gboolean _tmp458_ = FALSE;
						ValaCodeNode* _tmp459_;
						ValaCodeNode* _tmp460_;
						_tmp459_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
						_tmp460_ = _tmp459_;
						if (VALA_IS_MEMBER_ACCESS (_tmp460_)) {
							ValaExpression* _tmp461_;
							ValaExpression* _tmp462_;
							_tmp461_ = vala_member_access_get_inner (self);
							_tmp462_ = _tmp461_;
							_tmp458_ = VALA_IS_MEMBER_ACCESS (_tmp462_);
						} else {
							_tmp458_ = FALSE;
						}
						if (_tmp458_) {
							ValaCodeNode* _tmp463_;
							ValaCodeNode* _tmp464_;
							ValaCodeNode* _tmp465_;
							ValaCodeNode* _tmp466_;
							_tmp463_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp464_ = _tmp463_;
							_tmp465_ = vala_code_node_get_parent_node (_tmp464_);
							_tmp466_ = _tmp465_;
							_tmp457_ = VALA_IS_METHOD_CALL (_tmp466_);
						} else {
							_tmp457_ = FALSE;
						}
						if (_tmp457_) {
							ValaMemberAccess* ma = NULL;
							ValaCodeNode* _tmp467_;
							ValaCodeNode* _tmp468_;
							ValaMemberAccess* _tmp469_;
							gboolean _tmp470_ = FALSE;
							ValaMemberAccess* _tmp471_;
							const gchar* _tmp472_;
							_tmp467_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
							_tmp468_ = _tmp467_;
							_tmp469_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp468_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
							ma = _tmp469_;
							_tmp471_ = ma;
							_tmp472_ = _tmp471_->priv->_member_name;
							if (g_strcmp0 (_tmp472_, "connect") == 0) {
								_tmp470_ = TRUE;
							} else {
								ValaMemberAccess* _tmp473_;
								const gchar* _tmp474_;
								_tmp473_ = ma;
								_tmp474_ = _tmp473_->priv->_member_name;
								_tmp470_ = g_strcmp0 (_tmp474_, "connect_after") == 0;
							}
							if (_tmp470_) {
								ValaDynamicSignal* s = NULL;
								ValaExpression* _tmp475_;
								ValaExpression* _tmp476_;
								ValaDataType* _tmp477_;
								ValaDataType* _tmp478_;
								const gchar* _tmp479_;
								ValaVoidType* _tmp480_;
								ValaVoidType* _tmp481_;
								ValaSourceReference* _tmp482_;
								ValaSourceReference* _tmp483_;
								ValaDynamicSignal* _tmp484_;
								ValaDynamicSignal* _tmp485_;
								ValaMethodCall* mcall = NULL;
								ValaCodeNode* _tmp486_;
								ValaCodeNode* _tmp487_;
								ValaCodeNode* _tmp488_;
								ValaCodeNode* _tmp489_;
								ValaMethodCall* _tmp490_;
								ValaMethodCall* _tmp491_;
								ValaList* _tmp492_;
								ValaList* _tmp493_;
								gint _tmp494_;
								gint _tmp495_;
								gboolean _tmp496_;
								ValaDynamicSignal* _tmp503_;
								ValaObjectType* _tmp504_;
								ValaObjectTypeSymbol* _tmp505_;
								ValaObjectTypeSymbol* _tmp506_;
								ValaScope* _tmp507_;
								ValaScope* _tmp508_;
								ValaDynamicSignal* _tmp509_;
								ValaDynamicSignal* _tmp510_;
								_tmp475_ = vala_member_access_get_inner (self);
								_tmp476_ = _tmp475_;
								_tmp477_ = vala_expression_get_value_type (_tmp476_);
								_tmp478_ = _tmp477_;
								_tmp479_ = self->priv->_member_name;
								_tmp480_ = vala_void_type_new (NULL);
								_tmp481_ = _tmp480_;
								_tmp482_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp483_ = _tmp482_;
								_tmp484_ = vala_dynamic_signal_new (_tmp478_, _tmp479_, (ValaDataType*) _tmp481_, _tmp483_, NULL);
								_tmp485_ = _tmp484_;
								_vala_code_node_unref0 (_tmp481_);
								s = _tmp485_;
								_tmp486_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
								_tmp487_ = _tmp486_;
								_tmp488_ = vala_code_node_get_parent_node (_tmp487_);
								_tmp489_ = _tmp488_;
								_tmp490_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp489_, VALA_TYPE_METHOD_CALL, ValaMethodCall));
								mcall = _tmp490_;
								_tmp491_ = mcall;
								_tmp492_ = vala_method_call_get_argument_list (_tmp491_);
								_tmp493_ = _tmp492_;
								_tmp494_ = vala_collection_get_size ((ValaCollection*) _tmp493_);
								_tmp495_ = _tmp494_;
								_tmp496_ = _tmp495_ > 0;
								_vala_iterable_unref0 (_tmp493_);
								if (_tmp496_) {
									ValaDynamicSignal* _tmp497_;
									ValaMethodCall* _tmp498_;
									ValaList* _tmp499_;
									ValaList* _tmp500_;
									gpointer _tmp501_;
									ValaExpression* _tmp502_;
									_tmp497_ = s;
									_tmp498_ = mcall;
									_tmp499_ = vala_method_call_get_argument_list (_tmp498_);
									_tmp500_ = _tmp499_;
									_tmp501_ = vala_list_get (_tmp500_, 0);
									_tmp502_ = (ValaExpression*) _tmp501_;
									vala_dynamic_signal_set_handler (_tmp497_, _tmp502_);
									_vala_code_node_unref0 (_tmp502_);
									_vala_iterable_unref0 (_tmp500_);
								}
								_tmp503_ = s;
								vala_symbol_set_access ((ValaSymbol*) _tmp503_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
								_tmp504_ = dynamic_object_type;
								_tmp505_ = vala_object_type_get_type_symbol (_tmp504_);
								_tmp506_ = _tmp505_;
								_tmp507_ = vala_symbol_get_scope ((ValaSymbol*) _tmp506_);
								_tmp508_ = _tmp507_;
								_tmp509_ = s;
								vala_scope_add (_tmp508_, NULL, (ValaSymbol*) _tmp509_);
								_tmp510_ = s;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp510_);
								_vala_code_node_unref0 (mcall);
								_vala_code_node_unref0 (s);
							}
							_vala_code_node_unref0 (ma);
						}
					}
				}
				_tmp511_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp512_ = _tmp511_;
				if (_tmp512_ == NULL) {
					ValaDynamicProperty* prop = NULL;
					ValaExpression* _tmp513_;
					ValaExpression* _tmp514_;
					ValaDataType* _tmp515_;
					ValaDataType* _tmp516_;
					const gchar* _tmp517_;
					ValaSourceReference* _tmp518_;
					ValaSourceReference* _tmp519_;
					ValaDynamicProperty* _tmp520_;
					ValaDataType* _tmp521_;
					ValaDataType* _tmp522_;
					ValaDynamicProperty* _tmp533_;
					ValaDynamicProperty* _tmp534_;
					ValaDynamicProperty* _tmp535_;
					ValaDataType* _tmp536_;
					ValaDataType* _tmp537_;
					ValaDataType* _tmp538_;
					ValaDataType* _tmp539_;
					ValaDynamicProperty* _tmp540_;
					ValaSourceReference* _tmp541_;
					ValaSourceReference* _tmp542_;
					ValaPropertyAccessor* _tmp543_;
					ValaPropertyAccessor* _tmp544_;
					ValaDynamicProperty* _tmp545_;
					ValaExpression* _tmp546_;
					ValaExpression* _tmp547_;
					ValaDataType* _tmp548_;
					ValaDataType* _tmp549_;
					ValaTypeSymbol* _tmp550_;
					ValaTypeSymbol* _tmp551_;
					ValaScope* _tmp552_;
					ValaScope* _tmp553_;
					ValaObjectType* _tmp554_;
					ValaObjectTypeSymbol* _tmp555_;
					ValaObjectTypeSymbol* _tmp556_;
					ValaScope* _tmp557_;
					ValaScope* _tmp558_;
					ValaDynamicProperty* _tmp559_;
					ValaDynamicProperty* _tmp560_;
					_tmp513_ = vala_member_access_get_inner (self);
					_tmp514_ = _tmp513_;
					_tmp515_ = vala_expression_get_value_type (_tmp514_);
					_tmp516_ = _tmp515_;
					_tmp517_ = self->priv->_member_name;
					_tmp518_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp519_ = _tmp518_;
					_tmp520_ = vala_dynamic_property_new (_tmp516_, _tmp517_, _tmp519_, NULL);
					prop = _tmp520_;
					_tmp521_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp522_ = _tmp521_;
					if (_tmp522_ != NULL) {
						ValaDynamicProperty* _tmp523_;
						ValaDataType* _tmp524_;
						ValaDataType* _tmp525_;
						_tmp523_ = prop;
						_tmp524_ = vala_expression_get_target_type ((ValaExpression*) self);
						_tmp525_ = _tmp524_;
						vala_property_set_property_type ((ValaProperty*) _tmp523_, _tmp525_);
					} else {
						ValaDynamicProperty* _tmp526_;
						ValaExpression* _tmp527_;
						ValaExpression* _tmp528_;
						ValaDataType* _tmp529_;
						ValaDataType* _tmp530_;
						ValaDataType* _tmp531_;
						ValaDataType* _tmp532_;
						_tmp526_ = prop;
						_tmp527_ = vala_member_access_get_inner (self);
						_tmp528_ = _tmp527_;
						_tmp529_ = vala_expression_get_value_type (_tmp528_);
						_tmp530_ = _tmp529_;
						_tmp531_ = vala_data_type_copy (_tmp530_);
						_tmp532_ = _tmp531_;
						vala_property_set_property_type ((ValaProperty*) _tmp526_, _tmp532_);
						_vala_code_node_unref0 (_tmp532_);
					}
					_tmp533_ = prop;
					vala_symbol_set_access ((ValaSymbol*) _tmp533_, VALA_SYMBOL_ACCESSIBILITY_PUBLIC);
					_tmp534_ = prop;
					_tmp535_ = prop;
					_tmp536_ = vala_property_get_property_type ((ValaProperty*) _tmp535_);
					_tmp537_ = _tmp536_;
					_tmp538_ = vala_data_type_copy (_tmp537_);
					_tmp539_ = _tmp538_;
					_tmp540_ = prop;
					_tmp541_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp540_);
					_tmp542_ = _tmp541_;
					_tmp543_ = vala_property_accessor_new (TRUE, FALSE, FALSE, _tmp539_, NULL, _tmp542_, NULL);
					_tmp544_ = _tmp543_;
					vala_property_set_get_accessor ((ValaProperty*) _tmp534_, _tmp544_);
					_vala_code_node_unref0 (_tmp544_);
					_vala_code_node_unref0 (_tmp539_);
					_tmp545_ = prop;
					_tmp546_ = vala_member_access_get_inner (self);
					_tmp547_ = _tmp546_;
					_tmp548_ = vala_expression_get_value_type (_tmp547_);
					_tmp549_ = _tmp548_;
					_tmp550_ = vala_data_type_get_data_type (_tmp549_);
					_tmp551_ = _tmp550_;
					_tmp552_ = vala_symbol_get_scope ((ValaSymbol*) _tmp551_);
					_tmp553_ = _tmp552_;
					vala_symbol_set_owner ((ValaSymbol*) _tmp545_, _tmp553_);
					_tmp554_ = dynamic_object_type;
					_tmp555_ = vala_object_type_get_type_symbol (_tmp554_);
					_tmp556_ = _tmp555_;
					_tmp557_ = vala_symbol_get_scope ((ValaSymbol*) _tmp556_);
					_tmp558_ = _tmp557_;
					_tmp559_ = prop;
					vala_scope_add (_tmp558_, NULL, (ValaSymbol*) _tmp559_);
					_tmp560_ = prop;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp560_);
					_vala_code_node_unref0 (prop);
				}
				_tmp561_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp562_ = _tmp561_;
				if (_tmp562_ != NULL) {
					may_access_instance_members = TRUE;
					may_access_klass_members = TRUE;
				}
				_vala_code_node_unref0 (dynamic_object_type);
			}
			_tmp564_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp565_ = _tmp564_;
			if (VALA_IS_ARRAY_RESIZE_METHOD (_tmp565_)) {
				ValaExpression* _tmp566_;
				ValaExpression* _tmp567_;
				ValaDataType* _tmp568_;
				ValaDataType* _tmp569_;
				_tmp566_ = vala_member_access_get_inner (self);
				_tmp567_ = _tmp566_;
				_tmp568_ = vala_expression_get_value_type (_tmp567_);
				_tmp569_ = _tmp568_;
				_tmp563_ = VALA_IS_ARRAY_TYPE (_tmp569_);
			} else {
				_tmp563_ = FALSE;
			}
			if (_tmp563_) {
				ValaArrayType* value_array_type = NULL;
				ValaExpression* _tmp570_;
				ValaExpression* _tmp571_;
				ValaDataType* _tmp572_;
				ValaDataType* _tmp573_;
				gboolean _tmp574_ = FALSE;
				ValaArrayType* _tmp575_;
				_tmp570_ = vala_member_access_get_inner (self);
				_tmp571_ = _tmp570_;
				_tmp572_ = vala_expression_get_value_type (_tmp571_);
				_tmp573_ = _tmp572_;
				value_array_type = VALA_IS_ARRAY_TYPE (_tmp573_) ? ((ValaArrayType*) _tmp573_) : NULL;
				_tmp575_ = value_array_type;
				if (_tmp575_ != NULL) {
					ValaArrayType* _tmp576_;
					gboolean _tmp577_;
					gboolean _tmp578_;
					_tmp576_ = value_array_type;
					_tmp577_ = vala_array_type_get_inline_allocated (_tmp576_);
					_tmp578_ = _tmp577_;
					_tmp574_ = _tmp578_;
				} else {
					_tmp574_ = FALSE;
				}
				if (_tmp574_) {
					ValaSourceReference* _tmp579_;
					ValaSourceReference* _tmp580_;
					_tmp579_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp580_ = _tmp579_;
					vala_report_error (_tmp580_, "`resize' is not supported for arrays with fixed length");
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				}
			}
		}
	}
	_tmp583_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp584_ = _tmp583_;
	if (_tmp584_ == NULL) {
		ValaDataType* _tmp585_;
		ValaDataType* _tmp586_;
		_tmp585_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp586_ = _tmp585_;
		_tmp582_ = _tmp586_ != NULL;
	} else {
		_tmp582_ = FALSE;
	}
	if (_tmp582_) {
		ValaDataType* _tmp587_;
		ValaDataType* _tmp588_;
		ValaTypeSymbol* _tmp589_;
		ValaTypeSymbol* _tmp590_;
		_tmp587_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp588_ = _tmp587_;
		_tmp589_ = vala_data_type_get_data_type (_tmp588_);
		_tmp590_ = _tmp589_;
		_tmp581_ = VALA_IS_ENUM (_tmp590_);
	} else {
		_tmp581_ = FALSE;
	}
	if (_tmp581_) {
		ValaEnum* enum_type = NULL;
		ValaDataType* _tmp591_;
		ValaDataType* _tmp592_;
		ValaTypeSymbol* _tmp593_;
		ValaTypeSymbol* _tmp594_;
		ValaEnum* _tmp595_;
		_tmp591_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp592_ = _tmp591_;
		_tmp593_ = vala_data_type_get_data_type (_tmp592_);
		_tmp594_ = _tmp593_;
		_tmp595_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp594_, VALA_TYPE_ENUM, ValaEnum));
		enum_type = _tmp595_;
		{
			ValaList* _val_list = NULL;
			ValaEnum* _tmp596_;
			ValaList* _tmp597_;
			gint _val_size = 0;
			ValaList* _tmp598_;
			gint _tmp599_;
			gint _tmp600_;
			gint _val_index = 0;
			_tmp596_ = enum_type;
			_tmp597_ = vala_enum_get_values (_tmp596_);
			_val_list = _tmp597_;
			_tmp598_ = _val_list;
			_tmp599_ = vala_collection_get_size ((ValaCollection*) _tmp598_);
			_tmp600_ = _tmp599_;
			_val_size = _tmp600_;
			_val_index = -1;
			while (TRUE) {
				gint _tmp601_;
				gint _tmp602_;
				gint _tmp603_;
				ValaEnumValue* val = NULL;
				ValaList* _tmp604_;
				gint _tmp605_;
				gpointer _tmp606_;
				const gchar* _tmp607_;
				ValaEnumValue* _tmp608_;
				const gchar* _tmp609_;
				const gchar* _tmp610_;
				_tmp601_ = _val_index;
				_val_index = _tmp601_ + 1;
				_tmp602_ = _val_index;
				_tmp603_ = _val_size;
				if (!(_tmp602_ < _tmp603_)) {
					break;
				}
				_tmp604_ = _val_list;
				_tmp605_ = _val_index;
				_tmp606_ = vala_list_get (_tmp604_, _tmp605_);
				val = (ValaEnumValue*) _tmp606_;
				_tmp607_ = self->priv->_member_name;
				_tmp608_ = val;
				_tmp609_ = vala_symbol_get_name ((ValaSymbol*) _tmp608_);
				_tmp610_ = _tmp609_;
				if (g_strcmp0 (_tmp607_, _tmp610_) == 0) {
					ValaEnumValue* _tmp611_;
					_tmp611_ = val;
					vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp611_);
					_vala_code_node_unref0 (val);
					break;
				}
				_vala_code_node_unref0 (val);
			}
			_vala_iterable_unref0 (_val_list);
		}
		_vala_code_node_unref0 (enum_type);
	}
	_tmp612_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp613_ = _tmp612_;
	if (_tmp613_ == NULL) {
		gchar* base_type_name = NULL;
		gchar* _tmp614_;
		gboolean _tmp615_ = FALSE;
		ValaExpression* _tmp616_;
		ValaExpression* _tmp617_;
		ValaSourceReference* _tmp630_;
		ValaSourceReference* _tmp631_;
		const gchar* _tmp632_;
		const gchar* _tmp633_;
		gchar* _tmp634_;
		gchar* _tmp635_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp614_ = g_strdup ("(null)");
		base_type_name = _tmp614_;
		_tmp616_ = vala_member_access_get_inner (self);
		_tmp617_ = _tmp616_;
		if (_tmp617_ != NULL) {
			ValaExpression* _tmp618_;
			ValaExpression* _tmp619_;
			ValaDataType* _tmp620_;
			ValaDataType* _tmp621_;
			_tmp618_ = vala_member_access_get_inner (self);
			_tmp619_ = _tmp618_;
			_tmp620_ = vala_expression_get_value_type (_tmp619_);
			_tmp621_ = _tmp620_;
			_tmp615_ = _tmp621_ != NULL;
		} else {
			_tmp615_ = FALSE;
		}
		if (_tmp615_) {
			ValaExpression* _tmp622_;
			ValaExpression* _tmp623_;
			ValaDataType* _tmp624_;
			ValaDataType* _tmp625_;
			gchar* _tmp626_;
			_tmp622_ = vala_member_access_get_inner (self);
			_tmp623_ = _tmp622_;
			_tmp624_ = vala_expression_get_value_type (_tmp623_);
			_tmp625_ = _tmp624_;
			_tmp626_ = vala_code_node_to_string ((ValaCodeNode*) _tmp625_);
			_g_free0 (base_type_name);
			base_type_name = _tmp626_;
		} else {
			ValaSymbol* _tmp627_;
			_tmp627_ = base_symbol;
			if (_tmp627_ != NULL) {
				ValaSymbol* _tmp628_;
				gchar* _tmp629_;
				_tmp628_ = base_symbol;
				_tmp629_ = vala_symbol_get_full_name (_tmp628_);
				_g_free0 (base_type_name);
				base_type_name = _tmp629_;
			}
		}
		_tmp630_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp631_ = _tmp630_;
		_tmp632_ = self->priv->_member_name;
		_tmp633_ = base_type_name;
		_tmp634_ = g_strdup_printf ("The name `%s' does not exist in the context of `%s'", _tmp632_, _tmp633_);
		_tmp635_ = _tmp634_;
		vala_report_error (_tmp631_, _tmp635_);
		_g_free0 (_tmp635_);
		result = FALSE;
		_g_free0 (base_type_name);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp636_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp637_ = _tmp636_;
	_tmp638_ = _vala_code_node_ref0 (_tmp637_);
	member = _tmp638_;
	access = VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
	instance = FALSE;
	klass = FALSE;
	generics = FALSE;
	_tmp639_ = member;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp639_, context)) {
		result = FALSE;
		_vala_code_node_unref0 (member);
		_vala_code_node_unref0 (this_parameter);
		_vala_code_node_unref0 (base_symbol);
		return result;
	}
	_tmp640_ = member;
	if (VALA_IS_LOCAL_VARIABLE (_tmp640_)) {
		ValaLocalVariable* local = NULL;
		ValaSymbol* _tmp641_;
		ValaLocalVariable* _tmp642_;
		ValaBlock* block = NULL;
		ValaLocalVariable* _tmp643_;
		ValaSymbol* _tmp644_;
		ValaSymbol* _tmp645_;
		ValaBlock* _tmp646_;
		gboolean _tmp647_ = FALSE;
		ValaBlock* _tmp648_;
		_tmp641_ = member;
		_tmp642_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp641_, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable));
		local = _tmp642_;
		_tmp643_ = local;
		_tmp644_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp643_);
		_tmp645_ = _tmp644_;
		_tmp646_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp645_) ? ((ValaBlock*) _tmp645_) : NULL);
		block = _tmp646_;
		_tmp648_ = block;
		if (_tmp648_ != NULL) {
			ValaSemanticAnalyzer* _tmp649_;
			ValaSemanticAnalyzer* _tmp650_;
			ValaBlock* _tmp651_;
			ValaSymbol* _tmp652_;
			ValaSymbol* _tmp653_;
			ValaSemanticAnalyzer* _tmp654_;
			ValaSemanticAnalyzer* _tmp655_;
			ValaSymbol* _tmp656_;
			ValaSymbol* _tmp657_;
			_tmp649_ = vala_code_context_get_analyzer (context);
			_tmp650_ = _tmp649_;
			_tmp651_ = block;
			_tmp652_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp650_, (ValaSymbol*) _tmp651_);
			_tmp653_ = _tmp652_;
			_tmp654_ = vala_code_context_get_analyzer (context);
			_tmp655_ = _tmp654_;
			_tmp656_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp655_);
			_tmp657_ = _tmp656_;
			_tmp647_ = _tmp653_ != _tmp657_;
			_vala_code_node_unref0 (_tmp653_);
		} else {
			_tmp647_ = FALSE;
		}
		if (_tmp647_) {
			ValaSymbol* sym = NULL;
			ValaSemanticAnalyzer* _tmp658_;
			ValaSemanticAnalyzer* _tmp659_;
			ValaSymbol* _tmp660_;
			ValaSymbol* _tmp661_;
			ValaSymbol* _tmp662_;
			ValaLocalVariable* _tmp675_;
			ValaBlock* _tmp676_;
			_tmp658_ = vala_code_context_get_analyzer (context);
			_tmp659_ = _tmp658_;
			_tmp660_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp659_);
			_tmp661_ = _tmp660_;
			_tmp662_ = _vala_code_node_ref0 (_tmp661_);
			sym = _tmp662_;
			while (TRUE) {
				ValaSymbol* _tmp663_;
				ValaBlock* _tmp664_;
				ValaMethod* method = NULL;
				ValaSymbol* _tmp665_;
				ValaMethod* _tmp666_;
				ValaMethod* _tmp667_;
				ValaSymbol* _tmp671_;
				ValaSymbol* _tmp672_;
				ValaSymbol* _tmp673_;
				ValaSymbol* _tmp674_;
				_tmp663_ = sym;
				_tmp664_ = block;
				if (!(_tmp663_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp664_, VALA_TYPE_SYMBOL, ValaSymbol))) {
					break;
				}
				_tmp665_ = sym;
				_tmp666_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp665_) ? ((ValaMethod*) _tmp665_) : NULL);
				method = _tmp666_;
				_tmp667_ = method;
				if (_tmp667_ != NULL) {
					ValaMethod* _tmp668_;
					ValaMethod* _tmp669_;
					ValaLocalVariable* _tmp670_;
					_tmp668_ = method;
					vala_method_set_closure (_tmp668_, TRUE);
					_tmp669_ = method;
					_tmp670_ = local;
					vala_method_add_captured_variable (_tmp669_, _tmp670_);
				}
				_tmp671_ = sym;
				_tmp672_ = vala_symbol_get_parent_symbol (_tmp671_);
				_tmp673_ = _tmp672_;
				_tmp674_ = _vala_code_node_ref0 (_tmp673_);
				_vala_code_node_unref0 (sym);
				sym = _tmp674_;
				_vala_code_node_unref0 (method);
			}
			_tmp675_ = local;
			vala_local_variable_set_captured (_tmp675_, TRUE);
			_tmp676_ = block;
			vala_block_set_captured (_tmp676_, TRUE);
			_vala_code_node_unref0 (sym);
		}
		_vala_code_node_unref0 (block);
		_vala_code_node_unref0 (local);
	} else {
		ValaSymbol* _tmp677_;
		_tmp677_ = member;
		if (VALA_IS_PARAMETER (_tmp677_)) {
			ValaParameter* param = NULL;
			ValaSymbol* _tmp678_;
			ValaParameter* _tmp679_;
			ValaMethod* m = NULL;
			ValaParameter* _tmp680_;
			ValaSymbol* _tmp681_;
			ValaSymbol* _tmp682_;
			ValaMethod* _tmp683_;
			gboolean _tmp684_ = FALSE;
			gboolean _tmp685_ = FALSE;
			ValaMethod* _tmp686_;
			_tmp678_ = member;
			_tmp679_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp678_, VALA_TYPE_PARAMETER, ValaParameter));
			param = _tmp679_;
			_tmp680_ = param;
			_tmp681_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp680_);
			_tmp682_ = _tmp681_;
			_tmp683_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp682_) ? ((ValaMethod*) _tmp682_) : NULL);
			m = _tmp683_;
			_tmp686_ = m;
			if (_tmp686_ != NULL) {
				ValaMethod* _tmp687_;
				ValaSemanticAnalyzer* _tmp688_;
				ValaSemanticAnalyzer* _tmp689_;
				ValaSymbol* _tmp690_;
				ValaSymbol* _tmp691_;
				_tmp687_ = m;
				_tmp688_ = vala_code_context_get_analyzer (context);
				_tmp689_ = _tmp688_;
				_tmp690_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp689_);
				_tmp691_ = _tmp690_;
				_tmp685_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp687_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp691_;
			} else {
				_tmp685_ = FALSE;
			}
			if (_tmp685_) {
				ValaParameter* _tmp692_;
				ValaMethod* _tmp693_;
				ValaParameter* _tmp694_;
				ValaParameter* _tmp695_;
				_tmp692_ = param;
				_tmp693_ = m;
				_tmp694_ = vala_method_get_this_parameter (_tmp693_);
				_tmp695_ = _tmp694_;
				_tmp684_ = _tmp692_ != _tmp695_;
			} else {
				_tmp684_ = FALSE;
			}
			if (_tmp684_) {
				ValaSymbol* sym = NULL;
				ValaSemanticAnalyzer* _tmp696_;
				ValaSemanticAnalyzer* _tmp697_;
				ValaSymbol* _tmp698_;
				ValaSymbol* _tmp699_;
				ValaSymbol* _tmp700_;
				ValaParameter* _tmp711_;
				ValaMethod* _tmp712_;
				ValaBlock* _tmp713_;
				ValaBlock* _tmp714_;
				ValaParameter* _tmp715_;
				ValaParameterDirection _tmp716_;
				ValaParameterDirection _tmp717_;
				_tmp696_ = vala_code_context_get_analyzer (context);
				_tmp697_ = _tmp696_;
				_tmp698_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp697_);
				_tmp699_ = _tmp698_;
				_tmp700_ = _vala_code_node_ref0 (_tmp699_);
				sym = _tmp700_;
				while (TRUE) {
					ValaSymbol* _tmp701_;
					ValaMethod* _tmp702_;
					ValaMethod* method = NULL;
					ValaSymbol* _tmp703_;
					ValaMethod* _tmp704_;
					ValaMethod* _tmp705_;
					ValaSymbol* _tmp707_;
					ValaSymbol* _tmp708_;
					ValaSymbol* _tmp709_;
					ValaSymbol* _tmp710_;
					_tmp701_ = sym;
					_tmp702_ = m;
					if (!(_tmp701_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp702_, VALA_TYPE_SYMBOL, ValaSymbol))) {
						break;
					}
					_tmp703_ = sym;
					_tmp704_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp703_) ? ((ValaMethod*) _tmp703_) : NULL);
					method = _tmp704_;
					_tmp705_ = method;
					if (_tmp705_ != NULL) {
						ValaMethod* _tmp706_;
						_tmp706_ = method;
						vala_method_set_closure (_tmp706_, TRUE);
					}
					_tmp707_ = sym;
					_tmp708_ = vala_symbol_get_parent_symbol (_tmp707_);
					_tmp709_ = _tmp708_;
					_tmp710_ = _vala_code_node_ref0 (_tmp709_);
					_vala_code_node_unref0 (sym);
					sym = _tmp710_;
					_vala_code_node_unref0 (method);
				}
				_tmp711_ = param;
				vala_parameter_set_captured (_tmp711_, TRUE);
				_tmp712_ = m;
				_tmp713_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp712_);
				_tmp714_ = _tmp713_;
				vala_block_set_captured (_tmp714_, TRUE);
				_tmp715_ = param;
				_tmp716_ = vala_parameter_get_direction (_tmp715_);
				_tmp717_ = _tmp716_;
				if (_tmp717_ != VALA_PARAMETER_DIRECTION_IN) {
					ValaSourceReference* _tmp718_;
					ValaSourceReference* _tmp719_;
					ValaParameter* _tmp720_;
					gchar* _tmp721_;
					gchar* _tmp722_;
					gchar* _tmp723_;
					gchar* _tmp724_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp718_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp719_ = _tmp718_;
					_tmp720_ = param;
					_tmp721_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp720_);
					_tmp722_ = _tmp721_;
					_tmp723_ = g_strdup_printf ("Cannot capture reference or output parameter `%s'", _tmp722_);
					_tmp724_ = _tmp723_;
					vala_report_error (_tmp719_, _tmp724_);
					_g_free0 (_tmp724_);
					_g_free0 (_tmp722_);
				}
				_vala_code_node_unref0 (sym);
			} else {
				ValaPropertyAccessor* acc = NULL;
				ValaParameter* _tmp725_;
				ValaSymbol* _tmp726_;
				ValaSymbol* _tmp727_;
				ValaSymbol* _tmp728_;
				ValaSymbol* _tmp729_;
				ValaPropertyAccessor* _tmp730_;
				gboolean _tmp731_ = FALSE;
				gboolean _tmp732_ = FALSE;
				ValaPropertyAccessor* _tmp733_;
				_tmp725_ = param;
				_tmp726_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp725_);
				_tmp727_ = _tmp726_;
				_tmp728_ = vala_symbol_get_parent_symbol (_tmp727_);
				_tmp729_ = _tmp728_;
				_tmp730_ = _vala_code_node_ref0 (VALA_IS_PROPERTY_ACCESSOR (_tmp729_) ? ((ValaPropertyAccessor*) _tmp729_) : NULL);
				acc = _tmp730_;
				_tmp733_ = acc;
				if (_tmp733_ != NULL) {
					ValaPropertyAccessor* _tmp734_;
					ValaSemanticAnalyzer* _tmp735_;
					ValaSemanticAnalyzer* _tmp736_;
					ValaSymbol* _tmp737_;
					ValaSymbol* _tmp738_;
					_tmp734_ = acc;
					_tmp735_ = vala_code_context_get_analyzer (context);
					_tmp736_ = _tmp735_;
					_tmp737_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp736_);
					_tmp738_ = _tmp737_;
					_tmp732_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp734_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp738_;
				} else {
					_tmp732_ = FALSE;
				}
				if (_tmp732_) {
					ValaParameter* _tmp739_;
					ValaPropertyAccessor* _tmp740_;
					ValaProperty* _tmp741_;
					ValaProperty* _tmp742_;
					ValaParameter* _tmp743_;
					ValaParameter* _tmp744_;
					_tmp739_ = param;
					_tmp740_ = acc;
					_tmp741_ = vala_property_accessor_get_prop (_tmp740_);
					_tmp742_ = _tmp741_;
					_tmp743_ = vala_property_get_this_parameter (_tmp742_);
					_tmp744_ = _tmp743_;
					_tmp731_ = _tmp739_ != _tmp744_;
				} else {
					_tmp731_ = FALSE;
				}
				if (_tmp731_) {
					ValaSymbol* sym = NULL;
					ValaSemanticAnalyzer* _tmp745_;
					ValaSemanticAnalyzer* _tmp746_;
					ValaSymbol* _tmp747_;
					ValaSymbol* _tmp748_;
					ValaSymbol* _tmp749_;
					ValaParameter* _tmp760_;
					ValaPropertyAccessor* _tmp761_;
					ValaBlock* _tmp762_;
					ValaBlock* _tmp763_;
					_tmp745_ = vala_code_context_get_analyzer (context);
					_tmp746_ = _tmp745_;
					_tmp747_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp746_);
					_tmp748_ = _tmp747_;
					_tmp749_ = _vala_code_node_ref0 (_tmp748_);
					sym = _tmp749_;
					while (TRUE) {
						ValaSymbol* _tmp750_;
						ValaMethod* _tmp751_;
						ValaMethod* method = NULL;
						ValaSymbol* _tmp752_;
						ValaMethod* _tmp753_;
						ValaMethod* _tmp754_;
						ValaSymbol* _tmp756_;
						ValaSymbol* _tmp757_;
						ValaSymbol* _tmp758_;
						ValaSymbol* _tmp759_;
						_tmp750_ = sym;
						_tmp751_ = m;
						if (!(_tmp750_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp751_, VALA_TYPE_SYMBOL, ValaSymbol))) {
							break;
						}
						_tmp752_ = sym;
						_tmp753_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp752_) ? ((ValaMethod*) _tmp752_) : NULL);
						method = _tmp753_;
						_tmp754_ = method;
						if (_tmp754_ != NULL) {
							ValaMethod* _tmp755_;
							_tmp755_ = method;
							vala_method_set_closure (_tmp755_, TRUE);
						}
						_tmp756_ = sym;
						_tmp757_ = vala_symbol_get_parent_symbol (_tmp756_);
						_tmp758_ = _tmp757_;
						_tmp759_ = _vala_code_node_ref0 (_tmp758_);
						_vala_code_node_unref0 (sym);
						sym = _tmp759_;
						_vala_code_node_unref0 (method);
					}
					_tmp760_ = param;
					vala_parameter_set_captured (_tmp760_, TRUE);
					_tmp761_ = acc;
					_tmp762_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp761_);
					_tmp763_ = _tmp762_;
					vala_block_set_captured (_tmp763_, TRUE);
					_vala_code_node_unref0 (sym);
				}
				_vala_code_node_unref0 (acc);
			}
			_vala_code_node_unref0 (m);
			_vala_code_node_unref0 (param);
		} else {
			ValaSymbol* _tmp764_;
			_tmp764_ = member;
			if (VALA_IS_FIELD (_tmp764_)) {
				ValaField* f = NULL;
				ValaSymbol* _tmp765_;
				ValaField* _tmp766_;
				ValaField* _tmp767_;
				ValaSymbolAccessibility _tmp768_;
				ValaSymbolAccessibility _tmp769_;
				ValaField* _tmp770_;
				ValaMemberBinding _tmp771_;
				ValaMemberBinding _tmp772_;
				ValaField* _tmp773_;
				ValaMemberBinding _tmp774_;
				ValaMemberBinding _tmp775_;
				ValaField* _tmp776_;
				ValaDataType* _tmp777_;
				ValaDataType* _tmp778_;
				_tmp765_ = member;
				_tmp766_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp765_, VALA_TYPE_FIELD, ValaField));
				f = _tmp766_;
				_tmp767_ = f;
				_tmp768_ = vala_symbol_get_access ((ValaSymbol*) _tmp767_);
				_tmp769_ = _tmp768_;
				access = _tmp769_;
				_tmp770_ = f;
				_tmp771_ = vala_field_get_binding (_tmp770_);
				_tmp772_ = _tmp771_;
				instance = _tmp772_ == VALA_MEMBER_BINDING_INSTANCE;
				_tmp773_ = f;
				_tmp774_ = vala_field_get_binding (_tmp773_);
				_tmp775_ = _tmp774_;
				klass = _tmp775_ == VALA_MEMBER_BINDING_CLASS;
				_tmp776_ = f;
				_tmp777_ = vala_variable_get_variable_type ((ValaVariable*) _tmp776_);
				_tmp778_ = _tmp777_;
				if (VALA_IS_GENERIC_TYPE (_tmp778_)) {
					generics = TRUE;
				}
				_vala_code_node_unref0 (f);
			} else {
				ValaSymbol* _tmp779_;
				_tmp779_ = member;
				if (VALA_IS_CONSTANT (_tmp779_)) {
					ValaConstant* c = NULL;
					ValaSymbol* _tmp780_;
					ValaConstant* _tmp781_;
					ValaConstant* _tmp782_;
					ValaSymbolAccessibility _tmp783_;
					ValaSymbolAccessibility _tmp784_;
					ValaBlock* block = NULL;
					ValaConstant* _tmp785_;
					ValaSymbol* _tmp786_;
					ValaSymbol* _tmp787_;
					ValaBlock* _tmp788_;
					gboolean _tmp789_ = FALSE;
					ValaBlock* _tmp790_;
					_tmp780_ = member;
					_tmp781_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp780_, VALA_TYPE_CONSTANT, ValaConstant));
					c = _tmp781_;
					_tmp782_ = c;
					_tmp783_ = vala_symbol_get_access ((ValaSymbol*) _tmp782_);
					_tmp784_ = _tmp783_;
					access = _tmp784_;
					_tmp785_ = c;
					_tmp786_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp785_);
					_tmp787_ = _tmp786_;
					_tmp788_ = _vala_code_node_ref0 (VALA_IS_BLOCK (_tmp787_) ? ((ValaBlock*) _tmp787_) : NULL);
					block = _tmp788_;
					_tmp790_ = block;
					if (_tmp790_ != NULL) {
						ValaSemanticAnalyzer* _tmp791_;
						ValaSemanticAnalyzer* _tmp792_;
						ValaBlock* _tmp793_;
						ValaSymbol* _tmp794_;
						ValaSymbol* _tmp795_;
						ValaSemanticAnalyzer* _tmp796_;
						ValaSemanticAnalyzer* _tmp797_;
						ValaSymbol* _tmp798_;
						ValaSymbol* _tmp799_;
						_tmp791_ = vala_code_context_get_analyzer (context);
						_tmp792_ = _tmp791_;
						_tmp793_ = block;
						_tmp794_ = vala_semantic_analyzer_find_parent_method_or_property_accessor (_tmp792_, (ValaSymbol*) _tmp793_);
						_tmp795_ = _tmp794_;
						_tmp796_ = vala_code_context_get_analyzer (context);
						_tmp797_ = _tmp796_;
						_tmp798_ = vala_semantic_analyzer_get_current_method_or_property_accessor (_tmp797_);
						_tmp799_ = _tmp798_;
						_tmp789_ = _tmp795_ != _tmp799_;
						_vala_code_node_unref0 (_tmp795_);
					} else {
						_tmp789_ = FALSE;
					}
					if (_tmp789_) {
						ValaSourceReference* _tmp800_;
						ValaSourceReference* _tmp801_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp800_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp801_ = _tmp800_;
						vala_report_error (_tmp801_, "internal error: accessing local constants of outer methods is not supp" \
"orted yet");
						result = FALSE;
						_vala_code_node_unref0 (block);
						_vala_code_node_unref0 (c);
						_vala_code_node_unref0 (member);
						_vala_code_node_unref0 (this_parameter);
						_vala_code_node_unref0 (base_symbol);
						return result;
					}
					_vala_code_node_unref0 (block);
					_vala_code_node_unref0 (c);
				} else {
					ValaSymbol* _tmp802_;
					_tmp802_ = member;
					if (VALA_IS_METHOD (_tmp802_)) {
						ValaMethod* m = NULL;
						ValaSymbol* _tmp803_;
						ValaMethod* _tmp804_;
						ValaMethod* _tmp805_;
						gboolean _tmp806_;
						gboolean _tmp807_;
						ValaMethod* _tmp910_;
						ValaSymbolAccessibility _tmp911_;
						ValaSymbolAccessibility _tmp912_;
						ValaMethod* _tmp913_;
						ValaMethod* _tmp917_;
						ValaMemberBinding _tmp918_;
						ValaMemberBinding _tmp919_;
						ValaGenericType* generic_type = NULL;
						ValaMethod* _tmp942_;
						ValaDataType* _tmp943_;
						ValaDataType* _tmp944_;
						ValaGenericType* _tmp945_;
						gboolean _tmp946_ = FALSE;
						ValaGenericType* _tmp947_;
						_tmp803_ = member;
						_tmp804_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp803_, VALA_TYPE_METHOD, ValaMethod));
						m = _tmp804_;
						_tmp805_ = m;
						_tmp806_ = vala_method_get_is_async_callback (_tmp805_);
						_tmp807_ = _tmp806_;
						if (_tmp807_) {
							ValaMethod* async_method = NULL;
							ValaSemanticAnalyzer* _tmp808_;
							ValaSemanticAnalyzer* _tmp809_;
							ValaMethod* _tmp810_;
							ValaMethod* _tmp811_;
							ValaMethod* _tmp812_;
							gboolean is_valid_access = FALSE;
							ValaMethod* _tmp813_;
							gboolean _tmp839_;
							ValaMethod* _tmp847_;
							ValaSemanticAnalyzer* _tmp848_;
							ValaSemanticAnalyzer* _tmp849_;
							ValaMethod* _tmp850_;
							ValaMethod* _tmp851_;
							ValaMethod* _tmp870_;
							ValaMethod* _tmp871_;
							ValaMethod* _tmp872_;
							ValaSymbol* _tmp873_;
							ValaSymbol* _tmp874_;
							ValaSymbol* _tmp875_;
							_tmp808_ = vala_code_context_get_analyzer (context);
							_tmp809_ = _tmp808_;
							_tmp810_ = vala_semantic_analyzer_get_current_async_method (_tmp809_);
							_tmp811_ = _tmp810_;
							_tmp812_ = _vala_code_node_ref0 (_tmp811_);
							async_method = _tmp812_;
							is_valid_access = FALSE;
							_tmp813_ = async_method;
							if (_tmp813_ != NULL) {
								ValaMethod* _tmp814_;
								ValaMethod* _tmp815_;
								ValaMethod* _tmp816_;
								ValaMethod* _tmp817_;
								gboolean _tmp818_;
								_tmp814_ = m;
								_tmp815_ = async_method;
								_tmp816_ = vala_method_get_callback_method (_tmp815_);
								_tmp817_ = _tmp816_;
								_tmp818_ = _tmp814_ == _tmp817_;
								_vala_code_node_unref0 (_tmp817_);
								if (_tmp818_) {
									is_valid_access = TRUE;
								} else {
									gboolean _tmp819_ = FALSE;
									ValaMethod* _tmp820_;
									ValaMethod* _tmp821_;
									ValaMethod* _tmp822_;
									_tmp820_ = async_method;
									_tmp821_ = vala_method_get_base_method (_tmp820_);
									_tmp822_ = _tmp821_;
									if (_tmp822_ != NULL) {
										ValaMethod* _tmp823_;
										ValaMethod* _tmp824_;
										ValaMethod* _tmp825_;
										ValaMethod* _tmp826_;
										ValaMethod* _tmp827_;
										ValaMethod* _tmp828_;
										_tmp823_ = m;
										_tmp824_ = async_method;
										_tmp825_ = vala_method_get_base_method (_tmp824_);
										_tmp826_ = _tmp825_;
										_tmp827_ = vala_method_get_callback_method (_tmp826_);
										_tmp828_ = _tmp827_;
										_tmp819_ = _tmp823_ == _tmp828_;
										_vala_code_node_unref0 (_tmp828_);
									} else {
										_tmp819_ = FALSE;
									}
									if (_tmp819_) {
										is_valid_access = TRUE;
									} else {
										gboolean _tmp829_ = FALSE;
										ValaMethod* _tmp830_;
										ValaMethod* _tmp831_;
										ValaMethod* _tmp832_;
										_tmp830_ = async_method;
										_tmp831_ = vala_method_get_base_interface_method (_tmp830_);
										_tmp832_ = _tmp831_;
										if (_tmp832_ != NULL) {
											ValaMethod* _tmp833_;
											ValaMethod* _tmp834_;
											ValaMethod* _tmp835_;
											ValaMethod* _tmp836_;
											ValaMethod* _tmp837_;
											ValaMethod* _tmp838_;
											_tmp833_ = m;
											_tmp834_ = async_method;
											_tmp835_ = vala_method_get_base_interface_method (_tmp834_);
											_tmp836_ = _tmp835_;
											_tmp837_ = vala_method_get_callback_method (_tmp836_);
											_tmp838_ = _tmp837_;
											_tmp829_ = _tmp833_ == _tmp838_;
											_vala_code_node_unref0 (_tmp838_);
										} else {
											_tmp829_ = FALSE;
										}
										if (_tmp829_) {
											is_valid_access = TRUE;
										}
									}
								}
							}
							_tmp839_ = is_valid_access;
							if (!_tmp839_) {
								ValaSourceReference* _tmp840_;
								ValaSourceReference* _tmp841_;
								ValaMethod* _tmp842_;
								gchar* _tmp843_;
								gchar* _tmp844_;
								gchar* _tmp845_;
								gchar* _tmp846_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp840_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp841_ = _tmp840_;
								_tmp842_ = m;
								_tmp843_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp842_);
								_tmp844_ = _tmp843_;
								_tmp845_ = g_strdup_printf ("Access to async callback `%s' not allowed in this context", _tmp844_);
								_tmp846_ = _tmp845_;
								vala_report_error (_tmp841_, _tmp846_);
								_g_free0 (_tmp846_);
								_g_free0 (_tmp844_);
								result = FALSE;
								_vala_code_node_unref0 (async_method);
								_vala_code_node_unref0 (m);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp847_ = async_method;
							_tmp848_ = vala_code_context_get_analyzer (context);
							_tmp849_ = _tmp848_;
							_tmp850_ = vala_semantic_analyzer_get_current_method (_tmp849_);
							_tmp851_ = _tmp850_;
							if (_tmp847_ != _tmp851_) {
								ValaSymbol* sym = NULL;
								ValaSemanticAnalyzer* _tmp852_;
								ValaSemanticAnalyzer* _tmp853_;
								ValaMethod* _tmp854_;
								ValaMethod* _tmp855_;
								ValaSymbol* _tmp856_;
								ValaMethod* _tmp867_;
								ValaBlock* _tmp868_;
								ValaBlock* _tmp869_;
								_tmp852_ = vala_code_context_get_analyzer (context);
								_tmp853_ = _tmp852_;
								_tmp854_ = vala_semantic_analyzer_get_current_method (_tmp853_);
								_tmp855_ = _tmp854_;
								_tmp856_ = _vala_code_node_ref0 ((ValaSymbol*) _tmp855_);
								sym = _tmp856_;
								while (TRUE) {
									ValaSymbol* _tmp857_;
									ValaMethod* _tmp858_;
									ValaMethod* method = NULL;
									ValaSymbol* _tmp859_;
									ValaMethod* _tmp860_;
									ValaMethod* _tmp861_;
									ValaSymbol* _tmp863_;
									ValaSymbol* _tmp864_;
									ValaSymbol* _tmp865_;
									ValaSymbol* _tmp866_;
									_tmp857_ = sym;
									_tmp858_ = async_method;
									if (!(_tmp857_ != G_TYPE_CHECK_INSTANCE_CAST (_tmp858_, VALA_TYPE_SYMBOL, ValaSymbol))) {
										break;
									}
									_tmp859_ = sym;
									_tmp860_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp859_) ? ((ValaMethod*) _tmp859_) : NULL);
									method = _tmp860_;
									_tmp861_ = method;
									if (_tmp861_ != NULL) {
										ValaMethod* _tmp862_;
										_tmp862_ = method;
										vala_method_set_closure (_tmp862_, TRUE);
									}
									_tmp863_ = sym;
									_tmp864_ = vala_symbol_get_parent_symbol (_tmp863_);
									_tmp865_ = _tmp864_;
									_tmp866_ = _vala_code_node_ref0 (_tmp865_);
									_vala_code_node_unref0 (sym);
									sym = _tmp866_;
									_vala_code_node_unref0 (method);
								}
								_tmp867_ = async_method;
								_tmp868_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp867_);
								_tmp869_ = _tmp868_;
								vala_block_set_captured (_tmp869_, TRUE);
								_vala_code_node_unref0 (sym);
							}
							_tmp870_ = async_method;
							_tmp871_ = vala_method_get_callback_method (_tmp870_);
							_vala_code_node_unref0 (m);
							m = _tmp871_;
							_tmp872_ = m;
							vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp872_);
							_tmp873_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
							_tmp874_ = _tmp873_;
							_tmp875_ = _vala_code_node_ref0 (_tmp874_);
							_vala_code_node_unref0 (member);
							member = _tmp875_;
							_vala_code_node_unref0 (async_method);
						} else {
							ValaMethod* _tmp876_;
							ValaMethod* _tmp877_;
							ValaMethod* _tmp878_;
							_tmp876_ = m;
							_tmp877_ = vala_method_get_base_method (_tmp876_);
							_tmp878_ = _tmp877_;
							if (_tmp878_ != NULL) {
								ValaMethod* _tmp879_;
								ValaMethod* _tmp880_;
								ValaMethod* _tmp881_;
								ValaMethod* _tmp882_;
								ValaMethod* _tmp883_;
								ValaSignal* _tmp884_;
								ValaSignal* _tmp885_;
								ValaSymbol* _tmp890_;
								ValaSymbol* _tmp891_;
								ValaSymbol* _tmp892_;
								_tmp879_ = m;
								_tmp880_ = vala_method_get_base_method (_tmp879_);
								_tmp881_ = _tmp880_;
								_tmp882_ = _vala_code_node_ref0 (_tmp881_);
								_vala_code_node_unref0 (m);
								m = _tmp882_;
								_tmp883_ = m;
								_tmp884_ = vala_method_get_signal_reference (_tmp883_);
								_tmp885_ = _tmp884_;
								if (_tmp885_ != NULL) {
									ValaMethod* _tmp886_;
									ValaSignal* _tmp887_;
									ValaSignal* _tmp888_;
									_tmp886_ = m;
									_tmp887_ = vala_method_get_signal_reference (_tmp886_);
									_tmp888_ = _tmp887_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp888_);
								} else {
									ValaMethod* _tmp889_;
									_tmp889_ = m;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp889_);
								}
								_tmp890_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp891_ = _tmp890_;
								_tmp892_ = _vala_code_node_ref0 (_tmp891_);
								_vala_code_node_unref0 (member);
								member = _tmp892_;
							} else {
								ValaMethod* _tmp893_;
								ValaMethod* _tmp894_;
								ValaMethod* _tmp895_;
								_tmp893_ = m;
								_tmp894_ = vala_method_get_base_interface_method (_tmp893_);
								_tmp895_ = _tmp894_;
								if (_tmp895_ != NULL) {
									ValaMethod* _tmp896_;
									ValaMethod* _tmp897_;
									ValaMethod* _tmp898_;
									ValaMethod* _tmp899_;
									ValaMethod* _tmp900_;
									ValaSignal* _tmp901_;
									ValaSignal* _tmp902_;
									ValaSymbol* _tmp907_;
									ValaSymbol* _tmp908_;
									ValaSymbol* _tmp909_;
									_tmp896_ = m;
									_tmp897_ = vala_method_get_base_interface_method (_tmp896_);
									_tmp898_ = _tmp897_;
									_tmp899_ = _vala_code_node_ref0 (_tmp898_);
									_vala_code_node_unref0 (m);
									m = _tmp899_;
									_tmp900_ = m;
									_tmp901_ = vala_method_get_signal_reference (_tmp900_);
									_tmp902_ = _tmp901_;
									if (_tmp902_ != NULL) {
										ValaMethod* _tmp903_;
										ValaSignal* _tmp904_;
										ValaSignal* _tmp905_;
										_tmp903_ = m;
										_tmp904_ = vala_method_get_signal_reference (_tmp903_);
										_tmp905_ = _tmp904_;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp905_);
									} else {
										ValaMethod* _tmp906_;
										_tmp906_ = m;
										vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp906_);
									}
									_tmp907_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp908_ = _tmp907_;
									_tmp909_ = _vala_code_node_ref0 (_tmp908_);
									_vala_code_node_unref0 (member);
									member = _tmp909_;
								}
							}
						}
						_tmp910_ = m;
						_tmp911_ = vala_symbol_get_access ((ValaSymbol*) _tmp910_);
						_tmp912_ = _tmp911_;
						access = _tmp912_;
						_tmp913_ = m;
						if (!VALA_IS_CREATION_METHOD (_tmp913_)) {
							ValaMethod* _tmp914_;
							ValaMemberBinding _tmp915_;
							ValaMemberBinding _tmp916_;
							_tmp914_ = m;
							_tmp915_ = vala_method_get_binding (_tmp914_);
							_tmp916_ = _tmp915_;
							instance = _tmp916_ == VALA_MEMBER_BINDING_INSTANCE;
						}
						_tmp917_ = m;
						_tmp918_ = vala_method_get_binding (_tmp917_);
						_tmp919_ = _tmp918_;
						klass = _tmp919_ == VALA_MEMBER_BINDING_CLASS;
						{
							ValaList* _param_list = NULL;
							ValaMethod* _tmp920_;
							ValaList* _tmp921_;
							gint _param_size = 0;
							ValaList* _tmp922_;
							gint _tmp923_;
							gint _tmp924_;
							gint _param_index = 0;
							_tmp920_ = m;
							_tmp921_ = vala_callable_get_parameters ((ValaCallable*) _tmp920_);
							_param_list = _tmp921_;
							_tmp922_ = _param_list;
							_tmp923_ = vala_collection_get_size ((ValaCollection*) _tmp922_);
							_tmp924_ = _tmp923_;
							_param_size = _tmp924_;
							_param_index = -1;
							while (TRUE) {
								gint _tmp925_;
								gint _tmp926_;
								gint _tmp927_;
								ValaParameter* param = NULL;
								ValaList* _tmp928_;
								gint _tmp929_;
								gpointer _tmp930_;
								ValaGenericType* generic_type = NULL;
								ValaParameter* _tmp931_;
								ValaDataType* _tmp932_;
								ValaDataType* _tmp933_;
								ValaGenericType* _tmp934_;
								gboolean _tmp935_ = FALSE;
								ValaGenericType* _tmp936_;
								_tmp925_ = _param_index;
								_param_index = _tmp925_ + 1;
								_tmp926_ = _param_index;
								_tmp927_ = _param_size;
								if (!(_tmp926_ < _tmp927_)) {
									break;
								}
								_tmp928_ = _param_list;
								_tmp929_ = _param_index;
								_tmp930_ = vala_list_get (_tmp928_, _tmp929_);
								param = (ValaParameter*) _tmp930_;
								_tmp931_ = param;
								_tmp932_ = vala_variable_get_variable_type ((ValaVariable*) _tmp931_);
								_tmp933_ = _tmp932_;
								_tmp934_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp933_) ? ((ValaGenericType*) _tmp933_) : NULL);
								generic_type = _tmp934_;
								_tmp936_ = generic_type;
								if (_tmp936_ != NULL) {
									ValaGenericType* _tmp937_;
									ValaTypeParameter* _tmp938_;
									ValaTypeParameter* _tmp939_;
									ValaSymbol* _tmp940_;
									ValaSymbol* _tmp941_;
									_tmp937_ = generic_type;
									_tmp938_ = vala_generic_type_get_type_parameter (_tmp937_);
									_tmp939_ = _tmp938_;
									_tmp940_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp939_);
									_tmp941_ = _tmp940_;
									_tmp935_ = VALA_IS_TYPESYMBOL (_tmp941_);
								} else {
									_tmp935_ = FALSE;
								}
								if (_tmp935_) {
									generics = TRUE;
									_vala_code_node_unref0 (generic_type);
									_vala_code_node_unref0 (param);
									break;
								}
								_vala_code_node_unref0 (generic_type);
								_vala_code_node_unref0 (param);
							}
							_vala_iterable_unref0 (_param_list);
						}
						_tmp942_ = m;
						_tmp943_ = vala_callable_get_return_type ((ValaCallable*) _tmp942_);
						_tmp944_ = _tmp943_;
						_tmp945_ = _vala_code_node_ref0 (VALA_IS_GENERIC_TYPE (_tmp944_) ? ((ValaGenericType*) _tmp944_) : NULL);
						generic_type = _tmp945_;
						_tmp947_ = generic_type;
						if (_tmp947_ != NULL) {
							ValaGenericType* _tmp948_;
							ValaTypeParameter* _tmp949_;
							ValaTypeParameter* _tmp950_;
							ValaSymbol* _tmp951_;
							ValaSymbol* _tmp952_;
							_tmp948_ = generic_type;
							_tmp949_ = vala_generic_type_get_type_parameter (_tmp948_);
							_tmp950_ = _tmp949_;
							_tmp951_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp950_);
							_tmp952_ = _tmp951_;
							_tmp946_ = VALA_IS_TYPESYMBOL (_tmp952_);
						} else {
							_tmp946_ = FALSE;
						}
						if (_tmp946_) {
							generics = TRUE;
						}
						_vala_code_node_unref0 (generic_type);
						_vala_code_node_unref0 (m);
					} else {
						ValaSymbol* _tmp953_;
						_tmp953_ = member;
						if (VALA_IS_PROPERTY (_tmp953_)) {
							ValaProperty* prop = NULL;
							ValaSymbol* _tmp954_;
							ValaProperty* _tmp955_;
							ValaProperty* _tmp956_;
							ValaProperty* _tmp957_;
							ValaProperty* _tmp958_;
							ValaProperty* _tmp959_;
							ValaProperty* _tmp979_;
							ValaSymbolAccessibility _tmp980_;
							ValaSymbolAccessibility _tmp981_;
							gboolean _tmp982_;
							gboolean _tmp983_;
							ValaProperty* _tmp1048_;
							ValaMemberBinding _tmp1049_;
							ValaMemberBinding _tmp1050_;
							ValaProperty* _tmp1051_;
							ValaDataType* _tmp1052_;
							ValaDataType* _tmp1053_;
							_tmp954_ = member;
							_tmp955_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp954_, VALA_TYPE_PROPERTY, ValaProperty));
							prop = _tmp955_;
							_tmp956_ = prop;
							if (!vala_code_node_check ((ValaCodeNode*) _tmp956_, context)) {
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								result = FALSE;
								_vala_code_node_unref0 (prop);
								_vala_code_node_unref0 (member);
								_vala_code_node_unref0 (this_parameter);
								_vala_code_node_unref0 (base_symbol);
								return result;
							}
							_tmp957_ = prop;
							_tmp958_ = vala_property_get_base_property (_tmp957_);
							_tmp959_ = _tmp958_;
							if (_tmp959_ != NULL) {
								ValaProperty* _tmp960_;
								ValaProperty* _tmp961_;
								ValaProperty* _tmp962_;
								ValaProperty* _tmp963_;
								ValaProperty* _tmp964_;
								ValaSymbol* _tmp965_;
								ValaSymbol* _tmp966_;
								ValaSymbol* _tmp967_;
								_tmp960_ = prop;
								_tmp961_ = vala_property_get_base_property (_tmp960_);
								_tmp962_ = _tmp961_;
								_tmp963_ = _vala_code_node_ref0 (_tmp962_);
								_vala_code_node_unref0 (prop);
								prop = _tmp963_;
								_tmp964_ = prop;
								vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp964_);
								_tmp965_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
								_tmp966_ = _tmp965_;
								_tmp967_ = _vala_code_node_ref0 (_tmp966_);
								_vala_code_node_unref0 (member);
								member = _tmp967_;
							} else {
								ValaProperty* _tmp968_;
								ValaProperty* _tmp969_;
								ValaProperty* _tmp970_;
								_tmp968_ = prop;
								_tmp969_ = vala_property_get_base_interface_property (_tmp968_);
								_tmp970_ = _tmp969_;
								if (_tmp970_ != NULL) {
									ValaProperty* _tmp971_;
									ValaProperty* _tmp972_;
									ValaProperty* _tmp973_;
									ValaProperty* _tmp974_;
									ValaProperty* _tmp975_;
									ValaSymbol* _tmp976_;
									ValaSymbol* _tmp977_;
									ValaSymbol* _tmp978_;
									_tmp971_ = prop;
									_tmp972_ = vala_property_get_base_interface_property (_tmp971_);
									_tmp973_ = _tmp972_;
									_tmp974_ = _vala_code_node_ref0 (_tmp973_);
									_vala_code_node_unref0 (prop);
									prop = _tmp974_;
									_tmp975_ = prop;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp975_);
									_tmp976_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp977_ = _tmp976_;
									_tmp978_ = _vala_code_node_ref0 (_tmp977_);
									_vala_code_node_unref0 (member);
									member = _tmp978_;
								}
							}
							_tmp979_ = prop;
							_tmp980_ = vala_symbol_get_access ((ValaSymbol*) _tmp979_);
							_tmp981_ = _tmp980_;
							access = _tmp981_;
							_tmp982_ = vala_expression_get_lvalue ((ValaExpression*) self);
							_tmp983_ = _tmp982_;
							if (_tmp983_) {
								ValaProperty* _tmp984_;
								ValaPropertyAccessor* _tmp985_;
								ValaPropertyAccessor* _tmp986_;
								ValaProperty* _tmp994_;
								ValaSymbolAccessibility _tmp995_;
								ValaSymbolAccessibility _tmp996_;
								_tmp984_ = prop;
								_tmp985_ = vala_property_get_set_accessor (_tmp984_);
								_tmp986_ = _tmp985_;
								if (_tmp986_ == NULL) {
									ValaSourceReference* _tmp987_;
									ValaSourceReference* _tmp988_;
									ValaProperty* _tmp989_;
									gchar* _tmp990_;
									gchar* _tmp991_;
									gchar* _tmp992_;
									gchar* _tmp993_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp987_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp988_ = _tmp987_;
									_tmp989_ = prop;
									_tmp990_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp989_);
									_tmp991_ = _tmp990_;
									_tmp992_ = g_strdup_printf ("Property `%s' is read-only", _tmp991_);
									_tmp993_ = _tmp992_;
									vala_report_error (_tmp988_, _tmp993_);
									_g_free0 (_tmp993_);
									_g_free0 (_tmp991_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp994_ = prop;
								_tmp995_ = vala_symbol_get_access ((ValaSymbol*) _tmp994_);
								_tmp996_ = _tmp995_;
								if (_tmp996_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp997_;
									ValaPropertyAccessor* _tmp998_;
									ValaPropertyAccessor* _tmp999_;
									ValaSymbolAccessibility _tmp1000_;
									ValaSymbolAccessibility _tmp1001_;
									_tmp997_ = prop;
									_tmp998_ = vala_property_get_set_accessor (_tmp997_);
									_tmp999_ = _tmp998_;
									_tmp1000_ = vala_symbol_get_access ((ValaSymbol*) _tmp999_);
									_tmp1001_ = _tmp1000_;
									access = _tmp1001_;
								} else {
									gboolean _tmp1002_ = FALSE;
									ValaProperty* _tmp1003_;
									ValaSymbolAccessibility _tmp1004_;
									ValaSymbolAccessibility _tmp1005_;
									_tmp1003_ = prop;
									_tmp1004_ = vala_symbol_get_access ((ValaSymbol*) _tmp1003_);
									_tmp1005_ = _tmp1004_;
									if (_tmp1005_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1006_;
										ValaPropertyAccessor* _tmp1007_;
										ValaPropertyAccessor* _tmp1008_;
										ValaSymbolAccessibility _tmp1009_;
										ValaSymbolAccessibility _tmp1010_;
										_tmp1006_ = prop;
										_tmp1007_ = vala_property_get_set_accessor (_tmp1006_);
										_tmp1008_ = _tmp1007_;
										_tmp1009_ = vala_symbol_get_access ((ValaSymbol*) _tmp1008_);
										_tmp1010_ = _tmp1009_;
										_tmp1002_ = _tmp1010_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1002_ = FALSE;
									}
									if (_tmp1002_) {
										ValaProperty* _tmp1011_;
										ValaPropertyAccessor* _tmp1012_;
										ValaPropertyAccessor* _tmp1013_;
										ValaSymbolAccessibility _tmp1014_;
										ValaSymbolAccessibility _tmp1015_;
										_tmp1011_ = prop;
										_tmp1012_ = vala_property_get_set_accessor (_tmp1011_);
										_tmp1013_ = _tmp1012_;
										_tmp1014_ = vala_symbol_get_access ((ValaSymbol*) _tmp1013_);
										_tmp1015_ = _tmp1014_;
										access = _tmp1015_;
									}
								}
							} else {
								ValaProperty* _tmp1016_;
								ValaPropertyAccessor* _tmp1017_;
								ValaPropertyAccessor* _tmp1018_;
								ValaProperty* _tmp1026_;
								ValaSymbolAccessibility _tmp1027_;
								ValaSymbolAccessibility _tmp1028_;
								_tmp1016_ = prop;
								_tmp1017_ = vala_property_get_get_accessor (_tmp1016_);
								_tmp1018_ = _tmp1017_;
								if (_tmp1018_ == NULL) {
									ValaSourceReference* _tmp1019_;
									ValaSourceReference* _tmp1020_;
									ValaProperty* _tmp1021_;
									gchar* _tmp1022_;
									gchar* _tmp1023_;
									gchar* _tmp1024_;
									gchar* _tmp1025_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp1019_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp1020_ = _tmp1019_;
									_tmp1021_ = prop;
									_tmp1022_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp1021_);
									_tmp1023_ = _tmp1022_;
									_tmp1024_ = g_strdup_printf ("Property `%s' is write-only", _tmp1023_);
									_tmp1025_ = _tmp1024_;
									vala_report_error (_tmp1020_, _tmp1025_);
									_g_free0 (_tmp1025_);
									_g_free0 (_tmp1023_);
									result = FALSE;
									_vala_code_node_unref0 (prop);
									_vala_code_node_unref0 (member);
									_vala_code_node_unref0 (this_parameter);
									_vala_code_node_unref0 (base_symbol);
									return result;
								}
								_tmp1026_ = prop;
								_tmp1027_ = vala_symbol_get_access ((ValaSymbol*) _tmp1026_);
								_tmp1028_ = _tmp1027_;
								if (_tmp1028_ == VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
									ValaProperty* _tmp1029_;
									ValaPropertyAccessor* _tmp1030_;
									ValaPropertyAccessor* _tmp1031_;
									ValaSymbolAccessibility _tmp1032_;
									ValaSymbolAccessibility _tmp1033_;
									_tmp1029_ = prop;
									_tmp1030_ = vala_property_get_get_accessor (_tmp1029_);
									_tmp1031_ = _tmp1030_;
									_tmp1032_ = vala_symbol_get_access ((ValaSymbol*) _tmp1031_);
									_tmp1033_ = _tmp1032_;
									access = _tmp1033_;
								} else {
									gboolean _tmp1034_ = FALSE;
									ValaProperty* _tmp1035_;
									ValaSymbolAccessibility _tmp1036_;
									ValaSymbolAccessibility _tmp1037_;
									_tmp1035_ = prop;
									_tmp1036_ = vala_symbol_get_access ((ValaSymbol*) _tmp1035_);
									_tmp1037_ = _tmp1036_;
									if (_tmp1037_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
										ValaProperty* _tmp1038_;
										ValaPropertyAccessor* _tmp1039_;
										ValaPropertyAccessor* _tmp1040_;
										ValaSymbolAccessibility _tmp1041_;
										ValaSymbolAccessibility _tmp1042_;
										_tmp1038_ = prop;
										_tmp1039_ = vala_property_get_get_accessor (_tmp1038_);
										_tmp1040_ = _tmp1039_;
										_tmp1041_ = vala_symbol_get_access ((ValaSymbol*) _tmp1040_);
										_tmp1042_ = _tmp1041_;
										_tmp1034_ = _tmp1042_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC;
									} else {
										_tmp1034_ = FALSE;
									}
									if (_tmp1034_) {
										ValaProperty* _tmp1043_;
										ValaPropertyAccessor* _tmp1044_;
										ValaPropertyAccessor* _tmp1045_;
										ValaSymbolAccessibility _tmp1046_;
										ValaSymbolAccessibility _tmp1047_;
										_tmp1043_ = prop;
										_tmp1044_ = vala_property_get_get_accessor (_tmp1043_);
										_tmp1045_ = _tmp1044_;
										_tmp1046_ = vala_symbol_get_access ((ValaSymbol*) _tmp1045_);
										_tmp1047_ = _tmp1046_;
										access = _tmp1047_;
									}
								}
							}
							_tmp1048_ = prop;
							_tmp1049_ = vala_property_get_binding (_tmp1048_);
							_tmp1050_ = _tmp1049_;
							instance = _tmp1050_ == VALA_MEMBER_BINDING_INSTANCE;
							_tmp1051_ = prop;
							_tmp1052_ = vala_property_get_property_type (_tmp1051_);
							_tmp1053_ = _tmp1052_;
							if (VALA_IS_GENERIC_TYPE (_tmp1053_)) {
								generics = TRUE;
							}
							_vala_code_node_unref0 (prop);
						} else {
							ValaSymbol* _tmp1054_;
							_tmp1054_ = member;
							if (VALA_IS_SIGNAL (_tmp1054_)) {
								ValaSymbol* _tmp1055_;
								ValaSymbolAccessibility _tmp1056_;
								ValaSymbolAccessibility _tmp1057_;
								instance = TRUE;
								_tmp1055_ = member;
								_tmp1056_ = vala_symbol_get_access (_tmp1055_);
								_tmp1057_ = _tmp1056_;
								access = _tmp1057_;
							} else {
								gboolean _tmp1058_ = FALSE;
								gboolean _tmp1059_;
								_tmp1059_ = self->priv->_creation_member;
								if (!_tmp1059_) {
									ValaSymbol* _tmp1060_;
									_tmp1060_ = member;
									_tmp1058_ = VALA_IS_ERROR_CODE (_tmp1060_);
								} else {
									_tmp1058_ = FALSE;
								}
								if (_tmp1058_) {
									ValaSymbol* _tmp1061_;
									ValaConstant* _tmp1062_;
									ValaConstant* _tmp1063_;
									ValaSymbol* _tmp1064_;
									ValaSymbol* _tmp1065_;
									ValaSymbol* _tmp1066_;
									_tmp1061_ = member;
									_tmp1062_ = vala_error_code_get_code (G_TYPE_CHECK_INSTANCE_CAST (_tmp1061_, VALA_TYPE_ERROR_CODE, ValaErrorCode));
									_tmp1063_ = _tmp1062_;
									vala_expression_set_symbol_reference ((ValaExpression*) self, (ValaSymbol*) _tmp1063_);
									_tmp1064_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
									_tmp1065_ = _tmp1064_;
									_tmp1066_ = _vala_code_node_ref0 (_tmp1065_);
									_vala_code_node_unref0 (member);
									member = _tmp1066_;
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp1067_ = member;
	vala_symbol_set_used (_tmp1067_, TRUE);
	_tmp1068_ = member;
	_tmp1069_ = vala_symbol_get_version (_tmp1068_);
	_tmp1070_ = _tmp1069_;
	_tmp1071_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp1072_ = _tmp1071_;
	vala_version_attribute_check (_tmp1070_, _tmp1072_);
	_tmp1074_ = access;
	if (_tmp1074_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
		ValaSymbol* _tmp1075_;
		ValaSymbol* _tmp1076_;
		ValaSymbol* _tmp1077_;
		_tmp1075_ = member;
		_tmp1076_ = vala_symbol_get_parent_symbol (_tmp1075_);
		_tmp1077_ = _tmp1076_;
		_tmp1073_ = VALA_IS_TYPESYMBOL (_tmp1077_);
	} else {
		_tmp1073_ = FALSE;
	}
	if (_tmp1073_) {
		ValaTypeSymbol* target_type = NULL;
		ValaSymbol* _tmp1078_;
		ValaSymbol* _tmp1079_;
		ValaSymbol* _tmp1080_;
		ValaTypeSymbol* _tmp1081_;
		gboolean in_subtype = FALSE;
		gboolean _tmp1101_;
		_tmp1078_ = member;
		_tmp1079_ = vala_symbol_get_parent_symbol (_tmp1078_);
		_tmp1080_ = _tmp1079_;
		_tmp1081_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1080_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol));
		target_type = _tmp1081_;
		in_subtype = FALSE;
		{
			ValaSymbol* this_symbol = NULL;
			ValaSemanticAnalyzer* _tmp1082_;
			ValaSemanticAnalyzer* _tmp1083_;
			ValaSymbol* _tmp1084_;
			ValaSymbol* _tmp1085_;
			ValaSymbol* _tmp1086_;
			_tmp1082_ = vala_code_context_get_analyzer (context);
			_tmp1083_ = _tmp1082_;
			_tmp1084_ = vala_semantic_analyzer_get_current_symbol (_tmp1083_);
			_tmp1085_ = _tmp1084_;
			_tmp1086_ = _vala_code_node_ref0 (_tmp1085_);
			this_symbol = _tmp1086_;
			{
				gboolean _tmp1087_ = FALSE;
				_tmp1087_ = TRUE;
				while (TRUE) {
					ValaSymbol* _tmp1092_;
					ValaSymbol* _tmp1093_;
					ValaTypeSymbol* _tmp1094_;
					ValaClass* cl = NULL;
					ValaSymbol* _tmp1095_;
					ValaClass* _tmp1096_;
					gboolean _tmp1097_ = FALSE;
					ValaClass* _tmp1098_;
					if (!_tmp1087_) {
						ValaSymbol* _tmp1088_;
						ValaSymbol* _tmp1089_;
						ValaSymbol* _tmp1090_;
						ValaSymbol* _tmp1091_;
						_tmp1088_ = this_symbol;
						_tmp1089_ = vala_symbol_get_parent_symbol (_tmp1088_);
						_tmp1090_ = _tmp1089_;
						_tmp1091_ = _vala_code_node_ref0 (_tmp1090_);
						_vala_code_node_unref0 (this_symbol);
						this_symbol = _tmp1091_;
					}
					_tmp1087_ = FALSE;
					_tmp1092_ = this_symbol;
					if (!(_tmp1092_ != NULL)) {
						break;
					}
					_tmp1093_ = this_symbol;
					_tmp1094_ = target_type;
					if (_tmp1093_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1094_, VALA_TYPE_SYMBOL, ValaSymbol)) {
						in_subtype = TRUE;
						break;
					}
					_tmp1095_ = this_symbol;
					_tmp1096_ = _vala_code_node_ref0 (VALA_IS_CLASS (_tmp1095_) ? ((ValaClass*) _tmp1095_) : NULL);
					cl = _tmp1096_;
					_tmp1098_ = cl;
					if (_tmp1098_ != NULL) {
						ValaClass* _tmp1099_;
						ValaTypeSymbol* _tmp1100_;
						_tmp1099_ = cl;
						_tmp1100_ = target_type;
						_tmp1097_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp1099_, _tmp1100_);
					} else {
						_tmp1097_ = FALSE;
					}
					if (_tmp1097_) {
						in_subtype = TRUE;
						_vala_code_node_unref0 (cl);
						break;
					}
					_vala_code_node_unref0 (cl);
				}
			}
			_vala_code_node_unref0 (this_symbol);
		}
		_tmp1101_ = in_subtype;
		if (!_tmp1101_) {
			ValaSourceReference* _tmp1102_;
			ValaSourceReference* _tmp1103_;
			ValaSymbol* _tmp1104_;
			gchar* _tmp1105_;
			gchar* _tmp1106_;
			gchar* _tmp1107_;
			gchar* _tmp1108_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1102_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1103_ = _tmp1102_;
			_tmp1104_ = member;
			_tmp1105_ = vala_symbol_get_full_name (_tmp1104_);
			_tmp1106_ = _tmp1105_;
			_tmp1107_ = g_strdup_printf ("Access to protected member `%s' denied", _tmp1106_);
			_tmp1108_ = _tmp1107_;
			vala_report_error (_tmp1103_, _tmp1108_);
			_g_free0 (_tmp1108_);
			_g_free0 (_tmp1106_);
			result = FALSE;
			_vala_code_node_unref0 (target_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (target_type);
	} else {
		ValaSymbolAccessibility _tmp1109_;
		_tmp1109_ = access;
		if (_tmp1109_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaSymbol* target_type = NULL;
			ValaSymbol* _tmp1110_;
			ValaSymbol* _tmp1111_;
			ValaSymbol* _tmp1112_;
			ValaSymbol* _tmp1113_;
			gboolean in_target_type = FALSE;
			gboolean _tmp1127_;
			_tmp1110_ = member;
			_tmp1111_ = vala_symbol_get_parent_symbol (_tmp1110_);
			_tmp1112_ = _tmp1111_;
			_tmp1113_ = _vala_code_node_ref0 (_tmp1112_);
			target_type = _tmp1113_;
			in_target_type = FALSE;
			{
				ValaSymbol* this_symbol = NULL;
				ValaSemanticAnalyzer* _tmp1114_;
				ValaSemanticAnalyzer* _tmp1115_;
				ValaSymbol* _tmp1116_;
				ValaSymbol* _tmp1117_;
				ValaSymbol* _tmp1118_;
				_tmp1114_ = vala_code_context_get_analyzer (context);
				_tmp1115_ = _tmp1114_;
				_tmp1116_ = vala_semantic_analyzer_get_current_symbol (_tmp1115_);
				_tmp1117_ = _tmp1116_;
				_tmp1118_ = _vala_code_node_ref0 (_tmp1117_);
				this_symbol = _tmp1118_;
				{
					gboolean _tmp1119_ = FALSE;
					_tmp1119_ = TRUE;
					while (TRUE) {
						ValaSymbol* _tmp1124_;
						ValaSymbol* _tmp1125_;
						ValaSymbol* _tmp1126_;
						if (!_tmp1119_) {
							ValaSymbol* _tmp1120_;
							ValaSymbol* _tmp1121_;
							ValaSymbol* _tmp1122_;
							ValaSymbol* _tmp1123_;
							_tmp1120_ = this_symbol;
							_tmp1121_ = vala_symbol_get_parent_symbol (_tmp1120_);
							_tmp1122_ = _tmp1121_;
							_tmp1123_ = _vala_code_node_ref0 (_tmp1122_);
							_vala_code_node_unref0 (this_symbol);
							this_symbol = _tmp1123_;
						}
						_tmp1119_ = FALSE;
						_tmp1124_ = this_symbol;
						if (!(_tmp1124_ != NULL)) {
							break;
						}
						_tmp1125_ = target_type;
						_tmp1126_ = this_symbol;
						if (_tmp1125_ == _tmp1126_) {
							in_target_type = TRUE;
							break;
						}
					}
				}
				_vala_code_node_unref0 (this_symbol);
			}
			_tmp1127_ = in_target_type;
			if (!_tmp1127_) {
				ValaSourceReference* _tmp1128_;
				ValaSourceReference* _tmp1129_;
				ValaSymbol* _tmp1130_;
				gchar* _tmp1131_;
				gchar* _tmp1132_;
				gchar* _tmp1133_;
				gchar* _tmp1134_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp1128_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1129_ = _tmp1128_;
				_tmp1130_ = member;
				_tmp1131_ = vala_symbol_get_full_name (_tmp1130_);
				_tmp1132_ = _tmp1131_;
				_tmp1133_ = g_strdup_printf ("Access to private member `%s' denied", _tmp1132_);
				_tmp1134_ = _tmp1133_;
				vala_report_error (_tmp1129_, _tmp1134_);
				_g_free0 (_tmp1134_);
				_g_free0 (_tmp1132_);
				result = FALSE;
				_vala_code_node_unref0 (target_type);
				_vala_code_node_unref0 (member);
				_vala_code_node_unref0 (this_parameter);
				_vala_code_node_unref0 (base_symbol);
				return result;
			}
			_vala_code_node_unref0 (target_type);
		}
	}
	_tmp1136_ = generics;
	if (_tmp1136_) {
		ValaExpression* _tmp1137_;
		ValaExpression* _tmp1138_;
		_tmp1137_ = vala_member_access_get_inner (self);
		_tmp1138_ = _tmp1137_;
		_tmp1135_ = _tmp1138_ != NULL;
	} else {
		_tmp1135_ = FALSE;
	}
	if (_tmp1135_) {
		ValaDataType* instance_type = NULL;
		ValaExpression* _tmp1139_;
		ValaExpression* _tmp1140_;
		ValaDataType* _tmp1141_;
		ValaDataType* _tmp1142_;
		ValaDataType* _tmp1143_;
		ValaPointerType* pointer_type = NULL;
		ValaExpression* _tmp1144_;
		ValaExpression* _tmp1145_;
		ValaDataType* _tmp1146_;
		ValaDataType* _tmp1147_;
		ValaPointerType* _tmp1148_;
		ValaPointerType* _tmp1149_;
		ValaObjectType* object_type = NULL;
		ValaDataType* _tmp1154_;
		ValaObjectType* _tmp1155_;
		gboolean _tmp1156_ = FALSE;
		gboolean _tmp1157_ = FALSE;
		ValaObjectType* _tmp1158_;
		_tmp1139_ = vala_member_access_get_inner (self);
		_tmp1140_ = _tmp1139_;
		_tmp1141_ = vala_expression_get_value_type (_tmp1140_);
		_tmp1142_ = _tmp1141_;
		_tmp1143_ = _vala_code_node_ref0 (_tmp1142_);
		instance_type = _tmp1143_;
		_tmp1144_ = vala_member_access_get_inner (self);
		_tmp1145_ = _tmp1144_;
		_tmp1146_ = vala_expression_get_value_type (_tmp1145_);
		_tmp1147_ = _tmp1146_;
		_tmp1148_ = _vala_code_node_ref0 (VALA_IS_POINTER_TYPE (_tmp1147_) ? ((ValaPointerType*) _tmp1147_) : NULL);
		pointer_type = _tmp1148_;
		_tmp1149_ = pointer_type;
		if (_tmp1149_ != NULL) {
			ValaPointerType* _tmp1150_;
			ValaDataType* _tmp1151_;
			ValaDataType* _tmp1152_;
			ValaDataType* _tmp1153_;
			_tmp1150_ = pointer_type;
			_tmp1151_ = vala_pointer_type_get_base_type (_tmp1150_);
			_tmp1152_ = _tmp1151_;
			_tmp1153_ = _vala_code_node_ref0 (_tmp1152_);
			_vala_code_node_unref0 (instance_type);
			instance_type = _tmp1153_;
		}
		_tmp1154_ = instance_type;
		_tmp1155_ = _vala_code_node_ref0 (VALA_IS_OBJECT_TYPE (_tmp1154_) ? ((ValaObjectType*) _tmp1154_) : NULL);
		object_type = _tmp1155_;
		_tmp1158_ = object_type;
		if (_tmp1158_ != NULL) {
			ValaObjectType* _tmp1159_;
			ValaObjectTypeSymbol* _tmp1160_;
			ValaObjectTypeSymbol* _tmp1161_;
			ValaList* _tmp1162_;
			ValaList* _tmp1163_;
			gint _tmp1164_;
			gint _tmp1165_;
			_tmp1159_ = object_type;
			_tmp1160_ = vala_object_type_get_type_symbol (_tmp1159_);
			_tmp1161_ = _tmp1160_;
			_tmp1162_ = vala_object_type_symbol_get_type_parameters (_tmp1161_);
			_tmp1163_ = _tmp1162_;
			_tmp1164_ = vala_collection_get_size ((ValaCollection*) _tmp1163_);
			_tmp1165_ = _tmp1164_;
			_tmp1157_ = _tmp1165_ > 0;
			_vala_iterable_unref0 (_tmp1163_);
		} else {
			_tmp1157_ = FALSE;
		}
		if (_tmp1157_) {
			ValaDataType* _tmp1166_;
			ValaList* _tmp1167_;
			ValaList* _tmp1168_;
			gint _tmp1169_;
			gint _tmp1170_;
			_tmp1166_ = instance_type;
			_tmp1167_ = vala_data_type_get_type_arguments (_tmp1166_);
			_tmp1168_ = _tmp1167_;
			_tmp1169_ = vala_collection_get_size ((ValaCollection*) _tmp1168_);
			_tmp1170_ = _tmp1169_;
			_tmp1156_ = _tmp1170_ == 0;
			_vala_iterable_unref0 (_tmp1168_);
		} else {
			_tmp1156_ = FALSE;
		}
		if (_tmp1156_) {
			ValaExpression* _tmp1171_;
			ValaExpression* _tmp1172_;
			ValaSourceReference* _tmp1173_;
			ValaSourceReference* _tmp1174_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp1171_ = vala_member_access_get_inner (self);
			_tmp1172_ = _tmp1171_;
			_tmp1173_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1172_);
			_tmp1174_ = _tmp1173_;
			vala_report_error (_tmp1174_, "missing generic type arguments");
			result = FALSE;
			_vala_code_node_unref0 (object_type);
			_vala_code_node_unref0 (pointer_type);
			_vala_code_node_unref0 (instance_type);
			_vala_code_node_unref0 (member);
			_vala_code_node_unref0 (this_parameter);
			_vala_code_node_unref0 (base_symbol);
			return result;
		}
		_vala_code_node_unref0 (object_type);
		_vala_code_node_unref0 (pointer_type);
		_vala_code_node_unref0 (instance_type);
	}
	_tmp1177_ = instance;
	if (_tmp1177_) {
		gboolean _tmp1178_;
		_tmp1178_ = may_access_instance_members;
		_tmp1176_ = !_tmp1178_;
	} else {
		_tmp1176_ = FALSE;
	}
	if (_tmp1176_) {
		_tmp1175_ = TRUE;
	} else {
		gboolean _tmp1179_ = FALSE;
		gboolean _tmp1180_;
		_tmp1180_ = klass;
		if (_tmp1180_) {
			gboolean _tmp1181_;
			_tmp1181_ = may_access_klass_members;
			_tmp1179_ = !_tmp1181_;
		} else {
			_tmp1179_ = FALSE;
		}
		_tmp1175_ = _tmp1179_;
	}
	if (_tmp1175_) {
		ValaSymbol* _tmp1182_;
		ValaSymbol* _tmp1183_;
		ValaDataType* _tmp1206_;
		ValaDataType* _tmp1207_;
		vala_member_access_set_prototype_access (self, TRUE);
		_tmp1182_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1183_ = _tmp1182_;
		if (VALA_IS_METHOD (_tmp1183_)) {
			ValaSemanticAnalyzer* _tmp1184_;
			ValaSemanticAnalyzer* _tmp1185_;
			ValaSymbol* _tmp1186_;
			ValaSymbol* _tmp1187_;
			gboolean _tmp1188_;
			gboolean _tmp1189_;
			ValaDataType* _tmp1190_;
			ValaDataType* _tmp1191_;
			_tmp1184_ = vala_code_context_get_analyzer (context);
			_tmp1185_ = _tmp1184_;
			_tmp1186_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1187_ = _tmp1186_;
			_tmp1188_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp1189_ = _tmp1188_;
			_tmp1190_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1185_, _tmp1187_, _tmp1189_);
			_tmp1191_ = _tmp1190_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1191_);
			_vala_code_node_unref0 (_tmp1191_);
		} else {
			ValaSymbol* _tmp1192_;
			ValaSymbol* _tmp1193_;
			_tmp1192_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1193_ = _tmp1192_;
			if (VALA_IS_FIELD (_tmp1193_)) {
				ValaSymbol* _tmp1194_;
				ValaSymbol* _tmp1195_;
				ValaFieldPrototype* _tmp1196_;
				ValaFieldPrototype* _tmp1197_;
				_tmp1194_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1195_ = _tmp1194_;
				_tmp1196_ = vala_field_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1195_, VALA_TYPE_FIELD, ValaField));
				_tmp1197_ = _tmp1196_;
				vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1197_);
				_vala_code_node_unref0 (_tmp1197_);
			} else {
				ValaSymbol* _tmp1198_;
				ValaSymbol* _tmp1199_;
				_tmp1198_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1199_ = _tmp1198_;
				if (VALA_IS_PROPERTY (_tmp1199_)) {
					ValaSymbol* _tmp1200_;
					ValaSymbol* _tmp1201_;
					ValaPropertyPrototype* _tmp1202_;
					ValaPropertyPrototype* _tmp1203_;
					_tmp1200_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1201_ = _tmp1200_;
					_tmp1202_ = vala_property_prototype_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1201_, VALA_TYPE_PROPERTY, ValaProperty));
					_tmp1203_ = _tmp1202_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1203_);
					_vala_code_node_unref0 (_tmp1203_);
				} else {
					ValaInvalidType* _tmp1204_;
					ValaInvalidType* _tmp1205_;
					_tmp1204_ = vala_invalid_type_new ();
					_tmp1205_ = _tmp1204_;
					vala_expression_set_value_type ((ValaExpression*) self, (ValaDataType*) _tmp1205_);
					_vala_code_node_unref0 (_tmp1205_);
				}
			}
		}
		_tmp1206_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp1207_ = _tmp1206_;
		if (_tmp1207_ != NULL) {
			ValaDataType* _tmp1208_;
			ValaDataType* _tmp1209_;
			ValaDataType* _tmp1210_;
			ValaDataType* _tmp1211_;
			gboolean _tmp1212_;
			gboolean _tmp1213_;
			_tmp1208_ = vala_expression_get_value_type ((ValaExpression*) self);
			_tmp1209_ = _tmp1208_;
			_tmp1210_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1211_ = _tmp1210_;
			_tmp1212_ = vala_data_type_get_value_owned (_tmp1211_);
			_tmp1213_ = _tmp1212_;
			vala_data_type_set_value_owned (_tmp1209_, _tmp1213_);
		}
	} else {
		gboolean _tmp1214_ = FALSE;
		gboolean _tmp1215_;
		gboolean _tmp1236_ = FALSE;
		gboolean _tmp1237_ = FALSE;
		gboolean _tmp1238_ = FALSE;
		gboolean _tmp1239_ = FALSE;
		gboolean _tmp1240_;
		gboolean _tmp1259_ = FALSE;
		gboolean _tmp1260_ = FALSE;
		gboolean _tmp1261_ = FALSE;
		gboolean _tmp1262_ = FALSE;
		gboolean _tmp1263_ = FALSE;
		gboolean _tmp1264_;
		gboolean _tmp1265_;
		ValaMethod* m = NULL;
		ValaSymbol* _tmp1293_;
		ValaSymbol* _tmp1294_;
		ValaMethod* _tmp1295_;
		ValaMemberAccess* inner_ma = NULL;
		ValaExpression* _tmp1296_;
		ValaExpression* _tmp1297_;
		ValaMemberAccess* _tmp1298_;
		gboolean _tmp1299_ = FALSE;
		gboolean _tmp1300_ = FALSE;
		gboolean _tmp1301_ = FALSE;
		gboolean _tmp1302_ = FALSE;
		gboolean _tmp1303_ = FALSE;
		ValaMethod* _tmp1304_;
		ValaSemanticAnalyzer* _tmp1345_;
		ValaSemanticAnalyzer* _tmp1346_;
		ValaSymbol* _tmp1347_;
		ValaSymbol* _tmp1348_;
		gboolean _tmp1349_;
		gboolean _tmp1350_;
		ValaDataType* _tmp1351_;
		ValaDataType* _tmp1352_;
		gboolean _tmp1353_ = FALSE;
		ValaExpression* _tmp1354_;
		ValaExpression* _tmp1355_;
		ValaSymbol* _tmp1368_;
		ValaSymbol* _tmp1369_;
		_tmp1215_ = instance;
		if (_tmp1215_) {
			ValaExpression* _tmp1216_;
			ValaExpression* _tmp1217_;
			_tmp1216_ = vala_member_access_get_inner (self);
			_tmp1217_ = _tmp1216_;
			_tmp1214_ = _tmp1217_ == NULL;
		} else {
			_tmp1214_ = FALSE;
		}
		if (_tmp1214_) {
			ValaSourceReference* _tmp1218_;
			ValaSourceReference* _tmp1219_;
			ValaMemberAccess* _tmp1220_;
			ValaMemberAccess* _tmp1221_;
			ValaExpression* _tmp1222_;
			ValaExpression* _tmp1223_;
			ValaParameter* _tmp1224_;
			ValaDataType* _tmp1225_;
			ValaDataType* _tmp1226_;
			ValaDataType* _tmp1227_;
			ValaDataType* _tmp1228_;
			ValaExpression* _tmp1229_;
			ValaExpression* _tmp1230_;
			ValaDataType* _tmp1231_;
			ValaDataType* _tmp1232_;
			ValaExpression* _tmp1233_;
			ValaExpression* _tmp1234_;
			ValaParameter* _tmp1235_;
			_tmp1218_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1219_ = _tmp1218_;
			_tmp1220_ = vala_member_access_new (NULL, "this", _tmp1219_);
			_tmp1221_ = _tmp1220_;
			vala_member_access_set_inner (self, (ValaExpression*) _tmp1221_);
			_vala_code_node_unref0 (_tmp1221_);
			_tmp1222_ = vala_member_access_get_inner (self);
			_tmp1223_ = _tmp1222_;
			_tmp1224_ = this_parameter;
			_tmp1225_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1224_);
			_tmp1226_ = _tmp1225_;
			_tmp1227_ = vala_data_type_copy (_tmp1226_);
			_tmp1228_ = _tmp1227_;
			vala_expression_set_value_type (_tmp1223_, _tmp1228_);
			_vala_code_node_unref0 (_tmp1228_);
			_tmp1229_ = vala_member_access_get_inner (self);
			_tmp1230_ = _tmp1229_;
			_tmp1231_ = vala_expression_get_value_type (_tmp1230_);
			_tmp1232_ = _tmp1231_;
			vala_data_type_set_value_owned (_tmp1232_, FALSE);
			_tmp1233_ = vala_member_access_get_inner (self);
			_tmp1234_ = _tmp1233_;
			_tmp1235_ = this_parameter;
			vala_expression_set_symbol_reference (_tmp1234_, (ValaSymbol*) _tmp1235_);
		} else {
			vala_member_access_check_lvalue_access (self);
		}
		_tmp1240_ = instance;
		if (!_tmp1240_) {
			gboolean _tmp1241_;
			_tmp1241_ = klass;
			_tmp1239_ = !_tmp1241_;
		} else {
			_tmp1239_ = FALSE;
		}
		if (_tmp1239_) {
			ValaSymbol* _tmp1242_;
			ValaSymbol* _tmp1243_;
			_tmp1242_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1243_ = _tmp1242_;
			_tmp1238_ = !VALA_IS_CREATION_METHOD (_tmp1243_);
		} else {
			_tmp1238_ = FALSE;
		}
		if (_tmp1238_) {
			gboolean _tmp1244_;
			_tmp1244_ = may_access_instance_members;
			_tmp1237_ = _tmp1244_;
		} else {
			_tmp1237_ = FALSE;
		}
		if (_tmp1237_) {
			ValaExpression* _tmp1245_;
			ValaExpression* _tmp1246_;
			_tmp1245_ = vala_member_access_get_inner (self);
			_tmp1246_ = _tmp1245_;
			_tmp1236_ = _tmp1246_ != NULL;
		} else {
			_tmp1236_ = FALSE;
		}
		if (_tmp1236_) {
			ValaExpression* _tmp1247_;
			ValaExpression* _tmp1248_;
			ValaSymbol* _tmp1249_;
			ValaSymbol* _tmp1250_;
			_tmp1247_ = vala_member_access_get_inner (self);
			_tmp1248_ = _tmp1247_;
			_tmp1249_ = vala_expression_get_symbol_reference (_tmp1248_);
			_tmp1250_ = _tmp1249_;
			if (VALA_IS_METHOD (_tmp1250_)) {
			} else {
				ValaSourceReference* _tmp1251_;
				ValaSourceReference* _tmp1252_;
				ValaSymbol* _tmp1253_;
				ValaSymbol* _tmp1254_;
				gchar* _tmp1255_;
				gchar* _tmp1256_;
				gchar* _tmp1257_;
				gchar* _tmp1258_;
				_tmp1251_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp1252_ = _tmp1251_;
				_tmp1253_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1254_ = _tmp1253_;
				_tmp1255_ = vala_symbol_get_full_name (_tmp1254_);
				_tmp1256_ = _tmp1255_;
				_tmp1257_ = g_strdup_printf ("Access to static member `%s' with an instance reference", _tmp1256_);
				_tmp1258_ = _tmp1257_;
				vala_report_warning (_tmp1252_, _tmp1258_);
				_g_free0 (_tmp1258_);
				_g_free0 (_tmp1256_);
			}
		}
		_tmp1264_ = vala_code_context_get_experimental_non_null (context);
		_tmp1265_ = _tmp1264_;
		if (_tmp1265_) {
			gboolean _tmp1266_;
			_tmp1266_ = instance;
			_tmp1263_ = _tmp1266_;
		} else {
			_tmp1263_ = FALSE;
		}
		if (_tmp1263_) {
			ValaExpression* _tmp1267_;
			ValaExpression* _tmp1268_;
			ValaDataType* _tmp1269_;
			ValaDataType* _tmp1270_;
			gboolean _tmp1271_;
			gboolean _tmp1272_;
			_tmp1267_ = vala_member_access_get_inner (self);
			_tmp1268_ = _tmp1267_;
			_tmp1269_ = vala_expression_get_value_type (_tmp1268_);
			_tmp1270_ = _tmp1269_;
			_tmp1271_ = vala_data_type_get_nullable (_tmp1270_);
			_tmp1272_ = _tmp1271_;
			_tmp1262_ = _tmp1272_;
		} else {
			_tmp1262_ = FALSE;
		}
		if (_tmp1262_) {
			ValaExpression* _tmp1273_;
			ValaExpression* _tmp1274_;
			ValaDataType* _tmp1275_;
			ValaDataType* _tmp1276_;
			_tmp1273_ = vala_member_access_get_inner (self);
			_tmp1274_ = _tmp1273_;
			_tmp1275_ = vala_expression_get_value_type (_tmp1274_);
			_tmp1276_ = _tmp1275_;
			_tmp1261_ = !VALA_IS_POINTER_TYPE (_tmp1276_);
		} else {
			_tmp1261_ = FALSE;
		}
		if (_tmp1261_) {
			ValaExpression* _tmp1277_;
			ValaExpression* _tmp1278_;
			ValaDataType* _tmp1279_;
			ValaDataType* _tmp1280_;
			_tmp1277_ = vala_member_access_get_inner (self);
			_tmp1278_ = _tmp1277_;
			_tmp1279_ = vala_expression_get_value_type (_tmp1278_);
			_tmp1280_ = _tmp1279_;
			_tmp1260_ = !VALA_IS_GENERIC_TYPE (_tmp1280_);
		} else {
			_tmp1260_ = FALSE;
		}
		if (_tmp1260_) {
			ValaExpression* _tmp1281_;
			ValaExpression* _tmp1282_;
			ValaDataType* _tmp1283_;
			ValaDataType* _tmp1284_;
			_tmp1281_ = vala_member_access_get_inner (self);
			_tmp1282_ = _tmp1281_;
			_tmp1283_ = vala_expression_get_value_type (_tmp1282_);
			_tmp1284_ = _tmp1283_;
			_tmp1259_ = !VALA_IS_ARRAY_TYPE (_tmp1284_);
		} else {
			_tmp1259_ = FALSE;
		}
		if (_tmp1259_) {
			ValaSourceReference* _tmp1285_;
			ValaSourceReference* _tmp1286_;
			ValaSymbol* _tmp1287_;
			ValaSymbol* _tmp1288_;
			gchar* _tmp1289_;
			gchar* _tmp1290_;
			gchar* _tmp1291_;
			gchar* _tmp1292_;
			_tmp1285_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp1286_ = _tmp1285_;
			_tmp1287_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1288_ = _tmp1287_;
			_tmp1289_ = vala_symbol_get_full_name (_tmp1288_);
			_tmp1290_ = _tmp1289_;
			_tmp1291_ = g_strdup_printf ("Access to instance member `%s' from nullable reference denied", _tmp1290_);
			_tmp1292_ = _tmp1291_;
			vala_report_error (_tmp1286_, _tmp1292_);
			_g_free0 (_tmp1292_);
			_g_free0 (_tmp1290_);
		}
		_tmp1293_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1294_ = _tmp1293_;
		_tmp1295_ = _vala_code_node_ref0 (VALA_IS_METHOD (_tmp1294_) ? ((ValaMethod*) _tmp1294_) : NULL);
		m = _tmp1295_;
		_tmp1296_ = vala_member_access_get_inner (self);
		_tmp1297_ = _tmp1296_;
		_tmp1298_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp1297_) ? ((ValaMemberAccess*) _tmp1297_) : NULL);
		inner_ma = _tmp1298_;
		_tmp1304_ = m;
		if (_tmp1304_ != NULL) {
			ValaMethod* _tmp1305_;
			ValaMemberBinding _tmp1306_;
			ValaMemberBinding _tmp1307_;
			_tmp1305_ = m;
			_tmp1306_ = vala_method_get_binding (_tmp1305_);
			_tmp1307_ = _tmp1306_;
			_tmp1303_ = _tmp1307_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp1303_ = FALSE;
		}
		if (_tmp1303_) {
			ValaMethod* _tmp1308_;
			ValaSymbol* _tmp1309_;
			ValaSymbol* _tmp1310_;
			_tmp1308_ = m;
			_tmp1309_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1308_);
			_tmp1310_ = _tmp1309_;
			_tmp1302_ = VALA_IS_OBJECT_TYPE_SYMBOL (_tmp1310_);
		} else {
			_tmp1302_ = FALSE;
		}
		if (_tmp1302_) {
			ValaExpression* _tmp1311_;
			ValaExpression* _tmp1312_;
			_tmp1311_ = vala_member_access_get_inner (self);
			_tmp1312_ = _tmp1311_;
			_tmp1301_ = _tmp1312_ != NULL;
		} else {
			_tmp1301_ = FALSE;
		}
		if (_tmp1301_) {
			ValaExpression* _tmp1313_;
			ValaExpression* _tmp1314_;
			ValaDataType* _tmp1315_;
			ValaDataType* _tmp1316_;
			_tmp1313_ = vala_member_access_get_inner (self);
			_tmp1314_ = _tmp1313_;
			_tmp1315_ = vala_expression_get_value_type (_tmp1314_);
			_tmp1316_ = _tmp1315_;
			_tmp1300_ = _tmp1316_ == NULL;
		} else {
			_tmp1300_ = FALSE;
		}
		if (_tmp1300_) {
			ValaMemberAccess* _tmp1317_;
			ValaList* _tmp1318_;
			gint _tmp1319_;
			gint _tmp1320_;
			_tmp1317_ = inner_ma;
			_tmp1318_ = _tmp1317_->priv->type_argument_list;
			_tmp1319_ = vala_collection_get_size ((ValaCollection*) _tmp1318_);
			_tmp1320_ = _tmp1319_;
			_tmp1299_ = _tmp1320_ > 0;
		} else {
			_tmp1299_ = FALSE;
		}
		if (_tmp1299_) {
			ValaExpression* _tmp1321_;
			ValaExpression* _tmp1322_;
			ValaMethod* _tmp1323_;
			ValaSymbol* _tmp1324_;
			ValaSymbol* _tmp1325_;
			ValaObjectType* _tmp1326_;
			ValaObjectType* _tmp1327_;
			_tmp1321_ = vala_member_access_get_inner (self);
			_tmp1322_ = _tmp1321_;
			_tmp1323_ = m;
			_tmp1324_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1323_);
			_tmp1325_ = _tmp1324_;
			_tmp1326_ = vala_object_type_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp1325_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp1327_ = _tmp1326_;
			vala_expression_set_value_type (_tmp1322_, (ValaDataType*) _tmp1327_);
			_vala_code_node_unref0 (_tmp1327_);
			{
				ValaList* _type_argument_list = NULL;
				ValaMemberAccess* _tmp1328_;
				ValaList* _tmp1329_;
				ValaList* _tmp1330_;
				gint _type_argument_size = 0;
				ValaList* _tmp1331_;
				gint _tmp1332_;
				gint _tmp1333_;
				gint _type_argument_index = 0;
				_tmp1328_ = inner_ma;
				_tmp1329_ = _tmp1328_->priv->type_argument_list;
				_tmp1330_ = _vala_iterable_ref0 (_tmp1329_);
				_type_argument_list = _tmp1330_;
				_tmp1331_ = _type_argument_list;
				_tmp1332_ = vala_collection_get_size ((ValaCollection*) _tmp1331_);
				_tmp1333_ = _tmp1332_;
				_type_argument_size = _tmp1333_;
				_type_argument_index = -1;
				while (TRUE) {
					gint _tmp1334_;
					gint _tmp1335_;
					gint _tmp1336_;
					ValaDataType* type_argument = NULL;
					ValaList* _tmp1337_;
					gint _tmp1338_;
					gpointer _tmp1339_;
					ValaExpression* _tmp1340_;
					ValaExpression* _tmp1341_;
					ValaDataType* _tmp1342_;
					ValaDataType* _tmp1343_;
					ValaDataType* _tmp1344_;
					_tmp1334_ = _type_argument_index;
					_type_argument_index = _tmp1334_ + 1;
					_tmp1335_ = _type_argument_index;
					_tmp1336_ = _type_argument_size;
					if (!(_tmp1335_ < _tmp1336_)) {
						break;
					}
					_tmp1337_ = _type_argument_list;
					_tmp1338_ = _type_argument_index;
					_tmp1339_ = vala_list_get (_tmp1337_, _tmp1338_);
					type_argument = (ValaDataType*) _tmp1339_;
					_tmp1340_ = vala_member_access_get_inner (self);
					_tmp1341_ = _tmp1340_;
					_tmp1342_ = vala_expression_get_value_type (_tmp1341_);
					_tmp1343_ = _tmp1342_;
					_tmp1344_ = type_argument;
					vala_data_type_add_type_argument (_tmp1343_, _tmp1344_);
					_vala_code_node_unref0 (type_argument);
				}
				_vala_iterable_unref0 (_type_argument_list);
			}
		}
		_tmp1345_ = vala_code_context_get_analyzer (context);
		_tmp1346_ = _tmp1345_;
		_tmp1347_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1348_ = _tmp1347_;
		_tmp1349_ = vala_expression_get_lvalue ((ValaExpression*) self);
		_tmp1350_ = _tmp1349_;
		_tmp1351_ = vala_semantic_analyzer_get_value_type_for_symbol (_tmp1346_, _tmp1348_, _tmp1350_);
		_tmp1352_ = _tmp1351_;
		vala_expression_set_formal_value_type ((ValaExpression*) self, _tmp1352_);
		_vala_code_node_unref0 (_tmp1352_);
		_tmp1354_ = vala_member_access_get_inner (self);
		_tmp1355_ = _tmp1354_;
		if (_tmp1355_ != NULL) {
			ValaDataType* _tmp1356_;
			ValaDataType* _tmp1357_;
			_tmp1356_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1357_ = _tmp1356_;
			_tmp1353_ = _tmp1357_ != NULL;
		} else {
			_tmp1353_ = FALSE;
		}
		if (_tmp1353_) {
			ValaDataType* _tmp1358_;
			ValaDataType* _tmp1359_;
			ValaExpression* _tmp1360_;
			ValaExpression* _tmp1361_;
			ValaDataType* _tmp1362_;
			ValaDataType* _tmp1363_;
			ValaDataType* _tmp1364_;
			ValaDataType* _tmp1365_;
			_tmp1358_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1359_ = _tmp1358_;
			_tmp1360_ = vala_member_access_get_inner (self);
			_tmp1361_ = _tmp1360_;
			_tmp1362_ = vala_expression_get_value_type (_tmp1361_);
			_tmp1363_ = _tmp1362_;
			_tmp1364_ = vala_data_type_get_actual_type (_tmp1359_, _tmp1363_, NULL, (ValaCodeNode*) self);
			_tmp1365_ = _tmp1364_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1365_);
			_vala_code_node_unref0 (_tmp1365_);
		} else {
			ValaDataType* _tmp1366_;
			ValaDataType* _tmp1367_;
			_tmp1366_ = vala_expression_get_formal_value_type ((ValaExpression*) self);
			_tmp1367_ = _tmp1366_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp1367_);
		}
		_tmp1368_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp1369_ = _tmp1368_;
		if (VALA_IS_METHOD (_tmp1369_)) {
			ValaMethod* method = NULL;
			ValaSymbol* _tmp1370_;
			ValaSymbol* _tmp1371_;
			ValaMethod* _tmp1372_;
			ValaDataType* _tmp1373_;
			ValaDataType* _tmp1374_;
			gboolean _tmp1381_ = FALSE;
			gboolean _tmp1382_;
			_tmp1370_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1371_ = _tmp1370_;
			_tmp1372_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1371_, VALA_TYPE_METHOD, ValaMethod));
			method = _tmp1372_;
			_tmp1373_ = vala_expression_get_target_type ((ValaExpression*) self);
			_tmp1374_ = _tmp1373_;
			if (_tmp1374_ != NULL) {
				ValaDataType* _tmp1375_;
				ValaDataType* _tmp1376_;
				ValaDataType* _tmp1377_;
				ValaDataType* _tmp1378_;
				gboolean _tmp1379_;
				gboolean _tmp1380_;
				_tmp1375_ = vala_expression_get_value_type ((ValaExpression*) self);
				_tmp1376_ = _tmp1375_;
				_tmp1377_ = vala_expression_get_target_type ((ValaExpression*) self);
				_tmp1378_ = _tmp1377_;
				_tmp1379_ = vala_data_type_get_value_owned (_tmp1378_);
				_tmp1380_ = _tmp1379_;
				vala_data_type_set_value_owned (_tmp1376_, _tmp1380_);
			}
			_tmp1382_ = instance;
			if (_tmp1382_) {
				ValaMethod* _tmp1383_;
				ValaSymbol* _tmp1384_;
				ValaSymbol* _tmp1385_;
				_tmp1383_ = method;
				_tmp1384_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1383_);
				_tmp1385_ = _tmp1384_;
				_tmp1381_ = VALA_IS_TYPESYMBOL (_tmp1385_);
			} else {
				_tmp1381_ = FALSE;
			}
			if (_tmp1381_) {
				ValaExpression* _tmp1386_;
				ValaExpression* _tmp1387_;
				ValaMethod* _tmp1388_;
				ValaSymbol* _tmp1389_;
				ValaSymbol* _tmp1390_;
				ValaDataType* _tmp1391_;
				ValaDataType* _tmp1392_;
				ValaExpression* _tmp1393_;
				ValaExpression* _tmp1394_;
				ValaDataType* _tmp1395_;
				ValaDataType* _tmp1396_;
				ValaMethod* _tmp1397_;
				ValaParameter* _tmp1398_;
				ValaParameter* _tmp1399_;
				ValaDataType* _tmp1400_;
				ValaDataType* _tmp1401_;
				gboolean _tmp1402_;
				gboolean _tmp1403_;
				_tmp1386_ = vala_member_access_get_inner (self);
				_tmp1387_ = _tmp1386_;
				_tmp1388_ = method;
				_tmp1389_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1388_);
				_tmp1390_ = _tmp1389_;
				_tmp1391_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1390_);
				_tmp1392_ = _tmp1391_;
				vala_expression_set_target_type (_tmp1387_, _tmp1392_);
				_vala_code_node_unref0 (_tmp1392_);
				_tmp1393_ = vala_member_access_get_inner (self);
				_tmp1394_ = _tmp1393_;
				_tmp1395_ = vala_expression_get_target_type (_tmp1394_);
				_tmp1396_ = _tmp1395_;
				_tmp1397_ = method;
				_tmp1398_ = vala_method_get_this_parameter (_tmp1397_);
				_tmp1399_ = _tmp1398_;
				_tmp1400_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1399_);
				_tmp1401_ = _tmp1400_;
				_tmp1402_ = vala_data_type_get_value_owned (_tmp1401_);
				_tmp1403_ = _tmp1402_;
				vala_data_type_set_value_owned (_tmp1396_, _tmp1403_);
			}
			_vala_code_node_unref0 (method);
		} else {
			ValaSymbol* _tmp1404_;
			ValaSymbol* _tmp1405_;
			_tmp1404_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp1405_ = _tmp1404_;
			if (VALA_IS_PROPERTY (_tmp1405_)) {
				ValaProperty* prop = NULL;
				ValaSymbol* _tmp1406_;
				ValaSymbol* _tmp1407_;
				ValaProperty* _tmp1408_;
				gboolean _tmp1409_ = FALSE;
				gboolean _tmp1410_;
				_tmp1406_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1407_ = _tmp1406_;
				_tmp1408_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1407_, VALA_TYPE_PROPERTY, ValaProperty));
				prop = _tmp1408_;
				_tmp1410_ = instance;
				if (_tmp1410_) {
					ValaProperty* _tmp1411_;
					ValaSymbol* _tmp1412_;
					ValaSymbol* _tmp1413_;
					_tmp1411_ = prop;
					_tmp1412_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1411_);
					_tmp1413_ = _tmp1412_;
					_tmp1409_ = _tmp1413_ != NULL;
				} else {
					_tmp1409_ = FALSE;
				}
				if (_tmp1409_) {
					ValaExpression* _tmp1414_;
					ValaExpression* _tmp1415_;
					ValaProperty* _tmp1416_;
					ValaSymbol* _tmp1417_;
					ValaSymbol* _tmp1418_;
					ValaDataType* _tmp1419_;
					ValaDataType* _tmp1420_;
					_tmp1414_ = vala_member_access_get_inner (self);
					_tmp1415_ = _tmp1414_;
					_tmp1416_ = prop;
					_tmp1417_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1416_);
					_tmp1418_ = _tmp1417_;
					_tmp1419_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1418_);
					_tmp1420_ = _tmp1419_;
					vala_expression_set_target_type (_tmp1415_, _tmp1420_);
					_vala_code_node_unref0 (_tmp1420_);
				}
				_vala_code_node_unref0 (prop);
			} else {
				gboolean _tmp1421_ = FALSE;
				gboolean _tmp1422_ = FALSE;
				gboolean _tmp1423_ = FALSE;
				ValaSymbol* _tmp1424_;
				ValaSymbol* _tmp1425_;
				_tmp1424_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
				_tmp1425_ = _tmp1424_;
				if (VALA_IS_FIELD (_tmp1425_)) {
					_tmp1423_ = TRUE;
				} else {
					ValaSymbol* _tmp1426_;
					ValaSymbol* _tmp1427_;
					_tmp1426_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1427_ = _tmp1426_;
					_tmp1423_ = VALA_IS_SIGNAL (_tmp1427_);
				}
				if (_tmp1423_) {
					gboolean _tmp1428_;
					_tmp1428_ = instance;
					_tmp1422_ = _tmp1428_;
				} else {
					_tmp1422_ = FALSE;
				}
				if (_tmp1422_) {
					ValaSymbol* _tmp1429_;
					ValaSymbol* _tmp1430_;
					ValaSymbol* _tmp1431_;
					ValaSymbol* _tmp1432_;
					_tmp1429_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1430_ = _tmp1429_;
					_tmp1431_ = vala_symbol_get_parent_symbol (_tmp1430_);
					_tmp1432_ = _tmp1431_;
					_tmp1421_ = _tmp1432_ != NULL;
				} else {
					_tmp1421_ = FALSE;
				}
				if (_tmp1421_) {
					ValaDataType* parent_type = NULL;
					ValaSymbol* _tmp1433_;
					ValaSymbol* _tmp1434_;
					ValaSymbol* _tmp1435_;
					ValaSymbol* _tmp1436_;
					ValaDataType* _tmp1437_;
					ValaExpression* _tmp1438_;
					ValaExpression* _tmp1439_;
					ValaDataType* _tmp1440_;
					ValaExpression* _tmp1441_;
					ValaExpression* _tmp1442_;
					ValaDataType* _tmp1443_;
					ValaDataType* _tmp1444_;
					ValaDataType* _tmp1445_;
					ValaDataType* _tmp1446_;
					_tmp1433_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
					_tmp1434_ = _tmp1433_;
					_tmp1435_ = vala_symbol_get_parent_symbol (_tmp1434_);
					_tmp1436_ = _tmp1435_;
					_tmp1437_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp1436_);
					parent_type = _tmp1437_;
					_tmp1438_ = vala_member_access_get_inner (self);
					_tmp1439_ = _tmp1438_;
					_tmp1440_ = parent_type;
					_tmp1441_ = vala_member_access_get_inner (self);
					_tmp1442_ = _tmp1441_;
					_tmp1443_ = vala_expression_get_value_type (_tmp1442_);
					_tmp1444_ = _tmp1443_;
					_tmp1445_ = vala_data_type_get_actual_type (_tmp1440_, _tmp1444_, NULL, (ValaCodeNode*) self);
					_tmp1446_ = _tmp1445_;
					vala_expression_set_target_type (_tmp1439_, _tmp1446_);
					_vala_code_node_unref0 (_tmp1446_);
					_vala_code_node_unref0 (parent_type);
				}
			}
		}
		_vala_code_node_unref0 (inner_ma);
		_vala_code_node_unref0 (m);
	}
	_tmp1447_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp1448_ = _tmp1447_;
	result = !_tmp1448_;
	_vala_code_node_unref0 (member);
	_vala_code_node_unref0 (this_parameter);
	_vala_code_node_unref0 (base_symbol);
	return result;
}


static gboolean
vala_member_access_is_instance_symbol (ValaSymbol* symbol)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (symbol != NULL, FALSE);
	if (VALA_IS_FIELD (symbol)) {
		ValaMemberBinding _tmp1_;
		ValaMemberBinding _tmp2_;
		_tmp1_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_FIELD, ValaField));
		_tmp2_ = _tmp1_;
		_tmp0_ = _tmp2_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (VALA_IS_METHOD (symbol)) {
			_tmp4_ = !VALA_IS_CREATION_METHOD (symbol);
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			ValaMemberBinding _tmp5_;
			ValaMemberBinding _tmp6_;
			_tmp5_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_METHOD, ValaMethod));
			_tmp6_ = _tmp5_;
			_tmp3_ = _tmp6_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			result = TRUE;
			return result;
		} else {
			gboolean _tmp7_ = FALSE;
			if (VALA_IS_PROPERTY (symbol)) {
				ValaMemberBinding _tmp8_;
				ValaMemberBinding _tmp9_;
				_tmp8_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (symbol, VALA_TYPE_PROPERTY, ValaProperty));
				_tmp9_ = _tmp8_;
				_tmp7_ = _tmp9_ == VALA_MEMBER_BINDING_INSTANCE;
			} else {
				_tmp7_ = FALSE;
			}
			if (_tmp7_) {
				result = TRUE;
				return result;
			} else {
				if (VALA_IS_SIGNAL (symbol)) {
					result = TRUE;
					return result;
				} else {
					result = FALSE;
					return result;
				}
			}
		}
	}
}


void
vala_member_access_check_lvalue_access (ValaMemberAccess* self)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaSymbol* _tmp3_;
	ValaSymbol* _tmp4_;
	gboolean instance = FALSE;
	gboolean _tmp9_;
	gboolean _tmp17_;
	gboolean _tmp25_ = FALSE;
	ValaExpression* _tmp26_;
	ValaExpression* _tmp27_;
	ValaSymbol* _tmp28_;
	ValaSymbol* _tmp29_;
	gboolean this_access = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp37_ = FALSE;
	ValaExpression* _tmp38_;
	ValaExpression* _tmp39_;
	ValaDataType* _tmp40_;
	ValaDataType* _tmp41_;
	gboolean struct_or_array = FALSE;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp52_;
	ValaExpression* _tmp53_;
	ValaMemberAccess* _tmp54_;
	gboolean _tmp55_ = FALSE;
	gboolean _tmp56_ = FALSE;
	ValaMemberAccess* _tmp57_;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	gboolean _tmp68_ = FALSE;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_;
	gboolean _tmp91_ = FALSE;
	ValaSymbol* _tmp92_;
	ValaSymbol* _tmp93_;
	g_return_if_fail (self != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp3_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp4_ = _tmp3_;
	if (VALA_IS_FIELD (_tmp4_)) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		ValaMemberBinding _tmp7_;
		ValaMemberBinding _tmp8_;
		_tmp5_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_field_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_FIELD, ValaField));
		_tmp8_ = _tmp7_;
		_tmp2_ = _tmp8_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp2_ = FALSE;
	}
	instance = _tmp2_;
	_tmp9_ = instance;
	if (!_tmp9_) {
		gboolean _tmp10_ = FALSE;
		ValaSymbol* _tmp11_;
		ValaSymbol* _tmp12_;
		_tmp11_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		if (VALA_IS_METHOD (_tmp12_)) {
			ValaSymbol* _tmp13_;
			ValaSymbol* _tmp14_;
			ValaMemberBinding _tmp15_;
			ValaMemberBinding _tmp16_;
			_tmp13_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp14_ = _tmp13_;
			_tmp15_ = vala_method_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_METHOD, ValaMethod));
			_tmp16_ = _tmp15_;
			_tmp10_ = _tmp16_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp10_ = FALSE;
		}
		instance = _tmp10_;
	}
	_tmp17_ = instance;
	if (!_tmp17_) {
		gboolean _tmp18_ = FALSE;
		ValaSymbol* _tmp19_;
		ValaSymbol* _tmp20_;
		_tmp19_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp20_ = _tmp19_;
		if (VALA_IS_PROPERTY (_tmp20_)) {
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaMemberBinding _tmp23_;
			ValaMemberBinding _tmp24_;
			_tmp21_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
			_tmp22_ = _tmp21_;
			_tmp23_ = vala_property_get_binding (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
			_tmp24_ = _tmp23_;
			_tmp18_ = _tmp24_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp18_ = FALSE;
		}
		instance = _tmp18_;
	}
	_tmp26_ = vala_member_access_get_inner (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = vala_expression_get_symbol_reference (_tmp27_);
	_tmp29_ = _tmp28_;
	if (VALA_IS_PARAMETER (_tmp29_)) {
		ValaExpression* _tmp30_;
		ValaExpression* _tmp31_;
		ValaSymbol* _tmp32_;
		ValaSymbol* _tmp33_;
		const gchar* _tmp34_;
		const gchar* _tmp35_;
		_tmp30_ = vala_member_access_get_inner (self);
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_expression_get_symbol_reference (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_symbol_get_name (_tmp33_);
		_tmp35_ = _tmp34_;
		_tmp25_ = g_strcmp0 (_tmp35_, "this") == 0;
	} else {
		_tmp25_ = FALSE;
	}
	this_access = _tmp25_;
	_tmp38_ = vala_member_access_get_inner (self);
	_tmp39_ = _tmp38_;
	_tmp40_ = vala_expression_get_value_type (_tmp39_);
	_tmp41_ = _tmp40_;
	if (VALA_IS_STRUCT_VALUE_TYPE (_tmp41_)) {
		ValaExpression* _tmp42_;
		ValaExpression* _tmp43_;
		ValaDataType* _tmp44_;
		ValaDataType* _tmp45_;
		gboolean _tmp46_;
		gboolean _tmp47_;
		_tmp42_ = vala_member_access_get_inner (self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_expression_get_value_type (_tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_data_type_get_nullable (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp37_ = !_tmp47_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		_tmp36_ = TRUE;
	} else {
		ValaExpression* _tmp48_;
		ValaExpression* _tmp49_;
		ValaDataType* _tmp50_;
		ValaDataType* _tmp51_;
		_tmp48_ = vala_member_access_get_inner (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = vala_expression_get_value_type (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp36_ = VALA_IS_ARRAY_TYPE (_tmp51_);
	}
	struct_or_array = _tmp36_;
	_tmp52_ = vala_member_access_get_inner (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp53_) ? ((ValaMemberAccess*) _tmp53_) : NULL);
	ma = _tmp54_;
	_tmp57_ = ma;
	if (_tmp57_ == NULL) {
		gboolean _tmp58_;
		_tmp58_ = struct_or_array;
		_tmp56_ = _tmp58_;
	} else {
		_tmp56_ = FALSE;
	}
	if (_tmp56_) {
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		_tmp59_ = vala_member_access_get_inner (self);
		_tmp60_ = _tmp59_;
		_tmp55_ = VALA_IS_POINTER_INDIRECTION (_tmp60_);
	} else {
		_tmp55_ = FALSE;
	}
	if (_tmp55_) {
		ValaExpression* _tmp61_;
		ValaExpression* _tmp62_;
		ValaExpression* _tmp63_;
		ValaExpression* _tmp64_;
		ValaMemberAccess* _tmp65_;
		_tmp61_ = vala_member_access_get_inner (self);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_pointer_indirection_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp62_, VALA_TYPE_POINTER_INDIRECTION, ValaPointerIndirection));
		_tmp64_ = _tmp63_;
		_tmp65_ = _vala_code_node_ref0 (VALA_IS_MEMBER_ACCESS (_tmp64_) ? ((ValaMemberAccess*) _tmp64_) : NULL);
		_vala_code_node_unref0 (ma);
		ma = _tmp65_;
	}
	_tmp70_ = instance;
	if (_tmp70_) {
		gboolean _tmp71_;
		_tmp71_ = struct_or_array;
		_tmp69_ = _tmp71_;
	} else {
		_tmp69_ = FALSE;
	}
	if (_tmp69_) {
		gboolean _tmp72_ = FALSE;
		ValaSymbol* _tmp73_;
		ValaSymbol* _tmp74_;
		_tmp73_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp74_ = _tmp73_;
		if (VALA_IS_METHOD (_tmp74_)) {
			_tmp72_ = TRUE;
		} else {
			gboolean _tmp75_;
			gboolean _tmp76_;
			_tmp75_ = vala_expression_get_lvalue ((ValaExpression*) self);
			_tmp76_ = _tmp75_;
			_tmp72_ = _tmp76_;
		}
		_tmp68_ = _tmp72_;
	} else {
		_tmp68_ = FALSE;
	}
	if (_tmp68_) {
		gboolean _tmp77_ = FALSE;
		gboolean _tmp78_ = FALSE;
		ValaMemberAccess* _tmp79_;
		_tmp79_ = ma;
		if (_tmp79_ != NULL) {
			ValaMemberAccess* _tmp80_;
			ValaSymbol* _tmp81_;
			ValaSymbol* _tmp82_;
			_tmp80_ = ma;
			_tmp81_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp80_);
			_tmp82_ = _tmp81_;
			_tmp78_ = VALA_IS_VARIABLE (_tmp82_);
		} else {
			_tmp78_ = FALSE;
		}
		if (_tmp78_) {
			_tmp77_ = TRUE;
		} else {
			ValaExpression* _tmp83_;
			ValaExpression* _tmp84_;
			_tmp83_ = vala_member_access_get_inner (self);
			_tmp84_ = _tmp83_;
			_tmp77_ = VALA_IS_ELEMENT_ACCESS (_tmp84_);
		}
		_tmp67_ = _tmp77_;
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		gboolean _tmp85_;
		_tmp85_ = this_access;
		_tmp66_ = !_tmp85_;
	} else {
		_tmp66_ = FALSE;
	}
	if (_tmp66_) {
		ValaExpression* _tmp86_;
		ValaExpression* _tmp87_;
		ValaMemberAccess* _tmp88_;
		_tmp86_ = vala_member_access_get_inner (self);
		_tmp87_ = _tmp86_;
		vala_expression_set_lvalue (_tmp87_, TRUE);
		_tmp88_ = ma;
		if (_tmp88_ != NULL) {
			ValaMemberAccess* _tmp89_;
			ValaMemberAccess* _tmp90_;
			_tmp89_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp89_, TRUE);
			_tmp90_ = ma;
			vala_member_access_check_lvalue_access (_tmp90_);
		}
	}
	_tmp92_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp93_ = _tmp92_;
	if (VALA_IS_METHOD (_tmp93_)) {
		ValaSymbol* _tmp94_;
		ValaSymbol* _tmp95_;
		ValaAttribute* _tmp96_;
		ValaAttribute* _tmp97_;
		_tmp94_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp95_ = _tmp94_;
		_tmp96_ = vala_code_node_get_attribute ((ValaCodeNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp95_, VALA_TYPE_METHOD, ValaMethod), "DestroysInstance");
		_tmp97_ = _tmp96_;
		_tmp91_ = _tmp97_ != NULL;
		_vala_code_node_unref0 (_tmp97_);
	} else {
		_tmp91_ = FALSE;
	}
	if (_tmp91_) {
		ValaClass* cl = NULL;
		ValaSymbol* _tmp98_;
		ValaSymbol* _tmp99_;
		ValaSymbol* _tmp100_;
		ValaSymbol* _tmp101_;
		gboolean _tmp102_ = FALSE;
		gboolean _tmp103_ = FALSE;
		ValaClass* _tmp104_;
		_tmp98_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
		_tmp99_ = _tmp98_;
		_tmp100_ = vala_symbol_get_parent_symbol ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp99_, VALA_TYPE_METHOD, ValaMethod));
		_tmp101_ = _tmp100_;
		cl = VALA_IS_CLASS (_tmp101_) ? ((ValaClass*) _tmp101_) : NULL;
		_tmp104_ = cl;
		if (_tmp104_ != NULL) {
			ValaClass* _tmp105_;
			gboolean _tmp106_;
			gboolean _tmp107_;
			_tmp105_ = cl;
			_tmp106_ = vala_class_get_is_compact (_tmp105_);
			_tmp107_ = _tmp106_;
			_tmp103_ = _tmp107_;
		} else {
			_tmp103_ = FALSE;
		}
		if (_tmp103_) {
			ValaMemberAccess* _tmp108_;
			_tmp108_ = ma;
			_tmp102_ = _tmp108_ != NULL;
		} else {
			_tmp102_ = FALSE;
		}
		if (_tmp102_) {
			ValaMemberAccess* _tmp109_;
			ValaMemberAccess* _tmp110_;
			_tmp109_ = ma;
			vala_expression_set_lvalue ((ValaExpression*) _tmp109_, TRUE);
			_tmp110_ = ma;
			vala_member_access_check_lvalue_access (_tmp110_);
		}
	}
	_vala_code_node_unref0 (ma);
}


static void
vala_member_access_real_emit (ValaCodeNode* base,
                              ValaCodeGenerator* codegen)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_emit ((ValaCodeNode*) _tmp3_, codegen);
	}
	vala_code_visitor_visit_member_access ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_member_access_real_get_defined_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	}
}


static void
vala_member_access_real_get_used_variables (ValaCodeNode* base,
                                            ValaCollection* collection)
{
	ValaMemberAccess * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaLocalVariable* local = NULL;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaLocalVariable* _tmp6_;
	ValaParameter* param = NULL;
	ValaSymbol* _tmp7_;
	ValaSymbol* _tmp8_;
	ValaParameter* _tmp9_;
	ValaLocalVariable* _tmp10_;
	self = (ValaMemberAccess*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_member_access_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		_tmp2_ = vala_member_access_get_inner (self);
		_tmp3_ = _tmp2_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	}
	_tmp4_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _vala_code_node_ref0 (VALA_IS_LOCAL_VARIABLE (_tmp5_) ? ((ValaLocalVariable*) _tmp5_) : NULL);
	local = _tmp6_;
	_tmp7_ = vala_expression_get_symbol_reference ((ValaExpression*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = _vala_code_node_ref0 (VALA_IS_PARAMETER (_tmp8_) ? ((ValaParameter*) _tmp8_) : NULL);
	param = _tmp9_;
	_tmp10_ = local;
	if (_tmp10_ != NULL) {
		ValaLocalVariable* _tmp11_;
		_tmp11_ = local;
		vala_collection_add (collection, (ValaVariable*) _tmp11_);
	} else {
		gboolean _tmp12_ = FALSE;
		ValaParameter* _tmp13_;
		_tmp13_ = param;
		if (_tmp13_ != NULL) {
			ValaParameter* _tmp14_;
			ValaParameterDirection _tmp15_;
			ValaParameterDirection _tmp16_;
			_tmp14_ = param;
			_tmp15_ = vala_parameter_get_direction (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp12_ = _tmp16_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			ValaParameter* _tmp17_;
			_tmp17_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp17_);
		}
	}
	_vala_code_node_unref0 (param);
	_vala_code_node_unref0 (local);
}


ValaExpression*
vala_member_access_get_inner (ValaMemberAccess* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_inner (ValaMemberAccess* self,
                              ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		_tmp2_ = self->priv->_inner;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp2_, (ValaCodeNode*) self);
	}
}


const gchar*
vala_member_access_get_member_name (ValaMemberAccess* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_member_name;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_member_name (ValaMemberAccess* self,
                                    const gchar* value)
{
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_member_name);
	self->priv->_member_name = _tmp0_;
}


gboolean
vala_member_access_get_pointer_member_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_pointer_member_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_pointer_member_access (ValaMemberAccess* self,
                                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_pointer_member_access = value;
}


gboolean
vala_member_access_get_prototype_access (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_prototype_access;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_prototype_access (ValaMemberAccess* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_prototype_access = value;
}


gboolean
vala_member_access_get_creation_member (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_creation_member;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_creation_member (ValaMemberAccess* self,
                                        gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_creation_member = value;
}


gboolean
vala_member_access_get_qualified (ValaMemberAccess* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_qualified;
	result = _tmp0_;
	return result;
}


void
vala_member_access_set_qualified (ValaMemberAccess* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_qualified = value;
}


static void
vala_member_access_class_init (ValaMemberAccessClass * klass)
{
	vala_member_access_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_member_access_finalize;
	g_type_class_add_private (klass, sizeof (ValaMemberAccessPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_member_access_real_accept_children;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_member_access_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_member_access_real_replace_expression;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_member_access_real_is_accessible;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_member_access_real_replace_type;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_constant;
	((ValaExpressionClass *) klass)->is_non_null = (gboolean (*) (ValaExpression*)) vala_member_access_real_is_non_null;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_member_access_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_member_access_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_member_access_real_get_used_variables;
}


static void
vala_member_access_instance_init (ValaMemberAccess * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_MEMBER_ACCESS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->type_argument_list = (ValaList*) _tmp1_;
}


static void
vala_member_access_finalize (ValaCodeNode * obj)
{
	ValaMemberAccess * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess);
	_g_free0 (self->priv->_member_name);
	_vala_code_node_unref0 (self->priv->_inner);
	_vala_iterable_unref0 (self->priv->type_argument_list);
	VALA_CODE_NODE_CLASS (vala_member_access_parent_class)->finalize (obj);
}


/**
 * Represents an access to a type member in the source code.
 */
GType
vala_member_access_get_type (void)
{
	static volatile gsize vala_member_access_type_id__volatile = 0;
	if (g_once_init_enter (&vala_member_access_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaMemberAccessClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_member_access_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaMemberAccess), 0, (GInstanceInitFunc) vala_member_access_instance_init, NULL };
		GType vala_member_access_type_id;
		vala_member_access_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaMemberAccess", &g_define_type_info, 0);
		g_once_init_leave (&vala_member_access_type_id__volatile, vala_member_access_type_id);
	}
	return vala_member_access_type_id__volatile;
}



