/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                             ValaMethodCall* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp283_ = FALSE;
	ValaMethod* _tmp284_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp455_;
	ValaCCodeExpression* _tmp456_;
	ValaMethod* _tmp457_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp481_ = FALSE;
	ValaMethod* _tmp482_;
	gboolean _tmp638_ = FALSE;
	ValaMethod* _tmp639_;
	ValaMethod* _tmp702_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp898_;
	ValaIterator* _tmp899_;
	ValaIterator* _tmp1293_;
	gboolean _tmp1303_ = FALSE;
	gboolean _tmp1304_ = FALSE;
	ValaMethod* _tmp1305_;
	gboolean _tmp1430_ = FALSE;
	ValaDelegate* _tmp1431_;
	gboolean _tmp1528_ = FALSE;
	ValaMethod* _tmp1529_;
	gboolean _tmp1545_;
	gboolean _tmp1546_;
	gboolean _tmp1561_;
	ValaDataType* _tmp1586_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1610_;
	ValaDataType* _tmp1611_;
	ValaDataType* _tmp1612_;
	gboolean _tmp1613_;
	gboolean _tmp1614_ = FALSE;
	ValaDataType* _tmp1615_;
	ValaCCodeFunctionCall* _tmp1644_;
	ValaCCodeFunctionCall* _tmp1645_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1646_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1661_;
	ValaCCodeFunctionCall* _tmp1662_;
	ValaCCodeFunctionCall* _tmp1686_;
	gboolean _tmp1710_;
	gboolean _tmp1711_;
	gboolean _tmp1737_;
	gboolean _tmp1738_;
	gboolean _tmp1768_;
	gboolean _tmp1774_ = FALSE;
	gboolean _tmp1775_ = FALSE;
	ValaMethod* _tmp1776_;
	gboolean _tmp1814_ = FALSE;
	gboolean _tmp1815_ = FALSE;
	gboolean _tmp1816_ = FALSE;
	gboolean _tmp1817_ = FALSE;
	gboolean _tmp1818_ = FALSE;
	ValaMethod* _tmp1819_;
	gboolean _tmp1836_ = FALSE;
	gboolean _tmp1837_ = FALSE;
	ValaMethod* _tmp1838_;
	ValaMethod* _tmp1857_;
	gboolean _tmp1974_ = FALSE;
	ValaCodeNode* _tmp1975_;
	ValaCodeNode* _tmp1976_;
	ValaList* _tmp2052_;
	ValaIterator* _tmp2053_;
	gboolean _tmp2131_ = FALSE;
	gboolean _tmp2132_ = FALSE;
	ValaMethod* _tmp2133_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaMethod* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeIdentifier* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					ValaCCodeMemberAccess* _tmp282_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = m;
					_tmp279_ = vala_ccode_identifier_new ("_data_");
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp280_, "_res_");
					_tmp282_ = _tmp281_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp278_), FALSE)), (ValaCCodeExpression*) _tmp282_);
					_vala_ccode_node_unref0 (_tmp282_);
					_vala_ccode_node_unref0 (_tmp280_);
				}
			}
		}
	}
	_tmp284_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp284_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp285_;
		ValaSymbol* _tmp286_;
		ValaSymbol* _tmp287_;
		_tmp285_ = m;
		_tmp286_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp285_);
		_tmp287_ = _tmp286_;
		_tmp283_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp287_, VALA_TYPE_CLASS);
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		ValaMethod* _tmp288_;
		ValaSymbol* _tmp289_;
		ValaSymbol* _tmp290_;
		gboolean _tmp291_;
		gboolean _tmp292_;
		ValaClass* _tmp296_;
		ValaClass* _tmp297_;
		gboolean _tmp298_;
		gboolean _tmp299_;
		_tmp288_ = m;
		_tmp289_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_CLASS, ValaClass));
		_tmp292_ = _tmp291_;
		if (!_tmp292_) {
			ValaCCodeFunctionCall* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			ValaCCodeExpression* _tmp295_;
			_tmp293_ = ccall;
			_tmp294_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp293_, _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
		}
		_tmp296_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp297_ = _tmp296_;
		_tmp298_ = vala_class_get_is_compact (_tmp297_);
		_tmp299_ = _tmp298_;
		if (!_tmp299_) {
			ValaClass* _tmp300_;
			ValaClass* _tmp301_;
			ValaMethod* _tmp302_;
			ValaSymbol* _tmp303_;
			ValaSymbol* _tmp304_;
			_tmp300_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = m;
			_tmp303_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp302_);
			_tmp304_ = _tmp303_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp304_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp305_;
					ValaClass* _tmp306_;
					ValaList* _tmp307_;
					gint _base_type_size = 0;
					ValaList* _tmp308_;
					gint _tmp309_;
					gint _tmp310_;
					gint _base_type_index = 0;
					_tmp305_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_class_get_base_types (_tmp306_);
					_base_type_list = _tmp307_;
					_tmp308_ = _base_type_list;
					_tmp309_ = vala_collection_get_size ((ValaCollection*) _tmp308_);
					_tmp310_ = _tmp309_;
					_base_type_size = _tmp310_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp311_;
						gint _tmp312_;
						gint _tmp313_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp314_;
						gint _tmp315_;
						gpointer _tmp316_;
						ValaDataType* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						ValaTypeSymbol* _tmp319_;
						_tmp311_ = _base_type_index;
						_base_type_index = _tmp311_ + 1;
						_tmp312_ = _base_type_index;
						_tmp313_ = _base_type_size;
						if (!(_tmp312_ < _tmp313_)) {
							break;
						}
						_tmp314_ = _base_type_list;
						_tmp315_ = _base_type_index;
						_tmp316_ = vala_list_get (_tmp314_, _tmp315_);
						base_type = (ValaDataType*) _tmp316_;
						_tmp317_ = base_type;
						_tmp318_ = vala_data_type_get_data_type (_tmp317_);
						_tmp319_ = _tmp318_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp320_;
							gchar* _tmp321_;
							gchar* _tmp322_;
							gboolean _tmp323_;
							ValaHashMap* _tmp328_;
							ValaDataType* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							ValaList* _tmp332_;
							type_parameters = NULL;
							_tmp320_ = m;
							_tmp321_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp320_);
							_tmp322_ = _tmp321_;
							_tmp323_ = g_strcmp0 (_tmp322_, "g_object_new") == 0;
							_g_free0 (_tmp322_);
							if (_tmp323_) {
								ValaDataType* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaTypeSymbol* _tmp326_;
								ValaList* _tmp327_;
								_tmp324_ = base_type;
								_tmp325_ = vala_data_type_get_data_type (_tmp324_);
								_tmp326_ = _tmp325_;
								_tmp327_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp327_;
							}
							_tmp328_ = in_arg_map;
							_tmp329_ = base_type;
							_tmp330_ = vala_data_type_get_type_arguments (_tmp329_);
							_tmp331_ = _tmp330_;
							_tmp332_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp328_, _tmp331_, (ValaCodeNode*) expr, TRUE, _tmp332_);
							_vala_iterable_unref0 (_tmp331_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaSymbol* _tmp335_;
				ValaClass* _tmp336_;
				type_param_index = 0;
				_tmp333_ = m;
				_tmp334_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp333_);
				_tmp335_ = _tmp334_;
				_tmp336_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp336_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp337_;
					ValaList* _tmp338_;
					gint _type_param_size = 0;
					ValaList* _tmp339_;
					gint _tmp340_;
					gint _tmp341_;
					gint _type_param_index = 0;
					_tmp337_ = cl;
					_tmp338_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp337_);
					_type_param_list = _tmp338_;
					_tmp339_ = _type_param_list;
					_tmp340_ = vala_collection_get_size ((ValaCollection*) _tmp339_);
					_tmp341_ = _tmp340_;
					_type_param_size = _tmp341_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp342_;
						gint _tmp343_;
						gint _tmp344_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp345_;
						gint _tmp346_;
						gpointer _tmp347_;
						ValaHashMap* _tmp348_;
						gint _tmp349_;
						ValaTypeParameter* _tmp350_;
						const gchar* _tmp351_;
						const gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaCCodeIdentifier* _tmp358_;
						ValaHashMap* _tmp359_;
						gint _tmp360_;
						ValaTypeParameter* _tmp361_;
						const gchar* _tmp362_;
						const gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						ValaHashMap* _tmp370_;
						gint _tmp371_;
						ValaTypeParameter* _tmp372_;
						const gchar* _tmp373_;
						const gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						gchar* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						ValaCCodeIdentifier* _tmp380_;
						gint _tmp381_;
						_tmp342_ = _type_param_index;
						_type_param_index = _tmp342_ + 1;
						_tmp343_ = _type_param_index;
						_tmp344_ = _type_param_size;
						if (!(_tmp343_ < _tmp344_)) {
							break;
						}
						_tmp345_ = _type_param_list;
						_tmp346_ = _type_param_index;
						_tmp347_ = vala_list_get (_tmp345_, _tmp346_);
						type_param = (ValaTypeParameter*) _tmp347_;
						_tmp348_ = in_arg_map;
						_tmp349_ = type_param_index;
						_tmp350_ = type_param;
						_tmp351_ = vala_symbol_get_name ((ValaSymbol*) _tmp350_);
						_tmp352_ = _tmp351_;
						_tmp353_ = g_utf8_strdown (_tmp352_, (gssize) -1);
						_tmp354_ = _tmp353_;
						_tmp355_ = g_strdup_printf ("%s_type", _tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_ccode_identifier_new (_tmp356_);
						_tmp358_ = _tmp357_;
						vala_map_set ((ValaMap*) _tmp348_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp349_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp358_);
						_vala_ccode_node_unref0 (_tmp358_);
						_g_free0 (_tmp356_);
						_g_free0 (_tmp354_);
						_tmp359_ = in_arg_map;
						_tmp360_ = type_param_index;
						_tmp361_ = type_param;
						_tmp362_ = vala_symbol_get_name ((ValaSymbol*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = g_utf8_strdown (_tmp363_, (gssize) -1);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_strdup_printf ("%s_dup_func", _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_ccode_identifier_new (_tmp367_);
						_tmp369_ = _tmp368_;
						vala_map_set ((ValaMap*) _tmp359_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp360_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp369_);
						_vala_ccode_node_unref0 (_tmp369_);
						_g_free0 (_tmp367_);
						_g_free0 (_tmp365_);
						_tmp370_ = in_arg_map;
						_tmp371_ = type_param_index;
						_tmp372_ = type_param;
						_tmp373_ = vala_symbol_get_name ((ValaSymbol*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_utf8_strdown (_tmp374_, (gssize) -1);
						_tmp376_ = _tmp375_;
						_tmp377_ = g_strdup_printf ("%s_destroy_func", _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_ccode_identifier_new (_tmp378_);
						_tmp380_ = _tmp379_;
						vala_map_set ((ValaMap*) _tmp370_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp371_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp380_);
						_vala_ccode_node_unref0 (_tmp380_);
						_g_free0 (_tmp378_);
						_g_free0 (_tmp376_);
						_tmp381_ = type_param_index;
						type_param_index = _tmp381_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			ValaClass* _tmp386_;
			_tmp382_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp383_ = _tmp382_;
			_tmp384_ = vala_class_get_base_class (_tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp385_ == _tmp386_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp387_;
				ValaClass* _tmp388_;
				gchar* _tmp389_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				ValaCCodeDeclaration* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				const gchar* _tmp396_;
				gchar* _tmp397_;
				gchar* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeConstant* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeVariableDeclarator* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeFunction* _tmp404_;
				ValaCCodeDeclaration* _tmp405_;
				ValaCCodeFunctionCall* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeIdentifier* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeUnaryExpression* _tmp410_;
				ValaCCodeCastExpression* _tmp411_;
				ValaCCodeCastExpression* _tmp412_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeFunctionCall* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaCCodeFunctionCall* _tmp417_;
				ValaClass* _tmp418_;
				ValaClass* _tmp419_;
				gchar* _tmp420_;
				gchar* _tmp421_;
				ValaCCodeIdentifier* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeFunctionCall* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				_tmp387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp388_ = _tmp387_;
				_tmp389_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp388_, NULL);
				class_prefix = _tmp389_;
				_tmp390_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp390_;
				_tmp391_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp391_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp392_ = funcs;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = class_prefix;
				_tmp397_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp393_, _tmp394_, _tmp395_, _tmp396_);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_ccode_constant_new (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp400_, NULL);
				_tmp402_ = _tmp401_;
				vala_ccode_declaration_add_declarator (_tmp392_, (ValaCCodeDeclarator*) _tmp402_);
				_vala_ccode_node_unref0 (_tmp402_);
				_vala_ccode_node_unref0 (_tmp400_);
				_g_free0 (_tmp398_);
				_tmp403_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp404_ = _tmp403_;
				_tmp405_ = funcs;
				vala_ccode_function_add_statement (_tmp404_, (ValaCCodeNode*) _tmp405_);
				_tmp406_ = ccall;
				_tmp407_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp408_ = _tmp407_;
				_tmp409_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp410_, "GSourceFuncs *");
				_tmp412_ = _tmp411_;
				vala_ccode_function_call_add_argument (_tmp406_, (ValaCCodeExpression*) _tmp412_);
				_vala_ccode_node_unref0 (_tmp412_);
				_vala_ccode_node_unref0 (_tmp410_);
				_vala_ccode_node_unref0 (_tmp408_);
				_tmp413_ = vala_ccode_identifier_new ("sizeof");
				_tmp414_ = _tmp413_;
				_tmp415_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp414_);
				_tmp416_ = _tmp415_;
				_vala_ccode_node_unref0 (_tmp414_);
				csizeof = _tmp416_;
				_tmp417_ = csizeof;
				_tmp418_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_get_ccode_name ((ValaCodeNode*) _tmp419_);
				_tmp421_ = _tmp420_;
				_tmp422_ = vala_ccode_identifier_new (_tmp421_);
				_tmp423_ = _tmp422_;
				vala_ccode_function_call_add_argument (_tmp417_, (ValaCCodeExpression*) _tmp423_);
				_vala_ccode_node_unref0 (_tmp423_);
				_g_free0 (_tmp421_);
				_tmp424_ = ccall;
				_tmp425_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp424_, (ValaCCodeExpression*) _tmp425_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp426_ = FALSE;
		ValaMethod* _tmp427_;
		_tmp427_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp428_;
			ValaSymbol* _tmp429_;
			ValaSymbol* _tmp430_;
			_tmp428_ = m;
			_tmp429_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp428_);
			_tmp430_ = _tmp429_;
			_tmp426_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp430_, VALA_TYPE_STRUCT);
		} else {
			_tmp426_ = FALSE;
		}
		if (_tmp426_) {
			ValaCCodeFunctionCall* _tmp431_;
			ValaCCodeExpression* _tmp432_;
			ValaCCodeExpression* _tmp433_;
			_tmp431_ = ccall;
			_tmp432_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp433_ = _tmp432_;
			vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
			_vala_ccode_node_unref0 (_tmp433_);
		} else {
			gboolean _tmp434_ = FALSE;
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			gboolean _tmp437_ = FALSE;
			ValaMethod* _tmp438_;
			_tmp438_ = m;
			if (_tmp438_ != NULL) {
				ValaMethod* _tmp439_;
				ValaList* _tmp440_;
				ValaList* _tmp441_;
				gint _tmp442_;
				gint _tmp443_;
				_tmp439_ = m;
				_tmp440_ = vala_method_get_type_parameters (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_collection_get_size ((ValaCollection*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp437_ = _tmp443_ > 0;
				_vala_iterable_unref0 (_tmp441_);
			} else {
				_tmp437_ = FALSE;
			}
			if (_tmp437_) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp436_ = !vala_get_ccode_has_generic_type_parameter (_tmp444_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp435_ = !vala_get_ccode_simple_generics (_tmp445_);
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				gboolean _tmp446_ = FALSE;
				ValaCCodeFunctionCall* _tmp447_;
				ValaCCodeFunctionCall* _tmp448_;
				_tmp447_ = ccall;
				_tmp448_ = finish_call;
				if (_tmp447_ != _tmp448_) {
					_tmp446_ = TRUE;
				} else {
					gboolean _tmp449_;
					gboolean _tmp450_;
					_tmp449_ = vala_method_call_get_is_yield_expression (expr);
					_tmp450_ = _tmp449_;
					_tmp446_ = _tmp450_;
				}
				_tmp434_ = _tmp446_;
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaHashMap* _tmp451_;
				ValaMemberAccess* _tmp452_;
				ValaList* _tmp453_;
				ValaList* _tmp454_;
				_tmp451_ = in_arg_map;
				_tmp452_ = ma;
				_tmp453_ = vala_member_access_get_type_arguments (_tmp452_);
				_tmp454_ = _tmp453_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp451_, _tmp454_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp454_);
			}
		}
	}
	_tmp455_ = ccall;
	_tmp456_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp455_);
	ccall_expr = _tmp456_;
	_tmp457_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp457_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp458_;
		ValaExpression* _tmp459_;
		ValaExpression* _tmp460_;
		ValaDataType* _tmp461_;
		ValaDataType* _tmp462_;
		ValaArrayType* _tmp463_;
		ValaHashMap* _tmp464_;
		ValaArrayType* _tmp465_;
		ValaDataType* _tmp466_;
		ValaDataType* _tmp467_;
		gchar* _tmp468_;
		gchar* _tmp469_;
		ValaCCodeIdentifier* _tmp470_;
		ValaCCodeIdentifier* _tmp471_;
		_tmp458_ = ma;
		_tmp459_ = vala_member_access_get_inner (_tmp458_);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_expression_get_value_type (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp463_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp463_;
		_tmp464_ = in_arg_map;
		_tmp465_ = array_type;
		_tmp466_ = vala_array_type_get_element_type (_tmp465_);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_get_ccode_name ((ValaCodeNode*) _tmp467_);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_ccode_identifier_new (_tmp469_);
		_tmp471_ = _tmp470_;
		vala_map_set ((ValaMap*) _tmp464_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp471_);
		_vala_ccode_node_unref0 (_tmp471_);
		_g_free0 (_tmp469_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp472_;
		_tmp472_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp472_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp473_;
			_tmp473_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp473_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp474_;
				ValaExpression* _tmp475_;
				ValaExpression* _tmp476_;
				ValaTargetValue* _tmp477_;
				ValaTargetValue* _tmp478_;
				ValaTargetValue* _tmp479_;
				ValaTargetValue* _tmp480_;
				_tmp474_ = ma;
				_tmp475_ = vala_member_access_get_inner (_tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = vala_expression_get_target_value (_tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp478_, (ValaCodeNode*) expr);
				_tmp480_ = _tmp479_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp480_);
				_vala_target_value_unref0 (_tmp480_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp482_ = m;
	if (_tmp482_ != NULL) {
		ValaMethod* _tmp483_;
		gboolean _tmp484_;
		gboolean _tmp485_;
		_tmp483_ = m;
		_tmp484_ = vala_method_get_is_async_callback (_tmp483_);
		_tmp485_ = _tmp484_;
		_tmp481_ = _tmp485_;
	} else {
		_tmp481_ = FALSE;
	}
	if (_tmp481_) {
		ValaMethod* _tmp486_;
		ValaMethod* _tmp487_;
		gboolean _tmp488_;
		gboolean _tmp489_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		ValaHashMap* _tmp506_;
		ValaMethod* _tmp507_;
		ValaCCodeExpression* _tmp508_;
		_tmp486_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp487_ = _tmp486_;
		_tmp488_ = vala_method_get_closure (_tmp487_);
		_tmp489_ = _tmp488_;
		if (_tmp489_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp490_;
			ValaSymbol* _tmp491_;
			ValaSymbol* _tmp492_;
			ValaBlock* _tmp493_;
			ValaBlock* _tmp494_;
			ValaBlock* _tmp495_;
			ValaBlock* _tmp496_;
			gchar* _tmp497_;
			gchar* _tmp498_;
			ValaCCodeExpression* _tmp499_;
			ValaCCodeExpression* _tmp500_;
			ValaCCodeMemberAccess* _tmp501_;
			_tmp490_ = m;
			_tmp491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp490_);
			_tmp492_ = _tmp491_;
			_tmp493_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp492_, VALA_TYPE_METHOD, ValaMethod));
			_tmp494_ = _tmp493_;
			_tmp495_ = _vala_code_node_ref0 (_tmp494_);
			block = _tmp495_;
			_tmp496_ = block;
			_tmp497_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp496_));
			_tmp498_ = _tmp497_;
			_tmp499_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp498_);
			_tmp500_ = _tmp499_;
			_tmp501_ = vala_ccode_member_access_new_pointer (_tmp500_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp501_;
			_vala_ccode_node_unref0 (_tmp500_);
			_g_free0 (_tmp498_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp502_;
			_tmp502_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp502_;
		}
		_tmp503_ = in_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
		_tmp506_ = out_arg_map;
		_tmp507_ = m;
		_tmp508_ = instance;
		vala_map_set ((ValaMap*) _tmp506_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp507_), FALSE)), _tmp508_);
	} else {
		gboolean _tmp509_ = FALSE;
		gboolean _tmp510_ = FALSE;
		ValaMethod* _tmp511_;
		_tmp511_ = m;
		if (_tmp511_ != NULL) {
			ValaMethod* _tmp512_;
			ValaMemberBinding _tmp513_;
			ValaMemberBinding _tmp514_;
			_tmp512_ = m;
			_tmp513_ = vala_method_get_binding (_tmp512_);
			_tmp514_ = _tmp513_;
			_tmp510_ = _tmp514_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp510_ = FALSE;
		}
		if (_tmp510_) {
			ValaMethod* _tmp515_;
			_tmp515_ = m;
			_tmp509_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp515_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp509_ = FALSE;
		}
		if (_tmp509_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp516_;
			ValaExpression* _tmp517_;
			ValaExpression* _tmp518_;
			ValaTargetValue* _tmp519_;
			ValaTargetValue* _tmp520_;
			ValaTargetValue* _tmp521_;
			gboolean _tmp522_ = FALSE;
			gboolean _tmp523_ = FALSE;
			ValaMemberAccess* _tmp524_;
			const gchar* _tmp525_;
			const gchar* _tmp526_;
			ValaTargetValue* _tmp548_;
			ValaCCodeExpression* _tmp549_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp550_;
			ValaSymbol* _tmp551_;
			ValaSymbol* _tmp552_;
			ValaStruct* _tmp553_;
			gboolean _tmp554_ = FALSE;
			ValaStruct* _tmp555_;
			gboolean _tmp564_;
			gboolean _tmp565_;
			_tmp516_ = ma;
			_tmp517_ = vala_member_access_get_inner (_tmp516_);
			_tmp518_ = _tmp517_;
			_tmp519_ = vala_expression_get_target_value (_tmp518_);
			_tmp520_ = _tmp519_;
			_tmp521_ = _vala_target_value_ref0 (_tmp520_);
			instance_value = _tmp521_;
			_tmp524_ = ma;
			_tmp525_ = vala_member_access_get_member_name (_tmp524_);
			_tmp526_ = _tmp525_;
			if (g_strcmp0 (_tmp526_, "begin") == 0) {
				_tmp523_ = TRUE;
			} else {
				ValaMemberAccess* _tmp527_;
				const gchar* _tmp528_;
				const gchar* _tmp529_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_member_name (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp523_ = g_strcmp0 (_tmp529_, "end") == 0;
			}
			if (_tmp523_) {
				ValaMemberAccess* _tmp530_;
				ValaExpression* _tmp531_;
				ValaExpression* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				ValaMemberAccess* _tmp535_;
				ValaSymbol* _tmp536_;
				ValaSymbol* _tmp537_;
				_tmp530_ = ma;
				_tmp531_ = vala_member_access_get_inner (_tmp530_);
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_expression_get_symbol_reference (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = ma;
				_tmp536_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp535_);
				_tmp537_ = _tmp536_;
				_tmp522_ = _tmp534_ == _tmp537_;
			} else {
				_tmp522_ = FALSE;
			}
			if (_tmp522_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp538_;
				ValaExpression* _tmp539_;
				ValaExpression* _tmp540_;
				ValaMemberAccess* _tmp541_;
				ValaMemberAccess* _tmp542_;
				ValaExpression* _tmp543_;
				ValaExpression* _tmp544_;
				ValaTargetValue* _tmp545_;
				ValaTargetValue* _tmp546_;
				ValaTargetValue* _tmp547_;
				_tmp538_ = ma;
				_tmp539_ = vala_member_access_get_inner (_tmp538_);
				_tmp540_ = _tmp539_;
				_tmp541_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp540_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp541_;
				_tmp542_ = inner_ma;
				_tmp543_ = vala_member_access_get_inner (_tmp542_);
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_expression_get_target_value (_tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = _vala_target_value_ref0 (_tmp546_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp547_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp548_ = instance_value;
			_tmp549_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp548_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp549_;
			_tmp550_ = m;
			_tmp551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp550_);
			_tmp552_ = _tmp551_;
			_tmp553_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp552_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp552_) : NULL);
			st = _tmp553_;
			_tmp555_ = st;
			if (_tmp555_ != NULL) {
				ValaStruct* _tmp556_;
				_tmp556_ = st;
				_tmp554_ = !vala_struct_is_simple_type (_tmp556_);
			} else {
				_tmp554_ = FALSE;
			}
			if (_tmp554_) {
				ValaTargetValue* _tmp557_;
				ValaTargetValue* _tmp560_;
				ValaCCodeExpression* _tmp561_;
				ValaCCodeExpression* _tmp562_;
				ValaCCodeUnaryExpression* _tmp563_;
				_tmp557_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp557_)) {
					ValaTargetValue* _tmp558_;
					ValaTargetValue* _tmp559_;
					_tmp558_ = instance_value;
					_tmp559_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp558_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp559_;
				}
				_tmp560_ = instance_value;
				_tmp561_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp560_);
				_tmp562_ = _tmp561_;
				_tmp563_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp562_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp563_;
				_vala_ccode_node_unref0 (_tmp562_);
			}
			_tmp564_ = vala_method_call_get_is_yield_expression (expr);
			_tmp565_ = _tmp564_;
			if (_tmp565_) {
				ValaHashMap* _tmp566_;
				ValaMethod* _tmp567_;
				ValaCCodeExpression* _tmp568_;
				ValaMethod* _tmp569_;
				_tmp566_ = in_arg_map;
				_tmp567_ = m;
				_tmp568_ = instance;
				vala_map_set ((ValaMap*) _tmp566_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp567_), FALSE)), _tmp568_);
				_tmp569_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp569_)) {
					ValaHashMap* _tmp570_;
					ValaMethod* _tmp571_;
					ValaCCodeExpression* _tmp572_;
					_tmp570_ = out_arg_map;
					_tmp571_ = m;
					_tmp572_ = instance;
					vala_map_set ((ValaMap*) _tmp570_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp571_), FALSE)), _tmp572_);
				}
			} else {
				gboolean _tmp573_ = FALSE;
				ValaMemberAccess* _tmp574_;
				const gchar* _tmp575_;
				const gchar* _tmp576_;
				_tmp574_ = ma;
				_tmp575_ = vala_member_access_get_member_name (_tmp574_);
				_tmp576_ = _tmp575_;
				if (g_strcmp0 (_tmp576_, "end") != 0) {
					_tmp573_ = TRUE;
				} else {
					ValaMethod* _tmp577_;
					_tmp577_ = m;
					_tmp573_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp577_);
				}
				if (_tmp573_) {
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					ValaHashMap* _tmp581_;
					ValaMethod* _tmp582_;
					ValaCCodeExpression* _tmp583_;
					_tmp578_ = out_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
					_tmp581_ = in_arg_map;
					_tmp582_ = m;
					_tmp583_ = instance;
					vala_map_set ((ValaMap*) _tmp581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp582_), FALSE)), _tmp583_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp584_ = FALSE;
			ValaMethod* _tmp585_;
			_tmp585_ = m;
			if (_tmp585_ != NULL) {
				ValaMethod* _tmp586_;
				ValaMemberBinding _tmp587_;
				ValaMemberBinding _tmp588_;
				_tmp586_ = m;
				_tmp587_ = vala_method_get_binding (_tmp586_);
				_tmp588_ = _tmp587_;
				_tmp584_ = _tmp588_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp584_ = FALSE;
			}
			if (_tmp584_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp589_;
				ValaSymbol* _tmp590_;
				ValaSymbol* _tmp591_;
				ValaClass* _tmp592_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp593_;
				gchar* _tmp594_;
				gchar* _tmp595_;
				gchar* _tmp596_;
				gchar* _tmp597_;
				ValaCCodeIdentifier* _tmp598_;
				ValaCCodeIdentifier* _tmp599_;
				ValaCCodeFunctionCall* _tmp600_;
				ValaCCodeFunctionCall* _tmp601_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp602_;
				ValaExpression* _tmp603_;
				ValaExpression* _tmp604_;
				ValaCCodeFunctionCall* _tmp630_;
				ValaCCodeExpression* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				ValaHashMap* _tmp635_;
				ValaMethod* _tmp636_;
				ValaCCodeFunctionCall* _tmp637_;
				_tmp589_ = m;
				_tmp590_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp589_);
				_tmp591_ = _tmp590_;
				_tmp592_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp591_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp592_;
				_tmp593_ = cl;
				_tmp594_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp593_, NULL);
				_tmp595_ = _tmp594_;
				_tmp596_ = g_strconcat (_tmp595_, "_CLASS", NULL);
				_tmp597_ = _tmp596_;
				_tmp598_ = vala_ccode_identifier_new (_tmp597_);
				_tmp599_ = _tmp598_;
				_tmp600_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp599_);
				_tmp601_ = _tmp600_;
				_vala_ccode_node_unref0 (_tmp599_);
				_g_free0 (_tmp597_);
				_g_free0 (_tmp595_);
				cast = _tmp601_;
				_tmp602_ = ma;
				_tmp603_ = vala_member_access_get_inner (_tmp602_);
				_tmp604_ = _tmp603_;
				if (_tmp604_ == NULL) {
					ValaDataType* _tmp605_;
					ValaDataType* _tmp606_;
					gboolean _tmp607_;
					_tmp605_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp606_ = _tmp605_;
					_tmp607_ = _tmp606_ == NULL;
					_vala_code_node_unref0 (_tmp606_);
					if (_tmp607_) {
						ValaCCodeIdentifier* _tmp608_;
						_tmp608_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp608_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp609_;
						ValaCCodeIdentifier* _tmp610_;
						ValaCCodeFunctionCall* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						ValaCCodeExpression* _tmp615_;
						ValaCCodeFunctionCall* _tmp616_;
						ValaCCodeExpression* _tmp617_;
						_tmp609_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp610_ = _tmp609_;
						_tmp611_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp610_);
						_tmp612_ = _tmp611_;
						_vala_ccode_node_unref0 (_tmp610_);
						k = _tmp612_;
						_tmp613_ = k;
						_tmp614_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp615_ = _tmp614_;
						vala_ccode_function_call_add_argument (_tmp613_, _tmp615_);
						_vala_ccode_node_unref0 (_tmp615_);
						_tmp616_ = k;
						_tmp617_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp616_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp617_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp618_;
					ValaCCodeIdentifier* _tmp619_;
					ValaCCodeFunctionCall* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaMemberAccess* _tmp623_;
					ValaExpression* _tmp624_;
					ValaExpression* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					ValaCCodeExpression* _tmp627_;
					ValaCCodeFunctionCall* _tmp628_;
					ValaCCodeExpression* _tmp629_;
					_tmp618_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp619_);
					_tmp621_ = _tmp620_;
					_vala_ccode_node_unref0 (_tmp619_);
					k = _tmp621_;
					_tmp622_ = k;
					_tmp623_ = ma;
					_tmp624_ = vala_member_access_get_inner (_tmp623_);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp625_);
					_tmp627_ = _tmp626_;
					vala_ccode_function_call_add_argument (_tmp622_, _tmp627_);
					_vala_ccode_node_unref0 (_tmp627_);
					_tmp628_ = k;
					_tmp629_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp628_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp629_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp630_ = cast;
				_tmp631_ = klass;
				vala_ccode_function_call_add_argument (_tmp630_, _tmp631_);
				_tmp632_ = in_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_tmp635_ = out_arg_map;
				_tmp636_ = m;
				_tmp637_ = cast;
				vala_map_set ((ValaMap*) _tmp635_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp636_), FALSE)), (ValaCCodeExpression*) _tmp637_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp639_ = m;
	if (_tmp639_ != NULL) {
		ValaMethod* _tmp640_;
		_tmp640_ = m;
		_tmp638_ = vala_get_ccode_has_generic_type_parameter (_tmp640_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaMethod* _tmp641_;
		ValaList* _tmp642_;
		ValaList* _tmp643_;
		gint _tmp644_;
		gint _tmp645_;
		gboolean _tmp646_;
		_tmp641_ = m;
		_tmp642_ = vala_method_get_type_parameters (_tmp641_);
		_tmp643_ = _tmp642_;
		_tmp644_ = vala_collection_get_size ((ValaCollection*) _tmp643_);
		_tmp645_ = _tmp644_;
		_tmp646_ = _tmp645_ > 0;
		_vala_iterable_unref0 (_tmp643_);
		if (_tmp646_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp647_;
				ValaList* _tmp648_;
				gint _type_arg_size = 0;
				ValaList* _tmp649_;
				gint _tmp650_;
				gint _tmp651_;
				gint _type_arg_index = 0;
				_tmp647_ = ma;
				_tmp648_ = vala_member_access_get_type_arguments (_tmp647_);
				_type_arg_list = _tmp648_;
				_tmp649_ = _type_arg_list;
				_tmp650_ = vala_collection_get_size ((ValaCollection*) _tmp649_);
				_tmp651_ = _tmp650_;
				_type_arg_size = _tmp651_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp652_;
					gint _tmp653_;
					gint _tmp654_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp655_;
					gint _tmp656_;
					gpointer _tmp657_;
					gboolean _tmp658_ = FALSE;
					gboolean _tmp659_ = FALSE;
					gboolean _tmp660_ = FALSE;
					ValaMethod* _tmp661_;
					ValaHashMap* _tmp669_;
					ValaMethod* _tmp670_;
					gint _tmp671_;
					ValaDataType* _tmp672_;
					gchar* _tmp673_;
					gchar* _tmp674_;
					ValaCCodeIdentifier* _tmp675_;
					ValaCCodeIdentifier* _tmp676_;
					gint _tmp677_;
					_tmp652_ = _type_arg_index;
					_type_arg_index = _tmp652_ + 1;
					_tmp653_ = _type_arg_index;
					_tmp654_ = _type_arg_size;
					if (!(_tmp653_ < _tmp654_)) {
						break;
					}
					_tmp655_ = _type_arg_list;
					_tmp656_ = _type_arg_index;
					_tmp657_ = vala_list_get (_tmp655_, _tmp656_);
					type_arg = (ValaDataType*) _tmp657_;
					_tmp661_ = m;
					if (vala_get_ccode_simple_generics (_tmp661_)) {
						ValaDataType* _tmp662_;
						_tmp662_ = type_arg;
						_tmp660_ = vala_data_type_is_real_struct_type (_tmp662_);
					} else {
						_tmp660_ = FALSE;
					}
					if (_tmp660_) {
						ValaDataType* _tmp663_;
						gboolean _tmp664_;
						gboolean _tmp665_;
						_tmp663_ = type_arg;
						_tmp664_ = vala_data_type_get_nullable (_tmp663_);
						_tmp665_ = _tmp664_;
						_tmp659_ = !_tmp665_;
					} else {
						_tmp659_ = FALSE;
					}
					if (_tmp659_) {
						ValaDataType* _tmp666_;
						_tmp666_ = type_arg;
						_tmp658_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp666_, VALA_TYPE_POINTER_TYPE);
					} else {
						_tmp658_ = FALSE;
					}
					if (_tmp658_) {
						ValaDataType* _tmp667_;
						ValaPointerType* _tmp668_;
						_tmp667_ = type_arg;
						_tmp668_ = vala_pointer_type_new (_tmp667_, NULL);
						_vala_code_node_unref0 (type_arg);
						type_arg = (ValaDataType*) _tmp668_;
					}
					_tmp669_ = in_arg_map;
					_tmp670_ = m;
					_tmp671_ = type_param_index;
					_tmp672_ = type_arg;
					_tmp673_ = vala_get_ccode_name ((ValaCodeNode*) _tmp672_);
					_tmp674_ = _tmp673_;
					_tmp675_ = vala_ccode_identifier_new (_tmp674_);
					_tmp676_ = _tmp675_;
					vala_map_set ((ValaMap*) _tmp669_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp670_) + (0.01 * _tmp671_), FALSE)), (ValaCCodeExpression*) _tmp676_);
					_vala_ccode_node_unref0 (_tmp676_);
					_g_free0 (_tmp674_);
					_tmp677_ = type_param_index;
					type_param_index = _tmp677_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp678_;
				ValaExpression* _tmp679_;
				ValaExpression* _tmp680_;
				ValaDataType* _tmp681_;
				ValaDataType* _tmp682_;
				ValaList* _tmp683_;
				gint _type_arg_size = 0;
				ValaList* _tmp684_;
				gint _tmp685_;
				gint _tmp686_;
				gint _type_arg_index = 0;
				_tmp678_ = ma;
				_tmp679_ = vala_member_access_get_inner (_tmp678_);
				_tmp680_ = _tmp679_;
				_tmp681_ = vala_expression_get_value_type (_tmp680_);
				_tmp682_ = _tmp681_;
				_tmp683_ = vala_data_type_get_type_arguments (_tmp682_);
				_type_arg_list = _tmp683_;
				_tmp684_ = _type_arg_list;
				_tmp685_ = vala_collection_get_size ((ValaCollection*) _tmp684_);
				_tmp686_ = _tmp685_;
				_type_arg_size = _tmp686_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp687_;
					gint _tmp688_;
					gint _tmp689_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp690_;
					gint _tmp691_;
					gpointer _tmp692_;
					ValaHashMap* _tmp693_;
					ValaMethod* _tmp694_;
					gint _tmp695_;
					ValaDataType* _tmp696_;
					gchar* _tmp697_;
					gchar* _tmp698_;
					ValaCCodeIdentifier* _tmp699_;
					ValaCCodeIdentifier* _tmp700_;
					gint _tmp701_;
					_tmp687_ = _type_arg_index;
					_type_arg_index = _tmp687_ + 1;
					_tmp688_ = _type_arg_index;
					_tmp689_ = _type_arg_size;
					if (!(_tmp688_ < _tmp689_)) {
						break;
					}
					_tmp690_ = _type_arg_list;
					_tmp691_ = _type_arg_index;
					_tmp692_ = vala_list_get (_tmp690_, _tmp691_);
					type_arg = (ValaDataType*) _tmp692_;
					_tmp693_ = in_arg_map;
					_tmp694_ = m;
					_tmp695_ = type_param_index;
					_tmp696_ = type_arg;
					_tmp697_ = vala_get_ccode_name ((ValaCodeNode*) _tmp696_);
					_tmp698_ = _tmp697_;
					_tmp699_ = vala_ccode_identifier_new (_tmp698_);
					_tmp700_ = _tmp699_;
					vala_map_set ((ValaMap*) _tmp693_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp694_) + (0.01 * _tmp695_), FALSE)), (ValaCCodeExpression*) _tmp700_);
					_vala_ccode_node_unref0 (_tmp700_);
					_g_free0 (_tmp698_);
					_tmp701_ = type_param_index;
					type_param_index = _tmp701_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp702_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp702_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp703_;
		ValaExpression* _tmp704_;
		ValaExpression* _tmp705_;
		ValaDataType* _tmp706_;
		ValaDataType* _tmp707_;
		ValaArrayType* _tmp708_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp709_;
		ValaCCodeIdentifier* _tmp710_;
		ValaCCodeFunctionCall* _tmp711_;
		ValaCCodeFunctionCall* _tmp712_;
		ValaCCodeFunctionCall* _tmp713_;
		ValaArrayType* _tmp714_;
		ValaDataType* _tmp715_;
		ValaDataType* _tmp716_;
		gchar* _tmp717_;
		gchar* _tmp718_;
		ValaCCodeIdentifier* _tmp719_;
		ValaCCodeIdentifier* _tmp720_;
		ValaHashMap* _tmp721_;
		ValaCCodeFunctionCall* _tmp722_;
		_tmp703_ = ma;
		_tmp704_ = vala_member_access_get_inner (_tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_expression_get_value_type (_tmp705_);
		_tmp707_ = _tmp706_;
		_tmp708_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp707_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp708_;
		_tmp709_ = vala_ccode_identifier_new ("sizeof");
		_tmp710_ = _tmp709_;
		_tmp711_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp710_);
		_tmp712_ = _tmp711_;
		_vala_ccode_node_unref0 (_tmp710_);
		csizeof = _tmp712_;
		_tmp713_ = csizeof;
		_tmp714_ = array_type;
		_tmp715_ = vala_array_type_get_element_type (_tmp714_);
		_tmp716_ = _tmp715_;
		_tmp717_ = vala_get_ccode_name ((ValaCodeNode*) _tmp716_);
		_tmp718_ = _tmp717_;
		_tmp719_ = vala_ccode_identifier_new (_tmp718_);
		_tmp720_ = _tmp719_;
		vala_ccode_function_call_add_argument (_tmp713_, (ValaCCodeExpression*) _tmp720_);
		_vala_ccode_node_unref0 (_tmp720_);
		_g_free0 (_tmp718_);
		_tmp721_ = in_arg_map;
		_tmp722_ = csizeof;
		vala_map_set ((ValaMap*) _tmp721_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp722_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp723_;
		_tmp723_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp723_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp724_;
			gint param_nr = 0;
			ValaMethod* _tmp795_;
			_tmp724_ = m;
			vala_method_clear_parameters (_tmp724_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp725_;
				gint _arg_size = 0;
				ValaList* _tmp726_;
				gint _tmp727_;
				gint _tmp728_;
				gint _arg_index = 0;
				_tmp725_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp725_;
				_tmp726_ = _arg_list;
				_tmp727_ = vala_collection_get_size ((ValaCollection*) _tmp726_);
				_tmp728_ = _tmp727_;
				_arg_size = _tmp728_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp729_;
					gint _tmp730_;
					gint _tmp731_;
					ValaExpression* arg = NULL;
					ValaList* _tmp732_;
					gint _tmp733_;
					gpointer _tmp734_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp735_;
					ValaUnaryExpression* _tmp736_;
					gboolean _tmp737_ = FALSE;
					ValaUnaryExpression* _tmp738_;
					gint _tmp782_;
					_tmp729_ = _arg_index;
					_arg_index = _tmp729_ + 1;
					_tmp730_ = _arg_index;
					_tmp731_ = _arg_size;
					if (!(_tmp730_ < _tmp731_)) {
						break;
					}
					_tmp732_ = _arg_list;
					_tmp733_ = _arg_index;
					_tmp734_ = vala_list_get (_tmp732_, _tmp733_);
					arg = (ValaExpression*) _tmp734_;
					_tmp735_ = arg;
					_tmp736_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp735_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp735_) : NULL);
					unary = _tmp736_;
					_tmp738_ = unary;
					if (_tmp738_ != NULL) {
						ValaUnaryExpression* _tmp739_;
						ValaUnaryOperator _tmp740_;
						ValaUnaryOperator _tmp741_;
						_tmp739_ = unary;
						_tmp740_ = vala_unary_expression_get_operator (_tmp739_);
						_tmp741_ = _tmp740_;
						_tmp737_ = _tmp741_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp737_ = FALSE;
					}
					if (_tmp737_) {
						ValaParameter* param = NULL;
						gint _tmp742_;
						gchar* _tmp743_;
						gchar* _tmp744_;
						ValaUnaryExpression* _tmp745_;
						ValaExpression* _tmp746_;
						ValaExpression* _tmp747_;
						ValaDataType* _tmp748_;
						ValaDataType* _tmp749_;
						ValaParameter* _tmp750_;
						ValaParameter* _tmp751_;
						ValaParameter* _tmp752_;
						ValaMethod* _tmp753_;
						ValaParameter* _tmp754_;
						_tmp742_ = param_nr;
						_tmp743_ = g_strdup_printf ("param%d", _tmp742_);
						_tmp744_ = _tmp743_;
						_tmp745_ = unary;
						_tmp746_ = vala_unary_expression_get_inner (_tmp745_);
						_tmp747_ = _tmp746_;
						_tmp748_ = vala_expression_get_value_type (_tmp747_);
						_tmp749_ = _tmp748_;
						_tmp750_ = vala_parameter_new (_tmp744_, _tmp749_, NULL);
						_tmp751_ = _tmp750_;
						_g_free0 (_tmp744_);
						param = _tmp751_;
						_tmp752_ = param;
						vala_parameter_set_direction (_tmp752_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp753_ = m;
						_tmp754_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp753_, _tmp754_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp755_ = FALSE;
						ValaUnaryExpression* _tmp756_;
						_tmp756_ = unary;
						if (_tmp756_ != NULL) {
							ValaUnaryExpression* _tmp757_;
							ValaUnaryOperator _tmp758_;
							ValaUnaryOperator _tmp759_;
							_tmp757_ = unary;
							_tmp758_ = vala_unary_expression_get_operator (_tmp757_);
							_tmp759_ = _tmp758_;
							_tmp755_ = _tmp759_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp755_ = FALSE;
						}
						if (_tmp755_) {
							ValaParameter* param = NULL;
							gint _tmp760_;
							gchar* _tmp761_;
							gchar* _tmp762_;
							ValaUnaryExpression* _tmp763_;
							ValaExpression* _tmp764_;
							ValaExpression* _tmp765_;
							ValaDataType* _tmp766_;
							ValaDataType* _tmp767_;
							ValaParameter* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							ValaMethod* _tmp771_;
							ValaParameter* _tmp772_;
							_tmp760_ = param_nr;
							_tmp761_ = g_strdup_printf ("param%d", _tmp760_);
							_tmp762_ = _tmp761_;
							_tmp763_ = unary;
							_tmp764_ = vala_unary_expression_get_inner (_tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = vala_expression_get_value_type (_tmp765_);
							_tmp767_ = _tmp766_;
							_tmp768_ = vala_parameter_new (_tmp762_, _tmp767_, NULL);
							_tmp769_ = _tmp768_;
							_g_free0 (_tmp762_);
							param = _tmp769_;
							_tmp770_ = param;
							vala_parameter_set_direction (_tmp770_, VALA_PARAMETER_DIRECTION_REF);
							_tmp771_ = m;
							_tmp772_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp771_, _tmp772_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp773_;
							gint _tmp774_;
							gchar* _tmp775_;
							gchar* _tmp776_;
							ValaExpression* _tmp777_;
							ValaDataType* _tmp778_;
							ValaDataType* _tmp779_;
							ValaParameter* _tmp780_;
							ValaParameter* _tmp781_;
							_tmp773_ = m;
							_tmp774_ = param_nr;
							_tmp775_ = g_strdup_printf ("param%d", _tmp774_);
							_tmp776_ = _tmp775_;
							_tmp777_ = arg;
							_tmp778_ = vala_expression_get_value_type (_tmp777_);
							_tmp779_ = _tmp778_;
							_tmp780_ = vala_parameter_new (_tmp776_, _tmp779_, NULL);
							_tmp781_ = _tmp780_;
							vala_callable_add_parameter ((ValaCallable*) _tmp773_, _tmp781_);
							_vala_code_node_unref0 (_tmp781_);
							_g_free0 (_tmp776_);
						}
					}
					_tmp782_ = param_nr;
					param_nr = _tmp782_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp783_;
				ValaList* _tmp784_;
				gint _param_size = 0;
				ValaList* _tmp785_;
				gint _tmp786_;
				gint _tmp787_;
				gint _param_index = 0;
				_tmp783_ = m;
				_tmp784_ = vala_callable_get_parameters ((ValaCallable*) _tmp783_);
				_param_list = _tmp784_;
				_tmp785_ = _param_list;
				_tmp786_ = vala_collection_get_size ((ValaCollection*) _tmp785_);
				_tmp787_ = _tmp786_;
				_param_size = _tmp787_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp788_;
					gint _tmp789_;
					gint _tmp790_;
					ValaParameter* param = NULL;
					ValaList* _tmp791_;
					gint _tmp792_;
					gpointer _tmp793_;
					ValaParameter* _tmp794_;
					_tmp788_ = _param_index;
					_param_index = _tmp788_ + 1;
					_tmp789_ = _param_index;
					_tmp790_ = _param_size;
					if (!(_tmp789_ < _tmp790_)) {
						break;
					}
					_tmp791_ = _param_list;
					_tmp792_ = _param_index;
					_tmp793_ = vala_list_get (_tmp791_, _tmp792_);
					param = (ValaParameter*) _tmp793_;
					_tmp794_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp794_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp795_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp795_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp796_ = FALSE;
			ValaMethod* _tmp797_;
			_tmp797_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp797_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp798_;
				ValaSymbol* _tmp799_;
				ValaSymbol* _tmp800_;
				_tmp798_ = m;
				_tmp799_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp798_);
				_tmp800_ = _tmp799_;
				_tmp796_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp800_, VALA_TYPE_CLASS);
			} else {
				_tmp796_ = FALSE;
			}
			if (_tmp796_) {
				ValaCCodeFunction* _tmp801_;
				ValaCCodeFunction* _tmp802_;
				ValaCCodeExpression* _tmp803_;
				ValaCCodeExpression* _tmp804_;
				ValaCCodeFunctionCall* _tmp805_;
				ValaClass* _tmp806_;
				ValaClass* _tmp807_;
				gchar* _tmp808_;
				gchar* _tmp809_;
				gchar* _tmp810_;
				gchar* _tmp811_;
				ValaCCodeCastExpression* _tmp812_;
				ValaCCodeCastExpression* _tmp813_;
				ValaMethod* _tmp814_;
				ValaMethod* _tmp815_;
				ValaBlock* _tmp816_;
				ValaBlock* _tmp817_;
				gboolean _tmp818_;
				gboolean _tmp819_;
				gboolean _tmp846_ = FALSE;
				ValaClass* _tmp847_;
				ValaClass* _tmp848_;
				gboolean _tmp849_;
				gboolean _tmp850_;
				_tmp801_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp802_ = _tmp801_;
				_tmp803_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp804_ = _tmp803_;
				_tmp805_ = ccall;
				_tmp806_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp807_ = _tmp806_;
				_tmp808_ = vala_get_ccode_name ((ValaCodeNode*) _tmp807_);
				_tmp809_ = _tmp808_;
				_tmp810_ = g_strconcat (_tmp809_, "*", NULL);
				_tmp811_ = _tmp810_;
				_tmp812_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp805_, _tmp811_);
				_tmp813_ = _tmp812_;
				vala_ccode_function_add_assignment (_tmp802_, _tmp804_, (ValaCCodeExpression*) _tmp813_);
				_vala_ccode_node_unref0 (_tmp813_);
				_g_free0 (_tmp811_);
				_g_free0 (_tmp809_);
				_vala_ccode_node_unref0 (_tmp804_);
				_tmp814_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp815_ = _tmp814_;
				_tmp816_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp815_);
				_tmp817_ = _tmp816_;
				_tmp818_ = vala_block_get_captured (_tmp817_);
				_tmp819_ = _tmp818_;
				if (_tmp819_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp820_;
					ValaClass* _tmp821_;
					ValaObjectType* _tmp822_;
					ValaObjectType* _tmp823_;
					ValaSourceReference* _tmp824_;
					ValaSourceReference* _tmp825_;
					ValaCCodeExpression* _tmp826_;
					ValaCCodeExpression* _tmp827_;
					ValaCCodeFunctionCall* _tmp828_;
					ValaCCodeFunctionCall* _tmp829_;
					ValaCCodeFunctionCall* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeExpression* _tmp832_;
					ValaCCodeFunction* _tmp833_;
					ValaCCodeFunction* _tmp834_;
					ValaMethod* _tmp835_;
					ValaMethod* _tmp836_;
					ValaBlock* _tmp837_;
					ValaBlock* _tmp838_;
					gchar* _tmp839_;
					gchar* _tmp840_;
					ValaCCodeExpression* _tmp841_;
					ValaCCodeExpression* _tmp842_;
					ValaCCodeMemberAccess* _tmp843_;
					ValaCCodeMemberAccess* _tmp844_;
					ValaCCodeFunctionCall* _tmp845_;
					_tmp820_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp821_ = _tmp820_;
					_tmp822_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp821_);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp823_, _tmp825_, FALSE);
					_tmp827_ = _tmp826_;
					_tmp828_ = vala_ccode_function_call_new (_tmp827_);
					_tmp829_ = _tmp828_;
					_vala_ccode_node_unref0 (_tmp827_);
					_vala_code_node_unref0 (_tmp823_);
					ref_call = _tmp829_;
					_tmp830_ = ref_call;
					_tmp831_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp832_ = _tmp831_;
					vala_ccode_function_call_add_argument (_tmp830_, _tmp832_);
					_vala_ccode_node_unref0 (_tmp832_);
					_tmp833_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp834_ = _tmp833_;
					_tmp835_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp836_ = _tmp835_;
					_tmp837_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp836_);
					_tmp838_ = _tmp837_;
					_tmp839_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp838_));
					_tmp840_ = _tmp839_;
					_tmp841_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp840_);
					_tmp842_ = _tmp841_;
					_tmp843_ = vala_ccode_member_access_new_pointer (_tmp842_, "self");
					_tmp844_ = _tmp843_;
					_tmp845_ = ref_call;
					vala_ccode_function_add_assignment (_tmp834_, (ValaCCodeExpression*) _tmp844_, (ValaCCodeExpression*) _tmp845_);
					_vala_ccode_node_unref0 (_tmp844_);
					_vala_ccode_node_unref0 (_tmp842_);
					_g_free0 (_tmp840_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp847_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp848_ = _tmp847_;
				_tmp849_ = vala_class_get_is_compact (_tmp848_);
				_tmp850_ = _tmp849_;
				if (!_tmp850_) {
					ValaClass* _tmp851_;
					ValaClass* _tmp852_;
					ValaList* _tmp853_;
					ValaList* _tmp854_;
					gint _tmp855_;
					gint _tmp856_;
					_tmp851_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp852_ = _tmp851_;
					_tmp853_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp852_);
					_tmp854_ = _tmp853_;
					_tmp855_ = vala_collection_get_size ((ValaCollection*) _tmp854_);
					_tmp856_ = _tmp855_;
					_tmp846_ = _tmp856_ > 0;
					_vala_iterable_unref0 (_tmp854_);
				} else {
					_tmp846_ = FALSE;
				}
				if (_tmp846_) {
					gchar** suffices = NULL;
					gchar* _tmp857_;
					gchar* _tmp858_;
					gchar* _tmp859_;
					gchar** _tmp860_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp857_ = g_strdup ("type");
					_tmp858_ = g_strdup ("dup_func");
					_tmp859_ = g_strdup ("destroy_func");
					_tmp860_ = g_new0 (gchar*, 3 + 1);
					_tmp860_[0] = _tmp857_;
					_tmp860_[1] = _tmp858_;
					_tmp860_[2] = _tmp859_;
					suffices = _tmp860_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp861_;
						ValaClass* _tmp862_;
						ValaList* _tmp863_;
						gint _type_param_size = 0;
						ValaList* _tmp864_;
						gint _tmp865_;
						gint _tmp866_;
						gint _type_param_index = 0;
						_tmp861_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp862_ = _tmp861_;
						_tmp863_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp862_);
						_type_param_list = _tmp863_;
						_tmp864_ = _type_param_list;
						_tmp865_ = vala_collection_get_size ((ValaCollection*) _tmp864_);
						_tmp866_ = _tmp865_;
						_type_param_size = _tmp866_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp867_;
							gint _tmp868_;
							gint _tmp869_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp870_;
							gint _tmp871_;
							gpointer _tmp872_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp873_;
							ValaCCodeIdentifier* _tmp874_;
							ValaCCodeMemberAccess* _tmp875_;
							ValaCCodeMemberAccess* _tmp876_;
							gchar** _tmp877_;
							gint _tmp877__length1;
							_tmp867_ = _type_param_index;
							_type_param_index = _tmp867_ + 1;
							_tmp868_ = _type_param_index;
							_tmp869_ = _type_param_size;
							if (!(_tmp868_ < _tmp869_)) {
								break;
							}
							_tmp870_ = _type_param_list;
							_tmp871_ = _type_param_index;
							_tmp872_ = vala_list_get (_tmp870_, _tmp871_);
							type_param = (ValaTypeParameter*) _tmp872_;
							_tmp873_ = vala_ccode_identifier_new ("self");
							_tmp874_ = _tmp873_;
							_tmp875_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp874_, "priv");
							_tmp876_ = _tmp875_;
							_vala_ccode_node_unref0 (_tmp874_);
							priv_access = _tmp876_;
							_tmp877_ = suffices;
							_tmp877__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp877_;
								suffix_collection_length1 = _tmp877__length1;
								for (suffix_it = 0; suffix_it < suffix_collection_length1; suffix_it = suffix_it + 1) {
									gchar* _tmp878_;
									gchar* suffix = NULL;
									_tmp878_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp878_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp879_;
										const gchar* _tmp880_;
										const gchar* _tmp881_;
										gchar* _tmp882_;
										gchar* _tmp883_;
										const gchar* _tmp884_;
										gchar* _tmp885_;
										gchar* _tmp886_;
										ValaCCodeIdentifier* _tmp887_;
										ValaCCodeIdentifier* _tmp888_;
										ValaCCodeFunction* _tmp889_;
										ValaCCodeFunction* _tmp890_;
										ValaCCodeMemberAccess* _tmp891_;
										ValaCCodeIdentifier* _tmp892_;
										const gchar* _tmp893_;
										const gchar* _tmp894_;
										ValaCCodeMemberAccess* _tmp895_;
										ValaCCodeMemberAccess* _tmp896_;
										ValaCCodeIdentifier* _tmp897_;
										_tmp879_ = type_param;
										_tmp880_ = vala_symbol_get_name ((ValaSymbol*) _tmp879_);
										_tmp881_ = _tmp880_;
										_tmp882_ = g_utf8_strdown (_tmp881_, (gssize) -1);
										_tmp883_ = _tmp882_;
										_tmp884_ = suffix;
										_tmp885_ = g_strdup_printf ("%s_%s", _tmp883_, _tmp884_);
										_tmp886_ = _tmp885_;
										_tmp887_ = vala_ccode_identifier_new (_tmp886_);
										_tmp888_ = _tmp887_;
										_g_free0 (_tmp886_);
										_g_free0 (_tmp883_);
										param_name = _tmp888_;
										_tmp889_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp890_ = _tmp889_;
										_tmp891_ = priv_access;
										_tmp892_ = param_name;
										_tmp893_ = vala_ccode_identifier_get_name (_tmp892_);
										_tmp894_ = _tmp893_;
										_tmp895_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp891_, _tmp894_);
										_tmp896_ = _tmp895_;
										_tmp897_ = param_name;
										vala_ccode_function_add_assignment (_tmp890_, (ValaCCodeExpression*) _tmp896_, (ValaCCodeExpression*) _tmp897_);
										_vala_ccode_node_unref0 (_tmp896_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp898_ = params;
	_tmp899_ = vala_iterable_iterator ((ValaIterable*) _tmp898_);
	params_it = _tmp899_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp900_;
		gint _arg_size = 0;
		ValaList* _tmp901_;
		gint _tmp902_;
		gint _tmp903_;
		gint _arg_index = 0;
		_tmp900_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp900_;
		_tmp901_ = _arg_list;
		_tmp902_ = vala_collection_get_size ((ValaCollection*) _tmp901_);
		_tmp903_ = _tmp902_;
		_arg_size = _tmp903_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp904_;
			gint _tmp905_;
			gint _tmp906_;
			ValaExpression* arg = NULL;
			ValaList* _tmp907_;
			gint _tmp908_;
			gpointer _tmp909_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp910_;
			ValaCCodeExpression* _tmp911_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp912_;
			ValaHashMap* _tmp913_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp914_;
			gboolean _tmp924_ = FALSE;
			ValaParameter* _tmp925_;
			gdouble _tmp1263_ = 0.0;
			ValaParameter* _tmp1264_;
			gboolean _tmp1267_;
			ValaHashMap* _tmp1268_;
			gint _tmp1269_;
			ValaCCodeExpression* _tmp1270_;
			gboolean _tmp1271_ = FALSE;
			ValaExpression* _tmp1272_;
			gint _tmp1292_;
			_tmp904_ = _arg_index;
			_arg_index = _tmp904_ + 1;
			_tmp905_ = _arg_index;
			_tmp906_ = _arg_size;
			if (!(_tmp905_ < _tmp906_)) {
				break;
			}
			_tmp907_ = _arg_list;
			_tmp908_ = _arg_index;
			_tmp909_ = vala_list_get (_tmp907_, _tmp908_);
			arg = (ValaExpression*) _tmp909_;
			_tmp910_ = arg;
			_tmp911_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp910_);
			cexpr = _tmp911_;
			_tmp912_ = in_arg_map;
			_tmp913_ = _vala_map_ref0 (_tmp912_);
			carg_map = _tmp913_;
			param = NULL;
			_tmp914_ = params_it;
			if (vala_iterator_next (_tmp914_)) {
				ValaIterator* _tmp915_;
				gpointer _tmp916_;
				gboolean _tmp917_ = FALSE;
				ValaParameter* _tmp918_;
				gboolean _tmp919_;
				gboolean _tmp920_;
				_tmp915_ = params_it;
				_tmp916_ = vala_iterator_get (_tmp915_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp916_;
				_tmp918_ = param;
				_tmp919_ = vala_parameter_get_params_array (_tmp918_);
				_tmp920_ = _tmp919_;
				if (_tmp920_) {
					_tmp917_ = TRUE;
				} else {
					ValaParameter* _tmp921_;
					gboolean _tmp922_;
					gboolean _tmp923_;
					_tmp921_ = param;
					_tmp922_ = vala_parameter_get_ellipsis (_tmp921_);
					_tmp923_ = _tmp922_;
					_tmp917_ = _tmp923_;
				}
				ellipsis = _tmp917_;
			}
			_tmp925_ = param;
			if (_tmp925_ != NULL) {
				gboolean _tmp926_;
				_tmp926_ = ellipsis;
				_tmp924_ = !_tmp926_;
			} else {
				_tmp924_ = FALSE;
			}
			if (_tmp924_) {
				ValaParameter* _tmp927_;
				ValaParameterDirection _tmp928_;
				ValaParameterDirection _tmp929_;
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp932_;
				ValaUnaryExpression* _tmp933_;
				gboolean _tmp934_ = FALSE;
				ValaUnaryExpression* _tmp935_;
				ValaParameter* _tmp1213_;
				gchar* _tmp1214_;
				gchar* _tmp1215_;
				gboolean _tmp1216_;
				_tmp927_ = param;
				_tmp928_ = vala_parameter_get_direction (_tmp927_);
				_tmp929_ = _tmp928_;
				if (_tmp929_ == VALA_PARAMETER_DIRECTION_OUT) {
					ValaHashMap* _tmp930_;
					ValaHashMap* _tmp931_;
					_tmp930_ = out_arg_map;
					_tmp931_ = _vala_map_ref0 (_tmp930_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp931_;
				}
				_tmp932_ = arg;
				_tmp933_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp932_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp932_) : NULL);
				unary = _tmp933_;
				_tmp935_ = unary;
				if (_tmp935_ == NULL) {
					_tmp934_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp936_;
					ValaUnaryOperator _tmp937_;
					ValaUnaryOperator _tmp938_;
					_tmp936_ = unary;
					_tmp937_ = vala_unary_expression_get_operator (_tmp936_);
					_tmp938_ = _tmp937_;
					_tmp934_ = _tmp938_ != VALA_UNARY_OPERATOR_OUT;
				}
				if (_tmp934_) {
					gboolean _tmp939_ = FALSE;
					gboolean _tmp940_ = FALSE;
					ValaParameter* _tmp941_;
					ValaParameter* _tmp1083_;
					ValaExpression* _tmp1084_;
					ValaCCodeExpression* _tmp1085_;
					ValaCCodeExpression* _tmp1086_;
					_tmp941_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp941_)) {
						ValaParameter* _tmp942_;
						ValaDataType* _tmp943_;
						ValaDataType* _tmp944_;
						_tmp942_ = param;
						_tmp943_ = vala_variable_get_variable_type ((ValaVariable*) _tmp942_);
						_tmp944_ = _tmp943_;
						_tmp940_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp944_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp940_ = FALSE;
					}
					if (_tmp940_) {
						ValaParameter* _tmp945_;
						ValaDataType* _tmp946_;
						ValaDataType* _tmp947_;
						gboolean _tmp948_;
						gboolean _tmp949_;
						_tmp945_ = param;
						_tmp946_ = vala_variable_get_variable_type ((ValaVariable*) _tmp945_);
						_tmp947_ = _tmp946_;
						_tmp948_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp947_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp949_ = _tmp948_;
						_tmp939_ = !_tmp949_;
					} else {
						_tmp939_ = FALSE;
					}
					if (_tmp939_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp950_;
						ValaDataType* _tmp951_;
						ValaDataType* _tmp952_;
						ValaArrayType* _tmp953_;
						_tmp950_ = param;
						_tmp951_ = vala_variable_get_variable_type ((ValaVariable*) _tmp950_);
						_tmp952_ = _tmp951_;
						_tmp953_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp952_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp953_;
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp954_ = FALSE;
								_tmp954_ = TRUE;
								while (TRUE) {
									gint _tmp956_;
									ValaArrayType* _tmp957_;
									gint _tmp958_;
									gint _tmp959_;
									ValaCCodeExpression* array_length_expr = NULL;
									ValaParameter* _tmp960_;
									gchar* _tmp961_;
									gchar* _tmp962_;
									gboolean _tmp963_;
									ValaHashMap* _tmp982_;
									ValaParameter* _tmp983_;
									gint _tmp984_;
									ValaCCodeExpression* _tmp985_;
									if (!_tmp954_) {
										gint _tmp955_;
										_tmp955_ = dim;
										dim = _tmp955_ + 1;
									}
									_tmp954_ = FALSE;
									_tmp956_ = dim;
									_tmp957_ = array_type;
									_tmp958_ = vala_array_type_get_rank (_tmp957_);
									_tmp959_ = _tmp958_;
									if (!(_tmp956_ <= _tmp959_)) {
										break;
									}
									array_length_expr = NULL;
									_tmp960_ = param;
									_tmp961_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp960_);
									_tmp962_ = _tmp961_;
									_tmp963_ = _tmp962_ != NULL;
									_g_free0 (_tmp962_);
									if (_tmp963_) {
										gchar* length_ctype = NULL;
										ValaParameter* _tmp964_;
										gchar* _tmp965_;
										gboolean _tmp966_ = FALSE;
										ValaUnaryExpression* _tmp967_;
										ValaExpression* _tmp973_;
										gint _tmp974_;
										ValaCCodeExpression* _tmp975_;
										ValaCCodeExpression* _tmp976_;
										const gchar* _tmp977_;
										ValaCCodeCastExpression* _tmp978_;
										_tmp964_ = param;
										_tmp965_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp964_);
										length_ctype = _tmp965_;
										_tmp967_ = unary;
										if (_tmp967_ != NULL) {
											ValaUnaryExpression* _tmp968_;
											ValaUnaryOperator _tmp969_;
											ValaUnaryOperator _tmp970_;
											_tmp968_ = unary;
											_tmp969_ = vala_unary_expression_get_operator (_tmp968_);
											_tmp970_ = _tmp969_;
											_tmp966_ = _tmp970_ == VALA_UNARY_OPERATOR_REF;
										} else {
											_tmp966_ = FALSE;
										}
										if (_tmp966_) {
											const gchar* _tmp971_;
											gchar* _tmp972_;
											_tmp971_ = length_ctype;
											_tmp972_ = g_strdup_printf ("%s*", _tmp971_);
											_g_free0 (length_ctype);
											length_ctype = _tmp972_;
										}
										_tmp973_ = arg;
										_tmp974_ = dim;
										_tmp975_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp973_, _tmp974_);
										_tmp976_ = _tmp975_;
										_tmp977_ = length_ctype;
										_tmp978_ = vala_ccode_cast_expression_new (_tmp976_, _tmp977_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = (ValaCCodeExpression*) _tmp978_;
										_vala_ccode_node_unref0 (_tmp976_);
										_g_free0 (length_ctype);
									} else {
										ValaExpression* _tmp979_;
										gint _tmp980_;
										ValaCCodeExpression* _tmp981_;
										_tmp979_ = arg;
										_tmp980_ = dim;
										_tmp981_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp979_, _tmp980_);
										_vala_ccode_node_unref0 (array_length_expr);
										array_length_expr = _tmp981_;
									}
									_tmp982_ = carg_map;
									_tmp983_ = param;
									_tmp984_ = dim;
									_tmp985_ = array_length_expr;
									vala_map_set ((ValaMap*) _tmp982_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp983_) + (0.01 * _tmp984_), FALSE)), _tmp985_);
									_vala_ccode_node_unref0 (array_length_expr);
								}
							}
						}
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp986_;
						ValaDataType* _tmp987_;
						ValaDataType* _tmp988_;
						_tmp986_ = param;
						_tmp987_ = vala_variable_get_variable_type ((ValaVariable*) _tmp986_);
						_tmp988_ = _tmp987_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp988_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp989_;
							ValaDataType* _tmp990_;
							ValaDataType* _tmp991_;
							ValaDelegateType* _tmp992_;
							ValaDelegateType* _tmp993_;
							ValaDelegate* _tmp994_;
							ValaDelegate* _tmp995_;
							gboolean _tmp996_;
							gboolean _tmp997_;
							_tmp989_ = param;
							_tmp990_ = vala_variable_get_variable_type ((ValaVariable*) _tmp989_);
							_tmp991_ = _tmp990_;
							_tmp992_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp991_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp992_;
							_tmp993_ = deleg_type;
							_tmp994_ = vala_delegate_type_get_delegate_symbol (_tmp993_);
							_tmp995_ = _tmp994_;
							_tmp996_ = vala_delegate_get_has_target (_tmp995_);
							_tmp997_ = _tmp996_;
							if (_tmp997_) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaCCodeExpression* delegate_target = NULL;
								ValaExpression* _tmp998_;
								ValaCCodeExpression* _tmp999_ = NULL;
								ValaCCodeExpression* _tmp1000_;
								ValaCCodeExpression* _tmp1001_;
								ValaParameter* _tmp1002_;
								gchar* _tmp1003_;
								gchar* _tmp1004_;
								gboolean _tmp1005_;
								_tmp998_ = arg;
								_tmp1000_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp998_, &_tmp999_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp999_;
								delegate_target = _tmp1000_;
								_tmp1001_ = delegate_target;
								_vala_assert (_tmp1001_ != NULL, "delegate_target != null");
								_tmp1002_ = param;
								_tmp1003_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1002_);
								_tmp1004_ = _tmp1003_;
								_tmp1005_ = g_strcmp0 (_tmp1004_, "GClosure*") == 0;
								_g_free0 (_tmp1004_);
								if (_tmp1005_) {
									ValaCCodeFunctionCall* closure_new = NULL;
									ValaCCodeIdentifier* _tmp1006_;
									ValaCCodeIdentifier* _tmp1007_;
									ValaCCodeFunctionCall* _tmp1008_;
									ValaCCodeFunctionCall* _tmp1009_;
									ValaCCodeFunctionCall* _tmp1010_;
									ValaCCodeExpression* _tmp1011_;
									ValaCCodeCastExpression* _tmp1012_;
									ValaCCodeCastExpression* _tmp1013_;
									ValaCCodeFunctionCall* _tmp1014_;
									ValaCCodeExpression* _tmp1015_;
									ValaCCodeFunctionCall* _tmp1016_;
									ValaCCodeExpression* _tmp1017_;
									ValaCCodeCastExpression* _tmp1018_;
									ValaCCodeCastExpression* _tmp1019_;
									ValaCCodeExpression* _tmp1020_;
									ValaCCodeIdentifier* _tmp1021_;
									ValaCCodeIdentifier* _tmp1022_;
									ValaCCodeBinaryExpression* _tmp1023_;
									ValaCCodeBinaryExpression* _tmp1024_;
									ValaCCodeIdentifier* _tmp1025_;
									ValaCCodeIdentifier* _tmp1026_;
									ValaCCodeFunctionCall* _tmp1027_;
									ValaCCodeConditionalExpression* _tmp1028_;
									_tmp1006_ = vala_ccode_identifier_new ("g_cclosure_new");
									_tmp1007_ = _tmp1006_;
									_tmp1008_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1007_);
									_tmp1009_ = _tmp1008_;
									_vala_ccode_node_unref0 (_tmp1007_);
									closure_new = _tmp1009_;
									_tmp1010_ = closure_new;
									_tmp1011_ = cexpr;
									_tmp1012_ = vala_ccode_cast_expression_new (_tmp1011_, "GCallback");
									_tmp1013_ = _tmp1012_;
									vala_ccode_function_call_add_argument (_tmp1010_, (ValaCCodeExpression*) _tmp1013_);
									_vala_ccode_node_unref0 (_tmp1013_);
									_tmp1014_ = closure_new;
									_tmp1015_ = delegate_target;
									vala_ccode_function_call_add_argument (_tmp1014_, _tmp1015_);
									_tmp1016_ = closure_new;
									_tmp1017_ = delegate_target_destroy_notify;
									_tmp1018_ = vala_ccode_cast_expression_new (_tmp1017_, "GClosureNotify");
									_tmp1019_ = _tmp1018_;
									vala_ccode_function_call_add_argument (_tmp1016_, (ValaCCodeExpression*) _tmp1019_);
									_vala_ccode_node_unref0 (_tmp1019_);
									_tmp1020_ = cexpr;
									_tmp1021_ = vala_ccode_identifier_new ("NULL");
									_tmp1022_ = _tmp1021_;
									_tmp1023_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1020_, (ValaCCodeExpression*) _tmp1022_);
									_tmp1024_ = _tmp1023_;
									_tmp1025_ = vala_ccode_identifier_new ("NULL");
									_tmp1026_ = _tmp1025_;
									_tmp1027_ = closure_new;
									_tmp1028_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1024_, (ValaCCodeExpression*) _tmp1026_, (ValaCCodeExpression*) _tmp1027_);
									_vala_ccode_node_unref0 (cexpr);
									cexpr = (ValaCCodeExpression*) _tmp1028_;
									_vala_ccode_node_unref0 (_tmp1026_);
									_vala_ccode_node_unref0 (_tmp1024_);
									_vala_ccode_node_unref0 (_tmp1022_);
									_vala_ccode_node_unref0 (closure_new);
								} else {
									ValaHashMap* _tmp1029_;
									ValaParameter* _tmp1030_;
									ValaCCodeExpression* _tmp1031_;
									ValaDelegateType* _tmp1032_;
									_tmp1029_ = carg_map;
									_tmp1030_ = param;
									_tmp1031_ = delegate_target;
									vala_map_set ((ValaMap*) _tmp1029_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1030_), FALSE)), _tmp1031_);
									_tmp1032_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1032_)) {
										ValaCCodeExpression* _tmp1033_;
										ValaHashMap* _tmp1034_;
										ValaParameter* _tmp1035_;
										ValaCCodeExpression* _tmp1036_;
										_tmp1033_ = delegate_target_destroy_notify;
										_vala_assert (_tmp1033_ != NULL, "delegate_target_destroy_notify != null");
										_tmp1034_ = carg_map;
										_tmp1035_ = param;
										_tmp1036_ = delegate_target_destroy_notify;
										vala_map_set ((ValaMap*) _tmp1034_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1035_) + 0.01, FALSE)), _tmp1036_);
									}
								}
								_vala_ccode_node_unref0 (delegate_target);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							}
							_vala_code_node_unref0 (deleg_type);
						} else {
							ValaParameter* _tmp1037_;
							ValaDataType* _tmp1038_;
							ValaDataType* _tmp1039_;
							_tmp1037_ = param;
							_tmp1038_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1037_);
							_tmp1039_ = _tmp1038_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1039_, VALA_TYPE_METHOD_TYPE)) {
								ValaCCodeExpression* delegate_target_destroy_notify = NULL;
								ValaHashMap* _tmp1040_;
								ValaParameter* _tmp1041_;
								ValaExpression* _tmp1042_;
								ValaCCodeExpression* _tmp1043_ = NULL;
								ValaCCodeExpression* _tmp1044_;
								ValaCCodeExpression* _tmp1045_;
								_tmp1040_ = carg_map;
								_tmp1041_ = param;
								_tmp1042_ = arg;
								_tmp1044_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1042_, &_tmp1043_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								delegate_target_destroy_notify = _tmp1043_;
								_tmp1045_ = _tmp1044_;
								vala_map_set ((ValaMap*) _tmp1040_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1041_), FALSE)), _tmp1045_);
								_vala_ccode_node_unref0 (_tmp1045_);
								_vala_ccode_node_unref0 (delegate_target_destroy_notify);
							} else {
								ValaParameter* _tmp1046_;
								ValaDataType* _tmp1047_;
								ValaDataType* _tmp1048_;
								_tmp1046_ = param;
								_tmp1047_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1046_);
								_tmp1048_ = _tmp1047_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1048_, VALA_TYPE_GENERIC_TYPE)) {
									gboolean _tmp1049_ = FALSE;
									ValaMethod* _tmp1050_;
									_tmp1050_ = m;
									if (_tmp1050_ != NULL) {
										ValaMethod* _tmp1051_;
										_tmp1051_ = m;
										_tmp1049_ = vala_get_ccode_simple_generics (_tmp1051_);
									} else {
										_tmp1049_ = FALSE;
									}
									if (_tmp1049_) {
										ValaGenericType* generic_type = NULL;
										ValaParameter* _tmp1052_;
										ValaDataType* _tmp1053_;
										ValaDataType* _tmp1054_;
										ValaGenericType* _tmp1055_;
										gint type_param_index = 0;
										ValaMethod* _tmp1056_;
										ValaGenericType* _tmp1057_;
										ValaTypeParameter* _tmp1058_;
										ValaTypeParameter* _tmp1059_;
										const gchar* _tmp1060_;
										const gchar* _tmp1061_;
										ValaDataType* type_arg = NULL;
										ValaMemberAccess* _tmp1062_;
										ValaList* _tmp1063_;
										ValaList* _tmp1064_;
										gint _tmp1065_;
										gpointer _tmp1066_;
										ValaDataType* _tmp1067_;
										ValaParameter* _tmp1068_;
										ValaDataType* _tmp1069_;
										ValaDataType* _tmp1070_;
										gboolean _tmp1071_;
										gboolean _tmp1072_;
										_tmp1052_ = param;
										_tmp1053_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1052_);
										_tmp1054_ = _tmp1053_;
										_tmp1055_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1054_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
										generic_type = _tmp1055_;
										_tmp1056_ = m;
										_tmp1057_ = generic_type;
										_tmp1058_ = vala_generic_type_get_type_parameter (_tmp1057_);
										_tmp1059_ = _tmp1058_;
										_tmp1060_ = vala_symbol_get_name ((ValaSymbol*) _tmp1059_);
										_tmp1061_ = _tmp1060_;
										type_param_index = vala_method_get_type_parameter_index (_tmp1056_, _tmp1061_);
										_tmp1062_ = ma;
										_tmp1063_ = vala_member_access_get_type_arguments (_tmp1062_);
										_tmp1064_ = _tmp1063_;
										_tmp1065_ = type_param_index;
										_tmp1066_ = vala_list_get (_tmp1064_, _tmp1065_);
										_tmp1067_ = (ValaDataType*) _tmp1066_;
										_vala_iterable_unref0 (_tmp1064_);
										type_arg = _tmp1067_;
										_tmp1068_ = param;
										_tmp1069_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1068_);
										_tmp1070_ = _tmp1069_;
										_tmp1071_ = vala_data_type_get_value_owned (_tmp1070_);
										_tmp1072_ = _tmp1071_;
										if (_tmp1072_) {
											ValaDataType* _tmp1073_;
											_tmp1073_ = type_arg;
											if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1073_)) {
												ValaHashMap* _tmp1074_;
												ValaParameter* _tmp1075_;
												ValaDataType* _tmp1076_;
												ValaCCodeExpression* _tmp1077_;
												ValaCCodeExpression* _tmp1078_;
												_tmp1074_ = carg_map;
												_tmp1075_ = param;
												_tmp1076_ = type_arg;
												_tmp1077_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1076_, FALSE);
												_tmp1078_ = _tmp1077_;
												vala_map_set ((ValaMap*) _tmp1074_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1075_), FALSE)), _tmp1078_);
												_vala_ccode_node_unref0 (_tmp1078_);
											} else {
												ValaHashMap* _tmp1079_;
												ValaParameter* _tmp1080_;
												ValaCCodeConstant* _tmp1081_;
												ValaCCodeConstant* _tmp1082_;
												_tmp1079_ = carg_map;
												_tmp1080_ = param;
												_tmp1081_ = vala_ccode_constant_new ("NULL");
												_tmp1082_ = _tmp1081_;
												vala_map_set ((ValaMap*) _tmp1079_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1080_), FALSE)), (ValaCCodeExpression*) _tmp1082_);
												_vala_ccode_node_unref0 (_tmp1082_);
											}
										}
										_vala_code_node_unref0 (type_arg);
										_vala_code_node_unref0 (generic_type);
									}
								}
							}
						}
					}
					_tmp1083_ = param;
					_tmp1084_ = arg;
					_tmp1085_ = cexpr;
					_tmp1086_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1083_, _tmp1084_, _tmp1085_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1086_;
				} else {
					ValaExpression* _tmp1087_;
					ValaLocalVariable* temp_var = NULL;
					ValaParameter* _tmp1088_;
					ValaDataType* _tmp1089_;
					ValaDataType* _tmp1090_;
					ValaParameter* _tmp1091_;
					ValaDataType* _tmp1092_;
					ValaDataType* _tmp1093_;
					gboolean _tmp1094_;
					gboolean _tmp1095_;
					ValaLocalVariable* _tmp1096_;
					ValaLocalVariable* _tmp1097_;
					ValaExpression* _tmp1098_;
					ValaLocalVariable* _tmp1099_;
					const gchar* _tmp1100_;
					const gchar* _tmp1101_;
					ValaCCodeExpression* _tmp1102_;
					ValaCCodeExpression* _tmp1103_;
					ValaExpression* _tmp1104_;
					ValaTargetValue* _tmp1105_;
					ValaTargetValue* _tmp1106_;
					ValaExpression* _tmp1107_;
					ValaDataType* _tmp1108_;
					ValaDataType* _tmp1109_;
					ValaExpression* _tmp1110_;
					ValaCCodeExpression* _tmp1111_;
					ValaCCodeExpression* _tmp1112_;
					ValaCCodeUnaryExpression* _tmp1113_;
					gboolean _tmp1114_ = FALSE;
					gboolean _tmp1115_ = FALSE;
					ValaParameter* _tmp1116_;
					_tmp1087_ = arg;
					vala_expression_set_target_value (_tmp1087_, NULL);
					_tmp1088_ = param;
					_tmp1089_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1088_);
					_tmp1090_ = _tmp1089_;
					_tmp1091_ = param;
					_tmp1092_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1091_);
					_tmp1093_ = _tmp1092_;
					_tmp1094_ = vala_data_type_get_value_owned (_tmp1093_);
					_tmp1095_ = _tmp1094_;
					_tmp1096_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1090_, _tmp1095_, NULL, TRUE);
					temp_var = _tmp1096_;
					_tmp1097_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1097_, FALSE);
					_tmp1098_ = arg;
					_tmp1099_ = temp_var;
					_tmp1100_ = vala_symbol_get_name ((ValaSymbol*) _tmp1099_);
					_tmp1101_ = _tmp1100_;
					_tmp1102_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1101_);
					_tmp1103_ = _tmp1102_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1098_, _tmp1103_);
					_vala_ccode_node_unref0 (_tmp1103_);
					_tmp1104_ = arg;
					_tmp1105_ = vala_expression_get_target_value (_tmp1104_);
					_tmp1106_ = _tmp1105_;
					_tmp1107_ = arg;
					_tmp1108_ = vala_expression_get_target_type (_tmp1107_);
					_tmp1109_ = _tmp1108_;
					vala_target_value_set_value_type (_tmp1106_, _tmp1109_);
					_tmp1110_ = arg;
					_tmp1111_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1110_);
					_tmp1112_ = _tmp1111_;
					_tmp1113_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1112_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1113_;
					_vala_ccode_node_unref0 (_tmp1112_);
					_tmp1116_ = param;
					if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1116_)) {
						ValaParameter* _tmp1117_;
						ValaDataType* _tmp1118_;
						ValaDataType* _tmp1119_;
						_tmp1117_ = param;
						_tmp1118_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1117_);
						_tmp1119_ = _tmp1118_;
						_tmp1115_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1119_, VALA_TYPE_ARRAY_TYPE);
					} else {
						_tmp1115_ = FALSE;
					}
					if (_tmp1115_) {
						ValaParameter* _tmp1120_;
						ValaDataType* _tmp1121_;
						ValaDataType* _tmp1122_;
						gboolean _tmp1123_;
						gboolean _tmp1124_;
						_tmp1120_ = param;
						_tmp1121_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1120_);
						_tmp1122_ = _tmp1121_;
						_tmp1123_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1122_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						_tmp1124_ = _tmp1123_;
						_tmp1114_ = !_tmp1124_;
					} else {
						_tmp1114_ = FALSE;
					}
					if (_tmp1114_) {
						ValaArrayType* array_type = NULL;
						ValaParameter* _tmp1125_;
						ValaDataType* _tmp1126_;
						ValaDataType* _tmp1127_;
						ValaArrayType* _tmp1128_;
						ValaDataType* array_length_type = NULL;
						ValaDataType* _tmp1129_;
						ValaDataType* _tmp1130_;
						ValaParameter* _tmp1131_;
						gchar* _tmp1132_;
						gchar* _tmp1133_;
						gboolean _tmp1134_;
						_tmp1125_ = param;
						_tmp1126_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1125_);
						_tmp1127_ = _tmp1126_;
						_tmp1128_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1127_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
						array_type = _tmp1128_;
						_tmp1129_ = ((ValaCCodeBaseModule*) self)->int_type;
						_tmp1130_ = _vala_code_node_ref0 (_tmp1129_);
						array_length_type = _tmp1130_;
						_tmp1131_ = param;
						_tmp1132_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1131_);
						_tmp1133_ = _tmp1132_;
						_tmp1134_ = _tmp1133_ != NULL;
						_g_free0 (_tmp1133_);
						if (_tmp1134_) {
							ValaParameter* _tmp1135_;
							gchar* _tmp1136_;
							gchar* _tmp1137_;
							ValaCType* _tmp1138_;
							_tmp1135_ = param;
							_tmp1136_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1135_);
							_tmp1137_ = _tmp1136_;
							_tmp1138_ = vala_ctype_new (_tmp1137_, "0");
							_vala_code_node_unref0 (array_length_type);
							array_length_type = (ValaDataType*) _tmp1138_;
							_g_free0 (_tmp1137_);
						}
						{
							gint dim = 0;
							dim = 1;
							{
								gboolean _tmp1139_ = FALSE;
								_tmp1139_ = TRUE;
								while (TRUE) {
									gint _tmp1141_;
									ValaArrayType* _tmp1142_;
									gint _tmp1143_;
									gint _tmp1144_;
									ValaLocalVariable* temp_array_length = NULL;
									ValaDataType* _tmp1145_;
									ValaLocalVariable* _tmp1146_;
									ValaLocalVariable* _tmp1147_;
									ValaExpression* _tmp1148_;
									ValaLocalVariable* _tmp1149_;
									const gchar* _tmp1150_;
									const gchar* _tmp1151_;
									ValaCCodeExpression* _tmp1152_;
									ValaCCodeExpression* _tmp1153_;
									ValaHashMap* _tmp1154_;
									ValaParameter* _tmp1155_;
									gint _tmp1156_;
									ValaExpression* _tmp1157_;
									ValaList* _tmp1158_;
									ValaList* _tmp1159_;
									gint _tmp1160_;
									gpointer _tmp1161_;
									ValaCCodeExpression* _tmp1162_;
									ValaCCodeUnaryExpression* _tmp1163_;
									ValaCCodeUnaryExpression* _tmp1164_;
									if (!_tmp1139_) {
										gint _tmp1140_;
										_tmp1140_ = dim;
										dim = _tmp1140_ + 1;
									}
									_tmp1139_ = FALSE;
									_tmp1141_ = dim;
									_tmp1142_ = array_type;
									_tmp1143_ = vala_array_type_get_rank (_tmp1142_);
									_tmp1144_ = _tmp1143_;
									if (!(_tmp1141_ <= _tmp1144_)) {
										break;
									}
									_tmp1145_ = array_length_type;
									_tmp1146_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1145_, TRUE, NULL, FALSE);
									temp_array_length = _tmp1146_;
									_tmp1147_ = temp_array_length;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1147_, FALSE);
									_tmp1148_ = arg;
									_tmp1149_ = temp_array_length;
									_tmp1150_ = vala_symbol_get_name ((ValaSymbol*) _tmp1149_);
									_tmp1151_ = _tmp1150_;
									_tmp1152_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1151_);
									_tmp1153_ = _tmp1152_;
									vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1148_, _tmp1153_);
									_vala_ccode_node_unref0 (_tmp1153_);
									_tmp1154_ = carg_map;
									_tmp1155_ = param;
									_tmp1156_ = dim;
									_tmp1157_ = arg;
									_tmp1158_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1157_);
									_tmp1159_ = _tmp1158_;
									_tmp1160_ = dim;
									_tmp1161_ = vala_list_get (_tmp1159_, _tmp1160_ - 1);
									_tmp1162_ = (ValaCCodeExpression*) _tmp1161_;
									_tmp1163_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1162_);
									_tmp1164_ = _tmp1163_;
									vala_map_set ((ValaMap*) _tmp1154_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1155_) + (0.01 * _tmp1156_), FALSE)), (ValaCCodeExpression*) _tmp1164_);
									_vala_ccode_node_unref0 (_tmp1164_);
									_vala_ccode_node_unref0 (_tmp1162_);
									_vala_iterable_unref0 (_tmp1159_);
									_vala_code_node_unref0 (temp_array_length);
								}
							}
						}
						_vala_code_node_unref0 (array_length_type);
						_vala_code_node_unref0 (array_type);
					} else {
						ValaParameter* _tmp1165_;
						ValaDataType* _tmp1166_;
						ValaDataType* _tmp1167_;
						_tmp1165_ = param;
						_tmp1166_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1165_);
						_tmp1167_ = _tmp1166_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1167_, VALA_TYPE_DELEGATE_TYPE)) {
							ValaDelegateType* deleg_type = NULL;
							ValaParameter* _tmp1168_;
							ValaDataType* _tmp1169_;
							ValaDataType* _tmp1170_;
							ValaDelegateType* _tmp1171_;
							ValaDelegateType* _tmp1172_;
							ValaDelegate* _tmp1173_;
							ValaDelegate* _tmp1174_;
							gboolean _tmp1175_;
							gboolean _tmp1176_;
							_tmp1168_ = param;
							_tmp1169_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1168_);
							_tmp1170_ = _tmp1169_;
							_tmp1171_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1170_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
							deleg_type = _tmp1171_;
							_tmp1172_ = deleg_type;
							_tmp1173_ = vala_delegate_type_get_delegate_symbol (_tmp1172_);
							_tmp1174_ = _tmp1173_;
							_tmp1175_ = vala_delegate_get_has_target (_tmp1174_);
							_tmp1176_ = _tmp1175_;
							if (_tmp1176_) {
								ValaVoidType* _tmp1177_;
								ValaVoidType* _tmp1178_;
								ValaPointerType* _tmp1179_;
								ValaPointerType* _tmp1180_;
								ValaLocalVariable* _tmp1181_;
								ValaLocalVariable* _tmp1182_;
								ValaExpression* _tmp1183_;
								ValaLocalVariable* _tmp1184_;
								const gchar* _tmp1185_;
								const gchar* _tmp1186_;
								ValaCCodeExpression* _tmp1187_;
								ValaCCodeExpression* _tmp1188_;
								ValaHashMap* _tmp1189_;
								ValaParameter* _tmp1190_;
								ValaExpression* _tmp1191_;
								ValaCCodeExpression* _tmp1192_;
								ValaCCodeExpression* _tmp1193_;
								ValaCCodeUnaryExpression* _tmp1194_;
								ValaCCodeUnaryExpression* _tmp1195_;
								ValaDelegateType* _tmp1196_;
								_tmp1177_ = vala_void_type_new (NULL);
								_tmp1178_ = _tmp1177_;
								_tmp1179_ = vala_pointer_type_new ((ValaDataType*) _tmp1178_, NULL);
								_tmp1180_ = _tmp1179_;
								_tmp1181_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1180_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1181_;
								_vala_code_node_unref0 (_tmp1180_);
								_vala_code_node_unref0 (_tmp1178_);
								_tmp1182_ = temp_var;
								vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1182_, FALSE);
								_tmp1183_ = arg;
								_tmp1184_ = temp_var;
								_tmp1185_ = vala_symbol_get_name ((ValaSymbol*) _tmp1184_);
								_tmp1186_ = _tmp1185_;
								_tmp1187_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1186_);
								_tmp1188_ = _tmp1187_;
								vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1183_, _tmp1188_);
								_vala_ccode_node_unref0 (_tmp1188_);
								_tmp1189_ = carg_map;
								_tmp1190_ = param;
								_tmp1191_ = arg;
								_tmp1192_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1191_);
								_tmp1193_ = _tmp1192_;
								_tmp1194_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1193_);
								_tmp1195_ = _tmp1194_;
								vala_map_set ((ValaMap*) _tmp1189_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1190_), FALSE)), (ValaCCodeExpression*) _tmp1195_);
								_vala_ccode_node_unref0 (_tmp1195_);
								_vala_ccode_node_unref0 (_tmp1193_);
								_tmp1196_ = deleg_type;
								if (vala_data_type_is_disposable ((ValaDataType*) _tmp1196_)) {
									ValaDataType* _tmp1197_;
									ValaLocalVariable* _tmp1198_;
									ValaLocalVariable* _tmp1199_;
									ValaExpression* _tmp1200_;
									ValaLocalVariable* _tmp1201_;
									const gchar* _tmp1202_;
									const gchar* _tmp1203_;
									ValaCCodeExpression* _tmp1204_;
									ValaCCodeExpression* _tmp1205_;
									ValaHashMap* _tmp1206_;
									ValaParameter* _tmp1207_;
									ValaExpression* _tmp1208_;
									ValaCCodeExpression* _tmp1209_;
									ValaCCodeExpression* _tmp1210_;
									ValaCCodeUnaryExpression* _tmp1211_;
									ValaCCodeUnaryExpression* _tmp1212_;
									_tmp1197_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
									_tmp1198_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1197_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1198_;
									_tmp1199_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1199_, FALSE);
									_tmp1200_ = arg;
									_tmp1201_ = temp_var;
									_tmp1202_ = vala_symbol_get_name ((ValaSymbol*) _tmp1201_);
									_tmp1203_ = _tmp1202_;
									_tmp1204_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1203_);
									_tmp1205_ = _tmp1204_;
									vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1200_, _tmp1205_);
									_vala_ccode_node_unref0 (_tmp1205_);
									_tmp1206_ = carg_map;
									_tmp1207_ = param;
									_tmp1208_ = arg;
									_tmp1209_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1208_);
									_tmp1210_ = _tmp1209_;
									_tmp1211_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1210_);
									_tmp1212_ = _tmp1211_;
									vala_map_set ((ValaMap*) _tmp1206_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1207_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1212_);
									_vala_ccode_node_unref0 (_tmp1212_);
									_vala_ccode_node_unref0 (_tmp1210_);
								}
							}
							_vala_code_node_unref0 (deleg_type);
						}
					}
					_vala_code_node_unref0 (temp_var);
				}
				_tmp1213_ = param;
				_tmp1214_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1213_);
				_tmp1215_ = _tmp1214_;
				_tmp1216_ = _tmp1215_ != NULL;
				_g_free0 (_tmp1215_);
				if (_tmp1216_) {
					ValaCCodeExpression* _tmp1217_;
					ValaParameter* _tmp1218_;
					gchar* _tmp1219_;
					gchar* _tmp1220_;
					ValaCCodeCastExpression* _tmp1221_;
					_tmp1217_ = cexpr;
					_tmp1218_ = param;
					_tmp1219_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1218_);
					_tmp1220_ = _tmp1219_;
					_tmp1221_ = vala_ccode_cast_expression_new (_tmp1217_, _tmp1220_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1221_;
					_g_free0 (_tmp1220_);
				}
				_vala_code_node_unref0 (unary);
			} else {
				ValaUnaryExpression* unary = NULL;
				ValaExpression* _tmp1222_;
				ValaUnaryExpression* _tmp1223_;
				gboolean _tmp1224_ = FALSE;
				gboolean _tmp1225_ = FALSE;
				gboolean _tmp1226_;
				_tmp1222_ = arg;
				_tmp1223_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1222_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp1222_) : NULL);
				unary = _tmp1223_;
				_tmp1226_ = ellipsis;
				if (_tmp1226_) {
					ValaUnaryExpression* _tmp1227_;
					_tmp1227_ = unary;
					_tmp1225_ = _tmp1227_ != NULL;
				} else {
					_tmp1225_ = FALSE;
				}
				if (_tmp1225_) {
					ValaUnaryExpression* _tmp1228_;
					ValaUnaryOperator _tmp1229_;
					ValaUnaryOperator _tmp1230_;
					_tmp1228_ = unary;
					_tmp1229_ = vala_unary_expression_get_operator (_tmp1228_);
					_tmp1230_ = _tmp1229_;
					_tmp1224_ = _tmp1230_ == VALA_UNARY_OPERATOR_OUT;
				} else {
					_tmp1224_ = FALSE;
				}
				if (_tmp1224_) {
					ValaHashMap* _tmp1231_;
					ValaHashMap* _tmp1232_;
					ValaExpression* _tmp1233_;
					ValaLocalVariable* temp_var = NULL;
					ValaExpression* _tmp1234_;
					ValaDataType* _tmp1235_;
					ValaDataType* _tmp1236_;
					ValaExpression* _tmp1237_;
					ValaDataType* _tmp1238_;
					ValaDataType* _tmp1239_;
					gboolean _tmp1240_;
					gboolean _tmp1241_;
					ValaLocalVariable* _tmp1242_;
					ValaLocalVariable* _tmp1243_;
					ValaExpression* _tmp1244_;
					ValaLocalVariable* _tmp1245_;
					const gchar* _tmp1246_;
					const gchar* _tmp1247_;
					ValaCCodeExpression* _tmp1248_;
					ValaCCodeExpression* _tmp1249_;
					ValaExpression* _tmp1250_;
					ValaTargetValue* _tmp1251_;
					ValaTargetValue* _tmp1252_;
					ValaExpression* _tmp1253_;
					ValaDataType* _tmp1254_;
					ValaDataType* _tmp1255_;
					ValaExpression* _tmp1256_;
					ValaCCodeExpression* _tmp1257_;
					ValaCCodeExpression* _tmp1258_;
					ValaCCodeUnaryExpression* _tmp1259_;
					_tmp1231_ = out_arg_map;
					_tmp1232_ = _vala_map_ref0 (_tmp1231_);
					_vala_map_unref0 (carg_map);
					carg_map = _tmp1232_;
					_tmp1233_ = arg;
					vala_expression_set_target_value (_tmp1233_, NULL);
					_tmp1234_ = arg;
					_tmp1235_ = vala_expression_get_value_type (_tmp1234_);
					_tmp1236_ = _tmp1235_;
					_tmp1237_ = arg;
					_tmp1238_ = vala_expression_get_value_type (_tmp1237_);
					_tmp1239_ = _tmp1238_;
					_tmp1240_ = vala_data_type_get_value_owned (_tmp1239_);
					_tmp1241_ = _tmp1240_;
					_tmp1242_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1236_, _tmp1241_, NULL, TRUE);
					temp_var = _tmp1242_;
					_tmp1243_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1243_, FALSE);
					_tmp1244_ = arg;
					_tmp1245_ = temp_var;
					_tmp1246_ = vala_symbol_get_name ((ValaSymbol*) _tmp1245_);
					_tmp1247_ = _tmp1246_;
					_tmp1248_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1247_);
					_tmp1249_ = _tmp1248_;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1244_, _tmp1249_);
					_vala_ccode_node_unref0 (_tmp1249_);
					_tmp1250_ = arg;
					_tmp1251_ = vala_expression_get_target_value (_tmp1250_);
					_tmp1252_ = _tmp1251_;
					_tmp1253_ = arg;
					_tmp1254_ = vala_expression_get_value_type (_tmp1253_);
					_tmp1255_ = _tmp1254_;
					vala_target_value_set_value_type (_tmp1252_, _tmp1255_);
					_tmp1256_ = arg;
					_tmp1257_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1256_);
					_tmp1258_ = _tmp1257_;
					_tmp1259_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1258_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = (ValaCCodeExpression*) _tmp1259_;
					_vala_ccode_node_unref0 (_tmp1258_);
					_vala_code_node_unref0 (temp_var);
				} else {
					ValaExpression* _tmp1260_;
					ValaCCodeExpression* _tmp1261_;
					ValaCCodeExpression* _tmp1262_;
					_tmp1260_ = arg;
					_tmp1261_ = cexpr;
					_tmp1262_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1260_, _tmp1261_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1262_;
				}
				_vala_code_node_unref0 (unary);
			}
			_tmp1264_ = param;
			if (_tmp1264_ != NULL) {
				ValaParameter* _tmp1265_;
				_tmp1265_ = param;
				_tmp1263_ = vala_get_ccode_pos (_tmp1265_);
			} else {
				gint _tmp1266_;
				_tmp1266_ = i;
				_tmp1263_ = (gdouble) _tmp1266_;
			}
			_tmp1267_ = ellipsis;
			arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1263_, _tmp1267_);
			_tmp1268_ = carg_map;
			_tmp1269_ = arg_pos;
			_tmp1270_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1268_, (gpointer) ((gintptr) _tmp1269_), _tmp1270_);
			_tmp1272_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1272_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1273_;
				_tmp1273_ = ellipsis;
				_tmp1271_ = _tmp1273_;
			} else {
				_tmp1271_ = FALSE;
			}
			if (_tmp1271_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1274_;
				ValaNamedArgument* _tmp1275_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1276_;
				const gchar* _tmp1277_;
				const gchar* _tmp1278_;
				gchar** _tmp1279_;
				gchar** _tmp1280_;
				gchar** _tmp1281_;
				gint _tmp1281__length1;
				gchar* _tmp1282_;
				gchar* _tmp1283_;
				ValaHashMap* _tmp1284_;
				gint _tmp1285_;
				gboolean _tmp1286_;
				const gchar* _tmp1287_;
				gchar* _tmp1288_;
				gchar* _tmp1289_;
				ValaCCodeConstant* _tmp1290_;
				ValaCCodeConstant* _tmp1291_;
				_tmp1274_ = arg;
				_tmp1275_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1274_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1275_;
				_tmp1276_ = named_arg;
				_tmp1277_ = vala_named_argument_get_name (_tmp1276_);
				_tmp1278_ = _tmp1277_;
				_tmp1280_ = _tmp1279_ = g_strsplit (_tmp1278_, "_", 0);
				_tmp1281_ = _tmp1280_;
				_tmp1281__length1 = _vala_array_length (_tmp1279_);
				_tmp1282_ = _vala_g_strjoinv ("-", _tmp1281_, _vala_array_length (_tmp1279_));
				_tmp1283_ = _tmp1282_;
				_tmp1281_ = (_vala_array_free (_tmp1281_, _tmp1281__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1283_;
				_tmp1284_ = carg_map;
				_tmp1285_ = i;
				_tmp1286_ = ellipsis;
				_tmp1287_ = name;
				_tmp1288_ = g_strdup_printf ("\"%s\"", _tmp1287_);
				_tmp1289_ = _tmp1288_;
				_tmp1290_ = vala_ccode_constant_new (_tmp1289_);
				_tmp1291_ = _tmp1290_;
				vala_map_set ((ValaMap*) _tmp1284_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1285_ - 0.1, _tmp1286_)), (ValaCCodeExpression*) _tmp1291_);
				_vala_ccode_node_unref0 (_tmp1291_);
				_g_free0 (_tmp1289_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1292_ = i;
			i = _tmp1292_ + 1;
			_vala_code_node_unref0 (param);
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1293_ = params_it;
	if (vala_iterator_next (_tmp1293_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1294_;
		gpointer _tmp1295_;
		gboolean _tmp1296_ = FALSE;
		ValaParameter* _tmp1297_;
		gboolean _tmp1298_;
		gboolean _tmp1299_;
		_tmp1294_ = params_it;
		_tmp1295_ = vala_iterator_get (_tmp1294_);
		param = (ValaParameter*) _tmp1295_;
		_tmp1297_ = param;
		_tmp1298_ = vala_parameter_get_params_array (_tmp1297_);
		_tmp1299_ = _tmp1298_;
		if (_tmp1299_) {
			_tmp1296_ = TRUE;
		} else {
			ValaParameter* _tmp1300_;
			gboolean _tmp1301_;
			gboolean _tmp1302_;
			_tmp1300_ = param;
			_tmp1301_ = vala_parameter_get_ellipsis (_tmp1300_);
			_tmp1302_ = _tmp1301_;
			_tmp1296_ = _tmp1302_;
		}
		_vala_assert (_tmp1296_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1305_ = m;
	if (_tmp1305_ != NULL) {
		ValaMethod* _tmp1306_;
		ValaDataType* _tmp1307_;
		ValaDataType* _tmp1308_;
		_tmp1306_ = m;
		_tmp1307_ = vala_callable_get_return_type ((ValaCallable*) _tmp1306_);
		_tmp1308_ = _tmp1307_;
		_tmp1304_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1308_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1304_ = FALSE;
	}
	if (_tmp1304_) {
		ValaCCodeFunctionCall* _tmp1309_;
		ValaCCodeFunctionCall* _tmp1310_;
		_tmp1309_ = async_call;
		_tmp1310_ = ccall;
		_tmp1303_ = _tmp1309_ != _tmp1310_;
	} else {
		_tmp1303_ = FALSE;
	}
	if (_tmp1303_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1311_;
		ValaDataType* _tmp1312_;
		ValaDataType* _tmp1313_;
		ValaArrayType* _tmp1314_;
		_tmp1311_ = m;
		_tmp1312_ = vala_callable_get_return_type ((ValaCallable*) _tmp1311_);
		_tmp1313_ = _tmp1312_;
		_tmp1314_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1313_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1314_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1315_ = FALSE;
				_tmp1315_ = TRUE;
				while (TRUE) {
					gint _tmp1317_;
					ValaArrayType* _tmp1318_;
					gint _tmp1319_;
					gint _tmp1320_;
					ValaMethod* _tmp1321_;
					if (!_tmp1315_) {
						gint _tmp1316_;
						_tmp1316_ = dim;
						dim = _tmp1316_ + 1;
					}
					_tmp1315_ = FALSE;
					_tmp1317_ = dim;
					_tmp1318_ = array_type;
					_tmp1319_ = vala_array_type_get_rank (_tmp1318_);
					_tmp1320_ = _tmp1319_;
					if (!(_tmp1317_ <= _tmp1320_)) {
						break;
					}
					_tmp1321_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1321_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1322_;
						ValaDataType* _tmp1323_;
						ValaDataType* _tmp1324_;
						ValaLocalVariable* _tmp1325_;
						ValaLocalVariable* _tmp1326_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1327_;
						const gchar* _tmp1328_;
						const gchar* _tmp1329_;
						ValaCCodeExpression* _tmp1330_;
						ValaLocalVariable* _tmp1331_;
						ValaCCodeExpression* _tmp1332_;
						ValaCCodeExpression* _tmp1333_;
						ValaCCodeAssignment* _tmp1334_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1335_;
						ValaCCodeIdentifier* _tmp1336_;
						ValaCCodeFunctionCall* _tmp1337_;
						ValaCCodeFunctionCall* _tmp1338_;
						ValaCCodeFunctionCall* _tmp1339_;
						ValaCCodeExpression* _tmp1340_;
						ValaCCodeFunctionCall* _tmp1341_;
						_tmp1322_ = itype;
						_tmp1323_ = vala_data_type_get_return_type (_tmp1322_);
						_tmp1324_ = _tmp1323_;
						_tmp1325_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1324_, TRUE, NULL, FALSE);
						_tmp1326_ = _tmp1325_;
						_vala_code_node_unref0 (_tmp1324_);
						temp_var = _tmp1326_;
						_tmp1327_ = temp_var;
						_tmp1328_ = vala_symbol_get_name ((ValaSymbol*) _tmp1327_);
						_tmp1329_ = _tmp1328_;
						_tmp1330_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1329_);
						temp_ref = _tmp1330_;
						_tmp1331_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1331_, FALSE);
						_tmp1332_ = temp_ref;
						_tmp1333_ = ccall_expr;
						_tmp1334_ = vala_ccode_assignment_new (_tmp1332_, _tmp1333_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1334_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1335_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1336_ = _tmp1335_;
						_tmp1337_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1336_);
						_tmp1338_ = _tmp1337_;
						_vala_ccode_node_unref0 (_tmp1336_);
						len_call = _tmp1338_;
						_tmp1339_ = len_call;
						_tmp1340_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1339_, _tmp1340_);
						_tmp1341_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1341_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1342_;
						_tmp1342_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1342_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1343_;
							gchar* _tmp1344_;
							gchar* _tmp1345_;
							gboolean _tmp1346_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1355_;
							const gchar* _tmp1356_;
							const gchar* _tmp1357_;
							ValaCCodeExpression* _tmp1358_;
							ValaLocalVariable* _tmp1359_;
							ValaHashMap* _tmp1360_;
							ValaMethod* _tmp1361_;
							gint _tmp1362_;
							ValaCCodeExpression* _tmp1363_;
							ValaCCodeUnaryExpression* _tmp1364_;
							ValaCCodeUnaryExpression* _tmp1365_;
							ValaCCodeExpression* _tmp1366_;
							_tmp1343_ = m;
							_tmp1344_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1343_);
							_tmp1345_ = _tmp1344_;
							_tmp1346_ = _tmp1345_ == NULL;
							_g_free0 (_tmp1345_);
							if (_tmp1346_) {
								ValaDataType* _tmp1347_;
								ValaLocalVariable* _tmp1348_;
								_tmp1347_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1348_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1347_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1348_;
							} else {
								ValaMethod* _tmp1349_;
								gchar* _tmp1350_;
								gchar* _tmp1351_;
								ValaCType* _tmp1352_;
								ValaCType* _tmp1353_;
								ValaLocalVariable* _tmp1354_;
								_tmp1349_ = m;
								_tmp1350_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1349_);
								_tmp1351_ = _tmp1350_;
								_tmp1352_ = vala_ctype_new (_tmp1351_, "0");
								_tmp1353_ = _tmp1352_;
								_tmp1354_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1353_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1354_;
								_vala_code_node_unref0 (_tmp1353_);
								_g_free0 (_tmp1351_);
							}
							_tmp1355_ = temp_var;
							_tmp1356_ = vala_symbol_get_name ((ValaSymbol*) _tmp1355_);
							_tmp1357_ = _tmp1356_;
							_tmp1358_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1357_);
							temp_ref = _tmp1358_;
							_tmp1359_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1359_, FALSE);
							_tmp1360_ = out_arg_map;
							_tmp1361_ = m;
							_tmp1362_ = dim;
							_tmp1363_ = temp_ref;
							_tmp1364_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1363_);
							_tmp1365_ = _tmp1364_;
							vala_map_set ((ValaMap*) _tmp1360_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1361_) + (0.01 * _tmp1362_), FALSE)), (ValaCCodeExpression*) _tmp1365_);
							_vala_ccode_node_unref0 (_tmp1365_);
							_tmp1366_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1366_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1367_;
							gchar* _tmp1368_;
							gchar* _tmp1369_;
							gboolean _tmp1370_;
							_tmp1367_ = m;
							_tmp1368_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1367_);
							_tmp1369_ = _tmp1368_;
							_tmp1370_ = _tmp1369_ != NULL;
							_g_free0 (_tmp1369_);
							if (_tmp1370_) {
								ValaMethod* _tmp1371_;
								gchar* _tmp1372_;
								gchar* _tmp1373_;
								ValaCCodeConstant* _tmp1374_;
								ValaCCodeConstant* _tmp1375_;
								_tmp1371_ = m;
								_tmp1372_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1371_);
								_tmp1373_ = _tmp1372_;
								_tmp1374_ = vala_ccode_constant_new (_tmp1373_);
								_tmp1375_ = _tmp1374_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1375_);
								_vala_ccode_node_unref0 (_tmp1375_);
								_g_free0 (_tmp1373_);
							} else {
								ValaCCodeConstant* _tmp1376_;
								ValaCCodeConstant* _tmp1377_;
								_tmp1376_ = vala_ccode_constant_new ("-1");
								_tmp1377_ = _tmp1376_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1377_);
								_vala_ccode_node_unref0 (_tmp1377_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1378_ = FALSE;
		gboolean _tmp1379_ = FALSE;
		ValaMethod* _tmp1380_;
		_tmp1380_ = m;
		if (_tmp1380_ != NULL) {
			ValaMethod* _tmp1381_;
			ValaDataType* _tmp1382_;
			ValaDataType* _tmp1383_;
			_tmp1381_ = m;
			_tmp1382_ = vala_callable_get_return_type ((ValaCallable*) _tmp1381_);
			_tmp1383_ = _tmp1382_;
			_tmp1379_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1383_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1379_ = FALSE;
		}
		if (_tmp1379_) {
			ValaCCodeFunctionCall* _tmp1384_;
			ValaCCodeFunctionCall* _tmp1385_;
			_tmp1384_ = async_call;
			_tmp1385_ = ccall;
			_tmp1378_ = _tmp1384_ != _tmp1385_;
		} else {
			_tmp1378_ = FALSE;
		}
		if (_tmp1378_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1386_;
			ValaDataType* _tmp1387_;
			ValaDataType* _tmp1388_;
			ValaDelegateType* _tmp1389_;
			ValaDelegateType* _tmp1390_;
			ValaDelegate* _tmp1391_;
			ValaDelegate* _tmp1392_;
			gboolean _tmp1393_;
			gboolean _tmp1394_;
			_tmp1386_ = m;
			_tmp1387_ = vala_callable_get_return_type ((ValaCallable*) _tmp1386_);
			_tmp1388_ = _tmp1387_;
			_tmp1389_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1388_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1389_;
			_tmp1390_ = deleg_type;
			_tmp1391_ = vala_delegate_type_get_delegate_symbol (_tmp1390_);
			_tmp1392_ = _tmp1391_;
			_tmp1393_ = vala_delegate_get_has_target (_tmp1392_);
			_tmp1394_ = _tmp1393_;
			if (_tmp1394_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1395_;
				ValaVoidType* _tmp1396_;
				ValaPointerType* _tmp1397_;
				ValaPointerType* _tmp1398_;
				ValaLocalVariable* _tmp1399_;
				ValaLocalVariable* _tmp1400_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1401_;
				const gchar* _tmp1402_;
				const gchar* _tmp1403_;
				ValaCCodeExpression* _tmp1404_;
				ValaLocalVariable* _tmp1405_;
				ValaHashMap* _tmp1406_;
				ValaMethod* _tmp1407_;
				ValaCCodeExpression* _tmp1408_;
				ValaCCodeUnaryExpression* _tmp1409_;
				ValaCCodeUnaryExpression* _tmp1410_;
				ValaCCodeExpression* _tmp1411_;
				ValaDelegateType* _tmp1412_;
				_tmp1395_ = vala_void_type_new (NULL);
				_tmp1396_ = _tmp1395_;
				_tmp1397_ = vala_pointer_type_new ((ValaDataType*) _tmp1396_, NULL);
				_tmp1398_ = _tmp1397_;
				_tmp1399_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1398_, TRUE, NULL, TRUE);
				_tmp1400_ = _tmp1399_;
				_vala_code_node_unref0 (_tmp1398_);
				_vala_code_node_unref0 (_tmp1396_);
				temp_var = _tmp1400_;
				_tmp1401_ = temp_var;
				_tmp1402_ = vala_symbol_get_name ((ValaSymbol*) _tmp1401_);
				_tmp1403_ = _tmp1402_;
				_tmp1404_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1403_);
				temp_ref = _tmp1404_;
				_tmp1405_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1405_, FALSE);
				_tmp1406_ = out_arg_map;
				_tmp1407_ = m;
				_tmp1408_ = temp_ref;
				_tmp1409_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1408_);
				_tmp1410_ = _tmp1409_;
				vala_map_set ((ValaMap*) _tmp1406_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1407_), FALSE)), (ValaCCodeExpression*) _tmp1410_);
				_vala_ccode_node_unref0 (_tmp1410_);
				_tmp1411_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1411_);
				_tmp1412_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1412_)) {
					ValaDataType* _tmp1413_;
					ValaLocalVariable* _tmp1414_;
					ValaLocalVariable* _tmp1415_;
					const gchar* _tmp1416_;
					const gchar* _tmp1417_;
					ValaCCodeExpression* _tmp1418_;
					ValaLocalVariable* _tmp1419_;
					ValaHashMap* _tmp1420_;
					ValaMethod* _tmp1421_;
					ValaCCodeExpression* _tmp1422_;
					ValaCCodeUnaryExpression* _tmp1423_;
					ValaCCodeUnaryExpression* _tmp1424_;
					ValaCCodeExpression* _tmp1425_;
					_tmp1413_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1414_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1413_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1414_;
					_tmp1415_ = temp_var;
					_tmp1416_ = vala_symbol_get_name ((ValaSymbol*) _tmp1415_);
					_tmp1417_ = _tmp1416_;
					_tmp1418_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1417_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1418_;
					_tmp1419_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1419_, FALSE);
					_tmp1420_ = out_arg_map;
					_tmp1421_ = m;
					_tmp1422_ = temp_ref;
					_tmp1423_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1422_);
					_tmp1424_ = _tmp1423_;
					vala_map_set ((ValaMap*) _tmp1420_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1421_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1424_);
					_vala_ccode_node_unref0 (_tmp1424_);
					_tmp1425_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1425_);
				} else {
					ValaCCodeConstant* _tmp1426_;
					ValaCCodeConstant* _tmp1427_;
					_tmp1426_ = vala_ccode_constant_new ("NULL");
					_tmp1427_ = _tmp1426_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1427_);
					_vala_ccode_node_unref0 (_tmp1427_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1428_;
				ValaCCodeConstant* _tmp1429_;
				_tmp1428_ = vala_ccode_constant_new ("NULL");
				_tmp1429_ = _tmp1428_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1429_);
				_vala_ccode_node_unref0 (_tmp1429_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1431_ = deleg;
	if (_tmp1431_ != NULL) {
		ValaDelegate* _tmp1432_;
		ValaDataType* _tmp1433_;
		ValaDataType* _tmp1434_;
		_tmp1432_ = deleg;
		_tmp1433_ = vala_callable_get_return_type ((ValaCallable*) _tmp1432_);
		_tmp1434_ = _tmp1433_;
		_tmp1430_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1434_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1430_ = FALSE;
	}
	if (_tmp1430_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1435_;
		ValaDataType* _tmp1436_;
		ValaDataType* _tmp1437_;
		ValaArrayType* _tmp1438_;
		_tmp1435_ = deleg;
		_tmp1436_ = vala_callable_get_return_type ((ValaCallable*) _tmp1435_);
		_tmp1437_ = _tmp1436_;
		_tmp1438_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1437_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1438_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1439_ = FALSE;
				_tmp1439_ = TRUE;
				while (TRUE) {
					gint _tmp1441_;
					ValaArrayType* _tmp1442_;
					gint _tmp1443_;
					gint _tmp1444_;
					ValaDelegate* _tmp1445_;
					if (!_tmp1439_) {
						gint _tmp1440_;
						_tmp1440_ = dim;
						dim = _tmp1440_ + 1;
					}
					_tmp1439_ = FALSE;
					_tmp1441_ = dim;
					_tmp1442_ = array_type;
					_tmp1443_ = vala_array_type_get_rank (_tmp1442_);
					_tmp1444_ = _tmp1443_;
					if (!(_tmp1441_ <= _tmp1444_)) {
						break;
					}
					_tmp1445_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1445_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1446_;
						ValaDataType* _tmp1447_;
						ValaDataType* _tmp1448_;
						ValaLocalVariable* _tmp1449_;
						ValaLocalVariable* _tmp1450_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1451_;
						const gchar* _tmp1452_;
						const gchar* _tmp1453_;
						ValaCCodeExpression* _tmp1454_;
						ValaLocalVariable* _tmp1455_;
						ValaCCodeExpression* _tmp1456_;
						ValaCCodeExpression* _tmp1457_;
						ValaCCodeAssignment* _tmp1458_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1459_;
						ValaCCodeIdentifier* _tmp1460_;
						ValaCCodeFunctionCall* _tmp1461_;
						ValaCCodeFunctionCall* _tmp1462_;
						ValaCCodeFunctionCall* _tmp1463_;
						ValaCCodeExpression* _tmp1464_;
						ValaCCodeFunctionCall* _tmp1465_;
						_tmp1446_ = itype;
						_tmp1447_ = vala_data_type_get_return_type (_tmp1446_);
						_tmp1448_ = _tmp1447_;
						_tmp1449_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1448_, TRUE, NULL, FALSE);
						_tmp1450_ = _tmp1449_;
						_vala_code_node_unref0 (_tmp1448_);
						temp_var = _tmp1450_;
						_tmp1451_ = temp_var;
						_tmp1452_ = vala_symbol_get_name ((ValaSymbol*) _tmp1451_);
						_tmp1453_ = _tmp1452_;
						_tmp1454_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1453_);
						temp_ref = _tmp1454_;
						_tmp1455_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1455_, FALSE);
						_tmp1456_ = temp_ref;
						_tmp1457_ = ccall_expr;
						_tmp1458_ = vala_ccode_assignment_new (_tmp1456_, _tmp1457_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1458_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1459_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1460_ = _tmp1459_;
						_tmp1461_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1460_);
						_tmp1462_ = _tmp1461_;
						_vala_ccode_node_unref0 (_tmp1460_);
						len_call = _tmp1462_;
						_tmp1463_ = len_call;
						_tmp1464_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1463_, _tmp1464_);
						_tmp1465_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1465_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1466_;
						_tmp1466_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1466_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1467_;
							ValaLocalVariable* _tmp1468_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1469_;
							const gchar* _tmp1470_;
							const gchar* _tmp1471_;
							ValaCCodeExpression* _tmp1472_;
							ValaLocalVariable* _tmp1473_;
							ValaHashMap* _tmp1474_;
							ValaDelegate* _tmp1475_;
							gint _tmp1476_;
							ValaCCodeExpression* _tmp1477_;
							ValaCCodeUnaryExpression* _tmp1478_;
							ValaCCodeUnaryExpression* _tmp1479_;
							ValaCCodeExpression* _tmp1480_;
							_tmp1467_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1468_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1467_, TRUE, NULL, TRUE);
							temp_var = _tmp1468_;
							_tmp1469_ = temp_var;
							_tmp1470_ = vala_symbol_get_name ((ValaSymbol*) _tmp1469_);
							_tmp1471_ = _tmp1470_;
							_tmp1472_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1471_);
							temp_ref = _tmp1472_;
							_tmp1473_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1473_, FALSE);
							_tmp1474_ = out_arg_map;
							_tmp1475_ = deleg;
							_tmp1476_ = dim;
							_tmp1477_ = temp_ref;
							_tmp1478_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1477_);
							_tmp1479_ = _tmp1478_;
							vala_map_set ((ValaMap*) _tmp1474_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1475_) + (0.01 * _tmp1476_), FALSE)), (ValaCCodeExpression*) _tmp1479_);
							_vala_ccode_node_unref0 (_tmp1479_);
							_tmp1480_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1480_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1481_;
							ValaCCodeConstant* _tmp1482_;
							_tmp1481_ = vala_ccode_constant_new ("-1");
							_tmp1482_ = _tmp1481_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1482_);
							_vala_ccode_node_unref0 (_tmp1482_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1483_ = FALSE;
		ValaDelegate* _tmp1484_;
		_tmp1484_ = deleg;
		if (_tmp1484_ != NULL) {
			ValaDelegate* _tmp1485_;
			ValaDataType* _tmp1486_;
			ValaDataType* _tmp1487_;
			_tmp1485_ = deleg;
			_tmp1486_ = vala_callable_get_return_type ((ValaCallable*) _tmp1485_);
			_tmp1487_ = _tmp1486_;
			_tmp1483_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1487_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1483_ = FALSE;
		}
		if (_tmp1483_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1488_;
			ValaDataType* _tmp1489_;
			ValaDataType* _tmp1490_;
			ValaDelegateType* _tmp1491_;
			ValaDelegateType* _tmp1492_;
			ValaDelegate* _tmp1493_;
			ValaDelegate* _tmp1494_;
			gboolean _tmp1495_;
			gboolean _tmp1496_;
			_tmp1488_ = deleg;
			_tmp1489_ = vala_callable_get_return_type ((ValaCallable*) _tmp1488_);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1490_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1491_;
			_tmp1492_ = deleg_type;
			_tmp1493_ = vala_delegate_type_get_delegate_symbol (_tmp1492_);
			_tmp1494_ = _tmp1493_;
			_tmp1495_ = vala_delegate_get_has_target (_tmp1494_);
			_tmp1496_ = _tmp1495_;
			if (_tmp1496_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1497_;
				ValaVoidType* _tmp1498_;
				ValaPointerType* _tmp1499_;
				ValaPointerType* _tmp1500_;
				ValaLocalVariable* _tmp1501_;
				ValaLocalVariable* _tmp1502_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1503_;
				const gchar* _tmp1504_;
				const gchar* _tmp1505_;
				ValaCCodeExpression* _tmp1506_;
				ValaLocalVariable* _tmp1507_;
				ValaHashMap* _tmp1508_;
				ValaDelegate* _tmp1509_;
				ValaCCodeExpression* _tmp1510_;
				ValaCCodeUnaryExpression* _tmp1511_;
				ValaCCodeUnaryExpression* _tmp1512_;
				ValaCCodeExpression* _tmp1513_;
				ValaDelegateType* _tmp1514_;
				_tmp1497_ = vala_void_type_new (NULL);
				_tmp1498_ = _tmp1497_;
				_tmp1499_ = vala_pointer_type_new ((ValaDataType*) _tmp1498_, NULL);
				_tmp1500_ = _tmp1499_;
				_tmp1501_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1500_, TRUE, NULL, TRUE);
				_tmp1502_ = _tmp1501_;
				_vala_code_node_unref0 (_tmp1500_);
				_vala_code_node_unref0 (_tmp1498_);
				temp_var = _tmp1502_;
				_tmp1503_ = temp_var;
				_tmp1504_ = vala_symbol_get_name ((ValaSymbol*) _tmp1503_);
				_tmp1505_ = _tmp1504_;
				_tmp1506_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1505_);
				temp_ref = _tmp1506_;
				_tmp1507_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1507_, FALSE);
				_tmp1508_ = out_arg_map;
				_tmp1509_ = deleg;
				_tmp1510_ = temp_ref;
				_tmp1511_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1510_);
				_tmp1512_ = _tmp1511_;
				vala_map_set ((ValaMap*) _tmp1508_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1509_), FALSE)), (ValaCCodeExpression*) _tmp1512_);
				_vala_ccode_node_unref0 (_tmp1512_);
				_tmp1513_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1513_);
				_tmp1514_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1514_)) {
					ValaDataType* _tmp1515_;
					ValaLocalVariable* _tmp1516_;
					ValaLocalVariable* _tmp1517_;
					const gchar* _tmp1518_;
					const gchar* _tmp1519_;
					ValaCCodeExpression* _tmp1520_;
					ValaLocalVariable* _tmp1521_;
					ValaHashMap* _tmp1522_;
					ValaDelegate* _tmp1523_;
					ValaCCodeExpression* _tmp1524_;
					ValaCCodeUnaryExpression* _tmp1525_;
					ValaCCodeUnaryExpression* _tmp1526_;
					ValaCCodeExpression* _tmp1527_;
					_tmp1515_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1516_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1515_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1516_;
					_tmp1517_ = temp_var;
					_tmp1518_ = vala_symbol_get_name ((ValaSymbol*) _tmp1517_);
					_tmp1519_ = _tmp1518_;
					_tmp1520_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1519_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1520_;
					_tmp1521_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1521_, FALSE);
					_tmp1522_ = out_arg_map;
					_tmp1523_ = deleg;
					_tmp1524_ = temp_ref;
					_tmp1525_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1524_);
					_tmp1526_ = _tmp1525_;
					vala_map_set ((ValaMap*) _tmp1522_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1523_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1526_);
					_vala_ccode_node_unref0 (_tmp1526_);
					_tmp1527_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1527_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1529_ = m;
	if (_tmp1529_ != NULL) {
		ValaMethod* _tmp1530_;
		gboolean _tmp1531_;
		gboolean _tmp1532_;
		_tmp1530_ = m;
		_tmp1531_ = vala_method_get_coroutine (_tmp1530_);
		_tmp1532_ = _tmp1531_;
		_tmp1528_ = _tmp1532_;
	} else {
		_tmp1528_ = FALSE;
	}
	if (_tmp1528_) {
		gboolean _tmp1533_;
		gboolean _tmp1534_;
		_tmp1533_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1534_ = _tmp1533_;
		if (_tmp1534_) {
			ValaHashMap* _tmp1535_;
			ValaMethod* _tmp1536_;
			ValaMethod* _tmp1537_;
			gchar* _tmp1538_;
			gchar* _tmp1539_;
			ValaCCodeIdentifier* _tmp1540_;
			ValaCCodeIdentifier* _tmp1541_;
			ValaHashMap* _tmp1542_;
			ValaCCodeIdentifier* _tmp1543_;
			ValaCCodeIdentifier* _tmp1544_;
			_tmp1535_ = in_arg_map;
			_tmp1536_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1537_ = _tmp1536_;
			_tmp1538_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1537_);
			_tmp1539_ = _tmp1538_;
			_tmp1540_ = vala_ccode_identifier_new (_tmp1539_);
			_tmp1541_ = _tmp1540_;
			vala_map_set ((ValaMap*) _tmp1535_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1541_);
			_vala_ccode_node_unref0 (_tmp1541_);
			_g_free0 (_tmp1539_);
			_tmp1542_ = in_arg_map;
			_tmp1543_ = vala_ccode_identifier_new ("_data_");
			_tmp1544_ = _tmp1543_;
			vala_map_set ((ValaMap*) _tmp1542_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1544_);
			_vala_ccode_node_unref0 (_tmp1544_);
		}
	}
	_tmp1545_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1546_ = _tmp1545_;
	if (_tmp1546_) {
		ValaHashMap* _tmp1547_;
		ValaCCodeExpression* _tmp1548_;
		ValaCCodeExpression* _tmp1549_;
		ValaCCodeUnaryExpression* _tmp1550_;
		ValaCCodeUnaryExpression* _tmp1551_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1547_ = out_arg_map;
		_tmp1548_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1549_ = _tmp1548_;
		_tmp1550_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1549_);
		_tmp1551_ = _tmp1550_;
		vala_map_set ((ValaMap*) _tmp1547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1551_);
		_vala_ccode_node_unref0 (_tmp1551_);
		_vala_ccode_node_unref0 (_tmp1549_);
	} else {
		gboolean _tmp1552_ = FALSE;
		gboolean _tmp1553_ = FALSE;
		ValaMethod* _tmp1554_;
		_tmp1554_ = m;
		if (_tmp1554_ != NULL) {
			ValaMethod* _tmp1555_;
			_tmp1555_ = m;
			_tmp1553_ = vala_method_has_error_type_parameter (_tmp1555_);
		} else {
			_tmp1553_ = FALSE;
		}
		if (_tmp1553_) {
			ValaCCodeFunctionCall* _tmp1556_;
			ValaCCodeFunctionCall* _tmp1557_;
			_tmp1556_ = async_call;
			_tmp1557_ = ccall;
			_tmp1552_ = _tmp1556_ != _tmp1557_;
		} else {
			_tmp1552_ = FALSE;
		}
		if (_tmp1552_) {
			ValaHashMap* _tmp1558_;
			ValaCCodeConstant* _tmp1559_;
			ValaCCodeConstant* _tmp1560_;
			_tmp1558_ = out_arg_map;
			_tmp1559_ = vala_ccode_constant_new ("NULL");
			_tmp1560_ = _tmp1559_;
			vala_map_set ((ValaMap*) _tmp1558_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1560_);
			_vala_ccode_node_unref0 (_tmp1560_);
		}
	}
	_tmp1561_ = ellipsis;
	if (_tmp1561_) {
		ValaMethod* _tmp1562_;
		_tmp1562_ = m;
		if (_tmp1562_ == NULL) {
			ValaHashMap* _tmp1563_;
			ValaCCodeConstant* _tmp1564_;
			ValaCCodeConstant* _tmp1565_;
			_tmp1563_ = in_arg_map;
			_tmp1564_ = vala_ccode_constant_new ("NULL");
			_tmp1565_ = _tmp1564_;
			vala_map_set ((ValaMap*) _tmp1563_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1565_);
			_vala_ccode_node_unref0 (_tmp1565_);
		} else {
			gboolean _tmp1566_ = FALSE;
			gboolean _tmp1567_ = FALSE;
			gboolean _tmp1568_ = FALSE;
			ValaMethod* _tmp1569_;
			gboolean _tmp1570_;
			gboolean _tmp1571_;
			_tmp1569_ = m;
			_tmp1570_ = vala_method_get_printf_format (_tmp1569_);
			_tmp1571_ = _tmp1570_;
			if (!_tmp1571_) {
				ValaMethod* _tmp1572_;
				gboolean _tmp1573_;
				gboolean _tmp1574_;
				_tmp1572_ = m;
				_tmp1573_ = vala_method_get_scanf_format (_tmp1572_);
				_tmp1574_ = _tmp1573_;
				_tmp1568_ = !_tmp1574_;
			} else {
				_tmp1568_ = FALSE;
			}
			if (_tmp1568_) {
				ValaMethod* _tmp1575_;
				gchar* _tmp1576_;
				gchar* _tmp1577_;
				_tmp1575_ = m;
				_tmp1576_ = vala_get_ccode_sentinel (_tmp1575_);
				_tmp1577_ = _tmp1576_;
				_tmp1567_ = g_strcmp0 (_tmp1577_, "") != 0;
				_g_free0 (_tmp1577_);
			} else {
				_tmp1567_ = FALSE;
			}
			if (_tmp1567_) {
				gboolean _tmp1578_;
				gboolean _tmp1579_;
				_tmp1578_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1579_ = _tmp1578_;
				_tmp1566_ = !_tmp1579_;
			} else {
				_tmp1566_ = FALSE;
			}
			if (_tmp1566_) {
				ValaHashMap* _tmp1580_;
				ValaMethod* _tmp1581_;
				gchar* _tmp1582_;
				gchar* _tmp1583_;
				ValaCCodeConstant* _tmp1584_;
				ValaCCodeConstant* _tmp1585_;
				_tmp1580_ = in_arg_map;
				_tmp1581_ = m;
				_tmp1582_ = vala_get_ccode_sentinel (_tmp1581_);
				_tmp1583_ = _tmp1582_;
				_tmp1584_ = vala_ccode_constant_new (_tmp1583_);
				_tmp1585_ = _tmp1584_;
				vala_map_set ((ValaMap*) _tmp1580_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1585_);
				_vala_ccode_node_unref0 (_tmp1585_);
				_g_free0 (_tmp1583_);
			}
		}
	}
	_tmp1586_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1586_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1587_;
		ValaDelegateType* _tmp1588_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1589_;
		ValaDelegate* _tmp1590_;
		ValaDelegate* _tmp1591_;
		ValaDelegate* _tmp1592_;
		ValaDelegate* _tmp1593_;
		gboolean _tmp1594_;
		gboolean _tmp1595_;
		_tmp1587_ = itype;
		_tmp1588_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1587_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1588_;
		_tmp1589_ = deleg_type;
		_tmp1590_ = vala_delegate_type_get_delegate_symbol (_tmp1589_);
		_tmp1591_ = _tmp1590_;
		_tmp1592_ = _vala_code_node_ref0 (_tmp1591_);
		d = _tmp1592_;
		_tmp1593_ = d;
		_tmp1594_ = vala_delegate_get_has_target (_tmp1593_);
		_tmp1595_ = _tmp1594_;
		if (_tmp1595_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1596_;
			ValaDelegate* _tmp1597_;
			ValaExpression* _tmp1598_;
			ValaExpression* _tmp1599_;
			ValaCCodeExpression* _tmp1600_ = NULL;
			ValaCCodeExpression* _tmp1601_;
			ValaCCodeExpression* _tmp1602_;
			ValaHashMap* _tmp1603_;
			ValaDelegate* _tmp1604_;
			ValaExpression* _tmp1605_;
			ValaExpression* _tmp1606_;
			ValaCCodeExpression* _tmp1607_ = NULL;
			ValaCCodeExpression* _tmp1608_;
			ValaCCodeExpression* _tmp1609_;
			_tmp1596_ = in_arg_map;
			_tmp1597_ = d;
			_tmp1598_ = vala_method_call_get_call (expr);
			_tmp1599_ = _tmp1598_;
			_tmp1601_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1599_, &_tmp1600_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1600_;
			_tmp1602_ = _tmp1601_;
			vala_map_set ((ValaMap*) _tmp1596_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1597_), FALSE)), _tmp1602_);
			_vala_ccode_node_unref0 (_tmp1602_);
			_tmp1603_ = out_arg_map;
			_tmp1604_ = d;
			_tmp1605_ = vala_method_call_get_call (expr);
			_tmp1606_ = _tmp1605_;
			_tmp1608_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1606_, &_tmp1607_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1607_;
			_tmp1609_ = _tmp1608_;
			vala_map_set ((ValaMap*) _tmp1603_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1604_), FALSE)), _tmp1609_);
			_vala_ccode_node_unref0 (_tmp1609_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1610_ = itype;
	_tmp1611_ = vala_data_type_get_return_type (_tmp1610_);
	_tmp1612_ = _tmp1611_;
	_tmp1613_ = vala_data_type_is_real_non_null_struct_type (_tmp1612_);
	_vala_code_node_unref0 (_tmp1612_);
	return_result_via_out_param = _tmp1613_;
	_tmp1615_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1615_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1616_;
		ValaDataType* _tmp1617_;
		ValaDataType* _tmp1618_;
		_tmp1616_ = itype;
		_tmp1617_ = vala_data_type_get_return_type (_tmp1616_);
		_tmp1618_ = _tmp1617_;
		_tmp1614_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1618_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1618_);
	} else {
		_tmp1614_ = FALSE;
	}
	if (_tmp1614_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1619_;
		ValaSignal* _tmp1620_;
		ValaSignal* _tmp1621_;
		ValaSignal* _tmp1622_;
		gboolean _tmp1623_ = FALSE;
		gboolean _tmp1624_ = FALSE;
		ValaMemberAccess* _tmp1625_;
		_tmp1619_ = itype;
		_tmp1620_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1619_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1621_ = _tmp1620_;
		_tmp1622_ = _vala_code_node_ref0 (_tmp1621_);
		sig = _tmp1622_;
		_tmp1625_ = ma;
		if (_tmp1625_ != NULL) {
			ValaMemberAccess* _tmp1626_;
			ValaExpression* _tmp1627_;
			ValaExpression* _tmp1628_;
			_tmp1626_ = ma;
			_tmp1627_ = vala_member_access_get_inner (_tmp1626_);
			_tmp1628_ = _tmp1627_;
			_tmp1624_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1628_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1624_ = FALSE;
		}
		if (_tmp1624_) {
			ValaSignal* _tmp1629_;
			gboolean _tmp1630_;
			gboolean _tmp1631_;
			_tmp1629_ = sig;
			_tmp1630_ = vala_signal_get_is_virtual (_tmp1629_);
			_tmp1631_ = _tmp1630_;
			_tmp1623_ = _tmp1631_;
		} else {
			_tmp1623_ = FALSE;
		}
		if (_tmp1623_) {
		} else {
			gboolean _tmp1632_ = FALSE;
			ValaSignal* _tmp1633_;
			_tmp1633_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1633_)) {
				_tmp1632_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1634_;
				ValaSourceReference* _tmp1635_;
				ValaSourceReference* _tmp1636_;
				ValaSourceFile* _tmp1637_;
				ValaSourceFile* _tmp1638_;
				ValaSignal* _tmp1639_;
				ValaSourceReference* _tmp1640_;
				ValaSourceReference* _tmp1641_;
				ValaSourceFile* _tmp1642_;
				ValaSourceFile* _tmp1643_;
				_tmp1634_ = ma;
				_tmp1635_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1634_);
				_tmp1636_ = _tmp1635_;
				_tmp1637_ = vala_source_reference_get_file (_tmp1636_);
				_tmp1638_ = _tmp1637_;
				_tmp1639_ = sig;
				_tmp1640_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1639_);
				_tmp1641_ = _tmp1640_;
				_tmp1642_ = vala_source_reference_get_file (_tmp1641_);
				_tmp1643_ = _tmp1642_;
				_tmp1632_ = _tmp1638_ == _tmp1643_;
			}
			if (_tmp1632_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1644_ = async_call;
	_tmp1645_ = ccall;
	if (_tmp1644_ == _tmp1645_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1646_ = return_result_via_out_param;
	if (_tmp1646_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1647_;
		ValaDataType* _tmp1648_;
		ValaDataType* _tmp1649_;
		ValaLocalVariable* _tmp1650_;
		ValaLocalVariable* _tmp1651_;
		ValaLocalVariable* _tmp1652_;
		const gchar* _tmp1653_;
		const gchar* _tmp1654_;
		ValaCCodeExpression* _tmp1655_;
		ValaLocalVariable* _tmp1656_;
		ValaHashMap* _tmp1657_;
		ValaCCodeExpression* _tmp1658_;
		ValaCCodeUnaryExpression* _tmp1659_;
		ValaCCodeUnaryExpression* _tmp1660_;
		_tmp1647_ = itype;
		_tmp1648_ = vala_data_type_get_return_type (_tmp1647_);
		_tmp1649_ = _tmp1648_;
		_tmp1650_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1649_, TRUE, NULL, TRUE);
		_tmp1651_ = _tmp1650_;
		_vala_code_node_unref0 (_tmp1649_);
		out_param_var = _tmp1651_;
		_tmp1652_ = out_param_var;
		_tmp1653_ = vala_symbol_get_name ((ValaSymbol*) _tmp1652_);
		_tmp1654_ = _tmp1653_;
		_tmp1655_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1654_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1655_;
		_tmp1656_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1656_, FALSE);
		_tmp1657_ = out_arg_map;
		_tmp1658_ = out_param_ref;
		_tmp1659_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1658_);
		_tmp1660_ = _tmp1659_;
		vala_map_set ((ValaMap*) _tmp1657_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1660_);
		_vala_ccode_node_unref0 (_tmp1660_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1661_ = async_call;
	_tmp1662_ = ccall;
	if (_tmp1661_ != _tmp1662_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1679_;
			ValaCCodeFunctionCall* _tmp1680_;
			ValaHashMap* _tmp1681_;
			gint _tmp1682_;
			gpointer _tmp1683_;
			ValaCCodeExpression* _tmp1684_;
			gint _tmp1685_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1663_;
				ValaSet* _tmp1664_;
				ValaSet* _tmp1665_;
				ValaIterator* _tmp1666_;
				ValaIterator* _tmp1667_;
				_tmp1663_ = out_arg_map;
				_tmp1664_ = vala_map_get_keys ((ValaMap*) _tmp1663_);
				_tmp1665_ = _tmp1664_;
				_tmp1666_ = vala_iterable_iterator ((ValaIterable*) _tmp1665_);
				_tmp1667_ = _tmp1666_;
				_vala_iterable_unref0 (_tmp1665_);
				_pos_it = _tmp1667_;
				while (TRUE) {
					ValaIterator* _tmp1668_;
					gint pos = 0;
					ValaIterator* _tmp1669_;
					gpointer _tmp1670_;
					gboolean _tmp1671_ = FALSE;
					gint _tmp1672_;
					gint _tmp1673_;
					_tmp1668_ = _pos_it;
					if (!vala_iterator_next (_tmp1668_)) {
						break;
					}
					_tmp1669_ = _pos_it;
					_tmp1670_ = vala_iterator_get (_tmp1669_);
					pos = (gint) ((gintptr) _tmp1670_);
					_tmp1672_ = pos;
					_tmp1673_ = last_pos;
					if (_tmp1672_ > _tmp1673_) {
						gboolean _tmp1674_ = FALSE;
						gint _tmp1675_;
						_tmp1675_ = min_pos;
						if (_tmp1675_ == -1) {
							_tmp1674_ = TRUE;
						} else {
							gint _tmp1676_;
							gint _tmp1677_;
							_tmp1676_ = pos;
							_tmp1677_ = min_pos;
							_tmp1674_ = _tmp1676_ < _tmp1677_;
						}
						_tmp1671_ = _tmp1674_;
					} else {
						_tmp1671_ = FALSE;
					}
					if (_tmp1671_) {
						gint _tmp1678_;
						_tmp1678_ = pos;
						min_pos = _tmp1678_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1679_ = min_pos;
			if (_tmp1679_ == -1) {
				break;
			}
			_tmp1680_ = ccall;
			_tmp1681_ = out_arg_map;
			_tmp1682_ = min_pos;
			_tmp1683_ = vala_map_get ((ValaMap*) _tmp1681_, (gpointer) ((gintptr) _tmp1682_));
			_tmp1684_ = (ValaCCodeExpression*) _tmp1683_;
			vala_ccode_function_call_add_argument (_tmp1680_, _tmp1684_);
			_vala_ccode_node_unref0 (_tmp1684_);
			_tmp1685_ = min_pos;
			last_pos = _tmp1685_;
		}
	}
	_tmp1686_ = async_call;
	if (_tmp1686_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1703_;
			ValaCCodeFunctionCall* _tmp1704_;
			ValaHashMap* _tmp1705_;
			gint _tmp1706_;
			gpointer _tmp1707_;
			ValaCCodeExpression* _tmp1708_;
			gint _tmp1709_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1687_;
				ValaSet* _tmp1688_;
				ValaSet* _tmp1689_;
				ValaIterator* _tmp1690_;
				ValaIterator* _tmp1691_;
				_tmp1687_ = in_arg_map;
				_tmp1688_ = vala_map_get_keys ((ValaMap*) _tmp1687_);
				_tmp1689_ = _tmp1688_;
				_tmp1690_ = vala_iterable_iterator ((ValaIterable*) _tmp1689_);
				_tmp1691_ = _tmp1690_;
				_vala_iterable_unref0 (_tmp1689_);
				_pos_it = _tmp1691_;
				while (TRUE) {
					ValaIterator* _tmp1692_;
					gint pos = 0;
					ValaIterator* _tmp1693_;
					gpointer _tmp1694_;
					gboolean _tmp1695_ = FALSE;
					gint _tmp1696_;
					gint _tmp1697_;
					_tmp1692_ = _pos_it;
					if (!vala_iterator_next (_tmp1692_)) {
						break;
					}
					_tmp1693_ = _pos_it;
					_tmp1694_ = vala_iterator_get (_tmp1693_);
					pos = (gint) ((gintptr) _tmp1694_);
					_tmp1696_ = pos;
					_tmp1697_ = last_pos;
					if (_tmp1696_ > _tmp1697_) {
						gboolean _tmp1698_ = FALSE;
						gint _tmp1699_;
						_tmp1699_ = min_pos;
						if (_tmp1699_ == -1) {
							_tmp1698_ = TRUE;
						} else {
							gint _tmp1700_;
							gint _tmp1701_;
							_tmp1700_ = pos;
							_tmp1701_ = min_pos;
							_tmp1698_ = _tmp1700_ < _tmp1701_;
						}
						_tmp1695_ = _tmp1698_;
					} else {
						_tmp1695_ = FALSE;
					}
					if (_tmp1695_) {
						gint _tmp1702_;
						_tmp1702_ = pos;
						min_pos = _tmp1702_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1703_ = min_pos;
			if (_tmp1703_ == -1) {
				break;
			}
			_tmp1704_ = async_call;
			_tmp1705_ = in_arg_map;
			_tmp1706_ = min_pos;
			_tmp1707_ = vala_map_get ((ValaMap*) _tmp1705_, (gpointer) ((gintptr) _tmp1706_));
			_tmp1708_ = (ValaCCodeExpression*) _tmp1707_;
			vala_ccode_function_call_add_argument (_tmp1704_, _tmp1708_);
			_vala_ccode_node_unref0 (_tmp1708_);
			_tmp1709_ = min_pos;
			last_pos = _tmp1709_;
		}
	}
	_tmp1710_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1711_ = _tmp1710_;
	if (_tmp1711_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1712_;
		gint _tmp1713_;
		ValaCCodeFunction* _tmp1714_;
		ValaCCodeFunction* _tmp1715_;
		ValaCCodeIdentifier* _tmp1716_;
		ValaCCodeIdentifier* _tmp1717_;
		ValaCCodeMemberAccess* _tmp1718_;
		ValaCCodeMemberAccess* _tmp1719_;
		gint _tmp1720_;
		gchar* _tmp1721_;
		gchar* _tmp1722_;
		ValaCCodeConstant* _tmp1723_;
		ValaCCodeConstant* _tmp1724_;
		ValaCCodeFunction* _tmp1725_;
		ValaCCodeFunction* _tmp1726_;
		ValaCCodeFunctionCall* _tmp1727_;
		ValaCCodeFunction* _tmp1728_;
		ValaCCodeFunction* _tmp1729_;
		ValaCCodeConstant* _tmp1730_;
		ValaCCodeConstant* _tmp1731_;
		ValaCCodeFunction* _tmp1732_;
		ValaCCodeFunction* _tmp1733_;
		gint _tmp1734_;
		gchar* _tmp1735_;
		gchar* _tmp1736_;
		_tmp1712_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1713_ = _tmp1712_->next_coroutine_state;
		_tmp1712_->next_coroutine_state = _tmp1713_ + 1;
		state = _tmp1713_;
		_tmp1714_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1715_ = _tmp1714_;
		_tmp1716_ = vala_ccode_identifier_new ("_data_");
		_tmp1717_ = _tmp1716_;
		_tmp1718_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1717_, "_state_");
		_tmp1719_ = _tmp1718_;
		_tmp1720_ = state;
		_tmp1721_ = g_strdup_printf ("%i", _tmp1720_);
		_tmp1722_ = _tmp1721_;
		_tmp1723_ = vala_ccode_constant_new (_tmp1722_);
		_tmp1724_ = _tmp1723_;
		vala_ccode_function_add_assignment (_tmp1715_, (ValaCCodeExpression*) _tmp1719_, (ValaCCodeExpression*) _tmp1724_);
		_vala_ccode_node_unref0 (_tmp1724_);
		_g_free0 (_tmp1722_);
		_vala_ccode_node_unref0 (_tmp1719_);
		_vala_ccode_node_unref0 (_tmp1717_);
		_tmp1725_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1726_ = _tmp1725_;
		_tmp1727_ = async_call;
		vala_ccode_function_add_expression (_tmp1726_, (ValaCCodeExpression*) _tmp1727_);
		_tmp1728_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1729_ = _tmp1728_;
		_tmp1730_ = vala_ccode_constant_new ("FALSE");
		_tmp1731_ = _tmp1730_;
		vala_ccode_function_add_return (_tmp1729_, (ValaCCodeExpression*) _tmp1731_);
		_vala_ccode_node_unref0 (_tmp1731_);
		_tmp1732_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1733_ = _tmp1732_;
		_tmp1734_ = state;
		_tmp1735_ = g_strdup_printf ("_state_%d", _tmp1734_);
		_tmp1736_ = _tmp1735_;
		vala_ccode_function_add_label (_tmp1733_, _tmp1736_);
		_g_free0 (_tmp1736_);
	}
	_tmp1737_ = vala_method_call_get_is_assert (expr);
	_tmp1738_ = _tmp1737_;
	if (_tmp1738_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1739_;
		ValaSourceReference* _tmp1740_;
		ValaSourceLocation _tmp1741_ = {0};
		ValaSourceLocation _tmp1742_;
		gchar* _tmp1743_;
		ValaSourceReference* _tmp1744_;
		ValaSourceReference* _tmp1745_;
		ValaSourceLocation _tmp1746_ = {0};
		ValaSourceLocation _tmp1747_;
		gchar* _tmp1748_;
		ValaSourceReference* _tmp1749_;
		ValaSourceReference* _tmp1750_;
		ValaSourceLocation _tmp1751_ = {0};
		ValaSourceLocation _tmp1752_;
		gchar* _tmp1753_;
		gchar* _tmp1754_;
		ValaCCodeFunctionCall* _tmp1755_;
		ValaCCodeIdentifier* _tmp1756_;
		ValaCCodeIdentifier* _tmp1757_;
		ValaCCodeFunctionCall* _tmp1758_;
		const gchar* _tmp1759_;
		gchar* _tmp1760_;
		gchar* _tmp1761_;
		gchar* _tmp1762_;
		gchar* _tmp1763_;
		gchar* _tmp1764_;
		gchar* _tmp1765_;
		ValaCCodeConstant* _tmp1766_;
		ValaCCodeConstant* _tmp1767_;
		_tmp1739_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1740_ = _tmp1739_;
		vala_source_reference_get_begin (_tmp1740_, &_tmp1741_);
		_tmp1742_ = _tmp1741_;
		_tmp1743_ = _tmp1742_.pos;
		_tmp1744_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1745_ = _tmp1744_;
		vala_source_reference_get_end (_tmp1745_, &_tmp1746_);
		_tmp1747_ = _tmp1746_;
		_tmp1748_ = _tmp1747_.pos;
		_tmp1749_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1750_ = _tmp1749_;
		vala_source_reference_get_begin (_tmp1750_, &_tmp1751_);
		_tmp1752_ = _tmp1751_;
		_tmp1753_ = _tmp1752_.pos;
		_tmp1754_ = string_substring ((const gchar*) _tmp1743_, (glong) 0, (glong) ((gint) (_tmp1748_ - _tmp1753_)));
		message = _tmp1754_;
		_tmp1755_ = ccall;
		_tmp1756_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1757_ = _tmp1756_;
		vala_ccode_function_call_set_call (_tmp1755_, (ValaCCodeExpression*) _tmp1757_);
		_vala_ccode_node_unref0 (_tmp1757_);
		_tmp1758_ = ccall;
		_tmp1759_ = message;
		_tmp1760_ = string_replace (_tmp1759_, "\n", " ");
		_tmp1761_ = _tmp1760_;
		_tmp1762_ = g_strescape (_tmp1761_, "");
		_tmp1763_ = _tmp1762_;
		_tmp1764_ = g_strdup_printf ("\"%s\"", _tmp1763_);
		_tmp1765_ = _tmp1764_;
		_tmp1766_ = vala_ccode_constant_new (_tmp1765_);
		_tmp1767_ = _tmp1766_;
		vala_ccode_function_call_add_argument (_tmp1758_, (ValaCCodeExpression*) _tmp1767_);
		_vala_ccode_node_unref0 (_tmp1767_);
		_g_free0 (_tmp1765_);
		_g_free0 (_tmp1763_);
		_g_free0 (_tmp1761_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1768_ = return_result_via_out_param;
	if (_tmp1768_) {
		ValaCCodeFunction* _tmp1769_;
		ValaCCodeFunction* _tmp1770_;
		ValaCCodeExpression* _tmp1771_;
		ValaCCodeExpression* _tmp1772_;
		ValaCCodeExpression* _tmp1773_;
		_tmp1769_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1770_ = _tmp1769_;
		_tmp1771_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1770_, _tmp1771_);
		_tmp1772_ = out_param_ref;
		_tmp1773_ = _vala_ccode_node_ref0 (_tmp1772_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1773_;
	}
	_tmp1776_ = m;
	if (_tmp1776_ != NULL) {
		ValaMethod* _tmp1777_;
		ValaMemberBinding _tmp1778_;
		ValaMemberBinding _tmp1779_;
		_tmp1777_ = m;
		_tmp1778_ = vala_method_get_binding (_tmp1777_);
		_tmp1779_ = _tmp1778_;
		_tmp1775_ = _tmp1779_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1775_ = FALSE;
	}
	if (_tmp1775_) {
		ValaMethod* _tmp1780_;
		gboolean _tmp1781_;
		gboolean _tmp1782_;
		_tmp1780_ = m;
		_tmp1781_ = vala_method_get_returns_modified_pointer (_tmp1780_);
		_tmp1782_ = _tmp1781_;
		_tmp1774_ = _tmp1782_;
	} else {
		_tmp1774_ = FALSE;
	}
	if (_tmp1774_) {
		gboolean _tmp1783_ = FALSE;
		gboolean _tmp1784_ = FALSE;
		ValaMemberAccess* _tmp1785_;
		_tmp1785_ = ma;
		if (_tmp1785_ != NULL) {
			ValaMemberAccess* _tmp1786_;
			ValaExpression* _tmp1787_;
			ValaExpression* _tmp1788_;
			ValaSymbol* _tmp1789_;
			ValaSymbol* _tmp1790_;
			_tmp1786_ = ma;
			_tmp1787_ = vala_member_access_get_inner (_tmp1786_);
			_tmp1788_ = _tmp1787_;
			_tmp1789_ = vala_expression_get_symbol_reference (_tmp1788_);
			_tmp1790_ = _tmp1789_;
			_tmp1784_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1790_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1784_ = FALSE;
		}
		if (_tmp1784_) {
			ValaMemberAccess* _tmp1791_;
			ValaExpression* _tmp1792_;
			ValaExpression* _tmp1793_;
			_tmp1791_ = ma;
			_tmp1792_ = vala_member_access_get_inner (_tmp1791_);
			_tmp1793_ = _tmp1792_;
			_tmp1783_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1793_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1783_ = FALSE;
		}
		if (_tmp1783_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1794_;
			ValaExpression* _tmp1795_;
			ValaExpression* _tmp1796_;
			ValaSymbol* _tmp1797_;
			ValaSymbol* _tmp1798_;
			ValaProperty* _tmp1799_;
			ValaProperty* _tmp1800_;
			ValaMemberAccess* _tmp1801_;
			ValaExpression* _tmp1802_;
			ValaExpression* _tmp1803_;
			ValaExpression* _tmp1804_;
			ValaExpression* _tmp1805_;
			ValaDataType* _tmp1806_;
			ValaDataType* _tmp1807_;
			ValaCCodeExpression* _tmp1808_;
			ValaGLibValue* _tmp1809_;
			ValaGLibValue* _tmp1810_;
			_tmp1794_ = ma;
			_tmp1795_ = vala_member_access_get_inner (_tmp1794_);
			_tmp1796_ = _tmp1795_;
			_tmp1797_ = vala_expression_get_symbol_reference (_tmp1796_);
			_tmp1798_ = _tmp1797_;
			_tmp1799_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1798_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1799_;
			_tmp1800_ = prop;
			_tmp1801_ = ma;
			_tmp1802_ = vala_member_access_get_inner (_tmp1801_);
			_tmp1803_ = _tmp1802_;
			_tmp1804_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1803_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1805_ = _tmp1804_;
			_tmp1806_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1807_ = _tmp1806_;
			_tmp1808_ = ccall_expr;
			_tmp1809_ = vala_glib_value_new (_tmp1807_, _tmp1808_, FALSE);
			_tmp1810_ = _tmp1809_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1800_, _tmp1805_, (ValaTargetValue*) _tmp1810_);
			_vala_target_value_unref0 (_tmp1810_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1811_;
			ValaCCodeExpression* _tmp1812_;
			ValaCCodeAssignment* _tmp1813_;
			_tmp1811_ = instance;
			_tmp1812_ = ccall_expr;
			_tmp1813_ = vala_ccode_assignment_new (_tmp1811_, _tmp1812_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1813_;
		}
	}
	_tmp1819_ = m;
	if (_tmp1819_ != NULL) {
		ValaMethod* _tmp1820_;
		_tmp1820_ = m;
		_tmp1818_ = vala_get_ccode_simple_generics (_tmp1820_);
	} else {
		_tmp1818_ = FALSE;
	}
	if (_tmp1818_) {
		ValaMethod* _tmp1821_;
		ValaDataType* _tmp1822_;
		ValaDataType* _tmp1823_;
		_tmp1821_ = m;
		_tmp1822_ = vala_callable_get_return_type ((ValaCallable*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1817_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1823_, VALA_TYPE_GENERIC_TYPE);
	} else {
		_tmp1817_ = FALSE;
	}
	if (_tmp1817_) {
		ValaDataType* _tmp1824_;
		ValaDataType* _tmp1825_;
		_tmp1824_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1825_ = _tmp1824_;
		_tmp1816_ = vala_data_type_is_real_struct_type (_tmp1825_);
	} else {
		_tmp1816_ = FALSE;
	}
	if (_tmp1816_) {
		ValaDataType* _tmp1826_;
		ValaDataType* _tmp1827_;
		gboolean _tmp1828_;
		gboolean _tmp1829_;
		_tmp1826_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1827_ = _tmp1826_;
		_tmp1828_ = vala_data_type_get_nullable (_tmp1827_);
		_tmp1829_ = _tmp1828_;
		_tmp1815_ = !_tmp1829_;
	} else {
		_tmp1815_ = FALSE;
	}
	if (_tmp1815_) {
		ValaDataType* _tmp1830_;
		ValaDataType* _tmp1831_;
		_tmp1830_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1831_ = _tmp1830_;
		_tmp1814_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1831_, VALA_TYPE_POINTER_TYPE);
	} else {
		_tmp1814_ = FALSE;
	}
	if (_tmp1814_) {
		ValaCCodeExpression* _tmp1832_;
		ValaCCodeParenthesizedExpression* _tmp1833_;
		ValaCCodeParenthesizedExpression* _tmp1834_;
		ValaCCodeUnaryExpression* _tmp1835_;
		_tmp1832_ = ccall_expr;
		_tmp1833_ = vala_ccode_parenthesized_expression_new (_tmp1832_);
		_tmp1834_ = _tmp1833_;
		_tmp1835_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, (ValaCCodeExpression*) _tmp1834_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1835_;
		_vala_ccode_node_unref0 (_tmp1834_);
	}
	_tmp1838_ = m;
	if (_tmp1838_ != NULL) {
		ValaMethod* _tmp1839_;
		gchar* _tmp1840_;
		gchar* _tmp1841_;
		_tmp1839_ = m;
		_tmp1840_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1839_);
		_tmp1841_ = _tmp1840_;
		_tmp1837_ = _tmp1841_ != NULL;
		_g_free0 (_tmp1841_);
	} else {
		_tmp1837_ = FALSE;
	}
	if (_tmp1837_) {
		ValaMethod* _tmp1842_;
		gchar* _tmp1843_;
		gchar* _tmp1844_;
		ValaMethod* _tmp1845_;
		ValaDataType* _tmp1846_;
		ValaDataType* _tmp1847_;
		gchar* _tmp1848_;
		gchar* _tmp1849_;
		_tmp1842_ = m;
		_tmp1843_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1842_);
		_tmp1844_ = _tmp1843_;
		_tmp1845_ = m;
		_tmp1846_ = vala_callable_get_return_type ((ValaCallable*) _tmp1845_);
		_tmp1847_ = _tmp1846_;
		_tmp1848_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1847_);
		_tmp1849_ = _tmp1848_;
		_tmp1836_ = g_strcmp0 (_tmp1844_, _tmp1849_) != 0;
		_g_free0 (_tmp1849_);
		_g_free0 (_tmp1844_);
	} else {
		_tmp1836_ = FALSE;
	}
	if (_tmp1836_) {
		ValaCCodeExpression* _tmp1850_;
		ValaMethod* _tmp1851_;
		ValaDataType* _tmp1852_;
		ValaDataType* _tmp1853_;
		gchar* _tmp1854_;
		gchar* _tmp1855_;
		ValaCCodeCastExpression* _tmp1856_;
		_tmp1850_ = ccall_expr;
		_tmp1851_ = m;
		_tmp1852_ = vala_callable_get_return_type ((ValaCallable*) _tmp1851_);
		_tmp1853_ = _tmp1852_;
		_tmp1854_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1853_);
		_tmp1855_ = _tmp1854_;
		_tmp1856_ = vala_ccode_cast_expression_new (_tmp1850_, _tmp1855_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1856_;
		_g_free0 (_tmp1855_);
	}
	_tmp1857_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1857_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1858_;
		ValaList* _tmp1859_;
		ValaIterator* _tmp1860_;
		ValaIterator* _tmp1861_;
		ValaIterator* _tmp1862_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1863_;
		gpointer _tmp1864_;
		ValaExpression* _tmp1865_;
		ValaCCodeExpression* _tmp1866_;
		ValaCCodeExpression* _tmp1867_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1868_;
		ValaLocalVariable* _tmp1869_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1870_;
		const gchar* _tmp1871_;
		const gchar* _tmp1872_;
		ValaCCodeExpression* _tmp1873_;
		ValaLocalVariable* _tmp1874_;
		ValaCCodeFile* _tmp1875_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1876_;
		ValaExpression* _tmp1877_;
		ValaExpression* _tmp1878_;
		ValaCCodeExpression* _tmp1879_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1880_;
		ValaExpression* _tmp1881_;
		ValaExpression* _tmp1882_;
		ValaCCodeExpression* _tmp1883_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1884_;
		ValaExpression* _tmp1885_;
		ValaExpression* _tmp1886_;
		ValaDataType* _tmp1887_;
		ValaDataType* _tmp1888_;
		ValaArrayType* _tmp1889_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1890_;
		ValaDataType* _tmp1891_;
		ValaDataType* _tmp1892_;
		gchar* _tmp1893_;
		gchar* _tmp1894_;
		gchar* _tmp1895_;
		gchar* _tmp1896_;
		ValaCCodeIdentifier* _tmp1897_;
		ValaCCodeIdentifier* _tmp1898_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1899_;
		ValaCCodeExpression* _tmp1900_;
		ValaCCodeBinaryExpression* _tmp1901_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1902_;
		ValaCCodeExpression* _tmp1903_;
		ValaCCodeBinaryExpression* _tmp1904_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1905_;
		ValaCCodeIdentifier* _tmp1906_;
		ValaCCodeFunctionCall* _tmp1907_;
		ValaCCodeFunctionCall* _tmp1908_;
		ValaCCodeFunctionCall* _tmp1909_;
		ValaCCodeExpression* _tmp1910_;
		ValaCCodeExpression* _tmp1911_;
		ValaCCodeBinaryExpression* _tmp1912_;
		ValaCCodeBinaryExpression* _tmp1913_;
		ValaCCodeFunctionCall* _tmp1914_;
		ValaCCodeConstant* _tmp1915_;
		ValaCCodeConstant* _tmp1916_;
		ValaCCodeFunctionCall* _tmp1917_;
		ValaCCodeIdentifier* _tmp1918_;
		ValaCCodeBinaryExpression* _tmp1919_;
		ValaCCodeBinaryExpression* _tmp1920_;
		ValaCCodeBinaryExpression* _tmp1921_;
		ValaCCodeFunction* _tmp1922_;
		ValaCCodeFunction* _tmp1923_;
		ValaCCodeExpression* _tmp1924_;
		ValaCCodeExpression* _tmp1925_;
		ValaCCodeFunction* _tmp1926_;
		ValaCCodeFunction* _tmp1927_;
		ValaCCodeExpression* _tmp1928_;
		ValaCCodeFunction* _tmp1929_;
		ValaCCodeFunction* _tmp1930_;
		ValaCCodeBinaryExpression* _tmp1931_;
		ValaCCodeFunctionCall* _tmp1932_;
		ValaCCodeConstant* _tmp1933_;
		ValaCCodeConstant* _tmp1934_;
		ValaCCodeConditionalExpression* _tmp1935_;
		ValaCCodeConditionalExpression* _tmp1936_;
		ValaCCodeFunction* _tmp1937_;
		ValaCCodeFunction* _tmp1938_;
		ValaMemberAccess* _tmp1939_;
		ValaExpression* _tmp1940_;
		ValaExpression* _tmp1941_;
		ValaCCodeExpression* _tmp1942_;
		ValaCCodeExpression* _tmp1943_;
		ValaCCodeExpression* _tmp1944_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1945_;
		ValaExpression* _tmp1946_;
		ValaExpression* _tmp1947_;
		ValaSymbol* _tmp1948_;
		ValaSymbol* _tmp1949_;
		ValaSymbol* _tmp1950_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1951_;
		ValaLocalVariable* _tmp1952_;
		gboolean _tmp1953_ = FALSE;
		gboolean _tmp1954_ = FALSE;
		ValaSymbol* _tmp1955_;
		_tmp1858_ = vala_method_call_get_argument_list (expr);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = vala_iterable_iterator ((ValaIterable*) _tmp1859_);
		_tmp1861_ = _tmp1860_;
		_vala_iterable_unref0 (_tmp1859_);
		arg_it = _tmp1861_;
		_tmp1862_ = arg_it;
		vala_iterator_next (_tmp1862_);
		_tmp1863_ = arg_it;
		_tmp1864_ = vala_iterator_get (_tmp1863_);
		_tmp1865_ = (ValaExpression*) _tmp1864_;
		_tmp1866_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1865_);
		_tmp1867_ = _tmp1866_;
		_vala_code_node_unref0 (_tmp1865_);
		new_size = _tmp1867_;
		_tmp1868_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1869_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1868_, TRUE, NULL, FALSE);
		temp_decl = _tmp1869_;
		_tmp1870_ = temp_decl;
		_tmp1871_ = vala_symbol_get_name ((ValaSymbol*) _tmp1870_);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1872_);
		temp_ref = _tmp1873_;
		_tmp1874_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1874_, FALSE);
		_tmp1875_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1875_, "string.h", FALSE);
		_tmp1876_ = ma;
		_tmp1877_ = vala_member_access_get_inner (_tmp1876_);
		_tmp1878_ = _tmp1877_;
		_tmp1879_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1878_, 1);
		clen = _tmp1879_;
		_tmp1880_ = ma;
		_tmp1881_ = vala_member_access_get_inner (_tmp1880_);
		_tmp1882_ = _tmp1881_;
		_tmp1883_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1882_);
		celems = _tmp1883_;
		_tmp1884_ = ma;
		_tmp1885_ = vala_member_access_get_inner (_tmp1884_);
		_tmp1886_ = _tmp1885_;
		_tmp1887_ = vala_expression_get_value_type (_tmp1886_);
		_tmp1888_ = _tmp1887_;
		_tmp1889_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1888_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1889_;
		_tmp1890_ = array_type;
		_tmp1891_ = vala_array_type_get_element_type (_tmp1890_);
		_tmp1892_ = _tmp1891_;
		_tmp1893_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1892_);
		_tmp1894_ = _tmp1893_;
		_tmp1895_ = g_strdup_printf ("sizeof (%s)", _tmp1894_);
		_tmp1896_ = _tmp1895_;
		_tmp1897_ = vala_ccode_identifier_new (_tmp1896_);
		_tmp1898_ = _tmp1897_;
		_g_free0 (_tmp1896_);
		_g_free0 (_tmp1894_);
		csizeof = _tmp1898_;
		_tmp1899_ = temp_ref;
		_tmp1900_ = clen;
		_tmp1901_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1899_, _tmp1900_);
		cdelta = _tmp1901_;
		_tmp1902_ = temp_ref;
		_tmp1903_ = clen;
		_tmp1904_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1902_, _tmp1903_);
		ccheck = _tmp1904_;
		_tmp1905_ = vala_ccode_identifier_new ("memset");
		_tmp1906_ = _tmp1905_;
		_tmp1907_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1906_);
		_tmp1908_ = _tmp1907_;
		_vala_ccode_node_unref0 (_tmp1906_);
		czero = _tmp1908_;
		_tmp1909_ = czero;
		_tmp1910_ = celems;
		_tmp1911_ = clen;
		_tmp1912_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1910_, _tmp1911_);
		_tmp1913_ = _tmp1912_;
		vala_ccode_function_call_add_argument (_tmp1909_, (ValaCCodeExpression*) _tmp1913_);
		_vala_ccode_node_unref0 (_tmp1913_);
		_tmp1914_ = czero;
		_tmp1915_ = vala_ccode_constant_new ("0");
		_tmp1916_ = _tmp1915_;
		vala_ccode_function_call_add_argument (_tmp1914_, (ValaCCodeExpression*) _tmp1916_);
		_vala_ccode_node_unref0 (_tmp1916_);
		_tmp1917_ = czero;
		_tmp1918_ = csizeof;
		_tmp1919_ = cdelta;
		_tmp1920_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1918_, (ValaCCodeExpression*) _tmp1919_);
		_tmp1921_ = _tmp1920_;
		vala_ccode_function_call_add_argument (_tmp1917_, (ValaCCodeExpression*) _tmp1921_);
		_vala_ccode_node_unref0 (_tmp1921_);
		_tmp1922_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1923_ = _tmp1922_;
		_tmp1924_ = temp_ref;
		_tmp1925_ = new_size;
		vala_ccode_function_add_assignment (_tmp1923_, _tmp1924_, _tmp1925_);
		_tmp1926_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1927_ = _tmp1926_;
		_tmp1928_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1927_, _tmp1928_);
		_tmp1929_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1930_ = _tmp1929_;
		_tmp1931_ = ccheck;
		_tmp1932_ = czero;
		_tmp1933_ = vala_ccode_constant_new ("NULL");
		_tmp1934_ = _tmp1933_;
		_tmp1935_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1931_, (ValaCCodeExpression*) _tmp1932_, (ValaCCodeExpression*) _tmp1934_);
		_tmp1936_ = _tmp1935_;
		vala_ccode_function_add_expression (_tmp1930_, (ValaCCodeExpression*) _tmp1936_);
		_vala_ccode_node_unref0 (_tmp1936_);
		_vala_ccode_node_unref0 (_tmp1934_);
		_tmp1937_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1938_ = _tmp1937_;
		_tmp1939_ = ma;
		_tmp1940_ = vala_member_access_get_inner (_tmp1939_);
		_tmp1941_ = _tmp1940_;
		_tmp1942_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1941_, 1);
		_tmp1943_ = _tmp1942_;
		_tmp1944_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1938_, _tmp1943_, _tmp1944_);
		_vala_ccode_node_unref0 (_tmp1943_);
		_tmp1945_ = ma;
		_tmp1946_ = vala_member_access_get_inner (_tmp1945_);
		_tmp1947_ = _tmp1946_;
		_tmp1948_ = vala_expression_get_symbol_reference (_tmp1947_);
		_tmp1949_ = _tmp1948_;
		_tmp1950_ = _vala_code_node_ref0 (_tmp1949_);
		array_var = _tmp1950_;
		_tmp1951_ = array_var;
		_tmp1952_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1951_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1951_) : NULL);
		array_local = _tmp1952_;
		_tmp1955_ = array_var;
		if (_tmp1955_ != NULL) {
			ValaSymbol* _tmp1956_;
			_tmp1956_ = array_var;
			_tmp1954_ = vala_symbol_is_internal_symbol (_tmp1956_);
		} else {
			_tmp1954_ = FALSE;
		}
		if (_tmp1954_) {
			gboolean _tmp1957_ = FALSE;
			gboolean _tmp1958_ = FALSE;
			ValaSymbol* _tmp1959_;
			_tmp1959_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1959_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1960_;
				gboolean _tmp1961_;
				gboolean _tmp1962_;
				_tmp1960_ = array_local;
				_tmp1961_ = vala_local_variable_get_captured (_tmp1960_);
				_tmp1962_ = _tmp1961_;
				_tmp1958_ = !_tmp1962_;
			} else {
				_tmp1958_ = FALSE;
			}
			if (_tmp1958_) {
				_tmp1957_ = TRUE;
			} else {
				ValaSymbol* _tmp1963_;
				_tmp1963_ = array_var;
				_tmp1957_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1963_, VALA_TYPE_FIELD);
			}
			_tmp1953_ = _tmp1957_;
		} else {
			_tmp1953_ = FALSE;
		}
		if (_tmp1953_) {
			ValaCCodeFunction* _tmp1964_;
			ValaCCodeFunction* _tmp1965_;
			ValaMemberAccess* _tmp1966_;
			ValaExpression* _tmp1967_;
			ValaExpression* _tmp1968_;
			ValaTargetValue* _tmp1969_;
			ValaTargetValue* _tmp1970_;
			ValaCCodeExpression* _tmp1971_;
			ValaCCodeExpression* _tmp1972_;
			ValaCCodeExpression* _tmp1973_;
			_tmp1964_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1965_ = _tmp1964_;
			_tmp1966_ = ma;
			_tmp1967_ = vala_member_access_get_inner (_tmp1966_);
			_tmp1968_ = _tmp1967_;
			_tmp1969_ = vala_expression_get_target_value (_tmp1968_);
			_tmp1970_ = _tmp1969_;
			_tmp1971_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1970_);
			_tmp1972_ = _tmp1971_;
			_tmp1973_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1965_, _tmp1972_, _tmp1973_);
			_vala_ccode_node_unref0 (_tmp1972_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1975_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1976_ = _tmp1975_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1976_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1977_;
		ValaDataType* _tmp1978_;
		_tmp1977_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1978_ = _tmp1977_;
		_tmp1974_ = !vala_data_type_is_disposable (_tmp1978_);
	} else {
		_tmp1974_ = FALSE;
	}
	if (_tmp1974_) {
		gboolean _tmp1979_ = FALSE;
		ValaCCodeExpression* _tmp1980_;
		_tmp1980_ = ccall_expr;
		if (_tmp1980_ != NULL) {
			gboolean _tmp1981_;
			_tmp1981_ = return_result_via_out_param;
			_tmp1979_ = !_tmp1981_;
		} else {
			_tmp1979_ = FALSE;
		}
		if (_tmp1979_) {
			ValaCCodeFunction* _tmp1982_;
			ValaCCodeFunction* _tmp1983_;
			ValaCCodeExpression* _tmp1984_;
			_tmp1982_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1983_ = _tmp1982_;
			_tmp1984_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1983_, _tmp1984_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1985_;
		ValaDataType* _tmp1986_;
		gboolean _tmp1987_ = FALSE;
		ValaDataType* _tmp1988_;
		ValaDataType* _tmp1989_;
		gboolean _tmp2016_ = FALSE;
		ValaMethod* _tmp2017_;
		_tmp1985_ = itype;
		_tmp1986_ = vala_data_type_get_return_type (_tmp1985_);
		result_type = _tmp1986_;
		_tmp1988_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1989_ = _tmp1988_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1989_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1990_;
			ValaDataType* _tmp1991_;
			_tmp1990_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1991_ = _tmp1990_;
			_tmp1987_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1991_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1987_ = FALSE;
		}
		if (_tmp1987_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1992_;
			ValaDataType* _tmp1993_;
			ValaTypeParameter* _tmp1994_;
			ValaTypeParameter* _tmp1995_;
			ValaTypeParameter* _tmp1996_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1997_;
			ValaSymbol* _tmp1998_;
			ValaSymbol* _tmp1999_;
			ValaSymbol* _tmp2000_;
			ValaSymbol* _tmp2001_;
			ValaStruct* _tmp2002_;
			gboolean _tmp2003_ = FALSE;
			ValaTypeParameter* _tmp2004_;
			ValaSymbol* _tmp2005_;
			ValaSymbol* _tmp2006_;
			ValaTypeSymbol* _tmp2007_;
			_tmp1992_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1993_ = _tmp1992_;
			_tmp1994_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1993_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1995_ = _tmp1994_;
			_tmp1996_ = _vala_code_node_ref0 (_tmp1995_);
			type_parameter = _tmp1996_;
			_tmp1997_ = type_parameter;
			_tmp1998_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1997_);
			_tmp1999_ = _tmp1998_;
			_tmp2000_ = vala_symbol_get_parent_symbol (_tmp1999_);
			_tmp2001_ = _tmp2000_;
			_tmp2002_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2001_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp2001_) : NULL);
			st = _tmp2002_;
			_tmp2004_ = type_parameter;
			_tmp2005_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2004_);
			_tmp2006_ = _tmp2005_;
			_tmp2007_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp2006_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2007_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp2003_ = TRUE;
			} else {
				gboolean _tmp2008_ = FALSE;
				ValaStruct* _tmp2009_;
				_tmp2009_ = st;
				if (_tmp2009_ != NULL) {
					ValaStruct* _tmp2010_;
					gchar* _tmp2011_;
					gchar* _tmp2012_;
					_tmp2010_ = st;
					_tmp2011_ = vala_get_ccode_name ((ValaCodeNode*) _tmp2010_);
					_tmp2012_ = _tmp2011_;
					_tmp2008_ = g_strcmp0 (_tmp2012_, "va_list") == 0;
					_g_free0 (_tmp2012_);
				} else {
					_tmp2008_ = FALSE;
				}
				_tmp2003_ = _tmp2008_;
			}
			if (_tmp2003_) {
				ValaDataType* _tmp2013_;
				ValaDataType* _tmp2014_;
				ValaDataType* _tmp2015_;
				_tmp2013_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp2014_ = _tmp2013_;
				_tmp2015_ = _vala_code_node_ref0 (_tmp2014_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp2015_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp2017_ = m;
		if (_tmp2017_ != NULL) {
			ValaMethod* _tmp2018_;
			_tmp2018_ = m;
			_tmp2016_ = vala_method_get_format_arg_index (_tmp2018_) >= 0;
		} else {
			_tmp2016_ = FALSE;
		}
		if (_tmp2016_) {
			ValaCCodeExpression* _tmp2019_;
			_tmp2019_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2019_);
		} else {
			gboolean _tmp2020_ = FALSE;
			ValaMethod* _tmp2021_;
			_tmp2021_ = m;
			if (_tmp2021_ != NULL) {
				ValaMethod* _tmp2022_;
				_tmp2022_ = m;
				_tmp2020_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp2022_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp2020_ = FALSE;
			}
			if (_tmp2020_) {
				ValaCCodeExpression* _tmp2023_;
				_tmp2023_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2023_);
			} else {
				gboolean _tmp2024_ = FALSE;
				gboolean _tmp2025_ = FALSE;
				gboolean _tmp2026_;
				_tmp2026_ = return_result_via_out_param;
				if (!_tmp2026_) {
					_tmp2025_ = !vala_ccode_method_call_module_has_ref_out_argument (self, expr);
				} else {
					_tmp2025_ = FALSE;
				}
				if (_tmp2025_) {
					gboolean _tmp2027_ = FALSE;
					ValaDataType* _tmp2028_;
					_tmp2028_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2028_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp2029_;
						_tmp2029_ = result_type;
						_tmp2027_ = !vala_data_type_is_disposable (_tmp2029_);
					} else {
						_tmp2027_ = FALSE;
					}
					_tmp2024_ = _tmp2027_;
				} else {
					_tmp2024_ = FALSE;
				}
				if (_tmp2024_) {
					ValaCCodeExpression* _tmp2030_;
					_tmp2030_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2030_);
				} else {
					gboolean _tmp2031_;
					_tmp2031_ = return_result_via_out_param;
					if (!_tmp2031_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp2032_;
						ValaDataType* _tmp2033_;
						gboolean _tmp2034_;
						gboolean _tmp2035_;
						ValaLocalVariable* _tmp2036_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp2037_;
						const gchar* _tmp2038_;
						const gchar* _tmp2039_;
						ValaCCodeExpression* _tmp2040_;
						ValaLocalVariable* _tmp2041_;
						ValaCCodeFunction* _tmp2042_;
						ValaCCodeFunction* _tmp2043_;
						ValaCCodeExpression* _tmp2044_;
						ValaCCodeExpression* _tmp2045_;
						ValaCCodeExpression* _tmp2046_;
						ValaTargetValue* _tmp2047_;
						ValaTargetValue* _tmp2048_;
						_tmp2032_ = result_type;
						_tmp2033_ = result_type;
						_tmp2034_ = vala_data_type_get_value_owned (_tmp2033_);
						_tmp2035_ = _tmp2034_;
						_tmp2036_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp2032_, _tmp2035_, NULL, FALSE);
						temp_var = _tmp2036_;
						_tmp2037_ = temp_var;
						_tmp2038_ = vala_symbol_get_name ((ValaSymbol*) _tmp2037_);
						_tmp2039_ = _tmp2038_;
						_tmp2040_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp2039_);
						temp_ref = _tmp2040_;
						_tmp2041_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp2041_, FALSE);
						_tmp2042_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp2043_ = _tmp2042_;
						_tmp2044_ = temp_ref;
						_tmp2045_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp2043_, _tmp2044_, _tmp2045_);
						_tmp2046_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2046_);
						_tmp2047_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2048_ = _tmp2047_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2048_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp2049_;
						ValaTargetValue* _tmp2050_;
						ValaTargetValue* _tmp2051_;
						_tmp2049_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp2049_);
						_tmp2050_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp2051_ = _tmp2050_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp2051_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp2052_ = params;
	_tmp2053_ = vala_iterable_iterator ((ValaIterable*) _tmp2052_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp2053_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp2054_;
		gint _arg_size = 0;
		ValaList* _tmp2055_;
		gint _tmp2056_;
		gint _tmp2057_;
		gint _arg_index = 0;
		_tmp2054_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp2054_;
		_tmp2055_ = _arg_list;
		_tmp2056_ = vala_collection_get_size ((ValaCollection*) _tmp2055_);
		_tmp2057_ = _tmp2056_;
		_arg_size = _tmp2057_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp2058_;
			gint _tmp2059_;
			gint _tmp2060_;
			ValaExpression* arg = NULL;
			ValaList* _tmp2061_;
			gint _tmp2062_;
			gpointer _tmp2063_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2064_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2067_;
			ValaUnaryExpression* _tmp2068_;
			gboolean _tmp2069_ = FALSE;
			ValaUnaryExpression* _tmp2070_;
			ValaUnaryExpression* _tmp2074_;
			ValaExpression* _tmp2075_;
			ValaExpression* _tmp2076_;
			ValaDataType* _tmp2077_;
			ValaDataType* _tmp2078_;
			ValaUnaryExpression* _tmp2088_;
			ValaExpression* _tmp2089_;
			ValaExpression* _tmp2090_;
			ValaTargetValue* _tmp2091_;
			ValaTargetValue* _tmp2092_;
			ValaUnaryExpression* _tmp2093_;
			ValaTargetValue* _tmp2094_;
			ValaTargetValue* _tmp2095_;
			ValaUnaryExpression* _tmp2096_;
			ValaExpression* _tmp2097_;
			ValaExpression* _tmp2098_;
			ValaDataType* _tmp2099_;
			ValaDataType* _tmp2100_;
			ValaExpression* _tmp2101_;
			ValaTargetValue* _tmp2102_;
			ValaTargetValue* _tmp2103_;
			ValaSourceReference* _tmp2104_;
			ValaSourceReference* _tmp2105_;
			gboolean _tmp2106_ = FALSE;
			ValaParameter* _tmp2107_;
			_tmp2058_ = _arg_index;
			_arg_index = _tmp2058_ + 1;
			_tmp2059_ = _arg_index;
			_tmp2060_ = _arg_size;
			if (!(_tmp2059_ < _tmp2060_)) {
				break;
			}
			_tmp2061_ = _arg_list;
			_tmp2062_ = _arg_index;
			_tmp2063_ = vala_list_get (_tmp2061_, _tmp2062_);
			arg = (ValaExpression*) _tmp2063_;
			param = NULL;
			_tmp2064_ = params_it;
			if (vala_iterator_next (_tmp2064_)) {
				ValaIterator* _tmp2065_;
				gpointer _tmp2066_;
				_tmp2065_ = params_it;
				_tmp2066_ = vala_iterator_get (_tmp2065_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2066_;
			}
			_tmp2067_ = arg;
			_tmp2068_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2067_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2067_) : NULL);
			unary = _tmp2068_;
			_tmp2070_ = unary;
			if (_tmp2070_ == NULL) {
				_tmp2069_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2071_;
				ValaUnaryOperator _tmp2072_;
				ValaUnaryOperator _tmp2073_;
				_tmp2071_ = unary;
				_tmp2072_ = vala_unary_expression_get_operator (_tmp2071_);
				_tmp2073_ = _tmp2072_;
				_tmp2069_ = _tmp2073_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2069_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2074_ = unary;
			_tmp2075_ = vala_unary_expression_get_inner (_tmp2074_);
			_tmp2076_ = _tmp2075_;
			_tmp2077_ = vala_expression_get_value_type (_tmp2076_);
			_tmp2078_ = _tmp2077_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2078_)) {
				ValaCCodeFunction* _tmp2079_;
				ValaCCodeFunction* _tmp2080_;
				ValaUnaryExpression* _tmp2081_;
				ValaExpression* _tmp2082_;
				ValaExpression* _tmp2083_;
				ValaTargetValue* _tmp2084_;
				ValaTargetValue* _tmp2085_;
				ValaCCodeExpression* _tmp2086_;
				ValaCCodeExpression* _tmp2087_;
				_tmp2079_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2080_ = _tmp2079_;
				_tmp2081_ = unary;
				_tmp2082_ = vala_unary_expression_get_inner (_tmp2081_);
				_tmp2083_ = _tmp2082_;
				_tmp2084_ = vala_expression_get_target_value (_tmp2083_);
				_tmp2085_ = _tmp2084_;
				_tmp2086_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2085_, FALSE);
				_tmp2087_ = _tmp2086_;
				vala_ccode_function_add_expression (_tmp2080_, _tmp2087_);
				_vala_ccode_node_unref0 (_tmp2087_);
			}
			_tmp2088_ = unary;
			_tmp2089_ = vala_unary_expression_get_inner (_tmp2088_);
			_tmp2090_ = _tmp2089_;
			_tmp2091_ = vala_expression_get_target_value (_tmp2090_);
			_tmp2092_ = _tmp2091_;
			_tmp2093_ = unary;
			_tmp2094_ = vala_expression_get_target_value ((ValaExpression*) _tmp2093_);
			_tmp2095_ = _tmp2094_;
			_tmp2096_ = unary;
			_tmp2097_ = vala_unary_expression_get_inner (_tmp2096_);
			_tmp2098_ = _tmp2097_;
			_tmp2099_ = vala_expression_get_value_type (_tmp2098_);
			_tmp2100_ = _tmp2099_;
			_tmp2101_ = arg;
			_tmp2102_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2095_, _tmp2100_, (ValaCodeNode*) _tmp2101_);
			_tmp2103_ = _tmp2102_;
			_tmp2104_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2105_ = _tmp2104_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2092_, _tmp2103_, _tmp2105_);
			_vala_target_value_unref0 (_tmp2103_);
			_tmp2107_ = param;
			if (_tmp2107_ != NULL) {
				ValaParameter* _tmp2108_;
				_tmp2108_ = param;
				_tmp2106_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2108_);
			} else {
				_tmp2106_ = FALSE;
			}
			if (_tmp2106_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2109_;
				ValaCCodeIdentifier* _tmp2110_;
				ValaCCodeFunctionCall* _tmp2111_;
				ValaCCodeFunctionCall* _tmp2112_;
				ValaCCodeFunctionCall* _tmp2113_;
				ValaUnaryExpression* _tmp2114_;
				ValaExpression* _tmp2115_;
				ValaExpression* _tmp2116_;
				ValaTargetValue* _tmp2117_;
				ValaTargetValue* _tmp2118_;
				ValaCCodeExpression* _tmp2119_;
				ValaCCodeExpression* _tmp2120_;
				ValaCCodeFunction* _tmp2121_;
				ValaCCodeFunction* _tmp2122_;
				ValaUnaryExpression* _tmp2123_;
				ValaExpression* _tmp2124_;
				ValaExpression* _tmp2125_;
				ValaTargetValue* _tmp2126_;
				ValaTargetValue* _tmp2127_;
				ValaCCodeExpression* _tmp2128_;
				ValaCCodeExpression* _tmp2129_;
				ValaCCodeFunctionCall* _tmp2130_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2109_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2110_ = _tmp2109_;
				_tmp2111_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2110_);
				_tmp2112_ = _tmp2111_;
				_vala_ccode_node_unref0 (_tmp2110_);
				len_call = _tmp2112_;
				_tmp2113_ = len_call;
				_tmp2114_ = unary;
				_tmp2115_ = vala_unary_expression_get_inner (_tmp2114_);
				_tmp2116_ = _tmp2115_;
				_tmp2117_ = vala_expression_get_target_value (_tmp2116_);
				_tmp2118_ = _tmp2117_;
				_tmp2119_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2118_);
				_tmp2120_ = _tmp2119_;
				vala_ccode_function_call_add_argument (_tmp2113_, _tmp2120_);
				_vala_ccode_node_unref0 (_tmp2120_);
				_tmp2121_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2122_ = _tmp2121_;
				_tmp2123_ = unary;
				_tmp2124_ = vala_unary_expression_get_inner (_tmp2123_);
				_tmp2125_ = _tmp2124_;
				_tmp2126_ = vala_expression_get_target_value (_tmp2125_);
				_tmp2127_ = _tmp2126_;
				_tmp2128_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2127_, 1);
				_tmp2129_ = _tmp2128_;
				_tmp2130_ = len_call;
				vala_ccode_function_add_assignment (_tmp2122_, _tmp2129_, (ValaCCodeExpression*) _tmp2130_);
				_vala_ccode_node_unref0 (_tmp2129_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2133_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2133_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2134_;
		ValaSymbol* _tmp2135_;
		ValaSymbol* _tmp2136_;
		_tmp2134_ = m;
		_tmp2135_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2134_);
		_tmp2136_ = _tmp2135_;
		_tmp2132_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2136_, VALA_TYPE_CLASS);
	} else {
		_tmp2132_ = FALSE;
	}
	if (_tmp2132_) {
		gboolean _tmp2137_ = FALSE;
		gboolean _tmp2138_ = FALSE;
		ValaClass* _tmp2139_;
		ValaClass* _tmp2140_;
		gboolean _tmp2141_;
		gboolean _tmp2142_;
		_tmp2139_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2140_ = _tmp2139_;
		_tmp2141_ = vala_class_get_is_compact (_tmp2140_);
		_tmp2142_ = _tmp2141_;
		if (_tmp2142_) {
			ValaClass* _tmp2143_;
			ValaClass* _tmp2144_;
			ValaClass* _tmp2145_;
			ValaClass* _tmp2146_;
			_tmp2143_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2144_ = _tmp2143_;
			_tmp2145_ = vala_class_get_base_class (_tmp2144_);
			_tmp2146_ = _tmp2145_;
			_tmp2138_ = _tmp2146_ != NULL;
		} else {
			_tmp2138_ = FALSE;
		}
		if (_tmp2138_) {
			_tmp2137_ = TRUE;
		} else {
			ValaClass* _tmp2147_;
			ValaClass* _tmp2148_;
			ValaClass* _tmp2149_;
			ValaClass* _tmp2150_;
			ValaClass* _tmp2151_;
			_tmp2147_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2148_ = _tmp2147_;
			_tmp2149_ = vala_class_get_base_class (_tmp2148_);
			_tmp2150_ = _tmp2149_;
			_tmp2151_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2137_ = _tmp2150_ == _tmp2151_;
		}
		_tmp2131_ = _tmp2137_;
	} else {
		_tmp2131_ = FALSE;
	}
	if (_tmp2131_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2152_;
		ValaClass* _tmp2153_;
		gchar* _tmp2154_;
		gchar* _tmp2155_;
		gchar* _tmp2156_;
		gchar* _tmp2157_;
		ValaCCodeIdentifier* _tmp2158_;
		ValaCCodeIdentifier* _tmp2159_;
		ValaCCodeFunctionCall* _tmp2160_;
		ValaCCodeFunctionCall* _tmp2161_;
		ValaCCodeFunctionCall* _tmp2162_;
		ValaCCodeExpression* _tmp2163_;
		ValaCCodeExpression* _tmp2164_;
		ValaCCodeFunction* _tmp2165_;
		ValaCCodeFunction* _tmp2166_;
		ValaCCodeFunctionCall* _tmp2167_;
		_tmp2152_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2153_ = _tmp2152_;
		_tmp2154_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2153_, NULL);
		_tmp2155_ = _tmp2154_;
		_tmp2156_ = g_strdup_printf ("%s_instance_init", _tmp2155_);
		_tmp2157_ = _tmp2156_;
		_tmp2158_ = vala_ccode_identifier_new (_tmp2157_);
		_tmp2159_ = _tmp2158_;
		_tmp2160_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2159_);
		_tmp2161_ = _tmp2160_;
		_vala_ccode_node_unref0 (_tmp2159_);
		_g_free0 (_tmp2157_);
		_g_free0 (_tmp2155_);
		cinitcall = _tmp2161_;
		_tmp2162_ = cinitcall;
		_tmp2163_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2164_ = _tmp2163_;
		vala_ccode_function_call_add_argument (_tmp2162_, _tmp2164_);
		_vala_ccode_node_unref0 (_tmp2164_);
		_tmp2165_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2166_ = _tmp2165_;
		_tmp2167_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2166_, (ValaCCodeExpression*) _tmp2167_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_argument (ValaCCodeMethodCallModule* self,
                                                    ValaMethodCall* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp0_;
		gint _arg_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _arg_index = 0;
		_tmp0_ = vala_method_call_get_argument_list (c);
		_arg_list = _tmp0_;
		_tmp1_ = _arg_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_arg_size = _tmp3_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaExpression* arg = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaUnaryExpression* _tmp12_;
			_tmp4_ = _arg_index;
			_arg_index = _tmp4_ + 1;
			_tmp5_ = _arg_index;
			_tmp6_ = _arg_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _arg_list;
			_tmp8_ = _arg_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			arg = (ValaExpression*) _tmp9_;
			_tmp10_ = arg;
			unary = G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp10_) : NULL;
			_tmp12_ = unary;
			if (_tmp12_ != NULL) {
				gboolean _tmp13_ = FALSE;
				ValaUnaryExpression* _tmp14_;
				ValaUnaryOperator _tmp15_;
				ValaUnaryOperator _tmp16_;
				_tmp14_ = unary;
				_tmp15_ = vala_unary_expression_get_operator (_tmp14_);
				_tmp16_ = _tmp15_;
				if (_tmp16_ == VALA_UNARY_OPERATOR_OUT) {
					_tmp13_ = TRUE;
				} else {
					ValaUnaryExpression* _tmp17_;
					ValaUnaryOperator _tmp18_;
					ValaUnaryOperator _tmp19_;
					_tmp17_ = unary;
					_tmp18_ = vala_unary_expression_get_operator (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp13_ = _tmp19_ == VALA_UNARY_OPERATOR_REF;
				}
				_tmp11_ = _tmp13_;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (arg);
				_vala_iterable_unref0 (_arg_list);
				return result;
			}
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



