/* valalocalvariable.c generated by valac, the Vala compiler
 * generated from valalocalvariable.vala, do not modify */

/* valalocalvariable.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))

struct _ValaLocalVariablePrivate {
	gboolean _is_result;
	gboolean _captured;
	gboolean _init;
};


static gpointer vala_local_variable_parent_class = NULL;

#define VALA_LOCAL_VARIABLE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariablePrivate))
static void vala_local_variable_real_accept (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static void vala_local_variable_real_accept_children (ValaCodeNode* base,
                                               ValaCodeVisitor* visitor);
static void vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                                  ValaExpression* old_node,
                                                  ValaExpression* new_node);
static void vala_local_variable_real_replace_type (ValaCodeNode* base,
                                            ValaDataType* old_type,
                                            ValaDataType* new_type);
static gboolean vala_local_variable_real_check (ValaCodeNode* base,
                                         ValaCodeContext* context);
static void vala_local_variable_finalize (ValaCodeNode * obj);


/**
 * Creates a new local variable.
 *
 * @param name              name of the variable
 * @param initializer       optional initializer expression
 * @param source_reference  reference to source code
 * @return                  newly created variable declarator
 */
ValaLocalVariable*
vala_local_variable_construct (GType object_type,
                               ValaDataType* variable_type,
                               const gchar* name,
                               ValaExpression* initializer,
                               ValaSourceReference* source_reference)
{
	ValaLocalVariable* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaLocalVariable*) vala_variable_construct (object_type, variable_type, name, initializer, source_reference, NULL);
	return self;
}


ValaLocalVariable*
vala_local_variable_new (ValaDataType* variable_type,
                         const gchar* name,
                         ValaExpression* initializer,
                         ValaSourceReference* source_reference)
{
	return vala_local_variable_construct (VALA_TYPE_LOCAL_VARIABLE, variable_type, name, initializer, source_reference);
}


static void
vala_local_variable_real_accept (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_local_variable (visitor, self);
}


static void
vala_local_variable_real_accept_children (ValaCodeNode* base,
                                          ValaCodeVisitor* visitor)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaDataType* _tmp6_;
	ValaDataType* _tmp7_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaExpression* _tmp2_;
		ValaExpression* _tmp3_;
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp2_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp3_ = _tmp2_;
		vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
		_tmp4_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp5_ = _tmp4_;
		vala_code_visitor_visit_end_full_expression (visitor, _tmp5_);
	}
	_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaDataType* _tmp8_;
		ValaDataType* _tmp9_;
		_tmp8_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
}


static void
vala_local_variable_real_replace_expression (ValaCodeNode* base,
                                             ValaExpression* old_node,
                                             ValaExpression* new_node)
{
	ValaLocalVariable * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_variable_set_initializer ((ValaVariable*) self, new_node);
	}
}


static void
vala_local_variable_real_replace_type (ValaCodeNode* base,
                                       ValaDataType* old_type,
                                       ValaDataType* new_type)
{
	ValaLocalVariable * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaLocalVariable*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_variable_set_variable_type ((ValaVariable*) self, new_type);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_local_variable_real_check (ValaCodeNode* base,
                                ValaCodeContext* context)
{
	ValaLocalVariable * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaDataType* _tmp4_;
	ValaDataType* _tmp5_;
	gboolean is_initializer_list = FALSE;
	gint initializer_size = 0;
	ValaExpression* _tmp12_;
	ValaExpression* _tmp13_;
	ValaDataType* _tmp26_;
	ValaDataType* _tmp27_;
	gboolean _tmp75_ = FALSE;
	ValaExpression* _tmp76_;
	ValaExpression* _tmp77_;
	ValaSemanticAnalyzer* _tmp198_;
	ValaSemanticAnalyzer* _tmp199_;
	ValaSymbol* _tmp200_;
	ValaSymbol* _tmp201_;
	ValaScope* _tmp202_;
	ValaScope* _tmp203_;
	const gchar* _tmp204_;
	const gchar* _tmp205_;
	ValaBlock* block = NULL;
	ValaSemanticAnalyzer* _tmp206_;
	ValaSemanticAnalyzer* _tmp207_;
	ValaSymbol* _tmp208_;
	ValaSymbol* _tmp209_;
	ValaBlock* _tmp210_;
	ValaBlock* _tmp211_;
	gboolean _tmp213_;
	gboolean _tmp214_;
	self = (ValaLocalVariable*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaDataType* _tmp6_;
		ValaDataType* _tmp7_;
		ValaDataType* _tmp10_;
		ValaDataType* _tmp11_;
		_tmp6_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp7_ = _tmp6_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_VOID_TYPE)) {
			ValaSourceReference* _tmp8_;
			ValaSourceReference* _tmp9_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp9_ = _tmp8_;
			vala_report_error (_tmp9_, "'void' not supported as variable type");
			result = FALSE;
			return result;
		}
		_tmp10_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp11_ = _tmp10_;
		vala_code_node_check ((ValaCodeNode*) _tmp11_, context);
	}
	is_initializer_list = FALSE;
	initializer_size = -1;
	_tmp12_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaExpression* _tmp14_;
		ValaExpression* _tmp15_;
		ValaDataType* _tmp16_;
		ValaDataType* _tmp17_;
		ValaExpression* _tmp18_;
		ValaExpression* _tmp19_;
		ValaExpression* _tmp24_;
		ValaExpression* _tmp25_;
		_tmp14_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp17_ = _tmp16_;
		vala_expression_set_target_type (_tmp15_, _tmp17_);
		_tmp18_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp19_ = _tmp18_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_INITIALIZER_LIST)) {
			ValaExpression* _tmp20_;
			ValaExpression* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			_tmp20_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp21_ = _tmp20_;
			_tmp22_ = vala_initializer_list_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, VALA_TYPE_INITIALIZER_LIST, ValaInitializerList));
			_tmp23_ = _tmp22_;
			initializer_size = _tmp23_;
			is_initializer_list = TRUE;
		}
		_tmp24_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp25_ = _tmp24_;
		vala_code_node_check ((ValaCodeNode*) _tmp25_, context);
	}
	_tmp26_ = vala_variable_get_variable_type ((ValaVariable*) self);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == NULL) {
		ValaExpression* _tmp28_;
		ValaExpression* _tmp29_;
		ValaExpression* _tmp32_;
		ValaExpression* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		gboolean _tmp38_ = FALSE;
		ValaExpression* _tmp39_;
		ValaExpression* _tmp40_;
		ValaDataType* _tmp41_;
		ValaDataType* _tmp42_;
		ValaExpression* _tmp59_;
		ValaExpression* _tmp60_;
		ValaDataType* _tmp61_;
		ValaDataType* _tmp62_;
		ValaDataType* _tmp63_;
		ValaDataType* _tmp64_;
		ValaDataType* _tmp65_;
		ValaDataType* _tmp66_;
		ValaDataType* _tmp67_;
		ValaDataType* _tmp68_;
		ValaExpression* _tmp69_;
		ValaExpression* _tmp70_;
		ValaDataType* _tmp71_;
		ValaDataType* _tmp72_;
		ValaDataType* _tmp73_;
		ValaDataType* _tmp74_;
		_tmp28_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp29_ = _tmp28_;
		if (_tmp29_ == NULL) {
			ValaSourceReference* _tmp30_;
			ValaSourceReference* _tmp31_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp30_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp31_ = _tmp30_;
			vala_report_error (_tmp31_, "var declaration not allowed without initializer");
			result = FALSE;
			return result;
		}
		_tmp32_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_expression_get_value_type (_tmp33_);
		_tmp35_ = _tmp34_;
		if (_tmp35_ == NULL) {
			ValaSourceReference* _tmp36_;
			ValaSourceReference* _tmp37_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp37_ = _tmp36_;
			vala_report_error (_tmp37_, "var declaration not allowed with non-typed initializer");
			result = FALSE;
			return result;
		}
		_tmp39_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = vala_expression_get_value_type (_tmp40_);
		_tmp42_ = _tmp41_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp42_, VALA_TYPE_FIELD_PROTOTYPE)) {
			_tmp38_ = TRUE;
		} else {
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			_tmp43_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp38_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_PROPERTY_PROTOTYPE);
		}
		if (_tmp38_) {
			ValaExpression* _tmp47_;
			ValaExpression* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaSourceReference* _tmp50_;
			ValaExpression* _tmp51_;
			ValaExpression* _tmp52_;
			ValaSymbol* _tmp53_;
			ValaSymbol* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp47_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp48_);
			_tmp50_ = _tmp49_;
			_tmp51_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp52_ = _tmp51_;
			_tmp53_ = vala_expression_get_symbol_reference (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = vala_symbol_get_full_name (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp56_);
			_tmp58_ = _tmp57_;
			vala_report_error (_tmp50_, _tmp58_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
			result = FALSE;
			return result;
		}
		_tmp59_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_expression_get_value_type (_tmp60_);
		_tmp62_ = _tmp61_;
		_tmp63_ = vala_data_type_copy (_tmp62_);
		_tmp64_ = _tmp63_;
		vala_variable_set_variable_type ((ValaVariable*) self, _tmp64_);
		_vala_code_node_unref0 (_tmp64_);
		_tmp65_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp66_ = _tmp65_;
		vala_data_type_set_value_owned (_tmp66_, TRUE);
		_tmp67_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp68_ = _tmp67_;
		vala_data_type_set_floating_reference (_tmp68_, FALSE);
		_tmp69_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp70_ = _tmp69_;
		_tmp71_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp72_ = _tmp71_;
		vala_expression_set_target_type (_tmp70_, _tmp72_);
		_tmp73_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp74_ = _tmp73_;
		vala_code_node_check ((ValaCodeNode*) _tmp74_, context);
	}
	_tmp76_ = vala_variable_get_initializer ((ValaVariable*) self);
	_tmp77_ = _tmp76_;
	if (_tmp77_ != NULL) {
		ValaExpression* _tmp78_;
		ValaExpression* _tmp79_;
		gboolean _tmp80_;
		gboolean _tmp81_;
		_tmp78_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp79_ = _tmp78_;
		_tmp80_ = vala_code_node_get_error ((ValaCodeNode*) _tmp79_);
		_tmp81_ = _tmp80_;
		_tmp75_ = !_tmp81_;
	} else {
		_tmp75_ = FALSE;
	}
	if (_tmp75_) {
		ValaExpression* _tmp82_;
		ValaExpression* _tmp83_;
		ValaDataType* _tmp84_;
		ValaDataType* _tmp85_;
		ValaExpression* _tmp131_;
		ValaExpression* _tmp132_;
		ValaDataType* _tmp133_;
		ValaDataType* _tmp134_;
		ValaDataType* _tmp135_;
		ValaDataType* _tmp136_;
		ValaArrayType* variable_array_type = NULL;
		ValaDataType* _tmp151_;
		ValaDataType* _tmp152_;
		ValaArrayType* _tmp153_;
		gboolean _tmp154_ = FALSE;
		gboolean _tmp155_ = FALSE;
		gboolean _tmp156_ = FALSE;
		ValaArrayType* _tmp157_;
		gboolean _tmp173_ = FALSE;
		gboolean _tmp174_ = FALSE;
		ValaArrayType* _tmp175_;
		ValaExpression* _tmp185_;
		ValaExpression* _tmp186_;
		ValaDataType* _tmp187_;
		ValaDataType* _tmp188_;
		_tmp82_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_expression_get_value_type (_tmp83_);
		_tmp85_ = _tmp84_;
		if (_tmp85_ == NULL) {
			gboolean _tmp86_ = FALSE;
			ValaExpression* _tmp87_;
			ValaExpression* _tmp88_;
			gboolean _tmp93_ = FALSE;
			ValaExpression* _tmp94_;
			ValaExpression* _tmp95_;
			ValaSymbol* _tmp96_;
			ValaSymbol* _tmp97_;
			_tmp87_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp88_ = _tmp87_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp88_, VALA_TYPE_MEMBER_ACCESS)) {
				ValaExpression* _tmp89_;
				ValaExpression* _tmp90_;
				_tmp89_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp90_ = _tmp89_;
				_tmp86_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp90_, VALA_TYPE_LAMBDA_EXPRESSION);
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				ValaSourceReference* _tmp91_;
				ValaSourceReference* _tmp92_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp91_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp92_ = _tmp91_;
				vala_report_error (_tmp92_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
			_tmp94_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp95_ = _tmp94_;
			_tmp96_ = vala_expression_get_symbol_reference (_tmp95_);
			_tmp97_ = _tmp96_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp97_, VALA_TYPE_METHOD)) {
				ValaDataType* _tmp98_;
				ValaDataType* _tmp99_;
				_tmp98_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp99_ = _tmp98_;
				_tmp93_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp99_, VALA_TYPE_DELEGATE_TYPE);
			} else {
				_tmp93_ = FALSE;
			}
			if (_tmp93_) {
				ValaMethod* m = NULL;
				ValaExpression* _tmp100_;
				ValaExpression* _tmp101_;
				ValaSymbol* _tmp102_;
				ValaSymbol* _tmp103_;
				ValaMethod* _tmp104_;
				ValaDelegateType* dt = NULL;
				ValaDataType* _tmp105_;
				ValaDataType* _tmp106_;
				ValaDelegateType* _tmp107_;
				ValaDelegate* cb = NULL;
				ValaDelegateType* _tmp108_;
				ValaDelegate* _tmp109_;
				ValaDelegate* _tmp110_;
				ValaDelegate* _tmp111_;
				ValaDelegate* _tmp112_;
				ValaMethod* _tmp113_;
				ValaDelegateType* _tmp114_;
				ValaExpression* _tmp125_;
				ValaExpression* _tmp126_;
				ValaDataType* _tmp127_;
				ValaDataType* _tmp128_;
				_tmp100_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp101_ = _tmp100_;
				_tmp102_ = vala_expression_get_symbol_reference (_tmp101_);
				_tmp103_ = _tmp102_;
				_tmp104_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp103_, VALA_TYPE_METHOD, ValaMethod));
				m = _tmp104_;
				_tmp105_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp106_ = _tmp105_;
				_tmp107_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp106_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
				dt = _tmp107_;
				_tmp108_ = dt;
				_tmp109_ = vala_delegate_type_get_delegate_symbol (_tmp108_);
				_tmp110_ = _tmp109_;
				_tmp111_ = _vala_code_node_ref0 (_tmp110_);
				cb = _tmp111_;
				_tmp112_ = cb;
				_tmp113_ = m;
				_tmp114_ = dt;
				if (!vala_delegate_matches_method (_tmp112_, _tmp113_, (ValaDataType*) _tmp114_)) {
					ValaSourceReference* _tmp115_;
					ValaSourceReference* _tmp116_;
					ValaMethod* _tmp117_;
					gchar* _tmp118_;
					gchar* _tmp119_;
					ValaDelegate* _tmp120_;
					gchar* _tmp121_;
					gchar* _tmp122_;
					gchar* _tmp123_;
					gchar* _tmp124_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp116_ = _tmp115_;
					_tmp117_ = m;
					_tmp118_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp117_);
					_tmp119_ = _tmp118_;
					_tmp120_ = cb;
					_tmp121_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp120_);
					_tmp122_ = _tmp121_;
					_tmp123_ = g_strdup_printf ("declaration of method `%s' doesn't match declaration of callback `%s'", _tmp119_, _tmp122_);
					_tmp124_ = _tmp123_;
					vala_report_error (_tmp116_, _tmp124_);
					_g_free0 (_tmp124_);
					_g_free0 (_tmp122_);
					_g_free0 (_tmp119_);
					result = FALSE;
					_vala_code_node_unref0 (cb);
					_vala_code_node_unref0 (dt);
					_vala_code_node_unref0 (m);
					return result;
				}
				_tmp125_ = vala_variable_get_initializer ((ValaVariable*) self);
				_tmp126_ = _tmp125_;
				_tmp127_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp128_ = _tmp127_;
				vala_expression_set_value_type (_tmp126_, _tmp128_);
				_vala_code_node_unref0 (cb);
				_vala_code_node_unref0 (dt);
				_vala_code_node_unref0 (m);
			} else {
				ValaSourceReference* _tmp129_;
				ValaSourceReference* _tmp130_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp130_ = _tmp129_;
				vala_report_error (_tmp130_, "expression type not allowed as initializer");
				result = FALSE;
				return result;
			}
		}
		_tmp131_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp132_ = _tmp131_;
		_tmp133_ = vala_expression_get_value_type (_tmp132_);
		_tmp134_ = _tmp133_;
		_tmp135_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp136_ = _tmp135_;
		if (!vala_data_type_compatible (_tmp134_, _tmp136_)) {
			ValaSourceReference* _tmp137_;
			ValaSourceReference* _tmp138_;
			ValaExpression* _tmp139_;
			ValaExpression* _tmp140_;
			ValaDataType* _tmp141_;
			ValaDataType* _tmp142_;
			gchar* _tmp143_;
			gchar* _tmp144_;
			ValaDataType* _tmp145_;
			ValaDataType* _tmp146_;
			gchar* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			gchar* _tmp150_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp137_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp138_ = _tmp137_;
			_tmp139_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp140_ = _tmp139_;
			_tmp141_ = vala_expression_get_value_type (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = vala_code_node_to_string ((ValaCodeNode*) _tmp142_);
			_tmp144_ = _tmp143_;
			_tmp145_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp146_ = _tmp145_;
			_tmp147_ = vala_code_node_to_string ((ValaCodeNode*) _tmp146_);
			_tmp148_ = _tmp147_;
			_tmp149_ = g_strdup_printf ("Assignment: Cannot convert from `%s' to `%s'", _tmp144_, _tmp148_);
			_tmp150_ = _tmp149_;
			vala_report_error (_tmp138_, _tmp150_);
			_g_free0 (_tmp150_);
			_g_free0 (_tmp148_);
			_g_free0 (_tmp144_);
			result = FALSE;
			return result;
		}
		_tmp151_ = vala_variable_get_variable_type ((ValaVariable*) self);
		_tmp152_ = _tmp151_;
		_tmp153_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp152_, VALA_TYPE_ARRAY_TYPE) ? ((ValaArrayType*) _tmp152_) : NULL);
		variable_array_type = _tmp153_;
		_tmp157_ = variable_array_type;
		if (_tmp157_ != NULL) {
			ValaArrayType* _tmp158_;
			gboolean _tmp159_;
			gboolean _tmp160_;
			_tmp158_ = variable_array_type;
			_tmp159_ = vala_array_type_get_inline_allocated (_tmp158_);
			_tmp160_ = _tmp159_;
			_tmp156_ = _tmp160_;
		} else {
			_tmp156_ = FALSE;
		}
		if (_tmp156_) {
			ValaArrayType* _tmp161_;
			gboolean _tmp162_;
			gboolean _tmp163_;
			_tmp161_ = variable_array_type;
			_tmp162_ = vala_array_type_get_fixed_length (_tmp161_);
			_tmp163_ = _tmp162_;
			_tmp155_ = !_tmp163_;
		} else {
			_tmp155_ = FALSE;
		}
		if (_tmp155_) {
			gboolean _tmp164_;
			_tmp164_ = is_initializer_list;
			_tmp154_ = _tmp164_;
		} else {
			_tmp154_ = FALSE;
		}
		if (_tmp154_) {
			ValaArrayType* _tmp165_;
			gint _tmp166_;
			gchar* _tmp167_;
			gchar* _tmp168_;
			ValaIntegerLiteral* _tmp169_;
			ValaIntegerLiteral* _tmp170_;
			ValaArrayType* _tmp171_;
			ValaArrayType* _tmp172_;
			_tmp165_ = variable_array_type;
			_tmp166_ = initializer_size;
			_tmp167_ = g_strdup_printf ("%i", _tmp166_);
			_tmp168_ = _tmp167_;
			_tmp169_ = vala_integer_literal_new (_tmp168_, NULL);
			_tmp170_ = _tmp169_;
			vala_array_type_set_length (_tmp165_, (ValaExpression*) _tmp170_);
			_vala_code_node_unref0 (_tmp170_);
			_g_free0 (_tmp168_);
			_tmp171_ = variable_array_type;
			vala_array_type_set_fixed_length (_tmp171_, TRUE);
			_tmp172_ = variable_array_type;
			vala_data_type_set_nullable ((ValaDataType*) _tmp172_, FALSE);
		}
		_tmp175_ = variable_array_type;
		if (_tmp175_ != NULL) {
			ValaArrayType* _tmp176_;
			gboolean _tmp177_;
			gboolean _tmp178_;
			_tmp176_ = variable_array_type;
			_tmp177_ = vala_array_type_get_inline_allocated (_tmp176_);
			_tmp178_ = _tmp177_;
			_tmp174_ = _tmp178_;
		} else {
			_tmp174_ = FALSE;
		}
		if (_tmp174_) {
			ValaExpression* _tmp179_;
			ValaExpression* _tmp180_;
			ValaDataType* _tmp181_;
			ValaDataType* _tmp182_;
			_tmp179_ = vala_variable_get_initializer ((ValaVariable*) self);
			_tmp180_ = _tmp179_;
			_tmp181_ = vala_expression_get_value_type (_tmp180_);
			_tmp182_ = _tmp181_;
			_tmp173_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, VALA_TYPE_ARRAY_TYPE) == FALSE;
		} else {
			_tmp173_ = FALSE;
		}
		if (_tmp173_) {
			ValaSourceReference* _tmp183_;
			ValaSourceReference* _tmp184_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp184_ = _tmp183_;
			vala_report_error (_tmp184_, "only arrays are allowed as initializer for arrays with fixed length");
			result = FALSE;
			_vala_code_node_unref0 (variable_array_type);
			return result;
		}
		_tmp185_ = vala_variable_get_initializer ((ValaVariable*) self);
		_tmp186_ = _tmp185_;
		_tmp187_ = vala_expression_get_value_type (_tmp186_);
		_tmp188_ = _tmp187_;
		if (vala_data_type_is_disposable (_tmp188_)) {
			gboolean _tmp189_ = FALSE;
			ValaDataType* _tmp190_;
			ValaDataType* _tmp191_;
			_tmp190_ = vala_variable_get_variable_type ((ValaVariable*) self);
			_tmp191_ = _tmp190_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp191_, VALA_TYPE_POINTER_TYPE)) {
				ValaDataType* _tmp192_;
				ValaDataType* _tmp193_;
				gboolean _tmp194_;
				gboolean _tmp195_;
				_tmp192_ = vala_variable_get_variable_type ((ValaVariable*) self);
				_tmp193_ = _tmp192_;
				_tmp194_ = vala_data_type_get_value_owned (_tmp193_);
				_tmp195_ = _tmp194_;
				_tmp189_ = !_tmp195_;
			} else {
				_tmp189_ = FALSE;
			}
			if (_tmp189_) {
				ValaSourceReference* _tmp196_;
				ValaSourceReference* _tmp197_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp196_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp197_ = _tmp196_;
				vala_report_error (_tmp197_, "Invalid assignment from owned expression to unowned variable");
				result = FALSE;
				_vala_code_node_unref0 (variable_array_type);
				return result;
			}
		}
		_vala_code_node_unref0 (variable_array_type);
	}
	_tmp198_ = vala_code_context_get_analyzer (context);
	_tmp199_ = _tmp198_;
	_tmp200_ = vala_semantic_analyzer_get_current_symbol (_tmp199_);
	_tmp201_ = _tmp200_;
	_tmp202_ = vala_symbol_get_scope (_tmp201_);
	_tmp203_ = _tmp202_;
	_tmp204_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp205_ = _tmp204_;
	vala_scope_add (_tmp203_, _tmp205_, (ValaSymbol*) self);
	_tmp206_ = vala_code_context_get_analyzer (context);
	_tmp207_ = _tmp206_;
	_tmp208_ = vala_semantic_analyzer_get_current_symbol (_tmp207_);
	_tmp209_ = _tmp208_;
	_tmp210_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp209_, VALA_TYPE_BLOCK) ? ((ValaBlock*) _tmp209_) : NULL);
	block = _tmp210_;
	_tmp211_ = block;
	if (_tmp211_ != NULL) {
		ValaBlock* _tmp212_;
		_tmp212_ = block;
		vala_block_add_local_variable (_tmp212_, self);
	}
	vala_symbol_set_active ((ValaSymbol*) self, TRUE);
	_tmp213_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp214_ = _tmp213_;
	result = !_tmp214_;
	_vala_code_node_unref0 (block);
	return result;
}


gboolean
vala_local_variable_get_is_result (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_result;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_is_result (ValaLocalVariable* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_result = value;
}


gboolean
vala_local_variable_get_captured (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_captured;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_captured (ValaLocalVariable* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_captured = value;
}


gboolean
vala_local_variable_get_init (ValaLocalVariable* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_init;
	result = _tmp0_;
	return result;
}


void
vala_local_variable_set_init (ValaLocalVariable* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_init = value;
}


static void
vala_local_variable_class_init (ValaLocalVariableClass * klass)
{
	vala_local_variable_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_local_variable_finalize;
	g_type_class_add_private (klass, sizeof (ValaLocalVariablePrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_local_variable_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_local_variable_real_replace_expression;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode*, ValaDataType*, ValaDataType*)) vala_local_variable_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_local_variable_real_check;
}


static void
vala_local_variable_instance_init (ValaLocalVariable * self)
{
	self->priv = VALA_LOCAL_VARIABLE_GET_PRIVATE (self);
}


static void
vala_local_variable_finalize (ValaCodeNode * obj)
{
	ValaLocalVariable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_LOCAL_VARIABLE, ValaLocalVariable);
	VALA_CODE_NODE_CLASS (vala_local_variable_parent_class)->finalize (obj);
}


/**
 * Represents a local variable declaration in the source code.
 */
GType
vala_local_variable_get_type (void)
{
	static volatile gsize vala_local_variable_type_id__volatile = 0;
	if (g_once_init_enter (&vala_local_variable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLocalVariableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_local_variable_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLocalVariable), 0, (GInstanceInitFunc) vala_local_variable_instance_init, NULL };
		GType vala_local_variable_type_id;
		vala_local_variable_type_id = g_type_register_static (VALA_TYPE_VARIABLE, "ValaLocalVariable", &g_define_type_info, 0);
		g_once_init_leave (&vala_local_variable_type_id__volatile, vala_local_variable_type_id);
	}
	return vala_local_variable_type_id__volatile;
}



