/* valagerrormodule.c generated by valac, the Vala compiler
 * generated from valagerrormodule.vala, do not modify */

/* valagerrormodule.vala
 *
 * Copyright (C) 2008-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Jürg Billeter <j@bitron.ch>
 *	Thijs Vermeir <thijsvermeir@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))

struct _ValaGErrorModulePrivate {
	gint current_try_id;
	gint next_try_id;
	gboolean is_in_catch;
};


static gpointer vala_gerror_module_parent_class = NULL;

#define VALA_GERROR_MODULE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_GERROR_MODULE, ValaGErrorModulePrivate))
static void vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                                ValaErrorDomain* edomain,
                                                                ValaCCodeFile* decl_space);
static void vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                                 ValaErrorDomain* edomain);
static void vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                                    ValaThrowStatement* stmt);
static void vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                                    ValaCCodeExpression* error_expr);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static void vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                                  ValaCCodeExpression* inner_error,
                                                  gboolean unexpected);
static gboolean vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                              ValaCodeNode* node);
static void vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                               ValaCodeNode* node,
                                               gboolean always_fails);
static void vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                                  ValaTryStatement* stmt);
static void vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                                 ValaCatchClause* clause);
static void vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                                ValaSymbol* sym,
                                                ValaCodeNode* stop_at);
static void vala_gerror_module_finalize (ValaCodeVisitor * obj);


static void
vala_gerror_module_real_generate_error_domain_declaration (ValaCCodeBaseModule* base,
                                                           ValaErrorDomain* edomain,
                                                           ValaCCodeFile* decl_space)
{
	ValaGErrorModule * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_;
	ValaCCodeEnum* cenum = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	ValaCCodeEnum* _tmp5_;
	ValaCCodeEnum* _tmp6_;
	ValaCCodeEnum* _tmp40_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	ValaCCodeMacroReplacement* error_domain_define = NULL;
	gchar* _tmp45_;
	gchar* _tmp46_;
	const gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	ValaCCodeMacroReplacement* _tmp50_;
	ValaCCodeMacroReplacement* _tmp51_;
	ValaCCodeMacroReplacement* _tmp52_;
	ValaCCodeFunction* cquark_fun = NULL;
	const gchar* _tmp53_;
	ValaDataType* _tmp54_;
	ValaTypeSymbol* _tmp55_;
	ValaTypeSymbol* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	ValaCCodeFunction* _tmp59_;
	ValaCCodeFunction* _tmp60_;
	ValaCCodeFunction* _tmp61_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	g_return_if_fail (decl_space != NULL);
	_tmp0_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_add_symbol_declaration ((ValaCCodeBaseModule*) self, decl_space, (ValaSymbol*) edomain, _tmp1_);
	_g_free0 (_tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = vala_get_ccode_name ((ValaCodeNode*) edomain);
	_tmp4_ = _tmp3_;
	_tmp5_ = vala_ccode_enum_new (_tmp4_);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	cenum = _tmp6_;
	{
		ValaList* _ecode_list = NULL;
		ValaList* _tmp7_;
		gint _ecode_size = 0;
		ValaList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _ecode_index = 0;
		_tmp7_ = vala_error_domain_get_codes (edomain);
		_ecode_list = _tmp7_;
		_tmp8_ = _ecode_list;
		_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_ecode_size = _tmp10_;
		_ecode_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			ValaErrorCode* ecode = NULL;
			ValaList* _tmp14_;
			gint _tmp15_;
			gpointer _tmp16_;
			ValaErrorCode* _tmp17_;
			ValaExpression* _tmp18_;
			ValaExpression* _tmp19_;
			_tmp11_ = _ecode_index;
			_ecode_index = _tmp11_ + 1;
			_tmp12_ = _ecode_index;
			_tmp13_ = _ecode_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _ecode_list;
			_tmp15_ = _ecode_index;
			_tmp16_ = vala_list_get (_tmp14_, _tmp15_);
			ecode = (ValaErrorCode*) _tmp16_;
			_tmp17_ = ecode;
			_tmp18_ = vala_error_code_get_value (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ == NULL) {
				ValaCCodeEnum* _tmp20_;
				ValaErrorCode* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				ValaCCodeEnumValue* _tmp24_;
				ValaCCodeEnumValue* _tmp25_;
				_tmp20_ = cenum;
				_tmp21_ = ecode;
				_tmp22_ = vala_get_ccode_name ((ValaCodeNode*) _tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = vala_ccode_enum_value_new (_tmp23_, NULL);
				_tmp25_ = _tmp24_;
				vala_ccode_enum_add_value (_tmp20_, _tmp25_);
				_vala_ccode_node_unref0 (_tmp25_);
				_g_free0 (_tmp23_);
			} else {
				ValaErrorCode* _tmp26_;
				ValaExpression* _tmp27_;
				ValaExpression* _tmp28_;
				ValaCCodeEnum* _tmp29_;
				ValaErrorCode* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				ValaErrorCode* _tmp33_;
				ValaExpression* _tmp34_;
				ValaExpression* _tmp35_;
				ValaCCodeExpression* _tmp36_;
				ValaCCodeExpression* _tmp37_;
				ValaCCodeEnumValue* _tmp38_;
				ValaCCodeEnumValue* _tmp39_;
				_tmp26_ = ecode;
				_tmp27_ = vala_error_code_get_value (_tmp26_);
				_tmp28_ = _tmp27_;
				vala_code_node_emit ((ValaCodeNode*) _tmp28_, (ValaCodeGenerator*) self);
				_tmp29_ = cenum;
				_tmp30_ = ecode;
				_tmp31_ = vala_get_ccode_name ((ValaCodeNode*) _tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = ecode;
				_tmp34_ = vala_error_code_get_value (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = vala_ccode_enum_value_new (_tmp32_, _tmp37_);
				_tmp39_ = _tmp38_;
				vala_ccode_enum_add_value (_tmp29_, _tmp39_);
				_vala_ccode_node_unref0 (_tmp39_);
				_vala_ccode_node_unref0 (_tmp37_);
				_g_free0 (_tmp32_);
			}
			_vala_code_node_unref0 (ecode);
		}
		_vala_iterable_unref0 (_ecode_list);
	}
	_tmp40_ = cenum;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp40_);
	_tmp41_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_strconcat (_tmp42_, "quark", NULL);
	_tmp44_ = _tmp43_;
	_g_free0 (_tmp42_);
	quark_fun_name = _tmp44_;
	_tmp45_ = vala_get_ccode_upper_case_name ((ValaSymbol*) edomain, NULL);
	_tmp46_ = _tmp45_;
	_tmp47_ = quark_fun_name;
	_tmp48_ = g_strconcat (_tmp47_, " ()", NULL);
	_tmp49_ = _tmp48_;
	_tmp50_ = vala_ccode_macro_replacement_new (_tmp46_, _tmp49_);
	_tmp51_ = _tmp50_;
	_g_free0 (_tmp49_);
	_g_free0 (_tmp46_);
	error_domain_define = _tmp51_;
	_tmp52_ = error_domain_define;
	vala_ccode_file_add_type_definition (decl_space, (ValaCCodeNode*) _tmp52_);
	_tmp53_ = quark_fun_name;
	_tmp54_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp55_ = vala_data_type_get_data_type (_tmp54_);
	_tmp56_ = _tmp55_;
	_tmp57_ = vala_get_ccode_name ((ValaCodeNode*) _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = vala_ccode_function_new (_tmp53_, _tmp58_);
	_tmp60_ = _tmp59_;
	_g_free0 (_tmp58_);
	cquark_fun = _tmp60_;
	_tmp61_ = cquark_fun;
	vala_ccode_file_add_function_declaration (decl_space, _tmp61_);
	_vala_ccode_node_unref0 (cquark_fun);
	_vala_ccode_node_unref0 (error_domain_define);
	_g_free0 (quark_fun_name);
	_vala_ccode_node_unref0 (cenum);
}


static void
vala_gerror_module_real_visit_error_domain (ValaCodeVisitor* base,
                                            ValaErrorDomain* edomain)
{
	ValaGErrorModule * self;
	ValaComment* _tmp0_;
	ValaComment* _tmp1_;
	ValaCCodeFile* _tmp9_;
	gchar* quark_fun_name = NULL;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	ValaCCodeFunction* cquark_fun = NULL;
	ValaDataType* _tmp16_;
	ValaTypeSymbol* _tmp17_;
	ValaTypeSymbol* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	ValaCCodeFunction* _tmp21_;
	ValaCCodeFunction* _tmp22_;
	ValaCCodeFunctionCall* cquark_call = NULL;
	ValaCCodeIdentifier* _tmp23_;
	ValaCCodeIdentifier* _tmp24_;
	ValaCCodeFunctionCall* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	ValaCCodeConstant* _tmp33_;
	ValaCCodeConstant* _tmp34_;
	ValaCCodeFunction* _tmp35_;
	ValaCCodeFunction* _tmp36_;
	ValaCCodeFile* _tmp37_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (edomain != NULL);
	_tmp0_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		ValaCCodeFile* _tmp2_;
		ValaComment* _tmp3_;
		ValaComment* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		ValaCCodeComment* _tmp7_;
		ValaCCodeComment* _tmp8_;
		_tmp2_ = ((ValaCCodeBaseModule*) self)->cfile;
		_tmp3_ = vala_symbol_get_comment ((ValaSymbol*) edomain);
		_tmp4_ = _tmp3_;
		_tmp5_ = vala_comment_get_content (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_ccode_comment_new (_tmp6_);
		_tmp8_ = _tmp7_;
		vala_ccode_file_add_type_definition (_tmp2_, (ValaCCodeNode*) _tmp8_);
		_vala_ccode_node_unref0 (_tmp8_);
	}
	_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp9_);
	if (!vala_symbol_is_internal_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp10_;
		_tmp10_ = ((ValaCCodeBaseModule*) self)->header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp10_);
	}
	if (!vala_symbol_is_private_symbol ((ValaSymbol*) edomain)) {
		ValaCCodeFile* _tmp11_;
		_tmp11_ = ((ValaCCodeBaseModule*) self)->internal_header_file;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, edomain, _tmp11_);
	}
	_tmp12_ = vala_get_ccode_lower_case_prefix ((ValaSymbol*) edomain);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp13_, "quark", NULL);
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	quark_fun_name = _tmp15_;
	_tmp16_ = ((ValaCCodeBaseModule*) self)->gquark_type;
	_tmp17_ = vala_data_type_get_data_type (_tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = vala_get_ccode_name ((ValaCodeNode*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_function_new (quark_fun_name, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_);
	cquark_fun = _tmp22_;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, cquark_fun);
	_tmp23_ = vala_ccode_identifier_new ("g_quark_from_static_string");
	_tmp24_ = _tmp23_;
	_tmp25_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp24_);
	_tmp26_ = _tmp25_;
	_vala_ccode_node_unref0 (_tmp24_);
	cquark_call = _tmp26_;
	_tmp27_ = vala_get_ccode_quark_name (edomain);
	_tmp28_ = _tmp27_;
	_tmp29_ = g_strconcat ("\"", _tmp28_, NULL);
	_tmp30_ = _tmp29_;
	_tmp31_ = g_strconcat (_tmp30_, "\"", NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_constant_new (_tmp32_);
	_tmp34_ = _tmp33_;
	vala_ccode_function_call_add_argument (cquark_call, (ValaCCodeExpression*) _tmp34_);
	_vala_ccode_node_unref0 (_tmp34_);
	_g_free0 (_tmp32_);
	_g_free0 (_tmp30_);
	_g_free0 (_tmp28_);
	_tmp35_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp36_ = _tmp35_;
	vala_ccode_function_add_return (_tmp36_, (ValaCCodeExpression*) cquark_call);
	vala_ccode_base_module_pop_function ((ValaCCodeBaseModule*) self);
	_tmp37_ = ((ValaCCodeBaseModule*) self)->cfile;
	vala_ccode_file_add_function (_tmp37_, cquark_fun);
	_vala_ccode_node_unref0 (cquark_call);
	_vala_ccode_node_unref0 (cquark_fun);
	_g_free0 (quark_fun_name);
}


static void
vala_gerror_module_real_visit_throw_statement (ValaCodeVisitor* base,
                                               ValaThrowStatement* stmt)
{
	ValaGErrorModule * self;
	ValaCCodeFunction* _tmp0_;
	ValaCCodeFunction* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	ValaCCodeExpression* _tmp6_;
	ValaCCodeExpression* _tmp7_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_throw_statement_get_error_expression (stmt);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp5_);
	_tmp7_ = _tmp6_;
	vala_ccode_function_add_assignment (_tmp1_, _tmp3_, _tmp7_);
	_vala_ccode_node_unref0 (_tmp7_);
	_vala_ccode_node_unref0 (_tmp3_);
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, TRUE);
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_gerror_module_real_return_with_exception (ValaGErrorModule* self,
                                               ValaCCodeExpression* error_expr)
{
	ValaCCodeFunctionCall* cpropagate = NULL;
	ValaCCodeIdentifier* _tmp0_;
	ValaCCodeIdentifier* _tmp1_;
	ValaCCodeFunctionCall* _tmp2_;
	ValaCCodeFunctionCall* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeIdentifier* _tmp5_;
	ValaCCodeIdentifier* _tmp6_;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	ValaCCodeFunction* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	gboolean _tmp13_ = FALSE;
	ValaMethod* _tmp14_;
	ValaMethod* _tmp15_;
	g_return_if_fail (error_expr != NULL);
	_tmp0_ = vala_ccode_identifier_new ("g_propagate_error");
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1_);
	_tmp3_ = _tmp2_;
	_vala_ccode_node_unref0 (_tmp1_);
	cpropagate = _tmp3_;
	_tmp4_ = cpropagate;
	_tmp5_ = vala_ccode_identifier_new ("error");
	_tmp6_ = _tmp5_;
	vala_ccode_function_call_add_argument (_tmp4_, (ValaCCodeExpression*) _tmp6_);
	_vala_ccode_node_unref0 (_tmp6_);
	_tmp7_ = cpropagate;
	vala_ccode_function_call_add_argument (_tmp7_, error_expr);
	_tmp8_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = cpropagate;
	vala_ccode_function_add_expression (_tmp9_, (ValaCCodeExpression*) _tmp10_);
	_tmp11_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
	_tmp12_ = _tmp11_;
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp12_, FALSE, NULL);
	_tmp14_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp16_;
		ValaMethod* _tmp17_;
		ValaSymbol* _tmp18_;
		ValaSymbol* _tmp19_;
		_tmp16_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_CLASS);
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		ValaClass* cl = NULL;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaSymbol* _tmp22_;
		ValaSymbol* _tmp23_;
		ValaClass* _tmp24_;
		ValaCCodeFunction* _tmp25_;
		ValaCCodeFunction* _tmp26_;
		ValaClass* _tmp27_;
		ValaObjectType* _tmp28_;
		ValaObjectType* _tmp29_;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaGLibValue* _tmp32_;
		ValaGLibValue* _tmp33_;
		ValaCCodeExpression* _tmp34_;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeFunction* _tmp36_;
		ValaCCodeFunction* _tmp37_;
		ValaCCodeConstant* _tmp38_;
		ValaCCodeConstant* _tmp39_;
		_tmp20_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, VALA_TYPE_CLASS, ValaClass));
		cl = _tmp24_;
		_tmp25_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = cl;
		_tmp28_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = vala_ccode_identifier_new ("self");
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_glib_value_new ((ValaDataType*) _tmp29_, (ValaCCodeExpression*) _tmp31_, TRUE);
		_tmp33_ = _tmp32_;
		_tmp34_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, (ValaTargetValue*) _tmp33_, FALSE);
		_tmp35_ = _tmp34_;
		vala_ccode_function_add_expression (_tmp26_, _tmp35_);
		_vala_ccode_node_unref0 (_tmp35_);
		_vala_target_value_unref0 (_tmp33_);
		_vala_ccode_node_unref0 (_tmp31_);
		_vala_code_node_unref0 (_tmp29_);
		_tmp36_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_ccode_constant_new ("NULL");
		_tmp39_ = _tmp38_;
		vala_ccode_function_add_return (_tmp37_, (ValaCCodeExpression*) _tmp39_);
		_vala_ccode_node_unref0 (_tmp39_);
		_vala_code_node_unref0 (cl);
	} else {
		if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
			ValaCCodeFunction* _tmp40_;
			ValaCCodeFunction* _tmp41_;
			ValaCCodeConstant* _tmp42_;
			ValaCCodeConstant* _tmp43_;
			_tmp40_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp41_ = _tmp40_;
			_tmp42_ = vala_ccode_constant_new ("FALSE");
			_tmp43_ = _tmp42_;
			vala_ccode_function_add_return (_tmp41_, (ValaCCodeExpression*) _tmp43_);
			_vala_ccode_node_unref0 (_tmp43_);
		} else {
			ValaDataType* _tmp44_;
			ValaDataType* _tmp45_;
			_tmp44_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
			_tmp45_ = _tmp44_;
			vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp45_, TRUE);
		}
	}
	_vala_ccode_node_unref0 (cpropagate);
}


void
vala_gerror_module_return_with_exception (ValaGErrorModule* self,
                                          ValaCCodeExpression* error_expr)
{
	g_return_if_fail (self != NULL);
	VALA_GERROR_MODULE_GET_CLASS (self)->return_with_exception (self, error_expr);
}


static void
vala_gerror_module_uncaught_error_statement (ValaGErrorModule* self,
                                             ValaCCodeExpression* inner_error,
                                             gboolean unexpected)
{
	ValaSymbol* _tmp0_;
	ValaSymbol* _tmp1_;
	ValaCCodeFunctionCall* ccritical = NULL;
	ValaCCodeIdentifier* _tmp2_;
	ValaCCodeIdentifier* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	const gchar* _tmp6_ = NULL;
	ValaCCodeFunctionCall* _tmp7_;
	ValaCCodeConstant* _tmp8_;
	ValaCCodeConstant* _tmp9_;
	ValaCCodeFunctionCall* _tmp10_;
	ValaCCodeConstant* _tmp11_;
	ValaCCodeConstant* _tmp12_;
	ValaCCodeFunctionCall* _tmp13_;
	ValaCCodeConstant* _tmp14_;
	ValaCCodeConstant* _tmp15_;
	ValaCCodeFunctionCall* _tmp16_;
	ValaCCodeMemberAccess* _tmp17_;
	ValaCCodeMemberAccess* _tmp18_;
	ValaCCodeFunctionCall* domain_name = NULL;
	ValaCCodeIdentifier* _tmp19_;
	ValaCCodeIdentifier* _tmp20_;
	ValaCCodeFunctionCall* _tmp21_;
	ValaCCodeFunctionCall* _tmp22_;
	ValaCCodeFunctionCall* _tmp23_;
	ValaCCodeMemberAccess* _tmp24_;
	ValaCCodeMemberAccess* _tmp25_;
	ValaCCodeFunctionCall* _tmp26_;
	ValaCCodeFunctionCall* _tmp27_;
	ValaCCodeFunctionCall* _tmp28_;
	ValaCCodeMemberAccess* _tmp29_;
	ValaCCodeMemberAccess* _tmp30_;
	ValaCCodeFunctionCall* cclear = NULL;
	ValaCCodeIdentifier* _tmp31_;
	ValaCCodeIdentifier* _tmp32_;
	ValaCCodeFunctionCall* _tmp33_;
	ValaCCodeFunctionCall* _tmp34_;
	ValaCCodeFunctionCall* _tmp35_;
	ValaCCodeUnaryExpression* _tmp36_;
	ValaCCodeUnaryExpression* _tmp37_;
	ValaCCodeFunction* _tmp38_;
	ValaCCodeFunction* _tmp39_;
	ValaCCodeFunctionCall* _tmp40_;
	ValaCCodeFunction* _tmp41_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunctionCall* _tmp43_;
	gboolean _tmp44_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (inner_error != NULL);
	_tmp0_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
	_tmp1_ = _tmp0_;
	vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp1_, FALSE, NULL);
	_tmp2_ = vala_ccode_identifier_new ("g_critical");
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccritical = _tmp5_;
	if (unexpected) {
		_tmp6_ = "\"file %s: line %d: unexpected error: %s (%s, %d)\"";
	} else {
		_tmp6_ = "\"file %s: line %d: uncaught error: %s (%s, %d)\"";
	}
	_tmp7_ = ccritical;
	_tmp8_ = vala_ccode_constant_new (_tmp6_);
	_tmp9_ = _tmp8_;
	vala_ccode_function_call_add_argument (_tmp7_, (ValaCCodeExpression*) _tmp9_);
	_vala_ccode_node_unref0 (_tmp9_);
	_tmp10_ = ccritical;
	_tmp11_ = vala_ccode_constant_new ("__FILE__");
	_tmp12_ = _tmp11_;
	vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_tmp13_ = ccritical;
	_tmp14_ = vala_ccode_constant_new ("__LINE__");
	_tmp15_ = _tmp14_;
	vala_ccode_function_call_add_argument (_tmp13_, (ValaCCodeExpression*) _tmp15_);
	_vala_ccode_node_unref0 (_tmp15_);
	_tmp16_ = ccritical;
	_tmp17_ = vala_ccode_member_access_new_pointer (inner_error, "message");
	_tmp18_ = _tmp17_;
	vala_ccode_function_call_add_argument (_tmp16_, (ValaCCodeExpression*) _tmp18_);
	_vala_ccode_node_unref0 (_tmp18_);
	_tmp19_ = vala_ccode_identifier_new ("g_quark_to_string");
	_tmp20_ = _tmp19_;
	_tmp21_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp20_);
	_tmp22_ = _tmp21_;
	_vala_ccode_node_unref0 (_tmp20_);
	domain_name = _tmp22_;
	_tmp23_ = domain_name;
	_tmp24_ = vala_ccode_member_access_new_pointer (inner_error, "domain");
	_tmp25_ = _tmp24_;
	vala_ccode_function_call_add_argument (_tmp23_, (ValaCCodeExpression*) _tmp25_);
	_vala_ccode_node_unref0 (_tmp25_);
	_tmp26_ = ccritical;
	_tmp27_ = domain_name;
	vala_ccode_function_call_add_argument (_tmp26_, (ValaCCodeExpression*) _tmp27_);
	_tmp28_ = ccritical;
	_tmp29_ = vala_ccode_member_access_new_pointer (inner_error, "code");
	_tmp30_ = _tmp29_;
	vala_ccode_function_call_add_argument (_tmp28_, (ValaCCodeExpression*) _tmp30_);
	_vala_ccode_node_unref0 (_tmp30_);
	_tmp31_ = vala_ccode_identifier_new ("g_clear_error");
	_tmp32_ = _tmp31_;
	_tmp33_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp32_);
	_tmp34_ = _tmp33_;
	_vala_ccode_node_unref0 (_tmp32_);
	cclear = _tmp34_;
	_tmp35_ = cclear;
	_tmp36_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, inner_error);
	_tmp37_ = _tmp36_;
	vala_ccode_function_call_add_argument (_tmp35_, (ValaCCodeExpression*) _tmp37_);
	_vala_ccode_node_unref0 (_tmp37_);
	_tmp38_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp39_ = _tmp38_;
	_tmp40_ = ccritical;
	vala_ccode_function_add_expression (_tmp39_, (ValaCCodeExpression*) _tmp40_);
	_tmp41_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp42_ = _tmp41_;
	_tmp43_ = cclear;
	vala_ccode_function_add_expression (_tmp42_, (ValaCCodeExpression*) _tmp43_);
	if (vala_ccode_base_module_is_in_constructor ((ValaCCodeBaseModule*) self)) {
		_tmp44_ = TRUE;
	} else {
		_tmp44_ = vala_ccode_base_module_is_in_destructor ((ValaCCodeBaseModule*) self);
	}
	if (_tmp44_) {
	} else {
		ValaMethod* _tmp45_;
		ValaMethod* _tmp46_;
		_tmp45_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp46_ = _tmp45_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp47_;
			ValaMethod* _tmp48_;
			ValaSymbol* _tmp49_;
			ValaSymbol* _tmp50_;
			_tmp47_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp48_ = _tmp47_;
			_tmp49_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp48_);
			_tmp50_ = _tmp49_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp50_, VALA_TYPE_STRUCT)) {
				ValaCCodeFunction* _tmp51_;
				ValaCCodeFunction* _tmp52_;
				_tmp51_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp52_ = _tmp51_;
				vala_ccode_function_add_return (_tmp52_, NULL);
			} else {
				ValaCCodeFunction* _tmp53_;
				ValaCCodeFunction* _tmp54_;
				ValaCCodeConstant* _tmp55_;
				ValaCCodeConstant* _tmp56_;
				_tmp53_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = vala_ccode_constant_new ("NULL");
				_tmp56_ = _tmp55_;
				vala_ccode_function_add_return (_tmp54_, (ValaCCodeExpression*) _tmp56_);
				_vala_ccode_node_unref0 (_tmp56_);
			}
		} else {
			if (vala_ccode_base_module_is_in_coroutine ((ValaCCodeBaseModule*) self)) {
				ValaCCodeMemberAccess* async_result_expr = NULL;
				ValaCCodeIdentifier* _tmp57_;
				ValaCCodeIdentifier* _tmp58_;
				ValaCCodeMemberAccess* _tmp59_;
				ValaCCodeMemberAccess* _tmp60_;
				ValaCCodeFunctionCall* unref = NULL;
				ValaCCodeIdentifier* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeFunctionCall* _tmp63_;
				ValaCCodeFunctionCall* _tmp64_;
				ValaCCodeFunctionCall* _tmp65_;
				ValaCCodeMemberAccess* _tmp66_;
				ValaCCodeFunction* _tmp67_;
				ValaCCodeFunction* _tmp68_;
				ValaCCodeFunctionCall* _tmp69_;
				ValaCCodeFunction* _tmp70_;
				ValaCCodeFunction* _tmp71_;
				ValaCCodeConstant* _tmp72_;
				ValaCCodeConstant* _tmp73_;
				_tmp57_ = vala_ccode_identifier_new ("_data_");
				_tmp58_ = _tmp57_;
				_tmp59_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp58_, "_async_result");
				_tmp60_ = _tmp59_;
				_vala_ccode_node_unref0 (_tmp58_);
				async_result_expr = _tmp60_;
				_tmp61_ = vala_ccode_identifier_new ("g_object_unref");
				_tmp62_ = _tmp61_;
				_tmp63_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp62_);
				_tmp64_ = _tmp63_;
				_vala_ccode_node_unref0 (_tmp62_);
				unref = _tmp64_;
				_tmp65_ = unref;
				_tmp66_ = async_result_expr;
				vala_ccode_function_call_add_argument (_tmp65_, (ValaCCodeExpression*) _tmp66_);
				_tmp67_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp68_ = _tmp67_;
				_tmp69_ = unref;
				vala_ccode_function_add_expression (_tmp68_, (ValaCCodeExpression*) _tmp69_);
				_tmp70_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_ccode_constant_new ("FALSE");
				_tmp73_ = _tmp72_;
				vala_ccode_function_add_return (_tmp71_, (ValaCCodeExpression*) _tmp73_);
				_vala_ccode_node_unref0 (_tmp73_);
				_vala_ccode_node_unref0 (unref);
				_vala_ccode_node_unref0 (async_result_expr);
			} else {
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				_tmp74_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
				_tmp75_ = _tmp74_;
				if (_tmp75_ != NULL) {
					ValaDataType* _tmp76_;
					ValaDataType* _tmp77_;
					_tmp76_ = vala_ccode_base_module_get_current_return_type ((ValaCCodeBaseModule*) self);
					_tmp77_ = _tmp76_;
					vala_ccode_base_module_return_default_value ((ValaCCodeBaseModule*) self, _tmp77_, TRUE);
				}
			}
		}
	}
	_vala_ccode_node_unref0 (cclear);
	_vala_ccode_node_unref0 (domain_name);
	_vala_ccode_node_unref0 (ccritical);
}


static gboolean
vala_gerror_module_in_finally_block (ValaGErrorModule* self,
                                     ValaCodeNode* node)
{
	gboolean result = FALSE;
	ValaCodeNode* current_node = NULL;
	ValaCodeNode* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	_tmp0_ = _vala_code_node_ref0 (node);
	current_node = _tmp0_;
	while (TRUE) {
		ValaCodeNode* _tmp1_;
		ValaTryStatement* try_stmt = NULL;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		ValaCodeNode* _tmp4_;
		ValaTryStatement* _tmp5_;
		gboolean _tmp6_ = FALSE;
		ValaTryStatement* _tmp7_;
		ValaCodeNode* _tmp12_;
		ValaCodeNode* _tmp13_;
		ValaCodeNode* _tmp14_;
		ValaCodeNode* _tmp15_;
		_tmp1_ = current_node;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = current_node;
		_tmp3_ = vala_code_node_get_parent_node (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, VALA_TYPE_TRY_STATEMENT) ? ((ValaTryStatement*) _tmp4_) : NULL);
		try_stmt = _tmp5_;
		_tmp7_ = try_stmt;
		if (_tmp7_ != NULL) {
			ValaTryStatement* _tmp8_;
			ValaBlock* _tmp9_;
			ValaBlock* _tmp10_;
			ValaCodeNode* _tmp11_;
			_tmp8_ = try_stmt;
			_tmp9_ = vala_try_statement_get_finally_body (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = current_node;
			_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALA_TYPE_CODE_NODE, ValaCodeNode) == _tmp11_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			result = TRUE;
			_vala_code_node_unref0 (try_stmt);
			_vala_code_node_unref0 (current_node);
			return result;
		}
		_tmp12_ = current_node;
		_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _vala_code_node_ref0 (_tmp14_);
		_vala_code_node_unref0 (current_node);
		current_node = _tmp15_;
		_vala_code_node_unref0 (try_stmt);
	}
	result = FALSE;
	_vala_code_node_unref0 (current_node);
	return result;
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void
vala_gerror_module_real_add_simple_check (ValaCCodeBaseModule* base,
                                          ValaCodeNode* node,
                                          gboolean always_fails)
{
	ValaGErrorModule * self;
	ValaTryStatement* _tmp15_;
	ValaTryStatement* _tmp16_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (node != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	if (always_fails) {
	} else {
		ValaCCodeBinaryExpression* ccond = NULL;
		ValaCCodeExpression* _tmp0_;
		ValaCCodeExpression* _tmp1_;
		ValaCCodeConstant* _tmp2_;
		ValaCCodeConstant* _tmp3_;
		ValaCCodeBinaryExpression* _tmp4_;
		ValaCCodeBinaryExpression* _tmp5_;
		ValaCCodeFunctionCall* unlikely = NULL;
		ValaCCodeIdentifier* _tmp6_;
		ValaCCodeIdentifier* _tmp7_;
		ValaCCodeFunctionCall* _tmp8_;
		ValaCCodeFunctionCall* _tmp9_;
		ValaCCodeFunctionCall* _tmp10_;
		ValaCCodeBinaryExpression* _tmp11_;
		ValaCCodeFunction* _tmp12_;
		ValaCCodeFunction* _tmp13_;
		ValaCCodeFunctionCall* _tmp14_;
		_tmp0_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp1_ = _tmp0_;
		_tmp2_ = vala_ccode_constant_new ("NULL");
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_INEQUALITY, _tmp1_, (ValaCCodeExpression*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_ccode_node_unref0 (_tmp3_);
		_vala_ccode_node_unref0 (_tmp1_);
		ccond = _tmp5_;
		_tmp6_ = vala_ccode_identifier_new ("G_UNLIKELY");
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp7_);
		_tmp9_ = _tmp8_;
		_vala_ccode_node_unref0 (_tmp7_);
		unlikely = _tmp9_;
		_tmp10_ = unlikely;
		_tmp11_ = ccond;
		vala_ccode_function_call_add_argument (_tmp10_, (ValaCCodeExpression*) _tmp11_);
		_tmp12_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp13_ = _tmp12_;
		_tmp14_ = unlikely;
		vala_ccode_function_open_if (_tmp13_, (ValaCCodeExpression*) _tmp14_);
		_vala_ccode_node_unref0 (unlikely);
		_vala_ccode_node_unref0 (ccond);
	}
	_tmp15_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp16_ = _tmp15_;
	if (_tmp16_ != NULL) {
		gboolean _tmp17_;
		ValaArrayList* error_types = NULL;
		GEqualFunc _tmp26_;
		ValaArrayList* _tmp27_;
		gboolean has_general_catch_clause = FALSE;
		gboolean _tmp40_;
		gboolean _tmp157_;
		_tmp17_ = self->priv->is_in_catch;
		if (_tmp17_) {
			ValaSymbol* _tmp18_;
			ValaSymbol* _tmp19_;
			ValaCatchClause* _tmp20_;
			ValaCatchClause* _tmp21_;
			_tmp18_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp19_ = _tmp18_;
			_tmp20_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
			_tmp21_ = _tmp20_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp19_, FALSE, (ValaCodeNode*) _tmp21_);
		} else {
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp23_;
			ValaTryStatement* _tmp24_;
			ValaTryStatement* _tmp25_;
			_tmp22_ = vala_ccode_base_module_get_current_symbol ((ValaCCodeBaseModule*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
			_tmp25_ = _tmp24_;
			vala_ccode_base_module_append_local_free ((ValaCCodeBaseModule*) self, _tmp23_, FALSE, (ValaCodeNode*) _tmp25_);
		}
		_tmp26_ = g_direct_equal;
		_tmp27_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp26_);
		error_types = _tmp27_;
		{
			ValaList* _node_error_type_list = NULL;
			ValaList* _tmp28_;
			gint _node_error_type_size = 0;
			ValaList* _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			gint _node_error_type_index = 0;
			_tmp28_ = vala_code_node_get_error_types (node);
			_node_error_type_list = _tmp28_;
			_tmp29_ = _node_error_type_list;
			_tmp30_ = vala_collection_get_size ((ValaCollection*) _tmp29_);
			_tmp31_ = _tmp30_;
			_node_error_type_size = _tmp31_;
			_node_error_type_index = -1;
			while (TRUE) {
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
				ValaDataType* node_error_type = NULL;
				ValaList* _tmp35_;
				gint _tmp36_;
				gpointer _tmp37_;
				ValaArrayList* _tmp38_;
				ValaDataType* _tmp39_;
				_tmp32_ = _node_error_type_index;
				_node_error_type_index = _tmp32_ + 1;
				_tmp33_ = _node_error_type_index;
				_tmp34_ = _node_error_type_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _node_error_type_list;
				_tmp36_ = _node_error_type_index;
				_tmp37_ = vala_list_get (_tmp35_, _tmp36_);
				node_error_type = (ValaDataType*) _tmp37_;
				_tmp38_ = error_types;
				_tmp39_ = node_error_type;
				vala_collection_add ((ValaCollection*) _tmp38_, _tmp39_);
				_vala_code_node_unref0 (node_error_type);
			}
			_vala_iterable_unref0 (_node_error_type_list);
		}
		has_general_catch_clause = FALSE;
		_tmp40_ = self->priv->is_in_catch;
		if (!_tmp40_) {
			ValaArrayList* handled_error_types = NULL;
			GEqualFunc _tmp41_;
			ValaArrayList* _tmp42_;
			_tmp41_ = g_direct_equal;
			_tmp42_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp41_);
			handled_error_types = _tmp42_;
			{
				ValaList* _clause_list = NULL;
				ValaTryStatement* _tmp43_;
				ValaTryStatement* _tmp44_;
				ValaList* _tmp45_;
				gint _clause_size = 0;
				ValaList* _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _clause_index = 0;
				_tmp43_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
				_tmp44_ = _tmp43_;
				_tmp45_ = vala_try_statement_get_catch_clauses (_tmp44_);
				_clause_list = _tmp45_;
				_tmp46_ = _clause_list;
				_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
				_tmp48_ = _tmp47_;
				_clause_size = _tmp48_;
				_clause_index = -1;
				while (TRUE) {
					gint _tmp49_;
					gint _tmp50_;
					gint _tmp51_;
					ValaCatchClause* clause = NULL;
					ValaList* _tmp52_;
					gint _tmp53_;
					gpointer _tmp54_;
					ValaArrayList* _tmp89_;
					ValaCatchClause* _tmp90_;
					ValaDataType* _tmp91_;
					ValaDataType* _tmp92_;
					ValaErrorType* _tmp93_;
					_tmp49_ = _clause_index;
					_clause_index = _tmp49_ + 1;
					_tmp50_ = _clause_index;
					_tmp51_ = _clause_size;
					if (!(_tmp50_ < _tmp51_)) {
						break;
					}
					_tmp52_ = _clause_list;
					_tmp53_ = _clause_index;
					_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
					clause = (ValaCatchClause*) _tmp54_;
					{
						ValaArrayList* _node_error_type_list = NULL;
						ValaArrayList* _tmp55_;
						ValaArrayList* _tmp56_;
						gint _node_error_type_size = 0;
						ValaArrayList* _tmp57_;
						gint _tmp58_;
						gint _tmp59_;
						gint _node_error_type_index = 0;
						_tmp55_ = error_types;
						_tmp56_ = _vala_iterable_ref0 (_tmp55_);
						_node_error_type_list = _tmp56_;
						_tmp57_ = _node_error_type_list;
						_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
						_tmp59_ = _tmp58_;
						_node_error_type_size = _tmp59_;
						_node_error_type_index = -1;
						while (TRUE) {
							gint _tmp60_;
							gint _tmp61_;
							gint _tmp62_;
							ValaDataType* node_error_type = NULL;
							ValaArrayList* _tmp63_;
							gint _tmp64_;
							gpointer _tmp65_;
							gboolean _tmp66_ = FALSE;
							ValaCatchClause* _tmp67_;
							ValaDataType* _tmp68_;
							ValaDataType* _tmp69_;
							_tmp60_ = _node_error_type_index;
							_node_error_type_index = _tmp60_ + 1;
							_tmp61_ = _node_error_type_index;
							_tmp62_ = _node_error_type_size;
							if (!(_tmp61_ < _tmp62_)) {
								break;
							}
							_tmp63_ = _node_error_type_list;
							_tmp64_ = _node_error_type_index;
							_tmp65_ = vala_list_get ((ValaList*) _tmp63_, _tmp64_);
							node_error_type = (ValaDataType*) _tmp65_;
							_tmp67_ = clause;
							_tmp68_ = vala_catch_clause_get_error_type (_tmp67_);
							_tmp69_ = _tmp68_;
							if (_tmp69_ == NULL) {
								_tmp66_ = TRUE;
							} else {
								ValaDataType* _tmp70_;
								ValaCatchClause* _tmp71_;
								ValaDataType* _tmp72_;
								ValaDataType* _tmp73_;
								_tmp70_ = node_error_type;
								_tmp71_ = clause;
								_tmp72_ = vala_catch_clause_get_error_type (_tmp71_);
								_tmp73_ = _tmp72_;
								_tmp66_ = vala_data_type_compatible (_tmp70_, _tmp73_);
							}
							if (_tmp66_) {
								ValaArrayList* _tmp74_;
								ValaDataType* _tmp75_;
								_tmp74_ = handled_error_types;
								_tmp75_ = node_error_type;
								vala_collection_add ((ValaCollection*) _tmp74_, _tmp75_);
							}
							_vala_code_node_unref0 (node_error_type);
						}
						_vala_iterable_unref0 (_node_error_type_list);
					}
					{
						ValaArrayList* _handled_error_type_list = NULL;
						ValaArrayList* _tmp76_;
						ValaArrayList* _tmp77_;
						gint _handled_error_type_size = 0;
						ValaArrayList* _tmp78_;
						gint _tmp79_;
						gint _tmp80_;
						gint _handled_error_type_index = 0;
						_tmp76_ = handled_error_types;
						_tmp77_ = _vala_iterable_ref0 (_tmp76_);
						_handled_error_type_list = _tmp77_;
						_tmp78_ = _handled_error_type_list;
						_tmp79_ = vala_collection_get_size ((ValaCollection*) _tmp78_);
						_tmp80_ = _tmp79_;
						_handled_error_type_size = _tmp80_;
						_handled_error_type_index = -1;
						while (TRUE) {
							gint _tmp81_;
							gint _tmp82_;
							gint _tmp83_;
							ValaDataType* handled_error_type = NULL;
							ValaArrayList* _tmp84_;
							gint _tmp85_;
							gpointer _tmp86_;
							ValaArrayList* _tmp87_;
							ValaDataType* _tmp88_;
							_tmp81_ = _handled_error_type_index;
							_handled_error_type_index = _tmp81_ + 1;
							_tmp82_ = _handled_error_type_index;
							_tmp83_ = _handled_error_type_size;
							if (!(_tmp82_ < _tmp83_)) {
								break;
							}
							_tmp84_ = _handled_error_type_list;
							_tmp85_ = _handled_error_type_index;
							_tmp86_ = vala_list_get ((ValaList*) _tmp84_, _tmp85_);
							handled_error_type = (ValaDataType*) _tmp86_;
							_tmp87_ = error_types;
							_tmp88_ = handled_error_type;
							vala_collection_remove ((ValaCollection*) _tmp87_, _tmp88_);
							_vala_code_node_unref0 (handled_error_type);
						}
						_vala_iterable_unref0 (_handled_error_type_list);
					}
					_tmp89_ = handled_error_types;
					vala_collection_clear ((ValaCollection*) _tmp89_);
					_tmp90_ = clause;
					_tmp91_ = vala_catch_clause_get_error_type (_tmp90_);
					_tmp92_ = _tmp91_;
					_tmp93_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp92_, (ValaDataType*) _tmp93_)) {
						ValaCCodeFunction* _tmp94_;
						ValaCCodeFunction* _tmp95_;
						ValaCatchClause* _tmp96_;
						const gchar* _tmp97_;
						const gchar* _tmp98_;
						has_general_catch_clause = TRUE;
						_tmp94_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp95_ = _tmp94_;
						_tmp96_ = clause;
						_tmp97_ = vala_catch_clause_get_clabel_name (_tmp96_);
						_tmp98_ = _tmp97_;
						vala_ccode_function_add_goto (_tmp95_, _tmp98_);
						_vala_code_node_unref0 (clause);
						break;
					} else {
						ValaErrorType* catch_type = NULL;
						ValaCatchClause* _tmp99_;
						ValaDataType* _tmp100_;
						ValaDataType* _tmp101_;
						ValaErrorType* _tmp102_;
						ValaErrorType* _tmp103_;
						ValaErrorCode* _tmp104_;
						ValaErrorCode* _tmp105_;
						ValaCCodeFunction* _tmp150_;
						ValaCCodeFunction* _tmp151_;
						ValaCatchClause* _tmp152_;
						const gchar* _tmp153_;
						const gchar* _tmp154_;
						ValaCCodeFunction* _tmp155_;
						ValaCCodeFunction* _tmp156_;
						_tmp99_ = clause;
						_tmp100_ = vala_catch_clause_get_error_type (_tmp99_);
						_tmp101_ = _tmp100_;
						_tmp102_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp101_, VALA_TYPE_ERROR_TYPE) ? ((ValaErrorType*) _tmp101_) : NULL);
						catch_type = _tmp102_;
						_tmp103_ = catch_type;
						_tmp104_ = vala_error_type_get_error_code (_tmp103_);
						_tmp105_ = _tmp104_;
						if (_tmp105_ != NULL) {
							ValaCCodeFunctionCall* error_match = NULL;
							ValaCCodeIdentifier* _tmp106_;
							ValaCCodeIdentifier* _tmp107_;
							ValaCCodeFunctionCall* _tmp108_;
							ValaCCodeFunctionCall* _tmp109_;
							ValaCCodeFunctionCall* _tmp110_;
							ValaCCodeExpression* _tmp111_;
							ValaCCodeExpression* _tmp112_;
							ValaCCodeFunctionCall* _tmp113_;
							ValaErrorType* _tmp114_;
							ValaTypeSymbol* _tmp115_;
							ValaTypeSymbol* _tmp116_;
							gchar* _tmp117_;
							gchar* _tmp118_;
							ValaCCodeIdentifier* _tmp119_;
							ValaCCodeIdentifier* _tmp120_;
							ValaCCodeFunctionCall* _tmp121_;
							ValaErrorType* _tmp122_;
							ValaErrorCode* _tmp123_;
							ValaErrorCode* _tmp124_;
							gchar* _tmp125_;
							gchar* _tmp126_;
							ValaCCodeIdentifier* _tmp127_;
							ValaCCodeIdentifier* _tmp128_;
							ValaCCodeFunction* _tmp129_;
							ValaCCodeFunction* _tmp130_;
							ValaCCodeFunctionCall* _tmp131_;
							_tmp106_ = vala_ccode_identifier_new ("g_error_matches");
							_tmp107_ = _tmp106_;
							_tmp108_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp107_);
							_tmp109_ = _tmp108_;
							_vala_ccode_node_unref0 (_tmp107_);
							error_match = _tmp109_;
							_tmp110_ = error_match;
							_tmp111_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
							_tmp112_ = _tmp111_;
							vala_ccode_function_call_add_argument (_tmp110_, _tmp112_);
							_vala_ccode_node_unref0 (_tmp112_);
							_tmp113_ = error_match;
							_tmp114_ = catch_type;
							_tmp115_ = vala_data_type_get_data_type ((ValaDataType*) _tmp114_);
							_tmp116_ = _tmp115_;
							_tmp117_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp116_, NULL);
							_tmp118_ = _tmp117_;
							_tmp119_ = vala_ccode_identifier_new (_tmp118_);
							_tmp120_ = _tmp119_;
							vala_ccode_function_call_add_argument (_tmp113_, (ValaCCodeExpression*) _tmp120_);
							_vala_ccode_node_unref0 (_tmp120_);
							_g_free0 (_tmp118_);
							_tmp121_ = error_match;
							_tmp122_ = catch_type;
							_tmp123_ = vala_error_type_get_error_code (_tmp122_);
							_tmp124_ = _tmp123_;
							_tmp125_ = vala_get_ccode_name ((ValaCodeNode*) _tmp124_);
							_tmp126_ = _tmp125_;
							_tmp127_ = vala_ccode_identifier_new (_tmp126_);
							_tmp128_ = _tmp127_;
							vala_ccode_function_call_add_argument (_tmp121_, (ValaCCodeExpression*) _tmp128_);
							_vala_ccode_node_unref0 (_tmp128_);
							_g_free0 (_tmp126_);
							_tmp129_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp130_ = _tmp129_;
							_tmp131_ = error_match;
							vala_ccode_function_open_if (_tmp130_, (ValaCCodeExpression*) _tmp131_);
							_vala_ccode_node_unref0 (error_match);
						} else {
							ValaCCodeBinaryExpression* ccond = NULL;
							ValaCCodeExpression* _tmp132_;
							ValaCCodeExpression* _tmp133_;
							ValaCCodeMemberAccess* _tmp134_;
							ValaCCodeMemberAccess* _tmp135_;
							ValaCatchClause* _tmp136_;
							ValaDataType* _tmp137_;
							ValaDataType* _tmp138_;
							ValaTypeSymbol* _tmp139_;
							ValaTypeSymbol* _tmp140_;
							gchar* _tmp141_;
							gchar* _tmp142_;
							ValaCCodeIdentifier* _tmp143_;
							ValaCCodeIdentifier* _tmp144_;
							ValaCCodeBinaryExpression* _tmp145_;
							ValaCCodeBinaryExpression* _tmp146_;
							ValaCCodeFunction* _tmp147_;
							ValaCCodeFunction* _tmp148_;
							ValaCCodeBinaryExpression* _tmp149_;
							_tmp132_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
							_tmp133_ = _tmp132_;
							_tmp134_ = vala_ccode_member_access_new_pointer (_tmp133_, "domain");
							_tmp135_ = _tmp134_;
							_tmp136_ = clause;
							_tmp137_ = vala_catch_clause_get_error_type (_tmp136_);
							_tmp138_ = _tmp137_;
							_tmp139_ = vala_data_type_get_data_type (_tmp138_);
							_tmp140_ = _tmp139_;
							_tmp141_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp140_, NULL);
							_tmp142_ = _tmp141_;
							_tmp143_ = vala_ccode_identifier_new (_tmp142_);
							_tmp144_ = _tmp143_;
							_tmp145_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp135_, (ValaCCodeExpression*) _tmp144_);
							_tmp146_ = _tmp145_;
							_vala_ccode_node_unref0 (_tmp144_);
							_g_free0 (_tmp142_);
							_vala_ccode_node_unref0 (_tmp135_);
							_vala_ccode_node_unref0 (_tmp133_);
							ccond = _tmp146_;
							_tmp147_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
							_tmp148_ = _tmp147_;
							_tmp149_ = ccond;
							vala_ccode_function_open_if (_tmp148_, (ValaCCodeExpression*) _tmp149_);
							_vala_ccode_node_unref0 (ccond);
						}
						_tmp150_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp151_ = _tmp150_;
						_tmp152_ = clause;
						_tmp153_ = vala_catch_clause_get_clabel_name (_tmp152_);
						_tmp154_ = _tmp153_;
						vala_ccode_function_add_goto (_tmp151_, _tmp154_);
						_tmp155_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp156_ = _tmp155_;
						vala_ccode_function_close (_tmp156_);
						_vala_code_node_unref0 (catch_type);
					}
					_vala_code_node_unref0 (clause);
				}
				_vala_iterable_unref0 (_clause_list);
			}
			_vala_iterable_unref0 (handled_error_types);
		}
		_tmp157_ = has_general_catch_clause;
		if (_tmp157_) {
		} else {
			ValaArrayList* _tmp158_;
			gint _tmp159_;
			gint _tmp160_;
			_tmp158_ = error_types;
			_tmp159_ = vala_collection_get_size ((ValaCollection*) _tmp158_);
			_tmp160_ = _tmp159_;
			if (_tmp160_ > 0) {
				ValaCCodeFunction* _tmp161_;
				ValaCCodeFunction* _tmp162_;
				gint _tmp163_;
				gchar* _tmp164_;
				gchar* _tmp165_;
				_tmp161_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp162_ = _tmp161_;
				_tmp163_ = self->priv->current_try_id;
				_tmp164_ = g_strdup_printf ("__finally%d", _tmp163_);
				_tmp165_ = _tmp164_;
				vala_ccode_function_add_goto (_tmp162_, _tmp165_);
				_g_free0 (_tmp165_);
			} else {
				if (vala_gerror_module_in_finally_block (self, node)) {
				} else {
					ValaCCodeExpression* _tmp166_;
					ValaCCodeExpression* _tmp167_;
					_tmp166_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
					_tmp167_ = _tmp166_;
					vala_gerror_module_uncaught_error_statement (self, _tmp167_, TRUE);
					_vala_ccode_node_unref0 (_tmp167_);
				}
			}
		}
		_vala_iterable_unref0 (error_types);
	} else {
		gboolean _tmp168_ = FALSE;
		ValaMethod* _tmp169_;
		ValaMethod* _tmp170_;
		_tmp169_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp170_ = _tmp169_;
		if (_tmp170_ != NULL) {
			ValaMethod* _tmp171_;
			ValaMethod* _tmp172_;
			ValaList* _tmp173_;
			ValaList* _tmp174_;
			gint _tmp175_;
			gint _tmp176_;
			_tmp171_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp172_ = _tmp171_;
			_tmp173_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp172_);
			_tmp174_ = _tmp173_;
			_tmp175_ = vala_collection_get_size ((ValaCollection*) _tmp174_);
			_tmp176_ = _tmp175_;
			_tmp168_ = _tmp176_ > 0;
			_vala_iterable_unref0 (_tmp174_);
		} else {
			_tmp168_ = FALSE;
		}
		if (_tmp168_) {
			ValaCCodeBinaryExpression* ccond = NULL;
			ValaCCodeBinaryExpression* _tmp210_;
			ccond = NULL;
			{
				ValaList* _error_type_list = NULL;
				ValaMethod* _tmp177_;
				ValaMethod* _tmp178_;
				ValaList* _tmp179_;
				gint _error_type_size = 0;
				ValaList* _tmp180_;
				gint _tmp181_;
				gint _tmp182_;
				gint _error_type_index = 0;
				_tmp177_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp178_ = _tmp177_;
				_tmp179_ = vala_code_node_get_error_types ((ValaCodeNode*) _tmp178_);
				_error_type_list = _tmp179_;
				_tmp180_ = _error_type_list;
				_tmp181_ = vala_collection_get_size ((ValaCollection*) _tmp180_);
				_tmp182_ = _tmp181_;
				_error_type_size = _tmp182_;
				_error_type_index = -1;
				while (TRUE) {
					gint _tmp183_;
					gint _tmp184_;
					gint _tmp185_;
					ValaDataType* error_type = NULL;
					ValaList* _tmp186_;
					gint _tmp187_;
					gpointer _tmp188_;
					ValaDataType* _tmp189_;
					ValaErrorType* _tmp190_;
					ValaCCodeBinaryExpression* domain_check = NULL;
					ValaCCodeExpression* _tmp191_;
					ValaCCodeExpression* _tmp192_;
					ValaCCodeMemberAccess* _tmp193_;
					ValaCCodeMemberAccess* _tmp194_;
					ValaDataType* _tmp195_;
					ValaTypeSymbol* _tmp196_;
					ValaTypeSymbol* _tmp197_;
					gchar* _tmp198_;
					gchar* _tmp199_;
					ValaCCodeIdentifier* _tmp200_;
					ValaCCodeIdentifier* _tmp201_;
					ValaCCodeBinaryExpression* _tmp202_;
					ValaCCodeBinaryExpression* _tmp203_;
					ValaCCodeBinaryExpression* _tmp204_;
					_tmp183_ = _error_type_index;
					_error_type_index = _tmp183_ + 1;
					_tmp184_ = _error_type_index;
					_tmp185_ = _error_type_size;
					if (!(_tmp184_ < _tmp185_)) {
						break;
					}
					_tmp186_ = _error_type_list;
					_tmp187_ = _error_type_index;
					_tmp188_ = vala_list_get (_tmp186_, _tmp187_);
					error_type = (ValaDataType*) _tmp188_;
					_tmp189_ = error_type;
					_tmp190_ = ((ValaCCodeBaseModule*) self)->gerror_type;
					if (vala_data_type_equals (_tmp189_, (ValaDataType*) _tmp190_)) {
						_vala_ccode_node_unref0 (ccond);
						ccond = NULL;
						_vala_code_node_unref0 (error_type);
						break;
					}
					_tmp191_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
					_tmp192_ = _tmp191_;
					_tmp193_ = vala_ccode_member_access_new_pointer (_tmp192_, "domain");
					_tmp194_ = _tmp193_;
					_tmp195_ = error_type;
					_tmp196_ = vala_data_type_get_data_type (_tmp195_);
					_tmp197_ = _tmp196_;
					_tmp198_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp197_, NULL);
					_tmp199_ = _tmp198_;
					_tmp200_ = vala_ccode_identifier_new (_tmp199_);
					_tmp201_ = _tmp200_;
					_tmp202_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, (ValaCCodeExpression*) _tmp194_, (ValaCCodeExpression*) _tmp201_);
					_tmp203_ = _tmp202_;
					_vala_ccode_node_unref0 (_tmp201_);
					_g_free0 (_tmp199_);
					_vala_ccode_node_unref0 (_tmp194_);
					_vala_ccode_node_unref0 (_tmp192_);
					domain_check = _tmp203_;
					_tmp204_ = ccond;
					if (_tmp204_ == NULL) {
						ValaCCodeBinaryExpression* _tmp205_;
						ValaCCodeBinaryExpression* _tmp206_;
						_tmp205_ = domain_check;
						_tmp206_ = _vala_ccode_node_ref0 (_tmp205_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp206_;
					} else {
						ValaCCodeBinaryExpression* _tmp207_;
						ValaCCodeBinaryExpression* _tmp208_;
						ValaCCodeBinaryExpression* _tmp209_;
						_tmp207_ = ccond;
						_tmp208_ = domain_check;
						_tmp209_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, (ValaCCodeExpression*) _tmp207_, (ValaCCodeExpression*) _tmp208_);
						_vala_ccode_node_unref0 (ccond);
						ccond = _tmp209_;
					}
					_vala_ccode_node_unref0 (domain_check);
					_vala_code_node_unref0 (error_type);
				}
				_vala_iterable_unref0 (_error_type_list);
			}
			_tmp210_ = ccond;
			if (_tmp210_ != NULL) {
				ValaCCodeFunction* _tmp211_;
				ValaCCodeFunction* _tmp212_;
				ValaCCodeBinaryExpression* _tmp213_;
				ValaCCodeExpression* _tmp214_;
				ValaCCodeExpression* _tmp215_;
				ValaCCodeFunction* _tmp216_;
				ValaCCodeFunction* _tmp217_;
				ValaCCodeExpression* _tmp218_;
				ValaCCodeExpression* _tmp219_;
				ValaCCodeFunction* _tmp220_;
				ValaCCodeFunction* _tmp221_;
				_tmp211_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp212_ = _tmp211_;
				_tmp213_ = ccond;
				vala_ccode_function_open_if (_tmp212_, (ValaCCodeExpression*) _tmp213_);
				_tmp214_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp215_ = _tmp214_;
				vala_gerror_module_return_with_exception (self, _tmp215_);
				_vala_ccode_node_unref0 (_tmp215_);
				_tmp216_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp217_ = _tmp216_;
				vala_ccode_function_add_else (_tmp217_);
				_tmp218_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp219_ = _tmp218_;
				vala_gerror_module_uncaught_error_statement (self, _tmp219_, FALSE);
				_vala_ccode_node_unref0 (_tmp219_);
				_tmp220_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp221_ = _tmp220_;
				vala_ccode_function_close (_tmp221_);
			} else {
				ValaCCodeExpression* _tmp222_;
				ValaCCodeExpression* _tmp223_;
				_tmp222_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
				_tmp223_ = _tmp222_;
				vala_gerror_module_return_with_exception (self, _tmp223_);
				_vala_ccode_node_unref0 (_tmp223_);
			}
			_vala_ccode_node_unref0 (ccond);
		} else {
			ValaCCodeExpression* _tmp224_;
			ValaCCodeExpression* _tmp225_;
			_tmp224_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
			_tmp225_ = _tmp224_;
			vala_gerror_module_uncaught_error_statement (self, _tmp225_, FALSE);
			_vala_ccode_node_unref0 (_tmp225_);
		}
	}
	if (!always_fails) {
		ValaCCodeFunction* _tmp226_;
		ValaCCodeFunction* _tmp227_;
		_tmp226_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp227_ = _tmp226_;
		vala_ccode_function_close (_tmp227_);
	}
}


static void
vala_gerror_module_real_visit_try_statement (ValaCodeVisitor* base,
                                             ValaTryStatement* stmt)
{
	ValaGErrorModule * self;
	gint this_try_id = 0;
	gint _tmp0_;
	ValaTryStatement* old_try = NULL;
	ValaTryStatement* _tmp1_;
	ValaTryStatement* _tmp2_;
	ValaTryStatement* _tmp3_;
	gint old_try_id = 0;
	gint _tmp4_;
	gboolean old_is_in_catch = FALSE;
	gboolean _tmp5_;
	ValaCatchClause* old_catch = NULL;
	ValaCatchClause* _tmp6_;
	ValaCatchClause* _tmp7_;
	ValaCatchClause* _tmp8_;
	gint _tmp9_;
	ValaBlock* _tmp29_;
	ValaBlock* _tmp30_;
	ValaTryStatement* _tmp48_;
	gint _tmp49_;
	gboolean _tmp50_;
	ValaCatchClause* _tmp51_;
	ValaCCodeFunction* _tmp52_;
	ValaCCodeFunction* _tmp53_;
	gint _tmp54_;
	gchar* _tmp55_;
	gchar* _tmp56_;
	ValaBlock* _tmp57_;
	ValaBlock* _tmp58_;
	gboolean _tmp65_;
	gboolean _tmp66_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (stmt != NULL);
	_tmp0_ = self->priv->next_try_id;
	self->priv->next_try_id = _tmp0_ + 1;
	this_try_id = _tmp0_;
	_tmp1_ = vala_ccode_base_module_get_current_try ((ValaCCodeBaseModule*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _vala_code_node_ref0 (_tmp2_);
	old_try = _tmp3_;
	_tmp4_ = self->priv->current_try_id;
	old_try_id = _tmp4_;
	_tmp5_ = self->priv->is_in_catch;
	old_is_in_catch = _tmp5_;
	_tmp6_ = vala_ccode_base_module_get_current_catch ((ValaCCodeBaseModule*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (_tmp7_);
	old_catch = _tmp8_;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, stmt);
	_tmp9_ = this_try_id;
	self->priv->current_try_id = _tmp9_;
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp10_;
		gint _clause_size = 0;
		ValaList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		gint _clause_index = 0;
		_tmp10_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp10_;
		_tmp11_ = _clause_list;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_clause_size = _tmp13_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp17_;
			gint _tmp18_;
			gpointer _tmp19_;
			ValaCatchClause* _tmp20_;
			gint _tmp21_;
			ValaCatchClause* _tmp22_;
			ValaDataType* _tmp23_;
			ValaDataType* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp14_ = _clause_index;
			_clause_index = _tmp14_ + 1;
			_tmp15_ = _clause_index;
			_tmp16_ = _clause_size;
			if (!(_tmp15_ < _tmp16_)) {
				break;
			}
			_tmp17_ = _clause_list;
			_tmp18_ = _clause_index;
			_tmp19_ = vala_list_get (_tmp17_, _tmp18_);
			clause = (ValaCatchClause*) _tmp19_;
			_tmp20_ = clause;
			_tmp21_ = this_try_id;
			_tmp22_ = clause;
			_tmp23_ = vala_catch_clause_get_error_type (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp24_, NULL);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strdup_printf ("__catch%d_%s", _tmp21_, _tmp26_);
			_tmp28_ = _tmp27_;
			vala_catch_clause_set_clabel_name (_tmp20_, _tmp28_);
			_g_free0 (_tmp28_);
			_g_free0 (_tmp26_);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	self->priv->is_in_catch = FALSE;
	_tmp29_ = vala_try_statement_get_body (stmt);
	_tmp30_ = _tmp29_;
	vala_code_node_emit ((ValaCodeNode*) _tmp30_, (ValaCodeGenerator*) self);
	self->priv->is_in_catch = TRUE;
	{
		ValaList* _clause_list = NULL;
		ValaList* _tmp31_;
		gint _clause_size = 0;
		ValaList* _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint _clause_index = 0;
		_tmp31_ = vala_try_statement_get_catch_clauses (stmt);
		_clause_list = _tmp31_;
		_tmp32_ = _clause_list;
		_tmp33_ = vala_collection_get_size ((ValaCollection*) _tmp32_);
		_tmp34_ = _tmp33_;
		_clause_size = _tmp34_;
		_clause_index = -1;
		while (TRUE) {
			gint _tmp35_;
			gint _tmp36_;
			gint _tmp37_;
			ValaCatchClause* clause = NULL;
			ValaList* _tmp38_;
			gint _tmp39_;
			gpointer _tmp40_;
			ValaCatchClause* _tmp41_;
			ValaCCodeFunction* _tmp42_;
			ValaCCodeFunction* _tmp43_;
			gint _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
			ValaCatchClause* _tmp47_;
			_tmp35_ = _clause_index;
			_clause_index = _tmp35_ + 1;
			_tmp36_ = _clause_index;
			_tmp37_ = _clause_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _clause_list;
			_tmp39_ = _clause_index;
			_tmp40_ = vala_list_get (_tmp38_, _tmp39_);
			clause = (ValaCatchClause*) _tmp40_;
			_tmp41_ = clause;
			vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp41_);
			_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp43_ = _tmp42_;
			_tmp44_ = this_try_id;
			_tmp45_ = g_strdup_printf ("__finally%d", _tmp44_);
			_tmp46_ = _tmp45_;
			vala_ccode_function_add_goto (_tmp43_, _tmp46_);
			_g_free0 (_tmp46_);
			_tmp47_ = clause;
			vala_code_node_emit ((ValaCodeNode*) _tmp47_, (ValaCodeGenerator*) self);
			_vala_code_node_unref0 (clause);
		}
		_vala_iterable_unref0 (_clause_list);
	}
	_tmp48_ = old_try;
	vala_ccode_base_module_set_current_try ((ValaCCodeBaseModule*) self, _tmp48_);
	_tmp49_ = old_try_id;
	self->priv->current_try_id = _tmp49_;
	_tmp50_ = old_is_in_catch;
	self->priv->is_in_catch = _tmp50_;
	_tmp51_ = old_catch;
	vala_ccode_base_module_set_current_catch ((ValaCCodeBaseModule*) self, _tmp51_);
	_tmp52_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp53_ = _tmp52_;
	_tmp54_ = this_try_id;
	_tmp55_ = g_strdup_printf ("__finally%d", _tmp54_);
	_tmp56_ = _tmp55_;
	vala_ccode_function_add_label (_tmp53_, _tmp56_);
	_g_free0 (_tmp56_);
	_tmp57_ = vala_try_statement_get_finally_body (stmt);
	_tmp58_ = _tmp57_;
	if (_tmp58_ != NULL) {
		gint _tmp59_;
		gint _tmp60_;
		ValaBlock* _tmp61_;
		ValaBlock* _tmp62_;
		gint _tmp63_;
		gint _tmp64_;
		_tmp59_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
		_tmp60_ = _tmp59_;
		vala_ccode_base_module_set_current_inner_error_id ((ValaCCodeBaseModule*) self, _tmp60_ + 1);
		_tmp61_ = vala_try_statement_get_finally_body (stmt);
		_tmp62_ = _tmp61_;
		vala_code_node_emit ((ValaCodeNode*) _tmp62_, (ValaCodeGenerator*) self);
		_tmp63_ = vala_ccode_base_module_get_current_inner_error_id ((ValaCCodeBaseModule*) self);
		_tmp64_ = _tmp63_;
		vala_ccode_base_module_set_current_inner_error_id ((ValaCCodeBaseModule*) self, _tmp64_ - 1);
	}
	_tmp65_ = vala_try_statement_get_after_try_block_reachable (stmt);
	_tmp66_ = _tmp65_;
	vala_ccode_base_module_add_simple_check ((ValaCCodeBaseModule*) self, (ValaCodeNode*) stmt, !_tmp66_);
	_vala_code_node_unref0 (old_catch);
	_vala_code_node_unref0 (old_try);
}


static void
vala_gerror_module_real_visit_catch_clause (ValaCodeVisitor* base,
                                            ValaCatchClause* clause)
{
	ValaGErrorModule * self;
	ValaErrorType* error_type = NULL;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaErrorType* _tmp2_;
	ValaErrorType* _tmp3_;
	ValaErrorDomain* _tmp4_;
	ValaErrorDomain* _tmp5_;
	ValaCCodeFunction* _tmp10_;
	ValaCCodeFunction* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	ValaCCodeFunction* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaLocalVariable* _tmp16_;
	ValaLocalVariable* _tmp17_;
	ValaCCodeFunction* _tmp42_;
	ValaCCodeFunction* _tmp43_;
	ValaCCodeExpression* _tmp44_;
	ValaCCodeExpression* _tmp45_;
	ValaCCodeConstant* _tmp46_;
	ValaCCodeConstant* _tmp47_;
	ValaBlock* _tmp48_;
	ValaBlock* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (clause != NULL);
	vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
	_tmp0_ = vala_catch_clause_get_error_type (clause);
	_tmp1_ = _tmp0_;
	_tmp2_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, VALA_TYPE_ERROR_TYPE, ValaErrorType));
	error_type = _tmp2_;
	_tmp3_ = error_type;
	_tmp4_ = vala_error_type_get_error_domain (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		ValaErrorType* _tmp6_;
		ValaErrorDomain* _tmp7_;
		ValaErrorDomain* _tmp8_;
		ValaCCodeFile* _tmp9_;
		_tmp6_ = error_type;
		_tmp7_ = vala_error_type_get_error_domain (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_base_module_generate_error_domain_declaration ((ValaCCodeBaseModule*) self, _tmp8_, _tmp9_);
	}
	_tmp10_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp11_ = _tmp10_;
	_tmp12_ = vala_catch_clause_get_clabel_name (clause);
	_tmp13_ = _tmp12_;
	vala_ccode_function_add_label (_tmp11_, _tmp13_);
	_tmp14_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp15_ = _tmp14_;
	vala_ccode_function_open_block (_tmp15_);
	_tmp16_ = vala_catch_clause_get_error_variable (clause);
	_tmp17_ = _tmp16_;
	if (_tmp17_ != NULL) {
		ValaLocalVariable* _tmp18_;
		ValaLocalVariable* _tmp19_;
		ValaCCodeFunction* _tmp20_;
		ValaCCodeFunction* _tmp21_;
		ValaLocalVariable* _tmp22_;
		ValaLocalVariable* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		ValaCCodeExpression* _tmp26_;
		ValaCCodeExpression* _tmp27_;
		ValaCCodeExpression* _tmp28_;
		ValaCCodeExpression* _tmp29_;
		_tmp18_ = vala_catch_clause_get_error_variable (clause);
		_tmp19_ = _tmp18_;
		vala_code_visitor_visit_local_variable ((ValaCodeVisitor*) self, _tmp19_);
		_tmp20_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp21_ = _tmp20_;
		_tmp22_ = vala_catch_clause_get_error_variable (clause);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_ccode_base_module_get_local_cname ((ValaCCodeBaseModule*) self, _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp29_ = _tmp28_;
		vala_ccode_function_add_assignment (_tmp21_, _tmp27_, _tmp29_);
		_vala_ccode_node_unref0 (_tmp29_);
		_vala_ccode_node_unref0 (_tmp27_);
		_g_free0 (_tmp25_);
	} else {
		ValaCCodeFunctionCall* cclear = NULL;
		ValaCCodeIdentifier* _tmp30_;
		ValaCCodeIdentifier* _tmp31_;
		ValaCCodeFunctionCall* _tmp32_;
		ValaCCodeFunctionCall* _tmp33_;
		ValaCCodeFunctionCall* _tmp34_;
		ValaCCodeExpression* _tmp35_;
		ValaCCodeExpression* _tmp36_;
		ValaCCodeUnaryExpression* _tmp37_;
		ValaCCodeUnaryExpression* _tmp38_;
		ValaCCodeFunction* _tmp39_;
		ValaCCodeFunction* _tmp40_;
		ValaCCodeFunctionCall* _tmp41_;
		_tmp30_ = vala_ccode_identifier_new ("g_clear_error");
		_tmp31_ = _tmp30_;
		_tmp32_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp31_);
		_tmp33_ = _tmp32_;
		_vala_ccode_node_unref0 (_tmp31_);
		cclear = _tmp33_;
		_tmp34_ = cclear;
		_tmp35_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp36_);
		_tmp38_ = _tmp37_;
		vala_ccode_function_call_add_argument (_tmp34_, (ValaCCodeExpression*) _tmp38_);
		_vala_ccode_node_unref0 (_tmp38_);
		_vala_ccode_node_unref0 (_tmp36_);
		_tmp39_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = cclear;
		vala_ccode_function_add_expression (_tmp40_, (ValaCCodeExpression*) _tmp41_);
		_vala_ccode_node_unref0 (cclear);
	}
	_tmp42_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp43_ = _tmp42_;
	_tmp44_ = vala_ccode_base_module_get_inner_error_cexpression ((ValaCCodeBaseModule*) self);
	_tmp45_ = _tmp44_;
	_tmp46_ = vala_ccode_constant_new ("NULL");
	_tmp47_ = _tmp46_;
	vala_ccode_function_add_assignment (_tmp43_, _tmp45_, (ValaCCodeExpression*) _tmp47_);
	_vala_ccode_node_unref0 (_tmp47_);
	_vala_ccode_node_unref0 (_tmp45_);
	_tmp48_ = vala_catch_clause_get_body (clause);
	_tmp49_ = _tmp48_;
	vala_code_node_emit ((ValaCodeNode*) _tmp49_, (ValaCodeGenerator*) self);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	vala_ccode_function_close (_tmp51_);
	_vala_code_node_unref0 (error_type);
}


static void
vala_gerror_module_real_append_scope_free (ValaCCodeBaseModule* base,
                                           ValaSymbol* sym,
                                           ValaCodeNode* stop_at)
{
	ValaGErrorModule * self;
	gboolean _tmp0_ = FALSE;
	self = (ValaGErrorModule*) base;
	g_return_if_fail (sym != NULL);
	VALA_CCODE_BASE_MODULE_CLASS (vala_gerror_module_parent_class)->append_scope_free ((ValaCCodeBaseModule*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_CCODE_DELEGATE_MODULE, ValaCCodeDelegateModule), sym, stop_at);
	if (G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_TRY_STATEMENT)) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (stop_at, VALA_TYPE_CATCH_CLAUSE);
	}
	if (!_tmp0_) {
		ValaBlock* finally_block = NULL;
		ValaBlock* _tmp1_;
		ValaCodeNode* _tmp2_;
		ValaCodeNode* _tmp3_;
		gboolean _tmp18_ = FALSE;
		ValaBlock* _tmp19_;
		_tmp1_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (NULL, VALA_TYPE_BLOCK, ValaBlock));
		finally_block = _tmp1_;
		_tmp2_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
		_tmp3_ = _tmp2_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, VALA_TYPE_TRY_STATEMENT)) {
			ValaCodeNode* _tmp4_;
			ValaCodeNode* _tmp5_;
			ValaBlock* _tmp6_;
			ValaBlock* _tmp7_;
			ValaBlock* _tmp8_;
			_tmp4_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp5_ = _tmp4_;
			_tmp6_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
			_tmp7_ = _tmp6_;
			_tmp8_ = _vala_code_node_ref0 (_tmp7_);
			_vala_code_node_unref0 (finally_block);
			finally_block = _tmp8_;
		} else {
			ValaCodeNode* _tmp9_;
			ValaCodeNode* _tmp10_;
			_tmp9_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
			_tmp10_ = _tmp9_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, VALA_TYPE_CATCH_CLAUSE)) {
				ValaCodeNode* _tmp11_;
				ValaCodeNode* _tmp12_;
				ValaCodeNode* _tmp13_;
				ValaCodeNode* _tmp14_;
				ValaBlock* _tmp15_;
				ValaBlock* _tmp16_;
				ValaBlock* _tmp17_;
				_tmp11_ = vala_code_node_get_parent_node ((ValaCodeNode*) sym);
				_tmp12_ = _tmp11_;
				_tmp13_ = vala_code_node_get_parent_node (_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = vala_try_statement_get_finally_body (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, VALA_TYPE_TRY_STATEMENT, ValaTryStatement));
				_tmp16_ = _tmp15_;
				_tmp17_ = _vala_code_node_ref0 (_tmp16_);
				_vala_code_node_unref0 (finally_block);
				finally_block = _tmp17_;
			}
		}
		_tmp19_ = finally_block;
		if (_tmp19_ != NULL) {
			ValaBlock* _tmp20_;
			_tmp20_ = finally_block;
			_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, VALA_TYPE_SYMBOL, ValaSymbol) != sym;
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			ValaBlock* _tmp21_;
			_tmp21_ = finally_block;
			vala_code_node_emit ((ValaCodeNode*) _tmp21_, (ValaCodeGenerator*) self);
		}
		_vala_code_node_unref0 (finally_block);
	}
}


ValaGErrorModule*
vala_gerror_module_construct (GType object_type)
{
	ValaGErrorModule* self = NULL;
	self = (ValaGErrorModule*) vala_ccode_delegate_module_construct (object_type);
	return self;
}


ValaGErrorModule*
vala_gerror_module_new (void)
{
	return vala_gerror_module_construct (VALA_TYPE_GERROR_MODULE);
}


static void
vala_gerror_module_class_init (ValaGErrorModuleClass * klass)
{
	vala_gerror_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->finalize = vala_gerror_module_finalize;
	g_type_class_add_private (klass, sizeof (ValaGErrorModulePrivate));
	((ValaCCodeBaseModuleClass *) klass)->generate_error_domain_declaration = (void (*) (ValaCCodeBaseModule*, ValaErrorDomain*, ValaCCodeFile*)) vala_gerror_module_real_generate_error_domain_declaration;
	((ValaCodeVisitorClass *) klass)->visit_error_domain = (void (*) (ValaCodeVisitor*, ValaErrorDomain*)) vala_gerror_module_real_visit_error_domain;
	((ValaCodeVisitorClass *) klass)->visit_throw_statement = (void (*) (ValaCodeVisitor*, ValaThrowStatement*)) vala_gerror_module_real_visit_throw_statement;
	((ValaGErrorModuleClass *) klass)->return_with_exception = (void (*) (ValaGErrorModule*, ValaCCodeExpression*)) vala_gerror_module_real_return_with_exception;
	((ValaCCodeBaseModuleClass *) klass)->add_simple_check = (void (*) (ValaCCodeBaseModule*, ValaCodeNode*, gboolean)) vala_gerror_module_real_add_simple_check;
	((ValaCodeVisitorClass *) klass)->visit_try_statement = (void (*) (ValaCodeVisitor*, ValaTryStatement*)) vala_gerror_module_real_visit_try_statement;
	((ValaCodeVisitorClass *) klass)->visit_catch_clause = (void (*) (ValaCodeVisitor*, ValaCatchClause*)) vala_gerror_module_real_visit_catch_clause;
	((ValaCCodeBaseModuleClass *) klass)->append_scope_free = (void (*) (ValaCCodeBaseModule*, ValaSymbol*, ValaCodeNode*)) vala_gerror_module_real_append_scope_free;
}


static void
vala_gerror_module_instance_init (ValaGErrorModule * self)
{
	self->priv = VALA_GERROR_MODULE_GET_PRIVATE (self);
	self->priv->current_try_id = 0;
	self->priv->next_try_id = 0;
	self->priv->is_in_catch = FALSE;
}


static void
vala_gerror_module_finalize (ValaCodeVisitor * obj)
{
	ValaGErrorModule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_GERROR_MODULE, ValaGErrorModule);
	VALA_CODE_VISITOR_CLASS (vala_gerror_module_parent_class)->finalize (obj);
}


GType
vala_gerror_module_get_type (void)
{
	static volatile gsize vala_gerror_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_gerror_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaGErrorModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_gerror_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaGErrorModule), 0, (GInstanceInitFunc) vala_gerror_module_instance_init, NULL };
		GType vala_gerror_module_type_id;
		vala_gerror_module_type_id = g_type_register_static (VALA_TYPE_CCODE_DELEGATE_MODULE, "ValaGErrorModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_gerror_module_type_id__volatile, vala_gerror_module_type_id);
	}
	return vala_gerror_module_type_id__volatile;
}



