/* valaccodeblock.c generated by valac, the Vala compiler
 * generated from valaccodeblock.vala, do not modify */

/* valaccodeblock.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valaccode.h"
#include <valagee.h>

#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))

struct _ValaCCodeBlockPrivate {
	gboolean _suppress_newline;
	ValaList* statements;
};


static gpointer vala_ccode_block_parent_class = NULL;

#define VALA_CCODE_BLOCK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_BLOCK, ValaCCodeBlockPrivate))
static void vala_ccode_block_real_write (ValaCCodeNode* base,
                                  ValaCCodeWriter* writer);
static void vala_ccode_block_finalize (ValaCCodeNode * obj);


/**
 * Prepend the specified statement to the list of statements.
 */
void
vala_ccode_block_prepend_statement (ValaCCodeBlock* self,
                                    ValaCCodeNode* statement)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	_tmp0_ = self->priv->statements;
	vala_list_insert (_tmp0_, 0, statement);
}


/**
 * Append the specified statement to the list of statements.
 */
void
vala_ccode_block_add_statement (ValaCCodeBlock* self,
                                ValaCCodeNode* statement)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	_tmp0_ = self->priv->statements;
	vala_collection_add ((ValaCollection*) _tmp0_, statement);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static void
vala_ccode_block_real_write (ValaCCodeNode* base,
                             ValaCCodeWriter* writer)
{
	ValaCCodeBlock * self;
	ValaCCodeNode* last_statement = NULL;
	gboolean _tmp38_;
	self = (ValaCCodeBlock*) base;
	g_return_if_fail (writer != NULL);
	last_statement = NULL;
	vala_ccode_writer_write_begin_block (writer);
	{
		ValaList* _statement_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _statement_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _statement_index = 0;
		_tmp0_ = self->priv->statements;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_statement_list = _tmp1_;
		_tmp2_ = _statement_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_statement_size = _tmp4_;
		_statement_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaCCodeNode* statement = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaCCodeNode* _tmp11_;
			gboolean _tmp12_ = FALSE;
			ValaCCodeNode* _tmp13_;
			_tmp5_ = _statement_index;
			_statement_index = _tmp5_ + 1;
			_tmp6_ = _statement_index;
			_tmp7_ = _statement_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _statement_list;
			_tmp9_ = _statement_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			statement = (ValaCCodeNode*) _tmp10_;
			_tmp11_ = statement;
			vala_ccode_node_write_declaration (_tmp11_, writer);
			_tmp13_ = statement;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_CCODE_LABEL)) {
				_tmp12_ = TRUE;
			} else {
				ValaCCodeNode* _tmp14_;
				_tmp14_ = statement;
				_tmp12_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp14_, VALA_TYPE_CCODE_CASE_STATEMENT);
			}
			if (_tmp12_) {
				_vala_ccode_node_unref0 (last_statement);
				last_statement = NULL;
			} else {
				gboolean _tmp15_ = FALSE;
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				ValaCCodeNode* _tmp18_;
				_tmp18_ = statement;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, VALA_TYPE_CCODE_RETURN_STATEMENT)) {
					_tmp17_ = TRUE;
				} else {
					ValaCCodeNode* _tmp19_;
					_tmp19_ = statement;
					_tmp17_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp19_, VALA_TYPE_CCODE_GOTO_STATEMENT);
				}
				if (_tmp17_) {
					_tmp16_ = TRUE;
				} else {
					ValaCCodeNode* _tmp20_;
					_tmp20_ = statement;
					_tmp16_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp20_, VALA_TYPE_CCODE_CONTINUE_STATEMENT);
				}
				if (_tmp16_) {
					_tmp15_ = TRUE;
				} else {
					ValaCCodeNode* _tmp21_;
					_tmp21_ = statement;
					_tmp15_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_CCODE_BREAK_STATEMENT);
				}
				if (_tmp15_) {
					ValaCCodeNode* _tmp22_;
					ValaCCodeNode* _tmp23_;
					_tmp22_ = statement;
					_tmp23_ = _vala_ccode_node_ref0 (_tmp22_);
					_vala_ccode_node_unref0 (last_statement);
					last_statement = _tmp23_;
				}
			}
			_vala_ccode_node_unref0 (statement);
		}
		_vala_iterable_unref0 (_statement_list);
	}
	{
		ValaList* _statement_list = NULL;
		ValaList* _tmp24_;
		ValaList* _tmp25_;
		gint _statement_size = 0;
		ValaList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _statement_index = 0;
		_tmp24_ = self->priv->statements;
		_tmp25_ = _vala_iterable_ref0 (_tmp24_);
		_statement_list = _tmp25_;
		_tmp26_ = _statement_list;
		_tmp27_ = vala_collection_get_size ((ValaCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_statement_size = _tmp28_;
		_statement_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gint _tmp31_;
			ValaCCodeNode* statement = NULL;
			ValaList* _tmp32_;
			gint _tmp33_;
			gpointer _tmp34_;
			ValaCCodeNode* _tmp35_;
			ValaCCodeNode* _tmp36_;
			ValaCCodeNode* _tmp37_;
			_tmp29_ = _statement_index;
			_statement_index = _tmp29_ + 1;
			_tmp30_ = _statement_index;
			_tmp31_ = _statement_size;
			if (!(_tmp30_ < _tmp31_)) {
				break;
			}
			_tmp32_ = _statement_list;
			_tmp33_ = _statement_index;
			_tmp34_ = vala_list_get (_tmp32_, _tmp33_);
			statement = (ValaCCodeNode*) _tmp34_;
			_tmp35_ = statement;
			vala_ccode_node_write (_tmp35_, writer);
			_tmp36_ = statement;
			_tmp37_ = last_statement;
			if (_tmp36_ == _tmp37_) {
				_vala_ccode_node_unref0 (statement);
				break;
			}
			_vala_ccode_node_unref0 (statement);
		}
		_vala_iterable_unref0 (_statement_list);
	}
	vala_ccode_writer_write_end_block (writer);
	_tmp38_ = self->priv->_suppress_newline;
	if (!_tmp38_) {
		vala_ccode_writer_write_newline (writer);
	}
	_vala_ccode_node_unref0 (last_statement);
}


ValaCCodeBlock*
vala_ccode_block_construct (GType object_type)
{
	ValaCCodeBlock* self = NULL;
	self = (ValaCCodeBlock*) vala_ccode_statement_construct (object_type);
	return self;
}


ValaCCodeBlock*
vala_ccode_block_new (void)
{
	return vala_ccode_block_construct (VALA_TYPE_CCODE_BLOCK);
}


gboolean
vala_ccode_block_get_suppress_newline (ValaCCodeBlock* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_suppress_newline;
	result = _tmp0_;
	return result;
}


void
vala_ccode_block_set_suppress_newline (ValaCCodeBlock* self,
                                       gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_suppress_newline = value;
}


static void
vala_ccode_block_class_init (ValaCCodeBlockClass * klass)
{
	vala_ccode_block_parent_class = g_type_class_peek_parent (klass);
	((ValaCCodeNodeClass *) klass)->finalize = vala_ccode_block_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeBlockPrivate));
	((ValaCCodeNodeClass *) klass)->write = (void (*) (ValaCCodeNode*, ValaCCodeWriter*)) vala_ccode_block_real_write;
}


static void
vala_ccode_block_instance_init (ValaCCodeBlock * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CCODE_BLOCK_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_CCODE_NODE, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp0_);
	self->priv->statements = (ValaList*) _tmp1_;
}


static void
vala_ccode_block_finalize (ValaCCodeNode * obj)
{
	ValaCCodeBlock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CCODE_BLOCK, ValaCCodeBlock);
	_vala_iterable_unref0 (self->priv->statements);
	VALA_CCODE_NODE_CLASS (vala_ccode_block_parent_class)->finalize (obj);
}


/**
 * Represents a C code block.
 */
GType
vala_ccode_block_get_type (void)
{
	static volatile gsize vala_ccode_block_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_block_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeBlockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_block_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeBlock), 0, (GInstanceInitFunc) vala_ccode_block_instance_init, NULL };
		GType vala_ccode_block_type_id;
		vala_ccode_block_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeBlock", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_block_type_id__volatile, vala_ccode_block_type_id);
	}
	return vala_ccode_block_type_id__volatile;
}



