/* valaunaryexpression.c generated by valac, the Vala compiler
 * generated from valaunaryexpression.vala, do not modify */

/* valaunaryexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaUnaryExpressionPrivate {
	ValaUnaryOperator _operator;
	ValaExpression* _inner;
};


static gpointer vala_unary_expression_parent_class = NULL;

#define VALA_UNARY_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpressionPrivate))
static void vala_unary_expression_real_accept (ValaCodeNode* base,
                                        ValaCodeVisitor* visitor);
static void vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                                 ValaCodeVisitor* visitor);
static void vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                                    ValaExpression* old_node,
                                                    ValaExpression* new_node);
static const gchar* vala_unary_expression_get_operator_string (ValaUnaryExpression* self);
static gchar* vala_unary_expression_real_to_string (ValaCodeNode* base);
static gboolean vala_unary_expression_real_is_constant (ValaExpression* base);
static gboolean vala_unary_expression_real_is_pure (ValaExpression* base);
static gboolean vala_unary_expression_real_is_accessible (ValaExpression* base,
                                                   ValaSymbol* sym);
static gboolean vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static gboolean vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                                ValaDataType* type);
static ValaMemberAccess* vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                                            ValaExpression* expr);
static gboolean vala_unary_expression_real_check (ValaCodeNode* base,
                                           ValaCodeContext* context);
static void vala_unary_expression_real_emit (ValaCodeNode* base,
                                      ValaCodeGenerator* codegen);
static void vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                       ValaCollection* collection);
static void vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                                    ValaCollection* collection);
static void vala_unary_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new unary expression.
 *
 * @param op     unary operator
 * @param _inner operand
 * @param source reference to source code
 * @return       newly created binary expression
 */
ValaUnaryExpression*
vala_unary_expression_construct (GType object_type,
                                 ValaUnaryOperator op,
                                 ValaExpression* _inner,
                                 ValaSourceReference* source)
{
	ValaUnaryExpression* self = NULL;
	g_return_val_if_fail (_inner != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaUnaryExpression*) vala_expression_construct (object_type);
	vala_unary_expression_set_operator (self, op);
	vala_unary_expression_set_inner (self, _inner);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaUnaryExpression*
vala_unary_expression_new (ValaUnaryOperator op,
                           ValaExpression* _inner,
                           ValaSourceReference* source)
{
	return vala_unary_expression_construct (VALA_TYPE_UNARY_EXPRESSION, op, _inner, source);
}


static void
vala_unary_expression_real_accept (ValaCodeNode* base,
                                   ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_unary_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_unary_expression_real_accept_children (ValaCodeNode* base,
                                            ValaCodeVisitor* visitor)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
}


static void
vala_unary_expression_real_replace_expression (ValaCodeNode* base,
                                               ValaExpression* old_node,
                                               ValaExpression* new_node)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_unary_expression_set_inner (self, new_node);
	}
}


static const gchar*
vala_unary_expression_get_operator_string (ValaUnaryExpression* self)
{
	const gchar* result = NULL;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_operator;
	switch (_tmp0_) {
		case VALA_UNARY_OPERATOR_PLUS:
		{
			result = "+";
			return result;
		}
		case VALA_UNARY_OPERATOR_MINUS:
		{
			result = "-";
			return result;
		}
		case VALA_UNARY_OPERATOR_LOGICAL_NEGATION:
		{
			result = "!";
			return result;
		}
		case VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT:
		{
			result = "~";
			return result;
		}
		case VALA_UNARY_OPERATOR_INCREMENT:
		{
			result = "++";
			return result;
		}
		case VALA_UNARY_OPERATOR_DECREMENT:
		{
			result = "--";
			return result;
		}
		case VALA_UNARY_OPERATOR_REF:
		{
			result = "ref ";
			return result;
		}
		case VALA_UNARY_OPERATOR_OUT:
		{
			result = "out ";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static gchar*
vala_unary_expression_real_to_string (ValaCodeNode* base)
{
	ValaUnaryExpression * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self = (ValaUnaryExpression*) base;
	_tmp0_ = vala_unary_expression_get_operator_string (self);
	_tmp1_ = self->priv->_inner;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp0_, _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	result = _tmp5_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gboolean
vala_unary_expression_real_is_constant (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	gboolean _tmp3_ = FALSE;
	ValaUnaryOperator _tmp4_;
	ValaExpression* _tmp16_;
	ValaExpression* _tmp17_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp4_ = self->priv->_operator;
	if (_tmp4_ == VALA_UNARY_OPERATOR_REF) {
		_tmp3_ = TRUE;
	} else {
		ValaUnaryOperator _tmp5_;
		_tmp5_ = self->priv->_operator;
		_tmp3_ = _tmp5_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp3_) {
		ValaField* field = NULL;
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaSymbol* _tmp9_;
		ValaField* _tmp10_;
		gboolean _tmp11_ = FALSE;
		ValaField* _tmp12_;
		_tmp6_ = vala_unary_expression_get_inner (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = vala_expression_get_symbol_reference (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp9_, VALA_TYPE_FIELD) ? ((ValaField*) _tmp9_) : NULL);
		field = _tmp10_;
		_tmp12_ = field;
		if (_tmp12_ != NULL) {
			ValaField* _tmp13_;
			ValaMemberBinding _tmp14_;
			ValaMemberBinding _tmp15_;
			_tmp13_ = field;
			_tmp14_ = vala_field_get_binding (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp11_ = _tmp15_ == VALA_MEMBER_BINDING_STATIC;
		} else {
			_tmp11_ = FALSE;
		}
		if (_tmp11_) {
			result = TRUE;
			_vala_code_node_unref0 (field);
			return result;
		} else {
			result = FALSE;
			_vala_code_node_unref0 (field);
			return result;
		}
		_vala_code_node_unref0 (field);
	}
	_tmp16_ = vala_unary_expression_get_inner (self);
	_tmp17_ = _tmp16_;
	result = vala_expression_is_constant (_tmp17_);
	return result;
}


static gboolean
vala_unary_expression_real_is_pure (ValaExpression* base)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ValaUnaryOperator _tmp1_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	self = (ValaUnaryExpression*) base;
	_tmp1_ = self->priv->_operator;
	if (_tmp1_ == VALA_UNARY_OPERATOR_INCREMENT) {
		_tmp0_ = TRUE;
	} else {
		ValaUnaryOperator _tmp2_;
		_tmp2_ = self->priv->_operator;
		_tmp0_ = _tmp2_ == VALA_UNARY_OPERATOR_DECREMENT;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = vala_unary_expression_get_inner (self);
	_tmp4_ = _tmp3_;
	result = vala_expression_is_pure (_tmp4_);
	return result;
}


static gboolean
vala_unary_expression_real_is_accessible (ValaExpression* base,
                                          ValaSymbol* sym)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	result = vala_expression_is_accessible (_tmp1_, sym);
	return result;
}


static gboolean
vala_unary_expression_is_numeric_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaStruct* _tmp4_;
	gboolean _tmp5_ = FALSE;
	ValaStruct* _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRUCT)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_data_type_get_data_type (type);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp4_;
	_tmp6_ = st;
	if (vala_struct_is_integer_type (_tmp6_)) {
		_tmp5_ = TRUE;
	} else {
		ValaStruct* _tmp7_;
		_tmp7_ = st;
		_tmp5_ = vala_struct_is_floating_type (_tmp7_);
	}
	result = _tmp5_;
	_vala_code_node_unref0 (st);
	return result;
}


static gboolean
vala_unary_expression_is_integer_type (ValaUnaryExpression* self,
                                       ValaDataType* type)
{
	gboolean result = FALSE;
	ValaTypeSymbol* _tmp0_;
	ValaTypeSymbol* _tmp1_;
	ValaStruct* st = NULL;
	ValaTypeSymbol* _tmp2_;
	ValaTypeSymbol* _tmp3_;
	ValaStruct* _tmp4_;
	ValaStruct* _tmp5_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (type != NULL, FALSE);
	_tmp0_ = vala_data_type_get_data_type (type);
	_tmp1_ = _tmp0_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, VALA_TYPE_STRUCT)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = vala_data_type_get_data_type (type);
	_tmp3_ = _tmp2_;
	_tmp4_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALA_TYPE_STRUCT, ValaStruct));
	st = _tmp4_;
	_tmp5_ = st;
	result = vala_struct_is_integer_type (_tmp5_);
	_vala_code_node_unref0 (st);
	return result;
}


static ValaMemberAccess*
vala_unary_expression_find_member_access (ValaUnaryExpression* self,
                                          ValaExpression* expr)
{
	ValaMemberAccess* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (expr != NULL, NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (expr, VALA_TYPE_MEMBER_ACCESS)) {
		ValaMemberAccess* _tmp0_;
		_tmp0_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (expr, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
		result = _tmp0_;
		return result;
	}
	result = NULL;
	return result;
}


static gboolean
vala_unary_expression_real_check (ValaCodeNode* base,
                                  ValaCodeContext* context)
{
	ValaUnaryExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_ = FALSE;
	ValaUnaryOperator _tmp5_;
	ValaExpression* _tmp18_;
	ValaExpression* _tmp19_;
	gboolean _tmp20_ = FALSE;
	ValaExpression* _tmp21_;
	ValaExpression* _tmp22_;
	ValaDataType* _tmp23_;
	ValaDataType* _tmp24_;
	gboolean _tmp41_ = FALSE;
	ValaUnaryOperator _tmp42_;
	gboolean _tmp202_;
	gboolean _tmp203_;
	self = (ValaUnaryExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp5_ = self->priv->_operator;
	if (_tmp5_ == VALA_UNARY_OPERATOR_REF) {
		_tmp4_ = TRUE;
	} else {
		ValaUnaryOperator _tmp6_;
		_tmp6_ = self->priv->_operator;
		_tmp4_ = _tmp6_ == VALA_UNARY_OPERATOR_OUT;
	}
	if (_tmp4_) {
		ValaExpression* _tmp7_;
		ValaExpression* _tmp8_;
		ValaExpression* _tmp9_;
		ValaExpression* _tmp10_;
		ValaDataType* _tmp11_;
		ValaDataType* _tmp12_;
		_tmp7_ = vala_unary_expression_get_inner (self);
		_tmp8_ = _tmp7_;
		vala_expression_set_lvalue (_tmp8_, TRUE);
		_tmp9_ = vala_unary_expression_get_inner (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = vala_expression_get_target_type ((ValaExpression*) self);
		_tmp12_ = _tmp11_;
		vala_expression_set_target_type (_tmp10_, _tmp12_);
	} else {
		gboolean _tmp13_ = FALSE;
		ValaUnaryOperator _tmp14_;
		_tmp14_ = self->priv->_operator;
		if (_tmp14_ == VALA_UNARY_OPERATOR_INCREMENT) {
			_tmp13_ = TRUE;
		} else {
			ValaUnaryOperator _tmp15_;
			_tmp15_ = self->priv->_operator;
			_tmp13_ = _tmp15_ == VALA_UNARY_OPERATOR_DECREMENT;
		}
		if (_tmp13_) {
			ValaExpression* _tmp16_;
			ValaExpression* _tmp17_;
			_tmp16_ = vala_unary_expression_get_inner (self);
			_tmp17_ = _tmp16_;
			vala_expression_set_lvalue (_tmp17_, TRUE);
		}
	}
	_tmp18_ = vala_unary_expression_get_inner (self);
	_tmp19_ = _tmp18_;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp19_, context)) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp21_ = vala_unary_expression_get_inner (self);
	_tmp22_ = _tmp21_;
	_tmp23_ = vala_expression_get_value_type (_tmp22_);
	_tmp24_ = _tmp23_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_FIELD_PROTOTYPE)) {
		_tmp20_ = TRUE;
	} else {
		ValaExpression* _tmp25_;
		ValaExpression* _tmp26_;
		ValaDataType* _tmp27_;
		ValaDataType* _tmp28_;
		_tmp25_ = vala_unary_expression_get_inner (self);
		_tmp26_ = _tmp25_;
		_tmp27_ = vala_expression_get_value_type (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp20_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_PROPERTY_PROTOTYPE);
	}
	if (_tmp20_) {
		ValaExpression* _tmp29_;
		ValaExpression* _tmp30_;
		ValaSourceReference* _tmp31_;
		ValaSourceReference* _tmp32_;
		ValaExpression* _tmp33_;
		ValaExpression* _tmp34_;
		ValaSymbol* _tmp35_;
		ValaSymbol* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp29_ = vala_unary_expression_get_inner (self);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = vala_unary_expression_get_inner (self);
		_tmp34_ = _tmp33_;
		_tmp35_ = vala_expression_get_symbol_reference (_tmp34_);
		_tmp36_ = _tmp35_;
		_tmp37_ = vala_symbol_get_full_name (_tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strdup_printf ("Access to instance member `%s' denied", _tmp38_);
		_tmp40_ = _tmp39_;
		vala_report_error (_tmp32_, _tmp40_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		result = FALSE;
		return result;
	}
	_tmp42_ = self->priv->_operator;
	if (_tmp42_ == VALA_UNARY_OPERATOR_PLUS) {
		_tmp41_ = TRUE;
	} else {
		ValaUnaryOperator _tmp43_;
		_tmp43_ = self->priv->_operator;
		_tmp41_ = _tmp43_ == VALA_UNARY_OPERATOR_MINUS;
	}
	if (_tmp41_) {
		ValaExpression* _tmp44_;
		ValaExpression* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		ValaExpression* _tmp58_;
		ValaExpression* _tmp59_;
		ValaDataType* _tmp60_;
		ValaDataType* _tmp61_;
		_tmp44_ = vala_unary_expression_get_inner (self);
		_tmp45_ = _tmp44_;
		_tmp46_ = vala_expression_get_value_type (_tmp45_);
		_tmp47_ = _tmp46_;
		if (!vala_unary_expression_is_numeric_type (self, _tmp47_)) {
			ValaSourceReference* _tmp48_;
			ValaSourceReference* _tmp49_;
			ValaExpression* _tmp50_;
			ValaExpression* _tmp51_;
			ValaDataType* _tmp52_;
			ValaDataType* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp49_ = _tmp48_;
			_tmp50_ = vala_unary_expression_get_inner (self);
			_tmp51_ = _tmp50_;
			_tmp52_ = vala_expression_get_value_type (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_code_node_to_string ((ValaCodeNode*) _tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = g_strdup_printf ("Operator not supported for `%s'", _tmp55_);
			_tmp57_ = _tmp56_;
			vala_report_error (_tmp49_, _tmp57_);
			_g_free0 (_tmp57_);
			_g_free0 (_tmp55_);
			result = FALSE;
			return result;
		}
		_tmp58_ = vala_unary_expression_get_inner (self);
		_tmp59_ = _tmp58_;
		_tmp60_ = vala_expression_get_value_type (_tmp59_);
		_tmp61_ = _tmp60_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp61_);
	} else {
		ValaUnaryOperator _tmp62_;
		_tmp62_ = self->priv->_operator;
		if (_tmp62_ == VALA_UNARY_OPERATOR_LOGICAL_NEGATION) {
			ValaExpression* _tmp63_;
			ValaExpression* _tmp64_;
			ValaDataType* _tmp65_;
			ValaDataType* _tmp66_;
			ValaSemanticAnalyzer* _tmp67_;
			ValaSemanticAnalyzer* _tmp68_;
			ValaDataType* _tmp69_;
			ValaExpression* _tmp80_;
			ValaExpression* _tmp81_;
			ValaDataType* _tmp82_;
			ValaDataType* _tmp83_;
			_tmp63_ = vala_unary_expression_get_inner (self);
			_tmp64_ = _tmp63_;
			_tmp65_ = vala_expression_get_value_type (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = vala_code_context_get_analyzer (context);
			_tmp68_ = _tmp67_;
			_tmp69_ = _tmp68_->bool_type;
			if (!vala_data_type_compatible (_tmp66_, _tmp69_)) {
				ValaSourceReference* _tmp70_;
				ValaSourceReference* _tmp71_;
				ValaExpression* _tmp72_;
				ValaExpression* _tmp73_;
				ValaDataType* _tmp74_;
				ValaDataType* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp70_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp71_ = _tmp70_;
				_tmp72_ = vala_unary_expression_get_inner (self);
				_tmp73_ = _tmp72_;
				_tmp74_ = vala_expression_get_value_type (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_code_node_to_string ((ValaCodeNode*) _tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = g_strdup_printf ("Operator not supported for `%s'", _tmp77_);
				_tmp79_ = _tmp78_;
				vala_report_error (_tmp71_, _tmp79_);
				_g_free0 (_tmp79_);
				_g_free0 (_tmp77_);
				result = FALSE;
				return result;
			}
			_tmp80_ = vala_unary_expression_get_inner (self);
			_tmp81_ = _tmp80_;
			_tmp82_ = vala_expression_get_value_type (_tmp81_);
			_tmp83_ = _tmp82_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp83_);
		} else {
			ValaUnaryOperator _tmp84_;
			_tmp84_ = self->priv->_operator;
			if (_tmp84_ == VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT) {
				gboolean _tmp85_ = FALSE;
				ValaExpression* _tmp86_;
				ValaExpression* _tmp87_;
				ValaDataType* _tmp88_;
				ValaDataType* _tmp89_;
				ValaExpression* _tmp104_;
				ValaExpression* _tmp105_;
				ValaDataType* _tmp106_;
				ValaDataType* _tmp107_;
				_tmp86_ = vala_unary_expression_get_inner (self);
				_tmp87_ = _tmp86_;
				_tmp88_ = vala_expression_get_value_type (_tmp87_);
				_tmp89_ = _tmp88_;
				if (!vala_unary_expression_is_integer_type (self, _tmp89_)) {
					ValaExpression* _tmp90_;
					ValaExpression* _tmp91_;
					ValaDataType* _tmp92_;
					ValaDataType* _tmp93_;
					_tmp90_ = vala_unary_expression_get_inner (self);
					_tmp91_ = _tmp90_;
					_tmp92_ = vala_expression_get_value_type (_tmp91_);
					_tmp93_ = _tmp92_;
					_tmp85_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp93_, VALA_TYPE_ENUM_VALUE_TYPE);
				} else {
					_tmp85_ = FALSE;
				}
				if (_tmp85_) {
					ValaSourceReference* _tmp94_;
					ValaSourceReference* _tmp95_;
					ValaExpression* _tmp96_;
					ValaExpression* _tmp97_;
					ValaDataType* _tmp98_;
					ValaDataType* _tmp99_;
					gchar* _tmp100_;
					gchar* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp94_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp95_ = _tmp94_;
					_tmp96_ = vala_unary_expression_get_inner (self);
					_tmp97_ = _tmp96_;
					_tmp98_ = vala_expression_get_value_type (_tmp97_);
					_tmp99_ = _tmp98_;
					_tmp100_ = vala_code_node_to_string ((ValaCodeNode*) _tmp99_);
					_tmp101_ = _tmp100_;
					_tmp102_ = g_strdup_printf ("Operator not supported for `%s'", _tmp101_);
					_tmp103_ = _tmp102_;
					vala_report_error (_tmp95_, _tmp103_);
					_g_free0 (_tmp103_);
					_g_free0 (_tmp101_);
					result = FALSE;
					return result;
				}
				_tmp104_ = vala_unary_expression_get_inner (self);
				_tmp105_ = _tmp104_;
				_tmp106_ = vala_expression_get_value_type (_tmp105_);
				_tmp107_ = _tmp106_;
				vala_expression_set_value_type ((ValaExpression*) self, _tmp107_);
			} else {
				gboolean _tmp108_ = FALSE;
				ValaUnaryOperator _tmp109_;
				_tmp109_ = self->priv->_operator;
				if (_tmp109_ == VALA_UNARY_OPERATOR_INCREMENT) {
					_tmp108_ = TRUE;
				} else {
					ValaUnaryOperator _tmp110_;
					_tmp110_ = self->priv->_operator;
					_tmp108_ = _tmp110_ == VALA_UNARY_OPERATOR_DECREMENT;
				}
				if (_tmp108_) {
					ValaExpression* _tmp111_;
					ValaExpression* _tmp112_;
					ValaDataType* _tmp113_;
					ValaDataType* _tmp114_;
					ValaMemberAccess* ma = NULL;
					ValaExpression* _tmp125_;
					ValaExpression* _tmp126_;
					ValaMemberAccess* _tmp127_;
					ValaMemberAccess* _tmp128_;
					ValaMemberAccess* old_value = NULL;
					ValaMemberAccess* _tmp131_;
					ValaExpression* _tmp132_;
					ValaExpression* _tmp133_;
					ValaMemberAccess* _tmp134_;
					const gchar* _tmp135_;
					const gchar* _tmp136_;
					ValaExpression* _tmp137_;
					ValaExpression* _tmp138_;
					ValaSourceReference* _tmp139_;
					ValaSourceReference* _tmp140_;
					ValaMemberAccess* _tmp141_;
					ValaBinaryOperator _tmp142_ = 0;
					ValaUnaryOperator _tmp143_;
					ValaBinaryExpression* bin = NULL;
					ValaMemberAccess* _tmp144_;
					ValaIntegerLiteral* _tmp145_;
					ValaIntegerLiteral* _tmp146_;
					ValaSourceReference* _tmp147_;
					ValaSourceReference* _tmp148_;
					ValaBinaryExpression* _tmp149_;
					ValaBinaryExpression* _tmp150_;
					ValaAssignment* assignment = NULL;
					ValaMemberAccess* _tmp151_;
					ValaBinaryExpression* _tmp152_;
					ValaSourceReference* _tmp153_;
					ValaSourceReference* _tmp154_;
					ValaAssignment* _tmp155_;
					ValaAssignment* _tmp156_;
					ValaDataType* _tmp157_;
					ValaDataType* _tmp158_;
					ValaSemanticAnalyzer* _tmp159_;
					ValaSemanticAnalyzer* _tmp160_;
					ValaList* _tmp161_;
					ValaCodeNode* _tmp162_;
					ValaCodeNode* _tmp163_;
					ValaAssignment* _tmp164_;
					ValaAssignment* _tmp165_;
					_tmp111_ = vala_unary_expression_get_inner (self);
					_tmp112_ = _tmp111_;
					_tmp113_ = vala_expression_get_value_type (_tmp112_);
					_tmp114_ = _tmp113_;
					if (!vala_unary_expression_is_integer_type (self, _tmp114_)) {
						ValaSourceReference* _tmp115_;
						ValaSourceReference* _tmp116_;
						ValaExpression* _tmp117_;
						ValaExpression* _tmp118_;
						ValaDataType* _tmp119_;
						ValaDataType* _tmp120_;
						gchar* _tmp121_;
						gchar* _tmp122_;
						gchar* _tmp123_;
						gchar* _tmp124_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp115_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp116_ = _tmp115_;
						_tmp117_ = vala_unary_expression_get_inner (self);
						_tmp118_ = _tmp117_;
						_tmp119_ = vala_expression_get_value_type (_tmp118_);
						_tmp120_ = _tmp119_;
						_tmp121_ = vala_code_node_to_string ((ValaCodeNode*) _tmp120_);
						_tmp122_ = _tmp121_;
						_tmp123_ = g_strdup_printf ("Operator not supported for `%s'", _tmp122_);
						_tmp124_ = _tmp123_;
						vala_report_error (_tmp116_, _tmp124_);
						_g_free0 (_tmp124_);
						_g_free0 (_tmp122_);
						result = FALSE;
						return result;
					}
					_tmp125_ = vala_unary_expression_get_inner (self);
					_tmp126_ = _tmp125_;
					_tmp127_ = vala_unary_expression_find_member_access (self, _tmp126_);
					ma = _tmp127_;
					_tmp128_ = ma;
					if (_tmp128_ == NULL) {
						ValaSourceReference* _tmp129_;
						ValaSourceReference* _tmp130_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp129_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp130_ = _tmp129_;
						vala_report_error (_tmp130_, "Prefix operators not supported for this expression");
						result = FALSE;
						_vala_code_node_unref0 (ma);
						return result;
					}
					_tmp131_ = ma;
					_tmp132_ = vala_member_access_get_inner (_tmp131_);
					_tmp133_ = _tmp132_;
					_tmp134_ = ma;
					_tmp135_ = vala_member_access_get_member_name (_tmp134_);
					_tmp136_ = _tmp135_;
					_tmp137_ = vala_unary_expression_get_inner (self);
					_tmp138_ = _tmp137_;
					_tmp139_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp138_);
					_tmp140_ = _tmp139_;
					_tmp141_ = vala_member_access_new (_tmp133_, _tmp136_, _tmp140_);
					old_value = _tmp141_;
					_tmp143_ = self->priv->_operator;
					if (_tmp143_ == VALA_UNARY_OPERATOR_INCREMENT) {
						_tmp142_ = VALA_BINARY_OPERATOR_PLUS;
					} else {
						_tmp142_ = VALA_BINARY_OPERATOR_MINUS;
					}
					_tmp144_ = old_value;
					_tmp145_ = vala_integer_literal_new ("1", NULL);
					_tmp146_ = _tmp145_;
					_tmp147_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp148_ = _tmp147_;
					_tmp149_ = vala_binary_expression_new (_tmp142_, (ValaExpression*) _tmp144_, (ValaExpression*) _tmp146_, _tmp148_);
					_tmp150_ = _tmp149_;
					_vala_code_node_unref0 (_tmp146_);
					bin = _tmp150_;
					_tmp151_ = ma;
					_tmp152_ = bin;
					_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp154_ = _tmp153_;
					_tmp155_ = vala_assignment_new ((ValaExpression*) _tmp151_, (ValaExpression*) _tmp152_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp154_);
					assignment = _tmp155_;
					_tmp156_ = assignment;
					_tmp157_ = vala_expression_get_target_type ((ValaExpression*) self);
					_tmp158_ = _tmp157_;
					vala_expression_set_target_type ((ValaExpression*) _tmp156_, _tmp158_);
					_tmp159_ = vala_code_context_get_analyzer (context);
					_tmp160_ = _tmp159_;
					_tmp161_ = _tmp160_->replaced_nodes;
					vala_collection_add ((ValaCollection*) _tmp161_, (ValaCodeNode*) self);
					_tmp162_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
					_tmp163_ = _tmp162_;
					_tmp164_ = assignment;
					vala_code_node_replace_expression (_tmp163_, (ValaExpression*) self, (ValaExpression*) _tmp164_);
					_tmp165_ = assignment;
					vala_code_node_check ((ValaCodeNode*) _tmp165_, context);
					result = TRUE;
					_vala_code_node_unref0 (assignment);
					_vala_code_node_unref0 (bin);
					_vala_code_node_unref0 (old_value);
					_vala_code_node_unref0 (ma);
					return result;
				} else {
					gboolean _tmp166_ = FALSE;
					ValaUnaryOperator _tmp167_;
					_tmp167_ = self->priv->_operator;
					if (_tmp167_ == VALA_UNARY_OPERATOR_REF) {
						_tmp166_ = TRUE;
					} else {
						ValaUnaryOperator _tmp168_;
						_tmp168_ = self->priv->_operator;
						_tmp166_ = _tmp168_ == VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp166_) {
						ValaElementAccess* ea = NULL;
						ValaExpression* _tmp169_;
						ValaExpression* _tmp170_;
						ValaElementAccess* _tmp171_;
						gboolean _tmp172_ = FALSE;
						gboolean _tmp173_ = FALSE;
						gboolean _tmp174_ = FALSE;
						ValaExpression* _tmp175_;
						ValaExpression* _tmp176_;
						ValaSymbol* _tmp177_;
						ValaSymbol* _tmp178_;
						_tmp169_ = vala_unary_expression_get_inner (self);
						_tmp170_ = _tmp169_;
						_tmp171_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp170_, VALA_TYPE_ELEMENT_ACCESS) ? ((ValaElementAccess*) _tmp170_) : NULL);
						ea = _tmp171_;
						_tmp175_ = vala_unary_expression_get_inner (self);
						_tmp176_ = _tmp175_;
						_tmp177_ = vala_expression_get_symbol_reference (_tmp176_);
						_tmp178_ = _tmp177_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp178_, VALA_TYPE_FIELD)) {
							_tmp174_ = TRUE;
						} else {
							ValaExpression* _tmp179_;
							ValaExpression* _tmp180_;
							ValaSymbol* _tmp181_;
							ValaSymbol* _tmp182_;
							_tmp179_ = vala_unary_expression_get_inner (self);
							_tmp180_ = _tmp179_;
							_tmp181_ = vala_expression_get_symbol_reference (_tmp180_);
							_tmp182_ = _tmp181_;
							_tmp174_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp182_, VALA_TYPE_PARAMETER);
						}
						if (_tmp174_) {
							_tmp173_ = TRUE;
						} else {
							ValaExpression* _tmp183_;
							ValaExpression* _tmp184_;
							ValaSymbol* _tmp185_;
							ValaSymbol* _tmp186_;
							_tmp183_ = vala_unary_expression_get_inner (self);
							_tmp184_ = _tmp183_;
							_tmp185_ = vala_expression_get_symbol_reference (_tmp184_);
							_tmp186_ = _tmp185_;
							_tmp173_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp186_, VALA_TYPE_LOCAL_VARIABLE);
						}
						if (_tmp173_) {
							_tmp172_ = TRUE;
						} else {
							gboolean _tmp187_ = FALSE;
							ValaElementAccess* _tmp188_;
							_tmp188_ = ea;
							if (_tmp188_ != NULL) {
								ValaElementAccess* _tmp189_;
								ValaExpression* _tmp190_;
								ValaExpression* _tmp191_;
								ValaDataType* _tmp192_;
								ValaDataType* _tmp193_;
								_tmp189_ = ea;
								_tmp190_ = vala_element_access_get_container (_tmp189_);
								_tmp191_ = _tmp190_;
								_tmp192_ = vala_expression_get_value_type (_tmp191_);
								_tmp193_ = _tmp192_;
								_tmp187_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp193_, VALA_TYPE_ARRAY_TYPE);
							} else {
								_tmp187_ = FALSE;
							}
							_tmp172_ = _tmp187_;
						}
						if (_tmp172_) {
							ValaExpression* _tmp194_;
							ValaExpression* _tmp195_;
							ValaDataType* _tmp196_;
							ValaDataType* _tmp197_;
							vala_expression_set_lvalue ((ValaExpression*) self, TRUE);
							_tmp194_ = vala_unary_expression_get_inner (self);
							_tmp195_ = _tmp194_;
							_tmp196_ = vala_expression_get_value_type (_tmp195_);
							_tmp197_ = _tmp196_;
							vala_expression_set_value_type ((ValaExpression*) self, _tmp197_);
						} else {
							ValaSourceReference* _tmp198_;
							ValaSourceReference* _tmp199_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp198_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp199_ = _tmp198_;
							vala_report_error (_tmp199_, "ref and out method arguments can only be used with fields, parameters," \
" local variables, and array element access");
							result = FALSE;
							_vala_code_node_unref0 (ea);
							return result;
						}
						_vala_code_node_unref0 (ea);
					} else {
						ValaSourceReference* _tmp200_;
						ValaSourceReference* _tmp201_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp200_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp201_ = _tmp200_;
						vala_report_error (_tmp201_, "internal error: unsupported unary operator");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp202_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp203_ = _tmp202_;
	result = !_tmp203_;
	return result;
}


static void
vala_unary_expression_real_emit (ValaCodeNode* base,
                                 ValaCodeGenerator* codegen)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (codegen != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_emit ((ValaCodeNode*) _tmp1_, codegen);
	vala_code_visitor_visit_unary_expression ((ValaCodeVisitor*) codegen, self);
	vala_code_visitor_visit_expression ((ValaCodeVisitor*) codegen, (ValaExpression*) self);
}


static void
vala_unary_expression_real_get_defined_variables (ValaCodeNode* base,
                                                  ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gboolean _tmp2_ = FALSE;
	ValaUnaryOperator _tmp3_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_unary_expression_get_inner (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp3_ = self->priv->_operator;
	if (_tmp3_ == VALA_UNARY_OPERATOR_OUT) {
		_tmp2_ = TRUE;
	} else {
		ValaUnaryOperator _tmp4_;
		_tmp4_ = self->priv->_operator;
		_tmp2_ = _tmp4_ == VALA_UNARY_OPERATOR_REF;
	}
	if (_tmp2_) {
		ValaLocalVariable* local = NULL;
		ValaExpression* _tmp5_;
		ValaExpression* _tmp6_;
		ValaSymbol* _tmp7_;
		ValaSymbol* _tmp8_;
		ValaLocalVariable* _tmp9_;
		ValaParameter* param = NULL;
		ValaExpression* _tmp10_;
		ValaExpression* _tmp11_;
		ValaSymbol* _tmp12_;
		ValaSymbol* _tmp13_;
		ValaParameter* _tmp14_;
		ValaLocalVariable* _tmp15_;
		gboolean _tmp17_ = FALSE;
		ValaParameter* _tmp18_;
		_tmp5_ = vala_unary_expression_get_inner (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = vala_expression_get_symbol_reference (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp8_) : NULL);
		local = _tmp9_;
		_tmp10_ = vala_unary_expression_get_inner (self);
		_tmp11_ = _tmp10_;
		_tmp12_ = vala_expression_get_symbol_reference (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp13_, VALA_TYPE_PARAMETER) ? ((ValaParameter*) _tmp13_) : NULL);
		param = _tmp14_;
		_tmp15_ = local;
		if (_tmp15_ != NULL) {
			ValaLocalVariable* _tmp16_;
			_tmp16_ = local;
			vala_collection_add (collection, (ValaVariable*) _tmp16_);
		}
		_tmp18_ = param;
		if (_tmp18_ != NULL) {
			ValaParameter* _tmp19_;
			ValaParameterDirection _tmp20_;
			ValaParameterDirection _tmp21_;
			_tmp19_ = param;
			_tmp20_ = vala_parameter_get_direction (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp17_ = _tmp21_ == VALA_PARAMETER_DIRECTION_OUT;
		} else {
			_tmp17_ = FALSE;
		}
		if (_tmp17_) {
			ValaParameter* _tmp22_;
			_tmp22_ = param;
			vala_collection_add (collection, (ValaVariable*) _tmp22_);
		}
		_vala_code_node_unref0 (param);
		_vala_code_node_unref0 (local);
	}
}


static void
vala_unary_expression_real_get_used_variables (ValaCodeNode* base,
                                               ValaCollection* collection)
{
	ValaUnaryExpression * self;
	ValaUnaryOperator _tmp0_;
	self = (ValaUnaryExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = self->priv->_operator;
	if (_tmp0_ != VALA_UNARY_OPERATOR_OUT) {
		ValaExpression* _tmp1_;
		ValaExpression* _tmp2_;
		_tmp1_ = vala_unary_expression_get_inner (self);
		_tmp2_ = _tmp1_;
		vala_code_node_get_used_variables ((ValaCodeNode*) _tmp2_, collection);
	}
}


ValaUnaryOperator
vala_unary_expression_get_operator (ValaUnaryExpression* self)
{
	ValaUnaryOperator result;
	ValaUnaryOperator _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_operator;
	result = _tmp0_;
	return result;
}


void
vala_unary_expression_set_operator (ValaUnaryExpression* self,
                                    ValaUnaryOperator value)
{
	g_return_if_fail (self != NULL);
	self->priv->_operator = value;
}


ValaExpression*
vala_unary_expression_get_inner (ValaUnaryExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_inner;
	result = _tmp0_;
	return result;
}


void
vala_unary_expression_set_inner (ValaUnaryExpression* self,
                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_inner);
	self->priv->_inner = _tmp0_;
	_tmp1_ = self->priv->_inner;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_unary_expression_class_init (ValaUnaryExpressionClass * klass)
{
	vala_unary_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_unary_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaUnaryExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode*, ValaCodeVisitor*)) vala_unary_expression_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode*, ValaExpression*, ValaExpression*)) vala_unary_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode*)) vala_unary_expression_real_to_string;
	((ValaExpressionClass *) klass)->is_constant = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_constant;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression*)) vala_unary_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression*, ValaSymbol*)) vala_unary_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode*, ValaCodeContext*)) vala_unary_expression_real_check;
	((ValaCodeNodeClass *) klass)->emit = (void (*) (ValaCodeNode*, ValaCodeGenerator*)) vala_unary_expression_real_emit;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode*, ValaCollection*)) vala_unary_expression_real_get_used_variables;
}


static void
vala_unary_expression_instance_init (ValaUnaryExpression * self)
{
	self->priv = VALA_UNARY_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_unary_expression_finalize (ValaCodeNode * obj)
{
	ValaUnaryExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_UNARY_EXPRESSION, ValaUnaryExpression);
	_vala_code_node_unref0 (self->priv->_inner);
	VALA_CODE_NODE_CLASS (vala_unary_expression_parent_class)->finalize (obj);
}


/**
 * Represents an expression with one operand in the source code.
 *
 * Supports +, -, !, ~, ref, out.
 */
GType
vala_unary_expression_get_type (void)
{
	static volatile gsize vala_unary_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaUnaryExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_unary_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaUnaryExpression), 0, (GInstanceInitFunc) vala_unary_expression_instance_init, NULL };
		GType vala_unary_expression_type_id;
		vala_unary_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaUnaryExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_unary_expression_type_id__volatile, vala_unary_expression_type_id);
	}
	return vala_unary_expression_type_id__volatile;
}


GType
vala_unary_operator_get_type (void)
{
	static volatile gsize vala_unary_operator_type_id__volatile = 0;
	if (g_once_init_enter (&vala_unary_operator_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_UNARY_OPERATOR_NONE, "VALA_UNARY_OPERATOR_NONE", "none"}, {VALA_UNARY_OPERATOR_PLUS, "VALA_UNARY_OPERATOR_PLUS", "plus"}, {VALA_UNARY_OPERATOR_MINUS, "VALA_UNARY_OPERATOR_MINUS", "minus"}, {VALA_UNARY_OPERATOR_LOGICAL_NEGATION, "VALA_UNARY_OPERATOR_LOGICAL_NEGATION", "logical-negation"}, {VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT, "VALA_UNARY_OPERATOR_BITWISE_COMPLEMENT", "bitwise-complement"}, {VALA_UNARY_OPERATOR_INCREMENT, "VALA_UNARY_OPERATOR_INCREMENT", "increment"}, {VALA_UNARY_OPERATOR_DECREMENT, "VALA_UNARY_OPERATOR_DECREMENT", "decrement"}, {VALA_UNARY_OPERATOR_REF, "VALA_UNARY_OPERATOR_REF", "ref"}, {VALA_UNARY_OPERATOR_OUT, "VALA_UNARY_OPERATOR_OUT", "out"}, {0, NULL, NULL}};
		GType vala_unary_operator_type_id;
		vala_unary_operator_type_id = g_enum_register_static ("ValaUnaryOperator", values);
		g_once_init_leave (&vala_unary_operator_type_id__volatile, vala_unary_operator_type_id);
	}
	return vala_unary_operator_type_id__volatile;
}



