/* basicdoclet.c generated by valac, the Vala compiler
 * generated from basicdoclet.vala, do not modify */

/* basicdoclet.vala
 *
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */


#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>
#include <glib/gstdio.h>
#include <stdio.h>

enum  {
	VALADOC_HTML_BASIC_DOCLET_0_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY,
	VALADOC_HTML_BASIC_DOCLET_NUM_PROPERTIES
};
static GParamSpec* valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _valadoc_api_tree_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_api_tree_unref (var), NULL)))
#define _valadoc_markup_writer_unref0(var) ((var == NULL) ? NULL : (var = (valadoc_markup_writer_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHtmlBasicDocletPrivate {
	ValadocHtmlLinkHelper* _linker;
	ValadocSettings* _settings;
	gchar* _wiki_index_name;
	guint html_id_counter;
};


static gpointer valadoc_html_basic_doclet_parent_class = NULL;
static ValadocApiNodeType* valadoc_html_basic_doclet_inheritable_members;
static gint valadoc_html_basic_doclet_inheritable_members_length1;
static ValadocApiNodeType* valadoc_html_basic_doclet_inheritable_members = NULL;
static gint valadoc_html_basic_doclet_inheritable_members_length1 = 0;
static gint _valadoc_html_basic_doclet_inheritable_members_size_ = 0;
static ValadocDocletIface * valadoc_html_basic_doclet_valadoc_doclet_parent_iface = NULL;

#define VALADOC_HTML_BASIC_DOCLET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDocletPrivate))
#define VALADOC_HTML_BASIC_DOCLET_css_inline_navigation "navi_inline"
#define VALADOC_HTML_BASIC_DOCLET_css_package_index "package_index"
#define VALADOC_HTML_BASIC_DOCLET_css_brief_description "brief_description"
#define VALADOC_HTML_BASIC_DOCLET_css_description "description"
#define VALADOC_HTML_BASIC_DOCLET_css_known_list "known_nodes"
#define VALADOC_HTML_BASIC_DOCLET_css_leaf_brief_description "leaf_brief_description"
#define VALADOC_HTML_BASIC_DOCLET_css_leaf_code_definition "leaf_code_definition"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline_text "text"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline_toggle "toggle"
#define VALADOC_HTML_BASIC_DOCLET_css_box_headline "headline"
#define VALADOC_HTML_BASIC_DOCLET_css_box_content "content"
#define VALADOC_HTML_BASIC_DOCLET_css_box_column "column"
#define VALADOC_HTML_BASIC_DOCLET_css_box "box"
#define VALADOC_HTML_BASIC_DOCLET_css_namespace_note "namespace_note"
#define VALADOC_HTML_BASIC_DOCLET_css_package_note "package_note"
#define VALADOC_HTML_BASIC_DOCLET_css_site_header "site_header"
#define VALADOC_HTML_BASIC_DOCLET_css_navi "navi_main"
#define VALADOC_HTML_BASIC_DOCLET_css_navi_hr "navi_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table_name "main_errordomain_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table_text "main_errordomain_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_errordomain_table "main_errordomain_table"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table_name "main_enum_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table_text "main_enum_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_enum_table "main_enum_table"
#define VALADOC_HTML_BASIC_DOCLET_css_diagram "main_diagram"
#define VALADOC_HTML_BASIC_DOCLET_css_see_list "main_see_list"
#define VALADOC_HTML_BASIC_DOCLET_css_wiki_table "main_table"
#define VALADOC_HTML_BASIC_DOCLET_css_notification_area "main_notification"
#define VALADOC_HTML_BASIC_DOCLET_css_source_sample "main_sourcesample"
#define VALADOC_HTML_BASIC_DOCLET_css_exception_table "main_parameter_table"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table_text "main_parameter_table_text"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table_name "main_parameter_table_name"
#define VALADOC_HTML_BASIC_DOCLET_css_parameter_table "main_parameter_table"
#define VALADOC_HTML_BASIC_DOCLET_css_title "main_title"
#define VALADOC_HTML_BASIC_DOCLET_css_other_type "main_other_type"
#define VALADOC_HTML_BASIC_DOCLET_css_basic_type "main_basic_type"
#define VALADOC_HTML_BASIC_DOCLET_css_keyword "main_keyword"
#define VALADOC_HTML_BASIC_DOCLET_css_optional_parameter "main_optional_parameter"
#define VALADOC_HTML_BASIC_DOCLET_css_code_definition "main_code_definition"
#define VALADOC_HTML_BASIC_DOCLET_css_headline_hr "main_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_hr "main_hr"
#define VALADOC_HTML_BASIC_DOCLET_css_list_errdom "main_list_errdom"
#define VALADOC_HTML_BASIC_DOCLET_css_list_en "main_list_en"
#define VALADOC_HTML_BASIC_DOCLET_css_list_ns "main_list_ns"
#define VALADOC_HTML_BASIC_DOCLET_css_list_cl "main_list_cl"
#define VALADOC_HTML_BASIC_DOCLET_css_list_iface "main_list_iface"
#define VALADOC_HTML_BASIC_DOCLET_css_list_stru "main_list_stru"
#define VALADOC_HTML_BASIC_DOCLET_css_list_field "main_list_field"
#define VALADOC_HTML_BASIC_DOCLET_css_list_prop "main_list_prop"
#define VALADOC_HTML_BASIC_DOCLET_css_list_del "main_list_del"
#define VALADOC_HTML_BASIC_DOCLET_css_list_sig "main_list_sig"
#define VALADOC_HTML_BASIC_DOCLET_css_list_m "main_list_m"
#define VALADOC_HTML_BASIC_DOCLET_css_style_navigation "site_navigation"
#define VALADOC_HTML_BASIC_DOCLET_css_style_content "site_content"
#define VALADOC_HTML_BASIC_DOCLET_css_style_body "site_body"
#define VALADOC_HTML_BASIC_DOCLET_css_deprecated "deprecated"
static void valadoc_html_basic_doclet_real_process (ValadocHtmlBasicDoclet* self,
                                             ValadocSettings* settings,
                                             ValadocApiTree* tree,
                                             ValadocErrorReporter* reporter);
static gchar* valadoc_html_basic_doclet_real_get_img_path_html (ValadocHtmlBasicDoclet* self,
                                                         ValadocApiNode* element,
                                                         const gchar* type);
static gchar* valadoc_html_basic_doclet_real_get_img_path (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* element,
                                                    const gchar* type);
static gchar* valadoc_html_basic_doclet_real_get_icon_directory (ValadocHtmlBasicDoclet* self);
static ValadocApiTypeSymbol* valadoc_html_basic_doclet_unpack_type_reference (ValadocHtmlBasicDoclet* self,
                                                                       ValadocApiTypeReference* type_reference);
static void valadoc_html_basic_doclet_real_write_wiki_page (ValadocHtmlBasicDoclet* self,
                                                     ValadocWikiPage* page,
                                                     const gchar* contentp,
                                                     const gchar* css_path,
                                                     const gchar* js_path,
                                                     const gchar* pkg_name);
static gboolean valadoc_html_basic_doclet_has_brief_description (ValadocHtmlBasicDoclet* self,
                                                          ValadocApiNode* element);
static void valadoc_html_basic_doclet_write_brief_description (ValadocHtmlBasicDoclet* self,
                                                        ValadocApiNode* element,
                                                        ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_documentation (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* element,
                                                    ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_attributes (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiSymbol* element,
                                                 ValadocApiNode* pos);
static void valadoc_html_basic_doclet_write_signature (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* element,
                                                ValadocApiNode* pos);
static inline ValaArrayList* valadoc_html_basic_doclet_get_accessible_nodes_from_list (ValadocHtmlBasicDoclet* self,
                                                                         ValaCollection* nodes);
static void valadoc_html_basic_doclet_write_known_symbols_note (ValadocHtmlBasicDoclet* self,
                                                         ValaCollection* nodes2,
                                                         ValadocApiNode* container,
                                                         const gchar* headline);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (ValadocHtmlBasicDoclet* self,
                                                                       ValadocApiClass* cl,
                                                                       ValadocApiNode* container);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (ValadocHtmlBasicDoclet* self,
                                                                           ValadocApiInterface* iface,
                                                                           ValadocApiNode* container);
static void valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (ValadocHtmlBasicDoclet* self,
                                                                        ValadocApiStruct* str,
                                                                        ValadocApiNode* container);
static inline gboolean valadoc_html_basic_doclet_has_visible_inheritable_children (ValadocHtmlBasicDoclet* self,
                                                                     ValadocApiTypeSymbol* symbol);
static void valadoc_html_basic_doclet_write_inherited_members_headline (ValadocHtmlBasicDoclet* self);
static void valadoc_html_basic_doclet_write_inherited_symbols_note (ValadocHtmlBasicDoclet* self,
                                                             ValadocApiTypeSymbol* symbol,
                                                             const gchar* type,
                                                             ValadocApiNode* container);
static void valadoc_html_basic_doclet_finalize (GObject * obj);
static void _vala_valadoc_html_basic_doclet_get_property (GObject * object,
                                                   guint property_id,
                                                   GValue * value,
                                                   GParamSpec * pspec);
static void _vala_valadoc_html_basic_doclet_set_property (GObject * object,
                                                   guint property_id,
                                                   const GValue * value,
                                                   GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


static gpointer
_valadoc_api_tree_ref0 (gpointer self)
{
	return self ? valadoc_api_tree_ref (self) : NULL;
}


static void
valadoc_html_basic_doclet_real_process (ValadocHtmlBasicDoclet* self,
                                        ValadocSettings* settings,
                                        ValadocApiTree* tree,
                                        ValadocErrorReporter* reporter)
{
	ValadocErrorReporter* _tmp0_;
	ValadocApiTree* _tmp1_;
	ValadocHtmlCssClassResolver* _tmp2_;
	ValadocHtmlLinkHelper* _tmp3_;
	ValadocHtmlLinkHelper* _tmp4_;
	ValadocHtmlLinkHelper* _tmp5_;
	ValadocHtmlCssClassResolver* _tmp6_;
	ValadocHtmlHtmlRenderer* _tmp7_;
	ValadocHtmlLinkHelper* _tmp8_;
	ValadocHtmlSimpleChartFactory* _tmp9_;
	g_return_if_fail (settings != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (reporter != NULL);
	_tmp0_ = _g_object_ref0 (reporter);
	_g_object_unref0 (self->reporter);
	self->reporter = _tmp0_;
	valadoc_html_basic_doclet_set_settings (self, settings);
	_tmp1_ = _valadoc_api_tree_ref0 (tree);
	_valadoc_api_tree_unref0 (self->tree);
	self->tree = _tmp1_;
	_tmp2_ = valadoc_html_css_class_resolver_new ();
	_g_object_unref0 (self->cssresolver);
	self->cssresolver = _tmp2_;
	_tmp3_ = valadoc_html_link_helper_new ();
	_tmp4_ = _tmp3_;
	valadoc_html_basic_doclet_set_linker (self, _tmp4_);
	_g_object_unref0 (_tmp4_);
	_tmp5_ = self->priv->_linker;
	_tmp6_ = self->cssresolver;
	_tmp7_ = valadoc_html_html_renderer_new (settings, _tmp5_, _tmp6_);
	_g_object_unref0 (self->_renderer);
	self->_renderer = _tmp7_;
	_tmp8_ = self->priv->_linker;
	_tmp9_ = valadoc_html_simple_chart_factory_new (settings, _tmp8_);
	_g_object_unref0 (self->image_factory);
	self->image_factory = (ValadocChartsFactory*) _tmp9_;
}


void
valadoc_html_basic_doclet_process (ValadocHtmlBasicDoclet* self,
                                   ValadocSettings* settings,
                                   ValadocApiTree* tree,
                                   ValadocErrorReporter* reporter)
{
	g_return_if_fail (self != NULL);
	VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->process (self, settings, tree, reporter);
}


gchar*
valadoc_html_basic_doclet_get_link (ValadocHtmlBasicDoclet* self,
                                    ValadocApiNode* to,
                                    ValadocApiNode* from)
{
	gchar* result = NULL;
	ValadocHtmlLinkHelper* _tmp0_;
	ValadocSettings* _tmp1_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	_tmp0_ = self->priv->_linker;
	_tmp1_ = self->priv->_settings;
	_tmp2_ = valadoc_html_link_helper_get_relative_link (_tmp0_, (ValadocDocumentation*) from, (ValadocDocumentation*) to, _tmp1_);
	result = _tmp2_;
	return result;
}


static gchar*
valadoc_html_basic_doclet_real_get_img_path_html (ValadocHtmlBasicDoclet* self,
                                                  ValadocApiNode* element,
                                                  const gchar* type)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = valadoc_api_node_get_full_name (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, ".", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, type, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename ("img", _tmp5_, NULL);
	_tmp7_ = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp7_;
	return result;
}


gchar*
valadoc_html_basic_doclet_get_img_path_html (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* element,
                                             const gchar* type)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->get_img_path_html (self, element, type);
}


static gchar*
valadoc_html_basic_doclet_real_get_img_path (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* element,
                                             const gchar* type)
{
	gchar* result = NULL;
	ValadocSettings* _tmp0_;
	const gchar* _tmp1_;
	ValadocApiPackage* _tmp2_;
	ValadocApiPackage* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	g_return_val_if_fail (element != NULL, NULL);
	g_return_val_if_fail (type != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = _tmp0_->path;
	_tmp2_ = valadoc_documentation_get_package ((ValadocDocumentation*) element);
	_tmp3_ = _tmp2_;
	_tmp4_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = valadoc_api_node_get_full_name (element);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat (_tmp7_, ".", NULL);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, type, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename (_tmp1_, _tmp5_, "img", _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	result = _tmp13_;
	return result;
}


gchar*
valadoc_html_basic_doclet_get_img_path (ValadocHtmlBasicDoclet* self,
                                        ValadocApiNode* element,
                                        const gchar* type)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->get_img_path (self, element, type);
}


static gchar*
valadoc_html_basic_doclet_real_get_icon_directory (ValadocHtmlBasicDoclet* self)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	_tmp0_ = g_strdup ("..");
	result = _tmp0_;
	return result;
}


gchar*
valadoc_html_basic_doclet_get_icon_directory (ValadocHtmlBasicDoclet* self)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->get_icon_directory (self);
}


static ValadocApiTypeSymbol*
valadoc_html_basic_doclet_unpack_type_reference (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiTypeReference* type_reference)
{
	ValadocApiTypeSymbol* result = NULL;
	ValadocApiItem* pos = NULL;
	ValadocApiItem* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = _g_object_ref0 ((ValadocApiItem*) type_reference);
	pos = _tmp0_;
	while (TRUE) {
		ValadocApiItem* _tmp1_;
		ValadocApiItem* _tmp2_;
		_tmp1_ = pos;
		if (!(_tmp1_ != NULL)) {
			break;
		}
		_tmp2_ = pos;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_TYPEREFERENCE)) {
			ValadocApiItem* _tmp3_;
			ValadocApiItem* _tmp4_;
			ValadocApiItem* _tmp5_;
			ValadocApiItem* _tmp6_;
			_tmp3_ = pos;
			_tmp4_ = valadoc_api_typereference_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, VALADOC_API_TYPE_TYPEREFERENCE, ValadocApiTypeReference));
			_tmp5_ = _tmp4_;
			_tmp6_ = _g_object_ref0 (_tmp5_);
			_g_object_unref0 (pos);
			pos = _tmp6_;
		} else {
			ValadocApiItem* _tmp7_;
			_tmp7_ = pos;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALADOC_API_TYPE_ARRAY)) {
				ValadocApiItem* _tmp8_;
				ValadocApiItem* _tmp9_;
				ValadocApiItem* _tmp10_;
				ValadocApiItem* _tmp11_;
				_tmp8_ = pos;
				_tmp9_ = valadoc_api_array_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_ARRAY, ValadocApiArray));
				_tmp10_ = _tmp9_;
				_tmp11_ = _g_object_ref0 (_tmp10_);
				_g_object_unref0 (pos);
				pos = _tmp11_;
			} else {
				ValadocApiItem* _tmp12_;
				_tmp12_ = pos;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALADOC_API_TYPE_POINTER)) {
					ValadocApiItem* _tmp13_;
					ValadocApiItem* _tmp14_;
					ValadocApiItem* _tmp15_;
					ValadocApiItem* _tmp16_;
					_tmp13_ = pos;
					_tmp14_ = valadoc_api_pointer_get_data_type (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_API_TYPE_POINTER, ValadocApiPointer));
					_tmp15_ = _tmp14_;
					_tmp16_ = _g_object_ref0 (_tmp15_);
					_g_object_unref0 (pos);
					pos = _tmp16_;
				} else {
					ValadocApiItem* _tmp17_;
					ValadocApiItem* _tmp18_;
					ValadocApiTypeSymbol* _tmp19_;
					_tmp17_ = pos;
					_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp17_, VALADOC_API_TYPE_TYPESYMBOL), "pos is TypeSymbol");
					_tmp18_ = pos;
					_tmp19_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALADOC_API_TYPE_TYPESYMBOL, ValadocApiTypeSymbol));
					result = _tmp19_;
					_g_object_unref0 (pos);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (pos);
	return result;
}


void
valadoc_html_basic_doclet_write_navi_entry_html_template (ValadocHtmlBasicDoclet* self,
                                                          const gchar* style,
                                                          const gchar* content,
                                                          gboolean is_deprecated)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocMarkupWriter* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (style);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "li", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (is_deprecated) {
		ValadocHtmlMarkupWriter* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		ValadocHtmlMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocMarkupWriter* _tmp16_;
		ValadocHtmlMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		_tmp7_ = self->writer;
		_tmp8_ = g_strdup ("class");
		_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
		_tmp10_ = g_new0 (gchar*, 2 + 1);
		_tmp10_[0] = _tmp8_;
		_tmp10_[1] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 2;
		_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "span", _tmp11_, 2);
		_tmp13_ = _tmp12_;
		_valadoc_markup_writer_unref0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_tmp14_ = self->writer;
		_tmp15_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp14_, content);
		_tmp16_ = _tmp15_;
		_valadoc_markup_writer_unref0 (_tmp16_);
		_tmp17_ = self->writer;
		_tmp18_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp17_, "span");
		_tmp19_ = _tmp18_;
		_valadoc_markup_writer_unref0 (_tmp19_);
	} else {
		ValadocHtmlMarkupWriter* _tmp20_;
		ValadocMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		_tmp20_ = self->writer;
		_tmp21_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp20_, content);
		_tmp22_ = _tmp21_;
		_valadoc_markup_writer_unref0 (_tmp22_);
	}
	_tmp23_ = self->writer;
	_tmp24_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp23_, "li");
	_tmp25_ = _tmp24_;
	_valadoc_markup_writer_unref0 (_tmp25_);
}


void
valadoc_html_basic_doclet_write_navi_entry_html_template_with_link (ValadocHtmlBasicDoclet* self,
                                                                    const gchar* style,
                                                                    const gchar* link,
                                                                    const gchar* content,
                                                                    gboolean is_deprecated)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocMarkupWriter* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (style != NULL);
	g_return_if_fail (link != NULL);
	g_return_if_fail (content != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (style);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "li", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	if (is_deprecated) {
		ValadocHtmlMarkupWriter* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar** _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		ValadocHtmlMarkupWriter* _tmp14_;
		ValadocHtmlMarkupWriter* _tmp15_;
		ValadocHtmlMarkupWriter* _tmp16_;
		ValadocHtmlMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		_tmp7_ = self->writer;
		_tmp8_ = g_strdup ("class");
		_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
		_tmp10_ = g_new0 (gchar*, 2 + 1);
		_tmp10_[0] = _tmp8_;
		_tmp10_[1] = _tmp9_;
		_tmp11_ = _tmp10_;
		_tmp11__length1 = 2;
		_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "span", _tmp11_, 2);
		_tmp13_ = _tmp12_;
		_valadoc_markup_writer_unref0 (_tmp13_);
		_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
		_tmp14_ = self->writer;
		_tmp15_ = valadoc_html_markup_writer_link (_tmp14_, link, content, NULL);
		_tmp16_ = _tmp15_;
		_valadoc_markup_writer_unref0 (_tmp16_);
		_tmp17_ = self->writer;
		_tmp18_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp17_, "span");
		_tmp19_ = _tmp18_;
		_valadoc_markup_writer_unref0 (_tmp19_);
	} else {
		ValadocHtmlMarkupWriter* _tmp20_;
		ValadocHtmlMarkupWriter* _tmp21_;
		ValadocHtmlMarkupWriter* _tmp22_;
		_tmp20_ = self->writer;
		_tmp21_ = valadoc_html_markup_writer_link (_tmp20_, link, content, NULL);
		_tmp22_ = _tmp21_;
		_valadoc_markup_writer_unref0 (_tmp22_);
	}
	_tmp23_ = self->writer;
	_tmp24_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp23_, "li");
	_tmp25_ = _tmp24_;
	_valadoc_markup_writer_unref0 (_tmp25_);
}


void
valadoc_html_basic_doclet_write_navi_entry (ValadocHtmlBasicDoclet* self,
                                            ValadocApiNode* element,
                                            ValadocApiNode* pos,
                                            const gchar* style,
                                            gboolean link,
                                            gboolean full_name)
{
	gchar* name = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp13_ = FALSE;
	gboolean is_deprecated = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	g_return_if_fail (style != NULL);
	if (full_name == TRUE) {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (element, VALADOC_API_TYPE_NAMESPACE);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gchar* tmp = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_ = NULL;
		const gchar* _tmp3_;
		gchar* _tmp5_;
		_tmp1_ = valadoc_api_node_get_full_name (element);
		tmp = _tmp1_;
		_tmp3_ = tmp;
		if (_tmp3_ == NULL) {
			_tmp2_ = "Global Namespace";
		} else {
			const gchar* _tmp4_;
			_tmp4_ = tmp;
			_tmp2_ = _tmp4_;
		}
		_tmp5_ = g_strdup (_tmp2_);
		_g_free0 (name);
		name = _tmp5_;
		_g_free0 (tmp);
	} else {
		gchar* tmp = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		gchar* _tmp12_;
		_tmp6_ = valadoc_api_node_get_name (element);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		tmp = _tmp8_;
		_tmp10_ = tmp;
		if (_tmp10_ == NULL) {
			_tmp9_ = "Global Namespace";
		} else {
			const gchar* _tmp11_;
			_tmp11_ = tmp;
			_tmp9_ = _tmp11_;
		}
		_tmp12_ = g_strdup (_tmp9_);
		_g_free0 (name);
		name = _tmp12_;
		_g_free0 (tmp);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (element, VALADOC_API_TYPE_SYMBOL)) {
		gboolean _tmp14_;
		gboolean _tmp15_;
		_tmp14_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		_tmp15_ = _tmp14_;
		_tmp13_ = _tmp15_;
	} else {
		_tmp13_ = FALSE;
	}
	is_deprecated = _tmp13_;
	if (link == TRUE) {
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gboolean _tmp19_;
		_tmp16_ = valadoc_html_basic_doclet_get_link (self, element, pos);
		_tmp17_ = _tmp16_;
		_tmp18_ = name;
		_tmp19_ = is_deprecated;
		valadoc_html_basic_doclet_write_navi_entry_html_template_with_link (self, style, _tmp17_, _tmp18_, _tmp19_);
		_g_free0 (_tmp17_);
	} else {
		const gchar* _tmp20_;
		gboolean _tmp21_;
		_tmp20_ = name;
		_tmp21_ = is_deprecated;
		valadoc_html_basic_doclet_write_navi_entry_html_template (self, style, _tmp20_, _tmp21_);
	}
	_g_free0 (name);
}


void
valadoc_html_basic_doclet_write_wiki_pages (ValadocHtmlBasicDoclet* self,
                                            ValadocApiTree* tree,
                                            const gchar* css_path_wiki,
                                            const gchar* js_path_wiki,
                                            const gchar* contentp)
{
	ValadocWikiPageTree* _tmp0_;
	ValadocWikiPageTree* _tmp1_;
	ValadocWikiPageTree* _tmp2_;
	ValadocWikiPageTree* _tmp3_;
	ValaCollection* pages = NULL;
	ValadocWikiPageTree* _tmp4_;
	ValadocWikiPageTree* _tmp5_;
	ValaCollection* _tmp6_;
	ValaCollection* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	g_return_if_fail (css_path_wiki != NULL);
	g_return_if_fail (js_path_wiki != NULL);
	g_return_if_fail (contentp != NULL);
	_tmp0_ = valadoc_api_tree_get_wikitree (tree);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = valadoc_api_tree_get_wikitree (tree);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		return;
	}
	_tmp4_ = valadoc_api_tree_get_wikitree (tree);
	_tmp5_ = _tmp4_;
	_tmp6_ = valadoc_wiki_page_tree_get_pages (_tmp5_);
	pages = _tmp6_;
	_tmp7_ = pages;
	_tmp8_ = vala_collection_get_size (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == 0) {
		_vala_iterable_unref0 (pages);
		return;
	}
	g_mkdir (contentp, 0777);
	_tmp10_ = g_build_filename (contentp, "img", NULL);
	_tmp11_ = _tmp10_;
	g_mkdir (_tmp11_, 0777);
	_g_free0 (_tmp11_);
	{
		ValaIterator* _page_it = NULL;
		ValaCollection* _tmp12_;
		ValaIterator* _tmp13_;
		_tmp12_ = pages;
		_tmp13_ = vala_iterable_iterator ((ValaIterable*) _tmp12_);
		_page_it = _tmp13_;
		while (TRUE) {
			ValaIterator* _tmp14_;
			ValadocWikiPage* page = NULL;
			ValaIterator* _tmp15_;
			gpointer _tmp16_;
			ValadocWikiPage* _tmp17_;
			const gchar* _tmp18_;
			const gchar* _tmp19_;
			const gchar* _tmp20_;
			_tmp14_ = _page_it;
			if (!vala_iterator_next (_tmp14_)) {
				break;
			}
			_tmp15_ = _page_it;
			_tmp16_ = vala_iterator_get (_tmp15_);
			page = (ValadocWikiPage*) _tmp16_;
			_tmp17_ = page;
			_tmp18_ = valadoc_wiki_page_get_name (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = self->priv->_wiki_index_name;
			if (g_strcmp0 (_tmp19_, _tmp20_) != 0) {
				ValadocWikiPage* _tmp21_;
				ValadocSettings* _tmp22_;
				const gchar* _tmp23_;
				_tmp21_ = page;
				_tmp22_ = self->priv->_settings;
				_tmp23_ = _tmp22_->pkg_name;
				valadoc_html_basic_doclet_write_wiki_page (self, _tmp21_, contentp, css_path_wiki, js_path_wiki, _tmp23_);
			}
			_g_object_unref0 (page);
		}
		_vala_iterator_unref0 (_page_it);
	}
	_vala_iterable_unref0 (pages);
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch21_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch21_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally21;
	__catch21_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
valadoc_html_basic_doclet_real_write_wiki_page (ValadocHtmlBasicDoclet* self,
                                                ValadocWikiPage* page,
                                                const gchar* contentp,
                                                const gchar* css_path,
                                                const gchar* js_path,
                                                const gchar* pkg_name)
{
	FILE* file = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	FILE* _tmp14_;
	FILE* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlHtmlRenderer* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	ValadocHtmlHtmlRenderer* _tmp19_;
	ValadocHtmlHtmlRenderer* _tmp20_;
	ValadocContentPage* _tmp21_;
	ValadocContentPage* _tmp22_;
	g_return_if_fail (page != NULL);
	g_return_if_fail (contentp != NULL);
	g_return_if_fail (css_path != NULL);
	g_return_if_fail (js_path != NULL);
	g_return_if_fail (pkg_name != NULL);
	_tmp0_ = valadoc_wiki_page_get_name (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_wiki_page_get_name (page);
	_tmp3_ = _tmp2_;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = string_substring (_tmp1_, (glong) 0, (glong) (_tmp5_ - 7));
	_tmp7_ = _tmp6_;
	_tmp8_ = string_replace (_tmp7_, "/", ".");
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp9_, "htm", NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_build_filename (contentp, _tmp11_, NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_fopen (_tmp13_, "w");
	_tmp15_ = _tmp14_;
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	file = _tmp15_;
	_tmp16_ = valadoc_html_markup_writer_new (file, TRUE);
	_valadoc_markup_writer_unref0 (self->writer);
	self->writer = _tmp16_;
	_tmp17_ = self->_renderer;
	_tmp18_ = self->writer;
	valadoc_html_html_renderer_set_writer (_tmp17_, _tmp18_);
	valadoc_html_basic_doclet_write_file_header (self, css_path, js_path, pkg_name);
	_tmp19_ = self->_renderer;
	valadoc_html_html_renderer_set_container (_tmp19_, (ValadocDocumentation*) page);
	_tmp20_ = self->_renderer;
	_tmp21_ = valadoc_wiki_page_get_documentation (page);
	_tmp22_ = _tmp21_;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp20_, (ValadocContentContentElement*) _tmp22_);
	valadoc_html_basic_doclet_write_file_footer (self);
	_fclose0 (file);
}


void
valadoc_html_basic_doclet_write_wiki_page (ValadocHtmlBasicDoclet* self,
                                           ValadocWikiPage* page,
                                           const gchar* contentp,
                                           const gchar* css_path,
                                           const gchar* js_path,
                                           const gchar* pkg_name)
{
	g_return_if_fail (self != NULL);
	VALADOC_HTML_BASIC_DOCLET_GET_CLASS (self)->write_wiki_page (self, page, contentp, css_path, js_path, pkg_name);
}


void
valadoc_html_basic_doclet_write_navi_top_entry (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* element,
                                                ValadocApiNode* parent)
{
	gchar* style = NULL;
	ValadocHtmlCssClassResolver* _tmp0_;
	gchar* _tmp1_;
	ValadocHtmlMarkupWriter* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	ValadocMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	gboolean _tmp9_ = FALSE;
	ValadocHtmlMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->cssresolver;
	_tmp1_ = valadoc_html_css_class_resolver_resolve (_tmp0_, element);
	style = _tmp1_;
	_tmp2_ = self->writer;
	_tmp3_ = g_strdup ("class");
	_tmp4_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp7_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp2_, "ul", _tmp6_, 2);
	_tmp8_ = _tmp7_;
	_valadoc_markup_writer_unref0 (_tmp8_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	if (element == parent) {
		_tmp9_ = TRUE;
	} else {
		_tmp9_ = parent == NULL;
	}
	if (_tmp9_) {
		const gchar* _tmp10_;
		_tmp10_ = style;
		valadoc_html_basic_doclet_write_navi_entry (self, element, parent, _tmp10_, FALSE, FALSE);
	} else {
		const gchar* _tmp11_;
		_tmp11_ = style;
		valadoc_html_basic_doclet_write_navi_entry (self, element, parent, _tmp11_, TRUE, FALSE);
	}
	_tmp12_ = self->writer;
	_tmp13_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp12_, "ul");
	_tmp14_ = _tmp13_;
	_valadoc_markup_writer_unref0 (_tmp14_);
	_tmp15_ = self->writer;
	_tmp16_ = g_strdup ("class");
	_tmp17_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi_hr);
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp16_;
	_tmp18_[1] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 2;
	_tmp20_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp15_, "hr", _tmp19_, 2);
	_tmp21_ = _tmp20_;
	_valadoc_markup_writer_unref0 (_tmp21_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (style);
}


void
valadoc_html_basic_doclet_write_top_element_template (ValadocHtmlBasicDoclet* self,
                                                      const gchar* link)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocHtmlMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocHtmlMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (link != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_package_index);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "li", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = self->writer;
	_tmp15_ = valadoc_html_markup_writer_link (_tmp14_, link, "Packages", NULL);
	_tmp16_ = _tmp15_;
	_valadoc_markup_writer_unref0 (_tmp16_);
	_tmp17_ = self->writer;
	_tmp18_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp17_, "li");
	_tmp19_ = _tmp18_;
	_valadoc_markup_writer_unref0 (_tmp19_);
	_tmp20_ = self->writer;
	_tmp21_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp20_, "ul");
	_tmp22_ = _tmp21_;
	_valadoc_markup_writer_unref0 (_tmp22_);
	_tmp23_ = self->writer;
	_tmp24_ = g_strdup ("class");
	_tmp25_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi_hr);
	_tmp26_ = g_new0 (gchar*, 2 + 1);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	_tmp28_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp23_, "hr", _tmp27_, 2);
	_tmp29_ = _tmp28_;
	_valadoc_markup_writer_unref0 (_tmp29_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
}


void
valadoc_html_basic_doclet_write_top_elements (ValadocHtmlBasicDoclet* self,
                                              ValadocApiNode* element,
                                              ValadocApiNode* parent)
{
	ValaArrayList* lst = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValadocApiNode* pos = NULL;
	ValadocApiNode* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	lst = _tmp1_;
	_tmp2_ = _g_object_ref0 (element);
	pos = _tmp2_;
	_tmp3_ = self->package_list_link;
	valadoc_html_basic_doclet_write_top_element_template (self, _tmp3_);
	while (TRUE) {
		ValadocApiNode* _tmp4_;
		ValaArrayList* _tmp5_;
		ValadocApiNode* _tmp6_;
		ValadocApiNode* _tmp7_;
		ValadocApiItem* _tmp8_;
		ValadocApiItem* _tmp9_;
		ValadocApiNode* _tmp10_;
		_tmp4_ = pos;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp5_ = lst;
		_tmp6_ = pos;
		vala_collection_add ((ValaCollection*) _tmp5_, _tmp6_);
		_tmp7_ = pos;
		_tmp8_ = valadoc_api_item_get_parent ((ValadocApiItem*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALADOC_API_TYPE_NODE, ValadocApiNode));
		_g_object_unref0 (pos);
		pos = _tmp10_;
	}
	{
		gint i = 0;
		ValaArrayList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = lst;
		_tmp12_ = vala_collection_get_size ((ValaCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		i = _tmp13_ - 1;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint _tmp16_;
				ValadocApiNode* el = NULL;
				ValaArrayList* _tmp17_;
				gint _tmp18_;
				gpointer _tmp19_;
				ValadocApiNode* _tmp20_;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ - 1;
				}
				_tmp14_ = FALSE;
				_tmp16_ = i;
				if (!(_tmp16_ >= 0)) {
					break;
				}
				_tmp17_ = lst;
				_tmp18_ = i;
				_tmp19_ = vala_list_get ((ValaList*) _tmp17_, _tmp18_);
				el = (ValadocApiNode*) _tmp19_;
				_tmp20_ = el;
				_tmp21_ = valadoc_api_node_get_name (_tmp20_);
				_tmp22_ = _tmp21_;
				if (_tmp22_ != NULL) {
					ValadocApiNode* _tmp23_;
					_tmp23_ = el;
					valadoc_html_basic_doclet_write_navi_top_entry (self, _tmp23_, parent);
				}
				_g_object_unref0 (el);
			}
		}
	}
	_g_object_unref0 (pos);
	_vala_iterable_unref0 (lst);
}


static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


void
valadoc_html_basic_doclet_fetch_subnamespace_names (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* node,
                                                    ValaArrayList* namespaces)
{
	ValaList* children = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (namespaces != NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, VALADOC_API_NODE_TYPE_NAMESPACE, TRUE);
	children = _tmp0_;
	_tmp1_ = children;
	vala_list_sort (_tmp1_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _child_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _child_index = 0;
		_tmp2_ = children;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_child_list = _tmp3_;
		_tmp4_ = _child_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_child_size = _tmp6_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValadocApiNode* _tmp13_;
			ValadocApiNode* _tmp14_;
			_tmp7_ = _child_index;
			_child_index = _tmp7_ + 1;
			_tmp8_ = _child_index;
			_tmp9_ = _child_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _child_list;
			_tmp11_ = _child_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			child = (ValadocApiNode*) _tmp12_;
			_tmp13_ = child;
			vala_collection_add ((ValaCollection*) namespaces, G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, VALADOC_API_TYPE_NAMESPACE, ValadocApiNamespace));
			_tmp14_ = child;
			valadoc_html_basic_doclet_fetch_subnamespace_names (self, _tmp14_, namespaces);
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_vala_iterable_unref0 (children);
}


void
valadoc_html_basic_doclet_write_navi_package (ValadocHtmlBasicDoclet* self,
                                              ValadocApiPackage* package)
{
	ValaArrayList* ns_list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocHtmlMarkupWriter* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocApiNamespace* globals = NULL;
	ValadocApiNamespace* _tmp38_;
	ValadocHtmlMarkupWriter* _tmp53_;
	ValadocMarkupWriter* _tmp54_;
	ValadocMarkupWriter* _tmp55_;
	ValadocHtmlMarkupWriter* _tmp56_;
	ValadocMarkupWriter* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	ns_list = _tmp1_;
	_tmp2_ = ns_list;
	valadoc_html_basic_doclet_fetch_subnamespace_names (self, (ValadocApiNode*) package, _tmp2_);
	_tmp3_ = self->writer;
	_tmp4_ = g_strdup ("class");
	_tmp5_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp6_ = g_new0 (gchar*, 2 + 1);
	_tmp6_[0] = _tmp4_;
	_tmp6_[1] = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp7__length1 = 2;
	_tmp8_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "div", _tmp7_, 2);
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
	_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_top_elements (self, (ValadocApiNode*) package, (ValadocApiNode*) package);
	_tmp10_ = self->writer;
	_tmp11_ = g_strdup ("class");
	_tmp12_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp13_ = g_new0 (gchar*, 2 + 1);
	_tmp13_[0] = _tmp11_;
	_tmp13_[1] = _tmp12_;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	_tmp15_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp10_, "ul", _tmp14_, 2);
	_tmp16_ = _tmp15_;
	_valadoc_markup_writer_unref0 (_tmp16_);
	_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	globals = NULL;
	{
		ValaArrayList* _ns_list = NULL;
		ValaArrayList* _tmp17_;
		ValaArrayList* _tmp18_;
		gint _ns_size = 0;
		ValaArrayList* _tmp19_;
		gint _tmp20_;
		gint _tmp21_;
		gint _ns_index = 0;
		_tmp17_ = ns_list;
		_tmp18_ = _vala_iterable_ref0 (_tmp17_);
		_ns_list = _tmp18_;
		_tmp19_ = _ns_list;
		_tmp20_ = vala_collection_get_size ((ValaCollection*) _tmp19_);
		_tmp21_ = _tmp20_;
		_ns_size = _tmp21_;
		_ns_index = -1;
		while (TRUE) {
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_;
			ValadocApiNamespace* ns = NULL;
			ValaArrayList* _tmp25_;
			gint _tmp26_;
			gpointer _tmp27_;
			ValadocApiNamespace* _tmp28_;
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			_tmp22_ = _ns_index;
			_ns_index = _tmp22_ + 1;
			_tmp23_ = _ns_index;
			_tmp24_ = _ns_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _ns_list;
			_tmp26_ = _ns_index;
			_tmp27_ = vala_list_get ((ValaList*) _tmp25_, _tmp26_);
			ns = (ValadocApiNamespace*) _tmp27_;
			_tmp28_ = ns;
			_tmp29_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp28_);
			_tmp30_ = _tmp29_;
			if (_tmp30_ == NULL) {
				ValadocApiNamespace* _tmp31_;
				ValadocApiNamespace* _tmp32_;
				_tmp31_ = ns;
				_tmp32_ = _g_object_ref0 (_tmp31_);
				_g_object_unref0 (globals);
				globals = _tmp32_;
			} else {
				ValadocApiNamespace* _tmp33_;
				ValadocHtmlCssClassResolver* _tmp34_;
				ValadocApiNamespace* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				_tmp33_ = ns;
				_tmp34_ = self->cssresolver;
				_tmp35_ = ns;
				_tmp36_ = valadoc_html_css_class_resolver_resolve (_tmp34_, (ValadocApiNode*) _tmp35_);
				_tmp37_ = _tmp36_;
				valadoc_html_basic_doclet_write_navi_entry (self, (ValadocApiNode*) _tmp33_, (ValadocApiNode*) package, _tmp37_, TRUE, TRUE);
				_g_free0 (_tmp37_);
			}
			_g_object_unref0 (ns);
		}
		_vala_iterable_unref0 (_ns_list);
	}
	_tmp38_ = globals;
	if (_tmp38_ != NULL) {
		ValadocApiNamespace* _tmp39_;
		ValadocApiNamespace* _tmp40_;
		ValadocApiNamespace* _tmp41_;
		ValadocApiNamespace* _tmp42_;
		ValadocApiNamespace* _tmp43_;
		ValadocApiNamespace* _tmp44_;
		ValadocApiNamespace* _tmp45_;
		ValadocApiNamespace* _tmp46_;
		ValadocApiNamespace* _tmp47_;
		ValadocApiNamespace* _tmp48_;
		ValadocApiNamespace* _tmp49_;
		ValadocApiNamespace* _tmp50_;
		ValadocApiNamespace* _tmp51_;
		ValadocApiNamespace* _tmp52_;
		_tmp39_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp39_, VALADOC_API_NODE_TYPE_ERROR_CODE, (ValadocApiNode*) package);
		_tmp40_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp40_, VALADOC_API_NODE_TYPE_ENUM_VALUE, (ValadocApiNode*) package);
		_tmp41_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp41_, VALADOC_API_NODE_TYPE_ENUM, (ValadocApiNode*) package);
		_tmp42_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp42_, VALADOC_API_NODE_TYPE_INTERFACE, (ValadocApiNode*) package);
		_tmp43_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp43_, VALADOC_API_NODE_TYPE_CLASS, (ValadocApiNode*) package);
		_tmp44_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp44_, VALADOC_API_NODE_TYPE_STRUCT, (ValadocApiNode*) package);
		_tmp45_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp45_, VALADOC_API_NODE_TYPE_CONSTANT, (ValadocApiNode*) package);
		_tmp46_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp46_, VALADOC_API_NODE_TYPE_PROPERTY, (ValadocApiNode*) package);
		_tmp47_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp47_, VALADOC_API_NODE_TYPE_DELEGATE, (ValadocApiNode*) package);
		_tmp48_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp48_, VALADOC_API_NODE_TYPE_STATIC_METHOD, (ValadocApiNode*) package);
		_tmp49_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp49_, VALADOC_API_NODE_TYPE_CREATION_METHOD, (ValadocApiNode*) package);
		_tmp50_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp50_, VALADOC_API_NODE_TYPE_METHOD, (ValadocApiNode*) package);
		_tmp51_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp51_, VALADOC_API_NODE_TYPE_SIGNAL, (ValadocApiNode*) package);
		_tmp52_ = globals;
		valadoc_html_basic_doclet_write_navi_children (self, (ValadocApiNode*) _tmp52_, VALADOC_API_NODE_TYPE_FIELD, (ValadocApiNode*) package);
	}
	_tmp53_ = self->writer;
	_tmp54_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp53_, "ul");
	_tmp55_ = _tmp54_;
	_valadoc_markup_writer_unref0 (_tmp55_);
	_tmp56_ = self->writer;
	_tmp57_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp56_, "div");
	_tmp58_ = _tmp57_;
	_valadoc_markup_writer_unref0 (_tmp58_);
	_g_object_unref0 (globals);
	_vala_iterable_unref0 (ns_list);
}


void
valadoc_html_basic_doclet_write_navi_symbol (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* node)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_top_elements (self, node, node);
	valadoc_html_basic_doclet_write_navi_symbol_inline (self, node, node);
	_tmp7_ = self->writer;
	_tmp8_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp7_, "div");
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
}


void
valadoc_html_basic_doclet_write_navi_leaf_symbol (ValadocHtmlBasicDoclet* self,
                                                  ValadocApiNode* node)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocApiItem* _tmp7_;
	ValadocApiItem* _tmp8_;
	ValadocApiItem* _tmp9_;
	ValadocApiItem* _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
	_tmp8_ = _tmp7_;
	valadoc_html_basic_doclet_write_top_elements (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALADOC_API_TYPE_NODE, ValadocApiNode), node);
	_tmp9_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
	_tmp10_ = _tmp9_;
	valadoc_html_basic_doclet_write_navi_symbol_inline (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, VALADOC_API_TYPE_NODE, ValadocApiNode), node);
	_tmp11_ = self->writer;
	_tmp12_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp11_, "div");
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
}


void
valadoc_html_basic_doclet_write_navi_symbol_inline (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiNode* node,
                                                    ValadocApiNode* parent)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_NAMESPACE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_ERROR_CODE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_ENUM_VALUE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_ENUM, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_INTERFACE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_CLASS, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_STRUCT, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_CONSTANT, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_PROPERTY, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_DELEGATE, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_STATIC_METHOD, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_CREATION_METHOD, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_METHOD, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_SIGNAL, parent);
	valadoc_html_basic_doclet_write_navi_children (self, node, VALADOC_API_NODE_TYPE_FIELD, parent);
	_tmp7_ = self->writer;
	_tmp8_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp7_, "ul");
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
}


void
valadoc_html_basic_doclet_write_navi_children (ValadocHtmlBasicDoclet* self,
                                               ValadocApiNode* node,
                                               ValadocApiNodeType type,
                                               ValadocApiNode* parent)
{
	ValaList* children = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, type, TRUE);
	children = _tmp0_;
	_tmp1_ = children;
	vala_list_sort (_tmp1_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp2_;
		ValaList* _tmp3_;
		gint _child_size = 0;
		ValaList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		gint _child_index = 0;
		_tmp2_ = children;
		_tmp3_ = _vala_iterable_ref0 (_tmp2_);
		_child_list = _tmp3_;
		_tmp4_ = _child_list;
		_tmp5_ = vala_collection_get_size ((ValaCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_child_size = _tmp6_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp10_;
			gint _tmp11_;
			gpointer _tmp12_;
			ValadocApiNode* _tmp13_;
			ValadocHtmlCssClassResolver* _tmp14_;
			ValadocApiNode* _tmp15_;
			gchar* _tmp16_;
			gchar* _tmp17_;
			ValadocApiNode* _tmp18_;
			_tmp7_ = _child_index;
			_child_index = _tmp7_ + 1;
			_tmp8_ = _child_index;
			_tmp9_ = _child_size;
			if (!(_tmp8_ < _tmp9_)) {
				break;
			}
			_tmp10_ = _child_list;
			_tmp11_ = _child_index;
			_tmp12_ = vala_list_get (_tmp10_, _tmp11_);
			child = (ValadocApiNode*) _tmp12_;
			_tmp13_ = child;
			_tmp14_ = self->cssresolver;
			_tmp15_ = child;
			_tmp16_ = valadoc_html_css_class_resolver_resolve (_tmp14_, _tmp15_);
			_tmp17_ = _tmp16_;
			_tmp18_ = child;
			valadoc_html_basic_doclet_write_navi_entry (self, _tmp13_, parent, _tmp17_, _tmp18_ != parent, FALSE);
			_g_free0 (_tmp17_);
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_vala_iterable_unref0 (children);
}


void
valadoc_html_basic_doclet_write_package_note (ValadocHtmlBasicDoclet* self,
                                              ValadocApiNode* element)
{
	gchar* package = NULL;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	ValadocHtmlMarkupWriter* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocHtmlMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	gchar* _tmp23_;
	ValadocApiPackage* _tmp24_;
	ValadocApiPackage* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	const gchar* _tmp31_;
	ValadocMarkupWriter* _tmp32_;
	ValadocMarkupWriter* _tmp33_;
	ValadocMarkupWriter* _tmp34_;
	ValadocMarkupWriter* _tmp35_;
	ValadocHtmlMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_documentation_get_package ((ValadocDocumentation*) element);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	package = _tmp4_;
	_tmp5_ = package;
	if (_tmp5_ == NULL) {
		_g_free0 (package);
		return;
	}
	_tmp6_ = self->writer;
	_tmp7_ = g_strdup ("class");
	_tmp8_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_package_note);
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "div", _tmp10_, 2);
	_tmp12_ = _tmp11_;
	_valadoc_markup_writer_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = self->writer;
	_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp13_, "b", NULL, 0);
	_tmp15_ = _tmp14_;
	_tmp16_ = valadoc_markup_writer_text (_tmp15_, "Package:");
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_markup_writer_end_tag (_tmp17_, "b");
	_tmp19_ = _tmp18_;
	_valadoc_markup_writer_unref0 (_tmp19_);
	_valadoc_markup_writer_unref0 (_tmp17_);
	_valadoc_markup_writer_unref0 (_tmp15_);
	_tmp20_ = self->writer;
	_tmp21_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp20_, " ");
	_tmp22_ = _tmp21_;
	_tmp23_ = g_strdup ("href");
	_tmp24_ = valadoc_documentation_get_package ((ValadocDocumentation*) element);
	_tmp25_ = _tmp24_;
	_tmp26_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp25_, element);
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp23_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = valadoc_markup_writer_start_tag (_tmp22_, "a", _tmp28_, 2);
	_tmp30_ = _tmp29_;
	_tmp31_ = package;
	_tmp32_ = valadoc_markup_writer_text (_tmp30_, _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = valadoc_markup_writer_end_tag (_tmp33_, "a");
	_tmp35_ = _tmp34_;
	_valadoc_markup_writer_unref0 (_tmp35_);
	_valadoc_markup_writer_unref0 (_tmp33_);
	_valadoc_markup_writer_unref0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_valadoc_markup_writer_unref0 (_tmp22_);
	_tmp36_ = self->writer;
	_tmp37_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp36_, "div");
	_tmp38_ = _tmp37_;
	_valadoc_markup_writer_unref0 (_tmp38_);
	_g_free0 (package);
}


void
valadoc_html_basic_doclet_write_namespace_note (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* element)
{
	ValadocApiNamespace* ns = NULL;
	ValadocApiNamespace* _tmp0_;
	ValadocApiNamespace* _tmp1_;
	ValadocApiNamespace* _tmp2_;
	ValadocApiNamespace* _tmp3_;
	ValadocApiNamespace* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocHtmlMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocHtmlMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	ValadocApiNamespace* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	ValadocApiNamespace* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	ValadocMarkupWriter* _tmp34_;
	ValadocMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocHtmlMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_api_node_get_nspace (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	ns = _tmp2_;
	_tmp3_ = ns;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (ns);
		return;
	}
	_tmp4_ = ns;
	_tmp5_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (ns);
		return;
	}
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_namespace_note);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "div", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = self->writer;
	_tmp15_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp14_, "b", NULL, 0);
	_tmp16_ = _tmp15_;
	_tmp17_ = valadoc_markup_writer_text (_tmp16_, "Namespace:");
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_markup_writer_end_tag (_tmp18_, "b");
	_tmp20_ = _tmp19_;
	_valadoc_markup_writer_unref0 (_tmp20_);
	_valadoc_markup_writer_unref0 (_tmp18_);
	_valadoc_markup_writer_unref0 (_tmp16_);
	_tmp21_ = self->writer;
	_tmp22_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp21_, " ");
	_tmp23_ = _tmp22_;
	_tmp24_ = g_strdup ("href");
	_tmp25_ = ns;
	_tmp26_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp25_, element);
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp24_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = valadoc_markup_writer_start_tag (_tmp23_, "a", _tmp28_, 2);
	_tmp30_ = _tmp29_;
	_tmp31_ = ns;
	_tmp32_ = valadoc_api_node_get_full_name ((ValadocApiNode*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = valadoc_markup_writer_text (_tmp30_, _tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = valadoc_markup_writer_end_tag (_tmp35_, "a");
	_tmp37_ = _tmp36_;
	_valadoc_markup_writer_unref0 (_tmp37_);
	_valadoc_markup_writer_unref0 (_tmp35_);
	_g_free0 (_tmp33_);
	_valadoc_markup_writer_unref0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_valadoc_markup_writer_unref0 (_tmp23_);
	_tmp38_ = self->writer;
	_tmp39_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp38_, "div");
	_tmp40_ = _tmp39_;
	_valadoc_markup_writer_unref0 (_tmp40_);
	_g_object_unref0 (ns);
}


static gboolean
valadoc_html_basic_doclet_has_brief_description (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiNode* element)
{
	gboolean result = FALSE;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (element != NULL, FALSE);
	_tmp0_ = valadoc_api_node_get_documentation (element);
	_tmp1_ = _tmp0_;
	result = _tmp1_ != NULL;
	return result;
}


static void
valadoc_html_basic_doclet_write_brief_description (ValadocHtmlBasicDoclet* self,
                                                   ValadocApiNode* element,
                                                   ValadocApiNode* pos)
{
	ValadocContentComment* doctree = NULL;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	ValadocContentComment* _tmp3_;
	ValaList* description = NULL;
	ValadocContentComment* _tmp4_;
	ValaList* _tmp5_;
	ValaList* _tmp6_;
	ValaList* _tmp7_;
	ValaList* _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_api_node_get_documentation (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doctree = _tmp2_;
	_tmp3_ = doctree;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (doctree);
		return;
	}
	_tmp4_ = doctree;
	_tmp5_ = valadoc_content_block_content_get_content ((ValadocContentBlockContent*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _vala_iterable_ref0 (_tmp6_);
	description = _tmp7_;
	_tmp8_ = description;
	_tmp9_ = vala_collection_get_size ((ValaCollection*) _tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ > 0) {
		ValadocHtmlMarkupWriter* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gchar** _tmp15_;
		gint _tmp15__length1;
		ValadocMarkupWriter* _tmp16_;
		ValadocMarkupWriter* _tmp17_;
		ValadocHtmlHtmlRenderer* _tmp18_;
		ValadocHtmlHtmlRenderer* _tmp19_;
		ValadocHtmlHtmlRenderer* _tmp20_;
		ValaList* _tmp21_;
		gpointer _tmp22_;
		ValadocContentBlock* _tmp23_;
		ValadocHtmlHtmlRenderer* _tmp24_;
		ValadocHtmlMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		ValadocMarkupWriter* _tmp27_;
		_tmp11_ = self->writer;
		_tmp12_ = g_strdup ("class");
		_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_brief_description);
		_tmp14_ = g_new0 (gchar*, 2 + 1);
		_tmp14_[0] = _tmp12_;
		_tmp14_[1] = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp15__length1 = 2;
		_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "span", _tmp15_, 2);
		_tmp17_ = _tmp16_;
		_valadoc_markup_writer_unref0 (_tmp17_);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = self->_renderer;
		valadoc_html_html_renderer_set_container (_tmp18_, (ValadocDocumentation*) pos);
		_tmp19_ = self->_renderer;
		valadoc_html_html_renderer_set_owner (_tmp19_, (ValadocDocumentation*) element);
		_tmp20_ = self->_renderer;
		_tmp21_ = description;
		_tmp22_ = vala_list_get (_tmp21_, 0);
		_tmp23_ = (ValadocContentBlock*) _tmp22_;
		valadoc_content_content_renderer_render_children ((ValadocContentContentRenderer*) _tmp20_, (ValadocContentContentElement*) _tmp23_);
		_g_object_unref0 (_tmp23_);
		_tmp24_ = self->_renderer;
		valadoc_html_html_renderer_set_owner (_tmp24_, NULL);
		_tmp25_ = self->writer;
		_tmp26_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp25_, "span");
		_tmp27_ = _tmp26_;
		_valadoc_markup_writer_unref0 (_tmp27_);
	}
	_vala_iterable_unref0 (description);
	_g_object_unref0 (doctree);
}


static void
valadoc_html_basic_doclet_write_documentation (ValadocHtmlBasicDoclet* self,
                                               ValadocApiNode* element,
                                               ValadocApiNode* pos)
{
	ValadocContentComment* doctree = NULL;
	ValadocContentComment* _tmp0_;
	ValadocContentComment* _tmp1_;
	ValadocContentComment* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gboolean is_deprecated = FALSE;
	gboolean _tmp6_ = FALSE;
	ValadocContentComment* _tmp7_;
	ValadocHtmlMarkupWriter* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocHtmlHtmlRenderer* _tmp16_;
	gboolean _tmp17_;
	ValadocContentComment* _tmp114_;
	ValadocHtmlHtmlRenderer* _tmp118_;
	ValadocHtmlMarkupWriter* _tmp119_;
	ValadocMarkupWriter* _tmp120_;
	ValadocMarkupWriter* _tmp121_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = valadoc_api_node_get_documentation (element);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doctree = _tmp2_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (element, VALADOC_API_TYPE_SYMBOL)) {
		gboolean _tmp4_;
		gboolean _tmp5_;
		_tmp4_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		_tmp5_ = _tmp4_;
		_tmp3_ = _tmp5_;
	} else {
		_tmp3_ = FALSE;
	}
	is_deprecated = _tmp3_;
	_tmp7_ = doctree;
	if (_tmp7_ == NULL) {
		gboolean _tmp8_;
		_tmp8_ = is_deprecated;
		_tmp6_ = !_tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		_g_object_unref0 (doctree);
		return;
	}
	_tmp9_ = self->writer;
	_tmp10_ = g_strdup ("class");
	_tmp11_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_description);
	_tmp12_ = g_new0 (gchar*, 2 + 1);
	_tmp12_[0] = _tmp10_;
	_tmp12_[1] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 2;
	_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp9_, "div", _tmp13_, 2);
	_tmp15_ = _tmp14_;
	_valadoc_markup_writer_unref0 (_tmp15_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_tmp16_ = self->_renderer;
	valadoc_html_html_renderer_set_owner (_tmp16_, (ValadocDocumentation*) element);
	_tmp17_ = is_deprecated;
	if (_tmp17_) {
		ValadocApiSymbol* symbol = NULL;
		ValadocApiSymbol* _tmp18_;
		ValadocApiAttribute* version = NULL;
		ValadocApiAttribute* deprecated = NULL;
		ValadocApiAttributeArgument* replacement = NULL;
		ValadocApiAttributeArgument* since = NULL;
		ValadocApiSymbol* _tmp19_;
		ValadocApiAttribute* _tmp20_;
		ValadocApiAttribute* _tmp21_;
		ValadocHtmlMarkupWriter* _tmp33_;
		ValadocMarkupWriter* _tmp34_;
		ValadocMarkupWriter* _tmp35_;
		ValadocHtmlMarkupWriter* _tmp36_;
		ValadocMarkupWriter* _tmp37_;
		ValadocMarkupWriter* _tmp38_;
		ValadocHtmlMarkupWriter* _tmp39_;
		ValadocMarkupWriter* _tmp40_;
		ValadocMarkupWriter* _tmp41_;
		ValadocHtmlMarkupWriter* _tmp42_;
		ValadocMarkupWriter* _tmp43_;
		ValadocMarkupWriter* _tmp44_;
		ValadocHtmlMarkupWriter* _tmp45_;
		const gchar* _tmp46_;
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		ValadocMarkupWriter* _tmp50_;
		ValadocMarkupWriter* _tmp51_;
		ValadocApiAttributeArgument* _tmp52_;
		ValadocHtmlMarkupWriter* _tmp61_;
		ValadocMarkupWriter* _tmp62_;
		ValadocMarkupWriter* _tmp63_;
		ValadocApiAttributeArgument* _tmp64_;
		ValadocHtmlMarkupWriter* _tmp111_;
		ValadocMarkupWriter* _tmp112_;
		ValadocMarkupWriter* _tmp113_;
		_tmp18_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (element, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
		symbol = _tmp18_;
		_tmp19_ = symbol;
		_tmp20_ = valadoc_api_symbol_get_attribute (_tmp19_, "Version");
		_g_object_unref0 (version);
		version = _tmp20_;
		_tmp21_ = version;
		if (_tmp21_ != NULL) {
			ValadocApiAttribute* _tmp22_;
			ValadocApiAttributeArgument* _tmp23_;
			ValadocApiAttribute* _tmp24_;
			ValadocApiAttributeArgument* _tmp25_;
			_tmp22_ = version;
			_tmp23_ = valadoc_api_attribute_get_argument (_tmp22_, "replacement");
			_g_object_unref0 (replacement);
			replacement = _tmp23_;
			_tmp24_ = version;
			_tmp25_ = valadoc_api_attribute_get_argument (_tmp24_, "deprecated_since");
			_g_object_unref0 (since);
			since = _tmp25_;
		} else {
			ValadocApiSymbol* _tmp26_;
			ValadocApiAttribute* _tmp27_;
			ValadocApiAttribute* _tmp28_;
			_tmp26_ = symbol;
			_tmp27_ = valadoc_api_symbol_get_attribute (_tmp26_, "Deprecated");
			_g_object_unref0 (deprecated);
			deprecated = _tmp27_;
			_tmp28_ = deprecated;
			if (_tmp28_ != NULL) {
				ValadocApiAttribute* _tmp29_;
				ValadocApiAttributeArgument* _tmp30_;
				ValadocApiAttribute* _tmp31_;
				ValadocApiAttributeArgument* _tmp32_;
				_tmp29_ = deprecated;
				_tmp30_ = valadoc_api_attribute_get_argument (_tmp29_, "replacement");
				_g_object_unref0 (replacement);
				replacement = _tmp30_;
				_tmp31_ = deprecated;
				_tmp32_ = valadoc_api_attribute_get_argument (_tmp31_, "version");
				_g_object_unref0 (since);
				since = _tmp32_;
			} else {
				g_assert_not_reached ();
			}
		}
		_tmp33_ = self->writer;
		_tmp34_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp33_, "p", NULL, 0);
		_tmp35_ = _tmp34_;
		_valadoc_markup_writer_unref0 (_tmp35_);
		_tmp36_ = self->writer;
		_tmp37_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp36_, "b", NULL, 0);
		_tmp38_ = _tmp37_;
		_valadoc_markup_writer_unref0 (_tmp38_);
		_tmp39_ = self->writer;
		_tmp40_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp39_, "Warning:");
		_tmp41_ = _tmp40_;
		_valadoc_markup_writer_unref0 (_tmp41_);
		_tmp42_ = self->writer;
		_tmp43_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp42_, "b");
		_tmp44_ = _tmp43_;
		_valadoc_markup_writer_unref0 (_tmp44_);
		_tmp45_ = self->writer;
		_tmp46_ = valadoc_api_node_get_name (element);
		_tmp47_ = _tmp46_;
		_tmp48_ = g_strdup_printf (" %s is deprecated", _tmp47_);
		_tmp49_ = _tmp48_;
		_tmp50_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp45_, _tmp49_);
		_tmp51_ = _tmp50_;
		_valadoc_markup_writer_unref0 (_tmp51_);
		_g_free0 (_tmp49_);
		_tmp52_ = since;
		if (_tmp52_ != NULL) {
			ValadocHtmlMarkupWriter* _tmp53_;
			ValadocApiAttributeArgument* _tmp54_;
			gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar* _tmp58_;
			ValadocMarkupWriter* _tmp59_;
			ValadocMarkupWriter* _tmp60_;
			_tmp53_ = self->writer;
			_tmp54_ = since;
			_tmp55_ = valadoc_api_attribute_argument_get_value_as_string (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = g_strdup_printf (" since %s", _tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp53_, _tmp58_);
			_tmp60_ = _tmp59_;
			_valadoc_markup_writer_unref0 (_tmp60_);
			_g_free0 (_tmp58_);
			_g_free0 (_tmp56_);
		}
		_tmp61_ = self->writer;
		_tmp62_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp61_, ".");
		_tmp63_ = _tmp62_;
		_valadoc_markup_writer_unref0 (_tmp63_);
		_tmp64_ = replacement;
		if (_tmp64_ != NULL) {
			gchar* replacement_name = NULL;
			ValadocApiAttributeArgument* _tmp65_;
			gchar* _tmp66_;
			ValadocApiNode* replacement_node = NULL;
			ValadocApiTree* _tmp67_;
			const gchar* _tmp68_;
			const gchar* _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gchar* _tmp72_;
			gchar* _tmp73_;
			ValadocApiNode* _tmp74_;
			ValadocApiNode* _tmp75_;
			ValadocHtmlMarkupWriter* _tmp76_;
			ValadocMarkupWriter* _tmp77_;
			ValadocMarkupWriter* _tmp78_;
			ValadocApiNode* _tmp79_;
			ValadocHtmlMarkupWriter* _tmp108_;
			ValadocMarkupWriter* _tmp109_;
			ValadocMarkupWriter* _tmp110_;
			_tmp65_ = replacement;
			_tmp66_ = valadoc_api_attribute_argument_get_value_as_string (_tmp65_);
			replacement_name = _tmp66_;
			_tmp67_ = self->tree;
			_tmp68_ = replacement_name;
			_tmp69_ = replacement_name;
			_tmp70_ = strlen (_tmp69_);
			_tmp71_ = _tmp70_;
			_tmp72_ = string_substring (_tmp68_, (glong) 1, (glong) (_tmp71_ - 2));
			_tmp73_ = _tmp72_;
			_tmp74_ = valadoc_api_tree_search_symbol_str (_tmp67_, pos, _tmp73_);
			_tmp75_ = _tmp74_;
			_g_free0 (_tmp73_);
			replacement_node = _tmp75_;
			_tmp76_ = self->writer;
			_tmp77_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp76_, " Use ");
			_tmp78_ = _tmp77_;
			_valadoc_markup_writer_unref0 (_tmp78_);
			_tmp79_ = replacement_node;
			if (_tmp79_ == NULL) {
				ValadocHtmlMarkupWriter* _tmp80_;
				const gchar* _tmp81_;
				ValadocMarkupWriter* _tmp82_;
				ValadocMarkupWriter* _tmp83_;
				_tmp80_ = self->writer;
				_tmp81_ = replacement_name;
				_tmp82_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp80_, _tmp81_);
				_tmp83_ = _tmp82_;
				_valadoc_markup_writer_unref0 (_tmp83_);
			} else {
				gchar* link = NULL;
				ValadocApiNode* _tmp84_;
				gchar* _tmp85_;
				const gchar* _tmp86_;
				_tmp84_ = replacement_node;
				_tmp85_ = valadoc_html_basic_doclet_get_link (self, _tmp84_, pos);
				link = _tmp85_;
				_tmp86_ = link;
				if (_tmp86_ != NULL) {
					gchar* css = NULL;
					ValadocHtmlCssClassResolver* _tmp87_;
					ValadocApiNode* _tmp88_;
					gchar* _tmp89_;
					ValadocHtmlMarkupWriter* _tmp90_;
					const gchar* _tmp91_;
					ValadocApiNode* _tmp92_;
					gchar* _tmp93_;
					gchar* _tmp94_;
					const gchar* _tmp95_;
					ValadocHtmlMarkupWriter* _tmp96_;
					ValadocHtmlMarkupWriter* _tmp97_;
					_tmp87_ = self->cssresolver;
					_tmp88_ = replacement_node;
					_tmp89_ = valadoc_html_css_class_resolver_resolve (_tmp87_, _tmp88_);
					css = _tmp89_;
					_tmp90_ = self->writer;
					_tmp91_ = link;
					_tmp92_ = replacement_node;
					_tmp93_ = valadoc_api_node_get_full_name (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = css;
					_tmp96_ = valadoc_html_markup_writer_link (_tmp90_, _tmp91_, _tmp94_, _tmp95_);
					_tmp97_ = _tmp96_;
					_valadoc_markup_writer_unref0 (_tmp97_);
					_g_free0 (_tmp94_);
					_g_free0 (css);
				} else {
					ValadocHtmlMarkupWriter* _tmp98_;
					ValadocMarkupWriter* _tmp99_;
					ValadocMarkupWriter* _tmp100_;
					ValadocApiNode* _tmp101_;
					gchar* _tmp102_;
					gchar* _tmp103_;
					ValadocMarkupWriter* _tmp104_;
					ValadocMarkupWriter* _tmp105_;
					ValadocMarkupWriter* _tmp106_;
					ValadocMarkupWriter* _tmp107_;
					_tmp98_ = self->writer;
					_tmp99_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp98_, "code", NULL, 0);
					_tmp100_ = _tmp99_;
					_tmp101_ = replacement_node;
					_tmp102_ = valadoc_api_node_get_full_name (_tmp101_);
					_tmp103_ = _tmp102_;
					_tmp104_ = valadoc_markup_writer_text (_tmp100_, _tmp103_);
					_tmp105_ = _tmp104_;
					_tmp106_ = valadoc_markup_writer_end_tag (_tmp105_, "code");
					_tmp107_ = _tmp106_;
					_valadoc_markup_writer_unref0 (_tmp107_);
					_valadoc_markup_writer_unref0 (_tmp105_);
					_g_free0 (_tmp103_);
					_valadoc_markup_writer_unref0 (_tmp100_);
				}
				_g_free0 (link);
			}
			_tmp108_ = self->writer;
			_tmp109_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp108_, ".");
			_tmp110_ = _tmp109_;
			_valadoc_markup_writer_unref0 (_tmp110_);
			_g_object_unref0 (replacement_node);
			_g_free0 (replacement_name);
		}
		_tmp111_ = self->writer;
		_tmp112_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp111_, "p");
		_tmp113_ = _tmp112_;
		_valadoc_markup_writer_unref0 (_tmp113_);
		_g_object_unref0 (since);
		_g_object_unref0 (replacement);
		_g_object_unref0 (deprecated);
		_g_object_unref0 (version);
		_g_object_unref0 (symbol);
	}
	_tmp114_ = doctree;
	if (_tmp114_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp115_;
		ValadocHtmlHtmlRenderer* _tmp116_;
		ValadocContentComment* _tmp117_;
		_tmp115_ = self->_renderer;
		valadoc_html_html_renderer_set_container (_tmp115_, (ValadocDocumentation*) pos);
		_tmp116_ = self->_renderer;
		_tmp117_ = doctree;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp116_, (ValadocContentContentElement*) _tmp117_);
	}
	_tmp118_ = self->_renderer;
	valadoc_html_html_renderer_set_owner (_tmp118_, NULL);
	_tmp119_ = self->writer;
	_tmp120_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp119_, "div");
	_tmp121_ = _tmp120_;
	_valadoc_markup_writer_unref0 (_tmp121_);
	_g_object_unref0 (doctree);
}


static void
valadoc_html_basic_doclet_write_attributes (ValadocHtmlBasicDoclet* self,
                                            ValadocApiSymbol* element,
                                            ValadocApiNode* pos)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlHtmlRenderer* _tmp1_;
	ValadocHtmlMarkupWriter* _tmp16_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = self->_renderer;
	valadoc_html_html_renderer_set_container (_tmp1_, (ValadocDocumentation*) pos);
	{
		ValaIterator* _att_it = NULL;
		ValaCollection* _tmp2_;
		ValaCollection* _tmp3_;
		ValaIterator* _tmp4_;
		ValaIterator* _tmp5_;
		_tmp2_ = valadoc_api_symbol_get_attributes (element);
		_tmp3_ = _tmp2_;
		_tmp4_ = vala_iterable_iterator ((ValaIterable*) _tmp3_);
		_tmp5_ = _tmp4_;
		_vala_iterable_unref0 (_tmp3_);
		_att_it = _tmp5_;
		while (TRUE) {
			ValaIterator* _tmp6_;
			ValadocApiAttribute* att = NULL;
			ValaIterator* _tmp7_;
			gpointer _tmp8_;
			ValadocHtmlHtmlRenderer* _tmp9_;
			ValadocApiAttribute* _tmp10_;
			ValadocContentInline* _tmp11_;
			ValadocContentInline* _tmp12_;
			ValadocHtmlMarkupWriter* _tmp13_;
			ValadocMarkupWriter* _tmp14_;
			ValadocMarkupWriter* _tmp15_;
			_tmp6_ = _att_it;
			if (!vala_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _att_it;
			_tmp8_ = vala_iterator_get (_tmp7_);
			att = (ValadocApiAttribute*) _tmp8_;
			_tmp9_ = self->_renderer;
			_tmp10_ = att;
			_tmp11_ = valadoc_api_item_get_signature ((ValadocApiItem*) _tmp10_);
			_tmp12_ = _tmp11_;
			valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp9_, (ValadocContentContentElement*) _tmp12_);
			_tmp13_ = self->writer;
			_tmp14_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp13_, "br", NULL, 0);
			_tmp15_ = _tmp14_;
			_valadoc_markup_writer_unref0 (_tmp15_);
			_g_object_unref0 (att);
		}
		_vala_iterator_unref0 (_att_it);
	}
	_tmp16_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp16_, TRUE);
}


static void
valadoc_html_basic_doclet_write_signature (ValadocHtmlBasicDoclet* self,
                                           ValadocApiNode* element,
                                           ValadocApiNode* pos)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocHtmlHtmlRenderer* _tmp1_;
	ValadocHtmlHtmlRenderer* _tmp2_;
	ValadocContentInline* _tmp3_;
	ValadocContentInline* _tmp4_;
	ValadocHtmlMarkupWriter* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	_tmp0_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp0_, FALSE);
	_tmp1_ = self->_renderer;
	valadoc_html_html_renderer_set_container (_tmp1_, (ValadocDocumentation*) pos);
	_tmp2_ = self->_renderer;
	_tmp3_ = valadoc_api_item_get_signature ((ValadocApiItem*) element);
	_tmp4_ = _tmp3_;
	valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp2_, (ValadocContentContentElement*) _tmp4_);
	_tmp5_ = self->writer;
	valadoc_markup_writer_set_wrap ((ValadocMarkupWriter*) _tmp5_, TRUE);
}


gboolean
valadoc_html_basic_doclet_is_internal_node (ValadocHtmlBasicDoclet* self,
                                            ValadocApiNode* node)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_PACKAGE)) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_NAMESPACE);
	}
	if (_tmp7_) {
		_tmp6_ = TRUE;
	} else {
		_tmp6_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_INTERFACE);
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		_tmp5_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_CLASS);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_STRUCT);
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_ENUM);
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_ENUM_VALUE);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_ERROR_DOMAIN);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_ERROR_CODE);
	}
	result = _tmp0_;
	return result;
}


void
valadoc_html_basic_doclet_write_navi_packages_inline (ValadocHtmlBasicDoclet* self,
                                                      ValadocApiTree* tree)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	ValadocMarkupWriter* _tmp59_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_navi);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "ul", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaIterator* _pkg_it = NULL;
		ValaCollection* _tmp7_;
		ValaCollection* _tmp8_;
		ValaIterator* _tmp9_;
		ValaIterator* _tmp10_;
		_tmp7_ = valadoc_api_tree_get_package_list (tree);
		_tmp8_ = _tmp7_;
		_tmp9_ = vala_iterable_iterator ((ValaIterable*) _tmp8_);
		_tmp10_ = _tmp9_;
		_vala_iterable_unref0 (_tmp8_);
		_pkg_it = _tmp10_;
		while (TRUE) {
			ValaIterator* _tmp11_;
			ValadocApiPackage* pkg = NULL;
			ValaIterator* _tmp12_;
			gpointer _tmp13_;
			ValadocApiPackage* _tmp14_;
			ValadocSettings* _tmp15_;
			_tmp11_ = _pkg_it;
			if (!vala_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _pkg_it;
			_tmp13_ = vala_iterator_get (_tmp12_);
			pkg = (ValadocApiPackage*) _tmp13_;
			_tmp14_ = pkg;
			_tmp15_ = self->priv->_settings;
			if (valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp14_, _tmp15_)) {
				ValadocHtmlMarkupWriter* _tmp16_;
				gchar* _tmp17_;
				ValadocHtmlCssClassResolver* _tmp18_;
				ValadocApiPackage* _tmp19_;
				gchar* _tmp20_;
				gchar** _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				ValadocMarkupWriter* _tmp23_;
				ValadocMarkupWriter* _tmp24_;
				ValadocHtmlMarkupWriter* _tmp25_;
				ValadocHtmlLinkHelper* _tmp26_;
				ValadocApiPackage* _tmp27_;
				ValadocSettings* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				ValadocApiPackage* _tmp31_;
				const gchar* _tmp32_;
				const gchar* _tmp33_;
				ValadocHtmlMarkupWriter* _tmp34_;
				ValadocHtmlMarkupWriter* _tmp35_;
				ValadocHtmlMarkupWriter* _tmp36_;
				ValadocMarkupWriter* _tmp37_;
				ValadocMarkupWriter* _tmp38_;
				_tmp16_ = self->writer;
				_tmp17_ = g_strdup ("class");
				_tmp18_ = self->cssresolver;
				_tmp19_ = pkg;
				_tmp20_ = valadoc_html_css_class_resolver_resolve (_tmp18_, (ValadocApiNode*) _tmp19_);
				_tmp21_ = g_new0 (gchar*, 2 + 1);
				_tmp21_[0] = _tmp17_;
				_tmp21_[1] = _tmp20_;
				_tmp22_ = _tmp21_;
				_tmp22__length1 = 2;
				_tmp23_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "li", _tmp22_, 2);
				_tmp24_ = _tmp23_;
				_valadoc_markup_writer_unref0 (_tmp24_);
				_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
				_tmp25_ = self->writer;
				_tmp26_ = self->priv->_linker;
				_tmp27_ = pkg;
				_tmp28_ = self->priv->_settings;
				_tmp29_ = valadoc_html_link_helper_get_package_link (_tmp26_, _tmp27_, _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = pkg;
				_tmp32_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = valadoc_html_markup_writer_link (_tmp25_, _tmp30_, _tmp33_, NULL);
				_tmp35_ = _tmp34_;
				_valadoc_markup_writer_unref0 (_tmp35_);
				_g_free0 (_tmp30_);
				_tmp36_ = self->writer;
				_tmp37_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp36_, "li");
				_tmp38_ = _tmp37_;
				_valadoc_markup_writer_unref0 (_tmp38_);
			} else {
				ValadocHtmlMarkupWriter* _tmp39_;
				gchar* _tmp40_;
				ValadocHtmlCssClassResolver* _tmp41_;
				ValadocApiPackage* _tmp42_;
				gchar* _tmp43_;
				gchar** _tmp44_;
				gchar** _tmp45_;
				gint _tmp45__length1;
				ValadocMarkupWriter* _tmp46_;
				ValadocMarkupWriter* _tmp47_;
				ValadocHtmlMarkupWriter* _tmp48_;
				ValadocApiPackage* _tmp49_;
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				ValadocMarkupWriter* _tmp52_;
				ValadocMarkupWriter* _tmp53_;
				ValadocHtmlMarkupWriter* _tmp54_;
				ValadocMarkupWriter* _tmp55_;
				ValadocMarkupWriter* _tmp56_;
				_tmp39_ = self->writer;
				_tmp40_ = g_strdup ("class");
				_tmp41_ = self->cssresolver;
				_tmp42_ = pkg;
				_tmp43_ = valadoc_html_css_class_resolver_resolve (_tmp41_, (ValadocApiNode*) _tmp42_);
				_tmp44_ = g_new0 (gchar*, 2 + 1);
				_tmp44_[0] = _tmp40_;
				_tmp44_[1] = _tmp43_;
				_tmp45_ = _tmp44_;
				_tmp45__length1 = 2;
				_tmp46_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp39_, "li", _tmp45_, 2);
				_tmp47_ = _tmp46_;
				_valadoc_markup_writer_unref0 (_tmp47_);
				_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
				_tmp48_ = self->writer;
				_tmp49_ = pkg;
				_tmp50_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp49_);
				_tmp51_ = _tmp50_;
				_tmp52_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp48_, _tmp51_);
				_tmp53_ = _tmp52_;
				_valadoc_markup_writer_unref0 (_tmp53_);
				_tmp54_ = self->writer;
				_tmp55_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp54_, "li");
				_tmp56_ = _tmp55_;
				_valadoc_markup_writer_unref0 (_tmp56_);
			}
			_g_object_unref0 (pkg);
		}
		_vala_iterator_unref0 (_pkg_it);
	}
	_tmp57_ = self->writer;
	_tmp58_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp57_, "ul");
	_tmp59_ = _tmp58_;
	_valadoc_markup_writer_unref0 (_tmp59_);
}


void
valadoc_html_basic_doclet_write_navi_packages (ValadocHtmlBasicDoclet* self,
                                               ValadocApiTree* tree)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_navigation);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_navi_packages_inline (self, tree);
	_tmp7_ = self->writer;
	_tmp8_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp7_, "div");
	_tmp9_ = _tmp8_;
	_valadoc_markup_writer_unref0 (_tmp9_);
}


void
valadoc_html_basic_doclet_write_package_index_content (ValadocHtmlBasicDoclet* self,
                                                       ValadocApiTree* tree)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar** _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocWikiPage* _tmp25_ = NULL;
	ValadocWikiPageTree* _tmp26_;
	ValadocWikiPageTree* _tmp27_;
	ValadocWikiPage* wikiindex = NULL;
	ValadocWikiPage* _tmp32_;
	ValadocWikiPage* _tmp33_;
	ValadocHtmlMarkupWriter* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar** _tmp43_;
	gchar** _tmp44_;
	gint _tmp44__length1;
	ValadocMarkupWriter* _tmp45_;
	ValadocMarkupWriter* _tmp46_;
	ValadocMarkupWriter* _tmp47_;
	ValadocMarkupWriter* _tmp48_;
	ValadocMarkupWriter* _tmp49_;
	ValadocMarkupWriter* _tmp50_;
	ValadocHtmlMarkupWriter* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	gchar** _tmp54_;
	gchar** _tmp55_;
	gint _tmp55__length1;
	ValadocMarkupWriter* _tmp56_;
	ValadocMarkupWriter* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	ValadocMarkupWriter* _tmp59_;
	ValadocMarkupWriter* _tmp60_;
	ValadocMarkupWriter* _tmp61_;
	ValadocHtmlMarkupWriter* _tmp62_;
	ValadocMarkupWriter* _tmp63_;
	ValadocMarkupWriter* _tmp64_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tree != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "h1", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_markup_writer_text (_tmp13_, "Packages:");
	_tmp15_ = _tmp14_;
	_tmp16_ = valadoc_markup_writer_end_tag (_tmp15_, "h1");
	_tmp17_ = _tmp16_;
	_valadoc_markup_writer_unref0 (_tmp17_);
	_valadoc_markup_writer_unref0 (_tmp15_);
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = self->writer;
	_tmp19_ = g_strdup ("class");
	_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp21_ = g_new0 (gchar*, 2 + 1);
	_tmp21_[0] = _tmp19_;
	_tmp21_[1] = _tmp20_;
	_tmp22_ = _tmp21_;
	_tmp22__length1 = 2;
	_tmp23_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp18_, "hr", _tmp22_, 2);
	_tmp24_ = _tmp23_;
	_valadoc_markup_writer_unref0 (_tmp24_);
	_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
	_tmp26_ = valadoc_api_tree_get_wikitree (tree);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == NULL) {
		_g_object_unref0 (_tmp25_);
		_tmp25_ = NULL;
	} else {
		ValadocWikiPageTree* _tmp28_;
		ValadocWikiPageTree* _tmp29_;
		const gchar* _tmp30_;
		ValadocWikiPage* _tmp31_;
		_tmp28_ = valadoc_api_tree_get_wikitree (tree);
		_tmp29_ = _tmp28_;
		_tmp30_ = self->priv->_wiki_index_name;
		_tmp31_ = valadoc_wiki_page_tree_search (_tmp29_, _tmp30_);
		_g_object_unref0 (_tmp25_);
		_tmp25_ = _tmp31_;
	}
	_tmp32_ = _g_object_ref0 (_tmp25_);
	wikiindex = _tmp32_;
	_tmp33_ = wikiindex;
	if (_tmp33_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp34_;
		ValadocWikiPage* _tmp35_;
		ValadocHtmlHtmlRenderer* _tmp36_;
		ValadocWikiPage* _tmp37_;
		ValadocContentPage* _tmp38_;
		ValadocContentPage* _tmp39_;
		_tmp34_ = self->_renderer;
		_tmp35_ = wikiindex;
		valadoc_html_html_renderer_set_container (_tmp34_, (ValadocDocumentation*) _tmp35_);
		_tmp36_ = self->_renderer;
		_tmp37_ = wikiindex;
		_tmp38_ = valadoc_wiki_page_get_documentation (_tmp37_);
		_tmp39_ = _tmp38_;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp36_, (ValadocContentContentElement*) _tmp39_);
	}
	_tmp40_ = self->writer;
	_tmp41_ = g_strdup ("class");
	_tmp42_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp43_ = g_new0 (gchar*, 2 + 1);
	_tmp43_[0] = _tmp41_;
	_tmp43_[1] = _tmp42_;
	_tmp44_ = _tmp43_;
	_tmp44__length1 = 2;
	_tmp45_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp40_, "h2", _tmp44_, 2);
	_tmp46_ = _tmp45_;
	_tmp47_ = valadoc_markup_writer_text (_tmp46_, "Content:");
	_tmp48_ = _tmp47_;
	_tmp49_ = valadoc_markup_writer_end_tag (_tmp48_, "h2");
	_tmp50_ = _tmp49_;
	_valadoc_markup_writer_unref0 (_tmp50_);
	_valadoc_markup_writer_unref0 (_tmp48_);
	_valadoc_markup_writer_unref0 (_tmp46_);
	_tmp44_ = (_vala_array_free (_tmp44_, _tmp44__length1, (GDestroyNotify) g_free), NULL);
	_tmp51_ = self->writer;
	_tmp52_ = g_strdup ("class");
	_tmp53_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp54_ = g_new0 (gchar*, 2 + 1);
	_tmp54_[0] = _tmp52_;
	_tmp54_[1] = _tmp53_;
	_tmp55_ = _tmp54_;
	_tmp55__length1 = 2;
	_tmp56_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp51_, "h3", _tmp55_, 2);
	_tmp57_ = _tmp56_;
	_tmp58_ = valadoc_markup_writer_text (_tmp57_, "Packages:");
	_tmp59_ = _tmp58_;
	_tmp60_ = valadoc_markup_writer_end_tag (_tmp59_, "h3");
	_tmp61_ = _tmp60_;
	_valadoc_markup_writer_unref0 (_tmp61_);
	_valadoc_markup_writer_unref0 (_tmp59_);
	_valadoc_markup_writer_unref0 (_tmp57_);
	_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_navi_packages_inline (self, tree);
	_tmp62_ = self->writer;
	_tmp63_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp62_, "div");
	_tmp64_ = _tmp63_;
	_valadoc_markup_writer_unref0 (_tmp64_);
	_g_object_unref0 (wikiindex);
	_g_object_unref0 (_tmp25_);
}


static inline ValaArrayList*
valadoc_html_basic_doclet_get_accessible_nodes_from_list (ValadocHtmlBasicDoclet* self,
                                                          ValaCollection* nodes)
{
	ValaArrayList* result = NULL;
	ValaArrayList* list = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (nodes != NULL, NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NODE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	list = _tmp1_;
	{
		ValaIterator* _node_it = NULL;
		ValaIterator* _tmp2_;
		_tmp2_ = vala_iterable_iterator ((ValaIterable*) nodes);
		_node_it = _tmp2_;
		while (TRUE) {
			ValaIterator* _tmp3_;
			ValadocApiNode* node = NULL;
			ValaIterator* _tmp4_;
			gpointer _tmp5_;
			ValadocApiNode* _tmp6_;
			ValadocSettings* _tmp7_;
			_tmp3_ = _node_it;
			if (!vala_iterator_next (_tmp3_)) {
				break;
			}
			_tmp4_ = _node_it;
			_tmp5_ = vala_iterator_get (_tmp4_);
			node = (ValadocApiNode*) _tmp5_;
			_tmp6_ = node;
			_tmp7_ = self->priv->_settings;
			if (valadoc_api_node_is_browsable (_tmp6_, _tmp7_)) {
				ValaArrayList* _tmp8_;
				ValadocApiNode* _tmp9_;
				_tmp8_ = list;
				_tmp9_ = node;
				vala_collection_add ((ValaCollection*) _tmp8_, _tmp9_);
			}
			_g_object_unref0 (node);
		}
		_vala_iterator_unref0 (_node_it);
	}
	result = list;
	return result;
}


static void
valadoc_html_basic_doclet_write_known_symbols_note (ValadocHtmlBasicDoclet* self,
                                                    ValaCollection* nodes2,
                                                    ValadocApiNode* container,
                                                    const gchar* headline)
{
	ValaArrayList* nodes = NULL;
	ValaArrayList* _tmp0_;
	ValaArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValaArrayList* _tmp4_;
	gchar* html_id = NULL;
	guint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	guint _tmp10_;
	ValadocHtmlMarkupWriter* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	gchar** _tmp24_;
	gchar** _tmp25_;
	gint _tmp25__length1;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	ValadocMarkupWriter* _tmp31_;
	gint* list_sizes = NULL;
	gint* _tmp32_;
	gint list_sizes_length1;
	gint _list_sizes_size_;
	gint* _tmp33_;
	gint _tmp33__length1;
	ValaArrayList* _tmp34_;
	gint _tmp35_;
	gint _tmp36_;
	gint* _tmp37_;
	gint _tmp37__length1;
	gint* _tmp38_;
	gint _tmp38__length1;
	gint _tmp39_;
	gint* _tmp40_;
	gint _tmp40__length1;
	gint* _tmp41_;
	gint _tmp41__length1;
	gint _tmp42_;
	gint* _tmp43_;
	gint _tmp43__length1;
	gint* _tmp44_;
	gint _tmp44__length1;
	gint _tmp45_;
	gint* _tmp46_;
	gint _tmp46__length1;
	gint* _tmp47_;
	gint _tmp47__length1;
	gint _tmp48_;
	ValadocHtmlMarkupWriter* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	const gchar* _tmp53_;
	gchar* _tmp54_;
	gchar** _tmp55_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	ValadocMarkupWriter* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	ValaIterator* iter = NULL;
	ValaArrayList* _tmp59_;
	ValaIterator* _tmp60_;
	ValadocHtmlMarkupWriter* _tmp123_;
	ValadocMarkupWriter* _tmp124_;
	ValadocMarkupWriter* _tmp125_;
	ValadocHtmlMarkupWriter* _tmp126_;
	ValadocMarkupWriter* _tmp127_;
	ValadocMarkupWriter* _tmp128_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nodes2 != NULL);
	g_return_if_fail (container != NULL);
	g_return_if_fail (headline != NULL);
	_tmp0_ = valadoc_html_basic_doclet_get_accessible_nodes_from_list (self, nodes2);
	nodes = _tmp0_;
	_tmp1_ = nodes;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_vala_iterable_unref0 (nodes);
		return;
	}
	_tmp4_ = nodes;
	vala_list_sort ((ValaList*) _tmp4_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
	_tmp5_ = self->priv->html_id_counter;
	_tmp6_ = g_strdup_printf ("%u", _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strconcat ("box-content-", _tmp7_, NULL);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	html_id = _tmp9_;
	_tmp10_ = self->priv->html_id_counter;
	self->priv->html_id_counter = _tmp10_ + 1;
	_tmp11_ = self->writer;
	_tmp12_ = g_strdup ("class");
	_tmp13_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box);
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp12_;
	_tmp14_[1] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 2;
	_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp11_, "div", _tmp15_, 2);
	_tmp17_ = _tmp16_;
	_valadoc_markup_writer_unref0 (_tmp17_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp18_ = self->writer;
	_tmp19_ = g_strdup ("class");
	_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_headline);
	_tmp21_ = g_strdup ("onclick");
	_tmp22_ = html_id;
	_tmp23_ = g_strdup_printf ("toggle_box (this, '%s')", _tmp22_);
	_tmp24_ = g_new0 (gchar*, 4 + 1);
	_tmp24_[0] = _tmp19_;
	_tmp24_[1] = _tmp20_;
	_tmp24_[2] = _tmp21_;
	_tmp24_[3] = _tmp23_;
	_tmp25_ = _tmp24_;
	_tmp25__length1 = 4;
	_tmp26_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "div", _tmp25_, 4);
	_tmp27_ = _tmp26_;
	_tmp28_ = valadoc_markup_writer_text (_tmp27_, headline);
	_tmp29_ = _tmp28_;
	_tmp30_ = valadoc_markup_writer_end_tag (_tmp29_, "div");
	_tmp31_ = _tmp30_;
	_valadoc_markup_writer_unref0 (_tmp31_);
	_valadoc_markup_writer_unref0 (_tmp29_);
	_valadoc_markup_writer_unref0 (_tmp27_);
	_tmp25_ = (_vala_array_free (_tmp25_, _tmp25__length1, (GDestroyNotify) g_free), NULL);
	_tmp32_ = g_new0 (gint, 3);
	_tmp32_[0] = 0;
	_tmp32_[1] = 0;
	_tmp32_[2] = 0;
	list_sizes = _tmp32_;
	list_sizes_length1 = 3;
	_list_sizes_size_ = list_sizes_length1;
	_tmp33_ = list_sizes;
	_tmp33__length1 = list_sizes_length1;
	_tmp34_ = nodes;
	_tmp35_ = vala_collection_get_size ((ValaCollection*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp33_[0] = _tmp36_;
	_tmp37_ = list_sizes;
	_tmp37__length1 = list_sizes_length1;
	_tmp38_ = list_sizes;
	_tmp38__length1 = list_sizes_length1;
	_tmp39_ = _tmp38_[0];
	_tmp37_[2] = _tmp39_ / 3;
	_tmp40_ = list_sizes;
	_tmp40__length1 = list_sizes_length1;
	_tmp41_ = list_sizes;
	_tmp41__length1 = list_sizes_length1;
	_tmp42_ = _tmp41_[2];
	_tmp40_[0] -= _tmp42_;
	_tmp43_ = list_sizes;
	_tmp43__length1 = list_sizes_length1;
	_tmp44_ = list_sizes;
	_tmp44__length1 = list_sizes_length1;
	_tmp45_ = _tmp44_[0];
	_tmp43_[1] = _tmp45_ / 2;
	_tmp46_ = list_sizes;
	_tmp46__length1 = list_sizes_length1;
	_tmp47_ = list_sizes;
	_tmp47__length1 = list_sizes_length1;
	_tmp48_ = _tmp47_[1];
	_tmp46_[0] -= _tmp48_;
	_tmp49_ = self->writer;
	_tmp50_ = g_strdup ("class");
	_tmp51_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_content);
	_tmp52_ = g_strdup ("id");
	_tmp53_ = html_id;
	_tmp54_ = g_strdup (_tmp53_);
	_tmp55_ = g_new0 (gchar*, 4 + 1);
	_tmp55_[0] = _tmp50_;
	_tmp55_[1] = _tmp51_;
	_tmp55_[2] = _tmp52_;
	_tmp55_[3] = _tmp54_;
	_tmp56_ = _tmp55_;
	_tmp56__length1 = 4;
	_tmp57_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp49_, "div", _tmp56_, 4);
	_tmp58_ = _tmp57_;
	_valadoc_markup_writer_unref0 (_tmp58_);
	_tmp56_ = (_vala_array_free (_tmp56_, _tmp56__length1, (GDestroyNotify) g_free), NULL);
	_tmp59_ = nodes;
	_tmp60_ = vala_iterable_iterator ((ValaIterable*) _tmp59_);
	iter = _tmp60_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp61_ = FALSE;
			_tmp61_ = TRUE;
			while (TRUE) {
				gint _tmp63_;
				gint* _tmp64_;
				gint _tmp64__length1;
				ValadocHtmlMarkupWriter* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar** _tmp68_;
				gchar** _tmp69_;
				gint _tmp69__length1;
				ValadocMarkupWriter* _tmp70_;
				ValadocMarkupWriter* _tmp71_;
				ValadocHtmlMarkupWriter* _tmp72_;
				gchar* _tmp73_;
				gchar* _tmp74_;
				gchar** _tmp75_;
				gchar** _tmp76_;
				gint _tmp76__length1;
				ValadocMarkupWriter* _tmp77_;
				ValadocMarkupWriter* _tmp78_;
				ValadocHtmlMarkupWriter* _tmp117_;
				ValadocMarkupWriter* _tmp118_;
				ValadocMarkupWriter* _tmp119_;
				ValadocHtmlMarkupWriter* _tmp120_;
				ValadocMarkupWriter* _tmp121_;
				ValadocMarkupWriter* _tmp122_;
				if (!_tmp61_) {
					gint _tmp62_;
					_tmp62_ = i;
					i = _tmp62_ + 1;
				}
				_tmp61_ = FALSE;
				_tmp63_ = i;
				_tmp64_ = list_sizes;
				_tmp64__length1 = list_sizes_length1;
				if (!(_tmp63_ < _tmp64__length1)) {
					break;
				}
				_tmp65_ = self->writer;
				_tmp66_ = g_strdup ("class");
				_tmp67_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_box_column);
				_tmp68_ = g_new0 (gchar*, 2 + 1);
				_tmp68_[0] = _tmp66_;
				_tmp68_[1] = _tmp67_;
				_tmp69_ = _tmp68_;
				_tmp69__length1 = 2;
				_tmp70_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp65_, "div", _tmp69_, 2);
				_tmp71_ = _tmp70_;
				_valadoc_markup_writer_unref0 (_tmp71_);
				_tmp69_ = (_vala_array_free (_tmp69_, _tmp69__length1, (GDestroyNotify) g_free), NULL);
				_tmp72_ = self->writer;
				_tmp73_ = g_strdup ("class");
				_tmp74_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
				_tmp75_ = g_new0 (gchar*, 2 + 1);
				_tmp75_[0] = _tmp73_;
				_tmp75_[1] = _tmp74_;
				_tmp76_ = _tmp75_;
				_tmp76__length1 = 2;
				_tmp77_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp72_, "ul", _tmp76_, 2);
				_tmp78_ = _tmp77_;
				_valadoc_markup_writer_unref0 (_tmp78_);
				_tmp76_ = (_vala_array_free (_tmp76_, _tmp76__length1, (GDestroyNotify) g_free), NULL);
				{
					gint p = 0;
					p = 0;
					{
						gboolean _tmp79_ = FALSE;
						_tmp79_ = TRUE;
						while (TRUE) {
							gboolean _tmp81_ = FALSE;
							gint _tmp82_;
							gint* _tmp83_;
							gint _tmp83__length1;
							gint _tmp84_;
							gint _tmp85_;
							ValadocApiNode* node = NULL;
							ValaIterator* _tmp87_;
							gpointer _tmp88_;
							ValadocHtmlMarkupWriter* _tmp89_;
							gchar* _tmp90_;
							ValadocHtmlCssClassResolver* _tmp91_;
							ValadocApiNode* _tmp92_;
							gchar* _tmp93_;
							gchar** _tmp94_;
							gchar** _tmp95_;
							gint _tmp95__length1;
							ValadocMarkupWriter* _tmp96_;
							ValadocMarkupWriter* _tmp97_;
							gchar* link = NULL;
							ValadocApiNode* _tmp98_;
							gchar* _tmp99_;
							const gchar* _tmp100_;
							ValadocHtmlMarkupWriter* _tmp114_;
							ValadocMarkupWriter* _tmp115_;
							ValadocMarkupWriter* _tmp116_;
							if (!_tmp79_) {
								gint _tmp80_;
								_tmp80_ = p;
								p = _tmp80_ + 1;
							}
							_tmp79_ = FALSE;
							_tmp82_ = p;
							_tmp83_ = list_sizes;
							_tmp83__length1 = list_sizes_length1;
							_tmp84_ = i;
							_tmp85_ = _tmp83_[_tmp84_];
							if (_tmp82_ < _tmp85_) {
								ValaIterator* _tmp86_;
								_tmp86_ = iter;
								_tmp81_ = vala_iterator_next (_tmp86_);
							} else {
								_tmp81_ = FALSE;
							}
							if (!_tmp81_) {
								break;
							}
							_tmp87_ = iter;
							_tmp88_ = vala_iterator_get (_tmp87_);
							node = (ValadocApiNode*) _tmp88_;
							_tmp89_ = self->writer;
							_tmp90_ = g_strdup ("class");
							_tmp91_ = self->cssresolver;
							_tmp92_ = node;
							_tmp93_ = valadoc_html_css_class_resolver_resolve (_tmp91_, _tmp92_);
							_tmp94_ = g_new0 (gchar*, 2 + 1);
							_tmp94_[0] = _tmp90_;
							_tmp94_[1] = _tmp93_;
							_tmp95_ = _tmp94_;
							_tmp95__length1 = 2;
							_tmp96_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp89_, "li", _tmp95_, 2);
							_tmp97_ = _tmp96_;
							_valadoc_markup_writer_unref0 (_tmp97_);
							_tmp95_ = (_vala_array_free (_tmp95_, _tmp95__length1, (GDestroyNotify) g_free), NULL);
							_tmp98_ = node;
							_tmp99_ = valadoc_html_basic_doclet_get_link (self, _tmp98_, container);
							link = _tmp99_;
							_tmp100_ = link;
							if (_tmp100_ == NULL) {
								ValadocHtmlMarkupWriter* _tmp101_;
								ValadocApiNode* _tmp102_;
								const gchar* _tmp103_;
								const gchar* _tmp104_;
								ValadocMarkupWriter* _tmp105_;
								ValadocMarkupWriter* _tmp106_;
								_tmp101_ = self->writer;
								_tmp102_ = node;
								_tmp103_ = valadoc_api_node_get_name (_tmp102_);
								_tmp104_ = _tmp103_;
								_tmp105_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp101_, _tmp104_);
								_tmp106_ = _tmp105_;
								_valadoc_markup_writer_unref0 (_tmp106_);
							} else {
								ValadocHtmlMarkupWriter* _tmp107_;
								const gchar* _tmp108_;
								ValadocApiNode* _tmp109_;
								const gchar* _tmp110_;
								const gchar* _tmp111_;
								ValadocHtmlMarkupWriter* _tmp112_;
								ValadocHtmlMarkupWriter* _tmp113_;
								_tmp107_ = self->writer;
								_tmp108_ = link;
								_tmp109_ = node;
								_tmp110_ = valadoc_api_node_get_name (_tmp109_);
								_tmp111_ = _tmp110_;
								_tmp112_ = valadoc_html_markup_writer_link (_tmp107_, _tmp108_, _tmp111_, NULL);
								_tmp113_ = _tmp112_;
								_valadoc_markup_writer_unref0 (_tmp113_);
							}
							_tmp114_ = self->writer;
							_tmp115_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp114_, "li");
							_tmp116_ = _tmp115_;
							_valadoc_markup_writer_unref0 (_tmp116_);
							_g_free0 (link);
							_g_object_unref0 (node);
						}
					}
				}
				_tmp117_ = self->writer;
				_tmp118_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp117_, "ul");
				_tmp119_ = _tmp118_;
				_valadoc_markup_writer_unref0 (_tmp119_);
				_tmp120_ = self->writer;
				_tmp121_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp120_, "div");
				_tmp122_ = _tmp121_;
				_valadoc_markup_writer_unref0 (_tmp122_);
			}
		}
	}
	_tmp123_ = self->writer;
	_tmp124_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp123_, "div");
	_tmp125_ = _tmp124_;
	_valadoc_markup_writer_unref0 (_tmp125_);
	_tmp126_ = self->writer;
	_tmp127_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp126_, "div");
	_tmp128_ = _tmp127_;
	_valadoc_markup_writer_unref0 (_tmp128_);
	_vala_iterator_unref0 (iter);
	list_sizes = (g_free (list_sizes), NULL);
	_g_free0 (html_id);
	_vala_iterable_unref0 (nodes);
}


void
valadoc_html_basic_doclet_write_symbol_content (ValadocHtmlBasicDoclet* self,
                                                ValadocApiNode* node)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocHtmlMarkupWriter* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar** _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	ValadocMarkupWriter* _tmp25_;
	ValadocMarkupWriter* _tmp26_;
	ValadocHtmlMarkupWriter* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	ValadocMarkupWriter* _tmp32_;
	ValadocMarkupWriter* _tmp33_;
	ValadocMarkupWriter* _tmp34_;
	ValadocMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocHtmlMarkupWriter* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar** _tmp41_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	ValadocMarkupWriter* _tmp43_;
	ValadocMarkupWriter* _tmp44_;
	ValadocHtmlMarkupWriter* _tmp45_;
	ValadocMarkupWriter* _tmp46_;
	ValadocMarkupWriter* _tmp47_;
	ValadocApiItem* _tmp71_;
	ValadocApiItem* _tmp72_;
	gboolean _tmp76_ = FALSE;
	gboolean _tmp77_ = FALSE;
	ValadocHtmlMarkupWriter* _tmp92_;
	ValadocMarkupWriter* _tmp93_;
	ValadocMarkupWriter* _tmp94_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp10_ = g_new0 (gchar*, 2 + 1);
	_tmp10_[0] = _tmp8_;
	_tmp10_[1] = _tmp9_;
	_tmp11_ = _tmp10_;
	_tmp11__length1 = 2;
	_tmp12_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "h1", _tmp11_, 2);
	_tmp13_ = _tmp12_;
	_tmp14_ = valadoc_api_node_get_name (node);
	_tmp15_ = _tmp14_;
	_tmp16_ = valadoc_markup_writer_text (_tmp13_, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_markup_writer_end_tag (_tmp17_, "h1");
	_tmp19_ = _tmp18_;
	_valadoc_markup_writer_unref0 (_tmp19_);
	_valadoc_markup_writer_unref0 (_tmp17_);
	_valadoc_markup_writer_unref0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp20_ = self->writer;
	_tmp21_ = g_strdup ("class");
	_tmp22_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp23_ = g_new0 (gchar*, 2 + 1);
	_tmp23_[0] = _tmp21_;
	_tmp23_[1] = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp24__length1 = 2;
	_tmp25_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp20_, "hr", _tmp24_, 2);
	_tmp26_ = _tmp25_;
	_valadoc_markup_writer_unref0 (_tmp26_);
	_tmp24_ = (_vala_array_free (_tmp24_, _tmp24__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_image_block (self, node);
	_tmp27_ = self->writer;
	_tmp28_ = g_strdup ("class");
	_tmp29_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp30_ = g_new0 (gchar*, 2 + 1);
	_tmp30_[0] = _tmp28_;
	_tmp30_[1] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 2;
	_tmp32_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp27_, "h2", _tmp31_, 2);
	_tmp33_ = _tmp32_;
	_tmp34_ = valadoc_markup_writer_text (_tmp33_, "Description:");
	_tmp35_ = _tmp34_;
	_tmp36_ = valadoc_markup_writer_end_tag (_tmp35_, "h2");
	_tmp37_ = _tmp36_;
	_valadoc_markup_writer_unref0 (_tmp37_);
	_valadoc_markup_writer_unref0 (_tmp35_);
	_valadoc_markup_writer_unref0 (_tmp33_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	_tmp38_ = self->writer;
	_tmp39_ = g_strdup ("class");
	_tmp40_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_code_definition);
	_tmp41_ = g_new0 (gchar*, 2 + 1);
	_tmp41_[0] = _tmp39_;
	_tmp41_[1] = _tmp40_;
	_tmp42_ = _tmp41_;
	_tmp42__length1 = 2;
	_tmp43_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp38_, "div", _tmp42_, 2);
	_tmp44_ = _tmp43_;
	_valadoc_markup_writer_unref0 (_tmp44_);
	_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_SYMBOL)) {
		valadoc_html_basic_doclet_write_attributes (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol), node);
	}
	valadoc_html_basic_doclet_write_signature (self, node, node);
	_tmp45_ = self->writer;
	_tmp46_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp45_, "div");
	_tmp47_ = _tmp46_;
	_valadoc_markup_writer_unref0 (_tmp47_);
	valadoc_html_basic_doclet_write_documentation (self, node, node);
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_CLASS)) {
		ValadocApiClass* cl = NULL;
		ValadocApiClass* _tmp48_;
		ValadocApiClass* _tmp49_;
		ValaCollection* _tmp50_;
		ValaCollection* _tmp51_;
		ValadocApiClass* _tmp52_;
		ValadocApiClass* _tmp53_;
		ValaCollection* _tmp54_;
		ValaCollection* _tmp55_;
		ValadocApiClass* _tmp56_;
		_tmp48_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) node) : NULL);
		cl = _tmp48_;
		_tmp49_ = cl;
		_tmp50_ = valadoc_api_class_get_known_child_classes (_tmp49_);
		_tmp51_ = _tmp50_;
		_tmp52_ = cl;
		valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp51_, (ValadocApiNode*) _tmp52_, "All known sub-classes:");
		_vala_iterable_unref0 (_tmp51_);
		_tmp53_ = cl;
		_tmp54_ = valadoc_api_class_get_known_derived_interfaces (_tmp53_);
		_tmp55_ = _tmp54_;
		_tmp56_ = cl;
		valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp55_, (ValadocApiNode*) _tmp56_, "Required by:");
		_vala_iterable_unref0 (_tmp55_);
		_g_object_unref0 (cl);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_INTERFACE)) {
			ValadocApiInterface* iface = NULL;
			ValadocApiInterface* _tmp57_;
			ValadocApiInterface* _tmp58_;
			ValaCollection* _tmp59_;
			ValaCollection* _tmp60_;
			ValadocApiInterface* _tmp61_;
			ValadocApiInterface* _tmp62_;
			ValaCollection* _tmp63_;
			ValaCollection* _tmp64_;
			ValadocApiInterface* _tmp65_;
			_tmp57_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_INTERFACE) ? ((ValadocApiInterface*) node) : NULL);
			iface = _tmp57_;
			_tmp58_ = iface;
			_tmp59_ = valadoc_api_interface_get_known_implementations (_tmp58_);
			_tmp60_ = _tmp59_;
			_tmp61_ = iface;
			valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp60_, (ValadocApiNode*) _tmp61_, "All known implementing classes:");
			_vala_iterable_unref0 (_tmp60_);
			_tmp62_ = iface;
			_tmp63_ = valadoc_api_interface_get_known_related_interfaces (_tmp62_);
			_tmp64_ = _tmp63_;
			_tmp65_ = iface;
			valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp64_, (ValadocApiNode*) _tmp65_, "All known sub-interfaces:");
			_vala_iterable_unref0 (_tmp64_);
			_g_object_unref0 (iface);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_STRUCT)) {
				ValadocApiStruct* stru = NULL;
				ValadocApiStruct* _tmp66_;
				ValadocApiStruct* _tmp67_;
				ValaCollection* _tmp68_;
				ValaCollection* _tmp69_;
				ValadocApiStruct* _tmp70_;
				_tmp66_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_STRUCT) ? ((ValadocApiStruct*) node) : NULL);
				stru = _tmp66_;
				_tmp67_ = stru;
				_tmp68_ = valadoc_api_struct_get_known_child_structs (_tmp67_);
				_tmp69_ = _tmp68_;
				_tmp70_ = stru;
				valadoc_html_basic_doclet_write_known_symbols_note (self, _tmp69_, (ValadocApiNode*) _tmp70_, "All known sub-structs:");
				_vala_iterable_unref0 (_tmp69_);
				_g_object_unref0 (stru);
			}
		}
	}
	_tmp71_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
	_tmp72_ = _tmp71_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALADOC_API_TYPE_NAMESPACE)) {
		ValadocHtmlMarkupWriter* _tmp73_;
		ValadocMarkupWriter* _tmp74_;
		ValadocMarkupWriter* _tmp75_;
		_tmp73_ = self->writer;
		_tmp74_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp73_, "br", NULL, 0);
		_tmp75_ = _tmp74_;
		_valadoc_markup_writer_unref0 (_tmp75_);
		valadoc_html_basic_doclet_write_namespace_note (self, node);
		valadoc_html_basic_doclet_write_package_note (self, node);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_METHOD)) {
		_tmp77_ = TRUE;
	} else {
		_tmp77_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_DELEGATE);
	}
	if (_tmp77_) {
		_tmp76_ = TRUE;
	} else {
		_tmp76_ = G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_SIGNAL);
	}
	if (!_tmp76_) {
		ValadocApiNodeType* _tmp78_;
		ValadocApiNodeType* _tmp79_;
		gint _tmp79__length1;
		gboolean _tmp80_;
		_tmp78_ = g_new0 (ValadocApiNodeType, 13);
		_tmp78_[0] = VALADOC_API_NODE_TYPE_ERROR_CODE;
		_tmp78_[1] = VALADOC_API_NODE_TYPE_ENUM_VALUE;
		_tmp78_[2] = VALADOC_API_NODE_TYPE_CREATION_METHOD;
		_tmp78_[3] = VALADOC_API_NODE_TYPE_STATIC_METHOD;
		_tmp78_[4] = VALADOC_API_NODE_TYPE_CLASS;
		_tmp78_[5] = VALADOC_API_NODE_TYPE_STRUCT;
		_tmp78_[6] = VALADOC_API_NODE_TYPE_ENUM;
		_tmp78_[7] = VALADOC_API_NODE_TYPE_DELEGATE;
		_tmp78_[8] = VALADOC_API_NODE_TYPE_METHOD;
		_tmp78_[9] = VALADOC_API_NODE_TYPE_SIGNAL;
		_tmp78_[10] = VALADOC_API_NODE_TYPE_PROPERTY;
		_tmp78_[11] = VALADOC_API_NODE_TYPE_FIELD;
		_tmp78_[12] = VALADOC_API_NODE_TYPE_CONSTANT;
		_tmp79_ = _tmp78_;
		_tmp79__length1 = 13;
		_tmp80_ = valadoc_api_node_has_children (node, _tmp79_, 13);
		_tmp79_ = (g_free (_tmp79_), NULL);
		if (_tmp80_) {
			ValadocHtmlMarkupWriter* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			gchar** _tmp84_;
			gchar** _tmp85_;
			gint _tmp85__length1;
			ValadocMarkupWriter* _tmp86_;
			ValadocMarkupWriter* _tmp87_;
			ValadocMarkupWriter* _tmp88_;
			ValadocMarkupWriter* _tmp89_;
			ValadocMarkupWriter* _tmp90_;
			ValadocMarkupWriter* _tmp91_;
			_tmp81_ = self->writer;
			_tmp82_ = g_strdup ("class");
			_tmp83_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
			_tmp84_ = g_new0 (gchar*, 2 + 1);
			_tmp84_[0] = _tmp82_;
			_tmp84_[1] = _tmp83_;
			_tmp85_ = _tmp84_;
			_tmp85__length1 = 2;
			_tmp86_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp81_, "h2", _tmp85_, 2);
			_tmp87_ = _tmp86_;
			_tmp88_ = valadoc_markup_writer_text (_tmp87_, "Content:");
			_tmp89_ = _tmp88_;
			_tmp90_ = valadoc_markup_writer_end_tag (_tmp89_, "h2");
			_tmp91_ = _tmp90_;
			_valadoc_markup_writer_unref0 (_tmp91_);
			_valadoc_markup_writer_unref0 (_tmp89_);
			_valadoc_markup_writer_unref0 (_tmp87_);
			_tmp85_ = (_vala_array_free (_tmp85_, _tmp85__length1, (GDestroyNotify) g_free), NULL);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_ERROR_CODE, "Error codes", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_ENUM_VALUE, "Enum values", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_CLASS, "Classes", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_STRUCT, "Structs", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_ENUM, "Enums", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_PROPERTY, "Properties", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_STATIC_METHOD, "Static methods", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_CREATION_METHOD, "Creation methods", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_METHOD, "Methods", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_SIGNAL, "Signals", node);
			valadoc_html_basic_doclet_write_children (self, node, VALADOC_API_NODE_TYPE_FIELD, "Fields", node);
		}
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_CLASS)) {
		valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_CLASS, ValadocApiClass), node);
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_INTERFACE)) {
			valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface), node);
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (node, VALADOC_API_TYPE_STRUCT)) {
				valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (self, G_TYPE_CHECK_INSTANCE_CAST (node, VALADOC_API_TYPE_STRUCT, ValadocApiStruct), node);
			}
		}
	}
	_tmp92_ = self->writer;
	_tmp93_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp92_, "div");
	_tmp94_ = _tmp93_;
	_valadoc_markup_writer_unref0 (_tmp94_);
}


static inline gboolean
valadoc_html_basic_doclet_has_visible_inheritable_children (ValadocHtmlBasicDoclet* self,
                                                            ValadocApiTypeSymbol* symbol)
{
	gboolean result = FALSE;
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	ValadocSettings* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (symbol != NULL, FALSE);
	_tmp0_ = valadoc_html_basic_doclet_inheritable_members;
	_tmp0__length1 = valadoc_html_basic_doclet_inheritable_members_length1;
	_tmp1_ = self->priv->_settings;
	result = valadoc_api_node_has_visible_children_by_types ((ValadocApiNode*) symbol, _tmp0_, _tmp0__length1, _tmp1_);
	return result;
}


static void
valadoc_html_basic_doclet_write_inherited_members_headline (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocMarkupWriter* _tmp7_;
	ValadocMarkupWriter* _tmp8_;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "h3", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_tmp7_ = valadoc_markup_writer_text (_tmp6_, "Inherited Members:");
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_markup_writer_end_tag (_tmp8_, "h3");
	_tmp10_ = _tmp9_;
	_valadoc_markup_writer_unref0 (_tmp10_);
	_valadoc_markup_writer_unref0 (_tmp8_);
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
}


static void
valadoc_html_basic_doclet_write_inherited_symbols_note_for_class (ValadocHtmlBasicDoclet* self,
                                                                  ValadocApiClass* cl,
                                                                  ValadocApiNode* container)
{
	gboolean headline_printed = FALSE;
	ValadocApiClass* base_class = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiClass* _tmp3_;
	ValaCollection* printed_interfaces = NULL;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	g_return_if_fail (container != NULL);
	headline_printed = FALSE;
	_tmp0_ = valadoc_api_class_get_base_type (cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	base_class = _tmp3_;
	while (TRUE) {
		ValadocApiClass* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		ValadocApiClass* _tmp8_;
		ValadocApiClass* _tmp9_;
		ValadocApiTypeReference* _tmp10_;
		ValadocApiTypeReference* _tmp11_;
		ValadocApiTypeSymbol* _tmp12_;
		ValadocApiClass* _tmp13_;
		_tmp4_ = base_class;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp6_ = headline_printed;
		if (!_tmp6_) {
			ValadocApiClass* _tmp7_;
			_tmp7_ = base_class;
			_tmp5_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			valadoc_html_basic_doclet_write_inherited_members_headline (self);
			headline_printed = TRUE;
		}
		_tmp8_ = base_class;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp8_, "class", container);
		_tmp9_ = base_class;
		_tmp10_ = valadoc_api_class_get_base_type (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp11_);
		_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp12_) : NULL;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (_tmp12_);
		}
		_g_object_unref0 (base_class);
		base_class = _tmp13_;
	}
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp14_);
	printed_interfaces = (ValaCollection*) _tmp15_;
	{
		ValaIterator* _iface_ref_it = NULL;
		ValaCollection* _tmp16_;
		ValaCollection* _tmp17_;
		ValaIterator* _tmp18_;
		ValaIterator* _tmp19_;
		_tmp16_ = valadoc_api_class_get_full_implemented_interface_list (cl);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_iterable_iterator ((ValaIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_vala_iterable_unref0 (_tmp17_);
		_iface_ref_it = _tmp19_;
		while (TRUE) {
			ValaIterator* _tmp20_;
			ValadocApiTypeReference* iface_ref = NULL;
			ValaIterator* _tmp21_;
			gpointer _tmp22_;
			ValadocApiInterface* iface = NULL;
			ValadocApiTypeReference* _tmp23_;
			ValadocApiTypeSymbol* _tmp24_;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_;
			ValadocApiInterface* _tmp30_;
			ValaCollection* _tmp31_;
			ValadocApiInterface* _tmp32_;
			_tmp20_ = _iface_ref_it;
			if (!vala_iterator_next (_tmp20_)) {
				break;
			}
			_tmp21_ = _iface_ref_it;
			_tmp22_ = vala_iterator_get (_tmp21_);
			iface_ref = (ValadocApiTypeReference*) _tmp22_;
			_tmp23_ = iface_ref;
			_tmp24_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp23_);
			iface = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
			_tmp26_ = headline_printed;
			if (!_tmp26_) {
				ValadocApiInterface* _tmp27_;
				_tmp27_ = iface;
				_tmp25_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp27_);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				valadoc_html_basic_doclet_write_inherited_members_headline (self);
				headline_printed = TRUE;
			} else {
				ValaCollection* _tmp28_;
				ValadocApiInterface* _tmp29_;
				_tmp28_ = printed_interfaces;
				_tmp29_ = iface;
				if (vala_collection_contains (_tmp28_, _tmp29_)) {
					_g_object_unref0 (iface);
					_g_object_unref0 (iface_ref);
					continue;
				}
			}
			_tmp30_ = iface;
			valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp30_, "interface", container);
			_tmp31_ = printed_interfaces;
			_tmp32_ = iface;
			vala_collection_add (_tmp31_, _tmp32_);
			_g_object_unref0 (iface);
			_g_object_unref0 (iface_ref);
		}
		_vala_iterator_unref0 (_iface_ref_it);
	}
	_vala_iterable_unref0 (printed_interfaces);
	_g_object_unref0 (base_class);
}


static void
valadoc_html_basic_doclet_write_inherited_symbols_note_for_interface (ValadocHtmlBasicDoclet* self,
                                                                      ValadocApiInterface* iface,
                                                                      ValadocApiNode* container)
{
	gboolean headline_printed = FALSE;
	ValadocApiClass* base_class = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiClass* _tmp3_;
	ValaCollection* printed_interfaces = NULL;
	GEqualFunc _tmp14_;
	ValaArrayList* _tmp15_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (container != NULL);
	headline_printed = FALSE;
	_tmp0_ = valadoc_api_interface_get_base_type (iface);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	base_class = _tmp3_;
	while (TRUE) {
		ValadocApiClass* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		ValadocApiClass* _tmp8_;
		ValadocApiClass* _tmp9_;
		ValadocApiTypeReference* _tmp10_;
		ValadocApiTypeReference* _tmp11_;
		ValadocApiTypeSymbol* _tmp12_;
		ValadocApiClass* _tmp13_;
		_tmp4_ = base_class;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		_tmp6_ = headline_printed;
		if (!_tmp6_) {
			ValadocApiClass* _tmp7_;
			_tmp7_ = base_class;
			_tmp5_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			valadoc_html_basic_doclet_write_inherited_members_headline (self);
			headline_printed = TRUE;
		}
		_tmp8_ = base_class;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp8_, "class", container);
		_tmp9_ = base_class;
		_tmp10_ = valadoc_api_class_get_base_type (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp11_);
		_tmp13_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALADOC_API_TYPE_CLASS) ? ((ValadocApiClass*) _tmp12_) : NULL;
		if (_tmp13_ == NULL) {
			_g_object_unref0 (_tmp12_);
		}
		_g_object_unref0 (base_class);
		base_class = _tmp13_;
	}
	_tmp14_ = g_direct_equal;
	_tmp15_ = vala_array_list_new (VALADOC_API_TYPE_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp14_);
	printed_interfaces = (ValaCollection*) _tmp15_;
	{
		ValaIterator* _pre_ref_it = NULL;
		ValaCollection* _tmp16_;
		ValaCollection* _tmp17_;
		ValaIterator* _tmp18_;
		ValaIterator* _tmp19_;
		_tmp16_ = valadoc_api_interface_get_full_implemented_interface_list (iface);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_iterable_iterator ((ValaIterable*) _tmp17_);
		_tmp19_ = _tmp18_;
		_vala_iterable_unref0 (_tmp17_);
		_pre_ref_it = _tmp19_;
		while (TRUE) {
			ValaIterator* _tmp20_;
			ValadocApiTypeReference* pre_ref = NULL;
			ValaIterator* _tmp21_;
			gpointer _tmp22_;
			ValadocApiInterface* pre = NULL;
			ValadocApiTypeReference* _tmp23_;
			ValadocApiTypeSymbol* _tmp24_;
			gboolean _tmp25_ = FALSE;
			gboolean _tmp26_;
			ValadocApiInterface* _tmp30_;
			ValaCollection* _tmp31_;
			ValadocApiInterface* _tmp32_;
			_tmp20_ = _pre_ref_it;
			if (!vala_iterator_next (_tmp20_)) {
				break;
			}
			_tmp21_ = _pre_ref_it;
			_tmp22_ = vala_iterator_get (_tmp21_);
			pre_ref = (ValadocApiTypeReference*) _tmp22_;
			_tmp23_ = pre_ref;
			_tmp24_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp23_);
			pre = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, VALADOC_API_TYPE_INTERFACE, ValadocApiInterface);
			_tmp26_ = headline_printed;
			if (!_tmp26_) {
				ValadocApiInterface* _tmp27_;
				_tmp27_ = pre;
				_tmp25_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp27_);
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				valadoc_html_basic_doclet_write_inherited_members_headline (self);
				headline_printed = TRUE;
			} else {
				ValaCollection* _tmp28_;
				ValadocApiInterface* _tmp29_;
				_tmp28_ = printed_interfaces;
				_tmp29_ = pre;
				if (vala_collection_contains (_tmp28_, _tmp29_)) {
					_g_object_unref0 (pre);
					_g_object_unref0 (pre_ref);
					continue;
				}
			}
			_tmp30_ = pre;
			valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp30_, "interface", container);
			_tmp31_ = printed_interfaces;
			_tmp32_ = pre;
			vala_collection_add (_tmp31_, _tmp32_);
			_g_object_unref0 (pre);
			_g_object_unref0 (pre_ref);
		}
		_vala_iterator_unref0 (_pre_ref_it);
	}
	_vala_iterable_unref0 (printed_interfaces);
	_g_object_unref0 (base_class);
}


static void
valadoc_html_basic_doclet_write_inherited_symbols_note_for_struct (ValadocHtmlBasicDoclet* self,
                                                                   ValadocApiStruct* str,
                                                                   ValadocApiNode* container)
{
	ValadocApiStruct* base_struct = NULL;
	ValadocApiTypeReference* _tmp0_;
	ValadocApiTypeReference* _tmp1_;
	ValadocApiTypeSymbol* _tmp2_;
	ValadocApiStruct* _tmp3_;
	gboolean _tmp4_ = FALSE;
	ValadocApiStruct* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (str != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = valadoc_api_struct_get_base_type (str);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_html_basic_doclet_unpack_type_reference (self, _tmp1_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALADOC_API_TYPE_STRUCT) ? ((ValadocApiStruct*) _tmp2_) : NULL;
	if (_tmp3_ == NULL) {
		_g_object_unref0 (_tmp2_);
	}
	base_struct = _tmp3_;
	_tmp5_ = base_struct;
	if (_tmp5_ != NULL) {
		ValadocApiStruct* _tmp6_;
		_tmp6_ = base_struct;
		_tmp4_ = valadoc_html_basic_doclet_has_visible_inheritable_children (self, (ValadocApiTypeSymbol*) _tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		ValadocApiStruct* _tmp7_;
		valadoc_html_basic_doclet_write_inherited_members_headline (self);
		_tmp7_ = base_struct;
		valadoc_html_basic_doclet_write_inherited_symbols_note (self, (ValadocApiTypeSymbol*) _tmp7_, "struct", container);
	}
	_g_object_unref0 (base_struct);
}


static void
valadoc_html_basic_doclet_write_inherited_symbols_note (ValadocHtmlBasicDoclet* self,
                                                        ValadocApiTypeSymbol* symbol,
                                                        const gchar* type,
                                                        ValadocApiNode* container)
{
	ValadocApiNodeType* _tmp0_;
	gint _tmp0__length1;
	ValaList* _tmp1_;
	ValaList* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (symbol != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (container != NULL);
	_tmp0_ = valadoc_html_basic_doclet_inheritable_members;
	_tmp0__length1 = valadoc_html_basic_doclet_inheritable_members_length1;
	_tmp1_ = valadoc_api_node_get_children_by_types ((ValadocApiNode*) symbol, _tmp0_, _tmp0__length1, FALSE);
	_tmp2_ = _tmp1_;
	_tmp3_ = valadoc_api_node_get_full_name ((ValadocApiNode*) symbol);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strdup_printf ("All known members inherited from %s %s", type, _tmp4_);
	_tmp6_ = _tmp5_;
	valadoc_html_basic_doclet_write_known_symbols_note (self, (ValaCollection*) _tmp2_, container, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_vala_iterable_unref0 (_tmp2_);
}


void
valadoc_html_basic_doclet_write_child_namespaces (ValadocHtmlBasicDoclet* self,
                                                  ValadocApiNode* node,
                                                  ValadocApiNode* parent)
{
	ValaArrayList* namespaces = NULL;
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	ValaArrayList* _tmp2_;
	ValaArrayList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	ValaArrayList* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	gboolean _tmp15_ = FALSE;
	gboolean with_childs = FALSE;
	ValadocHtmlMarkupWriter* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocMarkupWriter* _tmp25_;
	ValadocMarkupWriter* _tmp26_;
	ValadocHtmlMarkupWriter* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar** _tmp30_;
	gchar** _tmp31_;
	gint _tmp31__length1;
	ValadocMarkupWriter* _tmp32_;
	ValadocMarkupWriter* _tmp33_;
	ValadocHtmlMarkupWriter* _tmp84_;
	ValadocMarkupWriter* _tmp85_;
	ValadocMarkupWriter* _tmp86_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALADOC_API_TYPE_NAMESPACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp0_);
	namespaces = _tmp1_;
	_tmp2_ = namespaces;
	valadoc_html_basic_doclet_fetch_subnamespace_names (self, node, _tmp2_);
	_tmp3_ = namespaces;
	_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == 0) {
		_vala_iterable_unref0 (namespaces);
		return;
	}
	_tmp6_ = namespaces;
	_tmp7_ = vala_collection_get_size ((ValaCollection*) _tmp6_);
	_tmp8_ = _tmp7_;
	if (_tmp8_ == 1) {
		ValaArrayList* _tmp9_;
		gpointer _tmp10_;
		ValadocApiNamespace* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gboolean _tmp14_;
		_tmp9_ = namespaces;
		_tmp10_ = vala_list_get ((ValaList*) _tmp9_, 0);
		_tmp11_ = (ValadocApiNamespace*) _tmp10_;
		_tmp12_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_ == NULL;
		_g_object_unref0 (_tmp11_);
		if (_tmp14_) {
			_vala_iterable_unref0 (namespaces);
			return;
		}
	}
	if (parent != NULL) {
		_tmp15_ = G_TYPE_CHECK_INSTANCE_TYPE (parent, VALADOC_API_TYPE_PACKAGE);
	} else {
		_tmp15_ = FALSE;
	}
	with_childs = _tmp15_;
	_tmp16_ = self->writer;
	_tmp17_ = g_strdup ("class");
	_tmp18_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp19_ = g_new0 (gchar*, 2 + 1);
	_tmp19_[0] = _tmp17_;
	_tmp19_[1] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 2;
	_tmp21_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp16_, "h3", _tmp20_, 2);
	_tmp22_ = _tmp21_;
	_tmp23_ = valadoc_markup_writer_text (_tmp22_, "Namespaces:");
	_tmp24_ = _tmp23_;
	_tmp25_ = valadoc_markup_writer_end_tag (_tmp24_, "h3");
	_tmp26_ = _tmp25_;
	_valadoc_markup_writer_unref0 (_tmp26_);
	_valadoc_markup_writer_unref0 (_tmp24_);
	_valadoc_markup_writer_unref0 (_tmp22_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_tmp27_ = self->writer;
	_tmp28_ = g_strdup ("class");
	_tmp29_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
	_tmp30_ = g_new0 (gchar*, 2 + 1);
	_tmp30_[0] = _tmp28_;
	_tmp30_[1] = _tmp29_;
	_tmp31_ = _tmp30_;
	_tmp31__length1 = 2;
	_tmp32_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp27_, "ul", _tmp31_, 2);
	_tmp33_ = _tmp32_;
	_valadoc_markup_writer_unref0 (_tmp33_);
	_tmp31_ = (_vala_array_free (_tmp31_, _tmp31__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaArrayList* _child_list = NULL;
		ValaArrayList* _tmp34_;
		ValaArrayList* _tmp35_;
		gint _child_size = 0;
		ValaArrayList* _tmp36_;
		gint _tmp37_;
		gint _tmp38_;
		gint _child_index = 0;
		_tmp34_ = namespaces;
		_tmp35_ = _vala_iterable_ref0 (_tmp34_);
		_child_list = _tmp35_;
		_tmp36_ = _child_list;
		_tmp37_ = vala_collection_get_size ((ValaCollection*) _tmp36_);
		_tmp38_ = _tmp37_;
		_child_size = _tmp38_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp39_;
			gint _tmp40_;
			gint _tmp41_;
			ValadocApiNamespace* child = NULL;
			ValaArrayList* _tmp42_;
			gint _tmp43_;
			gpointer _tmp44_;
			ValadocApiNamespace* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			_tmp39_ = _child_index;
			_child_index = _tmp39_ + 1;
			_tmp40_ = _child_index;
			_tmp41_ = _child_size;
			if (!(_tmp40_ < _tmp41_)) {
				break;
			}
			_tmp42_ = _child_list;
			_tmp43_ = _child_index;
			_tmp44_ = vala_list_get ((ValaList*) _tmp42_, _tmp43_);
			child = (ValadocApiNamespace*) _tmp44_;
			_tmp45_ = child;
			_tmp46_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp45_);
			_tmp47_ = _tmp46_;
			if (_tmp47_ != NULL) {
				ValadocHtmlMarkupWriter* _tmp48_;
				gchar* _tmp49_;
				ValadocHtmlCssClassResolver* _tmp50_;
				ValadocApiNamespace* _tmp51_;
				gchar* _tmp52_;
				gchar** _tmp53_;
				gchar** _tmp54_;
				gint _tmp54__length1;
				ValadocMarkupWriter* _tmp55_;
				ValadocMarkupWriter* _tmp56_;
				ValadocHtmlMarkupWriter* _tmp57_;
				ValadocApiNamespace* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				ValadocApiNamespace* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				ValadocHtmlMarkupWriter* _tmp64_;
				ValadocHtmlMarkupWriter* _tmp65_;
				ValadocApiNamespace* _tmp66_;
				ValadocHtmlMarkupWriter* _tmp71_;
				ValadocMarkupWriter* _tmp72_;
				ValadocMarkupWriter* _tmp73_;
				gboolean _tmp74_;
				_tmp48_ = self->writer;
				_tmp49_ = g_strdup ("class");
				_tmp50_ = self->cssresolver;
				_tmp51_ = child;
				_tmp52_ = valadoc_html_css_class_resolver_resolve (_tmp50_, (ValadocApiNode*) _tmp51_);
				_tmp53_ = g_new0 (gchar*, 2 + 1);
				_tmp53_[0] = _tmp49_;
				_tmp53_[1] = _tmp52_;
				_tmp54_ = _tmp53_;
				_tmp54__length1 = 2;
				_tmp55_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp48_, "li", _tmp54_, 2);
				_tmp56_ = _tmp55_;
				_valadoc_markup_writer_unref0 (_tmp56_);
				_tmp54_ = (_vala_array_free (_tmp54_, _tmp54__length1, (GDestroyNotify) g_free), NULL);
				_tmp57_ = self->writer;
				_tmp58_ = child;
				_tmp59_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp58_, parent);
				_tmp60_ = _tmp59_;
				_tmp61_ = child;
				_tmp62_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = valadoc_html_markup_writer_link (_tmp57_, _tmp60_, _tmp63_, NULL);
				_tmp65_ = _tmp64_;
				_valadoc_markup_writer_unref0 (_tmp65_);
				_g_free0 (_tmp60_);
				_tmp66_ = child;
				if (valadoc_html_basic_doclet_has_brief_description (self, (ValadocApiNode*) _tmp66_)) {
					ValadocHtmlMarkupWriter* _tmp67_;
					ValadocMarkupWriter* _tmp68_;
					ValadocMarkupWriter* _tmp69_;
					ValadocApiNamespace* _tmp70_;
					_tmp67_ = self->writer;
					_tmp68_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp67_, " - ");
					_tmp69_ = _tmp68_;
					_valadoc_markup_writer_unref0 (_tmp69_);
					_tmp70_ = child;
					valadoc_html_basic_doclet_write_brief_description (self, (ValadocApiNode*) _tmp70_, parent);
				}
				_tmp71_ = self->writer;
				_tmp72_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp71_, "li");
				_tmp73_ = _tmp72_;
				_valadoc_markup_writer_unref0 (_tmp73_);
				_tmp74_ = with_childs;
				if (_tmp74_ == TRUE) {
					ValadocApiNamespace* _tmp75_;
					ValadocApiNamespace* _tmp76_;
					ValadocApiNamespace* _tmp77_;
					ValadocApiNamespace* _tmp78_;
					ValadocApiNamespace* _tmp79_;
					ValadocApiNamespace* _tmp80_;
					ValadocApiNamespace* _tmp81_;
					ValadocApiNamespace* _tmp82_;
					ValadocApiNamespace* _tmp83_;
					_tmp75_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp75_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", parent);
					_tmp76_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp76_, VALADOC_API_NODE_TYPE_CLASS, "Classes", parent);
					_tmp77_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp77_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", parent);
					_tmp78_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp78_, VALADOC_API_NODE_TYPE_ENUM, "Enums", parent);
					_tmp79_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp79_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", parent);
					_tmp80_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp80_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", parent);
					_tmp81_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp81_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", parent);
					_tmp82_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp82_, VALADOC_API_NODE_TYPE_METHOD, "Methods", parent);
					_tmp83_ = child;
					valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) _tmp83_, VALADOC_API_NODE_TYPE_FIELD, "Fields", parent);
				}
			}
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	_tmp84_ = self->writer;
	_tmp85_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp84_, "ul");
	_tmp86_ = _tmp85_;
	_valadoc_markup_writer_unref0 (_tmp86_);
	_vala_iterable_unref0 (namespaces);
}


void
valadoc_html_basic_doclet_write_child_dependencies (ValadocHtmlBasicDoclet* self,
                                                    ValadocApiPackage* package,
                                                    ValadocApiNode* parent)
{
	ValaCollection* deps = NULL;
	ValaCollection* _tmp0_;
	ValaCollection* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	ValadocHtmlMarkupWriter* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	ValadocMarkupWriter* _tmp9_;
	ValadocMarkupWriter* _tmp10_;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocHtmlMarkupWriter* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar** _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocHtmlMarkupWriter* _tmp72_;
	ValadocMarkupWriter* _tmp73_;
	ValadocMarkupWriter* _tmp74_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (package != NULL);
	_tmp0_ = valadoc_api_package_get_full_dependency_list (package);
	deps = _tmp0_;
	_tmp1_ = deps;
	_tmp2_ = vala_collection_get_size (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == 0) {
		_vala_iterable_unref0 (deps);
		return;
	}
	_tmp4_ = self->writer;
	_tmp5_ = g_strdup ("class");
	_tmp6_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp7_ = g_new0 (gchar*, 2 + 1);
	_tmp7_[0] = _tmp5_;
	_tmp7_[1] = _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	_tmp9_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp4_, "h2", _tmp8_, 2);
	_tmp10_ = _tmp9_;
	_tmp11_ = valadoc_markup_writer_text (_tmp10_, "Dependencies:");
	_tmp12_ = _tmp11_;
	_tmp13_ = valadoc_markup_writer_end_tag (_tmp12_, "h2");
	_tmp14_ = _tmp13_;
	_valadoc_markup_writer_unref0 (_tmp14_);
	_valadoc_markup_writer_unref0 (_tmp12_);
	_valadoc_markup_writer_unref0 (_tmp10_);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp15_ = self->writer;
	_tmp16_ = g_strdup ("class");
	_tmp17_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
	_tmp18_ = g_new0 (gchar*, 2 + 1);
	_tmp18_[0] = _tmp16_;
	_tmp18_[1] = _tmp17_;
	_tmp19_ = _tmp18_;
	_tmp19__length1 = 2;
	_tmp20_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp15_, "ul", _tmp19_, 2);
	_tmp21_ = _tmp20_;
	_valadoc_markup_writer_unref0 (_tmp21_);
	_tmp19_ = (_vala_array_free (_tmp19_, _tmp19__length1, (GDestroyNotify) g_free), NULL);
	{
		ValaIterator* _p_it = NULL;
		ValaCollection* _tmp22_;
		ValaIterator* _tmp23_;
		_tmp22_ = deps;
		_tmp23_ = vala_iterable_iterator ((ValaIterable*) _tmp22_);
		_p_it = _tmp23_;
		while (TRUE) {
			ValaIterator* _tmp24_;
			ValadocApiPackage* p = NULL;
			ValaIterator* _tmp25_;
			gpointer _tmp26_;
			gchar* link = NULL;
			ValadocApiPackage* _tmp27_;
			gchar* _tmp28_;
			const gchar* _tmp29_;
			_tmp24_ = _p_it;
			if (!vala_iterator_next (_tmp24_)) {
				break;
			}
			_tmp25_ = _p_it;
			_tmp26_ = vala_iterator_get (_tmp25_);
			p = (ValadocApiPackage*) _tmp26_;
			_tmp27_ = p;
			_tmp28_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp27_, parent);
			link = _tmp28_;
			_tmp29_ = link;
			if (_tmp29_ == NULL) {
				ValadocHtmlMarkupWriter* _tmp30_;
				gchar* _tmp31_;
				ValadocHtmlCssClassResolver* _tmp32_;
				ValadocApiPackage* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				ValadocApiPackage* _tmp36_;
				const gchar* _tmp37_;
				const gchar* _tmp38_;
				gchar* _tmp39_;
				gchar** _tmp40_;
				gchar** _tmp41_;
				gint _tmp41__length1;
				ValadocMarkupWriter* _tmp42_;
				ValadocMarkupWriter* _tmp43_;
				ValadocApiPackage* _tmp44_;
				const gchar* _tmp45_;
				const gchar* _tmp46_;
				ValadocMarkupWriter* _tmp47_;
				ValadocMarkupWriter* _tmp48_;
				ValadocMarkupWriter* _tmp49_;
				ValadocMarkupWriter* _tmp50_;
				_tmp30_ = self->writer;
				_tmp31_ = g_strdup ("class");
				_tmp32_ = self->cssresolver;
				_tmp33_ = p;
				_tmp34_ = valadoc_html_css_class_resolver_resolve (_tmp32_, (ValadocApiNode*) _tmp33_);
				_tmp35_ = g_strdup ("id");
				_tmp36_ = p;
				_tmp37_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = g_strdup (_tmp38_);
				_tmp40_ = g_new0 (gchar*, 4 + 1);
				_tmp40_[0] = _tmp31_;
				_tmp40_[1] = _tmp34_;
				_tmp40_[2] = _tmp35_;
				_tmp40_[3] = _tmp39_;
				_tmp41_ = _tmp40_;
				_tmp41__length1 = 4;
				_tmp42_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp30_, "li", _tmp41_, 4);
				_tmp43_ = _tmp42_;
				_tmp44_ = p;
				_tmp45_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp44_);
				_tmp46_ = _tmp45_;
				_tmp47_ = valadoc_markup_writer_text (_tmp43_, _tmp46_);
				_tmp48_ = _tmp47_;
				_tmp49_ = valadoc_markup_writer_end_tag (_tmp48_, "li");
				_tmp50_ = _tmp49_;
				_valadoc_markup_writer_unref0 (_tmp50_);
				_valadoc_markup_writer_unref0 (_tmp48_);
				_valadoc_markup_writer_unref0 (_tmp43_);
				_tmp41_ = (_vala_array_free (_tmp41_, _tmp41__length1, (GDestroyNotify) g_free), NULL);
			} else {
				ValadocHtmlMarkupWriter* _tmp51_;
				gchar* _tmp52_;
				ValadocHtmlCssClassResolver* _tmp53_;
				ValadocApiPackage* _tmp54_;
				gchar* _tmp55_;
				gchar** _tmp56_;
				gchar** _tmp57_;
				gint _tmp57__length1;
				ValadocMarkupWriter* _tmp58_;
				ValadocMarkupWriter* _tmp59_;
				ValadocHtmlMarkupWriter* _tmp60_;
				ValadocApiPackage* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				ValadocApiPackage* _tmp64_;
				const gchar* _tmp65_;
				const gchar* _tmp66_;
				ValadocHtmlMarkupWriter* _tmp67_;
				ValadocHtmlMarkupWriter* _tmp68_;
				ValadocHtmlMarkupWriter* _tmp69_;
				ValadocMarkupWriter* _tmp70_;
				ValadocMarkupWriter* _tmp71_;
				_tmp51_ = self->writer;
				_tmp52_ = g_strdup ("class");
				_tmp53_ = self->cssresolver;
				_tmp54_ = p;
				_tmp55_ = valadoc_html_css_class_resolver_resolve (_tmp53_, (ValadocApiNode*) _tmp54_);
				_tmp56_ = g_new0 (gchar*, 2 + 1);
				_tmp56_[0] = _tmp52_;
				_tmp56_[1] = _tmp55_;
				_tmp57_ = _tmp56_;
				_tmp57__length1 = 2;
				_tmp58_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp51_, "li", _tmp57_, 2);
				_tmp59_ = _tmp58_;
				_valadoc_markup_writer_unref0 (_tmp59_);
				_tmp57_ = (_vala_array_free (_tmp57_, _tmp57__length1, (GDestroyNotify) g_free), NULL);
				_tmp60_ = self->writer;
				_tmp61_ = p;
				_tmp62_ = valadoc_html_basic_doclet_get_link (self, (ValadocApiNode*) _tmp61_, parent);
				_tmp63_ = _tmp62_;
				_tmp64_ = p;
				_tmp65_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = valadoc_html_markup_writer_link (_tmp60_, _tmp63_, _tmp66_, NULL);
				_tmp68_ = _tmp67_;
				_valadoc_markup_writer_unref0 (_tmp68_);
				_g_free0 (_tmp63_);
				_tmp69_ = self->writer;
				_tmp70_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp69_, "li");
				_tmp71_ = _tmp70_;
				_valadoc_markup_writer_unref0 (_tmp71_);
			}
			_g_free0 (link);
			_g_object_unref0 (p);
		}
		_vala_iterator_unref0 (_p_it);
	}
	_tmp72_ = self->writer;
	_tmp73_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp72_, "ul");
	_tmp74_ = _tmp73_;
	_valadoc_markup_writer_unref0 (_tmp74_);
	_vala_iterable_unref0 (deps);
}


void
valadoc_html_basic_doclet_write_children (ValadocHtmlBasicDoclet* self,
                                          ValadocApiNode* node,
                                          ValadocApiNodeType type,
                                          const gchar* type_string,
                                          ValadocApiNode* container)
{
	ValaList* children = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (type_string != NULL);
	_tmp0_ = valadoc_api_node_get_children_by_type (node, type, TRUE);
	children = _tmp0_;
	_tmp1_ = children;
	_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		ValaList* _tmp4_;
		ValadocHtmlMarkupWriter* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar** _tmp8_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		ValadocMarkupWriter* _tmp10_;
		ValadocMarkupWriter* _tmp11_;
		ValadocMarkupWriter* _tmp12_;
		ValadocMarkupWriter* _tmp13_;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocMarkupWriter* _tmp16_;
		ValadocMarkupWriter* _tmp17_;
		ValadocHtmlMarkupWriter* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar** _tmp21_;
		gchar** _tmp22_;
		gint _tmp22__length1;
		ValadocMarkupWriter* _tmp23_;
		ValadocMarkupWriter* _tmp24_;
		ValadocHtmlMarkupWriter* _tmp125_;
		ValadocMarkupWriter* _tmp126_;
		ValadocMarkupWriter* _tmp127_;
		_tmp4_ = children;
		vala_list_sort (_tmp4_, (GCompareDataFunc) valadoc_api_node_compare_to, NULL, NULL);
		_tmp5_ = self->writer;
		_tmp6_ = g_strdup ("class");
		_tmp7_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
		_tmp8_ = g_new0 (gchar*, 2 + 1);
		_tmp8_[0] = _tmp6_;
		_tmp8_[1] = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp9__length1 = 2;
		_tmp10_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp5_, "h3", _tmp9_, 2);
		_tmp11_ = _tmp10_;
		_tmp12_ = valadoc_markup_writer_text (_tmp11_, type_string);
		_tmp13_ = _tmp12_;
		_tmp14_ = valadoc_markup_writer_text (_tmp13_, ":");
		_tmp15_ = _tmp14_;
		_tmp16_ = valadoc_markup_writer_end_tag (_tmp15_, "h3");
		_tmp17_ = _tmp16_;
		_valadoc_markup_writer_unref0 (_tmp17_);
		_valadoc_markup_writer_unref0 (_tmp15_);
		_valadoc_markup_writer_unref0 (_tmp13_);
		_valadoc_markup_writer_unref0 (_tmp11_);
		_tmp9_ = (_vala_array_free (_tmp9_, _tmp9__length1, (GDestroyNotify) g_free), NULL);
		_tmp18_ = self->writer;
		_tmp19_ = g_strdup ("class");
		_tmp20_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_inline_navigation);
		_tmp21_ = g_new0 (gchar*, 2 + 1);
		_tmp21_[0] = _tmp19_;
		_tmp21_[1] = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp22__length1 = 2;
		_tmp23_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp18_, "ul", _tmp22_, 2);
		_tmp24_ = _tmp23_;
		_valadoc_markup_writer_unref0 (_tmp24_);
		_tmp22_ = (_vala_array_free (_tmp22_, _tmp22__length1, (GDestroyNotify) g_free), NULL);
		{
			ValaList* _child_list = NULL;
			ValaList* _tmp25_;
			ValaList* _tmp26_;
			gint _child_size = 0;
			ValaList* _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			gint _child_index = 0;
			_tmp25_ = children;
			_tmp26_ = _vala_iterable_ref0 (_tmp25_);
			_child_list = _tmp26_;
			_tmp27_ = _child_list;
			_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
			_tmp29_ = _tmp28_;
			_child_size = _tmp29_;
			_child_index = -1;
			while (TRUE) {
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				ValadocApiNode* child = NULL;
				ValaList* _tmp33_;
				gint _tmp34_;
				gpointer _tmp35_;
				ValadocHtmlMarkupWriter* _tmp36_;
				gchar* _tmp37_;
				ValadocHtmlCssClassResolver* _tmp38_;
				ValadocApiNode* _tmp39_;
				gchar* _tmp40_;
				gchar** _tmp41_;
				gchar** _tmp42_;
				gint _tmp42__length1;
				ValadocMarkupWriter* _tmp43_;
				ValadocMarkupWriter* _tmp44_;
				ValadocApiNode* _tmp45_;
				ValadocHtmlMarkupWriter* _tmp122_;
				ValadocMarkupWriter* _tmp123_;
				ValadocMarkupWriter* _tmp124_;
				_tmp30_ = _child_index;
				_child_index = _tmp30_ + 1;
				_tmp31_ = _child_index;
				_tmp32_ = _child_size;
				if (!(_tmp31_ < _tmp32_)) {
					break;
				}
				_tmp33_ = _child_list;
				_tmp34_ = _child_index;
				_tmp35_ = vala_list_get (_tmp33_, _tmp34_);
				child = (ValadocApiNode*) _tmp35_;
				_tmp36_ = self->writer;
				_tmp37_ = g_strdup ("class");
				_tmp38_ = self->cssresolver;
				_tmp39_ = child;
				_tmp40_ = valadoc_html_css_class_resolver_resolve (_tmp38_, _tmp39_);
				_tmp41_ = g_new0 (gchar*, 2 + 1);
				_tmp41_[0] = _tmp37_;
				_tmp41_[1] = _tmp40_;
				_tmp42_ = _tmp41_;
				_tmp42__length1 = 2;
				_tmp43_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp36_, "li", _tmp42_, 2);
				_tmp44_ = _tmp43_;
				_valadoc_markup_writer_unref0 (_tmp44_);
				_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
				_tmp45_ = child;
				if (valadoc_html_basic_doclet_is_internal_node (self, _tmp45_)) {
					gboolean _tmp46_ = FALSE;
					ValadocApiNode* _tmp47_;
					ValadocApiNode* _tmp79_;
					_tmp47_ = child;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp47_, VALADOC_API_TYPE_SYMBOL)) {
						ValadocApiNode* _tmp48_;
						gboolean _tmp49_;
						gboolean _tmp50_;
						_tmp48_ = child;
						_tmp49_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
						_tmp50_ = _tmp49_;
						_tmp46_ = _tmp50_;
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						ValadocHtmlMarkupWriter* _tmp51_;
						gchar* _tmp52_;
						gchar* _tmp53_;
						gchar** _tmp54_;
						gchar** _tmp55_;
						gint _tmp55__length1;
						ValadocMarkupWriter* _tmp56_;
						ValadocMarkupWriter* _tmp57_;
						ValadocHtmlMarkupWriter* _tmp58_;
						ValadocApiNode* _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						ValadocApiNode* _tmp62_;
						const gchar* _tmp63_;
						const gchar* _tmp64_;
						ValadocHtmlMarkupWriter* _tmp65_;
						ValadocHtmlMarkupWriter* _tmp66_;
						ValadocHtmlMarkupWriter* _tmp67_;
						ValadocMarkupWriter* _tmp68_;
						ValadocMarkupWriter* _tmp69_;
						_tmp51_ = self->writer;
						_tmp52_ = g_strdup ("class");
						_tmp53_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
						_tmp54_ = g_new0 (gchar*, 2 + 1);
						_tmp54_[0] = _tmp52_;
						_tmp54_[1] = _tmp53_;
						_tmp55_ = _tmp54_;
						_tmp55__length1 = 2;
						_tmp56_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp51_, "span", _tmp55_, 2);
						_tmp57_ = _tmp56_;
						_valadoc_markup_writer_unref0 (_tmp57_);
						_tmp55_ = (_vala_array_free (_tmp55_, _tmp55__length1, (GDestroyNotify) g_free), NULL);
						_tmp58_ = self->writer;
						_tmp59_ = child;
						_tmp60_ = valadoc_html_basic_doclet_get_link (self, _tmp59_, container);
						_tmp61_ = _tmp60_;
						_tmp62_ = child;
						_tmp63_ = valadoc_api_node_get_name (_tmp62_);
						_tmp64_ = _tmp63_;
						_tmp65_ = valadoc_html_markup_writer_link (_tmp58_, _tmp61_, _tmp64_, NULL);
						_tmp66_ = _tmp65_;
						_valadoc_markup_writer_unref0 (_tmp66_);
						_g_free0 (_tmp61_);
						_tmp67_ = self->writer;
						_tmp68_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp67_, "span");
						_tmp69_ = _tmp68_;
						_valadoc_markup_writer_unref0 (_tmp69_);
					} else {
						ValadocHtmlMarkupWriter* _tmp70_;
						ValadocApiNode* _tmp71_;
						gchar* _tmp72_;
						gchar* _tmp73_;
						ValadocApiNode* _tmp74_;
						const gchar* _tmp75_;
						const gchar* _tmp76_;
						ValadocHtmlMarkupWriter* _tmp77_;
						ValadocHtmlMarkupWriter* _tmp78_;
						_tmp70_ = self->writer;
						_tmp71_ = child;
						_tmp72_ = valadoc_html_basic_doclet_get_link (self, _tmp71_, container);
						_tmp73_ = _tmp72_;
						_tmp74_ = child;
						_tmp75_ = valadoc_api_node_get_name (_tmp74_);
						_tmp76_ = _tmp75_;
						_tmp77_ = valadoc_html_markup_writer_link (_tmp70_, _tmp73_, _tmp76_, NULL);
						_tmp78_ = _tmp77_;
						_valadoc_markup_writer_unref0 (_tmp78_);
						_g_free0 (_tmp73_);
					}
					_tmp79_ = child;
					if (valadoc_html_basic_doclet_has_brief_description (self, _tmp79_)) {
						ValadocHtmlMarkupWriter* _tmp80_;
						ValadocMarkupWriter* _tmp81_;
						ValadocMarkupWriter* _tmp82_;
						ValadocApiNode* _tmp83_;
						_tmp80_ = self->writer;
						_tmp81_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp80_, " - ");
						_tmp82_ = _tmp81_;
						_valadoc_markup_writer_unref0 (_tmp82_);
						_tmp83_ = child;
						valadoc_html_basic_doclet_write_brief_description (self, _tmp83_, container);
					}
				} else {
					ValadocHtmlMarkupWriter* _tmp84_;
					gchar* _tmp85_;
					gchar* _tmp86_;
					gchar** _tmp87_;
					gchar** _tmp88_;
					gint _tmp88__length1;
					ValadocMarkupWriter* _tmp89_;
					ValadocMarkupWriter* _tmp90_;
					gboolean _tmp91_ = FALSE;
					ValadocApiNode* _tmp92_;
					ValadocHtmlMarkupWriter* _tmp108_;
					ValadocMarkupWriter* _tmp109_;
					ValadocMarkupWriter* _tmp110_;
					ValadocHtmlMarkupWriter* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					gchar** _tmp114_;
					gchar** _tmp115_;
					gint _tmp115__length1;
					ValadocMarkupWriter* _tmp116_;
					ValadocMarkupWriter* _tmp117_;
					ValadocApiNode* _tmp118_;
					ValadocHtmlMarkupWriter* _tmp119_;
					ValadocMarkupWriter* _tmp120_;
					ValadocMarkupWriter* _tmp121_;
					_tmp84_ = self->writer;
					_tmp85_ = g_strdup ("class");
					_tmp86_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_leaf_code_definition);
					_tmp87_ = g_new0 (gchar*, 2 + 1);
					_tmp87_[0] = _tmp85_;
					_tmp87_[1] = _tmp86_;
					_tmp88_ = _tmp87_;
					_tmp88__length1 = 2;
					_tmp89_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp84_, "span", _tmp88_, 2);
					_tmp90_ = _tmp89_;
					_valadoc_markup_writer_unref0 (_tmp90_);
					_tmp88_ = (_vala_array_free (_tmp88_, _tmp88__length1, (GDestroyNotify) g_free), NULL);
					_tmp92_ = child;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp92_, VALADOC_API_TYPE_SYMBOL)) {
						ValadocApiNode* _tmp93_;
						gboolean _tmp94_;
						gboolean _tmp95_;
						_tmp93_ = child;
						_tmp94_ = valadoc_api_symbol_get_is_deprecated (G_TYPE_CHECK_INSTANCE_CAST (_tmp93_, VALADOC_API_TYPE_SYMBOL, ValadocApiSymbol));
						_tmp95_ = _tmp94_;
						_tmp91_ = _tmp95_;
					} else {
						_tmp91_ = FALSE;
					}
					if (_tmp91_) {
						ValadocHtmlMarkupWriter* _tmp96_;
						gchar* _tmp97_;
						gchar* _tmp98_;
						gchar** _tmp99_;
						gchar** _tmp100_;
						gint _tmp100__length1;
						ValadocMarkupWriter* _tmp101_;
						ValadocMarkupWriter* _tmp102_;
						ValadocApiNode* _tmp103_;
						ValadocHtmlMarkupWriter* _tmp104_;
						ValadocMarkupWriter* _tmp105_;
						ValadocMarkupWriter* _tmp106_;
						_tmp96_ = self->writer;
						_tmp97_ = g_strdup ("class");
						_tmp98_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_deprecated);
						_tmp99_ = g_new0 (gchar*, 2 + 1);
						_tmp99_[0] = _tmp97_;
						_tmp99_[1] = _tmp98_;
						_tmp100_ = _tmp99_;
						_tmp100__length1 = 2;
						_tmp101_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp96_, "span", _tmp100_, 2);
						_tmp102_ = _tmp101_;
						_valadoc_markup_writer_unref0 (_tmp102_);
						_tmp100_ = (_vala_array_free (_tmp100_, _tmp100__length1, (GDestroyNotify) g_free), NULL);
						_tmp103_ = child;
						valadoc_html_basic_doclet_write_signature (self, _tmp103_, container);
						_tmp104_ = self->writer;
						_tmp105_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp104_, "span");
						_tmp106_ = _tmp105_;
						_valadoc_markup_writer_unref0 (_tmp106_);
					} else {
						ValadocApiNode* _tmp107_;
						_tmp107_ = child;
						valadoc_html_basic_doclet_write_signature (self, _tmp107_, container);
					}
					_tmp108_ = self->writer;
					_tmp109_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp108_, "span");
					_tmp110_ = _tmp109_;
					_valadoc_markup_writer_unref0 (_tmp110_);
					_tmp111_ = self->writer;
					_tmp112_ = g_strdup ("class");
					_tmp113_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_leaf_brief_description);
					_tmp114_ = g_new0 (gchar*, 2 + 1);
					_tmp114_[0] = _tmp112_;
					_tmp114_[1] = _tmp113_;
					_tmp115_ = _tmp114_;
					_tmp115__length1 = 2;
					_tmp116_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp111_, "div", _tmp115_, 2);
					_tmp117_ = _tmp116_;
					_valadoc_markup_writer_unref0 (_tmp117_);
					_tmp115_ = (_vala_array_free (_tmp115_, _tmp115__length1, (GDestroyNotify) g_free), NULL);
					_tmp118_ = child;
					valadoc_html_basic_doclet_write_brief_description (self, _tmp118_, container);
					_tmp119_ = self->writer;
					_tmp120_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp119_, "div");
					_tmp121_ = _tmp120_;
					_valadoc_markup_writer_unref0 (_tmp121_);
				}
				_tmp122_ = self->writer;
				_tmp123_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp122_, "li");
				_tmp124_ = _tmp123_;
				_valadoc_markup_writer_unref0 (_tmp124_);
				_g_object_unref0 (child);
			}
			_vala_iterable_unref0 (_child_list);
		}
		_tmp125_ = self->writer;
		_tmp126_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp125_, "ul");
		_tmp127_ = _tmp126_;
		_valadoc_markup_writer_unref0 (_tmp127_);
	}
	_vala_iterable_unref0 (children);
}


void
valadoc_html_basic_doclet_write_image_block (ValadocHtmlBasicDoclet* self,
                                             ValadocApiNode* element)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (element != NULL);
	if (G_TYPE_CHECK_INSTANCE_TYPE (element, VALADOC_API_TYPE_CLASS)) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (element, VALADOC_API_TYPE_INTERFACE);
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (element, VALADOC_API_TYPE_STRUCT);
	}
	if (_tmp0_) {
		const gchar* _tmp2_ = NULL;
		ValadocSettings* _tmp3_;
		gboolean _tmp4_;
		const gchar* format = NULL;
		ValadocChartsHierarchy* chart = NULL;
		ValadocChartsFactory* _tmp5_;
		ValadocChartsHierarchy* _tmp6_;
		ValadocChartsHierarchy* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		ValadocHtmlMarkupWriter* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar** _tmp15_;
		gchar** _tmp16_;
		gint _tmp16__length1;
		ValadocMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		ValadocMarkupWriter* _tmp20_;
		ValadocMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		ValadocHtmlMarkupWriter* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		const gchar* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		const gchar* _tmp35_;
		gchar* _tmp36_;
		gchar** _tmp37_;
		gchar** _tmp38_;
		gint _tmp38__length1;
		ValadocMarkupWriter* _tmp39_;
		ValadocMarkupWriter* _tmp40_;
		ValadocHtmlMarkupWriter* _tmp41_;
		ValadocChartsHierarchy* _tmp42_;
		ValadocHtmlMarkupWriter* _tmp43_;
		ValadocHtmlMarkupWriter* _tmp44_;
		_tmp3_ = self->priv->_settings;
		_tmp4_ = _tmp3_->use_svg_images;
		if (_tmp4_) {
			_tmp2_ = "svg";
		} else {
			_tmp2_ = "png";
		}
		format = _tmp2_;
		_tmp5_ = self->image_factory;
		_tmp6_ = valadoc_charts_hierarchy_new (_tmp5_, element);
		chart = _tmp6_;
		_tmp7_ = chart;
		_tmp8_ = format;
		_tmp9_ = valadoc_html_basic_doclet_get_img_path (self, element, _tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = format;
		valadoc_charts_chart_save ((ValadocChartsChart*) _tmp7_, _tmp10_, _tmp11_);
		_g_free0 (_tmp10_);
		_tmp12_ = self->writer;
		_tmp13_ = g_strdup ("class");
		_tmp14_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
		_tmp15_ = g_new0 (gchar*, 2 + 1);
		_tmp15_[0] = _tmp13_;
		_tmp15_[1] = _tmp14_;
		_tmp16_ = _tmp15_;
		_tmp16__length1 = 2;
		_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "h2", _tmp16_, 2);
		_tmp18_ = _tmp17_;
		_tmp19_ = valadoc_markup_writer_text (_tmp18_, "Object Hierarchy:");
		_tmp20_ = _tmp19_;
		_tmp21_ = valadoc_markup_writer_end_tag (_tmp20_, "h2");
		_tmp22_ = _tmp21_;
		_valadoc_markup_writer_unref0 (_tmp22_);
		_valadoc_markup_writer_unref0 (_tmp20_);
		_valadoc_markup_writer_unref0 (_tmp18_);
		_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
		_tmp23_ = self->writer;
		_tmp24_ = g_strdup ("class");
		_tmp25_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_diagram);
		_tmp26_ = g_strdup ("usemap");
		_tmp27_ = valadoc_api_node_get_full_name (element);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat ("#", _tmp28_, NULL);
		_tmp30_ = g_strdup ("alt");
		_tmp31_ = valadoc_api_node_get_name (element);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strdup_printf ("Object hierarchy for %s", _tmp32_);
		_tmp34_ = g_strdup ("src");
		_tmp35_ = format;
		_tmp36_ = valadoc_html_basic_doclet_get_img_path_html (self, element, _tmp35_);
		_tmp37_ = g_new0 (gchar*, 8 + 1);
		_tmp37_[0] = _tmp24_;
		_tmp37_[1] = _tmp25_;
		_tmp37_[2] = _tmp26_;
		_tmp37_[3] = _tmp29_;
		_tmp37_[4] = _tmp30_;
		_tmp37_[5] = _tmp33_;
		_tmp37_[6] = _tmp34_;
		_tmp37_[7] = _tmp36_;
		_tmp38_ = _tmp37_;
		_tmp38__length1 = 8;
		_tmp39_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp23_, "img", _tmp38_, 8);
		_tmp40_ = _tmp39_;
		_valadoc_markup_writer_unref0 (_tmp40_);
		_tmp38_ = (_vala_array_free (_tmp38_, _tmp38__length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_tmp28_);
		_tmp41_ = self->writer;
		_tmp42_ = chart;
		_tmp43_ = valadoc_html_markup_writer_add_usemap (_tmp41_, (ValadocChartsChart*) _tmp42_);
		_tmp44_ = _tmp43_;
		_valadoc_markup_writer_unref0 (_tmp44_);
		_g_object_unref0 (chart);
	}
}


void
valadoc_html_basic_doclet_write_namespace_content (ValadocHtmlBasicDoclet* self,
                                                   ValadocApiNamespace* node,
                                                   ValadocApiNode* parent)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValadocHtmlMarkupWriter* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	ValadocMarkupWriter* _tmp17_;
	ValadocMarkupWriter* _tmp18_;
	ValadocMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocHtmlMarkupWriter* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	ValadocMarkupWriter* _tmp28_;
	ValadocMarkupWriter* _tmp29_;
	ValadocHtmlMarkupWriter* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint _tmp34__length1;
	ValadocMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocHtmlMarkupWriter* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	ValadocMarkupWriter* _tmp46_;
	ValadocMarkupWriter* _tmp47_;
	ValadocMarkupWriter* _tmp48_;
	ValadocMarkupWriter* _tmp49_;
	ValadocMarkupWriter* _tmp50_;
	ValadocMarkupWriter* _tmp51_;
	const gchar* _tmp52_;
	const gchar* _tmp53_;
	ValadocHtmlMarkupWriter* _tmp56_;
	ValadocMarkupWriter* _tmp57_;
	ValadocMarkupWriter* _tmp58_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp8_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp9_ = _tmp8_;
	if (_tmp9_ == NULL) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("Global Namespace");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp10_;
	} else {
		gchar* _tmp11_;
		_tmp11_ = valadoc_api_node_get_full_name ((ValadocApiNode*) node);
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp11_;
	}
	_tmp12_ = self->writer;
	_tmp13_ = g_strdup ("class");
	_tmp14_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp15_ = g_new0 (gchar*, 2 + 1);
	_tmp15_[0] = _tmp13_;
	_tmp15_[1] = _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	_tmp17_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp12_, "h1", _tmp16_, 2);
	_tmp18_ = _tmp17_;
	_tmp19_ = valadoc_markup_writer_text (_tmp18_, _tmp7_);
	_tmp20_ = _tmp19_;
	_tmp21_ = valadoc_markup_writer_end_tag (_tmp20_, "h1");
	_tmp22_ = _tmp21_;
	_valadoc_markup_writer_unref0 (_tmp22_);
	_valadoc_markup_writer_unref0 (_tmp20_);
	_valadoc_markup_writer_unref0 (_tmp18_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_tmp23_ = self->writer;
	_tmp24_ = g_strdup ("class");
	_tmp25_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_hr);
	_tmp26_ = g_new0 (gchar*, 2 + 1);
	_tmp26_[0] = _tmp24_;
	_tmp26_[1] = _tmp25_;
	_tmp27_ = _tmp26_;
	_tmp27__length1 = 2;
	_tmp28_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp23_, "hr", _tmp27_, 2);
	_tmp29_ = _tmp28_;
	_valadoc_markup_writer_unref0 (_tmp29_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = self->writer;
	_tmp31_ = g_strdup ("class");
	_tmp32_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp33_ = g_new0 (gchar*, 2 + 1);
	_tmp33_[0] = _tmp31_;
	_tmp33_[1] = _tmp32_;
	_tmp34_ = _tmp33_;
	_tmp34__length1 = 2;
	_tmp35_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp30_, "h2", _tmp34_, 2);
	_tmp36_ = _tmp35_;
	_tmp37_ = valadoc_markup_writer_text (_tmp36_, "Description:");
	_tmp38_ = _tmp37_;
	_tmp39_ = valadoc_markup_writer_end_tag (_tmp38_, "h2");
	_tmp40_ = _tmp39_;
	_valadoc_markup_writer_unref0 (_tmp40_);
	_valadoc_markup_writer_unref0 (_tmp38_);
	_valadoc_markup_writer_unref0 (_tmp36_);
	_tmp34_ = (_vala_array_free (_tmp34_, _tmp34__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_documentation (self, (ValadocApiNode*) node, parent);
	_tmp41_ = self->writer;
	_tmp42_ = g_strdup ("class");
	_tmp43_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp44_ = g_new0 (gchar*, 2 + 1);
	_tmp44_[0] = _tmp42_;
	_tmp44_[1] = _tmp43_;
	_tmp45_ = _tmp44_;
	_tmp45__length1 = 2;
	_tmp46_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp41_, "h2", _tmp45_, 2);
	_tmp47_ = _tmp46_;
	_tmp48_ = valadoc_markup_writer_text (_tmp47_, "Content:");
	_tmp49_ = _tmp48_;
	_tmp50_ = valadoc_markup_writer_end_tag (_tmp49_, "h2");
	_tmp51_ = _tmp50_;
	_valadoc_markup_writer_unref0 (_tmp51_);
	_valadoc_markup_writer_unref0 (_tmp49_);
	_valadoc_markup_writer_unref0 (_tmp47_);
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	_tmp52_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp53_ = _tmp52_;
	if (_tmp53_ == NULL) {
		ValadocApiItem* _tmp54_;
		ValadocApiItem* _tmp55_;
		_tmp54_ = valadoc_api_item_get_parent ((ValadocApiItem*) node);
		_tmp55_ = _tmp54_;
		valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) G_TYPE_CHECK_INSTANCE_CAST (_tmp55_, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), parent);
	} else {
		valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) node, parent);
	}
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_CLASS, "Classes", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_STRUCT, "Structs", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_ENUM, "Enums", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_METHOD, "Functions", parent);
	valadoc_html_basic_doclet_write_children (self, (ValadocApiNode*) node, VALADOC_API_NODE_TYPE_FIELD, "Fields", parent);
	_tmp56_ = self->writer;
	_tmp57_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp56_, "div");
	_tmp58_ = _tmp57_;
	_valadoc_markup_writer_unref0 (_tmp58_);
	_g_free0 (_tmp7_);
}


void
valadoc_html_basic_doclet_write_package_content (ValadocHtmlBasicDoclet* self,
                                                 ValadocApiPackage* node,
                                                 ValadocApiNode* parent)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	ValadocMarkupWriter* _tmp5_;
	ValadocMarkupWriter* _tmp6_;
	ValadocHtmlMarkupWriter* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	ValadocMarkupWriter* _tmp16_;
	ValadocMarkupWriter* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocHtmlMarkupWriter* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	ValadocMarkupWriter* _tmp29_;
	ValadocMarkupWriter* _tmp30_;
	ValadocHtmlMarkupWriter* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocMarkupWriter* _tmp41_;
	ValadocWikiPage* _tmp42_ = NULL;
	ValadocApiTree* _tmp43_;
	ValadocWikiPageTree* _tmp44_;
	ValadocWikiPageTree* _tmp45_;
	ValadocWikiPage* wikipage = NULL;
	ValadocWikiPage* _tmp51_;
	ValadocWikiPage* _tmp52_;
	ValadocHtmlMarkupWriter* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gchar** _tmp61_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	ValadocMarkupWriter* _tmp63_;
	ValadocMarkupWriter* _tmp64_;
	ValadocMarkupWriter* _tmp65_;
	ValadocMarkupWriter* _tmp66_;
	ValadocMarkupWriter* _tmp67_;
	ValadocMarkupWriter* _tmp68_;
	ValadocHtmlMarkupWriter* _tmp91_;
	ValadocMarkupWriter* _tmp92_;
	ValadocMarkupWriter* _tmp93_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = g_strdup ("class");
	_tmp2_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_content);
	_tmp3_ = g_new0 (gchar*, 2 + 1);
	_tmp3_[0] = _tmp1_;
	_tmp3_[1] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 2;
	_tmp5_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "div", _tmp4_, 2);
	_tmp6_ = _tmp5_;
	_valadoc_markup_writer_unref0 (_tmp6_);
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = self->writer;
	_tmp8_ = g_strdup ("class");
	_tmp9_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp10_ = g_strdup ("id");
	_tmp11_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = g_new0 (gchar*, 4 + 1);
	_tmp14_[0] = _tmp8_;
	_tmp14_[1] = _tmp9_;
	_tmp14_[2] = _tmp10_;
	_tmp14_[3] = _tmp13_;
	_tmp15_ = _tmp14_;
	_tmp15__length1 = 4;
	_tmp16_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp7_, "h1", _tmp15_, 4);
	_tmp17_ = _tmp16_;
	_tmp18_ = valadoc_api_node_get_name ((ValadocApiNode*) node);
	_tmp19_ = _tmp18_;
	_tmp20_ = valadoc_markup_writer_text (_tmp17_, _tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = valadoc_markup_writer_end_tag (_tmp21_, "h1");
	_tmp23_ = _tmp22_;
	_valadoc_markup_writer_unref0 (_tmp23_);
	_valadoc_markup_writer_unref0 (_tmp21_);
	_valadoc_markup_writer_unref0 (_tmp17_);
	_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
	_tmp24_ = self->writer;
	_tmp25_ = g_strdup ("class");
	_tmp26_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_headline_hr);
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp25_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp24_, "hr", _tmp28_, 2);
	_tmp30_ = _tmp29_;
	_valadoc_markup_writer_unref0 (_tmp30_);
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	_tmp31_ = self->writer;
	_tmp32_ = g_strdup ("class");
	_tmp33_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp34_ = g_new0 (gchar*, 2 + 1);
	_tmp34_[0] = _tmp32_;
	_tmp34_[1] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 2;
	_tmp36_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp31_, "h2", _tmp35_, 2);
	_tmp37_ = _tmp36_;
	_tmp38_ = valadoc_markup_writer_text (_tmp37_, "Description:");
	_tmp39_ = _tmp38_;
	_tmp40_ = valadoc_markup_writer_end_tag (_tmp39_, "h2");
	_tmp41_ = _tmp40_;
	_valadoc_markup_writer_unref0 (_tmp41_);
	_valadoc_markup_writer_unref0 (_tmp39_);
	_valadoc_markup_writer_unref0 (_tmp37_);
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	_tmp43_ = self->tree;
	_tmp44_ = valadoc_api_tree_get_wikitree (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_ == NULL) {
		_g_object_unref0 (_tmp42_);
		_tmp42_ = NULL;
	} else {
		ValadocApiTree* _tmp46_;
		ValadocWikiPageTree* _tmp47_;
		ValadocWikiPageTree* _tmp48_;
		const gchar* _tmp49_;
		ValadocWikiPage* _tmp50_;
		_tmp46_ = self->tree;
		_tmp47_ = valadoc_api_tree_get_wikitree (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = self->priv->_wiki_index_name;
		_tmp50_ = valadoc_wiki_page_tree_search (_tmp48_, _tmp49_);
		_g_object_unref0 (_tmp42_);
		_tmp42_ = _tmp50_;
	}
	_tmp51_ = _g_object_ref0 (_tmp42_);
	wikipage = _tmp51_;
	_tmp52_ = wikipage;
	if (_tmp52_ != NULL) {
		ValadocHtmlHtmlRenderer* _tmp53_;
		ValadocHtmlHtmlRenderer* _tmp54_;
		ValadocWikiPage* _tmp55_;
		ValadocContentPage* _tmp56_;
		ValadocContentPage* _tmp57_;
		_tmp53_ = self->_renderer;
		valadoc_html_html_renderer_set_container (_tmp53_, (ValadocDocumentation*) parent);
		_tmp54_ = self->_renderer;
		_tmp55_ = wikipage;
		_tmp56_ = valadoc_wiki_page_get_documentation (_tmp55_);
		_tmp57_ = _tmp56_;
		valadoc_content_content_renderer_render ((ValadocContentContentRenderer*) _tmp54_, (ValadocContentContentElement*) _tmp57_);
	}
	_tmp58_ = self->writer;
	_tmp59_ = g_strdup ("class");
	_tmp60_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_title);
	_tmp61_ = g_new0 (gchar*, 2 + 1);
	_tmp61_[0] = _tmp59_;
	_tmp61_[1] = _tmp60_;
	_tmp62_ = _tmp61_;
	_tmp62__length1 = 2;
	_tmp63_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp58_, "h2", _tmp62_, 2);
	_tmp64_ = _tmp63_;
	_tmp65_ = valadoc_markup_writer_text (_tmp64_, "Content:");
	_tmp66_ = _tmp65_;
	_tmp67_ = valadoc_markup_writer_end_tag (_tmp66_, "h2");
	_tmp68_ = _tmp67_;
	_valadoc_markup_writer_unref0 (_tmp68_);
	_valadoc_markup_writer_unref0 (_tmp66_);
	_valadoc_markup_writer_unref0 (_tmp64_);
	_tmp62_ = (_vala_array_free (_tmp62_, _tmp62__length1, (GDestroyNotify) g_free), NULL);
	valadoc_html_basic_doclet_write_child_namespaces (self, (ValadocApiNode*) node, parent);
	{
		ValaList* _child_list = NULL;
		ValaList* _tmp69_;
		gint _child_size = 0;
		ValaList* _tmp70_;
		gint _tmp71_;
		gint _tmp72_;
		gint _child_index = 0;
		_tmp69_ = valadoc_api_node_get_children_by_type ((ValadocApiNode*) node, VALADOC_API_NODE_TYPE_NAMESPACE, TRUE);
		_child_list = _tmp69_;
		_tmp70_ = _child_list;
		_tmp71_ = vala_collection_get_size ((ValaCollection*) _tmp70_);
		_tmp72_ = _tmp71_;
		_child_size = _tmp72_;
		_child_index = -1;
		while (TRUE) {
			gint _tmp73_;
			gint _tmp74_;
			gint _tmp75_;
			ValadocApiNode* child = NULL;
			ValaList* _tmp76_;
			gint _tmp77_;
			gpointer _tmp78_;
			ValadocApiNode* _tmp79_;
			const gchar* _tmp80_;
			const gchar* _tmp81_;
			_tmp73_ = _child_index;
			_child_index = _tmp73_ + 1;
			_tmp74_ = _child_index;
			_tmp75_ = _child_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _child_list;
			_tmp77_ = _child_index;
			_tmp78_ = vala_list_get (_tmp76_, _tmp77_);
			child = (ValadocApiNode*) _tmp78_;
			_tmp79_ = child;
			_tmp80_ = valadoc_api_node_get_name (_tmp79_);
			_tmp81_ = _tmp80_;
			if (_tmp81_ == NULL) {
				ValadocApiNode* _tmp82_;
				ValadocApiNode* _tmp83_;
				ValadocApiNode* _tmp84_;
				ValadocApiNode* _tmp85_;
				ValadocApiNode* _tmp86_;
				ValadocApiNode* _tmp87_;
				ValadocApiNode* _tmp88_;
				ValadocApiNode* _tmp89_;
				ValadocApiNode* _tmp90_;
				_tmp82_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp82_, VALADOC_API_NODE_TYPE_INTERFACE, "Interfaces", parent);
				_tmp83_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp83_, VALADOC_API_NODE_TYPE_CLASS, "Classes", parent);
				_tmp84_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp84_, VALADOC_API_NODE_TYPE_STRUCT, "Structs", parent);
				_tmp85_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp85_, VALADOC_API_NODE_TYPE_ENUM, "Enums", parent);
				_tmp86_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp86_, VALADOC_API_NODE_TYPE_ERROR_DOMAIN, "Error domains", parent);
				_tmp87_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp87_, VALADOC_API_NODE_TYPE_CONSTANT, "Constants", parent);
				_tmp88_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp88_, VALADOC_API_NODE_TYPE_DELEGATE, "Delegates", parent);
				_tmp89_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp89_, VALADOC_API_NODE_TYPE_METHOD, "Functions", parent);
				_tmp90_ = child;
				valadoc_html_basic_doclet_write_children (self, _tmp90_, VALADOC_API_NODE_TYPE_FIELD, "Fields", parent);
			}
			_g_object_unref0 (child);
		}
		_vala_iterable_unref0 (_child_list);
	}
	valadoc_html_basic_doclet_write_child_dependencies (self, node, parent);
	_tmp91_ = self->writer;
	_tmp92_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp91_, "div");
	_tmp93_ = _tmp92_;
	_valadoc_markup_writer_unref0 (_tmp93_);
	_g_object_unref0 (wikipage);
	_g_object_unref0 (_tmp42_);
}


void
valadoc_html_basic_doclet_write_file_header (ValadocHtmlBasicDoclet* self,
                                             const gchar* css,
                                             const gchar* js,
                                             const gchar* title)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocHtmlMarkupWriter* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp29_;
	ValadocHtmlMarkupWriter* _tmp30_;
	ValadocHtmlMarkupWriter* _tmp31_;
	ValadocHtmlMarkupWriter* _tmp32_;
	ValadocHtmlMarkupWriter* _tmp33_;
	ValadocHtmlMarkupWriter* _tmp34_;
	ValadocHtmlMarkupWriter* _tmp35_;
	ValadocMarkupWriter* _tmp36_;
	ValadocMarkupWriter* _tmp37_;
	ValadocHtmlMarkupWriter* _tmp38_;
	ValadocMarkupWriter* _tmp39_;
	ValadocMarkupWriter* _tmp40_;
	ValadocHtmlMarkupWriter* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar** _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	ValadocMarkupWriter* _tmp46_;
	ValadocMarkupWriter* _tmp47_;
	const gchar* _tmp48_ = NULL;
	ValadocHtmlMarkupWriter* _tmp49_;
	gchar* _tmp50_;
	gchar* _tmp51_;
	ValadocMarkupWriter* _tmp52_;
	ValadocMarkupWriter* _tmp53_;
	ValadocHtmlMarkupWriter* _tmp54_;
	ValadocMarkupWriter* _tmp55_;
	ValadocMarkupWriter* _tmp56_;
	ValadocHtmlMarkupWriter* _tmp57_;
	gchar* _tmp58_;
	gchar* _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	ValadocMarkupWriter* _tmp62_;
	ValadocMarkupWriter* _tmp63_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (css != NULL);
	g_return_if_fail (js != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp0_, "html", NULL, 0);
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = self->writer;
	_tmp4_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp3_, "head", NULL, 0);
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
	_tmp6_ = self->writer;
	_tmp7_ = g_strdup ("charset");
	_tmp8_ = g_strdup ("UTF-8");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp6_, "meta", _tmp10_, 2);
	_tmp12_ = _tmp11_;
	_valadoc_markup_writer_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	if (title == NULL) {
		ValadocHtmlMarkupWriter* _tmp13_;
		ValadocMarkupWriter* _tmp14_;
		ValadocMarkupWriter* _tmp15_;
		ValadocMarkupWriter* _tmp16_;
		ValadocMarkupWriter* _tmp17_;
		ValadocMarkupWriter* _tmp18_;
		ValadocMarkupWriter* _tmp19_;
		_tmp13_ = self->writer;
		_tmp14_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp13_, "title", NULL, 0);
		_tmp15_ = _tmp14_;
		_tmp16_ = valadoc_markup_writer_text (_tmp15_, "Vala Binding Reference");
		_tmp17_ = _tmp16_;
		_tmp18_ = valadoc_markup_writer_end_tag (_tmp17_, "title");
		_tmp19_ = _tmp18_;
		_valadoc_markup_writer_unref0 (_tmp19_);
		_valadoc_markup_writer_unref0 (_tmp17_);
		_valadoc_markup_writer_unref0 (_tmp15_);
	} else {
		ValadocHtmlMarkupWriter* _tmp20_;
		ValadocMarkupWriter* _tmp21_;
		ValadocMarkupWriter* _tmp22_;
		ValadocMarkupWriter* _tmp23_;
		ValadocMarkupWriter* _tmp24_;
		ValadocMarkupWriter* _tmp25_;
		ValadocMarkupWriter* _tmp26_;
		ValadocMarkupWriter* _tmp27_;
		ValadocMarkupWriter* _tmp28_;
		_tmp20_ = self->writer;
		_tmp21_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp20_, "title", NULL, 0);
		_tmp22_ = _tmp21_;
		_tmp23_ = valadoc_markup_writer_text (_tmp22_, title);
		_tmp24_ = _tmp23_;
		_tmp25_ = valadoc_markup_writer_text (_tmp24_, " &ndash; Vala Binding Reference");
		_tmp26_ = _tmp25_;
		_tmp27_ = valadoc_markup_writer_end_tag (_tmp26_, "title");
		_tmp28_ = _tmp27_;
		_valadoc_markup_writer_unref0 (_tmp28_);
		_valadoc_markup_writer_unref0 (_tmp26_);
		_valadoc_markup_writer_unref0 (_tmp24_);
		_valadoc_markup_writer_unref0 (_tmp22_);
	}
	_tmp29_ = self->writer;
	_tmp30_ = valadoc_html_markup_writer_stylesheet_link (_tmp29_, css);
	_tmp31_ = _tmp30_;
	_valadoc_markup_writer_unref0 (_tmp31_);
	_tmp32_ = self->writer;
	_tmp33_ = valadoc_html_markup_writer_javascript_link (_tmp32_, js);
	_tmp34_ = _tmp33_;
	_valadoc_markup_writer_unref0 (_tmp34_);
	_tmp35_ = self->writer;
	_tmp36_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp35_, "head");
	_tmp37_ = _tmp36_;
	_valadoc_markup_writer_unref0 (_tmp37_);
	_tmp38_ = self->writer;
	_tmp39_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp38_, "body", NULL, 0);
	_tmp40_ = _tmp39_;
	_valadoc_markup_writer_unref0 (_tmp40_);
	_tmp41_ = self->writer;
	_tmp42_ = g_strdup ("class");
	_tmp43_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_site_header);
	_tmp44_ = g_new0 (gchar*, 2 + 1);
	_tmp44_[0] = _tmp42_;
	_tmp44_[1] = _tmp43_;
	_tmp45_ = _tmp44_;
	_tmp45__length1 = 2;
	_tmp46_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp41_, "div", _tmp45_, 2);
	_tmp47_ = _tmp46_;
	_valadoc_markup_writer_unref0 (_tmp47_);
	_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
	if (title == NULL) {
		_tmp48_ = "";
	} else {
		_tmp48_ = title;
	}
	_tmp49_ = self->writer;
	_tmp50_ = g_strdup_printf ("%s Reference Manual", _tmp48_);
	_tmp51_ = _tmp50_;
	_tmp52_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp49_, _tmp51_);
	_tmp53_ = _tmp52_;
	_valadoc_markup_writer_unref0 (_tmp53_);
	_g_free0 (_tmp51_);
	_tmp54_ = self->writer;
	_tmp55_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp54_, "div");
	_tmp56_ = _tmp55_;
	_valadoc_markup_writer_unref0 (_tmp56_);
	_tmp57_ = self->writer;
	_tmp58_ = g_strdup ("class");
	_tmp59_ = g_strdup (VALADOC_HTML_BASIC_DOCLET_css_style_body);
	_tmp60_ = g_new0 (gchar*, 2 + 1);
	_tmp60_[0] = _tmp58_;
	_tmp60_[1] = _tmp59_;
	_tmp61_ = _tmp60_;
	_tmp61__length1 = 2;
	_tmp62_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp57_, "div", _tmp61_, 2);
	_tmp63_ = _tmp62_;
	_valadoc_markup_writer_unref0 (_tmp63_);
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
}


void
valadoc_html_basic_doclet_write_file_footer (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlMarkupWriter* _tmp0_;
	ValadocMarkupWriter* _tmp1_;
	ValadocMarkupWriter* _tmp2_;
	ValadocHtmlMarkupWriter* _tmp3_;
	ValadocMarkupWriter* _tmp4_;
	ValadocMarkupWriter* _tmp5_;
	ValadocHtmlMarkupWriter* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gint _tmp10__length1;
	ValadocMarkupWriter* _tmp11_;
	ValadocMarkupWriter* _tmp12_;
	ValadocHtmlMarkupWriter* _tmp13_;
	ValadocMarkupWriter* _tmp14_;
	ValadocMarkupWriter* _tmp15_;
	ValadocHtmlMarkupWriter* _tmp16_;
	ValadocHtmlMarkupWriter* _tmp17_;
	ValadocHtmlMarkupWriter* _tmp18_;
	ValadocHtmlMarkupWriter* _tmp19_;
	ValadocMarkupWriter* _tmp20_;
	ValadocMarkupWriter* _tmp21_;
	ValadocHtmlMarkupWriter* _tmp22_;
	ValadocMarkupWriter* _tmp23_;
	ValadocMarkupWriter* _tmp24_;
	ValadocHtmlMarkupWriter* _tmp25_;
	ValadocMarkupWriter* _tmp26_;
	ValadocMarkupWriter* _tmp27_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->writer;
	_tmp1_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp0_, "div");
	_tmp2_ = _tmp1_;
	_valadoc_markup_writer_unref0 (_tmp2_);
	_tmp3_ = self->writer;
	_tmp4_ = valadoc_markup_writer_simple_tag ((ValadocMarkupWriter*) _tmp3_, "br", NULL, 0);
	_tmp5_ = _tmp4_;
	_valadoc_markup_writer_unref0 (_tmp5_);
	_tmp6_ = self->writer;
	_tmp7_ = g_strdup ("class");
	_tmp8_ = g_strdup ("site_footer");
	_tmp9_ = g_new0 (gchar*, 2 + 1);
	_tmp9_[0] = _tmp7_;
	_tmp9_[1] = _tmp8_;
	_tmp10_ = _tmp9_;
	_tmp10__length1 = 2;
	_tmp11_ = valadoc_markup_writer_start_tag ((ValadocMarkupWriter*) _tmp6_, "div", _tmp10_, 2);
	_tmp12_ = _tmp11_;
	_valadoc_markup_writer_unref0 (_tmp12_);
	_tmp10_ = (_vala_array_free (_tmp10_, _tmp10__length1, (GDestroyNotify) g_free), NULL);
	_tmp13_ = self->writer;
	_tmp14_ = valadoc_markup_writer_text ((ValadocMarkupWriter*) _tmp13_, "Generated by ");
	_tmp15_ = _tmp14_;
	_valadoc_markup_writer_unref0 (_tmp15_);
	_tmp16_ = self->writer;
	_tmp17_ = valadoc_html_markup_writer_link (_tmp16_, "https://wiki.gnome.org/Projects/Valadoc", "<kbd>valadoc</kbd>", NULL);
	_tmp18_ = _tmp17_;
	_valadoc_markup_writer_unref0 (_tmp18_);
	_tmp19_ = self->writer;
	_tmp20_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp19_, "div");
	_tmp21_ = _tmp20_;
	_valadoc_markup_writer_unref0 (_tmp21_);
	_tmp22_ = self->writer;
	_tmp23_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp22_, "body");
	_tmp24_ = _tmp23_;
	_valadoc_markup_writer_unref0 (_tmp24_);
	_tmp25_ = self->writer;
	_tmp26_ = valadoc_markup_writer_end_tag ((ValadocMarkupWriter*) _tmp25_, "html");
	_tmp27_ = _tmp26_;
	_valadoc_markup_writer_unref0 (_tmp27_);
}


ValadocHtmlBasicDoclet*
valadoc_html_basic_doclet_construct (GType object_type)
{
	ValadocHtmlBasicDoclet * self = NULL;
	self = (ValadocHtmlBasicDoclet*) valadoc_api_visitor_construct (object_type);
	return self;
}


ValadocHtmlLinkHelper*
valadoc_html_basic_doclet_get_linker (ValadocHtmlBasicDoclet* self)
{
	ValadocHtmlLinkHelper* result;
	ValadocHtmlLinkHelper* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_linker;
	result = _tmp0_;
	return result;
}


void
valadoc_html_basic_doclet_set_linker (ValadocHtmlBasicDoclet* self,
                                      ValadocHtmlLinkHelper* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_html_basic_doclet_get_linker (self) != value) {
		ValadocHtmlLinkHelper* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_linker);
		self->priv->_linker = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY]);
	}
}


ValadocSettings*
valadoc_html_basic_doclet_get_settings (ValadocHtmlBasicDoclet* self)
{
	ValadocSettings* result;
	ValadocSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}


void
valadoc_html_basic_doclet_set_settings (ValadocHtmlBasicDoclet* self,
                                        ValadocSettings* value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_html_basic_doclet_get_settings (self) != value) {
		ValadocSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY]);
	}
}


const gchar*
valadoc_html_basic_doclet_get_wiki_index_name (ValadocHtmlBasicDoclet* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wiki_index_name;
	result = _tmp0_;
	return result;
}


void
valadoc_html_basic_doclet_set_wiki_index_name (ValadocHtmlBasicDoclet* self,
                                               const gchar* value)
{
	g_return_if_fail (self != NULL);
	if (g_strcmp0 (value, valadoc_html_basic_doclet_get_wiki_index_name (self)) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_wiki_index_name);
		self->priv->_wiki_index_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY]);
	}
}


static void
valadoc_html_basic_doclet_class_init (ValadocHtmlBasicDocletClass * klass)
{
	ValadocApiNodeType* _tmp0_;
	valadoc_html_basic_doclet_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocHtmlBasicDocletPrivate));
	((ValadocHtmlBasicDocletClass *) klass)->process = (void (*) (ValadocHtmlBasicDoclet*, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) valadoc_html_basic_doclet_real_process;
	((ValadocHtmlBasicDocletClass *) klass)->get_img_path_html = (gchar* (*) (ValadocHtmlBasicDoclet*, ValadocApiNode*, const gchar*)) valadoc_html_basic_doclet_real_get_img_path_html;
	((ValadocHtmlBasicDocletClass *) klass)->get_img_path = (gchar* (*) (ValadocHtmlBasicDoclet*, ValadocApiNode*, const gchar*)) valadoc_html_basic_doclet_real_get_img_path;
	((ValadocHtmlBasicDocletClass *) klass)->get_icon_directory = (gchar* (*) (ValadocHtmlBasicDoclet*)) valadoc_html_basic_doclet_real_get_icon_directory;
	((ValadocHtmlBasicDocletClass *) klass)->write_wiki_page = (void (*) (ValadocHtmlBasicDoclet*, ValadocWikiPage*, const gchar*, const gchar*, const gchar*, const gchar*)) valadoc_html_basic_doclet_real_write_wiki_page;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_html_basic_doclet_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_html_basic_doclet_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_html_basic_doclet_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY] = g_param_spec_object ("linker", "linker", "linker", VALADOC_HTML_TYPE_LINK_HELPER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", VALADOC_TYPE_SETTINGS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY, valadoc_html_basic_doclet_properties[VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY] = g_param_spec_string ("wiki-index-name", "wiki-index-name", "wiki-index-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	_tmp0_ = g_new0 (ValadocApiNodeType, 7);
	_tmp0_[0] = VALADOC_API_NODE_TYPE_CONSTANT;
	_tmp0_[1] = VALADOC_API_NODE_TYPE_PROPERTY;
	_tmp0_[2] = VALADOC_API_NODE_TYPE_DELEGATE;
	_tmp0_[3] = VALADOC_API_NODE_TYPE_STATIC_METHOD;
	_tmp0_[4] = VALADOC_API_NODE_TYPE_METHOD;
	_tmp0_[5] = VALADOC_API_NODE_TYPE_SIGNAL;
	_tmp0_[6] = VALADOC_API_NODE_TYPE_FIELD;
	valadoc_html_basic_doclet_inheritable_members = _tmp0_;
	valadoc_html_basic_doclet_inheritable_members_length1 = 7;
}


static void
valadoc_html_basic_doclet_valadoc_doclet_interface_init (ValadocDocletIface * iface)
{
	valadoc_html_basic_doclet_valadoc_doclet_parent_iface = g_type_interface_peek_parent (iface);
	iface->process = (void (*) (ValadocDoclet*, ValadocSettings*, ValadocApiTree*, ValadocErrorReporter*)) valadoc_html_basic_doclet_process;
}


static void
valadoc_html_basic_doclet_instance_init (ValadocHtmlBasicDoclet * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = VALADOC_HTML_BASIC_DOCLET_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("index.valadoc");
	self->priv->_wiki_index_name = _tmp0_;
	_tmp1_ = g_strdup ("../index.html");
	self->package_list_link = _tmp1_;
	self->priv->html_id_counter = (guint) 0;
}


static void
valadoc_html_basic_doclet_finalize (GObject * obj)
{
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	_g_object_unref0 (self->priv->_linker);
	_g_object_unref0 (self->priv->_settings);
	_g_free0 (self->priv->_wiki_index_name);
	_valadoc_api_tree_unref0 (self->tree);
	_g_object_unref0 (self->_renderer);
	_valadoc_markup_writer_unref0 (self->writer);
	_g_object_unref0 (self->cssresolver);
	_g_object_unref0 (self->image_factory);
	_g_object_unref0 (self->reporter);
	_g_free0 (self->package_list_link);
	G_OBJECT_CLASS (valadoc_html_basic_doclet_parent_class)->finalize (obj);
}


GType
valadoc_html_basic_doclet_get_type (void)
{
	static volatile gsize valadoc_html_basic_doclet_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_html_basic_doclet_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHtmlBasicDocletClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_html_basic_doclet_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHtmlBasicDoclet), 0, (GInstanceInitFunc) valadoc_html_basic_doclet_instance_init, NULL };
		static const GInterfaceInfo valadoc_doclet_info = { (GInterfaceInitFunc) valadoc_html_basic_doclet_valadoc_doclet_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType valadoc_html_basic_doclet_type_id;
		valadoc_html_basic_doclet_type_id = g_type_register_static (VALADOC_API_TYPE_VISITOR, "ValadocHtmlBasicDoclet", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_type_add_interface_static (valadoc_html_basic_doclet_type_id, VALADOC_TYPE_DOCLET, &valadoc_doclet_info);
		g_once_init_leave (&valadoc_html_basic_doclet_type_id__volatile, valadoc_html_basic_doclet_type_id);
	}
	return valadoc_html_basic_doclet_type_id__volatile;
}


static void
_vala_valadoc_html_basic_doclet_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec)
{
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	switch (property_id) {
		case VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY:
		g_value_set_object (value, valadoc_html_basic_doclet_get_linker (self));
		break;
		case VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY:
		g_value_set_object (value, valadoc_html_basic_doclet_get_settings (self));
		break;
		case VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY:
		g_value_set_string (value, valadoc_html_basic_doclet_get_wiki_index_name (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_html_basic_doclet_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec)
{
	ValadocHtmlBasicDoclet * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_BASIC_DOCLET, ValadocHtmlBasicDoclet);
	switch (property_id) {
		case VALADOC_HTML_BASIC_DOCLET_LINKER_PROPERTY:
		valadoc_html_basic_doclet_set_linker (self, g_value_get_object (value));
		break;
		case VALADOC_HTML_BASIC_DOCLET_SETTINGS_PROPERTY:
		valadoc_html_basic_doclet_set_settings (self, g_value_get_object (value));
		break;
		case VALADOC_HTML_BASIC_DOCLET_WIKI_INDEX_NAME_PROPERTY:
		valadoc_html_basic_doclet_set_wiki_index_name (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



