/* valaccodemethodcallmodule.c generated by valac, the Vala compiler
 * generated from valaccodemethodcallmodule.vala, do not modify */

/* valaccodemethodcallmodule.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 * Copyright (C) 2006-2008  Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "valacodegen.h"
#include <vala.h>
#include <valaccode.h>
#include <valagee.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>

#define _vala_ccode_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_node_unref (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_map_unref0(var) ((var == NULL) ? NULL : (var = (vala_map_unref (var), NULL)))
#define _vala_target_value_unref0(var) ((var == NULL) ? NULL : (var = (vala_target_value_unref (var), NULL)))
#define _vala_iterator_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterator_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define VALA_TYPE_GLIB_VALUE (vala_glib_value_get_type ())
#define VALA_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValue))
#define VALA_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))
#define VALA_IS_GLIB_VALUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_GLIB_VALUE))
#define VALA_IS_GLIB_VALUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_GLIB_VALUE))
#define VALA_GLIB_VALUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_GLIB_VALUE, ValaGLibValueClass))

typedef struct _ValaGLibValue ValaGLibValue;
typedef struct _ValaGLibValueClass ValaGLibValueClass;
typedef struct _ValaGLibValuePrivate ValaGLibValuePrivate;
#define _vala_ccode_base_module_emit_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_ccode_base_module_emit_context_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValaGLibValue {
	ValaTargetValue parent_instance;
	ValaCCodeExpression* cvalue;
	gboolean lvalue;
	gboolean non_null;
	gchar* ctype;
	ValaList* array_length_cvalues;
	ValaCCodeExpression* array_size_cvalue;
	gboolean array_null_terminated;
	ValaCCodeExpression* array_length_cexpr;
	ValaCCodeExpression* delegate_target_cvalue;
	ValaCCodeExpression* delegate_target_destroy_notify_cvalue;
	ValaGLibValuePrivate * priv;
};

struct _ValaGLibValueClass {
	ValaTargetValueClass parent_class;
};


static gpointer vala_ccode_method_call_module_parent_class = NULL;

static void vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                           ValaMethodCall* expr);
static gchar* vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                                      ValaEnum* en);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_new (ValaDataType* value_type,
                                    ValaCCodeExpression* cvalue,
                                    gboolean lvalue);
G_GNUC_INTERNAL ValaGLibValue* vala_glib_value_construct (GType object_type,
                                          ValaDataType* value_type,
                                          ValaCCodeExpression* cvalue,
                                          gboolean lvalue);
G_GNUC_INTERNAL GType vala_glib_value_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static gboolean vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                          ValaCallable* c);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static gpointer
_vala_map_ref0 (gpointer self)
{
	return self ? vala_map_ref (self) : NULL;
}


static gpointer
_vala_ccode_node_ref0 (gpointer self)
{
	return self ? vala_ccode_node_ref (self) : NULL;
}


static gpointer
_vala_target_value_ref0 (gpointer self)
{
	return self ? vala_target_value_ref (self) : NULL;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gsize _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		const gchar* res = NULL;
		gsize _tmp27_;
		void* _tmp28_;
		void* ptr = NULL;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		void* _tmp31_;
		const gchar* _tmp44_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = len;
		_tmp24_ = strlen ((const gchar*) separator);
		_tmp25_ = _tmp24_;
		_tmp26_ = i;
		len = _tmp23_ + (_tmp25_ * (_tmp26_ - 1));
		_tmp27_ = len;
		_tmp28_ = g_malloc (_tmp27_);
		res = _tmp28_;
		_tmp29_ = res;
		_tmp30_ = str_array[0];
		_tmp31_ = g_stpcpy ((void*) _tmp29_, (const gchar*) _tmp30_);
		ptr = _tmp31_;
		{
			gboolean _tmp32_ = FALSE;
			i = 1;
			_tmp32_ = TRUE;
			while (TRUE) {
				gint _tmp34_;
				void* _tmp35_;
				void* _tmp36_;
				const gchar* _tmp37_ = NULL;
				gint _tmp38_;
				const gchar* _tmp39_;
				void* _tmp42_;
				void* _tmp43_;
				if (!_tmp32_) {
					gint _tmp33_;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				if (!(_tmp34_ < str_array_length1)) {
					break;
				}
				_tmp35_ = ptr;
				_tmp36_ = g_stpcpy (_tmp35_, (const gchar*) separator);
				ptr = _tmp36_;
				_tmp38_ = i;
				_tmp39_ = str_array[_tmp38_];
				if (_tmp39_ != NULL) {
					gint _tmp40_;
					const gchar* _tmp41_;
					_tmp40_ = i;
					_tmp41_ = str_array[_tmp40_];
					_tmp37_ = (const gchar*) _tmp41_;
				} else {
					_tmp37_ = "";
				}
				_tmp42_ = ptr;
				_tmp43_ = g_stpcpy (_tmp42_, _tmp37_);
				ptr = _tmp43_;
			}
		}
		_tmp44_ = res;
		res = NULL;
		result = (gchar*) _tmp44_;
		return result;
	} else {
		gchar* _tmp45_;
		_tmp45_ = g_strdup ("");
		result = _tmp45_;
		return result;
	}
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch4_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally4;
	__catch4_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void
vala_ccode_method_call_module_real_visit_method_call (ValaCodeVisitor* base,
                                                      ValaMethodCall* expr)
{
	ValaCCodeMethodCallModule * self;
	ValaCCodeFunctionCall* ccall = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaCCodeExpression* _tmp2_;
	ValaCCodeExpression* _tmp3_;
	ValaCCodeFunctionCall* _tmp4_;
	ValaCCodeFunctionCall* _tmp5_;
	ValaCCodeFunctionCall* async_call = NULL;
	ValaCCodeFunctionCall* finish_call = NULL;
	ValaMethod* m = NULL;
	ValaDelegate* deleg = NULL;
	ValaList* params = NULL;
	ValaMemberAccess* ma = NULL;
	ValaExpression* _tmp6_;
	ValaExpression* _tmp7_;
	ValaMemberAccess* _tmp8_;
	ValaDataType* itype = NULL;
	ValaExpression* _tmp9_;
	ValaExpression* _tmp10_;
	ValaDataType* _tmp11_;
	ValaDataType* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaList* _tmp15_;
	ValaDataType* _tmp16_;
	ValaHashMap* in_arg_map = NULL;
	GHashFunc _tmp130_;
	GEqualFunc _tmp131_;
	GEqualFunc _tmp132_;
	ValaHashMap* _tmp133_;
	ValaHashMap* out_arg_map = NULL;
	ValaHashMap* _tmp134_;
	ValaHashMap* _tmp135_;
	gboolean _tmp136_ = FALSE;
	ValaMethod* _tmp137_;
	gboolean _tmp283_ = FALSE;
	ValaMethod* _tmp284_;
	ValaCCodeExpression* ccall_expr = NULL;
	ValaCCodeFunctionCall* _tmp455_;
	ValaCCodeExpression* _tmp456_;
	ValaMethod* _tmp457_;
	ValaCCodeExpression* instance = NULL;
	gboolean _tmp481_ = FALSE;
	ValaMethod* _tmp482_;
	gboolean _tmp638_ = FALSE;
	ValaMethod* _tmp639_;
	ValaMethod* _tmp691_;
	gboolean ellipsis = FALSE;
	gint i = 0;
	gint arg_pos = 0;
	ValaIterator* params_it = NULL;
	ValaList* _tmp887_;
	ValaIterator* _tmp888_;
	ValaIterator* _tmp1244_;
	gboolean _tmp1254_ = FALSE;
	gboolean _tmp1255_ = FALSE;
	ValaMethod* _tmp1256_;
	gboolean _tmp1381_ = FALSE;
	ValaDelegate* _tmp1382_;
	gboolean _tmp1479_ = FALSE;
	ValaMethod* _tmp1480_;
	gboolean _tmp1496_;
	gboolean _tmp1497_;
	gboolean _tmp1512_;
	ValaDataType* _tmp1537_;
	gboolean return_result_via_out_param = FALSE;
	ValaDataType* _tmp1561_;
	ValaDataType* _tmp1562_;
	ValaDataType* _tmp1563_;
	gboolean _tmp1564_;
	gboolean _tmp1565_ = FALSE;
	ValaDataType* _tmp1566_;
	ValaCCodeFunctionCall* _tmp1595_;
	ValaCCodeFunctionCall* _tmp1596_;
	ValaCCodeExpression* out_param_ref = NULL;
	gboolean _tmp1597_;
	gint last_pos = 0;
	gint min_pos = 0;
	ValaCCodeFunctionCall* _tmp1612_;
	ValaCCodeFunctionCall* _tmp1613_;
	ValaCCodeFunctionCall* _tmp1637_;
	gboolean _tmp1661_;
	gboolean _tmp1662_;
	gboolean _tmp1688_;
	gboolean _tmp1689_;
	gboolean _tmp1719_;
	gboolean _tmp1725_ = FALSE;
	gboolean _tmp1726_ = FALSE;
	ValaMethod* _tmp1727_;
	gboolean _tmp1765_ = FALSE;
	gboolean _tmp1766_ = FALSE;
	ValaMethod* _tmp1767_;
	ValaMethod* _tmp1786_;
	gboolean _tmp1903_ = FALSE;
	ValaCodeNode* _tmp1904_;
	ValaCodeNode* _tmp1905_;
	ValaList* _tmp1988_;
	ValaIterator* _tmp1989_;
	gboolean _tmp2074_ = FALSE;
	gboolean _tmp2075_ = FALSE;
	ValaMethod* _tmp2076_;
	self = (ValaCCodeMethodCallModule*) base;
	g_return_if_fail (expr != NULL);
	_tmp0_ = vala_method_call_get_call (expr);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_ccode_function_call_new (_tmp3_);
	_tmp5_ = _tmp4_;
	_vala_ccode_node_unref0 (_tmp3_);
	ccall = _tmp5_;
	async_call = NULL;
	finish_call = NULL;
	m = NULL;
	deleg = NULL;
	_tmp6_ = vala_method_call_get_call (expr);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_MEMBER_ACCESS) ? ((ValaMemberAccess*) _tmp7_) : NULL);
	ma = _tmp8_;
	_tmp9_ = vala_method_call_get_call (expr);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_expression_get_value_type (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	itype = _tmp13_;
	_tmp14_ = itype;
	_tmp15_ = vala_data_type_get_parameters (_tmp14_);
	_vala_iterable_unref0 (params);
	params = _tmp15_;
	_tmp16_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_METHOD_TYPE)) {
		ValaMemberAccess* _tmp17_;
		ValaDataType* _tmp18_;
		ValaMethod* _tmp19_;
		ValaMethod* _tmp20_;
		ValaMethod* _tmp21_;
		ValaMethod* _tmp22_;
		gboolean _tmp24_ = FALSE;
		gboolean _tmp25_ = FALSE;
		ValaMemberAccess* _tmp26_;
		ValaExpression* _tmp27_;
		ValaExpression* _tmp28_;
		_tmp17_ = ma;
		_vala_assert (_tmp17_ != NULL, "ma != null");
		_tmp18_ = itype;
		_tmp19_ = vala_method_type_get_method_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, VALA_TYPE_METHOD_TYPE, ValaMethodType));
		_tmp20_ = _tmp19_;
		_tmp21_ = _vala_code_node_ref0 (_tmp20_);
		_vala_code_node_unref0 (m);
		m = _tmp21_;
		_tmp22_ = m;
		if (!vala_get_ccode_simple_generics (_tmp22_)) {
			ValaMemberAccess* _tmp23_;
			_tmp23_ = ma;
			vala_ccode_base_module_check_type_arguments ((ValaCCodeBaseModule*) self, _tmp23_);
		}
		_tmp26_ = ma;
		_tmp27_ = vala_member_access_get_inner (_tmp26_);
		_tmp28_ = _tmp27_;
		if (_tmp28_ != NULL) {
			ValaMemberAccess* _tmp29_;
			ValaExpression* _tmp30_;
			ValaExpression* _tmp31_;
			ValaDataType* _tmp32_;
			ValaDataType* _tmp33_;
			_tmp29_ = ma;
			_tmp30_ = vala_member_access_get_inner (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = vala_expression_get_value_type (_tmp31_);
			_tmp33_ = _tmp32_;
			_tmp25_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp33_, VALA_TYPE_ENUM_VALUE_TYPE);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			ValaMemberAccess* _tmp34_;
			ValaExpression* _tmp35_;
			ValaExpression* _tmp36_;
			ValaDataType* _tmp37_;
			ValaDataType* _tmp38_;
			ValaMethod* _tmp39_;
			ValaMethod* _tmp40_;
			ValaMethod* _tmp41_;
			_tmp34_ = ma;
			_tmp35_ = vala_member_access_get_inner (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = vala_expression_get_value_type (_tmp36_);
			_tmp38_ = _tmp37_;
			_tmp39_ = vala_enum_value_type_get_to_string_method (G_TYPE_CHECK_INSTANCE_CAST (_tmp38_, VALA_TYPE_ENUM_VALUE_TYPE, ValaEnumValueType));
			_tmp40_ = _tmp39_;
			_tmp41_ = m;
			_tmp24_ = _tmp40_ == _tmp41_;
			_vala_code_node_unref0 (_tmp40_);
		} else {
			_tmp24_ = FALSE;
		}
		if (_tmp24_) {
			ValaEnum* en = NULL;
			ValaMemberAccess* _tmp42_;
			ValaExpression* _tmp43_;
			ValaExpression* _tmp44_;
			ValaDataType* _tmp45_;
			ValaDataType* _tmp46_;
			ValaTypeSymbol* _tmp47_;
			ValaTypeSymbol* _tmp48_;
			ValaEnum* _tmp49_;
			ValaCCodeFunctionCall* _tmp50_;
			ValaEnum* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			ValaCCodeIdentifier* _tmp54_;
			ValaCCodeIdentifier* _tmp55_;
			_tmp42_ = ma;
			_tmp43_ = vala_member_access_get_inner (_tmp42_);
			_tmp44_ = _tmp43_;
			_tmp45_ = vala_expression_get_value_type (_tmp44_);
			_tmp46_ = _tmp45_;
			_tmp47_ = vala_data_type_get_data_type (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, VALA_TYPE_ENUM, ValaEnum));
			en = _tmp49_;
			_tmp50_ = ccall;
			_tmp51_ = en;
			_tmp52_ = vala_ccode_method_call_module_generate_enum_tostring_function (self, _tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = vala_ccode_identifier_new (_tmp53_);
			_tmp55_ = _tmp54_;
			vala_ccode_function_call_set_call (_tmp50_, (ValaCCodeExpression*) _tmp55_);
			_vala_ccode_node_unref0 (_tmp55_);
			_g_free0 (_tmp53_);
			_vala_code_node_unref0 (en);
		} else {
			gboolean _tmp56_;
			gboolean _tmp57_;
			_tmp56_ = vala_method_call_get_is_constructv_chainup (expr);
			_tmp57_ = _tmp56_;
			if (_tmp57_) {
				ValaCCodeFunctionCall* _tmp58_;
				ValaMethod* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				ValaCCodeIdentifier* _tmp62_;
				ValaCCodeIdentifier* _tmp63_;
				_tmp58_ = ccall;
				_tmp59_ = m;
				_tmp60_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp59_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
				_tmp61_ = _tmp60_;
				_tmp62_ = vala_ccode_identifier_new (_tmp61_);
				_tmp63_ = _tmp62_;
				vala_ccode_function_call_set_call (_tmp58_, (ValaCCodeExpression*) _tmp63_);
				_vala_ccode_node_unref0 (_tmp63_);
				_g_free0 (_tmp61_);
			}
		}
	} else {
		ValaDataType* _tmp64_;
		_tmp64_ = itype;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp64_, VALA_TYPE_SIGNAL_TYPE)) {
			ValaSignalType* sig_type = NULL;
			ValaDataType* _tmp65_;
			ValaSignalType* _tmp66_;
			gboolean _tmp67_ = FALSE;
			gboolean _tmp68_ = FALSE;
			ValaMemberAccess* _tmp69_;
			_tmp65_ = itype;
			_tmp66_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
			sig_type = _tmp66_;
			_tmp69_ = ma;
			if (_tmp69_ != NULL) {
				ValaMemberAccess* _tmp70_;
				ValaExpression* _tmp71_;
				ValaExpression* _tmp72_;
				_tmp70_ = ma;
				_tmp71_ = vala_member_access_get_inner (_tmp70_);
				_tmp72_ = _tmp71_;
				_tmp68_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_BASE_ACCESS);
			} else {
				_tmp68_ = FALSE;
			}
			if (_tmp68_) {
				ValaSignalType* _tmp73_;
				ValaSignal* _tmp74_;
				ValaSignal* _tmp75_;
				gboolean _tmp76_;
				gboolean _tmp77_;
				_tmp73_ = sig_type;
				_tmp74_ = vala_signal_type_get_signal_symbol (_tmp73_);
				_tmp75_ = _tmp74_;
				_tmp76_ = vala_signal_get_is_virtual (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp67_ = _tmp77_;
			} else {
				_tmp67_ = FALSE;
			}
			if (_tmp67_) {
				ValaSignalType* _tmp78_;
				ValaSignal* _tmp79_;
				ValaSignal* _tmp80_;
				ValaMethod* _tmp81_;
				ValaMethod* _tmp82_;
				ValaMethod* _tmp83_;
				_tmp78_ = sig_type;
				_tmp79_ = vala_signal_type_get_signal_symbol (_tmp78_);
				_tmp80_ = _tmp79_;
				_tmp81_ = vala_signal_get_default_handler (_tmp80_);
				_tmp82_ = _tmp81_;
				_tmp83_ = _vala_code_node_ref0 (_tmp82_);
				_vala_code_node_unref0 (m);
				m = _tmp83_;
			} else {
				ValaExpression* _tmp84_;
				ValaExpression* _tmp85_;
				ValaCCodeExpression* _tmp86_;
				_tmp84_ = vala_method_call_get_call (expr);
				_tmp85_ = _tmp84_;
				_tmp86_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp85_);
				_vala_ccode_node_unref0 (ccall);
				ccall = G_TYPE_CHECK_INSTANCE_CAST (_tmp86_, VALA_TYPE_CCODE_FUNCTION_CALL, ValaCCodeFunctionCall);
			}
			_vala_code_node_unref0 (sig_type);
		} else {
			ValaDataType* _tmp87_;
			_tmp87_ = itype;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp87_, VALA_TYPE_OBJECT_TYPE)) {
				ValaClass* cl = NULL;
				ValaDataType* _tmp88_;
				ValaObjectTypeSymbol* _tmp89_;
				ValaObjectTypeSymbol* _tmp90_;
				ValaClass* _tmp91_;
				ValaClass* _tmp92_;
				ValaCreationMethod* _tmp93_;
				ValaCreationMethod* _tmp94_;
				ValaMethod* _tmp95_;
				ValaMethod* _tmp96_;
				ValaCCodeFile* _tmp97_;
				gchar* real_name = NULL;
				ValaMethod* _tmp98_;
				gchar* _tmp99_;
				gboolean _tmp100_;
				gboolean _tmp101_;
				const gchar* _tmp104_;
				ValaCCodeIdentifier* _tmp105_;
				ValaCCodeIdentifier* _tmp106_;
				ValaCCodeFunctionCall* _tmp107_;
				_tmp88_ = itype;
				_tmp89_ = vala_object_type_get_type_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp88_, VALA_TYPE_OBJECT_TYPE, ValaObjectType));
				_tmp90_ = _tmp89_;
				_tmp91_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp90_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp91_;
				_tmp92_ = cl;
				_tmp93_ = vala_class_get_default_construction_method (_tmp92_);
				_tmp94_ = _tmp93_;
				_tmp95_ = _vala_code_node_ref0 ((ValaMethod*) _tmp94_);
				_vala_code_node_unref0 (m);
				m = _tmp95_;
				_tmp96_ = m;
				_tmp97_ = ((ValaCCodeBaseModule*) self)->cfile;
				vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp96_, _tmp97_);
				_tmp98_ = m;
				_tmp99_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp98_);
				real_name = _tmp99_;
				_tmp100_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp101_ = _tmp100_;
				if (_tmp101_) {
					ValaMethod* _tmp102_;
					gchar* _tmp103_;
					_tmp102_ = m;
					_tmp103_ = vala_get_ccode_constructv_name (G_TYPE_CHECK_INSTANCE_CAST (_tmp102_, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
					_g_free0 (real_name);
					real_name = _tmp103_;
				}
				_tmp104_ = real_name;
				_tmp105_ = vala_ccode_identifier_new (_tmp104_);
				_tmp106_ = _tmp105_;
				_tmp107_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp106_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp107_;
				_vala_ccode_node_unref0 (_tmp106_);
				_g_free0 (real_name);
				_vala_code_node_unref0 (cl);
			} else {
				ValaDataType* _tmp108_;
				_tmp108_ = itype;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp108_, VALA_TYPE_STRUCT_VALUE_TYPE)) {
					ValaStruct* st = NULL;
					ValaDataType* _tmp109_;
					ValaTypeSymbol* _tmp110_;
					ValaTypeSymbol* _tmp111_;
					ValaStruct* _tmp112_;
					ValaStruct* _tmp113_;
					ValaMethod* _tmp114_;
					ValaMethod* _tmp115_;
					ValaMethod* _tmp116_;
					ValaMethod* _tmp117_;
					ValaCCodeFile* _tmp118_;
					ValaMethod* _tmp119_;
					gchar* _tmp120_;
					gchar* _tmp121_;
					ValaCCodeIdentifier* _tmp122_;
					ValaCCodeIdentifier* _tmp123_;
					ValaCCodeFunctionCall* _tmp124_;
					_tmp109_ = itype;
					_tmp110_ = vala_value_type_get_type_symbol ((ValaValueType*) G_TYPE_CHECK_INSTANCE_CAST (_tmp109_, VALA_TYPE_STRUCT_VALUE_TYPE, ValaStructValueType));
					_tmp111_ = _tmp110_;
					_tmp112_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp111_, VALA_TYPE_STRUCT, ValaStruct));
					st = _tmp112_;
					_tmp113_ = st;
					_tmp114_ = vala_struct_get_default_construction_method (_tmp113_);
					_tmp115_ = _tmp114_;
					_tmp116_ = _vala_code_node_ref0 (_tmp115_);
					_vala_code_node_unref0 (m);
					m = _tmp116_;
					_tmp117_ = m;
					_tmp118_ = ((ValaCCodeBaseModule*) self)->cfile;
					vala_ccode_base_module_generate_method_declaration ((ValaCCodeBaseModule*) self, _tmp117_, _tmp118_);
					_tmp119_ = m;
					_tmp120_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp119_);
					_tmp121_ = _tmp120_;
					_tmp122_ = vala_ccode_identifier_new (_tmp121_);
					_tmp123_ = _tmp122_;
					_tmp124_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp123_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp124_;
					_vala_ccode_node_unref0 (_tmp123_);
					_g_free0 (_tmp121_);
					_vala_code_node_unref0 (st);
				} else {
					ValaDataType* _tmp125_;
					_tmp125_ = itype;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp125_, VALA_TYPE_DELEGATE_TYPE)) {
						ValaDataType* _tmp126_;
						ValaDelegate* _tmp127_;
						ValaDelegate* _tmp128_;
						ValaDelegate* _tmp129_;
						_tmp126_ = itype;
						_tmp127_ = vala_delegate_type_get_delegate_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp126_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
						_tmp128_ = _tmp127_;
						_tmp129_ = _vala_code_node_ref0 (_tmp128_);
						_vala_code_node_unref0 (deleg);
						deleg = _tmp129_;
					}
				}
			}
		}
	}
	_tmp130_ = g_direct_hash;
	_tmp131_ = g_direct_equal;
	_tmp132_ = g_direct_equal;
	_tmp133_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp130_, _tmp131_, _tmp132_);
	in_arg_map = _tmp133_;
	_tmp134_ = in_arg_map;
	_tmp135_ = _vala_map_ref0 (_tmp134_);
	out_arg_map = _tmp135_;
	_tmp137_ = m;
	if (_tmp137_ != NULL) {
		ValaMethod* _tmp138_;
		gboolean _tmp139_;
		gboolean _tmp140_;
		_tmp138_ = m;
		_tmp139_ = vala_method_get_coroutine (_tmp138_);
		_tmp140_ = _tmp139_;
		_tmp136_ = _tmp140_;
	} else {
		_tmp136_ = FALSE;
	}
	if (_tmp136_) {
		ValaMethod* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		ValaCCodeIdentifier* _tmp144_;
		ValaCCodeIdentifier* _tmp145_;
		ValaCCodeFunctionCall* _tmp146_;
		ValaMethod* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		ValaCCodeIdentifier* _tmp150_;
		ValaCCodeIdentifier* _tmp151_;
		ValaCCodeFunctionCall* _tmp152_;
		ValaMemberAccess* _tmp153_;
		ValaExpression* _tmp154_;
		ValaExpression* _tmp155_;
		gboolean _tmp233_ = FALSE;
		ValaMemberAccess* _tmp234_;
		const gchar* _tmp235_;
		const gchar* _tmp236_;
		_tmp141_ = m;
		_tmp142_ = vala_get_ccode_name ((ValaCodeNode*) _tmp141_);
		_tmp143_ = _tmp142_;
		_tmp144_ = vala_ccode_identifier_new (_tmp143_);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp145_);
		_vala_ccode_node_unref0 (async_call);
		async_call = _tmp146_;
		_vala_ccode_node_unref0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = m;
		_tmp148_ = vala_get_ccode_finish_name (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = vala_ccode_identifier_new (_tmp149_);
		_tmp151_ = _tmp150_;
		_tmp152_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp151_);
		_vala_ccode_node_unref0 (finish_call);
		finish_call = _tmp152_;
		_vala_ccode_node_unref0 (_tmp151_);
		_g_free0 (_tmp149_);
		_tmp153_ = ma;
		_tmp154_ = vala_member_access_get_inner (_tmp153_);
		_tmp155_ = _tmp154_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp155_, VALA_TYPE_BASE_ACCESS)) {
			ValaMethod* _tmp156_;
			ValaMethod* _tmp157_;
			ValaMethod* _tmp158_;
			_tmp156_ = m;
			_tmp157_ = vala_method_get_base_method (_tmp156_);
			_tmp158_ = _tmp157_;
			if (_tmp158_ != NULL) {
				ValaClass* base_class = NULL;
				ValaMethod* _tmp159_;
				ValaMethod* _tmp160_;
				ValaMethod* _tmp161_;
				ValaSymbol* _tmp162_;
				ValaSymbol* _tmp163_;
				ValaClass* _tmp164_;
				ValaCCodeFunctionCall* vcast = NULL;
				ValaClass* _tmp165_;
				gchar* _tmp166_;
				gchar* _tmp167_;
				gchar* _tmp168_;
				gchar* _tmp169_;
				ValaCCodeIdentifier* _tmp170_;
				ValaCCodeIdentifier* _tmp171_;
				ValaCCodeFunctionCall* _tmp172_;
				ValaCCodeFunctionCall* _tmp173_;
				ValaCCodeFunctionCall* _tmp174_;
				ValaClass* _tmp175_;
				ValaClass* _tmp176_;
				gchar* _tmp177_;
				gchar* _tmp178_;
				gchar* _tmp179_;
				gchar* _tmp180_;
				ValaCCodeIdentifier* _tmp181_;
				ValaCCodeIdentifier* _tmp182_;
				ValaCCodeFunctionCall* _tmp183_;
				ValaCCodeFunctionCall* _tmp184_;
				ValaMethod* _tmp185_;
				gchar* _tmp186_;
				gchar* _tmp187_;
				ValaCCodeMemberAccess* _tmp188_;
				ValaCCodeMemberAccess* _tmp189_;
				ValaCCodeFunctionCall* _tmp190_;
				ValaCCodeFunctionCall* _tmp191_;
				ValaMethod* _tmp192_;
				gchar* _tmp193_;
				gchar* _tmp194_;
				ValaCCodeMemberAccess* _tmp195_;
				ValaCCodeMemberAccess* _tmp196_;
				_tmp159_ = m;
				_tmp160_ = vala_method_get_base_method (_tmp159_);
				_tmp161_ = _tmp160_;
				_tmp162_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp161_);
				_tmp163_ = _tmp162_;
				_tmp164_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp163_, VALA_TYPE_CLASS, ValaClass));
				base_class = _tmp164_;
				_tmp165_ = base_class;
				_tmp166_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp165_, NULL);
				_tmp167_ = _tmp166_;
				_tmp168_ = g_strdup_printf ("%s_CLASS", _tmp167_);
				_tmp169_ = _tmp168_;
				_tmp170_ = vala_ccode_identifier_new (_tmp169_);
				_tmp171_ = _tmp170_;
				_tmp172_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp171_);
				_tmp173_ = _tmp172_;
				_vala_ccode_node_unref0 (_tmp171_);
				_g_free0 (_tmp169_);
				_g_free0 (_tmp167_);
				vcast = _tmp173_;
				_tmp174_ = vcast;
				_tmp175_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp176_ = _tmp175_;
				_tmp177_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp176_, NULL);
				_tmp178_ = _tmp177_;
				_tmp179_ = g_strdup_printf ("%s_parent_class", _tmp178_);
				_tmp180_ = _tmp179_;
				_tmp181_ = vala_ccode_identifier_new (_tmp180_);
				_tmp182_ = _tmp181_;
				vala_ccode_function_call_add_argument (_tmp174_, (ValaCCodeExpression*) _tmp182_);
				_vala_ccode_node_unref0 (_tmp182_);
				_g_free0 (_tmp180_);
				_g_free0 (_tmp178_);
				_tmp183_ = async_call;
				_tmp184_ = vcast;
				_tmp185_ = m;
				_tmp186_ = vala_get_ccode_vfunc_name (_tmp185_);
				_tmp187_ = _tmp186_;
				_tmp188_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp184_, _tmp187_);
				_tmp189_ = _tmp188_;
				vala_ccode_function_call_set_call (_tmp183_, (ValaCCodeExpression*) _tmp189_);
				_vala_ccode_node_unref0 (_tmp189_);
				_g_free0 (_tmp187_);
				_tmp190_ = finish_call;
				_tmp191_ = vcast;
				_tmp192_ = m;
				_tmp193_ = vala_get_ccode_finish_vfunc_name (_tmp192_);
				_tmp194_ = _tmp193_;
				_tmp195_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp191_, _tmp194_);
				_tmp196_ = _tmp195_;
				vala_ccode_function_call_set_call (_tmp190_, (ValaCCodeExpression*) _tmp196_);
				_vala_ccode_node_unref0 (_tmp196_);
				_g_free0 (_tmp194_);
				_vala_ccode_node_unref0 (vcast);
				_vala_code_node_unref0 (base_class);
			} else {
				ValaMethod* _tmp197_;
				ValaMethod* _tmp198_;
				ValaMethod* _tmp199_;
				_tmp197_ = m;
				_tmp198_ = vala_method_get_base_interface_method (_tmp197_);
				_tmp199_ = _tmp198_;
				if (_tmp199_ != NULL) {
					ValaInterface* base_iface = NULL;
					ValaMethod* _tmp200_;
					ValaMethod* _tmp201_;
					ValaMethod* _tmp202_;
					ValaSymbol* _tmp203_;
					ValaSymbol* _tmp204_;
					ValaInterface* _tmp205_;
					gchar* parent_iface_var = NULL;
					ValaClass* _tmp206_;
					ValaClass* _tmp207_;
					gchar* _tmp208_;
					gchar* _tmp209_;
					ValaInterface* _tmp210_;
					gchar* _tmp211_;
					gchar* _tmp212_;
					gchar* _tmp213_;
					gchar* _tmp214_;
					ValaCCodeFunctionCall* _tmp215_;
					const gchar* _tmp216_;
					ValaCCodeIdentifier* _tmp217_;
					ValaCCodeIdentifier* _tmp218_;
					ValaMethod* _tmp219_;
					gchar* _tmp220_;
					gchar* _tmp221_;
					ValaCCodeMemberAccess* _tmp222_;
					ValaCCodeMemberAccess* _tmp223_;
					ValaCCodeFunctionCall* _tmp224_;
					const gchar* _tmp225_;
					ValaCCodeIdentifier* _tmp226_;
					ValaCCodeIdentifier* _tmp227_;
					ValaMethod* _tmp228_;
					gchar* _tmp229_;
					gchar* _tmp230_;
					ValaCCodeMemberAccess* _tmp231_;
					ValaCCodeMemberAccess* _tmp232_;
					_tmp200_ = m;
					_tmp201_ = vala_method_get_base_interface_method (_tmp200_);
					_tmp202_ = _tmp201_;
					_tmp203_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp202_);
					_tmp204_ = _tmp203_;
					_tmp205_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp204_, VALA_TYPE_INTERFACE, ValaInterface));
					base_iface = _tmp205_;
					_tmp206_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp207_ = _tmp206_;
					_tmp208_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp207_, NULL);
					_tmp209_ = _tmp208_;
					_tmp210_ = base_iface;
					_tmp211_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp210_, NULL);
					_tmp212_ = _tmp211_;
					_tmp213_ = g_strdup_printf ("%s_%s_parent_iface", _tmp209_, _tmp212_);
					_tmp214_ = _tmp213_;
					_g_free0 (_tmp212_);
					_g_free0 (_tmp209_);
					parent_iface_var = _tmp214_;
					_tmp215_ = async_call;
					_tmp216_ = parent_iface_var;
					_tmp217_ = vala_ccode_identifier_new (_tmp216_);
					_tmp218_ = _tmp217_;
					_tmp219_ = m;
					_tmp220_ = vala_get_ccode_vfunc_name (_tmp219_);
					_tmp221_ = _tmp220_;
					_tmp222_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp218_, _tmp221_);
					_tmp223_ = _tmp222_;
					vala_ccode_function_call_set_call (_tmp215_, (ValaCCodeExpression*) _tmp223_);
					_vala_ccode_node_unref0 (_tmp223_);
					_g_free0 (_tmp221_);
					_vala_ccode_node_unref0 (_tmp218_);
					_tmp224_ = finish_call;
					_tmp225_ = parent_iface_var;
					_tmp226_ = vala_ccode_identifier_new (_tmp225_);
					_tmp227_ = _tmp226_;
					_tmp228_ = m;
					_tmp229_ = vala_get_ccode_finish_vfunc_name (_tmp228_);
					_tmp230_ = _tmp229_;
					_tmp231_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp227_, _tmp230_);
					_tmp232_ = _tmp231_;
					vala_ccode_function_call_set_call (_tmp224_, (ValaCCodeExpression*) _tmp232_);
					_vala_ccode_node_unref0 (_tmp232_);
					_g_free0 (_tmp230_);
					_vala_ccode_node_unref0 (_tmp227_);
					_g_free0 (parent_iface_var);
					_vala_code_node_unref0 (base_iface);
				}
			}
		}
		_tmp234_ = ma;
		_tmp235_ = vala_member_access_get_member_name (_tmp234_);
		_tmp236_ = _tmp235_;
		if (g_strcmp0 (_tmp236_, "begin") == 0) {
			ValaMemberAccess* _tmp237_;
			ValaExpression* _tmp238_;
			ValaExpression* _tmp239_;
			ValaSymbol* _tmp240_;
			ValaSymbol* _tmp241_;
			ValaMemberAccess* _tmp242_;
			ValaSymbol* _tmp243_;
			ValaSymbol* _tmp244_;
			_tmp237_ = ma;
			_tmp238_ = vala_member_access_get_inner (_tmp237_);
			_tmp239_ = _tmp238_;
			_tmp240_ = vala_expression_get_symbol_reference (_tmp239_);
			_tmp241_ = _tmp240_;
			_tmp242_ = ma;
			_tmp243_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp242_);
			_tmp244_ = _tmp243_;
			_tmp233_ = _tmp241_ == _tmp244_;
		} else {
			_tmp233_ = FALSE;
		}
		if (_tmp233_) {
			ValaCCodeFunctionCall* _tmp245_;
			ValaCCodeFunctionCall* _tmp246_;
			ValaMethod* _tmp247_;
			ValaList* _tmp248_;
			_tmp245_ = async_call;
			_tmp246_ = _vala_ccode_node_ref0 (_tmp245_);
			_vala_ccode_node_unref0 (ccall);
			ccall = _tmp246_;
			_tmp247_ = m;
			_tmp248_ = vala_method_get_async_begin_parameters (_tmp247_);
			_vala_iterable_unref0 (params);
			params = _tmp248_;
		} else {
			gboolean _tmp249_ = FALSE;
			ValaMemberAccess* _tmp250_;
			const gchar* _tmp251_;
			const gchar* _tmp252_;
			_tmp250_ = ma;
			_tmp251_ = vala_member_access_get_member_name (_tmp250_);
			_tmp252_ = _tmp251_;
			if (g_strcmp0 (_tmp252_, "end") == 0) {
				ValaMemberAccess* _tmp253_;
				ValaExpression* _tmp254_;
				ValaExpression* _tmp255_;
				ValaSymbol* _tmp256_;
				ValaSymbol* _tmp257_;
				ValaMemberAccess* _tmp258_;
				ValaSymbol* _tmp259_;
				ValaSymbol* _tmp260_;
				_tmp253_ = ma;
				_tmp254_ = vala_member_access_get_inner (_tmp253_);
				_tmp255_ = _tmp254_;
				_tmp256_ = vala_expression_get_symbol_reference (_tmp255_);
				_tmp257_ = _tmp256_;
				_tmp258_ = ma;
				_tmp259_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp258_);
				_tmp260_ = _tmp259_;
				_tmp249_ = _tmp257_ == _tmp260_;
			} else {
				_tmp249_ = FALSE;
			}
			if (_tmp249_) {
				ValaCCodeFunctionCall* _tmp261_;
				ValaCCodeFunctionCall* _tmp262_;
				ValaMethod* _tmp263_;
				ValaList* _tmp264_;
				_tmp261_ = finish_call;
				_tmp262_ = _vala_ccode_node_ref0 (_tmp261_);
				_vala_ccode_node_unref0 (ccall);
				ccall = _tmp262_;
				_tmp263_ = m;
				_tmp264_ = vala_method_get_async_end_parameters (_tmp263_);
				_vala_iterable_unref0 (params);
				params = _tmp264_;
			} else {
				gboolean _tmp265_;
				gboolean _tmp266_;
				_tmp265_ = vala_method_call_get_is_yield_expression (expr);
				_tmp266_ = _tmp265_;
				if (!_tmp266_) {
					ValaCCodeFunctionCall* _tmp267_;
					ValaCCodeFunctionCall* _tmp268_;
					ValaMethod* _tmp269_;
					ValaList* _tmp270_;
					_tmp267_ = async_call;
					_tmp268_ = _vala_ccode_node_ref0 (_tmp267_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp268_;
					_tmp269_ = m;
					_tmp270_ = vala_method_get_async_begin_parameters (_tmp269_);
					_vala_iterable_unref0 (params);
					params = _tmp270_;
				} else {
					ValaCCodeFunctionCall* _tmp271_;
					ValaCCodeFunctionCall* _tmp272_;
					GHashFunc _tmp273_;
					GEqualFunc _tmp274_;
					GEqualFunc _tmp275_;
					ValaHashMap* _tmp276_;
					ValaHashMap* _tmp277_;
					ValaMethod* _tmp278_;
					ValaCCodeIdentifier* _tmp279_;
					ValaCCodeIdentifier* _tmp280_;
					ValaCCodeMemberAccess* _tmp281_;
					ValaCCodeMemberAccess* _tmp282_;
					_tmp271_ = finish_call;
					_tmp272_ = _vala_ccode_node_ref0 (_tmp271_);
					_vala_ccode_node_unref0 (ccall);
					ccall = _tmp272_;
					_tmp273_ = g_direct_hash;
					_tmp274_ = g_direct_equal;
					_tmp275_ = g_direct_equal;
					_tmp276_ = vala_hash_map_new (G_TYPE_INT, NULL, NULL, VALA_TYPE_CCODE_EXPRESSION, (GBoxedCopyFunc) vala_ccode_node_ref, (GDestroyNotify) vala_ccode_node_unref, _tmp273_, _tmp274_, _tmp275_);
					_vala_map_unref0 (out_arg_map);
					out_arg_map = _tmp276_;
					_tmp277_ = out_arg_map;
					_tmp278_ = m;
					_tmp279_ = vala_ccode_identifier_new ("_data_");
					_tmp280_ = _tmp279_;
					_tmp281_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp280_, "_res_");
					_tmp282_ = _tmp281_;
					vala_map_set ((ValaMap*) _tmp277_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_async_result_pos (_tmp278_), FALSE)), (ValaCCodeExpression*) _tmp282_);
					_vala_ccode_node_unref0 (_tmp282_);
					_vala_ccode_node_unref0 (_tmp280_);
				}
			}
		}
	}
	_tmp284_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp284_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp285_;
		ValaSymbol* _tmp286_;
		ValaSymbol* _tmp287_;
		_tmp285_ = m;
		_tmp286_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp285_);
		_tmp287_ = _tmp286_;
		_tmp283_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp287_, VALA_TYPE_CLASS);
	} else {
		_tmp283_ = FALSE;
	}
	if (_tmp283_) {
		ValaMethod* _tmp288_;
		ValaSymbol* _tmp289_;
		ValaSymbol* _tmp290_;
		gboolean _tmp291_;
		gboolean _tmp292_;
		ValaClass* _tmp296_;
		ValaClass* _tmp297_;
		gboolean _tmp298_;
		gboolean _tmp299_;
		_tmp288_ = m;
		_tmp289_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp288_);
		_tmp290_ = _tmp289_;
		_tmp291_ = vala_class_get_is_compact (G_TYPE_CHECK_INSTANCE_CAST (_tmp290_, VALA_TYPE_CLASS, ValaClass));
		_tmp292_ = _tmp291_;
		if (!_tmp292_) {
			ValaCCodeFunctionCall* _tmp293_;
			ValaCCodeExpression* _tmp294_;
			ValaCCodeExpression* _tmp295_;
			_tmp293_ = ccall;
			_tmp294_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "object_type");
			_tmp295_ = _tmp294_;
			vala_ccode_function_call_add_argument (_tmp293_, _tmp295_);
			_vala_ccode_node_unref0 (_tmp295_);
		}
		_tmp296_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp297_ = _tmp296_;
		_tmp298_ = vala_class_get_is_compact (_tmp297_);
		_tmp299_ = _tmp298_;
		if (!_tmp299_) {
			ValaClass* _tmp300_;
			ValaClass* _tmp301_;
			ValaMethod* _tmp302_;
			ValaSymbol* _tmp303_;
			ValaSymbol* _tmp304_;
			_tmp300_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp301_ = _tmp300_;
			_tmp302_ = m;
			_tmp303_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp302_);
			_tmp304_ = _tmp303_;
			if (G_TYPE_CHECK_INSTANCE_CAST (_tmp301_, VALA_TYPE_SYMBOL, ValaSymbol) != _tmp304_) {
				{
					ValaList* _base_type_list = NULL;
					ValaClass* _tmp305_;
					ValaClass* _tmp306_;
					ValaList* _tmp307_;
					gint _base_type_size = 0;
					ValaList* _tmp308_;
					gint _tmp309_;
					gint _tmp310_;
					gint _base_type_index = 0;
					_tmp305_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp306_ = _tmp305_;
					_tmp307_ = vala_class_get_base_types (_tmp306_);
					_base_type_list = _tmp307_;
					_tmp308_ = _base_type_list;
					_tmp309_ = vala_collection_get_size ((ValaCollection*) _tmp308_);
					_tmp310_ = _tmp309_;
					_base_type_size = _tmp310_;
					_base_type_index = -1;
					while (TRUE) {
						gint _tmp311_;
						gint _tmp312_;
						gint _tmp313_;
						ValaDataType* base_type = NULL;
						ValaList* _tmp314_;
						gint _tmp315_;
						gpointer _tmp316_;
						ValaDataType* _tmp317_;
						ValaTypeSymbol* _tmp318_;
						ValaTypeSymbol* _tmp319_;
						_tmp311_ = _base_type_index;
						_base_type_index = _tmp311_ + 1;
						_tmp312_ = _base_type_index;
						_tmp313_ = _base_type_size;
						if (!(_tmp312_ < _tmp313_)) {
							break;
						}
						_tmp314_ = _base_type_list;
						_tmp315_ = _base_type_index;
						_tmp316_ = vala_list_get (_tmp314_, _tmp315_);
						base_type = (ValaDataType*) _tmp316_;
						_tmp317_ = base_type;
						_tmp318_ = vala_data_type_get_data_type (_tmp317_);
						_tmp319_ = _tmp318_;
						if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp319_, VALA_TYPE_CLASS)) {
							ValaList* type_parameters = NULL;
							ValaMethod* _tmp320_;
							gchar* _tmp321_;
							gchar* _tmp322_;
							gboolean _tmp323_;
							ValaHashMap* _tmp328_;
							ValaDataType* _tmp329_;
							ValaList* _tmp330_;
							ValaList* _tmp331_;
							ValaList* _tmp332_;
							type_parameters = NULL;
							_tmp320_ = m;
							_tmp321_ = vala_get_ccode_real_name ((ValaSymbol*) _tmp320_);
							_tmp322_ = _tmp321_;
							_tmp323_ = g_strcmp0 (_tmp322_, "g_object_new") == 0;
							_g_free0 (_tmp322_);
							if (_tmp323_) {
								ValaDataType* _tmp324_;
								ValaTypeSymbol* _tmp325_;
								ValaTypeSymbol* _tmp326_;
								ValaList* _tmp327_;
								_tmp324_ = base_type;
								_tmp325_ = vala_data_type_get_data_type (_tmp324_);
								_tmp326_ = _tmp325_;
								_tmp327_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) G_TYPE_CHECK_INSTANCE_CAST (_tmp326_, VALA_TYPE_CLASS, ValaClass));
								_vala_iterable_unref0 (type_parameters);
								type_parameters = _tmp327_;
							}
							_tmp328_ = in_arg_map;
							_tmp329_ = base_type;
							_tmp330_ = vala_data_type_get_type_arguments (_tmp329_);
							_tmp331_ = _tmp330_;
							_tmp332_ = type_parameters;
							vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp328_, _tmp331_, (ValaCodeNode*) expr, TRUE, _tmp332_);
							_vala_iterable_unref0 (_tmp331_);
							_vala_iterable_unref0 (type_parameters);
							_vala_code_node_unref0 (base_type);
							break;
						}
						_vala_code_node_unref0 (base_type);
					}
					_vala_iterable_unref0 (_base_type_list);
				}
			} else {
				gint type_param_index = 0;
				ValaClass* cl = NULL;
				ValaMethod* _tmp333_;
				ValaSymbol* _tmp334_;
				ValaSymbol* _tmp335_;
				ValaClass* _tmp336_;
				type_param_index = 0;
				_tmp333_ = m;
				_tmp334_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp333_);
				_tmp335_ = _tmp334_;
				_tmp336_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp335_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp336_;
				{
					ValaList* _type_param_list = NULL;
					ValaClass* _tmp337_;
					ValaList* _tmp338_;
					gint _type_param_size = 0;
					ValaList* _tmp339_;
					gint _tmp340_;
					gint _tmp341_;
					gint _type_param_index = 0;
					_tmp337_ = cl;
					_tmp338_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp337_);
					_type_param_list = _tmp338_;
					_tmp339_ = _type_param_list;
					_tmp340_ = vala_collection_get_size ((ValaCollection*) _tmp339_);
					_tmp341_ = _tmp340_;
					_type_param_size = _tmp341_;
					_type_param_index = -1;
					while (TRUE) {
						gint _tmp342_;
						gint _tmp343_;
						gint _tmp344_;
						ValaTypeParameter* type_param = NULL;
						ValaList* _tmp345_;
						gint _tmp346_;
						gpointer _tmp347_;
						ValaHashMap* _tmp348_;
						gint _tmp349_;
						ValaTypeParameter* _tmp350_;
						const gchar* _tmp351_;
						const gchar* _tmp352_;
						gchar* _tmp353_;
						gchar* _tmp354_;
						gchar* _tmp355_;
						gchar* _tmp356_;
						ValaCCodeIdentifier* _tmp357_;
						ValaCCodeIdentifier* _tmp358_;
						ValaHashMap* _tmp359_;
						gint _tmp360_;
						ValaTypeParameter* _tmp361_;
						const gchar* _tmp362_;
						const gchar* _tmp363_;
						gchar* _tmp364_;
						gchar* _tmp365_;
						gchar* _tmp366_;
						gchar* _tmp367_;
						ValaCCodeIdentifier* _tmp368_;
						ValaCCodeIdentifier* _tmp369_;
						ValaHashMap* _tmp370_;
						gint _tmp371_;
						ValaTypeParameter* _tmp372_;
						const gchar* _tmp373_;
						const gchar* _tmp374_;
						gchar* _tmp375_;
						gchar* _tmp376_;
						gchar* _tmp377_;
						gchar* _tmp378_;
						ValaCCodeIdentifier* _tmp379_;
						ValaCCodeIdentifier* _tmp380_;
						gint _tmp381_;
						_tmp342_ = _type_param_index;
						_type_param_index = _tmp342_ + 1;
						_tmp343_ = _type_param_index;
						_tmp344_ = _type_param_size;
						if (!(_tmp343_ < _tmp344_)) {
							break;
						}
						_tmp345_ = _type_param_list;
						_tmp346_ = _type_param_index;
						_tmp347_ = vala_list_get (_tmp345_, _tmp346_);
						type_param = (ValaTypeParameter*) _tmp347_;
						_tmp348_ = in_arg_map;
						_tmp349_ = type_param_index;
						_tmp350_ = type_param;
						_tmp351_ = vala_symbol_get_name ((ValaSymbol*) _tmp350_);
						_tmp352_ = _tmp351_;
						_tmp353_ = g_utf8_strdown (_tmp352_, (gssize) -1);
						_tmp354_ = _tmp353_;
						_tmp355_ = g_strdup_printf ("%s_type", _tmp354_);
						_tmp356_ = _tmp355_;
						_tmp357_ = vala_ccode_identifier_new (_tmp356_);
						_tmp358_ = _tmp357_;
						vala_map_set ((ValaMap*) _tmp348_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp349_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp358_);
						_vala_ccode_node_unref0 (_tmp358_);
						_g_free0 (_tmp356_);
						_g_free0 (_tmp354_);
						_tmp359_ = in_arg_map;
						_tmp360_ = type_param_index;
						_tmp361_ = type_param;
						_tmp362_ = vala_symbol_get_name ((ValaSymbol*) _tmp361_);
						_tmp363_ = _tmp362_;
						_tmp364_ = g_utf8_strdown (_tmp363_, (gssize) -1);
						_tmp365_ = _tmp364_;
						_tmp366_ = g_strdup_printf ("%s_dup_func", _tmp365_);
						_tmp367_ = _tmp366_;
						_tmp368_ = vala_ccode_identifier_new (_tmp367_);
						_tmp369_ = _tmp368_;
						vala_map_set ((ValaMap*) _tmp359_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp360_) + 0.02, FALSE)), (ValaCCodeExpression*) _tmp369_);
						_vala_ccode_node_unref0 (_tmp369_);
						_g_free0 (_tmp367_);
						_g_free0 (_tmp365_);
						_tmp370_ = in_arg_map;
						_tmp371_ = type_param_index;
						_tmp372_ = type_param;
						_tmp373_ = vala_symbol_get_name ((ValaSymbol*) _tmp372_);
						_tmp374_ = _tmp373_;
						_tmp375_ = g_utf8_strdown (_tmp374_, (gssize) -1);
						_tmp376_ = _tmp375_;
						_tmp377_ = g_strdup_printf ("%s_destroy_func", _tmp376_);
						_tmp378_ = _tmp377_;
						_tmp379_ = vala_ccode_identifier_new (_tmp378_);
						_tmp380_ = _tmp379_;
						vala_map_set ((ValaMap*) _tmp370_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (0.1 * _tmp371_) + 0.03, FALSE)), (ValaCCodeExpression*) _tmp380_);
						_vala_ccode_node_unref0 (_tmp380_);
						_g_free0 (_tmp378_);
						_g_free0 (_tmp376_);
						_tmp381_ = type_param_index;
						type_param_index = _tmp381_ + 1;
						_vala_code_node_unref0 (type_param);
					}
					_vala_iterable_unref0 (_type_param_list);
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			ValaClass* _tmp382_;
			ValaClass* _tmp383_;
			ValaClass* _tmp384_;
			ValaClass* _tmp385_;
			ValaClass* _tmp386_;
			_tmp382_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp383_ = _tmp382_;
			_tmp384_ = vala_class_get_base_class (_tmp383_);
			_tmp385_ = _tmp384_;
			_tmp386_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			if (_tmp385_ == _tmp386_) {
				gchar* class_prefix = NULL;
				ValaClass* _tmp387_;
				ValaClass* _tmp388_;
				gchar* _tmp389_;
				ValaCCodeDeclaration* funcs = NULL;
				ValaCCodeDeclaration* _tmp390_;
				ValaCCodeDeclaration* _tmp391_;
				ValaCCodeDeclaration* _tmp392_;
				const gchar* _tmp393_;
				const gchar* _tmp394_;
				const gchar* _tmp395_;
				const gchar* _tmp396_;
				gchar* _tmp397_;
				gchar* _tmp398_;
				ValaCCodeConstant* _tmp399_;
				ValaCCodeConstant* _tmp400_;
				ValaCCodeVariableDeclarator* _tmp401_;
				ValaCCodeVariableDeclarator* _tmp402_;
				ValaCCodeFunction* _tmp403_;
				ValaCCodeFunction* _tmp404_;
				ValaCCodeDeclaration* _tmp405_;
				ValaCCodeFunctionCall* _tmp406_;
				ValaCCodeIdentifier* _tmp407_;
				ValaCCodeIdentifier* _tmp408_;
				ValaCCodeUnaryExpression* _tmp409_;
				ValaCCodeUnaryExpression* _tmp410_;
				ValaCCodeCastExpression* _tmp411_;
				ValaCCodeCastExpression* _tmp412_;
				ValaCCodeFunctionCall* csizeof = NULL;
				ValaCCodeIdentifier* _tmp413_;
				ValaCCodeIdentifier* _tmp414_;
				ValaCCodeFunctionCall* _tmp415_;
				ValaCCodeFunctionCall* _tmp416_;
				ValaCCodeFunctionCall* _tmp417_;
				ValaClass* _tmp418_;
				ValaClass* _tmp419_;
				gchar* _tmp420_;
				gchar* _tmp421_;
				ValaCCodeIdentifier* _tmp422_;
				ValaCCodeIdentifier* _tmp423_;
				ValaCCodeFunctionCall* _tmp424_;
				ValaCCodeFunctionCall* _tmp425_;
				_tmp387_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp388_ = _tmp387_;
				_tmp389_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp388_, NULL);
				class_prefix = _tmp389_;
				_tmp390_ = vala_ccode_declaration_new ("const GSourceFuncs");
				funcs = _tmp390_;
				_tmp391_ = funcs;
				vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp391_, VALA_CCODE_MODIFIERS_STATIC);
				_tmp392_ = funcs;
				_tmp393_ = class_prefix;
				_tmp394_ = class_prefix;
				_tmp395_ = class_prefix;
				_tmp396_ = class_prefix;
				_tmp397_ = g_strdup_printf ("{ %s_real_prepare, %s_real_check, %s_real_dispatch, %s_finalize}", _tmp393_, _tmp394_, _tmp395_, _tmp396_);
				_tmp398_ = _tmp397_;
				_tmp399_ = vala_ccode_constant_new (_tmp398_);
				_tmp400_ = _tmp399_;
				_tmp401_ = vala_ccode_variable_declarator_new ("_source_funcs", (ValaCCodeExpression*) _tmp400_, NULL);
				_tmp402_ = _tmp401_;
				vala_ccode_declaration_add_declarator (_tmp392_, (ValaCCodeDeclarator*) _tmp402_);
				_vala_ccode_node_unref0 (_tmp402_);
				_vala_ccode_node_unref0 (_tmp400_);
				_g_free0 (_tmp398_);
				_tmp403_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp404_ = _tmp403_;
				_tmp405_ = funcs;
				vala_ccode_function_add_statement (_tmp404_, (ValaCCodeNode*) _tmp405_);
				_tmp406_ = ccall;
				_tmp407_ = vala_ccode_identifier_new ("_source_funcs");
				_tmp408_ = _tmp407_;
				_tmp409_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, (ValaCCodeExpression*) _tmp408_);
				_tmp410_ = _tmp409_;
				_tmp411_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp410_, "GSourceFuncs *");
				_tmp412_ = _tmp411_;
				vala_ccode_function_call_add_argument (_tmp406_, (ValaCCodeExpression*) _tmp412_);
				_vala_ccode_node_unref0 (_tmp412_);
				_vala_ccode_node_unref0 (_tmp410_);
				_vala_ccode_node_unref0 (_tmp408_);
				_tmp413_ = vala_ccode_identifier_new ("sizeof");
				_tmp414_ = _tmp413_;
				_tmp415_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp414_);
				_tmp416_ = _tmp415_;
				_vala_ccode_node_unref0 (_tmp414_);
				csizeof = _tmp416_;
				_tmp417_ = csizeof;
				_tmp418_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp419_ = _tmp418_;
				_tmp420_ = vala_get_ccode_name ((ValaCodeNode*) _tmp419_);
				_tmp421_ = _tmp420_;
				_tmp422_ = vala_ccode_identifier_new (_tmp421_);
				_tmp423_ = _tmp422_;
				vala_ccode_function_call_add_argument (_tmp417_, (ValaCCodeExpression*) _tmp423_);
				_vala_ccode_node_unref0 (_tmp423_);
				_g_free0 (_tmp421_);
				_tmp424_ = ccall;
				_tmp425_ = csizeof;
				vala_ccode_function_call_add_argument (_tmp424_, (ValaCCodeExpression*) _tmp425_);
				_vala_ccode_node_unref0 (csizeof);
				_vala_ccode_node_unref0 (funcs);
				_g_free0 (class_prefix);
			}
		}
	} else {
		gboolean _tmp426_ = FALSE;
		ValaMethod* _tmp427_;
		_tmp427_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp427_, VALA_TYPE_CREATION_METHOD)) {
			ValaMethod* _tmp428_;
			ValaSymbol* _tmp429_;
			ValaSymbol* _tmp430_;
			_tmp428_ = m;
			_tmp429_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp428_);
			_tmp430_ = _tmp429_;
			_tmp426_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp430_, VALA_TYPE_STRUCT);
		} else {
			_tmp426_ = FALSE;
		}
		if (_tmp426_) {
			ValaCCodeFunctionCall* _tmp431_;
			ValaCCodeExpression* _tmp432_;
			ValaCCodeExpression* _tmp433_;
			_tmp431_ = ccall;
			_tmp432_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
			_tmp433_ = _tmp432_;
			vala_ccode_function_call_add_argument (_tmp431_, _tmp433_);
			_vala_ccode_node_unref0 (_tmp433_);
		} else {
			gboolean _tmp434_ = FALSE;
			gboolean _tmp435_ = FALSE;
			gboolean _tmp436_ = FALSE;
			gboolean _tmp437_ = FALSE;
			ValaMethod* _tmp438_;
			_tmp438_ = m;
			if (_tmp438_ != NULL) {
				ValaMethod* _tmp439_;
				ValaList* _tmp440_;
				ValaList* _tmp441_;
				gint _tmp442_;
				gint _tmp443_;
				_tmp439_ = m;
				_tmp440_ = vala_method_get_type_parameters (_tmp439_);
				_tmp441_ = _tmp440_;
				_tmp442_ = vala_collection_get_size ((ValaCollection*) _tmp441_);
				_tmp443_ = _tmp442_;
				_tmp437_ = _tmp443_ > 0;
				_vala_iterable_unref0 (_tmp441_);
			} else {
				_tmp437_ = FALSE;
			}
			if (_tmp437_) {
				ValaMethod* _tmp444_;
				_tmp444_ = m;
				_tmp436_ = !vala_get_ccode_has_generic_type_parameter (_tmp444_);
			} else {
				_tmp436_ = FALSE;
			}
			if (_tmp436_) {
				ValaMethod* _tmp445_;
				_tmp445_ = m;
				_tmp435_ = !vala_get_ccode_simple_generics (_tmp445_);
			} else {
				_tmp435_ = FALSE;
			}
			if (_tmp435_) {
				gboolean _tmp446_ = FALSE;
				ValaCCodeFunctionCall* _tmp447_;
				ValaCCodeFunctionCall* _tmp448_;
				_tmp447_ = ccall;
				_tmp448_ = finish_call;
				if (_tmp447_ != _tmp448_) {
					_tmp446_ = TRUE;
				} else {
					gboolean _tmp449_;
					gboolean _tmp450_;
					_tmp449_ = vala_method_call_get_is_yield_expression (expr);
					_tmp450_ = _tmp449_;
					_tmp446_ = _tmp450_;
				}
				_tmp434_ = _tmp446_;
			} else {
				_tmp434_ = FALSE;
			}
			if (_tmp434_) {
				ValaHashMap* _tmp451_;
				ValaMemberAccess* _tmp452_;
				ValaList* _tmp453_;
				ValaList* _tmp454_;
				_tmp451_ = in_arg_map;
				_tmp452_ = ma;
				_tmp453_ = vala_member_access_get_type_arguments (_tmp452_);
				_tmp454_ = _tmp453_;
				vala_ccode_base_module_add_generic_type_arguments ((ValaCCodeBaseModule*) self, (ValaMap*) _tmp451_, _tmp454_, (ValaCodeNode*) expr, FALSE, NULL);
				_vala_iterable_unref0 (_tmp454_);
			}
		}
	}
	_tmp455_ = ccall;
	_tmp456_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp455_);
	ccall_expr = _tmp456_;
	_tmp457_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp457_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp458_;
		ValaExpression* _tmp459_;
		ValaExpression* _tmp460_;
		ValaDataType* _tmp461_;
		ValaDataType* _tmp462_;
		ValaArrayType* _tmp463_;
		ValaHashMap* _tmp464_;
		ValaArrayType* _tmp465_;
		ValaDataType* _tmp466_;
		ValaDataType* _tmp467_;
		gchar* _tmp468_;
		gchar* _tmp469_;
		ValaCCodeIdentifier* _tmp470_;
		ValaCCodeIdentifier* _tmp471_;
		_tmp458_ = ma;
		_tmp459_ = vala_member_access_get_inner (_tmp458_);
		_tmp460_ = _tmp459_;
		_tmp461_ = vala_expression_get_value_type (_tmp460_);
		_tmp462_ = _tmp461_;
		_tmp463_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp462_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp463_;
		_tmp464_ = in_arg_map;
		_tmp465_ = array_type;
		_tmp466_ = vala_array_type_get_element_type (_tmp465_);
		_tmp467_ = _tmp466_;
		_tmp468_ = vala_get_ccode_name ((ValaCodeNode*) _tmp467_);
		_tmp469_ = _tmp468_;
		_tmp470_ = vala_ccode_identifier_new (_tmp469_);
		_tmp471_ = _tmp470_;
		vala_map_set ((ValaMap*) _tmp464_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) 0, FALSE)), (ValaCCodeExpression*) _tmp471_);
		_vala_ccode_node_unref0 (_tmp471_);
		_g_free0 (_tmp469_);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp472_;
		_tmp472_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp472_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
			((ValaCCodeBaseModule*) self)->requires_array_move = TRUE;
		} else {
			ValaMethod* _tmp473_;
			_tmp473_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp473_, VALA_TYPE_ARRAY_COPY_METHOD)) {
				ValaMemberAccess* _tmp474_;
				ValaExpression* _tmp475_;
				ValaExpression* _tmp476_;
				ValaTargetValue* _tmp477_;
				ValaTargetValue* _tmp478_;
				ValaTargetValue* _tmp479_;
				ValaTargetValue* _tmp480_;
				_tmp474_ = ma;
				_tmp475_ = vala_member_access_get_inner (_tmp474_);
				_tmp476_ = _tmp475_;
				_tmp477_ = vala_expression_get_target_value (_tmp476_);
				_tmp478_ = _tmp477_;
				_tmp479_ = vala_ccode_base_module_copy_value ((ValaCCodeBaseModule*) self, _tmp478_, (ValaCodeNode*) expr);
				_tmp480_ = _tmp479_;
				vala_expression_set_target_value ((ValaExpression*) expr, _tmp480_);
				_vala_target_value_unref0 (_tmp480_);
				_vala_ccode_node_unref0 (ccall_expr);
				_vala_map_unref0 (out_arg_map);
				_vala_map_unref0 (in_arg_map);
				_vala_code_node_unref0 (itype);
				_vala_code_node_unref0 (ma);
				_vala_iterable_unref0 (params);
				_vala_code_node_unref0 (deleg);
				_vala_code_node_unref0 (m);
				_vala_ccode_node_unref0 (finish_call);
				_vala_ccode_node_unref0 (async_call);
				_vala_ccode_node_unref0 (ccall);
				return;
			}
		}
	}
	instance = NULL;
	_tmp482_ = m;
	if (_tmp482_ != NULL) {
		ValaMethod* _tmp483_;
		gboolean _tmp484_;
		gboolean _tmp485_;
		_tmp483_ = m;
		_tmp484_ = vala_method_get_is_async_callback (_tmp483_);
		_tmp485_ = _tmp484_;
		_tmp481_ = _tmp485_;
	} else {
		_tmp481_ = FALSE;
	}
	if (_tmp481_) {
		ValaMethod* _tmp486_;
		ValaMethod* _tmp487_;
		gboolean _tmp488_;
		gboolean _tmp489_;
		ValaHashMap* _tmp503_;
		ValaMethod* _tmp504_;
		ValaCCodeExpression* _tmp505_;
		ValaHashMap* _tmp506_;
		ValaMethod* _tmp507_;
		ValaCCodeExpression* _tmp508_;
		_tmp486_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
		_tmp487_ = _tmp486_;
		_tmp488_ = vala_method_get_closure (_tmp487_);
		_tmp489_ = _tmp488_;
		if (_tmp489_) {
			ValaBlock* block = NULL;
			ValaMethod* _tmp490_;
			ValaSymbol* _tmp491_;
			ValaSymbol* _tmp492_;
			ValaBlock* _tmp493_;
			ValaBlock* _tmp494_;
			ValaBlock* _tmp495_;
			ValaBlock* _tmp496_;
			gchar* _tmp497_;
			gchar* _tmp498_;
			ValaCCodeExpression* _tmp499_;
			ValaCCodeExpression* _tmp500_;
			ValaCCodeMemberAccess* _tmp501_;
			_tmp490_ = m;
			_tmp491_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp490_);
			_tmp492_ = _tmp491_;
			_tmp493_ = vala_subroutine_get_body ((ValaSubroutine*) G_TYPE_CHECK_INSTANCE_CAST (_tmp492_, VALA_TYPE_METHOD, ValaMethod));
			_tmp494_ = _tmp493_;
			_tmp495_ = _vala_code_node_ref0 (_tmp494_);
			block = _tmp495_;
			_tmp496_ = block;
			_tmp497_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp496_));
			_tmp498_ = _tmp497_;
			_tmp499_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp498_);
			_tmp500_ = _tmp499_;
			_tmp501_ = vala_ccode_member_access_new_pointer (_tmp500_, "_async_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp501_;
			_vala_ccode_node_unref0 (_tmp500_);
			_g_free0 (_tmp498_);
			_vala_code_node_unref0 (block);
		} else {
			ValaCCodeIdentifier* _tmp502_;
			_tmp502_ = vala_ccode_identifier_new ("_data_");
			_vala_ccode_node_unref0 (instance);
			instance = (ValaCCodeExpression*) _tmp502_;
		}
		_tmp503_ = in_arg_map;
		_tmp504_ = m;
		_tmp505_ = instance;
		vala_map_set ((ValaMap*) _tmp503_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp504_), FALSE)), _tmp505_);
		_tmp506_ = out_arg_map;
		_tmp507_ = m;
		_tmp508_ = instance;
		vala_map_set ((ValaMap*) _tmp506_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp507_), FALSE)), _tmp508_);
	} else {
		gboolean _tmp509_ = FALSE;
		gboolean _tmp510_ = FALSE;
		ValaMethod* _tmp511_;
		_tmp511_ = m;
		if (_tmp511_ != NULL) {
			ValaMethod* _tmp512_;
			ValaMemberBinding _tmp513_;
			ValaMemberBinding _tmp514_;
			_tmp512_ = m;
			_tmp513_ = vala_method_get_binding (_tmp512_);
			_tmp514_ = _tmp513_;
			_tmp510_ = _tmp514_ == VALA_MEMBER_BINDING_INSTANCE;
		} else {
			_tmp510_ = FALSE;
		}
		if (_tmp510_) {
			ValaMethod* _tmp515_;
			_tmp515_ = m;
			_tmp509_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp515_, VALA_TYPE_CREATION_METHOD);
		} else {
			_tmp509_ = FALSE;
		}
		if (_tmp509_) {
			ValaTargetValue* instance_value = NULL;
			ValaMemberAccess* _tmp516_;
			ValaExpression* _tmp517_;
			ValaExpression* _tmp518_;
			ValaTargetValue* _tmp519_;
			ValaTargetValue* _tmp520_;
			ValaTargetValue* _tmp521_;
			gboolean _tmp522_ = FALSE;
			gboolean _tmp523_ = FALSE;
			ValaMemberAccess* _tmp524_;
			const gchar* _tmp525_;
			const gchar* _tmp526_;
			ValaTargetValue* _tmp548_;
			ValaCCodeExpression* _tmp549_;
			ValaStruct* st = NULL;
			ValaMethod* _tmp550_;
			ValaSymbol* _tmp551_;
			ValaSymbol* _tmp552_;
			ValaStruct* _tmp553_;
			gboolean _tmp554_ = FALSE;
			ValaStruct* _tmp555_;
			gboolean _tmp564_;
			gboolean _tmp565_;
			_tmp516_ = ma;
			_tmp517_ = vala_member_access_get_inner (_tmp516_);
			_tmp518_ = _tmp517_;
			_tmp519_ = vala_expression_get_target_value (_tmp518_);
			_tmp520_ = _tmp519_;
			_tmp521_ = _vala_target_value_ref0 (_tmp520_);
			instance_value = _tmp521_;
			_tmp524_ = ma;
			_tmp525_ = vala_member_access_get_member_name (_tmp524_);
			_tmp526_ = _tmp525_;
			if (g_strcmp0 (_tmp526_, "begin") == 0) {
				_tmp523_ = TRUE;
			} else {
				ValaMemberAccess* _tmp527_;
				const gchar* _tmp528_;
				const gchar* _tmp529_;
				_tmp527_ = ma;
				_tmp528_ = vala_member_access_get_member_name (_tmp527_);
				_tmp529_ = _tmp528_;
				_tmp523_ = g_strcmp0 (_tmp529_, "end") == 0;
			}
			if (_tmp523_) {
				ValaMemberAccess* _tmp530_;
				ValaExpression* _tmp531_;
				ValaExpression* _tmp532_;
				ValaSymbol* _tmp533_;
				ValaSymbol* _tmp534_;
				ValaMemberAccess* _tmp535_;
				ValaSymbol* _tmp536_;
				ValaSymbol* _tmp537_;
				_tmp530_ = ma;
				_tmp531_ = vala_member_access_get_inner (_tmp530_);
				_tmp532_ = _tmp531_;
				_tmp533_ = vala_expression_get_symbol_reference (_tmp532_);
				_tmp534_ = _tmp533_;
				_tmp535_ = ma;
				_tmp536_ = vala_expression_get_symbol_reference ((ValaExpression*) _tmp535_);
				_tmp537_ = _tmp536_;
				_tmp522_ = _tmp534_ == _tmp537_;
			} else {
				_tmp522_ = FALSE;
			}
			if (_tmp522_) {
				ValaMemberAccess* inner_ma = NULL;
				ValaMemberAccess* _tmp538_;
				ValaExpression* _tmp539_;
				ValaExpression* _tmp540_;
				ValaMemberAccess* _tmp541_;
				ValaMemberAccess* _tmp542_;
				ValaExpression* _tmp543_;
				ValaExpression* _tmp544_;
				ValaTargetValue* _tmp545_;
				ValaTargetValue* _tmp546_;
				ValaTargetValue* _tmp547_;
				_tmp538_ = ma;
				_tmp539_ = vala_member_access_get_inner (_tmp538_);
				_tmp540_ = _tmp539_;
				_tmp541_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp540_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
				inner_ma = _tmp541_;
				_tmp542_ = inner_ma;
				_tmp543_ = vala_member_access_get_inner (_tmp542_);
				_tmp544_ = _tmp543_;
				_tmp545_ = vala_expression_get_target_value (_tmp544_);
				_tmp546_ = _tmp545_;
				_tmp547_ = _vala_target_value_ref0 (_tmp546_);
				_vala_target_value_unref0 (instance_value);
				instance_value = _tmp547_;
				_vala_code_node_unref0 (inner_ma);
			}
			_tmp548_ = instance_value;
			_tmp549_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp548_);
			_vala_ccode_node_unref0 (instance);
			instance = _tmp549_;
			_tmp550_ = m;
			_tmp551_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp550_);
			_tmp552_ = _tmp551_;
			_tmp553_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp552_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp552_) : NULL);
			st = _tmp553_;
			_tmp555_ = st;
			if (_tmp555_ != NULL) {
				ValaStruct* _tmp556_;
				_tmp556_ = st;
				_tmp554_ = !vala_struct_is_simple_type (_tmp556_);
			} else {
				_tmp554_ = FALSE;
			}
			if (_tmp554_) {
				ValaTargetValue* _tmp557_;
				ValaTargetValue* _tmp560_;
				ValaCCodeExpression* _tmp561_;
				ValaCCodeExpression* _tmp562_;
				ValaCCodeUnaryExpression* _tmp563_;
				_tmp557_ = instance_value;
				if (!vala_ccode_base_module_get_lvalue ((ValaCCodeBaseModule*) self, _tmp557_)) {
					ValaTargetValue* _tmp558_;
					ValaTargetValue* _tmp559_;
					_tmp558_ = instance_value;
					_tmp559_ = vala_ccode_base_module_store_temp_value ((ValaCCodeBaseModule*) self, _tmp558_, (ValaCodeNode*) expr, NULL);
					_vala_target_value_unref0 (instance_value);
					instance_value = _tmp559_;
				}
				_tmp560_ = instance_value;
				_tmp561_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp560_);
				_tmp562_ = _tmp561_;
				_tmp563_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp562_);
				_vala_ccode_node_unref0 (instance);
				instance = (ValaCCodeExpression*) _tmp563_;
				_vala_ccode_node_unref0 (_tmp562_);
			}
			_tmp564_ = vala_method_call_get_is_yield_expression (expr);
			_tmp565_ = _tmp564_;
			if (_tmp565_) {
				ValaHashMap* _tmp566_;
				ValaMethod* _tmp567_;
				ValaCCodeExpression* _tmp568_;
				ValaMethod* _tmp569_;
				_tmp566_ = in_arg_map;
				_tmp567_ = m;
				_tmp568_ = instance;
				vala_map_set ((ValaMap*) _tmp566_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp567_), FALSE)), _tmp568_);
				_tmp569_ = m;
				if (vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp569_)) {
					ValaHashMap* _tmp570_;
					ValaMethod* _tmp571_;
					ValaCCodeExpression* _tmp572_;
					_tmp570_ = out_arg_map;
					_tmp571_ = m;
					_tmp572_ = instance;
					vala_map_set ((ValaMap*) _tmp570_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp571_), FALSE)), _tmp572_);
				}
			} else {
				gboolean _tmp573_ = FALSE;
				ValaMemberAccess* _tmp574_;
				const gchar* _tmp575_;
				const gchar* _tmp576_;
				_tmp574_ = ma;
				_tmp575_ = vala_member_access_get_member_name (_tmp574_);
				_tmp576_ = _tmp575_;
				if (g_strcmp0 (_tmp576_, "end") != 0) {
					_tmp573_ = TRUE;
				} else {
					ValaMethod* _tmp577_;
					_tmp577_ = m;
					_tmp573_ = vala_get_ccode_finish_instance ((ValaCodeNode*) _tmp577_);
				}
				if (_tmp573_) {
					ValaHashMap* _tmp578_;
					ValaMethod* _tmp579_;
					ValaCCodeExpression* _tmp580_;
					ValaHashMap* _tmp581_;
					ValaMethod* _tmp582_;
					ValaCCodeExpression* _tmp583_;
					_tmp578_ = out_arg_map;
					_tmp579_ = m;
					_tmp580_ = instance;
					vala_map_set ((ValaMap*) _tmp578_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp579_), FALSE)), _tmp580_);
					_tmp581_ = in_arg_map;
					_tmp582_ = m;
					_tmp583_ = instance;
					vala_map_set ((ValaMap*) _tmp581_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp582_), FALSE)), _tmp583_);
				}
			}
			_vala_code_node_unref0 (st);
			_vala_target_value_unref0 (instance_value);
		} else {
			gboolean _tmp584_ = FALSE;
			ValaMethod* _tmp585_;
			_tmp585_ = m;
			if (_tmp585_ != NULL) {
				ValaMethod* _tmp586_;
				ValaMemberBinding _tmp587_;
				ValaMemberBinding _tmp588_;
				_tmp586_ = m;
				_tmp587_ = vala_method_get_binding (_tmp586_);
				_tmp588_ = _tmp587_;
				_tmp584_ = _tmp588_ == VALA_MEMBER_BINDING_CLASS;
			} else {
				_tmp584_ = FALSE;
			}
			if (_tmp584_) {
				ValaClass* cl = NULL;
				ValaMethod* _tmp589_;
				ValaSymbol* _tmp590_;
				ValaSymbol* _tmp591_;
				ValaClass* _tmp592_;
				ValaCCodeFunctionCall* cast = NULL;
				ValaClass* _tmp593_;
				gchar* _tmp594_;
				gchar* _tmp595_;
				gchar* _tmp596_;
				gchar* _tmp597_;
				ValaCCodeIdentifier* _tmp598_;
				ValaCCodeIdentifier* _tmp599_;
				ValaCCodeFunctionCall* _tmp600_;
				ValaCCodeFunctionCall* _tmp601_;
				ValaCCodeExpression* klass = NULL;
				ValaMemberAccess* _tmp602_;
				ValaExpression* _tmp603_;
				ValaExpression* _tmp604_;
				ValaCCodeFunctionCall* _tmp630_;
				ValaCCodeExpression* _tmp631_;
				ValaHashMap* _tmp632_;
				ValaMethod* _tmp633_;
				ValaCCodeFunctionCall* _tmp634_;
				ValaHashMap* _tmp635_;
				ValaMethod* _tmp636_;
				ValaCCodeFunctionCall* _tmp637_;
				_tmp589_ = m;
				_tmp590_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp589_);
				_tmp591_ = _tmp590_;
				_tmp592_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp591_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp592_;
				_tmp593_ = cl;
				_tmp594_ = vala_get_ccode_upper_case_name ((ValaSymbol*) _tmp593_, NULL);
				_tmp595_ = _tmp594_;
				_tmp596_ = g_strconcat (_tmp595_, "_CLASS", NULL);
				_tmp597_ = _tmp596_;
				_tmp598_ = vala_ccode_identifier_new (_tmp597_);
				_tmp599_ = _tmp598_;
				_tmp600_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp599_);
				_tmp601_ = _tmp600_;
				_vala_ccode_node_unref0 (_tmp599_);
				_g_free0 (_tmp597_);
				_g_free0 (_tmp595_);
				cast = _tmp601_;
				_tmp602_ = ma;
				_tmp603_ = vala_member_access_get_inner (_tmp602_);
				_tmp604_ = _tmp603_;
				if (_tmp604_ == NULL) {
					ValaDataType* _tmp605_;
					ValaDataType* _tmp606_;
					gboolean _tmp607_;
					_tmp605_ = vala_ccode_base_module_get_this_type ((ValaCCodeBaseModule*) self);
					_tmp606_ = _tmp605_;
					_tmp607_ = _tmp606_ == NULL;
					_vala_code_node_unref0 (_tmp606_);
					if (_tmp607_) {
						ValaCCodeIdentifier* _tmp608_;
						_tmp608_ = vala_ccode_identifier_new ("klass");
						_vala_ccode_node_unref0 (klass);
						klass = (ValaCCodeExpression*) _tmp608_;
					} else {
						ValaCCodeFunctionCall* k = NULL;
						ValaCCodeIdentifier* _tmp609_;
						ValaCCodeIdentifier* _tmp610_;
						ValaCCodeFunctionCall* _tmp611_;
						ValaCCodeFunctionCall* _tmp612_;
						ValaCCodeFunctionCall* _tmp613_;
						ValaCCodeExpression* _tmp614_;
						ValaCCodeExpression* _tmp615_;
						ValaCCodeFunctionCall* _tmp616_;
						ValaCCodeExpression* _tmp617_;
						_tmp609_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
						_tmp610_ = _tmp609_;
						_tmp611_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp610_);
						_tmp612_ = _tmp611_;
						_vala_ccode_node_unref0 (_tmp610_);
						k = _tmp612_;
						_tmp613_ = k;
						_tmp614_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
						_tmp615_ = _tmp614_;
						vala_ccode_function_call_add_argument (_tmp613_, _tmp615_);
						_vala_ccode_node_unref0 (_tmp615_);
						_tmp616_ = k;
						_tmp617_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp616_);
						_vala_ccode_node_unref0 (klass);
						klass = _tmp617_;
						_vala_ccode_node_unref0 (k);
					}
				} else {
					ValaCCodeFunctionCall* k = NULL;
					ValaCCodeIdentifier* _tmp618_;
					ValaCCodeIdentifier* _tmp619_;
					ValaCCodeFunctionCall* _tmp620_;
					ValaCCodeFunctionCall* _tmp621_;
					ValaCCodeFunctionCall* _tmp622_;
					ValaMemberAccess* _tmp623_;
					ValaExpression* _tmp624_;
					ValaExpression* _tmp625_;
					ValaCCodeExpression* _tmp626_;
					ValaCCodeExpression* _tmp627_;
					ValaCCodeFunctionCall* _tmp628_;
					ValaCCodeExpression* _tmp629_;
					_tmp618_ = vala_ccode_identifier_new ("G_OBJECT_GET_CLASS");
					_tmp619_ = _tmp618_;
					_tmp620_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp619_);
					_tmp621_ = _tmp620_;
					_vala_ccode_node_unref0 (_tmp619_);
					k = _tmp621_;
					_tmp622_ = k;
					_tmp623_ = ma;
					_tmp624_ = vala_member_access_get_inner (_tmp623_);
					_tmp625_ = _tmp624_;
					_tmp626_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp625_);
					_tmp627_ = _tmp626_;
					vala_ccode_function_call_add_argument (_tmp622_, _tmp627_);
					_vala_ccode_node_unref0 (_tmp627_);
					_tmp628_ = k;
					_tmp629_ = _vala_ccode_node_ref0 ((ValaCCodeExpression*) _tmp628_);
					_vala_ccode_node_unref0 (klass);
					klass = _tmp629_;
					_vala_ccode_node_unref0 (k);
				}
				_tmp630_ = cast;
				_tmp631_ = klass;
				vala_ccode_function_call_add_argument (_tmp630_, _tmp631_);
				_tmp632_ = in_arg_map;
				_tmp633_ = m;
				_tmp634_ = cast;
				vala_map_set ((ValaMap*) _tmp632_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp633_), FALSE)), (ValaCCodeExpression*) _tmp634_);
				_tmp635_ = out_arg_map;
				_tmp636_ = m;
				_tmp637_ = cast;
				vala_map_set ((ValaMap*) _tmp635_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp636_), FALSE)), (ValaCCodeExpression*) _tmp637_);
				_vala_ccode_node_unref0 (klass);
				_vala_ccode_node_unref0 (cast);
				_vala_code_node_unref0 (cl);
			}
		}
	}
	_tmp639_ = m;
	if (_tmp639_ != NULL) {
		ValaMethod* _tmp640_;
		_tmp640_ = m;
		_tmp638_ = vala_get_ccode_has_generic_type_parameter (_tmp640_);
	} else {
		_tmp638_ = FALSE;
	}
	if (_tmp638_) {
		ValaMethod* _tmp641_;
		ValaList* _tmp642_;
		ValaList* _tmp643_;
		gint _tmp644_;
		gint _tmp645_;
		gboolean _tmp646_;
		_tmp641_ = m;
		_tmp642_ = vala_method_get_type_parameters (_tmp641_);
		_tmp643_ = _tmp642_;
		_tmp644_ = vala_collection_get_size ((ValaCollection*) _tmp643_);
		_tmp645_ = _tmp644_;
		_tmp646_ = _tmp645_ > 0;
		_vala_iterable_unref0 (_tmp643_);
		if (_tmp646_) {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp647_;
				ValaList* _tmp648_;
				gint _type_arg_size = 0;
				ValaList* _tmp649_;
				gint _tmp650_;
				gint _tmp651_;
				gint _type_arg_index = 0;
				_tmp647_ = ma;
				_tmp648_ = vala_member_access_get_type_arguments (_tmp647_);
				_type_arg_list = _tmp648_;
				_tmp649_ = _type_arg_list;
				_tmp650_ = vala_collection_get_size ((ValaCollection*) _tmp649_);
				_tmp651_ = _tmp650_;
				_type_arg_size = _tmp651_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp652_;
					gint _tmp653_;
					gint _tmp654_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp655_;
					gint _tmp656_;
					gpointer _tmp657_;
					ValaHashMap* _tmp658_;
					ValaMethod* _tmp659_;
					gint _tmp660_;
					ValaDataType* _tmp661_;
					gchar* _tmp662_;
					gchar* _tmp663_;
					ValaCCodeIdentifier* _tmp664_;
					ValaCCodeIdentifier* _tmp665_;
					gint _tmp666_;
					_tmp652_ = _type_arg_index;
					_type_arg_index = _tmp652_ + 1;
					_tmp653_ = _type_arg_index;
					_tmp654_ = _type_arg_size;
					if (!(_tmp653_ < _tmp654_)) {
						break;
					}
					_tmp655_ = _type_arg_list;
					_tmp656_ = _type_arg_index;
					_tmp657_ = vala_list_get (_tmp655_, _tmp656_);
					type_arg = (ValaDataType*) _tmp657_;
					_tmp658_ = in_arg_map;
					_tmp659_ = m;
					_tmp660_ = type_param_index;
					_tmp661_ = type_arg;
					_tmp662_ = vala_get_ccode_name ((ValaCodeNode*) _tmp661_);
					_tmp663_ = _tmp662_;
					_tmp664_ = vala_ccode_identifier_new (_tmp663_);
					_tmp665_ = _tmp664_;
					vala_map_set ((ValaMap*) _tmp658_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp659_) + (0.01 * _tmp660_), FALSE)), (ValaCCodeExpression*) _tmp665_);
					_vala_ccode_node_unref0 (_tmp665_);
					_g_free0 (_tmp663_);
					_tmp666_ = type_param_index;
					type_param_index = _tmp666_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		} else {
			gint type_param_index = 0;
			type_param_index = 0;
			{
				ValaList* _type_arg_list = NULL;
				ValaMemberAccess* _tmp667_;
				ValaExpression* _tmp668_;
				ValaExpression* _tmp669_;
				ValaDataType* _tmp670_;
				ValaDataType* _tmp671_;
				ValaList* _tmp672_;
				gint _type_arg_size = 0;
				ValaList* _tmp673_;
				gint _tmp674_;
				gint _tmp675_;
				gint _type_arg_index = 0;
				_tmp667_ = ma;
				_tmp668_ = vala_member_access_get_inner (_tmp667_);
				_tmp669_ = _tmp668_;
				_tmp670_ = vala_expression_get_value_type (_tmp669_);
				_tmp671_ = _tmp670_;
				_tmp672_ = vala_data_type_get_type_arguments (_tmp671_);
				_type_arg_list = _tmp672_;
				_tmp673_ = _type_arg_list;
				_tmp674_ = vala_collection_get_size ((ValaCollection*) _tmp673_);
				_tmp675_ = _tmp674_;
				_type_arg_size = _tmp675_;
				_type_arg_index = -1;
				while (TRUE) {
					gint _tmp676_;
					gint _tmp677_;
					gint _tmp678_;
					ValaDataType* type_arg = NULL;
					ValaList* _tmp679_;
					gint _tmp680_;
					gpointer _tmp681_;
					ValaHashMap* _tmp682_;
					ValaMethod* _tmp683_;
					gint _tmp684_;
					ValaDataType* _tmp685_;
					gchar* _tmp686_;
					gchar* _tmp687_;
					ValaCCodeIdentifier* _tmp688_;
					ValaCCodeIdentifier* _tmp689_;
					gint _tmp690_;
					_tmp676_ = _type_arg_index;
					_type_arg_index = _tmp676_ + 1;
					_tmp677_ = _type_arg_index;
					_tmp678_ = _type_arg_size;
					if (!(_tmp677_ < _tmp678_)) {
						break;
					}
					_tmp679_ = _type_arg_list;
					_tmp680_ = _type_arg_index;
					_tmp681_ = vala_list_get (_tmp679_, _tmp680_);
					type_arg = (ValaDataType*) _tmp681_;
					_tmp682_ = in_arg_map;
					_tmp683_ = m;
					_tmp684_ = type_param_index;
					_tmp685_ = type_arg;
					_tmp686_ = vala_get_ccode_name ((ValaCodeNode*) _tmp685_);
					_tmp687_ = _tmp686_;
					_tmp688_ = vala_ccode_identifier_new (_tmp687_);
					_tmp689_ = _tmp688_;
					vala_map_set ((ValaMap*) _tmp682_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_generic_type_pos (_tmp683_) + (0.01 * _tmp684_), FALSE)), (ValaCCodeExpression*) _tmp689_);
					_vala_ccode_node_unref0 (_tmp689_);
					_g_free0 (_tmp687_);
					_tmp690_ = type_param_index;
					type_param_index = _tmp690_ + 1;
					_vala_code_node_unref0 (type_arg);
				}
				_vala_iterable_unref0 (_type_arg_list);
			}
		}
	}
	_tmp691_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp691_, VALA_TYPE_ARRAY_MOVE_METHOD)) {
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp692_;
		ValaExpression* _tmp693_;
		ValaExpression* _tmp694_;
		ValaDataType* _tmp695_;
		ValaDataType* _tmp696_;
		ValaArrayType* _tmp697_;
		ValaCCodeFunctionCall* csizeof = NULL;
		ValaCCodeIdentifier* _tmp698_;
		ValaCCodeIdentifier* _tmp699_;
		ValaCCodeFunctionCall* _tmp700_;
		ValaCCodeFunctionCall* _tmp701_;
		ValaCCodeFunctionCall* _tmp702_;
		ValaArrayType* _tmp703_;
		ValaDataType* _tmp704_;
		ValaDataType* _tmp705_;
		gchar* _tmp706_;
		gchar* _tmp707_;
		ValaCCodeIdentifier* _tmp708_;
		ValaCCodeIdentifier* _tmp709_;
		ValaHashMap* _tmp710_;
		ValaCCodeFunctionCall* _tmp711_;
		_tmp692_ = ma;
		_tmp693_ = vala_member_access_get_inner (_tmp692_);
		_tmp694_ = _tmp693_;
		_tmp695_ = vala_expression_get_value_type (_tmp694_);
		_tmp696_ = _tmp695_;
		_tmp697_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp696_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp697_;
		_tmp698_ = vala_ccode_identifier_new ("sizeof");
		_tmp699_ = _tmp698_;
		_tmp700_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp699_);
		_tmp701_ = _tmp700_;
		_vala_ccode_node_unref0 (_tmp699_);
		csizeof = _tmp701_;
		_tmp702_ = csizeof;
		_tmp703_ = array_type;
		_tmp704_ = vala_array_type_get_element_type (_tmp703_);
		_tmp705_ = _tmp704_;
		_tmp706_ = vala_get_ccode_name ((ValaCodeNode*) _tmp705_);
		_tmp707_ = _tmp706_;
		_tmp708_ = vala_ccode_identifier_new (_tmp707_);
		_tmp709_ = _tmp708_;
		vala_ccode_function_call_add_argument (_tmp702_, (ValaCCodeExpression*) _tmp709_);
		_vala_ccode_node_unref0 (_tmp709_);
		_g_free0 (_tmp707_);
		_tmp710_ = in_arg_map;
		_tmp711_ = csizeof;
		vala_map_set ((ValaMap*) _tmp710_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, 0.1, FALSE)), (ValaCCodeExpression*) _tmp711_);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
	} else {
		ValaMethod* _tmp712_;
		_tmp712_ = m;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp712_, VALA_TYPE_DYNAMIC_METHOD)) {
			ValaMethod* _tmp713_;
			gint param_nr = 0;
			ValaMethod* _tmp784_;
			_tmp713_ = m;
			vala_method_clear_parameters (_tmp713_);
			param_nr = 1;
			{
				ValaList* _arg_list = NULL;
				ValaList* _tmp714_;
				gint _arg_size = 0;
				ValaList* _tmp715_;
				gint _tmp716_;
				gint _tmp717_;
				gint _arg_index = 0;
				_tmp714_ = vala_method_call_get_argument_list (expr);
				_arg_list = _tmp714_;
				_tmp715_ = _arg_list;
				_tmp716_ = vala_collection_get_size ((ValaCollection*) _tmp715_);
				_tmp717_ = _tmp716_;
				_arg_size = _tmp717_;
				_arg_index = -1;
				while (TRUE) {
					gint _tmp718_;
					gint _tmp719_;
					gint _tmp720_;
					ValaExpression* arg = NULL;
					ValaList* _tmp721_;
					gint _tmp722_;
					gpointer _tmp723_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp724_;
					ValaUnaryExpression* _tmp725_;
					gboolean _tmp726_ = FALSE;
					ValaUnaryExpression* _tmp727_;
					gint _tmp771_;
					_tmp718_ = _arg_index;
					_arg_index = _tmp718_ + 1;
					_tmp719_ = _arg_index;
					_tmp720_ = _arg_size;
					if (!(_tmp719_ < _tmp720_)) {
						break;
					}
					_tmp721_ = _arg_list;
					_tmp722_ = _arg_index;
					_tmp723_ = vala_list_get (_tmp721_, _tmp722_);
					arg = (ValaExpression*) _tmp723_;
					_tmp724_ = arg;
					_tmp725_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp724_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp724_) : NULL);
					unary = _tmp725_;
					_tmp727_ = unary;
					if (_tmp727_ != NULL) {
						ValaUnaryExpression* _tmp728_;
						ValaUnaryOperator _tmp729_;
						ValaUnaryOperator _tmp730_;
						_tmp728_ = unary;
						_tmp729_ = vala_unary_expression_get_operator (_tmp728_);
						_tmp730_ = _tmp729_;
						_tmp726_ = _tmp730_ == VALA_UNARY_OPERATOR_OUT;
					} else {
						_tmp726_ = FALSE;
					}
					if (_tmp726_) {
						ValaParameter* param = NULL;
						gint _tmp731_;
						gchar* _tmp732_;
						gchar* _tmp733_;
						ValaUnaryExpression* _tmp734_;
						ValaExpression* _tmp735_;
						ValaExpression* _tmp736_;
						ValaDataType* _tmp737_;
						ValaDataType* _tmp738_;
						ValaParameter* _tmp739_;
						ValaParameter* _tmp740_;
						ValaParameter* _tmp741_;
						ValaMethod* _tmp742_;
						ValaParameter* _tmp743_;
						_tmp731_ = param_nr;
						_tmp732_ = g_strdup_printf ("param%d", _tmp731_);
						_tmp733_ = _tmp732_;
						_tmp734_ = unary;
						_tmp735_ = vala_unary_expression_get_inner (_tmp734_);
						_tmp736_ = _tmp735_;
						_tmp737_ = vala_expression_get_value_type (_tmp736_);
						_tmp738_ = _tmp737_;
						_tmp739_ = vala_parameter_new (_tmp733_, _tmp738_, NULL);
						_tmp740_ = _tmp739_;
						_g_free0 (_tmp733_);
						param = _tmp740_;
						_tmp741_ = param;
						vala_parameter_set_direction (_tmp741_, VALA_PARAMETER_DIRECTION_OUT);
						_tmp742_ = m;
						_tmp743_ = param;
						vala_callable_add_parameter ((ValaCallable*) _tmp742_, _tmp743_);
						_vala_code_node_unref0 (param);
					} else {
						gboolean _tmp744_ = FALSE;
						ValaUnaryExpression* _tmp745_;
						_tmp745_ = unary;
						if (_tmp745_ != NULL) {
							ValaUnaryExpression* _tmp746_;
							ValaUnaryOperator _tmp747_;
							ValaUnaryOperator _tmp748_;
							_tmp746_ = unary;
							_tmp747_ = vala_unary_expression_get_operator (_tmp746_);
							_tmp748_ = _tmp747_;
							_tmp744_ = _tmp748_ == VALA_UNARY_OPERATOR_REF;
						} else {
							_tmp744_ = FALSE;
						}
						if (_tmp744_) {
							ValaParameter* param = NULL;
							gint _tmp749_;
							gchar* _tmp750_;
							gchar* _tmp751_;
							ValaUnaryExpression* _tmp752_;
							ValaExpression* _tmp753_;
							ValaExpression* _tmp754_;
							ValaDataType* _tmp755_;
							ValaDataType* _tmp756_;
							ValaParameter* _tmp757_;
							ValaParameter* _tmp758_;
							ValaParameter* _tmp759_;
							ValaMethod* _tmp760_;
							ValaParameter* _tmp761_;
							_tmp749_ = param_nr;
							_tmp750_ = g_strdup_printf ("param%d", _tmp749_);
							_tmp751_ = _tmp750_;
							_tmp752_ = unary;
							_tmp753_ = vala_unary_expression_get_inner (_tmp752_);
							_tmp754_ = _tmp753_;
							_tmp755_ = vala_expression_get_value_type (_tmp754_);
							_tmp756_ = _tmp755_;
							_tmp757_ = vala_parameter_new (_tmp751_, _tmp756_, NULL);
							_tmp758_ = _tmp757_;
							_g_free0 (_tmp751_);
							param = _tmp758_;
							_tmp759_ = param;
							vala_parameter_set_direction (_tmp759_, VALA_PARAMETER_DIRECTION_REF);
							_tmp760_ = m;
							_tmp761_ = param;
							vala_callable_add_parameter ((ValaCallable*) _tmp760_, _tmp761_);
							_vala_code_node_unref0 (param);
						} else {
							ValaMethod* _tmp762_;
							gint _tmp763_;
							gchar* _tmp764_;
							gchar* _tmp765_;
							ValaExpression* _tmp766_;
							ValaDataType* _tmp767_;
							ValaDataType* _tmp768_;
							ValaParameter* _tmp769_;
							ValaParameter* _tmp770_;
							_tmp762_ = m;
							_tmp763_ = param_nr;
							_tmp764_ = g_strdup_printf ("param%d", _tmp763_);
							_tmp765_ = _tmp764_;
							_tmp766_ = arg;
							_tmp767_ = vala_expression_get_value_type (_tmp766_);
							_tmp768_ = _tmp767_;
							_tmp769_ = vala_parameter_new (_tmp765_, _tmp768_, NULL);
							_tmp770_ = _tmp769_;
							vala_callable_add_parameter ((ValaCallable*) _tmp762_, _tmp770_);
							_vala_code_node_unref0 (_tmp770_);
							_g_free0 (_tmp765_);
						}
					}
					_tmp771_ = param_nr;
					param_nr = _tmp771_ + 1;
					_vala_code_node_unref0 (unary);
					_vala_code_node_unref0 (arg);
				}
				_vala_iterable_unref0 (_arg_list);
			}
			{
				ValaList* _param_list = NULL;
				ValaMethod* _tmp772_;
				ValaList* _tmp773_;
				gint _param_size = 0;
				ValaList* _tmp774_;
				gint _tmp775_;
				gint _tmp776_;
				gint _param_index = 0;
				_tmp772_ = m;
				_tmp773_ = vala_callable_get_parameters ((ValaCallable*) _tmp772_);
				_param_list = _tmp773_;
				_tmp774_ = _param_list;
				_tmp775_ = vala_collection_get_size ((ValaCollection*) _tmp774_);
				_tmp776_ = _tmp775_;
				_param_size = _tmp776_;
				_param_index = -1;
				while (TRUE) {
					gint _tmp777_;
					gint _tmp778_;
					gint _tmp779_;
					ValaParameter* param = NULL;
					ValaList* _tmp780_;
					gint _tmp781_;
					gpointer _tmp782_;
					ValaParameter* _tmp783_;
					_tmp777_ = _param_index;
					_param_index = _tmp777_ + 1;
					_tmp778_ = _param_index;
					_tmp779_ = _param_size;
					if (!(_tmp778_ < _tmp779_)) {
						break;
					}
					_tmp780_ = _param_list;
					_tmp781_ = _param_index;
					_tmp782_ = vala_list_get (_tmp780_, _tmp781_);
					param = (ValaParameter*) _tmp782_;
					_tmp783_ = param;
					vala_code_node_accept ((ValaCodeNode*) _tmp783_, (ValaCodeVisitor*) self);
					_vala_code_node_unref0 (param);
				}
				_vala_iterable_unref0 (_param_list);
			}
			_tmp784_ = m;
			vala_ccode_base_module_generate_dynamic_method_wrapper ((ValaCCodeBaseModule*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp784_, VALA_TYPE_DYNAMIC_METHOD, ValaDynamicMethod));
		} else {
			gboolean _tmp785_ = FALSE;
			ValaMethod* _tmp786_;
			_tmp786_ = m;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp786_, VALA_TYPE_CREATION_METHOD)) {
				ValaMethod* _tmp787_;
				ValaSymbol* _tmp788_;
				ValaSymbol* _tmp789_;
				_tmp787_ = m;
				_tmp788_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp787_);
				_tmp789_ = _tmp788_;
				_tmp785_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp789_, VALA_TYPE_CLASS);
			} else {
				_tmp785_ = FALSE;
			}
			if (_tmp785_) {
				ValaCCodeFunction* _tmp790_;
				ValaCCodeFunction* _tmp791_;
				ValaCCodeExpression* _tmp792_;
				ValaCCodeExpression* _tmp793_;
				ValaCCodeFunctionCall* _tmp794_;
				ValaClass* _tmp795_;
				ValaClass* _tmp796_;
				gchar* _tmp797_;
				gchar* _tmp798_;
				gchar* _tmp799_;
				gchar* _tmp800_;
				ValaCCodeCastExpression* _tmp801_;
				ValaCCodeCastExpression* _tmp802_;
				ValaMethod* _tmp803_;
				ValaMethod* _tmp804_;
				ValaBlock* _tmp805_;
				ValaBlock* _tmp806_;
				gboolean _tmp807_;
				gboolean _tmp808_;
				gboolean _tmp835_ = FALSE;
				ValaClass* _tmp836_;
				ValaClass* _tmp837_;
				gboolean _tmp838_;
				gboolean _tmp839_;
				_tmp790_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp791_ = _tmp790_;
				_tmp792_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
				_tmp793_ = _tmp792_;
				_tmp794_ = ccall;
				_tmp795_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp796_ = _tmp795_;
				_tmp797_ = vala_get_ccode_name ((ValaCodeNode*) _tmp796_);
				_tmp798_ = _tmp797_;
				_tmp799_ = g_strconcat (_tmp798_, "*", NULL);
				_tmp800_ = _tmp799_;
				_tmp801_ = vala_ccode_cast_expression_new ((ValaCCodeExpression*) _tmp794_, _tmp800_);
				_tmp802_ = _tmp801_;
				vala_ccode_function_add_assignment (_tmp791_, _tmp793_, (ValaCCodeExpression*) _tmp802_);
				_vala_ccode_node_unref0 (_tmp802_);
				_g_free0 (_tmp800_);
				_g_free0 (_tmp798_);
				_vala_ccode_node_unref0 (_tmp793_);
				_tmp803_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
				_tmp804_ = _tmp803_;
				_tmp805_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp804_);
				_tmp806_ = _tmp805_;
				_tmp807_ = vala_block_get_captured (_tmp806_);
				_tmp808_ = _tmp807_;
				if (_tmp808_) {
					ValaCCodeFunctionCall* ref_call = NULL;
					ValaClass* _tmp809_;
					ValaClass* _tmp810_;
					ValaObjectType* _tmp811_;
					ValaObjectType* _tmp812_;
					ValaSourceReference* _tmp813_;
					ValaSourceReference* _tmp814_;
					ValaCCodeExpression* _tmp815_;
					ValaCCodeExpression* _tmp816_;
					ValaCCodeFunctionCall* _tmp817_;
					ValaCCodeFunctionCall* _tmp818_;
					ValaCCodeFunctionCall* _tmp819_;
					ValaCCodeExpression* _tmp820_;
					ValaCCodeExpression* _tmp821_;
					ValaCCodeFunction* _tmp822_;
					ValaCCodeFunction* _tmp823_;
					ValaMethod* _tmp824_;
					ValaMethod* _tmp825_;
					ValaBlock* _tmp826_;
					ValaBlock* _tmp827_;
					gchar* _tmp828_;
					gchar* _tmp829_;
					ValaCCodeExpression* _tmp830_;
					ValaCCodeExpression* _tmp831_;
					ValaCCodeMemberAccess* _tmp832_;
					ValaCCodeMemberAccess* _tmp833_;
					ValaCCodeFunctionCall* _tmp834_;
					_tmp809_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp810_ = _tmp809_;
					_tmp811_ = vala_object_type_new ((ValaObjectTypeSymbol*) _tmp810_);
					_tmp812_ = _tmp811_;
					_tmp813_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
					_tmp814_ = _tmp813_;
					_tmp815_ = vala_ccode_base_module_get_dup_func_expression ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp812_, _tmp814_, FALSE);
					_tmp816_ = _tmp815_;
					_tmp817_ = vala_ccode_function_call_new (_tmp816_);
					_tmp818_ = _tmp817_;
					_vala_ccode_node_unref0 (_tmp816_);
					_vala_code_node_unref0 (_tmp812_);
					ref_call = _tmp818_;
					_tmp819_ = ref_call;
					_tmp820_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
					_tmp821_ = _tmp820_;
					vala_ccode_function_call_add_argument (_tmp819_, _tmp821_);
					_vala_ccode_node_unref0 (_tmp821_);
					_tmp822_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
					_tmp823_ = _tmp822_;
					_tmp824_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
					_tmp825_ = _tmp824_;
					_tmp826_ = vala_subroutine_get_body ((ValaSubroutine*) _tmp825_);
					_tmp827_ = _tmp826_;
					_tmp828_ = g_strdup_printf ("_data%d_", vala_ccode_base_module_get_block_id ((ValaCCodeBaseModule*) self, _tmp827_));
					_tmp829_ = _tmp828_;
					_tmp830_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp829_);
					_tmp831_ = _tmp830_;
					_tmp832_ = vala_ccode_member_access_new_pointer (_tmp831_, "self");
					_tmp833_ = _tmp832_;
					_tmp834_ = ref_call;
					vala_ccode_function_add_assignment (_tmp823_, (ValaCCodeExpression*) _tmp833_, (ValaCCodeExpression*) _tmp834_);
					_vala_ccode_node_unref0 (_tmp833_);
					_vala_ccode_node_unref0 (_tmp831_);
					_g_free0 (_tmp829_);
					_vala_ccode_node_unref0 (ref_call);
				}
				_tmp836_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
				_tmp837_ = _tmp836_;
				_tmp838_ = vala_class_get_is_compact (_tmp837_);
				_tmp839_ = _tmp838_;
				if (!_tmp839_) {
					ValaClass* _tmp840_;
					ValaClass* _tmp841_;
					ValaList* _tmp842_;
					ValaList* _tmp843_;
					gint _tmp844_;
					gint _tmp845_;
					_tmp840_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
					_tmp841_ = _tmp840_;
					_tmp842_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp841_);
					_tmp843_ = _tmp842_;
					_tmp844_ = vala_collection_get_size ((ValaCollection*) _tmp843_);
					_tmp845_ = _tmp844_;
					_tmp835_ = _tmp845_ > 0;
					_vala_iterable_unref0 (_tmp843_);
				} else {
					_tmp835_ = FALSE;
				}
				if (_tmp835_) {
					gchar** suffices = NULL;
					gchar* _tmp846_;
					gchar* _tmp847_;
					gchar* _tmp848_;
					gchar** _tmp849_;
					gint suffices_length1;
					gint _suffices_size_;
					_tmp846_ = g_strdup ("type");
					_tmp847_ = g_strdup ("dup_func");
					_tmp848_ = g_strdup ("destroy_func");
					_tmp849_ = g_new0 (gchar*, 3 + 1);
					_tmp849_[0] = _tmp846_;
					_tmp849_[1] = _tmp847_;
					_tmp849_[2] = _tmp848_;
					suffices = _tmp849_;
					suffices_length1 = 3;
					_suffices_size_ = suffices_length1;
					{
						ValaList* _type_param_list = NULL;
						ValaClass* _tmp850_;
						ValaClass* _tmp851_;
						ValaList* _tmp852_;
						gint _type_param_size = 0;
						ValaList* _tmp853_;
						gint _tmp854_;
						gint _tmp855_;
						gint _type_param_index = 0;
						_tmp850_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
						_tmp851_ = _tmp850_;
						_tmp852_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) _tmp851_);
						_type_param_list = _tmp852_;
						_tmp853_ = _type_param_list;
						_tmp854_ = vala_collection_get_size ((ValaCollection*) _tmp853_);
						_tmp855_ = _tmp854_;
						_type_param_size = _tmp855_;
						_type_param_index = -1;
						while (TRUE) {
							gint _tmp856_;
							gint _tmp857_;
							gint _tmp858_;
							ValaTypeParameter* type_param = NULL;
							ValaList* _tmp859_;
							gint _tmp860_;
							gpointer _tmp861_;
							ValaCCodeMemberAccess* priv_access = NULL;
							ValaCCodeIdentifier* _tmp862_;
							ValaCCodeIdentifier* _tmp863_;
							ValaCCodeMemberAccess* _tmp864_;
							ValaCCodeMemberAccess* _tmp865_;
							gchar** _tmp866_;
							gint _tmp866__length1;
							_tmp856_ = _type_param_index;
							_type_param_index = _tmp856_ + 1;
							_tmp857_ = _type_param_index;
							_tmp858_ = _type_param_size;
							if (!(_tmp857_ < _tmp858_)) {
								break;
							}
							_tmp859_ = _type_param_list;
							_tmp860_ = _type_param_index;
							_tmp861_ = vala_list_get (_tmp859_, _tmp860_);
							type_param = (ValaTypeParameter*) _tmp861_;
							_tmp862_ = vala_ccode_identifier_new ("self");
							_tmp863_ = _tmp862_;
							_tmp864_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp863_, "priv");
							_tmp865_ = _tmp864_;
							_vala_ccode_node_unref0 (_tmp863_);
							priv_access = _tmp865_;
							_tmp866_ = suffices;
							_tmp866__length1 = suffices_length1;
							{
								gchar** suffix_collection = NULL;
								gint suffix_collection_length1 = 0;
								gint _suffix_collection_size_ = 0;
								gint suffix_it = 0;
								suffix_collection = _tmp866_;
								suffix_collection_length1 = _tmp866__length1;
								for (suffix_it = 0; suffix_it < _tmp866__length1; suffix_it = suffix_it + 1) {
									gchar* _tmp867_;
									gchar* suffix = NULL;
									_tmp867_ = g_strdup (suffix_collection[suffix_it]);
									suffix = _tmp867_;
									{
										ValaCCodeIdentifier* param_name = NULL;
										ValaTypeParameter* _tmp868_;
										const gchar* _tmp869_;
										const gchar* _tmp870_;
										gchar* _tmp871_;
										gchar* _tmp872_;
										const gchar* _tmp873_;
										gchar* _tmp874_;
										gchar* _tmp875_;
										ValaCCodeIdentifier* _tmp876_;
										ValaCCodeIdentifier* _tmp877_;
										ValaCCodeFunction* _tmp878_;
										ValaCCodeFunction* _tmp879_;
										ValaCCodeMemberAccess* _tmp880_;
										ValaCCodeIdentifier* _tmp881_;
										const gchar* _tmp882_;
										const gchar* _tmp883_;
										ValaCCodeMemberAccess* _tmp884_;
										ValaCCodeMemberAccess* _tmp885_;
										ValaCCodeIdentifier* _tmp886_;
										_tmp868_ = type_param;
										_tmp869_ = vala_symbol_get_name ((ValaSymbol*) _tmp868_);
										_tmp870_ = _tmp869_;
										_tmp871_ = g_utf8_strdown (_tmp870_, (gssize) -1);
										_tmp872_ = _tmp871_;
										_tmp873_ = suffix;
										_tmp874_ = g_strdup_printf ("%s_%s", _tmp872_, _tmp873_);
										_tmp875_ = _tmp874_;
										_tmp876_ = vala_ccode_identifier_new (_tmp875_);
										_tmp877_ = _tmp876_;
										_g_free0 (_tmp875_);
										_g_free0 (_tmp872_);
										param_name = _tmp877_;
										_tmp878_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
										_tmp879_ = _tmp878_;
										_tmp880_ = priv_access;
										_tmp881_ = param_name;
										_tmp882_ = vala_ccode_identifier_get_name (_tmp881_);
										_tmp883_ = _tmp882_;
										_tmp884_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp880_, _tmp883_);
										_tmp885_ = _tmp884_;
										_tmp886_ = param_name;
										vala_ccode_function_add_assignment (_tmp879_, (ValaCCodeExpression*) _tmp885_, (ValaCCodeExpression*) _tmp886_);
										_vala_ccode_node_unref0 (_tmp885_);
										_vala_ccode_node_unref0 (param_name);
										_g_free0 (suffix);
									}
								}
							}
							_vala_ccode_node_unref0 (priv_access);
							_vala_code_node_unref0 (type_param);
						}
						_vala_iterable_unref0 (_type_param_list);
					}
					suffices = (_vala_array_free (suffices, suffices_length1, (GDestroyNotify) g_free), NULL);
				}
				_vala_ccode_node_unref0 (ccall_expr);
				ccall_expr = NULL;
			}
		}
	}
	ellipsis = FALSE;
	i = 1;
	_tmp887_ = params;
	_tmp888_ = vala_iterable_iterator ((ValaIterable*) _tmp887_);
	params_it = _tmp888_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp889_;
		gint _arg_size = 0;
		ValaList* _tmp890_;
		gint _tmp891_;
		gint _tmp892_;
		gint _arg_index = 0;
		_tmp889_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp889_;
		_tmp890_ = _arg_list;
		_tmp891_ = vala_collection_get_size ((ValaCollection*) _tmp890_);
		_tmp892_ = _tmp891_;
		_arg_size = _tmp892_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp893_;
			gint _tmp894_;
			gint _tmp895_;
			ValaExpression* arg = NULL;
			ValaList* _tmp896_;
			gint _tmp897_;
			gpointer _tmp898_;
			ValaCCodeExpression* cexpr = NULL;
			ValaExpression* _tmp899_;
			ValaCCodeExpression* _tmp900_;
			ValaHashMap* carg_map = NULL;
			ValaHashMap* _tmp901_;
			ValaHashMap* _tmp902_;
			ValaIterator* _tmp903_;
			ValaHashMap* _tmp1219_;
			gint _tmp1220_;
			ValaCCodeExpression* _tmp1221_;
			gboolean _tmp1222_ = FALSE;
			ValaExpression* _tmp1223_;
			gint _tmp1243_;
			_tmp893_ = _arg_index;
			_arg_index = _tmp893_ + 1;
			_tmp894_ = _arg_index;
			_tmp895_ = _arg_size;
			if (!(_tmp894_ < _tmp895_)) {
				break;
			}
			_tmp896_ = _arg_list;
			_tmp897_ = _arg_index;
			_tmp898_ = vala_list_get (_tmp896_, _tmp897_);
			arg = (ValaExpression*) _tmp898_;
			_tmp899_ = arg;
			_tmp900_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp899_);
			cexpr = _tmp900_;
			_tmp901_ = in_arg_map;
			_tmp902_ = _vala_map_ref0 (_tmp901_);
			carg_map = _tmp902_;
			_tmp903_ = params_it;
			if (vala_iterator_next (_tmp903_)) {
				ValaParameter* param = NULL;
				ValaIterator* _tmp904_;
				gpointer _tmp905_;
				gboolean _tmp906_ = FALSE;
				ValaParameter* _tmp907_;
				gboolean _tmp908_;
				gboolean _tmp909_;
				gboolean _tmp913_;
				ValaParameter* _tmp1212_;
				gboolean _tmp1213_;
				_tmp904_ = params_it;
				_tmp905_ = vala_iterator_get (_tmp904_);
				param = (ValaParameter*) _tmp905_;
				_tmp907_ = param;
				_tmp908_ = vala_parameter_get_params_array (_tmp907_);
				_tmp909_ = _tmp908_;
				if (_tmp909_) {
					_tmp906_ = TRUE;
				} else {
					ValaParameter* _tmp910_;
					gboolean _tmp911_;
					gboolean _tmp912_;
					_tmp910_ = param;
					_tmp911_ = vala_parameter_get_ellipsis (_tmp910_);
					_tmp912_ = _tmp911_;
					_tmp906_ = _tmp912_;
				}
				ellipsis = _tmp906_;
				_tmp913_ = ellipsis;
				if (!_tmp913_) {
					ValaParameter* _tmp914_;
					ValaParameterDirection _tmp915_;
					ValaParameterDirection _tmp916_;
					ValaUnaryExpression* unary = NULL;
					ValaExpression* _tmp919_;
					ValaUnaryExpression* _tmp920_;
					gboolean _tmp921_ = FALSE;
					ValaUnaryExpression* _tmp922_;
					ValaParameter* _tmp1200_;
					gchar* _tmp1201_;
					gchar* _tmp1202_;
					gboolean _tmp1203_;
					_tmp914_ = param;
					_tmp915_ = vala_parameter_get_direction (_tmp914_);
					_tmp916_ = _tmp915_;
					if (_tmp916_ == VALA_PARAMETER_DIRECTION_OUT) {
						ValaHashMap* _tmp917_;
						ValaHashMap* _tmp918_;
						_tmp917_ = out_arg_map;
						_tmp918_ = _vala_map_ref0 (_tmp917_);
						_vala_map_unref0 (carg_map);
						carg_map = _tmp918_;
					}
					_tmp919_ = arg;
					_tmp920_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp919_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp919_) : NULL);
					unary = _tmp920_;
					_tmp922_ = unary;
					if (_tmp922_ == NULL) {
						_tmp921_ = TRUE;
					} else {
						ValaUnaryExpression* _tmp923_;
						ValaUnaryOperator _tmp924_;
						ValaUnaryOperator _tmp925_;
						_tmp923_ = unary;
						_tmp924_ = vala_unary_expression_get_operator (_tmp923_);
						_tmp925_ = _tmp924_;
						_tmp921_ = _tmp925_ != VALA_UNARY_OPERATOR_OUT;
					}
					if (_tmp921_) {
						gboolean _tmp926_ = FALSE;
						gboolean _tmp927_ = FALSE;
						ValaParameter* _tmp928_;
						ValaParameter* _tmp1070_;
						ValaExpression* _tmp1071_;
						ValaCCodeExpression* _tmp1072_;
						ValaCCodeExpression* _tmp1073_;
						_tmp928_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp928_)) {
							ValaParameter* _tmp929_;
							ValaDataType* _tmp930_;
							ValaDataType* _tmp931_;
							_tmp929_ = param;
							_tmp930_ = vala_variable_get_variable_type ((ValaVariable*) _tmp929_);
							_tmp931_ = _tmp930_;
							_tmp927_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp931_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp927_ = FALSE;
						}
						if (_tmp927_) {
							ValaParameter* _tmp932_;
							ValaDataType* _tmp933_;
							ValaDataType* _tmp934_;
							gboolean _tmp935_;
							gboolean _tmp936_;
							_tmp932_ = param;
							_tmp933_ = vala_variable_get_variable_type ((ValaVariable*) _tmp932_);
							_tmp934_ = _tmp933_;
							_tmp935_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp934_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp936_ = _tmp935_;
							_tmp926_ = !_tmp936_;
						} else {
							_tmp926_ = FALSE;
						}
						if (_tmp926_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp937_;
							ValaDataType* _tmp938_;
							ValaDataType* _tmp939_;
							ValaArrayType* _tmp940_;
							_tmp937_ = param;
							_tmp938_ = vala_variable_get_variable_type ((ValaVariable*) _tmp937_);
							_tmp939_ = _tmp938_;
							_tmp940_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp939_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp940_;
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp941_ = FALSE;
									_tmp941_ = TRUE;
									while (TRUE) {
										gint _tmp943_;
										ValaArrayType* _tmp944_;
										gint _tmp945_;
										gint _tmp946_;
										ValaCCodeExpression* array_length_expr = NULL;
										ValaParameter* _tmp947_;
										gchar* _tmp948_;
										gchar* _tmp949_;
										gboolean _tmp950_;
										ValaHashMap* _tmp969_;
										ValaParameter* _tmp970_;
										gint _tmp971_;
										ValaCCodeExpression* _tmp972_;
										if (!_tmp941_) {
											gint _tmp942_;
											_tmp942_ = dim;
											dim = _tmp942_ + 1;
										}
										_tmp941_ = FALSE;
										_tmp943_ = dim;
										_tmp944_ = array_type;
										_tmp945_ = vala_array_type_get_rank (_tmp944_);
										_tmp946_ = _tmp945_;
										if (!(_tmp943_ <= _tmp946_)) {
											break;
										}
										array_length_expr = NULL;
										_tmp947_ = param;
										_tmp948_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp947_);
										_tmp949_ = _tmp948_;
										_tmp950_ = _tmp949_ != NULL;
										_g_free0 (_tmp949_);
										if (_tmp950_) {
											gchar* length_ctype = NULL;
											ValaParameter* _tmp951_;
											gchar* _tmp952_;
											gboolean _tmp953_ = FALSE;
											ValaUnaryExpression* _tmp954_;
											ValaExpression* _tmp960_;
											gint _tmp961_;
											ValaCCodeExpression* _tmp962_;
											ValaCCodeExpression* _tmp963_;
											const gchar* _tmp964_;
											ValaCCodeCastExpression* _tmp965_;
											_tmp951_ = param;
											_tmp952_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp951_);
											length_ctype = _tmp952_;
											_tmp954_ = unary;
											if (_tmp954_ != NULL) {
												ValaUnaryExpression* _tmp955_;
												ValaUnaryOperator _tmp956_;
												ValaUnaryOperator _tmp957_;
												_tmp955_ = unary;
												_tmp956_ = vala_unary_expression_get_operator (_tmp955_);
												_tmp957_ = _tmp956_;
												_tmp953_ = _tmp957_ == VALA_UNARY_OPERATOR_REF;
											} else {
												_tmp953_ = FALSE;
											}
											if (_tmp953_) {
												const gchar* _tmp958_;
												gchar* _tmp959_;
												_tmp958_ = length_ctype;
												_tmp959_ = g_strdup_printf ("%s*", _tmp958_);
												_g_free0 (length_ctype);
												length_ctype = _tmp959_;
											}
											_tmp960_ = arg;
											_tmp961_ = dim;
											_tmp962_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp960_, _tmp961_);
											_tmp963_ = _tmp962_;
											_tmp964_ = length_ctype;
											_tmp965_ = vala_ccode_cast_expression_new (_tmp963_, _tmp964_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = (ValaCCodeExpression*) _tmp965_;
											_vala_ccode_node_unref0 (_tmp963_);
											_g_free0 (length_ctype);
										} else {
											ValaExpression* _tmp966_;
											gint _tmp967_;
											ValaCCodeExpression* _tmp968_;
											_tmp966_ = arg;
											_tmp967_ = dim;
											_tmp968_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp966_, _tmp967_);
											_vala_ccode_node_unref0 (array_length_expr);
											array_length_expr = _tmp968_;
										}
										_tmp969_ = carg_map;
										_tmp970_ = param;
										_tmp971_ = dim;
										_tmp972_ = array_length_expr;
										vala_map_set ((ValaMap*) _tmp969_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp970_) + (0.01 * _tmp971_), FALSE)), _tmp972_);
										_vala_ccode_node_unref0 (array_length_expr);
									}
								}
							}
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp973_;
							ValaDataType* _tmp974_;
							ValaDataType* _tmp975_;
							_tmp973_ = param;
							_tmp974_ = vala_variable_get_variable_type ((ValaVariable*) _tmp973_);
							_tmp975_ = _tmp974_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp975_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp976_;
								ValaDataType* _tmp977_;
								ValaDataType* _tmp978_;
								ValaDelegateType* _tmp979_;
								ValaDelegateType* _tmp980_;
								ValaDelegate* _tmp981_;
								ValaDelegate* _tmp982_;
								gboolean _tmp983_;
								gboolean _tmp984_;
								_tmp976_ = param;
								_tmp977_ = vala_variable_get_variable_type ((ValaVariable*) _tmp976_);
								_tmp978_ = _tmp977_;
								_tmp979_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp978_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp979_;
								_tmp980_ = deleg_type;
								_tmp981_ = vala_delegate_type_get_delegate_symbol (_tmp980_);
								_tmp982_ = _tmp981_;
								_tmp983_ = vala_delegate_get_has_target (_tmp982_);
								_tmp984_ = _tmp983_;
								if (_tmp984_) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaCCodeExpression* delegate_target = NULL;
									ValaExpression* _tmp985_;
									ValaCCodeExpression* _tmp986_ = NULL;
									ValaCCodeExpression* _tmp987_;
									ValaCCodeExpression* _tmp988_;
									ValaParameter* _tmp989_;
									gchar* _tmp990_;
									gchar* _tmp991_;
									gboolean _tmp992_;
									_tmp985_ = arg;
									_tmp987_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp985_, &_tmp986_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp986_;
									delegate_target = _tmp987_;
									_tmp988_ = delegate_target;
									_vala_assert (_tmp988_ != NULL, "delegate_target != null");
									_tmp989_ = param;
									_tmp990_ = vala_get_ccode_type ((ValaCodeNode*) _tmp989_);
									_tmp991_ = _tmp990_;
									_tmp992_ = g_strcmp0 (_tmp991_, "GClosure*") == 0;
									_g_free0 (_tmp991_);
									if (_tmp992_) {
										ValaCCodeFunctionCall* closure_new = NULL;
										ValaCCodeIdentifier* _tmp993_;
										ValaCCodeIdentifier* _tmp994_;
										ValaCCodeFunctionCall* _tmp995_;
										ValaCCodeFunctionCall* _tmp996_;
										ValaCCodeFunctionCall* _tmp997_;
										ValaCCodeExpression* _tmp998_;
										ValaCCodeCastExpression* _tmp999_;
										ValaCCodeCastExpression* _tmp1000_;
										ValaCCodeFunctionCall* _tmp1001_;
										ValaCCodeExpression* _tmp1002_;
										ValaCCodeFunctionCall* _tmp1003_;
										ValaCCodeExpression* _tmp1004_;
										ValaCCodeCastExpression* _tmp1005_;
										ValaCCodeCastExpression* _tmp1006_;
										ValaCCodeExpression* _tmp1007_;
										ValaCCodeIdentifier* _tmp1008_;
										ValaCCodeIdentifier* _tmp1009_;
										ValaCCodeBinaryExpression* _tmp1010_;
										ValaCCodeBinaryExpression* _tmp1011_;
										ValaCCodeIdentifier* _tmp1012_;
										ValaCCodeIdentifier* _tmp1013_;
										ValaCCodeFunctionCall* _tmp1014_;
										ValaCCodeConditionalExpression* _tmp1015_;
										_tmp993_ = vala_ccode_identifier_new ("g_cclosure_new");
										_tmp994_ = _tmp993_;
										_tmp995_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp994_);
										_tmp996_ = _tmp995_;
										_vala_ccode_node_unref0 (_tmp994_);
										closure_new = _tmp996_;
										_tmp997_ = closure_new;
										_tmp998_ = cexpr;
										_tmp999_ = vala_ccode_cast_expression_new (_tmp998_, "GCallback");
										_tmp1000_ = _tmp999_;
										vala_ccode_function_call_add_argument (_tmp997_, (ValaCCodeExpression*) _tmp1000_);
										_vala_ccode_node_unref0 (_tmp1000_);
										_tmp1001_ = closure_new;
										_tmp1002_ = delegate_target;
										vala_ccode_function_call_add_argument (_tmp1001_, _tmp1002_);
										_tmp1003_ = closure_new;
										_tmp1004_ = delegate_target_destroy_notify;
										_tmp1005_ = vala_ccode_cast_expression_new (_tmp1004_, "GClosureNotify");
										_tmp1006_ = _tmp1005_;
										vala_ccode_function_call_add_argument (_tmp1003_, (ValaCCodeExpression*) _tmp1006_);
										_vala_ccode_node_unref0 (_tmp1006_);
										_tmp1007_ = cexpr;
										_tmp1008_ = vala_ccode_identifier_new ("NULL");
										_tmp1009_ = _tmp1008_;
										_tmp1010_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, _tmp1007_, (ValaCCodeExpression*) _tmp1009_);
										_tmp1011_ = _tmp1010_;
										_tmp1012_ = vala_ccode_identifier_new ("NULL");
										_tmp1013_ = _tmp1012_;
										_tmp1014_ = closure_new;
										_tmp1015_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1011_, (ValaCCodeExpression*) _tmp1013_, (ValaCCodeExpression*) _tmp1014_);
										_vala_ccode_node_unref0 (cexpr);
										cexpr = (ValaCCodeExpression*) _tmp1015_;
										_vala_ccode_node_unref0 (_tmp1013_);
										_vala_ccode_node_unref0 (_tmp1011_);
										_vala_ccode_node_unref0 (_tmp1009_);
										_vala_ccode_node_unref0 (closure_new);
									} else {
										ValaHashMap* _tmp1016_;
										ValaParameter* _tmp1017_;
										ValaCCodeExpression* _tmp1018_;
										ValaDelegateType* _tmp1019_;
										_tmp1016_ = carg_map;
										_tmp1017_ = param;
										_tmp1018_ = delegate_target;
										vala_map_set ((ValaMap*) _tmp1016_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1017_), FALSE)), _tmp1018_);
										_tmp1019_ = deleg_type;
										if (vala_data_type_is_disposable ((ValaDataType*) _tmp1019_)) {
											ValaCCodeExpression* _tmp1020_;
											ValaHashMap* _tmp1021_;
											ValaParameter* _tmp1022_;
											ValaCCodeExpression* _tmp1023_;
											_tmp1020_ = delegate_target_destroy_notify;
											_vala_assert (_tmp1020_ != NULL, "delegate_target_destroy_notify != null");
											_tmp1021_ = carg_map;
											_tmp1022_ = param;
											_tmp1023_ = delegate_target_destroy_notify;
											vala_map_set ((ValaMap*) _tmp1021_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1022_) + 0.01, FALSE)), _tmp1023_);
										}
									}
									_vala_ccode_node_unref0 (delegate_target);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								}
								_vala_code_node_unref0 (deleg_type);
							} else {
								ValaParameter* _tmp1024_;
								ValaDataType* _tmp1025_;
								ValaDataType* _tmp1026_;
								_tmp1024_ = param;
								_tmp1025_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1024_);
								_tmp1026_ = _tmp1025_;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1026_, VALA_TYPE_METHOD_TYPE)) {
									ValaCCodeExpression* delegate_target_destroy_notify = NULL;
									ValaHashMap* _tmp1027_;
									ValaParameter* _tmp1028_;
									ValaExpression* _tmp1029_;
									ValaCCodeExpression* _tmp1030_ = NULL;
									ValaCCodeExpression* _tmp1031_;
									ValaCCodeExpression* _tmp1032_;
									_tmp1027_ = carg_map;
									_tmp1028_ = param;
									_tmp1029_ = arg;
									_tmp1031_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1029_, &_tmp1030_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
									delegate_target_destroy_notify = _tmp1030_;
									_tmp1032_ = _tmp1031_;
									vala_map_set ((ValaMap*) _tmp1027_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1028_), FALSE)), _tmp1032_);
									_vala_ccode_node_unref0 (_tmp1032_);
									_vala_ccode_node_unref0 (delegate_target_destroy_notify);
								} else {
									ValaParameter* _tmp1033_;
									ValaDataType* _tmp1034_;
									ValaDataType* _tmp1035_;
									_tmp1033_ = param;
									_tmp1034_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1033_);
									_tmp1035_ = _tmp1034_;
									if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1035_, VALA_TYPE_GENERIC_TYPE)) {
										gboolean _tmp1036_ = FALSE;
										ValaMethod* _tmp1037_;
										_tmp1037_ = m;
										if (_tmp1037_ != NULL) {
											ValaMethod* _tmp1038_;
											_tmp1038_ = m;
											_tmp1036_ = vala_get_ccode_simple_generics (_tmp1038_);
										} else {
											_tmp1036_ = FALSE;
										}
										if (_tmp1036_) {
											ValaGenericType* generic_type = NULL;
											ValaParameter* _tmp1039_;
											ValaDataType* _tmp1040_;
											ValaDataType* _tmp1041_;
											ValaGenericType* _tmp1042_;
											gint type_param_index = 0;
											ValaMethod* _tmp1043_;
											ValaGenericType* _tmp1044_;
											ValaTypeParameter* _tmp1045_;
											ValaTypeParameter* _tmp1046_;
											const gchar* _tmp1047_;
											const gchar* _tmp1048_;
											ValaDataType* type_arg = NULL;
											ValaMemberAccess* _tmp1049_;
											ValaList* _tmp1050_;
											ValaList* _tmp1051_;
											gint _tmp1052_;
											gpointer _tmp1053_;
											ValaDataType* _tmp1054_;
											ValaParameter* _tmp1055_;
											ValaDataType* _tmp1056_;
											ValaDataType* _tmp1057_;
											gboolean _tmp1058_;
											gboolean _tmp1059_;
											_tmp1039_ = param;
											_tmp1040_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1039_);
											_tmp1041_ = _tmp1040_;
											_tmp1042_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1041_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
											generic_type = _tmp1042_;
											_tmp1043_ = m;
											_tmp1044_ = generic_type;
											_tmp1045_ = vala_generic_type_get_type_parameter (_tmp1044_);
											_tmp1046_ = _tmp1045_;
											_tmp1047_ = vala_symbol_get_name ((ValaSymbol*) _tmp1046_);
											_tmp1048_ = _tmp1047_;
											type_param_index = vala_method_get_type_parameter_index (_tmp1043_, _tmp1048_);
											_tmp1049_ = ma;
											_tmp1050_ = vala_member_access_get_type_arguments (_tmp1049_);
											_tmp1051_ = _tmp1050_;
											_tmp1052_ = type_param_index;
											_tmp1053_ = vala_list_get (_tmp1051_, _tmp1052_);
											_tmp1054_ = (ValaDataType*) _tmp1053_;
											_vala_iterable_unref0 (_tmp1051_);
											type_arg = _tmp1054_;
											_tmp1055_ = param;
											_tmp1056_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1055_);
											_tmp1057_ = _tmp1056_;
											_tmp1058_ = vala_data_type_get_value_owned (_tmp1057_);
											_tmp1059_ = _tmp1058_;
											if (_tmp1059_) {
												ValaDataType* _tmp1060_;
												_tmp1060_ = type_arg;
												if (vala_ccode_base_module_requires_copy ((ValaCCodeBaseModule*) self, _tmp1060_)) {
													ValaHashMap* _tmp1061_;
													ValaParameter* _tmp1062_;
													ValaDataType* _tmp1063_;
													ValaCCodeExpression* _tmp1064_;
													ValaCCodeExpression* _tmp1065_;
													_tmp1061_ = carg_map;
													_tmp1062_ = param;
													_tmp1063_ = type_arg;
													_tmp1064_ = vala_ccode_base_module_get_destroy_func_expression ((ValaCCodeBaseModule*) self, _tmp1063_, FALSE);
													_tmp1065_ = _tmp1064_;
													vala_map_set ((ValaMap*) _tmp1061_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1062_), FALSE)), _tmp1065_);
													_vala_ccode_node_unref0 (_tmp1065_);
												} else {
													ValaHashMap* _tmp1066_;
													ValaParameter* _tmp1067_;
													ValaCCodeConstant* _tmp1068_;
													ValaCCodeConstant* _tmp1069_;
													_tmp1066_ = carg_map;
													_tmp1067_ = param;
													_tmp1068_ = vala_ccode_constant_new ("NULL");
													_tmp1069_ = _tmp1068_;
													vala_map_set ((ValaMap*) _tmp1066_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_destroy_notify_pos ((ValaCodeNode*) _tmp1067_), FALSE)), (ValaCCodeExpression*) _tmp1069_);
													_vala_ccode_node_unref0 (_tmp1069_);
												}
											}
											_vala_code_node_unref0 (type_arg);
											_vala_code_node_unref0 (generic_type);
										}
									}
								}
							}
						}
						_tmp1070_ = param;
						_tmp1071_ = arg;
						_tmp1072_ = cexpr;
						_tmp1073_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, _tmp1070_, _tmp1071_, _tmp1072_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = _tmp1073_;
					} else {
						ValaExpression* _tmp1074_;
						ValaLocalVariable* temp_var = NULL;
						ValaParameter* _tmp1075_;
						ValaDataType* _tmp1076_;
						ValaDataType* _tmp1077_;
						ValaParameter* _tmp1078_;
						ValaDataType* _tmp1079_;
						ValaDataType* _tmp1080_;
						gboolean _tmp1081_;
						gboolean _tmp1082_;
						ValaLocalVariable* _tmp1083_;
						ValaLocalVariable* _tmp1084_;
						ValaExpression* _tmp1085_;
						ValaLocalVariable* _tmp1086_;
						const gchar* _tmp1087_;
						const gchar* _tmp1088_;
						ValaCCodeExpression* _tmp1089_;
						ValaCCodeExpression* _tmp1090_;
						ValaExpression* _tmp1091_;
						ValaTargetValue* _tmp1092_;
						ValaTargetValue* _tmp1093_;
						ValaExpression* _tmp1094_;
						ValaDataType* _tmp1095_;
						ValaDataType* _tmp1096_;
						ValaExpression* _tmp1097_;
						ValaCCodeExpression* _tmp1098_;
						ValaCCodeExpression* _tmp1099_;
						ValaCCodeUnaryExpression* _tmp1100_;
						gboolean _tmp1101_ = FALSE;
						gboolean _tmp1102_ = FALSE;
						ValaParameter* _tmp1103_;
						_tmp1074_ = arg;
						vala_expression_set_target_value (_tmp1074_, NULL);
						_tmp1075_ = param;
						_tmp1076_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1075_);
						_tmp1077_ = _tmp1076_;
						_tmp1078_ = param;
						_tmp1079_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1078_);
						_tmp1080_ = _tmp1079_;
						_tmp1081_ = vala_data_type_get_value_owned (_tmp1080_);
						_tmp1082_ = _tmp1081_;
						_tmp1083_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1077_, _tmp1082_, NULL, TRUE);
						temp_var = _tmp1083_;
						_tmp1084_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1084_, FALSE);
						_tmp1085_ = arg;
						_tmp1086_ = temp_var;
						_tmp1087_ = vala_symbol_get_name ((ValaSymbol*) _tmp1086_);
						_tmp1088_ = _tmp1087_;
						_tmp1089_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1088_);
						_tmp1090_ = _tmp1089_;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, _tmp1085_, _tmp1090_);
						_vala_ccode_node_unref0 (_tmp1090_);
						_tmp1091_ = arg;
						_tmp1092_ = vala_expression_get_target_value (_tmp1091_);
						_tmp1093_ = _tmp1092_;
						_tmp1094_ = arg;
						_tmp1095_ = vala_expression_get_target_type (_tmp1094_);
						_tmp1096_ = _tmp1095_;
						vala_target_value_set_value_type (_tmp1093_, _tmp1096_);
						_tmp1097_ = arg;
						_tmp1098_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1097_);
						_tmp1099_ = _tmp1098_;
						_tmp1100_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1099_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1100_;
						_vala_ccode_node_unref0 (_tmp1099_);
						_tmp1103_ = param;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1103_)) {
							ValaParameter* _tmp1104_;
							ValaDataType* _tmp1105_;
							ValaDataType* _tmp1106_;
							_tmp1104_ = param;
							_tmp1105_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1104_);
							_tmp1106_ = _tmp1105_;
							_tmp1102_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1106_, VALA_TYPE_ARRAY_TYPE);
						} else {
							_tmp1102_ = FALSE;
						}
						if (_tmp1102_) {
							ValaParameter* _tmp1107_;
							ValaDataType* _tmp1108_;
							ValaDataType* _tmp1109_;
							gboolean _tmp1110_;
							gboolean _tmp1111_;
							_tmp1107_ = param;
							_tmp1108_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1107_);
							_tmp1109_ = _tmp1108_;
							_tmp1110_ = vala_array_type_get_fixed_length (G_TYPE_CHECK_INSTANCE_CAST (_tmp1109_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							_tmp1111_ = _tmp1110_;
							_tmp1101_ = !_tmp1111_;
						} else {
							_tmp1101_ = FALSE;
						}
						if (_tmp1101_) {
							ValaArrayType* array_type = NULL;
							ValaParameter* _tmp1112_;
							ValaDataType* _tmp1113_;
							ValaDataType* _tmp1114_;
							ValaArrayType* _tmp1115_;
							ValaDataType* array_length_type = NULL;
							ValaDataType* _tmp1116_;
							ValaDataType* _tmp1117_;
							ValaParameter* _tmp1118_;
							gchar* _tmp1119_;
							gchar* _tmp1120_;
							gboolean _tmp1121_;
							_tmp1112_ = param;
							_tmp1113_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1112_);
							_tmp1114_ = _tmp1113_;
							_tmp1115_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1114_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
							array_type = _tmp1115_;
							_tmp1116_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1117_ = _vala_code_node_ref0 (_tmp1116_);
							array_length_type = _tmp1117_;
							_tmp1118_ = param;
							_tmp1119_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1118_);
							_tmp1120_ = _tmp1119_;
							_tmp1121_ = _tmp1120_ != NULL;
							_g_free0 (_tmp1120_);
							if (_tmp1121_) {
								ValaParameter* _tmp1122_;
								gchar* _tmp1123_;
								gchar* _tmp1124_;
								ValaCType* _tmp1125_;
								_tmp1122_ = param;
								_tmp1123_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1122_);
								_tmp1124_ = _tmp1123_;
								_tmp1125_ = vala_ctype_new (_tmp1124_);
								_vala_code_node_unref0 (array_length_type);
								array_length_type = (ValaDataType*) _tmp1125_;
								_g_free0 (_tmp1124_);
							}
							{
								gint dim = 0;
								dim = 1;
								{
									gboolean _tmp1126_ = FALSE;
									_tmp1126_ = TRUE;
									while (TRUE) {
										gint _tmp1128_;
										ValaArrayType* _tmp1129_;
										gint _tmp1130_;
										gint _tmp1131_;
										ValaLocalVariable* temp_array_length = NULL;
										ValaDataType* _tmp1132_;
										ValaLocalVariable* _tmp1133_;
										ValaLocalVariable* _tmp1134_;
										ValaExpression* _tmp1135_;
										ValaLocalVariable* _tmp1136_;
										const gchar* _tmp1137_;
										const gchar* _tmp1138_;
										ValaCCodeExpression* _tmp1139_;
										ValaCCodeExpression* _tmp1140_;
										ValaHashMap* _tmp1141_;
										ValaParameter* _tmp1142_;
										gint _tmp1143_;
										ValaExpression* _tmp1144_;
										ValaList* _tmp1145_;
										ValaList* _tmp1146_;
										gint _tmp1147_;
										gpointer _tmp1148_;
										ValaCCodeExpression* _tmp1149_;
										ValaCCodeUnaryExpression* _tmp1150_;
										ValaCCodeUnaryExpression* _tmp1151_;
										if (!_tmp1126_) {
											gint _tmp1127_;
											_tmp1127_ = dim;
											dim = _tmp1127_ + 1;
										}
										_tmp1126_ = FALSE;
										_tmp1128_ = dim;
										_tmp1129_ = array_type;
										_tmp1130_ = vala_array_type_get_rank (_tmp1129_);
										_tmp1131_ = _tmp1130_;
										if (!(_tmp1128_ <= _tmp1131_)) {
											break;
										}
										_tmp1132_ = array_length_type;
										_tmp1133_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1132_, TRUE, NULL, FALSE);
										temp_array_length = _tmp1133_;
										_tmp1134_ = temp_array_length;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1134_, FALSE);
										_tmp1135_ = arg;
										_tmp1136_ = temp_array_length;
										_tmp1137_ = vala_symbol_get_name ((ValaSymbol*) _tmp1136_);
										_tmp1138_ = _tmp1137_;
										_tmp1139_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1138_);
										_tmp1140_ = _tmp1139_;
										vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, _tmp1135_, _tmp1140_);
										_vala_ccode_node_unref0 (_tmp1140_);
										_tmp1141_ = carg_map;
										_tmp1142_ = param;
										_tmp1143_ = dim;
										_tmp1144_ = arg;
										_tmp1145_ = vala_ccode_base_module_get_array_lengths ((ValaCCodeBaseModule*) self, _tmp1144_);
										_tmp1146_ = _tmp1145_;
										_tmp1147_ = dim;
										_tmp1148_ = vala_list_get (_tmp1146_, _tmp1147_ - 1);
										_tmp1149_ = (ValaCCodeExpression*) _tmp1148_;
										_tmp1150_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1149_);
										_tmp1151_ = _tmp1150_;
										vala_map_set ((ValaMap*) _tmp1141_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1142_) + (0.01 * _tmp1143_), FALSE)), (ValaCCodeExpression*) _tmp1151_);
										_vala_ccode_node_unref0 (_tmp1151_);
										_vala_ccode_node_unref0 (_tmp1149_);
										_vala_iterable_unref0 (_tmp1146_);
										_vala_code_node_unref0 (temp_array_length);
									}
								}
							}
							_vala_code_node_unref0 (array_length_type);
							_vala_code_node_unref0 (array_type);
						} else {
							ValaParameter* _tmp1152_;
							ValaDataType* _tmp1153_;
							ValaDataType* _tmp1154_;
							_tmp1152_ = param;
							_tmp1153_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1152_);
							_tmp1154_ = _tmp1153_;
							if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1154_, VALA_TYPE_DELEGATE_TYPE)) {
								ValaDelegateType* deleg_type = NULL;
								ValaParameter* _tmp1155_;
								ValaDataType* _tmp1156_;
								ValaDataType* _tmp1157_;
								ValaDelegateType* _tmp1158_;
								ValaDelegateType* _tmp1159_;
								ValaDelegate* _tmp1160_;
								ValaDelegate* _tmp1161_;
								gboolean _tmp1162_;
								gboolean _tmp1163_;
								_tmp1155_ = param;
								_tmp1156_ = vala_variable_get_variable_type ((ValaVariable*) _tmp1155_);
								_tmp1157_ = _tmp1156_;
								_tmp1158_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1157_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
								deleg_type = _tmp1158_;
								_tmp1159_ = deleg_type;
								_tmp1160_ = vala_delegate_type_get_delegate_symbol (_tmp1159_);
								_tmp1161_ = _tmp1160_;
								_tmp1162_ = vala_delegate_get_has_target (_tmp1161_);
								_tmp1163_ = _tmp1162_;
								if (_tmp1163_) {
									ValaVoidType* _tmp1164_;
									ValaVoidType* _tmp1165_;
									ValaPointerType* _tmp1166_;
									ValaPointerType* _tmp1167_;
									ValaLocalVariable* _tmp1168_;
									ValaLocalVariable* _tmp1169_;
									ValaExpression* _tmp1170_;
									ValaLocalVariable* _tmp1171_;
									const gchar* _tmp1172_;
									const gchar* _tmp1173_;
									ValaCCodeExpression* _tmp1174_;
									ValaCCodeExpression* _tmp1175_;
									ValaHashMap* _tmp1176_;
									ValaParameter* _tmp1177_;
									ValaExpression* _tmp1178_;
									ValaCCodeExpression* _tmp1179_;
									ValaCCodeExpression* _tmp1180_;
									ValaCCodeUnaryExpression* _tmp1181_;
									ValaCCodeUnaryExpression* _tmp1182_;
									ValaDelegateType* _tmp1183_;
									_tmp1164_ = vala_void_type_new (NULL);
									_tmp1165_ = _tmp1164_;
									_tmp1166_ = vala_pointer_type_new ((ValaDataType*) _tmp1165_, NULL);
									_tmp1167_ = _tmp1166_;
									_tmp1168_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1167_, TRUE, NULL, TRUE);
									_vala_code_node_unref0 (temp_var);
									temp_var = _tmp1168_;
									_vala_code_node_unref0 (_tmp1167_);
									_vala_code_node_unref0 (_tmp1165_);
									_tmp1169_ = temp_var;
									vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1169_, FALSE);
									_tmp1170_ = arg;
									_tmp1171_ = temp_var;
									_tmp1172_ = vala_symbol_get_name ((ValaSymbol*) _tmp1171_);
									_tmp1173_ = _tmp1172_;
									_tmp1174_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1173_);
									_tmp1175_ = _tmp1174_;
									vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, _tmp1170_, _tmp1175_);
									_vala_ccode_node_unref0 (_tmp1175_);
									_tmp1176_ = carg_map;
									_tmp1177_ = param;
									_tmp1178_ = arg;
									_tmp1179_ = vala_ccode_base_module_get_delegate_target ((ValaCCodeBaseModule*) self, _tmp1178_);
									_tmp1180_ = _tmp1179_;
									_tmp1181_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1180_);
									_tmp1182_ = _tmp1181_;
									vala_map_set ((ValaMap*) _tmp1176_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1177_), FALSE)), (ValaCCodeExpression*) _tmp1182_);
									_vala_ccode_node_unref0 (_tmp1182_);
									_vala_ccode_node_unref0 (_tmp1180_);
									_tmp1183_ = deleg_type;
									if (vala_data_type_is_disposable ((ValaDataType*) _tmp1183_)) {
										ValaDataType* _tmp1184_;
										ValaLocalVariable* _tmp1185_;
										ValaLocalVariable* _tmp1186_;
										ValaExpression* _tmp1187_;
										ValaLocalVariable* _tmp1188_;
										const gchar* _tmp1189_;
										const gchar* _tmp1190_;
										ValaCCodeExpression* _tmp1191_;
										ValaCCodeExpression* _tmp1192_;
										ValaHashMap* _tmp1193_;
										ValaParameter* _tmp1194_;
										ValaExpression* _tmp1195_;
										ValaCCodeExpression* _tmp1196_;
										ValaCCodeExpression* _tmp1197_;
										ValaCCodeUnaryExpression* _tmp1198_;
										ValaCCodeUnaryExpression* _tmp1199_;
										_tmp1184_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
										_tmp1185_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1184_, TRUE, NULL, TRUE);
										_vala_code_node_unref0 (temp_var);
										temp_var = _tmp1185_;
										_tmp1186_ = temp_var;
										vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1186_, FALSE);
										_tmp1187_ = arg;
										_tmp1188_ = temp_var;
										_tmp1189_ = vala_symbol_get_name ((ValaSymbol*) _tmp1188_);
										_tmp1190_ = _tmp1189_;
										_tmp1191_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1190_);
										_tmp1192_ = _tmp1191_;
										vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1187_, _tmp1192_);
										_vala_ccode_node_unref0 (_tmp1192_);
										_tmp1193_ = carg_map;
										_tmp1194_ = param;
										_tmp1195_ = arg;
										_tmp1196_ = vala_ccode_base_module_get_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, _tmp1195_);
										_tmp1197_ = _tmp1196_;
										_tmp1198_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1197_);
										_tmp1199_ = _tmp1198_;
										vala_map_set ((ValaMap*) _tmp1193_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1194_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1199_);
										_vala_ccode_node_unref0 (_tmp1199_);
										_vala_ccode_node_unref0 (_tmp1197_);
									}
								}
								_vala_code_node_unref0 (deleg_type);
							}
						}
						_vala_code_node_unref0 (temp_var);
					}
					_tmp1200_ = param;
					_tmp1201_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1200_);
					_tmp1202_ = _tmp1201_;
					_tmp1203_ = _tmp1202_ != NULL;
					_g_free0 (_tmp1202_);
					if (_tmp1203_) {
						ValaCCodeExpression* _tmp1204_;
						ValaParameter* _tmp1205_;
						gchar* _tmp1206_;
						gchar* _tmp1207_;
						ValaCCodeCastExpression* _tmp1208_;
						_tmp1204_ = cexpr;
						_tmp1205_ = param;
						_tmp1206_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1205_);
						_tmp1207_ = _tmp1206_;
						_tmp1208_ = vala_ccode_cast_expression_new (_tmp1204_, _tmp1207_);
						_vala_ccode_node_unref0 (cexpr);
						cexpr = (ValaCCodeExpression*) _tmp1208_;
						_g_free0 (_tmp1207_);
					}
					_vala_code_node_unref0 (unary);
				} else {
					ValaExpression* _tmp1209_;
					ValaCCodeExpression* _tmp1210_;
					ValaCCodeExpression* _tmp1211_;
					_tmp1209_ = arg;
					_tmp1210_ = cexpr;
					_tmp1211_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1209_, _tmp1210_);
					_vala_ccode_node_unref0 (cexpr);
					cexpr = _tmp1211_;
				}
				_tmp1212_ = param;
				_tmp1213_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_pos (_tmp1212_), _tmp1213_);
				_vala_code_node_unref0 (param);
			} else {
				ValaExpression* _tmp1214_;
				ValaCCodeExpression* _tmp1215_;
				ValaCCodeExpression* _tmp1216_;
				gint _tmp1217_;
				gboolean _tmp1218_;
				_tmp1214_ = arg;
				_tmp1215_ = cexpr;
				_tmp1216_ = vala_ccode_base_module_handle_struct_argument ((ValaCCodeBaseModule*) self, NULL, _tmp1214_, _tmp1215_);
				_vala_ccode_node_unref0 (cexpr);
				cexpr = _tmp1216_;
				_tmp1217_ = i;
				_tmp1218_ = ellipsis;
				arg_pos = vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) _tmp1217_, _tmp1218_);
			}
			_tmp1219_ = carg_map;
			_tmp1220_ = arg_pos;
			_tmp1221_ = cexpr;
			vala_map_set ((ValaMap*) _tmp1219_, (gpointer) ((gintptr) _tmp1220_), _tmp1221_);
			_tmp1223_ = arg;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1223_, VALA_TYPE_NAMED_ARGUMENT)) {
				gboolean _tmp1224_;
				_tmp1224_ = ellipsis;
				_tmp1222_ = _tmp1224_;
			} else {
				_tmp1222_ = FALSE;
			}
			if (_tmp1222_) {
				ValaNamedArgument* named_arg = NULL;
				ValaExpression* _tmp1225_;
				ValaNamedArgument* _tmp1226_;
				gchar* name = NULL;
				ValaNamedArgument* _tmp1227_;
				const gchar* _tmp1228_;
				const gchar* _tmp1229_;
				gchar** _tmp1230_;
				gchar** _tmp1231_;
				gchar** _tmp1232_;
				gint _tmp1232__length1;
				gchar* _tmp1233_;
				gchar* _tmp1234_;
				ValaHashMap* _tmp1235_;
				gint _tmp1236_;
				gboolean _tmp1237_;
				const gchar* _tmp1238_;
				gchar* _tmp1239_;
				gchar* _tmp1240_;
				ValaCCodeConstant* _tmp1241_;
				ValaCCodeConstant* _tmp1242_;
				_tmp1225_ = arg;
				_tmp1226_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1225_, VALA_TYPE_NAMED_ARGUMENT, ValaNamedArgument));
				named_arg = _tmp1226_;
				_tmp1227_ = named_arg;
				_tmp1228_ = vala_named_argument_get_name (_tmp1227_);
				_tmp1229_ = _tmp1228_;
				_tmp1231_ = _tmp1230_ = g_strsplit (_tmp1229_, "_", 0);
				_tmp1232_ = _tmp1231_;
				_tmp1232__length1 = _vala_array_length (_tmp1230_);
				_tmp1233_ = _vala_g_strjoinv ("-", _tmp1232_, _vala_array_length (_tmp1230_));
				_tmp1234_ = _tmp1233_;
				_tmp1232_ = (_vala_array_free (_tmp1232_, _tmp1232__length1, (GDestroyNotify) g_free), NULL);
				name = _tmp1234_;
				_tmp1235_ = carg_map;
				_tmp1236_ = i;
				_tmp1237_ = ellipsis;
				_tmp1238_ = name;
				_tmp1239_ = g_strdup_printf ("\"%s\"", _tmp1238_);
				_tmp1240_ = _tmp1239_;
				_tmp1241_ = vala_ccode_constant_new (_tmp1240_);
				_tmp1242_ = _tmp1241_;
				vala_map_set ((ValaMap*) _tmp1235_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, _tmp1236_ - 0.1, _tmp1237_)), (ValaCCodeExpression*) _tmp1242_);
				_vala_ccode_node_unref0 (_tmp1242_);
				_g_free0 (_tmp1240_);
				_g_free0 (name);
				_vala_code_node_unref0 (named_arg);
			}
			_tmp1243_ = i;
			i = _tmp1243_ + 1;
			_vala_map_unref0 (carg_map);
			_vala_ccode_node_unref0 (cexpr);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp1244_ = params_it;
	if (vala_iterator_next (_tmp1244_)) {
		ValaParameter* param = NULL;
		ValaIterator* _tmp1245_;
		gpointer _tmp1246_;
		gboolean _tmp1247_ = FALSE;
		ValaParameter* _tmp1248_;
		gboolean _tmp1249_;
		gboolean _tmp1250_;
		_tmp1245_ = params_it;
		_tmp1246_ = vala_iterator_get (_tmp1245_);
		param = (ValaParameter*) _tmp1246_;
		_tmp1248_ = param;
		_tmp1249_ = vala_parameter_get_params_array (_tmp1248_);
		_tmp1250_ = _tmp1249_;
		if (_tmp1250_) {
			_tmp1247_ = TRUE;
		} else {
			ValaParameter* _tmp1251_;
			gboolean _tmp1252_;
			gboolean _tmp1253_;
			_tmp1251_ = param;
			_tmp1252_ = vala_parameter_get_ellipsis (_tmp1251_);
			_tmp1253_ = _tmp1252_;
			_tmp1247_ = _tmp1253_;
		}
		_vala_assert (_tmp1247_, "param.params_array || param.ellipsis");
		ellipsis = TRUE;
		_vala_code_node_unref0 (param);
	}
	_tmp1256_ = m;
	if (_tmp1256_ != NULL) {
		ValaMethod* _tmp1257_;
		ValaDataType* _tmp1258_;
		ValaDataType* _tmp1259_;
		_tmp1257_ = m;
		_tmp1258_ = vala_callable_get_return_type ((ValaCallable*) _tmp1257_);
		_tmp1259_ = _tmp1258_;
		_tmp1255_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1259_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1255_ = FALSE;
	}
	if (_tmp1255_) {
		ValaCCodeFunctionCall* _tmp1260_;
		ValaCCodeFunctionCall* _tmp1261_;
		_tmp1260_ = async_call;
		_tmp1261_ = ccall;
		_tmp1254_ = _tmp1260_ != _tmp1261_;
	} else {
		_tmp1254_ = FALSE;
	}
	if (_tmp1254_) {
		ValaArrayType* array_type = NULL;
		ValaMethod* _tmp1262_;
		ValaDataType* _tmp1263_;
		ValaDataType* _tmp1264_;
		ValaArrayType* _tmp1265_;
		_tmp1262_ = m;
		_tmp1263_ = vala_callable_get_return_type ((ValaCallable*) _tmp1262_);
		_tmp1264_ = _tmp1263_;
		_tmp1265_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1264_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1265_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1266_ = FALSE;
				_tmp1266_ = TRUE;
				while (TRUE) {
					gint _tmp1268_;
					ValaArrayType* _tmp1269_;
					gint _tmp1270_;
					gint _tmp1271_;
					ValaMethod* _tmp1272_;
					if (!_tmp1266_) {
						gint _tmp1267_;
						_tmp1267_ = dim;
						dim = _tmp1267_ + 1;
					}
					_tmp1266_ = FALSE;
					_tmp1268_ = dim;
					_tmp1269_ = array_type;
					_tmp1270_ = vala_array_type_get_rank (_tmp1269_);
					_tmp1271_ = _tmp1270_;
					if (!(_tmp1268_ <= _tmp1271_)) {
						break;
					}
					_tmp1272_ = m;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1272_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1273_;
						ValaDataType* _tmp1274_;
						ValaDataType* _tmp1275_;
						ValaLocalVariable* _tmp1276_;
						ValaLocalVariable* _tmp1277_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1278_;
						const gchar* _tmp1279_;
						const gchar* _tmp1280_;
						ValaCCodeExpression* _tmp1281_;
						ValaLocalVariable* _tmp1282_;
						ValaCCodeExpression* _tmp1283_;
						ValaCCodeExpression* _tmp1284_;
						ValaCCodeAssignment* _tmp1285_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1286_;
						ValaCCodeIdentifier* _tmp1287_;
						ValaCCodeFunctionCall* _tmp1288_;
						ValaCCodeFunctionCall* _tmp1289_;
						ValaCCodeFunctionCall* _tmp1290_;
						ValaCCodeExpression* _tmp1291_;
						ValaCCodeFunctionCall* _tmp1292_;
						_tmp1273_ = itype;
						_tmp1274_ = vala_data_type_get_return_type (_tmp1273_);
						_tmp1275_ = _tmp1274_;
						_tmp1276_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1275_, TRUE, NULL, FALSE);
						_tmp1277_ = _tmp1276_;
						_vala_code_node_unref0 (_tmp1275_);
						temp_var = _tmp1277_;
						_tmp1278_ = temp_var;
						_tmp1279_ = vala_symbol_get_name ((ValaSymbol*) _tmp1278_);
						_tmp1280_ = _tmp1279_;
						_tmp1281_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1280_);
						temp_ref = _tmp1281_;
						_tmp1282_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1282_, FALSE);
						_tmp1283_ = temp_ref;
						_tmp1284_ = ccall_expr;
						_tmp1285_ = vala_ccode_assignment_new (_tmp1283_, _tmp1284_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1285_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1286_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1287_ = _tmp1286_;
						_tmp1288_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1287_);
						_tmp1289_ = _tmp1288_;
						_vala_ccode_node_unref0 (_tmp1287_);
						len_call = _tmp1289_;
						_tmp1290_ = len_call;
						_tmp1291_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1290_, _tmp1291_);
						_tmp1292_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1292_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaMethod* _tmp1293_;
						_tmp1293_ = m;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1293_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaMethod* _tmp1294_;
							gchar* _tmp1295_;
							gchar* _tmp1296_;
							gboolean _tmp1297_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1306_;
							const gchar* _tmp1307_;
							const gchar* _tmp1308_;
							ValaCCodeExpression* _tmp1309_;
							ValaLocalVariable* _tmp1310_;
							ValaHashMap* _tmp1311_;
							ValaMethod* _tmp1312_;
							gint _tmp1313_;
							ValaCCodeExpression* _tmp1314_;
							ValaCCodeUnaryExpression* _tmp1315_;
							ValaCCodeUnaryExpression* _tmp1316_;
							ValaCCodeExpression* _tmp1317_;
							_tmp1294_ = m;
							_tmp1295_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1294_);
							_tmp1296_ = _tmp1295_;
							_tmp1297_ = _tmp1296_ == NULL;
							_g_free0 (_tmp1296_);
							if (_tmp1297_) {
								ValaDataType* _tmp1298_;
								ValaLocalVariable* _tmp1299_;
								_tmp1298_ = ((ValaCCodeBaseModule*) self)->int_type;
								_tmp1299_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1298_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1299_;
							} else {
								ValaMethod* _tmp1300_;
								gchar* _tmp1301_;
								gchar* _tmp1302_;
								ValaCType* _tmp1303_;
								ValaCType* _tmp1304_;
								ValaLocalVariable* _tmp1305_;
								_tmp1300_ = m;
								_tmp1301_ = vala_get_ccode_array_length_type ((ValaCodeNode*) _tmp1300_);
								_tmp1302_ = _tmp1301_;
								_tmp1303_ = vala_ctype_new (_tmp1302_);
								_tmp1304_ = _tmp1303_;
								_tmp1305_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1304_, TRUE, NULL, TRUE);
								_vala_code_node_unref0 (temp_var);
								temp_var = _tmp1305_;
								_vala_code_node_unref0 (_tmp1304_);
								_g_free0 (_tmp1302_);
							}
							_tmp1306_ = temp_var;
							_tmp1307_ = vala_symbol_get_name ((ValaSymbol*) _tmp1306_);
							_tmp1308_ = _tmp1307_;
							_tmp1309_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1308_);
							temp_ref = _tmp1309_;
							_tmp1310_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1310_, FALSE);
							_tmp1311_ = out_arg_map;
							_tmp1312_ = m;
							_tmp1313_ = dim;
							_tmp1314_ = temp_ref;
							_tmp1315_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1314_);
							_tmp1316_ = _tmp1315_;
							vala_map_set ((ValaMap*) _tmp1311_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1312_) + (0.01 * _tmp1313_), FALSE)), (ValaCCodeExpression*) _tmp1316_);
							_vala_ccode_node_unref0 (_tmp1316_);
							_tmp1317_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1317_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaMethod* _tmp1318_;
							gchar* _tmp1319_;
							gchar* _tmp1320_;
							gboolean _tmp1321_;
							_tmp1318_ = m;
							_tmp1319_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1318_);
							_tmp1320_ = _tmp1319_;
							_tmp1321_ = _tmp1320_ != NULL;
							_g_free0 (_tmp1320_);
							if (_tmp1321_) {
								ValaMethod* _tmp1322_;
								gchar* _tmp1323_;
								gchar* _tmp1324_;
								ValaCCodeConstant* _tmp1325_;
								ValaCCodeConstant* _tmp1326_;
								_tmp1322_ = m;
								_tmp1323_ = vala_get_ccode_array_length_expr ((ValaCodeNode*) _tmp1322_);
								_tmp1324_ = _tmp1323_;
								_tmp1325_ = vala_ccode_constant_new (_tmp1324_);
								_tmp1326_ = _tmp1325_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1326_);
								_vala_ccode_node_unref0 (_tmp1326_);
								_g_free0 (_tmp1324_);
							} else {
								ValaCCodeConstant* _tmp1327_;
								ValaCCodeConstant* _tmp1328_;
								_tmp1327_ = vala_ccode_constant_new ("-1");
								_tmp1328_ = _tmp1327_;
								vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1328_);
								_vala_ccode_node_unref0 (_tmp1328_);
							}
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1329_ = FALSE;
		gboolean _tmp1330_ = FALSE;
		ValaMethod* _tmp1331_;
		_tmp1331_ = m;
		if (_tmp1331_ != NULL) {
			ValaMethod* _tmp1332_;
			ValaDataType* _tmp1333_;
			ValaDataType* _tmp1334_;
			_tmp1332_ = m;
			_tmp1333_ = vala_callable_get_return_type ((ValaCallable*) _tmp1332_);
			_tmp1334_ = _tmp1333_;
			_tmp1330_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1334_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1330_ = FALSE;
		}
		if (_tmp1330_) {
			ValaCCodeFunctionCall* _tmp1335_;
			ValaCCodeFunctionCall* _tmp1336_;
			_tmp1335_ = async_call;
			_tmp1336_ = ccall;
			_tmp1329_ = _tmp1335_ != _tmp1336_;
		} else {
			_tmp1329_ = FALSE;
		}
		if (_tmp1329_) {
			ValaDelegateType* deleg_type = NULL;
			ValaMethod* _tmp1337_;
			ValaDataType* _tmp1338_;
			ValaDataType* _tmp1339_;
			ValaDelegateType* _tmp1340_;
			ValaDelegateType* _tmp1341_;
			ValaDelegate* _tmp1342_;
			ValaDelegate* _tmp1343_;
			gboolean _tmp1344_;
			gboolean _tmp1345_;
			_tmp1337_ = m;
			_tmp1338_ = vala_callable_get_return_type ((ValaCallable*) _tmp1337_);
			_tmp1339_ = _tmp1338_;
			_tmp1340_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1339_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1340_;
			_tmp1341_ = deleg_type;
			_tmp1342_ = vala_delegate_type_get_delegate_symbol (_tmp1341_);
			_tmp1343_ = _tmp1342_;
			_tmp1344_ = vala_delegate_get_has_target (_tmp1343_);
			_tmp1345_ = _tmp1344_;
			if (_tmp1345_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1346_;
				ValaVoidType* _tmp1347_;
				ValaPointerType* _tmp1348_;
				ValaPointerType* _tmp1349_;
				ValaLocalVariable* _tmp1350_;
				ValaLocalVariable* _tmp1351_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1352_;
				const gchar* _tmp1353_;
				const gchar* _tmp1354_;
				ValaCCodeExpression* _tmp1355_;
				ValaLocalVariable* _tmp1356_;
				ValaHashMap* _tmp1357_;
				ValaMethod* _tmp1358_;
				ValaCCodeExpression* _tmp1359_;
				ValaCCodeUnaryExpression* _tmp1360_;
				ValaCCodeUnaryExpression* _tmp1361_;
				ValaCCodeExpression* _tmp1362_;
				ValaDelegateType* _tmp1363_;
				_tmp1346_ = vala_void_type_new (NULL);
				_tmp1347_ = _tmp1346_;
				_tmp1348_ = vala_pointer_type_new ((ValaDataType*) _tmp1347_, NULL);
				_tmp1349_ = _tmp1348_;
				_tmp1350_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1349_, TRUE, NULL, TRUE);
				_tmp1351_ = _tmp1350_;
				_vala_code_node_unref0 (_tmp1349_);
				_vala_code_node_unref0 (_tmp1347_);
				temp_var = _tmp1351_;
				_tmp1352_ = temp_var;
				_tmp1353_ = vala_symbol_get_name ((ValaSymbol*) _tmp1352_);
				_tmp1354_ = _tmp1353_;
				_tmp1355_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1354_);
				temp_ref = _tmp1355_;
				_tmp1356_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1356_, FALSE);
				_tmp1357_ = out_arg_map;
				_tmp1358_ = m;
				_tmp1359_ = temp_ref;
				_tmp1360_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1359_);
				_tmp1361_ = _tmp1360_;
				vala_map_set ((ValaMap*) _tmp1357_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1358_), FALSE)), (ValaCCodeExpression*) _tmp1361_);
				_vala_ccode_node_unref0 (_tmp1361_);
				_tmp1362_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1362_);
				_tmp1363_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1363_)) {
					ValaDataType* _tmp1364_;
					ValaLocalVariable* _tmp1365_;
					ValaLocalVariable* _tmp1366_;
					const gchar* _tmp1367_;
					const gchar* _tmp1368_;
					ValaCCodeExpression* _tmp1369_;
					ValaLocalVariable* _tmp1370_;
					ValaHashMap* _tmp1371_;
					ValaMethod* _tmp1372_;
					ValaCCodeExpression* _tmp1373_;
					ValaCCodeUnaryExpression* _tmp1374_;
					ValaCCodeUnaryExpression* _tmp1375_;
					ValaCCodeExpression* _tmp1376_;
					_tmp1364_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1365_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1364_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1365_;
					_tmp1366_ = temp_var;
					_tmp1367_ = vala_symbol_get_name ((ValaSymbol*) _tmp1366_);
					_tmp1368_ = _tmp1367_;
					_tmp1369_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1368_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1369_;
					_tmp1370_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1370_, FALSE);
					_tmp1371_ = out_arg_map;
					_tmp1372_ = m;
					_tmp1373_ = temp_ref;
					_tmp1374_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1373_);
					_tmp1375_ = _tmp1374_;
					vala_map_set ((ValaMap*) _tmp1371_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1372_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1375_);
					_vala_ccode_node_unref0 (_tmp1375_);
					_tmp1376_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1376_);
				} else {
					ValaCCodeConstant* _tmp1377_;
					ValaCCodeConstant* _tmp1378_;
					_tmp1377_ = vala_ccode_constant_new ("NULL");
					_tmp1378_ = _tmp1377_;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1378_);
					_vala_ccode_node_unref0 (_tmp1378_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			} else {
				ValaCCodeConstant* _tmp1379_;
				ValaCCodeConstant* _tmp1380_;
				_tmp1379_ = vala_ccode_constant_new ("NULL");
				_tmp1380_ = _tmp1379_;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1380_);
				_vala_ccode_node_unref0 (_tmp1380_);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1382_ = deleg;
	if (_tmp1382_ != NULL) {
		ValaDelegate* _tmp1383_;
		ValaDataType* _tmp1384_;
		ValaDataType* _tmp1385_;
		_tmp1383_ = deleg;
		_tmp1384_ = vala_callable_get_return_type ((ValaCallable*) _tmp1383_);
		_tmp1385_ = _tmp1384_;
		_tmp1381_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1385_, VALA_TYPE_ARRAY_TYPE);
	} else {
		_tmp1381_ = FALSE;
	}
	if (_tmp1381_) {
		ValaArrayType* array_type = NULL;
		ValaDelegate* _tmp1386_;
		ValaDataType* _tmp1387_;
		ValaDataType* _tmp1388_;
		ValaArrayType* _tmp1389_;
		_tmp1386_ = deleg;
		_tmp1387_ = vala_callable_get_return_type ((ValaCallable*) _tmp1386_);
		_tmp1388_ = _tmp1387_;
		_tmp1389_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1388_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1389_;
		{
			gint dim = 0;
			dim = 1;
			{
				gboolean _tmp1390_ = FALSE;
				_tmp1390_ = TRUE;
				while (TRUE) {
					gint _tmp1392_;
					ValaArrayType* _tmp1393_;
					gint _tmp1394_;
					gint _tmp1395_;
					ValaDelegate* _tmp1396_;
					if (!_tmp1390_) {
						gint _tmp1391_;
						_tmp1391_ = dim;
						dim = _tmp1391_ + 1;
					}
					_tmp1390_ = FALSE;
					_tmp1392_ = dim;
					_tmp1393_ = array_type;
					_tmp1394_ = vala_array_type_get_rank (_tmp1393_);
					_tmp1395_ = _tmp1394_;
					if (!(_tmp1392_ <= _tmp1395_)) {
						break;
					}
					_tmp1396_ = deleg;
					if (vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp1396_)) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1397_;
						ValaDataType* _tmp1398_;
						ValaDataType* _tmp1399_;
						ValaLocalVariable* _tmp1400_;
						ValaLocalVariable* _tmp1401_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1402_;
						const gchar* _tmp1403_;
						const gchar* _tmp1404_;
						ValaCCodeExpression* _tmp1405_;
						ValaLocalVariable* _tmp1406_;
						ValaCCodeExpression* _tmp1407_;
						ValaCCodeExpression* _tmp1408_;
						ValaCCodeAssignment* _tmp1409_;
						ValaCCodeFunctionCall* len_call = NULL;
						ValaCCodeIdentifier* _tmp1410_;
						ValaCCodeIdentifier* _tmp1411_;
						ValaCCodeFunctionCall* _tmp1412_;
						ValaCCodeFunctionCall* _tmp1413_;
						ValaCCodeFunctionCall* _tmp1414_;
						ValaCCodeExpression* _tmp1415_;
						ValaCCodeFunctionCall* _tmp1416_;
						_tmp1397_ = itype;
						_tmp1398_ = vala_data_type_get_return_type (_tmp1397_);
						_tmp1399_ = _tmp1398_;
						_tmp1400_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1399_, TRUE, NULL, FALSE);
						_tmp1401_ = _tmp1400_;
						_vala_code_node_unref0 (_tmp1399_);
						temp_var = _tmp1401_;
						_tmp1402_ = temp_var;
						_tmp1403_ = vala_symbol_get_name ((ValaSymbol*) _tmp1402_);
						_tmp1404_ = _tmp1403_;
						_tmp1405_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1404_);
						temp_ref = _tmp1405_;
						_tmp1406_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1406_, FALSE);
						_tmp1407_ = temp_ref;
						_tmp1408_ = ccall_expr;
						_tmp1409_ = vala_ccode_assignment_new (_tmp1407_, _tmp1408_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
						_vala_ccode_node_unref0 (ccall_expr);
						ccall_expr = (ValaCCodeExpression*) _tmp1409_;
						((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
						_tmp1410_ = vala_ccode_identifier_new ("_vala_array_length");
						_tmp1411_ = _tmp1410_;
						_tmp1412_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1411_);
						_tmp1413_ = _tmp1412_;
						_vala_ccode_node_unref0 (_tmp1411_);
						len_call = _tmp1413_;
						_tmp1414_ = len_call;
						_tmp1415_ = temp_ref;
						vala_ccode_function_call_add_argument (_tmp1414_, _tmp1415_);
						_tmp1416_ = len_call;
						vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1416_);
						_vala_ccode_node_unref0 (len_call);
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaDelegate* _tmp1417_;
						_tmp1417_ = deleg;
						if (vala_get_ccode_array_length ((ValaCodeNode*) _tmp1417_)) {
							ValaLocalVariable* temp_var = NULL;
							ValaDataType* _tmp1418_;
							ValaLocalVariable* _tmp1419_;
							ValaCCodeExpression* temp_ref = NULL;
							ValaLocalVariable* _tmp1420_;
							const gchar* _tmp1421_;
							const gchar* _tmp1422_;
							ValaCCodeExpression* _tmp1423_;
							ValaLocalVariable* _tmp1424_;
							ValaHashMap* _tmp1425_;
							ValaDelegate* _tmp1426_;
							gint _tmp1427_;
							ValaCCodeExpression* _tmp1428_;
							ValaCCodeUnaryExpression* _tmp1429_;
							ValaCCodeUnaryExpression* _tmp1430_;
							ValaCCodeExpression* _tmp1431_;
							_tmp1418_ = ((ValaCCodeBaseModule*) self)->int_type;
							_tmp1419_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1418_, TRUE, NULL, TRUE);
							temp_var = _tmp1419_;
							_tmp1420_ = temp_var;
							_tmp1421_ = vala_symbol_get_name ((ValaSymbol*) _tmp1420_);
							_tmp1422_ = _tmp1421_;
							_tmp1423_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1422_);
							temp_ref = _tmp1423_;
							_tmp1424_ = temp_var;
							vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1424_, FALSE);
							_tmp1425_ = out_arg_map;
							_tmp1426_ = deleg;
							_tmp1427_ = dim;
							_tmp1428_ = temp_ref;
							_tmp1429_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1428_);
							_tmp1430_ = _tmp1429_;
							vala_map_set ((ValaMap*) _tmp1425_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_array_length_pos ((ValaCodeNode*) _tmp1426_) + (0.01 * _tmp1427_), FALSE)), (ValaCCodeExpression*) _tmp1430_);
							_vala_ccode_node_unref0 (_tmp1430_);
							_tmp1431_ = temp_ref;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1431_);
							_vala_ccode_node_unref0 (temp_ref);
							_vala_code_node_unref0 (temp_var);
						} else {
							ValaCCodeConstant* _tmp1432_;
							ValaCCodeConstant* _tmp1433_;
							_tmp1432_ = vala_ccode_constant_new ("-1");
							_tmp1433_ = _tmp1432_;
							vala_ccode_base_module_append_array_length ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, (ValaCCodeExpression*) _tmp1433_);
							_vala_ccode_node_unref0 (_tmp1433_);
						}
					}
				}
			}
		}
		_vala_code_node_unref0 (array_type);
	} else {
		gboolean _tmp1434_ = FALSE;
		ValaDelegate* _tmp1435_;
		_tmp1435_ = deleg;
		if (_tmp1435_ != NULL) {
			ValaDelegate* _tmp1436_;
			ValaDataType* _tmp1437_;
			ValaDataType* _tmp1438_;
			_tmp1436_ = deleg;
			_tmp1437_ = vala_callable_get_return_type ((ValaCallable*) _tmp1436_);
			_tmp1438_ = _tmp1437_;
			_tmp1434_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1438_, VALA_TYPE_DELEGATE_TYPE);
		} else {
			_tmp1434_ = FALSE;
		}
		if (_tmp1434_) {
			ValaDelegateType* deleg_type = NULL;
			ValaDelegate* _tmp1439_;
			ValaDataType* _tmp1440_;
			ValaDataType* _tmp1441_;
			ValaDelegateType* _tmp1442_;
			ValaDelegateType* _tmp1443_;
			ValaDelegate* _tmp1444_;
			ValaDelegate* _tmp1445_;
			gboolean _tmp1446_;
			gboolean _tmp1447_;
			_tmp1439_ = deleg;
			_tmp1440_ = vala_callable_get_return_type ((ValaCallable*) _tmp1439_);
			_tmp1441_ = _tmp1440_;
			_tmp1442_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1441_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
			deleg_type = _tmp1442_;
			_tmp1443_ = deleg_type;
			_tmp1444_ = vala_delegate_type_get_delegate_symbol (_tmp1443_);
			_tmp1445_ = _tmp1444_;
			_tmp1446_ = vala_delegate_get_has_target (_tmp1445_);
			_tmp1447_ = _tmp1446_;
			if (_tmp1447_) {
				ValaLocalVariable* temp_var = NULL;
				ValaVoidType* _tmp1448_;
				ValaVoidType* _tmp1449_;
				ValaPointerType* _tmp1450_;
				ValaPointerType* _tmp1451_;
				ValaLocalVariable* _tmp1452_;
				ValaLocalVariable* _tmp1453_;
				ValaCCodeExpression* temp_ref = NULL;
				ValaLocalVariable* _tmp1454_;
				const gchar* _tmp1455_;
				const gchar* _tmp1456_;
				ValaCCodeExpression* _tmp1457_;
				ValaLocalVariable* _tmp1458_;
				ValaHashMap* _tmp1459_;
				ValaDelegate* _tmp1460_;
				ValaCCodeExpression* _tmp1461_;
				ValaCCodeUnaryExpression* _tmp1462_;
				ValaCCodeUnaryExpression* _tmp1463_;
				ValaCCodeExpression* _tmp1464_;
				ValaDelegateType* _tmp1465_;
				_tmp1448_ = vala_void_type_new (NULL);
				_tmp1449_ = _tmp1448_;
				_tmp1450_ = vala_pointer_type_new ((ValaDataType*) _tmp1449_, NULL);
				_tmp1451_ = _tmp1450_;
				_tmp1452_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, (ValaDataType*) _tmp1451_, TRUE, NULL, TRUE);
				_tmp1453_ = _tmp1452_;
				_vala_code_node_unref0 (_tmp1451_);
				_vala_code_node_unref0 (_tmp1449_);
				temp_var = _tmp1453_;
				_tmp1454_ = temp_var;
				_tmp1455_ = vala_symbol_get_name ((ValaSymbol*) _tmp1454_);
				_tmp1456_ = _tmp1455_;
				_tmp1457_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1456_);
				temp_ref = _tmp1457_;
				_tmp1458_ = temp_var;
				vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1458_, FALSE);
				_tmp1459_ = out_arg_map;
				_tmp1460_ = deleg;
				_tmp1461_ = temp_ref;
				_tmp1462_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1461_);
				_tmp1463_ = _tmp1462_;
				vala_map_set ((ValaMap*) _tmp1459_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1460_), FALSE)), (ValaCCodeExpression*) _tmp1463_);
				_vala_ccode_node_unref0 (_tmp1463_);
				_tmp1464_ = temp_ref;
				vala_ccode_base_module_set_delegate_target ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1464_);
				_tmp1465_ = deleg_type;
				if (vala_data_type_is_disposable ((ValaDataType*) _tmp1465_)) {
					ValaDataType* _tmp1466_;
					ValaLocalVariable* _tmp1467_;
					ValaLocalVariable* _tmp1468_;
					const gchar* _tmp1469_;
					const gchar* _tmp1470_;
					ValaCCodeExpression* _tmp1471_;
					ValaLocalVariable* _tmp1472_;
					ValaHashMap* _tmp1473_;
					ValaDelegate* _tmp1474_;
					ValaCCodeExpression* _tmp1475_;
					ValaCCodeUnaryExpression* _tmp1476_;
					ValaCCodeUnaryExpression* _tmp1477_;
					ValaCCodeExpression* _tmp1478_;
					_tmp1466_ = ((ValaCCodeBaseModule*) self)->gdestroynotify_type;
					_tmp1467_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1466_, TRUE, NULL, TRUE);
					_vala_code_node_unref0 (temp_var);
					temp_var = _tmp1467_;
					_tmp1468_ = temp_var;
					_tmp1469_ = vala_symbol_get_name ((ValaSymbol*) _tmp1468_);
					_tmp1470_ = _tmp1469_;
					_tmp1471_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1470_);
					_vala_ccode_node_unref0 (temp_ref);
					temp_ref = _tmp1471_;
					_tmp1472_ = temp_var;
					vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1472_, FALSE);
					_tmp1473_ = out_arg_map;
					_tmp1474_ = deleg;
					_tmp1475_ = temp_ref;
					_tmp1476_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1475_);
					_tmp1477_ = _tmp1476_;
					vala_map_set ((ValaMap*) _tmp1473_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_delegate_target_pos ((ValaCodeNode*) _tmp1474_) + 0.01, FALSE)), (ValaCCodeExpression*) _tmp1477_);
					_vala_ccode_node_unref0 (_tmp1477_);
					_tmp1478_ = temp_ref;
					vala_ccode_base_module_set_delegate_target_destroy_notify ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1478_);
				}
				_vala_ccode_node_unref0 (temp_ref);
				_vala_code_node_unref0 (temp_var);
			}
			_vala_code_node_unref0 (deleg_type);
		}
	}
	_tmp1480_ = m;
	if (_tmp1480_ != NULL) {
		ValaMethod* _tmp1481_;
		gboolean _tmp1482_;
		gboolean _tmp1483_;
		_tmp1481_ = m;
		_tmp1482_ = vala_method_get_coroutine (_tmp1481_);
		_tmp1483_ = _tmp1482_;
		_tmp1479_ = _tmp1483_;
	} else {
		_tmp1479_ = FALSE;
	}
	if (_tmp1479_) {
		gboolean _tmp1484_;
		gboolean _tmp1485_;
		_tmp1484_ = vala_method_call_get_is_yield_expression (expr);
		_tmp1485_ = _tmp1484_;
		if (_tmp1485_) {
			ValaHashMap* _tmp1486_;
			ValaMethod* _tmp1487_;
			ValaMethod* _tmp1488_;
			gchar* _tmp1489_;
			gchar* _tmp1490_;
			ValaCCodeIdentifier* _tmp1491_;
			ValaCCodeIdentifier* _tmp1492_;
			ValaHashMap* _tmp1493_;
			ValaCCodeIdentifier* _tmp1494_;
			ValaCCodeIdentifier* _tmp1495_;
			_tmp1486_ = in_arg_map;
			_tmp1487_ = vala_ccode_base_module_get_current_method ((ValaCCodeBaseModule*) self);
			_tmp1488_ = _tmp1487_;
			_tmp1489_ = vala_ccode_base_module_generate_ready_function ((ValaCCodeBaseModule*) self, _tmp1488_);
			_tmp1490_ = _tmp1489_;
			_tmp1491_ = vala_ccode_identifier_new (_tmp1490_);
			_tmp1492_ = _tmp1491_;
			vala_map_set ((ValaMap*) _tmp1486_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1492_);
			_vala_ccode_node_unref0 (_tmp1492_);
			_g_free0 (_tmp1490_);
			_tmp1493_ = in_arg_map;
			_tmp1494_ = vala_ccode_identifier_new ("_data_");
			_tmp1495_ = _tmp1494_;
			vala_map_set ((ValaMap*) _tmp1493_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, -0.9, FALSE)), (ValaCCodeExpression*) _tmp1495_);
			_vala_ccode_node_unref0 (_tmp1495_);
		}
	}
	_tmp1496_ = vala_code_node_get_tree_can_fail ((ValaCodeNode*) expr);
	_tmp1497_ = _tmp1496_;
	if (_tmp1497_) {
		ValaHashMap* _tmp1498_;
		ValaCCodeExpression* _tmp1499_;
		ValaCCodeExpression* _tmp1500_;
		ValaCCodeUnaryExpression* _tmp1501_;
		ValaCCodeUnaryExpression* _tmp1502_;
		vala_ccode_base_module_set_current_method_inner_error ((ValaCCodeBaseModule*) self, TRUE);
		_tmp1498_ = out_arg_map;
		_tmp1499_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, "_inner_error_");
		_tmp1500_ = _tmp1499_;
		_tmp1501_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1500_);
		_tmp1502_ = _tmp1501_;
		vala_map_set ((ValaMap*) _tmp1498_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1502_);
		_vala_ccode_node_unref0 (_tmp1502_);
		_vala_ccode_node_unref0 (_tmp1500_);
	} else {
		gboolean _tmp1503_ = FALSE;
		gboolean _tmp1504_ = FALSE;
		ValaMethod* _tmp1505_;
		_tmp1505_ = m;
		if (_tmp1505_ != NULL) {
			ValaMethod* _tmp1506_;
			_tmp1506_ = m;
			_tmp1504_ = vala_method_has_error_type_parameter (_tmp1506_);
		} else {
			_tmp1504_ = FALSE;
		}
		if (_tmp1504_) {
			ValaCCodeFunctionCall* _tmp1507_;
			ValaCCodeFunctionCall* _tmp1508_;
			_tmp1507_ = async_call;
			_tmp1508_ = ccall;
			_tmp1503_ = _tmp1507_ != _tmp1508_;
		} else {
			_tmp1503_ = FALSE;
		}
		if (_tmp1503_) {
			ValaHashMap* _tmp1509_;
			ValaCCodeConstant* _tmp1510_;
			ValaCCodeConstant* _tmp1511_;
			_tmp1509_ = out_arg_map;
			_tmp1510_ = vala_ccode_constant_new ("NULL");
			_tmp1511_ = _tmp1510_;
			vala_map_set ((ValaMap*) _tmp1509_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, FALSE)), (ValaCCodeExpression*) _tmp1511_);
			_vala_ccode_node_unref0 (_tmp1511_);
		}
	}
	_tmp1512_ = ellipsis;
	if (_tmp1512_) {
		ValaMethod* _tmp1513_;
		_tmp1513_ = m;
		if (_tmp1513_ == NULL) {
			ValaHashMap* _tmp1514_;
			ValaCCodeConstant* _tmp1515_;
			ValaCCodeConstant* _tmp1516_;
			_tmp1514_ = in_arg_map;
			_tmp1515_ = vala_ccode_constant_new ("NULL");
			_tmp1516_ = _tmp1515_;
			vala_map_set ((ValaMap*) _tmp1514_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1516_);
			_vala_ccode_node_unref0 (_tmp1516_);
		} else {
			gboolean _tmp1517_ = FALSE;
			gboolean _tmp1518_ = FALSE;
			gboolean _tmp1519_ = FALSE;
			ValaMethod* _tmp1520_;
			gboolean _tmp1521_;
			gboolean _tmp1522_;
			_tmp1520_ = m;
			_tmp1521_ = vala_method_get_printf_format (_tmp1520_);
			_tmp1522_ = _tmp1521_;
			if (!_tmp1522_) {
				ValaMethod* _tmp1523_;
				gboolean _tmp1524_;
				gboolean _tmp1525_;
				_tmp1523_ = m;
				_tmp1524_ = vala_method_get_scanf_format (_tmp1523_);
				_tmp1525_ = _tmp1524_;
				_tmp1519_ = !_tmp1525_;
			} else {
				_tmp1519_ = FALSE;
			}
			if (_tmp1519_) {
				ValaMethod* _tmp1526_;
				gchar* _tmp1527_;
				gchar* _tmp1528_;
				_tmp1526_ = m;
				_tmp1527_ = vala_get_ccode_sentinel (_tmp1526_);
				_tmp1528_ = _tmp1527_;
				_tmp1518_ = g_strcmp0 (_tmp1528_, "") != 0;
				_g_free0 (_tmp1528_);
			} else {
				_tmp1518_ = FALSE;
			}
			if (_tmp1518_) {
				gboolean _tmp1529_;
				gboolean _tmp1530_;
				_tmp1529_ = vala_method_call_get_is_constructv_chainup (expr);
				_tmp1530_ = _tmp1529_;
				_tmp1517_ = !_tmp1530_;
			} else {
				_tmp1517_ = FALSE;
			}
			if (_tmp1517_) {
				ValaHashMap* _tmp1531_;
				ValaMethod* _tmp1532_;
				gchar* _tmp1533_;
				gchar* _tmp1534_;
				ValaCCodeConstant* _tmp1535_;
				ValaCCodeConstant* _tmp1536_;
				_tmp1531_ = in_arg_map;
				_tmp1532_ = m;
				_tmp1533_ = vala_get_ccode_sentinel (_tmp1532_);
				_tmp1534_ = _tmp1533_;
				_tmp1535_ = vala_ccode_constant_new (_tmp1534_);
				_tmp1536_ = _tmp1535_;
				vala_map_set ((ValaMap*) _tmp1531_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -1, TRUE)), (ValaCCodeExpression*) _tmp1536_);
				_vala_ccode_node_unref0 (_tmp1536_);
				_g_free0 (_tmp1534_);
			}
		}
	}
	_tmp1537_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1537_, VALA_TYPE_DELEGATE_TYPE)) {
		ValaDelegateType* deleg_type = NULL;
		ValaDataType* _tmp1538_;
		ValaDelegateType* _tmp1539_;
		ValaDelegate* d = NULL;
		ValaDelegateType* _tmp1540_;
		ValaDelegate* _tmp1541_;
		ValaDelegate* _tmp1542_;
		ValaDelegate* _tmp1543_;
		ValaDelegate* _tmp1544_;
		gboolean _tmp1545_;
		gboolean _tmp1546_;
		_tmp1538_ = itype;
		_tmp1539_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1538_, VALA_TYPE_DELEGATE_TYPE, ValaDelegateType));
		deleg_type = _tmp1539_;
		_tmp1540_ = deleg_type;
		_tmp1541_ = vala_delegate_type_get_delegate_symbol (_tmp1540_);
		_tmp1542_ = _tmp1541_;
		_tmp1543_ = _vala_code_node_ref0 (_tmp1542_);
		d = _tmp1543_;
		_tmp1544_ = d;
		_tmp1545_ = vala_delegate_get_has_target (_tmp1544_);
		_tmp1546_ = _tmp1545_;
		if (_tmp1546_) {
			ValaCCodeExpression* delegate_target_destroy_notify = NULL;
			ValaHashMap* _tmp1547_;
			ValaDelegate* _tmp1548_;
			ValaExpression* _tmp1549_;
			ValaExpression* _tmp1550_;
			ValaCCodeExpression* _tmp1551_ = NULL;
			ValaCCodeExpression* _tmp1552_;
			ValaCCodeExpression* _tmp1553_;
			ValaHashMap* _tmp1554_;
			ValaDelegate* _tmp1555_;
			ValaExpression* _tmp1556_;
			ValaExpression* _tmp1557_;
			ValaCCodeExpression* _tmp1558_ = NULL;
			ValaCCodeExpression* _tmp1559_;
			ValaCCodeExpression* _tmp1560_;
			_tmp1547_ = in_arg_map;
			_tmp1548_ = d;
			_tmp1549_ = vala_method_call_get_call (expr);
			_tmp1550_ = _tmp1549_;
			_tmp1552_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1550_, &_tmp1551_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1551_;
			_tmp1553_ = _tmp1552_;
			vala_map_set ((ValaMap*) _tmp1547_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1548_), FALSE)), _tmp1553_);
			_vala_ccode_node_unref0 (_tmp1553_);
			_tmp1554_ = out_arg_map;
			_tmp1555_ = d;
			_tmp1556_ = vala_method_call_get_call (expr);
			_tmp1557_ = _tmp1556_;
			_tmp1559_ = vala_ccode_base_module_get_delegate_target_cexpression ((ValaCCodeBaseModule*) self, _tmp1557_, &_tmp1558_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
			delegate_target_destroy_notify = _tmp1558_;
			_tmp1560_ = _tmp1559_;
			vala_map_set ((ValaMap*) _tmp1554_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, vala_get_ccode_instance_pos ((ValaCodeNode*) _tmp1555_), FALSE)), _tmp1560_);
			_vala_ccode_node_unref0 (_tmp1560_);
			_vala_ccode_node_unref0 (delegate_target_destroy_notify);
		}
		_vala_code_node_unref0 (d);
		_vala_code_node_unref0 (deleg_type);
	}
	_tmp1561_ = itype;
	_tmp1562_ = vala_data_type_get_return_type (_tmp1561_);
	_tmp1563_ = _tmp1562_;
	_tmp1564_ = vala_data_type_is_real_non_null_struct_type (_tmp1563_);
	_vala_code_node_unref0 (_tmp1563_);
	return_result_via_out_param = _tmp1564_;
	_tmp1566_ = itype;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1566_, VALA_TYPE_SIGNAL_TYPE)) {
		ValaDataType* _tmp1567_;
		ValaDataType* _tmp1568_;
		ValaDataType* _tmp1569_;
		_tmp1567_ = itype;
		_tmp1568_ = vala_data_type_get_return_type (_tmp1567_);
		_tmp1569_ = _tmp1568_;
		_tmp1565_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1569_, VALA_TYPE_VOID_TYPE);
		_vala_code_node_unref0 (_tmp1569_);
	} else {
		_tmp1565_ = FALSE;
	}
	if (_tmp1565_) {
		ValaSignal* sig = NULL;
		ValaDataType* _tmp1570_;
		ValaSignal* _tmp1571_;
		ValaSignal* _tmp1572_;
		ValaSignal* _tmp1573_;
		gboolean _tmp1574_ = FALSE;
		gboolean _tmp1575_ = FALSE;
		ValaMemberAccess* _tmp1576_;
		_tmp1570_ = itype;
		_tmp1571_ = vala_signal_type_get_signal_symbol (G_TYPE_CHECK_INSTANCE_CAST (_tmp1570_, VALA_TYPE_SIGNAL_TYPE, ValaSignalType));
		_tmp1572_ = _tmp1571_;
		_tmp1573_ = _vala_code_node_ref0 (_tmp1572_);
		sig = _tmp1573_;
		_tmp1576_ = ma;
		if (_tmp1576_ != NULL) {
			ValaMemberAccess* _tmp1577_;
			ValaExpression* _tmp1578_;
			ValaExpression* _tmp1579_;
			_tmp1577_ = ma;
			_tmp1578_ = vala_member_access_get_inner (_tmp1577_);
			_tmp1579_ = _tmp1578_;
			_tmp1575_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1579_, VALA_TYPE_BASE_ACCESS);
		} else {
			_tmp1575_ = FALSE;
		}
		if (_tmp1575_) {
			ValaSignal* _tmp1580_;
			gboolean _tmp1581_;
			gboolean _tmp1582_;
			_tmp1580_ = sig;
			_tmp1581_ = vala_signal_get_is_virtual (_tmp1580_);
			_tmp1582_ = _tmp1581_;
			_tmp1574_ = _tmp1582_;
		} else {
			_tmp1574_ = FALSE;
		}
		if (_tmp1574_) {
		} else {
			gboolean _tmp1583_ = FALSE;
			ValaSignal* _tmp1584_;
			_tmp1584_ = sig;
			if (!vala_ccode_base_module_get_signal_has_emitter ((ValaCCodeBaseModule*) self, _tmp1584_)) {
				_tmp1583_ = TRUE;
			} else {
				ValaMemberAccess* _tmp1585_;
				ValaSourceReference* _tmp1586_;
				ValaSourceReference* _tmp1587_;
				ValaSourceFile* _tmp1588_;
				ValaSourceFile* _tmp1589_;
				ValaSignal* _tmp1590_;
				ValaSourceReference* _tmp1591_;
				ValaSourceReference* _tmp1592_;
				ValaSourceFile* _tmp1593_;
				ValaSourceFile* _tmp1594_;
				_tmp1585_ = ma;
				_tmp1586_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1585_);
				_tmp1587_ = _tmp1586_;
				_tmp1588_ = vala_source_reference_get_file (_tmp1587_);
				_tmp1589_ = _tmp1588_;
				_tmp1590_ = sig;
				_tmp1591_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp1590_);
				_tmp1592_ = _tmp1591_;
				_tmp1593_ = vala_source_reference_get_file (_tmp1592_);
				_tmp1594_ = _tmp1593_;
				_tmp1583_ = _tmp1589_ == _tmp1594_;
			}
			if (_tmp1583_) {
				return_result_via_out_param = TRUE;
			}
		}
		_vala_code_node_unref0 (sig);
	}
	_tmp1595_ = async_call;
	_tmp1596_ = ccall;
	if (_tmp1595_ == _tmp1596_) {
		return_result_via_out_param = FALSE;
	}
	out_param_ref = NULL;
	_tmp1597_ = return_result_via_out_param;
	if (_tmp1597_) {
		ValaLocalVariable* out_param_var = NULL;
		ValaDataType* _tmp1598_;
		ValaDataType* _tmp1599_;
		ValaDataType* _tmp1600_;
		ValaLocalVariable* _tmp1601_;
		ValaLocalVariable* _tmp1602_;
		ValaLocalVariable* _tmp1603_;
		const gchar* _tmp1604_;
		const gchar* _tmp1605_;
		ValaCCodeExpression* _tmp1606_;
		ValaLocalVariable* _tmp1607_;
		ValaHashMap* _tmp1608_;
		ValaCCodeExpression* _tmp1609_;
		ValaCCodeUnaryExpression* _tmp1610_;
		ValaCCodeUnaryExpression* _tmp1611_;
		_tmp1598_ = itype;
		_tmp1599_ = vala_data_type_get_return_type (_tmp1598_);
		_tmp1600_ = _tmp1599_;
		_tmp1601_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1600_, TRUE, NULL, TRUE);
		_tmp1602_ = _tmp1601_;
		_vala_code_node_unref0 (_tmp1600_);
		out_param_var = _tmp1602_;
		_tmp1603_ = out_param_var;
		_tmp1604_ = vala_symbol_get_name ((ValaSymbol*) _tmp1603_);
		_tmp1605_ = _tmp1604_;
		_tmp1606_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1605_);
		_vala_ccode_node_unref0 (out_param_ref);
		out_param_ref = _tmp1606_;
		_tmp1607_ = out_param_var;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1607_, FALSE);
		_tmp1608_ = out_arg_map;
		_tmp1609_ = out_param_ref;
		_tmp1610_ = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, _tmp1609_);
		_tmp1611_ = _tmp1610_;
		vala_map_set ((ValaMap*) _tmp1608_, (gpointer) ((gintptr) vala_ccode_base_module_get_param_pos ((ValaCCodeBaseModule*) self, (gdouble) -3, FALSE)), (ValaCCodeExpression*) _tmp1611_);
		_vala_ccode_node_unref0 (_tmp1611_);
		_vala_code_node_unref0 (out_param_var);
	}
	_tmp1612_ = async_call;
	_tmp1613_ = ccall;
	if (_tmp1612_ != _tmp1613_) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1630_;
			ValaCCodeFunctionCall* _tmp1631_;
			ValaHashMap* _tmp1632_;
			gint _tmp1633_;
			gpointer _tmp1634_;
			ValaCCodeExpression* _tmp1635_;
			gint _tmp1636_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1614_;
				ValaSet* _tmp1615_;
				ValaSet* _tmp1616_;
				ValaIterator* _tmp1617_;
				ValaIterator* _tmp1618_;
				_tmp1614_ = out_arg_map;
				_tmp1615_ = vala_map_get_keys ((ValaMap*) _tmp1614_);
				_tmp1616_ = _tmp1615_;
				_tmp1617_ = vala_iterable_iterator ((ValaIterable*) _tmp1616_);
				_tmp1618_ = _tmp1617_;
				_vala_iterable_unref0 (_tmp1616_);
				_pos_it = _tmp1618_;
				while (TRUE) {
					ValaIterator* _tmp1619_;
					gint pos = 0;
					ValaIterator* _tmp1620_;
					gpointer _tmp1621_;
					gboolean _tmp1622_ = FALSE;
					gint _tmp1623_;
					gint _tmp1624_;
					_tmp1619_ = _pos_it;
					if (!vala_iterator_next (_tmp1619_)) {
						break;
					}
					_tmp1620_ = _pos_it;
					_tmp1621_ = vala_iterator_get (_tmp1620_);
					pos = (gint) ((gintptr) _tmp1621_);
					_tmp1623_ = pos;
					_tmp1624_ = last_pos;
					if (_tmp1623_ > _tmp1624_) {
						gboolean _tmp1625_ = FALSE;
						gint _tmp1626_;
						_tmp1626_ = min_pos;
						if (_tmp1626_ == -1) {
							_tmp1625_ = TRUE;
						} else {
							gint _tmp1627_;
							gint _tmp1628_;
							_tmp1627_ = pos;
							_tmp1628_ = min_pos;
							_tmp1625_ = _tmp1627_ < _tmp1628_;
						}
						_tmp1622_ = _tmp1625_;
					} else {
						_tmp1622_ = FALSE;
					}
					if (_tmp1622_) {
						gint _tmp1629_;
						_tmp1629_ = pos;
						min_pos = _tmp1629_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1630_ = min_pos;
			if (_tmp1630_ == -1) {
				break;
			}
			_tmp1631_ = ccall;
			_tmp1632_ = out_arg_map;
			_tmp1633_ = min_pos;
			_tmp1634_ = vala_map_get ((ValaMap*) _tmp1632_, (gpointer) ((gintptr) _tmp1633_));
			_tmp1635_ = (ValaCCodeExpression*) _tmp1634_;
			vala_ccode_function_call_add_argument (_tmp1631_, _tmp1635_);
			_vala_ccode_node_unref0 (_tmp1635_);
			_tmp1636_ = min_pos;
			last_pos = _tmp1636_;
		}
	}
	_tmp1637_ = async_call;
	if (_tmp1637_ != NULL) {
		last_pos = -1;
		while (TRUE) {
			gint _tmp1654_;
			ValaCCodeFunctionCall* _tmp1655_;
			ValaHashMap* _tmp1656_;
			gint _tmp1657_;
			gpointer _tmp1658_;
			ValaCCodeExpression* _tmp1659_;
			gint _tmp1660_;
			min_pos = -1;
			{
				ValaIterator* _pos_it = NULL;
				ValaHashMap* _tmp1638_;
				ValaSet* _tmp1639_;
				ValaSet* _tmp1640_;
				ValaIterator* _tmp1641_;
				ValaIterator* _tmp1642_;
				_tmp1638_ = in_arg_map;
				_tmp1639_ = vala_map_get_keys ((ValaMap*) _tmp1638_);
				_tmp1640_ = _tmp1639_;
				_tmp1641_ = vala_iterable_iterator ((ValaIterable*) _tmp1640_);
				_tmp1642_ = _tmp1641_;
				_vala_iterable_unref0 (_tmp1640_);
				_pos_it = _tmp1642_;
				while (TRUE) {
					ValaIterator* _tmp1643_;
					gint pos = 0;
					ValaIterator* _tmp1644_;
					gpointer _tmp1645_;
					gboolean _tmp1646_ = FALSE;
					gint _tmp1647_;
					gint _tmp1648_;
					_tmp1643_ = _pos_it;
					if (!vala_iterator_next (_tmp1643_)) {
						break;
					}
					_tmp1644_ = _pos_it;
					_tmp1645_ = vala_iterator_get (_tmp1644_);
					pos = (gint) ((gintptr) _tmp1645_);
					_tmp1647_ = pos;
					_tmp1648_ = last_pos;
					if (_tmp1647_ > _tmp1648_) {
						gboolean _tmp1649_ = FALSE;
						gint _tmp1650_;
						_tmp1650_ = min_pos;
						if (_tmp1650_ == -1) {
							_tmp1649_ = TRUE;
						} else {
							gint _tmp1651_;
							gint _tmp1652_;
							_tmp1651_ = pos;
							_tmp1652_ = min_pos;
							_tmp1649_ = _tmp1651_ < _tmp1652_;
						}
						_tmp1646_ = _tmp1649_;
					} else {
						_tmp1646_ = FALSE;
					}
					if (_tmp1646_) {
						gint _tmp1653_;
						_tmp1653_ = pos;
						min_pos = _tmp1653_;
					}
				}
				_vala_iterator_unref0 (_pos_it);
			}
			_tmp1654_ = min_pos;
			if (_tmp1654_ == -1) {
				break;
			}
			_tmp1655_ = async_call;
			_tmp1656_ = in_arg_map;
			_tmp1657_ = min_pos;
			_tmp1658_ = vala_map_get ((ValaMap*) _tmp1656_, (gpointer) ((gintptr) _tmp1657_));
			_tmp1659_ = (ValaCCodeExpression*) _tmp1658_;
			vala_ccode_function_call_add_argument (_tmp1655_, _tmp1659_);
			_vala_ccode_node_unref0 (_tmp1659_);
			_tmp1660_ = min_pos;
			last_pos = _tmp1660_;
		}
	}
	_tmp1661_ = vala_method_call_get_is_yield_expression (expr);
	_tmp1662_ = _tmp1661_;
	if (_tmp1662_) {
		gint state = 0;
		ValaCCodeBaseModuleEmitContext* _tmp1663_;
		gint _tmp1664_;
		ValaCCodeFunction* _tmp1665_;
		ValaCCodeFunction* _tmp1666_;
		ValaCCodeIdentifier* _tmp1667_;
		ValaCCodeIdentifier* _tmp1668_;
		ValaCCodeMemberAccess* _tmp1669_;
		ValaCCodeMemberAccess* _tmp1670_;
		gint _tmp1671_;
		gchar* _tmp1672_;
		gchar* _tmp1673_;
		ValaCCodeConstant* _tmp1674_;
		ValaCCodeConstant* _tmp1675_;
		ValaCCodeFunction* _tmp1676_;
		ValaCCodeFunction* _tmp1677_;
		ValaCCodeFunctionCall* _tmp1678_;
		ValaCCodeFunction* _tmp1679_;
		ValaCCodeFunction* _tmp1680_;
		ValaCCodeConstant* _tmp1681_;
		ValaCCodeConstant* _tmp1682_;
		ValaCCodeFunction* _tmp1683_;
		ValaCCodeFunction* _tmp1684_;
		gint _tmp1685_;
		gchar* _tmp1686_;
		gchar* _tmp1687_;
		_tmp1663_ = ((ValaCCodeBaseModule*) self)->emit_context;
		_tmp1664_ = _tmp1663_->next_coroutine_state;
		_tmp1663_->next_coroutine_state = _tmp1664_ + 1;
		state = _tmp1664_;
		_tmp1665_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1666_ = _tmp1665_;
		_tmp1667_ = vala_ccode_identifier_new ("_data_");
		_tmp1668_ = _tmp1667_;
		_tmp1669_ = vala_ccode_member_access_new_pointer ((ValaCCodeExpression*) _tmp1668_, "_state_");
		_tmp1670_ = _tmp1669_;
		_tmp1671_ = state;
		_tmp1672_ = g_strdup_printf ("%i", _tmp1671_);
		_tmp1673_ = _tmp1672_;
		_tmp1674_ = vala_ccode_constant_new (_tmp1673_);
		_tmp1675_ = _tmp1674_;
		vala_ccode_function_add_assignment (_tmp1666_, (ValaCCodeExpression*) _tmp1670_, (ValaCCodeExpression*) _tmp1675_);
		_vala_ccode_node_unref0 (_tmp1675_);
		_g_free0 (_tmp1673_);
		_vala_ccode_node_unref0 (_tmp1670_);
		_vala_ccode_node_unref0 (_tmp1668_);
		_tmp1676_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1677_ = _tmp1676_;
		_tmp1678_ = async_call;
		vala_ccode_function_add_expression (_tmp1677_, (ValaCCodeExpression*) _tmp1678_);
		_tmp1679_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1680_ = _tmp1679_;
		_tmp1681_ = vala_ccode_constant_new ("FALSE");
		_tmp1682_ = _tmp1681_;
		vala_ccode_function_add_return (_tmp1680_, (ValaCCodeExpression*) _tmp1682_);
		_vala_ccode_node_unref0 (_tmp1682_);
		_tmp1683_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1684_ = _tmp1683_;
		_tmp1685_ = state;
		_tmp1686_ = g_strdup_printf ("_state_%d", _tmp1685_);
		_tmp1687_ = _tmp1686_;
		vala_ccode_function_add_label (_tmp1684_, _tmp1687_);
		_g_free0 (_tmp1687_);
	}
	_tmp1688_ = vala_method_call_get_is_assert (expr);
	_tmp1689_ = _tmp1688_;
	if (_tmp1689_) {
		gchar* message = NULL;
		ValaSourceReference* _tmp1690_;
		ValaSourceReference* _tmp1691_;
		ValaSourceLocation _tmp1692_ = {0};
		ValaSourceLocation _tmp1693_;
		gchar* _tmp1694_;
		ValaSourceReference* _tmp1695_;
		ValaSourceReference* _tmp1696_;
		ValaSourceLocation _tmp1697_ = {0};
		ValaSourceLocation _tmp1698_;
		gchar* _tmp1699_;
		ValaSourceReference* _tmp1700_;
		ValaSourceReference* _tmp1701_;
		ValaSourceLocation _tmp1702_ = {0};
		ValaSourceLocation _tmp1703_;
		gchar* _tmp1704_;
		gchar* _tmp1705_;
		ValaCCodeFunctionCall* _tmp1706_;
		ValaCCodeIdentifier* _tmp1707_;
		ValaCCodeIdentifier* _tmp1708_;
		ValaCCodeFunctionCall* _tmp1709_;
		const gchar* _tmp1710_;
		gchar* _tmp1711_;
		gchar* _tmp1712_;
		gchar* _tmp1713_;
		gchar* _tmp1714_;
		gchar* _tmp1715_;
		gchar* _tmp1716_;
		ValaCCodeConstant* _tmp1717_;
		ValaCCodeConstant* _tmp1718_;
		_tmp1690_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1691_ = _tmp1690_;
		vala_source_reference_get_begin (_tmp1691_, &_tmp1692_);
		_tmp1693_ = _tmp1692_;
		_tmp1694_ = _tmp1693_.pos;
		_tmp1695_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1696_ = _tmp1695_;
		vala_source_reference_get_end (_tmp1696_, &_tmp1697_);
		_tmp1698_ = _tmp1697_;
		_tmp1699_ = _tmp1698_.pos;
		_tmp1700_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
		_tmp1701_ = _tmp1700_;
		vala_source_reference_get_begin (_tmp1701_, &_tmp1702_);
		_tmp1703_ = _tmp1702_;
		_tmp1704_ = _tmp1703_.pos;
		_tmp1705_ = string_substring ((const gchar*) _tmp1694_, (glong) 0, (glong) ((gint) (_tmp1699_ - _tmp1704_)));
		message = _tmp1705_;
		_tmp1706_ = ccall;
		_tmp1707_ = vala_ccode_identifier_new ("_vala_assert");
		_tmp1708_ = _tmp1707_;
		vala_ccode_function_call_set_call (_tmp1706_, (ValaCCodeExpression*) _tmp1708_);
		_vala_ccode_node_unref0 (_tmp1708_);
		_tmp1709_ = ccall;
		_tmp1710_ = message;
		_tmp1711_ = string_replace (_tmp1710_, "\n", " ");
		_tmp1712_ = _tmp1711_;
		_tmp1713_ = g_strescape (_tmp1712_, "");
		_tmp1714_ = _tmp1713_;
		_tmp1715_ = g_strdup_printf ("\"%s\"", _tmp1714_);
		_tmp1716_ = _tmp1715_;
		_tmp1717_ = vala_ccode_constant_new (_tmp1716_);
		_tmp1718_ = _tmp1717_;
		vala_ccode_function_call_add_argument (_tmp1709_, (ValaCCodeExpression*) _tmp1718_);
		_vala_ccode_node_unref0 (_tmp1718_);
		_g_free0 (_tmp1716_);
		_g_free0 (_tmp1714_);
		_g_free0 (_tmp1712_);
		((ValaCCodeBaseModule*) self)->requires_assert = TRUE;
		_g_free0 (message);
	}
	_tmp1719_ = return_result_via_out_param;
	if (_tmp1719_) {
		ValaCCodeFunction* _tmp1720_;
		ValaCCodeFunction* _tmp1721_;
		ValaCCodeExpression* _tmp1722_;
		ValaCCodeExpression* _tmp1723_;
		ValaCCodeExpression* _tmp1724_;
		_tmp1720_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1721_ = _tmp1720_;
		_tmp1722_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1721_, _tmp1722_);
		_tmp1723_ = out_param_ref;
		_tmp1724_ = _vala_ccode_node_ref0 (_tmp1723_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = _tmp1724_;
	}
	_tmp1727_ = m;
	if (_tmp1727_ != NULL) {
		ValaMethod* _tmp1728_;
		ValaMemberBinding _tmp1729_;
		ValaMemberBinding _tmp1730_;
		_tmp1728_ = m;
		_tmp1729_ = vala_method_get_binding (_tmp1728_);
		_tmp1730_ = _tmp1729_;
		_tmp1726_ = _tmp1730_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp1726_ = FALSE;
	}
	if (_tmp1726_) {
		ValaMethod* _tmp1731_;
		gboolean _tmp1732_;
		gboolean _tmp1733_;
		_tmp1731_ = m;
		_tmp1732_ = vala_method_get_returns_modified_pointer (_tmp1731_);
		_tmp1733_ = _tmp1732_;
		_tmp1725_ = _tmp1733_;
	} else {
		_tmp1725_ = FALSE;
	}
	if (_tmp1725_) {
		gboolean _tmp1734_ = FALSE;
		gboolean _tmp1735_ = FALSE;
		ValaMemberAccess* _tmp1736_;
		_tmp1736_ = ma;
		if (_tmp1736_ != NULL) {
			ValaMemberAccess* _tmp1737_;
			ValaExpression* _tmp1738_;
			ValaExpression* _tmp1739_;
			ValaSymbol* _tmp1740_;
			ValaSymbol* _tmp1741_;
			_tmp1737_ = ma;
			_tmp1738_ = vala_member_access_get_inner (_tmp1737_);
			_tmp1739_ = _tmp1738_;
			_tmp1740_ = vala_expression_get_symbol_reference (_tmp1739_);
			_tmp1741_ = _tmp1740_;
			_tmp1735_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1741_, VALA_TYPE_PROPERTY);
		} else {
			_tmp1735_ = FALSE;
		}
		if (_tmp1735_) {
			ValaMemberAccess* _tmp1742_;
			ValaExpression* _tmp1743_;
			ValaExpression* _tmp1744_;
			_tmp1742_ = ma;
			_tmp1743_ = vala_member_access_get_inner (_tmp1742_);
			_tmp1744_ = _tmp1743_;
			_tmp1734_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1744_, VALA_TYPE_MEMBER_ACCESS);
		} else {
			_tmp1734_ = FALSE;
		}
		if (_tmp1734_) {
			ValaProperty* prop = NULL;
			ValaMemberAccess* _tmp1745_;
			ValaExpression* _tmp1746_;
			ValaExpression* _tmp1747_;
			ValaSymbol* _tmp1748_;
			ValaSymbol* _tmp1749_;
			ValaProperty* _tmp1750_;
			ValaProperty* _tmp1751_;
			ValaMemberAccess* _tmp1752_;
			ValaExpression* _tmp1753_;
			ValaExpression* _tmp1754_;
			ValaExpression* _tmp1755_;
			ValaExpression* _tmp1756_;
			ValaDataType* _tmp1757_;
			ValaDataType* _tmp1758_;
			ValaCCodeExpression* _tmp1759_;
			ValaGLibValue* _tmp1760_;
			ValaGLibValue* _tmp1761_;
			_tmp1745_ = ma;
			_tmp1746_ = vala_member_access_get_inner (_tmp1745_);
			_tmp1747_ = _tmp1746_;
			_tmp1748_ = vala_expression_get_symbol_reference (_tmp1747_);
			_tmp1749_ = _tmp1748_;
			_tmp1750_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1749_, VALA_TYPE_PROPERTY, ValaProperty));
			prop = _tmp1750_;
			_tmp1751_ = prop;
			_tmp1752_ = ma;
			_tmp1753_ = vala_member_access_get_inner (_tmp1752_);
			_tmp1754_ = _tmp1753_;
			_tmp1755_ = vala_member_access_get_inner (G_TYPE_CHECK_INSTANCE_CAST (_tmp1754_, VALA_TYPE_MEMBER_ACCESS, ValaMemberAccess));
			_tmp1756_ = _tmp1755_;
			_tmp1757_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1758_ = _tmp1757_;
			_tmp1759_ = ccall_expr;
			_tmp1760_ = vala_glib_value_new (_tmp1758_, _tmp1759_, FALSE);
			_tmp1761_ = _tmp1760_;
			vala_ccode_base_module_store_property ((ValaCCodeBaseModule*) self, _tmp1751_, _tmp1756_, (ValaTargetValue*) _tmp1761_);
			_vala_target_value_unref0 (_tmp1761_);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = NULL;
			_vala_code_node_unref0 (prop);
		} else {
			ValaCCodeExpression* _tmp1762_;
			ValaCCodeExpression* _tmp1763_;
			ValaCCodeAssignment* _tmp1764_;
			_tmp1762_ = instance;
			_tmp1763_ = ccall_expr;
			_tmp1764_ = vala_ccode_assignment_new (_tmp1762_, _tmp1763_, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
			_vala_ccode_node_unref0 (ccall_expr);
			ccall_expr = (ValaCCodeExpression*) _tmp1764_;
		}
	}
	_tmp1767_ = m;
	if (_tmp1767_ != NULL) {
		ValaMethod* _tmp1768_;
		gchar* _tmp1769_;
		gchar* _tmp1770_;
		_tmp1768_ = m;
		_tmp1769_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1768_);
		_tmp1770_ = _tmp1769_;
		_tmp1766_ = _tmp1770_ != NULL;
		_g_free0 (_tmp1770_);
	} else {
		_tmp1766_ = FALSE;
	}
	if (_tmp1766_) {
		ValaMethod* _tmp1771_;
		gchar* _tmp1772_;
		gchar* _tmp1773_;
		ValaMethod* _tmp1774_;
		ValaDataType* _tmp1775_;
		ValaDataType* _tmp1776_;
		gchar* _tmp1777_;
		gchar* _tmp1778_;
		_tmp1771_ = m;
		_tmp1772_ = vala_get_ccode_type ((ValaCodeNode*) _tmp1771_);
		_tmp1773_ = _tmp1772_;
		_tmp1774_ = m;
		_tmp1775_ = vala_callable_get_return_type ((ValaCallable*) _tmp1774_);
		_tmp1776_ = _tmp1775_;
		_tmp1777_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1776_);
		_tmp1778_ = _tmp1777_;
		_tmp1765_ = g_strcmp0 (_tmp1773_, _tmp1778_) != 0;
		_g_free0 (_tmp1778_);
		_g_free0 (_tmp1773_);
	} else {
		_tmp1765_ = FALSE;
	}
	if (_tmp1765_) {
		ValaCCodeExpression* _tmp1779_;
		ValaMethod* _tmp1780_;
		ValaDataType* _tmp1781_;
		ValaDataType* _tmp1782_;
		gchar* _tmp1783_;
		gchar* _tmp1784_;
		ValaCCodeCastExpression* _tmp1785_;
		_tmp1779_ = ccall_expr;
		_tmp1780_ = m;
		_tmp1781_ = vala_callable_get_return_type ((ValaCallable*) _tmp1780_);
		_tmp1782_ = _tmp1781_;
		_tmp1783_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1782_);
		_tmp1784_ = _tmp1783_;
		_tmp1785_ = vala_ccode_cast_expression_new (_tmp1779_, _tmp1784_);
		_vala_ccode_node_unref0 (ccall_expr);
		ccall_expr = (ValaCCodeExpression*) _tmp1785_;
		_g_free0 (_tmp1784_);
	}
	_tmp1786_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1786_, VALA_TYPE_ARRAY_RESIZE_METHOD)) {
		ValaIterator* arg_it = NULL;
		ValaList* _tmp1787_;
		ValaList* _tmp1788_;
		ValaIterator* _tmp1789_;
		ValaIterator* _tmp1790_;
		ValaIterator* _tmp1791_;
		ValaCCodeExpression* new_size = NULL;
		ValaIterator* _tmp1792_;
		gpointer _tmp1793_;
		ValaExpression* _tmp1794_;
		ValaCCodeExpression* _tmp1795_;
		ValaCCodeExpression* _tmp1796_;
		ValaLocalVariable* temp_decl = NULL;
		ValaDataType* _tmp1797_;
		ValaLocalVariable* _tmp1798_;
		ValaCCodeExpression* temp_ref = NULL;
		ValaLocalVariable* _tmp1799_;
		const gchar* _tmp1800_;
		const gchar* _tmp1801_;
		ValaCCodeExpression* _tmp1802_;
		ValaLocalVariable* _tmp1803_;
		ValaCCodeFile* _tmp1804_;
		ValaCCodeExpression* clen = NULL;
		ValaMemberAccess* _tmp1805_;
		ValaExpression* _tmp1806_;
		ValaExpression* _tmp1807_;
		ValaCCodeExpression* _tmp1808_;
		ValaCCodeExpression* celems = NULL;
		ValaMemberAccess* _tmp1809_;
		ValaExpression* _tmp1810_;
		ValaExpression* _tmp1811_;
		ValaCCodeExpression* _tmp1812_;
		ValaArrayType* array_type = NULL;
		ValaMemberAccess* _tmp1813_;
		ValaExpression* _tmp1814_;
		ValaExpression* _tmp1815_;
		ValaDataType* _tmp1816_;
		ValaDataType* _tmp1817_;
		ValaArrayType* _tmp1818_;
		ValaCCodeIdentifier* csizeof = NULL;
		ValaArrayType* _tmp1819_;
		ValaDataType* _tmp1820_;
		ValaDataType* _tmp1821_;
		gchar* _tmp1822_;
		gchar* _tmp1823_;
		gchar* _tmp1824_;
		gchar* _tmp1825_;
		ValaCCodeIdentifier* _tmp1826_;
		ValaCCodeIdentifier* _tmp1827_;
		ValaCCodeBinaryExpression* cdelta = NULL;
		ValaCCodeExpression* _tmp1828_;
		ValaCCodeExpression* _tmp1829_;
		ValaCCodeBinaryExpression* _tmp1830_;
		ValaCCodeBinaryExpression* ccheck = NULL;
		ValaCCodeExpression* _tmp1831_;
		ValaCCodeExpression* _tmp1832_;
		ValaCCodeBinaryExpression* _tmp1833_;
		ValaCCodeFunctionCall* czero = NULL;
		ValaCCodeIdentifier* _tmp1834_;
		ValaCCodeIdentifier* _tmp1835_;
		ValaCCodeFunctionCall* _tmp1836_;
		ValaCCodeFunctionCall* _tmp1837_;
		ValaCCodeFunctionCall* _tmp1838_;
		ValaCCodeExpression* _tmp1839_;
		ValaCCodeExpression* _tmp1840_;
		ValaCCodeBinaryExpression* _tmp1841_;
		ValaCCodeBinaryExpression* _tmp1842_;
		ValaCCodeFunctionCall* _tmp1843_;
		ValaCCodeConstant* _tmp1844_;
		ValaCCodeConstant* _tmp1845_;
		ValaCCodeFunctionCall* _tmp1846_;
		ValaCCodeIdentifier* _tmp1847_;
		ValaCCodeBinaryExpression* _tmp1848_;
		ValaCCodeBinaryExpression* _tmp1849_;
		ValaCCodeBinaryExpression* _tmp1850_;
		ValaCCodeFunction* _tmp1851_;
		ValaCCodeFunction* _tmp1852_;
		ValaCCodeExpression* _tmp1853_;
		ValaCCodeExpression* _tmp1854_;
		ValaCCodeFunction* _tmp1855_;
		ValaCCodeFunction* _tmp1856_;
		ValaCCodeExpression* _tmp1857_;
		ValaCCodeFunction* _tmp1858_;
		ValaCCodeFunction* _tmp1859_;
		ValaCCodeBinaryExpression* _tmp1860_;
		ValaCCodeFunctionCall* _tmp1861_;
		ValaCCodeConstant* _tmp1862_;
		ValaCCodeConstant* _tmp1863_;
		ValaCCodeConditionalExpression* _tmp1864_;
		ValaCCodeConditionalExpression* _tmp1865_;
		ValaCCodeFunction* _tmp1866_;
		ValaCCodeFunction* _tmp1867_;
		ValaMemberAccess* _tmp1868_;
		ValaExpression* _tmp1869_;
		ValaExpression* _tmp1870_;
		ValaCCodeExpression* _tmp1871_;
		ValaCCodeExpression* _tmp1872_;
		ValaCCodeExpression* _tmp1873_;
		ValaSymbol* array_var = NULL;
		ValaMemberAccess* _tmp1874_;
		ValaExpression* _tmp1875_;
		ValaExpression* _tmp1876_;
		ValaSymbol* _tmp1877_;
		ValaSymbol* _tmp1878_;
		ValaSymbol* _tmp1879_;
		ValaLocalVariable* array_local = NULL;
		ValaSymbol* _tmp1880_;
		ValaLocalVariable* _tmp1881_;
		gboolean _tmp1882_ = FALSE;
		gboolean _tmp1883_ = FALSE;
		ValaSymbol* _tmp1884_;
		_tmp1787_ = vala_method_call_get_argument_list (expr);
		_tmp1788_ = _tmp1787_;
		_tmp1789_ = vala_iterable_iterator ((ValaIterable*) _tmp1788_);
		_tmp1790_ = _tmp1789_;
		_vala_iterable_unref0 (_tmp1788_);
		arg_it = _tmp1790_;
		_tmp1791_ = arg_it;
		vala_iterator_next (_tmp1791_);
		_tmp1792_ = arg_it;
		_tmp1793_ = vala_iterator_get (_tmp1792_);
		_tmp1794_ = (ValaExpression*) _tmp1793_;
		_tmp1795_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1794_);
		_tmp1796_ = _tmp1795_;
		_vala_code_node_unref0 (_tmp1794_);
		new_size = _tmp1796_;
		_tmp1797_ = ((ValaCCodeBaseModule*) self)->int_type;
		_tmp1798_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1797_, TRUE, NULL, FALSE);
		temp_decl = _tmp1798_;
		_tmp1799_ = temp_decl;
		_tmp1800_ = vala_symbol_get_name ((ValaSymbol*) _tmp1799_);
		_tmp1801_ = _tmp1800_;
		_tmp1802_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1801_);
		temp_ref = _tmp1802_;
		_tmp1803_ = temp_decl;
		vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1803_, FALSE);
		_tmp1804_ = ((ValaCCodeBaseModule*) self)->cfile;
		vala_ccode_file_add_include (_tmp1804_, "string.h", FALSE);
		_tmp1805_ = ma;
		_tmp1806_ = vala_member_access_get_inner (_tmp1805_);
		_tmp1807_ = _tmp1806_;
		_tmp1808_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1807_, 1);
		clen = _tmp1808_;
		_tmp1809_ = ma;
		_tmp1810_ = vala_member_access_get_inner (_tmp1809_);
		_tmp1811_ = _tmp1810_;
		_tmp1812_ = vala_ccode_base_module_get_cvalue ((ValaCCodeBaseModule*) self, _tmp1811_);
		celems = _tmp1812_;
		_tmp1813_ = ma;
		_tmp1814_ = vala_member_access_get_inner (_tmp1813_);
		_tmp1815_ = _tmp1814_;
		_tmp1816_ = vala_expression_get_value_type (_tmp1815_);
		_tmp1817_ = _tmp1816_;
		_tmp1818_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1817_, VALA_TYPE_ARRAY_TYPE, ValaArrayType));
		array_type = _tmp1818_;
		_tmp1819_ = array_type;
		_tmp1820_ = vala_array_type_get_element_type (_tmp1819_);
		_tmp1821_ = _tmp1820_;
		_tmp1822_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1821_);
		_tmp1823_ = _tmp1822_;
		_tmp1824_ = g_strdup_printf ("sizeof (%s)", _tmp1823_);
		_tmp1825_ = _tmp1824_;
		_tmp1826_ = vala_ccode_identifier_new (_tmp1825_);
		_tmp1827_ = _tmp1826_;
		_g_free0 (_tmp1825_);
		_g_free0 (_tmp1823_);
		csizeof = _tmp1827_;
		_tmp1828_ = temp_ref;
		_tmp1829_ = clen;
		_tmp1830_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MINUS, _tmp1828_, _tmp1829_);
		cdelta = _tmp1830_;
		_tmp1831_ = temp_ref;
		_tmp1832_ = clen;
		_tmp1833_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_GREATER_THAN, _tmp1831_, _tmp1832_);
		ccheck = _tmp1833_;
		_tmp1834_ = vala_ccode_identifier_new ("memset");
		_tmp1835_ = _tmp1834_;
		_tmp1836_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp1835_);
		_tmp1837_ = _tmp1836_;
		_vala_ccode_node_unref0 (_tmp1835_);
		czero = _tmp1837_;
		_tmp1838_ = czero;
		_tmp1839_ = celems;
		_tmp1840_ = clen;
		_tmp1841_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_PLUS, _tmp1839_, _tmp1840_);
		_tmp1842_ = _tmp1841_;
		vala_ccode_function_call_add_argument (_tmp1838_, (ValaCCodeExpression*) _tmp1842_);
		_vala_ccode_node_unref0 (_tmp1842_);
		_tmp1843_ = czero;
		_tmp1844_ = vala_ccode_constant_new ("0");
		_tmp1845_ = _tmp1844_;
		vala_ccode_function_call_add_argument (_tmp1843_, (ValaCCodeExpression*) _tmp1845_);
		_vala_ccode_node_unref0 (_tmp1845_);
		_tmp1846_ = czero;
		_tmp1847_ = csizeof;
		_tmp1848_ = cdelta;
		_tmp1849_ = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, (ValaCCodeExpression*) _tmp1847_, (ValaCCodeExpression*) _tmp1848_);
		_tmp1850_ = _tmp1849_;
		vala_ccode_function_call_add_argument (_tmp1846_, (ValaCCodeExpression*) _tmp1850_);
		_vala_ccode_node_unref0 (_tmp1850_);
		_tmp1851_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1852_ = _tmp1851_;
		_tmp1853_ = temp_ref;
		_tmp1854_ = new_size;
		vala_ccode_function_add_assignment (_tmp1852_, _tmp1853_, _tmp1854_);
		_tmp1855_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1856_ = _tmp1855_;
		_tmp1857_ = ccall_expr;
		vala_ccode_function_add_expression (_tmp1856_, _tmp1857_);
		_tmp1858_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1859_ = _tmp1858_;
		_tmp1860_ = ccheck;
		_tmp1861_ = czero;
		_tmp1862_ = vala_ccode_constant_new ("NULL");
		_tmp1863_ = _tmp1862_;
		_tmp1864_ = vala_ccode_conditional_expression_new ((ValaCCodeExpression*) _tmp1860_, (ValaCCodeExpression*) _tmp1861_, (ValaCCodeExpression*) _tmp1863_);
		_tmp1865_ = _tmp1864_;
		vala_ccode_function_add_expression (_tmp1859_, (ValaCCodeExpression*) _tmp1865_);
		_vala_ccode_node_unref0 (_tmp1865_);
		_vala_ccode_node_unref0 (_tmp1863_);
		_tmp1866_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp1867_ = _tmp1866_;
		_tmp1868_ = ma;
		_tmp1869_ = vala_member_access_get_inner (_tmp1868_);
		_tmp1870_ = _tmp1869_;
		_tmp1871_ = vala_ccode_base_module_get_array_length_cexpression ((ValaCCodeBaseModule*) self, _tmp1870_, 1);
		_tmp1872_ = _tmp1871_;
		_tmp1873_ = temp_ref;
		vala_ccode_function_add_assignment (_tmp1867_, _tmp1872_, _tmp1873_);
		_vala_ccode_node_unref0 (_tmp1872_);
		_tmp1874_ = ma;
		_tmp1875_ = vala_member_access_get_inner (_tmp1874_);
		_tmp1876_ = _tmp1875_;
		_tmp1877_ = vala_expression_get_symbol_reference (_tmp1876_);
		_tmp1878_ = _tmp1877_;
		_tmp1879_ = _vala_code_node_ref0 (_tmp1878_);
		array_var = _tmp1879_;
		_tmp1880_ = array_var;
		_tmp1881_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1880_, VALA_TYPE_LOCAL_VARIABLE) ? ((ValaLocalVariable*) _tmp1880_) : NULL);
		array_local = _tmp1881_;
		_tmp1884_ = array_var;
		if (_tmp1884_ != NULL) {
			ValaSymbol* _tmp1885_;
			_tmp1885_ = array_var;
			_tmp1883_ = vala_symbol_is_internal_symbol (_tmp1885_);
		} else {
			_tmp1883_ = FALSE;
		}
		if (_tmp1883_) {
			gboolean _tmp1886_ = FALSE;
			gboolean _tmp1887_ = FALSE;
			ValaSymbol* _tmp1888_;
			_tmp1888_ = array_var;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1888_, VALA_TYPE_LOCAL_VARIABLE)) {
				ValaLocalVariable* _tmp1889_;
				gboolean _tmp1890_;
				gboolean _tmp1891_;
				_tmp1889_ = array_local;
				_tmp1890_ = vala_local_variable_get_captured (_tmp1889_);
				_tmp1891_ = _tmp1890_;
				_tmp1887_ = !_tmp1891_;
			} else {
				_tmp1887_ = FALSE;
			}
			if (_tmp1887_) {
				_tmp1886_ = TRUE;
			} else {
				ValaSymbol* _tmp1892_;
				_tmp1892_ = array_var;
				_tmp1886_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp1892_, VALA_TYPE_FIELD);
			}
			_tmp1882_ = _tmp1886_;
		} else {
			_tmp1882_ = FALSE;
		}
		if (_tmp1882_) {
			ValaCCodeFunction* _tmp1893_;
			ValaCCodeFunction* _tmp1894_;
			ValaMemberAccess* _tmp1895_;
			ValaExpression* _tmp1896_;
			ValaExpression* _tmp1897_;
			ValaTargetValue* _tmp1898_;
			ValaTargetValue* _tmp1899_;
			ValaCCodeExpression* _tmp1900_;
			ValaCCodeExpression* _tmp1901_;
			ValaCCodeExpression* _tmp1902_;
			_tmp1893_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1894_ = _tmp1893_;
			_tmp1895_ = ma;
			_tmp1896_ = vala_member_access_get_inner (_tmp1895_);
			_tmp1897_ = _tmp1896_;
			_tmp1898_ = vala_expression_get_target_value (_tmp1897_);
			_tmp1899_ = _tmp1898_;
			_tmp1900_ = vala_ccode_base_module_get_array_size_cvalue ((ValaCCodeBaseModule*) self, _tmp1899_);
			_tmp1901_ = _tmp1900_;
			_tmp1902_ = temp_ref;
			vala_ccode_function_add_assignment (_tmp1894_, _tmp1901_, _tmp1902_);
			_vala_ccode_node_unref0 (_tmp1901_);
		}
		_vala_code_node_unref0 (array_local);
		_vala_code_node_unref0 (array_var);
		_vala_ccode_node_unref0 (czero);
		_vala_ccode_node_unref0 (ccheck);
		_vala_ccode_node_unref0 (cdelta);
		_vala_ccode_node_unref0 (csizeof);
		_vala_code_node_unref0 (array_type);
		_vala_ccode_node_unref0 (celems);
		_vala_ccode_node_unref0 (clen);
		_vala_ccode_node_unref0 (temp_ref);
		_vala_code_node_unref0 (temp_decl);
		_vala_ccode_node_unref0 (new_size);
		_vala_iterator_unref0 (arg_it);
		_vala_ccode_node_unref0 (out_param_ref);
		_vala_iterator_unref0 (params_it);
		_vala_ccode_node_unref0 (instance);
		_vala_ccode_node_unref0 (ccall_expr);
		_vala_map_unref0 (out_arg_map);
		_vala_map_unref0 (in_arg_map);
		_vala_code_node_unref0 (itype);
		_vala_code_node_unref0 (ma);
		_vala_iterable_unref0 (params);
		_vala_code_node_unref0 (deleg);
		_vala_code_node_unref0 (m);
		_vala_ccode_node_unref0 (finish_call);
		_vala_ccode_node_unref0 (async_call);
		_vala_ccode_node_unref0 (ccall);
		return;
	}
	_tmp1904_ = vala_code_node_get_parent_node ((ValaCodeNode*) expr);
	_tmp1905_ = _tmp1904_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1905_, VALA_TYPE_EXPRESSION_STATEMENT)) {
		ValaDataType* _tmp1906_;
		ValaDataType* _tmp1907_;
		_tmp1906_ = vala_expression_get_value_type ((ValaExpression*) expr);
		_tmp1907_ = _tmp1906_;
		_tmp1903_ = !vala_data_type_is_disposable (_tmp1907_);
	} else {
		_tmp1903_ = FALSE;
	}
	if (_tmp1903_) {
		gboolean _tmp1908_ = FALSE;
		ValaCCodeExpression* _tmp1909_;
		_tmp1909_ = ccall_expr;
		if (_tmp1909_ != NULL) {
			gboolean _tmp1910_;
			_tmp1910_ = return_result_via_out_param;
			_tmp1908_ = !_tmp1910_;
		} else {
			_tmp1908_ = FALSE;
		}
		if (_tmp1908_) {
			ValaCCodeFunction* _tmp1911_;
			ValaCCodeFunction* _tmp1912_;
			ValaCCodeExpression* _tmp1913_;
			_tmp1911_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp1912_ = _tmp1911_;
			_tmp1913_ = ccall_expr;
			vala_ccode_function_add_expression (_tmp1912_, _tmp1913_);
		}
	} else {
		ValaDataType* result_type = NULL;
		ValaDataType* _tmp1914_;
		ValaDataType* _tmp1915_;
		gboolean _tmp1916_ = FALSE;
		ValaDataType* _tmp1917_;
		ValaDataType* _tmp1918_;
		gboolean _tmp1945_ = FALSE;
		ValaMethod* _tmp1946_;
		_tmp1914_ = itype;
		_tmp1915_ = vala_data_type_get_return_type (_tmp1914_);
		result_type = _tmp1915_;
		_tmp1917_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
		_tmp1918_ = _tmp1917_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1918_, VALA_TYPE_GENERIC_TYPE)) {
			ValaDataType* _tmp1919_;
			ValaDataType* _tmp1920_;
			_tmp1919_ = vala_expression_get_value_type ((ValaExpression*) expr);
			_tmp1920_ = _tmp1919_;
			_tmp1916_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp1920_, VALA_TYPE_GENERIC_TYPE);
		} else {
			_tmp1916_ = FALSE;
		}
		if (_tmp1916_) {
			ValaTypeParameter* type_parameter = NULL;
			ValaDataType* _tmp1921_;
			ValaDataType* _tmp1922_;
			ValaTypeParameter* _tmp1923_;
			ValaTypeParameter* _tmp1924_;
			ValaTypeParameter* _tmp1925_;
			ValaStruct* st = NULL;
			ValaTypeParameter* _tmp1926_;
			ValaSymbol* _tmp1927_;
			ValaSymbol* _tmp1928_;
			ValaSymbol* _tmp1929_;
			ValaSymbol* _tmp1930_;
			ValaStruct* _tmp1931_;
			gboolean _tmp1932_ = FALSE;
			ValaTypeParameter* _tmp1933_;
			ValaSymbol* _tmp1934_;
			ValaSymbol* _tmp1935_;
			ValaTypeSymbol* _tmp1936_;
			_tmp1921_ = vala_expression_get_formal_value_type ((ValaExpression*) expr);
			_tmp1922_ = _tmp1921_;
			_tmp1923_ = vala_generic_type_get_type_parameter (G_TYPE_CHECK_INSTANCE_CAST (_tmp1922_, VALA_TYPE_GENERIC_TYPE, ValaGenericType));
			_tmp1924_ = _tmp1923_;
			_tmp1925_ = _vala_code_node_ref0 (_tmp1924_);
			type_parameter = _tmp1925_;
			_tmp1926_ = type_parameter;
			_tmp1927_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1926_);
			_tmp1928_ = _tmp1927_;
			_tmp1929_ = vala_symbol_get_parent_symbol (_tmp1928_);
			_tmp1930_ = _tmp1929_;
			_tmp1931_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1930_, VALA_TYPE_STRUCT) ? ((ValaStruct*) _tmp1930_) : NULL);
			st = _tmp1931_;
			_tmp1933_ = type_parameter;
			_tmp1934_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp1933_);
			_tmp1935_ = _tmp1934_;
			_tmp1936_ = ((ValaCCodeBaseModule*) self)->garray_type;
			if (_tmp1935_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp1936_, VALA_TYPE_SYMBOL, ValaSymbol)) {
				_tmp1932_ = TRUE;
			} else {
				gboolean _tmp1937_ = FALSE;
				ValaStruct* _tmp1938_;
				_tmp1938_ = st;
				if (_tmp1938_ != NULL) {
					ValaStruct* _tmp1939_;
					gchar* _tmp1940_;
					gchar* _tmp1941_;
					_tmp1939_ = st;
					_tmp1940_ = vala_get_ccode_name ((ValaCodeNode*) _tmp1939_);
					_tmp1941_ = _tmp1940_;
					_tmp1937_ = g_strcmp0 (_tmp1941_, "va_list") == 0;
					_g_free0 (_tmp1941_);
				} else {
					_tmp1937_ = FALSE;
				}
				_tmp1932_ = _tmp1937_;
			}
			if (_tmp1932_) {
				ValaDataType* _tmp1942_;
				ValaDataType* _tmp1943_;
				ValaDataType* _tmp1944_;
				_tmp1942_ = vala_expression_get_value_type ((ValaExpression*) expr);
				_tmp1943_ = _tmp1942_;
				_tmp1944_ = _vala_code_node_ref0 (_tmp1943_);
				_vala_code_node_unref0 (result_type);
				result_type = _tmp1944_;
			}
			_vala_code_node_unref0 (st);
			_vala_code_node_unref0 (type_parameter);
		}
		_tmp1946_ = m;
		if (_tmp1946_ != NULL) {
			ValaMethod* _tmp1947_;
			_tmp1947_ = m;
			_tmp1945_ = vala_method_get_format_arg_index (_tmp1947_) >= 0;
		} else {
			_tmp1945_ = FALSE;
		}
		if (_tmp1945_) {
			ValaCCodeExpression* _tmp1948_;
			_tmp1948_ = ccall_expr;
			vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1948_);
		} else {
			gboolean _tmp1949_ = FALSE;
			ValaMethod* _tmp1950_;
			_tmp1950_ = m;
			if (_tmp1950_ != NULL) {
				ValaMethod* _tmp1951_;
				_tmp1951_ = m;
				_tmp1949_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) _tmp1951_, "CCode", "use_inplace", FALSE);
			} else {
				_tmp1949_ = FALSE;
			}
			if (_tmp1949_) {
				ValaCCodeExpression* _tmp1952_;
				_tmp1952_ = ccall_expr;
				vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1952_);
			} else {
				gboolean _tmp1953_ = FALSE;
				gboolean _tmp1954_ = FALSE;
				gboolean _tmp1955_;
				_tmp1955_ = return_result_via_out_param;
				if (!_tmp1955_) {
					gboolean _tmp1956_ = FALSE;
					gboolean _tmp1957_ = FALSE;
					ValaMethod* _tmp1958_;
					_tmp1958_ = m;
					if (_tmp1958_ != NULL) {
						ValaMethod* _tmp1959_;
						_tmp1959_ = m;
						_tmp1957_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1959_);
					} else {
						_tmp1957_ = FALSE;
					}
					if (_tmp1957_) {
						_tmp1956_ = TRUE;
					} else {
						gboolean _tmp1960_ = FALSE;
						ValaDelegate* _tmp1961_;
						_tmp1961_ = deleg;
						if (_tmp1961_ != NULL) {
							ValaDelegate* _tmp1962_;
							_tmp1962_ = deleg;
							_tmp1960_ = !vala_ccode_method_call_module_has_ref_out_param (self, (ValaCallable*) _tmp1962_);
						} else {
							_tmp1960_ = FALSE;
						}
						_tmp1956_ = _tmp1960_;
					}
					_tmp1954_ = _tmp1956_;
				} else {
					_tmp1954_ = FALSE;
				}
				if (_tmp1954_) {
					gboolean _tmp1963_ = FALSE;
					ValaDataType* _tmp1964_;
					_tmp1964_ = result_type;
					if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1964_, VALA_TYPE_VALUE_TYPE)) {
						ValaDataType* _tmp1965_;
						_tmp1965_ = result_type;
						_tmp1963_ = !vala_data_type_is_disposable (_tmp1965_);
					} else {
						_tmp1963_ = FALSE;
					}
					_tmp1953_ = _tmp1963_;
				} else {
					_tmp1953_ = FALSE;
				}
				if (_tmp1953_) {
					ValaCCodeExpression* _tmp1966_;
					_tmp1966_ = ccall_expr;
					vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1966_);
				} else {
					gboolean _tmp1967_;
					_tmp1967_ = return_result_via_out_param;
					if (!_tmp1967_) {
						ValaLocalVariable* temp_var = NULL;
						ValaDataType* _tmp1968_;
						ValaDataType* _tmp1969_;
						gboolean _tmp1970_;
						gboolean _tmp1971_;
						ValaLocalVariable* _tmp1972_;
						ValaCCodeExpression* temp_ref = NULL;
						ValaLocalVariable* _tmp1973_;
						const gchar* _tmp1974_;
						const gchar* _tmp1975_;
						ValaCCodeExpression* _tmp1976_;
						ValaLocalVariable* _tmp1977_;
						ValaCCodeFunction* _tmp1978_;
						ValaCCodeFunction* _tmp1979_;
						ValaCCodeExpression* _tmp1980_;
						ValaCCodeExpression* _tmp1981_;
						ValaCCodeExpression* _tmp1982_;
						ValaTargetValue* _tmp1983_;
						ValaTargetValue* _tmp1984_;
						_tmp1968_ = result_type;
						_tmp1969_ = result_type;
						_tmp1970_ = vala_data_type_get_value_owned (_tmp1969_);
						_tmp1971_ = _tmp1970_;
						_tmp1972_ = vala_ccode_base_module_get_temp_variable ((ValaCCodeBaseModule*) self, _tmp1968_, _tmp1971_, NULL, FALSE);
						temp_var = _tmp1972_;
						_tmp1973_ = temp_var;
						_tmp1974_ = vala_symbol_get_name ((ValaSymbol*) _tmp1973_);
						_tmp1975_ = _tmp1974_;
						_tmp1976_ = vala_ccode_base_module_get_variable_cexpression ((ValaCCodeBaseModule*) self, _tmp1975_);
						temp_ref = _tmp1976_;
						_tmp1977_ = temp_var;
						vala_ccode_base_module_emit_temp_var ((ValaCCodeBaseModule*) self, _tmp1977_, FALSE);
						_tmp1978_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
						_tmp1979_ = _tmp1978_;
						_tmp1980_ = temp_ref;
						_tmp1981_ = ccall_expr;
						vala_ccode_function_add_assignment (_tmp1979_, _tmp1980_, _tmp1981_);
						_tmp1982_ = temp_ref;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1982_);
						_tmp1983_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1984_ = _tmp1983_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1984_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
						_vala_ccode_node_unref0 (temp_ref);
						_vala_code_node_unref0 (temp_var);
					} else {
						ValaCCodeExpression* _tmp1985_;
						ValaTargetValue* _tmp1986_;
						ValaTargetValue* _tmp1987_;
						_tmp1985_ = ccall_expr;
						vala_ccode_base_module_set_cvalue ((ValaCCodeBaseModule*) self, (ValaExpression*) expr, _tmp1985_);
						_tmp1986_ = vala_expression_get_target_value ((ValaExpression*) expr);
						_tmp1987_ = _tmp1986_;
						G_TYPE_CHECK_INSTANCE_CAST (_tmp1987_, VALA_TYPE_GLIB_VALUE, ValaGLibValue)->lvalue = TRUE;
					}
				}
			}
		}
		_vala_code_node_unref0 (result_type);
	}
	_tmp1988_ = params;
	_tmp1989_ = vala_iterable_iterator ((ValaIterable*) _tmp1988_);
	_vala_iterator_unref0 (params_it);
	params_it = _tmp1989_;
	{
		ValaList* _arg_list = NULL;
		ValaList* _tmp1990_;
		gint _arg_size = 0;
		ValaList* _tmp1991_;
		gint _tmp1992_;
		gint _tmp1993_;
		gint _arg_index = 0;
		_tmp1990_ = vala_method_call_get_argument_list (expr);
		_arg_list = _tmp1990_;
		_tmp1991_ = _arg_list;
		_tmp1992_ = vala_collection_get_size ((ValaCollection*) _tmp1991_);
		_tmp1993_ = _tmp1992_;
		_arg_size = _tmp1993_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp1994_;
			gint _tmp1995_;
			gint _tmp1996_;
			ValaExpression* arg = NULL;
			ValaList* _tmp1997_;
			gint _tmp1998_;
			gpointer _tmp1999_;
			ValaParameter* param = NULL;
			ValaIterator* _tmp2000_;
			ValaUnaryExpression* unary = NULL;
			ValaExpression* _tmp2010_;
			ValaUnaryExpression* _tmp2011_;
			gboolean _tmp2012_ = FALSE;
			ValaUnaryExpression* _tmp2013_;
			ValaUnaryExpression* _tmp2017_;
			ValaExpression* _tmp2018_;
			ValaExpression* _tmp2019_;
			ValaDataType* _tmp2020_;
			ValaDataType* _tmp2021_;
			ValaUnaryExpression* _tmp2031_;
			ValaExpression* _tmp2032_;
			ValaExpression* _tmp2033_;
			ValaTargetValue* _tmp2034_;
			ValaTargetValue* _tmp2035_;
			ValaUnaryExpression* _tmp2036_;
			ValaTargetValue* _tmp2037_;
			ValaTargetValue* _tmp2038_;
			ValaUnaryExpression* _tmp2039_;
			ValaExpression* _tmp2040_;
			ValaExpression* _tmp2041_;
			ValaDataType* _tmp2042_;
			ValaDataType* _tmp2043_;
			ValaExpression* _tmp2044_;
			ValaTargetValue* _tmp2045_;
			ValaTargetValue* _tmp2046_;
			ValaSourceReference* _tmp2047_;
			ValaSourceReference* _tmp2048_;
			gboolean _tmp2049_ = FALSE;
			ValaParameter* _tmp2050_;
			_tmp1994_ = _arg_index;
			_arg_index = _tmp1994_ + 1;
			_tmp1995_ = _arg_index;
			_tmp1996_ = _arg_size;
			if (!(_tmp1995_ < _tmp1996_)) {
				break;
			}
			_tmp1997_ = _arg_list;
			_tmp1998_ = _arg_index;
			_tmp1999_ = vala_list_get (_tmp1997_, _tmp1998_);
			arg = (ValaExpression*) _tmp1999_;
			param = NULL;
			_tmp2000_ = params_it;
			if (vala_iterator_next (_tmp2000_)) {
				ValaIterator* _tmp2001_;
				gpointer _tmp2002_;
				gboolean _tmp2003_ = FALSE;
				ValaParameter* _tmp2004_;
				gboolean _tmp2005_;
				gboolean _tmp2006_;
				_tmp2001_ = params_it;
				_tmp2002_ = vala_iterator_get (_tmp2001_);
				_vala_code_node_unref0 (param);
				param = (ValaParameter*) _tmp2002_;
				_tmp2004_ = param;
				_tmp2005_ = vala_parameter_get_params_array (_tmp2004_);
				_tmp2006_ = _tmp2005_;
				if (_tmp2006_) {
					_tmp2003_ = TRUE;
				} else {
					ValaParameter* _tmp2007_;
					gboolean _tmp2008_;
					gboolean _tmp2009_;
					_tmp2007_ = param;
					_tmp2008_ = vala_parameter_get_ellipsis (_tmp2007_);
					_tmp2009_ = _tmp2008_;
					_tmp2003_ = _tmp2009_;
				}
				if (_tmp2003_) {
					_vala_code_node_unref0 (param);
					_vala_code_node_unref0 (arg);
					break;
				}
			}
			_tmp2010_ = arg;
			_tmp2011_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2010_, VALA_TYPE_UNARY_EXPRESSION) ? ((ValaUnaryExpression*) _tmp2010_) : NULL);
			unary = _tmp2011_;
			_tmp2013_ = unary;
			if (_tmp2013_ == NULL) {
				_tmp2012_ = TRUE;
			} else {
				ValaUnaryExpression* _tmp2014_;
				ValaUnaryOperator _tmp2015_;
				ValaUnaryOperator _tmp2016_;
				_tmp2014_ = unary;
				_tmp2015_ = vala_unary_expression_get_operator (_tmp2014_);
				_tmp2016_ = _tmp2015_;
				_tmp2012_ = _tmp2016_ != VALA_UNARY_OPERATOR_OUT;
			}
			if (_tmp2012_) {
				_vala_code_node_unref0 (unary);
				_vala_code_node_unref0 (param);
				_vala_code_node_unref0 (arg);
				continue;
			}
			_tmp2017_ = unary;
			_tmp2018_ = vala_unary_expression_get_inner (_tmp2017_);
			_tmp2019_ = _tmp2018_;
			_tmp2020_ = vala_expression_get_value_type (_tmp2019_);
			_tmp2021_ = _tmp2020_;
			if (vala_ccode_base_module_requires_destroy ((ValaCCodeBaseModule*) self, _tmp2021_)) {
				ValaCCodeFunction* _tmp2022_;
				ValaCCodeFunction* _tmp2023_;
				ValaUnaryExpression* _tmp2024_;
				ValaExpression* _tmp2025_;
				ValaExpression* _tmp2026_;
				ValaTargetValue* _tmp2027_;
				ValaTargetValue* _tmp2028_;
				ValaCCodeExpression* _tmp2029_;
				ValaCCodeExpression* _tmp2030_;
				_tmp2022_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2023_ = _tmp2022_;
				_tmp2024_ = unary;
				_tmp2025_ = vala_unary_expression_get_inner (_tmp2024_);
				_tmp2026_ = _tmp2025_;
				_tmp2027_ = vala_expression_get_target_value (_tmp2026_);
				_tmp2028_ = _tmp2027_;
				_tmp2029_ = vala_ccode_base_module_destroy_value ((ValaCCodeBaseModule*) self, _tmp2028_, FALSE);
				_tmp2030_ = _tmp2029_;
				vala_ccode_function_add_expression (_tmp2023_, _tmp2030_);
				_vala_ccode_node_unref0 (_tmp2030_);
			}
			_tmp2031_ = unary;
			_tmp2032_ = vala_unary_expression_get_inner (_tmp2031_);
			_tmp2033_ = _tmp2032_;
			_tmp2034_ = vala_expression_get_target_value (_tmp2033_);
			_tmp2035_ = _tmp2034_;
			_tmp2036_ = unary;
			_tmp2037_ = vala_expression_get_target_value ((ValaExpression*) _tmp2036_);
			_tmp2038_ = _tmp2037_;
			_tmp2039_ = unary;
			_tmp2040_ = vala_unary_expression_get_inner (_tmp2039_);
			_tmp2041_ = _tmp2040_;
			_tmp2042_ = vala_expression_get_value_type (_tmp2041_);
			_tmp2043_ = _tmp2042_;
			_tmp2044_ = arg;
			_tmp2045_ = vala_ccode_base_module_transform_value ((ValaCCodeBaseModule*) self, _tmp2038_, _tmp2043_, (ValaCodeNode*) _tmp2044_);
			_tmp2046_ = _tmp2045_;
			_tmp2047_ = vala_code_node_get_source_reference ((ValaCodeNode*) expr);
			_tmp2048_ = _tmp2047_;
			vala_ccode_base_module_store_value ((ValaCCodeBaseModule*) self, _tmp2035_, _tmp2046_, _tmp2048_);
			_vala_target_value_unref0 (_tmp2046_);
			_tmp2050_ = param;
			if (_tmp2050_ != NULL) {
				ValaParameter* _tmp2051_;
				_tmp2051_ = param;
				_tmp2049_ = vala_get_ccode_array_null_terminated ((ValaCodeNode*) _tmp2051_);
			} else {
				_tmp2049_ = FALSE;
			}
			if (_tmp2049_) {
				ValaCCodeFunctionCall* len_call = NULL;
				ValaCCodeIdentifier* _tmp2052_;
				ValaCCodeIdentifier* _tmp2053_;
				ValaCCodeFunctionCall* _tmp2054_;
				ValaCCodeFunctionCall* _tmp2055_;
				ValaCCodeFunctionCall* _tmp2056_;
				ValaUnaryExpression* _tmp2057_;
				ValaExpression* _tmp2058_;
				ValaExpression* _tmp2059_;
				ValaTargetValue* _tmp2060_;
				ValaTargetValue* _tmp2061_;
				ValaCCodeExpression* _tmp2062_;
				ValaCCodeExpression* _tmp2063_;
				ValaCCodeFunction* _tmp2064_;
				ValaCCodeFunction* _tmp2065_;
				ValaUnaryExpression* _tmp2066_;
				ValaExpression* _tmp2067_;
				ValaExpression* _tmp2068_;
				ValaTargetValue* _tmp2069_;
				ValaTargetValue* _tmp2070_;
				ValaCCodeExpression* _tmp2071_;
				ValaCCodeExpression* _tmp2072_;
				ValaCCodeFunctionCall* _tmp2073_;
				((ValaCCodeBaseModule*) self)->requires_array_length = TRUE;
				_tmp2052_ = vala_ccode_identifier_new ("_vala_array_length");
				_tmp2053_ = _tmp2052_;
				_tmp2054_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2053_);
				_tmp2055_ = _tmp2054_;
				_vala_ccode_node_unref0 (_tmp2053_);
				len_call = _tmp2055_;
				_tmp2056_ = len_call;
				_tmp2057_ = unary;
				_tmp2058_ = vala_unary_expression_get_inner (_tmp2057_);
				_tmp2059_ = _tmp2058_;
				_tmp2060_ = vala_expression_get_target_value (_tmp2059_);
				_tmp2061_ = _tmp2060_;
				_tmp2062_ = vala_ccode_base_module_get_cvalue_ ((ValaCCodeBaseModule*) self, _tmp2061_);
				_tmp2063_ = _tmp2062_;
				vala_ccode_function_call_add_argument (_tmp2056_, _tmp2063_);
				_vala_ccode_node_unref0 (_tmp2063_);
				_tmp2064_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
				_tmp2065_ = _tmp2064_;
				_tmp2066_ = unary;
				_tmp2067_ = vala_unary_expression_get_inner (_tmp2066_);
				_tmp2068_ = _tmp2067_;
				_tmp2069_ = vala_expression_get_target_value (_tmp2068_);
				_tmp2070_ = _tmp2069_;
				_tmp2071_ = vala_ccode_base_module_get_array_length_cvalue ((ValaCCodeBaseModule*) self, _tmp2070_, 1);
				_tmp2072_ = _tmp2071_;
				_tmp2073_ = len_call;
				vala_ccode_function_add_assignment (_tmp2065_, _tmp2072_, (ValaCCodeExpression*) _tmp2073_);
				_vala_ccode_node_unref0 (_tmp2072_);
				_vala_ccode_node_unref0 (len_call);
			}
			_vala_code_node_unref0 (unary);
			_vala_code_node_unref0 (param);
			_vala_code_node_unref0 (arg);
		}
		_vala_iterable_unref0 (_arg_list);
	}
	_tmp2076_ = m;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2076_, VALA_TYPE_CREATION_METHOD)) {
		ValaMethod* _tmp2077_;
		ValaSymbol* _tmp2078_;
		ValaSymbol* _tmp2079_;
		_tmp2077_ = m;
		_tmp2078_ = vala_symbol_get_parent_symbol ((ValaSymbol*) _tmp2077_);
		_tmp2079_ = _tmp2078_;
		_tmp2075_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp2079_, VALA_TYPE_CLASS);
	} else {
		_tmp2075_ = FALSE;
	}
	if (_tmp2075_) {
		gboolean _tmp2080_ = FALSE;
		gboolean _tmp2081_ = FALSE;
		ValaClass* _tmp2082_;
		ValaClass* _tmp2083_;
		gboolean _tmp2084_;
		gboolean _tmp2085_;
		_tmp2082_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2083_ = _tmp2082_;
		_tmp2084_ = vala_class_get_is_compact (_tmp2083_);
		_tmp2085_ = _tmp2084_;
		if (_tmp2085_) {
			ValaClass* _tmp2086_;
			ValaClass* _tmp2087_;
			ValaClass* _tmp2088_;
			ValaClass* _tmp2089_;
			_tmp2086_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2087_ = _tmp2086_;
			_tmp2088_ = vala_class_get_base_class (_tmp2087_);
			_tmp2089_ = _tmp2088_;
			_tmp2081_ = _tmp2089_ != NULL;
		} else {
			_tmp2081_ = FALSE;
		}
		if (_tmp2081_) {
			_tmp2080_ = TRUE;
		} else {
			ValaClass* _tmp2090_;
			ValaClass* _tmp2091_;
			ValaClass* _tmp2092_;
			ValaClass* _tmp2093_;
			ValaClass* _tmp2094_;
			_tmp2090_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
			_tmp2091_ = _tmp2090_;
			_tmp2092_ = vala_class_get_base_class (_tmp2091_);
			_tmp2093_ = _tmp2092_;
			_tmp2094_ = ((ValaCCodeBaseModule*) self)->gsource_type;
			_tmp2080_ = _tmp2093_ == _tmp2094_;
		}
		_tmp2074_ = _tmp2080_;
	} else {
		_tmp2074_ = FALSE;
	}
	if (_tmp2074_) {
		ValaCCodeFunctionCall* cinitcall = NULL;
		ValaClass* _tmp2095_;
		ValaClass* _tmp2096_;
		gchar* _tmp2097_;
		gchar* _tmp2098_;
		gchar* _tmp2099_;
		gchar* _tmp2100_;
		ValaCCodeIdentifier* _tmp2101_;
		ValaCCodeIdentifier* _tmp2102_;
		ValaCCodeFunctionCall* _tmp2103_;
		ValaCCodeFunctionCall* _tmp2104_;
		ValaCCodeFunctionCall* _tmp2105_;
		ValaCCodeExpression* _tmp2106_;
		ValaCCodeExpression* _tmp2107_;
		ValaCCodeFunction* _tmp2108_;
		ValaCCodeFunction* _tmp2109_;
		ValaCCodeFunctionCall* _tmp2110_;
		_tmp2095_ = vala_ccode_base_module_get_current_class ((ValaCCodeBaseModule*) self);
		_tmp2096_ = _tmp2095_;
		_tmp2097_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) _tmp2096_, NULL);
		_tmp2098_ = _tmp2097_;
		_tmp2099_ = g_strdup_printf ("%s_instance_init", _tmp2098_);
		_tmp2100_ = _tmp2099_;
		_tmp2101_ = vala_ccode_identifier_new (_tmp2100_);
		_tmp2102_ = _tmp2101_;
		_tmp2103_ = vala_ccode_function_call_new ((ValaCCodeExpression*) _tmp2102_);
		_tmp2104_ = _tmp2103_;
		_vala_ccode_node_unref0 (_tmp2102_);
		_g_free0 (_tmp2100_);
		_g_free0 (_tmp2098_);
		cinitcall = _tmp2104_;
		_tmp2105_ = cinitcall;
		_tmp2106_ = vala_ccode_base_module_get_this_cexpression ((ValaCCodeBaseModule*) self);
		_tmp2107_ = _tmp2106_;
		vala_ccode_function_call_add_argument (_tmp2105_, _tmp2107_);
		_vala_ccode_node_unref0 (_tmp2107_);
		_tmp2108_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
		_tmp2109_ = _tmp2108_;
		_tmp2110_ = cinitcall;
		vala_ccode_function_add_expression (_tmp2109_, (ValaCCodeExpression*) _tmp2110_);
		_vala_ccode_node_unref0 (cinitcall);
	}
	_vala_ccode_node_unref0 (out_param_ref);
	_vala_iterator_unref0 (params_it);
	_vala_ccode_node_unref0 (instance);
	_vala_ccode_node_unref0 (ccall_expr);
	_vala_map_unref0 (out_arg_map);
	_vala_map_unref0 (in_arg_map);
	_vala_code_node_unref0 (itype);
	_vala_code_node_unref0 (ma);
	_vala_iterable_unref0 (params);
	_vala_code_node_unref0 (deleg);
	_vala_code_node_unref0 (m);
	_vala_ccode_node_unref0 (finish_call);
	_vala_ccode_node_unref0 (async_call);
	_vala_ccode_node_unref0 (ccall);
}


static gchar*
vala_ccode_method_call_module_generate_enum_tostring_function (ValaCCodeMethodCallModule* self,
                                                               ValaEnum* en)
{
	gchar* result = NULL;
	gchar* to_string_func = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	ValaCCodeFunction* function = NULL;
	const gchar* _tmp5_;
	ValaCCodeFunction* _tmp6_;
	ValaCCodeFunction* _tmp7_;
	ValaCCodeFunction* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	ValaCCodeParameter* _tmp11_;
	ValaCCodeParameter* _tmp12_;
	ValaCCodeBaseModuleEmitContext* _tmp13_;
	ValaCCodeBaseModuleEmitContext* _tmp14_;
	ValaCCodeFunction* _tmp15_;
	ValaCCodeFunction* _tmp16_;
	ValaCCodeFunction* _tmp17_;
	ValaCCodeConstant* _tmp18_;
	ValaCCodeConstant* _tmp19_;
	ValaCCodeFunction* _tmp48_;
	ValaCCodeFunction* _tmp49_;
	ValaCCodeFunction* _tmp50_;
	ValaCCodeFunction* _tmp51_;
	ValaCCodeConstant* _tmp52_;
	ValaCCodeConstant* _tmp53_;
	ValaCCodeFile* _tmp54_;
	ValaCCodeFunction* _tmp55_;
	ValaCCodeFile* _tmp56_;
	ValaCCodeFunction* _tmp57_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (en != NULL, NULL);
	_tmp0_ = vala_get_ccode_lower_case_name ((ValaCodeNode*) en, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("_%s_to_string", _tmp1_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	to_string_func = _tmp3_;
	_tmp4_ = to_string_func;
	if (!vala_ccode_base_module_add_wrapper ((ValaCCodeBaseModule*) self, _tmp4_)) {
		result = to_string_func;
		return result;
	}
	_tmp5_ = to_string_func;
	_tmp6_ = vala_ccode_function_new (_tmp5_, "const char*");
	function = _tmp6_;
	_tmp7_ = function;
	vala_ccode_node_set_modifiers ((ValaCCodeNode*) _tmp7_, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8_ = function;
	_tmp9_ = vala_get_ccode_name ((ValaCodeNode*) en);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_ccode_parameter_new ("value", _tmp10_);
	_tmp12_ = _tmp11_;
	vala_ccode_function_add_parameter (_tmp8_, _tmp12_);
	_vala_ccode_node_unref0 (_tmp12_);
	_g_free0 (_tmp10_);
	_tmp13_ = vala_ccode_base_module_emit_context_new (NULL);
	_tmp14_ = _tmp13_;
	vala_ccode_base_module_push_context ((ValaCCodeBaseModule*) self, _tmp14_);
	_vala_ccode_base_module_emit_context_unref0 (_tmp14_);
	_tmp15_ = function;
	vala_ccode_base_module_push_function ((ValaCCodeBaseModule*) self, _tmp15_);
	_tmp16_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = vala_ccode_constant_new ("value");
	_tmp19_ = _tmp18_;
	vala_ccode_function_open_switch (_tmp17_, (ValaCCodeExpression*) _tmp19_);
	_vala_ccode_node_unref0 (_tmp19_);
	{
		ValaList* _enum_value_list = NULL;
		ValaList* _tmp20_;
		gint _enum_value_size = 0;
		ValaList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _enum_value_index = 0;
		_tmp20_ = vala_enum_get_values (en);
		_enum_value_list = _tmp20_;
		_tmp21_ = _enum_value_list;
		_tmp22_ = vala_collection_get_size ((ValaCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_enum_value_size = _tmp23_;
		_enum_value_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			gint _tmp26_;
			ValaEnumValue* enum_value = NULL;
			ValaList* _tmp27_;
			gint _tmp28_;
			gpointer _tmp29_;
			ValaCCodeFunction* _tmp30_;
			ValaCCodeFunction* _tmp31_;
			ValaEnumValue* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			ValaCCodeIdentifier* _tmp35_;
			ValaCCodeIdentifier* _tmp36_;
			ValaCCodeFunction* _tmp37_;
			ValaCCodeFunction* _tmp38_;
			ValaEnumValue* _tmp39_;
			gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			ValaCCodeConstant* _tmp46_;
			ValaCCodeConstant* _tmp47_;
			_tmp24_ = _enum_value_index;
			_enum_value_index = _tmp24_ + 1;
			_tmp25_ = _enum_value_index;
			_tmp26_ = _enum_value_size;
			if (!(_tmp25_ < _tmp26_)) {
				break;
			}
			_tmp27_ = _enum_value_list;
			_tmp28_ = _enum_value_index;
			_tmp29_ = vala_list_get (_tmp27_, _tmp28_);
			enum_value = (ValaEnumValue*) _tmp29_;
			_tmp30_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp31_ = _tmp30_;
			_tmp32_ = enum_value;
			_tmp33_ = vala_get_ccode_name ((ValaCodeNode*) _tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = vala_ccode_identifier_new (_tmp34_);
			_tmp36_ = _tmp35_;
			vala_ccode_function_add_case (_tmp31_, (ValaCCodeExpression*) _tmp36_);
			_vala_ccode_node_unref0 (_tmp36_);
			_g_free0 (_tmp34_);
			_tmp37_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
			_tmp38_ = _tmp37_;
			_tmp39_ = enum_value;
			_tmp40_ = vala_get_ccode_name ((ValaCodeNode*) _tmp39_);
			_tmp41_ = _tmp40_;
			_tmp42_ = g_strconcat ("\"", _tmp41_, NULL);
			_tmp43_ = _tmp42_;
			_tmp44_ = g_strconcat (_tmp43_, "\"", NULL);
			_tmp45_ = _tmp44_;
			_tmp46_ = vala_ccode_constant_new (_tmp45_);
			_tmp47_ = _tmp46_;
			vala_ccode_function_add_return (_tmp38_, (ValaCCodeExpression*) _tmp47_);
			_vala_ccode_node_unref0 (_tmp47_);
			_g_free0 (_tmp45_);
			_g_free0 (_tmp43_);
			_g_free0 (_tmp41_);
			_vala_code_node_unref0 (enum_value);
		}
		_vala_iterable_unref0 (_enum_value_list);
	}
	_tmp48_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp49_ = _tmp48_;
	vala_ccode_function_close (_tmp49_);
	_tmp50_ = vala_ccode_base_module_get_ccode ((ValaCCodeBaseModule*) self);
	_tmp51_ = _tmp50_;
	_tmp52_ = vala_ccode_constant_new ("NULL");
	_tmp53_ = _tmp52_;
	vala_ccode_function_add_return (_tmp51_, (ValaCCodeExpression*) _tmp53_);
	_vala_ccode_node_unref0 (_tmp53_);
	_tmp54_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp55_ = function;
	vala_ccode_file_add_function_declaration (_tmp54_, _tmp55_);
	_tmp56_ = ((ValaCCodeBaseModule*) self)->cfile;
	_tmp57_ = function;
	vala_ccode_file_add_function (_tmp56_, _tmp57_);
	vala_ccode_base_module_pop_context ((ValaCCodeBaseModule*) self);
	result = to_string_func;
	_vala_ccode_node_unref0 (function);
	return result;
}


static gboolean
vala_ccode_method_call_module_has_ref_out_param (ValaCCodeMethodCallModule* self,
                                                 ValaCallable* c)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (c != NULL, FALSE);
	{
		ValaList* _param_list = NULL;
		ValaList* _tmp0_;
		gint _param_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _param_index = 0;
		_tmp0_ = vala_callable_get_parameters (c);
		_param_list = _tmp0_;
		_tmp1_ = _param_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_param_size = _tmp3_;
		_param_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaParameter* param = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaParameter* _tmp10_;
			ValaParameterDirection _tmp11_;
			ValaParameterDirection _tmp12_;
			_tmp4_ = _param_index;
			_param_index = _tmp4_ + 1;
			_tmp5_ = _param_index;
			_tmp6_ = _param_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _param_list;
			_tmp8_ = _param_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			param = (ValaParameter*) _tmp9_;
			_tmp10_ = param;
			_tmp11_ = vala_parameter_get_direction (_tmp10_);
			_tmp12_ = _tmp11_;
			if (_tmp12_ != VALA_PARAMETER_DIRECTION_IN) {
				result = TRUE;
				_vala_code_node_unref0 (param);
				_vala_iterable_unref0 (_param_list);
				return result;
			}
			_vala_code_node_unref0 (param);
		}
		_vala_iterable_unref0 (_param_list);
	}
	result = FALSE;
	return result;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_construct (GType object_type)
{
	ValaCCodeMethodCallModule* self = NULL;
	self = (ValaCCodeMethodCallModule*) vala_ccode_assignment_module_construct (object_type);
	return self;
}


ValaCCodeMethodCallModule*
vala_ccode_method_call_module_new (void)
{
	return vala_ccode_method_call_module_construct (VALA_TYPE_CCODE_METHOD_CALL_MODULE);
}


static void
vala_ccode_method_call_module_class_init (ValaCCodeMethodCallModuleClass * klass)
{
	vala_ccode_method_call_module_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeVisitorClass *) klass)->visit_method_call = (void (*) (ValaCodeVisitor*, ValaMethodCall*)) vala_ccode_method_call_module_real_visit_method_call;
}


static void
vala_ccode_method_call_module_instance_init (ValaCCodeMethodCallModule * self)
{
}


GType
vala_ccode_method_call_module_get_type (void)
{
	static volatile gsize vala_ccode_method_call_module_type_id__volatile = 0;
	if (g_once_init_enter (&vala_ccode_method_call_module_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeMethodCallModuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_method_call_module_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeMethodCallModule), 0, (GInstanceInitFunc) vala_ccode_method_call_module_instance_init, NULL };
		GType vala_ccode_method_call_module_type_id;
		vala_ccode_method_call_module_type_id = g_type_register_static (VALA_TYPE_CCODE_ASSIGNMENT_MODULE, "ValaCCodeMethodCallModule", &g_define_type_info, 0);
		g_once_init_leave (&vala_ccode_method_call_module_type_id__volatile, vala_ccode_method_call_module_type_id);
	}
	return vala_ccode_method_call_module_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



