/* valaconditionalexpression.c generated by valac, the Vala compiler
 * generated from valaconditionalexpression.vala, do not modify */

/* valaconditionalexpression.vala
 *
 * Copyright (C) 2006-2011  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */


#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _ValaConditionalExpressionPrivate {
	ValaExpression* _condition;
	ValaExpression* _true_expression;
	ValaExpression* _false_expression;
};


static gpointer vala_conditional_expression_parent_class = NULL;

#define VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpressionPrivate))
static void vala_conditional_expression_real_accept (ValaCodeNode* base,
                                              ValaCodeVisitor* visitor);
static void vala_conditional_expression_real_accept_children (ValaCodeNode* base,
                                                       ValaCodeVisitor* visitor);
static gboolean vala_conditional_expression_real_is_pure (ValaExpression* base);
static gboolean vala_conditional_expression_real_is_accessible (ValaExpression* base,
                                                         ValaSymbol* sym);
static gchar* vala_conditional_expression_real_to_string (ValaCodeNode* base);
static void vala_conditional_expression_real_replace_expression (ValaCodeNode* base,
                                                          ValaExpression* old_node,
                                                          ValaExpression* new_node);
static void vala_conditional_expression_real_get_defined_variables (ValaCodeNode* base,
                                                             ValaCollection* collection);
static void vala_conditional_expression_real_get_used_variables (ValaCodeNode* base,
                                                          ValaCollection* collection);
static gboolean vala_conditional_expression_real_check (ValaCodeNode* base,
                                                 ValaCodeContext* context);
static void vala_conditional_expression_finalize (ValaCodeNode * obj);


/**
 * Creates a new conditional expression.
 *
 * @param cond       a condition
 * @param true_expr  expression to be evaluated if condition is true
 * @param false_expr expression to be evaluated if condition is false
 * @return           newly created conditional expression
 */
ValaConditionalExpression*
vala_conditional_expression_construct (GType object_type,
                                       ValaExpression* cond,
                                       ValaExpression* true_expr,
                                       ValaExpression* false_expr,
                                       ValaSourceReference* source)
{
	ValaConditionalExpression* self = NULL;
	g_return_val_if_fail (cond != NULL, NULL);
	g_return_val_if_fail (true_expr != NULL, NULL);
	g_return_val_if_fail (false_expr != NULL, NULL);
	g_return_val_if_fail (source != NULL, NULL);
	self = (ValaConditionalExpression*) vala_expression_construct (object_type);
	vala_conditional_expression_set_condition (self, cond);
	vala_conditional_expression_set_true_expression (self, true_expr);
	vala_conditional_expression_set_false_expression (self, false_expr);
	vala_code_node_set_source_reference ((ValaCodeNode*) self, source);
	return self;
}


ValaConditionalExpression*
vala_conditional_expression_new (ValaExpression* cond,
                                 ValaExpression* true_expr,
                                 ValaExpression* false_expr,
                                 ValaSourceReference* source)
{
	return vala_conditional_expression_construct (VALA_TYPE_CONDITIONAL_EXPRESSION, cond, true_expr, false_expr, source);
}


static void
vala_conditional_expression_real_accept (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor)
{
	ValaConditionalExpression * self;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_conditional_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, (ValaExpression*) self);
}


static void
vala_conditional_expression_real_accept_children (ValaCodeNode* base,
                                                  ValaCodeVisitor* visitor)
{
	ValaConditionalExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_conditional_expression_get_condition (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_conditional_expression_get_true_expression (self);
	_tmp3_ = _tmp2_;
	vala_code_node_accept ((ValaCodeNode*) _tmp3_, visitor);
	_tmp4_ = vala_conditional_expression_get_false_expression (self);
	_tmp5_ = _tmp4_;
	vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
}


static gboolean
vala_conditional_expression_real_is_pure (ValaExpression* base)
{
	ValaConditionalExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaConditionalExpression*) base;
	_tmp2_ = vala_conditional_expression_get_condition (self);
	_tmp3_ = _tmp2_;
	if (vala_expression_is_pure (_tmp3_)) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_conditional_expression_get_true_expression (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_pure (_tmp5_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_conditional_expression_get_false_expression (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_expression_is_pure (_tmp7_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean
vala_conditional_expression_real_is_accessible (ValaExpression* base,
                                                ValaSymbol* sym)
{
	ValaConditionalExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	self = (ValaConditionalExpression*) base;
	g_return_val_if_fail (sym != NULL, FALSE);
	_tmp2_ = vala_conditional_expression_get_condition (self);
	_tmp3_ = _tmp2_;
	if (vala_expression_is_accessible (_tmp3_, sym)) {
		ValaExpression* _tmp4_;
		ValaExpression* _tmp5_;
		_tmp4_ = vala_conditional_expression_get_true_expression (self);
		_tmp5_ = _tmp4_;
		_tmp1_ = vala_expression_is_accessible (_tmp5_, sym);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		ValaExpression* _tmp6_;
		ValaExpression* _tmp7_;
		_tmp6_ = vala_conditional_expression_get_false_expression (self);
		_tmp7_ = _tmp6_;
		_tmp0_ = vala_expression_is_accessible (_tmp7_, sym);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gchar*
vala_conditional_expression_real_to_string (ValaCodeNode* base)
{
	ValaConditionalExpression * self;
	gchar* result = NULL;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	ValaExpression* _tmp8_;
	ValaExpression* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	self = (ValaConditionalExpression*) base;
	_tmp0_ = vala_conditional_expression_get_condition (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_node_to_string ((ValaCodeNode*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_conditional_expression_get_true_expression (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_code_node_to_string ((ValaCodeNode*) _tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_conditional_expression_get_false_expression (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_code_node_to_string ((ValaCodeNode*) _tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strdup_printf ("(%s ? %s : %s)", _tmp3_, _tmp7_, _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp13_;
	return result;
}


static void
vala_conditional_expression_real_replace_expression (ValaCodeNode* base,
                                                     ValaExpression* old_node,
                                                     ValaExpression* new_node)
{
	ValaConditionalExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_conditional_expression_get_condition (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_conditional_expression_set_condition (self, new_node);
	}
	_tmp2_ = vala_conditional_expression_get_true_expression (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == old_node) {
		vala_conditional_expression_set_true_expression (self, new_node);
	}
	_tmp4_ = vala_conditional_expression_get_false_expression (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == old_node) {
		vala_conditional_expression_set_false_expression (self, new_node);
	}
}


static void
vala_conditional_expression_real_get_defined_variables (ValaCodeNode* base,
                                                        ValaCollection* collection)
{
	ValaConditionalExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_conditional_expression_get_condition (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_conditional_expression_get_true_expression (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_conditional_expression_get_false_expression (self);
	_tmp5_ = _tmp4_;
	vala_code_node_get_defined_variables ((ValaCodeNode*) _tmp5_, collection);
}


static void
vala_conditional_expression_real_get_used_variables (ValaCodeNode* base,
                                                     ValaCollection* collection)
{
	ValaConditionalExpression * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	ValaExpression* _tmp2_;
	ValaExpression* _tmp3_;
	ValaExpression* _tmp4_;
	ValaExpression* _tmp5_;
	self = (ValaConditionalExpression*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = vala_conditional_expression_get_condition (self);
	_tmp1_ = _tmp0_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp1_, collection);
	_tmp2_ = vala_conditional_expression_get_true_expression (self);
	_tmp3_ = _tmp2_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp3_, collection);
	_tmp4_ = vala_conditional_expression_get_false_expression (self);
	_tmp5_ = _tmp4_;
	vala_code_node_get_used_variables ((ValaCodeNode*) _tmp5_, collection);
}


static gboolean
vala_conditional_expression_real_check (ValaCodeNode* base,
                                        ValaCodeContext* context)
{
	ValaConditionalExpression * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSymbol* _tmp6_;
	ValaSymbol* _tmp7_;
	gchar* temp_name = NULL;
	gchar* _tmp10_;
	ValaExpression* _tmp11_;
	ValaExpression* _tmp12_;
	ValaDataType* _tmp13_;
	ValaDataType* _tmp14_;
	ValaExpression* _tmp15_;
	ValaExpression* _tmp16_;
	ValaDataType* _tmp17_;
	ValaDataType* _tmp18_;
	ValaLocalVariable* local = NULL;
	const gchar* _tmp19_;
	ValaSourceReference* _tmp20_;
	ValaSourceReference* _tmp21_;
	ValaLocalVariable* _tmp22_;
	ValaDeclarationStatement* decl = NULL;
	ValaLocalVariable* _tmp23_;
	ValaSourceReference* _tmp24_;
	ValaSourceReference* _tmp25_;
	ValaDeclarationStatement* _tmp26_;
	ValaLocalVariable* true_local = NULL;
	const gchar* _tmp27_;
	ValaExpression* _tmp28_;
	ValaExpression* _tmp29_;
	ValaExpression* _tmp30_;
	ValaExpression* _tmp31_;
	ValaSourceReference* _tmp32_;
	ValaSourceReference* _tmp33_;
	ValaLocalVariable* _tmp34_;
	ValaBlock* true_block = NULL;
	ValaExpression* _tmp35_;
	ValaExpression* _tmp36_;
	ValaSourceReference* _tmp37_;
	ValaSourceReference* _tmp38_;
	ValaBlock* _tmp39_;
	ValaDeclarationStatement* true_decl = NULL;
	ValaLocalVariable* _tmp40_;
	ValaExpression* _tmp41_;
	ValaExpression* _tmp42_;
	ValaSourceReference* _tmp43_;
	ValaSourceReference* _tmp44_;
	ValaDeclarationStatement* _tmp45_;
	ValaBlock* _tmp46_;
	ValaDeclarationStatement* _tmp47_;
	ValaLocalVariable* false_local = NULL;
	const gchar* _tmp48_;
	ValaExpression* _tmp49_;
	ValaExpression* _tmp50_;
	ValaExpression* _tmp51_;
	ValaExpression* _tmp52_;
	ValaSourceReference* _tmp53_;
	ValaSourceReference* _tmp54_;
	ValaLocalVariable* _tmp55_;
	ValaBlock* false_block = NULL;
	ValaExpression* _tmp56_;
	ValaExpression* _tmp57_;
	ValaSourceReference* _tmp58_;
	ValaSourceReference* _tmp59_;
	ValaBlock* _tmp60_;
	ValaDeclarationStatement* false_decl = NULL;
	ValaLocalVariable* _tmp61_;
	ValaExpression* _tmp62_;
	ValaExpression* _tmp63_;
	ValaSourceReference* _tmp64_;
	ValaSourceReference* _tmp65_;
	ValaDeclarationStatement* _tmp66_;
	ValaBlock* _tmp67_;
	ValaDeclarationStatement* _tmp68_;
	ValaIfStatement* if_stmt = NULL;
	ValaExpression* _tmp69_;
	ValaExpression* _tmp70_;
	ValaBlock* _tmp71_;
	ValaBlock* _tmp72_;
	ValaSourceReference* _tmp73_;
	ValaSourceReference* _tmp74_;
	ValaIfStatement* _tmp75_;
	ValaSemanticAnalyzer* _tmp76_;
	ValaSemanticAnalyzer* _tmp77_;
	ValaBlock* _tmp78_;
	ValaDeclarationStatement* _tmp79_;
	ValaSemanticAnalyzer* _tmp80_;
	ValaSemanticAnalyzer* _tmp81_;
	ValaBlock* _tmp82_;
	ValaIfStatement* _tmp83_;
	gboolean _tmp84_ = FALSE;
	gboolean _tmp85_ = FALSE;
	ValaIfStatement* _tmp86_;
	ValaLocalVariable* _tmp95_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaLocalVariable* _tmp98_;
	ValaExpression* _tmp99_;
	ValaExpression* _tmp100_;
	ValaBlock* _tmp101_;
	ValaLocalVariable* _tmp102_;
	ValaBlock* _tmp103_;
	ValaLocalVariable* _tmp104_;
	ValaExpression* _tmp105_;
	ValaExpression* _tmp106_;
	ValaDataType* _tmp107_;
	ValaDataType* _tmp108_;
	ValaExpression* _tmp109_;
	ValaExpression* _tmp110_;
	ValaDataType* _tmp111_;
	ValaDataType* _tmp112_;
	gboolean _tmp137_ = FALSE;
	ValaExpression* _tmp138_;
	ValaExpression* _tmp139_;
	ValaDataType* _tmp140_;
	ValaDataType* _tmp141_;
	gboolean _tmp142_;
	gboolean _tmp143_;
	ValaDataType* _tmp150_;
	ValaDataType* _tmp151_;
	ValaLocalVariable* _tmp152_;
	ValaDataType* _tmp153_;
	ValaDataType* _tmp154_;
	ValaDeclarationStatement* _tmp155_;
	ValaExpression* _tmp156_;
	ValaExpression* _tmp157_;
	ValaDataType* _tmp158_;
	ValaDataType* _tmp159_;
	ValaExpression* _tmp160_;
	ValaExpression* _tmp161_;
	ValaDataType* _tmp162_;
	ValaDataType* _tmp163_;
	ValaExpressionStatement* true_stmt = NULL;
	ValaLocalVariable* _tmp164_;
	const gchar* _tmp165_;
	const gchar* _tmp166_;
	ValaExpression* _tmp167_;
	ValaExpression* _tmp168_;
	ValaSourceReference* _tmp169_;
	ValaSourceReference* _tmp170_;
	ValaMemberAccess* _tmp171_;
	ValaMemberAccess* _tmp172_;
	ValaExpression* _tmp173_;
	ValaExpression* _tmp174_;
	ValaExpression* _tmp175_;
	ValaExpression* _tmp176_;
	ValaSourceReference* _tmp177_;
	ValaSourceReference* _tmp178_;
	ValaAssignment* _tmp179_;
	ValaAssignment* _tmp180_;
	ValaExpression* _tmp181_;
	ValaExpression* _tmp182_;
	ValaSourceReference* _tmp183_;
	ValaSourceReference* _tmp184_;
	ValaExpressionStatement* _tmp185_;
	ValaExpressionStatement* _tmp186_;
	ValaExpressionStatement* false_stmt = NULL;
	ValaLocalVariable* _tmp187_;
	const gchar* _tmp188_;
	const gchar* _tmp189_;
	ValaExpression* _tmp190_;
	ValaExpression* _tmp191_;
	ValaSourceReference* _tmp192_;
	ValaSourceReference* _tmp193_;
	ValaMemberAccess* _tmp194_;
	ValaMemberAccess* _tmp195_;
	ValaExpression* _tmp196_;
	ValaExpression* _tmp197_;
	ValaExpression* _tmp198_;
	ValaExpression* _tmp199_;
	ValaSourceReference* _tmp200_;
	ValaSourceReference* _tmp201_;
	ValaAssignment* _tmp202_;
	ValaAssignment* _tmp203_;
	ValaExpression* _tmp204_;
	ValaExpression* _tmp205_;
	ValaSourceReference* _tmp206_;
	ValaSourceReference* _tmp207_;
	ValaExpressionStatement* _tmp208_;
	ValaExpressionStatement* _tmp209_;
	ValaBlock* _tmp210_;
	ValaDeclarationStatement* _tmp211_;
	ValaExpressionStatement* _tmp212_;
	ValaBlock* _tmp213_;
	ValaDeclarationStatement* _tmp214_;
	ValaExpressionStatement* _tmp215_;
	ValaExpressionStatement* _tmp216_;
	ValaExpressionStatement* _tmp217_;
	ValaMemberAccess* ma = NULL;
	ValaLocalVariable* _tmp218_;
	const gchar* _tmp219_;
	const gchar* _tmp220_;
	ValaSourceReference* _tmp221_;
	ValaSourceReference* _tmp222_;
	ValaMemberAccess* _tmp223_;
	ValaMemberAccess* _tmp224_;
	ValaDataType* _tmp225_;
	ValaDataType* _tmp226_;
	ValaMemberAccess* _tmp227_;
	ValaDataType* _tmp228_;
	ValaDataType* _tmp229_;
	ValaCodeNode* _tmp230_;
	ValaCodeNode* _tmp231_;
	ValaMemberAccess* _tmp232_;
	ValaMemberAccess* _tmp233_;
	self = (ValaConditionalExpression*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_symbol (_tmp5_);
	_tmp7_ = _tmp6_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, VALA_TYPE_BLOCK)) {
		ValaSourceReference* _tmp8_;
		ValaSourceReference* _tmp9_;
		_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp9_ = _tmp8_;
		vala_report_error (_tmp9_, "Conditional expressions may only be used in blocks");
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		return result;
	}
	_tmp10_ = vala_code_node_get_temp_name ();
	temp_name = _tmp10_;
	_tmp11_ = vala_conditional_expression_get_true_expression (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp14_ = _tmp13_;
	vala_expression_set_target_type (_tmp12_, _tmp14_);
	_tmp15_ = vala_conditional_expression_get_false_expression (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp18_ = _tmp17_;
	vala_expression_set_target_type (_tmp16_, _tmp18_);
	_tmp19_ = temp_name;
	_tmp20_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp21_ = _tmp20_;
	_tmp22_ = vala_local_variable_new (NULL, _tmp19_, NULL, _tmp21_);
	local = _tmp22_;
	_tmp23_ = local;
	_tmp24_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_declaration_statement_new ((ValaSymbol*) _tmp23_, _tmp25_);
	decl = _tmp26_;
	_tmp27_ = temp_name;
	_tmp28_ = vala_conditional_expression_get_true_expression (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = vala_conditional_expression_get_true_expression (self);
	_tmp31_ = _tmp30_;
	_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = vala_local_variable_new (NULL, _tmp27_, _tmp29_, _tmp33_);
	true_local = _tmp34_;
	_tmp35_ = vala_conditional_expression_get_true_expression (self);
	_tmp36_ = _tmp35_;
	_tmp37_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = vala_block_new (_tmp38_);
	true_block = _tmp39_;
	_tmp40_ = true_local;
	_tmp41_ = vala_conditional_expression_get_true_expression (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp42_);
	_tmp44_ = _tmp43_;
	_tmp45_ = vala_declaration_statement_new ((ValaSymbol*) _tmp40_, _tmp44_);
	true_decl = _tmp45_;
	_tmp46_ = true_block;
	_tmp47_ = true_decl;
	vala_block_add_statement (_tmp46_, (ValaStatement*) _tmp47_);
	_tmp48_ = temp_name;
	_tmp49_ = vala_conditional_expression_get_false_expression (self);
	_tmp50_ = _tmp49_;
	_tmp51_ = vala_conditional_expression_get_false_expression (self);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = vala_local_variable_new (NULL, _tmp48_, _tmp50_, _tmp54_);
	false_local = _tmp55_;
	_tmp56_ = vala_conditional_expression_get_false_expression (self);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = vala_block_new (_tmp59_);
	false_block = _tmp60_;
	_tmp61_ = false_local;
	_tmp62_ = vala_conditional_expression_get_false_expression (self);
	_tmp63_ = _tmp62_;
	_tmp64_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp63_);
	_tmp65_ = _tmp64_;
	_tmp66_ = vala_declaration_statement_new ((ValaSymbol*) _tmp61_, _tmp65_);
	false_decl = _tmp66_;
	_tmp67_ = false_block;
	_tmp68_ = false_decl;
	vala_block_add_statement (_tmp67_, (ValaStatement*) _tmp68_);
	_tmp69_ = vala_conditional_expression_get_condition (self);
	_tmp70_ = _tmp69_;
	_tmp71_ = true_block;
	_tmp72_ = false_block;
	_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp74_ = _tmp73_;
	_tmp75_ = vala_if_statement_new (_tmp70_, _tmp71_, _tmp72_, _tmp74_);
	if_stmt = _tmp75_;
	_tmp76_ = vala_code_context_get_analyzer (context);
	_tmp77_ = _tmp76_;
	_tmp78_ = _tmp77_->insert_block;
	_tmp79_ = decl;
	vala_expression_insert_statement ((ValaExpression*) self, _tmp78_, (ValaStatement*) _tmp79_);
	_tmp80_ = vala_code_context_get_analyzer (context);
	_tmp81_ = _tmp80_;
	_tmp82_ = _tmp81_->insert_block;
	_tmp83_ = if_stmt;
	vala_expression_insert_statement ((ValaExpression*) self, _tmp82_, (ValaStatement*) _tmp83_);
	_tmp86_ = if_stmt;
	if (!vala_code_node_check ((ValaCodeNode*) _tmp86_, context)) {
		_tmp85_ = TRUE;
	} else {
		ValaExpression* _tmp87_;
		ValaExpression* _tmp88_;
		gboolean _tmp89_;
		gboolean _tmp90_;
		_tmp87_ = vala_conditional_expression_get_true_expression (self);
		_tmp88_ = _tmp87_;
		_tmp89_ = vala_code_node_get_error ((ValaCodeNode*) _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp85_ = _tmp90_;
	}
	if (_tmp85_) {
		_tmp84_ = TRUE;
	} else {
		ValaExpression* _tmp91_;
		ValaExpression* _tmp92_;
		gboolean _tmp93_;
		gboolean _tmp94_;
		_tmp91_ = vala_conditional_expression_get_false_expression (self);
		_tmp92_ = _tmp91_;
		_tmp93_ = vala_code_node_get_error ((ValaCodeNode*) _tmp92_);
		_tmp94_ = _tmp93_;
		_tmp84_ = _tmp94_;
	}
	if (_tmp84_) {
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		result = FALSE;
		_vala_code_node_unref0 (if_stmt);
		_vala_code_node_unref0 (false_decl);
		_vala_code_node_unref0 (false_block);
		_vala_code_node_unref0 (false_local);
		_vala_code_node_unref0 (true_decl);
		_vala_code_node_unref0 (true_block);
		_vala_code_node_unref0 (true_local);
		_vala_code_node_unref0 (decl);
		_vala_code_node_unref0 (local);
		_g_free0 (temp_name);
		return result;
	}
	_tmp95_ = true_local;
	_tmp96_ = vala_variable_get_initializer ((ValaVariable*) _tmp95_);
	_tmp97_ = _tmp96_;
	vala_conditional_expression_set_true_expression (self, _tmp97_);
	_tmp98_ = false_local;
	_tmp99_ = vala_variable_get_initializer ((ValaVariable*) _tmp98_);
	_tmp100_ = _tmp99_;
	vala_conditional_expression_set_false_expression (self, _tmp100_);
	_tmp101_ = true_block;
	_tmp102_ = true_local;
	vala_block_remove_local_variable (_tmp101_, _tmp102_);
	_tmp103_ = false_block;
	_tmp104_ = false_local;
	vala_block_remove_local_variable (_tmp103_, _tmp104_);
	_tmp105_ = vala_conditional_expression_get_false_expression (self);
	_tmp106_ = _tmp105_;
	_tmp107_ = vala_expression_get_value_type (_tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = vala_conditional_expression_get_true_expression (self);
	_tmp110_ = _tmp109_;
	_tmp111_ = vala_expression_get_value_type (_tmp110_);
	_tmp112_ = _tmp111_;
	if (vala_data_type_compatible (_tmp108_, _tmp112_)) {
		ValaExpression* _tmp113_;
		ValaExpression* _tmp114_;
		ValaDataType* _tmp115_;
		ValaDataType* _tmp116_;
		ValaDataType* _tmp117_;
		ValaDataType* _tmp118_;
		_tmp113_ = vala_conditional_expression_get_true_expression (self);
		_tmp114_ = _tmp113_;
		_tmp115_ = vala_expression_get_value_type (_tmp114_);
		_tmp116_ = _tmp115_;
		_tmp117_ = vala_data_type_copy (_tmp116_);
		_tmp118_ = _tmp117_;
		vala_expression_set_value_type ((ValaExpression*) self, _tmp118_);
		_vala_code_node_unref0 (_tmp118_);
	} else {
		ValaExpression* _tmp119_;
		ValaExpression* _tmp120_;
		ValaDataType* _tmp121_;
		ValaDataType* _tmp122_;
		ValaExpression* _tmp123_;
		ValaExpression* _tmp124_;
		ValaDataType* _tmp125_;
		ValaDataType* _tmp126_;
		_tmp119_ = vala_conditional_expression_get_true_expression (self);
		_tmp120_ = _tmp119_;
		_tmp121_ = vala_expression_get_value_type (_tmp120_);
		_tmp122_ = _tmp121_;
		_tmp123_ = vala_conditional_expression_get_false_expression (self);
		_tmp124_ = _tmp123_;
		_tmp125_ = vala_expression_get_value_type (_tmp124_);
		_tmp126_ = _tmp125_;
		if (vala_data_type_compatible (_tmp122_, _tmp126_)) {
			ValaExpression* _tmp127_;
			ValaExpression* _tmp128_;
			ValaDataType* _tmp129_;
			ValaDataType* _tmp130_;
			ValaDataType* _tmp131_;
			ValaDataType* _tmp132_;
			_tmp127_ = vala_conditional_expression_get_false_expression (self);
			_tmp128_ = _tmp127_;
			_tmp129_ = vala_expression_get_value_type (_tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = vala_data_type_copy (_tmp130_);
			_tmp132_ = _tmp131_;
			vala_expression_set_value_type ((ValaExpression*) self, _tmp132_);
			_vala_code_node_unref0 (_tmp132_);
		} else {
			ValaExpression* _tmp133_;
			ValaExpression* _tmp134_;
			ValaSourceReference* _tmp135_;
			ValaSourceReference* _tmp136_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp133_ = vala_conditional_expression_get_condition (self);
			_tmp134_ = _tmp133_;
			_tmp135_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp134_);
			_tmp136_ = _tmp135_;
			vala_report_error (_tmp136_, "Incompatible expressions");
			result = FALSE;
			_vala_code_node_unref0 (if_stmt);
			_vala_code_node_unref0 (false_decl);
			_vala_code_node_unref0 (false_block);
			_vala_code_node_unref0 (false_local);
			_vala_code_node_unref0 (true_decl);
			_vala_code_node_unref0 (true_block);
			_vala_code_node_unref0 (true_local);
			_vala_code_node_unref0 (decl);
			_vala_code_node_unref0 (local);
			_g_free0 (temp_name);
			return result;
		}
	}
	_tmp138_ = vala_conditional_expression_get_true_expression (self);
	_tmp139_ = _tmp138_;
	_tmp140_ = vala_expression_get_value_type (_tmp139_);
	_tmp141_ = _tmp140_;
	_tmp142_ = vala_data_type_get_value_owned (_tmp141_);
	_tmp143_ = _tmp142_;
	if (_tmp143_) {
		_tmp137_ = TRUE;
	} else {
		ValaExpression* _tmp144_;
		ValaExpression* _tmp145_;
		ValaDataType* _tmp146_;
		ValaDataType* _tmp147_;
		gboolean _tmp148_;
		gboolean _tmp149_;
		_tmp144_ = vala_conditional_expression_get_false_expression (self);
		_tmp145_ = _tmp144_;
		_tmp146_ = vala_expression_get_value_type (_tmp145_);
		_tmp147_ = _tmp146_;
		_tmp148_ = vala_data_type_get_value_owned (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp137_ = _tmp149_;
	}
	_tmp150_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp151_ = _tmp150_;
	vala_data_type_set_value_owned (_tmp151_, _tmp137_);
	_tmp152_ = local;
	_tmp153_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp154_ = _tmp153_;
	vala_variable_set_variable_type ((ValaVariable*) _tmp152_, _tmp154_);
	_tmp155_ = decl;
	vala_code_node_check ((ValaCodeNode*) _tmp155_, context);
	_tmp156_ = vala_conditional_expression_get_true_expression (self);
	_tmp157_ = _tmp156_;
	_tmp158_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp159_ = _tmp158_;
	vala_expression_set_target_type (_tmp157_, _tmp159_);
	_tmp160_ = vala_conditional_expression_get_false_expression (self);
	_tmp161_ = _tmp160_;
	_tmp162_ = vala_expression_get_value_type ((ValaExpression*) self);
	_tmp163_ = _tmp162_;
	vala_expression_set_target_type (_tmp161_, _tmp163_);
	_tmp164_ = local;
	_tmp165_ = vala_symbol_get_name ((ValaSymbol*) _tmp164_);
	_tmp166_ = _tmp165_;
	_tmp167_ = vala_conditional_expression_get_true_expression (self);
	_tmp168_ = _tmp167_;
	_tmp169_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp168_);
	_tmp170_ = _tmp169_;
	_tmp171_ = vala_member_access_new_simple (_tmp166_, _tmp170_);
	_tmp172_ = _tmp171_;
	_tmp173_ = vala_conditional_expression_get_true_expression (self);
	_tmp174_ = _tmp173_;
	_tmp175_ = vala_conditional_expression_get_true_expression (self);
	_tmp176_ = _tmp175_;
	_tmp177_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp176_);
	_tmp178_ = _tmp177_;
	_tmp179_ = vala_assignment_new ((ValaExpression*) _tmp172_, _tmp174_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp178_);
	_tmp180_ = _tmp179_;
	_tmp181_ = vala_conditional_expression_get_true_expression (self);
	_tmp182_ = _tmp181_;
	_tmp183_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp182_);
	_tmp184_ = _tmp183_;
	_tmp185_ = vala_expression_statement_new ((ValaExpression*) _tmp180_, _tmp184_);
	_tmp186_ = _tmp185_;
	_vala_code_node_unref0 (_tmp180_);
	_vala_code_node_unref0 (_tmp172_);
	true_stmt = _tmp186_;
	_tmp187_ = local;
	_tmp188_ = vala_symbol_get_name ((ValaSymbol*) _tmp187_);
	_tmp189_ = _tmp188_;
	_tmp190_ = vala_conditional_expression_get_false_expression (self);
	_tmp191_ = _tmp190_;
	_tmp192_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp191_);
	_tmp193_ = _tmp192_;
	_tmp194_ = vala_member_access_new_simple (_tmp189_, _tmp193_);
	_tmp195_ = _tmp194_;
	_tmp196_ = vala_conditional_expression_get_false_expression (self);
	_tmp197_ = _tmp196_;
	_tmp198_ = vala_conditional_expression_get_false_expression (self);
	_tmp199_ = _tmp198_;
	_tmp200_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp199_);
	_tmp201_ = _tmp200_;
	_tmp202_ = vala_assignment_new ((ValaExpression*) _tmp195_, _tmp197_, VALA_ASSIGNMENT_OPERATOR_SIMPLE, _tmp201_);
	_tmp203_ = _tmp202_;
	_tmp204_ = vala_conditional_expression_get_false_expression (self);
	_tmp205_ = _tmp204_;
	_tmp206_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp205_);
	_tmp207_ = _tmp206_;
	_tmp208_ = vala_expression_statement_new ((ValaExpression*) _tmp203_, _tmp207_);
	_tmp209_ = _tmp208_;
	_vala_code_node_unref0 (_tmp203_);
	_vala_code_node_unref0 (_tmp195_);
	false_stmt = _tmp209_;
	_tmp210_ = true_block;
	_tmp211_ = true_decl;
	_tmp212_ = true_stmt;
	vala_block_replace_statement (_tmp210_, (ValaStatement*) _tmp211_, (ValaStatement*) _tmp212_);
	_tmp213_ = false_block;
	_tmp214_ = false_decl;
	_tmp215_ = false_stmt;
	vala_block_replace_statement (_tmp213_, (ValaStatement*) _tmp214_, (ValaStatement*) _tmp215_);
	_tmp216_ = true_stmt;
	vala_code_node_check ((ValaCodeNode*) _tmp216_, context);
	_tmp217_ = false_stmt;
	vala_code_node_check ((ValaCodeNode*) _tmp217_, context);
	_tmp218_ = local;
	_tmp219_ = vala_symbol_get_name ((ValaSymbol*) _tmp218_);
	_tmp220_ = _tmp219_;
	_tmp221_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp222_ = _tmp221_;
	_tmp223_ = vala_member_access_new_simple (_tmp220_, _tmp222_);
	ma = _tmp223_;
	_tmp224_ = ma;
	_tmp225_ = vala_expression_get_formal_target_type ((ValaExpression*) self);
	_tmp226_ = _tmp225_;
	vala_expression_set_formal_target_type ((ValaExpression*) _tmp224_, _tmp226_);
	_tmp227_ = ma;
	_tmp228_ = vala_expression_get_target_type ((ValaExpression*) self);
	_tmp229_ = _tmp228_;
	vala_expression_set_target_type ((ValaExpression*) _tmp227_, _tmp229_);
	_tmp230_ = vala_code_node_get_parent_node ((ValaCodeNode*) self);
	_tmp231_ = _tmp230_;
	_tmp232_ = ma;
	vala_code_node_replace_expression (_tmp231_, (ValaExpression*) self, (ValaExpression*) _tmp232_);
	_tmp233_ = ma;
	vala_code_node_check ((ValaCodeNode*) _tmp233_, context);
	result = TRUE;
	_vala_code_node_unref0 (ma);
	_vala_code_node_unref0 (false_stmt);
	_vala_code_node_unref0 (true_stmt);
	_vala_code_node_unref0 (if_stmt);
	_vala_code_node_unref0 (false_decl);
	_vala_code_node_unref0 (false_block);
	_vala_code_node_unref0 (false_local);
	_vala_code_node_unref0 (true_decl);
	_vala_code_node_unref0 (true_block);
	_vala_code_node_unref0 (true_local);
	_vala_code_node_unref0 (decl);
	_vala_code_node_unref0 (local);
	_g_free0 (temp_name);
	return result;
}


ValaExpression*
vala_conditional_expression_get_condition (ValaConditionalExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_condition;
	result = _tmp0_;
	return result;
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


void
vala_conditional_expression_set_condition (ValaConditionalExpression* self,
                                           ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_condition);
	self->priv->_condition = _tmp0_;
	_tmp1_ = self->priv->_condition;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaExpression*
vala_conditional_expression_get_true_expression (ValaConditionalExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_true_expression;
	result = _tmp0_;
	return result;
}


void
vala_conditional_expression_set_true_expression (ValaConditionalExpression* self,
                                                 ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_true_expression);
	self->priv->_true_expression = _tmp0_;
	_tmp1_ = self->priv->_true_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


ValaExpression*
vala_conditional_expression_get_false_expression (ValaConditionalExpression* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_false_expression;
	result = _tmp0_;
	return result;
}


void
vala_conditional_expression_set_false_expression (ValaConditionalExpression* self,
                                                  ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_false_expression);
	self->priv->_false_expression = _tmp0_;
	_tmp1_ = self->priv->_false_expression;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_conditional_expression_class_init (ValaConditionalExpressionClass * klass)
{
	vala_conditional_expression_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_conditional_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaConditionalExpressionPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_conditional_expression_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_conditional_expression_real_accept_children;
	((ValaExpressionClass *) klass)->is_pure = (gboolean (*) (ValaExpression *)) vala_conditional_expression_real_is_pure;
	((ValaExpressionClass *) klass)->is_accessible = (gboolean (*) (ValaExpression *, ValaSymbol*)) vala_conditional_expression_real_is_accessible;
	((ValaCodeNodeClass *) klass)->to_string = (gchar* (*) (ValaCodeNode *)) vala_conditional_expression_real_to_string;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_conditional_expression_real_replace_expression;
	((ValaCodeNodeClass *) klass)->get_defined_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_conditional_expression_real_get_defined_variables;
	((ValaCodeNodeClass *) klass)->get_used_variables = (void (*) (ValaCodeNode *, ValaCollection*)) vala_conditional_expression_real_get_used_variables;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_conditional_expression_real_check;
}


static void
vala_conditional_expression_instance_init (ValaConditionalExpression * self)
{
	self->priv = VALA_CONDITIONAL_EXPRESSION_GET_PRIVATE (self);
}


static void
vala_conditional_expression_finalize (ValaCodeNode * obj)
{
	ValaConditionalExpression * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CONDITIONAL_EXPRESSION, ValaConditionalExpression);
	_vala_code_node_unref0 (self->priv->_condition);
	_vala_code_node_unref0 (self->priv->_true_expression);
	_vala_code_node_unref0 (self->priv->_false_expression);
	VALA_CODE_NODE_CLASS (vala_conditional_expression_parent_class)->finalize (obj);
}


/**
 * Represents a conditional expression in the source code.
 */
GType
vala_conditional_expression_get_type (void)
{
	static volatile gsize vala_conditional_expression_type_id__volatile = 0;
	if (g_once_init_enter (&vala_conditional_expression_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaConditionalExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_conditional_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaConditionalExpression), 0, (GInstanceInitFunc) vala_conditional_expression_instance_init, NULL };
		GType vala_conditional_expression_type_id;
		vala_conditional_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaConditionalExpression", &g_define_type_info, 0);
		g_once_init_leave (&vala_conditional_expression_type_id__volatile, vala_conditional_expression_type_id);
	}
	return vala_conditional_expression_type_id__volatile;
}



