/* valalockstatement.vala
 *
 * Copyright (C) 2006-2007  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <vala/valalockstatement.h>
#include <vala/valaexpression.h>
#include <vala/valablock.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaLockStatementPrivate {
	ValaExpression* _resource;
	ValaBlock* _body;
};

#define VALA_LOCK_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_LOCK_STATEMENT, ValaLockStatementPrivate))
enum  {
	VALA_LOCK_STATEMENT_DUMMY_PROPERTY
};
static void vala_lock_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_lock_statement_parent_class = NULL;
static ValaStatementIface* vala_lock_statement_vala_statement_parent_iface = NULL;
static void vala_lock_statement_finalize (ValaCodeNode* obj);



ValaLockStatement* vala_lock_statement_construct (GType object_type, ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference) {
	ValaLockStatement* self;
	g_return_val_if_fail (VALA_IS_EXPRESSION (resource), NULL);
	g_return_val_if_fail (VALA_IS_BLOCK (body), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaLockStatement*) (g_type_create_instance (object_type)));
	vala_lock_statement_set_body (self, body);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	vala_lock_statement_set_resource (self, resource);
	return self;
}


ValaLockStatement* vala_lock_statement_new (ValaExpression* resource, ValaBlock* body, ValaSourceReference* source_reference) {
	return vala_lock_statement_construct (VALA_TYPE_LOCK_STATEMENT, resource, body, source_reference);
}


static void vala_lock_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaLockStatement * self;
	self = VALA_LOCK_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_resource), visitor);
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_body), visitor);
	vala_code_visitor_visit_lock_statement (visitor, self);
}


ValaExpression* vala_lock_statement_get_resource (ValaLockStatement* self) {
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (self), NULL);
	return self->priv->_resource;
}


void vala_lock_statement_set_resource (ValaLockStatement* self, ValaExpression* value) {
	ValaExpression* _tmp2;
	ValaExpression* _tmp1;
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_resource = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_resource == NULL ? NULL : (self->priv->_resource = (vala_code_node_unref (self->priv->_resource), NULL))), _tmp2);
}


ValaBlock* vala_lock_statement_get_body (ValaLockStatement* self) {
	g_return_val_if_fail (VALA_IS_LOCK_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_lock_statement_set_body (ValaLockStatement* self, ValaBlock* value) {
	ValaBlock* _tmp2;
	ValaBlock* _tmp1;
	g_return_if_fail (VALA_IS_LOCK_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL))), _tmp2);
}


static void vala_lock_statement_class_init (ValaLockStatementClass * klass) {
	vala_lock_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_lock_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaLockStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_lock_statement_real_accept;
}


static void vala_lock_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_lock_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_lock_statement_instance_init (ValaLockStatement * self) {
	self->priv = VALA_LOCK_STATEMENT_GET_PRIVATE (self);
}


static void vala_lock_statement_finalize (ValaCodeNode* obj) {
	ValaLockStatement * self;
	self = VALA_LOCK_STATEMENT (obj);
	(self->priv->_resource == NULL ? NULL : (self->priv->_resource = (vala_code_node_unref (self->priv->_resource), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_code_node_unref (self->priv->_body), NULL)));
	VALA_CODE_NODE_CLASS (vala_lock_statement_parent_class)->finalize (obj);
}


GType vala_lock_statement_get_type (void) {
	static GType vala_lock_statement_type_id = 0;
	if (vala_lock_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaLockStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_lock_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaLockStatement), 0, (GInstanceInitFunc) vala_lock_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_lock_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_lock_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaLockStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_lock_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_lock_statement_type_id;
}




