/* valacreationmethod.vala
 *
 * Copyright (C) 2007-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacreationmethod.h>
#include <vala/valasourcereference.h>
#include <vala/valasymbol.h>
#include <vala/valavoidtype.h>
#include <vala/valacodevisitor.h>
#include <vala/valaformalparameter.h>
#include <vala/valadatatype.h>
#include <vala/valablock.h>
#include <vala/valatypesymbol.h>
#include <vala/valastruct.h>
#include <vala/valacodegenerator.h>
#include <vala/valaclass.h>




struct _ValaCreationMethodPrivate {
	char* _type_name;
	gint _n_construction_params;
	char* _custom_return_type_cname;
	gboolean _chain_up;
};

#define VALA_CREATION_METHOD_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CREATION_METHOD, ValaCreationMethodPrivate))
enum  {
	VALA_CREATION_METHOD_DUMMY_PROPERTY
};
static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static char* vala_creation_method_real_get_default_cname (ValaMethod* base);
static ValaCodeBinding* vala_creation_method_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen);
static char* vala_creation_method_real_get_real_cname (ValaMethod* base);
static gpointer vala_creation_method_parent_class = NULL;
static void vala_creation_method_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



/**
 * Creates a new method.
 *
 * @param name             method name
 * @param source_reference reference to source code
 * @return                 newly created method
 */
ValaCreationMethod* vala_creation_method_construct (GType object_type, const char* type_name, const char* name, ValaSourceReference* source_reference) {
	ValaCreationMethod* self;
	ValaVoidType* _tmp0;
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaCreationMethod*) (g_type_create_instance (object_type)));
	vala_symbol_init (VALA_SYMBOL (VALA_METHOD (self)));
	vala_symbol_set_name (VALA_SYMBOL (self), name);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	vala_creation_method_set_type_name (self, type_name);
	_tmp0 = NULL;
	vala_method_set_return_type (VALA_METHOD (self), VALA_DATA_TYPE ((_tmp0 = vala_void_type_new ())));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_code_node_unref (_tmp0), NULL)));
	vala_method_set_carray_length_parameter_position (VALA_METHOD (self), ((double) (-3)));
	vala_method_set_cdelegate_target_parameter_position (VALA_METHOD (self), ((double) (-3)));
	return self;
}


ValaCreationMethod* vala_creation_method_new (const char* type_name, const char* name, ValaSourceReference* source_reference) {
	return vala_creation_method_construct (VALA_TYPE_CREATION_METHOD, type_name, name, source_reference);
}


static void vala_creation_method_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_creation_method (visitor, self);
}


static void vala_creation_method_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (VALA_METHOD (self));
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				vala_code_node_accept (VALA_CODE_NODE (param), visitor);
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	{
		GeeList* error_type_collection;
		int error_type_it;
		error_type_collection = vala_code_node_get_error_types (VALA_CODE_NODE (self));
		for (error_type_it = 0; error_type_it < gee_collection_get_size (GEE_COLLECTION (error_type_collection)); error_type_it = error_type_it + 1) {
			ValaDataType* error_type;
			error_type = ((ValaDataType*) (gee_list_get (GEE_LIST (error_type_collection), error_type_it)));
			{
				vala_code_node_accept (VALA_CODE_NODE (error_type), visitor);
				(error_type == NULL ? NULL : (error_type = (vala_code_node_unref (error_type), NULL)));
			}
		}
		(error_type_collection == NULL ? NULL : (error_type_collection = (gee_collection_object_unref (error_type_collection), NULL)));
	}
	if (vala_method_get_body (VALA_METHOD (self)) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_method_get_body (VALA_METHOD (self))), visitor);
	}
}


static char* vala_creation_method_real_get_default_cname (ValaMethod* base) {
	ValaCreationMethod * self;
	ValaTypeSymbol* _tmp1;
	ValaSymbol* _tmp0;
	ValaTypeSymbol* parent;
	char* infix;
	self = VALA_CREATION_METHOD (base);
	_tmp1 = NULL;
	_tmp0 = NULL;
	parent = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (self)), (VALA_IS_TYPESYMBOL (_tmp0) ? ((ValaTypeSymbol*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	infix = g_strdup ("new");
	if (VALA_IS_STRUCT (parent)) {
		char* _tmp2;
		_tmp2 = NULL;
		infix = (_tmp2 = g_strdup ("init"), (infix = (g_free (infix), NULL)), _tmp2);
	}
	if (_vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (self)), "new") == 0) {
		char* _tmp3;
		char* _tmp4;
		char* _tmp5;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = g_strdup_printf ("%s%s", (_tmp3 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (parent))), infix), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4), (parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL))), (infix = (g_free (infix), NULL)), _tmp5);
	} else {
		char* _tmp6;
		char* _tmp7;
		char* _tmp8;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = g_strdup_printf ("%s%s_%s", (_tmp6 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (parent))), infix, vala_symbol_get_name (VALA_SYMBOL (self))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7), (parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL))), (infix = (g_free (infix), NULL)), _tmp8);
	}
	(parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL)));
	infix = (g_free (infix), NULL);
}


static ValaCodeBinding* vala_creation_method_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (base);
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (codegen), NULL);
	return vala_code_generator_create_creation_method_binding (codegen, self);
}


static char* vala_creation_method_real_get_real_cname (ValaMethod* base) {
	ValaCreationMethod * self;
	ValaClass* _tmp1;
	ValaSymbol* _tmp0;
	ValaClass* parent;
	char* infix;
	self = VALA_CREATION_METHOD (base);
	_tmp1 = NULL;
	_tmp0 = NULL;
	parent = (_tmp1 = (_tmp0 = vala_symbol_get_parent_symbol (VALA_SYMBOL (self)), (VALA_IS_CLASS (_tmp0) ? ((ValaClass*) (_tmp0)) : NULL)), (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	if (parent == NULL || vala_class_get_is_compact (parent)) {
		char* _tmp2;
		_tmp2 = NULL;
		return (_tmp2 = vala_method_get_cname (VALA_METHOD (self)), (parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL))), _tmp2);
	}
	infix = g_strdup ("construct");
	if (_vala_strcmp0 (vala_symbol_get_name (VALA_SYMBOL (self)), "new") == 0) {
		char* _tmp3;
		char* _tmp4;
		char* _tmp5;
		_tmp3 = NULL;
		_tmp4 = NULL;
		_tmp5 = NULL;
		return (_tmp5 = (_tmp4 = g_strdup_printf ("%s%s", (_tmp3 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (parent))), infix), (_tmp3 = (g_free (_tmp3), NULL)), _tmp4), (parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL))), (infix = (g_free (infix), NULL)), _tmp5);
	} else {
		char* _tmp6;
		char* _tmp7;
		char* _tmp8;
		_tmp6 = NULL;
		_tmp7 = NULL;
		_tmp8 = NULL;
		return (_tmp8 = (_tmp7 = g_strdup_printf ("%s%s_%s", (_tmp6 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (parent))), infix, vala_symbol_get_name (VALA_SYMBOL (self))), (_tmp6 = (g_free (_tmp6), NULL)), _tmp7), (parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL))), (infix = (g_free (infix), NULL)), _tmp8);
	}
	(parent == NULL ? NULL : (parent = (vala_code_node_unref (parent), NULL)));
	infix = (g_free (infix), NULL);
}


const char* vala_creation_method_get_type_name (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), NULL);
	return self->priv->_type_name;
}


void vala_creation_method_set_type_name (ValaCreationMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_type_name = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_type_name = (g_free (self->priv->_type_name), NULL)), _tmp2);
}


gint vala_creation_method_get_n_construction_params (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), 0);
	return self->priv->_n_construction_params;
}


void vala_creation_method_set_n_construction_params (ValaCreationMethod* self, gint value) {
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	self->priv->_n_construction_params = value;
}


const char* vala_creation_method_get_custom_return_type_cname (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), NULL);
	return self->priv->_custom_return_type_cname;
}


void vala_creation_method_set_custom_return_type_cname (ValaCreationMethod* self, const char* value) {
	char* _tmp2;
	const char* _tmp1;
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_custom_return_type_cname = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : g_strdup (_tmp1))), (self->priv->_custom_return_type_cname = (g_free (self->priv->_custom_return_type_cname), NULL)), _tmp2);
}


gboolean vala_creation_method_get_chain_up (ValaCreationMethod* self) {
	g_return_val_if_fail (VALA_IS_CREATION_METHOD (self), FALSE);
	return self->priv->_chain_up;
}


void vala_creation_method_set_chain_up (ValaCreationMethod* self, gboolean value) {
	g_return_if_fail (VALA_IS_CREATION_METHOD (self));
	self->priv->_chain_up = value;
}


static void vala_creation_method_class_init (ValaCreationMethodClass * klass) {
	vala_creation_method_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_creation_method_finalize;
	g_type_class_add_private (klass, sizeof (ValaCreationMethodPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_creation_method_real_accept;
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_creation_method_real_accept_children;
	VALA_METHOD_CLASS (klass)->get_default_cname = vala_creation_method_real_get_default_cname;
	VALA_CODE_NODE_CLASS (klass)->create_code_binding = vala_creation_method_real_create_code_binding;
	VALA_METHOD_CLASS (klass)->get_real_cname = vala_creation_method_real_get_real_cname;
}


static void vala_creation_method_instance_init (ValaCreationMethod * self) {
	self->priv = VALA_CREATION_METHOD_GET_PRIVATE (self);
}


static void vala_creation_method_finalize (ValaCodeNode* obj) {
	ValaCreationMethod * self;
	self = VALA_CREATION_METHOD (obj);
	self->priv->_type_name = (g_free (self->priv->_type_name), NULL);
	self->priv->_custom_return_type_cname = (g_free (self->priv->_custom_return_type_cname), NULL);
	VALA_CODE_NODE_CLASS (vala_creation_method_parent_class)->finalize (obj);
}


GType vala_creation_method_get_type (void) {
	static GType vala_creation_method_type_id = 0;
	if (vala_creation_method_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCreationMethodClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_creation_method_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCreationMethod), 0, (GInstanceInitFunc) vala_creation_method_instance_init, NULL };
		vala_creation_method_type_id = g_type_register_static (VALA_TYPE_METHOD, "ValaCreationMethod", &g_define_type_info, 0);
	}
	return vala_creation_method_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




