/* valaccodeclassbinding.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter, Raffaele Sandrini
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodeclassbinding.h>
#include <vala/valasymbol.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodestruct.h>
#include <ccode/valaccodeenum.h>
#include <ccode/valaccodefragment.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valacodenode.h>
#include <vala/valareport.h>
#include <vala/valasourcereference.h>
#include <ccode/valaccodeenumvalue.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodenewline.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodemacroreplacement.h>
#include <vala/valasourcefile.h>
#include <ccode/valaccodetypedefinition.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodedeclarator.h>
#include <gee/collection.h>
#include <ccode/valaccodecomment.h>
#include <vala/valacodevisitor.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeidentifier.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <vala/valadatatype.h>
#include <vala/valainterface.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodeformalparameter.h>
#include <ccode/valaccodeblock.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <ccode/valaccodecastexpression.h>
#include <ccode/valaccodeifstatement.h>
#include <ccode/valaccodestatement.h>
#include <ccode/valaccodebinaryexpression.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valamethod.h>
#include <vala/valaproperty.h>
#include <vala/valatypeparameter.h>
#include <gee/list.h>
#include <vala/valafield.h>
#include <vala/valamember.h>
#include <vala/valasignal.h>
#include <vala/valascope.h>
#include <vala/valapropertyaccessor.h>
#include <vala/valainstancecast.h>
#include <ccode/valaccodeswitchstatement.h>
#include <vala/valaobjecttype.h>
#include <vala/valaexpression.h>
#include <ccode/valaccodecasestatement.h>
#include <ccode/valaccodebreakstatement.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaclassregisterfunction.h>
#include <gobject/valatyperegisterfunction.h>
#include <gobject/valaccodetypesymbolbinding.h>




struct _ValaCCodeClassBindingPrivate {
	ValaClass* _cl;
};

#define VALA_CCODE_CLASS_BINDING_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CLASS_BINDING, ValaCCodeClassBindingPrivate))
enum  {
	VALA_CCODE_CLASS_BINDING_DUMMY_PROPERTY
};
static void vala_ccode_class_binding_real_emit (ValaCCodeBinding* base);
static void vala_ccode_class_binding_add_type_value_table_init_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_type_value_table_free_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_type_value_table_copy_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_type_value_table_peek_pointer_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_type_value_table_lcopy_value_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_type_value_table_collect_value_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_g_param_spec_type_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_g_value_set_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_g_value_get_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_class_init_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_interface_init_function (ValaCCodeClassBinding* self, ValaClass* cl, ValaInterface* iface);
static void vala_ccode_class_binding_add_instance_init_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_finalize_function (ValaCCodeClassBinding* self, ValaClass* cl);
static gboolean vala_ccode_class_binding_class_has_readable_properties (ValaCCodeClassBinding* self, ValaClass* cl);
static gboolean vala_ccode_class_binding_class_has_writable_properties (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_get_property_function (ValaCCodeClassBinding* self, ValaClass* cl);
static void vala_ccode_class_binding_add_set_property_function (ValaCCodeClassBinding* self, ValaClass* cl);
static ValaCCodeStatement* vala_ccode_class_binding_get_invalid_property_id_warn_statement (ValaCCodeClassBinding* self);
static gpointer vala_ccode_class_binding_parent_class = NULL;
static void vala_ccode_class_binding_finalize (ValaCodeBinding* obj);



ValaCCodeClassBinding* vala_ccode_class_binding_construct (GType object_type, ValaCCodeGenerator* codegen, ValaClass* cl) {
	ValaCCodeClassBinding* self;
	g_return_val_if_fail (VALA_IS_CCODE_GENERATOR (codegen), NULL);
	g_return_val_if_fail (VALA_IS_CLASS (cl), NULL);
	self = ((ValaCCodeClassBinding*) (g_type_create_instance (object_type)));
	vala_ccode_class_binding_set_cl (self, cl);
	vala_ccode_binding_set_codegen (VALA_CCODE_BINDING (self), codegen);
	return self;
}


ValaCCodeClassBinding* vala_ccode_class_binding_new (ValaCCodeGenerator* codegen, ValaClass* cl) {
	return vala_ccode_class_binding_construct (VALA_TYPE_CCODE_CLASS_BINDING, codegen, cl);
}


static void vala_ccode_class_binding_real_emit (ValaCCodeBinding* base) {
	ValaCCodeClassBinding * self;
	ValaSymbol* _tmp0;
	ValaSymbol* old_symbol;
	ValaTypeSymbol* _tmp1;
	ValaTypeSymbol* old_type_symbol;
	ValaClass* _tmp2;
	ValaClass* old_class;
	ValaCCodeStruct* _tmp3;
	ValaCCodeStruct* old_instance_struct;
	ValaCCodeStruct* _tmp4;
	ValaCCodeStruct* old_param_spec_struct;
	ValaCCodeStruct* _tmp5;
	ValaCCodeStruct* old_type_struct;
	ValaCCodeStruct* _tmp6;
	ValaCCodeStruct* old_instance_priv_struct;
	ValaCCodeEnum* _tmp7;
	ValaCCodeEnum* old_prop_enum;
	ValaCCodeFragment* _tmp8;
	ValaCCodeFragment* old_class_init_fragment;
	ValaCCodeFragment* _tmp9;
	ValaCCodeFragment* old_instance_init_fragment;
	ValaCCodeFragment* _tmp10;
	ValaCCodeFragment* old_instance_finalize_fragment;
	ValaSymbol* _tmp12;
	ValaSymbol* _tmp11;
	ValaTypeSymbol* _tmp14;
	ValaTypeSymbol* _tmp13;
	ValaClass* _tmp16;
	ValaClass* _tmp15;
	gboolean is_gtypeinstance;
	gboolean is_gobject;
	gboolean is_fundamental;
	char* _tmp17;
	gboolean _tmp18;
	ValaCCodeFragment* decl_frag;
	ValaCCodeFragment* def_frag;
	GeeList* _tmp84;
	gboolean _tmp85;
	ValaTypeSymbol* _tmp202;
	ValaTypeSymbol* _tmp201;
	ValaClass* _tmp204;
	ValaClass* _tmp203;
	ValaCCodeStruct* _tmp206;
	ValaCCodeStruct* _tmp205;
	ValaCCodeStruct* _tmp208;
	ValaCCodeStruct* _tmp207;
	ValaCCodeStruct* _tmp210;
	ValaCCodeStruct* _tmp209;
	ValaCCodeEnum* _tmp212;
	ValaCCodeEnum* _tmp211;
	ValaCCodeFragment* _tmp214;
	ValaCCodeFragment* _tmp213;
	ValaCCodeFragment* _tmp216;
	ValaCCodeFragment* _tmp215;
	ValaCCodeFragment* _tmp218;
	ValaCCodeFragment* _tmp217;
	self = VALA_CCODE_CLASS_BINDING (base);
	_tmp0 = NULL;
	old_symbol = (_tmp0 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol, (_tmp0 == NULL ? NULL : vala_code_node_ref (_tmp0)));
	_tmp1 = NULL;
	old_type_symbol = (_tmp1 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1)));
	_tmp2 = NULL;
	old_class = (_tmp2 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class, (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
	_tmp3 = NULL;
	old_instance_struct = (_tmp3 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, (_tmp3 == NULL ? NULL : vala_ccode_node_ref (_tmp3)));
	_tmp4 = NULL;
	old_param_spec_struct = (_tmp4 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct, (_tmp4 == NULL ? NULL : vala_ccode_node_ref (_tmp4)));
	_tmp5 = NULL;
	old_type_struct = (_tmp5 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, (_tmp5 == NULL ? NULL : vala_ccode_node_ref (_tmp5)));
	_tmp6 = NULL;
	old_instance_priv_struct = (_tmp6 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, (_tmp6 == NULL ? NULL : vala_ccode_node_ref (_tmp6)));
	_tmp7 = NULL;
	old_prop_enum = (_tmp7 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp7 == NULL ? NULL : vala_ccode_node_ref (_tmp7)));
	_tmp8 = NULL;
	old_class_init_fragment = (_tmp8 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment, (_tmp8 == NULL ? NULL : vala_ccode_node_ref (_tmp8)));
	_tmp9 = NULL;
	old_instance_init_fragment = (_tmp9 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment, (_tmp9 == NULL ? NULL : vala_ccode_node_ref (_tmp9)));
	_tmp10 = NULL;
	old_instance_finalize_fragment = (_tmp10 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment, (_tmp10 == NULL ? NULL : vala_ccode_node_ref (_tmp10)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (_tmp12 = (_tmp11 = VALA_SYMBOL (self->priv->_cl), (_tmp11 == NULL ? NULL : vala_code_node_ref (_tmp11))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_symbol), NULL))), _tmp12);
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (_tmp14 = (_tmp13 = VALA_TYPESYMBOL (self->priv->_cl), (_tmp13 == NULL ? NULL : vala_code_node_ref (_tmp13))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), NULL))), _tmp14);
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (_tmp16 = (_tmp15 = self->priv->_cl, (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL))), _tmp16);
	is_gtypeinstance = !vala_class_get_is_compact (self->priv->_cl) && !vala_class_get_is_static (self->priv->_cl);
	is_gobject = vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (self->priv->_cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type);
	is_fundamental = is_gtypeinstance && vala_class_get_base_class (self->priv->_cl) == NULL;
	_tmp17 = NULL;
	if ((_tmp18 = g_utf8_strlen ((_tmp17 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)), -1) < 3, (_tmp17 = (g_free (_tmp17), NULL)), _tmp18)) {
		char* _tmp20;
		char* _tmp19;
		vala_code_node_set_error (VALA_CODE_NODE (self->priv->_cl), TRUE);
		_tmp20 = NULL;
		_tmp19 = NULL;
		vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)), (_tmp20 = g_strdup_printf ("Class name `%s' is too short", (_tmp19 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))));
		_tmp20 = (g_free (_tmp20), NULL);
		_tmp19 = (g_free (_tmp19), NULL);
		(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
		(old_type_symbol == NULL ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL)));
		(old_class == NULL ? NULL : (old_class = (vala_code_node_unref (old_class), NULL)));
		(old_instance_struct == NULL ? NULL : (old_instance_struct = (vala_ccode_node_unref (old_instance_struct), NULL)));
		(old_param_spec_struct == NULL ? NULL : (old_param_spec_struct = (vala_ccode_node_unref (old_param_spec_struct), NULL)));
		(old_type_struct == NULL ? NULL : (old_type_struct = (vala_ccode_node_unref (old_type_struct), NULL)));
		(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (vala_ccode_node_unref (old_instance_priv_struct), NULL)));
		(old_prop_enum == NULL ? NULL : (old_prop_enum = (vala_ccode_node_unref (old_prop_enum), NULL)));
		(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (vala_ccode_node_unref (old_class_init_fragment), NULL)));
		(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (vala_ccode_node_unref (old_instance_init_fragment), NULL)));
		(old_instance_finalize_fragment == NULL ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL)));
		return;
	}
	if (!vala_class_get_is_static (self->priv->_cl)) {
		ValaCCodeStruct* _tmp23;
		char* _tmp22;
		char* _tmp21;
		ValaCCodeStruct* _tmp26;
		char* _tmp25;
		char* _tmp24;
		ValaCCodeStruct* _tmp29;
		char* _tmp28;
		char* _tmp27;
		ValaCCodeEnum* _tmp30;
		ValaCCodeEnumValue* _tmp33;
		char* _tmp32;
		char* _tmp31;
		ValaCCodeFragment* _tmp34;
		ValaCCodeFragment* _tmp35;
		ValaCCodeFragment* _tmp36;
		_tmp23 = NULL;
		_tmp22 = NULL;
		_tmp21 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (_tmp23 = vala_ccode_struct_new ((_tmp22 = g_strdup_printf ("_%s", (_tmp21 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct), NULL))), _tmp23);
		_tmp22 = (g_free (_tmp22), NULL);
		_tmp21 = (g_free (_tmp21), NULL);
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (_tmp26 = vala_ccode_struct_new ((_tmp25 = g_strdup_printf ("_%sClass", (_tmp24 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct), NULL))), _tmp26);
		_tmp25 = (g_free (_tmp25), NULL);
		_tmp24 = (g_free (_tmp24), NULL);
		_tmp29 = NULL;
		_tmp28 = NULL;
		_tmp27 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (_tmp29 = vala_ccode_struct_new ((_tmp28 = g_strdup_printf ("_%sPrivate", (_tmp27 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct), NULL))), _tmp29);
		_tmp28 = (g_free (_tmp28), NULL);
		_tmp27 = (g_free (_tmp27), NULL);
		_tmp30 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (_tmp30 = vala_ccode_enum_new (NULL), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum), NULL))), _tmp30);
		_tmp33 = NULL;
		_tmp32 = NULL;
		_tmp31 = NULL;
		vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp33 = vala_ccode_enum_value_new ((_tmp32 = g_strdup_printf ("%s_DUMMY_PROPERTY", (_tmp31 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), NULL)));
		(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
		_tmp32 = (g_free (_tmp32), NULL);
		_tmp31 = (g_free (_tmp31), NULL);
		_tmp34 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (_tmp34 = vala_ccode_fragment_new (), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment), NULL))), _tmp34);
		_tmp35 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (_tmp35 = vala_ccode_fragment_new (), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment), NULL))), _tmp35);
		_tmp36 = NULL;
		vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment = (_tmp36 = vala_ccode_fragment_new (), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment), NULL))), _tmp36);
	}
	decl_frag = NULL;
	def_frag = NULL;
	if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFragment* _tmp38;
		ValaCCodeFragment* _tmp37;
		ValaCCodeFragment* _tmp40;
		ValaCCodeFragment* _tmp39;
		_tmp38 = NULL;
		_tmp37 = NULL;
		decl_frag = (_tmp38 = (_tmp37 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_declaration, (_tmp37 == NULL ? NULL : vala_ccode_node_ref (_tmp37))), (decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL))), _tmp38);
		_tmp40 = NULL;
		_tmp39 = NULL;
		def_frag = (_tmp40 = (_tmp39 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_definition, (_tmp39 == NULL ? NULL : vala_ccode_node_ref (_tmp39))), (def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL))), _tmp40);
	} else {
		ValaCCodeFragment* _tmp42;
		ValaCCodeFragment* _tmp41;
		ValaCCodeFragment* _tmp44;
		ValaCCodeFragment* _tmp43;
		_tmp42 = NULL;
		_tmp41 = NULL;
		decl_frag = (_tmp42 = (_tmp41 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_declaration, (_tmp41 == NULL ? NULL : vala_ccode_node_ref (_tmp41))), (decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL))), _tmp42);
		_tmp44 = NULL;
		_tmp43 = NULL;
		def_frag = (_tmp44 = (_tmp43 = vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_definition, (_tmp43 == NULL ? NULL : vala_ccode_node_ref (_tmp43))), (def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL))), _tmp44);
	}
	if (is_gtypeinstance) {
		ValaCCodeNewline* _tmp45;
		char* _tmp46;
		char* _tmp47;
		char* macro;
		ValaCCodeMacroReplacement* _tmp49;
		char* _tmp48;
		char* _tmp52;
		char* _tmp51;
		char* _tmp50;
		ValaCCodeMacroReplacement* _tmp55;
		char* _tmp54;
		char* _tmp53;
		char* _tmp58;
		char* _tmp57;
		char* _tmp56;
		ValaCCodeMacroReplacement* _tmp61;
		char* _tmp60;
		char* _tmp59;
		char* _tmp63;
		char* _tmp62;
		ValaCCodeMacroReplacement* _tmp66;
		char* _tmp65;
		char* _tmp64;
		char* _tmp68;
		char* _tmp67;
		ValaCCodeMacroReplacement* _tmp71;
		char* _tmp70;
		char* _tmp69;
		char* _tmp74;
		char* _tmp73;
		char* _tmp72;
		ValaCCodeMacroReplacement* _tmp77;
		char* _tmp76;
		char* _tmp75;
		ValaCCodeNewline* _tmp78;
		_tmp45 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp45 = vala_ccode_newline_new ())));
		(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
		_tmp46 = NULL;
		_tmp47 = NULL;
		macro = (_tmp47 = g_strdup_printf ("(%s_get_type ())", (_tmp46 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_cl), NULL))), (_tmp46 = (g_free (_tmp46), NULL)), _tmp47);
		_tmp49 = NULL;
		_tmp48 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp49 = vala_ccode_macro_replacement_new ((_tmp48 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl))), macro))));
		(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
		_tmp48 = (g_free (_tmp48), NULL);
		_tmp52 = NULL;
		_tmp51 = NULL;
		_tmp50 = NULL;
		macro = (_tmp52 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_CAST ((obj), %s, %s))", (_tmp50 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl))), (_tmp51 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp52);
		_tmp51 = (g_free (_tmp51), NULL);
		_tmp50 = (g_free (_tmp50), NULL);
		_tmp55 = NULL;
		_tmp54 = NULL;
		_tmp53 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp55 = vala_ccode_macro_replacement_new ((_tmp54 = g_strdup_printf ("%s(obj)", (_tmp53 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
		(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
		_tmp54 = (g_free (_tmp54), NULL);
		_tmp53 = (g_free (_tmp53), NULL);
		_tmp58 = NULL;
		_tmp57 = NULL;
		_tmp56 = NULL;
		macro = (_tmp58 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_CAST ((klass), %s, %sClass))", (_tmp56 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl))), (_tmp57 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp58);
		_tmp57 = (g_free (_tmp57), NULL);
		_tmp56 = (g_free (_tmp56), NULL);
		_tmp61 = NULL;
		_tmp60 = NULL;
		_tmp59 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp61 = vala_ccode_macro_replacement_new ((_tmp60 = g_strdup_printf ("%s_CLASS(klass)", (_tmp59 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
		(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
		_tmp60 = (g_free (_tmp60), NULL);
		_tmp59 = (g_free (_tmp59), NULL);
		_tmp63 = NULL;
		_tmp62 = NULL;
		macro = (_tmp63 = g_strdup_printf ("(G_TYPE_CHECK_INSTANCE_TYPE ((obj), %s))", (_tmp62 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl)))), (macro = (g_free (macro), NULL)), _tmp63);
		_tmp62 = (g_free (_tmp62), NULL);
		_tmp66 = NULL;
		_tmp65 = NULL;
		_tmp64 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp66 = vala_ccode_macro_replacement_new ((_tmp65 = g_strdup_printf ("%s(obj)", (_tmp64 = vala_ccode_generator_get_type_check_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_TYPESYMBOL (self->priv->_cl))))), macro))));
		(_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL)));
		_tmp65 = (g_free (_tmp65), NULL);
		_tmp64 = (g_free (_tmp64), NULL);
		_tmp68 = NULL;
		_tmp67 = NULL;
		macro = (_tmp68 = g_strdup_printf ("(G_TYPE_CHECK_CLASS_TYPE ((klass), %s))", (_tmp67 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl)))), (macro = (g_free (macro), NULL)), _tmp68);
		_tmp67 = (g_free (_tmp67), NULL);
		_tmp71 = NULL;
		_tmp70 = NULL;
		_tmp69 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp71 = vala_ccode_macro_replacement_new ((_tmp70 = g_strdup_printf ("%s_CLASS(klass)", (_tmp69 = vala_ccode_generator_get_type_check_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), VALA_TYPESYMBOL (self->priv->_cl))))), macro))));
		(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
		_tmp70 = (g_free (_tmp70), NULL);
		_tmp69 = (g_free (_tmp69), NULL);
		_tmp74 = NULL;
		_tmp73 = NULL;
		_tmp72 = NULL;
		macro = (_tmp74 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_CLASS ((obj), %s, %sClass))", (_tmp72 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl))), (_tmp73 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (macro = (g_free (macro), NULL)), _tmp74);
		_tmp73 = (g_free (_tmp73), NULL);
		_tmp72 = (g_free (_tmp72), NULL);
		_tmp77 = NULL;
		_tmp76 = NULL;
		_tmp75 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp77 = vala_ccode_macro_replacement_new ((_tmp76 = g_strdup_printf ("%s_GET_CLASS(obj)", (_tmp75 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
		(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
		_tmp76 = (g_free (_tmp76), NULL);
		_tmp75 = (g_free (_tmp75), NULL);
		_tmp78 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp78 = vala_ccode_newline_new ())));
		(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
		macro = (g_free (macro), NULL);
	}
	if (!vala_class_get_is_static (self->priv->_cl) && vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)))) == NULL) {
		ValaCCodeTypeDefinition* _tmp82;
		ValaCCodeVariableDeclarator* _tmp81;
		char* _tmp80;
		char* _tmp79;
		_tmp82 = NULL;
		_tmp81 = NULL;
		_tmp80 = NULL;
		_tmp79 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp82 = vala_ccode_type_definition_new ((_tmp79 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct))), VALA_CCODE_DECLARATOR ((_tmp81 = vala_ccode_variable_declarator_new ((_tmp80 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))))))));
		(_tmp82 == NULL ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)));
		(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
		_tmp80 = (g_free (_tmp80), NULL);
		_tmp79 = (g_free (_tmp79), NULL);
	}
	if (vala_class_get_base_class (self->priv->_cl) != NULL) {
		char* _tmp83;
		_tmp83 = NULL;
		vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, (_tmp83 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_class_get_base_class (self->priv->_cl)), FALSE)), "parent_instance");
		_tmp83 = (g_free (_tmp83), NULL);
	} else {
		if (is_fundamental) {
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, "GTypeInstance", "parent_instance");
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, "volatile int", "ref_count");
		}
	}
	_tmp84 = NULL;
	if ((_tmp85 = vala_class_get_is_compact (self->priv->_cl) && vala_class_get_base_class (self->priv->_cl) == NULL && gee_collection_get_size (GEE_COLLECTION ((_tmp84 = vala_class_get_fields (self->priv->_cl)))) == 0, (_tmp84 == NULL ? NULL : (_tmp84 = (gee_collection_object_unref (_tmp84), NULL))), _tmp85)) {
		/* add dummy member, C doesn't allow empty structs*/
		vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, "int", "dummy");
	}
	if (is_gtypeinstance) {
		ValaCCodeTypeDefinition* _tmp95;
		ValaCCodeVariableDeclarator* _tmp94;
		char* _tmp93;
		char* _tmp92;
		char* _tmp91;
		char* _tmp97;
		char* _tmp96;
		if (vala_source_file_get_cycle (vala_source_reference_get_file (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)))) == NULL) {
			ValaCCodeTypeDefinition* _tmp90;
			ValaCCodeVariableDeclarator* _tmp89;
			char* _tmp88;
			char* _tmp87;
			char* _tmp86;
			_tmp90 = NULL;
			_tmp89 = NULL;
			_tmp88 = NULL;
			_tmp87 = NULL;
			_tmp86 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp90 = vala_ccode_type_definition_new ((_tmp86 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct))), VALA_CCODE_DECLARATOR ((_tmp89 = vala_ccode_variable_declarator_new ((_tmp88 = g_strdup_printf ("%sClass", (_tmp87 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))))))))));
			(_tmp90 == NULL ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)));
			(_tmp89 == NULL ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)));
			_tmp88 = (g_free (_tmp88), NULL);
			_tmp87 = (g_free (_tmp87), NULL);
			_tmp86 = (g_free (_tmp86), NULL);
		}
		_tmp95 = NULL;
		_tmp94 = NULL;
		_tmp93 = NULL;
		_tmp92 = NULL;
		_tmp91 = NULL;
		vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp95 = vala_ccode_type_definition_new ((_tmp91 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct))), VALA_CCODE_DECLARATOR ((_tmp94 = vala_ccode_variable_declarator_new ((_tmp93 = g_strdup_printf ("%sPrivate", (_tmp92 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))))))))));
		(_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)));
		(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
		_tmp93 = (g_free (_tmp93), NULL);
		_tmp92 = (g_free (_tmp92), NULL);
		_tmp91 = (g_free (_tmp91), NULL);
		_tmp97 = NULL;
		_tmp96 = NULL;
		vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct, (_tmp97 = g_strdup_printf ("%sPrivate *", (_tmp96 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))), "priv");
		_tmp97 = (g_free (_tmp97), NULL);
		_tmp96 = (g_free (_tmp96), NULL);
		if (is_fundamental) {
			char* _tmp99;
			char* _tmp98;
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, "GTypeClass", "parent_class");
			_tmp99 = NULL;
			_tmp98 = NULL;
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, "void", (_tmp99 = g_strdup_printf ("(*finalize) (%s *self)", (_tmp98 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)))));
			_tmp99 = (g_free (_tmp99), NULL);
			_tmp98 = (g_free (_tmp98), NULL);
		} else {
			char* _tmp101;
			char* _tmp100;
			_tmp101 = NULL;
			_tmp100 = NULL;
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct, (_tmp101 = g_strdup_printf ("%sClass", (_tmp100 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (vala_class_get_base_class (self->priv->_cl)), FALSE)))), "parent_class");
			_tmp101 = (g_free (_tmp101), NULL);
			_tmp100 = (g_free (_tmp100), NULL);
		}
	}
	if (!vala_class_get_is_static (self->priv->_cl)) {
		if (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl))) != NULL) {
			ValaCCodeComment* _tmp102;
			_tmp102 = NULL;
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE ((_tmp102 = vala_ccode_comment_new (vala_source_reference_get_comment (vala_code_node_get_source_reference (VALA_CODE_NODE (self->priv->_cl)))))));
			(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
		}
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct));
	}
	if (is_gtypeinstance) {
		GeeList* _tmp103;
		gboolean _tmp104;
		vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct));
		/* only add the *Private struct if it is not empty, i.e. we actually have private data */
		_tmp103 = NULL;
		if ((_tmp104 = vala_class_get_has_private_fields (self->priv->_cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp103 = vala_class_get_type_parameters (self->priv->_cl)))) > 0, (_tmp103 == NULL ? NULL : (_tmp103 = (gee_collection_object_unref (_tmp103), NULL))), _tmp104)) {
			char* _tmp106;
			char* _tmp105;
			char* _tmp107;
			char* macro;
			ValaCCodeMacroReplacement* _tmp110;
			char* _tmp109;
			char* _tmp108;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct));
			_tmp106 = NULL;
			_tmp105 = NULL;
			_tmp107 = NULL;
			macro = (_tmp107 = g_strdup_printf ("(G_TYPE_INSTANCE_GET_PRIVATE ((o), %s, %sPrivate))", (_tmp105 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (self->priv->_cl))), (_tmp106 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))), (_tmp106 = (g_free (_tmp106), NULL)), (_tmp105 = (g_free (_tmp105), NULL)), _tmp107);
			_tmp110 = NULL;
			_tmp109 = NULL;
			_tmp108 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp110 = vala_ccode_macro_replacement_new ((_tmp109 = g_strdup_printf ("%s_GET_PRIVATE(o)", (_tmp108 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))), macro))));
			(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
			_tmp109 = (g_free (_tmp109), NULL);
			_tmp108 = (g_free (_tmp108), NULL);
			macro = (g_free (macro), NULL);
		}
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum));
	}
	vala_code_node_accept_children (VALA_CODE_NODE (self->priv->_cl), VALA_CODE_VISITOR (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))));
	if (is_gtypeinstance) {
		GeeList* _tmp128;
		gboolean _tmp129;
		ValaClassRegisterFunction* type_fun;
		ValaCCodeFragment* _tmp132;
		if (is_fundamental) {
			ValaCCodeStruct* _tmp113;
			char* _tmp112;
			char* _tmp111;
			ValaCCodeTypeDefinition* _tmp118;
			ValaCCodeVariableDeclarator* _tmp117;
			char* _tmp116;
			char* _tmp115;
			char* _tmp114;
			ValaCCodeConstant* _tmp121;
			ValaCCodeMemberAccess* _tmp120;
			ValaCCodeIdentifier* _tmp119;
			ValaCCodeAssignment* _tmp122;
			ValaCCodeAssignment* ref_count;
			ValaCCodeExpressionStatement* _tmp123;
			_tmp113 = NULL;
			_tmp112 = NULL;
			_tmp111 = NULL;
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct = (_tmp113 = vala_ccode_struct_new ((_tmp112 = g_strdup_printf ("_%sParamSpec%s", (_tmp111 = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol (VALA_SYMBOL (self->priv->_cl)))), vala_symbol_get_name (VALA_SYMBOL (self->priv->_cl))))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct), NULL))), _tmp113);
			_tmp112 = (g_free (_tmp112), NULL);
			_tmp111 = (g_free (_tmp111), NULL);
			vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct, "GParamSpec", "parent_instance");
			vala_ccode_fragment_append (def_frag, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct));
			_tmp118 = NULL;
			_tmp117 = NULL;
			_tmp116 = NULL;
			_tmp115 = NULL;
			_tmp114 = NULL;
			vala_ccode_fragment_append (decl_frag, VALA_CCODE_NODE ((_tmp118 = vala_ccode_type_definition_new ((_tmp114 = g_strdup_printf ("struct %s", vala_ccode_struct_get_name (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->param_spec_struct))), VALA_CCODE_DECLARATOR ((_tmp117 = vala_ccode_variable_declarator_new ((_tmp116 = g_strdup_printf ("%sParamSpec%s", (_tmp115 = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol (VALA_SYMBOL (self->priv->_cl)))), vala_symbol_get_name (VALA_SYMBOL (self->priv->_cl)))))))))));
			(_tmp118 == NULL ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL)));
			(_tmp117 == NULL ? NULL : (_tmp117 = (vala_ccode_node_unref (_tmp117), NULL)));
			_tmp116 = (g_free (_tmp116), NULL);
			_tmp115 = (g_free (_tmp115), NULL);
			_tmp114 = (g_free (_tmp114), NULL);
			vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gvaluecollector_h_needed = TRUE;
			vala_ccode_class_binding_add_type_value_table_init_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_type_value_table_free_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_type_value_table_copy_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_type_value_table_peek_pointer_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_type_value_table_collect_value_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_type_value_table_lcopy_value_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_g_param_spec_type_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_g_value_get_function (self, self->priv->_cl);
			vala_ccode_class_binding_add_g_value_set_function (self, self->priv->_cl);
			_tmp121 = NULL;
			_tmp120 = NULL;
			_tmp119 = NULL;
			_tmp122 = NULL;
			ref_count = (_tmp122 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp120 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp119 = vala_ccode_identifier_new ("self"))), "ref_count"))), VALA_CCODE_EXPRESSION ((_tmp121 = vala_ccode_constant_new ("1"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL))), (_tmp120 == NULL ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL))), (_tmp119 == NULL ? NULL : (_tmp119 = (vala_ccode_node_unref (_tmp119), NULL))), _tmp122);
			_tmp123 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment, VALA_CCODE_NODE ((_tmp123 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
			(ref_count == NULL ? NULL : (ref_count = (vala_ccode_node_unref (ref_count), NULL)));
		} else {
			if (is_gobject) {
				GeeList* _tmp124;
				gboolean _tmp125;
				GeeList* _tmp126;
				gboolean _tmp127;
				_tmp124 = NULL;
				if ((_tmp125 = vala_ccode_class_binding_class_has_readable_properties (self, self->priv->_cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp124 = vala_class_get_type_parameters (self->priv->_cl)))) > 0, (_tmp124 == NULL ? NULL : (_tmp124 = (gee_collection_object_unref (_tmp124), NULL))), _tmp125)) {
					vala_ccode_class_binding_add_get_property_function (self, self->priv->_cl);
				}
				_tmp126 = NULL;
				if ((_tmp127 = vala_ccode_class_binding_class_has_writable_properties (self, self->priv->_cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp126 = vala_class_get_type_parameters (self->priv->_cl)))) > 0, (_tmp126 == NULL ? NULL : (_tmp126 = (gee_collection_object_unref (_tmp126), NULL))), _tmp127)) {
					vala_ccode_class_binding_add_set_property_function (self, self->priv->_cl);
				}
			}
		}
		vala_ccode_class_binding_add_class_init_function (self, self->priv->_cl);
		{
			GeeList* base_type_collection;
			int base_type_it;
			base_type_collection = vala_class_get_base_types (self->priv->_cl);
			for (base_type_it = 0; base_type_it < gee_collection_get_size (GEE_COLLECTION (base_type_collection)); base_type_it = base_type_it + 1) {
				ValaDataType* base_type;
				base_type = ((ValaDataType*) (gee_list_get (GEE_LIST (base_type_collection), base_type_it)));
				{
					if (VALA_IS_INTERFACE (vala_data_type_get_data_type (base_type))) {
						vala_ccode_class_binding_add_interface_init_function (self, self->priv->_cl, VALA_INTERFACE (vala_data_type_get_data_type (base_type)));
					}
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				}
			}
			(base_type_collection == NULL ? NULL : (base_type_collection = (gee_collection_object_unref (base_type_collection), NULL)));
		}
		vala_ccode_class_binding_add_instance_init_function (self, self->priv->_cl);
		_tmp128 = NULL;
		if ((_tmp129 = !vala_class_get_is_compact (self->priv->_cl) && (gee_collection_get_size (GEE_COLLECTION ((_tmp128 = vala_class_get_fields (self->priv->_cl)))) > 0 || vala_class_get_destructor (self->priv->_cl) != NULL || vala_class_is_fundamental (self->priv->_cl)), (_tmp128 == NULL ? NULL : (_tmp128 = (gee_collection_object_unref (_tmp128), NULL))), _tmp129)) {
			vala_ccode_class_binding_add_finalize_function (self, self->priv->_cl);
		}
		type_fun = vala_class_register_function_new (self->priv->_cl, vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)));
		vala_typeregister_function_init_from_type (VALA_TYPEREGISTER_FUNCTION (type_fun), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin);
		if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaCCodeFragment* _tmp130;
			_tmp130 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp130 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp130 == NULL ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)));
		} else {
			ValaCCodeFragment* _tmp131;
			_tmp131 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp131 = vala_typeregister_function_get_declaration (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
			(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
		}
		_tmp132 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE ((_tmp132 = vala_typeregister_function_get_definition (VALA_TYPEREGISTER_FUNCTION (type_fun)))));
		(_tmp132 == NULL ? NULL : (_tmp132 = (vala_ccode_node_unref (_tmp132), NULL)));
		if (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->in_plugin) {
			ValaCCodeIdentifier* _tmp135;
			char* _tmp134;
			char* _tmp133;
			ValaCCodeFunctionCall* _tmp136;
			ValaCCodeFunctionCall* register_call;
			ValaCCodeIdentifier* _tmp137;
			ValaCCodeExpressionStatement* _tmp138;
			/* FIXME resolve potential dependency issues, i.e. base types have to be registered before derived types*/
			_tmp135 = NULL;
			_tmp134 = NULL;
			_tmp133 = NULL;
			_tmp136 = NULL;
			register_call = (_tmp136 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp135 = vala_ccode_identifier_new ((_tmp134 = g_strdup_printf ("%s_register_type", (_tmp133 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (self->priv->_cl), NULL)))))))), (_tmp135 == NULL ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL))), (_tmp134 = (g_free (_tmp134), NULL)), (_tmp133 = (g_free (_tmp133), NULL)), _tmp136);
			_tmp137 = NULL;
			vala_ccode_function_call_add_argument (register_call, VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_identifier_new (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_param_name))));
			(_tmp137 == NULL ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL)));
			_tmp138 = NULL;
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->module_init_fragment, VALA_CCODE_NODE ((_tmp138 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (register_call)))));
			(_tmp138 == NULL ? NULL : (_tmp138 = (vala_ccode_node_unref (_tmp138), NULL)));
			(register_call == NULL ? NULL : (register_call = (vala_ccode_node_unref (register_call), NULL)));
		}
		if (is_fundamental) {
			char* _tmp140;
			char* _tmp139;
			ValaCCodeFunction* _tmp141;
			ValaCCodeFunction* ref_fun;
			char* _tmp143;
			char* _tmp142;
			ValaCCodeFunction* _tmp144;
			ValaCCodeFunction* unref_fun;
			ValaCCodeFormalParameter* _tmp145;
			ValaCCodeFormalParameter* _tmp146;
			ValaCCodeBlock* ref_block;
			ValaCCodeBlock* unref_block;
			char* _tmp152;
			char* _tmp151;
			ValaCCodeDeclaration* _tmp153;
			ValaCCodeDeclaration* cdecl_;
			ValaCCodeVariableDeclarator* _tmp155;
			ValaCCodeIdentifier* _tmp154;
			ValaCCodeIdentifier* _tmp156;
			ValaCCodeMemberAccess* _tmp157;
			ValaCCodeMemberAccess* ref_count;
			ValaCCodeIdentifier* _tmp158;
			ValaCCodeFunctionCall* _tmp159;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeUnaryExpression* _tmp160;
			ValaCCodeExpressionStatement* _tmp161;
			ValaCCodeReturnStatement* _tmp163;
			ValaCCodeIdentifier* _tmp162;
			ValaCCodeBlock* destroy_block;
			ValaCCodeIdentifier* _tmp166;
			char* _tmp165;
			char* _tmp164;
			ValaCCodeFunctionCall* _tmp167;
			ValaCCodeFunctionCall* get_class;
			ValaCCodeIdentifier* _tmp168;
			ValaCCodeIdentifier* _tmp171;
			char* _tmp170;
			char* _tmp169;
			ValaCCodeFunctionCall* _tmp172;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp173;
			ValaCCodeFunctionCall* _tmp175;
			ValaCCodeMemberAccess* _tmp174;
			ValaCCodeIdentifier* _tmp176;
			ValaCCodeExpressionStatement* _tmp177;
			ValaCCodeIdentifier* _tmp178;
			ValaCCodeFunctionCall* _tmp179;
			ValaCCodeFunctionCall* free;
			ValaCCodeCastExpression* _tmp181;
			ValaCCodeIdentifier* _tmp180;
			ValaCCodeExpressionStatement* _tmp182;
			ValaCCodeFunctionCall* _tmp184;
			ValaCCodeIdentifier* _tmp183;
			ValaCCodeUnaryExpression* _tmp185;
			ValaCCodeIfStatement* _tmp186;
			_tmp140 = NULL;
			_tmp139 = NULL;
			_tmp141 = NULL;
			ref_fun = (_tmp141 = vala_ccode_function_new ((_tmp140 = g_strconcat ((_tmp139 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (self->priv->_cl))), "ref", NULL)), "gpointer"), (_tmp140 = (g_free (_tmp140), NULL)), (_tmp139 = (g_free (_tmp139), NULL)), _tmp141);
			_tmp143 = NULL;
			_tmp142 = NULL;
			_tmp144 = NULL;
			unref_fun = (_tmp144 = vala_ccode_function_new ((_tmp143 = g_strconcat ((_tmp142 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (self->priv->_cl))), "unref", NULL)), "void"), (_tmp143 = (g_free (_tmp143), NULL)), (_tmp142 = (g_free (_tmp142), NULL)), _tmp144);
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (ref_fun, VALA_CCODE_MODIFIERS_STATIC);
				vala_ccode_function_set_modifiers (unref_fun, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp145 = NULL;
			vala_ccode_function_add_parameter (ref_fun, (_tmp145 = vala_ccode_formal_parameter_new ("instance", "gpointer")));
			(_tmp145 == NULL ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL)));
			_tmp146 = NULL;
			vala_ccode_function_add_parameter (unref_fun, (_tmp146 = vala_ccode_formal_parameter_new ("instance", "gpointer")));
			(_tmp146 == NULL ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL)));
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp147;
				ValaCCodeFunction* _tmp148;
				_tmp147 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp147 = vala_ccode_function_copy (ref_fun))));
				(_tmp147 == NULL ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL)));
				_tmp148 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp148 = vala_ccode_function_copy (unref_fun))));
				(_tmp148 == NULL ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL)));
			} else {
				ValaCCodeFunction* _tmp149;
				ValaCCodeFunction* _tmp150;
				_tmp149 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp149 = vala_ccode_function_copy (ref_fun))));
				(_tmp149 == NULL ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL)));
				_tmp150 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp150 = vala_ccode_function_copy (unref_fun))));
				(_tmp150 == NULL ? NULL : (_tmp150 = (vala_ccode_node_unref (_tmp150), NULL)));
			}
			ref_block = vala_ccode_block_new ();
			unref_block = vala_ccode_block_new ();
			_tmp152 = NULL;
			_tmp151 = NULL;
			_tmp153 = NULL;
			cdecl_ = (_tmp153 = vala_ccode_declaration_new ((_tmp152 = g_strconcat ((_tmp151 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)), "*", NULL))), (_tmp152 = (g_free (_tmp152), NULL)), (_tmp151 = (g_free (_tmp151), NULL)), _tmp153);
			_tmp155 = NULL;
			_tmp154 = NULL;
			vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp155 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION ((_tmp154 = vala_ccode_identifier_new ("instance")))))));
			(_tmp155 == NULL ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL)));
			(_tmp154 == NULL ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL)));
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE (cdecl_));
			vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE (cdecl_));
			_tmp156 = NULL;
			_tmp157 = NULL;
			ref_count = (_tmp157 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp156 = vala_ccode_identifier_new ("self"))), "ref_count"), (_tmp156 == NULL ? NULL : (_tmp156 = (vala_ccode_node_unref (_tmp156), NULL))), _tmp157);
			_tmp158 = NULL;
			_tmp159 = NULL;
			ccall = (_tmp159 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_identifier_new ("g_atomic_int_inc")))), (_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL))), _tmp159);
			_tmp160 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL)));
			_tmp161 = NULL;
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE ((_tmp161 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp161 == NULL ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL)));
			_tmp163 = NULL;
			_tmp162 = NULL;
			vala_ccode_block_add_statement (ref_block, VALA_CCODE_NODE ((_tmp163 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_identifier_new ("instance")))))));
			(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
			(_tmp162 == NULL ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)));
			destroy_block = vala_ccode_block_new ();
			_tmp166 = NULL;
			_tmp165 = NULL;
			_tmp164 = NULL;
			_tmp167 = NULL;
			get_class = (_tmp167 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp166 = vala_ccode_identifier_new ((_tmp165 = g_strdup_printf ("%s_GET_CLASS", (_tmp164 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))))))), (_tmp166 == NULL ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL))), (_tmp165 = (g_free (_tmp165), NULL)), (_tmp164 = (g_free (_tmp164), NULL)), _tmp167);
			_tmp168 = NULL;
			vala_ccode_function_call_add_argument (get_class, VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_identifier_new ("self"))));
			(_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL)));
			/* finalize class*/
			_tmp171 = NULL;
			_tmp170 = NULL;
			_tmp169 = NULL;
			_tmp172 = NULL;
			ccast = (_tmp172 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp171 = vala_ccode_identifier_new ((_tmp170 = g_strdup_printf ("%s_GET_CLASS", (_tmp169 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (self->priv->_cl), NULL)))))))), (_tmp171 == NULL ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL))), (_tmp170 = (g_free (_tmp170), NULL)), (_tmp169 = (g_free (_tmp169), NULL)), _tmp172);
			_tmp173 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp173 = vala_ccode_identifier_new ("self"))));
			(_tmp173 == NULL ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL)));
			_tmp175 = NULL;
			_tmp174 = NULL;
			ccall = (_tmp175 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp174 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "finalize")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp175);
			(_tmp174 == NULL ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL)));
			_tmp176 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp176 = vala_ccode_identifier_new ("self"))));
			(_tmp176 == NULL ? NULL : (_tmp176 = (vala_ccode_node_unref (_tmp176), NULL)));
			_tmp177 = NULL;
			vala_ccode_block_add_statement (destroy_block, VALA_CCODE_NODE ((_tmp177 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp177 == NULL ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)));
			/* free type instance*/
			_tmp178 = NULL;
			_tmp179 = NULL;
			free = (_tmp179 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp178 = vala_ccode_identifier_new ("g_type_free_instance")))), (_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL))), _tmp179);
			_tmp181 = NULL;
			_tmp180 = NULL;
			vala_ccode_function_call_add_argument (free, VALA_CCODE_EXPRESSION ((_tmp181 = vala_ccode_cast_expression_new (VALA_CCODE_EXPRESSION ((_tmp180 = vala_ccode_identifier_new ("self"))), "GTypeInstance *"))));
			(_tmp181 == NULL ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL)));
			(_tmp180 == NULL ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL)));
			_tmp182 = NULL;
			vala_ccode_block_add_statement (destroy_block, VALA_CCODE_NODE ((_tmp182 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (free)))));
			(_tmp182 == NULL ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL)));
			_tmp184 = NULL;
			_tmp183 = NULL;
			ccall = (_tmp184 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp183 = vala_ccode_identifier_new ("g_atomic_int_dec_and_test")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp184);
			(_tmp183 == NULL ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL)));
			_tmp185 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp185 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION (ref_count)))));
			(_tmp185 == NULL ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)));
			_tmp186 = NULL;
			vala_ccode_block_add_statement (unref_block, VALA_CCODE_NODE ((_tmp186 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_STATEMENT (destroy_block), NULL))));
			(_tmp186 == NULL ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL)));
			vala_ccode_function_set_block (ref_fun, ref_block);
			vala_ccode_function_set_block (unref_fun, unref_block);
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (ref_fun));
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (unref_fun));
			(ref_fun == NULL ? NULL : (ref_fun = (vala_ccode_node_unref (ref_fun), NULL)));
			(unref_fun == NULL ? NULL : (unref_fun = (vala_ccode_node_unref (unref_fun), NULL)));
			(ref_block == NULL ? NULL : (ref_block = (vala_ccode_node_unref (ref_block), NULL)));
			(unref_block == NULL ? NULL : (unref_block = (vala_ccode_node_unref (unref_block), NULL)));
			(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			(ref_count == NULL ? NULL : (ref_count = (vala_ccode_node_unref (ref_count), NULL)));
			(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
			(destroy_block == NULL ? NULL : (destroy_block = (vala_ccode_node_unref (destroy_block), NULL)));
			(get_class == NULL ? NULL : (get_class = (vala_ccode_node_unref (get_class), NULL)));
			(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
			(free == NULL ? NULL : (free = (vala_ccode_node_unref (free), NULL)));
		}
		(type_fun == NULL ? NULL : (type_fun = (vala_typeregister_function_unref (type_fun), NULL)));
	} else {
		if (!vala_class_get_is_static (self->priv->_cl)) {
			char* _tmp188;
			char* _tmp187;
			ValaCCodeFunction* _tmp189;
			ValaCCodeFunction* function;
			ValaCCodeFormalParameter* _tmp192;
			char* _tmp191;
			char* _tmp190;
			ValaCCodeBlock* cblock;
			ValaCCodeIdentifier* _tmp195;
			ValaCCodeFunctionCall* _tmp196;
			ValaCCodeFunctionCall* ccall;
			ValaCCodeIdentifier* _tmp198;
			char* _tmp197;
			ValaCCodeIdentifier* _tmp199;
			ValaCCodeExpressionStatement* _tmp200;
			vala_ccode_class_binding_add_instance_init_function (self, self->priv->_cl);
			_tmp188 = NULL;
			_tmp187 = NULL;
			_tmp189 = NULL;
			function = (_tmp189 = vala_ccode_function_new ((_tmp188 = g_strconcat ((_tmp187 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (self->priv->_cl))), "free", NULL)), "void"), (_tmp188 = (g_free (_tmp188), NULL)), (_tmp187 = (g_free (_tmp187), NULL)), _tmp189);
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
			}
			_tmp192 = NULL;
			_tmp191 = NULL;
			_tmp190 = NULL;
			vala_ccode_function_add_parameter (function, (_tmp192 = vala_ccode_formal_parameter_new ("self", (_tmp191 = g_strconcat ((_tmp190 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE)), "*", NULL)))));
			(_tmp192 == NULL ? NULL : (_tmp192 = (vala_ccode_node_unref (_tmp192), NULL)));
			_tmp191 = (g_free (_tmp191), NULL);
			_tmp190 = (g_free (_tmp190), NULL);
			if (vala_symbol_get_access (VALA_SYMBOL (self->priv->_cl)) != VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
				ValaCCodeFunction* _tmp193;
				_tmp193 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp193 = vala_ccode_function_copy (function))));
				(_tmp193 == NULL ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL)));
			} else {
				ValaCCodeFunction* _tmp194;
				_tmp194 = NULL;
				vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp194 = vala_ccode_function_copy (function))));
				(_tmp194 == NULL ? NULL : (_tmp194 = (vala_ccode_node_unref (_tmp194), NULL)));
			}
			cblock = vala_ccode_block_new ();
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment));
			if (vala_class_get_destructor (self->priv->_cl) != NULL) {
				vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_class_get_destructor (self->priv->_cl))));
			}
			_tmp195 = NULL;
			_tmp196 = NULL;
			ccall = (_tmp196 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp195 = vala_ccode_identifier_new ("g_slice_free")))), (_tmp195 == NULL ? NULL : (_tmp195 = (vala_ccode_node_unref (_tmp195), NULL))), _tmp196);
			_tmp198 = NULL;
			_tmp197 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp198 = vala_ccode_identifier_new ((_tmp197 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (self->priv->_cl), FALSE))))));
			(_tmp198 == NULL ? NULL : (_tmp198 = (vala_ccode_node_unref (_tmp198), NULL)));
			_tmp197 = (g_free (_tmp197), NULL);
			_tmp199 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp199 = vala_ccode_identifier_new ("self"))));
			(_tmp199 == NULL ? NULL : (_tmp199 = (vala_ccode_node_unref (_tmp199), NULL)));
			_tmp200 = NULL;
			vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp200 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
			(_tmp200 == NULL ? NULL : (_tmp200 = (vala_ccode_node_unref (_tmp200), NULL)));
			vala_ccode_function_set_block (function, cblock);
			vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
			(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
			(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
			(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
		}
	}
	_tmp202 = NULL;
	_tmp201 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (_tmp202 = (_tmp201 = old_type_symbol, (_tmp201 == NULL ? NULL : vala_code_node_ref (_tmp201))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_type_symbol), NULL))), _tmp202);
	_tmp204 = NULL;
	_tmp203 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (_tmp204 = (_tmp203 = old_class, (_tmp203 == NULL ? NULL : vala_code_node_ref (_tmp203))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class = (vala_code_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->current_class), NULL))), _tmp204);
	_tmp206 = NULL;
	_tmp205 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (_tmp206 = (_tmp205 = old_instance_struct, (_tmp205 == NULL ? NULL : vala_ccode_node_ref (_tmp205))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_struct), NULL))), _tmp206);
	_tmp208 = NULL;
	_tmp207 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (_tmp208 = (_tmp207 = old_type_struct, (_tmp207 == NULL ? NULL : vala_ccode_node_ref (_tmp207))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->type_struct), NULL))), _tmp208);
	_tmp210 = NULL;
	_tmp209 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (_tmp210 = (_tmp209 = old_instance_priv_struct, (_tmp209 == NULL ? NULL : vala_ccode_node_ref (_tmp209))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct), NULL))), _tmp210);
	_tmp212 = NULL;
	_tmp211 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (_tmp212 = (_tmp211 = old_prop_enum, (_tmp211 == NULL ? NULL : vala_ccode_node_ref (_tmp211))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum), NULL))), _tmp212);
	_tmp214 = NULL;
	_tmp213 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (_tmp214 = (_tmp213 = old_class_init_fragment, (_tmp213 == NULL ? NULL : vala_ccode_node_ref (_tmp213))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment), NULL))), _tmp214);
	_tmp216 = NULL;
	_tmp215 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (_tmp216 = (_tmp215 = old_instance_init_fragment, (_tmp215 == NULL ? NULL : vala_ccode_node_ref (_tmp215))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment), NULL))), _tmp216);
	_tmp218 = NULL;
	_tmp217 = NULL;
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment = (_tmp218 = (_tmp217 = old_instance_finalize_fragment, (_tmp217 == NULL ? NULL : vala_ccode_node_ref (_tmp217))), (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment == NULL ? NULL : (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment = (vala_ccode_node_unref (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment), NULL))), _tmp218);
	(old_symbol == NULL ? NULL : (old_symbol = (vala_code_node_unref (old_symbol), NULL)));
	(old_type_symbol == NULL ? NULL : (old_type_symbol = (vala_code_node_unref (old_type_symbol), NULL)));
	(old_class == NULL ? NULL : (old_class = (vala_code_node_unref (old_class), NULL)));
	(old_instance_struct == NULL ? NULL : (old_instance_struct = (vala_ccode_node_unref (old_instance_struct), NULL)));
	(old_param_spec_struct == NULL ? NULL : (old_param_spec_struct = (vala_ccode_node_unref (old_param_spec_struct), NULL)));
	(old_type_struct == NULL ? NULL : (old_type_struct = (vala_ccode_node_unref (old_type_struct), NULL)));
	(old_instance_priv_struct == NULL ? NULL : (old_instance_priv_struct = (vala_ccode_node_unref (old_instance_priv_struct), NULL)));
	(old_prop_enum == NULL ? NULL : (old_prop_enum = (vala_ccode_node_unref (old_prop_enum), NULL)));
	(old_class_init_fragment == NULL ? NULL : (old_class_init_fragment = (vala_ccode_node_unref (old_class_init_fragment), NULL)));
	(old_instance_init_fragment == NULL ? NULL : (old_instance_init_fragment = (vala_ccode_node_unref (old_instance_init_fragment), NULL)));
	(old_instance_finalize_fragment == NULL ? NULL : (old_instance_finalize_fragment = (vala_ccode_node_unref (old_instance_finalize_fragment), NULL)));
	(decl_frag == NULL ? NULL : (decl_frag = (vala_ccode_node_unref (decl_frag), NULL)));
	(def_frag == NULL ? NULL : (def_frag = (vala_ccode_node_unref (def_frag), NULL)));
}


static void vala_ccode_class_binding_add_type_value_table_init_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeExpressionStatement* _tmp9;
	ValaCCodeAssignment* _tmp8;
	ValaCCodeConstant* _tmp7;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "value_")))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("value", "GValue*")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp9 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE))), VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
}


static void vala_ccode_class_binding_add_type_value_table_free_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeIdentifier* _tmp9;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeFunctionCall* _tmp10;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeBlock* ifbody;
	ValaCCodeExpressionStatement* _tmp11;
	ValaCCodeIfStatement* _tmp12;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_free_value", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "value_")))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("value", "GValue*")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp6 = NULL;
	vpointer = (_tmp6 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp6);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp10 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ((_tmp8 = g_strconcat ((_tmp7 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "unref", NULL)))))), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp10);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vpointer));
	ifbody = vala_ccode_block_new ();
	_tmp11 = NULL;
	vala_ccode_block_add_statement (ifbody, VALA_CCODE_NODE ((_tmp11 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL)));
	_tmp12 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp12 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (vpointer), VALA_CCODE_STATEMENT (ifbody), NULL))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(vpointer == NULL ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(ifbody == NULL ? NULL : (ifbody = (vala_ccode_node_unref (ifbody), NULL)));
}


static void vala_ccode_class_binding_add_type_value_table_copy_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeMemberAccess* dest_vpointer;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeMemberAccess* _tmp10;
	ValaCCodeMemberAccess* src_vpointer;
	ValaCCodeIdentifier* _tmp13;
	char* _tmp12;
	char* _tmp11;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* ref_ccall;
	ValaCCodeBlock* true_stmt;
	ValaCCodeExpressionStatement* _tmp16;
	ValaCCodeAssignment* _tmp15;
	ValaCCodeBlock* false_stmt;
	ValaCCodeExpressionStatement* _tmp19;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeConstant* _tmp17;
	ValaCCodeIfStatement* if_statement;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_copy_value", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "value_")))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("src_value", "const GValue*")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("dest_value", "GValue*")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	dest_vpointer = (_tmp7 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("dest_value"))), "data[0]"))), "v_pointer", FALSE), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), _tmp7);
	_tmp9 = NULL;
	_tmp8 = NULL;
	_tmp10 = NULL;
	src_vpointer = (_tmp10 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("src_value"))), "data[0]"))), "v_pointer", FALSE), (_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), _tmp10);
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp11 = NULL;
	_tmp14 = NULL;
	ref_ccall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ((_tmp12 = g_strconcat ((_tmp11 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "ref", NULL)))))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), (_tmp12 = (g_free (_tmp12), NULL)), (_tmp11 = (g_free (_tmp11), NULL)), _tmp14);
	vala_ccode_function_call_add_argument (ref_ccall, VALA_CCODE_EXPRESSION (src_vpointer));
	true_stmt = vala_ccode_block_new ();
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (dest_vpointer), VALA_CCODE_EXPRESSION (ref_ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	false_stmt = vala_ccode_block_new ();
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp17 = NULL;
	vala_ccode_block_add_statement (false_stmt, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (dest_vpointer), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	if_statement = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (src_vpointer), VALA_CCODE_STATEMENT (true_stmt), VALA_CCODE_STATEMENT (false_stmt));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (if_statement));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(dest_vpointer == NULL ? NULL : (dest_vpointer = (vala_ccode_node_unref (dest_vpointer), NULL)));
	(src_vpointer == NULL ? NULL : (src_vpointer = (vala_ccode_node_unref (src_vpointer), NULL)));
	(ref_ccall == NULL ? NULL : (ref_ccall = (vala_ccode_node_unref (ref_ccall), NULL)));
	(true_stmt == NULL ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL)));
	(false_stmt == NULL ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL)));
	(if_statement == NULL ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL)));
}


static void vala_ccode_class_binding_add_type_value_table_peek_pointer_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeMemberAccess* _tmp5;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeReturnStatement* ret;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_peek_pointer", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "value_")))), "gpointer"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("value", "const GValue*")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp6 = NULL;
	vpointer = (_tmp6 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), (_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL))), _tmp6);
	ret = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vpointer));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (ret));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(vpointer == NULL ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL)));
	(ret == NULL ? NULL : (ret = (vala_ccode_node_unref (ret), NULL)));
}


static void vala_ccode_class_binding_add_type_value_table_lcopy_value_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeMemberAccess* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeIdentifier* object_p_ptr;
	ValaCCodeConstant* null_;
	ValaCCodeBlock* init_block;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeMemberAccess* _tmp14;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeUnaryExpression* _tmp17;
	ValaCCodeUnaryExpression* assert_condition;
	ValaCCodeBlock* assert_true;
	ValaCCodeIfStatement* if_assert;
	ValaCCodeBlock* main_else_true;
	ValaCCodeBlock* main_else_if_true;
	ValaCCodeIdentifier* _tmp19;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeBinaryExpression* _tmp20;
	ValaCCodeBinaryExpression* main_else_if_condition;
	ValaCCodeIfStatement* main_else_if;
	ValaCCodeBlock* main_true;
	ValaCCodeUnaryExpression* main_condition;
	ValaCCodeIfStatement* if_main;
	ValaCCodeIdentifier* _tmp22;
	char* _tmp21;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* ref_fct;
	ValaCCodeExpressionStatement* _tmp25;
	ValaCCodeAssignment* _tmp24;
	ValaCCodeExpressionStatement* _tmp27;
	ValaCCodeAssignment* _tmp26;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeReturnStatement* _tmp30;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_lcopy_value", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "value_")))), "gchar*"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("value", "const GValue*")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("n_collect_values", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp5 = vala_ccode_formal_parameter_new ("collect_values", "GTypeCValue*")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp6 = vala_ccode_formal_parameter_new ("collect_flags", "guint")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	vpointer = (_tmp9 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp9);
	object_p_ptr = vala_ccode_identifier_new ("*object_p");
	null_ = vala_ccode_constant_new ("NULL");
	init_block = vala_ccode_block_new ();
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	ctypedecl = (_tmp12 = vala_ccode_declaration_new ((_tmp11 = g_strconcat ((_tmp10 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "**", NULL))), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp15 = vala_ccode_variable_declarator_new_with_initializer ("object_p", VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("collect_values[0]"))), "v_pointer", FALSE)))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (ctypedecl));
	_tmp16 = NULL;
	_tmp17 = NULL;
	assert_condition = (_tmp17 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("object_p")))), (_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL))), _tmp17);
	vala_ccode_function_set_block (function, init_block);
	assert_true = vala_ccode_block_new ();
	if_assert = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (assert_condition), VALA_CCODE_STATEMENT (assert_true), NULL);
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (if_assert));
	main_else_true = vala_ccode_block_new ();
	main_else_if_true = vala_ccode_block_new ();
	_tmp19 = NULL;
	_tmp18 = NULL;
	_tmp20 = NULL;
	main_else_if_condition = (_tmp20 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_AND, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("collect_flags"))), VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_identifier_new ("G_VALUE_NOCOPY_CONTENTS")))), (_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL))), (_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL))), _tmp20);
	main_else_if = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (main_else_if_condition), VALA_CCODE_STATEMENT (main_else_if_true), VALA_CCODE_STATEMENT (main_else_true));
	main_true = vala_ccode_block_new ();
	main_condition = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION (vpointer));
	if_main = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (main_condition), VALA_CCODE_STATEMENT (main_true), VALA_CCODE_STATEMENT (main_else_if));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (if_main));
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp23 = NULL;
	ref_fct = (_tmp23 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = vala_typesymbol_get_ref_function (VALA_TYPESYMBOL (cl))))))), (_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL))), (_tmp21 = (g_free (_tmp21), NULL)), _tmp23);
	vala_ccode_function_call_add_argument (ref_fct, VALA_CCODE_EXPRESSION (vpointer));
	_tmp25 = NULL;
	_tmp24 = NULL;
	vala_ccode_block_add_statement (main_true, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (object_p_ptr), VALA_CCODE_EXPRESSION (null_), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	_tmp27 = NULL;
	_tmp26 = NULL;
	vala_ccode_block_add_statement (main_else_if_true, VALA_CCODE_NODE ((_tmp27 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (object_p_ptr), VALA_CCODE_EXPRESSION (vpointer), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	_tmp29 = NULL;
	_tmp28 = NULL;
	vala_ccode_block_add_statement (main_else_true, VALA_CCODE_NODE ((_tmp29 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (object_p_ptr), VALA_CCODE_EXPRESSION (ref_fct), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
	_tmp30 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp30 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (null_)))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(vpointer == NULL ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL)));
	(object_p_ptr == NULL ? NULL : (object_p_ptr = (vala_ccode_node_unref (object_p_ptr), NULL)));
	(null_ == NULL ? NULL : (null_ = (vala_ccode_node_unref (null_), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL)));
	(assert_condition == NULL ? NULL : (assert_condition = (vala_ccode_node_unref (assert_condition), NULL)));
	(assert_true == NULL ? NULL : (assert_true = (vala_ccode_node_unref (assert_true), NULL)));
	(if_assert == NULL ? NULL : (if_assert = (vala_ccode_node_unref (if_assert), NULL)));
	(main_else_true == NULL ? NULL : (main_else_true = (vala_ccode_node_unref (main_else_true), NULL)));
	(main_else_if_true == NULL ? NULL : (main_else_if_true = (vala_ccode_node_unref (main_else_if_true), NULL)));
	(main_else_if_condition == NULL ? NULL : (main_else_if_condition = (vala_ccode_node_unref (main_else_if_condition), NULL)));
	(main_else_if == NULL ? NULL : (main_else_if = (vala_ccode_node_unref (main_else_if), NULL)));
	(main_true == NULL ? NULL : (main_true = (vala_ccode_node_unref (main_true), NULL)));
	(main_condition == NULL ? NULL : (main_condition = (vala_ccode_node_unref (main_condition), NULL)));
	(if_main == NULL ? NULL : (if_main = (vala_ccode_node_unref (if_main), NULL)));
	(ref_fct == NULL ? NULL : (ref_fct = (vala_ccode_node_unref (ref_fct), NULL)));
}


static void vala_ccode_class_binding_add_type_value_table_collect_value_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeMemberAccess* _tmp8;
	ValaCCodeIdentifier* _tmp7;
	ValaCCodeMemberAccess* _tmp9;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeMemberAccess* _tmp11;
	ValaCCodeMemberAccess* condition;
	ValaCCodeBlock* true_stmt;
	ValaCCodeBlock* false_stmt;
	ValaCCodeIfStatement* if_statement;
	ValaCCodeIdentifier* obj_identifier;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeDeclaration* _tmp14;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp15;
	ValaCCodeMemberAccess* _tmp16;
	ValaCCodeMemberAccess* _tmp17;
	ValaCCodeMemberAccess* l_expression;
	ValaCCodeConstant* _tmp18;
	ValaCCodeBinaryExpression* _tmp19;
	ValaCCodeBinaryExpression* sub_condition;
	ValaCCodeBlock* sub_true_stmt;
	ValaCCodeBlock* sub_false_stmt;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeFunctionCall* reg_call;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeFunctionCall* _tmp23;
	ValaCCodeFunctionCall* type_check;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeFunctionCall* _tmp26;
	ValaCCodeFunctionCall* stored_type;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeFunctionCall* _tmp29;
	ValaCCodeFunctionCall* type_name_fct;
	ValaCCodeConstant* _tmp30;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeFunctionCall* _tmp32;
	ValaCCodeFunctionCall* true_return;
	ValaCCodeConstant* _tmp33;
	ValaCCodeConstant* _tmp34;
	ValaCCodeConstant* _tmp35;
	ValaCCodeReturnStatement* _tmp36;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeFunctionCall* _tmp38;
	ValaCCodeFunctionCall* false_return;
	ValaCCodeConstant* _tmp39;
	ValaCCodeConstant* _tmp40;
	ValaCCodeConstant* _tmp41;
	ValaCCodeConstant* _tmp42;
	ValaCCodeReturnStatement* _tmp43;
	ValaCCodeUnaryExpression* _tmp44;
	ValaCCodeIfStatement* _tmp45;
	ValaCCodeIfStatement* sub_else_if_statement;
	ValaCCodeIfStatement* sub_if_statement;
	ValaCCodeAssignment* _tmp47;
	ValaCCodeConstant* _tmp46;
	ValaCCodeExpressionStatement* _tmp48;
	ValaCCodeExpressionStatement* else_assigment;
	ValaCCodeReturnStatement* _tmp50;
	ValaCCodeConstant* _tmp49;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_collect_value", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "value_")))), "gchar*"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("value", "GValue*")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("n_collect_values", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp5 = vala_ccode_formal_parameter_new ("collect_values", "GTypeCValue*")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp6 = vala_ccode_formal_parameter_new ("collect_flags", "guint")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	vpointer = (_tmp9 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp9);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp10 = NULL;
	_tmp11 = NULL;
	condition = (_tmp11 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("collect_values[0]"))), "v_pointer", FALSE), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp11);
	true_stmt = vala_ccode_block_new ();
	false_stmt = vala_ccode_block_new ();
	if_statement = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (condition), VALA_CCODE_STATEMENT (true_stmt), VALA_CCODE_STATEMENT (false_stmt));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (if_statement));
	obj_identifier = vala_ccode_identifier_new ("object");
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp14 = NULL;
	ctypedecl = (_tmp14 = vala_ccode_declaration_new ((_tmp13 = g_strconcat ((_tmp12 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp13 = (g_free (_tmp13), NULL)), (_tmp12 = (g_free (_tmp12), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp15 = vala_ccode_variable_declarator_new_with_initializer ("object", VALA_CCODE_EXPRESSION (vpointer)))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE (ctypedecl));
	_tmp16 = NULL;
	_tmp17 = NULL;
	l_expression = (_tmp17 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (obj_identifier), "parent_instance"))), "g_class", FALSE), (_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL))), _tmp17);
	_tmp18 = NULL;
	_tmp19 = NULL;
	sub_condition = (_tmp19 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_EQUALITY, VALA_CCODE_EXPRESSION (l_expression), VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("NULL")))), (_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL))), _tmp19);
	sub_true_stmt = vala_ccode_block_new ();
	sub_false_stmt = vala_ccode_block_new ();
	_tmp20 = NULL;
	_tmp21 = NULL;
	reg_call = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_value_type_compatible")))), (_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL))), _tmp21);
	_tmp22 = NULL;
	_tmp23 = NULL;
	type_check = (_tmp23 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("G_OBJECT_TYPE")))), (_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL))), _tmp23);
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (type_check, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("object"))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION (type_check));
	_tmp25 = NULL;
	_tmp26 = NULL;
	stored_type = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("G_VALUE_TYPE")))), (_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL))), _tmp26);
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (stored_type, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("value"))));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	vala_ccode_function_call_add_argument (reg_call, VALA_CCODE_EXPRESSION (stored_type));
	_tmp28 = NULL;
	_tmp29 = NULL;
	type_name_fct = (_tmp29 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("G_VALUE_TYPE_NAME")))), (_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL))), _tmp29);
	_tmp30 = NULL;
	vala_ccode_function_call_add_argument (type_name_fct, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("value"))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	_tmp31 = NULL;
	_tmp32 = NULL;
	true_return = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("g_strconcat")))), (_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL))), _tmp32);
	_tmp33 = NULL;
	vala_ccode_function_call_add_argument (true_return, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_constant_new ("\"invalid unclassed object pointer for value type `\""))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	vala_ccode_function_call_add_argument (true_return, VALA_CCODE_EXPRESSION (type_name_fct));
	_tmp34 = NULL;
	vala_ccode_function_call_add_argument (true_return, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_constant_new ("\"'\""))));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	_tmp35 = NULL;
	vala_ccode_function_call_add_argument (true_return, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("NULL"))));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	_tmp36 = NULL;
	vala_ccode_block_add_statement (sub_true_stmt, VALA_CCODE_NODE ((_tmp36 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (true_return)))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	_tmp37 = NULL;
	_tmp38 = NULL;
	false_return = (_tmp38 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("g_strconcat")))), (_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL))), _tmp38);
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (false_return, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_constant_new ("\"invalid object type `\""))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
	vala_ccode_function_call_add_argument (false_return, VALA_CCODE_EXPRESSION (type_check));
	_tmp40 = NULL;
	vala_ccode_function_call_add_argument (false_return, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_constant_new ("\"' for value type `\""))));
	(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
	vala_ccode_function_call_add_argument (false_return, VALA_CCODE_EXPRESSION (type_name_fct));
	_tmp41 = NULL;
	vala_ccode_function_call_add_argument (false_return, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("\"'\""))));
	(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
	_tmp42 = NULL;
	vala_ccode_function_call_add_argument (false_return, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ("NULL"))));
	(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	_tmp43 = NULL;
	vala_ccode_block_add_statement (sub_false_stmt, VALA_CCODE_NODE ((_tmp43 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (false_return)))));
	(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
	_tmp44 = NULL;
	_tmp45 = NULL;
	sub_else_if_statement = (_tmp45 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_LOGICAL_NEGATION, VALA_CCODE_EXPRESSION (reg_call)))), VALA_CCODE_STATEMENT (sub_false_stmt), NULL), (_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL))), _tmp45);
	vala_ccode_if_statement_set_else_if (sub_else_if_statement, TRUE);
	sub_if_statement = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION (sub_condition), VALA_CCODE_STATEMENT (sub_true_stmt), VALA_CCODE_STATEMENT (sub_else_if_statement));
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE (sub_if_statement));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp48 = NULL;
	else_assigment = (_tmp48 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vpointer), VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))), (_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL))), (_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL))), _tmp48);
	vala_ccode_block_add_statement (false_stmt, VALA_CCODE_NODE (else_assigment));
	_tmp50 = NULL;
	_tmp49 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp50 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_constant_new ("NULL")))))));
	(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
	(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(vpointer == NULL ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(condition == NULL ? NULL : (condition = (vala_ccode_node_unref (condition), NULL)));
	(true_stmt == NULL ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL)));
	(false_stmt == NULL ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL)));
	(if_statement == NULL ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL)));
	(obj_identifier == NULL ? NULL : (obj_identifier = (vala_ccode_node_unref (obj_identifier), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL)));
	(l_expression == NULL ? NULL : (l_expression = (vala_ccode_node_unref (l_expression), NULL)));
	(sub_condition == NULL ? NULL : (sub_condition = (vala_ccode_node_unref (sub_condition), NULL)));
	(sub_true_stmt == NULL ? NULL : (sub_true_stmt = (vala_ccode_node_unref (sub_true_stmt), NULL)));
	(sub_false_stmt == NULL ? NULL : (sub_false_stmt = (vala_ccode_node_unref (sub_false_stmt), NULL)));
	(reg_call == NULL ? NULL : (reg_call = (vala_ccode_node_unref (reg_call), NULL)));
	(type_check == NULL ? NULL : (type_check = (vala_ccode_node_unref (type_check), NULL)));
	(stored_type == NULL ? NULL : (stored_type = (vala_ccode_node_unref (stored_type), NULL)));
	(type_name_fct == NULL ? NULL : (type_name_fct = (vala_ccode_node_unref (type_name_fct), NULL)));
	(true_return == NULL ? NULL : (true_return = (vala_ccode_node_unref (true_return), NULL)));
	(false_return == NULL ? NULL : (false_return = (vala_ccode_node_unref (false_return), NULL)));
	(sub_else_if_statement == NULL ? NULL : (sub_else_if_statement = (vala_ccode_node_unref (sub_else_if_statement), NULL)));
	(sub_if_statement == NULL ? NULL : (sub_if_statement = (vala_ccode_node_unref (sub_if_statement), NULL)));
	(else_assigment == NULL ? NULL : (else_assigment = (vala_ccode_node_unref (else_assigment), NULL)));
}


static void vala_ccode_class_binding_add_g_param_spec_type_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* function_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp0;
	ValaCCodeFormalParameter* _tmp1;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeBlock* init_block;
	char* _tmp8;
	char* _tmp7;
	ValaCCodeDeclaration* _tmp9;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp10;
	ValaCCodeIdentifier* _tmp11;
	ValaCCodeFunctionCall* _tmp12;
	ValaCCodeFunctionCall* subccall;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeFunctionCall* _tmp17;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeExpressionStatement* _tmp19;
	ValaCCodeFunctionCall* _tmp21;
	ValaCCodeIdentifier* _tmp20;
	ValaCCodeIdentifier* _tmp22;
	ValaCCodeIdentifier* _tmp23;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeExpressionStatement* _tmp29;
	ValaCCodeAssignment* _tmp28;
	ValaCCodeIdentifier* _tmp27;
	ValaCCodeFunctionCall* _tmp31;
	ValaCCodeIdentifier* _tmp30;
	ValaCCodeIdentifier* _tmp32;
	ValaCCodeExpressionStatement* _tmp36;
	ValaCCodeAssignment* _tmp35;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeMemberAccess* _tmp33;
	ValaCCodeReturnStatement* _tmp37;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	function_name = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), "param_spec_");
	function = vala_ccode_function_new (function_name, "GParamSpec*");
	_tmp0 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp0 = vala_ccode_formal_parameter_new ("name", "const gchar*")));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp1 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp1 = vala_ccode_formal_parameter_new ("nick", "const gchar*")));
	(_tmp1 == NULL ? NULL : (_tmp1 = (vala_ccode_node_unref (_tmp1), NULL)));
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp2 = vala_ccode_formal_parameter_new ("blurb", "const gchar*")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("object_type", "GType")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("flags", "GParamFlags")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	vala_class_set_param_spec_function (cl, function_name);
	if (vala_symbol_get_access (VALA_SYMBOL (cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp5;
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp5 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp5 = vala_ccode_function_copy (function))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	} else {
		ValaCCodeFunction* _tmp6;
		_tmp6 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp6 = vala_ccode_function_copy (function))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	}
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	ctypedecl = (_tmp9 = vala_ccode_declaration_new ((_tmp8 = g_strdup_printf ("%sParamSpec%s*", (_tmp7 = vala_symbol_get_cprefix (vala_symbol_get_parent_symbol (VALA_SYMBOL (cl)))), vala_symbol_get_name (VALA_SYMBOL (cl))))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp10 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp10 = vala_ccode_variable_declarator_new ("spec"))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (ctypedecl));
	_tmp11 = NULL;
	_tmp12 = NULL;
	subccall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ("g_type_is_a")))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), _tmp12);
	_tmp13 = NULL;
	vala_ccode_function_call_add_argument (subccall, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("object_type"))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	vala_ccode_function_call_add_argument (subccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	_tmp14 = (g_free (_tmp14), NULL);
	_tmp16 = NULL;
	_tmp17 = NULL;
	ccall = (_tmp17 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("g_return_val_if_fail")))), (_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL))), _tmp17);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (subccall));
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("NULL"))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp21 = NULL;
	_tmp20 = NULL;
	ccall = (_tmp21 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_param_spec_internal")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp21);
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	_tmp22 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ("G_TYPE_PARAM_OBJECT"))));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	_tmp23 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new ("name"))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	_tmp24 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("nick"))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	_tmp25 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("blurb"))));
	(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
	_tmp26 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("flags"))));
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	_tmp29 = NULL;
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp29 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("spec"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
	(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
	_tmp31 = NULL;
	_tmp30 = NULL;
	ccall = (_tmp31 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ("G_PARAM_SPEC")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp31);
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	_tmp32 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("spec"))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
	_tmp36 = NULL;
	_tmp35 = NULL;
	_tmp34 = NULL;
	_tmp33 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp36 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "value_type"))), VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("object_type"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	_tmp37 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp37 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	function_name = (g_free (function_name), NULL);
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL)));
	(subccall == NULL ? NULL : (subccall = (vala_ccode_node_unref (subccall), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
}


static void vala_ccode_class_binding_add_g_value_set_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeIdentifier* _tmp6;
	ValaCCodeMemberAccess* _tmp8;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* ctypedecl;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* ccall_typecheck;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeIdentifier* _tmp17;
	char* _tmp16;
	ValaCCodeIdentifier* _tmp18;
	ValaCCodeFunctionCall* _tmp19;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeExpressionStatement* _tmp20;
	ValaCCodeExpressionStatement* _tmp23;
	ValaCCodeAssignment* _tmp22;
	ValaCCodeConstant* _tmp21;
	ValaCCodeBlock* true_stmt;
	ValaCCodeBlock* false_stmt;
	ValaCCodeIdentifier* _tmp24;
	ValaCCodeIfStatement* _tmp25;
	ValaCCodeIfStatement* if_statement;
	ValaCCodeFunctionCall* _tmp27;
	ValaCCodeIdentifier* _tmp26;
	ValaCCodeIdentifier* _tmp28;
	ValaCCodeIdentifier* _tmp30;
	char* _tmp29;
	ValaCCodeFunctionCall* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeIdentifier* _tmp34;
	ValaCCodeFunctionCall* _tmp35;
	ValaCCodeFunctionCall* ccall_typefrominstance;
	ValaCCodeIdentifier* _tmp36;
	ValaCCodeIdentifier* _tmp37;
	ValaCCodeFunctionCall* _tmp38;
	ValaCCodeFunctionCall* ccall_gvaluetype;
	ValaCCodeIdentifier* _tmp39;
	ValaCCodeIdentifier* _tmp40;
	ValaCCodeFunctionCall* _tmp41;
	ValaCCodeFunctionCall* ccall_typecompatible;
	ValaCCodeFunctionCall* _tmp43;
	ValaCCodeIdentifier* _tmp42;
	ValaCCodeExpressionStatement* _tmp44;
	ValaCCodeExpressionStatement* _tmp47;
	ValaCCodeAssignment* _tmp46;
	ValaCCodeConstant* _tmp45;
	ValaCCodeFunctionCall* _tmp50;
	ValaCCodeIdentifier* _tmp49;
	char* _tmp48;
	ValaCCodeExpressionStatement* _tmp51;
	ValaCCodeExpressionStatement* _tmp54;
	ValaCCodeAssignment* _tmp53;
	ValaCCodeConstant* _tmp52;
	ValaCCodeBlock* _tmp55;
	ValaCCodeIfStatement* _tmp57;
	ValaCCodeIdentifier* _tmp56;
	ValaCCodeFunctionCall* _tmp60;
	ValaCCodeIdentifier* _tmp59;
	char* _tmp58;
	ValaCCodeIdentifier* _tmp61;
	ValaCCodeExpressionStatement* _tmp62;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new ((_tmp0 = vala_typesymbol_get_set_value_function (VALA_TYPESYMBOL (cl))), "void"), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp2 = vala_ccode_formal_parameter_new ("value", "GValue*")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp3 = vala_ccode_formal_parameter_new ("v_object", "gpointer")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	if (vala_symbol_get_access (VALA_SYMBOL (cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp4;
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp4 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp4 = vala_ccode_function_copy (function))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	} else {
		ValaCCodeFunction* _tmp5;
		_tmp5 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp5 = vala_ccode_function_copy (function))));
		(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	}
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	vpointer = (_tmp8 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), _tmp8);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	ctypedecl = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strconcat ((_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)), "*", NULL))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (ctypedecl, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new ("old"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (ctypedecl));
	_tmp13 = NULL;
	_tmp14 = NULL;
	ccall_typecheck = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("G_TYPE_CHECK_VALUE_TYPE")))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("value"))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	_tmp17 = NULL;
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ((_tmp16 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp18 = NULL;
	_tmp19 = NULL;
	ccall = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ("g_return_if_fail")))), (_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL))), _tmp19);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccall_typecheck));
	_tmp20 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp20 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp23 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("old"))), VALA_CCODE_EXPRESSION (vpointer), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
	(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
	true_stmt = vala_ccode_block_new ();
	false_stmt = vala_ccode_block_new ();
	_tmp24 = NULL;
	_tmp25 = NULL;
	if_statement = (_tmp25 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_identifier_new ("v_object"))), VALA_CCODE_STATEMENT (true_stmt), VALA_CCODE_STATEMENT (false_stmt)), (_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL))), _tmp25);
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (if_statement));
	_tmp27 = NULL;
	_tmp26 = NULL;
	ccall_typecheck = (_tmp27 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ("G_TYPE_CHECK_INSTANCE_TYPE")))), (ccall_typecheck == NULL ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL))), _tmp27);
	(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
	_tmp28 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("v_object"))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_identifier_new ((_tmp29 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp32 = NULL;
	_tmp31 = NULL;
	ccall = (_tmp32 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ("g_return_if_fail")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp32);
	(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccall_typecheck));
	_tmp33 = NULL;
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	_tmp34 = NULL;
	_tmp35 = NULL;
	ccall_typefrominstance = (_tmp35 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("G_TYPE_FROM_INSTANCE")))), (_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL))), _tmp35);
	_tmp36 = NULL;
	vala_ccode_function_call_add_argument (ccall_typefrominstance, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("v_object"))));
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	_tmp37 = NULL;
	_tmp38 = NULL;
	ccall_gvaluetype = (_tmp38 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_identifier_new ("G_VALUE_TYPE")))), (_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL))), _tmp38);
	_tmp39 = NULL;
	vala_ccode_function_call_add_argument (ccall_gvaluetype, VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_identifier_new ("value"))));
	(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
	_tmp40 = NULL;
	_tmp41 = NULL;
	ccall_typecompatible = (_tmp41 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("g_value_type_compatible")))), (_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL))), _tmp41);
	vala_ccode_function_call_add_argument (ccall_typecompatible, VALA_CCODE_EXPRESSION (ccall_typefrominstance));
	vala_ccode_function_call_add_argument (ccall_typecompatible, VALA_CCODE_EXPRESSION (ccall_gvaluetype));
	_tmp43 = NULL;
	_tmp42 = NULL;
	ccall = (_tmp43 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_identifier_new ("g_return_if_fail")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp43);
	(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccall_typecompatible));
	_tmp44 = NULL;
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE ((_tmp44 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
	_tmp47 = NULL;
	_tmp46 = NULL;
	_tmp45 = NULL;
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE ((_tmp47 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vpointer), VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_constant_new ("v_object"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
	(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
	(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
	_tmp50 = NULL;
	_tmp49 = NULL;
	_tmp48 = NULL;
	ccall = (_tmp50 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ((_tmp48 = vala_typesymbol_get_ref_function (VALA_TYPESYMBOL (cl))))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp50);
	(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
	_tmp48 = (g_free (_tmp48), NULL);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (vpointer));
	_tmp51 = NULL;
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE ((_tmp51 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
	_tmp54 = NULL;
	_tmp53 = NULL;
	_tmp52 = NULL;
	vala_ccode_block_add_statement (false_stmt, VALA_CCODE_NODE ((_tmp54 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (vpointer), VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_constant_new ("NULL"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
	(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
	(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
	(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
	_tmp55 = NULL;
	true_stmt = (_tmp55 = vala_ccode_block_new (), (true_stmt == NULL ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL))), _tmp55);
	_tmp57 = NULL;
	_tmp56 = NULL;
	if_statement = (_tmp57 = vala_ccode_if_statement_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_identifier_new ("old"))), VALA_CCODE_STATEMENT (true_stmt), NULL), (if_statement == NULL ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL))), _tmp57);
	(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (if_statement));
	_tmp60 = NULL;
	_tmp59 = NULL;
	_tmp58 = NULL;
	ccall = (_tmp60 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ((_tmp58 = vala_typesymbol_get_unref_function (VALA_TYPESYMBOL (cl))))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp60);
	(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
	_tmp58 = (g_free (_tmp58), NULL);
	_tmp61 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_identifier_new ("old"))));
	(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
	_tmp62 = NULL;
	vala_ccode_block_add_statement (true_stmt, VALA_CCODE_NODE ((_tmp62 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(vpointer == NULL ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(ctypedecl == NULL ? NULL : (ctypedecl = (vala_ccode_node_unref (ctypedecl), NULL)));
	(ccall_typecheck == NULL ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(true_stmt == NULL ? NULL : (true_stmt = (vala_ccode_node_unref (true_stmt), NULL)));
	(false_stmt == NULL ? NULL : (false_stmt = (vala_ccode_node_unref (false_stmt), NULL)));
	(if_statement == NULL ? NULL : (if_statement = (vala_ccode_node_unref (if_statement), NULL)));
	(ccall_typefrominstance == NULL ? NULL : (ccall_typefrominstance = (vala_ccode_node_unref (ccall_typefrominstance), NULL)));
	(ccall_gvaluetype == NULL ? NULL : (ccall_gvaluetype = (vala_ccode_node_unref (ccall_gvaluetype), NULL)));
	(ccall_typecompatible == NULL ? NULL : (ccall_typecompatible = (vala_ccode_node_unref (ccall_typecompatible), NULL)));
}


static void vala_ccode_class_binding_add_g_value_get_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp0;
	ValaCCodeFunction* _tmp1;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp2;
	ValaCCodeMemberAccess* _tmp6;
	ValaCCodeIdentifier* _tmp5;
	ValaCCodeMemberAccess* _tmp7;
	ValaCCodeMemberAccess* vpointer;
	ValaCCodeBlock* init_block;
	ValaCCodeIdentifier* _tmp8;
	ValaCCodeFunctionCall* _tmp9;
	ValaCCodeFunctionCall* ccall_typecheck;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	char* _tmp11;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeFunctionCall* _tmp14;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp15;
	ValaCCodeExpressionStatement* _tmp16;
	ValaCCodeReturnStatement* _tmp17;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp0 = NULL;
	_tmp1 = NULL;
	function = (_tmp1 = vala_ccode_function_new ((_tmp0 = vala_typesymbol_get_get_value_function (VALA_TYPESYMBOL (cl))), "gpointer"), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp2 = vala_ccode_formal_parameter_new ("value", "const GValue*")));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	if (vala_symbol_get_access (VALA_SYMBOL (cl)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaCCodeFunction* _tmp3;
		vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
		_tmp3 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp3 = vala_ccode_function_copy (function))));
		(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	} else {
		ValaCCodeFunction* _tmp4;
		_tmp4 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->header_type_member_declaration, VALA_CCODE_NODE ((_tmp4 = vala_ccode_function_copy (function))));
		(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	}
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp7 = NULL;
	vpointer = (_tmp7 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("value"))), "data[0]"))), "v_pointer", FALSE), (_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL))), (_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL))), _tmp7);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (function, init_block);
	_tmp8 = NULL;
	_tmp9 = NULL;
	ccall_typecheck = (_tmp9 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ("G_TYPE_CHECK_VALUE_TYPE")))), (_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL))), _tmp9);
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("value"))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	_tmp11 = NULL;
	vala_ccode_function_call_add_argument (ccall_typecheck, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ((_tmp11 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (cl)))))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp11 = (g_free (_tmp11), NULL);
	_tmp13 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp14 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_return_val_if_fail")))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (ccall_typecheck));
	_tmp15 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ("NULL"))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	_tmp16 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp16 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (vpointer)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(vpointer == NULL ? NULL : (vpointer = (vala_ccode_node_unref (vpointer), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(ccall_typecheck == NULL ? NULL : (ccall_typecheck = (vala_ccode_node_unref (ccall_typecheck), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
}


static void vala_ccode_class_binding_add_class_init_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* class_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeDeclaration* parent_decl;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeVariableDeclarator* _tmp8;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp9;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeIdentifier* _tmp12;
	ValaCCodeIdentifier* _tmp15;
	char* _tmp14;
	char* _tmp13;
	ValaCCodeAssignment* _tmp16;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp17;
	GeeList* _tmp18;
	gboolean _tmp19;
	GeeList* _tmp34;
	gboolean _tmp35;
	ValaCCodeFragment* _tmp193;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	class_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_class_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (class_init, (_tmp5 = vala_ccode_formal_parameter_new ("klass", (_tmp4 = g_strdup_printf ("%sClass *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (class_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (class_init, init_block);
	ccall = NULL;
	/* save pointer to parent class */
	parent_decl = vala_ccode_declaration_new ("gpointer");
	_tmp7 = NULL;
	_tmp6 = NULL;
	_tmp8 = NULL;
	parent_var_decl = (_tmp8 = vala_ccode_variable_declarator_new ((_tmp7 = g_strdup_printf ("%s_parent_class", (_tmp6 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))), (_tmp7 = (g_free (_tmp7), NULL)), (_tmp6 = (g_free (_tmp6), NULL)), _tmp8);
	_tmp9 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp11 = NULL;
	_tmp10 = NULL;
	ccall = (_tmp11 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("g_type_class_peek_parent")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp11);
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp12 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp12 = vala_ccode_identifier_new ("klass"))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	_tmp15 = NULL;
	_tmp14 = NULL;
	_tmp13 = NULL;
	_tmp16 = NULL;
	parent_assignment = (_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_identifier_new ((_tmp14 = g_strdup_printf ("%s_parent_class", (_tmp13 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL))), (_tmp14 = (g_free (_tmp14), NULL)), (_tmp13 = (g_free (_tmp13), NULL)), _tmp16);
	_tmp17 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	_tmp18 = NULL;
	if ((_tmp19 = !vala_class_get_is_compact (cl) && !vala_class_get_is_static (cl) && !vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type) && (gee_collection_get_size (GEE_COLLECTION ((_tmp18 = vala_class_get_fields (cl)))) > 0 || vala_class_get_destructor (cl) != NULL || vala_class_is_fundamental (cl)), (_tmp18 == NULL ? NULL : (_tmp18 = (gee_collection_object_unref (_tmp18), NULL))), _tmp19)) {
		ValaClass* _tmp20;
		ValaClass* fundamental_class;
		ValaCCodeFunctionCall* _tmp26;
		ValaCCodeIdentifier* _tmp25;
		char* _tmp24;
		char* _tmp23;
		ValaCCodeIdentifier* _tmp27;
		ValaCCodeIdentifier* _tmp31;
		char* _tmp30;
		char* _tmp29;
		ValaCCodeMemberAccess* _tmp28;
		ValaCCodeAssignment* _tmp32;
		ValaCCodeAssignment* finalize_assignment;
		ValaCCodeExpressionStatement* _tmp33;
		/* set finalize function*/
		_tmp20 = NULL;
		fundamental_class = (_tmp20 = cl, (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
		while (vala_class_get_base_class (fundamental_class) != NULL) {
			ValaClass* _tmp22;
			ValaClass* _tmp21;
			_tmp22 = NULL;
			_tmp21 = NULL;
			fundamental_class = (_tmp22 = (_tmp21 = vala_class_get_base_class (fundamental_class), (_tmp21 == NULL ? NULL : vala_code_node_ref (_tmp21))), (fundamental_class == NULL ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL))), _tmp22);
		}
		_tmp26 = NULL;
		_tmp25 = NULL;
		_tmp24 = NULL;
		_tmp23 = NULL;
		ccall = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ((_tmp24 = g_strdup_printf ("%s_CLASS", (_tmp23 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (fundamental_class), NULL)))))))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp26);
		(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
		_tmp24 = (g_free (_tmp24), NULL);
		_tmp23 = (g_free (_tmp23), NULL);
		_tmp27 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp27 = vala_ccode_identifier_new ("klass"))));
		(_tmp27 == NULL ? NULL : (_tmp27 = (vala_ccode_node_unref (_tmp27), NULL)));
		_tmp31 = NULL;
		_tmp30 = NULL;
		_tmp29 = NULL;
		_tmp28 = NULL;
		_tmp32 = NULL;
		finalize_assignment = (_tmp32 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "finalize"))), VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ((_tmp30 = g_strconcat ((_tmp29 = vala_symbol_get_lower_case_cprefix (VALA_SYMBOL (cl))), "finalize", NULL))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL))), (_tmp30 = (g_free (_tmp30), NULL)), (_tmp29 = (g_free (_tmp29), NULL)), (_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL))), _tmp32);
		_tmp33 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (finalize_assignment)))));
		(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
		(fundamental_class == NULL ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL)));
		(finalize_assignment == NULL ? NULL : (finalize_assignment = (vala_ccode_node_unref (finalize_assignment), NULL)));
	}
	/* add struct for private fields */
	_tmp34 = NULL;
	if ((_tmp35 = vala_class_get_has_private_fields (cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp34 = vala_class_get_type_parameters (cl)))) > 0, (_tmp34 == NULL ? NULL : (_tmp34 = (gee_collection_object_unref (_tmp34), NULL))), _tmp35)) {
		ValaCCodeFunctionCall* _tmp37;
		ValaCCodeIdentifier* _tmp36;
		ValaCCodeIdentifier* _tmp38;
		ValaCCodeConstant* _tmp41;
		char* _tmp40;
		char* _tmp39;
		ValaCCodeExpressionStatement* _tmp42;
		_tmp37 = NULL;
		_tmp36 = NULL;
		ccall = (_tmp37 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_identifier_new ("g_type_class_add_private")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp37);
		(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
		_tmp38 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ("klass"))));
		(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
		_tmp41 = NULL;
		_tmp40 = NULL;
		_tmp39 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ((_tmp40 = g_strdup_printf ("sizeof (%sPrivate)", (_tmp39 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))))));
		(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
		_tmp40 = (g_free (_tmp40), NULL);
		_tmp39 = (g_free (_tmp39), NULL);
		_tmp42 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp42 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
	}
	if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		ValaCCodeFunctionCall* _tmp44;
		ValaCCodeIdentifier* _tmp43;
		ValaCCodeIdentifier* _tmp45;
		GeeList* _tmp46;
		gboolean _tmp47;
		GeeList* _tmp54;
		gboolean _tmp55;
		GeeList* _tmp71;
		gboolean _tmp72;
		/* set property handlers */
		_tmp44 = NULL;
		_tmp43 = NULL;
		ccall = (_tmp44 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp44);
		(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
		_tmp45 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp45 = vala_ccode_identifier_new ("klass"))));
		(_tmp45 == NULL ? NULL : (_tmp45 = (vala_ccode_node_unref (_tmp45), NULL)));
		_tmp46 = NULL;
		if ((_tmp47 = vala_ccode_class_binding_class_has_readable_properties (self, cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp46 = vala_class_get_type_parameters (cl)))) > 0, (_tmp46 == NULL ? NULL : (_tmp46 = (gee_collection_object_unref (_tmp46), NULL))), _tmp47)) {
			ValaCCodeExpressionStatement* _tmp53;
			ValaCCodeAssignment* _tmp52;
			ValaCCodeIdentifier* _tmp51;
			char* _tmp50;
			char* _tmp49;
			ValaCCodeMemberAccess* _tmp48;
			_tmp53 = NULL;
			_tmp52 = NULL;
			_tmp51 = NULL;
			_tmp50 = NULL;
			_tmp49 = NULL;
			_tmp48 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp53 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "get_property"))), VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ((_tmp50 = g_strdup_printf ("%s_get_property", (_tmp49 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
			(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
			(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
			_tmp50 = (g_free (_tmp50), NULL);
			_tmp49 = (g_free (_tmp49), NULL);
			(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
		}
		_tmp54 = NULL;
		if ((_tmp55 = vala_ccode_class_binding_class_has_writable_properties (self, cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp54 = vala_class_get_type_parameters (cl)))) > 0, (_tmp54 == NULL ? NULL : (_tmp54 = (gee_collection_object_unref (_tmp54), NULL))), _tmp55)) {
			ValaCCodeExpressionStatement* _tmp61;
			ValaCCodeAssignment* _tmp60;
			ValaCCodeIdentifier* _tmp59;
			char* _tmp58;
			char* _tmp57;
			ValaCCodeMemberAccess* _tmp56;
			_tmp61 = NULL;
			_tmp60 = NULL;
			_tmp59 = NULL;
			_tmp58 = NULL;
			_tmp57 = NULL;
			_tmp56 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp61 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccall), "set_property"))), VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_identifier_new ((_tmp58 = g_strdup_printf ("%s_set_property", (_tmp57 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
			(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
			(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
			_tmp58 = (g_free (_tmp58), NULL);
			_tmp57 = (g_free (_tmp57), NULL);
			(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
		}
		/* set constructor */
		if (vala_class_get_constructor (cl) != NULL) {
			ValaCCodeIdentifier* _tmp62;
			ValaCCodeFunctionCall* _tmp63;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp64;
			ValaCCodeExpressionStatement* _tmp70;
			ValaCCodeAssignment* _tmp69;
			ValaCCodeIdentifier* _tmp68;
			char* _tmp67;
			char* _tmp66;
			ValaCCodeMemberAccess* _tmp65;
			_tmp62 = NULL;
			_tmp63 = NULL;
			ccast = (_tmp63 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL))), _tmp63);
			_tmp64 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new ("klass"))));
			(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
			_tmp70 = NULL;
			_tmp69 = NULL;
			_tmp68 = NULL;
			_tmp67 = NULL;
			_tmp66 = NULL;
			_tmp65 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp70 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "constructor"))), VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ((_tmp67 = g_strdup_printf ("%s_constructor", (_tmp66 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
			(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
			(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
			_tmp67 = (g_free (_tmp67), NULL);
			_tmp66 = (g_free (_tmp66), NULL);
			(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
			(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
		}
		/* set finalize function */
		_tmp71 = NULL;
		if ((_tmp72 = gee_collection_get_size (GEE_COLLECTION ((_tmp71 = vala_class_get_fields (cl)))) > 0 || vala_class_get_destructor (cl) != NULL, (_tmp71 == NULL ? NULL : (_tmp71 = (gee_collection_object_unref (_tmp71), NULL))), _tmp72)) {
			ValaCCodeIdentifier* _tmp73;
			ValaCCodeFunctionCall* _tmp74;
			ValaCCodeFunctionCall* ccast;
			ValaCCodeIdentifier* _tmp75;
			ValaCCodeExpressionStatement* _tmp81;
			ValaCCodeAssignment* _tmp80;
			ValaCCodeIdentifier* _tmp79;
			char* _tmp78;
			char* _tmp77;
			ValaCCodeMemberAccess* _tmp76;
			_tmp73 = NULL;
			_tmp74 = NULL;
			ccast = (_tmp74 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ("G_OBJECT_CLASS")))), (_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL))), _tmp74);
			_tmp75 = NULL;
			vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_identifier_new ("klass"))));
			(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
			_tmp81 = NULL;
			_tmp80 = NULL;
			_tmp79 = NULL;
			_tmp78 = NULL;
			_tmp77 = NULL;
			_tmp76 = NULL;
			vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp81 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "finalize"))), VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ((_tmp78 = g_strdup_printf ("%s_finalize", (_tmp77 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
			(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
			(_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)));
			(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
			_tmp78 = (g_free (_tmp78), NULL);
			_tmp77 = (g_free (_tmp77), NULL);
			(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
			(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
		}
	}
	/* connect overridden methods */
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				ValaSymbol* _tmp82;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* _tmp85;
				char* _tmp84;
				char* _tmp83;
				ValaCCodeFunctionCall* _tmp86;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* _tmp87;
				ValaCCodeExpressionStatement* _tmp92;
				ValaCCodeAssignment* _tmp91;
				ValaCCodeIdentifier* _tmp90;
				char* _tmp89;
				ValaCCodeMemberAccess* _tmp88;
				if (vala_method_get_base_method (m) == NULL) {
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					continue;
				}
				_tmp82 = NULL;
				base_type = (_tmp82 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_method (m))), (_tmp82 == NULL ? NULL : vala_code_node_ref (_tmp82)));
				_tmp85 = NULL;
				_tmp84 = NULL;
				_tmp83 = NULL;
				_tmp86 = NULL;
				ccast = (_tmp86 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_identifier_new ((_tmp84 = g_strdup_printf ("%s_CLASS", (_tmp83 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL ((VALA_CLASS (base_type))), NULL)))))))), (_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL))), (_tmp84 = (g_free (_tmp84), NULL)), (_tmp83 = (g_free (_tmp83), NULL)), _tmp86);
				_tmp87 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_identifier_new ("klass"))));
				(_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)));
				_tmp92 = NULL;
				_tmp91 = NULL;
				_tmp90 = NULL;
				_tmp89 = NULL;
				_tmp88 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp92 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), vala_method_get_vfunc_name (vala_method_get_base_method (m))))), VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_identifier_new ((_tmp89 = vala_method_get_real_cname (m))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp92 == NULL ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)));
				(_tmp91 == NULL ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL)));
				(_tmp90 == NULL ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)));
				_tmp89 = (g_free (_tmp89), NULL);
				(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	/* connect overridden properties */
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				ValaSymbol* _tmp93;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* _tmp96;
				char* _tmp95;
				char* _tmp94;
				ValaCCodeFunctionCall* _tmp97;
				ValaCCodeFunctionCall* ccast;
				ValaCCodeIdentifier* _tmp98;
				if (vala_property_get_base_property (prop) == NULL) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				_tmp93 = NULL;
				base_type = (_tmp93 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_property_get_base_property (prop))), (_tmp93 == NULL ? NULL : vala_code_node_ref (_tmp93)));
				_tmp96 = NULL;
				_tmp95 = NULL;
				_tmp94 = NULL;
				_tmp97 = NULL;
				ccast = (_tmp97 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new ((_tmp95 = g_strdup_printf ("%s_CLASS", (_tmp94 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL ((VALA_CLASS (base_type))), NULL)))))))), (_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL))), (_tmp95 = (g_free (_tmp95), NULL)), (_tmp94 = (g_free (_tmp94), NULL)), _tmp97);
				_tmp98 = NULL;
				vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp98 = vala_ccode_identifier_new ("klass"))));
				(_tmp98 == NULL ? NULL : (_tmp98 = (vala_ccode_node_unref (_tmp98), NULL)));
				if (vala_property_get_get_accessor (prop) != NULL) {
					char* _tmp99;
					char* _tmp100;
					char* cname;
					ValaCCodeExpressionStatement* _tmp105;
					ValaCCodeAssignment* _tmp104;
					ValaCCodeIdentifier* _tmp103;
					ValaCCodeMemberAccess* _tmp102;
					char* _tmp101;
					_tmp99 = NULL;
					_tmp100 = NULL;
					cname = (_tmp100 = g_strdup_printf ("%s_real_get_%s", (_tmp99 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop))), (_tmp99 = (g_free (_tmp99), NULL)), _tmp100);
					_tmp105 = NULL;
					_tmp104 = NULL;
					_tmp103 = NULL;
					_tmp102 = NULL;
					_tmp101 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp105 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp104 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), (_tmp101 = g_strdup_printf ("get_%s", vala_symbol_get_name (VALA_SYMBOL (prop))))))), VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
					(_tmp104 == NULL ? NULL : (_tmp104 = (vala_ccode_node_unref (_tmp104), NULL)));
					(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
					(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
					_tmp101 = (g_free (_tmp101), NULL);
					cname = (g_free (cname), NULL);
				}
				if (vala_property_get_set_accessor (prop) != NULL) {
					char* _tmp106;
					char* _tmp107;
					char* cname;
					ValaCCodeExpressionStatement* _tmp112;
					ValaCCodeAssignment* _tmp111;
					ValaCCodeIdentifier* _tmp110;
					ValaCCodeMemberAccess* _tmp109;
					char* _tmp108;
					_tmp106 = NULL;
					_tmp107 = NULL;
					cname = (_tmp107 = g_strdup_printf ("%s_real_set_%s", (_tmp106 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop))), (_tmp106 = (g_free (_tmp106), NULL)), _tmp107);
					_tmp112 = NULL;
					_tmp111 = NULL;
					_tmp110 = NULL;
					_tmp109 = NULL;
					_tmp108 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp112 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp109 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), (_tmp108 = g_strdup_printf ("set_%s", vala_symbol_get_name (VALA_SYMBOL (prop))))))), VALA_CCODE_EXPRESSION ((_tmp110 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp112 == NULL ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL)));
					(_tmp111 == NULL ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL)));
					(_tmp110 == NULL ? NULL : (_tmp110 = (vala_ccode_node_unref (_tmp110), NULL)));
					(_tmp109 == NULL ? NULL : (_tmp109 = (vala_ccode_node_unref (_tmp109), NULL)));
					_tmp108 = (g_free (_tmp108), NULL);
					cname = (g_free (cname), NULL);
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
	}
	if (vala_typesymbol_is_subtype_of (VALA_TYPESYMBOL (cl), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gobject_type)) {
		GeeList* fields;
		GeeList* props;
		/* create type, dup_func, and destroy_func properties for generic types */
		{
			GeeList* type_param_collection;
			int type_param_it;
			type_param_collection = vala_class_get_type_parameters (cl);
			for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
				ValaTypeParameter* type_param;
				type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
				{
					char* func_name;
					char* enum_value;
					ValaCCodeConstant* func_name_constant;
					ValaCCodeFunctionCall* cinst;
					ValaCCodeFunctionCall* cspec;
					char* _tmp114;
					char* _tmp113;
					ValaCCodeConstant* _tmp117;
					char* _tmp116;
					char* _tmp115;
					char* _tmp120;
					char* _tmp119;
					char* _tmp118;
					ValaCCodeFunctionCall* _tmp122;
					ValaCCodeIdentifier* _tmp121;
					ValaCCodeConstant* _tmp123;
					ValaCCodeFunctionCall* _tmp125;
					ValaCCodeIdentifier* _tmp124;
					ValaCCodeConstant* _tmp126;
					ValaCCodeConstant* _tmp127;
					ValaCCodeIdentifier* _tmp128;
					ValaCCodeConstant* _tmp129;
					ValaCCodeExpressionStatement* _tmp130;
					ValaCCodeEnumValue* _tmp131;
					char* _tmp133;
					char* _tmp132;
					ValaCCodeConstant* _tmp136;
					char* _tmp135;
					char* _tmp134;
					char* _tmp139;
					char* _tmp138;
					char* _tmp137;
					ValaCCodeFunctionCall* _tmp141;
					ValaCCodeIdentifier* _tmp140;
					ValaCCodeConstant* _tmp142;
					ValaCCodeFunctionCall* _tmp144;
					ValaCCodeIdentifier* _tmp143;
					ValaCCodeConstant* _tmp145;
					ValaCCodeConstant* _tmp146;
					ValaCCodeConstant* _tmp147;
					ValaCCodeExpressionStatement* _tmp148;
					ValaCCodeEnumValue* _tmp149;
					char* _tmp151;
					char* _tmp150;
					ValaCCodeConstant* _tmp154;
					char* _tmp153;
					char* _tmp152;
					char* _tmp157;
					char* _tmp156;
					char* _tmp155;
					ValaCCodeFunctionCall* _tmp159;
					ValaCCodeIdentifier* _tmp158;
					ValaCCodeConstant* _tmp160;
					ValaCCodeFunctionCall* _tmp162;
					ValaCCodeIdentifier* _tmp161;
					ValaCCodeConstant* _tmp163;
					ValaCCodeConstant* _tmp164;
					ValaCCodeConstant* _tmp165;
					ValaCCodeExpressionStatement* _tmp166;
					ValaCCodeEnumValue* _tmp167;
					func_name = NULL;
					enum_value = NULL;
					func_name_constant = NULL;
					cinst = NULL;
					cspec = NULL;
					_tmp114 = NULL;
					_tmp113 = NULL;
					func_name = (_tmp114 = g_strdup_printf ("%s_type", (_tmp113 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp114);
					_tmp113 = (g_free (_tmp113), NULL);
					_tmp117 = NULL;
					_tmp116 = NULL;
					_tmp115 = NULL;
					func_name_constant = (_tmp117 = vala_ccode_constant_new ((_tmp116 = g_strdup_printf ("\"%s-type\"", (_tmp115 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL))), _tmp117);
					_tmp116 = (g_free (_tmp116), NULL);
					_tmp115 = (g_free (_tmp115), NULL);
					_tmp120 = NULL;
					_tmp119 = NULL;
					_tmp118 = NULL;
					enum_value = (_tmp120 = g_utf8_strup ((_tmp119 = g_strdup_printf ("%s_%s", (_tmp118 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp120);
					_tmp119 = (g_free (_tmp119), NULL);
					_tmp118 = (g_free (_tmp118), NULL);
					_tmp122 = NULL;
					_tmp121 = NULL;
					cinst = (_tmp122 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp121 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL))), _tmp122);
					(_tmp121 == NULL ? NULL : (_tmp121 = (vala_ccode_node_unref (_tmp121), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp123 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp123 = vala_ccode_constant_new (enum_value))));
					(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
					_tmp125 = NULL;
					_tmp124 = NULL;
					cspec = (_tmp125 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ("g_param_spec_gtype")))), (cspec == NULL ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL))), _tmp125);
					(_tmp124 == NULL ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp126 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_constant_new ("\"type\""))));
					(_tmp126 == NULL ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL)));
					_tmp127 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_constant_new ("\"type\""))));
					(_tmp127 == NULL ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)));
					_tmp128 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp128 = vala_ccode_identifier_new ("G_TYPE_NONE"))));
					(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
					_tmp129 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
					(_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp130 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp130 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp130 == NULL ? NULL : (_tmp130 = (vala_ccode_node_unref (_tmp130), NULL)));
					_tmp131 = NULL;
					vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp131 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL)));
					vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GType", func_name);
					_tmp133 = NULL;
					_tmp132 = NULL;
					func_name = (_tmp133 = g_strdup_printf ("%s_dup_func", (_tmp132 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp133);
					_tmp132 = (g_free (_tmp132), NULL);
					_tmp136 = NULL;
					_tmp135 = NULL;
					_tmp134 = NULL;
					func_name_constant = (_tmp136 = vala_ccode_constant_new ((_tmp135 = g_strdup_printf ("\"%s-dup-func\"", (_tmp134 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL))), _tmp136);
					_tmp135 = (g_free (_tmp135), NULL);
					_tmp134 = (g_free (_tmp134), NULL);
					_tmp139 = NULL;
					_tmp138 = NULL;
					_tmp137 = NULL;
					enum_value = (_tmp139 = g_utf8_strup ((_tmp138 = g_strdup_printf ("%s_%s", (_tmp137 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp139);
					_tmp138 = (g_free (_tmp138), NULL);
					_tmp137 = (g_free (_tmp137), NULL);
					_tmp141 = NULL;
					_tmp140 = NULL;
					cinst = (_tmp141 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL))), _tmp141);
					(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp142 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_constant_new (enum_value))));
					(_tmp142 == NULL ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL)));
					_tmp144 = NULL;
					_tmp143 = NULL;
					cspec = (_tmp144 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp143 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL))), _tmp144);
					(_tmp143 == NULL ? NULL : (_tmp143 = (vala_ccode_node_unref (_tmp143), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp145 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp145 = vala_ccode_constant_new ("\"dup func\""))));
					(_tmp145 == NULL ? NULL : (_tmp145 = (vala_ccode_node_unref (_tmp145), NULL)));
					_tmp146 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp146 = vala_ccode_constant_new ("\"dup func\""))));
					(_tmp146 == NULL ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL)));
					_tmp147 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp147 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
					(_tmp147 == NULL ? NULL : (_tmp147 = (vala_ccode_node_unref (_tmp147), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp148 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp148 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp148 == NULL ? NULL : (_tmp148 = (vala_ccode_node_unref (_tmp148), NULL)));
					_tmp149 = NULL;
					vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp149 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp149 == NULL ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL)));
					vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GBoxedCopyFunc", func_name);
					_tmp151 = NULL;
					_tmp150 = NULL;
					func_name = (_tmp151 = g_strdup_printf ("%s_destroy_func", (_tmp150 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp151);
					_tmp150 = (g_free (_tmp150), NULL);
					_tmp154 = NULL;
					_tmp153 = NULL;
					_tmp152 = NULL;
					func_name_constant = (_tmp154 = vala_ccode_constant_new ((_tmp153 = g_strdup_printf ("\"%s-destroy-func\"", (_tmp152 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))))), (func_name_constant == NULL ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL))), _tmp154);
					_tmp153 = (g_free (_tmp153), NULL);
					_tmp152 = (g_free (_tmp152), NULL);
					_tmp157 = NULL;
					_tmp156 = NULL;
					_tmp155 = NULL;
					enum_value = (_tmp157 = g_utf8_strup ((_tmp156 = g_strdup_printf ("%s_%s", (_tmp155 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp157);
					_tmp156 = (g_free (_tmp156), NULL);
					_tmp155 = (g_free (_tmp155), NULL);
					_tmp159 = NULL;
					_tmp158 = NULL;
					cinst = (_tmp159 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_identifier_new ("g_object_class_install_property")))), (cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL))), _tmp159);
					(_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
					_tmp160 = NULL;
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_constant_new (enum_value))));
					(_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL)));
					_tmp162 = NULL;
					_tmp161 = NULL;
					cspec = (_tmp162 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp161 = vala_ccode_identifier_new ("g_param_spec_pointer")))), (cspec == NULL ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL))), _tmp162);
					(_tmp161 == NULL ? NULL : (_tmp161 = (vala_ccode_node_unref (_tmp161), NULL)));
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (func_name_constant));
					_tmp163 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_constant_new ("\"destroy func\""))));
					(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
					_tmp164 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_constant_new ("\"destroy func\""))));
					(_tmp164 == NULL ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)));
					_tmp165 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp165 = vala_ccode_constant_new ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY"))));
					(_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL)));
					vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (cspec));
					_tmp166 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp166 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
					(_tmp166 == NULL ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL)));
					_tmp167 = NULL;
					vala_ccode_enum_add_value (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->prop_enum, (_tmp167 = vala_ccode_enum_value_new (enum_value, NULL)));
					(_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL)));
					vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GDestroyNotify", func_name);
					(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
					func_name = (g_free (func_name), NULL);
					enum_value = (g_free (enum_value), NULL);
					(func_name_constant == NULL ? NULL : (func_name_constant = (vala_ccode_node_unref (func_name_constant), NULL)));
					(cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)));
					(cspec == NULL ? NULL : (cspec = (vala_ccode_node_unref (cspec), NULL)));
				}
			}
			(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
		}
		/* initialize class fields */
		fields = vala_class_get_fields (cl);
		{
			GeeList* field_collection;
			int field_it;
			field_collection = fields;
			for (field_it = 0; field_it < gee_collection_get_size (GEE_COLLECTION (field_collection)); field_it = field_it + 1) {
				ValaField* field;
				field = ((ValaField*) (gee_list_get (GEE_LIST (field_collection), field_it)));
				{
					char* _tmp169;
					ValaCCodeIdentifier* _tmp168;
					ValaCCodeExpression* _tmp170;
					ValaCCodeExpression* left;
					ValaCCodeExpression* _tmp171;
					ValaCCodeExpression* right;
					ValaCCodeAssignment* assign;
					ValaCCodeExpressionStatement* _tmp172;
					if (vala_field_get_binding (field) != MEMBER_BINDING_CLASS || vala_field_get_initializer (field) == NULL) {
						(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
						continue;
					}
					_tmp169 = NULL;
					_tmp168 = NULL;
					_tmp170 = NULL;
					left = (_tmp170 = VALA_CCODE_EXPRESSION (vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_identifier_new ("klass"))), (_tmp169 = vala_field_get_cname (field)), TRUE)), (_tmp169 = (g_free (_tmp169), NULL)), (_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL))), _tmp170);
					_tmp171 = NULL;
					right = (_tmp171 = VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_field_get_initializer (field)))), (_tmp171 == NULL ? NULL : vala_ccode_node_ref (_tmp171)));
					assign = vala_ccode_assignment_new (left, right, VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE);
					_tmp172 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp172 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
					(_tmp172 == NULL ? NULL : (_tmp172 = (vala_ccode_node_unref (_tmp172), NULL)));
					(field == NULL ? NULL : (field = (vala_code_node_unref (field), NULL)));
					(left == NULL ? NULL : (left = (vala_ccode_node_unref (left), NULL)));
					(right == NULL ? NULL : (right = (vala_ccode_node_unref (right), NULL)));
					(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
				}
			}
		}
		/* create properties */
		props = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		{
			GeeList* prop_collection;
			int prop_it;
			prop_collection = props;
			for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
				ValaProperty* prop;
				prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
				{
					/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
					if (vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
						(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						continue;
					}
					if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
						/* don't register private properties*/
						(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
						continue;
					}
					if (vala_property_get_overrides (prop) || vala_property_get_base_interface_property (prop) != NULL) {
						ValaCCodeIdentifier* _tmp173;
						ValaCCodeFunctionCall* _tmp174;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeConstant* _tmp176;
						char* _tmp175;
						ValaCCodeConstant* _tmp177;
						ValaCCodeExpressionStatement* _tmp178;
						_tmp173 = NULL;
						_tmp174 = NULL;
						cinst = (_tmp174 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp173 = vala_ccode_identifier_new ("g_object_class_override_property")))), (_tmp173 == NULL ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL))), _tmp174);
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
						_tmp176 = NULL;
						_tmp175 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp176 = vala_ccode_constant_new ((_tmp175 = vala_property_get_upper_case_cname (prop))))));
						(_tmp176 == NULL ? NULL : (_tmp176 = (vala_ccode_node_unref (_tmp176), NULL)));
						_tmp175 = (g_free (_tmp175), NULL);
						_tmp177 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp177 = vala_property_get_canonical_cconstant (prop))));
						(_tmp177 == NULL ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL)));
						_tmp178 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp178 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
						(_tmp178 == NULL ? NULL : (_tmp178 = (vala_ccode_node_unref (_tmp178), NULL)));
						(cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp179;
						ValaCCodeFunctionCall* _tmp180;
						ValaCCodeFunctionCall* cinst;
						ValaCCodeConstant* _tmp182;
						char* _tmp181;
						ValaCCodeFunctionCall* _tmp183;
						ValaCCodeExpressionStatement* _tmp184;
						_tmp179 = NULL;
						_tmp180 = NULL;
						cinst = (_tmp180 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp179 = vala_ccode_identifier_new ("g_object_class_install_property")))), (_tmp179 == NULL ? NULL : (_tmp179 = (vala_ccode_node_unref (_tmp179), NULL))), _tmp180);
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION (ccall));
						_tmp182 = NULL;
						_tmp181 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_constant_new ((_tmp181 = vala_property_get_upper_case_cname (prop))))));
						(_tmp182 == NULL ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL)));
						_tmp181 = (g_free (_tmp181), NULL);
						_tmp183 = NULL;
						vala_ccode_function_call_add_argument (cinst, VALA_CCODE_EXPRESSION ((_tmp183 = vala_ccode_type_symbol_binding_get_param_spec (VALA_CCODE_TYPE_SYMBOL_BINDING (self), prop))));
						(_tmp183 == NULL ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL)));
						_tmp184 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp184 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinst)))));
						(_tmp184 == NULL ? NULL : (_tmp184 = (vala_ccode_node_unref (_tmp184), NULL)));
						(cinst == NULL ? NULL : (cinst = (vala_ccode_node_unref (cinst), NULL)));
					}
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				}
			}
		}
		/* create signals */
		{
			GeeList* sig_collection;
			int sig_it;
			sig_collection = vala_object_type_symbol_get_signals (VALA_OBJECT_TYPE_SYMBOL (cl));
			for (sig_it = 0; sig_it < gee_collection_get_size (GEE_COLLECTION (sig_collection)); sig_it = sig_it + 1) {
				ValaSignal* sig;
				sig = ((ValaSignal*) (gee_list_get (GEE_LIST (sig_collection), sig_it)));
				{
					ValaCCodeExpressionStatement* _tmp186;
					ValaCCodeFunctionCall* _tmp185;
					_tmp186 = NULL;
					_tmp185 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp186 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp185 = vala_ccode_type_symbol_binding_get_signal_creation (VALA_CCODE_TYPE_SYMBOL_BINDING (self), sig, VALA_TYPESYMBOL (cl))))))));
					(_tmp186 == NULL ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL)));
					(_tmp185 == NULL ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)));
					(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
				}
			}
			(sig_collection == NULL ? NULL : (sig_collection = (gee_collection_object_unref (sig_collection), NULL)));
		}
		(fields == NULL ? NULL : (fields = (gee_collection_object_unref (fields), NULL)));
		(props == NULL ? NULL : (props = (gee_collection_object_unref (props), NULL)));
	} else {
		if (!vala_class_get_is_compact (cl)) {
			/* create type, dup_func, and destroy_func fields for generic types */
			{
				GeeList* type_param_collection;
				int type_param_it;
				type_param_collection = vala_class_get_type_parameters (cl);
				for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
					ValaTypeParameter* type_param;
					type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
					{
						char* func_name;
						char* _tmp188;
						char* _tmp187;
						char* _tmp190;
						char* _tmp189;
						char* _tmp192;
						char* _tmp191;
						func_name = NULL;
						_tmp188 = NULL;
						_tmp187 = NULL;
						func_name = (_tmp188 = g_strdup_printf ("%s_type", (_tmp187 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp188);
						_tmp187 = (g_free (_tmp187), NULL);
						vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GType", func_name);
						_tmp190 = NULL;
						_tmp189 = NULL;
						func_name = (_tmp190 = g_strdup_printf ("%s_dup_func", (_tmp189 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp190);
						_tmp189 = (g_free (_tmp189), NULL);
						vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GBoxedCopyFunc", func_name);
						_tmp192 = NULL;
						_tmp191 = NULL;
						func_name = (_tmp192 = g_strdup_printf ("%s_destroy_func", (_tmp191 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp192);
						_tmp191 = (g_free (_tmp191), NULL);
						vala_ccode_struct_add_field (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_priv_struct, "GDestroyNotify", func_name);
						(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
						func_name = (g_free (func_name), NULL);
					}
				}
				(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
			}
		}
	}
	_tmp193 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp193 = vala_ccode_object_type_symbol_binding_register_dbus_info (VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), VALA_OBJECT_TYPE_SYMBOL (cl)))));
	(_tmp193 == NULL ? NULL : (_tmp193 = (vala_ccode_node_unref (_tmp193), NULL)));
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->class_init_fragment));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (class_init));
	(class_init == NULL ? NULL : (class_init = (vala_ccode_node_unref (class_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(parent_decl == NULL ? NULL : (parent_decl = (vala_ccode_node_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (vala_ccode_node_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (vala_ccode_node_unref (parent_assignment), NULL)));
}


static void vala_ccode_class_binding_add_interface_init_function (ValaCCodeClassBinding* self, ValaClass* cl, ValaInterface* iface) {
	char* _tmp2;
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp3;
	ValaCCodeFunction* iface_init;
	ValaCCodeFormalParameter* _tmp6;
	char* _tmp5;
	char* _tmp4;
	ValaCCodeBlock* init_block;
	ValaCCodeFunctionCall* ccall;
	char* _tmp8;
	char* _tmp7;
	char* _tmp9;
	char* parent_iface_var;
	char* _tmp11;
	char* _tmp10;
	ValaCCodeDeclaration* _tmp12;
	ValaCCodeDeclaration* parent_decl;
	ValaCCodeVariableDeclarator* parent_var_decl;
	ValaCCodeConstant* _tmp13;
	ValaCCodeFunctionCall* _tmp15;
	ValaCCodeIdentifier* _tmp14;
	ValaCCodeIdentifier* _tmp16;
	ValaCCodeIdentifier* _tmp17;
	ValaCCodeAssignment* _tmp18;
	ValaCCodeAssignment* parent_assignment;
	ValaCCodeExpressionStatement* _tmp19;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	g_return_if_fail (VALA_IS_INTERFACE (iface));
	_tmp2 = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp3 = NULL;
	iface_init = (_tmp3 = vala_ccode_function_new ((_tmp2 = g_strdup_printf ("%s_%s_interface_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp1 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL)))), "void"), (_tmp2 = (g_free (_tmp2), NULL)), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp3);
	_tmp6 = NULL;
	_tmp5 = NULL;
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (iface_init, (_tmp6 = vala_ccode_formal_parameter_new ("iface", (_tmp5 = g_strdup_printf ("%s *", (_tmp4 = vala_interface_get_type_cname (iface)))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp4 = (g_free (_tmp4), NULL);
	vala_ccode_function_set_modifiers (iface_init, VALA_CCODE_MODIFIERS_STATIC);
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (iface_init, init_block);
	ccall = NULL;
	/* save pointer to parent vtable */
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp9 = NULL;
	parent_iface_var = (_tmp9 = g_strdup_printf ("%s_%s_parent_iface", (_tmp7 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), (_tmp8 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (iface), NULL))), (_tmp8 = (g_free (_tmp8), NULL)), (_tmp7 = (g_free (_tmp7), NULL)), _tmp9);
	_tmp11 = NULL;
	_tmp10 = NULL;
	_tmp12 = NULL;
	parent_decl = (_tmp12 = vala_ccode_declaration_new ((_tmp11 = g_strconcat ((_tmp10 = vala_interface_get_type_cname (iface)), "*", NULL))), (_tmp11 = (g_free (_tmp11), NULL)), (_tmp10 = (g_free (_tmp10), NULL)), _tmp12);
	parent_var_decl = vala_ccode_variable_declarator_new (parent_iface_var);
	_tmp13 = NULL;
	vala_ccode_variable_declarator_set_initializer (parent_var_decl, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("NULL"))));
	(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	vala_ccode_declaration_add_declarator (parent_decl, VALA_CCODE_DECLARATOR (parent_var_decl));
	vala_ccode_declaration_set_modifiers (parent_decl, VALA_CCODE_MODIFIERS_STATIC);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE (parent_decl));
	_tmp15 = NULL;
	_tmp14 = NULL;
	ccall = (_tmp15 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_type_interface_peek_parent")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp15);
	(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
	_tmp16 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ("iface"))));
	(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
	_tmp17 = NULL;
	_tmp18 = NULL;
	parent_assignment = (_tmp18 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new (parent_iface_var))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL))), _tmp18);
	_tmp19 = NULL;
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp19 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (parent_assignment)))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				ValaSymbol* _tmp20;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* ciface;
				char* cname;
				ValaCCodeExpressionStatement* _tmp25;
				ValaCCodeAssignment* _tmp24;
				ValaCCodeIdentifier* _tmp23;
				ValaCCodeMemberAccess* _tmp22;
				if (vala_method_get_base_interface_method (m) == NULL) {
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					continue;
				}
				_tmp20 = NULL;
				base_type = (_tmp20 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_method_get_base_interface_method (m))), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
				if (base_type != VALA_SYMBOL (iface)) {
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				cname = vala_method_get_real_cname (m);
				if (vala_method_get_is_abstract (m) || vala_method_get_is_virtual (m)) {
					char* _tmp21;
					/* FIXME results in C compiler warning*/
					_tmp21 = NULL;
					cname = (_tmp21 = vala_method_get_cname (m), (cname = (g_free (cname), NULL)), _tmp21);
				}
				_tmp25 = NULL;
				_tmp24 = NULL;
				_tmp23 = NULL;
				_tmp22 = NULL;
				vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp25 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_vfunc_name (vala_method_get_base_interface_method (m))))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
				(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
				(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL)));
				cname = (g_free (cname), NULL);
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	/* connect inherited implementations*/
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (VALA_OBJECT_TYPE_SYMBOL (iface));
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				if (vala_method_get_is_abstract (m)) {
					ValaMethod* cl_method;
					ValaClass* _tmp26;
					ValaClass* base_class;
					cl_method = NULL;
					_tmp26 = NULL;
					base_class = (_tmp26 = cl, (_tmp26 == NULL ? NULL : vala_code_node_ref (_tmp26)));
					while (base_class != NULL && cl_method == NULL) {
						ValaMethod* _tmp28;
						ValaSymbol* _tmp27;
						ValaClass* _tmp30;
						ValaClass* _tmp29;
						_tmp28 = NULL;
						_tmp27 = NULL;
						cl_method = (_tmp28 = (_tmp27 = vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (base_class)), vala_symbol_get_name (VALA_SYMBOL (m))), (VALA_IS_METHOD (_tmp27) ? ((ValaMethod*) (_tmp27)) : NULL)), (cl_method == NULL ? NULL : (cl_method = (vala_code_node_unref (cl_method), NULL))), _tmp28);
						_tmp30 = NULL;
						_tmp29 = NULL;
						base_class = (_tmp30 = (_tmp29 = vala_class_get_base_class (base_class), (_tmp29 == NULL ? NULL : vala_code_node_ref (_tmp29))), (base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL))), _tmp30);
					}
					if (base_class != NULL && vala_symbol_get_parent_symbol (VALA_SYMBOL (cl_method)) != VALA_SYMBOL (cl)) {
						ValaMethod* _tmp31;
						ValaMethod* base_method;
						ValaCCodeIdentifier* ciface;
						ValaCCodeExpressionStatement* _tmp40;
						ValaCCodeAssignment* _tmp39;
						ValaCCodeIdentifier* _tmp38;
						char* _tmp37;
						ValaCCodeMemberAccess* _tmp36;
						/* method inherited from base class*/
						_tmp31 = NULL;
						base_method = (_tmp31 = cl_method, (_tmp31 == NULL ? NULL : vala_code_node_ref (_tmp31)));
						if (vala_method_get_base_method (cl_method) != NULL) {
							ValaMethod* _tmp33;
							ValaMethod* _tmp32;
							_tmp33 = NULL;
							_tmp32 = NULL;
							base_method = (_tmp33 = (_tmp32 = vala_method_get_base_method (cl_method), (_tmp32 == NULL ? NULL : vala_code_node_ref (_tmp32))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp33);
						} else {
							if (vala_method_get_base_interface_method (cl_method) != NULL) {
								ValaMethod* _tmp35;
								ValaMethod* _tmp34;
								_tmp35 = NULL;
								_tmp34 = NULL;
								base_method = (_tmp35 = (_tmp34 = vala_method_get_base_interface_method (cl_method), (_tmp34 == NULL ? NULL : vala_code_node_ref (_tmp34))), (base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL))), _tmp35);
							}
						}
						ciface = vala_ccode_identifier_new ("iface");
						_tmp40 = NULL;
						_tmp39 = NULL;
						_tmp38 = NULL;
						_tmp37 = NULL;
						_tmp36 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp40 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp39 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), vala_method_get_vfunc_name (m)))), VALA_CCODE_EXPRESSION ((_tmp38 = vala_ccode_identifier_new ((_tmp37 = vala_method_get_cname (base_method))))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
						(_tmp39 == NULL ? NULL : (_tmp39 = (vala_ccode_node_unref (_tmp39), NULL)));
						(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
						_tmp37 = (g_free (_tmp37), NULL);
						(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
						(base_method == NULL ? NULL : (base_method = (vala_code_node_unref (base_method), NULL)));
						(ciface == NULL ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL)));
					}
					(cl_method == NULL ? NULL : (cl_method = (vala_code_node_unref (cl_method), NULL)));
					(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
				}
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				ValaSymbol* _tmp41;
				ValaSymbol* base_type;
				ValaCCodeIdentifier* ciface;
				if (vala_property_get_base_interface_property (prop) == NULL) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				_tmp41 = NULL;
				base_type = (_tmp41 = vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_property_get_base_interface_property (prop))), (_tmp41 == NULL ? NULL : vala_code_node_ref (_tmp41)));
				if (base_type != VALA_SYMBOL (iface)) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					continue;
				}
				ciface = vala_ccode_identifier_new ("iface");
				if (vala_property_get_get_accessor (prop) != NULL) {
					char* _tmp42;
					char* _tmp43;
					char* cname;
					ValaCCodeExpressionStatement* _tmp50;
					ValaCCodeAssignment* _tmp49;
					ValaCCodeIdentifier* _tmp48;
					ValaCCodeMemberAccess* _tmp47;
					char* _tmp46;
					_tmp42 = NULL;
					_tmp43 = NULL;
					cname = (_tmp43 = g_strdup_printf ("%s_real_get_%s", (_tmp42 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop))), (_tmp42 = (g_free (_tmp42), NULL)), _tmp43);
					if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
						char* _tmp45;
						char* _tmp44;
						_tmp45 = NULL;
						_tmp44 = NULL;
						cname = (_tmp45 = g_strdup_printf ("%s_get_%s", (_tmp44 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop))), (cname = (g_free (cname), NULL)), _tmp45);
						_tmp44 = (g_free (_tmp44), NULL);
					}
					_tmp50 = NULL;
					_tmp49 = NULL;
					_tmp48 = NULL;
					_tmp47 = NULL;
					_tmp46 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp50 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), (_tmp46 = g_strdup_printf ("get_%s", vala_symbol_get_name (VALA_SYMBOL (prop))))))), VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL)));
					(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
					(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
					(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
					_tmp46 = (g_free (_tmp46), NULL);
					cname = (g_free (cname), NULL);
				}
				if (vala_property_get_set_accessor (prop) != NULL) {
					char* _tmp51;
					char* _tmp52;
					char* cname;
					ValaCCodeExpressionStatement* _tmp59;
					ValaCCodeAssignment* _tmp58;
					ValaCCodeIdentifier* _tmp57;
					ValaCCodeMemberAccess* _tmp56;
					char* _tmp55;
					_tmp51 = NULL;
					_tmp52 = NULL;
					cname = (_tmp52 = g_strdup_printf ("%s_real_set_%s", (_tmp51 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop))), (_tmp51 = (g_free (_tmp51), NULL)), _tmp52);
					if (vala_property_get_is_abstract (prop) || vala_property_get_is_virtual (prop)) {
						char* _tmp54;
						char* _tmp53;
						_tmp54 = NULL;
						_tmp53 = NULL;
						cname = (_tmp54 = g_strdup_printf ("%s_set_%s", (_tmp53 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), vala_symbol_get_name (VALA_SYMBOL (prop))), (cname = (g_free (cname), NULL)), _tmp54);
						_tmp53 = (g_free (_tmp53), NULL);
					}
					_tmp59 = NULL;
					_tmp58 = NULL;
					_tmp57 = NULL;
					_tmp56 = NULL;
					_tmp55 = NULL;
					vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp59 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp56 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), (_tmp55 = g_strdup_printf ("set_%s", vala_symbol_get_name (VALA_SYMBOL (prop))))))), VALA_CCODE_EXPRESSION ((_tmp57 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
					(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
					(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
					(_tmp56 == NULL ? NULL : (_tmp56 = (vala_ccode_node_unref (_tmp56), NULL)));
					_tmp55 = (g_free (_tmp55), NULL);
					cname = (g_free (cname), NULL);
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				(ciface == NULL ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
	}
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (iface));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				ValaProperty* cl_prop;
				ValaClass* _tmp60;
				ValaClass* base_class;
				if (!vala_property_get_is_abstract (prop)) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				cl_prop = NULL;
				_tmp60 = NULL;
				base_class = (_tmp60 = cl, (_tmp60 == NULL ? NULL : vala_code_node_ref (_tmp60)));
				while (base_class != NULL && cl_prop == NULL) {
					ValaProperty* _tmp62;
					ValaSymbol* _tmp61;
					ValaClass* _tmp64;
					ValaClass* _tmp63;
					_tmp62 = NULL;
					_tmp61 = NULL;
					cl_prop = (_tmp62 = (_tmp61 = vala_scope_lookup (vala_symbol_get_scope (VALA_SYMBOL (base_class)), vala_symbol_get_name (VALA_SYMBOL (prop))), (VALA_IS_PROPERTY (_tmp61) ? ((ValaProperty*) (_tmp61)) : NULL)), (cl_prop == NULL ? NULL : (cl_prop = (vala_code_node_unref (cl_prop), NULL))), _tmp62);
					_tmp64 = NULL;
					_tmp63 = NULL;
					base_class = (_tmp64 = (_tmp63 = vala_class_get_base_class (base_class), (_tmp63 == NULL ? NULL : vala_code_node_ref (_tmp63))), (base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL))), _tmp64);
				}
				if (base_class != NULL && vala_symbol_get_parent_symbol (VALA_SYMBOL (cl_prop)) != VALA_SYMBOL (cl)) {
					ValaProperty* _tmp65;
					ValaProperty* base_property;
					ValaCCodeIdentifier* ciface;
					/* property inherited from base class*/
					_tmp65 = NULL;
					base_property = (_tmp65 = cl_prop, (_tmp65 == NULL ? NULL : vala_code_node_ref (_tmp65)));
					if (vala_property_get_base_property (cl_prop) != NULL) {
						ValaProperty* _tmp67;
						ValaProperty* _tmp66;
						_tmp67 = NULL;
						_tmp66 = NULL;
						base_property = (_tmp67 = (_tmp66 = vala_property_get_base_property (cl_prop), (_tmp66 == NULL ? NULL : vala_code_node_ref (_tmp66))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp67);
					} else {
						if (vala_property_get_base_interface_property (cl_prop) != NULL) {
							ValaProperty* _tmp69;
							ValaProperty* _tmp68;
							_tmp69 = NULL;
							_tmp68 = NULL;
							base_property = (_tmp69 = (_tmp68 = vala_property_get_base_interface_property (cl_prop), (_tmp68 == NULL ? NULL : vala_code_node_ref (_tmp68))), (base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL))), _tmp69);
						}
					}
					ciface = vala_ccode_identifier_new ("iface");
					if (vala_property_get_get_accessor (base_property) != NULL) {
						char* cname;
						ValaCCodeExpressionStatement* _tmp74;
						ValaCCodeAssignment* _tmp73;
						ValaCCodeIdentifier* _tmp72;
						ValaCCodeMemberAccess* _tmp71;
						char* _tmp70;
						cname = vala_property_accessor_get_cname (vala_property_get_get_accessor (base_property));
						_tmp74 = NULL;
						_tmp73 = NULL;
						_tmp72 = NULL;
						_tmp71 = NULL;
						_tmp70 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp74 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), (_tmp70 = g_strdup_printf ("get_%s", vala_symbol_get_name (VALA_SYMBOL (prop))))))), VALA_CCODE_EXPRESSION ((_tmp72 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
						(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
						(_tmp72 == NULL ? NULL : (_tmp72 = (vala_ccode_node_unref (_tmp72), NULL)));
						(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
						_tmp70 = (g_free (_tmp70), NULL);
						cname = (g_free (cname), NULL);
					}
					if (vala_property_get_set_accessor (base_property) != NULL) {
						char* cname;
						ValaCCodeExpressionStatement* _tmp79;
						ValaCCodeAssignment* _tmp78;
						ValaCCodeIdentifier* _tmp77;
						ValaCCodeMemberAccess* _tmp76;
						char* _tmp75;
						cname = vala_property_accessor_get_cname (vala_property_get_set_accessor (base_property));
						_tmp79 = NULL;
						_tmp78 = NULL;
						_tmp77 = NULL;
						_tmp76 = NULL;
						_tmp75 = NULL;
						vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp79 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ciface), (_tmp75 = g_strdup_printf ("set_%s", vala_symbol_get_name (VALA_SYMBOL (prop))))))), VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_identifier_new (cname))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
						(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
						(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
						(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
						(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
						_tmp75 = (g_free (_tmp75), NULL);
						cname = (g_free (cname), NULL);
					}
					(base_property == NULL ? NULL : (base_property = (vala_code_node_unref (base_property), NULL)));
					(ciface == NULL ? NULL : (ciface = (vala_ccode_node_unref (ciface), NULL)));
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				(cl_prop == NULL ? NULL : (cl_prop = (vala_code_node_unref (cl_prop), NULL)));
				(base_class == NULL ? NULL : (base_class = (vala_code_node_unref (base_class), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
	}
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (iface_init));
	(iface_init == NULL ? NULL : (iface_init = (vala_ccode_node_unref (iface_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	parent_iface_var = (g_free (parent_iface_var), NULL);
	(parent_decl == NULL ? NULL : (parent_decl = (vala_ccode_node_unref (parent_decl), NULL)));
	(parent_var_decl == NULL ? NULL : (parent_var_decl = (vala_ccode_node_unref (parent_var_decl), NULL)));
	(parent_assignment == NULL ? NULL : (parent_assignment = (vala_ccode_node_unref (parent_assignment), NULL)));
}


static void vala_ccode_class_binding_add_instance_init_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* instance_init;
	ValaCCodeFormalParameter* _tmp5;
	char* _tmp4;
	char* _tmp3;
	ValaCCodeBlock* init_block;
	GeeList* _tmp7;
	gboolean _tmp8;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	instance_init = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_instance_init", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	_tmp5 = NULL;
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (instance_init, (_tmp5 = vala_ccode_formal_parameter_new ("self", (_tmp4 = g_strdup_printf ("%s *", (_tmp3 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE)))))));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp4 = (g_free (_tmp4), NULL);
	_tmp3 = (g_free (_tmp3), NULL);
	vala_ccode_function_set_modifiers (instance_init, VALA_CCODE_MODIFIERS_STATIC);
	if (vala_class_get_is_compact (cl)) {
		ValaCCodeFunction* _tmp6;
		/* Add declaration, since the instance_init function is explicitly called
		 by the creation methods*/
		_tmp6 = NULL;
		vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp6 = vala_ccode_function_copy (instance_init))));
		(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	}
	init_block = vala_ccode_block_new ();
	vala_ccode_function_set_block (instance_init, init_block);
	_tmp7 = NULL;
	if ((_tmp8 = !vala_class_get_is_compact (cl) && (vala_class_get_has_private_fields (cl) || gee_collection_get_size (GEE_COLLECTION ((_tmp7 = vala_class_get_type_parameters (cl)))) > 0), (_tmp7 == NULL ? NULL : (_tmp7 = (gee_collection_object_unref (_tmp7), NULL))), _tmp8)) {
		ValaCCodeIdentifier* _tmp11;
		char* _tmp10;
		char* _tmp9;
		ValaCCodeFunctionCall* _tmp12;
		ValaCCodeFunctionCall* ccall;
		ValaCCodeIdentifier* _tmp13;
		ValaCCodeExpressionStatement* _tmp17;
		ValaCCodeAssignment* _tmp16;
		ValaCCodeMemberAccess* _tmp15;
		ValaCCodeIdentifier* _tmp14;
		_tmp11 = NULL;
		_tmp10 = NULL;
		_tmp9 = NULL;
		_tmp12 = NULL;
		ccall = (_tmp12 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp11 = vala_ccode_identifier_new ((_tmp10 = g_strdup_printf ("%s_GET_PRIVATE", (_tmp9 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (cl), NULL)))))))), (_tmp11 == NULL ? NULL : (_tmp11 = (vala_ccode_node_unref (_tmp11), NULL))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp12);
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("self"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp15 = NULL;
		_tmp14 = NULL;
		vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE ((_tmp17 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("self"))), "priv"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
		(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
		(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
		(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
		(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	}
	vala_ccode_block_add_statement (init_block, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_init_fragment));
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (instance_init));
	(instance_init == NULL ? NULL : (instance_init = (vala_ccode_node_unref (instance_init), NULL)));
	(init_block == NULL ? NULL : (init_block = (vala_ccode_node_unref (init_block), NULL)));
}


static void vala_ccode_class_binding_add_finalize_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* function;
	ValaClass* _tmp3;
	ValaClass* fundamental_class;
	ValaCCodeFormalParameter* _tmp8;
	char* _tmp7;
	char* _tmp6;
	ValaCCodeFunction* _tmp9;
	ValaCCodeBlock* cblock;
	ValaCCodeIdentifier* _tmp10;
	ValaCCodeFunctionCall* _tmp11;
	ValaCCodeFunctionCall* ccall;
	char* _tmp13;
	char* _tmp12;
	ValaCCodeDeclaration* _tmp14;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp15;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	function = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_finalize", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	fundamental_class = (_tmp3 = cl, (_tmp3 == NULL ? NULL : vala_code_node_ref (_tmp3)));
	while (vala_class_get_base_class (fundamental_class) != NULL) {
		ValaClass* _tmp5;
		ValaClass* _tmp4;
		_tmp5 = NULL;
		_tmp4 = NULL;
		fundamental_class = (_tmp5 = (_tmp4 = vala_class_get_base_class (fundamental_class), (_tmp4 == NULL ? NULL : vala_code_node_ref (_tmp4))), (fundamental_class == NULL ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL))), _tmp5);
	}
	_tmp8 = NULL;
	_tmp7 = NULL;
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp8 = vala_ccode_formal_parameter_new ("obj", (_tmp7 = g_strconcat ((_tmp6 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (fundamental_class), FALSE)), "*", NULL)))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp7 = (g_free (_tmp7), NULL);
	_tmp6 = (g_free (_tmp6), NULL);
	_tmp9 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp9 = vala_ccode_function_copy (function))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	cblock = vala_ccode_block_new ();
	_tmp10 = NULL;
	_tmp11 = NULL;
	ccall = (_tmp11 = VALA_CCODE_FUNCTION_CALL (vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_identifier_new ("obj"))), VALA_TYPESYMBOL (cl))), (_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL))), _tmp11);
	_tmp13 = NULL;
	_tmp12 = NULL;
	_tmp14 = NULL;
	cdecl_ = (_tmp14 = vala_ccode_declaration_new ((_tmp13 = g_strdup_printf ("%s *", (_tmp12 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp13 = (g_free (_tmp13), NULL)), (_tmp12 = (g_free (_tmp12), NULL)), _tmp14);
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp15 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (cdecl_));
	if (vala_class_get_destructor (cl) != NULL) {
		vala_ccode_block_add_statement (cblock, vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_class_get_destructor (cl))));
	}
	vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->instance_finalize_fragment));
	/* chain up to finalize function of the base class*/
	if (vala_class_get_base_class (cl) != NULL) {
		ValaCCodeIdentifier* _tmp18;
		char* _tmp17;
		char* _tmp16;
		ValaCCodeFunctionCall* _tmp19;
		ValaCCodeFunctionCall* ccast;
		ValaCCodeIdentifier* _tmp22;
		char* _tmp21;
		char* _tmp20;
		ValaCCodeFunctionCall* _tmp24;
		ValaCCodeMemberAccess* _tmp23;
		ValaCCodeIdentifier* _tmp25;
		ValaCCodeExpressionStatement* _tmp26;
		_tmp18 = NULL;
		_tmp17 = NULL;
		_tmp16 = NULL;
		_tmp19 = NULL;
		ccast = (_tmp19 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_identifier_new ((_tmp17 = g_strdup_printf ("%s_CLASS", (_tmp16 = vala_typesymbol_get_upper_case_cname (VALA_TYPESYMBOL (fundamental_class), NULL)))))))), (_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL))), (_tmp17 = (g_free (_tmp17), NULL)), (_tmp16 = (g_free (_tmp16), NULL)), _tmp19);
		_tmp22 = NULL;
		_tmp21 = NULL;
		_tmp20 = NULL;
		vala_ccode_function_call_add_argument (ccast, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_identifier_new ((_tmp21 = g_strdup_printf ("%s_parent_class", (_tmp20 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL))))))));
		(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
		_tmp21 = (g_free (_tmp21), NULL);
		_tmp20 = (g_free (_tmp20), NULL);
		_tmp24 = NULL;
		_tmp23 = NULL;
		ccall = (_tmp24 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (ccast), "finalize")))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), _tmp24);
		(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
		_tmp25 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("obj"))));
		(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
		_tmp26 = NULL;
		vala_ccode_block_add_statement (cblock, VALA_CCODE_NODE ((_tmp26 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
		(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
		(ccast == NULL ? NULL : (ccast = (vala_ccode_node_unref (ccast), NULL)));
	}
	vala_ccode_function_set_block (function, cblock);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	(function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL)));
	(fundamental_class == NULL ? NULL : (fundamental_class = (vala_code_node_unref (fundamental_class), NULL)));
	(cblock == NULL ? NULL : (cblock = (vala_ccode_node_unref (cblock), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
}


static gboolean vala_ccode_class_binding_class_has_readable_properties (ValaCCodeClassBinding* self, ValaClass* cl) {
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				if (vala_property_get_get_accessor (prop) != NULL) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
	}
	return FALSE;
}


static gboolean vala_ccode_class_binding_class_has_writable_properties (ValaCCodeClassBinding* self, ValaClass* cl) {
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_CLASS (cl), FALSE);
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				if (vala_property_get_set_accessor (prop) != NULL) {
					gboolean _tmp0;
					return (_tmp0 = TRUE, (prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL))), (prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL))), _tmp0);
				}
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
	}
	return FALSE;
}


static void vala_ccode_class_binding_add_get_property_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* get_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeStatement* _tmp35;
	ValaCCodeBreakStatement* _tmp36;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	get_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_get_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (get_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (get_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("object"))), VALA_TYPESYMBOL (cl)), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("property_id")))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
	props = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = props;
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				char* prefix;
				ValaCCodeExpression* cself;
				ValaCCodeIdentifier* _tmp26;
				char* _tmp25;
				ValaCCodeCaseStatement* _tmp27;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				ValaCCodeFunctionCall* _tmp30;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeFunctionCall* csetcall;
				ValaCCodeIdentifier* _tmp31;
				ValaCCodeIdentifier* _tmp32;
				ValaCCodeExpressionStatement* _tmp33;
				ValaCCodeBreakStatement* _tmp34;
				/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
				if (vala_property_get_get_accessor (prop) == NULL || vala_property_get_is_abstract (prop) || vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					/* don't register private properties*/
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				cself = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self"));
				if (vala_property_get_base_property (prop) != NULL) {
					ValaClass* _tmp15;
					ValaClass* base_type;
					char* _tmp16;
					ValaCCodeExpression* _tmp19;
					ValaObjectType* _tmp18;
					ValaObjectType* _tmp17;
					_tmp15 = NULL;
					base_type = (_tmp15 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_property_get_base_property (prop)))), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
					_tmp16 = NULL;
					prefix = (_tmp16 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_type), NULL), (prefix = (g_free (prefix), NULL)), _tmp16);
					_tmp19 = NULL;
					_tmp18 = NULL;
					_tmp17 = NULL;
					cself = (_tmp19 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cself, VALA_DATA_TYPE ((_tmp17 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl)))), VALA_DATA_TYPE ((_tmp18 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (base_type)))), NULL), (cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL))), _tmp19);
					(_tmp18 == NULL ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL)));
					(_tmp17 == NULL ? NULL : (_tmp17 = (vala_code_node_unref (_tmp17), NULL)));
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaInterface* _tmp20;
						ValaInterface* base_type;
						char* _tmp21;
						ValaCCodeExpression* _tmp24;
						ValaObjectType* _tmp23;
						ValaObjectType* _tmp22;
						_tmp20 = NULL;
						base_type = (_tmp20 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_property_get_base_interface_property (prop)))), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
						_tmp21 = NULL;
						prefix = (_tmp21 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_type), NULL), (prefix = (g_free (prefix), NULL)), _tmp21);
						_tmp24 = NULL;
						_tmp23 = NULL;
						_tmp22 = NULL;
						cself = (_tmp24 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cself, VALA_DATA_TYPE ((_tmp22 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl)))), VALA_DATA_TYPE ((_tmp23 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (base_type)))), NULL), (cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL))), _tmp24);
						(_tmp23 == NULL ? NULL : (_tmp23 = (vala_code_node_unref (_tmp23), NULL)));
						(_tmp22 == NULL ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)));
						(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					}
				}
				_tmp26 = NULL;
				_tmp25 = NULL;
				_tmp27 = NULL;
				ccase = (_tmp27 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ((_tmp25 = vala_property_get_upper_case_cname (prop)))))), (_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL))), (_tmp25 = (g_free (_tmp25), NULL)), _tmp27);
				_tmp29 = NULL;
				_tmp28 = NULL;
				_tmp30 = NULL;
				ccall = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = g_strdup_printf ("%s_get_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))))))), (_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL))), (_tmp28 = (g_free (_tmp28), NULL)), _tmp30);
				vala_ccode_function_call_add_argument (ccall, cself);
				csetcall = vala_ccode_function_call_new (NULL);
				_tmp31 = NULL;
				vala_ccode_function_call_set_call (csetcall, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_binding_get_value_setter_function (VALA_CCODE_BINDING (self), vala_property_get_property_type (prop)))));
				(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
				_tmp32 = NULL;
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ("value"))));
				(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
				vala_ccode_function_call_add_argument (csetcall, VALA_CCODE_EXPRESSION (ccall));
				_tmp33 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (csetcall)))));
				(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
				_tmp34 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp34 = vala_ccode_break_statement_new ())));
				(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				prefix = (g_free (prefix), NULL);
				(cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)));
				(ccase == NULL ? NULL : (ccase = (vala_ccode_node_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
				(csetcall == NULL ? NULL : (csetcall = (vala_ccode_node_unref (csetcall), NULL)));
			}
		}
	}
	_tmp35 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp35 = vala_ccode_class_binding_get_invalid_property_id_warn_statement (self)));
	(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
	_tmp36 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp36 = vala_ccode_break_statement_new ())));
	(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	vala_ccode_function_set_block (get_prop, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (get_prop));
	(get_prop == NULL ? NULL : (get_prop = (vala_ccode_node_unref (get_prop), NULL)));
	(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (gee_collection_object_unref (props), NULL)));
}


static void vala_ccode_class_binding_add_set_property_function (ValaCCodeClassBinding* self, ValaClass* cl) {
	char* _tmp1;
	char* _tmp0;
	ValaCCodeFunction* _tmp2;
	ValaCCodeFunction* set_prop;
	ValaCCodeFormalParameter* _tmp3;
	ValaCCodeFormalParameter* _tmp4;
	ValaCCodeFormalParameter* _tmp5;
	ValaCCodeFormalParameter* _tmp6;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp7;
	ValaInstanceCast* _tmp8;
	ValaInstanceCast* ccall;
	char* _tmp10;
	char* _tmp9;
	ValaCCodeDeclaration* _tmp11;
	ValaCCodeDeclaration* cdecl_;
	ValaCCodeVariableDeclarator* _tmp12;
	ValaCCodeIdentifier* _tmp13;
	ValaCCodeSwitchStatement* _tmp14;
	ValaCCodeSwitchStatement* cswitch;
	GeeList* props;
	ValaCCodeStatement* _tmp37;
	ValaCCodeBreakStatement* _tmp38;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	g_return_if_fail (VALA_IS_CLASS (cl));
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	set_prop = (_tmp2 = vala_ccode_function_new ((_tmp1 = g_strdup_printf ("%s_set_property", (_tmp0 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)))), "void"), (_tmp1 = (g_free (_tmp1), NULL)), (_tmp0 = (g_free (_tmp0), NULL)), _tmp2);
	vala_ccode_function_set_modifiers (set_prop, VALA_CCODE_MODIFIERS_STATIC);
	_tmp3 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp3 = vala_ccode_formal_parameter_new ("object", "GObject *")));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp4 = vala_ccode_formal_parameter_new ("property_id", "guint")));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp5 = vala_ccode_formal_parameter_new ("value", "const GValue *")));
	(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
	_tmp6 = NULL;
	vala_ccode_function_add_parameter (set_prop, (_tmp6 = vala_ccode_formal_parameter_new ("pspec", "GParamSpec *")));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	block = vala_ccode_block_new ();
	_tmp7 = NULL;
	_tmp8 = NULL;
	ccall = (_tmp8 = vala_instance_cast_new (VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_identifier_new ("object"))), VALA_TYPESYMBOL (cl)), (_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL))), _tmp8);
	_tmp10 = NULL;
	_tmp9 = NULL;
	_tmp11 = NULL;
	cdecl_ = (_tmp11 = vala_ccode_declaration_new ((_tmp10 = g_strdup_printf ("%s *", (_tmp9 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (cl), FALSE))))), (_tmp10 = (g_free (_tmp10), NULL)), (_tmp9 = (g_free (_tmp9), NULL)), _tmp11);
	_tmp12 = NULL;
	vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp12 = vala_ccode_variable_declarator_new_with_initializer ("self", VALA_CCODE_EXPRESSION (ccall)))));
	(_tmp12 == NULL ? NULL : (_tmp12 = (vala_ccode_node_unref (_tmp12), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
	_tmp13 = NULL;
	_tmp14 = NULL;
	cswitch = (_tmp14 = vala_ccode_switch_statement_new (VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("property_id")))), (_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL))), _tmp14);
	props = vala_object_type_symbol_get_properties (VALA_OBJECT_TYPE_SYMBOL (cl));
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = props;
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				char* prefix;
				ValaCCodeExpression* cself;
				ValaCCodeIdentifier* _tmp26;
				char* _tmp25;
				ValaCCodeCaseStatement* _tmp27;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeIdentifier* _tmp29;
				char* _tmp28;
				ValaCCodeFunctionCall* _tmp30;
				ValaCCodeFunctionCall* ccall;
				ValaCCodeFunctionCall* cgetcall;
				ValaCCodeIdentifier* _tmp34;
				ValaCCodeExpressionStatement* _tmp35;
				ValaCCodeBreakStatement* _tmp36;
				/* FIXME: omit real struct types for now since they cannot be expressed as gobject property yet*/
				if (vala_property_get_set_accessor (prop) == NULL || vala_property_get_is_abstract (prop) || vala_data_type_is_real_struct_type (vala_property_get_property_type (prop))) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				if (vala_symbol_get_access (VALA_SYMBOL (prop)) == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
					/* don't register private properties*/
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				prefix = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL);
				cself = VALA_CCODE_EXPRESSION (vala_ccode_identifier_new ("self"));
				if (vala_property_get_base_property (prop) != NULL) {
					ValaClass* _tmp15;
					ValaClass* base_type;
					char* _tmp16;
					ValaCCodeExpression* _tmp19;
					ValaObjectType* _tmp18;
					ValaObjectType* _tmp17;
					_tmp15 = NULL;
					base_type = (_tmp15 = VALA_CLASS (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_property_get_base_property (prop)))), (_tmp15 == NULL ? NULL : vala_code_node_ref (_tmp15)));
					_tmp16 = NULL;
					prefix = (_tmp16 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_type), NULL), (prefix = (g_free (prefix), NULL)), _tmp16);
					_tmp19 = NULL;
					_tmp18 = NULL;
					_tmp17 = NULL;
					cself = (_tmp19 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cself, VALA_DATA_TYPE ((_tmp17 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl)))), VALA_DATA_TYPE ((_tmp18 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (base_type)))), NULL), (cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL))), _tmp19);
					(_tmp18 == NULL ? NULL : (_tmp18 = (vala_code_node_unref (_tmp18), NULL)));
					(_tmp17 == NULL ? NULL : (_tmp17 = (vala_code_node_unref (_tmp17), NULL)));
					(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
				} else {
					if (vala_property_get_base_interface_property (prop) != NULL) {
						ValaInterface* _tmp20;
						ValaInterface* base_type;
						char* _tmp21;
						ValaCCodeExpression* _tmp24;
						ValaObjectType* _tmp23;
						ValaObjectType* _tmp22;
						_tmp20 = NULL;
						base_type = (_tmp20 = VALA_INTERFACE (vala_symbol_get_parent_symbol (VALA_SYMBOL (vala_property_get_base_interface_property (prop)))), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
						_tmp21 = NULL;
						prefix = (_tmp21 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (base_type), NULL), (prefix = (g_free (prefix), NULL)), _tmp21);
						_tmp24 = NULL;
						_tmp23 = NULL;
						_tmp22 = NULL;
						cself = (_tmp24 = vala_ccode_generator_transform_expression (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), cself, VALA_DATA_TYPE ((_tmp22 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (cl)))), VALA_DATA_TYPE ((_tmp23 = vala_object_type_new (VALA_OBJECT_TYPE_SYMBOL (base_type)))), NULL), (cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL))), _tmp24);
						(_tmp23 == NULL ? NULL : (_tmp23 = (vala_code_node_unref (_tmp23), NULL)));
						(_tmp22 == NULL ? NULL : (_tmp22 = (vala_code_node_unref (_tmp22), NULL)));
						(base_type == NULL ? NULL : (base_type = (vala_code_node_unref (base_type), NULL)));
					}
				}
				_tmp26 = NULL;
				_tmp25 = NULL;
				_tmp27 = NULL;
				ccase = (_tmp27 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_identifier_new ((_tmp25 = vala_property_get_upper_case_cname (prop)))))), (_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL))), (_tmp25 = (g_free (_tmp25), NULL)), _tmp27);
				_tmp29 = NULL;
				_tmp28 = NULL;
				_tmp30 = NULL;
				ccall = (_tmp30 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_identifier_new ((_tmp28 = g_strdup_printf ("%s_set_%s", prefix, vala_symbol_get_name (VALA_SYMBOL (prop)))))))), (_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL))), (_tmp28 = (g_free (_tmp28), NULL)), _tmp30);
				vala_ccode_function_call_add_argument (ccall, cself);
				cgetcall = vala_ccode_function_call_new (NULL);
				if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) != NULL) {
					ValaCCodeIdentifier* _tmp32;
					char* _tmp31;
					_tmp32 = NULL;
					_tmp31 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_identifier_new ((_tmp31 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_property_get_property_type (prop))))))));
					(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
					_tmp31 = (g_free (_tmp31), NULL);
				} else {
					ValaCCodeIdentifier* _tmp33;
					_tmp33 = NULL;
					vala_ccode_function_call_set_call (cgetcall, VALA_CCODE_EXPRESSION ((_tmp33 = vala_ccode_identifier_new ("g_value_get_pointer"))));
					(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
				}
				_tmp34 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("value"))));
				(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
				vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cgetcall));
				_tmp35 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp35 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (ccall)))));
				(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
				_tmp36 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp36 = vala_ccode_break_statement_new ())));
				(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
				prefix = (g_free (prefix), NULL);
				(cself == NULL ? NULL : (cself = (vala_ccode_node_unref (cself), NULL)));
				(ccase == NULL ? NULL : (ccase = (vala_ccode_node_unref (ccase), NULL)));
				(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)));
			}
		}
	}
	_tmp37 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, (_tmp37 = vala_ccode_class_binding_get_invalid_property_id_warn_statement (self)));
	(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
	_tmp38 = NULL;
	vala_ccode_switch_statement_add_default_statement (cswitch, VALA_CCODE_STATEMENT ((_tmp38 = vala_ccode_break_statement_new ())));
	(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cswitch));
	/* type, dup func, and destroy func properties for generic types */
	{
		GeeList* type_param_collection;
		int type_param_it;
		type_param_collection = vala_class_get_type_parameters (cl);
		for (type_param_it = 0; type_param_it < gee_collection_get_size (GEE_COLLECTION (type_param_collection)); type_param_it = type_param_it + 1) {
			ValaTypeParameter* type_param;
			type_param = ((ValaTypeParameter*) (gee_list_get (GEE_LIST (type_param_collection), type_param_it)));
			{
				char* func_name;
				char* enum_value;
				ValaCCodeCaseStatement* ccase;
				ValaCCodeMemberAccess* cfield;
				ValaCCodeFunctionCall* cgetcall;
				char* _tmp40;
				char* _tmp39;
				char* _tmp43;
				char* _tmp42;
				char* _tmp41;
				ValaCCodeCaseStatement* _tmp45;
				ValaCCodeIdentifier* _tmp44;
				ValaCCodeMemberAccess* _tmp48;
				ValaCCodeMemberAccess* _tmp47;
				ValaCCodeIdentifier* _tmp46;
				ValaCCodeFunctionCall* _tmp50;
				ValaCCodeIdentifier* _tmp49;
				ValaCCodeIdentifier* _tmp51;
				ValaCCodeExpressionStatement* _tmp53;
				ValaCCodeAssignment* _tmp52;
				ValaCCodeBreakStatement* _tmp54;
				char* _tmp56;
				char* _tmp55;
				char* _tmp59;
				char* _tmp58;
				char* _tmp57;
				ValaCCodeCaseStatement* _tmp61;
				ValaCCodeIdentifier* _tmp60;
				ValaCCodeMemberAccess* _tmp64;
				ValaCCodeMemberAccess* _tmp63;
				ValaCCodeIdentifier* _tmp62;
				ValaCCodeFunctionCall* _tmp66;
				ValaCCodeIdentifier* _tmp65;
				ValaCCodeIdentifier* _tmp67;
				ValaCCodeExpressionStatement* _tmp69;
				ValaCCodeAssignment* _tmp68;
				ValaCCodeBreakStatement* _tmp70;
				char* _tmp72;
				char* _tmp71;
				char* _tmp75;
				char* _tmp74;
				char* _tmp73;
				ValaCCodeCaseStatement* _tmp77;
				ValaCCodeIdentifier* _tmp76;
				ValaCCodeMemberAccess* _tmp80;
				ValaCCodeMemberAccess* _tmp79;
				ValaCCodeIdentifier* _tmp78;
				ValaCCodeFunctionCall* _tmp82;
				ValaCCodeIdentifier* _tmp81;
				ValaCCodeIdentifier* _tmp83;
				ValaCCodeExpressionStatement* _tmp85;
				ValaCCodeAssignment* _tmp84;
				ValaCCodeBreakStatement* _tmp86;
				func_name = NULL;
				enum_value = NULL;
				ccase = NULL;
				cfield = NULL;
				cgetcall = NULL;
				_tmp40 = NULL;
				_tmp39 = NULL;
				func_name = (_tmp40 = g_strdup_printf ("%s_type", (_tmp39 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp40);
				_tmp39 = (g_free (_tmp39), NULL);
				_tmp43 = NULL;
				_tmp42 = NULL;
				_tmp41 = NULL;
				enum_value = (_tmp43 = g_utf8_strup ((_tmp42 = g_strdup_printf ("%s_%s", (_tmp41 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp43);
				_tmp42 = (g_free (_tmp42), NULL);
				_tmp41 = (g_free (_tmp41), NULL);
				_tmp45 = NULL;
				_tmp44 = NULL;
				ccase = (_tmp45 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (vala_ccode_node_unref (ccase), NULL))), _tmp45);
				(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
				_tmp48 = NULL;
				_tmp47 = NULL;
				_tmp46 = NULL;
				cfield = (_tmp48 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL))), _tmp48);
				(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
				(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
				_tmp50 = NULL;
				_tmp49 = NULL;
				cgetcall = (_tmp50 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new ("g_value_get_gtype")))), (cgetcall == NULL ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL))), _tmp50);
				(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
				_tmp51 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp51 = vala_ccode_identifier_new ("value"))));
				(_tmp51 == NULL ? NULL : (_tmp51 = (vala_ccode_node_unref (_tmp51), NULL)));
				_tmp53 = NULL;
				_tmp52 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp53 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
				(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
				_tmp54 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp54 = vala_ccode_break_statement_new ())));
				(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				_tmp56 = NULL;
				_tmp55 = NULL;
				func_name = (_tmp56 = g_strdup_printf ("%s_dup_func", (_tmp55 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp56);
				_tmp55 = (g_free (_tmp55), NULL);
				_tmp59 = NULL;
				_tmp58 = NULL;
				_tmp57 = NULL;
				enum_value = (_tmp59 = g_utf8_strup ((_tmp58 = g_strdup_printf ("%s_%s", (_tmp57 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp59);
				_tmp58 = (g_free (_tmp58), NULL);
				_tmp57 = (g_free (_tmp57), NULL);
				_tmp61 = NULL;
				_tmp60 = NULL;
				ccase = (_tmp61 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (vala_ccode_node_unref (ccase), NULL))), _tmp61);
				(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
				_tmp64 = NULL;
				_tmp63 = NULL;
				_tmp62 = NULL;
				cfield = (_tmp64 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp63 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL))), _tmp64);
				(_tmp63 == NULL ? NULL : (_tmp63 = (vala_ccode_node_unref (_tmp63), NULL)));
				(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
				_tmp66 = NULL;
				_tmp65 = NULL;
				cgetcall = (_tmp66 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_identifier_new ("g_value_get_pointer")))), (cgetcall == NULL ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL))), _tmp66);
				(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
				_tmp67 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp67 = vala_ccode_identifier_new ("value"))));
				(_tmp67 == NULL ? NULL : (_tmp67 = (vala_ccode_node_unref (_tmp67), NULL)));
				_tmp69 = NULL;
				_tmp68 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp69 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
				(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
				_tmp70 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp70 = vala_ccode_break_statement_new ())));
				(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				_tmp72 = NULL;
				_tmp71 = NULL;
				func_name = (_tmp72 = g_strdup_printf ("%s_destroy_func", (_tmp71 = g_utf8_strdown (vala_symbol_get_name (VALA_SYMBOL (type_param)), -1))), (func_name = (g_free (func_name), NULL)), _tmp72);
				_tmp71 = (g_free (_tmp71), NULL);
				_tmp75 = NULL;
				_tmp74 = NULL;
				_tmp73 = NULL;
				enum_value = (_tmp75 = g_utf8_strup ((_tmp74 = g_strdup_printf ("%s_%s", (_tmp73 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (cl), NULL)), func_name)), -1), (enum_value = (g_free (enum_value), NULL)), _tmp75);
				_tmp74 = (g_free (_tmp74), NULL);
				_tmp73 = (g_free (_tmp73), NULL);
				_tmp77 = NULL;
				_tmp76 = NULL;
				ccase = (_tmp77 = vala_ccode_case_statement_new (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new (enum_value)))), (ccase == NULL ? NULL : (ccase = (vala_ccode_node_unref (ccase), NULL))), _tmp77);
				(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
				_tmp80 = NULL;
				_tmp79 = NULL;
				_tmp78 = NULL;
				cfield = (_tmp80 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp78 = vala_ccode_identifier_new ("self"))), "priv"))), func_name), (cfield == NULL ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL))), _tmp80);
				(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
				(_tmp78 == NULL ? NULL : (_tmp78 = (vala_ccode_node_unref (_tmp78), NULL)));
				_tmp82 = NULL;
				_tmp81 = NULL;
				cgetcall = (_tmp82 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_identifier_new ("g_value_get_pointer")))), (cgetcall == NULL ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL))), _tmp82);
				(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
				_tmp83 = NULL;
				vala_ccode_function_call_add_argument (cgetcall, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_identifier_new ("value"))));
				(_tmp83 == NULL ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL)));
				_tmp85 = NULL;
				_tmp84 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp85 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (cfield), VALA_CCODE_EXPRESSION (cgetcall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL)));
				(_tmp84 == NULL ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)));
				_tmp86 = NULL;
				vala_ccode_case_statement_add_statement (ccase, VALA_CCODE_STATEMENT ((_tmp86 = vala_ccode_break_statement_new ())));
				(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
				vala_ccode_switch_statement_add_case (cswitch, ccase);
				(type_param == NULL ? NULL : (type_param = (vala_code_node_unref (type_param), NULL)));
				func_name = (g_free (func_name), NULL);
				enum_value = (g_free (enum_value), NULL);
				(ccase == NULL ? NULL : (ccase = (vala_ccode_node_unref (ccase), NULL)));
				(cfield == NULL ? NULL : (cfield = (vala_ccode_node_unref (cfield), NULL)));
				(cgetcall == NULL ? NULL : (cgetcall = (vala_ccode_node_unref (cgetcall), NULL)));
			}
		}
		(type_param_collection == NULL ? NULL : (type_param_collection = (gee_collection_object_unref (type_param_collection), NULL)));
	}
	vala_ccode_function_set_block (set_prop, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (set_prop));
	(set_prop == NULL ? NULL : (set_prop = (vala_ccode_node_unref (set_prop), NULL)));
	(block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL)));
	(ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL)));
	(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
	(cswitch == NULL ? NULL : (cswitch = (vala_ccode_node_unref (cswitch), NULL)));
	(props == NULL ? NULL : (props = (gee_collection_object_unref (props), NULL)));
}


static ValaCCodeStatement* vala_ccode_class_binding_get_invalid_property_id_warn_statement (ValaCCodeClassBinding* self) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* cwarn;
	ValaCCodeIdentifier* _tmp2;
	ValaCCodeIdentifier* _tmp3;
	ValaCCodeIdentifier* _tmp4;
	ValaCCodeStatement* _tmp5;
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), NULL);
	/* warn on invalid property id*/
	_tmp0 = NULL;
	_tmp1 = NULL;
	cwarn = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("G_OBJECT_WARN_INVALID_PROPERTY_ID")))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_identifier_new ("object"))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp3 = vala_ccode_identifier_new ("property_id"))));
	(_tmp3 == NULL ? NULL : (_tmp3 = (vala_ccode_node_unref (_tmp3), NULL)));
	_tmp4 = NULL;
	vala_ccode_function_call_add_argument (cwarn, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_identifier_new ("pspec"))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp5 = NULL;
	return (_tmp5 = VALA_CCODE_STATEMENT (vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cwarn))), (cwarn == NULL ? NULL : (cwarn = (vala_ccode_node_unref (cwarn), NULL))), _tmp5);
}


ValaClass* vala_ccode_class_binding_get_cl (ValaCCodeClassBinding* self) {
	g_return_val_if_fail (VALA_IS_CCODE_CLASS_BINDING (self), NULL);
	return self->priv->_cl;
}


void vala_ccode_class_binding_set_cl (ValaCCodeClassBinding* self, ValaClass* value) {
	ValaClass* _tmp2;
	ValaClass* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_CLASS_BINDING (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_cl = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_cl == NULL ? NULL : (self->priv->_cl = (vala_code_node_unref (self->priv->_cl), NULL))), _tmp2);
}


static void vala_ccode_class_binding_class_init (ValaCCodeClassBindingClass * klass) {
	vala_ccode_class_binding_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_BINDING_CLASS (klass)->finalize = vala_ccode_class_binding_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeClassBindingPrivate));
	VALA_CCODE_BINDING_CLASS (klass)->emit = vala_ccode_class_binding_real_emit;
}


static void vala_ccode_class_binding_instance_init (ValaCCodeClassBinding * self) {
	self->priv = VALA_CCODE_CLASS_BINDING_GET_PRIVATE (self);
}


static void vala_ccode_class_binding_finalize (ValaCodeBinding* obj) {
	ValaCCodeClassBinding * self;
	self = VALA_CCODE_CLASS_BINDING (obj);
	(self->priv->_cl == NULL ? NULL : (self->priv->_cl = (vala_code_node_unref (self->priv->_cl), NULL)));
	VALA_CODE_BINDING_CLASS (vala_ccode_class_binding_parent_class)->finalize (obj);
}


GType vala_ccode_class_binding_get_type (void) {
	static GType vala_ccode_class_binding_type_id = 0;
	if (vala_ccode_class_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeClassBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_class_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeClassBinding), 0, (GInstanceInitFunc) vala_ccode_class_binding_instance_init, NULL };
		vala_ccode_class_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_OBJECT_TYPE_SYMBOL_BINDING, "ValaCCodeClassBinding", &g_define_type_info, 0);
	}
	return vala_ccode_class_binding_type_id;
}




