/* valaccodecasestatement.vala
 *
 * Copyright (C) 2006-2007  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodecasestatement.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeCaseStatementPrivate {
	ValaCCodeExpression* _expression;
	GeeList* statements;
};

#define VALA_CCODE_CASE_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_CASE_STATEMENT, ValaCCodeCaseStatementPrivate))
enum  {
	VALA_CCODE_CASE_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_case_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_case_statement_parent_class = NULL;
static void vala_ccode_case_statement_finalize (ValaCCodeNode* obj);



ValaCCodeCaseStatement* vala_ccode_case_statement_construct (GType object_type, ValaCCodeExpression* expression) {
	ValaCCodeCaseStatement* self;
	g_return_val_if_fail (VALA_IS_CCODE_EXPRESSION (expression), NULL);
	self = ((ValaCCodeCaseStatement*) (g_type_create_instance (object_type)));
	vala_ccode_case_statement_set_expression (self, expression);
	return self;
}


ValaCCodeCaseStatement* vala_ccode_case_statement_new (ValaCCodeExpression* expression) {
	return vala_ccode_case_statement_construct (VALA_TYPE_CCODE_CASE_STATEMENT, expression);
}


/**
 * Append the specified statement to this switch section.
 *
 * @param stmt a statement
 */
void vala_ccode_case_statement_add_statement (ValaCCodeCaseStatement* self, ValaCCodeStatement* stmt) {
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_STATEMENT (stmt));
	gee_collection_add (GEE_COLLECTION (self->priv->statements), stmt);
}


static void vala_ccode_case_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "case ");
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_expression), writer);
	vala_ccode_writer_write_string (writer, ":");
	vala_ccode_writer_write_newline (writer);
	{
		GeeList* stmt_collection;
		int stmt_it;
		stmt_collection = self->priv->statements;
		for (stmt_it = 0; stmt_it < gee_collection_get_size (GEE_COLLECTION (stmt_collection)); stmt_it = stmt_it + 1) {
			ValaCCodeStatement* stmt;
			stmt = ((ValaCCodeStatement*) (gee_list_get (GEE_LIST (stmt_collection), stmt_it)));
			{
				vala_ccode_node_write (VALA_CCODE_NODE (stmt), writer);
				(stmt == NULL ? NULL : (stmt = (vala_ccode_node_unref (stmt), NULL)));
			}
		}
	}
}


ValaCCodeExpression* vala_ccode_case_statement_get_expression (ValaCCodeCaseStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self), NULL);
	return self->priv->_expression;
}


void vala_ccode_case_statement_set_expression (ValaCCodeCaseStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_CASE_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_expression = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_ccode_node_unref (self->priv->_expression), NULL))), _tmp2);
}


static void vala_ccode_case_statement_class_init (ValaCCodeCaseStatementClass * klass) {
	vala_ccode_case_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_case_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeCaseStatementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_case_statement_real_write;
}


static void vala_ccode_case_statement_instance_init (ValaCCodeCaseStatement * self) {
	self->priv = VALA_CCODE_CASE_STATEMENT_GET_PRIVATE (self);
	self->priv->statements = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_STATEMENT, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
}


static void vala_ccode_case_statement_finalize (ValaCCodeNode* obj) {
	ValaCCodeCaseStatement * self;
	self = VALA_CCODE_CASE_STATEMENT (obj);
	(self->priv->_expression == NULL ? NULL : (self->priv->_expression = (vala_ccode_node_unref (self->priv->_expression), NULL)));
	(self->priv->statements == NULL ? NULL : (self->priv->statements = (gee_collection_object_unref (self->priv->statements), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_case_statement_parent_class)->finalize (obj);
}


GType vala_ccode_case_statement_get_type (void) {
	static GType vala_ccode_case_statement_type_id = 0;
	if (vala_ccode_case_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeCaseStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_case_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeCaseStatement), 0, (GInstanceInitFunc) vala_ccode_case_statement_instance_init, NULL };
		vala_ccode_case_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeCaseStatement", &g_define_type_info, 0);
	}
	return vala_ccode_case_statement_type_id;
}




