/* valanamedargument.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

using GLib;

/**
 * Represents a named argument in the source code. A named argument may be used
 * when creating objects and attributes where no parameter list exists.
 */
public class Vala.NamedArgument : CodeNode {
	/**
	 * The name of a property.
	 */
	public string name { get; set; }
	
	/**
	 * The expression the property should assign.
	 */
	public Expression argument { get; set; }
	
	/**
	 * Creates a new named argument.
	 *
	 * @param name   property name
	 * @param arg    property value expression
	 * @param source reference to source code
	 * @return       newly created named argument
	 */
	public NamedArgument (string name, Expression argument, SourceReference? source_reference = null) {
		this.name = name;
		this.argument = argument;
		this.source_reference = source_reference;
	}
	
	public override void accept (CodeVisitor visitor) {
		argument.accept (visitor);
	
		visitor.visit_named_argument (this);
	}
}
