/* valainvocationexpression.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAINVOCATIONEXPRESSION_H__
#define __VALA_VALAINVOCATIONEXPRESSION_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <ccode/valaccodeexpression.h>
#include <vala/valaexpression.h>
#include <vala/valacodenode.h>
#include <vala/valacodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_INVOCATION_EXPRESSION (vala_invocation_expression_get_type ())
#define VALA_INVOCATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpression))
#define VALA_INVOCATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpressionClass))
#define VALA_IS_INVOCATION_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INVOCATION_EXPRESSION))
#define VALA_IS_INVOCATION_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INVOCATION_EXPRESSION))
#define VALA_INVOCATION_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INVOCATION_EXPRESSION, ValaInvocationExpressionClass))

typedef struct _ValaInvocationExpressionPrivate ValaInvocationExpressionPrivate;

/**
 * Represents an invocation expression in the source code.
 */
struct _ValaInvocationExpression {
	ValaExpression parent_instance;
	ValaInvocationExpressionPrivate * priv;
	ValaExpression* _call;
};

struct _ValaInvocationExpressionClass {
	ValaExpressionClass parent_class;
};


ValaInvocationExpression* vala_invocation_expression_construct (GType object_type, ValaExpression* call, ValaSourceReference* source_reference);
ValaInvocationExpression* vala_invocation_expression_new (ValaExpression* call, ValaSourceReference* source_reference);
void vala_invocation_expression_add_argument (ValaInvocationExpression* self, ValaExpression* arg);
GeeList* vala_invocation_expression_get_argument_list (ValaInvocationExpression* self);
void vala_invocation_expression_append_array_size (ValaInvocationExpression* self, ValaCCodeExpression* size);
GeeList* vala_invocation_expression_get_array_sizes (ValaInvocationExpression* self);
ValaExpression* vala_invocation_expression_get_call (ValaInvocationExpression* self);
void vala_invocation_expression_set_call (ValaInvocationExpression* self, ValaExpression* value);
ValaCCodeExpression* vala_invocation_expression_get_delegate_target (ValaInvocationExpression* self);
void vala_invocation_expression_set_delegate_target (ValaInvocationExpression* self, ValaCCodeExpression* value);
GType vala_invocation_expression_get_type (void);


G_END_DECLS

#endif
