/* valainterface.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#ifndef __VALA_VALAINTERFACE_H__
#define __VALA_VALAINTERFACE_H__

#include <glib.h>
#include <glib-object.h>
#include <gee/list.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaobjecttypesymbol.h>
#include <vala/valacodenode.h>
#include <vala/valatypesymbol.h>
#include <vala/valacodebinding.h>

G_BEGIN_DECLS


#define VALA_TYPE_INTERFACE (vala_interface_get_type ())
#define VALA_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VALA_TYPE_INTERFACE, ValaInterface))
#define VALA_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VALA_TYPE_INTERFACE, ValaInterfaceClass))
#define VALA_IS_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VALA_TYPE_INTERFACE))
#define VALA_IS_INTERFACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VALA_TYPE_INTERFACE))
#define VALA_INTERFACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VALA_TYPE_INTERFACE, ValaInterfaceClass))

typedef struct _ValaInterfacePrivate ValaInterfacePrivate;

/**
 * Represents a class declaration in the source code.
 */
struct _ValaInterface {
	ValaObjectTypeSymbol parent_instance;
	ValaInterfacePrivate * priv;
};

struct _ValaInterfaceClass {
	ValaObjectTypeSymbolClass parent_class;
};


GeeList* vala_interface_get_classes (ValaInterface* self);
GeeList* vala_interface_get_structs (ValaInterface* self);
GeeList* vala_interface_get_enums (ValaInterface* self);
GeeList* vala_interface_get_delegates (ValaInterface* self);
ValaInterface* vala_interface_construct (GType object_type, const char* name, ValaSourceReference* source_reference);
ValaInterface* vala_interface_new (const char* name, ValaSourceReference* source_reference);
void vala_interface_add_type_parameter (ValaInterface* self, ValaTypeParameter* p);
GeeList* vala_interface_get_type_parameters (ValaInterface* self);
void vala_interface_add_prerequisite (ValaInterface* self, ValaDataType* type);
void vala_interface_prepend_prerequisite (ValaInterface* self, ValaDataType* type);
GeeList* vala_interface_get_prerequisites (ValaInterface* self);
void vala_interface_add_method (ValaInterface* self, ValaMethod* m);
void vala_interface_add_field (ValaInterface* self, ValaField* f);
GeeList* vala_interface_get_fields (ValaInterface* self);
void vala_interface_add_property (ValaInterface* self, ValaProperty* prop);
void vala_interface_add_signal (ValaInterface* self, ValaSignal* sig);
void vala_interface_add_class (ValaInterface* self, ValaClass* cl);
void vala_interface_add_struct (ValaInterface* self, ValaStruct* st);
void vala_interface_add_enum (ValaInterface* self, ValaEnum* en);
void vala_interface_add_delegate (ValaInterface* self, ValaDelegate* d);
char* vala_interface_get_lower_case_csuffix (ValaInterface* self);
char* vala_interface_get_default_lower_case_csuffix (ValaInterface* self);
void vala_interface_set_lower_case_csuffix (ValaInterface* self, const char* csuffix);
void vala_interface_process_attributes (ValaInterface* self);
char* vala_interface_get_type_cname (ValaInterface* self);
void vala_interface_set_type_cname (ValaInterface* self, const char* type_cname);
gboolean vala_interface_get_is_static (ValaInterface* self);
void vala_interface_set_is_static (ValaInterface* self, gboolean value);
GType vala_interface_get_type (void);


G_END_DECLS

#endif
