/* valaintegertype.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaintegertype.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valastruct.h>
#include <vala/valacodenode.h>
#include <vala/valaattribute.h>
#include <vala/valaenum.h>




struct _ValaIntegerTypePrivate {
	ValaIntegerLiteral* _literal;
};

#define VALA_INTEGER_TYPE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_INTEGER_TYPE, ValaIntegerTypePrivate))
enum  {
	VALA_INTEGER_TYPE_DUMMY_PROPERTY
};
static ValaDataType* vala_integer_type_real_copy (ValaDataType* base);
static gboolean vala_integer_type_real_compatible (ValaDataType* base, ValaDataType* target_type);
static gpointer vala_integer_type_parent_class = NULL;
static void vala_integer_type_finalize (ValaCodeNode* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaIntegerType* vala_integer_type_construct (GType object_type, ValaTypeSymbol* type_symbol) {
	ValaIntegerType* self;
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (type_symbol), NULL);
	self = ((ValaIntegerType*) (g_type_create_instance (object_type)));
	vala_value_type_set_type_symbol (VALA_VALUE_TYPE (self), type_symbol);
	vala_data_type_set_data_type (VALA_DATA_TYPE (self), type_symbol);
	return self;
}


ValaIntegerType* vala_integer_type_new (ValaTypeSymbol* type_symbol) {
	return vala_integer_type_construct (VALA_TYPE_INTEGER_TYPE, type_symbol);
}


static ValaDataType* vala_integer_type_real_copy (ValaDataType* base) {
	ValaIntegerType * self;
	ValaIntegerType* type;
	self = VALA_INTEGER_TYPE (base);
	type = vala_integer_type_new (vala_value_type_get_type_symbol (VALA_VALUE_TYPE (self)));
	vala_integer_type_set_literal (type, self->priv->_literal);
	vala_data_type_set_is_type_argument (VALA_DATA_TYPE (type), vala_data_type_get_is_type_argument (VALA_DATA_TYPE (self)));
	return VALA_DATA_TYPE (type);
}


static gboolean vala_integer_type_real_compatible (ValaDataType* base, ValaDataType* target_type) {
	ValaIntegerType * self;
	char* _tmp0;
	gboolean _tmp1;
	self = VALA_INTEGER_TYPE (base);
	g_return_val_if_fail (VALA_IS_DATA_TYPE (target_type), FALSE);
	_tmp0 = NULL;
	if ((_tmp1 = VALA_IS_STRUCT (vala_data_type_get_data_type (target_type)) && _vala_strcmp0 ((_tmp0 = vala_integer_literal_get_type_name (self->priv->_literal)), "int") == 0, (_tmp0 = (g_free (_tmp0), NULL)), _tmp1)) {
		ValaStruct* _tmp2;
		ValaStruct* target_st;
		/* int literals are implicitly convertible to integer types
		 of a lower rank if the value of the literal is within
		 the range of the target type*/
		_tmp2 = NULL;
		target_st = (_tmp2 = VALA_STRUCT (vala_data_type_get_data_type (target_type)), (_tmp2 == NULL ? NULL : vala_code_node_ref (_tmp2)));
		if (vala_struct_is_integer_type (target_st)) {
			ValaAttribute* int_attr;
			int_attr = vala_code_node_get_attribute (VALA_CODE_NODE (target_st), "IntegerType");
			if (int_attr != NULL && vala_attribute_has_argument (int_attr, "min") && vala_attribute_has_argument (int_attr, "max")) {
				gint val;
				gboolean _tmp3;
				val = atoi (vala_integer_literal_get_value (self->priv->_literal));
				return (_tmp3 = (val >= vala_attribute_get_integer (int_attr, "min") && val <= vala_attribute_get_integer (int_attr, "max")), (int_attr == NULL ? NULL : (int_attr = (vala_code_node_unref (int_attr), NULL))), (target_st == NULL ? NULL : (target_st = (vala_code_node_unref (target_st), NULL))), _tmp3);
			} else {
				gboolean _tmp4;
				/* assume to be compatible if the target type doesn't specify limits*/
				return (_tmp4 = TRUE, (int_attr == NULL ? NULL : (int_attr = (vala_code_node_unref (int_attr), NULL))), (target_st == NULL ? NULL : (target_st = (vala_code_node_unref (target_st), NULL))), _tmp4);
			}
			(int_attr == NULL ? NULL : (int_attr = (vala_code_node_unref (int_attr), NULL)));
		}
		(target_st == NULL ? NULL : (target_st = (vala_code_node_unref (target_st), NULL)));
	} else {
		char* _tmp5;
		gboolean _tmp6;
		_tmp5 = NULL;
		if ((_tmp6 = VALA_IS_ENUM (vala_data_type_get_data_type (target_type)) && _vala_strcmp0 ((_tmp5 = vala_integer_literal_get_type_name (self->priv->_literal)), "int") == 0, (_tmp5 = (g_free (_tmp5), NULL)), _tmp6)) {
			/* allow implicit conversion from 0 to enum and flags types*/
			if (atoi (vala_integer_literal_get_value (self->priv->_literal)) == 0) {
				return TRUE;
			}
		}
	}
	return VALA_DATA_TYPE_CLASS (vala_integer_type_parent_class)->compatible (VALA_DATA_TYPE (VALA_VALUE_TYPE (self)), target_type);
}


ValaIntegerLiteral* vala_integer_type_get_literal (ValaIntegerType* self) {
	g_return_val_if_fail (VALA_IS_INTEGER_TYPE (self), NULL);
	return self->priv->_literal;
}


void vala_integer_type_set_literal (ValaIntegerType* self, ValaIntegerLiteral* value) {
	ValaIntegerLiteral* _tmp2;
	ValaIntegerLiteral* _tmp1;
	g_return_if_fail (VALA_IS_INTEGER_TYPE (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_literal = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_literal == NULL ? NULL : (self->priv->_literal = (vala_code_node_unref (self->priv->_literal), NULL))), _tmp2);
}


static void vala_integer_type_class_init (ValaIntegerTypeClass * klass) {
	vala_integer_type_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_integer_type_finalize;
	g_type_class_add_private (klass, sizeof (ValaIntegerTypePrivate));
	VALA_DATA_TYPE_CLASS (klass)->copy = vala_integer_type_real_copy;
	VALA_DATA_TYPE_CLASS (klass)->compatible = vala_integer_type_real_compatible;
}


static void vala_integer_type_instance_init (ValaIntegerType * self) {
	self->priv = VALA_INTEGER_TYPE_GET_PRIVATE (self);
}


static void vala_integer_type_finalize (ValaCodeNode* obj) {
	ValaIntegerType * self;
	self = VALA_INTEGER_TYPE (obj);
	(self->priv->_literal == NULL ? NULL : (self->priv->_literal = (vala_code_node_unref (self->priv->_literal), NULL)));
	VALA_CODE_NODE_CLASS (vala_integer_type_parent_class)->finalize (obj);
}


GType vala_integer_type_get_type (void) {
	static GType vala_integer_type_type_id = 0;
	if (vala_integer_type_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaIntegerTypeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_integer_type_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaIntegerType), 0, (GInstanceInitFunc) vala_integer_type_instance_init, NULL };
		vala_integer_type_type_id = g_type_register_static (VALA_TYPE_VALUE_TYPE, "ValaIntegerType", &g_define_type_info, 0);
	}
	return vala_integer_type_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




