/* valadeclarationstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valadeclarationstatement.h>
#include <vala/valasymbol.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>




struct _ValaDeclarationStatementPrivate {
	ValaSymbol* _declaration;
};

#define VALA_DECLARATION_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_DECLARATION_STATEMENT, ValaDeclarationStatementPrivate))
enum  {
	VALA_DECLARATION_STATEMENT_DUMMY_PROPERTY
};
static void vala_declaration_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gpointer vala_declaration_statement_parent_class = NULL;
static ValaStatementIface* vala_declaration_statement_vala_statement_parent_iface = NULL;
static void vala_declaration_statement_finalize (ValaCodeNode* obj);



/**
 * Creates a new declaration statement.
 *
 * @param decl   local variable declaration
 * @param source reference to source code
 * @return       newly created declaration statement
 */
ValaDeclarationStatement* vala_declaration_statement_construct (GType object_type, ValaSymbol* declaration, ValaSourceReference* source_reference) {
	ValaDeclarationStatement* self;
	g_return_val_if_fail (VALA_IS_SYMBOL (declaration), NULL);
	g_return_val_if_fail (source_reference == NULL || VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaDeclarationStatement*) (g_type_create_instance (object_type)));
	vala_declaration_statement_set_declaration (self, declaration);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


ValaDeclarationStatement* vala_declaration_statement_new (ValaSymbol* declaration, ValaSourceReference* source_reference) {
	return vala_declaration_statement_construct (VALA_TYPE_DECLARATION_STATEMENT, declaration, source_reference);
}


static void vala_declaration_statement_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_node_accept (VALA_CODE_NODE (self->priv->_declaration), visitor);
	vala_code_visitor_visit_declaration_statement (visitor, self);
}


ValaSymbol* vala_declaration_statement_get_declaration (ValaDeclarationStatement* self) {
	g_return_val_if_fail (VALA_IS_DECLARATION_STATEMENT (self), NULL);
	return self->priv->_declaration;
}


void vala_declaration_statement_set_declaration (ValaDeclarationStatement* self, ValaSymbol* value) {
	ValaSymbol* _tmp2;
	ValaSymbol* _tmp1;
	g_return_if_fail (VALA_IS_DECLARATION_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_declaration = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_declaration == NULL ? NULL : (self->priv->_declaration = (vala_code_node_unref (self->priv->_declaration), NULL))), _tmp2);
}


static void vala_declaration_statement_class_init (ValaDeclarationStatementClass * klass) {
	vala_declaration_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_declaration_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaDeclarationStatementPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept = vala_declaration_statement_real_accept;
}


static void vala_declaration_statement_vala_statement_interface_init (ValaStatementIface * iface) {
	vala_declaration_statement_vala_statement_parent_iface = g_type_interface_peek_parent (iface);
}


static void vala_declaration_statement_instance_init (ValaDeclarationStatement * self) {
	self->priv = VALA_DECLARATION_STATEMENT_GET_PRIVATE (self);
}


static void vala_declaration_statement_finalize (ValaCodeNode* obj) {
	ValaDeclarationStatement * self;
	self = VALA_DECLARATION_STATEMENT (obj);
	(self->priv->_declaration == NULL ? NULL : (self->priv->_declaration = (vala_code_node_unref (self->priv->_declaration), NULL)));
	VALA_CODE_NODE_CLASS (vala_declaration_statement_parent_class)->finalize (obj);
}


GType vala_declaration_statement_get_type (void) {
	static GType vala_declaration_statement_type_id = 0;
	if (vala_declaration_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaDeclarationStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_declaration_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaDeclarationStatement), 0, (GInstanceInitFunc) vala_declaration_statement_instance_init, NULL };
		static const GInterfaceInfo vala_statement_info = { (GInterfaceInitFunc) vala_declaration_statement_vala_statement_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		vala_declaration_statement_type_id = g_type_register_static (VALA_TYPE_CODE_NODE, "ValaDeclarationStatement", &g_define_type_info, 0);
		g_type_add_interface_static (vala_declaration_statement_type_id, VALA_TYPE_STATEMENT, &vala_statement_info);
	}
	return vala_declaration_statement_type_id;
}




