/* valacodebinding.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valacodebinding.h>
#include <gobject/gvaluecollector.h>




enum  {
	VALA_CODE_BINDING_DUMMY_PROPERTY
};
static gpointer vala_code_binding_parent_class = NULL;
static void vala_code_binding_finalize (ValaCodeBinding* obj);



static void vala_value_code_binding_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void vala_value_code_binding_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		vala_code_binding_unref (value->data[0].v_pointer);
	}
}


static void vala_value_code_binding_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_code_binding_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer vala_value_code_binding_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* vala_value_code_binding_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ValaCodeBinding* object;
		object = value->data[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_OBJECT_TYPE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", G_OBJECT_TYPE (object), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* vala_value_code_binding_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ValaCodeBinding** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags && G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_code_binding_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* vala_param_spec_code_binding (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ValaParamSpecCodeBinding* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_CODE_BINDING), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer vala_value_get_code_binding (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_BINDING), NULL);
	return value->data[0].v_pointer;
}


void vala_value_set_code_binding (GValue* value, gpointer v_object) {
	ValaCodeBinding* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_CODE_BINDING));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_CODE_BINDING));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_code_binding_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_code_binding_unref (old);
	}
}


static void vala_code_binding_class_init (ValaCodeBindingClass * klass) {
	vala_code_binding_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_BINDING_CLASS (klass)->finalize = vala_code_binding_finalize;
}


static void vala_code_binding_instance_init (ValaCodeBinding * self) {
	self->ref_count = 1;
}


static void vala_code_binding_finalize (ValaCodeBinding* obj) {
	ValaCodeBinding * self;
	self = VALA_CODE_BINDING (obj);
}


GType vala_code_binding_get_type (void) {
	static GType vala_code_binding_type_id = 0;
	if (vala_code_binding_type_id == 0) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_code_binding_init, vala_value_code_binding_free_value, vala_value_code_binding_copy_value, vala_value_code_binding_peek_pointer, "p", vala_value_code_binding_collect_value, "p", vala_value_code_binding_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaCodeBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_code_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCodeBinding), 0, (GInstanceInitFunc) vala_code_binding_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		vala_code_binding_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaCodeBinding", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_code_binding_type_id;
}


gpointer vala_code_binding_ref (gpointer instance) {
	ValaCodeBinding* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void vala_code_binding_unref (gpointer instance) {
	ValaCodeBinding* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_CODE_BINDING_GET_CLASS (self)->finalize (self);
		g_type_free_instance (((GTypeInstance *) (self)));
	}
}




