/* valaarraycreationexpression.vala
 *
 * Copyright (C) 2006-2008  Raffaele Sandrini, Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Raffaele Sandrini <raffaele@sandrini.ch>
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <vala/valaarraycreationexpression.h>
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <gee/readonlylist.h>
#include <vala/valainitializerlist.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <vala/valacodevisitor.h>
#include <vala/valacodegenerator.h>




struct _ValaArrayCreationExpressionPrivate {
	gint _rank;
	GeeList* sizes;
	ValaInitializerList* _initializer_list;
	ValaDataType* _element_type;
};

#define VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_ARRAY_CREATION_EXPRESSION, ValaArrayCreationExpressionPrivate))
enum  {
	VALA_ARRAY_CREATION_EXPRESSION_DUMMY_PROPERTY
};
static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor);
static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor);
static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base);
static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type);
static ValaCodeBinding* vala_array_creation_expression_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen);
static gpointer vala_array_creation_expression_parent_class = NULL;
static void vala_array_creation_expression_finalize (ValaCodeNode* obj);



/**
 * Add a size expression.
 */
void vala_array_creation_expression_append_size (ValaArrayCreationExpression* self, ValaExpression* size) {
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	g_return_if_fail (VALA_IS_EXPRESSION (size));
	gee_collection_add (GEE_COLLECTION (self->priv->sizes), size);
}


/**
 * Get the sizes for all dimensions ascending from left to right.
 */
GeeList* vala_array_creation_expression_get_sizes (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return GEE_LIST (gee_read_only_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, self->priv->sizes));
}


ValaArrayCreationExpression* vala_array_creation_expression_construct (GType object_type, ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	ValaArrayCreationExpression* self;
	g_return_val_if_fail (VALA_IS_DATA_TYPE (element_type), NULL);
	g_return_val_if_fail (initializer_list == NULL || VALA_IS_INITIALIZER_LIST (initializer_list), NULL);
	g_return_val_if_fail (VALA_IS_SOURCE_REFERENCE (source_reference), NULL);
	self = ((ValaArrayCreationExpression*) (g_type_create_instance (object_type)));
	vala_array_creation_expression_set_element_type (self, element_type);
	vala_array_creation_expression_set_rank (self, rank);
	vala_array_creation_expression_set_initializer_list (self, initializer_list);
	vala_code_node_set_source_reference (VALA_CODE_NODE (self), source_reference);
	return self;
}


ValaArrayCreationExpression* vala_array_creation_expression_new (ValaDataType* element_type, gint rank, ValaInitializerList* initializer_list, ValaSourceReference* source_reference) {
	return vala_array_creation_expression_construct (VALA_TYPE_ARRAY_CREATION_EXPRESSION, element_type, rank, initializer_list, source_reference);
}


static void vala_array_creation_expression_real_accept_children (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	if (vala_array_creation_expression_get_element_type (self) != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (vala_array_creation_expression_get_element_type (self)), visitor);
	}
	{
		GeeList* e_collection;
		int e_it;
		e_collection = self->priv->sizes;
		for (e_it = 0; e_it < gee_collection_get_size (GEE_COLLECTION (e_collection)); e_it = e_it + 1) {
			ValaExpression* e;
			e = ((ValaExpression*) (gee_list_get (GEE_LIST (e_collection), e_it)));
			{
				vala_code_node_accept (VALA_CODE_NODE (e), visitor);
				(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
			}
		}
	}
	if (self->priv->_initializer_list != NULL) {
		vala_code_node_accept (VALA_CODE_NODE (self->priv->_initializer_list), visitor);
	}
}


static void vala_array_creation_expression_real_accept (ValaCodeNode* base, ValaCodeVisitor* visitor) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_CODE_VISITOR (visitor));
	vala_code_visitor_visit_array_creation_expression (visitor, self);
	vala_code_visitor_visit_expression (visitor, VALA_EXPRESSION (self));
}


static gboolean vala_array_creation_expression_real_is_pure (ValaExpression* base) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	return FALSE;
}


static void vala_array_creation_expression_real_replace_type (ValaCodeNode* base, ValaDataType* old_type, ValaDataType* new_type) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_if_fail (VALA_IS_DATA_TYPE (old_type));
	g_return_if_fail (VALA_IS_DATA_TYPE (new_type));
	if (vala_array_creation_expression_get_element_type (self) == old_type) {
		vala_array_creation_expression_set_element_type (self, new_type);
	}
}


static ValaCodeBinding* vala_array_creation_expression_real_create_code_binding (ValaCodeNode* base, ValaCodeGenerator* codegen) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (base);
	g_return_val_if_fail (VALA_IS_CODE_GENERATOR (codegen), NULL);
	return vala_code_generator_create_array_creation_expression_binding (codegen, self);
}


ValaDataType* vala_array_creation_expression_get_element_type (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return self->priv->_element_type;
}


void vala_array_creation_expression_set_element_type (ValaArrayCreationExpression* self, ValaDataType* value) {
	ValaDataType* _tmp2;
	ValaDataType* _tmp1;
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_element_type = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL))), _tmp2);
	vala_code_node_set_parent_node (VALA_CODE_NODE (self->priv->_element_type), VALA_CODE_NODE (self));
}


gint vala_array_creation_expression_get_rank (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), 0);
	return self->priv->_rank;
}


void vala_array_creation_expression_set_rank (ValaArrayCreationExpression* self, gint value) {
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	self->priv->_rank = value;
}


ValaInitializerList* vala_array_creation_expression_get_initializer_list (ValaArrayCreationExpression* self) {
	g_return_val_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self), NULL);
	return self->priv->_initializer_list;
}


void vala_array_creation_expression_set_initializer_list (ValaArrayCreationExpression* self, ValaInitializerList* value) {
	ValaInitializerList* _tmp2;
	ValaInitializerList* _tmp1;
	g_return_if_fail (VALA_IS_ARRAY_CREATION_EXPRESSION (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_initializer_list = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_code_node_ref (_tmp1))), (self->priv->_initializer_list == NULL ? NULL : (self->priv->_initializer_list = (vala_code_node_unref (self->priv->_initializer_list), NULL))), _tmp2);
}


static void vala_array_creation_expression_class_init (ValaArrayCreationExpressionClass * klass) {
	vala_array_creation_expression_parent_class = g_type_class_peek_parent (klass);
	VALA_CODE_NODE_CLASS (klass)->finalize = vala_array_creation_expression_finalize;
	g_type_class_add_private (klass, sizeof (ValaArrayCreationExpressionPrivate));
	VALA_CODE_NODE_CLASS (klass)->accept_children = vala_array_creation_expression_real_accept_children;
	VALA_CODE_NODE_CLASS (klass)->accept = vala_array_creation_expression_real_accept;
	VALA_EXPRESSION_CLASS (klass)->is_pure = vala_array_creation_expression_real_is_pure;
	VALA_CODE_NODE_CLASS (klass)->replace_type = vala_array_creation_expression_real_replace_type;
	VALA_CODE_NODE_CLASS (klass)->create_code_binding = vala_array_creation_expression_real_create_code_binding;
}


static void vala_array_creation_expression_instance_init (ValaArrayCreationExpression * self) {
	self->priv = VALA_ARRAY_CREATION_EXPRESSION_GET_PRIVATE (self);
	self->priv->sizes = GEE_LIST (gee_array_list_new (VALA_TYPE_EXPRESSION, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal));
}


static void vala_array_creation_expression_finalize (ValaCodeNode* obj) {
	ValaArrayCreationExpression * self;
	self = VALA_ARRAY_CREATION_EXPRESSION (obj);
	(self->priv->sizes == NULL ? NULL : (self->priv->sizes = (gee_collection_object_unref (self->priv->sizes), NULL)));
	(self->priv->_initializer_list == NULL ? NULL : (self->priv->_initializer_list = (vala_code_node_unref (self->priv->_initializer_list), NULL)));
	(self->priv->_element_type == NULL ? NULL : (self->priv->_element_type = (vala_code_node_unref (self->priv->_element_type), NULL)));
	VALA_CODE_NODE_CLASS (vala_array_creation_expression_parent_class)->finalize (obj);
}


GType vala_array_creation_expression_get_type (void) {
	static GType vala_array_creation_expression_type_id = 0;
	if (vala_array_creation_expression_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaArrayCreationExpressionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_array_creation_expression_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaArrayCreationExpression), 0, (GInstanceInitFunc) vala_array_creation_expression_instance_init, NULL };
		vala_array_creation_expression_type_id = g_type_register_static (VALA_TYPE_EXPRESSION, "ValaArrayCreationExpression", &g_define_type_info, 0);
	}
	return vala_array_creation_expression_type_id;
}




