/* valaccodetypesymbolbinding.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <gobject/valaccodetypesymbolbinding.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodeconstant.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valadatatype.h>
#include <vala/valaclass.h>
#include <vala/valainterface.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valaenum.h>
#include <vala/valacodenode.h>
#include <vala/valastruct.h>
#include <vala/valapropertyaccessor.h>
#include <gee/list.h>
#include <vala/valapointertype.h>
#include <vala/valaerrortype.h>
#include <vala/valaformalparameter.h>
#include <vala/valaarraytype.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_TYPE_SYMBOL_BINDING_DUMMY_PROPERTY
};
static gpointer vala_ccode_type_symbol_binding_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



ValaCCodeFunctionCall* vala_ccode_type_symbol_binding_get_param_spec (ValaCCodeTypeSymbolBinding* self, ValaProperty* prop) {
	ValaCCodeFunctionCall* cspec;
	ValaCCodeConstant* _tmp0;
	ValaCCodeConstant* _tmp2;
	char* _tmp1;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	char* pflags;
	ValaCCodeConstant* _tmp100;
	ValaCCodeFunctionCall* _tmp101;
	g_return_val_if_fail (VALA_IS_CCODE_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_PROPERTY (prop), NULL);
	cspec = vala_ccode_function_call_new (NULL);
	_tmp0 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp0 = vala_property_get_canonical_cconstant (prop))));
	(_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL)));
	_tmp2 = NULL;
	_tmp1 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp2 = vala_ccode_constant_new ((_tmp1 = g_strdup_printf ("\"%s\"", vala_property_get_nick (prop)))))));
	(_tmp2 == NULL ? NULL : (_tmp2 = (vala_ccode_node_unref (_tmp2), NULL)));
	_tmp1 = (g_free (_tmp1), NULL);
	_tmp4 = NULL;
	_tmp3 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = g_strdup_printf ("\"%s\"", vala_property_get_blurb (prop)))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	if ((VALA_IS_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop))) && !(vala_class_get_is_compact ((VALA_CLASS (vala_data_type_get_data_type (vala_property_get_property_type (prop))))))) || VALA_IS_INTERFACE (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
		char* param_spec_name;
		param_spec_name = vala_typesymbol_get_param_spec_function (vala_data_type_get_data_type (vala_property_get_property_type (prop)));
		if (param_spec_name == NULL) {
			ValaCCodeIdentifier* _tmp5;
			_tmp5 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp5 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
			(_tmp5 == NULL ? NULL : (_tmp5 = (vala_ccode_node_unref (_tmp5), NULL)));
		} else {
			ValaCCodeIdentifier* _tmp6;
			ValaCCodeIdentifier* _tmp8;
			char* _tmp7;
			_tmp6 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new (param_spec_name))));
			(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
			_tmp8 = NULL;
			_tmp7 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_identifier_new ((_tmp7 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_property_get_property_type (prop))))))));
			(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
			_tmp7 = (g_free (_tmp7), NULL);
		}
		param_spec_name = (g_free (param_spec_name), NULL);
	} else {
		if (vala_data_type_get_data_type (vala_property_get_property_type (prop)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeIdentifier* _tmp9;
			ValaCCodeConstant* _tmp10;
			_tmp9 = NULL;
			vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_identifier_new ("g_param_spec_string"))));
			(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
			_tmp10 = NULL;
			vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("NULL"))));
			(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
		} else {
			if (VALA_IS_ENUM (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
				ValaEnum* _tmp12;
				ValaTypeSymbol* _tmp11;
				ValaEnum* e;
				_tmp12 = NULL;
				_tmp11 = NULL;
				e = (_tmp12 = (_tmp11 = vala_data_type_get_data_type (vala_property_get_property_type (prop)), (VALA_IS_ENUM (_tmp11) ? ((ValaEnum*) (_tmp11)) : NULL)), (_tmp12 == NULL ? NULL : vala_code_node_ref (_tmp12)));
				if (vala_enum_get_has_type_id (e)) {
					ValaCCodeIdentifier* _tmp16;
					char* _tmp15;
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp13;
						_tmp13 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_identifier_new ("g_param_spec_flags"))));
						(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp14;
						_tmp14 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_identifier_new ("g_param_spec_enum"))));
						(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
					}
					_tmp16 = NULL;
					_tmp15 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp16 = vala_ccode_identifier_new ((_tmp15 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (e)))))));
					(_tmp16 == NULL ? NULL : (_tmp16 = (vala_ccode_node_unref (_tmp16), NULL)));
					_tmp15 = (g_free (_tmp15), NULL);
				} else {
					if (vala_enum_get_is_flags (e)) {
						ValaCCodeIdentifier* _tmp17;
						ValaCCodeConstant* _tmp18;
						ValaCCodeConstant* _tmp19;
						_tmp17 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_identifier_new ("g_param_spec_uint"))));
						(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
						_tmp18 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp18 = vala_ccode_constant_new ("0"))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
						_tmp19 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ("G_MAXUINT"))));
						(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp20;
						ValaCCodeConstant* _tmp21;
						ValaCCodeConstant* _tmp22;
						_tmp20 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_identifier_new ("g_param_spec_int"))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("G_MININT"))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
						_tmp22 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("G_MAXINT"))));
						(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
					}
				}
				if (vala_property_get_default_expression (prop) != NULL) {
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
				} else {
					ValaCCodeConstant* _tmp24;
					char* _tmp23;
					_tmp24 = NULL;
					_tmp23 = NULL;
					vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_constant_new ((_tmp23 = vala_typesymbol_get_default_value (vala_data_type_get_data_type (vala_property_get_property_type (prop))))))));
					(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
					_tmp23 = (g_free (_tmp23), NULL);
				}
				(e == NULL ? NULL : (e = (vala_code_node_unref (e), NULL)));
			} else {
				if (VALA_IS_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop)))) {
					ValaStruct* _tmp25;
					ValaStruct* st;
					char* _tmp26;
					gboolean _tmp27;
					_tmp25 = NULL;
					st = (_tmp25 = VALA_STRUCT (vala_data_type_get_data_type (vala_property_get_property_type (prop))), (_tmp25 == NULL ? NULL : vala_code_node_ref (_tmp25)));
					_tmp26 = NULL;
					if ((_tmp27 = _vala_strcmp0 ((_tmp26 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_INT") == 0, (_tmp26 = (g_free (_tmp26), NULL)), _tmp27)) {
						ValaCCodeIdentifier* _tmp28;
						ValaCCodeConstant* _tmp29;
						ValaCCodeConstant* _tmp30;
						_tmp28 = NULL;
						vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ("g_param_spec_int"))));
						(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
						_tmp29 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp29 = vala_ccode_constant_new ("G_MININT"))));
						(_tmp29 == NULL ? NULL : (_tmp29 = (vala_ccode_node_unref (_tmp29), NULL)));
						_tmp30 = NULL;
						vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp30 = vala_ccode_constant_new ("G_MAXINT"))));
						(_tmp30 == NULL ? NULL : (_tmp30 = (vala_ccode_node_unref (_tmp30), NULL)));
						if (vala_property_get_default_expression (prop) != NULL) {
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
						} else {
							ValaCCodeConstant* _tmp31;
							_tmp31 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_constant_new ("0"))));
							(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
						}
					} else {
						char* _tmp32;
						gboolean _tmp33;
						_tmp32 = NULL;
						if ((_tmp33 = _vala_strcmp0 ((_tmp32 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_UINT") == 0, (_tmp32 = (g_free (_tmp32), NULL)), _tmp33)) {
							ValaCCodeIdentifier* _tmp34;
							ValaCCodeConstant* _tmp35;
							ValaCCodeConstant* _tmp36;
							_tmp34 = NULL;
							vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp34 = vala_ccode_identifier_new ("g_param_spec_uint"))));
							(_tmp34 == NULL ? NULL : (_tmp34 = (vala_ccode_node_unref (_tmp34), NULL)));
							_tmp35 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp35 = vala_ccode_constant_new ("0"))));
							(_tmp35 == NULL ? NULL : (_tmp35 = (vala_ccode_node_unref (_tmp35), NULL)));
							_tmp36 = NULL;
							vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp36 = vala_ccode_constant_new ("G_MAXUINT"))));
							(_tmp36 == NULL ? NULL : (_tmp36 = (vala_ccode_node_unref (_tmp36), NULL)));
							if (vala_property_get_default_expression (prop) != NULL) {
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
							} else {
								ValaCCodeConstant* _tmp37;
								_tmp37 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp37 = vala_ccode_constant_new ("0U"))));
								(_tmp37 == NULL ? NULL : (_tmp37 = (vala_ccode_node_unref (_tmp37), NULL)));
							}
						} else {
							char* _tmp38;
							gboolean _tmp39;
							_tmp38 = NULL;
							if ((_tmp39 = _vala_strcmp0 ((_tmp38 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_INT64") == 0, (_tmp38 = (g_free (_tmp38), NULL)), _tmp39)) {
								ValaCCodeIdentifier* _tmp40;
								ValaCCodeConstant* _tmp41;
								ValaCCodeConstant* _tmp42;
								_tmp40 = NULL;
								vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ("g_param_spec_int64"))));
								(_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL)));
								_tmp41 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp41 = vala_ccode_constant_new ("G_MININT64"))));
								(_tmp41 == NULL ? NULL : (_tmp41 = (vala_ccode_node_unref (_tmp41), NULL)));
								_tmp42 = NULL;
								vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp42 = vala_ccode_constant_new ("G_MAXINT64"))));
								(_tmp42 == NULL ? NULL : (_tmp42 = (vala_ccode_node_unref (_tmp42), NULL)));
								if (vala_property_get_default_expression (prop) != NULL) {
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
								} else {
									ValaCCodeConstant* _tmp43;
									_tmp43 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_constant_new ("0"))));
									(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
								}
							} else {
								char* _tmp44;
								gboolean _tmp45;
								_tmp44 = NULL;
								if ((_tmp45 = _vala_strcmp0 ((_tmp44 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_UINT64") == 0, (_tmp44 = (g_free (_tmp44), NULL)), _tmp45)) {
									ValaCCodeIdentifier* _tmp46;
									ValaCCodeConstant* _tmp47;
									ValaCCodeConstant* _tmp48;
									_tmp46 = NULL;
									vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_identifier_new ("g_param_spec_uint64"))));
									(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
									_tmp47 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_constant_new ("0"))));
									(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
									_tmp48 = NULL;
									vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_constant_new ("G_MAXUINT64"))));
									(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
									if (vala_property_get_default_expression (prop) != NULL) {
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
									} else {
										ValaCCodeConstant* _tmp49;
										_tmp49 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_constant_new ("0U"))));
										(_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL)));
									}
								} else {
									char* _tmp50;
									gboolean _tmp51;
									_tmp50 = NULL;
									if ((_tmp51 = _vala_strcmp0 ((_tmp50 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_LONG") == 0, (_tmp50 = (g_free (_tmp50), NULL)), _tmp51)) {
										ValaCCodeIdentifier* _tmp52;
										ValaCCodeConstant* _tmp53;
										ValaCCodeConstant* _tmp54;
										_tmp52 = NULL;
										vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp52 = vala_ccode_identifier_new ("g_param_spec_long"))));
										(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
										_tmp53 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp53 = vala_ccode_constant_new ("G_MINLONG"))));
										(_tmp53 == NULL ? NULL : (_tmp53 = (vala_ccode_node_unref (_tmp53), NULL)));
										_tmp54 = NULL;
										vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp54 = vala_ccode_constant_new ("G_MAXLONG"))));
										(_tmp54 == NULL ? NULL : (_tmp54 = (vala_ccode_node_unref (_tmp54), NULL)));
										if (vala_property_get_default_expression (prop) != NULL) {
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
										} else {
											ValaCCodeConstant* _tmp55;
											_tmp55 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp55 = vala_ccode_constant_new ("0L"))));
											(_tmp55 == NULL ? NULL : (_tmp55 = (vala_ccode_node_unref (_tmp55), NULL)));
										}
									} else {
										char* _tmp56;
										gboolean _tmp57;
										_tmp56 = NULL;
										if ((_tmp57 = _vala_strcmp0 ((_tmp56 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_ULONG") == 0, (_tmp56 = (g_free (_tmp56), NULL)), _tmp57)) {
											ValaCCodeIdentifier* _tmp58;
											ValaCCodeConstant* _tmp59;
											ValaCCodeConstant* _tmp60;
											_tmp58 = NULL;
											vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp58 = vala_ccode_identifier_new ("g_param_spec_ulong"))));
											(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
											_tmp59 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp59 = vala_ccode_constant_new ("0"))));
											(_tmp59 == NULL ? NULL : (_tmp59 = (vala_ccode_node_unref (_tmp59), NULL)));
											_tmp60 = NULL;
											vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_constant_new ("G_MAXULONG"))));
											(_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL)));
											if (vala_property_get_default_expression (prop) != NULL) {
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
											} else {
												ValaCCodeConstant* _tmp61;
												_tmp61 = NULL;
												vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp61 = vala_ccode_constant_new ("0UL"))));
												(_tmp61 == NULL ? NULL : (_tmp61 = (vala_ccode_node_unref (_tmp61), NULL)));
											}
										} else {
											char* _tmp62;
											gboolean _tmp63;
											_tmp62 = NULL;
											if ((_tmp63 = _vala_strcmp0 ((_tmp62 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_BOOLEAN") == 0, (_tmp62 = (g_free (_tmp62), NULL)), _tmp63)) {
												ValaCCodeIdentifier* _tmp64;
												_tmp64 = NULL;
												vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp64 = vala_ccode_identifier_new ("g_param_spec_boolean"))));
												(_tmp64 == NULL ? NULL : (_tmp64 = (vala_ccode_node_unref (_tmp64), NULL)));
												if (vala_property_get_default_expression (prop) != NULL) {
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
												} else {
													ValaCCodeConstant* _tmp65;
													_tmp65 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_constant_new ("FALSE"))));
													(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
												}
											} else {
												char* _tmp66;
												gboolean _tmp67;
												_tmp66 = NULL;
												if ((_tmp67 = _vala_strcmp0 ((_tmp66 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_CHAR") == 0, (_tmp66 = (g_free (_tmp66), NULL)), _tmp67)) {
													ValaCCodeIdentifier* _tmp68;
													ValaCCodeConstant* _tmp69;
													ValaCCodeConstant* _tmp70;
													_tmp68 = NULL;
													vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new ("g_param_spec_char"))));
													(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
													_tmp69 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp69 = vala_ccode_constant_new ("G_MININT8"))));
													(_tmp69 == NULL ? NULL : (_tmp69 = (vala_ccode_node_unref (_tmp69), NULL)));
													_tmp70 = NULL;
													vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_constant_new ("G_MAXINT8"))));
													(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
													if (vala_property_get_default_expression (prop) != NULL) {
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
													} else {
														ValaCCodeConstant* _tmp71;
														_tmp71 = NULL;
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_constant_new ("0"))));
														(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
													}
												} else {
													char* _tmp72;
													gboolean _tmp73;
													_tmp72 = NULL;
													if ((_tmp73 = _vala_strcmp0 ((_tmp72 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_UCHAR") == 0, (_tmp72 = (g_free (_tmp72), NULL)), _tmp73)) {
														ValaCCodeIdentifier* _tmp74;
														ValaCCodeConstant* _tmp75;
														ValaCCodeConstant* _tmp76;
														_tmp74 = NULL;
														vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_identifier_new ("g_param_spec_uchar"))));
														(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
														_tmp75 = NULL;
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp75 = vala_ccode_constant_new ("0"))));
														(_tmp75 == NULL ? NULL : (_tmp75 = (vala_ccode_node_unref (_tmp75), NULL)));
														_tmp76 = NULL;
														vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_constant_new ("G_MAXUINT8"))));
														(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
														if (vala_property_get_default_expression (prop) != NULL) {
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
														} else {
															ValaCCodeConstant* _tmp77;
															_tmp77 = NULL;
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_constant_new ("0"))));
															(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
														}
													} else {
														char* _tmp78;
														gboolean _tmp79;
														_tmp78 = NULL;
														if ((_tmp79 = _vala_strcmp0 ((_tmp78 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_FLOAT") == 0, (_tmp78 = (g_free (_tmp78), NULL)), _tmp79)) {
															ValaCCodeIdentifier* _tmp80;
															ValaCCodeConstant* _tmp81;
															ValaCCodeConstant* _tmp82;
															_tmp80 = NULL;
															vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_identifier_new ("g_param_spec_float"))));
															(_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)));
															_tmp81 = NULL;
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp81 = vala_ccode_constant_new ("-G_MAXFLOAT"))));
															(_tmp81 == NULL ? NULL : (_tmp81 = (vala_ccode_node_unref (_tmp81), NULL)));
															_tmp82 = NULL;
															vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp82 = vala_ccode_constant_new ("G_MAXFLOAT"))));
															(_tmp82 == NULL ? NULL : (_tmp82 = (vala_ccode_node_unref (_tmp82), NULL)));
															if (vala_property_get_default_expression (prop) != NULL) {
																vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
															} else {
																ValaCCodeConstant* _tmp83;
																_tmp83 = NULL;
																vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp83 = vala_ccode_constant_new ("0.0F"))));
																(_tmp83 == NULL ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL)));
															}
														} else {
															char* _tmp84;
															gboolean _tmp85;
															_tmp84 = NULL;
															if ((_tmp85 = _vala_strcmp0 ((_tmp84 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_DOUBLE") == 0, (_tmp84 = (g_free (_tmp84), NULL)), _tmp85)) {
																ValaCCodeIdentifier* _tmp86;
																ValaCCodeConstant* _tmp87;
																ValaCCodeConstant* _tmp88;
																_tmp86 = NULL;
																vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new ("g_param_spec_double"))));
																(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
																_tmp87 = NULL;
																vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp87 = vala_ccode_constant_new ("-G_MAXDOUBLE"))));
																(_tmp87 == NULL ? NULL : (_tmp87 = (vala_ccode_node_unref (_tmp87), NULL)));
																_tmp88 = NULL;
																vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp88 = vala_ccode_constant_new ("G_MAXDOUBLE"))));
																(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
																if (vala_property_get_default_expression (prop) != NULL) {
																	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
																} else {
																	ValaCCodeConstant* _tmp89;
																	_tmp89 = NULL;
																	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp89 = vala_ccode_constant_new ("0.0"))));
																	(_tmp89 == NULL ? NULL : (_tmp89 = (vala_ccode_node_unref (_tmp89), NULL)));
																}
															} else {
																char* _tmp90;
																gboolean _tmp91;
																_tmp90 = NULL;
																if ((_tmp91 = _vala_strcmp0 ((_tmp90 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (st))), "G_TYPE_GTYPE") == 0, (_tmp90 = (g_free (_tmp90), NULL)), _tmp91)) {
																	ValaCCodeIdentifier* _tmp92;
																	_tmp92 = NULL;
																	vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp92 = vala_ccode_identifier_new ("g_param_spec_gtype"))));
																	(_tmp92 == NULL ? NULL : (_tmp92 = (vala_ccode_node_unref (_tmp92), NULL)));
																	if (vala_property_get_default_expression (prop) != NULL) {
																		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION (vala_code_node_get_ccodenode (VALA_CODE_NODE (vala_property_get_default_expression (prop)))));
																	} else {
																		ValaCCodeConstant* _tmp93;
																		_tmp93 = NULL;
																		vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp93 = vala_ccode_constant_new ("G_TYPE_NONE"))));
																		(_tmp93 == NULL ? NULL : (_tmp93 = (vala_ccode_node_unref (_tmp93), NULL)));
																	}
																} else {
																	ValaCCodeIdentifier* _tmp94;
																	_tmp94 = NULL;
																	vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
																	(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
																}
															}
														}
													}
												}
											}
										}
									}
								}
							}
						}
					}
					(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
				} else {
					ValaCCodeIdentifier* _tmp95;
					_tmp95 = NULL;
					vala_ccode_function_call_set_call (cspec, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_identifier_new ("g_param_spec_pointer"))));
					(_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)));
				}
			}
		}
	}
	pflags = g_strdup ("G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB");
	if (vala_property_get_get_accessor (prop) != NULL) {
		char* _tmp96;
		_tmp96 = NULL;
		pflags = (_tmp96 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_READABLE"), (pflags = (g_free (pflags), NULL)), _tmp96);
	}
	if (vala_property_get_set_accessor (prop) != NULL) {
		char* _tmp97;
		_tmp97 = NULL;
		pflags = (_tmp97 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_WRITABLE"), (pflags = (g_free (pflags), NULL)), _tmp97);
		if (vala_property_accessor_get_construction (vala_property_get_set_accessor (prop))) {
			if (vala_property_accessor_get_writable (vala_property_get_set_accessor (prop))) {
				char* _tmp98;
				_tmp98 = NULL;
				pflags = (_tmp98 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT"), (pflags = (g_free (pflags), NULL)), _tmp98);
			} else {
				char* _tmp99;
				_tmp99 = NULL;
				pflags = (_tmp99 = g_strdup_printf ("%s%s", pflags, " | G_PARAM_CONSTRUCT_ONLY"), (pflags = (g_free (pflags), NULL)), _tmp99);
			}
		}
	}
	_tmp100 = NULL;
	vala_ccode_function_call_add_argument (cspec, VALA_CCODE_EXPRESSION ((_tmp100 = vala_ccode_constant_new (pflags))));
	(_tmp100 == NULL ? NULL : (_tmp100 = (vala_ccode_node_unref (_tmp100), NULL)));
	_tmp101 = NULL;
	return (_tmp101 = cspec, (pflags = (g_free (pflags), NULL)), _tmp101);
}


ValaCCodeFunctionCall* vala_ccode_type_symbol_binding_get_signal_creation (ValaCCodeTypeSymbolBinding* self, ValaSignal* sig, ValaTypeSymbol* type) {
	ValaCCodeIdentifier* _tmp0;
	ValaCCodeFunctionCall* _tmp1;
	ValaCCodeFunctionCall* csignew;
	ValaCCodeConstant* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeIdentifier* _tmp6;
	char* _tmp5;
	ValaCCodeConstant* _tmp7;
	ValaCCodeConstant* _tmp8;
	ValaCCodeConstant* _tmp9;
	ValaCCodeConstant* _tmp10;
	GeeList* _tmp11;
	char* _tmp12;
	char* marshaller;
	ValaCCodeIdentifier* marshal_arg;
	GeeList* params;
	gint params_len;
	ValaCCodeConstant* _tmp19;
	char* _tmp18;
	ValaCCodeFunctionCall* _tmp27;
	g_return_val_if_fail (VALA_IS_CCODE_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_SIGNAL (sig), NULL);
	g_return_val_if_fail (VALA_IS_TYPESYMBOL (type), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	csignew = (_tmp1 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp0 = vala_ccode_identifier_new ("g_signal_new")))), (_tmp0 == NULL ? NULL : (_tmp0 = (vala_ccode_node_unref (_tmp0), NULL))), _tmp1);
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp4 = vala_ccode_constant_new ((_tmp3 = g_strdup_printf ("\"%s\"", (_tmp2 = vala_signal_get_cname (sig))))))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	_tmp6 = NULL;
	_tmp5 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp6 = vala_ccode_identifier_new ((_tmp5 = vala_typesymbol_get_type_id (type))))));
	(_tmp6 == NULL ? NULL : (_tmp6 = (vala_ccode_node_unref (_tmp6), NULL)));
	_tmp5 = (g_free (_tmp5), NULL);
	_tmp7 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp7 = vala_ccode_constant_new ("G_SIGNAL_RUN_LAST"))));
	(_tmp7 == NULL ? NULL : (_tmp7 = (vala_ccode_node_unref (_tmp7), NULL)));
	_tmp8 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp8 = vala_ccode_constant_new ("0"))));
	(_tmp8 == NULL ? NULL : (_tmp8 = (vala_ccode_node_unref (_tmp8), NULL)));
	_tmp9 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp9 = vala_ccode_constant_new ("NULL"))));
	(_tmp9 == NULL ? NULL : (_tmp9 = (vala_ccode_node_unref (_tmp9), NULL)));
	_tmp10 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp10 = vala_ccode_constant_new ("NULL"))));
	(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
	_tmp11 = NULL;
	_tmp12 = NULL;
	marshaller = (_tmp12 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), (_tmp11 = vala_signal_get_parameters (sig)), vala_signal_get_return_type (sig), NULL, FALSE), (_tmp11 == NULL ? NULL : (_tmp11 = (gee_collection_object_unref (_tmp11), NULL))), _tmp12);
	marshal_arg = vala_ccode_identifier_new (marshaller);
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION (marshal_arg));
	params = vala_signal_get_parameters (sig);
	if (VALA_IS_POINTER_TYPE (vala_signal_get_return_type (sig)) || vala_data_type_get_type_parameter (vala_signal_get_return_type (sig)) != NULL) {
		ValaCCodeConstant* _tmp13;
		_tmp13 = NULL;
		vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp13 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
		(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
	} else {
		if (VALA_IS_ERROR_TYPE (vala_signal_get_return_type (sig))) {
			ValaCCodeConstant* _tmp14;
			_tmp14 = NULL;
			vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp14 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
			(_tmp14 == NULL ? NULL : (_tmp14 = (vala_ccode_node_unref (_tmp14), NULL)));
		} else {
			if (vala_data_type_get_data_type (vala_signal_get_return_type (sig)) == NULL) {
				ValaCCodeConstant* _tmp15;
				_tmp15 = NULL;
				vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp15 = vala_ccode_constant_new ("G_TYPE_NONE"))));
				(_tmp15 == NULL ? NULL : (_tmp15 = (vala_ccode_node_unref (_tmp15), NULL)));
			} else {
				ValaCCodeConstant* _tmp17;
				char* _tmp16;
				_tmp17 = NULL;
				_tmp16 = NULL;
				vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new ((_tmp16 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_signal_get_return_type (sig))))))));
				(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
				_tmp16 = (g_free (_tmp16), NULL);
			}
		}
	}
	params_len = 0;
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				params_len++;
				if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
					params_len++;
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	_tmp19 = NULL;
	_tmp18 = NULL;
	vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp19 = vala_ccode_constant_new ((_tmp18 = g_strdup_printf ("%d", params_len))))));
	(_tmp19 == NULL ? NULL : (_tmp19 = (vala_ccode_node_unref (_tmp19), NULL)));
	_tmp18 = (g_free (_tmp18), NULL);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = params;
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				if (vala_data_type_is_array (vala_formal_parameter_get_parameter_type (param))) {
					ValaCCodeConstant* _tmp22;
					if (vala_data_type_get_data_type (vala_array_type_get_element_type ((VALA_ARRAY_TYPE (vala_formal_parameter_get_parameter_type (param))))) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
						ValaCCodeConstant* _tmp20;
						_tmp20 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp20 = vala_ccode_constant_new ("G_TYPE_STRV"))));
						(_tmp20 == NULL ? NULL : (_tmp20 = (vala_ccode_node_unref (_tmp20), NULL)));
					} else {
						ValaCCodeConstant* _tmp21;
						_tmp21 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp21 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
						(_tmp21 == NULL ? NULL : (_tmp21 = (vala_ccode_node_unref (_tmp21), NULL)));
					}
					_tmp22 = NULL;
					vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp22 = vala_ccode_constant_new ("G_TYPE_INT"))));
					(_tmp22 == NULL ? NULL : (_tmp22 = (vala_ccode_node_unref (_tmp22), NULL)));
				} else {
					if (VALA_IS_POINTER_TYPE (vala_formal_parameter_get_parameter_type (param)) || vala_data_type_get_type_parameter (vala_formal_parameter_get_parameter_type (param)) != NULL || vala_formal_parameter_get_direction (param) != VALA_PARAMETER_DIRECTION_IN) {
						ValaCCodeConstant* _tmp23;
						_tmp23 = NULL;
						vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
						(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
					} else {
						if (VALA_IS_ERROR_TYPE (vala_formal_parameter_get_parameter_type (param))) {
							ValaCCodeConstant* _tmp24;
							_tmp24 = NULL;
							vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp24 = vala_ccode_constant_new ("G_TYPE_POINTER"))));
							(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
						} else {
							ValaCCodeConstant* _tmp26;
							char* _tmp25;
							_tmp26 = NULL;
							_tmp25 = NULL;
							vala_ccode_function_call_add_argument (csignew, VALA_CCODE_EXPRESSION ((_tmp26 = vala_ccode_constant_new ((_tmp25 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))))))));
							(_tmp26 == NULL ? NULL : (_tmp26 = (vala_ccode_node_unref (_tmp26), NULL)));
							_tmp25 = (g_free (_tmp25), NULL);
						}
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
	}
	vala_ccode_identifier_set_name (marshal_arg, marshaller);
	_tmp27 = NULL;
	return (_tmp27 = csignew, (marshaller = (g_free (marshaller), NULL)), (marshal_arg == NULL ? NULL : (marshal_arg = (vala_ccode_node_unref (marshal_arg), NULL))), (params == NULL ? NULL : (params = (gee_collection_object_unref (params), NULL))), _tmp27);
}


static void vala_ccode_type_symbol_binding_class_init (ValaCCodeTypeSymbolBindingClass * klass) {
	vala_ccode_type_symbol_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_type_symbol_binding_instance_init (ValaCCodeTypeSymbolBinding * self) {
}


GType vala_ccode_type_symbol_binding_get_type (void) {
	static GType vala_ccode_type_symbol_binding_type_id = 0;
	if (vala_ccode_type_symbol_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeTypeSymbolBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_type_symbol_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeTypeSymbolBinding), 0, (GInstanceInitFunc) vala_ccode_type_symbol_binding_instance_init, NULL };
		vala_ccode_type_symbol_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_BINDING, "ValaCCodeTypeSymbolBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_type_symbol_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




