/* valaccodeobjecttypesymbolbinding.vala
 *
 * Copyright (C) 2008  Philip Van Hoof
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Philip Van Hoof <pvanhoof@gnome.org>
 */

#include <gobject/valaccodeobjecttypesymbolbinding.h>
#include <vala/valacodenode.h>
#include <stdlib.h>
#include <string.h>
#include <vala/valaattribute.h>
#include <vala/valamethod.h>
#include <vala/valacreationmethod.h>
#include <vala/valamember.h>
#include <vala/valasymbol.h>
#include <gee/arraylist.h>
#include <vala/valaformalparameter.h>
#include <gee/collection.h>
#include <vala/valavoidtype.h>
#include <vala/valapointertype.h>
#include <vala/valadatatype.h>
#include <vala/valasourcereference.h>
#include <gee/list.h>
#include <vala/valareport.h>
#include <vala/valasignal.h>
#include <vala/valaproperty.h>
#include <ccode/valaccodedeclaration.h>
#include <ccode/valaccodemodifiers.h>
#include <ccode/valaccodevariabledeclarator.h>
#include <ccode/valaccodeconstant.h>
#include <ccode/valaccodeexpression.h>
#include <ccode/valaccodedeclarator.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodefunctioncall.h>
#include <ccode/valaccodeidentifier.h>
#include <vala/valatypesymbol.h>
#include <ccode/valaccodeunaryexpression.h>
#include <ccode/valaccodeexpressionstatement.h>
#include <ccode/valaccodefunction.h>
#include <ccode/valaccodeformalparameter.h>
#include <vala/valaarraytype.h>
#include <ccode/valaccodeblock.h>
#include <vala/valastruct.h>
#include <vala/valafield.h>
#include <ccode/valaccodeelementaccess.h>
#include <ccode/valaccodememberaccess.h>
#include <ccode/valaccodeassignment.h>
#include <ccode/valaccodeinitializerlist.h>
#include <ccode/valaccodebinaryexpression.h>
#include <ccode/valaccodereturnstatement.h>
#include <gobject/valaccodebinding.h>
#include <gobject/valaccodegenerator.h>




enum  {
	VALA_CCODE_OBJECT_TYPE_SYMBOL_BINDING_DUMMY_PROPERTY
};
static gboolean vala_ccode_object_type_symbol_binding_is_dbus_visible (ValaCCodeObjectTypeSymbolBinding* self, ValaCodeNode* node);
static char* vala_ccode_object_type_symbol_binding_dbus_result_name (ValaCCodeObjectTypeSymbolBinding* self, ValaCodeNode* node);
static char* vala_ccode_object_type_symbol_binding_generate_dbus_wrapper (ValaCCodeObjectTypeSymbolBinding* self, ValaMethod* m, ValaObjectTypeSymbol* bindable);
static gpointer vala_ccode_object_type_symbol_binding_parent_class = NULL;
static int _vala_strcmp0 (const char * str1, const char * str2);



static gboolean vala_ccode_object_type_symbol_binding_is_dbus_visible (ValaCCodeObjectTypeSymbolBinding* self, ValaCodeNode* node) {
	ValaAttribute* dbus_attribute;
	gboolean _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), FALSE);
	g_return_val_if_fail (VALA_IS_CODE_NODE (node), FALSE);
	dbus_attribute = vala_code_node_get_attribute (node, "DBus");
	if (dbus_attribute != NULL && vala_attribute_has_argument (dbus_attribute, "visible") && !vala_attribute_get_bool (dbus_attribute, "visible")) {
		gboolean _tmp0;
		return (_tmp0 = FALSE, (dbus_attribute == NULL ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL))), _tmp0);
	}
	return (_tmp1 = TRUE, (dbus_attribute == NULL ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL))), _tmp1);
}


static char* vala_ccode_object_type_symbol_binding_dbus_result_name (ValaCCodeObjectTypeSymbolBinding* self, ValaCodeNode* node) {
	ValaAttribute* dbus_attribute;
	char* _tmp1;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_CODE_NODE (node), NULL);
	dbus_attribute = vala_code_node_get_attribute (node, "DBus");
	if (dbus_attribute != NULL && vala_attribute_has_argument (dbus_attribute, "result")) {
		char* result_name;
		result_name = vala_attribute_get_string (dbus_attribute, "result");
		if (result_name != NULL && _vala_strcmp0 (result_name, "") != 0) {
			char* _tmp0;
			_tmp0 = NULL;
			return (_tmp0 = result_name, (dbus_attribute == NULL ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL))), _tmp0);
		}
		result_name = (g_free (result_name), NULL);
	}
	_tmp1 = NULL;
	return (_tmp1 = g_strdup ("result"), (dbus_attribute == NULL ? NULL : (dbus_attribute = (vala_code_node_unref (dbus_attribute), NULL))), _tmp1);
}


ValaCCodeFragment* vala_ccode_object_type_symbol_binding_register_dbus_info (ValaCCodeObjectTypeSymbolBinding* self, ValaObjectTypeSymbol* bindable) {
	ValaCCodeFragment* fragment;
	ValaAttribute* dbus;
	char* dbus_iface_name;
	GString* dbus_methods;
	GString* blob;
	gint method_count;
	glong blob_len;
	GString* dbus_signals;
	GString* dbus_props;
	ValaCCodeDeclaration* dbus_methods_decl;
	ValaCCodeVariableDeclarator* _tmp18;
	ValaCCodeConstant* _tmp17;
	char* _tmp16;
	char* _tmp15;
	ValaCCodeDeclaration* dbus_object_info;
	ValaCCodeVariableDeclarator* _tmp24;
	ValaCCodeConstant* _tmp23;
	char* _tmp22;
	char* _tmp21;
	char* _tmp20;
	char* _tmp19;
	ValaCCodeIdentifier* _tmp25;
	ValaCCodeFunctionCall* _tmp26;
	ValaCCodeFunctionCall* install_call;
	ValaCCodeIdentifier* _tmp28;
	char* _tmp27;
	ValaCCodeUnaryExpression* _tmp32;
	ValaCCodeIdentifier* _tmp31;
	char* _tmp30;
	char* _tmp29;
	ValaCCodeExpressionStatement* _tmp33;
	ValaCCodeFragment* _tmp34;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE_SYMBOL (bindable), NULL);
	fragment = vala_ccode_fragment_new ();
	dbus = vala_code_node_get_attribute (VALA_CODE_NODE (bindable), "DBus");
	if (dbus == NULL) {
		ValaCCodeFragment* _tmp0;
		_tmp0 = NULL;
		return (_tmp0 = fragment, (dbus == NULL ? NULL : (dbus = (vala_code_node_unref (dbus), NULL))), _tmp0);
	}
	dbus_iface_name = vala_attribute_get_string (dbus, "name");
	if (dbus_iface_name == NULL) {
		ValaCCodeFragment* _tmp1;
		_tmp1 = NULL;
		return (_tmp1 = fragment, (dbus == NULL ? NULL : (dbus = (vala_code_node_unref (dbus), NULL))), (dbus_iface_name = (g_free (dbus_iface_name), NULL)), _tmp1);
	}
	vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->dbus_glib_h_needed = TRUE;
	dbus_methods = g_string_new ("");
	g_string_append (dbus_methods, "{\n");
	blob = g_string_new ("");
	g_string_append_c (blob, '"');
	method_count = 0;
	blob_len = ((glong) (0));
	{
		GeeList* m_collection;
		int m_it;
		m_collection = vala_object_type_symbol_get_methods (bindable);
		for (m_it = 0; m_it < gee_collection_get_size (GEE_COLLECTION (m_collection)); m_it = m_it + 1) {
			ValaMethod* m;
			m = ((ValaMethod*) (gee_list_get (GEE_LIST (m_collection), m_it)));
			{
				GeeArrayList* parameters;
				ValaFormalParameter* _tmp5;
				char* _tmp6;
				char* _tmp7;
				char* _tmp8;
				glong start;
				char* _tmp9;
				if (VALA_IS_CREATION_METHOD (m) || vala_method_get_binding (m) != MEMBER_BINDING_INSTANCE || vala_method_get_overrides (m) || vala_symbol_get_access (VALA_SYMBOL (m)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					continue;
				}
				if (!vala_ccode_object_type_symbol_binding_is_dbus_visible (self, VALA_CODE_NODE (m))) {
					(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
					continue;
				}
				parameters = gee_array_list_new (VALA_TYPE_FORMAL_PARAMETER, ((GBoxedCopyFunc) (vala_code_node_ref)), vala_code_node_unref, g_direct_equal);
				{
					GeeList* param_collection;
					int param_it;
					param_collection = vala_method_get_parameters (m);
					for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
						ValaFormalParameter* param;
						param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
						{
							gee_collection_add (GEE_COLLECTION (parameters), param);
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
				}
				if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
					ValaFormalParameter* _tmp4;
					ValaPointerType* _tmp3;
					ValaVoidType* _tmp2;
					_tmp4 = NULL;
					_tmp3 = NULL;
					_tmp2 = NULL;
					gee_collection_add (GEE_COLLECTION (parameters), (_tmp4 = vala_formal_parameter_new ("result", VALA_DATA_TYPE ((_tmp3 = vala_pointer_type_new (VALA_DATA_TYPE ((_tmp2 = vala_void_type_new ())), NULL))), NULL)));
					(_tmp4 == NULL ? NULL : (_tmp4 = (vala_code_node_unref (_tmp4), NULL)));
					(_tmp3 == NULL ? NULL : (_tmp3 = (vala_code_node_unref (_tmp3), NULL)));
					(_tmp2 == NULL ? NULL : (_tmp2 = (vala_code_node_unref (_tmp2), NULL)));
				}
				_tmp5 = NULL;
				gee_collection_add (GEE_COLLECTION (parameters), (_tmp5 = vala_formal_parameter_new ("error", VALA_DATA_TYPE (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->gerror_type), NULL)));
				(_tmp5 == NULL ? NULL : (_tmp5 = (vala_code_node_unref (_tmp5), NULL)));
				g_string_append (dbus_methods, "{ (GCallback) ");
				_tmp6 = NULL;
				g_string_append (dbus_methods, (_tmp6 = vala_ccode_object_type_symbol_binding_generate_dbus_wrapper (self, m, bindable)));
				_tmp6 = (g_free (_tmp6), NULL);
				g_string_append (dbus_methods, ", ");
				_tmp7 = NULL;
				g_string_append (dbus_methods, (_tmp7 = vala_ccode_generator_get_marshaller_function (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), GEE_LIST (parameters), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->bool_type, NULL, TRUE)));
				_tmp7 = (g_free (_tmp7), NULL);
				g_string_append (dbus_methods, ", ");
				_tmp8 = NULL;
				g_string_append (dbus_methods, (_tmp8 = g_strdup_printf ("%li", blob_len)));
				_tmp8 = (g_free (_tmp8), NULL);
				g_string_append (dbus_methods, " },\n");
				vala_ccode_generator_generate_marshaller (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), GEE_LIST (parameters), vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->bool_type, TRUE);
				start = blob->len;
				g_string_append (blob, dbus_iface_name);
				g_string_append (blob, "\\0");
				start++;
				_tmp9 = NULL;
				g_string_append (blob, (_tmp9 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (m)))));
				_tmp9 = (g_free (_tmp9), NULL);
				g_string_append (blob, "\\0");
				start++;
				/* synchronous*/
				g_string_append (blob, "S\\0");
				start++;
				{
					GeeList* param_collection;
					int param_it;
					param_collection = vala_method_get_parameters (m);
					for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
						ValaFormalParameter* param;
						param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
						{
							char* _tmp10;
							g_string_append (blob, vala_symbol_get_name (VALA_SYMBOL (param)));
							g_string_append (blob, "\\0");
							start++;
							if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
								g_string_append (blob, "I\\0");
								start++;
							} else {
								if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT) {
									g_string_append (blob, "O\\0");
									start++;
									g_string_append (blob, "F\\0");
									start++;
									g_string_append (blob, "N\\0");
									start++;
								} else {
									vala_report_error (vala_code_node_get_source_reference (VALA_CODE_NODE (param)), "unsupported parameter direction for D-Bus method");
								}
							}
							_tmp10 = NULL;
							g_string_append (blob, (_tmp10 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))));
							_tmp10 = (g_free (_tmp10), NULL);
							g_string_append (blob, "\\0");
							start++;
							(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
						}
					}
					(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
				}
				if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
					char* _tmp11;
					char* _tmp12;
					_tmp11 = NULL;
					g_string_append (blob, (_tmp11 = vala_ccode_object_type_symbol_binding_dbus_result_name (self, VALA_CODE_NODE (m))));
					_tmp11 = (g_free (_tmp11), NULL);
					g_string_append (blob, "\\0");
					start++;
					g_string_append (blob, "O\\0");
					start++;
					g_string_append (blob, "F\\0");
					start++;
					g_string_append (blob, "N\\0");
					start++;
					_tmp12 = NULL;
					g_string_append (blob, (_tmp12 = vala_data_type_get_type_signature (vala_method_get_return_type (m))));
					_tmp12 = (g_free (_tmp12), NULL);
					g_string_append (blob, "\\0");
					start++;
				}
				g_string_append (blob, "\\0");
				start++;
				blob_len = blob_len + (blob->len - start);
				method_count++;
				(m == NULL ? NULL : (m = (vala_code_node_unref (m), NULL)));
				(parameters == NULL ? NULL : (parameters = (gee_collection_object_unref (parameters), NULL)));
			}
		}
		(m_collection == NULL ? NULL : (m_collection = (gee_collection_object_unref (m_collection), NULL)));
	}
	g_string_append_c (blob, '"');
	g_string_append (dbus_methods, "}\n");
	dbus_signals = g_string_new ("");
	g_string_append_c (dbus_signals, '"');
	{
		GeeList* sig_collection;
		int sig_it;
		sig_collection = vala_object_type_symbol_get_signals (bindable);
		for (sig_it = 0; sig_it < gee_collection_get_size (GEE_COLLECTION (sig_collection)); sig_it = sig_it + 1) {
			ValaSignal* sig;
			sig = ((ValaSignal*) (gee_list_get (GEE_LIST (sig_collection), sig_it)));
			{
				char* _tmp13;
				if (vala_symbol_get_access (VALA_SYMBOL (sig)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
					continue;
				}
				if (!vala_ccode_object_type_symbol_binding_is_dbus_visible (self, VALA_CODE_NODE (sig))) {
					(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
					continue;
				}
				g_string_append (dbus_signals, dbus_iface_name);
				g_string_append (dbus_signals, "\\0");
				_tmp13 = NULL;
				g_string_append (dbus_signals, (_tmp13 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (sig)))));
				_tmp13 = (g_free (_tmp13), NULL);
				g_string_append (dbus_signals, "\\0");
				(sig == NULL ? NULL : (sig = (vala_code_node_unref (sig), NULL)));
			}
		}
		(sig_collection == NULL ? NULL : (sig_collection = (gee_collection_object_unref (sig_collection), NULL)));
	}
	g_string_append_c (dbus_signals, '"');
	dbus_props = g_string_new ("");
	g_string_append_c (dbus_props, '"');
	{
		GeeList* prop_collection;
		int prop_it;
		prop_collection = vala_object_type_symbol_get_properties (bindable);
		for (prop_it = 0; prop_it < gee_collection_get_size (GEE_COLLECTION (prop_collection)); prop_it = prop_it + 1) {
			ValaProperty* prop;
			prop = ((ValaProperty*) (gee_list_get (GEE_LIST (prop_collection), prop_it)));
			{
				char* _tmp14;
				if (vala_symbol_get_access (VALA_SYMBOL (prop)) != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				if (!vala_ccode_object_type_symbol_binding_is_dbus_visible (self, VALA_CODE_NODE (prop))) {
					(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
					continue;
				}
				g_string_append (dbus_props, dbus_iface_name);
				g_string_append (dbus_props, "\\0");
				_tmp14 = NULL;
				g_string_append (dbus_props, (_tmp14 = vala_symbol_lower_case_to_camel_case (vala_symbol_get_name (VALA_SYMBOL (prop)))));
				_tmp14 = (g_free (_tmp14), NULL);
				g_string_append (dbus_props, "\\0");
				(prop == NULL ? NULL : (prop = (vala_code_node_unref (prop), NULL)));
			}
		}
		(prop_collection == NULL ? NULL : (prop_collection = (gee_collection_object_unref (prop_collection), NULL)));
	}
	g_string_append_c (dbus_props, '"');
	dbus_methods_decl = vala_ccode_declaration_new ("const DBusGMethodInfo");
	vala_ccode_declaration_set_modifiers (dbus_methods_decl, VALA_CCODE_MODIFIERS_STATIC);
	_tmp18 = NULL;
	_tmp17 = NULL;
	_tmp16 = NULL;
	_tmp15 = NULL;
	vala_ccode_declaration_add_declarator (dbus_methods_decl, VALA_CCODE_DECLARATOR ((_tmp18 = vala_ccode_variable_declarator_new_with_initializer ((_tmp16 = g_strdup_printf ("%s_dbus_methods[]", (_tmp15 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)))), VALA_CCODE_EXPRESSION ((_tmp17 = vala_ccode_constant_new (dbus_methods->str)))))));
	(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
	(_tmp17 == NULL ? NULL : (_tmp17 = (vala_ccode_node_unref (_tmp17), NULL)));
	_tmp16 = (g_free (_tmp16), NULL);
	_tmp15 = (g_free (_tmp15), NULL);
	vala_ccode_fragment_append (fragment, VALA_CCODE_NODE (dbus_methods_decl));
	dbus_object_info = vala_ccode_declaration_new ("const DBusGObjectInfo");
	vala_ccode_declaration_set_modifiers (dbus_object_info, VALA_CCODE_MODIFIERS_STATIC);
	_tmp24 = NULL;
	_tmp23 = NULL;
	_tmp22 = NULL;
	_tmp21 = NULL;
	_tmp20 = NULL;
	_tmp19 = NULL;
	vala_ccode_declaration_add_declarator (dbus_object_info, VALA_CCODE_DECLARATOR ((_tmp24 = vala_ccode_variable_declarator_new_with_initializer ((_tmp20 = g_strdup_printf ("%s_dbus_object_info", (_tmp19 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)))), VALA_CCODE_EXPRESSION ((_tmp23 = vala_ccode_constant_new ((_tmp22 = g_strdup_printf ("{ 0, %s_dbus_methods, %d, %s, %s, %s }", (_tmp21 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)), method_count, blob->str, dbus_signals->str, dbus_props->str)))))))));
	(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
	(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
	_tmp22 = (g_free (_tmp22), NULL);
	_tmp21 = (g_free (_tmp21), NULL);
	_tmp20 = (g_free (_tmp20), NULL);
	_tmp19 = (g_free (_tmp19), NULL);
	vala_ccode_fragment_append (fragment, VALA_CCODE_NODE (dbus_object_info));
	_tmp25 = NULL;
	_tmp26 = NULL;
	install_call = (_tmp26 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp25 = vala_ccode_identifier_new ("dbus_g_object_type_install_info")))), (_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL))), _tmp26);
	_tmp28 = NULL;
	_tmp27 = NULL;
	vala_ccode_function_call_add_argument (install_call, VALA_CCODE_EXPRESSION ((_tmp28 = vala_ccode_identifier_new ((_tmp27 = vala_typesymbol_get_type_id (VALA_TYPESYMBOL (bindable)))))));
	(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
	_tmp27 = (g_free (_tmp27), NULL);
	_tmp32 = NULL;
	_tmp31 = NULL;
	_tmp30 = NULL;
	_tmp29 = NULL;
	vala_ccode_function_call_add_argument (install_call, VALA_CCODE_EXPRESSION ((_tmp32 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp31 = vala_ccode_identifier_new ((_tmp30 = g_strdup_printf ("%s_dbus_object_info", (_tmp29 = vala_symbol_get_lower_case_cname (VALA_SYMBOL (bindable), NULL)))))))))));
	(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
	(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
	_tmp30 = (g_free (_tmp30), NULL);
	_tmp29 = (g_free (_tmp29), NULL);
	_tmp33 = NULL;
	vala_ccode_fragment_append (fragment, VALA_CCODE_NODE ((_tmp33 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (install_call)))));
	(_tmp33 == NULL ? NULL : (_tmp33 = (vala_ccode_node_unref (_tmp33), NULL)));
	_tmp34 = NULL;
	return (_tmp34 = fragment, (dbus == NULL ? NULL : (dbus = (vala_code_node_unref (dbus), NULL))), (dbus_iface_name = (g_free (dbus_iface_name), NULL)), (dbus_methods == NULL ? NULL : (dbus_methods = (g_string_free (dbus_methods, TRUE), NULL))), (blob == NULL ? NULL : (blob = (g_string_free (blob, TRUE), NULL))), (dbus_signals == NULL ? NULL : (dbus_signals = (g_string_free (dbus_signals, TRUE), NULL))), (dbus_props == NULL ? NULL : (dbus_props = (g_string_free (dbus_props, TRUE), NULL))), (dbus_methods_decl == NULL ? NULL : (dbus_methods_decl = (vala_ccode_node_unref (dbus_methods_decl), NULL))), (dbus_object_info == NULL ? NULL : (dbus_object_info = (vala_ccode_node_unref (dbus_object_info), NULL))), (install_call == NULL ? NULL : (install_call = (vala_ccode_node_unref (install_call), NULL))), _tmp34);
}


static char* vala_ccode_object_type_symbol_binding_generate_dbus_wrapper (ValaCCodeObjectTypeSymbolBinding* self, ValaMethod* m, ValaObjectTypeSymbol* bindable) {
	char* _tmp0;
	char* _tmp1;
	char* wrapper_name;
	ValaCCodeFunction* function;
	ValaCCodeFormalParameter* _tmp4;
	char* _tmp3;
	char* _tmp2;
	ValaCCodeFormalParameter* _tmp32;
	ValaCCodeBlock* block;
	ValaCCodeIdentifier* _tmp60;
	char* _tmp59;
	ValaCCodeFunctionCall* _tmp61;
	ValaCCodeFunctionCall* ccall;
	ValaCCodeIdentifier* _tmp62;
	ValaCCodeExpression* expr;
	GeeList* _tmp109;
	gboolean _tmp110;
	ValaCCodeExpressionStatement* _tmp112;
	ValaCCodeIdentifier* _tmp183;
	ValaCCodeIdentifier* _tmp182;
	ValaCCodeBinaryExpression* _tmp184;
	ValaCCodeBinaryExpression* no_error;
	ValaCCodeReturnStatement* _tmp185;
	ValaCCodeFunction* _tmp186;
	char* _tmp187;
	g_return_val_if_fail (VALA_IS_CCODE_OBJECT_TYPE_SYMBOL_BINDING (self), NULL);
	g_return_val_if_fail (VALA_IS_METHOD (m), NULL);
	g_return_val_if_fail (VALA_IS_OBJECT_TYPE_SYMBOL (bindable), NULL);
	_tmp0 = NULL;
	_tmp1 = NULL;
	wrapper_name = (_tmp1 = g_strdup_printf ("_dbus_%s", (_tmp0 = vala_method_get_cname (m))), (_tmp0 = (g_free (_tmp0), NULL)), _tmp1);
	/* declaration*/
	function = vala_ccode_function_new (wrapper_name, "gboolean");
	vala_ccode_function_set_modifiers (function, VALA_CCODE_MODIFIERS_STATIC);
	vala_code_node_set_ccodenode (VALA_CODE_NODE (m), VALA_CCODE_NODE (function));
	_tmp4 = NULL;
	_tmp3 = NULL;
	_tmp2 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp4 = vala_ccode_formal_parameter_new ("self", (_tmp3 = g_strconcat ((_tmp2 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (bindable), FALSE)), "*", NULL)))));
	(_tmp4 == NULL ? NULL : (_tmp4 = (vala_ccode_node_unref (_tmp4), NULL)));
	_tmp3 = (g_free (_tmp3), NULL);
	_tmp2 = (g_free (_tmp2), NULL);
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				const char* _tmp5;
				char* ptr;
				ValaArrayType* _tmp7;
				ValaDataType* _tmp6;
				ValaArrayType* array_type;
				_tmp5 = NULL;
				ptr = (_tmp5 = ((vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT ? "*" : "")), (_tmp5 == NULL ? NULL : g_strdup (_tmp5)));
				_tmp7 = NULL;
				_tmp6 = NULL;
				array_type = (_tmp7 = (_tmp6 = vala_formal_parameter_get_parameter_type (param), (VALA_IS_ARRAY_TYPE (_tmp6) ? ((ValaArrayType*) (_tmp6)) : NULL)), (_tmp7 == NULL ? NULL : vala_code_node_ref (_tmp7)));
				if (array_type != NULL && vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
					if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
						ValaCCodeFormalParameter* _tmp10;
						char* _tmp9;
						char* _tmp8;
						_tmp10 = NULL;
						_tmp9 = NULL;
						_tmp8 = NULL;
						vala_ccode_function_add_parameter (function, (_tmp10 = vala_ccode_formal_parameter_new ((_tmp8 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), (_tmp9 = g_strconcat ("GPtrArray*", ptr, NULL)))));
						(_tmp10 == NULL ? NULL : (_tmp10 = (vala_ccode_node_unref (_tmp10), NULL)));
						_tmp9 = (g_free (_tmp9), NULL);
						_tmp8 = (g_free (_tmp8), NULL);
					} else {
						ValaCCodeFormalParameter* _tmp13;
						char* _tmp12;
						char* _tmp11;
						_tmp13 = NULL;
						_tmp12 = NULL;
						_tmp11 = NULL;
						vala_ccode_function_add_parameter (function, (_tmp13 = vala_ccode_formal_parameter_new ((_tmp11 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), (_tmp12 = g_strconcat ("GArray*", ptr, NULL)))));
						(_tmp13 == NULL ? NULL : (_tmp13 = (vala_ccode_node_unref (_tmp13), NULL)));
						_tmp12 = (g_free (_tmp12), NULL);
						_tmp11 = (g_free (_tmp11), NULL);
					}
				} else {
					char* _tmp14;
					gboolean _tmp15;
					_tmp14 = NULL;
					if ((_tmp15 = g_str_has_prefix ((_tmp14 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp14 = (g_free (_tmp14), NULL)), _tmp15)) {
						ValaCCodeFormalParameter* _tmp18;
						char* _tmp17;
						char* _tmp16;
						_tmp18 = NULL;
						_tmp17 = NULL;
						_tmp16 = NULL;
						vala_ccode_function_add_parameter (function, (_tmp18 = vala_ccode_formal_parameter_new ((_tmp16 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))), (_tmp17 = g_strconcat ("GValueArray*", ptr, NULL)))));
						(_tmp18 == NULL ? NULL : (_tmp18 = (vala_ccode_node_unref (_tmp18), NULL)));
						_tmp17 = (g_free (_tmp17), NULL);
						_tmp16 = (g_free (_tmp16), NULL);
					} else {
						vala_ccode_function_add_parameter (function, VALA_CCODE_FORMAL_PARAMETER (vala_code_node_get_ccodenode (VALA_CODE_NODE (param))));
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				ptr = (g_free (ptr), NULL);
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		ValaArrayType* _tmp20;
		ValaDataType* _tmp19;
		ValaArrayType* array_type;
		_tmp20 = NULL;
		_tmp19 = NULL;
		array_type = (_tmp20 = (_tmp19 = vala_method_get_return_type (m), (VALA_IS_ARRAY_TYPE (_tmp19) ? ((ValaArrayType*) (_tmp19)) : NULL)), (_tmp20 == NULL ? NULL : vala_code_node_ref (_tmp20)));
		if (array_type != NULL) {
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
				ValaCCodeFormalParameter* _tmp23;
				char* _tmp22;
				char* _tmp21;
				_tmp23 = NULL;
				_tmp22 = NULL;
				_tmp21 = NULL;
				vala_ccode_function_add_parameter (function, (_tmp23 = vala_ccode_formal_parameter_new ("result", (_tmp22 = g_strconcat ((_tmp21 = vala_data_type_get_cname (VALA_DATA_TYPE (array_type))), "*", NULL)))));
				(_tmp23 == NULL ? NULL : (_tmp23 = (vala_ccode_node_unref (_tmp23), NULL)));
				_tmp22 = (g_free (_tmp22), NULL);
				_tmp21 = (g_free (_tmp21), NULL);
			} else {
				if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
					ValaCCodeFormalParameter* _tmp24;
					_tmp24 = NULL;
					vala_ccode_function_add_parameter (function, (_tmp24 = vala_ccode_formal_parameter_new ("dbus_result", "GPtrArray**")));
					(_tmp24 == NULL ? NULL : (_tmp24 = (vala_ccode_node_unref (_tmp24), NULL)));
				} else {
					ValaCCodeFormalParameter* _tmp25;
					_tmp25 = NULL;
					vala_ccode_function_add_parameter (function, (_tmp25 = vala_ccode_formal_parameter_new ("dbus_result", "GArray**")));
					(_tmp25 == NULL ? NULL : (_tmp25 = (vala_ccode_node_unref (_tmp25), NULL)));
				}
			}
		} else {
			char* _tmp26;
			gboolean _tmp27;
			_tmp26 = NULL;
			if ((_tmp27 = g_str_has_prefix ((_tmp26 = vala_data_type_get_type_signature (vala_method_get_return_type (m))), "("), (_tmp26 = (g_free (_tmp26), NULL)), _tmp27)) {
				ValaCCodeFormalParameter* _tmp28;
				_tmp28 = NULL;
				vala_ccode_function_add_parameter (function, (_tmp28 = vala_ccode_formal_parameter_new ("dbus_result", "GValueArray**")));
				(_tmp28 == NULL ? NULL : (_tmp28 = (vala_ccode_node_unref (_tmp28), NULL)));
			} else {
				ValaCCodeFormalParameter* _tmp31;
				char* _tmp30;
				char* _tmp29;
				_tmp31 = NULL;
				_tmp30 = NULL;
				_tmp29 = NULL;
				vala_ccode_function_add_parameter (function, (_tmp31 = vala_ccode_formal_parameter_new ("result", (_tmp30 = g_strconcat ((_tmp29 = vala_data_type_get_cname (vala_method_get_return_type (m))), "*", NULL)))));
				(_tmp31 == NULL ? NULL : (_tmp31 = (vala_ccode_node_unref (_tmp31), NULL)));
				_tmp30 = (g_free (_tmp30), NULL);
				_tmp29 = (g_free (_tmp29), NULL);
			}
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	}
	_tmp32 = NULL;
	vala_ccode_function_add_parameter (function, (_tmp32 = vala_ccode_formal_parameter_new ("error", "GError**")));
	(_tmp32 == NULL ? NULL : (_tmp32 = (vala_ccode_node_unref (_tmp32), NULL)));
	/* definition*/
	block = vala_ccode_block_new ();
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp33;
				gboolean _tmp34;
				_tmp33 = NULL;
				if ((_tmp34 = g_str_has_prefix ((_tmp33 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp33 = (g_free (_tmp33), NULL)), _tmp34)) {
					ValaStruct* _tmp35;
					ValaStruct* st;
					char* _tmp36;
					ValaCCodeDeclaration* _tmp37;
					ValaCCodeDeclaration* cdecl_;
					ValaCCodeVariableDeclarator* _tmp38;
					_tmp35 = NULL;
					st = (_tmp35 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp35 == NULL ? NULL : vala_code_node_ref (_tmp35)));
					_tmp36 = NULL;
					_tmp37 = NULL;
					cdecl_ = (_tmp37 = vala_ccode_declaration_new ((_tmp36 = vala_typesymbol_get_cname (VALA_TYPESYMBOL (st), FALSE))), (_tmp36 = (g_free (_tmp36), NULL)), _tmp37);
					_tmp38 = NULL;
					vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp38 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
					(_tmp38 == NULL ? NULL : (_tmp38 = (vala_ccode_node_unref (_tmp38), NULL)));
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						gint i;
						/* struct input parameter*/
						i = 0;
						{
							GeeList* f_collection;
							int f_it;
							f_collection = vala_struct_get_fields (st);
							for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
								ValaField* f;
								f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
								{
									if (vala_field_get_binding (f) == MEMBER_BINDING_INSTANCE) {
										ValaCCodeIdentifier* _tmp40;
										char* _tmp39;
										ValaCCodeFunctionCall* _tmp41;
										ValaCCodeFunctionCall* cget_call;
										ValaCCodeUnaryExpression* _tmp48;
										ValaCCodeElementAccess* _tmp47;
										ValaCCodeConstant* _tmp46;
										char* _tmp45;
										ValaCCodeMemberAccess* _tmp44;
										ValaCCodeIdentifier* _tmp43;
										char* _tmp42;
										ValaCCodeMemberAccess* _tmp50;
										ValaCCodeIdentifier* _tmp49;
										ValaCCodeAssignment* _tmp51;
										ValaCCodeAssignment* assign;
										ValaCCodeExpressionStatement* _tmp52;
										_tmp40 = NULL;
										_tmp39 = NULL;
										_tmp41 = NULL;
										cget_call = (_tmp41 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp40 = vala_ccode_identifier_new ((_tmp39 = vala_typesymbol_get_get_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp40 == NULL ? NULL : (_tmp40 = (vala_ccode_node_unref (_tmp40), NULL))), (_tmp39 = (g_free (_tmp39), NULL)), _tmp41);
										_tmp48 = NULL;
										_tmp47 = NULL;
										_tmp46 = NULL;
										_tmp45 = NULL;
										_tmp44 = NULL;
										_tmp43 = NULL;
										_tmp42 = NULL;
										vala_ccode_function_call_add_argument (cget_call, VALA_CCODE_EXPRESSION ((_tmp48 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp47 = vala_ccode_element_access_new (VALA_CCODE_EXPRESSION ((_tmp44 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp43 = vala_ccode_identifier_new ((_tmp42 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "values"))), VALA_CCODE_EXPRESSION ((_tmp46 = vala_ccode_constant_new ((_tmp45 = g_strdup_printf ("%i", i))))))))))));
										(_tmp48 == NULL ? NULL : (_tmp48 = (vala_ccode_node_unref (_tmp48), NULL)));
										(_tmp47 == NULL ? NULL : (_tmp47 = (vala_ccode_node_unref (_tmp47), NULL)));
										(_tmp46 == NULL ? NULL : (_tmp46 = (vala_ccode_node_unref (_tmp46), NULL)));
										_tmp45 = (g_free (_tmp45), NULL);
										(_tmp44 == NULL ? NULL : (_tmp44 = (vala_ccode_node_unref (_tmp44), NULL)));
										(_tmp43 == NULL ? NULL : (_tmp43 = (vala_ccode_node_unref (_tmp43), NULL)));
										_tmp42 = (g_free (_tmp42), NULL);
										_tmp50 = NULL;
										_tmp49 = NULL;
										_tmp51 = NULL;
										assign = (_tmp51 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp50 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp49 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f)), FALSE))), VALA_CCODE_EXPRESSION (cget_call), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp50 == NULL ? NULL : (_tmp50 = (vala_ccode_node_unref (_tmp50), NULL))), (_tmp49 == NULL ? NULL : (_tmp49 = (vala_ccode_node_unref (_tmp49), NULL))), _tmp51);
										_tmp52 = NULL;
										vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp52 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (assign)))));
										(_tmp52 == NULL ? NULL : (_tmp52 = (vala_ccode_node_unref (_tmp52), NULL)));
										i++;
										(cget_call == NULL ? NULL : (cget_call = (vala_ccode_node_unref (cget_call), NULL)));
										(assign == NULL ? NULL : (assign = (vala_ccode_node_unref (assign), NULL)));
									}
									(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
								}
							}
							(f_collection == NULL ? NULL : (f_collection = (gee_collection_object_unref (f_collection), NULL)));
						}
					}
					(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		ValaArrayType* _tmp54;
		ValaDataType* _tmp53;
		ValaArrayType* array_type;
		_tmp54 = NULL;
		_tmp53 = NULL;
		array_type = (_tmp54 = (_tmp53 = vala_method_get_return_type (m), (VALA_IS_ARRAY_TYPE (_tmp53) ? ((ValaArrayType*) (_tmp53)) : NULL)), (_tmp54 == NULL ? NULL : vala_code_node_ref (_tmp54)));
		if (array_type != NULL) {
			ValaCCodeDeclaration* len_cdecl;
			ValaCCodeVariableDeclarator* _tmp58;
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
				char* _tmp55;
				ValaCCodeDeclaration* _tmp56;
				ValaCCodeDeclaration* cdecl_;
				ValaCCodeVariableDeclarator* _tmp57;
				_tmp55 = NULL;
				_tmp56 = NULL;
				cdecl_ = (_tmp56 = vala_ccode_declaration_new ((_tmp55 = vala_data_type_get_cname (vala_method_get_return_type (m)))), (_tmp55 = (g_free (_tmp55), NULL)), _tmp56);
				_tmp57 = NULL;
				vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp57 = vala_ccode_variable_declarator_new ("result"))));
				(_tmp57 == NULL ? NULL : (_tmp57 = (vala_ccode_node_unref (_tmp57), NULL)));
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
				(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
			}
			len_cdecl = vala_ccode_declaration_new ("int");
			_tmp58 = NULL;
			vala_ccode_declaration_add_declarator (len_cdecl, VALA_CCODE_DECLARATOR ((_tmp58 = vala_ccode_variable_declarator_new ("result_length1"))));
			(_tmp58 == NULL ? NULL : (_tmp58 = (vala_ccode_node_unref (_tmp58), NULL)));
			vala_ccode_block_add_statement (block, VALA_CCODE_NODE (len_cdecl));
			(len_cdecl == NULL ? NULL : (len_cdecl = (vala_ccode_node_unref (len_cdecl), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	}
	_tmp60 = NULL;
	_tmp59 = NULL;
	_tmp61 = NULL;
	ccall = (_tmp61 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp60 = vala_ccode_identifier_new ((_tmp59 = vala_method_get_cname (m)))))), (_tmp60 == NULL ? NULL : (_tmp60 = (vala_ccode_node_unref (_tmp60), NULL))), (_tmp59 = (g_free (_tmp59), NULL)), _tmp61);
	_tmp62 = NULL;
	vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp62 = vala_ccode_identifier_new ("self"))));
	(_tmp62 == NULL ? NULL : (_tmp62 = (vala_ccode_node_unref (_tmp62), NULL)));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				ValaArrayType* _tmp64;
				ValaDataType* _tmp63;
				ValaArrayType* array_type;
				_tmp64 = NULL;
				_tmp63 = NULL;
				array_type = (_tmp64 = (_tmp63 = vala_formal_parameter_get_parameter_type (param), (VALA_IS_ARRAY_TYPE (_tmp63) ? ((ValaArrayType*) (_tmp63)) : NULL)), (_tmp64 == NULL ? NULL : vala_code_node_ref (_tmp64)));
				if (array_type != NULL) {
					if (vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_IN) {
						if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) == vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							ValaCCodeIdentifier* _tmp65;
							_tmp65 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp65 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp65 == NULL ? NULL : (_tmp65 = (vala_ccode_node_unref (_tmp65), NULL)));
							if (!vala_method_get_no_array_length (m)) {
								ValaCCodeIdentifier* _tmp66;
								ValaCCodeFunctionCall* _tmp67;
								ValaCCodeFunctionCall* cstrvlen;
								ValaCCodeIdentifier* _tmp68;
								_tmp66 = NULL;
								_tmp67 = NULL;
								cstrvlen = (_tmp67 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp66 = vala_ccode_identifier_new ("g_strv_length")))), (_tmp66 == NULL ? NULL : (_tmp66 = (vala_ccode_node_unref (_tmp66), NULL))), _tmp67);
								_tmp68 = NULL;
								vala_ccode_function_call_add_argument (cstrvlen, VALA_CCODE_EXPRESSION ((_tmp68 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
								(_tmp68 == NULL ? NULL : (_tmp68 = (vala_ccode_node_unref (_tmp68), NULL)));
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION (cstrvlen));
								(cstrvlen == NULL ? NULL : (cstrvlen = (vala_ccode_node_unref (cstrvlen), NULL)));
							}
						} else {
							if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
								ValaCCodeMemberAccess* _tmp71;
								ValaCCodeIdentifier* _tmp70;
								char* _tmp69;
								_tmp71 = NULL;
								_tmp70 = NULL;
								_tmp69 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp71 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp70 = vala_ccode_identifier_new ((_tmp69 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "pdata"))));
								(_tmp71 == NULL ? NULL : (_tmp71 = (vala_ccode_node_unref (_tmp71), NULL)));
								(_tmp70 == NULL ? NULL : (_tmp70 = (vala_ccode_node_unref (_tmp70), NULL)));
								_tmp69 = (g_free (_tmp69), NULL);
								if (!vala_method_get_no_array_length (m)) {
									ValaCCodeMemberAccess* _tmp74;
									ValaCCodeIdentifier* _tmp73;
									char* _tmp72;
									_tmp74 = NULL;
									_tmp73 = NULL;
									_tmp72 = NULL;
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp74 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp73 = vala_ccode_identifier_new ((_tmp72 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "len"))));
									(_tmp74 == NULL ? NULL : (_tmp74 = (vala_ccode_node_unref (_tmp74), NULL)));
									(_tmp73 == NULL ? NULL : (_tmp73 = (vala_ccode_node_unref (_tmp73), NULL)));
									_tmp72 = (g_free (_tmp72), NULL);
								}
							} else {
								ValaCCodeMemberAccess* _tmp77;
								ValaCCodeIdentifier* _tmp76;
								char* _tmp75;
								_tmp77 = NULL;
								_tmp76 = NULL;
								_tmp75 = NULL;
								vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp77 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp76 = vala_ccode_identifier_new ((_tmp75 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "data"))));
								(_tmp77 == NULL ? NULL : (_tmp77 = (vala_ccode_node_unref (_tmp77), NULL)));
								(_tmp76 == NULL ? NULL : (_tmp76 = (vala_ccode_node_unref (_tmp76), NULL)));
								_tmp75 = (g_free (_tmp75), NULL);
								if (!vala_method_get_no_array_length (m)) {
									ValaCCodeMemberAccess* _tmp80;
									ValaCCodeIdentifier* _tmp79;
									char* _tmp78;
									_tmp80 = NULL;
									_tmp79 = NULL;
									_tmp78 = NULL;
									vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp80 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION ((_tmp79 = vala_ccode_identifier_new ((_tmp78 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param))))))), "len"))));
									(_tmp80 == NULL ? NULL : (_tmp80 = (vala_ccode_node_unref (_tmp80), NULL)));
									(_tmp79 == NULL ? NULL : (_tmp79 = (vala_ccode_node_unref (_tmp79), NULL)));
									_tmp78 = (g_free (_tmp78), NULL);
								}
							}
						}
					} else {
						if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
							char* _tmp81;
							ValaCCodeDeclaration* _tmp82;
							ValaCCodeDeclaration* cdecl_;
							ValaCCodeVariableDeclarator* _tmp83;
							ValaCCodeUnaryExpression* _tmp85;
							ValaCCodeIdentifier* _tmp84;
							_tmp81 = NULL;
							_tmp82 = NULL;
							cdecl_ = (_tmp82 = vala_ccode_declaration_new ((_tmp81 = vala_data_type_get_cname (vala_formal_parameter_get_parameter_type (param)))), (_tmp81 = (g_free (_tmp81), NULL)), _tmp82);
							_tmp83 = NULL;
							vala_ccode_declaration_add_declarator (cdecl_, VALA_CCODE_DECLARATOR ((_tmp83 = vala_ccode_variable_declarator_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp83 == NULL ? NULL : (_tmp83 = (vala_ccode_node_unref (_tmp83), NULL)));
							vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cdecl_));
							_tmp85 = NULL;
							_tmp84 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp85 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp84 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
							(_tmp85 == NULL ? NULL : (_tmp85 = (vala_ccode_node_unref (_tmp85), NULL)));
							(_tmp84 == NULL ? NULL : (_tmp84 = (vala_ccode_node_unref (_tmp84), NULL)));
							(cdecl_ == NULL ? NULL : (cdecl_ = (vala_ccode_node_unref (cdecl_), NULL)));
						} else {
							ValaCCodeIdentifier* _tmp86;
							_tmp86 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp86 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
							(_tmp86 == NULL ? NULL : (_tmp86 = (vala_ccode_node_unref (_tmp86), NULL)));
						}
						if (!vala_method_get_no_array_length (m)) {
							ValaCCodeDeclaration* len_cdecl;
							ValaCCodeVariableDeclarator* _tmp88;
							char* _tmp87;
							ValaCCodeUnaryExpression* _tmp91;
							ValaCCodeIdentifier* _tmp90;
							char* _tmp89;
							len_cdecl = vala_ccode_declaration_new ("int");
							_tmp88 = NULL;
							_tmp87 = NULL;
							vala_ccode_declaration_add_declarator (len_cdecl, VALA_CCODE_DECLARATOR ((_tmp88 = vala_ccode_variable_declarator_new ((_tmp87 = g_strdup_printf ("%s_length1", vala_symbol_get_name (VALA_SYMBOL (param))))))));
							(_tmp88 == NULL ? NULL : (_tmp88 = (vala_ccode_node_unref (_tmp88), NULL)));
							_tmp87 = (g_free (_tmp87), NULL);
							vala_ccode_block_add_statement (block, VALA_CCODE_NODE (len_cdecl));
							_tmp91 = NULL;
							_tmp90 = NULL;
							_tmp89 = NULL;
							vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp91 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp90 = vala_ccode_identifier_new ((_tmp89 = g_strdup_printf ("%s_length1", vala_symbol_get_name (VALA_SYMBOL (param)))))))))));
							(_tmp91 == NULL ? NULL : (_tmp91 = (vala_ccode_node_unref (_tmp91), NULL)));
							(_tmp90 == NULL ? NULL : (_tmp90 = (vala_ccode_node_unref (_tmp90), NULL)));
							_tmp89 = (g_free (_tmp89), NULL);
							(len_cdecl == NULL ? NULL : (len_cdecl = (vala_ccode_node_unref (len_cdecl), NULL)));
						}
					}
				} else {
					char* _tmp92;
					gboolean _tmp93;
					_tmp92 = NULL;
					if ((_tmp93 = g_str_has_prefix ((_tmp92 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp92 = (g_free (_tmp92), NULL)), _tmp93)) {
						ValaCCodeUnaryExpression* _tmp95;
						ValaCCodeIdentifier* _tmp94;
						/* struct input or output parameters*/
						_tmp95 = NULL;
						_tmp94 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp95 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp94 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param)))))))));
						(_tmp95 == NULL ? NULL : (_tmp95 = (vala_ccode_node_unref (_tmp95), NULL)));
						(_tmp94 == NULL ? NULL : (_tmp94 = (vala_ccode_node_unref (_tmp94), NULL)));
					} else {
						ValaCCodeIdentifier* _tmp96;
						_tmp96 = NULL;
						vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp96 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))));
						(_tmp96 == NULL ? NULL : (_tmp96 = (vala_ccode_node_unref (_tmp96), NULL)));
					}
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
				(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	expr = NULL;
	if (VALA_IS_VOID_TYPE (vala_method_get_return_type (m))) {
		ValaCCodeExpression* _tmp98;
		ValaCCodeExpression* _tmp97;
		_tmp98 = NULL;
		_tmp97 = NULL;
		expr = (_tmp98 = (_tmp97 = VALA_CCODE_EXPRESSION (ccall), (_tmp97 == NULL ? NULL : vala_ccode_node_ref (_tmp97))), (expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL))), _tmp98);
	} else {
		ValaArrayType* _tmp100;
		ValaDataType* _tmp99;
		ValaArrayType* array_type;
		_tmp100 = NULL;
		_tmp99 = NULL;
		array_type = (_tmp100 = (_tmp99 = vala_method_get_return_type (m), (VALA_IS_ARRAY_TYPE (_tmp99) ? ((ValaArrayType*) (_tmp99)) : NULL)), (_tmp100 == NULL ? NULL : vala_code_node_ref (_tmp100)));
		if (array_type != NULL) {
			ValaCCodeUnaryExpression* _tmp102;
			ValaCCodeIdentifier* _tmp101;
			_tmp102 = NULL;
			_tmp101 = NULL;
			vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp102 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp101 = vala_ccode_identifier_new ("result_length1")))))));
			(_tmp102 == NULL ? NULL : (_tmp102 = (vala_ccode_node_unref (_tmp102), NULL)));
			(_tmp101 == NULL ? NULL : (_tmp101 = (vala_ccode_node_unref (_tmp101), NULL)));
			if (vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
				ValaCCodeExpression* _tmp104;
				ValaCCodeIdentifier* _tmp103;
				_tmp104 = NULL;
				_tmp103 = NULL;
				expr = (_tmp104 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp103 = vala_ccode_identifier_new ("result"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL))), _tmp104);
				(_tmp103 == NULL ? NULL : (_tmp103 = (vala_ccode_node_unref (_tmp103), NULL)));
			} else {
				ValaCCodeExpression* _tmp106;
				ValaCCodeIdentifier* _tmp105;
				_tmp106 = NULL;
				_tmp105 = NULL;
				expr = (_tmp106 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp105 = vala_ccode_identifier_new ("*result"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL))), _tmp106);
				(_tmp105 == NULL ? NULL : (_tmp105 = (vala_ccode_node_unref (_tmp105), NULL)));
			}
		} else {
			ValaCCodeExpression* _tmp108;
			ValaCCodeIdentifier* _tmp107;
			_tmp108 = NULL;
			_tmp107 = NULL;
			expr = (_tmp108 = VALA_CCODE_EXPRESSION (vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp107 = vala_ccode_identifier_new ("*result"))), VALA_CCODE_EXPRESSION (ccall), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)), (expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL))), _tmp108);
			(_tmp107 == NULL ? NULL : (_tmp107 = (vala_ccode_node_unref (_tmp107), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	}
	_tmp109 = NULL;
	if ((_tmp110 = gee_collection_get_size (GEE_COLLECTION ((_tmp109 = vala_code_node_get_error_types (VALA_CODE_NODE (m))))) > 0, (_tmp109 == NULL ? NULL : (_tmp109 = (gee_collection_object_unref (_tmp109), NULL))), _tmp110)) {
		ValaCCodeIdentifier* _tmp111;
		_tmp111 = NULL;
		vala_ccode_function_call_add_argument (ccall, VALA_CCODE_EXPRESSION ((_tmp111 = vala_ccode_identifier_new ("error"))));
		(_tmp111 == NULL ? NULL : (_tmp111 = (vala_ccode_node_unref (_tmp111), NULL)));
	}
	_tmp112 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp112 = vala_ccode_expression_statement_new (expr))));
	(_tmp112 == NULL ? NULL : (_tmp112 = (vala_ccode_node_unref (_tmp112), NULL)));
	{
		GeeList* param_collection;
		int param_it;
		param_collection = vala_method_get_parameters (m);
		for (param_it = 0; param_it < gee_collection_get_size (GEE_COLLECTION (param_collection)); param_it = param_it + 1) {
			ValaFormalParameter* param;
			param = ((ValaFormalParameter*) (gee_list_get (GEE_LIST (param_collection), param_it)));
			{
				char* _tmp113;
				gboolean _tmp114;
				_tmp113 = NULL;
				if ((_tmp114 = vala_formal_parameter_get_direction (param) == VALA_PARAMETER_DIRECTION_OUT && g_str_has_prefix ((_tmp113 = vala_data_type_get_type_signature (vala_formal_parameter_get_parameter_type (param))), "("), (_tmp113 = (g_free (_tmp113), NULL)), _tmp114)) {
					ValaStruct* _tmp115;
					ValaStruct* st;
					ValaCCodeIdentifier* _tmp116;
					ValaCCodeFunctionCall* _tmp117;
					ValaCCodeFunctionCall* array_construct;
					ValaCCodeConstant* _tmp118;
					ValaCCodeIdentifier* _tmp120;
					char* _tmp119;
					ValaCCodeUnaryExpression* _tmp121;
					ValaCCodeUnaryExpression* dbus_param;
					ValaCCodeExpressionStatement* _tmp123;
					ValaCCodeAssignment* _tmp122;
					ValaCCodeIdentifier* _tmp124;
					ValaCCodeFunctionCall* _tmp125;
					ValaCCodeFunctionCall* type_call;
					ValaCCodeConstant* _tmp126;
					/* struct output parameter*/
					_tmp115 = NULL;
					st = (_tmp115 = VALA_STRUCT (vala_data_type_get_data_type (vala_formal_parameter_get_parameter_type (param))), (_tmp115 == NULL ? NULL : vala_code_node_ref (_tmp115)));
					_tmp116 = NULL;
					_tmp117 = NULL;
					array_construct = (_tmp117 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp116 = vala_ccode_identifier_new ("g_value_array_new")))), (_tmp116 == NULL ? NULL : (_tmp116 = (vala_ccode_node_unref (_tmp116), NULL))), _tmp117);
					_tmp118 = NULL;
					vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp118 = vala_ccode_constant_new ("0"))));
					(_tmp118 == NULL ? NULL : (_tmp118 = (vala_ccode_node_unref (_tmp118), NULL)));
					_tmp120 = NULL;
					_tmp119 = NULL;
					_tmp121 = NULL;
					dbus_param = (_tmp121 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp120 = vala_ccode_identifier_new ((_tmp119 = g_strdup_printf ("dbus_%s", vala_symbol_get_name (VALA_SYMBOL (param)))))))), (_tmp120 == NULL ? NULL : (_tmp120 = (vala_ccode_node_unref (_tmp120), NULL))), (_tmp119 = (g_free (_tmp119), NULL)), _tmp121);
					_tmp123 = NULL;
					_tmp122 = NULL;
					vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp123 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp122 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (dbus_param), VALA_CCODE_EXPRESSION (array_construct), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
					(_tmp123 == NULL ? NULL : (_tmp123 = (vala_ccode_node_unref (_tmp123), NULL)));
					(_tmp122 == NULL ? NULL : (_tmp122 = (vala_ccode_node_unref (_tmp122), NULL)));
					_tmp124 = NULL;
					_tmp125 = NULL;
					type_call = (_tmp125 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp124 = vala_ccode_identifier_new ("dbus_g_type_get_struct")))), (_tmp124 == NULL ? NULL : (_tmp124 = (vala_ccode_node_unref (_tmp124), NULL))), _tmp125);
					_tmp126 = NULL;
					vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp126 = vala_ccode_constant_new ("\"GValueArray\""))));
					(_tmp126 == NULL ? NULL : (_tmp126 = (vala_ccode_node_unref (_tmp126), NULL)));
					{
						GeeList* f_collection;
						int f_it;
						f_collection = vala_struct_get_fields (st);
						for (f_it = 0; f_it < gee_collection_get_size (GEE_COLLECTION (f_collection)); f_it = f_it + 1) {
							ValaField* f;
							f = ((ValaField*) (gee_list_get (GEE_LIST (f_collection), f_it)));
							{
								char* val_name;
								ValaCCodeInitializerList* cvalinit;
								ValaCCodeConstant* _tmp127;
								ValaCCodeDeclaration* cval_decl;
								ValaCCodeVariableDeclarator* _tmp128;
								ValaCCodeIdentifier* _tmp129;
								ValaCCodeUnaryExpression* _tmp130;
								ValaCCodeUnaryExpression* val_ptr;
								ValaCCodeIdentifier* _tmp131;
								ValaCCodeFunctionCall* _tmp132;
								ValaCCodeFunctionCall* cinit_call;
								ValaCCodeIdentifier* _tmp134;
								char* _tmp133;
								ValaCCodeExpressionStatement* _tmp135;
								ValaCCodeIdentifier* _tmp137;
								char* _tmp136;
								ValaCCodeFunctionCall* _tmp138;
								ValaCCodeFunctionCall* cset_call;
								ValaCCodeMemberAccess* _tmp140;
								ValaCCodeIdentifier* _tmp139;
								ValaCCodeExpressionStatement* _tmp141;
								ValaCCodeIdentifier* _tmp142;
								ValaCCodeFunctionCall* _tmp143;
								ValaCCodeFunctionCall* cappend_call;
								ValaCCodeExpressionStatement* _tmp144;
								ValaCCodeIdentifier* _tmp146;
								char* _tmp145;
								if (vala_field_get_binding (f) != MEMBER_BINDING_INSTANCE) {
									(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
									continue;
								}
								val_name = g_strdup_printf ("val_%s_%s", vala_symbol_get_name (VALA_SYMBOL (param)), vala_symbol_get_name (VALA_SYMBOL (f)));
								/* 0-initialize struct with struct initializer { 0 }*/
								cvalinit = vala_ccode_initializer_list_new ();
								_tmp127 = NULL;
								vala_ccode_initializer_list_append (cvalinit, VALA_CCODE_EXPRESSION ((_tmp127 = vala_ccode_constant_new ("0"))));
								(_tmp127 == NULL ? NULL : (_tmp127 = (vala_ccode_node_unref (_tmp127), NULL)));
								cval_decl = vala_ccode_declaration_new ("GValue");
								_tmp128 = NULL;
								vala_ccode_declaration_add_declarator (cval_decl, VALA_CCODE_DECLARATOR ((_tmp128 = vala_ccode_variable_declarator_new_with_initializer (val_name, VALA_CCODE_EXPRESSION (cvalinit)))));
								(_tmp128 == NULL ? NULL : (_tmp128 = (vala_ccode_node_unref (_tmp128), NULL)));
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE (cval_decl));
								_tmp129 = NULL;
								_tmp130 = NULL;
								val_ptr = (_tmp130 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_ADDRESS_OF, VALA_CCODE_EXPRESSION ((_tmp129 = vala_ccode_identifier_new (val_name)))), (_tmp129 == NULL ? NULL : (_tmp129 = (vala_ccode_node_unref (_tmp129), NULL))), _tmp130);
								_tmp131 = NULL;
								_tmp132 = NULL;
								cinit_call = (_tmp132 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp131 = vala_ccode_identifier_new ("g_value_init")))), (_tmp131 == NULL ? NULL : (_tmp131 = (vala_ccode_node_unref (_tmp131), NULL))), _tmp132);
								vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp134 = NULL;
								_tmp133 = NULL;
								vala_ccode_function_call_add_argument (cinit_call, VALA_CCODE_EXPRESSION ((_tmp134 = vala_ccode_identifier_new ((_tmp133 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp134 == NULL ? NULL : (_tmp134 = (vala_ccode_node_unref (_tmp134), NULL)));
								_tmp133 = (g_free (_tmp133), NULL);
								_tmp135 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp135 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cinit_call)))));
								(_tmp135 == NULL ? NULL : (_tmp135 = (vala_ccode_node_unref (_tmp135), NULL)));
								_tmp137 = NULL;
								_tmp136 = NULL;
								_tmp138 = NULL;
								cset_call = (_tmp138 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp137 = vala_ccode_identifier_new ((_tmp136 = vala_typesymbol_get_set_value_function (vala_data_type_get_data_type (vala_field_get_field_type (f)))))))), (_tmp137 == NULL ? NULL : (_tmp137 = (vala_ccode_node_unref (_tmp137), NULL))), (_tmp136 = (g_free (_tmp136), NULL)), _tmp138);
								vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp140 = NULL;
								_tmp139 = NULL;
								vala_ccode_function_call_add_argument (cset_call, VALA_CCODE_EXPRESSION ((_tmp140 = vala_ccode_member_access_new (VALA_CCODE_EXPRESSION ((_tmp139 = vala_ccode_identifier_new (vala_symbol_get_name (VALA_SYMBOL (param))))), vala_symbol_get_name (VALA_SYMBOL (f)), FALSE))));
								(_tmp140 == NULL ? NULL : (_tmp140 = (vala_ccode_node_unref (_tmp140), NULL)));
								(_tmp139 == NULL ? NULL : (_tmp139 = (vala_ccode_node_unref (_tmp139), NULL)));
								_tmp141 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp141 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cset_call)))));
								(_tmp141 == NULL ? NULL : (_tmp141 = (vala_ccode_node_unref (_tmp141), NULL)));
								_tmp142 = NULL;
								_tmp143 = NULL;
								cappend_call = (_tmp143 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp142 = vala_ccode_identifier_new ("g_value_array_append")))), (_tmp142 == NULL ? NULL : (_tmp142 = (vala_ccode_node_unref (_tmp142), NULL))), _tmp143);
								vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (dbus_param));
								vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (val_ptr));
								_tmp144 = NULL;
								vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp144 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cappend_call)))));
								(_tmp144 == NULL ? NULL : (_tmp144 = (vala_ccode_node_unref (_tmp144), NULL)));
								_tmp146 = NULL;
								_tmp145 = NULL;
								vala_ccode_function_call_add_argument (type_call, VALA_CCODE_EXPRESSION ((_tmp146 = vala_ccode_identifier_new ((_tmp145 = vala_typesymbol_get_type_id (vala_data_type_get_data_type (vala_field_get_field_type (f))))))));
								(_tmp146 == NULL ? NULL : (_tmp146 = (vala_ccode_node_unref (_tmp146), NULL)));
								_tmp145 = (g_free (_tmp145), NULL);
								(f == NULL ? NULL : (f = (vala_code_node_unref (f), NULL)));
								val_name = (g_free (val_name), NULL);
								(cvalinit == NULL ? NULL : (cvalinit = (vala_ccode_node_unref (cvalinit), NULL)));
								(cval_decl == NULL ? NULL : (cval_decl = (vala_ccode_node_unref (cval_decl), NULL)));
								(val_ptr == NULL ? NULL : (val_ptr = (vala_ccode_node_unref (val_ptr), NULL)));
								(cinit_call == NULL ? NULL : (cinit_call = (vala_ccode_node_unref (cinit_call), NULL)));
								(cset_call == NULL ? NULL : (cset_call = (vala_ccode_node_unref (cset_call), NULL)));
								(cappend_call == NULL ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL)));
							}
						}
						(f_collection == NULL ? NULL : (f_collection = (gee_collection_object_unref (f_collection), NULL)));
					}
					(st == NULL ? NULL : (st = (vala_code_node_unref (st), NULL)));
					(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
					(dbus_param == NULL ? NULL : (dbus_param = (vala_ccode_node_unref (dbus_param), NULL)));
					(type_call == NULL ? NULL : (type_call = (vala_ccode_node_unref (type_call), NULL)));
				}
				(param == NULL ? NULL : (param = (vala_code_node_unref (param), NULL)));
			}
		}
		(param_collection == NULL ? NULL : (param_collection = (gee_collection_object_unref (param_collection), NULL)));
	}
	if (!(VALA_IS_VOID_TYPE (vala_method_get_return_type (m)))) {
		ValaArrayType* _tmp148;
		ValaDataType* _tmp147;
		ValaArrayType* array_type;
		_tmp148 = NULL;
		_tmp147 = NULL;
		array_type = (_tmp148 = (_tmp147 = vala_method_get_return_type (m), (VALA_IS_ARRAY_TYPE (_tmp147) ? ((ValaArrayType*) (_tmp147)) : NULL)), (_tmp148 == NULL ? NULL : vala_code_node_ref (_tmp148)));
		if (array_type != NULL && vala_data_type_get_data_type (vala_array_type_get_element_type (array_type)) != vala_data_type_get_data_type (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->string_type)) {
			ValaCCodeIdentifier* _tmp149;
			ValaCCodeUnaryExpression* _tmp150;
			ValaCCodeUnaryExpression* garray;
			ValaCCodeIdentifier* _tmp151;
			ValaCCodeFunctionCall* _tmp152;
			ValaCCodeFunctionCall* sizeof_call;
			ValaCCodeIdentifier* _tmp154;
			char* _tmp153;
			_tmp149 = NULL;
			_tmp150 = NULL;
			garray = (_tmp150 = vala_ccode_unary_expression_new (VALA_CCODE_UNARY_OPERATOR_POINTER_INDIRECTION, VALA_CCODE_EXPRESSION ((_tmp149 = vala_ccode_identifier_new ("dbus_result")))), (_tmp149 == NULL ? NULL : (_tmp149 = (vala_ccode_node_unref (_tmp149), NULL))), _tmp150);
			_tmp151 = NULL;
			_tmp152 = NULL;
			sizeof_call = (_tmp152 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp151 = vala_ccode_identifier_new ("sizeof")))), (_tmp151 == NULL ? NULL : (_tmp151 = (vala_ccode_node_unref (_tmp151), NULL))), _tmp152);
			_tmp154 = NULL;
			_tmp153 = NULL;
			vala_ccode_function_call_add_argument (sizeof_call, VALA_CCODE_EXPRESSION ((_tmp154 = vala_ccode_identifier_new ((_tmp153 = vala_data_type_get_cname (vala_array_type_get_element_type (array_type)))))));
			(_tmp154 == NULL ? NULL : (_tmp154 = (vala_ccode_node_unref (_tmp154), NULL)));
			_tmp153 = (g_free (_tmp153), NULL);
			if (vala_ccode_generator_dbus_use_ptr_array (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self)), array_type)) {
				ValaCCodeIdentifier* _tmp155;
				ValaCCodeFunctionCall* _tmp156;
				ValaCCodeFunctionCall* array_construct;
				ValaCCodeIdentifier* _tmp157;
				ValaCCodeExpressionStatement* _tmp159;
				ValaCCodeAssignment* _tmp158;
				ValaCCodeIdentifier* _tmp160;
				ValaCCodeFunctionCall* _tmp161;
				ValaCCodeFunctionCall* memcpy_call;
				ValaCCodeMemberAccess* _tmp162;
				ValaCCodeIdentifier* _tmp163;
				ValaCCodeBinaryExpression* _tmp165;
				ValaCCodeIdentifier* _tmp164;
				ValaCCodeExpressionStatement* _tmp166;
				ValaCCodeIdentifier* _tmp168;
				ValaCCodeMemberAccess* _tmp167;
				ValaCCodeAssignment* _tmp169;
				ValaCCodeAssignment* len_assignment;
				ValaCCodeExpressionStatement* _tmp170;
				_tmp155 = NULL;
				_tmp156 = NULL;
				array_construct = (_tmp156 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp155 = vala_ccode_identifier_new ("g_ptr_array_sized_new")))), (_tmp155 == NULL ? NULL : (_tmp155 = (vala_ccode_node_unref (_tmp155), NULL))), _tmp156);
				_tmp157 = NULL;
				vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp157 = vala_ccode_identifier_new ("result_length1"))));
				(_tmp157 == NULL ? NULL : (_tmp157 = (vala_ccode_node_unref (_tmp157), NULL)));
				_tmp159 = NULL;
				_tmp158 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp159 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp158 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (garray), VALA_CCODE_EXPRESSION (array_construct), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp159 == NULL ? NULL : (_tmp159 = (vala_ccode_node_unref (_tmp159), NULL)));
				(_tmp158 == NULL ? NULL : (_tmp158 = (vala_ccode_node_unref (_tmp158), NULL)));
				_tmp160 = NULL;
				_tmp161 = NULL;
				memcpy_call = (_tmp161 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp160 = vala_ccode_identifier_new ("memcpy")))), (_tmp160 == NULL ? NULL : (_tmp160 = (vala_ccode_node_unref (_tmp160), NULL))), _tmp161);
				_tmp162 = NULL;
				vala_ccode_function_call_add_argument (memcpy_call, VALA_CCODE_EXPRESSION ((_tmp162 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (garray), "pdata"))));
				(_tmp162 == NULL ? NULL : (_tmp162 = (vala_ccode_node_unref (_tmp162), NULL)));
				_tmp163 = NULL;
				vala_ccode_function_call_add_argument (memcpy_call, VALA_CCODE_EXPRESSION ((_tmp163 = vala_ccode_identifier_new ("result"))));
				(_tmp163 == NULL ? NULL : (_tmp163 = (vala_ccode_node_unref (_tmp163), NULL)));
				_tmp165 = NULL;
				_tmp164 = NULL;
				vala_ccode_function_call_add_argument (memcpy_call, VALA_CCODE_EXPRESSION ((_tmp165 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_MUL, VALA_CCODE_EXPRESSION ((_tmp164 = vala_ccode_identifier_new ("result_length1"))), VALA_CCODE_EXPRESSION (sizeof_call)))));
				(_tmp165 == NULL ? NULL : (_tmp165 = (vala_ccode_node_unref (_tmp165), NULL)));
				(_tmp164 == NULL ? NULL : (_tmp164 = (vala_ccode_node_unref (_tmp164), NULL)));
				_tmp166 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp166 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (memcpy_call)))));
				(_tmp166 == NULL ? NULL : (_tmp166 = (vala_ccode_node_unref (_tmp166), NULL)));
				_tmp168 = NULL;
				_tmp167 = NULL;
				_tmp169 = NULL;
				len_assignment = (_tmp169 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION ((_tmp167 = vala_ccode_member_access_new_pointer (VALA_CCODE_EXPRESSION (garray), "len"))), VALA_CCODE_EXPRESSION ((_tmp168 = vala_ccode_identifier_new ("result_length1"))), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE), (_tmp168 == NULL ? NULL : (_tmp168 = (vala_ccode_node_unref (_tmp168), NULL))), (_tmp167 == NULL ? NULL : (_tmp167 = (vala_ccode_node_unref (_tmp167), NULL))), _tmp169);
				_tmp170 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp170 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (len_assignment)))));
				(_tmp170 == NULL ? NULL : (_tmp170 = (vala_ccode_node_unref (_tmp170), NULL)));
				(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
				(memcpy_call == NULL ? NULL : (memcpy_call = (vala_ccode_node_unref (memcpy_call), NULL)));
				(len_assignment == NULL ? NULL : (len_assignment = (vala_ccode_node_unref (len_assignment), NULL)));
			} else {
				ValaCCodeIdentifier* _tmp171;
				ValaCCodeFunctionCall* _tmp172;
				ValaCCodeFunctionCall* array_construct;
				ValaCCodeConstant* _tmp173;
				ValaCCodeConstant* _tmp174;
				ValaCCodeExpressionStatement* _tmp176;
				ValaCCodeAssignment* _tmp175;
				ValaCCodeIdentifier* _tmp177;
				ValaCCodeFunctionCall* _tmp178;
				ValaCCodeFunctionCall* cappend_call;
				ValaCCodeIdentifier* _tmp179;
				ValaCCodeIdentifier* _tmp180;
				ValaCCodeExpressionStatement* _tmp181;
				_tmp171 = NULL;
				_tmp172 = NULL;
				array_construct = (_tmp172 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp171 = vala_ccode_identifier_new ("g_array_new")))), (_tmp171 == NULL ? NULL : (_tmp171 = (vala_ccode_node_unref (_tmp171), NULL))), _tmp172);
				_tmp173 = NULL;
				vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp173 = vala_ccode_constant_new ("TRUE"))));
				(_tmp173 == NULL ? NULL : (_tmp173 = (vala_ccode_node_unref (_tmp173), NULL)));
				_tmp174 = NULL;
				vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION ((_tmp174 = vala_ccode_constant_new ("TRUE"))));
				(_tmp174 == NULL ? NULL : (_tmp174 = (vala_ccode_node_unref (_tmp174), NULL)));
				vala_ccode_function_call_add_argument (array_construct, VALA_CCODE_EXPRESSION (sizeof_call));
				_tmp176 = NULL;
				_tmp175 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp176 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION ((_tmp175 = vala_ccode_assignment_new (VALA_CCODE_EXPRESSION (garray), VALA_CCODE_EXPRESSION (array_construct), VALA_CCODE_ASSIGNMENT_OPERATOR_SIMPLE)))))));
				(_tmp176 == NULL ? NULL : (_tmp176 = (vala_ccode_node_unref (_tmp176), NULL)));
				(_tmp175 == NULL ? NULL : (_tmp175 = (vala_ccode_node_unref (_tmp175), NULL)));
				_tmp177 = NULL;
				_tmp178 = NULL;
				cappend_call = (_tmp178 = vala_ccode_function_call_new (VALA_CCODE_EXPRESSION ((_tmp177 = vala_ccode_identifier_new ("g_array_append_vals")))), (_tmp177 == NULL ? NULL : (_tmp177 = (vala_ccode_node_unref (_tmp177), NULL))), _tmp178);
				vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION (garray));
				_tmp179 = NULL;
				vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp179 = vala_ccode_identifier_new ("result"))));
				(_tmp179 == NULL ? NULL : (_tmp179 = (vala_ccode_node_unref (_tmp179), NULL)));
				_tmp180 = NULL;
				vala_ccode_function_call_add_argument (cappend_call, VALA_CCODE_EXPRESSION ((_tmp180 = vala_ccode_identifier_new ("result_length1"))));
				(_tmp180 == NULL ? NULL : (_tmp180 = (vala_ccode_node_unref (_tmp180), NULL)));
				_tmp181 = NULL;
				vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp181 = vala_ccode_expression_statement_new (VALA_CCODE_EXPRESSION (cappend_call)))));
				(_tmp181 == NULL ? NULL : (_tmp181 = (vala_ccode_node_unref (_tmp181), NULL)));
				(array_construct == NULL ? NULL : (array_construct = (vala_ccode_node_unref (array_construct), NULL)));
				(cappend_call == NULL ? NULL : (cappend_call = (vala_ccode_node_unref (cappend_call), NULL)));
			}
			(garray == NULL ? NULL : (garray = (vala_ccode_node_unref (garray), NULL)));
			(sizeof_call == NULL ? NULL : (sizeof_call = (vala_ccode_node_unref (sizeof_call), NULL)));
		}
		(array_type == NULL ? NULL : (array_type = (vala_code_node_unref (array_type), NULL)));
	}
	_tmp183 = NULL;
	_tmp182 = NULL;
	_tmp184 = NULL;
	no_error = (_tmp184 = vala_ccode_binary_expression_new (VALA_CCODE_BINARY_OPERATOR_OR, VALA_CCODE_EXPRESSION ((_tmp182 = vala_ccode_identifier_new ("!error"))), VALA_CCODE_EXPRESSION ((_tmp183 = vala_ccode_identifier_new ("!*error")))), (_tmp183 == NULL ? NULL : (_tmp183 = (vala_ccode_node_unref (_tmp183), NULL))), (_tmp182 == NULL ? NULL : (_tmp182 = (vala_ccode_node_unref (_tmp182), NULL))), _tmp184);
	_tmp185 = NULL;
	vala_ccode_block_add_statement (block, VALA_CCODE_NODE ((_tmp185 = vala_ccode_return_statement_new (VALA_CCODE_EXPRESSION (no_error)))));
	(_tmp185 == NULL ? NULL : (_tmp185 = (vala_ccode_node_unref (_tmp185), NULL)));
	/* append to file*/
	_tmp186 = NULL;
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_declaration, VALA_CCODE_NODE ((_tmp186 = vala_ccode_function_copy (function))));
	(_tmp186 == NULL ? NULL : (_tmp186 = (vala_ccode_node_unref (_tmp186), NULL)));
	vala_ccode_function_set_block (function, block);
	vala_ccode_fragment_append (vala_ccode_binding_get_codegen (VALA_CCODE_BINDING (self))->source_type_member_definition, VALA_CCODE_NODE (function));
	_tmp187 = NULL;
	return (_tmp187 = wrapper_name, (function == NULL ? NULL : (function = (vala_ccode_node_unref (function), NULL))), (block == NULL ? NULL : (block = (vala_ccode_node_unref (block), NULL))), (ccall == NULL ? NULL : (ccall = (vala_ccode_node_unref (ccall), NULL))), (expr == NULL ? NULL : (expr = (vala_ccode_node_unref (expr), NULL))), (no_error == NULL ? NULL : (no_error = (vala_ccode_node_unref (no_error), NULL))), _tmp187);
}


static void vala_ccode_object_type_symbol_binding_class_init (ValaCCodeObjectTypeSymbolBindingClass * klass) {
	vala_ccode_object_type_symbol_binding_parent_class = g_type_class_peek_parent (klass);
}


static void vala_ccode_object_type_symbol_binding_instance_init (ValaCCodeObjectTypeSymbolBinding * self) {
}


GType vala_ccode_object_type_symbol_binding_get_type (void) {
	static GType vala_ccode_object_type_symbol_binding_type_id = 0;
	if (vala_ccode_object_type_symbol_binding_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeObjectTypeSymbolBindingClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_object_type_symbol_binding_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeObjectTypeSymbolBinding), 0, (GInstanceInitFunc) vala_ccode_object_type_symbol_binding_instance_init, NULL };
		vala_ccode_object_type_symbol_binding_type_id = g_type_register_static (VALA_TYPE_CCODE_TYPE_SYMBOL_BINDING, "ValaCCodeObjectTypeSymbolBinding", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	}
	return vala_ccode_object_type_symbol_binding_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




