/* readonlymap.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/readonlymap.h>
#include <gee/readonlyset.h>
#include <gee/readonlycollection.h>




struct _GeeReadOnlyMapPrivate {
	GeeMap* _map;
	GType k_type;
	GBoxedCopyFunc k_dup_func;
	GDestroyNotify k_destroy_func;
	GType v_type;
	GBoxedCopyFunc v_dup_func;
	GDestroyNotify v_destroy_func;
};

#define GEE_READ_ONLY_MAP_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapPrivate))
enum  {
	GEE_READ_ONLY_MAP_DUMMY_PROPERTY
};
static GeeSet* gee_read_only_map_real_get_keys (GeeMap* base);
static GeeCollection* gee_read_only_map_real_get_values (GeeMap* base);
static gboolean gee_read_only_map_real_contains (GeeMap* base, gconstpointer key);
static gpointer gee_read_only_map_real_get (GeeMap* base, gconstpointer key);
static void gee_read_only_map_real_set (GeeMap* base, gconstpointer key, gconstpointer value);
static gboolean gee_read_only_map_real_remove (GeeMap* base, gconstpointer key);
static void gee_read_only_map_real_clear (GeeMap* base);
static gpointer gee_read_only_map_parent_class = NULL;
static GeeMapIface* gee_read_only_map_gee_map_parent_iface = NULL;
static void gee_read_only_map_finalize (GeeCollectionObject* obj);



GeeReadOnlyMap* gee_read_only_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map) {
	GeeReadOnlyMap* self;
	g_return_val_if_fail (map == NULL || GEE_IS_MAP (map), NULL);
	self = ((GeeReadOnlyMap*) (g_type_create_instance (object_type)));
	self->priv->k_type = k_type;
	self->priv->k_dup_func = k_dup_func;
	self->priv->k_destroy_func = k_destroy_func;
	self->priv->v_type = v_type;
	self->priv->v_dup_func = v_dup_func;
	self->priv->v_destroy_func = v_destroy_func;
	gee_read_only_map_set_map (self, map);
	return self;
}


GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map) {
	return gee_read_only_map_construct (GEE_TYPE_READ_ONLY_MAP, k_type, k_dup_func, k_destroy_func, v_type, v_dup_func, v_destroy_func, map);
}


static GeeSet* gee_read_only_map_real_get_keys (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return GEE_SET (gee_read_only_set_new (self->priv->k_type, ((GBoxedCopyFunc) (self->priv->k_dup_func)), self->priv->k_destroy_func, NULL));
	}
	return gee_map_get_keys (self->priv->_map);
}


static GeeCollection* gee_read_only_map_real_get_values (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return GEE_COLLECTION (gee_read_only_collection_new (self->priv->v_type, ((GBoxedCopyFunc) (self->priv->v_dup_func)), self->priv->v_destroy_func, NULL));
	}
	return gee_map_get_values (self->priv->_map);
}


static gboolean gee_read_only_map_real_contains (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return FALSE;
	}
	return gee_map_contains (self->priv->_map, key);
}


static gpointer gee_read_only_map_real_get (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	if (self->priv->_map == NULL) {
		return NULL;
	}
	return gee_map_get (self->priv->_map, key);
}


static void gee_read_only_map_real_set (GeeMap* base, gconstpointer key, gconstpointer value) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	g_assert_not_reached ();
}


static gboolean gee_read_only_map_real_remove (GeeMap* base, gconstpointer key) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	g_assert_not_reached ();
}


static void gee_read_only_map_real_clear (GeeMap* base) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (base);
	g_assert_not_reached ();
}


static gint gee_read_only_map_real_get_size (GeeMap* base) {
	GeeReadOnlyMap* self;
	self = GEE_READ_ONLY_MAP (base);
	return gee_map_get_size (self->priv->_map);
}


void gee_read_only_map_set_map (GeeReadOnlyMap* self, GeeMap* value) {
	GeeMap* _tmp1;
	GeeMap* _tmp0;
	g_return_if_fail (GEE_IS_READ_ONLY_MAP (self));
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->_map = (_tmp1 = (_tmp0 = value, (_tmp0 == NULL ? NULL : gee_collection_object_ref (_tmp0))), (self->priv->_map == NULL ? NULL : (self->priv->_map = (gee_collection_object_unref (self->priv->_map), NULL))), _tmp1);
}


static void gee_read_only_map_class_init (GeeReadOnlyMapClass * klass) {
	gee_read_only_map_parent_class = g_type_class_peek_parent (klass);
	GEE_COLLECTION_OBJECT_CLASS (klass)->finalize = gee_read_only_map_finalize;
	g_type_class_add_private (klass, sizeof (GeeReadOnlyMapPrivate));
}


static void gee_read_only_map_gee_map_interface_init (GeeMapIface * iface) {
	gee_read_only_map_gee_map_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_keys = gee_read_only_map_real_get_keys;
	iface->get_values = gee_read_only_map_real_get_values;
	iface->contains = gee_read_only_map_real_contains;
	iface->get = gee_read_only_map_real_get;
	iface->set = gee_read_only_map_real_set;
	iface->remove = gee_read_only_map_real_remove;
	iface->clear = gee_read_only_map_real_clear;
	iface->get_size = gee_read_only_map_real_get_size;
}


static void gee_read_only_map_instance_init (GeeReadOnlyMap * self) {
	self->priv = GEE_READ_ONLY_MAP_GET_PRIVATE (self);
}


static void gee_read_only_map_finalize (GeeCollectionObject* obj) {
	GeeReadOnlyMap * self;
	self = GEE_READ_ONLY_MAP (obj);
	(self->priv->_map == NULL ? NULL : (self->priv->_map = (gee_collection_object_unref (self->priv->_map), NULL)));
	GEE_COLLECTION_OBJECT_CLASS (gee_read_only_map_parent_class)->finalize (obj);
}


GType gee_read_only_map_get_type (void) {
	static GType gee_read_only_map_type_id = 0;
	if (gee_read_only_map_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyMapClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_map_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyMap), 0, (GInstanceInitFunc) gee_read_only_map_instance_init, NULL };
		static const GInterfaceInfo gee_map_info = { (GInterfaceInitFunc) gee_read_only_map_gee_map_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_map_type_id = g_type_register_static (GEE_TYPE_COLLECTION_OBJECT, "GeeReadOnlyMap", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_map_type_id, GEE_TYPE_MAP, &gee_map_info);
	}
	return gee_read_only_map_type_id;
}




