/* valaccodeforstatement.vala
 *
 * Copyright (C) 2006-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <ccode/valaccodeforstatement.h>
#include <gee/arraylist.h>
#include <gee/list.h>
#include <gee/collection.h>
#include <stdlib.h>
#include <string.h>
#include <ccode/valaccodenode.h>
#include <ccode/valaccodelinedirective.h>




struct _ValaCCodeForStatementPrivate {
	ValaCCodeExpression* _condition;
	ValaCCodeStatement* _body;
	GeeList* initializer;
	GeeList* iterator;
};

#define VALA_CCODE_FOR_STATEMENT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CCODE_FOR_STATEMENT, ValaCCodeForStatementPrivate))
enum  {
	VALA_CCODE_FOR_STATEMENT_DUMMY_PROPERTY
};
static void vala_ccode_for_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer);
static gpointer vala_ccode_for_statement_parent_class = NULL;
static void vala_ccode_for_statement_finalize (ValaCCodeNode* obj);



ValaCCodeForStatement* vala_ccode_for_statement_construct (GType object_type, ValaCCodeExpression* condition, ValaCCodeStatement* body) {
	ValaCCodeForStatement* self;
	g_return_val_if_fail (condition == NULL || VALA_IS_CCODE_EXPRESSION (condition), NULL);
	g_return_val_if_fail (body == NULL || VALA_IS_CCODE_STATEMENT (body), NULL);
	self = ((ValaCCodeForStatement*) (g_type_create_instance (object_type)));
	vala_ccode_for_statement_set_condition (self, condition);
	vala_ccode_for_statement_set_body (self, body);
	return self;
}


ValaCCodeForStatement* vala_ccode_for_statement_new (ValaCCodeExpression* condition, ValaCCodeStatement* body) {
	return vala_ccode_for_statement_construct (VALA_TYPE_CCODE_FOR_STATEMENT, condition, body);
}


/**
 * Appends the specified expression to the list of initializers.
 *
 * @param expr an initializer expression
 */
void vala_ccode_for_statement_add_initializer (ValaCCodeForStatement* self, ValaCCodeExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->initializer), expr);
}


/**
 * Appends the specified expression to the iterator.
 *
 * @param expr an iterator expression
 */
void vala_ccode_for_statement_add_iterator (ValaCCodeForStatement* self, ValaCCodeExpression* expr) {
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	g_return_if_fail (VALA_IS_CCODE_EXPRESSION (expr));
	gee_collection_add (GEE_COLLECTION (self->priv->iterator), expr);
}


static void vala_ccode_for_statement_real_write (ValaCCodeNode* base, ValaCCodeWriter* writer) {
	ValaCCodeForStatement * self;
	gboolean first;
	self = VALA_CCODE_FOR_STATEMENT (base);
	g_return_if_fail (VALA_IS_CCODE_WRITER (writer));
	first = FALSE;
	vala_ccode_writer_write_indent (writer, vala_ccode_node_get_line (VALA_CCODE_NODE (self)));
	vala_ccode_writer_write_string (writer, "for (");
	first = TRUE;
	{
		GeeList* init_expr_collection;
		int init_expr_it;
		init_expr_collection = self->priv->initializer;
		for (init_expr_it = 0; init_expr_it < gee_collection_get_size (GEE_COLLECTION (init_expr_collection)); init_expr_it = init_expr_it + 1) {
			ValaCCodeExpression* init_expr;
			init_expr = ((ValaCCodeExpression*) (gee_list_get (GEE_LIST (init_expr_collection), init_expr_it)));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (init_expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (init_expr), writer);
				}
				(init_expr == NULL ? NULL : (init_expr = (vala_ccode_node_unref (init_expr), NULL)));
			}
		}
	}
	vala_ccode_writer_write_string (writer, "; ");
	if (self->priv->_condition != NULL) {
		vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_condition), writer);
	}
	vala_ccode_writer_write_string (writer, "; ");
	first = TRUE;
	{
		GeeList* it_expr_collection;
		int it_expr_it;
		it_expr_collection = self->priv->iterator;
		for (it_expr_it = 0; it_expr_it < gee_collection_get_size (GEE_COLLECTION (it_expr_collection)); it_expr_it = it_expr_it + 1) {
			ValaCCodeExpression* it_expr;
			it_expr = ((ValaCCodeExpression*) (gee_list_get (GEE_LIST (it_expr_collection), it_expr_it)));
			{
				if (!first) {
					vala_ccode_writer_write_string (writer, ", ");
				} else {
					first = FALSE;
				}
				if (it_expr != NULL) {
					vala_ccode_node_write (VALA_CCODE_NODE (it_expr), writer);
				}
				(it_expr == NULL ? NULL : (it_expr = (vala_ccode_node_unref (it_expr), NULL)));
			}
		}
	}
	vala_ccode_writer_write_string (writer, ")");
	vala_ccode_node_write (VALA_CCODE_NODE (self->priv->_body), writer);
}


ValaCCodeExpression* vala_ccode_for_statement_get_condition (ValaCCodeForStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self), NULL);
	return self->priv->_condition;
}


void vala_ccode_for_statement_set_condition (ValaCCodeForStatement* self, ValaCCodeExpression* value) {
	ValaCCodeExpression* _tmp2;
	ValaCCodeExpression* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_condition = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_condition == NULL ? NULL : (self->priv->_condition = (vala_ccode_node_unref (self->priv->_condition), NULL))), _tmp2);
}


ValaCCodeStatement* vala_ccode_for_statement_get_body (ValaCCodeForStatement* self) {
	g_return_val_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self), NULL);
	return self->priv->_body;
}


void vala_ccode_for_statement_set_body (ValaCCodeForStatement* self, ValaCCodeStatement* value) {
	ValaCCodeStatement* _tmp2;
	ValaCCodeStatement* _tmp1;
	g_return_if_fail (VALA_IS_CCODE_FOR_STATEMENT (self));
	_tmp2 = NULL;
	_tmp1 = NULL;
	self->priv->_body = (_tmp2 = (_tmp1 = value, (_tmp1 == NULL ? NULL : vala_ccode_node_ref (_tmp1))), (self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_ccode_node_unref (self->priv->_body), NULL))), _tmp2);
}


static void vala_ccode_for_statement_class_init (ValaCCodeForStatementClass * klass) {
	vala_ccode_for_statement_parent_class = g_type_class_peek_parent (klass);
	VALA_CCODE_NODE_CLASS (klass)->finalize = vala_ccode_for_statement_finalize;
	g_type_class_add_private (klass, sizeof (ValaCCodeForStatementPrivate));
	VALA_CCODE_NODE_CLASS (klass)->write = vala_ccode_for_statement_real_write;
}


static void vala_ccode_for_statement_instance_init (ValaCCodeForStatement * self) {
	self->priv = VALA_CCODE_FOR_STATEMENT_GET_PRIVATE (self);
	self->priv->initializer = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
	self->priv->iterator = GEE_LIST (gee_array_list_new (VALA_TYPE_CCODE_EXPRESSION, ((GBoxedCopyFunc) (vala_ccode_node_ref)), vala_ccode_node_unref, g_direct_equal));
}


static void vala_ccode_for_statement_finalize (ValaCCodeNode* obj) {
	ValaCCodeForStatement * self;
	self = VALA_CCODE_FOR_STATEMENT (obj);
	(self->priv->_condition == NULL ? NULL : (self->priv->_condition = (vala_ccode_node_unref (self->priv->_condition), NULL)));
	(self->priv->_body == NULL ? NULL : (self->priv->_body = (vala_ccode_node_unref (self->priv->_body), NULL)));
	(self->priv->initializer == NULL ? NULL : (self->priv->initializer = (gee_collection_object_unref (self->priv->initializer), NULL)));
	(self->priv->iterator == NULL ? NULL : (self->priv->iterator = (gee_collection_object_unref (self->priv->iterator), NULL)));
	VALA_CCODE_NODE_CLASS (vala_ccode_for_statement_parent_class)->finalize (obj);
}


GType vala_ccode_for_statement_get_type (void) {
	static GType vala_ccode_for_statement_type_id = 0;
	if (vala_ccode_for_statement_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaCCodeForStatementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_ccode_for_statement_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaCCodeForStatement), 0, (GInstanceInitFunc) vala_ccode_for_statement_instance_init, NULL };
		vala_ccode_for_statement_type_id = g_type_register_static (VALA_TYPE_CCODE_STATEMENT, "ValaCCodeForStatement", &g_define_type_info, 0);
	}
	return vala_ccode_for_statement_type_id;
}




