/* valaclass.c generated by valac, the Vala compiler
 * generated from valaclass.vala, do not modify */

/* valaclass.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <valagee.h>
#include <stdlib.h>
#include <string.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))

struct _ValaClassPrivate {
	ValaClass* _base_class;
	gboolean _is_abstract;
	gboolean _has_private_fields;
	gboolean _has_class_private_fields;
	gboolean* _is_compact;
	gboolean* _is_immutable;
	ValaList* base_types;
	ValaCreationMethod* _default_construction_method;
	ValaConstructor* _constructor;
	ValaConstructor* _class_constructor;
	ValaConstructor* _static_constructor;
	ValaDestructor* _static_destructor;
	ValaDestructor* _class_destructor;
	ValaDestructor* _destructor;
};


static gpointer vala_class_parent_class = NULL;

#define VALA_CLASS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_CLASS, ValaClassPrivate))
static void vala_class_real_add_field (ValaSymbol* base,
                                ValaField* f);
static void vala_class_set_has_class_private_fields (ValaClass* self,
                                              gboolean value);
static void vala_class_real_add_method (ValaSymbol* base,
                                 ValaMethod* m);
static void vala_class_real_add_property (ValaSymbol* base,
                                   ValaProperty* prop);
static void vala_class_real_add_constructor (ValaSymbol* base,
                                      ValaConstructor* c);
static void vala_class_real_add_destructor (ValaSymbol* base,
                                     ValaDestructor* d);
static void vala_class_real_accept (ValaCodeNode* base,
                             ValaCodeVisitor* visitor);
static void vala_class_real_accept_children (ValaCodeNode* base,
                                      ValaCodeVisitor* visitor);
static gboolean vala_class_real_is_reference_type (ValaTypeSymbol* base);
static gboolean vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                                        ValaTypeSymbol* t);
static void vala_class_real_replace_type (ValaCodeNode* base,
                                   ValaDataType* old_type,
                                   ValaDataType* new_type);
static void vala_class_get_all_prerequisites (ValaClass* self,
                                       ValaInterface* iface,
                                       ValaList* list);
static gboolean vala_class_class_is_a (ValaClass* self,
                                ValaClass* cl,
                                ValaTypeSymbol* t);
static gboolean vala_class_real_check (ValaCodeNode* base,
                                ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_class_finalize (ValaCodeNode * obj);


/**
 * Creates a new class.
 *
 * @param name             type name
 * @param source_reference reference to source code
 * @param comment          class documentation
 * @return                 newly created class
 */
ValaClass*
vala_class_construct (GType object_type,
                      const gchar* name,
                      ValaSourceReference* source_reference,
                      ValaComment* comment)
{
	ValaClass* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaClass*) vala_object_type_symbol_construct (object_type, name, source_reference, comment);
	return self;
}


ValaClass*
vala_class_new (const gchar* name,
                ValaSourceReference* source_reference,
                ValaComment* comment)
{
	return vala_class_construct (VALA_TYPE_CLASS, name, source_reference, comment);
}


/**
 * Adds the specified class or interface to the list of base types of
 * this class.
 *
 * @param type a class or interface reference
 */
void
vala_class_add_base_type (ValaClass* self,
                          ValaDataType* type)
{
	ValaList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	_tmp0_ = self->priv->base_types;
	vala_collection_add ((ValaCollection*) _tmp0_, type);
	vala_code_node_set_parent_node ((ValaCodeNode*) type, (ValaCodeNode*) self);
}


/**
 * Returns a copy of the base type list.
 *
 * @return list of base types
 */
static gpointer
_vala_iterable_ref0 (gpointer self)
{
	return self ? vala_iterable_ref (self) : NULL;
}


ValaList*
vala_class_get_base_types (ValaClass* self)
{
	ValaList* result = NULL;
	ValaList* _tmp0_;
	ValaList* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->base_types;
	_tmp1_ = _vala_iterable_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}


/**
 * Adds the specified field as a member to this class.
 *
 * @param f a field
 */
static void
vala_class_real_add_field (ValaSymbol* base,
                           ValaField* f)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaSymbolAccessibility _tmp1_;
	ValaSymbolAccessibility _tmp2_;
	self = (ValaClass*) base;
	g_return_if_fail (f != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_field ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), f);
	_tmp1_ = vala_symbol_get_access ((ValaSymbol*) f);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
		ValaMemberBinding _tmp3_;
		ValaMemberBinding _tmp4_;
		_tmp3_ = vala_field_get_binding (f);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_ == VALA_MEMBER_BINDING_INSTANCE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		vala_class_set_has_private_fields (self, TRUE);
	} else {
		gboolean _tmp5_ = FALSE;
		ValaSymbolAccessibility _tmp6_;
		ValaSymbolAccessibility _tmp7_;
		_tmp6_ = vala_symbol_get_access ((ValaSymbol*) f);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_SYMBOL_ACCESSIBILITY_PRIVATE) {
			ValaMemberBinding _tmp8_;
			ValaMemberBinding _tmp9_;
			_tmp8_ = vala_field_get_binding (f);
			_tmp9_ = _tmp8_;
			_tmp5_ = _tmp9_ == VALA_MEMBER_BINDING_CLASS;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			vala_class_set_has_class_private_fields (self, TRUE);
		}
	}
}


/**
 * Adds the specified method as a member to this class.
 *
 * @param m a method
 */
static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_class_real_add_method (ValaSymbol* base,
                            ValaMethod* m)
{
	ValaClass * self;
	gboolean _tmp0_ = FALSE;
	ValaMemberBinding _tmp1_;
	ValaMemberBinding _tmp2_;
	gboolean _tmp23_ = FALSE;
	ValaDataType* _tmp24_;
	ValaDataType* _tmp25_;
	ValaDataType* _tmp69_;
	ValaDataType* _tmp70_;
	self = (ValaClass*) base;
	g_return_if_fail (m != NULL);
	_tmp1_ = vala_method_get_binding (m);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == VALA_MEMBER_BINDING_INSTANCE) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD);
	}
	if (_tmp0_) {
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaObjectType* _tmp11_;
		ValaObjectType* _tmp12_;
		ValaParameter* _tmp13_;
		ValaParameter* _tmp14_;
		ValaScope* _tmp15_;
		ValaScope* _tmp16_;
		ValaParameter* _tmp17_;
		ValaParameter* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		ValaParameter* _tmp21_;
		ValaParameter* _tmp22_;
		_tmp3_ = vala_method_get_this_parameter (m);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaScope* _tmp5_;
			ValaScope* _tmp6_;
			ValaParameter* _tmp7_;
			ValaParameter* _tmp8_;
			const gchar* _tmp9_;
			const gchar* _tmp10_;
			_tmp5_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp6_ = _tmp5_;
			_tmp7_ = vala_method_get_this_parameter (m);
			_tmp8_ = _tmp7_;
			_tmp9_ = vala_symbol_get_name ((ValaSymbol*) _tmp8_);
			_tmp10_ = _tmp9_;
			vala_scope_remove (_tmp6_, _tmp10_);
		}
		_tmp11_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = vala_parameter_new ("this", (ValaDataType*) _tmp12_, NULL);
		_tmp14_ = _tmp13_;
		vala_method_set_this_parameter (m, _tmp14_);
		_vala_code_node_unref0 (_tmp14_);
		_vala_code_node_unref0 (_tmp12_);
		_tmp15_ = vala_symbol_get_scope ((ValaSymbol*) m);
		_tmp16_ = _tmp15_;
		_tmp17_ = vala_method_get_this_parameter (m);
		_tmp18_ = _tmp17_;
		_tmp19_ = vala_symbol_get_name ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = vala_method_get_this_parameter (m);
		_tmp22_ = _tmp21_;
		vala_scope_add (_tmp16_, _tmp20_, (ValaSymbol*) _tmp22_);
	}
	_tmp24_ = vala_callable_get_return_type ((ValaCallable*) m);
	_tmp25_ = _tmp24_;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp25_, VALA_TYPE_VOID_TYPE)) {
		ValaList* _tmp26_;
		ValaList* _tmp27_;
		gint _tmp28_;
		gint _tmp29_;
		_tmp26_ = vala_method_get_postconditions (m);
		_tmp27_ = _tmp26_;
		_tmp28_ = vala_collection_get_size ((ValaCollection*) _tmp27_);
		_tmp29_ = _tmp28_;
		_tmp23_ = _tmp29_ > 0;
		_vala_iterable_unref0 (_tmp27_);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		ValaLocalVariable* _tmp30_;
		ValaLocalVariable* _tmp31_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		ValaDataType* _tmp40_;
		ValaDataType* _tmp41_;
		ValaSourceReference* _tmp42_;
		ValaSourceReference* _tmp43_;
		ValaLocalVariable* _tmp44_;
		ValaLocalVariable* _tmp45_;
		ValaLocalVariable* _tmp46_;
		ValaLocalVariable* _tmp47_;
		_tmp30_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp31_ = _tmp30_;
		if (_tmp31_ != NULL) {
			ValaScope* _tmp32_;
			ValaScope* _tmp33_;
			ValaLocalVariable* _tmp34_;
			ValaLocalVariable* _tmp35_;
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			_tmp32_ = vala_symbol_get_scope ((ValaSymbol*) m);
			_tmp33_ = _tmp32_;
			_tmp34_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
			_tmp35_ = _tmp34_;
			_tmp36_ = vala_symbol_get_name ((ValaSymbol*) _tmp35_);
			_tmp37_ = _tmp36_;
			vala_scope_remove (_tmp33_, _tmp37_);
		}
		_tmp38_ = vala_callable_get_return_type ((ValaCallable*) m);
		_tmp39_ = _tmp38_;
		_tmp40_ = vala_data_type_copy (_tmp39_);
		_tmp41_ = _tmp40_;
		_tmp42_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp43_ = _tmp42_;
		_tmp44_ = vala_local_variable_new (_tmp41_, "result", NULL, _tmp43_);
		_tmp45_ = _tmp44_;
		vala_subroutine_set_result_var ((ValaSubroutine*) m, _tmp45_);
		_vala_code_node_unref0 (_tmp45_);
		_vala_code_node_unref0 (_tmp41_);
		_tmp46_ = vala_subroutine_get_result_var ((ValaSubroutine*) m);
		_tmp47_ = _tmp46_;
		vala_local_variable_set_is_result (_tmp47_, TRUE);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (m, VALA_TYPE_CREATION_METHOD)) {
		const gchar* _tmp48_;
		const gchar* _tmp49_;
		ValaCreationMethod* cm = NULL;
		ValaCreationMethod* _tmp50_;
		gboolean _tmp51_ = FALSE;
		ValaCreationMethod* _tmp52_;
		const gchar* _tmp53_;
		const gchar* _tmp54_;
		_tmp48_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp49_ = _tmp48_;
		if (_tmp49_ == NULL) {
			vala_class_set_default_construction_method (self, G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
			vala_symbol_set_name ((ValaSymbol*) m, ".new");
		}
		_tmp50_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (m, VALA_TYPE_CREATION_METHOD, ValaCreationMethod));
		cm = _tmp50_;
		_tmp52_ = cm;
		_tmp53_ = vala_creation_method_get_class_name (_tmp52_);
		_tmp54_ = _tmp53_;
		if (_tmp54_ != NULL) {
			ValaCreationMethod* _tmp55_;
			const gchar* _tmp56_;
			const gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp55_ = cm;
			_tmp56_ = vala_creation_method_get_class_name (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp58_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp59_ = _tmp58_;
			_tmp51_ = g_strcmp0 (_tmp57_, _tmp59_) != 0;
		} else {
			_tmp51_ = FALSE;
		}
		if (_tmp51_) {
			ValaSourceReference* _tmp60_;
			ValaSourceReference* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			ValaCreationMethod* _tmp64_;
			const gchar* _tmp65_;
			const gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			_tmp60_ = vala_code_node_get_source_reference ((ValaCodeNode*) m);
			_tmp61_ = _tmp60_;
			_tmp62_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp63_ = _tmp62_;
			_tmp64_ = cm;
			_tmp65_ = vala_creation_method_get_class_name (_tmp64_);
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("missing return type in method `%s.%s´", _tmp63_, _tmp66_);
			_tmp68_ = _tmp67_;
			vala_report_error (_tmp61_, _tmp68_);
			_g_free0 (_tmp68_);
			_g_free0 (_tmp63_);
			vala_code_node_set_error ((ValaCodeNode*) m, TRUE);
			_vala_code_node_unref0 (cm);
			return;
		}
		_vala_code_node_unref0 (cm);
	}
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_method ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), m);
	_tmp69_ = vala_method_get_base_interface_type (m);
	_tmp70_ = _tmp69_;
	if (_tmp70_ != NULL) {
		ValaScope* _tmp71_;
		ValaScope* _tmp72_;
		const gchar* _tmp73_;
		const gchar* _tmp74_;
		ValaScope* _tmp75_;
		ValaScope* _tmp76_;
		_tmp71_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp72_ = _tmp71_;
		_tmp73_ = vala_symbol_get_name ((ValaSymbol*) m);
		_tmp74_ = _tmp73_;
		vala_scope_remove (_tmp72_, _tmp74_);
		_tmp75_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp76_ = _tmp75_;
		vala_scope_add (_tmp76_, NULL, (ValaSymbol*) m);
	}
}


/**
 * Adds the specified property as a member to this class.
 *
 * @param prop a property
 */
static void
vala_class_real_add_property (ValaSymbol* base,
                              ValaProperty* prop)
{
	ValaClass * self;
	ValaObjectType* _tmp0_;
	ValaObjectType* _tmp1_;
	ValaParameter* _tmp2_;
	ValaParameter* _tmp3_;
	ValaScope* _tmp4_;
	ValaScope* _tmp5_;
	ValaParameter* _tmp6_;
	ValaParameter* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	ValaParameter* _tmp10_;
	ValaParameter* _tmp11_;
	ValaField* _tmp12_;
	ValaField* _tmp13_;
	self = (ValaClass*) base;
	g_return_if_fail (prop != NULL);
	VALA_SYMBOL_CLASS (vala_class_parent_class)->add_property ((ValaSymbol*) G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol), prop);
	_tmp0_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_parameter_new ("this", (ValaDataType*) _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	vala_property_set_this_parameter (prop, _tmp3_);
	_vala_code_node_unref0 (_tmp3_);
	_vala_code_node_unref0 (_tmp1_);
	_tmp4_ = vala_symbol_get_scope ((ValaSymbol*) prop);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_property_get_this_parameter (prop);
	_tmp7_ = _tmp6_;
	_tmp8_ = vala_symbol_get_name ((ValaSymbol*) _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = vala_property_get_this_parameter (prop);
	_tmp11_ = _tmp10_;
	vala_scope_add (_tmp5_, _tmp9_, (ValaSymbol*) _tmp11_);
	_tmp12_ = vala_property_get_field (prop);
	_tmp13_ = _tmp12_;
	if (_tmp13_ != NULL) {
		ValaField* _tmp14_;
		ValaField* _tmp15_;
		_tmp14_ = vala_property_get_field (prop);
		_tmp15_ = _tmp14_;
		vala_symbol_add_field ((ValaSymbol*) self, _tmp15_);
	}
}


static void
vala_class_real_add_constructor (ValaSymbol* base,
                                 ValaConstructor* c)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (c != NULL);
	_tmp0_ = vala_constructor_get_binding (c);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaConstructor* _tmp2_;
		_tmp2_ = self->priv->_constructor;
		if (_tmp2_ != NULL) {
			ValaSourceReference* _tmp3_;
			ValaSourceReference* _tmp4_;
			_tmp3_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
			_tmp4_ = _tmp3_;
			vala_report_error (_tmp4_, "class already contains a constructor");
		}
		vala_class_set_constructor (self, c);
	} else {
		ValaMemberBinding _tmp5_;
		ValaMemberBinding _tmp6_;
		_tmp5_ = vala_constructor_get_binding (c);
		_tmp6_ = _tmp5_;
		if (_tmp6_ == VALA_MEMBER_BINDING_CLASS) {
			ValaConstructor* _tmp7_;
			_tmp7_ = self->priv->_class_constructor;
			if (_tmp7_ != NULL) {
				ValaSourceReference* _tmp8_;
				ValaSourceReference* _tmp9_;
				_tmp8_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp9_ = _tmp8_;
				vala_report_error (_tmp9_, "class already contains a class constructor");
			}
			vala_class_set_class_constructor (self, c);
		} else {
			ValaConstructor* _tmp10_;
			_tmp10_ = self->priv->_static_constructor;
			if (_tmp10_ != NULL) {
				ValaSourceReference* _tmp11_;
				ValaSourceReference* _tmp12_;
				_tmp11_ = vala_code_node_get_source_reference ((ValaCodeNode*) c);
				_tmp12_ = _tmp11_;
				vala_report_error (_tmp12_, "class already contains a static constructor");
			}
			vala_class_set_static_constructor (self, c);
		}
	}
}


static void
vala_class_real_add_destructor (ValaSymbol* base,
                                ValaDestructor* d)
{
	ValaClass * self;
	ValaMemberBinding _tmp0_;
	ValaMemberBinding _tmp1_;
	self = (ValaClass*) base;
	g_return_if_fail (d != NULL);
	_tmp0_ = vala_destructor_get_binding (d);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == VALA_MEMBER_BINDING_INSTANCE) {
		ValaDestructor* _tmp2_;
		ValaDestructor* _tmp3_;
		_tmp2_ = vala_class_get_destructor (self);
		_tmp3_ = _tmp2_;
		if (_tmp3_ != NULL) {
			ValaSourceReference* _tmp4_;
			ValaSourceReference* _tmp5_;
			_tmp4_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
			_tmp5_ = _tmp4_;
			vala_report_error (_tmp5_, "class already contains a destructor");
		}
		vala_class_set_destructor (self, d);
	} else {
		ValaMemberBinding _tmp6_;
		ValaMemberBinding _tmp7_;
		_tmp6_ = vala_destructor_get_binding (d);
		_tmp7_ = _tmp6_;
		if (_tmp7_ == VALA_MEMBER_BINDING_CLASS) {
			ValaDestructor* _tmp8_;
			_tmp8_ = self->priv->_class_destructor;
			if (_tmp8_ != NULL) {
				ValaSourceReference* _tmp9_;
				ValaSourceReference* _tmp10_;
				_tmp9_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp10_ = _tmp9_;
				vala_report_error (_tmp10_, "class already contains a class destructor");
			}
			vala_class_set_class_destructor (self, d);
		} else {
			ValaDestructor* _tmp11_;
			_tmp11_ = self->priv->_static_destructor;
			if (_tmp11_ != NULL) {
				ValaSourceReference* _tmp12_;
				ValaSourceReference* _tmp13_;
				_tmp12_ = vala_code_node_get_source_reference ((ValaCodeNode*) d);
				_tmp13_ = _tmp12_;
				vala_report_error (_tmp13_, "class already contains a static destructor");
			}
			vala_class_set_static_destructor (self, d);
		}
	}
}


static void
vala_class_real_accept (ValaCodeNode* base,
                        ValaCodeVisitor* visitor)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_class (visitor, self);
}


static void
vala_class_real_accept_children (ValaCodeNode* base,
                                 ValaCodeVisitor* visitor)
{
	ValaClass * self;
	ValaConstructor* _tmp89_;
	ValaConstructor* _tmp91_;
	ValaConstructor* _tmp93_;
	ValaDestructor* _tmp95_;
	ValaDestructor* _tmp96_;
	ValaDestructor* _tmp99_;
	ValaDestructor* _tmp101_;
	self = (ValaClass*) base;
	g_return_if_fail (visitor != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_type_list = _tmp1_;
		_tmp2_ = _type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_type_size = _tmp4_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			ValaDataType* _tmp11_;
			_tmp5_ = _type_index;
			_type_index = _tmp5_ + 1;
			_tmp6_ = _type_index;
			_tmp7_ = _type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _type_list;
			_tmp9_ = _type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			type = (ValaDataType*) _tmp10_;
			_tmp11_ = type;
			vala_code_node_accept ((ValaCodeNode*) _tmp11_, visitor);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp12_;
		gint _p_size = 0;
		ValaList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _p_index = 0;
		_tmp12_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp12_;
		_tmp13_ = _p_list;
		_tmp14_ = vala_collection_get_size ((ValaCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_p_size = _tmp15_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			gint _tmp18_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp19_;
			gint _tmp20_;
			gpointer _tmp21_;
			ValaTypeParameter* _tmp22_;
			_tmp16_ = _p_index;
			_p_index = _tmp16_ + 1;
			_tmp17_ = _p_index;
			_tmp18_ = _p_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _p_list;
			_tmp20_ = _p_index;
			_tmp21_ = vala_list_get (_tmp19_, _tmp20_);
			p = (ValaTypeParameter*) _tmp21_;
			_tmp22_ = p;
			vala_code_node_accept ((ValaCodeNode*) _tmp22_, visitor);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp23_;
		gint _en_size = 0;
		ValaList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _en_index = 0;
		_tmp23_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp23_;
		_tmp24_ = _en_list;
		_tmp25_ = vala_collection_get_size ((ValaCollection*) _tmp24_);
		_tmp26_ = _tmp25_;
		_en_size = _tmp26_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp27_;
			gint _tmp28_;
			gint _tmp29_;
			ValaEnum* en = NULL;
			ValaList* _tmp30_;
			gint _tmp31_;
			gpointer _tmp32_;
			ValaEnum* _tmp33_;
			_tmp27_ = _en_index;
			_en_index = _tmp27_ + 1;
			_tmp28_ = _en_index;
			_tmp29_ = _en_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _en_list;
			_tmp31_ = _en_index;
			_tmp32_ = vala_list_get (_tmp30_, _tmp31_);
			en = (ValaEnum*) _tmp32_;
			_tmp33_ = en;
			vala_code_node_accept ((ValaCodeNode*) _tmp33_, visitor);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp34_;
		gint _f_size = 0;
		ValaList* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gint _f_index = 0;
		_tmp34_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp34_;
		_tmp35_ = _f_list;
		_tmp36_ = vala_collection_get_size ((ValaCollection*) _tmp35_);
		_tmp37_ = _tmp36_;
		_f_size = _tmp37_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp38_;
			gint _tmp39_;
			gint _tmp40_;
			ValaField* f = NULL;
			ValaList* _tmp41_;
			gint _tmp42_;
			gpointer _tmp43_;
			ValaField* _tmp44_;
			_tmp38_ = _f_index;
			_f_index = _tmp38_ + 1;
			_tmp39_ = _f_index;
			_tmp40_ = _f_size;
			if (!(_tmp39_ < _tmp40_)) {
				break;
			}
			_tmp41_ = _f_list;
			_tmp42_ = _f_index;
			_tmp43_ = vala_list_get (_tmp41_, _tmp42_);
			f = (ValaField*) _tmp43_;
			_tmp44_ = f;
			vala_code_node_accept ((ValaCodeNode*) _tmp44_, visitor);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp45_;
		gint _c_size = 0;
		ValaList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		gint _c_index = 0;
		_tmp45_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp45_;
		_tmp46_ = _c_list;
		_tmp47_ = vala_collection_get_size ((ValaCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		_c_size = _tmp48_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			ValaConstant* c = NULL;
			ValaList* _tmp52_;
			gint _tmp53_;
			gpointer _tmp54_;
			ValaConstant* _tmp55_;
			_tmp49_ = _c_index;
			_c_index = _tmp49_ + 1;
			_tmp50_ = _c_index;
			_tmp51_ = _c_size;
			if (!(_tmp50_ < _tmp51_)) {
				break;
			}
			_tmp52_ = _c_list;
			_tmp53_ = _c_index;
			_tmp54_ = vala_list_get (_tmp52_, _tmp53_);
			c = (ValaConstant*) _tmp54_;
			_tmp55_ = c;
			vala_code_node_accept ((ValaCodeNode*) _tmp55_, visitor);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp56_;
		gint _m_size = 0;
		ValaList* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gint _m_index = 0;
		_tmp56_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp56_;
		_tmp57_ = _m_list;
		_tmp58_ = vala_collection_get_size ((ValaCollection*) _tmp57_);
		_tmp59_ = _tmp58_;
		_m_size = _tmp59_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			ValaMethod* m = NULL;
			ValaList* _tmp63_;
			gint _tmp64_;
			gpointer _tmp65_;
			ValaMethod* _tmp66_;
			_tmp60_ = _m_index;
			_m_index = _tmp60_ + 1;
			_tmp61_ = _m_index;
			_tmp62_ = _m_size;
			if (!(_tmp61_ < _tmp62_)) {
				break;
			}
			_tmp63_ = _m_list;
			_tmp64_ = _m_index;
			_tmp65_ = vala_list_get (_tmp63_, _tmp64_);
			m = (ValaMethod*) _tmp65_;
			_tmp66_ = m;
			vala_code_node_accept ((ValaCodeNode*) _tmp66_, visitor);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp67_;
		gint _prop_size = 0;
		ValaList* _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _prop_index = 0;
		_tmp67_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp67_;
		_tmp68_ = _prop_list;
		_tmp69_ = vala_collection_get_size ((ValaCollection*) _tmp68_);
		_tmp70_ = _tmp69_;
		_prop_size = _tmp70_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp71_;
			gint _tmp72_;
			gint _tmp73_;
			ValaProperty* prop = NULL;
			ValaList* _tmp74_;
			gint _tmp75_;
			gpointer _tmp76_;
			ValaProperty* _tmp77_;
			_tmp71_ = _prop_index;
			_prop_index = _tmp71_ + 1;
			_tmp72_ = _prop_index;
			_tmp73_ = _prop_size;
			if (!(_tmp72_ < _tmp73_)) {
				break;
			}
			_tmp74_ = _prop_list;
			_tmp75_ = _prop_index;
			_tmp76_ = vala_list_get (_tmp74_, _tmp75_);
			prop = (ValaProperty*) _tmp76_;
			_tmp77_ = prop;
			vala_code_node_accept ((ValaCodeNode*) _tmp77_, visitor);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp78_;
		gint _sig_size = 0;
		ValaList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _sig_index = 0;
		_tmp78_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp78_;
		_tmp79_ = _sig_list;
		_tmp80_ = vala_collection_get_size ((ValaCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_sig_size = _tmp81_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			ValaSignal* sig = NULL;
			ValaList* _tmp85_;
			gint _tmp86_;
			gpointer _tmp87_;
			ValaSignal* _tmp88_;
			_tmp82_ = _sig_index;
			_sig_index = _tmp82_ + 1;
			_tmp83_ = _sig_index;
			_tmp84_ = _sig_size;
			if (!(_tmp83_ < _tmp84_)) {
				break;
			}
			_tmp85_ = _sig_list;
			_tmp86_ = _sig_index;
			_tmp87_ = vala_list_get (_tmp85_, _tmp86_);
			sig = (ValaSignal*) _tmp87_;
			_tmp88_ = sig;
			vala_code_node_accept ((ValaCodeNode*) _tmp88_, visitor);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp89_ = self->priv->_constructor;
	if (_tmp89_ != NULL) {
		ValaConstructor* _tmp90_;
		_tmp90_ = self->priv->_constructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp90_, visitor);
	}
	_tmp91_ = self->priv->_class_constructor;
	if (_tmp91_ != NULL) {
		ValaConstructor* _tmp92_;
		_tmp92_ = self->priv->_class_constructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp92_, visitor);
	}
	_tmp93_ = self->priv->_static_constructor;
	if (_tmp93_ != NULL) {
		ValaConstructor* _tmp94_;
		_tmp94_ = self->priv->_static_constructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp94_, visitor);
	}
	_tmp95_ = vala_class_get_destructor (self);
	_tmp96_ = _tmp95_;
	if (_tmp96_ != NULL) {
		ValaDestructor* _tmp97_;
		ValaDestructor* _tmp98_;
		_tmp97_ = vala_class_get_destructor (self);
		_tmp98_ = _tmp97_;
		vala_code_node_accept ((ValaCodeNode*) _tmp98_, visitor);
	}
	_tmp99_ = self->priv->_static_destructor;
	if (_tmp99_ != NULL) {
		ValaDestructor* _tmp100_;
		_tmp100_ = self->priv->_static_destructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp100_, visitor);
	}
	_tmp101_ = self->priv->_class_destructor;
	if (_tmp101_ != NULL) {
		ValaDestructor* _tmp102_;
		_tmp102_ = self->priv->_class_destructor;
		vala_code_node_accept ((ValaCodeNode*) _tmp102_, visitor);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp103_;
		gint _cl_size = 0;
		ValaList* _tmp104_;
		gint _tmp105_;
		gint _tmp106_;
		gint _cl_index = 0;
		_tmp103_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp103_;
		_tmp104_ = _cl_list;
		_tmp105_ = vala_collection_get_size ((ValaCollection*) _tmp104_);
		_tmp106_ = _tmp105_;
		_cl_size = _tmp106_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp107_;
			gint _tmp108_;
			gint _tmp109_;
			ValaClass* cl = NULL;
			ValaList* _tmp110_;
			gint _tmp111_;
			gpointer _tmp112_;
			ValaClass* _tmp113_;
			_tmp107_ = _cl_index;
			_cl_index = _tmp107_ + 1;
			_tmp108_ = _cl_index;
			_tmp109_ = _cl_size;
			if (!(_tmp108_ < _tmp109_)) {
				break;
			}
			_tmp110_ = _cl_list;
			_tmp111_ = _cl_index;
			_tmp112_ = vala_list_get (_tmp110_, _tmp111_);
			cl = (ValaClass*) _tmp112_;
			_tmp113_ = cl;
			vala_code_node_accept ((ValaCodeNode*) _tmp113_, visitor);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp114_;
		gint _st_size = 0;
		ValaList* _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		gint _st_index = 0;
		_tmp114_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp114_;
		_tmp115_ = _st_list;
		_tmp116_ = vala_collection_get_size ((ValaCollection*) _tmp115_);
		_tmp117_ = _tmp116_;
		_st_size = _tmp117_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp118_;
			gint _tmp119_;
			gint _tmp120_;
			ValaStruct* st = NULL;
			ValaList* _tmp121_;
			gint _tmp122_;
			gpointer _tmp123_;
			ValaStruct* _tmp124_;
			_tmp118_ = _st_index;
			_st_index = _tmp118_ + 1;
			_tmp119_ = _st_index;
			_tmp120_ = _st_size;
			if (!(_tmp119_ < _tmp120_)) {
				break;
			}
			_tmp121_ = _st_list;
			_tmp122_ = _st_index;
			_tmp123_ = vala_list_get (_tmp121_, _tmp122_);
			st = (ValaStruct*) _tmp123_;
			_tmp124_ = st;
			vala_code_node_accept ((ValaCodeNode*) _tmp124_, visitor);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp125_;
		gint _d_size = 0;
		ValaList* _tmp126_;
		gint _tmp127_;
		gint _tmp128_;
		gint _d_index = 0;
		_tmp125_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp125_;
		_tmp126_ = _d_list;
		_tmp127_ = vala_collection_get_size ((ValaCollection*) _tmp126_);
		_tmp128_ = _tmp127_;
		_d_size = _tmp128_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp129_;
			gint _tmp130_;
			gint _tmp131_;
			ValaDelegate* d = NULL;
			ValaList* _tmp132_;
			gint _tmp133_;
			gpointer _tmp134_;
			ValaDelegate* _tmp135_;
			_tmp129_ = _d_index;
			_d_index = _tmp129_ + 1;
			_tmp130_ = _d_index;
			_tmp131_ = _d_size;
			if (!(_tmp130_ < _tmp131_)) {
				break;
			}
			_tmp132_ = _d_list;
			_tmp133_ = _d_index;
			_tmp134_ = vala_list_get (_tmp132_, _tmp133_);
			d = (ValaDelegate*) _tmp134_;
			_tmp135_ = d;
			vala_code_node_accept ((ValaCodeNode*) _tmp135_, visitor);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
}


static gboolean
vala_class_real_is_reference_type (ValaTypeSymbol* base)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	result = TRUE;
	return result;
}


gboolean
vala_class_is_fundamental (ValaClass* self)
{
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = vala_class_get_is_compact (self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		ValaClass* _tmp3_;
		_tmp3_ = self->priv->_base_class;
		_tmp0_ = _tmp3_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean
vala_class_real_is_subtype_of (ValaTypeSymbol* base,
                               ValaTypeSymbol* t)
{
	ValaClass * self;
	gboolean result = FALSE;
	self = (ValaClass*) base;
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (self, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		ValaList* _tmp1_;
		gint _base_type_size = 0;
		ValaList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _base_type_index = 0;
		_tmp0_ = self->priv->base_types;
		_tmp1_ = _vala_iterable_ref0 (_tmp0_);
		_base_type_list = _tmp1_;
		_tmp2_ = _base_type_list;
		_tmp3_ = vala_collection_get_size ((ValaCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_base_type_size = _tmp4_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp8_;
			gint _tmp9_;
			gpointer _tmp10_;
			gboolean _tmp11_ = FALSE;
			ValaDataType* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			_tmp5_ = _base_type_index;
			_base_type_index = _tmp5_ + 1;
			_tmp6_ = _base_type_index;
			_tmp7_ = _base_type_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _base_type_list;
			_tmp9_ = _base_type_index;
			_tmp10_ = vala_list_get (_tmp8_, _tmp9_);
			base_type = (ValaDataType*) _tmp10_;
			_tmp12_ = base_type;
			_tmp13_ = vala_data_type_get_data_type (_tmp12_);
			_tmp14_ = _tmp13_;
			if (_tmp14_ != NULL) {
				ValaDataType* _tmp15_;
				ValaTypeSymbol* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				_tmp15_ = base_type;
				_tmp16_ = vala_data_type_get_data_type (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp11_ = vala_typesymbol_is_subtype_of (_tmp17_, t);
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				result = TRUE;
				_vala_code_node_unref0 (base_type);
				_vala_iterable_unref0 (_base_type_list);
				return result;
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static void
vala_class_real_replace_type (ValaCodeNode* base,
                              ValaDataType* old_type,
                              ValaDataType* new_type)
{
	ValaClass * self;
	self = (ValaClass*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_;
				ValaList* _tmp3_;
				gint _tmp4_;
				gint _tmp5_;
				ValaList* _tmp6_;
				gint _tmp7_;
				gpointer _tmp8_;
				ValaDataType* _tmp9_;
				gboolean _tmp10_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				_tmp3_ = self->priv->base_types;
				_tmp4_ = vala_collection_get_size ((ValaCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				if (!(_tmp2_ < _tmp5_)) {
					break;
				}
				_tmp6_ = self->priv->base_types;
				_tmp7_ = i;
				_tmp8_ = vala_list_get (_tmp6_, _tmp7_);
				_tmp9_ = (ValaDataType*) _tmp8_;
				_tmp10_ = _tmp9_ == old_type;
				_vala_code_node_unref0 (_tmp9_);
				if (_tmp10_) {
					ValaList* _tmp11_;
					gint _tmp12_;
					_tmp11_ = self->priv->base_types;
					_tmp12_ = i;
					vala_list_set (_tmp11_, _tmp12_, new_type);
					vala_code_node_set_parent_node ((ValaCodeNode*) new_type, (ValaCodeNode*) self);
					return;
				}
			}
		}
	}
}


static void
vala_class_get_all_prerequisites (ValaClass* self,
                                  ValaInterface* iface,
                                  ValaList* list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (iface != NULL);
	g_return_if_fail (list != NULL);
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp0_;
		gint _prereq_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _prereq_index = 0;
		_tmp0_ = vala_interface_get_prerequisites (iface);
		_prereq_list = _tmp0_;
		_tmp1_ = _prereq_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_prereq_size = _tmp3_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* prereq = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaTypeSymbol* type = NULL;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			ValaTypeSymbol* _tmp13_;
			ValaTypeSymbol* _tmp14_;
			ValaTypeSymbol* _tmp15_;
			ValaTypeSymbol* _tmp16_;
			_tmp4_ = _prereq_index;
			_prereq_index = _tmp4_ + 1;
			_tmp5_ = _prereq_index;
			_tmp6_ = _prereq_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _prereq_list;
			_tmp8_ = _prereq_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			prereq = (ValaDataType*) _tmp9_;
			_tmp10_ = prereq;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = _vala_code_node_ref0 (_tmp12_);
			type = _tmp13_;
			_tmp14_ = type;
			if (_tmp14_ == NULL) {
				_vala_code_node_unref0 (type);
				_vala_code_node_unref0 (prereq);
				continue;
			}
			_tmp15_ = type;
			vala_collection_add ((ValaCollection*) list, _tmp15_);
			_tmp16_ = type;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE)) {
				ValaTypeSymbol* _tmp17_;
				_tmp17_ = type;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, VALA_TYPE_INTERFACE, ValaInterface), list);
			}
			_vala_code_node_unref0 (type);
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
}


static gboolean
vala_class_class_is_a (ValaClass* self,
                       ValaClass* cl,
                       ValaTypeSymbol* t)
{
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (cl != NULL, FALSE);
	g_return_val_if_fail (t != NULL, FALSE);
	if (G_TYPE_CHECK_INSTANCE_CAST (cl, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol) == t) {
		result = TRUE;
		return result;
	}
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp0_;
		gint _base_type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _base_type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_base_type_list = _tmp0_;
		_tmp1_ = _base_type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_base_type_size = _tmp3_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _base_type_index;
			_base_type_index = _tmp4_ + 1;
			_tmp5_ = _base_type_index;
			_tmp6_ = _base_type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _base_type_list;
			_tmp8_ = _base_type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			base_type = (ValaDataType*) _tmp9_;
			_tmp10_ = base_type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_CLASS)) {
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				_tmp13_ = base_type;
				_tmp14_ = vala_data_type_get_data_type (_tmp13_);
				_tmp15_ = _tmp14_;
				if (vala_class_class_is_a (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, VALA_TYPE_CLASS, ValaClass), t)) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			} else {
				ValaDataType* _tmp16_;
				ValaTypeSymbol* _tmp17_;
				ValaTypeSymbol* _tmp18_;
				_tmp16_ = base_type;
				_tmp17_ = vala_data_type_get_data_type (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ == t) {
					result = TRUE;
					_vala_code_node_unref0 (base_type);
					_vala_iterable_unref0 (_base_type_list);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	result = FALSE;
	return result;
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_class_real_check (ValaCodeNode* base,
                       ValaCodeContext* context)
{
	ValaClass * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp4_;
	ValaSemanticAnalyzer* _tmp5_;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceFile* _tmp8_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp9_;
	ValaSemanticAnalyzer* _tmp10_;
	ValaSymbol* _tmp11_;
	ValaSymbol* _tmp12_;
	ValaSymbol* _tmp13_;
	ValaSourceReference* _tmp14_;
	ValaSourceReference* _tmp15_;
	ValaSemanticAnalyzer* _tmp22_;
	ValaSemanticAnalyzer* _tmp23_;
	ValaConstructor* _tmp181_;
	ValaConstructor* _tmp183_;
	ValaConstructor* _tmp185_;
	ValaDestructor* _tmp187_;
	ValaDestructor* _tmp188_;
	ValaDestructor* _tmp191_;
	ValaDestructor* _tmp193_;
	gboolean _tmp228_;
	gboolean _tmp229_;
	ValaList* prerequisites = NULL;
	GEqualFunc _tmp276_;
	ValaArrayList* _tmp277_;
	ValaList* missing_prereqs = NULL;
	GEqualFunc _tmp295_;
	ValaArrayList* _tmp296_;
	ValaList* _tmp313_;
	gint _tmp314_;
	gint _tmp315_;
	ValaSourceFileType _tmp343_;
	ValaSourceFileType _tmp344_;
	ValaSemanticAnalyzer* _tmp570_;
	ValaSemanticAnalyzer* _tmp571_;
	ValaSourceFile* _tmp572_;
	ValaSemanticAnalyzer* _tmp573_;
	ValaSemanticAnalyzer* _tmp574_;
	ValaSymbol* _tmp575_;
	gboolean _tmp576_;
	gboolean _tmp577_;
	self = (ValaClass*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = vala_code_context_get_analyzer (context);
	_tmp5_ = _tmp4_;
	_tmp6_ = vala_semantic_analyzer_get_current_source_file (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _vala_source_file_ref0 (_tmp7_);
	old_source_file = _tmp8_;
	_tmp9_ = vala_code_context_get_analyzer (context);
	_tmp10_ = _tmp9_;
	_tmp11_ = vala_semantic_analyzer_get_current_symbol (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = _vala_code_node_ref0 (_tmp12_);
	old_symbol = _tmp13_;
	_tmp14_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		ValaSemanticAnalyzer* _tmp16_;
		ValaSemanticAnalyzer* _tmp17_;
		ValaSourceReference* _tmp18_;
		ValaSourceReference* _tmp19_;
		ValaSourceFile* _tmp20_;
		ValaSourceFile* _tmp21_;
		_tmp16_ = vala_code_context_get_analyzer (context);
		_tmp17_ = _tmp16_;
		_tmp18_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp19_ = _tmp18_;
		_tmp20_ = vala_source_reference_get_file (_tmp19_);
		_tmp21_ = _tmp20_;
		vala_semantic_analyzer_set_current_source_file (_tmp17_, _tmp21_);
	}
	_tmp22_ = vala_code_context_get_analyzer (context);
	_tmp23_ = _tmp22_;
	vala_semantic_analyzer_set_current_symbol (_tmp23_, (ValaSymbol*) self);
	{
		ValaList* _base_type_reference_list = NULL;
		ValaList* _tmp24_;
		gint _base_type_reference_size = 0;
		ValaList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _base_type_reference_index = 0;
		_tmp24_ = vala_class_get_base_types (self);
		_base_type_reference_list = _tmp24_;
		_tmp25_ = _base_type_reference_list;
		_tmp26_ = vala_collection_get_size ((ValaCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_base_type_reference_size = _tmp27_;
		_base_type_reference_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			gint _tmp30_;
			ValaDataType* base_type_reference = NULL;
			ValaList* _tmp31_;
			gint _tmp32_;
			gpointer _tmp33_;
			ValaDataType* _tmp34_;
			ValaDataType* _tmp35_;
			ValaSemanticAnalyzer* _tmp45_;
			ValaSemanticAnalyzer* _tmp46_;
			ValaDataType* _tmp47_;
			gint n_type_args = 0;
			ValaDataType* _tmp57_;
			ValaList* _tmp58_;
			ValaList* _tmp59_;
			gint _tmp60_;
			gint _tmp61_;
			gint _tmp62_;
			gint n_type_params = 0;
			ValaDataType* _tmp63_;
			ValaTypeSymbol* _tmp64_;
			ValaTypeSymbol* _tmp65_;
			ValaList* _tmp66_;
			ValaList* _tmp67_;
			gint _tmp68_;
			gint _tmp69_;
			gint _tmp70_;
			gint _tmp71_;
			gint _tmp72_;
			_tmp28_ = _base_type_reference_index;
			_base_type_reference_index = _tmp28_ + 1;
			_tmp29_ = _base_type_reference_index;
			_tmp30_ = _base_type_reference_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _base_type_reference_list;
			_tmp32_ = _base_type_reference_index;
			_tmp33_ = vala_list_get (_tmp31_, _tmp32_);
			base_type_reference = (ValaDataType*) _tmp33_;
			_tmp34_ = base_type_reference;
			if (!vala_code_node_check ((ValaCodeNode*) _tmp34_, context)) {
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp35_ = base_type_reference;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp35_, VALA_TYPE_OBJECT_TYPE)) {
				ValaSourceReference* _tmp36_;
				ValaSourceReference* _tmp37_;
				ValaDataType* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gchar* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp36_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp37_ = _tmp36_;
				_tmp38_ = base_type_reference;
				_tmp39_ = vala_code_node_to_string ((ValaCodeNode*) _tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp42_ = _tmp41_;
				_tmp43_ = g_strdup_printf ("base type `%s` of class `%s` is not an object type", _tmp40_, _tmp42_);
				_tmp44_ = _tmp43_;
				vala_report_error (_tmp37_, _tmp44_);
				_g_free0 (_tmp44_);
				_g_free0 (_tmp42_);
				_g_free0 (_tmp40_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp45_ = vala_code_context_get_analyzer (context);
			_tmp46_ = _tmp45_;
			_tmp47_ = base_type_reference;
			if (!vala_semantic_analyzer_is_type_accessible (_tmp46_, (ValaSymbol*) self, _tmp47_)) {
				ValaSourceReference* _tmp48_;
				ValaSourceReference* _tmp49_;
				ValaDataType* _tmp50_;
				gchar* _tmp51_;
				gchar* _tmp52_;
				gchar* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp48_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp49_ = _tmp48_;
				_tmp50_ = base_type_reference;
				_tmp51_ = vala_code_node_to_string ((ValaCodeNode*) _tmp50_);
				_tmp52_ = _tmp51_;
				_tmp53_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp54_ = _tmp53_;
				_tmp55_ = g_strdup_printf ("base type `%s` is less accessible than class `%s`", _tmp52_, _tmp54_);
				_tmp56_ = _tmp55_;
				vala_report_error (_tmp49_, _tmp56_);
				_g_free0 (_tmp56_);
				_g_free0 (_tmp54_);
				_g_free0 (_tmp52_);
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp57_ = base_type_reference;
			_tmp58_ = vala_data_type_get_type_arguments (_tmp57_);
			_tmp59_ = _tmp58_;
			_tmp60_ = vala_collection_get_size ((ValaCollection*) _tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = _tmp61_;
			_vala_iterable_unref0 (_tmp59_);
			n_type_args = _tmp62_;
			_tmp63_ = base_type_reference;
			_tmp64_ = vala_data_type_get_data_type (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = vala_object_type_symbol_get_type_parameters (G_TYPE_CHECK_INSTANCE_CAST (_tmp65_, VALA_TYPE_OBJECT_TYPE_SYMBOL, ValaObjectTypeSymbol));
			_tmp67_ = _tmp66_;
			_tmp68_ = vala_collection_get_size ((ValaCollection*) _tmp67_);
			_tmp69_ = _tmp68_;
			_tmp70_ = _tmp69_;
			_vala_iterable_unref0 (_tmp67_);
			n_type_params = _tmp70_;
			_tmp71_ = n_type_args;
			_tmp72_ = n_type_params;
			if (_tmp71_ < _tmp72_) {
				ValaDataType* _tmp73_;
				ValaSourceReference* _tmp74_;
				ValaSourceReference* _tmp75_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp73_ = base_type_reference;
				_tmp74_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp73_);
				_tmp75_ = _tmp74_;
				vala_report_error (_tmp75_, "too few type arguments");
				result = FALSE;
				_vala_code_node_unref0 (base_type_reference);
				_vala_iterable_unref0 (_base_type_reference_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			} else {
				gint _tmp76_;
				gint _tmp77_;
				_tmp76_ = n_type_args;
				_tmp77_ = n_type_params;
				if (_tmp76_ > _tmp77_) {
					ValaDataType* _tmp78_;
					ValaSourceReference* _tmp79_;
					ValaSourceReference* _tmp80_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp78_ = base_type_reference;
					_tmp79_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp78_);
					_tmp80_ = _tmp79_;
					vala_report_error (_tmp80_, "too many type arguments");
					result = FALSE;
					_vala_code_node_unref0 (base_type_reference);
					_vala_iterable_unref0 (_base_type_reference_list);
					_vala_code_node_unref0 (old_symbol);
					_vala_source_file_unref0 (old_source_file);
					return result;
				}
			}
			_vala_code_node_unref0 (base_type_reference);
		}
		_vala_iterable_unref0 (_base_type_reference_list);
	}
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp81_;
		ValaList* _tmp82_;
		gint _type_size = 0;
		ValaList* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
		gint _type_index = 0;
		_tmp81_ = self->priv->base_types;
		_tmp82_ = _vala_iterable_ref0 (_tmp81_);
		_type_list = _tmp82_;
		_tmp83_ = _type_list;
		_tmp84_ = vala_collection_get_size ((ValaCollection*) _tmp83_);
		_tmp85_ = _tmp84_;
		_type_size = _tmp85_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			ValaDataType* type = NULL;
			ValaList* _tmp89_;
			gint _tmp90_;
			gpointer _tmp91_;
			ValaDataType* _tmp92_;
			_tmp86_ = _type_index;
			_type_index = _tmp86_ + 1;
			_tmp87_ = _type_index;
			_tmp88_ = _type_size;
			if (!(_tmp87_ < _tmp88_)) {
				break;
			}
			_tmp89_ = _type_list;
			_tmp90_ = _type_index;
			_tmp91_ = vala_list_get (_tmp89_, _tmp90_);
			type = (ValaDataType*) _tmp91_;
			_tmp92_ = type;
			vala_code_node_check ((ValaCodeNode*) _tmp92_, context);
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
	{
		ValaList* _p_list = NULL;
		ValaList* _tmp93_;
		gint _p_size = 0;
		ValaList* _tmp94_;
		gint _tmp95_;
		gint _tmp96_;
		gint _p_index = 0;
		_tmp93_ = vala_object_type_symbol_get_type_parameters ((ValaObjectTypeSymbol*) self);
		_p_list = _tmp93_;
		_tmp94_ = _p_list;
		_tmp95_ = vala_collection_get_size ((ValaCollection*) _tmp94_);
		_tmp96_ = _tmp95_;
		_p_size = _tmp96_;
		_p_index = -1;
		while (TRUE) {
			gint _tmp97_;
			gint _tmp98_;
			gint _tmp99_;
			ValaTypeParameter* p = NULL;
			ValaList* _tmp100_;
			gint _tmp101_;
			gpointer _tmp102_;
			ValaTypeParameter* _tmp103_;
			_tmp97_ = _p_index;
			_p_index = _tmp97_ + 1;
			_tmp98_ = _p_index;
			_tmp99_ = _p_size;
			if (!(_tmp98_ < _tmp99_)) {
				break;
			}
			_tmp100_ = _p_list;
			_tmp101_ = _p_index;
			_tmp102_ = vala_list_get (_tmp100_, _tmp101_);
			p = (ValaTypeParameter*) _tmp102_;
			_tmp103_ = p;
			vala_code_node_check ((ValaCodeNode*) _tmp103_, context);
			_vala_code_node_unref0 (p);
		}
		_vala_iterable_unref0 (_p_list);
	}
	{
		ValaList* _en_list = NULL;
		ValaList* _tmp104_;
		gint _en_size = 0;
		ValaList* _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _en_index = 0;
		_tmp104_ = vala_object_type_symbol_get_enums ((ValaObjectTypeSymbol*) self);
		_en_list = _tmp104_;
		_tmp105_ = _en_list;
		_tmp106_ = vala_collection_get_size ((ValaCollection*) _tmp105_);
		_tmp107_ = _tmp106_;
		_en_size = _tmp107_;
		_en_index = -1;
		while (TRUE) {
			gint _tmp108_;
			gint _tmp109_;
			gint _tmp110_;
			ValaEnum* en = NULL;
			ValaList* _tmp111_;
			gint _tmp112_;
			gpointer _tmp113_;
			ValaEnum* _tmp114_;
			_tmp108_ = _en_index;
			_en_index = _tmp108_ + 1;
			_tmp109_ = _en_index;
			_tmp110_ = _en_size;
			if (!(_tmp109_ < _tmp110_)) {
				break;
			}
			_tmp111_ = _en_list;
			_tmp112_ = _en_index;
			_tmp113_ = vala_list_get (_tmp111_, _tmp112_);
			en = (ValaEnum*) _tmp113_;
			_tmp114_ = en;
			vala_code_node_check ((ValaCodeNode*) _tmp114_, context);
			_vala_code_node_unref0 (en);
		}
		_vala_iterable_unref0 (_en_list);
	}
	{
		ValaList* _f_list = NULL;
		ValaList* _tmp115_;
		gint _f_size = 0;
		ValaList* _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _f_index = 0;
		_tmp115_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
		_f_list = _tmp115_;
		_tmp116_ = _f_list;
		_tmp117_ = vala_collection_get_size ((ValaCollection*) _tmp116_);
		_tmp118_ = _tmp117_;
		_f_size = _tmp118_;
		_f_index = -1;
		while (TRUE) {
			gint _tmp119_;
			gint _tmp120_;
			gint _tmp121_;
			ValaField* f = NULL;
			ValaList* _tmp122_;
			gint _tmp123_;
			gpointer _tmp124_;
			ValaField* _tmp125_;
			_tmp119_ = _f_index;
			_f_index = _tmp119_ + 1;
			_tmp120_ = _f_index;
			_tmp121_ = _f_size;
			if (!(_tmp120_ < _tmp121_)) {
				break;
			}
			_tmp122_ = _f_list;
			_tmp123_ = _f_index;
			_tmp124_ = vala_list_get (_tmp122_, _tmp123_);
			f = (ValaField*) _tmp124_;
			_tmp125_ = f;
			vala_code_node_check ((ValaCodeNode*) _tmp125_, context);
			_vala_code_node_unref0 (f);
		}
		_vala_iterable_unref0 (_f_list);
	}
	{
		ValaList* _c_list = NULL;
		ValaList* _tmp126_;
		gint _c_size = 0;
		ValaList* _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _c_index = 0;
		_tmp126_ = vala_object_type_symbol_get_constants ((ValaObjectTypeSymbol*) self);
		_c_list = _tmp126_;
		_tmp127_ = _c_list;
		_tmp128_ = vala_collection_get_size ((ValaCollection*) _tmp127_);
		_tmp129_ = _tmp128_;
		_c_size = _tmp129_;
		_c_index = -1;
		while (TRUE) {
			gint _tmp130_;
			gint _tmp131_;
			gint _tmp132_;
			ValaConstant* c = NULL;
			ValaList* _tmp133_;
			gint _tmp134_;
			gpointer _tmp135_;
			ValaConstant* _tmp136_;
			_tmp130_ = _c_index;
			_c_index = _tmp130_ + 1;
			_tmp131_ = _c_index;
			_tmp132_ = _c_size;
			if (!(_tmp131_ < _tmp132_)) {
				break;
			}
			_tmp133_ = _c_list;
			_tmp134_ = _c_index;
			_tmp135_ = vala_list_get (_tmp133_, _tmp134_);
			c = (ValaConstant*) _tmp135_;
			_tmp136_ = c;
			vala_code_node_check ((ValaCodeNode*) _tmp136_, context);
			_vala_code_node_unref0 (c);
		}
		_vala_iterable_unref0 (_c_list);
	}
	{
		ValaList* _m_list = NULL;
		ValaList* _tmp137_;
		gint _m_size = 0;
		ValaList* _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _m_index = 0;
		_tmp137_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) self);
		_m_list = _tmp137_;
		_tmp138_ = _m_list;
		_tmp139_ = vala_collection_get_size ((ValaCollection*) _tmp138_);
		_tmp140_ = _tmp139_;
		_m_size = _tmp140_;
		_m_index = -1;
		while (TRUE) {
			gint _tmp141_;
			gint _tmp142_;
			gint _tmp143_;
			ValaMethod* m = NULL;
			ValaList* _tmp144_;
			gint _tmp145_;
			gpointer _tmp146_;
			ValaMethod* _tmp147_;
			_tmp141_ = _m_index;
			_m_index = _tmp141_ + 1;
			_tmp142_ = _m_index;
			_tmp143_ = _m_size;
			if (!(_tmp142_ < _tmp143_)) {
				break;
			}
			_tmp144_ = _m_list;
			_tmp145_ = _m_index;
			_tmp146_ = vala_list_get (_tmp144_, _tmp145_);
			m = (ValaMethod*) _tmp146_;
			_tmp147_ = m;
			vala_code_node_check ((ValaCodeNode*) _tmp147_, context);
			_vala_code_node_unref0 (m);
		}
		_vala_iterable_unref0 (_m_list);
	}
	{
		ValaList* _prop_list = NULL;
		ValaList* _tmp148_;
		gint _prop_size = 0;
		ValaList* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _prop_index = 0;
		_tmp148_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) self);
		_prop_list = _tmp148_;
		_tmp149_ = _prop_list;
		_tmp150_ = vala_collection_get_size ((ValaCollection*) _tmp149_);
		_tmp151_ = _tmp150_;
		_prop_size = _tmp151_;
		_prop_index = -1;
		while (TRUE) {
			gint _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			ValaProperty* prop = NULL;
			ValaList* _tmp155_;
			gint _tmp156_;
			gpointer _tmp157_;
			gboolean _tmp158_ = FALSE;
			ValaProperty* _tmp159_;
			ValaAttribute* _tmp160_;
			ValaAttribute* _tmp161_;
			gboolean _tmp162_;
			ValaProperty* _tmp169_;
			_tmp152_ = _prop_index;
			_prop_index = _tmp152_ + 1;
			_tmp153_ = _prop_index;
			_tmp154_ = _prop_size;
			if (!(_tmp153_ < _tmp154_)) {
				break;
			}
			_tmp155_ = _prop_list;
			_tmp156_ = _prop_index;
			_tmp157_ = vala_list_get (_tmp155_, _tmp156_);
			prop = (ValaProperty*) _tmp157_;
			_tmp159_ = prop;
			_tmp160_ = vala_code_node_get_attribute ((ValaCodeNode*) _tmp159_, "NoAccessorMethod");
			_tmp161_ = _tmp160_;
			_tmp162_ = _tmp161_ != NULL;
			_vala_code_node_unref0 (_tmp161_);
			if (_tmp162_) {
				ValaSemanticAnalyzer* _tmp163_;
				ValaSemanticAnalyzer* _tmp164_;
				ValaClass* _tmp165_;
				_tmp163_ = vala_code_context_get_analyzer (context);
				_tmp164_ = _tmp163_;
				_tmp165_ = _tmp164_->object_type;
				_tmp158_ = !vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) self, (ValaTypeSymbol*) _tmp165_);
			} else {
				_tmp158_ = FALSE;
			}
			if (_tmp158_) {
				ValaProperty* _tmp166_;
				ValaSourceReference* _tmp167_;
				ValaSourceReference* _tmp168_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp166_ = prop;
				_tmp167_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp166_);
				_tmp168_ = _tmp167_;
				vala_report_error (_tmp168_, "NoAccessorMethod is only allowed for properties in classes derived fro" \
"m GLib.Object");
				result = FALSE;
				_vala_code_node_unref0 (prop);
				_vala_iterable_unref0 (_prop_list);
				_vala_code_node_unref0 (old_symbol);
				_vala_source_file_unref0 (old_source_file);
				return result;
			}
			_tmp169_ = prop;
			vala_code_node_check ((ValaCodeNode*) _tmp169_, context);
			_vala_code_node_unref0 (prop);
		}
		_vala_iterable_unref0 (_prop_list);
	}
	{
		ValaList* _sig_list = NULL;
		ValaList* _tmp170_;
		gint _sig_size = 0;
		ValaList* _tmp171_;
		gint _tmp172_;
		gint _tmp173_;
		gint _sig_index = 0;
		_tmp170_ = vala_object_type_symbol_get_signals ((ValaObjectTypeSymbol*) self);
		_sig_list = _tmp170_;
		_tmp171_ = _sig_list;
		_tmp172_ = vala_collection_get_size ((ValaCollection*) _tmp171_);
		_tmp173_ = _tmp172_;
		_sig_size = _tmp173_;
		_sig_index = -1;
		while (TRUE) {
			gint _tmp174_;
			gint _tmp175_;
			gint _tmp176_;
			ValaSignal* sig = NULL;
			ValaList* _tmp177_;
			gint _tmp178_;
			gpointer _tmp179_;
			ValaSignal* _tmp180_;
			_tmp174_ = _sig_index;
			_sig_index = _tmp174_ + 1;
			_tmp175_ = _sig_index;
			_tmp176_ = _sig_size;
			if (!(_tmp175_ < _tmp176_)) {
				break;
			}
			_tmp177_ = _sig_list;
			_tmp178_ = _sig_index;
			_tmp179_ = vala_list_get (_tmp177_, _tmp178_);
			sig = (ValaSignal*) _tmp179_;
			_tmp180_ = sig;
			vala_code_node_check ((ValaCodeNode*) _tmp180_, context);
			_vala_code_node_unref0 (sig);
		}
		_vala_iterable_unref0 (_sig_list);
	}
	_tmp181_ = self->priv->_constructor;
	if (_tmp181_ != NULL) {
		ValaConstructor* _tmp182_;
		_tmp182_ = self->priv->_constructor;
		vala_code_node_check ((ValaCodeNode*) _tmp182_, context);
	}
	_tmp183_ = self->priv->_class_constructor;
	if (_tmp183_ != NULL) {
		ValaConstructor* _tmp184_;
		_tmp184_ = self->priv->_class_constructor;
		vala_code_node_check ((ValaCodeNode*) _tmp184_, context);
	}
	_tmp185_ = self->priv->_static_constructor;
	if (_tmp185_ != NULL) {
		ValaConstructor* _tmp186_;
		_tmp186_ = self->priv->_static_constructor;
		vala_code_node_check ((ValaCodeNode*) _tmp186_, context);
	}
	_tmp187_ = vala_class_get_destructor (self);
	_tmp188_ = _tmp187_;
	if (_tmp188_ != NULL) {
		ValaDestructor* _tmp189_;
		ValaDestructor* _tmp190_;
		_tmp189_ = vala_class_get_destructor (self);
		_tmp190_ = _tmp189_;
		vala_code_node_check ((ValaCodeNode*) _tmp190_, context);
	}
	_tmp191_ = self->priv->_static_destructor;
	if (_tmp191_ != NULL) {
		ValaDestructor* _tmp192_;
		_tmp192_ = self->priv->_static_destructor;
		vala_code_node_check ((ValaCodeNode*) _tmp192_, context);
	}
	_tmp193_ = self->priv->_class_destructor;
	if (_tmp193_ != NULL) {
		ValaDestructor* _tmp194_;
		_tmp194_ = self->priv->_class_destructor;
		vala_code_node_check ((ValaCodeNode*) _tmp194_, context);
	}
	{
		ValaList* _cl_list = NULL;
		ValaList* _tmp195_;
		gint _cl_size = 0;
		ValaList* _tmp196_;
		gint _tmp197_;
		gint _tmp198_;
		gint _cl_index = 0;
		_tmp195_ = vala_object_type_symbol_get_classes ((ValaObjectTypeSymbol*) self);
		_cl_list = _tmp195_;
		_tmp196_ = _cl_list;
		_tmp197_ = vala_collection_get_size ((ValaCollection*) _tmp196_);
		_tmp198_ = _tmp197_;
		_cl_size = _tmp198_;
		_cl_index = -1;
		while (TRUE) {
			gint _tmp199_;
			gint _tmp200_;
			gint _tmp201_;
			ValaClass* cl = NULL;
			ValaList* _tmp202_;
			gint _tmp203_;
			gpointer _tmp204_;
			ValaClass* _tmp205_;
			_tmp199_ = _cl_index;
			_cl_index = _tmp199_ + 1;
			_tmp200_ = _cl_index;
			_tmp201_ = _cl_size;
			if (!(_tmp200_ < _tmp201_)) {
				break;
			}
			_tmp202_ = _cl_list;
			_tmp203_ = _cl_index;
			_tmp204_ = vala_list_get (_tmp202_, _tmp203_);
			cl = (ValaClass*) _tmp204_;
			_tmp205_ = cl;
			vala_code_node_check ((ValaCodeNode*) _tmp205_, context);
			_vala_code_node_unref0 (cl);
		}
		_vala_iterable_unref0 (_cl_list);
	}
	{
		ValaList* _st_list = NULL;
		ValaList* _tmp206_;
		gint _st_size = 0;
		ValaList* _tmp207_;
		gint _tmp208_;
		gint _tmp209_;
		gint _st_index = 0;
		_tmp206_ = vala_object_type_symbol_get_structs ((ValaObjectTypeSymbol*) self);
		_st_list = _tmp206_;
		_tmp207_ = _st_list;
		_tmp208_ = vala_collection_get_size ((ValaCollection*) _tmp207_);
		_tmp209_ = _tmp208_;
		_st_size = _tmp209_;
		_st_index = -1;
		while (TRUE) {
			gint _tmp210_;
			gint _tmp211_;
			gint _tmp212_;
			ValaStruct* st = NULL;
			ValaList* _tmp213_;
			gint _tmp214_;
			gpointer _tmp215_;
			ValaStruct* _tmp216_;
			_tmp210_ = _st_index;
			_st_index = _tmp210_ + 1;
			_tmp211_ = _st_index;
			_tmp212_ = _st_size;
			if (!(_tmp211_ < _tmp212_)) {
				break;
			}
			_tmp213_ = _st_list;
			_tmp214_ = _st_index;
			_tmp215_ = vala_list_get (_tmp213_, _tmp214_);
			st = (ValaStruct*) _tmp215_;
			_tmp216_ = st;
			vala_code_node_check ((ValaCodeNode*) _tmp216_, context);
			_vala_code_node_unref0 (st);
		}
		_vala_iterable_unref0 (_st_list);
	}
	{
		ValaList* _d_list = NULL;
		ValaList* _tmp217_;
		gint _d_size = 0;
		ValaList* _tmp218_;
		gint _tmp219_;
		gint _tmp220_;
		gint _d_index = 0;
		_tmp217_ = vala_object_type_symbol_get_delegates ((ValaObjectTypeSymbol*) self);
		_d_list = _tmp217_;
		_tmp218_ = _d_list;
		_tmp219_ = vala_collection_get_size ((ValaCollection*) _tmp218_);
		_tmp220_ = _tmp219_;
		_d_size = _tmp220_;
		_d_index = -1;
		while (TRUE) {
			gint _tmp221_;
			gint _tmp222_;
			gint _tmp223_;
			ValaDelegate* d = NULL;
			ValaList* _tmp224_;
			gint _tmp225_;
			gpointer _tmp226_;
			ValaDelegate* _tmp227_;
			_tmp221_ = _d_index;
			_d_index = _tmp221_ + 1;
			_tmp222_ = _d_index;
			_tmp223_ = _d_size;
			if (!(_tmp222_ < _tmp223_)) {
				break;
			}
			_tmp224_ = _d_list;
			_tmp225_ = _d_index;
			_tmp226_ = vala_list_get (_tmp224_, _tmp225_);
			d = (ValaDelegate*) _tmp226_;
			_tmp227_ = d;
			vala_code_node_check ((ValaCodeNode*) _tmp227_, context);
			_vala_code_node_unref0 (d);
		}
		_vala_iterable_unref0 (_d_list);
	}
	_tmp228_ = vala_class_get_is_compact (self);
	_tmp229_ = _tmp228_;
	if (_tmp229_) {
		gboolean _tmp249_ = FALSE;
		gboolean _tmp250_ = FALSE;
		gboolean _tmp251_ = FALSE;
		gboolean _tmp252_;
		gboolean _tmp253_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp230_;
			gint _base_type_size = 0;
			ValaList* _tmp231_;
			gint _tmp232_;
			gint _tmp233_;
			gint _base_type_index = 0;
			_tmp230_ = vala_class_get_base_types (self);
			_base_type_list = _tmp230_;
			_tmp231_ = _base_type_list;
			_tmp232_ = vala_collection_get_size ((ValaCollection*) _tmp231_);
			_tmp233_ = _tmp232_;
			_base_type_size = _tmp233_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp234_;
				gint _tmp235_;
				gint _tmp236_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp237_;
				gint _tmp238_;
				gpointer _tmp239_;
				ValaDataType* _tmp240_;
				ValaTypeSymbol* _tmp241_;
				ValaTypeSymbol* _tmp242_;
				_tmp234_ = _base_type_index;
				_base_type_index = _tmp234_ + 1;
				_tmp235_ = _base_type_index;
				_tmp236_ = _base_type_size;
				if (!(_tmp235_ < _tmp236_)) {
					break;
				}
				_tmp237_ = _base_type_list;
				_tmp238_ = _base_type_index;
				_tmp239_ = vala_list_get (_tmp237_, _tmp238_);
				base_type = (ValaDataType*) _tmp239_;
				_tmp240_ = base_type;
				_tmp241_ = vala_data_type_get_data_type (_tmp240_);
				_tmp242_ = _tmp241_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp242_, VALA_TYPE_INTERFACE)) {
					ValaSourceReference* _tmp243_;
					ValaSourceReference* _tmp244_;
					gchar* _tmp245_;
					gchar* _tmp246_;
					gchar* _tmp247_;
					gchar* _tmp248_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp243_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp244_ = _tmp243_;
					_tmp245_ = vala_symbol_get_full_name ((ValaSymbol*) self);
					_tmp246_ = _tmp245_;
					_tmp247_ = g_strdup_printf ("compact classes `%s` may not implement interfaces", _tmp246_);
					_tmp248_ = _tmp247_;
					vala_report_error (_tmp244_, _tmp248_);
					_g_free0 (_tmp248_);
					_g_free0 (_tmp246_);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp252_ = vala_symbol_get_external ((ValaSymbol*) self);
		_tmp253_ = _tmp252_;
		if (!_tmp253_) {
			gboolean _tmp254_;
			gboolean _tmp255_;
			_tmp254_ = vala_symbol_get_external_package ((ValaSymbol*) self);
			_tmp255_ = _tmp254_;
			_tmp251_ = !_tmp255_;
		} else {
			_tmp251_ = FALSE;
		}
		if (_tmp251_) {
			ValaClass* _tmp256_;
			_tmp256_ = self->priv->_base_class;
			_tmp250_ = _tmp256_ != NULL;
		} else {
			_tmp250_ = FALSE;
		}
		if (_tmp250_) {
			ValaClass* _tmp257_;
			ValaSemanticAnalyzer* _tmp258_;
			ValaSemanticAnalyzer* _tmp259_;
			ValaClass* _tmp260_;
			_tmp257_ = self->priv->_base_class;
			_tmp258_ = vala_code_context_get_analyzer (context);
			_tmp259_ = _tmp258_;
			_tmp260_ = _tmp259_->gsource_type;
			_tmp249_ = _tmp257_ != _tmp260_;
		} else {
			_tmp249_ = FALSE;
		}
		if (_tmp249_) {
			{
				ValaList* _f_list = NULL;
				ValaList* _tmp261_;
				gint _f_size = 0;
				ValaList* _tmp262_;
				gint _tmp263_;
				gint _tmp264_;
				gint _f_index = 0;
				_tmp261_ = vala_object_type_symbol_get_fields ((ValaObjectTypeSymbol*) self);
				_f_list = _tmp261_;
				_tmp262_ = _f_list;
				_tmp263_ = vala_collection_get_size ((ValaCollection*) _tmp262_);
				_tmp264_ = _tmp263_;
				_f_size = _tmp264_;
				_f_index = -1;
				while (TRUE) {
					gint _tmp265_;
					gint _tmp266_;
					gint _tmp267_;
					ValaField* f = NULL;
					ValaList* _tmp268_;
					gint _tmp269_;
					gpointer _tmp270_;
					ValaField* _tmp271_;
					ValaMemberBinding _tmp272_;
					ValaMemberBinding _tmp273_;
					_tmp265_ = _f_index;
					_f_index = _tmp265_ + 1;
					_tmp266_ = _f_index;
					_tmp267_ = _f_size;
					if (!(_tmp266_ < _tmp267_)) {
						break;
					}
					_tmp268_ = _f_list;
					_tmp269_ = _f_index;
					_tmp270_ = vala_list_get (_tmp268_, _tmp269_);
					f = (ValaField*) _tmp270_;
					_tmp271_ = f;
					_tmp272_ = vala_field_get_binding (_tmp271_);
					_tmp273_ = _tmp272_;
					if (_tmp273_ == VALA_MEMBER_BINDING_INSTANCE) {
						ValaSourceReference* _tmp274_;
						ValaSourceReference* _tmp275_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp274_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp275_ = _tmp274_;
						vala_report_error (_tmp275_, "derived compact classes may not have instance fields");
						_vala_code_node_unref0 (f);
						break;
					}
					_vala_code_node_unref0 (f);
				}
				_vala_iterable_unref0 (_f_list);
			}
		}
	}
	_tmp276_ = g_direct_equal;
	_tmp277_ = vala_array_list_new (VALA_TYPE_TYPESYMBOL, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp276_);
	prerequisites = (ValaList*) _tmp277_;
	{
		ValaList* _base_type_list = NULL;
		ValaList* _tmp278_;
		gint _base_type_size = 0;
		ValaList* _tmp279_;
		gint _tmp280_;
		gint _tmp281_;
		gint _base_type_index = 0;
		_tmp278_ = vala_class_get_base_types (self);
		_base_type_list = _tmp278_;
		_tmp279_ = _base_type_list;
		_tmp280_ = vala_collection_get_size ((ValaCollection*) _tmp279_);
		_tmp281_ = _tmp280_;
		_base_type_size = _tmp281_;
		_base_type_index = -1;
		while (TRUE) {
			gint _tmp282_;
			gint _tmp283_;
			gint _tmp284_;
			ValaDataType* base_type = NULL;
			ValaList* _tmp285_;
			gint _tmp286_;
			gpointer _tmp287_;
			ValaDataType* _tmp288_;
			ValaTypeSymbol* _tmp289_;
			ValaTypeSymbol* _tmp290_;
			_tmp282_ = _base_type_index;
			_base_type_index = _tmp282_ + 1;
			_tmp283_ = _base_type_index;
			_tmp284_ = _base_type_size;
			if (!(_tmp283_ < _tmp284_)) {
				break;
			}
			_tmp285_ = _base_type_list;
			_tmp286_ = _base_type_index;
			_tmp287_ = vala_list_get (_tmp285_, _tmp286_);
			base_type = (ValaDataType*) _tmp287_;
			_tmp288_ = base_type;
			_tmp289_ = vala_data_type_get_data_type (_tmp288_);
			_tmp290_ = _tmp289_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp290_, VALA_TYPE_INTERFACE)) {
				ValaDataType* _tmp291_;
				ValaTypeSymbol* _tmp292_;
				ValaTypeSymbol* _tmp293_;
				ValaList* _tmp294_;
				_tmp291_ = base_type;
				_tmp292_ = vala_data_type_get_data_type (_tmp291_);
				_tmp293_ = _tmp292_;
				_tmp294_ = prerequisites;
				vala_class_get_all_prerequisites (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp293_, VALA_TYPE_INTERFACE, ValaInterface), _tmp294_);
			}
			_vala_code_node_unref0 (base_type);
		}
		_vala_iterable_unref0 (_base_type_list);
	}
	_tmp295_ = g_direct_equal;
	_tmp296_ = vala_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp295_);
	missing_prereqs = (ValaList*) _tmp296_;
	{
		ValaList* _prereq_list = NULL;
		ValaList* _tmp297_;
		ValaList* _tmp298_;
		gint _prereq_size = 0;
		ValaList* _tmp299_;
		gint _tmp300_;
		gint _tmp301_;
		gint _prereq_index = 0;
		_tmp297_ = prerequisites;
		_tmp298_ = _vala_iterable_ref0 (_tmp297_);
		_prereq_list = _tmp298_;
		_tmp299_ = _prereq_list;
		_tmp300_ = vala_collection_get_size ((ValaCollection*) _tmp299_);
		_tmp301_ = _tmp300_;
		_prereq_size = _tmp301_;
		_prereq_index = -1;
		while (TRUE) {
			gint _tmp302_;
			gint _tmp303_;
			gint _tmp304_;
			ValaTypeSymbol* prereq = NULL;
			ValaList* _tmp305_;
			gint _tmp306_;
			gpointer _tmp307_;
			ValaTypeSymbol* _tmp308_;
			_tmp302_ = _prereq_index;
			_prereq_index = _tmp302_ + 1;
			_tmp303_ = _prereq_index;
			_tmp304_ = _prereq_size;
			if (!(_tmp303_ < _tmp304_)) {
				break;
			}
			_tmp305_ = _prereq_list;
			_tmp306_ = _prereq_index;
			_tmp307_ = vala_list_get (_tmp305_, _tmp306_);
			prereq = (ValaTypeSymbol*) _tmp307_;
			_tmp308_ = prereq;
			if (!vala_class_class_is_a (self, self, _tmp308_)) {
				ValaList* _tmp309_;
				ValaTypeSymbol* _tmp310_;
				gchar* _tmp311_;
				gchar* _tmp312_;
				_tmp309_ = missing_prereqs;
				_tmp310_ = prereq;
				_tmp311_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp310_);
				_tmp312_ = _tmp311_;
				vala_list_insert (_tmp309_, 0, _tmp312_);
				_g_free0 (_tmp312_);
			}
			_vala_code_node_unref0 (prereq);
		}
		_vala_iterable_unref0 (_prereq_list);
	}
	_tmp313_ = missing_prereqs;
	_tmp314_ = vala_collection_get_size ((ValaCollection*) _tmp313_);
	_tmp315_ = _tmp314_;
	if (_tmp315_ > 0) {
		gchar* error_string = NULL;
		gchar* _tmp316_;
		gchar* _tmp317_;
		gchar* _tmp318_;
		gchar* _tmp319_;
		gboolean first = FALSE;
		const gchar* _tmp338_;
		gchar* _tmp339_;
		ValaSourceReference* _tmp340_;
		ValaSourceReference* _tmp341_;
		const gchar* _tmp342_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp316_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp317_ = _tmp316_;
		_tmp318_ = g_strdup_printf ("%s: some prerequisites (", _tmp317_);
		_tmp319_ = _tmp318_;
		_g_free0 (_tmp317_);
		error_string = _tmp319_;
		first = TRUE;
		{
			ValaList* _s_list = NULL;
			ValaList* _tmp320_;
			ValaList* _tmp321_;
			gint _s_size = 0;
			ValaList* _tmp322_;
			gint _tmp323_;
			gint _tmp324_;
			gint _s_index = 0;
			_tmp320_ = missing_prereqs;
			_tmp321_ = _vala_iterable_ref0 (_tmp320_);
			_s_list = _tmp321_;
			_tmp322_ = _s_list;
			_tmp323_ = vala_collection_get_size ((ValaCollection*) _tmp322_);
			_tmp324_ = _tmp323_;
			_s_size = _tmp324_;
			_s_index = -1;
			while (TRUE) {
				gint _tmp325_;
				gint _tmp326_;
				gint _tmp327_;
				gchar* s = NULL;
				ValaList* _tmp328_;
				gint _tmp329_;
				gpointer _tmp330_;
				gboolean _tmp331_;
				_tmp325_ = _s_index;
				_s_index = _tmp325_ + 1;
				_tmp326_ = _s_index;
				_tmp327_ = _s_size;
				if (!(_tmp326_ < _tmp327_)) {
					break;
				}
				_tmp328_ = _s_list;
				_tmp329_ = _s_index;
				_tmp330_ = vala_list_get (_tmp328_, _tmp329_);
				s = (gchar*) _tmp330_;
				_tmp331_ = first;
				if (_tmp331_) {
					const gchar* _tmp332_;
					const gchar* _tmp333_;
					gchar* _tmp334_;
					_tmp332_ = error_string;
					_tmp333_ = s;
					_tmp334_ = g_strdup_printf ("%s`%s'", _tmp332_, _tmp333_);
					_g_free0 (error_string);
					error_string = _tmp334_;
					first = FALSE;
				} else {
					const gchar* _tmp335_;
					const gchar* _tmp336_;
					gchar* _tmp337_;
					_tmp335_ = error_string;
					_tmp336_ = s;
					_tmp337_ = g_strdup_printf ("%s, `%s'", _tmp335_, _tmp336_);
					_g_free0 (error_string);
					error_string = _tmp337_;
				}
				_g_free0 (s);
			}
			_vala_iterable_unref0 (_s_list);
		}
		_tmp338_ = error_string;
		_tmp339_ = g_strconcat (_tmp338_, ") are not met", NULL);
		_g_free0 (error_string);
		error_string = _tmp339_;
		_tmp340_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp341_ = _tmp340_;
		_tmp342_ = error_string;
		vala_report_error (_tmp341_, _tmp342_);
		_g_free0 (error_string);
	}
	_tmp343_ = vala_symbol_get_source_type ((ValaSymbol*) self);
	_tmp344_ = _tmp343_;
	if (_tmp344_ == VALA_SOURCE_FILE_TYPE_SOURCE) {
		gboolean _tmp494_;
		{
			ValaList* _base_type_list = NULL;
			ValaList* _tmp345_;
			gint _base_type_size = 0;
			ValaList* _tmp346_;
			gint _tmp347_;
			gint _tmp348_;
			gint _base_type_index = 0;
			_tmp345_ = vala_class_get_base_types (self);
			_base_type_list = _tmp345_;
			_tmp346_ = _base_type_list;
			_tmp347_ = vala_collection_get_size ((ValaCollection*) _tmp346_);
			_tmp348_ = _tmp347_;
			_base_type_size = _tmp348_;
			_base_type_index = -1;
			while (TRUE) {
				gint _tmp349_;
				gint _tmp350_;
				gint _tmp351_;
				ValaDataType* base_type = NULL;
				ValaList* _tmp352_;
				gint _tmp353_;
				gpointer _tmp354_;
				ValaDataType* _tmp355_;
				ValaTypeSymbol* _tmp356_;
				ValaTypeSymbol* _tmp357_;
				_tmp349_ = _base_type_index;
				_base_type_index = _tmp349_ + 1;
				_tmp350_ = _base_type_index;
				_tmp351_ = _base_type_size;
				if (!(_tmp350_ < _tmp351_)) {
					break;
				}
				_tmp352_ = _base_type_list;
				_tmp353_ = _base_type_index;
				_tmp354_ = vala_list_get (_tmp352_, _tmp353_);
				base_type = (ValaDataType*) _tmp354_;
				_tmp355_ = base_type;
				_tmp356_ = vala_data_type_get_data_type (_tmp355_);
				_tmp357_ = _tmp356_;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp357_, VALA_TYPE_INTERFACE)) {
					ValaInterface* iface = NULL;
					ValaDataType* _tmp358_;
					ValaTypeSymbol* _tmp359_;
					ValaTypeSymbol* _tmp360_;
					ValaInterface* _tmp361_;
					gboolean _tmp362_ = FALSE;
					ValaClass* _tmp363_;
					_tmp358_ = base_type;
					_tmp359_ = vala_data_type_get_data_type (_tmp358_);
					_tmp360_ = _tmp359_;
					_tmp361_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp360_, VALA_TYPE_INTERFACE, ValaInterface));
					iface = _tmp361_;
					_tmp363_ = self->priv->_base_class;
					if (_tmp363_ != NULL) {
						ValaClass* _tmp364_;
						ValaInterface* _tmp365_;
						_tmp364_ = self->priv->_base_class;
						_tmp365_ = iface;
						_tmp362_ = vala_typesymbol_is_subtype_of ((ValaTypeSymbol*) _tmp364_, (ValaTypeSymbol*) _tmp365_);
					} else {
						_tmp362_ = FALSE;
					}
					if (_tmp362_) {
						_vala_code_node_unref0 (iface);
						_vala_code_node_unref0 (base_type);
						break;
					}
					{
						ValaList* _m_list = NULL;
						ValaInterface* _tmp366_;
						ValaList* _tmp367_;
						gint _m_size = 0;
						ValaList* _tmp368_;
						gint _tmp369_;
						gint _tmp370_;
						gint _m_index = 0;
						_tmp366_ = iface;
						_tmp367_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp366_);
						_m_list = _tmp367_;
						_tmp368_ = _m_list;
						_tmp369_ = vala_collection_get_size ((ValaCollection*) _tmp368_);
						_tmp370_ = _tmp369_;
						_m_size = _tmp370_;
						_m_index = -1;
						while (TRUE) {
							gint _tmp371_;
							gint _tmp372_;
							gint _tmp373_;
							ValaMethod* m = NULL;
							ValaList* _tmp374_;
							gint _tmp375_;
							gpointer _tmp376_;
							ValaMethod* _tmp377_;
							gboolean _tmp378_;
							gboolean _tmp379_;
							_tmp371_ = _m_index;
							_m_index = _tmp371_ + 1;
							_tmp372_ = _m_index;
							_tmp373_ = _m_size;
							if (!(_tmp372_ < _tmp373_)) {
								break;
							}
							_tmp374_ = _m_list;
							_tmp375_ = _m_index;
							_tmp376_ = vala_list_get (_tmp374_, _tmp375_);
							m = (ValaMethod*) _tmp376_;
							_tmp377_ = m;
							_tmp378_ = vala_method_get_is_abstract (_tmp377_);
							_tmp379_ = _tmp378_;
							if (_tmp379_) {
								gboolean implemented = FALSE;
								ValaClass* base_class = NULL;
								ValaClass* _tmp380_;
								gboolean _tmp419_;
								implemented = FALSE;
								_tmp380_ = _vala_code_node_ref0 (self);
								base_class = _tmp380_;
								while (TRUE) {
									ValaClass* _tmp381_;
									ValaClass* _tmp416_;
									ValaClass* _tmp417_;
									ValaClass* _tmp418_;
									_tmp381_ = base_class;
									if (!(_tmp381_ != NULL)) {
										break;
									}
									{
										ValaList* _impl_list = NULL;
										ValaClass* _tmp382_;
										ValaList* _tmp383_;
										gint _impl_size = 0;
										ValaList* _tmp384_;
										gint _tmp385_;
										gint _tmp386_;
										gint _impl_index = 0;
										_tmp382_ = base_class;
										_tmp383_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp382_);
										_impl_list = _tmp383_;
										_tmp384_ = _impl_list;
										_tmp385_ = vala_collection_get_size ((ValaCollection*) _tmp384_);
										_tmp386_ = _tmp385_;
										_impl_size = _tmp386_;
										_impl_index = -1;
										while (TRUE) {
											gint _tmp387_;
											gint _tmp388_;
											gint _tmp389_;
											ValaMethod* impl = NULL;
											ValaList* _tmp390_;
											gint _tmp391_;
											gpointer _tmp392_;
											gboolean _tmp393_ = FALSE;
											ValaMethod* _tmp394_;
											const gchar* _tmp395_;
											const gchar* _tmp396_;
											ValaMethod* _tmp397_;
											const gchar* _tmp398_;
											const gchar* _tmp399_;
											_tmp387_ = _impl_index;
											_impl_index = _tmp387_ + 1;
											_tmp388_ = _impl_index;
											_tmp389_ = _impl_size;
											if (!(_tmp388_ < _tmp389_)) {
												break;
											}
											_tmp390_ = _impl_list;
											_tmp391_ = _impl_index;
											_tmp392_ = vala_list_get (_tmp390_, _tmp391_);
											impl = (ValaMethod*) _tmp392_;
											_tmp394_ = impl;
											_tmp395_ = vala_symbol_get_name ((ValaSymbol*) _tmp394_);
											_tmp396_ = _tmp395_;
											_tmp397_ = m;
											_tmp398_ = vala_symbol_get_name ((ValaSymbol*) _tmp397_);
											_tmp399_ = _tmp398_;
											if (g_strcmp0 (_tmp396_, _tmp399_) == 0) {
												gboolean _tmp400_ = FALSE;
												ValaMethod* _tmp401_;
												ValaDataType* _tmp402_;
												ValaDataType* _tmp403_;
												_tmp401_ = impl;
												_tmp402_ = vala_method_get_base_interface_type (_tmp401_);
												_tmp403_ = _tmp402_;
												if (_tmp403_ == NULL) {
													_tmp400_ = TRUE;
												} else {
													ValaMethod* _tmp404_;
													ValaDataType* _tmp405_;
													ValaDataType* _tmp406_;
													ValaTypeSymbol* _tmp407_;
													ValaTypeSymbol* _tmp408_;
													ValaInterface* _tmp409_;
													_tmp404_ = impl;
													_tmp405_ = vala_method_get_base_interface_type (_tmp404_);
													_tmp406_ = _tmp405_;
													_tmp407_ = vala_data_type_get_data_type (_tmp406_);
													_tmp408_ = _tmp407_;
													_tmp409_ = iface;
													_tmp400_ = _tmp408_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp409_, VALA_TYPE_TYPESYMBOL, ValaTypeSymbol);
												}
												_tmp393_ = _tmp400_;
											} else {
												_tmp393_ = FALSE;
											}
											if (_tmp393_) {
												ValaMethod* _tmp410_;
												ValaVersionAttribute* _tmp411_;
												ValaVersionAttribute* _tmp412_;
												ValaSourceReference* _tmp413_;
												ValaSourceReference* _tmp414_;
												ValaMethod* _tmp415_;
												_tmp410_ = impl;
												_tmp411_ = vala_symbol_get_version ((ValaSymbol*) _tmp410_);
												_tmp412_ = _tmp411_;
												_tmp413_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
												_tmp414_ = _tmp413_;
												vala_version_attribute_check (_tmp412_, _tmp414_);
												_tmp415_ = impl;
												vala_symbol_set_used ((ValaSymbol*) _tmp415_, TRUE);
												implemented = TRUE;
												_vala_code_node_unref0 (impl);
												break;
											}
											_vala_code_node_unref0 (impl);
										}
										_vala_iterable_unref0 (_impl_list);
									}
									_tmp416_ = base_class;
									_tmp417_ = _tmp416_->priv->_base_class;
									_tmp418_ = _vala_code_node_ref0 (_tmp417_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp418_;
								}
								_tmp419_ = implemented;
								if (!_tmp419_) {
									ValaSourceReference* _tmp420_;
									ValaSourceReference* _tmp421_;
									gchar* _tmp422_;
									gchar* _tmp423_;
									ValaMethod* _tmp424_;
									gchar* _tmp425_;
									gchar* _tmp426_;
									gchar* _tmp427_;
									gchar* _tmp428_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp420_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp421_ = _tmp420_;
									_tmp422_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp423_ = _tmp422_;
									_tmp424_ = m;
									_tmp425_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp424_);
									_tmp426_ = _tmp425_;
									_tmp427_ = g_strdup_printf ("`%s' does not implement interface method `%s'", _tmp423_, _tmp426_);
									_tmp428_ = _tmp427_;
									vala_report_error (_tmp421_, _tmp428_);
									_g_free0 (_tmp428_);
									_g_free0 (_tmp426_);
									_g_free0 (_tmp423_);
								}
								_vala_code_node_unref0 (base_class);
							}
							_vala_code_node_unref0 (m);
						}
						_vala_iterable_unref0 (_m_list);
					}
					{
						ValaList* _prop_list = NULL;
						ValaInterface* _tmp429_;
						ValaList* _tmp430_;
						gint _prop_size = 0;
						ValaList* _tmp431_;
						gint _tmp432_;
						gint _tmp433_;
						gint _prop_index = 0;
						_tmp429_ = iface;
						_tmp430_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp429_);
						_prop_list = _tmp430_;
						_tmp431_ = _prop_list;
						_tmp432_ = vala_collection_get_size ((ValaCollection*) _tmp431_);
						_tmp433_ = _tmp432_;
						_prop_size = _tmp433_;
						_prop_index = -1;
						while (TRUE) {
							gint _tmp434_;
							gint _tmp435_;
							gint _tmp436_;
							ValaProperty* prop = NULL;
							ValaList* _tmp437_;
							gint _tmp438_;
							gpointer _tmp439_;
							ValaProperty* _tmp440_;
							gboolean _tmp441_;
							gboolean _tmp442_;
							_tmp434_ = _prop_index;
							_prop_index = _tmp434_ + 1;
							_tmp435_ = _prop_index;
							_tmp436_ = _prop_size;
							if (!(_tmp435_ < _tmp436_)) {
								break;
							}
							_tmp437_ = _prop_list;
							_tmp438_ = _prop_index;
							_tmp439_ = vala_list_get (_tmp437_, _tmp438_);
							prop = (ValaProperty*) _tmp439_;
							_tmp440_ = prop;
							_tmp441_ = vala_property_get_is_abstract (_tmp440_);
							_tmp442_ = _tmp441_;
							if (_tmp442_) {
								ValaSymbol* sym = NULL;
								ValaClass* base_class = NULL;
								ValaClass* _tmp443_;
								ValaSymbol* _tmp457_;
								sym = NULL;
								_tmp443_ = _vala_code_node_ref0 (self);
								base_class = _tmp443_;
								while (TRUE) {
									gboolean _tmp444_ = FALSE;
									ValaClass* _tmp445_;
									ValaClass* _tmp447_;
									ValaScope* _tmp448_;
									ValaScope* _tmp449_;
									ValaProperty* _tmp450_;
									const gchar* _tmp451_;
									const gchar* _tmp452_;
									ValaSymbol* _tmp453_;
									ValaClass* _tmp454_;
									ValaClass* _tmp455_;
									ValaClass* _tmp456_;
									_tmp445_ = base_class;
									if (_tmp445_ != NULL) {
										ValaSymbol* _tmp446_;
										_tmp446_ = sym;
										_tmp444_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp446_, VALA_TYPE_PROPERTY);
									} else {
										_tmp444_ = FALSE;
									}
									if (!_tmp444_) {
										break;
									}
									_tmp447_ = base_class;
									_tmp448_ = vala_symbol_get_scope ((ValaSymbol*) _tmp447_);
									_tmp449_ = _tmp448_;
									_tmp450_ = prop;
									_tmp451_ = vala_symbol_get_name ((ValaSymbol*) _tmp450_);
									_tmp452_ = _tmp451_;
									_tmp453_ = vala_scope_lookup (_tmp449_, _tmp452_);
									_vala_code_node_unref0 (sym);
									sym = _tmp453_;
									_tmp454_ = base_class;
									_tmp455_ = _tmp454_->priv->_base_class;
									_tmp456_ = _vala_code_node_ref0 (_tmp455_);
									_vala_code_node_unref0 (base_class);
									base_class = _tmp456_;
								}
								_tmp457_ = sym;
								if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp457_, VALA_TYPE_PROPERTY)) {
									ValaProperty* base_prop = NULL;
									ValaSymbol* _tmp458_;
									ValaProperty* _tmp459_;
									gchar* invalid_match = NULL;
									gboolean _tmp460_ = FALSE;
									ValaProperty* _tmp461_;
									gboolean _tmp462_;
									gboolean _tmp463_;
									ValaSymbol* _tmp479_;
									ValaVersionAttribute* _tmp480_;
									ValaVersionAttribute* _tmp481_;
									ValaSourceReference* _tmp482_;
									ValaSourceReference* _tmp483_;
									ValaSymbol* _tmp484_;
									_tmp458_ = sym;
									_tmp459_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp458_, VALA_TYPE_PROPERTY, ValaProperty));
									base_prop = _tmp459_;
									invalid_match = NULL;
									_tmp461_ = base_prop;
									_tmp462_ = vala_symbol_get_hides ((ValaSymbol*) _tmp461_);
									_tmp463_ = _tmp462_;
									if (!_tmp463_) {
										ValaProperty* _tmp464_;
										ValaProperty* _tmp465_;
										gchar* _tmp466_ = NULL;
										gboolean _tmp467_;
										_tmp464_ = base_prop;
										_tmp465_ = prop;
										_tmp467_ = vala_property_compatible (_tmp464_, _tmp465_, &_tmp466_);
										_g_free0 (invalid_match);
										invalid_match = _tmp466_;
										_tmp460_ = !_tmp467_;
									} else {
										_tmp460_ = FALSE;
									}
									if (_tmp460_) {
										ValaSourceReference* _tmp468_;
										ValaSourceReference* _tmp469_;
										ValaProperty* _tmp470_;
										gchar* _tmp471_;
										gchar* _tmp472_;
										ValaProperty* _tmp473_;
										gchar* _tmp474_;
										gchar* _tmp475_;
										const gchar* _tmp476_;
										gchar* _tmp477_;
										gchar* _tmp478_;
										vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
										_tmp468_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
										_tmp469_ = _tmp468_;
										_tmp470_ = prop;
										_tmp471_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp470_);
										_tmp472_ = _tmp471_;
										_tmp473_ = base_prop;
										_tmp474_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp473_);
										_tmp475_ = _tmp474_;
										_tmp476_ = invalid_match;
										_tmp477_ = g_strdup_printf ("Type and/or accessors of inherited properties `%s' and `%s' do not mat" \
"ch: %s.", _tmp472_, _tmp475_, _tmp476_);
										_tmp478_ = _tmp477_;
										vala_report_error (_tmp469_, _tmp478_);
										_g_free0 (_tmp478_);
										_g_free0 (_tmp475_);
										_g_free0 (_tmp472_);
									}
									_tmp479_ = sym;
									_tmp480_ = vala_symbol_get_version (_tmp479_);
									_tmp481_ = _tmp480_;
									_tmp482_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp483_ = _tmp482_;
									vala_version_attribute_check (_tmp481_, _tmp483_);
									_tmp484_ = sym;
									vala_symbol_set_used (_tmp484_, TRUE);
									_g_free0 (invalid_match);
									_vala_code_node_unref0 (base_prop);
								} else {
									ValaSourceReference* _tmp485_;
									ValaSourceReference* _tmp486_;
									gchar* _tmp487_;
									gchar* _tmp488_;
									ValaProperty* _tmp489_;
									gchar* _tmp490_;
									gchar* _tmp491_;
									gchar* _tmp492_;
									gchar* _tmp493_;
									vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
									_tmp485_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
									_tmp486_ = _tmp485_;
									_tmp487_ = vala_symbol_get_full_name ((ValaSymbol*) self);
									_tmp488_ = _tmp487_;
									_tmp489_ = prop;
									_tmp490_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp489_);
									_tmp491_ = _tmp490_;
									_tmp492_ = g_strdup_printf ("`%s' does not implement interface property `%s'", _tmp488_, _tmp491_);
									_tmp493_ = _tmp492_;
									vala_report_error (_tmp486_, _tmp493_);
									_g_free0 (_tmp493_);
									_g_free0 (_tmp491_);
									_g_free0 (_tmp488_);
								}
								_vala_code_node_unref0 (base_class);
								_vala_code_node_unref0 (sym);
							}
							_vala_code_node_unref0 (prop);
						}
						_vala_iterable_unref0 (_prop_list);
					}
					_vala_code_node_unref0 (iface);
				}
				_vala_code_node_unref0 (base_type);
			}
			_vala_iterable_unref0 (_base_type_list);
		}
		_tmp494_ = self->priv->_is_abstract;
		if (!_tmp494_) {
			ValaClass* base_class = NULL;
			ValaClass* _tmp495_;
			ValaClass* _tmp496_;
			_tmp495_ = self->priv->_base_class;
			_tmp496_ = _vala_code_node_ref0 (_tmp495_);
			base_class = _tmp496_;
			while (TRUE) {
				gboolean _tmp497_ = FALSE;
				ValaClass* _tmp498_;
				ValaClass* _tmp567_;
				ValaClass* _tmp568_;
				ValaClass* _tmp569_;
				_tmp498_ = base_class;
				if (_tmp498_ != NULL) {
					ValaClass* _tmp499_;
					gboolean _tmp500_;
					_tmp499_ = base_class;
					_tmp500_ = _tmp499_->priv->_is_abstract;
					_tmp497_ = _tmp500_;
				} else {
					_tmp497_ = FALSE;
				}
				if (!_tmp497_) {
					break;
				}
				{
					ValaList* _base_method_list = NULL;
					ValaClass* _tmp501_;
					ValaList* _tmp502_;
					gint _base_method_size = 0;
					ValaList* _tmp503_;
					gint _tmp504_;
					gint _tmp505_;
					gint _base_method_index = 0;
					_tmp501_ = base_class;
					_tmp502_ = vala_object_type_symbol_get_methods ((ValaObjectTypeSymbol*) _tmp501_);
					_base_method_list = _tmp502_;
					_tmp503_ = _base_method_list;
					_tmp504_ = vala_collection_get_size ((ValaCollection*) _tmp503_);
					_tmp505_ = _tmp504_;
					_base_method_size = _tmp505_;
					_base_method_index = -1;
					while (TRUE) {
						gint _tmp506_;
						gint _tmp507_;
						gint _tmp508_;
						ValaMethod* base_method = NULL;
						ValaList* _tmp509_;
						gint _tmp510_;
						gpointer _tmp511_;
						ValaMethod* _tmp512_;
						gboolean _tmp513_;
						gboolean _tmp514_;
						_tmp506_ = _base_method_index;
						_base_method_index = _tmp506_ + 1;
						_tmp507_ = _base_method_index;
						_tmp508_ = _base_method_size;
						if (!(_tmp507_ < _tmp508_)) {
							break;
						}
						_tmp509_ = _base_method_list;
						_tmp510_ = _base_method_index;
						_tmp511_ = vala_list_get (_tmp509_, _tmp510_);
						base_method = (ValaMethod*) _tmp511_;
						_tmp512_ = base_method;
						_tmp513_ = vala_method_get_is_abstract (_tmp512_);
						_tmp514_ = _tmp513_;
						if (_tmp514_) {
							ValaMethod* override_method = NULL;
							ValaMethod* _tmp515_;
							const gchar* _tmp516_;
							const gchar* _tmp517_;
							ValaSymbol* _tmp518_;
							ValaMethod* _tmp519_;
							gboolean _tmp520_ = FALSE;
							ValaMethod* _tmp521_;
							_tmp515_ = base_method;
							_tmp516_ = vala_symbol_get_name ((ValaSymbol*) _tmp515_);
							_tmp517_ = _tmp516_;
							_tmp518_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp517_);
							_tmp519_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp518_, VALA_TYPE_METHOD) ? ((ValaMethod*) _tmp518_) : NULL;
							if (_tmp519_ == NULL) {
								_vala_code_node_unref0 (_tmp518_);
							}
							override_method = _tmp519_;
							_tmp521_ = override_method;
							if (_tmp521_ == NULL) {
								_tmp520_ = TRUE;
							} else {
								ValaMethod* _tmp522_;
								gboolean _tmp523_;
								gboolean _tmp524_;
								_tmp522_ = override_method;
								_tmp523_ = vala_method_get_overrides (_tmp522_);
								_tmp524_ = _tmp523_;
								_tmp520_ = !_tmp524_;
							}
							if (_tmp520_) {
								ValaSourceReference* _tmp525_;
								ValaSourceReference* _tmp526_;
								gchar* _tmp527_;
								gchar* _tmp528_;
								ValaMethod* _tmp529_;
								gchar* _tmp530_;
								gchar* _tmp531_;
								gchar* _tmp532_;
								gchar* _tmp533_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp525_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp526_ = _tmp525_;
								_tmp527_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp528_ = _tmp527_;
								_tmp529_ = base_method;
								_tmp530_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp529_);
								_tmp531_ = _tmp530_;
								_tmp532_ = g_strdup_printf ("`%s' does not implement abstract method `%s'", _tmp528_, _tmp531_);
								_tmp533_ = _tmp532_;
								vala_report_error (_tmp526_, _tmp533_);
								_g_free0 (_tmp533_);
								_g_free0 (_tmp531_);
								_g_free0 (_tmp528_);
							}
							_vala_code_node_unref0 (override_method);
						}
						_vala_code_node_unref0 (base_method);
					}
					_vala_iterable_unref0 (_base_method_list);
				}
				{
					ValaList* _base_property_list = NULL;
					ValaClass* _tmp534_;
					ValaList* _tmp535_;
					gint _base_property_size = 0;
					ValaList* _tmp536_;
					gint _tmp537_;
					gint _tmp538_;
					gint _base_property_index = 0;
					_tmp534_ = base_class;
					_tmp535_ = vala_object_type_symbol_get_properties ((ValaObjectTypeSymbol*) _tmp534_);
					_base_property_list = _tmp535_;
					_tmp536_ = _base_property_list;
					_tmp537_ = vala_collection_get_size ((ValaCollection*) _tmp536_);
					_tmp538_ = _tmp537_;
					_base_property_size = _tmp538_;
					_base_property_index = -1;
					while (TRUE) {
						gint _tmp539_;
						gint _tmp540_;
						gint _tmp541_;
						ValaProperty* base_property = NULL;
						ValaList* _tmp542_;
						gint _tmp543_;
						gpointer _tmp544_;
						ValaProperty* _tmp545_;
						gboolean _tmp546_;
						gboolean _tmp547_;
						_tmp539_ = _base_property_index;
						_base_property_index = _tmp539_ + 1;
						_tmp540_ = _base_property_index;
						_tmp541_ = _base_property_size;
						if (!(_tmp540_ < _tmp541_)) {
							break;
						}
						_tmp542_ = _base_property_list;
						_tmp543_ = _base_property_index;
						_tmp544_ = vala_list_get (_tmp542_, _tmp543_);
						base_property = (ValaProperty*) _tmp544_;
						_tmp545_ = base_property;
						_tmp546_ = vala_property_get_is_abstract (_tmp545_);
						_tmp547_ = _tmp546_;
						if (_tmp547_) {
							ValaProperty* override_property = NULL;
							ValaProperty* _tmp548_;
							const gchar* _tmp549_;
							const gchar* _tmp550_;
							ValaSymbol* _tmp551_;
							ValaProperty* _tmp552_;
							gboolean _tmp553_ = FALSE;
							ValaProperty* _tmp554_;
							_tmp548_ = base_property;
							_tmp549_ = vala_symbol_get_name ((ValaSymbol*) _tmp548_);
							_tmp550_ = _tmp549_;
							_tmp551_ = vala_semantic_analyzer_symbol_lookup_inherited ((ValaSymbol*) self, _tmp550_);
							_tmp552_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp551_, VALA_TYPE_PROPERTY) ? ((ValaProperty*) _tmp551_) : NULL;
							if (_tmp552_ == NULL) {
								_vala_code_node_unref0 (_tmp551_);
							}
							override_property = _tmp552_;
							_tmp554_ = override_property;
							if (_tmp554_ == NULL) {
								_tmp553_ = TRUE;
							} else {
								ValaProperty* _tmp555_;
								gboolean _tmp556_;
								gboolean _tmp557_;
								_tmp555_ = override_property;
								_tmp556_ = vala_property_get_overrides (_tmp555_);
								_tmp557_ = _tmp556_;
								_tmp553_ = !_tmp557_;
							}
							if (_tmp553_) {
								ValaSourceReference* _tmp558_;
								ValaSourceReference* _tmp559_;
								gchar* _tmp560_;
								gchar* _tmp561_;
								ValaProperty* _tmp562_;
								gchar* _tmp563_;
								gchar* _tmp564_;
								gchar* _tmp565_;
								gchar* _tmp566_;
								vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
								_tmp558_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
								_tmp559_ = _tmp558_;
								_tmp560_ = vala_symbol_get_full_name ((ValaSymbol*) self);
								_tmp561_ = _tmp560_;
								_tmp562_ = base_property;
								_tmp563_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp562_);
								_tmp564_ = _tmp563_;
								_tmp565_ = g_strdup_printf ("`%s' does not implement abstract property `%s'", _tmp561_, _tmp564_);
								_tmp566_ = _tmp565_;
								vala_report_error (_tmp559_, _tmp566_);
								_g_free0 (_tmp566_);
								_g_free0 (_tmp564_);
								_g_free0 (_tmp561_);
							}
							_vala_code_node_unref0 (override_property);
						}
						_vala_code_node_unref0 (base_property);
					}
					_vala_iterable_unref0 (_base_property_list);
				}
				_tmp567_ = base_class;
				_tmp568_ = _tmp567_->priv->_base_class;
				_tmp569_ = _vala_code_node_ref0 (_tmp568_);
				_vala_code_node_unref0 (base_class);
				base_class = _tmp569_;
			}
			_vala_code_node_unref0 (base_class);
		}
	}
	_tmp570_ = vala_code_context_get_analyzer (context);
	_tmp571_ = _tmp570_;
	_tmp572_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp571_, _tmp572_);
	_tmp573_ = vala_code_context_get_analyzer (context);
	_tmp574_ = _tmp573_;
	_tmp575_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp574_, _tmp575_);
	_tmp576_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp577_ = _tmp576_;
	result = !_tmp577_;
	_vala_iterable_unref0 (missing_prereqs);
	_vala_iterable_unref0 (prerequisites);
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaClass*
vala_class_get_base_class (ValaClass* self)
{
	ValaClass* result;
	ValaClass* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_base_class;
	result = _tmp0_;
	return result;
}


void
vala_class_set_base_class (ValaClass* self,
                           ValaClass* value)
{
	ValaClass* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_base_class);
	self->priv->_base_class = _tmp0_;
}


gboolean
vala_class_get_is_abstract (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_class_set_is_abstract (ValaClass* self,
                            gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_class_get_is_compact (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	gboolean* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_compact;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_compact (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_compact);
			self->priv->_is_compact = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_compact;
	if (_tmp10_ == NULL) {
		ValaAttribute* _tmp11_;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp14_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Compact");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_tmp14_ = __bool_dup0 (&_tmp13_);
		_g_free0 (self->priv->_is_compact);
		self->priv->_is_compact = _tmp14_;
		_vala_code_node_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->_is_compact;
	result = *_tmp15_;
	return result;
}


void
vala_class_set_is_compact (ValaClass* self,
                           gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_compact);
	self->priv->_is_compact = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Compact", value, NULL);
}


gboolean
vala_class_get_is_immutable (ValaClass* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp10_;
	gboolean* _tmp15_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_immutable;
	if (_tmp0_ == NULL) {
		ValaClass* _tmp1_;
		_tmp1_ = self->priv->_base_class;
		if (_tmp1_ != NULL) {
			ValaClass* _tmp2_;
			gboolean _tmp3_;
			gboolean _tmp4_;
			gboolean* _tmp5_;
			_tmp2_ = self->priv->_base_class;
			_tmp3_ = vala_class_get_is_immutable (_tmp2_);
			_tmp4_ = _tmp3_;
			_tmp5_ = __bool_dup0 (&_tmp4_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp5_;
		} else {
			ValaAttribute* _tmp6_;
			ValaAttribute* _tmp7_;
			gboolean _tmp8_;
			gboolean* _tmp9_;
			_tmp6_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_ != NULL;
			_tmp9_ = __bool_dup0 (&_tmp8_);
			_g_free0 (self->priv->_is_immutable);
			self->priv->_is_immutable = _tmp9_;
			_vala_code_node_unref0 (_tmp7_);
		}
	}
	_tmp10_ = self->priv->_is_immutable;
	if (_tmp10_ == NULL) {
		ValaAttribute* _tmp11_;
		ValaAttribute* _tmp12_;
		gboolean _tmp13_;
		gboolean* _tmp14_;
		_tmp11_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "Immutable");
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp12_ != NULL;
		_tmp14_ = __bool_dup0 (&_tmp13_);
		_g_free0 (self->priv->_is_immutable);
		self->priv->_is_immutable = _tmp14_;
		_vala_code_node_unref0 (_tmp12_);
	}
	_tmp15_ = self->priv->_is_immutable;
	result = *_tmp15_;
	return result;
}


void
vala_class_set_is_immutable (ValaClass* self,
                             gboolean value)
{
	gboolean* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = __bool_dup0 (&value);
	_g_free0 (self->priv->_is_immutable);
	self->priv->_is_immutable = _tmp0_;
	vala_code_node_set_attribute ((ValaCodeNode*) self, "Immutable", value, NULL);
}


gboolean
vala_class_get_has_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_private_fields;
	result = _tmp0_;
	return result;
}


void
vala_class_set_has_private_fields (ValaClass* self,
                                   gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_private_fields = value;
}


gboolean
vala_class_get_has_class_private_fields (ValaClass* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_has_class_private_fields;
	result = _tmp0_;
	return result;
}


static void
vala_class_set_has_class_private_fields (ValaClass* self,
                                         gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_has_class_private_fields = value;
}


ValaCreationMethod*
vala_class_get_default_construction_method (ValaClass* self)
{
	ValaCreationMethod* result;
	ValaCreationMethod* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_construction_method;
	result = _tmp0_;
	return result;
}


void
vala_class_set_default_construction_method (ValaClass* self,
                                            ValaCreationMethod* value)
{
	ValaCreationMethod* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	self->priv->_default_construction_method = _tmp0_;
}


ValaConstructor*
vala_class_get_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_constructor (ValaClass* self,
                            ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_constructor);
	self->priv->_constructor = _tmp0_;
}


ValaConstructor*
vala_class_get_class_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_constructor (ValaClass* self,
                                  ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	self->priv->_class_constructor = _tmp0_;
}


ValaConstructor*
vala_class_get_static_constructor (ValaClass* self)
{
	ValaConstructor* result;
	ValaConstructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_constructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_constructor (ValaClass* self,
                                   ValaConstructor* value)
{
	ValaConstructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	self->priv->_static_constructor = _tmp0_;
}


ValaDestructor*
vala_class_get_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_destructor (ValaClass* self,
                           ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	ValaDestructor* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_destructor);
	self->priv->_destructor = _tmp0_;
	_tmp1_ = self->priv->_destructor;
	if (_tmp1_ != NULL) {
		ValaDestructor* _tmp2_;
		ValaParameter* _tmp3_;
		ValaParameter* _tmp4_;
		ValaDestructor* _tmp13_;
		ValaObjectType* _tmp14_;
		ValaObjectType* _tmp15_;
		ValaParameter* _tmp16_;
		ValaParameter* _tmp17_;
		ValaDestructor* _tmp18_;
		ValaScope* _tmp19_;
		ValaScope* _tmp20_;
		ValaDestructor* _tmp21_;
		ValaParameter* _tmp22_;
		ValaParameter* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		ValaDestructor* _tmp26_;
		ValaParameter* _tmp27_;
		ValaParameter* _tmp28_;
		_tmp2_ = self->priv->_destructor;
		_tmp3_ = vala_destructor_get_this_parameter (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_ != NULL) {
			ValaDestructor* _tmp5_;
			ValaScope* _tmp6_;
			ValaScope* _tmp7_;
			ValaDestructor* _tmp8_;
			ValaParameter* _tmp9_;
			ValaParameter* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp5_ = self->priv->_destructor;
			_tmp6_ = vala_symbol_get_scope ((ValaSymbol*) _tmp5_);
			_tmp7_ = _tmp6_;
			_tmp8_ = self->priv->_destructor;
			_tmp9_ = vala_destructor_get_this_parameter (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = vala_symbol_get_name ((ValaSymbol*) _tmp10_);
			_tmp12_ = _tmp11_;
			vala_scope_remove (_tmp7_, _tmp12_);
		}
		_tmp13_ = self->priv->_destructor;
		_tmp14_ = vala_object_type_symbol_get_this_type ((ValaObjectTypeSymbol*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = vala_parameter_new ("this", (ValaDataType*) _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		vala_destructor_set_this_parameter (_tmp13_, _tmp17_);
		_vala_code_node_unref0 (_tmp17_);
		_vala_code_node_unref0 (_tmp15_);
		_tmp18_ = self->priv->_destructor;
		_tmp19_ = vala_symbol_get_scope ((ValaSymbol*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->_destructor;
		_tmp22_ = vala_destructor_get_this_parameter (_tmp21_);
		_tmp23_ = _tmp22_;
		_tmp24_ = vala_symbol_get_name ((ValaSymbol*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = self->priv->_destructor;
		_tmp27_ = vala_destructor_get_this_parameter (_tmp26_);
		_tmp28_ = _tmp27_;
		vala_scope_add (_tmp20_, _tmp25_, (ValaSymbol*) _tmp28_);
	}
}


ValaDestructor*
vala_class_get_static_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_static_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_static_destructor (ValaClass* self,
                                  ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	self->priv->_static_destructor = _tmp0_;
}


ValaDestructor*
vala_class_get_class_destructor (ValaClass* self)
{
	ValaDestructor* result;
	ValaDestructor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_class_destructor;
	result = _tmp0_;
	return result;
}


void
vala_class_set_class_destructor (ValaClass* self,
                                 ValaDestructor* value)
{
	ValaDestructor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	self->priv->_class_destructor = _tmp0_;
}


gboolean
vala_class_get_is_error_base (ValaClass* self)
{
	gboolean result;
	ValaAttribute* _tmp0_;
	ValaAttribute* _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = vala_code_node_get_attribute ((ValaCodeNode*) self, "ErrorBase");
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ != NULL;
	_vala_code_node_unref0 (_tmp1_);
	result = _tmp2_;
	return result;
}


static void
vala_class_class_init (ValaClassClass * klass)
{
	vala_class_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_class_finalize;
	g_type_class_add_private (klass, sizeof (ValaClassPrivate));
	((ValaSymbolClass *) klass)->add_field = (void (*) (ValaSymbol *, ValaField*)) vala_class_real_add_field;
	((ValaSymbolClass *) klass)->add_method = (void (*) (ValaSymbol *, ValaMethod*)) vala_class_real_add_method;
	((ValaSymbolClass *) klass)->add_property = (void (*) (ValaSymbol *, ValaProperty*)) vala_class_real_add_property;
	((ValaSymbolClass *) klass)->add_constructor = (void (*) (ValaSymbol *, ValaConstructor*)) vala_class_real_add_constructor;
	((ValaSymbolClass *) klass)->add_destructor = (void (*) (ValaSymbol *, ValaDestructor*)) vala_class_real_add_destructor;
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_class_real_accept_children;
	((ValaTypeSymbolClass *) klass)->is_reference_type = (gboolean (*) (ValaTypeSymbol *)) vala_class_real_is_reference_type;
	((ValaTypeSymbolClass *) klass)->is_subtype_of = (gboolean (*) (ValaTypeSymbol *, ValaTypeSymbol*)) vala_class_real_is_subtype_of;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_class_real_replace_type;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_class_real_check;
}


static void
vala_class_instance_init (ValaClass * self)
{
	GEqualFunc _tmp0_;
	ValaArrayList* _tmp1_;
	self->priv = VALA_CLASS_GET_PRIVATE (self);
	_tmp0_ = g_direct_equal;
	_tmp1_ = vala_array_list_new (VALA_TYPE_DATA_TYPE, (GBoxedCopyFunc) vala_code_node_ref, (GDestroyNotify) vala_code_node_unref, _tmp0_);
	self->priv->base_types = (ValaList*) _tmp1_;
}


static void
vala_class_finalize (ValaCodeNode * obj)
{
	ValaClass * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_CLASS, ValaClass);
	_vala_code_node_unref0 (self->priv->_base_class);
	_g_free0 (self->priv->_is_compact);
	_g_free0 (self->priv->_is_immutable);
	_vala_iterable_unref0 (self->priv->base_types);
	_vala_code_node_unref0 (self->priv->_default_construction_method);
	_vala_code_node_unref0 (self->priv->_constructor);
	_vala_code_node_unref0 (self->priv->_class_constructor);
	_vala_code_node_unref0 (self->priv->_static_constructor);
	_vala_code_node_unref0 (self->priv->_static_destructor);
	_vala_code_node_unref0 (self->priv->_class_destructor);
	_vala_code_node_unref0 (self->priv->_destructor);
	VALA_CODE_NODE_CLASS (vala_class_parent_class)->finalize (obj);
}


/**
 * Represents a class declaration in the source code.
 */
GType
vala_class_get_type (void)
{
	static volatile gsize vala_class_type_id__volatile = 0;
	if (g_once_init_enter (&vala_class_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaClassClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_class_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaClass), 0, (GInstanceInitFunc) vala_class_instance_init, NULL };
		GType vala_class_type_id;
		vala_class_type_id = g_type_register_static (VALA_TYPE_OBJECT_TYPE_SYMBOL, "ValaClass", &g_define_type_info, 0);
		g_once_init_leave (&vala_class_type_id__volatile, vala_class_type_id);
	}
	return vala_class_type_id__volatile;
}



