/* linkhelper.c generated by valac, the Vala compiler
 * generated from linkhelper.vala, do not modify */

/* linkhelper.vala
 *
 * Copyright (C) 2008-2012 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Florian Brosch <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>

enum  {
	VALADOC_HTML_LINK_HELPER_0_PROPERTY,
	VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY,
	VALADOC_HTML_LINK_HELPER_NUM_PROPERTIES
};
static GParamSpec* valadoc_html_link_helper_properties[VALADOC_HTML_LINK_HELPER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ValadocHtmlLinkHelperPrivate {
	gboolean _enable_browsable_check;
};


static gpointer valadoc_html_link_helper_parent_class = NULL;

#define VALADOC_HTML_LINK_HELPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelperPrivate))
static gchar* valadoc_html_link_helper_real_get_package_link (ValadocHtmlLinkHelper* self,
                                                       ValadocApiPackage* package,
                                                       ValadocSettings* settings);
static gchar* valadoc_html_link_helper_real_from_package_to_package (ValadocHtmlLinkHelper* self,
                                                              ValadocApiPackage* from,
                                                              ValadocApiPackage* to);
static gchar* valadoc_html_link_helper_real_from_package_to_wiki (ValadocHtmlLinkHelper* self,
                                                           ValadocApiPackage* from,
                                                           ValadocWikiPage* to);
static gchar* valadoc_html_link_helper_real_from_package_to_node (ValadocHtmlLinkHelper* self,
                                                           ValadocApiPackage* from,
                                                           ValadocApiNode* to);
static gchar* valadoc_html_link_helper_real_from_wiki_to_package (ValadocHtmlLinkHelper* self,
                                                           ValadocWikiPage* from,
                                                           ValadocApiPackage* to);
static gchar* valadoc_html_link_helper_real_from_wiki_to_wiki (ValadocHtmlLinkHelper* self,
                                                        ValadocWikiPage* from,
                                                        ValadocWikiPage* to);
static gchar* valadoc_html_link_helper_real_from_wiki_to_node (ValadocHtmlLinkHelper* self,
                                                        ValadocWikiPage* from,
                                                        ValadocApiNode* to);
static gchar* valadoc_html_link_helper_real_from_node_to_package (ValadocHtmlLinkHelper* self,
                                                           ValadocApiNode* from,
                                                           ValadocApiPackage* to);
static gchar* valadoc_html_link_helper_real_from_node_to_wiki (ValadocHtmlLinkHelper* self,
                                                        ValadocApiNode* from,
                                                        ValadocWikiPage* to);
static gchar* valadoc_html_link_helper_real_from_node_to_node (ValadocHtmlLinkHelper* self,
                                                        ValadocApiNode* from,
                                                        ValadocApiNode* to);
static void valadoc_html_link_helper_finalize (GObject * obj);
static void _vala_valadoc_html_link_helper_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_valadoc_html_link_helper_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);


static gchar*
valadoc_html_link_helper_real_get_package_link (ValadocHtmlLinkHelper* self,
                                                ValadocApiPackage* package,
                                                ValadocSettings* settings)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (package != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		_tmp0_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) package, settings);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp2_ = valadoc_api_node_get_name ((ValadocApiNode*) package);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_build_filename (_tmp3_, "index.htm", NULL);
	result = _tmp4_;
	return result;
}


gchar*
valadoc_html_link_helper_get_package_link (ValadocHtmlLinkHelper* self,
                                           ValadocApiPackage* package,
                                           ValadocSettings* settings)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->get_package_link (self, package, settings);
}


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


gchar*
valadoc_html_link_helper_get_relative_link (ValadocHtmlLinkHelper* self,
                                            ValadocDocumentation* from,
                                            ValadocDocumentation* to,
                                            ValadocSettings* settings)
{
	gchar* result = NULL;
	ValadocSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	g_return_val_if_fail (settings != NULL, NULL);
	_tmp0_ = _g_object_ref0 (settings);
	_g_object_unref0 (self->_settings);
	self->_settings = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (from, VALADOC_API_TYPE_PACKAGE)) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_API_TYPE_PACKAGE)) {
			gchar* _tmp1_;
			_tmp1_ = valadoc_html_link_helper_from_package_to_package (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
			result = _tmp1_;
			return result;
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_API_TYPE_NODE)) {
				gchar* _tmp2_;
				_tmp2_ = valadoc_html_link_helper_from_package_to_node (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_API_TYPE_NODE, ValadocApiNode));
				result = _tmp2_;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_TYPE_WIKI_PAGE)) {
					gchar* _tmp3_;
					_tmp3_ = valadoc_html_link_helper_from_package_to_wiki (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage));
					result = _tmp3_;
					return result;
				} else {
					_vala_assert (TRUE, "true");
				}
			}
		}
	} else {
		if (G_TYPE_CHECK_INSTANCE_TYPE (from, VALADOC_API_TYPE_NODE)) {
			if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_API_TYPE_PACKAGE)) {
				gchar* _tmp4_;
				_tmp4_ = valadoc_html_link_helper_from_node_to_package (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_API_TYPE_NODE, ValadocApiNode), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
				result = _tmp4_;
				return result;
			} else {
				if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_API_TYPE_NODE)) {
					gchar* _tmp5_;
					_tmp5_ = valadoc_html_link_helper_from_node_to_node (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_API_TYPE_NODE, ValadocApiNode), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_API_TYPE_NODE, ValadocApiNode));
					result = _tmp5_;
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_TYPE_WIKI_PAGE)) {
						gchar* _tmp6_;
						_tmp6_ = valadoc_html_link_helper_from_node_to_wiki (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_API_TYPE_NODE, ValadocApiNode), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage));
						result = _tmp6_;
						return result;
					} else {
						_vala_assert (TRUE, "true");
					}
				}
			}
		} else {
			if (G_TYPE_CHECK_INSTANCE_TYPE (from, VALADOC_TYPE_WIKI_PAGE)) {
				if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_API_TYPE_PACKAGE)) {
					gchar* _tmp7_;
					_tmp7_ = valadoc_html_link_helper_from_wiki_to_package (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_API_TYPE_PACKAGE, ValadocApiPackage));
					result = _tmp7_;
					return result;
				} else {
					if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_API_TYPE_NODE)) {
						gchar* _tmp8_;
						_tmp8_ = valadoc_html_link_helper_from_wiki_to_node (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_API_TYPE_NODE, ValadocApiNode));
						result = _tmp8_;
						return result;
					} else {
						if (G_TYPE_CHECK_INSTANCE_TYPE (to, VALADOC_TYPE_WIKI_PAGE)) {
							gchar* _tmp9_;
							_tmp9_ = valadoc_html_link_helper_from_wiki_to_wiki (self, G_TYPE_CHECK_INSTANCE_CAST (from, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage), G_TYPE_CHECK_INSTANCE_CAST (to, VALADOC_TYPE_WIKI_PAGE, ValadocWikiPage));
							result = _tmp9_;
							return result;
						} else {
							_vala_assert (TRUE, "true");
						}
					}
				}
			} else {
				_vala_assert (TRUE, "true");
			}
		}
	}
	result = NULL;
	return result;
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gint
string_last_index_of_char (const gchar* self,
                           gunichar c,
                           gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strrchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch22_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch22_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally22;
	__catch22_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


gchar*
valadoc_html_link_helper_translate_wiki_name (ValadocHtmlLinkHelper* self,
                                              ValadocWikiPage* page)
{
	gchar* result = NULL;
	gchar* name = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (page != NULL, NULL);
	_tmp0_ = valadoc_wiki_page_get_name (page);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup (_tmp1_);
	name = _tmp2_;
	_tmp3_ = string_substring (name, (glong) 0, (glong) string_last_index_of_char (name, (gunichar) '.', 0));
	_tmp4_ = _tmp3_;
	_tmp5_ = string_replace (_tmp4_, "/", ".");
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_tmp6_, ".htm", NULL);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	result = _tmp8_;
	_g_free0 (name);
	return result;
}


static gchar*
valadoc_html_link_helper_real_from_package_to_package (ValadocHtmlLinkHelper* self,
                                                       ValadocApiPackage* from,
                                                       ValadocApiPackage* to)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocSettings* _tmp2_;
		_tmp2_ = self->_settings;
		_tmp0_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) to, _tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	if (from == to) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("#");
		result = _tmp3_;
		return result;
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = valadoc_api_node_get_name ((ValadocApiNode*) to);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_build_filename ("..", _tmp5_, "index.htm", NULL);
		result = _tmp6_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_package_to_package (ValadocHtmlLinkHelper* self,
                                                  ValadocApiPackage* from,
                                                  ValadocApiPackage* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_package_to_package (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_package_to_wiki (ValadocHtmlLinkHelper* self,
                                                    ValadocApiPackage* from,
                                                    ValadocWikiPage* to)
{
	gchar* result = NULL;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp0_ = valadoc_api_package_get_is_package (from);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		ValadocSettings* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp2_ = self->_settings;
		_tmp3_ = _tmp2_->pkg_name;
		_tmp4_ = valadoc_html_link_helper_translate_wiki_name (self, to);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_build_filename ("..", _tmp3_, _tmp5_, NULL);
		_tmp7_ = _tmp6_;
		_g_free0 (_tmp5_);
		result = _tmp7_;
		return result;
	} else {
		gchar* _tmp8_;
		_tmp8_ = valadoc_html_link_helper_translate_wiki_name (self, to);
		result = _tmp8_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_package_to_wiki (ValadocHtmlLinkHelper* self,
                                               ValadocApiPackage* from,
                                               ValadocWikiPage* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_package_to_wiki (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_package_to_node (ValadocHtmlLinkHelper* self,
                                                    ValadocApiPackage* from,
                                                    ValadocApiNode* to)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp7_;
	ValadocApiPackage* _tmp8_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		ValadocSettings* _tmp3_;
		_tmp3_ = self->_settings;
		if (!valadoc_api_node_is_browsable (to, _tmp3_)) {
			_tmp2_ = TRUE;
		} else {
			ValadocApiPackage* _tmp4_;
			ValadocApiPackage* _tmp5_;
			ValadocSettings* _tmp6_;
			_tmp4_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->_settings;
			_tmp2_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp5_, _tmp6_);
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp7_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
	_tmp8_ = _tmp7_;
	if (from == _tmp8_) {
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp9_ = valadoc_api_node_get_full_name (to);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp10_, ".html", NULL);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_build_filename (_tmp12_, NULL);
		_tmp14_ = _tmp13_;
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		result = _tmp14_;
		return result;
	} else {
		ValadocApiPackage* _tmp15_;
		ValadocApiPackage* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp15_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
		_tmp16_ = _tmp15_;
		_tmp17_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = valadoc_api_node_get_full_name (to);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, ".html", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_build_filename ("..", _tmp18_, _tmp22_, NULL);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		result = _tmp24_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_package_to_node (ValadocHtmlLinkHelper* self,
                                               ValadocApiPackage* from,
                                               ValadocApiNode* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_package_to_node (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_wiki_to_package (ValadocHtmlLinkHelper* self,
                                                    ValadocWikiPage* from,
                                                    ValadocApiPackage* to)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocSettings* _tmp2_;
		_tmp2_ = self->_settings;
		_tmp0_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) to, _tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_api_package_get_is_package (to);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = valadoc_api_node_get_name ((ValadocApiNode*) to);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_build_filename ("..", _tmp6_, "index.htm", NULL);
		result = _tmp7_;
		return result;
	} else {
		gchar* _tmp8_;
		_tmp8_ = g_strdup ("index.htm");
		result = _tmp8_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_wiki_to_package (ValadocHtmlLinkHelper* self,
                                               ValadocWikiPage* from,
                                               ValadocApiPackage* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_wiki_to_package (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_wiki_to_wiki (ValadocHtmlLinkHelper* self,
                                                 ValadocWikiPage* from,
                                                 ValadocWikiPage* to)
{
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp0_ = valadoc_html_link_helper_translate_wiki_name (self, to);
	result = _tmp0_;
	return result;
}


gchar*
valadoc_html_link_helper_from_wiki_to_wiki (ValadocHtmlLinkHelper* self,
                                            ValadocWikiPage* from,
                                            ValadocWikiPage* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_wiki_to_wiki (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_wiki_to_node (ValadocHtmlLinkHelper* self,
                                                 ValadocWikiPage* from,
                                                 ValadocApiNode* to)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp7_;
	ValadocApiPackage* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		ValadocSettings* _tmp3_;
		_tmp3_ = self->_settings;
		if (!valadoc_api_node_is_browsable (to, _tmp3_)) {
			_tmp2_ = TRUE;
		} else {
			ValadocApiPackage* _tmp4_;
			ValadocApiPackage* _tmp5_;
			ValadocSettings* _tmp6_;
			_tmp4_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->_settings;
			_tmp2_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp5_, _tmp6_);
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp7_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_api_package_get_is_package (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		ValadocApiPackage* _tmp11_;
		ValadocApiPackage* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp11_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
		_tmp12_ = _tmp11_;
		_tmp13_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = valadoc_api_node_get_full_name (to);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, ".html", NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_build_filename ("..", _tmp14_, _tmp18_, NULL);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		result = _tmp20_;
		return result;
	} else {
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp21_ = valadoc_api_node_get_full_name (to);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, ".html", NULL);
		_tmp24_ = _tmp23_;
		_g_free0 (_tmp22_);
		result = _tmp24_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_wiki_to_node (ValadocHtmlLinkHelper* self,
                                            ValadocWikiPage* from,
                                            ValadocApiNode* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_wiki_to_node (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_node_to_package (ValadocHtmlLinkHelper* self,
                                                    ValadocApiNode* from,
                                                    ValadocApiPackage* to)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp3_;
	ValadocApiPackage* _tmp4_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		ValadocSettings* _tmp2_;
		_tmp2_ = self->_settings;
		_tmp0_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) to, _tmp2_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp3_ = valadoc_documentation_get_package ((ValadocDocumentation*) from);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == to) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("index.htm");
		result = _tmp5_;
		return result;
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = valadoc_api_node_get_name ((ValadocApiNode*) to);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename ("..", _tmp7_, "index.htm", NULL);
		result = _tmp8_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_node_to_package (ValadocHtmlLinkHelper* self,
                                               ValadocApiNode* from,
                                               ValadocApiPackage* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_node_to_package (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_node_to_wiki (ValadocHtmlLinkHelper* self,
                                                 ValadocApiNode* from,
                                                 ValadocWikiPage* to)
{
	gchar* result = NULL;
	ValadocApiPackage* _tmp0_;
	ValadocApiPackage* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp0_ = valadoc_documentation_get_package ((ValadocDocumentation*) from);
	_tmp1_ = _tmp0_;
	_tmp2_ = valadoc_api_package_get_is_package (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		ValadocSettings* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp4_ = self->_settings;
		_tmp5_ = _tmp4_->pkg_name;
		_tmp6_ = valadoc_html_link_helper_translate_wiki_name (self, to);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_build_filename ("..", _tmp5_, _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		result = _tmp9_;
		return result;
	} else {
		gchar* _tmp10_;
		_tmp10_ = valadoc_html_link_helper_translate_wiki_name (self, to);
		result = _tmp10_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_node_to_wiki (ValadocHtmlLinkHelper* self,
                                            ValadocApiNode* from,
                                            ValadocWikiPage* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_node_to_wiki (self, from, to);
}


static gchar*
valadoc_html_link_helper_real_from_node_to_node (ValadocHtmlLinkHelper* self,
                                                 ValadocApiNode* from,
                                                 ValadocApiNode* to)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	ValadocApiPackage* _tmp7_;
	ValadocApiPackage* _tmp8_;
	ValadocApiPackage* _tmp9_;
	ValadocApiPackage* _tmp10_;
	g_return_val_if_fail (from != NULL, NULL);
	g_return_val_if_fail (to != NULL, NULL);
	_tmp1_ = self->priv->_enable_browsable_check;
	if (_tmp1_) {
		gboolean _tmp2_ = FALSE;
		ValadocSettings* _tmp3_;
		_tmp3_ = self->_settings;
		if (!valadoc_api_node_is_browsable (to, _tmp3_)) {
			_tmp2_ = TRUE;
		} else {
			ValadocApiPackage* _tmp4_;
			ValadocApiPackage* _tmp5_;
			ValadocSettings* _tmp6_;
			_tmp4_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
			_tmp5_ = _tmp4_;
			_tmp6_ = self->_settings;
			_tmp2_ = !valadoc_api_node_is_browsable ((ValadocApiNode*) _tmp5_, _tmp6_);
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp7_ = valadoc_documentation_get_package ((ValadocDocumentation*) from);
	_tmp8_ = _tmp7_;
	_tmp9_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
	_tmp10_ = _tmp9_;
	if (_tmp8_ == _tmp10_) {
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp11_ = valadoc_api_node_get_full_name (to);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strconcat (_tmp12_, ".html", NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_build_filename (_tmp14_, NULL);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		_g_free0 (_tmp12_);
		result = _tmp16_;
		return result;
	} else {
		ValadocApiPackage* _tmp17_;
		ValadocApiPackage* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		_tmp17_ = valadoc_documentation_get_package ((ValadocDocumentation*) to);
		_tmp18_ = _tmp17_;
		_tmp19_ = valadoc_api_node_get_name ((ValadocApiNode*) _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = valadoc_api_node_get_full_name (to);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strconcat (_tmp22_, ".html", NULL);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_build_filename ("..", _tmp20_, _tmp24_, NULL);
		_tmp26_ = _tmp25_;
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
		result = _tmp26_;
		return result;
	}
}


gchar*
valadoc_html_link_helper_from_node_to_node (ValadocHtmlLinkHelper* self,
                                            ValadocApiNode* from,
                                            ValadocApiNode* to)
{
	g_return_val_if_fail (self != NULL, NULL);
	return VALADOC_HTML_LINK_HELPER_GET_CLASS (self)->from_node_to_node (self, from, to);
}


ValadocHtmlLinkHelper*
valadoc_html_link_helper_construct (GType object_type)
{
	ValadocHtmlLinkHelper * self = NULL;
	self = (ValadocHtmlLinkHelper*) g_object_new (object_type, NULL);
	return self;
}


ValadocHtmlLinkHelper*
valadoc_html_link_helper_new (void)
{
	return valadoc_html_link_helper_construct (VALADOC_HTML_TYPE_LINK_HELPER);
}


gboolean
valadoc_html_link_helper_get_enable_browsable_check (ValadocHtmlLinkHelper* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_browsable_check;
	result = _tmp0_;
	return result;
}


void
valadoc_html_link_helper_set_enable_browsable_check (ValadocHtmlLinkHelper* self,
                                                     gboolean value)
{
	g_return_if_fail (self != NULL);
	if (valadoc_html_link_helper_get_enable_browsable_check (self) != value) {
		self->priv->_enable_browsable_check = value;
		g_object_notify_by_pspec ((GObject *) self, valadoc_html_link_helper_properties[VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY]);
	}
}


static void
valadoc_html_link_helper_class_init (ValadocHtmlLinkHelperClass * klass)
{
	valadoc_html_link_helper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ValadocHtmlLinkHelperPrivate));
	((ValadocHtmlLinkHelperClass *) klass)->get_package_link = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocSettings*)) valadoc_html_link_helper_real_get_package_link;
	((ValadocHtmlLinkHelperClass *) klass)->from_package_to_package = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocApiPackage*)) valadoc_html_link_helper_real_from_package_to_package;
	((ValadocHtmlLinkHelperClass *) klass)->from_package_to_wiki = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocWikiPage*)) valadoc_html_link_helper_real_from_package_to_wiki;
	((ValadocHtmlLinkHelperClass *) klass)->from_package_to_node = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiPackage*, ValadocApiNode*)) valadoc_html_link_helper_real_from_package_to_node;
	((ValadocHtmlLinkHelperClass *) klass)->from_wiki_to_package = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocWikiPage*, ValadocApiPackage*)) valadoc_html_link_helper_real_from_wiki_to_package;
	((ValadocHtmlLinkHelperClass *) klass)->from_wiki_to_wiki = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocWikiPage*, ValadocWikiPage*)) valadoc_html_link_helper_real_from_wiki_to_wiki;
	((ValadocHtmlLinkHelperClass *) klass)->from_wiki_to_node = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocWikiPage*, ValadocApiNode*)) valadoc_html_link_helper_real_from_wiki_to_node;
	((ValadocHtmlLinkHelperClass *) klass)->from_node_to_package = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiNode*, ValadocApiPackage*)) valadoc_html_link_helper_real_from_node_to_package;
	((ValadocHtmlLinkHelperClass *) klass)->from_node_to_wiki = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiNode*, ValadocWikiPage*)) valadoc_html_link_helper_real_from_node_to_wiki;
	((ValadocHtmlLinkHelperClass *) klass)->from_node_to_node = (gchar* (*) (ValadocHtmlLinkHelper *, ValadocApiNode*, ValadocApiNode*)) valadoc_html_link_helper_real_from_node_to_node;
	G_OBJECT_CLASS (klass)->get_property = _vala_valadoc_html_link_helper_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_valadoc_html_link_helper_set_property;
	G_OBJECT_CLASS (klass)->finalize = valadoc_html_link_helper_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY, valadoc_html_link_helper_properties[VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY] = g_param_spec_boolean ("enable-browsable-check", "enable-browsable-check", "enable-browsable-check", TRUE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void
valadoc_html_link_helper_instance_init (ValadocHtmlLinkHelper * self)
{
	self->priv = VALADOC_HTML_LINK_HELPER_GET_PRIVATE (self);
	self->_settings = NULL;
	self->priv->_enable_browsable_check = TRUE;
}


static void
valadoc_html_link_helper_finalize (GObject * obj)
{
	ValadocHtmlLinkHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelper);
	_g_object_unref0 (self->_settings);
	G_OBJECT_CLASS (valadoc_html_link_helper_parent_class)->finalize (obj);
}


GType
valadoc_html_link_helper_get_type (void)
{
	static volatile gsize valadoc_html_link_helper_type_id__volatile = 0;
	if (g_once_init_enter (&valadoc_html_link_helper_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValadocHtmlLinkHelperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) valadoc_html_link_helper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValadocHtmlLinkHelper), 0, (GInstanceInitFunc) valadoc_html_link_helper_instance_init, NULL };
		GType valadoc_html_link_helper_type_id;
		valadoc_html_link_helper_type_id = g_type_register_static (G_TYPE_OBJECT, "ValadocHtmlLinkHelper", &g_define_type_info, 0);
		g_once_init_leave (&valadoc_html_link_helper_type_id__volatile, valadoc_html_link_helper_type_id);
	}
	return valadoc_html_link_helper_type_id__volatile;
}


static void
_vala_valadoc_html_link_helper_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	ValadocHtmlLinkHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelper);
	switch (property_id) {
		case VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY:
		g_value_set_boolean (value, valadoc_html_link_helper_get_enable_browsable_check (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_valadoc_html_link_helper_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	ValadocHtmlLinkHelper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, VALADOC_HTML_TYPE_LINK_HELPER, ValadocHtmlLinkHelper);
	switch (property_id) {
		case VALADOC_HTML_LINK_HELPER_ENABLE_BROWSABLE_CHECK_PROPERTY:
		valadoc_html_link_helper_set_enable_browsable_check (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



