/* valareport.c generated by valac, the Vala compiler
 * generated from valareport.vala, do not modify */

/* valareport.vala
 *
 * Copyright (C) 2006-2010  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <gmodule.h>
#include <gobject/gvaluecollector.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_code_context_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_context_unref (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef struct _ValaParamSpecReport ValaParamSpecReport;

struct _ValaReportPrivate {
	gchar* locus_color_start;
	const gchar* locus_color_end;
	gchar* warning_color_start;
	const gchar* warning_color_end;
	gchar* error_color_start;
	const gchar* error_color_end;
	gchar* note_color_start;
	const gchar* note_color_end;
	gchar* caret_color_start;
	const gchar* caret_color_end;
	gchar* quote_color_start;
	const gchar* quote_color_end;
	gboolean verbose_errors;
	gboolean _enable_warnings;
};

typedef gint (*ValaReportAttyFunc) (gint fd);
struct _ValaParamSpecReport {
	GParamSpec parent_instance;
};


static gpointer vala_report_parent_class = NULL;
static GRegex* vala_report_val_regex;
static GRegex* vala_report_val_regex = NULL;

#define VALA_REPORT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_REPORT, ValaReportPrivate))
#define VALA_REPORT_ANSI_COLOR_END "\x1b[0m"
static gboolean vala_report_is_atty (ValaReport* self,
                              gint fd);
static void vala_report_report_source (ValaReport* self,
                                ValaSourceReference* source);
static void vala_report_print_highlighted_message (ValaReport* self,
                                            const gchar* message);
static void vala_report_print_message (ValaReport* self,
                                ValaSourceReference* source,
                                const gchar* type,
                                const gchar* type_color_start,
                                const gchar* type_color_end,
                                const gchar* message,
                                gboolean do_report_source);
static void vala_report_real_note (ValaReport* self,
                            ValaSourceReference* source,
                            const gchar* message);
static void vala_report_real_depr (ValaReport* self,
                            ValaSourceReference* source,
                            const gchar* message);
static void vala_report_real_warn (ValaReport* self,
                            ValaSourceReference* source,
                            const gchar* message);
static void vala_report_real_err (ValaReport* self,
                           ValaSourceReference* source,
                           const gchar* message);
static void vala_report_finalize (ValaReport * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType
vala_report_colored_get_type (void)
{
	static volatile gsize vala_report_colored_type_id__volatile = 0;
	if (g_once_init_enter (&vala_report_colored_type_id__volatile)) {
		static const GEnumValue values[] = {{VALA_REPORT_COLORED_AUTO, "VALA_REPORT_COLORED_AUTO", "auto"}, {VALA_REPORT_COLORED_NEVER, "VALA_REPORT_COLORED_NEVER", "never"}, {VALA_REPORT_COLORED_ALWAYS, "VALA_REPORT_COLORED_ALWAYS", "always"}, {0, NULL, NULL}};
		GType vala_report_colored_type_id;
		vala_report_colored_type_id = g_enum_register_static ("ValaReportColored", values);
		g_once_init_leave (&vala_report_colored_type_id__volatile, vala_report_colored_type_id);
	}
	return vala_report_colored_type_id__volatile;
}


/**
 * Set all colors by string
 *
 * {{{
 *   "error=01;31:warning=01;35:note=01;36:caret=01;32:locus=01:quote=01"
 * }}}
 */
gboolean
vala_report_set_colors (ValaReport* self,
                        const gchar* str,
                        ValaReportColored colored_output)
{
	gboolean result = FALSE;
	gchar* error_color = NULL;
	gchar* warning_color = NULL;
	gchar* note_color = NULL;
	gchar* caret_color = NULL;
	gchar* locus_color = NULL;
	gchar* quote_color = NULL;
	gchar** fragments = NULL;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint fragments_length1;
	gint _fragments_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gboolean _tmp38_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (str != NULL, FALSE);
	{
		GRegex* _tmp0_;
		_tmp0_ = vala_report_val_regex;
		if (_tmp0_ == NULL) {
			GRegex* _tmp1_ = NULL;
			GRegex* _tmp2_;
			GRegex* _tmp4_;
			_tmp2_ = g_regex_new ("^\\s*[0-9]+(;[0-9]*)*\\s*$", 0, 0, &_inner_error_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp3_ = FALSE;
				if (_inner_error_->domain == G_REGEX_ERROR) {
					goto __catch17_g_regex_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp3_;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_regex_unref0 (vala_report_val_regex);
			vala_report_val_regex = _tmp4_;
			_g_regex_unref0 (_tmp1_);
		}
	}
	goto __finally17;
	__catch17_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp5_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp5_;
	}
	error_color = NULL;
	warning_color = NULL;
	note_color = NULL;
	caret_color = NULL;
	locus_color = NULL;
	quote_color = NULL;
	_tmp7_ = _tmp6_ = g_strsplit (str, ":", 0);
	fragments = _tmp7_;
	fragments_length1 = _vala_array_length (_tmp6_);
	_fragments_size_ = fragments_length1;
	_tmp8_ = fragments;
	_tmp8__length1 = fragments_length1;
	{
		gchar** fragment_collection = NULL;
		gint fragment_collection_length1 = 0;
		gint _fragment_collection_size_ = 0;
		gint fragment_it = 0;
		fragment_collection = _tmp8_;
		fragment_collection_length1 = _tmp8__length1;
		for (fragment_it = 0; fragment_it < _tmp8__length1; fragment_it = fragment_it + 1) {
			const gchar* fragment = NULL;
			fragment = fragment_collection[fragment_it];
			{
				gchar** eq = NULL;
				const gchar* _tmp9_;
				gchar** _tmp10_;
				gchar** _tmp11_;
				gint eq_length1;
				gint _eq_size_;
				gchar** _tmp12_;
				gint _tmp12__length1;
				GRegex* _tmp13_;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gboolean _tmp16_;
				const gchar* checked_value = NULL;
				gchar** _tmp17_;
				gint _tmp17__length1;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				gchar** _tmp20_;
				gint _tmp20__length1;
				const gchar* _tmp21_;
				const gchar* _tmp22_;
				const gchar* _tmp23_;
				GQuark _tmp25_ = 0U;
				static GQuark _tmp24_label0 = 0;
				static GQuark _tmp24_label1 = 0;
				static GQuark _tmp24_label2 = 0;
				static GQuark _tmp24_label3 = 0;
				static GQuark _tmp24_label4 = 0;
				static GQuark _tmp24_label5 = 0;
				_tmp9_ = fragment;
				_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, "=", 2);
				eq = _tmp11_;
				eq_length1 = _vala_array_length (_tmp10_);
				_eq_size_ = eq_length1;
				_tmp12_ = eq;
				_tmp12__length1 = eq_length1;
				if (_tmp12__length1 != 2) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					return result;
				}
				_tmp13_ = vala_report_val_regex;
				_tmp14_ = eq;
				_tmp14__length1 = eq_length1;
				_tmp15_ = _tmp14_[1];
				_tmp16_ = g_regex_match (_tmp13_, _tmp15_, 0, NULL);
				if (!_tmp16_) {
					result = FALSE;
					eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
					fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (quote_color);
					_g_free0 (locus_color);
					_g_free0 (caret_color);
					_g_free0 (note_color);
					_g_free0 (warning_color);
					_g_free0 (error_color);
					return result;
				}
				_tmp17_ = eq;
				_tmp17__length1 = eq_length1;
				_tmp18_ = _tmp17_[1];
				_tmp19_ = g_strstrip (_tmp18_);
				checked_value = _tmp19_;
				_tmp20_ = eq;
				_tmp20__length1 = eq_length1;
				_tmp21_ = _tmp20_[0];
				_tmp22_ = g_strstrip (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp25_ = (NULL == _tmp23_) ? 0 : g_quark_from_string (_tmp23_);
				if (_tmp25_ == ((0 != _tmp24_label0) ? _tmp24_label0 : (_tmp24_label0 = g_quark_from_static_string ("error")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp26_;
							gchar* _tmp27_;
							_tmp26_ = checked_value;
							_tmp27_ = g_strdup (_tmp26_);
							_g_free0 (error_color);
							error_color = _tmp27_;
							break;
						}
					}
				} else if (_tmp25_ == ((0 != _tmp24_label1) ? _tmp24_label1 : (_tmp24_label1 = g_quark_from_static_string ("warning")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp28_;
							gchar* _tmp29_;
							_tmp28_ = checked_value;
							_tmp29_ = g_strdup (_tmp28_);
							_g_free0 (warning_color);
							warning_color = _tmp29_;
							break;
						}
					}
				} else if (_tmp25_ == ((0 != _tmp24_label2) ? _tmp24_label2 : (_tmp24_label2 = g_quark_from_static_string ("note")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp30_;
							gchar* _tmp31_;
							_tmp30_ = checked_value;
							_tmp31_ = g_strdup (_tmp30_);
							_g_free0 (note_color);
							note_color = _tmp31_;
							break;
						}
					}
				} else if (_tmp25_ == ((0 != _tmp24_label3) ? _tmp24_label3 : (_tmp24_label3 = g_quark_from_static_string ("caret")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp32_;
							gchar* _tmp33_;
							_tmp32_ = checked_value;
							_tmp33_ = g_strdup (_tmp32_);
							_g_free0 (caret_color);
							caret_color = _tmp33_;
							break;
						}
					}
				} else if (_tmp25_ == ((0 != _tmp24_label4) ? _tmp24_label4 : (_tmp24_label4 = g_quark_from_static_string ("locus")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp34_;
							gchar* _tmp35_;
							_tmp34_ = checked_value;
							_tmp35_ = g_strdup (_tmp34_);
							_g_free0 (locus_color);
							locus_color = _tmp35_;
							break;
						}
					}
				} else if (_tmp25_ == ((0 != _tmp24_label5) ? _tmp24_label5 : (_tmp24_label5 = g_quark_from_static_string ("quote")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp36_;
							gchar* _tmp37_;
							_tmp36_ = checked_value;
							_tmp37_ = g_strdup (_tmp36_);
							_g_free0 (quote_color);
							quote_color = _tmp37_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							result = FALSE;
							eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
							fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
							_g_free0 (quote_color);
							_g_free0 (locus_color);
							_g_free0 (caret_color);
							_g_free0 (note_color);
							_g_free0 (warning_color);
							_g_free0 (error_color);
							return result;
						}
					}
				}
				eq = (_vala_array_free (eq, eq_length1, (GDestroyNotify) g_free), NULL);
			}
		}
	}
	if (colored_output == VALA_REPORT_COLORED_ALWAYS) {
		_tmp38_ = TRUE;
	} else {
		gboolean _tmp39_ = FALSE;
		if (colored_output == VALA_REPORT_COLORED_AUTO) {
			FILE* _tmp40_;
			_tmp40_ = stderr;
			_tmp39_ = vala_report_is_atty (self, fileno (_tmp40_));
		} else {
			_tmp39_ = FALSE;
		}
		_tmp38_ = _tmp39_;
	}
	if (_tmp38_) {
		const gchar* _tmp41_;
		const gchar* _tmp46_;
		const gchar* _tmp51_;
		const gchar* _tmp56_;
		const gchar* _tmp61_;
		const gchar* _tmp66_;
		_tmp41_ = error_color;
		if (_tmp41_ != NULL) {
			const gchar* _tmp42_;
			gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp42_ = error_color;
			_tmp43_ = g_strconcat ("\x1b[0", _tmp42_, NULL);
			_tmp44_ = _tmp43_;
			_tmp45_ = g_strconcat (_tmp44_, "m", NULL);
			_g_free0 (self->priv->error_color_start);
			self->priv->error_color_start = _tmp45_;
			_g_free0 (_tmp44_);
			self->priv->error_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp46_ = warning_color;
		if (_tmp46_ != NULL) {
			const gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			_tmp47_ = warning_color;
			_tmp48_ = g_strconcat ("\x1b[0", _tmp47_, NULL);
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strconcat (_tmp49_, "m", NULL);
			_g_free0 (self->priv->warning_color_start);
			self->priv->warning_color_start = _tmp50_;
			_g_free0 (_tmp49_);
			self->priv->warning_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp51_ = note_color;
		if (_tmp51_ != NULL) {
			const gchar* _tmp52_;
			gchar* _tmp53_;
			gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp52_ = note_color;
			_tmp53_ = g_strconcat ("\x1b[0", _tmp52_, NULL);
			_tmp54_ = _tmp53_;
			_tmp55_ = g_strconcat (_tmp54_, "m", NULL);
			_g_free0 (self->priv->note_color_start);
			self->priv->note_color_start = _tmp55_;
			_g_free0 (_tmp54_);
			self->priv->note_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp56_ = caret_color;
		if (_tmp56_ != NULL) {
			const gchar* _tmp57_;
			gchar* _tmp58_;
			gchar* _tmp59_;
			gchar* _tmp60_;
			_tmp57_ = caret_color;
			_tmp58_ = g_strconcat ("\x1b[0", _tmp57_, NULL);
			_tmp59_ = _tmp58_;
			_tmp60_ = g_strconcat (_tmp59_, "m", NULL);
			_g_free0 (self->priv->caret_color_start);
			self->priv->caret_color_start = _tmp60_;
			_g_free0 (_tmp59_);
			self->priv->caret_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp61_ = locus_color;
		if (_tmp61_ != NULL) {
			const gchar* _tmp62_;
			gchar* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			_tmp62_ = locus_color;
			_tmp63_ = g_strconcat ("\x1b[0", _tmp62_, NULL);
			_tmp64_ = _tmp63_;
			_tmp65_ = g_strconcat (_tmp64_, "m", NULL);
			_g_free0 (self->priv->locus_color_start);
			self->priv->locus_color_start = _tmp65_;
			_g_free0 (_tmp64_);
			self->priv->locus_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
		_tmp66_ = quote_color;
		if (_tmp66_ != NULL) {
			const gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			gchar* _tmp70_;
			_tmp67_ = quote_color;
			_tmp68_ = g_strconcat ("\x1b[0", _tmp67_, NULL);
			_tmp69_ = _tmp68_;
			_tmp70_ = g_strconcat (_tmp69_, "m", NULL);
			_g_free0 (self->priv->quote_color_start);
			self->priv->quote_color_start = _tmp70_;
			_g_free0 (_tmp69_);
			self->priv->quote_color_end = VALA_REPORT_ANSI_COLOR_END;
		}
	}
	result = TRUE;
	fragments = (_vala_array_free (fragments, fragments_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (quote_color);
	_g_free0 (locus_color);
	_g_free0 (caret_color);
	_g_free0 (note_color);
	_g_free0 (warning_color);
	_g_free0 (error_color);
	return result;
}


/**
 * Set the error verbosity.
 */
void
vala_report_set_verbose_errors (ValaReport* self,
                                gboolean verbose)
{
	g_return_if_fail (self != NULL);
	self->priv->verbose_errors = verbose;
}


/**
 * Returns the total number of warnings reported.
 */
gint
vala_report_get_warnings (ValaReport* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->warnings;
	result = _tmp0_;
	return result;
}


/**
 * Returns the total number of errors reported.
 */
gint
vala_report_get_errors (ValaReport* self)
{
	gint result = 0;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->errors;
	result = _tmp0_;
	return result;
}


/**
 * Pretty-print the actual line of offending code if possible.
 */
static gchar
string_get (const gchar* self,
            glong index)
{
	gchar result = '\0';
	gchar _tmp0_;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}


static void
vala_report_report_source (ValaReport* self,
                           ValaSourceReference* source)
{
	ValaSourceLocation _tmp0_ = {0};
	ValaSourceLocation _tmp1_;
	gint _tmp2_;
	ValaSourceLocation _tmp3_ = {0};
	ValaSourceLocation _tmp4_;
	gint _tmp5_;
	gchar* offending_line = NULL;
	ValaSourceFile* _tmp6_;
	ValaSourceFile* _tmp7_;
	ValaSourceLocation _tmp8_ = {0};
	ValaSourceLocation _tmp9_;
	gint _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	vala_source_reference_get_begin (source, &_tmp0_);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_.line;
	vala_source_reference_get_end (source, &_tmp3_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_.line;
	if (_tmp2_ != _tmp5_) {
		return;
	}
	_tmp6_ = vala_source_reference_get_file (source);
	_tmp7_ = _tmp6_;
	vala_source_reference_get_begin (source, &_tmp8_);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_.line;
	_tmp11_ = vala_source_file_get_source_line (_tmp7_, _tmp10_);
	offending_line = _tmp11_;
	_tmp12_ = offending_line;
	if (_tmp12_ != NULL) {
		FILE* _tmp13_;
		const gchar* _tmp14_;
		gint idx = 0;
		FILE* _tmp25_;
		const gchar* _tmp26_;
		FILE* _tmp40_;
		const gchar* _tmp41_;
		FILE* _tmp42_;
		_tmp13_ = stderr;
		_tmp14_ = offending_line;
		fprintf (_tmp13_, "%s\n", _tmp14_);
		{
			gboolean _tmp15_ = FALSE;
			idx = 1;
			_tmp15_ = TRUE;
			while (TRUE) {
				gint _tmp17_;
				ValaSourceLocation _tmp18_ = {0};
				ValaSourceLocation _tmp19_;
				gint _tmp20_;
				const gchar* _tmp21_;
				gint _tmp22_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = idx;
					idx = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = idx;
				vala_source_reference_get_begin (source, &_tmp18_);
				_tmp19_ = _tmp18_;
				_tmp20_ = _tmp19_.column;
				if (!(_tmp17_ < _tmp20_)) {
					break;
				}
				_tmp21_ = offending_line;
				_tmp22_ = idx;
				if (string_get (_tmp21_, (glong) (_tmp22_ - 1)) == '\t') {
					FILE* _tmp23_;
					_tmp23_ = stderr;
					fprintf (_tmp23_, "\t");
				} else {
					FILE* _tmp24_;
					_tmp24_ = stderr;
					fprintf (_tmp24_, " ");
				}
			}
		}
		_tmp25_ = stderr;
		_tmp26_ = self->priv->caret_color_start;
		fputs (_tmp26_, _tmp25_);
		{
			ValaSourceLocation _tmp27_ = {0};
			ValaSourceLocation _tmp28_;
			gint _tmp29_;
			gboolean _tmp30_ = FALSE;
			vala_source_reference_get_begin (source, &_tmp27_);
			_tmp28_ = _tmp27_;
			_tmp29_ = _tmp28_.column;
			idx = _tmp29_;
			_tmp30_ = TRUE;
			while (TRUE) {
				gint _tmp32_;
				ValaSourceLocation _tmp33_ = {0};
				ValaSourceLocation _tmp34_;
				gint _tmp35_;
				const gchar* _tmp36_;
				gint _tmp37_;
				if (!_tmp30_) {
					gint _tmp31_;
					_tmp31_ = idx;
					idx = _tmp31_ + 1;
				}
				_tmp30_ = FALSE;
				_tmp32_ = idx;
				vala_source_reference_get_end (source, &_tmp33_);
				_tmp34_ = _tmp33_;
				_tmp35_ = _tmp34_.column;
				if (!(_tmp32_ <= _tmp35_)) {
					break;
				}
				_tmp36_ = offending_line;
				_tmp37_ = idx;
				if (string_get (_tmp36_, (glong) (_tmp37_ - 1)) == '\t') {
					FILE* _tmp38_;
					_tmp38_ = stderr;
					fprintf (_tmp38_, "\t");
				} else {
					FILE* _tmp39_;
					_tmp39_ = stderr;
					fprintf (_tmp39_, "^");
				}
			}
		}
		_tmp40_ = stderr;
		_tmp41_ = self->priv->caret_color_end;
		fputs (_tmp41_, _tmp40_);
		_tmp42_ = stderr;
		fprintf (_tmp42_, "\n");
	}
	_g_free0 (offending_line);
}


static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gint
string_index_of_char (const gchar* self,
                      gunichar c,
                      gint start_index)
{
	gint result = 0;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = g_utf8_strchr (((gchar*) self) + start_index, (gssize) -1, c);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}


static const gchar*
string_offset (const gchar* self,
               glong offset)
{
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = (const gchar*) (((gchar*) self) + offset);
	return result;
}


static void
vala_report_print_highlighted_message (ValaReport* self,
                                       const gchar* message)
{
	gint start = 0;
	gint cur = 0;
	FILE* _tmp38_;
	gint _tmp39_;
	const gchar* _tmp40_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	start = 0;
	cur = 0;
	while (TRUE) {
		gint _tmp0_;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_;
		_tmp0_ = cur;
		if (!(string_get (message, (glong) _tmp0_) != '\0')) {
			break;
		}
		_tmp2_ = cur;
		if (string_get (message, (glong) _tmp2_) == '\'') {
			_tmp1_ = TRUE;
		} else {
			gint _tmp3_;
			_tmp3_ = cur;
			_tmp1_ = string_get (message, (glong) _tmp3_) == '`';
		}
		if (_tmp1_) {
			const gchar* _tmp4_ = NULL;
			gint _tmp5_;
			const gchar* end_chars = NULL;
			FILE* _tmp6_;
			gint _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			gint _tmp19_;
			_tmp5_ = cur;
			if (string_get (message, (glong) _tmp5_) == '`') {
				_tmp4_ = "`'";
			} else {
				_tmp4_ = "'";
			}
			end_chars = _tmp4_;
			_tmp6_ = stderr;
			_tmp7_ = start;
			_tmp8_ = cur;
			_tmp9_ = start;
			_tmp10_ = string_substring (message, (glong) _tmp7_, (glong) (_tmp8_ - _tmp9_));
			_tmp11_ = _tmp10_;
			fputs (_tmp11_, _tmp6_);
			_g_free0 (_tmp11_);
			_tmp12_ = cur;
			start = _tmp12_;
			_tmp13_ = cur;
			cur = _tmp13_ + 1;
			while (TRUE) {
				gboolean _tmp14_ = FALSE;
				gint _tmp15_;
				gint _tmp18_;
				_tmp15_ = cur;
				if (string_get (message, (glong) _tmp15_) != '\0') {
					const gchar* _tmp16_;
					gint _tmp17_;
					_tmp16_ = end_chars;
					_tmp17_ = cur;
					_tmp14_ = string_index_of_char (_tmp16_, (gunichar) string_get (message, (glong) _tmp17_), 0) < 0;
				} else {
					_tmp14_ = FALSE;
				}
				if (!_tmp14_) {
					break;
				}
				_tmp18_ = cur;
				cur = _tmp18_ + 1;
			}
			_tmp19_ = cur;
			if (string_get (message, (glong) _tmp19_) == '\0') {
				FILE* _tmp20_;
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				gint _tmp26_;
				_tmp20_ = stderr;
				_tmp21_ = start;
				_tmp22_ = cur;
				_tmp23_ = start;
				_tmp24_ = string_substring (message, (glong) _tmp21_, (glong) (_tmp22_ - _tmp23_));
				_tmp25_ = _tmp24_;
				fputs (_tmp25_, _tmp20_);
				_g_free0 (_tmp25_);
				_tmp26_ = cur;
				start = _tmp26_;
			} else {
				gint _tmp27_;
				FILE* _tmp28_;
				const gchar* _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gint _tmp36_;
				_tmp27_ = cur;
				cur = _tmp27_ + 1;
				_tmp28_ = stderr;
				_tmp29_ = self->priv->quote_color_start;
				_tmp30_ = start;
				_tmp31_ = cur;
				_tmp32_ = start;
				_tmp33_ = string_substring (message, (glong) _tmp30_, (glong) (_tmp31_ - _tmp32_));
				_tmp34_ = _tmp33_;
				_tmp35_ = self->priv->quote_color_end;
				fprintf (_tmp28_, "%s%s%s", _tmp29_, _tmp34_, _tmp35_);
				_g_free0 (_tmp34_);
				_tmp36_ = cur;
				start = _tmp36_;
			}
		} else {
			gint _tmp37_;
			_tmp37_ = cur;
			cur = _tmp37_ + 1;
		}
	}
	_tmp38_ = stderr;
	_tmp39_ = start;
	_tmp40_ = string_offset (message, (glong) _tmp39_);
	fputs (_tmp40_, _tmp38_);
}


static void
vala_report_print_message (ValaReport* self,
                           ValaSourceReference* source,
                           const gchar* type,
                           const gchar* type_color_start,
                           const gchar* type_color_end,
                           const gchar* message,
                           gboolean do_report_source)
{
	FILE* _tmp5_;
	FILE* _tmp6_;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (type != NULL);
	g_return_if_fail (type_color_start != NULL);
	g_return_if_fail (type_color_end != NULL);
	g_return_if_fail (message != NULL);
	if (source != NULL) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp0_ = stderr;
		_tmp1_ = self->priv->locus_color_start;
		_tmp2_ = vala_source_reference_to_string (source);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->locus_color_end;
		fprintf (_tmp0_, "%s%s:%s ", _tmp1_, _tmp3_, _tmp4_);
		_g_free0 (_tmp3_);
	}
	_tmp5_ = stderr;
	fprintf (_tmp5_, "%s%s:%s ", type_color_start, type, type_color_end);
	vala_report_print_highlighted_message (self, message);
	_tmp6_ = stderr;
	fputc ('\n', _tmp6_);
	if (do_report_source) {
		_tmp7_ = source != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		vala_report_report_source (self, source);
	}
}


/**
 * Reports the specified message as note.
 *
 * @param source  reference to source code
 * @param message note message
 */
static void
vala_report_real_note (ValaReport* self,
                       ValaSourceReference* source,
                       const gchar* message)
{
	gboolean _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->note_color_start;
	_tmp2_ = self->priv->note_color_end;
	_tmp3_ = self->priv->verbose_errors;
	vala_report_print_message (self, source, "note", _tmp1_, _tmp2_, message, _tmp3_);
}


void
vala_report_note (ValaReport* self,
                  ValaSourceReference* source,
                  const gchar* message)
{
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->note (self, source, message);
}


/**
 * Reports the specified message as deprecation warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void
vala_report_real_depr (ValaReport* self,
                       ValaSourceReference* source,
                       const gchar* message)
{
	gboolean _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->warnings;
	self->warnings = _tmp1_ + 1;
	_tmp2_ = self->priv->warning_color_start;
	_tmp3_ = self->priv->warning_color_end;
	vala_report_print_message (self, source, "warning", _tmp2_, _tmp3_, message, FALSE);
}


void
vala_report_depr (ValaReport* self,
                  ValaSourceReference* source,
                  const gchar* message)
{
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->depr (self, source, message);
}


/**
 * Reports the specified message as warning.
 *
 * @param source  reference to source code
 * @param message warning message
 */
static void
vala_report_real_warn (ValaReport* self,
                       ValaSourceReference* source,
                       const gchar* message)
{
	gboolean _tmp0_;
	gint _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->priv->_enable_warnings;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->warnings;
	self->warnings = _tmp1_ + 1;
	_tmp2_ = self->priv->warning_color_start;
	_tmp3_ = self->priv->warning_color_end;
	_tmp4_ = self->priv->verbose_errors;
	vala_report_print_message (self, source, "warning", _tmp2_, _tmp3_, message, _tmp4_);
}


void
vala_report_warn (ValaReport* self,
                  ValaSourceReference* source,
                  const gchar* message)
{
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->warn (self, source, message);
}


/**
 * Reports the specified message as error.
 *
 * @param source  reference to source code
 * @param message error message
 */
static void
vala_report_real_err (ValaReport* self,
                      ValaSourceReference* source,
                      const gchar* message)
{
	gint _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = self->errors;
	self->errors = _tmp0_ + 1;
	_tmp1_ = self->priv->error_color_start;
	_tmp2_ = self->priv->error_color_end;
	_tmp3_ = self->priv->verbose_errors;
	vala_report_print_message (self, source, "error", _tmp1_, _tmp2_, message, _tmp3_);
}


void
vala_report_err (ValaReport* self,
                 ValaSourceReference* source,
                 const gchar* message)
{
	g_return_if_fail (self != NULL);
	VALA_REPORT_GET_CLASS (self)->err (self, source, message);
}


void
vala_report_notice (ValaSourceReference* source,
                    const gchar* message)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_report_note (_tmp3_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void
vala_report_deprecated (ValaSourceReference* source,
                        const gchar* message)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_report_depr (_tmp3_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void
vala_report_experimental (ValaSourceReference* source,
                          const gchar* message)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_report_depr (_tmp3_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void
vala_report_warning (ValaSourceReference* source,
                     const gchar* message)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_report_warn (_tmp3_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


void
vala_report_error (ValaSourceReference* source,
                   const gchar* message)
{
	ValaCodeContext* _tmp0_;
	ValaCodeContext* _tmp1_;
	ValaReport* _tmp2_;
	ValaReport* _tmp3_;
	g_return_if_fail (message != NULL);
	_tmp0_ = vala_code_context_get ();
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_code_context_get_report (_tmp1_);
	_tmp3_ = _tmp2_;
	vala_report_err (_tmp3_, source, message);
	_vala_code_context_unref0 (_tmp1_);
}


static gboolean
vala_report_is_atty (ValaReport* self,
                     gint fd)
{
	gboolean result = FALSE;
	GModule* module = NULL;
	GModule* _tmp0_;
	GModule* _tmp1_;
	void* _func = NULL;
	GModule* _tmp2_;
	void* _tmp3_ = NULL;
	void* _tmp4_;
	ValaReportAttyFunc func = NULL;
	void* _tmp5_;
	ValaReportAttyFunc _tmp6_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = g_module_open (NULL, G_MODULE_BIND_LAZY);
	module = _tmp0_;
	_tmp1_ = module;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp2_ = module;
	g_module_symbol (_tmp2_, "isatty", &_tmp3_);
	_func = _tmp3_;
	_tmp4_ = _func;
	if (_tmp4_ == NULL) {
		result = FALSE;
		_g_module_close0 (module);
		return result;
	}
	_tmp5_ = _func;
	func = (ValaReportAttyFunc) _tmp5_;
	_tmp6_ = func;
	result = _tmp6_ (fd) == 1;
	_g_module_close0 (module);
	return result;
}


ValaReport*
vala_report_construct (GType object_type)
{
	ValaReport* self = NULL;
	self = (ValaReport*) g_type_create_instance (object_type);
	return self;
}


ValaReport*
vala_report_new (void)
{
	return vala_report_construct (VALA_TYPE_REPORT);
}


gboolean
vala_report_get_enable_warnings (ValaReport* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_enable_warnings;
	result = _tmp0_;
	return result;
}


void
vala_report_set_enable_warnings (ValaReport* self,
                                 gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_enable_warnings = value;
}


static void
vala_value_report_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}


static void
vala_value_report_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		vala_report_unref (value->data[0].v_pointer);
	}
}


static void
vala_value_report_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = vala_report_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer
vala_value_report_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}


static gchar*
vala_value_report_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ValaReport * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = vala_report_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar*
vala_value_report_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	ValaReport ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = vala_report_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec*
vala_param_spec_report (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ValaParamSpecReport* spec;
	g_return_val_if_fail (g_type_is_a (object_type, VALA_TYPE_REPORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer
vala_value_get_report (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_REPORT), NULL);
	return value->data[0].v_pointer;
}


void
vala_value_set_report (GValue* value,
                       gpointer v_object)
{
	ValaReport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_REPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_REPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		vala_report_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_report_unref (old);
	}
}


void
vala_value_take_report (GValue* value,
                        gpointer v_object)
{
	ValaReport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, VALA_TYPE_REPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, VALA_TYPE_REPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		vala_report_unref (old);
	}
}


static void
vala_report_class_init (ValaReportClass * klass)
{
	vala_report_parent_class = g_type_class_peek_parent (klass);
	((ValaReportClass *) klass)->finalize = vala_report_finalize;
	g_type_class_add_private (klass, sizeof (ValaReportPrivate));
	((ValaReportClass *) klass)->note = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_note;
	((ValaReportClass *) klass)->depr = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_depr;
	((ValaReportClass *) klass)->warn = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_warn;
	((ValaReportClass *) klass)->err = (void (*) (ValaReport *, ValaSourceReference*, const gchar*)) vala_report_real_err;
}


static void
vala_report_instance_init (ValaReport * self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	self->priv = VALA_REPORT_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("");
	self->priv->locus_color_start = _tmp0_;
	self->priv->locus_color_end = "";
	_tmp1_ = g_strdup ("");
	self->priv->warning_color_start = _tmp1_;
	self->priv->warning_color_end = "";
	_tmp2_ = g_strdup ("");
	self->priv->error_color_start = _tmp2_;
	self->priv->error_color_end = "";
	_tmp3_ = g_strdup ("");
	self->priv->note_color_start = _tmp3_;
	self->priv->note_color_end = "";
	_tmp4_ = g_strdup ("");
	self->priv->caret_color_start = _tmp4_;
	self->priv->caret_color_end = "";
	_tmp5_ = g_strdup ("");
	self->priv->quote_color_start = _tmp5_;
	self->priv->quote_color_end = "";
	self->priv->_enable_warnings = TRUE;
	self->ref_count = 1;
}


static void
vala_report_finalize (ValaReport * obj)
{
	ValaReport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_REPORT, ValaReport);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->locus_color_start);
	_g_free0 (self->priv->warning_color_start);
	_g_free0 (self->priv->error_color_start);
	_g_free0 (self->priv->note_color_start);
	_g_free0 (self->priv->caret_color_start);
	_g_free0 (self->priv->quote_color_start);
}


/**
 * Namespace to centralize reporting warnings and errors.
 */
GType
vala_report_get_type (void)
{
	static volatile gsize vala_report_type_id__volatile = 0;
	if (g_once_init_enter (&vala_report_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { vala_value_report_init, vala_value_report_free_value, vala_value_report_copy_value, vala_value_report_peek_pointer, "p", vala_value_report_collect_value, "p", vala_value_report_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ValaReportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_report_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaReport), 0, (GInstanceInitFunc) vala_report_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType vala_report_type_id;
		vala_report_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ValaReport", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&vala_report_type_id__volatile, vala_report_type_id);
	}
	return vala_report_type_id__volatile;
}


gpointer
vala_report_ref (gpointer instance)
{
	ValaReport * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void
vala_report_unref (gpointer instance)
{
	ValaReport * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		VALA_REPORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



