/* valaproperty.c generated by valac, the Vala compiler
 * generated from valaproperty.vala, do not modify */

/* valaproperty.vala
 *
 * Copyright (C) 2006-2012  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 *	Raffaele Sandrini <raffaele@sandrini.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include "vala.h"
#include <stdlib.h>
#include <string.h>
#include <valagee.h>

#define _vala_code_node_unref0(var) ((var == NULL) ? NULL : (var = (vala_code_node_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_iterable_unref0(var) ((var == NULL) ? NULL : (var = (vala_iterable_unref (var), NULL)))
#define _vala_source_file_unref0(var) ((var == NULL) ? NULL : (var = (vala_source_file_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ValaPropertyPrivate {
	ValaParameter* _this_parameter;
	gboolean _interface_only;
	gboolean _is_abstract;
	gboolean _is_virtual;
	gboolean _overrides;
	ValaField* _field;
	ValaMemberBinding _binding;
	ValaExpression* _initializer;
	gboolean lock_used;
	ValaDataType* _data_type;
	ValaProperty* _base_property;
	ValaProperty* _base_interface_property;
	gboolean base_properties_valid;
	ValaPropertyAccessor* _get_accessor;
	ValaPropertyAccessor* _set_accessor;
	gchar* _nick;
	gchar* _blurb;
	gboolean* _notify;
};


static gpointer vala_property_parent_class = NULL;
static ValaLockableIface * vala_property_vala_lockable_parent_iface = NULL;

#define VALA_PROPERTY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), VALA_TYPE_PROPERTY, ValaPropertyPrivate))
static void vala_property_real_accept (ValaCodeNode* base,
                                ValaCodeVisitor* visitor);
static void vala_property_real_accept_children (ValaCodeNode* base,
                                         ValaCodeVisitor* visitor);
static gboolean vala_property_real_get_lock_used (ValaLockable* base);
static void vala_property_real_set_lock_used (ValaLockable* base,
                                       gboolean used);
static void vala_property_real_replace_type (ValaCodeNode* base,
                                      ValaDataType* old_type,
                                      ValaDataType* new_type);
static void vala_property_real_replace_expression (ValaCodeNode* base,
                                            ValaExpression* old_node,
                                            ValaExpression* new_node);
static void vala_property_find_base_properties (ValaProperty* self);
static void vala_property_find_base_interface_property (ValaProperty* self,
                                                 ValaClass* cl);
static void vala_property_find_base_class_property (ValaProperty* self,
                                             ValaClass* cl);
static gboolean vala_property_real_check (ValaCodeNode* base,
                                   ValaCodeContext* context);
static gboolean* _bool_dup (gboolean* self);
static void vala_property_finalize (ValaCodeNode * obj);


/**
 * Creates a new property.
 *
 * @param name              property name
 * @param property_type     property type
 * @param get_accessor      get accessor
 * @param set_accessor      set/construct accessor
 * @param source_reference  reference to source code
 * @return                  newly created property
 */
ValaProperty*
vala_property_construct (GType object_type,
                         const gchar* name,
                         ValaDataType* property_type,
                         ValaPropertyAccessor* get_accessor,
                         ValaPropertyAccessor* set_accessor,
                         ValaSourceReference* source_reference,
                         ValaComment* comment)
{
	ValaProperty* self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (ValaProperty*) vala_symbol_construct (object_type, name, source_reference, comment);
	vala_property_set_property_type (self, property_type);
	vala_property_set_get_accessor (self, get_accessor);
	vala_property_set_set_accessor (self, set_accessor);
	return self;
}


ValaProperty*
vala_property_new (const gchar* name,
                   ValaDataType* property_type,
                   ValaPropertyAccessor* get_accessor,
                   ValaPropertyAccessor* set_accessor,
                   ValaSourceReference* source_reference,
                   ValaComment* comment)
{
	return vala_property_construct (VALA_TYPE_PROPERTY, name, property_type, get_accessor, set_accessor, source_reference, comment);
}


static void
vala_property_real_accept (ValaCodeNode* base,
                           ValaCodeVisitor* visitor)
{
	ValaProperty * self;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	vala_code_visitor_visit_property (visitor, self);
}


static void
vala_property_real_accept_children (ValaCodeNode* base,
                                    ValaCodeVisitor* visitor)
{
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	ValaPropertyAccessor* _tmp6_;
	ValaPropertyAccessor* _tmp7_;
	ValaExpression* _tmp10_;
	ValaExpression* _tmp11_;
	self = (ValaProperty*) base;
	g_return_if_fail (visitor != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	vala_code_node_accept ((ValaCodeNode*) _tmp1_, visitor);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ValaPropertyAccessor* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		_tmp4_ = vala_property_get_get_accessor (self);
		_tmp5_ = _tmp4_;
		vala_code_node_accept ((ValaCodeNode*) _tmp5_, visitor);
	}
	_tmp6_ = vala_property_get_set_accessor (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_ != NULL) {
		ValaPropertyAccessor* _tmp8_;
		ValaPropertyAccessor* _tmp9_;
		_tmp8_ = vala_property_get_set_accessor (self);
		_tmp9_ = _tmp8_;
		vala_code_node_accept ((ValaCodeNode*) _tmp9_, visitor);
	}
	_tmp10_ = vala_property_get_initializer (self);
	_tmp11_ = _tmp10_;
	if (_tmp11_ != NULL) {
		ValaExpression* _tmp12_;
		ValaExpression* _tmp13_;
		_tmp12_ = vala_property_get_initializer (self);
		_tmp13_ = _tmp12_;
		vala_code_node_accept ((ValaCodeNode*) _tmp13_, visitor);
	}
}


static gboolean
vala_property_real_get_lock_used (ValaLockable* base)
{
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	self = (ValaProperty*) base;
	_tmp0_ = self->priv->lock_used;
	result = _tmp0_;
	return result;
}


static void
vala_property_real_set_lock_used (ValaLockable* base,
                                  gboolean used)
{
	ValaProperty * self;
	self = (ValaProperty*) base;
	self->priv->lock_used = used;
}


/**
 * Checks whether the accessors of this property are compatible
 * with the specified base property.
 *
 * @param base_property a property
 * @param invalid_match error string about which check failed
 * @return true if the specified property is compatible to this property
 */
gboolean
vala_property_compatible (ValaProperty* self,
                          ValaProperty* base_property,
                          gchar* * invalid_match)
{
	gchar* _vala_invalid_match = NULL;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ValaPropertyAccessor* _tmp2_;
	ValaPropertyAccessor* _tmp3_;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp13_ = FALSE;
	ValaPropertyAccessor* _tmp14_;
	ValaPropertyAccessor* _tmp15_;
	ValaDataType* object_type = NULL;
	ValaSymbol* _tmp24_;
	ValaSymbol* _tmp25_;
	ValaDataType* _tmp26_;
	ValaPropertyAccessor* _tmp27_;
	ValaPropertyAccessor* _tmp28_;
	ValaPropertyAccessor* _tmp41_;
	ValaPropertyAccessor* _tmp42_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (base_property != NULL, FALSE);
	_tmp2_ = vala_property_get_get_accessor (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == NULL) {
		ValaPropertyAccessor* _tmp4_;
		ValaPropertyAccessor* _tmp5_;
		_tmp4_ = vala_property_get_get_accessor (base_property);
		_tmp5_ = _tmp4_;
		_tmp1_ = _tmp5_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		ValaPropertyAccessor* _tmp7_;
		ValaPropertyAccessor* _tmp8_;
		_tmp7_ = vala_property_get_get_accessor (self);
		_tmp8_ = _tmp7_;
		if (_tmp8_ != NULL) {
			ValaPropertyAccessor* _tmp9_;
			ValaPropertyAccessor* _tmp10_;
			_tmp9_ = vala_property_get_get_accessor (base_property);
			_tmp10_ = _tmp9_;
			_tmp6_ = _tmp10_ == NULL;
		} else {
			_tmp6_ = FALSE;
		}
		_tmp0_ = _tmp6_;
	}
	if (_tmp0_) {
		gchar* _tmp11_;
		_tmp11_ = g_strdup ("incompatible get accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp11_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp14_ = vala_property_get_set_accessor (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		ValaPropertyAccessor* _tmp16_;
		ValaPropertyAccessor* _tmp17_;
		_tmp16_ = vala_property_get_set_accessor (base_property);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ != NULL;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		_tmp12_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ValaPropertyAccessor* _tmp19_;
		ValaPropertyAccessor* _tmp20_;
		_tmp19_ = vala_property_get_set_accessor (self);
		_tmp20_ = _tmp19_;
		if (_tmp20_ != NULL) {
			ValaPropertyAccessor* _tmp21_;
			ValaPropertyAccessor* _tmp22_;
			_tmp21_ = vala_property_get_set_accessor (base_property);
			_tmp22_ = _tmp21_;
			_tmp18_ = _tmp22_ == NULL;
		} else {
			_tmp18_ = FALSE;
		}
		_tmp12_ = _tmp18_;
	}
	if (_tmp12_) {
		gchar* _tmp23_;
		_tmp23_ = g_strdup ("incompatible set accessor");
		_g_free0 (_vala_invalid_match);
		_vala_invalid_match = _tmp23_;
		result = FALSE;
		if (invalid_match) {
			*invalid_match = _vala_invalid_match;
		} else {
			_g_free0 (_vala_invalid_match);
		}
		return result;
	}
	_tmp24_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp25_ = _tmp24_;
	_tmp26_ = vala_semantic_analyzer_get_data_type_for_symbol (_tmp25_);
	object_type = _tmp26_;
	_tmp27_ = vala_property_get_get_accessor (self);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaPropertyAccessor* _tmp29_;
		ValaPropertyAccessor* _tmp30_;
		ValaDataType* _tmp31_;
		ValaDataType* _tmp32_;
		ValaDataType* _tmp33_;
		ValaDataType* _tmp34_;
		ValaDataType* _tmp35_;
		ValaPropertyAccessor* _tmp36_;
		ValaPropertyAccessor* _tmp37_;
		ValaDataType* _tmp38_;
		ValaDataType* _tmp39_;
		_tmp29_ = vala_property_get_get_accessor (base_property);
		_tmp30_ = _tmp29_;
		_tmp31_ = vala_property_accessor_get_value_type (_tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = object_type;
		_tmp34_ = vala_data_type_get_actual_type (_tmp32_, _tmp33_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp34_;
		_tmp35_ = actual_base_type;
		_tmp36_ = vala_property_get_get_accessor (self);
		_tmp37_ = _tmp36_;
		_tmp38_ = vala_property_accessor_get_value_type (_tmp37_);
		_tmp39_ = _tmp38_;
		if (!vala_data_type_equals (_tmp35_, _tmp39_)) {
			gchar* _tmp40_;
			_tmp40_ = g_strdup ("incompatible get accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp40_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_tmp41_ = vala_property_get_set_accessor (self);
	_tmp42_ = _tmp41_;
	if (_tmp42_ != NULL) {
		ValaDataType* actual_base_type = NULL;
		ValaPropertyAccessor* _tmp43_;
		ValaPropertyAccessor* _tmp44_;
		ValaDataType* _tmp45_;
		ValaDataType* _tmp46_;
		ValaDataType* _tmp47_;
		ValaDataType* _tmp48_;
		ValaDataType* _tmp49_;
		ValaPropertyAccessor* _tmp50_;
		ValaPropertyAccessor* _tmp51_;
		ValaDataType* _tmp52_;
		ValaDataType* _tmp53_;
		ValaPropertyAccessor* _tmp55_;
		ValaPropertyAccessor* _tmp56_;
		gboolean _tmp57_;
		gboolean _tmp58_;
		ValaPropertyAccessor* _tmp59_;
		ValaPropertyAccessor* _tmp60_;
		gboolean _tmp61_;
		gboolean _tmp62_;
		ValaPropertyAccessor* _tmp64_;
		ValaPropertyAccessor* _tmp65_;
		gboolean _tmp66_;
		gboolean _tmp67_;
		ValaPropertyAccessor* _tmp68_;
		ValaPropertyAccessor* _tmp69_;
		gboolean _tmp70_;
		gboolean _tmp71_;
		_tmp43_ = vala_property_get_set_accessor (base_property);
		_tmp44_ = _tmp43_;
		_tmp45_ = vala_property_accessor_get_value_type (_tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = object_type;
		_tmp48_ = vala_data_type_get_actual_type (_tmp46_, _tmp47_, NULL, (ValaCodeNode*) self);
		actual_base_type = _tmp48_;
		_tmp49_ = actual_base_type;
		_tmp50_ = vala_property_get_set_accessor (self);
		_tmp51_ = _tmp50_;
		_tmp52_ = vala_property_accessor_get_value_type (_tmp51_);
		_tmp53_ = _tmp52_;
		if (!vala_data_type_equals (_tmp49_, _tmp53_)) {
			gchar* _tmp54_;
			_tmp54_ = g_strdup ("incompatible set accessor type");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp54_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp55_ = vala_property_get_set_accessor (self);
		_tmp56_ = _tmp55_;
		_tmp57_ = vala_property_accessor_get_writable (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp59_ = vala_property_get_set_accessor (base_property);
		_tmp60_ = _tmp59_;
		_tmp61_ = vala_property_accessor_get_writable (_tmp60_);
		_tmp62_ = _tmp61_;
		if (_tmp58_ != _tmp62_) {
			gchar* _tmp63_;
			_tmp63_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp63_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_tmp64_ = vala_property_get_set_accessor (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = vala_property_accessor_get_construction (_tmp65_);
		_tmp67_ = _tmp66_;
		_tmp68_ = vala_property_get_set_accessor (base_property);
		_tmp69_ = _tmp68_;
		_tmp70_ = vala_property_accessor_get_construction (_tmp69_);
		_tmp71_ = _tmp70_;
		if (_tmp67_ != _tmp71_) {
			gchar* _tmp72_;
			_tmp72_ = g_strdup ("incompatible set accessor");
			_g_free0 (_vala_invalid_match);
			_vala_invalid_match = _tmp72_;
			result = FALSE;
			_vala_code_node_unref0 (actual_base_type);
			_vala_code_node_unref0 (object_type);
			if (invalid_match) {
				*invalid_match = _vala_invalid_match;
			} else {
				_g_free0 (_vala_invalid_match);
			}
			return result;
		}
		_vala_code_node_unref0 (actual_base_type);
	}
	_g_free0 (_vala_invalid_match);
	_vala_invalid_match = NULL;
	result = TRUE;
	_vala_code_node_unref0 (object_type);
	if (invalid_match) {
		*invalid_match = _vala_invalid_match;
	} else {
		_g_free0 (_vala_invalid_match);
	}
	return result;
}


static void
vala_property_real_replace_type (ValaCodeNode* base,
                                 ValaDataType* old_type,
                                 ValaDataType* new_type)
{
	ValaProperty * self;
	ValaDataType* _tmp0_;
	ValaDataType* _tmp1_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_type != NULL);
	g_return_if_fail (new_type != NULL);
	_tmp0_ = vala_property_get_property_type (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_type) {
		vala_property_set_property_type (self, new_type);
	}
}


static void
vala_property_real_replace_expression (ValaCodeNode* base,
                                       ValaExpression* old_node,
                                       ValaExpression* new_node)
{
	ValaProperty * self;
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	self = (ValaProperty*) base;
	g_return_if_fail (old_node != NULL);
	g_return_if_fail (new_node != NULL);
	_tmp0_ = vala_property_get_initializer (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == old_node) {
		vala_property_set_initializer (self, new_node);
	}
}


static gpointer
_vala_code_node_ref0 (gpointer self)
{
	return self ? vala_code_node_ref (self) : NULL;
}


static void
vala_property_find_base_properties (ValaProperty* self)
{
	gboolean _tmp0_;
	ValaSymbol* _tmp1_;
	ValaSymbol* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->base_properties_valid;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
	_tmp2_ = _tmp1_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, VALA_TYPE_CLASS)) {
		ValaSymbol* _tmp3_;
		ValaSymbol* _tmp4_;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		_tmp3_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp4_ = _tmp3_;
		vala_property_find_base_interface_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, VALA_TYPE_CLASS, ValaClass));
		_tmp6_ = self->priv->_is_virtual;
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			gboolean _tmp7_;
			_tmp7_ = self->priv->_overrides;
			_tmp5_ = _tmp7_;
		}
		if (_tmp5_) {
			ValaSymbol* _tmp8_;
			ValaSymbol* _tmp9_;
			_tmp8_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp9_ = _tmp8_;
			vala_property_find_base_class_property (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, VALA_TYPE_CLASS, ValaClass));
		}
	} else {
		ValaSymbol* _tmp10_;
		ValaSymbol* _tmp11_;
		_tmp10_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp11_ = _tmp10_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, VALA_TYPE_INTERFACE)) {
			gboolean _tmp12_ = FALSE;
			gboolean _tmp13_;
			_tmp13_ = self->priv->_is_virtual;
			if (_tmp13_) {
				_tmp12_ = TRUE;
			} else {
				gboolean _tmp14_;
				_tmp14_ = self->priv->_is_abstract;
				_tmp12_ = _tmp14_;
			}
			if (_tmp12_) {
				ValaProperty* _tmp15_;
				_tmp15_ = _vala_code_node_ref0 (self);
				_vala_code_node_unref0 (self->priv->_base_interface_property);
				self->priv->_base_interface_property = _tmp15_;
			}
		}
	}
	self->priv->base_properties_valid = TRUE;
}


static void
vala_property_find_base_class_property (ValaProperty* self,
                                        ValaClass* cl)
{
	ValaSymbol* sym = NULL;
	ValaScope* _tmp0_;
	ValaScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	ValaSymbol* _tmp4_;
	ValaSymbol* _tmp5_;
	ValaClass* _tmp27_;
	ValaClass* _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	_tmp0_ = vala_symbol_get_scope ((ValaSymbol*) cl);
	_tmp1_ = _tmp0_;
	_tmp2_ = vala_symbol_get_name ((ValaSymbol*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = vala_scope_lookup (_tmp1_, _tmp3_);
	sym = _tmp4_;
	_tmp5_ = sym;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp5_, VALA_TYPE_PROPERTY)) {
		ValaProperty* base_property = NULL;
		ValaSymbol* _tmp6_;
		ValaProperty* _tmp7_;
		gboolean _tmp8_ = FALSE;
		ValaProperty* _tmp9_;
		gboolean _tmp10_;
		_tmp6_ = sym;
		_tmp7_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, VALA_TYPE_PROPERTY, ValaProperty));
		base_property = _tmp7_;
		_tmp9_ = base_property;
		_tmp10_ = _tmp9_->priv->_is_abstract;
		if (_tmp10_) {
			_tmp8_ = TRUE;
		} else {
			ValaProperty* _tmp11_;
			gboolean _tmp12_;
			_tmp11_ = base_property;
			_tmp12_ = _tmp11_->priv->_is_virtual;
			_tmp8_ = _tmp12_;
		}
		if (_tmp8_) {
			gchar* invalid_match = NULL;
			ValaProperty* _tmp13_;
			gchar* _tmp14_ = NULL;
			gboolean _tmp15_;
			ValaProperty* _tmp26_;
			_tmp13_ = base_property;
			_tmp15_ = vala_property_compatible (self, _tmp13_, &_tmp14_);
			_g_free0 (invalid_match);
			invalid_match = _tmp14_;
			if (!_tmp15_) {
				ValaSourceReference* _tmp16_;
				ValaSourceReference* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				ValaProperty* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp16_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_symbol_get_full_name ((ValaSymbol*) self);
				_tmp19_ = _tmp18_;
				_tmp20_ = base_property;
				_tmp21_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = invalid_match;
				_tmp24_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp19_, _tmp22_, _tmp23_);
				_tmp25_ = _tmp24_;
				vala_report_error (_tmp17_, _tmp25_);
				_g_free0 (_tmp25_);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp19_);
				_g_free0 (invalid_match);
				_vala_code_node_unref0 (base_property);
				_vala_code_node_unref0 (sym);
				return;
			}
			_tmp26_ = base_property;
			self->priv->_base_property = _tmp26_;
			_g_free0 (invalid_match);
			_vala_code_node_unref0 (base_property);
			_vala_code_node_unref0 (sym);
			return;
		}
		_vala_code_node_unref0 (base_property);
	}
	_tmp27_ = vala_class_get_base_class (cl);
	_tmp28_ = _tmp27_;
	if (_tmp28_ != NULL) {
		ValaClass* _tmp29_;
		ValaClass* _tmp30_;
		_tmp29_ = vala_class_get_base_class (cl);
		_tmp30_ = _tmp29_;
		vala_property_find_base_class_property (self, _tmp30_);
	}
	_vala_code_node_unref0 (sym);
}


static void
vala_property_find_base_interface_property (ValaProperty* self,
                                            ValaClass* cl)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (cl != NULL);
	{
		ValaList* _type_list = NULL;
		ValaList* _tmp0_;
		gint _type_size = 0;
		ValaList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _type_index = 0;
		_tmp0_ = vala_class_get_base_types (cl);
		_type_list = _tmp0_;
		_tmp1_ = _type_list;
		_tmp2_ = vala_collection_get_size ((ValaCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_type_size = _tmp3_;
		_type_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			ValaDataType* type = NULL;
			ValaList* _tmp7_;
			gint _tmp8_;
			gpointer _tmp9_;
			ValaDataType* _tmp10_;
			ValaTypeSymbol* _tmp11_;
			ValaTypeSymbol* _tmp12_;
			_tmp4_ = _type_index;
			_type_index = _tmp4_ + 1;
			_tmp5_ = _type_index;
			_tmp6_ = _type_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _type_list;
			_tmp8_ = _type_index;
			_tmp9_ = vala_list_get (_tmp7_, _tmp8_);
			type = (ValaDataType*) _tmp9_;
			_tmp10_ = type;
			_tmp11_ = vala_data_type_get_data_type (_tmp10_);
			_tmp12_ = _tmp11_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp12_, VALA_TYPE_INTERFACE)) {
				ValaSymbol* sym = NULL;
				ValaDataType* _tmp13_;
				ValaTypeSymbol* _tmp14_;
				ValaTypeSymbol* _tmp15_;
				ValaScope* _tmp16_;
				ValaScope* _tmp17_;
				const gchar* _tmp18_;
				const gchar* _tmp19_;
				ValaSymbol* _tmp20_;
				ValaSymbol* _tmp21_;
				_tmp13_ = type;
				_tmp14_ = vala_data_type_get_data_type (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = vala_symbol_get_scope ((ValaSymbol*) _tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = vala_symbol_get_name ((ValaSymbol*) self);
				_tmp19_ = _tmp18_;
				_tmp20_ = vala_scope_lookup (_tmp17_, _tmp19_);
				sym = _tmp20_;
				_tmp21_ = sym;
				if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp21_, VALA_TYPE_PROPERTY)) {
					ValaProperty* base_property = NULL;
					ValaSymbol* _tmp22_;
					ValaProperty* _tmp23_;
					gboolean _tmp24_ = FALSE;
					ValaProperty* _tmp25_;
					gboolean _tmp26_;
					_tmp22_ = sym;
					_tmp23_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, VALA_TYPE_PROPERTY, ValaProperty));
					base_property = _tmp23_;
					_tmp25_ = base_property;
					_tmp26_ = _tmp25_->priv->_is_abstract;
					if (_tmp26_) {
						_tmp24_ = TRUE;
					} else {
						ValaProperty* _tmp27_;
						gboolean _tmp28_;
						_tmp27_ = base_property;
						_tmp28_ = _tmp27_->priv->_is_virtual;
						_tmp24_ = _tmp28_;
					}
					if (_tmp24_) {
						gchar* invalid_match = NULL;
						ValaProperty* _tmp29_;
						gchar* _tmp30_ = NULL;
						gboolean _tmp31_;
						ValaProperty* _tmp42_;
						ValaProperty* _tmp43_;
						_tmp29_ = base_property;
						_tmp31_ = vala_property_compatible (self, _tmp29_, &_tmp30_);
						_g_free0 (invalid_match);
						invalid_match = _tmp30_;
						if (!_tmp31_) {
							ValaSourceReference* _tmp32_;
							ValaSourceReference* _tmp33_;
							gchar* _tmp34_;
							gchar* _tmp35_;
							ValaProperty* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							const gchar* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
							_tmp32_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
							_tmp33_ = _tmp32_;
							_tmp34_ = vala_symbol_get_full_name ((ValaSymbol*) self);
							_tmp35_ = _tmp34_;
							_tmp36_ = base_property;
							_tmp37_ = vala_symbol_get_full_name ((ValaSymbol*) _tmp36_);
							_tmp38_ = _tmp37_;
							_tmp39_ = invalid_match;
							_tmp40_ = g_strdup_printf ("Type and/or accessors of overriding property `%s' do not match overrid" \
"den property `%s': %s.", _tmp35_, _tmp38_, _tmp39_);
							_tmp41_ = _tmp40_;
							vala_report_error (_tmp33_, _tmp41_);
							_g_free0 (_tmp41_);
							_g_free0 (_tmp38_);
							_g_free0 (_tmp35_);
							_g_free0 (invalid_match);
							_vala_code_node_unref0 (base_property);
							_vala_code_node_unref0 (sym);
							_vala_code_node_unref0 (type);
							_vala_iterable_unref0 (_type_list);
							return;
						}
						_tmp42_ = base_property;
						_tmp43_ = _vala_code_node_ref0 (_tmp42_);
						_vala_code_node_unref0 (self->priv->_base_interface_property);
						self->priv->_base_interface_property = _tmp43_;
						_g_free0 (invalid_match);
						_vala_code_node_unref0 (base_property);
						_vala_code_node_unref0 (sym);
						_vala_code_node_unref0 (type);
						_vala_iterable_unref0 (_type_list);
						return;
					}
					_vala_code_node_unref0 (base_property);
				}
				_vala_code_node_unref0 (sym);
			}
			_vala_code_node_unref0 (type);
		}
		_vala_iterable_unref0 (_type_list);
	}
}


static gpointer
_vala_source_file_ref0 (gpointer self)
{
	return self ? vala_source_file_ref (self) : NULL;
}


static gboolean
vala_property_real_check (ValaCodeNode* base,
                          ValaCodeContext* context)
{
	ValaProperty * self;
	gboolean result = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp4_;
	ValaSourceFile* old_source_file = NULL;
	ValaSemanticAnalyzer* _tmp51_;
	ValaSemanticAnalyzer* _tmp52_;
	ValaSourceFile* _tmp53_;
	ValaSourceFile* _tmp54_;
	ValaSourceFile* _tmp55_;
	ValaSymbol* old_symbol = NULL;
	ValaSemanticAnalyzer* _tmp56_;
	ValaSemanticAnalyzer* _tmp57_;
	ValaSymbol* _tmp58_;
	ValaSymbol* _tmp59_;
	ValaSymbol* _tmp60_;
	ValaSourceReference* _tmp61_;
	ValaSourceReference* _tmp62_;
	ValaSemanticAnalyzer* _tmp69_;
	ValaSemanticAnalyzer* _tmp70_;
	ValaDataType* _tmp71_;
	ValaDataType* _tmp72_;
	ValaDataType* _tmp75_;
	ValaDataType* _tmp76_;
	gboolean _tmp77_ = FALSE;
	ValaPropertyAccessor* _tmp78_;
	ValaPropertyAccessor* _tmp79_;
	ValaPropertyAccessor* _tmp88_;
	ValaPropertyAccessor* _tmp89_;
	ValaPropertyAccessor* _tmp92_;
	ValaPropertyAccessor* _tmp93_;
	ValaExpression* _tmp96_;
	ValaExpression* _tmp97_;
	ValaSemanticAnalyzer* _tmp100_;
	ValaSemanticAnalyzer* _tmp101_;
	ValaDataType* _tmp102_;
	ValaDataType* _tmp103_;
	gboolean _tmp114_ = FALSE;
	gboolean _tmp115_;
	gboolean _tmp124_ = FALSE;
	gboolean _tmp125_ = FALSE;
	gboolean _tmp126_ = FALSE;
	gboolean _tmp127_;
	gboolean _tmp128_;
	gboolean _tmp144_ = FALSE;
	ValaPropertyAccessor* _tmp145_;
	ValaPropertyAccessor* _tmp146_;
	gboolean _tmp159_ = FALSE;
	gboolean _tmp160_ = FALSE;
	gboolean _tmp161_ = FALSE;
	ValaExpression* _tmp162_;
	ValaExpression* _tmp163_;
	ValaSemanticAnalyzer* _tmp194_;
	ValaSemanticAnalyzer* _tmp195_;
	ValaSourceFile* _tmp196_;
	ValaSemanticAnalyzer* _tmp197_;
	ValaSemanticAnalyzer* _tmp198_;
	ValaSymbol* _tmp199_;
	gboolean _tmp200_;
	gboolean _tmp201_;
	self = (ValaProperty*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = vala_code_node_get_checked ((ValaCodeNode*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = vala_code_node_get_error ((ValaCodeNode*) self);
		_tmp3_ = _tmp2_;
		result = !_tmp3_;
		return result;
	}
	vala_code_node_set_checked ((ValaCodeNode*) self, TRUE);
	_tmp4_ = self->priv->_is_abstract;
	if (_tmp4_) {
		ValaSymbol* _tmp5_;
		ValaSymbol* _tmp6_;
		_tmp5_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
		_tmp6_ = _tmp5_;
		if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, VALA_TYPE_CLASS)) {
			ValaClass* cl = NULL;
			ValaSymbol* _tmp7_;
			ValaSymbol* _tmp8_;
			ValaClass* _tmp9_;
			ValaClass* _tmp10_;
			gboolean _tmp11_;
			gboolean _tmp12_;
			_tmp7_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp8_ = _tmp7_;
			_tmp9_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, VALA_TYPE_CLASS, ValaClass));
			cl = _tmp9_;
			_tmp10_ = cl;
			_tmp11_ = vala_class_get_is_abstract (_tmp10_);
			_tmp12_ = _tmp11_;
			if (!_tmp12_) {
				ValaSourceReference* _tmp13_;
				ValaSourceReference* _tmp14_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp13_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp14_ = _tmp13_;
				vala_report_error (_tmp14_, "Abstract properties may not be declared in non-abstract classes");
				result = FALSE;
				_vala_code_node_unref0 (cl);
				return result;
			}
			_vala_code_node_unref0 (cl);
		} else {
			ValaSymbol* _tmp15_;
			ValaSymbol* _tmp16_;
			_tmp15_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp16_ = _tmp15_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp16_, VALA_TYPE_INTERFACE)) {
				ValaSourceReference* _tmp17_;
				ValaSourceReference* _tmp18_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp17_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp18_ = _tmp17_;
				vala_report_error (_tmp18_, "Abstract properties may not be declared outside of classes and interfa" \
"ces");
				result = FALSE;
				return result;
			}
		}
	} else {
		gboolean _tmp19_;
		_tmp19_ = self->priv->_is_virtual;
		if (_tmp19_) {
			gboolean _tmp20_ = FALSE;
			ValaSymbol* _tmp21_;
			ValaSymbol* _tmp22_;
			ValaSymbol* _tmp27_;
			ValaSymbol* _tmp28_;
			_tmp21_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp22_ = _tmp21_;
			if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp22_, VALA_TYPE_CLASS)) {
				ValaSymbol* _tmp23_;
				ValaSymbol* _tmp24_;
				_tmp23_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp24_ = _tmp23_;
				_tmp20_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp24_, VALA_TYPE_INTERFACE);
			} else {
				_tmp20_ = FALSE;
			}
			if (_tmp20_) {
				ValaSourceReference* _tmp25_;
				ValaSourceReference* _tmp26_;
				vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
				_tmp25_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
				_tmp26_ = _tmp25_;
				vala_report_error (_tmp26_, "Virtual properties may not be declared outside of classes and interfac" \
"es");
				result = FALSE;
				return result;
			}
			_tmp27_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
			_tmp28_ = _tmp27_;
			if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp28_, VALA_TYPE_CLASS)) {
				ValaClass* cl = NULL;
				ValaSymbol* _tmp29_;
				ValaSymbol* _tmp30_;
				ValaClass* _tmp31_;
				ValaClass* _tmp32_;
				gboolean _tmp33_;
				gboolean _tmp34_;
				_tmp29_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp30_ = _tmp29_;
				_tmp31_ = _vala_code_node_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, VALA_TYPE_CLASS, ValaClass));
				cl = _tmp31_;
				_tmp32_ = cl;
				_tmp33_ = vala_class_get_is_compact (_tmp32_);
				_tmp34_ = _tmp33_;
				if (_tmp34_) {
					ValaSourceReference* _tmp35_;
					ValaSourceReference* _tmp36_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp35_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp36_ = _tmp35_;
					vala_report_error (_tmp36_, "Virtual properties may not be declared in compact classes");
					result = FALSE;
					_vala_code_node_unref0 (cl);
					return result;
				}
				_vala_code_node_unref0 (cl);
			}
		} else {
			gboolean _tmp37_;
			_tmp37_ = self->priv->_overrides;
			if (_tmp37_) {
				ValaSymbol* _tmp38_;
				ValaSymbol* _tmp39_;
				_tmp38_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
				_tmp39_ = _tmp38_;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp39_, VALA_TYPE_CLASS)) {
					ValaSourceReference* _tmp40_;
					ValaSourceReference* _tmp41_;
					vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
					_tmp40_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
					_tmp41_ = _tmp40_;
					vala_report_error (_tmp41_, "Properties may not be overridden outside of classes");
					result = FALSE;
					return result;
				}
			} else {
				ValaSymbolAccessibility _tmp42_;
				ValaSymbolAccessibility _tmp43_;
				_tmp42_ = vala_symbol_get_access ((ValaSymbol*) self);
				_tmp43_ = _tmp42_;
				if (_tmp43_ == VALA_SYMBOL_ACCESSIBILITY_PROTECTED) {
					gboolean _tmp44_ = FALSE;
					ValaSymbol* _tmp45_;
					ValaSymbol* _tmp46_;
					_tmp45_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
					_tmp46_ = _tmp45_;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp46_, VALA_TYPE_CLASS)) {
						ValaSymbol* _tmp47_;
						ValaSymbol* _tmp48_;
						_tmp47_ = vala_symbol_get_parent_symbol ((ValaSymbol*) self);
						_tmp48_ = _tmp47_;
						_tmp44_ = !G_TYPE_CHECK_INSTANCE_TYPE (_tmp48_, VALA_TYPE_INTERFACE);
					} else {
						_tmp44_ = FALSE;
					}
					if (_tmp44_) {
						ValaSourceReference* _tmp49_;
						ValaSourceReference* _tmp50_;
						vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
						_tmp49_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
						_tmp50_ = _tmp49_;
						vala_report_error (_tmp50_, "Protected properties may not be declared outside of classes and interf" \
"aces");
						result = FALSE;
						return result;
					}
				}
			}
		}
	}
	_tmp51_ = vala_code_context_get_analyzer (context);
	_tmp52_ = _tmp51_;
	_tmp53_ = vala_semantic_analyzer_get_current_source_file (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = _vala_source_file_ref0 (_tmp54_);
	old_source_file = _tmp55_;
	_tmp56_ = vala_code_context_get_analyzer (context);
	_tmp57_ = _tmp56_;
	_tmp58_ = vala_semantic_analyzer_get_current_symbol (_tmp57_);
	_tmp59_ = _tmp58_;
	_tmp60_ = _vala_code_node_ref0 (_tmp59_);
	old_symbol = _tmp60_;
	_tmp61_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
	_tmp62_ = _tmp61_;
	if (_tmp62_ != NULL) {
		ValaSemanticAnalyzer* _tmp63_;
		ValaSemanticAnalyzer* _tmp64_;
		ValaSourceReference* _tmp65_;
		ValaSourceReference* _tmp66_;
		ValaSourceFile* _tmp67_;
		ValaSourceFile* _tmp68_;
		_tmp63_ = vala_code_context_get_analyzer (context);
		_tmp64_ = _tmp63_;
		_tmp65_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp66_ = _tmp65_;
		_tmp67_ = vala_source_reference_get_file (_tmp66_);
		_tmp68_ = _tmp67_;
		vala_semantic_analyzer_set_current_source_file (_tmp64_, _tmp68_);
	}
	_tmp69_ = vala_code_context_get_analyzer (context);
	_tmp70_ = _tmp69_;
	vala_semantic_analyzer_set_current_symbol (_tmp70_, (ValaSymbol*) self);
	_tmp71_ = vala_property_get_property_type (self);
	_tmp72_ = _tmp71_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp72_, VALA_TYPE_VOID_TYPE)) {
		ValaSourceReference* _tmp73_;
		ValaSourceReference* _tmp74_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp73_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp74_ = _tmp73_;
		vala_report_error (_tmp74_, "'void' not supported as property type");
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp75_ = vala_property_get_property_type (self);
	_tmp76_ = _tmp75_;
	vala_code_node_check ((ValaCodeNode*) _tmp76_, context);
	_tmp78_ = vala_property_get_get_accessor (self);
	_tmp79_ = _tmp78_;
	if (_tmp79_ == NULL) {
		ValaPropertyAccessor* _tmp80_;
		ValaPropertyAccessor* _tmp81_;
		_tmp80_ = vala_property_get_set_accessor (self);
		_tmp81_ = _tmp80_;
		_tmp77_ = _tmp81_ == NULL;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		ValaSourceReference* _tmp82_;
		ValaSourceReference* _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp82_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp83_ = _tmp82_;
		_tmp84_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp85_ = _tmp84_;
		_tmp86_ = g_strdup_printf ("Property `%s' must have a `get' accessor and/or a `set' mutator", _tmp85_);
		_tmp87_ = _tmp86_;
		vala_report_error (_tmp83_, _tmp87_);
		_g_free0 (_tmp87_);
		_g_free0 (_tmp85_);
		result = FALSE;
		_vala_code_node_unref0 (old_symbol);
		_vala_source_file_unref0 (old_source_file);
		return result;
	}
	_tmp88_ = vala_property_get_get_accessor (self);
	_tmp89_ = _tmp88_;
	if (_tmp89_ != NULL) {
		ValaPropertyAccessor* _tmp90_;
		ValaPropertyAccessor* _tmp91_;
		_tmp90_ = vala_property_get_get_accessor (self);
		_tmp91_ = _tmp90_;
		vala_code_node_check ((ValaCodeNode*) _tmp91_, context);
	}
	_tmp92_ = vala_property_get_set_accessor (self);
	_tmp93_ = _tmp92_;
	if (_tmp93_ != NULL) {
		ValaPropertyAccessor* _tmp94_;
		ValaPropertyAccessor* _tmp95_;
		_tmp94_ = vala_property_get_set_accessor (self);
		_tmp95_ = _tmp94_;
		vala_code_node_check ((ValaCodeNode*) _tmp95_, context);
	}
	_tmp96_ = vala_property_get_initializer (self);
	_tmp97_ = _tmp96_;
	if (_tmp97_ != NULL) {
		ValaExpression* _tmp98_;
		ValaExpression* _tmp99_;
		_tmp98_ = vala_property_get_initializer (self);
		_tmp99_ = _tmp98_;
		vala_code_node_check ((ValaCodeNode*) _tmp99_, context);
	}
	_tmp100_ = vala_code_context_get_analyzer (context);
	_tmp101_ = _tmp100_;
	_tmp102_ = vala_property_get_property_type (self);
	_tmp103_ = _tmp102_;
	if (!vala_semantic_analyzer_is_type_accessible (_tmp101_, (ValaSymbol*) self, _tmp103_)) {
		ValaSourceReference* _tmp104_;
		ValaSourceReference* _tmp105_;
		ValaDataType* _tmp106_;
		ValaDataType* _tmp107_;
		gchar* _tmp108_;
		gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp104_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp105_ = _tmp104_;
		_tmp106_ = vala_property_get_property_type (self);
		_tmp107_ = _tmp106_;
		_tmp108_ = vala_code_node_to_string ((ValaCodeNode*) _tmp107_);
		_tmp109_ = _tmp108_;
		_tmp110_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strdup_printf ("property type `%s` is less accessible than property `%s`", _tmp109_, _tmp111_);
		_tmp113_ = _tmp112_;
		vala_report_error (_tmp105_, _tmp113_);
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
		_g_free0 (_tmp109_);
	}
	_tmp115_ = self->priv->_overrides;
	if (_tmp115_) {
		ValaProperty* _tmp116_;
		ValaProperty* _tmp117_;
		_tmp116_ = vala_property_get_base_property (self);
		_tmp117_ = _tmp116_;
		_tmp114_ = _tmp117_ == NULL;
	} else {
		_tmp114_ = FALSE;
	}
	if (_tmp114_) {
		ValaSourceReference* _tmp118_;
		ValaSourceReference* _tmp119_;
		gchar* _tmp120_;
		gchar* _tmp121_;
		gchar* _tmp122_;
		gchar* _tmp123_;
		_tmp118_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp119_ = _tmp118_;
		_tmp120_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp121_ = _tmp120_;
		_tmp122_ = g_strdup_printf ("%s: no suitable property found to override", _tmp121_);
		_tmp123_ = _tmp122_;
		vala_report_error (_tmp119_, _tmp123_);
		_g_free0 (_tmp123_);
		_g_free0 (_tmp121_);
	}
	_tmp127_ = vala_symbol_get_external_package ((ValaSymbol*) self);
	_tmp128_ = _tmp127_;
	if (!_tmp128_) {
		gboolean _tmp129_;
		_tmp129_ = self->priv->_overrides;
		_tmp126_ = !_tmp129_;
	} else {
		_tmp126_ = FALSE;
	}
	if (_tmp126_) {
		gboolean _tmp130_;
		gboolean _tmp131_;
		_tmp130_ = vala_symbol_get_hides ((ValaSymbol*) self);
		_tmp131_ = _tmp130_;
		_tmp125_ = !_tmp131_;
	} else {
		_tmp125_ = FALSE;
	}
	if (_tmp125_) {
		ValaSymbol* _tmp132_;
		ValaSymbol* _tmp133_;
		_tmp132_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp133_ = _tmp132_;
		_tmp124_ = _tmp133_ != NULL;
		_vala_code_node_unref0 (_tmp133_);
	} else {
		_tmp124_ = FALSE;
	}
	if (_tmp124_) {
		ValaSourceReference* _tmp134_;
		ValaSourceReference* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		ValaSymbol* _tmp138_;
		ValaSymbol* _tmp139_;
		gchar* _tmp140_;
		gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		_tmp134_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
		_tmp135_ = _tmp134_;
		_tmp136_ = vala_symbol_get_full_name ((ValaSymbol*) self);
		_tmp137_ = _tmp136_;
		_tmp138_ = vala_symbol_get_hidden_member ((ValaSymbol*) self);
		_tmp139_ = _tmp138_;
		_tmp140_ = vala_symbol_get_full_name (_tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = g_strdup_printf ("%s hides inherited property `%s'. Use the `new' keyword if hiding was " \
"intentional", _tmp137_, _tmp141_);
		_tmp143_ = _tmp142_;
		vala_report_warning (_tmp135_, _tmp143_);
		_g_free0 (_tmp143_);
		_g_free0 (_tmp141_);
		_vala_code_node_unref0 (_tmp139_);
		_g_free0 (_tmp137_);
	}
	_tmp145_ = vala_property_get_set_accessor (self);
	_tmp146_ = _tmp145_;
	if (_tmp146_ != NULL) {
		ValaPropertyAccessor* _tmp147_;
		ValaPropertyAccessor* _tmp148_;
		gboolean _tmp149_;
		gboolean _tmp150_;
		_tmp147_ = vala_property_get_set_accessor (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = vala_property_accessor_get_construction (_tmp148_);
		_tmp150_ = _tmp149_;
		_tmp144_ = _tmp150_;
	} else {
		_tmp144_ = FALSE;
	}
	if (_tmp144_) {
		ValaSymbolAccessibility _tmp151_;
		ValaSymbolAccessibility _tmp152_;
		_tmp151_ = vala_symbol_get_access ((ValaSymbol*) self);
		_tmp152_ = _tmp151_;
		if (_tmp152_ != VALA_SYMBOL_ACCESSIBILITY_PUBLIC) {
			ValaSourceReference* _tmp153_;
			ValaSourceReference* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			gchar* _tmp157_;
			gchar* _tmp158_;
			vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
			_tmp153_ = vala_code_node_get_source_reference ((ValaCodeNode*) self);
			_tmp154_ = _tmp153_;
			_tmp155_ = vala_symbol_get_full_name ((ValaSymbol*) self);
			_tmp156_ = _tmp155_;
			_tmp157_ = g_strdup_printf ("%s: construct properties must be public", _tmp156_);
			_tmp158_ = _tmp157_;
			vala_report_error (_tmp154_, _tmp158_);
			_g_free0 (_tmp158_);
			_g_free0 (_tmp156_);
		}
	}
	_tmp162_ = vala_property_get_initializer (self);
	_tmp163_ = _tmp162_;
	if (_tmp163_ != NULL) {
		ValaExpression* _tmp164_;
		ValaExpression* _tmp165_;
		gboolean _tmp166_;
		gboolean _tmp167_;
		_tmp164_ = vala_property_get_initializer (self);
		_tmp165_ = _tmp164_;
		_tmp166_ = vala_code_node_get_error ((ValaCodeNode*) _tmp165_);
		_tmp167_ = _tmp166_;
		_tmp161_ = !_tmp167_;
	} else {
		_tmp161_ = FALSE;
	}
	if (_tmp161_) {
		ValaExpression* _tmp168_;
		ValaExpression* _tmp169_;
		ValaDataType* _tmp170_;
		ValaDataType* _tmp171_;
		_tmp168_ = vala_property_get_initializer (self);
		_tmp169_ = _tmp168_;
		_tmp170_ = vala_expression_get_value_type (_tmp169_);
		_tmp171_ = _tmp170_;
		_tmp160_ = _tmp171_ != NULL;
	} else {
		_tmp160_ = FALSE;
	}
	if (_tmp160_) {
		ValaExpression* _tmp172_;
		ValaExpression* _tmp173_;
		ValaDataType* _tmp174_;
		ValaDataType* _tmp175_;
		ValaDataType* _tmp176_;
		ValaDataType* _tmp177_;
		_tmp172_ = vala_property_get_initializer (self);
		_tmp173_ = _tmp172_;
		_tmp174_ = vala_expression_get_value_type (_tmp173_);
		_tmp175_ = _tmp174_;
		_tmp176_ = vala_property_get_property_type (self);
		_tmp177_ = _tmp176_;
		_tmp159_ = !vala_data_type_compatible (_tmp175_, _tmp177_);
	} else {
		_tmp159_ = FALSE;
	}
	if (_tmp159_) {
		ValaExpression* _tmp178_;
		ValaExpression* _tmp179_;
		ValaSourceReference* _tmp180_;
		ValaSourceReference* _tmp181_;
		ValaDataType* _tmp182_;
		ValaDataType* _tmp183_;
		gchar* _tmp184_;
		gchar* _tmp185_;
		ValaExpression* _tmp186_;
		ValaExpression* _tmp187_;
		ValaDataType* _tmp188_;
		ValaDataType* _tmp189_;
		gchar* _tmp190_;
		gchar* _tmp191_;
		gchar* _tmp192_;
		gchar* _tmp193_;
		vala_code_node_set_error ((ValaCodeNode*) self, TRUE);
		_tmp178_ = vala_property_get_initializer (self);
		_tmp179_ = _tmp178_;
		_tmp180_ = vala_code_node_get_source_reference ((ValaCodeNode*) _tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = vala_property_get_property_type (self);
		_tmp183_ = _tmp182_;
		_tmp184_ = vala_code_node_to_string ((ValaCodeNode*) _tmp183_);
		_tmp185_ = _tmp184_;
		_tmp186_ = vala_property_get_initializer (self);
		_tmp187_ = _tmp186_;
		_tmp188_ = vala_expression_get_value_type (_tmp187_);
		_tmp189_ = _tmp188_;
		_tmp190_ = vala_code_node_to_string ((ValaCodeNode*) _tmp189_);
		_tmp191_ = _tmp190_;
		_tmp192_ = g_strdup_printf ("Expected initializer of type `%s' but got `%s'", _tmp185_, _tmp191_);
		_tmp193_ = _tmp192_;
		vala_report_error (_tmp181_, _tmp193_);
		_g_free0 (_tmp193_);
		_g_free0 (_tmp191_);
		_g_free0 (_tmp185_);
	}
	_tmp194_ = vala_code_context_get_analyzer (context);
	_tmp195_ = _tmp194_;
	_tmp196_ = old_source_file;
	vala_semantic_analyzer_set_current_source_file (_tmp195_, _tmp196_);
	_tmp197_ = vala_code_context_get_analyzer (context);
	_tmp198_ = _tmp197_;
	_tmp199_ = old_symbol;
	vala_semantic_analyzer_set_current_symbol (_tmp198_, _tmp199_);
	_tmp200_ = vala_code_node_get_error ((ValaCodeNode*) self);
	_tmp201_ = _tmp200_;
	result = !_tmp201_;
	_vala_code_node_unref0 (old_symbol);
	_vala_source_file_unref0 (old_source_file);
	return result;
}


ValaDataType*
vala_property_get_property_type (ValaProperty* self)
{
	ValaDataType* result;
	ValaDataType* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_data_type;
	result = _tmp0_;
	return result;
}


void
vala_property_set_property_type (ValaProperty* self,
                                 ValaDataType* value)
{
	ValaDataType* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_data_type);
	self->priv->_data_type = _tmp0_;
	if (value != NULL) {
		ValaDataType* _tmp1_;
		_tmp1_ = self->priv->_data_type;
		vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
	}
}


ValaPropertyAccessor*
vala_property_get_get_accessor (ValaProperty* self)
{
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_get_accessor;
	result = _tmp0_;
	return result;
}


void
vala_property_set_get_accessor (ValaProperty* self,
                                ValaPropertyAccessor* value)
{
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	self->priv->_get_accessor = _tmp0_;
	if (value != NULL) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}


ValaPropertyAccessor*
vala_property_get_set_accessor (ValaProperty* self)
{
	ValaPropertyAccessor* result;
	ValaPropertyAccessor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_set_accessor;
	result = _tmp0_;
	return result;
}


void
vala_property_set_set_accessor (ValaProperty* self,
                                ValaPropertyAccessor* value)
{
	ValaPropertyAccessor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	self->priv->_set_accessor = _tmp0_;
	if (value != NULL) {
		ValaScope* _tmp1_;
		ValaScope* _tmp2_;
		_tmp1_ = vala_symbol_get_scope ((ValaSymbol*) self);
		_tmp2_ = _tmp1_;
		vala_symbol_set_owner ((ValaSymbol*) value, _tmp2_);
	}
}


ValaParameter*
vala_property_get_this_parameter (ValaProperty* self)
{
	ValaParameter* result;
	ValaParameter* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_this_parameter;
	result = _tmp0_;
	return result;
}


void
vala_property_set_this_parameter (ValaProperty* self,
                                  ValaParameter* value)
{
	ValaParameter* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	self->priv->_this_parameter = _tmp0_;
}


gboolean
vala_property_get_interface_only (ValaProperty* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_interface_only;
	result = _tmp0_;
	return result;
}


void
vala_property_set_interface_only (ValaProperty* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_interface_only = value;
}


gboolean
vala_property_get_is_abstract (ValaProperty* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_abstract;
	result = _tmp0_;
	return result;
}


void
vala_property_set_is_abstract (ValaProperty* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_abstract = value;
}


gboolean
vala_property_get_is_virtual (ValaProperty* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_virtual;
	result = _tmp0_;
	return result;
}


void
vala_property_set_is_virtual (ValaProperty* self,
                              gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_is_virtual = value;
}


gboolean
vala_property_get_overrides (ValaProperty* self)
{
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_overrides;
	result = _tmp0_;
	return result;
}


void
vala_property_set_overrides (ValaProperty* self,
                             gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_overrides = value;
}


ValaField*
vala_property_get_field (ValaProperty* self)
{
	ValaField* result;
	ValaField* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_field;
	result = _tmp0_;
	return result;
}


void
vala_property_set_field (ValaProperty* self,
                         ValaField* value)
{
	ValaField* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_field);
	self->priv->_field = _tmp0_;
}


ValaMemberBinding
vala_property_get_binding (ValaProperty* self)
{
	ValaMemberBinding result;
	ValaMemberBinding _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_binding;
	result = _tmp0_;
	return result;
}


void
vala_property_set_binding (ValaProperty* self,
                           ValaMemberBinding value)
{
	g_return_if_fail (self != NULL);
	self->priv->_binding = value;
}


static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch15_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch15_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally15;
	__catch15_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


const gchar*
vala_property_get_nick (ValaProperty* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nick;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "nick", NULL);
		_g_free0 (self->priv->_nick);
		self->priv->_nick = _tmp1_;
		_tmp2_ = self->priv->_nick;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_nick);
			self->priv->_nick = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_nick;
	result = _tmp6_;
	return result;
}


const gchar*
vala_property_get_blurb (ValaProperty* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp6_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_blurb;
	if (_tmp0_ == NULL) {
		gchar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_string ((ValaCodeNode*) self, "Description", "blurb", NULL);
		_g_free0 (self->priv->_blurb);
		self->priv->_blurb = _tmp1_;
		_tmp2_ = self->priv->_blurb;
		if (_tmp2_ == NULL) {
			const gchar* _tmp3_;
			const gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp3_ = vala_symbol_get_name ((ValaSymbol*) self);
			_tmp4_ = _tmp3_;
			_tmp5_ = string_replace (_tmp4_, "_", "-");
			_g_free0 (self->priv->_blurb);
			self->priv->_blurb = _tmp5_;
		}
	}
	_tmp6_ = self->priv->_blurb;
	result = _tmp6_;
	return result;
}


static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}


static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}


gboolean
vala_property_get_notify (ValaProperty* self)
{
	gboolean result;
	gboolean* _tmp0_;
	gboolean* _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_notify;
	if (_tmp0_ == NULL) {
		gboolean _tmp1_;
		gboolean* _tmp2_;
		_tmp1_ = vala_code_node_get_attribute_bool ((ValaCodeNode*) self, "CCode", "notify", TRUE);
		_tmp2_ = __bool_dup0 (&_tmp1_);
		_g_free0 (self->priv->_notify);
		self->priv->_notify = _tmp2_;
	}
	_tmp3_ = self->priv->_notify;
	result = *_tmp3_;
	return result;
}


ValaProperty*
vala_property_get_base_property (ValaProperty* self)
{
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_property;
	result = _tmp0_;
	return result;
}


ValaProperty*
vala_property_get_base_interface_property (ValaProperty* self)
{
	ValaProperty* result;
	ValaProperty* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	vala_property_find_base_properties (self);
	_tmp0_ = self->priv->_base_interface_property;
	result = _tmp0_;
	return result;
}


ValaExpression*
vala_property_get_initializer (ValaProperty* self)
{
	ValaExpression* result;
	ValaExpression* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initializer;
	result = _tmp0_;
	return result;
}


void
vala_property_set_initializer (ValaProperty* self,
                               ValaExpression* value)
{
	ValaExpression* _tmp0_;
	ValaExpression* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _vala_code_node_ref0 (value);
	_vala_code_node_unref0 (self->priv->_initializer);
	self->priv->_initializer = _tmp0_;
	_tmp1_ = self->priv->_initializer;
	vala_code_node_set_parent_node ((ValaCodeNode*) _tmp1_, (ValaCodeNode*) self);
}


static void
vala_property_class_init (ValaPropertyClass * klass)
{
	vala_property_parent_class = g_type_class_peek_parent (klass);
	((ValaCodeNodeClass *) klass)->finalize = vala_property_finalize;
	g_type_class_add_private (klass, sizeof (ValaPropertyPrivate));
	((ValaCodeNodeClass *) klass)->accept = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_real_accept;
	((ValaCodeNodeClass *) klass)->accept_children = (void (*) (ValaCodeNode *, ValaCodeVisitor*)) vala_property_real_accept_children;
	((ValaCodeNodeClass *) klass)->replace_type = (void (*) (ValaCodeNode *, ValaDataType*, ValaDataType*)) vala_property_real_replace_type;
	((ValaCodeNodeClass *) klass)->replace_expression = (void (*) (ValaCodeNode *, ValaExpression*, ValaExpression*)) vala_property_real_replace_expression;
	((ValaCodeNodeClass *) klass)->check = (gboolean (*) (ValaCodeNode *, ValaCodeContext*)) vala_property_real_check;
}


static void
vala_property_vala_lockable_interface_init (ValaLockableIface * iface)
{
	vala_property_vala_lockable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_lock_used = (gboolean (*) (ValaLockable *)) vala_property_real_get_lock_used;
	iface->set_lock_used = (void (*) (ValaLockable *, gboolean)) vala_property_real_set_lock_used;
}


static void
vala_property_instance_init (ValaProperty * self)
{
	self->priv = VALA_PROPERTY_GET_PRIVATE (self);
	self->priv->_binding = VALA_MEMBER_BINDING_INSTANCE;
	self->priv->lock_used = FALSE;
}


static void
vala_property_finalize (ValaCodeNode * obj)
{
	ValaProperty * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VALA_TYPE_PROPERTY, ValaProperty);
	_vala_code_node_unref0 (self->priv->_this_parameter);
	_vala_code_node_unref0 (self->priv->_field);
	_vala_code_node_unref0 (self->priv->_initializer);
	_vala_code_node_unref0 (self->priv->_data_type);
	_vala_code_node_unref0 (self->priv->_base_interface_property);
	_vala_code_node_unref0 (self->priv->_get_accessor);
	_vala_code_node_unref0 (self->priv->_set_accessor);
	_g_free0 (self->priv->_nick);
	_g_free0 (self->priv->_blurb);
	_g_free0 (self->priv->_notify);
	VALA_CODE_NODE_CLASS (vala_property_parent_class)->finalize (obj);
}


/**
 * Represents a property declaration in the source code.
 */
GType
vala_property_get_type (void)
{
	static volatile gsize vala_property_type_id__volatile = 0;
	if (g_once_init_enter (&vala_property_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ValaPropertyClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) vala_property_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ValaProperty), 0, (GInstanceInitFunc) vala_property_instance_init, NULL };
		static const GInterfaceInfo vala_lockable_info = { (GInterfaceInitFunc) vala_property_vala_lockable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType vala_property_type_id;
		vala_property_type_id = g_type_register_static (VALA_TYPE_SYMBOL, "ValaProperty", &g_define_type_info, 0);
		g_type_add_interface_static (vala_property_type_id, VALA_TYPE_LOCKABLE, &vala_lockable_info);
		g_once_init_leave (&vala_property_type_id__volatile, vala_property_type_id);
	}
	return vala_property_type_id__volatile;
}



