/* filehelper.c generated by valac, the Vala compiler
 * generated from filehelper.vala, do not modify */

/* filehelper.vala
 *
 * Copyright (C) 2008-2009 Florian Brosch
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Brosch Florian <flo.brosch@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include "valadoc.h"
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <glib/gstdio.h>

#define _fclose0(var) ((var == NULL) ? NULL : (var = (fclose (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_dir_close0(var) ((var == NULL) ? NULL : (var = (g_dir_close (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))



G_GNUC_INTERNAL gboolean valadoc_ends_with_dir_separator (const gchar* s);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


/**
 * Makes a copy of the file src to dest. 
 *
 * @param src the file to copy
 * @param dest the destination path
 */
gboolean
valadoc_copy_file (const gchar* src,
                   const gchar* dest)
{
	gboolean result = FALSE;
	FILE* fsrc = NULL;
	FILE* _tmp0_;
	FILE* _tmp1_;
	FILE* fdest = NULL;
	FILE* _tmp2_;
	FILE* _tmp3_;
	g_return_val_if_fail (src != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	_tmp0_ = g_fopen (src, "rb");
	fsrc = _tmp0_;
	_tmp1_ = fsrc;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_fclose0 (fsrc);
		return result;
	}
	_tmp2_ = g_fopen (dest, "wb");
	fdest = _tmp2_;
	_tmp3_ = fdest;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_fclose0 (fdest);
		_fclose0 (fsrc);
		return result;
	}
	{
		gint c = 0;
		FILE* _tmp4_;
		_tmp4_ = fsrc;
		c = fgetc (_tmp4_);
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				FILE* _tmp7_;
				FILE* _tmp8_;
				gint _tmp9_;
				if (!_tmp5_) {
					FILE* _tmp6_;
					_tmp6_ = fsrc;
					c = fgetc (_tmp6_);
				}
				_tmp5_ = FALSE;
				_tmp7_ = fsrc;
				if (!(!feof (_tmp7_))) {
					break;
				}
				_tmp8_ = fdest;
				_tmp9_ = c;
				fputc ((gchar) _tmp9_, _tmp8_);
			}
		}
	}
	result = TRUE;
	_fclose0 (fdest);
	_fclose0 (fsrc);
	return result;
}


/**
 * Makes a copy of the directory src to dest. 
 *
 * @param src the directory to copy
 * @param dest the destination path
 */
gboolean
valadoc_copy_directory (const gchar* src,
                        const gchar* dest)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (src != NULL, FALSE);
	g_return_val_if_fail (dest != NULL, FALSE);
	{
		GDir* dir = NULL;
		GDir* _tmp0_;
		_tmp0_ = g_dir_open (src, (guint) 0, &_inner_error_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch1_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp1_;
		}
		{
			gchar* file = NULL;
			const gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_dir_read_name (dir);
			_tmp3_ = g_strdup (_tmp2_);
			file = _tmp3_;
			{
				gboolean _tmp4_ = FALSE;
				_tmp4_ = TRUE;
				while (TRUE) {
					const gchar* _tmp7_;
					gchar* src_file_path = NULL;
					const gchar* _tmp8_;
					gchar* _tmp9_;
					gchar* dest_file_path = NULL;
					const gchar* _tmp10_;
					gchar* _tmp11_;
					const gchar* _tmp12_;
					if (!_tmp4_) {
						const gchar* _tmp5_;
						gchar* _tmp6_;
						_tmp5_ = g_dir_read_name (dir);
						_tmp6_ = g_strdup (_tmp5_);
						_g_free0 (file);
						file = _tmp6_;
					}
					_tmp4_ = FALSE;
					_tmp7_ = file;
					if (!(_tmp7_ != NULL)) {
						break;
					}
					_tmp8_ = file;
					_tmp9_ = g_build_filename (src, _tmp8_, NULL);
					src_file_path = _tmp9_;
					_tmp10_ = file;
					_tmp11_ = g_build_filename (dest, _tmp10_, NULL);
					dest_file_path = _tmp11_;
					_tmp12_ = src_file_path;
					if (g_file_test (_tmp12_, G_FILE_TEST_IS_DIR)) {
						const gchar* _tmp13_;
						const gchar* _tmp14_;
						const gchar* _tmp15_;
						_tmp13_ = dest_file_path;
						g_mkdir (_tmp13_, 0755);
						_tmp14_ = src_file_path;
						_tmp15_ = dest_file_path;
						if (!valadoc_copy_directory (_tmp14_, _tmp15_)) {
							result = FALSE;
							_g_free0 (dest_file_path);
							_g_free0 (src_file_path);
							_g_free0 (file);
							_g_dir_close0 (dir);
							return result;
						}
					} else {
						const gchar* _tmp16_;
						const gchar* _tmp17_;
						_tmp16_ = src_file_path;
						_tmp17_ = dest_file_path;
						if (!valadoc_copy_file (_tmp16_, _tmp17_)) {
							result = FALSE;
							_g_free0 (dest_file_path);
							_g_free0 (src_file_path);
							_g_free0 (file);
							_g_dir_close0 (dir);
							return result;
						}
					}
					_g_free0 (dest_file_path);
					_g_free0 (src_file_path);
				}
			}
			_g_free0 (file);
		}
		_g_dir_close0 (dir);
	}
	goto __finally1;
	__catch1_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp18_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp18_;
	}
	result = TRUE;
	return result;
}


/**
 * A recursive directory delete function
 *
 * @param rpath the directory to remove
 */
gboolean
valadoc_remove_directory (const gchar* rpath)
{
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (rpath != NULL, FALSE);
	{
		GDir* dir = NULL;
		GDir* _tmp0_;
		GDir* _tmp2_;
		_tmp0_ = g_dir_open (rpath, (guint) 0, &_inner_error_);
		dir = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch2_g_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return _tmp1_;
		}
		_tmp2_ = dir;
		if (_tmp2_ == NULL) {
			result = FALSE;
			_g_dir_close0 (dir);
			return result;
		}
		{
			const gchar* entry = NULL;
			GDir* _tmp3_;
			const gchar* _tmp4_;
			_tmp3_ = dir;
			_tmp4_ = g_dir_read_name (_tmp3_);
			entry = _tmp4_;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					const gchar* _tmp8_;
					gchar* path = NULL;
					const gchar* _tmp9_;
					gchar* _tmp10_;
					gboolean is_dir = FALSE;
					const gchar* _tmp11_;
					gboolean _tmp12_;
					if (!_tmp5_) {
						GDir* _tmp6_;
						const gchar* _tmp7_;
						_tmp6_ = dir;
						_tmp7_ = g_dir_read_name (_tmp6_);
						entry = _tmp7_;
					}
					_tmp5_ = FALSE;
					_tmp8_ = entry;
					if (!(_tmp8_ != NULL)) {
						break;
					}
					_tmp9_ = entry;
					_tmp10_ = g_strconcat (rpath, _tmp9_, NULL);
					path = _tmp10_;
					_tmp11_ = path;
					is_dir = g_file_test (_tmp11_, G_FILE_TEST_IS_DIR);
					_tmp12_ = is_dir;
					if (_tmp12_ == TRUE) {
						gboolean tmp = FALSE;
						const gchar* _tmp13_;
						gboolean _tmp14_;
						_tmp13_ = path;
						tmp = valadoc_remove_directory (_tmp13_);
						_tmp14_ = tmp;
						if (_tmp14_ == FALSE) {
							result = FALSE;
							_g_free0 (path);
							_g_dir_close0 (dir);
							return result;
						}
					} else {
						gint tmp = 0;
						const gchar* _tmp15_;
						gint _tmp16_;
						_tmp15_ = path;
						tmp = g_unlink (_tmp15_);
						_tmp16_ = tmp;
						if (_tmp16_ > 0) {
							result = FALSE;
							_g_free0 (path);
							_g_dir_close0 (dir);
							return result;
						}
					}
					_g_free0 (path);
				}
			}
		}
		_g_dir_close0 (dir);
	}
	goto __finally2;
	__catch2_g_file_error:
	{
		GError* err = NULL;
		err = _inner_error_;
		_inner_error_ = NULL;
		result = FALSE;
		_g_error_free0 (err);
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp17_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp17_;
	}
	result = TRUE;
	return result;
}


static gunichar
string_get_char (const gchar* self,
                 glong index)
{
	gunichar result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	result = g_utf8_get_char (((gchar*) self) + index);
	return result;
}


G_GNUC_INTERNAL inline gboolean
valadoc_ends_with_dir_separator (const gchar* s)
{
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
	g_return_val_if_fail (s != NULL, FALSE);
	_tmp0_ = strlen (s);
	_tmp1_ = _tmp0_;
	result = G_IS_DIR_SEPARATOR (string_get_char (s, (glong) (_tmp1_ - 1)));
	return result;
}


/**
 * Returns canonicalized absolute pathname
 *
 * @param name the path being checked
 * @return a canonicalized absolute pathname
 */
static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	glong result = 0L;
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}


static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	gchar* result = NULL;
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	glong _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		glong _tmp3_;
		_tmp3_ = string_length;
		offset = _tmp3_ + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		glong _tmp4_;
		_tmp4_ = string_length;
		g_return_val_if_fail (offset <= _tmp4_, NULL);
	}
	if (len < ((glong) 0)) {
		glong _tmp5_;
		_tmp5_ = string_length;
		len = _tmp5_ - offset;
	}
	_tmp6_ = string_length;
	g_return_val_if_fail ((offset + len) <= _tmp6_, NULL);
	_tmp7_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp7_;
	return result;
}


static gchar*
_vala_g_strjoinv (const gchar* separator,
                  gchar** str_array,
                  int str_array_length1)
{
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	if (separator == NULL) {
		separator = "";
	}
	if (str_array != NULL) {
		gboolean _tmp1_ = FALSE;
		if (str_array_length1 > 0) {
			_tmp1_ = TRUE;
		} else {
			gboolean _tmp2_ = FALSE;
			if (str_array_length1 == -1) {
				const gchar* _tmp3_;
				_tmp3_ = str_array[0];
				_tmp2_ = _tmp3_ != NULL;
			} else {
				_tmp2_ = FALSE;
			}
			_tmp1_ = _tmp2_;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp20_;
		gint _tmp22_;
		gint _tmp23_;
		gsize _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		const gchar* res = NULL;
		gsize _tmp28_;
		void* _tmp29_;
		void* ptr = NULL;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		void* _tmp32_;
		const gchar* _tmp45_;
		len = (gsize) 1;
		{
			gboolean _tmp4_ = FALSE;
			i = 0;
			_tmp4_ = TRUE;
			while (TRUE) {
				gboolean _tmp6_ = FALSE;
				gboolean _tmp7_ = FALSE;
				gint _tmp12_ = 0;
				gint _tmp13_;
				const gchar* _tmp14_;
				gsize _tmp19_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (str_array_length1 != -1) {
					gint _tmp8_;
					_tmp8_ = i;
					_tmp7_ = _tmp8_ < str_array_length1;
				} else {
					_tmp7_ = FALSE;
				}
				if (_tmp7_) {
					_tmp6_ = TRUE;
				} else {
					gboolean _tmp9_ = FALSE;
					if (str_array_length1 == -1) {
						gint _tmp10_;
						const gchar* _tmp11_;
						_tmp10_ = i;
						_tmp11_ = str_array[_tmp10_];
						_tmp9_ = _tmp11_ != NULL;
					} else {
						_tmp9_ = FALSE;
					}
					_tmp6_ = _tmp9_;
				}
				if (!_tmp6_) {
					break;
				}
				_tmp13_ = i;
				_tmp14_ = str_array[_tmp13_];
				if (_tmp14_ != NULL) {
					gint _tmp15_;
					const gchar* _tmp16_;
					gint _tmp17_;
					gint _tmp18_;
					_tmp15_ = i;
					_tmp16_ = str_array[_tmp15_];
					_tmp17_ = strlen ((const gchar*) _tmp16_);
					_tmp18_ = _tmp17_;
					_tmp12_ = _tmp18_;
				} else {
					_tmp12_ = 0;
				}
				_tmp19_ = len;
				len = _tmp19_ + _tmp12_;
			}
		}
		_tmp20_ = i;
		if (_tmp20_ == 0) {
			gchar* _tmp21_;
			_tmp21_ = g_strdup ("");
			result = _tmp21_;
			return result;
		}
		_tmp22_ = i;
		str_array_length1 = _tmp22_;
		_tmp23_ = str_array_length1;
		_tmp24_ = len;
		_tmp25_ = strlen ((const gchar*) separator);
		_tmp26_ = _tmp25_;
		_tmp27_ = i;
		len = _tmp24_ + (_tmp26_ * (_tmp27_ - 1));
		_tmp28_ = len;
		_tmp29_ = g_malloc (_tmp28_);
		res = _tmp29_;
		_tmp30_ = res;
		_tmp31_ = str_array[0];
		_tmp32_ = g_stpcpy ((void*) _tmp30_, (const gchar*) _tmp31_);
		ptr = _tmp32_;
		{
			gboolean _tmp33_ = FALSE;
			i = 1;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_;
				void* _tmp36_;
				void* _tmp37_;
				const gchar* _tmp38_ = NULL;
				gint _tmp39_;
				const gchar* _tmp40_;
				void* _tmp43_;
				void* _tmp44_;
				if (!_tmp33_) {
					gint _tmp34_;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < str_array_length1)) {
					break;
				}
				_tmp36_ = ptr;
				_tmp37_ = g_stpcpy (_tmp36_, (const gchar*) separator);
				ptr = _tmp37_;
				_tmp39_ = i;
				_tmp40_ = str_array[_tmp39_];
				if (_tmp40_ != NULL) {
					gint _tmp41_;
					const gchar* _tmp42_;
					_tmp41_ = i;
					_tmp42_ = str_array[_tmp41_];
					_tmp38_ = (const gchar*) _tmp42_;
				} else {
					_tmp38_ = "";
				}
				_tmp43_ = ptr;
				_tmp44_ = g_stpcpy (_tmp43_, _tmp38_);
				ptr = _tmp44_;
			}
		}
		_tmp45_ = res;
		res = NULL;
		result = (gchar*) _tmp45_;
		return result;
	} else {
		gchar* _tmp46_;
		_tmp46_ = g_strdup ("");
		result = _tmp46_;
		return result;
	}
}


gchar*
valadoc_realpath (const gchar* name)
{
	gchar* result = NULL;
	gchar* rpath = NULL;
	const gchar* start = NULL;
	const gchar* end = NULL;
	glong root_len = 0L;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gboolean _tmp50_ = FALSE;
	const gchar* _tmp51_;
	gint _tmp52_;
	gint _tmp53_;
	glong _tmp54_;
	g_return_val_if_fail (name != NULL, NULL);
	if (!g_path_is_absolute (name)) {
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = g_get_current_dir ();
		_g_free0 (rpath);
		rpath = _tmp0_;
		end = name;
		_tmp1_ = end;
		start = _tmp1_;
	} else {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = g_path_skip_root (name);
		end = _tmp2_;
		_tmp3_ = end;
		start = _tmp3_;
		_tmp4_ = start;
		_tmp5_ = string_substring (name, (glong) 0, (glong) ((gint) (((gchar*) _tmp4_) - ((gchar*) name))));
		_g_free0 (rpath);
		rpath = _tmp5_;
	}
	_tmp6_ = rpath;
	_tmp7_ = g_path_skip_root (_tmp6_);
	_tmp8_ = rpath;
	root_len = (glong) (((gchar*) _tmp7_) - ((gchar*) _tmp8_));
	{
		gboolean _tmp9_ = FALSE;
		_tmp9_ = TRUE;
		while (TRUE) {
			const gchar* _tmp11_;
			glong len = 0L;
			glong _tmp23_;
			if (!_tmp9_) {
				const gchar* _tmp10_;
				_tmp10_ = end;
				start = _tmp10_;
			}
			_tmp9_ = FALSE;
			_tmp11_ = start;
			if (!(string_get_char (_tmp11_, (glong) 0) != ((gunichar) 0))) {
				break;
			}
			while (TRUE) {
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				const gchar* _tmp14_;
				_tmp12_ = start;
				if (!G_IS_DIR_SEPARATOR (string_get_char (_tmp12_, (glong) 0))) {
					break;
				}
				_tmp13_ = start;
				_tmp14_ = g_utf8_next_char (_tmp13_);
				start = _tmp14_;
			}
			len = (glong) 0;
			{
				const gchar* _tmp15_;
				gboolean _tmp16_ = FALSE;
				_tmp15_ = start;
				end = _tmp15_;
				_tmp16_ = TRUE;
				while (TRUE) {
					gboolean _tmp19_ = FALSE;
					const gchar* _tmp20_;
					glong _tmp22_;
					if (!_tmp16_) {
						const gchar* _tmp17_;
						const gchar* _tmp18_;
						_tmp17_ = end;
						_tmp18_ = g_utf8_next_char (_tmp17_);
						end = _tmp18_;
					}
					_tmp16_ = FALSE;
					_tmp20_ = end;
					if (string_get_char (_tmp20_, (glong) 0) != ((gunichar) 0)) {
						const gchar* _tmp21_;
						_tmp21_ = end;
						_tmp19_ = !G_IS_DIR_SEPARATOR (string_get_char (_tmp21_, (glong) 0));
					} else {
						_tmp19_ = FALSE;
					}
					if (!_tmp19_) {
						break;
					}
					_tmp22_ = len;
					len = _tmp22_ + 1;
				}
			}
			_tmp23_ = len;
			if (_tmp23_ == ((glong) 0)) {
				break;
			} else {
				gboolean _tmp24_ = FALSE;
				glong _tmp25_;
				_tmp25_ = len;
				if (_tmp25_ == ((glong) 1)) {
					const gchar* _tmp26_;
					_tmp26_ = start;
					_tmp24_ = string_get_char (_tmp26_, (glong) 0) == ((gunichar) '.');
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
				} else {
					gboolean _tmp27_ = FALSE;
					glong _tmp28_;
					_tmp28_ = len;
					if (_tmp28_ == ((glong) 2)) {
						const gchar* _tmp29_;
						_tmp29_ = start;
						_tmp27_ = g_str_has_prefix (_tmp29_, "..");
					} else {
						_tmp27_ = FALSE;
					}
					if (_tmp27_) {
						const gchar* _tmp30_;
						gint _tmp31_;
						gint _tmp32_;
						glong _tmp33_;
						_tmp30_ = rpath;
						_tmp31_ = strlen (_tmp30_);
						_tmp32_ = _tmp31_;
						_tmp33_ = root_len;
						if (((glong) _tmp32_) > _tmp33_) {
							{
								gboolean _tmp34_ = FALSE;
								_tmp34_ = TRUE;
								while (TRUE) {
									const gchar* _tmp36_;
									const gchar* _tmp37_;
									gint _tmp38_;
									gint _tmp39_;
									gchar* _tmp40_;
									if (!_tmp34_) {
										const gchar* _tmp35_;
										_tmp35_ = rpath;
										if (!(!valadoc_ends_with_dir_separator (_tmp35_))) {
											break;
										}
									}
									_tmp34_ = FALSE;
									_tmp36_ = rpath;
									_tmp37_ = rpath;
									_tmp38_ = strlen (_tmp37_);
									_tmp39_ = _tmp38_;
									_tmp40_ = string_substring (_tmp36_, (glong) 0, (glong) (_tmp39_ - 1));
									_g_free0 (rpath);
									rpath = _tmp40_;
								}
							}
						}
					} else {
						const gchar* _tmp41_;
						const gchar* _tmp44_;
						const gchar* _tmp45_;
						glong _tmp46_;
						gchar* _tmp47_;
						gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp41_ = rpath;
						if (!valadoc_ends_with_dir_separator (_tmp41_)) {
							const gchar* _tmp42_;
							gchar* _tmp43_;
							_tmp42_ = rpath;
							_tmp43_ = g_strconcat (_tmp42_, G_DIR_SEPARATOR_S, NULL);
							_g_free0 (rpath);
							rpath = _tmp43_;
						}
						_tmp44_ = rpath;
						_tmp45_ = start;
						_tmp46_ = len;
						_tmp47_ = string_substring (_tmp45_, (glong) 0, _tmp46_);
						_tmp48_ = _tmp47_;
						_tmp49_ = g_strconcat (_tmp44_, _tmp48_, NULL);
						_g_free0 (rpath);
						rpath = _tmp49_;
						_g_free0 (_tmp48_);
					}
				}
			}
		}
	}
	_tmp51_ = rpath;
	_tmp52_ = strlen (_tmp51_);
	_tmp53_ = _tmp52_;
	_tmp54_ = root_len;
	if (((glong) _tmp53_) > _tmp54_) {
		const gchar* _tmp55_;
		_tmp55_ = rpath;
		_tmp50_ = valadoc_ends_with_dir_separator (_tmp55_);
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		const gchar* _tmp56_;
		const gchar* _tmp57_;
		gint _tmp58_;
		gint _tmp59_;
		gchar* _tmp60_;
		_tmp56_ = rpath;
		_tmp57_ = rpath;
		_tmp58_ = strlen (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = string_substring (_tmp56_, (glong) 0, (glong) (_tmp59_ - 1));
		_g_free0 (rpath);
		rpath = _tmp60_;
	}
	if (G_DIR_SEPARATOR != '/') {
		gchar** components = NULL;
		const gchar* _tmp61_;
		gchar** _tmp62_;
		gchar** _tmp63_;
		gint components_length1;
		gint _components_size_;
		gchar** _tmp64_;
		gint _tmp64__length1;
		gchar* _tmp65_;
		_tmp61_ = rpath;
		_tmp63_ = _tmp62_ = g_strsplit (_tmp61_, "\\", 0);
		components = _tmp63_;
		components_length1 = _vala_array_length (_tmp62_);
		_components_size_ = components_length1;
		_tmp64_ = components;
		_tmp64__length1 = components_length1;
		_tmp65_ = _vala_g_strjoinv ("/", _tmp64_, _tmp64__length1);
		_g_free0 (rpath);
		rpath = _tmp65_;
		components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	}
	result = rpath;
	return result;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint
_vala_array_length (gpointer array)
{
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



